import { KycRule } from "@gnu-taler/taler-util";
import { useTranslationContext } from "@gnu-taler/web-util/browser";
import { Fragment, h, VNode } from "preact";
import { RulesInfo } from "./RulesInfo.js";

export function ShowDefaultRules({ rules }: { rules: KycRule[] }): VNode {
  const { i18n } = useTranslationContext();
  return (
    <Fragment>
      <h1 class="text-base font-semibold leading-6 text-black">
        <i18n.Translate>Default rules</i18n.Translate>
      </h1>
      <RulesInfo rules={rules} />
    </Fragment>
  );
}
