package Net::Amazon::EMR::JobFlowExecutionStatusDetail;
use Moose;
with 'Net::Amazon::EMR::Role::AttrHash';
use Net::Amazon::EMR::Coercions;
use Moose::Util::TypeConstraints;

has 'CreationDateTime' => ( is => 'ro', 
                            isa => 'Net::Amazon::EMR::Type::DateTime',
                            coerce => 1,
    );

has 'EndDateTime' => ( is => 'ro', 
                       isa => 'Net::Amazon::EMR::Type::DateTime',
                       coerce => 1,
    );

has 'LastStateChangeReason' => ( is => 'ro', 
                                 isa => 'Net::Amazon::EMR::Type::LongConstrainedStr',
                                 coerce => 1,
                             );

has 'ReadyDateTime' => ( is => 'ro', 
                         isa => 'Net::Amazon::EMR::Type::DateTime',
                         coerce => 1,
    );

has 'StartDateTime' => ( is => 'ro', 
                         isa => 'Net::Amazon::EMR::Type::DateTime',
                         coerce => 1,
    );

subtype 'Net::Amazon::EMR::Type::JobFlowExecutionStatusDetail::State' => as 'Str' => where { m/^(?:STARTING | BOOTSTRAPPING | RUNNING | WAITING | SHUTTING_DOWN | TERMINATED | COMPLETED | FAILED)$/x };

has 'State' => ( is => 'ro',
                 isa => 'Net::Amazon::EMR::Type::JobFlowExecutionStatusDetail::State',
                 required => 1,
             );

__PACKAGE__->meta->make_immutable();

1;

__END__

=head1 NAME

Net::Amazon::EMR::JobFlowExecutionStatusDetail

=head1 DESCRIPTION

Implements the JobFlowExecutionStatusDetail data type described at L<http://docs.amazonwebservices.com/ElasticMapReduce/latest/APIReference/API_JobFlowExecutionStatusDetail.html>.

=head1 AUTHOR

Jon Schutz 

L<http://notes.jschutz.net>

=head1 DOCUMENTATION, LICENSE AND COPYRIGHT

See L<Net::Amazon::EMR>.

=cut
