package Toolforge::MixNMatch::Print;

use strict;
use warnings;

our $VERSION = 0.04;

1;

__END__

=pod

=encoding utf8

=head1 NAME

Toolforge::MixNMatch::Print - Toolforge Mix'n'match tool object print routines.

=head1 DESCRIPTION

This distributions is set of print routins for objects from Toolforge Mix'n'match tool
(https://mix-n-match.toolforge.org/).

=head1 SEE ALSO

=over

=item L<Toolforge::MixNMatch::Print::Catalog>

Mix'n'match user structure print.

=item L<Toolforge::MixNMatch::Print::User>

Mix'n'match user structure print.

=item L<Toolforge::MixNMatch::Print::YearMonth>

Mix'n'match year/month structure print.

=back

=head1 REPOSITORY

L<https://github.com/michal-josef-spacek/Toolforge-MixNMatch-Print>

=head1 AUTHOR

Michal Josef Špaček L<mailto:skim@cpan.org>

L<http://skim.cz>

=head1 LICENSE AND COPYRIGHT

© Michal Josef Špaček 2020

BSD 2-Clause License

=head1 VERSION

0.04

=cut
