package Stepford::Planner;

use strict;
use warnings;
use namespace::autoclean;

our $VERSION = '0.003009';

use Carp qw( carp );

use Moose;

extends 'Stepford::Runner';

override new => sub {

    # Needed to escape modifier caller.
    ## no critic (Variables::ProhibitPackageVars)
    local $Carp::CarpLevel = $Carp::CarpLevel + 1;
    carp
        'The Stepford::Planner class has been renamed to Stepford::Runner - use Stepford::Runner';
    return super;
};

__PACKAGE__->meta->make_immutable( inline_constructor => 0 );

1;

# ABSTRACT: Renamed to Stepford::Runner

__END__

=pod

=head1 NAME

Stepford::Planner - Renamed to Stepford::Runner

=head1 VERSION

version 0.003009

=head1 DESCRIPTION

This class has been renamed to Stepford::Runner. Use that instead.

=for Pod::Coverage .*

=head1 AUTHOR

Dave Rolsky <drolsky@maxmind.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by MaxMind, Inc.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
