use strict;
use warnings;
use ExtUtils::MakeMaker;

WriteMakefile(
    NAME                => 'PerlVision',
    AUTHOR              => q{Ashish Gulhati <perlvision at hash.neo.email>},
    VERSION_FROM        => 'lib/PV.pm',
    ABSTRACT_FROM       => 'lib/PV.pm',
    ($ExtUtils::MakeMaker::VERSION >= 6.3002
      ? ('LICENSE'=> 'unrestricted')
      : ()),
    PL_FILES            => {},
    PREREQ_PM => {
        'Test::More' => 0,
        'Curses' => 1.45,
    },
    META_MERGE          => {
	provides => {
			'PV' => { file => 'lib/PV.pm' },
			'PV::Checkbox' => { file => 'lib/PV.pm' },
			'PV::Cutebutton' => { file => 'lib/PV.pm' },
			'PV::Dialog' => { file => 'lib/PV.pm' },
			'PV::Editbox' => { file => 'lib/PV.pm' },
			'PV::Entryfield' => { file => 'lib/PV.pm' },
			'PV::Listbox' => { file => 'lib/PV.pm' },
			'PV::Menubar' => { file => 'lib/PV.pm' },
			'PV::Mlistbox' => { file => 'lib/PV.pm' },
			'PV::PVD' => { file => 'lib/PV.pm' },
			'PV::Password' => { file => 'lib/PV.pm' },
			'PV::Plainbutton' => { file => 'lib/PV.pm' },
			'PV::Pushbutton' => { file => 'lib/PV.pm' },
			'PV::Radio' => { file => 'lib/PV.pm' },
			'PV::RadioG' => { file => 'lib/PV.pm' },
			'PV::Static' => { file => 'lib/PV.pm' },
			'PV::Viewbox' => { file => 'lib/PV.pm' },
		    }
    },
    dist                => { COMPRESS => 'gzip -9f', SUFFIX => 'gz', },
    clean               => { FILES => 'PerlVision-*' },
);
