/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.conn;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Properties;
import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.CacheFactory;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.cache.CacheableFactory;
import org.apache.derby.iapi.services.compiler.JavaFactory;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyFactory;
import org.apache.derby.iapi.services.property.PropertySetCallback;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.LanguageFactory;
import org.apache.derby.iapi.sql.Statement;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.NodeFactory;
import org.apache.derby.iapi.sql.compile.OptimizerFactory;
import org.apache.derby.iapi.sql.compile.Parser;
import org.apache.derby.iapi.sql.compile.TypeCompilerFactory;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionFactory;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.GenericStatement;
import org.apache.derby.impl.sql.compile.ParserImpl;
import org.apache.derby.impl.sql.conn.CachedStatement;
import org.apache.derby.impl.sql.conn.GenericLanguageConnectionContext;

public class GenericLanguageConnectionFactory
implements LanguageConnectionFactory,
CacheableFactory,
PropertySetCallback,
ModuleControl,
ModuleSupportable {
    protected DataDictionary dd;
    private ExecutionFactory ef;
    private OptimizerFactory of;
    private TypeCompilerFactory tcf;
    private DataValueFactory dvf;
    private UUIDFactory uuidFactory;
    private JavaFactory javaFactory;
    private ClassFactory classFactory;
    private NodeFactory nodeFactory;
    private AccessFactory af;
    private PropertyFactory pf;
    private int nextLCCInstanceNumber;
    private int cacheSize = 100;
    private CacheManager singleStatementCache;

    public Statement getStatement(SchemaDescriptor schemaDescriptor, String string) {
        return new GenericStatement(schemaDescriptor, string);
    }

    public LanguageConnectionContext newLanguageConnectionContext(ContextManager contextManager, TransactionController transactionController, LanguageFactory languageFactory, Database database, String string, String string2, String string3) throws StandardException {
        this.pushDataDictionaryContext(contextManager);
        return new GenericLanguageConnectionContext(contextManager, transactionController, languageFactory, this, database, string, this.getNextLCCInstanceNumber(), string2, string3);
    }

    public Cacheable newCacheable(CacheManager cacheManager) {
        return new CachedStatement();
    }

    public UUIDFactory getUUIDFactory() {
        return this.uuidFactory;
    }

    public ClassFactory getClassFactory() {
        return this.classFactory;
    }

    public JavaFactory getJavaFactory() {
        return this.javaFactory;
    }

    public NodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    public ExecutionFactory getExecutionFactory() {
        return this.ef;
    }

    public AccessFactory getAccessFactory() {
        return this.af;
    }

    public PropertyFactory getPropertyFactory() {
        return this.pf;
    }

    public OptimizerFactory getOptimizerFactory() {
        return this.of;
    }

    public TypeCompilerFactory getTypeCompilerFactory() {
        return this.tcf;
    }

    public DataValueFactory getDataValueFactory() {
        return this.dvf;
    }

    protected void pushDataDictionaryContext(ContextManager contextManager) {
        this.dd.pushDataDictionaryContext(contextManager, false);
    }

    public boolean canSupport(Properties properties) {
        return Monitor.isDesiredType(properties, 2);
    }

    private int statementCacheSize(Properties properties) {
        String string = null;
        string = PropertyUtil.getPropertyFromSet(properties, "derby.language.statementCacheSize");
        if (string != null) {
            try {
                this.cacheSize = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.cacheSize = 100;
            }
        }
        return this.cacheSize;
    }

    public void boot(boolean bl, Properties properties) throws StandardException {
        this.dvf = (DataValueFactory)Monitor.bootServiceModule(bl, this, "org.apache.derby.iapi.types.DataValueFactory", properties);
        this.javaFactory = (JavaFactory)Monitor.startSystemModule("org.apache.derby.iapi.services.compiler.JavaFactory");
        this.uuidFactory = Monitor.getMonitor().getUUIDFactory();
        this.classFactory = (ClassFactory)Monitor.getServiceModule(this, "org.apache.derby.iapi.services.loader.ClassFactory");
        if (this.classFactory == null) {
            this.classFactory = (ClassFactory)Monitor.findSystemModule("org.apache.derby.iapi.services.loader.ClassFactory");
        }
        this.bootDataDictionary(bl, properties);
        this.setValidation();
        this.setStore();
        this.ef = (ExecutionFactory)Monitor.bootServiceModule(bl, this, "org.apache.derby.iapi.sql.execute.ExecutionFactory", properties);
        this.of = (OptimizerFactory)Monitor.bootServiceModule(bl, this, "org.apache.derby.iapi.sql.compile.OptimizerFactory", properties);
        this.tcf = (TypeCompilerFactory)Monitor.startSystemModule("org.apache.derby.iapi.sql.compile.TypeCompilerFactory");
        this.nodeFactory = (NodeFactory)Monitor.bootServiceModule(bl, this, "org.apache.derby.iapi.sql.compile.NodeFactory", properties);
        int n = this.statementCacheSize(properties);
        if (n > 0) {
            CacheFactory cacheFactory = (CacheFactory)Monitor.startSystemModule("org.apache.derby.iapi.services.cache.CacheFactory");
            this.singleStatementCache = cacheFactory.newCacheManager(this, "StatementCache", n / 4, n);
        }
    }

    protected void bootDataDictionary(boolean bl, Properties properties) throws StandardException {
        this.dd = (DataDictionary)Monitor.bootServiceModule(bl, this, "org.apache.derby.iapi.sql.dictionary.DataDictionary", properties);
    }

    public CacheManager getStatementCache() {
        return this.singleStatementCache;
    }

    public void stop() {
    }

    public void init(boolean bl, Dictionary dictionary) {
    }

    public boolean validate(String string, Serializable serializable, Dictionary dictionary) throws StandardException {
        if (serializable == null) {
            return true;
        }
        if (string.equals("derby.database.defaultConnectionMode")) {
            String string2 = (String)((Object)serializable);
            if (!(string2 == null || StringUtil.SQLEqualsIgnoreCase(string2, "noAccess") || StringUtil.SQLEqualsIgnoreCase(string2, "readOnlyAccess") || StringUtil.SQLEqualsIgnoreCase(string2, "fullAccess"))) {
                throw StandardException.newException("28501", string, (Object)string2);
            }
            return true;
        }
        if (string.equals("derby.database.readOnlyAccessUsers") || string.equals("derby.database.fullAccessUsers")) {
            String[] stringArray;
            String string3 = (String)((Object)serializable);
            try {
                stringArray = IdUtil.parseIdList(string3);
            }
            catch (StandardException standardException) {
                throw StandardException.newException("28501", string, (Object)string3, (Object)standardException);
            }
            String string4 = IdUtil.dups(stringArray);
            if (string4 != null) {
                throw StandardException.newException("28504", string, (Object)string4);
            }
            String string5 = string.equals("derby.database.readOnlyAccessUsers") ? (String)dictionary.get("derby.database.fullAccessUsers") : (String)dictionary.get("derby.database.readOnlyAccessUsers");
            String[] stringArray2 = IdUtil.parseIdList(string5);
            String string6 = IdUtil.intersect(stringArray, stringArray2);
            if (string6 != null) {
                throw StandardException.newException("28503", string6);
            }
            return true;
        }
        return false;
    }

    public Serviceable apply(String string, Serializable serializable, Dictionary dictionary) {
        return null;
    }

    public Serializable map(String string, Serializable serializable, Dictionary dictionary) {
        return null;
    }

    protected void setValidation() throws StandardException {
        this.pf = (PropertyFactory)Monitor.findServiceModule(this, "org.apache.derby.iapi.services.property.PropertyFactory");
        this.pf.addPropertySetNotification(this);
    }

    protected void setStore() throws StandardException {
        this.af = (AccessFactory)Monitor.findServiceModule(this, "org.apache.derby.iapi.store.access.AccessFactory");
    }

    public Parser newParser(CompilerContext compilerContext) {
        return new ParserImpl(compilerContext);
    }

    protected synchronized int getNextLCCInstanceNumber() {
        return this.nextLCCInstanceNumber++;
    }
}

