use Test;
BEGIN { plan(tests => 2) }

use Net::Routing::Darwin;

my $lines4 = [
   "Routing tables",
   "",
   "Internet:",
   "Destination        Gateway            Flags        Refs      Use   Netif Expire",
   "default            10.64.64.64        UGSc           21        0    ppp0",
   "default            link#4             UCSI            0        0     en0",
   "default            10.1.1.1          UGScI           0        0     en1",
   "10.1.1/24         link#5             UCS             6        0     en1",
   "192.168.1         10.1.1.1          UGSc            0        0     en1",
];
my $route4 =  {
   '0.0.0.0/0|10.64.64.64|ppp0|1|0' => 1,
   '0.0.0.0/0|0.0.0.0|en0|1|1' => 1,
   '0.0.0.0/0|10.1.1.1|en1|1|0' => 1,
   '10.1.1.0/24|0.0.0.0|en1|0|1' => 1,
   '192.168.1.0/24|10.1.1.1|en1|0|0' => 1,
};
my $route4_count = keys %$route4;

my $lines6 = [
];
my $route6 = {
};
my $route6_count = keys %$route6;

sub _to_psv {
   my ($r) = @_;
   return $r->{route}.'|'.$r->{gateway}.'|'.$r->{interface}.'|'.
      (exists($r->{default})?'1':'0').'|'.(exists($r->{local})?'1':'0');
}

sub default_route4 {
   my $routes = Net::Routing::Darwin->_get_inet4($lines4);

   my $count = @$routes;
   if ($count != $route4_count) {
      die("Invalid number of IPv4 routes: $count instead of $route4_count\n");
   }

   for my $route (@$routes) {
      my $psv = _to_psv($route);
      if (! exists($route4->{$psv})) {
         die("Invalid IPv4 route: $psv\n");
      }
   }

   return 1;
}

sub default_route6 {
   my $routes = Net::Routing::Darwin->_get_inet6($lines6);

   my $count = @$routes;
   if ($count != $route6_count) {
      die("Invalid number of IPv6 routes: $count instead of $route6_count\n");
   }

   for my $route (@$routes) {
      my $psv = _to_psv($route);
      if (! exists($route6->{$psv})) {
         die("Invalid IPv6 route: $psv\n");
      }
   }

   return 1;
}

ok(
   sub { eval { default_route4() }; return $@ ? 0 : 1 },
   1,
   $@,
);

ok(
   sub { eval { default_route6() }; return $@ ? 0 : 1 },
   1,
   $@,
);
