# automatically generated file, don't edit



# Copyright 2025 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::KZ;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20251210153523;

my $formatters = [];

my $validators = {
                'fixed_line' => '
          (?:
            33622|
            7(?:
              1(?:
                0(?:
                  [23]\\d|
                  4[0-3]|
                  59|
                  63
                )|
                1(?:
                  [23]\\d|
                  4[0-79]|
                  59
                )|
                2(?:
                  [23]\\d|
                  59
                )|
                3(?:
                  2\\d|
                  3[0-79]|
                  4[0-35-9]|
                  59
                )|
                4(?:
                  [24]\\d|
                  3[013-9]|
                  5[1-9]|
                  97
                )|
                5(?:
                  2\\d|
                  3[1-9]|
                  4[0-7]|
                  59
                )|
                6(?:
                  [2-4]\\d|
                  5[19]|
                  61
                )|
                72\\d|
                8(?:
                  [27]\\d|
                  3[1-46-9]|
                  4[0-5]|
                  59
                )
              )|
              2(?:
                1(?:
                  [23]\\d|
                  4[46-9]|
                  5[3469]
                )|
                2(?:
                  2\\d|
                  3[0679]|
                  46|
                  5[12679]
                )|
                3(?:
                  [2-4]\\d|
                  5[139]
                )|
                4(?:
                  2\\d|
                  3[1-35-9]|
                  59
                )|
                5(?:
                  [23]\\d|
                  4[0-8]|
                  59|
                  61
                )|
                6(?:
                  2\\d|
                  3[1-9]|
                  4[0-4]|
                  59
                )|
                7(?:
                  [2379]\\d|
                  40|
                  5[279]
                )|
                8(?:
                  [23]\\d|
                  4[0-3]|
                  59
                )|
                9(?:
                  2\\d|
                  3[124578]|
                  59
                )
              )
            )
          )\\d{5}
        ',
                'geographic' => '
          (?:
            33622|
            7(?:
              1(?:
                0(?:
                  [23]\\d|
                  4[0-3]|
                  59|
                  63
                )|
                1(?:
                  [23]\\d|
                  4[0-79]|
                  59
                )|
                2(?:
                  [23]\\d|
                  59
                )|
                3(?:
                  2\\d|
                  3[0-79]|
                  4[0-35-9]|
                  59
                )|
                4(?:
                  [24]\\d|
                  3[013-9]|
                  5[1-9]|
                  97
                )|
                5(?:
                  2\\d|
                  3[1-9]|
                  4[0-7]|
                  59
                )|
                6(?:
                  [2-4]\\d|
                  5[19]|
                  61
                )|
                72\\d|
                8(?:
                  [27]\\d|
                  3[1-46-9]|
                  4[0-5]|
                  59
                )
              )|
              2(?:
                1(?:
                  [23]\\d|
                  4[46-9]|
                  5[3469]
                )|
                2(?:
                  2\\d|
                  3[0679]|
                  46|
                  5[12679]
                )|
                3(?:
                  [2-4]\\d|
                  5[139]
                )|
                4(?:
                  2\\d|
                  3[1-35-9]|
                  59
                )|
                5(?:
                  [23]\\d|
                  4[0-8]|
                  59|
                  61
                )|
                6(?:
                  2\\d|
                  3[1-9]|
                  4[0-4]|
                  59
                )|
                7(?:
                  [2379]\\d|
                  40|
                  5[279]
                )|
                8(?:
                  [23]\\d|
                  4[0-3]|
                  59
                )|
                9(?:
                  2\\d|
                  3[124578]|
                  59
                )
              )
            )
          )\\d{5}
        ',
                'mobile' => '
          7(?:
            0[0-25-8]|
            47|
            6[0-4]|
            7[15-8]|
            85
          )\\d{7}
        ',
                'pager' => '',
                'personal_number' => '808\\d{7}',
                'specialrate' => '(809\\d{7})',
                'toll_free' => '
          8(?:
            00|
            108\\d{3}
          )\\d{7}
        ',
                'voip' => '751\\d{7}'
              };
my %areanames = ();
$areanames{en} = {"7382", "Tomsk",
"772347", "Kalbatau",
"771032", "Karazhal",
"771043", "Zhairem",
"771040", "Zhairem\ \(GOK\)",
"7812", "St\ Petersburg",
"772544", "Shaulder",
"7342", "Perm",
"7867", "Republic\ of\ North\ Ossetia",
"7351", "Chelyabinsk",
"771039", "Priozersk",
"771144", "Kaztalovka",
"771635", "Zhaksy",
"77213", "Aktau\/Temirtau",
"772934", "Zhanaozen",
"7860", "Kherson\ Region",
"771435", "Zhitikara",
"7863", "Rostov",
"772239", "Makanchi",
"772346", "Aksuat",
"771231", "Akkystau",
"771339", "Komsomolskoye",
"77149", "Kostanai",
"772331", "Glubokoye",
"7833", "Kirov",
"772153", "Topar",
"771453", "Auliekol",
"771343", "Irgiz",
"771340", "Khobdinsky\ District",
"771535", "Novoishimski",
"772938", "Fort\ Shevchenko",
"7481", "Smolensk",
"7301", "Republic\ of\ Buryatia",
"771332", "Uil",
"772548", "Shayan",
"772644", "Karatau",
"7471", "Kursk",
"7820", "Cherepovets",
"772137", "Saran",
"7427", "Chukotka\ Autonomous\ District",
"771636", "Shuchinsk",
"771841", "Aktogai",
"772759", "Almaty\ Region",
"771836", "Sharbakty",
"771537", "Timiryazevo",
"7871", "Chechen\ Republic",
"771641", "Astrakhanka",
"771038", "Shashubai",
"740", "Kaliningrad",
"772633", "Asa",
"772752", "Otegen\ Batyra",
"77162", "Kokshetau\/Krasni\ Yar",
"772842", "Kogaly",
"7498", "Moscow",
"7349", "Yamalo\-Nenets\ Autonomous\ District",
"77245", "Kyzylorda\ Region",
"772833", "Usharal",
"771334", "Emba",
"772830", "Alakolsky\ District",
"772771", "Kaskelen",
"771437", "Kamysty",
"772642", "Moiynkum",
"7496", "Moscow",
"7841", "Penza",
"77182", "Pavlodar",
"771541", "Mamlutka",
"7494", "Kostroma",
"771637", "Korgalzhyn",
"771034", "Zhezdy",
"77274", "Karassaisky\ District",
"771149", "Zelenovsky\ District",
"772433", "Aralsk",
"77142", "Kostanai",
"771536", "Taiynsha",
"771837", "Aksu",
"77212", "Karaganda",
"772542", "Asykata",
"7495", "Moscow",
"7390", "Republic\ of\ Khakassia",
"771130", "Peremetnoye",
"77187", "Ekibastuz",
"771441", "Karabalyk",
"771133", "Aksai",
"7423", "Primorie\ territory",
"771142", "Taipak",
"77152", "Petropavlovsk",
"771436", "Taranovskoye",
"772932", "Beineu",
"772345", "Shar",
"772530", "Temirlanovka",
"772251", "Kurchatov",
"772533", "Turkestan",
"771543", "Yavlenka",
"771540", "Kishkenekol",
"771335", "Shalkar",
"772132", "Nurinsky\ District",
"7302", "Chita",
"7482", "Tver",
"771439", "Torgai",
"77292", "Aktau",
"772431", "Zhalagash",
"7834", "Republic\ of\ Mordovia",
"771532", "Smirnovo",
"7472", "Belgorod",
"772348", "Kokpekty",
"772546", "Sholakkorgan",
"772757", "Akshi",
"77272983", "Kaskelen",
"77106", "Satpaev",
"771443", "Borovskoi",
"771131", "Darinskoye",
"7865", "Stavropol\ territory",
"771440", "Amangeldy",
"771146", "Akzhaiksky\ District",
"7835", "Chuvashi\ Republic",
"771539", "Beskol",
"772531", "Aksukent",
"7341", "Udmurtian\ Republic",
"771632", "Zerenda",
"771840", "Bayanaul",
"7352", "Kurgan",
"772344", "Akzhar",
"771843", "Maisky\ District",
"771832", "Irtyshsk",
"771643", "Atbasar",
"771640", "Balkashino",
"7879", "Mineranye\ Vody",
"771639", "Stepnyak",
"7381", "Omsk",
"7712302", "Tengizshevroil",
"772631", "Kulan",
"7836", "Republic\ of\ Marij\ El",
"772547", "Lenger",
"772770", "Uzynagash",
"772831", "Zharkent",
"772937", "Kuryk",
"771839", "Akku",
"7866", "Kabardino\-Balkarian\ Republic",
"772773", "Bakanas",
"771035", "Ulytau",
"7811", "Pskov",
"771147", "Akzhaiksky\ District",
"771037", "Aktogai",
"77222", "Semey",
"771145", "Karatobe\ District",
"771538", "Beskol",
"771230", "Atyrau\ Region",
"772342", "Katon\-Karagai",
"772935", "Zhetybai",
"771233", "Ganyushkino",
"771834", "Uspenka",
"772545", "Ikan",
"772330", "Zyryanovsky\ District",
"7411", "Republic\ of\ Sakha",
"772333", "Samarskoye",
"77132", "Aktobe\/Kargalinskoye",
"772138", "Gabidena\ Mustafina",
"771438", "Amangeldy",
"771451", "Sarykol",
"771341", "Khobda",
"7424", "Sakhalin\ Region",
"772236", "Beskaragai",
"771336", "Khromtau",
"771838", "Koktobe",
"771036", "Balkhash",
"771638", "Akkol",
"771041", "Aktau\,\ Zhezkazgan",
"7851", "Astrakhan",
"771651", "Kabanbai\ Batyr",
"7394", "Republic\ of\ Tuva",
"771534", "Sergeyevka",
"7842", "Ulyanovsk",
"7426", "Jewish\ Autonomous\ Region",
"77102", "Zhezkazgan",
"772237", "Ayagoz",
"77125", "Atyrau\ Region",
"7395", "Irkutsk",
"7872", "Republic\ of\ Daghestan",
"771434", "Denisovka",
"771337", "Alga",
"772774", "Talgar",
"771331", "Martuk",
"7347", "Republic\ of\ Bashkortostan",
"772339", "Kurchum",
"7862", "Sochi",
"771448", "Oktyabrskoye",
"7474", "Lipetsk",
"772435", "Zhanakorgan",
"771456", "Kachar",
"7712303", "Tengizs",
"7484", "Kaluga",
"771239", "Makat",
"771346", "Shubarkuduk",
"772332", "Shemonaikha",
"771135", "Zhanibek",
"772156", "Shakhtinsk",
"771644", "Arshaly",
"772148", "Molodezhnoye",
"7485", "Yaroslavl",
"772340", "Zaisan",
"771232", "Atyrau\ Region",
"7475", "Tambov",
"772535", "Shardara",
"771844", "Irtyshsky\ District",
"772343", "Terekty",
"7817", "Vologda",
"7383", "Novosibirsk",
"771347", "Aitekebisky\ District",
"7813", "Leningrad\ region",
"772778", "Chundzha",
"771457", "Dzhangildinsky\ District",
"771444", "Uzunkol",
"772635", "Bauyrzhan\ Mamyshuly",
"772144", "Kiyevka",
"7343", "Ekaterinburg",
"7486", "Orel",
"772835", "Tekeli",
"771544", "Presnovka",
"771031", "Aksu\-Ayuly",
"771648", "Derzhavinsk",
"772149", "Osakarovka",
"771433", "Lisakovsk",
"77185", "Shaldai",
"771430", "Arkalyk",
"771141", "Zhangala",
"772536", "Kentau",
"772252", "Karaul",
"772837", "Kabanbai",
"77242", "Kyzylorda",
"772931", "Shetpe",
"7857", "Luhansk\ People\'s\ Republic",
"772541", "Myrzakent",
"771136", "Chapayev",
"7869", "Sevastopol",
"7878", "Karachayevo\-Cherkessian\ Republic",
"771442", "Fyodorovka",
"772637", "Sarykemer",
"7846", "Samara",
"771455", "Zatobolsk",
"772436", "Terenozek",
"7491", "Ryazan",
"77252", "Shymkent",
"771533", "Saumalkol",
"771345", "Karauylkeldy",
"771238", "Miyaly",
"772351", "Borodulikha",
"772338", "Bozanbai\/Molodezhnyi",
"77112", "Uralsk",
"771542", "Kishkenekol",
"7848", "Tolyatti",
"771449", "Taranovskoye",
"7413", "Magadan",
"772772", "Kapchagai",
"772836", "Karabulak",
"772537", "Saryagash",
"77272956", "Talgar",
"771649", "Zhaksynsky\ District",
"772641", "Akkol",
"7844", "Volgograd",
"772636", "Kordai",
"771137", "Chingirlau",
"772841", "Kapal",
"772334", "Tavricheskoye",
"772779", "Narynkol",
"771833", "Terenkol",
"77282", "Taldykorgan",
"772437", "Zhosaly",
"771642", "Egendykol",
"77224", "Barshatas",
"771633", "Ereimentau",
"771630", "Burabay",
"771842", "Koktobe",
"771234", "Indernborski",
"7845", "Saratov",
"77262", "Taraz",
"772776", "Shelek",
"7345", "Tyumen",
"772257", "Shulbinsk",
"7353", "Orenburg",
"772832", "Zhansugurov",
"772640", "Moiynkumsky\ District",
"772643", "Shu",
"7384", "Kemerovo",
"7814", "Republic\ of\ Karelia",
"772632", "Merke",
"771447", "Karabalyksky\ District",
"771454", "Karamendy",
"772843", "Lepsy",
"772840", "Saryozek",
"772839", "Sarkand",
"7385", "Altai\ Territory",
"771831", "Zhelezinka",
"77279", "Almaty",
"7821", "Komi\ Republic",
"772154", "Botakara",
"772147", "Egindybulak",
"771646", "Makinsk",
"7487", "Tula",
"771631", "Shortandy",
"772639", "Saudakent",
"771547", "Zhambylsky\ District",
"7815", "Murmansk",
"771431", "Rudny",
"771140", "Saikhin",
"771143", "Akzhaik",
"772439", "Aralsky\ District",
"771458", "Kostanai\ Region",
"772532", "Abai",
"772256", "Kainar",
"771235", "Dossor",
"771348", "Shalkarsky\ District",
"772777", "Kegen",
"772540", "Arys",
"772335", "Zyryanovsk",
"7473", "Voronezh",
"7499", "Moscow",
"736", "Simferopol",
"772543", "Aqsumbe",
"771132", "Fyodorovka",
"7346", "Surgut",
"771446", "Uzunkolsky\ District",
"7483", "Bryansk",
"7816", "Veliky\ Novgorod",
"772432", "Shiyeli",
"771647", "Esil",
"772146", "Karkaralinsk",
"7388", "Republic\ of\ Altai",
"7861", "Krasnodar\ Territory",
"771531", "Bulayevo",
"772539", "Kazygurt",
"772353", "Novaya\ Shulba",
"7818", "Arkhangelsk",
"7831", "Nizhni\ Novgorod",
"771546", "Talshik",
"772131", "Abai",
"77273", "Almaty",
"771139", "Taskala",
"77145834", "Krasnogorsk",
"772638", "Tole\ bi",
"772534", "Zhetysai",
"7416", "Amur\ Region",
"771845", "Pavlodar\ Area",
"772838", "Balpyk\ bi",
"7843", "Republic\ of\ Tatarstan",
"7855", "Naberezhnye\ Chelny",
"771134", "Zhympity",
"771645", "Stepnogorsk",
"77272", "Almaty",
"771042", "Zharyk",
"77135", "Aktobe\ Region",
"772337", "Serebryansk",
"772775", "Esik",
"7717", "Astana",
"771237", "Kulsary",
"7391", "Krasnoyarsk\ Territory",
"771033", "Agadyr",
"7873", "Ingushi\ Republic",
"771030", "Atasu",
"7421", "Khabarovsk\ Territory",
"771333", "Kandyagash",
"7492", "Vladimir",
"772834", "Ushtobe",
"771545", "Zhambylsky\ District",
"771330", "Khromtau\ District",
"7856", "Donetsk\ People\'s\ Republic",
"77232", "Ust\-Kamenogorsk",
"772159", "Karaganda\ Region",
"771138", "Zhalpaktal",
"772634", "Zhanatas",
"771452", "Karasu",
"7415", "Kamchatka\ Region",
"7877", "Republic\ of\ Adygeya",
"77122", "Atyrau",
"772538", "Turara\ Ryskulova",
"772230", "Urdzhar",
"771342", "Badamsha",
"772336", "Ridder",
"772725", "Otegen\ Batyra",
"733622", "Baikonur",
"771445", "Ubaganskoye",
"772438", "Aiteke\ bi",
"771459", "Kostanai\ Region",
"771236", "Makhambet",
"771349", "Shalkarsky\ District",
"7847", "Republic\ of\ Kalmykia",
"772341", "Ulken\ Naryn",};
$areanames{ru} = {"771343", "Иргизский\ р\-н",
"771535", "Габита\ Мусрепова\ р\-н",
"771340", "Хобдинский\ р\-н",
"772938", "Тупкараганский\ р\-н",
"771453", "Аулиекольский\ р\-н",
"772644", "Таласский\ р\-н",
"7820", "Вологодская\ обл\.",
"7471", "Курская\ обл\.",
"7301", "Республика\ Бурятия",
"7481", "Смоленская\ обл\.",
"772548", "Шаян",
"771332", "Уилский\ р\-н",
"772346", "Тарбагатайский\ р\-н",
"772239", "Урджарский\ р\-н",
"771231", "Исатайский\ р\-н",
"7863", "Ростовская\ обл\.",
"771435", "Житикаринский\ р\-н",
"7833", "Кировская\ обл\.",
"772153", "Абайский\ р\-н",
"771339", "Айтекебийский\ р\-н",
"77149", "Костанай",
"772331", "Глубоковский\ р\-н",
"7867", "Республика\ Северная\ Осетия\ \-\ Алания",
"771039", "Приозерск",
"7351", "Челябинская\ обл\.",
"772544", "Шаульдер",
"7342", "Пермский\ край",
"77213", "Темиртау",
"772934", "Жанаозен",
"7860", "Херсонская\ область",
"771144", "Казталовский\ р\-н",
"771635", "Жаксынский\ р\-н",
"771032", "Каражал",
"7382", "Томская\ обл\.",
"772347", "Жарминский\ р\-н",
"7812", "г\.\ Санкт\-Петербург",
"771043", "Жайрем\ \(поселок\)",
"771040", "Жайрем\ \(ГОК\)",
"77187", "Экибастуз",
"771130", "Зеленовский\ р\-н",
"771441", "Карабалыкский\ р\-н",
"771133", "Бурлинский\ р\-н",
"7423", "Приморский\ край",
"772542", "Асыката",
"77212", "Караганда",
"7390", "Республика\ Хакасия",
"7495", "Московская\ обл\.",
"772932", "Бейнеуский\ р\-н",
"772530", "Темирлановка",
"772345", "Жарминский\ р\-н",
"772251", "Курчатов",
"772533", "Туркестан",
"77152", "Петропавловск",
"771142", "Акжаикский\ р\-н",
"771436", "Тарановский\ р\-н",
"7494", "Костромская\ обл\.",
"771637", "Коргалжынский\ р\-н",
"771034", "Улытауский\ р\-н",
"771541", "Мамлютский\ р\-н",
"77142", "Костанай",
"771536", "Тайыншинский\ р\-н",
"771837", "Аксуский\ р\-н",
"77274", "Карасайский\ р\-н",
"772433", "Аральский\ р\-н",
"771149", "Акжаикский\ р\-н",
"772752", "Илийский\ р\-н",
"77162", "Кокшетау",
"772842", "Кербулакский\ р\-н",
"7498", "Московская\ обл\.",
"740", "Калининградская\ обл\.",
"772633", "Жамбылский\ р\-н",
"772642", "Мойынкумский\ р\-н",
"771437", "Камыстинский\ р\-н",
"7496", "г\.\ Москва",
"7841", "Пензенская\ обл\.",
"77182", "Павлодар",
"77245", "Кызылординская\ область",
"7349", "Ямало\-Ненецкий\ АО",
"772833", "Алакольский\ р\-н",
"771334", "Мугалжарский\ р\-н",
"772771", "Карасайский\ р\-н",
"772830", "Алакольский\ р\-н",
"771841", "Актогайский\ р\-н",
"772759", "Алматинская\ область",
"772137", "Сарань",
"7427", "Чукотский\ АО",
"771636", "Щучинский\ р\-н",
"771641", "Астраханский\ р\-н",
"771038", "Сыры\-Шаган",
"771836", "Щербактинский\ р\-н",
"771537", "Тимирязевский\ р\-н",
"7871", "Республика\ Чеченская",
"7836", "Республика\ Марий\ Эл",
"772547", "Ленгер",
"771639", "Енбекшилдерский\ р\-н",
"7879", "Ставропольский\ край",
"7712302", "Тенгизшевройл",
"7381", "Омская\ обл\.",
"772631", "Турара\ Рыскулова\ р\-н",
"771147", "Акжаикский\ р\-н",
"7811", "Псковская\ обл\.",
"771035", "Улытауский\ р\-н",
"772831", "Панфиловский\ р\-н",
"772770", "Жамбылский\ р\-н",
"771839", "Лебяжинский\ р\-н",
"772937", "Каракиянский\ р\-н",
"7866", "Республика\ Кабардино\-Балкарская",
"772773", "Балхашский\ р\-н",
"771840", "Баянаульский\ р\-н",
"7352", "Курганская\ обл\.",
"772344", "Тарбагатайский\ р\-н",
"771843", "Майский\ р\-н",
"7341", "Республика\ Удмуртская",
"771632", "Зерендинский\ р\-н",
"771643", "Атбасарский\ р\-н",
"771640", "Сандыктауский\ р\-н",
"771832", "Иртышский\ р\-н",
"77106", "Сатпаев",
"771443", "Мендыкаринский\ р\-н",
"771131", "Зеленовский\ р\-н",
"771440", "Амангельдинский\ р\-н",
"7865", "Ставропольский\ край",
"772546", "Шолаккорган",
"772757", "Акший",
"77272983", "Каскелен",
"771539", "Кызылжарский\ р\-н",
"772531", "Аксукент",
"771146", "Акжаикский\ р\-н",
"7835", "Чувашская\ Республика\ \-\ Чувашия",
"772132", "Нуринский\ р\-н",
"771543", "Есильский\ р\-н",
"771335", "Шалкарский\ р\-н",
"771540", "Уалихановский\ р\-н",
"7834", "Республика\ Мордовия",
"7472", "Белгородская\ обл\.",
"772348", "Кокпектинский\ р\-н",
"771532", "Аккайынский\ р\-н",
"7482", "Тверская\ обл\.",
"7302", "Забайкальский\ край",
"771439", "Джангильдинский\ р\-н",
"772431", "Жалагашский\ р\-н",
"77292", "Актау",
"77125", "Атырауская\ область",
"772237", "Аязог",
"77102", "Жезказган",
"771337", "Алгинский\ р\-н",
"7395", "Иркутская\ обл\.",
"7872", "Республика\ Дагестан",
"771434", "Денисовский\ р\-н",
"771036", "Балхаш",
"771838", "Майский\ р\-он",
"7394", "Республика\ Тыва",
"7842", "Ульяновская\ обл\.",
"771534", "Шал\ Акына\ р\-н",
"7426", "Еврейская\ автономная\ обл\.",
"771638", "Аккольский\ р\-н",
"7851", "Астраханская\ обл\.",
"771041", "Актау\,\ Жезказган",
"771651", "Целиноградский\ р\-н",
"771341", "Хобдинский\ р\-н",
"7424", "Сахалинская\ обл\.",
"772236", "Бескарагайский\ р\-н",
"771438", "Амангельдинский\ р\-н",
"771451", "Сарыкольский\ р\-н",
"771336", "Хромтауский\ р\-н",
"771230", "Атырауская\ область",
"772342", "Катон\-Карагайский\ р\-н",
"771538", "Кызылжарский\ р\-н",
"7493", "Ивановская\ обл\.",
"772935", "Каракиянский\ р\-н",
"771233", "Курмангазинский\ р\-н",
"771145", "Каратобинский\ р\-н",
"77222", "Семипалатинск",
"771037", "Актогайский\ р\-н",
"77132", "Актобе\/Актюбинск",
"772138", "Бухар\-Жырауский\ р\-н",
"771834", "Успенский\ р\-н",
"772330", "Зыряновский\ р\-н",
"772545", "Икан",
"7411", "Республика\ Саха\ \/Якутия\/",
"772333", "Кокпектинский\ р\-н",
"7343", "Свердловская\ обл",
"7486", "Орловская\ обл\.",
"772635", "Жуалынский\ р\-н",
"772144", "Нуринский\ р\-н",
"771031", "Шетский\ р\-н",
"771648", "Жаркаинский\ р\-н",
"772835", "Текели",
"771544", "Жамбылский\ р\-н",
"7383", "Новосибирская\ обл\.",
"771457", "Джангильдинский\ р\-н",
"771444", "Узункольский\ р\-н",
"7813", "Ленинградская\ обл\.",
"771347", "Айтекебийский\ р\-н",
"772778", "Уйгурский\ р\-н",
"772156", "Шахтинск",
"771135", "Жанибекский\ р\-н",
"771644", "Аршалынский\ р\-н",
"772332", "Шемонаихинский\ р\-н",
"7475", "Тамбовская\ обл\.",
"772535", "Шардара",
"771232", "Атырауская\ область",
"772340", "Зайсанский\ р\-н",
"771844", "Иртышский\ р\-н",
"772343", "Курчумский\ р\-н",
"7817", "Вологодская\ обл\.",
"772148", "Осакаровский\ р\-н",
"7485", "Ярославская\ обл\.",
"7862", "Краснодарский\ край",
"771448", "Карасуский\ р\-н",
"772774", "Талгарский\ р\-н",
"771331", "Мартукский\ р\-н",
"772339", "Курчумский\ р\-н",
"7347", "Республика\ Башкортостан",
"7712303", "Тензиз",
"7484", "Калужская\ обл\.",
"771346", "Темирский\ р\-н",
"771239", "Макатский\ р\-н",
"771456", "Качар",
"772435", "Жанакорганский\ р\-н",
"7474", "Липецкая\ обл\.",
"77282", "Талдыкорган",
"772437", "Кармакшинский\ р\-н",
"771642", "Егиндыкольский\ р\-н",
"772334", "Уланский\ р\-н",
"772779", "Райымбекский\ р\-н",
"771833", "Качирский\ р\-н",
"771842", "Майский\ р\-он",
"7845", "Саратовская\ обл\.",
"771234", "Индерский\ р\-н",
"77262", "Тараз",
"77224", "Эмельтау",
"771633", "Ерейментауский\ р\-н",
"771630", "Боровое",
"77272956", "Талгар",
"771649", "Жаксынский\ р\-н",
"772641", "Таласский\ р\-н",
"772772", "Капчагай",
"772836", "Ескельдинский\ р\-н",
"772537", "Сарыагаш",
"772841", "Аксуский\ р\-н",
"772636", "Кордай",
"7844", "Волгоградская\ обл\.",
"771137", "Чингирлауский\ р\-н",
"771533", "Айыртауский\ р\-н",
"771238", "Кзылкогинский\ р\-н",
"771345", "Байганинский\ р\-н",
"772436", "Сырдарьинский\ р\-н",
"771455", "Костанайский\ р\-н",
"7846", "Самарская\ обл\.",
"7491", "Рязанская\ обл\.",
"77252", "Шымкент",
"771449", "Тарановский\ р\-н",
"7413", "Магаданская\ обл\.",
"772351", "Бородулихинский\ р\-н",
"771542", "Уалихановский\ р\-н",
"77112", "Уральск",
"772338", "Уланский\ р\-н",
"7848", "Самарская\ обл\.",
"772252", "Абайский\ р\-н",
"772536", "Кентау",
"772837", "Алакольский\ р\-н",
"772931", "Мангистауский\ р\-н",
"77242", "Кызылорда",
"771433", "Лисаковск",
"772149", "Осакаровский\ р\-н",
"77185", "Шалдай",
"771430", "Аркалык",
"771141", "Жангалинский\ р\-н",
"771136", "Акжаикский\ р\-н",
"7869", "г\.\ Севастополь",
"7878", "Республика\ Карачаево\-Черкесская",
"771442", "Федоровский\ р\-н",
"772637", "Байзакский\ р\-н",
"7857", "Луга́нская\ Наро́дная\ Респу́блика",
"772541", "Мырзакент",
"7861", "Краснодарский\ край",
"7388", "Республика\ Алтай",
"771531", "Магжана\ Жумабаева\ р\-н",
"772539", "Казыгурт",
"772432", "Шиелийский\ р\-н",
"771647", "Есильский\ р\-н",
"7816", "Новгородская\ обл\.",
"772146", "Каркаралинск",
"77273", "Алма\-Ата",
"772131", "Абайский\ р\-н",
"77145834", "Красногорск",
"771139", "Таскалинский\ р\-н",
"772353", "Бородулихинский\ р\-н",
"7831", "Нижегородская\ обл\.",
"7818", "Архангельская\ обл\.",
"771546", "Акжарский\ р\-н",
"771348", "Шалкарский\ р\-н",
"771235", "Макатский\ р\-н",
"772256", "Алгабас",
"772532", "Абая",
"772777", "Райымбекский\ р\-н",
"771431", "Рудный",
"771140", "Бокейординский\ р\-н",
"772439", "Аральский\ р\-н",
"771458", "Костанайская\ область",
"771143", "Теректинский\ р\-н",
"771132", "Теректинский\ р\-н",
"7346", "Ханты\ \-\ Мансийский\ \-\ Югра\ АО",
"771446", "Узункольский\ р\-н",
"7483", "Брянская\ обл\.",
"772335", "Зыряновск",
"7473", "Воронежская\ обл\.",
"7499", "г\.\ Москва",
"772540", "Арыс",
"772543", "Аксумбе",
"736", "Республика\ Крым",
"772147", "Каркаралинский\ р\-н",
"772154", "Бухар\-Жырауский\ р\-н",
"7821", "Республика\ Коми",
"77279", "Алматы",
"771646", "Буландинский\ р\-н",
"772839", "Саркандский\ р\-н",
"7385", "Алтайский\ край",
"771831", "Железинский\ р\-н",
"7815", "Мурманская\ обл\.",
"771547", "Жамбылский\ р\-н",
"7487", "Тульская\ обл\.",
"771631", "Шортандинский\ р\-н",
"772639", "Сарысуский\ р\-н",
"772640", "Мойынкумский\ р\-н",
"772643", "Шуский\ р\-н",
"7384", "Кемеровская\ обл\.",
"772776", "Енбекшиказахский\ р\-н",
"7345", "Тюменская\ обл\.",
"772257", "Шульбинск",
"7353", "Оренбургская\ обл\.",
"772832", "Аксуский\ р\-н",
"772843", "Лепсы",
"772840", "Кербулакский\ р\-н",
"771447", "Карабалыкский\ р\-н",
"772632", "Меркенский\ р\-н",
"771454", "Наурзумский\ р\-н",
"7814", "Республика\ Карелия",
"771445", "Алтынсаринский\ р\-н",
"772336", "Риддер",
"772725", "Отеген\-Батыр",
"733622", "Байконыр",
"771349", "Шалкарский\ р\-н",
"771236", "Махамбетский\ р\-н",
"772341", "Катон\-Карагайский\ р\-н",
"7847", "Республика\ Калмыкия",
"772438", "Казалинский\ р\-н",
"771459", "Костанайская\ область",
"7856", "Донецкая\ Народная\ Республика",
"77232", "Усть\-Каменогорск",
"771138", "Казталовский\ р\-н",
"772159", "Карагандинская\ область",
"7421", "Хабаровский\ край",
"771333", "Мугалжарский\ р\-н",
"772834", "Каратальский\ р\-н",
"7492", "Владимирская\ обл\.",
"771330", "Хромтауский\ р\-н",
"771545", "Жамбылский\ р\-н",
"772230", "Урджарский\ р\-н",
"771342", "Каргалинский\ р\-н",
"772538", "имени\ Турара\ Рыскулова",
"772634", "Жанатас",
"771452", "Карасуский\ р\-н",
"7415", "Камчатский\ край",
"77122", "Атырау",
"7877", "Республика\ Адыгея",
"772337", "Серебрянск",
"77272", "Алма\-Ата",
"771042", "Акой",
"77135", "Актюбинская\ область",
"771033", "Шетский\ р\-н",
"7873", "Республика\ Ингушетия",
"771030", "Жана\-Аркинский\ р\-н",
"772775", "Енбекшиказахский\ р\-н",
"771237", "Жылыойский\ р\-н",
"7717", "Астана",
"7391", "Красноярский\ край",
"772534", "Жетысай",
"771845", "Павлодар",
"7416", "Амурская\ обл\.",
"772638", "Шуский\ р\-н",
"771134", "Сырымский\ р\-н",
"771645", "Степногорск",
"772838", "Коксуский\ р\-н",
"7843", "Республика\ Татарстан",
"7855", "Республика\ Татарстан",};
my $timezones = {
               '' => [
                       'Asia/Almaty',
                       'Asia/Anadyr',
                       'Asia/Aqtobe',
                       'Asia/Irkutsk',
                       'Asia/Kamchatka',
                       'Asia/Krasnoyarsk',
                       'Asia/Magadan',
                       'Asia/Novosibirsk',
                       'Asia/Omsk',
                       'Asia/Sakhalin',
                       'Asia/Vladivostok',
                       'Asia/Yakutsk',
                       'Asia/Yekaterinburg',
                       'Europe/Bucharest',
                       'Europe/Moscow',
                       'Europe/Samara'
                     ],
               '301' => [
                          'Asia/Irkutsk'
                        ],
               '302' => [
                          'Asia/Yakutsk'
                        ],
               '336' => [
                          'Asia/Yekaterinburg'
                        ],
               '33622' => [
                            'Asia/Almaty'
                          ],
               '34' => [
                         'Asia/Yekaterinburg'
                       ],
               '341' => [
                          'Europe/Samara'
                        ],
               '35' => [
                         'Asia/Yekaterinburg'
                       ],
               '36' => [
                         'Europe/Moscow'
                       ],
               '381' => [
                          'Asia/Omsk'
                        ],
               '382' => [
                          'Asia/Novosibirsk'
                        ],
               '383' => [
                          'Asia/Novosibirsk'
                        ],
               '384' => [
                          'Asia/Krasnoyarsk'
                        ],
               '385' => [
                          'Asia/Krasnoyarsk'
                        ],
               '388' => [
                          'Asia/Krasnoyarsk'
                        ],
               '390' => [
                          'Asia/Krasnoyarsk'
                        ],
               '391' => [
                          'Asia/Krasnoyarsk'
                        ],
               '394' => [
                          'Asia/Krasnoyarsk'
                        ],
               '395' => [
                          'Asia/Irkutsk'
                        ],
               '40' => [
                         'Europe/Bucharest'
                       ],
               '411' => [
                          'Asia/Yakutsk'
                        ],
               '413' => [
                          'Asia/Magadan'
                        ],
               '415' => [
                          'Asia/Kamchatka'
                        ],
               '416' => [
                          'Asia/Yakutsk'
                        ],
               '421' => [
                          'Asia/Vladivostok'
                        ],
               '423' => [
                          'Asia/Vladivostok'
                        ],
               '424' => [
                          'Asia/Sakhalin'
                        ],
               '426' => [
                          'Asia/Vladivostok'
                        ],
               '427' => [
                          'Asia/Anadyr'
                        ],
               '47' => [
                         'Europe/Moscow'
                       ],
               '48' => [
                         'Europe/Moscow'
                       ],
               '49' => [
                         'Europe/Moscow'
                       ],
               '7' => [
                        'Asia/Almaty',
                        'Asia/Aqtobe'
                      ],
               '71' => [
                         'Asia/Almaty'
                       ],
               '711' => [
                          'Asia/Aqtobe'
                        ],
               '712' => [
                          'Asia/Aqtobe'
                        ],
               '713' => [
                          'Asia/Aqtobe'
                        ],
               '72' => [
                         'Asia/Almaty'
                       ],
               '729' => [
                          'Asia/Aqtobe'
                        ],
               '79' => [
                         'Asia/Almaty'
                       ],
               '800' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '803' => [
                          'Europe/Moscow'
                        ],
               '804' => [
                          'Europe/Moscow'
                        ],
               '808' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '809' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '81' => [
                         'Europe/Moscow'
                       ],
               '810' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '82' => [
                         'Europe/Moscow'
                       ],
               '83' => [
                         'Europe/Moscow'
                       ],
               '840' => [
                          'Europe/Bucharest',
                          'Europe/Moscow'
                        ],
               '841' => [
                          'Europe/Moscow'
                        ],
               '842' => [
                          'Europe/Samara'
                        ],
               '843' => [
                          'Europe/Moscow'
                        ],
               '844' => [
                          'Europe/Moscow'
                        ],
               '845' => [
                          'Europe/Moscow'
                        ],
               '846' => [
                          'Europe/Samara'
                        ],
               '847' => [
                          'Europe/Moscow'
                        ],
               '848' => [
                          'Europe/Samara'
                        ],
               '851' => [
                          'Europe/Samara'
                        ],
               '855' => [
                          'Europe/Moscow'
                        ],
               '856' => [
                          'Europe/Moscow'
                        ],
               '857' => [
                          'Europe/Moscow'
                        ],
               '86' => [
                         'Europe/Moscow'
                       ],
               '87' => [
                         'Europe/Moscow'
                       ],
               '9' => [
                        'Europe/Moscow'
                      ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+7|\D)//g;
      my $self = bless({ country_code => '7', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:8)//;
      $self = bless({ country_code => '7', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;