#! /usr/bin/env false

use v6.d;

use IRC::Client::Plugin::Reminders::Delay;

constant Delay = IRC::Client::Plugin::Reminders::Delay;

unit class IRC::Client::Plugin::Reminders::Actions;

method TOP ($/) {
	make $<subject>.made
}

method subject ($/) {
	make {
		subject => $/.substr(0, *-$<delay>.chars).trim,
		delay => $<delay>.made,
	}
}

method delay ($/) {
	my %delay;

	%delay<minutes> = +$_ with $<delay-minutes>;
	%delay<hours> = +$_ with $<delay-hours>;
	%delay<days> = +$_ with $<delay-days>;
	%delay<weeks> = +$_ with $<delay-weeks>;

	make Delay.new(|%delay);
}

=begin pod

=NAME    IRC::Client::Plugin::Reminders::Actions
=VERSION 0.1.0
=AUTHOR  Patrick Spek <p.spek@tyil.nl>

=begin LICENSE
Copyright © 2020

This program is free software: you can redistribute it and/or modify it under
the terms of the GNU Affero General Public License as published by the Free
Software Foundation, either version 3 of the License, or (at your option) any
later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
details.

You should have received a copy of the GNU Affero General Public License along
with this program.  If not, see http://www.gnu.org/licenses/.
=end LICENSE

=end pod

# vim: ft=raku noet sw=8 ts=8
