/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.utils.connectiondata;

import com.javonet.utils.ConnectionType;
import com.javonet.utils.connectiondata.IConnectionData;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;

public class TcpConnectionData
implements IConnectionData {
    private String hostName = "";
    private String ipAddress = "";
    private final int port;
    private final ConnectionType connectionType = ConnectionType.TCP;

    public TcpConnectionData(String hostname, int port) throws UnknownHostException {
        this.hostName = hostname;
        this.port = port;
        InetAddress inetAddress = InetAddress.getByName(hostname);
        this.ipAddress = inetAddress.getHostAddress();
    }

    @Override
    public byte[] serializeConnectionData() {
        byte[] addressBytes = this.getAddressBytes();
        byte[] portBytes = this.getPortBytes();
        byte[] result = new byte[1 + addressBytes.length + portBytes.length];
        result[0] = (byte)this.getConnectionType().ordinal();
        System.arraycopy(addressBytes, 0, result, 1, addressBytes.length);
        System.arraycopy(portBytes, 0, result, 1 + addressBytes.length, portBytes.length);
        return result;
    }

    private byte[] getAddressBytes() {
        String[] ipAddress = this.ipAddress.split("\\.");
        byte[] ipBytes = new byte[ipAddress.length];
        for (int i = 0; i < ipAddress.length; ++i) {
            ipBytes[i] = (byte)Integer.parseInt(ipAddress[i]);
        }
        return ipBytes;
    }

    private byte[] getPortBytes() {
        return new byte[]{(byte)this.port, (byte)(this.port >>> 8 & 0xFF)};
    }

    @Override
    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    @Override
    public String getHostname() {
        return this.hostName;
    }

    public String toString() {
        return this.ipAddress + ":" + this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TcpConnectionData that = (TcpConnectionData)o;
        return this.port == that.port && this.ipAddress.equals(that.ipAddress);
    }

    public int hashCode() {
        return Objects.hash(this.ipAddress, this.port);
    }
}

