#!/bin/sh

# User, system, MTA binaries, alternative man pages
UBINDIR="/usr/bin"
SBINDIR="/usr/sbin"
MBINDIR="/usr/libexec"
MANROOT="/usr/share/sendmail/man"

# owner of MSP queue
MSPQOWN="18"

# Setgid binary ownership/permissions
GBINOWN="18"
GBINGRP="545"
GBINMODE="2555"

function install_conf {
	if ! [ -f "/$1" ]; then
		cp -p "/etc/defaults/$1" "/$1"
		chown $GBINOWN "/$1"
	fi
}
function install_dir {
	if ! [ -d "$1" ]; then
		mkdir -p "$1"
		chown $MSPQOWN "$1"
		chmod 0750 "$1"
	fi
}

install_dir /etc/sasl2
install_dir /etc/mail
install_dir /etc/mail/certs
install_dir /var/spool/mqueue

install_dir /var/run
chgrp 544 /var/run
chmod g+w /var/run

install_dir /var/spool/clientmqueue
chmod g+w /var/spool/clientmqueue

chown $GBINOWN $MBINDIR/sendmail.exe
chmod $GBINMODE $MBINDIR/sendmail.exe

if ! [ -f /etc/mail/aliases ]; then
	ln -s /etc/aliases /etc/mail/
	chown $MSPQOWN /etc/aliases
	chown $MSPQOWN /etc/mail
fi

for conf in local-host-names trusted-users statistics sendmail.cf submit.cf virtusertable virtusertable.db relay-domains
do
	install_conf etc/mail/$conf
done

chmod g+w /etc/mail/virtusertable.db

install_conf etc/sasl2/Sendmail.conf
install_conf usr/share/sendmail/cf/sendmail.mc
install_conf etc/init.src.sh

/usr/sbin/alternatives --install /usr/sbin/sendmail mta $MBINDIR/sendmail.exe 0 \
	--slave /usr/lib/sendmail mta-sendmail $MBINDIR/sendmail.exe \
	--slave /usr/bin/mailq mta-mailq $MBINDIR/sendmail.exe \
	--slave /usr/bin/newaliases mta-newaliases $MBINDIR/sendmail.exe \
	--slave /usr/share/man/man1/mailq.1.gz mta-mailq-man $MANROOT/man1/mailq.1.gz \
	--slave /usr/share/man/man1/newaliases.1.gz mta-newaliases-man $MANROOT/man1/newaliases.1.gz \
	--slave /usr/share/man/man5/aliases.5.gz mta-aliases-man $MANROOT/man5/aliases.5.gz \
	--slave /usr/share/man/man8/sendmail.8.gz mta-sendmail-man $MANROOT/man8/sendmail.8.gz

chown 18:544 $UBINDIR/sendmail-config
chmod 0750 $UBINDIR/sendmail-config

