/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDocument.h"

#include "Attr.h"
#include "CDATASection.h"
#include "CSSStyleDeclaration.h"
#include "CanvasRenderingContext.h"
#include "Comment.h"
#include "DOMImplementation.h"
#include "DOMNamedFlowCollection.h"
#include "DOMSelection.h"
#include "DOMWindow.h"
#include "Document.h"
#include "DocumentFragment.h"
#include "DocumentType.h"
#include "Element.h"
#include "EntityReference.h"
#include "Event.h"
#include "EventListener.h"
#include "ExceptionCode.h"
#include "HTMLCollection.h"
#include "HTMLElement.h"
#include "HTMLHeadElement.h"
#include "JSAttr.h"
#include "JSCDATASection.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCanvasRenderingContext.h"
#include "JSComment.h"
#include "JSCustomXPathNSResolver.h"
#include "JSDOMBinding.h"
#include "JSDOMImplementation.h"
#include "JSDOMSelection.h"
#include "JSDOMWindow.h"
#include "JSDocumentFragment.h"
#include "JSDocumentType.h"
#include "JSElement.h"
#include "JSEntityReference.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "JSEventTarget.h"
#include "JSHTMLCollection.h"
#include "JSHTMLElement.h"
#include "JSHTMLHeadElement.h"
#include "JSNode.h"
#include "JSNodeFilter.h"
#include "JSNodeIterator.h"
#include "JSNodeList.h"
#include "JSProcessingInstruction.h"
#include "JSRange.h"
#include "JSStyleSheetList.h"
#include "JSText.h"
#include "JSTouch.h"
#include "JSTreeWalker.h"
#include "JSXPathExpression.h"
#include "JSXPathNSResolver.h"
#include "JSXPathResult.h"
#include "KURL.h"
#include "NameNodeList.h"
#include "Node.h"
#include "NodeFilter.h"
#include "NodeIterator.h"
#include "NodeList.h"
#include "ProcessingInstruction.h"
#include "Range.h"
#include "StylePropertySet.h"
#include "StyleSheetList.h"
#include "Text.h"
#include "Touch.h"
#include "TouchList.h"
#include "TreeWalker.h"
#include "XPathExpression.h"
#include "XPathNSResolver.h"
#include "XPathResult.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>
#include <wtf/text/WTFString.h>

#if ENABLE(CSP_NEXT)
#include "DOMSecurityPolicy.h"
#include "JSDOMSecurityPolicy.h"
#endif

#if ENABLE(CSS_REGIONS)
#include "JSDOMNamedFlowCollection.h"
#endif

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSDocumentTableValues[] =
{
    { "doctype", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentDoctype), (intptr_t)0, NoIntrinsic },
    { "implementation", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentImplementation), (intptr_t)0, NoIntrinsic },
    { "documentElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentDocumentElement), (intptr_t)0, NoIntrinsic },
    { "inputEncoding", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentInputEncoding), (intptr_t)0, NoIntrinsic },
    { "xmlEncoding", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentXMLEncoding), (intptr_t)0, NoIntrinsic },
    { "xmlVersion", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentXMLVersion), (intptr_t)setJSDocumentXMLVersion, NoIntrinsic },
    { "xmlStandalone", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentXMLStandalone), (intptr_t)setJSDocumentXMLStandalone, NoIntrinsic },
    { "documentURI", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentDocumentURI), (intptr_t)0, NoIntrinsic },
    { "defaultView", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentDefaultView), (intptr_t)0, NoIntrinsic },
    { "styleSheets", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentStyleSheets), (intptr_t)0, NoIntrinsic },
    { "title", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentTitle), (intptr_t)setJSDocumentTitle, NoIntrinsic },
    { "referrer", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentReferrer), (intptr_t)0, NoIntrinsic },
    { "domain", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentDomain), (intptr_t)setJSDocumentDomain, NoIntrinsic },
    { "URL", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentURL), (intptr_t)0, NoIntrinsic },
    { "cookie", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentCookie), (intptr_t)setJSDocumentCookie, NoIntrinsic },
    { "body", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentBody), (intptr_t)setJSDocumentBody, NoIntrinsic },
    { "head", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentHead), (intptr_t)0, NoIntrinsic },
    { "images", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentImages), (intptr_t)0, NoIntrinsic },
    { "applets", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentApplets), (intptr_t)0, NoIntrinsic },
    { "links", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentLinks), (intptr_t)0, NoIntrinsic },
    { "forms", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentForms), (intptr_t)0, NoIntrinsic },
    { "anchors", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentAnchors), (intptr_t)0, NoIntrinsic },
    { "lastModified", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentLastModified), (intptr_t)0, NoIntrinsic },
    { "location", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentLocation), (intptr_t)setJSDocumentLocation, NoIntrinsic },
    { "charset", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentCharset), (intptr_t)setJSDocumentCharset, NoIntrinsic },
    { "defaultCharset", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentDefaultCharset), (intptr_t)0, NoIntrinsic },
    { "readyState", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentReadyState), (intptr_t)0, NoIntrinsic },
    { "characterSet", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentCharacterSet), (intptr_t)0, NoIntrinsic },
    { "preferredStylesheetSet", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentPreferredStylesheetSet), (intptr_t)0, NoIntrinsic },
    { "selectedStylesheetSet", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentSelectedStylesheetSet), (intptr_t)setJSDocumentSelectedStylesheetSet, NoIntrinsic },
    { "compatMode", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentCompatMode), (intptr_t)0, NoIntrinsic },
#if ENABLE(POINTER_LOCK)
    { "webkitPointerLockElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentWebkitPointerLockElement), (intptr_t)0, NoIntrinsic },
#endif
    { "onabort", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnabort), (intptr_t)setJSDocumentOnabort, NoIntrinsic },
    { "onblur", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnblur), (intptr_t)setJSDocumentOnblur, NoIntrinsic },
    { "onchange", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnchange), (intptr_t)setJSDocumentOnchange, NoIntrinsic },
    { "onclick", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnclick), (intptr_t)setJSDocumentOnclick, NoIntrinsic },
    { "oncontextmenu", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOncontextmenu), (intptr_t)setJSDocumentOncontextmenu, NoIntrinsic },
    { "ondblclick", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndblclick), (intptr_t)setJSDocumentOndblclick, NoIntrinsic },
    { "ondrag", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndrag), (intptr_t)setJSDocumentOndrag, NoIntrinsic },
    { "ondragend", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndragend), (intptr_t)setJSDocumentOndragend, NoIntrinsic },
    { "ondragenter", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndragenter), (intptr_t)setJSDocumentOndragenter, NoIntrinsic },
    { "ondragleave", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndragleave), (intptr_t)setJSDocumentOndragleave, NoIntrinsic },
    { "ondragover", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndragover), (intptr_t)setJSDocumentOndragover, NoIntrinsic },
    { "ondragstart", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndragstart), (intptr_t)setJSDocumentOndragstart, NoIntrinsic },
    { "ondrop", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOndrop), (intptr_t)setJSDocumentOndrop, NoIntrinsic },
    { "onerror", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnerror), (intptr_t)setJSDocumentOnerror, NoIntrinsic },
    { "onfocus", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnfocus), (intptr_t)setJSDocumentOnfocus, NoIntrinsic },
    { "oninput", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOninput), (intptr_t)setJSDocumentOninput, NoIntrinsic },
    { "oninvalid", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOninvalid), (intptr_t)setJSDocumentOninvalid, NoIntrinsic },
    { "onkeydown", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnkeydown), (intptr_t)setJSDocumentOnkeydown, NoIntrinsic },
    { "onkeypress", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnkeypress), (intptr_t)setJSDocumentOnkeypress, NoIntrinsic },
    { "onkeyup", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnkeyup), (intptr_t)setJSDocumentOnkeyup, NoIntrinsic },
    { "onload", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnload), (intptr_t)setJSDocumentOnload, NoIntrinsic },
    { "onmousedown", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnmousedown), (intptr_t)setJSDocumentOnmousedown, NoIntrinsic },
    { "onmousemove", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnmousemove), (intptr_t)setJSDocumentOnmousemove, NoIntrinsic },
    { "onmouseout", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnmouseout), (intptr_t)setJSDocumentOnmouseout, NoIntrinsic },
    { "onmouseover", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnmouseover), (intptr_t)setJSDocumentOnmouseover, NoIntrinsic },
    { "onmouseup", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnmouseup), (intptr_t)setJSDocumentOnmouseup, NoIntrinsic },
    { "onmousewheel", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnmousewheel), (intptr_t)setJSDocumentOnmousewheel, NoIntrinsic },
    { "onreadystatechange", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnreadystatechange), (intptr_t)setJSDocumentOnreadystatechange, NoIntrinsic },
    { "onscroll", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnscroll), (intptr_t)setJSDocumentOnscroll, NoIntrinsic },
    { "onselect", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnselect), (intptr_t)setJSDocumentOnselect, NoIntrinsic },
    { "onsubmit", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnsubmit), (intptr_t)setJSDocumentOnsubmit, NoIntrinsic },
    { "onbeforecut", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnbeforecut), (intptr_t)setJSDocumentOnbeforecut, NoIntrinsic },
    { "oncut", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOncut), (intptr_t)setJSDocumentOncut, NoIntrinsic },
    { "onbeforecopy", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnbeforecopy), (intptr_t)setJSDocumentOnbeforecopy, NoIntrinsic },
    { "oncopy", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOncopy), (intptr_t)setJSDocumentOncopy, NoIntrinsic },
    { "onbeforepaste", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnbeforepaste), (intptr_t)setJSDocumentOnbeforepaste, NoIntrinsic },
    { "onpaste", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnpaste), (intptr_t)setJSDocumentOnpaste, NoIntrinsic },
    { "onreset", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnreset), (intptr_t)setJSDocumentOnreset, NoIntrinsic },
    { "onsearch", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnsearch), (intptr_t)setJSDocumentOnsearch, NoIntrinsic },
    { "onselectstart", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnselectstart), (intptr_t)setJSDocumentOnselectstart, NoIntrinsic },
    { "onselectionchange", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnselectionchange), (intptr_t)setJSDocumentOnselectionchange, NoIntrinsic },
#if ENABLE(TOUCH_EVENTS)
    { "ontouchstart", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOntouchstart), (intptr_t)setJSDocumentOntouchstart, NoIntrinsic },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchmove", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOntouchmove), (intptr_t)setJSDocumentOntouchmove, NoIntrinsic },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchend", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOntouchend), (intptr_t)setJSDocumentOntouchend, NoIntrinsic },
#endif
#if ENABLE(TOUCH_EVENTS)
    { "ontouchcancel", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOntouchcancel), (intptr_t)setJSDocumentOntouchcancel, NoIntrinsic },
#endif
#if ENABLE(FULLSCREEN_API)
    { "onwebkitfullscreenchange", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnwebkitfullscreenchange), (intptr_t)setJSDocumentOnwebkitfullscreenchange, NoIntrinsic },
#endif
#if ENABLE(FULLSCREEN_API)
    { "onwebkitfullscreenerror", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnwebkitfullscreenerror), (intptr_t)setJSDocumentOnwebkitfullscreenerror, NoIntrinsic },
#endif
#if ENABLE(POINTER_LOCK)
    { "onwebkitpointerlockchange", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnwebkitpointerlockchange), (intptr_t)setJSDocumentOnwebkitpointerlockchange, NoIntrinsic },
#endif
#if ENABLE(POINTER_LOCK)
    { "onwebkitpointerlockerror", DontDelete | DontEnum, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentOnwebkitpointerlockerror), (intptr_t)setJSDocumentOnwebkitpointerlockerror, NoIntrinsic },
#endif
#if ENABLE(PAGE_VISIBILITY_API)
    { "webkitVisibilityState", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentWebkitVisibilityState), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(PAGE_VISIBILITY_API)
    { "webkitHidden", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentWebkitHidden), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(CSP_NEXT)
    { "securityPolicy", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentSecurityPolicy), (intptr_t)0, NoIntrinsic },
#endif
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDocumentConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDocumentTable = { 264, 255, JSDocumentTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSDocumentConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDocumentConstructorTable = { 1, 0, JSDocumentConstructorTableValues, 0 };
const ClassInfo JSDocumentConstructor::s_info = { "DocumentConstructor", &Base::s_info, &JSDocumentConstructorTable, 0, CREATE_METHOD_TABLE(JSDocumentConstructor) };

JSDocumentConstructor::JSDocumentConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSDocumentConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSDocumentPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSDocumentConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSDocumentConstructor, JSDOMWrapper>(exec, &JSDocumentConstructorTable, jsCast<JSDocumentConstructor*>(cell), propertyName, slot);
}

bool JSDocumentConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSDocumentConstructor, JSDOMWrapper>(exec, &JSDocumentConstructorTable, jsCast<JSDocumentConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSDocumentPrototypeTableValues[] =
{
    { "createElement", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateElement), (intptr_t)1, NoIntrinsic },
    { "createDocumentFragment", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateDocumentFragment), (intptr_t)0, NoIntrinsic },
    { "createTextNode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateTextNode), (intptr_t)1, NoIntrinsic },
    { "createComment", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateComment), (intptr_t)1, NoIntrinsic },
    { "createCDATASection", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateCDATASection), (intptr_t)1, NoIntrinsic },
    { "createProcessingInstruction", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateProcessingInstruction), (intptr_t)2, NoIntrinsic },
    { "createAttribute", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateAttribute), (intptr_t)1, NoIntrinsic },
    { "createEntityReference", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateEntityReference), (intptr_t)1, NoIntrinsic },
    { "getElementsByTagName", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionGetElementsByTagName), (intptr_t)1, NoIntrinsic },
    { "importNode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionImportNode), (intptr_t)2, NoIntrinsic },
    { "createElementNS", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateElementNS), (intptr_t)2, NoIntrinsic },
    { "createAttributeNS", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateAttributeNS), (intptr_t)2, NoIntrinsic },
    { "getElementsByTagNameNS", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionGetElementsByTagNameNS), (intptr_t)2, NoIntrinsic },
    { "getElementById", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionGetElementById), (intptr_t)1, NoIntrinsic },
    { "adoptNode", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionAdoptNode), (intptr_t)1, NoIntrinsic },
    { "createEvent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateEvent), (intptr_t)1, NoIntrinsic },
    { "createRange", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateRange), (intptr_t)0, NoIntrinsic },
    { "createNodeIterator", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateNodeIterator), (intptr_t)4, NoIntrinsic },
    { "createTreeWalker", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateTreeWalker), (intptr_t)4, NoIntrinsic },
    { "getOverrideStyle", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionGetOverrideStyle), (intptr_t)2, NoIntrinsic },
    { "createExpression", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateExpression), (intptr_t)2, NoIntrinsic },
    { "createNSResolver", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateNSResolver), (intptr_t)1, NoIntrinsic },
    { "evaluate", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionEvaluate), (intptr_t)5, NoIntrinsic },
    { "execCommand", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionExecCommand), (intptr_t)3, NoIntrinsic },
    { "queryCommandEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionQueryCommandEnabled), (intptr_t)1, NoIntrinsic },
    { "queryCommandIndeterm", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionQueryCommandIndeterm), (intptr_t)1, NoIntrinsic },
    { "queryCommandState", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionQueryCommandState), (intptr_t)1, NoIntrinsic },
    { "queryCommandSupported", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionQueryCommandSupported), (intptr_t)1, NoIntrinsic },
    { "queryCommandValue", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionQueryCommandValue), (intptr_t)1, NoIntrinsic },
    { "getElementsByName", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionGetElementsByName), (intptr_t)1, NoIntrinsic },
    { "elementFromPoint", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionElementFromPoint), (intptr_t)2, NoIntrinsic },
    { "caretRangeFromPoint", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCaretRangeFromPoint), (intptr_t)2, NoIntrinsic },
    { "getSelection", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionGetSelection), (intptr_t)0, NoIntrinsic },
    { "getCSSCanvasContext", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionGetCSSCanvasContext), (intptr_t)4, NoIntrinsic },
    { "getElementsByClassName", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionGetElementsByClassName), (intptr_t)1, NoIntrinsic },
    { "querySelector", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionQuerySelector), (intptr_t)1, NoIntrinsic },
    { "querySelectorAll", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionQuerySelectorAll), (intptr_t)1, NoIntrinsic },
#if ENABLE(POINTER_LOCK)
    { "webkitExitPointerLock", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionWebkitExitPointerLock), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(CSS_REGIONS)
    { "webkitGetNamedFlows", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionWebkitGetNamedFlows), (intptr_t)0, NoIntrinsic },
#endif
    { "createTouch", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateTouch), (intptr_t)11, NoIntrinsic },
    { "createTouchList", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDocumentPrototypeFunctionCreateTouchList), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDocumentPrototypeTable = { 135, 127, JSDocumentPrototypeTableValues, 0 };
const ClassInfo JSDocumentPrototype::s_info = { "DocumentPrototype", &Base::s_info, &JSDocumentPrototypeTable, 0, CREATE_METHOD_TABLE(JSDocumentPrototype) };

JSObject* JSDocumentPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDocument>(exec, globalObject);
}

bool JSDocumentPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDocumentPrototype* thisObject = jsCast<JSDocumentPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSDocumentPrototypeTable, thisObject, propertyName, slot);
}

bool JSDocumentPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDocumentPrototype* thisObject = jsCast<JSDocumentPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSDocumentPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSDocument::s_info = { "Document", &Base::s_info, &JSDocumentTable, 0 , CREATE_METHOD_TABLE(JSDocument) };

JSDocument::JSDocument(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Document> impl)
    : JSNode(structure, globalObject, impl)
{
}

void JSDocument::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSDocument::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSDocumentPrototype::create(exec->globalData(), globalObject, JSDocumentPrototype::createStructure(exec->globalData(), globalObject, JSNodePrototype::self(exec, globalObject)));
}

JSValue jsDocumentDoctype(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->doctype()));
    return result;
}


JSValue jsDocumentImplementation(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->implementation()));
    return result;
}


JSValue jsDocumentDocumentElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->documentElement()));
    return result;
}


JSValue jsDocumentInputEncoding(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, impl->inputEncoding());
    return result;
}


JSValue jsDocumentXMLEncoding(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, impl->xmlEncoding());
    return result;
}


JSValue jsDocumentXMLVersion(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, impl->xmlVersion());
    return result;
}


JSValue jsDocumentXMLStandalone(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    JSValue result = jsBoolean(impl->xmlStandalone());
    return result;
}


JSValue jsDocumentDocumentURI(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, impl->documentURI());
    return result;
}


JSValue jsDocumentDefaultView(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->defaultView()));
    return result;
}


JSValue jsDocumentStyleSheets(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->styleSheets()));
    return result;
}


JSValue jsDocumentTitle(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->title());
    return result;
}


JSValue jsDocumentReferrer(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->referrer());
    return result;
}


JSValue jsDocumentDomain(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->domain());
    return result;
}


JSValue jsDocumentURL(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->url());
    return result;
}


JSValue jsDocumentCookie(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    ExceptionCode ec = 0;
    Document* impl = static_cast<Document*>(castedThis->impl());
    JSC::JSValue result = jsStringWithCache(exec, impl->cookie(ec));
    setDOMException(exec, ec);
    return result;
}


JSValue jsDocumentBody(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->body()));
    return result;
}


JSValue jsDocumentHead(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->head()));
    return result;
}


JSValue jsDocumentImages(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->images()));
    return result;
}


JSValue jsDocumentApplets(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->applets()));
    return result;
}


JSValue jsDocumentLinks(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->links()));
    return result;
}


JSValue jsDocumentForms(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->forms()));
    return result;
}


JSValue jsDocumentAnchors(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->anchors()));
    return result;
}


JSValue jsDocumentLastModified(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->lastModified());
    return result;
}


JSValue jsDocumentLocation(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    return castedThis->location(exec);
}


JSValue jsDocumentCharset(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringOrUndefined(exec, impl->charset());
    return result;
}


JSValue jsDocumentDefaultCharset(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringOrUndefined(exec, impl->defaultCharset());
    return result;
}


JSValue jsDocumentReadyState(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringOrUndefined(exec, impl->readyState());
    return result;
}


JSValue jsDocumentCharacterSet(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, impl->characterSet());
    return result;
}


JSValue jsDocumentPreferredStylesheetSet(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, impl->preferredStylesheetSet());
    return result;
}


JSValue jsDocumentSelectedStylesheetSet(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, impl->selectedStylesheetSet());
    return result;
}


JSValue jsDocumentCompatMode(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->compatMode());
    return result;
}


#if ENABLE(POINTER_LOCK)
JSValue jsDocumentWebkitPointerLockElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->webkitPointerLockElement()));
    return result;
}

#endif

JSValue jsDocumentOnabort(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->onabort()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOnblur(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->onblur()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOnchange(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->onchange()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOnclick(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->onclick()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOncontextmenu(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->oncontextmenu()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOndblclick(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->ondblclick()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOndrag(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->ondrag()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOndragend(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->ondragend()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOndragenter(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->ondragenter()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOndragleave(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->ondragleave()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOndragover(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->ondragover()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOndragstart(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->ondragstart()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOndrop(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->ondrop()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOnerror(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->onerror()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOnfocus(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->onfocus()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOninput(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->oninput()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOninvalid(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->oninvalid()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOnkeydown(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->onkeydown()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOnkeypress(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->onkeypress()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOnkeyup(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->onkeyup()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOnload(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->onload()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOnmousedown(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->onmousedown()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOnmousemove(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->onmousemove()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOnmouseout(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->onmouseout()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOnmouseover(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->onmouseover()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOnmouseup(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->onmouseup()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOnmousewheel(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->onmousewheel()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOnreadystatechange(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->onreadystatechange()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOnscroll(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->onscroll()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOnselect(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->onselect()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOnsubmit(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->onsubmit()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOnbeforecut(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->onbeforecut()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOncut(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->oncut()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOnbeforecopy(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->onbeforecopy()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOncopy(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->oncopy()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOnbeforepaste(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->onbeforepaste()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOnpaste(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->onpaste()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOnreset(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->onreset()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOnsearch(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->onsearch()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOnselectstart(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->onselectstart()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


JSValue jsDocumentOnselectionchange(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->onselectionchange()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


#if ENABLE(TOUCH_EVENTS)
JSValue jsDocumentOntouchstart(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->ontouchstart()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}

#endif

#if ENABLE(TOUCH_EVENTS)
JSValue jsDocumentOntouchmove(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->ontouchmove()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}

#endif

#if ENABLE(TOUCH_EVENTS)
JSValue jsDocumentOntouchend(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->ontouchend()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}

#endif

#if ENABLE(TOUCH_EVENTS)
JSValue jsDocumentOntouchcancel(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->ontouchcancel()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}

#endif

#if ENABLE(FULLSCREEN_API)
JSValue jsDocumentOnwebkitfullscreenchange(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->onwebkitfullscreenchange()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}

#endif

#if ENABLE(FULLSCREEN_API)
JSValue jsDocumentOnwebkitfullscreenerror(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->onwebkitfullscreenerror()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}

#endif

#if ENABLE(POINTER_LOCK)
JSValue jsDocumentOnwebkitpointerlockchange(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->onwebkitpointerlockchange()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}

#endif

#if ENABLE(POINTER_LOCK)
JSValue jsDocumentOnwebkitpointerlockerror(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (EventListener* listener = impl->onwebkitpointerlockerror()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}

#endif

#if ENABLE(PAGE_VISIBILITY_API)
JSValue jsDocumentWebkitVisibilityState(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->webkitVisibilityState());
    return result;
}

#endif

#if ENABLE(PAGE_VISIBILITY_API)
JSValue jsDocumentWebkitHidden(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    JSValue result = jsBoolean(impl->webkitHidden());
    return result;
}

#endif

#if ENABLE(CSP_NEXT)
JSValue jsDocumentSecurityPolicy(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Document* impl = static_cast<Document*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->securityPolicy()));
    return result;
}

#endif

JSValue jsDocumentConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDocument* domObject = jsCast<JSDocument*>(asObject(slotBase));
    return JSDocument::getConstructor(exec, domObject->globalObject());
}

void JSDocument::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSDocument* thisObject = jsCast<JSDocument*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSDocument, Base>(exec, propertyName, value, &JSDocumentTable, thisObject, slot);
}

void setJSDocumentXMLVersion(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->setXMLVersion(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}


void setJSDocumentXMLStandalone(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->setXMLStandalone(value.toBoolean(exec), ec);
    setDOMException(exec, ec);
}


void setJSDocumentTitle(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setTitle(valueToStringWithNullCheck(exec, value));
}


void setJSDocumentDomain(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->setDomain(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}


void setJSDocumentCookie(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->setCookie(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}


void setJSDocumentBody(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->setBody(toHTMLElement(value), ec);
    setDOMException(exec, ec);
}


void setJSDocumentLocation(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    jsCast<JSDocument*>(thisObject)->setLocation(exec, value);
}


void setJSDocumentCharset(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setCharset(valueToStringWithNullCheck(exec, value));
}


void setJSDocumentSelectedStylesheetSet(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setSelectedStylesheetSet(valueToStringWithNullCheck(exec, value));
}


void setJSDocumentOnabort(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOnabort(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOnblur(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOnblur(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOnchange(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOnchange(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOnclick(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOnclick(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOncontextmenu(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOncontextmenu(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOndblclick(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOndblclick(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOndrag(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOndrag(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOndragend(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOndragend(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOndragenter(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOndragenter(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOndragleave(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOndragleave(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOndragover(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOndragover(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOndragstart(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOndragstart(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOndrop(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOndrop(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOnerror(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOnerror(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOnfocus(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOnfocus(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOninput(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOninput(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOninvalid(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOninvalid(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOnkeydown(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOnkeydown(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOnkeypress(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOnkeypress(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOnkeyup(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOnkeyup(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOnload(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOnload(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOnmousedown(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOnmousedown(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOnmousemove(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOnmousemove(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOnmouseout(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOnmouseout(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOnmouseover(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOnmouseover(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOnmouseup(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOnmouseup(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOnmousewheel(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOnmousewheel(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOnreadystatechange(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOnreadystatechange(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOnscroll(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOnscroll(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOnselect(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOnselect(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOnsubmit(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOnsubmit(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOnbeforecut(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOnbeforecut(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOncut(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOncut(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOnbeforecopy(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOnbeforecopy(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOncopy(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOncopy(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOnbeforepaste(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOnbeforepaste(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOnpaste(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOnpaste(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOnreset(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOnreset(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOnsearch(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOnsearch(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOnselectstart(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOnselectstart(createJSAttributeEventListener(exec, value, thisObject));
}


void setJSDocumentOnselectionchange(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOnselectionchange(createJSAttributeEventListener(exec, value, thisObject));
}


#if ENABLE(TOUCH_EVENTS)
void setJSDocumentOntouchstart(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOntouchstart(createJSAttributeEventListener(exec, value, thisObject));
}

#endif

#if ENABLE(TOUCH_EVENTS)
void setJSDocumentOntouchmove(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOntouchmove(createJSAttributeEventListener(exec, value, thisObject));
}

#endif

#if ENABLE(TOUCH_EVENTS)
void setJSDocumentOntouchend(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOntouchend(createJSAttributeEventListener(exec, value, thisObject));
}

#endif

#if ENABLE(TOUCH_EVENTS)
void setJSDocumentOntouchcancel(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOntouchcancel(createJSAttributeEventListener(exec, value, thisObject));
}

#endif

#if ENABLE(FULLSCREEN_API)
void setJSDocumentOnwebkitfullscreenchange(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOnwebkitfullscreenchange(createJSAttributeEventListener(exec, value, thisObject));
}

#endif

#if ENABLE(FULLSCREEN_API)
void setJSDocumentOnwebkitfullscreenerror(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOnwebkitfullscreenerror(createJSAttributeEventListener(exec, value, thisObject));
}

#endif

#if ENABLE(POINTER_LOCK)
void setJSDocumentOnwebkitpointerlockchange(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOnwebkitpointerlockchange(createJSAttributeEventListener(exec, value, thisObject));
}

#endif

#if ENABLE(POINTER_LOCK)
void setJSDocumentOnwebkitpointerlockerror(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(thisObject);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->setOnwebkitpointerlockerror(createJSAttributeEventListener(exec, value, thisObject));
}

#endif

JSValue JSDocument::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDocumentConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& tagName(valueToStringWithNullCheck(exec, MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJSNewlyCreated(exec, castedThis->globalObject(), WTF::getPtr(impl->createElement(tagName, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateDocumentFragment(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createDocumentFragment()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateTextNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    const String& data(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJSNewlyCreated(exec, castedThis->globalObject(), WTF::getPtr(impl->createTextNode(data)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateComment(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    const String& data(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJSNewlyCreated(exec, castedThis->globalObject(), WTF::getPtr(impl->createComment(data)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateCDATASection(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& data(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJSNewlyCreated(exec, castedThis->globalObject(), WTF::getPtr(impl->createCDATASection(data, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateProcessingInstruction(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& target(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& data(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJSNewlyCreated(exec, castedThis->globalObject(), WTF::getPtr(impl->createProcessingInstruction(target, data, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateAttribute(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& name(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJSNewlyCreated(exec, castedThis->globalObject(), WTF::getPtr(impl->createAttribute(name, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateEntityReference(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& name(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJSNewlyCreated(exec, castedThis->globalObject(), WTF::getPtr(impl->createEntityReference(name, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetElementsByTagName(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    const String& tagname(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getElementsByTagName(tagname)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionImportNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* importedNode(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 1) {

        JSC::JSValue result = toJSNewlyCreated(exec, castedThis->globalObject(), WTF::getPtr(impl->importNode(importedNode, ec)));
        setDOMException(exec, ec);
        return JSValue::encode(result);
    }

    bool deep(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJSNewlyCreated(exec, castedThis->globalObject(), WTF::getPtr(impl->importNode(importedNode, deep, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateElementNS(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& namespaceURI(valueToStringWithNullCheck(exec, MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& qualifiedName(valueToStringWithNullCheck(exec, MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJSNewlyCreated(exec, castedThis->globalObject(), WTF::getPtr(impl->createElementNS(namespaceURI, qualifiedName, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateAttributeNS(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& namespaceURI(valueToStringWithNullCheck(exec, MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& qualifiedName(valueToStringWithNullCheck(exec, MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJSNewlyCreated(exec, castedThis->globalObject(), WTF::getPtr(impl->createAttributeNS(namespaceURI, qualifiedName, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetElementsByTagNameNS(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    const String& namespaceURI(valueToStringWithNullCheck(exec, MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& localName(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getElementsByTagNameNS(namespaceURI, localName)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetElementById(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    const String& elementId(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getElementById(elementId)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionAdoptNode(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* source(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->adoptNode(source, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& eventType(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createEvent(eventType, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateRange(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createRange()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateNodeIterator(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* root(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned whatToShow(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    RefPtr<NodeFilter> filter(toNodeFilter(exec->globalData(), MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool expandEntityReferences(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createNodeIterator(root, whatToShow, filter.get(), expandEntityReferences, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateTreeWalker(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* root(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned whatToShow(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    RefPtr<NodeFilter> filter(toNodeFilter(exec->globalData(), MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool expandEntityReferences(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createTreeWalker(root, whatToShow, filter.get(), expandEntityReferences, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetOverrideStyle(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    Element* element(toElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& pseudoElement(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getOverrideStyle(element, pseudoElement)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateExpression(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& expression(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    RefPtr<XPathNSResolver> customResolver;
    XPathNSResolver* resolver = toXPathNSResolver(exec->argument(1));
    if (!resolver) {
        customResolver = JSCustomXPathNSResolver::create(exec, exec->argument(1));
        if (exec->hadException())
            return JSValue::encode(jsUndefined());
        resolver = customResolver.get();
    }

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createExpression(expression, resolver, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateNSResolver(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    Node* nodeResolver(toNode(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->createNSResolver(nodeResolver)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionEvaluate(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& expression(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    Node* contextNode(toNode(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    RefPtr<XPathNSResolver> customResolver;
    XPathNSResolver* resolver = toXPathNSResolver(exec->argument(2));
    if (!resolver) {
        customResolver = JSCustomXPathNSResolver::create(exec, exec->argument(2));
        if (exec->hadException())
            return JSValue::encode(jsUndefined());
        resolver = customResolver.get();
    }
    unsigned short type(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    XPathResult* inResult(toXPathResult(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->evaluate(expression, contextNode, resolver, type, inResult, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionExecCommand(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    const String& command(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool userInterface(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& value(valueToStringWithUndefinedOrNullCheck(exec, MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->execCommand(command, userInterface, value));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQueryCommandEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    const String& command(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->queryCommandEnabled(command));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQueryCommandIndeterm(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    const String& command(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->queryCommandIndeterm(command));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQueryCommandState(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    const String& command(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->queryCommandState(command));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQueryCommandSupported(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    const String& command(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->queryCommandSupported(command));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQueryCommandValue(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    const String& command(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->queryCommandValue(command));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetElementsByName(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    const String& elementName(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getElementsByName(elementName)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionElementFromPoint(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    int x(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int y(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->elementFromPoint(x, y)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCaretRangeFromPoint(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    int x(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int y(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->caretRangeFromPoint(x, y)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetSelection(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getSelection()));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetCSSCanvasContext(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (exec->argumentCount() < 4)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& contextId(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& name(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int width(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int height(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getCSSCanvasContext(contextId, name, width, height)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionGetElementsByClassName(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    const String& tagname(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getElementsByClassName(tagname)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQuerySelector(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& selectors(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->querySelector(selectors, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionQuerySelectorAll(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& selectors(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->querySelectorAll(selectors, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

#if ENABLE(POINTER_LOCK)
EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionWebkitExitPointerLock(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    impl->webkitExitPointerLock();
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(CSS_REGIONS)
EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionWebkitGetNamedFlows(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->webkitGetNamedFlows()));
    return JSValue::encode(result);
}

#endif

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateTouch(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    Document* impl = static_cast<Document*>(castedThis->impl());
    ExceptionCode ec = 0;
    DOMWindow* window(toDOMWindow(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    EventTarget* target(toEventTarget(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int identifier(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int pageX(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int pageY(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int screenX(MAYBE_MISSING_PARAMETER(exec, 5, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int screenY(MAYBE_MISSING_PARAMETER(exec, 6, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int webkitRadiusX(MAYBE_MISSING_PARAMETER(exec, 7, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    int webkitRadiusY(MAYBE_MISSING_PARAMETER(exec, 8, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float webkitRotationAngle(MAYBE_MISSING_PARAMETER(exec, 9, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    float webkitForce(MAYBE_MISSING_PARAMETER(exec, 10, DefaultIsUndefined).toFloat(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJSNewlyCreated(exec, castedThis->globalObject(), WTF::getPtr(impl->createTouch(window, target, identifier, pageX, pageY, screenX, screenY, webkitRadiusX, webkitRadiusY, webkitRotationAngle, webkitForce, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDocumentPrototypeFunctionCreateTouchList(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSDocument::s_info))
        return throwVMTypeError(exec);
    JSDocument* castedThis = jsCast<JSDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSDocument::s_info);
    return JSValue::encode(castedThis->createTouchList(exec));
}

Document* toDocument(JSC::JSValue value)
{
    return value.inherits(&JSDocument::s_info) ? jsCast<JSDocument*>(asObject(value))->impl() : 0;
}

}
