/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.22 from the
 * contents of GtkToolbar.xs. Do not edit this file, edit GtkToolbar.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "xs/GtkToolbar.xs"
/*
 * Copyright (c) 2003 by the gtk2-perl team (see the file AUTHORS)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the 
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
 * Boston, MA  02111-1307  USA.
 *
 * $Id$
 */

#include "gtk2perl.h"

/*
most of the insert/append/prepend functions do the same thing with one minor
change, or a change of signature.  all of them (except the ones dealing with
spaces because they're trivial) are corralled through 
gtk2perl_toolbar_insert_internal in a vain attempt to reduce code bloat
and duplicated code.
*/


typedef enum {
	ITEM,
	STOCK,
	ELEMENT,
	WIDGET
} WhichInsert;

typedef enum {
	PREPEND,
	APPEND,
	INSERT
} WhichOp;

#define SvGChar_ornull(sv)   (gperl_sv_is_defined((sv)) ? SvGChar ((sv)) : NULL)

static GtkWidget *
gtk2perl_toolbar_insert_internal (GtkToolbar * toolbar,
                                  SV * type,
				  SV * widget,
                                  SV * text,
				  SV * tooltip_text,
				  SV * tooltip_private_text,
				  SV * icon,
				  SV * callback,
				  SV * user_data,
				  SV * position,
				  WhichInsert which,
				  WhichOp op)
{
	GtkWidget * w = NULL;
	const char * real_tooltip_text = NULL;
	const char * real_tooltip_private_text = NULL;

	/* _ornull is not always right for text, but is for the others. */
	real_tooltip_text = SvGChar_ornull (tooltip_text);
	real_tooltip_private_text = SvGChar_ornull (tooltip_private_text);

	switch (which) {
	    case STOCK:
		/* stock with NULL text (the stock id) makes no sense,
		 * so let's make sure perl will issue an uninitialized
		 * value warning for undef passed here for text. */
		w = gtk_toolbar_insert_stock (toolbar, SvGChar (text),
		                              real_tooltip_text,
		                              real_tooltip_private_text,
		                              NULL, NULL, 
		                              SvIV (position));
		break;
	    case ITEM:
		{
		const gchar * real_text = SvGChar_ornull (text);
		GtkWidget * real_icon = SvGtkWidget_ornull (icon);
		switch (op) {
		    case PREPEND:
			w = gtk_toolbar_prepend_item (toolbar, real_text,
			                              real_tooltip_text,
			                              real_tooltip_private_text,
			                              real_icon, NULL, NULL);
			break;
		    case APPEND:
			w = gtk_toolbar_append_item (toolbar, real_text,
			                             real_tooltip_text,
			                             real_tooltip_private_text,
			                             real_icon, NULL, NULL);
			break;
		    case INSERT:
			w = gtk_toolbar_insert_item (toolbar, real_text,
			                             real_tooltip_text,
			                             real_tooltip_private_text,
			                             real_icon, NULL, NULL, 
			                             SvIV (position));
			break;
		    default:
			g_assert_not_reached ();
		}
		}
		break;
	    case ELEMENT:
		{
		GtkToolbarChildType real_type = SvGtkToolbarChildType(type);
		const gchar * real_text = SvGChar_ornull (text);
		GtkWidget * real_widget = SvGtkWidget_ornull (widget);
		GtkWidget * real_icon = SvGtkWidget_ornull (icon);
		switch (op) {
		    case PREPEND:
			w = gtk_toolbar_prepend_element (toolbar, real_type,
			                                 real_widget,
							 real_text,
							 real_tooltip_text,
							 real_tooltip_private_text,
							 real_icon,
							 NULL, NULL);
			break;
		    case APPEND:
			w = gtk_toolbar_append_element (toolbar, real_type,
			                                real_widget,
						        real_text,
						        real_tooltip_text,
						        real_tooltip_private_text,
						        real_icon,
						        NULL, NULL);
			break;
		    case INSERT:
			w = gtk_toolbar_insert_element (toolbar, real_type,
			                                real_widget,
						        real_text,
						        real_tooltip_text,
						        real_tooltip_private_text,
						        real_icon,
						        NULL, NULL,
			                                SvIV (position));
			break;
		    default:
			g_assert_not_reached ();
		}
		}
		break;
	    case WIDGET:
		{
		w = SvGtkWidget (widget);
		switch (op) {
		    case PREPEND:
			gtk_toolbar_prepend_widget (toolbar, w,
			                            real_tooltip_text,
			                            real_tooltip_private_text);
			break;
		    case APPEND:
			gtk_toolbar_append_widget (toolbar, w,
			                           real_tooltip_text,
			                           real_tooltip_private_text);
			break;
		    case INSERT:
			gtk_toolbar_insert_widget (toolbar, w,
			                           real_tooltip_text,
			                           real_tooltip_private_text,
						   SvIV (position));
			break;
		    default:
			g_assert_not_reached ();
		}
		}
		break;
		default:
			g_assert_not_reached ();
	}
	if (gperl_sv_is_defined (callback))
		gperl_signal_connect (newSVGtkWidget (w), "clicked",
		                      callback, user_data, 0);

	return w;
}


#line 196 "xs/GtkToolbar.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
            Perl_croak(aTHX_ "Usage: %s::%s(%s)", hvname, gvname, params);
        else
            Perl_croak(aTHX_ "Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
        Perl_croak(aTHX_ "Usage: CODE(0x%"UVxf")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#ifdef PERL_IMPLICIT_CONTEXT
#define croak_xs_usage(a,b)    S_croak_xs_usage(aTHX_ a,b)
#else
#define croak_xs_usage        S_croak_xs_usage
#endif

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#line 338 "xs/GtkToolbar.c"

XS_EUPXS(XS_Gtk2__Toolbar_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Toolbar_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "class");
    {
	GtkWidget *	RETVAL;

	RETVAL = gtk_toolbar_new(/* void */);
	ST(0) = newSVGtkWidget (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}

#if GTK_CHECK_VERSION(2,4,0)
#define XSubPPtmpAAAA 1


XS_EUPXS(XS_Gtk2__Toolbar_insert); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Toolbar_insert)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "toolbar, item, pos");
    {
	GtkToolbar *	toolbar = SvGtkToolbar (ST(0))
;
	GtkToolItem *	item = SvGtkToolItem (ST(1))
;
	gint	pos = (gint)SvIV(ST(2))
;

	gtk_toolbar_insert(toolbar, item, pos);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gtk2__Toolbar_get_item_index); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Toolbar_get_item_index)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "toolbar, item");
    {
	gint	RETVAL;
	dXSTARG;
	GtkToolbar *	toolbar = SvGtkToolbar (ST(0))
;
	GtkToolItem *	item = SvGtkToolItem (ST(1))
;

	RETVAL = gtk_toolbar_get_item_index(toolbar, item);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Toolbar_get_n_items); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Toolbar_get_n_items)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "toolbar");
    {
	gint	RETVAL;
	dXSTARG;
	GtkToolbar *	toolbar = SvGtkToolbar (ST(0))
;

	RETVAL = gtk_toolbar_get_n_items(toolbar);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Toolbar_get_nth_item); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Toolbar_get_nth_item)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "toolbar, n");
    {
	GtkToolItem_ornull *	RETVAL;
	GtkToolbar *	toolbar = SvGtkToolbar (ST(0))
;
	gint	n = (gint)SvIV(ST(1))
;

	RETVAL = gtk_toolbar_get_nth_item(toolbar, n);
	ST(0) = newSVGtkToolItem_ornull (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Toolbar_get_show_arrow); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Toolbar_get_show_arrow)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "toolbar");
    {
	gboolean	RETVAL;
	GtkToolbar *	toolbar = SvGtkToolbar (ST(0))
;

	RETVAL = gtk_toolbar_get_show_arrow(toolbar);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Toolbar_set_show_arrow); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Toolbar_set_show_arrow)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "toolbar, show_arrow");
    {
	GtkToolbar *	toolbar = SvGtkToolbar (ST(0))
;
	gboolean	show_arrow = (bool)SvTRUE(ST(1))
;

	gtk_toolbar_set_show_arrow(toolbar, show_arrow);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gtk2__Toolbar_get_relief_style); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Toolbar_get_relief_style)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "toolbar");
    {
	GtkReliefStyle	RETVAL;
	GtkToolbar *	toolbar = SvGtkToolbar (ST(0))
;

	RETVAL = gtk_toolbar_get_relief_style(toolbar);
	ST(0) = newSVGtkReliefStyle (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Toolbar_get_drop_index); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Toolbar_get_drop_index)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "toolbar, x, y");
    {
	gint	RETVAL;
	dXSTARG;
	GtkToolbar *	toolbar = SvGtkToolbar (ST(0))
;
	gint	x = (gint)SvIV(ST(1))
;
	gint	y = (gint)SvIV(ST(2))
;

	RETVAL = gtk_toolbar_get_drop_index(toolbar, x, y);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Toolbar_set_drop_highlight_item); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Toolbar_set_drop_highlight_item)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "toolbar, tool_item, index");
    {
	GtkToolbar *	toolbar = SvGtkToolbar (ST(0))
;
	GtkToolItem_ornull *	tool_item = SvGtkToolItem_ornull (ST(1))
;
	gint	index = (gint)SvIV(ST(2))
;

	gtk_toolbar_set_drop_highlight_item(toolbar, tool_item, index);
    }
    XSRETURN_EMPTY;
}

#endif

XS_EUPXS(XS_Gtk2__Toolbar_append_item); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Toolbar_append_item)
{
    dVAR; dXSARGS;
    if (items < 5 || items > 7)
       croak_xs_usage(cv,  "toolbar, text, tooltip_text, tooltip_private_text, icon, callback=NULL, user_data=NULL");
    {
	GtkToolbar *	toolbar = SvGtkToolbar (ST(0))
;
	SV *	text = ST(1)
;
	SV *	tooltip_text = ST(2)
;
	SV *	tooltip_private_text = ST(3)
;
	SV *	icon = ST(4)
;
	SV *	callback;
	SV *	user_data;
	GtkWidget *	RETVAL;

	if (items < 6)
	    callback = NULL;
	else {
	    callback = ST(5)
;
	}

	if (items < 7)
	    user_data = NULL;
	else {
	    user_data = ST(6)
;
	}
#line 239 "xs/GtkToolbar.xs"
	RETVAL = gtk2perl_toolbar_insert_internal (toolbar,
	                                           NULL, /* type */
	                                           NULL, /* widget */
	                                           text,
	                                           tooltip_text,
	                                           tooltip_private_text,
	                                           icon,
	                                           callback,
	                                           user_data,
	                                           NULL, /* position */
	                                           ITEM,
	                                           APPEND);
#line 587 "xs/GtkToolbar.c"
	ST(0) = newSVGtkWidget (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Toolbar_prepend_item); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Toolbar_prepend_item)
{
    dVAR; dXSARGS;
    if (items < 5 || items > 7)
       croak_xs_usage(cv,  "toolbar, text, tooltip_text, tooltip_private_text, icon, callback=NULL, user_data=NULL");
    {
	GtkToolbar *	toolbar = SvGtkToolbar (ST(0))
;
	SV *	text = ST(1)
;
	SV *	tooltip_text = ST(2)
;
	SV *	tooltip_private_text = ST(3)
;
	SV *	icon = ST(4)
;
	SV *	callback;
	SV *	user_data;
	GtkWidget *	RETVAL;

	if (items < 6)
	    callback = NULL;
	else {
	    callback = ST(5)
;
	}

	if (items < 7)
	    user_data = NULL;
	else {
	    user_data = ST(6)
;
	}
#line 272 "xs/GtkToolbar.xs"
	RETVAL = gtk2perl_toolbar_insert_internal (toolbar,
	                                           NULL, /* type */
	                                           NULL, /* widget */
	                                           text,
	                                           tooltip_text,
	                                           tooltip_private_text,
	                                           icon,
	                                           callback,
	                                           user_data,
	                                           NULL, /* position */
	                                           ITEM,
	                                           PREPEND);
#line 642 "xs/GtkToolbar.c"
	ST(0) = newSVGtkWidget (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Toolbar_insert_item); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Toolbar_insert_item)
{
    dVAR; dXSARGS;
    if (items != 8)
       croak_xs_usage(cv,  "toolbar, text, tooltip_text, tooltip_private_text, icon, callback, user_data, position");
    {
	GtkToolbar *	toolbar = SvGtkToolbar (ST(0))
;
	SV *	text = ST(1)
;
	SV *	tooltip_text = ST(2)
;
	SV *	tooltip_private_text = ST(3)
;
	SV *	icon = ST(4)
;
	SV *	callback = ST(5)
;
	SV *	user_data = ST(6)
;
	SV *	position = ST(7)
;
	GtkWidget *	RETVAL;
#line 307 "xs/GtkToolbar.xs"
	RETVAL = gtk2perl_toolbar_insert_internal (toolbar,
	                                           NULL, /* type, */
	                                           NULL, /* widget, */
	                                           text,
	                                           tooltip_text,
	                                           tooltip_private_text,
	                                           icon,
	                                           callback,
	                                           user_data,
	                                           position,
	                                           ITEM,
	                                           INSERT);
#line 687 "xs/GtkToolbar.c"
	ST(0) = newSVGtkWidget (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Toolbar_insert_stock); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Toolbar_insert_stock)
{
    dVAR; dXSARGS;
    if (items != 7)
       croak_xs_usage(cv,  "toolbar, stock_id, tooltip_text, tooltip_private_text, callback, user_data, position");
    {
	GtkToolbar *	toolbar = SvGtkToolbar (ST(0))
;
	SV *	stock_id = ST(1)
;
	SV *	tooltip_text = ST(2)
;
	SV *	tooltip_private_text = ST(3)
;
	SV *	callback = ST(4)
;
	SV *	user_data = ST(5)
;
	SV *	position = ST(6)
;
	GtkWidget *	RETVAL;
#line 341 "xs/GtkToolbar.xs"
	RETVAL = gtk2perl_toolbar_insert_internal (toolbar,
	                                           NULL, /* type, */
	                                           NULL, /* widget, */
	                                           stock_id,
	                                           tooltip_text,
	                                           tooltip_private_text,
	                                           NULL, /* icon, */
	                                           callback,
	                                           user_data,
	                                           position,
	                                           STOCK,
	                                           INSERT);
#line 730 "xs/GtkToolbar.c"
	ST(0) = newSVGtkWidget (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Toolbar_prepend_element); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Toolbar_prepend_element)
{
    dVAR; dXSARGS;
    if (items < 7 || items > 9)
       croak_xs_usage(cv,  "toolbar, type, widget, text, tooltip_text, tooltip_private_text, icon, callback=NULL, user_data=NULL");
    {
	GtkToolbar *	toolbar = SvGtkToolbar (ST(0))
;
	SV *	type = ST(1)
;
	SV *	widget = ST(2)
;
	SV *	text = ST(3)
;
	SV *	tooltip_text = ST(4)
;
	SV *	tooltip_private_text = ST(5)
;
	SV *	icon = ST(6)
;
	SV *	callback;
	SV *	user_data;
	GtkWidget *	RETVAL;

	if (items < 8)
	    callback = NULL;
	else {
	    callback = ST(7)
;
	}

	if (items < 9)
	    user_data = NULL;
	else {
	    user_data = ST(8)
;
	}
#line 379 "xs/GtkToolbar.xs"
	RETVAL = gtk2perl_toolbar_insert_internal (toolbar,
	                                           type,
	                                           widget,
	                                           text,
	                                           tooltip_text,
	                                           tooltip_private_text,
	                                           icon,
	                                           callback,
	                                           user_data,
	                                           NULL, /* position, */
	                                           ELEMENT,
	                                           PREPEND);
#line 789 "xs/GtkToolbar.c"
	ST(0) = newSVGtkWidget (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Toolbar_insert_element); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Toolbar_insert_element)
{
    dVAR; dXSARGS;
    if (items != 10)
       croak_xs_usage(cv,  "toolbar, type, widget, text, tooltip_text, tooltip_private_text, icon, callback, user_data, position");
    {
	GtkToolbar *	toolbar = SvGtkToolbar (ST(0))
;
	SV *	type = ST(1)
;
	SV *	widget = ST(2)
;
	SV *	text = ST(3)
;
	SV *	tooltip_text = ST(4)
;
	SV *	tooltip_private_text = ST(5)
;
	SV *	icon = ST(6)
;
	SV *	callback = ST(7)
;
	SV *	user_data = ST(8)
;
	SV *	position = ST(9)
;
	GtkWidget *	RETVAL;
#line 418 "xs/GtkToolbar.xs"
	RETVAL = gtk2perl_toolbar_insert_internal (toolbar,
	                                           type,
	                                           widget,
	                                           text,
	                                           tooltip_text,
	                                           tooltip_private_text,
	                                           icon,
	                                           callback,
	                                           user_data,
	                                           position,
	                                           ELEMENT,
	                                           INSERT);
#line 838 "xs/GtkToolbar.c"
	ST(0) = newSVGtkWidget (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Toolbar_append_element); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Toolbar_append_element)
{
    dVAR; dXSARGS;
    if (items < 7 || items > 9)
       croak_xs_usage(cv,  "toolbar, type, widget, text, tooltip_text, tooltip_private_text, icon, callback=NULL, user_data=NULL");
    {
	GtkToolbar *	toolbar = SvGtkToolbar (ST(0))
;
	SV *	type = ST(1)
;
	SV *	widget = ST(2)
;
	SV *	text = ST(3)
;
	SV *	tooltip_text = ST(4)
;
	SV *	tooltip_private_text = ST(5)
;
	SV *	icon = ST(6)
;
	SV *	callback;
	SV *	user_data;
	GtkWidget *	RETVAL;

	if (items < 8)
	    callback = NULL;
	else {
	    callback = ST(7)
;
	}

	if (items < 9)
	    user_data = NULL;
	else {
	    user_data = ST(8)
;
	}
#line 455 "xs/GtkToolbar.xs"
	RETVAL = gtk2perl_toolbar_insert_internal (toolbar,
	                                           type,
	                                           widget,
	                                           text,
	                                           tooltip_text,
	                                           tooltip_private_text,
	                                           icon,
	                                           callback,
	                                           user_data,
	                                           NULL, /* position, */
	                                           ELEMENT,
	                                           APPEND);
#line 897 "xs/GtkToolbar.c"
	ST(0) = newSVGtkWidget (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Toolbar_prepend_widget); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Toolbar_prepend_widget)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "toolbar, widget, tooltip_text, tooltip_private_text");
    {
	GtkToolbar *	toolbar = SvGtkToolbar (ST(0))
;
	SV *	widget = ST(1)
;
	SV *	tooltip_text = ST(2)
;
	SV *	tooltip_private_text = ST(3)
;
#line 483 "xs/GtkToolbar.xs"
	gtk2perl_toolbar_insert_internal (toolbar,
	                                  NULL, /* type, */
	                                  widget,
	                                  NULL, /* text, */
	                                  tooltip_text,
	                                  tooltip_private_text,
	                                  NULL, /* icon, */
	                                  NULL, /* callback, */
	                                  NULL, /* user_data, */
	                                  NULL, /* position, */
	                                  WIDGET,
	                                  PREPEND);
#line 933 "xs/GtkToolbar.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gtk2__Toolbar_insert_widget); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Toolbar_insert_widget)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "toolbar, widget, tooltip_text, tooltip_private_text, position");
    {
	GtkToolbar *	toolbar = SvGtkToolbar (ST(0))
;
	SV *	widget = ST(1)
;
	SV *	tooltip_text = ST(2)
;
	SV *	tooltip_private_text = ST(3)
;
	SV *	position = ST(4)
;
#line 511 "xs/GtkToolbar.xs"
	gtk2perl_toolbar_insert_internal (toolbar,
	                                  NULL, /* type, */
	                                  widget,
	                                  NULL, /* text, */
	                                  tooltip_text,
	                                  tooltip_private_text,
	                                  NULL, /* icon, */
	                                  NULL, /* callback, */
	                                  NULL, /* user_data, */
	                                  position,
	                                  WIDGET,
	                                  INSERT);
#line 969 "xs/GtkToolbar.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gtk2__Toolbar_append_widget); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Toolbar_append_widget)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "toolbar, widget, tooltip_text, tooltip_private_text");
    {
	GtkToolbar *	toolbar = SvGtkToolbar (ST(0))
;
	SV *	widget = ST(1)
;
	SV *	tooltip_text = ST(2)
;
	SV *	tooltip_private_text = ST(3)
;
#line 537 "xs/GtkToolbar.xs"
	gtk2perl_toolbar_insert_internal (toolbar,
	                                  NULL, /* type, */
	                                  widget,
	                                  NULL, /* text, */
	                                  tooltip_text,
	                                  tooltip_private_text,
	                                  NULL, /* icon, */
	                                  NULL, /* callback, */
	                                  NULL, /* user_data, */
	                                  NULL, /* position, */
	                                  WIDGET,
	                                  APPEND);
#line 1003 "xs/GtkToolbar.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gtk2__Toolbar_prepend_space); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Toolbar_prepend_space)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "toolbar");
    {
	GtkToolbar *	toolbar = SvGtkToolbar (ST(0))
;

	gtk_toolbar_prepend_space(toolbar);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gtk2__Toolbar_insert_space); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Toolbar_insert_space)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "toolbar, position");
    {
	GtkToolbar *	toolbar = SvGtkToolbar (ST(0))
;
	gint	position = (gint)SvIV(ST(1))
;

	gtk_toolbar_insert_space(toolbar, position);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gtk2__Toolbar_append_space); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Toolbar_append_space)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "toolbar");
    {
	GtkToolbar *	toolbar = SvGtkToolbar (ST(0))
;

	gtk_toolbar_append_space(toolbar);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gtk2__Toolbar_remove_space); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Toolbar_remove_space)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "toolbar, position");
    {
	GtkToolbar *	toolbar = SvGtkToolbar (ST(0))
;
	gint	position = (gint)SvIV(ST(1))
;

	gtk_toolbar_remove_space(toolbar, position);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gtk2__Toolbar_set_style); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Toolbar_set_style)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "toolbar, style");
    {
	GtkToolbar *	toolbar = SvGtkToolbar (ST(0))
;
	GtkToolbarStyle	style = SvGtkToolbarStyle (ST(1))
;

	gtk_toolbar_set_style(toolbar, style);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gtk2__Toolbar_set_icon_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Toolbar_set_icon_size)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "toolbar, icon_size");
    {
	GtkToolbar *	toolbar = SvGtkToolbar (ST(0))
;
	GtkIconSize	icon_size = SvGtkIconSize (ST(1))
;

	gtk_toolbar_set_icon_size(toolbar, icon_size);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gtk2__Toolbar_set_tooltips); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Toolbar_set_tooltips)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "toolbar, enable");
    {
	GtkToolbar *	toolbar = SvGtkToolbar (ST(0))
;
	gboolean	enable = (bool)SvTRUE(ST(1))
;

	gtk_toolbar_set_tooltips(toolbar, enable);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gtk2__Toolbar_unset_style); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Toolbar_unset_style)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "toolbar");
    {
	GtkToolbar *	toolbar = SvGtkToolbar (ST(0))
;

	gtk_toolbar_unset_style(toolbar);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gtk2__Toolbar_unset_icon_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Toolbar_unset_icon_size)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "toolbar");
    {
	GtkToolbar *	toolbar = SvGtkToolbar (ST(0))
;

	gtk_toolbar_unset_icon_size(toolbar);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gtk2__Toolbar_get_orientation); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Toolbar_get_orientation)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "toolbar");
    {
	GtkToolbar *	toolbar = SvGtkToolbar (ST(0))
;
	GtkOrientation	RETVAL;

	RETVAL = gtk_toolbar_get_orientation(toolbar);
	ST(0) = newSVGtkOrientation (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Toolbar_get_style); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Toolbar_get_style)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "toolbar");
    {
	GtkToolbar *	toolbar = SvGtkToolbar (ST(0))
;
	GtkToolbarStyle	RETVAL;

	RETVAL = gtk_toolbar_get_style(toolbar);
	ST(0) = newSVGtkToolbarStyle (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Toolbar_get_icon_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Toolbar_get_icon_size)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "toolbar");
    {
	GtkToolbar *	toolbar = SvGtkToolbar (ST(0))
;
	GtkIconSize	RETVAL;

	RETVAL = gtk_toolbar_get_icon_size(toolbar);
	ST(0) = newSVGtkIconSize (RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Toolbar_get_tooltips); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Toolbar_get_tooltips)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "toolbar");
    {
	GtkToolbar *	toolbar = SvGtkToolbar (ST(0))
;
	gboolean	RETVAL;

	RETVAL = gtk_toolbar_get_tooltips(toolbar);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gtk2__Toolbar_set_orientation); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gtk2__Toolbar_set_orientation)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "toolbar, orientation");
    {
	GtkToolbar *	toolbar = SvGtkToolbar (ST(0))
;
	GtkOrientation	orientation = SvGtkOrientation (ST(1))
;

	gtk_toolbar_set_orientation(toolbar, orientation);
    }
    XSRETURN_EMPTY;
}

#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_Gtk2__Toolbar); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Gtk2__Toolbar)
{
    dVAR; dXSARGS;
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#endif
    XS_VERSION_BOOTCHECK;

        newXS("Gtk2::Toolbar::new", XS_Gtk2__Toolbar_new, file);
#if XSubPPtmpAAAA
        newXS("Gtk2::Toolbar::insert", XS_Gtk2__Toolbar_insert, file);
        newXS("Gtk2::Toolbar::get_item_index", XS_Gtk2__Toolbar_get_item_index, file);
        newXS("Gtk2::Toolbar::get_n_items", XS_Gtk2__Toolbar_get_n_items, file);
        newXS("Gtk2::Toolbar::get_nth_item", XS_Gtk2__Toolbar_get_nth_item, file);
        newXS("Gtk2::Toolbar::get_show_arrow", XS_Gtk2__Toolbar_get_show_arrow, file);
        newXS("Gtk2::Toolbar::set_show_arrow", XS_Gtk2__Toolbar_set_show_arrow, file);
        newXS("Gtk2::Toolbar::get_relief_style", XS_Gtk2__Toolbar_get_relief_style, file);
        newXS("Gtk2::Toolbar::get_drop_index", XS_Gtk2__Toolbar_get_drop_index, file);
        newXS("Gtk2::Toolbar::set_drop_highlight_item", XS_Gtk2__Toolbar_set_drop_highlight_item, file);
#endif
        newXS("Gtk2::Toolbar::append_item", XS_Gtk2__Toolbar_append_item, file);
        newXS("Gtk2::Toolbar::prepend_item", XS_Gtk2__Toolbar_prepend_item, file);
        newXS("Gtk2::Toolbar::insert_item", XS_Gtk2__Toolbar_insert_item, file);
        newXS("Gtk2::Toolbar::insert_stock", XS_Gtk2__Toolbar_insert_stock, file);
        newXS("Gtk2::Toolbar::prepend_element", XS_Gtk2__Toolbar_prepend_element, file);
        newXS("Gtk2::Toolbar::insert_element", XS_Gtk2__Toolbar_insert_element, file);
        newXS("Gtk2::Toolbar::append_element", XS_Gtk2__Toolbar_append_element, file);
        newXS("Gtk2::Toolbar::prepend_widget", XS_Gtk2__Toolbar_prepend_widget, file);
        newXS("Gtk2::Toolbar::insert_widget", XS_Gtk2__Toolbar_insert_widget, file);
        newXS("Gtk2::Toolbar::append_widget", XS_Gtk2__Toolbar_append_widget, file);
        newXS("Gtk2::Toolbar::prepend_space", XS_Gtk2__Toolbar_prepend_space, file);
        newXS("Gtk2::Toolbar::insert_space", XS_Gtk2__Toolbar_insert_space, file);
        newXS("Gtk2::Toolbar::append_space", XS_Gtk2__Toolbar_append_space, file);
        newXS("Gtk2::Toolbar::remove_space", XS_Gtk2__Toolbar_remove_space, file);
        newXS("Gtk2::Toolbar::set_style", XS_Gtk2__Toolbar_set_style, file);
        newXS("Gtk2::Toolbar::set_icon_size", XS_Gtk2__Toolbar_set_icon_size, file);
        newXS("Gtk2::Toolbar::set_tooltips", XS_Gtk2__Toolbar_set_tooltips, file);
        newXS("Gtk2::Toolbar::unset_style", XS_Gtk2__Toolbar_unset_style, file);
        newXS("Gtk2::Toolbar::unset_icon_size", XS_Gtk2__Toolbar_unset_icon_size, file);
        newXS("Gtk2::Toolbar::get_orientation", XS_Gtk2__Toolbar_get_orientation, file);
        newXS("Gtk2::Toolbar::get_style", XS_Gtk2__Toolbar_get_style, file);
        newXS("Gtk2::Toolbar::get_icon_size", XS_Gtk2__Toolbar_get_icon_size, file);
        newXS("Gtk2::Toolbar::get_tooltips", XS_Gtk2__Toolbar_get_tooltips, file);
        newXS("Gtk2::Toolbar::set_orientation", XS_Gtk2__Toolbar_set_orientation, file);

    /* Initialisation Section */

#if XSubPPtmpAAAA
#endif
#line 1316 "xs/GtkToolbar.c"

    /* End of Initialisation Section */

#if (PERL_REVISION == 5 && PERL_VERSION >= 9)
  if (PL_unitcheckav)
       call_list(PL_scopestack_ix, PL_unitcheckav);
#endif
    XSRETURN_YES;
}

