#line 5 "../../nc_test/test_put.m4"
/* Do not edit this file. It is produced from the corresponding .m4 source */
#line 7
/*********************************************************************
 *   Copyright 1996, UCAR/Unidata
 *   See netcdf/COPYRIGHT file for copying and redistribution conditions.
 *   $Id: test_put.m4,v 1.25 2005/03/08 03:04:19 ed Exp $
 *********************************************************************/

#line 31

#include "tests.h"

#line 55

/*
#line 56
 *  ensure hash value within range for internal TYPE
#line 56
 */
#line 56
static
#line 56
double
#line 56
hash_text(
#line 56
    const nc_type type,
#line 56
    const int rank,
#line 56
    const size_t *index,
#line 56
    const nct_itype itype)
#line 56
{
#line 56
    const double min = text_min;
#line 56
    const double max = text_max;
#line 56

#line 56
    return MAX(min, MIN(max, hash4( type, rank, index, itype)));
#line 56
}
#line 56

/*
#line 57
 *  ensure hash value within range for internal TYPE
#line 57
 */
#line 57
static
#line 57
double
#line 57
hash_uchar(
#line 57
    const nc_type type,
#line 57
    const int rank,
#line 57
    const size_t *index,
#line 57
    const nct_itype itype)
#line 57
{
#line 57
    const double min = uchar_min;
#line 57
    const double max = uchar_max;
#line 57

#line 57
    return MAX(min, MIN(max, hash4( type, rank, index, itype)));
#line 57
}
#line 57

/*
#line 58
 *  ensure hash value within range for internal TYPE
#line 58
 */
#line 58
static
#line 58
double
#line 58
hash_schar(
#line 58
    const nc_type type,
#line 58
    const int rank,
#line 58
    const size_t *index,
#line 58
    const nct_itype itype)
#line 58
{
#line 58
    const double min = schar_min;
#line 58
    const double max = schar_max;
#line 58

#line 58
    return MAX(min, MIN(max, hash4( type, rank, index, itype)));
#line 58
}
#line 58

/*
#line 59
 *  ensure hash value within range for internal TYPE
#line 59
 */
#line 59
static
#line 59
double
#line 59
hash_short(
#line 59
    const nc_type type,
#line 59
    const int rank,
#line 59
    const size_t *index,
#line 59
    const nct_itype itype)
#line 59
{
#line 59
    const double min = short_min;
#line 59
    const double max = short_max;
#line 59

#line 59
    return MAX(min, MIN(max, hash4( type, rank, index, itype)));
#line 59
}
#line 59

/*
#line 60
 *  ensure hash value within range for internal TYPE
#line 60
 */
#line 60
static
#line 60
double
#line 60
hash_int(
#line 60
    const nc_type type,
#line 60
    const int rank,
#line 60
    const size_t *index,
#line 60
    const nct_itype itype)
#line 60
{
#line 60
    const double min = int_min;
#line 60
    const double max = int_max;
#line 60

#line 60
    return MAX(min, MIN(max, hash4( type, rank, index, itype)));
#line 60
}
#line 60

/*
#line 61
 *  ensure hash value within range for internal TYPE
#line 61
 */
#line 61
static
#line 61
double
#line 61
hash_long(
#line 61
    const nc_type type,
#line 61
    const int rank,
#line 61
    const size_t *index,
#line 61
    const nct_itype itype)
#line 61
{
#line 61
    const double min = long_min;
#line 61
    const double max = long_max;
#line 61

#line 61
    return MAX(min, MIN(max, hash4( type, rank, index, itype)));
#line 61
}
#line 61

/*
#line 62
 *  ensure hash value within range for internal TYPE
#line 62
 */
#line 62
static
#line 62
double
#line 62
hash_float(
#line 62
    const nc_type type,
#line 62
    const int rank,
#line 62
    const size_t *index,
#line 62
    const nct_itype itype)
#line 62
{
#line 62
    const double min = float_min;
#line 62
    const double max = float_max;
#line 62

#line 62
    return MAX(min, MIN(max, hash4( type, rank, index, itype)));
#line 62
}
#line 62

/*
#line 63
 *  ensure hash value within range for internal TYPE
#line 63
 */
#line 63
static
#line 63
double
#line 63
hash_double(
#line 63
    const nc_type type,
#line 63
    const int rank,
#line 63
    const size_t *index,
#line 63
    const nct_itype itype)
#line 63
{
#line 63
    const double min = double_min;
#line 63
    const double max = double_max;
#line 63

#line 63
    return MAX(min, MIN(max, hash4( type, rank, index, itype)));
#line 63
}
#line 63



#line 154

/* 
#line 155
 *  check all vars in file which are (text/numeric) compatible with TYPE
#line 155
 */
#line 155
static
#line 155
void
#line 155
check_vars_text(const char *filename)
#line 155
{
#line 155
    int  ncid;                  /* netCDF id */
#line 155
    size_t index[MAX_RANK];
#line 155
    int  err;           /* status */
#line 155
    int  d;
#line 155
    int  i;
#line 155
    size_t  j;
#line 155
    text value;
#line 155
    nc_type datatype;
#line 155
    int ndims;
#line 155
    int dimids[MAX_RANK];
#line 155
    double expect;
#line 155
    char name[NC_MAX_NAME];
#line 155
    size_t length;
#line 155
    int canConvert;     /* Both text or both numeric */
#line 155
    int nok = 0;      /* count of valid comparisons */
#line 155

#line 155
    err = nc_open(filename, NC_NOWRITE, &ncid);
#line 155
    IF (err)
#line 155
        error("nc_open: %s", nc_strerror(err));
#line 155

#line 155
    for (i = 0; i < NVARS; i++) {
#line 155
	canConvert = (var_type[i] == NC_CHAR) == (NCT_TEXT == NCT_TEXT);
#line 155
	if (canConvert) {
#line 155
	    err = nc_inq_var(ncid, i, name, &datatype, &ndims, dimids, NULL);
#line 155
	    IF (err)
#line 155
		error("nc_inq_var: %s", nc_strerror(err));
#line 155
	    IF (strcmp(name, var_name[i]) != 0)
#line 155
		error("Unexpected var_name");
#line 155
	    IF (datatype != var_type[i])
#line 155
		error("Unexpected type");
#line 155
	    IF (ndims != var_rank[i])
#line 155
		error("Unexpected rank");
#line 155
	    for (j = 0; j < ndims; j++) {
#line 155
		err = nc_inq_dim(ncid, dimids[j], 0, &length);
#line 155
		IF (err)
#line 155
		    error("nc_inq_dim: %s", nc_strerror(err));
#line 155
		IF (length != var_shape[i][j])
#line 155
		    error("Unexpected shape");
#line 155
	    }
#line 155
	    for (j = 0; j < var_nels[i]; j++) {
#line 155
		err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 155
		IF (err)
#line 155
		    error("error in toMixedBase 2");
#line 155
		expect = hash4( var_type[i], var_rank[i], index, NCT_TEXT);
#line 155
		err = nc_get_var1_text(ncid, i, index, &value);
#line 155
		if (inRange3(expect,datatype,NCT_TEXT)) {
#line 155
                    if (expect >= text_min && expect <= text_max) {
#line 155
			IF (err) {
#line 155
			    error("nc_get_var1_text: %s", nc_strerror(err));
#line 155
			} else {
#line 155
                            IF (!equal(value,expect,var_type[i],NCT_TEXT)) {
#line 155
				error("Var value read not that expected");
#line 155
				if (verbose) {
#line 155
				    error("\n");
#line 155
				    error("varid: %d, ", i);
#line 155
				    error("var_name: %s, ", var_name[i]);
#line 155
				    error("index:");
#line 155
				    for (d = 0; d < var_rank[i]; d++)
#line 155
					error(" %d", index[d]);
#line 155
				    error(", expect: %g, ", expect);
#line 155
				    error("got: %g", (double) value);
#line 155
				}
#line 155
			    } else {
#line 155
				++nok;
#line 155
			    }
#line 155
			}
#line 155
		    }
#line 155
		}
#line 155
	    }
#line 155
	}
#line 155
    }
#line 155
    err = nc_close (ncid);
#line 155
    IF (err)
#line 155
        error("nc_close: %s", nc_strerror(err));
#line 155
    print_nok(nok);
#line 155
}
#line 155

/* 
#line 156
 *  check all vars in file which are (text/numeric) compatible with TYPE
#line 156
 */
#line 156
static
#line 156
void
#line 156
check_vars_uchar(const char *filename)
#line 156
{
#line 156
    int  ncid;                  /* netCDF id */
#line 156
    size_t index[MAX_RANK];
#line 156
    int  err;           /* status */
#line 156
    int  d;
#line 156
    int  i;
#line 156
    size_t  j;
#line 156
    uchar value;
#line 156
    nc_type datatype;
#line 156
    int ndims;
#line 156
    int dimids[MAX_RANK];
#line 156
    double expect;
#line 156
    char name[NC_MAX_NAME];
#line 156
    size_t length;
#line 156
    int canConvert;     /* Both text or both numeric */
#line 156
    int nok = 0;      /* count of valid comparisons */
#line 156

#line 156
    err = nc_open(filename, NC_NOWRITE, &ncid);
#line 156
    IF (err)
#line 156
        error("nc_open: %s", nc_strerror(err));
#line 156

#line 156
    for (i = 0; i < NVARS; i++) {
#line 156
	canConvert = (var_type[i] == NC_CHAR) == (NCT_UCHAR == NCT_TEXT);
#line 156
	if (canConvert) {
#line 156
	    err = nc_inq_var(ncid, i, name, &datatype, &ndims, dimids, NULL);
#line 156
	    IF (err)
#line 156
		error("nc_inq_var: %s", nc_strerror(err));
#line 156
	    IF (strcmp(name, var_name[i]) != 0)
#line 156
		error("Unexpected var_name");
#line 156
	    IF (datatype != var_type[i])
#line 156
		error("Unexpected type");
#line 156
	    IF (ndims != var_rank[i])
#line 156
		error("Unexpected rank");
#line 156
	    for (j = 0; j < ndims; j++) {
#line 156
		err = nc_inq_dim(ncid, dimids[j], 0, &length);
#line 156
		IF (err)
#line 156
		    error("nc_inq_dim: %s", nc_strerror(err));
#line 156
		IF (length != var_shape[i][j])
#line 156
		    error("Unexpected shape");
#line 156
	    }
#line 156
	    for (j = 0; j < var_nels[i]; j++) {
#line 156
		err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 156
		IF (err)
#line 156
		    error("error in toMixedBase 2");
#line 156
		expect = hash4( var_type[i], var_rank[i], index, NCT_UCHAR);
#line 156
		err = nc_get_var1_uchar(ncid, i, index, &value);
#line 156
		if (inRange3(expect,datatype,NCT_UCHAR)) {
#line 156
                    if (expect >= uchar_min && expect <= uchar_max) {
#line 156
			IF (err) {
#line 156
			    error("nc_get_var1_uchar: %s", nc_strerror(err));
#line 156
			} else {
#line 156
                            IF (!equal(value,expect,var_type[i],NCT_UCHAR)) {
#line 156
				error("Var value read not that expected");
#line 156
				if (verbose) {
#line 156
				    error("\n");
#line 156
				    error("varid: %d, ", i);
#line 156
				    error("var_name: %s, ", var_name[i]);
#line 156
				    error("index:");
#line 156
				    for (d = 0; d < var_rank[i]; d++)
#line 156
					error(" %d", index[d]);
#line 156
				    error(", expect: %g, ", expect);
#line 156
				    error("got: %g", (double) value);
#line 156
				}
#line 156
			    } else {
#line 156
				++nok;
#line 156
			    }
#line 156
			}
#line 156
		    }
#line 156
		}
#line 156
	    }
#line 156
	}
#line 156
    }
#line 156
    err = nc_close (ncid);
#line 156
    IF (err)
#line 156
        error("nc_close: %s", nc_strerror(err));
#line 156
    print_nok(nok);
#line 156
}
#line 156

/* 
#line 157
 *  check all vars in file which are (text/numeric) compatible with TYPE
#line 157
 */
#line 157
static
#line 157
void
#line 157
check_vars_schar(const char *filename)
#line 157
{
#line 157
    int  ncid;                  /* netCDF id */
#line 157
    size_t index[MAX_RANK];
#line 157
    int  err;           /* status */
#line 157
    int  d;
#line 157
    int  i;
#line 157
    size_t  j;
#line 157
    schar value;
#line 157
    nc_type datatype;
#line 157
    int ndims;
#line 157
    int dimids[MAX_RANK];
#line 157
    double expect;
#line 157
    char name[NC_MAX_NAME];
#line 157
    size_t length;
#line 157
    int canConvert;     /* Both text or both numeric */
#line 157
    int nok = 0;      /* count of valid comparisons */
#line 157

#line 157
    err = nc_open(filename, NC_NOWRITE, &ncid);
#line 157
    IF (err)
#line 157
        error("nc_open: %s", nc_strerror(err));
#line 157

#line 157
    for (i = 0; i < NVARS; i++) {
#line 157
	canConvert = (var_type[i] == NC_CHAR) == (NCT_SCHAR == NCT_TEXT);
#line 157
	if (canConvert) {
#line 157
	    err = nc_inq_var(ncid, i, name, &datatype, &ndims, dimids, NULL);
#line 157
	    IF (err)
#line 157
		error("nc_inq_var: %s", nc_strerror(err));
#line 157
	    IF (strcmp(name, var_name[i]) != 0)
#line 157
		error("Unexpected var_name");
#line 157
	    IF (datatype != var_type[i])
#line 157
		error("Unexpected type");
#line 157
	    IF (ndims != var_rank[i])
#line 157
		error("Unexpected rank");
#line 157
	    for (j = 0; j < ndims; j++) {
#line 157
		err = nc_inq_dim(ncid, dimids[j], 0, &length);
#line 157
		IF (err)
#line 157
		    error("nc_inq_dim: %s", nc_strerror(err));
#line 157
		IF (length != var_shape[i][j])
#line 157
		    error("Unexpected shape");
#line 157
	    }
#line 157
	    for (j = 0; j < var_nels[i]; j++) {
#line 157
		err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 157
		IF (err)
#line 157
		    error("error in toMixedBase 2");
#line 157
		expect = hash4( var_type[i], var_rank[i], index, NCT_SCHAR);
#line 157
		err = nc_get_var1_schar(ncid, i, index, &value);
#line 157
		if (inRange3(expect,datatype,NCT_SCHAR)) {
#line 157
                    if (expect >= schar_min && expect <= schar_max) {
#line 157
			IF (err) {
#line 157
			    error("nc_get_var1_schar: %s", nc_strerror(err));
#line 157
			} else {
#line 157
                            IF (!equal(value,expect,var_type[i],NCT_SCHAR)) {
#line 157
				error("Var value read not that expected");
#line 157
				if (verbose) {
#line 157
				    error("\n");
#line 157
				    error("varid: %d, ", i);
#line 157
				    error("var_name: %s, ", var_name[i]);
#line 157
				    error("index:");
#line 157
				    for (d = 0; d < var_rank[i]; d++)
#line 157
					error(" %d", index[d]);
#line 157
				    error(", expect: %g, ", expect);
#line 157
				    error("got: %g", (double) value);
#line 157
				}
#line 157
			    } else {
#line 157
				++nok;
#line 157
			    }
#line 157
			}
#line 157
		    }
#line 157
		}
#line 157
	    }
#line 157
	}
#line 157
    }
#line 157
    err = nc_close (ncid);
#line 157
    IF (err)
#line 157
        error("nc_close: %s", nc_strerror(err));
#line 157
    print_nok(nok);
#line 157
}
#line 157

/* 
#line 158
 *  check all vars in file which are (text/numeric) compatible with TYPE
#line 158
 */
#line 158
static
#line 158
void
#line 158
check_vars_short(const char *filename)
#line 158
{
#line 158
    int  ncid;                  /* netCDF id */
#line 158
    size_t index[MAX_RANK];
#line 158
    int  err;           /* status */
#line 158
    int  d;
#line 158
    int  i;
#line 158
    size_t  j;
#line 158
    short value;
#line 158
    nc_type datatype;
#line 158
    int ndims;
#line 158
    int dimids[MAX_RANK];
#line 158
    double expect;
#line 158
    char name[NC_MAX_NAME];
#line 158
    size_t length;
#line 158
    int canConvert;     /* Both text or both numeric */
#line 158
    int nok = 0;      /* count of valid comparisons */
#line 158

#line 158
    err = nc_open(filename, NC_NOWRITE, &ncid);
#line 158
    IF (err)
#line 158
        error("nc_open: %s", nc_strerror(err));
#line 158

#line 158
    for (i = 0; i < NVARS; i++) {
#line 158
	canConvert = (var_type[i] == NC_CHAR) == (NCT_SHORT == NCT_TEXT);
#line 158
	if (canConvert) {
#line 158
	    err = nc_inq_var(ncid, i, name, &datatype, &ndims, dimids, NULL);
#line 158
	    IF (err)
#line 158
		error("nc_inq_var: %s", nc_strerror(err));
#line 158
	    IF (strcmp(name, var_name[i]) != 0)
#line 158
		error("Unexpected var_name");
#line 158
	    IF (datatype != var_type[i])
#line 158
		error("Unexpected type");
#line 158
	    IF (ndims != var_rank[i])
#line 158
		error("Unexpected rank");
#line 158
	    for (j = 0; j < ndims; j++) {
#line 158
		err = nc_inq_dim(ncid, dimids[j], 0, &length);
#line 158
		IF (err)
#line 158
		    error("nc_inq_dim: %s", nc_strerror(err));
#line 158
		IF (length != var_shape[i][j])
#line 158
		    error("Unexpected shape");
#line 158
	    }
#line 158
	    for (j = 0; j < var_nels[i]; j++) {
#line 158
		err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 158
		IF (err)
#line 158
		    error("error in toMixedBase 2");
#line 158
		expect = hash4( var_type[i], var_rank[i], index, NCT_SHORT);
#line 158
		err = nc_get_var1_short(ncid, i, index, &value);
#line 158
		if (inRange3(expect,datatype,NCT_SHORT)) {
#line 158
                    if (expect >= short_min && expect <= short_max) {
#line 158
			IF (err) {
#line 158
			    error("nc_get_var1_short: %s", nc_strerror(err));
#line 158
			} else {
#line 158
                            IF (!equal(value,expect,var_type[i],NCT_SHORT)) {
#line 158
				error("Var value read not that expected");
#line 158
				if (verbose) {
#line 158
				    error("\n");
#line 158
				    error("varid: %d, ", i);
#line 158
				    error("var_name: %s, ", var_name[i]);
#line 158
				    error("index:");
#line 158
				    for (d = 0; d < var_rank[i]; d++)
#line 158
					error(" %d", index[d]);
#line 158
				    error(", expect: %g, ", expect);
#line 158
				    error("got: %g", (double) value);
#line 158
				}
#line 158
			    } else {
#line 158
				++nok;
#line 158
			    }
#line 158
			}
#line 158
		    }
#line 158
		}
#line 158
	    }
#line 158
	}
#line 158
    }
#line 158
    err = nc_close (ncid);
#line 158
    IF (err)
#line 158
        error("nc_close: %s", nc_strerror(err));
#line 158
    print_nok(nok);
#line 158
}
#line 158

/* 
#line 159
 *  check all vars in file which are (text/numeric) compatible with TYPE
#line 159
 */
#line 159
static
#line 159
void
#line 159
check_vars_int(const char *filename)
#line 159
{
#line 159
    int  ncid;                  /* netCDF id */
#line 159
    size_t index[MAX_RANK];
#line 159
    int  err;           /* status */
#line 159
    int  d;
#line 159
    int  i;
#line 159
    size_t  j;
#line 159
    int value;
#line 159
    nc_type datatype;
#line 159
    int ndims;
#line 159
    int dimids[MAX_RANK];
#line 159
    double expect;
#line 159
    char name[NC_MAX_NAME];
#line 159
    size_t length;
#line 159
    int canConvert;     /* Both text or both numeric */
#line 159
    int nok = 0;      /* count of valid comparisons */
#line 159

#line 159
    err = nc_open(filename, NC_NOWRITE, &ncid);
#line 159
    IF (err)
#line 159
        error("nc_open: %s", nc_strerror(err));
#line 159

#line 159
    for (i = 0; i < NVARS; i++) {
#line 159
	canConvert = (var_type[i] == NC_CHAR) == (NCT_INT == NCT_TEXT);
#line 159
	if (canConvert) {
#line 159
	    err = nc_inq_var(ncid, i, name, &datatype, &ndims, dimids, NULL);
#line 159
	    IF (err)
#line 159
		error("nc_inq_var: %s", nc_strerror(err));
#line 159
	    IF (strcmp(name, var_name[i]) != 0)
#line 159
		error("Unexpected var_name");
#line 159
	    IF (datatype != var_type[i])
#line 159
		error("Unexpected type");
#line 159
	    IF (ndims != var_rank[i])
#line 159
		error("Unexpected rank");
#line 159
	    for (j = 0; j < ndims; j++) {
#line 159
		err = nc_inq_dim(ncid, dimids[j], 0, &length);
#line 159
		IF (err)
#line 159
		    error("nc_inq_dim: %s", nc_strerror(err));
#line 159
		IF (length != var_shape[i][j])
#line 159
		    error("Unexpected shape");
#line 159
	    }
#line 159
	    for (j = 0; j < var_nels[i]; j++) {
#line 159
		err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 159
		IF (err)
#line 159
		    error("error in toMixedBase 2");
#line 159
		expect = hash4( var_type[i], var_rank[i], index, NCT_INT);
#line 159
		err = nc_get_var1_int(ncid, i, index, &value);
#line 159
		if (inRange3(expect,datatype,NCT_INT)) {
#line 159
                    if (expect >= int_min && expect <= int_max) {
#line 159
			IF (err) {
#line 159
			    error("nc_get_var1_int: %s", nc_strerror(err));
#line 159
			} else {
#line 159
                            IF (!equal(value,expect,var_type[i],NCT_INT)) {
#line 159
				error("Var value read not that expected");
#line 159
				if (verbose) {
#line 159
				    error("\n");
#line 159
				    error("varid: %d, ", i);
#line 159
				    error("var_name: %s, ", var_name[i]);
#line 159
				    error("index:");
#line 159
				    for (d = 0; d < var_rank[i]; d++)
#line 159
					error(" %d", index[d]);
#line 159
				    error(", expect: %g, ", expect);
#line 159
				    error("got: %g", (double) value);
#line 159
				}
#line 159
			    } else {
#line 159
				++nok;
#line 159
			    }
#line 159
			}
#line 159
		    }
#line 159
		}
#line 159
	    }
#line 159
	}
#line 159
    }
#line 159
    err = nc_close (ncid);
#line 159
    IF (err)
#line 159
        error("nc_close: %s", nc_strerror(err));
#line 159
    print_nok(nok);
#line 159
}
#line 159

/* 
#line 160
 *  check all vars in file which are (text/numeric) compatible with TYPE
#line 160
 */
#line 160
static
#line 160
void
#line 160
check_vars_long(const char *filename)
#line 160
{
#line 160
    int  ncid;                  /* netCDF id */
#line 160
    size_t index[MAX_RANK];
#line 160
    int  err;           /* status */
#line 160
    int  d;
#line 160
    int  i;
#line 160
    size_t  j;
#line 160
    long value;
#line 160
    nc_type datatype;
#line 160
    int ndims;
#line 160
    int dimids[MAX_RANK];
#line 160
    double expect;
#line 160
    char name[NC_MAX_NAME];
#line 160
    size_t length;
#line 160
    int canConvert;     /* Both text or both numeric */
#line 160
    int nok = 0;      /* count of valid comparisons */
#line 160

#line 160
    err = nc_open(filename, NC_NOWRITE, &ncid);
#line 160
    IF (err)
#line 160
        error("nc_open: %s", nc_strerror(err));
#line 160

#line 160
    for (i = 0; i < NVARS; i++) {
#line 160
	canConvert = (var_type[i] == NC_CHAR) == (NCT_LONG == NCT_TEXT);
#line 160
	if (canConvert) {
#line 160
	    err = nc_inq_var(ncid, i, name, &datatype, &ndims, dimids, NULL);
#line 160
	    IF (err)
#line 160
		error("nc_inq_var: %s", nc_strerror(err));
#line 160
	    IF (strcmp(name, var_name[i]) != 0)
#line 160
		error("Unexpected var_name");
#line 160
	    IF (datatype != var_type[i])
#line 160
		error("Unexpected type");
#line 160
	    IF (ndims != var_rank[i])
#line 160
		error("Unexpected rank");
#line 160
	    for (j = 0; j < ndims; j++) {
#line 160
		err = nc_inq_dim(ncid, dimids[j], 0, &length);
#line 160
		IF (err)
#line 160
		    error("nc_inq_dim: %s", nc_strerror(err));
#line 160
		IF (length != var_shape[i][j])
#line 160
		    error("Unexpected shape");
#line 160
	    }
#line 160
	    for (j = 0; j < var_nels[i]; j++) {
#line 160
		err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 160
		IF (err)
#line 160
		    error("error in toMixedBase 2");
#line 160
		expect = hash4( var_type[i], var_rank[i], index, NCT_LONG);
#line 160
		err = nc_get_var1_long(ncid, i, index, &value);
#line 160
		if (inRange3(expect,datatype,NCT_LONG)) {
#line 160
                    if (expect >= long_min && expect <= long_max) {
#line 160
			IF (err) {
#line 160
			    error("nc_get_var1_long: %s", nc_strerror(err));
#line 160
			} else {
#line 160
                            IF (!equal(value,expect,var_type[i],NCT_LONG)) {
#line 160
				error("Var value read not that expected");
#line 160
				if (verbose) {
#line 160
				    error("\n");
#line 160
				    error("varid: %d, ", i);
#line 160
				    error("var_name: %s, ", var_name[i]);
#line 160
				    error("index:");
#line 160
				    for (d = 0; d < var_rank[i]; d++)
#line 160
					error(" %d", index[d]);
#line 160
				    error(", expect: %g, ", expect);
#line 160
				    error("got: %g", (double) value);
#line 160
				}
#line 160
			    } else {
#line 160
				++nok;
#line 160
			    }
#line 160
			}
#line 160
		    }
#line 160
		}
#line 160
	    }
#line 160
	}
#line 160
    }
#line 160
    err = nc_close (ncid);
#line 160
    IF (err)
#line 160
        error("nc_close: %s", nc_strerror(err));
#line 160
    print_nok(nok);
#line 160
}
#line 160

/* 
#line 161
 *  check all vars in file which are (text/numeric) compatible with TYPE
#line 161
 */
#line 161
static
#line 161
void
#line 161
check_vars_float(const char *filename)
#line 161
{
#line 161
    int  ncid;                  /* netCDF id */
#line 161
    size_t index[MAX_RANK];
#line 161
    int  err;           /* status */
#line 161
    int  d;
#line 161
    int  i;
#line 161
    size_t  j;
#line 161
    float value;
#line 161
    nc_type datatype;
#line 161
    int ndims;
#line 161
    int dimids[MAX_RANK];
#line 161
    double expect;
#line 161
    char name[NC_MAX_NAME];
#line 161
    size_t length;
#line 161
    int canConvert;     /* Both text or both numeric */
#line 161
    int nok = 0;      /* count of valid comparisons */
#line 161

#line 161
    err = nc_open(filename, NC_NOWRITE, &ncid);
#line 161
    IF (err)
#line 161
        error("nc_open: %s", nc_strerror(err));
#line 161

#line 161
    for (i = 0; i < NVARS; i++) {
#line 161
	canConvert = (var_type[i] == NC_CHAR) == (NCT_FLOAT == NCT_TEXT);
#line 161
	if (canConvert) {
#line 161
	    err = nc_inq_var(ncid, i, name, &datatype, &ndims, dimids, NULL);
#line 161
	    IF (err)
#line 161
		error("nc_inq_var: %s", nc_strerror(err));
#line 161
	    IF (strcmp(name, var_name[i]) != 0)
#line 161
		error("Unexpected var_name");
#line 161
	    IF (datatype != var_type[i])
#line 161
		error("Unexpected type");
#line 161
	    IF (ndims != var_rank[i])
#line 161
		error("Unexpected rank");
#line 161
	    for (j = 0; j < ndims; j++) {
#line 161
		err = nc_inq_dim(ncid, dimids[j], 0, &length);
#line 161
		IF (err)
#line 161
		    error("nc_inq_dim: %s", nc_strerror(err));
#line 161
		IF (length != var_shape[i][j])
#line 161
		    error("Unexpected shape");
#line 161
	    }
#line 161
	    for (j = 0; j < var_nels[i]; j++) {
#line 161
		err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 161
		IF (err)
#line 161
		    error("error in toMixedBase 2");
#line 161
		expect = hash4( var_type[i], var_rank[i], index, NCT_FLOAT);
#line 161
		err = nc_get_var1_float(ncid, i, index, &value);
#line 161
		if (inRange3(expect,datatype,NCT_FLOAT)) {
#line 161
                    if (expect >= float_min && expect <= float_max) {
#line 161
			IF (err) {
#line 161
			    error("nc_get_var1_float: %s", nc_strerror(err));
#line 161
			} else {
#line 161
                            IF (!equal(value,expect,var_type[i],NCT_FLOAT)) {
#line 161
				error("Var value read not that expected");
#line 161
				if (verbose) {
#line 161
				    error("\n");
#line 161
				    error("varid: %d, ", i);
#line 161
				    error("var_name: %s, ", var_name[i]);
#line 161
				    error("index:");
#line 161
				    for (d = 0; d < var_rank[i]; d++)
#line 161
					error(" %d", index[d]);
#line 161
				    error(", expect: %g, ", expect);
#line 161
				    error("got: %g", (double) value);
#line 161
				}
#line 161
			    } else {
#line 161
				++nok;
#line 161
			    }
#line 161
			}
#line 161
		    }
#line 161
		}
#line 161
	    }
#line 161
	}
#line 161
    }
#line 161
    err = nc_close (ncid);
#line 161
    IF (err)
#line 161
        error("nc_close: %s", nc_strerror(err));
#line 161
    print_nok(nok);
#line 161
}
#line 161

/* 
#line 162
 *  check all vars in file which are (text/numeric) compatible with TYPE
#line 162
 */
#line 162
static
#line 162
void
#line 162
check_vars_double(const char *filename)
#line 162
{
#line 162
    int  ncid;                  /* netCDF id */
#line 162
    size_t index[MAX_RANK];
#line 162
    int  err;           /* status */
#line 162
    int  d;
#line 162
    int  i;
#line 162
    size_t  j;
#line 162
    double value;
#line 162
    nc_type datatype;
#line 162
    int ndims;
#line 162
    int dimids[MAX_RANK];
#line 162
    double expect;
#line 162
    char name[NC_MAX_NAME];
#line 162
    size_t length;
#line 162
    int canConvert;     /* Both text or both numeric */
#line 162
    int nok = 0;      /* count of valid comparisons */
#line 162

#line 162
    err = nc_open(filename, NC_NOWRITE, &ncid);
#line 162
    IF (err)
#line 162
        error("nc_open: %s", nc_strerror(err));
#line 162

#line 162
    for (i = 0; i < NVARS; i++) {
#line 162
	canConvert = (var_type[i] == NC_CHAR) == (NCT_DOUBLE == NCT_TEXT);
#line 162
	if (canConvert) {
#line 162
	    err = nc_inq_var(ncid, i, name, &datatype, &ndims, dimids, NULL);
#line 162
	    IF (err)
#line 162
		error("nc_inq_var: %s", nc_strerror(err));
#line 162
	    IF (strcmp(name, var_name[i]) != 0)
#line 162
		error("Unexpected var_name");
#line 162
	    IF (datatype != var_type[i])
#line 162
		error("Unexpected type");
#line 162
	    IF (ndims != var_rank[i])
#line 162
		error("Unexpected rank");
#line 162
	    for (j = 0; j < ndims; j++) {
#line 162
		err = nc_inq_dim(ncid, dimids[j], 0, &length);
#line 162
		IF (err)
#line 162
		    error("nc_inq_dim: %s", nc_strerror(err));
#line 162
		IF (length != var_shape[i][j])
#line 162
		    error("Unexpected shape");
#line 162
	    }
#line 162
	    for (j = 0; j < var_nels[i]; j++) {
#line 162
		err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 162
		IF (err)
#line 162
		    error("error in toMixedBase 2");
#line 162
		expect = hash4( var_type[i], var_rank[i], index, NCT_DOUBLE);
#line 162
		err = nc_get_var1_double(ncid, i, index, &value);
#line 162
		if (inRange3(expect,datatype,NCT_DOUBLE)) {
#line 162
                    if (expect >= double_min && expect <= double_max) {
#line 162
			IF (err) {
#line 162
			    error("nc_get_var1_double: %s", nc_strerror(err));
#line 162
			} else {
#line 162
                            IF (!equal(value,expect,var_type[i],NCT_DOUBLE)) {
#line 162
				error("Var value read not that expected");
#line 162
				if (verbose) {
#line 162
				    error("\n");
#line 162
				    error("varid: %d, ", i);
#line 162
				    error("var_name: %s, ", var_name[i]);
#line 162
				    error("index:");
#line 162
				    for (d = 0; d < var_rank[i]; d++)
#line 162
					error(" %d", index[d]);
#line 162
				    error(", expect: %g, ", expect);
#line 162
				    error("got: %g", (double) value);
#line 162
				}
#line 162
			    } else {
#line 162
				++nok;
#line 162
			    }
#line 162
			}
#line 162
		    }
#line 162
		}
#line 162
	    }
#line 162
	}
#line 162
    }
#line 162
    err = nc_close (ncid);
#line 162
    IF (err)
#line 162
        error("nc_close: %s", nc_strerror(err));
#line 162
    print_nok(nok);
#line 162
}
#line 162



#line 244

/* 
#line 245
 *  check all attributes in file which are (text/numeric) compatible with TYPE
#line 245
 *  ignore any attributes containing values outside range of TYPE
#line 245
 */
#line 245
static
#line 245
void
#line 245
check_atts_text(int  ncid)
#line 245
{
#line 245
    int  err;           /* status */
#line 245
    int  i;
#line 245
    int  j;
#line 245
    size_t  k;
#line 245
    text value[MAX_NELS];
#line 245
    nc_type datatype;
#line 245
    double expect[MAX_NELS];
#line 245
    size_t length;
#line 245
    size_t nInExtRange;  /* number values within external range */
#line 245
    size_t nInIntRange;  /* number values within internal range */
#line 245
    int canConvert;     /* Both text or both numeric */
#line 245
    int nok = 0;      /* count of valid comparisons */
#line 245

#line 245
    for (i = -1; i < NVARS; i++) {
#line 245
        for (j = 0; j < NATTS(i); j++) {
#line 245
	    canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_TEXT == NCT_TEXT);
#line 245
	    if (canConvert) {
#line 245
		err = nc_inq_att(ncid, i, ATT_NAME(i,j), &datatype, &length);
#line 245
		IF (err)
#line 245
		    error("nc_inq_att: %s", nc_strerror(err));
#line 245
		IF (datatype != ATT_TYPE(i,j))
#line 245
		error("nc_inq_att: unexpected type");
#line 245
		IF (length != ATT_LEN(i,j))
#line 245
		    error("nc_inq_att: unexpected length");
#line 245
		assert(length <= MAX_NELS);
#line 245
		nInIntRange = nInExtRange = 0;
#line 245
		for (k = 0; k < length; k++) {
#line 245
		    expect[k] = hash4( datatype, -1, &k, NCT_TEXT);
#line 245
		    if (inRange3(expect[k], datatype, NCT_TEXT)) {
#line 245
			++nInExtRange;
#line 245
			if (expect[k] >= text_min && expect[k] <= text_max)
#line 245
			    ++nInIntRange;
#line 245
		    }
#line 245
		}
#line 245
		err = nc_get_att_text(ncid, i, ATT_NAME(i,j), value);
#line 245
                if (nInExtRange == length && nInIntRange == length) {
#line 245
		    IF (err)
#line 245
			error("%s", nc_strerror(err));
#line 245
                } else {
#line 245
                    IF (err != 0 && err != NC_ERANGE)
#line 245
                        error("OK or Range error: status = %d", err);
#line 245
                }
#line 245
		for (k = 0; k < length; k++) {
#line 245
                    if (inRange3(expect[k],datatype,NCT_TEXT)
#line 245
                            && expect[k] >= text_min && expect[k] <= text_max) {
#line 245
                        IF (!equal(value[k],expect[k],datatype,NCT_TEXT)) {
#line 245
                            error("att. value read not that expected");
#line 245
                            if (verbose) {
#line 245
                                error("\n");
#line 245
                                error("varid: %d, ", i);
#line 245
                                error("att_name: %s, ", ATT_NAME(i,j));
#line 245
                                error("element number: %d ", k);
#line 245
                                error("expect: %g, ", expect[k]);
#line 245
                                error("got: %g", (double) value[k]);
#line 245
                            }
#line 245
                        } else {
#line 245
                            nok++;
#line 245
                        }
#line 245
                    }
#line 245
                }
#line 245
            }                                               
#line 245
        }
#line 245
    }
#line 245

#line 245
    print_nok(nok);
#line 245
}
#line 245

/* 
#line 246
 *  check all attributes in file which are (text/numeric) compatible with TYPE
#line 246
 *  ignore any attributes containing values outside range of TYPE
#line 246
 */
#line 246
static
#line 246
void
#line 246
check_atts_uchar(int  ncid)
#line 246
{
#line 246
    int  err;           /* status */
#line 246
    int  i;
#line 246
    int  j;
#line 246
    size_t  k;
#line 246
    uchar value[MAX_NELS];
#line 246
    nc_type datatype;
#line 246
    double expect[MAX_NELS];
#line 246
    size_t length;
#line 246
    size_t nInExtRange;  /* number values within external range */
#line 246
    size_t nInIntRange;  /* number values within internal range */
#line 246
    int canConvert;     /* Both text or both numeric */
#line 246
    int nok = 0;      /* count of valid comparisons */
#line 246

#line 246
    for (i = -1; i < NVARS; i++) {
#line 246
        for (j = 0; j < NATTS(i); j++) {
#line 246
	    canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_UCHAR == NCT_TEXT);
#line 246
	    if (canConvert) {
#line 246
		err = nc_inq_att(ncid, i, ATT_NAME(i,j), &datatype, &length);
#line 246
		IF (err)
#line 246
		    error("nc_inq_att: %s", nc_strerror(err));
#line 246
		IF (datatype != ATT_TYPE(i,j))
#line 246
		error("nc_inq_att: unexpected type");
#line 246
		IF (length != ATT_LEN(i,j))
#line 246
		    error("nc_inq_att: unexpected length");
#line 246
		assert(length <= MAX_NELS);
#line 246
		nInIntRange = nInExtRange = 0;
#line 246
		for (k = 0; k < length; k++) {
#line 246
		    expect[k] = hash4( datatype, -1, &k, NCT_UCHAR);
#line 246
		    if (inRange3(expect[k], datatype, NCT_UCHAR)) {
#line 246
			++nInExtRange;
#line 246
			if (expect[k] >= uchar_min && expect[k] <= uchar_max)
#line 246
			    ++nInIntRange;
#line 246
		    }
#line 246
		}
#line 246
		err = nc_get_att_uchar(ncid, i, ATT_NAME(i,j), value);
#line 246
                if (nInExtRange == length && nInIntRange == length) {
#line 246
		    IF (err)
#line 246
			error("%s", nc_strerror(err));
#line 246
                } else {
#line 246
                    IF (err != 0 && err != NC_ERANGE)
#line 246
                        error("OK or Range error: status = %d", err);
#line 246
                }
#line 246
		for (k = 0; k < length; k++) {
#line 246
                    if (inRange3(expect[k],datatype,NCT_UCHAR)
#line 246
                            && expect[k] >= uchar_min && expect[k] <= uchar_max) {
#line 246
                        IF (!equal(value[k],expect[k],datatype,NCT_UCHAR)) {
#line 246
                            error("att. value read not that expected");
#line 246
                            if (verbose) {
#line 246
                                error("\n");
#line 246
                                error("varid: %d, ", i);
#line 246
                                error("att_name: %s, ", ATT_NAME(i,j));
#line 246
                                error("element number: %d ", k);
#line 246
                                error("expect: %g, ", expect[k]);
#line 246
                                error("got: %g", (double) value[k]);
#line 246
                            }
#line 246
                        } else {
#line 246
                            nok++;
#line 246
                        }
#line 246
                    }
#line 246
                }
#line 246
            }                                               
#line 246
        }
#line 246
    }
#line 246

#line 246
    print_nok(nok);
#line 246
}
#line 246

/* 
#line 247
 *  check all attributes in file which are (text/numeric) compatible with TYPE
#line 247
 *  ignore any attributes containing values outside range of TYPE
#line 247
 */
#line 247
static
#line 247
void
#line 247
check_atts_schar(int  ncid)
#line 247
{
#line 247
    int  err;           /* status */
#line 247
    int  i;
#line 247
    int  j;
#line 247
    size_t  k;
#line 247
    schar value[MAX_NELS];
#line 247
    nc_type datatype;
#line 247
    double expect[MAX_NELS];
#line 247
    size_t length;
#line 247
    size_t nInExtRange;  /* number values within external range */
#line 247
    size_t nInIntRange;  /* number values within internal range */
#line 247
    int canConvert;     /* Both text or both numeric */
#line 247
    int nok = 0;      /* count of valid comparisons */
#line 247

#line 247
    for (i = -1; i < NVARS; i++) {
#line 247
        for (j = 0; j < NATTS(i); j++) {
#line 247
	    canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_SCHAR == NCT_TEXT);
#line 247
	    if (canConvert) {
#line 247
		err = nc_inq_att(ncid, i, ATT_NAME(i,j), &datatype, &length);
#line 247
		IF (err)
#line 247
		    error("nc_inq_att: %s", nc_strerror(err));
#line 247
		IF (datatype != ATT_TYPE(i,j))
#line 247
		error("nc_inq_att: unexpected type");
#line 247
		IF (length != ATT_LEN(i,j))
#line 247
		    error("nc_inq_att: unexpected length");
#line 247
		assert(length <= MAX_NELS);
#line 247
		nInIntRange = nInExtRange = 0;
#line 247
		for (k = 0; k < length; k++) {
#line 247
		    expect[k] = hash4( datatype, -1, &k, NCT_SCHAR);
#line 247
		    if (inRange3(expect[k], datatype, NCT_SCHAR)) {
#line 247
			++nInExtRange;
#line 247
			if (expect[k] >= schar_min && expect[k] <= schar_max)
#line 247
			    ++nInIntRange;
#line 247
		    }
#line 247
		}
#line 247
		err = nc_get_att_schar(ncid, i, ATT_NAME(i,j), value);
#line 247
                if (nInExtRange == length && nInIntRange == length) {
#line 247
		    IF (err)
#line 247
			error("%s", nc_strerror(err));
#line 247
                } else {
#line 247
                    IF (err != 0 && err != NC_ERANGE)
#line 247
                        error("OK or Range error: status = %d", err);
#line 247
                }
#line 247
		for (k = 0; k < length; k++) {
#line 247
                    if (inRange3(expect[k],datatype,NCT_SCHAR)
#line 247
                            && expect[k] >= schar_min && expect[k] <= schar_max) {
#line 247
                        IF (!equal(value[k],expect[k],datatype,NCT_SCHAR)) {
#line 247
                            error("att. value read not that expected");
#line 247
                            if (verbose) {
#line 247
                                error("\n");
#line 247
                                error("varid: %d, ", i);
#line 247
                                error("att_name: %s, ", ATT_NAME(i,j));
#line 247
                                error("element number: %d ", k);
#line 247
                                error("expect: %g, ", expect[k]);
#line 247
                                error("got: %g", (double) value[k]);
#line 247
                            }
#line 247
                        } else {
#line 247
                            nok++;
#line 247
                        }
#line 247
                    }
#line 247
                }
#line 247
            }                                               
#line 247
        }
#line 247
    }
#line 247

#line 247
    print_nok(nok);
#line 247
}
#line 247

/* 
#line 248
 *  check all attributes in file which are (text/numeric) compatible with TYPE
#line 248
 *  ignore any attributes containing values outside range of TYPE
#line 248
 */
#line 248
static
#line 248
void
#line 248
check_atts_short(int  ncid)
#line 248
{
#line 248
    int  err;           /* status */
#line 248
    int  i;
#line 248
    int  j;
#line 248
    size_t  k;
#line 248
    short value[MAX_NELS];
#line 248
    nc_type datatype;
#line 248
    double expect[MAX_NELS];
#line 248
    size_t length;
#line 248
    size_t nInExtRange;  /* number values within external range */
#line 248
    size_t nInIntRange;  /* number values within internal range */
#line 248
    int canConvert;     /* Both text or both numeric */
#line 248
    int nok = 0;      /* count of valid comparisons */
#line 248

#line 248
    for (i = -1; i < NVARS; i++) {
#line 248
        for (j = 0; j < NATTS(i); j++) {
#line 248
	    canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_SHORT == NCT_TEXT);
#line 248
	    if (canConvert) {
#line 248
		err = nc_inq_att(ncid, i, ATT_NAME(i,j), &datatype, &length);
#line 248
		IF (err)
#line 248
		    error("nc_inq_att: %s", nc_strerror(err));
#line 248
		IF (datatype != ATT_TYPE(i,j))
#line 248
		error("nc_inq_att: unexpected type");
#line 248
		IF (length != ATT_LEN(i,j))
#line 248
		    error("nc_inq_att: unexpected length");
#line 248
		assert(length <= MAX_NELS);
#line 248
		nInIntRange = nInExtRange = 0;
#line 248
		for (k = 0; k < length; k++) {
#line 248
		    expect[k] = hash4( datatype, -1, &k, NCT_SHORT);
#line 248
		    if (inRange3(expect[k], datatype, NCT_SHORT)) {
#line 248
			++nInExtRange;
#line 248
			if (expect[k] >= short_min && expect[k] <= short_max)
#line 248
			    ++nInIntRange;
#line 248
		    }
#line 248
		}
#line 248
		err = nc_get_att_short(ncid, i, ATT_NAME(i,j), value);
#line 248
                if (nInExtRange == length && nInIntRange == length) {
#line 248
		    IF (err)
#line 248
			error("%s", nc_strerror(err));
#line 248
                } else {
#line 248
                    IF (err != 0 && err != NC_ERANGE)
#line 248
                        error("OK or Range error: status = %d", err);
#line 248
                }
#line 248
		for (k = 0; k < length; k++) {
#line 248
                    if (inRange3(expect[k],datatype,NCT_SHORT)
#line 248
                            && expect[k] >= short_min && expect[k] <= short_max) {
#line 248
                        IF (!equal(value[k],expect[k],datatype,NCT_SHORT)) {
#line 248
                            error("att. value read not that expected");
#line 248
                            if (verbose) {
#line 248
                                error("\n");
#line 248
                                error("varid: %d, ", i);
#line 248
                                error("att_name: %s, ", ATT_NAME(i,j));
#line 248
                                error("element number: %d ", k);
#line 248
                                error("expect: %g, ", expect[k]);
#line 248
                                error("got: %g", (double) value[k]);
#line 248
                            }
#line 248
                        } else {
#line 248
                            nok++;
#line 248
                        }
#line 248
                    }
#line 248
                }
#line 248
            }                                               
#line 248
        }
#line 248
    }
#line 248

#line 248
    print_nok(nok);
#line 248
}
#line 248

/* 
#line 249
 *  check all attributes in file which are (text/numeric) compatible with TYPE
#line 249
 *  ignore any attributes containing values outside range of TYPE
#line 249
 */
#line 249
static
#line 249
void
#line 249
check_atts_int(int  ncid)
#line 249
{
#line 249
    int  err;           /* status */
#line 249
    int  i;
#line 249
    int  j;
#line 249
    size_t  k;
#line 249
    int value[MAX_NELS];
#line 249
    nc_type datatype;
#line 249
    double expect[MAX_NELS];
#line 249
    size_t length;
#line 249
    size_t nInExtRange;  /* number values within external range */
#line 249
    size_t nInIntRange;  /* number values within internal range */
#line 249
    int canConvert;     /* Both text or both numeric */
#line 249
    int nok = 0;      /* count of valid comparisons */
#line 249

#line 249
    for (i = -1; i < NVARS; i++) {
#line 249
        for (j = 0; j < NATTS(i); j++) {
#line 249
	    canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_INT == NCT_TEXT);
#line 249
	    if (canConvert) {
#line 249
		err = nc_inq_att(ncid, i, ATT_NAME(i,j), &datatype, &length);
#line 249
		IF (err)
#line 249
		    error("nc_inq_att: %s", nc_strerror(err));
#line 249
		IF (datatype != ATT_TYPE(i,j))
#line 249
		error("nc_inq_att: unexpected type");
#line 249
		IF (length != ATT_LEN(i,j))
#line 249
		    error("nc_inq_att: unexpected length");
#line 249
		assert(length <= MAX_NELS);
#line 249
		nInIntRange = nInExtRange = 0;
#line 249
		for (k = 0; k < length; k++) {
#line 249
		    expect[k] = hash4( datatype, -1, &k, NCT_INT);
#line 249
		    if (inRange3(expect[k], datatype, NCT_INT)) {
#line 249
			++nInExtRange;
#line 249
			if (expect[k] >= int_min && expect[k] <= int_max)
#line 249
			    ++nInIntRange;
#line 249
		    }
#line 249
		}
#line 249
		err = nc_get_att_int(ncid, i, ATT_NAME(i,j), value);
#line 249
                if (nInExtRange == length && nInIntRange == length) {
#line 249
		    IF (err)
#line 249
			error("%s", nc_strerror(err));
#line 249
                } else {
#line 249
                    IF (err != 0 && err != NC_ERANGE)
#line 249
                        error("OK or Range error: status = %d", err);
#line 249
                }
#line 249
		for (k = 0; k < length; k++) {
#line 249
                    if (inRange3(expect[k],datatype,NCT_INT)
#line 249
                            && expect[k] >= int_min && expect[k] <= int_max) {
#line 249
                        IF (!equal(value[k],expect[k],datatype,NCT_INT)) {
#line 249
                            error("att. value read not that expected");
#line 249
                            if (verbose) {
#line 249
                                error("\n");
#line 249
                                error("varid: %d, ", i);
#line 249
                                error("att_name: %s, ", ATT_NAME(i,j));
#line 249
                                error("element number: %d ", k);
#line 249
                                error("expect: %g, ", expect[k]);
#line 249
                                error("got: %g", (double) value[k]);
#line 249
                            }
#line 249
                        } else {
#line 249
                            nok++;
#line 249
                        }
#line 249
                    }
#line 249
                }
#line 249
            }                                               
#line 249
        }
#line 249
    }
#line 249

#line 249
    print_nok(nok);
#line 249
}
#line 249

/* 
#line 250
 *  check all attributes in file which are (text/numeric) compatible with TYPE
#line 250
 *  ignore any attributes containing values outside range of TYPE
#line 250
 */
#line 250
static
#line 250
void
#line 250
check_atts_long(int  ncid)
#line 250
{
#line 250
    int  err;           /* status */
#line 250
    int  i;
#line 250
    int  j;
#line 250
    size_t  k;
#line 250
    long value[MAX_NELS];
#line 250
    nc_type datatype;
#line 250
    double expect[MAX_NELS];
#line 250
    size_t length;
#line 250
    size_t nInExtRange;  /* number values within external range */
#line 250
    size_t nInIntRange;  /* number values within internal range */
#line 250
    int canConvert;     /* Both text or both numeric */
#line 250
    int nok = 0;      /* count of valid comparisons */
#line 250

#line 250
    for (i = -1; i < NVARS; i++) {
#line 250
        for (j = 0; j < NATTS(i); j++) {
#line 250
	    canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_LONG == NCT_TEXT);
#line 250
	    if (canConvert) {
#line 250
		err = nc_inq_att(ncid, i, ATT_NAME(i,j), &datatype, &length);
#line 250
		IF (err)
#line 250
		    error("nc_inq_att: %s", nc_strerror(err));
#line 250
		IF (datatype != ATT_TYPE(i,j))
#line 250
		error("nc_inq_att: unexpected type");
#line 250
		IF (length != ATT_LEN(i,j))
#line 250
		    error("nc_inq_att: unexpected length");
#line 250
		assert(length <= MAX_NELS);
#line 250
		nInIntRange = nInExtRange = 0;
#line 250
		for (k = 0; k < length; k++) {
#line 250
		    expect[k] = hash4( datatype, -1, &k, NCT_LONG);
#line 250
		    if (inRange3(expect[k], datatype, NCT_LONG)) {
#line 250
			++nInExtRange;
#line 250
			if (expect[k] >= long_min && expect[k] <= long_max)
#line 250
			    ++nInIntRange;
#line 250
		    }
#line 250
		}
#line 250
		err = nc_get_att_long(ncid, i, ATT_NAME(i,j), value);
#line 250
                if (nInExtRange == length && nInIntRange == length) {
#line 250
		    IF (err)
#line 250
			error("%s", nc_strerror(err));
#line 250
                } else {
#line 250
                    IF (err != 0 && err != NC_ERANGE)
#line 250
                        error("OK or Range error: status = %d", err);
#line 250
                }
#line 250
		for (k = 0; k < length; k++) {
#line 250
                    if (inRange3(expect[k],datatype,NCT_LONG)
#line 250
                            && expect[k] >= long_min && expect[k] <= long_max) {
#line 250
                        IF (!equal(value[k],expect[k],datatype,NCT_LONG)) {
#line 250
                            error("att. value read not that expected");
#line 250
                            if (verbose) {
#line 250
                                error("\n");
#line 250
                                error("varid: %d, ", i);
#line 250
                                error("att_name: %s, ", ATT_NAME(i,j));
#line 250
                                error("element number: %d ", k);
#line 250
                                error("expect: %g, ", expect[k]);
#line 250
                                error("got: %g", (double) value[k]);
#line 250
                            }
#line 250
                        } else {
#line 250
                            nok++;
#line 250
                        }
#line 250
                    }
#line 250
                }
#line 250
            }                                               
#line 250
        }
#line 250
    }
#line 250

#line 250
    print_nok(nok);
#line 250
}
#line 250

/* 
#line 251
 *  check all attributes in file which are (text/numeric) compatible with TYPE
#line 251
 *  ignore any attributes containing values outside range of TYPE
#line 251
 */
#line 251
static
#line 251
void
#line 251
check_atts_float(int  ncid)
#line 251
{
#line 251
    int  err;           /* status */
#line 251
    int  i;
#line 251
    int  j;
#line 251
    size_t  k;
#line 251
    float value[MAX_NELS];
#line 251
    nc_type datatype;
#line 251
    double expect[MAX_NELS];
#line 251
    size_t length;
#line 251
    size_t nInExtRange;  /* number values within external range */
#line 251
    size_t nInIntRange;  /* number values within internal range */
#line 251
    int canConvert;     /* Both text or both numeric */
#line 251
    int nok = 0;      /* count of valid comparisons */
#line 251

#line 251
    for (i = -1; i < NVARS; i++) {
#line 251
        for (j = 0; j < NATTS(i); j++) {
#line 251
	    canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_FLOAT == NCT_TEXT);
#line 251
	    if (canConvert) {
#line 251
		err = nc_inq_att(ncid, i, ATT_NAME(i,j), &datatype, &length);
#line 251
		IF (err)
#line 251
		    error("nc_inq_att: %s", nc_strerror(err));
#line 251
		IF (datatype != ATT_TYPE(i,j))
#line 251
		error("nc_inq_att: unexpected type");
#line 251
		IF (length != ATT_LEN(i,j))
#line 251
		    error("nc_inq_att: unexpected length");
#line 251
		assert(length <= MAX_NELS);
#line 251
		nInIntRange = nInExtRange = 0;
#line 251
		for (k = 0; k < length; k++) {
#line 251
		    expect[k] = hash4( datatype, -1, &k, NCT_FLOAT);
#line 251
		    if (inRange3(expect[k], datatype, NCT_FLOAT)) {
#line 251
			++nInExtRange;
#line 251
			if (expect[k] >= float_min && expect[k] <= float_max)
#line 251
			    ++nInIntRange;
#line 251
		    }
#line 251
		}
#line 251
		err = nc_get_att_float(ncid, i, ATT_NAME(i,j), value);
#line 251
                if (nInExtRange == length && nInIntRange == length) {
#line 251
		    IF (err)
#line 251
			error("%s", nc_strerror(err));
#line 251
                } else {
#line 251
                    IF (err != 0 && err != NC_ERANGE)
#line 251
                        error("OK or Range error: status = %d", err);
#line 251
                }
#line 251
		for (k = 0; k < length; k++) {
#line 251
                    if (inRange3(expect[k],datatype,NCT_FLOAT)
#line 251
                            && expect[k] >= float_min && expect[k] <= float_max) {
#line 251
                        IF (!equal(value[k],expect[k],datatype,NCT_FLOAT)) {
#line 251
                            error("att. value read not that expected");
#line 251
                            if (verbose) {
#line 251
                                error("\n");
#line 251
                                error("varid: %d, ", i);
#line 251
                                error("att_name: %s, ", ATT_NAME(i,j));
#line 251
                                error("element number: %d ", k);
#line 251
                                error("expect: %g, ", expect[k]);
#line 251
                                error("got: %g", (double) value[k]);
#line 251
                            }
#line 251
                        } else {
#line 251
                            nok++;
#line 251
                        }
#line 251
                    }
#line 251
                }
#line 251
            }                                               
#line 251
        }
#line 251
    }
#line 251

#line 251
    print_nok(nok);
#line 251
}
#line 251

/* 
#line 252
 *  check all attributes in file which are (text/numeric) compatible with TYPE
#line 252
 *  ignore any attributes containing values outside range of TYPE
#line 252
 */
#line 252
static
#line 252
void
#line 252
check_atts_double(int  ncid)
#line 252
{
#line 252
    int  err;           /* status */
#line 252
    int  i;
#line 252
    int  j;
#line 252
    size_t  k;
#line 252
    double value[MAX_NELS];
#line 252
    nc_type datatype;
#line 252
    double expect[MAX_NELS];
#line 252
    size_t length;
#line 252
    size_t nInExtRange;  /* number values within external range */
#line 252
    size_t nInIntRange;  /* number values within internal range */
#line 252
    int canConvert;     /* Both text or both numeric */
#line 252
    int nok = 0;      /* count of valid comparisons */
#line 252

#line 252
    for (i = -1; i < NVARS; i++) {
#line 252
        for (j = 0; j < NATTS(i); j++) {
#line 252
	    canConvert = (ATT_TYPE(i,j) == NC_CHAR) == (NCT_DOUBLE == NCT_TEXT);
#line 252
	    if (canConvert) {
#line 252
		err = nc_inq_att(ncid, i, ATT_NAME(i,j), &datatype, &length);
#line 252
		IF (err)
#line 252
		    error("nc_inq_att: %s", nc_strerror(err));
#line 252
		IF (datatype != ATT_TYPE(i,j))
#line 252
		error("nc_inq_att: unexpected type");
#line 252
		IF (length != ATT_LEN(i,j))
#line 252
		    error("nc_inq_att: unexpected length");
#line 252
		assert(length <= MAX_NELS);
#line 252
		nInIntRange = nInExtRange = 0;
#line 252
		for (k = 0; k < length; k++) {
#line 252
		    expect[k] = hash4( datatype, -1, &k, NCT_DOUBLE);
#line 252
		    if (inRange3(expect[k], datatype, NCT_DOUBLE)) {
#line 252
			++nInExtRange;
#line 252
			if (expect[k] >= double_min && expect[k] <= double_max)
#line 252
			    ++nInIntRange;
#line 252
		    }
#line 252
		}
#line 252
		err = nc_get_att_double(ncid, i, ATT_NAME(i,j), value);
#line 252
                if (nInExtRange == length && nInIntRange == length) {
#line 252
		    IF (err)
#line 252
			error("%s", nc_strerror(err));
#line 252
                } else {
#line 252
                    IF (err != 0 && err != NC_ERANGE)
#line 252
                        error("OK or Range error: status = %d", err);
#line 252
                }
#line 252
		for (k = 0; k < length; k++) {
#line 252
                    if (inRange3(expect[k],datatype,NCT_DOUBLE)
#line 252
                            && expect[k] >= double_min && expect[k] <= double_max) {
#line 252
                        IF (!equal(value[k],expect[k],datatype,NCT_DOUBLE)) {
#line 252
                            error("att. value read not that expected");
#line 252
                            if (verbose) {
#line 252
                                error("\n");
#line 252
                                error("varid: %d, ", i);
#line 252
                                error("att_name: %s, ", ATT_NAME(i,j));
#line 252
                                error("element number: %d ", k);
#line 252
                                error("expect: %g, ", expect[k]);
#line 252
                                error("got: %g", (double) value[k]);
#line 252
                            }
#line 252
                        } else {
#line 252
                            nok++;
#line 252
                        }
#line 252
                    }
#line 252
                }
#line 252
            }                                               
#line 252
        }
#line 252
    }
#line 252

#line 252
    print_nok(nok);
#line 252
}
#line 252



#line 339

void
#line 340
test_nc_put_var1_text(void)
#line 340
{
#line 340
    int ncid;
#line 340
    int i;
#line 340
    int j;
#line 340
    int err;
#line 340
    size_t index[MAX_RANK];
#line 340
    int canConvert;	/* Both text or both numeric */
#line 340
    text value = 5;	/* any value would do - only for error cases */
#line 340

#line 340
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 340
    IF (err) {
#line 340
        error("nc_create: %s", nc_strerror(err));
#line 340
        return;
#line 340
    }
#line 340
    def_dims(ncid);
#line 340
    def_vars(ncid);
#line 340
    err = nc_enddef(ncid);
#line 340
    IF (err)
#line 340
        error("nc_enddef: %s", nc_strerror(err));
#line 340

#line 340
    for (i = 0; i < NVARS; i++) {
#line 340
	canConvert = (var_type[i] == NC_CHAR) == (NCT_TEXT == NCT_TEXT);
#line 340
        for (j = 0; j < var_rank[i]; j++)
#line 340
            index[j] = 0;
#line 340
        err = nc_put_var1_text(BAD_ID, i, index, &value);
#line 340
        IF (err != NC_EBADID) 
#line 340
	    error("bad ncid: status = %d", err);
#line 340
        err = nc_put_var1_text(ncid, BAD_VARID, index, &value);
#line 340
        IF (err != NC_ENOTVAR) 
#line 340
	    error("bad var id: status = %d", err);
#line 340
        for (j = 0; j < var_rank[i]; j++) {
#line 340
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 340
		index[j] = var_shape[i][j];
#line 340
		err = nc_put_var1_text(ncid, i, index, &value);
#line 340
		IF (canConvert && err != NC_EINVALCOORDS)
#line 340
		    error("bad index: status = %d", err);
#line 340
		index[j] = 0;
#line 340
	    }
#line 340
        }
#line 340
        for (j = 0; j < var_nels[i]; j++) {
#line 340
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 340
            IF (err) 
#line 340
		error("error in toMixedBase 1");
#line 340
            value = hash_text( var_type[i], var_rank[i], index, NCT_TEXT);
#line 340
	    if (var_rank[i] == 0 && i%2 == 0)
#line 340
		err = nc_put_var1_text(ncid, i, NULL, &value);
#line 340
	    else
#line 340
		err = nc_put_var1_text(ncid, i, index, &value);
#line 340
	    if (canConvert) {
#line 340
		if (inRange3(value, var_type[i],NCT_TEXT)) {
#line 340
		    IF (err)
#line 340
			error("%s", nc_strerror(err));
#line 340
		} else {
#line 340
		    IF (err != NC_ERANGE) {
#line 340
			error("Range error: status = %d", err);
#line 340
			error("\n\t\tfor type %s value %.17e %ld",
#line 340
				s_nc_type(var_type[i]),
#line 340
				(double)value, (long)value);
#line 340
		    }
#line 340
		}
#line 340
	    } else {
#line 340
		IF (err != NC_ECHAR)
#line 340
		    error("wrong type: status = %d", err);
#line 340
            }
#line 340
        }
#line 340
    }
#line 340

#line 340
    err = nc_close(ncid);
#line 340
    IF (err) 
#line 340
	error("nc_close: %s", nc_strerror(err));
#line 340

#line 340
    check_vars_text(scratch);
#line 340

#line 340
    err = remove(scratch);
#line 340
    IF (err)
#line 340
        error("remove of %s failed", scratch);
#line 340
}
#line 340

void
#line 341
test_nc_put_var1_uchar(void)
#line 341
{
#line 341
    int ncid;
#line 341
    int i;
#line 341
    int j;
#line 341
    int err;
#line 341
    size_t index[MAX_RANK];
#line 341
    int canConvert;	/* Both text or both numeric */
#line 341
    uchar value = 5;	/* any value would do - only for error cases */
#line 341

#line 341
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 341
    IF (err) {
#line 341
        error("nc_create: %s", nc_strerror(err));
#line 341
        return;
#line 341
    }
#line 341
    def_dims(ncid);
#line 341
    def_vars(ncid);
#line 341
    err = nc_enddef(ncid);
#line 341
    IF (err)
#line 341
        error("nc_enddef: %s", nc_strerror(err));
#line 341

#line 341
    for (i = 0; i < NVARS; i++) {
#line 341
	canConvert = (var_type[i] == NC_CHAR) == (NCT_UCHAR == NCT_TEXT);
#line 341
        for (j = 0; j < var_rank[i]; j++)
#line 341
            index[j] = 0;
#line 341
        err = nc_put_var1_uchar(BAD_ID, i, index, &value);
#line 341
        IF (err != NC_EBADID) 
#line 341
	    error("bad ncid: status = %d", err);
#line 341
        err = nc_put_var1_uchar(ncid, BAD_VARID, index, &value);
#line 341
        IF (err != NC_ENOTVAR) 
#line 341
	    error("bad var id: status = %d", err);
#line 341
        for (j = 0; j < var_rank[i]; j++) {
#line 341
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 341
		index[j] = var_shape[i][j];
#line 341
		err = nc_put_var1_uchar(ncid, i, index, &value);
#line 341
		IF (canConvert && err != NC_EINVALCOORDS)
#line 341
		    error("bad index: status = %d", err);
#line 341
		index[j] = 0;
#line 341
	    }
#line 341
        }
#line 341
        for (j = 0; j < var_nels[i]; j++) {
#line 341
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 341
            IF (err) 
#line 341
		error("error in toMixedBase 1");
#line 341
            value = hash_uchar( var_type[i], var_rank[i], index, NCT_UCHAR);
#line 341
	    if (var_rank[i] == 0 && i%2 == 0)
#line 341
		err = nc_put_var1_uchar(ncid, i, NULL, &value);
#line 341
	    else
#line 341
		err = nc_put_var1_uchar(ncid, i, index, &value);
#line 341
	    if (canConvert) {
#line 341
		if (inRange3(value, var_type[i],NCT_UCHAR)) {
#line 341
		    IF (err)
#line 341
			error("%s", nc_strerror(err));
#line 341
		} else {
#line 341
		    IF (err != NC_ERANGE) {
#line 341
			error("Range error: status = %d", err);
#line 341
			error("\n\t\tfor type %s value %.17e %ld",
#line 341
				s_nc_type(var_type[i]),
#line 341
				(double)value, (long)value);
#line 341
		    }
#line 341
		}
#line 341
	    } else {
#line 341
		IF (err != NC_ECHAR)
#line 341
		    error("wrong type: status = %d", err);
#line 341
            }
#line 341
        }
#line 341
    }
#line 341

#line 341
    err = nc_close(ncid);
#line 341
    IF (err) 
#line 341
	error("nc_close: %s", nc_strerror(err));
#line 341

#line 341
    check_vars_uchar(scratch);
#line 341

#line 341
    err = remove(scratch);
#line 341
    IF (err)
#line 341
        error("remove of %s failed", scratch);
#line 341
}
#line 341

void
#line 342
test_nc_put_var1_schar(void)
#line 342
{
#line 342
    int ncid;
#line 342
    int i;
#line 342
    int j;
#line 342
    int err;
#line 342
    size_t index[MAX_RANK];
#line 342
    int canConvert;	/* Both text or both numeric */
#line 342
    schar value = 5;	/* any value would do - only for error cases */
#line 342

#line 342
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 342
    IF (err) {
#line 342
        error("nc_create: %s", nc_strerror(err));
#line 342
        return;
#line 342
    }
#line 342
    def_dims(ncid);
#line 342
    def_vars(ncid);
#line 342
    err = nc_enddef(ncid);
#line 342
    IF (err)
#line 342
        error("nc_enddef: %s", nc_strerror(err));
#line 342

#line 342
    for (i = 0; i < NVARS; i++) {
#line 342
	canConvert = (var_type[i] == NC_CHAR) == (NCT_SCHAR == NCT_TEXT);
#line 342
        for (j = 0; j < var_rank[i]; j++)
#line 342
            index[j] = 0;
#line 342
        err = nc_put_var1_schar(BAD_ID, i, index, &value);
#line 342
        IF (err != NC_EBADID) 
#line 342
	    error("bad ncid: status = %d", err);
#line 342
        err = nc_put_var1_schar(ncid, BAD_VARID, index, &value);
#line 342
        IF (err != NC_ENOTVAR) 
#line 342
	    error("bad var id: status = %d", err);
#line 342
        for (j = 0; j < var_rank[i]; j++) {
#line 342
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 342
		index[j] = var_shape[i][j];
#line 342
		err = nc_put_var1_schar(ncid, i, index, &value);
#line 342
		IF (canConvert && err != NC_EINVALCOORDS)
#line 342
		    error("bad index: status = %d", err);
#line 342
		index[j] = 0;
#line 342
	    }
#line 342
        }
#line 342
        for (j = 0; j < var_nels[i]; j++) {
#line 342
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 342
            IF (err) 
#line 342
		error("error in toMixedBase 1");
#line 342
            value = hash_schar( var_type[i], var_rank[i], index, NCT_SCHAR);
#line 342
	    if (var_rank[i] == 0 && i%2 == 0)
#line 342
		err = nc_put_var1_schar(ncid, i, NULL, &value);
#line 342
	    else
#line 342
		err = nc_put_var1_schar(ncid, i, index, &value);
#line 342
	    if (canConvert) {
#line 342
		if (inRange3(value, var_type[i],NCT_SCHAR)) {
#line 342
		    IF (err)
#line 342
			error("%s", nc_strerror(err));
#line 342
		} else {
#line 342
		    IF (err != NC_ERANGE) {
#line 342
			error("Range error: status = %d", err);
#line 342
			error("\n\t\tfor type %s value %.17e %ld",
#line 342
				s_nc_type(var_type[i]),
#line 342
				(double)value, (long)value);
#line 342
		    }
#line 342
		}
#line 342
	    } else {
#line 342
		IF (err != NC_ECHAR)
#line 342
		    error("wrong type: status = %d", err);
#line 342
            }
#line 342
        }
#line 342
    }
#line 342

#line 342
    err = nc_close(ncid);
#line 342
    IF (err) 
#line 342
	error("nc_close: %s", nc_strerror(err));
#line 342

#line 342
    check_vars_schar(scratch);
#line 342

#line 342
    err = remove(scratch);
#line 342
    IF (err)
#line 342
        error("remove of %s failed", scratch);
#line 342
}
#line 342

void
#line 343
test_nc_put_var1_short(void)
#line 343
{
#line 343
    int ncid;
#line 343
    int i;
#line 343
    int j;
#line 343
    int err;
#line 343
    size_t index[MAX_RANK];
#line 343
    int canConvert;	/* Both text or both numeric */
#line 343
    short value = 5;	/* any value would do - only for error cases */
#line 343

#line 343
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 343
    IF (err) {
#line 343
        error("nc_create: %s", nc_strerror(err));
#line 343
        return;
#line 343
    }
#line 343
    def_dims(ncid);
#line 343
    def_vars(ncid);
#line 343
    err = nc_enddef(ncid);
#line 343
    IF (err)
#line 343
        error("nc_enddef: %s", nc_strerror(err));
#line 343

#line 343
    for (i = 0; i < NVARS; i++) {
#line 343
	canConvert = (var_type[i] == NC_CHAR) == (NCT_SHORT == NCT_TEXT);
#line 343
        for (j = 0; j < var_rank[i]; j++)
#line 343
            index[j] = 0;
#line 343
        err = nc_put_var1_short(BAD_ID, i, index, &value);
#line 343
        IF (err != NC_EBADID) 
#line 343
	    error("bad ncid: status = %d", err);
#line 343
        err = nc_put_var1_short(ncid, BAD_VARID, index, &value);
#line 343
        IF (err != NC_ENOTVAR) 
#line 343
	    error("bad var id: status = %d", err);
#line 343
        for (j = 0; j < var_rank[i]; j++) {
#line 343
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 343
		index[j] = var_shape[i][j];
#line 343
		err = nc_put_var1_short(ncid, i, index, &value);
#line 343
		IF (canConvert && err != NC_EINVALCOORDS)
#line 343
		    error("bad index: status = %d", err);
#line 343
		index[j] = 0;
#line 343
	    }
#line 343
        }
#line 343
        for (j = 0; j < var_nels[i]; j++) {
#line 343
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 343
            IF (err) 
#line 343
		error("error in toMixedBase 1");
#line 343
            value = hash_short( var_type[i], var_rank[i], index, NCT_SHORT);
#line 343
	    if (var_rank[i] == 0 && i%2 == 0)
#line 343
		err = nc_put_var1_short(ncid, i, NULL, &value);
#line 343
	    else
#line 343
		err = nc_put_var1_short(ncid, i, index, &value);
#line 343
	    if (canConvert) {
#line 343
		if (inRange3(value, var_type[i],NCT_SHORT)) {
#line 343
		    IF (err)
#line 343
			error("%s", nc_strerror(err));
#line 343
		} else {
#line 343
		    IF (err != NC_ERANGE) {
#line 343
			error("Range error: status = %d", err);
#line 343
			error("\n\t\tfor type %s value %.17e %ld",
#line 343
				s_nc_type(var_type[i]),
#line 343
				(double)value, (long)value);
#line 343
		    }
#line 343
		}
#line 343
	    } else {
#line 343
		IF (err != NC_ECHAR)
#line 343
		    error("wrong type: status = %d", err);
#line 343
            }
#line 343
        }
#line 343
    }
#line 343

#line 343
    err = nc_close(ncid);
#line 343
    IF (err) 
#line 343
	error("nc_close: %s", nc_strerror(err));
#line 343

#line 343
    check_vars_short(scratch);
#line 343

#line 343
    err = remove(scratch);
#line 343
    IF (err)
#line 343
        error("remove of %s failed", scratch);
#line 343
}
#line 343

void
#line 344
test_nc_put_var1_int(void)
#line 344
{
#line 344
    int ncid;
#line 344
    int i;
#line 344
    int j;
#line 344
    int err;
#line 344
    size_t index[MAX_RANK];
#line 344
    int canConvert;	/* Both text or both numeric */
#line 344
    int value = 5;	/* any value would do - only for error cases */
#line 344

#line 344
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 344
    IF (err) {
#line 344
        error("nc_create: %s", nc_strerror(err));
#line 344
        return;
#line 344
    }
#line 344
    def_dims(ncid);
#line 344
    def_vars(ncid);
#line 344
    err = nc_enddef(ncid);
#line 344
    IF (err)
#line 344
        error("nc_enddef: %s", nc_strerror(err));
#line 344

#line 344
    for (i = 0; i < NVARS; i++) {
#line 344
	canConvert = (var_type[i] == NC_CHAR) == (NCT_INT == NCT_TEXT);
#line 344
        for (j = 0; j < var_rank[i]; j++)
#line 344
            index[j] = 0;
#line 344
        err = nc_put_var1_int(BAD_ID, i, index, &value);
#line 344
        IF (err != NC_EBADID) 
#line 344
	    error("bad ncid: status = %d", err);
#line 344
        err = nc_put_var1_int(ncid, BAD_VARID, index, &value);
#line 344
        IF (err != NC_ENOTVAR) 
#line 344
	    error("bad var id: status = %d", err);
#line 344
        for (j = 0; j < var_rank[i]; j++) {
#line 344
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 344
		index[j] = var_shape[i][j];
#line 344
		err = nc_put_var1_int(ncid, i, index, &value);
#line 344
		IF (canConvert && err != NC_EINVALCOORDS)
#line 344
		    error("bad index: status = %d", err);
#line 344
		index[j] = 0;
#line 344
	    }
#line 344
        }
#line 344
        for (j = 0; j < var_nels[i]; j++) {
#line 344
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 344
            IF (err) 
#line 344
		error("error in toMixedBase 1");
#line 344
            value = hash_int( var_type[i], var_rank[i], index, NCT_INT);
#line 344
	    if (var_rank[i] == 0 && i%2 == 0)
#line 344
		err = nc_put_var1_int(ncid, i, NULL, &value);
#line 344
	    else
#line 344
		err = nc_put_var1_int(ncid, i, index, &value);
#line 344
	    if (canConvert) {
#line 344
		if (inRange3(value, var_type[i],NCT_INT)) {
#line 344
		    IF (err)
#line 344
			error("%s", nc_strerror(err));
#line 344
		} else {
#line 344
		    IF (err != NC_ERANGE) {
#line 344
			error("Range error: status = %d", err);
#line 344
			error("\n\t\tfor type %s value %.17e %ld",
#line 344
				s_nc_type(var_type[i]),
#line 344
				(double)value, (long)value);
#line 344
		    }
#line 344
		}
#line 344
	    } else {
#line 344
		IF (err != NC_ECHAR)
#line 344
		    error("wrong type: status = %d", err);
#line 344
            }
#line 344
        }
#line 344
    }
#line 344

#line 344
    err = nc_close(ncid);
#line 344
    IF (err) 
#line 344
	error("nc_close: %s", nc_strerror(err));
#line 344

#line 344
    check_vars_int(scratch);
#line 344

#line 344
    err = remove(scratch);
#line 344
    IF (err)
#line 344
        error("remove of %s failed", scratch);
#line 344
}
#line 344

void
#line 345
test_nc_put_var1_long(void)
#line 345
{
#line 345
    int ncid;
#line 345
    int i;
#line 345
    int j;
#line 345
    int err;
#line 345
    size_t index[MAX_RANK];
#line 345
    int canConvert;	/* Both text or both numeric */
#line 345
    long value = 5;	/* any value would do - only for error cases */
#line 345

#line 345
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 345
    IF (err) {
#line 345
        error("nc_create: %s", nc_strerror(err));
#line 345
        return;
#line 345
    }
#line 345
    def_dims(ncid);
#line 345
    def_vars(ncid);
#line 345
    err = nc_enddef(ncid);
#line 345
    IF (err)
#line 345
        error("nc_enddef: %s", nc_strerror(err));
#line 345

#line 345
    for (i = 0; i < NVARS; i++) {
#line 345
	canConvert = (var_type[i] == NC_CHAR) == (NCT_LONG == NCT_TEXT);
#line 345
        for (j = 0; j < var_rank[i]; j++)
#line 345
            index[j] = 0;
#line 345
        err = nc_put_var1_long(BAD_ID, i, index, &value);
#line 345
        IF (err != NC_EBADID) 
#line 345
	    error("bad ncid: status = %d", err);
#line 345
        err = nc_put_var1_long(ncid, BAD_VARID, index, &value);
#line 345
        IF (err != NC_ENOTVAR) 
#line 345
	    error("bad var id: status = %d", err);
#line 345
        for (j = 0; j < var_rank[i]; j++) {
#line 345
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 345
		index[j] = var_shape[i][j];
#line 345
		err = nc_put_var1_long(ncid, i, index, &value);
#line 345
		IF (canConvert && err != NC_EINVALCOORDS)
#line 345
		    error("bad index: status = %d", err);
#line 345
		index[j] = 0;
#line 345
	    }
#line 345
        }
#line 345
        for (j = 0; j < var_nels[i]; j++) {
#line 345
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 345
            IF (err) 
#line 345
		error("error in toMixedBase 1");
#line 345
            value = hash_long( var_type[i], var_rank[i], index, NCT_LONG);
#line 345
	    if (var_rank[i] == 0 && i%2 == 0)
#line 345
		err = nc_put_var1_long(ncid, i, NULL, &value);
#line 345
	    else
#line 345
		err = nc_put_var1_long(ncid, i, index, &value);
#line 345
	    if (canConvert) {
#line 345
		if (inRange3(value, var_type[i],NCT_LONG)) {
#line 345
		    IF (err)
#line 345
			error("%s", nc_strerror(err));
#line 345
		} else {
#line 345
		    IF (err != NC_ERANGE) {
#line 345
			error("Range error: status = %d", err);
#line 345
			error("\n\t\tfor type %s value %.17e %ld",
#line 345
				s_nc_type(var_type[i]),
#line 345
				(double)value, (long)value);
#line 345
		    }
#line 345
		}
#line 345
	    } else {
#line 345
		IF (err != NC_ECHAR)
#line 345
		    error("wrong type: status = %d", err);
#line 345
            }
#line 345
        }
#line 345
    }
#line 345

#line 345
    err = nc_close(ncid);
#line 345
    IF (err) 
#line 345
	error("nc_close: %s", nc_strerror(err));
#line 345

#line 345
    check_vars_long(scratch);
#line 345

#line 345
    err = remove(scratch);
#line 345
    IF (err)
#line 345
        error("remove of %s failed", scratch);
#line 345
}
#line 345

void
#line 346
test_nc_put_var1_float(void)
#line 346
{
#line 346
    int ncid;
#line 346
    int i;
#line 346
    int j;
#line 346
    int err;
#line 346
    size_t index[MAX_RANK];
#line 346
    int canConvert;	/* Both text or both numeric */
#line 346
    float value = 5;	/* any value would do - only for error cases */
#line 346

#line 346
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 346
    IF (err) {
#line 346
        error("nc_create: %s", nc_strerror(err));
#line 346
        return;
#line 346
    }
#line 346
    def_dims(ncid);
#line 346
    def_vars(ncid);
#line 346
    err = nc_enddef(ncid);
#line 346
    IF (err)
#line 346
        error("nc_enddef: %s", nc_strerror(err));
#line 346

#line 346
    for (i = 0; i < NVARS; i++) {
#line 346
	canConvert = (var_type[i] == NC_CHAR) == (NCT_FLOAT == NCT_TEXT);
#line 346
        for (j = 0; j < var_rank[i]; j++)
#line 346
            index[j] = 0;
#line 346
        err = nc_put_var1_float(BAD_ID, i, index, &value);
#line 346
        IF (err != NC_EBADID) 
#line 346
	    error("bad ncid: status = %d", err);
#line 346
        err = nc_put_var1_float(ncid, BAD_VARID, index, &value);
#line 346
        IF (err != NC_ENOTVAR) 
#line 346
	    error("bad var id: status = %d", err);
#line 346
        for (j = 0; j < var_rank[i]; j++) {
#line 346
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 346
		index[j] = var_shape[i][j];
#line 346
		err = nc_put_var1_float(ncid, i, index, &value);
#line 346
		IF (canConvert && err != NC_EINVALCOORDS)
#line 346
		    error("bad index: status = %d", err);
#line 346
		index[j] = 0;
#line 346
	    }
#line 346
        }
#line 346
        for (j = 0; j < var_nels[i]; j++) {
#line 346
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 346
            IF (err) 
#line 346
		error("error in toMixedBase 1");
#line 346
            value = hash_float( var_type[i], var_rank[i], index, NCT_FLOAT);
#line 346
	    if (var_rank[i] == 0 && i%2 == 0)
#line 346
		err = nc_put_var1_float(ncid, i, NULL, &value);
#line 346
	    else
#line 346
		err = nc_put_var1_float(ncid, i, index, &value);
#line 346
	    if (canConvert) {
#line 346
		if (inRange3(value, var_type[i],NCT_FLOAT)) {
#line 346
		    IF (err)
#line 346
			error("%s", nc_strerror(err));
#line 346
		} else {
#line 346
		    IF (err != NC_ERANGE) {
#line 346
			error("Range error: status = %d", err);
#line 346
			error("\n\t\tfor type %s value %.17e %ld",
#line 346
				s_nc_type(var_type[i]),
#line 346
				(double)value, (long)value);
#line 346
		    }
#line 346
		}
#line 346
	    } else {
#line 346
		IF (err != NC_ECHAR)
#line 346
		    error("wrong type: status = %d", err);
#line 346
            }
#line 346
        }
#line 346
    }
#line 346

#line 346
    err = nc_close(ncid);
#line 346
    IF (err) 
#line 346
	error("nc_close: %s", nc_strerror(err));
#line 346

#line 346
    check_vars_float(scratch);
#line 346

#line 346
    err = remove(scratch);
#line 346
    IF (err)
#line 346
        error("remove of %s failed", scratch);
#line 346
}
#line 346

void
#line 347
test_nc_put_var1_double(void)
#line 347
{
#line 347
    int ncid;
#line 347
    int i;
#line 347
    int j;
#line 347
    int err;
#line 347
    size_t index[MAX_RANK];
#line 347
    int canConvert;	/* Both text or both numeric */
#line 347
    double value = 5;	/* any value would do - only for error cases */
#line 347

#line 347
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 347
    IF (err) {
#line 347
        error("nc_create: %s", nc_strerror(err));
#line 347
        return;
#line 347
    }
#line 347
    def_dims(ncid);
#line 347
    def_vars(ncid);
#line 347
    err = nc_enddef(ncid);
#line 347
    IF (err)
#line 347
        error("nc_enddef: %s", nc_strerror(err));
#line 347

#line 347
    for (i = 0; i < NVARS; i++) {
#line 347
	canConvert = (var_type[i] == NC_CHAR) == (NCT_DOUBLE == NCT_TEXT);
#line 347
        for (j = 0; j < var_rank[i]; j++)
#line 347
            index[j] = 0;
#line 347
        err = nc_put_var1_double(BAD_ID, i, index, &value);
#line 347
        IF (err != NC_EBADID) 
#line 347
	    error("bad ncid: status = %d", err);
#line 347
        err = nc_put_var1_double(ncid, BAD_VARID, index, &value);
#line 347
        IF (err != NC_ENOTVAR) 
#line 347
	    error("bad var id: status = %d", err);
#line 347
        for (j = 0; j < var_rank[i]; j++) {
#line 347
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 347
		index[j] = var_shape[i][j];
#line 347
		err = nc_put_var1_double(ncid, i, index, &value);
#line 347
		IF (canConvert && err != NC_EINVALCOORDS)
#line 347
		    error("bad index: status = %d", err);
#line 347
		index[j] = 0;
#line 347
	    }
#line 347
        }
#line 347
        for (j = 0; j < var_nels[i]; j++) {
#line 347
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 347
            IF (err) 
#line 347
		error("error in toMixedBase 1");
#line 347
            value = hash_double( var_type[i], var_rank[i], index, NCT_DOUBLE);
#line 347
	    if (var_rank[i] == 0 && i%2 == 0)
#line 347
		err = nc_put_var1_double(ncid, i, NULL, &value);
#line 347
	    else
#line 347
		err = nc_put_var1_double(ncid, i, index, &value);
#line 347
	    if (canConvert) {
#line 347
		if (inRange3(value, var_type[i],NCT_DOUBLE)) {
#line 347
		    IF (err)
#line 347
			error("%s", nc_strerror(err));
#line 347
		} else {
#line 347
		    IF (err != NC_ERANGE) {
#line 347
			error("Range error: status = %d", err);
#line 347
			error("\n\t\tfor type %s value %.17e %ld",
#line 347
				s_nc_type(var_type[i]),
#line 347
				(double)value, (long)value);
#line 347
		    }
#line 347
		}
#line 347
	    } else {
#line 347
		IF (err != NC_ECHAR)
#line 347
		    error("wrong type: status = %d", err);
#line 347
            }
#line 347
        }
#line 347
    }
#line 347

#line 347
    err = nc_close(ncid);
#line 347
    IF (err) 
#line 347
	error("nc_close: %s", nc_strerror(err));
#line 347

#line 347
    check_vars_double(scratch);
#line 347

#line 347
    err = remove(scratch);
#line 347
    IF (err)
#line 347
        error("remove of %s failed", scratch);
#line 347
}
#line 347



#line 477

void
#line 478
test_nc_put_var_text(void)
#line 478
{
#line 478
    int ncid;
#line 478
    int varid;
#line 478
    int i;
#line 478
    int j;
#line 478
    int err;
#line 478
    int nels;
#line 478
    size_t index[MAX_RANK];
#line 478
    int canConvert;	/* Both text or both numeric */
#line 478
    int allInExtRange;	/* all values within external range? */
#line 478
    text value[MAX_NELS];
#line 478

#line 478
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 478
    IF (err) {
#line 478
        error("nc_create: %s", nc_strerror(err));
#line 478
        return;
#line 478
    }
#line 478
    def_dims(ncid);
#line 478
    def_vars(ncid);
#line 478
    err = nc_enddef(ncid);
#line 478
    IF (err)
#line 478
        error("nc_enddef: %s", nc_strerror(err));
#line 478

#line 478
    for (i = 0; i < NVARS; i++) {
#line 478
	canConvert = (var_type[i] == NC_CHAR) == (NCT_TEXT == NCT_TEXT);
#line 478
        assert(var_rank[i] <= MAX_RANK);
#line 478
        assert(var_nels[i] <= MAX_NELS);
#line 478
        err = nc_put_var_text(BAD_ID, i, value);
#line 478
        IF (err != NC_EBADID) 
#line 478
	    error("bad ncid: status = %d", err);
#line 478
        err = nc_put_var_text(ncid, BAD_VARID, value);
#line 478
        IF (err != NC_ENOTVAR) 
#line 478
	    error("bad var id: status = %d", err);
#line 478

#line 478
	nels = 1;
#line 478
	for (j = 0; j < var_rank[i]; j++) {
#line 478
	    nels *= var_shape[i][j];
#line 478
	}
#line 478
	for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 478
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 478
	    IF (err) 
#line 478
		error("error in toMixedBase 1");
#line 478
	    value[j]= hash_text(var_type[i], var_rank[i], index, NCT_TEXT);
#line 478
	    allInExtRange = allInExtRange 
#line 478
		&& inRange3(value[j], var_type[i], NCT_TEXT);
#line 478
	}
#line 478
        err = nc_put_var_text(ncid, i, value);
#line 478
	if (canConvert) {
#line 478
	    if (allInExtRange) {
#line 478
		IF (err) 
#line 478
		    error("%s", nc_strerror(err));
#line 478
	    } else {
#line 478
		IF (err != NC_ERANGE && var_dimid[i][0] != RECDIM)
#line 478
		    error("range error: status = %d", err);
#line 478
	    }
#line 478
	} else {       /* should flag wrong type even if nothing to write */
#line 478
	    IF (nels > 0 && err != NC_ECHAR)
#line 478
		error("wrong type: status = %d", err);
#line 478
	}
#line 478
    }
#line 478

#line 478
        /* Preceeding has written nothing for record variables, now try */
#line 478
        /* again with more than 0 records */
#line 478

#line 478
	/* Write record number NRECS to force writing of preceding records */
#line 478
	/* Assumes variable cr is char vector with UNLIMITED dimension */
#line 478
    err = nc_inq_varid(ncid, "cr", &varid);
#line 478
    IF (err)
#line 478
        error("nc_inq_varid: %s", nc_strerror(err));
#line 478
    index[0] = NRECS-1;
#line 478
    err = nc_put_var1_text(ncid, varid, index, "x");
#line 478
    IF (err)
#line 478
        error("nc_put_var1_text: %s", nc_strerror(err));
#line 478

#line 478
    for (i = 0; i < NVARS; i++) {
#line 478
        if (var_dimid[i][0] == RECDIM) {  /* only test record variables here */
#line 478
	    canConvert = (var_type[i] == NC_CHAR) == (NCT_TEXT == NCT_TEXT);
#line 478
	    assert(var_rank[i] <= MAX_RANK);
#line 478
	    assert(var_nels[i] <= MAX_NELS);
#line 478
	    err = nc_put_var_text(BAD_ID, i, value);
#line 478
	    IF (err != NC_EBADID) 
#line 478
	        error("bad ncid: status = %d", err);
#line 478
	    nels = 1;
#line 478
	    for (j = 0; j < var_rank[i]; j++) {
#line 478
		nels *= var_shape[i][j];
#line 478
	    }
#line 478
	    for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 478
		err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 478
		IF (err) 
#line 478
		    error("error in toMixedBase 1");
#line 478
		value[j]= hash_text(var_type[i], var_rank[i], index, NCT_TEXT);
#line 478
		allInExtRange = allInExtRange 
#line 478
		    && inRange3(value[j], var_type[i], NCT_TEXT);
#line 478
	    }
#line 478
	    err = nc_put_var_text(ncid, i, value);
#line 478
	    if (canConvert) {
#line 478
		if (allInExtRange) {
#line 478
		    IF (err) 
#line 478
			error("%s", nc_strerror(err));
#line 478
		} else {
#line 478
		    IF (err != NC_ERANGE)
#line 478
			error("range error: status = %d", err);
#line 478
		}
#line 478
	    } else {
#line 478
		IF (nels > 0 && err != NC_ECHAR)
#line 478
		    error("wrong type: status = %d", err);
#line 478
	    }
#line 478
        }
#line 478
    }
#line 478

#line 478
    err = nc_close(ncid);
#line 478
    IF (err) 
#line 478
	error("nc_close: %s", nc_strerror(err));
#line 478

#line 478
    check_vars_text(scratch);
#line 478

#line 478
    err = remove(scratch);
#line 478
    IF (err)
#line 478
        error("remove of %s failed", scratch);
#line 478
}
#line 478

void
#line 479
test_nc_put_var_uchar(void)
#line 479
{
#line 479
    int ncid;
#line 479
    int varid;
#line 479
    int i;
#line 479
    int j;
#line 479
    int err;
#line 479
    int nels;
#line 479
    size_t index[MAX_RANK];
#line 479
    int canConvert;	/* Both text or both numeric */
#line 479
    int allInExtRange;	/* all values within external range? */
#line 479
    uchar value[MAX_NELS];
#line 479

#line 479
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 479
    IF (err) {
#line 479
        error("nc_create: %s", nc_strerror(err));
#line 479
        return;
#line 479
    }
#line 479
    def_dims(ncid);
#line 479
    def_vars(ncid);
#line 479
    err = nc_enddef(ncid);
#line 479
    IF (err)
#line 479
        error("nc_enddef: %s", nc_strerror(err));
#line 479

#line 479
    for (i = 0; i < NVARS; i++) {
#line 479
	canConvert = (var_type[i] == NC_CHAR) == (NCT_UCHAR == NCT_TEXT);
#line 479
        assert(var_rank[i] <= MAX_RANK);
#line 479
        assert(var_nels[i] <= MAX_NELS);
#line 479
        err = nc_put_var_uchar(BAD_ID, i, value);
#line 479
        IF (err != NC_EBADID) 
#line 479
	    error("bad ncid: status = %d", err);
#line 479
        err = nc_put_var_uchar(ncid, BAD_VARID, value);
#line 479
        IF (err != NC_ENOTVAR) 
#line 479
	    error("bad var id: status = %d", err);
#line 479

#line 479
	nels = 1;
#line 479
	for (j = 0; j < var_rank[i]; j++) {
#line 479
	    nels *= var_shape[i][j];
#line 479
	}
#line 479
	for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 479
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 479
	    IF (err) 
#line 479
		error("error in toMixedBase 1");
#line 479
	    value[j]= hash_uchar(var_type[i], var_rank[i], index, NCT_UCHAR);
#line 479
	    allInExtRange = allInExtRange 
#line 479
		&& inRange3(value[j], var_type[i], NCT_UCHAR);
#line 479
	}
#line 479
        err = nc_put_var_uchar(ncid, i, value);
#line 479
	if (canConvert) {
#line 479
	    if (allInExtRange) {
#line 479
		IF (err) 
#line 479
		    error("%s", nc_strerror(err));
#line 479
	    } else {
#line 479
		IF (err != NC_ERANGE && var_dimid[i][0] != RECDIM)
#line 479
		    error("range error: status = %d", err);
#line 479
	    }
#line 479
	} else {       /* should flag wrong type even if nothing to write */
#line 479
	    IF (nels > 0 && err != NC_ECHAR)
#line 479
		error("wrong type: status = %d", err);
#line 479
	}
#line 479
    }
#line 479

#line 479
        /* Preceeding has written nothing for record variables, now try */
#line 479
        /* again with more than 0 records */
#line 479

#line 479
	/* Write record number NRECS to force writing of preceding records */
#line 479
	/* Assumes variable cr is char vector with UNLIMITED dimension */
#line 479
    err = nc_inq_varid(ncid, "cr", &varid);
#line 479
    IF (err)
#line 479
        error("nc_inq_varid: %s", nc_strerror(err));
#line 479
    index[0] = NRECS-1;
#line 479
    err = nc_put_var1_text(ncid, varid, index, "x");
#line 479
    IF (err)
#line 479
        error("nc_put_var1_text: %s", nc_strerror(err));
#line 479

#line 479
    for (i = 0; i < NVARS; i++) {
#line 479
        if (var_dimid[i][0] == RECDIM) {  /* only test record variables here */
#line 479
	    canConvert = (var_type[i] == NC_CHAR) == (NCT_UCHAR == NCT_TEXT);
#line 479
	    assert(var_rank[i] <= MAX_RANK);
#line 479
	    assert(var_nels[i] <= MAX_NELS);
#line 479
	    err = nc_put_var_uchar(BAD_ID, i, value);
#line 479
	    IF (err != NC_EBADID) 
#line 479
	        error("bad ncid: status = %d", err);
#line 479
	    nels = 1;
#line 479
	    for (j = 0; j < var_rank[i]; j++) {
#line 479
		nels *= var_shape[i][j];
#line 479
	    }
#line 479
	    for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 479
		err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 479
		IF (err) 
#line 479
		    error("error in toMixedBase 1");
#line 479
		value[j]= hash_uchar(var_type[i], var_rank[i], index, NCT_UCHAR);
#line 479
		allInExtRange = allInExtRange 
#line 479
		    && inRange3(value[j], var_type[i], NCT_UCHAR);
#line 479
	    }
#line 479
	    err = nc_put_var_uchar(ncid, i, value);
#line 479
	    if (canConvert) {
#line 479
		if (allInExtRange) {
#line 479
		    IF (err) 
#line 479
			error("%s", nc_strerror(err));
#line 479
		} else {
#line 479
		    IF (err != NC_ERANGE)
#line 479
			error("range error: status = %d", err);
#line 479
		}
#line 479
	    } else {
#line 479
		IF (nels > 0 && err != NC_ECHAR)
#line 479
		    error("wrong type: status = %d", err);
#line 479
	    }
#line 479
        }
#line 479
    }
#line 479

#line 479
    err = nc_close(ncid);
#line 479
    IF (err) 
#line 479
	error("nc_close: %s", nc_strerror(err));
#line 479

#line 479
    check_vars_uchar(scratch);
#line 479

#line 479
    err = remove(scratch);
#line 479
    IF (err)
#line 479
        error("remove of %s failed", scratch);
#line 479
}
#line 479

void
#line 480
test_nc_put_var_schar(void)
#line 480
{
#line 480
    int ncid;
#line 480
    int varid;
#line 480
    int i;
#line 480
    int j;
#line 480
    int err;
#line 480
    int nels;
#line 480
    size_t index[MAX_RANK];
#line 480
    int canConvert;	/* Both text or both numeric */
#line 480
    int allInExtRange;	/* all values within external range? */
#line 480
    schar value[MAX_NELS];
#line 480

#line 480
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 480
    IF (err) {
#line 480
        error("nc_create: %s", nc_strerror(err));
#line 480
        return;
#line 480
    }
#line 480
    def_dims(ncid);
#line 480
    def_vars(ncid);
#line 480
    err = nc_enddef(ncid);
#line 480
    IF (err)
#line 480
        error("nc_enddef: %s", nc_strerror(err));
#line 480

#line 480
    for (i = 0; i < NVARS; i++) {
#line 480
	canConvert = (var_type[i] == NC_CHAR) == (NCT_SCHAR == NCT_TEXT);
#line 480
        assert(var_rank[i] <= MAX_RANK);
#line 480
        assert(var_nels[i] <= MAX_NELS);
#line 480
        err = nc_put_var_schar(BAD_ID, i, value);
#line 480
        IF (err != NC_EBADID) 
#line 480
	    error("bad ncid: status = %d", err);
#line 480
        err = nc_put_var_schar(ncid, BAD_VARID, value);
#line 480
        IF (err != NC_ENOTVAR) 
#line 480
	    error("bad var id: status = %d", err);
#line 480

#line 480
	nels = 1;
#line 480
	for (j = 0; j < var_rank[i]; j++) {
#line 480
	    nels *= var_shape[i][j];
#line 480
	}
#line 480
	for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 480
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 480
	    IF (err) 
#line 480
		error("error in toMixedBase 1");
#line 480
	    value[j]= hash_schar(var_type[i], var_rank[i], index, NCT_SCHAR);
#line 480
	    allInExtRange = allInExtRange 
#line 480
		&& inRange3(value[j], var_type[i], NCT_SCHAR);
#line 480
	}
#line 480
        err = nc_put_var_schar(ncid, i, value);
#line 480
	if (canConvert) {
#line 480
	    if (allInExtRange) {
#line 480
		IF (err) 
#line 480
		    error("%s", nc_strerror(err));
#line 480
	    } else {
#line 480
		IF (err != NC_ERANGE && var_dimid[i][0] != RECDIM)
#line 480
		    error("range error: status = %d", err);
#line 480
	    }
#line 480
	} else {       /* should flag wrong type even if nothing to write */
#line 480
	    IF (nels > 0 && err != NC_ECHAR)
#line 480
		error("wrong type: status = %d", err);
#line 480
	}
#line 480
    }
#line 480

#line 480
        /* Preceeding has written nothing for record variables, now try */
#line 480
        /* again with more than 0 records */
#line 480

#line 480
	/* Write record number NRECS to force writing of preceding records */
#line 480
	/* Assumes variable cr is char vector with UNLIMITED dimension */
#line 480
    err = nc_inq_varid(ncid, "cr", &varid);
#line 480
    IF (err)
#line 480
        error("nc_inq_varid: %s", nc_strerror(err));
#line 480
    index[0] = NRECS-1;
#line 480
    err = nc_put_var1_text(ncid, varid, index, "x");
#line 480
    IF (err)
#line 480
        error("nc_put_var1_text: %s", nc_strerror(err));
#line 480

#line 480
    for (i = 0; i < NVARS; i++) {
#line 480
        if (var_dimid[i][0] == RECDIM) {  /* only test record variables here */
#line 480
	    canConvert = (var_type[i] == NC_CHAR) == (NCT_SCHAR == NCT_TEXT);
#line 480
	    assert(var_rank[i] <= MAX_RANK);
#line 480
	    assert(var_nels[i] <= MAX_NELS);
#line 480
	    err = nc_put_var_schar(BAD_ID, i, value);
#line 480
	    IF (err != NC_EBADID) 
#line 480
	        error("bad ncid: status = %d", err);
#line 480
	    nels = 1;
#line 480
	    for (j = 0; j < var_rank[i]; j++) {
#line 480
		nels *= var_shape[i][j];
#line 480
	    }
#line 480
	    for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 480
		err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 480
		IF (err) 
#line 480
		    error("error in toMixedBase 1");
#line 480
		value[j]= hash_schar(var_type[i], var_rank[i], index, NCT_SCHAR);
#line 480
		allInExtRange = allInExtRange 
#line 480
		    && inRange3(value[j], var_type[i], NCT_SCHAR);
#line 480
	    }
#line 480
	    err = nc_put_var_schar(ncid, i, value);
#line 480
	    if (canConvert) {
#line 480
		if (allInExtRange) {
#line 480
		    IF (err) 
#line 480
			error("%s", nc_strerror(err));
#line 480
		} else {
#line 480
		    IF (err != NC_ERANGE)
#line 480
			error("range error: status = %d", err);
#line 480
		}
#line 480
	    } else {
#line 480
		IF (nels > 0 && err != NC_ECHAR)
#line 480
		    error("wrong type: status = %d", err);
#line 480
	    }
#line 480
        }
#line 480
    }
#line 480

#line 480
    err = nc_close(ncid);
#line 480
    IF (err) 
#line 480
	error("nc_close: %s", nc_strerror(err));
#line 480

#line 480
    check_vars_schar(scratch);
#line 480

#line 480
    err = remove(scratch);
#line 480
    IF (err)
#line 480
        error("remove of %s failed", scratch);
#line 480
}
#line 480

void
#line 481
test_nc_put_var_short(void)
#line 481
{
#line 481
    int ncid;
#line 481
    int varid;
#line 481
    int i;
#line 481
    int j;
#line 481
    int err;
#line 481
    int nels;
#line 481
    size_t index[MAX_RANK];
#line 481
    int canConvert;	/* Both text or both numeric */
#line 481
    int allInExtRange;	/* all values within external range? */
#line 481
    short value[MAX_NELS];
#line 481

#line 481
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 481
    IF (err) {
#line 481
        error("nc_create: %s", nc_strerror(err));
#line 481
        return;
#line 481
    }
#line 481
    def_dims(ncid);
#line 481
    def_vars(ncid);
#line 481
    err = nc_enddef(ncid);
#line 481
    IF (err)
#line 481
        error("nc_enddef: %s", nc_strerror(err));
#line 481

#line 481
    for (i = 0; i < NVARS; i++) {
#line 481
	canConvert = (var_type[i] == NC_CHAR) == (NCT_SHORT == NCT_TEXT);
#line 481
        assert(var_rank[i] <= MAX_RANK);
#line 481
        assert(var_nels[i] <= MAX_NELS);
#line 481
        err = nc_put_var_short(BAD_ID, i, value);
#line 481
        IF (err != NC_EBADID) 
#line 481
	    error("bad ncid: status = %d", err);
#line 481
        err = nc_put_var_short(ncid, BAD_VARID, value);
#line 481
        IF (err != NC_ENOTVAR) 
#line 481
	    error("bad var id: status = %d", err);
#line 481

#line 481
	nels = 1;
#line 481
	for (j = 0; j < var_rank[i]; j++) {
#line 481
	    nels *= var_shape[i][j];
#line 481
	}
#line 481
	for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 481
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 481
	    IF (err) 
#line 481
		error("error in toMixedBase 1");
#line 481
	    value[j]= hash_short(var_type[i], var_rank[i], index, NCT_SHORT);
#line 481
	    allInExtRange = allInExtRange 
#line 481
		&& inRange3(value[j], var_type[i], NCT_SHORT);
#line 481
	}
#line 481
        err = nc_put_var_short(ncid, i, value);
#line 481
	if (canConvert) {
#line 481
	    if (allInExtRange) {
#line 481
		IF (err) 
#line 481
		    error("%s", nc_strerror(err));
#line 481
	    } else {
#line 481
		IF (err != NC_ERANGE && var_dimid[i][0] != RECDIM)
#line 481
		    error("range error: status = %d", err);
#line 481
	    }
#line 481
	} else {       /* should flag wrong type even if nothing to write */
#line 481
	    IF (nels > 0 && err != NC_ECHAR)
#line 481
		error("wrong type: status = %d", err);
#line 481
	}
#line 481
    }
#line 481

#line 481
        /* Preceeding has written nothing for record variables, now try */
#line 481
        /* again with more than 0 records */
#line 481

#line 481
	/* Write record number NRECS to force writing of preceding records */
#line 481
	/* Assumes variable cr is char vector with UNLIMITED dimension */
#line 481
    err = nc_inq_varid(ncid, "cr", &varid);
#line 481
    IF (err)
#line 481
        error("nc_inq_varid: %s", nc_strerror(err));
#line 481
    index[0] = NRECS-1;
#line 481
    err = nc_put_var1_text(ncid, varid, index, "x");
#line 481
    IF (err)
#line 481
        error("nc_put_var1_text: %s", nc_strerror(err));
#line 481

#line 481
    for (i = 0; i < NVARS; i++) {
#line 481
        if (var_dimid[i][0] == RECDIM) {  /* only test record variables here */
#line 481
	    canConvert = (var_type[i] == NC_CHAR) == (NCT_SHORT == NCT_TEXT);
#line 481
	    assert(var_rank[i] <= MAX_RANK);
#line 481
	    assert(var_nels[i] <= MAX_NELS);
#line 481
	    err = nc_put_var_short(BAD_ID, i, value);
#line 481
	    IF (err != NC_EBADID) 
#line 481
	        error("bad ncid: status = %d", err);
#line 481
	    nels = 1;
#line 481
	    for (j = 0; j < var_rank[i]; j++) {
#line 481
		nels *= var_shape[i][j];
#line 481
	    }
#line 481
	    for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 481
		err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 481
		IF (err) 
#line 481
		    error("error in toMixedBase 1");
#line 481
		value[j]= hash_short(var_type[i], var_rank[i], index, NCT_SHORT);
#line 481
		allInExtRange = allInExtRange 
#line 481
		    && inRange3(value[j], var_type[i], NCT_SHORT);
#line 481
	    }
#line 481
	    err = nc_put_var_short(ncid, i, value);
#line 481
	    if (canConvert) {
#line 481
		if (allInExtRange) {
#line 481
		    IF (err) 
#line 481
			error("%s", nc_strerror(err));
#line 481
		} else {
#line 481
		    IF (err != NC_ERANGE)
#line 481
			error("range error: status = %d", err);
#line 481
		}
#line 481
	    } else {
#line 481
		IF (nels > 0 && err != NC_ECHAR)
#line 481
		    error("wrong type: status = %d", err);
#line 481
	    }
#line 481
        }
#line 481
    }
#line 481

#line 481
    err = nc_close(ncid);
#line 481
    IF (err) 
#line 481
	error("nc_close: %s", nc_strerror(err));
#line 481

#line 481
    check_vars_short(scratch);
#line 481

#line 481
    err = remove(scratch);
#line 481
    IF (err)
#line 481
        error("remove of %s failed", scratch);
#line 481
}
#line 481

void
#line 482
test_nc_put_var_int(void)
#line 482
{
#line 482
    int ncid;
#line 482
    int varid;
#line 482
    int i;
#line 482
    int j;
#line 482
    int err;
#line 482
    int nels;
#line 482
    size_t index[MAX_RANK];
#line 482
    int canConvert;	/* Both text or both numeric */
#line 482
    int allInExtRange;	/* all values within external range? */
#line 482
    int value[MAX_NELS];
#line 482

#line 482
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 482
    IF (err) {
#line 482
        error("nc_create: %s", nc_strerror(err));
#line 482
        return;
#line 482
    }
#line 482
    def_dims(ncid);
#line 482
    def_vars(ncid);
#line 482
    err = nc_enddef(ncid);
#line 482
    IF (err)
#line 482
        error("nc_enddef: %s", nc_strerror(err));
#line 482

#line 482
    for (i = 0; i < NVARS; i++) {
#line 482
	canConvert = (var_type[i] == NC_CHAR) == (NCT_INT == NCT_TEXT);
#line 482
        assert(var_rank[i] <= MAX_RANK);
#line 482
        assert(var_nels[i] <= MAX_NELS);
#line 482
        err = nc_put_var_int(BAD_ID, i, value);
#line 482
        IF (err != NC_EBADID) 
#line 482
	    error("bad ncid: status = %d", err);
#line 482
        err = nc_put_var_int(ncid, BAD_VARID, value);
#line 482
        IF (err != NC_ENOTVAR) 
#line 482
	    error("bad var id: status = %d", err);
#line 482

#line 482
	nels = 1;
#line 482
	for (j = 0; j < var_rank[i]; j++) {
#line 482
	    nels *= var_shape[i][j];
#line 482
	}
#line 482
	for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 482
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 482
	    IF (err) 
#line 482
		error("error in toMixedBase 1");
#line 482
	    value[j]= hash_int(var_type[i], var_rank[i], index, NCT_INT);
#line 482
	    allInExtRange = allInExtRange 
#line 482
		&& inRange3(value[j], var_type[i], NCT_INT);
#line 482
	}
#line 482
        err = nc_put_var_int(ncid, i, value);
#line 482
	if (canConvert) {
#line 482
	    if (allInExtRange) {
#line 482
		IF (err) 
#line 482
		    error("%s", nc_strerror(err));
#line 482
	    } else {
#line 482
		IF (err != NC_ERANGE && var_dimid[i][0] != RECDIM)
#line 482
		    error("range error: status = %d", err);
#line 482
	    }
#line 482
	} else {       /* should flag wrong type even if nothing to write */
#line 482
	    IF (nels > 0 && err != NC_ECHAR)
#line 482
		error("wrong type: status = %d", err);
#line 482
	}
#line 482
    }
#line 482

#line 482
        /* Preceeding has written nothing for record variables, now try */
#line 482
        /* again with more than 0 records */
#line 482

#line 482
	/* Write record number NRECS to force writing of preceding records */
#line 482
	/* Assumes variable cr is char vector with UNLIMITED dimension */
#line 482
    err = nc_inq_varid(ncid, "cr", &varid);
#line 482
    IF (err)
#line 482
        error("nc_inq_varid: %s", nc_strerror(err));
#line 482
    index[0] = NRECS-1;
#line 482
    err = nc_put_var1_text(ncid, varid, index, "x");
#line 482
    IF (err)
#line 482
        error("nc_put_var1_text: %s", nc_strerror(err));
#line 482

#line 482
    for (i = 0; i < NVARS; i++) {
#line 482
        if (var_dimid[i][0] == RECDIM) {  /* only test record variables here */
#line 482
	    canConvert = (var_type[i] == NC_CHAR) == (NCT_INT == NCT_TEXT);
#line 482
	    assert(var_rank[i] <= MAX_RANK);
#line 482
	    assert(var_nels[i] <= MAX_NELS);
#line 482
	    err = nc_put_var_int(BAD_ID, i, value);
#line 482
	    IF (err != NC_EBADID) 
#line 482
	        error("bad ncid: status = %d", err);
#line 482
	    nels = 1;
#line 482
	    for (j = 0; j < var_rank[i]; j++) {
#line 482
		nels *= var_shape[i][j];
#line 482
	    }
#line 482
	    for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 482
		err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 482
		IF (err) 
#line 482
		    error("error in toMixedBase 1");
#line 482
		value[j]= hash_int(var_type[i], var_rank[i], index, NCT_INT);
#line 482
		allInExtRange = allInExtRange 
#line 482
		    && inRange3(value[j], var_type[i], NCT_INT);
#line 482
	    }
#line 482
	    err = nc_put_var_int(ncid, i, value);
#line 482
	    if (canConvert) {
#line 482
		if (allInExtRange) {
#line 482
		    IF (err) 
#line 482
			error("%s", nc_strerror(err));
#line 482
		} else {
#line 482
		    IF (err != NC_ERANGE)
#line 482
			error("range error: status = %d", err);
#line 482
		}
#line 482
	    } else {
#line 482
		IF (nels > 0 && err != NC_ECHAR)
#line 482
		    error("wrong type: status = %d", err);
#line 482
	    }
#line 482
        }
#line 482
    }
#line 482

#line 482
    err = nc_close(ncid);
#line 482
    IF (err) 
#line 482
	error("nc_close: %s", nc_strerror(err));
#line 482

#line 482
    check_vars_int(scratch);
#line 482

#line 482
    err = remove(scratch);
#line 482
    IF (err)
#line 482
        error("remove of %s failed", scratch);
#line 482
}
#line 482

void
#line 483
test_nc_put_var_long(void)
#line 483
{
#line 483
    int ncid;
#line 483
    int varid;
#line 483
    int i;
#line 483
    int j;
#line 483
    int err;
#line 483
    int nels;
#line 483
    size_t index[MAX_RANK];
#line 483
    int canConvert;	/* Both text or both numeric */
#line 483
    int allInExtRange;	/* all values within external range? */
#line 483
    long value[MAX_NELS];
#line 483

#line 483
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 483
    IF (err) {
#line 483
        error("nc_create: %s", nc_strerror(err));
#line 483
        return;
#line 483
    }
#line 483
    def_dims(ncid);
#line 483
    def_vars(ncid);
#line 483
    err = nc_enddef(ncid);
#line 483
    IF (err)
#line 483
        error("nc_enddef: %s", nc_strerror(err));
#line 483

#line 483
    for (i = 0; i < NVARS; i++) {
#line 483
	canConvert = (var_type[i] == NC_CHAR) == (NCT_LONG == NCT_TEXT);
#line 483
        assert(var_rank[i] <= MAX_RANK);
#line 483
        assert(var_nels[i] <= MAX_NELS);
#line 483
        err = nc_put_var_long(BAD_ID, i, value);
#line 483
        IF (err != NC_EBADID) 
#line 483
	    error("bad ncid: status = %d", err);
#line 483
        err = nc_put_var_long(ncid, BAD_VARID, value);
#line 483
        IF (err != NC_ENOTVAR) 
#line 483
	    error("bad var id: status = %d", err);
#line 483

#line 483
	nels = 1;
#line 483
	for (j = 0; j < var_rank[i]; j++) {
#line 483
	    nels *= var_shape[i][j];
#line 483
	}
#line 483
	for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 483
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 483
	    IF (err) 
#line 483
		error("error in toMixedBase 1");
#line 483
	    value[j]= hash_long(var_type[i], var_rank[i], index, NCT_LONG);
#line 483
	    allInExtRange = allInExtRange 
#line 483
		&& inRange3(value[j], var_type[i], NCT_LONG);
#line 483
	}
#line 483
        err = nc_put_var_long(ncid, i, value);
#line 483
	if (canConvert) {
#line 483
	    if (allInExtRange) {
#line 483
		IF (err) 
#line 483
		    error("%s", nc_strerror(err));
#line 483
	    } else {
#line 483
		IF (err != NC_ERANGE && var_dimid[i][0] != RECDIM)
#line 483
		    error("range error: status = %d", err);
#line 483
	    }
#line 483
	} else {       /* should flag wrong type even if nothing to write */
#line 483
	    IF (nels > 0 && err != NC_ECHAR)
#line 483
		error("wrong type: status = %d", err);
#line 483
	}
#line 483
    }
#line 483

#line 483
        /* Preceeding has written nothing for record variables, now try */
#line 483
        /* again with more than 0 records */
#line 483

#line 483
	/* Write record number NRECS to force writing of preceding records */
#line 483
	/* Assumes variable cr is char vector with UNLIMITED dimension */
#line 483
    err = nc_inq_varid(ncid, "cr", &varid);
#line 483
    IF (err)
#line 483
        error("nc_inq_varid: %s", nc_strerror(err));
#line 483
    index[0] = NRECS-1;
#line 483
    err = nc_put_var1_text(ncid, varid, index, "x");
#line 483
    IF (err)
#line 483
        error("nc_put_var1_text: %s", nc_strerror(err));
#line 483

#line 483
    for (i = 0; i < NVARS; i++) {
#line 483
        if (var_dimid[i][0] == RECDIM) {  /* only test record variables here */
#line 483
	    canConvert = (var_type[i] == NC_CHAR) == (NCT_LONG == NCT_TEXT);
#line 483
	    assert(var_rank[i] <= MAX_RANK);
#line 483
	    assert(var_nels[i] <= MAX_NELS);
#line 483
	    err = nc_put_var_long(BAD_ID, i, value);
#line 483
	    IF (err != NC_EBADID) 
#line 483
	        error("bad ncid: status = %d", err);
#line 483
	    nels = 1;
#line 483
	    for (j = 0; j < var_rank[i]; j++) {
#line 483
		nels *= var_shape[i][j];
#line 483
	    }
#line 483
	    for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 483
		err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 483
		IF (err) 
#line 483
		    error("error in toMixedBase 1");
#line 483
		value[j]= hash_long(var_type[i], var_rank[i], index, NCT_LONG);
#line 483
		allInExtRange = allInExtRange 
#line 483
		    && inRange3(value[j], var_type[i], NCT_LONG);
#line 483
	    }
#line 483
	    err = nc_put_var_long(ncid, i, value);
#line 483
	    if (canConvert) {
#line 483
		if (allInExtRange) {
#line 483
		    IF (err) 
#line 483
			error("%s", nc_strerror(err));
#line 483
		} else {
#line 483
		    IF (err != NC_ERANGE)
#line 483
			error("range error: status = %d", err);
#line 483
		}
#line 483
	    } else {
#line 483
		IF (nels > 0 && err != NC_ECHAR)
#line 483
		    error("wrong type: status = %d", err);
#line 483
	    }
#line 483
        }
#line 483
    }
#line 483

#line 483
    err = nc_close(ncid);
#line 483
    IF (err) 
#line 483
	error("nc_close: %s", nc_strerror(err));
#line 483

#line 483
    check_vars_long(scratch);
#line 483

#line 483
    err = remove(scratch);
#line 483
    IF (err)
#line 483
        error("remove of %s failed", scratch);
#line 483
}
#line 483

void
#line 484
test_nc_put_var_float(void)
#line 484
{
#line 484
    int ncid;
#line 484
    int varid;
#line 484
    int i;
#line 484
    int j;
#line 484
    int err;
#line 484
    int nels;
#line 484
    size_t index[MAX_RANK];
#line 484
    int canConvert;	/* Both text or both numeric */
#line 484
    int allInExtRange;	/* all values within external range? */
#line 484
    float value[MAX_NELS];
#line 484

#line 484
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 484
    IF (err) {
#line 484
        error("nc_create: %s", nc_strerror(err));
#line 484
        return;
#line 484
    }
#line 484
    def_dims(ncid);
#line 484
    def_vars(ncid);
#line 484
    err = nc_enddef(ncid);
#line 484
    IF (err)
#line 484
        error("nc_enddef: %s", nc_strerror(err));
#line 484

#line 484
    for (i = 0; i < NVARS; i++) {
#line 484
	canConvert = (var_type[i] == NC_CHAR) == (NCT_FLOAT == NCT_TEXT);
#line 484
        assert(var_rank[i] <= MAX_RANK);
#line 484
        assert(var_nels[i] <= MAX_NELS);
#line 484
        err = nc_put_var_float(BAD_ID, i, value);
#line 484
        IF (err != NC_EBADID) 
#line 484
	    error("bad ncid: status = %d", err);
#line 484
        err = nc_put_var_float(ncid, BAD_VARID, value);
#line 484
        IF (err != NC_ENOTVAR) 
#line 484
	    error("bad var id: status = %d", err);
#line 484

#line 484
	nels = 1;
#line 484
	for (j = 0; j < var_rank[i]; j++) {
#line 484
	    nels *= var_shape[i][j];
#line 484
	}
#line 484
	for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 484
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 484
	    IF (err) 
#line 484
		error("error in toMixedBase 1");
#line 484
	    value[j]= hash_float(var_type[i], var_rank[i], index, NCT_FLOAT);
#line 484
	    allInExtRange = allInExtRange 
#line 484
		&& inRange3(value[j], var_type[i], NCT_FLOAT);
#line 484
	}
#line 484
        err = nc_put_var_float(ncid, i, value);
#line 484
	if (canConvert) {
#line 484
	    if (allInExtRange) {
#line 484
		IF (err) 
#line 484
		    error("%s", nc_strerror(err));
#line 484
	    } else {
#line 484
		IF (err != NC_ERANGE && var_dimid[i][0] != RECDIM)
#line 484
		    error("range error: status = %d", err);
#line 484
	    }
#line 484
	} else {       /* should flag wrong type even if nothing to write */
#line 484
	    IF (nels > 0 && err != NC_ECHAR)
#line 484
		error("wrong type: status = %d", err);
#line 484
	}
#line 484
    }
#line 484

#line 484
        /* Preceeding has written nothing for record variables, now try */
#line 484
        /* again with more than 0 records */
#line 484

#line 484
	/* Write record number NRECS to force writing of preceding records */
#line 484
	/* Assumes variable cr is char vector with UNLIMITED dimension */
#line 484
    err = nc_inq_varid(ncid, "cr", &varid);
#line 484
    IF (err)
#line 484
        error("nc_inq_varid: %s", nc_strerror(err));
#line 484
    index[0] = NRECS-1;
#line 484
    err = nc_put_var1_text(ncid, varid, index, "x");
#line 484
    IF (err)
#line 484
        error("nc_put_var1_text: %s", nc_strerror(err));
#line 484

#line 484
    for (i = 0; i < NVARS; i++) {
#line 484
        if (var_dimid[i][0] == RECDIM) {  /* only test record variables here */
#line 484
	    canConvert = (var_type[i] == NC_CHAR) == (NCT_FLOAT == NCT_TEXT);
#line 484
	    assert(var_rank[i] <= MAX_RANK);
#line 484
	    assert(var_nels[i] <= MAX_NELS);
#line 484
	    err = nc_put_var_float(BAD_ID, i, value);
#line 484
	    IF (err != NC_EBADID) 
#line 484
	        error("bad ncid: status = %d", err);
#line 484
	    nels = 1;
#line 484
	    for (j = 0; j < var_rank[i]; j++) {
#line 484
		nels *= var_shape[i][j];
#line 484
	    }
#line 484
	    for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 484
		err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 484
		IF (err) 
#line 484
		    error("error in toMixedBase 1");
#line 484
		value[j]= hash_float(var_type[i], var_rank[i], index, NCT_FLOAT);
#line 484
		allInExtRange = allInExtRange 
#line 484
		    && inRange3(value[j], var_type[i], NCT_FLOAT);
#line 484
	    }
#line 484
	    err = nc_put_var_float(ncid, i, value);
#line 484
	    if (canConvert) {
#line 484
		if (allInExtRange) {
#line 484
		    IF (err) 
#line 484
			error("%s", nc_strerror(err));
#line 484
		} else {
#line 484
		    IF (err != NC_ERANGE)
#line 484
			error("range error: status = %d", err);
#line 484
		}
#line 484
	    } else {
#line 484
		IF (nels > 0 && err != NC_ECHAR)
#line 484
		    error("wrong type: status = %d", err);
#line 484
	    }
#line 484
        }
#line 484
    }
#line 484

#line 484
    err = nc_close(ncid);
#line 484
    IF (err) 
#line 484
	error("nc_close: %s", nc_strerror(err));
#line 484

#line 484
    check_vars_float(scratch);
#line 484

#line 484
    err = remove(scratch);
#line 484
    IF (err)
#line 484
        error("remove of %s failed", scratch);
#line 484
}
#line 484

void
#line 485
test_nc_put_var_double(void)
#line 485
{
#line 485
    int ncid;
#line 485
    int varid;
#line 485
    int i;
#line 485
    int j;
#line 485
    int err;
#line 485
    int nels;
#line 485
    size_t index[MAX_RANK];
#line 485
    int canConvert;	/* Both text or both numeric */
#line 485
    int allInExtRange;	/* all values within external range? */
#line 485
    double value[MAX_NELS];
#line 485

#line 485
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 485
    IF (err) {
#line 485
        error("nc_create: %s", nc_strerror(err));
#line 485
        return;
#line 485
    }
#line 485
    def_dims(ncid);
#line 485
    def_vars(ncid);
#line 485
    err = nc_enddef(ncid);
#line 485
    IF (err)
#line 485
        error("nc_enddef: %s", nc_strerror(err));
#line 485

#line 485
    for (i = 0; i < NVARS; i++) {
#line 485
	canConvert = (var_type[i] == NC_CHAR) == (NCT_DOUBLE == NCT_TEXT);
#line 485
        assert(var_rank[i] <= MAX_RANK);
#line 485
        assert(var_nels[i] <= MAX_NELS);
#line 485
        err = nc_put_var_double(BAD_ID, i, value);
#line 485
        IF (err != NC_EBADID) 
#line 485
	    error("bad ncid: status = %d", err);
#line 485
        err = nc_put_var_double(ncid, BAD_VARID, value);
#line 485
        IF (err != NC_ENOTVAR) 
#line 485
	    error("bad var id: status = %d", err);
#line 485

#line 485
	nels = 1;
#line 485
	for (j = 0; j < var_rank[i]; j++) {
#line 485
	    nels *= var_shape[i][j];
#line 485
	}
#line 485
	for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 485
	    err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 485
	    IF (err) 
#line 485
		error("error in toMixedBase 1");
#line 485
	    value[j]= hash_double(var_type[i], var_rank[i], index, NCT_DOUBLE);
#line 485
	    allInExtRange = allInExtRange 
#line 485
		&& inRange3(value[j], var_type[i], NCT_DOUBLE);
#line 485
	}
#line 485
        err = nc_put_var_double(ncid, i, value);
#line 485
	if (canConvert) {
#line 485
	    if (allInExtRange) {
#line 485
		IF (err) 
#line 485
		    error("%s", nc_strerror(err));
#line 485
	    } else {
#line 485
		IF (err != NC_ERANGE && var_dimid[i][0] != RECDIM)
#line 485
		    error("range error: status = %d", err);
#line 485
	    }
#line 485
	} else {       /* should flag wrong type even if nothing to write */
#line 485
	    IF (nels > 0 && err != NC_ECHAR)
#line 485
		error("wrong type: status = %d", err);
#line 485
	}
#line 485
    }
#line 485

#line 485
        /* Preceeding has written nothing for record variables, now try */
#line 485
        /* again with more than 0 records */
#line 485

#line 485
	/* Write record number NRECS to force writing of preceding records */
#line 485
	/* Assumes variable cr is char vector with UNLIMITED dimension */
#line 485
    err = nc_inq_varid(ncid, "cr", &varid);
#line 485
    IF (err)
#line 485
        error("nc_inq_varid: %s", nc_strerror(err));
#line 485
    index[0] = NRECS-1;
#line 485
    err = nc_put_var1_text(ncid, varid, index, "x");
#line 485
    IF (err)
#line 485
        error("nc_put_var1_text: %s", nc_strerror(err));
#line 485

#line 485
    for (i = 0; i < NVARS; i++) {
#line 485
        if (var_dimid[i][0] == RECDIM) {  /* only test record variables here */
#line 485
	    canConvert = (var_type[i] == NC_CHAR) == (NCT_DOUBLE == NCT_TEXT);
#line 485
	    assert(var_rank[i] <= MAX_RANK);
#line 485
	    assert(var_nels[i] <= MAX_NELS);
#line 485
	    err = nc_put_var_double(BAD_ID, i, value);
#line 485
	    IF (err != NC_EBADID) 
#line 485
	        error("bad ncid: status = %d", err);
#line 485
	    nels = 1;
#line 485
	    for (j = 0; j < var_rank[i]; j++) {
#line 485
		nels *= var_shape[i][j];
#line 485
	    }
#line 485
	    for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 485
		err = toMixedBase(j, var_rank[i], var_shape[i], index);
#line 485
		IF (err) 
#line 485
		    error("error in toMixedBase 1");
#line 485
		value[j]= hash_double(var_type[i], var_rank[i], index, NCT_DOUBLE);
#line 485
		allInExtRange = allInExtRange 
#line 485
		    && inRange3(value[j], var_type[i], NCT_DOUBLE);
#line 485
	    }
#line 485
	    err = nc_put_var_double(ncid, i, value);
#line 485
	    if (canConvert) {
#line 485
		if (allInExtRange) {
#line 485
		    IF (err) 
#line 485
			error("%s", nc_strerror(err));
#line 485
		} else {
#line 485
		    IF (err != NC_ERANGE)
#line 485
			error("range error: status = %d", err);
#line 485
		}
#line 485
	    } else {
#line 485
		IF (nels > 0 && err != NC_ECHAR)
#line 485
		    error("wrong type: status = %d", err);
#line 485
	    }
#line 485
        }
#line 485
    }
#line 485

#line 485
    err = nc_close(ncid);
#line 485
    IF (err) 
#line 485
	error("nc_close: %s", nc_strerror(err));
#line 485

#line 485
    check_vars_double(scratch);
#line 485

#line 485
    err = remove(scratch);
#line 485
    IF (err)
#line 485
        error("remove of %s failed", scratch);
#line 485
}
#line 485



#line 642

void
#line 643
test_nc_put_vara_text(void)
#line 643
{
#line 643
    int ncid;
#line 643
    int d;
#line 643
    int i;
#line 643
    int j;
#line 643
    int k;
#line 643
    int err;
#line 643
    int nslabs;
#line 643
    int nels;
#line 643
    size_t start[MAX_RANK];
#line 643
    size_t edge[MAX_RANK];
#line 643
    size_t mid[MAX_RANK];
#line 643
    size_t index[MAX_RANK];
#line 643
    int canConvert;	/* Both text or both numeric */
#line 643
    int allInExtRange;	/* all values within external range? */
#line 643
    text value[MAX_NELS];
#line 643

#line 643
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 643
    IF (err) {
#line 643
        error("nc_create: %s", nc_strerror(err));
#line 643
        return;
#line 643
    }
#line 643
    def_dims(ncid);
#line 643
    def_vars(ncid);
#line 643
    err = nc_enddef(ncid);
#line 643
    IF (err)
#line 643
        error("nc_enddef: %s", nc_strerror(err));
#line 643

#line 643
    value[0] = 0;
#line 643
    for (i = 0; i < NVARS; i++) {
#line 643
	canConvert = (var_type[i] == NC_CHAR) == (NCT_TEXT == NCT_TEXT);
#line 643
        assert(var_rank[i] <= MAX_RANK);
#line 643
        assert(var_nels[i] <= MAX_NELS);
#line 643
        for (j = 0; j < var_rank[i]; j++) {
#line 643
            start[j] = 0;
#line 643
            edge[j] = 1;
#line 643
	}
#line 643
        err = nc_put_vara_text(BAD_ID, i, start, edge, value);
#line 643
        IF (err != NC_EBADID) 
#line 643
	    error("bad ncid: status = %d", err);
#line 643
        err = nc_put_vara_text(ncid, BAD_VARID, start, edge, value);
#line 643
        IF (err != NC_ENOTVAR) 
#line 643
	    error("bad var id: status = %d", err);
#line 643
        for (j = 0; j < var_rank[i]; j++) {
#line 643
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 643
		start[j] = var_shape[i][j];
#line 643
		err = nc_put_vara_text(ncid, i, start, edge, value);
#line 643
		IF (canConvert && err != NC_EINVALCOORDS)
#line 643
		    error("bad start: status = %d", err);
#line 643
		start[j] = 0;
#line 643
		edge[j] = var_shape[i][j] + 1;
#line 643
		err = nc_put_vara_text(ncid, i, start, edge, value);
#line 643
		IF (canConvert && err != NC_EEDGE)
#line 643
		    error("bad edge: status = %d", err);
#line 643
		edge[j] = 1;
#line 643
	    }
#line 643
        }
#line 643
            /* Check correct error returned even when nothing to put */
#line 643
        for (j = 0; j < var_rank[i]; j++) {
#line 643
            edge[j] = 0;
#line 643
	}
#line 643
        err = nc_put_vara_text(BAD_ID, i, start, edge, value);
#line 643
        IF (err != NC_EBADID) 
#line 643
	    error("bad ncid: status = %d", err);
#line 643
        err = nc_put_vara_text(ncid, BAD_VARID, start, edge, value);
#line 643
        IF (err != NC_ENOTVAR) 
#line 643
	    error("bad var id: status = %d", err);
#line 643
        for (j = 0; j < var_rank[i]; j++) {
#line 643
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 643
		start[j] = var_shape[i][j];
#line 643
		err = nc_put_vara_text(ncid, i, start, edge, value);
#line 643
		IF (canConvert && err != NC_EINVALCOORDS)
#line 643
		    error("bad start: status = %d", err);
#line 643
		start[j] = 0;
#line 643
	    }
#line 643
        }
#line 643
	err = nc_put_vara_text(ncid, i, start, edge, value);
#line 643
	if (canConvert) {
#line 643
	    IF (err) 
#line 643
		error("%s", nc_strerror(err));
#line 643
	} else {
#line 643
	    IF (err != NC_ECHAR)
#line 643
		error("wrong type: status = %d", err);
#line 643
        }
#line 643
        for (j = 0; j < var_rank[i]; j++) {
#line 643
            edge[j] = 1;
#line 643
	}
#line 643

#line 643
	    /* Choose a random point dividing each dim into 2 parts */
#line 643
	    /* Put 2^rank (nslabs) slabs so defined */
#line 643
	nslabs = 1;
#line 643
	for (j = 0; j < var_rank[i]; j++) {
#line 643
            mid[j] = roll( var_shape[i][j] );
#line 643
	    nslabs *= 2;
#line 643
	}
#line 643
	    /* bits of k determine whether to put lower or upper part of dim */
#line 643
	for (k = 0; k < nslabs; k++) {
#line 643
	    nels = 1;
#line 643
	    for (j = 0; j < var_rank[i]; j++) {
#line 643
		if ((k >> j) & 1) {
#line 643
		    start[j] = 0;
#line 643
		    edge[j] = mid[j];
#line 643
		}else{
#line 643
		    start[j] = mid[j];
#line 643
		    edge[j] = var_shape[i][j] - mid[j];
#line 643
		}
#line 643
		nels *= edge[j];
#line 643
	    }
#line 643
            for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 643
		err = toMixedBase(j, var_rank[i], edge, index);
#line 643
		IF (err) 
#line 643
		    error("error in toMixedBase 1");
#line 643
		for (d = 0; d < var_rank[i]; d++) 
#line 643
		    index[d] += start[d];
#line 643
		value[j]= hash_text(var_type[i], var_rank[i], index, NCT_TEXT);
#line 643
		allInExtRange = allInExtRange 
#line 643
		    && inRange3(value[j], var_type[i], NCT_TEXT);
#line 643
	    }
#line 643
	    if (var_rank[i] == 0 && i%2 == 0)
#line 643
		err = nc_put_vara_text(ncid, i, NULL, NULL, value);
#line 643
	    else
#line 643
		err = nc_put_vara_text(ncid, i, start, edge, value);
#line 643
	    if (canConvert) {
#line 643
		if (allInExtRange) {
#line 643
		    IF (err) 
#line 643
			error("%s", nc_strerror(err));
#line 643
		} else {
#line 643
		    IF (err != NC_ERANGE)
#line 643
			error("range error: status = %d", err);
#line 643
		}
#line 643
	    } else {
#line 643
		IF (nels > 0 && err != NC_ECHAR)
#line 643
		    error("wrong type: status = %d", err);
#line 643
            }
#line 643
        }
#line 643
    }
#line 643

#line 643
    err = nc_close(ncid);
#line 643
    IF (err) 
#line 643
	error("nc_close: %s", nc_strerror(err));
#line 643

#line 643
    check_vars_text(scratch);
#line 643

#line 643
    err = remove(scratch);
#line 643
    IF (err)
#line 643
        error("remove of %s failed", scratch);
#line 643
}
#line 643

void
#line 644
test_nc_put_vara_uchar(void)
#line 644
{
#line 644
    int ncid;
#line 644
    int d;
#line 644
    int i;
#line 644
    int j;
#line 644
    int k;
#line 644
    int err;
#line 644
    int nslabs;
#line 644
    int nels;
#line 644
    size_t start[MAX_RANK];
#line 644
    size_t edge[MAX_RANK];
#line 644
    size_t mid[MAX_RANK];
#line 644
    size_t index[MAX_RANK];
#line 644
    int canConvert;	/* Both text or both numeric */
#line 644
    int allInExtRange;	/* all values within external range? */
#line 644
    uchar value[MAX_NELS];
#line 644

#line 644
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 644
    IF (err) {
#line 644
        error("nc_create: %s", nc_strerror(err));
#line 644
        return;
#line 644
    }
#line 644
    def_dims(ncid);
#line 644
    def_vars(ncid);
#line 644
    err = nc_enddef(ncid);
#line 644
    IF (err)
#line 644
        error("nc_enddef: %s", nc_strerror(err));
#line 644

#line 644
    value[0] = 0;
#line 644
    for (i = 0; i < NVARS; i++) {
#line 644
	canConvert = (var_type[i] == NC_CHAR) == (NCT_UCHAR == NCT_TEXT);
#line 644
        assert(var_rank[i] <= MAX_RANK);
#line 644
        assert(var_nels[i] <= MAX_NELS);
#line 644
        for (j = 0; j < var_rank[i]; j++) {
#line 644
            start[j] = 0;
#line 644
            edge[j] = 1;
#line 644
	}
#line 644
        err = nc_put_vara_uchar(BAD_ID, i, start, edge, value);
#line 644
        IF (err != NC_EBADID) 
#line 644
	    error("bad ncid: status = %d", err);
#line 644
        err = nc_put_vara_uchar(ncid, BAD_VARID, start, edge, value);
#line 644
        IF (err != NC_ENOTVAR) 
#line 644
	    error("bad var id: status = %d", err);
#line 644
        for (j = 0; j < var_rank[i]; j++) {
#line 644
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 644
		start[j] = var_shape[i][j];
#line 644
		err = nc_put_vara_uchar(ncid, i, start, edge, value);
#line 644
		IF (canConvert && err != NC_EINVALCOORDS)
#line 644
		    error("bad start: status = %d", err);
#line 644
		start[j] = 0;
#line 644
		edge[j] = var_shape[i][j] + 1;
#line 644
		err = nc_put_vara_uchar(ncid, i, start, edge, value);
#line 644
		IF (canConvert && err != NC_EEDGE)
#line 644
		    error("bad edge: status = %d", err);
#line 644
		edge[j] = 1;
#line 644
	    }
#line 644
        }
#line 644
            /* Check correct error returned even when nothing to put */
#line 644
        for (j = 0; j < var_rank[i]; j++) {
#line 644
            edge[j] = 0;
#line 644
	}
#line 644
        err = nc_put_vara_uchar(BAD_ID, i, start, edge, value);
#line 644
        IF (err != NC_EBADID) 
#line 644
	    error("bad ncid: status = %d", err);
#line 644
        err = nc_put_vara_uchar(ncid, BAD_VARID, start, edge, value);
#line 644
        IF (err != NC_ENOTVAR) 
#line 644
	    error("bad var id: status = %d", err);
#line 644
        for (j = 0; j < var_rank[i]; j++) {
#line 644
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 644
		start[j] = var_shape[i][j];
#line 644
		err = nc_put_vara_uchar(ncid, i, start, edge, value);
#line 644
		IF (canConvert && err != NC_EINVALCOORDS)
#line 644
		    error("bad start: status = %d", err);
#line 644
		start[j] = 0;
#line 644
	    }
#line 644
        }
#line 644
	err = nc_put_vara_uchar(ncid, i, start, edge, value);
#line 644
	if (canConvert) {
#line 644
	    IF (err) 
#line 644
		error("%s", nc_strerror(err));
#line 644
	} else {
#line 644
	    IF (err != NC_ECHAR)
#line 644
		error("wrong type: status = %d", err);
#line 644
        }
#line 644
        for (j = 0; j < var_rank[i]; j++) {
#line 644
            edge[j] = 1;
#line 644
	}
#line 644

#line 644
	    /* Choose a random point dividing each dim into 2 parts */
#line 644
	    /* Put 2^rank (nslabs) slabs so defined */
#line 644
	nslabs = 1;
#line 644
	for (j = 0; j < var_rank[i]; j++) {
#line 644
            mid[j] = roll( var_shape[i][j] );
#line 644
	    nslabs *= 2;
#line 644
	}
#line 644
	    /* bits of k determine whether to put lower or upper part of dim */
#line 644
	for (k = 0; k < nslabs; k++) {
#line 644
	    nels = 1;
#line 644
	    for (j = 0; j < var_rank[i]; j++) {
#line 644
		if ((k >> j) & 1) {
#line 644
		    start[j] = 0;
#line 644
		    edge[j] = mid[j];
#line 644
		}else{
#line 644
		    start[j] = mid[j];
#line 644
		    edge[j] = var_shape[i][j] - mid[j];
#line 644
		}
#line 644
		nels *= edge[j];
#line 644
	    }
#line 644
            for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 644
		err = toMixedBase(j, var_rank[i], edge, index);
#line 644
		IF (err) 
#line 644
		    error("error in toMixedBase 1");
#line 644
		for (d = 0; d < var_rank[i]; d++) 
#line 644
		    index[d] += start[d];
#line 644
		value[j]= hash_uchar(var_type[i], var_rank[i], index, NCT_UCHAR);
#line 644
		allInExtRange = allInExtRange 
#line 644
		    && inRange3(value[j], var_type[i], NCT_UCHAR);
#line 644
	    }
#line 644
	    if (var_rank[i] == 0 && i%2 == 0)
#line 644
		err = nc_put_vara_uchar(ncid, i, NULL, NULL, value);
#line 644
	    else
#line 644
		err = nc_put_vara_uchar(ncid, i, start, edge, value);
#line 644
	    if (canConvert) {
#line 644
		if (allInExtRange) {
#line 644
		    IF (err) 
#line 644
			error("%s", nc_strerror(err));
#line 644
		} else {
#line 644
		    IF (err != NC_ERANGE)
#line 644
			error("range error: status = %d", err);
#line 644
		}
#line 644
	    } else {
#line 644
		IF (nels > 0 && err != NC_ECHAR)
#line 644
		    error("wrong type: status = %d", err);
#line 644
            }
#line 644
        }
#line 644
    }
#line 644

#line 644
    err = nc_close(ncid);
#line 644
    IF (err) 
#line 644
	error("nc_close: %s", nc_strerror(err));
#line 644

#line 644
    check_vars_uchar(scratch);
#line 644

#line 644
    err = remove(scratch);
#line 644
    IF (err)
#line 644
        error("remove of %s failed", scratch);
#line 644
}
#line 644

void
#line 645
test_nc_put_vara_schar(void)
#line 645
{
#line 645
    int ncid;
#line 645
    int d;
#line 645
    int i;
#line 645
    int j;
#line 645
    int k;
#line 645
    int err;
#line 645
    int nslabs;
#line 645
    int nels;
#line 645
    size_t start[MAX_RANK];
#line 645
    size_t edge[MAX_RANK];
#line 645
    size_t mid[MAX_RANK];
#line 645
    size_t index[MAX_RANK];
#line 645
    int canConvert;	/* Both text or both numeric */
#line 645
    int allInExtRange;	/* all values within external range? */
#line 645
    schar value[MAX_NELS];
#line 645

#line 645
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 645
    IF (err) {
#line 645
        error("nc_create: %s", nc_strerror(err));
#line 645
        return;
#line 645
    }
#line 645
    def_dims(ncid);
#line 645
    def_vars(ncid);
#line 645
    err = nc_enddef(ncid);
#line 645
    IF (err)
#line 645
        error("nc_enddef: %s", nc_strerror(err));
#line 645

#line 645
    value[0] = 0;
#line 645
    for (i = 0; i < NVARS; i++) {
#line 645
	canConvert = (var_type[i] == NC_CHAR) == (NCT_SCHAR == NCT_TEXT);
#line 645
        assert(var_rank[i] <= MAX_RANK);
#line 645
        assert(var_nels[i] <= MAX_NELS);
#line 645
        for (j = 0; j < var_rank[i]; j++) {
#line 645
            start[j] = 0;
#line 645
            edge[j] = 1;
#line 645
	}
#line 645
        err = nc_put_vara_schar(BAD_ID, i, start, edge, value);
#line 645
        IF (err != NC_EBADID) 
#line 645
	    error("bad ncid: status = %d", err);
#line 645
        err = nc_put_vara_schar(ncid, BAD_VARID, start, edge, value);
#line 645
        IF (err != NC_ENOTVAR) 
#line 645
	    error("bad var id: status = %d", err);
#line 645
        for (j = 0; j < var_rank[i]; j++) {
#line 645
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 645
		start[j] = var_shape[i][j];
#line 645
		err = nc_put_vara_schar(ncid, i, start, edge, value);
#line 645
		IF (canConvert && err != NC_EINVALCOORDS)
#line 645
		    error("bad start: status = %d", err);
#line 645
		start[j] = 0;
#line 645
		edge[j] = var_shape[i][j] + 1;
#line 645
		err = nc_put_vara_schar(ncid, i, start, edge, value);
#line 645
		IF (canConvert && err != NC_EEDGE)
#line 645
		    error("bad edge: status = %d", err);
#line 645
		edge[j] = 1;
#line 645
	    }
#line 645
        }
#line 645
            /* Check correct error returned even when nothing to put */
#line 645
        for (j = 0; j < var_rank[i]; j++) {
#line 645
            edge[j] = 0;
#line 645
	}
#line 645
        err = nc_put_vara_schar(BAD_ID, i, start, edge, value);
#line 645
        IF (err != NC_EBADID) 
#line 645
	    error("bad ncid: status = %d", err);
#line 645
        err = nc_put_vara_schar(ncid, BAD_VARID, start, edge, value);
#line 645
        IF (err != NC_ENOTVAR) 
#line 645
	    error("bad var id: status = %d", err);
#line 645
        for (j = 0; j < var_rank[i]; j++) {
#line 645
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 645
		start[j] = var_shape[i][j];
#line 645
		err = nc_put_vara_schar(ncid, i, start, edge, value);
#line 645
		IF (canConvert && err != NC_EINVALCOORDS)
#line 645
		    error("bad start: status = %d", err);
#line 645
		start[j] = 0;
#line 645
	    }
#line 645
        }
#line 645
	err = nc_put_vara_schar(ncid, i, start, edge, value);
#line 645
	if (canConvert) {
#line 645
	    IF (err) 
#line 645
		error("%s", nc_strerror(err));
#line 645
	} else {
#line 645
	    IF (err != NC_ECHAR)
#line 645
		error("wrong type: status = %d", err);
#line 645
        }
#line 645
        for (j = 0; j < var_rank[i]; j++) {
#line 645
            edge[j] = 1;
#line 645
	}
#line 645

#line 645
	    /* Choose a random point dividing each dim into 2 parts */
#line 645
	    /* Put 2^rank (nslabs) slabs so defined */
#line 645
	nslabs = 1;
#line 645
	for (j = 0; j < var_rank[i]; j++) {
#line 645
            mid[j] = roll( var_shape[i][j] );
#line 645
	    nslabs *= 2;
#line 645
	}
#line 645
	    /* bits of k determine whether to put lower or upper part of dim */
#line 645
	for (k = 0; k < nslabs; k++) {
#line 645
	    nels = 1;
#line 645
	    for (j = 0; j < var_rank[i]; j++) {
#line 645
		if ((k >> j) & 1) {
#line 645
		    start[j] = 0;
#line 645
		    edge[j] = mid[j];
#line 645
		}else{
#line 645
		    start[j] = mid[j];
#line 645
		    edge[j] = var_shape[i][j] - mid[j];
#line 645
		}
#line 645
		nels *= edge[j];
#line 645
	    }
#line 645
            for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 645
		err = toMixedBase(j, var_rank[i], edge, index);
#line 645
		IF (err) 
#line 645
		    error("error in toMixedBase 1");
#line 645
		for (d = 0; d < var_rank[i]; d++) 
#line 645
		    index[d] += start[d];
#line 645
		value[j]= hash_schar(var_type[i], var_rank[i], index, NCT_SCHAR);
#line 645
		allInExtRange = allInExtRange 
#line 645
		    && inRange3(value[j], var_type[i], NCT_SCHAR);
#line 645
	    }
#line 645
	    if (var_rank[i] == 0 && i%2 == 0)
#line 645
		err = nc_put_vara_schar(ncid, i, NULL, NULL, value);
#line 645
	    else
#line 645
		err = nc_put_vara_schar(ncid, i, start, edge, value);
#line 645
	    if (canConvert) {
#line 645
		if (allInExtRange) {
#line 645
		    IF (err) 
#line 645
			error("%s", nc_strerror(err));
#line 645
		} else {
#line 645
		    IF (err != NC_ERANGE)
#line 645
			error("range error: status = %d", err);
#line 645
		}
#line 645
	    } else {
#line 645
		IF (nels > 0 && err != NC_ECHAR)
#line 645
		    error("wrong type: status = %d", err);
#line 645
            }
#line 645
        }
#line 645
    }
#line 645

#line 645
    err = nc_close(ncid);
#line 645
    IF (err) 
#line 645
	error("nc_close: %s", nc_strerror(err));
#line 645

#line 645
    check_vars_schar(scratch);
#line 645

#line 645
    err = remove(scratch);
#line 645
    IF (err)
#line 645
        error("remove of %s failed", scratch);
#line 645
}
#line 645

void
#line 646
test_nc_put_vara_short(void)
#line 646
{
#line 646
    int ncid;
#line 646
    int d;
#line 646
    int i;
#line 646
    int j;
#line 646
    int k;
#line 646
    int err;
#line 646
    int nslabs;
#line 646
    int nels;
#line 646
    size_t start[MAX_RANK];
#line 646
    size_t edge[MAX_RANK];
#line 646
    size_t mid[MAX_RANK];
#line 646
    size_t index[MAX_RANK];
#line 646
    int canConvert;	/* Both text or both numeric */
#line 646
    int allInExtRange;	/* all values within external range? */
#line 646
    short value[MAX_NELS];
#line 646

#line 646
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 646
    IF (err) {
#line 646
        error("nc_create: %s", nc_strerror(err));
#line 646
        return;
#line 646
    }
#line 646
    def_dims(ncid);
#line 646
    def_vars(ncid);
#line 646
    err = nc_enddef(ncid);
#line 646
    IF (err)
#line 646
        error("nc_enddef: %s", nc_strerror(err));
#line 646

#line 646
    value[0] = 0;
#line 646
    for (i = 0; i < NVARS; i++) {
#line 646
	canConvert = (var_type[i] == NC_CHAR) == (NCT_SHORT == NCT_TEXT);
#line 646
        assert(var_rank[i] <= MAX_RANK);
#line 646
        assert(var_nels[i] <= MAX_NELS);
#line 646
        for (j = 0; j < var_rank[i]; j++) {
#line 646
            start[j] = 0;
#line 646
            edge[j] = 1;
#line 646
	}
#line 646
        err = nc_put_vara_short(BAD_ID, i, start, edge, value);
#line 646
        IF (err != NC_EBADID) 
#line 646
	    error("bad ncid: status = %d", err);
#line 646
        err = nc_put_vara_short(ncid, BAD_VARID, start, edge, value);
#line 646
        IF (err != NC_ENOTVAR) 
#line 646
	    error("bad var id: status = %d", err);
#line 646
        for (j = 0; j < var_rank[i]; j++) {
#line 646
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 646
		start[j] = var_shape[i][j];
#line 646
		err = nc_put_vara_short(ncid, i, start, edge, value);
#line 646
		IF (canConvert && err != NC_EINVALCOORDS)
#line 646
		    error("bad start: status = %d", err);
#line 646
		start[j] = 0;
#line 646
		edge[j] = var_shape[i][j] + 1;
#line 646
		err = nc_put_vara_short(ncid, i, start, edge, value);
#line 646
		IF (canConvert && err != NC_EEDGE)
#line 646
		    error("bad edge: status = %d", err);
#line 646
		edge[j] = 1;
#line 646
	    }
#line 646
        }
#line 646
            /* Check correct error returned even when nothing to put */
#line 646
        for (j = 0; j < var_rank[i]; j++) {
#line 646
            edge[j] = 0;
#line 646
	}
#line 646
        err = nc_put_vara_short(BAD_ID, i, start, edge, value);
#line 646
        IF (err != NC_EBADID) 
#line 646
	    error("bad ncid: status = %d", err);
#line 646
        err = nc_put_vara_short(ncid, BAD_VARID, start, edge, value);
#line 646
        IF (err != NC_ENOTVAR) 
#line 646
	    error("bad var id: status = %d", err);
#line 646
        for (j = 0; j < var_rank[i]; j++) {
#line 646
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 646
		start[j] = var_shape[i][j];
#line 646
		err = nc_put_vara_short(ncid, i, start, edge, value);
#line 646
		IF (canConvert && err != NC_EINVALCOORDS)
#line 646
		    error("bad start: status = %d", err);
#line 646
		start[j] = 0;
#line 646
	    }
#line 646
        }
#line 646
	err = nc_put_vara_short(ncid, i, start, edge, value);
#line 646
	if (canConvert) {
#line 646
	    IF (err) 
#line 646
		error("%s", nc_strerror(err));
#line 646
	} else {
#line 646
	    IF (err != NC_ECHAR)
#line 646
		error("wrong type: status = %d", err);
#line 646
        }
#line 646
        for (j = 0; j < var_rank[i]; j++) {
#line 646
            edge[j] = 1;
#line 646
	}
#line 646

#line 646
	    /* Choose a random point dividing each dim into 2 parts */
#line 646
	    /* Put 2^rank (nslabs) slabs so defined */
#line 646
	nslabs = 1;
#line 646
	for (j = 0; j < var_rank[i]; j++) {
#line 646
            mid[j] = roll( var_shape[i][j] );
#line 646
	    nslabs *= 2;
#line 646
	}
#line 646
	    /* bits of k determine whether to put lower or upper part of dim */
#line 646
	for (k = 0; k < nslabs; k++) {
#line 646
	    nels = 1;
#line 646
	    for (j = 0; j < var_rank[i]; j++) {
#line 646
		if ((k >> j) & 1) {
#line 646
		    start[j] = 0;
#line 646
		    edge[j] = mid[j];
#line 646
		}else{
#line 646
		    start[j] = mid[j];
#line 646
		    edge[j] = var_shape[i][j] - mid[j];
#line 646
		}
#line 646
		nels *= edge[j];
#line 646
	    }
#line 646
            for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 646
		err = toMixedBase(j, var_rank[i], edge, index);
#line 646
		IF (err) 
#line 646
		    error("error in toMixedBase 1");
#line 646
		for (d = 0; d < var_rank[i]; d++) 
#line 646
		    index[d] += start[d];
#line 646
		value[j]= hash_short(var_type[i], var_rank[i], index, NCT_SHORT);
#line 646
		allInExtRange = allInExtRange 
#line 646
		    && inRange3(value[j], var_type[i], NCT_SHORT);
#line 646
	    }
#line 646
	    if (var_rank[i] == 0 && i%2 == 0)
#line 646
		err = nc_put_vara_short(ncid, i, NULL, NULL, value);
#line 646
	    else
#line 646
		err = nc_put_vara_short(ncid, i, start, edge, value);
#line 646
	    if (canConvert) {
#line 646
		if (allInExtRange) {
#line 646
		    IF (err) 
#line 646
			error("%s", nc_strerror(err));
#line 646
		} else {
#line 646
		    IF (err != NC_ERANGE)
#line 646
			error("range error: status = %d", err);
#line 646
		}
#line 646
	    } else {
#line 646
		IF (nels > 0 && err != NC_ECHAR)
#line 646
		    error("wrong type: status = %d", err);
#line 646
            }
#line 646
        }
#line 646
    }
#line 646

#line 646
    err = nc_close(ncid);
#line 646
    IF (err) 
#line 646
	error("nc_close: %s", nc_strerror(err));
#line 646

#line 646
    check_vars_short(scratch);
#line 646

#line 646
    err = remove(scratch);
#line 646
    IF (err)
#line 646
        error("remove of %s failed", scratch);
#line 646
}
#line 646

void
#line 647
test_nc_put_vara_int(void)
#line 647
{
#line 647
    int ncid;
#line 647
    int d;
#line 647
    int i;
#line 647
    int j;
#line 647
    int k;
#line 647
    int err;
#line 647
    int nslabs;
#line 647
    int nels;
#line 647
    size_t start[MAX_RANK];
#line 647
    size_t edge[MAX_RANK];
#line 647
    size_t mid[MAX_RANK];
#line 647
    size_t index[MAX_RANK];
#line 647
    int canConvert;	/* Both text or both numeric */
#line 647
    int allInExtRange;	/* all values within external range? */
#line 647
    int value[MAX_NELS];
#line 647

#line 647
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 647
    IF (err) {
#line 647
        error("nc_create: %s", nc_strerror(err));
#line 647
        return;
#line 647
    }
#line 647
    def_dims(ncid);
#line 647
    def_vars(ncid);
#line 647
    err = nc_enddef(ncid);
#line 647
    IF (err)
#line 647
        error("nc_enddef: %s", nc_strerror(err));
#line 647

#line 647
    value[0] = 0;
#line 647
    for (i = 0; i < NVARS; i++) {
#line 647
	canConvert = (var_type[i] == NC_CHAR) == (NCT_INT == NCT_TEXT);
#line 647
        assert(var_rank[i] <= MAX_RANK);
#line 647
        assert(var_nels[i] <= MAX_NELS);
#line 647
        for (j = 0; j < var_rank[i]; j++) {
#line 647
            start[j] = 0;
#line 647
            edge[j] = 1;
#line 647
	}
#line 647
        err = nc_put_vara_int(BAD_ID, i, start, edge, value);
#line 647
        IF (err != NC_EBADID) 
#line 647
	    error("bad ncid: status = %d", err);
#line 647
        err = nc_put_vara_int(ncid, BAD_VARID, start, edge, value);
#line 647
        IF (err != NC_ENOTVAR) 
#line 647
	    error("bad var id: status = %d", err);
#line 647
        for (j = 0; j < var_rank[i]; j++) {
#line 647
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 647
		start[j] = var_shape[i][j];
#line 647
		err = nc_put_vara_int(ncid, i, start, edge, value);
#line 647
		IF (canConvert && err != NC_EINVALCOORDS)
#line 647
		    error("bad start: status = %d", err);
#line 647
		start[j] = 0;
#line 647
		edge[j] = var_shape[i][j] + 1;
#line 647
		err = nc_put_vara_int(ncid, i, start, edge, value);
#line 647
		IF (canConvert && err != NC_EEDGE)
#line 647
		    error("bad edge: status = %d", err);
#line 647
		edge[j] = 1;
#line 647
	    }
#line 647
        }
#line 647
            /* Check correct error returned even when nothing to put */
#line 647
        for (j = 0; j < var_rank[i]; j++) {
#line 647
            edge[j] = 0;
#line 647
	}
#line 647
        err = nc_put_vara_int(BAD_ID, i, start, edge, value);
#line 647
        IF (err != NC_EBADID) 
#line 647
	    error("bad ncid: status = %d", err);
#line 647
        err = nc_put_vara_int(ncid, BAD_VARID, start, edge, value);
#line 647
        IF (err != NC_ENOTVAR) 
#line 647
	    error("bad var id: status = %d", err);
#line 647
        for (j = 0; j < var_rank[i]; j++) {
#line 647
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 647
		start[j] = var_shape[i][j];
#line 647
		err = nc_put_vara_int(ncid, i, start, edge, value);
#line 647
		IF (canConvert && err != NC_EINVALCOORDS)
#line 647
		    error("bad start: status = %d", err);
#line 647
		start[j] = 0;
#line 647
	    }
#line 647
        }
#line 647
	err = nc_put_vara_int(ncid, i, start, edge, value);
#line 647
	if (canConvert) {
#line 647
	    IF (err) 
#line 647
		error("%s", nc_strerror(err));
#line 647
	} else {
#line 647
	    IF (err != NC_ECHAR)
#line 647
		error("wrong type: status = %d", err);
#line 647
        }
#line 647
        for (j = 0; j < var_rank[i]; j++) {
#line 647
            edge[j] = 1;
#line 647
	}
#line 647

#line 647
	    /* Choose a random point dividing each dim into 2 parts */
#line 647
	    /* Put 2^rank (nslabs) slabs so defined */
#line 647
	nslabs = 1;
#line 647
	for (j = 0; j < var_rank[i]; j++) {
#line 647
            mid[j] = roll( var_shape[i][j] );
#line 647
	    nslabs *= 2;
#line 647
	}
#line 647
	    /* bits of k determine whether to put lower or upper part of dim */
#line 647
	for (k = 0; k < nslabs; k++) {
#line 647
	    nels = 1;
#line 647
	    for (j = 0; j < var_rank[i]; j++) {
#line 647
		if ((k >> j) & 1) {
#line 647
		    start[j] = 0;
#line 647
		    edge[j] = mid[j];
#line 647
		}else{
#line 647
		    start[j] = mid[j];
#line 647
		    edge[j] = var_shape[i][j] - mid[j];
#line 647
		}
#line 647
		nels *= edge[j];
#line 647
	    }
#line 647
            for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 647
		err = toMixedBase(j, var_rank[i], edge, index);
#line 647
		IF (err) 
#line 647
		    error("error in toMixedBase 1");
#line 647
		for (d = 0; d < var_rank[i]; d++) 
#line 647
		    index[d] += start[d];
#line 647
		value[j]= hash_int(var_type[i], var_rank[i], index, NCT_INT);
#line 647
		allInExtRange = allInExtRange 
#line 647
		    && inRange3(value[j], var_type[i], NCT_INT);
#line 647
	    }
#line 647
	    if (var_rank[i] == 0 && i%2 == 0)
#line 647
		err = nc_put_vara_int(ncid, i, NULL, NULL, value);
#line 647
	    else
#line 647
		err = nc_put_vara_int(ncid, i, start, edge, value);
#line 647
	    if (canConvert) {
#line 647
		if (allInExtRange) {
#line 647
		    IF (err) 
#line 647
			error("%s", nc_strerror(err));
#line 647
		} else {
#line 647
		    IF (err != NC_ERANGE)
#line 647
			error("range error: status = %d", err);
#line 647
		}
#line 647
	    } else {
#line 647
		IF (nels > 0 && err != NC_ECHAR)
#line 647
		    error("wrong type: status = %d", err);
#line 647
            }
#line 647
        }
#line 647
    }
#line 647

#line 647
    err = nc_close(ncid);
#line 647
    IF (err) 
#line 647
	error("nc_close: %s", nc_strerror(err));
#line 647

#line 647
    check_vars_int(scratch);
#line 647

#line 647
    err = remove(scratch);
#line 647
    IF (err)
#line 647
        error("remove of %s failed", scratch);
#line 647
}
#line 647

void
#line 648
test_nc_put_vara_long(void)
#line 648
{
#line 648
    int ncid;
#line 648
    int d;
#line 648
    int i;
#line 648
    int j;
#line 648
    int k;
#line 648
    int err;
#line 648
    int nslabs;
#line 648
    int nels;
#line 648
    size_t start[MAX_RANK];
#line 648
    size_t edge[MAX_RANK];
#line 648
    size_t mid[MAX_RANK];
#line 648
    size_t index[MAX_RANK];
#line 648
    int canConvert;	/* Both text or both numeric */
#line 648
    int allInExtRange;	/* all values within external range? */
#line 648
    long value[MAX_NELS];
#line 648

#line 648
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 648
    IF (err) {
#line 648
        error("nc_create: %s", nc_strerror(err));
#line 648
        return;
#line 648
    }
#line 648
    def_dims(ncid);
#line 648
    def_vars(ncid);
#line 648
    err = nc_enddef(ncid);
#line 648
    IF (err)
#line 648
        error("nc_enddef: %s", nc_strerror(err));
#line 648

#line 648
    value[0] = 0;
#line 648
    for (i = 0; i < NVARS; i++) {
#line 648
	canConvert = (var_type[i] == NC_CHAR) == (NCT_LONG == NCT_TEXT);
#line 648
        assert(var_rank[i] <= MAX_RANK);
#line 648
        assert(var_nels[i] <= MAX_NELS);
#line 648
        for (j = 0; j < var_rank[i]; j++) {
#line 648
            start[j] = 0;
#line 648
            edge[j] = 1;
#line 648
	}
#line 648
        err = nc_put_vara_long(BAD_ID, i, start, edge, value);
#line 648
        IF (err != NC_EBADID) 
#line 648
	    error("bad ncid: status = %d", err);
#line 648
        err = nc_put_vara_long(ncid, BAD_VARID, start, edge, value);
#line 648
        IF (err != NC_ENOTVAR) 
#line 648
	    error("bad var id: status = %d", err);
#line 648
        for (j = 0; j < var_rank[i]; j++) {
#line 648
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 648
		start[j] = var_shape[i][j];
#line 648
		err = nc_put_vara_long(ncid, i, start, edge, value);
#line 648
		IF (canConvert && err != NC_EINVALCOORDS)
#line 648
		    error("bad start: status = %d", err);
#line 648
		start[j] = 0;
#line 648
		edge[j] = var_shape[i][j] + 1;
#line 648
		err = nc_put_vara_long(ncid, i, start, edge, value);
#line 648
		IF (canConvert && err != NC_EEDGE)
#line 648
		    error("bad edge: status = %d", err);
#line 648
		edge[j] = 1;
#line 648
	    }
#line 648
        }
#line 648
            /* Check correct error returned even when nothing to put */
#line 648
        for (j = 0; j < var_rank[i]; j++) {
#line 648
            edge[j] = 0;
#line 648
	}
#line 648
        err = nc_put_vara_long(BAD_ID, i, start, edge, value);
#line 648
        IF (err != NC_EBADID) 
#line 648
	    error("bad ncid: status = %d", err);
#line 648
        err = nc_put_vara_long(ncid, BAD_VARID, start, edge, value);
#line 648
        IF (err != NC_ENOTVAR) 
#line 648
	    error("bad var id: status = %d", err);
#line 648
        for (j = 0; j < var_rank[i]; j++) {
#line 648
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 648
		start[j] = var_shape[i][j];
#line 648
		err = nc_put_vara_long(ncid, i, start, edge, value);
#line 648
		IF (canConvert && err != NC_EINVALCOORDS)
#line 648
		    error("bad start: status = %d", err);
#line 648
		start[j] = 0;
#line 648
	    }
#line 648
        }
#line 648
	err = nc_put_vara_long(ncid, i, start, edge, value);
#line 648
	if (canConvert) {
#line 648
	    IF (err) 
#line 648
		error("%s", nc_strerror(err));
#line 648
	} else {
#line 648
	    IF (err != NC_ECHAR)
#line 648
		error("wrong type: status = %d", err);
#line 648
        }
#line 648
        for (j = 0; j < var_rank[i]; j++) {
#line 648
            edge[j] = 1;
#line 648
	}
#line 648

#line 648
	    /* Choose a random point dividing each dim into 2 parts */
#line 648
	    /* Put 2^rank (nslabs) slabs so defined */
#line 648
	nslabs = 1;
#line 648
	for (j = 0; j < var_rank[i]; j++) {
#line 648
            mid[j] = roll( var_shape[i][j] );
#line 648
	    nslabs *= 2;
#line 648
	}
#line 648
	    /* bits of k determine whether to put lower or upper part of dim */
#line 648
	for (k = 0; k < nslabs; k++) {
#line 648
	    nels = 1;
#line 648
	    for (j = 0; j < var_rank[i]; j++) {
#line 648
		if ((k >> j) & 1) {
#line 648
		    start[j] = 0;
#line 648
		    edge[j] = mid[j];
#line 648
		}else{
#line 648
		    start[j] = mid[j];
#line 648
		    edge[j] = var_shape[i][j] - mid[j];
#line 648
		}
#line 648
		nels *= edge[j];
#line 648
	    }
#line 648
            for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 648
		err = toMixedBase(j, var_rank[i], edge, index);
#line 648
		IF (err) 
#line 648
		    error("error in toMixedBase 1");
#line 648
		for (d = 0; d < var_rank[i]; d++) 
#line 648
		    index[d] += start[d];
#line 648
		value[j]= hash_long(var_type[i], var_rank[i], index, NCT_LONG);
#line 648
		allInExtRange = allInExtRange 
#line 648
		    && inRange3(value[j], var_type[i], NCT_LONG);
#line 648
	    }
#line 648
	    if (var_rank[i] == 0 && i%2 == 0)
#line 648
		err = nc_put_vara_long(ncid, i, NULL, NULL, value);
#line 648
	    else
#line 648
		err = nc_put_vara_long(ncid, i, start, edge, value);
#line 648
	    if (canConvert) {
#line 648
		if (allInExtRange) {
#line 648
		    IF (err) 
#line 648
			error("%s", nc_strerror(err));
#line 648
		} else {
#line 648
		    IF (err != NC_ERANGE)
#line 648
			error("range error: status = %d", err);
#line 648
		}
#line 648
	    } else {
#line 648
		IF (nels > 0 && err != NC_ECHAR)
#line 648
		    error("wrong type: status = %d", err);
#line 648
            }
#line 648
        }
#line 648
    }
#line 648

#line 648
    err = nc_close(ncid);
#line 648
    IF (err) 
#line 648
	error("nc_close: %s", nc_strerror(err));
#line 648

#line 648
    check_vars_long(scratch);
#line 648

#line 648
    err = remove(scratch);
#line 648
    IF (err)
#line 648
        error("remove of %s failed", scratch);
#line 648
}
#line 648

void
#line 649
test_nc_put_vara_float(void)
#line 649
{
#line 649
    int ncid;
#line 649
    int d;
#line 649
    int i;
#line 649
    int j;
#line 649
    int k;
#line 649
    int err;
#line 649
    int nslabs;
#line 649
    int nels;
#line 649
    size_t start[MAX_RANK];
#line 649
    size_t edge[MAX_RANK];
#line 649
    size_t mid[MAX_RANK];
#line 649
    size_t index[MAX_RANK];
#line 649
    int canConvert;	/* Both text or both numeric */
#line 649
    int allInExtRange;	/* all values within external range? */
#line 649
    float value[MAX_NELS];
#line 649

#line 649
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 649
    IF (err) {
#line 649
        error("nc_create: %s", nc_strerror(err));
#line 649
        return;
#line 649
    }
#line 649
    def_dims(ncid);
#line 649
    def_vars(ncid);
#line 649
    err = nc_enddef(ncid);
#line 649
    IF (err)
#line 649
        error("nc_enddef: %s", nc_strerror(err));
#line 649

#line 649
    value[0] = 0;
#line 649
    for (i = 0; i < NVARS; i++) {
#line 649
	canConvert = (var_type[i] == NC_CHAR) == (NCT_FLOAT == NCT_TEXT);
#line 649
        assert(var_rank[i] <= MAX_RANK);
#line 649
        assert(var_nels[i] <= MAX_NELS);
#line 649
        for (j = 0; j < var_rank[i]; j++) {
#line 649
            start[j] = 0;
#line 649
            edge[j] = 1;
#line 649
	}
#line 649
        err = nc_put_vara_float(BAD_ID, i, start, edge, value);
#line 649
        IF (err != NC_EBADID) 
#line 649
	    error("bad ncid: status = %d", err);
#line 649
        err = nc_put_vara_float(ncid, BAD_VARID, start, edge, value);
#line 649
        IF (err != NC_ENOTVAR) 
#line 649
	    error("bad var id: status = %d", err);
#line 649
        for (j = 0; j < var_rank[i]; j++) {
#line 649
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 649
		start[j] = var_shape[i][j];
#line 649
		err = nc_put_vara_float(ncid, i, start, edge, value);
#line 649
		IF (canConvert && err != NC_EINVALCOORDS)
#line 649
		    error("bad start: status = %d", err);
#line 649
		start[j] = 0;
#line 649
		edge[j] = var_shape[i][j] + 1;
#line 649
		err = nc_put_vara_float(ncid, i, start, edge, value);
#line 649
		IF (canConvert && err != NC_EEDGE)
#line 649
		    error("bad edge: status = %d", err);
#line 649
		edge[j] = 1;
#line 649
	    }
#line 649
        }
#line 649
            /* Check correct error returned even when nothing to put */
#line 649
        for (j = 0; j < var_rank[i]; j++) {
#line 649
            edge[j] = 0;
#line 649
	}
#line 649
        err = nc_put_vara_float(BAD_ID, i, start, edge, value);
#line 649
        IF (err != NC_EBADID) 
#line 649
	    error("bad ncid: status = %d", err);
#line 649
        err = nc_put_vara_float(ncid, BAD_VARID, start, edge, value);
#line 649
        IF (err != NC_ENOTVAR) 
#line 649
	    error("bad var id: status = %d", err);
#line 649
        for (j = 0; j < var_rank[i]; j++) {
#line 649
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 649
		start[j] = var_shape[i][j];
#line 649
		err = nc_put_vara_float(ncid, i, start, edge, value);
#line 649
		IF (canConvert && err != NC_EINVALCOORDS)
#line 649
		    error("bad start: status = %d", err);
#line 649
		start[j] = 0;
#line 649
	    }
#line 649
        }
#line 649
	err = nc_put_vara_float(ncid, i, start, edge, value);
#line 649
	if (canConvert) {
#line 649
	    IF (err) 
#line 649
		error("%s", nc_strerror(err));
#line 649
	} else {
#line 649
	    IF (err != NC_ECHAR)
#line 649
		error("wrong type: status = %d", err);
#line 649
        }
#line 649
        for (j = 0; j < var_rank[i]; j++) {
#line 649
            edge[j] = 1;
#line 649
	}
#line 649

#line 649
	    /* Choose a random point dividing each dim into 2 parts */
#line 649
	    /* Put 2^rank (nslabs) slabs so defined */
#line 649
	nslabs = 1;
#line 649
	for (j = 0; j < var_rank[i]; j++) {
#line 649
            mid[j] = roll( var_shape[i][j] );
#line 649
	    nslabs *= 2;
#line 649
	}
#line 649
	    /* bits of k determine whether to put lower or upper part of dim */
#line 649
	for (k = 0; k < nslabs; k++) {
#line 649
	    nels = 1;
#line 649
	    for (j = 0; j < var_rank[i]; j++) {
#line 649
		if ((k >> j) & 1) {
#line 649
		    start[j] = 0;
#line 649
		    edge[j] = mid[j];
#line 649
		}else{
#line 649
		    start[j] = mid[j];
#line 649
		    edge[j] = var_shape[i][j] - mid[j];
#line 649
		}
#line 649
		nels *= edge[j];
#line 649
	    }
#line 649
            for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 649
		err = toMixedBase(j, var_rank[i], edge, index);
#line 649
		IF (err) 
#line 649
		    error("error in toMixedBase 1");
#line 649
		for (d = 0; d < var_rank[i]; d++) 
#line 649
		    index[d] += start[d];
#line 649
		value[j]= hash_float(var_type[i], var_rank[i], index, NCT_FLOAT);
#line 649
		allInExtRange = allInExtRange 
#line 649
		    && inRange3(value[j], var_type[i], NCT_FLOAT);
#line 649
	    }
#line 649
	    if (var_rank[i] == 0 && i%2 == 0)
#line 649
		err = nc_put_vara_float(ncid, i, NULL, NULL, value);
#line 649
	    else
#line 649
		err = nc_put_vara_float(ncid, i, start, edge, value);
#line 649
	    if (canConvert) {
#line 649
		if (allInExtRange) {
#line 649
		    IF (err) 
#line 649
			error("%s", nc_strerror(err));
#line 649
		} else {
#line 649
		    IF (err != NC_ERANGE)
#line 649
			error("range error: status = %d", err);
#line 649
		}
#line 649
	    } else {
#line 649
		IF (nels > 0 && err != NC_ECHAR)
#line 649
		    error("wrong type: status = %d", err);
#line 649
            }
#line 649
        }
#line 649
    }
#line 649

#line 649
    err = nc_close(ncid);
#line 649
    IF (err) 
#line 649
	error("nc_close: %s", nc_strerror(err));
#line 649

#line 649
    check_vars_float(scratch);
#line 649

#line 649
    err = remove(scratch);
#line 649
    IF (err)
#line 649
        error("remove of %s failed", scratch);
#line 649
}
#line 649

void
#line 650
test_nc_put_vara_double(void)
#line 650
{
#line 650
    int ncid;
#line 650
    int d;
#line 650
    int i;
#line 650
    int j;
#line 650
    int k;
#line 650
    int err;
#line 650
    int nslabs;
#line 650
    int nels;
#line 650
    size_t start[MAX_RANK];
#line 650
    size_t edge[MAX_RANK];
#line 650
    size_t mid[MAX_RANK];
#line 650
    size_t index[MAX_RANK];
#line 650
    int canConvert;	/* Both text or both numeric */
#line 650
    int allInExtRange;	/* all values within external range? */
#line 650
    double value[MAX_NELS];
#line 650

#line 650
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 650
    IF (err) {
#line 650
        error("nc_create: %s", nc_strerror(err));
#line 650
        return;
#line 650
    }
#line 650
    def_dims(ncid);
#line 650
    def_vars(ncid);
#line 650
    err = nc_enddef(ncid);
#line 650
    IF (err)
#line 650
        error("nc_enddef: %s", nc_strerror(err));
#line 650

#line 650
    value[0] = 0;
#line 650
    for (i = 0; i < NVARS; i++) {
#line 650
	canConvert = (var_type[i] == NC_CHAR) == (NCT_DOUBLE == NCT_TEXT);
#line 650
        assert(var_rank[i] <= MAX_RANK);
#line 650
        assert(var_nels[i] <= MAX_NELS);
#line 650
        for (j = 0; j < var_rank[i]; j++) {
#line 650
            start[j] = 0;
#line 650
            edge[j] = 1;
#line 650
	}
#line 650
        err = nc_put_vara_double(BAD_ID, i, start, edge, value);
#line 650
        IF (err != NC_EBADID) 
#line 650
	    error("bad ncid: status = %d", err);
#line 650
        err = nc_put_vara_double(ncid, BAD_VARID, start, edge, value);
#line 650
        IF (err != NC_ENOTVAR) 
#line 650
	    error("bad var id: status = %d", err);
#line 650
        for (j = 0; j < var_rank[i]; j++) {
#line 650
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 650
		start[j] = var_shape[i][j];
#line 650
		err = nc_put_vara_double(ncid, i, start, edge, value);
#line 650
		IF (canConvert && err != NC_EINVALCOORDS)
#line 650
		    error("bad start: status = %d", err);
#line 650
		start[j] = 0;
#line 650
		edge[j] = var_shape[i][j] + 1;
#line 650
		err = nc_put_vara_double(ncid, i, start, edge, value);
#line 650
		IF (canConvert && err != NC_EEDGE)
#line 650
		    error("bad edge: status = %d", err);
#line 650
		edge[j] = 1;
#line 650
	    }
#line 650
        }
#line 650
            /* Check correct error returned even when nothing to put */
#line 650
        for (j = 0; j < var_rank[i]; j++) {
#line 650
            edge[j] = 0;
#line 650
	}
#line 650
        err = nc_put_vara_double(BAD_ID, i, start, edge, value);
#line 650
        IF (err != NC_EBADID) 
#line 650
	    error("bad ncid: status = %d", err);
#line 650
        err = nc_put_vara_double(ncid, BAD_VARID, start, edge, value);
#line 650
        IF (err != NC_ENOTVAR) 
#line 650
	    error("bad var id: status = %d", err);
#line 650
        for (j = 0; j < var_rank[i]; j++) {
#line 650
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 650
		start[j] = var_shape[i][j];
#line 650
		err = nc_put_vara_double(ncid, i, start, edge, value);
#line 650
		IF (canConvert && err != NC_EINVALCOORDS)
#line 650
		    error("bad start: status = %d", err);
#line 650
		start[j] = 0;
#line 650
	    }
#line 650
        }
#line 650
	err = nc_put_vara_double(ncid, i, start, edge, value);
#line 650
	if (canConvert) {
#line 650
	    IF (err) 
#line 650
		error("%s", nc_strerror(err));
#line 650
	} else {
#line 650
	    IF (err != NC_ECHAR)
#line 650
		error("wrong type: status = %d", err);
#line 650
        }
#line 650
        for (j = 0; j < var_rank[i]; j++) {
#line 650
            edge[j] = 1;
#line 650
	}
#line 650

#line 650
	    /* Choose a random point dividing each dim into 2 parts */
#line 650
	    /* Put 2^rank (nslabs) slabs so defined */
#line 650
	nslabs = 1;
#line 650
	for (j = 0; j < var_rank[i]; j++) {
#line 650
            mid[j] = roll( var_shape[i][j] );
#line 650
	    nslabs *= 2;
#line 650
	}
#line 650
	    /* bits of k determine whether to put lower or upper part of dim */
#line 650
	for (k = 0; k < nslabs; k++) {
#line 650
	    nels = 1;
#line 650
	    for (j = 0; j < var_rank[i]; j++) {
#line 650
		if ((k >> j) & 1) {
#line 650
		    start[j] = 0;
#line 650
		    edge[j] = mid[j];
#line 650
		}else{
#line 650
		    start[j] = mid[j];
#line 650
		    edge[j] = var_shape[i][j] - mid[j];
#line 650
		}
#line 650
		nels *= edge[j];
#line 650
	    }
#line 650
            for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 650
		err = toMixedBase(j, var_rank[i], edge, index);
#line 650
		IF (err) 
#line 650
		    error("error in toMixedBase 1");
#line 650
		for (d = 0; d < var_rank[i]; d++) 
#line 650
		    index[d] += start[d];
#line 650
		value[j]= hash_double(var_type[i], var_rank[i], index, NCT_DOUBLE);
#line 650
		allInExtRange = allInExtRange 
#line 650
		    && inRange3(value[j], var_type[i], NCT_DOUBLE);
#line 650
	    }
#line 650
	    if (var_rank[i] == 0 && i%2 == 0)
#line 650
		err = nc_put_vara_double(ncid, i, NULL, NULL, value);
#line 650
	    else
#line 650
		err = nc_put_vara_double(ncid, i, start, edge, value);
#line 650
	    if (canConvert) {
#line 650
		if (allInExtRange) {
#line 650
		    IF (err) 
#line 650
			error("%s", nc_strerror(err));
#line 650
		} else {
#line 650
		    IF (err != NC_ERANGE)
#line 650
			error("range error: status = %d", err);
#line 650
		}
#line 650
	    } else {
#line 650
		IF (nels > 0 && err != NC_ECHAR)
#line 650
		    error("wrong type: status = %d", err);
#line 650
            }
#line 650
        }
#line 650
    }
#line 650

#line 650
    err = nc_close(ncid);
#line 650
    IF (err) 
#line 650
	error("nc_close: %s", nc_strerror(err));
#line 650

#line 650
    check_vars_double(scratch);
#line 650

#line 650
    err = remove(scratch);
#line 650
    IF (err)
#line 650
        error("remove of %s failed", scratch);
#line 650
}
#line 650



#line 815

void
#line 816
test_nc_put_vars_text(void)
#line 816
{
#line 816
    int ncid;
#line 816
    int d;
#line 816
    int i;
#line 816
    int j;
#line 816
    int k;
#line 816
    int m;
#line 816
    int err;
#line 816
    int nels;
#line 816
    int nslabs;
#line 816
    int nstarts;        /* number of different starts */
#line 816
    size_t start[MAX_RANK];
#line 816
    size_t edge[MAX_RANK];
#line 816
    size_t index[MAX_RANK];
#line 816
    size_t index2[MAX_RANK];
#line 816
    size_t mid[MAX_RANK];
#line 816
    size_t count[MAX_RANK];
#line 816
    size_t sstride[MAX_RANK];
#line 816
    ptrdiff_t stride[MAX_RANK];
#line 816
    int canConvert;	/* Both text or both numeric */
#line 816
    int allInExtRange;	/* all values within external range? */
#line 816
    text value[MAX_NELS];
#line 816

#line 816
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 816
    IF (err) {
#line 816
	error("nc_create: %s", nc_strerror(err));
#line 816
	return;
#line 816
    }
#line 816
    def_dims(ncid);
#line 816
    def_vars(ncid);
#line 816
    err = nc_enddef(ncid);
#line 816
    IF (err)
#line 816
	error("nc_enddef: %s", nc_strerror(err));
#line 816

#line 816
    for (i = 0; i < NVARS; i++) {
#line 816
	canConvert = (var_type[i] == NC_CHAR) == (NCT_TEXT == NCT_TEXT);
#line 816
	assert(var_rank[i] <= MAX_RANK);
#line 816
	assert(var_nels[i] <= MAX_NELS);
#line 816
	for (j = 0; j < var_rank[i]; j++) {
#line 816
	    start[j] = 0;
#line 816
	    edge[j] = 1;
#line 816
	    stride[j] = 1;
#line 816
	}
#line 816
	err = nc_put_vars_text(BAD_ID, i, start, edge, stride, value);
#line 816
	IF (err != NC_EBADID) 
#line 816
	    error("bad ncid: status = %d", err);
#line 816
	err = nc_put_vars_text(ncid, BAD_VARID, start, edge, stride, value);
#line 816
	IF (err != NC_ENOTVAR) 
#line 816
	    error("bad var id: status = %d", err);
#line 816
	for (j = 0; j < var_rank[i]; j++) {
#line 816
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 816
		start[j] = var_shape[i][j] + 1;
#line 816
		err = nc_put_vars_text(ncid, i, start, edge, stride, value);
#line 816
	      if(!canConvert) {
#line 816
		IF(err != NC_ECHAR)
#line 816
			error("conversion: status = %d", err);
#line 816
	      } else {
#line 816
		IF(err != NC_EINVALCOORDS)
#line 816
		    error("bad start: status = %d", err);
#line 816
		start[j] = 0;
#line 816
		edge[j] = var_shape[i][j] + 1;
#line 816
		err = nc_put_vars_text(ncid, i, start, edge, stride, value);
#line 816
		IF (err != NC_EEDGE)
#line 816
		    error("bad edge: status = %d", err);
#line 816
		edge[j] = 1;
#line 816
		stride[j] = 0;
#line 816
		err = nc_put_vars_text(ncid, i, start, edge, stride, value);
#line 816
		IF (err != NC_ESTRIDE)
#line 816
		    error("bad stride: status = %d", err);
#line 816
		stride[j] = 1;
#line 816
              }
#line 816
	    }
#line 816
	}
#line 816
	    /* Choose a random point dividing each dim into 2 parts */
#line 816
	    /* Put 2^rank (nslabs) slabs so defined */
#line 816
	nslabs = 1;
#line 816
	for (j = 0; j < var_rank[i]; j++) {
#line 816
	    mid[j] = roll( var_shape[i][j] );
#line 816
	    nslabs *= 2;
#line 816
	}
#line 816
	    /* bits of k determine whether to put lower or upper part of dim */
#line 816
	    /* choose random stride from 1 to edge */
#line 816
	for (k = 0; k < nslabs; k++) {
#line 816
	    nstarts = 1;
#line 816
	    for (j = 0; j < var_rank[i]; j++) {
#line 816
		if ((k >> j) & 1) {
#line 816
		    start[j] = 0;
#line 816
		    edge[j] = mid[j];
#line 816
		}else{
#line 816
		    start[j] = mid[j];
#line 816
		    edge[j] = var_shape[i][j] - mid[j];
#line 816
		}
#line 816
		sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 816
		nstarts *= stride[j];
#line 816
	    }
#line 816
	    for (m = 0; m < nstarts; m++) {
#line 816
		err = toMixedBase(m, var_rank[i], sstride, index);
#line 816
		IF (err)
#line 816
		    error("error in toMixedBase");
#line 816
		nels = 1;
#line 816
		for (j = 0; j < var_rank[i]; j++) {
#line 816
		    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 816
		    nels *= count[j];
#line 816
		    index[j] += start[j];
#line 816
		}
#line 816
		    /* Random choice of forward or backward */
#line 816
/* TODO
#line 816
		if ( roll(2) ) {
#line 816
		    for (j = 0; j < var_rank[i]; j++) {
#line 816
			index[j] += (count[j] - 1) * stride[j];
#line 816
			stride[j] = -stride[j];
#line 816
		    }
#line 816
		}
#line 816
*/
#line 816
		for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 816
		    err = toMixedBase(j, var_rank[i], count, index2);
#line 816
		    IF (err)
#line 816
			error("error in toMixedBase");
#line 816
		    for (d = 0; d < var_rank[i]; d++)
#line 816
			index2[d] = index[d] + index2[d] * stride[d];
#line 816
		    value[j] = hash_text(var_type[i], var_rank[i], index2, 
#line 816
			NCT_TEXT);
#line 816
		    allInExtRange = allInExtRange 
#line 816
			&& inRange3(value[j], var_type[i], NCT_TEXT);
#line 816
		}
#line 816
		if (var_rank[i] == 0 && i%2 == 0)
#line 816
		    err = nc_put_vars_text(ncid, i, NULL, NULL, stride, value);
#line 816
		else
#line 816
		    err = nc_put_vars_text(ncid, i, index, count, stride, value);
#line 816
		if (canConvert) {
#line 816
		    if (allInExtRange) {
#line 816
			IF (err) 
#line 816
			    error("%s", nc_strerror(err));
#line 816
		    } else {
#line 816
			IF (err != NC_ERANGE)
#line 816
			    error("range error: status = %d", err);
#line 816
		    }
#line 816
		} else {
#line 816
		    IF (nels > 0 && err != NC_ECHAR)
#line 816
			error("wrong type: status = %d", err);
#line 816
		}
#line 816
	    }
#line 816
	}
#line 816
    }
#line 816

#line 816
    err = nc_close(ncid);
#line 816
    IF (err) 
#line 816
	error("nc_close: %s", nc_strerror(err));
#line 816

#line 816
    check_vars_text(scratch);
#line 816

#line 816
    err = remove(scratch);
#line 816
    IF (err)
#line 816
	error("remove of %s failed", scratch);
#line 816
}
#line 816

void
#line 817
test_nc_put_vars_uchar(void)
#line 817
{
#line 817
    int ncid;
#line 817
    int d;
#line 817
    int i;
#line 817
    int j;
#line 817
    int k;
#line 817
    int m;
#line 817
    int err;
#line 817
    int nels;
#line 817
    int nslabs;
#line 817
    int nstarts;        /* number of different starts */
#line 817
    size_t start[MAX_RANK];
#line 817
    size_t edge[MAX_RANK];
#line 817
    size_t index[MAX_RANK];
#line 817
    size_t index2[MAX_RANK];
#line 817
    size_t mid[MAX_RANK];
#line 817
    size_t count[MAX_RANK];
#line 817
    size_t sstride[MAX_RANK];
#line 817
    ptrdiff_t stride[MAX_RANK];
#line 817
    int canConvert;	/* Both text or both numeric */
#line 817
    int allInExtRange;	/* all values within external range? */
#line 817
    uchar value[MAX_NELS];
#line 817

#line 817
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 817
    IF (err) {
#line 817
	error("nc_create: %s", nc_strerror(err));
#line 817
	return;
#line 817
    }
#line 817
    def_dims(ncid);
#line 817
    def_vars(ncid);
#line 817
    err = nc_enddef(ncid);
#line 817
    IF (err)
#line 817
	error("nc_enddef: %s", nc_strerror(err));
#line 817

#line 817
    for (i = 0; i < NVARS; i++) {
#line 817
	canConvert = (var_type[i] == NC_CHAR) == (NCT_UCHAR == NCT_TEXT);
#line 817
	assert(var_rank[i] <= MAX_RANK);
#line 817
	assert(var_nels[i] <= MAX_NELS);
#line 817
	for (j = 0; j < var_rank[i]; j++) {
#line 817
	    start[j] = 0;
#line 817
	    edge[j] = 1;
#line 817
	    stride[j] = 1;
#line 817
	}
#line 817
	err = nc_put_vars_uchar(BAD_ID, i, start, edge, stride, value);
#line 817
	IF (err != NC_EBADID) 
#line 817
	    error("bad ncid: status = %d", err);
#line 817
	err = nc_put_vars_uchar(ncid, BAD_VARID, start, edge, stride, value);
#line 817
	IF (err != NC_ENOTVAR) 
#line 817
	    error("bad var id: status = %d", err);
#line 817
	for (j = 0; j < var_rank[i]; j++) {
#line 817
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 817
		start[j] = var_shape[i][j] + 1;
#line 817
		err = nc_put_vars_uchar(ncid, i, start, edge, stride, value);
#line 817
	      if(!canConvert) {
#line 817
		IF(err != NC_ECHAR)
#line 817
			error("conversion: status = %d", err);
#line 817
	      } else {
#line 817
		IF(err != NC_EINVALCOORDS)
#line 817
		    error("bad start: status = %d", err);
#line 817
		start[j] = 0;
#line 817
		edge[j] = var_shape[i][j] + 1;
#line 817
		err = nc_put_vars_uchar(ncid, i, start, edge, stride, value);
#line 817
		IF (err != NC_EEDGE)
#line 817
		    error("bad edge: status = %d", err);
#line 817
		edge[j] = 1;
#line 817
		stride[j] = 0;
#line 817
		err = nc_put_vars_uchar(ncid, i, start, edge, stride, value);
#line 817
		IF (err != NC_ESTRIDE)
#line 817
		    error("bad stride: status = %d", err);
#line 817
		stride[j] = 1;
#line 817
              }
#line 817
	    }
#line 817
	}
#line 817
	    /* Choose a random point dividing each dim into 2 parts */
#line 817
	    /* Put 2^rank (nslabs) slabs so defined */
#line 817
	nslabs = 1;
#line 817
	for (j = 0; j < var_rank[i]; j++) {
#line 817
	    mid[j] = roll( var_shape[i][j] );
#line 817
	    nslabs *= 2;
#line 817
	}
#line 817
	    /* bits of k determine whether to put lower or upper part of dim */
#line 817
	    /* choose random stride from 1 to edge */
#line 817
	for (k = 0; k < nslabs; k++) {
#line 817
	    nstarts = 1;
#line 817
	    for (j = 0; j < var_rank[i]; j++) {
#line 817
		if ((k >> j) & 1) {
#line 817
		    start[j] = 0;
#line 817
		    edge[j] = mid[j];
#line 817
		}else{
#line 817
		    start[j] = mid[j];
#line 817
		    edge[j] = var_shape[i][j] - mid[j];
#line 817
		}
#line 817
		sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 817
		nstarts *= stride[j];
#line 817
	    }
#line 817
	    for (m = 0; m < nstarts; m++) {
#line 817
		err = toMixedBase(m, var_rank[i], sstride, index);
#line 817
		IF (err)
#line 817
		    error("error in toMixedBase");
#line 817
		nels = 1;
#line 817
		for (j = 0; j < var_rank[i]; j++) {
#line 817
		    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 817
		    nels *= count[j];
#line 817
		    index[j] += start[j];
#line 817
		}
#line 817
		    /* Random choice of forward or backward */
#line 817
/* TODO
#line 817
		if ( roll(2) ) {
#line 817
		    for (j = 0; j < var_rank[i]; j++) {
#line 817
			index[j] += (count[j] - 1) * stride[j];
#line 817
			stride[j] = -stride[j];
#line 817
		    }
#line 817
		}
#line 817
*/
#line 817
		for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 817
		    err = toMixedBase(j, var_rank[i], count, index2);
#line 817
		    IF (err)
#line 817
			error("error in toMixedBase");
#line 817
		    for (d = 0; d < var_rank[i]; d++)
#line 817
			index2[d] = index[d] + index2[d] * stride[d];
#line 817
		    value[j] = hash_uchar(var_type[i], var_rank[i], index2, 
#line 817
			NCT_UCHAR);
#line 817
		    allInExtRange = allInExtRange 
#line 817
			&& inRange3(value[j], var_type[i], NCT_UCHAR);
#line 817
		}
#line 817
		if (var_rank[i] == 0 && i%2 == 0)
#line 817
		    err = nc_put_vars_uchar(ncid, i, NULL, NULL, stride, value);
#line 817
		else
#line 817
		    err = nc_put_vars_uchar(ncid, i, index, count, stride, value);
#line 817
		if (canConvert) {
#line 817
		    if (allInExtRange) {
#line 817
			IF (err) 
#line 817
			    error("%s", nc_strerror(err));
#line 817
		    } else {
#line 817
			IF (err != NC_ERANGE)
#line 817
			    error("range error: status = %d", err);
#line 817
		    }
#line 817
		} else {
#line 817
		    IF (nels > 0 && err != NC_ECHAR)
#line 817
			error("wrong type: status = %d", err);
#line 817
		}
#line 817
	    }
#line 817
	}
#line 817
    }
#line 817

#line 817
    err = nc_close(ncid);
#line 817
    IF (err) 
#line 817
	error("nc_close: %s", nc_strerror(err));
#line 817

#line 817
    check_vars_uchar(scratch);
#line 817

#line 817
    err = remove(scratch);
#line 817
    IF (err)
#line 817
	error("remove of %s failed", scratch);
#line 817
}
#line 817

void
#line 818
test_nc_put_vars_schar(void)
#line 818
{
#line 818
    int ncid;
#line 818
    int d;
#line 818
    int i;
#line 818
    int j;
#line 818
    int k;
#line 818
    int m;
#line 818
    int err;
#line 818
    int nels;
#line 818
    int nslabs;
#line 818
    int nstarts;        /* number of different starts */
#line 818
    size_t start[MAX_RANK];
#line 818
    size_t edge[MAX_RANK];
#line 818
    size_t index[MAX_RANK];
#line 818
    size_t index2[MAX_RANK];
#line 818
    size_t mid[MAX_RANK];
#line 818
    size_t count[MAX_RANK];
#line 818
    size_t sstride[MAX_RANK];
#line 818
    ptrdiff_t stride[MAX_RANK];
#line 818
    int canConvert;	/* Both text or both numeric */
#line 818
    int allInExtRange;	/* all values within external range? */
#line 818
    schar value[MAX_NELS];
#line 818

#line 818
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 818
    IF (err) {
#line 818
	error("nc_create: %s", nc_strerror(err));
#line 818
	return;
#line 818
    }
#line 818
    def_dims(ncid);
#line 818
    def_vars(ncid);
#line 818
    err = nc_enddef(ncid);
#line 818
    IF (err)
#line 818
	error("nc_enddef: %s", nc_strerror(err));
#line 818

#line 818
    for (i = 0; i < NVARS; i++) {
#line 818
	canConvert = (var_type[i] == NC_CHAR) == (NCT_SCHAR == NCT_TEXT);
#line 818
	assert(var_rank[i] <= MAX_RANK);
#line 818
	assert(var_nels[i] <= MAX_NELS);
#line 818
	for (j = 0; j < var_rank[i]; j++) {
#line 818
	    start[j] = 0;
#line 818
	    edge[j] = 1;
#line 818
	    stride[j] = 1;
#line 818
	}
#line 818
	err = nc_put_vars_schar(BAD_ID, i, start, edge, stride, value);
#line 818
	IF (err != NC_EBADID) 
#line 818
	    error("bad ncid: status = %d", err);
#line 818
	err = nc_put_vars_schar(ncid, BAD_VARID, start, edge, stride, value);
#line 818
	IF (err != NC_ENOTVAR) 
#line 818
	    error("bad var id: status = %d", err);
#line 818
	for (j = 0; j < var_rank[i]; j++) {
#line 818
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 818
		start[j] = var_shape[i][j] + 1;
#line 818
		err = nc_put_vars_schar(ncid, i, start, edge, stride, value);
#line 818
	      if(!canConvert) {
#line 818
		IF(err != NC_ECHAR)
#line 818
			error("conversion: status = %d", err);
#line 818
	      } else {
#line 818
		IF(err != NC_EINVALCOORDS)
#line 818
		    error("bad start: status = %d", err);
#line 818
		start[j] = 0;
#line 818
		edge[j] = var_shape[i][j] + 1;
#line 818
		err = nc_put_vars_schar(ncid, i, start, edge, stride, value);
#line 818
		IF (err != NC_EEDGE)
#line 818
		    error("bad edge: status = %d", err);
#line 818
		edge[j] = 1;
#line 818
		stride[j] = 0;
#line 818
		err = nc_put_vars_schar(ncid, i, start, edge, stride, value);
#line 818
		IF (err != NC_ESTRIDE)
#line 818
		    error("bad stride: status = %d", err);
#line 818
		stride[j] = 1;
#line 818
              }
#line 818
	    }
#line 818
	}
#line 818
	    /* Choose a random point dividing each dim into 2 parts */
#line 818
	    /* Put 2^rank (nslabs) slabs so defined */
#line 818
	nslabs = 1;
#line 818
	for (j = 0; j < var_rank[i]; j++) {
#line 818
	    mid[j] = roll( var_shape[i][j] );
#line 818
	    nslabs *= 2;
#line 818
	}
#line 818
	    /* bits of k determine whether to put lower or upper part of dim */
#line 818
	    /* choose random stride from 1 to edge */
#line 818
	for (k = 0; k < nslabs; k++) {
#line 818
	    nstarts = 1;
#line 818
	    for (j = 0; j < var_rank[i]; j++) {
#line 818
		if ((k >> j) & 1) {
#line 818
		    start[j] = 0;
#line 818
		    edge[j] = mid[j];
#line 818
		}else{
#line 818
		    start[j] = mid[j];
#line 818
		    edge[j] = var_shape[i][j] - mid[j];
#line 818
		}
#line 818
		sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 818
		nstarts *= stride[j];
#line 818
	    }
#line 818
	    for (m = 0; m < nstarts; m++) {
#line 818
		err = toMixedBase(m, var_rank[i], sstride, index);
#line 818
		IF (err)
#line 818
		    error("error in toMixedBase");
#line 818
		nels = 1;
#line 818
		for (j = 0; j < var_rank[i]; j++) {
#line 818
		    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 818
		    nels *= count[j];
#line 818
		    index[j] += start[j];
#line 818
		}
#line 818
		    /* Random choice of forward or backward */
#line 818
/* TODO
#line 818
		if ( roll(2) ) {
#line 818
		    for (j = 0; j < var_rank[i]; j++) {
#line 818
			index[j] += (count[j] - 1) * stride[j];
#line 818
			stride[j] = -stride[j];
#line 818
		    }
#line 818
		}
#line 818
*/
#line 818
		for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 818
		    err = toMixedBase(j, var_rank[i], count, index2);
#line 818
		    IF (err)
#line 818
			error("error in toMixedBase");
#line 818
		    for (d = 0; d < var_rank[i]; d++)
#line 818
			index2[d] = index[d] + index2[d] * stride[d];
#line 818
		    value[j] = hash_schar(var_type[i], var_rank[i], index2, 
#line 818
			NCT_SCHAR);
#line 818
		    allInExtRange = allInExtRange 
#line 818
			&& inRange3(value[j], var_type[i], NCT_SCHAR);
#line 818
		}
#line 818
		if (var_rank[i] == 0 && i%2 == 0)
#line 818
		    err = nc_put_vars_schar(ncid, i, NULL, NULL, stride, value);
#line 818
		else
#line 818
		    err = nc_put_vars_schar(ncid, i, index, count, stride, value);
#line 818
		if (canConvert) {
#line 818
		    if (allInExtRange) {
#line 818
			IF (err) 
#line 818
			    error("%s", nc_strerror(err));
#line 818
		    } else {
#line 818
			IF (err != NC_ERANGE)
#line 818
			    error("range error: status = %d", err);
#line 818
		    }
#line 818
		} else {
#line 818
		    IF (nels > 0 && err != NC_ECHAR)
#line 818
			error("wrong type: status = %d", err);
#line 818
		}
#line 818
	    }
#line 818
	}
#line 818
    }
#line 818

#line 818
    err = nc_close(ncid);
#line 818
    IF (err) 
#line 818
	error("nc_close: %s", nc_strerror(err));
#line 818

#line 818
    check_vars_schar(scratch);
#line 818

#line 818
    err = remove(scratch);
#line 818
    IF (err)
#line 818
	error("remove of %s failed", scratch);
#line 818
}
#line 818

void
#line 819
test_nc_put_vars_short(void)
#line 819
{
#line 819
    int ncid;
#line 819
    int d;
#line 819
    int i;
#line 819
    int j;
#line 819
    int k;
#line 819
    int m;
#line 819
    int err;
#line 819
    int nels;
#line 819
    int nslabs;
#line 819
    int nstarts;        /* number of different starts */
#line 819
    size_t start[MAX_RANK];
#line 819
    size_t edge[MAX_RANK];
#line 819
    size_t index[MAX_RANK];
#line 819
    size_t index2[MAX_RANK];
#line 819
    size_t mid[MAX_RANK];
#line 819
    size_t count[MAX_RANK];
#line 819
    size_t sstride[MAX_RANK];
#line 819
    ptrdiff_t stride[MAX_RANK];
#line 819
    int canConvert;	/* Both text or both numeric */
#line 819
    int allInExtRange;	/* all values within external range? */
#line 819
    short value[MAX_NELS];
#line 819

#line 819
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 819
    IF (err) {
#line 819
	error("nc_create: %s", nc_strerror(err));
#line 819
	return;
#line 819
    }
#line 819
    def_dims(ncid);
#line 819
    def_vars(ncid);
#line 819
    err = nc_enddef(ncid);
#line 819
    IF (err)
#line 819
	error("nc_enddef: %s", nc_strerror(err));
#line 819

#line 819
    for (i = 0; i < NVARS; i++) {
#line 819
	canConvert = (var_type[i] == NC_CHAR) == (NCT_SHORT == NCT_TEXT);
#line 819
	assert(var_rank[i] <= MAX_RANK);
#line 819
	assert(var_nels[i] <= MAX_NELS);
#line 819
	for (j = 0; j < var_rank[i]; j++) {
#line 819
	    start[j] = 0;
#line 819
	    edge[j] = 1;
#line 819
	    stride[j] = 1;
#line 819
	}
#line 819
	err = nc_put_vars_short(BAD_ID, i, start, edge, stride, value);
#line 819
	IF (err != NC_EBADID) 
#line 819
	    error("bad ncid: status = %d", err);
#line 819
	err = nc_put_vars_short(ncid, BAD_VARID, start, edge, stride, value);
#line 819
	IF (err != NC_ENOTVAR) 
#line 819
	    error("bad var id: status = %d", err);
#line 819
	for (j = 0; j < var_rank[i]; j++) {
#line 819
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 819
		start[j] = var_shape[i][j] + 1;
#line 819
		err = nc_put_vars_short(ncid, i, start, edge, stride, value);
#line 819
	      if(!canConvert) {
#line 819
		IF(err != NC_ECHAR)
#line 819
			error("conversion: status = %d", err);
#line 819
	      } else {
#line 819
		IF(err != NC_EINVALCOORDS)
#line 819
		    error("bad start: status = %d", err);
#line 819
		start[j] = 0;
#line 819
		edge[j] = var_shape[i][j] + 1;
#line 819
		err = nc_put_vars_short(ncid, i, start, edge, stride, value);
#line 819
		IF (err != NC_EEDGE)
#line 819
		    error("bad edge: status = %d", err);
#line 819
		edge[j] = 1;
#line 819
		stride[j] = 0;
#line 819
		err = nc_put_vars_short(ncid, i, start, edge, stride, value);
#line 819
		IF (err != NC_ESTRIDE)
#line 819
		    error("bad stride: status = %d", err);
#line 819
		stride[j] = 1;
#line 819
              }
#line 819
	    }
#line 819
	}
#line 819
	    /* Choose a random point dividing each dim into 2 parts */
#line 819
	    /* Put 2^rank (nslabs) slabs so defined */
#line 819
	nslabs = 1;
#line 819
	for (j = 0; j < var_rank[i]; j++) {
#line 819
	    mid[j] = roll( var_shape[i][j] );
#line 819
	    nslabs *= 2;
#line 819
	}
#line 819
	    /* bits of k determine whether to put lower or upper part of dim */
#line 819
	    /* choose random stride from 1 to edge */
#line 819
	for (k = 0; k < nslabs; k++) {
#line 819
	    nstarts = 1;
#line 819
	    for (j = 0; j < var_rank[i]; j++) {
#line 819
		if ((k >> j) & 1) {
#line 819
		    start[j] = 0;
#line 819
		    edge[j] = mid[j];
#line 819
		}else{
#line 819
		    start[j] = mid[j];
#line 819
		    edge[j] = var_shape[i][j] - mid[j];
#line 819
		}
#line 819
		sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 819
		nstarts *= stride[j];
#line 819
	    }
#line 819
	    for (m = 0; m < nstarts; m++) {
#line 819
		err = toMixedBase(m, var_rank[i], sstride, index);
#line 819
		IF (err)
#line 819
		    error("error in toMixedBase");
#line 819
		nels = 1;
#line 819
		for (j = 0; j < var_rank[i]; j++) {
#line 819
		    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 819
		    nels *= count[j];
#line 819
		    index[j] += start[j];
#line 819
		}
#line 819
		    /* Random choice of forward or backward */
#line 819
/* TODO
#line 819
		if ( roll(2) ) {
#line 819
		    for (j = 0; j < var_rank[i]; j++) {
#line 819
			index[j] += (count[j] - 1) * stride[j];
#line 819
			stride[j] = -stride[j];
#line 819
		    }
#line 819
		}
#line 819
*/
#line 819
		for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 819
		    err = toMixedBase(j, var_rank[i], count, index2);
#line 819
		    IF (err)
#line 819
			error("error in toMixedBase");
#line 819
		    for (d = 0; d < var_rank[i]; d++)
#line 819
			index2[d] = index[d] + index2[d] * stride[d];
#line 819
		    value[j] = hash_short(var_type[i], var_rank[i], index2, 
#line 819
			NCT_SHORT);
#line 819
		    allInExtRange = allInExtRange 
#line 819
			&& inRange3(value[j], var_type[i], NCT_SHORT);
#line 819
		}
#line 819
		if (var_rank[i] == 0 && i%2 == 0)
#line 819
		    err = nc_put_vars_short(ncid, i, NULL, NULL, stride, value);
#line 819
		else
#line 819
		    err = nc_put_vars_short(ncid, i, index, count, stride, value);
#line 819
		if (canConvert) {
#line 819
		    if (allInExtRange) {
#line 819
			IF (err) 
#line 819
			    error("%s", nc_strerror(err));
#line 819
		    } else {
#line 819
			IF (err != NC_ERANGE)
#line 819
			    error("range error: status = %d", err);
#line 819
		    }
#line 819
		} else {
#line 819
		    IF (nels > 0 && err != NC_ECHAR)
#line 819
			error("wrong type: status = %d", err);
#line 819
		}
#line 819
	    }
#line 819
	}
#line 819
    }
#line 819

#line 819
    err = nc_close(ncid);
#line 819
    IF (err) 
#line 819
	error("nc_close: %s", nc_strerror(err));
#line 819

#line 819
    check_vars_short(scratch);
#line 819

#line 819
    err = remove(scratch);
#line 819
    IF (err)
#line 819
	error("remove of %s failed", scratch);
#line 819
}
#line 819

void
#line 820
test_nc_put_vars_int(void)
#line 820
{
#line 820
    int ncid;
#line 820
    int d;
#line 820
    int i;
#line 820
    int j;
#line 820
    int k;
#line 820
    int m;
#line 820
    int err;
#line 820
    int nels;
#line 820
    int nslabs;
#line 820
    int nstarts;        /* number of different starts */
#line 820
    size_t start[MAX_RANK];
#line 820
    size_t edge[MAX_RANK];
#line 820
    size_t index[MAX_RANK];
#line 820
    size_t index2[MAX_RANK];
#line 820
    size_t mid[MAX_RANK];
#line 820
    size_t count[MAX_RANK];
#line 820
    size_t sstride[MAX_RANK];
#line 820
    ptrdiff_t stride[MAX_RANK];
#line 820
    int canConvert;	/* Both text or both numeric */
#line 820
    int allInExtRange;	/* all values within external range? */
#line 820
    int value[MAX_NELS];
#line 820

#line 820
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 820
    IF (err) {
#line 820
	error("nc_create: %s", nc_strerror(err));
#line 820
	return;
#line 820
    }
#line 820
    def_dims(ncid);
#line 820
    def_vars(ncid);
#line 820
    err = nc_enddef(ncid);
#line 820
    IF (err)
#line 820
	error("nc_enddef: %s", nc_strerror(err));
#line 820

#line 820
    for (i = 0; i < NVARS; i++) {
#line 820
	canConvert = (var_type[i] == NC_CHAR) == (NCT_INT == NCT_TEXT);
#line 820
	assert(var_rank[i] <= MAX_RANK);
#line 820
	assert(var_nels[i] <= MAX_NELS);
#line 820
	for (j = 0; j < var_rank[i]; j++) {
#line 820
	    start[j] = 0;
#line 820
	    edge[j] = 1;
#line 820
	    stride[j] = 1;
#line 820
	}
#line 820
	err = nc_put_vars_int(BAD_ID, i, start, edge, stride, value);
#line 820
	IF (err != NC_EBADID) 
#line 820
	    error("bad ncid: status = %d", err);
#line 820
	err = nc_put_vars_int(ncid, BAD_VARID, start, edge, stride, value);
#line 820
	IF (err != NC_ENOTVAR) 
#line 820
	    error("bad var id: status = %d", err);
#line 820
	for (j = 0; j < var_rank[i]; j++) {
#line 820
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 820
		start[j] = var_shape[i][j] + 1;
#line 820
		err = nc_put_vars_int(ncid, i, start, edge, stride, value);
#line 820
	      if(!canConvert) {
#line 820
		IF(err != NC_ECHAR)
#line 820
			error("conversion: status = %d", err);
#line 820
	      } else {
#line 820
		IF(err != NC_EINVALCOORDS)
#line 820
		    error("bad start: status = %d", err);
#line 820
		start[j] = 0;
#line 820
		edge[j] = var_shape[i][j] + 1;
#line 820
		err = nc_put_vars_int(ncid, i, start, edge, stride, value);
#line 820
		IF (err != NC_EEDGE)
#line 820
		    error("bad edge: status = %d", err);
#line 820
		edge[j] = 1;
#line 820
		stride[j] = 0;
#line 820
		err = nc_put_vars_int(ncid, i, start, edge, stride, value);
#line 820
		IF (err != NC_ESTRIDE)
#line 820
		    error("bad stride: status = %d", err);
#line 820
		stride[j] = 1;
#line 820
              }
#line 820
	    }
#line 820
	}
#line 820
	    /* Choose a random point dividing each dim into 2 parts */
#line 820
	    /* Put 2^rank (nslabs) slabs so defined */
#line 820
	nslabs = 1;
#line 820
	for (j = 0; j < var_rank[i]; j++) {
#line 820
	    mid[j] = roll( var_shape[i][j] );
#line 820
	    nslabs *= 2;
#line 820
	}
#line 820
	    /* bits of k determine whether to put lower or upper part of dim */
#line 820
	    /* choose random stride from 1 to edge */
#line 820
	for (k = 0; k < nslabs; k++) {
#line 820
	    nstarts = 1;
#line 820
	    for (j = 0; j < var_rank[i]; j++) {
#line 820
		if ((k >> j) & 1) {
#line 820
		    start[j] = 0;
#line 820
		    edge[j] = mid[j];
#line 820
		}else{
#line 820
		    start[j] = mid[j];
#line 820
		    edge[j] = var_shape[i][j] - mid[j];
#line 820
		}
#line 820
		sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 820
		nstarts *= stride[j];
#line 820
	    }
#line 820
	    for (m = 0; m < nstarts; m++) {
#line 820
		err = toMixedBase(m, var_rank[i], sstride, index);
#line 820
		IF (err)
#line 820
		    error("error in toMixedBase");
#line 820
		nels = 1;
#line 820
		for (j = 0; j < var_rank[i]; j++) {
#line 820
		    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 820
		    nels *= count[j];
#line 820
		    index[j] += start[j];
#line 820
		}
#line 820
		    /* Random choice of forward or backward */
#line 820
/* TODO
#line 820
		if ( roll(2) ) {
#line 820
		    for (j = 0; j < var_rank[i]; j++) {
#line 820
			index[j] += (count[j] - 1) * stride[j];
#line 820
			stride[j] = -stride[j];
#line 820
		    }
#line 820
		}
#line 820
*/
#line 820
		for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 820
		    err = toMixedBase(j, var_rank[i], count, index2);
#line 820
		    IF (err)
#line 820
			error("error in toMixedBase");
#line 820
		    for (d = 0; d < var_rank[i]; d++)
#line 820
			index2[d] = index[d] + index2[d] * stride[d];
#line 820
		    value[j] = hash_int(var_type[i], var_rank[i], index2, 
#line 820
			NCT_INT);
#line 820
		    allInExtRange = allInExtRange 
#line 820
			&& inRange3(value[j], var_type[i], NCT_INT);
#line 820
		}
#line 820
		if (var_rank[i] == 0 && i%2 == 0)
#line 820
		    err = nc_put_vars_int(ncid, i, NULL, NULL, stride, value);
#line 820
		else
#line 820
		    err = nc_put_vars_int(ncid, i, index, count, stride, value);
#line 820
		if (canConvert) {
#line 820
		    if (allInExtRange) {
#line 820
			IF (err) 
#line 820
			    error("%s", nc_strerror(err));
#line 820
		    } else {
#line 820
			IF (err != NC_ERANGE)
#line 820
			    error("range error: status = %d", err);
#line 820
		    }
#line 820
		} else {
#line 820
		    IF (nels > 0 && err != NC_ECHAR)
#line 820
			error("wrong type: status = %d", err);
#line 820
		}
#line 820
	    }
#line 820
	}
#line 820
    }
#line 820

#line 820
    err = nc_close(ncid);
#line 820
    IF (err) 
#line 820
	error("nc_close: %s", nc_strerror(err));
#line 820

#line 820
    check_vars_int(scratch);
#line 820

#line 820
    err = remove(scratch);
#line 820
    IF (err)
#line 820
	error("remove of %s failed", scratch);
#line 820
}
#line 820

void
#line 821
test_nc_put_vars_long(void)
#line 821
{
#line 821
    int ncid;
#line 821
    int d;
#line 821
    int i;
#line 821
    int j;
#line 821
    int k;
#line 821
    int m;
#line 821
    int err;
#line 821
    int nels;
#line 821
    int nslabs;
#line 821
    int nstarts;        /* number of different starts */
#line 821
    size_t start[MAX_RANK];
#line 821
    size_t edge[MAX_RANK];
#line 821
    size_t index[MAX_RANK];
#line 821
    size_t index2[MAX_RANK];
#line 821
    size_t mid[MAX_RANK];
#line 821
    size_t count[MAX_RANK];
#line 821
    size_t sstride[MAX_RANK];
#line 821
    ptrdiff_t stride[MAX_RANK];
#line 821
    int canConvert;	/* Both text or both numeric */
#line 821
    int allInExtRange;	/* all values within external range? */
#line 821
    long value[MAX_NELS];
#line 821

#line 821
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 821
    IF (err) {
#line 821
	error("nc_create: %s", nc_strerror(err));
#line 821
	return;
#line 821
    }
#line 821
    def_dims(ncid);
#line 821
    def_vars(ncid);
#line 821
    err = nc_enddef(ncid);
#line 821
    IF (err)
#line 821
	error("nc_enddef: %s", nc_strerror(err));
#line 821

#line 821
    for (i = 0; i < NVARS; i++) {
#line 821
	canConvert = (var_type[i] == NC_CHAR) == (NCT_LONG == NCT_TEXT);
#line 821
	assert(var_rank[i] <= MAX_RANK);
#line 821
	assert(var_nels[i] <= MAX_NELS);
#line 821
	for (j = 0; j < var_rank[i]; j++) {
#line 821
	    start[j] = 0;
#line 821
	    edge[j] = 1;
#line 821
	    stride[j] = 1;
#line 821
	}
#line 821
	err = nc_put_vars_long(BAD_ID, i, start, edge, stride, value);
#line 821
	IF (err != NC_EBADID) 
#line 821
	    error("bad ncid: status = %d", err);
#line 821
	err = nc_put_vars_long(ncid, BAD_VARID, start, edge, stride, value);
#line 821
	IF (err != NC_ENOTVAR) 
#line 821
	    error("bad var id: status = %d", err);
#line 821
	for (j = 0; j < var_rank[i]; j++) {
#line 821
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 821
		start[j] = var_shape[i][j] + 1;
#line 821
		err = nc_put_vars_long(ncid, i, start, edge, stride, value);
#line 821
	      if(!canConvert) {
#line 821
		IF(err != NC_ECHAR)
#line 821
			error("conversion: status = %d", err);
#line 821
	      } else {
#line 821
		IF(err != NC_EINVALCOORDS)
#line 821
		    error("bad start: status = %d", err);
#line 821
		start[j] = 0;
#line 821
		edge[j] = var_shape[i][j] + 1;
#line 821
		err = nc_put_vars_long(ncid, i, start, edge, stride, value);
#line 821
		IF (err != NC_EEDGE)
#line 821
		    error("bad edge: status = %d", err);
#line 821
		edge[j] = 1;
#line 821
		stride[j] = 0;
#line 821
		err = nc_put_vars_long(ncid, i, start, edge, stride, value);
#line 821
		IF (err != NC_ESTRIDE)
#line 821
		    error("bad stride: status = %d", err);
#line 821
		stride[j] = 1;
#line 821
              }
#line 821
	    }
#line 821
	}
#line 821
	    /* Choose a random point dividing each dim into 2 parts */
#line 821
	    /* Put 2^rank (nslabs) slabs so defined */
#line 821
	nslabs = 1;
#line 821
	for (j = 0; j < var_rank[i]; j++) {
#line 821
	    mid[j] = roll( var_shape[i][j] );
#line 821
	    nslabs *= 2;
#line 821
	}
#line 821
	    /* bits of k determine whether to put lower or upper part of dim */
#line 821
	    /* choose random stride from 1 to edge */
#line 821
	for (k = 0; k < nslabs; k++) {
#line 821
	    nstarts = 1;
#line 821
	    for (j = 0; j < var_rank[i]; j++) {
#line 821
		if ((k >> j) & 1) {
#line 821
		    start[j] = 0;
#line 821
		    edge[j] = mid[j];
#line 821
		}else{
#line 821
		    start[j] = mid[j];
#line 821
		    edge[j] = var_shape[i][j] - mid[j];
#line 821
		}
#line 821
		sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 821
		nstarts *= stride[j];
#line 821
	    }
#line 821
	    for (m = 0; m < nstarts; m++) {
#line 821
		err = toMixedBase(m, var_rank[i], sstride, index);
#line 821
		IF (err)
#line 821
		    error("error in toMixedBase");
#line 821
		nels = 1;
#line 821
		for (j = 0; j < var_rank[i]; j++) {
#line 821
		    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 821
		    nels *= count[j];
#line 821
		    index[j] += start[j];
#line 821
		}
#line 821
		    /* Random choice of forward or backward */
#line 821
/* TODO
#line 821
		if ( roll(2) ) {
#line 821
		    for (j = 0; j < var_rank[i]; j++) {
#line 821
			index[j] += (count[j] - 1) * stride[j];
#line 821
			stride[j] = -stride[j];
#line 821
		    }
#line 821
		}
#line 821
*/
#line 821
		for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 821
		    err = toMixedBase(j, var_rank[i], count, index2);
#line 821
		    IF (err)
#line 821
			error("error in toMixedBase");
#line 821
		    for (d = 0; d < var_rank[i]; d++)
#line 821
			index2[d] = index[d] + index2[d] * stride[d];
#line 821
		    value[j] = hash_long(var_type[i], var_rank[i], index2, 
#line 821
			NCT_LONG);
#line 821
		    allInExtRange = allInExtRange 
#line 821
			&& inRange3(value[j], var_type[i], NCT_LONG);
#line 821
		}
#line 821
		if (var_rank[i] == 0 && i%2 == 0)
#line 821
		    err = nc_put_vars_long(ncid, i, NULL, NULL, stride, value);
#line 821
		else
#line 821
		    err = nc_put_vars_long(ncid, i, index, count, stride, value);
#line 821
		if (canConvert) {
#line 821
		    if (allInExtRange) {
#line 821
			IF (err) 
#line 821
			    error("%s", nc_strerror(err));
#line 821
		    } else {
#line 821
			IF (err != NC_ERANGE)
#line 821
			    error("range error: status = %d", err);
#line 821
		    }
#line 821
		} else {
#line 821
		    IF (nels > 0 && err != NC_ECHAR)
#line 821
			error("wrong type: status = %d", err);
#line 821
		}
#line 821
	    }
#line 821
	}
#line 821
    }
#line 821

#line 821
    err = nc_close(ncid);
#line 821
    IF (err) 
#line 821
	error("nc_close: %s", nc_strerror(err));
#line 821

#line 821
    check_vars_long(scratch);
#line 821

#line 821
    err = remove(scratch);
#line 821
    IF (err)
#line 821
	error("remove of %s failed", scratch);
#line 821
}
#line 821

void
#line 822
test_nc_put_vars_float(void)
#line 822
{
#line 822
    int ncid;
#line 822
    int d;
#line 822
    int i;
#line 822
    int j;
#line 822
    int k;
#line 822
    int m;
#line 822
    int err;
#line 822
    int nels;
#line 822
    int nslabs;
#line 822
    int nstarts;        /* number of different starts */
#line 822
    size_t start[MAX_RANK];
#line 822
    size_t edge[MAX_RANK];
#line 822
    size_t index[MAX_RANK];
#line 822
    size_t index2[MAX_RANK];
#line 822
    size_t mid[MAX_RANK];
#line 822
    size_t count[MAX_RANK];
#line 822
    size_t sstride[MAX_RANK];
#line 822
    ptrdiff_t stride[MAX_RANK];
#line 822
    int canConvert;	/* Both text or both numeric */
#line 822
    int allInExtRange;	/* all values within external range? */
#line 822
    float value[MAX_NELS];
#line 822

#line 822
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 822
    IF (err) {
#line 822
	error("nc_create: %s", nc_strerror(err));
#line 822
	return;
#line 822
    }
#line 822
    def_dims(ncid);
#line 822
    def_vars(ncid);
#line 822
    err = nc_enddef(ncid);
#line 822
    IF (err)
#line 822
	error("nc_enddef: %s", nc_strerror(err));
#line 822

#line 822
    for (i = 0; i < NVARS; i++) {
#line 822
	canConvert = (var_type[i] == NC_CHAR) == (NCT_FLOAT == NCT_TEXT);
#line 822
	assert(var_rank[i] <= MAX_RANK);
#line 822
	assert(var_nels[i] <= MAX_NELS);
#line 822
	for (j = 0; j < var_rank[i]; j++) {
#line 822
	    start[j] = 0;
#line 822
	    edge[j] = 1;
#line 822
	    stride[j] = 1;
#line 822
	}
#line 822
	err = nc_put_vars_float(BAD_ID, i, start, edge, stride, value);
#line 822
	IF (err != NC_EBADID) 
#line 822
	    error("bad ncid: status = %d", err);
#line 822
	err = nc_put_vars_float(ncid, BAD_VARID, start, edge, stride, value);
#line 822
	IF (err != NC_ENOTVAR) 
#line 822
	    error("bad var id: status = %d", err);
#line 822
	for (j = 0; j < var_rank[i]; j++) {
#line 822
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 822
		start[j] = var_shape[i][j] + 1;
#line 822
		err = nc_put_vars_float(ncid, i, start, edge, stride, value);
#line 822
	      if(!canConvert) {
#line 822
		IF(err != NC_ECHAR)
#line 822
			error("conversion: status = %d", err);
#line 822
	      } else {
#line 822
		IF(err != NC_EINVALCOORDS)
#line 822
		    error("bad start: status = %d", err);
#line 822
		start[j] = 0;
#line 822
		edge[j] = var_shape[i][j] + 1;
#line 822
		err = nc_put_vars_float(ncid, i, start, edge, stride, value);
#line 822
		IF (err != NC_EEDGE)
#line 822
		    error("bad edge: status = %d", err);
#line 822
		edge[j] = 1;
#line 822
		stride[j] = 0;
#line 822
		err = nc_put_vars_float(ncid, i, start, edge, stride, value);
#line 822
		IF (err != NC_ESTRIDE)
#line 822
		    error("bad stride: status = %d", err);
#line 822
		stride[j] = 1;
#line 822
              }
#line 822
	    }
#line 822
	}
#line 822
	    /* Choose a random point dividing each dim into 2 parts */
#line 822
	    /* Put 2^rank (nslabs) slabs so defined */
#line 822
	nslabs = 1;
#line 822
	for (j = 0; j < var_rank[i]; j++) {
#line 822
	    mid[j] = roll( var_shape[i][j] );
#line 822
	    nslabs *= 2;
#line 822
	}
#line 822
	    /* bits of k determine whether to put lower or upper part of dim */
#line 822
	    /* choose random stride from 1 to edge */
#line 822
	for (k = 0; k < nslabs; k++) {
#line 822
	    nstarts = 1;
#line 822
	    for (j = 0; j < var_rank[i]; j++) {
#line 822
		if ((k >> j) & 1) {
#line 822
		    start[j] = 0;
#line 822
		    edge[j] = mid[j];
#line 822
		}else{
#line 822
		    start[j] = mid[j];
#line 822
		    edge[j] = var_shape[i][j] - mid[j];
#line 822
		}
#line 822
		sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 822
		nstarts *= stride[j];
#line 822
	    }
#line 822
	    for (m = 0; m < nstarts; m++) {
#line 822
		err = toMixedBase(m, var_rank[i], sstride, index);
#line 822
		IF (err)
#line 822
		    error("error in toMixedBase");
#line 822
		nels = 1;
#line 822
		for (j = 0; j < var_rank[i]; j++) {
#line 822
		    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 822
		    nels *= count[j];
#line 822
		    index[j] += start[j];
#line 822
		}
#line 822
		    /* Random choice of forward or backward */
#line 822
/* TODO
#line 822
		if ( roll(2) ) {
#line 822
		    for (j = 0; j < var_rank[i]; j++) {
#line 822
			index[j] += (count[j] - 1) * stride[j];
#line 822
			stride[j] = -stride[j];
#line 822
		    }
#line 822
		}
#line 822
*/
#line 822
		for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 822
		    err = toMixedBase(j, var_rank[i], count, index2);
#line 822
		    IF (err)
#line 822
			error("error in toMixedBase");
#line 822
		    for (d = 0; d < var_rank[i]; d++)
#line 822
			index2[d] = index[d] + index2[d] * stride[d];
#line 822
		    value[j] = hash_float(var_type[i], var_rank[i], index2, 
#line 822
			NCT_FLOAT);
#line 822
		    allInExtRange = allInExtRange 
#line 822
			&& inRange3(value[j], var_type[i], NCT_FLOAT);
#line 822
		}
#line 822
		if (var_rank[i] == 0 && i%2 == 0)
#line 822
		    err = nc_put_vars_float(ncid, i, NULL, NULL, stride, value);
#line 822
		else
#line 822
		    err = nc_put_vars_float(ncid, i, index, count, stride, value);
#line 822
		if (canConvert) {
#line 822
		    if (allInExtRange) {
#line 822
			IF (err) 
#line 822
			    error("%s", nc_strerror(err));
#line 822
		    } else {
#line 822
			IF (err != NC_ERANGE)
#line 822
			    error("range error: status = %d", err);
#line 822
		    }
#line 822
		} else {
#line 822
		    IF (nels > 0 && err != NC_ECHAR)
#line 822
			error("wrong type: status = %d", err);
#line 822
		}
#line 822
	    }
#line 822
	}
#line 822
    }
#line 822

#line 822
    err = nc_close(ncid);
#line 822
    IF (err) 
#line 822
	error("nc_close: %s", nc_strerror(err));
#line 822

#line 822
    check_vars_float(scratch);
#line 822

#line 822
    err = remove(scratch);
#line 822
    IF (err)
#line 822
	error("remove of %s failed", scratch);
#line 822
}
#line 822

void
#line 823
test_nc_put_vars_double(void)
#line 823
{
#line 823
    int ncid;
#line 823
    int d;
#line 823
    int i;
#line 823
    int j;
#line 823
    int k;
#line 823
    int m;
#line 823
    int err;
#line 823
    int nels;
#line 823
    int nslabs;
#line 823
    int nstarts;        /* number of different starts */
#line 823
    size_t start[MAX_RANK];
#line 823
    size_t edge[MAX_RANK];
#line 823
    size_t index[MAX_RANK];
#line 823
    size_t index2[MAX_RANK];
#line 823
    size_t mid[MAX_RANK];
#line 823
    size_t count[MAX_RANK];
#line 823
    size_t sstride[MAX_RANK];
#line 823
    ptrdiff_t stride[MAX_RANK];
#line 823
    int canConvert;	/* Both text or both numeric */
#line 823
    int allInExtRange;	/* all values within external range? */
#line 823
    double value[MAX_NELS];
#line 823

#line 823
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 823
    IF (err) {
#line 823
	error("nc_create: %s", nc_strerror(err));
#line 823
	return;
#line 823
    }
#line 823
    def_dims(ncid);
#line 823
    def_vars(ncid);
#line 823
    err = nc_enddef(ncid);
#line 823
    IF (err)
#line 823
	error("nc_enddef: %s", nc_strerror(err));
#line 823

#line 823
    for (i = 0; i < NVARS; i++) {
#line 823
	canConvert = (var_type[i] == NC_CHAR) == (NCT_DOUBLE == NCT_TEXT);
#line 823
	assert(var_rank[i] <= MAX_RANK);
#line 823
	assert(var_nels[i] <= MAX_NELS);
#line 823
	for (j = 0; j < var_rank[i]; j++) {
#line 823
	    start[j] = 0;
#line 823
	    edge[j] = 1;
#line 823
	    stride[j] = 1;
#line 823
	}
#line 823
	err = nc_put_vars_double(BAD_ID, i, start, edge, stride, value);
#line 823
	IF (err != NC_EBADID) 
#line 823
	    error("bad ncid: status = %d", err);
#line 823
	err = nc_put_vars_double(ncid, BAD_VARID, start, edge, stride, value);
#line 823
	IF (err != NC_ENOTVAR) 
#line 823
	    error("bad var id: status = %d", err);
#line 823
	for (j = 0; j < var_rank[i]; j++) {
#line 823
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 823
		start[j] = var_shape[i][j] + 1;
#line 823
		err = nc_put_vars_double(ncid, i, start, edge, stride, value);
#line 823
	      if(!canConvert) {
#line 823
		IF(err != NC_ECHAR)
#line 823
			error("conversion: status = %d", err);
#line 823
	      } else {
#line 823
		IF(err != NC_EINVALCOORDS)
#line 823
		    error("bad start: status = %d", err);
#line 823
		start[j] = 0;
#line 823
		edge[j] = var_shape[i][j] + 1;
#line 823
		err = nc_put_vars_double(ncid, i, start, edge, stride, value);
#line 823
		IF (err != NC_EEDGE)
#line 823
		    error("bad edge: status = %d", err);
#line 823
		edge[j] = 1;
#line 823
		stride[j] = 0;
#line 823
		err = nc_put_vars_double(ncid, i, start, edge, stride, value);
#line 823
		IF (err != NC_ESTRIDE)
#line 823
		    error("bad stride: status = %d", err);
#line 823
		stride[j] = 1;
#line 823
              }
#line 823
	    }
#line 823
	}
#line 823
	    /* Choose a random point dividing each dim into 2 parts */
#line 823
	    /* Put 2^rank (nslabs) slabs so defined */
#line 823
	nslabs = 1;
#line 823
	for (j = 0; j < var_rank[i]; j++) {
#line 823
	    mid[j] = roll( var_shape[i][j] );
#line 823
	    nslabs *= 2;
#line 823
	}
#line 823
	    /* bits of k determine whether to put lower or upper part of dim */
#line 823
	    /* choose random stride from 1 to edge */
#line 823
	for (k = 0; k < nslabs; k++) {
#line 823
	    nstarts = 1;
#line 823
	    for (j = 0; j < var_rank[i]; j++) {
#line 823
		if ((k >> j) & 1) {
#line 823
		    start[j] = 0;
#line 823
		    edge[j] = mid[j];
#line 823
		}else{
#line 823
		    start[j] = mid[j];
#line 823
		    edge[j] = var_shape[i][j] - mid[j];
#line 823
		}
#line 823
		sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 823
		nstarts *= stride[j];
#line 823
	    }
#line 823
	    for (m = 0; m < nstarts; m++) {
#line 823
		err = toMixedBase(m, var_rank[i], sstride, index);
#line 823
		IF (err)
#line 823
		    error("error in toMixedBase");
#line 823
		nels = 1;
#line 823
		for (j = 0; j < var_rank[i]; j++) {
#line 823
		    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 823
		    nels *= count[j];
#line 823
		    index[j] += start[j];
#line 823
		}
#line 823
		    /* Random choice of forward or backward */
#line 823
/* TODO
#line 823
		if ( roll(2) ) {
#line 823
		    for (j = 0; j < var_rank[i]; j++) {
#line 823
			index[j] += (count[j] - 1) * stride[j];
#line 823
			stride[j] = -stride[j];
#line 823
		    }
#line 823
		}
#line 823
*/
#line 823
		for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 823
		    err = toMixedBase(j, var_rank[i], count, index2);
#line 823
		    IF (err)
#line 823
			error("error in toMixedBase");
#line 823
		    for (d = 0; d < var_rank[i]; d++)
#line 823
			index2[d] = index[d] + index2[d] * stride[d];
#line 823
		    value[j] = hash_double(var_type[i], var_rank[i], index2, 
#line 823
			NCT_DOUBLE);
#line 823
		    allInExtRange = allInExtRange 
#line 823
			&& inRange3(value[j], var_type[i], NCT_DOUBLE);
#line 823
		}
#line 823
		if (var_rank[i] == 0 && i%2 == 0)
#line 823
		    err = nc_put_vars_double(ncid, i, NULL, NULL, stride, value);
#line 823
		else
#line 823
		    err = nc_put_vars_double(ncid, i, index, count, stride, value);
#line 823
		if (canConvert) {
#line 823
		    if (allInExtRange) {
#line 823
			IF (err) 
#line 823
			    error("%s", nc_strerror(err));
#line 823
		    } else {
#line 823
			IF (err != NC_ERANGE)
#line 823
			    error("range error: status = %d", err);
#line 823
		    }
#line 823
		} else {
#line 823
		    IF (nels > 0 && err != NC_ECHAR)
#line 823
			error("wrong type: status = %d", err);
#line 823
		}
#line 823
	    }
#line 823
	}
#line 823
    }
#line 823

#line 823
    err = nc_close(ncid);
#line 823
    IF (err) 
#line 823
	error("nc_close: %s", nc_strerror(err));
#line 823

#line 823
    check_vars_double(scratch);
#line 823

#line 823
    err = remove(scratch);
#line 823
    IF (err)
#line 823
	error("remove of %s failed", scratch);
#line 823
}
#line 823



#line 996

void
#line 997
test_nc_put_varm_text(void)
#line 997
{
#line 997
    int ncid;
#line 997
    int d;
#line 997
    int i;
#line 997
    int j;
#line 997
    int k;
#line 997
    int m;
#line 997
    int err;
#line 997
    int nels;
#line 997
    int nslabs;
#line 997
    int nstarts;        /* number of different starts */
#line 997
    size_t start[MAX_RANK];
#line 997
    size_t edge[MAX_RANK];
#line 997
    size_t index[MAX_RANK];
#line 997
    size_t index2[MAX_RANK];
#line 997
    size_t mid[MAX_RANK];
#line 997
    size_t count[MAX_RANK];
#line 997
    size_t sstride[MAX_RANK];
#line 997
    ptrdiff_t stride[MAX_RANK];
#line 997
    ptrdiff_t imap[MAX_RANK];
#line 997
    int canConvert;	/* Both text or both numeric */
#line 997
    int allInExtRange;	/* all values within external range? */
#line 997
    text value[MAX_NELS];
#line 997

#line 997
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 997
    IF (err) {
#line 997
	error("nc_create: %s", nc_strerror(err));
#line 997
	return;
#line 997
    }
#line 997
    def_dims(ncid);
#line 997
    def_vars(ncid);
#line 997
    err = nc_enddef(ncid);
#line 997
    IF (err)
#line 997
	error("nc_enddef: %s", nc_strerror(err));
#line 997

#line 997
    for (i = 0; i < NVARS; i++) {
#line 997
	canConvert = (var_type[i] == NC_CHAR) == (NCT_TEXT == NCT_TEXT);
#line 997
	assert(var_rank[i] <= MAX_RANK);
#line 997
	assert(var_nels[i] <= MAX_NELS);
#line 997
	for (j = 0; j < var_rank[i]; j++) {
#line 997
	    start[j] = 0;
#line 997
	    edge[j] = 1;
#line 997
	    stride[j] = 1;
#line 997
	    imap[j] = 1;
#line 997
	}
#line 997
	err = nc_put_varm_text(BAD_ID, i, start, edge, stride, imap, value);
#line 997
	IF (err != NC_EBADID) 
#line 997
	    error("bad ncid: status = %d", err);
#line 997
	err = nc_put_varm_text(ncid, BAD_VARID, start, edge, stride, imap, value);
#line 997
	IF (err != NC_ENOTVAR) 
#line 997
	    error("bad var id: status = %d", err);
#line 997
	for (j = 0; j < var_rank[i]; j++) {
#line 997
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 997
		start[j] = var_shape[i][j] + 1;
#line 997
		err = nc_put_varm_text(ncid, i, start, edge, stride, imap, value);
#line 997
	      if (!canConvert) {
#line 997
		IF(err != NC_ECHAR)
#line 997
			error("conversion: status = %d", err);
#line 997
	      } else {
#line 997
		IF (err != NC_EINVALCOORDS)
#line 997
		    error("bad start: status = %d", err);
#line 997
		start[j] = 0;
#line 997
		edge[j] = var_shape[i][j] + 1;
#line 997
		err = nc_put_varm_text(ncid, i, start, edge, stride, imap, value);
#line 997
		IF (err != NC_EEDGE)
#line 997
		    error("bad edge: status = %d", err);
#line 997
		edge[j] = 1;
#line 997
		stride[j] = 0;
#line 997
		err = nc_put_varm_text(ncid, i, start, edge, stride, imap, value);
#line 997
		IF (err != NC_ESTRIDE)
#line 997
		    error("bad stride: status = %d", err);
#line 997
		stride[j] = 1;
#line 997
	      }
#line 997
	    }
#line 997
	}
#line 997
	    /* Choose a random point dividing each dim into 2 parts */
#line 997
	    /* Put 2^rank (nslabs) slabs so defined */
#line 997
	nslabs = 1;
#line 997
	for (j = 0; j < var_rank[i]; j++) {
#line 997
	    mid[j] = roll( var_shape[i][j] );
#line 997
	    nslabs *= 2;
#line 997
	}
#line 997
	    /* bits of k determine whether to put lower or upper part of dim */
#line 997
	    /* choose random stride from 1 to edge */
#line 997
	for (k = 0; k < nslabs; k++) {
#line 997
	    nstarts = 1;
#line 997
	    for (j = 0; j < var_rank[i]; j++) {
#line 997
		if ((k >> j) & 1) {
#line 997
		    start[j] = 0;
#line 997
		    edge[j] = mid[j];
#line 997
		}else{
#line 997
		    start[j] = mid[j];
#line 997
		    edge[j] = var_shape[i][j] - mid[j];
#line 997
		}
#line 997
		sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 997
		nstarts *= stride[j];
#line 997
	    }
#line 997
            for (m = 0; m < nstarts; m++) {
#line 997
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 997
                IF (err)
#line 997
                    error("error in toMixedBase");
#line 997
                nels = 1;
#line 997
                for (j = 0; j < var_rank[i]; j++) {
#line 997
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 997
                    nels *= count[j];
#line 997
                    index[j] += start[j];
#line 997
                }
#line 997
                    /* Random choice of forward or backward */
#line 997
/* TODO
#line 997
                if ( roll(2) ) {
#line 997
                    for (j = 0; j < var_rank[i]; j++) {
#line 997
                        index[j] += (count[j] - 1) * stride[j];
#line 997
                        stride[j] = -stride[j];
#line 997
                    }
#line 997
                }
#line 997
*/
#line 997
                if (var_rank[i] > 0) {
#line 997
                    j = var_rank[i] - 1;
#line 997
                    imap[j] = 1;
#line 997
                    for (; j > 0; j--)
#line 997
                        imap[j-1] = imap[j] * count[j];
#line 997
                }
#line 997
                for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 997
                    err = toMixedBase(j, var_rank[i], count, index2);
#line 997
                    IF (err)
#line 997
                        error("error in toMixedBase");
#line 997
                    for (d = 0; d < var_rank[i]; d++)
#line 997
                        index2[d] = index[d] + index2[d] * stride[d];
#line 997
                    value[j] = hash_text(var_type[i], var_rank[i], index2,
#line 997
                        NCT_TEXT);
#line 997
                    allInExtRange = allInExtRange
#line 997
                        && inRange3(value[j], var_type[i], NCT_TEXT);
#line 997
                }
#line 997
                if (var_rank[i] == 0 && i%2 == 0)
#line 997
                    err = nc_put_varm_text(ncid,i,NULL,NULL,NULL,NULL,value);
#line 997
                else
#line 997
                    err = nc_put_varm_text(ncid,i,index,count,stride,imap,value);
#line 997
                if (canConvert) {
#line 997
                    if (allInExtRange) {
#line 997
                        IF (err)
#line 997
                            error("%s", nc_strerror(err));
#line 997
                    } else {
#line 997
                        IF (err != NC_ERANGE)
#line 997
                            error("range error: status = %d", err);
#line 997
                    }
#line 997
                } else {
#line 997
                    IF (nels > 0 && err != NC_ECHAR)
#line 997
                        error("wrong type: status = %d", err);
#line 997
		}
#line 997
	    }
#line 997
	}
#line 997
    }
#line 997

#line 997
    err = nc_close(ncid);
#line 997
    IF (err) 
#line 997
	error("nc_close: %s", nc_strerror(err));
#line 997

#line 997
    check_vars_text(scratch);
#line 997

#line 997
    err = remove(scratch);
#line 997
    IF (err)
#line 997
        error("remove of %s failed", scratch);
#line 997
}
#line 997

void
#line 998
test_nc_put_varm_uchar(void)
#line 998
{
#line 998
    int ncid;
#line 998
    int d;
#line 998
    int i;
#line 998
    int j;
#line 998
    int k;
#line 998
    int m;
#line 998
    int err;
#line 998
    int nels;
#line 998
    int nslabs;
#line 998
    int nstarts;        /* number of different starts */
#line 998
    size_t start[MAX_RANK];
#line 998
    size_t edge[MAX_RANK];
#line 998
    size_t index[MAX_RANK];
#line 998
    size_t index2[MAX_RANK];
#line 998
    size_t mid[MAX_RANK];
#line 998
    size_t count[MAX_RANK];
#line 998
    size_t sstride[MAX_RANK];
#line 998
    ptrdiff_t stride[MAX_RANK];
#line 998
    ptrdiff_t imap[MAX_RANK];
#line 998
    int canConvert;	/* Both text or both numeric */
#line 998
    int allInExtRange;	/* all values within external range? */
#line 998
    uchar value[MAX_NELS];
#line 998

#line 998
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 998
    IF (err) {
#line 998
	error("nc_create: %s", nc_strerror(err));
#line 998
	return;
#line 998
    }
#line 998
    def_dims(ncid);
#line 998
    def_vars(ncid);
#line 998
    err = nc_enddef(ncid);
#line 998
    IF (err)
#line 998
	error("nc_enddef: %s", nc_strerror(err));
#line 998

#line 998
    for (i = 0; i < NVARS; i++) {
#line 998
	canConvert = (var_type[i] == NC_CHAR) == (NCT_UCHAR == NCT_TEXT);
#line 998
	assert(var_rank[i] <= MAX_RANK);
#line 998
	assert(var_nels[i] <= MAX_NELS);
#line 998
	for (j = 0; j < var_rank[i]; j++) {
#line 998
	    start[j] = 0;
#line 998
	    edge[j] = 1;
#line 998
	    stride[j] = 1;
#line 998
	    imap[j] = 1;
#line 998
	}
#line 998
	err = nc_put_varm_uchar(BAD_ID, i, start, edge, stride, imap, value);
#line 998
	IF (err != NC_EBADID) 
#line 998
	    error("bad ncid: status = %d", err);
#line 998
	err = nc_put_varm_uchar(ncid, BAD_VARID, start, edge, stride, imap, value);
#line 998
	IF (err != NC_ENOTVAR) 
#line 998
	    error("bad var id: status = %d", err);
#line 998
	for (j = 0; j < var_rank[i]; j++) {
#line 998
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 998
		start[j] = var_shape[i][j] + 1;
#line 998
		err = nc_put_varm_uchar(ncid, i, start, edge, stride, imap, value);
#line 998
	      if (!canConvert) {
#line 998
		IF(err != NC_ECHAR)
#line 998
			error("conversion: status = %d", err);
#line 998
	      } else {
#line 998
		IF (err != NC_EINVALCOORDS)
#line 998
		    error("bad start: status = %d", err);
#line 998
		start[j] = 0;
#line 998
		edge[j] = var_shape[i][j] + 1;
#line 998
		err = nc_put_varm_uchar(ncid, i, start, edge, stride, imap, value);
#line 998
		IF (err != NC_EEDGE)
#line 998
		    error("bad edge: status = %d", err);
#line 998
		edge[j] = 1;
#line 998
		stride[j] = 0;
#line 998
		err = nc_put_varm_uchar(ncid, i, start, edge, stride, imap, value);
#line 998
		IF (err != NC_ESTRIDE)
#line 998
		    error("bad stride: status = %d", err);
#line 998
		stride[j] = 1;
#line 998
	      }
#line 998
	    }
#line 998
	}
#line 998
	    /* Choose a random point dividing each dim into 2 parts */
#line 998
	    /* Put 2^rank (nslabs) slabs so defined */
#line 998
	nslabs = 1;
#line 998
	for (j = 0; j < var_rank[i]; j++) {
#line 998
	    mid[j] = roll( var_shape[i][j] );
#line 998
	    nslabs *= 2;
#line 998
	}
#line 998
	    /* bits of k determine whether to put lower or upper part of dim */
#line 998
	    /* choose random stride from 1 to edge */
#line 998
	for (k = 0; k < nslabs; k++) {
#line 998
	    nstarts = 1;
#line 998
	    for (j = 0; j < var_rank[i]; j++) {
#line 998
		if ((k >> j) & 1) {
#line 998
		    start[j] = 0;
#line 998
		    edge[j] = mid[j];
#line 998
		}else{
#line 998
		    start[j] = mid[j];
#line 998
		    edge[j] = var_shape[i][j] - mid[j];
#line 998
		}
#line 998
		sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 998
		nstarts *= stride[j];
#line 998
	    }
#line 998
            for (m = 0; m < nstarts; m++) {
#line 998
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 998
                IF (err)
#line 998
                    error("error in toMixedBase");
#line 998
                nels = 1;
#line 998
                for (j = 0; j < var_rank[i]; j++) {
#line 998
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 998
                    nels *= count[j];
#line 998
                    index[j] += start[j];
#line 998
                }
#line 998
                    /* Random choice of forward or backward */
#line 998
/* TODO
#line 998
                if ( roll(2) ) {
#line 998
                    for (j = 0; j < var_rank[i]; j++) {
#line 998
                        index[j] += (count[j] - 1) * stride[j];
#line 998
                        stride[j] = -stride[j];
#line 998
                    }
#line 998
                }
#line 998
*/
#line 998
                if (var_rank[i] > 0) {
#line 998
                    j = var_rank[i] - 1;
#line 998
                    imap[j] = 1;
#line 998
                    for (; j > 0; j--)
#line 998
                        imap[j-1] = imap[j] * count[j];
#line 998
                }
#line 998
                for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 998
                    err = toMixedBase(j, var_rank[i], count, index2);
#line 998
                    IF (err)
#line 998
                        error("error in toMixedBase");
#line 998
                    for (d = 0; d < var_rank[i]; d++)
#line 998
                        index2[d] = index[d] + index2[d] * stride[d];
#line 998
                    value[j] = hash_uchar(var_type[i], var_rank[i], index2,
#line 998
                        NCT_UCHAR);
#line 998
                    allInExtRange = allInExtRange
#line 998
                        && inRange3(value[j], var_type[i], NCT_UCHAR);
#line 998
                }
#line 998
                if (var_rank[i] == 0 && i%2 == 0)
#line 998
                    err = nc_put_varm_uchar(ncid,i,NULL,NULL,NULL,NULL,value);
#line 998
                else
#line 998
                    err = nc_put_varm_uchar(ncid,i,index,count,stride,imap,value);
#line 998
                if (canConvert) {
#line 998
                    if (allInExtRange) {
#line 998
                        IF (err)
#line 998
                            error("%s", nc_strerror(err));
#line 998
                    } else {
#line 998
                        IF (err != NC_ERANGE)
#line 998
                            error("range error: status = %d", err);
#line 998
                    }
#line 998
                } else {
#line 998
                    IF (nels > 0 && err != NC_ECHAR)
#line 998
                        error("wrong type: status = %d", err);
#line 998
		}
#line 998
	    }
#line 998
	}
#line 998
    }
#line 998

#line 998
    err = nc_close(ncid);
#line 998
    IF (err) 
#line 998
	error("nc_close: %s", nc_strerror(err));
#line 998

#line 998
    check_vars_uchar(scratch);
#line 998

#line 998
    err = remove(scratch);
#line 998
    IF (err)
#line 998
        error("remove of %s failed", scratch);
#line 998
}
#line 998

void
#line 999
test_nc_put_varm_schar(void)
#line 999
{
#line 999
    int ncid;
#line 999
    int d;
#line 999
    int i;
#line 999
    int j;
#line 999
    int k;
#line 999
    int m;
#line 999
    int err;
#line 999
    int nels;
#line 999
    int nslabs;
#line 999
    int nstarts;        /* number of different starts */
#line 999
    size_t start[MAX_RANK];
#line 999
    size_t edge[MAX_RANK];
#line 999
    size_t index[MAX_RANK];
#line 999
    size_t index2[MAX_RANK];
#line 999
    size_t mid[MAX_RANK];
#line 999
    size_t count[MAX_RANK];
#line 999
    size_t sstride[MAX_RANK];
#line 999
    ptrdiff_t stride[MAX_RANK];
#line 999
    ptrdiff_t imap[MAX_RANK];
#line 999
    int canConvert;	/* Both text or both numeric */
#line 999
    int allInExtRange;	/* all values within external range? */
#line 999
    schar value[MAX_NELS];
#line 999

#line 999
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 999
    IF (err) {
#line 999
	error("nc_create: %s", nc_strerror(err));
#line 999
	return;
#line 999
    }
#line 999
    def_dims(ncid);
#line 999
    def_vars(ncid);
#line 999
    err = nc_enddef(ncid);
#line 999
    IF (err)
#line 999
	error("nc_enddef: %s", nc_strerror(err));
#line 999

#line 999
    for (i = 0; i < NVARS; i++) {
#line 999
	canConvert = (var_type[i] == NC_CHAR) == (NCT_SCHAR == NCT_TEXT);
#line 999
	assert(var_rank[i] <= MAX_RANK);
#line 999
	assert(var_nels[i] <= MAX_NELS);
#line 999
	for (j = 0; j < var_rank[i]; j++) {
#line 999
	    start[j] = 0;
#line 999
	    edge[j] = 1;
#line 999
	    stride[j] = 1;
#line 999
	    imap[j] = 1;
#line 999
	}
#line 999
	err = nc_put_varm_schar(BAD_ID, i, start, edge, stride, imap, value);
#line 999
	IF (err != NC_EBADID) 
#line 999
	    error("bad ncid: status = %d", err);
#line 999
	err = nc_put_varm_schar(ncid, BAD_VARID, start, edge, stride, imap, value);
#line 999
	IF (err != NC_ENOTVAR) 
#line 999
	    error("bad var id: status = %d", err);
#line 999
	for (j = 0; j < var_rank[i]; j++) {
#line 999
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 999
		start[j] = var_shape[i][j] + 1;
#line 999
		err = nc_put_varm_schar(ncid, i, start, edge, stride, imap, value);
#line 999
	      if (!canConvert) {
#line 999
		IF(err != NC_ECHAR)
#line 999
			error("conversion: status = %d", err);
#line 999
	      } else {
#line 999
		IF (err != NC_EINVALCOORDS)
#line 999
		    error("bad start: status = %d", err);
#line 999
		start[j] = 0;
#line 999
		edge[j] = var_shape[i][j] + 1;
#line 999
		err = nc_put_varm_schar(ncid, i, start, edge, stride, imap, value);
#line 999
		IF (err != NC_EEDGE)
#line 999
		    error("bad edge: status = %d", err);
#line 999
		edge[j] = 1;
#line 999
		stride[j] = 0;
#line 999
		err = nc_put_varm_schar(ncid, i, start, edge, stride, imap, value);
#line 999
		IF (err != NC_ESTRIDE)
#line 999
		    error("bad stride: status = %d", err);
#line 999
		stride[j] = 1;
#line 999
	      }
#line 999
	    }
#line 999
	}
#line 999
	    /* Choose a random point dividing each dim into 2 parts */
#line 999
	    /* Put 2^rank (nslabs) slabs so defined */
#line 999
	nslabs = 1;
#line 999
	for (j = 0; j < var_rank[i]; j++) {
#line 999
	    mid[j] = roll( var_shape[i][j] );
#line 999
	    nslabs *= 2;
#line 999
	}
#line 999
	    /* bits of k determine whether to put lower or upper part of dim */
#line 999
	    /* choose random stride from 1 to edge */
#line 999
	for (k = 0; k < nslabs; k++) {
#line 999
	    nstarts = 1;
#line 999
	    for (j = 0; j < var_rank[i]; j++) {
#line 999
		if ((k >> j) & 1) {
#line 999
		    start[j] = 0;
#line 999
		    edge[j] = mid[j];
#line 999
		}else{
#line 999
		    start[j] = mid[j];
#line 999
		    edge[j] = var_shape[i][j] - mid[j];
#line 999
		}
#line 999
		sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 999
		nstarts *= stride[j];
#line 999
	    }
#line 999
            for (m = 0; m < nstarts; m++) {
#line 999
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 999
                IF (err)
#line 999
                    error("error in toMixedBase");
#line 999
                nels = 1;
#line 999
                for (j = 0; j < var_rank[i]; j++) {
#line 999
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 999
                    nels *= count[j];
#line 999
                    index[j] += start[j];
#line 999
                }
#line 999
                    /* Random choice of forward or backward */
#line 999
/* TODO
#line 999
                if ( roll(2) ) {
#line 999
                    for (j = 0; j < var_rank[i]; j++) {
#line 999
                        index[j] += (count[j] - 1) * stride[j];
#line 999
                        stride[j] = -stride[j];
#line 999
                    }
#line 999
                }
#line 999
*/
#line 999
                if (var_rank[i] > 0) {
#line 999
                    j = var_rank[i] - 1;
#line 999
                    imap[j] = 1;
#line 999
                    for (; j > 0; j--)
#line 999
                        imap[j-1] = imap[j] * count[j];
#line 999
                }
#line 999
                for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 999
                    err = toMixedBase(j, var_rank[i], count, index2);
#line 999
                    IF (err)
#line 999
                        error("error in toMixedBase");
#line 999
                    for (d = 0; d < var_rank[i]; d++)
#line 999
                        index2[d] = index[d] + index2[d] * stride[d];
#line 999
                    value[j] = hash_schar(var_type[i], var_rank[i], index2,
#line 999
                        NCT_SCHAR);
#line 999
                    allInExtRange = allInExtRange
#line 999
                        && inRange3(value[j], var_type[i], NCT_SCHAR);
#line 999
                }
#line 999
                if (var_rank[i] == 0 && i%2 == 0)
#line 999
                    err = nc_put_varm_schar(ncid,i,NULL,NULL,NULL,NULL,value);
#line 999
                else
#line 999
                    err = nc_put_varm_schar(ncid,i,index,count,stride,imap,value);
#line 999
                if (canConvert) {
#line 999
                    if (allInExtRange) {
#line 999
                        IF (err)
#line 999
                            error("%s", nc_strerror(err));
#line 999
                    } else {
#line 999
                        IF (err != NC_ERANGE)
#line 999
                            error("range error: status = %d", err);
#line 999
                    }
#line 999
                } else {
#line 999
                    IF (nels > 0 && err != NC_ECHAR)
#line 999
                        error("wrong type: status = %d", err);
#line 999
		}
#line 999
	    }
#line 999
	}
#line 999
    }
#line 999

#line 999
    err = nc_close(ncid);
#line 999
    IF (err) 
#line 999
	error("nc_close: %s", nc_strerror(err));
#line 999

#line 999
    check_vars_schar(scratch);
#line 999

#line 999
    err = remove(scratch);
#line 999
    IF (err)
#line 999
        error("remove of %s failed", scratch);
#line 999
}
#line 999

void
#line 1000
test_nc_put_varm_short(void)
#line 1000
{
#line 1000
    int ncid;
#line 1000
    int d;
#line 1000
    int i;
#line 1000
    int j;
#line 1000
    int k;
#line 1000
    int m;
#line 1000
    int err;
#line 1000
    int nels;
#line 1000
    int nslabs;
#line 1000
    int nstarts;        /* number of different starts */
#line 1000
    size_t start[MAX_RANK];
#line 1000
    size_t edge[MAX_RANK];
#line 1000
    size_t index[MAX_RANK];
#line 1000
    size_t index2[MAX_RANK];
#line 1000
    size_t mid[MAX_RANK];
#line 1000
    size_t count[MAX_RANK];
#line 1000
    size_t sstride[MAX_RANK];
#line 1000
    ptrdiff_t stride[MAX_RANK];
#line 1000
    ptrdiff_t imap[MAX_RANK];
#line 1000
    int canConvert;	/* Both text or both numeric */
#line 1000
    int allInExtRange;	/* all values within external range? */
#line 1000
    short value[MAX_NELS];
#line 1000

#line 1000
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 1000
    IF (err) {
#line 1000
	error("nc_create: %s", nc_strerror(err));
#line 1000
	return;
#line 1000
    }
#line 1000
    def_dims(ncid);
#line 1000
    def_vars(ncid);
#line 1000
    err = nc_enddef(ncid);
#line 1000
    IF (err)
#line 1000
	error("nc_enddef: %s", nc_strerror(err));
#line 1000

#line 1000
    for (i = 0; i < NVARS; i++) {
#line 1000
	canConvert = (var_type[i] == NC_CHAR) == (NCT_SHORT == NCT_TEXT);
#line 1000
	assert(var_rank[i] <= MAX_RANK);
#line 1000
	assert(var_nels[i] <= MAX_NELS);
#line 1000
	for (j = 0; j < var_rank[i]; j++) {
#line 1000
	    start[j] = 0;
#line 1000
	    edge[j] = 1;
#line 1000
	    stride[j] = 1;
#line 1000
	    imap[j] = 1;
#line 1000
	}
#line 1000
	err = nc_put_varm_short(BAD_ID, i, start, edge, stride, imap, value);
#line 1000
	IF (err != NC_EBADID) 
#line 1000
	    error("bad ncid: status = %d", err);
#line 1000
	err = nc_put_varm_short(ncid, BAD_VARID, start, edge, stride, imap, value);
#line 1000
	IF (err != NC_ENOTVAR) 
#line 1000
	    error("bad var id: status = %d", err);
#line 1000
	for (j = 0; j < var_rank[i]; j++) {
#line 1000
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 1000
		start[j] = var_shape[i][j] + 1;
#line 1000
		err = nc_put_varm_short(ncid, i, start, edge, stride, imap, value);
#line 1000
	      if (!canConvert) {
#line 1000
		IF(err != NC_ECHAR)
#line 1000
			error("conversion: status = %d", err);
#line 1000
	      } else {
#line 1000
		IF (err != NC_EINVALCOORDS)
#line 1000
		    error("bad start: status = %d", err);
#line 1000
		start[j] = 0;
#line 1000
		edge[j] = var_shape[i][j] + 1;
#line 1000
		err = nc_put_varm_short(ncid, i, start, edge, stride, imap, value);
#line 1000
		IF (err != NC_EEDGE)
#line 1000
		    error("bad edge: status = %d", err);
#line 1000
		edge[j] = 1;
#line 1000
		stride[j] = 0;
#line 1000
		err = nc_put_varm_short(ncid, i, start, edge, stride, imap, value);
#line 1000
		IF (err != NC_ESTRIDE)
#line 1000
		    error("bad stride: status = %d", err);
#line 1000
		stride[j] = 1;
#line 1000
	      }
#line 1000
	    }
#line 1000
	}
#line 1000
	    /* Choose a random point dividing each dim into 2 parts */
#line 1000
	    /* Put 2^rank (nslabs) slabs so defined */
#line 1000
	nslabs = 1;
#line 1000
	for (j = 0; j < var_rank[i]; j++) {
#line 1000
	    mid[j] = roll( var_shape[i][j] );
#line 1000
	    nslabs *= 2;
#line 1000
	}
#line 1000
	    /* bits of k determine whether to put lower or upper part of dim */
#line 1000
	    /* choose random stride from 1 to edge */
#line 1000
	for (k = 0; k < nslabs; k++) {
#line 1000
	    nstarts = 1;
#line 1000
	    for (j = 0; j < var_rank[i]; j++) {
#line 1000
		if ((k >> j) & 1) {
#line 1000
		    start[j] = 0;
#line 1000
		    edge[j] = mid[j];
#line 1000
		}else{
#line 1000
		    start[j] = mid[j];
#line 1000
		    edge[j] = var_shape[i][j] - mid[j];
#line 1000
		}
#line 1000
		sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 1000
		nstarts *= stride[j];
#line 1000
	    }
#line 1000
            for (m = 0; m < nstarts; m++) {
#line 1000
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 1000
                IF (err)
#line 1000
                    error("error in toMixedBase");
#line 1000
                nels = 1;
#line 1000
                for (j = 0; j < var_rank[i]; j++) {
#line 1000
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 1000
                    nels *= count[j];
#line 1000
                    index[j] += start[j];
#line 1000
                }
#line 1000
                    /* Random choice of forward or backward */
#line 1000
/* TODO
#line 1000
                if ( roll(2) ) {
#line 1000
                    for (j = 0; j < var_rank[i]; j++) {
#line 1000
                        index[j] += (count[j] - 1) * stride[j];
#line 1000
                        stride[j] = -stride[j];
#line 1000
                    }
#line 1000
                }
#line 1000
*/
#line 1000
                if (var_rank[i] > 0) {
#line 1000
                    j = var_rank[i] - 1;
#line 1000
                    imap[j] = 1;
#line 1000
                    for (; j > 0; j--)
#line 1000
                        imap[j-1] = imap[j] * count[j];
#line 1000
                }
#line 1000
                for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 1000
                    err = toMixedBase(j, var_rank[i], count, index2);
#line 1000
                    IF (err)
#line 1000
                        error("error in toMixedBase");
#line 1000
                    for (d = 0; d < var_rank[i]; d++)
#line 1000
                        index2[d] = index[d] + index2[d] * stride[d];
#line 1000
                    value[j] = hash_short(var_type[i], var_rank[i], index2,
#line 1000
                        NCT_SHORT);
#line 1000
                    allInExtRange = allInExtRange
#line 1000
                        && inRange3(value[j], var_type[i], NCT_SHORT);
#line 1000
                }
#line 1000
                if (var_rank[i] == 0 && i%2 == 0)
#line 1000
                    err = nc_put_varm_short(ncid,i,NULL,NULL,NULL,NULL,value);
#line 1000
                else
#line 1000
                    err = nc_put_varm_short(ncid,i,index,count,stride,imap,value);
#line 1000
                if (canConvert) {
#line 1000
                    if (allInExtRange) {
#line 1000
                        IF (err)
#line 1000
                            error("%s", nc_strerror(err));
#line 1000
                    } else {
#line 1000
                        IF (err != NC_ERANGE)
#line 1000
                            error("range error: status = %d", err);
#line 1000
                    }
#line 1000
                } else {
#line 1000
                    IF (nels > 0 && err != NC_ECHAR)
#line 1000
                        error("wrong type: status = %d", err);
#line 1000
		}
#line 1000
	    }
#line 1000
	}
#line 1000
    }
#line 1000

#line 1000
    err = nc_close(ncid);
#line 1000
    IF (err) 
#line 1000
	error("nc_close: %s", nc_strerror(err));
#line 1000

#line 1000
    check_vars_short(scratch);
#line 1000

#line 1000
    err = remove(scratch);
#line 1000
    IF (err)
#line 1000
        error("remove of %s failed", scratch);
#line 1000
}
#line 1000

void
#line 1001
test_nc_put_varm_int(void)
#line 1001
{
#line 1001
    int ncid;
#line 1001
    int d;
#line 1001
    int i;
#line 1001
    int j;
#line 1001
    int k;
#line 1001
    int m;
#line 1001
    int err;
#line 1001
    int nels;
#line 1001
    int nslabs;
#line 1001
    int nstarts;        /* number of different starts */
#line 1001
    size_t start[MAX_RANK];
#line 1001
    size_t edge[MAX_RANK];
#line 1001
    size_t index[MAX_RANK];
#line 1001
    size_t index2[MAX_RANK];
#line 1001
    size_t mid[MAX_RANK];
#line 1001
    size_t count[MAX_RANK];
#line 1001
    size_t sstride[MAX_RANK];
#line 1001
    ptrdiff_t stride[MAX_RANK];
#line 1001
    ptrdiff_t imap[MAX_RANK];
#line 1001
    int canConvert;	/* Both text or both numeric */
#line 1001
    int allInExtRange;	/* all values within external range? */
#line 1001
    int value[MAX_NELS];
#line 1001

#line 1001
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 1001
    IF (err) {
#line 1001
	error("nc_create: %s", nc_strerror(err));
#line 1001
	return;
#line 1001
    }
#line 1001
    def_dims(ncid);
#line 1001
    def_vars(ncid);
#line 1001
    err = nc_enddef(ncid);
#line 1001
    IF (err)
#line 1001
	error("nc_enddef: %s", nc_strerror(err));
#line 1001

#line 1001
    for (i = 0; i < NVARS; i++) {
#line 1001
	canConvert = (var_type[i] == NC_CHAR) == (NCT_INT == NCT_TEXT);
#line 1001
	assert(var_rank[i] <= MAX_RANK);
#line 1001
	assert(var_nels[i] <= MAX_NELS);
#line 1001
	for (j = 0; j < var_rank[i]; j++) {
#line 1001
	    start[j] = 0;
#line 1001
	    edge[j] = 1;
#line 1001
	    stride[j] = 1;
#line 1001
	    imap[j] = 1;
#line 1001
	}
#line 1001
	err = nc_put_varm_int(BAD_ID, i, start, edge, stride, imap, value);
#line 1001
	IF (err != NC_EBADID) 
#line 1001
	    error("bad ncid: status = %d", err);
#line 1001
	err = nc_put_varm_int(ncid, BAD_VARID, start, edge, stride, imap, value);
#line 1001
	IF (err != NC_ENOTVAR) 
#line 1001
	    error("bad var id: status = %d", err);
#line 1001
	for (j = 0; j < var_rank[i]; j++) {
#line 1001
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 1001
		start[j] = var_shape[i][j] + 1;
#line 1001
		err = nc_put_varm_int(ncid, i, start, edge, stride, imap, value);
#line 1001
	      if (!canConvert) {
#line 1001
		IF(err != NC_ECHAR)
#line 1001
			error("conversion: status = %d", err);
#line 1001
	      } else {
#line 1001
		IF (err != NC_EINVALCOORDS)
#line 1001
		    error("bad start: status = %d", err);
#line 1001
		start[j] = 0;
#line 1001
		edge[j] = var_shape[i][j] + 1;
#line 1001
		err = nc_put_varm_int(ncid, i, start, edge, stride, imap, value);
#line 1001
		IF (err != NC_EEDGE)
#line 1001
		    error("bad edge: status = %d", err);
#line 1001
		edge[j] = 1;
#line 1001
		stride[j] = 0;
#line 1001
		err = nc_put_varm_int(ncid, i, start, edge, stride, imap, value);
#line 1001
		IF (err != NC_ESTRIDE)
#line 1001
		    error("bad stride: status = %d", err);
#line 1001
		stride[j] = 1;
#line 1001
	      }
#line 1001
	    }
#line 1001
	}
#line 1001
	    /* Choose a random point dividing each dim into 2 parts */
#line 1001
	    /* Put 2^rank (nslabs) slabs so defined */
#line 1001
	nslabs = 1;
#line 1001
	for (j = 0; j < var_rank[i]; j++) {
#line 1001
	    mid[j] = roll( var_shape[i][j] );
#line 1001
	    nslabs *= 2;
#line 1001
	}
#line 1001
	    /* bits of k determine whether to put lower or upper part of dim */
#line 1001
	    /* choose random stride from 1 to edge */
#line 1001
	for (k = 0; k < nslabs; k++) {
#line 1001
	    nstarts = 1;
#line 1001
	    for (j = 0; j < var_rank[i]; j++) {
#line 1001
		if ((k >> j) & 1) {
#line 1001
		    start[j] = 0;
#line 1001
		    edge[j] = mid[j];
#line 1001
		}else{
#line 1001
		    start[j] = mid[j];
#line 1001
		    edge[j] = var_shape[i][j] - mid[j];
#line 1001
		}
#line 1001
		sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 1001
		nstarts *= stride[j];
#line 1001
	    }
#line 1001
            for (m = 0; m < nstarts; m++) {
#line 1001
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 1001
                IF (err)
#line 1001
                    error("error in toMixedBase");
#line 1001
                nels = 1;
#line 1001
                for (j = 0; j < var_rank[i]; j++) {
#line 1001
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 1001
                    nels *= count[j];
#line 1001
                    index[j] += start[j];
#line 1001
                }
#line 1001
                    /* Random choice of forward or backward */
#line 1001
/* TODO
#line 1001
                if ( roll(2) ) {
#line 1001
                    for (j = 0; j < var_rank[i]; j++) {
#line 1001
                        index[j] += (count[j] - 1) * stride[j];
#line 1001
                        stride[j] = -stride[j];
#line 1001
                    }
#line 1001
                }
#line 1001
*/
#line 1001
                if (var_rank[i] > 0) {
#line 1001
                    j = var_rank[i] - 1;
#line 1001
                    imap[j] = 1;
#line 1001
                    for (; j > 0; j--)
#line 1001
                        imap[j-1] = imap[j] * count[j];
#line 1001
                }
#line 1001
                for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 1001
                    err = toMixedBase(j, var_rank[i], count, index2);
#line 1001
                    IF (err)
#line 1001
                        error("error in toMixedBase");
#line 1001
                    for (d = 0; d < var_rank[i]; d++)
#line 1001
                        index2[d] = index[d] + index2[d] * stride[d];
#line 1001
                    value[j] = hash_int(var_type[i], var_rank[i], index2,
#line 1001
                        NCT_INT);
#line 1001
                    allInExtRange = allInExtRange
#line 1001
                        && inRange3(value[j], var_type[i], NCT_INT);
#line 1001
                }
#line 1001
                if (var_rank[i] == 0 && i%2 == 0)
#line 1001
                    err = nc_put_varm_int(ncid,i,NULL,NULL,NULL,NULL,value);
#line 1001
                else
#line 1001
                    err = nc_put_varm_int(ncid,i,index,count,stride,imap,value);
#line 1001
                if (canConvert) {
#line 1001
                    if (allInExtRange) {
#line 1001
                        IF (err)
#line 1001
                            error("%s", nc_strerror(err));
#line 1001
                    } else {
#line 1001
                        IF (err != NC_ERANGE)
#line 1001
                            error("range error: status = %d", err);
#line 1001
                    }
#line 1001
                } else {
#line 1001
                    IF (nels > 0 && err != NC_ECHAR)
#line 1001
                        error("wrong type: status = %d", err);
#line 1001
		}
#line 1001
	    }
#line 1001
	}
#line 1001
    }
#line 1001

#line 1001
    err = nc_close(ncid);
#line 1001
    IF (err) 
#line 1001
	error("nc_close: %s", nc_strerror(err));
#line 1001

#line 1001
    check_vars_int(scratch);
#line 1001

#line 1001
    err = remove(scratch);
#line 1001
    IF (err)
#line 1001
        error("remove of %s failed", scratch);
#line 1001
}
#line 1001

void
#line 1002
test_nc_put_varm_long(void)
#line 1002
{
#line 1002
    int ncid;
#line 1002
    int d;
#line 1002
    int i;
#line 1002
    int j;
#line 1002
    int k;
#line 1002
    int m;
#line 1002
    int err;
#line 1002
    int nels;
#line 1002
    int nslabs;
#line 1002
    int nstarts;        /* number of different starts */
#line 1002
    size_t start[MAX_RANK];
#line 1002
    size_t edge[MAX_RANK];
#line 1002
    size_t index[MAX_RANK];
#line 1002
    size_t index2[MAX_RANK];
#line 1002
    size_t mid[MAX_RANK];
#line 1002
    size_t count[MAX_RANK];
#line 1002
    size_t sstride[MAX_RANK];
#line 1002
    ptrdiff_t stride[MAX_RANK];
#line 1002
    ptrdiff_t imap[MAX_RANK];
#line 1002
    int canConvert;	/* Both text or both numeric */
#line 1002
    int allInExtRange;	/* all values within external range? */
#line 1002
    long value[MAX_NELS];
#line 1002

#line 1002
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 1002
    IF (err) {
#line 1002
	error("nc_create: %s", nc_strerror(err));
#line 1002
	return;
#line 1002
    }
#line 1002
    def_dims(ncid);
#line 1002
    def_vars(ncid);
#line 1002
    err = nc_enddef(ncid);
#line 1002
    IF (err)
#line 1002
	error("nc_enddef: %s", nc_strerror(err));
#line 1002

#line 1002
    for (i = 0; i < NVARS; i++) {
#line 1002
	canConvert = (var_type[i] == NC_CHAR) == (NCT_LONG == NCT_TEXT);
#line 1002
	assert(var_rank[i] <= MAX_RANK);
#line 1002
	assert(var_nels[i] <= MAX_NELS);
#line 1002
	for (j = 0; j < var_rank[i]; j++) {
#line 1002
	    start[j] = 0;
#line 1002
	    edge[j] = 1;
#line 1002
	    stride[j] = 1;
#line 1002
	    imap[j] = 1;
#line 1002
	}
#line 1002
	err = nc_put_varm_long(BAD_ID, i, start, edge, stride, imap, value);
#line 1002
	IF (err != NC_EBADID) 
#line 1002
	    error("bad ncid: status = %d", err);
#line 1002
	err = nc_put_varm_long(ncid, BAD_VARID, start, edge, stride, imap, value);
#line 1002
	IF (err != NC_ENOTVAR) 
#line 1002
	    error("bad var id: status = %d", err);
#line 1002
	for (j = 0; j < var_rank[i]; j++) {
#line 1002
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 1002
		start[j] = var_shape[i][j] + 1;
#line 1002
		err = nc_put_varm_long(ncid, i, start, edge, stride, imap, value);
#line 1002
	      if (!canConvert) {
#line 1002
		IF(err != NC_ECHAR)
#line 1002
			error("conversion: status = %d", err);
#line 1002
	      } else {
#line 1002
		IF (err != NC_EINVALCOORDS)
#line 1002
		    error("bad start: status = %d", err);
#line 1002
		start[j] = 0;
#line 1002
		edge[j] = var_shape[i][j] + 1;
#line 1002
		err = nc_put_varm_long(ncid, i, start, edge, stride, imap, value);
#line 1002
		IF (err != NC_EEDGE)
#line 1002
		    error("bad edge: status = %d", err);
#line 1002
		edge[j] = 1;
#line 1002
		stride[j] = 0;
#line 1002
		err = nc_put_varm_long(ncid, i, start, edge, stride, imap, value);
#line 1002
		IF (err != NC_ESTRIDE)
#line 1002
		    error("bad stride: status = %d", err);
#line 1002
		stride[j] = 1;
#line 1002
	      }
#line 1002
	    }
#line 1002
	}
#line 1002
	    /* Choose a random point dividing each dim into 2 parts */
#line 1002
	    /* Put 2^rank (nslabs) slabs so defined */
#line 1002
	nslabs = 1;
#line 1002
	for (j = 0; j < var_rank[i]; j++) {
#line 1002
	    mid[j] = roll( var_shape[i][j] );
#line 1002
	    nslabs *= 2;
#line 1002
	}
#line 1002
	    /* bits of k determine whether to put lower or upper part of dim */
#line 1002
	    /* choose random stride from 1 to edge */
#line 1002
	for (k = 0; k < nslabs; k++) {
#line 1002
	    nstarts = 1;
#line 1002
	    for (j = 0; j < var_rank[i]; j++) {
#line 1002
		if ((k >> j) & 1) {
#line 1002
		    start[j] = 0;
#line 1002
		    edge[j] = mid[j];
#line 1002
		}else{
#line 1002
		    start[j] = mid[j];
#line 1002
		    edge[j] = var_shape[i][j] - mid[j];
#line 1002
		}
#line 1002
		sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 1002
		nstarts *= stride[j];
#line 1002
	    }
#line 1002
            for (m = 0; m < nstarts; m++) {
#line 1002
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 1002
                IF (err)
#line 1002
                    error("error in toMixedBase");
#line 1002
                nels = 1;
#line 1002
                for (j = 0; j < var_rank[i]; j++) {
#line 1002
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 1002
                    nels *= count[j];
#line 1002
                    index[j] += start[j];
#line 1002
                }
#line 1002
                    /* Random choice of forward or backward */
#line 1002
/* TODO
#line 1002
                if ( roll(2) ) {
#line 1002
                    for (j = 0; j < var_rank[i]; j++) {
#line 1002
                        index[j] += (count[j] - 1) * stride[j];
#line 1002
                        stride[j] = -stride[j];
#line 1002
                    }
#line 1002
                }
#line 1002
*/
#line 1002
                if (var_rank[i] > 0) {
#line 1002
                    j = var_rank[i] - 1;
#line 1002
                    imap[j] = 1;
#line 1002
                    for (; j > 0; j--)
#line 1002
                        imap[j-1] = imap[j] * count[j];
#line 1002
                }
#line 1002
                for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 1002
                    err = toMixedBase(j, var_rank[i], count, index2);
#line 1002
                    IF (err)
#line 1002
                        error("error in toMixedBase");
#line 1002
                    for (d = 0; d < var_rank[i]; d++)
#line 1002
                        index2[d] = index[d] + index2[d] * stride[d];
#line 1002
                    value[j] = hash_long(var_type[i], var_rank[i], index2,
#line 1002
                        NCT_LONG);
#line 1002
                    allInExtRange = allInExtRange
#line 1002
                        && inRange3(value[j], var_type[i], NCT_LONG);
#line 1002
                }
#line 1002
                if (var_rank[i] == 0 && i%2 == 0)
#line 1002
                    err = nc_put_varm_long(ncid,i,NULL,NULL,NULL,NULL,value);
#line 1002
                else
#line 1002
                    err = nc_put_varm_long(ncid,i,index,count,stride,imap,value);
#line 1002
                if (canConvert) {
#line 1002
                    if (allInExtRange) {
#line 1002
                        IF (err)
#line 1002
                            error("%s", nc_strerror(err));
#line 1002
                    } else {
#line 1002
                        IF (err != NC_ERANGE)
#line 1002
                            error("range error: status = %d", err);
#line 1002
                    }
#line 1002
                } else {
#line 1002
                    IF (nels > 0 && err != NC_ECHAR)
#line 1002
                        error("wrong type: status = %d", err);
#line 1002
		}
#line 1002
	    }
#line 1002
	}
#line 1002
    }
#line 1002

#line 1002
    err = nc_close(ncid);
#line 1002
    IF (err) 
#line 1002
	error("nc_close: %s", nc_strerror(err));
#line 1002

#line 1002
    check_vars_long(scratch);
#line 1002

#line 1002
    err = remove(scratch);
#line 1002
    IF (err)
#line 1002
        error("remove of %s failed", scratch);
#line 1002
}
#line 1002

void
#line 1003
test_nc_put_varm_float(void)
#line 1003
{
#line 1003
    int ncid;
#line 1003
    int d;
#line 1003
    int i;
#line 1003
    int j;
#line 1003
    int k;
#line 1003
    int m;
#line 1003
    int err;
#line 1003
    int nels;
#line 1003
    int nslabs;
#line 1003
    int nstarts;        /* number of different starts */
#line 1003
    size_t start[MAX_RANK];
#line 1003
    size_t edge[MAX_RANK];
#line 1003
    size_t index[MAX_RANK];
#line 1003
    size_t index2[MAX_RANK];
#line 1003
    size_t mid[MAX_RANK];
#line 1003
    size_t count[MAX_RANK];
#line 1003
    size_t sstride[MAX_RANK];
#line 1003
    ptrdiff_t stride[MAX_RANK];
#line 1003
    ptrdiff_t imap[MAX_RANK];
#line 1003
    int canConvert;	/* Both text or both numeric */
#line 1003
    int allInExtRange;	/* all values within external range? */
#line 1003
    float value[MAX_NELS];
#line 1003

#line 1003
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 1003
    IF (err) {
#line 1003
	error("nc_create: %s", nc_strerror(err));
#line 1003
	return;
#line 1003
    }
#line 1003
    def_dims(ncid);
#line 1003
    def_vars(ncid);
#line 1003
    err = nc_enddef(ncid);
#line 1003
    IF (err)
#line 1003
	error("nc_enddef: %s", nc_strerror(err));
#line 1003

#line 1003
    for (i = 0; i < NVARS; i++) {
#line 1003
	canConvert = (var_type[i] == NC_CHAR) == (NCT_FLOAT == NCT_TEXT);
#line 1003
	assert(var_rank[i] <= MAX_RANK);
#line 1003
	assert(var_nels[i] <= MAX_NELS);
#line 1003
	for (j = 0; j < var_rank[i]; j++) {
#line 1003
	    start[j] = 0;
#line 1003
	    edge[j] = 1;
#line 1003
	    stride[j] = 1;
#line 1003
	    imap[j] = 1;
#line 1003
	}
#line 1003
	err = nc_put_varm_float(BAD_ID, i, start, edge, stride, imap, value);
#line 1003
	IF (err != NC_EBADID) 
#line 1003
	    error("bad ncid: status = %d", err);
#line 1003
	err = nc_put_varm_float(ncid, BAD_VARID, start, edge, stride, imap, value);
#line 1003
	IF (err != NC_ENOTVAR) 
#line 1003
	    error("bad var id: status = %d", err);
#line 1003
	for (j = 0; j < var_rank[i]; j++) {
#line 1003
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 1003
		start[j] = var_shape[i][j] + 1;
#line 1003
		err = nc_put_varm_float(ncid, i, start, edge, stride, imap, value);
#line 1003
	      if (!canConvert) {
#line 1003
		IF(err != NC_ECHAR)
#line 1003
			error("conversion: status = %d", err);
#line 1003
	      } else {
#line 1003
		IF (err != NC_EINVALCOORDS)
#line 1003
		    error("bad start: status = %d", err);
#line 1003
		start[j] = 0;
#line 1003
		edge[j] = var_shape[i][j] + 1;
#line 1003
		err = nc_put_varm_float(ncid, i, start, edge, stride, imap, value);
#line 1003
		IF (err != NC_EEDGE)
#line 1003
		    error("bad edge: status = %d", err);
#line 1003
		edge[j] = 1;
#line 1003
		stride[j] = 0;
#line 1003
		err = nc_put_varm_float(ncid, i, start, edge, stride, imap, value);
#line 1003
		IF (err != NC_ESTRIDE)
#line 1003
		    error("bad stride: status = %d", err);
#line 1003
		stride[j] = 1;
#line 1003
	      }
#line 1003
	    }
#line 1003
	}
#line 1003
	    /* Choose a random point dividing each dim into 2 parts */
#line 1003
	    /* Put 2^rank (nslabs) slabs so defined */
#line 1003
	nslabs = 1;
#line 1003
	for (j = 0; j < var_rank[i]; j++) {
#line 1003
	    mid[j] = roll( var_shape[i][j] );
#line 1003
	    nslabs *= 2;
#line 1003
	}
#line 1003
	    /* bits of k determine whether to put lower or upper part of dim */
#line 1003
	    /* choose random stride from 1 to edge */
#line 1003
	for (k = 0; k < nslabs; k++) {
#line 1003
	    nstarts = 1;
#line 1003
	    for (j = 0; j < var_rank[i]; j++) {
#line 1003
		if ((k >> j) & 1) {
#line 1003
		    start[j] = 0;
#line 1003
		    edge[j] = mid[j];
#line 1003
		}else{
#line 1003
		    start[j] = mid[j];
#line 1003
		    edge[j] = var_shape[i][j] - mid[j];
#line 1003
		}
#line 1003
		sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 1003
		nstarts *= stride[j];
#line 1003
	    }
#line 1003
            for (m = 0; m < nstarts; m++) {
#line 1003
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 1003
                IF (err)
#line 1003
                    error("error in toMixedBase");
#line 1003
                nels = 1;
#line 1003
                for (j = 0; j < var_rank[i]; j++) {
#line 1003
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 1003
                    nels *= count[j];
#line 1003
                    index[j] += start[j];
#line 1003
                }
#line 1003
                    /* Random choice of forward or backward */
#line 1003
/* TODO
#line 1003
                if ( roll(2) ) {
#line 1003
                    for (j = 0; j < var_rank[i]; j++) {
#line 1003
                        index[j] += (count[j] - 1) * stride[j];
#line 1003
                        stride[j] = -stride[j];
#line 1003
                    }
#line 1003
                }
#line 1003
*/
#line 1003
                if (var_rank[i] > 0) {
#line 1003
                    j = var_rank[i] - 1;
#line 1003
                    imap[j] = 1;
#line 1003
                    for (; j > 0; j--)
#line 1003
                        imap[j-1] = imap[j] * count[j];
#line 1003
                }
#line 1003
                for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 1003
                    err = toMixedBase(j, var_rank[i], count, index2);
#line 1003
                    IF (err)
#line 1003
                        error("error in toMixedBase");
#line 1003
                    for (d = 0; d < var_rank[i]; d++)
#line 1003
                        index2[d] = index[d] + index2[d] * stride[d];
#line 1003
                    value[j] = hash_float(var_type[i], var_rank[i], index2,
#line 1003
                        NCT_FLOAT);
#line 1003
                    allInExtRange = allInExtRange
#line 1003
                        && inRange3(value[j], var_type[i], NCT_FLOAT);
#line 1003
                }
#line 1003
                if (var_rank[i] == 0 && i%2 == 0)
#line 1003
                    err = nc_put_varm_float(ncid,i,NULL,NULL,NULL,NULL,value);
#line 1003
                else
#line 1003
                    err = nc_put_varm_float(ncid,i,index,count,stride,imap,value);
#line 1003
                if (canConvert) {
#line 1003
                    if (allInExtRange) {
#line 1003
                        IF (err)
#line 1003
                            error("%s", nc_strerror(err));
#line 1003
                    } else {
#line 1003
                        IF (err != NC_ERANGE)
#line 1003
                            error("range error: status = %d", err);
#line 1003
                    }
#line 1003
                } else {
#line 1003
                    IF (nels > 0 && err != NC_ECHAR)
#line 1003
                        error("wrong type: status = %d", err);
#line 1003
		}
#line 1003
	    }
#line 1003
	}
#line 1003
    }
#line 1003

#line 1003
    err = nc_close(ncid);
#line 1003
    IF (err) 
#line 1003
	error("nc_close: %s", nc_strerror(err));
#line 1003

#line 1003
    check_vars_float(scratch);
#line 1003

#line 1003
    err = remove(scratch);
#line 1003
    IF (err)
#line 1003
        error("remove of %s failed", scratch);
#line 1003
}
#line 1003

void
#line 1004
test_nc_put_varm_double(void)
#line 1004
{
#line 1004
    int ncid;
#line 1004
    int d;
#line 1004
    int i;
#line 1004
    int j;
#line 1004
    int k;
#line 1004
    int m;
#line 1004
    int err;
#line 1004
    int nels;
#line 1004
    int nslabs;
#line 1004
    int nstarts;        /* number of different starts */
#line 1004
    size_t start[MAX_RANK];
#line 1004
    size_t edge[MAX_RANK];
#line 1004
    size_t index[MAX_RANK];
#line 1004
    size_t index2[MAX_RANK];
#line 1004
    size_t mid[MAX_RANK];
#line 1004
    size_t count[MAX_RANK];
#line 1004
    size_t sstride[MAX_RANK];
#line 1004
    ptrdiff_t stride[MAX_RANK];
#line 1004
    ptrdiff_t imap[MAX_RANK];
#line 1004
    int canConvert;	/* Both text or both numeric */
#line 1004
    int allInExtRange;	/* all values within external range? */
#line 1004
    double value[MAX_NELS];
#line 1004

#line 1004
    err = nc_create(scratch, NC_CLOBBER, &ncid);
#line 1004
    IF (err) {
#line 1004
	error("nc_create: %s", nc_strerror(err));
#line 1004
	return;
#line 1004
    }
#line 1004
    def_dims(ncid);
#line 1004
    def_vars(ncid);
#line 1004
    err = nc_enddef(ncid);
#line 1004
    IF (err)
#line 1004
	error("nc_enddef: %s", nc_strerror(err));
#line 1004

#line 1004
    for (i = 0; i < NVARS; i++) {
#line 1004
	canConvert = (var_type[i] == NC_CHAR) == (NCT_DOUBLE == NCT_TEXT);
#line 1004
	assert(var_rank[i] <= MAX_RANK);
#line 1004
	assert(var_nels[i] <= MAX_NELS);
#line 1004
	for (j = 0; j < var_rank[i]; j++) {
#line 1004
	    start[j] = 0;
#line 1004
	    edge[j] = 1;
#line 1004
	    stride[j] = 1;
#line 1004
	    imap[j] = 1;
#line 1004
	}
#line 1004
	err = nc_put_varm_double(BAD_ID, i, start, edge, stride, imap, value);
#line 1004
	IF (err != NC_EBADID) 
#line 1004
	    error("bad ncid: status = %d", err);
#line 1004
	err = nc_put_varm_double(ncid, BAD_VARID, start, edge, stride, imap, value);
#line 1004
	IF (err != NC_ENOTVAR) 
#line 1004
	    error("bad var id: status = %d", err);
#line 1004
	for (j = 0; j < var_rank[i]; j++) {
#line 1004
	    if (var_dimid[i][j] > 0) {		/* skip record dim */
#line 1004
		start[j] = var_shape[i][j] + 1;
#line 1004
		err = nc_put_varm_double(ncid, i, start, edge, stride, imap, value);
#line 1004
	      if (!canConvert) {
#line 1004
		IF(err != NC_ECHAR)
#line 1004
			error("conversion: status = %d", err);
#line 1004
	      } else {
#line 1004
		IF (err != NC_EINVALCOORDS)
#line 1004
		    error("bad start: status = %d", err);
#line 1004
		start[j] = 0;
#line 1004
		edge[j] = var_shape[i][j] + 1;
#line 1004
		err = nc_put_varm_double(ncid, i, start, edge, stride, imap, value);
#line 1004
		IF (err != NC_EEDGE)
#line 1004
		    error("bad edge: status = %d", err);
#line 1004
		edge[j] = 1;
#line 1004
		stride[j] = 0;
#line 1004
		err = nc_put_varm_double(ncid, i, start, edge, stride, imap, value);
#line 1004
		IF (err != NC_ESTRIDE)
#line 1004
		    error("bad stride: status = %d", err);
#line 1004
		stride[j] = 1;
#line 1004
	      }
#line 1004
	    }
#line 1004
	}
#line 1004
	    /* Choose a random point dividing each dim into 2 parts */
#line 1004
	    /* Put 2^rank (nslabs) slabs so defined */
#line 1004
	nslabs = 1;
#line 1004
	for (j = 0; j < var_rank[i]; j++) {
#line 1004
	    mid[j] = roll( var_shape[i][j] );
#line 1004
	    nslabs *= 2;
#line 1004
	}
#line 1004
	    /* bits of k determine whether to put lower or upper part of dim */
#line 1004
	    /* choose random stride from 1 to edge */
#line 1004
	for (k = 0; k < nslabs; k++) {
#line 1004
	    nstarts = 1;
#line 1004
	    for (j = 0; j < var_rank[i]; j++) {
#line 1004
		if ((k >> j) & 1) {
#line 1004
		    start[j] = 0;
#line 1004
		    edge[j] = mid[j];
#line 1004
		}else{
#line 1004
		    start[j] = mid[j];
#line 1004
		    edge[j] = var_shape[i][j] - mid[j];
#line 1004
		}
#line 1004
		sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
#line 1004
		nstarts *= stride[j];
#line 1004
	    }
#line 1004
            for (m = 0; m < nstarts; m++) {
#line 1004
                err = toMixedBase(m, var_rank[i], sstride, index);
#line 1004
                IF (err)
#line 1004
                    error("error in toMixedBase");
#line 1004
                nels = 1;
#line 1004
                for (j = 0; j < var_rank[i]; j++) {
#line 1004
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
#line 1004
                    nels *= count[j];
#line 1004
                    index[j] += start[j];
#line 1004
                }
#line 1004
                    /* Random choice of forward or backward */
#line 1004
/* TODO
#line 1004
                if ( roll(2) ) {
#line 1004
                    for (j = 0; j < var_rank[i]; j++) {
#line 1004
                        index[j] += (count[j] - 1) * stride[j];
#line 1004
                        stride[j] = -stride[j];
#line 1004
                    }
#line 1004
                }
#line 1004
*/
#line 1004
                if (var_rank[i] > 0) {
#line 1004
                    j = var_rank[i] - 1;
#line 1004
                    imap[j] = 1;
#line 1004
                    for (; j > 0; j--)
#line 1004
                        imap[j-1] = imap[j] * count[j];
#line 1004
                }
#line 1004
                for (allInExtRange = 1, j = 0; j < nels; j++) {
#line 1004
                    err = toMixedBase(j, var_rank[i], count, index2);
#line 1004
                    IF (err)
#line 1004
                        error("error in toMixedBase");
#line 1004
                    for (d = 0; d < var_rank[i]; d++)
#line 1004
                        index2[d] = index[d] + index2[d] * stride[d];
#line 1004
                    value[j] = hash_double(var_type[i], var_rank[i], index2,
#line 1004
                        NCT_DOUBLE);
#line 1004
                    allInExtRange = allInExtRange
#line 1004
                        && inRange3(value[j], var_type[i], NCT_DOUBLE);
#line 1004
                }
#line 1004
                if (var_rank[i] == 0 && i%2 == 0)
#line 1004
                    err = nc_put_varm_double(ncid,i,NULL,NULL,NULL,NULL,value);
#line 1004
                else
#line 1004
                    err = nc_put_varm_double(ncid,i,index,count,stride,imap,value);
#line 1004
                if (canConvert) {
#line 1004
                    if (allInExtRange) {
#line 1004
                        IF (err)
#line 1004
                            error("%s", nc_strerror(err));
#line 1004
                    } else {
#line 1004
                        IF (err != NC_ERANGE)
#line 1004
                            error("range error: status = %d", err);
#line 1004
                    }
#line 1004
                } else {
#line 1004
                    IF (nels > 0 && err != NC_ECHAR)
#line 1004
                        error("wrong type: status = %d", err);
#line 1004
		}
#line 1004
	    }
#line 1004
	}
#line 1004
    }
#line 1004

#line 1004
    err = nc_close(ncid);
#line 1004
    IF (err) 
#line 1004
	error("nc_close: %s", nc_strerror(err));
#line 1004

#line 1004
    check_vars_double(scratch);
#line 1004

#line 1004
    err = remove(scratch);
#line 1004
    IF (err)
#line 1004
        error("remove of %s failed", scratch);
#line 1004
}
#line 1004



void
test_nc_put_att_text(void)
{
    int ncid;
    int i;
    int j;
    size_t k;
    int err;
    text value[MAX_NELS];

    err = nc_create(scratch, NC_NOCLOBBER, &ncid);
    IF (err) {
        error("nc_create: %s", nc_strerror(err));
        return;
    }
    def_dims(ncid);
    def_vars(ncid);

    {
	const char *const tval = "value for bad name";
	const size_t tval_len = strlen(tval);
	
	err = nc_put_att_text(ncid, 0, "", tval_len, tval);
	IF (err != NC_EBADNAME)
	   error("should be NC_EBADNAME: status = %d", err);
    }
    for (i = -1; i < NVARS; i++) {
        for (j = 0; j < NATTS(i); j++) {
            if (ATT_TYPE(i,j) == NC_CHAR) {
		assert(ATT_LEN(i,j) <= MAX_NELS);
		err = nc_put_att_text(BAD_ID, i, ATT_NAME(i,j), ATT_LEN(i,j), 
		    value);
		IF (err != NC_EBADID)
		    error("bad ncid: status = %d", err);
		err = nc_put_att_text(ncid, BAD_VARID, ATT_NAME(i,j), 
		    ATT_LEN(i,j), value);
		IF (err != NC_ENOTVAR)
		    error("bad var id: status = %d", err);
		for (k = 0; k < ATT_LEN(i,j); k++) {
		    value[k] = hash(ATT_TYPE(i,j), -1, &k);
		}
		err = nc_put_att_text(ncid, i, ATT_NAME(i,j), 
		    ATT_LEN(i,j), value);
		IF (err) {
		    error("%s", nc_strerror(err));
		}
	    }
        }
    }

    check_atts_text(ncid);
    err = nc_close(ncid);
    IF (err)
        error("nc_close: %s", nc_strerror(err));

    err = remove(scratch);
    IF (err)
        error("remove of %s failed", scratch);
}


#line 1135

void
#line 1136
test_nc_put_att_uchar(void)
#line 1136
{
#line 1136
    int ncid;
#line 1136
    int i;
#line 1136
    int j;
#line 1136
    size_t k;
#line 1136
    int err;
#line 1136
    uchar value[MAX_NELS];
#line 1136
    int allInExtRange;  /* all values within external range? */
#line 1136

#line 1136
    err = nc_create(scratch, NC_NOCLOBBER, &ncid);
#line 1136
    IF (err) {
#line 1136
        error("nc_create: %s", nc_strerror(err));
#line 1136
        return;
#line 1136
    }
#line 1136
    def_dims(ncid);
#line 1136
    def_vars(ncid);
#line 1136

#line 1136
    for (i = -1; i < NVARS; i++) {
#line 1136
        for (j = 0; j < NATTS(i); j++) {
#line 1136
            if (!(ATT_TYPE(i,j) == NC_CHAR)) {
#line 1136
		assert(ATT_LEN(i,j) <= MAX_NELS);
#line 1136
		err = nc_put_att_uchar(BAD_ID, i, ATT_NAME(i,j), ATT_TYPE(i,j), 
#line 1136
		    ATT_LEN(i,j), value);
#line 1136
		IF (err != NC_EBADID)
#line 1136
		    error("bad ncid: status = %d", err);
#line 1136
		err = nc_put_att_uchar(ncid, BAD_VARID, ATT_NAME(i,j), 
#line 1136
		    ATT_TYPE(i,j), ATT_LEN(i,j), value);
#line 1136
		IF (err != NC_ENOTVAR)
#line 1136
		    error("bad var id: status = %d", err);
#line 1136
		err = nc_put_att_uchar(ncid, i, ATT_NAME(i,j), BAD_TYPE, 
#line 1136
		    ATT_LEN(i,j), value);
#line 1136
		IF (err != NC_EBADTYPE)
#line 1136
		    error("bad type: status = %d", err);
#line 1136
		for (allInExtRange = 1, k = 0; k < ATT_LEN(i,j); k++) {
#line 1136
		    value[k] = hash_uchar(ATT_TYPE(i,j), -1, &k, NCT_UCHAR);
#line 1136
		    allInExtRange = allInExtRange
#line 1136
			&& inRange3(value[k], ATT_TYPE(i,j), NCT_UCHAR);
#line 1136
		}
#line 1136
		err = nc_put_att_uchar(ncid, i, ATT_NAME(i,j), ATT_TYPE(i,j),
#line 1136
		    ATT_LEN(i,j), value);
#line 1136
		if (allInExtRange) {
#line 1136
		    IF (err)
#line 1136
			error("%s", nc_strerror(err));
#line 1136
		} else {
#line 1136
                    IF (err != NC_ERANGE)
#line 1136
                        error("range error: status = %d", err);
#line 1136
		}
#line 1136
	    }
#line 1136
        }
#line 1136
    }
#line 1136

#line 1136
    check_atts_uchar(ncid);
#line 1136
    err = nc_close(ncid);
#line 1136
    IF (err)
#line 1136
        error("nc_close: %s", nc_strerror(err));
#line 1136

#line 1136
    err = remove(scratch);
#line 1136
    IF (err)
#line 1136
        error("remove of %s failed", scratch);
#line 1136
}
#line 1136

void
#line 1137
test_nc_put_att_schar(void)
#line 1137
{
#line 1137
    int ncid;
#line 1137
    int i;
#line 1137
    int j;
#line 1137
    size_t k;
#line 1137
    int err;
#line 1137
    schar value[MAX_NELS];
#line 1137
    int allInExtRange;  /* all values within external range? */
#line 1137

#line 1137
    err = nc_create(scratch, NC_NOCLOBBER, &ncid);
#line 1137
    IF (err) {
#line 1137
        error("nc_create: %s", nc_strerror(err));
#line 1137
        return;
#line 1137
    }
#line 1137
    def_dims(ncid);
#line 1137
    def_vars(ncid);
#line 1137

#line 1137
    for (i = -1; i < NVARS; i++) {
#line 1137
        for (j = 0; j < NATTS(i); j++) {
#line 1137
            if (!(ATT_TYPE(i,j) == NC_CHAR)) {
#line 1137
		assert(ATT_LEN(i,j) <= MAX_NELS);
#line 1137
		err = nc_put_att_schar(BAD_ID, i, ATT_NAME(i,j), ATT_TYPE(i,j), 
#line 1137
		    ATT_LEN(i,j), value);
#line 1137
		IF (err != NC_EBADID)
#line 1137
		    error("bad ncid: status = %d", err);
#line 1137
		err = nc_put_att_schar(ncid, BAD_VARID, ATT_NAME(i,j), 
#line 1137
		    ATT_TYPE(i,j), ATT_LEN(i,j), value);
#line 1137
		IF (err != NC_ENOTVAR)
#line 1137
		    error("bad var id: status = %d", err);
#line 1137
		err = nc_put_att_schar(ncid, i, ATT_NAME(i,j), BAD_TYPE, 
#line 1137
		    ATT_LEN(i,j), value);
#line 1137
		IF (err != NC_EBADTYPE)
#line 1137
		    error("bad type: status = %d", err);
#line 1137
		for (allInExtRange = 1, k = 0; k < ATT_LEN(i,j); k++) {
#line 1137
		    value[k] = hash_schar(ATT_TYPE(i,j), -1, &k, NCT_SCHAR);
#line 1137
		    allInExtRange = allInExtRange
#line 1137
			&& inRange3(value[k], ATT_TYPE(i,j), NCT_SCHAR);
#line 1137
		}
#line 1137
		err = nc_put_att_schar(ncid, i, ATT_NAME(i,j), ATT_TYPE(i,j),
#line 1137
		    ATT_LEN(i,j), value);
#line 1137
		if (allInExtRange) {
#line 1137
		    IF (err)
#line 1137
			error("%s", nc_strerror(err));
#line 1137
		} else {
#line 1137
                    IF (err != NC_ERANGE)
#line 1137
                        error("range error: status = %d", err);
#line 1137
		}
#line 1137
	    }
#line 1137
        }
#line 1137
    }
#line 1137

#line 1137
    check_atts_schar(ncid);
#line 1137
    err = nc_close(ncid);
#line 1137
    IF (err)
#line 1137
        error("nc_close: %s", nc_strerror(err));
#line 1137

#line 1137
    err = remove(scratch);
#line 1137
    IF (err)
#line 1137
        error("remove of %s failed", scratch);
#line 1137
}
#line 1137

void
#line 1138
test_nc_put_att_short(void)
#line 1138
{
#line 1138
    int ncid;
#line 1138
    int i;
#line 1138
    int j;
#line 1138
    size_t k;
#line 1138
    int err;
#line 1138
    short value[MAX_NELS];
#line 1138
    int allInExtRange;  /* all values within external range? */
#line 1138

#line 1138
    err = nc_create(scratch, NC_NOCLOBBER, &ncid);
#line 1138
    IF (err) {
#line 1138
        error("nc_create: %s", nc_strerror(err));
#line 1138
        return;
#line 1138
    }
#line 1138
    def_dims(ncid);
#line 1138
    def_vars(ncid);
#line 1138

#line 1138
    for (i = -1; i < NVARS; i++) {
#line 1138
        for (j = 0; j < NATTS(i); j++) {
#line 1138
            if (!(ATT_TYPE(i,j) == NC_CHAR)) {
#line 1138
		assert(ATT_LEN(i,j) <= MAX_NELS);
#line 1138
		err = nc_put_att_short(BAD_ID, i, ATT_NAME(i,j), ATT_TYPE(i,j), 
#line 1138
		    ATT_LEN(i,j), value);
#line 1138
		IF (err != NC_EBADID)
#line 1138
		    error("bad ncid: status = %d", err);
#line 1138
		err = nc_put_att_short(ncid, BAD_VARID, ATT_NAME(i,j), 
#line 1138
		    ATT_TYPE(i,j), ATT_LEN(i,j), value);
#line 1138
		IF (err != NC_ENOTVAR)
#line 1138
		    error("bad var id: status = %d", err);
#line 1138
		err = nc_put_att_short(ncid, i, ATT_NAME(i,j), BAD_TYPE, 
#line 1138
		    ATT_LEN(i,j), value);
#line 1138
		IF (err != NC_EBADTYPE)
#line 1138
		    error("bad type: status = %d", err);
#line 1138
		for (allInExtRange = 1, k = 0; k < ATT_LEN(i,j); k++) {
#line 1138
		    value[k] = hash_short(ATT_TYPE(i,j), -1, &k, NCT_SHORT);
#line 1138
		    allInExtRange = allInExtRange
#line 1138
			&& inRange3(value[k], ATT_TYPE(i,j), NCT_SHORT);
#line 1138
		}
#line 1138
		err = nc_put_att_short(ncid, i, ATT_NAME(i,j), ATT_TYPE(i,j),
#line 1138
		    ATT_LEN(i,j), value);
#line 1138
		if (allInExtRange) {
#line 1138
		    IF (err)
#line 1138
			error("%s", nc_strerror(err));
#line 1138
		} else {
#line 1138
                    IF (err != NC_ERANGE)
#line 1138
                        error("range error: status = %d", err);
#line 1138
		}
#line 1138
	    }
#line 1138
        }
#line 1138
    }
#line 1138

#line 1138
    check_atts_short(ncid);
#line 1138
    err = nc_close(ncid);
#line 1138
    IF (err)
#line 1138
        error("nc_close: %s", nc_strerror(err));
#line 1138

#line 1138
    err = remove(scratch);
#line 1138
    IF (err)
#line 1138
        error("remove of %s failed", scratch);
#line 1138
}
#line 1138

void
#line 1139
test_nc_put_att_int(void)
#line 1139
{
#line 1139
    int ncid;
#line 1139
    int i;
#line 1139
    int j;
#line 1139
    size_t k;
#line 1139
    int err;
#line 1139
    int value[MAX_NELS];
#line 1139
    int allInExtRange;  /* all values within external range? */
#line 1139

#line 1139
    err = nc_create(scratch, NC_NOCLOBBER, &ncid);
#line 1139
    IF (err) {
#line 1139
        error("nc_create: %s", nc_strerror(err));
#line 1139
        return;
#line 1139
    }
#line 1139
    def_dims(ncid);
#line 1139
    def_vars(ncid);
#line 1139

#line 1139
    for (i = -1; i < NVARS; i++) {
#line 1139
        for (j = 0; j < NATTS(i); j++) {
#line 1139
            if (!(ATT_TYPE(i,j) == NC_CHAR)) {
#line 1139
		assert(ATT_LEN(i,j) <= MAX_NELS);
#line 1139
		err = nc_put_att_int(BAD_ID, i, ATT_NAME(i,j), ATT_TYPE(i,j), 
#line 1139
		    ATT_LEN(i,j), value);
#line 1139
		IF (err != NC_EBADID)
#line 1139
		    error("bad ncid: status = %d", err);
#line 1139
		err = nc_put_att_int(ncid, BAD_VARID, ATT_NAME(i,j), 
#line 1139
		    ATT_TYPE(i,j), ATT_LEN(i,j), value);
#line 1139
		IF (err != NC_ENOTVAR)
#line 1139
		    error("bad var id: status = %d", err);
#line 1139
		err = nc_put_att_int(ncid, i, ATT_NAME(i,j), BAD_TYPE, 
#line 1139
		    ATT_LEN(i,j), value);
#line 1139
		IF (err != NC_EBADTYPE)
#line 1139
		    error("bad type: status = %d", err);
#line 1139
		for (allInExtRange = 1, k = 0; k < ATT_LEN(i,j); k++) {
#line 1139
		    value[k] = hash_int(ATT_TYPE(i,j), -1, &k, NCT_INT);
#line 1139
		    allInExtRange = allInExtRange
#line 1139
			&& inRange3(value[k], ATT_TYPE(i,j), NCT_INT);
#line 1139
		}
#line 1139
		err = nc_put_att_int(ncid, i, ATT_NAME(i,j), ATT_TYPE(i,j),
#line 1139
		    ATT_LEN(i,j), value);
#line 1139
		if (allInExtRange) {
#line 1139
		    IF (err)
#line 1139
			error("%s", nc_strerror(err));
#line 1139
		} else {
#line 1139
                    IF (err != NC_ERANGE)
#line 1139
                        error("range error: status = %d", err);
#line 1139
		}
#line 1139
	    }
#line 1139
        }
#line 1139
    }
#line 1139

#line 1139
    check_atts_int(ncid);
#line 1139
    err = nc_close(ncid);
#line 1139
    IF (err)
#line 1139
        error("nc_close: %s", nc_strerror(err));
#line 1139

#line 1139
    err = remove(scratch);
#line 1139
    IF (err)
#line 1139
        error("remove of %s failed", scratch);
#line 1139
}
#line 1139

void
#line 1140
test_nc_put_att_long(void)
#line 1140
{
#line 1140
    int ncid;
#line 1140
    int i;
#line 1140
    int j;
#line 1140
    size_t k;
#line 1140
    int err;
#line 1140
    long value[MAX_NELS];
#line 1140
    int allInExtRange;  /* all values within external range? */
#line 1140

#line 1140
    err = nc_create(scratch, NC_NOCLOBBER, &ncid);
#line 1140
    IF (err) {
#line 1140
        error("nc_create: %s", nc_strerror(err));
#line 1140
        return;
#line 1140
    }
#line 1140
    def_dims(ncid);
#line 1140
    def_vars(ncid);
#line 1140

#line 1140
    for (i = -1; i < NVARS; i++) {
#line 1140
        for (j = 0; j < NATTS(i); j++) {
#line 1140
            if (!(ATT_TYPE(i,j) == NC_CHAR)) {
#line 1140
		assert(ATT_LEN(i,j) <= MAX_NELS);
#line 1140
		err = nc_put_att_long(BAD_ID, i, ATT_NAME(i,j), ATT_TYPE(i,j), 
#line 1140
		    ATT_LEN(i,j), value);
#line 1140
		IF (err != NC_EBADID)
#line 1140
		    error("bad ncid: status = %d", err);
#line 1140
		err = nc_put_att_long(ncid, BAD_VARID, ATT_NAME(i,j), 
#line 1140
		    ATT_TYPE(i,j), ATT_LEN(i,j), value);
#line 1140
		IF (err != NC_ENOTVAR)
#line 1140
		    error("bad var id: status = %d", err);
#line 1140
		err = nc_put_att_long(ncid, i, ATT_NAME(i,j), BAD_TYPE, 
#line 1140
		    ATT_LEN(i,j), value);
#line 1140
		IF (err != NC_EBADTYPE)
#line 1140
		    error("bad type: status = %d", err);
#line 1140
		for (allInExtRange = 1, k = 0; k < ATT_LEN(i,j); k++) {
#line 1140
		    value[k] = hash_long(ATT_TYPE(i,j), -1, &k, NCT_LONG);
#line 1140
		    allInExtRange = allInExtRange
#line 1140
			&& inRange3(value[k], ATT_TYPE(i,j), NCT_LONG);
#line 1140
		}
#line 1140
		err = nc_put_att_long(ncid, i, ATT_NAME(i,j), ATT_TYPE(i,j),
#line 1140
		    ATT_LEN(i,j), value);
#line 1140
		if (allInExtRange) {
#line 1140
		    IF (err)
#line 1140
			error("%s", nc_strerror(err));
#line 1140
		} else {
#line 1140
                    IF (err != NC_ERANGE)
#line 1140
                        error("range error: status = %d", err);
#line 1140
		}
#line 1140
	    }
#line 1140
        }
#line 1140
    }
#line 1140

#line 1140
    check_atts_long(ncid);
#line 1140
    err = nc_close(ncid);
#line 1140
    IF (err)
#line 1140
        error("nc_close: %s", nc_strerror(err));
#line 1140

#line 1140
    err = remove(scratch);
#line 1140
    IF (err)
#line 1140
        error("remove of %s failed", scratch);
#line 1140
}
#line 1140

void
#line 1141
test_nc_put_att_float(void)
#line 1141
{
#line 1141
    int ncid;
#line 1141
    int i;
#line 1141
    int j;
#line 1141
    size_t k;
#line 1141
    int err;
#line 1141
    float value[MAX_NELS];
#line 1141
    int allInExtRange;  /* all values within external range? */
#line 1141

#line 1141
    err = nc_create(scratch, NC_NOCLOBBER, &ncid);
#line 1141
    IF (err) {
#line 1141
        error("nc_create: %s", nc_strerror(err));
#line 1141
        return;
#line 1141
    }
#line 1141
    def_dims(ncid);
#line 1141
    def_vars(ncid);
#line 1141

#line 1141
    for (i = -1; i < NVARS; i++) {
#line 1141
        for (j = 0; j < NATTS(i); j++) {
#line 1141
            if (!(ATT_TYPE(i,j) == NC_CHAR)) {
#line 1141
		assert(ATT_LEN(i,j) <= MAX_NELS);
#line 1141
		err = nc_put_att_float(BAD_ID, i, ATT_NAME(i,j), ATT_TYPE(i,j), 
#line 1141
		    ATT_LEN(i,j), value);
#line 1141
		IF (err != NC_EBADID)
#line 1141
		    error("bad ncid: status = %d", err);
#line 1141
		err = nc_put_att_float(ncid, BAD_VARID, ATT_NAME(i,j), 
#line 1141
		    ATT_TYPE(i,j), ATT_LEN(i,j), value);
#line 1141
		IF (err != NC_ENOTVAR)
#line 1141
		    error("bad var id: status = %d", err);
#line 1141
		err = nc_put_att_float(ncid, i, ATT_NAME(i,j), BAD_TYPE, 
#line 1141
		    ATT_LEN(i,j), value);
#line 1141
		IF (err != NC_EBADTYPE)
#line 1141
		    error("bad type: status = %d", err);
#line 1141
		for (allInExtRange = 1, k = 0; k < ATT_LEN(i,j); k++) {
#line 1141
		    value[k] = hash_float(ATT_TYPE(i,j), -1, &k, NCT_FLOAT);
#line 1141
		    allInExtRange = allInExtRange
#line 1141
			&& inRange3(value[k], ATT_TYPE(i,j), NCT_FLOAT);
#line 1141
		}
#line 1141
		err = nc_put_att_float(ncid, i, ATT_NAME(i,j), ATT_TYPE(i,j),
#line 1141
		    ATT_LEN(i,j), value);
#line 1141
		if (allInExtRange) {
#line 1141
		    IF (err)
#line 1141
			error("%s", nc_strerror(err));
#line 1141
		} else {
#line 1141
                    IF (err != NC_ERANGE)
#line 1141
                        error("range error: status = %d", err);
#line 1141
		}
#line 1141
	    }
#line 1141
        }
#line 1141
    }
#line 1141

#line 1141
    check_atts_float(ncid);
#line 1141
    err = nc_close(ncid);
#line 1141
    IF (err)
#line 1141
        error("nc_close: %s", nc_strerror(err));
#line 1141

#line 1141
    err = remove(scratch);
#line 1141
    IF (err)
#line 1141
        error("remove of %s failed", scratch);
#line 1141
}
#line 1141

void
#line 1142
test_nc_put_att_double(void)
#line 1142
{
#line 1142
    int ncid;
#line 1142
    int i;
#line 1142
    int j;
#line 1142
    size_t k;
#line 1142
    int err;
#line 1142
    double value[MAX_NELS];
#line 1142
    int allInExtRange;  /* all values within external range? */
#line 1142

#line 1142
    err = nc_create(scratch, NC_NOCLOBBER, &ncid);
#line 1142
    IF (err) {
#line 1142
        error("nc_create: %s", nc_strerror(err));
#line 1142
        return;
#line 1142
    }
#line 1142
    def_dims(ncid);
#line 1142
    def_vars(ncid);
#line 1142

#line 1142
    for (i = -1; i < NVARS; i++) {
#line 1142
        for (j = 0; j < NATTS(i); j++) {
#line 1142
            if (!(ATT_TYPE(i,j) == NC_CHAR)) {
#line 1142
		assert(ATT_LEN(i,j) <= MAX_NELS);
#line 1142
		err = nc_put_att_double(BAD_ID, i, ATT_NAME(i,j), ATT_TYPE(i,j), 
#line 1142
		    ATT_LEN(i,j), value);
#line 1142
		IF (err != NC_EBADID)
#line 1142
		    error("bad ncid: status = %d", err);
#line 1142
		err = nc_put_att_double(ncid, BAD_VARID, ATT_NAME(i,j), 
#line 1142
		    ATT_TYPE(i,j), ATT_LEN(i,j), value);
#line 1142
		IF (err != NC_ENOTVAR)
#line 1142
		    error("bad var id: status = %d", err);
#line 1142
		err = nc_put_att_double(ncid, i, ATT_NAME(i,j), BAD_TYPE, 
#line 1142
		    ATT_LEN(i,j), value);
#line 1142
		IF (err != NC_EBADTYPE)
#line 1142
		    error("bad type: status = %d", err);
#line 1142
		for (allInExtRange = 1, k = 0; k < ATT_LEN(i,j); k++) {
#line 1142
		    value[k] = hash_double(ATT_TYPE(i,j), -1, &k, NCT_DOUBLE);
#line 1142
		    allInExtRange = allInExtRange
#line 1142
			&& inRange3(value[k], ATT_TYPE(i,j), NCT_DOUBLE);
#line 1142
		}
#line 1142
		err = nc_put_att_double(ncid, i, ATT_NAME(i,j), ATT_TYPE(i,j),
#line 1142
		    ATT_LEN(i,j), value);
#line 1142
		if (allInExtRange) {
#line 1142
		    IF (err)
#line 1142
			error("%s", nc_strerror(err));
#line 1142
		} else {
#line 1142
                    IF (err != NC_ERANGE)
#line 1142
                        error("range error: status = %d", err);
#line 1142
		}
#line 1142
	    }
#line 1142
        }
#line 1142
    }
#line 1142

#line 1142
    check_atts_double(ncid);
#line 1142
    err = nc_close(ncid);
#line 1142
    IF (err)
#line 1142
        error("nc_close: %s", nc_strerror(err));
#line 1142

#line 1142
    err = remove(scratch);
#line 1142
    IF (err)
#line 1142
        error("remove of %s failed", scratch);
#line 1142
}
#line 1142


