#include <locale.h>
#include <nl_types.h>
#include <stdio.h>
#include <stdlib.h>

int
main(int     const argc,
     char ** const argv) {

    if (argc-1 < 1) {
        fprintf(stderr, "Not enough arguments");
        exit(1);
    } else {
        const char * const catalogName = argv[1];

        nl_catd catalog;

        catalog = catopen (catalogName, NL_CAT_LOCALE);
        if (catalog == (nl_catd) -1) {
            fprintf(stderr, "catopen() failed.\n");
            exit(1);
        } else {
            printf ("%s\n", catgets(catalog, 1, 1, "sample 1"));
            printf ("%s\n", catgets(catalog, 1, 2, "sample 2"));
            printf ("%s\n", catgets(catalog, 1, 3, "sample 3"));
            printf ("%s\n", catgets(catalog, 1, 4, "sample 4"));
            printf ("%s\n", catgets(catalog, 1, 5, "sample 5"));
            printf ("%s\n", catgets(catalog, 1, 6, "sample 6"));
            printf ("%s\n", catgets(catalog, 1, 7, "sample 7"));
            catclose (catalog);
        }
    }
    return 0;
}
