/***** Autogenerated from runpicture.in; changes will be overwritten *****/

#line 1 "runtimebase.in"
/*****
 * runtimebase.in
 * Andy Hammerlindl  2009/07/28
 *
 * Common declarations needed for all code-generating .in files.
 *
 *****/


#line 1 "runpicture.in"
/*****
 * runpicture.in
 *
 * Runtime functions for picture operations.
 *
 *****/

#line 1 "runtimebase.in"
#include "stack.h"
#include "types.h"
#include "builtin.h"
#include "entry.h"
#include "errormsg.h"
#include "array.h"
#include "triple.h"
#include "callable.h"
#include "opsymbols.h"

using vm::stack;
using vm::error;
using vm::array;
using vm::read;
using vm::callable;
using types::formal;
using types::function;
using camp::triple;

#define PRIMITIVE(name,Name,asyName) using types::prim##Name;
#include <primitives.h>
#undef PRIMITIVE

typedef double real;

void unused(void *);

namespace run {
array *copyArray(array *a);
array *copyArray2(array *a);
array *copyArray3(array *a);

double *copyTripleArray2Components(array *a, bool square=true, size_t dim2=0,
                                   GCPlacement placement=NoGC);
}

function *realRealFunction();

#define CURRENTPEN processData().currentpen

#line 29 "runpicture.in"
#include "picture.h"
#include "drawelement.h"
#include "path.h"
#include "array.h"
#include "arrayop.h"
#include "drawpath.h"
#include "drawfill.h"
#include "drawclipbegin.h"
#include "drawclipend.h"
#include "drawgsave.h"
#include "drawgrestore.h"
#include "drawgroup.h"
#include "drawverbatim.h"
#include "drawlabel.h"
#include "drawlayer.h"
#include "drawimage.h"
#include "drawpath3.h"
#include "drawsurface.h"

using namespace camp;
using namespace settings;
using namespace vm;

typedef array Intarray;
typedef array Intarray2;
typedef array realarray;
typedef array realarray2;
typedef array pairarray;
typedef array pairarray2;
typedef array triplearray;
typedef array triplearray2;
typedef array patharray;
typedef array penarray;
typedef array penarray2;

typedef callable callableTransform;
typedef callable callablePen;

using types::IntArray;
using types::IntArray2;
using types::realArray;
using types::realArray2;
using types::pairArray;
using types::pairArray2;
using types::tripleArray;
using types::tripleArray2;
using types::pathArray;
using types::penArray;
using types::penArray2;

function *transformFunction()
{
  return new function(primTransform());
}

function *penFunction()
{
  return new function(primPen(),primInt(),primInt());
}

// Ignore unclosed begingroups but not spurious endgroups.
const char *nobegin="endgroup without matching begingroup";
  
array *emptyarray=new array(0);

array *nop(array *a) 
{
  return a;
}
  
triple Zero;

// Autogenerated routines:



#ifndef NOSYM
#include "runpicture.symbols.h"

#endif
namespace run {
#line 104 "runpicture.in"
void newPicture(stack *Stack)
{
#line 105 "runpicture.in"
  {Stack->push<picture*>(new picture()); return;}
}

#line 109 "runpicture.in"
// bool empty(picture *f);
void gen_runpicture1(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 110 "runpicture.in"
  {Stack->push<bool>(f->null()); return;}
}

#line 114 "runpicture.in"
// void erase(picture *f);
void gen_runpicture2(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 115 "runpicture.in"
  f->nodes.clear();
}

#line 119 "runpicture.in"
// pair min(picture *f);
void gen_runpicture3(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 120 "runpicture.in"
  {Stack->push<pair>(f->bounds().Min()); return;}
}

#line 124 "runpicture.in"
// pair max(picture *f);
void gen_runpicture4(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 125 "runpicture.in"
  {Stack->push<pair>(f->bounds().Max()); return;}
}

#line 129 "runpicture.in"
// pair size(picture *f);
void gen_runpicture5(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 130 "runpicture.in"
  bbox b=f->bounds();
  {Stack->push<pair>(b.Max()-b.Min()); return;}
}

#line 135 "runpicture.in"
// void _draw(picture *f, path g, pen p);
void gen_runpicture6(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
  path g=vm::pop<path>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 136 "runpicture.in"
  f->append(new drawPath(g,p));
}

#line 140 "runpicture.in"
// void fill(picture *f, patharray *g, pen p=CURRENTPEN, bool copy=true);
void gen_runpicture7(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  pen p=vm::pop<pen>(Stack,CURRENTPEN);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 141 "runpicture.in"
  array *(*copyarray)(array *a)=copy ? copyArray: nop;
  f->append(new drawFill(*copyarray(g),false,p));
}

#line 146 "runpicture.in"
// void latticeshade(picture *f, patharray *g, bool stroke=false,                  pen fillrule=CURRENTPEN, penarray2 *p, transform t=identity,                   bool copy=true);
void gen_runpicture8(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  transform t=vm::pop<transform>(Stack,identity);
  penarray2 * p=vm::pop<penarray2 *>(Stack);
  pen fillrule=vm::pop<pen>(Stack,CURRENTPEN);
  bool stroke=vm::pop<bool>(Stack,false);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 149 "runpicture.in"
  array *(*copyarray)(array *a)=copy ? copyArray: nop;
  f->append(new drawLatticeShade(*copyarray(g),stroke,fillrule,*copyarray(p),
                                 t));
}

#line 155 "runpicture.in"
// void axialshade(picture *f, patharray *g, bool stroke=false, pen pena, pair a,                bool extenda=true, pen penb, pair b, bool extendb=true,                bool copy=true);
void gen_runpicture9(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  bool extendb=vm::pop<bool>(Stack,true);
  pair b=vm::pop<pair>(Stack);
  pen penb=vm::pop<pen>(Stack);
  bool extenda=vm::pop<bool>(Stack,true);
  pair a=vm::pop<pair>(Stack);
  pen pena=vm::pop<pen>(Stack);
  bool stroke=vm::pop<bool>(Stack,false);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 158 "runpicture.in"
  array *(*copyarray)(array *a)=copy ? copyArray: nop;
  f->append(new drawAxialShade(*copyarray(g),stroke,pena,a,extenda,penb,b,
                               extendb));
}

#line 164 "runpicture.in"
// void radialshade(picture *f, patharray *g, bool stroke=false, pen pena,                 pair a, real ra, bool extenda=true, pen penb, pair b, real rb,                 bool extendb=true, bool copy=true);
void gen_runpicture10(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  bool extendb=vm::pop<bool>(Stack,true);
  real rb=vm::pop<real>(Stack);
  pair b=vm::pop<pair>(Stack);
  pen penb=vm::pop<pen>(Stack);
  bool extenda=vm::pop<bool>(Stack,true);
  real ra=vm::pop<real>(Stack);
  pair a=vm::pop<pair>(Stack);
  pen pena=vm::pop<pen>(Stack);
  bool stroke=vm::pop<bool>(Stack,false);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 167 "runpicture.in"
  array *(*copyarray)(array *a)=copy ? copyArray: nop;
  f->append(new drawRadialShade(*copyarray(g),stroke,pena,a,ra,extenda,
                                penb,b,rb,extendb));
}

#line 173 "runpicture.in"
// void gouraudshade(picture *f, patharray *g, bool stroke=false,                  pen fillrule=CURRENTPEN, penarray *p, pairarray *z,                  Intarray *edges, bool copy=true);
void gen_runpicture11(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  Intarray * edges=vm::pop<Intarray *>(Stack);
  pairarray * z=vm::pop<pairarray *>(Stack);
  penarray * p=vm::pop<penarray *>(Stack);
  pen fillrule=vm::pop<pen>(Stack,CURRENTPEN);
  bool stroke=vm::pop<bool>(Stack,false);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 176 "runpicture.in"
  array *(*copyarray)(array *a)=copy ? copyArray: nop;
  checkArrays(p,z);
  checkArrays(z,edges);
  f->append(new drawGouraudShade(*copyarray(g),stroke,fillrule,*copyarray(p),
                                 *copyarray(z),*copyarray(edges)));
}

#line 184 "runpicture.in"
// void gouraudshade(picture *f, patharray *g, bool stroke=false,                  pen fillrule=CURRENTPEN, penarray *p, Intarray *edges,                  bool copy=true);
void gen_runpicture12(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  Intarray * edges=vm::pop<Intarray *>(Stack);
  penarray * p=vm::pop<penarray *>(Stack);
  pen fillrule=vm::pop<pen>(Stack,CURRENTPEN);
  bool stroke=vm::pop<bool>(Stack,false);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 187 "runpicture.in"
  array *(*copyarray)(array *a)=copy ? copyArray: nop;
  size_t n=checkArrays(p,edges);
  size_t m=checkArray(g);
  array *z=new array(n);
  Int k=0;
  Int in=(Int) n;
  for(size_t j=0; j < m; ++j) {
    path *P=read<path *>(g,j);
    assert(P);
    Int stop=Min(P->size(),in-k);
    mem::vector<solvedKnot>& nodes=P->Nodes();
    for(Int i=0; i < stop; ++i)
      (*z)[k++]=nodes[i].point;
  }
  checkArrays(p,z);
  
  f->append(new drawGouraudShade(*copyarray(g),stroke,fillrule,*copyarray(p),
                                 *z,*copyarray(edges)));
}

#line 208 "runpicture.in"
// void tensorshade(picture *f, patharray *g, bool stroke=false,                 pen fillrule=CURRENTPEN, penarray2 *p, patharray *b=NULL,                 pairarray2 *z=emptyarray, bool copy=true);
void gen_runpicture13(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  pairarray2 * z=vm::pop<pairarray2 *>(Stack,emptyarray);
  patharray * b=vm::pop<patharray *>(Stack,NULL);
  penarray2 * p=vm::pop<penarray2 *>(Stack);
  pen fillrule=vm::pop<pen>(Stack,CURRENTPEN);
  bool stroke=vm::pop<bool>(Stack,false);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 211 "runpicture.in"
  array *(*copyarray)(array *a)=copy ? copyArray: nop;
  array *(*copyarray2)(array *a)=copy ? copyArray2: nop;
  if(b == NULL) b=g;
  size_t n=checkArrays(p,b);
  size_t nz=checkArray(z);
  if(nz != 0)
    checkEqual(nz,n);
  f->append(new drawTensorShade(*copyarray(g),stroke,fillrule,*copyarray2(p),
                                *copyarray(b),*copyarray2(z)));
}

#line 223 "runpicture.in"
// void functionshade(picture *f, patharray *g, bool stroke=false,                   pen fillrule=CURRENTPEN, string shader=emptystring,                   bool copy=true);
void gen_runpicture14(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  string shader=vm::pop<string>(Stack,emptystring);
  pen fillrule=vm::pop<pen>(Stack,CURRENTPEN);
  bool stroke=vm::pop<bool>(Stack,false);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 226 "runpicture.in"
  array *(*copyarray)(array *a)=copy ? copyArray: nop;
  f->append(new drawFunctionShade(*copyarray(g),stroke,fillrule,shader));
}

// Clip a picture to a superpath using the given fill rule.
// Subsequent additions to the picture will not be affected by the clipping.
#line 233 "runpicture.in"
// void clip(picture *f, patharray *g, bool stroke=false,          pen fillrule=CURRENTPEN, bool copy=true);
void gen_runpicture15(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  pen fillrule=vm::pop<pen>(Stack,CURRENTPEN);
  bool stroke=vm::pop<bool>(Stack,false);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 235 "runpicture.in"
  array *(*copyarray)(array *a)=copy ? copyArray: nop;
  drawClipBegin *begin=new drawClipBegin(*copyarray(g),stroke,fillrule,true);
  f->enclose(begin,new drawClipEnd(true,begin));
}

#line 241 "runpicture.in"
// void beginclip(picture *f, patharray *g, bool stroke=false,               pen fillrule=CURRENTPEN, bool copy=true);
void gen_runpicture16(stack *Stack)
{
  bool copy=vm::pop<bool>(Stack,true);
  pen fillrule=vm::pop<pen>(Stack,CURRENTPEN);
  bool stroke=vm::pop<bool>(Stack,false);
  patharray * g=vm::pop<patharray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 243 "runpicture.in"
  array *(*copyarray)(array *a)=copy ? copyArray: nop;
  f->append(new drawClipBegin(*copyarray(g),stroke,fillrule,false));
}

#line 248 "runpicture.in"
// void endclip(picture *f);
void gen_runpicture17(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 249 "runpicture.in"
  f->append(new drawClipEnd(false));
}

#line 253 "runpicture.in"
// void gsave(picture *f);
void gen_runpicture18(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 254 "runpicture.in"
  f->append(new drawGsave());
}

#line 258 "runpicture.in"
// void grestore(picture *f);
void gen_runpicture19(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 259 "runpicture.in"
  f->append(new drawGrestore());
}

#line 263 "runpicture.in"
// void begingroup(picture *f);
void gen_runpicture20(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 264 "runpicture.in"
  f->append(new drawBegin());
}

#line 268 "runpicture.in"
// void endgroup(picture *f);
void gen_runpicture21(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 269 "runpicture.in"
  f->append(new drawEnd());
}

#line 273 "runpicture.in"
// void _begingroup3(picture *f, string name, real compression,                 real granularity, bool closed, bool tessellate,                 bool dobreak, bool nobreak, triple center, Int interaction);
void gen_runpicture22(stack *Stack)
{
  Int interaction=vm::pop<Int>(Stack);
  triple center=vm::pop<triple>(Stack);
  bool nobreak=vm::pop<bool>(Stack);
  bool dobreak=vm::pop<bool>(Stack);
  bool tessellate=vm::pop<bool>(Stack);
  bool closed=vm::pop<bool>(Stack);
  real granularity=vm::pop<real>(Stack);
  real compression=vm::pop<real>(Stack);
  string name=vm::pop<string>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 276 "runpicture.in"
  f->append(new drawBegin3(name,compression,granularity,
                           closed,tessellate,dobreak,nobreak,
                           center,(Interaction) intcast(interaction)));
}

#line 282 "runpicture.in"
// void endgroup3(picture *f);
void gen_runpicture23(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 283 "runpicture.in"
  f->append(new drawEnd3());
}

#line 287 "runpicture.in"
// void add(picture *dest, picture *src);
void gen_runpicture24(stack *Stack)
{
  picture * src=vm::pop<picture *>(Stack);
  picture * dest=vm::pop<picture *>(Stack);
#line 288 "runpicture.in"
  dest->add(*src);
}

#line 292 "runpicture.in"
// void prepend(picture *dest, picture *src);
void gen_runpicture25(stack *Stack)
{
  picture * src=vm::pop<picture *>(Stack);
  picture * dest=vm::pop<picture *>(Stack);
#line 293 "runpicture.in"
  dest->prepend(*src);
}

#line 297 "runpicture.in"
// void postscript(picture *f, string s);
void gen_runpicture26(stack *Stack)
{
  string s=vm::pop<string>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 298 "runpicture.in"
  f->append(new drawVerbatim(PostScript,s));
}

#line 302 "runpicture.in"
// void tex(picture *f, string s);
void gen_runpicture27(stack *Stack)
{
  string s=vm::pop<string>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 303 "runpicture.in"
  f->append(new drawVerbatim(TeX,s));
}

#line 307 "runpicture.in"
// void postscript(picture *f, string s, pair min, pair max);
void gen_runpicture28(stack *Stack)
{
  pair max=vm::pop<pair>(Stack);
  pair min=vm::pop<pair>(Stack);
  string s=vm::pop<string>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 308 "runpicture.in"
  f->append(new drawVerbatim(PostScript,s,min,max));
}

#line 312 "runpicture.in"
// void tex(picture *f, string s, pair min, pair max);
void gen_runpicture29(stack *Stack)
{
  pair max=vm::pop<pair>(Stack);
  pair min=vm::pop<pair>(Stack);
  string s=vm::pop<string>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 313 "runpicture.in"
  f->append(new drawVerbatim(TeX,s,min,max));
}

#line 317 "runpicture.in"
// void texpreamble(string s);
void gen_runpicture30(stack *Stack)
{
  string s=vm::pop<string>(Stack);
#line 318 "runpicture.in"
  string t=s+"\n";
  processDataStruct &pd=processData();
  pd.TeXpipepreamble.push_back(t);
  pd.TeXpreamble.push_back(t);
}

#line 325 "runpicture.in"
// void deletepreamble();
void gen_runpicture31(stack *)
{
#line 326 "runpicture.in"
  if(getSetting<bool>("inlinetex")) {
    unlink(buildname(outname(),"pre").c_str());
  }
}

#line 332 "runpicture.in"
// void _labelpath(picture *f, string s, string size, path g, string justify,                pair offset, pen p);
void gen_runpicture32(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
  pair offset=vm::pop<pair>(Stack);
  string justify=vm::pop<string>(Stack);
  path g=vm::pop<path>(Stack);
  string size=vm::pop<string>(Stack);
  string s=vm::pop<string>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 334 "runpicture.in"
  f->append(new drawLabelPath(s,size,g,justify,offset,p));
}

#line 338 "runpicture.in"
// void texreset();
void gen_runpicture33(stack *)
{
#line 339 "runpicture.in"
  processDataStruct &pd=processData();
  pd.TeXpipepreamble.clear();
  pd.TeXpreamble.clear();
  pd.tex.pipeclose();
}

#line 346 "runpicture.in"
// void layer(picture *f);
void gen_runpicture34(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 347 "runpicture.in"
  f->append(new drawLayer());
}

#line 351 "runpicture.in"
// void newpage(picture *f);
void gen_runpicture35(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 352 "runpicture.in"
  f->append(new drawNewPage());
}

#line 356 "runpicture.in"
// void _image(picture *f, realarray2 *data, pair initial, pair final,            penarray *palette=NULL, transform t=identity, bool copy=true,            bool antialias=false);
void gen_runpicture36(stack *Stack)
{
  bool antialias=vm::pop<bool>(Stack,false);
  bool copy=vm::pop<bool>(Stack,true);
  transform t=vm::pop<transform>(Stack,identity);
  penarray * palette=vm::pop<penarray *>(Stack,NULL);
  pair final=vm::pop<pair>(Stack);
  pair initial=vm::pop<pair>(Stack);
  realarray2 * data=vm::pop<realarray2 *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 359 "runpicture.in"
  array *(*copyarray)(array *a)=copy ? copyArray: nop;
  array *(*copyarray2)(array *a)=copy ? copyArray2: nop;
  f->append(new drawPaletteImage(*copyarray2(data),*copyarray(palette),
                            t*matrix(initial,final),antialias));
}

#line 366 "runpicture.in"
// void _image(picture *f, penarray2 *data, pair initial, pair final,            transform t=identity, bool copy=true, bool antialias=false);
void gen_runpicture37(stack *Stack)
{
  bool antialias=vm::pop<bool>(Stack,false);
  bool copy=vm::pop<bool>(Stack,true);
  transform t=vm::pop<transform>(Stack,identity);
  pair final=vm::pop<pair>(Stack);
  pair initial=vm::pop<pair>(Stack);
  penarray2 * data=vm::pop<penarray2 *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 368 "runpicture.in"
  array *(*copyarray2)(array *a)=copy ? copyArray2: nop;
  f->append(new drawNoPaletteImage(*copyarray2(data),t*matrix(initial,final),
                                   antialias));
}

#line 374 "runpicture.in"
// void _image(picture *f, callablePen *F, Int width, Int height,            pair initial, pair final, transform t=identity, bool antialias=false);
void gen_runpicture38(stack *Stack)
{
  bool antialias=vm::pop<bool>(Stack,false);
  transform t=vm::pop<transform>(Stack,identity);
  pair final=vm::pop<pair>(Stack);
  pair initial=vm::pop<pair>(Stack);
  Int height=vm::pop<Int>(Stack);
  Int width=vm::pop<Int>(Stack);
  callablePen * F=vm::pop<callablePen *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 376 "runpicture.in"
  f->append(new drawFunctionImage(Stack,F,width,height,
                                  t*matrix(initial,final),antialias));
}

#line 381 "runpicture.in"
// string nativeformat();
void gen_runpicture39(stack *Stack)
{
#line 382 "runpicture.in"
  {Stack->push<string>(nativeformat()); return;}
}

#line 386 "runpicture.in"
// bool latex();
void gen_runpicture40(stack *Stack)
{
#line 387 "runpicture.in"
  {Stack->push<bool>(latex(getSetting<string>("tex"))); return;}
}

#line 391 "runpicture.in"
// bool pdf();
void gen_runpicture41(stack *Stack)
{
#line 392 "runpicture.in"
  {Stack->push<bool>(pdf(getSetting<string>("tex"))); return;}
}

#line 396 "runpicture.in"
// void shipout(string prefix=emptystring, picture *f, picture *preamble=NULL,             string format=emptystring, bool wait=false, bool view=true,             callableTransform *xform);
void gen_runpicture42(stack *Stack)
{
  callableTransform * xform=vm::pop<callableTransform *>(Stack);
  bool view=vm::pop<bool>(Stack,true);
  bool wait=vm::pop<bool>(Stack,false);
  string format=vm::pop<string>(Stack,emptystring);
  picture * preamble=vm::pop<picture *>(Stack,NULL);
  picture * f=vm::pop<picture *>(Stack);
  string prefix=vm::pop<string>(Stack,emptystring);
#line 399 "runpicture.in"
  if(prefix.empty()) prefix=outname();

  picture *result=new picture;
  unsigned level=0;
  picture::nodelist::iterator p;

  // If null is given as an xform, just use the identity transformation.
  bool xformIsNull = xform == nullfunc::instance();

  for(p = f->nodes.begin(); p != f->nodes.end(); ++p) {
    if (!xformIsNull)
      xform->call(Stack);
    transform t=xformIsNull ? camp::identity : pop<transform>(Stack);

    static transform Zero=transform(0.0,0.0,0.0,0.0,0.0,0.0);
    bool Delete=(t == Zero);
    picture *group=new picture;
    assert(*p);
    if((*p)->endgroup()) error(nobegin);
    if((*p)->begingroup()) {
      ++level;
      while(p != f->nodes.end() && level) {
        if(!Delete) {
          drawElement *e=t.isIdentity() ? *p : (*p)->transformed(t);
          group->append(e);
        }
        ++p;
        if(p == f->nodes.end()) break;
        assert(*p);
        if((*p)->begingroup()) ++level;
        if((*p)->endgroup()) {
          if(level) --level;
          else error(nobegin);
        }
      }
    }
    if(p == f->nodes.end()) break;
    assert(*p);
    if(!Delete) {
      drawElement *e=t.isIdentity() ? *p : (*p)->transformed(t);
      group->append(e);
      result->add(*group);
    }
  }
    
  result->shipout(preamble,prefix,format,0.0,wait,view);
}

#line 448 "runpicture.in"
// void shipout3(string prefix, picture *f, string format=emptystring,              real width, real height, real angle, real zoom,              triple m, triple M, pair shift, realarray2 *t,              realarray *background, triplearray *lights, realarray2 *diffuse,              realarray2 *ambient, realarray2 *specular,              bool viewportlighting, bool view=true);
void gen_runpicture43(stack *Stack)
{
  bool view=vm::pop<bool>(Stack,true);
  bool viewportlighting=vm::pop<bool>(Stack);
  realarray2 * specular=vm::pop<realarray2 *>(Stack);
  realarray2 * ambient=vm::pop<realarray2 *>(Stack);
  realarray2 * diffuse=vm::pop<realarray2 *>(Stack);
  triplearray * lights=vm::pop<triplearray *>(Stack);
  realarray * background=vm::pop<realarray *>(Stack);
  realarray2 * t=vm::pop<realarray2 *>(Stack);
  pair shift=vm::pop<pair>(Stack);
  triple M=vm::pop<triple>(Stack);
  triple m=vm::pop<triple>(Stack);
  real zoom=vm::pop<real>(Stack);
  real angle=vm::pop<real>(Stack);
  real height=vm::pop<real>(Stack);
  real width=vm::pop<real>(Stack);
  string format=vm::pop<string>(Stack,emptystring);
  picture * f=vm::pop<picture *>(Stack);
  string prefix=vm::pop<string>(Stack);
#line 454 "runpicture.in"
  size_t n=checkArrays(lights,diffuse);
  checkEqual(n,checkArray(ambient));
  checkEqual(n,checkArray(specular));
  
  real *T,*Background,*Diffuse,*Ambient,*Specular;
  triple *Lights;

  copyArray2C(T,t,true,4);
  copyArrayC(Background,background);
  copyArrayC(Lights,lights);
  copyArray2C(Diffuse,diffuse,false,4,UseGC);
  copyArray2C(Ambient,ambient,false,4,UseGC);
  copyArray2C(Specular,specular,false,4,UseGC);
    
  f->shipout3(prefix,format,width,height,angle,zoom,m,M,shift,T,Background,n,
              Lights,Diffuse,Ambient,Specular,viewportlighting,view);
  
  delete[] Background;
  delete[] T;
}

#line 476 "runpicture.in"
// void shipout3(string prefix, picture *f);
void gen_runpicture44(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
  string prefix=vm::pop<string>(Stack);
#line 477 "runpicture.in"
  f->shipout3(prefix);
}

#line 481 "runpicture.in"
// void deconstruct(picture *f, picture *preamble=NULL, real magnification=1,                  callableTransform *xform);
void gen_runpicture45(stack *Stack)
{
  callableTransform * xform=vm::pop<callableTransform *>(Stack);
  real magnification=vm::pop<real>(Stack,1);
  picture * preamble=vm::pop<picture *>(Stack,NULL);
  picture * f=vm::pop<picture *>(Stack);
#line 483 "runpicture.in"
  unsigned level=0;
  unsigned n=0;

  string prefix=outname();
  const string xformat="png";

  static long arg_max=sysconf(_SC_ARG_MAX);
  const unsigned maxargs=::min(arg_max/(prefix.size()+xformat.size()+25ul),
                               256ul);
  openpipeout();

  fprintf(pipeout,"%d\n",maxargs);
  fflush(pipeout);
  
  string preformat=nativeformat();
  const string Done="Done";
  const string Error="Error";
  
  mem::vector<string> cmd;
  
  // Enforce ghostscript limitations.
  magnification=::max(magnification,0.0001);
  real res=::min(::max(magnification*72.0,2.0),8192.0);
  
  const char *converter=NULL, *hint=NULL;
  
  if(magnification > 0.0) {
    mem::list<string> nameStack;
    string outname;
    unsigned arg=0;
    unsigned batch=0;
    for(picture::nodelist::iterator p=f->nodes.begin();;) {
      if(p == f->nodes.end()) break;
      if(arg == 0) {
        cmd.clear();
        ostringstream buf;
        buf << batch << "_";
        outname=buildname(prefix+buf.str()+"%d",xformat,"");
        converter="gs";
        hint="Ghostscript";
        cmd.push_back(getSetting<string>(converter));
        cmd.push_back("-q");
        cmd.push_back("-dNOPAUSE");
        cmd.push_back("-dBATCH");
        cmd.push_back("-sDEVICE=pngalpha");
        cmd.push_back("-dEPSCrop");
        if(safe)
          cmd.push_back("-dSAFER");
        cmd.push_back("-r"+String(res)+"x"+String(res));
        cmd.push_back("-sOutputFile="+outname);
      }
      
      picture *group=new picture;
      xform->call(Stack);
      transform t=pop<transform>(Stack);
      assert(*p);
      if((*p)->endgroup()) {
        fprintf(pipeout,"%s\n",Error.c_str());
        fflush(pipeout);
        error(nobegin);
      }
      if((*p)->begingroup()) {
        ++level;
        while(p != f->nodes.end() && level) {
          drawElement *e=t.isIdentity() ? *p : (*p)->transformed(t);
          group->append(e);
          ++p;
          if(p == f->nodes.end()) break;
          assert(*p);
          if((*p)->begingroup()) ++level;
          if((*p)->endgroup()) {
            if(level) --level;
            else {
              fprintf(pipeout,"%s\n",Error.c_str());
              fflush(pipeout);
              error(nobegin);
            }
          }
        }
      }
      if(p != f->nodes.end()) {
        assert(*p);
        drawElement *e=t.isIdentity() ? *p : (*p)->transformed(t);
        group->append(e);
        bbox b;
        ostringstream buf;
        buf << prefix << "_" << n;
        group->shipout(preamble,buf.str(),preformat,magnification,false,false);
        string Preformat=group->Transparency() ? "pdf" : preformat;
        string name=buildname(buf.str(),Preformat);
        nameStack.push_back(name);
        cmd.push_back(name);
        b=group->bounds();
        b *= magnification;
      
        const char *oldlocale=setlocale(LC_NUMERIC,NULL);
        bool override=oldlocale && strcmp(oldlocale,"C") != 0;
        if(override) {
          oldlocale=StrdupNoGC(oldlocale);
          setlocale(LC_NUMERIC,"C");
        }
        
        fprintf(pipeout,"%g %g %g %g\n",b.left,b.right,b.bottom,b.top);
        
        if(override) {
          setlocale(LC_NUMERIC,oldlocale);
          delete[] oldlocale;
        }
        
        fflush(pipeout);
        ++n;
        ++p;
        ++arg;
      }
      
      if(p == f->nodes.end() || arg >= maxargs) {
        arg=0;
        ++batch;
        fflush(pipeout);
  
        int status=System(cmd,0,true,converter,hint);
        if(status) {
          fprintf(pipeout,"%s\n",Error.c_str());
          fflush(pipeout);
          error("deconstruct failed");
        }
      }
    }
    
    if(!getSetting<bool>("keep")) {
      for(mem::list<string>::iterator p=nameStack.begin();
          p != nameStack.end(); ++p)
        unlink(p->c_str());
    }
    
    fprintf(pipeout,"%s\n",Done.c_str());
    fflush(pipeout);
  }
}


// Three-dimensional picture and surface operations

// Bezier curve
#line 628 "runpicture.in"
// void _draw(picture *f, path3 g, triple center=Zero, pen p, Int interaction=0);
void gen_runpicture46(stack *Stack)
{
  Int interaction=vm::pop<Int>(Stack,0);
  pen p=vm::pop<pen>(Stack);
  triple center=vm::pop<triple>(Stack,Zero);
  path3 g=vm::pop<path3>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 629 "runpicture.in"
  if(g.size() > 0)
    f->append(new drawPath3(g,center,p,(Interaction) intcast(interaction)));
}

// Bezier patch
#line 635 "runpicture.in"
// void draw(picture *f, triplearray2 *P, triple center, bool straight,          penarray *p, real opacity, real shininess, real PRCshininess,          triple normal, penarray *colors, Int interaction, bool prc=true);
void gen_runpicture47(stack *Stack)
{
  bool prc=vm::pop<bool>(Stack,true);
  Int interaction=vm::pop<Int>(Stack);
  penarray * colors=vm::pop<penarray *>(Stack);
  triple normal=vm::pop<triple>(Stack);
  real PRCshininess=vm::pop<real>(Stack);
  real shininess=vm::pop<real>(Stack);
  real opacity=vm::pop<real>(Stack);
  penarray * p=vm::pop<penarray *>(Stack);
  bool straight=vm::pop<bool>(Stack);
  triple center=vm::pop<triple>(Stack);
  triplearray2 * P=vm::pop<triplearray2 *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 638 "runpicture.in"
  f->append(new drawSurface(*P,center,straight,*p,opacity,shininess,
                            PRCshininess,normal,*colors,
                            (Interaction) intcast(interaction),prc));
}

// General NURBS curve
#line 645 "runpicture.in"
// void draw(picture *f, triplearray *P, realarray *knot,          realarray *weights=emptyarray, pen p);
void gen_runpicture48(stack *Stack)
{
  pen p=vm::pop<pen>(Stack);
  realarray * weights=vm::pop<realarray *>(Stack,emptyarray);
  realarray * knot=vm::pop<realarray *>(Stack);
  triplearray * P=vm::pop<triplearray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 647 "runpicture.in"
  f->append(new drawNurbsPath3(*P,knot,weights,p));
}

// General NURBS surface
#line 652 "runpicture.in"
// void draw(picture *f, triplearray2 *P, realarray *uknot, realarray *vknot,          realarray2 *weights=emptyarray, penarray *p, real opacity,          real shininess, real PRCshininess, penarray *colors);
void gen_runpicture49(stack *Stack)
{
  penarray * colors=vm::pop<penarray *>(Stack);
  real PRCshininess=vm::pop<real>(Stack);
  real shininess=vm::pop<real>(Stack);
  real opacity=vm::pop<real>(Stack);
  penarray * p=vm::pop<penarray *>(Stack);
  realarray2 * weights=vm::pop<realarray2 *>(Stack,emptyarray);
  realarray * vknot=vm::pop<realarray *>(Stack);
  realarray * uknot=vm::pop<realarray *>(Stack);
  triplearray2 * P=vm::pop<triplearray2 *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 655 "runpicture.in"
  f->append(new drawNurbs(*P,uknot,vknot,weights,*p,opacity,shininess,
                          PRCshininess,*colors));
}

// PRC unit sphere
#line 661 "runpicture.in"
// void drawPRCsphere(picture *f, realarray2 *t, bool half=false, penarray *p,                   real opacity, real shininess, Int type);
void gen_runpicture50(stack *Stack)
{
  Int type=vm::pop<Int>(Stack);
  real shininess=vm::pop<real>(Stack);
  real opacity=vm::pop<real>(Stack);
  penarray * p=vm::pop<penarray *>(Stack);
  bool half=vm::pop<bool>(Stack,false);
  realarray2 * t=vm::pop<realarray2 *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 663 "runpicture.in"
  f->append(new drawSphere(*t,half,*p,opacity,shininess,intcast(type)));
}

// PRC unit cylinder
#line 668 "runpicture.in"
// void drawPRCcylinder(picture *f, realarray2 *t, penarray *p, real opacity,                     real shininess);
void gen_runpicture51(stack *Stack)
{
  real shininess=vm::pop<real>(Stack);
  real opacity=vm::pop<real>(Stack);
  penarray * p=vm::pop<penarray *>(Stack);
  realarray2 * t=vm::pop<realarray2 *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 670 "runpicture.in"
  f->append(new drawCylinder(*t,*p,opacity,shininess));
}

// PRC unit disk
#line 675 "runpicture.in"
// void drawPRCdisk(picture *f, realarray2 *t, penarray *p, real opacity,                 real shininess);
void gen_runpicture52(stack *Stack)
{
  real shininess=vm::pop<real>(Stack);
  real opacity=vm::pop<real>(Stack);
  penarray * p=vm::pop<penarray *>(Stack);
  realarray2 * t=vm::pop<realarray2 *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 677 "runpicture.in"
  f->append(new drawDisk(*t,*p,opacity,shininess));
}

// General PRC tube
#line 682 "runpicture.in"
// void drawPRCtube(picture *f, path3 center, path3 g, penarray *p, real opacity,                 real shininess);
void gen_runpicture53(stack *Stack)
{
  real shininess=vm::pop<real>(Stack);
  real opacity=vm::pop<real>(Stack);
  penarray * p=vm::pop<penarray *>(Stack);
  path3 g=vm::pop<path3>(Stack);
  path3 center=vm::pop<path3>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 684 "runpicture.in"
  f->append(new drawTube(center,g,*p,opacity,shininess));
}

// Draw pixel
#line 689 "runpicture.in"
// void drawpixel(picture *f, triple v, pen p, real width=1.0);
void gen_runpicture54(stack *Stack)
{
  real width=vm::pop<real>(Stack,1.0);
  pen p=vm::pop<pen>(Stack);
  triple v=vm::pop<triple>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 690 "runpicture.in"
  f->append(new drawPixel(v,p,width));
}

// Draw triangles
#line 695 "runpicture.in"
// void draw(picture *f, triplearray *v, Intarray2 *vi,          triplearray *n, Intarray2 *ni,          penarray *p, real opacity, real shininess, real PRCshininess,          penarray *c=emptyarray, Intarray2 *ci=emptyarray);
void gen_runpicture55(stack *Stack)
{
  Intarray2 * ci=vm::pop<Intarray2 *>(Stack,emptyarray);
  penarray * c=vm::pop<penarray *>(Stack,emptyarray);
  real PRCshininess=vm::pop<real>(Stack);
  real shininess=vm::pop<real>(Stack);
  real opacity=vm::pop<real>(Stack);
  penarray * p=vm::pop<penarray *>(Stack);
  Intarray2 * ni=vm::pop<Intarray2 *>(Stack);
  triplearray * n=vm::pop<triplearray *>(Stack);
  Intarray2 * vi=vm::pop<Intarray2 *>(Stack);
  triplearray * v=vm::pop<triplearray *>(Stack);
  picture * f=vm::pop<picture *>(Stack);
#line 699 "runpicture.in"
  f->append(new drawTriangles(*v,*vi,*n,*ni,*p,opacity,shininess,PRCshininess,
                              *c,*ci));
}

#line 704 "runpicture.in"
// triple min3(picture *f);
void gen_runpicture56(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 705 "runpicture.in"
  {Stack->push<triple>(f->bounds3().Min()); return;}
}

#line 709 "runpicture.in"
// triple max3(picture *f);
void gen_runpicture57(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 710 "runpicture.in"
  {Stack->push<triple>(f->bounds3().Max()); return;}
}

#line 714 "runpicture.in"
// triple size3(picture *f);
void gen_runpicture58(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 715 "runpicture.in"
  bbox3 b=f->bounds3();
  {Stack->push<triple>(b.Max()-b.Min()); return;}
}

#line 720 "runpicture.in"
// pair minratio(picture *f);
void gen_runpicture59(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 721 "runpicture.in"
  {Stack->push<pair>(f->ratio(::min)); return;}
}

#line 725 "runpicture.in"
// pair maxratio(picture *f);
void gen_runpicture60(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 726 "runpicture.in"
  {Stack->push<pair>(f->ratio(::max)); return;}
}

#line 730 "runpicture.in"
// bool is3D(picture *f);
void gen_runpicture61(stack *Stack)
{
  picture * f=vm::pop<picture *>(Stack);
#line 731 "runpicture.in"
  {Stack->push<bool>(f->have3D()); return;}
}

} // namespace run

namespace trans {

void gen_runpicture_venv(venv &ve)
{
#line 104 "runpicture.in"
  REGISTER_BLTIN(run::newPicture,"newPicture");
#line 109 "runpicture.in"
  addFunc(ve, run::gen_runpicture1, primBoolean(), SYM(empty), formal(primPicture(), SYM(f), false, false));
#line 114 "runpicture.in"
  addFunc(ve, run::gen_runpicture2, primVoid(), SYM(erase), formal(primPicture(), SYM(f), false, false));
#line 119 "runpicture.in"
  addFunc(ve, run::gen_runpicture3, primPair(), SYM(min), formal(primPicture(), SYM(f), false, false));
#line 124 "runpicture.in"
  addFunc(ve, run::gen_runpicture4, primPair(), SYM(max), formal(primPicture(), SYM(f), false, false));
#line 129 "runpicture.in"
  addFunc(ve, run::gen_runpicture5, primPair(), SYM(size), formal(primPicture(), SYM(f), false, false));
#line 135 "runpicture.in"
  addFunc(ve, run::gen_runpicture6, primVoid(), SYM(_draw), formal(primPicture(), SYM(f), false, false), formal(primPath(), SYM(g), false, false), formal(primPen(), SYM(p), false, false));
#line 140 "runpicture.in"
  addFunc(ve, run::gen_runpicture7, primVoid(), SYM(fill), formal(primPicture(), SYM(f), false, false), formal(pathArray()  , SYM(g), false, false), formal(primPen(), SYM(p), true, false), formal(primBoolean(), SYM(copy), true, false));
#line 146 "runpicture.in"
  addFunc(ve, run::gen_runpicture8, primVoid(), SYM(latticeshade), formal(primPicture(), SYM(f), false, false), formal(pathArray()  , SYM(g), false, false), formal(primBoolean(), SYM(stroke), true, false), formal(primPen(), SYM(fillrule), true, false), formal(penArray2()  , SYM(p), false, false), formal(primTransform(), SYM(t), true, false), formal(primBoolean(), SYM(copy), true, false));
#line 155 "runpicture.in"
  addFunc(ve, run::gen_runpicture9, primVoid(), SYM(axialshade), formal(primPicture(), SYM(f), false, false), formal(pathArray()  , SYM(g), false, false), formal(primBoolean(), SYM(stroke), true, false), formal(primPen(), SYM(pena), false, false), formal(primPair(), SYM(a), false, false), formal(primBoolean(), SYM(extenda), true, false), formal(primPen(), SYM(penb), false, false), formal(primPair(), SYM(b), false, false), formal(primBoolean(), SYM(extendb), true, false), formal(primBoolean(), SYM(copy), true, false));
#line 164 "runpicture.in"
  addFunc(ve, run::gen_runpicture10, primVoid(), SYM(radialshade), formal(primPicture(), SYM(f), false, false), formal(pathArray()  , SYM(g), false, false), formal(primBoolean(), SYM(stroke), true, false), formal(primPen(), SYM(pena), false, false), formal(primPair(), SYM(a), false, false), formal(primReal(), SYM(ra), false, false), formal(primBoolean(), SYM(extenda), true, false), formal(primPen(), SYM(penb), false, false), formal(primPair(), SYM(b), false, false), formal(primReal(), SYM(rb), false, false), formal(primBoolean(), SYM(extendb), true, false), formal(primBoolean(), SYM(copy), true, false));
#line 173 "runpicture.in"
  addFunc(ve, run::gen_runpicture11, primVoid(), SYM(gouraudshade), formal(primPicture(), SYM(f), false, false), formal(pathArray()  , SYM(g), false, false), formal(primBoolean(), SYM(stroke), true, false), formal(primPen(), SYM(fillrule), true, false), formal(penArray()  , SYM(p), false, false), formal(pairArray(), SYM(z), false, false), formal(IntArray(), SYM(edges), false, false), formal(primBoolean(), SYM(copy), true, false));
#line 184 "runpicture.in"
  addFunc(ve, run::gen_runpicture12, primVoid(), SYM(gouraudshade), formal(primPicture(), SYM(f), false, false), formal(pathArray()  , SYM(g), false, false), formal(primBoolean(), SYM(stroke), true, false), formal(primPen(), SYM(fillrule), true, false), formal(penArray()  , SYM(p), false, false), formal(IntArray(), SYM(edges), false, false), formal(primBoolean(), SYM(copy), true, false));
#line 208 "runpicture.in"
  addFunc(ve, run::gen_runpicture13, primVoid(), SYM(tensorshade), formal(primPicture(), SYM(f), false, false), formal(pathArray()  , SYM(g), false, false), formal(primBoolean(), SYM(stroke), true, false), formal(primPen(), SYM(fillrule), true, false), formal(penArray2()  , SYM(p), false, false), formal(pathArray()  , SYM(b), true, false), formal(pairArray2(), SYM(z), true, false), formal(primBoolean(), SYM(copy), true, false));
#line 223 "runpicture.in"
  addFunc(ve, run::gen_runpicture14, primVoid(), SYM(functionshade), formal(primPicture(), SYM(f), false, false), formal(pathArray()  , SYM(g), false, false), formal(primBoolean(), SYM(stroke), true, false), formal(primPen(), SYM(fillrule), true, false), formal(primString() , SYM(shader), true, false), formal(primBoolean(), SYM(copy), true, false));
#line 231 "runpicture.in"
  addFunc(ve, run::gen_runpicture15, primVoid(), SYM(clip), formal(primPicture(), SYM(f), false, false), formal(pathArray()  , SYM(g), false, false), formal(primBoolean(), SYM(stroke), true, false), formal(primPen(), SYM(fillrule), true, false), formal(primBoolean(), SYM(copy), true, false));
#line 241 "runpicture.in"
  addFunc(ve, run::gen_runpicture16, primVoid(), SYM(beginclip), formal(primPicture(), SYM(f), false, false), formal(pathArray()  , SYM(g), false, false), formal(primBoolean(), SYM(stroke), true, false), formal(primPen(), SYM(fillrule), true, false), formal(primBoolean(), SYM(copy), true, false));
#line 248 "runpicture.in"
  addFunc(ve, run::gen_runpicture17, primVoid(), SYM(endclip), formal(primPicture(), SYM(f), false, false));
#line 253 "runpicture.in"
  addFunc(ve, run::gen_runpicture18, primVoid(), SYM(gsave), formal(primPicture(), SYM(f), false, false));
#line 258 "runpicture.in"
  addFunc(ve, run::gen_runpicture19, primVoid(), SYM(grestore), formal(primPicture(), SYM(f), false, false));
#line 263 "runpicture.in"
  addFunc(ve, run::gen_runpicture20, primVoid(), SYM(begingroup), formal(primPicture(), SYM(f), false, false));
#line 268 "runpicture.in"
  addFunc(ve, run::gen_runpicture21, primVoid(), SYM(endgroup), formal(primPicture(), SYM(f), false, false));
#line 273 "runpicture.in"
  addFunc(ve, run::gen_runpicture22, primVoid(), SYM(_begingroup3), formal(primPicture(), SYM(f), false, false), formal(primString() , SYM(name), false, false), formal(primReal(), SYM(compression), false, false), formal(primReal(), SYM(granularity), false, false), formal(primBoolean(), SYM(closed), false, false), formal(primBoolean(), SYM(tessellate), false, false), formal(primBoolean(), SYM(dobreak), false, false), formal(primBoolean(), SYM(nobreak), false, false), formal(primTriple(), SYM(center), false, false), formal(primInt(), SYM(interaction), false, false));
#line 282 "runpicture.in"
  addFunc(ve, run::gen_runpicture23, primVoid(), SYM(endgroup3), formal(primPicture(), SYM(f), false, false));
#line 287 "runpicture.in"
  addFunc(ve, run::gen_runpicture24, primVoid(), SYM(add), formal(primPicture(), SYM(dest), false, false), formal(primPicture(), SYM(src), false, false));
#line 292 "runpicture.in"
  addFunc(ve, run::gen_runpicture25, primVoid(), SYM(prepend), formal(primPicture(), SYM(dest), false, false), formal(primPicture(), SYM(src), false, false));
#line 297 "runpicture.in"
  addFunc(ve, run::gen_runpicture26, primVoid(), SYM(postscript), formal(primPicture(), SYM(f), false, false), formal(primString() , SYM(s), false, false));
#line 302 "runpicture.in"
  addFunc(ve, run::gen_runpicture27, primVoid(), SYM(tex), formal(primPicture(), SYM(f), false, false), formal(primString() , SYM(s), false, false));
#line 307 "runpicture.in"
  addFunc(ve, run::gen_runpicture28, primVoid(), SYM(postscript), formal(primPicture(), SYM(f), false, false), formal(primString() , SYM(s), false, false), formal(primPair(), SYM(min), false, false), formal(primPair(), SYM(max), false, false));
#line 312 "runpicture.in"
  addFunc(ve, run::gen_runpicture29, primVoid(), SYM(tex), formal(primPicture(), SYM(f), false, false), formal(primString() , SYM(s), false, false), formal(primPair(), SYM(min), false, false), formal(primPair(), SYM(max), false, false));
#line 317 "runpicture.in"
  addFunc(ve, run::gen_runpicture30, primVoid(), SYM(texpreamble), formal(primString() , SYM(s), false, false));
#line 325 "runpicture.in"
  addFunc(ve, run::gen_runpicture31, primVoid(), SYM(deletepreamble));
#line 332 "runpicture.in"
  addFunc(ve, run::gen_runpicture32, primVoid(), SYM(_labelpath), formal(primPicture(), SYM(f), false, false), formal(primString() , SYM(s), false, false), formal(primString() , SYM(size), false, false), formal(primPath(), SYM(g), false, false), formal(primString() , SYM(justify), false, false), formal(primPair(), SYM(offset), false, false), formal(primPen(), SYM(p), false, false));
#line 338 "runpicture.in"
  addFunc(ve, run::gen_runpicture33, primVoid(), SYM(texreset));
#line 346 "runpicture.in"
  addFunc(ve, run::gen_runpicture34, primVoid(), SYM(layer), formal(primPicture(), SYM(f), false, false));
#line 351 "runpicture.in"
  addFunc(ve, run::gen_runpicture35, primVoid(), SYM(newpage), formal(primPicture(), SYM(f), false, false));
#line 356 "runpicture.in"
  addFunc(ve, run::gen_runpicture36, primVoid(), SYM(_image), formal(primPicture(), SYM(f), false, false), formal(realArray2(), SYM(data), false, false), formal(primPair(), SYM(initial), false, false), formal(primPair(), SYM(final), false, false), formal(penArray()  , SYM(palette), true, false), formal(primTransform(), SYM(t), true, false), formal(primBoolean(), SYM(copy), true, false), formal(primBoolean(), SYM(antialias), true, false));
#line 366 "runpicture.in"
  addFunc(ve, run::gen_runpicture37, primVoid(), SYM(_image), formal(primPicture(), SYM(f), false, false), formal(penArray2()  , SYM(data), false, false), formal(primPair(), SYM(initial), false, false), formal(primPair(), SYM(final), false, false), formal(primTransform(), SYM(t), true, false), formal(primBoolean(), SYM(copy), true, false), formal(primBoolean(), SYM(antialias), true, false));
#line 374 "runpicture.in"
  addFunc(ve, run::gen_runpicture38, primVoid(), SYM(_image), formal(primPicture(), SYM(f), false, false), formal(penFunction(), SYM(f), false, false), formal(primInt(), SYM(width), false, false), formal(primInt(), SYM(height), false, false), formal(primPair(), SYM(initial), false, false), formal(primPair(), SYM(final), false, false), formal(primTransform(), SYM(t), true, false), formal(primBoolean(), SYM(antialias), true, false));
#line 381 "runpicture.in"
  addFunc(ve, run::gen_runpicture39, primString() , SYM(nativeformat));
#line 386 "runpicture.in"
  addFunc(ve, run::gen_runpicture40, primBoolean(), SYM(latex));
#line 391 "runpicture.in"
  addFunc(ve, run::gen_runpicture41, primBoolean(), SYM(pdf));
#line 396 "runpicture.in"
  addFunc(ve, run::gen_runpicture42, primVoid(), SYM(shipout), formal(primString() , SYM(prefix), true, false), formal(primPicture(), SYM(f), false, false), formal(primPicture(), SYM(preamble), true, false), formal(primString() , SYM(format), true, false), formal(primBoolean(), SYM(wait), true, false), formal(primBoolean(), SYM(view), true, false), formal(transformFunction(), SYM(xform), false, false));
#line 448 "runpicture.in"
  addFunc(ve, run::gen_runpicture43, primVoid(), SYM(shipout3), formal(primString() , SYM(prefix), false, false), formal(primPicture(), SYM(f), false, false), formal(primString() , SYM(format), true, false), formal(primReal(), SYM(width), false, false), formal(primReal(), SYM(height), false, false), formal(primReal(), SYM(angle), false, false), formal(primReal(), SYM(zoom), false, false), formal(primTriple(), SYM(m), false, false), formal(primTriple(), SYM(m), false, false), formal(primPair(), SYM(shift), false, false), formal(realArray2(), SYM(t), false, false), formal(realArray(), SYM(background), false, false), formal(tripleArray(), SYM(lights), false, false), formal(realArray2(), SYM(diffuse), false, false), formal(realArray2(), SYM(ambient), false, false), formal(realArray2(), SYM(specular), false, false), formal(primBoolean(), SYM(viewportlighting), false, false), formal(primBoolean(), SYM(view), true, false));
#line 476 "runpicture.in"
  addFunc(ve, run::gen_runpicture44, primVoid(), SYM(shipout3), formal(primString() , SYM(prefix), false, false), formal(primPicture(), SYM(f), false, false));
#line 481 "runpicture.in"
  addFunc(ve, run::gen_runpicture45, primVoid(), SYM(deconstruct), formal(primPicture(), SYM(f), false, false), formal(primPicture(), SYM(preamble), true, false), formal(primReal(), SYM(magnification), true, false), formal(transformFunction(), SYM(xform), false, false));
#line 624 "runpicture.in"
  addFunc(ve, run::gen_runpicture46, primVoid(), SYM(_draw), formal(primPicture(), SYM(f), false, false), formal(primPath3(), SYM(g), false, false), formal(primTriple(), SYM(center), true, false), formal(primPen(), SYM(p), false, false), formal(primInt(), SYM(interaction), true, false));
#line 634 "runpicture.in"
  addFunc(ve, run::gen_runpicture47, primVoid(), SYM(draw), formal(primPicture(), SYM(f), false, false), formal(tripleArray2(), SYM(p), false, false), formal(primTriple(), SYM(center), false, false), formal(primBoolean(), SYM(straight), false, false), formal(penArray()  , SYM(p), false, false), formal(primReal(), SYM(opacity), false, false), formal(primReal(), SYM(shininess), false, false), formal(primReal(), SYM(prcshininess), false, false), formal(primTriple(), SYM(normal), false, false), formal(penArray()  , SYM(colors), false, false), formal(primInt(), SYM(interaction), false, false), formal(primBoolean(), SYM(prc), true, false));
#line 644 "runpicture.in"
  addFunc(ve, run::gen_runpicture48, primVoid(), SYM(draw), formal(primPicture(), SYM(f), false, false), formal(tripleArray(), SYM(p), false, false), formal(realArray(), SYM(knot), false, false), formal(realArray(), SYM(weights), true, false), formal(primPen(), SYM(p), false, false));
#line 651 "runpicture.in"
  addFunc(ve, run::gen_runpicture49, primVoid(), SYM(draw), formal(primPicture(), SYM(f), false, false), formal(tripleArray2(), SYM(p), false, false), formal(realArray(), SYM(uknot), false, false), formal(realArray(), SYM(vknot), false, false), formal(realArray2(), SYM(weights), true, false), formal(penArray()  , SYM(p), false, false), formal(primReal(), SYM(opacity), false, false), formal(primReal(), SYM(shininess), false, false), formal(primReal(), SYM(prcshininess), false, false), formal(penArray()  , SYM(colors), false, false));
#line 660 "runpicture.in"
  addFunc(ve, run::gen_runpicture50, primVoid(), SYM(drawPRCsphere), formal(primPicture(), SYM(f), false, false), formal(realArray2(), SYM(t), false, false), formal(primBoolean(), SYM(half), true, false), formal(penArray()  , SYM(p), false, false), formal(primReal(), SYM(opacity), false, false), formal(primReal(), SYM(shininess), false, false), formal(primInt(), SYM(type), false, false));
#line 667 "runpicture.in"
  addFunc(ve, run::gen_runpicture51, primVoid(), SYM(drawPRCcylinder), formal(primPicture(), SYM(f), false, false), formal(realArray2(), SYM(t), false, false), formal(penArray()  , SYM(p), false, false), formal(primReal(), SYM(opacity), false, false), formal(primReal(), SYM(shininess), false, false));
#line 674 "runpicture.in"
  addFunc(ve, run::gen_runpicture52, primVoid(), SYM(drawPRCdisk), formal(primPicture(), SYM(f), false, false), formal(realArray2(), SYM(t), false, false), formal(penArray()  , SYM(p), false, false), formal(primReal(), SYM(opacity), false, false), formal(primReal(), SYM(shininess), false, false));
#line 681 "runpicture.in"
  addFunc(ve, run::gen_runpicture53, primVoid(), SYM(drawPRCtube), formal(primPicture(), SYM(f), false, false), formal(primPath3(), SYM(center), false, false), formal(primPath3(), SYM(g), false, false), formal(penArray()  , SYM(p), false, false), formal(primReal(), SYM(opacity), false, false), formal(primReal(), SYM(shininess), false, false));
#line 688 "runpicture.in"
  addFunc(ve, run::gen_runpicture54, primVoid(), SYM(drawpixel), formal(primPicture(), SYM(f), false, false), formal(primTriple(), SYM(v), false, false), formal(primPen(), SYM(p), false, false), formal(primReal(), SYM(width), true, false));
#line 694 "runpicture.in"
  addFunc(ve, run::gen_runpicture55, primVoid(), SYM(draw), formal(primPicture(), SYM(f), false, false), formal(tripleArray(), SYM(v), false, false), formal(IntArray2(), SYM(vi), false, false), formal(tripleArray(), SYM(n), false, false), formal(IntArray2(), SYM(ni), false, false), formal(penArray()  , SYM(p), false, false), formal(primReal(), SYM(opacity), false, false), formal(primReal(), SYM(shininess), false, false), formal(primReal(), SYM(prcshininess), false, false), formal(penArray()  , SYM(c), true, false), formal(IntArray2(), SYM(ci), true, false));
#line 704 "runpicture.in"
  addFunc(ve, run::gen_runpicture56, primTriple(), SYM(min3), formal(primPicture(), SYM(f), false, false));
#line 709 "runpicture.in"
  addFunc(ve, run::gen_runpicture57, primTriple(), SYM(max3), formal(primPicture(), SYM(f), false, false));
#line 714 "runpicture.in"
  addFunc(ve, run::gen_runpicture58, primTriple(), SYM(size3), formal(primPicture(), SYM(f), false, false));
#line 720 "runpicture.in"
  addFunc(ve, run::gen_runpicture59, primPair(), SYM(minratio), formal(primPicture(), SYM(f), false, false));
#line 725 "runpicture.in"
  addFunc(ve, run::gen_runpicture60, primPair(), SYM(maxratio), formal(primPicture(), SYM(f), false, false));
#line 730 "runpicture.in"
  addFunc(ve, run::gen_runpicture61, primBoolean(), SYM(is3D), formal(primPicture(), SYM(f), false, false));
}

} // namespace trans
