function X = rint(num,k);
% X = RINT(num,k)
%        Input   num     positive integer or a vector [lig,col] of integers
%                k       positive integer
%        Output  X       num-vector or a num-matrix of random numbers
%                        chosen from uniform distribution on {1,...,k}
%
% Renvoie num ralisations ou une matrice [lig,col] de ralisations 
% pseudo-indpendantes de la loi uniforme discrte sur les k premiers 
% entiers non nuls {1,...,k}.
%
% La mthode consiste  considrer la partie entire de 1+kU o U suit une loi
% uniforme sur [0,1]. Cette dernire s'obtient via la fonction rand, et les
% valeurs renvoyes par des appels successifs sont donc pseudo-indpendantes. 
%
% ### Copyright (C) D. Chafa, 2003-12-06.
% ### http://www.lsp.ups-tlse.fr/Chafai/agregation.html
% ### Licence GNU General Public License http://www.gnu.org/copyleft/gpl.html
%

if length(num) == 1
   num = [num 1];
end
X = ceil(k * rand(num));
return;
