#include <solid_includes.h>

#include <smoke.h>
#include <solid_smoke.h>

namespace __smokesolid {

static void *cast(void *xptr, Smoke::Index from, Smoke::Index to) {
  switch(from) {
    case 1:   //QBool
      switch(to) {
        case 1: return (void*)(QBool*)xptr;
        default: return xptr;
      }
    case 2:   //QChildEvent
      switch(to) {
        case 2: return (void*)(QChildEvent*)xptr;
        default: return xptr;
      }
    case 3:   //QEvent
      switch(to) {
        case 3: return (void*)(QEvent*)xptr;
        default: return xptr;
      }
    case 5:   //QMetaObject
      switch(to) {
        case 5: return (void*)(QMetaObject*)xptr;
        default: return xptr;
      }
    case 6:   //QObject
      switch(to) {
        case 6: return (void*)(QObject*)xptr;
        case 21: return (void*)(Solid::DvbInterface*)(QObject*)xptr;
        case 23: return (void*)(Solid::NetworkInterface*)(QObject*)xptr;
        case 25: return (void*)(Solid::Networking::Notifier*)(QObject*)xptr;
        case 33: return (void*)(Solid::StorageAccess*)(QObject*)xptr;
        case 35: return (void*)(Solid::StorageDrive*)(QObject*)xptr;
        case 28: return (void*)(Solid::PortableMediaPlayer*)(QObject*)xptr;
        case 12: return (void*)(Solid::AudioInterface*)(QObject*)xptr;
        case 20: return (void*)(Solid::DeviceNotifier*)(QObject*)xptr;
        case 37: return (void*)(Solid::StorageVolume*)(QObject*)xptr;
        case 39: return (void*)(Solid::Video*)(QObject*)xptr;
        case 32: return (void*)(Solid::Processor*)(QObject*)xptr;
        case 13: return (void*)(Solid::Battery*)(QObject*)xptr;
        case 22: return (void*)(Solid::GenericInterface*)(QObject*)xptr;
        case 27: return (void*)(Solid::OpticalDrive*)(QObject*)xptr;
        case 11: return (void*)(Solid::AcAdapter*)(QObject*)xptr;
        case 15: return (void*)(Solid::Button*)(QObject*)xptr;
        case 14: return (void*)(Solid::Block*)(QObject*)xptr;
        case 30: return (void*)(Solid::PowerManagement::Notifier*)(QObject*)xptr;
        case 16: return (void*)(Solid::Camera*)(QObject*)xptr;
        case 18: return (void*)(Solid::DeviceInterface*)(QObject*)xptr;
        case 26: return (void*)(Solid::OpticalDisc*)(QObject*)xptr;
        default: return xptr;
      }
    case 7:   //QRegExp
      switch(to) {
        case 7: return (void*)(QRegExp*)xptr;
        default: return xptr;
      }
    case 8:   //QTimerEvent
      switch(to) {
        case 8: return (void*)(QTimerEvent*)xptr;
        default: return xptr;
      }
    case 9:   //QVariant
      switch(to) {
        case 9: return (void*)(QVariant*)xptr;
        default: return xptr;
      }
    case 11:   //Solid::AcAdapter
      switch(to) {
        case 18: return (void*)(Solid::DeviceInterface*)(Solid::AcAdapter*)xptr;
        case 6: return (void*)(QObject*)(Solid::AcAdapter*)xptr;
        case 11: return (void*)(Solid::AcAdapter*)xptr;
        default: return xptr;
      }
    case 12:   //Solid::AudioInterface
      switch(to) {
        case 18: return (void*)(Solid::DeviceInterface*)(Solid::AudioInterface*)xptr;
        case 6: return (void*)(QObject*)(Solid::AudioInterface*)xptr;
        case 12: return (void*)(Solid::AudioInterface*)xptr;
        default: return xptr;
      }
    case 13:   //Solid::Battery
      switch(to) {
        case 18: return (void*)(Solid::DeviceInterface*)(Solid::Battery*)xptr;
        case 6: return (void*)(QObject*)(Solid::Battery*)xptr;
        case 13: return (void*)(Solid::Battery*)xptr;
        default: return xptr;
      }
    case 14:   //Solid::Block
      switch(to) {
        case 18: return (void*)(Solid::DeviceInterface*)(Solid::Block*)xptr;
        case 6: return (void*)(QObject*)(Solid::Block*)xptr;
        case 14: return (void*)(Solid::Block*)xptr;
        default: return xptr;
      }
    case 15:   //Solid::Button
      switch(to) {
        case 18: return (void*)(Solid::DeviceInterface*)(Solid::Button*)xptr;
        case 6: return (void*)(QObject*)(Solid::Button*)xptr;
        case 15: return (void*)(Solid::Button*)xptr;
        default: return xptr;
      }
    case 16:   //Solid::Camera
      switch(to) {
        case 18: return (void*)(Solid::DeviceInterface*)(Solid::Camera*)xptr;
        case 6: return (void*)(QObject*)(Solid::Camera*)xptr;
        case 16: return (void*)(Solid::Camera*)xptr;
        default: return xptr;
      }
    case 17:   //Solid::Device
      switch(to) {
        case 17: return (void*)(Solid::Device*)xptr;
        default: return xptr;
      }
    case 18:   //Solid::DeviceInterface
      switch(to) {
        case 6: return (void*)(QObject*)(Solid::DeviceInterface*)xptr;
        case 18: return (void*)(Solid::DeviceInterface*)xptr;
        case 21: return (void*)(Solid::DvbInterface*)(Solid::DeviceInterface*)xptr;
        case 23: return (void*)(Solid::NetworkInterface*)(Solid::DeviceInterface*)xptr;
        case 33: return (void*)(Solid::StorageAccess*)(Solid::DeviceInterface*)xptr;
        case 35: return (void*)(Solid::StorageDrive*)(Solid::DeviceInterface*)xptr;
        case 28: return (void*)(Solid::PortableMediaPlayer*)(Solid::DeviceInterface*)xptr;
        case 12: return (void*)(Solid::AudioInterface*)(Solid::DeviceInterface*)xptr;
        case 37: return (void*)(Solid::StorageVolume*)(Solid::DeviceInterface*)xptr;
        case 39: return (void*)(Solid::Video*)(Solid::DeviceInterface*)xptr;
        case 32: return (void*)(Solid::Processor*)(Solid::DeviceInterface*)xptr;
        case 13: return (void*)(Solid::Battery*)(Solid::DeviceInterface*)xptr;
        case 22: return (void*)(Solid::GenericInterface*)(Solid::DeviceInterface*)xptr;
        case 27: return (void*)(Solid::OpticalDrive*)(Solid::DeviceInterface*)xptr;
        case 11: return (void*)(Solid::AcAdapter*)(Solid::DeviceInterface*)xptr;
        case 15: return (void*)(Solid::Button*)(Solid::DeviceInterface*)xptr;
        case 14: return (void*)(Solid::Block*)(Solid::DeviceInterface*)xptr;
        case 16: return (void*)(Solid::Camera*)(Solid::DeviceInterface*)xptr;
        case 26: return (void*)(Solid::OpticalDisc*)(Solid::DeviceInterface*)xptr;
        default: return xptr;
      }
    case 19:   //Solid::DeviceInterfacePrivate
      switch(to) {
        case 19: return (void*)(Solid::DeviceInterfacePrivate*)xptr;
        default: return xptr;
      }
    case 20:   //Solid::DeviceNotifier
      switch(to) {
        case 6: return (void*)(QObject*)(Solid::DeviceNotifier*)xptr;
        case 20: return (void*)(Solid::DeviceNotifier*)xptr;
        default: return xptr;
      }
    case 21:   //Solid::DvbInterface
      switch(to) {
        case 18: return (void*)(Solid::DeviceInterface*)(Solid::DvbInterface*)xptr;
        case 6: return (void*)(QObject*)(Solid::DvbInterface*)xptr;
        case 21: return (void*)(Solid::DvbInterface*)xptr;
        default: return xptr;
      }
    case 22:   //Solid::GenericInterface
      switch(to) {
        case 18: return (void*)(Solid::DeviceInterface*)(Solid::GenericInterface*)xptr;
        case 6: return (void*)(QObject*)(Solid::GenericInterface*)xptr;
        case 22: return (void*)(Solid::GenericInterface*)xptr;
        default: return xptr;
      }
    case 23:   //Solid::NetworkInterface
      switch(to) {
        case 18: return (void*)(Solid::DeviceInterface*)(Solid::NetworkInterface*)xptr;
        case 6: return (void*)(QObject*)(Solid::NetworkInterface*)xptr;
        case 23: return (void*)(Solid::NetworkInterface*)xptr;
        default: return xptr;
      }
    case 25:   //Solid::Networking::Notifier
      switch(to) {
        case 6: return (void*)(QObject*)(Solid::Networking::Notifier*)xptr;
        case 25: return (void*)(Solid::Networking::Notifier*)xptr;
        default: return xptr;
      }
    case 26:   //Solid::OpticalDisc
      switch(to) {
        case 37: return (void*)(Solid::StorageVolume*)(Solid::OpticalDisc*)xptr;
        case 18: return (void*)(Solid::DeviceInterface*)(Solid::OpticalDisc*)xptr;
        case 6: return (void*)(QObject*)(Solid::OpticalDisc*)xptr;
        case 26: return (void*)(Solid::OpticalDisc*)xptr;
        default: return xptr;
      }
    case 27:   //Solid::OpticalDrive
      switch(to) {
        case 35: return (void*)(Solid::StorageDrive*)(Solid::OpticalDrive*)xptr;
        case 18: return (void*)(Solid::DeviceInterface*)(Solid::OpticalDrive*)xptr;
        case 6: return (void*)(QObject*)(Solid::OpticalDrive*)xptr;
        case 27: return (void*)(Solid::OpticalDrive*)xptr;
        default: return xptr;
      }
    case 28:   //Solid::PortableMediaPlayer
      switch(to) {
        case 18: return (void*)(Solid::DeviceInterface*)(Solid::PortableMediaPlayer*)xptr;
        case 6: return (void*)(QObject*)(Solid::PortableMediaPlayer*)xptr;
        case 28: return (void*)(Solid::PortableMediaPlayer*)xptr;
        default: return xptr;
      }
    case 30:   //Solid::PowerManagement::Notifier
      switch(to) {
        case 6: return (void*)(QObject*)(Solid::PowerManagement::Notifier*)xptr;
        case 30: return (void*)(Solid::PowerManagement::Notifier*)xptr;
        default: return xptr;
      }
    case 31:   //Solid::Predicate
      switch(to) {
        case 31: return (void*)(Solid::Predicate*)xptr;
        default: return xptr;
      }
    case 32:   //Solid::Processor
      switch(to) {
        case 18: return (void*)(Solid::DeviceInterface*)(Solid::Processor*)xptr;
        case 6: return (void*)(QObject*)(Solid::Processor*)xptr;
        case 32: return (void*)(Solid::Processor*)xptr;
        default: return xptr;
      }
    case 33:   //Solid::StorageAccess
      switch(to) {
        case 18: return (void*)(Solid::DeviceInterface*)(Solid::StorageAccess*)xptr;
        case 6: return (void*)(QObject*)(Solid::StorageAccess*)xptr;
        case 33: return (void*)(Solid::StorageAccess*)xptr;
        default: return xptr;
      }
    case 34:   //Solid::StorageAccessPrivate
      switch(to) {
        case 34: return (void*)(Solid::StorageAccessPrivate*)xptr;
        default: return xptr;
      }
    case 35:   //Solid::StorageDrive
      switch(to) {
        case 18: return (void*)(Solid::DeviceInterface*)(Solid::StorageDrive*)xptr;
        case 6: return (void*)(QObject*)(Solid::StorageDrive*)xptr;
        case 35: return (void*)(Solid::StorageDrive*)xptr;
        case 27: return (void*)(Solid::OpticalDrive*)(Solid::StorageDrive*)xptr;
        default: return xptr;
      }
    case 36:   //Solid::StorageDrivePrivate
      switch(to) {
        case 36: return (void*)(Solid::StorageDrivePrivate*)xptr;
        default: return xptr;
      }
    case 37:   //Solid::StorageVolume
      switch(to) {
        case 18: return (void*)(Solid::DeviceInterface*)(Solid::StorageVolume*)xptr;
        case 6: return (void*)(QObject*)(Solid::StorageVolume*)xptr;
        case 37: return (void*)(Solid::StorageVolume*)xptr;
        case 26: return (void*)(Solid::OpticalDisc*)(Solid::StorageVolume*)xptr;
        default: return xptr;
      }
    case 38:   //Solid::StorageVolumePrivate
      switch(to) {
        case 38: return (void*)(Solid::StorageVolumePrivate*)xptr;
        default: return xptr;
      }
    case 39:   //Solid::Video
      switch(to) {
        case 18: return (void*)(Solid::DeviceInterface*)(Solid::Video*)xptr;
        case 6: return (void*)(QObject*)(Solid::Video*)xptr;
        case 39: return (void*)(Solid::Video*)xptr;
        default: return xptr;
      }
    default: return xptr;
  }
}

// Group of Indexes (0 separated) used as super class lists.
// Classes with super classes have an index into this array.
static Smoke::Index inheritanceList[] = {
    0,	// 0: (no super class)
    18, 0,	// 1: Solid::DeviceInterface
    6, 0,	// 3: QObject
    37, 0,	// 5: Solid::StorageVolume
    35, 0,	// 7: Solid::StorageDrive
};

// These are the xenum functions for manipulating enum pointers
void xenum_Solid__StorageDrive(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Solid__Predicate(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Solid__DeviceInterface(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Solid__Processor(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Solid__PowerManagement(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Solid__Networking(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Solid(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Solid__Button(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Solid__DvbInterface(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Solid__OpticalDrive(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Solid__Battery(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Solid__GenericInterface(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Solid__AudioInterface(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Solid__OpticalDisc(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Solid__StorageVolume(Smoke::EnumOperation, Smoke::Index, void*&, long&);

// Those are the xcall functions defined in each x_*.cpp file, for dispatching method calls
void xcall_QGlobalSpace(Smoke::Index, void*, Smoke::Stack);
void xcall_Solid(Smoke::Index, void*, Smoke::Stack);
void xcall_Solid__AcAdapter(Smoke::Index, void*, Smoke::Stack);
void xcall_Solid__AudioInterface(Smoke::Index, void*, Smoke::Stack);
void xcall_Solid__Battery(Smoke::Index, void*, Smoke::Stack);
void xcall_Solid__Block(Smoke::Index, void*, Smoke::Stack);
void xcall_Solid__Button(Smoke::Index, void*, Smoke::Stack);
void xcall_Solid__Camera(Smoke::Index, void*, Smoke::Stack);
void xcall_Solid__Device(Smoke::Index, void*, Smoke::Stack);
void xcall_Solid__DeviceInterface(Smoke::Index, void*, Smoke::Stack);
void xcall_Solid__DeviceNotifier(Smoke::Index, void*, Smoke::Stack);
void xcall_Solid__DvbInterface(Smoke::Index, void*, Smoke::Stack);
void xcall_Solid__GenericInterface(Smoke::Index, void*, Smoke::Stack);
void xcall_Solid__NetworkInterface(Smoke::Index, void*, Smoke::Stack);
void xcall_Solid__Networking(Smoke::Index, void*, Smoke::Stack);
void xcall_Solid__Networking__Notifier(Smoke::Index, void*, Smoke::Stack);
void xcall_Solid__OpticalDisc(Smoke::Index, void*, Smoke::Stack);
void xcall_Solid__OpticalDrive(Smoke::Index, void*, Smoke::Stack);
void xcall_Solid__PortableMediaPlayer(Smoke::Index, void*, Smoke::Stack);
void xcall_Solid__PowerManagement(Smoke::Index, void*, Smoke::Stack);
void xcall_Solid__PowerManagement__Notifier(Smoke::Index, void*, Smoke::Stack);
void xcall_Solid__Predicate(Smoke::Index, void*, Smoke::Stack);
void xcall_Solid__Processor(Smoke::Index, void*, Smoke::Stack);
void xcall_Solid__StorageAccess(Smoke::Index, void*, Smoke::Stack);
void xcall_Solid__StorageDrive(Smoke::Index, void*, Smoke::Stack);
void xcall_Solid__StorageVolume(Smoke::Index, void*, Smoke::Stack);
void xcall_Solid__Video(Smoke::Index, void*, Smoke::Stack);

// List of all classes
// Name, external, index into inheritanceList, method dispatcher, enum dispatcher, class flags, size
static Smoke::Class classes[] = {
    { 0L, false, 0, 0, 0, 0, 0 },	// 0 (no class)
    { "QBool", true, 0, 0, 0, 0, 0 },	//1
    { "QChildEvent", true, 0, 0, 0, 0, 0 },	//2
    { "QEvent", true, 0, 0, 0, 0, 0 },	//3
    { "QGlobalSpace", false, 0, xcall_QGlobalSpace, 0, Smoke::cf_namespace, 0 },	//4
    { "QMetaObject", true, 0, 0, 0, 0, 0 },	//5
    { "QObject", true, 0, 0, 0, 0, 0 },	//6
    { "QRegExp", true, 0, 0, 0, 0, 0 },	//7
    { "QTimerEvent", true, 0, 0, 0, 0, 0 },	//8
    { "QVariant", true, 0, 0, 0, 0, 0 },	//9
    { "Solid", false, 0, xcall_Solid, xenum_Solid, Smoke::cf_namespace, 0 },	//10
    { "Solid::AcAdapter", false, 1, xcall_Solid__AcAdapter, 0, Smoke::cf_virtual, sizeof(Solid::AcAdapter) },	//11
    { "Solid::AudioInterface", false, 1, xcall_Solid__AudioInterface, xenum_Solid__AudioInterface, Smoke::cf_virtual, sizeof(Solid::AudioInterface) },	//12
    { "Solid::Battery", false, 1, xcall_Solid__Battery, xenum_Solid__Battery, Smoke::cf_virtual, sizeof(Solid::Battery) },	//13
    { "Solid::Block", false, 1, xcall_Solid__Block, 0, Smoke::cf_virtual, sizeof(Solid::Block) },	//14
    { "Solid::Button", false, 1, xcall_Solid__Button, xenum_Solid__Button, Smoke::cf_virtual, sizeof(Solid::Button) },	//15
    { "Solid::Camera", false, 1, xcall_Solid__Camera, 0, Smoke::cf_virtual, sizeof(Solid::Camera) },	//16
    { "Solid::Device", false, 0, xcall_Solid__Device, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(Solid::Device) },	//17
    { "Solid::DeviceInterface", false, 3, xcall_Solid__DeviceInterface, xenum_Solid__DeviceInterface, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Solid::DeviceInterface) },	//18
    { "Solid::DeviceInterfacePrivate", true, 0, 0, 0, 0, 0 },	//19
    { "Solid::DeviceNotifier", false, 3, xcall_Solid__DeviceNotifier, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Solid::DeviceNotifier) },	//20
    { "Solid::DvbInterface", false, 1, xcall_Solid__DvbInterface, xenum_Solid__DvbInterface, Smoke::cf_virtual, sizeof(Solid::DvbInterface) },	//21
    { "Solid::GenericInterface", false, 1, xcall_Solid__GenericInterface, xenum_Solid__GenericInterface, Smoke::cf_virtual, sizeof(Solid::GenericInterface) },	//22
    { "Solid::NetworkInterface", false, 1, xcall_Solid__NetworkInterface, 0, Smoke::cf_virtual, sizeof(Solid::NetworkInterface) },	//23
    { "Solid::Networking", false, 0, xcall_Solid__Networking, xenum_Solid__Networking, Smoke::cf_namespace, 0 },	//24
    { "Solid::Networking::Notifier", false, 3, xcall_Solid__Networking__Notifier, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Solid::Networking::Notifier) },	//25
    { "Solid::OpticalDisc", false, 5, xcall_Solid__OpticalDisc, xenum_Solid__OpticalDisc, Smoke::cf_virtual, sizeof(Solid::OpticalDisc) },	//26
    { "Solid::OpticalDrive", false, 7, xcall_Solid__OpticalDrive, xenum_Solid__OpticalDrive, Smoke::cf_virtual, sizeof(Solid::OpticalDrive) },	//27
    { "Solid::PortableMediaPlayer", false, 1, xcall_Solid__PortableMediaPlayer, 0, Smoke::cf_virtual, sizeof(Solid::PortableMediaPlayer) },	//28
    { "Solid::PowerManagement", false, 0, xcall_Solid__PowerManagement, xenum_Solid__PowerManagement, Smoke::cf_namespace, 0 },	//29
    { "Solid::PowerManagement::Notifier", false, 3, xcall_Solid__PowerManagement__Notifier, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Solid::PowerManagement::Notifier) },	//30
    { "Solid::Predicate", false, 0, xcall_Solid__Predicate, xenum_Solid__Predicate, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(Solid::Predicate) },	//31
    { "Solid::Processor", false, 1, xcall_Solid__Processor, xenum_Solid__Processor, Smoke::cf_virtual, sizeof(Solid::Processor) },	//32
    { "Solid::StorageAccess", false, 1, xcall_Solid__StorageAccess, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Solid::StorageAccess) },	//33
    { "Solid::StorageAccessPrivate", true, 0, 0, 0, 0, 0 },	//34
    { "Solid::StorageDrive", false, 1, xcall_Solid__StorageDrive, xenum_Solid__StorageDrive, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Solid::StorageDrive) },	//35
    { "Solid::StorageDrivePrivate", true, 0, 0, 0, 0, 0 },	//36
    { "Solid::StorageVolume", false, 1, xcall_Solid__StorageVolume, xenum_Solid__StorageVolume, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Solid::StorageVolume) },	//37
    { "Solid::StorageVolumePrivate", true, 0, 0, 0, 0, 0 },	//38
    { "Solid::Video", false, 1, xcall_Solid__Video, 0, Smoke::cf_virtual, sizeof(Solid::Video) },	//39
};

// List of all types needed by the methods (arguments and return values)
// Name, class ID if arg is a class, and TypeId
static Smoke::Type types[] = {
    { 0, 0, 0 },	//0 (no type)
    { "QBool", 1, Smoke::t_class|Smoke::tf_stack },	//1
    { "QChildEvent*", 2, Smoke::t_class|Smoke::tf_ptr },	//2
    { "QEvent*", 3, Smoke::t_class|Smoke::tf_ptr },	//3
    { "QFlags<Solid::AudioInterface::AudioInterfaceType>", 0, Smoke::t_uint|Smoke::tf_stack },	//4
    { "QFlags<Solid::OpticalDisc::ContentType>", 0, Smoke::t_uint|Smoke::tf_stack },	//5
    { "QFlags<Solid::OpticalDrive::MediumType>", 0, Smoke::t_uint|Smoke::tf_stack },	//6
    { "QFlags<Solid::Processor::InstructionSet>", 0, Smoke::t_uint|Smoke::tf_stack },	//7
    { "QList<Solid::Device>", 0, Smoke::t_voidp|Smoke::tf_stack },	//8
    { "QList<int>", 0, Smoke::t_voidp|Smoke::tf_stack },	//9
    { "QMap<QString,QVariant>", 0, Smoke::t_voidp|Smoke::tf_stack },	//10
    { "QMap<QString,int>", 0, Smoke::t_voidp|Smoke::tf_stack },	//11
    { "QMetaObject::Call", 5, Smoke::t_enum|Smoke::tf_stack },	//12
    { "QObject*", 6, Smoke::t_class|Smoke::tf_ptr },	//13
    { "QRegExp&", 7, Smoke::t_class|Smoke::tf_ref },	//14
    { "QSet<Solid::DeviceInterface::Type>", 0, Smoke::t_voidp|Smoke::tf_stack },	//15
    { "QSet<Solid::PowerManagement::SleepState>", 0, Smoke::t_voidp|Smoke::tf_stack },	//16
    { "QString", 0, Smoke::t_voidp|Smoke::tf_stack },	//17
    { "QStringList", 0, Smoke::t_voidp|Smoke::tf_stack },	//18
    { "QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//19
    { "QTimerEvent*", 8, Smoke::t_class|Smoke::tf_ptr },	//20
    { "QVariant", 9, Smoke::t_class|Smoke::tf_stack },	//21
    { "Qt::AlignmentFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//22
    { "Qt::AnchorAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//23
    { "Qt::AnchorPoint", 0, Smoke::t_enum|Smoke::tf_stack },	//24
    { "Qt::ApplicationAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//25
    { "Qt::ArrowType", 0, Smoke::t_enum|Smoke::tf_stack },	//26
    { "Qt::AspectRatioMode", 0, Smoke::t_enum|Smoke::tf_stack },	//27
    { "Qt::Axis", 0, Smoke::t_enum|Smoke::tf_stack },	//28
    { "Qt::BGMode", 0, Smoke::t_enum|Smoke::tf_stack },	//29
    { "Qt::BrushStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//30
    { "Qt::CaseSensitivity", 0, Smoke::t_enum|Smoke::tf_stack },	//31
    { "Qt::CheckState", 0, Smoke::t_enum|Smoke::tf_stack },	//32
    { "Qt::ClipOperation", 0, Smoke::t_enum|Smoke::tf_stack },	//33
    { "Qt::ConnectionType", 0, Smoke::t_enum|Smoke::tf_stack },	//34
    { "Qt::ContextMenuPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//35
    { "Qt::CoordinateSystem", 0, Smoke::t_enum|Smoke::tf_stack },	//36
    { "Qt::Corner", 0, Smoke::t_enum|Smoke::tf_stack },	//37
    { "Qt::CursorMoveStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//38
    { "Qt::CursorShape", 0, Smoke::t_enum|Smoke::tf_stack },	//39
    { "Qt::DateFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//40
    { "Qt::DayOfWeek", 0, Smoke::t_enum|Smoke::tf_stack },	//41
    { "Qt::DockWidgetArea", 0, Smoke::t_enum|Smoke::tf_stack },	//42
    { "Qt::DockWidgetAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//43
    { "Qt::DropAction", 0, Smoke::t_enum|Smoke::tf_stack },	//44
    { "Qt::EventPriority", 0, Smoke::t_enum|Smoke::tf_stack },	//45
    { "Qt::FillRule", 0, Smoke::t_enum|Smoke::tf_stack },	//46
    { "Qt::FocusPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//47
    { "Qt::FocusReason", 0, Smoke::t_enum|Smoke::tf_stack },	//48
    { "Qt::GestureFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//49
    { "Qt::GestureState", 0, Smoke::t_enum|Smoke::tf_stack },	//50
    { "Qt::GestureType", 0, Smoke::t_enum|Smoke::tf_stack },	//51
    { "Qt::GlobalColor", 0, Smoke::t_enum|Smoke::tf_stack },	//52
    { "Qt::ImageConversionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//53
    { "Qt::Initialization", 0, Smoke::t_enum|Smoke::tf_stack },	//54
    { "Qt::InputMethodHint", 0, Smoke::t_enum|Smoke::tf_stack },	//55
    { "Qt::InputMethodQuery", 0, Smoke::t_enum|Smoke::tf_stack },	//56
    { "Qt::ItemDataRole", 0, Smoke::t_enum|Smoke::tf_stack },	//57
    { "Qt::ItemFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//58
    { "Qt::ItemSelectionMode", 0, Smoke::t_enum|Smoke::tf_stack },	//59
    { "Qt::Key", 0, Smoke::t_enum|Smoke::tf_stack },	//60
    { "Qt::KeyboardModifier", 0, Smoke::t_enum|Smoke::tf_stack },	//61
    { "Qt::LayoutDirection", 0, Smoke::t_enum|Smoke::tf_stack },	//62
    { "Qt::MaskMode", 0, Smoke::t_enum|Smoke::tf_stack },	//63
    { "Qt::MatchFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//64
    { "Qt::Modifier", 0, Smoke::t_enum|Smoke::tf_stack },	//65
    { "Qt::MouseButton", 0, Smoke::t_enum|Smoke::tf_stack },	//66
    { "Qt::NavigationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//67
    { "Qt::Orientation", 0, Smoke::t_enum|Smoke::tf_stack },	//68
    { "Qt::PenCapStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//69
    { "Qt::PenJoinStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//70
    { "Qt::PenStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//71
    { "Qt::ScrollBarPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//72
    { "Qt::ShortcutContext", 0, Smoke::t_enum|Smoke::tf_stack },	//73
    { "Qt::SizeHint", 0, Smoke::t_enum|Smoke::tf_stack },	//74
    { "Qt::SizeMode", 0, Smoke::t_enum|Smoke::tf_stack },	//75
    { "Qt::SortOrder", 0, Smoke::t_enum|Smoke::tf_stack },	//76
    { "Qt::TextElideMode", 0, Smoke::t_enum|Smoke::tf_stack },	//77
    { "Qt::TextFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//78
    { "Qt::TextFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//79
    { "Qt::TextInteractionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//80
    { "Qt::TileRule", 0, Smoke::t_enum|Smoke::tf_stack },	//81
    { "Qt::TimeSpec", 0, Smoke::t_enum|Smoke::tf_stack },	//82
    { "Qt::ToolBarArea", 0, Smoke::t_enum|Smoke::tf_stack },	//83
    { "Qt::ToolBarAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//84
    { "Qt::ToolButtonStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//85
    { "Qt::TouchPointState", 0, Smoke::t_enum|Smoke::tf_stack },	//86
    { "Qt::TransformationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//87
    { "Qt::UIEffect", 0, Smoke::t_enum|Smoke::tf_stack },	//88
    { "Qt::WidgetAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//89
    { "Qt::WindowFrameSection", 0, Smoke::t_enum|Smoke::tf_stack },	//90
    { "Qt::WindowModality", 0, Smoke::t_enum|Smoke::tf_stack },	//91
    { "Qt::WindowState", 0, Smoke::t_enum|Smoke::tf_stack },	//92
    { "Qt::WindowType", 0, Smoke::t_enum|Smoke::tf_stack },	//93
    { "Solid::AudioInterface::AudioDriver", 12, Smoke::t_enum|Smoke::tf_stack },	//94
    { "Solid::AudioInterface::AudioInterfaceType", 12, Smoke::t_enum|Smoke::tf_stack },	//95
    { "Solid::AudioInterface::SoundcardType", 12, Smoke::t_enum|Smoke::tf_stack },	//96
    { "Solid::Battery::BatteryType", 13, Smoke::t_enum|Smoke::tf_stack },	//97
    { "Solid::Battery::ChargeState", 13, Smoke::t_enum|Smoke::tf_stack },	//98
    { "Solid::Button::ButtonType", 15, Smoke::t_enum|Smoke::tf_stack },	//99
    { "Solid::Device", 17, Smoke::t_class|Smoke::tf_stack },	//100
    { "Solid::Device&", 17, Smoke::t_class|Smoke::tf_ref },	//101
    { "Solid::Device*", 17, Smoke::t_class|Smoke::tf_ptr },	//102
    { "Solid::DeviceInterface*", 18, Smoke::t_class|Smoke::tf_ptr },	//103
    { "Solid::DeviceInterface::Type", 18, Smoke::t_enum|Smoke::tf_stack },	//104
    { "Solid::DeviceInterfacePrivate&", 19, Smoke::t_class|Smoke::tf_ref },	//105
    { "Solid::DeviceNotifier*", 20, Smoke::t_class|Smoke::tf_ptr },	//106
    { "Solid::DvbInterface::DeviceType", 21, Smoke::t_enum|Smoke::tf_stack },	//107
    { "Solid::ErrorType", 10, Smoke::t_enum|Smoke::tf_stack },	//108
    { "Solid::GenericInterface::PropertyChange", 22, Smoke::t_enum|Smoke::tf_stack },	//109
    { "Solid::Networking::ManagementPolicy", 24, Smoke::t_enum|Smoke::tf_stack },	//110
    { "Solid::Networking::Notifier*", 25, Smoke::t_class|Smoke::tf_ptr },	//111
    { "Solid::Networking::Status", 24, Smoke::t_enum|Smoke::tf_stack },	//112
    { "Solid::OpticalDisc::ContentType", 26, Smoke::t_enum|Smoke::tf_stack },	//113
    { "Solid::OpticalDisc::DiscType", 26, Smoke::t_enum|Smoke::tf_stack },	//114
    { "Solid::OpticalDrive::MediumType", 27, Smoke::t_enum|Smoke::tf_stack },	//115
    { "Solid::PowerManagement::Notifier*", 30, Smoke::t_class|Smoke::tf_ptr },	//116
    { "Solid::PowerManagement::SleepState", 29, Smoke::t_enum|Smoke::tf_stack },	//117
    { "Solid::Predicate", 31, Smoke::t_class|Smoke::tf_stack },	//118
    { "Solid::Predicate&", 31, Smoke::t_class|Smoke::tf_ref },	//119
    { "Solid::Predicate*", 31, Smoke::t_class|Smoke::tf_ptr },	//120
    { "Solid::Predicate::ComparisonOperator", 31, Smoke::t_enum|Smoke::tf_stack },	//121
    { "Solid::Predicate::Type", 31, Smoke::t_enum|Smoke::tf_stack },	//122
    { "Solid::Processor::InstructionSet", 32, Smoke::t_enum|Smoke::tf_stack },	//123
    { "Solid::StorageAccess*", 33, Smoke::t_class|Smoke::tf_ptr },	//124
    { "Solid::StorageAccessPrivate&", 34, Smoke::t_class|Smoke::tf_ref },	//125
    { "Solid::StorageDrive*", 35, Smoke::t_class|Smoke::tf_ptr },	//126
    { "Solid::StorageDrive::Bus", 35, Smoke::t_enum|Smoke::tf_stack },	//127
    { "Solid::StorageDrive::DriveType", 35, Smoke::t_enum|Smoke::tf_stack },	//128
    { "Solid::StorageDrivePrivate&", 36, Smoke::t_class|Smoke::tf_ref },	//129
    { "Solid::StorageVolume*", 37, Smoke::t_class|Smoke::tf_ptr },	//130
    { "Solid::StorageVolume::UsageType", 37, Smoke::t_enum|Smoke::tf_stack },	//131
    { "Solid::StorageVolumePrivate&", 38, Smoke::t_class|Smoke::tf_ref },	//132
    { "bool", 0, Smoke::t_bool|Smoke::tf_stack },	//133
    { "const QMap<QString,int>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//134
    { "const QMetaObject&", 5, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//135
    { "const QMetaObject*", 5, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//136
    { "const QRegExp&", 7, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//137
    { "const QString&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//138
    { "const QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//139
    { "const QVariant&", 9, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//140
    { "const Solid::Device&", 17, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//141
    { "const Solid::DeviceInterface*", 18, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//142
    { "const Solid::DeviceInterface::Type&", 18, Smoke::t_enum|Smoke::tf_ref|Smoke::tf_const },	//143
    { "const Solid::Predicate&", 31, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//144
    { "const char*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//145
    { "int", 0, Smoke::t_int|Smoke::tf_stack },	//146
    { "unsigned long long", 0, Smoke::t_voidp|Smoke::tf_stack },	//147
    { "void*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//148
    { "void**", 0, Smoke::t_voidp|Smoke::tf_ptr },	//149
};

static Smoke::Index argumentList[] = {
    0,	//0  (void)
    3, 0,	//1  QEvent*
    13, 3, 0,	//3  QObject*, QEvent*
    20, 0,	//6  QTimerEvent*
    2, 0,	//8  QChildEvent*
    145, 0,	//10  const char*
    145, 145, 0,	//12  const char*, const char*
    145, 145, 146, 0,	//15  const char*, const char*, int
    12, 146, 149, 0,	//19  QMetaObject::Call, int, void**
    133, 138, 0,	//23  bool, const QString&
    146, 138, 0,	//26  int, const QString&
    99, 138, 0,	//29  Solid::Button::ButtonType, const QString&
    17, 0,	//32  QString
    138, 0,	//34  const QString&
    143, 138, 0,	//36  const Solid::DeviceInterface::Type&, const QString&
    144, 138, 0,	//39  const Solid::Predicate&, const QString&
    138, 138, 0,	//42  const QString&, const QString&
    141, 0,	//45  const Solid::Device&
    143, 0,	//47  const Solid::DeviceInterface::Type&
    144, 0,	//49  const Solid::Predicate&
    104, 0,	//51  Solid::DeviceInterface::Type
    105, 13, 0,	//53  Solid::DeviceInterfacePrivate&, QObject*
    134, 0,	//56  const QMap<QString,int>&
    112, 0,	//58  Solid::Networking::Status
    108, 21, 138, 0,	//60  Solid::ErrorType, QVariant, const QString&
    146, 0,	//64  int
    117, 13, 145, 0,	//66  Solid::PowerManagement::SleepState, QObject*, const char*
    133, 0,	//70  bool
    143, 138, 140, 121, 0,	//72  const Solid::DeviceInterface::Type&, const QString&, const QVariant&, Solid::Predicate::ComparisonOperator
    138, 138, 140, 121, 0,	//77  const QString&, const QString&, const QVariant&, Solid::Predicate::ComparisonOperator
    143, 138, 140, 0,	//82  const Solid::DeviceInterface::Type&, const QString&, const QVariant&
    138, 138, 140, 0,	//86  const QString&, const QString&, const QVariant&
    125, 13, 0,	//90  Solid::StorageAccessPrivate&, QObject*
    129, 13, 0,	//93  Solid::StorageDrivePrivate&, QObject*
    132, 13, 0,	//96  Solid::StorageVolumePrivate&, QObject*
};

// Raw list of all methods, using munged names
static const char *methodNames[] = {
    "",	//0
    "AcAdapter",	//1
    "Alsa",	//2
    "AltiVec",	//3
    "Amd3DNow",	//4
    "Audio",	//5
    "AudioControl",	//6
    "AudioInput",	//7
    "AudioInterface",	//8
    "AudioOutput",	//9
    "Battery",	//10
    "Bd",	//11
    "Bdr",	//12
    "Bdre",	//13
    "Block",	//14
    "BluRayRecordable",	//15
    "BluRayRewritable",	//16
    "BluRayRom",	//17
    "Button",	//18
    "Camera",	//19
    "CameraBattery",	//20
    "CdRecordable",	//21
    "CdRewritable",	//22
    "CdRom",	//23
    "Cdr",	//24
    "CdromDrive",	//25
    "Cdrw",	//26
    "Charging",	//27
    "CompactFlash",	//28
    "Conjunction",	//29
    "Connected",	//30
    "Connecting",	//31
    "Data",	//32
    "Device",	//33
    "Device#",	//34
    "Device$",	//35
    "DeviceBusy",	//36
    "DeviceInterface",	//37
    "DeviceInterface##",	//38
    "DeviceNotifier",	//39
    "Discharging",	//40
    "Disconnecting",	//41
    "Disjunction",	//42
    "DvbAudio",	//43
    "DvbCa",	//44
    "DvbDemux",	//45
    "DvbDvr",	//46
    "DvbFrontend",	//47
    "DvbInterface",	//48
    "DvbNet",	//49
    "DvbOsd",	//50
    "DvbSec",	//51
    "DvbUnknown",	//52
    "DvbVideo",	//53
    "Dvd",	//54
    "DvdPlusRecordable",	//55
    "DvdPlusRecordableDuallayer",	//56
    "DvdPlusRewritable",	//57
    "DvdPlusRewritableDuallayer",	//58
    "DvdRam",	//59
    "DvdRecordable",	//60
    "DvdRewritable",	//61
    "DvdRom",	//62
    "Dvdplusdl",	//63
    "Dvdplusdlrw",	//64
    "Dvdplusr",	//65
    "Dvdplusrw",	//66
    "Dvdr",	//67
    "Dvdram",	//68
    "Dvdrw",	//69
    "Encrypted",	//70
    "Equals",	//71
    "FileSystem",	//72
    "FirewireSoundcard",	//73
    "Floppy",	//74
    "GenericInterface",	//75
    "HardDisk",	//76
    "HdDvd",	//77
    "HdDvdRecordable",	//78
    "HdDvdRewritable",	//79
    "HdDvdRom",	//80
    "HdDvdr",	//81
    "HdDvdrw",	//82
    "Headset",	//83
    "HibernateState",	//84
    "HybridSuspendState",	//85
    "Ide",	//86
    "Ieee1394",	//87
    "IntelMmx",	//88
    "IntelSse",	//89
    "IntelSse2",	//90
    "IntelSse3",	//91
    "IntelSse4",	//92
    "InterfaceCheck",	//93
    "InternalSoundcard",	//94
    "InternetGateway",	//95
    "InvalidOption",	//96
    "KeyboardBattery",	//97
    "KeyboardMouseBattery",	//98
    "Last",	//99
    "LidButton",	//100
    "Managed",	//101
    "Manual",	//102
    "Mask",	//103
    "MemoryStick",	//104
    "MissingDriver",	//105
    "Modem",	//106
    "MonitorBattery",	//107
    "MouseBattery",	//108
    "NetworkInterface",	//109
    "NetworkShare",	//110
    "NoCharge",	//111
    "NoContent",	//112
    "NoError",	//113
    "NoExtensions",	//114
    "Notifier",	//115
    "OnNextStatusChange",	//116
    "OpenSoundSystem",	//117
    "OperationFailed",	//118
    "OpticalDisc",	//119
    "OpticalDrive",	//120
    "Other",	//121
    "PartitionTable",	//122
    "PdaBattery",	//123
    "PhoneBattery",	//124
    "Platform",	//125
    "PortableMediaPlayer",	//126
    "PowerButton",	//127
    "Predicate",	//128
    "Predicate#",	//129
    "Predicate$",	//130
    "Predicate$$#",	//131
    "Predicate$$#$",	//132
    "PrimaryBattery",	//133
    "Processor",	//134
    "PropertyAdded",	//135
    "PropertyCheck",	//136
    "PropertyModified",	//137
    "PropertyRemoved",	//138
    "Raid",	//139
    "Sata",	//140
    "Scsi",	//141
    "SdMmc",	//142
    "SerialInterface",	//143
    "SleepButton",	//144
    "SmartCardReader",	//145
    "SmartMedia",	//146
    "StandbyState",	//147
    "StorageAccess",	//148
    "StorageAccess##",	//149
    "StorageDrive",	//150
    "StorageDrive##",	//151
    "StorageVolume",	//152
    "StorageVolume##",	//153
    "SuperVideoCd",	//154
    "SuspendState",	//155
    "TabletButton",	//156
    "Tape",	//157
    "UnauthorizedOperation",	//158
    "Unconnected",	//159
    "Unknown",	//160
    "UnknownAudioDriver",	//161
    "UnknownAudioInterfaceType",	//162
    "UnknownBattery",	//163
    "UnknownButtonType",	//164
    "UnknownDiscType",	//165
    "Unused",	//166
    "UpsBattery",	//167
    "Usb",	//168
    "UsbSoundcard",	//169
    "UserCanceled",	//170
    "Video",	//171
    "VideoBluRay",	//172
    "VideoCd",	//173
    "VideoDvd",	//174
    "Xd",	//175
    "accessibilityChanged",	//176
    "accessibilityChanged$$",	//177
    "allDevices",	//178
    "allProperties",	//179
    "appShouldConserveResources",	//180
    "appShouldConserveResourcesChanged",	//181
    "appShouldConserveResourcesChanged$",	//182
    "asDeviceInterface",	//183
    "asDeviceInterface$",	//184
    "availableContent",	//185
    "beginSuppressingScreenPowerManagement",	//186
    "beginSuppressingScreenPowerManagement$",	//187
    "beginSuppressingSleep",	//188
    "beginSuppressingSleep$",	//189
    "bus",	//190
    "canChangeFrequency",	//191
    "capacity",	//192
    "capacityChanged",	//193
    "capacityChanged$$",	//194
    "chargePercent",	//195
    "chargePercentChanged",	//196
    "chargePercentChanged$$",	//197
    "chargeState",	//198
    "chargeStateChanged",	//199
    "chargeStateChanged$$",	//200
    "childEvent",	//201
    "comparisonOperator",	//202
    "conditionRaised",	//203
    "conditionRaised$$",	//204
    "connectNotify",	//205
    "customEvent",	//206
    "description",	//207
    "device",	//208
    "deviceAdapter",	//209
    "deviceAdded",	//210
    "deviceAdded$",	//211
    "deviceIndex",	//212
    "deviceInterfaceType",	//213
    "deviceMajor",	//214
    "deviceMinor",	//215
    "deviceRemoved",	//216
    "deviceRemoved$",	//217
    "deviceType",	//218
    "discType",	//219
    "disconnectNotify",	//220
    "driveType",	//221
    "driver",	//222
    "driverHandle",	//223
    "driverHandle$",	//224
    "eject",	//225
    "ejectDone",	//226
    "ejectDone$#$",	//227
    "ejectPressed",	//228
    "ejectPressed$",	//229
    "ejectRequested",	//230
    "ejectRequested$",	//231
    "emblems",	//232
    "encryptedContainer",	//233
    "event",	//234
    "eventFilter",	//235
    "filePath",	//236
    "firstOperand",	//237
    "fromString",	//238
    "fromString$",	//239
    "fsType",	//240
    "hasState",	//241
    "hwAddress",	//242
    "icon",	//243
    "ifaceName",	//244
    "instance",	//245
    "instructionSets",	//246
    "interfaceType",	//247
    "isAccessible",	//248
    "isAppendable",	//249
    "isBlank",	//250
    "isDeviceInterface",	//251
    "isDeviceInterface$",	//252
    "isHotpluggable",	//253
    "isIgnored",	//254
    "isInUse",	//255
    "isPlugged",	//256
    "isPowerSupply",	//257
    "isRechargeable",	//258
    "isRemovable",	//259
    "isRewritable",	//260
    "isValid",	//261
    "isWireless",	//262
    "label",	//263
    "listFromQuery",	//264
    "listFromQuery#",	//265
    "listFromQuery#$",	//266
    "listFromQuery$",	//267
    "listFromQuery$$",	//268
    "listFromType",	//269
    "listFromType$",	//270
    "listFromType$$",	//271
    "macAddress",	//272
    "matches",	//273
    "matches#",	//274
    "matchingValue",	//275
    "maxSpeed",	//276
    "metaObject",	//277
    "name",	//278
    "notifier",	//279
    "number",	//280
    "operator&",	//281
    "operator&#",	//282
    "operator&=",	//283
    "operator&=#",	//284
    "operator=",	//285
    "operator=#",	//286
    "operator|",	//287
    "operator|#",	//288
    "operator|=",	//289
    "operator|=#",	//290
    "parent",	//291
    "parentUdi",	//292
    "plugStateChanged",	//293
    "plugStateChanged$$",	//294
    "powerSupplyStateChanged",	//295
    "powerSupplyStateChanged$$",	//296
    "pressed",	//297
    "pressed$$",	//298
    "product",	//299
    "property",	//300
    "property$",	//301
    "propertyChanged",	//302
    "propertyChanged?",	//303
    "propertyExists",	//304
    "propertyExists$",	//305
    "propertyName",	//306
    "qt_metacall",	//307
    "qt_metacall$$?",	//308
    "qt_metacast",	//309
    "qt_metacast$",	//310
    "readSpeed",	//311
    "requestSleep",	//312
    "requestSleep$#$",	//313
    "resumingFromSuspend",	//314
    "secondOperand",	//315
    "setup",	//316
    "setupDone",	//317
    "setupDone$#$",	//318
    "setupRequested",	//319
    "setupRequested$",	//320
    "shouldConnect",	//321
    "shouldDisconnect",	//322
    "size",	//323
    "soundcardType",	//324
    "stateValue",	//325
    "staticMetaObject",	//326
    "status",	//327
    "statusChanged",	//328
    "statusChanged$",	//329
    "stopSuppressingScreenPowerManagement",	//330
    "stopSuppressingScreenPowerManagement$",	//331
    "stopSuppressingSleep",	//332
    "stopSuppressingSleep$",	//333
    "stringToType",	//334
    "stringToType$",	//335
    "supportedDrivers",	//336
    "supportedDrivers$",	//337
    "supportedMedia",	//338
    "supportedProtocols",	//339
    "supportedSleepStates",	//340
    "teardown",	//341
    "teardownDone",	//342
    "teardownDone$#$",	//343
    "teardownRequested",	//344
    "teardownRequested$",	//345
    "timerEvent",	//346
    "toString",	//347
    "tr",	//348
    "tr$",	//349
    "tr$$",	//350
    "tr$$$",	//351
    "trUtf8",	//352
    "trUtf8$",	//353
    "trUtf8$$",	//354
    "trUtf8$$$",	//355
    "type",	//356
    "typeDescription",	//357
    "typeDescription$",	//358
    "typeToString",	//359
    "typeToString$",	//360
    "udi",	//361
    "usage",	//362
    "usedTypes",	//363
    "uuid",	//364
    "vendor",	//365
    "writeSpeed",	//366
    "writeSpeeds",	//367
    "~AcAdapter",	//368
    "~AudioInterface",	//369
    "~Battery",	//370
    "~Block",	//371
    "~Button",	//372
    "~Camera",	//373
    "~Device",	//374
    "~DeviceInterface",	//375
    "~DeviceNotifier",	//376
    "~DvbInterface",	//377
    "~GenericInterface",	//378
    "~NetworkInterface",	//379
    "~Notifier",	//380
    "~OpticalDisc",	//381
    "~OpticalDrive",	//382
    "~PortableMediaPlayer",	//383
    "~Predicate",	//384
    "~Processor",	//385
    "~StorageAccess",	//386
    "~StorageDrive",	//387
    "~StorageVolume",	//388
    "~Video",	//389
};

// (classId, name (index in methodNames), argumentList index, number of args, method flags, return type (index in types), xcall() index)
static Smoke::Method methods[] = {
    { 0, 0, 0, 0, 0, 0, 0 },	// (no method)
    {6, 234, 1, 1, Smoke::mf_virtual, 133, 0},	//1 QObject::event(QEvent*)
    {6, 235, 3, 2, Smoke::mf_virtual, 133, 0},	//2 QObject::eventFilter(QObject*, QEvent*)
    {6, 346, 6, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3 QObject::timerEvent(QTimerEvent*)
    {6, 201, 8, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//4 QObject::childEvent(QChildEvent*)
    {6, 206, 1, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//5 QObject::customEvent(QEvent*)
    {6, 205, 10, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//6 QObject::connectNotify(const char*)
    {6, 220, 10, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//7 QObject::disconnectNotify(const char*)
    {10, 113, 0, 0, Smoke::mf_static|Smoke::mf_enum, 108, 1},	//8 Solid::NoError (enum)
    {10, 158, 0, 0, Smoke::mf_static|Smoke::mf_enum, 108, 2},	//9 Solid::UnauthorizedOperation (enum)
    {10, 36, 0, 0, Smoke::mf_static|Smoke::mf_enum, 108, 3},	//10 Solid::DeviceBusy (enum)
    {10, 118, 0, 0, Smoke::mf_static|Smoke::mf_enum, 108, 4},	//11 Solid::OperationFailed (enum)
    {10, 170, 0, 0, Smoke::mf_static|Smoke::mf_enum, 108, 5},	//12 Solid::UserCanceled (enum)
    {10, 96, 0, 0, Smoke::mf_static|Smoke::mf_enum, 108, 6},	//13 Solid::InvalidOption (enum)
    {10, 105, 0, 0, Smoke::mf_static|Smoke::mf_enum, 108, 7},	//14 Solid::MissingDriver (enum)
    {11, 277, 0, 0, Smoke::mf_const, 136, 1},	//15 Solid::AcAdapter::metaObject() const
    {11, 309, 10, 1, 0, 148, 2},	//16 Solid::AcAdapter::qt_metacast(const char*)
    {11, 348, 12, 2, Smoke::mf_static, 17, 3},	//17 Solid::AcAdapter::tr(const char*, const char*)
    {11, 352, 12, 2, Smoke::mf_static, 17, 4},	//18 Solid::AcAdapter::trUtf8(const char*, const char*)
    {11, 348, 15, 3, Smoke::mf_static, 17, 5},	//19 Solid::AcAdapter::tr(const char*, const char*, int)
    {11, 352, 15, 3, Smoke::mf_static, 17, 6},	//20 Solid::AcAdapter::trUtf8(const char*, const char*, int)
    {11, 307, 19, 3, 0, 146, 7},	//21 Solid::AcAdapter::qt_metacall(QMetaObject::Call, int, void**)
    {11, 213, 0, 0, Smoke::mf_static, 104, 8},	//22 Solid::AcAdapter::deviceInterfaceType()
    {11, 256, 0, 0, Smoke::mf_const|Smoke::mf_property, 133, 9},	//23 Solid::AcAdapter::isPlugged() const
    {11, 293, 23, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 10},	//24 Solid::AcAdapter::plugStateChanged(bool, const QString&)
    {11, 348, 10, 1, Smoke::mf_static, 17, 11},	//25 Solid::AcAdapter::tr(const char*)
    {11, 352, 10, 1, Smoke::mf_static, 17, 12},	//26 Solid::AcAdapter::trUtf8(const char*)
    {11, 326, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 135, 13},	//27 Solid::AcAdapter::staticMetaObject() const
    {11, 368, 0, 0, Smoke::mf_dtor, 0, 14 },	//28 Solid::AcAdapter::~AcAdapter()
    {12, 277, 0, 0, Smoke::mf_const, 136, 1},	//29 Solid::AudioInterface::metaObject() const
    {12, 309, 10, 1, 0, 148, 2},	//30 Solid::AudioInterface::qt_metacast(const char*)
    {12, 348, 12, 2, Smoke::mf_static, 17, 3},	//31 Solid::AudioInterface::tr(const char*, const char*)
    {12, 352, 12, 2, Smoke::mf_static, 17, 4},	//32 Solid::AudioInterface::trUtf8(const char*, const char*)
    {12, 348, 15, 3, Smoke::mf_static, 17, 5},	//33 Solid::AudioInterface::tr(const char*, const char*, int)
    {12, 352, 15, 3, Smoke::mf_static, 17, 6},	//34 Solid::AudioInterface::trUtf8(const char*, const char*, int)
    {12, 307, 19, 3, 0, 146, 7},	//35 Solid::AudioInterface::qt_metacall(QMetaObject::Call, int, void**)
    {12, 213, 0, 0, Smoke::mf_static, 104, 8},	//36 Solid::AudioInterface::deviceInterfaceType()
    {12, 222, 0, 0, Smoke::mf_const|Smoke::mf_property, 94, 9},	//37 Solid::AudioInterface::driver() const
    {12, 223, 0, 0, Smoke::mf_const|Smoke::mf_property, 21, 10},	//38 Solid::AudioInterface::driverHandle() const
    {12, 278, 0, 0, Smoke::mf_const|Smoke::mf_property, 17, 11},	//39 Solid::AudioInterface::name() const
    {12, 218, 0, 0, Smoke::mf_const, 4, 12},	//40 Solid::AudioInterface::deviceType() const
    {12, 324, 0, 0, Smoke::mf_const|Smoke::mf_property, 96, 13},	//41 Solid::AudioInterface::soundcardType() const
    {12, 348, 10, 1, Smoke::mf_static, 17, 14},	//42 Solid::AudioInterface::tr(const char*)
    {12, 352, 10, 1, Smoke::mf_static, 17, 15},	//43 Solid::AudioInterface::trUtf8(const char*)
    {12, 326, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 135, 16},	//44 Solid::AudioInterface::staticMetaObject() const
    {12, 2, 0, 0, Smoke::mf_static|Smoke::mf_enum, 94, 17},	//45 Solid::AudioInterface::Alsa (enum)
    {12, 117, 0, 0, Smoke::mf_static|Smoke::mf_enum, 94, 18},	//46 Solid::AudioInterface::OpenSoundSystem (enum)
    {12, 161, 0, 0, Smoke::mf_static|Smoke::mf_enum, 94, 19},	//47 Solid::AudioInterface::UnknownAudioDriver (enum)
    {12, 162, 0, 0, Smoke::mf_static|Smoke::mf_enum, 95, 20},	//48 Solid::AudioInterface::UnknownAudioInterfaceType (enum)
    {12, 6, 0, 0, Smoke::mf_static|Smoke::mf_enum, 95, 21},	//49 Solid::AudioInterface::AudioControl (enum)
    {12, 7, 0, 0, Smoke::mf_static|Smoke::mf_enum, 95, 22},	//50 Solid::AudioInterface::AudioInput (enum)
    {12, 9, 0, 0, Smoke::mf_static|Smoke::mf_enum, 95, 23},	//51 Solid::AudioInterface::AudioOutput (enum)
    {12, 94, 0, 0, Smoke::mf_static|Smoke::mf_enum, 96, 24},	//52 Solid::AudioInterface::InternalSoundcard (enum)
    {12, 169, 0, 0, Smoke::mf_static|Smoke::mf_enum, 96, 25},	//53 Solid::AudioInterface::UsbSoundcard (enum)
    {12, 73, 0, 0, Smoke::mf_static|Smoke::mf_enum, 96, 26},	//54 Solid::AudioInterface::FirewireSoundcard (enum)
    {12, 83, 0, 0, Smoke::mf_static|Smoke::mf_enum, 96, 27},	//55 Solid::AudioInterface::Headset (enum)
    {12, 106, 0, 0, Smoke::mf_static|Smoke::mf_enum, 96, 28},	//56 Solid::AudioInterface::Modem (enum)
    {12, 369, 0, 0, Smoke::mf_dtor, 0, 29 },	//57 Solid::AudioInterface::~AudioInterface()
    {13, 277, 0, 0, Smoke::mf_const, 136, 1},	//58 Solid::Battery::metaObject() const
    {13, 309, 10, 1, 0, 148, 2},	//59 Solid::Battery::qt_metacast(const char*)
    {13, 348, 12, 2, Smoke::mf_static, 17, 3},	//60 Solid::Battery::tr(const char*, const char*)
    {13, 352, 12, 2, Smoke::mf_static, 17, 4},	//61 Solid::Battery::trUtf8(const char*, const char*)
    {13, 348, 15, 3, Smoke::mf_static, 17, 5},	//62 Solid::Battery::tr(const char*, const char*, int)
    {13, 352, 15, 3, Smoke::mf_static, 17, 6},	//63 Solid::Battery::trUtf8(const char*, const char*, int)
    {13, 307, 19, 3, 0, 146, 7},	//64 Solid::Battery::qt_metacall(QMetaObject::Call, int, void**)
    {13, 213, 0, 0, Smoke::mf_static, 104, 8},	//65 Solid::Battery::deviceInterfaceType()
    {13, 256, 0, 0, Smoke::mf_const|Smoke::mf_property, 133, 9},	//66 Solid::Battery::isPlugged() const
    {13, 257, 0, 0, Smoke::mf_const|Smoke::mf_property, 133, 10},	//67 Solid::Battery::isPowerSupply() const
    {13, 356, 0, 0, Smoke::mf_const|Smoke::mf_property, 97, 11},	//68 Solid::Battery::type() const
    {13, 195, 0, 0, Smoke::mf_const|Smoke::mf_property, 146, 12},	//69 Solid::Battery::chargePercent() const
    {13, 192, 0, 0, Smoke::mf_const|Smoke::mf_property, 146, 13},	//70 Solid::Battery::capacity() const
    {13, 258, 0, 0, Smoke::mf_const|Smoke::mf_property, 133, 14},	//71 Solid::Battery::isRechargeable() const
    {13, 198, 0, 0, Smoke::mf_const|Smoke::mf_property, 98, 15},	//72 Solid::Battery::chargeState() const
    {13, 196, 26, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 16},	//73 Solid::Battery::chargePercentChanged(int, const QString&)
    {13, 193, 26, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 17},	//74 Solid::Battery::capacityChanged(int, const QString&)
    {13, 199, 26, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 18},	//75 Solid::Battery::chargeStateChanged(int, const QString&)
    {13, 293, 23, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 19},	//76 Solid::Battery::plugStateChanged(bool, const QString&)
    {13, 295, 23, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 20},	//77 Solid::Battery::powerSupplyStateChanged(bool, const QString&)
    {13, 348, 10, 1, Smoke::mf_static, 17, 21},	//78 Solid::Battery::tr(const char*)
    {13, 352, 10, 1, Smoke::mf_static, 17, 22},	//79 Solid::Battery::trUtf8(const char*)
    {13, 326, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 135, 23},	//80 Solid::Battery::staticMetaObject() const
    {13, 163, 0, 0, Smoke::mf_static|Smoke::mf_enum, 97, 24},	//81 Solid::Battery::UnknownBattery (enum)
    {13, 123, 0, 0, Smoke::mf_static|Smoke::mf_enum, 97, 25},	//82 Solid::Battery::PdaBattery (enum)
    {13, 167, 0, 0, Smoke::mf_static|Smoke::mf_enum, 97, 26},	//83 Solid::Battery::UpsBattery (enum)
    {13, 133, 0, 0, Smoke::mf_static|Smoke::mf_enum, 97, 27},	//84 Solid::Battery::PrimaryBattery (enum)
    {13, 108, 0, 0, Smoke::mf_static|Smoke::mf_enum, 97, 28},	//85 Solid::Battery::MouseBattery (enum)
    {13, 97, 0, 0, Smoke::mf_static|Smoke::mf_enum, 97, 29},	//86 Solid::Battery::KeyboardBattery (enum)
    {13, 98, 0, 0, Smoke::mf_static|Smoke::mf_enum, 97, 30},	//87 Solid::Battery::KeyboardMouseBattery (enum)
    {13, 20, 0, 0, Smoke::mf_static|Smoke::mf_enum, 97, 31},	//88 Solid::Battery::CameraBattery (enum)
    {13, 124, 0, 0, Smoke::mf_static|Smoke::mf_enum, 97, 32},	//89 Solid::Battery::PhoneBattery (enum)
    {13, 107, 0, 0, Smoke::mf_static|Smoke::mf_enum, 97, 33},	//90 Solid::Battery::MonitorBattery (enum)
    {13, 111, 0, 0, Smoke::mf_static|Smoke::mf_enum, 98, 34},	//91 Solid::Battery::NoCharge (enum)
    {13, 27, 0, 0, Smoke::mf_static|Smoke::mf_enum, 98, 35},	//92 Solid::Battery::Charging (enum)
    {13, 40, 0, 0, Smoke::mf_static|Smoke::mf_enum, 98, 36},	//93 Solid::Battery::Discharging (enum)
    {13, 370, 0, 0, Smoke::mf_dtor, 0, 37 },	//94 Solid::Battery::~Battery()
    {14, 277, 0, 0, Smoke::mf_const, 136, 1},	//95 Solid::Block::metaObject() const
    {14, 309, 10, 1, 0, 148, 2},	//96 Solid::Block::qt_metacast(const char*)
    {14, 348, 12, 2, Smoke::mf_static, 17, 3},	//97 Solid::Block::tr(const char*, const char*)
    {14, 352, 12, 2, Smoke::mf_static, 17, 4},	//98 Solid::Block::trUtf8(const char*, const char*)
    {14, 348, 15, 3, Smoke::mf_static, 17, 5},	//99 Solid::Block::tr(const char*, const char*, int)
    {14, 352, 15, 3, Smoke::mf_static, 17, 6},	//100 Solid::Block::trUtf8(const char*, const char*, int)
    {14, 307, 19, 3, 0, 146, 7},	//101 Solid::Block::qt_metacall(QMetaObject::Call, int, void**)
    {14, 213, 0, 0, Smoke::mf_static, 104, 8},	//102 Solid::Block::deviceInterfaceType()
    {14, 214, 0, 0, Smoke::mf_const|Smoke::mf_property, 146, 9},	//103 Solid::Block::deviceMajor() const
    {14, 215, 0, 0, Smoke::mf_const|Smoke::mf_property, 146, 10},	//104 Solid::Block::deviceMinor() const
    {14, 208, 0, 0, Smoke::mf_const|Smoke::mf_property, 17, 11},	//105 Solid::Block::device() const
    {14, 348, 10, 1, Smoke::mf_static, 17, 12},	//106 Solid::Block::tr(const char*)
    {14, 352, 10, 1, Smoke::mf_static, 17, 13},	//107 Solid::Block::trUtf8(const char*)
    {14, 326, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 135, 14},	//108 Solid::Block::staticMetaObject() const
    {14, 371, 0, 0, Smoke::mf_dtor, 0, 15 },	//109 Solid::Block::~Block()
    {15, 277, 0, 0, Smoke::mf_const, 136, 1},	//110 Solid::Button::metaObject() const
    {15, 309, 10, 1, 0, 148, 2},	//111 Solid::Button::qt_metacast(const char*)
    {15, 348, 12, 2, Smoke::mf_static, 17, 3},	//112 Solid::Button::tr(const char*, const char*)
    {15, 352, 12, 2, Smoke::mf_static, 17, 4},	//113 Solid::Button::trUtf8(const char*, const char*)
    {15, 348, 15, 3, Smoke::mf_static, 17, 5},	//114 Solid::Button::tr(const char*, const char*, int)
    {15, 352, 15, 3, Smoke::mf_static, 17, 6},	//115 Solid::Button::trUtf8(const char*, const char*, int)
    {15, 307, 19, 3, 0, 146, 7},	//116 Solid::Button::qt_metacall(QMetaObject::Call, int, void**)
    {15, 213, 0, 0, Smoke::mf_static, 104, 8},	//117 Solid::Button::deviceInterfaceType()
    {15, 356, 0, 0, Smoke::mf_const|Smoke::mf_property, 99, 9},	//118 Solid::Button::type() const
    {15, 241, 0, 0, Smoke::mf_const|Smoke::mf_property, 133, 10},	//119 Solid::Button::hasState() const
    {15, 325, 0, 0, Smoke::mf_const|Smoke::mf_property, 133, 11},	//120 Solid::Button::stateValue() const
    {15, 297, 29, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 12},	//121 Solid::Button::pressed(Solid::Button::ButtonType, const QString&)
    {15, 348, 10, 1, Smoke::mf_static, 17, 13},	//122 Solid::Button::tr(const char*)
    {15, 352, 10, 1, Smoke::mf_static, 17, 14},	//123 Solid::Button::trUtf8(const char*)
    {15, 326, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 135, 15},	//124 Solid::Button::staticMetaObject() const
    {15, 100, 0, 0, Smoke::mf_static|Smoke::mf_enum, 99, 16},	//125 Solid::Button::LidButton (enum)
    {15, 127, 0, 0, Smoke::mf_static|Smoke::mf_enum, 99, 17},	//126 Solid::Button::PowerButton (enum)
    {15, 144, 0, 0, Smoke::mf_static|Smoke::mf_enum, 99, 18},	//127 Solid::Button::SleepButton (enum)
    {15, 164, 0, 0, Smoke::mf_static|Smoke::mf_enum, 99, 19},	//128 Solid::Button::UnknownButtonType (enum)
    {15, 156, 0, 0, Smoke::mf_static|Smoke::mf_enum, 99, 20},	//129 Solid::Button::TabletButton (enum)
    {15, 372, 0, 0, Smoke::mf_dtor, 0, 21 },	//130 Solid::Button::~Button()
    {16, 277, 0, 0, Smoke::mf_const, 136, 1},	//131 Solid::Camera::metaObject() const
    {16, 309, 10, 1, 0, 148, 2},	//132 Solid::Camera::qt_metacast(const char*)
    {16, 348, 12, 2, Smoke::mf_static, 17, 3},	//133 Solid::Camera::tr(const char*, const char*)
    {16, 352, 12, 2, Smoke::mf_static, 17, 4},	//134 Solid::Camera::trUtf8(const char*, const char*)
    {16, 348, 15, 3, Smoke::mf_static, 17, 5},	//135 Solid::Camera::tr(const char*, const char*, int)
    {16, 352, 15, 3, Smoke::mf_static, 17, 6},	//136 Solid::Camera::trUtf8(const char*, const char*, int)
    {16, 307, 19, 3, 0, 146, 7},	//137 Solid::Camera::qt_metacall(QMetaObject::Call, int, void**)
    {16, 213, 0, 0, Smoke::mf_static, 104, 8},	//138 Solid::Camera::deviceInterfaceType()
    {16, 339, 0, 0, Smoke::mf_const|Smoke::mf_property, 18, 9},	//139 Solid::Camera::supportedProtocols() const
    {16, 336, 32, 1, Smoke::mf_const, 18, 10},	//140 Solid::Camera::supportedDrivers(QString) const
    {16, 223, 34, 1, Smoke::mf_const, 21, 11},	//141 Solid::Camera::driverHandle(const QString&) const
    {16, 348, 10, 1, Smoke::mf_static, 17, 12},	//142 Solid::Camera::tr(const char*)
    {16, 352, 10, 1, Smoke::mf_static, 17, 13},	//143 Solid::Camera::trUtf8(const char*)
    {16, 336, 0, 0, Smoke::mf_const, 18, 14},	//144 Solid::Camera::supportedDrivers() const
    {16, 326, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 135, 15},	//145 Solid::Camera::staticMetaObject() const
    {16, 373, 0, 0, Smoke::mf_dtor, 0, 16 },	//146 Solid::Camera::~Camera()
    {17, 178, 0, 0, Smoke::mf_static, 8, 1},	//147 Solid::Device::allDevices()
    {17, 269, 36, 2, Smoke::mf_static, 8, 2},	//148 Solid::Device::listFromType(const Solid::DeviceInterface::Type&, const QString&)
    {17, 264, 39, 2, Smoke::mf_static, 8, 3},	//149 Solid::Device::listFromQuery(const Solid::Predicate&, const QString&)
    {17, 264, 42, 2, Smoke::mf_static, 8, 4},	//150 Solid::Device::listFromQuery(const QString&, const QString&)
    {17, 33, 34, 1, Smoke::mf_ctor, 102, 5},	//151 Solid::Device::Device(const QString&)
    {17, 33, 45, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 102, 6},	//152 Solid::Device::Device(const Solid::Device&)
    {17, 285, 45, 1, 0, 101, 7},	//153 Solid::Device::operator=(const Solid::Device&)
    {17, 261, 0, 0, Smoke::mf_const, 133, 8},	//154 Solid::Device::isValid() const
    {17, 361, 0, 0, Smoke::mf_const, 17, 9},	//155 Solid::Device::udi() const
    {17, 292, 0, 0, Smoke::mf_const, 17, 10},	//156 Solid::Device::parentUdi() const
    {17, 291, 0, 0, Smoke::mf_const, 100, 11},	//157 Solid::Device::parent() const
    {17, 365, 0, 0, Smoke::mf_const, 17, 12},	//158 Solid::Device::vendor() const
    {17, 299, 0, 0, Smoke::mf_const, 17, 13},	//159 Solid::Device::product() const
    {17, 243, 0, 0, Smoke::mf_const, 17, 14},	//160 Solid::Device::icon() const
    {17, 232, 0, 0, Smoke::mf_const, 18, 15},	//161 Solid::Device::emblems() const
    {17, 207, 0, 0, Smoke::mf_const, 17, 16},	//162 Solid::Device::description() const
    {17, 251, 47, 1, Smoke::mf_const, 133, 17},	//163 Solid::Device::isDeviceInterface(const Solid::DeviceInterface::Type&) const
    {17, 183, 47, 1, 0, 103, 18},	//164 Solid::Device::asDeviceInterface(const Solid::DeviceInterface::Type&)
    {17, 183, 47, 1, Smoke::mf_const, 142, 19},	//165 Solid::Device::asDeviceInterface(const Solid::DeviceInterface::Type&) const
    {17, 269, 47, 1, Smoke::mf_static, 8, 20},	//166 Solid::Device::listFromType(const Solid::DeviceInterface::Type&)
    {17, 264, 49, 1, Smoke::mf_static, 8, 21},	//167 Solid::Device::listFromQuery(const Solid::Predicate&)
    {17, 264, 34, 1, Smoke::mf_static, 8, 22},	//168 Solid::Device::listFromQuery(const QString&)
    {17, 33, 0, 0, Smoke::mf_ctor, 102, 23},	//169 Solid::Device::Device()
    {17, 374, 0, 0, Smoke::mf_dtor, 0, 24 },	//170 Solid::Device::~Device()
    {18, 277, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 136, 1},	//171 Solid::DeviceInterface::metaObject() const
    {18, 309, 10, 1, Smoke::mf_virtual, 148, 2},	//172 Solid::DeviceInterface::qt_metacast(const char*)
    {18, 348, 12, 2, Smoke::mf_static, 17, 3},	//173 Solid::DeviceInterface::tr(const char*, const char*)
    {18, 352, 12, 2, Smoke::mf_static, 17, 4},	//174 Solid::DeviceInterface::trUtf8(const char*, const char*)
    {18, 348, 15, 3, Smoke::mf_static, 17, 5},	//175 Solid::DeviceInterface::tr(const char*, const char*, int)
    {18, 352, 15, 3, Smoke::mf_static, 17, 6},	//176 Solid::DeviceInterface::trUtf8(const char*, const char*, int)
    {18, 307, 19, 3, Smoke::mf_virtual, 146, 7},	//177 Solid::DeviceInterface::qt_metacall(QMetaObject::Call, int, void**)
    {18, 261, 0, 0, Smoke::mf_const, 133, 8},	//178 Solid::DeviceInterface::isValid() const
    {18, 359, 51, 1, Smoke::mf_static, 17, 9},	//179 Solid::DeviceInterface::typeToString(Solid::DeviceInterface::Type)
    {18, 334, 34, 1, Smoke::mf_static, 104, 10},	//180 Solid::DeviceInterface::stringToType(const QString&)
    {18, 357, 51, 1, Smoke::mf_static, 17, 11},	//181 Solid::DeviceInterface::typeDescription(Solid::DeviceInterface::Type)
    {18, 37, 53, 2, Smoke::mf_ctor|Smoke::mf_protected, 103, 12},	//182 Solid::DeviceInterface::DeviceInterface(Solid::DeviceInterfacePrivate&, QObject*)
    {18, 348, 10, 1, Smoke::mf_static, 17, 13},	//183 Solid::DeviceInterface::tr(const char*)
    {18, 352, 10, 1, Smoke::mf_static, 17, 14},	//184 Solid::DeviceInterface::trUtf8(const char*)
    {18, 326, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 135, 15},	//185 Solid::DeviceInterface::staticMetaObject() const
    {18, 160, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 16},	//186 Solid::DeviceInterface::Unknown (enum)
    {18, 75, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 17},	//187 Solid::DeviceInterface::GenericInterface (enum)
    {18, 134, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 18},	//188 Solid::DeviceInterface::Processor (enum)
    {18, 14, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 19},	//189 Solid::DeviceInterface::Block (enum)
    {18, 148, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 20},	//190 Solid::DeviceInterface::StorageAccess (enum)
    {18, 150, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 21},	//191 Solid::DeviceInterface::StorageDrive (enum)
    {18, 120, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 22},	//192 Solid::DeviceInterface::OpticalDrive (enum)
    {18, 152, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 23},	//193 Solid::DeviceInterface::StorageVolume (enum)
    {18, 119, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 24},	//194 Solid::DeviceInterface::OpticalDisc (enum)
    {18, 19, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 25},	//195 Solid::DeviceInterface::Camera (enum)
    {18, 126, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 26},	//196 Solid::DeviceInterface::PortableMediaPlayer (enum)
    {18, 109, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 27},	//197 Solid::DeviceInterface::NetworkInterface (enum)
    {18, 1, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 28},	//198 Solid::DeviceInterface::AcAdapter (enum)
    {18, 10, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 29},	//199 Solid::DeviceInterface::Battery (enum)
    {18, 18, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 30},	//200 Solid::DeviceInterface::Button (enum)
    {18, 8, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 31},	//201 Solid::DeviceInterface::AudioInterface (enum)
    {18, 48, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 32},	//202 Solid::DeviceInterface::DvbInterface (enum)
    {18, 171, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 33},	//203 Solid::DeviceInterface::Video (enum)
    {18, 143, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 34},	//204 Solid::DeviceInterface::SerialInterface (enum)
    {18, 145, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 35},	//205 Solid::DeviceInterface::SmartCardReader (enum)
    {18, 95, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 36},	//206 Solid::DeviceInterface::InternetGateway (enum)
    {18, 110, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 37},	//207 Solid::DeviceInterface::NetworkShare (enum)
    {18, 99, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 38},	//208 Solid::DeviceInterface::Last (enum)
    {18, 375, 0, 0, Smoke::mf_dtor, 0, 39 },	//209 Solid::DeviceInterface::~DeviceInterface()
    {20, 277, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 136, 1},	//210 Solid::DeviceNotifier::metaObject() const
    {20, 309, 10, 1, Smoke::mf_virtual, 148, 2},	//211 Solid::DeviceNotifier::qt_metacast(const char*)
    {20, 348, 12, 2, Smoke::mf_static, 17, 3},	//212 Solid::DeviceNotifier::tr(const char*, const char*)
    {20, 352, 12, 2, Smoke::mf_static, 17, 4},	//213 Solid::DeviceNotifier::trUtf8(const char*, const char*)
    {20, 348, 15, 3, Smoke::mf_static, 17, 5},	//214 Solid::DeviceNotifier::tr(const char*, const char*, int)
    {20, 352, 15, 3, Smoke::mf_static, 17, 6},	//215 Solid::DeviceNotifier::trUtf8(const char*, const char*, int)
    {20, 307, 19, 3, Smoke::mf_virtual, 146, 7},	//216 Solid::DeviceNotifier::qt_metacall(QMetaObject::Call, int, void**)
    {20, 245, 0, 0, Smoke::mf_static, 106, 8},	//217 Solid::DeviceNotifier::instance()
    {20, 210, 34, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 9},	//218 Solid::DeviceNotifier::deviceAdded(const QString&)
    {20, 216, 34, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 10},	//219 Solid::DeviceNotifier::deviceRemoved(const QString&)
    {20, 39, 0, 0, Smoke::mf_ctor, 106, 11},	//220 Solid::DeviceNotifier::DeviceNotifier()
    {20, 348, 10, 1, Smoke::mf_static, 17, 12},	//221 Solid::DeviceNotifier::tr(const char*)
    {20, 352, 10, 1, Smoke::mf_static, 17, 13},	//222 Solid::DeviceNotifier::trUtf8(const char*)
    {20, 326, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 135, 14},	//223 Solid::DeviceNotifier::staticMetaObject() const
    {20, 376, 0, 0, Smoke::mf_dtor, 0, 15 },	//224 Solid::DeviceNotifier::~DeviceNotifier()
    {21, 277, 0, 0, Smoke::mf_const, 136, 1},	//225 Solid::DvbInterface::metaObject() const
    {21, 309, 10, 1, 0, 148, 2},	//226 Solid::DvbInterface::qt_metacast(const char*)
    {21, 348, 12, 2, Smoke::mf_static, 17, 3},	//227 Solid::DvbInterface::tr(const char*, const char*)
    {21, 352, 12, 2, Smoke::mf_static, 17, 4},	//228 Solid::DvbInterface::trUtf8(const char*, const char*)
    {21, 348, 15, 3, Smoke::mf_static, 17, 5},	//229 Solid::DvbInterface::tr(const char*, const char*, int)
    {21, 352, 15, 3, Smoke::mf_static, 17, 6},	//230 Solid::DvbInterface::trUtf8(const char*, const char*, int)
    {21, 307, 19, 3, 0, 146, 7},	//231 Solid::DvbInterface::qt_metacall(QMetaObject::Call, int, void**)
    {21, 213, 0, 0, Smoke::mf_static, 104, 8},	//232 Solid::DvbInterface::deviceInterfaceType()
    {21, 208, 0, 0, Smoke::mf_const|Smoke::mf_property, 17, 9},	//233 Solid::DvbInterface::device() const
    {21, 209, 0, 0, Smoke::mf_const|Smoke::mf_property, 146, 10},	//234 Solid::DvbInterface::deviceAdapter() const
    {21, 218, 0, 0, Smoke::mf_const|Smoke::mf_property, 107, 11},	//235 Solid::DvbInterface::deviceType() const
    {21, 212, 0, 0, Smoke::mf_const|Smoke::mf_property, 146, 12},	//236 Solid::DvbInterface::deviceIndex() const
    {21, 348, 10, 1, Smoke::mf_static, 17, 13},	//237 Solid::DvbInterface::tr(const char*)
    {21, 352, 10, 1, Smoke::mf_static, 17, 14},	//238 Solid::DvbInterface::trUtf8(const char*)
    {21, 326, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 135, 15},	//239 Solid::DvbInterface::staticMetaObject() const
    {21, 52, 0, 0, Smoke::mf_static|Smoke::mf_enum, 107, 16},	//240 Solid::DvbInterface::DvbUnknown (enum)
    {21, 43, 0, 0, Smoke::mf_static|Smoke::mf_enum, 107, 17},	//241 Solid::DvbInterface::DvbAudio (enum)
    {21, 44, 0, 0, Smoke::mf_static|Smoke::mf_enum, 107, 18},	//242 Solid::DvbInterface::DvbCa (enum)
    {21, 45, 0, 0, Smoke::mf_static|Smoke::mf_enum, 107, 19},	//243 Solid::DvbInterface::DvbDemux (enum)
    {21, 46, 0, 0, Smoke::mf_static|Smoke::mf_enum, 107, 20},	//244 Solid::DvbInterface::DvbDvr (enum)
    {21, 47, 0, 0, Smoke::mf_static|Smoke::mf_enum, 107, 21},	//245 Solid::DvbInterface::DvbFrontend (enum)
    {21, 49, 0, 0, Smoke::mf_static|Smoke::mf_enum, 107, 22},	//246 Solid::DvbInterface::DvbNet (enum)
    {21, 50, 0, 0, Smoke::mf_static|Smoke::mf_enum, 107, 23},	//247 Solid::DvbInterface::DvbOsd (enum)
    {21, 51, 0, 0, Smoke::mf_static|Smoke::mf_enum, 107, 24},	//248 Solid::DvbInterface::DvbSec (enum)
    {21, 53, 0, 0, Smoke::mf_static|Smoke::mf_enum, 107, 25},	//249 Solid::DvbInterface::DvbVideo (enum)
    {21, 377, 0, 0, Smoke::mf_dtor, 0, 26 },	//250 Solid::DvbInterface::~DvbInterface()
    {22, 277, 0, 0, Smoke::mf_const, 136, 1},	//251 Solid::GenericInterface::metaObject() const
    {22, 309, 10, 1, 0, 148, 2},	//252 Solid::GenericInterface::qt_metacast(const char*)
    {22, 348, 12, 2, Smoke::mf_static, 17, 3},	//253 Solid::GenericInterface::tr(const char*, const char*)
    {22, 352, 12, 2, Smoke::mf_static, 17, 4},	//254 Solid::GenericInterface::trUtf8(const char*, const char*)
    {22, 348, 15, 3, Smoke::mf_static, 17, 5},	//255 Solid::GenericInterface::tr(const char*, const char*, int)
    {22, 352, 15, 3, Smoke::mf_static, 17, 6},	//256 Solid::GenericInterface::trUtf8(const char*, const char*, int)
    {22, 307, 19, 3, 0, 146, 7},	//257 Solid::GenericInterface::qt_metacall(QMetaObject::Call, int, void**)
    {22, 213, 0, 0, Smoke::mf_static, 104, 8},	//258 Solid::GenericInterface::deviceInterfaceType()
    {22, 300, 34, 1, Smoke::mf_const, 21, 9},	//259 Solid::GenericInterface::property(const QString&) const
    {22, 179, 0, 0, Smoke::mf_const, 10, 10},	//260 Solid::GenericInterface::allProperties() const
    {22, 304, 34, 1, Smoke::mf_const, 133, 11},	//261 Solid::GenericInterface::propertyExists(const QString&) const
    {22, 302, 56, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 12},	//262 Solid::GenericInterface::propertyChanged(const QMap<QString,int>&)
    {22, 203, 42, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 13},	//263 Solid::GenericInterface::conditionRaised(const QString&, const QString&)
    {22, 348, 10, 1, Smoke::mf_static, 17, 14},	//264 Solid::GenericInterface::tr(const char*)
    {22, 352, 10, 1, Smoke::mf_static, 17, 15},	//265 Solid::GenericInterface::trUtf8(const char*)
    {22, 326, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 135, 16},	//266 Solid::GenericInterface::staticMetaObject() const
    {22, 137, 0, 0, Smoke::mf_static|Smoke::mf_enum, 109, 17},	//267 Solid::GenericInterface::PropertyModified (enum)
    {22, 135, 0, 0, Smoke::mf_static|Smoke::mf_enum, 109, 18},	//268 Solid::GenericInterface::PropertyAdded (enum)
    {22, 138, 0, 0, Smoke::mf_static|Smoke::mf_enum, 109, 19},	//269 Solid::GenericInterface::PropertyRemoved (enum)
    {22, 378, 0, 0, Smoke::mf_dtor, 0, 20 },	//270 Solid::GenericInterface::~GenericInterface()
    {23, 277, 0, 0, Smoke::mf_const, 136, 1},	//271 Solid::NetworkInterface::metaObject() const
    {23, 309, 10, 1, 0, 148, 2},	//272 Solid::NetworkInterface::qt_metacast(const char*)
    {23, 348, 12, 2, Smoke::mf_static, 17, 3},	//273 Solid::NetworkInterface::tr(const char*, const char*)
    {23, 352, 12, 2, Smoke::mf_static, 17, 4},	//274 Solid::NetworkInterface::trUtf8(const char*, const char*)
    {23, 348, 15, 3, Smoke::mf_static, 17, 5},	//275 Solid::NetworkInterface::tr(const char*, const char*, int)
    {23, 352, 15, 3, Smoke::mf_static, 17, 6},	//276 Solid::NetworkInterface::trUtf8(const char*, const char*, int)
    {23, 307, 19, 3, 0, 146, 7},	//277 Solid::NetworkInterface::qt_metacall(QMetaObject::Call, int, void**)
    {23, 213, 0, 0, Smoke::mf_static, 104, 8},	//278 Solid::NetworkInterface::deviceInterfaceType()
    {23, 244, 0, 0, Smoke::mf_const|Smoke::mf_property, 17, 9},	//279 Solid::NetworkInterface::ifaceName() const
    {23, 262, 0, 0, Smoke::mf_const|Smoke::mf_property, 133, 10},	//280 Solid::NetworkInterface::isWireless() const
    {23, 242, 0, 0, Smoke::mf_const|Smoke::mf_property, 17, 11},	//281 Solid::NetworkInterface::hwAddress() const
    {23, 272, 0, 0, Smoke::mf_const, 147, 12},	//282 Solid::NetworkInterface::macAddress() const
    {23, 348, 10, 1, Smoke::mf_static, 17, 13},	//283 Solid::NetworkInterface::tr(const char*)
    {23, 352, 10, 1, Smoke::mf_static, 17, 14},	//284 Solid::NetworkInterface::trUtf8(const char*)
    {23, 326, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 135, 15},	//285 Solid::NetworkInterface::staticMetaObject() const
    {23, 379, 0, 0, Smoke::mf_dtor, 0, 16 },	//286 Solid::NetworkInterface::~NetworkInterface()
    {24, 327, 0, 0, Smoke::mf_static, 112, 1},	//287 Solid::Networking::status()
    {24, 279, 0, 0, Smoke::mf_static, 111, 2},	//288 Solid::Networking::notifier()
    {24, 102, 0, 0, Smoke::mf_static|Smoke::mf_enum, 110, 3},	//289 Solid::Networking::Manual (enum)
    {24, 116, 0, 0, Smoke::mf_static|Smoke::mf_enum, 110, 4},	//290 Solid::Networking::OnNextStatusChange (enum)
    {24, 101, 0, 0, Smoke::mf_static|Smoke::mf_enum, 110, 5},	//291 Solid::Networking::Managed (enum)
    {24, 160, 0, 0, Smoke::mf_static|Smoke::mf_enum, 112, 6},	//292 Solid::Networking::Unknown (enum)
    {24, 159, 0, 0, Smoke::mf_static|Smoke::mf_enum, 112, 7},	//293 Solid::Networking::Unconnected (enum)
    {24, 41, 0, 0, Smoke::mf_static|Smoke::mf_enum, 112, 8},	//294 Solid::Networking::Disconnecting (enum)
    {24, 31, 0, 0, Smoke::mf_static|Smoke::mf_enum, 112, 9},	//295 Solid::Networking::Connecting (enum)
    {24, 30, 0, 0, Smoke::mf_static|Smoke::mf_enum, 112, 10},	//296 Solid::Networking::Connected (enum)
    {25, 277, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 136, 1},	//297 Solid::Networking::Notifier::metaObject() const
    {25, 309, 10, 1, Smoke::mf_virtual, 148, 2},	//298 Solid::Networking::Notifier::qt_metacast(const char*)
    {25, 348, 12, 2, Smoke::mf_static, 17, 3},	//299 Solid::Networking::Notifier::tr(const char*, const char*)
    {25, 352, 12, 2, Smoke::mf_static, 17, 4},	//300 Solid::Networking::Notifier::trUtf8(const char*, const char*)
    {25, 348, 15, 3, Smoke::mf_static, 17, 5},	//301 Solid::Networking::Notifier::tr(const char*, const char*, int)
    {25, 352, 15, 3, Smoke::mf_static, 17, 6},	//302 Solid::Networking::Notifier::trUtf8(const char*, const char*, int)
    {25, 307, 19, 3, Smoke::mf_virtual, 146, 7},	//303 Solid::Networking::Notifier::qt_metacall(QMetaObject::Call, int, void**)
    {25, 328, 58, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 8},	//304 Solid::Networking::Notifier::statusChanged(Solid::Networking::Status)
    {25, 321, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 9},	//305 Solid::Networking::Notifier::shouldConnect()
    {25, 322, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 10},	//306 Solid::Networking::Notifier::shouldDisconnect()
    {25, 115, 0, 0, Smoke::mf_ctor|Smoke::mf_protected, 111, 11},	//307 Solid::Networking::Notifier::Notifier()
    {25, 348, 10, 1, Smoke::mf_static, 17, 12},	//308 Solid::Networking::Notifier::tr(const char*)
    {25, 352, 10, 1, Smoke::mf_static, 17, 13},	//309 Solid::Networking::Notifier::trUtf8(const char*)
    {25, 326, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 135, 14},	//310 Solid::Networking::Notifier::staticMetaObject() const
    {25, 380, 0, 0, Smoke::mf_dtor, 0, 15 },	//311 Solid::Networking::Notifier::~Notifier()
    {26, 277, 0, 0, Smoke::mf_const, 136, 1},	//312 Solid::OpticalDisc::metaObject() const
    {26, 309, 10, 1, 0, 148, 2},	//313 Solid::OpticalDisc::qt_metacast(const char*)
    {26, 348, 12, 2, Smoke::mf_static, 17, 3},	//314 Solid::OpticalDisc::tr(const char*, const char*)
    {26, 352, 12, 2, Smoke::mf_static, 17, 4},	//315 Solid::OpticalDisc::trUtf8(const char*, const char*)
    {26, 348, 15, 3, Smoke::mf_static, 17, 5},	//316 Solid::OpticalDisc::tr(const char*, const char*, int)
    {26, 352, 15, 3, Smoke::mf_static, 17, 6},	//317 Solid::OpticalDisc::trUtf8(const char*, const char*, int)
    {26, 307, 19, 3, 0, 146, 7},	//318 Solid::OpticalDisc::qt_metacall(QMetaObject::Call, int, void**)
    {26, 213, 0, 0, Smoke::mf_static, 104, 8},	//319 Solid::OpticalDisc::deviceInterfaceType()
    {26, 185, 0, 0, Smoke::mf_const, 5, 9},	//320 Solid::OpticalDisc::availableContent() const
    {26, 219, 0, 0, Smoke::mf_const|Smoke::mf_property, 114, 10},	//321 Solid::OpticalDisc::discType() const
    {26, 249, 0, 0, Smoke::mf_const|Smoke::mf_property, 133, 11},	//322 Solid::OpticalDisc::isAppendable() const
    {26, 250, 0, 0, Smoke::mf_const|Smoke::mf_property, 133, 12},	//323 Solid::OpticalDisc::isBlank() const
    {26, 260, 0, 0, Smoke::mf_const|Smoke::mf_property, 133, 13},	//324 Solid::OpticalDisc::isRewritable() const
    {26, 192, 0, 0, Smoke::mf_const, 147, 14},	//325 Solid::OpticalDisc::capacity() const
    {26, 348, 10, 1, Smoke::mf_static, 17, 15},	//326 Solid::OpticalDisc::tr(const char*)
    {26, 352, 10, 1, Smoke::mf_static, 17, 16},	//327 Solid::OpticalDisc::trUtf8(const char*)
    {26, 326, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 135, 17},	//328 Solid::OpticalDisc::staticMetaObject() const
    {26, 112, 0, 0, Smoke::mf_static|Smoke::mf_enum, 113, 18},	//329 Solid::OpticalDisc::NoContent (enum)
    {26, 5, 0, 0, Smoke::mf_static|Smoke::mf_enum, 113, 19},	//330 Solid::OpticalDisc::Audio (enum)
    {26, 32, 0, 0, Smoke::mf_static|Smoke::mf_enum, 113, 20},	//331 Solid::OpticalDisc::Data (enum)
    {26, 173, 0, 0, Smoke::mf_static|Smoke::mf_enum, 113, 21},	//332 Solid::OpticalDisc::VideoCd (enum)
    {26, 154, 0, 0, Smoke::mf_static|Smoke::mf_enum, 113, 22},	//333 Solid::OpticalDisc::SuperVideoCd (enum)
    {26, 174, 0, 0, Smoke::mf_static|Smoke::mf_enum, 113, 23},	//334 Solid::OpticalDisc::VideoDvd (enum)
    {26, 172, 0, 0, Smoke::mf_static|Smoke::mf_enum, 113, 24},	//335 Solid::OpticalDisc::VideoBluRay (enum)
    {26, 165, 0, 0, Smoke::mf_static|Smoke::mf_enum, 114, 25},	//336 Solid::OpticalDisc::UnknownDiscType (enum)
    {26, 23, 0, 0, Smoke::mf_static|Smoke::mf_enum, 114, 26},	//337 Solid::OpticalDisc::CdRom (enum)
    {26, 21, 0, 0, Smoke::mf_static|Smoke::mf_enum, 114, 27},	//338 Solid::OpticalDisc::CdRecordable (enum)
    {26, 22, 0, 0, Smoke::mf_static|Smoke::mf_enum, 114, 28},	//339 Solid::OpticalDisc::CdRewritable (enum)
    {26, 62, 0, 0, Smoke::mf_static|Smoke::mf_enum, 114, 29},	//340 Solid::OpticalDisc::DvdRom (enum)
    {26, 59, 0, 0, Smoke::mf_static|Smoke::mf_enum, 114, 30},	//341 Solid::OpticalDisc::DvdRam (enum)
    {26, 60, 0, 0, Smoke::mf_static|Smoke::mf_enum, 114, 31},	//342 Solid::OpticalDisc::DvdRecordable (enum)
    {26, 61, 0, 0, Smoke::mf_static|Smoke::mf_enum, 114, 32},	//343 Solid::OpticalDisc::DvdRewritable (enum)
    {26, 55, 0, 0, Smoke::mf_static|Smoke::mf_enum, 114, 33},	//344 Solid::OpticalDisc::DvdPlusRecordable (enum)
    {26, 57, 0, 0, Smoke::mf_static|Smoke::mf_enum, 114, 34},	//345 Solid::OpticalDisc::DvdPlusRewritable (enum)
    {26, 56, 0, 0, Smoke::mf_static|Smoke::mf_enum, 114, 35},	//346 Solid::OpticalDisc::DvdPlusRecordableDuallayer (enum)
    {26, 58, 0, 0, Smoke::mf_static|Smoke::mf_enum, 114, 36},	//347 Solid::OpticalDisc::DvdPlusRewritableDuallayer (enum)
    {26, 17, 0, 0, Smoke::mf_static|Smoke::mf_enum, 114, 37},	//348 Solid::OpticalDisc::BluRayRom (enum)
    {26, 15, 0, 0, Smoke::mf_static|Smoke::mf_enum, 114, 38},	//349 Solid::OpticalDisc::BluRayRecordable (enum)
    {26, 16, 0, 0, Smoke::mf_static|Smoke::mf_enum, 114, 39},	//350 Solid::OpticalDisc::BluRayRewritable (enum)
    {26, 80, 0, 0, Smoke::mf_static|Smoke::mf_enum, 114, 40},	//351 Solid::OpticalDisc::HdDvdRom (enum)
    {26, 78, 0, 0, Smoke::mf_static|Smoke::mf_enum, 114, 41},	//352 Solid::OpticalDisc::HdDvdRecordable (enum)
    {26, 79, 0, 0, Smoke::mf_static|Smoke::mf_enum, 114, 42},	//353 Solid::OpticalDisc::HdDvdRewritable (enum)
    {26, 381, 0, 0, Smoke::mf_dtor, 0, 43 },	//354 Solid::OpticalDisc::~OpticalDisc()
    {27, 277, 0, 0, Smoke::mf_const, 136, 1},	//355 Solid::OpticalDrive::metaObject() const
    {27, 309, 10, 1, 0, 148, 2},	//356 Solid::OpticalDrive::qt_metacast(const char*)
    {27, 348, 12, 2, Smoke::mf_static, 17, 3},	//357 Solid::OpticalDrive::tr(const char*, const char*)
    {27, 352, 12, 2, Smoke::mf_static, 17, 4},	//358 Solid::OpticalDrive::trUtf8(const char*, const char*)
    {27, 348, 15, 3, Smoke::mf_static, 17, 5},	//359 Solid::OpticalDrive::tr(const char*, const char*, int)
    {27, 352, 15, 3, Smoke::mf_static, 17, 6},	//360 Solid::OpticalDrive::trUtf8(const char*, const char*, int)
    {27, 307, 19, 3, 0, 146, 7},	//361 Solid::OpticalDrive::qt_metacall(QMetaObject::Call, int, void**)
    {27, 213, 0, 0, Smoke::mf_static, 104, 8},	//362 Solid::OpticalDrive::deviceInterfaceType()
    {27, 338, 0, 0, Smoke::mf_const, 6, 9},	//363 Solid::OpticalDrive::supportedMedia() const
    {27, 311, 0, 0, Smoke::mf_const|Smoke::mf_property, 146, 10},	//364 Solid::OpticalDrive::readSpeed() const
    {27, 366, 0, 0, Smoke::mf_const|Smoke::mf_property, 146, 11},	//365 Solid::OpticalDrive::writeSpeed() const
    {27, 367, 0, 0, Smoke::mf_const|Smoke::mf_property, 9, 12},	//366 Solid::OpticalDrive::writeSpeeds() const
    {27, 225, 0, 0, 0, 133, 13},	//367 Solid::OpticalDrive::eject()
    {27, 228, 34, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 14},	//368 Solid::OpticalDrive::ejectPressed(const QString&)
    {27, 226, 60, 3, Smoke::mf_protected|Smoke::mf_signal, 0, 15},	//369 Solid::OpticalDrive::ejectDone(Solid::ErrorType, QVariant, const QString&)
    {27, 230, 34, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 16},	//370 Solid::OpticalDrive::ejectRequested(const QString&)
    {27, 348, 10, 1, Smoke::mf_static, 17, 17},	//371 Solid::OpticalDrive::tr(const char*)
    {27, 352, 10, 1, Smoke::mf_static, 17, 18},	//372 Solid::OpticalDrive::trUtf8(const char*)
    {27, 326, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 135, 19},	//373 Solid::OpticalDrive::staticMetaObject() const
    {27, 24, 0, 0, Smoke::mf_static|Smoke::mf_enum, 115, 20},	//374 Solid::OpticalDrive::Cdr (enum)
    {27, 26, 0, 0, Smoke::mf_static|Smoke::mf_enum, 115, 21},	//375 Solid::OpticalDrive::Cdrw (enum)
    {27, 54, 0, 0, Smoke::mf_static|Smoke::mf_enum, 115, 22},	//376 Solid::OpticalDrive::Dvd (enum)
    {27, 67, 0, 0, Smoke::mf_static|Smoke::mf_enum, 115, 23},	//377 Solid::OpticalDrive::Dvdr (enum)
    {27, 69, 0, 0, Smoke::mf_static|Smoke::mf_enum, 115, 24},	//378 Solid::OpticalDrive::Dvdrw (enum)
    {27, 68, 0, 0, Smoke::mf_static|Smoke::mf_enum, 115, 25},	//379 Solid::OpticalDrive::Dvdram (enum)
    {27, 65, 0, 0, Smoke::mf_static|Smoke::mf_enum, 115, 26},	//380 Solid::OpticalDrive::Dvdplusr (enum)
    {27, 66, 0, 0, Smoke::mf_static|Smoke::mf_enum, 115, 27},	//381 Solid::OpticalDrive::Dvdplusrw (enum)
    {27, 63, 0, 0, Smoke::mf_static|Smoke::mf_enum, 115, 28},	//382 Solid::OpticalDrive::Dvdplusdl (enum)
    {27, 64, 0, 0, Smoke::mf_static|Smoke::mf_enum, 115, 29},	//383 Solid::OpticalDrive::Dvdplusdlrw (enum)
    {27, 11, 0, 0, Smoke::mf_static|Smoke::mf_enum, 115, 30},	//384 Solid::OpticalDrive::Bd (enum)
    {27, 12, 0, 0, Smoke::mf_static|Smoke::mf_enum, 115, 31},	//385 Solid::OpticalDrive::Bdr (enum)
    {27, 13, 0, 0, Smoke::mf_static|Smoke::mf_enum, 115, 32},	//386 Solid::OpticalDrive::Bdre (enum)
    {27, 77, 0, 0, Smoke::mf_static|Smoke::mf_enum, 115, 33},	//387 Solid::OpticalDrive::HdDvd (enum)
    {27, 81, 0, 0, Smoke::mf_static|Smoke::mf_enum, 115, 34},	//388 Solid::OpticalDrive::HdDvdr (enum)
    {27, 82, 0, 0, Smoke::mf_static|Smoke::mf_enum, 115, 35},	//389 Solid::OpticalDrive::HdDvdrw (enum)
    {27, 382, 0, 0, Smoke::mf_dtor, 0, 36 },	//390 Solid::OpticalDrive::~OpticalDrive()
    {28, 277, 0, 0, Smoke::mf_const, 136, 1},	//391 Solid::PortableMediaPlayer::metaObject() const
    {28, 309, 10, 1, 0, 148, 2},	//392 Solid::PortableMediaPlayer::qt_metacast(const char*)
    {28, 348, 12, 2, Smoke::mf_static, 17, 3},	//393 Solid::PortableMediaPlayer::tr(const char*, const char*)
    {28, 352, 12, 2, Smoke::mf_static, 17, 4},	//394 Solid::PortableMediaPlayer::trUtf8(const char*, const char*)
    {28, 348, 15, 3, Smoke::mf_static, 17, 5},	//395 Solid::PortableMediaPlayer::tr(const char*, const char*, int)
    {28, 352, 15, 3, Smoke::mf_static, 17, 6},	//396 Solid::PortableMediaPlayer::trUtf8(const char*, const char*, int)
    {28, 307, 19, 3, 0, 146, 7},	//397 Solid::PortableMediaPlayer::qt_metacall(QMetaObject::Call, int, void**)
    {28, 213, 0, 0, Smoke::mf_static, 104, 8},	//398 Solid::PortableMediaPlayer::deviceInterfaceType()
    {28, 339, 0, 0, Smoke::mf_const|Smoke::mf_property, 18, 9},	//399 Solid::PortableMediaPlayer::supportedProtocols() const
    {28, 336, 32, 1, Smoke::mf_const, 18, 10},	//400 Solid::PortableMediaPlayer::supportedDrivers(QString) const
    {28, 223, 34, 1, Smoke::mf_const, 21, 11},	//401 Solid::PortableMediaPlayer::driverHandle(const QString&) const
    {28, 348, 10, 1, Smoke::mf_static, 17, 12},	//402 Solid::PortableMediaPlayer::tr(const char*)
    {28, 352, 10, 1, Smoke::mf_static, 17, 13},	//403 Solid::PortableMediaPlayer::trUtf8(const char*)
    {28, 336, 0, 0, Smoke::mf_const, 18, 14},	//404 Solid::PortableMediaPlayer::supportedDrivers() const
    {28, 326, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 135, 15},	//405 Solid::PortableMediaPlayer::staticMetaObject() const
    {28, 383, 0, 0, Smoke::mf_dtor, 0, 16 },	//406 Solid::PortableMediaPlayer::~PortableMediaPlayer()
    {29, 180, 0, 0, Smoke::mf_static, 133, 1},	//407 Solid::PowerManagement::appShouldConserveResources()
    {29, 340, 0, 0, Smoke::mf_static, 16, 2},	//408 Solid::PowerManagement::supportedSleepStates()
    {29, 332, 64, 1, Smoke::mf_static, 133, 3},	//409 Solid::PowerManagement::stopSuppressingSleep(int)
    {29, 186, 34, 1, Smoke::mf_static, 146, 4},	//410 Solid::PowerManagement::beginSuppressingScreenPowerManagement(const QString&)
    {29, 186, 0, 0, Smoke::mf_static, 146, 5},	//411 Solid::PowerManagement::beginSuppressingScreenPowerManagement()
    {29, 188, 34, 1, Smoke::mf_static, 146, 6},	//412 Solid::PowerManagement::beginSuppressingSleep(const QString&)
    {29, 188, 0, 0, Smoke::mf_static, 146, 7},	//413 Solid::PowerManagement::beginSuppressingSleep()
    {29, 312, 66, 3, Smoke::mf_static, 0, 8},	//414 Solid::PowerManagement::requestSleep(Solid::PowerManagement::SleepState, QObject*, const char*)
    {29, 279, 0, 0, Smoke::mf_static, 116, 9},	//415 Solid::PowerManagement::notifier()
    {29, 330, 64, 1, Smoke::mf_static, 133, 10},	//416 Solid::PowerManagement::stopSuppressingScreenPowerManagement(int)
    {29, 147, 0, 0, Smoke::mf_static|Smoke::mf_enum, 117, 11},	//417 Solid::PowerManagement::StandbyState (enum)
    {29, 155, 0, 0, Smoke::mf_static|Smoke::mf_enum, 117, 12},	//418 Solid::PowerManagement::SuspendState (enum)
    {29, 84, 0, 0, Smoke::mf_static|Smoke::mf_enum, 117, 13},	//419 Solid::PowerManagement::HibernateState (enum)
    {29, 85, 0, 0, Smoke::mf_static|Smoke::mf_enum, 117, 14},	//420 Solid::PowerManagement::HybridSuspendState (enum)
    {30, 277, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 136, 1},	//421 Solid::PowerManagement::Notifier::metaObject() const
    {30, 309, 10, 1, Smoke::mf_virtual, 148, 2},	//422 Solid::PowerManagement::Notifier::qt_metacast(const char*)
    {30, 348, 12, 2, Smoke::mf_static, 17, 3},	//423 Solid::PowerManagement::Notifier::tr(const char*, const char*)
    {30, 352, 12, 2, Smoke::mf_static, 17, 4},	//424 Solid::PowerManagement::Notifier::trUtf8(const char*, const char*)
    {30, 348, 15, 3, Smoke::mf_static, 17, 5},	//425 Solid::PowerManagement::Notifier::tr(const char*, const char*, int)
    {30, 352, 15, 3, Smoke::mf_static, 17, 6},	//426 Solid::PowerManagement::Notifier::trUtf8(const char*, const char*, int)
    {30, 307, 19, 3, Smoke::mf_virtual, 146, 7},	//427 Solid::PowerManagement::Notifier::qt_metacall(QMetaObject::Call, int, void**)
    {30, 181, 70, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 8},	//428 Solid::PowerManagement::Notifier::appShouldConserveResourcesChanged(bool)
    {30, 314, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 9},	//429 Solid::PowerManagement::Notifier::resumingFromSuspend()
    {30, 115, 0, 0, Smoke::mf_ctor|Smoke::mf_protected, 116, 10},	//430 Solid::PowerManagement::Notifier::Notifier()
    {30, 348, 10, 1, Smoke::mf_static, 17, 11},	//431 Solid::PowerManagement::Notifier::tr(const char*)
    {30, 352, 10, 1, Smoke::mf_static, 17, 12},	//432 Solid::PowerManagement::Notifier::trUtf8(const char*)
    {30, 326, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 135, 13},	//433 Solid::PowerManagement::Notifier::staticMetaObject() const
    {30, 380, 0, 0, Smoke::mf_dtor, 0, 14 },	//434 Solid::PowerManagement::Notifier::~Notifier()
    {31, 128, 0, 0, Smoke::mf_ctor, 120, 1},	//435 Solid::Predicate::Predicate()
    {31, 128, 49, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 120, 2},	//436 Solid::Predicate::Predicate(const Solid::Predicate&)
    {31, 128, 72, 4, Smoke::mf_ctor, 120, 3},	//437 Solid::Predicate::Predicate(const Solid::DeviceInterface::Type&, const QString&, const QVariant&, Solid::Predicate::ComparisonOperator)
    {31, 128, 77, 4, Smoke::mf_ctor, 120, 4},	//438 Solid::Predicate::Predicate(const QString&, const QString&, const QVariant&, Solid::Predicate::ComparisonOperator)
    {31, 128, 47, 1, Smoke::mf_ctor, 120, 5},	//439 Solid::Predicate::Predicate(const Solid::DeviceInterface::Type&)
    {31, 128, 34, 1, Smoke::mf_ctor, 120, 6},	//440 Solid::Predicate::Predicate(const QString&)
    {31, 285, 49, 1, 0, 119, 7},	//441 Solid::Predicate::operator=(const Solid::Predicate&)
    {31, 281, 49, 1, 0, 118, 8},	//442 Solid::Predicate::operator&(const Solid::Predicate&)
    {31, 283, 49, 1, 0, 119, 9},	//443 Solid::Predicate::operator&=(const Solid::Predicate&)
    {31, 287, 49, 1, 0, 118, 10},	//444 Solid::Predicate::operator|(const Solid::Predicate&)
    {31, 289, 49, 1, 0, 119, 11},	//445 Solid::Predicate::operator|=(const Solid::Predicate&)
    {31, 261, 0, 0, Smoke::mf_const, 133, 12},	//446 Solid::Predicate::isValid() const
    {31, 273, 45, 1, Smoke::mf_const, 133, 13},	//447 Solid::Predicate::matches(const Solid::Device&) const
    {31, 363, 0, 0, Smoke::mf_const, 15, 14},	//448 Solid::Predicate::usedTypes() const
    {31, 347, 0, 0, Smoke::mf_const, 17, 15},	//449 Solid::Predicate::toString() const
    {31, 238, 34, 1, Smoke::mf_static, 118, 16},	//450 Solid::Predicate::fromString(const QString&)
    {31, 356, 0, 0, Smoke::mf_const, 122, 17},	//451 Solid::Predicate::type() const
    {31, 247, 0, 0, Smoke::mf_const, 104, 18},	//452 Solid::Predicate::interfaceType() const
    {31, 306, 0, 0, Smoke::mf_const, 17, 19},	//453 Solid::Predicate::propertyName() const
    {31, 275, 0, 0, Smoke::mf_const, 21, 20},	//454 Solid::Predicate::matchingValue() const
    {31, 202, 0, 0, Smoke::mf_const, 121, 21},	//455 Solid::Predicate::comparisonOperator() const
    {31, 237, 0, 0, Smoke::mf_const, 118, 22},	//456 Solid::Predicate::firstOperand() const
    {31, 315, 0, 0, Smoke::mf_const, 118, 23},	//457 Solid::Predicate::secondOperand() const
    {31, 128, 82, 3, Smoke::mf_ctor, 120, 24},	//458 Solid::Predicate::Predicate(const Solid::DeviceInterface::Type&, const QString&, const QVariant&)
    {31, 128, 86, 3, Smoke::mf_ctor, 120, 25},	//459 Solid::Predicate::Predicate(const QString&, const QString&, const QVariant&)
    {31, 71, 0, 0, Smoke::mf_static|Smoke::mf_enum, 121, 26},	//460 Solid::Predicate::Equals (enum)
    {31, 103, 0, 0, Smoke::mf_static|Smoke::mf_enum, 121, 27},	//461 Solid::Predicate::Mask (enum)
    {31, 136, 0, 0, Smoke::mf_static|Smoke::mf_enum, 122, 28},	//462 Solid::Predicate::PropertyCheck (enum)
    {31, 29, 0, 0, Smoke::mf_static|Smoke::mf_enum, 122, 29},	//463 Solid::Predicate::Conjunction (enum)
    {31, 42, 0, 0, Smoke::mf_static|Smoke::mf_enum, 122, 30},	//464 Solid::Predicate::Disjunction (enum)
    {31, 93, 0, 0, Smoke::mf_static|Smoke::mf_enum, 122, 31},	//465 Solid::Predicate::InterfaceCheck (enum)
    {31, 384, 0, 0, Smoke::mf_dtor, 0, 32 },	//466 Solid::Predicate::~Predicate()
    {32, 277, 0, 0, Smoke::mf_const, 136, 1},	//467 Solid::Processor::metaObject() const
    {32, 309, 10, 1, 0, 148, 2},	//468 Solid::Processor::qt_metacast(const char*)
    {32, 348, 12, 2, Smoke::mf_static, 17, 3},	//469 Solid::Processor::tr(const char*, const char*)
    {32, 352, 12, 2, Smoke::mf_static, 17, 4},	//470 Solid::Processor::trUtf8(const char*, const char*)
    {32, 348, 15, 3, Smoke::mf_static, 17, 5},	//471 Solid::Processor::tr(const char*, const char*, int)
    {32, 352, 15, 3, Smoke::mf_static, 17, 6},	//472 Solid::Processor::trUtf8(const char*, const char*, int)
    {32, 307, 19, 3, 0, 146, 7},	//473 Solid::Processor::qt_metacall(QMetaObject::Call, int, void**)
    {32, 213, 0, 0, Smoke::mf_static, 104, 8},	//474 Solid::Processor::deviceInterfaceType()
    {32, 280, 0, 0, Smoke::mf_const|Smoke::mf_property, 146, 9},	//475 Solid::Processor::number() const
    {32, 276, 0, 0, Smoke::mf_const, 146, 10},	//476 Solid::Processor::maxSpeed() const
    {32, 191, 0, 0, Smoke::mf_const|Smoke::mf_property, 133, 11},	//477 Solid::Processor::canChangeFrequency() const
    {32, 246, 0, 0, Smoke::mf_const, 7, 12},	//478 Solid::Processor::instructionSets() const
    {32, 348, 10, 1, Smoke::mf_static, 17, 13},	//479 Solid::Processor::tr(const char*)
    {32, 352, 10, 1, Smoke::mf_static, 17, 14},	//480 Solid::Processor::trUtf8(const char*)
    {32, 326, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 135, 15},	//481 Solid::Processor::staticMetaObject() const
    {32, 114, 0, 0, Smoke::mf_static|Smoke::mf_enum, 123, 16},	//482 Solid::Processor::NoExtensions (enum)
    {32, 88, 0, 0, Smoke::mf_static|Smoke::mf_enum, 123, 17},	//483 Solid::Processor::IntelMmx (enum)
    {32, 89, 0, 0, Smoke::mf_static|Smoke::mf_enum, 123, 18},	//484 Solid::Processor::IntelSse (enum)
    {32, 90, 0, 0, Smoke::mf_static|Smoke::mf_enum, 123, 19},	//485 Solid::Processor::IntelSse2 (enum)
    {32, 91, 0, 0, Smoke::mf_static|Smoke::mf_enum, 123, 20},	//486 Solid::Processor::IntelSse3 (enum)
    {32, 92, 0, 0, Smoke::mf_static|Smoke::mf_enum, 123, 21},	//487 Solid::Processor::IntelSse4 (enum)
    {32, 4, 0, 0, Smoke::mf_static|Smoke::mf_enum, 123, 22},	//488 Solid::Processor::Amd3DNow (enum)
    {32, 3, 0, 0, Smoke::mf_static|Smoke::mf_enum, 123, 23},	//489 Solid::Processor::AltiVec (enum)
    {32, 385, 0, 0, Smoke::mf_dtor, 0, 24 },	//490 Solid::Processor::~Processor()
    {33, 277, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 136, 1},	//491 Solid::StorageAccess::metaObject() const
    {33, 309, 10, 1, Smoke::mf_virtual, 148, 2},	//492 Solid::StorageAccess::qt_metacast(const char*)
    {33, 348, 12, 2, Smoke::mf_static, 17, 3},	//493 Solid::StorageAccess::tr(const char*, const char*)
    {33, 352, 12, 2, Smoke::mf_static, 17, 4},	//494 Solid::StorageAccess::trUtf8(const char*, const char*)
    {33, 348, 15, 3, Smoke::mf_static, 17, 5},	//495 Solid::StorageAccess::tr(const char*, const char*, int)
    {33, 352, 15, 3, Smoke::mf_static, 17, 6},	//496 Solid::StorageAccess::trUtf8(const char*, const char*, int)
    {33, 307, 19, 3, Smoke::mf_virtual, 146, 7},	//497 Solid::StorageAccess::qt_metacall(QMetaObject::Call, int, void**)
    {33, 213, 0, 0, Smoke::mf_static, 104, 8},	//498 Solid::StorageAccess::deviceInterfaceType()
    {33, 248, 0, 0, Smoke::mf_const|Smoke::mf_property, 133, 9},	//499 Solid::StorageAccess::isAccessible() const
    {33, 236, 0, 0, Smoke::mf_const|Smoke::mf_property, 17, 10},	//500 Solid::StorageAccess::filePath() const
    {33, 254, 0, 0, Smoke::mf_const|Smoke::mf_property, 133, 11},	//501 Solid::StorageAccess::isIgnored() const
    {33, 316, 0, 0, 0, 133, 12},	//502 Solid::StorageAccess::setup()
    {33, 341, 0, 0, 0, 133, 13},	//503 Solid::StorageAccess::teardown()
    {33, 176, 23, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 14},	//504 Solid::StorageAccess::accessibilityChanged(bool, const QString&)
    {33, 317, 60, 3, Smoke::mf_protected|Smoke::mf_signal, 0, 15},	//505 Solid::StorageAccess::setupDone(Solid::ErrorType, QVariant, const QString&)
    {33, 342, 60, 3, Smoke::mf_protected|Smoke::mf_signal, 0, 16},	//506 Solid::StorageAccess::teardownDone(Solid::ErrorType, QVariant, const QString&)
    {33, 319, 34, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 17},	//507 Solid::StorageAccess::setupRequested(const QString&)
    {33, 344, 34, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 18},	//508 Solid::StorageAccess::teardownRequested(const QString&)
    {33, 148, 90, 2, Smoke::mf_ctor|Smoke::mf_protected, 124, 19},	//509 Solid::StorageAccess::StorageAccess(Solid::StorageAccessPrivate&, QObject*)
    {33, 348, 10, 1, Smoke::mf_static, 17, 20},	//510 Solid::StorageAccess::tr(const char*)
    {33, 352, 10, 1, Smoke::mf_static, 17, 21},	//511 Solid::StorageAccess::trUtf8(const char*)
    {33, 326, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 135, 22},	//512 Solid::StorageAccess::staticMetaObject() const
    {33, 386, 0, 0, Smoke::mf_dtor, 0, 23 },	//513 Solid::StorageAccess::~StorageAccess()
    {35, 277, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 136, 1},	//514 Solid::StorageDrive::metaObject() const
    {35, 309, 10, 1, Smoke::mf_virtual, 148, 2},	//515 Solid::StorageDrive::qt_metacast(const char*)
    {35, 348, 12, 2, Smoke::mf_static, 17, 3},	//516 Solid::StorageDrive::tr(const char*, const char*)
    {35, 352, 12, 2, Smoke::mf_static, 17, 4},	//517 Solid::StorageDrive::trUtf8(const char*, const char*)
    {35, 348, 15, 3, Smoke::mf_static, 17, 5},	//518 Solid::StorageDrive::tr(const char*, const char*, int)
    {35, 352, 15, 3, Smoke::mf_static, 17, 6},	//519 Solid::StorageDrive::trUtf8(const char*, const char*, int)
    {35, 307, 19, 3, Smoke::mf_virtual, 146, 7},	//520 Solid::StorageDrive::qt_metacall(QMetaObject::Call, int, void**)
    {35, 213, 0, 0, Smoke::mf_static, 104, 8},	//521 Solid::StorageDrive::deviceInterfaceType()
    {35, 190, 0, 0, Smoke::mf_const|Smoke::mf_property, 127, 9},	//522 Solid::StorageDrive::bus() const
    {35, 221, 0, 0, Smoke::mf_const|Smoke::mf_property, 128, 10},	//523 Solid::StorageDrive::driveType() const
    {35, 259, 0, 0, Smoke::mf_const|Smoke::mf_property, 133, 11},	//524 Solid::StorageDrive::isRemovable() const
    {35, 253, 0, 0, Smoke::mf_const|Smoke::mf_property, 133, 12},	//525 Solid::StorageDrive::isHotpluggable() const
    {35, 323, 0, 0, Smoke::mf_const, 147, 13},	//526 Solid::StorageDrive::size() const
    {35, 255, 0, 0, Smoke::mf_const|Smoke::mf_property, 133, 14},	//527 Solid::StorageDrive::isInUse() const
    {35, 150, 93, 2, Smoke::mf_ctor|Smoke::mf_protected, 126, 15},	//528 Solid::StorageDrive::StorageDrive(Solid::StorageDrivePrivate&, QObject*)
    {35, 348, 10, 1, Smoke::mf_static, 17, 16},	//529 Solid::StorageDrive::tr(const char*)
    {35, 352, 10, 1, Smoke::mf_static, 17, 17},	//530 Solid::StorageDrive::trUtf8(const char*)
    {35, 326, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 135, 18},	//531 Solid::StorageDrive::staticMetaObject() const
    {35, 86, 0, 0, Smoke::mf_static|Smoke::mf_enum, 127, 19},	//532 Solid::StorageDrive::Ide (enum)
    {35, 168, 0, 0, Smoke::mf_static|Smoke::mf_enum, 127, 20},	//533 Solid::StorageDrive::Usb (enum)
    {35, 87, 0, 0, Smoke::mf_static|Smoke::mf_enum, 127, 21},	//534 Solid::StorageDrive::Ieee1394 (enum)
    {35, 141, 0, 0, Smoke::mf_static|Smoke::mf_enum, 127, 22},	//535 Solid::StorageDrive::Scsi (enum)
    {35, 140, 0, 0, Smoke::mf_static|Smoke::mf_enum, 127, 23},	//536 Solid::StorageDrive::Sata (enum)
    {35, 125, 0, 0, Smoke::mf_static|Smoke::mf_enum, 127, 24},	//537 Solid::StorageDrive::Platform (enum)
    {35, 76, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 25},	//538 Solid::StorageDrive::HardDisk (enum)
    {35, 25, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 26},	//539 Solid::StorageDrive::CdromDrive (enum)
    {35, 74, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 27},	//540 Solid::StorageDrive::Floppy (enum)
    {35, 157, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 28},	//541 Solid::StorageDrive::Tape (enum)
    {35, 28, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 29},	//542 Solid::StorageDrive::CompactFlash (enum)
    {35, 104, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 30},	//543 Solid::StorageDrive::MemoryStick (enum)
    {35, 146, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 31},	//544 Solid::StorageDrive::SmartMedia (enum)
    {35, 142, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 32},	//545 Solid::StorageDrive::SdMmc (enum)
    {35, 175, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 33},	//546 Solid::StorageDrive::Xd (enum)
    {35, 387, 0, 0, Smoke::mf_dtor, 0, 34 },	//547 Solid::StorageDrive::~StorageDrive()
    {37, 277, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 136, 1},	//548 Solid::StorageVolume::metaObject() const
    {37, 309, 10, 1, Smoke::mf_virtual, 148, 2},	//549 Solid::StorageVolume::qt_metacast(const char*)
    {37, 348, 12, 2, Smoke::mf_static, 17, 3},	//550 Solid::StorageVolume::tr(const char*, const char*)
    {37, 352, 12, 2, Smoke::mf_static, 17, 4},	//551 Solid::StorageVolume::trUtf8(const char*, const char*)
    {37, 348, 15, 3, Smoke::mf_static, 17, 5},	//552 Solid::StorageVolume::tr(const char*, const char*, int)
    {37, 352, 15, 3, Smoke::mf_static, 17, 6},	//553 Solid::StorageVolume::trUtf8(const char*, const char*, int)
    {37, 307, 19, 3, Smoke::mf_virtual, 146, 7},	//554 Solid::StorageVolume::qt_metacall(QMetaObject::Call, int, void**)
    {37, 213, 0, 0, Smoke::mf_static, 104, 8},	//555 Solid::StorageVolume::deviceInterfaceType()
    {37, 254, 0, 0, Smoke::mf_const|Smoke::mf_property, 133, 9},	//556 Solid::StorageVolume::isIgnored() const
    {37, 362, 0, 0, Smoke::mf_const|Smoke::mf_property, 131, 10},	//557 Solid::StorageVolume::usage() const
    {37, 240, 0, 0, Smoke::mf_const|Smoke::mf_property, 17, 11},	//558 Solid::StorageVolume::fsType() const
    {37, 263, 0, 0, Smoke::mf_const|Smoke::mf_property, 17, 12},	//559 Solid::StorageVolume::label() const
    {37, 364, 0, 0, Smoke::mf_const|Smoke::mf_property, 17, 13},	//560 Solid::StorageVolume::uuid() const
    {37, 323, 0, 0, Smoke::mf_const, 147, 14},	//561 Solid::StorageVolume::size() const
    {37, 233, 0, 0, Smoke::mf_const, 100, 15},	//562 Solid::StorageVolume::encryptedContainer() const
    {37, 152, 96, 2, Smoke::mf_ctor|Smoke::mf_protected, 130, 16},	//563 Solid::StorageVolume::StorageVolume(Solid::StorageVolumePrivate&, QObject*)
    {37, 348, 10, 1, Smoke::mf_static, 17, 17},	//564 Solid::StorageVolume::tr(const char*)
    {37, 352, 10, 1, Smoke::mf_static, 17, 18},	//565 Solid::StorageVolume::trUtf8(const char*)
    {37, 326, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 135, 19},	//566 Solid::StorageVolume::staticMetaObject() const
    {37, 121, 0, 0, Smoke::mf_static|Smoke::mf_enum, 131, 20},	//567 Solid::StorageVolume::Other (enum)
    {37, 166, 0, 0, Smoke::mf_static|Smoke::mf_enum, 131, 21},	//568 Solid::StorageVolume::Unused (enum)
    {37, 72, 0, 0, Smoke::mf_static|Smoke::mf_enum, 131, 22},	//569 Solid::StorageVolume::FileSystem (enum)
    {37, 122, 0, 0, Smoke::mf_static|Smoke::mf_enum, 131, 23},	//570 Solid::StorageVolume::PartitionTable (enum)
    {37, 139, 0, 0, Smoke::mf_static|Smoke::mf_enum, 131, 24},	//571 Solid::StorageVolume::Raid (enum)
    {37, 70, 0, 0, Smoke::mf_static|Smoke::mf_enum, 131, 25},	//572 Solid::StorageVolume::Encrypted (enum)
    {37, 388, 0, 0, Smoke::mf_dtor, 0, 26 },	//573 Solid::StorageVolume::~StorageVolume()
    {39, 277, 0, 0, Smoke::mf_const, 136, 1},	//574 Solid::Video::metaObject() const
    {39, 309, 10, 1, 0, 148, 2},	//575 Solid::Video::qt_metacast(const char*)
    {39, 348, 12, 2, Smoke::mf_static, 17, 3},	//576 Solid::Video::tr(const char*, const char*)
    {39, 352, 12, 2, Smoke::mf_static, 17, 4},	//577 Solid::Video::trUtf8(const char*, const char*)
    {39, 348, 15, 3, Smoke::mf_static, 17, 5},	//578 Solid::Video::tr(const char*, const char*, int)
    {39, 352, 15, 3, Smoke::mf_static, 17, 6},	//579 Solid::Video::trUtf8(const char*, const char*, int)
    {39, 307, 19, 3, 0, 146, 7},	//580 Solid::Video::qt_metacall(QMetaObject::Call, int, void**)
    {39, 213, 0, 0, Smoke::mf_static, 104, 8},	//581 Solid::Video::deviceInterfaceType()
    {39, 339, 0, 0, Smoke::mf_const, 18, 9},	//582 Solid::Video::supportedProtocols() const
    {39, 336, 32, 1, Smoke::mf_const, 18, 10},	//583 Solid::Video::supportedDrivers(QString) const
    {39, 223, 34, 1, Smoke::mf_const, 21, 11},	//584 Solid::Video::driverHandle(const QString&) const
    {39, 348, 10, 1, Smoke::mf_static, 17, 12},	//585 Solid::Video::tr(const char*)
    {39, 352, 10, 1, Smoke::mf_static, 17, 13},	//586 Solid::Video::trUtf8(const char*)
    {39, 336, 0, 0, Smoke::mf_const, 18, 14},	//587 Solid::Video::supportedDrivers() const
    {39, 326, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 135, 15},	//588 Solid::Video::staticMetaObject() const
    {39, 389, 0, 0, Smoke::mf_dtor, 0, 16 },	//589 Solid::Video::~Video()
};

static Smoke::Index ambiguousMethodList[] = {
    0,
    439,  // Solid::Predicate::Predicate(const Solid::DeviceInterface::Type&)
    440,  // Solid::Predicate::Predicate(const QString&)
    0,
    458,  // Solid::Predicate::Predicate(const Solid::DeviceInterface::Type&, const QString&, const QVariant&)
    459,  // Solid::Predicate::Predicate(const QString&, const QString&, const QVariant&)
    0,
    437,  // Solid::Predicate::Predicate(const Solid::DeviceInterface::Type&, const QString&, const QVariant&, Solid::Predicate::ComparisonOperator)
    438,  // Solid::Predicate::Predicate(const QString&, const QString&, const QVariant&, Solid::Predicate::ComparisonOperator)
    0,
    164,  // Solid::Device::asDeviceInterface(const Solid::DeviceInterface::Type&)
    165,  // Solid::Device::asDeviceInterface(const Solid::DeviceInterface::Type&) const
    0,
};

// Class ID, munged name ID (index into methodNames), method def (see methods) if >0 or number of overloads if <0
static Smoke::MethodMap methodMaps[] = {
    {0, 0, 0},	//0 (no method)
    {10, 36, 10},	// Solid::DeviceBusy
    {10, 96, 13},	// Solid::InvalidOption
    {10, 105, 14},	// Solid::MissingDriver
    {10, 113, 8},	// Solid::NoError
    {10, 118, 11},	// Solid::OperationFailed
    {10, 158, 9},	// Solid::UnauthorizedOperation
    {10, 170, 12},	// Solid::UserCanceled
    {11, 213, 22},	// Solid::AcAdapter::deviceInterfaceType
    {11, 256, 23},	// Solid::AcAdapter::isPlugged
    {11, 277, 15},	// Solid::AcAdapter::metaObject
    {11, 294, 24},	// Solid::AcAdapter::plugStateChanged$$
    {11, 308, 21},	// Solid::AcAdapter::qt_metacall$$?
    {11, 310, 16},	// Solid::AcAdapter::qt_metacast$
    {11, 326, 27},	// Solid::AcAdapter::staticMetaObject
    {11, 349, 25},	// Solid::AcAdapter::tr$
    {11, 350, 17},	// Solid::AcAdapter::tr$$
    {11, 351, 19},	// Solid::AcAdapter::tr$$$
    {11, 353, 26},	// Solid::AcAdapter::trUtf8$
    {11, 354, 18},	// Solid::AcAdapter::trUtf8$$
    {11, 355, 20},	// Solid::AcAdapter::trUtf8$$$
    {11, 368, 28},	// Solid::AcAdapter::~AcAdapter
    {12, 2, 45},	// Solid::AudioInterface::Alsa
    {12, 6, 49},	// Solid::AudioInterface::AudioControl
    {12, 7, 50},	// Solid::AudioInterface::AudioInput
    {12, 9, 51},	// Solid::AudioInterface::AudioOutput
    {12, 73, 54},	// Solid::AudioInterface::FirewireSoundcard
    {12, 83, 55},	// Solid::AudioInterface::Headset
    {12, 94, 52},	// Solid::AudioInterface::InternalSoundcard
    {12, 106, 56},	// Solid::AudioInterface::Modem
    {12, 117, 46},	// Solid::AudioInterface::OpenSoundSystem
    {12, 161, 47},	// Solid::AudioInterface::UnknownAudioDriver
    {12, 162, 48},	// Solid::AudioInterface::UnknownAudioInterfaceType
    {12, 169, 53},	// Solid::AudioInterface::UsbSoundcard
    {12, 213, 36},	// Solid::AudioInterface::deviceInterfaceType
    {12, 218, 40},	// Solid::AudioInterface::deviceType
    {12, 222, 37},	// Solid::AudioInterface::driver
    {12, 223, 38},	// Solid::AudioInterface::driverHandle
    {12, 277, 29},	// Solid::AudioInterface::metaObject
    {12, 278, 39},	// Solid::AudioInterface::name
    {12, 308, 35},	// Solid::AudioInterface::qt_metacall$$?
    {12, 310, 30},	// Solid::AudioInterface::qt_metacast$
    {12, 324, 41},	// Solid::AudioInterface::soundcardType
    {12, 326, 44},	// Solid::AudioInterface::staticMetaObject
    {12, 349, 42},	// Solid::AudioInterface::tr$
    {12, 350, 31},	// Solid::AudioInterface::tr$$
    {12, 351, 33},	// Solid::AudioInterface::tr$$$
    {12, 353, 43},	// Solid::AudioInterface::trUtf8$
    {12, 354, 32},	// Solid::AudioInterface::trUtf8$$
    {12, 355, 34},	// Solid::AudioInterface::trUtf8$$$
    {12, 369, 57},	// Solid::AudioInterface::~AudioInterface
    {13, 20, 88},	// Solid::Battery::CameraBattery
    {13, 27, 92},	// Solid::Battery::Charging
    {13, 40, 93},	// Solid::Battery::Discharging
    {13, 97, 86},	// Solid::Battery::KeyboardBattery
    {13, 98, 87},	// Solid::Battery::KeyboardMouseBattery
    {13, 107, 90},	// Solid::Battery::MonitorBattery
    {13, 108, 85},	// Solid::Battery::MouseBattery
    {13, 111, 91},	// Solid::Battery::NoCharge
    {13, 123, 82},	// Solid::Battery::PdaBattery
    {13, 124, 89},	// Solid::Battery::PhoneBattery
    {13, 133, 84},	// Solid::Battery::PrimaryBattery
    {13, 163, 81},	// Solid::Battery::UnknownBattery
    {13, 167, 83},	// Solid::Battery::UpsBattery
    {13, 192, 70},	// Solid::Battery::capacity
    {13, 194, 74},	// Solid::Battery::capacityChanged$$
    {13, 195, 69},	// Solid::Battery::chargePercent
    {13, 197, 73},	// Solid::Battery::chargePercentChanged$$
    {13, 198, 72},	// Solid::Battery::chargeState
    {13, 200, 75},	// Solid::Battery::chargeStateChanged$$
    {13, 213, 65},	// Solid::Battery::deviceInterfaceType
    {13, 256, 66},	// Solid::Battery::isPlugged
    {13, 257, 67},	// Solid::Battery::isPowerSupply
    {13, 258, 71},	// Solid::Battery::isRechargeable
    {13, 277, 58},	// Solid::Battery::metaObject
    {13, 294, 76},	// Solid::Battery::plugStateChanged$$
    {13, 296, 77},	// Solid::Battery::powerSupplyStateChanged$$
    {13, 308, 64},	// Solid::Battery::qt_metacall$$?
    {13, 310, 59},	// Solid::Battery::qt_metacast$
    {13, 326, 80},	// Solid::Battery::staticMetaObject
    {13, 349, 78},	// Solid::Battery::tr$
    {13, 350, 60},	// Solid::Battery::tr$$
    {13, 351, 62},	// Solid::Battery::tr$$$
    {13, 353, 79},	// Solid::Battery::trUtf8$
    {13, 354, 61},	// Solid::Battery::trUtf8$$
    {13, 355, 63},	// Solid::Battery::trUtf8$$$
    {13, 356, 68},	// Solid::Battery::type
    {13, 370, 94},	// Solid::Battery::~Battery
    {14, 208, 105},	// Solid::Block::device
    {14, 213, 102},	// Solid::Block::deviceInterfaceType
    {14, 214, 103},	// Solid::Block::deviceMajor
    {14, 215, 104},	// Solid::Block::deviceMinor
    {14, 277, 95},	// Solid::Block::metaObject
    {14, 308, 101},	// Solid::Block::qt_metacall$$?
    {14, 310, 96},	// Solid::Block::qt_metacast$
    {14, 326, 108},	// Solid::Block::staticMetaObject
    {14, 349, 106},	// Solid::Block::tr$
    {14, 350, 97},	// Solid::Block::tr$$
    {14, 351, 99},	// Solid::Block::tr$$$
    {14, 353, 107},	// Solid::Block::trUtf8$
    {14, 354, 98},	// Solid::Block::trUtf8$$
    {14, 355, 100},	// Solid::Block::trUtf8$$$
    {14, 371, 109},	// Solid::Block::~Block
    {15, 100, 125},	// Solid::Button::LidButton
    {15, 127, 126},	// Solid::Button::PowerButton
    {15, 144, 127},	// Solid::Button::SleepButton
    {15, 156, 129},	// Solid::Button::TabletButton
    {15, 164, 128},	// Solid::Button::UnknownButtonType
    {15, 213, 117},	// Solid::Button::deviceInterfaceType
    {15, 241, 119},	// Solid::Button::hasState
    {15, 277, 110},	// Solid::Button::metaObject
    {15, 298, 121},	// Solid::Button::pressed$$
    {15, 308, 116},	// Solid::Button::qt_metacall$$?
    {15, 310, 111},	// Solid::Button::qt_metacast$
    {15, 325, 120},	// Solid::Button::stateValue
    {15, 326, 124},	// Solid::Button::staticMetaObject
    {15, 349, 122},	// Solid::Button::tr$
    {15, 350, 112},	// Solid::Button::tr$$
    {15, 351, 114},	// Solid::Button::tr$$$
    {15, 353, 123},	// Solid::Button::trUtf8$
    {15, 354, 113},	// Solid::Button::trUtf8$$
    {15, 355, 115},	// Solid::Button::trUtf8$$$
    {15, 356, 118},	// Solid::Button::type
    {15, 372, 130},	// Solid::Button::~Button
    {16, 213, 138},	// Solid::Camera::deviceInterfaceType
    {16, 224, 141},	// Solid::Camera::driverHandle$
    {16, 277, 131},	// Solid::Camera::metaObject
    {16, 308, 137},	// Solid::Camera::qt_metacall$$?
    {16, 310, 132},	// Solid::Camera::qt_metacast$
    {16, 326, 145},	// Solid::Camera::staticMetaObject
    {16, 336, 144},	// Solid::Camera::supportedDrivers
    {16, 337, 140},	// Solid::Camera::supportedDrivers$
    {16, 339, 139},	// Solid::Camera::supportedProtocols
    {16, 349, 142},	// Solid::Camera::tr$
    {16, 350, 133},	// Solid::Camera::tr$$
    {16, 351, 135},	// Solid::Camera::tr$$$
    {16, 353, 143},	// Solid::Camera::trUtf8$
    {16, 354, 134},	// Solid::Camera::trUtf8$$
    {16, 355, 136},	// Solid::Camera::trUtf8$$$
    {16, 373, 146},	// Solid::Camera::~Camera
    {17, 33, 169},	// Solid::Device::Device
    {17, 34, 152},	// Solid::Device::Device#
    {17, 35, 151},	// Solid::Device::Device$
    {17, 178, 147},	// Solid::Device::allDevices
    {17, 184, -10},	// Solid::Device::asDeviceInterface$
    {17, 207, 162},	// Solid::Device::description
    {17, 232, 161},	// Solid::Device::emblems
    {17, 243, 160},	// Solid::Device::icon
    {17, 252, 163},	// Solid::Device::isDeviceInterface$
    {17, 261, 154},	// Solid::Device::isValid
    {17, 265, 167},	// Solid::Device::listFromQuery#
    {17, 266, 149},	// Solid::Device::listFromQuery#$
    {17, 267, 168},	// Solid::Device::listFromQuery$
    {17, 268, 150},	// Solid::Device::listFromQuery$$
    {17, 270, 166},	// Solid::Device::listFromType$
    {17, 271, 148},	// Solid::Device::listFromType$$
    {17, 286, 153},	// Solid::Device::operator=#
    {17, 291, 157},	// Solid::Device::parent
    {17, 292, 156},	// Solid::Device::parentUdi
    {17, 299, 159},	// Solid::Device::product
    {17, 361, 155},	// Solid::Device::udi
    {17, 365, 158},	// Solid::Device::vendor
    {17, 374, 170},	// Solid::Device::~Device
    {18, 1, 198},	// Solid::DeviceInterface::AcAdapter
    {18, 8, 201},	// Solid::DeviceInterface::AudioInterface
    {18, 10, 199},	// Solid::DeviceInterface::Battery
    {18, 14, 189},	// Solid::DeviceInterface::Block
    {18, 18, 200},	// Solid::DeviceInterface::Button
    {18, 19, 195},	// Solid::DeviceInterface::Camera
    {18, 38, 182},	// Solid::DeviceInterface::DeviceInterface##
    {18, 48, 202},	// Solid::DeviceInterface::DvbInterface
    {18, 75, 187},	// Solid::DeviceInterface::GenericInterface
    {18, 95, 206},	// Solid::DeviceInterface::InternetGateway
    {18, 99, 208},	// Solid::DeviceInterface::Last
    {18, 109, 197},	// Solid::DeviceInterface::NetworkInterface
    {18, 110, 207},	// Solid::DeviceInterface::NetworkShare
    {18, 119, 194},	// Solid::DeviceInterface::OpticalDisc
    {18, 120, 192},	// Solid::DeviceInterface::OpticalDrive
    {18, 126, 196},	// Solid::DeviceInterface::PortableMediaPlayer
    {18, 134, 188},	// Solid::DeviceInterface::Processor
    {18, 143, 204},	// Solid::DeviceInterface::SerialInterface
    {18, 145, 205},	// Solid::DeviceInterface::SmartCardReader
    {18, 148, 190},	// Solid::DeviceInterface::StorageAccess
    {18, 150, 191},	// Solid::DeviceInterface::StorageDrive
    {18, 152, 193},	// Solid::DeviceInterface::StorageVolume
    {18, 160, 186},	// Solid::DeviceInterface::Unknown
    {18, 171, 203},	// Solid::DeviceInterface::Video
    {18, 261, 178},	// Solid::DeviceInterface::isValid
    {18, 277, 171},	// Solid::DeviceInterface::metaObject
    {18, 308, 177},	// Solid::DeviceInterface::qt_metacall$$?
    {18, 310, 172},	// Solid::DeviceInterface::qt_metacast$
    {18, 326, 185},	// Solid::DeviceInterface::staticMetaObject
    {18, 335, 180},	// Solid::DeviceInterface::stringToType$
    {18, 349, 183},	// Solid::DeviceInterface::tr$
    {18, 350, 173},	// Solid::DeviceInterface::tr$$
    {18, 351, 175},	// Solid::DeviceInterface::tr$$$
    {18, 353, 184},	// Solid::DeviceInterface::trUtf8$
    {18, 354, 174},	// Solid::DeviceInterface::trUtf8$$
    {18, 355, 176},	// Solid::DeviceInterface::trUtf8$$$
    {18, 358, 181},	// Solid::DeviceInterface::typeDescription$
    {18, 360, 179},	// Solid::DeviceInterface::typeToString$
    {18, 375, 209},	// Solid::DeviceInterface::~DeviceInterface
    {20, 39, 220},	// Solid::DeviceNotifier::DeviceNotifier
    {20, 211, 218},	// Solid::DeviceNotifier::deviceAdded$
    {20, 217, 219},	// Solid::DeviceNotifier::deviceRemoved$
    {20, 245, 217},	// Solid::DeviceNotifier::instance
    {20, 277, 210},	// Solid::DeviceNotifier::metaObject
    {20, 308, 216},	// Solid::DeviceNotifier::qt_metacall$$?
    {20, 310, 211},	// Solid::DeviceNotifier::qt_metacast$
    {20, 326, 223},	// Solid::DeviceNotifier::staticMetaObject
    {20, 349, 221},	// Solid::DeviceNotifier::tr$
    {20, 350, 212},	// Solid::DeviceNotifier::tr$$
    {20, 351, 214},	// Solid::DeviceNotifier::tr$$$
    {20, 353, 222},	// Solid::DeviceNotifier::trUtf8$
    {20, 354, 213},	// Solid::DeviceNotifier::trUtf8$$
    {20, 355, 215},	// Solid::DeviceNotifier::trUtf8$$$
    {20, 376, 224},	// Solid::DeviceNotifier::~DeviceNotifier
    {21, 43, 241},	// Solid::DvbInterface::DvbAudio
    {21, 44, 242},	// Solid::DvbInterface::DvbCa
    {21, 45, 243},	// Solid::DvbInterface::DvbDemux
    {21, 46, 244},	// Solid::DvbInterface::DvbDvr
    {21, 47, 245},	// Solid::DvbInterface::DvbFrontend
    {21, 49, 246},	// Solid::DvbInterface::DvbNet
    {21, 50, 247},	// Solid::DvbInterface::DvbOsd
    {21, 51, 248},	// Solid::DvbInterface::DvbSec
    {21, 52, 240},	// Solid::DvbInterface::DvbUnknown
    {21, 53, 249},	// Solid::DvbInterface::DvbVideo
    {21, 208, 233},	// Solid::DvbInterface::device
    {21, 209, 234},	// Solid::DvbInterface::deviceAdapter
    {21, 212, 236},	// Solid::DvbInterface::deviceIndex
    {21, 213, 232},	// Solid::DvbInterface::deviceInterfaceType
    {21, 218, 235},	// Solid::DvbInterface::deviceType
    {21, 277, 225},	// Solid::DvbInterface::metaObject
    {21, 308, 231},	// Solid::DvbInterface::qt_metacall$$?
    {21, 310, 226},	// Solid::DvbInterface::qt_metacast$
    {21, 326, 239},	// Solid::DvbInterface::staticMetaObject
    {21, 349, 237},	// Solid::DvbInterface::tr$
    {21, 350, 227},	// Solid::DvbInterface::tr$$
    {21, 351, 229},	// Solid::DvbInterface::tr$$$
    {21, 353, 238},	// Solid::DvbInterface::trUtf8$
    {21, 354, 228},	// Solid::DvbInterface::trUtf8$$
    {21, 355, 230},	// Solid::DvbInterface::trUtf8$$$
    {21, 377, 250},	// Solid::DvbInterface::~DvbInterface
    {22, 135, 268},	// Solid::GenericInterface::PropertyAdded
    {22, 137, 267},	// Solid::GenericInterface::PropertyModified
    {22, 138, 269},	// Solid::GenericInterface::PropertyRemoved
    {22, 179, 260},	// Solid::GenericInterface::allProperties
    {22, 204, 263},	// Solid::GenericInterface::conditionRaised$$
    {22, 213, 258},	// Solid::GenericInterface::deviceInterfaceType
    {22, 277, 251},	// Solid::GenericInterface::metaObject
    {22, 301, 259},	// Solid::GenericInterface::property$
    {22, 303, 262},	// Solid::GenericInterface::propertyChanged?
    {22, 305, 261},	// Solid::GenericInterface::propertyExists$
    {22, 308, 257},	// Solid::GenericInterface::qt_metacall$$?
    {22, 310, 252},	// Solid::GenericInterface::qt_metacast$
    {22, 326, 266},	// Solid::GenericInterface::staticMetaObject
    {22, 349, 264},	// Solid::GenericInterface::tr$
    {22, 350, 253},	// Solid::GenericInterface::tr$$
    {22, 351, 255},	// Solid::GenericInterface::tr$$$
    {22, 353, 265},	// Solid::GenericInterface::trUtf8$
    {22, 354, 254},	// Solid::GenericInterface::trUtf8$$
    {22, 355, 256},	// Solid::GenericInterface::trUtf8$$$
    {22, 378, 270},	// Solid::GenericInterface::~GenericInterface
    {23, 213, 278},	// Solid::NetworkInterface::deviceInterfaceType
    {23, 242, 281},	// Solid::NetworkInterface::hwAddress
    {23, 244, 279},	// Solid::NetworkInterface::ifaceName
    {23, 262, 280},	// Solid::NetworkInterface::isWireless
    {23, 272, 282},	// Solid::NetworkInterface::macAddress
    {23, 277, 271},	// Solid::NetworkInterface::metaObject
    {23, 308, 277},	// Solid::NetworkInterface::qt_metacall$$?
    {23, 310, 272},	// Solid::NetworkInterface::qt_metacast$
    {23, 326, 285},	// Solid::NetworkInterface::staticMetaObject
    {23, 349, 283},	// Solid::NetworkInterface::tr$
    {23, 350, 273},	// Solid::NetworkInterface::tr$$
    {23, 351, 275},	// Solid::NetworkInterface::tr$$$
    {23, 353, 284},	// Solid::NetworkInterface::trUtf8$
    {23, 354, 274},	// Solid::NetworkInterface::trUtf8$$
    {23, 355, 276},	// Solid::NetworkInterface::trUtf8$$$
    {23, 379, 286},	// Solid::NetworkInterface::~NetworkInterface
    {24, 30, 296},	// Solid::Networking::Connected
    {24, 31, 295},	// Solid::Networking::Connecting
    {24, 41, 294},	// Solid::Networking::Disconnecting
    {24, 101, 291},	// Solid::Networking::Managed
    {24, 102, 289},	// Solid::Networking::Manual
    {24, 116, 290},	// Solid::Networking::OnNextStatusChange
    {24, 159, 293},	// Solid::Networking::Unconnected
    {24, 160, 292},	// Solid::Networking::Unknown
    {24, 279, 288},	// Solid::Networking::notifier
    {24, 327, 287},	// Solid::Networking::status
    {25, 115, 307},	// Solid::Networking::Notifier::Notifier
    {25, 277, 297},	// Solid::Networking::Notifier::metaObject
    {25, 308, 303},	// Solid::Networking::Notifier::qt_metacall$$?
    {25, 310, 298},	// Solid::Networking::Notifier::qt_metacast$
    {25, 321, 305},	// Solid::Networking::Notifier::shouldConnect
    {25, 322, 306},	// Solid::Networking::Notifier::shouldDisconnect
    {25, 326, 310},	// Solid::Networking::Notifier::staticMetaObject
    {25, 329, 304},	// Solid::Networking::Notifier::statusChanged$
    {25, 349, 308},	// Solid::Networking::Notifier::tr$
    {25, 350, 299},	// Solid::Networking::Notifier::tr$$
    {25, 351, 301},	// Solid::Networking::Notifier::tr$$$
    {25, 353, 309},	// Solid::Networking::Notifier::trUtf8$
    {25, 354, 300},	// Solid::Networking::Notifier::trUtf8$$
    {25, 355, 302},	// Solid::Networking::Notifier::trUtf8$$$
    {25, 380, 311},	// Solid::Networking::Notifier::~Notifier
    {26, 5, 330},	// Solid::OpticalDisc::Audio
    {26, 15, 349},	// Solid::OpticalDisc::BluRayRecordable
    {26, 16, 350},	// Solid::OpticalDisc::BluRayRewritable
    {26, 17, 348},	// Solid::OpticalDisc::BluRayRom
    {26, 21, 338},	// Solid::OpticalDisc::CdRecordable
    {26, 22, 339},	// Solid::OpticalDisc::CdRewritable
    {26, 23, 337},	// Solid::OpticalDisc::CdRom
    {26, 32, 331},	// Solid::OpticalDisc::Data
    {26, 55, 344},	// Solid::OpticalDisc::DvdPlusRecordable
    {26, 56, 346},	// Solid::OpticalDisc::DvdPlusRecordableDuallayer
    {26, 57, 345},	// Solid::OpticalDisc::DvdPlusRewritable
    {26, 58, 347},	// Solid::OpticalDisc::DvdPlusRewritableDuallayer
    {26, 59, 341},	// Solid::OpticalDisc::DvdRam
    {26, 60, 342},	// Solid::OpticalDisc::DvdRecordable
    {26, 61, 343},	// Solid::OpticalDisc::DvdRewritable
    {26, 62, 340},	// Solid::OpticalDisc::DvdRom
    {26, 78, 352},	// Solid::OpticalDisc::HdDvdRecordable
    {26, 79, 353},	// Solid::OpticalDisc::HdDvdRewritable
    {26, 80, 351},	// Solid::OpticalDisc::HdDvdRom
    {26, 112, 329},	// Solid::OpticalDisc::NoContent
    {26, 154, 333},	// Solid::OpticalDisc::SuperVideoCd
    {26, 165, 336},	// Solid::OpticalDisc::UnknownDiscType
    {26, 172, 335},	// Solid::OpticalDisc::VideoBluRay
    {26, 173, 332},	// Solid::OpticalDisc::VideoCd
    {26, 174, 334},	// Solid::OpticalDisc::VideoDvd
    {26, 185, 320},	// Solid::OpticalDisc::availableContent
    {26, 192, 325},	// Solid::OpticalDisc::capacity
    {26, 213, 319},	// Solid::OpticalDisc::deviceInterfaceType
    {26, 219, 321},	// Solid::OpticalDisc::discType
    {26, 249, 322},	// Solid::OpticalDisc::isAppendable
    {26, 250, 323},	// Solid::OpticalDisc::isBlank
    {26, 260, 324},	// Solid::OpticalDisc::isRewritable
    {26, 277, 312},	// Solid::OpticalDisc::metaObject
    {26, 308, 318},	// Solid::OpticalDisc::qt_metacall$$?
    {26, 310, 313},	// Solid::OpticalDisc::qt_metacast$
    {26, 326, 328},	// Solid::OpticalDisc::staticMetaObject
    {26, 349, 326},	// Solid::OpticalDisc::tr$
    {26, 350, 314},	// Solid::OpticalDisc::tr$$
    {26, 351, 316},	// Solid::OpticalDisc::tr$$$
    {26, 353, 327},	// Solid::OpticalDisc::trUtf8$
    {26, 354, 315},	// Solid::OpticalDisc::trUtf8$$
    {26, 355, 317},	// Solid::OpticalDisc::trUtf8$$$
    {26, 381, 354},	// Solid::OpticalDisc::~OpticalDisc
    {27, 11, 384},	// Solid::OpticalDrive::Bd
    {27, 12, 385},	// Solid::OpticalDrive::Bdr
    {27, 13, 386},	// Solid::OpticalDrive::Bdre
    {27, 24, 374},	// Solid::OpticalDrive::Cdr
    {27, 26, 375},	// Solid::OpticalDrive::Cdrw
    {27, 54, 376},	// Solid::OpticalDrive::Dvd
    {27, 63, 382},	// Solid::OpticalDrive::Dvdplusdl
    {27, 64, 383},	// Solid::OpticalDrive::Dvdplusdlrw
    {27, 65, 380},	// Solid::OpticalDrive::Dvdplusr
    {27, 66, 381},	// Solid::OpticalDrive::Dvdplusrw
    {27, 67, 377},	// Solid::OpticalDrive::Dvdr
    {27, 68, 379},	// Solid::OpticalDrive::Dvdram
    {27, 69, 378},	// Solid::OpticalDrive::Dvdrw
    {27, 77, 387},	// Solid::OpticalDrive::HdDvd
    {27, 81, 388},	// Solid::OpticalDrive::HdDvdr
    {27, 82, 389},	// Solid::OpticalDrive::HdDvdrw
    {27, 213, 362},	// Solid::OpticalDrive::deviceInterfaceType
    {27, 225, 367},	// Solid::OpticalDrive::eject
    {27, 227, 369},	// Solid::OpticalDrive::ejectDone$#$
    {27, 229, 368},	// Solid::OpticalDrive::ejectPressed$
    {27, 231, 370},	// Solid::OpticalDrive::ejectRequested$
    {27, 277, 355},	// Solid::OpticalDrive::metaObject
    {27, 308, 361},	// Solid::OpticalDrive::qt_metacall$$?
    {27, 310, 356},	// Solid::OpticalDrive::qt_metacast$
    {27, 311, 364},	// Solid::OpticalDrive::readSpeed
    {27, 326, 373},	// Solid::OpticalDrive::staticMetaObject
    {27, 338, 363},	// Solid::OpticalDrive::supportedMedia
    {27, 349, 371},	// Solid::OpticalDrive::tr$
    {27, 350, 357},	// Solid::OpticalDrive::tr$$
    {27, 351, 359},	// Solid::OpticalDrive::tr$$$
    {27, 353, 372},	// Solid::OpticalDrive::trUtf8$
    {27, 354, 358},	// Solid::OpticalDrive::trUtf8$$
    {27, 355, 360},	// Solid::OpticalDrive::trUtf8$$$
    {27, 366, 365},	// Solid::OpticalDrive::writeSpeed
    {27, 367, 366},	// Solid::OpticalDrive::writeSpeeds
    {27, 382, 390},	// Solid::OpticalDrive::~OpticalDrive
    {28, 213, 398},	// Solid::PortableMediaPlayer::deviceInterfaceType
    {28, 224, 401},	// Solid::PortableMediaPlayer::driverHandle$
    {28, 277, 391},	// Solid::PortableMediaPlayer::metaObject
    {28, 308, 397},	// Solid::PortableMediaPlayer::qt_metacall$$?
    {28, 310, 392},	// Solid::PortableMediaPlayer::qt_metacast$
    {28, 326, 405},	// Solid::PortableMediaPlayer::staticMetaObject
    {28, 336, 404},	// Solid::PortableMediaPlayer::supportedDrivers
    {28, 337, 400},	// Solid::PortableMediaPlayer::supportedDrivers$
    {28, 339, 399},	// Solid::PortableMediaPlayer::supportedProtocols
    {28, 349, 402},	// Solid::PortableMediaPlayer::tr$
    {28, 350, 393},	// Solid::PortableMediaPlayer::tr$$
    {28, 351, 395},	// Solid::PortableMediaPlayer::tr$$$
    {28, 353, 403},	// Solid::PortableMediaPlayer::trUtf8$
    {28, 354, 394},	// Solid::PortableMediaPlayer::trUtf8$$
    {28, 355, 396},	// Solid::PortableMediaPlayer::trUtf8$$$
    {28, 383, 406},	// Solid::PortableMediaPlayer::~PortableMediaPlayer
    {29, 84, 419},	// Solid::PowerManagement::HibernateState
    {29, 85, 420},	// Solid::PowerManagement::HybridSuspendState
    {29, 147, 417},	// Solid::PowerManagement::StandbyState
    {29, 155, 418},	// Solid::PowerManagement::SuspendState
    {29, 180, 407},	// Solid::PowerManagement::appShouldConserveResources
    {29, 186, 411},	// Solid::PowerManagement::beginSuppressingScreenPowerManagement
    {29, 187, 410},	// Solid::PowerManagement::beginSuppressingScreenPowerManagement$
    {29, 188, 413},	// Solid::PowerManagement::beginSuppressingSleep
    {29, 189, 412},	// Solid::PowerManagement::beginSuppressingSleep$
    {29, 279, 415},	// Solid::PowerManagement::notifier
    {29, 313, 414},	// Solid::PowerManagement::requestSleep$#$
    {29, 331, 416},	// Solid::PowerManagement::stopSuppressingScreenPowerManagement$
    {29, 333, 409},	// Solid::PowerManagement::stopSuppressingSleep$
    {29, 340, 408},	// Solid::PowerManagement::supportedSleepStates
    {30, 115, 430},	// Solid::PowerManagement::Notifier::Notifier
    {30, 182, 428},	// Solid::PowerManagement::Notifier::appShouldConserveResourcesChanged$
    {30, 277, 421},	// Solid::PowerManagement::Notifier::metaObject
    {30, 308, 427},	// Solid::PowerManagement::Notifier::qt_metacall$$?
    {30, 310, 422},	// Solid::PowerManagement::Notifier::qt_metacast$
    {30, 314, 429},	// Solid::PowerManagement::Notifier::resumingFromSuspend
    {30, 326, 433},	// Solid::PowerManagement::Notifier::staticMetaObject
    {30, 349, 431},	// Solid::PowerManagement::Notifier::tr$
    {30, 350, 423},	// Solid::PowerManagement::Notifier::tr$$
    {30, 351, 425},	// Solid::PowerManagement::Notifier::tr$$$
    {30, 353, 432},	// Solid::PowerManagement::Notifier::trUtf8$
    {30, 354, 424},	// Solid::PowerManagement::Notifier::trUtf8$$
    {30, 355, 426},	// Solid::PowerManagement::Notifier::trUtf8$$$
    {30, 380, 434},	// Solid::PowerManagement::Notifier::~Notifier
    {31, 29, 463},	// Solid::Predicate::Conjunction
    {31, 42, 464},	// Solid::Predicate::Disjunction
    {31, 71, 460},	// Solid::Predicate::Equals
    {31, 93, 465},	// Solid::Predicate::InterfaceCheck
    {31, 103, 461},	// Solid::Predicate::Mask
    {31, 128, 435},	// Solid::Predicate::Predicate
    {31, 129, 436},	// Solid::Predicate::Predicate#
    {31, 130, -1},	// Solid::Predicate::Predicate$
    {31, 131, -4},	// Solid::Predicate::Predicate$$#
    {31, 132, -7},	// Solid::Predicate::Predicate$$#$
    {31, 136, 462},	// Solid::Predicate::PropertyCheck
    {31, 202, 455},	// Solid::Predicate::comparisonOperator
    {31, 237, 456},	// Solid::Predicate::firstOperand
    {31, 239, 450},	// Solid::Predicate::fromString$
    {31, 247, 452},	// Solid::Predicate::interfaceType
    {31, 261, 446},	// Solid::Predicate::isValid
    {31, 274, 447},	// Solid::Predicate::matches#
    {31, 275, 454},	// Solid::Predicate::matchingValue
    {31, 282, 442},	// Solid::Predicate::operator&#
    {31, 284, 443},	// Solid::Predicate::operator&=#
    {31, 286, 441},	// Solid::Predicate::operator=#
    {31, 288, 444},	// Solid::Predicate::operator|#
    {31, 290, 445},	// Solid::Predicate::operator|=#
    {31, 306, 453},	// Solid::Predicate::propertyName
    {31, 315, 457},	// Solid::Predicate::secondOperand
    {31, 347, 449},	// Solid::Predicate::toString
    {31, 356, 451},	// Solid::Predicate::type
    {31, 363, 448},	// Solid::Predicate::usedTypes
    {31, 384, 466},	// Solid::Predicate::~Predicate
    {32, 3, 489},	// Solid::Processor::AltiVec
    {32, 4, 488},	// Solid::Processor::Amd3DNow
    {32, 88, 483},	// Solid::Processor::IntelMmx
    {32, 89, 484},	// Solid::Processor::IntelSse
    {32, 90, 485},	// Solid::Processor::IntelSse2
    {32, 91, 486},	// Solid::Processor::IntelSse3
    {32, 92, 487},	// Solid::Processor::IntelSse4
    {32, 114, 482},	// Solid::Processor::NoExtensions
    {32, 191, 477},	// Solid::Processor::canChangeFrequency
    {32, 213, 474},	// Solid::Processor::deviceInterfaceType
    {32, 246, 478},	// Solid::Processor::instructionSets
    {32, 276, 476},	// Solid::Processor::maxSpeed
    {32, 277, 467},	// Solid::Processor::metaObject
    {32, 280, 475},	// Solid::Processor::number
    {32, 308, 473},	// Solid::Processor::qt_metacall$$?
    {32, 310, 468},	// Solid::Processor::qt_metacast$
    {32, 326, 481},	// Solid::Processor::staticMetaObject
    {32, 349, 479},	// Solid::Processor::tr$
    {32, 350, 469},	// Solid::Processor::tr$$
    {32, 351, 471},	// Solid::Processor::tr$$$
    {32, 353, 480},	// Solid::Processor::trUtf8$
    {32, 354, 470},	// Solid::Processor::trUtf8$$
    {32, 355, 472},	// Solid::Processor::trUtf8$$$
    {32, 385, 490},	// Solid::Processor::~Processor
    {33, 149, 509},	// Solid::StorageAccess::StorageAccess##
    {33, 177, 504},	// Solid::StorageAccess::accessibilityChanged$$
    {33, 213, 498},	// Solid::StorageAccess::deviceInterfaceType
    {33, 236, 500},	// Solid::StorageAccess::filePath
    {33, 248, 499},	// Solid::StorageAccess::isAccessible
    {33, 254, 501},	// Solid::StorageAccess::isIgnored
    {33, 277, 491},	// Solid::StorageAccess::metaObject
    {33, 308, 497},	// Solid::StorageAccess::qt_metacall$$?
    {33, 310, 492},	// Solid::StorageAccess::qt_metacast$
    {33, 316, 502},	// Solid::StorageAccess::setup
    {33, 318, 505},	// Solid::StorageAccess::setupDone$#$
    {33, 320, 507},	// Solid::StorageAccess::setupRequested$
    {33, 326, 512},	// Solid::StorageAccess::staticMetaObject
    {33, 341, 503},	// Solid::StorageAccess::teardown
    {33, 343, 506},	// Solid::StorageAccess::teardownDone$#$
    {33, 345, 508},	// Solid::StorageAccess::teardownRequested$
    {33, 349, 510},	// Solid::StorageAccess::tr$
    {33, 350, 493},	// Solid::StorageAccess::tr$$
    {33, 351, 495},	// Solid::StorageAccess::tr$$$
    {33, 353, 511},	// Solid::StorageAccess::trUtf8$
    {33, 354, 494},	// Solid::StorageAccess::trUtf8$$
    {33, 355, 496},	// Solid::StorageAccess::trUtf8$$$
    {33, 386, 513},	// Solid::StorageAccess::~StorageAccess
    {35, 25, 539},	// Solid::StorageDrive::CdromDrive
    {35, 28, 542},	// Solid::StorageDrive::CompactFlash
    {35, 74, 540},	// Solid::StorageDrive::Floppy
    {35, 76, 538},	// Solid::StorageDrive::HardDisk
    {35, 86, 532},	// Solid::StorageDrive::Ide
    {35, 87, 534},	// Solid::StorageDrive::Ieee1394
    {35, 104, 543},	// Solid::StorageDrive::MemoryStick
    {35, 125, 537},	// Solid::StorageDrive::Platform
    {35, 140, 536},	// Solid::StorageDrive::Sata
    {35, 141, 535},	// Solid::StorageDrive::Scsi
    {35, 142, 545},	// Solid::StorageDrive::SdMmc
    {35, 146, 544},	// Solid::StorageDrive::SmartMedia
    {35, 151, 528},	// Solid::StorageDrive::StorageDrive##
    {35, 157, 541},	// Solid::StorageDrive::Tape
    {35, 168, 533},	// Solid::StorageDrive::Usb
    {35, 175, 546},	// Solid::StorageDrive::Xd
    {35, 190, 522},	// Solid::StorageDrive::bus
    {35, 213, 521},	// Solid::StorageDrive::deviceInterfaceType
    {35, 221, 523},	// Solid::StorageDrive::driveType
    {35, 253, 525},	// Solid::StorageDrive::isHotpluggable
    {35, 255, 527},	// Solid::StorageDrive::isInUse
    {35, 259, 524},	// Solid::StorageDrive::isRemovable
    {35, 277, 514},	// Solid::StorageDrive::metaObject
    {35, 308, 520},	// Solid::StorageDrive::qt_metacall$$?
    {35, 310, 515},	// Solid::StorageDrive::qt_metacast$
    {35, 323, 526},	// Solid::StorageDrive::size
    {35, 326, 531},	// Solid::StorageDrive::staticMetaObject
    {35, 349, 529},	// Solid::StorageDrive::tr$
    {35, 350, 516},	// Solid::StorageDrive::tr$$
    {35, 351, 518},	// Solid::StorageDrive::tr$$$
    {35, 353, 530},	// Solid::StorageDrive::trUtf8$
    {35, 354, 517},	// Solid::StorageDrive::trUtf8$$
    {35, 355, 519},	// Solid::StorageDrive::trUtf8$$$
    {35, 387, 547},	// Solid::StorageDrive::~StorageDrive
    {37, 70, 572},	// Solid::StorageVolume::Encrypted
    {37, 72, 569},	// Solid::StorageVolume::FileSystem
    {37, 121, 567},	// Solid::StorageVolume::Other
    {37, 122, 570},	// Solid::StorageVolume::PartitionTable
    {37, 139, 571},	// Solid::StorageVolume::Raid
    {37, 153, 563},	// Solid::StorageVolume::StorageVolume##
    {37, 166, 568},	// Solid::StorageVolume::Unused
    {37, 213, 555},	// Solid::StorageVolume::deviceInterfaceType
    {37, 233, 562},	// Solid::StorageVolume::encryptedContainer
    {37, 240, 558},	// Solid::StorageVolume::fsType
    {37, 254, 556},	// Solid::StorageVolume::isIgnored
    {37, 263, 559},	// Solid::StorageVolume::label
    {37, 277, 548},	// Solid::StorageVolume::metaObject
    {37, 308, 554},	// Solid::StorageVolume::qt_metacall$$?
    {37, 310, 549},	// Solid::StorageVolume::qt_metacast$
    {37, 323, 561},	// Solid::StorageVolume::size
    {37, 326, 566},	// Solid::StorageVolume::staticMetaObject
    {37, 349, 564},	// Solid::StorageVolume::tr$
    {37, 350, 550},	// Solid::StorageVolume::tr$$
    {37, 351, 552},	// Solid::StorageVolume::tr$$$
    {37, 353, 565},	// Solid::StorageVolume::trUtf8$
    {37, 354, 551},	// Solid::StorageVolume::trUtf8$$
    {37, 355, 553},	// Solid::StorageVolume::trUtf8$$$
    {37, 362, 557},	// Solid::StorageVolume::usage
    {37, 364, 560},	// Solid::StorageVolume::uuid
    {37, 388, 573},	// Solid::StorageVolume::~StorageVolume
    {39, 213, 581},	// Solid::Video::deviceInterfaceType
    {39, 224, 584},	// Solid::Video::driverHandle$
    {39, 277, 574},	// Solid::Video::metaObject
    {39, 308, 580},	// Solid::Video::qt_metacall$$?
    {39, 310, 575},	// Solid::Video::qt_metacast$
    {39, 326, 588},	// Solid::Video::staticMetaObject
    {39, 336, 587},	// Solid::Video::supportedDrivers
    {39, 337, 583},	// Solid::Video::supportedDrivers$
    {39, 339, 582},	// Solid::Video::supportedProtocols
    {39, 349, 585},	// Solid::Video::tr$
    {39, 350, 576},	// Solid::Video::tr$$
    {39, 351, 578},	// Solid::Video::tr$$$
    {39, 353, 586},	// Solid::Video::trUtf8$
    {39, 354, 577},	// Solid::Video::trUtf8$$
    {39, 355, 579},	// Solid::Video::trUtf8$$$
    {39, 389, 589},	// Solid::Video::~Video
};

}

extern "C" {

SMOKE_IMPORT void init_qtcore_Smoke();

static bool initialized = false;
Smoke *solid_Smoke = 0;

// Create the Smoke instance encapsulating all the above.
void init_solid_Smoke() {
    init_qtcore_Smoke();
    if (initialized) return;
    solid_Smoke = new Smoke(
        "solid",
        __smokesolid::classes, 39,
        __smokesolid::methods, 590,
        __smokesolid::methodMaps, 579,
        __smokesolid::methodNames, 389,
        __smokesolid::types, 149,
        __smokesolid::inheritanceList,
        __smokesolid::argumentList,
        __smokesolid::ambiguousMethodList,
        __smokesolid::cast );
    initialized = true;
}

void delete_solid_Smoke() { delete solid_Smoke; }

}
