#include <plasma_includes.h>

#include <smoke.h>
#include <plasma_smoke.h>

namespace __smokeplasma {

static void *cast(void *xptr, Smoke::Index from, Smoke::Index to) {
  switch(from) {
    case 1:   //KAction
      switch(to) {
        case 1: return (void*)(KAction*)xptr;
        default: return xptr;
      }
    case 2:   //KActionCollection
      switch(to) {
        case 2: return (void*)(KActionCollection*)xptr;
        default: return xptr;
      }
    case 3:   //KComboBox
      switch(to) {
        case 3: return (void*)(KComboBox*)xptr;
        default: return xptr;
      }
    case 4:   //KConfigBase
      switch(to) {
        case 4: return (void*)(KConfigBase*)xptr;
        default: return xptr;
      }
    case 5:   //KConfigDialog
      switch(to) {
        case 5: return (void*)(KConfigDialog*)xptr;
        default: return xptr;
      }
    case 6:   //KConfigGroup
      switch(to) {
        case 4: return (void*)(KConfigBase*)(KConfigGroup*)xptr;
        case 6: return (void*)(KConfigGroup*)xptr;
        default: return xptr;
      }
    case 7:   //KConfigSkeleton
      switch(to) {
        case 9: return (void*)(KCoreConfigSkeleton*)(KConfigSkeleton*)xptr;
        case 162: return (void*)(QObject*)(KConfigSkeleton*)xptr;
        case 7: return (void*)(KConfigSkeleton*)xptr;
        case 45: return (void*)(Plasma::ConfigLoader*)(KConfigSkeleton*)xptr;
        default: return xptr;
      }
    case 8:   //KConfigSkeletonItem
      switch(to) {
        case 8: return (void*)(KConfigSkeletonItem*)xptr;
        default: return xptr;
      }
    case 9:   //KCoreConfigSkeleton
      switch(to) {
        case 162: return (void*)(QObject*)(KCoreConfigSkeleton*)xptr;
        case 9: return (void*)(KCoreConfigSkeleton*)xptr;
        case 45: return (void*)(Plasma::ConfigLoader*)(KCoreConfigSkeleton*)xptr;
        default: return xptr;
      }
    case 10:   //KIcon
      switch(to) {
        case 150: return (void*)(QIcon*)(KIcon*)xptr;
        case 10: return (void*)(KIcon*)xptr;
        default: return xptr;
      }
    case 11:   //KIntSpinBox
      switch(to) {
        case 11: return (void*)(KIntSpinBox*)xptr;
        default: return xptr;
      }
    case 12:   //KJob
      switch(to) {
        case 162: return (void*)(QObject*)(KJob*)xptr;
        case 12: return (void*)(KJob*)xptr;
        case 31: return (void*)(Plasma::AccessAppletJob*)(KJob*)xptr;
        case 88: return (void*)(Plasma::ServiceAccessJob*)(KJob*)xptr;
        default: return xptr;
      }
    case 13:   //KLineEdit
      switch(to) {
        case 13: return (void*)(KLineEdit*)xptr;
        default: return xptr;
      }
    case 14:   //KPluginInfo
      switch(to) {
        case 14: return (void*)(KPluginInfo*)xptr;
        default: return xptr;
      }
    case 15:   //KPushButton
      switch(to) {
        case 15: return (void*)(KPushButton*)xptr;
        default: return xptr;
      }
    case 16:   //KService
      switch(to) {
        case 178: return (void*)(QSharedData*)(KService*)xptr;
        case 16: return (void*)(KService*)xptr;
        default: return xptr;
      }
    case 17:   //KServiceAction
      switch(to) {
        case 17: return (void*)(KServiceAction*)xptr;
        default: return xptr;
      }
    case 18:   //KSharedConfig
      switch(to) {
        case 4: return (void*)(KConfigBase*)(KSharedConfig*)xptr;
        case 178: return (void*)(QSharedData*)(KSharedConfig*)xptr;
        case 18: return (void*)(KSharedConfig*)xptr;
        default: return xptr;
      }
    case 19:   //KShortcut
      switch(to) {
        case 19: return (void*)(KShortcut*)xptr;
        default: return xptr;
      }
    case 20:   //KTabBar
      switch(to) {
        case 198: return (void*)(QWidget*)(KTabBar*)xptr;
        case 162: return (void*)(QObject*)(KTabBar*)xptr;
        case 20: return (void*)(KTabBar*)xptr;
        default: return xptr;
      }
    case 21:   //KTextBrowser
      switch(to) {
        case 21: return (void*)(KTextBrowser*)xptr;
        default: return xptr;
      }
    case 22:   //KTextEdit
      switch(to) {
        case 22: return (void*)(KTextEdit*)xptr;
        default: return xptr;
      }
    case 23:   //KUrl
      switch(to) {
        case 193: return (void*)(QUrl*)(KUrl*)xptr;
        case 23: return (void*)(KUrl*)xptr;
        default: return xptr;
      }
    case 24:   //Phonon::AudioOutput
      switch(to) {
        case 24: return (void*)(Phonon::AudioOutput*)xptr;
        default: return xptr;
      }
    case 25:   //Phonon::MediaObject
      switch(to) {
        case 25: return (void*)(Phonon::MediaObject*)xptr;
        default: return xptr;
      }
    case 26:   //Phonon::VideoWidget
      switch(to) {
        case 26: return (void*)(Phonon::VideoWidget*)xptr;
        default: return xptr;
      }
    case 28:   //Plasma::AbstractDialogManager
      switch(to) {
        case 162: return (void*)(QObject*)(Plasma::AbstractDialogManager*)xptr;
        case 28: return (void*)(Plasma::AbstractDialogManager*)xptr;
        default: return xptr;
      }
    case 29:   //Plasma::AbstractRunner
      switch(to) {
        case 162: return (void*)(QObject*)(Plasma::AbstractRunner*)xptr;
        case 29: return (void*)(Plasma::AbstractRunner*)xptr;
        default: return xptr;
      }
    case 30:   //Plasma::AbstractToolBox
      switch(to) {
        case 146: return (void*)(QGraphicsWidget*)(Plasma::AbstractToolBox*)xptr;
        case 134: return (void*)(QGraphicsObject*)(Plasma::AbstractToolBox*)xptr;
        case 162: return (void*)(QObject*)(Plasma::AbstractToolBox*)xptr;
        case 132: return (void*)(QGraphicsItem*)(Plasma::AbstractToolBox*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(Plasma::AbstractToolBox*)xptr;
        case 30: return (void*)(Plasma::AbstractToolBox*)xptr;
        default: return xptr;
      }
    case 31:   //Plasma::AccessAppletJob
      switch(to) {
        case 12: return (void*)(KJob*)(Plasma::AccessAppletJob*)xptr;
        case 162: return (void*)(QObject*)(Plasma::AccessAppletJob*)xptr;
        case 31: return (void*)(Plasma::AccessAppletJob*)xptr;
        default: return xptr;
      }
    case 32:   //Plasma::AccessManager
      switch(to) {
        case 162: return (void*)(QObject*)(Plasma::AccessManager*)xptr;
        case 32: return (void*)(Plasma::AccessManager*)xptr;
        default: return xptr;
      }
    case 33:   //Plasma::Animation
      switch(to) {
        case 108: return (void*)(QAbstractAnimation*)(Plasma::Animation*)xptr;
        case 162: return (void*)(QObject*)(Plasma::Animation*)xptr;
        case 33: return (void*)(Plasma::Animation*)xptr;
        default: return xptr;
      }
    case 34:   //Plasma::AnimationDriver
      switch(to) {
        case 162: return (void*)(QObject*)(Plasma::AnimationDriver*)xptr;
        case 34: return (void*)(Plasma::AnimationDriver*)xptr;
        default: return xptr;
      }
    case 35:   //Plasma::Animator
      switch(to) {
        case 162: return (void*)(QObject*)(Plasma::Animator*)xptr;
        case 35: return (void*)(Plasma::Animator*)xptr;
        default: return xptr;
      }
    case 36:   //Plasma::Applet
      switch(to) {
        case 146: return (void*)(QGraphicsWidget*)(Plasma::Applet*)xptr;
        case 134: return (void*)(QGraphicsObject*)(Plasma::Applet*)xptr;
        case 162: return (void*)(QObject*)(Plasma::Applet*)xptr;
        case 132: return (void*)(QGraphicsItem*)(Plasma::Applet*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(Plasma::Applet*)xptr;
        case 36: return (void*)(Plasma::Applet*)xptr;
        case 46: return (void*)(Plasma::Containment*)(Plasma::Applet*)xptr;
        case 64: return (void*)(Plasma::GLApplet*)(Plasma::Applet*)xptr;
        case 75: return (void*)(Plasma::PopupApplet*)(Plasma::Applet*)xptr;
        default: return xptr;
      }
    case 37:   //Plasma::AppletScript
      switch(to) {
        case 83: return (void*)(Plasma::ScriptEngine*)(Plasma::AppletScript*)xptr;
        case 162: return (void*)(QObject*)(Plasma::AppletScript*)xptr;
        case 37: return (void*)(Plasma::AppletScript*)xptr;
        default: return xptr;
      }
    case 38:   //Plasma::AuthorizationInterface
      switch(to) {
        case 38: return (void*)(Plasma::AuthorizationInterface*)xptr;
        default: return xptr;
      }
    case 39:   //Plasma::AuthorizationManager
      switch(to) {
        case 162: return (void*)(QObject*)(Plasma::AuthorizationManager*)xptr;
        case 39: return (void*)(Plasma::AuthorizationManager*)xptr;
        default: return xptr;
      }
    case 40:   //Plasma::AuthorizationRule
      switch(to) {
        case 162: return (void*)(QObject*)(Plasma::AuthorizationRule*)xptr;
        case 40: return (void*)(Plasma::AuthorizationRule*)xptr;
        default: return xptr;
      }
    case 41:   //Plasma::BusyWidget
      switch(to) {
        case 146: return (void*)(QGraphicsWidget*)(Plasma::BusyWidget*)xptr;
        case 134: return (void*)(QGraphicsObject*)(Plasma::BusyWidget*)xptr;
        case 162: return (void*)(QObject*)(Plasma::BusyWidget*)xptr;
        case 132: return (void*)(QGraphicsItem*)(Plasma::BusyWidget*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(Plasma::BusyWidget*)xptr;
        case 41: return (void*)(Plasma::BusyWidget*)xptr;
        default: return xptr;
      }
    case 42:   //Plasma::CheckBox
      switch(to) {
        case 135: return (void*)(QGraphicsProxyWidget*)(Plasma::CheckBox*)xptr;
        case 146: return (void*)(QGraphicsWidget*)(Plasma::CheckBox*)xptr;
        case 134: return (void*)(QGraphicsObject*)(Plasma::CheckBox*)xptr;
        case 162: return (void*)(QObject*)(Plasma::CheckBox*)xptr;
        case 132: return (void*)(QGraphicsItem*)(Plasma::CheckBox*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(Plasma::CheckBox*)xptr;
        case 42: return (void*)(Plasma::CheckBox*)xptr;
        default: return xptr;
      }
    case 43:   //Plasma::ClientPinRequest
      switch(to) {
        case 162: return (void*)(QObject*)(Plasma::ClientPinRequest*)xptr;
        case 43: return (void*)(Plasma::ClientPinRequest*)xptr;
        default: return xptr;
      }
    case 44:   //Plasma::ComboBox
      switch(to) {
        case 135: return (void*)(QGraphicsProxyWidget*)(Plasma::ComboBox*)xptr;
        case 146: return (void*)(QGraphicsWidget*)(Plasma::ComboBox*)xptr;
        case 134: return (void*)(QGraphicsObject*)(Plasma::ComboBox*)xptr;
        case 162: return (void*)(QObject*)(Plasma::ComboBox*)xptr;
        case 132: return (void*)(QGraphicsItem*)(Plasma::ComboBox*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(Plasma::ComboBox*)xptr;
        case 44: return (void*)(Plasma::ComboBox*)xptr;
        default: return xptr;
      }
    case 45:   //Plasma::ConfigLoader
      switch(to) {
        case 7: return (void*)(KConfigSkeleton*)(Plasma::ConfigLoader*)xptr;
        case 9: return (void*)(KCoreConfigSkeleton*)(Plasma::ConfigLoader*)xptr;
        case 162: return (void*)(QObject*)(Plasma::ConfigLoader*)xptr;
        case 45: return (void*)(Plasma::ConfigLoader*)xptr;
        default: return xptr;
      }
    case 46:   //Plasma::Containment
      switch(to) {
        case 36: return (void*)(Plasma::Applet*)(Plasma::Containment*)xptr;
        case 146: return (void*)(QGraphicsWidget*)(Plasma::Containment*)xptr;
        case 134: return (void*)(QGraphicsObject*)(Plasma::Containment*)xptr;
        case 162: return (void*)(QObject*)(Plasma::Containment*)xptr;
        case 132: return (void*)(QGraphicsItem*)(Plasma::Containment*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(Plasma::Containment*)xptr;
        case 46: return (void*)(Plasma::Containment*)xptr;
        default: return xptr;
      }
    case 47:   //Plasma::Containment::StyleOption
      switch(to) {
        case 185: return (void*)(QStyleOptionGraphicsItem*)(Plasma::Containment::StyleOption*)xptr;
        case 184: return (void*)(QStyleOption*)(Plasma::Containment::StyleOption*)xptr;
        case 47: return (void*)(Plasma::Containment::StyleOption*)xptr;
        default: return xptr;
      }
    case 48:   //Plasma::ContainmentActions
      switch(to) {
        case 162: return (void*)(QObject*)(Plasma::ContainmentActions*)xptr;
        case 48: return (void*)(Plasma::ContainmentActions*)xptr;
        default: return xptr;
      }
    case 49:   //Plasma::ContainmentActionsPluginsConfig
      switch(to) {
        case 49: return (void*)(Plasma::ContainmentActionsPluginsConfig*)xptr;
        default: return xptr;
      }
    case 50:   //Plasma::Context
      switch(to) {
        case 162: return (void*)(QObject*)(Plasma::Context*)xptr;
        case 50: return (void*)(Plasma::Context*)xptr;
        default: return xptr;
      }
    case 51:   //Plasma::Corona
      switch(to) {
        case 136: return (void*)(QGraphicsScene*)(Plasma::Corona*)xptr;
        case 162: return (void*)(QObject*)(Plasma::Corona*)xptr;
        case 51: return (void*)(Plasma::Corona*)xptr;
        default: return xptr;
      }
    case 52:   //Plasma::DataContainer
      switch(to) {
        case 162: return (void*)(QObject*)(Plasma::DataContainer*)xptr;
        case 52: return (void*)(Plasma::DataContainer*)xptr;
        default: return xptr;
      }
    case 53:   //Plasma::DataEngine
      switch(to) {
        case 162: return (void*)(QObject*)(Plasma::DataEngine*)xptr;
        case 53: return (void*)(Plasma::DataEngine*)xptr;
        default: return xptr;
      }
    case 54:   //Plasma::DataEngineManager
      switch(to) {
        case 162: return (void*)(QObject*)(Plasma::DataEngineManager*)xptr;
        case 54: return (void*)(Plasma::DataEngineManager*)xptr;
        default: return xptr;
      }
    case 55:   //Plasma::DataEngineScript
      switch(to) {
        case 83: return (void*)(Plasma::ScriptEngine*)(Plasma::DataEngineScript*)xptr;
        case 162: return (void*)(QObject*)(Plasma::DataEngineScript*)xptr;
        case 55: return (void*)(Plasma::DataEngineScript*)xptr;
        default: return xptr;
      }
    case 56:   //Plasma::Delegate
      switch(to) {
        case 109: return (void*)(QAbstractItemDelegate*)(Plasma::Delegate*)xptr;
        case 162: return (void*)(QObject*)(Plasma::Delegate*)xptr;
        case 56: return (void*)(Plasma::Delegate*)xptr;
        default: return xptr;
      }
    case 57:   //Plasma::Dialog
      switch(to) {
        case 198: return (void*)(QWidget*)(Plasma::Dialog*)xptr;
        case 162: return (void*)(QObject*)(Plasma::Dialog*)xptr;
        case 57: return (void*)(Plasma::Dialog*)xptr;
        default: return xptr;
      }
    case 58:   //Plasma::Extender
      switch(to) {
        case 146: return (void*)(QGraphicsWidget*)(Plasma::Extender*)xptr;
        case 134: return (void*)(QGraphicsObject*)(Plasma::Extender*)xptr;
        case 162: return (void*)(QObject*)(Plasma::Extender*)xptr;
        case 132: return (void*)(QGraphicsItem*)(Plasma::Extender*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(Plasma::Extender*)xptr;
        case 58: return (void*)(Plasma::Extender*)xptr;
        default: return xptr;
      }
    case 59:   //Plasma::ExtenderGroup
      switch(to) {
        case 60: return (void*)(Plasma::ExtenderItem*)(Plasma::ExtenderGroup*)xptr;
        case 146: return (void*)(QGraphicsWidget*)(Plasma::ExtenderGroup*)xptr;
        case 134: return (void*)(QGraphicsObject*)(Plasma::ExtenderGroup*)xptr;
        case 162: return (void*)(QObject*)(Plasma::ExtenderGroup*)xptr;
        case 132: return (void*)(QGraphicsItem*)(Plasma::ExtenderGroup*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(Plasma::ExtenderGroup*)xptr;
        case 59: return (void*)(Plasma::ExtenderGroup*)xptr;
        default: return xptr;
      }
    case 60:   //Plasma::ExtenderItem
      switch(to) {
        case 146: return (void*)(QGraphicsWidget*)(Plasma::ExtenderItem*)xptr;
        case 134: return (void*)(QGraphicsObject*)(Plasma::ExtenderItem*)xptr;
        case 162: return (void*)(QObject*)(Plasma::ExtenderItem*)xptr;
        case 132: return (void*)(QGraphicsItem*)(Plasma::ExtenderItem*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(Plasma::ExtenderItem*)xptr;
        case 60: return (void*)(Plasma::ExtenderItem*)xptr;
        case 59: return (void*)(Plasma::ExtenderGroup*)(Plasma::ExtenderItem*)xptr;
        default: return xptr;
      }
    case 61:   //Plasma::FlashingLabel
      switch(to) {
        case 146: return (void*)(QGraphicsWidget*)(Plasma::FlashingLabel*)xptr;
        case 134: return (void*)(QGraphicsObject*)(Plasma::FlashingLabel*)xptr;
        case 162: return (void*)(QObject*)(Plasma::FlashingLabel*)xptr;
        case 132: return (void*)(QGraphicsItem*)(Plasma::FlashingLabel*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(Plasma::FlashingLabel*)xptr;
        case 61: return (void*)(Plasma::FlashingLabel*)xptr;
        default: return xptr;
      }
    case 62:   //Plasma::Frame
      switch(to) {
        case 146: return (void*)(QGraphicsWidget*)(Plasma::Frame*)xptr;
        case 134: return (void*)(QGraphicsObject*)(Plasma::Frame*)xptr;
        case 162: return (void*)(QObject*)(Plasma::Frame*)xptr;
        case 132: return (void*)(QGraphicsItem*)(Plasma::Frame*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(Plasma::Frame*)xptr;
        case 62: return (void*)(Plasma::Frame*)xptr;
        default: return xptr;
      }
    case 63:   //Plasma::FrameSvg
      switch(to) {
        case 93: return (void*)(Plasma::Svg*)(Plasma::FrameSvg*)xptr;
        case 162: return (void*)(QObject*)(Plasma::FrameSvg*)xptr;
        case 63: return (void*)(Plasma::FrameSvg*)xptr;
        default: return xptr;
      }
    case 64:   //Plasma::GLApplet
      switch(to) {
        case 36: return (void*)(Plasma::Applet*)(Plasma::GLApplet*)xptr;
        case 146: return (void*)(QGraphicsWidget*)(Plasma::GLApplet*)xptr;
        case 134: return (void*)(QGraphicsObject*)(Plasma::GLApplet*)xptr;
        case 162: return (void*)(QObject*)(Plasma::GLApplet*)xptr;
        case 132: return (void*)(QGraphicsItem*)(Plasma::GLApplet*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(Plasma::GLApplet*)xptr;
        case 64: return (void*)(Plasma::GLApplet*)xptr;
        default: return xptr;
      }
    case 65:   //Plasma::GroupBox
      switch(to) {
        case 135: return (void*)(QGraphicsProxyWidget*)(Plasma::GroupBox*)xptr;
        case 146: return (void*)(QGraphicsWidget*)(Plasma::GroupBox*)xptr;
        case 134: return (void*)(QGraphicsObject*)(Plasma::GroupBox*)xptr;
        case 162: return (void*)(QObject*)(Plasma::GroupBox*)xptr;
        case 132: return (void*)(QGraphicsItem*)(Plasma::GroupBox*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(Plasma::GroupBox*)xptr;
        case 65: return (void*)(Plasma::GroupBox*)xptr;
        default: return xptr;
      }
    case 66:   //Plasma::IconWidget
      switch(to) {
        case 146: return (void*)(QGraphicsWidget*)(Plasma::IconWidget*)xptr;
        case 134: return (void*)(QGraphicsObject*)(Plasma::IconWidget*)xptr;
        case 162: return (void*)(QObject*)(Plasma::IconWidget*)xptr;
        case 132: return (void*)(QGraphicsItem*)(Plasma::IconWidget*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(Plasma::IconWidget*)xptr;
        case 66: return (void*)(Plasma::IconWidget*)xptr;
        default: return xptr;
      }
    case 67:   //Plasma::ItemBackground
      switch(to) {
        case 146: return (void*)(QGraphicsWidget*)(Plasma::ItemBackground*)xptr;
        case 134: return (void*)(QGraphicsObject*)(Plasma::ItemBackground*)xptr;
        case 162: return (void*)(QObject*)(Plasma::ItemBackground*)xptr;
        case 132: return (void*)(QGraphicsItem*)(Plasma::ItemBackground*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(Plasma::ItemBackground*)xptr;
        case 67: return (void*)(Plasma::ItemBackground*)xptr;
        default: return xptr;
      }
    case 68:   //Plasma::Label
      switch(to) {
        case 135: return (void*)(QGraphicsProxyWidget*)(Plasma::Label*)xptr;
        case 146: return (void*)(QGraphicsWidget*)(Plasma::Label*)xptr;
        case 134: return (void*)(QGraphicsObject*)(Plasma::Label*)xptr;
        case 162: return (void*)(QObject*)(Plasma::Label*)xptr;
        case 132: return (void*)(QGraphicsItem*)(Plasma::Label*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(Plasma::Label*)xptr;
        case 68: return (void*)(Plasma::Label*)xptr;
        default: return xptr;
      }
    case 69:   //Plasma::LineEdit
      switch(to) {
        case 135: return (void*)(QGraphicsProxyWidget*)(Plasma::LineEdit*)xptr;
        case 146: return (void*)(QGraphicsWidget*)(Plasma::LineEdit*)xptr;
        case 134: return (void*)(QGraphicsObject*)(Plasma::LineEdit*)xptr;
        case 162: return (void*)(QObject*)(Plasma::LineEdit*)xptr;
        case 132: return (void*)(QGraphicsItem*)(Plasma::LineEdit*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(Plasma::LineEdit*)xptr;
        case 69: return (void*)(Plasma::LineEdit*)xptr;
        default: return xptr;
      }
    case 70:   //Plasma::Meter
      switch(to) {
        case 146: return (void*)(QGraphicsWidget*)(Plasma::Meter*)xptr;
        case 134: return (void*)(QGraphicsObject*)(Plasma::Meter*)xptr;
        case 162: return (void*)(QObject*)(Plasma::Meter*)xptr;
        case 132: return (void*)(QGraphicsItem*)(Plasma::Meter*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(Plasma::Meter*)xptr;
        case 70: return (void*)(Plasma::Meter*)xptr;
        default: return xptr;
      }
    case 71:   //Plasma::Package
      switch(to) {
        case 71: return (void*)(Plasma::Package*)xptr;
        default: return xptr;
      }
    case 72:   //Plasma::PackageMetadata
      switch(to) {
        case 72: return (void*)(Plasma::PackageMetadata*)xptr;
        default: return xptr;
      }
    case 73:   //Plasma::PackageStructure
      switch(to) {
        case 162: return (void*)(QObject*)(Plasma::PackageStructure*)xptr;
        case 178: return (void*)(QSharedData*)(Plasma::PackageStructure*)xptr;
        case 73: return (void*)(Plasma::PackageStructure*)xptr;
        default: return xptr;
      }
    case 74:   //Plasma::PlotColor
      switch(to) {
        case 74: return (void*)(Plasma::PlotColor*)xptr;
        default: return xptr;
      }
    case 75:   //Plasma::PopupApplet
      switch(to) {
        case 36: return (void*)(Plasma::Applet*)(Plasma::PopupApplet*)xptr;
        case 146: return (void*)(QGraphicsWidget*)(Plasma::PopupApplet*)xptr;
        case 134: return (void*)(QGraphicsObject*)(Plasma::PopupApplet*)xptr;
        case 162: return (void*)(QObject*)(Plasma::PopupApplet*)xptr;
        case 132: return (void*)(QGraphicsItem*)(Plasma::PopupApplet*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(Plasma::PopupApplet*)xptr;
        case 75: return (void*)(Plasma::PopupApplet*)xptr;
        default: return xptr;
      }
    case 76:   //Plasma::PushButton
      switch(to) {
        case 135: return (void*)(QGraphicsProxyWidget*)(Plasma::PushButton*)xptr;
        case 146: return (void*)(QGraphicsWidget*)(Plasma::PushButton*)xptr;
        case 134: return (void*)(QGraphicsObject*)(Plasma::PushButton*)xptr;
        case 162: return (void*)(QObject*)(Plasma::PushButton*)xptr;
        case 132: return (void*)(QGraphicsItem*)(Plasma::PushButton*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(Plasma::PushButton*)xptr;
        case 76: return (void*)(Plasma::PushButton*)xptr;
        default: return xptr;
      }
    case 77:   //Plasma::QueryMatch
      switch(to) {
        case 77: return (void*)(Plasma::QueryMatch*)xptr;
        default: return xptr;
      }
    case 78:   //Plasma::RadioButton
      switch(to) {
        case 135: return (void*)(QGraphicsProxyWidget*)(Plasma::RadioButton*)xptr;
        case 146: return (void*)(QGraphicsWidget*)(Plasma::RadioButton*)xptr;
        case 134: return (void*)(QGraphicsObject*)(Plasma::RadioButton*)xptr;
        case 162: return (void*)(QObject*)(Plasma::RadioButton*)xptr;
        case 132: return (void*)(QGraphicsItem*)(Plasma::RadioButton*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(Plasma::RadioButton*)xptr;
        case 78: return (void*)(Plasma::RadioButton*)xptr;
        default: return xptr;
      }
    case 79:   //Plasma::RunnerContext
      switch(to) {
        case 162: return (void*)(QObject*)(Plasma::RunnerContext*)xptr;
        case 79: return (void*)(Plasma::RunnerContext*)xptr;
        default: return xptr;
      }
    case 80:   //Plasma::RunnerManager
      switch(to) {
        case 162: return (void*)(QObject*)(Plasma::RunnerManager*)xptr;
        case 80: return (void*)(Plasma::RunnerManager*)xptr;
        default: return xptr;
      }
    case 81:   //Plasma::RunnerScript
      switch(to) {
        case 83: return (void*)(Plasma::ScriptEngine*)(Plasma::RunnerScript*)xptr;
        case 162: return (void*)(QObject*)(Plasma::RunnerScript*)xptr;
        case 81: return (void*)(Plasma::RunnerScript*)xptr;
        default: return xptr;
      }
    case 82:   //Plasma::RunnerSyntax
      switch(to) {
        case 82: return (void*)(Plasma::RunnerSyntax*)xptr;
        default: return xptr;
      }
    case 83:   //Plasma::ScriptEngine
      switch(to) {
        case 162: return (void*)(QObject*)(Plasma::ScriptEngine*)xptr;
        case 83: return (void*)(Plasma::ScriptEngine*)xptr;
        case 55: return (void*)(Plasma::DataEngineScript*)(Plasma::ScriptEngine*)xptr;
        case 106: return (void*)(Plasma::WallpaperScript*)(Plasma::ScriptEngine*)xptr;
        case 81: return (void*)(Plasma::RunnerScript*)(Plasma::ScriptEngine*)xptr;
        case 37: return (void*)(Plasma::AppletScript*)(Plasma::ScriptEngine*)xptr;
        default: return xptr;
      }
    case 84:   //Plasma::ScrollBar
      switch(to) {
        case 135: return (void*)(QGraphicsProxyWidget*)(Plasma::ScrollBar*)xptr;
        case 146: return (void*)(QGraphicsWidget*)(Plasma::ScrollBar*)xptr;
        case 134: return (void*)(QGraphicsObject*)(Plasma::ScrollBar*)xptr;
        case 162: return (void*)(QObject*)(Plasma::ScrollBar*)xptr;
        case 132: return (void*)(QGraphicsItem*)(Plasma::ScrollBar*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(Plasma::ScrollBar*)xptr;
        case 84: return (void*)(Plasma::ScrollBar*)xptr;
        default: return xptr;
      }
    case 85:   //Plasma::ScrollWidget
      switch(to) {
        case 146: return (void*)(QGraphicsWidget*)(Plasma::ScrollWidget*)xptr;
        case 134: return (void*)(QGraphicsObject*)(Plasma::ScrollWidget*)xptr;
        case 162: return (void*)(QObject*)(Plasma::ScrollWidget*)xptr;
        case 132: return (void*)(QGraphicsItem*)(Plasma::ScrollWidget*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(Plasma::ScrollWidget*)xptr;
        case 85: return (void*)(Plasma::ScrollWidget*)xptr;
        default: return xptr;
      }
    case 86:   //Plasma::Separator
      switch(to) {
        case 146: return (void*)(QGraphicsWidget*)(Plasma::Separator*)xptr;
        case 134: return (void*)(QGraphicsObject*)(Plasma::Separator*)xptr;
        case 162: return (void*)(QObject*)(Plasma::Separator*)xptr;
        case 132: return (void*)(QGraphicsItem*)(Plasma::Separator*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(Plasma::Separator*)xptr;
        case 86: return (void*)(Plasma::Separator*)xptr;
        default: return xptr;
      }
    case 87:   //Plasma::Service
      switch(to) {
        case 162: return (void*)(QObject*)(Plasma::Service*)xptr;
        case 87: return (void*)(Plasma::Service*)xptr;
        default: return xptr;
      }
    case 88:   //Plasma::ServiceAccessJob
      switch(to) {
        case 12: return (void*)(KJob*)(Plasma::ServiceAccessJob*)xptr;
        case 162: return (void*)(QObject*)(Plasma::ServiceAccessJob*)xptr;
        case 88: return (void*)(Plasma::ServiceAccessJob*)xptr;
        default: return xptr;
      }
    case 89:   //Plasma::ServiceJob
      switch(to) {
        case 89: return (void*)(Plasma::ServiceJob*)xptr;
        default: return xptr;
      }
    case 90:   //Plasma::SignalPlotter
      switch(to) {
        case 146: return (void*)(QGraphicsWidget*)(Plasma::SignalPlotter*)xptr;
        case 134: return (void*)(QGraphicsObject*)(Plasma::SignalPlotter*)xptr;
        case 162: return (void*)(QObject*)(Plasma::SignalPlotter*)xptr;
        case 132: return (void*)(QGraphicsItem*)(Plasma::SignalPlotter*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(Plasma::SignalPlotter*)xptr;
        case 90: return (void*)(Plasma::SignalPlotter*)xptr;
        default: return xptr;
      }
    case 91:   //Plasma::Slider
      switch(to) {
        case 135: return (void*)(QGraphicsProxyWidget*)(Plasma::Slider*)xptr;
        case 146: return (void*)(QGraphicsWidget*)(Plasma::Slider*)xptr;
        case 134: return (void*)(QGraphicsObject*)(Plasma::Slider*)xptr;
        case 162: return (void*)(QObject*)(Plasma::Slider*)xptr;
        case 132: return (void*)(QGraphicsItem*)(Plasma::Slider*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(Plasma::Slider*)xptr;
        case 91: return (void*)(Plasma::Slider*)xptr;
        default: return xptr;
      }
    case 92:   //Plasma::SpinBox
      switch(to) {
        case 135: return (void*)(QGraphicsProxyWidget*)(Plasma::SpinBox*)xptr;
        case 146: return (void*)(QGraphicsWidget*)(Plasma::SpinBox*)xptr;
        case 134: return (void*)(QGraphicsObject*)(Plasma::SpinBox*)xptr;
        case 162: return (void*)(QObject*)(Plasma::SpinBox*)xptr;
        case 132: return (void*)(QGraphicsItem*)(Plasma::SpinBox*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(Plasma::SpinBox*)xptr;
        case 92: return (void*)(Plasma::SpinBox*)xptr;
        default: return xptr;
      }
    case 93:   //Plasma::Svg
      switch(to) {
        case 162: return (void*)(QObject*)(Plasma::Svg*)xptr;
        case 93: return (void*)(Plasma::Svg*)xptr;
        case 63: return (void*)(Plasma::FrameSvg*)(Plasma::Svg*)xptr;
        default: return xptr;
      }
    case 94:   //Plasma::SvgWidget
      switch(to) {
        case 146: return (void*)(QGraphicsWidget*)(Plasma::SvgWidget*)xptr;
        case 134: return (void*)(QGraphicsObject*)(Plasma::SvgWidget*)xptr;
        case 162: return (void*)(QObject*)(Plasma::SvgWidget*)xptr;
        case 132: return (void*)(QGraphicsItem*)(Plasma::SvgWidget*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(Plasma::SvgWidget*)xptr;
        case 94: return (void*)(Plasma::SvgWidget*)xptr;
        default: return xptr;
      }
    case 95:   //Plasma::TabBar
      switch(to) {
        case 146: return (void*)(QGraphicsWidget*)(Plasma::TabBar*)xptr;
        case 134: return (void*)(QGraphicsObject*)(Plasma::TabBar*)xptr;
        case 162: return (void*)(QObject*)(Plasma::TabBar*)xptr;
        case 132: return (void*)(QGraphicsItem*)(Plasma::TabBar*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(Plasma::TabBar*)xptr;
        case 95: return (void*)(Plasma::TabBar*)xptr;
        default: return xptr;
      }
    case 96:   //Plasma::TextBrowser
      switch(to) {
        case 135: return (void*)(QGraphicsProxyWidget*)(Plasma::TextBrowser*)xptr;
        case 146: return (void*)(QGraphicsWidget*)(Plasma::TextBrowser*)xptr;
        case 134: return (void*)(QGraphicsObject*)(Plasma::TextBrowser*)xptr;
        case 162: return (void*)(QObject*)(Plasma::TextBrowser*)xptr;
        case 132: return (void*)(QGraphicsItem*)(Plasma::TextBrowser*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(Plasma::TextBrowser*)xptr;
        case 96: return (void*)(Plasma::TextBrowser*)xptr;
        default: return xptr;
      }
    case 97:   //Plasma::TextEdit
      switch(to) {
        case 135: return (void*)(QGraphicsProxyWidget*)(Plasma::TextEdit*)xptr;
        case 146: return (void*)(QGraphicsWidget*)(Plasma::TextEdit*)xptr;
        case 134: return (void*)(QGraphicsObject*)(Plasma::TextEdit*)xptr;
        case 162: return (void*)(QObject*)(Plasma::TextEdit*)xptr;
        case 132: return (void*)(QGraphicsItem*)(Plasma::TextEdit*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(Plasma::TextEdit*)xptr;
        case 97: return (void*)(Plasma::TextEdit*)xptr;
        default: return xptr;
      }
    case 98:   //Plasma::Theme
      switch(to) {
        case 162: return (void*)(QObject*)(Plasma::Theme*)xptr;
        case 98: return (void*)(Plasma::Theme*)xptr;
        default: return xptr;
      }
    case 99:   //Plasma::ToolButton
      switch(to) {
        case 135: return (void*)(QGraphicsProxyWidget*)(Plasma::ToolButton*)xptr;
        case 146: return (void*)(QGraphicsWidget*)(Plasma::ToolButton*)xptr;
        case 134: return (void*)(QGraphicsObject*)(Plasma::ToolButton*)xptr;
        case 162: return (void*)(QObject*)(Plasma::ToolButton*)xptr;
        case 132: return (void*)(QGraphicsItem*)(Plasma::ToolButton*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(Plasma::ToolButton*)xptr;
        case 99: return (void*)(Plasma::ToolButton*)xptr;
        default: return xptr;
      }
    case 100:   //Plasma::ToolTipContent
      switch(to) {
        case 100: return (void*)(Plasma::ToolTipContent*)xptr;
        default: return xptr;
      }
    case 101:   //Plasma::ToolTipManager
      switch(to) {
        case 162: return (void*)(QObject*)(Plasma::ToolTipManager*)xptr;
        case 101: return (void*)(Plasma::ToolTipManager*)xptr;
        default: return xptr;
      }
    case 102:   //Plasma::TreeView
      switch(to) {
        case 135: return (void*)(QGraphicsProxyWidget*)(Plasma::TreeView*)xptr;
        case 146: return (void*)(QGraphicsWidget*)(Plasma::TreeView*)xptr;
        case 134: return (void*)(QGraphicsObject*)(Plasma::TreeView*)xptr;
        case 162: return (void*)(QObject*)(Plasma::TreeView*)xptr;
        case 132: return (void*)(QGraphicsItem*)(Plasma::TreeView*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(Plasma::TreeView*)xptr;
        case 102: return (void*)(Plasma::TreeView*)xptr;
        default: return xptr;
      }
    case 103:   //Plasma::VideoWidget
      switch(to) {
        case 135: return (void*)(QGraphicsProxyWidget*)(Plasma::VideoWidget*)xptr;
        case 146: return (void*)(QGraphicsWidget*)(Plasma::VideoWidget*)xptr;
        case 134: return (void*)(QGraphicsObject*)(Plasma::VideoWidget*)xptr;
        case 162: return (void*)(QObject*)(Plasma::VideoWidget*)xptr;
        case 132: return (void*)(QGraphicsItem*)(Plasma::VideoWidget*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(Plasma::VideoWidget*)xptr;
        case 103: return (void*)(Plasma::VideoWidget*)xptr;
        default: return xptr;
      }
    case 104:   //Plasma::View
      switch(to) {
        case 145: return (void*)(QGraphicsView*)(Plasma::View*)xptr;
        case 111: return (void*)(QAbstractScrollArea*)(Plasma::View*)xptr;
        case 130: return (void*)(QFrame*)(Plasma::View*)xptr;
        case 198: return (void*)(QWidget*)(Plasma::View*)xptr;
        case 162: return (void*)(QObject*)(Plasma::View*)xptr;
        case 104: return (void*)(Plasma::View*)xptr;
        default: return xptr;
      }
    case 105:   //Plasma::Wallpaper
      switch(to) {
        case 162: return (void*)(QObject*)(Plasma::Wallpaper*)xptr;
        case 105: return (void*)(Plasma::Wallpaper*)xptr;
        default: return xptr;
      }
    case 106:   //Plasma::WallpaperScript
      switch(to) {
        case 83: return (void*)(Plasma::ScriptEngine*)(Plasma::WallpaperScript*)xptr;
        case 162: return (void*)(QObject*)(Plasma::WallpaperScript*)xptr;
        case 106: return (void*)(Plasma::WallpaperScript*)xptr;
        default: return xptr;
      }
    case 107:   //Plasma::WebView
      switch(to) {
        case 146: return (void*)(QGraphicsWidget*)(Plasma::WebView*)xptr;
        case 134: return (void*)(QGraphicsObject*)(Plasma::WebView*)xptr;
        case 162: return (void*)(QObject*)(Plasma::WebView*)xptr;
        case 132: return (void*)(QGraphicsItem*)(Plasma::WebView*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(Plasma::WebView*)xptr;
        case 107: return (void*)(Plasma::WebView*)xptr;
        default: return xptr;
      }
    case 108:   //QAbstractAnimation
      switch(to) {
        case 162: return (void*)(QObject*)(QAbstractAnimation*)xptr;
        case 108: return (void*)(QAbstractAnimation*)xptr;
        case 33: return (void*)(Plasma::Animation*)(QAbstractAnimation*)xptr;
        default: return xptr;
      }
    case 109:   //QAbstractItemDelegate
      switch(to) {
        case 162: return (void*)(QObject*)(QAbstractItemDelegate*)xptr;
        case 109: return (void*)(QAbstractItemDelegate*)xptr;
        case 56: return (void*)(Plasma::Delegate*)(QAbstractItemDelegate*)xptr;
        default: return xptr;
      }
    case 110:   //QAbstractItemModel
      switch(to) {
        case 162: return (void*)(QObject*)(QAbstractItemModel*)xptr;
        case 110: return (void*)(QAbstractItemModel*)xptr;
        default: return xptr;
      }
    case 111:   //QAbstractScrollArea
      switch(to) {
        case 130: return (void*)(QFrame*)(QAbstractScrollArea*)xptr;
        case 198: return (void*)(QWidget*)(QAbstractScrollArea*)xptr;
        case 162: return (void*)(QObject*)(QAbstractScrollArea*)xptr;
        case 111: return (void*)(QAbstractScrollArea*)xptr;
        case 104: return (void*)(Plasma::View*)(QAbstractScrollArea*)xptr;
        default: return xptr;
      }
    case 112:   //QAction
      switch(to) {
        case 112: return (void*)(QAction*)xptr;
        default: return xptr;
      }
    case 113:   //QActionEvent
      switch(to) {
        case 126: return (void*)(QEvent*)(QActionEvent*)xptr;
        case 113: return (void*)(QActionEvent*)xptr;
        default: return xptr;
      }
    case 114:   //QBool
      switch(to) {
        case 114: return (void*)(QBool*)xptr;
        default: return xptr;
      }
    case 115:   //QByteArray
      switch(to) {
        case 115: return (void*)(QByteArray*)xptr;
        default: return xptr;
      }
    case 116:   //QCheckBox
      switch(to) {
        case 116: return (void*)(QCheckBox*)xptr;
        default: return xptr;
      }
    case 117:   //QChildEvent
      switch(to) {
        case 126: return (void*)(QEvent*)(QChildEvent*)xptr;
        case 117: return (void*)(QChildEvent*)xptr;
        default: return xptr;
      }
    case 118:   //QCloseEvent
      switch(to) {
        case 126: return (void*)(QEvent*)(QCloseEvent*)xptr;
        case 118: return (void*)(QCloseEvent*)xptr;
        default: return xptr;
      }
    case 119:   //QColor
      switch(to) {
        case 119: return (void*)(QColor*)xptr;
        default: return xptr;
      }
    case 120:   //QContextMenuEvent
      switch(to) {
        case 126: return (void*)(QEvent*)(QContextMenuEvent*)xptr;
        case 120: return (void*)(QContextMenuEvent*)xptr;
        default: return xptr;
      }
    case 121:   //QDragEnterEvent
      switch(to) {
        case 123: return (void*)(QDragMoveEvent*)(QDragEnterEvent*)xptr;
        case 124: return (void*)(QDropEvent*)(QDragEnterEvent*)xptr;
        case 126: return (void*)(QEvent*)(QDragEnterEvent*)xptr;
        case 121: return (void*)(QDragEnterEvent*)xptr;
        default: return xptr;
      }
    case 122:   //QDragLeaveEvent
      switch(to) {
        case 126: return (void*)(QEvent*)(QDragLeaveEvent*)xptr;
        case 122: return (void*)(QDragLeaveEvent*)xptr;
        default: return xptr;
      }
    case 123:   //QDragMoveEvent
      switch(to) {
        case 124: return (void*)(QDropEvent*)(QDragMoveEvent*)xptr;
        case 126: return (void*)(QEvent*)(QDragMoveEvent*)xptr;
        case 123: return (void*)(QDragMoveEvent*)xptr;
        default: return xptr;
      }
    case 124:   //QDropEvent
      switch(to) {
        case 126: return (void*)(QEvent*)(QDropEvent*)xptr;
        case 124: return (void*)(QDropEvent*)xptr;
        default: return xptr;
      }
    case 125:   //QEasingCurve
      switch(to) {
        case 125: return (void*)(QEasingCurve*)xptr;
        default: return xptr;
      }
    case 126:   //QEvent
      switch(to) {
        case 126: return (void*)(QEvent*)xptr;
        default: return xptr;
      }
    case 127:   //QFocusEvent
      switch(to) {
        case 126: return (void*)(QEvent*)(QFocusEvent*)xptr;
        case 127: return (void*)(QFocusEvent*)xptr;
        default: return xptr;
      }
    case 128:   //QFont
      switch(to) {
        case 128: return (void*)(QFont*)xptr;
        default: return xptr;
      }
    case 129:   //QFontMetrics
      switch(to) {
        case 129: return (void*)(QFontMetrics*)xptr;
        default: return xptr;
      }
    case 130:   //QFrame
      switch(to) {
        case 198: return (void*)(QWidget*)(QFrame*)xptr;
        case 162: return (void*)(QObject*)(QFrame*)xptr;
        case 130: return (void*)(QFrame*)xptr;
        case 104: return (void*)(Plasma::View*)(QFrame*)xptr;
        default: return xptr;
      }
    case 132:   //QGraphicsItem
      switch(to) {
        case 132: return (void*)(QGraphicsItem*)xptr;
        case 95: return (void*)(Plasma::TabBar*)(QGraphicsItem*)xptr;
        case 67: return (void*)(Plasma::ItemBackground*)(QGraphicsItem*)xptr;
        case 36: return (void*)(Plasma::Applet*)(QGraphicsItem*)xptr;
        case 46: return (void*)(Plasma::Containment*)(QGraphicsItem*)xptr;
        case 94: return (void*)(Plasma::SvgWidget*)(QGraphicsItem*)xptr;
        case 68: return (void*)(Plasma::Label*)(QGraphicsItem*)xptr;
        case 62: return (void*)(Plasma::Frame*)(QGraphicsItem*)xptr;
        case 103: return (void*)(Plasma::VideoWidget*)(QGraphicsItem*)xptr;
        case 59: return (void*)(Plasma::ExtenderGroup*)(QGraphicsItem*)xptr;
        case 41: return (void*)(Plasma::BusyWidget*)(QGraphicsItem*)xptr;
        case 64: return (void*)(Plasma::GLApplet*)(QGraphicsItem*)xptr;
        case 42: return (void*)(Plasma::CheckBox*)(QGraphicsItem*)xptr;
        case 102: return (void*)(Plasma::TreeView*)(QGraphicsItem*)xptr;
        case 99: return (void*)(Plasma::ToolButton*)(QGraphicsItem*)xptr;
        case 65: return (void*)(Plasma::GroupBox*)(QGraphicsItem*)xptr;
        case 84: return (void*)(Plasma::ScrollBar*)(QGraphicsItem*)xptr;
        case 66: return (void*)(Plasma::IconWidget*)(QGraphicsItem*)xptr;
        case 69: return (void*)(Plasma::LineEdit*)(QGraphicsItem*)xptr;
        case 60: return (void*)(Plasma::ExtenderItem*)(QGraphicsItem*)xptr;
        case 86: return (void*)(Plasma::Separator*)(QGraphicsItem*)xptr;
        case 76: return (void*)(Plasma::PushButton*)(QGraphicsItem*)xptr;
        case 78: return (void*)(Plasma::RadioButton*)(QGraphicsItem*)xptr;
        case 96: return (void*)(Plasma::TextBrowser*)(QGraphicsItem*)xptr;
        case 75: return (void*)(Plasma::PopupApplet*)(QGraphicsItem*)xptr;
        case 58: return (void*)(Plasma::Extender*)(QGraphicsItem*)xptr;
        case 92: return (void*)(Plasma::SpinBox*)(QGraphicsItem*)xptr;
        case 90: return (void*)(Plasma::SignalPlotter*)(QGraphicsItem*)xptr;
        case 85: return (void*)(Plasma::ScrollWidget*)(QGraphicsItem*)xptr;
        case 30: return (void*)(Plasma::AbstractToolBox*)(QGraphicsItem*)xptr;
        case 70: return (void*)(Plasma::Meter*)(QGraphicsItem*)xptr;
        case 44: return (void*)(Plasma::ComboBox*)(QGraphicsItem*)xptr;
        case 91: return (void*)(Plasma::Slider*)(QGraphicsItem*)xptr;
        case 107: return (void*)(Plasma::WebView*)(QGraphicsItem*)xptr;
        case 61: return (void*)(Plasma::FlashingLabel*)(QGraphicsItem*)xptr;
        case 97: return (void*)(Plasma::TextEdit*)(QGraphicsItem*)xptr;
        default: return xptr;
      }
    case 133:   //QGraphicsLayoutItem
      switch(to) {
        case 133: return (void*)(QGraphicsLayoutItem*)xptr;
        case 95: return (void*)(Plasma::TabBar*)(QGraphicsLayoutItem*)xptr;
        case 67: return (void*)(Plasma::ItemBackground*)(QGraphicsLayoutItem*)xptr;
        case 36: return (void*)(Plasma::Applet*)(QGraphicsLayoutItem*)xptr;
        case 46: return (void*)(Plasma::Containment*)(QGraphicsLayoutItem*)xptr;
        case 94: return (void*)(Plasma::SvgWidget*)(QGraphicsLayoutItem*)xptr;
        case 68: return (void*)(Plasma::Label*)(QGraphicsLayoutItem*)xptr;
        case 62: return (void*)(Plasma::Frame*)(QGraphicsLayoutItem*)xptr;
        case 103: return (void*)(Plasma::VideoWidget*)(QGraphicsLayoutItem*)xptr;
        case 59: return (void*)(Plasma::ExtenderGroup*)(QGraphicsLayoutItem*)xptr;
        case 41: return (void*)(Plasma::BusyWidget*)(QGraphicsLayoutItem*)xptr;
        case 64: return (void*)(Plasma::GLApplet*)(QGraphicsLayoutItem*)xptr;
        case 42: return (void*)(Plasma::CheckBox*)(QGraphicsLayoutItem*)xptr;
        case 102: return (void*)(Plasma::TreeView*)(QGraphicsLayoutItem*)xptr;
        case 99: return (void*)(Plasma::ToolButton*)(QGraphicsLayoutItem*)xptr;
        case 65: return (void*)(Plasma::GroupBox*)(QGraphicsLayoutItem*)xptr;
        case 84: return (void*)(Plasma::ScrollBar*)(QGraphicsLayoutItem*)xptr;
        case 66: return (void*)(Plasma::IconWidget*)(QGraphicsLayoutItem*)xptr;
        case 69: return (void*)(Plasma::LineEdit*)(QGraphicsLayoutItem*)xptr;
        case 60: return (void*)(Plasma::ExtenderItem*)(QGraphicsLayoutItem*)xptr;
        case 86: return (void*)(Plasma::Separator*)(QGraphicsLayoutItem*)xptr;
        case 76: return (void*)(Plasma::PushButton*)(QGraphicsLayoutItem*)xptr;
        case 78: return (void*)(Plasma::RadioButton*)(QGraphicsLayoutItem*)xptr;
        case 96: return (void*)(Plasma::TextBrowser*)(QGraphicsLayoutItem*)xptr;
        case 75: return (void*)(Plasma::PopupApplet*)(QGraphicsLayoutItem*)xptr;
        case 58: return (void*)(Plasma::Extender*)(QGraphicsLayoutItem*)xptr;
        case 92: return (void*)(Plasma::SpinBox*)(QGraphicsLayoutItem*)xptr;
        case 90: return (void*)(Plasma::SignalPlotter*)(QGraphicsLayoutItem*)xptr;
        case 85: return (void*)(Plasma::ScrollWidget*)(QGraphicsLayoutItem*)xptr;
        case 30: return (void*)(Plasma::AbstractToolBox*)(QGraphicsLayoutItem*)xptr;
        case 70: return (void*)(Plasma::Meter*)(QGraphicsLayoutItem*)xptr;
        case 44: return (void*)(Plasma::ComboBox*)(QGraphicsLayoutItem*)xptr;
        case 91: return (void*)(Plasma::Slider*)(QGraphicsLayoutItem*)xptr;
        case 107: return (void*)(Plasma::WebView*)(QGraphicsLayoutItem*)xptr;
        case 61: return (void*)(Plasma::FlashingLabel*)(QGraphicsLayoutItem*)xptr;
        case 97: return (void*)(Plasma::TextEdit*)(QGraphicsLayoutItem*)xptr;
        default: return xptr;
      }
    case 134:   //QGraphicsObject
      switch(to) {
        case 162: return (void*)(QObject*)(QGraphicsObject*)xptr;
        case 132: return (void*)(QGraphicsItem*)(QGraphicsObject*)xptr;
        case 134: return (void*)(QGraphicsObject*)xptr;
        case 95: return (void*)(Plasma::TabBar*)(QGraphicsObject*)xptr;
        case 67: return (void*)(Plasma::ItemBackground*)(QGraphicsObject*)xptr;
        case 36: return (void*)(Plasma::Applet*)(QGraphicsObject*)xptr;
        case 46: return (void*)(Plasma::Containment*)(QGraphicsObject*)xptr;
        case 94: return (void*)(Plasma::SvgWidget*)(QGraphicsObject*)xptr;
        case 68: return (void*)(Plasma::Label*)(QGraphicsObject*)xptr;
        case 62: return (void*)(Plasma::Frame*)(QGraphicsObject*)xptr;
        case 103: return (void*)(Plasma::VideoWidget*)(QGraphicsObject*)xptr;
        case 59: return (void*)(Plasma::ExtenderGroup*)(QGraphicsObject*)xptr;
        case 41: return (void*)(Plasma::BusyWidget*)(QGraphicsObject*)xptr;
        case 64: return (void*)(Plasma::GLApplet*)(QGraphicsObject*)xptr;
        case 42: return (void*)(Plasma::CheckBox*)(QGraphicsObject*)xptr;
        case 102: return (void*)(Plasma::TreeView*)(QGraphicsObject*)xptr;
        case 99: return (void*)(Plasma::ToolButton*)(QGraphicsObject*)xptr;
        case 65: return (void*)(Plasma::GroupBox*)(QGraphicsObject*)xptr;
        case 84: return (void*)(Plasma::ScrollBar*)(QGraphicsObject*)xptr;
        case 66: return (void*)(Plasma::IconWidget*)(QGraphicsObject*)xptr;
        case 69: return (void*)(Plasma::LineEdit*)(QGraphicsObject*)xptr;
        case 60: return (void*)(Plasma::ExtenderItem*)(QGraphicsObject*)xptr;
        case 86: return (void*)(Plasma::Separator*)(QGraphicsObject*)xptr;
        case 76: return (void*)(Plasma::PushButton*)(QGraphicsObject*)xptr;
        case 78: return (void*)(Plasma::RadioButton*)(QGraphicsObject*)xptr;
        case 96: return (void*)(Plasma::TextBrowser*)(QGraphicsObject*)xptr;
        case 75: return (void*)(Plasma::PopupApplet*)(QGraphicsObject*)xptr;
        case 58: return (void*)(Plasma::Extender*)(QGraphicsObject*)xptr;
        case 92: return (void*)(Plasma::SpinBox*)(QGraphicsObject*)xptr;
        case 90: return (void*)(Plasma::SignalPlotter*)(QGraphicsObject*)xptr;
        case 85: return (void*)(Plasma::ScrollWidget*)(QGraphicsObject*)xptr;
        case 30: return (void*)(Plasma::AbstractToolBox*)(QGraphicsObject*)xptr;
        case 70: return (void*)(Plasma::Meter*)(QGraphicsObject*)xptr;
        case 44: return (void*)(Plasma::ComboBox*)(QGraphicsObject*)xptr;
        case 91: return (void*)(Plasma::Slider*)(QGraphicsObject*)xptr;
        case 107: return (void*)(Plasma::WebView*)(QGraphicsObject*)xptr;
        case 61: return (void*)(Plasma::FlashingLabel*)(QGraphicsObject*)xptr;
        case 97: return (void*)(Plasma::TextEdit*)(QGraphicsObject*)xptr;
        default: return xptr;
      }
    case 135:   //QGraphicsProxyWidget
      switch(to) {
        case 146: return (void*)(QGraphicsWidget*)(QGraphicsProxyWidget*)xptr;
        case 134: return (void*)(QGraphicsObject*)(QGraphicsProxyWidget*)xptr;
        case 162: return (void*)(QObject*)(QGraphicsProxyWidget*)xptr;
        case 132: return (void*)(QGraphicsItem*)(QGraphicsProxyWidget*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(QGraphicsProxyWidget*)xptr;
        case 135: return (void*)(QGraphicsProxyWidget*)xptr;
        case 68: return (void*)(Plasma::Label*)(QGraphicsProxyWidget*)xptr;
        case 103: return (void*)(Plasma::VideoWidget*)(QGraphicsProxyWidget*)xptr;
        case 42: return (void*)(Plasma::CheckBox*)(QGraphicsProxyWidget*)xptr;
        case 102: return (void*)(Plasma::TreeView*)(QGraphicsProxyWidget*)xptr;
        case 99: return (void*)(Plasma::ToolButton*)(QGraphicsProxyWidget*)xptr;
        case 65: return (void*)(Plasma::GroupBox*)(QGraphicsProxyWidget*)xptr;
        case 84: return (void*)(Plasma::ScrollBar*)(QGraphicsProxyWidget*)xptr;
        case 69: return (void*)(Plasma::LineEdit*)(QGraphicsProxyWidget*)xptr;
        case 76: return (void*)(Plasma::PushButton*)(QGraphicsProxyWidget*)xptr;
        case 78: return (void*)(Plasma::RadioButton*)(QGraphicsProxyWidget*)xptr;
        case 96: return (void*)(Plasma::TextBrowser*)(QGraphicsProxyWidget*)xptr;
        case 92: return (void*)(Plasma::SpinBox*)(QGraphicsProxyWidget*)xptr;
        case 44: return (void*)(Plasma::ComboBox*)(QGraphicsProxyWidget*)xptr;
        case 91: return (void*)(Plasma::Slider*)(QGraphicsProxyWidget*)xptr;
        case 97: return (void*)(Plasma::TextEdit*)(QGraphicsProxyWidget*)xptr;
        default: return xptr;
      }
    case 136:   //QGraphicsScene
      switch(to) {
        case 162: return (void*)(QObject*)(QGraphicsScene*)xptr;
        case 136: return (void*)(QGraphicsScene*)xptr;
        case 51: return (void*)(Plasma::Corona*)(QGraphicsScene*)xptr;
        default: return xptr;
      }
    case 137:   //QGraphicsSceneContextMenuEvent
      switch(to) {
        case 126: return (void*)(QEvent*)(QGraphicsSceneContextMenuEvent*)xptr;
        case 137: return (void*)(QGraphicsSceneContextMenuEvent*)xptr;
        default: return xptr;
      }
    case 138:   //QGraphicsSceneDragDropEvent
      switch(to) {
        case 126: return (void*)(QEvent*)(QGraphicsSceneDragDropEvent*)xptr;
        case 138: return (void*)(QGraphicsSceneDragDropEvent*)xptr;
        default: return xptr;
      }
    case 139:   //QGraphicsSceneHelpEvent
      switch(to) {
        case 126: return (void*)(QEvent*)(QGraphicsSceneHelpEvent*)xptr;
        case 139: return (void*)(QGraphicsSceneHelpEvent*)xptr;
        default: return xptr;
      }
    case 140:   //QGraphicsSceneHoverEvent
      switch(to) {
        case 126: return (void*)(QEvent*)(QGraphicsSceneHoverEvent*)xptr;
        case 140: return (void*)(QGraphicsSceneHoverEvent*)xptr;
        default: return xptr;
      }
    case 141:   //QGraphicsSceneMouseEvent
      switch(to) {
        case 126: return (void*)(QEvent*)(QGraphicsSceneMouseEvent*)xptr;
        case 141: return (void*)(QGraphicsSceneMouseEvent*)xptr;
        default: return xptr;
      }
    case 142:   //QGraphicsSceneMoveEvent
      switch(to) {
        case 126: return (void*)(QEvent*)(QGraphicsSceneMoveEvent*)xptr;
        case 142: return (void*)(QGraphicsSceneMoveEvent*)xptr;
        default: return xptr;
      }
    case 143:   //QGraphicsSceneResizeEvent
      switch(to) {
        case 126: return (void*)(QEvent*)(QGraphicsSceneResizeEvent*)xptr;
        case 143: return (void*)(QGraphicsSceneResizeEvent*)xptr;
        default: return xptr;
      }
    case 144:   //QGraphicsSceneWheelEvent
      switch(to) {
        case 126: return (void*)(QEvent*)(QGraphicsSceneWheelEvent*)xptr;
        case 144: return (void*)(QGraphicsSceneWheelEvent*)xptr;
        default: return xptr;
      }
    case 145:   //QGraphicsView
      switch(to) {
        case 111: return (void*)(QAbstractScrollArea*)(QGraphicsView*)xptr;
        case 130: return (void*)(QFrame*)(QGraphicsView*)xptr;
        case 198: return (void*)(QWidget*)(QGraphicsView*)xptr;
        case 162: return (void*)(QObject*)(QGraphicsView*)xptr;
        case 145: return (void*)(QGraphicsView*)xptr;
        case 104: return (void*)(Plasma::View*)(QGraphicsView*)xptr;
        default: return xptr;
      }
    case 146:   //QGraphicsWidget
      switch(to) {
        case 134: return (void*)(QGraphicsObject*)(QGraphicsWidget*)xptr;
        case 162: return (void*)(QObject*)(QGraphicsWidget*)xptr;
        case 132: return (void*)(QGraphicsItem*)(QGraphicsWidget*)xptr;
        case 133: return (void*)(QGraphicsLayoutItem*)(QGraphicsWidget*)xptr;
        case 146: return (void*)(QGraphicsWidget*)xptr;
        case 95: return (void*)(Plasma::TabBar*)(QGraphicsWidget*)xptr;
        case 67: return (void*)(Plasma::ItemBackground*)(QGraphicsWidget*)xptr;
        case 36: return (void*)(Plasma::Applet*)(QGraphicsWidget*)xptr;
        case 46: return (void*)(Plasma::Containment*)(QGraphicsWidget*)xptr;
        case 94: return (void*)(Plasma::SvgWidget*)(QGraphicsWidget*)xptr;
        case 68: return (void*)(Plasma::Label*)(QGraphicsWidget*)xptr;
        case 62: return (void*)(Plasma::Frame*)(QGraphicsWidget*)xptr;
        case 103: return (void*)(Plasma::VideoWidget*)(QGraphicsWidget*)xptr;
        case 59: return (void*)(Plasma::ExtenderGroup*)(QGraphicsWidget*)xptr;
        case 41: return (void*)(Plasma::BusyWidget*)(QGraphicsWidget*)xptr;
        case 64: return (void*)(Plasma::GLApplet*)(QGraphicsWidget*)xptr;
        case 42: return (void*)(Plasma::CheckBox*)(QGraphicsWidget*)xptr;
        case 102: return (void*)(Plasma::TreeView*)(QGraphicsWidget*)xptr;
        case 99: return (void*)(Plasma::ToolButton*)(QGraphicsWidget*)xptr;
        case 65: return (void*)(Plasma::GroupBox*)(QGraphicsWidget*)xptr;
        case 84: return (void*)(Plasma::ScrollBar*)(QGraphicsWidget*)xptr;
        case 66: return (void*)(Plasma::IconWidget*)(QGraphicsWidget*)xptr;
        case 69: return (void*)(Plasma::LineEdit*)(QGraphicsWidget*)xptr;
        case 60: return (void*)(Plasma::ExtenderItem*)(QGraphicsWidget*)xptr;
        case 86: return (void*)(Plasma::Separator*)(QGraphicsWidget*)xptr;
        case 76: return (void*)(Plasma::PushButton*)(QGraphicsWidget*)xptr;
        case 78: return (void*)(Plasma::RadioButton*)(QGraphicsWidget*)xptr;
        case 96: return (void*)(Plasma::TextBrowser*)(QGraphicsWidget*)xptr;
        case 75: return (void*)(Plasma::PopupApplet*)(QGraphicsWidget*)xptr;
        case 58: return (void*)(Plasma::Extender*)(QGraphicsWidget*)xptr;
        case 92: return (void*)(Plasma::SpinBox*)(QGraphicsWidget*)xptr;
        case 90: return (void*)(Plasma::SignalPlotter*)(QGraphicsWidget*)xptr;
        case 85: return (void*)(Plasma::ScrollWidget*)(QGraphicsWidget*)xptr;
        case 30: return (void*)(Plasma::AbstractToolBox*)(QGraphicsWidget*)xptr;
        case 70: return (void*)(Plasma::Meter*)(QGraphicsWidget*)xptr;
        case 44: return (void*)(Plasma::ComboBox*)(QGraphicsWidget*)xptr;
        case 91: return (void*)(Plasma::Slider*)(QGraphicsWidget*)xptr;
        case 107: return (void*)(Plasma::WebView*)(QGraphicsWidget*)xptr;
        case 61: return (void*)(Plasma::FlashingLabel*)(QGraphicsWidget*)xptr;
        case 97: return (void*)(Plasma::TextEdit*)(QGraphicsWidget*)xptr;
        default: return xptr;
      }
    case 147:   //QGroupBox
      switch(to) {
        case 147: return (void*)(QGroupBox*)xptr;
        default: return xptr;
      }
    case 148:   //QHideEvent
      switch(to) {
        case 126: return (void*)(QEvent*)(QHideEvent*)xptr;
        case 148: return (void*)(QHideEvent*)xptr;
        default: return xptr;
      }
    case 149:   //QIODevice
      switch(to) {
        case 162: return (void*)(QObject*)(QIODevice*)xptr;
        case 149: return (void*)(QIODevice*)xptr;
        default: return xptr;
      }
    case 150:   //QIcon
      switch(to) {
        case 150: return (void*)(QIcon*)xptr;
        default: return xptr;
      }
    case 151:   //QImage
      switch(to) {
        case 151: return (void*)(QImage*)xptr;
        default: return xptr;
      }
    case 152:   //QInputMethodEvent
      switch(to) {
        case 126: return (void*)(QEvent*)(QInputMethodEvent*)xptr;
        case 152: return (void*)(QInputMethodEvent*)xptr;
        default: return xptr;
      }
    case 153:   //QKeyEvent
      switch(to) {
        case 126: return (void*)(QEvent*)(QKeyEvent*)xptr;
        case 153: return (void*)(QKeyEvent*)xptr;
        default: return xptr;
      }
    case 154:   //QLabel
      switch(to) {
        case 154: return (void*)(QLabel*)xptr;
        default: return xptr;
      }
    case 155:   //QMenu
      switch(to) {
        case 155: return (void*)(QMenu*)xptr;
        default: return xptr;
      }
    case 156:   //QMetaObject
      switch(to) {
        case 156: return (void*)(QMetaObject*)xptr;
        default: return xptr;
      }
    case 157:   //QMimeData
      switch(to) {
        case 162: return (void*)(QObject*)(QMimeData*)xptr;
        case 157: return (void*)(QMimeData*)xptr;
        default: return xptr;
      }
    case 158:   //QModelIndex
      switch(to) {
        case 158: return (void*)(QModelIndex*)xptr;
        default: return xptr;
      }
    case 159:   //QMouseEvent
      switch(to) {
        case 126: return (void*)(QEvent*)(QMouseEvent*)xptr;
        case 159: return (void*)(QMouseEvent*)xptr;
        default: return xptr;
      }
    case 160:   //QMoveEvent
      switch(to) {
        case 126: return (void*)(QEvent*)(QMoveEvent*)xptr;
        case 160: return (void*)(QMoveEvent*)xptr;
        default: return xptr;
      }
    case 161:   //QMutex
      switch(to) {
        case 161: return (void*)(QMutex*)xptr;
        default: return xptr;
      }
    case 162:   //QObject
      switch(to) {
        case 162: return (void*)(QObject*)xptr;
        case 95: return (void*)(Plasma::TabBar*)(QObject*)xptr;
        case 67: return (void*)(Plasma::ItemBackground*)(QObject*)xptr;
        case 101: return (void*)(Plasma::ToolTipManager*)(QObject*)xptr;
        case 54: return (void*)(Plasma::DataEngineManager*)(QObject*)xptr;
        case 28: return (void*)(Plasma::AbstractDialogManager*)(QObject*)xptr;
        case 55: return (void*)(Plasma::DataEngineScript*)(QObject*)xptr;
        case 45: return (void*)(Plasma::ConfigLoader*)(QObject*)xptr;
        case 34: return (void*)(Plasma::AnimationDriver*)(QObject*)xptr;
        case 36: return (void*)(Plasma::Applet*)(QObject*)xptr;
        case 46: return (void*)(Plasma::Containment*)(QObject*)xptr;
        case 51: return (void*)(Plasma::Corona*)(QObject*)xptr;
        case 43: return (void*)(Plasma::ClientPinRequest*)(QObject*)xptr;
        case 94: return (void*)(Plasma::SvgWidget*)(QObject*)xptr;
        case 68: return (void*)(Plasma::Label*)(QObject*)xptr;
        case 106: return (void*)(Plasma::WallpaperScript*)(QObject*)xptr;
        case 93: return (void*)(Plasma::Svg*)(QObject*)xptr;
        case 62: return (void*)(Plasma::Frame*)(QObject*)xptr;
        case 103: return (void*)(Plasma::VideoWidget*)(QObject*)xptr;
        case 31: return (void*)(Plasma::AccessAppletJob*)(QObject*)xptr;
        case 59: return (void*)(Plasma::ExtenderGroup*)(QObject*)xptr;
        case 41: return (void*)(Plasma::BusyWidget*)(QObject*)xptr;
        case 50: return (void*)(Plasma::Context*)(QObject*)xptr;
        case 64: return (void*)(Plasma::GLApplet*)(QObject*)xptr;
        case 42: return (void*)(Plasma::CheckBox*)(QObject*)xptr;
        case 39: return (void*)(Plasma::AuthorizationManager*)(QObject*)xptr;
        case 80: return (void*)(Plasma::RunnerManager*)(QObject*)xptr;
        case 102: return (void*)(Plasma::TreeView*)(QObject*)xptr;
        case 53: return (void*)(Plasma::DataEngine*)(QObject*)xptr;
        case 99: return (void*)(Plasma::ToolButton*)(QObject*)xptr;
        case 65: return (void*)(Plasma::GroupBox*)(QObject*)xptr;
        case 105: return (void*)(Plasma::Wallpaper*)(QObject*)xptr;
        case 84: return (void*)(Plasma::ScrollBar*)(QObject*)xptr;
        case 66: return (void*)(Plasma::IconWidget*)(QObject*)xptr;
        case 73: return (void*)(Plasma::PackageStructure*)(QObject*)xptr;
        case 87: return (void*)(Plasma::Service*)(QObject*)xptr;
        case 32: return (void*)(Plasma::AccessManager*)(QObject*)xptr;
        case 69: return (void*)(Plasma::LineEdit*)(QObject*)xptr;
        case 60: return (void*)(Plasma::ExtenderItem*)(QObject*)xptr;
        case 81: return (void*)(Plasma::RunnerScript*)(QObject*)xptr;
        case 35: return (void*)(Plasma::Animator*)(QObject*)xptr;
        case 88: return (void*)(Plasma::ServiceAccessJob*)(QObject*)xptr;
        case 83: return (void*)(Plasma::ScriptEngine*)(QObject*)xptr;
        case 86: return (void*)(Plasma::Separator*)(QObject*)xptr;
        case 76: return (void*)(Plasma::PushButton*)(QObject*)xptr;
        case 78: return (void*)(Plasma::RadioButton*)(QObject*)xptr;
        case 98: return (void*)(Plasma::Theme*)(QObject*)xptr;
        case 96: return (void*)(Plasma::TextBrowser*)(QObject*)xptr;
        case 75: return (void*)(Plasma::PopupApplet*)(QObject*)xptr;
        case 56: return (void*)(Plasma::Delegate*)(QObject*)xptr;
        case 63: return (void*)(Plasma::FrameSvg*)(QObject*)xptr;
        case 52: return (void*)(Plasma::DataContainer*)(QObject*)xptr;
        case 79: return (void*)(Plasma::RunnerContext*)(QObject*)xptr;
        case 58: return (void*)(Plasma::Extender*)(QObject*)xptr;
        case 33: return (void*)(Plasma::Animation*)(QObject*)xptr;
        case 57: return (void*)(Plasma::Dialog*)(QObject*)xptr;
        case 92: return (void*)(Plasma::SpinBox*)(QObject*)xptr;
        case 29: return (void*)(Plasma::AbstractRunner*)(QObject*)xptr;
        case 90: return (void*)(Plasma::SignalPlotter*)(QObject*)xptr;
        case 85: return (void*)(Plasma::ScrollWidget*)(QObject*)xptr;
        case 30: return (void*)(Plasma::AbstractToolBox*)(QObject*)xptr;
        case 70: return (void*)(Plasma::Meter*)(QObject*)xptr;
        case 44: return (void*)(Plasma::ComboBox*)(QObject*)xptr;
        case 48: return (void*)(Plasma::ContainmentActions*)(QObject*)xptr;
        case 40: return (void*)(Plasma::AuthorizationRule*)(QObject*)xptr;
        case 91: return (void*)(Plasma::Slider*)(QObject*)xptr;
        case 107: return (void*)(Plasma::WebView*)(QObject*)xptr;
        case 61: return (void*)(Plasma::FlashingLabel*)(QObject*)xptr;
        case 97: return (void*)(Plasma::TextEdit*)(QObject*)xptr;
        case 104: return (void*)(Plasma::View*)(QObject*)xptr;
        case 37: return (void*)(Plasma::AppletScript*)(QObject*)xptr;
        default: return xptr;
      }
    case 163:   //QPaintEngine
      switch(to) {
        case 163: return (void*)(QPaintEngine*)xptr;
        default: return xptr;
      }
    case 164:   //QPaintEvent
      switch(to) {
        case 126: return (void*)(QEvent*)(QPaintEvent*)xptr;
        case 164: return (void*)(QPaintEvent*)xptr;
        default: return xptr;
      }
    case 165:   //QPainter
      switch(to) {
        case 165: return (void*)(QPainter*)xptr;
        default: return xptr;
      }
    case 166:   //QPainterPath
      switch(to) {
        case 166: return (void*)(QPainterPath*)xptr;
        default: return xptr;
      }
    case 167:   //QPalette
      switch(to) {
        case 167: return (void*)(QPalette*)xptr;
        default: return xptr;
      }
    case 168:   //QPixmap
      switch(to) {
        case 168: return (void*)(QPixmap*)xptr;
        default: return xptr;
      }
    case 169:   //QPoint
      switch(to) {
        case 169: return (void*)(QPoint*)xptr;
        default: return xptr;
      }
    case 170:   //QPointF
      switch(to) {
        case 170: return (void*)(QPointF*)xptr;
        default: return xptr;
      }
    case 171:   //QRadioButton
      switch(to) {
        case 171: return (void*)(QRadioButton*)xptr;
        default: return xptr;
      }
    case 172:   //QRect
      switch(to) {
        case 172: return (void*)(QRect*)xptr;
        default: return xptr;
      }
    case 173:   //QRectF
      switch(to) {
        case 173: return (void*)(QRectF*)xptr;
        default: return xptr;
      }
    case 174:   //QRegExp
      switch(to) {
        case 174: return (void*)(QRegExp*)xptr;
        default: return xptr;
      }
    case 175:   //QRegion
      switch(to) {
        case 175: return (void*)(QRegion*)xptr;
        default: return xptr;
      }
    case 176:   //QResizeEvent
      switch(to) {
        case 126: return (void*)(QEvent*)(QResizeEvent*)xptr;
        case 176: return (void*)(QResizeEvent*)xptr;
        default: return xptr;
      }
    case 177:   //QScrollBar
      switch(to) {
        case 198: return (void*)(QWidget*)(QScrollBar*)xptr;
        case 162: return (void*)(QObject*)(QScrollBar*)xptr;
        case 177: return (void*)(QScrollBar*)xptr;
        default: return xptr;
      }
    case 178:   //QSharedData
      switch(to) {
        case 178: return (void*)(QSharedData*)xptr;
        case 73: return (void*)(Plasma::PackageStructure*)(QSharedData*)xptr;
        default: return xptr;
      }
    case 179:   //QShowEvent
      switch(to) {
        case 126: return (void*)(QEvent*)(QShowEvent*)xptr;
        case 179: return (void*)(QShowEvent*)xptr;
        default: return xptr;
      }
    case 180:   //QSize
      switch(to) {
        case 180: return (void*)(QSize*)xptr;
        default: return xptr;
      }
    case 181:   //QSizeF
      switch(to) {
        case 181: return (void*)(QSizeF*)xptr;
        default: return xptr;
      }
    case 182:   //QSlider
      switch(to) {
        case 198: return (void*)(QWidget*)(QSlider*)xptr;
        case 162: return (void*)(QObject*)(QSlider*)xptr;
        case 182: return (void*)(QSlider*)xptr;
        default: return xptr;
      }
    case 183:   //QStyle
      switch(to) {
        case 162: return (void*)(QObject*)(QStyle*)xptr;
        case 183: return (void*)(QStyle*)xptr;
        default: return xptr;
      }
    case 184:   //QStyleOption
      switch(to) {
        case 184: return (void*)(QStyleOption*)xptr;
        case 47: return (void*)(Plasma::Containment::StyleOption*)(QStyleOption*)xptr;
        default: return xptr;
      }
    case 185:   //QStyleOptionGraphicsItem
      switch(to) {
        case 184: return (void*)(QStyleOption*)(QStyleOptionGraphicsItem*)xptr;
        case 185: return (void*)(QStyleOptionGraphicsItem*)xptr;
        case 47: return (void*)(Plasma::Containment::StyleOption*)(QStyleOptionGraphicsItem*)xptr;
        default: return xptr;
      }
    case 186:   //QStyleOptionViewItem
      switch(to) {
        case 184: return (void*)(QStyleOption*)(QStyleOptionViewItem*)xptr;
        case 186: return (void*)(QStyleOptionViewItem*)xptr;
        default: return xptr;
      }
    case 187:   //QTabletEvent
      switch(to) {
        case 126: return (void*)(QEvent*)(QTabletEvent*)xptr;
        case 187: return (void*)(QTabletEvent*)xptr;
        default: return xptr;
      }
    case 188:   //QTextDocument
      switch(to) {
        case 188: return (void*)(QTextDocument*)xptr;
        default: return xptr;
      }
    case 189:   //QTextOption
      switch(to) {
        case 189: return (void*)(QTextOption*)xptr;
        default: return xptr;
      }
    case 190:   //QTimerEvent
      switch(to) {
        case 126: return (void*)(QEvent*)(QTimerEvent*)xptr;
        case 190: return (void*)(QTimerEvent*)xptr;
        default: return xptr;
      }
    case 191:   //QToolButton
      switch(to) {
        case 191: return (void*)(QToolButton*)xptr;
        default: return xptr;
      }
    case 192:   //QTreeView
      switch(to) {
        case 192: return (void*)(QTreeView*)xptr;
        default: return xptr;
      }
    case 193:   //QUrl
      switch(to) {
        case 193: return (void*)(QUrl*)xptr;
        default: return xptr;
      }
    case 194:   //QVariant
      switch(to) {
        case 194: return (void*)(QVariant*)xptr;
        default: return xptr;
      }
    case 195:   //QWebFrame
      switch(to) {
        case 195: return (void*)(QWebFrame*)xptr;
        default: return xptr;
      }
    case 196:   //QWebPage
      switch(to) {
        case 196: return (void*)(QWebPage*)xptr;
        default: return xptr;
      }
    case 197:   //QWheelEvent
      switch(to) {
        case 126: return (void*)(QEvent*)(QWheelEvent*)xptr;
        case 197: return (void*)(QWheelEvent*)xptr;
        default: return xptr;
      }
    case 198:   //QWidget
      switch(to) {
        case 162: return (void*)(QObject*)(QWidget*)xptr;
        case 198: return (void*)(QWidget*)xptr;
        case 57: return (void*)(Plasma::Dialog*)(QWidget*)xptr;
        case 104: return (void*)(Plasma::View*)(QWidget*)xptr;
        default: return xptr;
      }
    default: return xptr;
  }
}

// Group of Indexes (0 separated) used as super class lists.
// Classes with super classes have an index into this array.
static Smoke::Index inheritanceList[] = {
    0,	// 0: (no super class)
    162, 0,	// 1: QObject
    146, 0,	// 3: QGraphicsWidget
    12, 0,	// 5: KJob
    108, 0,	// 7: QAbstractAnimation
    83, 0,	// 9: Plasma::ScriptEngine
    135, 0,	// 11: QGraphicsProxyWidget
    7, 0,	// 13: KConfigSkeleton
    36, 0,	// 15: Plasma::Applet
    185, 0,	// 17: QStyleOptionGraphicsItem
    136, 0,	// 19: QGraphicsScene
    109, 0,	// 21: QAbstractItemDelegate
    198, 0,	// 23: QWidget
    60, 0,	// 25: Plasma::ExtenderItem
    93, 0,	// 27: Plasma::Svg
    162, 178, 0,	// 29: QObject, QSharedData
    145, 0,	// 32: QGraphicsView
};

// These are the xenum functions for manipulating enum pointers
void xenum_Plasma__Animation(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Plasma__AuthorizationRule(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Plasma(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Plasma__Containment__StyleOption(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Plasma__AbstractRunner(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Plasma__Dialog(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Plasma__ToolTipManager(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Plasma__ToolTipContent(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Plasma__Meter(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Plasma__Delegate(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Plasma__VideoWidget(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Plasma__Frame(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Plasma__AuthorizationManager(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Plasma__Wallpaper(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Plasma__Extender(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Plasma__RunnerContext(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Plasma__Animator(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Plasma__AbstractToolBox(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Plasma__Applet(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Plasma__QueryMatch(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Plasma__Theme(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Plasma__Containment(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Plasma__FrameSvg(Smoke::EnumOperation, Smoke::Index, void*&, long&);

// Those are the xcall functions defined in each x_*.cpp file, for dispatching method calls
void xcall_Plasma(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__AbstractDialogManager(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__AbstractRunner(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__AbstractToolBox(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__AccessAppletJob(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__AccessManager(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__Animation(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__AnimationDriver(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__Animator(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__Applet(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__AppletScript(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__AuthorizationInterface(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__AuthorizationManager(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__AuthorizationRule(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__BusyWidget(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__CheckBox(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__ClientPinRequest(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__ComboBox(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__ConfigLoader(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__Containment(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__Containment__StyleOption(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__ContainmentActions(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__ContainmentActionsPluginsConfig(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__Context(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__Corona(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__DataContainer(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__DataEngine(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__DataEngineManager(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__DataEngineScript(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__Delegate(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__Dialog(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__Extender(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__ExtenderGroup(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__ExtenderItem(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__FlashingLabel(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__Frame(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__FrameSvg(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__GLApplet(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__GroupBox(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__IconWidget(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__ItemBackground(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__Label(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__LineEdit(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__Meter(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__Package(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__PackageMetadata(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__PackageStructure(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__PlotColor(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__PopupApplet(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__PushButton(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__QueryMatch(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__RadioButton(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__RunnerContext(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__RunnerManager(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__RunnerScript(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__RunnerSyntax(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__ScriptEngine(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__ScrollBar(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__ScrollWidget(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__Separator(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__Service(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__ServiceAccessJob(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__SignalPlotter(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__Slider(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__SpinBox(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__Svg(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__SvgWidget(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__TabBar(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__TextBrowser(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__TextEdit(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__Theme(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__ToolButton(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__ToolTipContent(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__ToolTipManager(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__TreeView(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__VideoWidget(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__View(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__Wallpaper(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__WallpaperScript(Smoke::Index, void*, Smoke::Stack);
void xcall_Plasma__WebView(Smoke::Index, void*, Smoke::Stack);
void xcall_QGlobalSpace(Smoke::Index, void*, Smoke::Stack);

// List of all classes
// Name, external, index into inheritanceList, method dispatcher, enum dispatcher, class flags, size
static Smoke::Class classes[] = {
    { 0L, false, 0, 0, 0, 0, 0 },	// 0 (no class)
    { "KAction", true, 0, 0, 0, 0, 0 },	//1
    { "KActionCollection", true, 0, 0, 0, 0, 0 },	//2
    { "KComboBox", true, 0, 0, 0, 0, 0 },	//3
    { "KConfigBase", true, 0, 0, 0, 0, 0 },	//4
    { "KConfigDialog", true, 0, 0, 0, 0, 0 },	//5
    { "KConfigGroup", true, 0, 0, 0, 0, 0 },	//6
    { "KConfigSkeleton", true, 0, 0, 0, 0, 0 },	//7
    { "KConfigSkeletonItem", true, 0, 0, 0, 0, 0 },	//8
    { "KCoreConfigSkeleton", true, 0, 0, 0, 0, 0 },	//9
    { "KIcon", true, 0, 0, 0, 0, 0 },	//10
    { "KIntSpinBox", true, 0, 0, 0, 0, 0 },	//11
    { "KJob", true, 0, 0, 0, 0, 0 },	//12
    { "KLineEdit", true, 0, 0, 0, 0, 0 },	//13
    { "KPluginInfo", true, 0, 0, 0, 0, 0 },	//14
    { "KPushButton", true, 0, 0, 0, 0, 0 },	//15
    { "KService", true, 0, 0, 0, 0, 0 },	//16
    { "KServiceAction", true, 0, 0, 0, 0, 0 },	//17
    { "KSharedConfig", true, 0, 0, 0, 0, 0 },	//18
    { "KShortcut", true, 0, 0, 0, 0, 0 },	//19
    { "KTabBar", true, 0, 0, 0, 0, 0 },	//20
    { "KTextBrowser", true, 0, 0, 0, 0, 0 },	//21
    { "KTextEdit", true, 0, 0, 0, 0, 0 },	//22
    { "KUrl", true, 0, 0, 0, 0, 0 },	//23
    { "Phonon::AudioOutput", true, 0, 0, 0, 0, 0 },	//24
    { "Phonon::MediaObject", true, 0, 0, 0, 0, 0 },	//25
    { "Phonon::VideoWidget", true, 0, 0, 0, 0, 0 },	//26
    { "Plasma", false, 0, xcall_Plasma, xenum_Plasma, Smoke::cf_namespace, 0 },	//27
    { "Plasma::AbstractDialogManager", false, 1, xcall_Plasma__AbstractDialogManager, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::AbstractDialogManager) },	//28
    { "Plasma::AbstractRunner", false, 1, xcall_Plasma__AbstractRunner, xenum_Plasma__AbstractRunner, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::AbstractRunner) },	//29
    { "Plasma::AbstractToolBox", false, 3, xcall_Plasma__AbstractToolBox, xenum_Plasma__AbstractToolBox, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::AbstractToolBox) },	//30
    { "Plasma::AccessAppletJob", false, 5, xcall_Plasma__AccessAppletJob, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::AccessAppletJob) },	//31
    { "Plasma::AccessManager", false, 1, xcall_Plasma__AccessManager, 0, Smoke::cf_virtual, sizeof(Plasma::AccessManager) },	//32
    { "Plasma::Animation", false, 7, xcall_Plasma__Animation, xenum_Plasma__Animation, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::Animation) },	//33
    { "Plasma::AnimationDriver", false, 1, xcall_Plasma__AnimationDriver, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::AnimationDriver) },	//34
    { "Plasma::Animator", false, 1, xcall_Plasma__Animator, xenum_Plasma__Animator, Smoke::cf_virtual, sizeof(Plasma::Animator) },	//35
    { "Plasma::Applet", false, 3, xcall_Plasma__Applet, xenum_Plasma__Applet, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::Applet) },	//36
    { "Plasma::AppletScript", false, 9, xcall_Plasma__AppletScript, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::AppletScript) },	//37
    { "Plasma::AuthorizationInterface", false, 0, xcall_Plasma__AuthorizationInterface, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(Plasma::AuthorizationInterface) },	//38
    { "Plasma::AuthorizationManager", false, 1, xcall_Plasma__AuthorizationManager, xenum_Plasma__AuthorizationManager, Smoke::cf_virtual, sizeof(Plasma::AuthorizationManager) },	//39
    { "Plasma::AuthorizationRule", false, 1, xcall_Plasma__AuthorizationRule, xenum_Plasma__AuthorizationRule, Smoke::cf_virtual, sizeof(Plasma::AuthorizationRule) },	//40
    { "Plasma::BusyWidget", false, 3, xcall_Plasma__BusyWidget, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::BusyWidget) },	//41
    { "Plasma::CheckBox", false, 11, xcall_Plasma__CheckBox, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::CheckBox) },	//42
    { "Plasma::ClientPinRequest", false, 1, xcall_Plasma__ClientPinRequest, 0, Smoke::cf_virtual, sizeof(Plasma::ClientPinRequest) },	//43
    { "Plasma::ComboBox", false, 11, xcall_Plasma__ComboBox, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::ComboBox) },	//44
    { "Plasma::ConfigLoader", false, 13, xcall_Plasma__ConfigLoader, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::ConfigLoader) },	//45
    { "Plasma::Containment", false, 15, xcall_Plasma__Containment, xenum_Plasma__Containment, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::Containment) },	//46
    { "Plasma::Containment::StyleOption", false, 17, xcall_Plasma__Containment__StyleOption, xenum_Plasma__Containment__StyleOption, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(Plasma::Containment::StyleOption) },	//47
    { "Plasma::ContainmentActions", false, 1, xcall_Plasma__ContainmentActions, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::ContainmentActions) },	//48
    { "Plasma::ContainmentActionsPluginsConfig", false, 0, xcall_Plasma__ContainmentActionsPluginsConfig, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(Plasma::ContainmentActionsPluginsConfig) },	//49
    { "Plasma::Context", false, 1, xcall_Plasma__Context, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::Context) },	//50
    { "Plasma::Corona", false, 19, xcall_Plasma__Corona, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::Corona) },	//51
    { "Plasma::DataContainer", false, 1, xcall_Plasma__DataContainer, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::DataContainer) },	//52
    { "Plasma::DataEngine", false, 1, xcall_Plasma__DataEngine, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::DataEngine) },	//53
    { "Plasma::DataEngineManager", false, 1, xcall_Plasma__DataEngineManager, 0, Smoke::cf_virtual, sizeof(Plasma::DataEngineManager) },	//54
    { "Plasma::DataEngineScript", false, 9, xcall_Plasma__DataEngineScript, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::DataEngineScript) },	//55
    { "Plasma::Delegate", false, 21, xcall_Plasma__Delegate, xenum_Plasma__Delegate, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::Delegate) },	//56
    { "Plasma::Dialog", false, 23, xcall_Plasma__Dialog, xenum_Plasma__Dialog, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::Dialog) },	//57
    { "Plasma::Extender", false, 3, xcall_Plasma__Extender, xenum_Plasma__Extender, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::Extender) },	//58
    { "Plasma::ExtenderGroup", false, 25, xcall_Plasma__ExtenderGroup, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::ExtenderGroup) },	//59
    { "Plasma::ExtenderItem", false, 3, xcall_Plasma__ExtenderItem, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::ExtenderItem) },	//60
    { "Plasma::FlashingLabel", false, 3, xcall_Plasma__FlashingLabel, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::FlashingLabel) },	//61
    { "Plasma::Frame", false, 3, xcall_Plasma__Frame, xenum_Plasma__Frame, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::Frame) },	//62
    { "Plasma::FrameSvg", false, 27, xcall_Plasma__FrameSvg, xenum_Plasma__FrameSvg, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::FrameSvg) },	//63
    { "Plasma::GLApplet", false, 15, xcall_Plasma__GLApplet, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::GLApplet) },	//64
    { "Plasma::GroupBox", false, 11, xcall_Plasma__GroupBox, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::GroupBox) },	//65
    { "Plasma::IconWidget", false, 3, xcall_Plasma__IconWidget, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::IconWidget) },	//66
    { "Plasma::ItemBackground", false, 3, xcall_Plasma__ItemBackground, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::ItemBackground) },	//67
    { "Plasma::Label", false, 11, xcall_Plasma__Label, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::Label) },	//68
    { "Plasma::LineEdit", false, 11, xcall_Plasma__LineEdit, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::LineEdit) },	//69
    { "Plasma::Meter", false, 3, xcall_Plasma__Meter, xenum_Plasma__Meter, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::Meter) },	//70
    { "Plasma::Package", false, 0, xcall_Plasma__Package, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(Plasma::Package) },	//71
    { "Plasma::PackageMetadata", false, 0, xcall_Plasma__PackageMetadata, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(Plasma::PackageMetadata) },	//72
    { "Plasma::PackageStructure", false, 29, xcall_Plasma__PackageStructure, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::PackageStructure) },	//73
    { "Plasma::PlotColor", false, 0, xcall_Plasma__PlotColor, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(Plasma::PlotColor) },	//74
    { "Plasma::PopupApplet", false, 15, xcall_Plasma__PopupApplet, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::PopupApplet) },	//75
    { "Plasma::PushButton", false, 11, xcall_Plasma__PushButton, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::PushButton) },	//76
    { "Plasma::QueryMatch", false, 0, xcall_Plasma__QueryMatch, xenum_Plasma__QueryMatch, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(Plasma::QueryMatch) },	//77
    { "Plasma::RadioButton", false, 11, xcall_Plasma__RadioButton, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::RadioButton) },	//78
    { "Plasma::RunnerContext", false, 1, xcall_Plasma__RunnerContext, xenum_Plasma__RunnerContext, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::RunnerContext) },	//79
    { "Plasma::RunnerManager", false, 1, xcall_Plasma__RunnerManager, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::RunnerManager) },	//80
    { "Plasma::RunnerScript", false, 9, xcall_Plasma__RunnerScript, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::RunnerScript) },	//81
    { "Plasma::RunnerSyntax", false, 0, xcall_Plasma__RunnerSyntax, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(Plasma::RunnerSyntax) },	//82
    { "Plasma::ScriptEngine", false, 1, xcall_Plasma__ScriptEngine, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::ScriptEngine) },	//83
    { "Plasma::ScrollBar", false, 11, xcall_Plasma__ScrollBar, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::ScrollBar) },	//84
    { "Plasma::ScrollWidget", false, 3, xcall_Plasma__ScrollWidget, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::ScrollWidget) },	//85
    { "Plasma::Separator", false, 3, xcall_Plasma__Separator, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::Separator) },	//86
    { "Plasma::Service", false, 1, xcall_Plasma__Service, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::Service) },	//87
    { "Plasma::ServiceAccessJob", false, 5, xcall_Plasma__ServiceAccessJob, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::ServiceAccessJob) },	//88
    { "Plasma::ServiceJob", true, 0, 0, 0, 0, 0 },	//89
    { "Plasma::SignalPlotter", false, 3, xcall_Plasma__SignalPlotter, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::SignalPlotter) },	//90
    { "Plasma::Slider", false, 11, xcall_Plasma__Slider, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::Slider) },	//91
    { "Plasma::SpinBox", false, 11, xcall_Plasma__SpinBox, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::SpinBox) },	//92
    { "Plasma::Svg", false, 1, xcall_Plasma__Svg, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::Svg) },	//93
    { "Plasma::SvgWidget", false, 3, xcall_Plasma__SvgWidget, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::SvgWidget) },	//94
    { "Plasma::TabBar", false, 3, xcall_Plasma__TabBar, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::TabBar) },	//95
    { "Plasma::TextBrowser", false, 11, xcall_Plasma__TextBrowser, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::TextBrowser) },	//96
    { "Plasma::TextEdit", false, 11, xcall_Plasma__TextEdit, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::TextEdit) },	//97
    { "Plasma::Theme", false, 1, xcall_Plasma__Theme, xenum_Plasma__Theme, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::Theme) },	//98
    { "Plasma::ToolButton", false, 11, xcall_Plasma__ToolButton, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::ToolButton) },	//99
    { "Plasma::ToolTipContent", false, 0, xcall_Plasma__ToolTipContent, xenum_Plasma__ToolTipContent, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(Plasma::ToolTipContent) },	//100
    { "Plasma::ToolTipManager", false, 1, xcall_Plasma__ToolTipManager, xenum_Plasma__ToolTipManager, Smoke::cf_virtual, sizeof(Plasma::ToolTipManager) },	//101
    { "Plasma::TreeView", false, 11, xcall_Plasma__TreeView, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::TreeView) },	//102
    { "Plasma::VideoWidget", false, 11, xcall_Plasma__VideoWidget, xenum_Plasma__VideoWidget, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::VideoWidget) },	//103
    { "Plasma::View", false, 32, xcall_Plasma__View, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::View) },	//104
    { "Plasma::Wallpaper", false, 1, xcall_Plasma__Wallpaper, xenum_Plasma__Wallpaper, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::Wallpaper) },	//105
    { "Plasma::WallpaperScript", false, 9, xcall_Plasma__WallpaperScript, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::WallpaperScript) },	//106
    { "Plasma::WebView", false, 3, xcall_Plasma__WebView, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Plasma::WebView) },	//107
    { "QAbstractAnimation", true, 0, 0, 0, 0, 0 },	//108
    { "QAbstractItemDelegate", true, 0, 0, 0, 0, 0 },	//109
    { "QAbstractItemModel", true, 0, 0, 0, 0, 0 },	//110
    { "QAbstractScrollArea", true, 0, 0, 0, 0, 0 },	//111
    { "QAction", true, 0, 0, 0, 0, 0 },	//112
    { "QActionEvent", true, 0, 0, 0, 0, 0 },	//113
    { "QBool", true, 0, 0, 0, 0, 0 },	//114
    { "QByteArray", true, 0, 0, 0, 0, 0 },	//115
    { "QCheckBox", true, 0, 0, 0, 0, 0 },	//116
    { "QChildEvent", true, 0, 0, 0, 0, 0 },	//117
    { "QCloseEvent", true, 0, 0, 0, 0, 0 },	//118
    { "QColor", true, 0, 0, 0, 0, 0 },	//119
    { "QContextMenuEvent", true, 0, 0, 0, 0, 0 },	//120
    { "QDragEnterEvent", true, 0, 0, 0, 0, 0 },	//121
    { "QDragLeaveEvent", true, 0, 0, 0, 0, 0 },	//122
    { "QDragMoveEvent", true, 0, 0, 0, 0, 0 },	//123
    { "QDropEvent", true, 0, 0, 0, 0, 0 },	//124
    { "QEasingCurve", true, 0, 0, 0, 0, 0 },	//125
    { "QEvent", true, 0, 0, 0, 0, 0 },	//126
    { "QFocusEvent", true, 0, 0, 0, 0, 0 },	//127
    { "QFont", true, 0, 0, 0, 0, 0 },	//128
    { "QFontMetrics", true, 0, 0, 0, 0, 0 },	//129
    { "QFrame", true, 0, 0, 0, 0, 0 },	//130
    { "QGlobalSpace", false, 0, xcall_QGlobalSpace, 0, Smoke::cf_namespace, 0 },	//131
    { "QGraphicsItem", true, 0, 0, 0, 0, 0 },	//132
    { "QGraphicsLayoutItem", true, 0, 0, 0, 0, 0 },	//133
    { "QGraphicsObject", true, 0, 0, 0, 0, 0 },	//134
    { "QGraphicsProxyWidget", true, 0, 0, 0, 0, 0 },	//135
    { "QGraphicsScene", true, 0, 0, 0, 0, 0 },	//136
    { "QGraphicsSceneContextMenuEvent", true, 0, 0, 0, 0, 0 },	//137
    { "QGraphicsSceneDragDropEvent", true, 0, 0, 0, 0, 0 },	//138
    { "QGraphicsSceneHelpEvent", true, 0, 0, 0, 0, 0 },	//139
    { "QGraphicsSceneHoverEvent", true, 0, 0, 0, 0, 0 },	//140
    { "QGraphicsSceneMouseEvent", true, 0, 0, 0, 0, 0 },	//141
    { "QGraphicsSceneMoveEvent", true, 0, 0, 0, 0, 0 },	//142
    { "QGraphicsSceneResizeEvent", true, 0, 0, 0, 0, 0 },	//143
    { "QGraphicsSceneWheelEvent", true, 0, 0, 0, 0, 0 },	//144
    { "QGraphicsView", true, 0, 0, 0, 0, 0 },	//145
    { "QGraphicsWidget", true, 0, 0, 0, 0, 0 },	//146
    { "QGroupBox", true, 0, 0, 0, 0, 0 },	//147
    { "QHideEvent", true, 0, 0, 0, 0, 0 },	//148
    { "QIODevice", true, 0, 0, 0, 0, 0 },	//149
    { "QIcon", true, 0, 0, 0, 0, 0 },	//150
    { "QImage", true, 0, 0, 0, 0, 0 },	//151
    { "QInputMethodEvent", true, 0, 0, 0, 0, 0 },	//152
    { "QKeyEvent", true, 0, 0, 0, 0, 0 },	//153
    { "QLabel", true, 0, 0, 0, 0, 0 },	//154
    { "QMenu", true, 0, 0, 0, 0, 0 },	//155
    { "QMetaObject", true, 0, 0, 0, 0, 0 },	//156
    { "QMimeData", true, 0, 0, 0, 0, 0 },	//157
    { "QModelIndex", true, 0, 0, 0, 0, 0 },	//158
    { "QMouseEvent", true, 0, 0, 0, 0, 0 },	//159
    { "QMoveEvent", true, 0, 0, 0, 0, 0 },	//160
    { "QMutex", true, 0, 0, 0, 0, 0 },	//161
    { "QObject", true, 0, 0, 0, 0, 0 },	//162
    { "QPaintEngine", true, 0, 0, 0, 0, 0 },	//163
    { "QPaintEvent", true, 0, 0, 0, 0, 0 },	//164
    { "QPainter", true, 0, 0, 0, 0, 0 },	//165
    { "QPainterPath", true, 0, 0, 0, 0, 0 },	//166
    { "QPalette", true, 0, 0, 0, 0, 0 },	//167
    { "QPixmap", true, 0, 0, 0, 0, 0 },	//168
    { "QPoint", true, 0, 0, 0, 0, 0 },	//169
    { "QPointF", true, 0, 0, 0, 0, 0 },	//170
    { "QRadioButton", true, 0, 0, 0, 0, 0 },	//171
    { "QRect", true, 0, 0, 0, 0, 0 },	//172
    { "QRectF", true, 0, 0, 0, 0, 0 },	//173
    { "QRegExp", true, 0, 0, 0, 0, 0 },	//174
    { "QRegion", true, 0, 0, 0, 0, 0 },	//175
    { "QResizeEvent", true, 0, 0, 0, 0, 0 },	//176
    { "QScrollBar", true, 0, 0, 0, 0, 0 },	//177
    { "QSharedData", true, 0, 0, 0, 0, 0 },	//178
    { "QShowEvent", true, 0, 0, 0, 0, 0 },	//179
    { "QSize", true, 0, 0, 0, 0, 0 },	//180
    { "QSizeF", true, 0, 0, 0, 0, 0 },	//181
    { "QSlider", true, 0, 0, 0, 0, 0 },	//182
    { "QStyle", true, 0, 0, 0, 0, 0 },	//183
    { "QStyleOption", true, 0, 0, 0, 0, 0 },	//184
    { "QStyleOptionGraphicsItem", true, 0, 0, 0, 0, 0 },	//185
    { "QStyleOptionViewItem", true, 0, 0, 0, 0, 0 },	//186
    { "QTabletEvent", true, 0, 0, 0, 0, 0 },	//187
    { "QTextDocument", true, 0, 0, 0, 0, 0 },	//188
    { "QTextOption", true, 0, 0, 0, 0, 0 },	//189
    { "QTimerEvent", true, 0, 0, 0, 0, 0 },	//190
    { "QToolButton", true, 0, 0, 0, 0, 0 },	//191
    { "QTreeView", true, 0, 0, 0, 0, 0 },	//192
    { "QUrl", true, 0, 0, 0, 0, 0 },	//193
    { "QVariant", true, 0, 0, 0, 0, 0 },	//194
    { "QWebFrame", true, 0, 0, 0, 0, 0 },	//195
    { "QWebPage", true, 0, 0, 0, 0, 0 },	//196
    { "QWheelEvent", true, 0, 0, 0, 0, 0 },	//197
    { "QWidget", true, 0, 0, 0, 0, 0 },	//198
};

// List of all types needed by the methods (arguments and return values)
// Name, class ID if arg is a class, and TypeId
static Smoke::Type types[] = {
    { 0, 0, 0 },	//0 (no type)
    { "GLenum", 0, Smoke::t_voidp|Smoke::tf_stack },	//1
    { "GLuint", 0, Smoke::t_voidp|Smoke::tf_stack },	//2
    { "KAction*", 1, Smoke::t_class|Smoke::tf_ptr },	//3
    { "KActionCollection*", 2, Smoke::t_class|Smoke::tf_ptr },	//4
    { "KComboBox*", 3, Smoke::t_class|Smoke::tf_ptr },	//5
    { "KConfigBase*", 4, Smoke::t_class|Smoke::tf_ptr },	//6
    { "KConfigDialog*", 5, Smoke::t_class|Smoke::tf_ptr },	//7
    { "KConfigGroup", 6, Smoke::t_class|Smoke::tf_stack },	//8
    { "KConfigGroup&", 6, Smoke::t_class|Smoke::tf_ref },	//9
    { "KConfigSkeletonItem*", 8, Smoke::t_class|Smoke::tf_ptr },	//10
    { "KGlobal::CopyCatalogs", 0, Smoke::t_enum|Smoke::tf_stack },	//11
    { "KIntSpinBox*", 11, Smoke::t_class|Smoke::tf_ptr },	//12
    { "KLineEdit*", 13, Smoke::t_class|Smoke::tf_ptr },	//13
    { "KPluginInfo", 14, Smoke::t_class|Smoke::tf_stack },	//14
    { "KPushButton*", 15, Smoke::t_class|Smoke::tf_ptr },	//15
    { "KService", 16, Smoke::t_class|Smoke::tf_stack },	//16
    { "KServiceAction", 17, Smoke::t_class|Smoke::tf_stack },	//17
    { "KSharedConfig", 18, Smoke::t_class|Smoke::tf_stack },	//18
    { "KSharedPtr<KService>", 0, Smoke::t_voidp|Smoke::tf_stack },	//19
    { "KSharedPtr<KSharedConfig>", 0, Smoke::t_voidp|Smoke::tf_stack },	//20
    { "KSharedPtr<Plasma::PackageStructure>", 0, Smoke::t_voidp|Smoke::tf_stack },	//21
    { "KShortcut", 19, Smoke::t_class|Smoke::tf_stack },	//22
    { "KTabBar*", 20, Smoke::t_class|Smoke::tf_ptr },	//23
    { "KTextBrowser*", 21, Smoke::t_class|Smoke::tf_ptr },	//24
    { "KTextEdit*", 22, Smoke::t_class|Smoke::tf_ptr },	//25
    { "KUrl", 23, Smoke::t_class|Smoke::tf_stack },	//26
    { "KUrl::List", 0, Smoke::t_voidp|Smoke::tf_stack },	//27
    { "Phonon::AudioOutput*", 24, Smoke::t_class|Smoke::tf_ptr },	//28
    { "Phonon::MediaObject*", 25, Smoke::t_class|Smoke::tf_ptr },	//29
    { "Phonon::VideoWidget*", 26, Smoke::t_class|Smoke::tf_ptr },	//30
    { "Plasma::AbstractDialogManager*", 28, Smoke::t_class|Smoke::tf_ptr },	//31
    { "Plasma::AbstractRunner*", 29, Smoke::t_class|Smoke::tf_ptr },	//32
    { "Plasma::AbstractRunner::Priority", 29, Smoke::t_enum|Smoke::tf_stack },	//33
    { "Plasma::AbstractRunner::Speed", 29, Smoke::t_enum|Smoke::tf_stack },	//34
    { "Plasma::AbstractToolBox*", 30, Smoke::t_class|Smoke::tf_ptr },	//35
    { "Plasma::AbstractToolBox::ToolType", 30, Smoke::t_enum|Smoke::tf_stack },	//36
    { "Plasma::AccessAppletJob*", 31, Smoke::t_class|Smoke::tf_ptr },	//37
    { "Plasma::AccessManager*", 32, Smoke::t_class|Smoke::tf_ptr },	//38
    { "Plasma::Animation*", 33, Smoke::t_class|Smoke::tf_ptr },	//39
    { "Plasma::Animation::MovementDirectionFlag", 33, Smoke::t_enum|Smoke::tf_stack },	//40
    { "Plasma::Animation::ReferenceFlag", 33, Smoke::t_enum|Smoke::tf_stack },	//41
    { "Plasma::AnimationDriver*", 34, Smoke::t_class|Smoke::tf_ptr },	//42
    { "Plasma::Animator*", 35, Smoke::t_class|Smoke::tf_ptr },	//43
    { "Plasma::Animator::Animation", 35, Smoke::t_enum|Smoke::tf_stack },	//44
    { "Plasma::Animator::CurveShape", 35, Smoke::t_enum|Smoke::tf_stack },	//45
    { "Plasma::Animator::Movement", 35, Smoke::t_enum|Smoke::tf_stack },	//46
    { "Plasma::AnnouncementMethod", 27, Smoke::t_enum|Smoke::tf_stack },	//47
    { "Plasma::AnnouncementMethods", 0, Smoke::t_uint|Smoke::tf_stack },	//48
    { "Plasma::Applet*", 36, Smoke::t_class|Smoke::tf_ptr },	//49
    { "Plasma::Applet::BackgroundHint", 36, Smoke::t_enum|Smoke::tf_stack },	//50
    { "Plasma::AppletScript*", 37, Smoke::t_class|Smoke::tf_ptr },	//51
    { "Plasma::AspectRatioMode", 27, Smoke::t_enum|Smoke::tf_stack },	//52
    { "Plasma::AuthorizationInterface*", 38, Smoke::t_class|Smoke::tf_ptr },	//53
    { "Plasma::AuthorizationManager*", 39, Smoke::t_class|Smoke::tf_ptr },	//54
    { "Plasma::AuthorizationManager::AuthorizationPolicy", 39, Smoke::t_enum|Smoke::tf_stack },	//55
    { "Plasma::AuthorizationRule&", 40, Smoke::t_class|Smoke::tf_ref },	//56
    { "Plasma::AuthorizationRule*", 40, Smoke::t_class|Smoke::tf_ptr },	//57
    { "Plasma::AuthorizationRule::Persistence", 40, Smoke::t_enum|Smoke::tf_stack },	//58
    { "Plasma::AuthorizationRule::Policy", 40, Smoke::t_enum|Smoke::tf_stack },	//59
    { "Plasma::AuthorizationRule::Target", 40, Smoke::t_enum|Smoke::tf_stack },	//60
    { "Plasma::BusyWidget*", 41, Smoke::t_class|Smoke::tf_ptr },	//61
    { "Plasma::CheckBox*", 42, Smoke::t_class|Smoke::tf_ptr },	//62
    { "Plasma::ClientPinRequest&", 43, Smoke::t_class|Smoke::tf_ref },	//63
    { "Plasma::ClientPinRequest*", 43, Smoke::t_class|Smoke::tf_ptr },	//64
    { "Plasma::ComboBox*", 44, Smoke::t_class|Smoke::tf_ptr },	//65
    { "Plasma::ComponentType", 27, Smoke::t_enum|Smoke::tf_stack },	//66
    { "Plasma::ConfigLoader*", 45, Smoke::t_class|Smoke::tf_ptr },	//67
    { "Plasma::Constraint", 27, Smoke::t_enum|Smoke::tf_stack },	//68
    { "Plasma::Containment*", 46, Smoke::t_class|Smoke::tf_ptr },	//69
    { "Plasma::Containment::StyleOption*", 47, Smoke::t_class|Smoke::tf_ptr },	//70
    { "Plasma::Containment::StyleOption::StyleOptionType", 47, Smoke::t_enum|Smoke::tf_stack },	//71
    { "Plasma::Containment::StyleOption::StyleOptionVersion", 47, Smoke::t_enum|Smoke::tf_stack },	//72
    { "Plasma::Containment::Type", 46, Smoke::t_enum|Smoke::tf_stack },	//73
    { "Plasma::ContainmentActions*", 48, Smoke::t_class|Smoke::tf_ptr },	//74
    { "Plasma::ContainmentActionsPluginsConfig", 49, Smoke::t_class|Smoke::tf_stack },	//75
    { "Plasma::ContainmentActionsPluginsConfig&", 49, Smoke::t_class|Smoke::tf_ref },	//76
    { "Plasma::ContainmentActionsPluginsConfig*", 49, Smoke::t_class|Smoke::tf_ptr },	//77
    { "Plasma::Context*", 50, Smoke::t_class|Smoke::tf_ptr },	//78
    { "Plasma::Corona*", 51, Smoke::t_class|Smoke::tf_ptr },	//79
    { "Plasma::DataContainer*", 52, Smoke::t_class|Smoke::tf_ptr },	//80
    { "Plasma::DataEngine*", 53, Smoke::t_class|Smoke::tf_ptr },	//81
    { "Plasma::DataEngine::Data", 0, Smoke::t_voidp|Smoke::tf_stack },	//82
    { "Plasma::DataEngineManager*", 54, Smoke::t_class|Smoke::tf_ptr },	//83
    { "Plasma::DataEngineScript*", 55, Smoke::t_class|Smoke::tf_ptr },	//84
    { "Plasma::Delegate*", 56, Smoke::t_class|Smoke::tf_ptr },	//85
    { "Plasma::Delegate::ColumnType", 56, Smoke::t_enum|Smoke::tf_stack },	//86
    { "Plasma::Delegate::SpecificRoles", 56, Smoke::t_enum|Smoke::tf_stack },	//87
    { "Plasma::Dialog*", 57, Smoke::t_class|Smoke::tf_ptr },	//88
    { "Plasma::Dialog::ResizeCorner", 57, Smoke::t_enum|Smoke::tf_stack },	//89
    { "Plasma::Direction", 27, Smoke::t_enum|Smoke::tf_stack },	//90
    { "Plasma::Extender*", 58, Smoke::t_class|Smoke::tf_ptr },	//91
    { "Plasma::Extender::Appearance", 58, Smoke::t_enum|Smoke::tf_stack },	//92
    { "Plasma::ExtenderGroup*", 59, Smoke::t_class|Smoke::tf_ptr },	//93
    { "Plasma::ExtenderItem*", 60, Smoke::t_class|Smoke::tf_ptr },	//94
    { "Plasma::FlashingLabel*", 61, Smoke::t_class|Smoke::tf_ptr },	//95
    { "Plasma::FlipDirection", 27, Smoke::t_enum|Smoke::tf_stack },	//96
    { "Plasma::FormFactor", 27, Smoke::t_enum|Smoke::tf_stack },	//97
    { "Plasma::Frame*", 62, Smoke::t_class|Smoke::tf_ptr },	//98
    { "Plasma::Frame::Shadow", 62, Smoke::t_enum|Smoke::tf_stack },	//99
    { "Plasma::FrameSvg*", 63, Smoke::t_class|Smoke::tf_ptr },	//100
    { "Plasma::FrameSvg::EnabledBorder", 63, Smoke::t_enum|Smoke::tf_stack },	//101
    { "Plasma::GLApplet*", 64, Smoke::t_class|Smoke::tf_ptr },	//102
    { "Plasma::GroupBox*", 65, Smoke::t_class|Smoke::tf_ptr },	//103
    { "Plasma::IconWidget*", 66, Smoke::t_class|Smoke::tf_ptr },	//104
    { "Plasma::ImmutabilityType", 27, Smoke::t_enum|Smoke::tf_stack },	//105
    { "Plasma::IntervalAlignment", 27, Smoke::t_enum|Smoke::tf_stack },	//106
    { "Plasma::ItemBackground*", 67, Smoke::t_class|Smoke::tf_ptr },	//107
    { "Plasma::ItemStatus", 27, Smoke::t_enum|Smoke::tf_stack },	//108
    { "Plasma::ItemTypes", 27, Smoke::t_enum|Smoke::tf_stack },	//109
    { "Plasma::Label*", 68, Smoke::t_class|Smoke::tf_ptr },	//110
    { "Plasma::LineEdit*", 69, Smoke::t_class|Smoke::tf_ptr },	//111
    { "Plasma::Location", 27, Smoke::t_enum|Smoke::tf_stack },	//112
    { "Plasma::MarginEdge", 27, Smoke::t_enum|Smoke::tf_stack },	//113
    { "Plasma::MessageButton", 27, Smoke::t_enum|Smoke::tf_stack },	//114
    { "Plasma::Meter*", 70, Smoke::t_class|Smoke::tf_ptr },	//115
    { "Plasma::Meter::MeterType", 70, Smoke::t_enum|Smoke::tf_stack },	//116
    { "Plasma::Package&", 71, Smoke::t_class|Smoke::tf_ref },	//117
    { "Plasma::Package*", 71, Smoke::t_class|Smoke::tf_ptr },	//118
    { "Plasma::PackageMetadata", 72, Smoke::t_class|Smoke::tf_stack },	//119
    { "Plasma::PackageMetadata&", 72, Smoke::t_class|Smoke::tf_ref },	//120
    { "Plasma::PackageMetadata*", 72, Smoke::t_class|Smoke::tf_ptr },	//121
    { "Plasma::PackageStructure", 73, Smoke::t_class|Smoke::tf_stack },	//122
    { "Plasma::PackageStructure&", 73, Smoke::t_class|Smoke::tf_ref },	//123
    { "Plasma::PackageStructure*", 73, Smoke::t_class|Smoke::tf_ptr },	//124
    { "Plasma::PlotColor", 74, Smoke::t_class|Smoke::tf_stack },	//125
    { "Plasma::PlotColor*", 74, Smoke::t_class|Smoke::tf_ptr },	//126
    { "Plasma::PopupApplet*", 75, Smoke::t_class|Smoke::tf_ptr },	//127
    { "Plasma::PopupPlacement", 27, Smoke::t_enum|Smoke::tf_stack },	//128
    { "Plasma::Position", 27, Smoke::t_enum|Smoke::tf_stack },	//129
    { "Plasma::PushButton*", 76, Smoke::t_class|Smoke::tf_ptr },	//130
    { "Plasma::QueryMatch", 77, Smoke::t_class|Smoke::tf_stack },	//131
    { "Plasma::QueryMatch&", 77, Smoke::t_class|Smoke::tf_ref },	//132
    { "Plasma::QueryMatch*", 77, Smoke::t_class|Smoke::tf_ptr },	//133
    { "Plasma::QueryMatch::Type", 77, Smoke::t_enum|Smoke::tf_stack },	//134
    { "Plasma::RadioButton*", 78, Smoke::t_class|Smoke::tf_ptr },	//135
    { "Plasma::RunnerContext&", 79, Smoke::t_class|Smoke::tf_ref },	//136
    { "Plasma::RunnerContext*", 79, Smoke::t_class|Smoke::tf_ptr },	//137
    { "Plasma::RunnerContext::Type", 79, Smoke::t_enum|Smoke::tf_stack },	//138
    { "Plasma::RunnerManager*", 80, Smoke::t_class|Smoke::tf_ptr },	//139
    { "Plasma::RunnerScript*", 81, Smoke::t_class|Smoke::tf_ptr },	//140
    { "Plasma::RunnerSyntax", 82, Smoke::t_class|Smoke::tf_stack },	//141
    { "Plasma::RunnerSyntax&", 82, Smoke::t_class|Smoke::tf_ref },	//142
    { "Plasma::RunnerSyntax*", 82, Smoke::t_class|Smoke::tf_ptr },	//143
    { "Plasma::ScriptEngine*", 83, Smoke::t_class|Smoke::tf_ptr },	//144
    { "Plasma::ScrollBar*", 84, Smoke::t_class|Smoke::tf_ptr },	//145
    { "Plasma::ScrollWidget*", 85, Smoke::t_class|Smoke::tf_ptr },	//146
    { "Plasma::Separator*", 86, Smoke::t_class|Smoke::tf_ptr },	//147
    { "Plasma::Service*", 87, Smoke::t_class|Smoke::tf_ptr },	//148
    { "Plasma::ServiceAccessJob*", 88, Smoke::t_class|Smoke::tf_ptr },	//149
    { "Plasma::ServiceJob*", 89, Smoke::t_class|Smoke::tf_ptr },	//150
    { "Plasma::SignalPlotter*", 90, Smoke::t_class|Smoke::tf_ptr },	//151
    { "Plasma::Slider*", 91, Smoke::t_class|Smoke::tf_ptr },	//152
    { "Plasma::SpinBox*", 92, Smoke::t_class|Smoke::tf_ptr },	//153
    { "Plasma::Svg*", 93, Smoke::t_class|Smoke::tf_ptr },	//154
    { "Plasma::SvgWidget*", 94, Smoke::t_class|Smoke::tf_ptr },	//155
    { "Plasma::TabBar*", 95, Smoke::t_class|Smoke::tf_ptr },	//156
    { "Plasma::TextBrowser*", 96, Smoke::t_class|Smoke::tf_ptr },	//157
    { "Plasma::TextEdit*", 97, Smoke::t_class|Smoke::tf_ptr },	//158
    { "Plasma::Theme*", 98, Smoke::t_class|Smoke::tf_ptr },	//159
    { "Plasma::Theme::ColorRole", 98, Smoke::t_enum|Smoke::tf_stack },	//160
    { "Plasma::Theme::FontRole", 98, Smoke::t_enum|Smoke::tf_stack },	//161
    { "Plasma::ToolButton*", 99, Smoke::t_class|Smoke::tf_ptr },	//162
    { "Plasma::ToolTipContent&", 100, Smoke::t_class|Smoke::tf_ref },	//163
    { "Plasma::ToolTipContent*", 100, Smoke::t_class|Smoke::tf_ptr },	//164
    { "Plasma::ToolTipContent::ResourceType", 100, Smoke::t_enum|Smoke::tf_stack },	//165
    { "Plasma::ToolTipManager*", 101, Smoke::t_class|Smoke::tf_ptr },	//166
    { "Plasma::ToolTipManager::State", 101, Smoke::t_enum|Smoke::tf_stack },	//167
    { "Plasma::TreeView*", 102, Smoke::t_class|Smoke::tf_ptr },	//168
    { "Plasma::TrustLevel", 27, Smoke::t_enum|Smoke::tf_stack },	//169
    { "Plasma::VideoWidget*", 103, Smoke::t_class|Smoke::tf_ptr },	//170
    { "Plasma::VideoWidget::Control", 103, Smoke::t_enum|Smoke::tf_stack },	//171
    { "Plasma::View*", 104, Smoke::t_class|Smoke::tf_ptr },	//172
    { "Plasma::Wallpaper*", 105, Smoke::t_class|Smoke::tf_ptr },	//173
    { "Plasma::Wallpaper::ResizeMethod", 105, Smoke::t_enum|Smoke::tf_stack },	//174
    { "Plasma::WallpaperScript*", 106, Smoke::t_class|Smoke::tf_ptr },	//175
    { "Plasma::WebView*", 107, Smoke::t_class|Smoke::tf_ptr },	//176
    { "Plasma::WindowEffects::Effect", 0, Smoke::t_enum|Smoke::tf_stack },	//177
    { "Plasma::ZoomDirection", 27, Smoke::t_enum|Smoke::tf_stack },	//178
    { "Plasma::ZoomLevel", 27, Smoke::t_enum|Smoke::tf_stack },	//179
    { "QAbstractAnimation::Direction", 108, Smoke::t_enum|Smoke::tf_stack },	//180
    { "QAbstractAnimation::State", 108, Smoke::t_enum|Smoke::tf_stack },	//181
    { "QAbstractItemModel*", 110, Smoke::t_class|Smoke::tf_ptr },	//182
    { "QAction*", 112, Smoke::t_class|Smoke::tf_ptr },	//183
    { "QActionEvent*", 113, Smoke::t_class|Smoke::tf_ptr },	//184
    { "QBool", 114, Smoke::t_class|Smoke::tf_stack },	//185
    { "QCheckBox*", 116, Smoke::t_class|Smoke::tf_ptr },	//186
    { "QChildEvent*", 117, Smoke::t_class|Smoke::tf_ptr },	//187
    { "QCloseEvent*", 118, Smoke::t_class|Smoke::tf_ptr },	//188
    { "QColor", 119, Smoke::t_class|Smoke::tf_stack },	//189
    { "QColor&", 119, Smoke::t_class|Smoke::tf_ref },	//190
    { "QContextMenuEvent*", 120, Smoke::t_class|Smoke::tf_ptr },	//191
    { "QDragEnterEvent*", 121, Smoke::t_class|Smoke::tf_ptr },	//192
    { "QDragLeaveEvent*", 122, Smoke::t_class|Smoke::tf_ptr },	//193
    { "QDragMoveEvent*", 123, Smoke::t_class|Smoke::tf_ptr },	//194
    { "QDrawBorderPixmap::DrawingHint", 0, Smoke::t_enum|Smoke::tf_stack },	//195
    { "QDropEvent*", 124, Smoke::t_class|Smoke::tf_ptr },	//196
    { "QEasingCurve", 125, Smoke::t_class|Smoke::tf_stack },	//197
    { "QEvent*", 126, Smoke::t_class|Smoke::tf_ptr },	//198
    { "QFlags<Plasma::Applet::BackgroundHint>", 0, Smoke::t_uint|Smoke::tf_stack },	//199
    { "QFlags<Plasma::AuthorizationRule::Target>", 0, Smoke::t_uint|Smoke::tf_stack },	//200
    { "QFlags<Plasma::ComponentType>", 0, Smoke::t_uint|Smoke::tf_stack },	//201
    { "QFlags<Plasma::Constraint>", 0, Smoke::t_uint|Smoke::tf_stack },	//202
    { "QFlags<Plasma::Dialog::ResizeCorner>", 0, Smoke::t_uint|Smoke::tf_stack },	//203
    { "QFlags<Plasma::FrameSvg::EnabledBorder>", 0, Smoke::t_uint|Smoke::tf_stack },	//204
    { "QFlags<Plasma::RunnerContext::Type>", 0, Smoke::t_uint|Smoke::tf_stack },	//205
    { "QFlags<Plasma::VideoWidget::Control>", 0, Smoke::t_uint|Smoke::tf_stack },	//206
    { "QFlags<Qt::AlignmentFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//207
    { "QFlags<Qt::KeyboardModifier>", 0, Smoke::t_uint|Smoke::tf_stack },	//208
    { "QFlags<Qt::WindowType>", 0, Smoke::t_uint|Smoke::tf_stack },	//209
    { "QFocusEvent*", 127, Smoke::t_class|Smoke::tf_ptr },	//210
    { "QFont", 128, Smoke::t_class|Smoke::tf_stack },	//211
    { "QFontMetrics", 129, Smoke::t_class|Smoke::tf_stack },	//212
    { "QGL::FormatOption", 0, Smoke::t_enum|Smoke::tf_stack },	//213
    { "QGraphicsItem*", 132, Smoke::t_class|Smoke::tf_ptr },	//214
    { "QGraphicsItem**", 132, Smoke::t_class|Smoke::tf_ptr },	//215
    { "QGraphicsItem::Extension", 132, Smoke::t_enum|Smoke::tf_stack },	//216
    { "QGraphicsItem::GraphicsItemChange", 132, Smoke::t_enum|Smoke::tf_stack },	//217
    { "QGraphicsLayoutItem*", 133, Smoke::t_class|Smoke::tf_ptr },	//218
    { "QGraphicsObject*", 134, Smoke::t_class|Smoke::tf_ptr },	//219
    { "QGraphicsSceneContextMenuEvent*", 137, Smoke::t_class|Smoke::tf_ptr },	//220
    { "QGraphicsSceneDragDropEvent*", 138, Smoke::t_class|Smoke::tf_ptr },	//221
    { "QGraphicsSceneHelpEvent*", 139, Smoke::t_class|Smoke::tf_ptr },	//222
    { "QGraphicsSceneHoverEvent*", 140, Smoke::t_class|Smoke::tf_ptr },	//223
    { "QGraphicsSceneMouseEvent*", 141, Smoke::t_class|Smoke::tf_ptr },	//224
    { "QGraphicsSceneMoveEvent*", 142, Smoke::t_class|Smoke::tf_ptr },	//225
    { "QGraphicsSceneResizeEvent*", 143, Smoke::t_class|Smoke::tf_ptr },	//226
    { "QGraphicsSceneWheelEvent*", 144, Smoke::t_class|Smoke::tf_ptr },	//227
    { "QGraphicsView*", 145, Smoke::t_class|Smoke::tf_ptr },	//228
    { "QGraphicsWidget*", 146, Smoke::t_class|Smoke::tf_ptr },	//229
    { "QGroupBox*", 147, Smoke::t_class|Smoke::tf_ptr },	//230
    { "QHash<QString,Plasma::DataContainer*>", 0, Smoke::t_voidp|Smoke::tf_stack },	//231
    { "QHash<QString,QAction*>", 0, Smoke::t_voidp|Smoke::tf_stack },	//232
    { "QHash<QString,QVariant>", 0, Smoke::t_voidp|Smoke::tf_stack },	//233
    { "QHideEvent*", 148, Smoke::t_class|Smoke::tf_ptr },	//234
    { "QIODevice*", 149, Smoke::t_class|Smoke::tf_ptr },	//235
    { "QIcon", 150, Smoke::t_class|Smoke::tf_stack },	//236
    { "QImage", 151, Smoke::t_class|Smoke::tf_stack },	//237
    { "QImage&", 151, Smoke::t_class|Smoke::tf_ref },	//238
    { "QInputMethodEvent*", 152, Smoke::t_class|Smoke::tf_ptr },	//239
    { "QKeyEvent*", 153, Smoke::t_class|Smoke::tf_ptr },	//240
    { "QLabel*", 154, Smoke::t_class|Smoke::tf_ptr },	//241
    { "QList<KPluginInfo>", 0, Smoke::t_voidp|Smoke::tf_stack },	//242
    { "QList<KServiceAction>", 0, Smoke::t_voidp|Smoke::tf_stack },	//243
    { "QList<KSharedPtr<KService> >", 0, Smoke::t_voidp|Smoke::tf_stack },	//244
    { "QList<Plasma::AbstractRunner*>", 0, Smoke::t_voidp|Smoke::tf_stack },	//245
    { "QList<Plasma::Applet*>", 0, Smoke::t_voidp|Smoke::tf_stack },	//246
    { "QList<Plasma::Containment*>", 0, Smoke::t_voidp|Smoke::tf_stack },	//247
    { "QList<Plasma::ExtenderGroup*>", 0, Smoke::t_voidp|Smoke::tf_stack },	//248
    { "QList<Plasma::ExtenderItem*>", 0, Smoke::t_voidp|Smoke::tf_stack },	//249
    { "QList<Plasma::Location>", 0, Smoke::t_voidp|Smoke::tf_stack },	//250
    { "QList<Plasma::PackageMetadata>", 0, Smoke::t_voidp|Smoke::tf_stack },	//251
    { "QList<Plasma::PlotColor>&", 0, Smoke::t_voidp|Smoke::tf_ref },	//252
    { "QList<Plasma::QueryMatch>", 0, Smoke::t_voidp|Smoke::tf_stack },	//253
    { "QList<Plasma::RunnerSyntax>", 0, Smoke::t_voidp|Smoke::tf_stack },	//254
    { "QList<QAction*>", 0, Smoke::t_voidp|Smoke::tf_stack },	//255
    { "QList<QAction*>&", 0, Smoke::t_voidp|Smoke::tf_ref },	//256
    { "QList<QAction*>*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//257
    { "QList<QGraphicsWidget*>", 0, Smoke::t_voidp|Smoke::tf_stack },	//258
    { "QList<QSize>", 0, Smoke::t_voidp|Smoke::tf_stack },	//259
    { "QList<const char*>", 0, Smoke::t_voidp|Smoke::tf_stack },	//260
    { "QList<unsigned long>", 0, Smoke::t_voidp|Smoke::tf_stack },	//261
    { "QMap<QString,QVariant>", 0, Smoke::t_voidp|Smoke::tf_stack },	//262
    { "QMap<QString,QVariant>&", 0, Smoke::t_voidp|Smoke::tf_ref },	//263
    { "QMenu*", 155, Smoke::t_class|Smoke::tf_ptr },	//264
    { "QMetaObject::Call", 156, Smoke::t_enum|Smoke::tf_stack },	//265
    { "QMimeData*", 157, Smoke::t_class|Smoke::tf_ptr },	//266
    { "QMouseEvent*", 159, Smoke::t_class|Smoke::tf_ptr },	//267
    { "QMoveEvent*", 160, Smoke::t_class|Smoke::tf_ptr },	//268
    { "QMutex*", 161, Smoke::t_class|Smoke::tf_ptr },	//269
    { "QObject*", 162, Smoke::t_class|Smoke::tf_ptr },	//270
    { "QPaintDevice::PaintDeviceMetric", 0, Smoke::t_enum|Smoke::tf_stack },	//271
    { "QPaintEngine*", 163, Smoke::t_class|Smoke::tf_ptr },	//272
    { "QPaintEngine::Type", 163, Smoke::t_enum|Smoke::tf_stack },	//273
    { "QPaintEvent*", 164, Smoke::t_class|Smoke::tf_ptr },	//274
    { "QPainter*", 165, Smoke::t_class|Smoke::tf_ptr },	//275
    { "QPainterPath", 166, Smoke::t_class|Smoke::tf_stack },	//276
    { "QPixmap", 168, Smoke::t_class|Smoke::tf_stack },	//277
    { "QPixmap&", 168, Smoke::t_class|Smoke::tf_ref },	//278
    { "QPoint", 169, Smoke::t_class|Smoke::tf_stack },	//279
    { "QPointF", 170, Smoke::t_class|Smoke::tf_stack },	//280
    { "QRadioButton*", 171, Smoke::t_class|Smoke::tf_ptr },	//281
    { "QRect", 172, Smoke::t_class|Smoke::tf_stack },	//282
    { "QRectF", 173, Smoke::t_class|Smoke::tf_stack },	//283
    { "QRectF&", 173, Smoke::t_class|Smoke::tf_ref },	//284
    { "QRegExp&", 174, Smoke::t_class|Smoke::tf_ref },	//285
    { "QRegion", 175, Smoke::t_class|Smoke::tf_stack },	//286
    { "QResizeEvent*", 176, Smoke::t_class|Smoke::tf_ptr },	//287
    { "QScrollBar*", 177, Smoke::t_class|Smoke::tf_ptr },	//288
    { "QShowEvent*", 179, Smoke::t_class|Smoke::tf_ptr },	//289
    { "QSize", 180, Smoke::t_class|Smoke::tf_stack },	//290
    { "QSizeF", 181, Smoke::t_class|Smoke::tf_stack },	//291
    { "QSlider*", 182, Smoke::t_class|Smoke::tf_ptr },	//292
    { "QString", 0, Smoke::t_voidp|Smoke::tf_stack },	//293
    { "QStringList", 0, Smoke::t_voidp|Smoke::tf_stack },	//294
    { "QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//295
    { "QStyle&", 183, Smoke::t_class|Smoke::tf_ref },	//296
    { "QStyleOption*", 184, Smoke::t_class|Smoke::tf_ptr },	//297
    { "QTabletEvent*", 187, Smoke::t_class|Smoke::tf_ptr },	//298
    { "QTextDocument*", 188, Smoke::t_class|Smoke::tf_ptr },	//299
    { "QTimerEvent*", 190, Smoke::t_class|Smoke::tf_ptr },	//300
    { "QToolButton*", 191, Smoke::t_class|Smoke::tf_ptr },	//301
    { "QTreeView*", 192, Smoke::t_class|Smoke::tf_ptr },	//302
    { "QUrl", 193, Smoke::t_class|Smoke::tf_stack },	//303
    { "QVariant", 194, Smoke::t_class|Smoke::tf_stack },	//304
    { "QVariantList", 0, Smoke::t_voidp|Smoke::tf_stack },	//305
    { "QWebFrame*", 195, Smoke::t_class|Smoke::tf_ptr },	//306
    { "QWebPage*", 196, Smoke::t_class|Smoke::tf_ptr },	//307
    { "QWheelEvent*", 197, Smoke::t_class|Smoke::tf_ptr },	//308
    { "QWidget*", 198, Smoke::t_class|Smoke::tf_ptr },	//309
    { "Qt::AlignmentFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//310
    { "Qt::AnchorAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//311
    { "Qt::AnchorPoint", 0, Smoke::t_enum|Smoke::tf_stack },	//312
    { "Qt::ApplicationAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//313
    { "Qt::ArrowType", 0, Smoke::t_enum|Smoke::tf_stack },	//314
    { "Qt::AspectRatioMode", 0, Smoke::t_enum|Smoke::tf_stack },	//315
    { "Qt::Axis", 0, Smoke::t_enum|Smoke::tf_stack },	//316
    { "Qt::BGMode", 0, Smoke::t_enum|Smoke::tf_stack },	//317
    { "Qt::BrushStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//318
    { "Qt::CaseSensitivity", 0, Smoke::t_enum|Smoke::tf_stack },	//319
    { "Qt::CheckState", 0, Smoke::t_enum|Smoke::tf_stack },	//320
    { "Qt::ClipOperation", 0, Smoke::t_enum|Smoke::tf_stack },	//321
    { "Qt::ConnectionType", 0, Smoke::t_enum|Smoke::tf_stack },	//322
    { "Qt::ContextMenuPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//323
    { "Qt::CoordinateSystem", 0, Smoke::t_enum|Smoke::tf_stack },	//324
    { "Qt::Corner", 0, Smoke::t_enum|Smoke::tf_stack },	//325
    { "Qt::CursorMoveStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//326
    { "Qt::CursorShape", 0, Smoke::t_enum|Smoke::tf_stack },	//327
    { "Qt::DateFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//328
    { "Qt::DayOfWeek", 0, Smoke::t_enum|Smoke::tf_stack },	//329
    { "Qt::DockWidgetArea", 0, Smoke::t_enum|Smoke::tf_stack },	//330
    { "Qt::DockWidgetAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//331
    { "Qt::DropAction", 0, Smoke::t_enum|Smoke::tf_stack },	//332
    { "Qt::EventPriority", 0, Smoke::t_enum|Smoke::tf_stack },	//333
    { "Qt::FillRule", 0, Smoke::t_enum|Smoke::tf_stack },	//334
    { "Qt::FocusPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//335
    { "Qt::FocusReason", 0, Smoke::t_enum|Smoke::tf_stack },	//336
    { "Qt::GestureFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//337
    { "Qt::GestureState", 0, Smoke::t_enum|Smoke::tf_stack },	//338
    { "Qt::GestureType", 0, Smoke::t_enum|Smoke::tf_stack },	//339
    { "Qt::GlobalColor", 0, Smoke::t_enum|Smoke::tf_stack },	//340
    { "Qt::ImageConversionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//341
    { "Qt::Initialization", 0, Smoke::t_enum|Smoke::tf_stack },	//342
    { "Qt::InputMethodHint", 0, Smoke::t_enum|Smoke::tf_stack },	//343
    { "Qt::InputMethodQuery", 0, Smoke::t_enum|Smoke::tf_stack },	//344
    { "Qt::ItemDataRole", 0, Smoke::t_enum|Smoke::tf_stack },	//345
    { "Qt::ItemFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//346
    { "Qt::ItemSelectionMode", 0, Smoke::t_enum|Smoke::tf_stack },	//347
    { "Qt::Key", 0, Smoke::t_enum|Smoke::tf_stack },	//348
    { "Qt::KeyboardModifier", 0, Smoke::t_enum|Smoke::tf_stack },	//349
    { "Qt::KeyboardModifiers", 0, Smoke::t_uint|Smoke::tf_stack },	//350
    { "Qt::LayoutDirection", 0, Smoke::t_enum|Smoke::tf_stack },	//351
    { "Qt::MaskMode", 0, Smoke::t_enum|Smoke::tf_stack },	//352
    { "Qt::MatchFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//353
    { "Qt::Modifier", 0, Smoke::t_enum|Smoke::tf_stack },	//354
    { "Qt::MouseButton", 0, Smoke::t_enum|Smoke::tf_stack },	//355
    { "Qt::MouseButtons", 0, Smoke::t_uint|Smoke::tf_stack },	//356
    { "Qt::NavigationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//357
    { "Qt::Orientation", 0, Smoke::t_enum|Smoke::tf_stack },	//358
    { "Qt::PenCapStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//359
    { "Qt::PenJoinStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//360
    { "Qt::PenStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//361
    { "Qt::ScrollBarPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//362
    { "Qt::ShortcutContext", 0, Smoke::t_enum|Smoke::tf_stack },	//363
    { "Qt::SizeHint", 0, Smoke::t_enum|Smoke::tf_stack },	//364
    { "Qt::SizeMode", 0, Smoke::t_enum|Smoke::tf_stack },	//365
    { "Qt::SortOrder", 0, Smoke::t_enum|Smoke::tf_stack },	//366
    { "Qt::TextElideMode", 0, Smoke::t_enum|Smoke::tf_stack },	//367
    { "Qt::TextFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//368
    { "Qt::TextFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//369
    { "Qt::TextInteractionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//370
    { "Qt::TileRule", 0, Smoke::t_enum|Smoke::tf_stack },	//371
    { "Qt::TimeSpec", 0, Smoke::t_enum|Smoke::tf_stack },	//372
    { "Qt::ToolBarArea", 0, Smoke::t_enum|Smoke::tf_stack },	//373
    { "Qt::ToolBarAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//374
    { "Qt::ToolButtonStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//375
    { "Qt::TouchPointState", 0, Smoke::t_enum|Smoke::tf_stack },	//376
    { "Qt::TransformationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//377
    { "Qt::UIEffect", 0, Smoke::t_enum|Smoke::tf_stack },	//378
    { "Qt::WidgetAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//379
    { "Qt::WindowFrameSection", 0, Smoke::t_enum|Smoke::tf_stack },	//380
    { "Qt::WindowModality", 0, Smoke::t_enum|Smoke::tf_stack },	//381
    { "Qt::WindowState", 0, Smoke::t_enum|Smoke::tf_stack },	//382
    { "Qt::WindowType", 0, Smoke::t_enum|Smoke::tf_stack },	//383
    { "WId", 0, Smoke::t_ulong|Smoke::tf_stack },	//384
    { "_XEvent*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//385
    { "bool", 0, Smoke::t_bool|Smoke::tf_stack },	//386
    { "const KConfigBase&", 4, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//387
    { "const KConfigBase*", 4, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//388
    { "const KConfigGroup&", 6, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//389
    { "const KConfigGroup*", 6, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//390
    { "const KIcon&", 10, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//391
    { "const KPluginInfo&", 14, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//392
    { "const KSharedPtr<KService>", 0, Smoke::t_voidp|Smoke::tf_stack|Smoke::tf_const },	//393
    { "const KSharedPtr<Plasma::PackageStructure>", 0, Smoke::t_voidp|Smoke::tf_stack|Smoke::tf_const },	//394
    { "const KShortcut&", 19, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//395
    { "const KUrl&", 23, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//396
    { "const KUrl::List", 0, Smoke::t_voidp|Smoke::tf_stack|Smoke::tf_const },	//397
    { "const KUrl::List&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//398
    { "const Plasma::AuthorizationInterface&", 38, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//399
    { "const Plasma::Containment::StyleOption&", 47, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//400
    { "const Plasma::Containment::Type", 46, Smoke::t_enum|Smoke::tf_stack|Smoke::tf_const },	//401
    { "const Plasma::ContainmentActionsPluginsConfig&", 49, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//402
    { "const Plasma::DataEngine::Data&", 0, Smoke::t_voidp|Smoke::tf_stack },	//403
    { "const Plasma::ImmutabilityType", 27, Smoke::t_enum|Smoke::tf_stack|Smoke::tf_const },	//404
    { "const Plasma::ItemStatus", 27, Smoke::t_enum|Smoke::tf_stack|Smoke::tf_const },	//405
    { "const Plasma::MarginEdge", 27, Smoke::t_enum|Smoke::tf_stack|Smoke::tf_const },	//406
    { "const Plasma::MessageButton", 27, Smoke::t_enum|Smoke::tf_stack|Smoke::tf_const },	//407
    { "const Plasma::Package&", 71, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//408
    { "const Plasma::Package*", 71, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//409
    { "const Plasma::PackageMetadata&", 72, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//410
    { "const Plasma::PackageStructure&", 73, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//411
    { "const Plasma::PlotColor&", 74, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//412
    { "const Plasma::QueryMatch&", 77, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//413
    { "const Plasma::QueryMatch*", 77, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//414
    { "const Plasma::RunnerContext&", 79, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//415
    { "const Plasma::RunnerSyntax&", 82, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//416
    { "const Plasma::ToolTipContent&", 100, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//417
    { "const QByteArray&", 115, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//418
    { "const QColor&", 119, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//419
    { "const QEasingCurve&", 125, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//420
    { "const QFlags<Plasma::Applet::BackgroundHint>", 0, Smoke::t_uint|Smoke::tf_stack|Smoke::tf_const },	//421
    { "const QFlags<Plasma::FrameSvg::EnabledBorder>", 0, Smoke::t_uint|Smoke::tf_stack|Smoke::tf_const },	//422
    { "const QFlags<Plasma::MessageButton>", 0, Smoke::t_uint|Smoke::tf_stack|Smoke::tf_const },	//423
    { "const QFlags<Plasma::VideoWidget::Control>", 0, Smoke::t_uint|Smoke::tf_stack|Smoke::tf_const },	//424
    { "const QFlags<Qt::AlignmentFlag>", 0, Smoke::t_uint|Smoke::tf_stack|Smoke::tf_const },	//425
    { "const QFont&", 128, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//426
    { "const QGraphicsItem*", 132, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//427
    { "const QGraphicsView*", 145, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//428
    { "const QHash<QString,QVariant>", 0, Smoke::t_voidp|Smoke::tf_stack|Smoke::tf_const },	//429
    { "const QHash<QString,QVariant>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//430
    { "const QIcon&", 150, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//431
    { "const QImage&", 151, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//432
    { "const QList<Plasma::QueryMatch>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//433
    { "const QList<Plasma::RunnerSyntax>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//434
    { "const QList<QAction*>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//435
    { "const QList<QRect>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//436
    { "const QList<QVariant>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//437
    { "const QList<double>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//438
    { "const QList<unsigned int>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//439
    { "const QList<unsigned long>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//440
    { "const QMetaObject&", 156, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//441
    { "const QMetaObject*", 156, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//442
    { "const QModelIndex&", 158, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//443
    { "const QPainterPath&", 166, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//444
    { "const QPalette&", 167, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//445
    { "const QPixmap&", 168, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//446
    { "const QPoint", 169, Smoke::t_class|Smoke::tf_stack|Smoke::tf_const },	//447
    { "const QPoint&", 169, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//448
    { "const QPointF&", 170, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//449
    { "const QRect&", 172, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//450
    { "const QRectF&", 173, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//451
    { "const QRegExp&", 174, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//452
    { "const QRegion&", 175, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//453
    { "const QSize&", 180, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//454
    { "const QSizeF&", 181, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//455
    { "const QString", 0, Smoke::t_voidp|Smoke::tf_stack|Smoke::tf_const },	//456
    { "const QString&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//457
    { "const QStringList", 0, Smoke::t_voidp|Smoke::tf_stack|Smoke::tf_const },	//458
    { "const QStringList&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//459
    { "const QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//460
    { "const QStyleOptionGraphicsItem&", 185, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//461
    { "const QStyleOptionGraphicsItem*", 185, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//462
    { "const QStyleOptionViewItem&", 186, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//463
    { "const QTextOption&", 189, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//464
    { "const QUrl&", 193, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//465
    { "const QVariant&", 194, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//466
    { "const Qt::ScrollBarPolicy", 0, Smoke::t_enum|Smoke::tf_stack|Smoke::tf_const },	//467
    { "const bool", 0, Smoke::t_bool|Smoke::tf_stack|Smoke::tf_const },	//468
    { "const char*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//469
    { "const double", 0, Smoke::t_double|Smoke::tf_stack|Smoke::tf_const },	//470
    { "const int", 0, Smoke::t_int|Smoke::tf_stack|Smoke::tf_const },	//471
    { "const int&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//472
    { "const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//473
    { "double", 0, Smoke::t_double|Smoke::tf_stack },	//474
    { "double&", 0, Smoke::t_voidp|Smoke::tf_ref },	//475
    { "double*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//476
    { "int", 0, Smoke::t_int|Smoke::tf_stack },	//477
    { "int*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//478
    { "long", 0, Smoke::t_long|Smoke::tf_stack },	//479
    { "long long", 0, Smoke::t_voidp|Smoke::tf_stack },	//480
    { "qint64", 0, Smoke::t_voidp|Smoke::tf_stack },	//481
    { "qreal", 0, Smoke::t_double|Smoke::tf_stack },	//482
    { "uint", 0, Smoke::t_uint|Smoke::tf_stack },	//483
    { "unsigned int", 0, Smoke::t_uint|Smoke::tf_stack },	//484
    { "unsigned long", 0, Smoke::t_ulong|Smoke::tf_stack },	//485
    { "void*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//486
    { "void**", 0, Smoke::t_voidp|Smoke::tf_ptr },	//487
    { "volatile const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//488
};

static Smoke::Index argumentList[] = {
    0,	//0  (void)
    469, 0,	//1  const char*
    265, 477, 487, 0,	//3  QMetaObject::Call, int, void**
    386, 0,	//7  bool
    457, 32, 0,	//9  const QString&, Plasma::AbstractRunner*
    457, 66, 0,	//12  const QString&, Plasma::ComponentType
    201, 0,	//15  QFlags<Plasma::ComponentType>
    484, 0,	//17  unsigned int
    457, 49, 0,	//19  const QString&, Plasma::Applet*
    457, 81, 0,	//22  const QString&, Plasma::DataEngine*
    112, 0,	//25  Plasma::Location
    179, 0,	//27  Plasma::ZoomLevel
    427, 0,	//29  const QGraphicsItem*
    457, 173, 0,	//31  const QString&, Plasma::Wallpaper*
    264, 457, 270, 0,	//34  QMenu*, const QString&, QObject*
    264, 0,	//38  QMenu*
    264, 457, 0,	//40  QMenu*, const QString&
    469, 469, 0,	//43  const char*, const char*
    469, 469, 477, 0,	//46  const char*, const char*, int
    79, 0,	//50  Plasma::Corona*
    309, 49, 0,	//52  QWidget*, Plasma::Applet*
    136, 0,	//55  Plasma::RunnerContext&
    309, 0,	//57  QWidget*
    415, 413, 0,	//59  const Plasma::RunnerContext&, const Plasma::QueryMatch&
    205, 0,	//62  QFlags<Plasma::RunnerContext::Type>
    270, 457, 0,	//64  QObject*, const QString&
    393, 270, 0,	//67  const KSharedPtr<KService>, QObject*
    270, 437, 0,	//70  QObject*, const QList<QVariant>&
    34, 0,	//73  Plasma::AbstractRunner::Speed
    33, 0,	//75  Plasma::AbstractRunner::Priority
    457, 457, 0,	//77  const QString&, const QString&
    413, 0,	//80  const Plasma::QueryMatch&
    457, 431, 457, 0,	//82  const QString&, const QIcon&, const QString&
    457, 183, 0,	//86  const QString&, QAction*
    457, 0,	//89  const QString&
    416, 0,	//91  const Plasma::RunnerSyntax&
    434, 0,	//93  const QList<Plasma::RunnerSyntax>&
    414, 0,	//95  const Plasma::QueryMatch*
    270, 0,	//97  QObject*
    393, 0,	//99  const KSharedPtr<KService>
    69, 0,	//101  Plasma::Containment*
    457, 437, 69, 0,	//103  const QString&, const QList<QVariant>&, Plasma::Containment*
    183, 0,	//107  QAction*
    468, 0,	//109  const bool
    389, 0,	//111  const KConfigGroup&
    457, 437, 0,	//113  const QString&, const QList<QVariant>&
    396, 270, 0,	//116  const KUrl&, QObject*
    396, 0,	//119  const KUrl&
    37, 0,	//121  Plasma::AccessAppletJob*
    119, 0,	//123  Plasma::PackageMetadata
    229, 0,	//125  QGraphicsWidget*
    420, 0,	//127  const QEasingCurve&
    477, 0,	//129  int
    44, 0,	//131  Plasma::Animator::Animation
    46, 0,	//133  Plasma::Animator::Movement
    474, 446, 0,	//135  double, const QPixmap&
    474, 214, 0,	//138  double, QGraphicsItem*
    474, 214, 448, 448, 0,	//141  double, QGraphicsItem*, const QPoint&, const QPoint&
    44, 270, 0,	//146  Plasma::Animator::Animation, QObject*
    457, 270, 0,	//149  const QString&, QObject*
    45, 0,	//152  Plasma::Animator::CurveShape
    214, 46, 448, 0,	//154  QGraphicsItem*, Plasma::Animator::Movement, const QPoint&
    477, 477, 45, 270, 469, 0,	//158  int, int, Plasma::Animator::CurveShape, QObject*, const char*
    477, 446, 0,	//164  int, const QPixmap&
    214, 44, 0,	//167  QGraphicsItem*, Plasma::Animator::Animation
    214, 0,	//170  QGraphicsItem*
    229, 181, 181, 0,	//172  QGraphicsWidget*, QAbstractAnimation::State, QAbstractAnimation::State
    300, 0,	//176  QTimerEvent*
    9, 0,	//178  KConfigGroup&
    428, 450, 0,	//180  const QGraphicsView*, const QRect&
    428, 451, 0,	//183  const QGraphicsView*, const QRectF&
    454, 0,	//186  const QSize&
    454, 310, 0,	//188  const QSize&, Qt::AlignmentFlag
    202, 0,	//191  QFlags<Plasma::Constraint>
    52, 0,	//193  Plasma::AspectRatioMode
    465, 0,	//195  const QUrl&
    457, 386, 0,	//197  const QString&, bool
    459, 0,	//200  const QStringList&
    457, 484, 437, 0,	//202  const QString&, unsigned int, const QList<QVariant>&
    392, 484, 437, 0,	//206  const KPluginInfo&, unsigned int, const QList<QVariant>&
    392, 0,	//210  const KPluginInfo&
    275, 462, 450, 0,	//212  QPainter*, const QStyleOptionGraphicsItem*, const QRect&
    275, 462, 309, 0,	//216  QPainter*, const QStyleOptionGraphicsItem*, QWidget*
    293, 0,	//220  QString
    293, 183, 0,	//222  QString, QAction*
    421, 0,	//225  const QFlags<Plasma::Applet::BackgroundHint>
    395, 0,	//227  const KShortcut&
    94, 0,	//229  Plasma::ExtenderItem*
    214, 457, 484, 0,	//231  QGraphicsItem*, const QString&, unsigned int
    392, 214, 484, 0,	//235  const KPluginInfo&, QGraphicsItem*, unsigned int
    214, 457, 484, 437, 0,	//239  QGraphicsItem*, const QString&, unsigned int, const QList<QVariant>&
    7, 0,	//244  KConfigDialog*
    398, 0,	//246  const KUrl::List&
    364, 0,	//248  Qt::SizeHint
    407, 0,	//250  const Plasma::MessageButton
    49, 0,	//252  Plasma::Applet*
    108, 0,	//254  Plasma::ItemStatus
    105, 0,	//256  Plasma::ImmutabilityType
    404, 0,	//258  const Plasma::ImmutabilityType
    405, 0,	//260  const Plasma::ItemStatus
    48, 457, 0,	//262  Plasma::AnnouncementMethods, const QString&
    386, 457, 0,	//265  bool, const QString&
    431, 457, 423, 0,	//268  const QIcon&, const QString&, const QFlags<Plasma::MessageButton>
    270, 198, 0,	//272  QObject*, QEvent*
    214, 198, 0,	//275  QGraphicsItem*, QEvent*
    224, 0,	//278  QGraphicsSceneMouseEvent*
    210, 0,	//280  QFocusEvent*
    226, 0,	//282  QGraphicsSceneResizeEvent*
    217, 466, 0,	//284  QGraphicsItem::GraphicsItemChange, const QVariant&
    364, 455, 0,	//287  Qt::SizeHint, const QSizeF&
    223, 0,	//290  QGraphicsSceneHoverEvent*
    457, 484, 0,	//292  const QString&, unsigned int
    392, 484, 0,	//295  const KPluginInfo&, unsigned int
    214, 457, 0,	//298  QGraphicsItem*, const QString&
    392, 214, 0,	//301  const KPluginInfo&, QGraphicsItem*
    73, 0,	//304  Plasma::Containment::Type
    56, 0,	//306  Plasma::AuthorizationRule&
    63, 0,	//308  Plasma::ClientPinRequest&
    399, 0,	//310  const Plasma::AuthorizationInterface&
    55, 0,	//312  Plasma::AuthorizationManager::AuthorizationPolicy
    53, 0,	//314  Plasma::AuthorizationInterface*
    59, 0,	//316  Plasma::AuthorizationRule::Policy
    58, 0,	//318  Plasma::AuthorizationRule::Persistence
    200, 0,	//320  QFlags<Plasma::AuthorizationRule::Target>
    57, 0,	//322  Plasma::AuthorizationRule*
    289, 0,	//324  QShowEvent*
    234, 0,	//326  QHideEvent*
    275, 462, 0,	//328  QPainter*, const QStyleOptionGraphicsItem*
    198, 0,	//331  QEvent*
    64, 0,	//333  Plasma::ClientPinRequest*
    5, 0,	//335  KComboBox*
    457, 235, 270, 0,	//337  const QString&, QIODevice*, QObject*
    20, 235, 270, 0,	//341  KSharedPtr<KSharedConfig>, QIODevice*, QObject*
    390, 235, 270, 0,	//345  const KConfigGroup*, QIODevice*, QObject*
    457, 235, 0,	//349  const QString&, QIODevice*
    20, 235, 0,	//352  KSharedPtr<KSharedConfig>, QIODevice*
    390, 235, 0,	//355  const KConfigGroup*, QIODevice*
    457, 457, 457, 0,	//358  const QString&, const QString&, const QString&
    457, 437, 451, 0,	//362  const QString&, const QList<QVariant>&, const QRectF&
    49, 449, 386, 0,	//366  Plasma::Applet*, const QPointF&, bool
    477, 477, 0,	//370  int, int
    449, 448, 0,	//373  const QPointF&, const QPoint&
    447, 0,	//376  const QPoint
    49, 449, 0,	//378  Plasma::Applet*, const QPointF&
    69, 178, 0,	//381  Plasma::Containment*, Plasma::ZoomDirection
    449, 0,	//384  const QPointF&
    477, 477, 69, 0,	//386  int, int, Plasma::Containment*
    78, 0,	//390  Plasma::Context*
    97, 0,	//392  Plasma::FormFactor
    220, 0,	//394  QGraphicsSceneContextMenuEvent*
    240, 0,	//396  QKeyEvent*
    227, 0,	//398  QGraphicsSceneWheelEvent*
    221, 0,	//400  QGraphicsSceneDragDropEvent*
    35, 0,	//402  Plasma::AbstractToolBox*
    400, 0,	//404  const Plasma::Containment::StyleOption&
    461, 0,	//406  const QStyleOptionGraphicsItem&
    172, 0,	//408  Plasma::View*
    69, 457, 437, 0,	//410  Plasma::Containment*, const QString&, const QList<QVariant>&
    69, 392, 437, 0,	//414  Plasma::Containment*, const KPluginInfo&, const QList<QVariant>&
    454, 198, 0,	//418  const QSize&, QEvent*
    280, 279, 0,	//421  QPointF, QPoint
    69, 457, 0,	//424  Plasma::Containment*, const QString&
    69, 392, 0,	//427  Plasma::Containment*, const KPluginInfo&
    402, 0,	//430  const Plasma::ContainmentActionsPluginsConfig&
    198, 457, 0,	//432  QEvent*, const QString&
    208, 355, 457, 0,	//435  QFlags<Qt::KeyboardModifier>, Qt::MouseButton, const QString&
    208, 358, 457, 0,	//439  QFlags<Qt::KeyboardModifier>, Qt::Orientation, const QString&
    477, 477, 457, 437, 0,	//443  int, int, const QString&, const QList<QVariant>&
    427, 454, 0,	//448  const QGraphicsItem*, const QSize&
    427, 454, 310, 0,	//451  const QGraphicsItem*, const QSize&, Qt::AlignmentFlag
    4, 0,	//455  KActionCollection*
    73, 402, 0,	//457  Plasma::Containment::Type, const Plasma::ContainmentActionsPluginsConfig&
    31, 0,	//460  Plasma::AbstractDialogManager*
    387, 0,	//462  const KConfigBase&
    401, 0,	//464  const Plasma::Containment::Type
    9, 247, 0,	//466  KConfigGroup&, QList<Plasma::Containment*>
    44, 44, 0,	//469  Plasma::Animator::Animation, Plasma::Animator::Animation
    44, 457, 0,	//472  Plasma::Animator::Animation, const QString&
    401, 457, 0,	//475  const Plasma::Containment::Type, const QString&
    477, 477, 457, 0,	//478  int, int, const QString&
    457, 466, 0,	//482  const QString&, const QVariant&
    270, 484, 106, 0,	//485  QObject*, unsigned int, Plasma::IntervalAlignment
    457, 403, 0,	//489  const QString&, const Plasma::DataEngine::Data&
    80, 0,	//492  Plasma::DataContainer*
    270, 19, 0,	//494  QObject*, KSharedPtr<KService>
    457, 270, 484, 106, 0,	//497  const QString&, QObject*, unsigned int, Plasma::IntervalAlignment
    457, 457, 466, 0,	//502  const QString&, const QString&, const QVariant&
    457, 430, 0,	//506  const QString&, const QHash<QString,QVariant>&
    457, 270, 484, 0,	//509  const QString&, QObject*, unsigned int
    270, 484, 0,	//513  QObject*, unsigned int
    81, 0,	//516  Plasma::DataEngine*
    87, 477, 0,	//518  Plasma::Delegate::SpecificRoles, int
    87, 0,	//521  Plasma::Delegate::SpecificRoles
    275, 463, 443, 0,	//523  QPainter*, const QStyleOptionViewItem&, const QModelIndex&
    463, 443, 0,	//527  const QStyleOptionViewItem&, const QModelIndex&
    309, 209, 0,	//530  QWidget*, QFlags<Qt::WindowType>
    203, 0,	//533  QFlags<Plasma::Dialog::ResizeCorner>
    477, 477, 477, 477, 0,	//535  int, int, int, int
    478, 478, 478, 478, 0,	//540  int*, int*, int*, int*
    90, 0,	//545  Plasma::Direction
    274, 0,	//547  QPaintEvent*
    287, 0,	//549  QResizeEvent*
    267, 0,	//551  QMouseEvent*
    268, 0,	//553  QMoveEvent*
    448, 0,	//555  const QPoint&
    92, 0,	//557  Plasma::Extender::Appearance
    94, 449, 0,	//559  Plasma::ExtenderItem*, const QPointF&
    91, 484, 0,	//562  Plasma::Extender*, unsigned int
    91, 0,	//565  Plasma::Extender*
    431, 0,	//567  const QIcon&
    91, 449, 0,	//569  Plasma::Extender*, const QPointF&
    93, 0,	//572  Plasma::ExtenderGroup*
    93, 449, 0,	//574  Plasma::ExtenderGroup*, const QPointF&
    225, 0,	//577  QGraphicsSceneMoveEvent*
    426, 0,	//579  const QFont&
    419, 0,	//581  const QColor&
    457, 477, 464, 0,	//583  const QString&, int, const QTextOption&
    446, 477, 207, 0,	//587  const QPixmap&, int, QFlags<Qt::AlignmentFlag>
    457, 477, 0,	//591  const QString&, int
    446, 0,	//594  const QPixmap&
    446, 477, 0,	//596  const QPixmap&, int
    99, 0,	//599  Plasma::Frame::Shadow
    422, 0,	//601  const QFlags<Plasma::FrameSvg::EnabledBorder>
    455, 0,	//603  const QSizeF&
    406, 0,	//605  const Plasma::MarginEdge
    475, 475, 475, 475, 0,	//607  double&, double&, double&, double&
    275, 451, 451, 0,	//612  QPainter*, const QRectF&, const QRectF&
    275, 449, 0,	//616  QPainter*, const QPointF&
    275, 451, 0,	//619  QPainter*, const QRectF&
    275, 0,	//622  QPainter*
    214, 457, 477, 0,	//624  QGraphicsItem*, const QString&, int
    432, 1, 0,	//628  const QImage&, GLenum
    2, 0,	//631  GLuint
    432, 0,	//633  const QImage&
    457, 214, 0,	//635  const QString&, QGraphicsItem*
    431, 457, 214, 0,	//638  const QIcon&, const QString&, QGraphicsItem*
    358, 0,	//642  Qt::Orientation
    470, 0,	//644  const double
    275, 454, 477, 0,	//646  QPainter*, const QSize&, int
    431, 457, 0,	//650  const QIcon&, const QString&
    451, 0,	//653  const QRectF&
    482, 0,	//655  qreal
    283, 0,	//657  QRectF
    207, 0,	//659  QFlags<Qt::AlignmentFlag>
    13, 0,	//661  KLineEdit*
    116, 0,	//663  Plasma::Meter::MeterType
    477, 457, 0,	//665  int, const QString&
    477, 419, 0,	//668  int, const QColor&
    477, 426, 0,	//671  int, const QFont&
    477, 425, 0,	//674  int, const QFlags<Qt::AlignmentFlag>
    472, 0,	//677  const int&
    457, 457, 21, 0,	//679  const QString&, const QString&, KSharedPtr<Plasma::PackageStructure>
    457, 21, 0,	//683  const QString&, KSharedPtr<Plasma::PackageStructure>
    408, 0,	//686  const Plasma::Package&
    469, 457, 0,	//688  const char*, const QString&
    410, 457, 0,	//691  const Plasma::PackageMetadata&, const QString&
    410, 457, 457, 457, 0,	//694  const Plasma::PackageMetadata&, const QString&, const QString&, const QString&
    410, 457, 457, 0,	//699  const Plasma::PackageMetadata&, const QString&, const QString&
    410, 0,	//703  const Plasma::PackageMetadata&
    411, 0,	//705  const Plasma::PackageStructure&
    469, 457, 457, 0,	//707  const char*, const QString&, const QString&
    469, 386, 0,	//711  const char*, bool
    294, 0,	//714  QStringList
    469, 294, 0,	//716  const char*, QStringList
    388, 0,	//719  const KConfigBase*
    6, 0,	//721  KConfigBase*
    412, 0,	//723  const Plasma::PlotColor&
    310, 0,	//725  Qt::AlignmentFlag
    483, 0,	//727  uint
    391, 0,	//729  const KIcon&
    32, 0,	//731  Plasma::AbstractRunner*
    134, 0,	//733  Plasma::QueryMatch::Type
    474, 0,	//735  double
    415, 0,	//737  const Plasma::RunnerContext&
    466, 0,	//739  const QVariant&
    136, 270, 0,	//741  Plasma::RunnerContext&, QObject*
    457, 433, 0,	//744  const QString&, const QList<Plasma::QueryMatch>&
    457, 413, 0,	//747  const QString&, const Plasma::QueryMatch&
    456, 0,	//750  const QString
    458, 0,	//752  const QStringList
    9, 270, 0,	//754  KConfigGroup&, QObject*
    433, 0,	//757  const QList<Plasma::QueryMatch>&
    413, 257, 0,	//759  const Plasma::QueryMatch&, QList<QAction*>*
    471, 0,	//762  const int
    467, 0,	//764  const Qt::ScrollBarPolicy
    181, 181, 0,	//766  QAbstractAnimation::State, QAbstractAnimation::State
    214, 209, 0,	//769  QGraphicsItem*, QFlags<Qt::WindowType>
    457, 437, 270, 0,	//772  const QString&, const QList<QVariant>&, QObject*
    389, 270, 0,	//776  const KConfigGroup&, QObject*
    309, 457, 0,	//779  QWidget*, const QString&
    229, 457, 0,	//782  QGraphicsWidget*, const QString&
    219, 457, 0,	//785  QGraphicsObject*, const QString&
    219, 0,	//788  QGraphicsObject*
    150, 0,	//790  Plasma::ServiceJob*
    148, 0,	//792  Plasma::Service*
    457, 263, 0,	//794  const QString&, QMap<QString,QVariant>&
    235, 0,	//797  QIODevice*
    26, 270, 0,	//799  KUrl, QObject*
    26, 0,	//802  KUrl
    438, 0,	//804  const QList<double>&
    439, 0,	//806  const QList<unsigned int>&
    474, 474, 0,	//808  double, double
    484, 484, 0,	//811  unsigned int, unsigned int
    275, 484, 484, 477, 0,	//814  QPainter*, unsigned int, unsigned int, int
    275, 477, 477, 0,	//819  QPainter*, int, int
    275, 477, 477, 477, 0,	//823  QPainter*, int, int, int
    275, 477, 477, 477, 477, 0,	//828  QPainter*, int, int, int, int
    275, 449, 457, 0,	//834  QPainter*, const QPointF&, const QString&
    275, 477, 477, 457, 0,	//838  QPainter*, int, int, const QString&
    275, 451, 457, 0,	//843  QPainter*, const QRectF&, const QString&
    275, 477, 477, 477, 477, 457, 0,	//847  QPainter*, int, int, int, int, const QString&
    159, 0,	//854  Plasma::Theme*
    154, 457, 214, 209, 0,	//856  Plasma::Svg*, const QString&, QGraphicsItem*, QFlags<Qt::WindowType>
    154, 0,	//861  Plasma::Svg*
    355, 0,	//863  Qt::MouseButton
    154, 457, 0,	//865  Plasma::Svg*, const QString&
    154, 457, 214, 0,	//868  Plasma::Svg*, const QString&, QGraphicsItem*
    477, 431, 457, 218, 0,	//872  int, const QIcon&, const QString&, QGraphicsLayoutItem*
    477, 457, 218, 0,	//877  int, const QString&, QGraphicsLayoutItem*
    431, 457, 218, 0,	//881  const QIcon&, const QString&, QGraphicsLayoutItem*
    457, 218, 0,	//885  const QString&, QGraphicsLayoutItem*
    477, 431, 0,	//888  int, const QIcon&
    477, 386, 0,	//891  int, bool
    477, 431, 457, 0,	//894  int, const QIcon&, const QString&
    362, 0,	//898  Qt::ScrollBarPolicy
    25, 0,	//900  KTextEdit*
    160, 0,	//902  Plasma::Theme::ColorRole
    426, 161, 0,	//904  const QFont&, Plasma::Theme::FontRole
    161, 0,	//907  Plasma::Theme::FontRole
    457, 278, 0,	//909  const QString&, QPixmap&
    457, 278, 484, 0,	//912  const QString&, QPixmap&, unsigned int
    457, 446, 0,	//916  const QString&, const QPixmap&
    457, 446, 457, 0,	//919  const QString&, const QPixmap&, const QString&
    457, 457, 284, 0,	//923  const QString&, const QString&, QRectF&
    457, 457, 451, 0,	//927  const QString&, const QString&, const QRectF&
    417, 0,	//931  const Plasma::ToolTipContent&
    457, 457, 446, 0,	//933  const QString&, const QString&, const QPixmap&
    457, 457, 431, 0,	//937  const QString&, const QString&, const QIcon&
    485, 0,	//941  unsigned long
    440, 0,	//943  const QList<unsigned long>&
    165, 465, 466, 0,	//945  Plasma::ToolTipContent::ResourceType, const QUrl&, const QVariant&
    299, 0,	//949  QTextDocument*
    229, 417, 0,	//951  QGraphicsWidget*, const Plasma::ToolTipContent&
    167, 0,	//954  Plasma::ToolTipManager::State
    384, 356, 350, 448, 0,	//956  WId, Qt::MouseButtons, Qt::KeyboardModifiers, const QPoint&
    457, 356, 350, 448, 0,	//961  const QString&, Qt::MouseButtons, Qt::KeyboardModifiers, const QPoint&
    182, 0,	//966  QAbstractItemModel*
    424, 0,	//968  const QFlags<Plasma::VideoWidget::Control>
    480, 0,	//970  long long
    481, 0,	//972  qint64
    69, 309, 0,	//974  Plasma::Containment*, QWidget*
    69, 477, 309, 0,	//977  Plasma::Containment*, int, QWidget*
    69, 477, 0,	//981  Plasma::Containment*, int
    392, 437, 0,	//984  const KPluginInfo&, const QList<QVariant>&
    173, 0,	//987  Plasma::Wallpaper*
    174, 0,	//989  Plasma::Wallpaper::ResizeMethod
    457, 454, 174, 419, 0,	//991  const QString&, const QSize&, Plasma::Wallpaper::ResizeMethod, const QColor&
    432, 454, 174, 419, 0,	//996  const QImage&, const QSize&, Plasma::Wallpaper::ResizeMethod, const QColor&
    457, 238, 484, 0,	//1001  const QString&, QImage&, unsigned int
    457, 432, 0,	//1005  const QString&, const QImage&
    435, 0,	//1008  const QList<QAction*>&
    457, 454, 0,	//1010  const QString&, const QSize&
    457, 454, 174, 0,	//1013  const QString&, const QSize&, Plasma::Wallpaper::ResizeMethod
    432, 454, 0,	//1017  const QImage&, const QSize&
    432, 454, 174, 0,	//1020  const QImage&, const QSize&, Plasma::Wallpaper::ResizeMethod
    457, 238, 0,	//1024  const QString&, QImage&
    397, 0,	//1027  const KUrl::List
    418, 396, 0,	//1029  const QByteArray&, const KUrl&
    457, 396, 0,	//1032  const QString&, const KUrl&
    307, 0,	//1035  QWebPage*
    418, 0,	//1037  const QByteArray&
    180, 0,	//1039  QAbstractAnimation::Direction
    309, 463, 443, 0,	//1041  QWidget*, const QStyleOptionViewItem&, const QModelIndex&
    309, 443, 0,	//1045  QWidget*, const QModelIndex&
    309, 182, 443, 0,	//1048  QWidget*, QAbstractItemModel*, const QModelIndex&
    198, 182, 463, 443, 0,	//1052  QEvent*, QAbstractItemModel*, const QStyleOptionViewItem&, const QModelIndex&
    427, 347, 0,	//1057  const QGraphicsItem*, Qt::ItemSelectionMode
    444, 347, 0,	//1060  const QPainterPath&, Qt::ItemSelectionMode
    239, 0,	//1063  QInputMethodEvent*
    344, 0,	//1065  Qt::InputMethodQuery
    216, 0,	//1067  QGraphicsItem::Extension
    216, 466, 0,	//1069  QGraphicsItem::Extension, const QVariant&
    222, 0,	//1072  QGraphicsSceneHelpEvent*
    275, 477, 215, 462, 309, 0,	//1074  QPainter*, int, QGraphicsItem**, const QStyleOptionGraphicsItem*, QWidget*
    191, 0,	//1080  QContextMenuEvent*
    192, 0,	//1082  QDragEnterEvent*
    193, 0,	//1084  QDragLeaveEvent*
    194, 0,	//1086  QDragMoveEvent*
    196, 0,	//1088  QDropEvent*
    308, 0,	//1090  QWheelEvent*
    275, 477, 215, 462, 0,	//1092  QPainter*, int, QGraphicsItem**, const QStyleOptionGraphicsItem*
    476, 476, 476, 476, 0,	//1097  double*, double*, double*, double*
    297, 0,	//1102  QStyleOption*
    188, 0,	//1104  QCloseEvent*
    187, 0,	//1106  QChildEvent*
    298, 0,	//1108  QTabletEvent*
    184, 0,	//1110  QActionEvent*
    385, 0,	//1112  _XEvent*
    271, 0,	//1114  QPaintDevice::PaintDeviceMetric
    296, 0,	//1116  QStyle&
    445, 0,	//1118  const QPalette&
};

// Raw list of all methods, using munged names
static const char *methodNames[] = {
    "",	//0
    "AbstractDialogManager",	//1
    "AbstractDialogManager#",	//2
    "AbstractRunner",	//3
    "AbstractRunner#",	//4
    "AbstractRunner#$",	//5
    "AbstractRunner#?",	//6
    "AbstractRunner?",	//7
    "AbstractRunner?#",	//8
    "AbstractToolBox",	//9
    "AbstractToolBox#",	//10
    "AbstractToolBox#?",	//11
    "AcceptingInputStatus",	//12
    "AccessAppletJob",	//13
    "AccessAppletJob#",	//14
    "AccessAppletJob##",	//15
    "ActivateAnimation",	//16
    "Activated",	//17
    "ActiveStatus",	//18
    "AddTool",	//19
    "AlignToHour",	//20
    "AlignToMinute",	//21
    "All",	//22
    "AllBorders",	//23
    "AllConstraints",	//24
    "AllLayers",	//25
    "AllServices",	//26
    "AllUsers",	//27
    "Allow",	//28
    "AnalogMeter",	//29
    "AnchorUnderMouse",	//30
    "AnchorViewCenter",	//31
    "Animation",	//32
    "Animation#",	//33
    "AnimationDriver",	//34
    "AnimationDriver#",	//35
    "AnimatorComponent",	//36
    "AppearAnimation",	//37
    "Applet",	//38
    "Applet#",	//39
    "Applet##",	//40
    "Applet##$",	//41
    "Applet#$",	//42
    "Applet#$$",	//43
    "Applet#$$?",	//44
    "Applet#?",	//45
    "AppletComponent",	//46
    "AppletScript",	//47
    "AppletScript#",	//48
    "AppletType",	//49
    "Application",	//50
    "AuthorizationInterface",	//51
    "AuthorizationInterface#",	//52
    "BackgroundColor",	//53
    "BackgroundLayer",	//54
    "Backward",	//55
    "BarMeterHorizontal",	//56
    "BarMeterVertical",	//57
    "BottomBorder",	//58
    "BottomEdge",	//59
    "BottomMargin",	//60
    "BottomPosedLeftAlignedPopup",	//61
    "BottomPosedRightAlignedPopup",	//62
    "BottomPositioned",	//63
    "BottomUpStacked",	//64
    "BoundingRectViewportUpdate",	//65
    "Box",	//66
    "BspTreeIndex",	//67
    "BusyWidget",	//68
    "BusyWidget#",	//69
    "ButtonBackgroundColor",	//70
    "ButtonCancel",	//71
    "ButtonFocusColor",	//72
    "ButtonHoverColor",	//73
    "ButtonNo",	//74
    "ButtonNone",	//75
    "ButtonOk",	//76
    "ButtonTextColor",	//77
    "ButtonYes",	//78
    "Bytes",	//79
    "CacheBackground",	//80
    "CacheNone",	//81
    "Center",	//82
    "CenterPositioned",	//83
    "CenterTiledResize",	//84
    "CenteredResize",	//85
    "CheckBox",	//86
    "CheckBox#",	//87
    "ColumnTypeRole",	//88
    "ComboBox",	//89
    "ComboBox#",	//90
    "CompletionMatch",	//91
    "ConfigLoader",	//92
    "ConfigLoader##",	//93
    "ConfigLoader###",	//94
    "ConfigLoader$#",	//95
    "ConfigLoader$##",	//96
    "ConfigLoader?#",	//97
    "ConfigLoader?##",	//98
    "ConfigureTool",	//99
    "ConstrainedSquare",	//100
    "Containment",	//101
    "Containment#",	//102
    "Containment#$",	//103
    "Containment#$$",	//104
    "Containment#?",	//105
    "ContainmentActions",	//106
    "ContainmentActions#",	//107
    "ContainmentActions#?",	//108
    "ContainmentActionsPluginsConfig",	//109
    "ContainmentActionsPluginsConfig#",	//110
    "ContainmentComponent",	//111
    "Context",	//112
    "Context#",	//113
    "ContextConstraint",	//114
    "ControlTool",	//115
    "Corona",	//116
    "Corona#",	//117
    "CssResource",	//118
    "Custom",	//119
    "CustomContainment",	//120
    "CustomPanelContainment",	//121
    "DataContainer",	//122
    "DataContainer#",	//123
    "DataEngine",	//124
    "DataEngine#",	//125
    "DataEngine#?",	//126
    "DataEngineComponent",	//127
    "DataEngineScript",	//128
    "DataEngineScript#",	//129
    "Deactivated",	//130
    "Default",	//131
    "DefaultBackground",	//132
    "DefaultControls",	//133
    "DefaultFont",	//134
    "Delegate",	//135
    "Delegate#",	//136
    "DeleteWhenStopped",	//137
    "Deny",	//138
    "DenyAll",	//139
    "Desktop",	//140
    "DesktopContainment",	//141
    "DesktopFont",	//142
    "DesktopZoom",	//143
    "DestructiveTool",	//144
    "DeviceCoordinateCache",	//145
    "Dialog",	//146
    "Dialog#",	//147
    "Dialog#$",	//148
    "Directories",	//149
    "Directory",	//150
    "DisappearAnimation",	//151
    "DontAdjustForAntialiasing",	//152
    "DontClipPainter",	//153
    "DontSavePainterState",	//154
    "Down",	//155
    "DrawChildren",	//156
    "DrawWindowBackground",	//157
    "EaseInCurve",	//158
    "EaseInOutCurve",	//159
    "EaseOutCurve",	//160
    "EditNextItem",	//161
    "EditPreviousItem",	//162
    "EmitResult",	//163
    "ExactMatch",	//164
    "Executable",	//165
    "Extender",	//166
    "Extender#",	//167
    "ExtenderGroup",	//168
    "ExtenderGroup#",	//169
    "ExtenderGroup#$",	//170
    "ExtenderItem",	//171
    "ExtenderItem#",	//172
    "ExtenderItem#$",	//173
    "FadeAnimation",	//174
    "FastSlideInMovement",	//175
    "FastSlideOutMovement",	//176
    "File",	//177
    "FileSystem",	//178
    "Files",	//179
    "FixedSize",	//180
    "FlashingLabel",	//181
    "FlashingLabel#",	//182
    "Floating",	//183
    "FloatingPopup",	//184
    "ForegroundLayer",	//185
    "FormFactorConstraint",	//186
    "Forward",	//187
    "Frame",	//188
    "Frame#",	//189
    "FrameSvg",	//190
    "FrameSvg#",	//191
    "FullScreen",	//192
    "FullViewportUpdate",	//193
    "GLApplet",	//194
    "GLApplet#$$",	//195
    "GLApplet#?",	//196
    "GenericComponent",	//197
    "GeometryAnimation",	//198
    "GroupBox",	//199
    "GroupBox#",	//200
    "GroupZoom",	//201
    "GrowAnimation",	//202
    "HLine",	//203
    "Help",	//204
    "HelperMatch",	//205
    "HighPriority",	//206
    "HighestPriority",	//207
    "HighlightColor",	//208
    "Horizontal",	//209
    "HorizontalFlip",	//210
    "HtmlResource",	//211
    "IconWidget",	//212
    "IconWidget#",	//213
    "IconWidget#$",	//214
    "IconWidget#$#",	//215
    "IconWidget$",	//216
    "IconWidget$#",	//217
    "IgnoreAspectRatio",	//218
    "IgnoreMask",	//219
    "ImageResource",	//220
    "ImmutableConstraint",	//221
    "IndirectPainting",	//222
    "InformationalMatch",	//223
    "Inhibited",	//224
    "InvalidAspectRatioMode",	//225
    "InvalidCredentials",	//226
    "ItemAcceptsInputMethod",	//227
    "ItemBackground",	//228
    "ItemBackground#",	//229
    "ItemChildAddedChange",	//230
    "ItemChildRemovedChange",	//231
    "ItemClipsChildrenToShape",	//232
    "ItemClipsToShape",	//233
    "ItemCoordinateCache",	//234
    "ItemCursorChange",	//235
    "ItemCursorHasChanged",	//236
    "ItemDoesntPropagateOpacityToChildren",	//237
    "ItemEnabledChange",	//238
    "ItemEnabledHasChanged",	//239
    "ItemFlagsChange",	//240
    "ItemFlagsHaveChanged",	//241
    "ItemHasNoContents",	//242
    "ItemIgnoresParentOpacity",	//243
    "ItemIgnoresTransformations",	//244
    "ItemIsFocusScope",	//245
    "ItemIsFocusable",	//246
    "ItemIsMovable",	//247
    "ItemIsPanel",	//248
    "ItemIsSelectable",	//249
    "ItemLayer",	//250
    "ItemMatrixChange",	//251
    "ItemNegativeZStacksBehindParent",	//252
    "ItemOpacityChange",	//253
    "ItemOpacityHasChanged",	//254
    "ItemParentChange",	//255
    "ItemParentHasChanged",	//256
    "ItemPositionChange",	//257
    "ItemPositionHasChanged",	//258
    "ItemRotationChange",	//259
    "ItemRotationHasChanged",	//260
    "ItemScaleChange",	//261
    "ItemScaleHasChanged",	//262
    "ItemSceneChange",	//263
    "ItemSceneHasChanged",	//264
    "ItemScenePositionHasChanged",	//265
    "ItemSelectedChange",	//266
    "ItemSelectedHasChanged",	//267
    "ItemSendsGeometryChanges",	//268
    "ItemSendsScenePositionChanges",	//269
    "ItemStacksBehindParent",	//270
    "ItemStopsClickFocusPropagation",	//271
    "ItemStopsFocusHandling",	//272
    "ItemToolTipChange",	//273
    "ItemToolTipHasChanged",	//274
    "ItemTransformChange",	//275
    "ItemTransformHasChanged",	//276
    "ItemTransformOriginPointChange",	//277
    "ItemTransformOriginPointHasChanged",	//278
    "ItemUsesExtendedStyleOption",	//279
    "ItemVisibleChange",	//280
    "ItemVisibleHasChanged",	//281
    "ItemZValueChange",	//282
    "ItemZValueHasChanged",	//283
    "KeepAspectRatio",	//284
    "KeepWhenStopped",	//285
    "Killable",	//286
    "KilledJobError",	//287
    "Label",	//288
    "Label#",	//289
    "LastAnimation",	//290
    "LastResizeMethod",	//291
    "Left",	//292
    "LeftBorder",	//293
    "LeftEdge",	//294
    "LeftMargin",	//295
    "LeftPosedBottomAlignedPopup",	//296
    "LeftPosedTopAlignedPopup",	//297
    "LeftPositioned",	//298
    "LineEdit",	//299
    "LineEdit#",	//300
    "LineEditType",	//301
    "LinearCurve",	//302
    "LinkColor",	//303
    "LocationConstraint",	//304
    "LowPriority",	//305
    "LowestPriority",	//306
    "MainColumn",	//307
    "MaxpectResize",	//308
    "MediaCenter",	//309
    "Meter",	//310
    "Meter#",	//311
    "MinimalViewportUpdate",	//312
    "MiscTool",	//313
    "MoveAny",	//314
    "MoveDown",	//315
    "MoveLeft",	//316
    "MoveRight",	//317
    "MoveUp",	//318
    "Mutable",	//319
    "NeedsAttentionStatus",	//320
    "NetworkLocation",	//321
    "Next",	//322
    "NoAlignment",	//323
    "NoAnchor",	//324
    "NoAnnouncement",	//325
    "NoBackground",	//326
    "NoBorder",	//327
    "NoBorders",	//328
    "NoCache",	//329
    "NoCapabilities",	//330
    "NoConstraint",	//331
    "NoContainmentType",	//332
    "NoControls",	//333
    "NoCorner",	//334
    "NoDrag",	//335
    "NoError",	//336
    "NoFlip",	//337
    "NoFrame",	//338
    "NoHint",	//339
    "NoIndex",	//340
    "NoMatch",	//341
    "NoViewportUpdate",	//342
    "NonModal",	//343
    "None",	//344
    "NormalPriority",	//345
    "NormalSpeed",	//346
    "NorthEast",	//347
    "NorthWest",	//348
    "OpenFile",	//349
    "OverviewZoom",	//350
    "Package",	//351
    "Package#",	//352
    "Package$$?",	//353
    "Package$?",	//354
    "PackageMetadata",	//355
    "PackageMetadata#",	//356
    "PackageMetadata$",	//357
    "PackageStructure",	//358
    "PackageStructure#",	//359
    "PackageStructure#$",	//360
    "Panel",	//361
    "PanelContainment",	//362
    "PanelModal",	//363
    "PassiveStatus",	//364
    "Pause",	//365
    "Paused",	//366
    "PendularCurve",	//367
    "Persistent",	//368
    "PinPairing",	//369
    "PinRequired",	//370
    "PixmapTransitionAnimation",	//371
    "Plain",	//372
    "Planar",	//373
    "Play",	//374
    "PlayPause",	//375
    "PlotColor",	//376
    "PlotColor#",	//377
    "PopupApplet",	//378
    "PopupApplet#?",	//379
    "PopupConstraint",	//380
    "PossibleMatch",	//381
    "Previous",	//382
    "Progress",	//383
    "PulseAnimation",	//384
    "PushButton",	//385
    "PushButton#",	//386
    "QueryMatch",	//387
    "QueryMatch#",	//388
    "Quietly",	//389
    "RadioButton",	//390
    "RadioButton#",	//391
    "Raised",	//392
    "RevertModelCache",	//393
    "Right",	//394
    "RightBorder",	//395
    "RightEdge",	//396
    "RightMargin",	//397
    "RightPosedBottomAlignedPopup",	//398
    "RightPosedTopAlignedPopup",	//399
    "RightPositioned",	//400
    "RotationAnimation",	//401
    "RotationStackedAnimation",	//402
    "RubberBandDrag",	//403
    "RunnerComponent",	//404
    "RunnerContext",	//405
    "RunnerContext#",	//406
    "RunnerContext##",	//407
    "RunnerManager",	//408
    "RunnerManager#",	//409
    "RunnerManager##",	//410
    "RunnerScript",	//411
    "RunnerScript#",	//412
    "RunnerSyntax",	//413
    "RunnerSyntax#",	//414
    "RunnerSyntax$$",	//415
    "Running",	//416
    "ScaledAndCroppedResize",	//417
    "ScaledResize",	//418
    "SceneModal",	//419
    "ScreenConstraint",	//420
    "ScriptEngine",	//421
    "ScriptEngine#",	//422
    "ScrollBar",	//423
    "ScrollBar#",	//424
    "ScrollHandDrag",	//425
    "ScrollWidget",	//426
    "ScrollWidget#",	//427
    "SecondaryActionColumn",	//428
    "Separator",	//429
    "Separator#",	//430
    "Separator#$",	//431
    "Service",	//432
    "Service#",	//433
    "Service#?",	//434
    "ServiceAccessJob",	//435
    "ServiceAccessJob#",	//436
    "ServiceAccessJob##",	//437
    "Shadow_Mask",	//438
    "Shape_Mask",	//439
    "ShellCommand",	//440
    "SignalPlotter",	//441
    "SignalPlotter#",	//442
    "SizeConstraint",	//443
    "SlideAnimation",	//444
    "SlideInMovement",	//445
    "SlideOutMovement",	//446
    "Slider",	//447
    "Slider#",	//448
    "SlowSpeed",	//449
    "SmallestFont",	//450
    "SmartViewportUpdate",	//451
    "SouthEast",	//452
    "SouthWest",	//453
    "SpinBox",	//454
    "SpinBox#",	//455
    "Square",	//456
    "StandardBackground",	//457
    "StartupCompletedConstraint",	//458
    "Stop",	//459
    "Stopped",	//460
    "StyleOption",	//461
    "StyleOption#",	//462
    "StyledPanel",	//463
    "SubTitleMandatoryRole",	//464
    "SubTitleRole",	//465
    "SubmitModelCache",	//466
    "Sunken",	//467
    "Suspendable",	//468
    "Svg",	//469
    "Svg#",	//470
    "SvgWidget",	//471
    "SvgWidget#",	//472
    "SvgWidget#$",	//473
    "SvgWidget#$#",	//474
    "SvgWidget#$#$",	//475
    "SystemImmutable",	//476
    "TabBar",	//477
    "TabBar#",	//478
    "TextBrowser",	//479
    "TextBrowser#",	//480
    "TextColor",	//481
    "TextEdit",	//482
    "TextEdit#",	//483
    "Theme",	//484
    "Theme#",	//485
    "Theme$",	//486
    "Theme$#",	//487
    "TiledResize",	//488
    "ToolButton",	//489
    "ToolButton#",	//490
    "ToolTipContent",	//491
    "ToolTipContent#",	//492
    "ToolTipContent$$",	//493
    "ToolTipContent$$#",	//494
    "TopBorder",	//495
    "TopDownStacked",	//496
    "TopEdge",	//497
    "TopMargin",	//498
    "TopPosedLeftAlignedPopup",	//499
    "TopPosedRightAlignedPopup",	//500
    "TopPositioned",	//501
    "Transient",	//502
    "TranslucentBackground",	//503
    "TreeView",	//504
    "TreeView#",	//505
    "TrustedCredentials",	//506
    "TrustedOnly",	//507
    "Type",	//508
    "UltimateCredentials",	//509
    "UnknownCredentials",	//510
    "UnknownStatus",	//511
    "UnknownType",	//512
    "Up",	//513
    "UserDefinedError",	//514
    "UserExtension",	//515
    "UserImmutable",	//516
    "UserToolType",	//517
    "UserType",	//518
    "VLine",	//519
    "ValidCredentials",	//520
    "Version",	//521
    "Vertical",	//522
    "VerticalFlip",	//523
    "VideoWidget",	//524
    "VideoWidget#",	//525
    "View",	//526
    "View#",	//527
    "View##",	//528
    "View#$",	//529
    "View#$#",	//530
    "ViewBackgroundColor",	//531
    "ViewFocusColor",	//532
    "ViewHoverColor",	//533
    "ViewTextColor",	//534
    "VisitedLinkColor",	//535
    "Volume",	//536
    "Wallpaper",	//537
    "Wallpaper#",	//538
    "Wallpaper#?",	//539
    "WallpaperComponent",	//540
    "WallpaperScript",	//541
    "WallpaperScript#",	//542
    "WaterAnimation",	//543
    "WebView",	//544
    "WebView#",	//545
    "WinPanel",	//546
    "ZeroconfAnnouncement",	//547
    "ZoomAnimation",	//548
    "ZoomIn",	//549
    "ZoomOut",	//550
    "aboutToFinish",	//551
    "access",	//552
    "access#",	//553
    "access##",	//554
    "accessRemoteApplet",	//555
    "accessRemoteApplet#",	//556
    "action",	//557
    "action$",	//558
    "actionEvent",	//559
    "actions",	//560
    "actionsForMatch",	//561
    "actionsForMatch#",	//562
    "actionsForMatch#?",	//563
    "actionsFromMenu",	//564
    "actionsFromMenu#",	//565
    "actionsFromMenu#$",	//566
    "actionsFromMenu#$#",	//567
    "activate",	//568
    "activated",	//569
    "activated$",	//570
    "activity",	//571
    "activityChanged",	//572
    "activityChanged#",	//573
    "addAction",	//574
    "addAction$",	//575
    "addAction$#",	//576
    "addAction$#$",	//577
    "addApplet",	//578
    "addApplet#",	//579
    "addApplet##",	//580
    "addApplet##$",	//581
    "addApplet$",	//582
    "addApplet$?",	//583
    "addApplet$?#",	//584
    "addAssociatedWidget",	//585
    "addAssociatedWidget#",	//586
    "addContainment",	//587
    "addContainment$",	//588
    "addContainment$?",	//589
    "addContainmentDelayed",	//590
    "addContainmentDelayed$",	//591
    "addContainmentDelayed$?",	//592
    "addDirectoryDefinition",	//593
    "addDirectoryDefinition$$$",	//594
    "addExampleQuery",	//595
    "addExampleQuery$",	//596
    "addFileDefinition",	//597
    "addFileDefinition$$$",	//598
    "addIconAction",	//599
    "addIconAction#",	//600
    "addItem",	//601
    "addItem$",	//602
    "addMatch",	//603
    "addMatch$#",	//604
    "addMatches",	//605
    "addMatches$?",	//606
    "addOffscreenWidget",	//607
    "addOffscreenWidget#",	//608
    "addPlot",	//609
    "addPlot#",	//610
    "addPlugin",	//611
    "addPlugin#$",	//612
    "addPlugin$$$",	//613
    "addResource",	//614
    "addResource$##",	//615
    "addSample",	//616
    "addSample?",	//617
    "addShortcuts",	//618
    "addShortcuts#",	//619
    "addSiblingContainment",	//620
    "addSiblingContainment#",	//621
    "addSource",	//622
    "addSource#",	//623
    "addStandardConfigurationPages",	//624
    "addStandardConfigurationPages#",	//625
    "addSyntax",	//626
    "addSyntax#",	//627
    "addTab",	//628
    "addTab#$",	//629
    "addTab#$#",	//630
    "addTab$",	//631
    "addTab$#",	//632
    "addTool",	//633
    "addTool#",	//634
    "addToolBoxAction",	//635
    "addToolBoxAction#",	//636
    "addUrls",	//637
    "addUrls?",	//638
    "advance",	//639
    "alignment",	//640
    "allowExternalPaths",	//641
    "allowedRunners",	//642
    "alphaMask",	//643
    "animatedHide",	//644
    "animatedHide$",	//645
    "animatedShow",	//646
    "animatedShow$",	//647
    "animationCurve",	//648
    "animationCurve$",	//649
    "animationDuration",	//650
    "animationDuration$",	//651
    "animationFinished",	//652
    "animationFinished#$",	//653
    "animationFps",	//654
    "animationFps$",	//655
    "animationPath",	//656
    "animationPath$",	//657
    "animationStep",	//658
    "animationStep$",	//659
    "appearance",	//660
    "appearanceChanged",	//661
    "append",	//662
    "append$",	//663
    "applet",	//664
    "appletAdded",	//665
    "appletAdded##",	//666
    "appletDestroyed",	//667
    "appletDestroyed#",	//668
    "appletMimeType",	//669
    "appletRemoved",	//670
    "appletRemoved#",	//671
    "appletTransformedByUser",	//672
    "appletTransformedItself",	//673
    "applets",	//674
    "application",	//675
    "aspectRatioMode",	//676
    "associateItem",	//677
    "associateItem#$",	//678
    "associateWidget",	//679
    "associateWidget#$",	//680
    "associatedApplication",	//681
    "associatedApplicationUrls",	//682
    "attachedItems",	//683
    "audioOutput",	//684
    "author",	//685
    "authorizationRequest",	//686
    "authorizationRequest#",	//687
    "autoExpireDelay",	//688
    "autoHide",	//689
    "autoRaise",	//690
    "autohide",	//691
    "availableScreenRegion",	//692
    "availableScreenRegion$",	//693
    "availableScreenRegionChanged",	//694
    "back",	//695
    "backgroundColor",	//696
    "backgroundHints",	//697
    "becameUnused",	//698
    "becameUnused$",	//699
    "bigLock",	//700
    "bindTexture",	//701
    "bindTexture#",	//702
    "bindTexture#?",	//703
    "boundingRect",	//704
    "cacheAllRenderedFrames",	//705
    "calculateNiceRange",	//706
    "category",	//707
    "category#",	//708
    "category$",	//709
    "changeEvent",	//710
    "changeEvent#",	//711
    "changed",	//712
    "changed#",	//713
    "checkForUpdate",	//714
    "checkUsage",	//715
    "childEvent",	//716
    "clear",	//717
    "clearActions",	//718
    "clearApplets",	//719
    "clearCache",	//720
    "clearContainments",	//721
    "clearContent",	//722
    "clearContent#",	//723
    "click",	//724
    "clickMessage",	//725
    "clicked",	//726
    "clicked$",	//727
    "clientPinRequest",	//728
    "clientPinRequest#",	//729
    "closeEvent",	//730
    "closeToolBox",	//731
    "collapseGroup",	//732
    "collidesWithItem",	//733
    "collidesWithPath",	//734
    "color",	//735
    "color$",	//736
    "colorScheme",	//737
    "config",	//738
    "config$",	//739
    "configChanged",	//740
    "configNeedsSaving",	//741
    "configScheme",	//742
    "configSynced",	//743
    "configurationAccepted",	//744
    "configurationRequired",	//745
    "configurationRequired$",	//746
    "configureRequested",	//747
    "configureRequested#",	//748
    "connectAllSources",	//749
    "connectAllSources#",	//750
    "connectAllSources#$",	//751
    "connectAllSources#$$",	//752
    "connectNotify",	//753
    "connectSource",	//754
    "connectSource$#",	//755
    "connectSource$#$",	//756
    "connectSource$#$$",	//757
    "connectVisualization",	//758
    "connectVisualization#$$",	//759
    "constraintsEvent",	//760
    "constraintsEvent$",	//761
    "containerDict",	//762
    "containerForSource",	//763
    "containerForSource$",	//764
    "containment",	//765
    "containmentActions",	//766
    "containmentActions$",	//767
    "containmentActionsConfig",	//768
    "containmentActionsDefaults",	//769
    "containmentActionsDefaults$",	//770
    "containmentActionsTriggers",	//771
    "containmentAdded",	//772
    "containmentAdded#",	//773
    "containmentForScreen",	//774
    "containmentForScreen$",	//775
    "containmentForScreen$$",	//776
    "containmentForScreen$$$",	//777
    "containmentForScreen$$$?",	//778
    "containmentType",	//779
    "containments",	//780
    "contains",	//781
    "containsMultipleImages",	//782
    "contentsHash",	//783
    "contentsPrefix",	//784
    "contentsPrefixPaths",	//785
    "contentsRect",	//786
    "contentsSize",	//787
    "context",	//788
    "contextActions",	//789
    "contextChanged",	//790
    "contextChanged#",	//791
    "contextEvent",	//792
    "contextEvent#",	//793
    "contextMenuEvent",	//794
    "contextMenuEvent#",	//795
    "contextualActions",	//796
    "controlsVisible",	//797
    "corona",	//798
    "count",	//799
    "create",	//800
    "create$",	//801
    "create$#",	//802
    "createActivity",	//803
    "createActivity$",	//804
    "createConfigurationInterface",	//805
    "createConfigurationInterface#",	//806
    "createDefaultService",	//807
    "createDefaultService#",	//808
    "createEditor",	//809
    "createJob",	//810
    "createJob$?",	//811
    "createNewWidgetBrowser",	//812
    "createNewWidgetBrowser#",	//813
    "createPackage",	//814
    "createPackage#$$",	//815
    "createPackage#$$$",	//816
    "createRunOptions",	//817
    "createRunOptions#",	//818
    "currentActivity",	//819
    "currentActivityId",	//820
    "currentChanged",	//821
    "currentChanged$",	//822
    "currentIndex",	//823
    "currentIndexChanged",	//824
    "currentIndexChanged$",	//825
    "currentPixmap",	//826
    "currentPixmap$",	//827
    "currentThemeHasImage",	//828
    "currentThemeHasImage$",	//829
    "currentTime",	//830
    "customAnimation",	//831
    "customAnimation$$$#$",	//832
    "customAnimationFinished",	//833
    "customAnimationFinished$",	//834
    "customCategories",	//835
    "customEvent",	//836
    "darkColor",	//837
    "data",	//838
    "dataEngine",	//839
    "dataEngine$",	//840
    "dataUpdated",	//841
    "dataUpdated$?",	//842
    "defaultContainmentPlugin",	//843
    "defaultPackageRoot",	//844
    "defaultSyntax",	//845
    "defaultTheme",	//846
    "deleteTexture",	//847
    "deleteTexture?",	//848
    "description",	//849
    "desktop",	//850
    "destination",	//851
    "destroy",	//852
    "destroy$",	//853
    "destroyed",	//854
    "destroyed#",	//855
    "detachedItems",	//856
    "devType",	//857
    "dialogManager",	//858
    "dialogResized",	//859
    "dialogVisible",	//860
    "dialogVisible$",	//861
    "directories",	//862
    "disassociateItem",	//863
    "disassociateItem#",	//864
    "disassociateWidget",	//865
    "disassociateWidget#",	//866
    "disconnectNotify",	//867
    "disconnectSource",	//868
    "disconnectSource$#",	//869
    "disconnectVisualization",	//870
    "disconnectVisualization#",	//871
    "doKill",	//872
    "doResume",	//873
    "doSuspend",	//874
    "doubleClicked",	//875
    "dragEnterEvent",	//876
    "dragEnterEvent#",	//877
    "dragLeaveEvent",	//878
    "dragLeaveEvent#",	//879
    "dragMoveEvent",	//880
    "dragMoveEvent#",	//881
    "dragToScroll",	//882
    "drawActionButtonBase",	//883
    "drawActionButtonBase##$",	//884
    "drawAxisText",	//885
    "drawAxisText#$$",	//886
    "drawBackground",	//887
    "drawBackground#$$",	//888
    "drawForeground",	//889
    "drawHorizontalLines",	//890
    "drawHorizontalLines#$$$",	//891
    "drawItems",	//892
    "drawPlots",	//893
    "drawPlots#$$$$",	//894
    "drawThinFrame",	//895
    "drawThinFrame#$$",	//896
    "drawTopBarContents",	//897
    "drawTopBarContents#$$$",	//898
    "drawTopBarFrame",	//899
    "drawTopBarFrame#$$",	//900
    "drawVerticalLines",	//901
    "drawVerticalLines#$$$",	//902
    "drawWallpaper",	//903
    "drawWidget",	//904
    "drawWidget#$$$",	//905
    "dropEvent",	//906
    "dropEvent#",	//907
    "duration",	//908
    "easingCurve",	//909
    "editingFinished",	//910
    "editorEvent",	//911
    "effectiveDesktop",	//912
    "elementAnimationCurve",	//913
    "elementAnimationCurve$",	//914
    "elementAnimationDuration",	//915
    "elementAnimationDuration$",	//916
    "elementAnimationFinished",	//917
    "elementAnimationFinished$",	//918
    "elementAnimationFps",	//919
    "elementAnimationFps$",	//920
    "elementAppear",	//921
    "elementAppear$#",	//922
    "elementAtPoint",	//923
    "elementAtPoint#",	//924
    "elementDisappear",	//925
    "elementDisappear$#",	//926
    "elementID",	//927
    "elementRect",	//928
    "elementRect$",	//929
    "elementSize",	//930
    "elementSize$",	//931
    "email",	//932
    "emptyExtenderMessage",	//933
    "emptyRect",	//934
    "emptyRect##",	//935
    "enableAction",	//936
    "enableAction$$",	//937
    "enabledBorders",	//938
    "enabledBordersForItem",	//939
    "enabledBordersForItem#",	//940
    "enabledChange",	//941
    "engine",	//942
    "engine$",	//943
    "ensureItemVisible",	//944
    "ensureItemVisible#",	//945
    "ensureRectVisible",	//946
    "ensureRectVisible#",	//947
    "enterEvent",	//948
    "entryList",	//949
    "entryList$",	//950
    "errorString",	//951
    "event",	//952
    "event#",	//953
    "eventFilter",	//954
    "eventFilter##",	//955
    "eventToString",	//956
    "eventToString#",	//957
    "exampleQueries",	//958
    "exampleQueriesWithTermDescription",	//959
    "execQuery",	//960
    "execQuery$",	//961
    "execQuery$$",	//962
    "expandGroup",	//963
    "exportLayout",	//964
    "exportLayout#?",	//965
    "extender",	//966
    "extenderItemRestored",	//967
    "extenderItemRestored#",	//968
    "extension",	//969
    "fadeIn",	//970
    "fadeOut",	//971
    "filePath",	//972
    "filePath$",	//973
    "filePath$$",	//974
    "files",	//975
    "findInCache",	//976
    "findInCache$#",	//977
    "findInCache$#$",	//978
    "findInRectsCache",	//979
    "findInRectsCache$$#",	//980
    "findItem",	//981
    "findItem$$",	//982
    "findItemByName",	//983
    "findItemByName$",	//984
    "finished",	//985
    "finished#",	//986
    "firstPositionWidget",	//987
    "flash",	//988
    "flash#",	//989
    "flash#$",	//990
    "flash#$$",	//991
    "flash$",	//992
    "flash$$",	//993
    "flash$$#",	//994
    "flushPendingConstraintsEvents",	//995
    "focusChanged",	//996
    "focusChanged$",	//997
    "focusInEvent",	//998
    "focusInEvent#",	//999
    "focusNextApplet",	//1000
    "focusNextPrevChild",	//1001
    "focusOutEvent",	//1002
    "focusOutEvent#",	//1003
    "focusPreviousApplet",	//1004
    "font",	//1005
    "font$",	//1006
    "fontChange",	//1007
    "fontColor",	//1008
    "fontMetrics",	//1009
    "forceImmediateUpdate",	//1010
    "forceImmediateUpdateOfAllVisualizations",	//1011
    "formFactor",	//1012
    "forward",	//1013
    "framePixmap",	//1014
    "frameShadow",	//1015
    "frameSize",	//1016
    "freeEdges",	//1017
    "freeEdges$",	//1018
    "geometry",	//1019
    "geometryChanged",	//1020
    "getContentsMargins",	//1021
    "getDataEngine",	//1022
    "getMargins",	//1023
    "getMargins$$$$",	//1024
    "getMinimumResizeLimits",	//1025
    "getMinimumResizeLimits$$$$",	//1026
    "getSnapshotImage",	//1027
    "getSnapshotImage$$",	//1028
    "globalConfig",	//1029
    "globalShortcut",	//1030
    "grabKeyboardEvent",	//1031
    "grabMouseEvent",	//1032
    "graphicsWidget",	//1033
    "group",	//1034
    "group$",	//1035
    "groupList",	//1036
    "groups",	//1037
    "hasAuthorization",	//1038
    "hasAuthorization$",	//1039
    "hasConfigurationInterface",	//1040
    "hasElement",	//1041
    "hasElement$",	//1042
    "hasElementPrefix",	//1043
    "hasElementPrefix$",	//1044
    "hasFailedToLaunch",	//1045
    "hasGroup",	//1046
    "hasGroup$",	//1047
    "hasItem",	//1048
    "hasItem$",	//1049
    "hasOverShoot",	//1050
    "hasRunOptions",	//1051
    "hasScaledContents",	//1052
    "hasValidAssociatedApplication",	//1053
    "heightForWidth",	//1054
    "helpEvent",	//1055
    "hide",	//1056
    "hide#",	//1057
    "hideCloseButton",	//1058
    "hideEvent",	//1059
    "hideEvent#",	//1060
    "hidePopup",	//1061
    "highlightWindows",	//1062
    "homepage",	//1063
    "horizontalLinesColor",	//1064
    "horizontalLinesCount",	//1065
    "horizontalScale",	//1066
    "horizontalScrollBarPolicy",	//1067
    "hoverEnterEvent",	//1068
    "hoverEnterEvent#",	//1069
    "hoverLeaveEvent",	//1070
    "hoverLeaveEvent#",	//1071
    "hoverMoveEvent",	//1072
    "hoverMoveEvent#",	//1073
    "html",	//1074
    "icon",	//1075
    "iconSize",	//1076
    "id",	//1077
    "ignoredTypes",	//1078
    "image",	//1079
    "imagePath",	//1080
    "imagePath$",	//1081
    "immutability",	//1082
    "immutabilityChanged",	//1083
    "immutabilityChanged$",	//1084
    "implementationApi",	//1085
    "importLayout",	//1086
    "importLayout#",	//1087
    "inControlArea",	//1088
    "inControlArea#",	//1089
    "infoText",	//1090
    "init",	//1091
    "init#",	//1092
    "initExtenderItem",	//1093
    "initExtenderItem#",	//1094
    "initStyleOption",	//1095
    "initWallpaper",	//1096
    "initWallpaper#",	//1097
    "initializeLayout",	//1098
    "initializeLayout$",	//1099
    "inputMethodEvent",	//1100
    "inputMethodQuery",	//1101
    "insertIntoCache",	//1102
    "insertIntoCache$#",	//1103
    "insertIntoCache$#$",	//1104
    "insertIntoRectsCache",	//1105
    "insertIntoRectsCache$$#",	//1106
    "insertTab",	//1107
    "insertTab$#$",	//1108
    "insertTab$#$#",	//1109
    "insertTab$$",	//1110
    "insertTab$$#",	//1111
    "installPackage",	//1112
    "installPackage$$",	//1113
    "installPackage$$$",	//1114
    "invalidateRectsCache",	//1115
    "invalidateRectsCache$",	//1116
    "invertLayout",	//1117
    "invertLayout$",	//1118
    "invertedLayout",	//1119
    "isAnimating",	//1120
    "isAutoCollapse",	//1121
    "isBusy",	//1122
    "isCheckable",	//1123
    "isChecked",	//1124
    "isClearButtonShown",	//1125
    "isClickable",	//1126
    "isCollapsed",	//1127
    "isContainment",	//1128
    "isDetached",	//1129
    "isDown",	//1130
    "isEmpty",	//1131
    "isEnabled",	//1132
    "isGroup",	//1133
    "isGroupCollapsed",	//1134
    "isIconified",	//1135
    "isInitialized",	//1136
    "isInstantPopup",	//1137
    "isMatchingSuspended",	//1138
    "isObscuredBy",	//1139
    "isOperationEnabled",	//1140
    "isOperationEnabled$",	//1141
    "isPassivePopup",	//1142
    "isPluginVersionCompatible",	//1143
    "isPluginVersionCompatible$",	//1144
    "isPopupShowing",	//1145
    "isPreviewing",	//1146
    "isPublished",	//1147
    "isReadOnly",	//1148
    "isRegisteredAsDragHandle",	//1149
    "isRegisteredAsDragHandle#",	//1150
    "isRequired",	//1151
    "isRequired$",	//1152
    "isRunning",	//1153
    "isShowing",	//1154
    "isStorageEnabled",	//1155
    "isTabBarShown",	//1156
    "isTabHighlighted",	//1157
    "isTabHighlighted$",	//1158
    "isToolBoxOpen",	//1159
    "isTransient",	//1160
    "isUserConfiguring",	//1161
    "isUserResizing",	//1162
    "isUsingRenderingCache",	//1163
    "isValid",	//1164
    "isVisible",	//1165
    "isVisible#",	//1166
    "isWallpaperEnabled",	//1167
    "item",	//1168
    "item$",	//1169
    "itemActivated",	//1170
    "itemActivated$#",	//1171
    "itemAddedEvent",	//1172
    "itemAddedEvent#",	//1173
    "itemAddedEvent##",	//1174
    "itemAppear",	//1175
    "itemAppear$#",	//1176
    "itemAttached",	//1177
    "itemAttached#",	//1178
    "itemChange",	//1179
    "itemChange$#",	//1180
    "itemDetached",	//1181
    "itemDetached#",	//1182
    "itemDisappear",	//1183
    "itemDisappear$#",	//1184
    "itemHoverEnterEvent",	//1185
    "itemHoverEnterEvent#",	//1186
    "itemHoverLeaveEvent",	//1187
    "itemHoverLeaveEvent#",	//1188
    "itemHoverMoveEvent",	//1189
    "itemHoverMoveEvent##",	//1190
    "itemRemovedEvent",	//1191
    "itemRemovedEvent#",	//1192
    "itemSlideIn",	//1193
    "itemSlideIn$###",	//1194
    "itemSlideOut",	//1195
    "itemSlideOut$###",	//1196
    "items",	//1197
    "keyPressEvent",	//1198
    "keyPressEvent#",	//1199
    "keyReleaseEvent",	//1200
    "keyReleaseEvent#",	//1201
    "keywords",	//1202
    "kill",	//1203
    "knownLanguages",	//1204
    "knownLanguages$",	//1205
    "label",	//1206
    "label$",	//1207
    "labelAlignment",	//1208
    "labelAlignment$",	//1209
    "labelColor",	//1210
    "labelColor$",	//1211
    "labelFont",	//1212
    "labelFont$",	//1213
    "labelRect",	//1214
    "labelRect$",	//1215
    "languageChange",	//1216
    "lastDesktop",	//1217
    "lastPositionWidget",	//1218
    "lastScreen",	//1219
    "lastValue",	//1220
    "lastValue$",	//1221
    "lastValueAsString",	//1222
    "lastValueAsString$",	//1223
    "launchQuery",	//1224
    "launchQuery$",	//1225
    "launchQuery$$",	//1226
    "layoutContainments",	//1227
    "leaveEvent",	//1228
    "license",	//1229
    "linkActivated",	//1230
    "linkActivated$",	//1231
    "linkActivated$$$#",	//1232
    "linkHovered",	//1233
    "linkHovered$",	//1234
    "listActivities",	//1235
    "listAllEngines",	//1236
    "listAllEngines$",	//1237
    "listAppletInfo",	//1238
    "listAppletInfo$",	//1239
    "listAppletInfo$$",	//1240
    "listAppletInfoForMimetype",	//1241
    "listAppletInfoForMimetype$",	//1242
    "listAppletInfoForUrl",	//1243
    "listAppletInfoForUrl#",	//1244
    "listCachedRectKeys",	//1245
    "listCachedRectKeys$",	//1246
    "listCategories",	//1247
    "listCategories$",	//1248
    "listCategories$$",	//1249
    "listContainmentActionsInfo",	//1250
    "listContainmentTypes",	//1251
    "listContainments",	//1252
    "listContainments$",	//1253
    "listContainments$$",	//1254
    "listContainmentsForMimetype",	//1255
    "listContainmentsForMimetype$",	//1256
    "listContainmentsOfType",	//1257
    "listContainmentsOfType$",	//1258
    "listContainmentsOfType$$",	//1259
    "listContainmentsOfType$$$",	//1260
    "listEngineInfo",	//1261
    "listEngineInfo$",	//1262
    "listEngineInfoByCategory",	//1263
    "listEngineInfoByCategory$",	//1264
    "listEngineInfoByCategory$$",	//1265
    "listInstalled",	//1266
    "listInstalled$",	//1267
    "listInstalledPaths",	//1268
    "listInstalledPaths$",	//1269
    "listRenderingModes",	//1270
    "listRunnerInfo",	//1271
    "listRunnerInfo$",	//1272
    "listThemeInfo",	//1273
    "listToolBoxInfo",	//1274
    "listToolBoxInfo$",	//1275
    "listWallpaperInfo",	//1276
    "listWallpaperInfo$",	//1277
    "listWallpaperInfoForMimetype",	//1278
    "listWallpaperInfoForMimetype$",	//1279
    "listWallpaperInfoForMimetype$$",	//1280
    "load",	//1281
    "load#",	//1282
    "load##",	//1283
    "load##?",	//1284
    "load#$",	//1285
    "load#$?",	//1286
    "load#?",	//1287
    "load$",	//1288
    "load$#",	//1289
    "load$$",	//1290
    "load$$?",	//1291
    "load$?",	//1292
    "load$?#",	//1293
    "loadAnimationFromPackage",	//1294
    "loadAnimationFromPackage$#",	//1295
    "loadDefaultLayout",	//1296
    "loadEngine",	//1297
    "loadEngine$",	//1298
    "loadFinished",	//1299
    "loadFinished$",	//1300
    "loadLayout",	//1301
    "loadLayout$",	//1302
    "loadPlasmoid",	//1303
    "loadPlasmoid$",	//1304
    "loadPlasmoid$$",	//1305
    "loadPlasmoid$$?",	//1306
    "loadProgress",	//1307
    "loadProgress$",	//1308
    "loadRunner",	//1309
    "loadRunner$",	//1310
    "loadRunner?",	//1311
    "loadScriptEngine",	//1312
    "loadScriptEngine$#",	//1313
    "location",	//1314
    "locationChanged",	//1315
    "locationChanged#",	//1316
    "locationToDirection",	//1317
    "locationToDirection$",	//1318
    "locationToInverseDirection",	//1319
    "locationToInverseDirection$",	//1320
    "lostContainment",	//1321
    "lower",	//1322
    "mainFrame",	//1323
    "mainScript",	//1324
    "mainText",	//1325
    "makeCurrent",	//1326
    "mapAnimation",	//1327
    "mapAnimation$$",	//1328
    "mapFromView",	//1329
    "mapFromView##",	//1330
    "mapToView",	//1331
    "mapToView##",	//1332
    "marginSize",	//1333
    "marginSize$",	//1334
    "mask",	//1335
    "match",	//1336
    "match#",	//1337
    "match$",	//1338
    "matchSessionComplete",	//1339
    "matches",	//1340
    "matchesChanged",	//1341
    "matchesChanged?",	//1342
    "matchingSuspended",	//1343
    "matchingSuspended$",	//1344
    "maxSourceCount",	//1345
    "maximum",	//1346
    "maximumIconSize",	//1347
    "mediaObject",	//1348
    "messageButtonPressed",	//1349
    "messageButtonPressed$",	//1350
    "metaObject",	//1351
    "metadata",	//1352
    "meterType",	//1353
    "metric",	//1354
    "mimeDataForMatch",	//1355
    "mimeDataForMatch#",	//1356
    "mimeDataForMatch$",	//1357
    "mimeType",	//1358
    "mimetypes",	//1359
    "mimetypes$",	//1360
    "minimum",	//1361
    "minimumIconSize",	//1362
    "minimumPollingInterval",	//1363
    "minimumSizeHint",	//1364
    "model",	//1365
    "mouseDoubleClickEvent",	//1366
    "mouseDoubleClickEvent#",	//1367
    "mouseMoveEvent",	//1368
    "mouseMoveEvent#",	//1369
    "mousePressEvent",	//1370
    "mousePressEvent#",	//1371
    "mouseReleaseEvent",	//1372
    "mouseReleaseEvent#",	//1373
    "moveEvent",	//1374
    "moveEvent#",	//1375
    "moveItem",	//1376
    "moveItem#$#",	//1377
    "movementAnimationCurve",	//1378
    "movementAnimationCurve$",	//1379
    "movementAnimationDuration",	//1380
    "movementAnimationDuration$",	//1381
    "movementAnimationFps",	//1382
    "movementAnimationFps$",	//1383
    "movementFinished",	//1384
    "movementFinished#",	//1385
    "name",	//1386
    "name$",	//1387
    "nativeWidget",	//1388
    "needsPreviewDuringConfiguration",	//1389
    "needsToBeStored",	//1390
    "newStatus",	//1391
    "newStatus$",	//1392
    "newWidgetBrowserFinished",	//1393
    "nextRequested",	//1394
    "numDisplayLines",	//1395
    "numScreens",	//1396
    "offscreenWidgets",	//1397
    "opaqueArea",	//1398
    "openToolBox",	//1399
    "operationDescription",	//1400
    "operationDescription$",	//1401
    "operationNames",	//1402
    "operationsChanged",	//1403
    "operator!=",	//1404
    "operator!=#",	//1405
    "operator<",	//1406
    "operator<#",	//1407
    "operator=",	//1408
    "operator=#",	//1409
    "operator==",	//1410
    "operator==#",	//1411
    "orientation",	//1412
    "overflowBordersVisible",	//1413
    "package",	//1414
    "packageStructure",	//1415
    "packageStructure#",	//1416
    "packageStructure$$",	//1417
    "page",	//1418
    "pageStep",	//1419
    "paint",	//1420
    "paint##",	//1421
    "paint###",	//1422
    "paint##$",	//1423
    "paint#$$",	//1424
    "paint#$$$",	//1425
    "paint#$$$$",	//1426
    "paint#$$$$$",	//1427
    "paintEngine",	//1428
    "paintEvent",	//1429
    "paintEvent#",	//1430
    "paintFrame",	//1431
    "paintFrame#",	//1432
    "paintFrame##",	//1433
    "paintFrame###",	//1434
    "paintGLInterface",	//1435
    "paintGLInterface##",	//1436
    "paintInterface",	//1437
    "paintInterface###",	//1438
    "paintWindowFrame",	//1439
    "paintWindowFrame###",	//1440
    "paletteChange",	//1441
    "parametersFromDescription",	//1442
    "parametersFromDescription#",	//1443
    "paste",	//1444
    "paste##",	//1445
    "path",	//1446
    "path$",	//1447
    "pathChanged",	//1448
    "pause",	//1449
    "performMatch",	//1450
    "performMatch#",	//1451
    "persistence",	//1452
    "pin",	//1453
    "pixmap",	//1454
    "pixmap$",	//1455
    "play",	//1456
    "plotColors",	//1457
    "pluginName",	//1458
    "policy",	//1459
    "polishEvent",	//1460
    "popupAlignment",	//1461
    "popupEvent",	//1462
    "popupEvent$",	//1463
    "popupIcon",	//1464
    "popupPlacement",	//1465
    "popupPosition",	//1466
    "popupPosition#",	//1467
    "popupPosition##",	//1468
    "popupPosition##$",	//1469
    "popupPosition#$",	//1470
    "preferredIconSize",	//1471
    "preferredToolBoxPlugin",	//1472
    "preferredToolBoxPlugin$",	//1473
    "prefix",	//1474
    "prepare",	//1475
    "pressed",	//1476
    "pressed$",	//1477
    "previousRequested",	//1478
    "priority",	//1479
    "property",	//1480
    "property$",	//1481
    "propertyChange",	//1482
    "publish",	//1483
    "publish$$",	//1484
    "qt_metacall",	//1485
    "qt_metacall$$?",	//1486
    "qt_metacast",	//1487
    "qt_metacast$",	//1488
    "query",	//1489
    "query$",	//1490
    "queryFinished",	//1491
    "raise",	//1492
    "read",	//1493
    "read#",	//1494
    "read$",	//1495
    "readConfig",	//1496
    "readyForRemoteAccess",	//1497
    "rectAfterSubTitle",	//1498
    "rectAfterSubTitle##",	//1499
    "rectAfterTitle",	//1500
    "rectAfterTitle##",	//1501
    "registerAsDragHandle",	//1502
    "registerAsDragHandle#",	//1503
    "registerOperationsScheme",	//1504
    "registerPackage",	//1505
    "registerPackage#$",	//1506
    "registerResources",	//1507
    "registerResources#",	//1508
    "registerScrollingManager",	//1509
    "registerScrollingManager#",	//1510
    "registerWidget",	//1511
    "registerWidget#",	//1512
    "releaseRectsCache",	//1513
    "releaseRectsCache$",	//1514
    "releaseVisualFocus",	//1515
    "released",	//1516
    "relevance",	//1517
    "reload",	//1518
    "reloadConfiguration",	//1519
    "remainingTime",	//1520
    "remoteAppletAnnounced",	//1521
    "remoteAppletAnnounced#",	//1522
    "remoteAppletUnannounced",	//1523
    "remoteAppletUnannounced#",	//1524
    "remoteApplets",	//1525
    "remoteLocation",	//1526
    "remove",	//1527
    "remove#",	//1528
    "removeAction",	//1529
    "removeAction$",	//1530
    "removeAllData",	//1531
    "removeAllData$",	//1532
    "removeAllSources",	//1533
    "removeAssociatedWidget",	//1534
    "removeAssociatedWidget#",	//1535
    "removeData",	//1536
    "removeData$$",	//1537
    "removeDefinition",	//1538
    "removeDefinition$",	//1539
    "removeIconAction",	//1540
    "removeIconAction#",	//1541
    "removeMatch",	//1542
    "removeMatch$",	//1543
    "removeMatches",	//1544
    "removeMatches#",	//1545
    "removeMatches?",	//1546
    "removeOffscreenWidget",	//1547
    "removeOffscreenWidget#",	//1548
    "removePlot",	//1549
    "removePlot$",	//1550
    "removeSource",	//1551
    "removeSource$",	//1552
    "removeTab",	//1553
    "removeTab$",	//1554
    "removeTool",	//1555
    "removeTool#",	//1556
    "removeToolBoxAction",	//1557
    "removeToolBoxAction#",	//1558
    "render",	//1559
    "render##",	//1560
    "render##$",	//1561
    "render##$#",	//1562
    "render$#",	//1563
    "render$#$",	//1564
    "render$#$#",	//1565
    "renderCompleted",	//1566
    "renderCompleted#",	//1567
    "renderHintsChanged",	//1568
    "renderingMode",	//1569
    "reorderPlots",	//1570
    "reorderPlots?",	//1571
    "repaintNeeded",	//1572
    "reposition",	//1573
    "requestConfigSync",	//1574
    "requireConfigSync",	//1575
    "requiredDirectories",	//1576
    "requiredFiles",	//1577
    "requiredVersion",	//1578
    "reset",	//1579
    "resize",	//1580
    "resize#",	//1581
    "resize$$",	//1582
    "resizeCorners",	//1583
    "resizeEvent",	//1584
    "resizeEvent#",	//1585
    "resizeFrame",	//1586
    "resizeFrame#",	//1587
    "resizeMethodHint",	//1588
    "restore",	//1589
    "restore#",	//1590
    "restoreContents",	//1591
    "restoreContents#",	//1592
    "returnPressed",	//1593
    "returnToSource",	//1594
    "roleMapping",	//1595
    "roleMapping$",	//1596
    "run",	//1597
    "run#",	//1598
    "run##",	//1599
    "run$",	//1600
    "runAssociatedApplication",	//1601
    "runner",	//1602
    "runner$",	//1603
    "runnerName",	//1604
    "runnerName$",	//1605
    "runners",	//1606
    "save",	//1607
    "save#",	//1608
    "saveContents",	//1609
    "saveContents#",	//1610
    "saveLayout",	//1611
    "saveLayout$",	//1612
    "saveState",	//1613
    "saveState#",	//1614
    "scale",	//1615
    "scale$",	//1616
    "scaledBy",	//1617
    "scalingFactor",	//1618
    "scalingFactor$",	//1619
    "sceneEvent",	//1620
    "sceneEventFilter",	//1621
    "sceneEventFilter##",	//1622
    "sceneRectAboutToChange",	//1623
    "sceneRectChanged",	//1624
    "scheduleSourcesUpdated",	//1625
    "screen",	//1626
    "screenChanged",	//1627
    "screenChanged$$#",	//1628
    "screenGeometry",	//1629
    "screenGeometry$",	//1630
    "screenOwnerChanged",	//1631
    "screenOwnerChanged$$#",	//1632
    "screenRect",	//1633
    "scrollContentsBy",	//1634
    "scrollPosition",	//1635
    "scrollStateChanged",	//1636
    "scrollStateChanged#$$",	//1637
    "scrollStateChanged$$",	//1638
    "searchContext",	//1639
    "searchPath",	//1640
    "searchPath$",	//1641
    "searchTermDescription",	//1642
    "seek",	//1643
    "seek$",	//1644
    "selectedAction",	//1645
    "self",	//1646
    "service",	//1647
    "serviceForSource",	//1648
    "serviceForSource$",	//1649
    "serviceName",	//1650
    "servicePrefix",	//1651
    "serviceQuery",	//1652
    "serviceQuery$",	//1653
    "serviceQuery$$",	//1654
    "serviceReady",	//1655
    "serviceReady#",	//1656
    "serviceType",	//1657
    "setAction",	//1658
    "setAction#",	//1659
    "setActivity",	//1660
    "setActivity$",	//1661
    "setAlignment",	//1662
    "setAlignment$",	//1663
    "setAllowExternalPaths",	//1664
    "setAllowExternalPaths$",	//1665
    "setAllowedRunners",	//1666
    "setAllowedRunners?",	//1667
    "setAppearance",	//1668
    "setAppearance$",	//1669
    "setApplet",	//1670
    "setApplet#",	//1671
    "setAppletMimeType",	//1672
    "setAppletMimeType$",	//1673
    "setApplication",	//1674
    "setApplication$",	//1675
    "setAspectRatioMode",	//1676
    "setAspectRatioMode$",	//1677
    "setAssociatedApplication",	//1678
    "setAssociatedApplication$",	//1679
    "setAssociatedApplicationUrls",	//1680
    "setAssociatedApplicationUrls?",	//1681
    "setAuthor",	//1682
    "setAuthor$",	//1683
    "setAuthorizationInterface",	//1684
    "setAuthorizationInterface#",	//1685
    "setAuthorizationPolicy",	//1686
    "setAuthorizationPolicy$",	//1687
    "setAutoCollapse",	//1688
    "setAutoCollapse$",	//1689
    "setAutoExpireDelay",	//1690
    "setAutoExpireDelay$",	//1691
    "setAutoHide",	//1692
    "setAutoHide$",	//1693
    "setAutoRaise",	//1694
    "setAutoRaise$",	//1695
    "setAutohide",	//1696
    "setAutohide$",	//1697
    "setBackgroundColor",	//1698
    "setBackgroundColor#",	//1699
    "setBackgroundHints",	//1700
    "setBackgroundHints$",	//1701
    "setBoundingRect",	//1702
    "setBoundingRect#",	//1703
    "setBusy",	//1704
    "setBusy$",	//1705
    "setCacheAllRenderedFrames",	//1706
    "setCacheAllRenderedFrames$",	//1707
    "setCacheLimit",	//1708
    "setCacheLimit$",	//1709
    "setCategory",	//1710
    "setCategory$",	//1711
    "setCheckable",	//1712
    "setCheckable$",	//1713
    "setChecked",	//1714
    "setChecked$",	//1715
    "setClearButtonShown",	//1716
    "setClearButtonShown$",	//1717
    "setClickMessage",	//1718
    "setClickMessage$",	//1719
    "setClickable",	//1720
    "setClickable$",	//1721
    "setCollapsed",	//1722
    "setCollapsed$",	//1723
    "setColor",	//1724
    "setColor#",	//1725
    "setConfigurationRequired",	//1726
    "setConfigurationRequired$",	//1727
    "setConfigurationRequired$$",	//1728
    "setContainment",	//1729
    "setContainment#",	//1730
    "setContainmentActions",	//1731
    "setContainmentActions$$",	//1732
    "setContainmentActionsDefaults",	//1733
    "setContainmentActionsDefaults$#",	//1734
    "setContainmentType",	//1735
    "setContainmentType$",	//1736
    "setContainsMultipleImages",	//1737
    "setContainsMultipleImages$",	//1738
    "setContent",	//1739
    "setContent##",	//1740
    "setContentsPrefix",	//1741
    "setContentsPrefix$",	//1742
    "setContentsPrefixPaths",	//1743
    "setContentsPrefixPaths?",	//1744
    "setContextActions",	//1745
    "setContextActions?",	//1746
    "setContextualActions",	//1747
    "setContextualActions?",	//1748
    "setControlsVisible",	//1749
    "setControlsVisible$",	//1750
    "setCurrentActivity",	//1751
    "setCurrentActivity$",	//1752
    "setCurrentActivityId",	//1753
    "setCurrentActivityId$",	//1754
    "setCurrentIndex",	//1755
    "setCurrentIndex$",	//1756
    "setCustomCategories",	//1757
    "setCustomCategories?",	//1758
    "setDarkColor",	//1759
    "setDarkColor#",	//1760
    "setData",	//1761
    "setData#",	//1762
    "setData$#",	//1763
    "setData$$#",	//1764
    "setData$?",	//1765
    "setDataEngine",	//1766
    "setDataEngine#",	//1767
    "setDefaultContainmentPlugin",	//1768
    "setDefaultContainmentPlugin$",	//1769
    "setDefaultMimetypes",	//1770
    "setDefaultMimetypes?",	//1771
    "setDefaultPackageRoot",	//1772
    "setDefaultPackageRoot$",	//1773
    "setDefaultService",	//1774
    "setDefaultService$",	//1775
    "setDefaultSyntax",	//1776
    "setDefaultSyntax#",	//1777
    "setDefaults",	//1778
    "setDescription",	//1779
    "setDescription$",	//1780
    "setDestination",	//1781
    "setDestination$",	//1782
    "setDialogManager",	//1783
    "setDialogManager#",	//1784
    "setDown",	//1785
    "setDown$",	//1786
    "setDragToScroll",	//1787
    "setDragToScroll$",	//1788
    "setDrawBackground",	//1789
    "setDrawBackground$",	//1790
    "setDrawWallpaper",	//1791
    "setDrawWallpaper$",	//1792
    "setDuration",	//1793
    "setDuration$",	//1794
    "setEasingCurve",	//1795
    "setEasingCurve#",	//1796
    "setEditorData",	//1797
    "setElementID",	//1798
    "setElementID$",	//1799
    "setElementPrefix",	//1800
    "setElementPrefix$",	//1801
    "setEmail",	//1802
    "setEmail$",	//1803
    "setEmptyExtenderMessage",	//1804
    "setEmptyExtenderMessage$",	//1805
    "setEnabled",	//1806
    "setEnabled$",	//1807
    "setEnabledBorders",	//1808
    "setEnabledBorders$",	//1809
    "setExtender",	//1810
    "setExtender#",	//1811
    "setExtender##",	//1812
    "setExtension",	//1813
    "setFailedToLaunch",	//1814
    "setFailedToLaunch$",	//1815
    "setFailedToLaunch$$",	//1816
    "setFirstPositionWidget",	//1817
    "setFirstPositionWidget#",	//1818
    "setFont",	//1819
    "setFont#",	//1820
    "setFont#$",	//1821
    "setFontColor",	//1822
    "setFontColor#",	//1823
    "setFormFactor",	//1824
    "setFormFactor$",	//1825
    "setFrameShadow",	//1826
    "setFrameShadow$",	//1827
    "setGeometry",	//1828
    "setGeometry#",	//1829
    "setGlobalShortcut",	//1830
    "setGlobalShortcut#",	//1831
    "setGraphicsWidget",	//1832
    "setGraphicsWidget#",	//1833
    "setGroup",	//1834
    "setGroup#",	//1835
    "setGroup##",	//1836
    "setGroupCollapsed",	//1837
    "setGroupCollapsed$",	//1838
    "setHasConfigurationInterface",	//1839
    "setHasConfigurationInterface$",	//1840
    "setHasRunOptions",	//1841
    "setHasRunOptions$",	//1842
    "setHighlightWindows",	//1843
    "setHighlightWindows$",	//1844
    "setHorizontalLinesColor",	//1845
    "setHorizontalLinesColor#",	//1846
    "setHorizontalLinesCount",	//1847
    "setHorizontalLinesCount$",	//1848
    "setHorizontalScale",	//1849
    "setHorizontalScale$",	//1850
    "setHorizontalScrollBarPolicy",	//1851
    "setHorizontalScrollBarPolicy$",	//1852
    "setHtml",	//1853
    "setHtml#",	//1854
    "setHtml##",	//1855
    "setHtml$",	//1856
    "setHtml$#",	//1857
    "setIcon",	//1858
    "setIcon#",	//1859
    "setIcon$",	//1860
    "setId",	//1861
    "setId$",	//1862
    "setIgnoredTypes",	//1863
    "setIgnoredTypes$",	//1864
    "setImage",	//1865
    "setImage#",	//1866
    "setImage$",	//1867
    "setImage$$",	//1868
    "setImagePath",	//1869
    "setImagePath$",	//1870
    "setImmutability",	//1871
    "setImmutability$",	//1872
    "setImplementationApi",	//1873
    "setImplementationApi$",	//1874
    "setInfoText",	//1875
    "setInfoText$",	//1876
    "setInitialPixmap",	//1877
    "setInitialPixmap$#",	//1878
    "setInstantPopup",	//1879
    "setInstantPopup$",	//1880
    "setKeywords",	//1881
    "setKeywords?",	//1882
    "setLabel",	//1883
    "setLabel$",	//1884
    "setLabel$$",	//1885
    "setLabelAlignment",	//1886
    "setLabelAlignment$$",	//1887
    "setLabelColor",	//1888
    "setLabelColor$#",	//1889
    "setLabelFont",	//1890
    "setLabelFont$#",	//1891
    "setLastPositionWidget",	//1892
    "setLastPositionWidget#",	//1893
    "setLicense",	//1894
    "setLicense$",	//1895
    "setLocation",	//1896
    "setLocation$",	//1897
    "setMainText",	//1898
    "setMainText$",	//1899
    "setMaxSourceCount",	//1900
    "setMaxSourceCount$",	//1901
    "setMaximum",	//1902
    "setMaximum$",	//1903
    "setMaximumIconSize",	//1904
    "setMaximumIconSize#",	//1905
    "setMeterType",	//1906
    "setMeterType$",	//1907
    "setMimetypes",	//1908
    "setMimetypes$?",	//1909
    "setMinimum",	//1910
    "setMinimum$",	//1911
    "setMinimumIconSize",	//1912
    "setMinimumIconSize#",	//1913
    "setMinimumPollingInterval",	//1914
    "setMinimumPollingInterval$",	//1915
    "setMinimumResizeLimits",	//1916
    "setMinimumResizeLimits$$$$",	//1917
    "setModel",	//1918
    "setModel#",	//1919
    "setModelData",	//1920
    "setName",	//1921
    "setName$",	//1922
    "setNativeWidget",	//1923
    "setNativeWidget#",	//1924
    "setNeedsToBeStored",	//1925
    "setNeedsToBeStored$",	//1926
    "setNeedsUpdate",	//1927
    "setNeedsUpdate$",	//1928
    "setNumDisplayLines",	//1929
    "setNumDisplayLines$",	//1930
    "setOperationEnabled",	//1931
    "setOperationEnabled$$",	//1932
    "setOperationsScheme",	//1933
    "setOperationsScheme#",	//1934
    "setOrientation",	//1935
    "setOrientation$",	//1936
    "setOverShoot",	//1937
    "setOverShoot$",	//1938
    "setOverflowBordersVisible",	//1939
    "setOverflowBordersVisible$",	//1940
    "setPage",	//1941
    "setPage#",	//1942
    "setPageStep",	//1943
    "setPageStep$",	//1944
    "setPassivePopup",	//1945
    "setPassivePopup$",	//1946
    "setPath",	//1947
    "setPath$",	//1948
    "setPersistence",	//1949
    "setPersistence$",	//1950
    "setPin",	//1951
    "setPin$",	//1952
    "setPluginName",	//1953
    "setPluginName$",	//1954
    "setPolicy",	//1955
    "setPolicy$",	//1956
    "setPollingInterval",	//1957
    "setPollingInterval$",	//1958
    "setPopupAlignment",	//1959
    "setPopupAlignment$",	//1960
    "setPopupIcon",	//1961
    "setPopupIcon#",	//1962
    "setPopupIcon$",	//1963
    "setPreferredIconSize",	//1964
    "setPreferredIconSize#",	//1965
    "setPreferredToolBoxPlugin",	//1966
    "setPreferredToolBoxPlugin$$",	//1967
    "setPressed",	//1968
    "setPressed$",	//1969
    "setPreviewDuringConfiguration",	//1970
    "setPreviewDuringConfiguration$",	//1971
    "setPreviewing",	//1972
    "setPreviewing$",	//1973
    "setPriority",	//1974
    "setPriority$",	//1975
    "setQuery",	//1976
    "setQuery$",	//1977
    "setRange",	//1978
    "setRange$$",	//1979
    "setReadOnly",	//1980
    "setReadOnly$",	//1981
    "setRelevance",	//1982
    "setRelevance$",	//1983
    "setRemoteLocation",	//1984
    "setRemoteLocation#",	//1985
    "setRenderingMode",	//1986
    "setRenderingMode$",	//1987
    "setRequired",	//1988
    "setRequired$$",	//1989
    "setRequiredVersion",	//1990
    "setRequiredVersion$",	//1991
    "setResizeHandleCorners",	//1992
    "setResizeHandleCorners$",	//1993
    "setResizeMethodHint",	//1994
    "setResizeMethodHint$",	//1995
    "setRoleMapping",	//1996
    "setRoleMapping$$",	//1997
    "setRunner",	//1998
    "setRunner#",	//1999
    "setRunning",	//2000
    "setRunning$",	//2001
    "setScaledContents",	//2002
    "setScaledContents$",	//2003
    "setScreen",	//2004
    "setScreen$",	//2005
    "setScreen$$",	//2006
    "setScrollPosition",	//2007
    "setScrollPosition#",	//2008
    "setSearchTermDescription",	//2009
    "setSearchTermDescription$",	//2010
    "setSelectedAction",	//2011
    "setSelectedAction#",	//2012
    "setServicePrefix",	//2013
    "setServicePrefix$",	//2014
    "setServiceType",	//2015
    "setServiceType$",	//2016
    "setShowHorizontalLines",	//2017
    "setShowHorizontalLines$",	//2018
    "setShowLabels",	//2019
    "setShowLabels$",	//2020
    "setShowTopBar",	//2021
    "setShowTopBar$",	//2022
    "setShowVerticalLines",	//2023
    "setShowVerticalLines$",	//2024
    "setShowing",	//2025
    "setShowing$",	//2026
    "setSingleMode",	//2027
    "setSingleMode$",	//2028
    "setSingleModeRunnerId",	//2029
    "setSingleModeRunnerId$",	//2030
    "setSingleRunnerQueryMode",	//2031
    "setSingleRunnerQueryMode$",	//2032
    "setSingleStep",	//2033
    "setSingleStep$",	//2034
    "setSnapSize",	//2035
    "setSnapSize#",	//2036
    "setSpeed",	//2037
    "setSpeed$",	//2038
    "setStackPlots",	//2039
    "setStackPlots$",	//2040
    "setState",	//2041
    "setState$",	//2042
    "setStatus",	//2043
    "setStatus$",	//2044
    "setStorageEnabled",	//2045
    "setStorageEnabled$",	//2046
    "setStorageEnabled$$",	//2047
    "setStyleSheet",	//2048
    "setStyleSheet$",	//2049
    "setSubText",	//2050
    "setSubText$",	//2051
    "setSubtext",	//2052
    "setSubtext$",	//2053
    "setSvg",	//2054
    "setSvg#",	//2055
    "setSvg$",	//2056
    "setSvg$$",	//2057
    "setSvgBackground",	//2058
    "setSvgBackground$",	//2059
    "setSyntaxes",	//2060
    "setSyntaxes?",	//2061
    "setTabBarShown",	//2062
    "setTabBarShown$",	//2063
    "setTabHighlighted",	//2064
    "setTabHighlighted$$",	//2065
    "setTabIcon",	//2066
    "setTabIcon$#",	//2067
    "setTabText",	//2068
    "setTabText$$",	//2069
    "setTarget",	//2070
    "setTarget#",	//2071
    "setTargetItem",	//2072
    "setTargetItem#",	//2073
    "setTargetSizeHint",	//2074
    "setTargetSizeHint#",	//2075
    "setTargetWidget",	//2076
    "setTargetWidget#",	//2077
    "setTargets",	//2078
    "setTargets$",	//2079
    "setText",	//2080
    "setText$",	//2081
    "setTextBackgroundColor",	//2082
    "setTextBackgroundColor#",	//2083
    "setTextSelectable",	//2084
    "setTextSelectable$",	//2085
    "setTheme",	//2086
    "setTheme#",	//2087
    "setThemeName",	//2088
    "setThemeName$",	//2089
    "setThinFrame",	//2090
    "setThinFrame$",	//2091
    "setTickInterval",	//2092
    "setTickInterval$",	//2093
    "setTitle",	//2094
    "setTitle$",	//2095
    "setToolBox",	//2096
    "setToolBox#",	//2097
    "setToolBoxOpen",	//2098
    "setToolBoxOpen$",	//2099
    "setTrackContainmentChanges",	//2100
    "setTrackContainmentChanges$",	//2101
    "setTransient",	//2102
    "setTransient$",	//2103
    "setType",	//2104
    "setType$",	//2105
    "setUnit",	//2106
    "setUnit$",	//2107
    "setUnpressed",	//2108
    "setUrl",	//2109
    "setUrl#",	//2110
    "setUrl$",	//2111
    "setUrls",	//2112
    "setUrls?",	//2113
    "setUseAutoRange",	//2114
    "setUseAutoRange$",	//2115
    "setUseGlobalSettings",	//2116
    "setUseGlobalSettings$",	//2117
    "setUsedControls",	//2118
    "setUsedControls$",	//2119
    "setUsingRenderingCache",	//2120
    "setUsingRenderingCache$",	//2121
    "setValid",	//2122
    "setValid$",	//2123
    "setValue",	//2124
    "setValue$",	//2125
    "setVersion",	//2126
    "setVersion$",	//2127
    "setVerticalLinesColor",	//2128
    "setVerticalLinesColor#",	//2129
    "setVerticalLinesDistance",	//2130
    "setVerticalLinesDistance$",	//2131
    "setVerticalLinesScroll",	//2132
    "setVerticalLinesScroll$",	//2133
    "setVerticalRange",	//2134
    "setVerticalRange$$",	//2135
    "setVerticalScrollBarPolicy",	//2136
    "setVerticalScrollBarPolicy$",	//2137
    "setView",	//2138
    "setView#",	//2139
    "setVisible",	//2140
    "setWallpaper",	//2141
    "setWallpaper#",	//2142
    "setWallpaper$",	//2143
    "setWallpaper$$",	//2144
    "setWallpaperEnabled",	//2145
    "setWallpaperEnabled$",	//2146
    "setWebsite",	//2147
    "setWebsite$",	//2148
    "setWidget",	//2149
    "setWidget#",	//2150
    "setWindowToPreview",	//2151
    "setWindowToPreview$",	//2152
    "setWindowsToPreview",	//2153
    "setWindowsToPreview?",	//2154
    "setWordWrap",	//2155
    "setWordWrap$",	//2156
    "setZoomFactor",	//2157
    "setZoomFactor$",	//2158
    "settingsChanged",	//2159
    "setupMatchSession",	//2160
    "shape",	//2161
    "shortcutsChanged",	//2162
    "shouldConserveResources",	//2163
    "show",	//2164
    "show#",	//2165
    "showAddWidgetsInterface",	//2166
    "showAddWidgetsInterface#",	//2167
    "showCloseButton",	//2168
    "showConfigurationInterface",	//2169
    "showConfigurationInterface#",	//2170
    "showContextMenu",	//2171
    "showContextMenu##",	//2172
    "showDialog",	//2173
    "showDialog##",	//2174
    "showDropZone",	//2175
    "showDropZone#",	//2176
    "showEvent",	//2177
    "showEvent#",	//2178
    "showHorizontalLines",	//2179
    "showLabels",	//2180
    "showMessage",	//2181
    "showMessage#$$",	//2182
    "showPopup",	//2183
    "showPopup$",	//2184
    "showToolTip",	//2185
    "showTopBar",	//2186
    "showVerticalLines",	//2187
    "singleMode",	//2188
    "singleModeAdvertisedRunnerIds",	//2189
    "singleModeRunner",	//2190
    "singleModeRunnerId",	//2191
    "singleRunnerQueryMode",	//2192
    "singleStep",	//2193
    "size",	//2194
    "sizeChanged",	//2195
    "sizeFromIconSize",	//2196
    "sizeFromIconSize$",	//2197
    "sizeHint",	//2198
    "sizeHint##",	//2199
    "sizeHint$",	//2200
    "sizeHint$#",	//2201
    "sizeHintChanged",	//2202
    "sizeHintChanged$",	//2203
    "sliderMoved",	//2204
    "sliderMoved$",	//2205
    "snapSize",	//2206
    "sourceAdded",	//2207
    "sourceAdded$",	//2208
    "sourceRemoved",	//2209
    "sourceRemoved$",	//2210
    "sourceRequestEvent",	//2211
    "sourceRequestEvent$",	//2212
    "sources",	//2213
    "speed",	//2214
    "stackPlots",	//2215
    "standardConfigurationDialog",	//2216
    "start",	//2217
    "startOperationCall",	//2218
    "startOperationCall#",	//2219
    "startOperationCall##",	//2220
    "startupArguments",	//2221
    "state",	//2222
    "staticMetaObject",	//2223
    "status",	//2224
    "stop",	//2225
    "stopCustomAnimation",	//2226
    "stopCustomAnimation$",	//2227
    "stopElementAnimation",	//2228
    "stopElementAnimation$",	//2229
    "stopItemAnimation",	//2230
    "stopItemAnimation$",	//2231
    "stopItemMovement",	//2232
    "stopItemMovement$",	//2233
    "structure",	//2234
    "styleChange",	//2235
    "styleSheet",	//2236
    "styleSheet$",	//2237
    "subText",	//2238
    "subtext",	//2239
    "supportedProtocols",	//2240
    "supportsExtension",	//2241
    "supportsMimetype",	//2242
    "supportsMimetype$",	//2243
    "suspendMatching",	//2244
    "suspendMatching$",	//2245
    "svg",	//2246
    "svgBackground",	//2247
    "swapContainment",	//2248
    "swapContainment#$",	//2249
    "swapContainment#$?",	//2250
    "swapContainment$",	//2251
    "swapContainment$?",	//2252
    "syncToGraphicsWidget",	//2253
    "syntaxes",	//2254
    "tabAt",	//2255
    "tabAt$",	//2256
    "tabIcon",	//2257
    "tabIcon$",	//2258
    "tabText",	//2259
    "tabText$",	//2260
    "tabletEvent",	//2261
    "takeTab",	//2262
    "takeTab$",	//2263
    "target",	//2264
    "targetItem",	//2265
    "targetItemReached",	//2266
    "targetItemReached#",	//2267
    "targetReached",	//2268
    "targetReached#",	//2269
    "targetSizeHint",	//2270
    "targetWidget",	//2271
    "targets",	//2272
    "teardown",	//2273
    "text",	//2274
    "textBackgroundColor",	//2275
    "textChanged",	//2276
    "textChanged$",	//2277
    "textEdited",	//2278
    "textEdited$",	//2279
    "textSelectable",	//2280
    "theme",	//2281
    "themeChanged",	//2282
    "themeName",	//2283
    "thinFrame",	//2284
    "tick",	//2285
    "tick$",	//2286
    "tickInterval",	//2287
    "timeSinceLastUpdate",	//2288
    "timerEvent",	//2289
    "timerEvent#",	//2290
    "title",	//2291
    "togglePopup",	//2292
    "toggled",	//2293
    "toggled$",	//2294
    "toolBox",	//2295
    "toolBoxItem",	//2296
    "toolBoxToggled",	//2297
    "toolBoxVisibilityChanged",	//2298
    "toolBoxVisibilityChanged$",	//2299
    "toolTipDelay",	//2300
    "topLevelViewAt",	//2301
    "topLevelViewAt#",	//2302
    "totalTime",	//2303
    "tr",	//2304
    "tr$",	//2305
    "tr$$",	//2306
    "tr$$$",	//2307
    "trUtf8",	//2308
    "trUtf8$",	//2309
    "trUtf8$$",	//2310
    "trUtf8$$$",	//2311
    "trackContainmentChanges",	//2312
    "type",	//2313
    "ungrabKeyboardEvent",	//2314
    "ungrabMouseEvent",	//2315
    "uninstallPackage",	//2316
    "uninstallPackage$$",	//2317
    "uninstallPackage$$$",	//2318
    "unit",	//2319
    "unloadEngine",	//2320
    "unloadEngine$",	//2321
    "unpublish",	//2322
    "unregisterAsDragHandle",	//2323
    "unregisterAsDragHandle#",	//2324
    "unregisterScrollingManager",	//2325
    "unregisterScrollingManager#",	//2326
    "unregisterWidget",	//2327
    "unregisterWidget#",	//2328
    "update",	//2329
    "update#",	//2330
    "updateAllSources",	//2331
    "updateConstraints",	//2332
    "updateConstraints$",	//2333
    "updateCurrentTime",	//2334
    "updateCurrentTime$",	//2335
    "updateDataBuffers",	//2336
    "updateDirection",	//2337
    "updateEditorGeometry",	//2338
    "updateGeometry",	//2339
    "updateRequested",	//2340
    "updateRequested#",	//2341
    "updateShortcuts",	//2342
    "updateSourceEvent",	//2343
    "updateSourceEvent$",	//2344
    "updateState",	//2345
    "url",	//2346
    "urlChanged",	//2347
    "urlChanged#",	//2348
    "urlDropped",	//2349
    "urlDropped#",	//2350
    "useAutoRange",	//2351
    "useDefaults",	//2352
    "useGlobalSettings",	//2353
    "useNativeWidgetStyle",	//2354
    "usedControls",	//2355
    "usrReadConfig",	//2356
    "usrSetDefaults",	//2357
    "usrUseDefaults",	//2358
    "usrWriteConfig",	//2359
    "value",	//2360
    "valueChanged",	//2361
    "valueChanged$",	//2362
    "version",	//2363
    "versionMajor",	//2364
    "versionMinor",	//2365
    "versionRelease",	//2366
    "versionString",	//2367
    "verticalLinesColor",	//2368
    "verticalLinesDistance",	//2369
    "verticalLinesScroll",	//2370
    "verticalMaxValue",	//2371
    "verticalMinValue",	//2372
    "verticalScrollBarPolicy",	//2373
    "view",	//2374
    "viewFor",	//2375
    "viewFor#",	//2376
    "viewportEvent",	//2377
    "viewportGeometry",	//2378
    "viewportGeometryChanged",	//2379
    "viewportGeometryChanged#",	//2380
    "visibilityChanged",	//2381
    "visibilityChanged$",	//2382
    "visualizationIsConnected",	//2383
    "visualizationIsConnected#",	//2384
    "wallpaper",	//2385
    "wallpaperPath",	//2386
    "wallpaperPath#",	//2387
    "website",	//2388
    "wheelEvent",	//2389
    "wheelEvent#",	//2390
    "widget",	//2391
    "windowActivationChange",	//2392
    "windowFrameEvent",	//2393
    "windowFrameSectionAt",	//2394
    "windowPreviewActivated",	//2395
    "windowPreviewActivated$$$#",	//2396
    "windowToPreview",	//2397
    "windowTranslucencyEnabled",	//2398
    "windowsToPreview",	//2399
    "wordWrap",	//2400
    "write",	//2401
    "write#",	//2402
    "write$",	//2403
    "writeConfig",	//2404
    "x11Event",	//2405
    "zoomFactor",	//2406
    "zoomRequested",	//2407
    "zoomRequested#$",	//2408
    "~AbstractDialogManager",	//2409
    "~AbstractRunner",	//2410
    "~AbstractToolBox",	//2411
    "~AccessAppletJob",	//2412
    "~Animation",	//2413
    "~AnimationDriver",	//2414
    "~Applet",	//2415
    "~AppletScript",	//2416
    "~AuthorizationInterface",	//2417
    "~AuthorizationRule",	//2418
    "~BusyWidget",	//2419
    "~CheckBox",	//2420
    "~ComboBox",	//2421
    "~ConfigLoader",	//2422
    "~Containment",	//2423
    "~ContainmentActions",	//2424
    "~ContainmentActionsPluginsConfig",	//2425
    "~Context",	//2426
    "~Corona",	//2427
    "~DataContainer",	//2428
    "~DataEngine",	//2429
    "~DataEngineScript",	//2430
    "~Delegate",	//2431
    "~Dialog",	//2432
    "~Extender",	//2433
    "~ExtenderGroup",	//2434
    "~ExtenderItem",	//2435
    "~FlashingLabel",	//2436
    "~Frame",	//2437
    "~FrameSvg",	//2438
    "~GLApplet",	//2439
    "~GroupBox",	//2440
    "~IconWidget",	//2441
    "~ItemBackground",	//2442
    "~Label",	//2443
    "~LineEdit",	//2444
    "~Meter",	//2445
    "~Package",	//2446
    "~PackageMetadata",	//2447
    "~PackageStructure",	//2448
    "~PlotColor",	//2449
    "~PopupApplet",	//2450
    "~PushButton",	//2451
    "~QueryMatch",	//2452
    "~RadioButton",	//2453
    "~RunnerContext",	//2454
    "~RunnerManager",	//2455
    "~RunnerScript",	//2456
    "~RunnerSyntax",	//2457
    "~ScriptEngine",	//2458
    "~ScrollBar",	//2459
    "~ScrollWidget",	//2460
    "~Separator",	//2461
    "~Service",	//2462
    "~ServiceAccessJob",	//2463
    "~SignalPlotter",	//2464
    "~Slider",	//2465
    "~SpinBox",	//2466
    "~StyleOption",	//2467
    "~Svg",	//2468
    "~SvgWidget",	//2469
    "~TabBar",	//2470
    "~TextBrowser",	//2471
    "~TextEdit",	//2472
    "~Theme",	//2473
    "~ToolButton",	//2474
    "~ToolTipContent",	//2475
    "~TreeView",	//2476
    "~VideoWidget",	//2477
    "~View",	//2478
    "~Wallpaper",	//2479
    "~WallpaperScript",	//2480
    "~WebView",	//2481
};

// (classId, name (index in methodNames), argumentList index, number of args, method flags, return type (index in types), xcall() index)
static Smoke::Method methods[] = {
    { 0, 0, 0, 0, 0, 0, 0 },	// (no method)
    {7, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 0},	//1 KConfigSkeleton::metaObject() const
    {7, 1487, 1, 1, Smoke::mf_virtual, 486, 0},	//2 KConfigSkeleton::qt_metacast(const char*)
    {7, 1485, 3, 3, Smoke::mf_virtual, 477, 0},	//3 KConfigSkeleton::qt_metacall(QMetaObject::Call, int, void**)
    {9, 1778, 0, 0, Smoke::mf_virtual, 0, 0},	//4 KCoreConfigSkeleton::setDefaults()
    {9, 1496, 0, 0, Smoke::mf_virtual, 0, 0},	//5 KCoreConfigSkeleton::readConfig()
    {9, 2404, 0, 0, Smoke::mf_virtual, 0, 0},	//6 KCoreConfigSkeleton::writeConfig()
    {9, 2352, 7, 1, Smoke::mf_virtual, 386, 0},	//7 KCoreConfigSkeleton::useDefaults(bool)
    {9, 2358, 7, 1, Smoke::mf_protected|Smoke::mf_virtual, 386, 0},	//8 KCoreConfigSkeleton::usrUseDefaults(bool)
    {9, 2357, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//9 KCoreConfigSkeleton::usrSetDefaults()
    {9, 2356, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//10 KCoreConfigSkeleton::usrReadConfig()
    {12, 872, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 386, 0},	//11 KJob::doKill()
    {12, 874, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 386, 0},	//12 KJob::doSuspend()
    {12, 873, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 386, 0},	//13 KJob::doResume()
    {12, 951, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 293, 0},	//14 KJob::errorString() const
    {12, 336, 0, 0, Smoke::mf_static|Smoke::mf_enum, 479, 5},	//15 KJob::NoError (enum)
    {12, 287, 0, 0, Smoke::mf_static|Smoke::mf_enum, 479, 6},	//16 KJob::KilledJobError (enum)
    {12, 514, 0, 0, Smoke::mf_static|Smoke::mf_enum, 479, 7},	//17 KJob::UserDefinedError (enum)
    {27, 1312, 9, 2, Smoke::mf_static, 140, 1},	//18 Plasma::loadScriptEngine(const QString&, Plasma::AbstractRunner*)
    {27, 2364, 0, 0, Smoke::mf_static, 484, 2},	//19 Plasma::versionMajor()
    {27, 1415, 12, 2, Smoke::mf_static, 21, 3},	//20 Plasma::packageStructure(const QString&, Plasma::ComponentType)
    {27, 1204, 15, 1, Smoke::mf_static, 294, 4},	//21 Plasma::knownLanguages(QFlags<Plasma::ComponentType>)
    {27, 2366, 0, 0, Smoke::mf_static, 484, 5},	//22 Plasma::versionRelease()
    {27, 2367, 0, 0, Smoke::mf_static, 469, 6},	//23 Plasma::versionString()
    {27, 1143, 17, 1, Smoke::mf_static, 386, 7},	//24 Plasma::isPluginVersionCompatible(unsigned int)
    {27, 1312, 19, 2, Smoke::mf_static, 51, 8},	//25 Plasma::loadScriptEngine(const QString&, Plasma::Applet*)
    {27, 1312, 22, 2, Smoke::mf_static, 84, 9},	//26 Plasma::loadScriptEngine(const QString&, Plasma::DataEngine*)
    {27, 2365, 0, 0, Smoke::mf_static, 484, 10},	//27 Plasma::versionMinor()
    {27, 1317, 25, 1, Smoke::mf_static, 90, 11},	//28 Plasma::locationToDirection(Plasma::Location)
    {27, 1319, 25, 1, Smoke::mf_static, 90, 12},	//29 Plasma::locationToInverseDirection(Plasma::Location)
    {27, 2363, 0, 0, Smoke::mf_static, 484, 13},	//30 Plasma::version()
    {27, 1618, 27, 1, Smoke::mf_static, 474, 14},	//31 Plasma::scalingFactor(Plasma::ZoomLevel)
    {27, 2375, 29, 1, Smoke::mf_static, 228, 15},	//32 Plasma::viewFor(const QGraphicsItem*)
    {27, 1312, 31, 2, Smoke::mf_static, 175, 16},	//33 Plasma::loadScriptEngine(const QString&, Plasma::Wallpaper*)
    {27, 564, 34, 3, Smoke::mf_static, 255, 17},	//34 Plasma::actionsFromMenu(QMenu*, const QString&, QObject*)
    {27, 564, 38, 1, Smoke::mf_static, 255, 18},	//35 Plasma::actionsFromMenu(QMenu*)
    {27, 564, 40, 2, Smoke::mf_static, 255, 19},	//36 Plasma::actionsFromMenu(QMenu*, const QString&)
    {27, 549, 0, 0, Smoke::mf_static|Smoke::mf_enum, 178, 20},	//37 Plasma::ZoomIn (enum)
    {27, 550, 0, 0, Smoke::mf_static|Smoke::mf_enum, 178, 21},	//38 Plasma::ZoomOut (enum)
    {27, 373, 0, 0, Smoke::mf_static|Smoke::mf_enum, 97, 22},	//39 Plasma::Planar (enum)
    {27, 309, 0, 0, Smoke::mf_static|Smoke::mf_enum, 97, 23},	//40 Plasma::MediaCenter (enum)
    {27, 209, 0, 0, Smoke::mf_static|Smoke::mf_enum, 97, 24},	//41 Plasma::Horizontal (enum)
    {27, 522, 0, 0, Smoke::mf_static|Smoke::mf_enum, 97, 25},	//42 Plasma::Vertical (enum)
    {27, 50, 0, 0, Smoke::mf_static|Smoke::mf_enum, 97, 26},	//43 Plasma::Application (enum)
    {27, 75, 0, 0, Smoke::mf_static|Smoke::mf_enum, 114, 27},	//44 Plasma::ButtonNone (enum)
    {27, 76, 0, 0, Smoke::mf_static|Smoke::mf_enum, 114, 28},	//45 Plasma::ButtonOk (enum)
    {27, 78, 0, 0, Smoke::mf_static|Smoke::mf_enum, 114, 29},	//46 Plasma::ButtonYes (enum)
    {27, 74, 0, 0, Smoke::mf_static|Smoke::mf_enum, 114, 30},	//47 Plasma::ButtonNo (enum)
    {27, 71, 0, 0, Smoke::mf_static|Smoke::mf_enum, 114, 31},	//48 Plasma::ButtonCancel (enum)
    {27, 323, 0, 0, Smoke::mf_static|Smoke::mf_enum, 106, 32},	//49 Plasma::NoAlignment (enum)
    {27, 21, 0, 0, Smoke::mf_static|Smoke::mf_enum, 106, 33},	//50 Plasma::AlignToMinute (enum)
    {27, 20, 0, 0, Smoke::mf_static|Smoke::mf_enum, 106, 34},	//51 Plasma::AlignToHour (enum)
    {27, 498, 0, 0, Smoke::mf_static|Smoke::mf_enum, 113, 35},	//52 Plasma::TopMargin (enum)
    {27, 60, 0, 0, Smoke::mf_static|Smoke::mf_enum, 113, 36},	//53 Plasma::BottomMargin (enum)
    {27, 295, 0, 0, Smoke::mf_static|Smoke::mf_enum, 113, 37},	//54 Plasma::LeftMargin (enum)
    {27, 397, 0, 0, Smoke::mf_static|Smoke::mf_enum, 113, 38},	//55 Plasma::RightMargin (enum)
    {27, 225, 0, 0, Smoke::mf_static|Smoke::mf_enum, 52, 39},	//56 Plasma::InvalidAspectRatioMode (enum)
    {27, 218, 0, 0, Smoke::mf_static|Smoke::mf_enum, 52, 40},	//57 Plasma::IgnoreAspectRatio (enum)
    {27, 284, 0, 0, Smoke::mf_static|Smoke::mf_enum, 52, 41},	//58 Plasma::KeepAspectRatio (enum)
    {27, 456, 0, 0, Smoke::mf_static|Smoke::mf_enum, 52, 42},	//59 Plasma::Square (enum)
    {27, 100, 0, 0, Smoke::mf_static|Smoke::mf_enum, 52, 43},	//60 Plasma::ConstrainedSquare (enum)
    {27, 180, 0, 0, Smoke::mf_static|Smoke::mf_enum, 52, 44},	//61 Plasma::FixedSize (enum)
    {27, 298, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 45},	//62 Plasma::LeftPositioned (enum)
    {27, 400, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 46},	//63 Plasma::RightPositioned (enum)
    {27, 501, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 47},	//64 Plasma::TopPositioned (enum)
    {27, 63, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 48},	//65 Plasma::BottomPositioned (enum)
    {27, 83, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 49},	//66 Plasma::CenterPositioned (enum)
    {27, 155, 0, 0, Smoke::mf_static|Smoke::mf_enum, 90, 50},	//67 Plasma::Down (enum)
    {27, 513, 0, 0, Smoke::mf_static|Smoke::mf_enum, 90, 51},	//68 Plasma::Up (enum)
    {27, 292, 0, 0, Smoke::mf_static|Smoke::mf_enum, 90, 52},	//69 Plasma::Left (enum)
    {27, 394, 0, 0, Smoke::mf_static|Smoke::mf_enum, 90, 53},	//70 Plasma::Right (enum)
    {27, 325, 0, 0, Smoke::mf_static|Smoke::mf_enum, 47, 54},	//71 Plasma::NoAnnouncement (enum)
    {27, 547, 0, 0, Smoke::mf_static|Smoke::mf_enum, 47, 55},	//72 Plasma::ZeroconfAnnouncement (enum)
    {27, 226, 0, 0, Smoke::mf_static|Smoke::mf_enum, 169, 56},	//73 Plasma::InvalidCredentials (enum)
    {27, 510, 0, 0, Smoke::mf_static|Smoke::mf_enum, 169, 57},	//74 Plasma::UnknownCredentials (enum)
    {27, 520, 0, 0, Smoke::mf_static|Smoke::mf_enum, 169, 58},	//75 Plasma::ValidCredentials (enum)
    {27, 506, 0, 0, Smoke::mf_static|Smoke::mf_enum, 169, 59},	//76 Plasma::TrustedCredentials (enum)
    {27, 509, 0, 0, Smoke::mf_static|Smoke::mf_enum, 169, 60},	//77 Plasma::UltimateCredentials (enum)
    {27, 319, 0, 0, Smoke::mf_static|Smoke::mf_enum, 105, 61},	//78 Plasma::Mutable (enum)
    {27, 516, 0, 0, Smoke::mf_static|Smoke::mf_enum, 105, 62},	//79 Plasma::UserImmutable (enum)
    {27, 476, 0, 0, Smoke::mf_static|Smoke::mf_enum, 105, 63},	//80 Plasma::SystemImmutable (enum)
    {27, 184, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 64},	//81 Plasma::FloatingPopup (enum)
    {27, 499, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 65},	//82 Plasma::TopPosedLeftAlignedPopup (enum)
    {27, 500, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 66},	//83 Plasma::TopPosedRightAlignedPopup (enum)
    {27, 297, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 67},	//84 Plasma::LeftPosedTopAlignedPopup (enum)
    {27, 296, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 68},	//85 Plasma::LeftPosedBottomAlignedPopup (enum)
    {27, 61, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 69},	//86 Plasma::BottomPosedLeftAlignedPopup (enum)
    {27, 62, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 70},	//87 Plasma::BottomPosedRightAlignedPopup (enum)
    {27, 399, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 71},	//88 Plasma::RightPosedTopAlignedPopup (enum)
    {27, 398, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 72},	//89 Plasma::RightPosedBottomAlignedPopup (enum)
    {27, 49, 0, 0, Smoke::mf_static|Smoke::mf_enum, 109, 73},	//90 Plasma::AppletType (enum)
    {27, 301, 0, 0, Smoke::mf_static|Smoke::mf_enum, 109, 74},	//91 Plasma::LineEditType (enum)
    {27, 331, 0, 0, Smoke::mf_static|Smoke::mf_enum, 68, 75},	//92 Plasma::NoConstraint (enum)
    {27, 186, 0, 0, Smoke::mf_static|Smoke::mf_enum, 68, 76},	//93 Plasma::FormFactorConstraint (enum)
    {27, 304, 0, 0, Smoke::mf_static|Smoke::mf_enum, 68, 77},	//94 Plasma::LocationConstraint (enum)
    {27, 420, 0, 0, Smoke::mf_static|Smoke::mf_enum, 68, 78},	//95 Plasma::ScreenConstraint (enum)
    {27, 443, 0, 0, Smoke::mf_static|Smoke::mf_enum, 68, 79},	//96 Plasma::SizeConstraint (enum)
    {27, 221, 0, 0, Smoke::mf_static|Smoke::mf_enum, 68, 80},	//97 Plasma::ImmutableConstraint (enum)
    {27, 458, 0, 0, Smoke::mf_static|Smoke::mf_enum, 68, 81},	//98 Plasma::StartupCompletedConstraint (enum)
    {27, 114, 0, 0, Smoke::mf_static|Smoke::mf_enum, 68, 82},	//99 Plasma::ContextConstraint (enum)
    {27, 380, 0, 0, Smoke::mf_static|Smoke::mf_enum, 68, 83},	//100 Plasma::PopupConstraint (enum)
    {27, 24, 0, 0, Smoke::mf_static|Smoke::mf_enum, 68, 84},	//101 Plasma::AllConstraints (enum)
    {27, 337, 0, 0, Smoke::mf_static|Smoke::mf_enum, 96, 85},	//102 Plasma::NoFlip (enum)
    {27, 210, 0, 0, Smoke::mf_static|Smoke::mf_enum, 96, 86},	//103 Plasma::HorizontalFlip (enum)
    {27, 523, 0, 0, Smoke::mf_static|Smoke::mf_enum, 96, 87},	//104 Plasma::VerticalFlip (enum)
    {27, 511, 0, 0, Smoke::mf_static|Smoke::mf_enum, 108, 88},	//105 Plasma::UnknownStatus (enum)
    {27, 364, 0, 0, Smoke::mf_static|Smoke::mf_enum, 108, 89},	//106 Plasma::PassiveStatus (enum)
    {27, 18, 0, 0, Smoke::mf_static|Smoke::mf_enum, 108, 90},	//107 Plasma::ActiveStatus (enum)
    {27, 320, 0, 0, Smoke::mf_static|Smoke::mf_enum, 108, 91},	//108 Plasma::NeedsAttentionStatus (enum)
    {27, 12, 0, 0, Smoke::mf_static|Smoke::mf_enum, 108, 92},	//109 Plasma::AcceptingInputStatus (enum)
    {27, 143, 0, 0, Smoke::mf_static|Smoke::mf_enum, 179, 93},	//110 Plasma::DesktopZoom (enum)
    {27, 201, 0, 0, Smoke::mf_static|Smoke::mf_enum, 179, 94},	//111 Plasma::GroupZoom (enum)
    {27, 350, 0, 0, Smoke::mf_static|Smoke::mf_enum, 179, 95},	//112 Plasma::OverviewZoom (enum)
    {27, 46, 0, 0, Smoke::mf_static|Smoke::mf_enum, 66, 96},	//113 Plasma::AppletComponent (enum)
    {27, 127, 0, 0, Smoke::mf_static|Smoke::mf_enum, 66, 97},	//114 Plasma::DataEngineComponent (enum)
    {27, 404, 0, 0, Smoke::mf_static|Smoke::mf_enum, 66, 98},	//115 Plasma::RunnerComponent (enum)
    {27, 36, 0, 0, Smoke::mf_static|Smoke::mf_enum, 66, 99},	//116 Plasma::AnimatorComponent (enum)
    {27, 111, 0, 0, Smoke::mf_static|Smoke::mf_enum, 66, 100},	//117 Plasma::ContainmentComponent (enum)
    {27, 540, 0, 0, Smoke::mf_static|Smoke::mf_enum, 66, 101},	//118 Plasma::WallpaperComponent (enum)
    {27, 197, 0, 0, Smoke::mf_static|Smoke::mf_enum, 66, 102},	//119 Plasma::GenericComponent (enum)
    {27, 183, 0, 0, Smoke::mf_static|Smoke::mf_enum, 112, 103},	//120 Plasma::Floating (enum)
    {27, 140, 0, 0, Smoke::mf_static|Smoke::mf_enum, 112, 104},	//121 Plasma::Desktop (enum)
    {27, 192, 0, 0, Smoke::mf_static|Smoke::mf_enum, 112, 105},	//122 Plasma::FullScreen (enum)
    {27, 497, 0, 0, Smoke::mf_static|Smoke::mf_enum, 112, 106},	//123 Plasma::TopEdge (enum)
    {27, 59, 0, 0, Smoke::mf_static|Smoke::mf_enum, 112, 107},	//124 Plasma::BottomEdge (enum)
    {27, 294, 0, 0, Smoke::mf_static|Smoke::mf_enum, 112, 108},	//125 Plasma::LeftEdge (enum)
    {27, 396, 0, 0, Smoke::mf_static|Smoke::mf_enum, 112, 109},	//126 Plasma::RightEdge (enum)
    {28, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//127 Plasma::AbstractDialogManager::metaObject() const
    {28, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//128 Plasma::AbstractDialogManager::qt_metacast(const char*)
    {28, 2304, 43, 2, Smoke::mf_static, 293, 3},	//129 Plasma::AbstractDialogManager::tr(const char*, const char*)
    {28, 2308, 43, 2, Smoke::mf_static, 293, 4},	//130 Plasma::AbstractDialogManager::trUtf8(const char*, const char*)
    {28, 2304, 46, 3, Smoke::mf_static, 293, 5},	//131 Plasma::AbstractDialogManager::tr(const char*, const char*, int)
    {28, 2308, 46, 3, Smoke::mf_static, 293, 6},	//132 Plasma::AbstractDialogManager::trUtf8(const char*, const char*, int)
    {28, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//133 Plasma::AbstractDialogManager::qt_metacall(QMetaObject::Call, int, void**)
    {28, 1, 50, 1, Smoke::mf_ctor, 31, 8},	//134 Plasma::AbstractDialogManager::AbstractDialogManager(Plasma::Corona*)
    {28, 2173, 52, 2, Smoke::mf_slot, 0, 9},	//135 Plasma::AbstractDialogManager::showDialog(QWidget*, Plasma::Applet*)
    {28, 2304, 1, 1, Smoke::mf_static, 293, 10},	//136 Plasma::AbstractDialogManager::tr(const char*)
    {28, 2308, 1, 1, Smoke::mf_static, 293, 11},	//137 Plasma::AbstractDialogManager::trUtf8(const char*)
    {28, 1, 0, 0, Smoke::mf_ctor, 31, 12},	//138 Plasma::AbstractDialogManager::AbstractDialogManager()
    {28, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 13},	//139 Plasma::AbstractDialogManager::staticMetaObject() const
    {28, 2409, 0, 0, Smoke::mf_dtor, 0, 14 },	//140 Plasma::AbstractDialogManager::~AbstractDialogManager()
    {29, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//141 Plasma::AbstractRunner::metaObject() const
    {29, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//142 Plasma::AbstractRunner::qt_metacast(const char*)
    {29, 2304, 43, 2, Smoke::mf_static, 293, 3},	//143 Plasma::AbstractRunner::tr(const char*, const char*)
    {29, 2308, 43, 2, Smoke::mf_static, 293, 4},	//144 Plasma::AbstractRunner::trUtf8(const char*, const char*)
    {29, 2304, 46, 3, Smoke::mf_static, 293, 5},	//145 Plasma::AbstractRunner::tr(const char*, const char*, int)
    {29, 2308, 46, 3, Smoke::mf_static, 293, 6},	//146 Plasma::AbstractRunner::trUtf8(const char*, const char*, int)
    {29, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//147 Plasma::AbstractRunner::qt_metacall(QMetaObject::Call, int, void**)
    {29, 1336, 55, 1, Smoke::mf_virtual, 0, 8},	//148 Plasma::AbstractRunner::match(Plasma::RunnerContext&)
    {29, 1450, 55, 1, 0, 0, 9},	//149 Plasma::AbstractRunner::performMatch(Plasma::RunnerContext&)
    {29, 1051, 0, 0, 0, 386, 10},	//150 Plasma::AbstractRunner::hasRunOptions()
    {29, 817, 57, 1, Smoke::mf_virtual, 0, 11},	//151 Plasma::AbstractRunner::createRunOptions(QWidget*)
    {29, 1597, 59, 2, Smoke::mf_virtual, 0, 12},	//152 Plasma::AbstractRunner::run(const Plasma::RunnerContext&, const Plasma::QueryMatch&)
    {29, 2214, 0, 0, Smoke::mf_const, 34, 13},	//153 Plasma::AbstractRunner::speed() const
    {29, 1479, 0, 0, Smoke::mf_const, 33, 14},	//154 Plasma::AbstractRunner::priority() const
    {29, 1078, 0, 0, Smoke::mf_const, 205, 15},	//155 Plasma::AbstractRunner::ignoredTypes() const
    {29, 1863, 62, 1, 0, 0, 16},	//156 Plasma::AbstractRunner::setIgnoredTypes(QFlags<Plasma::RunnerContext::Type>)
    {29, 1386, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 17},	//157 Plasma::AbstractRunner::name() const
    {29, 1077, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 18},	//158 Plasma::AbstractRunner::id() const
    {29, 849, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 19},	//159 Plasma::AbstractRunner::description() const
    {29, 1075, 0, 0, Smoke::mf_const|Smoke::mf_property, 236, 20},	//160 Plasma::AbstractRunner::icon() const
    {29, 1414, 0, 0, Smoke::mf_const, 409, 21},	//161 Plasma::AbstractRunner::package() const
    {29, 1519, 0, 0, Smoke::mf_virtual, 0, 22},	//162 Plasma::AbstractRunner::reloadConfiguration()
    {29, 2254, 0, 0, Smoke::mf_const, 254, 23},	//163 Plasma::AbstractRunner::syntaxes() const
    {29, 700, 0, 0, Smoke::mf_static, 269, 24},	//164 Plasma::AbstractRunner::bigLock()
    {29, 845, 0, 0, Smoke::mf_const, 143, 25},	//165 Plasma::AbstractRunner::defaultSyntax() const
    {29, 1138, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 26},	//166 Plasma::AbstractRunner::isMatchingSuspended() const
    {29, 1475, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 27},	//167 Plasma::AbstractRunner::prepare()
    {29, 2273, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 28},	//168 Plasma::AbstractRunner::teardown()
    {29, 1343, 7, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 29},	//169 Plasma::AbstractRunner::matchingSuspended(bool)
    {29, 3, 64, 2, Smoke::mf_ctor|Smoke::mf_protected, 32, 30},	//170 Plasma::AbstractRunner::AbstractRunner(QObject*, const QString&)
    {29, 3, 67, 2, Smoke::mf_ctor|Smoke::mf_protected, 32, 31},	//171 Plasma::AbstractRunner::AbstractRunner(const KSharedPtr<KService>, QObject*)
    {29, 3, 70, 2, Smoke::mf_ctor|Smoke::mf_protected, 32, 32},	//172 Plasma::AbstractRunner::AbstractRunner(QObject*, const QList<QVariant>&)
    {29, 2244, 7, 1, Smoke::mf_protected|Smoke::mf_property, 0, 33},	//173 Plasma::AbstractRunner::suspendMatching(bool)
    {29, 738, 0, 0, Smoke::mf_const|Smoke::mf_protected, 8, 34},	//174 Plasma::AbstractRunner::config() const
    {29, 1841, 7, 1, Smoke::mf_protected, 0, 35},	//175 Plasma::AbstractRunner::setHasRunOptions(bool)
    {29, 2037, 73, 1, Smoke::mf_protected, 0, 36},	//176 Plasma::AbstractRunner::setSpeed(Plasma::AbstractRunner::Speed)
    {29, 1974, 75, 1, Smoke::mf_protected, 0, 37},	//177 Plasma::AbstractRunner::setPriority(Plasma::AbstractRunner::Priority)
    {29, 1652, 77, 2, Smoke::mf_const|Smoke::mf_protected, 244, 38},	//178 Plasma::AbstractRunner::serviceQuery(const QString&, const QString&) const
    {29, 561, 80, 1, Smoke::mf_protected|Smoke::mf_virtual, 255, 39},	//179 Plasma::AbstractRunner::actionsForMatch(const Plasma::QueryMatch&)
    {29, 574, 82, 3, Smoke::mf_protected, 183, 40},	//180 Plasma::AbstractRunner::addAction(const QString&, const QIcon&, const QString&)
    {29, 574, 86, 2, Smoke::mf_protected, 0, 41},	//181 Plasma::AbstractRunner::addAction(const QString&, QAction*)
    {29, 1529, 89, 1, Smoke::mf_protected, 0, 42},	//182 Plasma::AbstractRunner::removeAction(const QString&)
    {29, 557, 89, 1, Smoke::mf_const|Smoke::mf_protected, 183, 43},	//183 Plasma::AbstractRunner::action(const QString&) const
    {29, 560, 0, 0, Smoke::mf_const|Smoke::mf_protected, 232, 44},	//184 Plasma::AbstractRunner::actions() const
    {29, 718, 0, 0, Smoke::mf_protected, 0, 45},	//185 Plasma::AbstractRunner::clearActions()
    {29, 626, 91, 1, Smoke::mf_protected, 0, 46},	//186 Plasma::AbstractRunner::addSyntax(const Plasma::RunnerSyntax&)
    {29, 1776, 91, 1, Smoke::mf_protected, 0, 47},	//187 Plasma::AbstractRunner::setDefaultSyntax(const Plasma::RunnerSyntax&)
    {29, 2060, 93, 1, Smoke::mf_protected, 0, 48},	//188 Plasma::AbstractRunner::setSyntaxes(const QList<Plasma::RunnerSyntax>&)
    {29, 839, 89, 1, Smoke::mf_const|Smoke::mf_protected, 81, 49},	//189 Plasma::AbstractRunner::dataEngine(const QString&) const
    {29, 1091, 0, 0, Smoke::mf_protected|Smoke::mf_slot, 0, 50},	//190 Plasma::AbstractRunner::init()
    {29, 1355, 95, 1, Smoke::mf_protected|Smoke::mf_slot, 266, 51},	//191 Plasma::AbstractRunner::mimeDataForMatch(const Plasma::QueryMatch*)
    {29, 2304, 1, 1, Smoke::mf_static, 293, 52},	//192 Plasma::AbstractRunner::tr(const char*)
    {29, 2308, 1, 1, Smoke::mf_static, 293, 53},	//193 Plasma::AbstractRunner::trUtf8(const char*)
    {29, 3, 0, 0, Smoke::mf_ctor|Smoke::mf_protected, 32, 54},	//194 Plasma::AbstractRunner::AbstractRunner()
    {29, 3, 97, 1, Smoke::mf_ctor|Smoke::mf_protected, 32, 55},	//195 Plasma::AbstractRunner::AbstractRunner(QObject*)
    {29, 3, 99, 1, Smoke::mf_ctor|Smoke::mf_protected, 32, 56},	//196 Plasma::AbstractRunner::AbstractRunner(const KSharedPtr<KService>)
    {29, 1652, 89, 1, Smoke::mf_const|Smoke::mf_protected, 244, 57},	//197 Plasma::AbstractRunner::serviceQuery(const QString&) const
    {29, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 58},	//198 Plasma::AbstractRunner::staticMetaObject() const
    {29, 449, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 59},	//199 Plasma::AbstractRunner::SlowSpeed (enum)
    {29, 346, 0, 0, Smoke::mf_static|Smoke::mf_enum, 34, 60},	//200 Plasma::AbstractRunner::NormalSpeed (enum)
    {29, 306, 0, 0, Smoke::mf_static|Smoke::mf_enum, 33, 61},	//201 Plasma::AbstractRunner::LowestPriority (enum)
    {29, 305, 0, 0, Smoke::mf_static|Smoke::mf_enum, 33, 62},	//202 Plasma::AbstractRunner::LowPriority (enum)
    {29, 345, 0, 0, Smoke::mf_static|Smoke::mf_enum, 33, 63},	//203 Plasma::AbstractRunner::NormalPriority (enum)
    {29, 206, 0, 0, Smoke::mf_static|Smoke::mf_enum, 33, 64},	//204 Plasma::AbstractRunner::HighPriority (enum)
    {29, 207, 0, 0, Smoke::mf_static|Smoke::mf_enum, 33, 65},	//205 Plasma::AbstractRunner::HighestPriority (enum)
    {29, 2410, 0, 0, Smoke::mf_dtor, 0, 66 },	//206 Plasma::AbstractRunner::~AbstractRunner()
    {30, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//207 Plasma::AbstractToolBox::metaObject() const
    {30, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//208 Plasma::AbstractToolBox::qt_metacast(const char*)
    {30, 2304, 43, 2, Smoke::mf_static, 293, 3},	//209 Plasma::AbstractToolBox::tr(const char*, const char*)
    {30, 2308, 43, 2, Smoke::mf_static, 293, 4},	//210 Plasma::AbstractToolBox::trUtf8(const char*, const char*)
    {30, 2304, 46, 3, Smoke::mf_static, 293, 5},	//211 Plasma::AbstractToolBox::tr(const char*, const char*, int)
    {30, 2308, 46, 3, Smoke::mf_static, 293, 6},	//212 Plasma::AbstractToolBox::trUtf8(const char*, const char*, int)
    {30, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//213 Plasma::AbstractToolBox::qt_metacall(QMetaObject::Call, int, void**)
    {30, 9, 101, 1, Smoke::mf_ctor, 35, 8},	//214 Plasma::AbstractToolBox::AbstractToolBox(Plasma::Containment*)
    {30, 9, 70, 2, Smoke::mf_ctor, 35, 9},	//215 Plasma::AbstractToolBox::AbstractToolBox(QObject*, const QList<QVariant>&)
    {30, 1281, 103, 3, Smoke::mf_static, 35, 10},	//216 Plasma::AbstractToolBox::load(const QString&, const QList<QVariant>&, Plasma::Containment*)
    {30, 1274, 89, 1, Smoke::mf_static, 242, 11},	//217 Plasma::AbstractToolBox::listToolBoxInfo(const QString&)
    {30, 633, 107, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 12},	//218 Plasma::AbstractToolBox::addTool(QAction*) [pure virtual]
    {30, 1555, 107, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 13},	//219 Plasma::AbstractToolBox::removeTool(QAction*) [pure virtual]
    {30, 1154, 0, 0, Smoke::mf_const|Smoke::mf_property|Smoke::mf_virtual|Smoke::mf_purevirtual, 386, 14},	//220 Plasma::AbstractToolBox::isShowing() const [pure virtual]
    {30, 2025, 109, 1, Smoke::mf_property|Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 15},	//221 Plasma::AbstractToolBox::setShowing(const bool) [pure virtual]
    {30, 1589, 111, 1, Smoke::mf_slot, 0, 16},	//222 Plasma::AbstractToolBox::restore(const KConfigGroup&)
    {30, 1607, 111, 1, Smoke::mf_slot, 0, 17},	//223 Plasma::AbstractToolBox::save(const KConfigGroup&)
    {30, 1573, 0, 0, Smoke::mf_slot, 0, 18},	//224 Plasma::AbstractToolBox::reposition()
    {30, 2293, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 19},	//225 Plasma::AbstractToolBox::toggled()
    {30, 2381, 7, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 20},	//226 Plasma::AbstractToolBox::visibilityChanged(bool)
    {30, 765, 0, 0, Smoke::mf_const|Smoke::mf_protected, 69, 21},	//227 Plasma::AbstractToolBox::containment() const
    {30, 2304, 1, 1, Smoke::mf_static, 293, 22},	//228 Plasma::AbstractToolBox::tr(const char*)
    {30, 2308, 1, 1, Smoke::mf_static, 293, 23},	//229 Plasma::AbstractToolBox::trUtf8(const char*)
    {30, 9, 0, 0, Smoke::mf_ctor, 35, 24},	//230 Plasma::AbstractToolBox::AbstractToolBox()
    {30, 9, 97, 1, Smoke::mf_ctor, 35, 25},	//231 Plasma::AbstractToolBox::AbstractToolBox(QObject*)
    {30, 1281, 89, 1, Smoke::mf_static, 35, 26},	//232 Plasma::AbstractToolBox::load(const QString&)
    {30, 1281, 113, 2, Smoke::mf_static, 35, 27},	//233 Plasma::AbstractToolBox::load(const QString&, const QList<QVariant>&)
    {30, 1274, 0, 0, Smoke::mf_static, 242, 28},	//234 Plasma::AbstractToolBox::listToolBoxInfo()
    {30, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 29},	//235 Plasma::AbstractToolBox::staticMetaObject() const
    {30, 19, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 30},	//236 Plasma::AbstractToolBox::AddTool (enum)
    {30, 99, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 31},	//237 Plasma::AbstractToolBox::ConfigureTool (enum)
    {30, 115, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 32},	//238 Plasma::AbstractToolBox::ControlTool (enum)
    {30, 313, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 33},	//239 Plasma::AbstractToolBox::MiscTool (enum)
    {30, 144, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 34},	//240 Plasma::AbstractToolBox::DestructiveTool (enum)
    {30, 517, 0, 0, Smoke::mf_static|Smoke::mf_enum, 36, 35},	//241 Plasma::AbstractToolBox::UserToolType (enum)
    {30, 2411, 0, 0, Smoke::mf_dtor, 0, 36 },	//242 Plasma::AbstractToolBox::~AbstractToolBox()
    {31, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//243 Plasma::AccessAppletJob::metaObject() const
    {31, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//244 Plasma::AccessAppletJob::qt_metacast(const char*)
    {31, 2304, 43, 2, Smoke::mf_static, 293, 3},	//245 Plasma::AccessAppletJob::tr(const char*, const char*)
    {31, 2308, 43, 2, Smoke::mf_static, 293, 4},	//246 Plasma::AccessAppletJob::trUtf8(const char*, const char*)
    {31, 2304, 46, 3, Smoke::mf_static, 293, 5},	//247 Plasma::AccessAppletJob::tr(const char*, const char*, int)
    {31, 2308, 46, 3, Smoke::mf_static, 293, 6},	//248 Plasma::AccessAppletJob::trUtf8(const char*, const char*, int)
    {31, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//249 Plasma::AccessAppletJob::qt_metacall(QMetaObject::Call, int, void**)
    {31, 664, 0, 0, Smoke::mf_const, 49, 8},	//250 Plasma::AccessAppletJob::applet() const
    {31, 13, 116, 2, Smoke::mf_ctor|Smoke::mf_protected, 37, 9},	//251 Plasma::AccessAppletJob::AccessAppletJob(const KUrl&, QObject*)
    {31, 2217, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 10},	//252 Plasma::AccessAppletJob::start()
    {31, 2304, 1, 1, Smoke::mf_static, 293, 11},	//253 Plasma::AccessAppletJob::tr(const char*)
    {31, 2308, 1, 1, Smoke::mf_static, 293, 12},	//254 Plasma::AccessAppletJob::trUtf8(const char*)
    {31, 13, 119, 1, Smoke::mf_ctor|Smoke::mf_protected, 37, 13},	//255 Plasma::AccessAppletJob::AccessAppletJob(const KUrl&)
    {31, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 14},	//256 Plasma::AccessAppletJob::staticMetaObject() const
    {31, 2412, 0, 0, Smoke::mf_dtor, 0, 15 },	//257 Plasma::AccessAppletJob::~AccessAppletJob()
    {32, 1351, 0, 0, Smoke::mf_const, 442, 1},	//258 Plasma::AccessManager::metaObject() const
    {32, 1487, 1, 1, 0, 486, 2},	//259 Plasma::AccessManager::qt_metacast(const char*)
    {32, 2304, 43, 2, Smoke::mf_static, 293, 3},	//260 Plasma::AccessManager::tr(const char*, const char*)
    {32, 2308, 43, 2, Smoke::mf_static, 293, 4},	//261 Plasma::AccessManager::trUtf8(const char*, const char*)
    {32, 2304, 46, 3, Smoke::mf_static, 293, 5},	//262 Plasma::AccessManager::tr(const char*, const char*, int)
    {32, 2308, 46, 3, Smoke::mf_static, 293, 6},	//263 Plasma::AccessManager::trUtf8(const char*, const char*, int)
    {32, 1485, 3, 3, 0, 477, 7},	//264 Plasma::AccessManager::qt_metacall(QMetaObject::Call, int, void**)
    {32, 1646, 0, 0, Smoke::mf_static, 38, 8},	//265 Plasma::AccessManager::self()
    {32, 555, 119, 1, Smoke::mf_const, 37, 9},	//266 Plasma::AccessManager::accessRemoteApplet(const KUrl&) const
    {32, 1525, 0, 0, Smoke::mf_const, 251, 10},	//267 Plasma::AccessManager::remoteApplets() const
    {32, 2240, 0, 0, Smoke::mf_static, 294, 11},	//268 Plasma::AccessManager::supportedProtocols()
    {32, 985, 121, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 12},	//269 Plasma::AccessManager::finished(Plasma::AccessAppletJob*)
    {32, 1521, 123, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 13},	//270 Plasma::AccessManager::remoteAppletAnnounced(Plasma::PackageMetadata)
    {32, 1523, 123, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 14},	//271 Plasma::AccessManager::remoteAppletUnannounced(Plasma::PackageMetadata)
    {32, 2304, 1, 1, Smoke::mf_static, 293, 15},	//272 Plasma::AccessManager::tr(const char*)
    {32, 2308, 1, 1, Smoke::mf_static, 293, 16},	//273 Plasma::AccessManager::trUtf8(const char*)
    {32, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 17},	//274 Plasma::AccessManager::staticMetaObject() const
    {33, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//275 Plasma::Animation::metaObject() const
    {33, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//276 Plasma::Animation::qt_metacast(const char*)
    {33, 2304, 43, 2, Smoke::mf_static, 293, 3},	//277 Plasma::Animation::tr(const char*, const char*)
    {33, 2308, 43, 2, Smoke::mf_static, 293, 4},	//278 Plasma::Animation::trUtf8(const char*, const char*)
    {33, 2304, 46, 3, Smoke::mf_static, 293, 5},	//279 Plasma::Animation::tr(const char*, const char*, int)
    {33, 2308, 46, 3, Smoke::mf_static, 293, 6},	//280 Plasma::Animation::trUtf8(const char*, const char*, int)
    {33, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//281 Plasma::Animation::qt_metacall(QMetaObject::Call, int, void**)
    {33, 908, 0, 0, Smoke::mf_const|Smoke::mf_property|Smoke::mf_virtual, 477, 8},	//282 Plasma::Animation::duration() const
    {33, 32, 97, 1, Smoke::mf_ctor, 39, 9},	//283 Plasma::Animation::Animation(QObject*)
    {33, 2076, 125, 1, 0, 0, 10},	//284 Plasma::Animation::setTargetWidget(QGraphicsWidget*)
    {33, 2271, 0, 0, Smoke::mf_const, 229, 11},	//285 Plasma::Animation::targetWidget() const
    {33, 1795, 127, 1, Smoke::mf_property, 0, 12},	//286 Plasma::Animation::setEasingCurve(const QEasingCurve&)
    {33, 909, 0, 0, Smoke::mf_const|Smoke::mf_property, 197, 13},	//287 Plasma::Animation::easingCurve() const
    {33, 1793, 129, 1, Smoke::mf_protected|Smoke::mf_property|Smoke::mf_virtual, 0, 14},	//288 Plasma::Animation::setDuration(int)
    {33, 2334, 129, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 15},	//289 Plasma::Animation::updateCurrentTime(int)
    {33, 2304, 1, 1, Smoke::mf_static, 293, 16},	//290 Plasma::Animation::tr(const char*)
    {33, 2308, 1, 1, Smoke::mf_static, 293, 17},	//291 Plasma::Animation::trUtf8(const char*)
    {33, 32, 0, 0, Smoke::mf_ctor, 39, 18},	//292 Plasma::Animation::Animation()
    {33, 1793, 0, 0, Smoke::mf_protected|Smoke::mf_property, 0, 19},	//293 Plasma::Animation::setDuration()
    {33, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 20},	//294 Plasma::Animation::staticMetaObject() const
    {33, 82, 0, 0, Smoke::mf_static|Smoke::mf_enum, 41, 21},	//295 Plasma::Animation::Center (enum)
    {33, 513, 0, 0, Smoke::mf_static|Smoke::mf_enum, 41, 22},	//296 Plasma::Animation::Up (enum)
    {33, 155, 0, 0, Smoke::mf_static|Smoke::mf_enum, 41, 23},	//297 Plasma::Animation::Down (enum)
    {33, 292, 0, 0, Smoke::mf_static|Smoke::mf_enum, 41, 24},	//298 Plasma::Animation::Left (enum)
    {33, 394, 0, 0, Smoke::mf_static|Smoke::mf_enum, 41, 25},	//299 Plasma::Animation::Right (enum)
    {33, 314, 0, 0, Smoke::mf_static|Smoke::mf_enum, 40, 26},	//300 Plasma::Animation::MoveAny (enum)
    {33, 318, 0, 0, Smoke::mf_static|Smoke::mf_enum, 40, 27},	//301 Plasma::Animation::MoveUp (enum)
    {33, 317, 0, 0, Smoke::mf_static|Smoke::mf_enum, 40, 28},	//302 Plasma::Animation::MoveRight (enum)
    {33, 315, 0, 0, Smoke::mf_static|Smoke::mf_enum, 40, 29},	//303 Plasma::Animation::MoveDown (enum)
    {33, 316, 0, 0, Smoke::mf_static|Smoke::mf_enum, 40, 30},	//304 Plasma::Animation::MoveLeft (enum)
    {33, 2413, 0, 0, Smoke::mf_dtor, 0, 31 },	//305 Plasma::Animation::~Animation()
    {34, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//306 Plasma::AnimationDriver::metaObject() const
    {34, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//307 Plasma::AnimationDriver::qt_metacast(const char*)
    {34, 2304, 43, 2, Smoke::mf_static, 293, 3},	//308 Plasma::AnimationDriver::tr(const char*, const char*)
    {34, 2308, 43, 2, Smoke::mf_static, 293, 4},	//309 Plasma::AnimationDriver::trUtf8(const char*, const char*)
    {34, 2304, 46, 3, Smoke::mf_static, 293, 5},	//310 Plasma::AnimationDriver::tr(const char*, const char*, int)
    {34, 2308, 46, 3, Smoke::mf_static, 293, 6},	//311 Plasma::AnimationDriver::trUtf8(const char*, const char*, int)
    {34, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//312 Plasma::AnimationDriver::qt_metacall(QMetaObject::Call, int, void**)
    {34, 34, 97, 1, Smoke::mf_ctor, 42, 8},	//313 Plasma::AnimationDriver::AnimationDriver(QObject*)
    {34, 654, 131, 1, Smoke::mf_const|Smoke::mf_virtual, 477, 9},	//314 Plasma::AnimationDriver::animationFps(Plasma::Animator::Animation) const
    {34, 1382, 133, 1, Smoke::mf_const|Smoke::mf_virtual, 477, 10},	//315 Plasma::AnimationDriver::movementAnimationFps(Plasma::Animator::Movement) const
    {34, 919, 131, 1, Smoke::mf_const|Smoke::mf_virtual, 477, 11},	//316 Plasma::AnimationDriver::elementAnimationFps(Plasma::Animator::Animation) const
    {34, 650, 131, 1, Smoke::mf_const|Smoke::mf_virtual, 477, 12},	//317 Plasma::AnimationDriver::animationDuration(Plasma::Animator::Animation) const
    {34, 1380, 133, 1, Smoke::mf_const|Smoke::mf_virtual, 477, 13},	//318 Plasma::AnimationDriver::movementAnimationDuration(Plasma::Animator::Movement) const
    {34, 915, 131, 1, Smoke::mf_const|Smoke::mf_virtual, 477, 14},	//319 Plasma::AnimationDriver::elementAnimationDuration(Plasma::Animator::Animation) const
    {34, 648, 131, 1, Smoke::mf_const|Smoke::mf_virtual, 45, 15},	//320 Plasma::AnimationDriver::animationCurve(Plasma::Animator::Animation) const
    {34, 1378, 133, 1, Smoke::mf_const|Smoke::mf_virtual, 45, 16},	//321 Plasma::AnimationDriver::movementAnimationCurve(Plasma::Animator::Movement) const
    {34, 913, 131, 1, Smoke::mf_const|Smoke::mf_virtual, 45, 17},	//322 Plasma::AnimationDriver::elementAnimationCurve(Plasma::Animator::Animation) const
    {34, 921, 135, 2, Smoke::mf_virtual, 277, 18},	//323 Plasma::AnimationDriver::elementAppear(double, const QPixmap&)
    {34, 925, 135, 2, Smoke::mf_virtual, 277, 19},	//324 Plasma::AnimationDriver::elementDisappear(double, const QPixmap&)
    {34, 1175, 138, 2, Smoke::mf_virtual, 0, 20},	//325 Plasma::AnimationDriver::itemAppear(double, QGraphicsItem*)
    {34, 1183, 138, 2, Smoke::mf_virtual, 0, 21},	//326 Plasma::AnimationDriver::itemDisappear(double, QGraphicsItem*)
    {34, 1170, 138, 2, Smoke::mf_virtual, 0, 22},	//327 Plasma::AnimationDriver::itemActivated(double, QGraphicsItem*)
    {34, 1193, 141, 4, Smoke::mf_virtual, 0, 23},	//328 Plasma::AnimationDriver::itemSlideIn(double, QGraphicsItem*, const QPoint&, const QPoint&)
    {34, 1195, 141, 4, Smoke::mf_virtual, 0, 24},	//329 Plasma::AnimationDriver::itemSlideOut(double, QGraphicsItem*, const QPoint&, const QPoint&)
    {34, 2304, 1, 1, Smoke::mf_static, 293, 25},	//330 Plasma::AnimationDriver::tr(const char*)
    {34, 2308, 1, 1, Smoke::mf_static, 293, 26},	//331 Plasma::AnimationDriver::trUtf8(const char*)
    {34, 34, 0, 0, Smoke::mf_ctor, 42, 27},	//332 Plasma::AnimationDriver::AnimationDriver()
    {34, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 28},	//333 Plasma::AnimationDriver::staticMetaObject() const
    {34, 2414, 0, 0, Smoke::mf_dtor, 0, 29 },	//334 Plasma::AnimationDriver::~AnimationDriver()
    {35, 1351, 0, 0, Smoke::mf_const, 442, 1},	//335 Plasma::Animator::metaObject() const
    {35, 1487, 1, 1, 0, 486, 2},	//336 Plasma::Animator::qt_metacast(const char*)
    {35, 2304, 43, 2, Smoke::mf_static, 293, 3},	//337 Plasma::Animator::tr(const char*, const char*)
    {35, 2308, 43, 2, Smoke::mf_static, 293, 4},	//338 Plasma::Animator::trUtf8(const char*, const char*)
    {35, 2304, 46, 3, Smoke::mf_static, 293, 5},	//339 Plasma::Animator::tr(const char*, const char*, int)
    {35, 2308, 46, 3, Smoke::mf_static, 293, 6},	//340 Plasma::Animator::trUtf8(const char*, const char*, int)
    {35, 1485, 3, 3, 0, 477, 7},	//341 Plasma::Animator::qt_metacall(QMetaObject::Call, int, void**)
    {35, 1646, 0, 0, Smoke::mf_static, 43, 8},	//342 Plasma::Animator::self()
    {35, 800, 146, 2, Smoke::mf_static, 39, 9},	//343 Plasma::Animator::create(Plasma::Animator::Animation, QObject*)
    {35, 800, 149, 2, Smoke::mf_static, 39, 10},	//344 Plasma::Animator::create(const QString&, QObject*)
    {35, 800, 152, 1, Smoke::mf_static, 197, 11},	//345 Plasma::Animator::create(Plasma::Animator::CurveShape)
    {35, 2230, 129, 1, 0, 0, 12},	//346 Plasma::Animator::stopItemAnimation(int)
    {35, 1376, 154, 3, 0, 477, 13},	//347 Plasma::Animator::moveItem(QGraphicsItem*, Plasma::Animator::Movement, const QPoint&)
    {35, 2232, 129, 1, 0, 0, 14},	//348 Plasma::Animator::stopItemMovement(int)
    {35, 831, 158, 5, 0, 477, 15},	//349 Plasma::Animator::customAnimation(int, int, Plasma::Animator::CurveShape, QObject*, const char*)
    {35, 2226, 129, 1, 0, 0, 16},	//350 Plasma::Animator::stopCustomAnimation(int)
    {35, 2228, 129, 1, 0, 0, 17},	//351 Plasma::Animator::stopElementAnimation(int)
    {35, 1877, 164, 2, 0, 0, 18},	//352 Plasma::Animator::setInitialPixmap(int, const QPixmap&)
    {35, 826, 129, 1, 0, 277, 19},	//353 Plasma::Animator::currentPixmap(int)
    {35, 1120, 0, 0, Smoke::mf_const, 386, 20},	//354 Plasma::Animator::isAnimating() const
    {35, 1509, 125, 1, 0, 0, 21},	//355 Plasma::Animator::registerScrollingManager(QGraphicsWidget*)
    {35, 2325, 125, 1, 0, 0, 22},	//356 Plasma::Animator::unregisterScrollingManager(QGraphicsWidget*)
    {35, 652, 167, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 23},	//357 Plasma::Animator::animationFinished(QGraphicsItem*, Plasma::Animator::Animation)
    {35, 1384, 170, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 24},	//358 Plasma::Animator::movementFinished(QGraphicsItem*)
    {35, 917, 129, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 25},	//359 Plasma::Animator::elementAnimationFinished(int)
    {35, 833, 129, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 26},	//360 Plasma::Animator::customAnimationFinished(int)
    {35, 1636, 172, 3, Smoke::mf_protected|Smoke::mf_signal, 0, 27},	//361 Plasma::Animator::scrollStateChanged(QGraphicsWidget*, QAbstractAnimation::State, QAbstractAnimation::State)
    {35, 2289, 176, 1, Smoke::mf_protected, 0, 28},	//362 Plasma::Animator::timerEvent(QTimerEvent*)
    {35, 2304, 1, 1, Smoke::mf_static, 293, 29},	//363 Plasma::Animator::tr(const char*)
    {35, 2308, 1, 1, Smoke::mf_static, 293, 30},	//364 Plasma::Animator::trUtf8(const char*)
    {35, 800, 131, 1, Smoke::mf_static, 39, 31},	//365 Plasma::Animator::create(Plasma::Animator::Animation)
    {35, 800, 89, 1, Smoke::mf_static, 39, 32},	//366 Plasma::Animator::create(const QString&)
    {35, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 33},	//367 Plasma::Animator::staticMetaObject() const
    {35, 37, 0, 0, Smoke::mf_static|Smoke::mf_enum, 44, 34},	//368 Plasma::Animator::AppearAnimation (enum)
    {35, 151, 0, 0, Smoke::mf_static|Smoke::mf_enum, 44, 35},	//369 Plasma::Animator::DisappearAnimation (enum)
    {35, 16, 0, 0, Smoke::mf_static|Smoke::mf_enum, 44, 36},	//370 Plasma::Animator::ActivateAnimation (enum)
    {35, 174, 0, 0, Smoke::mf_static|Smoke::mf_enum, 44, 37},	//371 Plasma::Animator::FadeAnimation (enum)
    {35, 202, 0, 0, Smoke::mf_static|Smoke::mf_enum, 44, 38},	//372 Plasma::Animator::GrowAnimation (enum)
    {35, 384, 0, 0, Smoke::mf_static|Smoke::mf_enum, 44, 39},	//373 Plasma::Animator::PulseAnimation (enum)
    {35, 401, 0, 0, Smoke::mf_static|Smoke::mf_enum, 44, 40},	//374 Plasma::Animator::RotationAnimation (enum)
    {35, 402, 0, 0, Smoke::mf_static|Smoke::mf_enum, 44, 41},	//375 Plasma::Animator::RotationStackedAnimation (enum)
    {35, 444, 0, 0, Smoke::mf_static|Smoke::mf_enum, 44, 42},	//376 Plasma::Animator::SlideAnimation (enum)
    {35, 198, 0, 0, Smoke::mf_static|Smoke::mf_enum, 44, 43},	//377 Plasma::Animator::GeometryAnimation (enum)
    {35, 548, 0, 0, Smoke::mf_static|Smoke::mf_enum, 44, 44},	//378 Plasma::Animator::ZoomAnimation (enum)
    {35, 371, 0, 0, Smoke::mf_static|Smoke::mf_enum, 44, 45},	//379 Plasma::Animator::PixmapTransitionAnimation (enum)
    {35, 543, 0, 0, Smoke::mf_static|Smoke::mf_enum, 44, 46},	//380 Plasma::Animator::WaterAnimation (enum)
    {35, 290, 0, 0, Smoke::mf_static|Smoke::mf_enum, 44, 47},	//381 Plasma::Animator::LastAnimation (enum)
    {35, 158, 0, 0, Smoke::mf_static|Smoke::mf_enum, 45, 48},	//382 Plasma::Animator::EaseInCurve (enum)
    {35, 160, 0, 0, Smoke::mf_static|Smoke::mf_enum, 45, 49},	//383 Plasma::Animator::EaseOutCurve (enum)
    {35, 159, 0, 0, Smoke::mf_static|Smoke::mf_enum, 45, 50},	//384 Plasma::Animator::EaseInOutCurve (enum)
    {35, 302, 0, 0, Smoke::mf_static|Smoke::mf_enum, 45, 51},	//385 Plasma::Animator::LinearCurve (enum)
    {35, 367, 0, 0, Smoke::mf_static|Smoke::mf_enum, 45, 52},	//386 Plasma::Animator::PendularCurve (enum)
    {35, 445, 0, 0, Smoke::mf_static|Smoke::mf_enum, 46, 53},	//387 Plasma::Animator::SlideInMovement (enum)
    {35, 446, 0, 0, Smoke::mf_static|Smoke::mf_enum, 46, 54},	//388 Plasma::Animator::SlideOutMovement (enum)
    {35, 175, 0, 0, Smoke::mf_static|Smoke::mf_enum, 46, 55},	//389 Plasma::Animator::FastSlideInMovement (enum)
    {35, 176, 0, 0, Smoke::mf_static|Smoke::mf_enum, 46, 56},	//390 Plasma::Animator::FastSlideOutMovement (enum)
    {36, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//391 Plasma::Applet::metaObject() const
    {36, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//392 Plasma::Applet::qt_metacast(const char*)
    {36, 2304, 43, 2, Smoke::mf_static, 293, 3},	//393 Plasma::Applet::tr(const char*, const char*)
    {36, 2308, 43, 2, Smoke::mf_static, 293, 4},	//394 Plasma::Applet::trUtf8(const char*, const char*)
    {36, 2304, 46, 3, Smoke::mf_static, 293, 5},	//395 Plasma::Applet::tr(const char*, const char*, int)
    {36, 2308, 46, 3, Smoke::mf_static, 293, 6},	//396 Plasma::Applet::trUtf8(const char*, const char*, int)
    {36, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//397 Plasma::Applet::qt_metacall(QMetaObject::Call, int, void**)
    {36, 1415, 0, 0, Smoke::mf_static, 21, 8},	//398 Plasma::Applet::packageStructure()
    {36, 1077, 0, 0, Smoke::mf_const, 484, 9},	//399 Plasma::Applet::id() const
    {36, 738, 0, 0, Smoke::mf_const, 8, 10},	//400 Plasma::Applet::config() const
    {36, 738, 89, 1, Smoke::mf_const, 8, 11},	//401 Plasma::Applet::config(const QString&) const
    {36, 1607, 178, 1, Smoke::mf_const|Smoke::mf_virtual, 0, 12},	//402 Plasma::Applet::save(KConfigGroup&) const
    {36, 1589, 178, 1, Smoke::mf_virtual, 0, 13},	//403 Plasma::Applet::restore(KConfigGroup&)
    {36, 1029, 0, 0, Smoke::mf_const, 8, 14},	//404 Plasma::Applet::globalConfig() const
    {36, 742, 0, 0, Smoke::mf_const, 67, 15},	//405 Plasma::Applet::configScheme() const
    {36, 839, 89, 1, Smoke::mf_const, 81, 16},	//406 Plasma::Applet::dataEngine(const QString&) const
    {36, 1414, 0, 0, Smoke::mf_const, 409, 17},	//407 Plasma::Applet::package() const
    {36, 2374, 0, 0, Smoke::mf_const, 228, 18},	//408 Plasma::Applet::view() const
    {36, 1329, 180, 2, Smoke::mf_const, 283, 19},	//409 Plasma::Applet::mapFromView(const QGraphicsView*, const QRect&) const
    {36, 1331, 183, 2, Smoke::mf_const, 282, 20},	//410 Plasma::Applet::mapToView(const QGraphicsView*, const QRectF&) const
    {36, 1466, 186, 1, Smoke::mf_const, 279, 21},	//411 Plasma::Applet::popupPosition(const QSize&) const
    {36, 1466, 188, 2, Smoke::mf_const, 279, 22},	//412 Plasma::Applet::popupPosition(const QSize&, Qt::AlignmentFlag) const
    {36, 2332, 191, 1, 0, 0, 23},	//413 Plasma::Applet::updateConstraints(QFlags<Plasma::Constraint>)
    {36, 1012, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 97, 24},	//414 Plasma::Applet::formFactor() const
    {36, 1314, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 112, 25},	//415 Plasma::Applet::location() const
    {36, 788, 0, 0, Smoke::mf_const, 78, 26},	//416 Plasma::Applet::context() const
    {36, 676, 0, 0, Smoke::mf_const, 52, 27},	//417 Plasma::Applet::aspectRatioMode() const
    {36, 1676, 193, 1, 0, 0, 28},	//418 Plasma::Applet::setAspectRatioMode(Plasma::AspectRatioMode)
    {36, 1238, 77, 2, Smoke::mf_static, 242, 29},	//419 Plasma::Applet::listAppletInfo(const QString&, const QString&)
    {36, 1241, 89, 1, Smoke::mf_static, 242, 30},	//420 Plasma::Applet::listAppletInfoForMimetype(const QString&)
    {36, 1243, 195, 1, Smoke::mf_static, 242, 31},	//421 Plasma::Applet::listAppletInfoForUrl(const QUrl&)
    {36, 1247, 197, 2, Smoke::mf_static, 294, 32},	//422 Plasma::Applet::listCategories(const QString&, bool)
    {36, 1757, 200, 1, 0, 0, 33},	//423 Plasma::Applet::setCustomCategories(const QStringList&)
    {36, 835, 0, 0, 0, 294, 34},	//424 Plasma::Applet::customCategories()
    {36, 1303, 202, 3, Smoke::mf_static, 49, 35},	//425 Plasma::Applet::loadPlasmoid(const QString&, unsigned int, const QList<QVariant>&)
    {36, 1281, 202, 3, Smoke::mf_static, 49, 36},	//426 Plasma::Applet::load(const QString&, unsigned int, const QList<QVariant>&)
    {36, 1281, 206, 3, Smoke::mf_static, 49, 37},	//427 Plasma::Applet::load(const KPluginInfo&, unsigned int, const QList<QVariant>&)
    {36, 707, 210, 1, Smoke::mf_static, 293, 38},	//428 Plasma::Applet::category(const KPluginInfo&)
    {36, 707, 89, 1, Smoke::mf_static, 293, 39},	//429 Plasma::Applet::category(const QString&)
    {36, 1437, 212, 3, Smoke::mf_virtual, 0, 40},	//430 Plasma::Applet::paintInterface(QPainter*, const QStyleOptionGraphicsItem*, const QRect&)
    {36, 1386, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 41},	//431 Plasma::Applet::name() const
    {36, 1005, 0, 0, Smoke::mf_const, 211, 42},	//432 Plasma::Applet::font() const
    {36, 1458, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 43},	//433 Plasma::Applet::pluginName() const
    {36, 2163, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 44},	//434 Plasma::Applet::shouldConserveResources() const
    {36, 1075, 0, 0, Smoke::mf_const, 293, 45},	//435 Plasma::Applet::icon() const
    {36, 707, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 46},	//436 Plasma::Applet::category() const
    {36, 1082, 0, 0, Smoke::mf_const|Smoke::mf_property, 105, 47},	//437 Plasma::Applet::immutability() const
    {36, 1439, 216, 3, Smoke::mf_virtual, 0, 48},	//438 Plasma::Applet::paintWindowFrame(QPainter*, const QStyleOptionGraphicsItem*, QWidget*)
    {36, 1045, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 49},	//439 Plasma::Applet::hasFailedToLaunch() const
    {36, 1122, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 50},	//440 Plasma::Applet::isBusy() const
    {36, 745, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 51},	//441 Plasma::Applet::configurationRequired() const
    {36, 1040, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 52},	//442 Plasma::Applet::hasConfigurationInterface() const
    {36, 796, 0, 0, Smoke::mf_virtual, 255, 53},	//443 Plasma::Applet::contextualActions()
    {36, 557, 220, 1, Smoke::mf_const, 183, 54},	//444 Plasma::Applet::action(QString) const
    {36, 574, 222, 2, 0, 0, 55},	//445 Plasma::Applet::addAction(QString, QAction*)
    {36, 1700, 225, 1, 0, 0, 56},	//446 Plasma::Applet::setBackgroundHints(const QFlags<Plasma::Applet::BackgroundHint>)
    {36, 697, 0, 0, Smoke::mf_const, 199, 57},	//447 Plasma::Applet::backgroundHints() const
    {36, 1128, 0, 0, Smoke::mf_const, 386, 58},	//448 Plasma::Applet::isContainment() const
    {36, 1633, 0, 0, Smoke::mf_const, 282, 59},	//449 Plasma::Applet::screenRect() const
    {36, 2313, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 477, 60},	//450 Plasma::Applet::type() const
    {36, 765, 0, 0, Smoke::mf_const, 69, 61},	//451 Plasma::Applet::containment() const
    {36, 1830, 227, 1, 0, 0, 62},	//452 Plasma::Applet::setGlobalShortcut(const KShortcut&)
    {36, 1030, 0, 0, Smoke::mf_const, 22, 63},	//453 Plasma::Applet::globalShortcut() const
    {36, 1145, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 386, 64},	//454 Plasma::Applet::isPopupShowing() const
    {36, 585, 57, 1, Smoke::mf_virtual, 0, 65},	//455 Plasma::Applet::addAssociatedWidget(QWidget*)
    {36, 1534, 57, 1, Smoke::mf_virtual, 0, 66},	//456 Plasma::Applet::removeAssociatedWidget(QWidget*)
    {36, 1093, 229, 1, Smoke::mf_virtual, 0, 67},	//457 Plasma::Applet::initExtenderItem(Plasma::ExtenderItem*)
    {36, 38, 231, 3, Smoke::mf_ctor, 49, 68},	//458 Plasma::Applet::Applet(QGraphicsItem*, const QString&, unsigned int)
    {36, 38, 235, 3, Smoke::mf_ctor, 49, 69},	//459 Plasma::Applet::Applet(const KPluginInfo&, QGraphicsItem*, unsigned int)
    {36, 38, 239, 4, Smoke::mf_ctor, 49, 70},	//460 Plasma::Applet::Applet(QGraphicsItem*, const QString&, unsigned int, const QList<QVariant>&)
    {36, 854, 0, 0, Smoke::mf_const, 386, 71},	//461 Plasma::Applet::destroyed() const
    {36, 805, 244, 1, Smoke::mf_virtual, 0, 72},	//462 Plasma::Applet::createConfigurationInterface(KConfigDialog*)
    {36, 1038, 89, 1, Smoke::mf_const, 386, 73},	//463 Plasma::Applet::hasAuthorization(const QString&) const
    {36, 1678, 89, 1, 0, 0, 74},	//464 Plasma::Applet::setAssociatedApplication(const QString&)
    {36, 1680, 246, 1, 0, 0, 75},	//465 Plasma::Applet::setAssociatedApplicationUrls(const KUrl::List&)
    {36, 681, 0, 0, Smoke::mf_const, 293, 76},	//466 Plasma::Applet::associatedApplication() const
    {36, 682, 0, 0, Smoke::mf_const, 27, 77},	//467 Plasma::Applet::associatedApplicationUrls() const
    {36, 1053, 0, 0, Smoke::mf_const, 386, 78},	//468 Plasma::Applet::hasValidAssociatedApplication() const
    {36, 1515, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 79},	//469 Plasma::Applet::releaseVisualFocus()
    {36, 1020, 0, 0, Smoke::mf_protected, 0, 80},	//470 Plasma::Applet::geometryChanged()
    {36, 672, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 81},	//471 Plasma::Applet::appletTransformedByUser()
    {36, 673, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 82},	//472 Plasma::Applet::appletTransformedItself()
    {36, 2202, 248, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 83},	//473 Plasma::Applet::sizeHintChanged(Qt::SizeHint)
    {36, 741, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 84},	//474 Plasma::Applet::configNeedsSaving()
    {36, 568, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 85},	//475 Plasma::Applet::activate()
    {36, 1349, 250, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 86},	//476 Plasma::Applet::messageButtonPressed(const Plasma::MessageButton)
    {36, 667, 252, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 87},	//477 Plasma::Applet::appletDestroyed(Plasma::Applet*)
    {36, 1391, 254, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 88},	//478 Plasma::Applet::newStatus(Plasma::ItemStatus)
    {36, 967, 229, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 89},	//479 Plasma::Applet::extenderItemRestored(Plasma::ExtenderItem*)
    {36, 1083, 256, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 90},	//480 Plasma::Applet::immutabilityChanged(Plasma::ImmutabilityType)
    {36, 1871, 258, 1, Smoke::mf_property|Smoke::mf_slot, 0, 91},	//481 Plasma::Applet::setImmutability(const Plasma::ImmutabilityType)
    {36, 852, 0, 0, Smoke::mf_virtual|Smoke::mf_slot, 0, 92},	//482 Plasma::Applet::destroy()
    {36, 2169, 0, 0, Smoke::mf_virtual|Smoke::mf_slot, 0, 93},	//483 Plasma::Applet::showConfigurationInterface()
    {36, 2169, 57, 1, Smoke::mf_slot, 0, 94},	//484 Plasma::Applet::showConfigurationInterface(QWidget*)
    {36, 1161, 0, 0, Smoke::mf_const|Smoke::mf_property|Smoke::mf_slot, 386, 95},	//485 Plasma::Applet::isUserConfiguring() const
    {36, 1492, 0, 0, Smoke::mf_slot, 0, 96},	//486 Plasma::Applet::raise()
    {36, 1322, 0, 0, Smoke::mf_slot, 0, 97},	//487 Plasma::Applet::lower()
    {36, 995, 0, 0, Smoke::mf_slot, 0, 98},	//488 Plasma::Applet::flushPendingConstraintsEvents()
    {36, 1091, 0, 0, Smoke::mf_virtual|Smoke::mf_slot, 0, 99},	//489 Plasma::Applet::init()
    {36, 740, 0, 0, Smoke::mf_virtual|Smoke::mf_slot, 0, 100},	//490 Plasma::Applet::configChanged()
    {36, 1704, 7, 1, Smoke::mf_property|Smoke::mf_slot, 0, 101},	//491 Plasma::Applet::setBusy(bool)
    {36, 2221, 0, 0, Smoke::mf_const|Smoke::mf_slot, 305, 102},	//492 Plasma::Applet::startupArguments() const
    {36, 2224, 0, 0, Smoke::mf_const|Smoke::mf_slot, 108, 103},	//493 Plasma::Applet::status() const
    {36, 2043, 260, 1, Smoke::mf_slot, 0, 104},	//494 Plasma::Applet::setStatus(const Plasma::ItemStatus)
    {36, 1483, 262, 2, Smoke::mf_slot, 0, 105},	//495 Plasma::Applet::publish(Plasma::AnnouncementMethods, const QString&)
    {36, 2322, 0, 0, Smoke::mf_slot, 0, 106},	//496 Plasma::Applet::unpublish()
    {36, 1147, 0, 0, Smoke::mf_const|Smoke::mf_slot, 386, 107},	//497 Plasma::Applet::isPublished() const
    {36, 1601, 0, 0, Smoke::mf_slot, 0, 108},	//498 Plasma::Applet::runAssociatedApplication()
    {36, 38, 70, 2, Smoke::mf_ctor|Smoke::mf_protected, 49, 109},	//499 Plasma::Applet::Applet(QObject*, const QList<QVariant>&)
    {36, 1814, 265, 2, Smoke::mf_protected, 0, 110},	//500 Plasma::Applet::setFailedToLaunch(bool, const QString&)
    {36, 1613, 178, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 0, 111},	//501 Plasma::Applet::saveState(KConfigGroup&) const
    {36, 1839, 7, 1, Smoke::mf_protected, 0, 112},	//502 Plasma::Applet::setHasConfigurationInterface(bool)
    {36, 1726, 265, 2, Smoke::mf_protected, 0, 113},	//503 Plasma::Applet::setConfigurationRequired(bool, const QString&)
    {36, 2181, 268, 3, Smoke::mf_protected, 0, 114},	//504 Plasma::Applet::showMessage(const QIcon&, const QString&, const QFlags<Plasma::MessageButton>)
    {36, 760, 191, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 115},	//505 Plasma::Applet::constraintsEvent(QFlags<Plasma::Constraint>)
    {36, 1502, 170, 1, Smoke::mf_protected, 0, 116},	//506 Plasma::Applet::registerAsDragHandle(QGraphicsItem*)
    {36, 2323, 170, 1, Smoke::mf_protected, 0, 117},	//507 Plasma::Applet::unregisterAsDragHandle(QGraphicsItem*)
    {36, 1149, 170, 1, Smoke::mf_protected, 386, 118},	//508 Plasma::Applet::isRegisteredAsDragHandle(QGraphicsItem*)
    {36, 966, 0, 0, Smoke::mf_const|Smoke::mf_protected, 91, 119},	//509 Plasma::Applet::extender() const
    {36, 954, 272, 2, Smoke::mf_protected|Smoke::mf_virtual, 386, 120},	//510 Plasma::Applet::eventFilter(QObject*, QEvent*)
    {36, 1621, 275, 2, Smoke::mf_protected|Smoke::mf_virtual, 386, 121},	//511 Plasma::Applet::sceneEventFilter(QGraphicsItem*, QEvent*)
    {36, 1368, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 122},	//512 Plasma::Applet::mouseMoveEvent(QGraphicsSceneMouseEvent*)
    {36, 998, 280, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 123},	//513 Plasma::Applet::focusInEvent(QFocusEvent*)
    {36, 1584, 282, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 124},	//514 Plasma::Applet::resizeEvent(QGraphicsSceneResizeEvent*)
    {36, 1179, 284, 2, Smoke::mf_protected|Smoke::mf_virtual, 304, 125},	//515 Plasma::Applet::itemChange(QGraphicsItem::GraphicsItemChange, const QVariant&)
    {36, 2161, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 276, 126},	//516 Plasma::Applet::shape() const
    {36, 2198, 287, 2, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 291, 127},	//517 Plasma::Applet::sizeHint(Qt::SizeHint, const QSizeF&) const
    {36, 1068, 290, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 128},	//518 Plasma::Applet::hoverEnterEvent(QGraphicsSceneHoverEvent*)
    {36, 1070, 290, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 129},	//519 Plasma::Applet::hoverLeaveEvent(QGraphicsSceneHoverEvent*)
    {36, 2289, 176, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 130},	//520 Plasma::Applet::timerEvent(QTimerEvent*)
    {36, 2304, 1, 1, Smoke::mf_static, 293, 131},	//521 Plasma::Applet::tr(const char*)
    {36, 2308, 1, 1, Smoke::mf_static, 293, 132},	//522 Plasma::Applet::trUtf8(const char*)
    {36, 2332, 0, 0, 0, 0, 133},	//523 Plasma::Applet::updateConstraints()
    {36, 1238, 0, 0, Smoke::mf_static, 242, 134},	//524 Plasma::Applet::listAppletInfo()
    {36, 1238, 89, 1, Smoke::mf_static, 242, 135},	//525 Plasma::Applet::listAppletInfo(const QString&)
    {36, 1247, 0, 0, Smoke::mf_static, 294, 136},	//526 Plasma::Applet::listCategories()
    {36, 1247, 89, 1, Smoke::mf_static, 294, 137},	//527 Plasma::Applet::listCategories(const QString&)
    {36, 1303, 89, 1, Smoke::mf_static, 49, 138},	//528 Plasma::Applet::loadPlasmoid(const QString&)
    {36, 1303, 292, 2, Smoke::mf_static, 49, 139},	//529 Plasma::Applet::loadPlasmoid(const QString&, unsigned int)
    {36, 1281, 89, 1, Smoke::mf_static, 49, 140},	//530 Plasma::Applet::load(const QString&)
    {36, 1281, 292, 2, Smoke::mf_static, 49, 141},	//531 Plasma::Applet::load(const QString&, unsigned int)
    {36, 1281, 210, 1, Smoke::mf_static, 49, 142},	//532 Plasma::Applet::load(const KPluginInfo&)
    {36, 1281, 295, 2, Smoke::mf_static, 49, 143},	//533 Plasma::Applet::load(const KPluginInfo&, unsigned int)
    {36, 38, 0, 0, Smoke::mf_ctor, 49, 144},	//534 Plasma::Applet::Applet()
    {36, 38, 170, 1, Smoke::mf_ctor, 49, 145},	//535 Plasma::Applet::Applet(QGraphicsItem*)
    {36, 38, 298, 2, Smoke::mf_ctor, 49, 146},	//536 Plasma::Applet::Applet(QGraphicsItem*, const QString&)
    {36, 38, 210, 1, Smoke::mf_ctor, 49, 147},	//537 Plasma::Applet::Applet(const KPluginInfo&)
    {36, 38, 301, 2, Smoke::mf_ctor, 49, 148},	//538 Plasma::Applet::Applet(const KPluginInfo&, QGraphicsItem*)
    {36, 1814, 7, 1, Smoke::mf_protected, 0, 149},	//539 Plasma::Applet::setFailedToLaunch(bool)
    {36, 1726, 7, 1, Smoke::mf_protected, 0, 150},	//540 Plasma::Applet::setConfigurationRequired(bool)
    {36, 2198, 248, 1, Smoke::mf_const|Smoke::mf_protected, 291, 151},	//541 Plasma::Applet::sizeHint(Qt::SizeHint) const
    {36, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 152},	//542 Plasma::Applet::staticMetaObject() const
    {36, 326, 0, 0, Smoke::mf_static|Smoke::mf_enum, 50, 153},	//543 Plasma::Applet::NoBackground (enum)
    {36, 457, 0, 0, Smoke::mf_static|Smoke::mf_enum, 50, 154},	//544 Plasma::Applet::StandardBackground (enum)
    {36, 503, 0, 0, Smoke::mf_static|Smoke::mf_enum, 50, 155},	//545 Plasma::Applet::TranslucentBackground (enum)
    {36, 132, 0, 0, Smoke::mf_static|Smoke::mf_enum, 50, 156},	//546 Plasma::Applet::DefaultBackground (enum)
    {36, 508, 0, 0, Smoke::mf_static|Smoke::mf_enum, 479, 157},	//547 Plasma::Applet::Type (enum)
    {36, 2415, 0, 0, Smoke::mf_dtor, 0, 158 },	//548 Plasma::Applet::~Applet()
    {37, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//549 Plasma::AppletScript::metaObject() const
    {37, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//550 Plasma::AppletScript::qt_metacast(const char*)
    {37, 2304, 43, 2, Smoke::mf_static, 293, 3},	//551 Plasma::AppletScript::tr(const char*, const char*)
    {37, 2308, 43, 2, Smoke::mf_static, 293, 4},	//552 Plasma::AppletScript::trUtf8(const char*, const char*)
    {37, 2304, 46, 3, Smoke::mf_static, 293, 5},	//553 Plasma::AppletScript::tr(const char*, const char*, int)
    {37, 2308, 46, 3, Smoke::mf_static, 293, 6},	//554 Plasma::AppletScript::trUtf8(const char*, const char*, int)
    {37, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//555 Plasma::AppletScript::qt_metacall(QMetaObject::Call, int, void**)
    {37, 47, 97, 1, Smoke::mf_ctor, 51, 8},	//556 Plasma::AppletScript::AppletScript(QObject*)
    {37, 1670, 252, 1, 0, 0, 9},	//557 Plasma::AppletScript::setApplet(Plasma::Applet*)
    {37, 664, 0, 0, Smoke::mf_const, 49, 10},	//558 Plasma::AppletScript::applet() const
    {37, 1437, 212, 3, Smoke::mf_virtual, 0, 11},	//559 Plasma::AppletScript::paintInterface(QPainter*, const QStyleOptionGraphicsItem*, const QRect&)
    {37, 2194, 0, 0, Smoke::mf_const, 291, 12},	//560 Plasma::AppletScript::size() const
    {37, 760, 191, 1, Smoke::mf_virtual, 0, 13},	//561 Plasma::AppletScript::constraintsEvent(QFlags<Plasma::Constraint>)
    {37, 796, 0, 0, Smoke::mf_virtual, 255, 14},	//562 Plasma::AppletScript::contextualActions()
    {37, 2161, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 276, 15},	//563 Plasma::AppletScript::shape() const
    {37, 1839, 7, 1, 0, 0, 16},	//564 Plasma::AppletScript::setHasConfigurationInterface(bool)
    {37, 1726, 265, 2, 0, 0, 17},	//565 Plasma::AppletScript::setConfigurationRequired(bool, const QString&)
    {37, 1814, 265, 2, 0, 0, 18},	//566 Plasma::AppletScript::setFailedToLaunch(bool, const QString&)
    {37, 741, 0, 0, Smoke::mf_const, 0, 19},	//567 Plasma::AppletScript::configNeedsSaving() const
    {37, 966, 0, 0, Smoke::mf_const, 91, 20},	//568 Plasma::AppletScript::extender() const
    {37, 903, 0, 0, Smoke::mf_const, 386, 21},	//569 Plasma::AppletScript::drawWallpaper() const
    {37, 1791, 7, 1, 0, 0, 22},	//570 Plasma::AppletScript::setDrawWallpaper(bool)
    {37, 779, 0, 0, Smoke::mf_const, 73, 23},	//571 Plasma::AppletScript::containmentType() const
    {37, 1735, 304, 1, 0, 0, 24},	//572 Plasma::AppletScript::setContainmentType(Plasma::Containment::Type)
    {37, 1613, 178, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_signal, 0, 25},	//573 Plasma::AppletScript::saveState(KConfigGroup&) const
    {37, 1462, 7, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_signal, 0, 26},	//574 Plasma::AppletScript::popupEvent(bool) const
    {37, 2169, 0, 0, Smoke::mf_virtual|Smoke::mf_slot, 0, 27},	//575 Plasma::AppletScript::showConfigurationInterface()
    {37, 740, 0, 0, Smoke::mf_virtual|Smoke::mf_slot, 0, 28},	//576 Plasma::AppletScript::configChanged()
    {37, 839, 89, 1, Smoke::mf_const|Smoke::mf_protected, 81, 29},	//577 Plasma::AppletScript::dataEngine(const QString&) const
    {37, 1324, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 293, 30},	//578 Plasma::AppletScript::mainScript() const
    {37, 1414, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 409, 31},	//579 Plasma::AppletScript::package() const
    {37, 849, 0, 0, Smoke::mf_const|Smoke::mf_protected, 14, 32},	//580 Plasma::AppletScript::description() const
    {37, 2216, 0, 0, Smoke::mf_protected, 7, 33},	//581 Plasma::AppletScript::standardConfigurationDialog()
    {37, 624, 244, 1, Smoke::mf_protected, 0, 34},	//582 Plasma::AppletScript::addStandardConfigurationPages(KConfigDialog*)
    {37, 2181, 268, 3, Smoke::mf_protected, 0, 35},	//583 Plasma::AppletScript::showMessage(const QIcon&, const QString&, const QFlags<Plasma::MessageButton>)
    {37, 1502, 170, 1, Smoke::mf_protected, 0, 36},	//584 Plasma::AppletScript::registerAsDragHandle(QGraphicsItem*)
    {37, 2323, 170, 1, Smoke::mf_protected, 0, 37},	//585 Plasma::AppletScript::unregisterAsDragHandle(QGraphicsItem*)
    {37, 1149, 170, 1, Smoke::mf_protected, 386, 38},	//586 Plasma::AppletScript::isRegisteredAsDragHandle(QGraphicsItem*)
    {37, 1294, 149, 2, Smoke::mf_protected, 39, 39},	//587 Plasma::AppletScript::loadAnimationFromPackage(const QString&, QObject*)
    {37, 2304, 1, 1, Smoke::mf_static, 293, 40},	//588 Plasma::AppletScript::tr(const char*)
    {37, 2308, 1, 1, Smoke::mf_static, 293, 41},	//589 Plasma::AppletScript::trUtf8(const char*)
    {37, 47, 0, 0, Smoke::mf_ctor, 51, 42},	//590 Plasma::AppletScript::AppletScript()
    {37, 1726, 7, 1, 0, 0, 43},	//591 Plasma::AppletScript::setConfigurationRequired(bool)
    {37, 1814, 7, 1, 0, 0, 44},	//592 Plasma::AppletScript::setFailedToLaunch(bool)
    {37, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 45},	//593 Plasma::AppletScript::staticMetaObject() const
    {37, 2416, 0, 0, Smoke::mf_dtor, 0, 46 },	//594 Plasma::AppletScript::~AppletScript()
    {38, 686, 306, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 1},	//595 Plasma::AuthorizationInterface::authorizationRequest(Plasma::AuthorizationRule&) [pure virtual]
    {38, 728, 308, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 2},	//596 Plasma::AuthorizationInterface::clientPinRequest(Plasma::ClientPinRequest&) [pure virtual]
    {38, 51, 0, 0, Smoke::mf_ctor|Smoke::mf_protected, 53, 3},	//597 Plasma::AuthorizationInterface::AuthorizationInterface()
    {38, 51, 310, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 53, 4},	//598 Plasma::AuthorizationInterface::AuthorizationInterface(const Plasma::AuthorizationInterface&)
    {38, 2417, 0, 0, Smoke::mf_dtor, 0, 5 },	//599 Plasma::AuthorizationInterface::~AuthorizationInterface()
    {39, 1351, 0, 0, Smoke::mf_const, 442, 1},	//600 Plasma::AuthorizationManager::metaObject() const
    {39, 1487, 1, 1, 0, 486, 2},	//601 Plasma::AuthorizationManager::qt_metacast(const char*)
    {39, 2304, 43, 2, Smoke::mf_static, 293, 3},	//602 Plasma::AuthorizationManager::tr(const char*, const char*)
    {39, 2308, 43, 2, Smoke::mf_static, 293, 4},	//603 Plasma::AuthorizationManager::trUtf8(const char*, const char*)
    {39, 2304, 46, 3, Smoke::mf_static, 293, 5},	//604 Plasma::AuthorizationManager::tr(const char*, const char*, int)
    {39, 2308, 46, 3, Smoke::mf_static, 293, 6},	//605 Plasma::AuthorizationManager::trUtf8(const char*, const char*, int)
    {39, 1485, 3, 3, 0, 477, 7},	//606 Plasma::AuthorizationManager::qt_metacall(QMetaObject::Call, int, void**)
    {39, 1646, 0, 0, Smoke::mf_static, 54, 8},	//607 Plasma::AuthorizationManager::self()
    {39, 1686, 312, 1, 0, 0, 9},	//608 Plasma::AuthorizationManager::setAuthorizationPolicy(Plasma::AuthorizationManager::AuthorizationPolicy)
    {39, 1684, 314, 1, 0, 0, 10},	//609 Plasma::AuthorizationManager::setAuthorizationInterface(Plasma::AuthorizationInterface*)
    {39, 1497, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 11},	//610 Plasma::AuthorizationManager::readyForRemoteAccess()
    {39, 2304, 1, 1, Smoke::mf_static, 293, 12},	//611 Plasma::AuthorizationManager::tr(const char*)
    {39, 2308, 1, 1, Smoke::mf_static, 293, 13},	//612 Plasma::AuthorizationManager::trUtf8(const char*)
    {39, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 14},	//613 Plasma::AuthorizationManager::staticMetaObject() const
    {39, 139, 0, 0, Smoke::mf_static|Smoke::mf_enum, 55, 15},	//614 Plasma::AuthorizationManager::DenyAll (enum)
    {39, 507, 0, 0, Smoke::mf_static|Smoke::mf_enum, 55, 16},	//615 Plasma::AuthorizationManager::TrustedOnly (enum)
    {39, 369, 0, 0, Smoke::mf_static|Smoke::mf_enum, 55, 17},	//616 Plasma::AuthorizationManager::PinPairing (enum)
    {39, 119, 0, 0, Smoke::mf_static|Smoke::mf_enum, 55, 18},	//617 Plasma::AuthorizationManager::Custom (enum)
    {40, 1351, 0, 0, Smoke::mf_const, 442, 1},	//618 Plasma::AuthorizationRule::metaObject() const
    {40, 1487, 1, 1, 0, 486, 2},	//619 Plasma::AuthorizationRule::qt_metacast(const char*)
    {40, 2304, 43, 2, Smoke::mf_static, 293, 3},	//620 Plasma::AuthorizationRule::tr(const char*, const char*)
    {40, 2308, 43, 2, Smoke::mf_static, 293, 4},	//621 Plasma::AuthorizationRule::trUtf8(const char*, const char*)
    {40, 2304, 46, 3, Smoke::mf_static, 293, 5},	//622 Plasma::AuthorizationRule::tr(const char*, const char*, int)
    {40, 2308, 46, 3, Smoke::mf_static, 293, 6},	//623 Plasma::AuthorizationRule::trUtf8(const char*, const char*, int)
    {40, 1485, 3, 3, 0, 477, 7},	//624 Plasma::AuthorizationRule::qt_metacall(QMetaObject::Call, int, void**)
    {40, 849, 0, 0, Smoke::mf_const, 293, 8},	//625 Plasma::AuthorizationRule::description() const
    {40, 1955, 316, 1, 0, 0, 9},	//626 Plasma::AuthorizationRule::setPolicy(Plasma::AuthorizationRule::Policy)
    {40, 1459, 0, 0, 0, 59, 10},	//627 Plasma::AuthorizationRule::policy()
    {40, 1949, 318, 1, 0, 0, 11},	//628 Plasma::AuthorizationRule::setPersistence(Plasma::AuthorizationRule::Persistence)
    {40, 1452, 0, 0, 0, 58, 12},	//629 Plasma::AuthorizationRule::persistence()
    {40, 2078, 320, 1, 0, 0, 13},	//630 Plasma::AuthorizationRule::setTargets(QFlags<Plasma::AuthorizationRule::Target>)
    {40, 2272, 0, 0, 0, 200, 14},	//631 Plasma::AuthorizationRule::targets()
    {40, 1951, 89, 1, 0, 0, 15},	//632 Plasma::AuthorizationRule::setPin(const QString&)
    {40, 1453, 0, 0, Smoke::mf_const, 293, 16},	//633 Plasma::AuthorizationRule::pin() const
    {40, 1650, 0, 0, Smoke::mf_const, 293, 17},	//634 Plasma::AuthorizationRule::serviceName() const
    {40, 712, 322, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 18},	//635 Plasma::AuthorizationRule::changed(Plasma::AuthorizationRule*)
    {40, 2304, 1, 1, Smoke::mf_static, 293, 19},	//636 Plasma::AuthorizationRule::tr(const char*)
    {40, 2308, 1, 1, Smoke::mf_static, 293, 20},	//637 Plasma::AuthorizationRule::trUtf8(const char*)
    {40, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 21},	//638 Plasma::AuthorizationRule::staticMetaObject() const
    {40, 138, 0, 0, Smoke::mf_static|Smoke::mf_enum, 59, 22},	//639 Plasma::AuthorizationRule::Deny (enum)
    {40, 28, 0, 0, Smoke::mf_static|Smoke::mf_enum, 59, 23},	//640 Plasma::AuthorizationRule::Allow (enum)
    {40, 370, 0, 0, Smoke::mf_static|Smoke::mf_enum, 59, 24},	//641 Plasma::AuthorizationRule::PinRequired (enum)
    {40, 502, 0, 0, Smoke::mf_static|Smoke::mf_enum, 58, 25},	//642 Plasma::AuthorizationRule::Transient (enum)
    {40, 368, 0, 0, Smoke::mf_static|Smoke::mf_enum, 58, 26},	//643 Plasma::AuthorizationRule::Persistent (enum)
    {40, 131, 0, 0, Smoke::mf_static|Smoke::mf_enum, 60, 27},	//644 Plasma::AuthorizationRule::Default (enum)
    {40, 27, 0, 0, Smoke::mf_static|Smoke::mf_enum, 60, 28},	//645 Plasma::AuthorizationRule::AllUsers (enum)
    {40, 26, 0, 0, Smoke::mf_static|Smoke::mf_enum, 60, 29},	//646 Plasma::AuthorizationRule::AllServices (enum)
    {40, 2418, 0, 0, Smoke::mf_dtor, 0, 30 },	//647 Plasma::AuthorizationRule::~AuthorizationRule()
    {41, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//648 Plasma::BusyWidget::metaObject() const
    {41, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//649 Plasma::BusyWidget::qt_metacast(const char*)
    {41, 2304, 43, 2, Smoke::mf_static, 293, 3},	//650 Plasma::BusyWidget::tr(const char*, const char*)
    {41, 2308, 43, 2, Smoke::mf_static, 293, 4},	//651 Plasma::BusyWidget::trUtf8(const char*, const char*)
    {41, 2304, 46, 3, Smoke::mf_static, 293, 5},	//652 Plasma::BusyWidget::tr(const char*, const char*, int)
    {41, 2308, 46, 3, Smoke::mf_static, 293, 6},	//653 Plasma::BusyWidget::trUtf8(const char*, const char*, int)
    {41, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//654 Plasma::BusyWidget::qt_metacall(QMetaObject::Call, int, void**)
    {41, 68, 125, 1, Smoke::mf_ctor, 61, 8},	//655 Plasma::BusyWidget::BusyWidget(QGraphicsWidget*)
    {41, 2000, 7, 1, Smoke::mf_property, 0, 9},	//656 Plasma::BusyWidget::setRunning(bool)
    {41, 1153, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 10},	//657 Plasma::BusyWidget::isRunning() const
    {41, 1883, 89, 1, Smoke::mf_property, 0, 11},	//658 Plasma::BusyWidget::setLabel(const QString&)
    {41, 1206, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 12},	//659 Plasma::BusyWidget::label() const
    {41, 726, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 13},	//660 Plasma::BusyWidget::clicked()
    {41, 1420, 216, 3, Smoke::mf_protected|Smoke::mf_virtual, 0, 14},	//661 Plasma::BusyWidget::paint(QPainter*, const QStyleOptionGraphicsItem*, QWidget*)
    {41, 2177, 324, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 15},	//662 Plasma::BusyWidget::showEvent(QShowEvent*)
    {41, 1059, 326, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 16},	//663 Plasma::BusyWidget::hideEvent(QHideEvent*)
    {41, 1584, 282, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 17},	//664 Plasma::BusyWidget::resizeEvent(QGraphicsSceneResizeEvent*)
    {41, 1370, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 18},	//665 Plasma::BusyWidget::mousePressEvent(QGraphicsSceneMouseEvent*)
    {41, 1372, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 19},	//666 Plasma::BusyWidget::mouseReleaseEvent(QGraphicsSceneMouseEvent*)
    {41, 2289, 176, 1, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_slot, 0, 20},	//667 Plasma::BusyWidget::timerEvent(QTimerEvent*)
    {41, 2304, 1, 1, Smoke::mf_static, 293, 21},	//668 Plasma::BusyWidget::tr(const char*)
    {41, 2308, 1, 1, Smoke::mf_static, 293, 22},	//669 Plasma::BusyWidget::trUtf8(const char*)
    {41, 68, 0, 0, Smoke::mf_ctor, 61, 23},	//670 Plasma::BusyWidget::BusyWidget()
    {41, 1420, 328, 2, Smoke::mf_protected, 0, 24},	//671 Plasma::BusyWidget::paint(QPainter*, const QStyleOptionGraphicsItem*)
    {41, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 25},	//672 Plasma::BusyWidget::staticMetaObject() const
    {41, 2419, 0, 0, Smoke::mf_dtor, 0, 26 },	//673 Plasma::BusyWidget::~BusyWidget()
    {42, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//674 Plasma::CheckBox::metaObject() const
    {42, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//675 Plasma::CheckBox::qt_metacast(const char*)
    {42, 2304, 43, 2, Smoke::mf_static, 293, 3},	//676 Plasma::CheckBox::tr(const char*, const char*)
    {42, 2308, 43, 2, Smoke::mf_static, 293, 4},	//677 Plasma::CheckBox::trUtf8(const char*, const char*)
    {42, 2304, 46, 3, Smoke::mf_static, 293, 5},	//678 Plasma::CheckBox::tr(const char*, const char*, int)
    {42, 2308, 46, 3, Smoke::mf_static, 293, 6},	//679 Plasma::CheckBox::trUtf8(const char*, const char*, int)
    {42, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//680 Plasma::CheckBox::qt_metacall(QMetaObject::Call, int, void**)
    {42, 86, 125, 1, Smoke::mf_ctor, 62, 8},	//681 Plasma::CheckBox::CheckBox(QGraphicsWidget*)
    {42, 2080, 89, 1, Smoke::mf_property, 0, 9},	//682 Plasma::CheckBox::setText(const QString&)
    {42, 2274, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 10},	//683 Plasma::CheckBox::text() const
    {42, 1865, 89, 1, Smoke::mf_property, 0, 11},	//684 Plasma::CheckBox::setImage(const QString&)
    {42, 1079, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 12},	//685 Plasma::CheckBox::image() const
    {42, 2048, 89, 1, Smoke::mf_property, 0, 13},	//686 Plasma::CheckBox::setStyleSheet(const QString&)
    {42, 2236, 0, 0, Smoke::mf_property, 293, 14},	//687 Plasma::CheckBox::styleSheet()
    {42, 1388, 0, 0, Smoke::mf_const, 186, 15},	//688 Plasma::CheckBox::nativeWidget() const
    {42, 1714, 7, 1, Smoke::mf_property, 0, 16},	//689 Plasma::CheckBox::setChecked(bool)
    {42, 1124, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 17},	//690 Plasma::CheckBox::isChecked() const
    {42, 2293, 7, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 18},	//691 Plasma::CheckBox::toggled(bool)
    {42, 1584, 282, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 19},	//692 Plasma::CheckBox::resizeEvent(QGraphicsSceneResizeEvent*)
    {42, 710, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 20},	//693 Plasma::CheckBox::changeEvent(QEvent*)
    {42, 2304, 1, 1, Smoke::mf_static, 293, 21},	//694 Plasma::CheckBox::tr(const char*)
    {42, 2308, 1, 1, Smoke::mf_static, 293, 22},	//695 Plasma::CheckBox::trUtf8(const char*)
    {42, 86, 0, 0, Smoke::mf_ctor, 62, 23},	//696 Plasma::CheckBox::CheckBox()
    {42, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 24},	//697 Plasma::CheckBox::staticMetaObject() const
    {42, 2420, 0, 0, Smoke::mf_dtor, 0, 25 },	//698 Plasma::CheckBox::~CheckBox()
    {43, 1351, 0, 0, Smoke::mf_const, 442, 1},	//699 Plasma::ClientPinRequest::metaObject() const
    {43, 1487, 1, 1, 0, 486, 2},	//700 Plasma::ClientPinRequest::qt_metacast(const char*)
    {43, 2304, 43, 2, Smoke::mf_static, 293, 3},	//701 Plasma::ClientPinRequest::tr(const char*, const char*)
    {43, 2308, 43, 2, Smoke::mf_static, 293, 4},	//702 Plasma::ClientPinRequest::trUtf8(const char*, const char*)
    {43, 2304, 46, 3, Smoke::mf_static, 293, 5},	//703 Plasma::ClientPinRequest::tr(const char*, const char*, int)
    {43, 2308, 46, 3, Smoke::mf_static, 293, 6},	//704 Plasma::ClientPinRequest::trUtf8(const char*, const char*, int)
    {43, 1485, 3, 3, 0, 477, 7},	//705 Plasma::ClientPinRequest::qt_metacall(QMetaObject::Call, int, void**)
    {43, 849, 0, 0, Smoke::mf_const, 293, 8},	//706 Plasma::ClientPinRequest::description() const
    {43, 1951, 89, 1, 0, 0, 9},	//707 Plasma::ClientPinRequest::setPin(const QString&)
    {43, 1453, 0, 0, Smoke::mf_const, 293, 10},	//708 Plasma::ClientPinRequest::pin() const
    {43, 712, 333, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 11},	//709 Plasma::ClientPinRequest::changed(Plasma::ClientPinRequest*)
    {43, 2304, 1, 1, Smoke::mf_static, 293, 12},	//710 Plasma::ClientPinRequest::tr(const char*)
    {43, 2308, 1, 1, Smoke::mf_static, 293, 13},	//711 Plasma::ClientPinRequest::trUtf8(const char*)
    {43, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 14},	//712 Plasma::ClientPinRequest::staticMetaObject() const
    {44, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//713 Plasma::ComboBox::metaObject() const
    {44, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//714 Plasma::ComboBox::qt_metacast(const char*)
    {44, 2304, 43, 2, Smoke::mf_static, 293, 3},	//715 Plasma::ComboBox::tr(const char*, const char*)
    {44, 2308, 43, 2, Smoke::mf_static, 293, 4},	//716 Plasma::ComboBox::trUtf8(const char*, const char*)
    {44, 2304, 46, 3, Smoke::mf_static, 293, 5},	//717 Plasma::ComboBox::tr(const char*, const char*, int)
    {44, 2308, 46, 3, Smoke::mf_static, 293, 6},	//718 Plasma::ComboBox::trUtf8(const char*, const char*, int)
    {44, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//719 Plasma::ComboBox::qt_metacall(QMetaObject::Call, int, void**)
    {44, 89, 125, 1, Smoke::mf_ctor, 65, 8},	//720 Plasma::ComboBox::ComboBox(QGraphicsWidget*)
    {44, 2274, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 9},	//721 Plasma::ComboBox::text() const
    {44, 2048, 89, 1, Smoke::mf_property, 0, 10},	//722 Plasma::ComboBox::setStyleSheet(const QString&)
    {44, 2236, 0, 0, Smoke::mf_property, 293, 11},	//723 Plasma::ComboBox::styleSheet()
    {44, 1923, 335, 1, 0, 0, 12},	//724 Plasma::ComboBox::setNativeWidget(KComboBox*)
    {44, 1388, 0, 0, Smoke::mf_const, 5, 13},	//725 Plasma::ComboBox::nativeWidget() const
    {44, 601, 89, 1, 0, 0, 14},	//726 Plasma::ComboBox::addItem(const QString&)
    {44, 799, 0, 0, Smoke::mf_const|Smoke::mf_property, 477, 15},	//727 Plasma::ComboBox::count() const
    {44, 823, 0, 0, Smoke::mf_const|Smoke::mf_property, 477, 16},	//728 Plasma::ComboBox::currentIndex() const
    {44, 1755, 129, 1, Smoke::mf_property, 0, 17},	//729 Plasma::ComboBox::setCurrentIndex(int)
    {44, 717, 0, 0, Smoke::mf_slot, 0, 18},	//730 Plasma::ComboBox::clear()
    {44, 569, 89, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 19},	//731 Plasma::ComboBox::activated(const QString&)
    {44, 2276, 89, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 20},	//732 Plasma::ComboBox::textChanged(const QString&)
    {44, 824, 129, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 21},	//733 Plasma::ComboBox::currentIndexChanged(int)
    {44, 1584, 282, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 22},	//734 Plasma::ComboBox::resizeEvent(QGraphicsSceneResizeEvent*)
    {44, 1420, 216, 3, Smoke::mf_protected|Smoke::mf_virtual, 0, 23},	//735 Plasma::ComboBox::paint(QPainter*, const QStyleOptionGraphicsItem*, QWidget*)
    {44, 998, 280, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 24},	//736 Plasma::ComboBox::focusInEvent(QFocusEvent*)
    {44, 1002, 280, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 25},	//737 Plasma::ComboBox::focusOutEvent(QFocusEvent*)
    {44, 1068, 290, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 26},	//738 Plasma::ComboBox::hoverEnterEvent(QGraphicsSceneHoverEvent*)
    {44, 1070, 290, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 27},	//739 Plasma::ComboBox::hoverLeaveEvent(QGraphicsSceneHoverEvent*)
    {44, 710, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 28},	//740 Plasma::ComboBox::changeEvent(QEvent*)
    {44, 1370, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 29},	//741 Plasma::ComboBox::mousePressEvent(QGraphicsSceneMouseEvent*)
    {44, 2304, 1, 1, Smoke::mf_static, 293, 30},	//742 Plasma::ComboBox::tr(const char*)
    {44, 2308, 1, 1, Smoke::mf_static, 293, 31},	//743 Plasma::ComboBox::trUtf8(const char*)
    {44, 89, 0, 0, Smoke::mf_ctor, 65, 32},	//744 Plasma::ComboBox::ComboBox()
    {44, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 33},	//745 Plasma::ComboBox::staticMetaObject() const
    {44, 2421, 0, 0, Smoke::mf_dtor, 0, 34 },	//746 Plasma::ComboBox::~ComboBox()
    {45, 92, 337, 3, Smoke::mf_ctor, 67, 1},	//747 Plasma::ConfigLoader::ConfigLoader(const QString&, QIODevice*, QObject*)
    {45, 92, 341, 3, Smoke::mf_ctor, 67, 2},	//748 Plasma::ConfigLoader::ConfigLoader(KSharedPtr<KSharedConfig>, QIODevice*, QObject*)
    {45, 92, 345, 3, Smoke::mf_ctor, 67, 3},	//749 Plasma::ConfigLoader::ConfigLoader(const KConfigGroup*, QIODevice*, QObject*)
    {45, 981, 77, 2, 0, 10, 4},	//750 Plasma::ConfigLoader::findItem(const QString&, const QString&)
    {45, 983, 89, 1, 0, 10, 5},	//751 Plasma::ConfigLoader::findItemByName(const QString&)
    {45, 1480, 89, 1, 0, 304, 6},	//752 Plasma::ConfigLoader::property(const QString&)
    {45, 1046, 89, 1, Smoke::mf_const, 386, 7},	//753 Plasma::ConfigLoader::hasGroup(const QString&) const
    {45, 1036, 0, 0, Smoke::mf_const, 294, 8},	//754 Plasma::ConfigLoader::groupList() const
    {45, 2359, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 9},	//755 Plasma::ConfigLoader::usrWriteConfig()
    {45, 92, 349, 2, Smoke::mf_ctor, 67, 10},	//756 Plasma::ConfigLoader::ConfigLoader(const QString&, QIODevice*)
    {45, 92, 352, 2, Smoke::mf_ctor, 67, 11},	//757 Plasma::ConfigLoader::ConfigLoader(KSharedPtr<KSharedConfig>, QIODevice*)
    {45, 92, 355, 2, Smoke::mf_ctor, 67, 12},	//758 Plasma::ConfigLoader::ConfigLoader(const KConfigGroup*, QIODevice*)
    {45, 2422, 0, 0, Smoke::mf_dtor, 0, 13 },	//759 Plasma::ConfigLoader::~ConfigLoader()
    {46, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//760 Plasma::Containment::metaObject() const
    {46, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//761 Plasma::Containment::qt_metacast(const char*)
    {46, 2304, 43, 2, Smoke::mf_static, 293, 3},	//762 Plasma::Containment::tr(const char*, const char*)
    {46, 2308, 43, 2, Smoke::mf_static, 293, 4},	//763 Plasma::Containment::trUtf8(const char*, const char*)
    {46, 2304, 46, 3, Smoke::mf_static, 293, 5},	//764 Plasma::Containment::tr(const char*, const char*, int)
    {46, 2308, 46, 3, Smoke::mf_static, 293, 6},	//765 Plasma::Containment::trUtf8(const char*, const char*, int)
    {46, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//766 Plasma::Containment::qt_metacall(QMetaObject::Call, int, void**)
    {46, 101, 231, 3, Smoke::mf_ctor, 69, 8},	//767 Plasma::Containment::Containment(QGraphicsItem*, const QString&, unsigned int)
    {46, 101, 70, 2, Smoke::mf_ctor, 69, 9},	//768 Plasma::Containment::Containment(QObject*, const QList<QVariant>&)
    {46, 1091, 0, 0, Smoke::mf_virtual, 0, 10},	//769 Plasma::Containment::init()
    {46, 779, 0, 0, Smoke::mf_const, 73, 11},	//770 Plasma::Containment::containmentType() const
    {46, 798, 0, 0, Smoke::mf_const, 79, 12},	//771 Plasma::Containment::corona() const
    {46, 1252, 77, 2, Smoke::mf_static, 242, 13},	//772 Plasma::Containment::listContainments(const QString&, const QString&)
    {46, 1257, 358, 3, Smoke::mf_static, 242, 14},	//773 Plasma::Containment::listContainmentsOfType(const QString&, const QString&, const QString&)
    {46, 1251, 0, 0, Smoke::mf_static, 294, 15},	//774 Plasma::Containment::listContainmentTypes()
    {46, 1255, 89, 1, Smoke::mf_static, 242, 16},	//775 Plasma::Containment::listContainmentsForMimetype(const QString&)
    {46, 578, 362, 3, 0, 49, 17},	//776 Plasma::Containment::addApplet(const QString&, const QList<QVariant>&, const QRectF&)
    {46, 578, 366, 3, 0, 0, 18},	//777 Plasma::Containment::addApplet(Plasma::Applet*, const QPointF&, bool)
    {46, 674, 0, 0, Smoke::mf_const, 246, 19},	//778 Plasma::Containment::applets() const
    {46, 719, 0, 0, 0, 0, 20},	//779 Plasma::Containment::clearApplets()
    {46, 2004, 370, 2, 0, 0, 21},	//780 Plasma::Containment::setScreen(int, int)
    {46, 1626, 0, 0, Smoke::mf_const, 477, 22},	//781 Plasma::Containment::screen() const
    {46, 1219, 0, 0, Smoke::mf_const, 477, 23},	//782 Plasma::Containment::lastScreen() const
    {46, 850, 0, 0, Smoke::mf_const, 477, 24},	//783 Plasma::Containment::desktop() const
    {46, 1217, 0, 0, Smoke::mf_const, 477, 25},	//784 Plasma::Containment::lastDesktop() const
    {46, 1607, 178, 1, Smoke::mf_const|Smoke::mf_virtual, 0, 26},	//785 Plasma::Containment::save(KConfigGroup&) const
    {46, 1589, 178, 1, Smoke::mf_virtual, 0, 27},	//786 Plasma::Containment::restore(KConfigGroup&)
    {46, 936, 197, 2, 0, 0, 28},	//787 Plasma::Containment::enableAction(const QString&, bool)
    {46, 635, 107, 1, 0, 0, 29},	//788 Plasma::Containment::addToolBoxAction(QAction*)
    {46, 1557, 107, 1, 0, 0, 30},	//789 Plasma::Containment::removeToolBoxAction(QAction*)
    {46, 2098, 7, 1, 0, 0, 31},	//790 Plasma::Containment::setToolBoxOpen(bool)
    {46, 1159, 0, 0, Smoke::mf_const, 386, 32},	//791 Plasma::Containment::isToolBoxOpen() const
    {46, 1399, 0, 0, 0, 0, 33},	//792 Plasma::Containment::openToolBox()
    {46, 731, 0, 0, 0, 0, 34},	//793 Plasma::Containment::closeToolBox()
    {46, 585, 57, 1, Smoke::mf_virtual, 0, 35},	//794 Plasma::Containment::addAssociatedWidget(QWidget*)
    {46, 1534, 57, 1, Smoke::mf_virtual, 0, 36},	//795 Plasma::Containment::removeAssociatedWidget(QWidget*)
    {46, 903, 0, 0, 0, 386, 37},	//796 Plasma::Containment::drawWallpaper()
    {46, 2141, 77, 2, 0, 0, 38},	//797 Plasma::Containment::setWallpaper(const QString&, const QString&)
    {46, 2385, 0, 0, Smoke::mf_const, 173, 39},	//798 Plasma::Containment::wallpaper() const
    {46, 1660, 89, 1, 0, 0, 40},	//799 Plasma::Containment::setActivity(const QString&)
    {46, 571, 0, 0, Smoke::mf_const, 293, 41},	//800 Plasma::Containment::activity() const
    {46, 788, 0, 0, Smoke::mf_const, 78, 42},	//801 Plasma::Containment::context() const
    {46, 2171, 373, 2, 0, 0, 43},	//802 Plasma::Containment::showContextMenu(const QPointF&, const QPoint&)
    {46, 2175, 376, 1, Smoke::mf_virtual, 0, 44},	//803 Plasma::Containment::showDropZone(const QPoint)
    {46, 1731, 77, 2, 0, 0, 45},	//804 Plasma::Containment::setContainmentActions(const QString&, const QString&)
    {46, 771, 0, 0, 0, 294, 46},	//805 Plasma::Containment::containmentActionsTriggers()
    {46, 766, 89, 1, 0, 293, 47},	//806 Plasma::Containment::containmentActions(const QString&)
    {46, 768, 0, 0, 0, 8, 48},	//807 Plasma::Containment::containmentActionsConfig()
    {46, 665, 378, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 49},	//808 Plasma::Containment::appletAdded(Plasma::Applet*, const QPointF&)
    {46, 670, 252, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 50},	//809 Plasma::Containment::appletRemoved(Plasma::Applet*)
    {46, 2407, 381, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 51},	//810 Plasma::Containment::zoomRequested(Plasma::Containment*, Plasma::ZoomDirection)
    {46, 2297, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 52},	//811 Plasma::Containment::toolBoxToggled()
    {46, 2298, 7, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 53},	//812 Plasma::Containment::toolBoxVisibilityChanged(bool)
    {46, 620, 101, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 54},	//813 Plasma::Containment::addSiblingContainment(Plasma::Containment*)
    {46, 2166, 384, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 55},	//814 Plasma::Containment::showAddWidgetsInterface(const QPointF&)
    {46, 1627, 386, 3, Smoke::mf_protected|Smoke::mf_signal, 0, 56},	//815 Plasma::Containment::screenChanged(int, int, Plasma::Containment*)
    {46, 747, 101, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 57},	//816 Plasma::Containment::configureRequested(Plasma::Containment*)
    {46, 790, 390, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 58},	//817 Plasma::Containment::contextChanged(Plasma::Context*)
    {46, 1896, 25, 1, Smoke::mf_slot, 0, 59},	//818 Plasma::Containment::setLocation(Plasma::Location)
    {46, 1824, 392, 1, Smoke::mf_slot, 0, 60},	//819 Plasma::Containment::setFormFactor(Plasma::FormFactor)
    {46, 620, 0, 0, Smoke::mf_slot, 0, 61},	//820 Plasma::Containment::addSiblingContainment()
    {46, 1000, 0, 0, Smoke::mf_slot, 0, 62},	//821 Plasma::Containment::focusNextApplet()
    {46, 1004, 0, 0, Smoke::mf_slot, 0, 63},	//822 Plasma::Containment::focusPreviousApplet()
    {46, 852, 0, 0, Smoke::mf_virtual|Smoke::mf_slot, 0, 64},	//823 Plasma::Containment::destroy()
    {46, 852, 7, 1, Smoke::mf_slot, 0, 65},	//824 Plasma::Containment::destroy(bool)
    {46, 2169, 0, 0, Smoke::mf_virtual|Smoke::mf_slot, 0, 66},	//825 Plasma::Containment::showConfigurationInterface()
    {46, 740, 0, 0, Smoke::mf_virtual|Smoke::mf_slot, 0, 67},	//826 Plasma::Containment::configChanged()
    {46, 1735, 304, 1, Smoke::mf_protected, 0, 68},	//827 Plasma::Containment::setContainmentType(Plasma::Containment::Type)
    {46, 1791, 7, 1, Smoke::mf_protected, 0, 69},	//828 Plasma::Containment::setDrawWallpaper(bool)
    {46, 1609, 178, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 0, 70},	//829 Plasma::Containment::saveContents(KConfigGroup&) const
    {46, 1591, 178, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 71},	//830 Plasma::Containment::restoreContents(KConfigGroup&)
    {46, 1368, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 72},	//831 Plasma::Containment::mouseMoveEvent(QGraphicsSceneMouseEvent*)
    {46, 1370, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 73},	//832 Plasma::Containment::mousePressEvent(QGraphicsSceneMouseEvent*)
    {46, 1372, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 74},	//833 Plasma::Containment::mouseReleaseEvent(QGraphicsSceneMouseEvent*)
    {46, 794, 394, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 75},	//834 Plasma::Containment::contextMenuEvent(QGraphicsSceneContextMenuEvent*)
    {46, 1198, 396, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 76},	//835 Plasma::Containment::keyPressEvent(QKeyEvent*)
    {46, 2389, 398, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 77},	//836 Plasma::Containment::wheelEvent(QGraphicsSceneWheelEvent*)
    {46, 1621, 275, 2, Smoke::mf_protected|Smoke::mf_virtual, 386, 78},	//837 Plasma::Containment::sceneEventFilter(QGraphicsItem*, QEvent*)
    {46, 1179, 284, 2, Smoke::mf_protected|Smoke::mf_virtual, 304, 79},	//838 Plasma::Containment::itemChange(QGraphicsItem::GraphicsItemChange, const QVariant&)
    {46, 876, 400, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 80},	//839 Plasma::Containment::dragEnterEvent(QGraphicsSceneDragDropEvent*)
    {46, 878, 400, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 81},	//840 Plasma::Containment::dragLeaveEvent(QGraphicsSceneDragDropEvent*)
    {46, 880, 400, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 82},	//841 Plasma::Containment::dragMoveEvent(QGraphicsSceneDragDropEvent*)
    {46, 906, 400, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 83},	//842 Plasma::Containment::dropEvent(QGraphicsSceneDragDropEvent*)
    {46, 1584, 282, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 84},	//843 Plasma::Containment::resizeEvent(QGraphicsSceneResizeEvent*)
    {46, 2296, 0, 0, Smoke::mf_const|Smoke::mf_protected, 427, 85},	//844 Plasma::Containment::toolBoxItem() const
    {46, 2096, 402, 1, Smoke::mf_protected, 0, 86},	//845 Plasma::Containment::setToolBox(Plasma::AbstractToolBox*)
    {46, 2295, 0, 0, Smoke::mf_const|Smoke::mf_protected, 35, 87},	//846 Plasma::Containment::toolBox() const
    {46, 2304, 1, 1, Smoke::mf_static, 293, 88},	//847 Plasma::Containment::tr(const char*)
    {46, 2308, 1, 1, Smoke::mf_static, 293, 89},	//848 Plasma::Containment::trUtf8(const char*)
    {46, 101, 0, 0, Smoke::mf_ctor, 69, 90},	//849 Plasma::Containment::Containment()
    {46, 101, 170, 1, Smoke::mf_ctor, 69, 91},	//850 Plasma::Containment::Containment(QGraphicsItem*)
    {46, 101, 298, 2, Smoke::mf_ctor, 69, 92},	//851 Plasma::Containment::Containment(QGraphicsItem*, const QString&)
    {46, 1252, 0, 0, Smoke::mf_static, 242, 93},	//852 Plasma::Containment::listContainments()
    {46, 1252, 89, 1, Smoke::mf_static, 242, 94},	//853 Plasma::Containment::listContainments(const QString&)
    {46, 1257, 89, 1, Smoke::mf_static, 242, 95},	//854 Plasma::Containment::listContainmentsOfType(const QString&)
    {46, 1257, 77, 2, Smoke::mf_static, 242, 96},	//855 Plasma::Containment::listContainmentsOfType(const QString&, const QString&)
    {46, 578, 89, 1, 0, 49, 97},	//856 Plasma::Containment::addApplet(const QString&)
    {46, 578, 113, 2, 0, 49, 98},	//857 Plasma::Containment::addApplet(const QString&, const QList<QVariant>&)
    {46, 578, 252, 1, 0, 0, 99},	//858 Plasma::Containment::addApplet(Plasma::Applet*)
    {46, 578, 378, 2, 0, 0, 100},	//859 Plasma::Containment::addApplet(Plasma::Applet*, const QPointF&)
    {46, 2004, 129, 1, 0, 0, 101},	//860 Plasma::Containment::setScreen(int)
    {46, 2141, 89, 1, 0, 0, 102},	//861 Plasma::Containment::setWallpaper(const QString&)
    {46, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 103},	//862 Plasma::Containment::staticMetaObject() const
    {46, 332, 0, 0, Smoke::mf_static|Smoke::mf_enum, 73, 104},	//863 Plasma::Containment::NoContainmentType (enum)
    {46, 141, 0, 0, Smoke::mf_static|Smoke::mf_enum, 73, 105},	//864 Plasma::Containment::DesktopContainment (enum)
    {46, 362, 0, 0, Smoke::mf_static|Smoke::mf_enum, 73, 106},	//865 Plasma::Containment::PanelContainment (enum)
    {46, 120, 0, 0, Smoke::mf_static|Smoke::mf_enum, 73, 107},	//866 Plasma::Containment::CustomContainment (enum)
    {46, 121, 0, 0, Smoke::mf_static|Smoke::mf_enum, 73, 108},	//867 Plasma::Containment::CustomPanelContainment (enum)
    {46, 2423, 0, 0, Smoke::mf_dtor, 0, 109 },	//868 Plasma::Containment::~Containment()
    {47, 461, 0, 0, Smoke::mf_ctor, 70, 1},	//869 Plasma::Containment::StyleOption::StyleOption()
    {47, 461, 404, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 70, 2},	//870 Plasma::Containment::StyleOption::StyleOption(const Plasma::Containment::StyleOption&)
    {47, 461, 406, 1, Smoke::mf_ctor, 70, 3},	//871 Plasma::Containment::StyleOption::StyleOption(const QStyleOptionGraphicsItem&)
    {47, 2374, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 172, 4},	//872 Plasma::Containment::StyleOption::view() const
    {47, 2138, 408, 1, Smoke::mf_attribute, 0, 5},	//873 Plasma::Containment::StyleOption::setView(Plasma::View*)
    {47, 508, 0, 0, Smoke::mf_static|Smoke::mf_enum, 71, 6},	//874 Plasma::Containment::StyleOption::Type (enum)
    {47, 521, 0, 0, Smoke::mf_static|Smoke::mf_enum, 72, 7},	//875 Plasma::Containment::StyleOption::Version (enum)
    {47, 2467, 0, 0, Smoke::mf_dtor, 0, 8 },	//876 Plasma::Containment::StyleOption::~StyleOption()
    {48, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//877 Plasma::ContainmentActions::metaObject() const
    {48, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//878 Plasma::ContainmentActions::qt_metacast(const char*)
    {48, 2304, 43, 2, Smoke::mf_static, 293, 3},	//879 Plasma::ContainmentActions::tr(const char*, const char*)
    {48, 2308, 43, 2, Smoke::mf_static, 293, 4},	//880 Plasma::ContainmentActions::trUtf8(const char*, const char*)
    {48, 2304, 46, 3, Smoke::mf_static, 293, 5},	//881 Plasma::ContainmentActions::tr(const char*, const char*, int)
    {48, 2308, 46, 3, Smoke::mf_static, 293, 6},	//882 Plasma::ContainmentActions::trUtf8(const char*, const char*, int)
    {48, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//883 Plasma::ContainmentActions::qt_metacall(QMetaObject::Call, int, void**)
    {48, 106, 97, 1, Smoke::mf_ctor, 74, 8},	//884 Plasma::ContainmentActions::ContainmentActions(QObject*)
    {48, 1250, 0, 0, Smoke::mf_static, 242, 9},	//885 Plasma::ContainmentActions::listContainmentActionsInfo()
    {48, 1281, 410, 3, Smoke::mf_static, 74, 10},	//886 Plasma::ContainmentActions::load(Plasma::Containment*, const QString&, const QList<QVariant>&)
    {48, 1281, 414, 3, Smoke::mf_static, 74, 11},	//887 Plasma::ContainmentActions::load(Plasma::Containment*, const KPluginInfo&, const QList<QVariant>&)
    {48, 1415, 0, 0, Smoke::mf_static, 21, 12},	//888 Plasma::ContainmentActions::packageStructure()
    {48, 1386, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 13},	//889 Plasma::ContainmentActions::name() const
    {48, 1458, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 14},	//890 Plasma::ContainmentActions::pluginName() const
    {48, 1075, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 15},	//891 Plasma::ContainmentActions::icon() const
    {48, 1136, 0, 0, Smoke::mf_const, 386, 16},	//892 Plasma::ContainmentActions::isInitialized() const
    {48, 1589, 111, 1, 0, 0, 17},	//893 Plasma::ContainmentActions::restore(const KConfigGroup&)
    {48, 1607, 178, 1, Smoke::mf_virtual, 0, 18},	//894 Plasma::ContainmentActions::save(KConfigGroup&)
    {48, 805, 57, 1, Smoke::mf_virtual, 309, 19},	//895 Plasma::ContainmentActions::createConfigurationInterface(QWidget*)
    {48, 744, 0, 0, Smoke::mf_virtual, 0, 20},	//896 Plasma::ContainmentActions::configurationAccepted()
    {48, 792, 331, 1, Smoke::mf_virtual, 0, 21},	//897 Plasma::ContainmentActions::contextEvent(QEvent*)
    {48, 796, 0, 0, Smoke::mf_virtual, 255, 22},	//898 Plasma::ContainmentActions::contextualActions()
    {48, 839, 89, 1, Smoke::mf_const, 81, 23},	//899 Plasma::ContainmentActions::dataEngine(const QString&) const
    {48, 745, 0, 0, Smoke::mf_const, 386, 24},	//900 Plasma::ContainmentActions::configurationRequired() const
    {48, 956, 331, 1, Smoke::mf_static, 293, 25},	//901 Plasma::ContainmentActions::eventToString(QEvent*)
    {48, 1466, 418, 2, 0, 279, 26},	//902 Plasma::ContainmentActions::popupPosition(const QSize&, QEvent*)
    {48, 952, 331, 1, Smoke::mf_virtual, 386, 27},	//903 Plasma::ContainmentActions::event(QEvent*)
    {48, 1729, 101, 1, 0, 0, 28},	//904 Plasma::ContainmentActions::setContainment(Plasma::Containment*)
    {48, 106, 70, 2, Smoke::mf_ctor|Smoke::mf_protected, 74, 29},	//905 Plasma::ContainmentActions::ContainmentActions(QObject*, const QList<QVariant>&)
    {48, 1091, 111, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 30},	//906 Plasma::ContainmentActions::init(const KConfigGroup&)
    {48, 1726, 7, 1, Smoke::mf_protected, 0, 31},	//907 Plasma::ContainmentActions::setConfigurationRequired(bool)
    {48, 765, 0, 0, Smoke::mf_protected, 69, 32},	//908 Plasma::ContainmentActions::containment()
    {48, 1444, 421, 2, Smoke::mf_protected, 0, 33},	//909 Plasma::ContainmentActions::paste(QPointF, QPoint)
    {48, 2304, 1, 1, Smoke::mf_static, 293, 34},	//910 Plasma::ContainmentActions::tr(const char*)
    {48, 2308, 1, 1, Smoke::mf_static, 293, 35},	//911 Plasma::ContainmentActions::trUtf8(const char*)
    {48, 106, 0, 0, Smoke::mf_ctor, 74, 36},	//912 Plasma::ContainmentActions::ContainmentActions()
    {48, 1281, 424, 2, Smoke::mf_static, 74, 37},	//913 Plasma::ContainmentActions::load(Plasma::Containment*, const QString&)
    {48, 1281, 427, 2, Smoke::mf_static, 74, 38},	//914 Plasma::ContainmentActions::load(Plasma::Containment*, const KPluginInfo&)
    {48, 1726, 0, 0, Smoke::mf_protected, 0, 39},	//915 Plasma::ContainmentActions::setConfigurationRequired()
    {48, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 40},	//916 Plasma::ContainmentActions::staticMetaObject() const
    {48, 2424, 0, 0, Smoke::mf_dtor, 0, 41 },	//917 Plasma::ContainmentActions::~ContainmentActions()
    {49, 109, 0, 0, Smoke::mf_ctor, 77, 1},	//918 Plasma::ContainmentActionsPluginsConfig::ContainmentActionsPluginsConfig()
    {49, 109, 430, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 77, 2},	//919 Plasma::ContainmentActionsPluginsConfig::ContainmentActionsPluginsConfig(const Plasma::ContainmentActionsPluginsConfig&)
    {49, 1408, 430, 1, 0, 76, 3},	//920 Plasma::ContainmentActionsPluginsConfig::operator=(const Plasma::ContainmentActionsPluginsConfig&)
    {49, 717, 0, 0, 0, 0, 4},	//921 Plasma::ContainmentActionsPluginsConfig::clear()
    {49, 1527, 331, 1, 0, 0, 5},	//922 Plasma::ContainmentActionsPluginsConfig::remove(QEvent*)
    {49, 611, 432, 2, 0, 0, 6},	//923 Plasma::ContainmentActionsPluginsConfig::addPlugin(QEvent*, const QString&)
    {49, 611, 435, 3, 0, 0, 7},	//924 Plasma::ContainmentActionsPluginsConfig::addPlugin(QFlags<Qt::KeyboardModifier>, Qt::MouseButton, const QString&)
    {49, 611, 439, 3, 0, 0, 8},	//925 Plasma::ContainmentActionsPluginsConfig::addPlugin(QFlags<Qt::KeyboardModifier>, Qt::Orientation, const QString&)
    {49, 2425, 0, 0, Smoke::mf_dtor, 0, 9 },	//926 Plasma::ContainmentActionsPluginsConfig::~ContainmentActionsPluginsConfig()
    {50, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//927 Plasma::Context::metaObject() const
    {50, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//928 Plasma::Context::qt_metacast(const char*)
    {50, 2304, 43, 2, Smoke::mf_static, 293, 3},	//929 Plasma::Context::tr(const char*, const char*)
    {50, 2308, 43, 2, Smoke::mf_static, 293, 4},	//930 Plasma::Context::trUtf8(const char*, const char*)
    {50, 2304, 46, 3, Smoke::mf_static, 293, 5},	//931 Plasma::Context::tr(const char*, const char*, int)
    {50, 2308, 46, 3, Smoke::mf_static, 293, 6},	//932 Plasma::Context::trUtf8(const char*, const char*, int)
    {50, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//933 Plasma::Context::qt_metacall(QMetaObject::Call, int, void**)
    {50, 112, 97, 1, Smoke::mf_ctor, 78, 8},	//934 Plasma::Context::Context(QObject*)
    {50, 803, 89, 1, 0, 0, 9},	//935 Plasma::Context::createActivity(const QString&)
    {50, 1235, 0, 0, Smoke::mf_const, 294, 10},	//936 Plasma::Context::listActivities() const
    {50, 1751, 89, 1, 0, 0, 11},	//937 Plasma::Context::setCurrentActivity(const QString&)
    {50, 819, 0, 0, Smoke::mf_const, 293, 12},	//938 Plasma::Context::currentActivity() const
    {50, 1753, 89, 1, 0, 0, 13},	//939 Plasma::Context::setCurrentActivityId(const QString&)
    {50, 820, 0, 0, Smoke::mf_const, 293, 14},	//940 Plasma::Context::currentActivityId() const
    {50, 712, 390, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 15},	//941 Plasma::Context::changed(Plasma::Context*)
    {50, 572, 390, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 16},	//942 Plasma::Context::activityChanged(Plasma::Context*)
    {50, 1315, 390, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 17},	//943 Plasma::Context::locationChanged(Plasma::Context*)
    {50, 2304, 1, 1, Smoke::mf_static, 293, 18},	//944 Plasma::Context::tr(const char*)
    {50, 2308, 1, 1, Smoke::mf_static, 293, 19},	//945 Plasma::Context::trUtf8(const char*)
    {50, 112, 0, 0, Smoke::mf_ctor, 78, 20},	//946 Plasma::Context::Context()
    {50, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 21},	//947 Plasma::Context::staticMetaObject() const
    {50, 2426, 0, 0, Smoke::mf_dtor, 0, 22 },	//948 Plasma::Context::~Context()
    {51, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//949 Plasma::Corona::metaObject() const
    {51, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//950 Plasma::Corona::qt_metacast(const char*)
    {51, 2304, 43, 2, Smoke::mf_static, 293, 3},	//951 Plasma::Corona::tr(const char*, const char*)
    {51, 2308, 43, 2, Smoke::mf_static, 293, 4},	//952 Plasma::Corona::trUtf8(const char*, const char*)
    {51, 2304, 46, 3, Smoke::mf_static, 293, 5},	//953 Plasma::Corona::tr(const char*, const char*, int)
    {51, 2308, 46, 3, Smoke::mf_static, 293, 6},	//954 Plasma::Corona::trUtf8(const char*, const char*, int)
    {51, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//955 Plasma::Corona::qt_metacall(QMetaObject::Call, int, void**)
    {51, 116, 97, 1, Smoke::mf_ctor, 79, 8},	//956 Plasma::Corona::Corona(QObject*)
    {51, 1672, 89, 1, 0, 0, 9},	//957 Plasma::Corona::setAppletMimeType(const QString&)
    {51, 669, 0, 0, 0, 293, 10},	//958 Plasma::Corona::appletMimeType()
    {51, 843, 0, 0, Smoke::mf_const, 293, 11},	//959 Plasma::Corona::defaultContainmentPlugin() const
    {51, 780, 0, 0, Smoke::mf_const, 247, 12},	//960 Plasma::Corona::containments() const
    {51, 721, 0, 0, 0, 0, 13},	//961 Plasma::Corona::clearContainments()
    {51, 738, 0, 0, Smoke::mf_const, 20, 14},	//962 Plasma::Corona::config() const
    {51, 587, 113, 2, 0, 69, 15},	//963 Plasma::Corona::addContainment(const QString&, const QList<QVariant>&)
    {51, 590, 113, 2, 0, 69, 16},	//964 Plasma::Corona::addContainmentDelayed(const QString&, const QList<QVariant>&)
    {51, 774, 370, 2, Smoke::mf_const, 69, 17},	//965 Plasma::Corona::containmentForScreen(int, int) const
    {51, 774, 443, 4, 0, 69, 18},	//966 Plasma::Corona::containmentForScreen(int, int, const QString&, const QList<QVariant>&)
    {51, 607, 125, 1, 0, 0, 19},	//967 Plasma::Corona::addOffscreenWidget(QGraphicsWidget*)
    {51, 1547, 125, 1, 0, 0, 20},	//968 Plasma::Corona::removeOffscreenWidget(QGraphicsWidget*)
    {51, 1397, 0, 0, Smoke::mf_const, 258, 21},	//969 Plasma::Corona::offscreenWidgets() const
    {51, 1396, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 477, 22},	//970 Plasma::Corona::numScreens() const
    {51, 1629, 129, 1, Smoke::mf_const|Smoke::mf_virtual, 282, 23},	//971 Plasma::Corona::screenGeometry(int) const
    {51, 692, 129, 1, Smoke::mf_const|Smoke::mf_virtual, 286, 24},	//972 Plasma::Corona::availableScreenRegion(int) const
    {51, 1466, 448, 2, 0, 279, 25},	//973 Plasma::Corona::popupPosition(const QGraphicsItem*, const QSize&)
    {51, 1466, 451, 3, 0, 279, 26},	//974 Plasma::Corona::popupPosition(const QGraphicsItem*, const QSize&, Qt::AlignmentFlag)
    {51, 1017, 129, 1, Smoke::mf_const, 250, 27},	//975 Plasma::Corona::freeEdges(int) const
    {51, 557, 220, 1, Smoke::mf_const, 183, 28},	//976 Plasma::Corona::action(QString) const
    {51, 574, 222, 2, 0, 0, 29},	//977 Plasma::Corona::addAction(QString, QAction*)
    {51, 560, 0, 0, Smoke::mf_const, 255, 30},	//978 Plasma::Corona::actions() const
    {51, 936, 197, 2, 0, 0, 31},	//979 Plasma::Corona::enableAction(const QString&, bool)
    {51, 2342, 0, 0, 0, 0, 32},	//980 Plasma::Corona::updateShortcuts()
    {51, 618, 455, 1, 0, 0, 33},	//981 Plasma::Corona::addShortcuts(KActionCollection*)
    {51, 574, 220, 1, 0, 3, 34},	//982 Plasma::Corona::addAction(QString)
    {51, 1733, 457, 2, 0, 0, 35},	//983 Plasma::Corona::setContainmentActionsDefaults(Plasma::Containment::Type, const Plasma::ContainmentActionsPluginsConfig&)
    {51, 769, 304, 1, 0, 75, 36},	//984 Plasma::Corona::containmentActionsDefaults(Plasma::Containment::Type)
    {51, 1783, 460, 1, 0, 0, 37},	//985 Plasma::Corona::setDialogManager(Plasma::AbstractDialogManager*)
    {51, 858, 0, 0, 0, 31, 38},	//986 Plasma::Corona::dialogManager()
    {51, 1086, 462, 1, 0, 247, 39},	//987 Plasma::Corona::importLayout(const KConfigBase&)
    {51, 1472, 464, 1, Smoke::mf_const, 293, 40},	//988 Plasma::Corona::preferredToolBoxPlugin(const Plasma::Containment::Type) const
    {51, 1086, 111, 1, 0, 247, 41},	//989 Plasma::Corona::importLayout(const KConfigGroup&)
    {51, 964, 466, 2, 0, 0, 42},	//990 Plasma::Corona::exportLayout(KConfigGroup&, QList<Plasma::Containment*>)
    {51, 1098, 89, 1, Smoke::mf_slot, 0, 43},	//991 Plasma::Corona::initializeLayout(const QString&)
    {51, 1301, 89, 1, Smoke::mf_slot, 0, 44},	//992 Plasma::Corona::loadLayout(const QString&)
    {51, 1611, 89, 1, Smoke::mf_const|Smoke::mf_slot, 0, 45},	//993 Plasma::Corona::saveLayout(const QString&) const
    {51, 1082, 0, 0, Smoke::mf_const|Smoke::mf_slot, 105, 46},	//994 Plasma::Corona::immutability() const
    {51, 1871, 258, 1, Smoke::mf_slot, 0, 47},	//995 Plasma::Corona::setImmutability(const Plasma::ImmutabilityType)
    {51, 1574, 0, 0, Smoke::mf_slot, 0, 48},	//996 Plasma::Corona::requestConfigSync()
    {51, 1575, 0, 0, Smoke::mf_slot, 0, 49},	//997 Plasma::Corona::requireConfigSync()
    {51, 1227, 0, 0, Smoke::mf_slot, 0, 50},	//998 Plasma::Corona::layoutContainments()
    {51, 772, 101, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 51},	//999 Plasma::Corona::containmentAdded(Plasma::Containment*)
    {51, 1631, 386, 3, Smoke::mf_protected|Smoke::mf_signal, 0, 52},	//1000 Plasma::Corona::screenOwnerChanged(int, int, Plasma::Containment*)
    {51, 1515, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 53},	//1001 Plasma::Corona::releaseVisualFocus()
    {51, 743, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 54},	//1002 Plasma::Corona::configSynced()
    {51, 694, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 55},	//1003 Plasma::Corona::availableScreenRegionChanged()
    {51, 1083, 256, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 56},	//1004 Plasma::Corona::immutabilityChanged(Plasma::ImmutabilityType)
    {51, 2162, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 57},	//1005 Plasma::Corona::shortcutsChanged()
    {51, 1296, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 58},	//1006 Plasma::Corona::loadDefaultLayout()
    {51, 1327, 469, 2, Smoke::mf_protected, 0, 59},	//1007 Plasma::Corona::mapAnimation(Plasma::Animator::Animation, Plasma::Animator::Animation)
    {51, 1327, 472, 2, Smoke::mf_protected, 0, 60},	//1008 Plasma::Corona::mapAnimation(Plasma::Animator::Animation, const QString&)
    {51, 1966, 475, 2, Smoke::mf_protected, 0, 61},	//1009 Plasma::Corona::setPreferredToolBoxPlugin(const Plasma::Containment::Type, const QString&)
    {51, 1768, 89, 1, Smoke::mf_protected, 0, 62},	//1010 Plasma::Corona::setDefaultContainmentPlugin(const QString&)
    {51, 876, 400, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 63},	//1011 Plasma::Corona::dragEnterEvent(QGraphicsSceneDragDropEvent*)
    {51, 878, 400, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 64},	//1012 Plasma::Corona::dragLeaveEvent(QGraphicsSceneDragDropEvent*)
    {51, 880, 400, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 65},	//1013 Plasma::Corona::dragMoveEvent(QGraphicsSceneDragDropEvent*)
    {51, 2304, 1, 1, Smoke::mf_static, 293, 66},	//1014 Plasma::Corona::tr(const char*)
    {51, 2308, 1, 1, Smoke::mf_static, 293, 67},	//1015 Plasma::Corona::trUtf8(const char*)
    {51, 116, 0, 0, Smoke::mf_ctor, 79, 68},	//1016 Plasma::Corona::Corona()
    {51, 587, 89, 1, 0, 69, 69},	//1017 Plasma::Corona::addContainment(const QString&)
    {51, 590, 89, 1, 0, 69, 70},	//1018 Plasma::Corona::addContainmentDelayed(const QString&)
    {51, 774, 129, 1, Smoke::mf_const, 69, 71},	//1019 Plasma::Corona::containmentForScreen(int) const
    {51, 774, 478, 3, 0, 69, 72},	//1020 Plasma::Corona::containmentForScreen(int, int, const QString&)
    {51, 1098, 0, 0, Smoke::mf_slot, 0, 73},	//1021 Plasma::Corona::initializeLayout()
    {51, 1301, 0, 0, Smoke::mf_slot, 0, 74},	//1022 Plasma::Corona::loadLayout()
    {51, 1611, 0, 0, Smoke::mf_const|Smoke::mf_slot, 0, 75},	//1023 Plasma::Corona::saveLayout() const
    {51, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 76},	//1024 Plasma::Corona::staticMetaObject() const
    {51, 2427, 0, 0, Smoke::mf_dtor, 0, 77 },	//1025 Plasma::Corona::~Corona()
    {52, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//1026 Plasma::DataContainer::metaObject() const
    {52, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//1027 Plasma::DataContainer::qt_metacast(const char*)
    {52, 2304, 43, 2, Smoke::mf_static, 293, 3},	//1028 Plasma::DataContainer::tr(const char*, const char*)
    {52, 2308, 43, 2, Smoke::mf_static, 293, 4},	//1029 Plasma::DataContainer::trUtf8(const char*, const char*)
    {52, 2304, 46, 3, Smoke::mf_static, 293, 5},	//1030 Plasma::DataContainer::tr(const char*, const char*, int)
    {52, 2308, 46, 3, Smoke::mf_static, 293, 6},	//1031 Plasma::DataContainer::trUtf8(const char*, const char*, int)
    {52, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//1032 Plasma::DataContainer::qt_metacall(QMetaObject::Call, int, void**)
    {52, 122, 97, 1, Smoke::mf_ctor, 80, 8},	//1033 Plasma::DataContainer::DataContainer(QObject*)
    {52, 838, 0, 0, Smoke::mf_const, 429, 9},	//1034 Plasma::DataContainer::data() const
    {52, 1761, 482, 2, 0, 0, 10},	//1035 Plasma::DataContainer::setData(const QString&, const QVariant&)
    {52, 1531, 0, 0, 0, 0, 11},	//1036 Plasma::DataContainer::removeAllData()
    {52, 2383, 97, 1, Smoke::mf_const, 386, 12},	//1037 Plasma::DataContainer::visualizationIsConnected(QObject*) const
    {52, 758, 485, 3, 0, 0, 13},	//1038 Plasma::DataContainer::connectVisualization(QObject*, unsigned int, Plasma::IntervalAlignment)
    {52, 2045, 7, 1, 0, 0, 14},	//1039 Plasma::DataContainer::setStorageEnabled(bool)
    {52, 1155, 0, 0, Smoke::mf_const, 386, 15},	//1040 Plasma::DataContainer::isStorageEnabled() const
    {52, 1390, 0, 0, Smoke::mf_const, 386, 16},	//1041 Plasma::DataContainer::needsToBeStored() const
    {52, 1925, 7, 1, 0, 0, 17},	//1042 Plasma::DataContainer::setNeedsToBeStored(bool)
    {52, 1022, 0, 0, 0, 81, 18},	//1043 Plasma::DataContainer::getDataEngine()
    {52, 870, 97, 1, Smoke::mf_slot, 0, 19},	//1044 Plasma::DataContainer::disconnectVisualization(QObject*)
    {52, 1010, 0, 0, Smoke::mf_slot, 0, 20},	//1045 Plasma::DataContainer::forceImmediateUpdate()
    {52, 841, 489, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 21},	//1046 Plasma::DataContainer::dataUpdated(const QString&, const Plasma::DataEngine::Data&)
    {52, 698, 89, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 22},	//1047 Plasma::DataContainer::becameUnused(const QString&)
    {52, 2340, 492, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 23},	//1048 Plasma::DataContainer::updateRequested(Plasma::DataContainer*)
    {52, 714, 0, 0, Smoke::mf_protected, 0, 24},	//1049 Plasma::DataContainer::checkForUpdate()
    {52, 2288, 0, 0, Smoke::mf_const|Smoke::mf_protected, 484, 25},	//1050 Plasma::DataContainer::timeSinceLastUpdate() const
    {52, 1927, 7, 1, Smoke::mf_protected, 0, 26},	//1051 Plasma::DataContainer::setNeedsUpdate(bool)
    {52, 715, 0, 0, Smoke::mf_protected|Smoke::mf_slot, 0, 27},	//1052 Plasma::DataContainer::checkUsage()
    {52, 2289, 176, 1, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_slot, 0, 28},	//1053 Plasma::DataContainer::timerEvent(QTimerEvent*)
    {52, 2304, 1, 1, Smoke::mf_static, 293, 29},	//1054 Plasma::DataContainer::tr(const char*)
    {52, 2308, 1, 1, Smoke::mf_static, 293, 30},	//1055 Plasma::DataContainer::trUtf8(const char*)
    {52, 122, 0, 0, Smoke::mf_ctor, 80, 31},	//1056 Plasma::DataContainer::DataContainer()
    {52, 1927, 0, 0, Smoke::mf_protected, 0, 32},	//1057 Plasma::DataContainer::setNeedsUpdate()
    {52, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 33},	//1058 Plasma::DataContainer::staticMetaObject() const
    {52, 2428, 0, 0, Smoke::mf_dtor, 0, 34 },	//1059 Plasma::DataContainer::~DataContainer()
    {53, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//1060 Plasma::DataEngine::metaObject() const
    {53, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//1061 Plasma::DataEngine::qt_metacast(const char*)
    {53, 2304, 43, 2, Smoke::mf_static, 293, 3},	//1062 Plasma::DataEngine::tr(const char*, const char*)
    {53, 2308, 43, 2, Smoke::mf_static, 293, 4},	//1063 Plasma::DataEngine::trUtf8(const char*, const char*)
    {53, 2304, 46, 3, Smoke::mf_static, 293, 5},	//1064 Plasma::DataEngine::tr(const char*, const char*, int)
    {53, 2308, 46, 3, Smoke::mf_static, 293, 6},	//1065 Plasma::DataEngine::trUtf8(const char*, const char*, int)
    {53, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//1066 Plasma::DataEngine::qt_metacall(QMetaObject::Call, int, void**)
    {53, 124, 494, 2, Smoke::mf_ctor, 81, 8},	//1067 Plasma::DataEngine::DataEngine(QObject*, KSharedPtr<KService>)
    {53, 124, 70, 2, Smoke::mf_ctor, 81, 9},	//1068 Plasma::DataEngine::DataEngine(QObject*, const QList<QVariant>&)
    {53, 1091, 0, 0, Smoke::mf_virtual, 0, 10},	//1069 Plasma::DataEngine::init()
    {53, 2213, 0, 0, Smoke::mf_const|Smoke::mf_property|Smoke::mf_virtual, 294, 11},	//1070 Plasma::DataEngine::sources() const
    {53, 1648, 89, 1, Smoke::mf_virtual, 148, 12},	//1071 Plasma::DataEngine::serviceForSource(const QString&)
    {53, 1386, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 13},	//1072 Plasma::DataEngine::name() const
    {53, 754, 497, 4, Smoke::mf_const, 0, 14},	//1073 Plasma::DataEngine::connectSource(const QString&, QObject*, unsigned int, Plasma::IntervalAlignment) const
    {53, 749, 485, 3, Smoke::mf_const, 0, 15},	//1074 Plasma::DataEngine::connectAllSources(QObject*, unsigned int, Plasma::IntervalAlignment) const
    {53, 868, 149, 2, Smoke::mf_const, 0, 16},	//1075 Plasma::DataEngine::disconnectSource(const QString&, QObject*) const
    {53, 763, 89, 1, 0, 80, 17},	//1076 Plasma::DataEngine::containerForSource(const QString&)
    {53, 1489, 89, 1, Smoke::mf_const, 233, 18},	//1077 Plasma::DataEngine::query(const QString&) const
    {53, 1164, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 19},	//1078 Plasma::DataEngine::isValid() const
    {53, 1131, 0, 0, Smoke::mf_const, 386, 20},	//1079 Plasma::DataEngine::isEmpty() const
    {53, 1345, 0, 0, Smoke::mf_const, 484, 21},	//1080 Plasma::DataEngine::maxSourceCount() const
    {53, 1075, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 22},	//1081 Plasma::DataEngine::icon() const
    {53, 1414, 0, 0, Smoke::mf_const, 409, 23},	//1082 Plasma::DataEngine::package() const
    {53, 1458, 0, 0, Smoke::mf_const, 293, 24},	//1083 Plasma::DataEngine::pluginName() const
    {53, 807, 97, 1, 0, 148, 25},	//1084 Plasma::DataEngine::createDefaultService(QObject*)
    {53, 2207, 89, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 26},	//1085 Plasma::DataEngine::sourceAdded(const QString&)
    {53, 2209, 89, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 27},	//1086 Plasma::DataEngine::sourceRemoved(const QString&)
    {53, 2211, 89, 1, Smoke::mf_protected|Smoke::mf_virtual, 386, 28},	//1087 Plasma::DataEngine::sourceRequestEvent(const QString&)
    {53, 2343, 89, 1, Smoke::mf_protected|Smoke::mf_virtual, 386, 29},	//1088 Plasma::DataEngine::updateSourceEvent(const QString&)
    {53, 1761, 482, 2, Smoke::mf_protected, 0, 30},	//1089 Plasma::DataEngine::setData(const QString&, const QVariant&)
    {53, 1761, 502, 3, Smoke::mf_protected, 0, 31},	//1090 Plasma::DataEngine::setData(const QString&, const QString&, const QVariant&)
    {53, 1761, 506, 2, Smoke::mf_protected, 0, 32},	//1091 Plasma::DataEngine::setData(const QString&, const QHash<QString,QVariant>&)
    {53, 1531, 89, 1, Smoke::mf_protected, 0, 33},	//1092 Plasma::DataEngine::removeAllData(const QString&)
    {53, 1536, 77, 2, Smoke::mf_protected, 0, 34},	//1093 Plasma::DataEngine::removeData(const QString&, const QString&)
    {53, 622, 492, 1, Smoke::mf_protected, 0, 35},	//1094 Plasma::DataEngine::addSource(Plasma::DataContainer*)
    {53, 1900, 17, 1, Smoke::mf_protected, 0, 36},	//1095 Plasma::DataEngine::setMaxSourceCount(unsigned int)
    {53, 1914, 129, 1, Smoke::mf_protected, 0, 37},	//1096 Plasma::DataEngine::setMinimumPollingInterval(int)
    {53, 1363, 0, 0, Smoke::mf_const|Smoke::mf_protected, 477, 38},	//1097 Plasma::DataEngine::minimumPollingInterval() const
    {53, 1957, 17, 1, Smoke::mf_protected, 0, 39},	//1098 Plasma::DataEngine::setPollingInterval(unsigned int)
    {53, 1533, 0, 0, Smoke::mf_protected, 0, 40},	//1099 Plasma::DataEngine::removeAllSources()
    {53, 2122, 7, 1, Smoke::mf_protected, 0, 41},	//1100 Plasma::DataEngine::setValid(bool)
    {53, 762, 0, 0, Smoke::mf_const|Smoke::mf_protected, 231, 42},	//1101 Plasma::DataEngine::containerDict() const
    {53, 2289, 176, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 43},	//1102 Plasma::DataEngine::timerEvent(QTimerEvent*)
    {53, 1921, 89, 1, Smoke::mf_protected, 0, 44},	//1103 Plasma::DataEngine::setName(const QString&)
    {53, 1858, 89, 1, Smoke::mf_protected|Smoke::mf_property, 0, 45},	//1104 Plasma::DataEngine::setIcon(const QString&)
    {53, 1774, 89, 1, Smoke::mf_protected, 0, 46},	//1105 Plasma::DataEngine::setDefaultService(const QString&)
    {53, 2045, 197, 2, Smoke::mf_protected, 0, 47},	//1106 Plasma::DataEngine::setStorageEnabled(const QString&, bool)
    {53, 1625, 0, 0, Smoke::mf_protected|Smoke::mf_slot, 0, 48},	//1107 Plasma::DataEngine::scheduleSourcesUpdated()
    {53, 1551, 89, 1, Smoke::mf_protected|Smoke::mf_slot, 0, 49},	//1108 Plasma::DataEngine::removeSource(const QString&)
    {53, 2331, 0, 0, Smoke::mf_protected|Smoke::mf_slot, 0, 50},	//1109 Plasma::DataEngine::updateAllSources()
    {53, 1011, 0, 0, Smoke::mf_protected|Smoke::mf_slot, 0, 51},	//1110 Plasma::DataEngine::forceImmediateUpdateOfAllVisualizations()
    {53, 2304, 1, 1, Smoke::mf_static, 293, 52},	//1111 Plasma::DataEngine::tr(const char*)
    {53, 2308, 1, 1, Smoke::mf_static, 293, 53},	//1112 Plasma::DataEngine::trUtf8(const char*)
    {53, 124, 0, 0, Smoke::mf_ctor, 81, 54},	//1113 Plasma::DataEngine::DataEngine()
    {53, 124, 97, 1, Smoke::mf_ctor, 81, 55},	//1114 Plasma::DataEngine::DataEngine(QObject*)
    {53, 754, 149, 2, Smoke::mf_const, 0, 56},	//1115 Plasma::DataEngine::connectSource(const QString&, QObject*) const
    {53, 754, 509, 3, Smoke::mf_const, 0, 57},	//1116 Plasma::DataEngine::connectSource(const QString&, QObject*, unsigned int) const
    {53, 749, 97, 1, Smoke::mf_const, 0, 58},	//1117 Plasma::DataEngine::connectAllSources(QObject*) const
    {53, 749, 513, 2, Smoke::mf_const, 0, 59},	//1118 Plasma::DataEngine::connectAllSources(QObject*, unsigned int) const
    {53, 807, 0, 0, 0, 148, 60},	//1119 Plasma::DataEngine::createDefaultService()
    {53, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 61},	//1120 Plasma::DataEngine::staticMetaObject() const
    {53, 2429, 0, 0, Smoke::mf_dtor, 0, 62 },	//1121 Plasma::DataEngine::~DataEngine()
    {54, 1351, 0, 0, Smoke::mf_const, 442, 1},	//1122 Plasma::DataEngineManager::metaObject() const
    {54, 1487, 1, 1, 0, 486, 2},	//1123 Plasma::DataEngineManager::qt_metacast(const char*)
    {54, 2304, 43, 2, Smoke::mf_static, 293, 3},	//1124 Plasma::DataEngineManager::tr(const char*, const char*)
    {54, 2308, 43, 2, Smoke::mf_static, 293, 4},	//1125 Plasma::DataEngineManager::trUtf8(const char*, const char*)
    {54, 2304, 46, 3, Smoke::mf_static, 293, 5},	//1126 Plasma::DataEngineManager::tr(const char*, const char*, int)
    {54, 2308, 46, 3, Smoke::mf_static, 293, 6},	//1127 Plasma::DataEngineManager::trUtf8(const char*, const char*, int)
    {54, 1485, 3, 3, 0, 477, 7},	//1128 Plasma::DataEngineManager::qt_metacall(QMetaObject::Call, int, void**)
    {54, 1646, 0, 0, Smoke::mf_static, 83, 8},	//1129 Plasma::DataEngineManager::self()
    {54, 942, 89, 1, Smoke::mf_const, 81, 9},	//1130 Plasma::DataEngineManager::engine(const QString&) const
    {54, 1297, 89, 1, 0, 81, 10},	//1131 Plasma::DataEngineManager::loadEngine(const QString&)
    {54, 2320, 89, 1, 0, 0, 11},	//1132 Plasma::DataEngineManager::unloadEngine(const QString&)
    {54, 1236, 89, 1, Smoke::mf_static, 294, 12},	//1133 Plasma::DataEngineManager::listAllEngines(const QString&)
    {54, 1261, 89, 1, Smoke::mf_static, 242, 13},	//1134 Plasma::DataEngineManager::listEngineInfo(const QString&)
    {54, 1263, 77, 2, Smoke::mf_static, 242, 14},	//1135 Plasma::DataEngineManager::listEngineInfoByCategory(const QString&, const QString&)
    {54, 2289, 176, 1, Smoke::mf_protected, 0, 15},	//1136 Plasma::DataEngineManager::timerEvent(QTimerEvent*)
    {54, 2304, 1, 1, Smoke::mf_static, 293, 16},	//1137 Plasma::DataEngineManager::tr(const char*)
    {54, 2308, 1, 1, Smoke::mf_static, 293, 17},	//1138 Plasma::DataEngineManager::trUtf8(const char*)
    {54, 1236, 0, 0, Smoke::mf_static, 294, 18},	//1139 Plasma::DataEngineManager::listAllEngines()
    {54, 1261, 0, 0, Smoke::mf_static, 242, 19},	//1140 Plasma::DataEngineManager::listEngineInfo()
    {54, 1263, 89, 1, Smoke::mf_static, 242, 20},	//1141 Plasma::DataEngineManager::listEngineInfoByCategory(const QString&)
    {54, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 21},	//1142 Plasma::DataEngineManager::staticMetaObject() const
    {55, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//1143 Plasma::DataEngineScript::metaObject() const
    {55, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//1144 Plasma::DataEngineScript::qt_metacast(const char*)
    {55, 2304, 43, 2, Smoke::mf_static, 293, 3},	//1145 Plasma::DataEngineScript::tr(const char*, const char*)
    {55, 2308, 43, 2, Smoke::mf_static, 293, 4},	//1146 Plasma::DataEngineScript::trUtf8(const char*, const char*)
    {55, 2304, 46, 3, Smoke::mf_static, 293, 5},	//1147 Plasma::DataEngineScript::tr(const char*, const char*, int)
    {55, 2308, 46, 3, Smoke::mf_static, 293, 6},	//1148 Plasma::DataEngineScript::trUtf8(const char*, const char*, int)
    {55, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//1149 Plasma::DataEngineScript::qt_metacall(QMetaObject::Call, int, void**)
    {55, 128, 97, 1, Smoke::mf_ctor, 84, 8},	//1150 Plasma::DataEngineScript::DataEngineScript(QObject*)
    {55, 1766, 516, 1, 0, 0, 9},	//1151 Plasma::DataEngineScript::setDataEngine(Plasma::DataEngine*)
    {55, 839, 0, 0, Smoke::mf_const, 81, 10},	//1152 Plasma::DataEngineScript::dataEngine() const
    {55, 2213, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 294, 11},	//1153 Plasma::DataEngineScript::sources() const
    {55, 2211, 89, 1, Smoke::mf_virtual, 386, 12},	//1154 Plasma::DataEngineScript::sourceRequestEvent(const QString&)
    {55, 2343, 89, 1, Smoke::mf_virtual, 386, 13},	//1155 Plasma::DataEngineScript::updateSourceEvent(const QString&)
    {55, 1648, 89, 1, Smoke::mf_virtual, 148, 14},	//1156 Plasma::DataEngineScript::serviceForSource(const QString&)
    {55, 1324, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 293, 15},	//1157 Plasma::DataEngineScript::mainScript() const
    {55, 1414, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 409, 16},	//1158 Plasma::DataEngineScript::package() const
    {55, 849, 0, 0, Smoke::mf_const|Smoke::mf_protected, 14, 17},	//1159 Plasma::DataEngineScript::description() const
    {55, 1761, 502, 3, Smoke::mf_protected, 0, 18},	//1160 Plasma::DataEngineScript::setData(const QString&, const QString&, const QVariant&)
    {55, 1761, 482, 2, Smoke::mf_protected, 0, 19},	//1161 Plasma::DataEngineScript::setData(const QString&, const QVariant&)
    {55, 1761, 506, 2, Smoke::mf_protected, 0, 20},	//1162 Plasma::DataEngineScript::setData(const QString&, const QHash<QString,QVariant>&)
    {55, 1531, 89, 1, Smoke::mf_protected, 0, 21},	//1163 Plasma::DataEngineScript::removeAllData(const QString&)
    {55, 1536, 77, 2, Smoke::mf_protected, 0, 22},	//1164 Plasma::DataEngineScript::removeData(const QString&, const QString&)
    {55, 1900, 17, 1, Smoke::mf_protected, 0, 23},	//1165 Plasma::DataEngineScript::setMaxSourceCount(unsigned int)
    {55, 1914, 129, 1, Smoke::mf_protected, 0, 24},	//1166 Plasma::DataEngineScript::setMinimumPollingInterval(int)
    {55, 1363, 0, 0, Smoke::mf_const|Smoke::mf_protected, 477, 25},	//1167 Plasma::DataEngineScript::minimumPollingInterval() const
    {55, 1957, 17, 1, Smoke::mf_protected, 0, 26},	//1168 Plasma::DataEngineScript::setPollingInterval(unsigned int)
    {55, 1533, 0, 0, Smoke::mf_protected, 0, 27},	//1169 Plasma::DataEngineScript::removeAllSources()
    {55, 622, 492, 1, Smoke::mf_protected, 0, 28},	//1170 Plasma::DataEngineScript::addSource(Plasma::DataContainer*)
    {55, 762, 0, 0, Smoke::mf_const|Smoke::mf_protected, 231, 29},	//1171 Plasma::DataEngineScript::containerDict() const
    {55, 1921, 89, 1, Smoke::mf_protected, 0, 30},	//1172 Plasma::DataEngineScript::setName(const QString&)
    {55, 1858, 89, 1, Smoke::mf_protected, 0, 31},	//1173 Plasma::DataEngineScript::setIcon(const QString&)
    {55, 1625, 0, 0, Smoke::mf_protected, 0, 32},	//1174 Plasma::DataEngineScript::scheduleSourcesUpdated()
    {55, 1551, 89, 1, Smoke::mf_protected, 0, 33},	//1175 Plasma::DataEngineScript::removeSource(const QString&)
    {55, 2331, 0, 0, Smoke::mf_protected, 0, 34},	//1176 Plasma::DataEngineScript::updateAllSources()
    {55, 1011, 0, 0, Smoke::mf_protected, 0, 35},	//1177 Plasma::DataEngineScript::forceImmediateUpdateOfAllVisualizations()
    {55, 2304, 1, 1, Smoke::mf_static, 293, 36},	//1178 Plasma::DataEngineScript::tr(const char*)
    {55, 2308, 1, 1, Smoke::mf_static, 293, 37},	//1179 Plasma::DataEngineScript::trUtf8(const char*)
    {55, 128, 0, 0, Smoke::mf_ctor, 84, 38},	//1180 Plasma::DataEngineScript::DataEngineScript()
    {55, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 39},	//1181 Plasma::DataEngineScript::staticMetaObject() const
    {55, 2430, 0, 0, Smoke::mf_dtor, 0, 40 },	//1182 Plasma::DataEngineScript::~DataEngineScript()
    {56, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//1183 Plasma::Delegate::metaObject() const
    {56, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//1184 Plasma::Delegate::qt_metacast(const char*)
    {56, 2304, 43, 2, Smoke::mf_static, 293, 3},	//1185 Plasma::Delegate::tr(const char*, const char*)
    {56, 2308, 43, 2, Smoke::mf_static, 293, 4},	//1186 Plasma::Delegate::trUtf8(const char*, const char*)
    {56, 2304, 46, 3, Smoke::mf_static, 293, 5},	//1187 Plasma::Delegate::tr(const char*, const char*, int)
    {56, 2308, 46, 3, Smoke::mf_static, 293, 6},	//1188 Plasma::Delegate::trUtf8(const char*, const char*, int)
    {56, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//1189 Plasma::Delegate::qt_metacall(QMetaObject::Call, int, void**)
    {56, 135, 97, 1, Smoke::mf_ctor, 85, 8},	//1190 Plasma::Delegate::Delegate(QObject*)
    {56, 1996, 518, 2, 0, 0, 9},	//1191 Plasma::Delegate::setRoleMapping(Plasma::Delegate::SpecificRoles, int)
    {56, 1595, 521, 1, Smoke::mf_const, 477, 10},	//1192 Plasma::Delegate::roleMapping(Plasma::Delegate::SpecificRoles) const
    {56, 1420, 523, 3, Smoke::mf_const|Smoke::mf_virtual, 0, 11},	//1193 Plasma::Delegate::paint(QPainter*, const QStyleOptionViewItem&, const QModelIndex&) const
    {56, 2185, 0, 0, Smoke::mf_const, 386, 12},	//1194 Plasma::Delegate::showToolTip() const
    {56, 1500, 527, 2, Smoke::mf_const|Smoke::mf_protected, 282, 13},	//1195 Plasma::Delegate::rectAfterTitle(const QStyleOptionViewItem&, const QModelIndex&) const
    {56, 1498, 527, 2, Smoke::mf_const|Smoke::mf_protected, 282, 14},	//1196 Plasma::Delegate::rectAfterSubTitle(const QStyleOptionViewItem&, const QModelIndex&) const
    {56, 934, 527, 2, Smoke::mf_const|Smoke::mf_protected, 282, 15},	//1197 Plasma::Delegate::emptyRect(const QStyleOptionViewItem&, const QModelIndex&) const
    {56, 2198, 527, 2, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 290, 16},	//1198 Plasma::Delegate::sizeHint(const QStyleOptionViewItem&, const QModelIndex&) const
    {56, 2304, 1, 1, Smoke::mf_static, 293, 17},	//1199 Plasma::Delegate::tr(const char*)
    {56, 2308, 1, 1, Smoke::mf_static, 293, 18},	//1200 Plasma::Delegate::trUtf8(const char*)
    {56, 135, 0, 0, Smoke::mf_ctor, 85, 19},	//1201 Plasma::Delegate::Delegate()
    {56, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 20},	//1202 Plasma::Delegate::staticMetaObject() const
    {56, 465, 0, 0, Smoke::mf_static|Smoke::mf_enum, 87, 21},	//1203 Plasma::Delegate::SubTitleRole (enum)
    {56, 464, 0, 0, Smoke::mf_static|Smoke::mf_enum, 87, 22},	//1204 Plasma::Delegate::SubTitleMandatoryRole (enum)
    {56, 88, 0, 0, Smoke::mf_static|Smoke::mf_enum, 87, 23},	//1205 Plasma::Delegate::ColumnTypeRole (enum)
    {56, 307, 0, 0, Smoke::mf_static|Smoke::mf_enum, 86, 24},	//1206 Plasma::Delegate::MainColumn (enum)
    {56, 428, 0, 0, Smoke::mf_static|Smoke::mf_enum, 86, 25},	//1207 Plasma::Delegate::SecondaryActionColumn (enum)
    {56, 2431, 0, 0, Smoke::mf_dtor, 0, 26 },	//1208 Plasma::Delegate::~Delegate()
    {57, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//1209 Plasma::Dialog::metaObject() const
    {57, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//1210 Plasma::Dialog::qt_metacast(const char*)
    {57, 2304, 43, 2, Smoke::mf_static, 293, 3},	//1211 Plasma::Dialog::tr(const char*, const char*)
    {57, 2308, 43, 2, Smoke::mf_static, 293, 4},	//1212 Plasma::Dialog::trUtf8(const char*, const char*)
    {57, 2304, 46, 3, Smoke::mf_static, 293, 5},	//1213 Plasma::Dialog::tr(const char*, const char*, int)
    {57, 2308, 46, 3, Smoke::mf_static, 293, 6},	//1214 Plasma::Dialog::trUtf8(const char*, const char*, int)
    {57, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//1215 Plasma::Dialog::qt_metacall(QMetaObject::Call, int, void**)
    {57, 146, 530, 2, Smoke::mf_ctor, 88, 8},	//1216 Plasma::Dialog::Dialog(QWidget*, QFlags<Qt::WindowType>)
    {57, 1832, 125, 1, 0, 0, 9},	//1217 Plasma::Dialog::setGraphicsWidget(QGraphicsWidget*)
    {57, 1033, 0, 0, 0, 229, 10},	//1218 Plasma::Dialog::graphicsWidget()
    {57, 1992, 533, 1, 0, 0, 11},	//1219 Plasma::Dialog::setResizeHandleCorners(QFlags<Plasma::Dialog::ResizeCorner>)
    {57, 1583, 0, 0, Smoke::mf_const, 203, 12},	//1220 Plasma::Dialog::resizeCorners() const
    {57, 1162, 0, 0, Smoke::mf_const, 386, 13},	//1221 Plasma::Dialog::isUserResizing() const
    {57, 1916, 535, 4, 0, 0, 14},	//1222 Plasma::Dialog::setMinimumResizeLimits(int, int, int, int)
    {57, 1025, 540, 4, 0, 0, 15},	//1223 Plasma::Dialog::getMinimumResizeLimits(int*, int*, int*, int*)
    {57, 644, 545, 1, 0, 0, 16},	//1224 Plasma::Dialog::animatedHide(Plasma::Direction)
    {57, 646, 545, 1, 0, 0, 17},	//1225 Plasma::Dialog::animatedShow(Plasma::Direction)
    {57, 676, 0, 0, Smoke::mf_const, 52, 18},	//1226 Plasma::Dialog::aspectRatioMode() const
    {57, 1676, 193, 1, 0, 0, 19},	//1227 Plasma::Dialog::setAspectRatioMode(Plasma::AspectRatioMode)
    {57, 859, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 20},	//1228 Plasma::Dialog::dialogResized()
    {57, 860, 7, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 21},	//1229 Plasma::Dialog::dialogVisible(bool)
    {57, 2253, 0, 0, Smoke::mf_slot, 0, 22},	//1230 Plasma::Dialog::syncToGraphicsWidget()
    {57, 1429, 547, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 23},	//1231 Plasma::Dialog::paintEvent(QPaintEvent*)
    {57, 952, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 386, 24},	//1232 Plasma::Dialog::event(QEvent*)
    {57, 1584, 549, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 25},	//1233 Plasma::Dialog::resizeEvent(QResizeEvent*)
    {57, 954, 272, 2, Smoke::mf_protected|Smoke::mf_virtual, 386, 26},	//1234 Plasma::Dialog::eventFilter(QObject*, QEvent*)
    {57, 1059, 326, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 27},	//1235 Plasma::Dialog::hideEvent(QHideEvent*)
    {57, 2177, 324, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 28},	//1236 Plasma::Dialog::showEvent(QShowEvent*)
    {57, 998, 280, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 29},	//1237 Plasma::Dialog::focusInEvent(QFocusEvent*)
    {57, 1368, 551, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 30},	//1238 Plasma::Dialog::mouseMoveEvent(QMouseEvent*)
    {57, 1370, 551, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 31},	//1239 Plasma::Dialog::mousePressEvent(QMouseEvent*)
    {57, 1372, 551, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 32},	//1240 Plasma::Dialog::mouseReleaseEvent(QMouseEvent*)
    {57, 1198, 396, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 33},	//1241 Plasma::Dialog::keyPressEvent(QKeyEvent*)
    {57, 1374, 553, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 34},	//1242 Plasma::Dialog::moveEvent(QMoveEvent*)
    {57, 1088, 555, 1, Smoke::mf_protected, 386, 35},	//1243 Plasma::Dialog::inControlArea(const QPoint&)
    {57, 2304, 1, 1, Smoke::mf_static, 293, 36},	//1244 Plasma::Dialog::tr(const char*)
    {57, 2308, 1, 1, Smoke::mf_static, 293, 37},	//1245 Plasma::Dialog::trUtf8(const char*)
    {57, 146, 0, 0, Smoke::mf_ctor, 88, 38},	//1246 Plasma::Dialog::Dialog()
    {57, 146, 57, 1, Smoke::mf_ctor, 88, 39},	//1247 Plasma::Dialog::Dialog(QWidget*)
    {57, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 40},	//1248 Plasma::Dialog::staticMetaObject() const
    {57, 334, 0, 0, Smoke::mf_static|Smoke::mf_enum, 89, 41},	//1249 Plasma::Dialog::NoCorner (enum)
    {57, 347, 0, 0, Smoke::mf_static|Smoke::mf_enum, 89, 42},	//1250 Plasma::Dialog::NorthEast (enum)
    {57, 452, 0, 0, Smoke::mf_static|Smoke::mf_enum, 89, 43},	//1251 Plasma::Dialog::SouthEast (enum)
    {57, 348, 0, 0, Smoke::mf_static|Smoke::mf_enum, 89, 44},	//1252 Plasma::Dialog::NorthWest (enum)
    {57, 453, 0, 0, Smoke::mf_static|Smoke::mf_enum, 89, 45},	//1253 Plasma::Dialog::SouthWest (enum)
    {57, 22, 0, 0, Smoke::mf_static|Smoke::mf_enum, 89, 46},	//1254 Plasma::Dialog::All (enum)
    {57, 2432, 0, 0, Smoke::mf_dtor, 0, 47 },	//1255 Plasma::Dialog::~Dialog()
    {58, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//1256 Plasma::Extender::metaObject() const
    {58, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//1257 Plasma::Extender::qt_metacast(const char*)
    {58, 2304, 43, 2, Smoke::mf_static, 293, 3},	//1258 Plasma::Extender::tr(const char*, const char*)
    {58, 2308, 43, 2, Smoke::mf_static, 293, 4},	//1259 Plasma::Extender::trUtf8(const char*, const char*)
    {58, 2304, 46, 3, Smoke::mf_static, 293, 5},	//1260 Plasma::Extender::tr(const char*, const char*, int)
    {58, 2308, 46, 3, Smoke::mf_static, 293, 6},	//1261 Plasma::Extender::trUtf8(const char*, const char*, int)
    {58, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//1262 Plasma::Extender::qt_metacall(QMetaObject::Call, int, void**)
    {58, 166, 252, 1, Smoke::mf_ctor, 91, 8},	//1263 Plasma::Extender::Extender(Plasma::Applet*)
    {58, 1804, 89, 1, Smoke::mf_property, 0, 9},	//1264 Plasma::Extender::setEmptyExtenderMessage(const QString&)
    {58, 933, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 10},	//1265 Plasma::Extender::emptyExtenderMessage() const
    {58, 1197, 0, 0, Smoke::mf_const, 249, 11},	//1266 Plasma::Extender::items() const
    {58, 683, 0, 0, Smoke::mf_const, 249, 12},	//1267 Plasma::Extender::attachedItems() const
    {58, 856, 0, 0, Smoke::mf_const, 249, 13},	//1268 Plasma::Extender::detachedItems() const
    {58, 1168, 89, 1, Smoke::mf_const, 94, 14},	//1269 Plasma::Extender::item(const QString&) const
    {58, 1034, 89, 1, Smoke::mf_const, 93, 15},	//1270 Plasma::Extender::group(const QString&) const
    {58, 1048, 89, 1, Smoke::mf_const, 386, 16},	//1271 Plasma::Extender::hasItem(const QString&) const
    {58, 1131, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 17},	//1272 Plasma::Extender::isEmpty() const
    {58, 1668, 557, 1, 0, 0, 18},	//1273 Plasma::Extender::setAppearance(Plasma::Extender::Appearance)
    {58, 660, 0, 0, Smoke::mf_const, 92, 19},	//1274 Plasma::Extender::appearance() const
    {58, 1037, 0, 0, Smoke::mf_const, 248, 20},	//1275 Plasma::Extender::groups() const
    {58, 664, 0, 0, Smoke::mf_const, 49, 21},	//1276 Plasma::Extender::applet() const
    {58, 1172, 559, 2, Smoke::mf_protected|Smoke::mf_virtual, 0, 22},	//1277 Plasma::Extender::itemAddedEvent(Plasma::ExtenderItem*, const QPointF&)
    {58, 1191, 229, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 23},	//1278 Plasma::Extender::itemRemovedEvent(Plasma::ExtenderItem*)
    {58, 1185, 229, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 24},	//1279 Plasma::Extender::itemHoverEnterEvent(Plasma::ExtenderItem*)
    {58, 1189, 559, 2, Smoke::mf_protected|Smoke::mf_virtual, 0, 25},	//1280 Plasma::Extender::itemHoverMoveEvent(Plasma::ExtenderItem*, const QPointF&)
    {58, 1187, 229, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 26},	//1281 Plasma::Extender::itemHoverLeaveEvent(Plasma::ExtenderItem*)
    {58, 1613, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 27},	//1282 Plasma::Extender::saveState()
    {58, 939, 229, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 204, 28},	//1283 Plasma::Extender::enabledBordersForItem(Plasma::ExtenderItem*) const
    {58, 1179, 284, 2, Smoke::mf_protected|Smoke::mf_virtual, 304, 29},	//1284 Plasma::Extender::itemChange(QGraphicsItem::GraphicsItemChange, const QVariant&)
    {58, 1584, 282, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 30},	//1285 Plasma::Extender::resizeEvent(QGraphicsSceneResizeEvent*)
    {58, 1370, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 31},	//1286 Plasma::Extender::mousePressEvent(QGraphicsSceneMouseEvent*)
    {58, 876, 400, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 32},	//1287 Plasma::Extender::dragEnterEvent(QGraphicsSceneDragDropEvent*)
    {58, 880, 400, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 33},	//1288 Plasma::Extender::dragMoveEvent(QGraphicsSceneDragDropEvent*)
    {58, 878, 400, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 34},	//1289 Plasma::Extender::dragLeaveEvent(QGraphicsSceneDragDropEvent*)
    {58, 906, 400, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 35},	//1290 Plasma::Extender::dropEvent(QGraphicsSceneDragDropEvent*)
    {58, 1177, 229, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 36},	//1291 Plasma::Extender::itemAttached(Plasma::ExtenderItem*)
    {58, 1181, 229, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 37},	//1292 Plasma::Extender::itemDetached(Plasma::ExtenderItem*)
    {58, 1020, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 38},	//1293 Plasma::Extender::geometryChanged()
    {58, 2304, 1, 1, Smoke::mf_static, 293, 39},	//1294 Plasma::Extender::tr(const char*)
    {58, 2308, 1, 1, Smoke::mf_static, 293, 40},	//1295 Plasma::Extender::trUtf8(const char*)
    {58, 1172, 229, 1, Smoke::mf_protected, 0, 41},	//1296 Plasma::Extender::itemAddedEvent(Plasma::ExtenderItem*)
    {58, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 42},	//1297 Plasma::Extender::staticMetaObject() const
    {58, 328, 0, 0, Smoke::mf_static|Smoke::mf_enum, 92, 43},	//1298 Plasma::Extender::NoBorders (enum)
    {58, 64, 0, 0, Smoke::mf_static|Smoke::mf_enum, 92, 44},	//1299 Plasma::Extender::BottomUpStacked (enum)
    {58, 496, 0, 0, Smoke::mf_static|Smoke::mf_enum, 92, 45},	//1300 Plasma::Extender::TopDownStacked (enum)
    {58, 2433, 0, 0, Smoke::mf_dtor, 0, 46 },	//1301 Plasma::Extender::~Extender()
    {59, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//1302 Plasma::ExtenderGroup::metaObject() const
    {59, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//1303 Plasma::ExtenderGroup::qt_metacast(const char*)
    {59, 2304, 43, 2, Smoke::mf_static, 293, 3},	//1304 Plasma::ExtenderGroup::tr(const char*, const char*)
    {59, 2308, 43, 2, Smoke::mf_static, 293, 4},	//1305 Plasma::ExtenderGroup::trUtf8(const char*, const char*)
    {59, 2304, 46, 3, Smoke::mf_static, 293, 5},	//1306 Plasma::ExtenderGroup::tr(const char*, const char*, int)
    {59, 2308, 46, 3, Smoke::mf_static, 293, 6},	//1307 Plasma::ExtenderGroup::trUtf8(const char*, const char*, int)
    {59, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//1308 Plasma::ExtenderGroup::qt_metacall(QMetaObject::Call, int, void**)
    {59, 168, 562, 2, Smoke::mf_ctor, 93, 8},	//1309 Plasma::ExtenderGroup::ExtenderGroup(Plasma::Extender*, unsigned int)
    {59, 1197, 0, 0, Smoke::mf_const, 249, 9},	//1310 Plasma::ExtenderGroup::items() const
    {59, 689, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 10},	//1311 Plasma::ExtenderGroup::autoHide() const
    {59, 1692, 7, 1, Smoke::mf_property, 0, 11},	//1312 Plasma::ExtenderGroup::setAutoHide(bool)
    {59, 1134, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 12},	//1313 Plasma::ExtenderGroup::isGroupCollapsed() const
    {59, 1121, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 13},	//1314 Plasma::ExtenderGroup::isAutoCollapse() const
    {59, 1688, 7, 1, Smoke::mf_property, 0, 14},	//1315 Plasma::ExtenderGroup::setAutoCollapse(bool)
    {59, 1837, 7, 1, Smoke::mf_property|Smoke::mf_slot, 0, 15},	//1316 Plasma::ExtenderGroup::setGroupCollapsed(bool)
    {59, 963, 0, 0, Smoke::mf_slot, 0, 16},	//1317 Plasma::ExtenderGroup::expandGroup()
    {59, 732, 0, 0, Smoke::mf_slot, 0, 17},	//1318 Plasma::ExtenderGroup::collapseGroup()
    {59, 1584, 282, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 18},	//1319 Plasma::ExtenderGroup::resizeEvent(QGraphicsSceneResizeEvent*)
    {59, 954, 272, 2, Smoke::mf_protected|Smoke::mf_virtual, 386, 19},	//1320 Plasma::ExtenderGroup::eventFilter(QObject*, QEvent*)
    {59, 876, 400, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 20},	//1321 Plasma::ExtenderGroup::dragEnterEvent(QGraphicsSceneDragDropEvent*)
    {59, 880, 400, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 21},	//1322 Plasma::ExtenderGroup::dragMoveEvent(QGraphicsSceneDragDropEvent*)
    {59, 878, 400, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 22},	//1323 Plasma::ExtenderGroup::dragLeaveEvent(QGraphicsSceneDragDropEvent*)
    {59, 906, 400, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 23},	//1324 Plasma::ExtenderGroup::dropEvent(QGraphicsSceneDragDropEvent*)
    {59, 2304, 1, 1, Smoke::mf_static, 293, 24},	//1325 Plasma::ExtenderGroup::tr(const char*)
    {59, 2308, 1, 1, Smoke::mf_static, 293, 25},	//1326 Plasma::ExtenderGroup::trUtf8(const char*)
    {59, 168, 565, 1, Smoke::mf_ctor, 93, 26},	//1327 Plasma::ExtenderGroup::ExtenderGroup(Plasma::Extender*)
    {59, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 27},	//1328 Plasma::ExtenderGroup::staticMetaObject() const
    {59, 2434, 0, 0, Smoke::mf_dtor, 0, 28 },	//1329 Plasma::ExtenderGroup::~ExtenderGroup()
    {60, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//1330 Plasma::ExtenderItem::metaObject() const
    {60, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//1331 Plasma::ExtenderItem::qt_metacast(const char*)
    {60, 2304, 43, 2, Smoke::mf_static, 293, 3},	//1332 Plasma::ExtenderItem::tr(const char*, const char*)
    {60, 2308, 43, 2, Smoke::mf_static, 293, 4},	//1333 Plasma::ExtenderItem::trUtf8(const char*, const char*)
    {60, 2304, 46, 3, Smoke::mf_static, 293, 5},	//1334 Plasma::ExtenderItem::tr(const char*, const char*, int)
    {60, 2308, 46, 3, Smoke::mf_static, 293, 6},	//1335 Plasma::ExtenderItem::trUtf8(const char*, const char*, int)
    {60, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//1336 Plasma::ExtenderItem::qt_metacall(QMetaObject::Call, int, void**)
    {60, 171, 562, 2, Smoke::mf_ctor, 94, 8},	//1337 Plasma::ExtenderItem::ExtenderItem(Plasma::Extender*, unsigned int)
    {60, 738, 0, 0, Smoke::mf_const, 8, 9},	//1338 Plasma::ExtenderItem::config() const
    {60, 2149, 170, 1, 0, 0, 10},	//1339 Plasma::ExtenderItem::setWidget(QGraphicsItem*)
    {60, 2391, 0, 0, Smoke::mf_const, 214, 11},	//1340 Plasma::ExtenderItem::widget() const
    {60, 2094, 89, 1, Smoke::mf_property, 0, 12},	//1341 Plasma::ExtenderItem::setTitle(const QString&)
    {60, 2291, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 13},	//1342 Plasma::ExtenderItem::title() const
    {60, 1921, 89, 1, Smoke::mf_property, 0, 14},	//1343 Plasma::ExtenderItem::setName(const QString&)
    {60, 1386, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 15},	//1344 Plasma::ExtenderItem::name() const
    {60, 1858, 89, 1, 0, 0, 16},	//1345 Plasma::ExtenderItem::setIcon(const QString&)
    {60, 1858, 567, 1, Smoke::mf_property, 0, 17},	//1346 Plasma::ExtenderItem::setIcon(const QIcon&)
    {60, 1075, 0, 0, Smoke::mf_const|Smoke::mf_property, 236, 18},	//1347 Plasma::ExtenderItem::icon() const
    {60, 1810, 569, 2, 0, 0, 19},	//1348 Plasma::ExtenderItem::setExtender(Plasma::Extender*, const QPointF&)
    {60, 966, 0, 0, Smoke::mf_const, 91, 20},	//1349 Plasma::ExtenderItem::extender() const
    {60, 1834, 572, 1, 0, 0, 21},	//1350 Plasma::ExtenderItem::setGroup(Plasma::ExtenderGroup*)
    {60, 1834, 574, 2, 0, 0, 22},	//1351 Plasma::ExtenderItem::setGroup(Plasma::ExtenderGroup*, const QPointF&)
    {60, 1034, 0, 0, Smoke::mf_const, 93, 23},	//1352 Plasma::ExtenderItem::group() const
    {60, 1133, 0, 0, Smoke::mf_const, 386, 24},	//1353 Plasma::ExtenderItem::isGroup() const
    {60, 1690, 17, 1, 0, 0, 25},	//1354 Plasma::ExtenderItem::setAutoExpireDelay(unsigned int)
    {60, 688, 0, 0, Smoke::mf_const, 484, 26},	//1355 Plasma::ExtenderItem::autoExpireDelay() const
    {60, 1129, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 27},	//1356 Plasma::ExtenderItem::isDetached() const
    {60, 1127, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 28},	//1357 Plasma::ExtenderItem::isCollapsed() const
    {60, 574, 86, 2, 0, 0, 29},	//1358 Plasma::ExtenderItem::addAction(const QString&, QAction*)
    {60, 557, 89, 1, Smoke::mf_const, 183, 30},	//1359 Plasma::ExtenderItem::action(const QString&) const
    {60, 2102, 109, 1, 0, 0, 31},	//1360 Plasma::ExtenderItem::setTransient(const bool)
    {60, 1160, 0, 0, Smoke::mf_const, 386, 32},	//1361 Plasma::ExtenderItem::isTransient() const
    {60, 852, 0, 0, Smoke::mf_slot, 0, 33},	//1362 Plasma::ExtenderItem::destroy()
    {60, 1722, 7, 1, Smoke::mf_property|Smoke::mf_slot, 0, 34},	//1363 Plasma::ExtenderItem::setCollapsed(bool)
    {60, 1594, 0, 0, Smoke::mf_slot, 0, 35},	//1364 Plasma::ExtenderItem::returnToSource()
    {60, 2168, 0, 0, Smoke::mf_slot, 0, 36},	//1365 Plasma::ExtenderItem::showCloseButton()
    {60, 1058, 0, 0, Smoke::mf_slot, 0, 37},	//1366 Plasma::ExtenderItem::hideCloseButton()
    {60, 854, 229, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 38},	//1367 Plasma::ExtenderItem::destroyed(Plasma::ExtenderItem*)
    {60, 1420, 216, 3, Smoke::mf_protected|Smoke::mf_virtual, 0, 39},	//1368 Plasma::ExtenderItem::paint(QPainter*, const QStyleOptionGraphicsItem*, QWidget*)
    {60, 1374, 577, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 40},	//1369 Plasma::ExtenderItem::moveEvent(QGraphicsSceneMoveEvent*)
    {60, 1584, 282, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 41},	//1370 Plasma::ExtenderItem::resizeEvent(QGraphicsSceneResizeEvent*)
    {60, 1370, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 42},	//1371 Plasma::ExtenderItem::mousePressEvent(QGraphicsSceneMouseEvent*)
    {60, 1366, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 43},	//1372 Plasma::ExtenderItem::mouseDoubleClickEvent(QGraphicsSceneMouseEvent*)
    {60, 1368, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 44},	//1373 Plasma::ExtenderItem::mouseMoveEvent(QGraphicsSceneMouseEvent*)
    {60, 1372, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 45},	//1374 Plasma::ExtenderItem::mouseReleaseEvent(QGraphicsSceneMouseEvent*)
    {60, 1072, 290, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 46},	//1375 Plasma::ExtenderItem::hoverMoveEvent(QGraphicsSceneHoverEvent*)
    {60, 1070, 290, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 47},	//1376 Plasma::ExtenderItem::hoverLeaveEvent(QGraphicsSceneHoverEvent*)
    {60, 1621, 275, 2, Smoke::mf_protected|Smoke::mf_virtual, 386, 48},	//1377 Plasma::ExtenderItem::sceneEventFilter(QGraphicsItem*, QEvent*)
    {60, 2198, 287, 2, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 291, 49},	//1378 Plasma::ExtenderItem::sizeHint(Qt::SizeHint, const QSizeF&) const
    {60, 2304, 1, 1, Smoke::mf_static, 293, 50},	//1379 Plasma::ExtenderItem::tr(const char*)
    {60, 2308, 1, 1, Smoke::mf_static, 293, 51},	//1380 Plasma::ExtenderItem::trUtf8(const char*)
    {60, 171, 565, 1, Smoke::mf_ctor, 94, 52},	//1381 Plasma::ExtenderItem::ExtenderItem(Plasma::Extender*)
    {60, 1810, 565, 1, 0, 0, 53},	//1382 Plasma::ExtenderItem::setExtender(Plasma::Extender*)
    {60, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 54},	//1383 Plasma::ExtenderItem::staticMetaObject() const
    {60, 2435, 0, 0, Smoke::mf_dtor, 0, 55 },	//1384 Plasma::ExtenderItem::~ExtenderItem()
    {61, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//1385 Plasma::FlashingLabel::metaObject() const
    {61, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//1386 Plasma::FlashingLabel::qt_metacast(const char*)
    {61, 2304, 43, 2, Smoke::mf_static, 293, 3},	//1387 Plasma::FlashingLabel::tr(const char*, const char*)
    {61, 2308, 43, 2, Smoke::mf_static, 293, 4},	//1388 Plasma::FlashingLabel::trUtf8(const char*, const char*)
    {61, 2304, 46, 3, Smoke::mf_static, 293, 5},	//1389 Plasma::FlashingLabel::tr(const char*, const char*, int)
    {61, 2308, 46, 3, Smoke::mf_static, 293, 6},	//1390 Plasma::FlashingLabel::trUtf8(const char*, const char*, int)
    {61, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//1391 Plasma::FlashingLabel::qt_metacall(QMetaObject::Call, int, void**)
    {61, 181, 170, 1, Smoke::mf_ctor, 95, 8},	//1392 Plasma::FlashingLabel::FlashingLabel(QGraphicsItem*)
    {61, 1420, 216, 3, Smoke::mf_virtual, 0, 9},	//1393 Plasma::FlashingLabel::paint(QPainter*, const QStyleOptionGraphicsItem*, QWidget*)
    {61, 1005, 0, 0, Smoke::mf_const|Smoke::mf_property, 211, 10},	//1394 Plasma::FlashingLabel::font() const
    {61, 1819, 579, 1, Smoke::mf_property, 0, 11},	//1395 Plasma::FlashingLabel::setFont(const QFont&)
    {61, 735, 0, 0, Smoke::mf_const|Smoke::mf_property, 189, 12},	//1396 Plasma::FlashingLabel::color() const
    {61, 1724, 581, 1, Smoke::mf_property, 0, 13},	//1397 Plasma::FlashingLabel::setColor(const QColor&)
    {61, 908, 0, 0, Smoke::mf_const|Smoke::mf_property, 477, 14},	//1398 Plasma::FlashingLabel::duration() const
    {61, 1793, 129, 1, Smoke::mf_property, 0, 15},	//1399 Plasma::FlashingLabel::setDuration(int)
    {61, 988, 583, 3, 0, 0, 16},	//1400 Plasma::FlashingLabel::flash(const QString&, int, const QTextOption&)
    {61, 988, 587, 3, 0, 0, 17},	//1401 Plasma::FlashingLabel::flash(const QPixmap&, int, QFlags<Qt::AlignmentFlag>)
    {61, 1696, 7, 1, Smoke::mf_property, 0, 18},	//1402 Plasma::FlashingLabel::setAutohide(bool)
    {61, 691, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 19},	//1403 Plasma::FlashingLabel::autohide() const
    {61, 2198, 287, 2, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 291, 20},	//1404 Plasma::FlashingLabel::sizeHint(Qt::SizeHint, const QSizeF&) const
    {61, 1203, 0, 0, Smoke::mf_slot, 0, 21},	//1405 Plasma::FlashingLabel::kill()
    {61, 970, 0, 0, Smoke::mf_protected|Smoke::mf_slot, 0, 22},	//1406 Plasma::FlashingLabel::fadeIn()
    {61, 971, 0, 0, Smoke::mf_protected|Smoke::mf_slot, 0, 23},	//1407 Plasma::FlashingLabel::fadeOut()
    {61, 2304, 1, 1, Smoke::mf_static, 293, 24},	//1408 Plasma::FlashingLabel::tr(const char*)
    {61, 2308, 1, 1, Smoke::mf_static, 293, 25},	//1409 Plasma::FlashingLabel::trUtf8(const char*)
    {61, 181, 0, 0, Smoke::mf_ctor, 95, 26},	//1410 Plasma::FlashingLabel::FlashingLabel()
    {61, 1420, 328, 2, 0, 0, 27},	//1411 Plasma::FlashingLabel::paint(QPainter*, const QStyleOptionGraphicsItem*)
    {61, 988, 89, 1, 0, 0, 28},	//1412 Plasma::FlashingLabel::flash(const QString&)
    {61, 988, 591, 2, 0, 0, 29},	//1413 Plasma::FlashingLabel::flash(const QString&, int)
    {61, 988, 594, 1, 0, 0, 30},	//1414 Plasma::FlashingLabel::flash(const QPixmap&)
    {61, 988, 596, 2, 0, 0, 31},	//1415 Plasma::FlashingLabel::flash(const QPixmap&, int)
    {61, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 32},	//1416 Plasma::FlashingLabel::staticMetaObject() const
    {61, 2436, 0, 0, Smoke::mf_dtor, 0, 33 },	//1417 Plasma::FlashingLabel::~FlashingLabel()
    {62, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//1418 Plasma::Frame::metaObject() const
    {62, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//1419 Plasma::Frame::qt_metacast(const char*)
    {62, 2304, 43, 2, Smoke::mf_static, 293, 3},	//1420 Plasma::Frame::tr(const char*, const char*)
    {62, 2308, 43, 2, Smoke::mf_static, 293, 4},	//1421 Plasma::Frame::trUtf8(const char*, const char*)
    {62, 2304, 46, 3, Smoke::mf_static, 293, 5},	//1422 Plasma::Frame::tr(const char*, const char*, int)
    {62, 2308, 46, 3, Smoke::mf_static, 293, 6},	//1423 Plasma::Frame::trUtf8(const char*, const char*, int)
    {62, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//1424 Plasma::Frame::qt_metacall(QMetaObject::Call, int, void**)
    {62, 188, 125, 1, Smoke::mf_ctor, 98, 8},	//1425 Plasma::Frame::Frame(QGraphicsWidget*)
    {62, 1826, 599, 1, Smoke::mf_property, 0, 9},	//1426 Plasma::Frame::setFrameShadow(Plasma::Frame::Shadow)
    {62, 1015, 0, 0, Smoke::mf_const|Smoke::mf_property, 99, 10},	//1427 Plasma::Frame::frameShadow() const
    {62, 1808, 601, 1, 0, 0, 11},	//1428 Plasma::Frame::setEnabledBorders(const QFlags<Plasma::FrameSvg::EnabledBorder>)
    {62, 938, 0, 0, Smoke::mf_const, 204, 12},	//1429 Plasma::Frame::enabledBorders() const
    {62, 2080, 220, 1, Smoke::mf_property, 0, 13},	//1430 Plasma::Frame::setText(QString)
    {62, 2274, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 14},	//1431 Plasma::Frame::text() const
    {62, 1865, 89, 1, Smoke::mf_property, 0, 15},	//1432 Plasma::Frame::setImage(const QString&)
    {62, 1079, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 16},	//1433 Plasma::Frame::image() const
    {62, 2048, 89, 1, Smoke::mf_property, 0, 17},	//1434 Plasma::Frame::setStyleSheet(const QString&)
    {62, 2236, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 18},	//1435 Plasma::Frame::styleSheet() const
    {62, 1388, 0, 0, Smoke::mf_const, 309, 19},	//1436 Plasma::Frame::nativeWidget() const
    {62, 1420, 216, 3, Smoke::mf_protected|Smoke::mf_virtual, 0, 20},	//1437 Plasma::Frame::paint(QPainter*, const QStyleOptionGraphicsItem*, QWidget*)
    {62, 1584, 282, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 21},	//1438 Plasma::Frame::resizeEvent(QGraphicsSceneResizeEvent*)
    {62, 2198, 287, 2, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 291, 22},	//1439 Plasma::Frame::sizeHint(Qt::SizeHint, const QSizeF&) const
    {62, 710, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 23},	//1440 Plasma::Frame::changeEvent(QEvent*)
    {62, 2304, 1, 1, Smoke::mf_static, 293, 24},	//1441 Plasma::Frame::tr(const char*)
    {62, 2308, 1, 1, Smoke::mf_static, 293, 25},	//1442 Plasma::Frame::trUtf8(const char*)
    {62, 188, 0, 0, Smoke::mf_ctor, 98, 26},	//1443 Plasma::Frame::Frame()
    {62, 1420, 328, 2, Smoke::mf_protected, 0, 27},	//1444 Plasma::Frame::paint(QPainter*, const QStyleOptionGraphicsItem*)
    {62, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 28},	//1445 Plasma::Frame::staticMetaObject() const
    {62, 372, 0, 0, Smoke::mf_static|Smoke::mf_enum, 99, 29},	//1446 Plasma::Frame::Plain (enum)
    {62, 392, 0, 0, Smoke::mf_static|Smoke::mf_enum, 99, 30},	//1447 Plasma::Frame::Raised (enum)
    {62, 467, 0, 0, Smoke::mf_static|Smoke::mf_enum, 99, 31},	//1448 Plasma::Frame::Sunken (enum)
    {62, 2437, 0, 0, Smoke::mf_dtor, 0, 32 },	//1449 Plasma::Frame::~Frame()
    {63, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//1450 Plasma::FrameSvg::metaObject() const
    {63, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//1451 Plasma::FrameSvg::qt_metacast(const char*)
    {63, 2304, 43, 2, Smoke::mf_static, 293, 3},	//1452 Plasma::FrameSvg::tr(const char*, const char*)
    {63, 2308, 43, 2, Smoke::mf_static, 293, 4},	//1453 Plasma::FrameSvg::trUtf8(const char*, const char*)
    {63, 2304, 46, 3, Smoke::mf_static, 293, 5},	//1454 Plasma::FrameSvg::tr(const char*, const char*, int)
    {63, 2308, 46, 3, Smoke::mf_static, 293, 6},	//1455 Plasma::FrameSvg::trUtf8(const char*, const char*, int)
    {63, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//1456 Plasma::FrameSvg::qt_metacall(QMetaObject::Call, int, void**)
    {63, 190, 97, 1, Smoke::mf_ctor, 100, 8},	//1457 Plasma::FrameSvg::FrameSvg(QObject*)
    {63, 1869, 89, 1, 0, 0, 9},	//1458 Plasma::FrameSvg::setImagePath(const QString&)
    {63, 1808, 601, 1, 0, 0, 10},	//1459 Plasma::FrameSvg::setEnabledBorders(const QFlags<Plasma::FrameSvg::EnabledBorder>)
    {63, 938, 0, 0, Smoke::mf_const, 204, 11},	//1460 Plasma::FrameSvg::enabledBorders() const
    {63, 1586, 603, 1, 0, 0, 12},	//1461 Plasma::FrameSvg::resizeFrame(const QSizeF&)
    {63, 1016, 0, 0, Smoke::mf_const, 291, 13},	//1462 Plasma::FrameSvg::frameSize() const
    {63, 1333, 605, 1, Smoke::mf_const, 474, 14},	//1463 Plasma::FrameSvg::marginSize(const Plasma::MarginEdge) const
    {63, 1023, 607, 4, Smoke::mf_const, 0, 15},	//1464 Plasma::FrameSvg::getMargins(double&, double&, double&, double&) const
    {63, 786, 0, 0, Smoke::mf_const, 283, 16},	//1465 Plasma::FrameSvg::contentsRect() const
    {63, 1800, 25, 1, 0, 0, 17},	//1466 Plasma::FrameSvg::setElementPrefix(Plasma::Location)
    {63, 1800, 89, 1, 0, 0, 18},	//1467 Plasma::FrameSvg::setElementPrefix(const QString&)
    {63, 1043, 89, 1, Smoke::mf_const, 386, 19},	//1468 Plasma::FrameSvg::hasElementPrefix(const QString&) const
    {63, 1043, 25, 1, Smoke::mf_const, 386, 20},	//1469 Plasma::FrameSvg::hasElementPrefix(Plasma::Location) const
    {63, 1474, 0, 0, 0, 293, 21},	//1470 Plasma::FrameSvg::prefix()
    {63, 1335, 0, 0, Smoke::mf_const, 286, 22},	//1471 Plasma::FrameSvg::mask() const
    {63, 643, 0, 0, Smoke::mf_const, 277, 23},	//1472 Plasma::FrameSvg::alphaMask() const
    {63, 1706, 7, 1, 0, 0, 24},	//1473 Plasma::FrameSvg::setCacheAllRenderedFrames(bool)
    {63, 705, 0, 0, Smoke::mf_const, 386, 25},	//1474 Plasma::FrameSvg::cacheAllRenderedFrames() const
    {63, 720, 0, 0, 0, 0, 26},	//1475 Plasma::FrameSvg::clearCache()
    {63, 1014, 0, 0, 0, 277, 27},	//1476 Plasma::FrameSvg::framePixmap()
    {63, 1431, 612, 3, 0, 0, 28},	//1477 Plasma::FrameSvg::paintFrame(QPainter*, const QRectF&, const QRectF&)
    {63, 1431, 616, 2, 0, 0, 29},	//1478 Plasma::FrameSvg::paintFrame(QPainter*, const QPointF&)
    {63, 2304, 1, 1, Smoke::mf_static, 293, 30},	//1479 Plasma::FrameSvg::tr(const char*)
    {63, 2308, 1, 1, Smoke::mf_static, 293, 31},	//1480 Plasma::FrameSvg::trUtf8(const char*)
    {63, 190, 0, 0, Smoke::mf_ctor, 100, 32},	//1481 Plasma::FrameSvg::FrameSvg()
    {63, 1431, 619, 2, 0, 0, 33},	//1482 Plasma::FrameSvg::paintFrame(QPainter*, const QRectF&)
    {63, 1431, 622, 1, 0, 0, 34},	//1483 Plasma::FrameSvg::paintFrame(QPainter*)
    {63, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 35},	//1484 Plasma::FrameSvg::staticMetaObject() const
    {63, 327, 0, 0, Smoke::mf_static|Smoke::mf_enum, 101, 36},	//1485 Plasma::FrameSvg::NoBorder (enum)
    {63, 495, 0, 0, Smoke::mf_static|Smoke::mf_enum, 101, 37},	//1486 Plasma::FrameSvg::TopBorder (enum)
    {63, 58, 0, 0, Smoke::mf_static|Smoke::mf_enum, 101, 38},	//1487 Plasma::FrameSvg::BottomBorder (enum)
    {63, 293, 0, 0, Smoke::mf_static|Smoke::mf_enum, 101, 39},	//1488 Plasma::FrameSvg::LeftBorder (enum)
    {63, 395, 0, 0, Smoke::mf_static|Smoke::mf_enum, 101, 40},	//1489 Plasma::FrameSvg::RightBorder (enum)
    {63, 23, 0, 0, Smoke::mf_static|Smoke::mf_enum, 101, 41},	//1490 Plasma::FrameSvg::AllBorders (enum)
    {63, 2438, 0, 0, Smoke::mf_dtor, 0, 42 },	//1491 Plasma::FrameSvg::~FrameSvg()
    {64, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//1492 Plasma::GLApplet::metaObject() const
    {64, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//1493 Plasma::GLApplet::qt_metacast(const char*)
    {64, 2304, 43, 2, Smoke::mf_static, 293, 3},	//1494 Plasma::GLApplet::tr(const char*, const char*)
    {64, 2308, 43, 2, Smoke::mf_static, 293, 4},	//1495 Plasma::GLApplet::trUtf8(const char*, const char*)
    {64, 2304, 46, 3, Smoke::mf_static, 293, 5},	//1496 Plasma::GLApplet::tr(const char*, const char*, int)
    {64, 2308, 46, 3, Smoke::mf_static, 293, 6},	//1497 Plasma::GLApplet::trUtf8(const char*, const char*, int)
    {64, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//1498 Plasma::GLApplet::qt_metacall(QMetaObject::Call, int, void**)
    {64, 194, 624, 3, Smoke::mf_ctor, 102, 8},	//1499 Plasma::GLApplet::GLApplet(QGraphicsItem*, const QString&, int)
    {64, 194, 70, 2, Smoke::mf_ctor, 102, 9},	//1500 Plasma::GLApplet::GLApplet(QObject*, const QList<QVariant>&)
    {64, 701, 628, 2, 0, 2, 10},	//1501 Plasma::GLApplet::bindTexture(const QImage&, GLenum)
    {64, 847, 631, 1, 0, 0, 11},	//1502 Plasma::GLApplet::deleteTexture(GLuint)
    {64, 1435, 328, 2, Smoke::mf_virtual, 0, 12},	//1503 Plasma::GLApplet::paintGLInterface(QPainter*, const QStyleOptionGraphicsItem*)
    {64, 1326, 0, 0, 0, 0, 13},	//1504 Plasma::GLApplet::makeCurrent()
    {64, 2304, 1, 1, Smoke::mf_static, 293, 14},	//1505 Plasma::GLApplet::tr(const char*)
    {64, 2308, 1, 1, Smoke::mf_static, 293, 15},	//1506 Plasma::GLApplet::trUtf8(const char*)
    {64, 701, 633, 1, 0, 2, 16},	//1507 Plasma::GLApplet::bindTexture(const QImage&)
    {64, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 17},	//1508 Plasma::GLApplet::staticMetaObject() const
    {64, 2439, 0, 0, Smoke::mf_dtor, 0, 18 },	//1509 Plasma::GLApplet::~GLApplet()
    {65, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//1510 Plasma::GroupBox::metaObject() const
    {65, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//1511 Plasma::GroupBox::qt_metacast(const char*)
    {65, 2304, 43, 2, Smoke::mf_static, 293, 3},	//1512 Plasma::GroupBox::tr(const char*, const char*)
    {65, 2308, 43, 2, Smoke::mf_static, 293, 4},	//1513 Plasma::GroupBox::trUtf8(const char*, const char*)
    {65, 2304, 46, 3, Smoke::mf_static, 293, 5},	//1514 Plasma::GroupBox::tr(const char*, const char*, int)
    {65, 2308, 46, 3, Smoke::mf_static, 293, 6},	//1515 Plasma::GroupBox::trUtf8(const char*, const char*, int)
    {65, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//1516 Plasma::GroupBox::qt_metacall(QMetaObject::Call, int, void**)
    {65, 199, 125, 1, Smoke::mf_ctor, 103, 8},	//1517 Plasma::GroupBox::GroupBox(QGraphicsWidget*)
    {65, 2080, 89, 1, Smoke::mf_property, 0, 9},	//1518 Plasma::GroupBox::setText(const QString&)
    {65, 2274, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 10},	//1519 Plasma::GroupBox::text() const
    {65, 2048, 89, 1, Smoke::mf_property, 0, 11},	//1520 Plasma::GroupBox::setStyleSheet(const QString&)
    {65, 2236, 0, 0, Smoke::mf_property, 293, 12},	//1521 Plasma::GroupBox::styleSheet()
    {65, 1388, 0, 0, Smoke::mf_const, 230, 13},	//1522 Plasma::GroupBox::nativeWidget() const
    {65, 1584, 282, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 14},	//1523 Plasma::GroupBox::resizeEvent(QGraphicsSceneResizeEvent*)
    {65, 710, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 15},	//1524 Plasma::GroupBox::changeEvent(QEvent*)
    {65, 2304, 1, 1, Smoke::mf_static, 293, 16},	//1525 Plasma::GroupBox::tr(const char*)
    {65, 2308, 1, 1, Smoke::mf_static, 293, 17},	//1526 Plasma::GroupBox::trUtf8(const char*)
    {65, 199, 0, 0, Smoke::mf_ctor, 103, 18},	//1527 Plasma::GroupBox::GroupBox()
    {65, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 19},	//1528 Plasma::GroupBox::staticMetaObject() const
    {65, 2440, 0, 0, Smoke::mf_dtor, 0, 20 },	//1529 Plasma::GroupBox::~GroupBox()
    {66, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//1530 Plasma::IconWidget::metaObject() const
    {66, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//1531 Plasma::IconWidget::qt_metacast(const char*)
    {66, 2304, 43, 2, Smoke::mf_static, 293, 3},	//1532 Plasma::IconWidget::tr(const char*, const char*)
    {66, 2308, 43, 2, Smoke::mf_static, 293, 4},	//1533 Plasma::IconWidget::trUtf8(const char*, const char*)
    {66, 2304, 46, 3, Smoke::mf_static, 293, 5},	//1534 Plasma::IconWidget::tr(const char*, const char*, int)
    {66, 2308, 46, 3, Smoke::mf_static, 293, 6},	//1535 Plasma::IconWidget::trUtf8(const char*, const char*, int)
    {66, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//1536 Plasma::IconWidget::qt_metacall(QMetaObject::Call, int, void**)
    {66, 212, 170, 1, Smoke::mf_ctor, 104, 8},	//1537 Plasma::IconWidget::IconWidget(QGraphicsItem*)
    {66, 212, 635, 2, Smoke::mf_ctor, 104, 9},	//1538 Plasma::IconWidget::IconWidget(const QString&, QGraphicsItem*)
    {66, 212, 638, 3, Smoke::mf_ctor, 104, 10},	//1539 Plasma::IconWidget::IconWidget(const QIcon&, const QString&, QGraphicsItem*)
    {66, 2274, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 11},	//1540 Plasma::IconWidget::text() const
    {66, 2080, 89, 1, Smoke::mf_property, 0, 12},	//1541 Plasma::IconWidget::setText(const QString&)
    {66, 2054, 77, 2, 0, 0, 13},	//1542 Plasma::IconWidget::setSvg(const QString&, const QString&)
    {66, 2246, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 14},	//1543 Plasma::IconWidget::svg() const
    {66, 1090, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 15},	//1544 Plasma::IconWidget::infoText() const
    {66, 1875, 89, 1, Smoke::mf_property, 0, 16},	//1545 Plasma::IconWidget::setInfoText(const QString&)
    {66, 1075, 0, 0, Smoke::mf_const|Smoke::mf_property, 236, 17},	//1546 Plasma::IconWidget::icon() const
    {66, 1858, 567, 1, Smoke::mf_property, 0, 18},	//1547 Plasma::IconWidget::setIcon(const QIcon&)
    {66, 2275, 0, 0, Smoke::mf_const|Smoke::mf_property, 189, 19},	//1548 Plasma::IconWidget::textBackgroundColor() const
    {66, 2082, 581, 1, Smoke::mf_property, 0, 20},	//1549 Plasma::IconWidget::setTextBackgroundColor(const QColor&)
    {66, 1858, 89, 1, 0, 0, 21},	//1550 Plasma::IconWidget::setIcon(const QString&)
    {66, 1076, 0, 0, Smoke::mf_const|Smoke::mf_property, 291, 22},	//1551 Plasma::IconWidget::iconSize() const
    {66, 1964, 603, 1, Smoke::mf_property, 0, 23},	//1552 Plasma::IconWidget::setPreferredIconSize(const QSizeF&)
    {66, 1471, 0, 0, Smoke::mf_const|Smoke::mf_property, 291, 24},	//1553 Plasma::IconWidget::preferredIconSize() const
    {66, 1912, 603, 1, Smoke::mf_property, 0, 25},	//1554 Plasma::IconWidget::setMinimumIconSize(const QSizeF&)
    {66, 1362, 0, 0, Smoke::mf_const|Smoke::mf_property, 291, 26},	//1555 Plasma::IconWidget::minimumIconSize() const
    {66, 1904, 603, 1, Smoke::mf_property, 0, 27},	//1556 Plasma::IconWidget::setMaximumIconSize(const QSizeF&)
    {66, 1347, 0, 0, Smoke::mf_const|Smoke::mf_property, 291, 28},	//1557 Plasma::IconWidget::maximumIconSize() const
    {66, 599, 107, 1, 0, 0, 29},	//1558 Plasma::IconWidget::addIconAction(QAction*)
    {66, 1540, 107, 1, 0, 0, 30},	//1559 Plasma::IconWidget::removeIconAction(QAction*)
    {66, 1658, 107, 1, 0, 0, 31},	//1560 Plasma::IconWidget::setAction(QAction*)
    {66, 557, 0, 0, Smoke::mf_const, 183, 32},	//1561 Plasma::IconWidget::action() const
    {66, 1935, 642, 1, Smoke::mf_property, 0, 33},	//1562 Plasma::IconWidget::setOrientation(Qt::Orientation)
    {66, 1412, 0, 0, Smoke::mf_const|Smoke::mf_property, 358, 34},	//1563 Plasma::IconWidget::orientation() const
    {66, 1117, 7, 1, 0, 0, 35},	//1564 Plasma::IconWidget::invertLayout(bool)
    {66, 1119, 0, 0, Smoke::mf_const, 386, 36},	//1565 Plasma::IconWidget::invertedLayout() const
    {66, 2196, 644, 1, Smoke::mf_const, 291, 37},	//1566 Plasma::IconWidget::sizeFromIconSize(const double) const
    {66, 1395, 0, 0, Smoke::mf_property, 477, 38},	//1567 Plasma::IconWidget::numDisplayLines()
    {66, 1929, 129, 1, Smoke::mf_property, 0, 39},	//1568 Plasma::IconWidget::setNumDisplayLines(int)
    {66, 1789, 7, 1, Smoke::mf_property, 0, 40},	//1569 Plasma::IconWidget::setDrawBackground(bool)
    {66, 887, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 41},	//1570 Plasma::IconWidget::drawBackground() const
    {66, 2161, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 276, 42},	//1571 Plasma::IconWidget::shape() const
    {66, 1968, 7, 1, Smoke::mf_slot, 0, 43},	//1572 Plasma::IconWidget::setPressed(bool)
    {66, 2108, 0, 0, Smoke::mf_slot, 0, 44},	//1573 Plasma::IconWidget::setUnpressed()
    {66, 1420, 216, 3, Smoke::mf_protected|Smoke::mf_virtual, 0, 45},	//1574 Plasma::IconWidget::paint(QPainter*, const QStyleOptionGraphicsItem*, QWidget*)
    {66, 2198, 287, 2, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 291, 46},	//1575 Plasma::IconWidget::sizeHint(Qt::SizeHint, const QSizeF&) const
    {66, 1476, 7, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 47},	//1576 Plasma::IconWidget::pressed(bool)
    {66, 726, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 48},	//1577 Plasma::IconWidget::clicked()
    {66, 875, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 49},	//1578 Plasma::IconWidget::doubleClicked()
    {66, 569, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 50},	//1579 Plasma::IconWidget::activated()
    {66, 712, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 51},	//1580 Plasma::IconWidget::changed()
    {66, 1130, 0, 0, Smoke::mf_protected, 386, 52},	//1581 Plasma::IconWidget::isDown()
    {66, 1370, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 53},	//1582 Plasma::IconWidget::mousePressEvent(QGraphicsSceneMouseEvent*)
    {66, 1368, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 54},	//1583 Plasma::IconWidget::mouseMoveEvent(QGraphicsSceneMouseEvent*)
    {66, 1372, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 55},	//1584 Plasma::IconWidget::mouseReleaseEvent(QGraphicsSceneMouseEvent*)
    {66, 1366, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 56},	//1585 Plasma::IconWidget::mouseDoubleClickEvent(QGraphicsSceneMouseEvent*)
    {66, 1068, 290, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 57},	//1586 Plasma::IconWidget::hoverEnterEvent(QGraphicsSceneHoverEvent*)
    {66, 1070, 290, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 58},	//1587 Plasma::IconWidget::hoverLeaveEvent(QGraphicsSceneHoverEvent*)
    {66, 1621, 275, 2, Smoke::mf_protected|Smoke::mf_virtual, 386, 59},	//1588 Plasma::IconWidget::sceneEventFilter(QGraphicsItem*, QEvent*)
    {66, 710, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 60},	//1589 Plasma::IconWidget::changeEvent(QEvent*)
    {66, 883, 646, 3, 0, 0, 61},	//1590 Plasma::IconWidget::drawActionButtonBase(QPainter*, const QSize&, int)
    {66, 2304, 1, 1, Smoke::mf_static, 293, 62},	//1591 Plasma::IconWidget::tr(const char*)
    {66, 2308, 1, 1, Smoke::mf_static, 293, 63},	//1592 Plasma::IconWidget::trUtf8(const char*)
    {66, 212, 0, 0, Smoke::mf_ctor, 104, 64},	//1593 Plasma::IconWidget::IconWidget()
    {66, 212, 89, 1, Smoke::mf_ctor, 104, 65},	//1594 Plasma::IconWidget::IconWidget(const QString&)
    {66, 212, 650, 2, Smoke::mf_ctor, 104, 66},	//1595 Plasma::IconWidget::IconWidget(const QIcon&, const QString&)
    {66, 2054, 89, 1, 0, 0, 67},	//1596 Plasma::IconWidget::setSvg(const QString&)
    {66, 1968, 0, 0, Smoke::mf_slot, 0, 68},	//1597 Plasma::IconWidget::setPressed()
    {66, 1420, 328, 2, Smoke::mf_protected, 0, 69},	//1598 Plasma::IconWidget::paint(QPainter*, const QStyleOptionGraphicsItem*)
    {66, 2198, 248, 1, Smoke::mf_const|Smoke::mf_protected, 291, 70},	//1599 Plasma::IconWidget::sizeHint(Qt::SizeHint) const
    {66, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 71},	//1600 Plasma::IconWidget::staticMetaObject() const
    {66, 2441, 0, 0, Smoke::mf_dtor, 0, 72 },	//1601 Plasma::IconWidget::~IconWidget()
    {67, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//1602 Plasma::ItemBackground::metaObject() const
    {67, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//1603 Plasma::ItemBackground::qt_metacast(const char*)
    {67, 2304, 43, 2, Smoke::mf_static, 293, 3},	//1604 Plasma::ItemBackground::tr(const char*, const char*)
    {67, 2308, 43, 2, Smoke::mf_static, 293, 4},	//1605 Plasma::ItemBackground::trUtf8(const char*, const char*)
    {67, 2304, 46, 3, Smoke::mf_static, 293, 5},	//1606 Plasma::ItemBackground::tr(const char*, const char*, int)
    {67, 2308, 46, 3, Smoke::mf_static, 293, 6},	//1607 Plasma::ItemBackground::trUtf8(const char*, const char*, int)
    {67, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//1608 Plasma::ItemBackground::qt_metacall(QMetaObject::Call, int, void**)
    {67, 228, 125, 1, Smoke::mf_ctor, 107, 8},	//1609 Plasma::ItemBackground::ItemBackground(QGraphicsWidget*)
    {67, 2070, 653, 1, Smoke::mf_property, 0, 9},	//1610 Plasma::ItemBackground::setTarget(const QRectF&)
    {67, 2264, 0, 0, Smoke::mf_const|Smoke::mf_property, 283, 10},	//1611 Plasma::ItemBackground::target() const
    {67, 2072, 170, 1, Smoke::mf_property, 0, 11},	//1612 Plasma::ItemBackground::setTargetItem(QGraphicsItem*)
    {67, 2265, 0, 0, Smoke::mf_const|Smoke::mf_property, 214, 12},	//1613 Plasma::ItemBackground::targetItem() const
    {67, 1420, 216, 3, Smoke::mf_virtual, 0, 13},	//1614 Plasma::ItemBackground::paint(QPainter*, const QStyleOptionGraphicsItem*, QWidget*)
    {67, 661, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 14},	//1615 Plasma::ItemBackground::appearanceChanged()
    {67, 658, 655, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 15},	//1616 Plasma::ItemBackground::animationStep(qreal)
    {67, 2268, 657, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 16},	//1617 Plasma::ItemBackground::targetReached(QRectF)
    {67, 2266, 170, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 17},	//1618 Plasma::ItemBackground::targetItemReached(QGraphicsItem*)
    {67, 1179, 284, 2, Smoke::mf_protected|Smoke::mf_virtual, 304, 18},	//1619 Plasma::ItemBackground::itemChange(QGraphicsItem::GraphicsItemChange, const QVariant&)
    {67, 954, 272, 2, Smoke::mf_protected|Smoke::mf_virtual, 386, 19},	//1620 Plasma::ItemBackground::eventFilter(QObject*, QEvent*)
    {67, 1621, 275, 2, Smoke::mf_protected|Smoke::mf_virtual, 386, 20},	//1621 Plasma::ItemBackground::sceneEventFilter(QGraphicsItem*, QEvent*)
    {67, 1584, 282, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 21},	//1622 Plasma::ItemBackground::resizeEvent(QGraphicsSceneResizeEvent*)
    {67, 2304, 1, 1, Smoke::mf_static, 293, 22},	//1623 Plasma::ItemBackground::tr(const char*)
    {67, 2308, 1, 1, Smoke::mf_static, 293, 23},	//1624 Plasma::ItemBackground::trUtf8(const char*)
    {67, 228, 0, 0, Smoke::mf_ctor, 107, 24},	//1625 Plasma::ItemBackground::ItemBackground()
    {67, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 25},	//1626 Plasma::ItemBackground::staticMetaObject() const
    {67, 2442, 0, 0, Smoke::mf_dtor, 0, 26 },	//1627 Plasma::ItemBackground::~ItemBackground()
    {68, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//1628 Plasma::Label::metaObject() const
    {68, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//1629 Plasma::Label::qt_metacast(const char*)
    {68, 2304, 43, 2, Smoke::mf_static, 293, 3},	//1630 Plasma::Label::tr(const char*, const char*)
    {68, 2308, 43, 2, Smoke::mf_static, 293, 4},	//1631 Plasma::Label::trUtf8(const char*, const char*)
    {68, 2304, 46, 3, Smoke::mf_static, 293, 5},	//1632 Plasma::Label::tr(const char*, const char*, int)
    {68, 2308, 46, 3, Smoke::mf_static, 293, 6},	//1633 Plasma::Label::trUtf8(const char*, const char*, int)
    {68, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//1634 Plasma::Label::qt_metacall(QMetaObject::Call, int, void**)
    {68, 288, 125, 1, Smoke::mf_ctor, 110, 8},	//1635 Plasma::Label::Label(QGraphicsWidget*)
    {68, 2080, 89, 1, Smoke::mf_property, 0, 9},	//1636 Plasma::Label::setText(const QString&)
    {68, 2274, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 10},	//1637 Plasma::Label::text() const
    {68, 1865, 89, 1, Smoke::mf_property, 0, 11},	//1638 Plasma::Label::setImage(const QString&)
    {68, 1079, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 12},	//1639 Plasma::Label::image() const
    {68, 1662, 659, 1, 0, 0, 13},	//1640 Plasma::Label::setAlignment(QFlags<Qt::AlignmentFlag>)
    {68, 640, 0, 0, Smoke::mf_const, 207, 14},	//1641 Plasma::Label::alignment() const
    {68, 2002, 7, 1, Smoke::mf_property, 0, 15},	//1642 Plasma::Label::setScaledContents(bool)
    {68, 1052, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 16},	//1643 Plasma::Label::hasScaledContents() const
    {68, 2084, 7, 1, Smoke::mf_property, 0, 17},	//1644 Plasma::Label::setTextSelectable(bool)
    {68, 2280, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 18},	//1645 Plasma::Label::textSelectable() const
    {68, 2155, 7, 1, Smoke::mf_property, 0, 19},	//1646 Plasma::Label::setWordWrap(bool)
    {68, 2400, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 20},	//1647 Plasma::Label::wordWrap() const
    {68, 2048, 89, 1, Smoke::mf_property, 0, 21},	//1648 Plasma::Label::setStyleSheet(const QString&)
    {68, 2236, 0, 0, Smoke::mf_property, 293, 22},	//1649 Plasma::Label::styleSheet()
    {68, 1388, 0, 0, Smoke::mf_const, 241, 23},	//1650 Plasma::Label::nativeWidget() const
    {68, 1230, 89, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 24},	//1651 Plasma::Label::linkActivated(const QString&)
    {68, 1233, 89, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 25},	//1652 Plasma::Label::linkHovered(const QString&)
    {68, 841, 489, 2, Smoke::mf_slot, 0, 26},	//1653 Plasma::Label::dataUpdated(const QString&, const Plasma::DataEngine::Data&)
    {68, 1584, 282, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 27},	//1654 Plasma::Label::resizeEvent(QGraphicsSceneResizeEvent*)
    {68, 1370, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 28},	//1655 Plasma::Label::mousePressEvent(QGraphicsSceneMouseEvent*)
    {68, 1368, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 29},	//1656 Plasma::Label::mouseMoveEvent(QGraphicsSceneMouseEvent*)
    {68, 1420, 216, 3, Smoke::mf_protected|Smoke::mf_virtual, 0, 30},	//1657 Plasma::Label::paint(QPainter*, const QStyleOptionGraphicsItem*, QWidget*)
    {68, 710, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 31},	//1658 Plasma::Label::changeEvent(QEvent*)
    {68, 952, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 386, 32},	//1659 Plasma::Label::event(QEvent*)
    {68, 1179, 284, 2, Smoke::mf_protected|Smoke::mf_virtual, 304, 33},	//1660 Plasma::Label::itemChange(QGraphicsItem::GraphicsItemChange, const QVariant&)
    {68, 794, 394, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 34},	//1661 Plasma::Label::contextMenuEvent(QGraphicsSceneContextMenuEvent*)
    {68, 2198, 287, 2, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 291, 35},	//1662 Plasma::Label::sizeHint(Qt::SizeHint, const QSizeF&) const
    {68, 2304, 1, 1, Smoke::mf_static, 293, 36},	//1663 Plasma::Label::tr(const char*)
    {68, 2308, 1, 1, Smoke::mf_static, 293, 37},	//1664 Plasma::Label::trUtf8(const char*)
    {68, 288, 0, 0, Smoke::mf_ctor, 110, 38},	//1665 Plasma::Label::Label()
    {68, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 39},	//1666 Plasma::Label::staticMetaObject() const
    {68, 2443, 0, 0, Smoke::mf_dtor, 0, 40 },	//1667 Plasma::Label::~Label()
    {69, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//1668 Plasma::LineEdit::metaObject() const
    {69, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//1669 Plasma::LineEdit::qt_metacast(const char*)
    {69, 2304, 43, 2, Smoke::mf_static, 293, 3},	//1670 Plasma::LineEdit::tr(const char*, const char*)
    {69, 2308, 43, 2, Smoke::mf_static, 293, 4},	//1671 Plasma::LineEdit::trUtf8(const char*, const char*)
    {69, 2304, 46, 3, Smoke::mf_static, 293, 5},	//1672 Plasma::LineEdit::tr(const char*, const char*, int)
    {69, 2308, 46, 3, Smoke::mf_static, 293, 6},	//1673 Plasma::LineEdit::trUtf8(const char*, const char*, int)
    {69, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//1674 Plasma::LineEdit::qt_metacall(QMetaObject::Call, int, void**)
    {69, 299, 125, 1, Smoke::mf_ctor, 111, 8},	//1675 Plasma::LineEdit::LineEdit(QGraphicsWidget*)
    {69, 2080, 89, 1, Smoke::mf_property, 0, 9},	//1676 Plasma::LineEdit::setText(const QString&)
    {69, 2274, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 10},	//1677 Plasma::LineEdit::text() const
    {69, 1716, 7, 1, Smoke::mf_property, 0, 11},	//1678 Plasma::LineEdit::setClearButtonShown(bool)
    {69, 1125, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 12},	//1679 Plasma::LineEdit::isClearButtonShown() const
    {69, 1718, 89, 1, Smoke::mf_property, 0, 13},	//1680 Plasma::LineEdit::setClickMessage(const QString&)
    {69, 725, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 14},	//1681 Plasma::LineEdit::clickMessage() const
    {69, 2048, 89, 1, Smoke::mf_property, 0, 15},	//1682 Plasma::LineEdit::setStyleSheet(const QString&)
    {69, 2236, 0, 0, Smoke::mf_property, 293, 16},	//1683 Plasma::LineEdit::styleSheet()
    {69, 1923, 661, 1, 0, 0, 17},	//1684 Plasma::LineEdit::setNativeWidget(KLineEdit*)
    {69, 1388, 0, 0, Smoke::mf_const, 13, 18},	//1685 Plasma::LineEdit::nativeWidget() const
    {69, 1068, 290, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 19},	//1686 Plasma::LineEdit::hoverEnterEvent(QGraphicsSceneHoverEvent*)
    {69, 1070, 290, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 20},	//1687 Plasma::LineEdit::hoverLeaveEvent(QGraphicsSceneHoverEvent*)
    {69, 710, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 21},	//1688 Plasma::LineEdit::changeEvent(QEvent*)
    {69, 1420, 216, 3, Smoke::mf_protected|Smoke::mf_virtual, 0, 22},	//1689 Plasma::LineEdit::paint(QPainter*, const QStyleOptionGraphicsItem*, QWidget*)
    {69, 1370, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 23},	//1690 Plasma::LineEdit::mousePressEvent(QGraphicsSceneMouseEvent*)
    {69, 998, 280, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 24},	//1691 Plasma::LineEdit::focusInEvent(QFocusEvent*)
    {69, 1002, 280, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 25},	//1692 Plasma::LineEdit::focusOutEvent(QFocusEvent*)
    {69, 910, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 26},	//1693 Plasma::LineEdit::editingFinished()
    {69, 1593, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 27},	//1694 Plasma::LineEdit::returnPressed()
    {69, 2278, 89, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 28},	//1695 Plasma::LineEdit::textEdited(const QString&)
    {69, 2276, 89, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 29},	//1696 Plasma::LineEdit::textChanged(const QString&)
    {69, 996, 7, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 30},	//1697 Plasma::LineEdit::focusChanged(bool)
    {69, 2304, 1, 1, Smoke::mf_static, 293, 31},	//1698 Plasma::LineEdit::tr(const char*)
    {69, 2308, 1, 1, Smoke::mf_static, 293, 32},	//1699 Plasma::LineEdit::trUtf8(const char*)
    {69, 299, 0, 0, Smoke::mf_ctor, 111, 33},	//1700 Plasma::LineEdit::LineEdit()
    {69, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 34},	//1701 Plasma::LineEdit::staticMetaObject() const
    {69, 2444, 0, 0, Smoke::mf_dtor, 0, 35 },	//1702 Plasma::LineEdit::~LineEdit()
    {70, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//1703 Plasma::Meter::metaObject() const
    {70, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//1704 Plasma::Meter::qt_metacast(const char*)
    {70, 2304, 43, 2, Smoke::mf_static, 293, 3},	//1705 Plasma::Meter::tr(const char*, const char*)
    {70, 2308, 43, 2, Smoke::mf_static, 293, 4},	//1706 Plasma::Meter::trUtf8(const char*, const char*)
    {70, 2304, 46, 3, Smoke::mf_static, 293, 5},	//1707 Plasma::Meter::tr(const char*, const char*, int)
    {70, 2308, 46, 3, Smoke::mf_static, 293, 6},	//1708 Plasma::Meter::trUtf8(const char*, const char*, int)
    {70, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//1709 Plasma::Meter::qt_metacall(QMetaObject::Call, int, void**)
    {70, 310, 170, 1, Smoke::mf_ctor, 115, 8},	//1710 Plasma::Meter::Meter(QGraphicsItem*)
    {70, 1346, 0, 0, Smoke::mf_const|Smoke::mf_property, 477, 9},	//1711 Plasma::Meter::maximum() const
    {70, 1361, 0, 0, Smoke::mf_const|Smoke::mf_property, 477, 10},	//1712 Plasma::Meter::minimum() const
    {70, 2360, 0, 0, Smoke::mf_const|Smoke::mf_property, 477, 11},	//1713 Plasma::Meter::value() const
    {70, 2054, 89, 1, Smoke::mf_property, 0, 12},	//1714 Plasma::Meter::setSvg(const QString&)
    {70, 2246, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 13},	//1715 Plasma::Meter::svg() const
    {70, 1906, 663, 1, Smoke::mf_property, 0, 14},	//1716 Plasma::Meter::setMeterType(Plasma::Meter::MeterType)
    {70, 1353, 0, 0, Smoke::mf_const|Smoke::mf_property, 116, 15},	//1717 Plasma::Meter::meterType() const
    {70, 1883, 665, 2, 0, 0, 16},	//1718 Plasma::Meter::setLabel(int, const QString&)
    {70, 1206, 129, 1, Smoke::mf_const, 293, 17},	//1719 Plasma::Meter::label(int) const
    {70, 1888, 668, 2, 0, 0, 18},	//1720 Plasma::Meter::setLabelColor(int, const QColor&)
    {70, 1210, 129, 1, Smoke::mf_const, 189, 19},	//1721 Plasma::Meter::labelColor(int) const
    {70, 1890, 671, 2, 0, 0, 20},	//1722 Plasma::Meter::setLabelFont(int, const QFont&)
    {70, 1212, 129, 1, Smoke::mf_const, 211, 21},	//1723 Plasma::Meter::labelFont(int) const
    {70, 1886, 674, 2, 0, 0, 22},	//1724 Plasma::Meter::setLabelAlignment(int, const QFlags<Qt::AlignmentFlag>)
    {70, 1208, 129, 1, Smoke::mf_const, 207, 23},	//1725 Plasma::Meter::labelAlignment(int) const
    {70, 1214, 129, 1, Smoke::mf_const, 283, 24},	//1726 Plasma::Meter::labelRect(int) const
    {70, 841, 489, 2, Smoke::mf_slot, 0, 25},	//1727 Plasma::Meter::dataUpdated(const QString&, const Plasma::DataEngine::Data&)
    {70, 1902, 129, 1, Smoke::mf_property|Smoke::mf_slot, 0, 26},	//1728 Plasma::Meter::setMaximum(int)
    {70, 1910, 129, 1, Smoke::mf_property|Smoke::mf_slot, 0, 27},	//1729 Plasma::Meter::setMinimum(int)
    {70, 2124, 129, 1, Smoke::mf_property|Smoke::mf_slot, 0, 28},	//1730 Plasma::Meter::setValue(int)
    {70, 2361, 677, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 29},	//1731 Plasma::Meter::valueChanged(const int&)
    {70, 1420, 216, 3, Smoke::mf_protected|Smoke::mf_virtual, 0, 30},	//1732 Plasma::Meter::paint(QPainter*, const QStyleOptionGraphicsItem*, QWidget*)
    {70, 2198, 287, 2, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 291, 31},	//1733 Plasma::Meter::sizeHint(Qt::SizeHint, const QSizeF&) const
    {70, 2304, 1, 1, Smoke::mf_static, 293, 32},	//1734 Plasma::Meter::tr(const char*)
    {70, 2308, 1, 1, Smoke::mf_static, 293, 33},	//1735 Plasma::Meter::trUtf8(const char*)
    {70, 310, 0, 0, Smoke::mf_ctor, 115, 34},	//1736 Plasma::Meter::Meter()
    {70, 1420, 328, 2, Smoke::mf_protected, 0, 35},	//1737 Plasma::Meter::paint(QPainter*, const QStyleOptionGraphicsItem*)
    {70, 2198, 248, 1, Smoke::mf_const|Smoke::mf_protected, 291, 36},	//1738 Plasma::Meter::sizeHint(Qt::SizeHint) const
    {70, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 37},	//1739 Plasma::Meter::staticMetaObject() const
    {70, 56, 0, 0, Smoke::mf_static|Smoke::mf_enum, 116, 38},	//1740 Plasma::Meter::BarMeterHorizontal (enum)
    {70, 57, 0, 0, Smoke::mf_static|Smoke::mf_enum, 116, 39},	//1741 Plasma::Meter::BarMeterVertical (enum)
    {70, 29, 0, 0, Smoke::mf_static|Smoke::mf_enum, 116, 40},	//1742 Plasma::Meter::AnalogMeter (enum)
    {70, 2445, 0, 0, Smoke::mf_dtor, 0, 41 },	//1743 Plasma::Meter::~Meter()
    {71, 351, 0, 0, Smoke::mf_ctor, 118, 1},	//1744 Plasma::Package::Package()
    {71, 351, 679, 3, Smoke::mf_ctor, 118, 2},	//1745 Plasma::Package::Package(const QString&, const QString&, KSharedPtr<Plasma::PackageStructure>)
    {71, 351, 683, 2, Smoke::mf_ctor, 118, 3},	//1746 Plasma::Package::Package(const QString&, KSharedPtr<Plasma::PackageStructure>)
    {71, 351, 686, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 118, 4},	//1747 Plasma::Package::Package(const Plasma::Package&)
    {71, 1408, 686, 1, 0, 117, 5},	//1748 Plasma::Package::operator=(const Plasma::Package&)
    {71, 1164, 0, 0, Smoke::mf_const, 386, 6},	//1749 Plasma::Package::isValid() const
    {71, 972, 688, 2, Smoke::mf_const, 293, 7},	//1750 Plasma::Package::filePath(const char*, const QString&) const
    {71, 972, 1, 1, Smoke::mf_const, 293, 8},	//1751 Plasma::Package::filePath(const char*) const
    {71, 949, 1, 1, Smoke::mf_const, 294, 9},	//1752 Plasma::Package::entryList(const char*) const
    {71, 1352, 0, 0, Smoke::mf_const, 119, 10},	//1753 Plasma::Package::metadata() const
    {71, 1947, 89, 1, 0, 0, 11},	//1754 Plasma::Package::setPath(const QString&)
    {71, 1446, 0, 0, Smoke::mf_const, 456, 12},	//1755 Plasma::Package::path() const
    {71, 2234, 0, 0, Smoke::mf_const, 394, 13},	//1756 Plasma::Package::structure() const
    {71, 783, 0, 0, Smoke::mf_const, 293, 14},	//1757 Plasma::Package::contentsHash() const
    {71, 1266, 89, 1, Smoke::mf_static, 294, 15},	//1758 Plasma::Package::listInstalled(const QString&)
    {71, 1268, 89, 1, Smoke::mf_static, 294, 16},	//1759 Plasma::Package::listInstalledPaths(const QString&)
    {71, 1112, 358, 3, Smoke::mf_static, 386, 17},	//1760 Plasma::Package::installPackage(const QString&, const QString&, const QString&)
    {71, 2316, 358, 3, Smoke::mf_static, 386, 18},	//1761 Plasma::Package::uninstallPackage(const QString&, const QString&, const QString&)
    {71, 1505, 691, 2, Smoke::mf_static, 386, 19},	//1762 Plasma::Package::registerPackage(const Plasma::PackageMetadata&, const QString&)
    {71, 814, 694, 4, Smoke::mf_static, 386, 20},	//1763 Plasma::Package::createPackage(const Plasma::PackageMetadata&, const QString&, const QString&, const QString&)
    {71, 814, 699, 3, Smoke::mf_static, 386, 21},	//1764 Plasma::Package::createPackage(const Plasma::PackageMetadata&, const QString&, const QString&)
    {71, 2446, 0, 0, Smoke::mf_dtor, 0, 22 },	//1765 Plasma::Package::~Package()
    {72, 355, 89, 1, Smoke::mf_ctor, 121, 1},	//1766 Plasma::PackageMetadata::PackageMetadata(const QString&)
    {72, 355, 703, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 121, 2},	//1767 Plasma::PackageMetadata::PackageMetadata(const Plasma::PackageMetadata&)
    {72, 1408, 703, 1, 0, 120, 3},	//1768 Plasma::PackageMetadata::operator=(const Plasma::PackageMetadata&)
    {72, 1164, 0, 0, Smoke::mf_const, 386, 4},	//1769 Plasma::PackageMetadata::isValid() const
    {72, 2401, 89, 1, Smoke::mf_const, 0, 5},	//1770 Plasma::PackageMetadata::write(const QString&) const
    {72, 1493, 89, 1, 0, 0, 6},	//1771 Plasma::PackageMetadata::read(const QString&)
    {72, 1386, 0, 0, Smoke::mf_const, 293, 7},	//1772 Plasma::PackageMetadata::name() const
    {72, 849, 0, 0, Smoke::mf_const, 293, 8},	//1773 Plasma::PackageMetadata::description() const
    {72, 1202, 0, 0, Smoke::mf_const, 294, 9},	//1774 Plasma::PackageMetadata::keywords() const
    {72, 1657, 0, 0, Smoke::mf_const, 293, 10},	//1775 Plasma::PackageMetadata::serviceType() const
    {72, 685, 0, 0, Smoke::mf_const, 293, 11},	//1776 Plasma::PackageMetadata::author() const
    {72, 932, 0, 0, Smoke::mf_const, 293, 12},	//1777 Plasma::PackageMetadata::email() const
    {72, 2363, 0, 0, Smoke::mf_const, 293, 13},	//1778 Plasma::PackageMetadata::version() const
    {72, 2388, 0, 0, Smoke::mf_const, 293, 14},	//1779 Plasma::PackageMetadata::website() const
    {72, 1229, 0, 0, Smoke::mf_const, 293, 15},	//1780 Plasma::PackageMetadata::license() const
    {72, 675, 0, 0, Smoke::mf_const, 293, 16},	//1781 Plasma::PackageMetadata::application() const
    {72, 707, 0, 0, Smoke::mf_const, 293, 17},	//1782 Plasma::PackageMetadata::category() const
    {72, 1578, 0, 0, Smoke::mf_const, 293, 18},	//1783 Plasma::PackageMetadata::requiredVersion() const
    {72, 1458, 0, 0, Smoke::mf_const, 293, 19},	//1784 Plasma::PackageMetadata::pluginName() const
    {72, 1085, 0, 0, Smoke::mf_const, 293, 20},	//1785 Plasma::PackageMetadata::implementationApi() const
    {72, 1526, 0, 0, Smoke::mf_const, 26, 21},	//1786 Plasma::PackageMetadata::remoteLocation() const
    {72, 2313, 0, 0, Smoke::mf_const, 293, 22},	//1787 Plasma::PackageMetadata::type() const
    {72, 1921, 89, 1, 0, 0, 23},	//1788 Plasma::PackageMetadata::setName(const QString&)
    {72, 1779, 89, 1, 0, 0, 24},	//1789 Plasma::PackageMetadata::setDescription(const QString&)
    {72, 1075, 0, 0, Smoke::mf_const, 293, 25},	//1790 Plasma::PackageMetadata::icon() const
    {72, 1858, 89, 1, 0, 0, 26},	//1791 Plasma::PackageMetadata::setIcon(const QString&)
    {72, 1881, 200, 1, 0, 0, 27},	//1792 Plasma::PackageMetadata::setKeywords(const QStringList&)
    {72, 2015, 89, 1, 0, 0, 28},	//1793 Plasma::PackageMetadata::setServiceType(const QString&)
    {72, 1682, 89, 1, 0, 0, 29},	//1794 Plasma::PackageMetadata::setAuthor(const QString&)
    {72, 1802, 89, 1, 0, 0, 30},	//1795 Plasma::PackageMetadata::setEmail(const QString&)
    {72, 2126, 89, 1, 0, 0, 31},	//1796 Plasma::PackageMetadata::setVersion(const QString&)
    {72, 2147, 89, 1, 0, 0, 32},	//1797 Plasma::PackageMetadata::setWebsite(const QString&)
    {72, 1894, 89, 1, 0, 0, 33},	//1798 Plasma::PackageMetadata::setLicense(const QString&)
    {72, 1674, 89, 1, 0, 0, 34},	//1799 Plasma::PackageMetadata::setApplication(const QString&)
    {72, 1710, 89, 1, 0, 0, 35},	//1800 Plasma::PackageMetadata::setCategory(const QString&)
    {72, 1990, 89, 1, 0, 0, 36},	//1801 Plasma::PackageMetadata::setRequiredVersion(const QString&)
    {72, 1984, 119, 1, 0, 0, 37},	//1802 Plasma::PackageMetadata::setRemoteLocation(const KUrl&)
    {72, 2104, 89, 1, 0, 0, 38},	//1803 Plasma::PackageMetadata::setType(const QString&)
    {72, 1953, 89, 1, 0, 0, 39},	//1804 Plasma::PackageMetadata::setPluginName(const QString&)
    {72, 1873, 89, 1, 0, 0, 40},	//1805 Plasma::PackageMetadata::setImplementationApi(const QString&)
    {72, 355, 0, 0, Smoke::mf_ctor, 121, 41},	//1806 Plasma::PackageMetadata::PackageMetadata()
    {72, 2447, 0, 0, Smoke::mf_dtor, 0, 42 },	//1807 Plasma::PackageMetadata::~PackageMetadata()
    {73, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//1808 Plasma::PackageStructure::metaObject() const
    {73, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//1809 Plasma::PackageStructure::qt_metacast(const char*)
    {73, 2304, 43, 2, Smoke::mf_static, 293, 3},	//1810 Plasma::PackageStructure::tr(const char*, const char*)
    {73, 2308, 43, 2, Smoke::mf_static, 293, 4},	//1811 Plasma::PackageStructure::trUtf8(const char*, const char*)
    {73, 2304, 46, 3, Smoke::mf_static, 293, 5},	//1812 Plasma::PackageStructure::tr(const char*, const char*, int)
    {73, 2308, 46, 3, Smoke::mf_static, 293, 6},	//1813 Plasma::PackageStructure::trUtf8(const char*, const char*, int)
    {73, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//1814 Plasma::PackageStructure::qt_metacall(QMetaObject::Call, int, void**)
    {73, 358, 64, 2, Smoke::mf_ctor, 124, 8},	//1815 Plasma::PackageStructure::PackageStructure(QObject*, const QString&)
    {73, 1408, 705, 1, 0, 123, 9},	//1816 Plasma::PackageStructure::operator=(const Plasma::PackageStructure&)
    {73, 1281, 89, 1, Smoke::mf_static, 21, 10},	//1817 Plasma::PackageStructure::load(const QString&)
    {73, 2313, 0, 0, Smoke::mf_const, 293, 11},	//1818 Plasma::PackageStructure::type() const
    {73, 862, 0, 0, Smoke::mf_const, 260, 12},	//1819 Plasma::PackageStructure::directories() const
    {73, 1576, 0, 0, Smoke::mf_const, 260, 13},	//1820 Plasma::PackageStructure::requiredDirectories() const
    {73, 975, 0, 0, Smoke::mf_const, 260, 14},	//1821 Plasma::PackageStructure::files() const
    {73, 1577, 0, 0, Smoke::mf_const, 260, 15},	//1822 Plasma::PackageStructure::requiredFiles() const
    {73, 593, 707, 3, 0, 0, 16},	//1823 Plasma::PackageStructure::addDirectoryDefinition(const char*, const QString&, const QString&)
    {73, 597, 707, 3, 0, 0, 17},	//1824 Plasma::PackageStructure::addFileDefinition(const char*, const QString&, const QString&)
    {73, 1538, 1, 1, 0, 0, 18},	//1825 Plasma::PackageStructure::removeDefinition(const char*)
    {73, 1446, 1, 1, Smoke::mf_const, 293, 19},	//1826 Plasma::PackageStructure::path(const char*) const
    {73, 1640, 1, 1, Smoke::mf_const, 294, 20},	//1827 Plasma::PackageStructure::searchPath(const char*) const
    {73, 949, 1, 1, 0, 294, 21},	//1828 Plasma::PackageStructure::entryList(const char*)
    {73, 1386, 1, 1, Smoke::mf_const, 293, 22},	//1829 Plasma::PackageStructure::name(const char*) const
    {73, 1988, 711, 2, 0, 0, 23},	//1830 Plasma::PackageStructure::setRequired(const char*, bool)
    {73, 1151, 1, 1, Smoke::mf_const, 386, 24},	//1831 Plasma::PackageStructure::isRequired(const char*) const
    {73, 1770, 714, 1, 0, 0, 25},	//1832 Plasma::PackageStructure::setDefaultMimetypes(QStringList)
    {73, 1908, 716, 2, 0, 0, 26},	//1833 Plasma::PackageStructure::setMimetypes(const char*, QStringList)
    {73, 1359, 1, 1, Smoke::mf_const, 294, 27},	//1834 Plasma::PackageStructure::mimetypes(const char*) const
    {73, 1947, 89, 1, 0, 0, 28},	//1835 Plasma::PackageStructure::setPath(const QString&)
    {73, 1446, 0, 0, Smoke::mf_const, 293, 29},	//1836 Plasma::PackageStructure::path() const
    {73, 1493, 719, 1, 0, 0, 30},	//1837 Plasma::PackageStructure::read(const KConfigBase*)
    {73, 2401, 721, 1, Smoke::mf_const, 0, 31},	//1838 Plasma::PackageStructure::write(KConfigBase*) const
    {73, 1112, 77, 2, Smoke::mf_virtual, 386, 32},	//1839 Plasma::PackageStructure::installPackage(const QString&, const QString&)
    {73, 2316, 77, 2, Smoke::mf_virtual, 386, 33},	//1840 Plasma::PackageStructure::uninstallPackage(const QString&, const QString&)
    {73, 812, 57, 1, Smoke::mf_virtual, 0, 34},	//1841 Plasma::PackageStructure::createNewWidgetBrowser(QWidget*)
    {73, 784, 0, 0, Smoke::mf_const, 293, 35},	//1842 Plasma::PackageStructure::contentsPrefix() const
    {73, 785, 0, 0, Smoke::mf_const, 294, 36},	//1843 Plasma::PackageStructure::contentsPrefixPaths() const
    {73, 844, 0, 0, Smoke::mf_const, 293, 37},	//1844 Plasma::PackageStructure::defaultPackageRoot() const
    {73, 1651, 0, 0, Smoke::mf_const, 293, 38},	//1845 Plasma::PackageStructure::servicePrefix() const
    {73, 2013, 89, 1, 0, 0, 39},	//1846 Plasma::PackageStructure::setServicePrefix(const QString&)
    {73, 1352, 0, 0, Smoke::mf_virtual, 119, 40},	//1847 Plasma::PackageStructure::metadata()
    {73, 641, 0, 0, Smoke::mf_const, 386, 41},	//1848 Plasma::PackageStructure::allowExternalPaths() const
    {73, 1393, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 42},	//1849 Plasma::PackageStructure::newWidgetBrowserFinished()
    {73, 1664, 7, 1, Smoke::mf_protected, 0, 43},	//1850 Plasma::PackageStructure::setAllowExternalPaths(bool)
    {73, 1741, 89, 1, Smoke::mf_protected, 0, 44},	//1851 Plasma::PackageStructure::setContentsPrefix(const QString&)
    {73, 1743, 200, 1, Smoke::mf_protected, 0, 45},	//1852 Plasma::PackageStructure::setContentsPrefixPaths(const QStringList&)
    {73, 1772, 89, 1, Smoke::mf_protected, 0, 46},	//1853 Plasma::PackageStructure::setDefaultPackageRoot(const QString&)
    {73, 1448, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 47},	//1854 Plasma::PackageStructure::pathChanged()
    {73, 2304, 1, 1, Smoke::mf_static, 293, 48},	//1855 Plasma::PackageStructure::tr(const char*)
    {73, 2308, 1, 1, Smoke::mf_static, 293, 49},	//1856 Plasma::PackageStructure::trUtf8(const char*)
    {73, 358, 0, 0, Smoke::mf_ctor, 124, 50},	//1857 Plasma::PackageStructure::PackageStructure()
    {73, 358, 97, 1, Smoke::mf_ctor, 124, 51},	//1858 Plasma::PackageStructure::PackageStructure(QObject*)
    {73, 812, 0, 0, 0, 0, 52},	//1859 Plasma::PackageStructure::createNewWidgetBrowser()
    {73, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 53},	//1860 Plasma::PackageStructure::staticMetaObject() const
    {73, 2448, 0, 0, Smoke::mf_dtor, 0, 54 },	//1861 Plasma::PackageStructure::~PackageStructure()
    {74, 376, 0, 0, Smoke::mf_ctor, 126, 1},	//1862 Plasma::PlotColor::PlotColor()
    {74, 376, 723, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 126, 2},	//1863 Plasma::PlotColor::PlotColor(const Plasma::PlotColor&)
    {74, 735, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 190, 3},	//1864 Plasma::PlotColor::color() const
    {74, 1724, 581, 1, Smoke::mf_attribute, 0, 4},	//1865 Plasma::PlotColor::setColor(const QColor&)
    {74, 837, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 190, 5},	//1866 Plasma::PlotColor::darkColor() const
    {74, 1759, 581, 1, Smoke::mf_attribute, 0, 6},	//1867 Plasma::PlotColor::setDarkColor(const QColor&)
    {74, 2449, 0, 0, Smoke::mf_dtor, 0, 7 },	//1868 Plasma::PlotColor::~PlotColor()
    {75, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//1869 Plasma::PopupApplet::metaObject() const
    {75, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//1870 Plasma::PopupApplet::qt_metacast(const char*)
    {75, 2304, 43, 2, Smoke::mf_static, 293, 3},	//1871 Plasma::PopupApplet::tr(const char*, const char*)
    {75, 2308, 43, 2, Smoke::mf_static, 293, 4},	//1872 Plasma::PopupApplet::trUtf8(const char*, const char*)
    {75, 2304, 46, 3, Smoke::mf_static, 293, 5},	//1873 Plasma::PopupApplet::tr(const char*, const char*, int)
    {75, 2308, 46, 3, Smoke::mf_static, 293, 6},	//1874 Plasma::PopupApplet::trUtf8(const char*, const char*, int)
    {75, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//1875 Plasma::PopupApplet::qt_metacall(QMetaObject::Call, int, void**)
    {75, 378, 70, 2, Smoke::mf_ctor, 127, 8},	//1876 Plasma::PopupApplet::PopupApplet(QObject*, const QList<QVariant>&)
    {75, 1961, 567, 1, 0, 0, 9},	//1877 Plasma::PopupApplet::setPopupIcon(const QIcon&)
    {75, 1961, 89, 1, 0, 0, 10},	//1878 Plasma::PopupApplet::setPopupIcon(const QString&)
    {75, 1464, 0, 0, Smoke::mf_const, 236, 11},	//1879 Plasma::PopupApplet::popupIcon() const
    {75, 2391, 0, 0, Smoke::mf_virtual, 309, 12},	//1880 Plasma::PopupApplet::widget()
    {75, 2149, 57, 1, 0, 0, 13},	//1881 Plasma::PopupApplet::setWidget(QWidget*)
    {75, 1033, 0, 0, Smoke::mf_virtual, 229, 14},	//1882 Plasma::PopupApplet::graphicsWidget()
    {75, 1832, 125, 1, 0, 0, 15},	//1883 Plasma::PopupApplet::setGraphicsWidget(QGraphicsWidget*)
    {75, 1465, 0, 0, Smoke::mf_const, 128, 16},	//1884 Plasma::PopupApplet::popupPlacement() const
    {75, 1959, 725, 1, Smoke::mf_property, 0, 17},	//1885 Plasma::PopupApplet::setPopupAlignment(Qt::AlignmentFlag)
    {75, 1461, 0, 0, Smoke::mf_const|Smoke::mf_property, 310, 18},	//1886 Plasma::PopupApplet::popupAlignment() const
    {75, 1945, 7, 1, 0, 0, 19},	//1887 Plasma::PopupApplet::setPassivePopup(bool)
    {75, 1142, 0, 0, Smoke::mf_const, 386, 20},	//1888 Plasma::PopupApplet::isPassivePopup() const
    {75, 1145, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 386, 21},	//1889 Plasma::PopupApplet::isPopupShowing() const
    {75, 1135, 0, 0, Smoke::mf_const, 386, 22},	//1890 Plasma::PopupApplet::isIconified() const
    {75, 1061, 0, 0, Smoke::mf_slot, 0, 23},	//1891 Plasma::PopupApplet::hidePopup()
    {75, 2183, 727, 1, Smoke::mf_slot, 0, 24},	//1892 Plasma::PopupApplet::showPopup(uint)
    {75, 2292, 0, 0, Smoke::mf_slot, 0, 25},	//1893 Plasma::PopupApplet::togglePopup()
    {75, 1462, 7, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 26},	//1894 Plasma::PopupApplet::popupEvent(bool)
    {75, 2198, 287, 2, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 291, 27},	//1895 Plasma::PopupApplet::sizeHint(Qt::SizeHint, const QSizeF&) const
    {75, 1370, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 28},	//1896 Plasma::PopupApplet::mousePressEvent(QGraphicsSceneMouseEvent*)
    {75, 1372, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 29},	//1897 Plasma::PopupApplet::mouseReleaseEvent(QGraphicsSceneMouseEvent*)
    {75, 954, 272, 2, Smoke::mf_protected|Smoke::mf_virtual, 386, 30},	//1898 Plasma::PopupApplet::eventFilter(QObject*, QEvent*)
    {75, 876, 400, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 31},	//1899 Plasma::PopupApplet::dragEnterEvent(QGraphicsSceneDragDropEvent*)
    {75, 878, 400, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 32},	//1900 Plasma::PopupApplet::dragLeaveEvent(QGraphicsSceneDragDropEvent*)
    {75, 906, 400, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 33},	//1901 Plasma::PopupApplet::dropEvent(QGraphicsSceneDragDropEvent*)
    {75, 2289, 176, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 34},	//1902 Plasma::PopupApplet::timerEvent(QTimerEvent*)
    {75, 2304, 1, 1, Smoke::mf_static, 293, 35},	//1903 Plasma::PopupApplet::tr(const char*)
    {75, 2308, 1, 1, Smoke::mf_static, 293, 36},	//1904 Plasma::PopupApplet::trUtf8(const char*)
    {75, 2183, 0, 0, Smoke::mf_slot, 0, 37},	//1905 Plasma::PopupApplet::showPopup()
    {75, 2198, 248, 1, Smoke::mf_const|Smoke::mf_protected, 291, 38},	//1906 Plasma::PopupApplet::sizeHint(Qt::SizeHint) const
    {75, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 39},	//1907 Plasma::PopupApplet::staticMetaObject() const
    {75, 2450, 0, 0, Smoke::mf_dtor, 0, 40 },	//1908 Plasma::PopupApplet::~PopupApplet()
    {76, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//1909 Plasma::PushButton::metaObject() const
    {76, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//1910 Plasma::PushButton::qt_metacast(const char*)
    {76, 2304, 43, 2, Smoke::mf_static, 293, 3},	//1911 Plasma::PushButton::tr(const char*, const char*)
    {76, 2308, 43, 2, Smoke::mf_static, 293, 4},	//1912 Plasma::PushButton::trUtf8(const char*, const char*)
    {76, 2304, 46, 3, Smoke::mf_static, 293, 5},	//1913 Plasma::PushButton::tr(const char*, const char*, int)
    {76, 2308, 46, 3, Smoke::mf_static, 293, 6},	//1914 Plasma::PushButton::trUtf8(const char*, const char*, int)
    {76, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//1915 Plasma::PushButton::qt_metacall(QMetaObject::Call, int, void**)
    {76, 385, 125, 1, Smoke::mf_ctor, 130, 8},	//1916 Plasma::PushButton::PushButton(QGraphicsWidget*)
    {76, 2080, 89, 1, Smoke::mf_property, 0, 9},	//1917 Plasma::PushButton::setText(const QString&)
    {76, 2274, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 10},	//1918 Plasma::PushButton::text() const
    {76, 1865, 89, 1, Smoke::mf_property, 0, 11},	//1919 Plasma::PushButton::setImage(const QString&)
    {76, 1865, 77, 2, 0, 0, 12},	//1920 Plasma::PushButton::setImage(const QString&, const QString&)
    {76, 1079, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 13},	//1921 Plasma::PushButton::image() const
    {76, 2048, 89, 1, Smoke::mf_property, 0, 14},	//1922 Plasma::PushButton::setStyleSheet(const QString&)
    {76, 2236, 0, 0, Smoke::mf_property, 293, 15},	//1923 Plasma::PushButton::styleSheet()
    {76, 1658, 107, 1, 0, 0, 16},	//1924 Plasma::PushButton::setAction(QAction*)
    {76, 557, 0, 0, Smoke::mf_const, 183, 17},	//1925 Plasma::PushButton::action() const
    {76, 1858, 567, 1, Smoke::mf_property, 0, 18},	//1926 Plasma::PushButton::setIcon(const QIcon&)
    {76, 1858, 729, 1, 0, 0, 19},	//1927 Plasma::PushButton::setIcon(const KIcon&)
    {76, 1075, 0, 0, Smoke::mf_const|Smoke::mf_property, 236, 20},	//1928 Plasma::PushButton::icon() const
    {76, 1712, 7, 1, Smoke::mf_property, 0, 21},	//1929 Plasma::PushButton::setCheckable(bool)
    {76, 1123, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 22},	//1930 Plasma::PushButton::isCheckable() const
    {76, 1124, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 23},	//1931 Plasma::PushButton::isChecked() const
    {76, 1130, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 24},	//1932 Plasma::PushButton::isDown() const
    {76, 1388, 0, 0, Smoke::mf_const, 15, 25},	//1933 Plasma::PushButton::nativeWidget() const
    {76, 1476, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 26},	//1934 Plasma::PushButton::pressed()
    {76, 1516, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 27},	//1935 Plasma::PushButton::released()
    {76, 726, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 28},	//1936 Plasma::PushButton::clicked()
    {76, 2293, 7, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 29},	//1937 Plasma::PushButton::toggled(bool)
    {76, 724, 0, 0, Smoke::mf_slot, 0, 30},	//1938 Plasma::PushButton::click()
    {76, 1714, 7, 1, Smoke::mf_property|Smoke::mf_slot, 0, 31},	//1939 Plasma::PushButton::setChecked(bool)
    {76, 1420, 216, 3, Smoke::mf_protected|Smoke::mf_virtual, 0, 32},	//1940 Plasma::PushButton::paint(QPainter*, const QStyleOptionGraphicsItem*, QWidget*)
    {76, 1584, 282, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 33},	//1941 Plasma::PushButton::resizeEvent(QGraphicsSceneResizeEvent*)
    {76, 1068, 290, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 34},	//1942 Plasma::PushButton::hoverEnterEvent(QGraphicsSceneHoverEvent*)
    {76, 1070, 290, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 35},	//1943 Plasma::PushButton::hoverLeaveEvent(QGraphicsSceneHoverEvent*)
    {76, 710, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 36},	//1944 Plasma::PushButton::changeEvent(QEvent*)
    {76, 2198, 287, 2, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 291, 37},	//1945 Plasma::PushButton::sizeHint(Qt::SizeHint, const QSizeF&) const
    {76, 2304, 1, 1, Smoke::mf_static, 293, 38},	//1946 Plasma::PushButton::tr(const char*)
    {76, 2308, 1, 1, Smoke::mf_static, 293, 39},	//1947 Plasma::PushButton::trUtf8(const char*)
    {76, 385, 0, 0, Smoke::mf_ctor, 130, 40},	//1948 Plasma::PushButton::PushButton()
    {76, 1420, 328, 2, Smoke::mf_protected, 0, 41},	//1949 Plasma::PushButton::paint(QPainter*, const QStyleOptionGraphicsItem*)
    {76, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 42},	//1950 Plasma::PushButton::staticMetaObject() const
    {76, 2451, 0, 0, Smoke::mf_dtor, 0, 43 },	//1951 Plasma::PushButton::~PushButton()
    {77, 387, 731, 1, Smoke::mf_ctor, 133, 1},	//1952 Plasma::QueryMatch::QueryMatch(Plasma::AbstractRunner*)
    {77, 387, 80, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 133, 2},	//1953 Plasma::QueryMatch::QueryMatch(const Plasma::QueryMatch&)
    {77, 1408, 80, 1, 0, 132, 3},	//1954 Plasma::QueryMatch::operator=(const Plasma::QueryMatch&)
    {77, 1410, 80, 1, Smoke::mf_const, 386, 4},	//1955 Plasma::QueryMatch::operator==(const Plasma::QueryMatch&) const
    {77, 1404, 80, 1, Smoke::mf_const, 386, 5},	//1956 Plasma::QueryMatch::operator!=(const Plasma::QueryMatch&) const
    {77, 1406, 80, 1, Smoke::mf_const, 386, 6},	//1957 Plasma::QueryMatch::operator<(const Plasma::QueryMatch&) const
    {77, 1602, 0, 0, Smoke::mf_const, 32, 7},	//1958 Plasma::QueryMatch::runner() const
    {77, 1164, 0, 0, Smoke::mf_const, 386, 8},	//1959 Plasma::QueryMatch::isValid() const
    {77, 2104, 733, 1, 0, 0, 9},	//1960 Plasma::QueryMatch::setType(Plasma::QueryMatch::Type)
    {77, 2313, 0, 0, Smoke::mf_const, 134, 10},	//1961 Plasma::QueryMatch::type() const
    {77, 1982, 735, 1, 0, 0, 11},	//1962 Plasma::QueryMatch::setRelevance(double)
    {77, 1517, 0, 0, Smoke::mf_const, 474, 12},	//1963 Plasma::QueryMatch::relevance() const
    {77, 1597, 737, 1, Smoke::mf_const, 0, 13},	//1964 Plasma::QueryMatch::run(const Plasma::RunnerContext&) const
    {77, 1761, 739, 1, 0, 0, 14},	//1965 Plasma::QueryMatch::setData(const QVariant&)
    {77, 838, 0, 0, Smoke::mf_const, 304, 15},	//1966 Plasma::QueryMatch::data() const
    {77, 1861, 89, 1, 0, 0, 16},	//1967 Plasma::QueryMatch::setId(const QString&)
    {77, 1077, 0, 0, Smoke::mf_const, 293, 17},	//1968 Plasma::QueryMatch::id() const
    {77, 2080, 89, 1, 0, 0, 18},	//1969 Plasma::QueryMatch::setText(const QString&)
    {77, 2274, 0, 0, Smoke::mf_const, 293, 19},	//1970 Plasma::QueryMatch::text() const
    {77, 2052, 89, 1, 0, 0, 20},	//1971 Plasma::QueryMatch::setSubtext(const QString&)
    {77, 2239, 0, 0, Smoke::mf_const, 293, 21},	//1972 Plasma::QueryMatch::subtext() const
    {77, 1858, 567, 1, 0, 0, 22},	//1973 Plasma::QueryMatch::setIcon(const QIcon&)
    {77, 1075, 0, 0, Smoke::mf_const, 236, 23},	//1974 Plasma::QueryMatch::icon() const
    {77, 1806, 7, 1, 0, 0, 24},	//1975 Plasma::QueryMatch::setEnabled(bool)
    {77, 1132, 0, 0, Smoke::mf_const, 386, 25},	//1976 Plasma::QueryMatch::isEnabled() const
    {77, 1645, 0, 0, Smoke::mf_const, 183, 26},	//1977 Plasma::QueryMatch::selectedAction() const
    {77, 2011, 107, 1, 0, 0, 27},	//1978 Plasma::QueryMatch::setSelectedAction(QAction*)
    {77, 1040, 0, 0, Smoke::mf_const, 386, 28},	//1979 Plasma::QueryMatch::hasConfigurationInterface() const
    {77, 805, 57, 1, 0, 0, 29},	//1980 Plasma::QueryMatch::createConfigurationInterface(QWidget*)
    {77, 341, 0, 0, Smoke::mf_static|Smoke::mf_enum, 134, 30},	//1981 Plasma::QueryMatch::NoMatch (enum)
    {77, 91, 0, 0, Smoke::mf_static|Smoke::mf_enum, 134, 31},	//1982 Plasma::QueryMatch::CompletionMatch (enum)
    {77, 381, 0, 0, Smoke::mf_static|Smoke::mf_enum, 134, 32},	//1983 Plasma::QueryMatch::PossibleMatch (enum)
    {77, 223, 0, 0, Smoke::mf_static|Smoke::mf_enum, 134, 33},	//1984 Plasma::QueryMatch::InformationalMatch (enum)
    {77, 205, 0, 0, Smoke::mf_static|Smoke::mf_enum, 134, 34},	//1985 Plasma::QueryMatch::HelperMatch (enum)
    {77, 164, 0, 0, Smoke::mf_static|Smoke::mf_enum, 134, 35},	//1986 Plasma::QueryMatch::ExactMatch (enum)
    {77, 2452, 0, 0, Smoke::mf_dtor, 0, 36 },	//1987 Plasma::QueryMatch::~QueryMatch()
    {78, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//1988 Plasma::RadioButton::metaObject() const
    {78, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//1989 Plasma::RadioButton::qt_metacast(const char*)
    {78, 2304, 43, 2, Smoke::mf_static, 293, 3},	//1990 Plasma::RadioButton::tr(const char*, const char*)
    {78, 2308, 43, 2, Smoke::mf_static, 293, 4},	//1991 Plasma::RadioButton::trUtf8(const char*, const char*)
    {78, 2304, 46, 3, Smoke::mf_static, 293, 5},	//1992 Plasma::RadioButton::tr(const char*, const char*, int)
    {78, 2308, 46, 3, Smoke::mf_static, 293, 6},	//1993 Plasma::RadioButton::trUtf8(const char*, const char*, int)
    {78, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//1994 Plasma::RadioButton::qt_metacall(QMetaObject::Call, int, void**)
    {78, 390, 125, 1, Smoke::mf_ctor, 135, 8},	//1995 Plasma::RadioButton::RadioButton(QGraphicsWidget*)
    {78, 2080, 89, 1, Smoke::mf_property, 0, 9},	//1996 Plasma::RadioButton::setText(const QString&)
    {78, 2274, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 10},	//1997 Plasma::RadioButton::text() const
    {78, 1865, 89, 1, Smoke::mf_property, 0, 11},	//1998 Plasma::RadioButton::setImage(const QString&)
    {78, 1079, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 12},	//1999 Plasma::RadioButton::image() const
    {78, 2048, 89, 1, Smoke::mf_property, 0, 13},	//2000 Plasma::RadioButton::setStyleSheet(const QString&)
    {78, 2236, 0, 0, Smoke::mf_property, 293, 14},	//2001 Plasma::RadioButton::styleSheet()
    {78, 1388, 0, 0, Smoke::mf_const, 281, 15},	//2002 Plasma::RadioButton::nativeWidget() const
    {78, 1714, 7, 1, Smoke::mf_property, 0, 16},	//2003 Plasma::RadioButton::setChecked(bool)
    {78, 1124, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 17},	//2004 Plasma::RadioButton::isChecked() const
    {78, 2293, 7, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 18},	//2005 Plasma::RadioButton::toggled(bool)
    {78, 1584, 282, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 19},	//2006 Plasma::RadioButton::resizeEvent(QGraphicsSceneResizeEvent*)
    {78, 710, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 20},	//2007 Plasma::RadioButton::changeEvent(QEvent*)
    {78, 2304, 1, 1, Smoke::mf_static, 293, 21},	//2008 Plasma::RadioButton::tr(const char*)
    {78, 2308, 1, 1, Smoke::mf_static, 293, 22},	//2009 Plasma::RadioButton::trUtf8(const char*)
    {78, 390, 0, 0, Smoke::mf_ctor, 135, 23},	//2010 Plasma::RadioButton::RadioButton()
    {78, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 24},	//2011 Plasma::RadioButton::staticMetaObject() const
    {78, 2453, 0, 0, Smoke::mf_dtor, 0, 25 },	//2012 Plasma::RadioButton::~RadioButton()
    {79, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//2013 Plasma::RunnerContext::metaObject() const
    {79, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//2014 Plasma::RunnerContext::qt_metacast(const char*)
    {79, 2304, 43, 2, Smoke::mf_static, 293, 3},	//2015 Plasma::RunnerContext::tr(const char*, const char*)
    {79, 2308, 43, 2, Smoke::mf_static, 293, 4},	//2016 Plasma::RunnerContext::trUtf8(const char*, const char*)
    {79, 2304, 46, 3, Smoke::mf_static, 293, 5},	//2017 Plasma::RunnerContext::tr(const char*, const char*, int)
    {79, 2308, 46, 3, Smoke::mf_static, 293, 6},	//2018 Plasma::RunnerContext::trUtf8(const char*, const char*, int)
    {79, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//2019 Plasma::RunnerContext::qt_metacall(QMetaObject::Call, int, void**)
    {79, 405, 97, 1, Smoke::mf_ctor, 137, 8},	//2020 Plasma::RunnerContext::RunnerContext(QObject*)
    {79, 405, 741, 2, Smoke::mf_ctor, 137, 9},	//2021 Plasma::RunnerContext::RunnerContext(Plasma::RunnerContext&, QObject*)
    {79, 1408, 737, 1, 0, 136, 10},	//2022 Plasma::RunnerContext::operator=(const Plasma::RunnerContext&)
    {79, 1579, 0, 0, 0, 0, 11},	//2023 Plasma::RunnerContext::reset()
    {79, 1976, 89, 1, 0, 0, 12},	//2024 Plasma::RunnerContext::setQuery(const QString&)
    {79, 1489, 0, 0, Smoke::mf_const, 293, 13},	//2025 Plasma::RunnerContext::query() const
    {79, 2313, 0, 0, Smoke::mf_const, 138, 14},	//2026 Plasma::RunnerContext::type() const
    {79, 1358, 0, 0, Smoke::mf_const, 293, 15},	//2027 Plasma::RunnerContext::mimeType() const
    {79, 1164, 0, 0, Smoke::mf_const, 386, 16},	//2028 Plasma::RunnerContext::isValid() const
    {79, 605, 744, 2, 0, 386, 17},	//2029 Plasma::RunnerContext::addMatches(const QString&, const QList<Plasma::QueryMatch>&)
    {79, 603, 747, 2, 0, 386, 18},	//2030 Plasma::RunnerContext::addMatch(const QString&, const Plasma::QueryMatch&)
    {79, 1542, 750, 1, 0, 386, 19},	//2031 Plasma::RunnerContext::removeMatch(const QString)
    {79, 1544, 752, 1, 0, 386, 20},	//2032 Plasma::RunnerContext::removeMatches(const QStringList)
    {79, 1544, 731, 1, 0, 386, 21},	//2033 Plasma::RunnerContext::removeMatches(Plasma::AbstractRunner*)
    {79, 1340, 0, 0, Smoke::mf_const, 253, 22},	//2034 Plasma::RunnerContext::matches() const
    {79, 1336, 89, 1, Smoke::mf_const, 131, 23},	//2035 Plasma::RunnerContext::match(const QString&) const
    {79, 2031, 7, 1, 0, 0, 24},	//2036 Plasma::RunnerContext::setSingleRunnerQueryMode(bool)
    {79, 2192, 0, 0, Smoke::mf_const, 386, 25},	//2037 Plasma::RunnerContext::singleRunnerQueryMode() const
    {79, 1589, 111, 1, 0, 0, 26},	//2038 Plasma::RunnerContext::restore(const KConfigGroup&)
    {79, 1607, 178, 1, 0, 0, 27},	//2039 Plasma::RunnerContext::save(KConfigGroup&)
    {79, 1597, 80, 1, 0, 0, 28},	//2040 Plasma::RunnerContext::run(const Plasma::QueryMatch&)
    {79, 1341, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 29},	//2041 Plasma::RunnerContext::matchesChanged()
    {79, 2304, 1, 1, Smoke::mf_static, 293, 30},	//2042 Plasma::RunnerContext::tr(const char*)
    {79, 2308, 1, 1, Smoke::mf_static, 293, 31},	//2043 Plasma::RunnerContext::trUtf8(const char*)
    {79, 405, 0, 0, Smoke::mf_ctor, 137, 32},	//2044 Plasma::RunnerContext::RunnerContext()
    {79, 405, 55, 1, Smoke::mf_ctor, 137, 33},	//2045 Plasma::RunnerContext::RunnerContext(Plasma::RunnerContext&)
    {79, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 34},	//2046 Plasma::RunnerContext::staticMetaObject() const
    {79, 344, 0, 0, Smoke::mf_static|Smoke::mf_enum, 138, 35},	//2047 Plasma::RunnerContext::None (enum)
    {79, 512, 0, 0, Smoke::mf_static|Smoke::mf_enum, 138, 36},	//2048 Plasma::RunnerContext::UnknownType (enum)
    {79, 150, 0, 0, Smoke::mf_static|Smoke::mf_enum, 138, 37},	//2049 Plasma::RunnerContext::Directory (enum)
    {79, 177, 0, 0, Smoke::mf_static|Smoke::mf_enum, 138, 38},	//2050 Plasma::RunnerContext::File (enum)
    {79, 321, 0, 0, Smoke::mf_static|Smoke::mf_enum, 138, 39},	//2051 Plasma::RunnerContext::NetworkLocation (enum)
    {79, 165, 0, 0, Smoke::mf_static|Smoke::mf_enum, 138, 40},	//2052 Plasma::RunnerContext::Executable (enum)
    {79, 440, 0, 0, Smoke::mf_static|Smoke::mf_enum, 138, 41},	//2053 Plasma::RunnerContext::ShellCommand (enum)
    {79, 204, 0, 0, Smoke::mf_static|Smoke::mf_enum, 138, 42},	//2054 Plasma::RunnerContext::Help (enum)
    {79, 178, 0, 0, Smoke::mf_static|Smoke::mf_enum, 138, 43},	//2055 Plasma::RunnerContext::FileSystem (enum)
    {79, 2454, 0, 0, Smoke::mf_dtor, 0, 44 },	//2056 Plasma::RunnerContext::~RunnerContext()
    {80, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//2057 Plasma::RunnerManager::metaObject() const
    {80, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//2058 Plasma::RunnerManager::qt_metacast(const char*)
    {80, 2304, 43, 2, Smoke::mf_static, 293, 3},	//2059 Plasma::RunnerManager::tr(const char*, const char*)
    {80, 2308, 43, 2, Smoke::mf_static, 293, 4},	//2060 Plasma::RunnerManager::trUtf8(const char*, const char*)
    {80, 2304, 46, 3, Smoke::mf_static, 293, 5},	//2061 Plasma::RunnerManager::tr(const char*, const char*, int)
    {80, 2308, 46, 3, Smoke::mf_static, 293, 6},	//2062 Plasma::RunnerManager::trUtf8(const char*, const char*, int)
    {80, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//2063 Plasma::RunnerManager::qt_metacall(QMetaObject::Call, int, void**)
    {80, 408, 97, 1, Smoke::mf_ctor, 139, 8},	//2064 Plasma::RunnerManager::RunnerManager(QObject*)
    {80, 408, 754, 2, Smoke::mf_ctor, 139, 9},	//2065 Plasma::RunnerManager::RunnerManager(KConfigGroup&, QObject*)
    {80, 1602, 89, 1, Smoke::mf_const, 32, 10},	//2066 Plasma::RunnerManager::runner(const QString&) const
    {80, 2190, 0, 0, Smoke::mf_const, 32, 11},	//2067 Plasma::RunnerManager::singleModeRunner() const
    {80, 2029, 89, 1, 0, 0, 12},	//2068 Plasma::RunnerManager::setSingleModeRunnerId(const QString&)
    {80, 2191, 0, 0, Smoke::mf_const, 293, 13},	//2069 Plasma::RunnerManager::singleModeRunnerId() const
    {80, 2188, 0, 0, Smoke::mf_const, 386, 14},	//2070 Plasma::RunnerManager::singleMode() const
    {80, 2027, 7, 1, 0, 0, 15},	//2071 Plasma::RunnerManager::setSingleMode(bool)
    {80, 1604, 89, 1, Smoke::mf_const, 293, 16},	//2072 Plasma::RunnerManager::runnerName(const QString&) const
    {80, 1606, 0, 0, Smoke::mf_const, 245, 17},	//2073 Plasma::RunnerManager::runners() const
    {80, 2189, 0, 0, Smoke::mf_const, 294, 18},	//2074 Plasma::RunnerManager::singleModeAdvertisedRunnerIds() const
    {80, 1639, 0, 0, Smoke::mf_const, 137, 19},	//2075 Plasma::RunnerManager::searchContext() const
    {80, 1340, 0, 0, Smoke::mf_const, 253, 20},	//2076 Plasma::RunnerManager::matches() const
    {80, 1597, 80, 1, 0, 0, 21},	//2077 Plasma::RunnerManager::run(const Plasma::QueryMatch&)
    {80, 1597, 89, 1, 0, 0, 22},	//2078 Plasma::RunnerManager::run(const QString&)
    {80, 561, 80, 1, 0, 255, 23},	//2079 Plasma::RunnerManager::actionsForMatch(const Plasma::QueryMatch&)
    {80, 1489, 0, 0, Smoke::mf_const, 293, 24},	//2080 Plasma::RunnerManager::query() const
    {80, 1519, 0, 0, 0, 0, 25},	//2081 Plasma::RunnerManager::reloadConfiguration()
    {80, 1666, 200, 1, 0, 0, 26},	//2082 Plasma::RunnerManager::setAllowedRunners(const QStringList&)
    {80, 1309, 99, 1, 0, 0, 27},	//2083 Plasma::RunnerManager::loadRunner(const KSharedPtr<KService>)
    {80, 1309, 89, 1, 0, 0, 28},	//2084 Plasma::RunnerManager::loadRunner(const QString&)
    {80, 642, 0, 0, Smoke::mf_const, 294, 29},	//2085 Plasma::RunnerManager::allowedRunners() const
    {80, 1355, 80, 1, Smoke::mf_const, 266, 30},	//2086 Plasma::RunnerManager::mimeDataForMatch(const Plasma::QueryMatch&) const
    {80, 1355, 89, 1, Smoke::mf_const, 266, 31},	//2087 Plasma::RunnerManager::mimeDataForMatch(const QString&) const
    {80, 1271, 89, 1, Smoke::mf_static, 242, 32},	//2088 Plasma::RunnerManager::listRunnerInfo(const QString&)
    {80, 2160, 0, 0, Smoke::mf_slot, 0, 33},	//2089 Plasma::RunnerManager::setupMatchSession()
    {80, 1339, 0, 0, Smoke::mf_slot, 0, 34},	//2090 Plasma::RunnerManager::matchSessionComplete()
    {80, 1224, 77, 2, Smoke::mf_slot, 0, 35},	//2091 Plasma::RunnerManager::launchQuery(const QString&, const QString&)
    {80, 1224, 89, 1, Smoke::mf_slot, 0, 36},	//2092 Plasma::RunnerManager::launchQuery(const QString&)
    {80, 960, 77, 2, Smoke::mf_slot, 386, 37},	//2093 Plasma::RunnerManager::execQuery(const QString&, const QString&)
    {80, 960, 89, 1, Smoke::mf_slot, 386, 38},	//2094 Plasma::RunnerManager::execQuery(const QString&)
    {80, 1579, 0, 0, Smoke::mf_slot, 0, 39},	//2095 Plasma::RunnerManager::reset()
    {80, 1341, 757, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 40},	//2096 Plasma::RunnerManager::matchesChanged(const QList<Plasma::QueryMatch>&)
    {80, 1491, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 41},	//2097 Plasma::RunnerManager::queryFinished()
    {80, 2304, 1, 1, Smoke::mf_static, 293, 42},	//2098 Plasma::RunnerManager::tr(const char*)
    {80, 2308, 1, 1, Smoke::mf_static, 293, 43},	//2099 Plasma::RunnerManager::trUtf8(const char*)
    {80, 408, 0, 0, Smoke::mf_ctor, 139, 44},	//2100 Plasma::RunnerManager::RunnerManager()
    {80, 408, 178, 1, Smoke::mf_ctor, 139, 45},	//2101 Plasma::RunnerManager::RunnerManager(KConfigGroup&)
    {80, 1271, 0, 0, Smoke::mf_static, 242, 46},	//2102 Plasma::RunnerManager::listRunnerInfo()
    {80, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 47},	//2103 Plasma::RunnerManager::staticMetaObject() const
    {80, 2455, 0, 0, Smoke::mf_dtor, 0, 48 },	//2104 Plasma::RunnerManager::~RunnerManager()
    {81, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//2105 Plasma::RunnerScript::metaObject() const
    {81, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//2106 Plasma::RunnerScript::qt_metacast(const char*)
    {81, 2304, 43, 2, Smoke::mf_static, 293, 3},	//2107 Plasma::RunnerScript::tr(const char*, const char*)
    {81, 2308, 43, 2, Smoke::mf_static, 293, 4},	//2108 Plasma::RunnerScript::trUtf8(const char*, const char*)
    {81, 2304, 46, 3, Smoke::mf_static, 293, 5},	//2109 Plasma::RunnerScript::tr(const char*, const char*, int)
    {81, 2308, 46, 3, Smoke::mf_static, 293, 6},	//2110 Plasma::RunnerScript::trUtf8(const char*, const char*, int)
    {81, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//2111 Plasma::RunnerScript::qt_metacall(QMetaObject::Call, int, void**)
    {81, 411, 97, 1, Smoke::mf_ctor, 140, 8},	//2112 Plasma::RunnerScript::RunnerScript(QObject*)
    {81, 1998, 731, 1, 0, 0, 9},	//2113 Plasma::RunnerScript::setRunner(Plasma::AbstractRunner*)
    {81, 1602, 0, 0, Smoke::mf_const, 32, 10},	//2114 Plasma::RunnerScript::runner() const
    {81, 1336, 55, 1, Smoke::mf_virtual, 0, 11},	//2115 Plasma::RunnerScript::match(Plasma::RunnerContext&)
    {81, 1597, 59, 2, Smoke::mf_virtual, 0, 12},	//2116 Plasma::RunnerScript::run(const Plasma::RunnerContext&, const Plasma::QueryMatch&)
    {81, 1475, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 13},	//2117 Plasma::RunnerScript::prepare()
    {81, 2273, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 14},	//2118 Plasma::RunnerScript::teardown()
    {81, 817, 57, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 15},	//2119 Plasma::RunnerScript::createRunOptions(QWidget*)
    {81, 1519, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 16},	//2120 Plasma::RunnerScript::reloadConfiguration()
    {81, 561, 759, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 17},	//2121 Plasma::RunnerScript::actionsForMatch(const Plasma::QueryMatch&, QList<QAction*>*)
    {81, 1324, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 293, 18},	//2122 Plasma::RunnerScript::mainScript() const
    {81, 1414, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 409, 19},	//2123 Plasma::RunnerScript::package() const
    {81, 849, 0, 0, Smoke::mf_const|Smoke::mf_protected, 14, 20},	//2124 Plasma::RunnerScript::description() const
    {81, 839, 89, 1, Smoke::mf_protected, 81, 21},	//2125 Plasma::RunnerScript::dataEngine(const QString&)
    {81, 738, 0, 0, Smoke::mf_const|Smoke::mf_protected, 8, 22},	//2126 Plasma::RunnerScript::config() const
    {81, 1863, 62, 1, Smoke::mf_protected, 0, 23},	//2127 Plasma::RunnerScript::setIgnoredTypes(QFlags<Plasma::RunnerContext::Type>)
    {81, 1841, 7, 1, Smoke::mf_protected, 0, 24},	//2128 Plasma::RunnerScript::setHasRunOptions(bool)
    {81, 2037, 73, 1, Smoke::mf_protected, 0, 25},	//2129 Plasma::RunnerScript::setSpeed(Plasma::AbstractRunner::Speed)
    {81, 1974, 75, 1, Smoke::mf_protected, 0, 26},	//2130 Plasma::RunnerScript::setPriority(Plasma::AbstractRunner::Priority)
    {81, 1652, 77, 2, Smoke::mf_const|Smoke::mf_protected, 244, 27},	//2131 Plasma::RunnerScript::serviceQuery(const QString&, const QString&) const
    {81, 574, 82, 3, Smoke::mf_protected, 183, 28},	//2132 Plasma::RunnerScript::addAction(const QString&, const QIcon&, const QString&)
    {81, 574, 86, 2, Smoke::mf_protected, 0, 29},	//2133 Plasma::RunnerScript::addAction(const QString&, QAction*)
    {81, 1529, 89, 1, Smoke::mf_protected, 0, 30},	//2134 Plasma::RunnerScript::removeAction(const QString&)
    {81, 557, 89, 1, Smoke::mf_const|Smoke::mf_protected, 183, 31},	//2135 Plasma::RunnerScript::action(const QString&) const
    {81, 560, 0, 0, Smoke::mf_const|Smoke::mf_protected, 232, 32},	//2136 Plasma::RunnerScript::actions() const
    {81, 718, 0, 0, Smoke::mf_protected, 0, 33},	//2137 Plasma::RunnerScript::clearActions()
    {81, 626, 91, 1, Smoke::mf_protected, 0, 34},	//2138 Plasma::RunnerScript::addSyntax(const Plasma::RunnerSyntax&)
    {81, 2060, 93, 1, Smoke::mf_protected, 0, 35},	//2139 Plasma::RunnerScript::setSyntaxes(const QList<Plasma::RunnerSyntax>&)
    {81, 2304, 1, 1, Smoke::mf_static, 293, 36},	//2140 Plasma::RunnerScript::tr(const char*)
    {81, 2308, 1, 1, Smoke::mf_static, 293, 37},	//2141 Plasma::RunnerScript::trUtf8(const char*)
    {81, 411, 0, 0, Smoke::mf_ctor, 140, 38},	//2142 Plasma::RunnerScript::RunnerScript()
    {81, 1652, 89, 1, Smoke::mf_const|Smoke::mf_protected, 244, 39},	//2143 Plasma::RunnerScript::serviceQuery(const QString&) const
    {81, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 40},	//2144 Plasma::RunnerScript::staticMetaObject() const
    {81, 2456, 0, 0, Smoke::mf_dtor, 0, 41 },	//2145 Plasma::RunnerScript::~RunnerScript()
    {82, 413, 77, 2, Smoke::mf_ctor, 143, 1},	//2146 Plasma::RunnerSyntax::RunnerSyntax(const QString&, const QString&)
    {82, 413, 91, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 143, 2},	//2147 Plasma::RunnerSyntax::RunnerSyntax(const Plasma::RunnerSyntax&)
    {82, 1408, 91, 1, 0, 142, 3},	//2148 Plasma::RunnerSyntax::operator=(const Plasma::RunnerSyntax&)
    {82, 595, 89, 1, 0, 0, 4},	//2149 Plasma::RunnerSyntax::addExampleQuery(const QString&)
    {82, 958, 0, 0, Smoke::mf_const, 294, 5},	//2150 Plasma::RunnerSyntax::exampleQueries() const
    {82, 959, 0, 0, Smoke::mf_const, 294, 6},	//2151 Plasma::RunnerSyntax::exampleQueriesWithTermDescription() const
    {82, 1779, 89, 1, 0, 0, 7},	//2152 Plasma::RunnerSyntax::setDescription(const QString&)
    {82, 849, 0, 0, Smoke::mf_const, 293, 8},	//2153 Plasma::RunnerSyntax::description() const
    {82, 2009, 89, 1, 0, 0, 9},	//2154 Plasma::RunnerSyntax::setSearchTermDescription(const QString&)
    {82, 1642, 0, 0, Smoke::mf_const, 293, 10},	//2155 Plasma::RunnerSyntax::searchTermDescription() const
    {82, 2457, 0, 0, Smoke::mf_dtor, 0, 11 },	//2156 Plasma::RunnerSyntax::~RunnerSyntax()
    {83, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//2157 Plasma::ScriptEngine::metaObject() const
    {83, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//2158 Plasma::ScriptEngine::qt_metacast(const char*)
    {83, 2304, 43, 2, Smoke::mf_static, 293, 3},	//2159 Plasma::ScriptEngine::tr(const char*, const char*)
    {83, 2308, 43, 2, Smoke::mf_static, 293, 4},	//2160 Plasma::ScriptEngine::trUtf8(const char*, const char*)
    {83, 2304, 46, 3, Smoke::mf_static, 293, 5},	//2161 Plasma::ScriptEngine::tr(const char*, const char*, int)
    {83, 2308, 46, 3, Smoke::mf_static, 293, 6},	//2162 Plasma::ScriptEngine::trUtf8(const char*, const char*, int)
    {83, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//2163 Plasma::ScriptEngine::qt_metacall(QMetaObject::Call, int, void**)
    {83, 1091, 0, 0, Smoke::mf_virtual, 386, 8},	//2164 Plasma::ScriptEngine::init()
    {83, 421, 97, 1, Smoke::mf_ctor|Smoke::mf_protected, 144, 9},	//2165 Plasma::ScriptEngine::ScriptEngine(QObject*)
    {83, 1324, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 293, 10},	//2166 Plasma::ScriptEngine::mainScript() const
    {83, 1414, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 409, 11},	//2167 Plasma::ScriptEngine::package() const
    {83, 2304, 1, 1, Smoke::mf_static, 293, 12},	//2168 Plasma::ScriptEngine::tr(const char*)
    {83, 2308, 1, 1, Smoke::mf_static, 293, 13},	//2169 Plasma::ScriptEngine::trUtf8(const char*)
    {83, 421, 0, 0, Smoke::mf_ctor|Smoke::mf_protected, 144, 14},	//2170 Plasma::ScriptEngine::ScriptEngine()
    {83, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 15},	//2171 Plasma::ScriptEngine::staticMetaObject() const
    {83, 2458, 0, 0, Smoke::mf_dtor, 0, 16 },	//2172 Plasma::ScriptEngine::~ScriptEngine()
    {84, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//2173 Plasma::ScrollBar::metaObject() const
    {84, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//2174 Plasma::ScrollBar::qt_metacast(const char*)
    {84, 2304, 43, 2, Smoke::mf_static, 293, 3},	//2175 Plasma::ScrollBar::tr(const char*, const char*)
    {84, 2308, 43, 2, Smoke::mf_static, 293, 4},	//2176 Plasma::ScrollBar::trUtf8(const char*, const char*)
    {84, 2304, 46, 3, Smoke::mf_static, 293, 5},	//2177 Plasma::ScrollBar::tr(const char*, const char*, int)
    {84, 2308, 46, 3, Smoke::mf_static, 293, 6},	//2178 Plasma::ScrollBar::trUtf8(const char*, const char*, int)
    {84, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//2179 Plasma::ScrollBar::qt_metacall(QMetaObject::Call, int, void**)
    {84, 423, 125, 1, Smoke::mf_ctor, 145, 8},	//2180 Plasma::ScrollBar::ScrollBar(QGraphicsWidget*)
    {84, 1978, 370, 2, 0, 0, 9},	//2181 Plasma::ScrollBar::setRange(int, int)
    {84, 2033, 129, 1, Smoke::mf_property, 0, 10},	//2182 Plasma::ScrollBar::setSingleStep(int)
    {84, 2193, 0, 0, Smoke::mf_property, 477, 11},	//2183 Plasma::ScrollBar::singleStep()
    {84, 1943, 129, 1, Smoke::mf_property, 0, 12},	//2184 Plasma::ScrollBar::setPageStep(int)
    {84, 1419, 0, 0, Smoke::mf_property, 477, 13},	//2185 Plasma::ScrollBar::pageStep()
    {84, 2360, 0, 0, Smoke::mf_const|Smoke::mf_property, 477, 14},	//2186 Plasma::ScrollBar::value() const
    {84, 1361, 0, 0, Smoke::mf_const|Smoke::mf_property, 477, 15},	//2187 Plasma::ScrollBar::minimum() const
    {84, 1346, 0, 0, Smoke::mf_const|Smoke::mf_property, 477, 16},	//2188 Plasma::ScrollBar::maximum() const
    {84, 1910, 762, 1, Smoke::mf_const|Smoke::mf_property, 0, 17},	//2189 Plasma::ScrollBar::setMinimum(const int) const
    {84, 1902, 762, 1, Smoke::mf_const|Smoke::mf_property, 0, 18},	//2190 Plasma::ScrollBar::setMaximum(const int) const
    {84, 2048, 89, 1, Smoke::mf_property, 0, 19},	//2191 Plasma::ScrollBar::setStyleSheet(const QString&)
    {84, 2236, 0, 0, Smoke::mf_property, 293, 20},	//2192 Plasma::ScrollBar::styleSheet()
    {84, 1388, 0, 0, Smoke::mf_const, 288, 21},	//2193 Plasma::ScrollBar::nativeWidget() const
    {84, 1412, 0, 0, Smoke::mf_const|Smoke::mf_property, 358, 22},	//2194 Plasma::ScrollBar::orientation() const
    {84, 794, 394, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 23},	//2195 Plasma::ScrollBar::contextMenuEvent(QGraphicsSceneContextMenuEvent*)
    {84, 2124, 129, 1, Smoke::mf_property|Smoke::mf_slot, 0, 24},	//2196 Plasma::ScrollBar::setValue(int)
    {84, 1935, 642, 1, Smoke::mf_property|Smoke::mf_slot, 0, 25},	//2197 Plasma::ScrollBar::setOrientation(Qt::Orientation)
    {84, 2361, 129, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 26},	//2198 Plasma::ScrollBar::valueChanged(int)
    {84, 2204, 129, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 27},	//2199 Plasma::ScrollBar::sliderMoved(int)
    {84, 2304, 1, 1, Smoke::mf_static, 293, 28},	//2200 Plasma::ScrollBar::tr(const char*)
    {84, 2308, 1, 1, Smoke::mf_static, 293, 29},	//2201 Plasma::ScrollBar::trUtf8(const char*)
    {84, 423, 0, 0, Smoke::mf_ctor, 145, 30},	//2202 Plasma::ScrollBar::ScrollBar()
    {84, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 31},	//2203 Plasma::ScrollBar::staticMetaObject() const
    {84, 2459, 0, 0, Smoke::mf_dtor, 0, 32 },	//2204 Plasma::ScrollBar::~ScrollBar()
    {85, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//2205 Plasma::ScrollWidget::metaObject() const
    {85, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//2206 Plasma::ScrollWidget::qt_metacast(const char*)
    {85, 2304, 43, 2, Smoke::mf_static, 293, 3},	//2207 Plasma::ScrollWidget::tr(const char*, const char*)
    {85, 2308, 43, 2, Smoke::mf_static, 293, 4},	//2208 Plasma::ScrollWidget::trUtf8(const char*, const char*)
    {85, 2304, 46, 3, Smoke::mf_static, 293, 5},	//2209 Plasma::ScrollWidget::tr(const char*, const char*, int)
    {85, 2308, 46, 3, Smoke::mf_static, 293, 6},	//2210 Plasma::ScrollWidget::trUtf8(const char*, const char*, int)
    {85, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//2211 Plasma::ScrollWidget::qt_metacall(QMetaObject::Call, int, void**)
    {85, 426, 125, 1, Smoke::mf_ctor, 146, 8},	//2212 Plasma::ScrollWidget::ScrollWidget(QGraphicsWidget*)
    {85, 426, 170, 1, Smoke::mf_ctor, 146, 9},	//2213 Plasma::ScrollWidget::ScrollWidget(QGraphicsItem*)
    {85, 2149, 125, 1, 0, 0, 10},	//2214 Plasma::ScrollWidget::setWidget(QGraphicsWidget*)
    {85, 2391, 0, 0, Smoke::mf_const, 229, 11},	//2215 Plasma::ScrollWidget::widget() const
    {85, 1662, 659, 1, 0, 0, 12},	//2216 Plasma::ScrollWidget::setAlignment(QFlags<Qt::AlignmentFlag>)
    {85, 640, 0, 0, Smoke::mf_const, 207, 13},	//2217 Plasma::ScrollWidget::alignment() const
    {85, 1937, 7, 1, Smoke::mf_property, 0, 14},	//2218 Plasma::ScrollWidget::setOverShoot(bool)
    {85, 1050, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 15},	//2219 Plasma::ScrollWidget::hasOverShoot() const
    {85, 1851, 764, 1, Smoke::mf_property, 0, 16},	//2220 Plasma::ScrollWidget::setHorizontalScrollBarPolicy(const Qt::ScrollBarPolicy)
    {85, 1067, 0, 0, Smoke::mf_const|Smoke::mf_property, 362, 17},	//2221 Plasma::ScrollWidget::horizontalScrollBarPolicy() const
    {85, 2136, 764, 1, Smoke::mf_property, 0, 18},	//2222 Plasma::ScrollWidget::setVerticalScrollBarPolicy(const Qt::ScrollBarPolicy)
    {85, 2373, 0, 0, Smoke::mf_const|Smoke::mf_property, 362, 19},	//2223 Plasma::ScrollWidget::verticalScrollBarPolicy() const
    {85, 1413, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 20},	//2224 Plasma::ScrollWidget::overflowBordersVisible() const
    {85, 1939, 109, 1, Smoke::mf_property, 0, 21},	//2225 Plasma::ScrollWidget::setOverflowBordersVisible(const bool)
    {85, 946, 653, 1, 0, 0, 22},	//2226 Plasma::ScrollWidget::ensureRectVisible(const QRectF&)
    {85, 944, 170, 1, 0, 0, 23},	//2227 Plasma::ScrollWidget::ensureItemVisible(QGraphicsItem*)
    {85, 1502, 125, 1, 0, 0, 24},	//2228 Plasma::ScrollWidget::registerAsDragHandle(QGraphicsWidget*)
    {85, 2323, 125, 1, 0, 0, 25},	//2229 Plasma::ScrollWidget::unregisterAsDragHandle(QGraphicsWidget*)
    {85, 2378, 0, 0, Smoke::mf_const|Smoke::mf_property, 283, 26},	//2230 Plasma::ScrollWidget::viewportGeometry() const
    {85, 787, 0, 0, Smoke::mf_const|Smoke::mf_property, 291, 27},	//2231 Plasma::ScrollWidget::contentsSize() const
    {85, 2007, 384, 1, Smoke::mf_property, 0, 28},	//2232 Plasma::ScrollWidget::setScrollPosition(const QPointF&)
    {85, 1635, 0, 0, Smoke::mf_const|Smoke::mf_property, 280, 29},	//2233 Plasma::ScrollWidget::scrollPosition() const
    {85, 2035, 603, 1, Smoke::mf_property, 0, 30},	//2234 Plasma::ScrollWidget::setSnapSize(const QSizeF&)
    {85, 2206, 0, 0, Smoke::mf_const|Smoke::mf_property, 291, 31},	//2235 Plasma::ScrollWidget::snapSize() const
    {85, 2048, 89, 1, Smoke::mf_property, 0, 32},	//2236 Plasma::ScrollWidget::setStyleSheet(const QString&)
    {85, 2236, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 33},	//2237 Plasma::ScrollWidget::styleSheet() const
    {85, 1388, 0, 0, Smoke::mf_const, 309, 34},	//2238 Plasma::ScrollWidget::nativeWidget() const
    {85, 1636, 766, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 35},	//2239 Plasma::ScrollWidget::scrollStateChanged(QAbstractAnimation::State, QAbstractAnimation::State)
    {85, 2379, 653, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 36},	//2240 Plasma::ScrollWidget::viewportGeometryChanged(const QRectF&)
    {85, 1584, 282, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 37},	//2241 Plasma::ScrollWidget::resizeEvent(QGraphicsSceneResizeEvent*)
    {85, 1368, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 38},	//2242 Plasma::ScrollWidget::mouseMoveEvent(QGraphicsSceneMouseEvent*)
    {85, 1370, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 39},	//2243 Plasma::ScrollWidget::mousePressEvent(QGraphicsSceneMouseEvent*)
    {85, 1372, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 40},	//2244 Plasma::ScrollWidget::mouseReleaseEvent(QGraphicsSceneMouseEvent*)
    {85, 1198, 396, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 41},	//2245 Plasma::ScrollWidget::keyPressEvent(QKeyEvent*)
    {85, 2389, 398, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 42},	//2246 Plasma::ScrollWidget::wheelEvent(QGraphicsSceneWheelEvent*)
    {85, 954, 272, 2, Smoke::mf_protected|Smoke::mf_virtual, 386, 43},	//2247 Plasma::ScrollWidget::eventFilter(QObject*, QEvent*)
    {85, 998, 280, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 44},	//2248 Plasma::ScrollWidget::focusInEvent(QFocusEvent*)
    {85, 2198, 287, 2, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 291, 45},	//2249 Plasma::ScrollWidget::sizeHint(Qt::SizeHint, const QSizeF&) const
    {85, 1621, 275, 2, Smoke::mf_protected|Smoke::mf_virtual, 386, 46},	//2250 Plasma::ScrollWidget::sceneEventFilter(QGraphicsItem*, QEvent*)
    {85, 2304, 1, 1, Smoke::mf_static, 293, 47},	//2251 Plasma::ScrollWidget::tr(const char*)
    {85, 2308, 1, 1, Smoke::mf_static, 293, 48},	//2252 Plasma::ScrollWidget::trUtf8(const char*)
    {85, 426, 0, 0, Smoke::mf_ctor, 146, 49},	//2253 Plasma::ScrollWidget::ScrollWidget()
    {85, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 50},	//2254 Plasma::ScrollWidget::staticMetaObject() const
    {85, 2460, 0, 0, Smoke::mf_dtor, 0, 51 },	//2255 Plasma::ScrollWidget::~ScrollWidget()
    {86, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//2256 Plasma::Separator::metaObject() const
    {86, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//2257 Plasma::Separator::qt_metacast(const char*)
    {86, 2304, 43, 2, Smoke::mf_static, 293, 3},	//2258 Plasma::Separator::tr(const char*, const char*)
    {86, 2308, 43, 2, Smoke::mf_static, 293, 4},	//2259 Plasma::Separator::trUtf8(const char*, const char*)
    {86, 2304, 46, 3, Smoke::mf_static, 293, 5},	//2260 Plasma::Separator::tr(const char*, const char*, int)
    {86, 2308, 46, 3, Smoke::mf_static, 293, 6},	//2261 Plasma::Separator::trUtf8(const char*, const char*, int)
    {86, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//2262 Plasma::Separator::qt_metacall(QMetaObject::Call, int, void**)
    {86, 429, 769, 2, Smoke::mf_ctor, 147, 8},	//2263 Plasma::Separator::Separator(QGraphicsItem*, QFlags<Qt::WindowType>)
    {86, 1935, 642, 1, Smoke::mf_property, 0, 9},	//2264 Plasma::Separator::setOrientation(Qt::Orientation)
    {86, 1412, 0, 0, Smoke::mf_property, 358, 10},	//2265 Plasma::Separator::orientation()
    {86, 1420, 216, 3, Smoke::mf_protected|Smoke::mf_virtual, 0, 11},	//2266 Plasma::Separator::paint(QPainter*, const QStyleOptionGraphicsItem*, QWidget*)
    {86, 2198, 287, 2, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 291, 12},	//2267 Plasma::Separator::sizeHint(Qt::SizeHint, const QSizeF&) const
    {86, 2304, 1, 1, Smoke::mf_static, 293, 13},	//2268 Plasma::Separator::tr(const char*)
    {86, 2308, 1, 1, Smoke::mf_static, 293, 14},	//2269 Plasma::Separator::trUtf8(const char*)
    {86, 429, 0, 0, Smoke::mf_ctor, 147, 15},	//2270 Plasma::Separator::Separator()
    {86, 429, 170, 1, Smoke::mf_ctor, 147, 16},	//2271 Plasma::Separator::Separator(QGraphicsItem*)
    {86, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 17},	//2272 Plasma::Separator::staticMetaObject() const
    {86, 2461, 0, 0, Smoke::mf_dtor, 0, 18 },	//2273 Plasma::Separator::~Separator()
    {87, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//2274 Plasma::Service::metaObject() const
    {87, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//2275 Plasma::Service::qt_metacast(const char*)
    {87, 2304, 43, 2, Smoke::mf_static, 293, 3},	//2276 Plasma::Service::tr(const char*, const char*)
    {87, 2308, 43, 2, Smoke::mf_static, 293, 4},	//2277 Plasma::Service::trUtf8(const char*, const char*)
    {87, 2304, 46, 3, Smoke::mf_static, 293, 5},	//2278 Plasma::Service::tr(const char*, const char*, int)
    {87, 2308, 46, 3, Smoke::mf_static, 293, 6},	//2279 Plasma::Service::trUtf8(const char*, const char*, int)
    {87, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//2280 Plasma::Service::qt_metacall(QMetaObject::Call, int, void**)
    {87, 1281, 772, 3, Smoke::mf_static, 148, 8},	//2281 Plasma::Service::load(const QString&, const QList<QVariant>&, QObject*)
    {87, 1281, 149, 2, Smoke::mf_static, 148, 9},	//2282 Plasma::Service::load(const QString&, QObject*)
    {87, 552, 116, 2, Smoke::mf_static, 148, 10},	//2283 Plasma::Service::access(const KUrl&, QObject*)
    {87, 1781, 89, 1, Smoke::mf_property, 0, 11},	//2284 Plasma::Service::setDestination(const QString&)
    {87, 851, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 12},	//2285 Plasma::Service::destination() const
    {87, 1402, 0, 0, Smoke::mf_const|Smoke::mf_property, 294, 13},	//2286 Plasma::Service::operationNames() const
    {87, 1400, 89, 1, 0, 8, 14},	//2287 Plasma::Service::operationDescription(const QString&)
    {87, 2218, 776, 2, 0, 150, 15},	//2288 Plasma::Service::startOperationCall(const KConfigGroup&, QObject*)
    {87, 1140, 89, 1, Smoke::mf_const, 386, 16},	//2289 Plasma::Service::isOperationEnabled(const QString&) const
    {87, 1386, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 17},	//2290 Plasma::Service::name() const
    {87, 679, 779, 2, 0, 0, 18},	//2291 Plasma::Service::associateWidget(QWidget*, const QString&)
    {87, 865, 57, 1, 0, 0, 19},	//2292 Plasma::Service::disassociateWidget(QWidget*)
    {87, 679, 782, 2, 0, 0, 20},	//2293 Plasma::Service::associateWidget(QGraphicsWidget*, const QString&)
    {87, 865, 125, 1, 0, 0, 21},	//2294 Plasma::Service::disassociateWidget(QGraphicsWidget*)
    {87, 677, 785, 2, 0, 0, 22},	//2295 Plasma::Service::associateItem(QGraphicsObject*, const QString&)
    {87, 863, 788, 1, 0, 0, 23},	//2296 Plasma::Service::disassociateItem(QGraphicsObject*)
    {87, 1442, 111, 1, 0, 262, 24},	//2297 Plasma::Service::parametersFromDescription(const KConfigGroup&)
    {87, 985, 790, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 25},	//2298 Plasma::Service::finished(Plasma::ServiceJob*)
    {87, 1403, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 26},	//2299 Plasma::Service::operationsChanged()
    {87, 1655, 792, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 27},	//2300 Plasma::Service::serviceReady(Plasma::Service*)
    {87, 432, 97, 1, Smoke::mf_ctor|Smoke::mf_protected, 148, 28},	//2301 Plasma::Service::Service(QObject*)
    {87, 432, 70, 2, Smoke::mf_ctor|Smoke::mf_protected, 148, 29},	//2302 Plasma::Service::Service(QObject*, const QList<QVariant>&)
    {87, 810, 794, 2, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_purevirtual, 150, 30},	//2303 Plasma::Service::createJob(const QString&, QMap<QString,QVariant>&) [pure virtual]
    {87, 1504, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 31},	//2304 Plasma::Service::registerOperationsScheme()
    {87, 1933, 797, 1, Smoke::mf_protected, 0, 32},	//2305 Plasma::Service::setOperationsScheme(QIODevice*)
    {87, 1921, 89, 1, Smoke::mf_protected, 0, 33},	//2306 Plasma::Service::setName(const QString&)
    {87, 1931, 197, 2, Smoke::mf_protected, 0, 34},	//2307 Plasma::Service::setOperationEnabled(const QString&, bool)
    {87, 2304, 1, 1, Smoke::mf_static, 293, 35},	//2308 Plasma::Service::tr(const char*)
    {87, 2308, 1, 1, Smoke::mf_static, 293, 36},	//2309 Plasma::Service::trUtf8(const char*)
    {87, 1281, 113, 2, Smoke::mf_static, 148, 37},	//2310 Plasma::Service::load(const QString&, const QList<QVariant>&)
    {87, 1281, 89, 1, Smoke::mf_static, 148, 38},	//2311 Plasma::Service::load(const QString&)
    {87, 552, 119, 1, Smoke::mf_static, 148, 39},	//2312 Plasma::Service::access(const KUrl&)
    {87, 2218, 111, 1, 0, 150, 40},	//2313 Plasma::Service::startOperationCall(const KConfigGroup&)
    {87, 432, 0, 0, Smoke::mf_ctor|Smoke::mf_protected, 148, 41},	//2314 Plasma::Service::Service()
    {87, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 42},	//2315 Plasma::Service::staticMetaObject() const
    {87, 2462, 0, 0, Smoke::mf_dtor, 0, 43 },	//2316 Plasma::Service::~Service()
    {88, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//2317 Plasma::ServiceAccessJob::metaObject() const
    {88, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//2318 Plasma::ServiceAccessJob::qt_metacast(const char*)
    {88, 2304, 43, 2, Smoke::mf_static, 293, 3},	//2319 Plasma::ServiceAccessJob::tr(const char*, const char*)
    {88, 2308, 43, 2, Smoke::mf_static, 293, 4},	//2320 Plasma::ServiceAccessJob::trUtf8(const char*, const char*)
    {88, 2304, 46, 3, Smoke::mf_static, 293, 5},	//2321 Plasma::ServiceAccessJob::tr(const char*, const char*, int)
    {88, 2308, 46, 3, Smoke::mf_static, 293, 6},	//2322 Plasma::ServiceAccessJob::trUtf8(const char*, const char*, int)
    {88, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//2323 Plasma::ServiceAccessJob::qt_metacall(QMetaObject::Call, int, void**)
    {88, 1647, 0, 0, Smoke::mf_const, 148, 8},	//2324 Plasma::ServiceAccessJob::service() const
    {88, 435, 799, 2, Smoke::mf_ctor|Smoke::mf_protected, 149, 9},	//2325 Plasma::ServiceAccessJob::ServiceAccessJob(KUrl, QObject*)
    {88, 2217, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 10},	//2326 Plasma::ServiceAccessJob::start()
    {88, 2304, 1, 1, Smoke::mf_static, 293, 11},	//2327 Plasma::ServiceAccessJob::tr(const char*)
    {88, 2308, 1, 1, Smoke::mf_static, 293, 12},	//2328 Plasma::ServiceAccessJob::trUtf8(const char*)
    {88, 435, 802, 1, Smoke::mf_ctor|Smoke::mf_protected, 149, 13},	//2329 Plasma::ServiceAccessJob::ServiceAccessJob(KUrl)
    {88, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 14},	//2330 Plasma::ServiceAccessJob::staticMetaObject() const
    {88, 2463, 0, 0, Smoke::mf_dtor, 0, 15 },	//2331 Plasma::ServiceAccessJob::~ServiceAccessJob()
    {90, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//2332 Plasma::SignalPlotter::metaObject() const
    {90, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//2333 Plasma::SignalPlotter::qt_metacast(const char*)
    {90, 2304, 43, 2, Smoke::mf_static, 293, 3},	//2334 Plasma::SignalPlotter::tr(const char*, const char*)
    {90, 2308, 43, 2, Smoke::mf_static, 293, 4},	//2335 Plasma::SignalPlotter::trUtf8(const char*, const char*)
    {90, 2304, 46, 3, Smoke::mf_static, 293, 5},	//2336 Plasma::SignalPlotter::tr(const char*, const char*, int)
    {90, 2308, 46, 3, Smoke::mf_static, 293, 6},	//2337 Plasma::SignalPlotter::trUtf8(const char*, const char*, int)
    {90, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//2338 Plasma::SignalPlotter::qt_metacall(QMetaObject::Call, int, void**)
    {90, 441, 170, 1, Smoke::mf_ctor, 151, 8},	//2339 Plasma::SignalPlotter::SignalPlotter(QGraphicsItem*)
    {90, 609, 581, 1, 0, 0, 9},	//2340 Plasma::SignalPlotter::addPlot(const QColor&)
    {90, 616, 804, 1, 0, 0, 10},	//2341 Plasma::SignalPlotter::addSample(const QList<double>&)
    {90, 1570, 806, 1, 0, 0, 11},	//2342 Plasma::SignalPlotter::reorderPlots(const QList<unsigned int>&)
    {90, 1549, 17, 1, 0, 0, 12},	//2343 Plasma::SignalPlotter::removePlot(unsigned int)
    {90, 1457, 0, 0, 0, 252, 13},	//2344 Plasma::SignalPlotter::plotColors()
    {90, 2094, 89, 1, Smoke::mf_property, 0, 14},	//2345 Plasma::SignalPlotter::setTitle(const QString&)
    {90, 2291, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 15},	//2346 Plasma::SignalPlotter::title() const
    {90, 2106, 89, 1, Smoke::mf_property, 0, 16},	//2347 Plasma::SignalPlotter::setUnit(const QString&)
    {90, 2319, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 17},	//2348 Plasma::SignalPlotter::unit() const
    {90, 1615, 735, 1, 0, 0, 18},	//2349 Plasma::SignalPlotter::scale(double)
    {90, 1617, 0, 0, Smoke::mf_const, 474, 19},	//2350 Plasma::SignalPlotter::scaledBy() const
    {90, 2114, 7, 1, Smoke::mf_property, 0, 20},	//2351 Plasma::SignalPlotter::setUseAutoRange(bool)
    {90, 2351, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 21},	//2352 Plasma::SignalPlotter::useAutoRange() const
    {90, 2134, 808, 2, 0, 0, 22},	//2353 Plasma::SignalPlotter::setVerticalRange(double, double)
    {90, 2372, 0, 0, Smoke::mf_const, 474, 23},	//2354 Plasma::SignalPlotter::verticalMinValue() const
    {90, 2371, 0, 0, Smoke::mf_const, 474, 24},	//2355 Plasma::SignalPlotter::verticalMaxValue() const
    {90, 1849, 17, 1, 0, 0, 25},	//2356 Plasma::SignalPlotter::setHorizontalScale(unsigned int)
    {90, 1066, 0, 0, Smoke::mf_const, 484, 26},	//2357 Plasma::SignalPlotter::horizontalScale() const
    {90, 2023, 7, 1, Smoke::mf_property, 0, 27},	//2358 Plasma::SignalPlotter::setShowVerticalLines(bool)
    {90, 2187, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 28},	//2359 Plasma::SignalPlotter::showVerticalLines() const
    {90, 2128, 581, 1, Smoke::mf_property, 0, 29},	//2360 Plasma::SignalPlotter::setVerticalLinesColor(const QColor&)
    {90, 2368, 0, 0, Smoke::mf_const|Smoke::mf_property, 189, 30},	//2361 Plasma::SignalPlotter::verticalLinesColor() const
    {90, 2130, 17, 1, 0, 0, 31},	//2362 Plasma::SignalPlotter::setVerticalLinesDistance(unsigned int)
    {90, 2369, 0, 0, Smoke::mf_const, 484, 32},	//2363 Plasma::SignalPlotter::verticalLinesDistance() const
    {90, 2132, 7, 1, Smoke::mf_property, 0, 33},	//2364 Plasma::SignalPlotter::setVerticalLinesScroll(bool)
    {90, 2370, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 34},	//2365 Plasma::SignalPlotter::verticalLinesScroll() const
    {90, 2017, 7, 1, Smoke::mf_property, 0, 35},	//2366 Plasma::SignalPlotter::setShowHorizontalLines(bool)
    {90, 2179, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 36},	//2367 Plasma::SignalPlotter::showHorizontalLines() const
    {90, 1845, 581, 1, Smoke::mf_property, 0, 37},	//2368 Plasma::SignalPlotter::setHorizontalLinesColor(const QColor&)
    {90, 1064, 0, 0, Smoke::mf_const|Smoke::mf_property, 189, 38},	//2369 Plasma::SignalPlotter::horizontalLinesColor() const
    {90, 1822, 581, 1, Smoke::mf_property, 0, 39},	//2370 Plasma::SignalPlotter::setFontColor(const QColor&)
    {90, 1008, 0, 0, Smoke::mf_const|Smoke::mf_property, 189, 40},	//2371 Plasma::SignalPlotter::fontColor() const
    {90, 1819, 579, 1, Smoke::mf_property, 0, 41},	//2372 Plasma::SignalPlotter::setFont(const QFont&)
    {90, 1005, 0, 0, Smoke::mf_const|Smoke::mf_property, 211, 42},	//2373 Plasma::SignalPlotter::font() const
    {90, 1847, 17, 1, 0, 0, 43},	//2374 Plasma::SignalPlotter::setHorizontalLinesCount(unsigned int)
    {90, 1065, 0, 0, Smoke::mf_const, 484, 44},	//2375 Plasma::SignalPlotter::horizontalLinesCount() const
    {90, 2019, 7, 1, Smoke::mf_property, 0, 45},	//2376 Plasma::SignalPlotter::setShowLabels(bool)
    {90, 2180, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 46},	//2377 Plasma::SignalPlotter::showLabels() const
    {90, 2021, 7, 1, Smoke::mf_property, 0, 47},	//2378 Plasma::SignalPlotter::setShowTopBar(bool)
    {90, 2186, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 48},	//2379 Plasma::SignalPlotter::showTopBar() const
    {90, 1698, 581, 1, Smoke::mf_property, 0, 49},	//2380 Plasma::SignalPlotter::setBackgroundColor(const QColor&)
    {90, 696, 0, 0, Smoke::mf_const|Smoke::mf_property, 189, 50},	//2381 Plasma::SignalPlotter::backgroundColor() const
    {90, 2058, 89, 1, Smoke::mf_property, 0, 51},	//2382 Plasma::SignalPlotter::setSvgBackground(const QString&)
    {90, 2247, 0, 0, Smoke::mf_property, 293, 52},	//2383 Plasma::SignalPlotter::svgBackground()
    {90, 1220, 17, 1, Smoke::mf_const, 474, 53},	//2384 Plasma::SignalPlotter::lastValue(unsigned int) const
    {90, 1222, 17, 1, Smoke::mf_const, 293, 54},	//2385 Plasma::SignalPlotter::lastValueAsString(unsigned int) const
    {90, 2090, 7, 1, Smoke::mf_property, 0, 55},	//2386 Plasma::SignalPlotter::setThinFrame(bool)
    {90, 2284, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 56},	//2387 Plasma::SignalPlotter::thinFrame() const
    {90, 2039, 7, 1, Smoke::mf_property, 0, 57},	//2388 Plasma::SignalPlotter::setStackPlots(bool)
    {90, 2215, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 58},	//2389 Plasma::SignalPlotter::stackPlots() const
    {90, 1027, 811, 2, 0, 277, 59},	//2390 Plasma::SignalPlotter::getSnapshotImage(unsigned int, unsigned int)
    {90, 1828, 653, 1, Smoke::mf_virtual, 0, 60},	//2391 Plasma::SignalPlotter::setGeometry(const QRectF&)
    {90, 2336, 0, 0, Smoke::mf_protected, 0, 61},	//2392 Plasma::SignalPlotter::updateDataBuffers()
    {90, 706, 0, 0, Smoke::mf_protected, 0, 62},	//2393 Plasma::SignalPlotter::calculateNiceRange()
    {90, 1420, 216, 3, Smoke::mf_protected|Smoke::mf_virtual, 0, 63},	//2394 Plasma::SignalPlotter::paint(QPainter*, const QStyleOptionGraphicsItem*, QWidget*)
    {90, 904, 814, 4, Smoke::mf_protected, 0, 64},	//2395 Plasma::SignalPlotter::drawWidget(QPainter*, unsigned int, unsigned int, int)
    {90, 887, 819, 3, Smoke::mf_protected, 0, 65},	//2396 Plasma::SignalPlotter::drawBackground(QPainter*, int, int)
    {90, 895, 819, 3, Smoke::mf_protected, 0, 66},	//2397 Plasma::SignalPlotter::drawThinFrame(QPainter*, int, int)
    {90, 899, 819, 3, Smoke::mf_protected, 0, 67},	//2398 Plasma::SignalPlotter::drawTopBarFrame(QPainter*, int, int)
    {90, 897, 823, 4, Smoke::mf_protected, 0, 68},	//2399 Plasma::SignalPlotter::drawTopBarContents(QPainter*, int, int, int)
    {90, 901, 823, 4, Smoke::mf_protected, 0, 69},	//2400 Plasma::SignalPlotter::drawVerticalLines(QPainter*, int, int, int)
    {90, 893, 828, 5, Smoke::mf_protected, 0, 70},	//2401 Plasma::SignalPlotter::drawPlots(QPainter*, int, int, int, int)
    {90, 885, 819, 3, Smoke::mf_protected, 0, 71},	//2402 Plasma::SignalPlotter::drawAxisText(QPainter*, int, int)
    {90, 890, 823, 4, Smoke::mf_protected, 0, 72},	//2403 Plasma::SignalPlotter::drawHorizontalLines(QPainter*, int, int, int)
    {90, 2304, 1, 1, Smoke::mf_static, 293, 73},	//2404 Plasma::SignalPlotter::tr(const char*)
    {90, 2308, 1, 1, Smoke::mf_static, 293, 74},	//2405 Plasma::SignalPlotter::trUtf8(const char*)
    {90, 441, 0, 0, Smoke::mf_ctor, 151, 75},	//2406 Plasma::SignalPlotter::SignalPlotter()
    {90, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 76},	//2407 Plasma::SignalPlotter::staticMetaObject() const
    {90, 2464, 0, 0, Smoke::mf_dtor, 0, 77 },	//2408 Plasma::SignalPlotter::~SignalPlotter()
    {91, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//2409 Plasma::Slider::metaObject() const
    {91, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//2410 Plasma::Slider::qt_metacast(const char*)
    {91, 2304, 43, 2, Smoke::mf_static, 293, 3},	//2411 Plasma::Slider::tr(const char*, const char*)
    {91, 2308, 43, 2, Smoke::mf_static, 293, 4},	//2412 Plasma::Slider::trUtf8(const char*, const char*)
    {91, 2304, 46, 3, Smoke::mf_static, 293, 5},	//2413 Plasma::Slider::tr(const char*, const char*, int)
    {91, 2308, 46, 3, Smoke::mf_static, 293, 6},	//2414 Plasma::Slider::trUtf8(const char*, const char*, int)
    {91, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//2415 Plasma::Slider::qt_metacall(QMetaObject::Call, int, void**)
    {91, 447, 125, 1, Smoke::mf_ctor, 152, 8},	//2416 Plasma::Slider::Slider(QGraphicsWidget*)
    {91, 1346, 0, 0, Smoke::mf_const|Smoke::mf_property, 477, 9},	//2417 Plasma::Slider::maximum() const
    {91, 1361, 0, 0, Smoke::mf_const|Smoke::mf_property, 477, 10},	//2418 Plasma::Slider::minimum() const
    {91, 2360, 0, 0, Smoke::mf_const|Smoke::mf_property, 477, 11},	//2419 Plasma::Slider::value() const
    {91, 1412, 0, 0, Smoke::mf_const|Smoke::mf_property, 358, 12},	//2420 Plasma::Slider::orientation() const
    {91, 2048, 89, 1, Smoke::mf_property, 0, 13},	//2421 Plasma::Slider::setStyleSheet(const QString&)
    {91, 2236, 0, 0, Smoke::mf_property, 293, 14},	//2422 Plasma::Slider::styleSheet()
    {91, 1388, 0, 0, Smoke::mf_const, 292, 15},	//2423 Plasma::Slider::nativeWidget() const
    {91, 1420, 216, 3, Smoke::mf_protected|Smoke::mf_virtual, 0, 16},	//2424 Plasma::Slider::paint(QPainter*, const QStyleOptionGraphicsItem*, QWidget*)
    {91, 2389, 398, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 17},	//2425 Plasma::Slider::wheelEvent(QGraphicsSceneWheelEvent*)
    {91, 1902, 129, 1, Smoke::mf_property|Smoke::mf_slot, 0, 18},	//2426 Plasma::Slider::setMaximum(int)
    {91, 1910, 129, 1, Smoke::mf_property|Smoke::mf_slot, 0, 19},	//2427 Plasma::Slider::setMinimum(int)
    {91, 1978, 370, 2, Smoke::mf_slot, 0, 20},	//2428 Plasma::Slider::setRange(int, int)
    {91, 2124, 129, 1, Smoke::mf_property|Smoke::mf_slot, 0, 21},	//2429 Plasma::Slider::setValue(int)
    {91, 1935, 642, 1, Smoke::mf_property|Smoke::mf_slot, 0, 22},	//2430 Plasma::Slider::setOrientation(Qt::Orientation)
    {91, 2204, 129, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 23},	//2431 Plasma::Slider::sliderMoved(int)
    {91, 2361, 129, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 24},	//2432 Plasma::Slider::valueChanged(int)
    {91, 2304, 1, 1, Smoke::mf_static, 293, 25},	//2433 Plasma::Slider::tr(const char*)
    {91, 2308, 1, 1, Smoke::mf_static, 293, 26},	//2434 Plasma::Slider::trUtf8(const char*)
    {91, 447, 0, 0, Smoke::mf_ctor, 152, 27},	//2435 Plasma::Slider::Slider()
    {91, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 28},	//2436 Plasma::Slider::staticMetaObject() const
    {91, 2465, 0, 0, Smoke::mf_dtor, 0, 29 },	//2437 Plasma::Slider::~Slider()
    {92, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//2438 Plasma::SpinBox::metaObject() const
    {92, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//2439 Plasma::SpinBox::qt_metacast(const char*)
    {92, 2304, 43, 2, Smoke::mf_static, 293, 3},	//2440 Plasma::SpinBox::tr(const char*, const char*)
    {92, 2308, 43, 2, Smoke::mf_static, 293, 4},	//2441 Plasma::SpinBox::trUtf8(const char*, const char*)
    {92, 2304, 46, 3, Smoke::mf_static, 293, 5},	//2442 Plasma::SpinBox::tr(const char*, const char*, int)
    {92, 2308, 46, 3, Smoke::mf_static, 293, 6},	//2443 Plasma::SpinBox::trUtf8(const char*, const char*, int)
    {92, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//2444 Plasma::SpinBox::qt_metacall(QMetaObject::Call, int, void**)
    {92, 454, 125, 1, Smoke::mf_ctor, 153, 8},	//2445 Plasma::SpinBox::SpinBox(QGraphicsWidget*)
    {92, 1346, 0, 0, Smoke::mf_const|Smoke::mf_property, 477, 9},	//2446 Plasma::SpinBox::maximum() const
    {92, 1361, 0, 0, Smoke::mf_const|Smoke::mf_property, 477, 10},	//2447 Plasma::SpinBox::minimum() const
    {92, 2360, 0, 0, Smoke::mf_const|Smoke::mf_property, 477, 11},	//2448 Plasma::SpinBox::value() const
    {92, 2048, 89, 1, Smoke::mf_property, 0, 12},	//2449 Plasma::SpinBox::setStyleSheet(const QString&)
    {92, 2236, 0, 0, Smoke::mf_property, 293, 13},	//2450 Plasma::SpinBox::styleSheet()
    {92, 1388, 0, 0, Smoke::mf_const, 12, 14},	//2451 Plasma::SpinBox::nativeWidget() const
    {92, 710, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 15},	//2452 Plasma::SpinBox::changeEvent(QEvent*)
    {92, 1068, 290, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 16},	//2453 Plasma::SpinBox::hoverEnterEvent(QGraphicsSceneHoverEvent*)
    {92, 1070, 290, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 17},	//2454 Plasma::SpinBox::hoverLeaveEvent(QGraphicsSceneHoverEvent*)
    {92, 1584, 282, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 18},	//2455 Plasma::SpinBox::resizeEvent(QGraphicsSceneResizeEvent*)
    {92, 1420, 216, 3, Smoke::mf_protected|Smoke::mf_virtual, 0, 19},	//2456 Plasma::SpinBox::paint(QPainter*, const QStyleOptionGraphicsItem*, QWidget*)
    {92, 1370, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 20},	//2457 Plasma::SpinBox::mousePressEvent(QGraphicsSceneMouseEvent*)
    {92, 1002, 280, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 21},	//2458 Plasma::SpinBox::focusOutEvent(QFocusEvent*)
    {92, 1902, 129, 1, Smoke::mf_slot, 0, 22},	//2459 Plasma::SpinBox::setMaximum(int)
    {92, 1910, 129, 1, Smoke::mf_property|Smoke::mf_slot, 0, 23},	//2460 Plasma::SpinBox::setMinimum(int)
    {92, 1978, 370, 2, Smoke::mf_slot, 0, 24},	//2461 Plasma::SpinBox::setRange(int, int)
    {92, 2124, 129, 1, Smoke::mf_property|Smoke::mf_slot, 0, 25},	//2462 Plasma::SpinBox::setValue(int)
    {92, 2204, 129, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 26},	//2463 Plasma::SpinBox::sliderMoved(int)
    {92, 2361, 129, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 27},	//2464 Plasma::SpinBox::valueChanged(int)
    {92, 910, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 28},	//2465 Plasma::SpinBox::editingFinished()
    {92, 2304, 1, 1, Smoke::mf_static, 293, 29},	//2466 Plasma::SpinBox::tr(const char*)
    {92, 2308, 1, 1, Smoke::mf_static, 293, 30},	//2467 Plasma::SpinBox::trUtf8(const char*)
    {92, 454, 0, 0, Smoke::mf_ctor, 153, 31},	//2468 Plasma::SpinBox::SpinBox()
    {92, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 32},	//2469 Plasma::SpinBox::staticMetaObject() const
    {92, 2466, 0, 0, Smoke::mf_dtor, 0, 33 },	//2470 Plasma::SpinBox::~SpinBox()
    {93, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//2471 Plasma::Svg::metaObject() const
    {93, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//2472 Plasma::Svg::qt_metacast(const char*)
    {93, 2304, 43, 2, Smoke::mf_static, 293, 3},	//2473 Plasma::Svg::tr(const char*, const char*)
    {93, 2308, 43, 2, Smoke::mf_static, 293, 4},	//2474 Plasma::Svg::trUtf8(const char*, const char*)
    {93, 2304, 46, 3, Smoke::mf_static, 293, 5},	//2475 Plasma::Svg::tr(const char*, const char*, int)
    {93, 2308, 46, 3, Smoke::mf_static, 293, 6},	//2476 Plasma::Svg::trUtf8(const char*, const char*, int)
    {93, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//2477 Plasma::Svg::qt_metacall(QMetaObject::Call, int, void**)
    {93, 469, 97, 1, Smoke::mf_ctor, 154, 8},	//2478 Plasma::Svg::Svg(QObject*)
    {93, 1454, 89, 1, 0, 277, 9},	//2479 Plasma::Svg::pixmap(const QString&)
    {93, 1420, 834, 3, 0, 0, 10},	//2480 Plasma::Svg::paint(QPainter*, const QPointF&, const QString&)
    {93, 1420, 838, 4, 0, 0, 11},	//2481 Plasma::Svg::paint(QPainter*, int, int, const QString&)
    {93, 1420, 843, 3, 0, 0, 12},	//2482 Plasma::Svg::paint(QPainter*, const QRectF&, const QString&)
    {93, 1420, 847, 6, 0, 0, 13},	//2483 Plasma::Svg::paint(QPainter*, int, int, int, int, const QString&)
    {93, 2194, 0, 0, Smoke::mf_const|Smoke::mf_property, 290, 14},	//2484 Plasma::Svg::size() const
    {93, 1580, 808, 2, 0, 0, 15},	//2485 Plasma::Svg::resize(double, double)
    {93, 1580, 603, 1, 0, 0, 16},	//2486 Plasma::Svg::resize(const QSizeF&)
    {93, 1580, 0, 0, 0, 0, 17},	//2487 Plasma::Svg::resize()
    {93, 930, 89, 1, Smoke::mf_const, 290, 18},	//2488 Plasma::Svg::elementSize(const QString&) const
    {93, 928, 89, 1, Smoke::mf_const, 283, 19},	//2489 Plasma::Svg::elementRect(const QString&) const
    {93, 1041, 89, 1, Smoke::mf_const, 386, 20},	//2490 Plasma::Svg::hasElement(const QString&) const
    {93, 923, 555, 1, Smoke::mf_const, 293, 21},	//2491 Plasma::Svg::elementAtPoint(const QPoint&) const
    {93, 1164, 0, 0, Smoke::mf_const, 386, 22},	//2492 Plasma::Svg::isValid() const
    {93, 1737, 7, 1, Smoke::mf_property, 0, 23},	//2493 Plasma::Svg::setContainsMultipleImages(bool)
    {93, 782, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 24},	//2494 Plasma::Svg::containsMultipleImages() const
    {93, 1869, 89, 1, Smoke::mf_property, 0, 25},	//2495 Plasma::Svg::setImagePath(const QString&)
    {93, 1080, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 26},	//2496 Plasma::Svg::imagePath() const
    {93, 2120, 7, 1, Smoke::mf_property, 0, 27},	//2497 Plasma::Svg::setUsingRenderingCache(bool)
    {93, 1163, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 28},	//2498 Plasma::Svg::isUsingRenderingCache() const
    {93, 2086, 854, 1, 0, 0, 29},	//2499 Plasma::Svg::setTheme(Plasma::Theme*)
    {93, 2281, 0, 0, Smoke::mf_const, 159, 30},	//2500 Plasma::Svg::theme() const
    {93, 1572, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 31},	//2501 Plasma::Svg::repaintNeeded()
    {93, 2195, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 32},	//2502 Plasma::Svg::sizeChanged()
    {93, 2304, 1, 1, Smoke::mf_static, 293, 33},	//2503 Plasma::Svg::tr(const char*)
    {93, 2308, 1, 1, Smoke::mf_static, 293, 34},	//2504 Plasma::Svg::trUtf8(const char*)
    {93, 469, 0, 0, Smoke::mf_ctor, 154, 35},	//2505 Plasma::Svg::Svg()
    {93, 1454, 0, 0, 0, 277, 36},	//2506 Plasma::Svg::pixmap()
    {93, 1420, 616, 2, 0, 0, 37},	//2507 Plasma::Svg::paint(QPainter*, const QPointF&)
    {93, 1420, 819, 3, 0, 0, 38},	//2508 Plasma::Svg::paint(QPainter*, int, int)
    {93, 1420, 619, 2, 0, 0, 39},	//2509 Plasma::Svg::paint(QPainter*, const QRectF&)
    {93, 1420, 828, 5, 0, 0, 40},	//2510 Plasma::Svg::paint(QPainter*, int, int, int, int)
    {93, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 41},	//2511 Plasma::Svg::staticMetaObject() const
    {93, 2468, 0, 0, Smoke::mf_dtor, 0, 42 },	//2512 Plasma::Svg::~Svg()
    {94, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//2513 Plasma::SvgWidget::metaObject() const
    {94, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//2514 Plasma::SvgWidget::qt_metacast(const char*)
    {94, 2304, 43, 2, Smoke::mf_static, 293, 3},	//2515 Plasma::SvgWidget::tr(const char*, const char*)
    {94, 2308, 43, 2, Smoke::mf_static, 293, 4},	//2516 Plasma::SvgWidget::trUtf8(const char*, const char*)
    {94, 2304, 46, 3, Smoke::mf_static, 293, 5},	//2517 Plasma::SvgWidget::tr(const char*, const char*, int)
    {94, 2308, 46, 3, Smoke::mf_static, 293, 6},	//2518 Plasma::SvgWidget::trUtf8(const char*, const char*, int)
    {94, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//2519 Plasma::SvgWidget::qt_metacall(QMetaObject::Call, int, void**)
    {94, 471, 769, 2, Smoke::mf_ctor, 155, 8},	//2520 Plasma::SvgWidget::SvgWidget(QGraphicsItem*, QFlags<Qt::WindowType>)
    {94, 471, 856, 4, Smoke::mf_ctor, 155, 9},	//2521 Plasma::SvgWidget::SvgWidget(Plasma::Svg*, const QString&, QGraphicsItem*, QFlags<Qt::WindowType>)
    {94, 2054, 861, 1, 0, 0, 10},	//2522 Plasma::SvgWidget::setSvg(Plasma::Svg*)
    {94, 2246, 0, 0, Smoke::mf_const, 154, 11},	//2523 Plasma::SvgWidget::svg() const
    {94, 1798, 89, 1, Smoke::mf_property, 0, 12},	//2524 Plasma::SvgWidget::setElementID(const QString&)
    {94, 927, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 13},	//2525 Plasma::SvgWidget::elementID() const
    {94, 1372, 278, 1, Smoke::mf_virtual, 0, 14},	//2526 Plasma::SvgWidget::mouseReleaseEvent(QGraphicsSceneMouseEvent*)
    {94, 726, 863, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 15},	//2527 Plasma::SvgWidget::clicked(Qt::MouseButton)
    {94, 1420, 216, 3, Smoke::mf_protected|Smoke::mf_virtual, 0, 16},	//2528 Plasma::SvgWidget::paint(QPainter*, const QStyleOptionGraphicsItem*, QWidget*)
    {94, 2198, 287, 2, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 291, 17},	//2529 Plasma::SvgWidget::sizeHint(Qt::SizeHint, const QSizeF&) const
    {94, 1370, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 18},	//2530 Plasma::SvgWidget::mousePressEvent(QGraphicsSceneMouseEvent*)
    {94, 2304, 1, 1, Smoke::mf_static, 293, 19},	//2531 Plasma::SvgWidget::tr(const char*)
    {94, 2308, 1, 1, Smoke::mf_static, 293, 20},	//2532 Plasma::SvgWidget::trUtf8(const char*)
    {94, 471, 0, 0, Smoke::mf_ctor, 155, 21},	//2533 Plasma::SvgWidget::SvgWidget()
    {94, 471, 170, 1, Smoke::mf_ctor, 155, 22},	//2534 Plasma::SvgWidget::SvgWidget(QGraphicsItem*)
    {94, 471, 861, 1, Smoke::mf_ctor, 155, 23},	//2535 Plasma::SvgWidget::SvgWidget(Plasma::Svg*)
    {94, 471, 865, 2, Smoke::mf_ctor, 155, 24},	//2536 Plasma::SvgWidget::SvgWidget(Plasma::Svg*, const QString&)
    {94, 471, 868, 3, Smoke::mf_ctor, 155, 25},	//2537 Plasma::SvgWidget::SvgWidget(Plasma::Svg*, const QString&, QGraphicsItem*)
    {94, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 26},	//2538 Plasma::SvgWidget::staticMetaObject() const
    {94, 2469, 0, 0, Smoke::mf_dtor, 0, 27 },	//2539 Plasma::SvgWidget::~SvgWidget()
    {95, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//2540 Plasma::TabBar::metaObject() const
    {95, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//2541 Plasma::TabBar::qt_metacast(const char*)
    {95, 2304, 43, 2, Smoke::mf_static, 293, 3},	//2542 Plasma::TabBar::tr(const char*, const char*)
    {95, 2308, 43, 2, Smoke::mf_static, 293, 4},	//2543 Plasma::TabBar::trUtf8(const char*, const char*)
    {95, 2304, 46, 3, Smoke::mf_static, 293, 5},	//2544 Plasma::TabBar::tr(const char*, const char*, int)
    {95, 2308, 46, 3, Smoke::mf_static, 293, 6},	//2545 Plasma::TabBar::trUtf8(const char*, const char*, int)
    {95, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//2546 Plasma::TabBar::qt_metacall(QMetaObject::Call, int, void**)
    {95, 477, 125, 1, Smoke::mf_ctor, 156, 8},	//2547 Plasma::TabBar::TabBar(QGraphicsWidget*)
    {95, 1107, 872, 4, 0, 477, 9},	//2548 Plasma::TabBar::insertTab(int, const QIcon&, const QString&, QGraphicsLayoutItem*)
    {95, 1107, 877, 3, 0, 477, 10},	//2549 Plasma::TabBar::insertTab(int, const QString&, QGraphicsLayoutItem*)
    {95, 628, 881, 3, 0, 477, 11},	//2550 Plasma::TabBar::addTab(const QIcon&, const QString&, QGraphicsLayoutItem*)
    {95, 628, 885, 2, 0, 477, 12},	//2551 Plasma::TabBar::addTab(const QString&, QGraphicsLayoutItem*)
    {95, 1553, 129, 1, 0, 0, 13},	//2552 Plasma::TabBar::removeTab(int)
    {95, 2262, 129, 1, 0, 218, 14},	//2553 Plasma::TabBar::takeTab(int)
    {95, 2255, 129, 1, 0, 218, 15},	//2554 Plasma::TabBar::tabAt(int)
    {95, 823, 0, 0, Smoke::mf_const|Smoke::mf_property, 477, 16},	//2555 Plasma::TabBar::currentIndex() const
    {95, 799, 0, 0, Smoke::mf_const|Smoke::mf_property, 477, 17},	//2556 Plasma::TabBar::count() const
    {95, 2068, 665, 2, 0, 0, 18},	//2557 Plasma::TabBar::setTabText(int, const QString&)
    {95, 2259, 129, 1, Smoke::mf_const, 293, 19},	//2558 Plasma::TabBar::tabText(int) const
    {95, 2066, 888, 2, 0, 0, 20},	//2559 Plasma::TabBar::setTabIcon(int, const QIcon&)
    {95, 2257, 129, 1, Smoke::mf_const, 236, 21},	//2560 Plasma::TabBar::tabIcon(int) const
    {95, 2062, 7, 1, Smoke::mf_property, 0, 22},	//2561 Plasma::TabBar::setTabBarShown(bool)
    {95, 1156, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 23},	//2562 Plasma::TabBar::isTabBarShown() const
    {95, 2048, 89, 1, Smoke::mf_property, 0, 24},	//2563 Plasma::TabBar::setStyleSheet(const QString&)
    {95, 2236, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 25},	//2564 Plasma::TabBar::styleSheet() const
    {95, 2064, 891, 2, 0, 0, 26},	//2565 Plasma::TabBar::setTabHighlighted(int, bool)
    {95, 1157, 129, 1, Smoke::mf_const, 386, 27},	//2566 Plasma::TabBar::isTabHighlighted(int) const
    {95, 1388, 0, 0, Smoke::mf_const, 23, 28},	//2567 Plasma::TabBar::nativeWidget() const
    {95, 1817, 125, 1, 0, 0, 29},	//2568 Plasma::TabBar::setFirstPositionWidget(QGraphicsWidget*)
    {95, 987, 0, 0, Smoke::mf_const, 229, 30},	//2569 Plasma::TabBar::firstPositionWidget() const
    {95, 1892, 125, 1, 0, 0, 31},	//2570 Plasma::TabBar::setLastPositionWidget(QGraphicsWidget*)
    {95, 1218, 0, 0, Smoke::mf_const, 229, 32},	//2571 Plasma::TabBar::lastPositionWidget() const
    {95, 1755, 129, 1, Smoke::mf_property|Smoke::mf_slot, 0, 33},	//2572 Plasma::TabBar::setCurrentIndex(int)
    {95, 821, 129, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 34},	//2573 Plasma::TabBar::currentChanged(int)
    {95, 2389, 398, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 35},	//2574 Plasma::TabBar::wheelEvent(QGraphicsSceneWheelEvent*)
    {95, 1584, 282, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 36},	//2575 Plasma::TabBar::resizeEvent(QGraphicsSceneResizeEvent*)
    {95, 710, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 37},	//2576 Plasma::TabBar::changeEvent(QEvent*)
    {95, 2304, 1, 1, Smoke::mf_static, 293, 38},	//2577 Plasma::TabBar::tr(const char*)
    {95, 2308, 1, 1, Smoke::mf_static, 293, 39},	//2578 Plasma::TabBar::trUtf8(const char*)
    {95, 477, 0, 0, Smoke::mf_ctor, 156, 40},	//2579 Plasma::TabBar::TabBar()
    {95, 1107, 894, 3, 0, 477, 41},	//2580 Plasma::TabBar::insertTab(int, const QIcon&, const QString&)
    {95, 1107, 665, 2, 0, 477, 42},	//2581 Plasma::TabBar::insertTab(int, const QString&)
    {95, 628, 650, 2, 0, 477, 43},	//2582 Plasma::TabBar::addTab(const QIcon&, const QString&)
    {95, 628, 89, 1, 0, 477, 44},	//2583 Plasma::TabBar::addTab(const QString&)
    {95, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 45},	//2584 Plasma::TabBar::staticMetaObject() const
    {95, 2470, 0, 0, Smoke::mf_dtor, 0, 46 },	//2585 Plasma::TabBar::~TabBar()
    {96, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//2586 Plasma::TextBrowser::metaObject() const
    {96, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//2587 Plasma::TextBrowser::qt_metacast(const char*)
    {96, 2304, 43, 2, Smoke::mf_static, 293, 3},	//2588 Plasma::TextBrowser::tr(const char*, const char*)
    {96, 2308, 43, 2, Smoke::mf_static, 293, 4},	//2589 Plasma::TextBrowser::trUtf8(const char*, const char*)
    {96, 2304, 46, 3, Smoke::mf_static, 293, 5},	//2590 Plasma::TextBrowser::tr(const char*, const char*, int)
    {96, 2308, 46, 3, Smoke::mf_static, 293, 6},	//2591 Plasma::TextBrowser::trUtf8(const char*, const char*, int)
    {96, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//2592 Plasma::TextBrowser::qt_metacall(QMetaObject::Call, int, void**)
    {96, 479, 125, 1, Smoke::mf_ctor, 157, 8},	//2593 Plasma::TextBrowser::TextBrowser(QGraphicsWidget*)
    {96, 2080, 89, 1, Smoke::mf_property, 0, 9},	//2594 Plasma::TextBrowser::setText(const QString&)
    {96, 2274, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 10},	//2595 Plasma::TextBrowser::text() const
    {96, 1851, 898, 1, 0, 0, 11},	//2596 Plasma::TextBrowser::setHorizontalScrollBarPolicy(Qt::ScrollBarPolicy)
    {96, 2136, 898, 1, 0, 0, 12},	//2597 Plasma::TextBrowser::setVerticalScrollBarPolicy(Qt::ScrollBarPolicy)
    {96, 2048, 89, 1, Smoke::mf_property, 0, 13},	//2598 Plasma::TextBrowser::setStyleSheet(const QString&)
    {96, 2236, 0, 0, Smoke::mf_property, 293, 14},	//2599 Plasma::TextBrowser::styleSheet()
    {96, 1388, 0, 0, Smoke::mf_const, 24, 15},	//2600 Plasma::TextBrowser::nativeWidget() const
    {96, 662, 89, 1, Smoke::mf_slot, 0, 16},	//2601 Plasma::TextBrowser::append(const QString&)
    {96, 841, 489, 2, Smoke::mf_slot, 0, 17},	//2602 Plasma::TextBrowser::dataUpdated(const QString&, const Plasma::DataEngine::Data&)
    {96, 2276, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 18},	//2603 Plasma::TextBrowser::textChanged()
    {96, 1584, 282, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 19},	//2604 Plasma::TextBrowser::resizeEvent(QGraphicsSceneResizeEvent*)
    {96, 2389, 398, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 20},	//2605 Plasma::TextBrowser::wheelEvent(QGraphicsSceneWheelEvent*)
    {96, 710, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 21},	//2606 Plasma::TextBrowser::changeEvent(QEvent*)
    {96, 794, 394, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 22},	//2607 Plasma::TextBrowser::contextMenuEvent(QGraphicsSceneContextMenuEvent*)
    {96, 2304, 1, 1, Smoke::mf_static, 293, 23},	//2608 Plasma::TextBrowser::tr(const char*)
    {96, 2308, 1, 1, Smoke::mf_static, 293, 24},	//2609 Plasma::TextBrowser::trUtf8(const char*)
    {96, 479, 0, 0, Smoke::mf_ctor, 157, 25},	//2610 Plasma::TextBrowser::TextBrowser()
    {96, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 26},	//2611 Plasma::TextBrowser::staticMetaObject() const
    {96, 2471, 0, 0, Smoke::mf_dtor, 0, 27 },	//2612 Plasma::TextBrowser::~TextBrowser()
    {97, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//2613 Plasma::TextEdit::metaObject() const
    {97, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//2614 Plasma::TextEdit::qt_metacast(const char*)
    {97, 2304, 43, 2, Smoke::mf_static, 293, 3},	//2615 Plasma::TextEdit::tr(const char*, const char*)
    {97, 2308, 43, 2, Smoke::mf_static, 293, 4},	//2616 Plasma::TextEdit::trUtf8(const char*, const char*)
    {97, 2304, 46, 3, Smoke::mf_static, 293, 5},	//2617 Plasma::TextEdit::tr(const char*, const char*, int)
    {97, 2308, 46, 3, Smoke::mf_static, 293, 6},	//2618 Plasma::TextEdit::trUtf8(const char*, const char*, int)
    {97, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//2619 Plasma::TextEdit::qt_metacall(QMetaObject::Call, int, void**)
    {97, 482, 125, 1, Smoke::mf_ctor, 158, 8},	//2620 Plasma::TextEdit::TextEdit(QGraphicsWidget*)
    {97, 2080, 89, 1, Smoke::mf_property, 0, 9},	//2621 Plasma::TextEdit::setText(const QString&)
    {97, 2274, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 10},	//2622 Plasma::TextEdit::text() const
    {97, 1980, 7, 1, Smoke::mf_property, 0, 11},	//2623 Plasma::TextEdit::setReadOnly(bool)
    {97, 1148, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 12},	//2624 Plasma::TextEdit::isReadOnly() const
    {97, 2048, 89, 1, Smoke::mf_property, 0, 13},	//2625 Plasma::TextEdit::setStyleSheet(const QString&)
    {97, 2236, 0, 0, Smoke::mf_property, 293, 14},	//2626 Plasma::TextEdit::styleSheet()
    {97, 1923, 900, 1, 0, 0, 15},	//2627 Plasma::TextEdit::setNativeWidget(KTextEdit*)
    {97, 1388, 0, 0, Smoke::mf_const, 25, 16},	//2628 Plasma::TextEdit::nativeWidget() const
    {97, 662, 89, 1, Smoke::mf_slot, 0, 17},	//2629 Plasma::TextEdit::append(const QString&)
    {97, 841, 489, 2, Smoke::mf_slot, 0, 18},	//2630 Plasma::TextEdit::dataUpdated(const QString&, const Plasma::DataEngine::Data&)
    {97, 2276, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 19},	//2631 Plasma::TextEdit::textChanged()
    {97, 1584, 282, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 20},	//2632 Plasma::TextEdit::resizeEvent(QGraphicsSceneResizeEvent*)
    {97, 710, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 21},	//2633 Plasma::TextEdit::changeEvent(QEvent*)
    {97, 794, 394, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 22},	//2634 Plasma::TextEdit::contextMenuEvent(QGraphicsSceneContextMenuEvent*)
    {97, 1370, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 23},	//2635 Plasma::TextEdit::mousePressEvent(QGraphicsSceneMouseEvent*)
    {97, 1002, 280, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 24},	//2636 Plasma::TextEdit::focusOutEvent(QFocusEvent*)
    {97, 2304, 1, 1, Smoke::mf_static, 293, 25},	//2637 Plasma::TextEdit::tr(const char*)
    {97, 2308, 1, 1, Smoke::mf_static, 293, 26},	//2638 Plasma::TextEdit::trUtf8(const char*)
    {97, 482, 0, 0, Smoke::mf_ctor, 158, 27},	//2639 Plasma::TextEdit::TextEdit()
    {97, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 28},	//2640 Plasma::TextEdit::staticMetaObject() const
    {97, 2472, 0, 0, Smoke::mf_dtor, 0, 29 },	//2641 Plasma::TextEdit::~TextEdit()
    {98, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//2642 Plasma::Theme::metaObject() const
    {98, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//2643 Plasma::Theme::qt_metacast(const char*)
    {98, 2304, 43, 2, Smoke::mf_static, 293, 3},	//2644 Plasma::Theme::tr(const char*, const char*)
    {98, 2308, 43, 2, Smoke::mf_static, 293, 4},	//2645 Plasma::Theme::trUtf8(const char*, const char*)
    {98, 2304, 46, 3, Smoke::mf_static, 293, 5},	//2646 Plasma::Theme::tr(const char*, const char*, int)
    {98, 2308, 46, 3, Smoke::mf_static, 293, 6},	//2647 Plasma::Theme::trUtf8(const char*, const char*, int)
    {98, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//2648 Plasma::Theme::qt_metacall(QMetaObject::Call, int, void**)
    {98, 846, 0, 0, Smoke::mf_static, 159, 8},	//2649 Plasma::Theme::defaultTheme()
    {98, 484, 97, 1, Smoke::mf_ctor, 159, 9},	//2650 Plasma::Theme::Theme(QObject*)
    {98, 484, 149, 2, Smoke::mf_ctor, 159, 10},	//2651 Plasma::Theme::Theme(const QString&, QObject*)
    {98, 1415, 0, 0, Smoke::mf_static, 21, 11},	//2652 Plasma::Theme::packageStructure()
    {98, 1273, 0, 0, Smoke::mf_static, 242, 12},	//2653 Plasma::Theme::listThemeInfo()
    {98, 2088, 89, 1, 0, 0, 13},	//2654 Plasma::Theme::setThemeName(const QString&)
    {98, 2283, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 14},	//2655 Plasma::Theme::themeName() const
    {98, 1080, 89, 1, Smoke::mf_const, 293, 15},	//2656 Plasma::Theme::imagePath(const QString&) const
    {98, 656, 89, 1, Smoke::mf_const, 293, 16},	//2657 Plasma::Theme::animationPath(const QString&) const
    {98, 2386, 186, 1, Smoke::mf_const, 293, 17},	//2658 Plasma::Theme::wallpaperPath(const QSize&) const
    {98, 828, 89, 1, Smoke::mf_const, 386, 18},	//2659 Plasma::Theme::currentThemeHasImage(const QString&) const
    {98, 737, 0, 0, Smoke::mf_const, 20, 19},	//2660 Plasma::Theme::colorScheme() const
    {98, 735, 902, 1, Smoke::mf_const, 189, 20},	//2661 Plasma::Theme::color(Plasma::Theme::ColorRole) const
    {98, 1819, 904, 2, 0, 0, 21},	//2662 Plasma::Theme::setFont(const QFont&, Plasma::Theme::FontRole)
    {98, 1005, 907, 1, Smoke::mf_const, 211, 22},	//2663 Plasma::Theme::font(Plasma::Theme::FontRole) const
    {98, 1009, 0, 0, Smoke::mf_const, 212, 23},	//2664 Plasma::Theme::fontMetrics() const
    {98, 2398, 0, 0, Smoke::mf_const, 386, 24},	//2665 Plasma::Theme::windowTranslucencyEnabled() const
    {98, 2116, 7, 1, 0, 0, 25},	//2666 Plasma::Theme::setUseGlobalSettings(bool)
    {98, 2353, 0, 0, Smoke::mf_const, 386, 26},	//2667 Plasma::Theme::useGlobalSettings() const
    {98, 2354, 0, 0, Smoke::mf_const, 386, 27},	//2668 Plasma::Theme::useNativeWidgetStyle() const
    {98, 2236, 89, 1, Smoke::mf_const, 293, 28},	//2669 Plasma::Theme::styleSheet(const QString&) const
    {98, 976, 909, 2, 0, 386, 29},	//2670 Plasma::Theme::findInCache(const QString&, QPixmap&)
    {98, 976, 912, 3, 0, 386, 30},	//2671 Plasma::Theme::findInCache(const QString&, QPixmap&, unsigned int)
    {98, 1102, 916, 2, 0, 0, 31},	//2672 Plasma::Theme::insertIntoCache(const QString&, const QPixmap&)
    {98, 1102, 919, 3, 0, 0, 32},	//2673 Plasma::Theme::insertIntoCache(const QString&, const QPixmap&, const QString&)
    {98, 1708, 129, 1, 0, 0, 33},	//2674 Plasma::Theme::setCacheLimit(int)
    {98, 979, 923, 3, Smoke::mf_const, 386, 34},	//2675 Plasma::Theme::findInRectsCache(const QString&, const QString&, QRectF&) const
    {98, 1245, 89, 1, Smoke::mf_const, 294, 35},	//2676 Plasma::Theme::listCachedRectKeys(const QString&) const
    {98, 1105, 927, 3, 0, 0, 36},	//2677 Plasma::Theme::insertIntoRectsCache(const QString&, const QString&, const QRectF&)
    {98, 1115, 89, 1, 0, 0, 37},	//2678 Plasma::Theme::invalidateRectsCache(const QString&)
    {98, 1513, 89, 1, 0, 0, 38},	//2679 Plasma::Theme::releaseRectsCache(const QString&)
    {98, 1063, 0, 0, Smoke::mf_const, 26, 39},	//2680 Plasma::Theme::homepage() const
    {98, 2300, 0, 0, Smoke::mf_const, 477, 40},	//2681 Plasma::Theme::toolTipDelay() const
    {98, 2282, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 41},	//2682 Plasma::Theme::themeChanged()
    {98, 2159, 0, 0, Smoke::mf_slot, 0, 42},	//2683 Plasma::Theme::settingsChanged()
    {98, 2304, 1, 1, Smoke::mf_static, 293, 43},	//2684 Plasma::Theme::tr(const char*)
    {98, 2308, 1, 1, Smoke::mf_static, 293, 44},	//2685 Plasma::Theme::trUtf8(const char*)
    {98, 484, 0, 0, Smoke::mf_ctor, 159, 45},	//2686 Plasma::Theme::Theme()
    {98, 484, 89, 1, Smoke::mf_ctor, 159, 46},	//2687 Plasma::Theme::Theme(const QString&)
    {98, 2386, 0, 0, Smoke::mf_const, 293, 47},	//2688 Plasma::Theme::wallpaperPath() const
    {98, 1819, 579, 1, 0, 0, 48},	//2689 Plasma::Theme::setFont(const QFont&)
    {98, 2236, 0, 0, Smoke::mf_const, 293, 49},	//2690 Plasma::Theme::styleSheet() const
    {98, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 50},	//2691 Plasma::Theme::staticMetaObject() const
    {98, 481, 0, 0, Smoke::mf_static|Smoke::mf_enum, 160, 51},	//2692 Plasma::Theme::TextColor (enum)
    {98, 208, 0, 0, Smoke::mf_static|Smoke::mf_enum, 160, 52},	//2693 Plasma::Theme::HighlightColor (enum)
    {98, 53, 0, 0, Smoke::mf_static|Smoke::mf_enum, 160, 53},	//2694 Plasma::Theme::BackgroundColor (enum)
    {98, 77, 0, 0, Smoke::mf_static|Smoke::mf_enum, 160, 54},	//2695 Plasma::Theme::ButtonTextColor (enum)
    {98, 70, 0, 0, Smoke::mf_static|Smoke::mf_enum, 160, 55},	//2696 Plasma::Theme::ButtonBackgroundColor (enum)
    {98, 303, 0, 0, Smoke::mf_static|Smoke::mf_enum, 160, 56},	//2697 Plasma::Theme::LinkColor (enum)
    {98, 535, 0, 0, Smoke::mf_static|Smoke::mf_enum, 160, 57},	//2698 Plasma::Theme::VisitedLinkColor (enum)
    {98, 73, 0, 0, Smoke::mf_static|Smoke::mf_enum, 160, 58},	//2699 Plasma::Theme::ButtonHoverColor (enum)
    {98, 72, 0, 0, Smoke::mf_static|Smoke::mf_enum, 160, 59},	//2700 Plasma::Theme::ButtonFocusColor (enum)
    {98, 534, 0, 0, Smoke::mf_static|Smoke::mf_enum, 160, 60},	//2701 Plasma::Theme::ViewTextColor (enum)
    {98, 531, 0, 0, Smoke::mf_static|Smoke::mf_enum, 160, 61},	//2702 Plasma::Theme::ViewBackgroundColor (enum)
    {98, 533, 0, 0, Smoke::mf_static|Smoke::mf_enum, 160, 62},	//2703 Plasma::Theme::ViewHoverColor (enum)
    {98, 532, 0, 0, Smoke::mf_static|Smoke::mf_enum, 160, 63},	//2704 Plasma::Theme::ViewFocusColor (enum)
    {98, 134, 0, 0, Smoke::mf_static|Smoke::mf_enum, 161, 64},	//2705 Plasma::Theme::DefaultFont (enum)
    {98, 142, 0, 0, Smoke::mf_static|Smoke::mf_enum, 161, 65},	//2706 Plasma::Theme::DesktopFont (enum)
    {98, 450, 0, 0, Smoke::mf_static|Smoke::mf_enum, 161, 66},	//2707 Plasma::Theme::SmallestFont (enum)
    {98, 2473, 0, 0, Smoke::mf_dtor, 0, 67 },	//2708 Plasma::Theme::~Theme()
    {99, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//2709 Plasma::ToolButton::metaObject() const
    {99, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//2710 Plasma::ToolButton::qt_metacast(const char*)
    {99, 2304, 43, 2, Smoke::mf_static, 293, 3},	//2711 Plasma::ToolButton::tr(const char*, const char*)
    {99, 2308, 43, 2, Smoke::mf_static, 293, 4},	//2712 Plasma::ToolButton::trUtf8(const char*, const char*)
    {99, 2304, 46, 3, Smoke::mf_static, 293, 5},	//2713 Plasma::ToolButton::tr(const char*, const char*, int)
    {99, 2308, 46, 3, Smoke::mf_static, 293, 6},	//2714 Plasma::ToolButton::trUtf8(const char*, const char*, int)
    {99, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//2715 Plasma::ToolButton::qt_metacall(QMetaObject::Call, int, void**)
    {99, 489, 125, 1, Smoke::mf_ctor, 162, 8},	//2716 Plasma::ToolButton::ToolButton(QGraphicsWidget*)
    {99, 1694, 7, 1, Smoke::mf_property, 0, 9},	//2717 Plasma::ToolButton::setAutoRaise(bool)
    {99, 690, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 10},	//2718 Plasma::ToolButton::autoRaise() const
    {99, 2080, 89, 1, Smoke::mf_property, 0, 11},	//2719 Plasma::ToolButton::setText(const QString&)
    {99, 2274, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 12},	//2720 Plasma::ToolButton::text() const
    {99, 1865, 89, 1, Smoke::mf_property, 0, 13},	//2721 Plasma::ToolButton::setImage(const QString&)
    {99, 1865, 77, 2, 0, 0, 14},	//2722 Plasma::ToolButton::setImage(const QString&, const QString&)
    {99, 1079, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 15},	//2723 Plasma::ToolButton::image() const
    {99, 1785, 7, 1, Smoke::mf_property, 0, 16},	//2724 Plasma::ToolButton::setDown(bool)
    {99, 1130, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 17},	//2725 Plasma::ToolButton::isDown() const
    {99, 2048, 89, 1, Smoke::mf_property, 0, 18},	//2726 Plasma::ToolButton::setStyleSheet(const QString&)
    {99, 2236, 0, 0, Smoke::mf_property, 293, 19},	//2727 Plasma::ToolButton::styleSheet()
    {99, 1658, 107, 1, 0, 0, 20},	//2728 Plasma::ToolButton::setAction(QAction*)
    {99, 557, 0, 0, Smoke::mf_const, 183, 21},	//2729 Plasma::ToolButton::action() const
    {99, 1858, 567, 1, 0, 0, 22},	//2730 Plasma::ToolButton::setIcon(const QIcon&)
    {99, 1075, 0, 0, Smoke::mf_const, 236, 23},	//2731 Plasma::ToolButton::icon() const
    {99, 1388, 0, 0, Smoke::mf_const, 301, 24},	//2732 Plasma::ToolButton::nativeWidget() const
    {99, 726, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 25},	//2733 Plasma::ToolButton::clicked()
    {99, 1476, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 26},	//2734 Plasma::ToolButton::pressed()
    {99, 1516, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 27},	//2735 Plasma::ToolButton::released()
    {99, 1420, 216, 3, Smoke::mf_protected|Smoke::mf_virtual, 0, 28},	//2736 Plasma::ToolButton::paint(QPainter*, const QStyleOptionGraphicsItem*, QWidget*)
    {99, 1584, 282, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 29},	//2737 Plasma::ToolButton::resizeEvent(QGraphicsSceneResizeEvent*)
    {99, 1068, 290, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 30},	//2738 Plasma::ToolButton::hoverEnterEvent(QGraphicsSceneHoverEvent*)
    {99, 1070, 290, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 31},	//2739 Plasma::ToolButton::hoverLeaveEvent(QGraphicsSceneHoverEvent*)
    {99, 710, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 32},	//2740 Plasma::ToolButton::changeEvent(QEvent*)
    {99, 1179, 284, 2, Smoke::mf_protected|Smoke::mf_virtual, 304, 33},	//2741 Plasma::ToolButton::itemChange(QGraphicsItem::GraphicsItemChange, const QVariant&)
    {99, 2198, 287, 2, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 291, 34},	//2742 Plasma::ToolButton::sizeHint(Qt::SizeHint, const QSizeF&) const
    {99, 2304, 1, 1, Smoke::mf_static, 293, 35},	//2743 Plasma::ToolButton::tr(const char*)
    {99, 2308, 1, 1, Smoke::mf_static, 293, 36},	//2744 Plasma::ToolButton::trUtf8(const char*)
    {99, 489, 0, 0, Smoke::mf_ctor, 162, 37},	//2745 Plasma::ToolButton::ToolButton()
    {99, 1420, 328, 2, Smoke::mf_protected, 0, 38},	//2746 Plasma::ToolButton::paint(QPainter*, const QStyleOptionGraphicsItem*)
    {99, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 39},	//2747 Plasma::ToolButton::staticMetaObject() const
    {99, 2474, 0, 0, Smoke::mf_dtor, 0, 40 },	//2748 Plasma::ToolButton::~ToolButton()
    {100, 491, 0, 0, Smoke::mf_ctor, 164, 1},	//2749 Plasma::ToolTipContent::ToolTipContent()
    {100, 491, 931, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 164, 2},	//2750 Plasma::ToolTipContent::ToolTipContent(const Plasma::ToolTipContent&)
    {100, 491, 933, 3, Smoke::mf_ctor, 164, 3},	//2751 Plasma::ToolTipContent::ToolTipContent(const QString&, const QString&, const QPixmap&)
    {100, 491, 937, 3, Smoke::mf_ctor, 164, 4},	//2752 Plasma::ToolTipContent::ToolTipContent(const QString&, const QString&, const QIcon&)
    {100, 1408, 931, 1, 0, 163, 5},	//2753 Plasma::ToolTipContent::operator=(const Plasma::ToolTipContent&)
    {100, 1131, 0, 0, Smoke::mf_const, 386, 6},	//2754 Plasma::ToolTipContent::isEmpty() const
    {100, 1898, 89, 1, 0, 0, 7},	//2755 Plasma::ToolTipContent::setMainText(const QString&)
    {100, 1325, 0, 0, Smoke::mf_const, 293, 8},	//2756 Plasma::ToolTipContent::mainText() const
    {100, 2050, 89, 1, 0, 0, 9},	//2757 Plasma::ToolTipContent::setSubText(const QString&)
    {100, 2238, 0, 0, Smoke::mf_const, 293, 10},	//2758 Plasma::ToolTipContent::subText() const
    {100, 1865, 594, 1, 0, 0, 11},	//2759 Plasma::ToolTipContent::setImage(const QPixmap&)
    {100, 1865, 567, 1, 0, 0, 12},	//2760 Plasma::ToolTipContent::setImage(const QIcon&)
    {100, 1079, 0, 0, Smoke::mf_const, 277, 13},	//2761 Plasma::ToolTipContent::image() const
    {100, 2151, 941, 1, 0, 0, 14},	//2762 Plasma::ToolTipContent::setWindowToPreview(unsigned long)
    {100, 2397, 0, 0, Smoke::mf_const, 485, 15},	//2763 Plasma::ToolTipContent::windowToPreview() const
    {100, 2153, 943, 1, 0, 0, 16},	//2764 Plasma::ToolTipContent::setWindowsToPreview(const QList<unsigned long>&)
    {100, 2399, 0, 0, Smoke::mf_const, 261, 17},	//2765 Plasma::ToolTipContent::windowsToPreview() const
    {100, 1843, 7, 1, 0, 0, 18},	//2766 Plasma::ToolTipContent::setHighlightWindows(bool)
    {100, 1062, 0, 0, Smoke::mf_const, 386, 19},	//2767 Plasma::ToolTipContent::highlightWindows() const
    {100, 1696, 7, 1, 0, 0, 20},	//2768 Plasma::ToolTipContent::setAutohide(bool)
    {100, 691, 0, 0, Smoke::mf_const, 386, 21},	//2769 Plasma::ToolTipContent::autohide() const
    {100, 1879, 7, 1, 0, 0, 22},	//2770 Plasma::ToolTipContent::setInstantPopup(bool)
    {100, 1137, 0, 0, Smoke::mf_const, 386, 23},	//2771 Plasma::ToolTipContent::isInstantPopup() const
    {100, 614, 945, 3, 0, 0, 24},	//2772 Plasma::ToolTipContent::addResource(Plasma::ToolTipContent::ResourceType, const QUrl&, const QVariant&)
    {100, 1507, 949, 1, Smoke::mf_const, 0, 25},	//2773 Plasma::ToolTipContent::registerResources(QTextDocument*) const
    {100, 1720, 7, 1, 0, 0, 26},	//2774 Plasma::ToolTipContent::setClickable(bool)
    {100, 1126, 0, 0, Smoke::mf_const, 386, 27},	//2775 Plasma::ToolTipContent::isClickable() const
    {100, 1832, 125, 1, 0, 0, 28},	//2776 Plasma::ToolTipContent::setGraphicsWidget(QGraphicsWidget*)
    {100, 1033, 0, 0, Smoke::mf_const, 229, 29},	//2777 Plasma::ToolTipContent::graphicsWidget() const
    {100, 491, 77, 2, Smoke::mf_ctor, 164, 30},	//2778 Plasma::ToolTipContent::ToolTipContent(const QString&, const QString&)
    {100, 220, 0, 0, Smoke::mf_static|Smoke::mf_enum, 165, 31},	//2779 Plasma::ToolTipContent::ImageResource (enum)
    {100, 211, 0, 0, Smoke::mf_static|Smoke::mf_enum, 165, 32},	//2780 Plasma::ToolTipContent::HtmlResource (enum)
    {100, 118, 0, 0, Smoke::mf_static|Smoke::mf_enum, 165, 33},	//2781 Plasma::ToolTipContent::CssResource (enum)
    {100, 2475, 0, 0, Smoke::mf_dtor, 0, 34 },	//2782 Plasma::ToolTipContent::~ToolTipContent()
    {101, 1351, 0, 0, Smoke::mf_const, 442, 1},	//2783 Plasma::ToolTipManager::metaObject() const
    {101, 1487, 1, 1, 0, 486, 2},	//2784 Plasma::ToolTipManager::qt_metacast(const char*)
    {101, 2304, 43, 2, Smoke::mf_static, 293, 3},	//2785 Plasma::ToolTipManager::tr(const char*, const char*)
    {101, 2308, 43, 2, Smoke::mf_static, 293, 4},	//2786 Plasma::ToolTipManager::trUtf8(const char*, const char*)
    {101, 2304, 46, 3, Smoke::mf_static, 293, 5},	//2787 Plasma::ToolTipManager::tr(const char*, const char*, int)
    {101, 2308, 46, 3, Smoke::mf_static, 293, 6},	//2788 Plasma::ToolTipManager::trUtf8(const char*, const char*, int)
    {101, 1485, 3, 3, 0, 477, 7},	//2789 Plasma::ToolTipManager::qt_metacall(QMetaObject::Call, int, void**)
    {101, 1646, 0, 0, Smoke::mf_static, 166, 8},	//2790 Plasma::ToolTipManager::self()
    {101, 2164, 125, 1, 0, 0, 9},	//2791 Plasma::ToolTipManager::show(QGraphicsWidget*)
    {101, 1165, 125, 1, Smoke::mf_const, 386, 10},	//2792 Plasma::ToolTipManager::isVisible(QGraphicsWidget*) const
    {101, 1056, 125, 1, 0, 0, 11},	//2793 Plasma::ToolTipManager::hide(QGraphicsWidget*)
    {101, 1511, 125, 1, 0, 0, 12},	//2794 Plasma::ToolTipManager::registerWidget(QGraphicsWidget*)
    {101, 2327, 125, 1, 0, 0, 13},	//2795 Plasma::ToolTipManager::unregisterWidget(QGraphicsWidget*)
    {101, 1739, 951, 2, 0, 0, 14},	//2796 Plasma::ToolTipManager::setContent(QGraphicsWidget*, const Plasma::ToolTipContent&)
    {101, 722, 125, 1, 0, 0, 15},	//2797 Plasma::ToolTipManager::clearContent(QGraphicsWidget*)
    {101, 2041, 954, 1, 0, 0, 16},	//2798 Plasma::ToolTipManager::setState(Plasma::ToolTipManager::State)
    {101, 2222, 0, 0, Smoke::mf_const, 167, 17},	//2799 Plasma::ToolTipManager::state() const
    {101, 2395, 956, 4, Smoke::mf_protected|Smoke::mf_signal, 0, 18},	//2800 Plasma::ToolTipManager::windowPreviewActivated(WId, Qt::MouseButtons, Qt::KeyboardModifiers, const QPoint&)
    {101, 1230, 961, 4, Smoke::mf_protected|Smoke::mf_signal, 0, 19},	//2801 Plasma::ToolTipManager::linkActivated(const QString&, Qt::MouseButtons, Qt::KeyboardModifiers, const QPoint&)
    {101, 2304, 1, 1, Smoke::mf_static, 293, 20},	//2802 Plasma::ToolTipManager::tr(const char*)
    {101, 2308, 1, 1, Smoke::mf_static, 293, 21},	//2803 Plasma::ToolTipManager::trUtf8(const char*)
    {101, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 22},	//2804 Plasma::ToolTipManager::staticMetaObject() const
    {101, 17, 0, 0, Smoke::mf_static|Smoke::mf_enum, 167, 23},	//2805 Plasma::ToolTipManager::Activated (enum)
    {101, 224, 0, 0, Smoke::mf_static|Smoke::mf_enum, 167, 24},	//2806 Plasma::ToolTipManager::Inhibited (enum)
    {101, 130, 0, 0, Smoke::mf_static|Smoke::mf_enum, 167, 25},	//2807 Plasma::ToolTipManager::Deactivated (enum)
    {102, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//2808 Plasma::TreeView::metaObject() const
    {102, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//2809 Plasma::TreeView::qt_metacast(const char*)
    {102, 2304, 43, 2, Smoke::mf_static, 293, 3},	//2810 Plasma::TreeView::tr(const char*, const char*)
    {102, 2308, 43, 2, Smoke::mf_static, 293, 4},	//2811 Plasma::TreeView::trUtf8(const char*, const char*)
    {102, 2304, 46, 3, Smoke::mf_static, 293, 5},	//2812 Plasma::TreeView::tr(const char*, const char*, int)
    {102, 2308, 46, 3, Smoke::mf_static, 293, 6},	//2813 Plasma::TreeView::trUtf8(const char*, const char*, int)
    {102, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//2814 Plasma::TreeView::qt_metacall(QMetaObject::Call, int, void**)
    {102, 504, 125, 1, Smoke::mf_ctor, 168, 8},	//2815 Plasma::TreeView::TreeView(QGraphicsWidget*)
    {102, 1918, 966, 1, 0, 0, 9},	//2816 Plasma::TreeView::setModel(QAbstractItemModel*)
    {102, 1365, 0, 0, 0, 182, 10},	//2817 Plasma::TreeView::model()
    {102, 2048, 89, 1, Smoke::mf_property, 0, 11},	//2818 Plasma::TreeView::setStyleSheet(const QString&)
    {102, 2236, 0, 0, Smoke::mf_property, 293, 12},	//2819 Plasma::TreeView::styleSheet()
    {102, 1388, 0, 0, Smoke::mf_const, 302, 13},	//2820 Plasma::TreeView::nativeWidget() const
    {102, 2304, 1, 1, Smoke::mf_static, 293, 14},	//2821 Plasma::TreeView::tr(const char*)
    {102, 2308, 1, 1, Smoke::mf_static, 293, 15},	//2822 Plasma::TreeView::trUtf8(const char*)
    {102, 504, 0, 0, Smoke::mf_ctor, 168, 16},	//2823 Plasma::TreeView::TreeView()
    {102, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 17},	//2824 Plasma::TreeView::staticMetaObject() const
    {102, 2476, 0, 0, Smoke::mf_dtor, 0, 18 },	//2825 Plasma::TreeView::~TreeView()
    {103, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//2826 Plasma::VideoWidget::metaObject() const
    {103, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//2827 Plasma::VideoWidget::qt_metacast(const char*)
    {103, 2304, 43, 2, Smoke::mf_static, 293, 3},	//2828 Plasma::VideoWidget::tr(const char*, const char*)
    {103, 2308, 43, 2, Smoke::mf_static, 293, 4},	//2829 Plasma::VideoWidget::trUtf8(const char*, const char*)
    {103, 2304, 46, 3, Smoke::mf_static, 293, 5},	//2830 Plasma::VideoWidget::tr(const char*, const char*, int)
    {103, 2308, 46, 3, Smoke::mf_static, 293, 6},	//2831 Plasma::VideoWidget::trUtf8(const char*, const char*, int)
    {103, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//2832 Plasma::VideoWidget::qt_metacall(QMetaObject::Call, int, void**)
    {103, 524, 125, 1, Smoke::mf_ctor, 170, 8},	//2833 Plasma::VideoWidget::VideoWidget(QGraphicsWidget*)
    {103, 2109, 89, 1, Smoke::mf_property, 0, 9},	//2834 Plasma::VideoWidget::setUrl(const QString&)
    {103, 2346, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 10},	//2835 Plasma::VideoWidget::url() const
    {103, 1348, 0, 0, Smoke::mf_const, 29, 11},	//2836 Plasma::VideoWidget::mediaObject() const
    {103, 684, 0, 0, Smoke::mf_const, 28, 12},	//2837 Plasma::VideoWidget::audioOutput() const
    {103, 830, 0, 0, Smoke::mf_const, 480, 13},	//2838 Plasma::VideoWidget::currentTime() const
    {103, 2303, 0, 0, Smoke::mf_const, 480, 14},	//2839 Plasma::VideoWidget::totalTime() const
    {103, 1520, 0, 0, Smoke::mf_const, 480, 15},	//2840 Plasma::VideoWidget::remainingTime() const
    {103, 2118, 968, 1, 0, 0, 16},	//2841 Plasma::VideoWidget::setUsedControls(const QFlags<Plasma::VideoWidget::Control>)
    {103, 2355, 0, 0, Smoke::mf_const, 206, 17},	//2842 Plasma::VideoWidget::usedControls() const
    {103, 1749, 7, 1, Smoke::mf_property, 0, 18},	//2843 Plasma::VideoWidget::setControlsVisible(bool)
    {103, 797, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 19},	//2844 Plasma::VideoWidget::controlsVisible() const
    {103, 2092, 970, 1, 0, 0, 20},	//2845 Plasma::VideoWidget::setTickInterval(long long)
    {103, 2287, 0, 0, Smoke::mf_const, 480, 21},	//2846 Plasma::VideoWidget::tickInterval() const
    {103, 2048, 89, 1, Smoke::mf_property, 0, 22},	//2847 Plasma::VideoWidget::setStyleSheet(const QString&)
    {103, 2236, 0, 0, Smoke::mf_property, 293, 23},	//2848 Plasma::VideoWidget::styleSheet()
    {103, 1388, 0, 0, Smoke::mf_const, 30, 24},	//2849 Plasma::VideoWidget::nativeWidget() const
    {103, 1456, 0, 0, Smoke::mf_slot, 0, 25},	//2850 Plasma::VideoWidget::play()
    {103, 1449, 0, 0, Smoke::mf_slot, 0, 26},	//2851 Plasma::VideoWidget::pause()
    {103, 2225, 0, 0, Smoke::mf_slot, 0, 27},	//2852 Plasma::VideoWidget::stop()
    {103, 1643, 972, 1, Smoke::mf_slot, 0, 28},	//2853 Plasma::VideoWidget::seek(qint64)
    {103, 2285, 972, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 29},	//2854 Plasma::VideoWidget::tick(qint64)
    {103, 551, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 30},	//2855 Plasma::VideoWidget::aboutToFinish()
    {103, 1394, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 31},	//2856 Plasma::VideoWidget::nextRequested()
    {103, 1478, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 32},	//2857 Plasma::VideoWidget::previousRequested()
    {103, 1584, 282, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 33},	//2858 Plasma::VideoWidget::resizeEvent(QGraphicsSceneResizeEvent*)
    {103, 1068, 290, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 34},	//2859 Plasma::VideoWidget::hoverEnterEvent(QGraphicsSceneHoverEvent*)
    {103, 1070, 290, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 35},	//2860 Plasma::VideoWidget::hoverLeaveEvent(QGraphicsSceneHoverEvent*)
    {103, 1072, 290, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 36},	//2861 Plasma::VideoWidget::hoverMoveEvent(QGraphicsSceneHoverEvent*)
    {103, 2304, 1, 1, Smoke::mf_static, 293, 37},	//2862 Plasma::VideoWidget::tr(const char*)
    {103, 2308, 1, 1, Smoke::mf_static, 293, 38},	//2863 Plasma::VideoWidget::trUtf8(const char*)
    {103, 524, 0, 0, Smoke::mf_ctor, 170, 39},	//2864 Plasma::VideoWidget::VideoWidget()
    {103, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 40},	//2865 Plasma::VideoWidget::staticMetaObject() const
    {103, 333, 0, 0, Smoke::mf_static|Smoke::mf_enum, 171, 41},	//2866 Plasma::VideoWidget::NoControls (enum)
    {103, 374, 0, 0, Smoke::mf_static|Smoke::mf_enum, 171, 42},	//2867 Plasma::VideoWidget::Play (enum)
    {103, 365, 0, 0, Smoke::mf_static|Smoke::mf_enum, 171, 43},	//2868 Plasma::VideoWidget::Pause (enum)
    {103, 459, 0, 0, Smoke::mf_static|Smoke::mf_enum, 171, 44},	//2869 Plasma::VideoWidget::Stop (enum)
    {103, 375, 0, 0, Smoke::mf_static|Smoke::mf_enum, 171, 45},	//2870 Plasma::VideoWidget::PlayPause (enum)
    {103, 382, 0, 0, Smoke::mf_static|Smoke::mf_enum, 171, 46},	//2871 Plasma::VideoWidget::Previous (enum)
    {103, 322, 0, 0, Smoke::mf_static|Smoke::mf_enum, 171, 47},	//2872 Plasma::VideoWidget::Next (enum)
    {103, 383, 0, 0, Smoke::mf_static|Smoke::mf_enum, 171, 48},	//2873 Plasma::VideoWidget::Progress (enum)
    {103, 536, 0, 0, Smoke::mf_static|Smoke::mf_enum, 171, 49},	//2874 Plasma::VideoWidget::Volume (enum)
    {103, 349, 0, 0, Smoke::mf_static|Smoke::mf_enum, 171, 50},	//2875 Plasma::VideoWidget::OpenFile (enum)
    {103, 133, 0, 0, Smoke::mf_static|Smoke::mf_enum, 171, 51},	//2876 Plasma::VideoWidget::DefaultControls (enum)
    {103, 2477, 0, 0, Smoke::mf_dtor, 0, 52 },	//2877 Plasma::VideoWidget::~VideoWidget()
    {104, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//2878 Plasma::View::metaObject() const
    {104, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//2879 Plasma::View::qt_metacast(const char*)
    {104, 2304, 43, 2, Smoke::mf_static, 293, 3},	//2880 Plasma::View::tr(const char*, const char*)
    {104, 2308, 43, 2, Smoke::mf_static, 293, 4},	//2881 Plasma::View::trUtf8(const char*, const char*)
    {104, 2304, 46, 3, Smoke::mf_static, 293, 5},	//2882 Plasma::View::tr(const char*, const char*, int)
    {104, 2308, 46, 3, Smoke::mf_static, 293, 6},	//2883 Plasma::View::trUtf8(const char*, const char*, int)
    {104, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//2884 Plasma::View::qt_metacall(QMetaObject::Call, int, void**)
    {104, 526, 974, 2, Smoke::mf_ctor, 172, 8},	//2885 Plasma::View::View(Plasma::Containment*, QWidget*)
    {104, 526, 977, 3, Smoke::mf_ctor, 172, 9},	//2886 Plasma::View::View(Plasma::Containment*, int, QWidget*)
    {104, 2145, 7, 1, 0, 0, 10},	//2887 Plasma::View::setWallpaperEnabled(bool)
    {104, 1167, 0, 0, Smoke::mf_const, 386, 11},	//2888 Plasma::View::isWallpaperEnabled() const
    {104, 2004, 370, 2, 0, 0, 12},	//2889 Plasma::View::setScreen(int, int)
    {104, 1626, 0, 0, Smoke::mf_const, 477, 13},	//2890 Plasma::View::screen() const
    {104, 850, 0, 0, Smoke::mf_const, 477, 14},	//2891 Plasma::View::desktop() const
    {104, 912, 0, 0, Smoke::mf_const, 477, 15},	//2892 Plasma::View::effectiveDesktop() const
    {104, 765, 0, 0, Smoke::mf_const, 69, 16},	//2893 Plasma::View::containment() const
    {104, 2248, 410, 3, 0, 69, 17},	//2894 Plasma::View::swapContainment(Plasma::Containment*, const QString&, const QList<QVariant>&)
    {104, 2248, 113, 2, 0, 69, 18},	//2895 Plasma::View::swapContainment(const QString&, const QList<QVariant>&)
    {104, 2100, 7, 1, 0, 0, 19},	//2896 Plasma::View::setTrackContainmentChanges(bool)
    {104, 2312, 0, 0, 0, 386, 20},	//2897 Plasma::View::trackContainmentChanges()
    {104, 2301, 555, 1, Smoke::mf_static, 172, 21},	//2898 Plasma::View::topLevelViewAt(const QPoint&)
    {104, 1077, 0, 0, Smoke::mf_const, 477, 22},	//2899 Plasma::View::id() const
    {104, 1623, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 23},	//2900 Plasma::View::sceneRectAboutToChange()
    {104, 1624, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 24},	//2901 Plasma::View::sceneRectChanged()
    {104, 1321, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 25},	//2902 Plasma::View::lostContainment()
    {104, 1729, 101, 1, Smoke::mf_virtual|Smoke::mf_slot, 0, 26},	//2903 Plasma::View::setContainment(Plasma::Containment*)
    {104, 738, 0, 0, Smoke::mf_const|Smoke::mf_protected, 8, 27},	//2904 Plasma::View::config() const
    {104, 741, 0, 0, Smoke::mf_const|Smoke::mf_protected, 0, 28},	//2905 Plasma::View::configNeedsSaving() const
    {104, 2304, 1, 1, Smoke::mf_static, 293, 29},	//2906 Plasma::View::tr(const char*)
    {104, 2308, 1, 1, Smoke::mf_static, 293, 30},	//2907 Plasma::View::trUtf8(const char*)
    {104, 526, 101, 1, Smoke::mf_ctor, 172, 31},	//2908 Plasma::View::View(Plasma::Containment*)
    {104, 526, 981, 2, Smoke::mf_ctor, 172, 32},	//2909 Plasma::View::View(Plasma::Containment*, int)
    {104, 2004, 129, 1, 0, 0, 33},	//2910 Plasma::View::setScreen(int)
    {104, 2248, 424, 2, 0, 69, 34},	//2911 Plasma::View::swapContainment(Plasma::Containment*, const QString&)
    {104, 2248, 89, 1, 0, 69, 35},	//2912 Plasma::View::swapContainment(const QString&)
    {104, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 36},	//2913 Plasma::View::staticMetaObject() const
    {104, 2478, 0, 0, Smoke::mf_dtor, 0, 37 },	//2914 Plasma::View::~View()
    {105, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//2915 Plasma::Wallpaper::metaObject() const
    {105, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//2916 Plasma::Wallpaper::qt_metacast(const char*)
    {105, 2304, 43, 2, Smoke::mf_static, 293, 3},	//2917 Plasma::Wallpaper::tr(const char*, const char*)
    {105, 2308, 43, 2, Smoke::mf_static, 293, 4},	//2918 Plasma::Wallpaper::trUtf8(const char*, const char*)
    {105, 2304, 46, 3, Smoke::mf_static, 293, 5},	//2919 Plasma::Wallpaper::tr(const char*, const char*, int)
    {105, 2308, 46, 3, Smoke::mf_static, 293, 6},	//2920 Plasma::Wallpaper::trUtf8(const char*, const char*, int)
    {105, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//2921 Plasma::Wallpaper::qt_metacall(QMetaObject::Call, int, void**)
    {105, 537, 97, 1, Smoke::mf_ctor, 173, 8},	//2922 Plasma::Wallpaper::Wallpaper(QObject*)
    {105, 2112, 246, 1, 0, 0, 9},	//2923 Plasma::Wallpaper::setUrls(const KUrl::List&)
    {105, 1276, 89, 1, Smoke::mf_static, 242, 10},	//2924 Plasma::Wallpaper::listWallpaperInfo(const QString&)
    {105, 1278, 77, 2, Smoke::mf_static, 242, 11},	//2925 Plasma::Wallpaper::listWallpaperInfoForMimetype(const QString&, const QString&)
    {105, 1281, 113, 2, Smoke::mf_static, 173, 12},	//2926 Plasma::Wallpaper::load(const QString&, const QList<QVariant>&)
    {105, 1281, 984, 2, Smoke::mf_static, 173, 13},	//2927 Plasma::Wallpaper::load(const KPluginInfo&, const QList<QVariant>&)
    {105, 1415, 987, 1, Smoke::mf_static, 21, 14},	//2928 Plasma::Wallpaper::packageStructure(Plasma::Wallpaper*)
    {105, 1386, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 15},	//2929 Plasma::Wallpaper::name() const
    {105, 1414, 0, 0, Smoke::mf_const, 409, 16},	//2930 Plasma::Wallpaper::package() const
    {105, 1458, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 17},	//2931 Plasma::Wallpaper::pluginName() const
    {105, 1075, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 18},	//2932 Plasma::Wallpaper::icon() const
    {105, 1569, 0, 0, Smoke::mf_const|Smoke::mf_property, 17, 19},	//2933 Plasma::Wallpaper::renderingMode() const
    {105, 2242, 89, 1, Smoke::mf_const, 386, 20},	//2934 Plasma::Wallpaper::supportsMimetype(const QString&) const
    {105, 1986, 89, 1, 0, 0, 21},	//2935 Plasma::Wallpaper::setRenderingMode(const QString&)
    {105, 1270, 0, 0, Smoke::mf_const|Smoke::mf_property, 243, 22},	//2936 Plasma::Wallpaper::listRenderingModes() const
    {105, 1136, 0, 0, Smoke::mf_const, 386, 23},	//2937 Plasma::Wallpaper::isInitialized() const
    {105, 704, 0, 0, Smoke::mf_const|Smoke::mf_property, 283, 24},	//2938 Plasma::Wallpaper::boundingRect() const
    {105, 1702, 653, 1, Smoke::mf_property, 0, 25},	//2939 Plasma::Wallpaper::setBoundingRect(const QRectF&)
    {105, 1420, 619, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 26},	//2940 Plasma::Wallpaper::paint(QPainter*, const QRectF&) [pure virtual]
    {105, 1589, 111, 1, 0, 0, 27},	//2941 Plasma::Wallpaper::restore(const KConfigGroup&)
    {105, 1607, 178, 1, Smoke::mf_virtual, 0, 28},	//2942 Plasma::Wallpaper::save(KConfigGroup&)
    {105, 805, 57, 1, Smoke::mf_virtual, 309, 29},	//2943 Plasma::Wallpaper::createConfigurationInterface(QWidget*)
    {105, 1368, 278, 1, Smoke::mf_virtual, 0, 30},	//2944 Plasma::Wallpaper::mouseMoveEvent(QGraphicsSceneMouseEvent*)
    {105, 1370, 278, 1, Smoke::mf_virtual, 0, 31},	//2945 Plasma::Wallpaper::mousePressEvent(QGraphicsSceneMouseEvent*)
    {105, 1372, 278, 1, Smoke::mf_virtual, 0, 32},	//2946 Plasma::Wallpaper::mouseReleaseEvent(QGraphicsSceneMouseEvent*)
    {105, 2389, 398, 1, Smoke::mf_virtual, 0, 33},	//2947 Plasma::Wallpaper::wheelEvent(QGraphicsSceneWheelEvent*)
    {105, 839, 89, 1, Smoke::mf_const, 81, 34},	//2948 Plasma::Wallpaper::dataEngine(const QString&) const
    {105, 745, 0, 0, Smoke::mf_const, 386, 35},	//2949 Plasma::Wallpaper::configurationRequired() const
    {105, 1163, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 36},	//2950 Plasma::Wallpaper::isUsingRenderingCache() const
    {105, 1994, 989, 1, Smoke::mf_property, 0, 37},	//2951 Plasma::Wallpaper::setResizeMethodHint(Plasma::Wallpaper::ResizeMethod)
    {105, 1588, 0, 0, Smoke::mf_const|Smoke::mf_property, 174, 38},	//2952 Plasma::Wallpaper::resizeMethodHint() const
    {105, 2074, 603, 1, Smoke::mf_property, 0, 39},	//2953 Plasma::Wallpaper::setTargetSizeHint(const QSizeF&)
    {105, 2270, 0, 0, Smoke::mf_const|Smoke::mf_property, 291, 40},	//2954 Plasma::Wallpaper::targetSizeHint() const
    {105, 796, 0, 0, Smoke::mf_const, 255, 41},	//2955 Plasma::Wallpaper::contextualActions() const
    {105, 1146, 0, 0, Smoke::mf_const|Smoke::mf_property, 386, 42},	//2956 Plasma::Wallpaper::isPreviewing() const
    {105, 1972, 7, 1, Smoke::mf_property, 0, 43},	//2957 Plasma::Wallpaper::setPreviewing(bool)
    {105, 1389, 0, 0, Smoke::mf_const, 386, 44},	//2958 Plasma::Wallpaper::needsPreviewDuringConfiguration() const
    {105, 2329, 653, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 45},	//2959 Plasma::Wallpaper::update(const QRectF&)
    {105, 747, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 46},	//2960 Plasma::Wallpaper::configureRequested()
    {105, 745, 7, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 47},	//2961 Plasma::Wallpaper::configurationRequired(bool)
    {105, 741, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 48},	//2962 Plasma::Wallpaper::configNeedsSaving()
    {105, 1566, 633, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 49},	//2963 Plasma::Wallpaper::renderCompleted(const QImage&)
    {105, 2349, 119, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 50},	//2964 Plasma::Wallpaper::urlDropped(const KUrl&)
    {105, 1568, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 51},	//2965 Plasma::Wallpaper::renderHintsChanged()
    {105, 637, 246, 1, Smoke::mf_protected|Smoke::mf_slot, 0, 52},	//2966 Plasma::Wallpaper::addUrls(const KUrl::List&)
    {105, 537, 70, 2, Smoke::mf_ctor|Smoke::mf_protected, 173, 53},	//2967 Plasma::Wallpaper::Wallpaper(QObject*, const QList<QVariant>&)
    {105, 1091, 111, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 54},	//2968 Plasma::Wallpaper::init(const KConfigGroup&)
    {105, 1726, 265, 2, Smoke::mf_protected, 0, 55},	//2969 Plasma::Wallpaper::setConfigurationRequired(bool, const QString&)
    {105, 1559, 991, 4, Smoke::mf_protected, 0, 56},	//2970 Plasma::Wallpaper::render(const QString&, const QSize&, Plasma::Wallpaper::ResizeMethod, const QColor&)
    {105, 1559, 996, 4, Smoke::mf_protected, 0, 57},	//2971 Plasma::Wallpaper::render(const QImage&, const QSize&, Plasma::Wallpaper::ResizeMethod, const QColor&)
    {105, 2120, 7, 1, Smoke::mf_protected|Smoke::mf_property, 0, 58},	//2972 Plasma::Wallpaper::setUsingRenderingCache(bool)
    {105, 976, 1001, 3, Smoke::mf_protected, 386, 59},	//2973 Plasma::Wallpaper::findInCache(const QString&, QImage&, unsigned int)
    {105, 1102, 1005, 2, Smoke::mf_protected, 0, 60},	//2974 Plasma::Wallpaper::insertIntoCache(const QString&, const QImage&)
    {105, 1747, 1008, 1, Smoke::mf_protected, 0, 61},	//2975 Plasma::Wallpaper::setContextualActions(const QList<QAction*>&)
    {105, 1970, 109, 1, Smoke::mf_protected, 0, 62},	//2976 Plasma::Wallpaper::setPreviewDuringConfiguration(const bool)
    {105, 2304, 1, 1, Smoke::mf_static, 293, 63},	//2977 Plasma::Wallpaper::tr(const char*)
    {105, 2308, 1, 1, Smoke::mf_static, 293, 64},	//2978 Plasma::Wallpaper::trUtf8(const char*)
    {105, 537, 0, 0, Smoke::mf_ctor, 173, 65},	//2979 Plasma::Wallpaper::Wallpaper()
    {105, 1276, 0, 0, Smoke::mf_static, 242, 66},	//2980 Plasma::Wallpaper::listWallpaperInfo()
    {105, 1278, 89, 1, Smoke::mf_static, 242, 67},	//2981 Plasma::Wallpaper::listWallpaperInfoForMimetype(const QString&)
    {105, 1281, 89, 1, Smoke::mf_static, 173, 68},	//2982 Plasma::Wallpaper::load(const QString&)
    {105, 1281, 210, 1, Smoke::mf_static, 173, 69},	//2983 Plasma::Wallpaper::load(const KPluginInfo&)
    {105, 1415, 0, 0, Smoke::mf_static, 21, 70},	//2984 Plasma::Wallpaper::packageStructure()
    {105, 1726, 7, 1, Smoke::mf_protected, 0, 71},	//2985 Plasma::Wallpaper::setConfigurationRequired(bool)
    {105, 1559, 1010, 2, Smoke::mf_protected, 0, 72},	//2986 Plasma::Wallpaper::render(const QString&, const QSize&)
    {105, 1559, 1013, 3, Smoke::mf_protected, 0, 73},	//2987 Plasma::Wallpaper::render(const QString&, const QSize&, Plasma::Wallpaper::ResizeMethod)
    {105, 1559, 1017, 2, Smoke::mf_protected, 0, 74},	//2988 Plasma::Wallpaper::render(const QImage&, const QSize&)
    {105, 1559, 1020, 3, Smoke::mf_protected, 0, 75},	//2989 Plasma::Wallpaper::render(const QImage&, const QSize&, Plasma::Wallpaper::ResizeMethod)
    {105, 976, 1024, 2, Smoke::mf_protected, 386, 76},	//2990 Plasma::Wallpaper::findInCache(const QString&, QImage&)
    {105, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 77},	//2991 Plasma::Wallpaper::staticMetaObject() const
    {105, 789, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 256, 78},	//2992 Plasma::Wallpaper::contextActions() const
    {105, 1745, 1008, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 79},	//2993 Plasma::Wallpaper::setContextActions(const QList<QAction*>&)
    {105, 418, 0, 0, Smoke::mf_static|Smoke::mf_enum, 174, 80},	//2994 Plasma::Wallpaper::ScaledResize (enum)
    {105, 85, 0, 0, Smoke::mf_static|Smoke::mf_enum, 174, 81},	//2995 Plasma::Wallpaper::CenteredResize (enum)
    {105, 417, 0, 0, Smoke::mf_static|Smoke::mf_enum, 174, 82},	//2996 Plasma::Wallpaper::ScaledAndCroppedResize (enum)
    {105, 488, 0, 0, Smoke::mf_static|Smoke::mf_enum, 174, 83},	//2997 Plasma::Wallpaper::TiledResize (enum)
    {105, 84, 0, 0, Smoke::mf_static|Smoke::mf_enum, 174, 84},	//2998 Plasma::Wallpaper::CenterTiledResize (enum)
    {105, 308, 0, 0, Smoke::mf_static|Smoke::mf_enum, 174, 85},	//2999 Plasma::Wallpaper::MaxpectResize (enum)
    {105, 291, 0, 0, Smoke::mf_static|Smoke::mf_enum, 174, 86},	//3000 Plasma::Wallpaper::LastResizeMethod (enum)
    {105, 2479, 0, 0, Smoke::mf_dtor, 0, 87 },	//3001 Plasma::Wallpaper::~Wallpaper()
    {106, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//3002 Plasma::WallpaperScript::metaObject() const
    {106, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//3003 Plasma::WallpaperScript::qt_metacast(const char*)
    {106, 2304, 43, 2, Smoke::mf_static, 293, 3},	//3004 Plasma::WallpaperScript::tr(const char*, const char*)
    {106, 2308, 43, 2, Smoke::mf_static, 293, 4},	//3005 Plasma::WallpaperScript::trUtf8(const char*, const char*)
    {106, 2304, 46, 3, Smoke::mf_static, 293, 5},	//3006 Plasma::WallpaperScript::tr(const char*, const char*, int)
    {106, 2308, 46, 3, Smoke::mf_static, 293, 6},	//3007 Plasma::WallpaperScript::trUtf8(const char*, const char*, int)
    {106, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//3008 Plasma::WallpaperScript::qt_metacall(QMetaObject::Call, int, void**)
    {106, 541, 97, 1, Smoke::mf_ctor, 175, 8},	//3009 Plasma::WallpaperScript::WallpaperScript(QObject*)
    {106, 2141, 987, 1, 0, 0, 9},	//3010 Plasma::WallpaperScript::setWallpaper(Plasma::Wallpaper*)
    {106, 2385, 0, 0, Smoke::mf_const, 173, 10},	//3011 Plasma::WallpaperScript::wallpaper() const
    {106, 1096, 111, 1, Smoke::mf_virtual, 0, 11},	//3012 Plasma::WallpaperScript::initWallpaper(const KConfigGroup&)
    {106, 1420, 619, 2, Smoke::mf_virtual, 0, 12},	//3013 Plasma::WallpaperScript::paint(QPainter*, const QRectF&)
    {106, 1607, 178, 1, Smoke::mf_virtual, 0, 13},	//3014 Plasma::WallpaperScript::save(KConfigGroup&)
    {106, 805, 57, 1, Smoke::mf_virtual, 309, 14},	//3015 Plasma::WallpaperScript::createConfigurationInterface(QWidget*)
    {106, 1368, 278, 1, Smoke::mf_virtual, 0, 15},	//3016 Plasma::WallpaperScript::mouseMoveEvent(QGraphicsSceneMouseEvent*)
    {106, 1370, 278, 1, Smoke::mf_virtual, 0, 16},	//3017 Plasma::WallpaperScript::mousePressEvent(QGraphicsSceneMouseEvent*)
    {106, 1372, 278, 1, Smoke::mf_virtual, 0, 17},	//3018 Plasma::WallpaperScript::mouseReleaseEvent(QGraphicsSceneMouseEvent*)
    {106, 2389, 398, 1, Smoke::mf_virtual, 0, 18},	//3019 Plasma::WallpaperScript::wheelEvent(QGraphicsSceneWheelEvent*)
    {106, 2112, 1027, 1, 0, 0, 19},	//3020 Plasma::WallpaperScript::setUrls(const KUrl::List)
    {106, 1324, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 293, 20},	//3021 Plasma::WallpaperScript::mainScript() const
    {106, 1414, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 409, 21},	//3022 Plasma::WallpaperScript::package() const
    {106, 849, 0, 0, Smoke::mf_const|Smoke::mf_protected, 14, 22},	//3023 Plasma::WallpaperScript::description() const
    {106, 1136, 0, 0, Smoke::mf_const|Smoke::mf_protected, 386, 23},	//3024 Plasma::WallpaperScript::isInitialized() const
    {106, 704, 0, 0, Smoke::mf_const|Smoke::mf_protected, 283, 24},	//3025 Plasma::WallpaperScript::boundingRect() const
    {106, 839, 89, 1, Smoke::mf_const|Smoke::mf_protected, 81, 25},	//3026 Plasma::WallpaperScript::dataEngine(const QString&) const
    {106, 1994, 989, 1, Smoke::mf_protected, 0, 26},	//3027 Plasma::WallpaperScript::setResizeMethodHint(Plasma::Wallpaper::ResizeMethod)
    {106, 2074, 603, 1, Smoke::mf_protected, 0, 27},	//3028 Plasma::WallpaperScript::setTargetSizeHint(const QSizeF&)
    {106, 1726, 265, 2, Smoke::mf_protected, 0, 28},	//3029 Plasma::WallpaperScript::setConfigurationRequired(bool, const QString&)
    {106, 1559, 991, 4, Smoke::mf_protected, 0, 29},	//3030 Plasma::WallpaperScript::render(const QString&, const QSize&, Plasma::Wallpaper::ResizeMethod, const QColor&)
    {106, 2120, 7, 1, Smoke::mf_protected, 0, 30},	//3031 Plasma::WallpaperScript::setUsingRenderingCache(bool)
    {106, 976, 1001, 3, Smoke::mf_protected, 386, 31},	//3032 Plasma::WallpaperScript::findInCache(const QString&, QImage&, unsigned int)
    {106, 1102, 1005, 2, Smoke::mf_protected, 0, 32},	//3033 Plasma::WallpaperScript::insertIntoCache(const QString&, const QImage&)
    {106, 1747, 1008, 1, Smoke::mf_protected, 0, 33},	//3034 Plasma::WallpaperScript::setContextualActions(const QList<QAction*>&)
    {106, 2329, 653, 1, Smoke::mf_protected, 0, 34},	//3035 Plasma::WallpaperScript::update(const QRectF&)
    {106, 741, 0, 0, Smoke::mf_protected, 0, 35},	//3036 Plasma::WallpaperScript::configNeedsSaving()
    {106, 1566, 633, 1, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_slot, 0, 36},	//3037 Plasma::WallpaperScript::renderCompleted(const QImage&)
    {106, 2349, 119, 1, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_slot, 0, 37},	//3038 Plasma::WallpaperScript::urlDropped(const KUrl&)
    {106, 2304, 1, 1, Smoke::mf_static, 293, 38},	//3039 Plasma::WallpaperScript::tr(const char*)
    {106, 2308, 1, 1, Smoke::mf_static, 293, 39},	//3040 Plasma::WallpaperScript::trUtf8(const char*)
    {106, 541, 0, 0, Smoke::mf_ctor, 175, 40},	//3041 Plasma::WallpaperScript::WallpaperScript()
    {106, 1726, 7, 1, Smoke::mf_protected, 0, 41},	//3042 Plasma::WallpaperScript::setConfigurationRequired(bool)
    {106, 1559, 1010, 2, Smoke::mf_protected, 0, 42},	//3043 Plasma::WallpaperScript::render(const QString&, const QSize&)
    {106, 1559, 1013, 3, Smoke::mf_protected, 0, 43},	//3044 Plasma::WallpaperScript::render(const QString&, const QSize&, Plasma::Wallpaper::ResizeMethod)
    {106, 976, 1024, 2, Smoke::mf_protected, 386, 44},	//3045 Plasma::WallpaperScript::findInCache(const QString&, QImage&)
    {106, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 45},	//3046 Plasma::WallpaperScript::staticMetaObject() const
    {106, 2480, 0, 0, Smoke::mf_dtor, 0, 46 },	//3047 Plasma::WallpaperScript::~WallpaperScript()
    {107, 1351, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 442, 1},	//3048 Plasma::WebView::metaObject() const
    {107, 1487, 1, 1, Smoke::mf_virtual, 486, 2},	//3049 Plasma::WebView::qt_metacast(const char*)
    {107, 2304, 43, 2, Smoke::mf_static, 293, 3},	//3050 Plasma::WebView::tr(const char*, const char*)
    {107, 2308, 43, 2, Smoke::mf_static, 293, 4},	//3051 Plasma::WebView::trUtf8(const char*, const char*)
    {107, 2304, 46, 3, Smoke::mf_static, 293, 5},	//3052 Plasma::WebView::tr(const char*, const char*, int)
    {107, 2308, 46, 3, Smoke::mf_static, 293, 6},	//3053 Plasma::WebView::trUtf8(const char*, const char*, int)
    {107, 1485, 3, 3, Smoke::mf_virtual, 477, 7},	//3054 Plasma::WebView::qt_metacall(QMetaObject::Call, int, void**)
    {107, 544, 170, 1, Smoke::mf_ctor, 176, 8},	//3055 Plasma::WebView::WebView(QGraphicsItem*)
    {107, 2109, 119, 1, Smoke::mf_property, 0, 9},	//3056 Plasma::WebView::setUrl(const KUrl&)
    {107, 2346, 0, 0, Smoke::mf_const|Smoke::mf_property, 26, 10},	//3057 Plasma::WebView::url() const
    {107, 1853, 1029, 2, 0, 0, 11},	//3058 Plasma::WebView::setHtml(const QByteArray&, const KUrl&)
    {107, 1074, 0, 0, Smoke::mf_const|Smoke::mf_property, 293, 12},	//3059 Plasma::WebView::html() const
    {107, 1853, 1032, 2, 0, 0, 13},	//3060 Plasma::WebView::setHtml(const QString&, const KUrl&)
    {107, 1019, 0, 0, Smoke::mf_const, 283, 14},	//3061 Plasma::WebView::geometry() const
    {107, 787, 0, 0, Smoke::mf_const|Smoke::mf_property, 291, 15},	//3062 Plasma::WebView::contentsSize() const
    {107, 2007, 384, 1, Smoke::mf_property, 0, 16},	//3063 Plasma::WebView::setScrollPosition(const QPointF&)
    {107, 1635, 0, 0, Smoke::mf_const|Smoke::mf_property, 280, 17},	//3064 Plasma::WebView::scrollPosition() const
    {107, 2378, 0, 0, Smoke::mf_const|Smoke::mf_property, 283, 18},	//3065 Plasma::WebView::viewportGeometry() const
    {107, 2406, 0, 0, Smoke::mf_const, 474, 19},	//3066 Plasma::WebView::zoomFactor() const
    {107, 2157, 644, 1, 0, 0, 20},	//3067 Plasma::WebView::setZoomFactor(const double)
    {107, 1941, 1035, 1, 0, 0, 21},	//3068 Plasma::WebView::setPage(QWebPage*)
    {107, 1418, 0, 0, Smoke::mf_const, 307, 22},	//3069 Plasma::WebView::page() const
    {107, 1323, 0, 0, Smoke::mf_const, 306, 23},	//3070 Plasma::WebView::mainFrame() const
    {107, 1787, 7, 1, Smoke::mf_property, 0, 24},	//3071 Plasma::WebView::setDragToScroll(bool)
    {107, 882, 0, 0, Smoke::mf_property, 386, 25},	//3072 Plasma::WebView::dragToScroll()
    {107, 1828, 653, 1, Smoke::mf_virtual, 0, 26},	//3073 Plasma::WebView::setGeometry(const QRectF&)
    {107, 695, 0, 0, Smoke::mf_slot, 0, 27},	//3074 Plasma::WebView::back()
    {107, 1013, 0, 0, Smoke::mf_slot, 0, 28},	//3075 Plasma::WebView::forward()
    {107, 1518, 0, 0, Smoke::mf_slot, 0, 29},	//3076 Plasma::WebView::reload()
    {107, 2225, 0, 0, Smoke::mf_slot, 0, 30},	//3077 Plasma::WebView::stop()
    {107, 1307, 129, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 31},	//3078 Plasma::WebView::loadProgress(int)
    {107, 1299, 7, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 32},	//3079 Plasma::WebView::loadFinished(bool)
    {107, 2347, 195, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 33},	//3080 Plasma::WebView::urlChanged(const QUrl&)
    {107, 1420, 216, 3, Smoke::mf_protected|Smoke::mf_virtual, 0, 34},	//3081 Plasma::WebView::paint(QPainter*, const QStyleOptionGraphicsItem*, QWidget*)
    {107, 1368, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 35},	//3082 Plasma::WebView::mouseMoveEvent(QGraphicsSceneMouseEvent*)
    {107, 1072, 290, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 36},	//3083 Plasma::WebView::hoverMoveEvent(QGraphicsSceneHoverEvent*)
    {107, 1370, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 37},	//3084 Plasma::WebView::mousePressEvent(QGraphicsSceneMouseEvent*)
    {107, 1366, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 38},	//3085 Plasma::WebView::mouseDoubleClickEvent(QGraphicsSceneMouseEvent*)
    {107, 1372, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 39},	//3086 Plasma::WebView::mouseReleaseEvent(QGraphicsSceneMouseEvent*)
    {107, 794, 394, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 40},	//3087 Plasma::WebView::contextMenuEvent(QGraphicsSceneContextMenuEvent*)
    {107, 2389, 398, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 41},	//3088 Plasma::WebView::wheelEvent(QGraphicsSceneWheelEvent*)
    {107, 1198, 396, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 42},	//3089 Plasma::WebView::keyPressEvent(QKeyEvent*)
    {107, 1200, 396, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 43},	//3090 Plasma::WebView::keyReleaseEvent(QKeyEvent*)
    {107, 998, 280, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 44},	//3091 Plasma::WebView::focusInEvent(QFocusEvent*)
    {107, 1002, 280, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 45},	//3092 Plasma::WebView::focusOutEvent(QFocusEvent*)
    {107, 876, 400, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 46},	//3093 Plasma::WebView::dragEnterEvent(QGraphicsSceneDragDropEvent*)
    {107, 878, 400, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 47},	//3094 Plasma::WebView::dragLeaveEvent(QGraphicsSceneDragDropEvent*)
    {107, 880, 400, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 48},	//3095 Plasma::WebView::dragMoveEvent(QGraphicsSceneDragDropEvent*)
    {107, 906, 400, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 49},	//3096 Plasma::WebView::dropEvent(QGraphicsSceneDragDropEvent*)
    {107, 1179, 284, 2, Smoke::mf_protected|Smoke::mf_virtual, 304, 50},	//3097 Plasma::WebView::itemChange(QGraphicsItem::GraphicsItemChange, const QVariant&)
    {107, 2198, 287, 2, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 291, 51},	//3098 Plasma::WebView::sizeHint(Qt::SizeHint, const QSizeF&) const
    {107, 2304, 1, 1, Smoke::mf_static, 293, 52},	//3099 Plasma::WebView::tr(const char*)
    {107, 2308, 1, 1, Smoke::mf_static, 293, 53},	//3100 Plasma::WebView::trUtf8(const char*)
    {107, 544, 0, 0, Smoke::mf_ctor, 176, 54},	//3101 Plasma::WebView::WebView()
    {107, 1853, 1037, 1, 0, 0, 55},	//3102 Plasma::WebView::setHtml(const QByteArray&)
    {107, 1853, 89, 1, 0, 0, 56},	//3103 Plasma::WebView::setHtml(const QString&)
    {107, 1420, 328, 2, Smoke::mf_protected, 0, 57},	//3104 Plasma::WebView::paint(QPainter*, const QStyleOptionGraphicsItem*)
    {107, 2223, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 441, 58},	//3105 Plasma::WebView::staticMetaObject() const
    {107, 2481, 0, 0, Smoke::mf_dtor, 0, 59 },	//3106 Plasma::WebView::~WebView()
    {108, 952, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 386, 0},	//3107 QAbstractAnimation::event(QEvent*)
    {108, 2345, 766, 2, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3108 QAbstractAnimation::updateState(QAbstractAnimation::State, QAbstractAnimation::State)
    {108, 2337, 1039, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3109 QAbstractAnimation::updateDirection(QAbstractAnimation::Direction)
    {108, 187, 0, 0, Smoke::mf_static|Smoke::mf_enum, 180, 4},	//3110 QAbstractAnimation::Forward (enum)
    {108, 55, 0, 0, Smoke::mf_static|Smoke::mf_enum, 180, 5},	//3111 QAbstractAnimation::Backward (enum)
    {108, 460, 0, 0, Smoke::mf_static|Smoke::mf_enum, 181, 6},	//3112 QAbstractAnimation::Stopped (enum)
    {108, 366, 0, 0, Smoke::mf_static|Smoke::mf_enum, 181, 7},	//3113 QAbstractAnimation::Paused (enum)
    {108, 416, 0, 0, Smoke::mf_static|Smoke::mf_enum, 181, 8},	//3114 QAbstractAnimation::Running (enum)
    {109, 809, 1041, 3, Smoke::mf_const|Smoke::mf_virtual, 309, 0},	//3115 QAbstractItemDelegate::createEditor(QWidget*, const QStyleOptionViewItem&, const QModelIndex&) const
    {109, 1797, 1045, 2, Smoke::mf_const|Smoke::mf_virtual, 0, 0},	//3116 QAbstractItemDelegate::setEditorData(QWidget*, const QModelIndex&) const
    {109, 1920, 1048, 3, Smoke::mf_const|Smoke::mf_virtual, 0, 0},	//3117 QAbstractItemDelegate::setModelData(QWidget*, QAbstractItemModel*, const QModelIndex&) const
    {109, 2338, 1041, 3, Smoke::mf_const|Smoke::mf_virtual, 0, 0},	//3118 QAbstractItemDelegate::updateEditorGeometry(QWidget*, const QStyleOptionViewItem&, const QModelIndex&) const
    {109, 911, 1052, 4, Smoke::mf_virtual, 386, 0},	//3119 QAbstractItemDelegate::editorEvent(QEvent*, QAbstractItemModel*, const QStyleOptionViewItem&, const QModelIndex&)
    {111, 1364, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 290, 0},	//3120 QAbstractScrollArea::minimumSizeHint() const
    {130, 710, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3121 QFrame::changeEvent(QEvent*)
    {132, 639, 129, 1, Smoke::mf_virtual, 0, 0},	//3122 QGraphicsItem::advance(int)
    {132, 781, 384, 1, Smoke::mf_const|Smoke::mf_virtual, 386, 0},	//3123 QGraphicsItem::contains(const QPointF&) const
    {132, 733, 1057, 2, Smoke::mf_const|Smoke::mf_virtual, 386, 0},	//3124 QGraphicsItem::collidesWithItem(const QGraphicsItem*, Qt::ItemSelectionMode) const
    {132, 734, 1060, 2, Smoke::mf_const|Smoke::mf_virtual, 386, 0},	//3125 QGraphicsItem::collidesWithPath(const QPainterPath&, Qt::ItemSelectionMode) const
    {132, 1139, 29, 1, Smoke::mf_const|Smoke::mf_virtual, 386, 0},	//3126 QGraphicsItem::isObscuredBy(const QGraphicsItem*) const
    {132, 1398, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 276, 0},	//3127 QGraphicsItem::opaqueArea() const
    {132, 1621, 275, 2, Smoke::mf_protected|Smoke::mf_virtual, 386, 0},	//3128 QGraphicsItem::sceneEventFilter(QGraphicsItem*, QEvent*)
    {132, 794, 394, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3129 QGraphicsItem::contextMenuEvent(QGraphicsSceneContextMenuEvent*)
    {132, 876, 400, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3130 QGraphicsItem::dragEnterEvent(QGraphicsSceneDragDropEvent*)
    {132, 878, 400, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3131 QGraphicsItem::dragLeaveEvent(QGraphicsSceneDragDropEvent*)
    {132, 880, 400, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3132 QGraphicsItem::dragMoveEvent(QGraphicsSceneDragDropEvent*)
    {132, 906, 400, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3133 QGraphicsItem::dropEvent(QGraphicsSceneDragDropEvent*)
    {132, 1068, 290, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3134 QGraphicsItem::hoverEnterEvent(QGraphicsSceneHoverEvent*)
    {132, 1198, 396, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3135 QGraphicsItem::keyPressEvent(QKeyEvent*)
    {132, 1200, 396, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3136 QGraphicsItem::keyReleaseEvent(QKeyEvent*)
    {132, 1370, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3137 QGraphicsItem::mousePressEvent(QGraphicsSceneMouseEvent*)
    {132, 1368, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3138 QGraphicsItem::mouseMoveEvent(QGraphicsSceneMouseEvent*)
    {132, 1372, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3139 QGraphicsItem::mouseReleaseEvent(QGraphicsSceneMouseEvent*)
    {132, 1366, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3140 QGraphicsItem::mouseDoubleClickEvent(QGraphicsSceneMouseEvent*)
    {132, 2389, 398, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3141 QGraphicsItem::wheelEvent(QGraphicsSceneWheelEvent*)
    {132, 1100, 1063, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3142 QGraphicsItem::inputMethodEvent(QInputMethodEvent*)
    {132, 1101, 1065, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 304, 0},	//3143 QGraphicsItem::inputMethodQuery(Qt::InputMethodQuery) const
    {132, 2241, 1067, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 386, 0},	//3144 QGraphicsItem::supportsExtension(QGraphicsItem::Extension) const
    {132, 1813, 1069, 2, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3145 QGraphicsItem::setExtension(QGraphicsItem::Extension, const QVariant&)
    {132, 969, 739, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 304, 0},	//3146 QGraphicsItem::extension(const QVariant&) const
    {132, 257, 0, 0, Smoke::mf_static|Smoke::mf_enum, 217, 26},	//3147 QGraphicsItem::ItemPositionChange (enum)
    {132, 251, 0, 0, Smoke::mf_static|Smoke::mf_enum, 217, 27},	//3148 QGraphicsItem::ItemMatrixChange (enum)
    {132, 280, 0, 0, Smoke::mf_static|Smoke::mf_enum, 217, 28},	//3149 QGraphicsItem::ItemVisibleChange (enum)
    {132, 238, 0, 0, Smoke::mf_static|Smoke::mf_enum, 217, 29},	//3150 QGraphicsItem::ItemEnabledChange (enum)
    {132, 266, 0, 0, Smoke::mf_static|Smoke::mf_enum, 217, 30},	//3151 QGraphicsItem::ItemSelectedChange (enum)
    {132, 255, 0, 0, Smoke::mf_static|Smoke::mf_enum, 217, 31},	//3152 QGraphicsItem::ItemParentChange (enum)
    {132, 230, 0, 0, Smoke::mf_static|Smoke::mf_enum, 217, 32},	//3153 QGraphicsItem::ItemChildAddedChange (enum)
    {132, 231, 0, 0, Smoke::mf_static|Smoke::mf_enum, 217, 33},	//3154 QGraphicsItem::ItemChildRemovedChange (enum)
    {132, 275, 0, 0, Smoke::mf_static|Smoke::mf_enum, 217, 34},	//3155 QGraphicsItem::ItemTransformChange (enum)
    {132, 258, 0, 0, Smoke::mf_static|Smoke::mf_enum, 217, 35},	//3156 QGraphicsItem::ItemPositionHasChanged (enum)
    {132, 276, 0, 0, Smoke::mf_static|Smoke::mf_enum, 217, 36},	//3157 QGraphicsItem::ItemTransformHasChanged (enum)
    {132, 263, 0, 0, Smoke::mf_static|Smoke::mf_enum, 217, 37},	//3158 QGraphicsItem::ItemSceneChange (enum)
    {132, 281, 0, 0, Smoke::mf_static|Smoke::mf_enum, 217, 38},	//3159 QGraphicsItem::ItemVisibleHasChanged (enum)
    {132, 239, 0, 0, Smoke::mf_static|Smoke::mf_enum, 217, 39},	//3160 QGraphicsItem::ItemEnabledHasChanged (enum)
    {132, 267, 0, 0, Smoke::mf_static|Smoke::mf_enum, 217, 40},	//3161 QGraphicsItem::ItemSelectedHasChanged (enum)
    {132, 256, 0, 0, Smoke::mf_static|Smoke::mf_enum, 217, 41},	//3162 QGraphicsItem::ItemParentHasChanged (enum)
    {132, 264, 0, 0, Smoke::mf_static|Smoke::mf_enum, 217, 42},	//3163 QGraphicsItem::ItemSceneHasChanged (enum)
    {132, 235, 0, 0, Smoke::mf_static|Smoke::mf_enum, 217, 43},	//3164 QGraphicsItem::ItemCursorChange (enum)
    {132, 236, 0, 0, Smoke::mf_static|Smoke::mf_enum, 217, 44},	//3165 QGraphicsItem::ItemCursorHasChanged (enum)
    {132, 273, 0, 0, Smoke::mf_static|Smoke::mf_enum, 217, 45},	//3166 QGraphicsItem::ItemToolTipChange (enum)
    {132, 274, 0, 0, Smoke::mf_static|Smoke::mf_enum, 217, 46},	//3167 QGraphicsItem::ItemToolTipHasChanged (enum)
    {132, 240, 0, 0, Smoke::mf_static|Smoke::mf_enum, 217, 47},	//3168 QGraphicsItem::ItemFlagsChange (enum)
    {132, 241, 0, 0, Smoke::mf_static|Smoke::mf_enum, 217, 48},	//3169 QGraphicsItem::ItemFlagsHaveChanged (enum)
    {132, 282, 0, 0, Smoke::mf_static|Smoke::mf_enum, 217, 49},	//3170 QGraphicsItem::ItemZValueChange (enum)
    {132, 283, 0, 0, Smoke::mf_static|Smoke::mf_enum, 217, 50},	//3171 QGraphicsItem::ItemZValueHasChanged (enum)
    {132, 253, 0, 0, Smoke::mf_static|Smoke::mf_enum, 217, 51},	//3172 QGraphicsItem::ItemOpacityChange (enum)
    {132, 254, 0, 0, Smoke::mf_static|Smoke::mf_enum, 217, 52},	//3173 QGraphicsItem::ItemOpacityHasChanged (enum)
    {132, 265, 0, 0, Smoke::mf_static|Smoke::mf_enum, 217, 53},	//3174 QGraphicsItem::ItemScenePositionHasChanged (enum)
    {132, 259, 0, 0, Smoke::mf_static|Smoke::mf_enum, 217, 54},	//3175 QGraphicsItem::ItemRotationChange (enum)
    {132, 260, 0, 0, Smoke::mf_static|Smoke::mf_enum, 217, 55},	//3176 QGraphicsItem::ItemRotationHasChanged (enum)
    {132, 261, 0, 0, Smoke::mf_static|Smoke::mf_enum, 217, 56},	//3177 QGraphicsItem::ItemScaleChange (enum)
    {132, 262, 0, 0, Smoke::mf_static|Smoke::mf_enum, 217, 57},	//3178 QGraphicsItem::ItemScaleHasChanged (enum)
    {132, 277, 0, 0, Smoke::mf_static|Smoke::mf_enum, 217, 58},	//3179 QGraphicsItem::ItemTransformOriginPointChange (enum)
    {132, 278, 0, 0, Smoke::mf_static|Smoke::mf_enum, 217, 59},	//3180 QGraphicsItem::ItemTransformOriginPointHasChanged (enum)
    {132, 508, 0, 0, Smoke::mf_static|Smoke::mf_enum, 479, 60},	//3181 QGraphicsItem::Type (enum)
    {132, 518, 0, 0, Smoke::mf_static|Smoke::mf_enum, 479, 61},	//3182 QGraphicsItem::UserType (enum)
    {132, 515, 0, 0, Smoke::mf_static|Smoke::mf_enum, 216, 62},	//3183 QGraphicsItem::UserExtension (enum)
    {135, 1828, 653, 1, Smoke::mf_virtual, 0, 0},	//3184 QGraphicsProxyWidget::setGeometry(const QRectF&)
    {135, 1420, 216, 3, Smoke::mf_virtual, 0, 0},	//3185 QGraphicsProxyWidget::paint(QPainter*, const QStyleOptionGraphicsItem*, QWidget*)
    {135, 2313, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 477, 0},	//3186 QGraphicsProxyWidget::type() const
    {135, 1179, 284, 2, Smoke::mf_protected|Smoke::mf_virtual, 304, 0},	//3187 QGraphicsProxyWidget::itemChange(QGraphicsItem::GraphicsItemChange, const QVariant&)
    {135, 952, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 386, 0},	//3188 QGraphicsProxyWidget::event(QEvent*)
    {135, 954, 272, 2, Smoke::mf_protected|Smoke::mf_virtual, 386, 0},	//3189 QGraphicsProxyWidget::eventFilter(QObject*, QEvent*)
    {135, 2177, 324, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3190 QGraphicsProxyWidget::showEvent(QShowEvent*)
    {135, 1059, 326, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3191 QGraphicsProxyWidget::hideEvent(QHideEvent*)
    {135, 794, 394, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3192 QGraphicsProxyWidget::contextMenuEvent(QGraphicsSceneContextMenuEvent*)
    {135, 876, 400, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3193 QGraphicsProxyWidget::dragEnterEvent(QGraphicsSceneDragDropEvent*)
    {135, 878, 400, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3194 QGraphicsProxyWidget::dragLeaveEvent(QGraphicsSceneDragDropEvent*)
    {135, 880, 400, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3195 QGraphicsProxyWidget::dragMoveEvent(QGraphicsSceneDragDropEvent*)
    {135, 906, 400, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3196 QGraphicsProxyWidget::dropEvent(QGraphicsSceneDragDropEvent*)
    {135, 1068, 290, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3197 QGraphicsProxyWidget::hoverEnterEvent(QGraphicsSceneHoverEvent*)
    {135, 1070, 290, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3198 QGraphicsProxyWidget::hoverLeaveEvent(QGraphicsSceneHoverEvent*)
    {135, 1072, 290, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3199 QGraphicsProxyWidget::hoverMoveEvent(QGraphicsSceneHoverEvent*)
    {135, 1032, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3200 QGraphicsProxyWidget::grabMouseEvent(QEvent*)
    {135, 2315, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3201 QGraphicsProxyWidget::ungrabMouseEvent(QEvent*)
    {135, 1368, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3202 QGraphicsProxyWidget::mouseMoveEvent(QGraphicsSceneMouseEvent*)
    {135, 1370, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3203 QGraphicsProxyWidget::mousePressEvent(QGraphicsSceneMouseEvent*)
    {135, 1372, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3204 QGraphicsProxyWidget::mouseReleaseEvent(QGraphicsSceneMouseEvent*)
    {135, 1366, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3205 QGraphicsProxyWidget::mouseDoubleClickEvent(QGraphicsSceneMouseEvent*)
    {135, 2389, 398, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3206 QGraphicsProxyWidget::wheelEvent(QGraphicsSceneWheelEvent*)
    {135, 1198, 396, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3207 QGraphicsProxyWidget::keyPressEvent(QKeyEvent*)
    {135, 1200, 396, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3208 QGraphicsProxyWidget::keyReleaseEvent(QKeyEvent*)
    {135, 998, 280, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3209 QGraphicsProxyWidget::focusInEvent(QFocusEvent*)
    {135, 1002, 280, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3210 QGraphicsProxyWidget::focusOutEvent(QFocusEvent*)
    {135, 1001, 7, 1, Smoke::mf_protected|Smoke::mf_virtual, 386, 0},	//3211 QGraphicsProxyWidget::focusNextPrevChild(bool)
    {135, 2198, 287, 2, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 291, 0},	//3212 QGraphicsProxyWidget::sizeHint(Qt::SizeHint, const QSizeF&) const
    {135, 1584, 282, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3213 QGraphicsProxyWidget::resizeEvent(QGraphicsSceneResizeEvent*)
    {135, 508, 0, 0, Smoke::mf_static|Smoke::mf_enum, 479, 31},	//3214 QGraphicsProxyWidget::Type (enum)
    {136, 1101, 1065, 1, Smoke::mf_const|Smoke::mf_virtual, 304, 0},	//3215 QGraphicsScene::inputMethodQuery(Qt::InputMethodQuery) const
    {136, 952, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 386, 0},	//3216 QGraphicsScene::event(QEvent*)
    {136, 954, 272, 2, Smoke::mf_protected|Smoke::mf_virtual, 386, 0},	//3217 QGraphicsScene::eventFilter(QObject*, QEvent*)
    {136, 794, 394, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3218 QGraphicsScene::contextMenuEvent(QGraphicsSceneContextMenuEvent*)
    {136, 906, 400, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3219 QGraphicsScene::dropEvent(QGraphicsSceneDragDropEvent*)
    {136, 998, 280, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3220 QGraphicsScene::focusInEvent(QFocusEvent*)
    {136, 1002, 280, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3221 QGraphicsScene::focusOutEvent(QFocusEvent*)
    {136, 1055, 1072, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3222 QGraphicsScene::helpEvent(QGraphicsSceneHelpEvent*)
    {136, 1198, 396, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3223 QGraphicsScene::keyPressEvent(QKeyEvent*)
    {136, 1200, 396, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3224 QGraphicsScene::keyReleaseEvent(QKeyEvent*)
    {136, 1370, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3225 QGraphicsScene::mousePressEvent(QGraphicsSceneMouseEvent*)
    {136, 1368, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3226 QGraphicsScene::mouseMoveEvent(QGraphicsSceneMouseEvent*)
    {136, 1372, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3227 QGraphicsScene::mouseReleaseEvent(QGraphicsSceneMouseEvent*)
    {136, 1366, 278, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3228 QGraphicsScene::mouseDoubleClickEvent(QGraphicsSceneMouseEvent*)
    {136, 2389, 398, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3229 QGraphicsScene::wheelEvent(QGraphicsSceneWheelEvent*)
    {136, 1100, 1063, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3230 QGraphicsScene::inputMethodEvent(QInputMethodEvent*)
    {136, 887, 619, 2, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3231 QGraphicsScene::drawBackground(QPainter*, const QRectF&)
    {136, 889, 619, 2, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3232 QGraphicsScene::drawForeground(QPainter*, const QRectF&)
    {136, 892, 1074, 5, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3233 QGraphicsScene::drawItems(QPainter*, int, QGraphicsItem**, const QStyleOptionGraphicsItem*, QWidget*)
    {145, 2198, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 290, 0},	//3234 QGraphicsView::sizeHint() const
    {145, 1101, 1065, 1, Smoke::mf_const|Smoke::mf_virtual, 304, 0},	//3235 QGraphicsView::inputMethodQuery(Qt::InputMethodQuery) const
    {145, 952, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 386, 0},	//3236 QGraphicsView::event(QEvent*)
    {145, 2377, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 386, 0},	//3237 QGraphicsView::viewportEvent(QEvent*)
    {145, 794, 1080, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3238 QGraphicsView::contextMenuEvent(QContextMenuEvent*)
    {145, 876, 1082, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3239 QGraphicsView::dragEnterEvent(QDragEnterEvent*)
    {145, 878, 1084, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3240 QGraphicsView::dragLeaveEvent(QDragLeaveEvent*)
    {145, 880, 1086, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3241 QGraphicsView::dragMoveEvent(QDragMoveEvent*)
    {145, 906, 1088, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3242 QGraphicsView::dropEvent(QDropEvent*)
    {145, 998, 280, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3243 QGraphicsView::focusInEvent(QFocusEvent*)
    {145, 1001, 7, 1, Smoke::mf_protected|Smoke::mf_virtual, 386, 0},	//3244 QGraphicsView::focusNextPrevChild(bool)
    {145, 1002, 280, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3245 QGraphicsView::focusOutEvent(QFocusEvent*)
    {145, 1198, 396, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3246 QGraphicsView::keyPressEvent(QKeyEvent*)
    {145, 1200, 396, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3247 QGraphicsView::keyReleaseEvent(QKeyEvent*)
    {145, 1366, 551, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3248 QGraphicsView::mouseDoubleClickEvent(QMouseEvent*)
    {145, 1370, 551, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3249 QGraphicsView::mousePressEvent(QMouseEvent*)
    {145, 1368, 551, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3250 QGraphicsView::mouseMoveEvent(QMouseEvent*)
    {145, 1372, 551, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3251 QGraphicsView::mouseReleaseEvent(QMouseEvent*)
    {145, 2389, 1090, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3252 QGraphicsView::wheelEvent(QWheelEvent*)
    {145, 1429, 547, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3253 QGraphicsView::paintEvent(QPaintEvent*)
    {145, 1584, 549, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3254 QGraphicsView::resizeEvent(QResizeEvent*)
    {145, 1634, 370, 2, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3255 QGraphicsView::scrollContentsBy(int, int)
    {145, 2177, 324, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3256 QGraphicsView::showEvent(QShowEvent*)
    {145, 1100, 1063, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3257 QGraphicsView::inputMethodEvent(QInputMethodEvent*)
    {145, 887, 619, 2, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3258 QGraphicsView::drawBackground(QPainter*, const QRectF&)
    {145, 889, 619, 2, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3259 QGraphicsView::drawForeground(QPainter*, const QRectF&)
    {145, 892, 1092, 4, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3260 QGraphicsView::drawItems(QPainter*, int, QGraphicsItem**, const QStyleOptionGraphicsItem*)
    {146, 1828, 653, 1, Smoke::mf_property|Smoke::mf_virtual, 0, 0},	//3261 QGraphicsWidget::setGeometry(const QRectF&)
    {146, 1021, 1097, 4, Smoke::mf_const|Smoke::mf_virtual, 0, 0},	//3262 QGraphicsWidget::getContentsMargins(double*, double*, double*, double*) const
    {146, 2313, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 477, 0},	//3263 QGraphicsWidget::type() const
    {146, 1420, 216, 3, Smoke::mf_virtual, 0, 0},	//3264 QGraphicsWidget::paint(QPainter*, const QStyleOptionGraphicsItem*, QWidget*)
    {146, 1439, 216, 3, Smoke::mf_virtual, 0, 0},	//3265 QGraphicsWidget::paintWindowFrame(QPainter*, const QStyleOptionGraphicsItem*, QWidget*)
    {146, 704, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 283, 0},	//3266 QGraphicsWidget::boundingRect() const
    {146, 2161, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 276, 0},	//3267 QGraphicsWidget::shape() const
    {146, 1095, 1102, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3268 QGraphicsWidget::initStyleOption(QStyleOption*) const
    {146, 2198, 287, 2, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 291, 0},	//3269 QGraphicsWidget::sizeHint(Qt::SizeHint, const QSizeF&) const
    {146, 2339, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3270 QGraphicsWidget::updateGeometry()
    {146, 1179, 284, 2, Smoke::mf_protected|Smoke::mf_virtual, 304, 0},	//3271 QGraphicsWidget::itemChange(QGraphicsItem::GraphicsItemChange, const QVariant&)
    {146, 1482, 482, 2, Smoke::mf_protected|Smoke::mf_virtual, 304, 0},	//3272 QGraphicsWidget::propertyChange(const QString&, const QVariant&)
    {146, 1620, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 386, 0},	//3273 QGraphicsWidget::sceneEvent(QEvent*)
    {146, 2393, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 386, 0},	//3274 QGraphicsWidget::windowFrameEvent(QEvent*)
    {146, 2394, 384, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 380, 0},	//3275 QGraphicsWidget::windowFrameSectionAt(const QPointF&) const
    {146, 952, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 386, 0},	//3276 QGraphicsWidget::event(QEvent*)
    {146, 710, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3277 QGraphicsWidget::changeEvent(QEvent*)
    {146, 730, 1104, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3278 QGraphicsWidget::closeEvent(QCloseEvent*)
    {146, 998, 280, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3279 QGraphicsWidget::focusInEvent(QFocusEvent*)
    {146, 1001, 7, 1, Smoke::mf_protected|Smoke::mf_virtual, 386, 0},	//3280 QGraphicsWidget::focusNextPrevChild(bool)
    {146, 1002, 280, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3281 QGraphicsWidget::focusOutEvent(QFocusEvent*)
    {146, 1059, 326, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3282 QGraphicsWidget::hideEvent(QHideEvent*)
    {146, 1374, 577, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3283 QGraphicsWidget::moveEvent(QGraphicsSceneMoveEvent*)
    {146, 1460, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3284 QGraphicsWidget::polishEvent()
    {146, 1584, 282, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3285 QGraphicsWidget::resizeEvent(QGraphicsSceneResizeEvent*)
    {146, 2177, 324, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3286 QGraphicsWidget::showEvent(QShowEvent*)
    {146, 1072, 290, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3287 QGraphicsWidget::hoverMoveEvent(QGraphicsSceneHoverEvent*)
    {146, 1070, 290, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3288 QGraphicsWidget::hoverLeaveEvent(QGraphicsSceneHoverEvent*)
    {146, 1032, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3289 QGraphicsWidget::grabMouseEvent(QEvent*)
    {146, 2315, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3290 QGraphicsWidget::ungrabMouseEvent(QEvent*)
    {146, 1031, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3291 QGraphicsWidget::grabKeyboardEvent(QEvent*)
    {146, 2314, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3292 QGraphicsWidget::ungrabKeyboardEvent(QEvent*)
    {146, 508, 0, 0, Smoke::mf_static|Smoke::mf_enum, 479, 33},	//3293 QGraphicsWidget::Type (enum)
    {162, 952, 331, 1, Smoke::mf_virtual, 386, 0},	//3294 QObject::event(QEvent*)
    {162, 954, 272, 2, Smoke::mf_virtual, 386, 0},	//3295 QObject::eventFilter(QObject*, QEvent*)
    {162, 2289, 176, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3296 QObject::timerEvent(QTimerEvent*)
    {162, 716, 1106, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3297 QObject::childEvent(QChildEvent*)
    {162, 836, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3298 QObject::customEvent(QEvent*)
    {162, 753, 1, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3299 QObject::connectNotify(const char*)
    {162, 867, 1, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3300 QObject::disconnectNotify(const char*)
    {198, 857, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 477, 0},	//3301 QWidget::devType() const
    {198, 2140, 7, 1, Smoke::mf_property|Smoke::mf_virtual|Smoke::mf_slot, 0, 0},	//3302 QWidget::setVisible(bool)
    {198, 2198, 0, 0, Smoke::mf_const|Smoke::mf_property|Smoke::mf_virtual, 290, 0},	//3303 QWidget::sizeHint() const
    {198, 1364, 0, 0, Smoke::mf_const|Smoke::mf_property|Smoke::mf_virtual, 290, 0},	//3304 QWidget::minimumSizeHint() const
    {198, 1054, 129, 1, Smoke::mf_const|Smoke::mf_virtual, 477, 0},	//3305 QWidget::heightForWidth(int) const
    {198, 1428, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 272, 0},	//3306 QWidget::paintEngine() const
    {198, 1366, 551, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3307 QWidget::mouseDoubleClickEvent(QMouseEvent*)
    {198, 2389, 1090, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3308 QWidget::wheelEvent(QWheelEvent*)
    {198, 1200, 396, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3309 QWidget::keyReleaseEvent(QKeyEvent*)
    {198, 1002, 280, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3310 QWidget::focusOutEvent(QFocusEvent*)
    {198, 948, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3311 QWidget::enterEvent(QEvent*)
    {198, 1228, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3312 QWidget::leaveEvent(QEvent*)
    {198, 1374, 553, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3313 QWidget::moveEvent(QMoveEvent*)
    {198, 730, 1104, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3314 QWidget::closeEvent(QCloseEvent*)
    {198, 794, 1080, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3315 QWidget::contextMenuEvent(QContextMenuEvent*)
    {198, 2261, 1108, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3316 QWidget::tabletEvent(QTabletEvent*)
    {198, 559, 1110, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3317 QWidget::actionEvent(QActionEvent*)
    {198, 876, 1082, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3318 QWidget::dragEnterEvent(QDragEnterEvent*)
    {198, 880, 1086, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3319 QWidget::dragMoveEvent(QDragMoveEvent*)
    {198, 878, 1084, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3320 QWidget::dragLeaveEvent(QDragLeaveEvent*)
    {198, 906, 1088, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3321 QWidget::dropEvent(QDropEvent*)
    {198, 1059, 326, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3322 QWidget::hideEvent(QHideEvent*)
    {198, 2405, 1112, 1, Smoke::mf_protected|Smoke::mf_virtual, 386, 0},	//3323 QWidget::x11Event(_XEvent*)
    {198, 710, 331, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3324 QWidget::changeEvent(QEvent*)
    {198, 1354, 1114, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 477, 0},	//3325 QWidget::metric(QPaintDevice::PaintDeviceMetric) const
    {198, 1100, 1063, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3326 QWidget::inputMethodEvent(QInputMethodEvent*)
    {198, 1101, 1065, 1, Smoke::mf_const|Smoke::mf_virtual, 304, 0},	//3327 QWidget::inputMethodQuery(Qt::InputMethodQuery) const
    {198, 1001, 7, 1, Smoke::mf_protected|Smoke::mf_virtual, 386, 0},	//3328 QWidget::focusNextPrevChild(bool)
    {198, 2235, 1116, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3329 QWidget::styleChange(QStyle&)
    {198, 941, 7, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3330 QWidget::enabledChange(bool)
    {198, 1441, 1118, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3331 QWidget::paletteChange(const QPalette&)
    {198, 1007, 579, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3332 QWidget::fontChange(const QFont&)
    {198, 2392, 7, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3333 QWidget::windowActivationChange(bool)
    {198, 1216, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3334 QWidget::languageChange()
};

static Smoke::Index ambiguousMethodList[] = {
    0,
    987,  // Plasma::Corona::importLayout(const KConfigBase&)
    989,  // Plasma::Corona::importLayout(const KConfigGroup&)
    0,
    1007,  // Plasma::Corona::mapAnimation(Plasma::Animator::Animation, Plasma::Animator::Animation)
    1008,  // Plasma::Corona::mapAnimation(Plasma::Animator::Animation, const QString&)
    0,
    18,  // Plasma::loadScriptEngine(const QString&, Plasma::AbstractRunner*)
    25,  // Plasma::loadScriptEngine(const QString&, Plasma::Applet*)
    26,  // Plasma::loadScriptEngine(const QString&, Plasma::DataEngine*)
    33,  // Plasma::loadScriptEngine(const QString&, Plasma::Wallpaper*)
    0,
    1926,  // Plasma::PushButton::setIcon(const QIcon&)
    1927,  // Plasma::PushButton::setIcon(const KIcon&)
    0,
    2507,  // Plasma::Svg::paint(QPainter*, const QPointF&)
    2509,  // Plasma::Svg::paint(QPainter*, const QRectF&)
    0,
    2480,  // Plasma::Svg::paint(QPainter*, const QPointF&, const QString&)
    2482,  // Plasma::Svg::paint(QPainter*, const QRectF&, const QString&)
    0,
    535,  // Plasma::Applet::Applet(QGraphicsItem*)
    537,  // Plasma::Applet::Applet(const KPluginInfo&)
    0,
    1067,  // Plasma::DataEngine::DataEngine(QObject*, KSharedPtr<KService>)
    1068,  // Plasma::DataEngine::DataEngine(QObject*, const QList<QVariant>&)
    0,
    345,  // Plasma::Animator::create(Plasma::Animator::CurveShape)
    365,  // Plasma::Animator::create(Plasma::Animator::Animation)
    366,  // Plasma::Animator::create(const QString&)
    0,
    343,  // Plasma::Animator::create(Plasma::Animator::Animation, QObject*)
    344,  // Plasma::Animator::create(const QString&, QObject*)
    0,
    214,  // Plasma::AbstractToolBox::AbstractToolBox(Plasma::Containment*)
    231,  // Plasma::AbstractToolBox::AbstractToolBox(QObject*)
    0,
    924,  // Plasma::ContainmentActionsPluginsConfig::addPlugin(QFlags<Qt::KeyboardModifier>, Qt::MouseButton, const QString&)
    925,  // Plasma::ContainmentActionsPluginsConfig::addPlugin(QFlags<Qt::KeyboardModifier>, Qt::Orientation, const QString&)
    0,
    2212,  // Plasma::ScrollWidget::ScrollWidget(QGraphicsWidget*)
    2213,  // Plasma::ScrollWidget::ScrollWidget(QGraphicsItem*)
    0,
    1952,  // Plasma::QueryMatch::QueryMatch(Plasma::AbstractRunner*)
    1953,  // Plasma::QueryMatch::QueryMatch(const Plasma::QueryMatch&)
    0,
    870,  // Plasma::Containment::StyleOption::StyleOption(const Plasma::Containment::StyleOption&)
    871,  // Plasma::Containment::StyleOption::StyleOption(const QStyleOptionGraphicsItem&)
    0,
    2291,  // Plasma::Service::associateWidget(QWidget*, const QString&)
    2293,  // Plasma::Service::associateWidget(QGraphicsWidget*, const QString&)
    0,
    2292,  // Plasma::Service::disassociateWidget(QWidget*)
    2294,  // Plasma::Service::disassociateWidget(QGraphicsWidget*)
    0,
    2064,  // Plasma::RunnerManager::RunnerManager(QObject*)
    2101,  // Plasma::RunnerManager::RunnerManager(KConfigGroup&)
    0,
    2020,  // Plasma::RunnerContext::RunnerContext(QObject*)
    2045,  // Plasma::RunnerContext::RunnerContext(Plasma::RunnerContext&)
    0,
    2534,  // Plasma::SvgWidget::SvgWidget(QGraphicsItem*)
    2535,  // Plasma::SvgWidget::SvgWidget(Plasma::Svg*)
    0,
    2520,  // Plasma::SvgWidget::SvgWidget(QGraphicsItem*, QFlags<Qt::WindowType>)
    2536,  // Plasma::SvgWidget::SvgWidget(Plasma::Svg*, const QString&)
    0,
    1468,  // Plasma::FrameSvg::hasElementPrefix(const QString&) const
    1469,  // Plasma::FrameSvg::hasElementPrefix(Plasma::Location) const
    0,
    1478,  // Plasma::FrameSvg::paintFrame(QPainter*, const QPointF&)
    1482,  // Plasma::FrameSvg::paintFrame(QPainter*, const QRectF&)
    0,
    1466,  // Plasma::FrameSvg::setElementPrefix(Plasma::Location)
    1467,  // Plasma::FrameSvg::setElementPrefix(const QString&)
    0,
    2751,  // Plasma::ToolTipContent::ToolTipContent(const QString&, const QString&, const QPixmap&)
    2752,  // Plasma::ToolTipContent::ToolTipContent(const QString&, const QString&, const QIcon&)
    0,
    2759,  // Plasma::ToolTipContent::setImage(const QPixmap&)
    2760,  // Plasma::ToolTipContent::setImage(const QIcon&)
    0,
};

// Class ID, munged name ID (index into methodNames), method def (see methods) if >0 or number of overloads if <0
static Smoke::MethodMap methodMaps[] = {
    {0, 0, 0},	//0 (no method)
    {27, 12, 109},	// Plasma::AcceptingInputStatus
    {27, 18, 107},	// Plasma::ActiveStatus
    {27, 20, 51},	// Plasma::AlignToHour
    {27, 21, 50},	// Plasma::AlignToMinute
    {27, 24, 101},	// Plasma::AllConstraints
    {27, 36, 116},	// Plasma::AnimatorComponent
    {27, 46, 113},	// Plasma::AppletComponent
    {27, 49, 90},	// Plasma::AppletType
    {27, 50, 43},	// Plasma::Application
    {27, 59, 124},	// Plasma::BottomEdge
    {27, 60, 53},	// Plasma::BottomMargin
    {27, 61, 86},	// Plasma::BottomPosedLeftAlignedPopup
    {27, 62, 87},	// Plasma::BottomPosedRightAlignedPopup
    {27, 63, 65},	// Plasma::BottomPositioned
    {27, 71, 48},	// Plasma::ButtonCancel
    {27, 74, 47},	// Plasma::ButtonNo
    {27, 75, 44},	// Plasma::ButtonNone
    {27, 76, 45},	// Plasma::ButtonOk
    {27, 78, 46},	// Plasma::ButtonYes
    {27, 83, 66},	// Plasma::CenterPositioned
    {27, 100, 60},	// Plasma::ConstrainedSquare
    {27, 111, 117},	// Plasma::ContainmentComponent
    {27, 114, 99},	// Plasma::ContextConstraint
    {27, 127, 114},	// Plasma::DataEngineComponent
    {27, 140, 121},	// Plasma::Desktop
    {27, 143, 110},	// Plasma::DesktopZoom
    {27, 155, 67},	// Plasma::Down
    {27, 180, 61},	// Plasma::FixedSize
    {27, 183, 120},	// Plasma::Floating
    {27, 184, 81},	// Plasma::FloatingPopup
    {27, 186, 93},	// Plasma::FormFactorConstraint
    {27, 192, 122},	// Plasma::FullScreen
    {27, 197, 119},	// Plasma::GenericComponent
    {27, 201, 111},	// Plasma::GroupZoom
    {27, 209, 41},	// Plasma::Horizontal
    {27, 210, 103},	// Plasma::HorizontalFlip
    {27, 218, 57},	// Plasma::IgnoreAspectRatio
    {27, 221, 97},	// Plasma::ImmutableConstraint
    {27, 225, 56},	// Plasma::InvalidAspectRatioMode
    {27, 226, 73},	// Plasma::InvalidCredentials
    {27, 284, 58},	// Plasma::KeepAspectRatio
    {27, 292, 69},	// Plasma::Left
    {27, 294, 125},	// Plasma::LeftEdge
    {27, 295, 54},	// Plasma::LeftMargin
    {27, 296, 85},	// Plasma::LeftPosedBottomAlignedPopup
    {27, 297, 84},	// Plasma::LeftPosedTopAlignedPopup
    {27, 298, 62},	// Plasma::LeftPositioned
    {27, 301, 91},	// Plasma::LineEditType
    {27, 304, 94},	// Plasma::LocationConstraint
    {27, 309, 40},	// Plasma::MediaCenter
    {27, 319, 78},	// Plasma::Mutable
    {27, 320, 108},	// Plasma::NeedsAttentionStatus
    {27, 323, 49},	// Plasma::NoAlignment
    {27, 325, 71},	// Plasma::NoAnnouncement
    {27, 331, 92},	// Plasma::NoConstraint
    {27, 337, 102},	// Plasma::NoFlip
    {27, 350, 112},	// Plasma::OverviewZoom
    {27, 364, 106},	// Plasma::PassiveStatus
    {27, 373, 39},	// Plasma::Planar
    {27, 380, 100},	// Plasma::PopupConstraint
    {27, 394, 70},	// Plasma::Right
    {27, 396, 126},	// Plasma::RightEdge
    {27, 397, 55},	// Plasma::RightMargin
    {27, 398, 89},	// Plasma::RightPosedBottomAlignedPopup
    {27, 399, 88},	// Plasma::RightPosedTopAlignedPopup
    {27, 400, 63},	// Plasma::RightPositioned
    {27, 404, 115},	// Plasma::RunnerComponent
    {27, 420, 95},	// Plasma::ScreenConstraint
    {27, 443, 96},	// Plasma::SizeConstraint
    {27, 456, 59},	// Plasma::Square
    {27, 458, 98},	// Plasma::StartupCompletedConstraint
    {27, 476, 80},	// Plasma::SystemImmutable
    {27, 497, 123},	// Plasma::TopEdge
    {27, 498, 52},	// Plasma::TopMargin
    {27, 499, 82},	// Plasma::TopPosedLeftAlignedPopup
    {27, 500, 83},	// Plasma::TopPosedRightAlignedPopup
    {27, 501, 64},	// Plasma::TopPositioned
    {27, 506, 76},	// Plasma::TrustedCredentials
    {27, 509, 77},	// Plasma::UltimateCredentials
    {27, 510, 74},	// Plasma::UnknownCredentials
    {27, 511, 105},	// Plasma::UnknownStatus
    {27, 513, 68},	// Plasma::Up
    {27, 516, 79},	// Plasma::UserImmutable
    {27, 520, 75},	// Plasma::ValidCredentials
    {27, 522, 42},	// Plasma::Vertical
    {27, 523, 104},	// Plasma::VerticalFlip
    {27, 540, 118},	// Plasma::WallpaperComponent
    {27, 547, 72},	// Plasma::ZeroconfAnnouncement
    {27, 549, 37},	// Plasma::ZoomIn
    {27, 550, 38},	// Plasma::ZoomOut
    {27, 565, 35},	// Plasma::actionsFromMenu#
    {27, 566, 36},	// Plasma::actionsFromMenu#$
    {27, 567, 34},	// Plasma::actionsFromMenu#$#
    {27, 1144, 24},	// Plasma::isPluginVersionCompatible$
    {27, 1205, 21},	// Plasma::knownLanguages$
    {27, 1313, -7},	// Plasma::loadScriptEngine$#
    {27, 1318, 28},	// Plasma::locationToDirection$
    {27, 1320, 29},	// Plasma::locationToInverseDirection$
    {27, 1417, 20},	// Plasma::packageStructure$$
    {27, 1619, 31},	// Plasma::scalingFactor$
    {27, 2363, 30},	// Plasma::version
    {27, 2364, 19},	// Plasma::versionMajor
    {27, 2365, 27},	// Plasma::versionMinor
    {27, 2366, 22},	// Plasma::versionRelease
    {27, 2367, 23},	// Plasma::versionString
    {27, 2376, 32},	// Plasma::viewFor#
    {28, 1, 138},	// Plasma::AbstractDialogManager::AbstractDialogManager
    {28, 2, 134},	// Plasma::AbstractDialogManager::AbstractDialogManager#
    {28, 1351, 127},	// Plasma::AbstractDialogManager::metaObject
    {28, 1486, 133},	// Plasma::AbstractDialogManager::qt_metacall$$?
    {28, 1488, 128},	// Plasma::AbstractDialogManager::qt_metacast$
    {28, 2174, 135},	// Plasma::AbstractDialogManager::showDialog##
    {28, 2223, 139},	// Plasma::AbstractDialogManager::staticMetaObject
    {28, 2305, 136},	// Plasma::AbstractDialogManager::tr$
    {28, 2306, 129},	// Plasma::AbstractDialogManager::tr$$
    {28, 2307, 131},	// Plasma::AbstractDialogManager::tr$$$
    {28, 2309, 137},	// Plasma::AbstractDialogManager::trUtf8$
    {28, 2310, 130},	// Plasma::AbstractDialogManager::trUtf8$$
    {28, 2311, 132},	// Plasma::AbstractDialogManager::trUtf8$$$
    {28, 2409, 140},	// Plasma::AbstractDialogManager::~AbstractDialogManager
    {29, 3, 194},	// Plasma::AbstractRunner::AbstractRunner
    {29, 4, 195},	// Plasma::AbstractRunner::AbstractRunner#
    {29, 5, 170},	// Plasma::AbstractRunner::AbstractRunner#$
    {29, 6, 172},	// Plasma::AbstractRunner::AbstractRunner#?
    {29, 7, 196},	// Plasma::AbstractRunner::AbstractRunner?
    {29, 8, 171},	// Plasma::AbstractRunner::AbstractRunner?#
    {29, 206, 204},	// Plasma::AbstractRunner::HighPriority
    {29, 207, 205},	// Plasma::AbstractRunner::HighestPriority
    {29, 305, 202},	// Plasma::AbstractRunner::LowPriority
    {29, 306, 201},	// Plasma::AbstractRunner::LowestPriority
    {29, 345, 203},	// Plasma::AbstractRunner::NormalPriority
    {29, 346, 200},	// Plasma::AbstractRunner::NormalSpeed
    {29, 449, 199},	// Plasma::AbstractRunner::SlowSpeed
    {29, 558, 183},	// Plasma::AbstractRunner::action$
    {29, 560, 184},	// Plasma::AbstractRunner::actions
    {29, 562, 179},	// Plasma::AbstractRunner::actionsForMatch#
    {29, 576, 181},	// Plasma::AbstractRunner::addAction$#
    {29, 577, 180},	// Plasma::AbstractRunner::addAction$#$
    {29, 627, 186},	// Plasma::AbstractRunner::addSyntax#
    {29, 700, 164},	// Plasma::AbstractRunner::bigLock
    {29, 718, 185},	// Plasma::AbstractRunner::clearActions
    {29, 738, 174},	// Plasma::AbstractRunner::config
    {29, 818, 151},	// Plasma::AbstractRunner::createRunOptions#
    {29, 840, 189},	// Plasma::AbstractRunner::dataEngine$
    {29, 845, 165},	// Plasma::AbstractRunner::defaultSyntax
    {29, 849, 159},	// Plasma::AbstractRunner::description
    {29, 1051, 150},	// Plasma::AbstractRunner::hasRunOptions
    {29, 1075, 160},	// Plasma::AbstractRunner::icon
    {29, 1077, 158},	// Plasma::AbstractRunner::id
    {29, 1078, 155},	// Plasma::AbstractRunner::ignoredTypes
    {29, 1091, 190},	// Plasma::AbstractRunner::init
    {29, 1138, 166},	// Plasma::AbstractRunner::isMatchingSuspended
    {29, 1337, 148},	// Plasma::AbstractRunner::match#
    {29, 1344, 169},	// Plasma::AbstractRunner::matchingSuspended$
    {29, 1351, 141},	// Plasma::AbstractRunner::metaObject
    {29, 1356, 191},	// Plasma::AbstractRunner::mimeDataForMatch#
    {29, 1386, 157},	// Plasma::AbstractRunner::name
    {29, 1414, 161},	// Plasma::AbstractRunner::package
    {29, 1451, 149},	// Plasma::AbstractRunner::performMatch#
    {29, 1475, 167},	// Plasma::AbstractRunner::prepare
    {29, 1479, 154},	// Plasma::AbstractRunner::priority
    {29, 1486, 147},	// Plasma::AbstractRunner::qt_metacall$$?
    {29, 1488, 142},	// Plasma::AbstractRunner::qt_metacast$
    {29, 1519, 162},	// Plasma::AbstractRunner::reloadConfiguration
    {29, 1530, 182},	// Plasma::AbstractRunner::removeAction$
    {29, 1599, 152},	// Plasma::AbstractRunner::run##
    {29, 1653, 197},	// Plasma::AbstractRunner::serviceQuery$
    {29, 1654, 178},	// Plasma::AbstractRunner::serviceQuery$$
    {29, 1777, 187},	// Plasma::AbstractRunner::setDefaultSyntax#
    {29, 1842, 175},	// Plasma::AbstractRunner::setHasRunOptions$
    {29, 1864, 156},	// Plasma::AbstractRunner::setIgnoredTypes$
    {29, 1975, 177},	// Plasma::AbstractRunner::setPriority$
    {29, 2038, 176},	// Plasma::AbstractRunner::setSpeed$
    {29, 2061, 188},	// Plasma::AbstractRunner::setSyntaxes?
    {29, 2214, 153},	// Plasma::AbstractRunner::speed
    {29, 2223, 198},	// Plasma::AbstractRunner::staticMetaObject
    {29, 2245, 173},	// Plasma::AbstractRunner::suspendMatching$
    {29, 2254, 163},	// Plasma::AbstractRunner::syntaxes
    {29, 2273, 168},	// Plasma::AbstractRunner::teardown
    {29, 2305, 192},	// Plasma::AbstractRunner::tr$
    {29, 2306, 143},	// Plasma::AbstractRunner::tr$$
    {29, 2307, 145},	// Plasma::AbstractRunner::tr$$$
    {29, 2309, 193},	// Plasma::AbstractRunner::trUtf8$
    {29, 2310, 144},	// Plasma::AbstractRunner::trUtf8$$
    {29, 2311, 146},	// Plasma::AbstractRunner::trUtf8$$$
    {29, 2410, 206},	// Plasma::AbstractRunner::~AbstractRunner
    {30, 9, 230},	// Plasma::AbstractToolBox::AbstractToolBox
    {30, 10, -34},	// Plasma::AbstractToolBox::AbstractToolBox#
    {30, 11, 215},	// Plasma::AbstractToolBox::AbstractToolBox#?
    {30, 19, 236},	// Plasma::AbstractToolBox::AddTool
    {30, 99, 237},	// Plasma::AbstractToolBox::ConfigureTool
    {30, 115, 238},	// Plasma::AbstractToolBox::ControlTool
    {30, 144, 240},	// Plasma::AbstractToolBox::DestructiveTool
    {30, 313, 239},	// Plasma::AbstractToolBox::MiscTool
    {30, 517, 241},	// Plasma::AbstractToolBox::UserToolType
    {30, 634, 218},	// Plasma::AbstractToolBox::addTool#
    {30, 765, 227},	// Plasma::AbstractToolBox::containment
    {30, 1154, 220},	// Plasma::AbstractToolBox::isShowing
    {30, 1274, 234},	// Plasma::AbstractToolBox::listToolBoxInfo
    {30, 1275, 217},	// Plasma::AbstractToolBox::listToolBoxInfo$
    {30, 1288, 232},	// Plasma::AbstractToolBox::load$
    {30, 1292, 233},	// Plasma::AbstractToolBox::load$?
    {30, 1293, 216},	// Plasma::AbstractToolBox::load$?#
    {30, 1351, 207},	// Plasma::AbstractToolBox::metaObject
    {30, 1486, 213},	// Plasma::AbstractToolBox::qt_metacall$$?
    {30, 1488, 208},	// Plasma::AbstractToolBox::qt_metacast$
    {30, 1556, 219},	// Plasma::AbstractToolBox::removeTool#
    {30, 1573, 224},	// Plasma::AbstractToolBox::reposition
    {30, 1590, 222},	// Plasma::AbstractToolBox::restore#
    {30, 1608, 223},	// Plasma::AbstractToolBox::save#
    {30, 2026, 221},	// Plasma::AbstractToolBox::setShowing$
    {30, 2223, 235},	// Plasma::AbstractToolBox::staticMetaObject
    {30, 2293, 225},	// Plasma::AbstractToolBox::toggled
    {30, 2305, 228},	// Plasma::AbstractToolBox::tr$
    {30, 2306, 209},	// Plasma::AbstractToolBox::tr$$
    {30, 2307, 211},	// Plasma::AbstractToolBox::tr$$$
    {30, 2309, 229},	// Plasma::AbstractToolBox::trUtf8$
    {30, 2310, 210},	// Plasma::AbstractToolBox::trUtf8$$
    {30, 2311, 212},	// Plasma::AbstractToolBox::trUtf8$$$
    {30, 2382, 226},	// Plasma::AbstractToolBox::visibilityChanged$
    {30, 2411, 242},	// Plasma::AbstractToolBox::~AbstractToolBox
    {31, 14, 255},	// Plasma::AccessAppletJob::AccessAppletJob#
    {31, 15, 251},	// Plasma::AccessAppletJob::AccessAppletJob##
    {31, 664, 250},	// Plasma::AccessAppletJob::applet
    {31, 1351, 243},	// Plasma::AccessAppletJob::metaObject
    {31, 1486, 249},	// Plasma::AccessAppletJob::qt_metacall$$?
    {31, 1488, 244},	// Plasma::AccessAppletJob::qt_metacast$
    {31, 2217, 252},	// Plasma::AccessAppletJob::start
    {31, 2223, 256},	// Plasma::AccessAppletJob::staticMetaObject
    {31, 2305, 253},	// Plasma::AccessAppletJob::tr$
    {31, 2306, 245},	// Plasma::AccessAppletJob::tr$$
    {31, 2307, 247},	// Plasma::AccessAppletJob::tr$$$
    {31, 2309, 254},	// Plasma::AccessAppletJob::trUtf8$
    {31, 2310, 246},	// Plasma::AccessAppletJob::trUtf8$$
    {31, 2311, 248},	// Plasma::AccessAppletJob::trUtf8$$$
    {31, 2412, 257},	// Plasma::AccessAppletJob::~AccessAppletJob
    {32, 556, 266},	// Plasma::AccessManager::accessRemoteApplet#
    {32, 986, 269},	// Plasma::AccessManager::finished#
    {32, 1351, 258},	// Plasma::AccessManager::metaObject
    {32, 1486, 264},	// Plasma::AccessManager::qt_metacall$$?
    {32, 1488, 259},	// Plasma::AccessManager::qt_metacast$
    {32, 1522, 270},	// Plasma::AccessManager::remoteAppletAnnounced#
    {32, 1524, 271},	// Plasma::AccessManager::remoteAppletUnannounced#
    {32, 1525, 267},	// Plasma::AccessManager::remoteApplets
    {32, 1646, 265},	// Plasma::AccessManager::self
    {32, 2223, 274},	// Plasma::AccessManager::staticMetaObject
    {32, 2240, 268},	// Plasma::AccessManager::supportedProtocols
    {32, 2305, 272},	// Plasma::AccessManager::tr$
    {32, 2306, 260},	// Plasma::AccessManager::tr$$
    {32, 2307, 262},	// Plasma::AccessManager::tr$$$
    {32, 2309, 273},	// Plasma::AccessManager::trUtf8$
    {32, 2310, 261},	// Plasma::AccessManager::trUtf8$$
    {32, 2311, 263},	// Plasma::AccessManager::trUtf8$$$
    {33, 32, 292},	// Plasma::Animation::Animation
    {33, 33, 283},	// Plasma::Animation::Animation#
    {33, 82, 295},	// Plasma::Animation::Center
    {33, 155, 297},	// Plasma::Animation::Down
    {33, 292, 298},	// Plasma::Animation::Left
    {33, 314, 300},	// Plasma::Animation::MoveAny
    {33, 315, 303},	// Plasma::Animation::MoveDown
    {33, 316, 304},	// Plasma::Animation::MoveLeft
    {33, 317, 302},	// Plasma::Animation::MoveRight
    {33, 318, 301},	// Plasma::Animation::MoveUp
    {33, 394, 299},	// Plasma::Animation::Right
    {33, 513, 296},	// Plasma::Animation::Up
    {33, 908, 282},	// Plasma::Animation::duration
    {33, 909, 287},	// Plasma::Animation::easingCurve
    {33, 1351, 275},	// Plasma::Animation::metaObject
    {33, 1486, 281},	// Plasma::Animation::qt_metacall$$?
    {33, 1488, 276},	// Plasma::Animation::qt_metacast$
    {33, 1793, 293},	// Plasma::Animation::setDuration
    {33, 1794, 288},	// Plasma::Animation::setDuration$
    {33, 1796, 286},	// Plasma::Animation::setEasingCurve#
    {33, 2077, 284},	// Plasma::Animation::setTargetWidget#
    {33, 2223, 294},	// Plasma::Animation::staticMetaObject
    {33, 2271, 285},	// Plasma::Animation::targetWidget
    {33, 2305, 290},	// Plasma::Animation::tr$
    {33, 2306, 277},	// Plasma::Animation::tr$$
    {33, 2307, 279},	// Plasma::Animation::tr$$$
    {33, 2309, 291},	// Plasma::Animation::trUtf8$
    {33, 2310, 278},	// Plasma::Animation::trUtf8$$
    {33, 2311, 280},	// Plasma::Animation::trUtf8$$$
    {33, 2335, 289},	// Plasma::Animation::updateCurrentTime$
    {33, 2413, 305},	// Plasma::Animation::~Animation
    {34, 34, 332},	// Plasma::AnimationDriver::AnimationDriver
    {34, 35, 313},	// Plasma::AnimationDriver::AnimationDriver#
    {34, 649, 320},	// Plasma::AnimationDriver::animationCurve$
    {34, 651, 317},	// Plasma::AnimationDriver::animationDuration$
    {34, 655, 314},	// Plasma::AnimationDriver::animationFps$
    {34, 914, 322},	// Plasma::AnimationDriver::elementAnimationCurve$
    {34, 916, 319},	// Plasma::AnimationDriver::elementAnimationDuration$
    {34, 920, 316},	// Plasma::AnimationDriver::elementAnimationFps$
    {34, 922, 323},	// Plasma::AnimationDriver::elementAppear$#
    {34, 926, 324},	// Plasma::AnimationDriver::elementDisappear$#
    {34, 1171, 327},	// Plasma::AnimationDriver::itemActivated$#
    {34, 1176, 325},	// Plasma::AnimationDriver::itemAppear$#
    {34, 1184, 326},	// Plasma::AnimationDriver::itemDisappear$#
    {34, 1194, 328},	// Plasma::AnimationDriver::itemSlideIn$###
    {34, 1196, 329},	// Plasma::AnimationDriver::itemSlideOut$###
    {34, 1351, 306},	// Plasma::AnimationDriver::metaObject
    {34, 1379, 321},	// Plasma::AnimationDriver::movementAnimationCurve$
    {34, 1381, 318},	// Plasma::AnimationDriver::movementAnimationDuration$
    {34, 1383, 315},	// Plasma::AnimationDriver::movementAnimationFps$
    {34, 1486, 312},	// Plasma::AnimationDriver::qt_metacall$$?
    {34, 1488, 307},	// Plasma::AnimationDriver::qt_metacast$
    {34, 2223, 333},	// Plasma::AnimationDriver::staticMetaObject
    {34, 2305, 330},	// Plasma::AnimationDriver::tr$
    {34, 2306, 308},	// Plasma::AnimationDriver::tr$$
    {34, 2307, 310},	// Plasma::AnimationDriver::tr$$$
    {34, 2309, 331},	// Plasma::AnimationDriver::trUtf8$
    {34, 2310, 309},	// Plasma::AnimationDriver::trUtf8$$
    {34, 2311, 311},	// Plasma::AnimationDriver::trUtf8$$$
    {34, 2414, 334},	// Plasma::AnimationDriver::~AnimationDriver
    {35, 16, 370},	// Plasma::Animator::ActivateAnimation
    {35, 37, 368},	// Plasma::Animator::AppearAnimation
    {35, 151, 369},	// Plasma::Animator::DisappearAnimation
    {35, 158, 382},	// Plasma::Animator::EaseInCurve
    {35, 159, 384},	// Plasma::Animator::EaseInOutCurve
    {35, 160, 383},	// Plasma::Animator::EaseOutCurve
    {35, 174, 371},	// Plasma::Animator::FadeAnimation
    {35, 175, 389},	// Plasma::Animator::FastSlideInMovement
    {35, 176, 390},	// Plasma::Animator::FastSlideOutMovement
    {35, 198, 377},	// Plasma::Animator::GeometryAnimation
    {35, 202, 372},	// Plasma::Animator::GrowAnimation
    {35, 290, 381},	// Plasma::Animator::LastAnimation
    {35, 302, 385},	// Plasma::Animator::LinearCurve
    {35, 367, 386},	// Plasma::Animator::PendularCurve
    {35, 371, 379},	// Plasma::Animator::PixmapTransitionAnimation
    {35, 384, 373},	// Plasma::Animator::PulseAnimation
    {35, 401, 374},	// Plasma::Animator::RotationAnimation
    {35, 402, 375},	// Plasma::Animator::RotationStackedAnimation
    {35, 444, 376},	// Plasma::Animator::SlideAnimation
    {35, 445, 387},	// Plasma::Animator::SlideInMovement
    {35, 446, 388},	// Plasma::Animator::SlideOutMovement
    {35, 543, 380},	// Plasma::Animator::WaterAnimation
    {35, 548, 378},	// Plasma::Animator::ZoomAnimation
    {35, 653, 357},	// Plasma::Animator::animationFinished#$
    {35, 801, -27},	// Plasma::Animator::create$
    {35, 802, -31},	// Plasma::Animator::create$#
    {35, 827, 353},	// Plasma::Animator::currentPixmap$
    {35, 832, 349},	// Plasma::Animator::customAnimation$$$#$
    {35, 834, 360},	// Plasma::Animator::customAnimationFinished$
    {35, 918, 359},	// Plasma::Animator::elementAnimationFinished$
    {35, 1120, 354},	// Plasma::Animator::isAnimating
    {35, 1351, 335},	// Plasma::Animator::metaObject
    {35, 1377, 347},	// Plasma::Animator::moveItem#$#
    {35, 1385, 358},	// Plasma::Animator::movementFinished#
    {35, 1486, 341},	// Plasma::Animator::qt_metacall$$?
    {35, 1488, 336},	// Plasma::Animator::qt_metacast$
    {35, 1510, 355},	// Plasma::Animator::registerScrollingManager#
    {35, 1637, 361},	// Plasma::Animator::scrollStateChanged#$$
    {35, 1646, 342},	// Plasma::Animator::self
    {35, 1878, 352},	// Plasma::Animator::setInitialPixmap$#
    {35, 2223, 367},	// Plasma::Animator::staticMetaObject
    {35, 2227, 350},	// Plasma::Animator::stopCustomAnimation$
    {35, 2229, 351},	// Plasma::Animator::stopElementAnimation$
    {35, 2231, 346},	// Plasma::Animator::stopItemAnimation$
    {35, 2233, 348},	// Plasma::Animator::stopItemMovement$
    {35, 2290, 362},	// Plasma::Animator::timerEvent#
    {35, 2305, 363},	// Plasma::Animator::tr$
    {35, 2306, 337},	// Plasma::Animator::tr$$
    {35, 2307, 339},	// Plasma::Animator::tr$$$
    {35, 2309, 364},	// Plasma::Animator::trUtf8$
    {35, 2310, 338},	// Plasma::Animator::trUtf8$$
    {35, 2311, 340},	// Plasma::Animator::trUtf8$$$
    {35, 2326, 356},	// Plasma::Animator::unregisterScrollingManager#
    {36, 38, 534},	// Plasma::Applet::Applet
    {36, 39, -21},	// Plasma::Applet::Applet#
    {36, 40, 538},	// Plasma::Applet::Applet##
    {36, 41, 459},	// Plasma::Applet::Applet##$
    {36, 42, 536},	// Plasma::Applet::Applet#$
    {36, 43, 458},	// Plasma::Applet::Applet#$$
    {36, 44, 460},	// Plasma::Applet::Applet#$$?
    {36, 45, 499},	// Plasma::Applet::Applet#?
    {36, 132, 546},	// Plasma::Applet::DefaultBackground
    {36, 326, 543},	// Plasma::Applet::NoBackground
    {36, 457, 544},	// Plasma::Applet::StandardBackground
    {36, 503, 545},	// Plasma::Applet::TranslucentBackground
    {36, 508, 547},	// Plasma::Applet::Type
    {36, 558, 444},	// Plasma::Applet::action$
    {36, 568, 475},	// Plasma::Applet::activate
    {36, 576, 445},	// Plasma::Applet::addAction$#
    {36, 586, 455},	// Plasma::Applet::addAssociatedWidget#
    {36, 668, 477},	// Plasma::Applet::appletDestroyed#
    {36, 672, 471},	// Plasma::Applet::appletTransformedByUser
    {36, 673, 472},	// Plasma::Applet::appletTransformedItself
    {36, 676, 417},	// Plasma::Applet::aspectRatioMode
    {36, 681, 466},	// Plasma::Applet::associatedApplication
    {36, 682, 467},	// Plasma::Applet::associatedApplicationUrls
    {36, 697, 447},	// Plasma::Applet::backgroundHints
    {36, 707, 436},	// Plasma::Applet::category
    {36, 708, 428},	// Plasma::Applet::category#
    {36, 709, 429},	// Plasma::Applet::category$
    {36, 738, 400},	// Plasma::Applet::config
    {36, 739, 401},	// Plasma::Applet::config$
    {36, 740, 490},	// Plasma::Applet::configChanged
    {36, 741, 474},	// Plasma::Applet::configNeedsSaving
    {36, 742, 405},	// Plasma::Applet::configScheme
    {36, 745, 441},	// Plasma::Applet::configurationRequired
    {36, 761, 505},	// Plasma::Applet::constraintsEvent$
    {36, 765, 451},	// Plasma::Applet::containment
    {36, 788, 416},	// Plasma::Applet::context
    {36, 796, 443},	// Plasma::Applet::contextualActions
    {36, 806, 462},	// Plasma::Applet::createConfigurationInterface#
    {36, 835, 424},	// Plasma::Applet::customCategories
    {36, 840, 406},	// Plasma::Applet::dataEngine$
    {36, 852, 482},	// Plasma::Applet::destroy
    {36, 854, 461},	// Plasma::Applet::destroyed
    {36, 955, 510},	// Plasma::Applet::eventFilter##
    {36, 966, 509},	// Plasma::Applet::extender
    {36, 968, 479},	// Plasma::Applet::extenderItemRestored#
    {36, 995, 488},	// Plasma::Applet::flushPendingConstraintsEvents
    {36, 999, 513},	// Plasma::Applet::focusInEvent#
    {36, 1005, 432},	// Plasma::Applet::font
    {36, 1012, 414},	// Plasma::Applet::formFactor
    {36, 1020, 470},	// Plasma::Applet::geometryChanged
    {36, 1029, 404},	// Plasma::Applet::globalConfig
    {36, 1030, 453},	// Plasma::Applet::globalShortcut
    {36, 1039, 463},	// Plasma::Applet::hasAuthorization$
    {36, 1040, 442},	// Plasma::Applet::hasConfigurationInterface
    {36, 1045, 439},	// Plasma::Applet::hasFailedToLaunch
    {36, 1053, 468},	// Plasma::Applet::hasValidAssociatedApplication
    {36, 1069, 518},	// Plasma::Applet::hoverEnterEvent#
    {36, 1071, 519},	// Plasma::Applet::hoverLeaveEvent#
    {36, 1075, 435},	// Plasma::Applet::icon
    {36, 1077, 399},	// Plasma::Applet::id
    {36, 1082, 437},	// Plasma::Applet::immutability
    {36, 1084, 480},	// Plasma::Applet::immutabilityChanged$
    {36, 1091, 489},	// Plasma::Applet::init
    {36, 1094, 457},	// Plasma::Applet::initExtenderItem#
    {36, 1122, 440},	// Plasma::Applet::isBusy
    {36, 1128, 448},	// Plasma::Applet::isContainment
    {36, 1145, 454},	// Plasma::Applet::isPopupShowing
    {36, 1147, 497},	// Plasma::Applet::isPublished
    {36, 1150, 508},	// Plasma::Applet::isRegisteredAsDragHandle#
    {36, 1161, 485},	// Plasma::Applet::isUserConfiguring
    {36, 1180, 515},	// Plasma::Applet::itemChange$#
    {36, 1238, 524},	// Plasma::Applet::listAppletInfo
    {36, 1239, 525},	// Plasma::Applet::listAppletInfo$
    {36, 1240, 419},	// Plasma::Applet::listAppletInfo$$
    {36, 1242, 420},	// Plasma::Applet::listAppletInfoForMimetype$
    {36, 1244, 421},	// Plasma::Applet::listAppletInfoForUrl#
    {36, 1247, 526},	// Plasma::Applet::listCategories
    {36, 1248, 527},	// Plasma::Applet::listCategories$
    {36, 1249, 422},	// Plasma::Applet::listCategories$$
    {36, 1282, 532},	// Plasma::Applet::load#
    {36, 1285, 533},	// Plasma::Applet::load#$
    {36, 1286, 427},	// Plasma::Applet::load#$?
    {36, 1288, 530},	// Plasma::Applet::load$
    {36, 1290, 531},	// Plasma::Applet::load$$
    {36, 1291, 426},	// Plasma::Applet::load$$?
    {36, 1304, 528},	// Plasma::Applet::loadPlasmoid$
    {36, 1305, 529},	// Plasma::Applet::loadPlasmoid$$
    {36, 1306, 425},	// Plasma::Applet::loadPlasmoid$$?
    {36, 1314, 415},	// Plasma::Applet::location
    {36, 1322, 487},	// Plasma::Applet::lower
    {36, 1330, 409},	// Plasma::Applet::mapFromView##
    {36, 1332, 410},	// Plasma::Applet::mapToView##
    {36, 1350, 476},	// Plasma::Applet::messageButtonPressed$
    {36, 1351, 391},	// Plasma::Applet::metaObject
    {36, 1369, 512},	// Plasma::Applet::mouseMoveEvent#
    {36, 1386, 431},	// Plasma::Applet::name
    {36, 1392, 478},	// Plasma::Applet::newStatus$
    {36, 1414, 407},	// Plasma::Applet::package
    {36, 1415, 398},	// Plasma::Applet::packageStructure
    {36, 1438, 430},	// Plasma::Applet::paintInterface###
    {36, 1440, 438},	// Plasma::Applet::paintWindowFrame###
    {36, 1458, 433},	// Plasma::Applet::pluginName
    {36, 1467, 411},	// Plasma::Applet::popupPosition#
    {36, 1470, 412},	// Plasma::Applet::popupPosition#$
    {36, 1484, 495},	// Plasma::Applet::publish$$
    {36, 1486, 397},	// Plasma::Applet::qt_metacall$$?
    {36, 1488, 392},	// Plasma::Applet::qt_metacast$
    {36, 1492, 486},	// Plasma::Applet::raise
    {36, 1503, 506},	// Plasma::Applet::registerAsDragHandle#
    {36, 1515, 469},	// Plasma::Applet::releaseVisualFocus
    {36, 1535, 456},	// Plasma::Applet::removeAssociatedWidget#
    {36, 1585, 514},	// Plasma::Applet::resizeEvent#
    {36, 1590, 403},	// Plasma::Applet::restore#
    {36, 1601, 498},	// Plasma::Applet::runAssociatedApplication
    {36, 1608, 402},	// Plasma::Applet::save#
    {36, 1614, 501},	// Plasma::Applet::saveState#
    {36, 1622, 511},	// Plasma::Applet::sceneEventFilter##
    {36, 1633, 449},	// Plasma::Applet::screenRect
    {36, 1677, 418},	// Plasma::Applet::setAspectRatioMode$
    {36, 1679, 464},	// Plasma::Applet::setAssociatedApplication$
    {36, 1681, 465},	// Plasma::Applet::setAssociatedApplicationUrls?
    {36, 1701, 446},	// Plasma::Applet::setBackgroundHints$
    {36, 1705, 491},	// Plasma::Applet::setBusy$
    {36, 1727, 540},	// Plasma::Applet::setConfigurationRequired$
    {36, 1728, 503},	// Plasma::Applet::setConfigurationRequired$$
    {36, 1758, 423},	// Plasma::Applet::setCustomCategories?
    {36, 1815, 539},	// Plasma::Applet::setFailedToLaunch$
    {36, 1816, 500},	// Plasma::Applet::setFailedToLaunch$$
    {36, 1831, 452},	// Plasma::Applet::setGlobalShortcut#
    {36, 1840, 502},	// Plasma::Applet::setHasConfigurationInterface$
    {36, 1872, 481},	// Plasma::Applet::setImmutability$
    {36, 2044, 494},	// Plasma::Applet::setStatus$
    {36, 2161, 516},	// Plasma::Applet::shape
    {36, 2163, 434},	// Plasma::Applet::shouldConserveResources
    {36, 2169, 483},	// Plasma::Applet::showConfigurationInterface
    {36, 2170, 484},	// Plasma::Applet::showConfigurationInterface#
    {36, 2182, 504},	// Plasma::Applet::showMessage#$$
    {36, 2200, 541},	// Plasma::Applet::sizeHint$
    {36, 2201, 517},	// Plasma::Applet::sizeHint$#
    {36, 2203, 473},	// Plasma::Applet::sizeHintChanged$
    {36, 2221, 492},	// Plasma::Applet::startupArguments
    {36, 2223, 542},	// Plasma::Applet::staticMetaObject
    {36, 2224, 493},	// Plasma::Applet::status
    {36, 2290, 520},	// Plasma::Applet::timerEvent#
    {36, 2305, 521},	// Plasma::Applet::tr$
    {36, 2306, 393},	// Plasma::Applet::tr$$
    {36, 2307, 395},	// Plasma::Applet::tr$$$
    {36, 2309, 522},	// Plasma::Applet::trUtf8$
    {36, 2310, 394},	// Plasma::Applet::trUtf8$$
    {36, 2311, 396},	// Plasma::Applet::trUtf8$$$
    {36, 2313, 450},	// Plasma::Applet::type
    {36, 2322, 496},	// Plasma::Applet::unpublish
    {36, 2324, 507},	// Plasma::Applet::unregisterAsDragHandle#
    {36, 2332, 523},	// Plasma::Applet::updateConstraints
    {36, 2333, 413},	// Plasma::Applet::updateConstraints$
    {36, 2374, 408},	// Plasma::Applet::view
    {36, 2415, 548},	// Plasma::Applet::~Applet
    {37, 47, 590},	// Plasma::AppletScript::AppletScript
    {37, 48, 556},	// Plasma::AppletScript::AppletScript#
    {37, 625, 582},	// Plasma::AppletScript::addStandardConfigurationPages#
    {37, 664, 558},	// Plasma::AppletScript::applet
    {37, 740, 576},	// Plasma::AppletScript::configChanged
    {37, 741, 567},	// Plasma::AppletScript::configNeedsSaving
    {37, 761, 561},	// Plasma::AppletScript::constraintsEvent$
    {37, 779, 571},	// Plasma::AppletScript::containmentType
    {37, 796, 562},	// Plasma::AppletScript::contextualActions
    {37, 840, 577},	// Plasma::AppletScript::dataEngine$
    {37, 849, 580},	// Plasma::AppletScript::description
    {37, 903, 569},	// Plasma::AppletScript::drawWallpaper
    {37, 966, 568},	// Plasma::AppletScript::extender
    {37, 1150, 586},	// Plasma::AppletScript::isRegisteredAsDragHandle#
    {37, 1295, 587},	// Plasma::AppletScript::loadAnimationFromPackage$#
    {37, 1324, 578},	// Plasma::AppletScript::mainScript
    {37, 1351, 549},	// Plasma::AppletScript::metaObject
    {37, 1414, 579},	// Plasma::AppletScript::package
    {37, 1438, 559},	// Plasma::AppletScript::paintInterface###
    {37, 1463, 574},	// Plasma::AppletScript::popupEvent$
    {37, 1486, 555},	// Plasma::AppletScript::qt_metacall$$?
    {37, 1488, 550},	// Plasma::AppletScript::qt_metacast$
    {37, 1503, 584},	// Plasma::AppletScript::registerAsDragHandle#
    {37, 1614, 573},	// Plasma::AppletScript::saveState#
    {37, 1671, 557},	// Plasma::AppletScript::setApplet#
    {37, 1727, 591},	// Plasma::AppletScript::setConfigurationRequired$
    {37, 1728, 565},	// Plasma::AppletScript::setConfigurationRequired$$
    {37, 1736, 572},	// Plasma::AppletScript::setContainmentType$
    {37, 1792, 570},	// Plasma::AppletScript::setDrawWallpaper$
    {37, 1815, 592},	// Plasma::AppletScript::setFailedToLaunch$
    {37, 1816, 566},	// Plasma::AppletScript::setFailedToLaunch$$
    {37, 1840, 564},	// Plasma::AppletScript::setHasConfigurationInterface$
    {37, 2161, 563},	// Plasma::AppletScript::shape
    {37, 2169, 575},	// Plasma::AppletScript::showConfigurationInterface
    {37, 2182, 583},	// Plasma::AppletScript::showMessage#$$
    {37, 2194, 560},	// Plasma::AppletScript::size
    {37, 2216, 581},	// Plasma::AppletScript::standardConfigurationDialog
    {37, 2223, 593},	// Plasma::AppletScript::staticMetaObject
    {37, 2305, 588},	// Plasma::AppletScript::tr$
    {37, 2306, 551},	// Plasma::AppletScript::tr$$
    {37, 2307, 553},	// Plasma::AppletScript::tr$$$
    {37, 2309, 589},	// Plasma::AppletScript::trUtf8$
    {37, 2310, 552},	// Plasma::AppletScript::trUtf8$$
    {37, 2311, 554},	// Plasma::AppletScript::trUtf8$$$
    {37, 2324, 585},	// Plasma::AppletScript::unregisterAsDragHandle#
    {37, 2416, 594},	// Plasma::AppletScript::~AppletScript
    {38, 51, 597},	// Plasma::AuthorizationInterface::AuthorizationInterface
    {38, 52, 598},	// Plasma::AuthorizationInterface::AuthorizationInterface#
    {38, 687, 595},	// Plasma::AuthorizationInterface::authorizationRequest#
    {38, 729, 596},	// Plasma::AuthorizationInterface::clientPinRequest#
    {38, 2417, 599},	// Plasma::AuthorizationInterface::~AuthorizationInterface
    {39, 119, 617},	// Plasma::AuthorizationManager::Custom
    {39, 139, 614},	// Plasma::AuthorizationManager::DenyAll
    {39, 369, 616},	// Plasma::AuthorizationManager::PinPairing
    {39, 507, 615},	// Plasma::AuthorizationManager::TrustedOnly
    {39, 1351, 600},	// Plasma::AuthorizationManager::metaObject
    {39, 1486, 606},	// Plasma::AuthorizationManager::qt_metacall$$?
    {39, 1488, 601},	// Plasma::AuthorizationManager::qt_metacast$
    {39, 1497, 610},	// Plasma::AuthorizationManager::readyForRemoteAccess
    {39, 1646, 607},	// Plasma::AuthorizationManager::self
    {39, 1685, 609},	// Plasma::AuthorizationManager::setAuthorizationInterface#
    {39, 1687, 608},	// Plasma::AuthorizationManager::setAuthorizationPolicy$
    {39, 2223, 613},	// Plasma::AuthorizationManager::staticMetaObject
    {39, 2305, 611},	// Plasma::AuthorizationManager::tr$
    {39, 2306, 602},	// Plasma::AuthorizationManager::tr$$
    {39, 2307, 604},	// Plasma::AuthorizationManager::tr$$$
    {39, 2309, 612},	// Plasma::AuthorizationManager::trUtf8$
    {39, 2310, 603},	// Plasma::AuthorizationManager::trUtf8$$
    {39, 2311, 605},	// Plasma::AuthorizationManager::trUtf8$$$
    {40, 26, 646},	// Plasma::AuthorizationRule::AllServices
    {40, 27, 645},	// Plasma::AuthorizationRule::AllUsers
    {40, 28, 640},	// Plasma::AuthorizationRule::Allow
    {40, 131, 644},	// Plasma::AuthorizationRule::Default
    {40, 138, 639},	// Plasma::AuthorizationRule::Deny
    {40, 368, 643},	// Plasma::AuthorizationRule::Persistent
    {40, 370, 641},	// Plasma::AuthorizationRule::PinRequired
    {40, 502, 642},	// Plasma::AuthorizationRule::Transient
    {40, 713, 635},	// Plasma::AuthorizationRule::changed#
    {40, 849, 625},	// Plasma::AuthorizationRule::description
    {40, 1351, 618},	// Plasma::AuthorizationRule::metaObject
    {40, 1452, 629},	// Plasma::AuthorizationRule::persistence
    {40, 1453, 633},	// Plasma::AuthorizationRule::pin
    {40, 1459, 627},	// Plasma::AuthorizationRule::policy
    {40, 1486, 624},	// Plasma::AuthorizationRule::qt_metacall$$?
    {40, 1488, 619},	// Plasma::AuthorizationRule::qt_metacast$
    {40, 1650, 634},	// Plasma::AuthorizationRule::serviceName
    {40, 1950, 628},	// Plasma::AuthorizationRule::setPersistence$
    {40, 1952, 632},	// Plasma::AuthorizationRule::setPin$
    {40, 1956, 626},	// Plasma::AuthorizationRule::setPolicy$
    {40, 2079, 630},	// Plasma::AuthorizationRule::setTargets$
    {40, 2223, 638},	// Plasma::AuthorizationRule::staticMetaObject
    {40, 2272, 631},	// Plasma::AuthorizationRule::targets
    {40, 2305, 636},	// Plasma::AuthorizationRule::tr$
    {40, 2306, 620},	// Plasma::AuthorizationRule::tr$$
    {40, 2307, 622},	// Plasma::AuthorizationRule::tr$$$
    {40, 2309, 637},	// Plasma::AuthorizationRule::trUtf8$
    {40, 2310, 621},	// Plasma::AuthorizationRule::trUtf8$$
    {40, 2311, 623},	// Plasma::AuthorizationRule::trUtf8$$$
    {40, 2418, 647},	// Plasma::AuthorizationRule::~AuthorizationRule
    {41, 68, 670},	// Plasma::BusyWidget::BusyWidget
    {41, 69, 655},	// Plasma::BusyWidget::BusyWidget#
    {41, 726, 660},	// Plasma::BusyWidget::clicked
    {41, 1060, 663},	// Plasma::BusyWidget::hideEvent#
    {41, 1153, 657},	// Plasma::BusyWidget::isRunning
    {41, 1206, 659},	// Plasma::BusyWidget::label
    {41, 1351, 648},	// Plasma::BusyWidget::metaObject
    {41, 1371, 665},	// Plasma::BusyWidget::mousePressEvent#
    {41, 1373, 666},	// Plasma::BusyWidget::mouseReleaseEvent#
    {41, 1421, 671},	// Plasma::BusyWidget::paint##
    {41, 1422, 661},	// Plasma::BusyWidget::paint###
    {41, 1486, 654},	// Plasma::BusyWidget::qt_metacall$$?
    {41, 1488, 649},	// Plasma::BusyWidget::qt_metacast$
    {41, 1585, 664},	// Plasma::BusyWidget::resizeEvent#
    {41, 1884, 658},	// Plasma::BusyWidget::setLabel$
    {41, 2001, 656},	// Plasma::BusyWidget::setRunning$
    {41, 2178, 662},	// Plasma::BusyWidget::showEvent#
    {41, 2223, 672},	// Plasma::BusyWidget::staticMetaObject
    {41, 2290, 667},	// Plasma::BusyWidget::timerEvent#
    {41, 2305, 668},	// Plasma::BusyWidget::tr$
    {41, 2306, 650},	// Plasma::BusyWidget::tr$$
    {41, 2307, 652},	// Plasma::BusyWidget::tr$$$
    {41, 2309, 669},	// Plasma::BusyWidget::trUtf8$
    {41, 2310, 651},	// Plasma::BusyWidget::trUtf8$$
    {41, 2311, 653},	// Plasma::BusyWidget::trUtf8$$$
    {41, 2419, 673},	// Plasma::BusyWidget::~BusyWidget
    {42, 86, 696},	// Plasma::CheckBox::CheckBox
    {42, 87, 681},	// Plasma::CheckBox::CheckBox#
    {42, 711, 693},	// Plasma::CheckBox::changeEvent#
    {42, 1079, 685},	// Plasma::CheckBox::image
    {42, 1124, 690},	// Plasma::CheckBox::isChecked
    {42, 1351, 674},	// Plasma::CheckBox::metaObject
    {42, 1388, 688},	// Plasma::CheckBox::nativeWidget
    {42, 1486, 680},	// Plasma::CheckBox::qt_metacall$$?
    {42, 1488, 675},	// Plasma::CheckBox::qt_metacast$
    {42, 1585, 692},	// Plasma::CheckBox::resizeEvent#
    {42, 1715, 689},	// Plasma::CheckBox::setChecked$
    {42, 1867, 684},	// Plasma::CheckBox::setImage$
    {42, 2049, 686},	// Plasma::CheckBox::setStyleSheet$
    {42, 2081, 682},	// Plasma::CheckBox::setText$
    {42, 2223, 697},	// Plasma::CheckBox::staticMetaObject
    {42, 2236, 687},	// Plasma::CheckBox::styleSheet
    {42, 2274, 683},	// Plasma::CheckBox::text
    {42, 2294, 691},	// Plasma::CheckBox::toggled$
    {42, 2305, 694},	// Plasma::CheckBox::tr$
    {42, 2306, 676},	// Plasma::CheckBox::tr$$
    {42, 2307, 678},	// Plasma::CheckBox::tr$$$
    {42, 2309, 695},	// Plasma::CheckBox::trUtf8$
    {42, 2310, 677},	// Plasma::CheckBox::trUtf8$$
    {42, 2311, 679},	// Plasma::CheckBox::trUtf8$$$
    {42, 2420, 698},	// Plasma::CheckBox::~CheckBox
    {43, 713, 709},	// Plasma::ClientPinRequest::changed#
    {43, 849, 706},	// Plasma::ClientPinRequest::description
    {43, 1351, 699},	// Plasma::ClientPinRequest::metaObject
    {43, 1453, 708},	// Plasma::ClientPinRequest::pin
    {43, 1486, 705},	// Plasma::ClientPinRequest::qt_metacall$$?
    {43, 1488, 700},	// Plasma::ClientPinRequest::qt_metacast$
    {43, 1952, 707},	// Plasma::ClientPinRequest::setPin$
    {43, 2223, 712},	// Plasma::ClientPinRequest::staticMetaObject
    {43, 2305, 710},	// Plasma::ClientPinRequest::tr$
    {43, 2306, 701},	// Plasma::ClientPinRequest::tr$$
    {43, 2307, 703},	// Plasma::ClientPinRequest::tr$$$
    {43, 2309, 711},	// Plasma::ClientPinRequest::trUtf8$
    {43, 2310, 702},	// Plasma::ClientPinRequest::trUtf8$$
    {43, 2311, 704},	// Plasma::ClientPinRequest::trUtf8$$$
    {44, 89, 744},	// Plasma::ComboBox::ComboBox
    {44, 90, 720},	// Plasma::ComboBox::ComboBox#
    {44, 570, 731},	// Plasma::ComboBox::activated$
    {44, 602, 726},	// Plasma::ComboBox::addItem$
    {44, 711, 740},	// Plasma::ComboBox::changeEvent#
    {44, 717, 730},	// Plasma::ComboBox::clear
    {44, 799, 727},	// Plasma::ComboBox::count
    {44, 823, 728},	// Plasma::ComboBox::currentIndex
    {44, 825, 733},	// Plasma::ComboBox::currentIndexChanged$
    {44, 999, 736},	// Plasma::ComboBox::focusInEvent#
    {44, 1003, 737},	// Plasma::ComboBox::focusOutEvent#
    {44, 1069, 738},	// Plasma::ComboBox::hoverEnterEvent#
    {44, 1071, 739},	// Plasma::ComboBox::hoverLeaveEvent#
    {44, 1351, 713},	// Plasma::ComboBox::metaObject
    {44, 1371, 741},	// Plasma::ComboBox::mousePressEvent#
    {44, 1388, 725},	// Plasma::ComboBox::nativeWidget
    {44, 1422, 735},	// Plasma::ComboBox::paint###
    {44, 1486, 719},	// Plasma::ComboBox::qt_metacall$$?
    {44, 1488, 714},	// Plasma::ComboBox::qt_metacast$
    {44, 1585, 734},	// Plasma::ComboBox::resizeEvent#
    {44, 1756, 729},	// Plasma::ComboBox::setCurrentIndex$
    {44, 1924, 724},	// Plasma::ComboBox::setNativeWidget#
    {44, 2049, 722},	// Plasma::ComboBox::setStyleSheet$
    {44, 2223, 745},	// Plasma::ComboBox::staticMetaObject
    {44, 2236, 723},	// Plasma::ComboBox::styleSheet
    {44, 2274, 721},	// Plasma::ComboBox::text
    {44, 2277, 732},	// Plasma::ComboBox::textChanged$
    {44, 2305, 742},	// Plasma::ComboBox::tr$
    {44, 2306, 715},	// Plasma::ComboBox::tr$$
    {44, 2307, 717},	// Plasma::ComboBox::tr$$$
    {44, 2309, 743},	// Plasma::ComboBox::trUtf8$
    {44, 2310, 716},	// Plasma::ComboBox::trUtf8$$
    {44, 2311, 718},	// Plasma::ComboBox::trUtf8$$$
    {44, 2421, 746},	// Plasma::ComboBox::~ComboBox
    {45, 93, 758},	// Plasma::ConfigLoader::ConfigLoader##
    {45, 94, 749},	// Plasma::ConfigLoader::ConfigLoader###
    {45, 95, 756},	// Plasma::ConfigLoader::ConfigLoader$#
    {45, 96, 747},	// Plasma::ConfigLoader::ConfigLoader$##
    {45, 97, 757},	// Plasma::ConfigLoader::ConfigLoader?#
    {45, 98, 748},	// Plasma::ConfigLoader::ConfigLoader?##
    {45, 982, 750},	// Plasma::ConfigLoader::findItem$$
    {45, 984, 751},	// Plasma::ConfigLoader::findItemByName$
    {45, 1036, 754},	// Plasma::ConfigLoader::groupList
    {45, 1047, 753},	// Plasma::ConfigLoader::hasGroup$
    {45, 1481, 752},	// Plasma::ConfigLoader::property$
    {45, 2359, 755},	// Plasma::ConfigLoader::usrWriteConfig
    {45, 2422, 759},	// Plasma::ConfigLoader::~ConfigLoader
    {46, 101, 849},	// Plasma::Containment::Containment
    {46, 102, 850},	// Plasma::Containment::Containment#
    {46, 103, 851},	// Plasma::Containment::Containment#$
    {46, 104, 767},	// Plasma::Containment::Containment#$$
    {46, 105, 768},	// Plasma::Containment::Containment#?
    {46, 120, 866},	// Plasma::Containment::CustomContainment
    {46, 121, 867},	// Plasma::Containment::CustomPanelContainment
    {46, 141, 864},	// Plasma::Containment::DesktopContainment
    {46, 332, 863},	// Plasma::Containment::NoContainmentType
    {46, 362, 865},	// Plasma::Containment::PanelContainment
    {46, 571, 800},	// Plasma::Containment::activity
    {46, 579, 858},	// Plasma::Containment::addApplet#
    {46, 580, 859},	// Plasma::Containment::addApplet##
    {46, 581, 777},	// Plasma::Containment::addApplet##$
    {46, 582, 856},	// Plasma::Containment::addApplet$
    {46, 583, 857},	// Plasma::Containment::addApplet$?
    {46, 584, 776},	// Plasma::Containment::addApplet$?#
    {46, 586, 794},	// Plasma::Containment::addAssociatedWidget#
    {46, 620, 820},	// Plasma::Containment::addSiblingContainment
    {46, 621, 813},	// Plasma::Containment::addSiblingContainment#
    {46, 636, 788},	// Plasma::Containment::addToolBoxAction#
    {46, 666, 808},	// Plasma::Containment::appletAdded##
    {46, 671, 809},	// Plasma::Containment::appletRemoved#
    {46, 674, 778},	// Plasma::Containment::applets
    {46, 719, 779},	// Plasma::Containment::clearApplets
    {46, 731, 793},	// Plasma::Containment::closeToolBox
    {46, 740, 826},	// Plasma::Containment::configChanged
    {46, 748, 816},	// Plasma::Containment::configureRequested#
    {46, 767, 806},	// Plasma::Containment::containmentActions$
    {46, 768, 807},	// Plasma::Containment::containmentActionsConfig
    {46, 771, 805},	// Plasma::Containment::containmentActionsTriggers
    {46, 779, 770},	// Plasma::Containment::containmentType
    {46, 788, 801},	// Plasma::Containment::context
    {46, 791, 817},	// Plasma::Containment::contextChanged#
    {46, 795, 834},	// Plasma::Containment::contextMenuEvent#
    {46, 798, 771},	// Plasma::Containment::corona
    {46, 850, 783},	// Plasma::Containment::desktop
    {46, 852, 823},	// Plasma::Containment::destroy
    {46, 853, 824},	// Plasma::Containment::destroy$
    {46, 877, 839},	// Plasma::Containment::dragEnterEvent#
    {46, 879, 840},	// Plasma::Containment::dragLeaveEvent#
    {46, 881, 841},	// Plasma::Containment::dragMoveEvent#
    {46, 903, 796},	// Plasma::Containment::drawWallpaper
    {46, 907, 842},	// Plasma::Containment::dropEvent#
    {46, 937, 787},	// Plasma::Containment::enableAction$$
    {46, 1000, 821},	// Plasma::Containment::focusNextApplet
    {46, 1004, 822},	// Plasma::Containment::focusPreviousApplet
    {46, 1091, 769},	// Plasma::Containment::init
    {46, 1159, 791},	// Plasma::Containment::isToolBoxOpen
    {46, 1180, 838},	// Plasma::Containment::itemChange$#
    {46, 1199, 835},	// Plasma::Containment::keyPressEvent#
    {46, 1217, 784},	// Plasma::Containment::lastDesktop
    {46, 1219, 782},	// Plasma::Containment::lastScreen
    {46, 1251, 774},	// Plasma::Containment::listContainmentTypes
    {46, 1252, 852},	// Plasma::Containment::listContainments
    {46, 1253, 853},	// Plasma::Containment::listContainments$
    {46, 1254, 772},	// Plasma::Containment::listContainments$$
    {46, 1256, 775},	// Plasma::Containment::listContainmentsForMimetype$
    {46, 1258, 854},	// Plasma::Containment::listContainmentsOfType$
    {46, 1259, 855},	// Plasma::Containment::listContainmentsOfType$$
    {46, 1260, 773},	// Plasma::Containment::listContainmentsOfType$$$
    {46, 1351, 760},	// Plasma::Containment::metaObject
    {46, 1369, 831},	// Plasma::Containment::mouseMoveEvent#
    {46, 1371, 832},	// Plasma::Containment::mousePressEvent#
    {46, 1373, 833},	// Plasma::Containment::mouseReleaseEvent#
    {46, 1399, 792},	// Plasma::Containment::openToolBox
    {46, 1486, 766},	// Plasma::Containment::qt_metacall$$?
    {46, 1488, 761},	// Plasma::Containment::qt_metacast$
    {46, 1535, 795},	// Plasma::Containment::removeAssociatedWidget#
    {46, 1558, 789},	// Plasma::Containment::removeToolBoxAction#
    {46, 1585, 843},	// Plasma::Containment::resizeEvent#
    {46, 1590, 786},	// Plasma::Containment::restore#
    {46, 1592, 830},	// Plasma::Containment::restoreContents#
    {46, 1608, 785},	// Plasma::Containment::save#
    {46, 1610, 829},	// Plasma::Containment::saveContents#
    {46, 1622, 837},	// Plasma::Containment::sceneEventFilter##
    {46, 1626, 781},	// Plasma::Containment::screen
    {46, 1628, 815},	// Plasma::Containment::screenChanged$$#
    {46, 1661, 799},	// Plasma::Containment::setActivity$
    {46, 1732, 804},	// Plasma::Containment::setContainmentActions$$
    {46, 1736, 827},	// Plasma::Containment::setContainmentType$
    {46, 1792, 828},	// Plasma::Containment::setDrawWallpaper$
    {46, 1825, 819},	// Plasma::Containment::setFormFactor$
    {46, 1897, 818},	// Plasma::Containment::setLocation$
    {46, 2005, 860},	// Plasma::Containment::setScreen$
    {46, 2006, 780},	// Plasma::Containment::setScreen$$
    {46, 2097, 845},	// Plasma::Containment::setToolBox#
    {46, 2099, 790},	// Plasma::Containment::setToolBoxOpen$
    {46, 2143, 861},	// Plasma::Containment::setWallpaper$
    {46, 2144, 797},	// Plasma::Containment::setWallpaper$$
    {46, 2167, 814},	// Plasma::Containment::showAddWidgetsInterface#
    {46, 2169, 825},	// Plasma::Containment::showConfigurationInterface
    {46, 2172, 802},	// Plasma::Containment::showContextMenu##
    {46, 2176, 803},	// Plasma::Containment::showDropZone#
    {46, 2223, 862},	// Plasma::Containment::staticMetaObject
    {46, 2295, 846},	// Plasma::Containment::toolBox
    {46, 2296, 844},	// Plasma::Containment::toolBoxItem
    {46, 2297, 811},	// Plasma::Containment::toolBoxToggled
    {46, 2299, 812},	// Plasma::Containment::toolBoxVisibilityChanged$
    {46, 2305, 847},	// Plasma::Containment::tr$
    {46, 2306, 762},	// Plasma::Containment::tr$$
    {46, 2307, 764},	// Plasma::Containment::tr$$$
    {46, 2309, 848},	// Plasma::Containment::trUtf8$
    {46, 2310, 763},	// Plasma::Containment::trUtf8$$
    {46, 2311, 765},	// Plasma::Containment::trUtf8$$$
    {46, 2385, 798},	// Plasma::Containment::wallpaper
    {46, 2390, 836},	// Plasma::Containment::wheelEvent#
    {46, 2408, 810},	// Plasma::Containment::zoomRequested#$
    {46, 2423, 868},	// Plasma::Containment::~Containment
    {47, 461, 869},	// Plasma::Containment::StyleOption::StyleOption
    {47, 462, -46},	// Plasma::Containment::StyleOption::StyleOption#
    {47, 508, 874},	// Plasma::Containment::StyleOption::Type
    {47, 521, 875},	// Plasma::Containment::StyleOption::Version
    {47, 2139, 873},	// Plasma::Containment::StyleOption::setView#
    {47, 2374, 872},	// Plasma::Containment::StyleOption::view
    {47, 2467, 876},	// Plasma::Containment::StyleOption::~StyleOption
    {48, 106, 912},	// Plasma::ContainmentActions::ContainmentActions
    {48, 107, 884},	// Plasma::ContainmentActions::ContainmentActions#
    {48, 108, 905},	// Plasma::ContainmentActions::ContainmentActions#?
    {48, 744, 896},	// Plasma::ContainmentActions::configurationAccepted
    {48, 745, 900},	// Plasma::ContainmentActions::configurationRequired
    {48, 765, 908},	// Plasma::ContainmentActions::containment
    {48, 793, 897},	// Plasma::ContainmentActions::contextEvent#
    {48, 796, 898},	// Plasma::ContainmentActions::contextualActions
    {48, 806, 895},	// Plasma::ContainmentActions::createConfigurationInterface#
    {48, 840, 899},	// Plasma::ContainmentActions::dataEngine$
    {48, 953, 903},	// Plasma::ContainmentActions::event#
    {48, 957, 901},	// Plasma::ContainmentActions::eventToString#
    {48, 1075, 891},	// Plasma::ContainmentActions::icon
    {48, 1092, 906},	// Plasma::ContainmentActions::init#
    {48, 1136, 892},	// Plasma::ContainmentActions::isInitialized
    {48, 1250, 885},	// Plasma::ContainmentActions::listContainmentActionsInfo
    {48, 1283, 914},	// Plasma::ContainmentActions::load##
    {48, 1284, 887},	// Plasma::ContainmentActions::load##?
    {48, 1285, 913},	// Plasma::ContainmentActions::load#$
    {48, 1286, 886},	// Plasma::ContainmentActions::load#$?
    {48, 1351, 877},	// Plasma::ContainmentActions::metaObject
    {48, 1386, 889},	// Plasma::ContainmentActions::name
    {48, 1415, 888},	// Plasma::ContainmentActions::packageStructure
    {48, 1445, 909},	// Plasma::ContainmentActions::paste##
    {48, 1458, 890},	// Plasma::ContainmentActions::pluginName
    {48, 1468, 902},	// Plasma::ContainmentActions::popupPosition##
    {48, 1486, 883},	// Plasma::ContainmentActions::qt_metacall$$?
    {48, 1488, 878},	// Plasma::ContainmentActions::qt_metacast$
    {48, 1590, 893},	// Plasma::ContainmentActions::restore#
    {48, 1608, 894},	// Plasma::ContainmentActions::save#
    {48, 1726, 915},	// Plasma::ContainmentActions::setConfigurationRequired
    {48, 1727, 907},	// Plasma::ContainmentActions::setConfigurationRequired$
    {48, 1730, 904},	// Plasma::ContainmentActions::setContainment#
    {48, 2223, 916},	// Plasma::ContainmentActions::staticMetaObject
    {48, 2305, 910},	// Plasma::ContainmentActions::tr$
    {48, 2306, 879},	// Plasma::ContainmentActions::tr$$
    {48, 2307, 881},	// Plasma::ContainmentActions::tr$$$
    {48, 2309, 911},	// Plasma::ContainmentActions::trUtf8$
    {48, 2310, 880},	// Plasma::ContainmentActions::trUtf8$$
    {48, 2311, 882},	// Plasma::ContainmentActions::trUtf8$$$
    {48, 2424, 917},	// Plasma::ContainmentActions::~ContainmentActions
    {49, 109, 918},	// Plasma::ContainmentActionsPluginsConfig::ContainmentActionsPluginsConfig
    {49, 110, 919},	// Plasma::ContainmentActionsPluginsConfig::ContainmentActionsPluginsConfig#
    {49, 612, 923},	// Plasma::ContainmentActionsPluginsConfig::addPlugin#$
    {49, 613, -37},	// Plasma::ContainmentActionsPluginsConfig::addPlugin$$$
    {49, 717, 921},	// Plasma::ContainmentActionsPluginsConfig::clear
    {49, 1409, 920},	// Plasma::ContainmentActionsPluginsConfig::operator=#
    {49, 1528, 922},	// Plasma::ContainmentActionsPluginsConfig::remove#
    {49, 2425, 926},	// Plasma::ContainmentActionsPluginsConfig::~ContainmentActionsPluginsConfig
    {50, 112, 946},	// Plasma::Context::Context
    {50, 113, 934},	// Plasma::Context::Context#
    {50, 573, 942},	// Plasma::Context::activityChanged#
    {50, 713, 941},	// Plasma::Context::changed#
    {50, 804, 935},	// Plasma::Context::createActivity$
    {50, 819, 938},	// Plasma::Context::currentActivity
    {50, 820, 940},	// Plasma::Context::currentActivityId
    {50, 1235, 936},	// Plasma::Context::listActivities
    {50, 1316, 943},	// Plasma::Context::locationChanged#
    {50, 1351, 927},	// Plasma::Context::metaObject
    {50, 1486, 933},	// Plasma::Context::qt_metacall$$?
    {50, 1488, 928},	// Plasma::Context::qt_metacast$
    {50, 1752, 937},	// Plasma::Context::setCurrentActivity$
    {50, 1754, 939},	// Plasma::Context::setCurrentActivityId$
    {50, 2223, 947},	// Plasma::Context::staticMetaObject
    {50, 2305, 944},	// Plasma::Context::tr$
    {50, 2306, 929},	// Plasma::Context::tr$$
    {50, 2307, 931},	// Plasma::Context::tr$$$
    {50, 2309, 945},	// Plasma::Context::trUtf8$
    {50, 2310, 930},	// Plasma::Context::trUtf8$$
    {50, 2311, 932},	// Plasma::Context::trUtf8$$$
    {50, 2426, 948},	// Plasma::Context::~Context
    {51, 116, 1016},	// Plasma::Corona::Corona
    {51, 117, 956},	// Plasma::Corona::Corona#
    {51, 558, 976},	// Plasma::Corona::action$
    {51, 560, 978},	// Plasma::Corona::actions
    {51, 575, 982},	// Plasma::Corona::addAction$
    {51, 576, 977},	// Plasma::Corona::addAction$#
    {51, 588, 1017},	// Plasma::Corona::addContainment$
    {51, 589, 963},	// Plasma::Corona::addContainment$?
    {51, 591, 1018},	// Plasma::Corona::addContainmentDelayed$
    {51, 592, 964},	// Plasma::Corona::addContainmentDelayed$?
    {51, 608, 967},	// Plasma::Corona::addOffscreenWidget#
    {51, 619, 981},	// Plasma::Corona::addShortcuts#
    {51, 669, 958},	// Plasma::Corona::appletMimeType
    {51, 693, 972},	// Plasma::Corona::availableScreenRegion$
    {51, 694, 1003},	// Plasma::Corona::availableScreenRegionChanged
    {51, 721, 961},	// Plasma::Corona::clearContainments
    {51, 738, 962},	// Plasma::Corona::config
    {51, 743, 1002},	// Plasma::Corona::configSynced
    {51, 770, 984},	// Plasma::Corona::containmentActionsDefaults$
    {51, 773, 999},	// Plasma::Corona::containmentAdded#
    {51, 775, 1019},	// Plasma::Corona::containmentForScreen$
    {51, 776, 965},	// Plasma::Corona::containmentForScreen$$
    {51, 777, 1020},	// Plasma::Corona::containmentForScreen$$$
    {51, 778, 966},	// Plasma::Corona::containmentForScreen$$$?
    {51, 780, 960},	// Plasma::Corona::containments
    {51, 843, 959},	// Plasma::Corona::defaultContainmentPlugin
    {51, 858, 986},	// Plasma::Corona::dialogManager
    {51, 877, 1011},	// Plasma::Corona::dragEnterEvent#
    {51, 879, 1012},	// Plasma::Corona::dragLeaveEvent#
    {51, 881, 1013},	// Plasma::Corona::dragMoveEvent#
    {51, 937, 979},	// Plasma::Corona::enableAction$$
    {51, 965, 990},	// Plasma::Corona::exportLayout#?
    {51, 1018, 975},	// Plasma::Corona::freeEdges$
    {51, 1082, 994},	// Plasma::Corona::immutability
    {51, 1084, 1004},	// Plasma::Corona::immutabilityChanged$
    {51, 1087, -1},	// Plasma::Corona::importLayout#
    {51, 1098, 1021},	// Plasma::Corona::initializeLayout
    {51, 1099, 991},	// Plasma::Corona::initializeLayout$
    {51, 1227, 998},	// Plasma::Corona::layoutContainments
    {51, 1296, 1006},	// Plasma::Corona::loadDefaultLayout
    {51, 1301, 1022},	// Plasma::Corona::loadLayout
    {51, 1302, 992},	// Plasma::Corona::loadLayout$
    {51, 1328, -4},	// Plasma::Corona::mapAnimation$$
    {51, 1351, 949},	// Plasma::Corona::metaObject
    {51, 1396, 970},	// Plasma::Corona::numScreens
    {51, 1397, 969},	// Plasma::Corona::offscreenWidgets
    {51, 1468, 973},	// Plasma::Corona::popupPosition##
    {51, 1469, 974},	// Plasma::Corona::popupPosition##$
    {51, 1473, 988},	// Plasma::Corona::preferredToolBoxPlugin$
    {51, 1486, 955},	// Plasma::Corona::qt_metacall$$?
    {51, 1488, 950},	// Plasma::Corona::qt_metacast$
    {51, 1515, 1001},	// Plasma::Corona::releaseVisualFocus
    {51, 1548, 968},	// Plasma::Corona::removeOffscreenWidget#
    {51, 1574, 996},	// Plasma::Corona::requestConfigSync
    {51, 1575, 997},	// Plasma::Corona::requireConfigSync
    {51, 1611, 1023},	// Plasma::Corona::saveLayout
    {51, 1612, 993},	// Plasma::Corona::saveLayout$
    {51, 1630, 971},	// Plasma::Corona::screenGeometry$
    {51, 1632, 1000},	// Plasma::Corona::screenOwnerChanged$$#
    {51, 1673, 957},	// Plasma::Corona::setAppletMimeType$
    {51, 1734, 983},	// Plasma::Corona::setContainmentActionsDefaults$#
    {51, 1769, 1010},	// Plasma::Corona::setDefaultContainmentPlugin$
    {51, 1784, 985},	// Plasma::Corona::setDialogManager#
    {51, 1872, 995},	// Plasma::Corona::setImmutability$
    {51, 1967, 1009},	// Plasma::Corona::setPreferredToolBoxPlugin$$
    {51, 2162, 1005},	// Plasma::Corona::shortcutsChanged
    {51, 2223, 1024},	// Plasma::Corona::staticMetaObject
    {51, 2305, 1014},	// Plasma::Corona::tr$
    {51, 2306, 951},	// Plasma::Corona::tr$$
    {51, 2307, 953},	// Plasma::Corona::tr$$$
    {51, 2309, 1015},	// Plasma::Corona::trUtf8$
    {51, 2310, 952},	// Plasma::Corona::trUtf8$$
    {51, 2311, 954},	// Plasma::Corona::trUtf8$$$
    {51, 2342, 980},	// Plasma::Corona::updateShortcuts
    {51, 2427, 1025},	// Plasma::Corona::~Corona
    {52, 122, 1056},	// Plasma::DataContainer::DataContainer
    {52, 123, 1033},	// Plasma::DataContainer::DataContainer#
    {52, 699, 1047},	// Plasma::DataContainer::becameUnused$
    {52, 714, 1049},	// Plasma::DataContainer::checkForUpdate
    {52, 715, 1052},	// Plasma::DataContainer::checkUsage
    {52, 759, 1038},	// Plasma::DataContainer::connectVisualization#$$
    {52, 838, 1034},	// Plasma::DataContainer::data
    {52, 842, 1046},	// Plasma::DataContainer::dataUpdated$?
    {52, 871, 1044},	// Plasma::DataContainer::disconnectVisualization#
    {52, 1010, 1045},	// Plasma::DataContainer::forceImmediateUpdate
    {52, 1022, 1043},	// Plasma::DataContainer::getDataEngine
    {52, 1155, 1040},	// Plasma::DataContainer::isStorageEnabled
    {52, 1351, 1026},	// Plasma::DataContainer::metaObject
    {52, 1390, 1041},	// Plasma::DataContainer::needsToBeStored
    {52, 1486, 1032},	// Plasma::DataContainer::qt_metacall$$?
    {52, 1488, 1027},	// Plasma::DataContainer::qt_metacast$
    {52, 1531, 1036},	// Plasma::DataContainer::removeAllData
    {52, 1763, 1035},	// Plasma::DataContainer::setData$#
    {52, 1926, 1042},	// Plasma::DataContainer::setNeedsToBeStored$
    {52, 1927, 1057},	// Plasma::DataContainer::setNeedsUpdate
    {52, 1928, 1051},	// Plasma::DataContainer::setNeedsUpdate$
    {52, 2046, 1039},	// Plasma::DataContainer::setStorageEnabled$
    {52, 2223, 1058},	// Plasma::DataContainer::staticMetaObject
    {52, 2288, 1050},	// Plasma::DataContainer::timeSinceLastUpdate
    {52, 2290, 1053},	// Plasma::DataContainer::timerEvent#
    {52, 2305, 1054},	// Plasma::DataContainer::tr$
    {52, 2306, 1028},	// Plasma::DataContainer::tr$$
    {52, 2307, 1030},	// Plasma::DataContainer::tr$$$
    {52, 2309, 1055},	// Plasma::DataContainer::trUtf8$
    {52, 2310, 1029},	// Plasma::DataContainer::trUtf8$$
    {52, 2311, 1031},	// Plasma::DataContainer::trUtf8$$$
    {52, 2341, 1048},	// Plasma::DataContainer::updateRequested#
    {52, 2384, 1037},	// Plasma::DataContainer::visualizationIsConnected#
    {52, 2428, 1059},	// Plasma::DataContainer::~DataContainer
    {53, 124, 1113},	// Plasma::DataEngine::DataEngine
    {53, 125, 1114},	// Plasma::DataEngine::DataEngine#
    {53, 126, -24},	// Plasma::DataEngine::DataEngine#?
    {53, 623, 1094},	// Plasma::DataEngine::addSource#
    {53, 750, 1117},	// Plasma::DataEngine::connectAllSources#
    {53, 751, 1118},	// Plasma::DataEngine::connectAllSources#$
    {53, 752, 1074},	// Plasma::DataEngine::connectAllSources#$$
    {53, 755, 1115},	// Plasma::DataEngine::connectSource$#
    {53, 756, 1116},	// Plasma::DataEngine::connectSource$#$
    {53, 757, 1073},	// Plasma::DataEngine::connectSource$#$$
    {53, 762, 1101},	// Plasma::DataEngine::containerDict
    {53, 764, 1076},	// Plasma::DataEngine::containerForSource$
    {53, 807, 1119},	// Plasma::DataEngine::createDefaultService
    {53, 808, 1084},	// Plasma::DataEngine::createDefaultService#
    {53, 869, 1075},	// Plasma::DataEngine::disconnectSource$#
    {53, 1011, 1110},	// Plasma::DataEngine::forceImmediateUpdateOfAllVisualizations
    {53, 1075, 1081},	// Plasma::DataEngine::icon
    {53, 1091, 1069},	// Plasma::DataEngine::init
    {53, 1131, 1079},	// Plasma::DataEngine::isEmpty
    {53, 1164, 1078},	// Plasma::DataEngine::isValid
    {53, 1345, 1080},	// Plasma::DataEngine::maxSourceCount
    {53, 1351, 1060},	// Plasma::DataEngine::metaObject
    {53, 1363, 1097},	// Plasma::DataEngine::minimumPollingInterval
    {53, 1386, 1072},	// Plasma::DataEngine::name
    {53, 1414, 1082},	// Plasma::DataEngine::package
    {53, 1458, 1083},	// Plasma::DataEngine::pluginName
    {53, 1486, 1066},	// Plasma::DataEngine::qt_metacall$$?
    {53, 1488, 1061},	// Plasma::DataEngine::qt_metacast$
    {53, 1490, 1077},	// Plasma::DataEngine::query$
    {53, 1532, 1092},	// Plasma::DataEngine::removeAllData$
    {53, 1533, 1099},	// Plasma::DataEngine::removeAllSources
    {53, 1537, 1093},	// Plasma::DataEngine::removeData$$
    {53, 1552, 1108},	// Plasma::DataEngine::removeSource$
    {53, 1625, 1107},	// Plasma::DataEngine::scheduleSourcesUpdated
    {53, 1649, 1071},	// Plasma::DataEngine::serviceForSource$
    {53, 1763, 1089},	// Plasma::DataEngine::setData$#
    {53, 1764, 1090},	// Plasma::DataEngine::setData$$#
    {53, 1765, 1091},	// Plasma::DataEngine::setData$?
    {53, 1775, 1105},	// Plasma::DataEngine::setDefaultService$
    {53, 1860, 1104},	// Plasma::DataEngine::setIcon$
    {53, 1901, 1095},	// Plasma::DataEngine::setMaxSourceCount$
    {53, 1915, 1096},	// Plasma::DataEngine::setMinimumPollingInterval$
    {53, 1922, 1103},	// Plasma::DataEngine::setName$
    {53, 1958, 1098},	// Plasma::DataEngine::setPollingInterval$
    {53, 2047, 1106},	// Plasma::DataEngine::setStorageEnabled$$
    {53, 2123, 1100},	// Plasma::DataEngine::setValid$
    {53, 2208, 1085},	// Plasma::DataEngine::sourceAdded$
    {53, 2210, 1086},	// Plasma::DataEngine::sourceRemoved$
    {53, 2212, 1087},	// Plasma::DataEngine::sourceRequestEvent$
    {53, 2213, 1070},	// Plasma::DataEngine::sources
    {53, 2223, 1120},	// Plasma::DataEngine::staticMetaObject
    {53, 2290, 1102},	// Plasma::DataEngine::timerEvent#
    {53, 2305, 1111},	// Plasma::DataEngine::tr$
    {53, 2306, 1062},	// Plasma::DataEngine::tr$$
    {53, 2307, 1064},	// Plasma::DataEngine::tr$$$
    {53, 2309, 1112},	// Plasma::DataEngine::trUtf8$
    {53, 2310, 1063},	// Plasma::DataEngine::trUtf8$$
    {53, 2311, 1065},	// Plasma::DataEngine::trUtf8$$$
    {53, 2331, 1109},	// Plasma::DataEngine::updateAllSources
    {53, 2344, 1088},	// Plasma::DataEngine::updateSourceEvent$
    {53, 2429, 1121},	// Plasma::DataEngine::~DataEngine
    {54, 943, 1130},	// Plasma::DataEngineManager::engine$
    {54, 1236, 1139},	// Plasma::DataEngineManager::listAllEngines
    {54, 1237, 1133},	// Plasma::DataEngineManager::listAllEngines$
    {54, 1261, 1140},	// Plasma::DataEngineManager::listEngineInfo
    {54, 1262, 1134},	// Plasma::DataEngineManager::listEngineInfo$
    {54, 1264, 1141},	// Plasma::DataEngineManager::listEngineInfoByCategory$
    {54, 1265, 1135},	// Plasma::DataEngineManager::listEngineInfoByCategory$$
    {54, 1298, 1131},	// Plasma::DataEngineManager::loadEngine$
    {54, 1351, 1122},	// Plasma::DataEngineManager::metaObject
    {54, 1486, 1128},	// Plasma::DataEngineManager::qt_metacall$$?
    {54, 1488, 1123},	// Plasma::DataEngineManager::qt_metacast$
    {54, 1646, 1129},	// Plasma::DataEngineManager::self
    {54, 2223, 1142},	// Plasma::DataEngineManager::staticMetaObject
    {54, 2290, 1136},	// Plasma::DataEngineManager::timerEvent#
    {54, 2305, 1137},	// Plasma::DataEngineManager::tr$
    {54, 2306, 1124},	// Plasma::DataEngineManager::tr$$
    {54, 2307, 1126},	// Plasma::DataEngineManager::tr$$$
    {54, 2309, 1138},	// Plasma::DataEngineManager::trUtf8$
    {54, 2310, 1125},	// Plasma::DataEngineManager::trUtf8$$
    {54, 2311, 1127},	// Plasma::DataEngineManager::trUtf8$$$
    {54, 2321, 1132},	// Plasma::DataEngineManager::unloadEngine$
    {55, 128, 1180},	// Plasma::DataEngineScript::DataEngineScript
    {55, 129, 1150},	// Plasma::DataEngineScript::DataEngineScript#
    {55, 623, 1170},	// Plasma::DataEngineScript::addSource#
    {55, 762, 1171},	// Plasma::DataEngineScript::containerDict
    {55, 839, 1152},	// Plasma::DataEngineScript::dataEngine
    {55, 849, 1159},	// Plasma::DataEngineScript::description
    {55, 1011, 1177},	// Plasma::DataEngineScript::forceImmediateUpdateOfAllVisualizations
    {55, 1324, 1157},	// Plasma::DataEngineScript::mainScript
    {55, 1351, 1143},	// Plasma::DataEngineScript::metaObject
    {55, 1363, 1167},	// Plasma::DataEngineScript::minimumPollingInterval
    {55, 1414, 1158},	// Plasma::DataEngineScript::package
    {55, 1486, 1149},	// Plasma::DataEngineScript::qt_metacall$$?
    {55, 1488, 1144},	// Plasma::DataEngineScript::qt_metacast$
    {55, 1532, 1163},	// Plasma::DataEngineScript::removeAllData$
    {55, 1533, 1169},	// Plasma::DataEngineScript::removeAllSources
    {55, 1537, 1164},	// Plasma::DataEngineScript::removeData$$
    {55, 1552, 1175},	// Plasma::DataEngineScript::removeSource$
    {55, 1625, 1174},	// Plasma::DataEngineScript::scheduleSourcesUpdated
    {55, 1649, 1156},	// Plasma::DataEngineScript::serviceForSource$
    {55, 1763, 1161},	// Plasma::DataEngineScript::setData$#
    {55, 1764, 1160},	// Plasma::DataEngineScript::setData$$#
    {55, 1765, 1162},	// Plasma::DataEngineScript::setData$?
    {55, 1767, 1151},	// Plasma::DataEngineScript::setDataEngine#
    {55, 1860, 1173},	// Plasma::DataEngineScript::setIcon$
    {55, 1901, 1165},	// Plasma::DataEngineScript::setMaxSourceCount$
    {55, 1915, 1166},	// Plasma::DataEngineScript::setMinimumPollingInterval$
    {55, 1922, 1172},	// Plasma::DataEngineScript::setName$
    {55, 1958, 1168},	// Plasma::DataEngineScript::setPollingInterval$
    {55, 2212, 1154},	// Plasma::DataEngineScript::sourceRequestEvent$
    {55, 2213, 1153},	// Plasma::DataEngineScript::sources
    {55, 2223, 1181},	// Plasma::DataEngineScript::staticMetaObject
    {55, 2305, 1178},	// Plasma::DataEngineScript::tr$
    {55, 2306, 1145},	// Plasma::DataEngineScript::tr$$
    {55, 2307, 1147},	// Plasma::DataEngineScript::tr$$$
    {55, 2309, 1179},	// Plasma::DataEngineScript::trUtf8$
    {55, 2310, 1146},	// Plasma::DataEngineScript::trUtf8$$
    {55, 2311, 1148},	// Plasma::DataEngineScript::trUtf8$$$
    {55, 2331, 1176},	// Plasma::DataEngineScript::updateAllSources
    {55, 2344, 1155},	// Plasma::DataEngineScript::updateSourceEvent$
    {55, 2430, 1182},	// Plasma::DataEngineScript::~DataEngineScript
    {56, 88, 1205},	// Plasma::Delegate::ColumnTypeRole
    {56, 135, 1201},	// Plasma::Delegate::Delegate
    {56, 136, 1190},	// Plasma::Delegate::Delegate#
    {56, 307, 1206},	// Plasma::Delegate::MainColumn
    {56, 428, 1207},	// Plasma::Delegate::SecondaryActionColumn
    {56, 464, 1204},	// Plasma::Delegate::SubTitleMandatoryRole
    {56, 465, 1203},	// Plasma::Delegate::SubTitleRole
    {56, 935, 1197},	// Plasma::Delegate::emptyRect##
    {56, 1351, 1183},	// Plasma::Delegate::metaObject
    {56, 1422, 1193},	// Plasma::Delegate::paint###
    {56, 1486, 1189},	// Plasma::Delegate::qt_metacall$$?
    {56, 1488, 1184},	// Plasma::Delegate::qt_metacast$
    {56, 1499, 1196},	// Plasma::Delegate::rectAfterSubTitle##
    {56, 1501, 1195},	// Plasma::Delegate::rectAfterTitle##
    {56, 1596, 1192},	// Plasma::Delegate::roleMapping$
    {56, 1997, 1191},	// Plasma::Delegate::setRoleMapping$$
    {56, 2185, 1194},	// Plasma::Delegate::showToolTip
    {56, 2199, 1198},	// Plasma::Delegate::sizeHint##
    {56, 2223, 1202},	// Plasma::Delegate::staticMetaObject
    {56, 2305, 1199},	// Plasma::Delegate::tr$
    {56, 2306, 1185},	// Plasma::Delegate::tr$$
    {56, 2307, 1187},	// Plasma::Delegate::tr$$$
    {56, 2309, 1200},	// Plasma::Delegate::trUtf8$
    {56, 2310, 1186},	// Plasma::Delegate::trUtf8$$
    {56, 2311, 1188},	// Plasma::Delegate::trUtf8$$$
    {56, 2431, 1208},	// Plasma::Delegate::~Delegate
    {57, 22, 1254},	// Plasma::Dialog::All
    {57, 146, 1246},	// Plasma::Dialog::Dialog
    {57, 147, 1247},	// Plasma::Dialog::Dialog#
    {57, 148, 1216},	// Plasma::Dialog::Dialog#$
    {57, 334, 1249},	// Plasma::Dialog::NoCorner
    {57, 347, 1250},	// Plasma::Dialog::NorthEast
    {57, 348, 1252},	// Plasma::Dialog::NorthWest
    {57, 452, 1251},	// Plasma::Dialog::SouthEast
    {57, 453, 1253},	// Plasma::Dialog::SouthWest
    {57, 645, 1224},	// Plasma::Dialog::animatedHide$
    {57, 647, 1225},	// Plasma::Dialog::animatedShow$
    {57, 676, 1226},	// Plasma::Dialog::aspectRatioMode
    {57, 859, 1228},	// Plasma::Dialog::dialogResized
    {57, 861, 1229},	// Plasma::Dialog::dialogVisible$
    {57, 953, 1232},	// Plasma::Dialog::event#
    {57, 955, 1234},	// Plasma::Dialog::eventFilter##
    {57, 999, 1237},	// Plasma::Dialog::focusInEvent#
    {57, 1026, 1223},	// Plasma::Dialog::getMinimumResizeLimits$$$$
    {57, 1033, 1218},	// Plasma::Dialog::graphicsWidget
    {57, 1060, 1235},	// Plasma::Dialog::hideEvent#
    {57, 1089, 1243},	// Plasma::Dialog::inControlArea#
    {57, 1162, 1221},	// Plasma::Dialog::isUserResizing
    {57, 1199, 1241},	// Plasma::Dialog::keyPressEvent#
    {57, 1351, 1209},	// Plasma::Dialog::metaObject
    {57, 1369, 1238},	// Plasma::Dialog::mouseMoveEvent#
    {57, 1371, 1239},	// Plasma::Dialog::mousePressEvent#
    {57, 1373, 1240},	// Plasma::Dialog::mouseReleaseEvent#
    {57, 1375, 1242},	// Plasma::Dialog::moveEvent#
    {57, 1430, 1231},	// Plasma::Dialog::paintEvent#
    {57, 1486, 1215},	// Plasma::Dialog::qt_metacall$$?
    {57, 1488, 1210},	// Plasma::Dialog::qt_metacast$
    {57, 1583, 1220},	// Plasma::Dialog::resizeCorners
    {57, 1585, 1233},	// Plasma::Dialog::resizeEvent#
    {57, 1677, 1227},	// Plasma::Dialog::setAspectRatioMode$
    {57, 1833, 1217},	// Plasma::Dialog::setGraphicsWidget#
    {57, 1917, 1222},	// Plasma::Dialog::setMinimumResizeLimits$$$$
    {57, 1993, 1219},	// Plasma::Dialog::setResizeHandleCorners$
    {57, 2178, 1236},	// Plasma::Dialog::showEvent#
    {57, 2223, 1248},	// Plasma::Dialog::staticMetaObject
    {57, 2253, 1230},	// Plasma::Dialog::syncToGraphicsWidget
    {57, 2305, 1244},	// Plasma::Dialog::tr$
    {57, 2306, 1211},	// Plasma::Dialog::tr$$
    {57, 2307, 1213},	// Plasma::Dialog::tr$$$
    {57, 2309, 1245},	// Plasma::Dialog::trUtf8$
    {57, 2310, 1212},	// Plasma::Dialog::trUtf8$$
    {57, 2311, 1214},	// Plasma::Dialog::trUtf8$$$
    {57, 2432, 1255},	// Plasma::Dialog::~Dialog
    {58, 64, 1299},	// Plasma::Extender::BottomUpStacked
    {58, 167, 1263},	// Plasma::Extender::Extender#
    {58, 328, 1298},	// Plasma::Extender::NoBorders
    {58, 496, 1300},	// Plasma::Extender::TopDownStacked
    {58, 660, 1274},	// Plasma::Extender::appearance
    {58, 664, 1276},	// Plasma::Extender::applet
    {58, 683, 1267},	// Plasma::Extender::attachedItems
    {58, 856, 1268},	// Plasma::Extender::detachedItems
    {58, 877, 1287},	// Plasma::Extender::dragEnterEvent#
    {58, 879, 1289},	// Plasma::Extender::dragLeaveEvent#
    {58, 881, 1288},	// Plasma::Extender::dragMoveEvent#
    {58, 907, 1290},	// Plasma::Extender::dropEvent#
    {58, 933, 1265},	// Plasma::Extender::emptyExtenderMessage
    {58, 940, 1283},	// Plasma::Extender::enabledBordersForItem#
    {58, 1020, 1293},	// Plasma::Extender::geometryChanged
    {58, 1035, 1270},	// Plasma::Extender::group$
    {58, 1037, 1275},	// Plasma::Extender::groups
    {58, 1049, 1271},	// Plasma::Extender::hasItem$
    {58, 1131, 1272},	// Plasma::Extender::isEmpty
    {58, 1169, 1269},	// Plasma::Extender::item$
    {58, 1173, 1296},	// Plasma::Extender::itemAddedEvent#
    {58, 1174, 1277},	// Plasma::Extender::itemAddedEvent##
    {58, 1178, 1291},	// Plasma::Extender::itemAttached#
    {58, 1180, 1284},	// Plasma::Extender::itemChange$#
    {58, 1182, 1292},	// Plasma::Extender::itemDetached#
    {58, 1186, 1279},	// Plasma::Extender::itemHoverEnterEvent#
    {58, 1188, 1281},	// Plasma::Extender::itemHoverLeaveEvent#
    {58, 1190, 1280},	// Plasma::Extender::itemHoverMoveEvent##
    {58, 1192, 1278},	// Plasma::Extender::itemRemovedEvent#
    {58, 1197, 1266},	// Plasma::Extender::items
    {58, 1351, 1256},	// Plasma::Extender::metaObject
    {58, 1371, 1286},	// Plasma::Extender::mousePressEvent#
    {58, 1486, 1262},	// Plasma::Extender::qt_metacall$$?
    {58, 1488, 1257},	// Plasma::Extender::qt_metacast$
    {58, 1585, 1285},	// Plasma::Extender::resizeEvent#
    {58, 1613, 1282},	// Plasma::Extender::saveState
    {58, 1669, 1273},	// Plasma::Extender::setAppearance$
    {58, 1805, 1264},	// Plasma::Extender::setEmptyExtenderMessage$
    {58, 2223, 1297},	// Plasma::Extender::staticMetaObject
    {58, 2305, 1294},	// Plasma::Extender::tr$
    {58, 2306, 1258},	// Plasma::Extender::tr$$
    {58, 2307, 1260},	// Plasma::Extender::tr$$$
    {58, 2309, 1295},	// Plasma::Extender::trUtf8$
    {58, 2310, 1259},	// Plasma::Extender::trUtf8$$
    {58, 2311, 1261},	// Plasma::Extender::trUtf8$$$
    {58, 2433, 1301},	// Plasma::Extender::~Extender
    {59, 169, 1327},	// Plasma::ExtenderGroup::ExtenderGroup#
    {59, 170, 1309},	// Plasma::ExtenderGroup::ExtenderGroup#$
    {59, 689, 1311},	// Plasma::ExtenderGroup::autoHide
    {59, 732, 1318},	// Plasma::ExtenderGroup::collapseGroup
    {59, 877, 1321},	// Plasma::ExtenderGroup::dragEnterEvent#
    {59, 879, 1323},	// Plasma::ExtenderGroup::dragLeaveEvent#
    {59, 881, 1322},	// Plasma::ExtenderGroup::dragMoveEvent#
    {59, 907, 1324},	// Plasma::ExtenderGroup::dropEvent#
    {59, 955, 1320},	// Plasma::ExtenderGroup::eventFilter##
    {59, 963, 1317},	// Plasma::ExtenderGroup::expandGroup
    {59, 1121, 1314},	// Plasma::ExtenderGroup::isAutoCollapse
    {59, 1134, 1313},	// Plasma::ExtenderGroup::isGroupCollapsed
    {59, 1197, 1310},	// Plasma::ExtenderGroup::items
    {59, 1351, 1302},	// Plasma::ExtenderGroup::metaObject
    {59, 1486, 1308},	// Plasma::ExtenderGroup::qt_metacall$$?
    {59, 1488, 1303},	// Plasma::ExtenderGroup::qt_metacast$
    {59, 1585, 1319},	// Plasma::ExtenderGroup::resizeEvent#
    {59, 1689, 1315},	// Plasma::ExtenderGroup::setAutoCollapse$
    {59, 1693, 1312},	// Plasma::ExtenderGroup::setAutoHide$
    {59, 1838, 1316},	// Plasma::ExtenderGroup::setGroupCollapsed$
    {59, 2223, 1328},	// Plasma::ExtenderGroup::staticMetaObject
    {59, 2305, 1325},	// Plasma::ExtenderGroup::tr$
    {59, 2306, 1304},	// Plasma::ExtenderGroup::tr$$
    {59, 2307, 1306},	// Plasma::ExtenderGroup::tr$$$
    {59, 2309, 1326},	// Plasma::ExtenderGroup::trUtf8$
    {59, 2310, 1305},	// Plasma::ExtenderGroup::trUtf8$$
    {59, 2311, 1307},	// Plasma::ExtenderGroup::trUtf8$$$
    {59, 2434, 1329},	// Plasma::ExtenderGroup::~ExtenderGroup
    {60, 172, 1381},	// Plasma::ExtenderItem::ExtenderItem#
    {60, 173, 1337},	// Plasma::ExtenderItem::ExtenderItem#$
    {60, 558, 1359},	// Plasma::ExtenderItem::action$
    {60, 576, 1358},	// Plasma::ExtenderItem::addAction$#
    {60, 688, 1355},	// Plasma::ExtenderItem::autoExpireDelay
    {60, 738, 1338},	// Plasma::ExtenderItem::config
    {60, 852, 1362},	// Plasma::ExtenderItem::destroy
    {60, 855, 1367},	// Plasma::ExtenderItem::destroyed#
    {60, 966, 1349},	// Plasma::ExtenderItem::extender
    {60, 1034, 1352},	// Plasma::ExtenderItem::group
    {60, 1058, 1366},	// Plasma::ExtenderItem::hideCloseButton
    {60, 1071, 1376},	// Plasma::ExtenderItem::hoverLeaveEvent#
    {60, 1073, 1375},	// Plasma::ExtenderItem::hoverMoveEvent#
    {60, 1075, 1347},	// Plasma::ExtenderItem::icon
    {60, 1127, 1357},	// Plasma::ExtenderItem::isCollapsed
    {60, 1129, 1356},	// Plasma::ExtenderItem::isDetached
    {60, 1133, 1353},	// Plasma::ExtenderItem::isGroup
    {60, 1160, 1361},	// Plasma::ExtenderItem::isTransient
    {60, 1351, 1330},	// Plasma::ExtenderItem::metaObject
    {60, 1367, 1372},	// Plasma::ExtenderItem::mouseDoubleClickEvent#
    {60, 1369, 1373},	// Plasma::ExtenderItem::mouseMoveEvent#
    {60, 1371, 1371},	// Plasma::ExtenderItem::mousePressEvent#
    {60, 1373, 1374},	// Plasma::ExtenderItem::mouseReleaseEvent#
    {60, 1375, 1369},	// Plasma::ExtenderItem::moveEvent#
    {60, 1386, 1344},	// Plasma::ExtenderItem::name
    {60, 1422, 1368},	// Plasma::ExtenderItem::paint###
    {60, 1486, 1336},	// Plasma::ExtenderItem::qt_metacall$$?
    {60, 1488, 1331},	// Plasma::ExtenderItem::qt_metacast$
    {60, 1585, 1370},	// Plasma::ExtenderItem::resizeEvent#
    {60, 1594, 1364},	// Plasma::ExtenderItem::returnToSource
    {60, 1622, 1377},	// Plasma::ExtenderItem::sceneEventFilter##
    {60, 1691, 1354},	// Plasma::ExtenderItem::setAutoExpireDelay$
    {60, 1723, 1363},	// Plasma::ExtenderItem::setCollapsed$
    {60, 1811, 1382},	// Plasma::ExtenderItem::setExtender#
    {60, 1812, 1348},	// Plasma::ExtenderItem::setExtender##
    {60, 1835, 1350},	// Plasma::ExtenderItem::setGroup#
    {60, 1836, 1351},	// Plasma::ExtenderItem::setGroup##
    {60, 1859, 1346},	// Plasma::ExtenderItem::setIcon#
    {60, 1860, 1345},	// Plasma::ExtenderItem::setIcon$
    {60, 1922, 1343},	// Plasma::ExtenderItem::setName$
    {60, 2095, 1341},	// Plasma::ExtenderItem::setTitle$
    {60, 2103, 1360},	// Plasma::ExtenderItem::setTransient$
    {60, 2150, 1339},	// Plasma::ExtenderItem::setWidget#
    {60, 2168, 1365},	// Plasma::ExtenderItem::showCloseButton
    {60, 2201, 1378},	// Plasma::ExtenderItem::sizeHint$#
    {60, 2223, 1383},	// Plasma::ExtenderItem::staticMetaObject
    {60, 2291, 1342},	// Plasma::ExtenderItem::title
    {60, 2305, 1379},	// Plasma::ExtenderItem::tr$
    {60, 2306, 1332},	// Plasma::ExtenderItem::tr$$
    {60, 2307, 1334},	// Plasma::ExtenderItem::tr$$$
    {60, 2309, 1380},	// Plasma::ExtenderItem::trUtf8$
    {60, 2310, 1333},	// Plasma::ExtenderItem::trUtf8$$
    {60, 2311, 1335},	// Plasma::ExtenderItem::trUtf8$$$
    {60, 2391, 1340},	// Plasma::ExtenderItem::widget
    {60, 2435, 1384},	// Plasma::ExtenderItem::~ExtenderItem
    {61, 181, 1410},	// Plasma::FlashingLabel::FlashingLabel
    {61, 182, 1392},	// Plasma::FlashingLabel::FlashingLabel#
    {61, 691, 1403},	// Plasma::FlashingLabel::autohide
    {61, 735, 1396},	// Plasma::FlashingLabel::color
    {61, 908, 1398},	// Plasma::FlashingLabel::duration
    {61, 970, 1406},	// Plasma::FlashingLabel::fadeIn
    {61, 971, 1407},	// Plasma::FlashingLabel::fadeOut
    {61, 989, 1414},	// Plasma::FlashingLabel::flash#
    {61, 990, 1415},	// Plasma::FlashingLabel::flash#$
    {61, 991, 1401},	// Plasma::FlashingLabel::flash#$$
    {61, 992, 1412},	// Plasma::FlashingLabel::flash$
    {61, 993, 1413},	// Plasma::FlashingLabel::flash$$
    {61, 994, 1400},	// Plasma::FlashingLabel::flash$$#
    {61, 1005, 1394},	// Plasma::FlashingLabel::font
    {61, 1203, 1405},	// Plasma::FlashingLabel::kill
    {61, 1351, 1385},	// Plasma::FlashingLabel::metaObject
    {61, 1421, 1411},	// Plasma::FlashingLabel::paint##
    {61, 1422, 1393},	// Plasma::FlashingLabel::paint###
    {61, 1486, 1391},	// Plasma::FlashingLabel::qt_metacall$$?
    {61, 1488, 1386},	// Plasma::FlashingLabel::qt_metacast$
    {61, 1697, 1402},	// Plasma::FlashingLabel::setAutohide$
    {61, 1725, 1397},	// Plasma::FlashingLabel::setColor#
    {61, 1794, 1399},	// Plasma::FlashingLabel::setDuration$
    {61, 1820, 1395},	// Plasma::FlashingLabel::setFont#
    {61, 2201, 1404},	// Plasma::FlashingLabel::sizeHint$#
    {61, 2223, 1416},	// Plasma::FlashingLabel::staticMetaObject
    {61, 2305, 1408},	// Plasma::FlashingLabel::tr$
    {61, 2306, 1387},	// Plasma::FlashingLabel::tr$$
    {61, 2307, 1389},	// Plasma::FlashingLabel::tr$$$
    {61, 2309, 1409},	// Plasma::FlashingLabel::trUtf8$
    {61, 2310, 1388},	// Plasma::FlashingLabel::trUtf8$$
    {61, 2311, 1390},	// Plasma::FlashingLabel::trUtf8$$$
    {61, 2436, 1417},	// Plasma::FlashingLabel::~FlashingLabel
    {62, 188, 1443},	// Plasma::Frame::Frame
    {62, 189, 1425},	// Plasma::Frame::Frame#
    {62, 372, 1446},	// Plasma::Frame::Plain
    {62, 392, 1447},	// Plasma::Frame::Raised
    {62, 467, 1448},	// Plasma::Frame::Sunken
    {62, 711, 1440},	// Plasma::Frame::changeEvent#
    {62, 938, 1429},	// Plasma::Frame::enabledBorders
    {62, 1015, 1427},	// Plasma::Frame::frameShadow
    {62, 1079, 1433},	// Plasma::Frame::image
    {62, 1351, 1418},	// Plasma::Frame::metaObject
    {62, 1388, 1436},	// Plasma::Frame::nativeWidget
    {62, 1421, 1444},	// Plasma::Frame::paint##
    {62, 1422, 1437},	// Plasma::Frame::paint###
    {62, 1486, 1424},	// Plasma::Frame::qt_metacall$$?
    {62, 1488, 1419},	// Plasma::Frame::qt_metacast$
    {62, 1585, 1438},	// Plasma::Frame::resizeEvent#
    {62, 1809, 1428},	// Plasma::Frame::setEnabledBorders$
    {62, 1827, 1426},	// Plasma::Frame::setFrameShadow$
    {62, 1867, 1432},	// Plasma::Frame::setImage$
    {62, 2049, 1434},	// Plasma::Frame::setStyleSheet$
    {62, 2081, 1430},	// Plasma::Frame::setText$
    {62, 2201, 1439},	// Plasma::Frame::sizeHint$#
    {62, 2223, 1445},	// Plasma::Frame::staticMetaObject
    {62, 2236, 1435},	// Plasma::Frame::styleSheet
    {62, 2274, 1431},	// Plasma::Frame::text
    {62, 2305, 1441},	// Plasma::Frame::tr$
    {62, 2306, 1420},	// Plasma::Frame::tr$$
    {62, 2307, 1422},	// Plasma::Frame::tr$$$
    {62, 2309, 1442},	// Plasma::Frame::trUtf8$
    {62, 2310, 1421},	// Plasma::Frame::trUtf8$$
    {62, 2311, 1423},	// Plasma::Frame::trUtf8$$$
    {62, 2437, 1449},	// Plasma::Frame::~Frame
    {63, 23, 1490},	// Plasma::FrameSvg::AllBorders
    {63, 58, 1487},	// Plasma::FrameSvg::BottomBorder
    {63, 190, 1481},	// Plasma::FrameSvg::FrameSvg
    {63, 191, 1457},	// Plasma::FrameSvg::FrameSvg#
    {63, 293, 1488},	// Plasma::FrameSvg::LeftBorder
    {63, 327, 1485},	// Plasma::FrameSvg::NoBorder
    {63, 395, 1489},	// Plasma::FrameSvg::RightBorder
    {63, 495, 1486},	// Plasma::FrameSvg::TopBorder
    {63, 643, 1472},	// Plasma::FrameSvg::alphaMask
    {63, 705, 1474},	// Plasma::FrameSvg::cacheAllRenderedFrames
    {63, 720, 1475},	// Plasma::FrameSvg::clearCache
    {63, 786, 1465},	// Plasma::FrameSvg::contentsRect
    {63, 938, 1460},	// Plasma::FrameSvg::enabledBorders
    {63, 1014, 1476},	// Plasma::FrameSvg::framePixmap
    {63, 1016, 1462},	// Plasma::FrameSvg::frameSize
    {63, 1024, 1464},	// Plasma::FrameSvg::getMargins$$$$
    {63, 1044, -67},	// Plasma::FrameSvg::hasElementPrefix$
    {63, 1334, 1463},	// Plasma::FrameSvg::marginSize$
    {63, 1335, 1471},	// Plasma::FrameSvg::mask
    {63, 1351, 1450},	// Plasma::FrameSvg::metaObject
    {63, 1432, 1483},	// Plasma::FrameSvg::paintFrame#
    {63, 1433, -70},	// Plasma::FrameSvg::paintFrame##
    {63, 1434, 1477},	// Plasma::FrameSvg::paintFrame###
    {63, 1474, 1470},	// Plasma::FrameSvg::prefix
    {63, 1486, 1456},	// Plasma::FrameSvg::qt_metacall$$?
    {63, 1488, 1451},	// Plasma::FrameSvg::qt_metacast$
    {63, 1587, 1461},	// Plasma::FrameSvg::resizeFrame#
    {63, 1707, 1473},	// Plasma::FrameSvg::setCacheAllRenderedFrames$
    {63, 1801, -73},	// Plasma::FrameSvg::setElementPrefix$
    {63, 1809, 1459},	// Plasma::FrameSvg::setEnabledBorders$
    {63, 1870, 1458},	// Plasma::FrameSvg::setImagePath$
    {63, 2223, 1484},	// Plasma::FrameSvg::staticMetaObject
    {63, 2305, 1479},	// Plasma::FrameSvg::tr$
    {63, 2306, 1452},	// Plasma::FrameSvg::tr$$
    {63, 2307, 1454},	// Plasma::FrameSvg::tr$$$
    {63, 2309, 1480},	// Plasma::FrameSvg::trUtf8$
    {63, 2310, 1453},	// Plasma::FrameSvg::trUtf8$$
    {63, 2311, 1455},	// Plasma::FrameSvg::trUtf8$$$
    {63, 2438, 1491},	// Plasma::FrameSvg::~FrameSvg
    {64, 195, 1499},	// Plasma::GLApplet::GLApplet#$$
    {64, 196, 1500},	// Plasma::GLApplet::GLApplet#?
    {64, 702, 1507},	// Plasma::GLApplet::bindTexture#
    {64, 703, 1501},	// Plasma::GLApplet::bindTexture#?
    {64, 848, 1502},	// Plasma::GLApplet::deleteTexture?
    {64, 1326, 1504},	// Plasma::GLApplet::makeCurrent
    {64, 1351, 1492},	// Plasma::GLApplet::metaObject
    {64, 1436, 1503},	// Plasma::GLApplet::paintGLInterface##
    {64, 1486, 1498},	// Plasma::GLApplet::qt_metacall$$?
    {64, 1488, 1493},	// Plasma::GLApplet::qt_metacast$
    {64, 2223, 1508},	// Plasma::GLApplet::staticMetaObject
    {64, 2305, 1505},	// Plasma::GLApplet::tr$
    {64, 2306, 1494},	// Plasma::GLApplet::tr$$
    {64, 2307, 1496},	// Plasma::GLApplet::tr$$$
    {64, 2309, 1506},	// Plasma::GLApplet::trUtf8$
    {64, 2310, 1495},	// Plasma::GLApplet::trUtf8$$
    {64, 2311, 1497},	// Plasma::GLApplet::trUtf8$$$
    {64, 2439, 1509},	// Plasma::GLApplet::~GLApplet
    {65, 199, 1527},	// Plasma::GroupBox::GroupBox
    {65, 200, 1517},	// Plasma::GroupBox::GroupBox#
    {65, 711, 1524},	// Plasma::GroupBox::changeEvent#
    {65, 1351, 1510},	// Plasma::GroupBox::metaObject
    {65, 1388, 1522},	// Plasma::GroupBox::nativeWidget
    {65, 1486, 1516},	// Plasma::GroupBox::qt_metacall$$?
    {65, 1488, 1511},	// Plasma::GroupBox::qt_metacast$
    {65, 1585, 1523},	// Plasma::GroupBox::resizeEvent#
    {65, 2049, 1520},	// Plasma::GroupBox::setStyleSheet$
    {65, 2081, 1518},	// Plasma::GroupBox::setText$
    {65, 2223, 1528},	// Plasma::GroupBox::staticMetaObject
    {65, 2236, 1521},	// Plasma::GroupBox::styleSheet
    {65, 2274, 1519},	// Plasma::GroupBox::text
    {65, 2305, 1525},	// Plasma::GroupBox::tr$
    {65, 2306, 1512},	// Plasma::GroupBox::tr$$
    {65, 2307, 1514},	// Plasma::GroupBox::tr$$$
    {65, 2309, 1526},	// Plasma::GroupBox::trUtf8$
    {65, 2310, 1513},	// Plasma::GroupBox::trUtf8$$
    {65, 2311, 1515},	// Plasma::GroupBox::trUtf8$$$
    {65, 2440, 1529},	// Plasma::GroupBox::~GroupBox
    {66, 212, 1593},	// Plasma::IconWidget::IconWidget
    {66, 213, 1537},	// Plasma::IconWidget::IconWidget#
    {66, 214, 1595},	// Plasma::IconWidget::IconWidget#$
    {66, 215, 1539},	// Plasma::IconWidget::IconWidget#$#
    {66, 216, 1594},	// Plasma::IconWidget::IconWidget$
    {66, 217, 1538},	// Plasma::IconWidget::IconWidget$#
    {66, 557, 1561},	// Plasma::IconWidget::action
    {66, 569, 1579},	// Plasma::IconWidget::activated
    {66, 600, 1558},	// Plasma::IconWidget::addIconAction#
    {66, 711, 1589},	// Plasma::IconWidget::changeEvent#
    {66, 712, 1580},	// Plasma::IconWidget::changed
    {66, 726, 1577},	// Plasma::IconWidget::clicked
    {66, 875, 1578},	// Plasma::IconWidget::doubleClicked
    {66, 884, 1590},	// Plasma::IconWidget::drawActionButtonBase##$
    {66, 887, 1570},	// Plasma::IconWidget::drawBackground
    {66, 1069, 1586},	// Plasma::IconWidget::hoverEnterEvent#
    {66, 1071, 1587},	// Plasma::IconWidget::hoverLeaveEvent#
    {66, 1075, 1546},	// Plasma::IconWidget::icon
    {66, 1076, 1551},	// Plasma::IconWidget::iconSize
    {66, 1090, 1544},	// Plasma::IconWidget::infoText
    {66, 1118, 1564},	// Plasma::IconWidget::invertLayout$
    {66, 1119, 1565},	// Plasma::IconWidget::invertedLayout
    {66, 1130, 1581},	// Plasma::IconWidget::isDown
    {66, 1347, 1557},	// Plasma::IconWidget::maximumIconSize
    {66, 1351, 1530},	// Plasma::IconWidget::metaObject
    {66, 1362, 1555},	// Plasma::IconWidget::minimumIconSize
    {66, 1367, 1585},	// Plasma::IconWidget::mouseDoubleClickEvent#
    {66, 1369, 1583},	// Plasma::IconWidget::mouseMoveEvent#
    {66, 1371, 1582},	// Plasma::IconWidget::mousePressEvent#
    {66, 1373, 1584},	// Plasma::IconWidget::mouseReleaseEvent#
    {66, 1395, 1567},	// Plasma::IconWidget::numDisplayLines
    {66, 1412, 1563},	// Plasma::IconWidget::orientation
    {66, 1421, 1598},	// Plasma::IconWidget::paint##
    {66, 1422, 1574},	// Plasma::IconWidget::paint###
    {66, 1471, 1553},	// Plasma::IconWidget::preferredIconSize
    {66, 1477, 1576},	// Plasma::IconWidget::pressed$
    {66, 1486, 1536},	// Plasma::IconWidget::qt_metacall$$?
    {66, 1488, 1531},	// Plasma::IconWidget::qt_metacast$
    {66, 1541, 1559},	// Plasma::IconWidget::removeIconAction#
    {66, 1622, 1588},	// Plasma::IconWidget::sceneEventFilter##
    {66, 1659, 1560},	// Plasma::IconWidget::setAction#
    {66, 1790, 1569},	// Plasma::IconWidget::setDrawBackground$
    {66, 1859, 1547},	// Plasma::IconWidget::setIcon#
    {66, 1860, 1550},	// Plasma::IconWidget::setIcon$
    {66, 1876, 1545},	// Plasma::IconWidget::setInfoText$
    {66, 1905, 1556},	// Plasma::IconWidget::setMaximumIconSize#
    {66, 1913, 1554},	// Plasma::IconWidget::setMinimumIconSize#
    {66, 1930, 1568},	// Plasma::IconWidget::setNumDisplayLines$
    {66, 1936, 1562},	// Plasma::IconWidget::setOrientation$
    {66, 1965, 1552},	// Plasma::IconWidget::setPreferredIconSize#
    {66, 1968, 1597},	// Plasma::IconWidget::setPressed
    {66, 1969, 1572},	// Plasma::IconWidget::setPressed$
    {66, 2056, 1596},	// Plasma::IconWidget::setSvg$
    {66, 2057, 1542},	// Plasma::IconWidget::setSvg$$
    {66, 2081, 1541},	// Plasma::IconWidget::setText$
    {66, 2083, 1549},	// Plasma::IconWidget::setTextBackgroundColor#
    {66, 2108, 1573},	// Plasma::IconWidget::setUnpressed
    {66, 2161, 1571},	// Plasma::IconWidget::shape
    {66, 2197, 1566},	// Plasma::IconWidget::sizeFromIconSize$
    {66, 2200, 1599},	// Plasma::IconWidget::sizeHint$
    {66, 2201, 1575},	// Plasma::IconWidget::sizeHint$#
    {66, 2223, 1600},	// Plasma::IconWidget::staticMetaObject
    {66, 2246, 1543},	// Plasma::IconWidget::svg
    {66, 2274, 1540},	// Plasma::IconWidget::text
    {66, 2275, 1548},	// Plasma::IconWidget::textBackgroundColor
    {66, 2305, 1591},	// Plasma::IconWidget::tr$
    {66, 2306, 1532},	// Plasma::IconWidget::tr$$
    {66, 2307, 1534},	// Plasma::IconWidget::tr$$$
    {66, 2309, 1592},	// Plasma::IconWidget::trUtf8$
    {66, 2310, 1533},	// Plasma::IconWidget::trUtf8$$
    {66, 2311, 1535},	// Plasma::IconWidget::trUtf8$$$
    {66, 2441, 1601},	// Plasma::IconWidget::~IconWidget
    {67, 228, 1625},	// Plasma::ItemBackground::ItemBackground
    {67, 229, 1609},	// Plasma::ItemBackground::ItemBackground#
    {67, 659, 1616},	// Plasma::ItemBackground::animationStep$
    {67, 661, 1615},	// Plasma::ItemBackground::appearanceChanged
    {67, 955, 1620},	// Plasma::ItemBackground::eventFilter##
    {67, 1180, 1619},	// Plasma::ItemBackground::itemChange$#
    {67, 1351, 1602},	// Plasma::ItemBackground::metaObject
    {67, 1422, 1614},	// Plasma::ItemBackground::paint###
    {67, 1486, 1608},	// Plasma::ItemBackground::qt_metacall$$?
    {67, 1488, 1603},	// Plasma::ItemBackground::qt_metacast$
    {67, 1585, 1622},	// Plasma::ItemBackground::resizeEvent#
    {67, 1622, 1621},	// Plasma::ItemBackground::sceneEventFilter##
    {67, 2071, 1610},	// Plasma::ItemBackground::setTarget#
    {67, 2073, 1612},	// Plasma::ItemBackground::setTargetItem#
    {67, 2223, 1626},	// Plasma::ItemBackground::staticMetaObject
    {67, 2264, 1611},	// Plasma::ItemBackground::target
    {67, 2265, 1613},	// Plasma::ItemBackground::targetItem
    {67, 2267, 1618},	// Plasma::ItemBackground::targetItemReached#
    {67, 2269, 1617},	// Plasma::ItemBackground::targetReached#
    {67, 2305, 1623},	// Plasma::ItemBackground::tr$
    {67, 2306, 1604},	// Plasma::ItemBackground::tr$$
    {67, 2307, 1606},	// Plasma::ItemBackground::tr$$$
    {67, 2309, 1624},	// Plasma::ItemBackground::trUtf8$
    {67, 2310, 1605},	// Plasma::ItemBackground::trUtf8$$
    {67, 2311, 1607},	// Plasma::ItemBackground::trUtf8$$$
    {67, 2442, 1627},	// Plasma::ItemBackground::~ItemBackground
    {68, 288, 1665},	// Plasma::Label::Label
    {68, 289, 1635},	// Plasma::Label::Label#
    {68, 640, 1641},	// Plasma::Label::alignment
    {68, 711, 1658},	// Plasma::Label::changeEvent#
    {68, 795, 1661},	// Plasma::Label::contextMenuEvent#
    {68, 842, 1653},	// Plasma::Label::dataUpdated$?
    {68, 953, 1659},	// Plasma::Label::event#
    {68, 1052, 1643},	// Plasma::Label::hasScaledContents
    {68, 1079, 1639},	// Plasma::Label::image
    {68, 1180, 1660},	// Plasma::Label::itemChange$#
    {68, 1231, 1651},	// Plasma::Label::linkActivated$
    {68, 1234, 1652},	// Plasma::Label::linkHovered$
    {68, 1351, 1628},	// Plasma::Label::metaObject
    {68, 1369, 1656},	// Plasma::Label::mouseMoveEvent#
    {68, 1371, 1655},	// Plasma::Label::mousePressEvent#
    {68, 1388, 1650},	// Plasma::Label::nativeWidget
    {68, 1422, 1657},	// Plasma::Label::paint###
    {68, 1486, 1634},	// Plasma::Label::qt_metacall$$?
    {68, 1488, 1629},	// Plasma::Label::qt_metacast$
    {68, 1585, 1654},	// Plasma::Label::resizeEvent#
    {68, 1663, 1640},	// Plasma::Label::setAlignment$
    {68, 1867, 1638},	// Plasma::Label::setImage$
    {68, 2003, 1642},	// Plasma::Label::setScaledContents$
    {68, 2049, 1648},	// Plasma::Label::setStyleSheet$
    {68, 2081, 1636},	// Plasma::Label::setText$
    {68, 2085, 1644},	// Plasma::Label::setTextSelectable$
    {68, 2156, 1646},	// Plasma::Label::setWordWrap$
    {68, 2201, 1662},	// Plasma::Label::sizeHint$#
    {68, 2223, 1666},	// Plasma::Label::staticMetaObject
    {68, 2236, 1649},	// Plasma::Label::styleSheet
    {68, 2274, 1637},	// Plasma::Label::text
    {68, 2280, 1645},	// Plasma::Label::textSelectable
    {68, 2305, 1663},	// Plasma::Label::tr$
    {68, 2306, 1630},	// Plasma::Label::tr$$
    {68, 2307, 1632},	// Plasma::Label::tr$$$
    {68, 2309, 1664},	// Plasma::Label::trUtf8$
    {68, 2310, 1631},	// Plasma::Label::trUtf8$$
    {68, 2311, 1633},	// Plasma::Label::trUtf8$$$
    {68, 2400, 1647},	// Plasma::Label::wordWrap
    {68, 2443, 1667},	// Plasma::Label::~Label
    {69, 299, 1700},	// Plasma::LineEdit::LineEdit
    {69, 300, 1675},	// Plasma::LineEdit::LineEdit#
    {69, 711, 1688},	// Plasma::LineEdit::changeEvent#
    {69, 725, 1681},	// Plasma::LineEdit::clickMessage
    {69, 910, 1693},	// Plasma::LineEdit::editingFinished
    {69, 997, 1697},	// Plasma::LineEdit::focusChanged$
    {69, 999, 1691},	// Plasma::LineEdit::focusInEvent#
    {69, 1003, 1692},	// Plasma::LineEdit::focusOutEvent#
    {69, 1069, 1686},	// Plasma::LineEdit::hoverEnterEvent#
    {69, 1071, 1687},	// Plasma::LineEdit::hoverLeaveEvent#
    {69, 1125, 1679},	// Plasma::LineEdit::isClearButtonShown
    {69, 1351, 1668},	// Plasma::LineEdit::metaObject
    {69, 1371, 1690},	// Plasma::LineEdit::mousePressEvent#
    {69, 1388, 1685},	// Plasma::LineEdit::nativeWidget
    {69, 1422, 1689},	// Plasma::LineEdit::paint###
    {69, 1486, 1674},	// Plasma::LineEdit::qt_metacall$$?
    {69, 1488, 1669},	// Plasma::LineEdit::qt_metacast$
    {69, 1593, 1694},	// Plasma::LineEdit::returnPressed
    {69, 1717, 1678},	// Plasma::LineEdit::setClearButtonShown$
    {69, 1719, 1680},	// Plasma::LineEdit::setClickMessage$
    {69, 1924, 1684},	// Plasma::LineEdit::setNativeWidget#
    {69, 2049, 1682},	// Plasma::LineEdit::setStyleSheet$
    {69, 2081, 1676},	// Plasma::LineEdit::setText$
    {69, 2223, 1701},	// Plasma::LineEdit::staticMetaObject
    {69, 2236, 1683},	// Plasma::LineEdit::styleSheet
    {69, 2274, 1677},	// Plasma::LineEdit::text
    {69, 2277, 1696},	// Plasma::LineEdit::textChanged$
    {69, 2279, 1695},	// Plasma::LineEdit::textEdited$
    {69, 2305, 1698},	// Plasma::LineEdit::tr$
    {69, 2306, 1670},	// Plasma::LineEdit::tr$$
    {69, 2307, 1672},	// Plasma::LineEdit::tr$$$
    {69, 2309, 1699},	// Plasma::LineEdit::trUtf8$
    {69, 2310, 1671},	// Plasma::LineEdit::trUtf8$$
    {69, 2311, 1673},	// Plasma::LineEdit::trUtf8$$$
    {69, 2444, 1702},	// Plasma::LineEdit::~LineEdit
    {70, 29, 1742},	// Plasma::Meter::AnalogMeter
    {70, 56, 1740},	// Plasma::Meter::BarMeterHorizontal
    {70, 57, 1741},	// Plasma::Meter::BarMeterVertical
    {70, 310, 1736},	// Plasma::Meter::Meter
    {70, 311, 1710},	// Plasma::Meter::Meter#
    {70, 842, 1727},	// Plasma::Meter::dataUpdated$?
    {70, 1207, 1719},	// Plasma::Meter::label$
    {70, 1209, 1725},	// Plasma::Meter::labelAlignment$
    {70, 1211, 1721},	// Plasma::Meter::labelColor$
    {70, 1213, 1723},	// Plasma::Meter::labelFont$
    {70, 1215, 1726},	// Plasma::Meter::labelRect$
    {70, 1346, 1711},	// Plasma::Meter::maximum
    {70, 1351, 1703},	// Plasma::Meter::metaObject
    {70, 1353, 1717},	// Plasma::Meter::meterType
    {70, 1361, 1712},	// Plasma::Meter::minimum
    {70, 1421, 1737},	// Plasma::Meter::paint##
    {70, 1422, 1732},	// Plasma::Meter::paint###
    {70, 1486, 1709},	// Plasma::Meter::qt_metacall$$?
    {70, 1488, 1704},	// Plasma::Meter::qt_metacast$
    {70, 1885, 1718},	// Plasma::Meter::setLabel$$
    {70, 1887, 1724},	// Plasma::Meter::setLabelAlignment$$
    {70, 1889, 1720},	// Plasma::Meter::setLabelColor$#
    {70, 1891, 1722},	// Plasma::Meter::setLabelFont$#
    {70, 1903, 1728},	// Plasma::Meter::setMaximum$
    {70, 1907, 1716},	// Plasma::Meter::setMeterType$
    {70, 1911, 1729},	// Plasma::Meter::setMinimum$
    {70, 2056, 1714},	// Plasma::Meter::setSvg$
    {70, 2125, 1730},	// Plasma::Meter::setValue$
    {70, 2200, 1738},	// Plasma::Meter::sizeHint$
    {70, 2201, 1733},	// Plasma::Meter::sizeHint$#
    {70, 2223, 1739},	// Plasma::Meter::staticMetaObject
    {70, 2246, 1715},	// Plasma::Meter::svg
    {70, 2305, 1734},	// Plasma::Meter::tr$
    {70, 2306, 1705},	// Plasma::Meter::tr$$
    {70, 2307, 1707},	// Plasma::Meter::tr$$$
    {70, 2309, 1735},	// Plasma::Meter::trUtf8$
    {70, 2310, 1706},	// Plasma::Meter::trUtf8$$
    {70, 2311, 1708},	// Plasma::Meter::trUtf8$$$
    {70, 2360, 1713},	// Plasma::Meter::value
    {70, 2362, 1731},	// Plasma::Meter::valueChanged$
    {70, 2445, 1743},	// Plasma::Meter::~Meter
    {71, 351, 1744},	// Plasma::Package::Package
    {71, 352, 1747},	// Plasma::Package::Package#
    {71, 353, 1745},	// Plasma::Package::Package$$?
    {71, 354, 1746},	// Plasma::Package::Package$?
    {71, 783, 1757},	// Plasma::Package::contentsHash
    {71, 815, 1764},	// Plasma::Package::createPackage#$$
    {71, 816, 1763},	// Plasma::Package::createPackage#$$$
    {71, 950, 1752},	// Plasma::Package::entryList$
    {71, 973, 1751},	// Plasma::Package::filePath$
    {71, 974, 1750},	// Plasma::Package::filePath$$
    {71, 1114, 1760},	// Plasma::Package::installPackage$$$
    {71, 1164, 1749},	// Plasma::Package::isValid
    {71, 1267, 1758},	// Plasma::Package::listInstalled$
    {71, 1269, 1759},	// Plasma::Package::listInstalledPaths$
    {71, 1352, 1753},	// Plasma::Package::metadata
    {71, 1409, 1748},	// Plasma::Package::operator=#
    {71, 1446, 1755},	// Plasma::Package::path
    {71, 1506, 1762},	// Plasma::Package::registerPackage#$
    {71, 1948, 1754},	// Plasma::Package::setPath$
    {71, 2234, 1756},	// Plasma::Package::structure
    {71, 2318, 1761},	// Plasma::Package::uninstallPackage$$$
    {71, 2446, 1765},	// Plasma::Package::~Package
    {72, 355, 1806},	// Plasma::PackageMetadata::PackageMetadata
    {72, 356, 1767},	// Plasma::PackageMetadata::PackageMetadata#
    {72, 357, 1766},	// Plasma::PackageMetadata::PackageMetadata$
    {72, 675, 1781},	// Plasma::PackageMetadata::application
    {72, 685, 1776},	// Plasma::PackageMetadata::author
    {72, 707, 1782},	// Plasma::PackageMetadata::category
    {72, 849, 1773},	// Plasma::PackageMetadata::description
    {72, 932, 1777},	// Plasma::PackageMetadata::email
    {72, 1075, 1790},	// Plasma::PackageMetadata::icon
    {72, 1085, 1785},	// Plasma::PackageMetadata::implementationApi
    {72, 1164, 1769},	// Plasma::PackageMetadata::isValid
    {72, 1202, 1774},	// Plasma::PackageMetadata::keywords
    {72, 1229, 1780},	// Plasma::PackageMetadata::license
    {72, 1386, 1772},	// Plasma::PackageMetadata::name
    {72, 1409, 1768},	// Plasma::PackageMetadata::operator=#
    {72, 1458, 1784},	// Plasma::PackageMetadata::pluginName
    {72, 1495, 1771},	// Plasma::PackageMetadata::read$
    {72, 1526, 1786},	// Plasma::PackageMetadata::remoteLocation
    {72, 1578, 1783},	// Plasma::PackageMetadata::requiredVersion
    {72, 1657, 1775},	// Plasma::PackageMetadata::serviceType
    {72, 1675, 1799},	// Plasma::PackageMetadata::setApplication$
    {72, 1683, 1794},	// Plasma::PackageMetadata::setAuthor$
    {72, 1711, 1800},	// Plasma::PackageMetadata::setCategory$
    {72, 1780, 1789},	// Plasma::PackageMetadata::setDescription$
    {72, 1803, 1795},	// Plasma::PackageMetadata::setEmail$
    {72, 1860, 1791},	// Plasma::PackageMetadata::setIcon$
    {72, 1874, 1805},	// Plasma::PackageMetadata::setImplementationApi$
    {72, 1882, 1792},	// Plasma::PackageMetadata::setKeywords?
    {72, 1895, 1798},	// Plasma::PackageMetadata::setLicense$
    {72, 1922, 1788},	// Plasma::PackageMetadata::setName$
    {72, 1954, 1804},	// Plasma::PackageMetadata::setPluginName$
    {72, 1985, 1802},	// Plasma::PackageMetadata::setRemoteLocation#
    {72, 1991, 1801},	// Plasma::PackageMetadata::setRequiredVersion$
    {72, 2016, 1793},	// Plasma::PackageMetadata::setServiceType$
    {72, 2105, 1803},	// Plasma::PackageMetadata::setType$
    {72, 2127, 1796},	// Plasma::PackageMetadata::setVersion$
    {72, 2148, 1797},	// Plasma::PackageMetadata::setWebsite$
    {72, 2313, 1787},	// Plasma::PackageMetadata::type
    {72, 2363, 1778},	// Plasma::PackageMetadata::version
    {72, 2388, 1779},	// Plasma::PackageMetadata::website
    {72, 2403, 1770},	// Plasma::PackageMetadata::write$
    {72, 2447, 1807},	// Plasma::PackageMetadata::~PackageMetadata
    {73, 358, 1857},	// Plasma::PackageStructure::PackageStructure
    {73, 359, 1858},	// Plasma::PackageStructure::PackageStructure#
    {73, 360, 1815},	// Plasma::PackageStructure::PackageStructure#$
    {73, 594, 1823},	// Plasma::PackageStructure::addDirectoryDefinition$$$
    {73, 598, 1824},	// Plasma::PackageStructure::addFileDefinition$$$
    {73, 641, 1848},	// Plasma::PackageStructure::allowExternalPaths
    {73, 784, 1842},	// Plasma::PackageStructure::contentsPrefix
    {73, 785, 1843},	// Plasma::PackageStructure::contentsPrefixPaths
    {73, 812, 1859},	// Plasma::PackageStructure::createNewWidgetBrowser
    {73, 813, 1841},	// Plasma::PackageStructure::createNewWidgetBrowser#
    {73, 844, 1844},	// Plasma::PackageStructure::defaultPackageRoot
    {73, 862, 1819},	// Plasma::PackageStructure::directories
    {73, 950, 1828},	// Plasma::PackageStructure::entryList$
    {73, 975, 1821},	// Plasma::PackageStructure::files
    {73, 1113, 1839},	// Plasma::PackageStructure::installPackage$$
    {73, 1152, 1831},	// Plasma::PackageStructure::isRequired$
    {73, 1288, 1817},	// Plasma::PackageStructure::load$
    {73, 1351, 1808},	// Plasma::PackageStructure::metaObject
    {73, 1352, 1847},	// Plasma::PackageStructure::metadata
    {73, 1360, 1834},	// Plasma::PackageStructure::mimetypes$
    {73, 1387, 1829},	// Plasma::PackageStructure::name$
    {73, 1393, 1849},	// Plasma::PackageStructure::newWidgetBrowserFinished
    {73, 1409, 1816},	// Plasma::PackageStructure::operator=#
    {73, 1446, 1836},	// Plasma::PackageStructure::path
    {73, 1447, 1826},	// Plasma::PackageStructure::path$
    {73, 1448, 1854},	// Plasma::PackageStructure::pathChanged
    {73, 1486, 1814},	// Plasma::PackageStructure::qt_metacall$$?
    {73, 1488, 1809},	// Plasma::PackageStructure::qt_metacast$
    {73, 1494, 1837},	// Plasma::PackageStructure::read#
    {73, 1539, 1825},	// Plasma::PackageStructure::removeDefinition$
    {73, 1576, 1820},	// Plasma::PackageStructure::requiredDirectories
    {73, 1577, 1822},	// Plasma::PackageStructure::requiredFiles
    {73, 1641, 1827},	// Plasma::PackageStructure::searchPath$
    {73, 1651, 1845},	// Plasma::PackageStructure::servicePrefix
    {73, 1665, 1850},	// Plasma::PackageStructure::setAllowExternalPaths$
    {73, 1742, 1851},	// Plasma::PackageStructure::setContentsPrefix$
    {73, 1744, 1852},	// Plasma::PackageStructure::setContentsPrefixPaths?
    {73, 1771, 1832},	// Plasma::PackageStructure::setDefaultMimetypes?
    {73, 1773, 1853},	// Plasma::PackageStructure::setDefaultPackageRoot$
    {73, 1909, 1833},	// Plasma::PackageStructure::setMimetypes$?
    {73, 1948, 1835},	// Plasma::PackageStructure::setPath$
    {73, 1989, 1830},	// Plasma::PackageStructure::setRequired$$
    {73, 2014, 1846},	// Plasma::PackageStructure::setServicePrefix$
    {73, 2223, 1860},	// Plasma::PackageStructure::staticMetaObject
    {73, 2305, 1855},	// Plasma::PackageStructure::tr$
    {73, 2306, 1810},	// Plasma::PackageStructure::tr$$
    {73, 2307, 1812},	// Plasma::PackageStructure::tr$$$
    {73, 2309, 1856},	// Plasma::PackageStructure::trUtf8$
    {73, 2310, 1811},	// Plasma::PackageStructure::trUtf8$$
    {73, 2311, 1813},	// Plasma::PackageStructure::trUtf8$$$
    {73, 2313, 1818},	// Plasma::PackageStructure::type
    {73, 2317, 1840},	// Plasma::PackageStructure::uninstallPackage$$
    {73, 2402, 1838},	// Plasma::PackageStructure::write#
    {73, 2448, 1861},	// Plasma::PackageStructure::~PackageStructure
    {74, 376, 1862},	// Plasma::PlotColor::PlotColor
    {74, 377, 1863},	// Plasma::PlotColor::PlotColor#
    {74, 735, 1864},	// Plasma::PlotColor::color
    {74, 837, 1866},	// Plasma::PlotColor::darkColor
    {74, 1725, 1865},	// Plasma::PlotColor::setColor#
    {74, 1760, 1867},	// Plasma::PlotColor::setDarkColor#
    {74, 2449, 1868},	// Plasma::PlotColor::~PlotColor
    {75, 379, 1876},	// Plasma::PopupApplet::PopupApplet#?
    {75, 877, 1899},	// Plasma::PopupApplet::dragEnterEvent#
    {75, 879, 1900},	// Plasma::PopupApplet::dragLeaveEvent#
    {75, 907, 1901},	// Plasma::PopupApplet::dropEvent#
    {75, 955, 1898},	// Plasma::PopupApplet::eventFilter##
    {75, 1033, 1882},	// Plasma::PopupApplet::graphicsWidget
    {75, 1061, 1891},	// Plasma::PopupApplet::hidePopup
    {75, 1135, 1890},	// Plasma::PopupApplet::isIconified
    {75, 1142, 1888},	// Plasma::PopupApplet::isPassivePopup
    {75, 1145, 1889},	// Plasma::PopupApplet::isPopupShowing
    {75, 1351, 1869},	// Plasma::PopupApplet::metaObject
    {75, 1371, 1896},	// Plasma::PopupApplet::mousePressEvent#
    {75, 1373, 1897},	// Plasma::PopupApplet::mouseReleaseEvent#
    {75, 1461, 1886},	// Plasma::PopupApplet::popupAlignment
    {75, 1463, 1894},	// Plasma::PopupApplet::popupEvent$
    {75, 1464, 1879},	// Plasma::PopupApplet::popupIcon
    {75, 1465, 1884},	// Plasma::PopupApplet::popupPlacement
    {75, 1486, 1875},	// Plasma::PopupApplet::qt_metacall$$?
    {75, 1488, 1870},	// Plasma::PopupApplet::qt_metacast$
    {75, 1833, 1883},	// Plasma::PopupApplet::setGraphicsWidget#
    {75, 1946, 1887},	// Plasma::PopupApplet::setPassivePopup$
    {75, 1960, 1885},	// Plasma::PopupApplet::setPopupAlignment$
    {75, 1962, 1877},	// Plasma::PopupApplet::setPopupIcon#
    {75, 1963, 1878},	// Plasma::PopupApplet::setPopupIcon$
    {75, 2150, 1881},	// Plasma::PopupApplet::setWidget#
    {75, 2183, 1905},	// Plasma::PopupApplet::showPopup
    {75, 2184, 1892},	// Plasma::PopupApplet::showPopup$
    {75, 2200, 1906},	// Plasma::PopupApplet::sizeHint$
    {75, 2201, 1895},	// Plasma::PopupApplet::sizeHint$#
    {75, 2223, 1907},	// Plasma::PopupApplet::staticMetaObject
    {75, 2290, 1902},	// Plasma::PopupApplet::timerEvent#
    {75, 2292, 1893},	// Plasma::PopupApplet::togglePopup
    {75, 2305, 1903},	// Plasma::PopupApplet::tr$
    {75, 2306, 1871},	// Plasma::PopupApplet::tr$$
    {75, 2307, 1873},	// Plasma::PopupApplet::tr$$$
    {75, 2309, 1904},	// Plasma::PopupApplet::trUtf8$
    {75, 2310, 1872},	// Plasma::PopupApplet::trUtf8$$
    {75, 2311, 1874},	// Plasma::PopupApplet::trUtf8$$$
    {75, 2391, 1880},	// Plasma::PopupApplet::widget
    {75, 2450, 1908},	// Plasma::PopupApplet::~PopupApplet
    {76, 385, 1948},	// Plasma::PushButton::PushButton
    {76, 386, 1916},	// Plasma::PushButton::PushButton#
    {76, 557, 1925},	// Plasma::PushButton::action
    {76, 711, 1944},	// Plasma::PushButton::changeEvent#
    {76, 724, 1938},	// Plasma::PushButton::click
    {76, 726, 1936},	// Plasma::PushButton::clicked
    {76, 1069, 1942},	// Plasma::PushButton::hoverEnterEvent#
    {76, 1071, 1943},	// Plasma::PushButton::hoverLeaveEvent#
    {76, 1075, 1928},	// Plasma::PushButton::icon
    {76, 1079, 1921},	// Plasma::PushButton::image
    {76, 1123, 1930},	// Plasma::PushButton::isCheckable
    {76, 1124, 1931},	// Plasma::PushButton::isChecked
    {76, 1130, 1932},	// Plasma::PushButton::isDown
    {76, 1351, 1909},	// Plasma::PushButton::metaObject
    {76, 1388, 1933},	// Plasma::PushButton::nativeWidget
    {76, 1421, 1949},	// Plasma::PushButton::paint##
    {76, 1422, 1940},	// Plasma::PushButton::paint###
    {76, 1476, 1934},	// Plasma::PushButton::pressed
    {76, 1486, 1915},	// Plasma::PushButton::qt_metacall$$?
    {76, 1488, 1910},	// Plasma::PushButton::qt_metacast$
    {76, 1516, 1935},	// Plasma::PushButton::released
    {76, 1585, 1941},	// Plasma::PushButton::resizeEvent#
    {76, 1659, 1924},	// Plasma::PushButton::setAction#
    {76, 1713, 1929},	// Plasma::PushButton::setCheckable$
    {76, 1715, 1939},	// Plasma::PushButton::setChecked$
    {76, 1859, -12},	// Plasma::PushButton::setIcon#
    {76, 1867, 1919},	// Plasma::PushButton::setImage$
    {76, 1868, 1920},	// Plasma::PushButton::setImage$$
    {76, 2049, 1922},	// Plasma::PushButton::setStyleSheet$
    {76, 2081, 1917},	// Plasma::PushButton::setText$
    {76, 2201, 1945},	// Plasma::PushButton::sizeHint$#
    {76, 2223, 1950},	// Plasma::PushButton::staticMetaObject
    {76, 2236, 1923},	// Plasma::PushButton::styleSheet
    {76, 2274, 1918},	// Plasma::PushButton::text
    {76, 2294, 1937},	// Plasma::PushButton::toggled$
    {76, 2305, 1946},	// Plasma::PushButton::tr$
    {76, 2306, 1911},	// Plasma::PushButton::tr$$
    {76, 2307, 1913},	// Plasma::PushButton::tr$$$
    {76, 2309, 1947},	// Plasma::PushButton::trUtf8$
    {76, 2310, 1912},	// Plasma::PushButton::trUtf8$$
    {76, 2311, 1914},	// Plasma::PushButton::trUtf8$$$
    {76, 2451, 1951},	// Plasma::PushButton::~PushButton
    {77, 91, 1982},	// Plasma::QueryMatch::CompletionMatch
    {77, 164, 1986},	// Plasma::QueryMatch::ExactMatch
    {77, 205, 1985},	// Plasma::QueryMatch::HelperMatch
    {77, 223, 1984},	// Plasma::QueryMatch::InformationalMatch
    {77, 341, 1981},	// Plasma::QueryMatch::NoMatch
    {77, 381, 1983},	// Plasma::QueryMatch::PossibleMatch
    {77, 388, -43},	// Plasma::QueryMatch::QueryMatch#
    {77, 806, 1980},	// Plasma::QueryMatch::createConfigurationInterface#
    {77, 838, 1966},	// Plasma::QueryMatch::data
    {77, 1040, 1979},	// Plasma::QueryMatch::hasConfigurationInterface
    {77, 1075, 1974},	// Plasma::QueryMatch::icon
    {77, 1077, 1968},	// Plasma::QueryMatch::id
    {77, 1132, 1976},	// Plasma::QueryMatch::isEnabled
    {77, 1164, 1959},	// Plasma::QueryMatch::isValid
    {77, 1405, 1956},	// Plasma::QueryMatch::operator!=#
    {77, 1407, 1957},	// Plasma::QueryMatch::operator<#
    {77, 1409, 1954},	// Plasma::QueryMatch::operator=#
    {77, 1411, 1955},	// Plasma::QueryMatch::operator==#
    {77, 1517, 1963},	// Plasma::QueryMatch::relevance
    {77, 1598, 1964},	// Plasma::QueryMatch::run#
    {77, 1602, 1958},	// Plasma::QueryMatch::runner
    {77, 1645, 1977},	// Plasma::QueryMatch::selectedAction
    {77, 1762, 1965},	// Plasma::QueryMatch::setData#
    {77, 1807, 1975},	// Plasma::QueryMatch::setEnabled$
    {77, 1859, 1973},	// Plasma::QueryMatch::setIcon#
    {77, 1862, 1967},	// Plasma::QueryMatch::setId$
    {77, 1983, 1962},	// Plasma::QueryMatch::setRelevance$
    {77, 2012, 1978},	// Plasma::QueryMatch::setSelectedAction#
    {77, 2053, 1971},	// Plasma::QueryMatch::setSubtext$
    {77, 2081, 1969},	// Plasma::QueryMatch::setText$
    {77, 2105, 1960},	// Plasma::QueryMatch::setType$
    {77, 2239, 1972},	// Plasma::QueryMatch::subtext
    {77, 2274, 1970},	// Plasma::QueryMatch::text
    {77, 2313, 1961},	// Plasma::QueryMatch::type
    {77, 2452, 1987},	// Plasma::QueryMatch::~QueryMatch
    {78, 390, 2010},	// Plasma::RadioButton::RadioButton
    {78, 391, 1995},	// Plasma::RadioButton::RadioButton#
    {78, 711, 2007},	// Plasma::RadioButton::changeEvent#
    {78, 1079, 1999},	// Plasma::RadioButton::image
    {78, 1124, 2004},	// Plasma::RadioButton::isChecked
    {78, 1351, 1988},	// Plasma::RadioButton::metaObject
    {78, 1388, 2002},	// Plasma::RadioButton::nativeWidget
    {78, 1486, 1994},	// Plasma::RadioButton::qt_metacall$$?
    {78, 1488, 1989},	// Plasma::RadioButton::qt_metacast$
    {78, 1585, 2006},	// Plasma::RadioButton::resizeEvent#
    {78, 1715, 2003},	// Plasma::RadioButton::setChecked$
    {78, 1867, 1998},	// Plasma::RadioButton::setImage$
    {78, 2049, 2000},	// Plasma::RadioButton::setStyleSheet$
    {78, 2081, 1996},	// Plasma::RadioButton::setText$
    {78, 2223, 2011},	// Plasma::RadioButton::staticMetaObject
    {78, 2236, 2001},	// Plasma::RadioButton::styleSheet
    {78, 2274, 1997},	// Plasma::RadioButton::text
    {78, 2294, 2005},	// Plasma::RadioButton::toggled$
    {78, 2305, 2008},	// Plasma::RadioButton::tr$
    {78, 2306, 1990},	// Plasma::RadioButton::tr$$
    {78, 2307, 1992},	// Plasma::RadioButton::tr$$$
    {78, 2309, 2009},	// Plasma::RadioButton::trUtf8$
    {78, 2310, 1991},	// Plasma::RadioButton::trUtf8$$
    {78, 2311, 1993},	// Plasma::RadioButton::trUtf8$$$
    {78, 2453, 2012},	// Plasma::RadioButton::~RadioButton
    {79, 150, 2049},	// Plasma::RunnerContext::Directory
    {79, 165, 2052},	// Plasma::RunnerContext::Executable
    {79, 177, 2050},	// Plasma::RunnerContext::File
    {79, 178, 2055},	// Plasma::RunnerContext::FileSystem
    {79, 204, 2054},	// Plasma::RunnerContext::Help
    {79, 321, 2051},	// Plasma::RunnerContext::NetworkLocation
    {79, 344, 2047},	// Plasma::RunnerContext::None
    {79, 405, 2044},	// Plasma::RunnerContext::RunnerContext
    {79, 406, -58},	// Plasma::RunnerContext::RunnerContext#
    {79, 407, 2021},	// Plasma::RunnerContext::RunnerContext##
    {79, 440, 2053},	// Plasma::RunnerContext::ShellCommand
    {79, 512, 2048},	// Plasma::RunnerContext::UnknownType
    {79, 604, 2030},	// Plasma::RunnerContext::addMatch$#
    {79, 606, 2029},	// Plasma::RunnerContext::addMatches$?
    {79, 1164, 2028},	// Plasma::RunnerContext::isValid
    {79, 1338, 2035},	// Plasma::RunnerContext::match$
    {79, 1340, 2034},	// Plasma::RunnerContext::matches
    {79, 1341, 2041},	// Plasma::RunnerContext::matchesChanged
    {79, 1351, 2013},	// Plasma::RunnerContext::metaObject
    {79, 1358, 2027},	// Plasma::RunnerContext::mimeType
    {79, 1409, 2022},	// Plasma::RunnerContext::operator=#
    {79, 1486, 2019},	// Plasma::RunnerContext::qt_metacall$$?
    {79, 1488, 2014},	// Plasma::RunnerContext::qt_metacast$
    {79, 1489, 2025},	// Plasma::RunnerContext::query
    {79, 1543, 2031},	// Plasma::RunnerContext::removeMatch$
    {79, 1545, 2033},	// Plasma::RunnerContext::removeMatches#
    {79, 1546, 2032},	// Plasma::RunnerContext::removeMatches?
    {79, 1579, 2023},	// Plasma::RunnerContext::reset
    {79, 1590, 2038},	// Plasma::RunnerContext::restore#
    {79, 1598, 2040},	// Plasma::RunnerContext::run#
    {79, 1608, 2039},	// Plasma::RunnerContext::save#
    {79, 1977, 2024},	// Plasma::RunnerContext::setQuery$
    {79, 2032, 2036},	// Plasma::RunnerContext::setSingleRunnerQueryMode$
    {79, 2192, 2037},	// Plasma::RunnerContext::singleRunnerQueryMode
    {79, 2223, 2046},	// Plasma::RunnerContext::staticMetaObject
    {79, 2305, 2042},	// Plasma::RunnerContext::tr$
    {79, 2306, 2015},	// Plasma::RunnerContext::tr$$
    {79, 2307, 2017},	// Plasma::RunnerContext::tr$$$
    {79, 2309, 2043},	// Plasma::RunnerContext::trUtf8$
    {79, 2310, 2016},	// Plasma::RunnerContext::trUtf8$$
    {79, 2311, 2018},	// Plasma::RunnerContext::trUtf8$$$
    {79, 2313, 2026},	// Plasma::RunnerContext::type
    {79, 2454, 2056},	// Plasma::RunnerContext::~RunnerContext
    {80, 408, 2100},	// Plasma::RunnerManager::RunnerManager
    {80, 409, -55},	// Plasma::RunnerManager::RunnerManager#
    {80, 410, 2065},	// Plasma::RunnerManager::RunnerManager##
    {80, 562, 2079},	// Plasma::RunnerManager::actionsForMatch#
    {80, 642, 2085},	// Plasma::RunnerManager::allowedRunners
    {80, 961, 2094},	// Plasma::RunnerManager::execQuery$
    {80, 962, 2093},	// Plasma::RunnerManager::execQuery$$
    {80, 1225, 2092},	// Plasma::RunnerManager::launchQuery$
    {80, 1226, 2091},	// Plasma::RunnerManager::launchQuery$$
    {80, 1271, 2102},	// Plasma::RunnerManager::listRunnerInfo
    {80, 1272, 2088},	// Plasma::RunnerManager::listRunnerInfo$
    {80, 1310, 2084},	// Plasma::RunnerManager::loadRunner$
    {80, 1311, 2083},	// Plasma::RunnerManager::loadRunner?
    {80, 1339, 2090},	// Plasma::RunnerManager::matchSessionComplete
    {80, 1340, 2076},	// Plasma::RunnerManager::matches
    {80, 1342, 2096},	// Plasma::RunnerManager::matchesChanged?
    {80, 1351, 2057},	// Plasma::RunnerManager::metaObject
    {80, 1356, 2086},	// Plasma::RunnerManager::mimeDataForMatch#
    {80, 1357, 2087},	// Plasma::RunnerManager::mimeDataForMatch$
    {80, 1486, 2063},	// Plasma::RunnerManager::qt_metacall$$?
    {80, 1488, 2058},	// Plasma::RunnerManager::qt_metacast$
    {80, 1489, 2080},	// Plasma::RunnerManager::query
    {80, 1491, 2097},	// Plasma::RunnerManager::queryFinished
    {80, 1519, 2081},	// Plasma::RunnerManager::reloadConfiguration
    {80, 1579, 2095},	// Plasma::RunnerManager::reset
    {80, 1598, 2077},	// Plasma::RunnerManager::run#
    {80, 1600, 2078},	// Plasma::RunnerManager::run$
    {80, 1603, 2066},	// Plasma::RunnerManager::runner$
    {80, 1605, 2072},	// Plasma::RunnerManager::runnerName$
    {80, 1606, 2073},	// Plasma::RunnerManager::runners
    {80, 1639, 2075},	// Plasma::RunnerManager::searchContext
    {80, 1667, 2082},	// Plasma::RunnerManager::setAllowedRunners?
    {80, 2028, 2071},	// Plasma::RunnerManager::setSingleMode$
    {80, 2030, 2068},	// Plasma::RunnerManager::setSingleModeRunnerId$
    {80, 2160, 2089},	// Plasma::RunnerManager::setupMatchSession
    {80, 2188, 2070},	// Plasma::RunnerManager::singleMode
    {80, 2189, 2074},	// Plasma::RunnerManager::singleModeAdvertisedRunnerIds
    {80, 2190, 2067},	// Plasma::RunnerManager::singleModeRunner
    {80, 2191, 2069},	// Plasma::RunnerManager::singleModeRunnerId
    {80, 2223, 2103},	// Plasma::RunnerManager::staticMetaObject
    {80, 2305, 2098},	// Plasma::RunnerManager::tr$
    {80, 2306, 2059},	// Plasma::RunnerManager::tr$$
    {80, 2307, 2061},	// Plasma::RunnerManager::tr$$$
    {80, 2309, 2099},	// Plasma::RunnerManager::trUtf8$
    {80, 2310, 2060},	// Plasma::RunnerManager::trUtf8$$
    {80, 2311, 2062},	// Plasma::RunnerManager::trUtf8$$$
    {80, 2455, 2104},	// Plasma::RunnerManager::~RunnerManager
    {81, 411, 2142},	// Plasma::RunnerScript::RunnerScript
    {81, 412, 2112},	// Plasma::RunnerScript::RunnerScript#
    {81, 558, 2135},	// Plasma::RunnerScript::action$
    {81, 560, 2136},	// Plasma::RunnerScript::actions
    {81, 563, 2121},	// Plasma::RunnerScript::actionsForMatch#?
    {81, 576, 2133},	// Plasma::RunnerScript::addAction$#
    {81, 577, 2132},	// Plasma::RunnerScript::addAction$#$
    {81, 627, 2138},	// Plasma::RunnerScript::addSyntax#
    {81, 718, 2137},	// Plasma::RunnerScript::clearActions
    {81, 738, 2126},	// Plasma::RunnerScript::config
    {81, 818, 2119},	// Plasma::RunnerScript::createRunOptions#
    {81, 840, 2125},	// Plasma::RunnerScript::dataEngine$
    {81, 849, 2124},	// Plasma::RunnerScript::description
    {81, 1324, 2122},	// Plasma::RunnerScript::mainScript
    {81, 1337, 2115},	// Plasma::RunnerScript::match#
    {81, 1351, 2105},	// Plasma::RunnerScript::metaObject
    {81, 1414, 2123},	// Plasma::RunnerScript::package
    {81, 1475, 2117},	// Plasma::RunnerScript::prepare
    {81, 1486, 2111},	// Plasma::RunnerScript::qt_metacall$$?
    {81, 1488, 2106},	// Plasma::RunnerScript::qt_metacast$
    {81, 1519, 2120},	// Plasma::RunnerScript::reloadConfiguration
    {81, 1530, 2134},	// Plasma::RunnerScript::removeAction$
    {81, 1599, 2116},	// Plasma::RunnerScript::run##
    {81, 1602, 2114},	// Plasma::RunnerScript::runner
    {81, 1653, 2143},	// Plasma::RunnerScript::serviceQuery$
    {81, 1654, 2131},	// Plasma::RunnerScript::serviceQuery$$
    {81, 1842, 2128},	// Plasma::RunnerScript::setHasRunOptions$
    {81, 1864, 2127},	// Plasma::RunnerScript::setIgnoredTypes$
    {81, 1975, 2130},	// Plasma::RunnerScript::setPriority$
    {81, 1999, 2113},	// Plasma::RunnerScript::setRunner#
    {81, 2038, 2129},	// Plasma::RunnerScript::setSpeed$
    {81, 2061, 2139},	// Plasma::RunnerScript::setSyntaxes?
    {81, 2223, 2144},	// Plasma::RunnerScript::staticMetaObject
    {81, 2273, 2118},	// Plasma::RunnerScript::teardown
    {81, 2305, 2140},	// Plasma::RunnerScript::tr$
    {81, 2306, 2107},	// Plasma::RunnerScript::tr$$
    {81, 2307, 2109},	// Plasma::RunnerScript::tr$$$
    {81, 2309, 2141},	// Plasma::RunnerScript::trUtf8$
    {81, 2310, 2108},	// Plasma::RunnerScript::trUtf8$$
    {81, 2311, 2110},	// Plasma::RunnerScript::trUtf8$$$
    {81, 2456, 2145},	// Plasma::RunnerScript::~RunnerScript
    {82, 414, 2147},	// Plasma::RunnerSyntax::RunnerSyntax#
    {82, 415, 2146},	// Plasma::RunnerSyntax::RunnerSyntax$$
    {82, 596, 2149},	// Plasma::RunnerSyntax::addExampleQuery$
    {82, 849, 2153},	// Plasma::RunnerSyntax::description
    {82, 958, 2150},	// Plasma::RunnerSyntax::exampleQueries
    {82, 959, 2151},	// Plasma::RunnerSyntax::exampleQueriesWithTermDescription
    {82, 1409, 2148},	// Plasma::RunnerSyntax::operator=#
    {82, 1642, 2155},	// Plasma::RunnerSyntax::searchTermDescription
    {82, 1780, 2152},	// Plasma::RunnerSyntax::setDescription$
    {82, 2010, 2154},	// Plasma::RunnerSyntax::setSearchTermDescription$
    {82, 2457, 2156},	// Plasma::RunnerSyntax::~RunnerSyntax
    {83, 421, 2170},	// Plasma::ScriptEngine::ScriptEngine
    {83, 422, 2165},	// Plasma::ScriptEngine::ScriptEngine#
    {83, 1091, 2164},	// Plasma::ScriptEngine::init
    {83, 1324, 2166},	// Plasma::ScriptEngine::mainScript
    {83, 1351, 2157},	// Plasma::ScriptEngine::metaObject
    {83, 1414, 2167},	// Plasma::ScriptEngine::package
    {83, 1486, 2163},	// Plasma::ScriptEngine::qt_metacall$$?
    {83, 1488, 2158},	// Plasma::ScriptEngine::qt_metacast$
    {83, 2223, 2171},	// Plasma::ScriptEngine::staticMetaObject
    {83, 2305, 2168},	// Plasma::ScriptEngine::tr$
    {83, 2306, 2159},	// Plasma::ScriptEngine::tr$$
    {83, 2307, 2161},	// Plasma::ScriptEngine::tr$$$
    {83, 2309, 2169},	// Plasma::ScriptEngine::trUtf8$
    {83, 2310, 2160},	// Plasma::ScriptEngine::trUtf8$$
    {83, 2311, 2162},	// Plasma::ScriptEngine::trUtf8$$$
    {83, 2458, 2172},	// Plasma::ScriptEngine::~ScriptEngine
    {84, 423, 2202},	// Plasma::ScrollBar::ScrollBar
    {84, 424, 2180},	// Plasma::ScrollBar::ScrollBar#
    {84, 795, 2195},	// Plasma::ScrollBar::contextMenuEvent#
    {84, 1346, 2188},	// Plasma::ScrollBar::maximum
    {84, 1351, 2173},	// Plasma::ScrollBar::metaObject
    {84, 1361, 2187},	// Plasma::ScrollBar::minimum
    {84, 1388, 2193},	// Plasma::ScrollBar::nativeWidget
    {84, 1412, 2194},	// Plasma::ScrollBar::orientation
    {84, 1419, 2185},	// Plasma::ScrollBar::pageStep
    {84, 1486, 2179},	// Plasma::ScrollBar::qt_metacall$$?
    {84, 1488, 2174},	// Plasma::ScrollBar::qt_metacast$
    {84, 1903, 2190},	// Plasma::ScrollBar::setMaximum$
    {84, 1911, 2189},	// Plasma::ScrollBar::setMinimum$
    {84, 1936, 2197},	// Plasma::ScrollBar::setOrientation$
    {84, 1944, 2184},	// Plasma::ScrollBar::setPageStep$
    {84, 1979, 2181},	// Plasma::ScrollBar::setRange$$
    {84, 2034, 2182},	// Plasma::ScrollBar::setSingleStep$
    {84, 2049, 2191},	// Plasma::ScrollBar::setStyleSheet$
    {84, 2125, 2196},	// Plasma::ScrollBar::setValue$
    {84, 2193, 2183},	// Plasma::ScrollBar::singleStep
    {84, 2205, 2199},	// Plasma::ScrollBar::sliderMoved$
    {84, 2223, 2203},	// Plasma::ScrollBar::staticMetaObject
    {84, 2236, 2192},	// Plasma::ScrollBar::styleSheet
    {84, 2305, 2200},	// Plasma::ScrollBar::tr$
    {84, 2306, 2175},	// Plasma::ScrollBar::tr$$
    {84, 2307, 2177},	// Plasma::ScrollBar::tr$$$
    {84, 2309, 2201},	// Plasma::ScrollBar::trUtf8$
    {84, 2310, 2176},	// Plasma::ScrollBar::trUtf8$$
    {84, 2311, 2178},	// Plasma::ScrollBar::trUtf8$$$
    {84, 2360, 2186},	// Plasma::ScrollBar::value
    {84, 2362, 2198},	// Plasma::ScrollBar::valueChanged$
    {84, 2459, 2204},	// Plasma::ScrollBar::~ScrollBar
    {85, 426, 2253},	// Plasma::ScrollWidget::ScrollWidget
    {85, 427, -40},	// Plasma::ScrollWidget::ScrollWidget#
    {85, 640, 2217},	// Plasma::ScrollWidget::alignment
    {85, 787, 2231},	// Plasma::ScrollWidget::contentsSize
    {85, 945, 2227},	// Plasma::ScrollWidget::ensureItemVisible#
    {85, 947, 2226},	// Plasma::ScrollWidget::ensureRectVisible#
    {85, 955, 2247},	// Plasma::ScrollWidget::eventFilter##
    {85, 999, 2248},	// Plasma::ScrollWidget::focusInEvent#
    {85, 1050, 2219},	// Plasma::ScrollWidget::hasOverShoot
    {85, 1067, 2221},	// Plasma::ScrollWidget::horizontalScrollBarPolicy
    {85, 1199, 2245},	// Plasma::ScrollWidget::keyPressEvent#
    {85, 1351, 2205},	// Plasma::ScrollWidget::metaObject
    {85, 1369, 2242},	// Plasma::ScrollWidget::mouseMoveEvent#
    {85, 1371, 2243},	// Plasma::ScrollWidget::mousePressEvent#
    {85, 1373, 2244},	// Plasma::ScrollWidget::mouseReleaseEvent#
    {85, 1388, 2238},	// Plasma::ScrollWidget::nativeWidget
    {85, 1413, 2224},	// Plasma::ScrollWidget::overflowBordersVisible
    {85, 1486, 2211},	// Plasma::ScrollWidget::qt_metacall$$?
    {85, 1488, 2206},	// Plasma::ScrollWidget::qt_metacast$
    {85, 1503, 2228},	// Plasma::ScrollWidget::registerAsDragHandle#
    {85, 1585, 2241},	// Plasma::ScrollWidget::resizeEvent#
    {85, 1622, 2250},	// Plasma::ScrollWidget::sceneEventFilter##
    {85, 1635, 2233},	// Plasma::ScrollWidget::scrollPosition
    {85, 1638, 2239},	// Plasma::ScrollWidget::scrollStateChanged$$
    {85, 1663, 2216},	// Plasma::ScrollWidget::setAlignment$
    {85, 1852, 2220},	// Plasma::ScrollWidget::setHorizontalScrollBarPolicy$
    {85, 1938, 2218},	// Plasma::ScrollWidget::setOverShoot$
    {85, 1940, 2225},	// Plasma::ScrollWidget::setOverflowBordersVisible$
    {85, 2008, 2232},	// Plasma::ScrollWidget::setScrollPosition#
    {85, 2036, 2234},	// Plasma::ScrollWidget::setSnapSize#
    {85, 2049, 2236},	// Plasma::ScrollWidget::setStyleSheet$
    {85, 2137, 2222},	// Plasma::ScrollWidget::setVerticalScrollBarPolicy$
    {85, 2150, 2214},	// Plasma::ScrollWidget::setWidget#
    {85, 2201, 2249},	// Plasma::ScrollWidget::sizeHint$#
    {85, 2206, 2235},	// Plasma::ScrollWidget::snapSize
    {85, 2223, 2254},	// Plasma::ScrollWidget::staticMetaObject
    {85, 2236, 2237},	// Plasma::ScrollWidget::styleSheet
    {85, 2305, 2251},	// Plasma::ScrollWidget::tr$
    {85, 2306, 2207},	// Plasma::ScrollWidget::tr$$
    {85, 2307, 2209},	// Plasma::ScrollWidget::tr$$$
    {85, 2309, 2252},	// Plasma::ScrollWidget::trUtf8$
    {85, 2310, 2208},	// Plasma::ScrollWidget::trUtf8$$
    {85, 2311, 2210},	// Plasma::ScrollWidget::trUtf8$$$
    {85, 2324, 2229},	// Plasma::ScrollWidget::unregisterAsDragHandle#
    {85, 2373, 2223},	// Plasma::ScrollWidget::verticalScrollBarPolicy
    {85, 2378, 2230},	// Plasma::ScrollWidget::viewportGeometry
    {85, 2380, 2240},	// Plasma::ScrollWidget::viewportGeometryChanged#
    {85, 2390, 2246},	// Plasma::ScrollWidget::wheelEvent#
    {85, 2391, 2215},	// Plasma::ScrollWidget::widget
    {85, 2460, 2255},	// Plasma::ScrollWidget::~ScrollWidget
    {86, 429, 2270},	// Plasma::Separator::Separator
    {86, 430, 2271},	// Plasma::Separator::Separator#
    {86, 431, 2263},	// Plasma::Separator::Separator#$
    {86, 1351, 2256},	// Plasma::Separator::metaObject
    {86, 1412, 2265},	// Plasma::Separator::orientation
    {86, 1422, 2266},	// Plasma::Separator::paint###
    {86, 1486, 2262},	// Plasma::Separator::qt_metacall$$?
    {86, 1488, 2257},	// Plasma::Separator::qt_metacast$
    {86, 1936, 2264},	// Plasma::Separator::setOrientation$
    {86, 2201, 2267},	// Plasma::Separator::sizeHint$#
    {86, 2223, 2272},	// Plasma::Separator::staticMetaObject
    {86, 2305, 2268},	// Plasma::Separator::tr$
    {86, 2306, 2258},	// Plasma::Separator::tr$$
    {86, 2307, 2260},	// Plasma::Separator::tr$$$
    {86, 2309, 2269},	// Plasma::Separator::trUtf8$
    {86, 2310, 2259},	// Plasma::Separator::trUtf8$$
    {86, 2311, 2261},	// Plasma::Separator::trUtf8$$$
    {86, 2461, 2273},	// Plasma::Separator::~Separator
    {87, 432, 2314},	// Plasma::Service::Service
    {87, 433, 2301},	// Plasma::Service::Service#
    {87, 434, 2302},	// Plasma::Service::Service#?
    {87, 553, 2312},	// Plasma::Service::access#
    {87, 554, 2283},	// Plasma::Service::access##
    {87, 678, 2295},	// Plasma::Service::associateItem#$
    {87, 680, -49},	// Plasma::Service::associateWidget#$
    {87, 811, 2303},	// Plasma::Service::createJob$?
    {87, 851, 2285},	// Plasma::Service::destination
    {87, 864, 2296},	// Plasma::Service::disassociateItem#
    {87, 866, -52},	// Plasma::Service::disassociateWidget#
    {87, 986, 2298},	// Plasma::Service::finished#
    {87, 1141, 2289},	// Plasma::Service::isOperationEnabled$
    {87, 1288, 2311},	// Plasma::Service::load$
    {87, 1289, 2282},	// Plasma::Service::load$#
    {87, 1292, 2310},	// Plasma::Service::load$?
    {87, 1293, 2281},	// Plasma::Service::load$?#
    {87, 1351, 2274},	// Plasma::Service::metaObject
    {87, 1386, 2290},	// Plasma::Service::name
    {87, 1401, 2287},	// Plasma::Service::operationDescription$
    {87, 1402, 2286},	// Plasma::Service::operationNames
    {87, 1403, 2299},	// Plasma::Service::operationsChanged
    {87, 1443, 2297},	// Plasma::Service::parametersFromDescription#
    {87, 1486, 2280},	// Plasma::Service::qt_metacall$$?
    {87, 1488, 2275},	// Plasma::Service::qt_metacast$
    {87, 1504, 2304},	// Plasma::Service::registerOperationsScheme
    {87, 1656, 2300},	// Plasma::Service::serviceReady#
    {87, 1782, 2284},	// Plasma::Service::setDestination$
    {87, 1922, 2306},	// Plasma::Service::setName$
    {87, 1932, 2307},	// Plasma::Service::setOperationEnabled$$
    {87, 1934, 2305},	// Plasma::Service::setOperationsScheme#
    {87, 2219, 2313},	// Plasma::Service::startOperationCall#
    {87, 2220, 2288},	// Plasma::Service::startOperationCall##
    {87, 2223, 2315},	// Plasma::Service::staticMetaObject
    {87, 2305, 2308},	// Plasma::Service::tr$
    {87, 2306, 2276},	// Plasma::Service::tr$$
    {87, 2307, 2278},	// Plasma::Service::tr$$$
    {87, 2309, 2309},	// Plasma::Service::trUtf8$
    {87, 2310, 2277},	// Plasma::Service::trUtf8$$
    {87, 2311, 2279},	// Plasma::Service::trUtf8$$$
    {87, 2462, 2316},	// Plasma::Service::~Service
    {88, 436, 2329},	// Plasma::ServiceAccessJob::ServiceAccessJob#
    {88, 437, 2325},	// Plasma::ServiceAccessJob::ServiceAccessJob##
    {88, 1351, 2317},	// Plasma::ServiceAccessJob::metaObject
    {88, 1486, 2323},	// Plasma::ServiceAccessJob::qt_metacall$$?
    {88, 1488, 2318},	// Plasma::ServiceAccessJob::qt_metacast$
    {88, 1647, 2324},	// Plasma::ServiceAccessJob::service
    {88, 2217, 2326},	// Plasma::ServiceAccessJob::start
    {88, 2223, 2330},	// Plasma::ServiceAccessJob::staticMetaObject
    {88, 2305, 2327},	// Plasma::ServiceAccessJob::tr$
    {88, 2306, 2319},	// Plasma::ServiceAccessJob::tr$$
    {88, 2307, 2321},	// Plasma::ServiceAccessJob::tr$$$
    {88, 2309, 2328},	// Plasma::ServiceAccessJob::trUtf8$
    {88, 2310, 2320},	// Plasma::ServiceAccessJob::trUtf8$$
    {88, 2311, 2322},	// Plasma::ServiceAccessJob::trUtf8$$$
    {88, 2463, 2331},	// Plasma::ServiceAccessJob::~ServiceAccessJob
    {90, 441, 2406},	// Plasma::SignalPlotter::SignalPlotter
    {90, 442, 2339},	// Plasma::SignalPlotter::SignalPlotter#
    {90, 610, 2340},	// Plasma::SignalPlotter::addPlot#
    {90, 617, 2341},	// Plasma::SignalPlotter::addSample?
    {90, 696, 2381},	// Plasma::SignalPlotter::backgroundColor
    {90, 706, 2393},	// Plasma::SignalPlotter::calculateNiceRange
    {90, 886, 2402},	// Plasma::SignalPlotter::drawAxisText#$$
    {90, 888, 2396},	// Plasma::SignalPlotter::drawBackground#$$
    {90, 891, 2403},	// Plasma::SignalPlotter::drawHorizontalLines#$$$
    {90, 894, 2401},	// Plasma::SignalPlotter::drawPlots#$$$$
    {90, 896, 2397},	// Plasma::SignalPlotter::drawThinFrame#$$
    {90, 898, 2399},	// Plasma::SignalPlotter::drawTopBarContents#$$$
    {90, 900, 2398},	// Plasma::SignalPlotter::drawTopBarFrame#$$
    {90, 902, 2400},	// Plasma::SignalPlotter::drawVerticalLines#$$$
    {90, 905, 2395},	// Plasma::SignalPlotter::drawWidget#$$$
    {90, 1005, 2373},	// Plasma::SignalPlotter::font
    {90, 1008, 2371},	// Plasma::SignalPlotter::fontColor
    {90, 1028, 2390},	// Plasma::SignalPlotter::getSnapshotImage$$
    {90, 1064, 2369},	// Plasma::SignalPlotter::horizontalLinesColor
    {90, 1065, 2375},	// Plasma::SignalPlotter::horizontalLinesCount
    {90, 1066, 2357},	// Plasma::SignalPlotter::horizontalScale
    {90, 1221, 2384},	// Plasma::SignalPlotter::lastValue$
    {90, 1223, 2385},	// Plasma::SignalPlotter::lastValueAsString$
    {90, 1351, 2332},	// Plasma::SignalPlotter::metaObject
    {90, 1422, 2394},	// Plasma::SignalPlotter::paint###
    {90, 1457, 2344},	// Plasma::SignalPlotter::plotColors
    {90, 1486, 2338},	// Plasma::SignalPlotter::qt_metacall$$?
    {90, 1488, 2333},	// Plasma::SignalPlotter::qt_metacast$
    {90, 1550, 2343},	// Plasma::SignalPlotter::removePlot$
    {90, 1571, 2342},	// Plasma::SignalPlotter::reorderPlots?
    {90, 1616, 2349},	// Plasma::SignalPlotter::scale$
    {90, 1617, 2350},	// Plasma::SignalPlotter::scaledBy
    {90, 1699, 2380},	// Plasma::SignalPlotter::setBackgroundColor#
    {90, 1820, 2372},	// Plasma::SignalPlotter::setFont#
    {90, 1823, 2370},	// Plasma::SignalPlotter::setFontColor#
    {90, 1829, 2391},	// Plasma::SignalPlotter::setGeometry#
    {90, 1846, 2368},	// Plasma::SignalPlotter::setHorizontalLinesColor#
    {90, 1848, 2374},	// Plasma::SignalPlotter::setHorizontalLinesCount$
    {90, 1850, 2356},	// Plasma::SignalPlotter::setHorizontalScale$
    {90, 2018, 2366},	// Plasma::SignalPlotter::setShowHorizontalLines$
    {90, 2020, 2376},	// Plasma::SignalPlotter::setShowLabels$
    {90, 2022, 2378},	// Plasma::SignalPlotter::setShowTopBar$
    {90, 2024, 2358},	// Plasma::SignalPlotter::setShowVerticalLines$
    {90, 2040, 2388},	// Plasma::SignalPlotter::setStackPlots$
    {90, 2059, 2382},	// Plasma::SignalPlotter::setSvgBackground$
    {90, 2091, 2386},	// Plasma::SignalPlotter::setThinFrame$
    {90, 2095, 2345},	// Plasma::SignalPlotter::setTitle$
    {90, 2107, 2347},	// Plasma::SignalPlotter::setUnit$
    {90, 2115, 2351},	// Plasma::SignalPlotter::setUseAutoRange$
    {90, 2129, 2360},	// Plasma::SignalPlotter::setVerticalLinesColor#
    {90, 2131, 2362},	// Plasma::SignalPlotter::setVerticalLinesDistance$
    {90, 2133, 2364},	// Plasma::SignalPlotter::setVerticalLinesScroll$
    {90, 2135, 2353},	// Plasma::SignalPlotter::setVerticalRange$$
    {90, 2179, 2367},	// Plasma::SignalPlotter::showHorizontalLines
    {90, 2180, 2377},	// Plasma::SignalPlotter::showLabels
    {90, 2186, 2379},	// Plasma::SignalPlotter::showTopBar
    {90, 2187, 2359},	// Plasma::SignalPlotter::showVerticalLines
    {90, 2215, 2389},	// Plasma::SignalPlotter::stackPlots
    {90, 2223, 2407},	// Plasma::SignalPlotter::staticMetaObject
    {90, 2247, 2383},	// Plasma::SignalPlotter::svgBackground
    {90, 2284, 2387},	// Plasma::SignalPlotter::thinFrame
    {90, 2291, 2346},	// Plasma::SignalPlotter::title
    {90, 2305, 2404},	// Plasma::SignalPlotter::tr$
    {90, 2306, 2334},	// Plasma::SignalPlotter::tr$$
    {90, 2307, 2336},	// Plasma::SignalPlotter::tr$$$
    {90, 2309, 2405},	// Plasma::SignalPlotter::trUtf8$
    {90, 2310, 2335},	// Plasma::SignalPlotter::trUtf8$$
    {90, 2311, 2337},	// Plasma::SignalPlotter::trUtf8$$$
    {90, 2319, 2348},	// Plasma::SignalPlotter::unit
    {90, 2336, 2392},	// Plasma::SignalPlotter::updateDataBuffers
    {90, 2351, 2352},	// Plasma::SignalPlotter::useAutoRange
    {90, 2368, 2361},	// Plasma::SignalPlotter::verticalLinesColor
    {90, 2369, 2363},	// Plasma::SignalPlotter::verticalLinesDistance
    {90, 2370, 2365},	// Plasma::SignalPlotter::verticalLinesScroll
    {90, 2371, 2355},	// Plasma::SignalPlotter::verticalMaxValue
    {90, 2372, 2354},	// Plasma::SignalPlotter::verticalMinValue
    {90, 2464, 2408},	// Plasma::SignalPlotter::~SignalPlotter
    {91, 447, 2435},	// Plasma::Slider::Slider
    {91, 448, 2416},	// Plasma::Slider::Slider#
    {91, 1346, 2417},	// Plasma::Slider::maximum
    {91, 1351, 2409},	// Plasma::Slider::metaObject
    {91, 1361, 2418},	// Plasma::Slider::minimum
    {91, 1388, 2423},	// Plasma::Slider::nativeWidget
    {91, 1412, 2420},	// Plasma::Slider::orientation
    {91, 1422, 2424},	// Plasma::Slider::paint###
    {91, 1486, 2415},	// Plasma::Slider::qt_metacall$$?
    {91, 1488, 2410},	// Plasma::Slider::qt_metacast$
    {91, 1903, 2426},	// Plasma::Slider::setMaximum$
    {91, 1911, 2427},	// Plasma::Slider::setMinimum$
    {91, 1936, 2430},	// Plasma::Slider::setOrientation$
    {91, 1979, 2428},	// Plasma::Slider::setRange$$
    {91, 2049, 2421},	// Plasma::Slider::setStyleSheet$
    {91, 2125, 2429},	// Plasma::Slider::setValue$
    {91, 2205, 2431},	// Plasma::Slider::sliderMoved$
    {91, 2223, 2436},	// Plasma::Slider::staticMetaObject
    {91, 2236, 2422},	// Plasma::Slider::styleSheet
    {91, 2305, 2433},	// Plasma::Slider::tr$
    {91, 2306, 2411},	// Plasma::Slider::tr$$
    {91, 2307, 2413},	// Plasma::Slider::tr$$$
    {91, 2309, 2434},	// Plasma::Slider::trUtf8$
    {91, 2310, 2412},	// Plasma::Slider::trUtf8$$
    {91, 2311, 2414},	// Plasma::Slider::trUtf8$$$
    {91, 2360, 2419},	// Plasma::Slider::value
    {91, 2362, 2432},	// Plasma::Slider::valueChanged$
    {91, 2390, 2425},	// Plasma::Slider::wheelEvent#
    {91, 2465, 2437},	// Plasma::Slider::~Slider
    {92, 454, 2468},	// Plasma::SpinBox::SpinBox
    {92, 455, 2445},	// Plasma::SpinBox::SpinBox#
    {92, 711, 2452},	// Plasma::SpinBox::changeEvent#
    {92, 910, 2465},	// Plasma::SpinBox::editingFinished
    {92, 1003, 2458},	// Plasma::SpinBox::focusOutEvent#
    {92, 1069, 2453},	// Plasma::SpinBox::hoverEnterEvent#
    {92, 1071, 2454},	// Plasma::SpinBox::hoverLeaveEvent#
    {92, 1346, 2446},	// Plasma::SpinBox::maximum
    {92, 1351, 2438},	// Plasma::SpinBox::metaObject
    {92, 1361, 2447},	// Plasma::SpinBox::minimum
    {92, 1371, 2457},	// Plasma::SpinBox::mousePressEvent#
    {92, 1388, 2451},	// Plasma::SpinBox::nativeWidget
    {92, 1422, 2456},	// Plasma::SpinBox::paint###
    {92, 1486, 2444},	// Plasma::SpinBox::qt_metacall$$?
    {92, 1488, 2439},	// Plasma::SpinBox::qt_metacast$
    {92, 1585, 2455},	// Plasma::SpinBox::resizeEvent#
    {92, 1903, 2459},	// Plasma::SpinBox::setMaximum$
    {92, 1911, 2460},	// Plasma::SpinBox::setMinimum$
    {92, 1979, 2461},	// Plasma::SpinBox::setRange$$
    {92, 2049, 2449},	// Plasma::SpinBox::setStyleSheet$
    {92, 2125, 2462},	// Plasma::SpinBox::setValue$
    {92, 2205, 2463},	// Plasma::SpinBox::sliderMoved$
    {92, 2223, 2469},	// Plasma::SpinBox::staticMetaObject
    {92, 2236, 2450},	// Plasma::SpinBox::styleSheet
    {92, 2305, 2466},	// Plasma::SpinBox::tr$
    {92, 2306, 2440},	// Plasma::SpinBox::tr$$
    {92, 2307, 2442},	// Plasma::SpinBox::tr$$$
    {92, 2309, 2467},	// Plasma::SpinBox::trUtf8$
    {92, 2310, 2441},	// Plasma::SpinBox::trUtf8$$
    {92, 2311, 2443},	// Plasma::SpinBox::trUtf8$$$
    {92, 2360, 2448},	// Plasma::SpinBox::value
    {92, 2362, 2464},	// Plasma::SpinBox::valueChanged$
    {92, 2466, 2470},	// Plasma::SpinBox::~SpinBox
    {93, 469, 2505},	// Plasma::Svg::Svg
    {93, 470, 2478},	// Plasma::Svg::Svg#
    {93, 782, 2494},	// Plasma::Svg::containsMultipleImages
    {93, 924, 2491},	// Plasma::Svg::elementAtPoint#
    {93, 929, 2489},	// Plasma::Svg::elementRect$
    {93, 931, 2488},	// Plasma::Svg::elementSize$
    {93, 1042, 2490},	// Plasma::Svg::hasElement$
    {93, 1080, 2496},	// Plasma::Svg::imagePath
    {93, 1163, 2498},	// Plasma::Svg::isUsingRenderingCache
    {93, 1164, 2492},	// Plasma::Svg::isValid
    {93, 1351, 2471},	// Plasma::Svg::metaObject
    {93, 1421, -15},	// Plasma::Svg::paint##
    {93, 1423, -18},	// Plasma::Svg::paint##$
    {93, 1424, 2508},	// Plasma::Svg::paint#$$
    {93, 1425, 2481},	// Plasma::Svg::paint#$$$
    {93, 1426, 2510},	// Plasma::Svg::paint#$$$$
    {93, 1427, 2483},	// Plasma::Svg::paint#$$$$$
    {93, 1454, 2506},	// Plasma::Svg::pixmap
    {93, 1455, 2479},	// Plasma::Svg::pixmap$
    {93, 1486, 2477},	// Plasma::Svg::qt_metacall$$?
    {93, 1488, 2472},	// Plasma::Svg::qt_metacast$
    {93, 1572, 2501},	// Plasma::Svg::repaintNeeded
    {93, 1580, 2487},	// Plasma::Svg::resize
    {93, 1581, 2486},	// Plasma::Svg::resize#
    {93, 1582, 2485},	// Plasma::Svg::resize$$
    {93, 1738, 2493},	// Plasma::Svg::setContainsMultipleImages$
    {93, 1870, 2495},	// Plasma::Svg::setImagePath$
    {93, 2087, 2499},	// Plasma::Svg::setTheme#
    {93, 2121, 2497},	// Plasma::Svg::setUsingRenderingCache$
    {93, 2194, 2484},	// Plasma::Svg::size
    {93, 2195, 2502},	// Plasma::Svg::sizeChanged
    {93, 2223, 2511},	// Plasma::Svg::staticMetaObject
    {93, 2281, 2500},	// Plasma::Svg::theme
    {93, 2305, 2503},	// Plasma::Svg::tr$
    {93, 2306, 2473},	// Plasma::Svg::tr$$
    {93, 2307, 2475},	// Plasma::Svg::tr$$$
    {93, 2309, 2504},	// Plasma::Svg::trUtf8$
    {93, 2310, 2474},	// Plasma::Svg::trUtf8$$
    {93, 2311, 2476},	// Plasma::Svg::trUtf8$$$
    {93, 2468, 2512},	// Plasma::Svg::~Svg
    {94, 471, 2533},	// Plasma::SvgWidget::SvgWidget
    {94, 472, -61},	// Plasma::SvgWidget::SvgWidget#
    {94, 473, -64},	// Plasma::SvgWidget::SvgWidget#$
    {94, 474, 2537},	// Plasma::SvgWidget::SvgWidget#$#
    {94, 475, 2521},	// Plasma::SvgWidget::SvgWidget#$#$
    {94, 727, 2527},	// Plasma::SvgWidget::clicked$
    {94, 927, 2525},	// Plasma::SvgWidget::elementID
    {94, 1351, 2513},	// Plasma::SvgWidget::metaObject
    {94, 1371, 2530},	// Plasma::SvgWidget::mousePressEvent#
    {94, 1373, 2526},	// Plasma::SvgWidget::mouseReleaseEvent#
    {94, 1422, 2528},	// Plasma::SvgWidget::paint###
    {94, 1486, 2519},	// Plasma::SvgWidget::qt_metacall$$?
    {94, 1488, 2514},	// Plasma::SvgWidget::qt_metacast$
    {94, 1799, 2524},	// Plasma::SvgWidget::setElementID$
    {94, 2055, 2522},	// Plasma::SvgWidget::setSvg#
    {94, 2201, 2529},	// Plasma::SvgWidget::sizeHint$#
    {94, 2223, 2538},	// Plasma::SvgWidget::staticMetaObject
    {94, 2246, 2523},	// Plasma::SvgWidget::svg
    {94, 2305, 2531},	// Plasma::SvgWidget::tr$
    {94, 2306, 2515},	// Plasma::SvgWidget::tr$$
    {94, 2307, 2517},	// Plasma::SvgWidget::tr$$$
    {94, 2309, 2532},	// Plasma::SvgWidget::trUtf8$
    {94, 2310, 2516},	// Plasma::SvgWidget::trUtf8$$
    {94, 2311, 2518},	// Plasma::SvgWidget::trUtf8$$$
    {94, 2469, 2539},	// Plasma::SvgWidget::~SvgWidget
    {95, 477, 2579},	// Plasma::TabBar::TabBar
    {95, 478, 2547},	// Plasma::TabBar::TabBar#
    {95, 629, 2582},	// Plasma::TabBar::addTab#$
    {95, 630, 2550},	// Plasma::TabBar::addTab#$#
    {95, 631, 2583},	// Plasma::TabBar::addTab$
    {95, 632, 2551},	// Plasma::TabBar::addTab$#
    {95, 711, 2576},	// Plasma::TabBar::changeEvent#
    {95, 799, 2556},	// Plasma::TabBar::count
    {95, 822, 2573},	// Plasma::TabBar::currentChanged$
    {95, 823, 2555},	// Plasma::TabBar::currentIndex
    {95, 987, 2569},	// Plasma::TabBar::firstPositionWidget
    {95, 1108, 2580},	// Plasma::TabBar::insertTab$#$
    {95, 1109, 2548},	// Plasma::TabBar::insertTab$#$#
    {95, 1110, 2581},	// Plasma::TabBar::insertTab$$
    {95, 1111, 2549},	// Plasma::TabBar::insertTab$$#
    {95, 1156, 2562},	// Plasma::TabBar::isTabBarShown
    {95, 1158, 2566},	// Plasma::TabBar::isTabHighlighted$
    {95, 1218, 2571},	// Plasma::TabBar::lastPositionWidget
    {95, 1351, 2540},	// Plasma::TabBar::metaObject
    {95, 1388, 2567},	// Plasma::TabBar::nativeWidget
    {95, 1486, 2546},	// Plasma::TabBar::qt_metacall$$?
    {95, 1488, 2541},	// Plasma::TabBar::qt_metacast$
    {95, 1554, 2552},	// Plasma::TabBar::removeTab$
    {95, 1585, 2575},	// Plasma::TabBar::resizeEvent#
    {95, 1756, 2572},	// Plasma::TabBar::setCurrentIndex$
    {95, 1818, 2568},	// Plasma::TabBar::setFirstPositionWidget#
    {95, 1893, 2570},	// Plasma::TabBar::setLastPositionWidget#
    {95, 2049, 2563},	// Plasma::TabBar::setStyleSheet$
    {95, 2063, 2561},	// Plasma::TabBar::setTabBarShown$
    {95, 2065, 2565},	// Plasma::TabBar::setTabHighlighted$$
    {95, 2067, 2559},	// Plasma::TabBar::setTabIcon$#
    {95, 2069, 2557},	// Plasma::TabBar::setTabText$$
    {95, 2223, 2584},	// Plasma::TabBar::staticMetaObject
    {95, 2236, 2564},	// Plasma::TabBar::styleSheet
    {95, 2256, 2554},	// Plasma::TabBar::tabAt$
    {95, 2258, 2560},	// Plasma::TabBar::tabIcon$
    {95, 2260, 2558},	// Plasma::TabBar::tabText$
    {95, 2263, 2553},	// Plasma::TabBar::takeTab$
    {95, 2305, 2577},	// Plasma::TabBar::tr$
    {95, 2306, 2542},	// Plasma::TabBar::tr$$
    {95, 2307, 2544},	// Plasma::TabBar::tr$$$
    {95, 2309, 2578},	// Plasma::TabBar::trUtf8$
    {95, 2310, 2543},	// Plasma::TabBar::trUtf8$$
    {95, 2311, 2545},	// Plasma::TabBar::trUtf8$$$
    {95, 2390, 2574},	// Plasma::TabBar::wheelEvent#
    {95, 2470, 2585},	// Plasma::TabBar::~TabBar
    {96, 479, 2610},	// Plasma::TextBrowser::TextBrowser
    {96, 480, 2593},	// Plasma::TextBrowser::TextBrowser#
    {96, 663, 2601},	// Plasma::TextBrowser::append$
    {96, 711, 2606},	// Plasma::TextBrowser::changeEvent#
    {96, 795, 2607},	// Plasma::TextBrowser::contextMenuEvent#
    {96, 842, 2602},	// Plasma::TextBrowser::dataUpdated$?
    {96, 1351, 2586},	// Plasma::TextBrowser::metaObject
    {96, 1388, 2600},	// Plasma::TextBrowser::nativeWidget
    {96, 1486, 2592},	// Plasma::TextBrowser::qt_metacall$$?
    {96, 1488, 2587},	// Plasma::TextBrowser::qt_metacast$
    {96, 1585, 2604},	// Plasma::TextBrowser::resizeEvent#
    {96, 1852, 2596},	// Plasma::TextBrowser::setHorizontalScrollBarPolicy$
    {96, 2049, 2598},	// Plasma::TextBrowser::setStyleSheet$
    {96, 2081, 2594},	// Plasma::TextBrowser::setText$
    {96, 2137, 2597},	// Plasma::TextBrowser::setVerticalScrollBarPolicy$
    {96, 2223, 2611},	// Plasma::TextBrowser::staticMetaObject
    {96, 2236, 2599},	// Plasma::TextBrowser::styleSheet
    {96, 2274, 2595},	// Plasma::TextBrowser::text
    {96, 2276, 2603},	// Plasma::TextBrowser::textChanged
    {96, 2305, 2608},	// Plasma::TextBrowser::tr$
    {96, 2306, 2588},	// Plasma::TextBrowser::tr$$
    {96, 2307, 2590},	// Plasma::TextBrowser::tr$$$
    {96, 2309, 2609},	// Plasma::TextBrowser::trUtf8$
    {96, 2310, 2589},	// Plasma::TextBrowser::trUtf8$$
    {96, 2311, 2591},	// Plasma::TextBrowser::trUtf8$$$
    {96, 2390, 2605},	// Plasma::TextBrowser::wheelEvent#
    {96, 2471, 2612},	// Plasma::TextBrowser::~TextBrowser
    {97, 482, 2639},	// Plasma::TextEdit::TextEdit
    {97, 483, 2620},	// Plasma::TextEdit::TextEdit#
    {97, 663, 2629},	// Plasma::TextEdit::append$
    {97, 711, 2633},	// Plasma::TextEdit::changeEvent#
    {97, 795, 2634},	// Plasma::TextEdit::contextMenuEvent#
    {97, 842, 2630},	// Plasma::TextEdit::dataUpdated$?
    {97, 1003, 2636},	// Plasma::TextEdit::focusOutEvent#
    {97, 1148, 2624},	// Plasma::TextEdit::isReadOnly
    {97, 1351, 2613},	// Plasma::TextEdit::metaObject
    {97, 1371, 2635},	// Plasma::TextEdit::mousePressEvent#
    {97, 1388, 2628},	// Plasma::TextEdit::nativeWidget
    {97, 1486, 2619},	// Plasma::TextEdit::qt_metacall$$?
    {97, 1488, 2614},	// Plasma::TextEdit::qt_metacast$
    {97, 1585, 2632},	// Plasma::TextEdit::resizeEvent#
    {97, 1924, 2627},	// Plasma::TextEdit::setNativeWidget#
    {97, 1981, 2623},	// Plasma::TextEdit::setReadOnly$
    {97, 2049, 2625},	// Plasma::TextEdit::setStyleSheet$
    {97, 2081, 2621},	// Plasma::TextEdit::setText$
    {97, 2223, 2640},	// Plasma::TextEdit::staticMetaObject
    {97, 2236, 2626},	// Plasma::TextEdit::styleSheet
    {97, 2274, 2622},	// Plasma::TextEdit::text
    {97, 2276, 2631},	// Plasma::TextEdit::textChanged
    {97, 2305, 2637},	// Plasma::TextEdit::tr$
    {97, 2306, 2615},	// Plasma::TextEdit::tr$$
    {97, 2307, 2617},	// Plasma::TextEdit::tr$$$
    {97, 2309, 2638},	// Plasma::TextEdit::trUtf8$
    {97, 2310, 2616},	// Plasma::TextEdit::trUtf8$$
    {97, 2311, 2618},	// Plasma::TextEdit::trUtf8$$$
    {97, 2472, 2641},	// Plasma::TextEdit::~TextEdit
    {98, 53, 2694},	// Plasma::Theme::BackgroundColor
    {98, 70, 2696},	// Plasma::Theme::ButtonBackgroundColor
    {98, 72, 2700},	// Plasma::Theme::ButtonFocusColor
    {98, 73, 2699},	// Plasma::Theme::ButtonHoverColor
    {98, 77, 2695},	// Plasma::Theme::ButtonTextColor
    {98, 134, 2705},	// Plasma::Theme::DefaultFont
    {98, 142, 2706},	// Plasma::Theme::DesktopFont
    {98, 208, 2693},	// Plasma::Theme::HighlightColor
    {98, 303, 2697},	// Plasma::Theme::LinkColor
    {98, 450, 2707},	// Plasma::Theme::SmallestFont
    {98, 481, 2692},	// Plasma::Theme::TextColor
    {98, 484, 2686},	// Plasma::Theme::Theme
    {98, 485, 2650},	// Plasma::Theme::Theme#
    {98, 486, 2687},	// Plasma::Theme::Theme$
    {98, 487, 2651},	// Plasma::Theme::Theme$#
    {98, 531, 2702},	// Plasma::Theme::ViewBackgroundColor
    {98, 532, 2704},	// Plasma::Theme::ViewFocusColor
    {98, 533, 2703},	// Plasma::Theme::ViewHoverColor
    {98, 534, 2701},	// Plasma::Theme::ViewTextColor
    {98, 535, 2698},	// Plasma::Theme::VisitedLinkColor
    {98, 657, 2657},	// Plasma::Theme::animationPath$
    {98, 736, 2661},	// Plasma::Theme::color$
    {98, 737, 2660},	// Plasma::Theme::colorScheme
    {98, 829, 2659},	// Plasma::Theme::currentThemeHasImage$
    {98, 846, 2649},	// Plasma::Theme::defaultTheme
    {98, 977, 2670},	// Plasma::Theme::findInCache$#
    {98, 978, 2671},	// Plasma::Theme::findInCache$#$
    {98, 980, 2675},	// Plasma::Theme::findInRectsCache$$#
    {98, 1006, 2663},	// Plasma::Theme::font$
    {98, 1009, 2664},	// Plasma::Theme::fontMetrics
    {98, 1063, 2680},	// Plasma::Theme::homepage
    {98, 1081, 2656},	// Plasma::Theme::imagePath$
    {98, 1103, 2672},	// Plasma::Theme::insertIntoCache$#
    {98, 1104, 2673},	// Plasma::Theme::insertIntoCache$#$
    {98, 1106, 2677},	// Plasma::Theme::insertIntoRectsCache$$#
    {98, 1116, 2678},	// Plasma::Theme::invalidateRectsCache$
    {98, 1246, 2676},	// Plasma::Theme::listCachedRectKeys$
    {98, 1273, 2653},	// Plasma::Theme::listThemeInfo
    {98, 1351, 2642},	// Plasma::Theme::metaObject
    {98, 1415, 2652},	// Plasma::Theme::packageStructure
    {98, 1486, 2648},	// Plasma::Theme::qt_metacall$$?
    {98, 1488, 2643},	// Plasma::Theme::qt_metacast$
    {98, 1514, 2679},	// Plasma::Theme::releaseRectsCache$
    {98, 1709, 2674},	// Plasma::Theme::setCacheLimit$
    {98, 1820, 2689},	// Plasma::Theme::setFont#
    {98, 1821, 2662},	// Plasma::Theme::setFont#$
    {98, 2089, 2654},	// Plasma::Theme::setThemeName$
    {98, 2117, 2666},	// Plasma::Theme::setUseGlobalSettings$
    {98, 2159, 2683},	// Plasma::Theme::settingsChanged
    {98, 2223, 2691},	// Plasma::Theme::staticMetaObject
    {98, 2236, 2690},	// Plasma::Theme::styleSheet
    {98, 2237, 2669},	// Plasma::Theme::styleSheet$
    {98, 2282, 2682},	// Plasma::Theme::themeChanged
    {98, 2283, 2655},	// Plasma::Theme::themeName
    {98, 2300, 2681},	// Plasma::Theme::toolTipDelay
    {98, 2305, 2684},	// Plasma::Theme::tr$
    {98, 2306, 2644},	// Plasma::Theme::tr$$
    {98, 2307, 2646},	// Plasma::Theme::tr$$$
    {98, 2309, 2685},	// Plasma::Theme::trUtf8$
    {98, 2310, 2645},	// Plasma::Theme::trUtf8$$
    {98, 2311, 2647},	// Plasma::Theme::trUtf8$$$
    {98, 2353, 2667},	// Plasma::Theme::useGlobalSettings
    {98, 2354, 2668},	// Plasma::Theme::useNativeWidgetStyle
    {98, 2386, 2688},	// Plasma::Theme::wallpaperPath
    {98, 2387, 2658},	// Plasma::Theme::wallpaperPath#
    {98, 2398, 2665},	// Plasma::Theme::windowTranslucencyEnabled
    {98, 2473, 2708},	// Plasma::Theme::~Theme
    {99, 489, 2745},	// Plasma::ToolButton::ToolButton
    {99, 490, 2716},	// Plasma::ToolButton::ToolButton#
    {99, 557, 2729},	// Plasma::ToolButton::action
    {99, 690, 2718},	// Plasma::ToolButton::autoRaise
    {99, 711, 2740},	// Plasma::ToolButton::changeEvent#
    {99, 726, 2733},	// Plasma::ToolButton::clicked
    {99, 1069, 2738},	// Plasma::ToolButton::hoverEnterEvent#
    {99, 1071, 2739},	// Plasma::ToolButton::hoverLeaveEvent#
    {99, 1075, 2731},	// Plasma::ToolButton::icon
    {99, 1079, 2723},	// Plasma::ToolButton::image
    {99, 1130, 2725},	// Plasma::ToolButton::isDown
    {99, 1180, 2741},	// Plasma::ToolButton::itemChange$#
    {99, 1351, 2709},	// Plasma::ToolButton::metaObject
    {99, 1388, 2732},	// Plasma::ToolButton::nativeWidget
    {99, 1421, 2746},	// Plasma::ToolButton::paint##
    {99, 1422, 2736},	// Plasma::ToolButton::paint###
    {99, 1476, 2734},	// Plasma::ToolButton::pressed
    {99, 1486, 2715},	// Plasma::ToolButton::qt_metacall$$?
    {99, 1488, 2710},	// Plasma::ToolButton::qt_metacast$
    {99, 1516, 2735},	// Plasma::ToolButton::released
    {99, 1585, 2737},	// Plasma::ToolButton::resizeEvent#
    {99, 1659, 2728},	// Plasma::ToolButton::setAction#
    {99, 1695, 2717},	// Plasma::ToolButton::setAutoRaise$
    {99, 1786, 2724},	// Plasma::ToolButton::setDown$
    {99, 1859, 2730},	// Plasma::ToolButton::setIcon#
    {99, 1867, 2721},	// Plasma::ToolButton::setImage$
    {99, 1868, 2722},	// Plasma::ToolButton::setImage$$
    {99, 2049, 2726},	// Plasma::ToolButton::setStyleSheet$
    {99, 2081, 2719},	// Plasma::ToolButton::setText$
    {99, 2201, 2742},	// Plasma::ToolButton::sizeHint$#
    {99, 2223, 2747},	// Plasma::ToolButton::staticMetaObject
    {99, 2236, 2727},	// Plasma::ToolButton::styleSheet
    {99, 2274, 2720},	// Plasma::ToolButton::text
    {99, 2305, 2743},	// Plasma::ToolButton::tr$
    {99, 2306, 2711},	// Plasma::ToolButton::tr$$
    {99, 2307, 2713},	// Plasma::ToolButton::tr$$$
    {99, 2309, 2744},	// Plasma::ToolButton::trUtf8$
    {99, 2310, 2712},	// Plasma::ToolButton::trUtf8$$
    {99, 2311, 2714},	// Plasma::ToolButton::trUtf8$$$
    {99, 2474, 2748},	// Plasma::ToolButton::~ToolButton
    {100, 118, 2781},	// Plasma::ToolTipContent::CssResource
    {100, 211, 2780},	// Plasma::ToolTipContent::HtmlResource
    {100, 220, 2779},	// Plasma::ToolTipContent::ImageResource
    {100, 491, 2749},	// Plasma::ToolTipContent::ToolTipContent
    {100, 492, 2750},	// Plasma::ToolTipContent::ToolTipContent#
    {100, 493, 2778},	// Plasma::ToolTipContent::ToolTipContent$$
    {100, 494, -76},	// Plasma::ToolTipContent::ToolTipContent$$#
    {100, 615, 2772},	// Plasma::ToolTipContent::addResource$##
    {100, 691, 2769},	// Plasma::ToolTipContent::autohide
    {100, 1033, 2777},	// Plasma::ToolTipContent::graphicsWidget
    {100, 1062, 2767},	// Plasma::ToolTipContent::highlightWindows
    {100, 1079, 2761},	// Plasma::ToolTipContent::image
    {100, 1126, 2775},	// Plasma::ToolTipContent::isClickable
    {100, 1131, 2754},	// Plasma::ToolTipContent::isEmpty
    {100, 1137, 2771},	// Plasma::ToolTipContent::isInstantPopup
    {100, 1325, 2756},	// Plasma::ToolTipContent::mainText
    {100, 1409, 2753},	// Plasma::ToolTipContent::operator=#
    {100, 1508, 2773},	// Plasma::ToolTipContent::registerResources#
    {100, 1697, 2768},	// Plasma::ToolTipContent::setAutohide$
    {100, 1721, 2774},	// Plasma::ToolTipContent::setClickable$
    {100, 1833, 2776},	// Plasma::ToolTipContent::setGraphicsWidget#
    {100, 1844, 2766},	// Plasma::ToolTipContent::setHighlightWindows$
    {100, 1866, -79},	// Plasma::ToolTipContent::setImage#
    {100, 1880, 2770},	// Plasma::ToolTipContent::setInstantPopup$
    {100, 1899, 2755},	// Plasma::ToolTipContent::setMainText$
    {100, 2051, 2757},	// Plasma::ToolTipContent::setSubText$
    {100, 2152, 2762},	// Plasma::ToolTipContent::setWindowToPreview$
    {100, 2154, 2764},	// Plasma::ToolTipContent::setWindowsToPreview?
    {100, 2238, 2758},	// Plasma::ToolTipContent::subText
    {100, 2397, 2763},	// Plasma::ToolTipContent::windowToPreview
    {100, 2399, 2765},	// Plasma::ToolTipContent::windowsToPreview
    {100, 2475, 2782},	// Plasma::ToolTipContent::~ToolTipContent
    {101, 17, 2805},	// Plasma::ToolTipManager::Activated
    {101, 130, 2807},	// Plasma::ToolTipManager::Deactivated
    {101, 224, 2806},	// Plasma::ToolTipManager::Inhibited
    {101, 723, 2797},	// Plasma::ToolTipManager::clearContent#
    {101, 1057, 2793},	// Plasma::ToolTipManager::hide#
    {101, 1166, 2792},	// Plasma::ToolTipManager::isVisible#
    {101, 1232, 2801},	// Plasma::ToolTipManager::linkActivated$$$#
    {101, 1351, 2783},	// Plasma::ToolTipManager::metaObject
    {101, 1486, 2789},	// Plasma::ToolTipManager::qt_metacall$$?
    {101, 1488, 2784},	// Plasma::ToolTipManager::qt_metacast$
    {101, 1512, 2794},	// Plasma::ToolTipManager::registerWidget#
    {101, 1646, 2790},	// Plasma::ToolTipManager::self
    {101, 1740, 2796},	// Plasma::ToolTipManager::setContent##
    {101, 2042, 2798},	// Plasma::ToolTipManager::setState$
    {101, 2165, 2791},	// Plasma::ToolTipManager::show#
    {101, 2222, 2799},	// Plasma::ToolTipManager::state
    {101, 2223, 2804},	// Plasma::ToolTipManager::staticMetaObject
    {101, 2305, 2802},	// Plasma::ToolTipManager::tr$
    {101, 2306, 2785},	// Plasma::ToolTipManager::tr$$
    {101, 2307, 2787},	// Plasma::ToolTipManager::tr$$$
    {101, 2309, 2803},	// Plasma::ToolTipManager::trUtf8$
    {101, 2310, 2786},	// Plasma::ToolTipManager::trUtf8$$
    {101, 2311, 2788},	// Plasma::ToolTipManager::trUtf8$$$
    {101, 2328, 2795},	// Plasma::ToolTipManager::unregisterWidget#
    {101, 2396, 2800},	// Plasma::ToolTipManager::windowPreviewActivated$$$#
    {102, 504, 2823},	// Plasma::TreeView::TreeView
    {102, 505, 2815},	// Plasma::TreeView::TreeView#
    {102, 1351, 2808},	// Plasma::TreeView::metaObject
    {102, 1365, 2817},	// Plasma::TreeView::model
    {102, 1388, 2820},	// Plasma::TreeView::nativeWidget
    {102, 1486, 2814},	// Plasma::TreeView::qt_metacall$$?
    {102, 1488, 2809},	// Plasma::TreeView::qt_metacast$
    {102, 1919, 2816},	// Plasma::TreeView::setModel#
    {102, 2049, 2818},	// Plasma::TreeView::setStyleSheet$
    {102, 2223, 2824},	// Plasma::TreeView::staticMetaObject
    {102, 2236, 2819},	// Plasma::TreeView::styleSheet
    {102, 2305, 2821},	// Plasma::TreeView::tr$
    {102, 2306, 2810},	// Plasma::TreeView::tr$$
    {102, 2307, 2812},	// Plasma::TreeView::tr$$$
    {102, 2309, 2822},	// Plasma::TreeView::trUtf8$
    {102, 2310, 2811},	// Plasma::TreeView::trUtf8$$
    {102, 2311, 2813},	// Plasma::TreeView::trUtf8$$$
    {102, 2476, 2825},	// Plasma::TreeView::~TreeView
    {103, 133, 2876},	// Plasma::VideoWidget::DefaultControls
    {103, 322, 2872},	// Plasma::VideoWidget::Next
    {103, 333, 2866},	// Plasma::VideoWidget::NoControls
    {103, 349, 2875},	// Plasma::VideoWidget::OpenFile
    {103, 365, 2868},	// Plasma::VideoWidget::Pause
    {103, 374, 2867},	// Plasma::VideoWidget::Play
    {103, 375, 2870},	// Plasma::VideoWidget::PlayPause
    {103, 382, 2871},	// Plasma::VideoWidget::Previous
    {103, 383, 2873},	// Plasma::VideoWidget::Progress
    {103, 459, 2869},	// Plasma::VideoWidget::Stop
    {103, 524, 2864},	// Plasma::VideoWidget::VideoWidget
    {103, 525, 2833},	// Plasma::VideoWidget::VideoWidget#
    {103, 536, 2874},	// Plasma::VideoWidget::Volume
    {103, 551, 2855},	// Plasma::VideoWidget::aboutToFinish
    {103, 684, 2837},	// Plasma::VideoWidget::audioOutput
    {103, 797, 2844},	// Plasma::VideoWidget::controlsVisible
    {103, 830, 2838},	// Plasma::VideoWidget::currentTime
    {103, 1069, 2859},	// Plasma::VideoWidget::hoverEnterEvent#
    {103, 1071, 2860},	// Plasma::VideoWidget::hoverLeaveEvent#
    {103, 1073, 2861},	// Plasma::VideoWidget::hoverMoveEvent#
    {103, 1348, 2836},	// Plasma::VideoWidget::mediaObject
    {103, 1351, 2826},	// Plasma::VideoWidget::metaObject
    {103, 1388, 2849},	// Plasma::VideoWidget::nativeWidget
    {103, 1394, 2856},	// Plasma::VideoWidget::nextRequested
    {103, 1449, 2851},	// Plasma::VideoWidget::pause
    {103, 1456, 2850},	// Plasma::VideoWidget::play
    {103, 1478, 2857},	// Plasma::VideoWidget::previousRequested
    {103, 1486, 2832},	// Plasma::VideoWidget::qt_metacall$$?
    {103, 1488, 2827},	// Plasma::VideoWidget::qt_metacast$
    {103, 1520, 2840},	// Plasma::VideoWidget::remainingTime
    {103, 1585, 2858},	// Plasma::VideoWidget::resizeEvent#
    {103, 1644, 2853},	// Plasma::VideoWidget::seek$
    {103, 1750, 2843},	// Plasma::VideoWidget::setControlsVisible$
    {103, 2049, 2847},	// Plasma::VideoWidget::setStyleSheet$
    {103, 2093, 2845},	// Plasma::VideoWidget::setTickInterval$
    {103, 2111, 2834},	// Plasma::VideoWidget::setUrl$
    {103, 2119, 2841},	// Plasma::VideoWidget::setUsedControls$
    {103, 2223, 2865},	// Plasma::VideoWidget::staticMetaObject
    {103, 2225, 2852},	// Plasma::VideoWidget::stop
    {103, 2236, 2848},	// Plasma::VideoWidget::styleSheet
    {103, 2286, 2854},	// Plasma::VideoWidget::tick$
    {103, 2287, 2846},	// Plasma::VideoWidget::tickInterval
    {103, 2303, 2839},	// Plasma::VideoWidget::totalTime
    {103, 2305, 2862},	// Plasma::VideoWidget::tr$
    {103, 2306, 2828},	// Plasma::VideoWidget::tr$$
    {103, 2307, 2830},	// Plasma::VideoWidget::tr$$$
    {103, 2309, 2863},	// Plasma::VideoWidget::trUtf8$
    {103, 2310, 2829},	// Plasma::VideoWidget::trUtf8$$
    {103, 2311, 2831},	// Plasma::VideoWidget::trUtf8$$$
    {103, 2346, 2835},	// Plasma::VideoWidget::url
    {103, 2355, 2842},	// Plasma::VideoWidget::usedControls
    {103, 2477, 2877},	// Plasma::VideoWidget::~VideoWidget
    {104, 527, 2908},	// Plasma::View::View#
    {104, 528, 2885},	// Plasma::View::View##
    {104, 529, 2909},	// Plasma::View::View#$
    {104, 530, 2886},	// Plasma::View::View#$#
    {104, 738, 2904},	// Plasma::View::config
    {104, 741, 2905},	// Plasma::View::configNeedsSaving
    {104, 765, 2893},	// Plasma::View::containment
    {104, 850, 2891},	// Plasma::View::desktop
    {104, 912, 2892},	// Plasma::View::effectiveDesktop
    {104, 1077, 2899},	// Plasma::View::id
    {104, 1167, 2888},	// Plasma::View::isWallpaperEnabled
    {104, 1321, 2902},	// Plasma::View::lostContainment
    {104, 1351, 2878},	// Plasma::View::metaObject
    {104, 1486, 2884},	// Plasma::View::qt_metacall$$?
    {104, 1488, 2879},	// Plasma::View::qt_metacast$
    {104, 1623, 2900},	// Plasma::View::sceneRectAboutToChange
    {104, 1624, 2901},	// Plasma::View::sceneRectChanged
    {104, 1626, 2890},	// Plasma::View::screen
    {104, 1730, 2903},	// Plasma::View::setContainment#
    {104, 2005, 2910},	// Plasma::View::setScreen$
    {104, 2006, 2889},	// Plasma::View::setScreen$$
    {104, 2101, 2896},	// Plasma::View::setTrackContainmentChanges$
    {104, 2146, 2887},	// Plasma::View::setWallpaperEnabled$
    {104, 2223, 2913},	// Plasma::View::staticMetaObject
    {104, 2249, 2911},	// Plasma::View::swapContainment#$
    {104, 2250, 2894},	// Plasma::View::swapContainment#$?
    {104, 2251, 2912},	// Plasma::View::swapContainment$
    {104, 2252, 2895},	// Plasma::View::swapContainment$?
    {104, 2302, 2898},	// Plasma::View::topLevelViewAt#
    {104, 2305, 2906},	// Plasma::View::tr$
    {104, 2306, 2880},	// Plasma::View::tr$$
    {104, 2307, 2882},	// Plasma::View::tr$$$
    {104, 2309, 2907},	// Plasma::View::trUtf8$
    {104, 2310, 2881},	// Plasma::View::trUtf8$$
    {104, 2311, 2883},	// Plasma::View::trUtf8$$$
    {104, 2312, 2897},	// Plasma::View::trackContainmentChanges
    {104, 2478, 2914},	// Plasma::View::~View
    {105, 84, 2998},	// Plasma::Wallpaper::CenterTiledResize
    {105, 85, 2995},	// Plasma::Wallpaper::CenteredResize
    {105, 291, 3000},	// Plasma::Wallpaper::LastResizeMethod
    {105, 308, 2999},	// Plasma::Wallpaper::MaxpectResize
    {105, 417, 2996},	// Plasma::Wallpaper::ScaledAndCroppedResize
    {105, 418, 2994},	// Plasma::Wallpaper::ScaledResize
    {105, 488, 2997},	// Plasma::Wallpaper::TiledResize
    {105, 537, 2979},	// Plasma::Wallpaper::Wallpaper
    {105, 538, 2922},	// Plasma::Wallpaper::Wallpaper#
    {105, 539, 2967},	// Plasma::Wallpaper::Wallpaper#?
    {105, 638, 2966},	// Plasma::Wallpaper::addUrls?
    {105, 704, 2938},	// Plasma::Wallpaper::boundingRect
    {105, 741, 2962},	// Plasma::Wallpaper::configNeedsSaving
    {105, 745, 2949},	// Plasma::Wallpaper::configurationRequired
    {105, 746, 2961},	// Plasma::Wallpaper::configurationRequired$
    {105, 747, 2960},	// Plasma::Wallpaper::configureRequested
    {105, 789, 2992},	// Plasma::Wallpaper::contextActions
    {105, 796, 2955},	// Plasma::Wallpaper::contextualActions
    {105, 806, 2943},	// Plasma::Wallpaper::createConfigurationInterface#
    {105, 840, 2948},	// Plasma::Wallpaper::dataEngine$
    {105, 977, 2990},	// Plasma::Wallpaper::findInCache$#
    {105, 978, 2973},	// Plasma::Wallpaper::findInCache$#$
    {105, 1075, 2932},	// Plasma::Wallpaper::icon
    {105, 1092, 2968},	// Plasma::Wallpaper::init#
    {105, 1103, 2974},	// Plasma::Wallpaper::insertIntoCache$#
    {105, 1136, 2937},	// Plasma::Wallpaper::isInitialized
    {105, 1146, 2956},	// Plasma::Wallpaper::isPreviewing
    {105, 1163, 2950},	// Plasma::Wallpaper::isUsingRenderingCache
    {105, 1270, 2936},	// Plasma::Wallpaper::listRenderingModes
    {105, 1276, 2980},	// Plasma::Wallpaper::listWallpaperInfo
    {105, 1277, 2924},	// Plasma::Wallpaper::listWallpaperInfo$
    {105, 1279, 2981},	// Plasma::Wallpaper::listWallpaperInfoForMimetype$
    {105, 1280, 2925},	// Plasma::Wallpaper::listWallpaperInfoForMimetype$$
    {105, 1282, 2983},	// Plasma::Wallpaper::load#
    {105, 1287, 2927},	// Plasma::Wallpaper::load#?
    {105, 1288, 2982},	// Plasma::Wallpaper::load$
    {105, 1292, 2926},	// Plasma::Wallpaper::load$?
    {105, 1351, 2915},	// Plasma::Wallpaper::metaObject
    {105, 1369, 2944},	// Plasma::Wallpaper::mouseMoveEvent#
    {105, 1371, 2945},	// Plasma::Wallpaper::mousePressEvent#
    {105, 1373, 2946},	// Plasma::Wallpaper::mouseReleaseEvent#
    {105, 1386, 2929},	// Plasma::Wallpaper::name
    {105, 1389, 2958},	// Plasma::Wallpaper::needsPreviewDuringConfiguration
    {105, 1414, 2930},	// Plasma::Wallpaper::package
    {105, 1415, 2984},	// Plasma::Wallpaper::packageStructure
    {105, 1416, 2928},	// Plasma::Wallpaper::packageStructure#
    {105, 1421, 2940},	// Plasma::Wallpaper::paint##
    {105, 1458, 2931},	// Plasma::Wallpaper::pluginName
    {105, 1486, 2921},	// Plasma::Wallpaper::qt_metacall$$?
    {105, 1488, 2916},	// Plasma::Wallpaper::qt_metacast$
    {105, 1560, 2988},	// Plasma::Wallpaper::render##
    {105, 1561, 2989},	// Plasma::Wallpaper::render##$
    {105, 1562, 2971},	// Plasma::Wallpaper::render##$#
    {105, 1563, 2986},	// Plasma::Wallpaper::render$#
    {105, 1564, 2987},	// Plasma::Wallpaper::render$#$
    {105, 1565, 2970},	// Plasma::Wallpaper::render$#$#
    {105, 1567, 2963},	// Plasma::Wallpaper::renderCompleted#
    {105, 1568, 2965},	// Plasma::Wallpaper::renderHintsChanged
    {105, 1569, 2933},	// Plasma::Wallpaper::renderingMode
    {105, 1588, 2952},	// Plasma::Wallpaper::resizeMethodHint
    {105, 1590, 2941},	// Plasma::Wallpaper::restore#
    {105, 1608, 2942},	// Plasma::Wallpaper::save#
    {105, 1703, 2939},	// Plasma::Wallpaper::setBoundingRect#
    {105, 1727, 2985},	// Plasma::Wallpaper::setConfigurationRequired$
    {105, 1728, 2969},	// Plasma::Wallpaper::setConfigurationRequired$$
    {105, 1746, 2993},	// Plasma::Wallpaper::setContextActions?
    {105, 1748, 2975},	// Plasma::Wallpaper::setContextualActions?
    {105, 1971, 2976},	// Plasma::Wallpaper::setPreviewDuringConfiguration$
    {105, 1973, 2957},	// Plasma::Wallpaper::setPreviewing$
    {105, 1987, 2935},	// Plasma::Wallpaper::setRenderingMode$
    {105, 1995, 2951},	// Plasma::Wallpaper::setResizeMethodHint$
    {105, 2075, 2953},	// Plasma::Wallpaper::setTargetSizeHint#
    {105, 2113, 2923},	// Plasma::Wallpaper::setUrls?
    {105, 2121, 2972},	// Plasma::Wallpaper::setUsingRenderingCache$
    {105, 2223, 2991},	// Plasma::Wallpaper::staticMetaObject
    {105, 2243, 2934},	// Plasma::Wallpaper::supportsMimetype$
    {105, 2270, 2954},	// Plasma::Wallpaper::targetSizeHint
    {105, 2305, 2977},	// Plasma::Wallpaper::tr$
    {105, 2306, 2917},	// Plasma::Wallpaper::tr$$
    {105, 2307, 2919},	// Plasma::Wallpaper::tr$$$
    {105, 2309, 2978},	// Plasma::Wallpaper::trUtf8$
    {105, 2310, 2918},	// Plasma::Wallpaper::trUtf8$$
    {105, 2311, 2920},	// Plasma::Wallpaper::trUtf8$$$
    {105, 2330, 2959},	// Plasma::Wallpaper::update#
    {105, 2350, 2964},	// Plasma::Wallpaper::urlDropped#
    {105, 2390, 2947},	// Plasma::Wallpaper::wheelEvent#
    {105, 2479, 3001},	// Plasma::Wallpaper::~Wallpaper
    {106, 541, 3041},	// Plasma::WallpaperScript::WallpaperScript
    {106, 542, 3009},	// Plasma::WallpaperScript::WallpaperScript#
    {106, 704, 3025},	// Plasma::WallpaperScript::boundingRect
    {106, 741, 3036},	// Plasma::WallpaperScript::configNeedsSaving
    {106, 806, 3015},	// Plasma::WallpaperScript::createConfigurationInterface#
    {106, 840, 3026},	// Plasma::WallpaperScript::dataEngine$
    {106, 849, 3023},	// Plasma::WallpaperScript::description
    {106, 977, 3045},	// Plasma::WallpaperScript::findInCache$#
    {106, 978, 3032},	// Plasma::WallpaperScript::findInCache$#$
    {106, 1097, 3012},	// Plasma::WallpaperScript::initWallpaper#
    {106, 1103, 3033},	// Plasma::WallpaperScript::insertIntoCache$#
    {106, 1136, 3024},	// Plasma::WallpaperScript::isInitialized
    {106, 1324, 3021},	// Plasma::WallpaperScript::mainScript
    {106, 1351, 3002},	// Plasma::WallpaperScript::metaObject
    {106, 1369, 3016},	// Plasma::WallpaperScript::mouseMoveEvent#
    {106, 1371, 3017},	// Plasma::WallpaperScript::mousePressEvent#
    {106, 1373, 3018},	// Plasma::WallpaperScript::mouseReleaseEvent#
    {106, 1414, 3022},	// Plasma::WallpaperScript::package
    {106, 1421, 3013},	// Plasma::WallpaperScript::paint##
    {106, 1486, 3008},	// Plasma::WallpaperScript::qt_metacall$$?
    {106, 1488, 3003},	// Plasma::WallpaperScript::qt_metacast$
    {106, 1563, 3043},	// Plasma::WallpaperScript::render$#
    {106, 1564, 3044},	// Plasma::WallpaperScript::render$#$
    {106, 1565, 3030},	// Plasma::WallpaperScript::render$#$#
    {106, 1567, 3037},	// Plasma::WallpaperScript::renderCompleted#
    {106, 1608, 3014},	// Plasma::WallpaperScript::save#
    {106, 1727, 3042},	// Plasma::WallpaperScript::setConfigurationRequired$
    {106, 1728, 3029},	// Plasma::WallpaperScript::setConfigurationRequired$$
    {106, 1748, 3034},	// Plasma::WallpaperScript::setContextualActions?
    {106, 1995, 3027},	// Plasma::WallpaperScript::setResizeMethodHint$
    {106, 2075, 3028},	// Plasma::WallpaperScript::setTargetSizeHint#
    {106, 2113, 3020},	// Plasma::WallpaperScript::setUrls?
    {106, 2121, 3031},	// Plasma::WallpaperScript::setUsingRenderingCache$
    {106, 2142, 3010},	// Plasma::WallpaperScript::setWallpaper#
    {106, 2223, 3046},	// Plasma::WallpaperScript::staticMetaObject
    {106, 2305, 3039},	// Plasma::WallpaperScript::tr$
    {106, 2306, 3004},	// Plasma::WallpaperScript::tr$$
    {106, 2307, 3006},	// Plasma::WallpaperScript::tr$$$
    {106, 2309, 3040},	// Plasma::WallpaperScript::trUtf8$
    {106, 2310, 3005},	// Plasma::WallpaperScript::trUtf8$$
    {106, 2311, 3007},	// Plasma::WallpaperScript::trUtf8$$$
    {106, 2330, 3035},	// Plasma::WallpaperScript::update#
    {106, 2350, 3038},	// Plasma::WallpaperScript::urlDropped#
    {106, 2385, 3011},	// Plasma::WallpaperScript::wallpaper
    {106, 2390, 3019},	// Plasma::WallpaperScript::wheelEvent#
    {106, 2480, 3047},	// Plasma::WallpaperScript::~WallpaperScript
    {107, 544, 3101},	// Plasma::WebView::WebView
    {107, 545, 3055},	// Plasma::WebView::WebView#
    {107, 695, 3074},	// Plasma::WebView::back
    {107, 787, 3062},	// Plasma::WebView::contentsSize
    {107, 795, 3087},	// Plasma::WebView::contextMenuEvent#
    {107, 877, 3093},	// Plasma::WebView::dragEnterEvent#
    {107, 879, 3094},	// Plasma::WebView::dragLeaveEvent#
    {107, 881, 3095},	// Plasma::WebView::dragMoveEvent#
    {107, 882, 3072},	// Plasma::WebView::dragToScroll
    {107, 907, 3096},	// Plasma::WebView::dropEvent#
    {107, 999, 3091},	// Plasma::WebView::focusInEvent#
    {107, 1003, 3092},	// Plasma::WebView::focusOutEvent#
    {107, 1013, 3075},	// Plasma::WebView::forward
    {107, 1019, 3061},	// Plasma::WebView::geometry
    {107, 1073, 3083},	// Plasma::WebView::hoverMoveEvent#
    {107, 1074, 3059},	// Plasma::WebView::html
    {107, 1180, 3097},	// Plasma::WebView::itemChange$#
    {107, 1199, 3089},	// Plasma::WebView::keyPressEvent#
    {107, 1201, 3090},	// Plasma::WebView::keyReleaseEvent#
    {107, 1300, 3079},	// Plasma::WebView::loadFinished$
    {107, 1308, 3078},	// Plasma::WebView::loadProgress$
    {107, 1323, 3070},	// Plasma::WebView::mainFrame
    {107, 1351, 3048},	// Plasma::WebView::metaObject
    {107, 1367, 3085},	// Plasma::WebView::mouseDoubleClickEvent#
    {107, 1369, 3082},	// Plasma::WebView::mouseMoveEvent#
    {107, 1371, 3084},	// Plasma::WebView::mousePressEvent#
    {107, 1373, 3086},	// Plasma::WebView::mouseReleaseEvent#
    {107, 1418, 3069},	// Plasma::WebView::page
    {107, 1421, 3104},	// Plasma::WebView::paint##
    {107, 1422, 3081},	// Plasma::WebView::paint###
    {107, 1486, 3054},	// Plasma::WebView::qt_metacall$$?
    {107, 1488, 3049},	// Plasma::WebView::qt_metacast$
    {107, 1518, 3076},	// Plasma::WebView::reload
    {107, 1635, 3064},	// Plasma::WebView::scrollPosition
    {107, 1788, 3071},	// Plasma::WebView::setDragToScroll$
    {107, 1829, 3073},	// Plasma::WebView::setGeometry#
    {107, 1854, 3102},	// Plasma::WebView::setHtml#
    {107, 1855, 3058},	// Plasma::WebView::setHtml##
    {107, 1856, 3103},	// Plasma::WebView::setHtml$
    {107, 1857, 3060},	// Plasma::WebView::setHtml$#
    {107, 1942, 3068},	// Plasma::WebView::setPage#
    {107, 2008, 3063},	// Plasma::WebView::setScrollPosition#
    {107, 2110, 3056},	// Plasma::WebView::setUrl#
    {107, 2158, 3067},	// Plasma::WebView::setZoomFactor$
    {107, 2201, 3098},	// Plasma::WebView::sizeHint$#
    {107, 2223, 3105},	// Plasma::WebView::staticMetaObject
    {107, 2225, 3077},	// Plasma::WebView::stop
    {107, 2305, 3099},	// Plasma::WebView::tr$
    {107, 2306, 3050},	// Plasma::WebView::tr$$
    {107, 2307, 3052},	// Plasma::WebView::tr$$$
    {107, 2309, 3100},	// Plasma::WebView::trUtf8$
    {107, 2310, 3051},	// Plasma::WebView::trUtf8$$
    {107, 2311, 3053},	// Plasma::WebView::trUtf8$$$
    {107, 2346, 3057},	// Plasma::WebView::url
    {107, 2348, 3080},	// Plasma::WebView::urlChanged#
    {107, 2378, 3065},	// Plasma::WebView::viewportGeometry
    {107, 2390, 3088},	// Plasma::WebView::wheelEvent#
    {107, 2406, 3066},	// Plasma::WebView::zoomFactor
    {107, 2481, 3106},	// Plasma::WebView::~WebView
};

}

extern "C" {

SMOKE_IMPORT void init_kdecore_Smoke();
SMOKE_IMPORT void init_kdeui_Smoke();

static bool initialized = false;
Smoke *plasma_Smoke = 0;

// Create the Smoke instance encapsulating all the above.
void init_plasma_Smoke() {
    init_kdecore_Smoke();
    init_kdeui_Smoke();
    if (initialized) return;
    plasma_Smoke = new Smoke(
        "plasma",
        __smokeplasma::classes, 198,
        __smokeplasma::methods, 3335,
        __smokeplasma::methodMaps, 3061,
        __smokeplasma::methodNames, 2481,
        __smokeplasma::types, 488,
        __smokeplasma::inheritanceList,
        __smokeplasma::argumentList,
        __smokeplasma::ambiguousMethodList,
        __smokeplasma::cast );
    initialized = true;
}

void delete_plasma_Smoke() { delete plasma_Smoke; }

}
