#include <kutils_includes.h>

#include <smoke.h>
#include <kutils_smoke.h>

namespace __smokekutils {

static void *cast(void *xptr, Smoke::Index from, Smoke::Index to) {
  switch(from) {
    case 1:   //Emoticon
      switch(to) {
        case 1: return (void*)(Emoticon*)xptr;
        default: return xptr;
      }
    case 2:   //KAboutData
      switch(to) {
        case 2: return (void*)(KAboutData*)xptr;
        default: return xptr;
      }
    case 3:   //KCModule
      switch(to) {
        case 96: return (void*)(QWidget*)(KCModule*)xptr;
        case 65: return (void*)(QObject*)(KCModule*)xptr;
        case 3: return (void*)(KCModule*)xptr;
        case 4: return (void*)(KCModuleContainer*)(KCModule*)xptr;
        case 25: return (void*)(KSettings::PluginPage*)(KCModule*)xptr;
        default: return xptr;
      }
    case 4:   //KCModuleContainer
      switch(to) {
        case 3: return (void*)(KCModule*)(KCModuleContainer*)xptr;
        case 96: return (void*)(QWidget*)(KCModuleContainer*)xptr;
        case 65: return (void*)(QObject*)(KCModuleContainer*)xptr;
        case 4: return (void*)(KCModuleContainer*)xptr;
        default: return xptr;
      }
    case 5:   //KCModuleInfo
      switch(to) {
        case 5: return (void*)(KCModuleInfo*)xptr;
        default: return xptr;
      }
    case 6:   //KCModuleProxy
      switch(to) {
        case 96: return (void*)(QWidget*)(KCModuleProxy*)xptr;
        case 65: return (void*)(QObject*)(KCModuleProxy*)xptr;
        case 6: return (void*)(KCModuleProxy*)xptr;
        default: return xptr;
      }
    case 7:   //KCMultiDialog
      switch(to) {
        case 16: return (void*)(KPageDialog*)(KCMultiDialog*)xptr;
        case 10: return (void*)(KDialog*)(KCMultiDialog*)xptr;
        case 40: return (void*)(QDialog*)(KCMultiDialog*)xptr;
        case 96: return (void*)(QWidget*)(KCMultiDialog*)xptr;
        case 65: return (void*)(QObject*)(KCMultiDialog*)xptr;
        case 7: return (void*)(KCMultiDialog*)xptr;
        case 24: return (void*)(KSettings::Dialog*)(KCMultiDialog*)xptr;
        default: return xptr;
      }
    case 8:   //KCMultiDialogPrivate
      switch(to) {
        case 8: return (void*)(KCMultiDialogPrivate*)xptr;
        default: return xptr;
      }
    case 9:   //KComponentData
      switch(to) {
        case 9: return (void*)(KComponentData*)xptr;
        default: return xptr;
      }
    case 10:   //KDialog
      switch(to) {
        case 40: return (void*)(QDialog*)(KDialog*)xptr;
        case 96: return (void*)(QWidget*)(KDialog*)xptr;
        case 65: return (void*)(QObject*)(KDialog*)xptr;
        case 10: return (void*)(KDialog*)xptr;
        case 21: return (void*)(KPrintPreview*)(KDialog*)xptr;
        case 7: return (void*)(KCMultiDialog*)(KDialog*)xptr;
        case 24: return (void*)(KSettings::Dialog*)(KDialog*)xptr;
        default: return xptr;
      }
    case 11:   //KEmoticons
      switch(to) {
        case 65: return (void*)(QObject*)(KEmoticons*)xptr;
        case 11: return (void*)(KEmoticons*)xptr;
        default: return xptr;
      }
    case 12:   //KEmoticonsProvider
      switch(to) {
        case 65: return (void*)(QObject*)(KEmoticonsProvider*)xptr;
        case 12: return (void*)(KEmoticonsProvider*)xptr;
        default: return xptr;
      }
    case 13:   //KEmoticonsTheme
      switch(to) {
        case 13: return (void*)(KEmoticonsTheme*)xptr;
        default: return xptr;
      }
    case 14:   //KIdleTime
      switch(to) {
        case 65: return (void*)(QObject*)(KIdleTime*)xptr;
        case 14: return (void*)(KIdleTime*)xptr;
        default: return xptr;
      }
    case 15:   //KLocalizedString
      switch(to) {
        case 15: return (void*)(KLocalizedString*)xptr;
        default: return xptr;
      }
    case 16:   //KPageDialog
      switch(to) {
        case 10: return (void*)(KDialog*)(KPageDialog*)xptr;
        case 40: return (void*)(QDialog*)(KPageDialog*)xptr;
        case 96: return (void*)(QWidget*)(KPageDialog*)xptr;
        case 65: return (void*)(QObject*)(KPageDialog*)xptr;
        case 16: return (void*)(KPageDialog*)xptr;
        case 7: return (void*)(KCMultiDialog*)(KPageDialog*)xptr;
        case 24: return (void*)(KSettings::Dialog*)(KPageDialog*)xptr;
        default: return xptr;
      }
    case 17:   //KPageWidget
      switch(to) {
        case 96: return (void*)(QWidget*)(KPageWidget*)xptr;
        case 65: return (void*)(QObject*)(KPageWidget*)xptr;
        case 17: return (void*)(KPageWidget*)xptr;
        default: return xptr;
      }
    case 18:   //KPageWidgetItem
      switch(to) {
        case 65: return (void*)(QObject*)(KPageWidgetItem*)xptr;
        case 18: return (void*)(KPageWidgetItem*)xptr;
        default: return xptr;
      }
    case 19:   //KPluginInfo
      switch(to) {
        case 19: return (void*)(KPluginInfo*)xptr;
        default: return xptr;
      }
    case 20:   //KPluginSelector
      switch(to) {
        case 96: return (void*)(QWidget*)(KPluginSelector*)xptr;
        case 65: return (void*)(QObject*)(KPluginSelector*)xptr;
        case 20: return (void*)(KPluginSelector*)xptr;
        default: return xptr;
      }
    case 21:   //KPrintPreview
      switch(to) {
        case 10: return (void*)(KDialog*)(KPrintPreview*)xptr;
        case 40: return (void*)(QDialog*)(KPrintPreview*)xptr;
        case 96: return (void*)(QWidget*)(KPrintPreview*)xptr;
        case 65: return (void*)(QObject*)(KPrintPreview*)xptr;
        case 21: return (void*)(KPrintPreview*)xptr;
        default: return xptr;
      }
    case 22:   //KService
      switch(to) {
        case 22: return (void*)(KService*)xptr;
        default: return xptr;
      }
    case 23:   //KServiceAction
      switch(to) {
        case 23: return (void*)(KServiceAction*)xptr;
        default: return xptr;
      }
    case 24:   //KSettings::Dialog
      switch(to) {
        case 7: return (void*)(KCMultiDialog*)(KSettings::Dialog*)xptr;
        case 16: return (void*)(KPageDialog*)(KSettings::Dialog*)xptr;
        case 10: return (void*)(KDialog*)(KSettings::Dialog*)xptr;
        case 40: return (void*)(QDialog*)(KSettings::Dialog*)xptr;
        case 96: return (void*)(QWidget*)(KSettings::Dialog*)xptr;
        case 65: return (void*)(QObject*)(KSettings::Dialog*)xptr;
        case 24: return (void*)(KSettings::Dialog*)xptr;
        default: return xptr;
      }
    case 25:   //KSettings::PluginPage
      switch(to) {
        case 3: return (void*)(KCModule*)(KSettings::PluginPage*)xptr;
        case 96: return (void*)(QWidget*)(KSettings::PluginPage*)xptr;
        case 65: return (void*)(QObject*)(KSettings::PluginPage*)xptr;
        case 25: return (void*)(KSettings::PluginPage*)xptr;
        default: return xptr;
      }
    case 26:   //KSharedConfig
      switch(to) {
        case 26: return (void*)(KSharedConfig*)xptr;
        default: return xptr;
      }
    case 27:   //QActionEvent
      switch(to) {
        case 27: return (void*)(QActionEvent*)xptr;
        default: return xptr;
      }
    case 28:   //QBool
      switch(to) {
        case 28: return (void*)(QBool*)xptr;
        default: return xptr;
      }
    case 29:   //QBrush
      switch(to) {
        case 29: return (void*)(QBrush*)xptr;
        default: return xptr;
      }
    case 30:   //QByteArray
      switch(to) {
        case 30: return (void*)(QByteArray*)xptr;
        default: return xptr;
      }
    case 31:   //QChar
      switch(to) {
        case 31: return (void*)(QChar*)xptr;
        default: return xptr;
      }
    case 32:   //QChildEvent
      switch(to) {
        case 32: return (void*)(QChildEvent*)xptr;
        default: return xptr;
      }
    case 33:   //QCloseEvent
      switch(to) {
        case 33: return (void*)(QCloseEvent*)xptr;
        default: return xptr;
      }
    case 34:   //QColor
      switch(to) {
        case 34: return (void*)(QColor*)xptr;
        default: return xptr;
      }
    case 35:   //QContextMenuEvent
      switch(to) {
        case 35: return (void*)(QContextMenuEvent*)xptr;
        default: return xptr;
      }
    case 36:   //QCursor
      switch(to) {
        case 36: return (void*)(QCursor*)xptr;
        default: return xptr;
      }
    case 37:   //QDataStream
      switch(to) {
        case 37: return (void*)(QDataStream*)xptr;
        default: return xptr;
      }
    case 38:   //QDate
      switch(to) {
        case 38: return (void*)(QDate*)xptr;
        default: return xptr;
      }
    case 39:   //QDateTime
      switch(to) {
        case 39: return (void*)(QDateTime*)xptr;
        default: return xptr;
      }
    case 40:   //QDialog
      switch(to) {
        case 96: return (void*)(QWidget*)(QDialog*)xptr;
        case 65: return (void*)(QObject*)(QDialog*)xptr;
        case 40: return (void*)(QDialog*)xptr;
        case 21: return (void*)(KPrintPreview*)(QDialog*)xptr;
        case 7: return (void*)(KCMultiDialog*)(QDialog*)xptr;
        case 24: return (void*)(KSettings::Dialog*)(QDialog*)xptr;
        default: return xptr;
      }
    case 41:   //QDragEnterEvent
      switch(to) {
        case 41: return (void*)(QDragEnterEvent*)xptr;
        default: return xptr;
      }
    case 42:   //QDragLeaveEvent
      switch(to) {
        case 42: return (void*)(QDragLeaveEvent*)xptr;
        default: return xptr;
      }
    case 43:   //QDragMoveEvent
      switch(to) {
        case 43: return (void*)(QDragMoveEvent*)xptr;
        default: return xptr;
      }
    case 44:   //QDropEvent
      switch(to) {
        case 44: return (void*)(QDropEvent*)xptr;
        default: return xptr;
      }
    case 45:   //QEvent
      switch(to) {
        case 45: return (void*)(QEvent*)xptr;
        default: return xptr;
      }
    case 46:   //QFocusEvent
      switch(to) {
        case 46: return (void*)(QFocusEvent*)xptr;
        default: return xptr;
      }
    case 47:   //QFont
      switch(to) {
        case 47: return (void*)(QFont*)xptr;
        default: return xptr;
      }
    case 49:   //QHashDummyValue
      switch(to) {
        case 49: return (void*)(QHashDummyValue*)xptr;
        default: return xptr;
      }
    case 50:   //QHideEvent
      switch(to) {
        case 50: return (void*)(QHideEvent*)xptr;
        default: return xptr;
      }
    case 51:   //QIcon
      switch(to) {
        case 51: return (void*)(QIcon*)xptr;
        default: return xptr;
      }
    case 52:   //QImage
      switch(to) {
        case 52: return (void*)(QImage*)xptr;
        default: return xptr;
      }
    case 53:   //QIncompatibleFlag
      switch(to) {
        case 53: return (void*)(QIncompatibleFlag*)xptr;
        default: return xptr;
      }
    case 54:   //QInputMethodEvent
      switch(to) {
        case 54: return (void*)(QInputMethodEvent*)xptr;
        default: return xptr;
      }
    case 55:   //QKeyEvent
      switch(to) {
        case 55: return (void*)(QKeyEvent*)xptr;
        default: return xptr;
      }
    case 56:   //QKeySequence
      switch(to) {
        case 56: return (void*)(QKeySequence*)xptr;
        default: return xptr;
      }
    case 57:   //QLatin1String
      switch(to) {
        case 57: return (void*)(QLatin1String*)xptr;
        default: return xptr;
      }
    case 58:   //QLine
      switch(to) {
        case 58: return (void*)(QLine*)xptr;
        default: return xptr;
      }
    case 59:   //QLineF
      switch(to) {
        case 59: return (void*)(QLineF*)xptr;
        default: return xptr;
      }
    case 60:   //QMargins
      switch(to) {
        case 60: return (void*)(QMargins*)xptr;
        default: return xptr;
      }
    case 61:   //QMatrix
      switch(to) {
        case 61: return (void*)(QMatrix*)xptr;
        default: return xptr;
      }
    case 62:   //QMetaObject
      switch(to) {
        case 62: return (void*)(QMetaObject*)xptr;
        default: return xptr;
      }
    case 63:   //QMouseEvent
      switch(to) {
        case 63: return (void*)(QMouseEvent*)xptr;
        default: return xptr;
      }
    case 64:   //QMoveEvent
      switch(to) {
        case 64: return (void*)(QMoveEvent*)xptr;
        default: return xptr;
      }
    case 65:   //QObject
      switch(to) {
        case 65: return (void*)(QObject*)xptr;
        case 14: return (void*)(KIdleTime*)(QObject*)xptr;
        case 21: return (void*)(KPrintPreview*)(QObject*)xptr;
        case 7: return (void*)(KCMultiDialog*)(QObject*)xptr;
        case 24: return (void*)(KSettings::Dialog*)(QObject*)xptr;
        case 6: return (void*)(KCModuleProxy*)(QObject*)xptr;
        case 12: return (void*)(KEmoticonsProvider*)(QObject*)xptr;
        case 4: return (void*)(KCModuleContainer*)(QObject*)xptr;
        case 11: return (void*)(KEmoticons*)(QObject*)xptr;
        case 25: return (void*)(KSettings::PluginPage*)(QObject*)xptr;
        case 20: return (void*)(KPluginSelector*)(QObject*)xptr;
        default: return xptr;
      }
    case 66:   //QPaintEngine
      switch(to) {
        case 66: return (void*)(QPaintEngine*)xptr;
        default: return xptr;
      }
    case 67:   //QPaintEvent
      switch(to) {
        case 67: return (void*)(QPaintEvent*)xptr;
        default: return xptr;
      }
    case 68:   //QPainterPath
      switch(to) {
        case 68: return (void*)(QPainterPath*)xptr;
        default: return xptr;
      }
    case 69:   //QPalette
      switch(to) {
        case 69: return (void*)(QPalette*)xptr;
        default: return xptr;
      }
    case 70:   //QPixmap
      switch(to) {
        case 70: return (void*)(QPixmap*)xptr;
        default: return xptr;
      }
    case 71:   //QPoint
      switch(to) {
        case 71: return (void*)(QPoint*)xptr;
        default: return xptr;
      }
    case 72:   //QPointF
      switch(to) {
        case 72: return (void*)(QPointF*)xptr;
        default: return xptr;
      }
    case 73:   //QPolygon
      switch(to) {
        case 73: return (void*)(QPolygon*)xptr;
        default: return xptr;
      }
    case 74:   //QPolygonF
      switch(to) {
        case 74: return (void*)(QPolygonF*)xptr;
        default: return xptr;
      }
    case 75:   //QPrinter
      switch(to) {
        case 75: return (void*)(QPrinter*)xptr;
        default: return xptr;
      }
    case 76:   //QRect
      switch(to) {
        case 76: return (void*)(QRect*)xptr;
        default: return xptr;
      }
    case 77:   //QRectF
      switch(to) {
        case 77: return (void*)(QRectF*)xptr;
        default: return xptr;
      }
    case 78:   //QRegExp
      switch(to) {
        case 78: return (void*)(QRegExp*)xptr;
        default: return xptr;
      }
    case 79:   //QRegion
      switch(to) {
        case 79: return (void*)(QRegion*)xptr;
        default: return xptr;
      }
    case 80:   //QResizeEvent
      switch(to) {
        case 80: return (void*)(QResizeEvent*)xptr;
        default: return xptr;
      }
    case 81:   //QShowEvent
      switch(to) {
        case 81: return (void*)(QShowEvent*)xptr;
        default: return xptr;
      }
    case 82:   //QSize
      switch(to) {
        case 82: return (void*)(QSize*)xptr;
        default: return xptr;
      }
    case 83:   //QSizeF
      switch(to) {
        case 83: return (void*)(QSizeF*)xptr;
        default: return xptr;
      }
    case 84:   //QSizePolicy
      switch(to) {
        case 84: return (void*)(QSizePolicy*)xptr;
        default: return xptr;
      }
    case 85:   //QString::Null
      switch(to) {
        case 85: return (void*)(QString::Null*)xptr;
        default: return xptr;
      }
    case 86:   //QStringRef
      switch(to) {
        case 86: return (void*)(QStringRef*)xptr;
        default: return xptr;
      }
    case 87:   //QStyle
      switch(to) {
        case 87: return (void*)(QStyle*)xptr;
        default: return xptr;
      }
    case 88:   //QTabletEvent
      switch(to) {
        case 88: return (void*)(QTabletEvent*)xptr;
        default: return xptr;
      }
    case 89:   //QTime
      switch(to) {
        case 89: return (void*)(QTime*)xptr;
        default: return xptr;
      }
    case 90:   //QTimerEvent
      switch(to) {
        case 90: return (void*)(QTimerEvent*)xptr;
        default: return xptr;
      }
    case 91:   //QTransform
      switch(to) {
        case 91: return (void*)(QTransform*)xptr;
        default: return xptr;
      }
    case 92:   //QUrl
      switch(to) {
        case 92: return (void*)(QUrl*)xptr;
        default: return xptr;
      }
    case 93:   //QVariant
      switch(to) {
        case 93: return (void*)(QVariant*)xptr;
        default: return xptr;
      }
    case 94:   //QVariantComparisonHelper
      switch(to) {
        case 94: return (void*)(QVariantComparisonHelper*)xptr;
        default: return xptr;
      }
    case 95:   //QWheelEvent
      switch(to) {
        case 95: return (void*)(QWheelEvent*)xptr;
        default: return xptr;
      }
    case 96:   //QWidget
      switch(to) {
        case 65: return (void*)(QObject*)(QWidget*)xptr;
        case 96: return (void*)(QWidget*)xptr;
        case 21: return (void*)(KPrintPreview*)(QWidget*)xptr;
        case 7: return (void*)(KCMultiDialog*)(QWidget*)xptr;
        case 24: return (void*)(KSettings::Dialog*)(QWidget*)xptr;
        case 6: return (void*)(KCModuleProxy*)(QWidget*)xptr;
        case 4: return (void*)(KCModuleContainer*)(QWidget*)xptr;
        case 25: return (void*)(KSettings::PluginPage*)(QWidget*)xptr;
        case 20: return (void*)(KPluginSelector*)(QWidget*)xptr;
        default: return xptr;
      }
    default: return xptr;
  }
}

// Group of Indexes (0 separated) used as super class lists.
// Classes with super classes have an index into this array.
static Smoke::Index inheritanceList[] = {
    0,	// 0: (no super class)
    3, 0,	// 1: KCModule
    96, 0,	// 3: QWidget
    16, 0,	// 5: KPageDialog
    65, 0,	// 7: QObject
    10, 0,	// 9: KDialog
    7, 0,	// 11: KCMultiDialog
};

// These are the xenum functions for manipulating enum pointers
void xenum_KEmoticonsProvider(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QGlobalSpace(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KPluginSelector(Smoke::EnumOperation, Smoke::Index, void*&, long&);

// Those are the xcall functions defined in each x_*.cpp file, for dispatching method calls
void xcall_KCModuleContainer(Smoke::Index, void*, Smoke::Stack);
void xcall_KCModuleProxy(Smoke::Index, void*, Smoke::Stack);
void xcall_KCMultiDialog(Smoke::Index, void*, Smoke::Stack);
void xcall_KEmoticons(Smoke::Index, void*, Smoke::Stack);
void xcall_KEmoticonsProvider(Smoke::Index, void*, Smoke::Stack);
void xcall_KIdleTime(Smoke::Index, void*, Smoke::Stack);
void xcall_KPluginSelector(Smoke::Index, void*, Smoke::Stack);
void xcall_KPrintPreview(Smoke::Index, void*, Smoke::Stack);
void xcall_KSettings__Dialog(Smoke::Index, void*, Smoke::Stack);
void xcall_KSettings__PluginPage(Smoke::Index, void*, Smoke::Stack);
void xcall_QGlobalSpace(Smoke::Index, void*, Smoke::Stack);

// List of all classes
// Name, external, index into inheritanceList, method dispatcher, enum dispatcher, class flags, size
static Smoke::Class classes[] = {
    { 0L, false, 0, 0, 0, 0, 0 },	// 0 (no class)
    { "Emoticon", true, 0, 0, 0, 0, 0 },	//1
    { "KAboutData", true, 0, 0, 0, 0, 0 },	//2
    { "KCModule", true, 0, 0, 0, 0, 0 },	//3
    { "KCModuleContainer", false, 1, xcall_KCModuleContainer, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KCModuleContainer) },	//4
    { "KCModuleInfo", true, 0, 0, 0, 0, 0 },	//5
    { "KCModuleProxy", false, 3, xcall_KCModuleProxy, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KCModuleProxy) },	//6
    { "KCMultiDialog", false, 5, xcall_KCMultiDialog, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KCMultiDialog) },	//7
    { "KCMultiDialogPrivate", true, 0, 0, 0, 0, 0 },	//8
    { "KComponentData", true, 0, 0, 0, 0, 0 },	//9
    { "KDialog", true, 0, 0, 0, 0, 0 },	//10
    { "KEmoticons", false, 7, xcall_KEmoticons, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KEmoticons) },	//11
    { "KEmoticonsProvider", false, 7, xcall_KEmoticonsProvider, xenum_KEmoticonsProvider, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KEmoticonsProvider) },	//12
    { "KEmoticonsTheme", true, 0, 0, 0, 0, 0 },	//13
    { "KIdleTime", false, 7, xcall_KIdleTime, 0, Smoke::cf_virtual, sizeof(KIdleTime) },	//14
    { "KLocalizedString", true, 0, 0, 0, 0, 0 },	//15
    { "KPageDialog", true, 0, 0, 0, 0, 0 },	//16
    { "KPageWidget", true, 0, 0, 0, 0, 0 },	//17
    { "KPageWidgetItem", true, 0, 0, 0, 0, 0 },	//18
    { "KPluginInfo", true, 0, 0, 0, 0, 0 },	//19
    { "KPluginSelector", false, 3, xcall_KPluginSelector, xenum_KPluginSelector, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KPluginSelector) },	//20
    { "KPrintPreview", false, 9, xcall_KPrintPreview, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KPrintPreview) },	//21
    { "KService", true, 0, 0, 0, 0, 0 },	//22
    { "KServiceAction", true, 0, 0, 0, 0, 0 },	//23
    { "KSettings::Dialog", false, 11, xcall_KSettings__Dialog, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KSettings::Dialog) },	//24
    { "KSettings::PluginPage", false, 1, xcall_KSettings__PluginPage, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KSettings::PluginPage) },	//25
    { "KSharedConfig", true, 0, 0, 0, 0, 0 },	//26
    { "QActionEvent", true, 0, 0, 0, 0, 0 },	//27
    { "QBool", true, 0, 0, 0, 0, 0 },	//28
    { "QBrush", true, 0, 0, 0, 0, 0 },	//29
    { "QByteArray", true, 0, 0, 0, 0, 0 },	//30
    { "QChar", true, 0, 0, 0, 0, 0 },	//31
    { "QChildEvent", true, 0, 0, 0, 0, 0 },	//32
    { "QCloseEvent", true, 0, 0, 0, 0, 0 },	//33
    { "QColor", true, 0, 0, 0, 0, 0 },	//34
    { "QContextMenuEvent", true, 0, 0, 0, 0, 0 },	//35
    { "QCursor", true, 0, 0, 0, 0, 0 },	//36
    { "QDataStream", true, 0, 0, 0, 0, 0 },	//37
    { "QDate", true, 0, 0, 0, 0, 0 },	//38
    { "QDateTime", true, 0, 0, 0, 0, 0 },	//39
    { "QDialog", true, 0, 0, 0, 0, 0 },	//40
    { "QDragEnterEvent", true, 0, 0, 0, 0, 0 },	//41
    { "QDragLeaveEvent", true, 0, 0, 0, 0, 0 },	//42
    { "QDragMoveEvent", true, 0, 0, 0, 0, 0 },	//43
    { "QDropEvent", true, 0, 0, 0, 0, 0 },	//44
    { "QEvent", true, 0, 0, 0, 0, 0 },	//45
    { "QFocusEvent", true, 0, 0, 0, 0, 0 },	//46
    { "QFont", true, 0, 0, 0, 0, 0 },	//47
    { "QGlobalSpace", false, 0, xcall_QGlobalSpace, xenum_QGlobalSpace, Smoke::cf_namespace, 0 },	//48
    { "QHashDummyValue", true, 0, 0, 0, 0, 0 },	//49
    { "QHideEvent", true, 0, 0, 0, 0, 0 },	//50
    { "QIcon", true, 0, 0, 0, 0, 0 },	//51
    { "QImage", true, 0, 0, 0, 0, 0 },	//52
    { "QIncompatibleFlag", true, 0, 0, 0, 0, 0 },	//53
    { "QInputMethodEvent", true, 0, 0, 0, 0, 0 },	//54
    { "QKeyEvent", true, 0, 0, 0, 0, 0 },	//55
    { "QKeySequence", true, 0, 0, 0, 0, 0 },	//56
    { "QLatin1String", true, 0, 0, 0, 0, 0 },	//57
    { "QLine", true, 0, 0, 0, 0, 0 },	//58
    { "QLineF", true, 0, 0, 0, 0, 0 },	//59
    { "QMargins", true, 0, 0, 0, 0, 0 },	//60
    { "QMatrix", true, 0, 0, 0, 0, 0 },	//61
    { "QMetaObject", true, 0, 0, 0, 0, 0 },	//62
    { "QMouseEvent", true, 0, 0, 0, 0, 0 },	//63
    { "QMoveEvent", true, 0, 0, 0, 0, 0 },	//64
    { "QObject", true, 0, 0, 0, 0, 0 },	//65
    { "QPaintEngine", true, 0, 0, 0, 0, 0 },	//66
    { "QPaintEvent", true, 0, 0, 0, 0, 0 },	//67
    { "QPainterPath", true, 0, 0, 0, 0, 0 },	//68
    { "QPalette", true, 0, 0, 0, 0, 0 },	//69
    { "QPixmap", true, 0, 0, 0, 0, 0 },	//70
    { "QPoint", true, 0, 0, 0, 0, 0 },	//71
    { "QPointF", true, 0, 0, 0, 0, 0 },	//72
    { "QPolygon", true, 0, 0, 0, 0, 0 },	//73
    { "QPolygonF", true, 0, 0, 0, 0, 0 },	//74
    { "QPrinter", true, 0, 0, 0, 0, 0 },	//75
    { "QRect", true, 0, 0, 0, 0, 0 },	//76
    { "QRectF", true, 0, 0, 0, 0, 0 },	//77
    { "QRegExp", true, 0, 0, 0, 0, 0 },	//78
    { "QRegion", true, 0, 0, 0, 0, 0 },	//79
    { "QResizeEvent", true, 0, 0, 0, 0, 0 },	//80
    { "QShowEvent", true, 0, 0, 0, 0, 0 },	//81
    { "QSize", true, 0, 0, 0, 0, 0 },	//82
    { "QSizeF", true, 0, 0, 0, 0, 0 },	//83
    { "QSizePolicy", true, 0, 0, 0, 0, 0 },	//84
    { "QString::Null", true, 0, 0, 0, 0, 0 },	//85
    { "QStringRef", true, 0, 0, 0, 0, 0 },	//86
    { "QStyle", true, 0, 0, 0, 0, 0 },	//87
    { "QTabletEvent", true, 0, 0, 0, 0, 0 },	//88
    { "QTime", true, 0, 0, 0, 0, 0 },	//89
    { "QTimerEvent", true, 0, 0, 0, 0, 0 },	//90
    { "QTransform", true, 0, 0, 0, 0, 0 },	//91
    { "QUrl", true, 0, 0, 0, 0, 0 },	//92
    { "QVariant", true, 0, 0, 0, 0, 0 },	//93
    { "QVariantComparisonHelper", true, 0, 0, 0, 0, 0 },	//94
    { "QWheelEvent", true, 0, 0, 0, 0, 0 },	//95
    { "QWidget", true, 0, 0, 0, 0, 0 },	//96
};

// List of all types needed by the methods (arguments and return values)
// Name, class ID if arg is a class, and TypeId
static Smoke::Type types[] = {
    { 0, 0, 0 },	//0 (no type)
    { "Emoticon", 1, Smoke::t_class|Smoke::tf_stack },	//1
    { "KCModule*", 3, Smoke::t_class|Smoke::tf_ptr },	//2
    { "KCModule::Button", 3, Smoke::t_enum|Smoke::tf_stack },	//3
    { "KCModuleContainer*", 4, Smoke::t_class|Smoke::tf_ptr },	//4
    { "KCModuleInfo", 5, Smoke::t_class|Smoke::tf_stack },	//5
    { "KCModuleLoader::ErrorReporting", 0, Smoke::t_enum|Smoke::tf_stack },	//6
    { "KCModuleProxy*", 6, Smoke::t_class|Smoke::tf_ptr },	//7
    { "KCMultiDialog*", 7, Smoke::t_class|Smoke::tf_ptr },	//8
    { "KCMultiDialogPrivate&", 8, Smoke::t_class|Smoke::tf_ref },	//9
    { "KComponentData", 9, Smoke::t_class|Smoke::tf_stack },	//10
    { "KConfig::OpenFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//11
    { "KConfigBase::WriteConfigFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//12
    { "KDialog::ButtonCode", 10, Smoke::t_enum|Smoke::tf_stack },	//13
    { "KDialog::CaptionFlag", 10, Smoke::t_enum|Smoke::tf_stack },	//14
    { "KEmoticons*", 11, Smoke::t_class|Smoke::tf_ptr },	//15
    { "KEmoticonsProvider*", 12, Smoke::t_class|Smoke::tf_ptr },	//16
    { "KEmoticonsProvider::AddEmoticonOption", 12, Smoke::t_enum|Smoke::tf_stack },	//17
    { "KEmoticonsTheme", 13, Smoke::t_class|Smoke::tf_stack },	//18
    { "KEmoticonsTheme::ParseModeEnum", 13, Smoke::t_enum|Smoke::tf_stack },	//19
    { "KGlobal::CopyCatalogs", 0, Smoke::t_enum|Smoke::tf_stack },	//20
    { "KIconLoader::Group", 0, Smoke::t_enum|Smoke::tf_stack },	//21
    { "KIconLoader::Group&", 0, Smoke::t_enum|Smoke::tf_ref },	//22
    { "KIdleTime*", 14, Smoke::t_class|Smoke::tf_ptr },	//23
    { "KLocale::DateTimeComponent", 0, Smoke::t_enum|Smoke::tf_stack },	//24
    { "KLocale::DateTimeFormatOption", 0, Smoke::t_enum|Smoke::tf_stack },	//25
    { "KLocale::TimeFormatOption", 0, Smoke::t_enum|Smoke::tf_stack },	//26
    { "KLocale::TimeProcessingOption", 0, Smoke::t_enum|Smoke::tf_stack },	//27
    { "KLocalizedString", 15, Smoke::t_class|Smoke::tf_stack },	//28
    { "KPageWidget*", 17, Smoke::t_class|Smoke::tf_ptr },	//29
    { "KPageWidgetItem*", 18, Smoke::t_class|Smoke::tf_ptr },	//30
    { "KPluginInfo", 19, Smoke::t_class|Smoke::tf_stack },	//31
    { "KPluginSelector*", 20, Smoke::t_class|Smoke::tf_ptr },	//32
    { "KPluginSelector::PluginLoadMethod", 20, Smoke::t_enum|Smoke::tf_stack },	//33
    { "KPrintPreview*", 21, Smoke::t_class|Smoke::tf_ptr },	//34
    { "KService", 22, Smoke::t_class|Smoke::tf_stack },	//35
    { "KServiceAction&", 23, Smoke::t_class|Smoke::tf_ref },	//36
    { "KSettings::Dialog*", 24, Smoke::t_class|Smoke::tf_ptr },	//37
    { "KSettings::PluginPage*", 25, Smoke::t_class|Smoke::tf_ptr },	//38
    { "KSharedConfig", 26, Smoke::t_class|Smoke::tf_stack },	//39
    { "KSharedPtr<KSharedConfig>", 0, Smoke::t_voidp|Smoke::tf_stack },	//40
    { "KSycocaFactoryId", 48, Smoke::t_enum|Smoke::tf_stack },	//41
    { "KSycocaType", 48, Smoke::t_enum|Smoke::tf_stack },	//42
    { "KUrl::CleanPathOption", 0, Smoke::t_enum|Smoke::tf_stack },	//43
    { "KUrl::DirectoryOption", 0, Smoke::t_enum|Smoke::tf_stack },	//44
    { "KUrl::EncodedPathAndQueryOption", 0, Smoke::t_enum|Smoke::tf_stack },	//45
    { "KUrl::EqualsOption", 0, Smoke::t_enum|Smoke::tf_stack },	//46
    { "KUrl::QueryItemsOption", 0, Smoke::t_enum|Smoke::tf_stack },	//47
    { "QActionEvent*", 27, Smoke::t_class|Smoke::tf_ptr },	//48
    { "QBool", 28, Smoke::t_class|Smoke::tf_stack },	//49
    { "QBrush&", 29, Smoke::t_class|Smoke::tf_ref },	//50
    { "QByteArray", 30, Smoke::t_class|Smoke::tf_stack },	//51
    { "QByteArray&", 30, Smoke::t_class|Smoke::tf_ref },	//52
    { "QChar", 31, Smoke::t_class|Smoke::tf_stack },	//53
    { "QChar&", 31, Smoke::t_class|Smoke::tf_ref },	//54
    { "QChildEvent*", 32, Smoke::t_class|Smoke::tf_ptr },	//55
    { "QCloseEvent*", 33, Smoke::t_class|Smoke::tf_ptr },	//56
    { "QColor&", 34, Smoke::t_class|Smoke::tf_ref },	//57
    { "QContextMenuEvent*", 35, Smoke::t_class|Smoke::tf_ptr },	//58
    { "QCursor&", 36, Smoke::t_class|Smoke::tf_ref },	//59
    { "QDataStream&", 37, Smoke::t_class|Smoke::tf_ref },	//60
    { "QDate&", 38, Smoke::t_class|Smoke::tf_ref },	//61
    { "QDateTime&", 39, Smoke::t_class|Smoke::tf_ref },	//62
    { "QDragEnterEvent*", 41, Smoke::t_class|Smoke::tf_ptr },	//63
    { "QDragLeaveEvent*", 42, Smoke::t_class|Smoke::tf_ptr },	//64
    { "QDragMoveEvent*", 43, Smoke::t_class|Smoke::tf_ptr },	//65
    { "QDropEvent*", 44, Smoke::t_class|Smoke::tf_ptr },	//66
    { "QEvent*", 45, Smoke::t_class|Smoke::tf_ptr },	//67
    { "QFlags<KCModule::Button>", 0, Smoke::t_uint|Smoke::tf_stack },	//68
    { "QFlags<KConfig::OpenFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//69
    { "QFlags<KConfigBase::WriteConfigFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//70
    { "QFlags<KDialog::ButtonCode>", 0, Smoke::t_uint|Smoke::tf_stack },	//71
    { "QFlags<KDialog::CaptionFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//72
    { "QFlags<KEmoticonsTheme::ParseModeEnum>", 0, Smoke::t_uint|Smoke::tf_stack },	//73
    { "QFlags<KLocale::DateTimeComponent>", 0, Smoke::t_uint|Smoke::tf_stack },	//74
    { "QFlags<KLocale::DateTimeFormatOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//75
    { "QFlags<KLocale::TimeFormatOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//76
    { "QFlags<KLocale::TimeProcessingOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//77
    { "QFlags<KUrl::CleanPathOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//78
    { "QFlags<KUrl::DirectoryOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//79
    { "QFlags<KUrl::EncodedPathAndQueryOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//80
    { "QFlags<KUrl::EqualsOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//81
    { "QFlags<KUrl::QueryItemsOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//82
    { "QFlags<QIODevice::OpenModeFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//83
    { "QFlags<QLibrary::LoadHint>", 0, Smoke::t_uint|Smoke::tf_stack },	//84
    { "QFlags<QSizePolicy::ControlType>", 0, Smoke::t_uint|Smoke::tf_stack },	//85
    { "QFlags<QString::SectionFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//86
    { "QFlags<QUrl::FormattingOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//87
    { "QFlags<QWidget::RenderFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//88
    { "QFlags<Qt::AlignmentFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//89
    { "QFlags<Qt::DockWidgetArea>", 0, Smoke::t_uint|Smoke::tf_stack },	//90
    { "QFlags<Qt::DropAction>", 0, Smoke::t_uint|Smoke::tf_stack },	//91
    { "QFlags<Qt::GestureFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//92
    { "QFlags<Qt::ImageConversionFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//93
    { "QFlags<Qt::InputMethodHint>", 0, Smoke::t_uint|Smoke::tf_stack },	//94
    { "QFlags<Qt::ItemFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//95
    { "QFlags<Qt::KeyboardModifier>", 0, Smoke::t_uint|Smoke::tf_stack },	//96
    { "QFlags<Qt::MatchFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//97
    { "QFlags<Qt::MouseButton>", 0, Smoke::t_uint|Smoke::tf_stack },	//98
    { "QFlags<Qt::Orientation>", 0, Smoke::t_uint|Smoke::tf_stack },	//99
    { "QFlags<Qt::TextInteractionFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//100
    { "QFlags<Qt::ToolBarArea>", 0, Smoke::t_uint|Smoke::tf_stack },	//101
    { "QFlags<Qt::TouchPointState>", 0, Smoke::t_uint|Smoke::tf_stack },	//102
    { "QFlags<Qt::WindowState>", 0, Smoke::t_uint|Smoke::tf_stack },	//103
    { "QFlags<Qt::WindowType>", 0, Smoke::t_uint|Smoke::tf_stack },	//104
    { "QFocusEvent*", 46, Smoke::t_class|Smoke::tf_ptr },	//105
    { "QFont&", 47, Smoke::t_class|Smoke::tf_ref },	//106
    { "QHash<QChar,QList<Emoticon> >", 0, Smoke::t_voidp|Smoke::tf_stack },	//107
    { "QHash<QString,QStringList>", 0, Smoke::t_voidp|Smoke::tf_stack },	//108
    { "QHash<int,int>", 0, Smoke::t_voidp|Smoke::tf_stack },	//109
    { "QHideEvent*", 50, Smoke::t_class|Smoke::tf_ptr },	//110
    { "QIODevice::OpenModeFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//111
    { "QIcon&", 51, Smoke::t_class|Smoke::tf_ref },	//112
    { "QImage&", 52, Smoke::t_class|Smoke::tf_ref },	//113
    { "QIncompatibleFlag", 53, Smoke::t_class|Smoke::tf_stack },	//114
    { "QInputMethodEvent*", 54, Smoke::t_class|Smoke::tf_ptr },	//115
    { "QKeyEvent*", 55, Smoke::t_class|Smoke::tf_ptr },	//116
    { "QKeySequence&", 56, Smoke::t_class|Smoke::tf_ref },	//117
    { "QLibrary::LoadHint", 0, Smoke::t_enum|Smoke::tf_stack },	//118
    { "QLine", 58, Smoke::t_class|Smoke::tf_stack },	//119
    { "QLine&", 58, Smoke::t_class|Smoke::tf_ref },	//120
    { "QLineF", 59, Smoke::t_class|Smoke::tf_stack },	//121
    { "QLineF&", 59, Smoke::t_class|Smoke::tf_ref },	//122
    { "QList<Emoticon>", 0, Smoke::t_voidp|Smoke::tf_stack },	//123
    { "QList<KCModuleProxy*>&", 0, Smoke::t_voidp|Smoke::tf_ref },	//124
    { "QList<KPluginInfo>", 0, Smoke::t_voidp|Smoke::tf_stack },	//125
    { "QList<QString>", 0, Smoke::t_voidp|Smoke::tf_stack },	//126
    { "QMatrix&", 61, Smoke::t_class|Smoke::tf_ref },	//127
    { "QMetaObject::Call", 62, Smoke::t_enum|Smoke::tf_stack },	//128
    { "QMouseEvent*", 63, Smoke::t_class|Smoke::tf_ptr },	//129
    { "QMoveEvent*", 64, Smoke::t_class|Smoke::tf_ptr },	//130
    { "QObject*", 65, Smoke::t_class|Smoke::tf_ptr },	//131
    { "QPaintDevice::PaintDeviceMetric", 0, Smoke::t_enum|Smoke::tf_stack },	//132
    { "QPaintEngine*", 66, Smoke::t_class|Smoke::tf_ptr },	//133
    { "QPaintEvent*", 67, Smoke::t_class|Smoke::tf_ptr },	//134
    { "QPainterPath", 68, Smoke::t_class|Smoke::tf_stack },	//135
    { "QPainterPath&", 68, Smoke::t_class|Smoke::tf_ref },	//136
    { "QPalette&", 69, Smoke::t_class|Smoke::tf_ref },	//137
    { "QPixmap&", 70, Smoke::t_class|Smoke::tf_ref },	//138
    { "QPoint", 71, Smoke::t_class|Smoke::tf_stack },	//139
    { "QPoint&", 71, Smoke::t_class|Smoke::tf_ref },	//140
    { "QPointF", 72, Smoke::t_class|Smoke::tf_stack },	//141
    { "QPointF&", 72, Smoke::t_class|Smoke::tf_ref },	//142
    { "QPolygon", 73, Smoke::t_class|Smoke::tf_stack },	//143
    { "QPolygon&", 73, Smoke::t_class|Smoke::tf_ref },	//144
    { "QPolygonF", 74, Smoke::t_class|Smoke::tf_stack },	//145
    { "QPolygonF&", 74, Smoke::t_class|Smoke::tf_ref },	//146
    { "QPrinter*", 75, Smoke::t_class|Smoke::tf_ptr },	//147
    { "QRect&", 76, Smoke::t_class|Smoke::tf_ref },	//148
    { "QRectF&", 77, Smoke::t_class|Smoke::tf_ref },	//149
    { "QRegExp&", 78, Smoke::t_class|Smoke::tf_ref },	//150
    { "QRegion", 79, Smoke::t_class|Smoke::tf_stack },	//151
    { "QRegion&", 79, Smoke::t_class|Smoke::tf_ref },	//152
    { "QResizeEvent*", 80, Smoke::t_class|Smoke::tf_ptr },	//153
    { "QShowEvent*", 81, Smoke::t_class|Smoke::tf_ptr },	//154
    { "QSize", 82, Smoke::t_class|Smoke::tf_stack },	//155
    { "QSize&", 82, Smoke::t_class|Smoke::tf_ref },	//156
    { "QSizeF&", 83, Smoke::t_class|Smoke::tf_ref },	//157
    { "QSizePolicy&", 84, Smoke::t_class|Smoke::tf_ref },	//158
    { "QSizePolicy::ControlType", 84, Smoke::t_enum|Smoke::tf_stack },	//159
    { "QString", 0, Smoke::t_voidp|Smoke::tf_stack },	//160
    { "QString&", 0, Smoke::t_voidp|Smoke::tf_ref },	//161
    { "QString::Null", 85, Smoke::t_class|Smoke::tf_stack },	//162
    { "QString::SectionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//163
    { "QStringList", 0, Smoke::t_voidp|Smoke::tf_stack },	//164
    { "QStringList&", 0, Smoke::t_voidp|Smoke::tf_ref },	//165
    { "QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//166
    { "QStyle&", 87, Smoke::t_class|Smoke::tf_ref },	//167
    { "QTabletEvent*", 88, Smoke::t_class|Smoke::tf_ptr },	//168
    { "QTime&", 89, Smoke::t_class|Smoke::tf_ref },	//169
    { "QTimerEvent*", 90, Smoke::t_class|Smoke::tf_ptr },	//170
    { "QTransform", 91, Smoke::t_class|Smoke::tf_stack },	//171
    { "QTransform&", 91, Smoke::t_class|Smoke::tf_ref },	//172
    { "QUrl&", 92, Smoke::t_class|Smoke::tf_ref },	//173
    { "QUrl::FormattingOption", 92, Smoke::t_enum|Smoke::tf_stack },	//174
    { "QVariant", 93, Smoke::t_class|Smoke::tf_stack },	//175
    { "QVariant&", 93, Smoke::t_class|Smoke::tf_ref },	//176
    { "QVariant::Type&", 93, Smoke::t_enum|Smoke::tf_ref },	//177
    { "QWheelEvent*", 95, Smoke::t_class|Smoke::tf_ptr },	//178
    { "QWidget*", 96, Smoke::t_class|Smoke::tf_ptr },	//179
    { "QWidget::RenderFlag", 96, Smoke::t_enum|Smoke::tf_stack },	//180
    { "Qt::AlignmentFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//181
    { "Qt::AnchorAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//182
    { "Qt::AnchorPoint", 0, Smoke::t_enum|Smoke::tf_stack },	//183
    { "Qt::ApplicationAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//184
    { "Qt::ArrowType", 0, Smoke::t_enum|Smoke::tf_stack },	//185
    { "Qt::AspectRatioMode", 0, Smoke::t_enum|Smoke::tf_stack },	//186
    { "Qt::Axis", 0, Smoke::t_enum|Smoke::tf_stack },	//187
    { "Qt::BGMode", 0, Smoke::t_enum|Smoke::tf_stack },	//188
    { "Qt::BrushStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//189
    { "Qt::CaseSensitivity", 0, Smoke::t_enum|Smoke::tf_stack },	//190
    { "Qt::CheckState", 0, Smoke::t_enum|Smoke::tf_stack },	//191
    { "Qt::ClipOperation", 0, Smoke::t_enum|Smoke::tf_stack },	//192
    { "Qt::ConnectionType", 0, Smoke::t_enum|Smoke::tf_stack },	//193
    { "Qt::ContextMenuPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//194
    { "Qt::CoordinateSystem", 0, Smoke::t_enum|Smoke::tf_stack },	//195
    { "Qt::Corner", 0, Smoke::t_enum|Smoke::tf_stack },	//196
    { "Qt::CursorMoveStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//197
    { "Qt::CursorShape", 0, Smoke::t_enum|Smoke::tf_stack },	//198
    { "Qt::DateFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//199
    { "Qt::DayOfWeek", 0, Smoke::t_enum|Smoke::tf_stack },	//200
    { "Qt::DockWidgetArea", 0, Smoke::t_enum|Smoke::tf_stack },	//201
    { "Qt::DockWidgetAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//202
    { "Qt::DropAction", 0, Smoke::t_enum|Smoke::tf_stack },	//203
    { "Qt::EventPriority", 0, Smoke::t_enum|Smoke::tf_stack },	//204
    { "Qt::FillRule", 0, Smoke::t_enum|Smoke::tf_stack },	//205
    { "Qt::FocusPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//206
    { "Qt::FocusReason", 0, Smoke::t_enum|Smoke::tf_stack },	//207
    { "Qt::GestureFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//208
    { "Qt::GestureState", 0, Smoke::t_enum|Smoke::tf_stack },	//209
    { "Qt::GestureType", 0, Smoke::t_enum|Smoke::tf_stack },	//210
    { "Qt::GlobalColor", 0, Smoke::t_enum|Smoke::tf_stack },	//211
    { "Qt::ImageConversionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//212
    { "Qt::Initialization", 0, Smoke::t_enum|Smoke::tf_stack },	//213
    { "Qt::InputMethodHint", 0, Smoke::t_enum|Smoke::tf_stack },	//214
    { "Qt::InputMethodQuery", 0, Smoke::t_enum|Smoke::tf_stack },	//215
    { "Qt::ItemDataRole", 0, Smoke::t_enum|Smoke::tf_stack },	//216
    { "Qt::ItemFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//217
    { "Qt::ItemSelectionMode", 0, Smoke::t_enum|Smoke::tf_stack },	//218
    { "Qt::Key", 0, Smoke::t_enum|Smoke::tf_stack },	//219
    { "Qt::KeyboardModifier", 0, Smoke::t_enum|Smoke::tf_stack },	//220
    { "Qt::LayoutDirection", 0, Smoke::t_enum|Smoke::tf_stack },	//221
    { "Qt::MaskMode", 0, Smoke::t_enum|Smoke::tf_stack },	//222
    { "Qt::MatchFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//223
    { "Qt::Modifier", 0, Smoke::t_enum|Smoke::tf_stack },	//224
    { "Qt::MouseButton", 0, Smoke::t_enum|Smoke::tf_stack },	//225
    { "Qt::NavigationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//226
    { "Qt::Orientation", 0, Smoke::t_enum|Smoke::tf_stack },	//227
    { "Qt::PenCapStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//228
    { "Qt::PenJoinStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//229
    { "Qt::PenStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//230
    { "Qt::ScrollBarPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//231
    { "Qt::ShortcutContext", 0, Smoke::t_enum|Smoke::tf_stack },	//232
    { "Qt::SizeHint", 0, Smoke::t_enum|Smoke::tf_stack },	//233
    { "Qt::SizeMode", 0, Smoke::t_enum|Smoke::tf_stack },	//234
    { "Qt::SortOrder", 0, Smoke::t_enum|Smoke::tf_stack },	//235
    { "Qt::TextElideMode", 0, Smoke::t_enum|Smoke::tf_stack },	//236
    { "Qt::TextFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//237
    { "Qt::TextFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//238
    { "Qt::TextInteractionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//239
    { "Qt::TileRule", 0, Smoke::t_enum|Smoke::tf_stack },	//240
    { "Qt::TimeSpec", 0, Smoke::t_enum|Smoke::tf_stack },	//241
    { "Qt::ToolBarArea", 0, Smoke::t_enum|Smoke::tf_stack },	//242
    { "Qt::ToolBarAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//243
    { "Qt::ToolButtonStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//244
    { "Qt::TouchPointState", 0, Smoke::t_enum|Smoke::tf_stack },	//245
    { "Qt::TransformationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//246
    { "Qt::UIEffect", 0, Smoke::t_enum|Smoke::tf_stack },	//247
    { "Qt::WidgetAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//248
    { "Qt::WindowFrameSection", 0, Smoke::t_enum|Smoke::tf_stack },	//249
    { "Qt::WindowModality", 0, Smoke::t_enum|Smoke::tf_stack },	//250
    { "Qt::WindowState", 0, Smoke::t_enum|Smoke::tf_stack },	//251
    { "Qt::WindowType", 0, Smoke::t_enum|Smoke::tf_stack },	//252
    { "_XEvent*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//253
    { "bool", 0, Smoke::t_bool|Smoke::tf_stack },	//254
    { "char", 0, Smoke::t_char|Smoke::tf_stack },	//255
    { "const KAboutData*", 2, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//256
    { "const KCModuleInfo&", 5, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//257
    { "const KComponentData&", 9, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//258
    { "const KEmoticonsTheme&", 13, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//259
    { "const KServiceAction&", 23, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//260
    { "const KSharedPtr<KService>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//261
    { "const KSharedPtr<KSharedConfig>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//262
    { "const QBrush&", 29, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//263
    { "const QByteArray", 30, Smoke::t_class|Smoke::tf_stack|Smoke::tf_const },	//264
    { "const QByteArray&", 30, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//265
    { "const QChar&", 31, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//266
    { "const QColor&", 34, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//267
    { "const QCursor&", 36, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//268
    { "const QDate&", 38, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//269
    { "const QDateTime&", 39, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//270
    { "const QFont&", 47, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//271
    { "const QHashDummyValue&", 49, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//272
    { "const QIcon&", 51, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//273
    { "const QImage&", 52, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//274
    { "const QKeySequence&", 56, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//275
    { "const QLatin1String&", 57, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//276
    { "const QLine&", 58, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//277
    { "const QLineF&", 59, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//278
    { "const QList<KCModuleProxy*>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//279
    { "const QList<KPluginInfo>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//280
    { "const QList<QVariant>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//281
    { "const QMargins&", 60, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//282
    { "const QMatrix&", 61, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//283
    { "const QMetaObject&", 62, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//284
    { "const QMetaObject*", 62, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//285
    { "const QPainterPath&", 68, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//286
    { "const QPalette&", 69, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//287
    { "const QPixmap&", 70, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//288
    { "const QPoint", 71, Smoke::t_class|Smoke::tf_stack|Smoke::tf_const },	//289
    { "const QPoint&", 71, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//290
    { "const QPointF", 72, Smoke::t_class|Smoke::tf_stack|Smoke::tf_const },	//291
    { "const QPointF&", 72, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//292
    { "const QPolygon&", 73, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//293
    { "const QPolygonF&", 74, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//294
    { "const QRect&", 76, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//295
    { "const QRectF&", 77, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//296
    { "const QRegExp&", 78, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//297
    { "const QRegion&", 79, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//298
    { "const QSize", 82, Smoke::t_class|Smoke::tf_stack|Smoke::tf_const },	//299
    { "const QSize&", 82, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//300
    { "const QSizeF", 83, Smoke::t_class|Smoke::tf_stack|Smoke::tf_const },	//301
    { "const QSizeF&", 83, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//302
    { "const QSizePolicy&", 84, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//303
    { "const QString", 0, Smoke::t_voidp|Smoke::tf_stack|Smoke::tf_const },	//304
    { "const QString&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//305
    { "const QStringList&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//306
    { "const QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//307
    { "const QStringRef&", 86, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//308
    { "const QTime&", 89, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//309
    { "const QTransform&", 91, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//310
    { "const QUrl&", 92, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//311
    { "const QVariant&", 93, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//312
    { "const QVariant::Type", 93, Smoke::t_enum|Smoke::tf_stack|Smoke::tf_const },	//313
    { "const QVariantComparisonHelper&", 94, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//314
    { "const char*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//315
    { "const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//316
    { "double", 0, Smoke::t_double|Smoke::tf_stack },	//317
    { "float", 0, Smoke::t_float|Smoke::tf_stack },	//318
    { "int", 0, Smoke::t_int|Smoke::tf_stack },	//319
    { "void*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//320
    { "void**", 0, Smoke::t_voidp|Smoke::tf_ptr },	//321
    { "volatile const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//322
};

static Smoke::Index argumentList[] = {
    0,	//0  (void)
    154, 0,	//1  QShowEvent*
    315, 0,	//3  const char*
    315, 315, 0,	//5  const char*, const char*
    315, 315, 319, 0,	//8  const char*, const char*, int
    128, 319, 321, 0,	//12  QMetaObject::Call, int, void**
    179, 306, 0,	//16  QWidget*, const QStringList&
    179, 305, 0,	//19  QWidget*, const QString&
    305, 0,	//22  const QString&
    179, 0,	//24  QWidget*
    279, 0,	//26  const QList<KCModuleProxy*>&
    257, 179, 306, 0,	//28  const KCModuleInfo&, QWidget*, const QStringList&
    305, 179, 306, 0,	//32  const QString&, QWidget*, const QStringList&
    261, 179, 306, 0,	//36  const KSharedPtr<KService>&, QWidget*, const QStringList&
    254, 0,	//40  bool
    7, 0,	//42  KCModuleProxy*
    257, 0,	//44  const KCModuleInfo&
    257, 179, 0,	//46  const KCModuleInfo&, QWidget*
    305, 179, 0,	//49  const QString&, QWidget*
    261, 0,	//52  const KSharedPtr<KService>&
    261, 179, 0,	//54  const KSharedPtr<KService>&, QWidget*
    305, 306, 0,	//57  const QString&, const QStringList&
    257, 30, 306, 0,	//60  const KCModuleInfo&, KPageWidgetItem*, const QStringList&
    71, 0,	//64  QFlags<KDialog::ButtonCode>
    265, 0,	//66  const QByteArray&
    29, 179, 104, 0,	//68  KPageWidget*, QWidget*, QFlags<Qt::WindowType>
    9, 29, 179, 104, 0,	//72  KCMultiDialogPrivate&, KPageWidget*, QWidget*, QFlags<Qt::WindowType>
    257, 30, 0,	//77  const KCModuleInfo&, KPageWidgetItem*
    29, 179, 0,	//80  KPageWidget*, QWidget*
    9, 29, 179, 0,	//83  KCMultiDialogPrivate&, KPageWidget*, QWidget*
    305, 254, 0,	//87  const QString&, bool
    110, 0,	//90  QHideEvent*
    56, 0,	//92  QCloseEvent*
    116, 0,	//94  QKeyEvent*
    319, 0,	//96  int
    259, 0,	//98  const KEmoticonsTheme&
    305, 261, 0,	//100  const QString&, const KSharedPtr<KService>&
    73, 0,	//103  QFlags<KEmoticonsTheme::ParseModeEnum>
    131, 0,	//105  QObject*
    305, 305, 17, 0,	//107  const QString&, const QString&, KEmoticonsProvider::AddEmoticonOption
    160, 164, 0,	//111  QString, QStringList
    160, 0,	//114  QString
    305, 305, 0,	//116  const QString&, const QString&
    319, 319, 0,	//119  int, int
    305, 305, 305, 40, 0,	//122  const QString&, const QString&, const QString&, KSharedPtr<KSharedConfig>
    258, 305, 305, 262, 0,	//127  const KComponentData&, const QString&, const QString&, const KSharedPtr<KSharedConfig>&
    280, 33, 305, 305, 262, 0,	//132  const QList<KPluginInfo>&, KPluginSelector::PluginLoadMethod, const QString&, const QString&, const KSharedPtr<KSharedConfig>&
    305, 305, 305, 0,	//138  const QString&, const QString&, const QString&
    258, 0,	//142  const KComponentData&
    258, 305, 0,	//144  const KComponentData&, const QString&
    258, 305, 305, 0,	//147  const KComponentData&, const QString&, const QString&
    280, 0,	//151  const QList<KPluginInfo>&
    280, 33, 0,	//153  const QList<KPluginInfo>&, KPluginSelector::PluginLoadMethod
    280, 33, 305, 0,	//156  const QList<KPluginInfo>&, KPluginSelector::PluginLoadMethod, const QString&
    280, 33, 305, 305, 0,	//160  const QList<KPluginInfo>&, KPluginSelector::PluginLoadMethod, const QString&, const QString&
    147, 179, 0,	//165  QPrinter*, QWidget*
    147, 0,	//168  QPrinter*
    306, 179, 0,	//170  const QStringList&, QWidget*
    306, 0,	//173  const QStringList&
    258, 179, 281, 0,	//175  const KComponentData&, QWidget*, const QList<QVariant>&
    258, 179, 0,	//179  const KComponentData&, QWidget*
    153, 0,	//182  QResizeEvent*
    58, 0,	//184  QContextMenuEvent*
    131, 67, 0,	//186  QObject*, QEvent*
    201, 319, 0,	//189  Qt::DockWidgetArea, int
    290, 317, 0,	//192  const QPoint&, double
    317, 292, 0,	//195  double, const QPointF&
    225, 98, 0,	//198  Qt::MouseButton, QFlags<Qt::MouseButton>
    282, 282, 0,	//201  const QMargins&, const QMargins&
    317, 302, 0,	//204  double, const QSizeF&
    60, 113, 0,	//207  QDataStream&, QImage&
    60, 303, 0,	//210  QDataStream&, const QSizePolicy&
    214, 319, 0,	//213  Qt::InputMethodHint, int
    25, 25, 0,	//216  KLocale::DateTimeFormatOption, KLocale::DateTimeFormatOption
    295, 295, 0,	//219  const QRect&, const QRect&
    300, 300, 0,	//222  const QSize&, const QSize&
    60, 310, 0,	//225  QDataStream&, const QTransform&
    292, 283, 0,	//228  const QPointF&, const QMatrix&
    60, 260, 0,	//231  QDataStream&, const KServiceAction&
    277, 310, 0,	//234  const QLine&, const QTransform&
    19, 319, 0,	//237  KEmoticonsTheme::ParseModeEnum, int
    251, 103, 0,	//240  Qt::WindowState, QFlags<Qt::WindowState>
    302, 317, 0,	//243  const QSizeF&, double
    60, 277, 0,	//246  QDataStream&, const QLine&
    315, 276, 0,	//249  const char*, const QLatin1String&
    302, 302, 0,	//252  const QSizeF&, const QSizeF&
    26, 76, 0,	//255  KLocale::TimeFormatOption, QFlags<KLocale::TimeFormatOption>
    265, 265, 0,	//258  const QByteArray&, const QByteArray&
    276, 308, 0,	//261  const QLatin1String&, const QStringRef&
    225, 225, 0,	//264  Qt::MouseButton, Qt::MouseButton
    43, 78, 0,	//267  KUrl::CleanPathOption, QFlags<KUrl::CleanPathOption>
    43, 43, 0,	//270  KUrl::CleanPathOption, KUrl::CleanPathOption
    312, 314, 0,	//273  const QVariant&, const QVariantComparisonHelper&
    19, 19, 0,	//276  KEmoticonsTheme::ParseModeEnum, KEmoticonsTheme::ParseModeEnum
    49, 49, 0,	//279  QBool, QBool
    12, 319, 0,	//282  KConfigBase::WriteConfigFlag, int
    181, 89, 0,	//285  Qt::AlignmentFlag, QFlags<Qt::AlignmentFlag>
    162, 162, 0,	//288  QString::Null, QString::Null
    60, 36, 0,	//291  QDataStream&, KServiceAction&
    60, 296, 0,	//294  QDataStream&, const QRectF&
    53, 305, 0,	//297  QChar, const QString&
    111, 83, 0,	//300  QIODevice::OpenModeFlag, QFlags<QIODevice::OpenModeFlag>
    13, 13, 0,	//303  KDialog::ButtonCode, KDialog::ButtonCode
    60, 287, 0,	//306  QDataStream&, const QPalette&
    22, 0,	//309  KIconLoader::Group&
    60, 265, 0,	//311  QDataStream&, const QByteArray&
    294, 310, 0,	//314  const QPolygonF&, const QTransform&
    242, 242, 0,	//317  Qt::ToolBarArea, Qt::ToolBarArea
    47, 319, 0,	//320  KUrl::QueryItemsOption, int
    180, 319, 0,	//323  QWidget::RenderFlag, int
    203, 319, 0,	//326  Qt::DropAction, int
    60, 306, 0,	//329  QDataStream&, const QStringList&
    45, 45, 0,	//332  KUrl::EncodedPathAndQueryOption, KUrl::EncodedPathAndQueryOption
    11, 69, 0,	//335  KConfig::OpenFlag, QFlags<KConfig::OpenFlag>
    181, 181, 0,	//338  Qt::AlignmentFlag, Qt::AlignmentFlag
    60, 57, 0,	//341  QDataStream&, QColor&
    60, 297, 0,	//344  QDataStream&, const QRegExp&
    174, 319, 0,	//347  QUrl::FormattingOption, int
    265, 315, 0,	//350  const QByteArray&, const char*
    44, 44, 0,	//353  KUrl::DirectoryOption, KUrl::DirectoryOption
    201, 90, 0,	//356  Qt::DockWidgetArea, QFlags<Qt::DockWidgetArea>
    14, 14, 0,	//359  KDialog::CaptionFlag, KDialog::CaptionFlag
    277, 283, 0,	//362  const QLine&, const QMatrix&
    44, 79, 0,	//365  KUrl::DirectoryOption, QFlags<KUrl::DirectoryOption>
    278, 283, 0,	//368  const QLineF&, const QMatrix&
    227, 227, 0,	//371  Qt::Orientation, Qt::Orientation
    286, 283, 0,	//374  const QPainterPath&, const QMatrix&
    242, 319, 0,	//377  Qt::ToolBarArea, int
    60, 142, 0,	//380  QDataStream&, QPointF&
    223, 319, 0,	//383  Qt::MatchFlag, int
    60, 275, 0,	//386  QDataStream&, const QKeySequence&
    305, 315, 0,	//389  const QString&, const char*
    60, 268, 0,	//392  QDataStream&, const QCursor&
    208, 208, 0,	//395  Qt::GestureFlag, Qt::GestureFlag
    60, 61, 0,	//398  QDataStream&, QDate&
    111, 111, 0,	//401  QIODevice::OpenModeFlag, QIODevice::OpenModeFlag
    255, 265, 0,	//404  char, const QByteArray&
    315, 305, 0,	//407  const char*, const QString&
    315, 265, 0,	//410  const char*, const QByteArray&
    60, 52, 0,	//413  QDataStream&, QByteArray&
    60, 176, 0,	//416  QDataStream&, QVariant&
    13, 319, 0,	//419  KDialog::ButtonCode, int
    60, 150, 0,	//422  QDataStream&, QRegExp&
    292, 292, 0,	//425  const QPointF&, const QPointF&
    310, 317, 0,	//428  const QTransform&, double
    24, 74, 0,	//431  KLocale::DateTimeComponent, QFlags<KLocale::DateTimeComponent>
    308, 308, 0,	//434  const QStringRef&, const QStringRef&
    53, 53, 0,	//437  QChar, QChar
    286, 310, 0,	//440  const QPainterPath&, const QTransform&
    60, 263, 0,	//443  QDataStream&, const QBrush&
    13, 71, 0,	//446  KDialog::ButtonCode, QFlags<KDialog::ButtonCode>
    25, 319, 0,	//449  KLocale::DateTimeFormatOption, int
    60, 152, 0,	//452  QDataStream&, QRegion&
    292, 317, 0,	//455  const QPointF&, double
    45, 319, 0,	//458  KUrl::EncodedPathAndQueryOption, int
    60, 269, 0,	//461  QDataStream&, const QDate&
    223, 97, 0,	//464  Qt::MatchFlag, QFlags<Qt::MatchFlag>
    208, 319, 0,	//467  Qt::GestureFlag, int
    159, 159, 0,	//470  QSizePolicy::ControlType, QSizePolicy::ControlType
    60, 59, 0,	//473  QDataStream&, QCursor&
    220, 96, 0,	//476  Qt::KeyboardModifier, QFlags<Qt::KeyboardModifier>
    223, 223, 0,	//479  Qt::MatchFlag, Qt::MatchFlag
    60, 172, 0,	//482  QDataStream&, QTransform&
    293, 283, 0,	//485  const QPolygon&, const QMatrix&
    305, 162, 0,	//488  const QString&, QString::Null
    3, 68, 0,	//491  KCModule::Button, QFlags<KCModule::Button>
    118, 319, 0,	//494  QLibrary::LoadHint, int
    60, 157, 0,	//497  QDataStream&, QSizeF&
    292, 0,	//500  const QPointF&
    217, 217, 0,	//502  Qt::ItemFlag, Qt::ItemFlag
    60, 288, 0,	//505  QDataStream&, const QPixmap&
    265, 305, 0,	//508  const QByteArray&, const QString&
    252, 104, 0,	//511  Qt::WindowType, QFlags<Qt::WindowType>
    292, 310, 0,	//514  const QPointF&, const QTransform&
    217, 95, 0,	//517  Qt::ItemFlag, QFlags<Qt::ItemFlag>
    245, 102, 0,	//520  Qt::TouchPointState, QFlags<Qt::TouchPointState>
    305, 255, 0,	//523  const QString&, char
    60, 311, 0,	//526  QDataStream&, const QUrl&
    159, 85, 0,	//529  QSizePolicy::ControlType, QFlags<QSizePolicy::ControlType>
    315, 315, 315, 0,	//532  const char*, const char*, const char*
    60, 312, 0,	//536  QDataStream&, const QVariant&
    60, 120, 0,	//539  QDataStream&, QLine&
    220, 220, 0,	//542  Qt::KeyboardModifier, Qt::KeyboardModifier
    181, 319, 0,	//545  Qt::AlignmentFlag, int
    290, 283, 0,	//548  const QPoint&, const QMatrix&
    220, 319, 0,	//551  Qt::KeyboardModifier, int
    217, 319, 0,	//554  Qt::ItemFlag, int
    27, 27, 0,	//557  KLocale::TimeProcessingOption, KLocale::TimeProcessingOption
    212, 93, 0,	//560  Qt::ImageConversionFlag, QFlags<Qt::ImageConversionFlag>
    290, 290, 0,	//563  const QPoint&, const QPoint&
    163, 319, 0,	//566  QString::SectionFlag, int
    252, 319, 0,	//569  Qt::WindowType, int
    180, 180, 0,	//572  QWidget::RenderFlag, QWidget::RenderFlag
    308, 305, 0,	//575  const QStringRef&, const QString&
    276, 276, 0,	//578  const QLatin1String&, const QLatin1String&
    272, 272, 0,	//581  const QHashDummyValue&, const QHashDummyValue&
    46, 46, 0,	//584  KUrl::EqualsOption, KUrl::EqualsOption
    174, 174, 0,	//587  QUrl::FormattingOption, QUrl::FormattingOption
    60, 112, 0,	//590  QDataStream&, QIcon&
    60, 293, 0,	//593  QDataStream&, const QPolygon&
    245, 319, 0,	//596  Qt::TouchPointState, int
    14, 72, 0,	//599  KDialog::CaptionFlag, QFlags<KDialog::CaptionFlag>
    180, 88, 0,	//602  QWidget::RenderFlag, QFlags<QWidget::RenderFlag>
    308, 315, 0,	//605  const QStringRef&, const char*
    43, 319, 0,	//608  KUrl::CleanPathOption, int
    47, 47, 0,	//611  KUrl::QueryItemsOption, KUrl::QueryItemsOption
    12, 12, 0,	//614  KConfigBase::WriteConfigFlag, KConfigBase::WriteConfigFlag
    11, 319, 0,	//617  KConfig::OpenFlag, int
    60, 278, 0,	//620  QDataStream&, const QLineF&
    60, 50, 0,	//623  QDataStream&, QBrush&
    60, 292, 0,	//626  QDataStream&, const QPointF&
    290, 318, 0,	//629  const QPoint&, float
    26, 26, 0,	//632  KLocale::TimeFormatOption, KLocale::TimeFormatOption
    305, 308, 0,	//635  const QString&, const QStringRef&
    46, 319, 0,	//638  KUrl::EqualsOption, int
    14, 319, 0,	//641  KDialog::CaptionFlag, int
    159, 319, 0,	//644  QSizePolicy::ControlType, int
    60, 158, 0,	//647  QDataStream&, QSizePolicy&
    315, 308, 0,	//650  const char*, const QStringRef&
    60, 127, 0,	//653  QDataStream&, QMatrix&
    225, 319, 0,	//656  Qt::MouseButton, int
    60, 156, 0,	//659  QDataStream&, QSize&
    214, 214, 0,	//662  Qt::InputMethodHint, Qt::InputMethodHint
    27, 77, 0,	//665  KLocale::TimeProcessingOption, QFlags<KLocale::TimeProcessingOption>
    60, 177, 0,	//668  QDataStream&, QVariant::Type&
    239, 100, 0,	//671  Qt::TextInteractionFlag, QFlags<Qt::TextInteractionFlag>
    278, 310, 0,	//674  const QLineF&, const QTransform&
    308, 276, 0,	//677  const QStringRef&, const QLatin1String&
    60, 294, 0,	//680  QDataStream&, const QPolygonF&
    60, 302, 0,	//683  QDataStream&, const QSizeF&
    242, 101, 0,	//686  Qt::ToolBarArea, QFlags<Qt::ToolBarArea>
    60, 271, 0,	//689  QDataStream&, const QFont&
    46, 81, 0,	//692  KUrl::EqualsOption, QFlags<KUrl::EqualsOption>
    27, 319, 0,	//695  KLocale::TimeProcessingOption, int
    60, 283, 0,	//698  QDataStream&, const QMatrix&
    255, 305, 0,	//701  char, const QString&
    118, 118, 0,	//704  QLibrary::LoadHint, QLibrary::LoadHint
    251, 251, 0,	//707  Qt::WindowState, Qt::WindowState
    174, 87, 0,	//710  QUrl::FormattingOption, QFlags<QUrl::FormattingOption>
    60, 146, 0,	//713  QDataStream&, QPolygonF&
    60, 137, 0,	//716  QDataStream&, QPalette&
    60, 286, 0,	//719  QDataStream&, const QPainterPath&
    296, 296, 0,	//722  const QRectF&, const QRectF&
    317, 300, 0,	//725  double, const QSize&
    3, 3, 0,	//728  KCModule::Button, KCModule::Button
    317, 290, 0,	//731  double, const QPoint&
    60, 290, 0,	//734  QDataStream&, const QPoint&
    60, 274, 0,	//737  QDataStream&, const QImage&
    265, 255, 0,	//740  const QByteArray&, char
    60, 106, 0,	//743  QDataStream&, QFont&
    163, 86, 0,	//746  QString::SectionFlag, QFlags<QString::SectionFlag>
    60, 300, 0,	//749  QDataStream&, const QSize&
    25, 75, 0,	//752  KLocale::DateTimeFormatOption, QFlags<KLocale::DateTimeFormatOption>
    60, 149, 0,	//755  QDataStream&, QRectF&
    60, 266, 0,	//758  QDataStream&, const QChar&
    254, 49, 0,	//761  bool, QBool
    47, 82, 0,	//764  KUrl::QueryItemsOption, QFlags<KUrl::QueryItemsOption>
    293, 310, 0,	//767  const QPolygon&, const QTransform&
    49, 254, 0,	//770  QBool, bool
    251, 319, 0,	//773  Qt::WindowState, int
    60, 165, 0,	//776  QDataStream&, QStringList&
    60, 295, 0,	//779  QDataStream&, const QRect&
    44, 319, 0,	//782  KUrl::DirectoryOption, int
    60, 298, 0,	//785  QDataStream&, const QRegion&
    201, 201, 0,	//788  Qt::DockWidgetArea, Qt::DockWidgetArea
    24, 24, 0,	//791  KLocale::DateTimeComponent, KLocale::DateTimeComponent
    60, 267, 0,	//794  QDataStream&, const QColor&
    252, 252, 0,	//797  Qt::WindowType, Qt::WindowType
    300, 317, 0,	//800  const QSize&, double
    162, 305, 0,	//803  QString::Null, const QString&
    214, 94, 0,	//806  Qt::InputMethodHint, QFlags<Qt::InputMethodHint>
    11, 11, 0,	//809  KConfig::OpenFlag, KConfig::OpenFlag
    60, 140, 0,	//812  QDataStream&, QPoint&
    60, 62, 0,	//815  QDataStream&, QDateTime&
    60, 309, 0,	//818  QDataStream&, const QTime&
    60, 117, 0,	//821  QDataStream&, QKeySequence&
    26, 319, 0,	//824  KLocale::TimeFormatOption, int
    298, 310, 0,	//827  const QRegion&, const QTransform&
    3, 319, 0,	//830  KCModule::Button, int
    163, 163, 0,	//833  QString::SectionFlag, QString::SectionFlag
    111, 319, 0,	//836  QIODevice::OpenModeFlag, int
    319, 290, 0,	//839  int, const QPoint&
    208, 92, 0,	//842  Qt::GestureFlag, QFlags<Qt::GestureFlag>
    294, 283, 0,	//845  const QPolygonF&, const QMatrix&
    290, 0,	//848  const QPoint&
    60, 144, 0,	//850  QDataStream&, QPolygon&
    45, 80, 0,	//853  KUrl::EncodedPathAndQueryOption, QFlags<KUrl::EncodedPathAndQueryOption>
    60, 161, 0,	//856  QDataStream&, QString&
    60, 305, 0,	//859  QDataStream&, const QString&
    60, 54, 0,	//862  QDataStream&, QChar&
    239, 239, 0,	//865  Qt::TextInteractionFlag, Qt::TextInteractionFlag
    60, 138, 0,	//868  QDataStream&, QPixmap&
    19, 73, 0,	//871  KEmoticonsTheme::ParseModeEnum, QFlags<KEmoticonsTheme::ParseModeEnum>
    12, 70, 0,	//874  KConfigBase::WriteConfigFlag, QFlags<KConfigBase::WriteConfigFlag>
    305, 265, 0,	//877  const QString&, const QByteArray&
    60, 148, 0,	//880  QDataStream&, QRect&
    24, 319, 0,	//883  KLocale::DateTimeComponent, int
    212, 319, 0,	//886  Qt::ImageConversionFlag, int
    60, 273, 0,	//889  QDataStream&, const QIcon&
    60, 313, 0,	//892  QDataStream&, const QVariant::Type
    60, 122, 0,	//895  QDataStream&, QLineF&
    60, 136, 0,	//898  QDataStream&, QPainterPath&
    245, 245, 0,	//901  Qt::TouchPointState, Qt::TouchPointState
    239, 319, 0,	//904  Qt::TextInteractionFlag, int
    290, 310, 0,	//907  const QPoint&, const QTransform&
    60, 270, 0,	//910  QDataStream&, const QDateTime&
    60, 169, 0,	//913  QDataStream&, QTime&
    290, 319, 0,	//916  const QPoint&, int
    212, 212, 0,	//919  Qt::ImageConversionFlag, Qt::ImageConversionFlag
    203, 91, 0,	//922  Qt::DropAction, QFlags<Qt::DropAction>
    203, 203, 0,	//925  Qt::DropAction, Qt::DropAction
    227, 319, 0,	//928  Qt::Orientation, int
    298, 283, 0,	//931  const QRegion&, const QMatrix&
    318, 290, 0,	//934  float, const QPoint&
    60, 173, 0,	//937  QDataStream&, QUrl&
    118, 84, 0,	//940  QLibrary::LoadHint, QFlags<QLibrary::LoadHint>
    305, 53, 0,	//943  const QString&, QChar
    227, 99, 0,	//946  Qt::Orientation, QFlags<Qt::Orientation>
    22, 319, 0,	//949  KIconLoader::Group&, int
    67, 0,	//952  QEvent*
    170, 0,	//954  QTimerEvent*
    55, 0,	//956  QChildEvent*
    129, 0,	//958  QMouseEvent*
    178, 0,	//960  QWheelEvent*
    105, 0,	//962  QFocusEvent*
    134, 0,	//964  QPaintEvent*
    130, 0,	//966  QMoveEvent*
    168, 0,	//968  QTabletEvent*
    48, 0,	//970  QActionEvent*
    63, 0,	//972  QDragEnterEvent*
    65, 0,	//974  QDragMoveEvent*
    64, 0,	//976  QDragLeaveEvent*
    66, 0,	//978  QDropEvent*
    253, 0,	//980  _XEvent*
    132, 0,	//982  QPaintDevice::PaintDeviceMetric
    115, 0,	//984  QInputMethodEvent*
    215, 0,	//986  Qt::InputMethodQuery
    167, 0,	//988  QStyle&
    287, 0,	//990  const QPalette&
    271, 0,	//992  const QFont&
};

// Raw list of all methods, using munged names
static const char *methodNames[] = {
    "",	//0
    "Accepted",	//1
    "AppNameCaption",	//2
    "Apply",	//3
    "Cancel",	//4
    "Close",	//5
    "Copy",	//6
    "Default",	//7
    "DelayedPopup",	//8
    "Details",	//9
    "Dialog",	//10
    "Dialog#",	//11
    "Dialog?",	//12
    "Dialog?#",	//13
    "DoNotCopy",	//14
    "DrawChildren",	//15
    "DrawWindowBackground",	//16
    "Export",	//17
    "HIGCompliantCaption",	//18
    "Help",	//19
    "IgnoreConfigFile",	//20
    "IgnoreMask",	//21
    "InstantPopup",	//22
    "KCModuleContainer",	//23
    "KCModuleContainer#",	//24
    "KCModuleContainer#$",	//25
    "KCModuleContainer#?",	//26
    "KCModuleProxy",	//27
    "KCModuleProxy#",	//28
    "KCModuleProxy##",	//29
    "KCModuleProxy##?",	//30
    "KCModuleProxy$",	//31
    "KCModuleProxy$#",	//32
    "KCModuleProxy$#?",	//33
    "KCModuleProxy?",	//34
    "KCModuleProxy?#",	//35
    "KCModuleProxy?#?",	//36
    "KCMultiDialog",	//37
    "KCMultiDialog#",	//38
    "KCMultiDialog##",	//39
    "KCMultiDialog###",	//40
    "KCMultiDialog###$",	//41
    "KCMultiDialog##$",	//42
    "KEmoticons",	//43
    "KEmoticonsProvider",	//44
    "KEmoticonsProvider#",	//45
    "KPluginSelector",	//46
    "KPluginSelector#",	//47
    "KPrintPreview",	//48
    "KPrintPreview#",	//49
    "KPrintPreview##",	//50
    "KST_CTimeInfo",	//51
    "KST_KCustom",	//52
    "KST_KDEDesktopMimeType",	//53
    "KST_KFolderMimeType",	//54
    "KST_KImageIO",	//55
    "KST_KImageIOFormat",	//56
    "KST_KMimeType",	//57
    "KST_KMimeTypeEntry",	//58
    "KST_KMimeTypeFactory",	//59
    "KST_KProtocolInfo",	//60
    "KST_KProtocolInfoFactory",	//61
    "KST_KService",	//62
    "KST_KServiceFactory",	//63
    "KST_KServiceGroup",	//64
    "KST_KServiceGroupFactory",	//65
    "KST_KServiceSeparator",	//66
    "KST_KServiceType",	//67
    "KST_KServiceTypeFactory",	//68
    "KST_KSycocaEntry",	//69
    "ModifiedCaption",	//70
    "No",	//71
    "NoAdditionalButton",	//72
    "NoCaptionFlags",	//73
    "NoDefault",	//74
    "None",	//75
    "Ok",	//76
    "PluginPage",	//77
    "PluginPage#",	//78
    "PluginPage##",	//79
    "PluginPage##?",	//80
    "ReadConfigFile",	//81
    "Rejected",	//82
    "Reset",	//83
    "Try",	//84
    "User1",	//85
    "User2",	//86
    "User3",	//87
    "Yes",	//88
    "aboutData",	//89
    "accept",	//90
    "actionEvent",	//91
    "addEmoticon",	//92
    "addEmoticon$$",	//93
    "addEmoticon$$$",	//94
    "addEmoticonIndex",	//95
    "addEmoticonIndex$?",	//96
    "addEmoticonsMap",	//97
    "addEmoticonsMap$?",	//98
    "addIdleTimeout",	//99
    "addIdleTimeout$",	//100
    "addModule",	//101
    "addModule#",	//102
    "addModule##",	//103
    "addModule##?",	//104
    "addModule$",	//105
    "addModule$?",	//106
    "addPluginInfos",	//107
    "addPluginInfos?",	//108
    "addPlugins",	//109
    "addPlugins#",	//110
    "addPlugins#$",	//111
    "addPlugins#$$",	//112
    "addPlugins#$$?",	//113
    "addPlugins$",	//114
    "addPlugins$$",	//115
    "addPlugins$$$",	//116
    "addPlugins$$$?",	//117
    "addPlugins?",	//118
    "addPlugins?$",	//119
    "addPlugins?$$",	//120
    "addPlugins?$$$",	//121
    "addPlugins?$$$?",	//122
    "allModules",	//123
    "allowComponentSelection",	//124
    "buttons",	//125
    "catchNextResumeEvent",	//126
    "changeEvent",	//127
    "changed",	//128
    "changed#",	//129
    "changed$",	//130
    "changedModules",	//131
    "childClosed",	//132
    "childEvent",	//133
    "clear",	//134
    "clearEmoticonsMap",	//135
    "closeEvent",	//136
    "componentData",	//137
    "configCommitted",	//138
    "configCommitted#",	//139
    "connectNotify",	//140
    "contextMenuEvent",	//141
    "createNew",	//142
    "currentThemeName",	//143
    "customEvent",	//144
    "dbusPath",	//145
    "dbusService",	//146
    "defaults",	//147
    "deleteClient",	//148
    "devType",	//149
    "disconnectNotify",	//150
    "done",	//151
    "dragEnterEvent",	//152
    "dragLeaveEvent",	//153
    "dragMoveEvent",	//154
    "dropEvent",	//155
    "emoticonsIndex",	//156
    "emoticonsMap",	//157
    "enabledChange",	//158
    "enterEvent",	//159
    "event",	//160
    "eventFilter",	//161
    "fileName",	//162
    "focusInEvent",	//163
    "focusNextPrevChild",	//164
    "focusOutEvent",	//165
    "fontChange",	//166
    "heightForWidth",	//167
    "hideEvent",	//168
    "i18n",	//169
    "i18n$",	//170
    "i18nc",	//171
    "i18nc$$",	//172
    "idleTime",	//173
    "idleTimeouts",	//174
    "inputMethodEvent",	//175
    "inputMethodQuery",	//176
    "installTheme",	//177
    "installTheme$",	//178
    "instance",	//179
    "isAvailable",	//180
    "isDefault",	//181
    "keyPressEvent",	//182
    "keyReleaseEvent",	//183
    "ki18n",	//184
    "ki18n$",	//185
    "ki18nc",	//186
    "ki18nc$$",	//187
    "ki18ncp",	//188
    "ki18ncp$$$",	//189
    "ki18np",	//190
    "ki18np$$",	//191
    "languageChange",	//192
    "leaveEvent",	//193
    "load",	//194
    "loadTheme",	//195
    "loadTheme$",	//196
    "metaObject",	//197
    "metric",	//198
    "minimumSizeHint",	//199
    "moduleInfo",	//200
    "mouseDoubleClickEvent",	//201
    "mouseMoveEvent",	//202
    "mousePressEvent",	//203
    "mouseReleaseEvent",	//204
    "moveEvent",	//205
    "newTheme",	//206
    "newTheme$?",	//207
    "operator!=",	//208
    "operator!=##",	//209
    "operator!=#$",	//210
    "operator!=$#",	//211
    "operator!=$$",	//212
    "operator*",	//213
    "operator*##",	//214
    "operator*#$",	//215
    "operator*$#",	//216
    "operator+",	//217
    "operator+##",	//218
    "operator+#$",	//219
    "operator+$#",	//220
    "operator+$$",	//221
    "operator++",	//222
    "operator++$",	//223
    "operator++$$",	//224
    "operator-",	//225
    "operator-#",	//226
    "operator-##",	//227
    "operator-#$",	//228
    "operator/",	//229
    "operator/#$",	//230
    "operator<",	//231
    "operator<##",	//232
    "operator<#$",	//233
    "operator<$#",	//234
    "operator<$$",	//235
    "operator<<",	//236
    "operator<<##",	//237
    "operator<<#$",	//238
    "operator<<#?",	//239
    "operator<=",	//240
    "operator<=##",	//241
    "operator<=#$",	//242
    "operator<=$#",	//243
    "operator<=$$",	//244
    "operator==",	//245
    "operator==##",	//246
    "operator==#$",	//247
    "operator==$#",	//248
    "operator==$$",	//249
    "operator>",	//250
    "operator>##",	//251
    "operator>#$",	//252
    "operator>$#",	//253
    "operator>$$",	//254
    "operator>=",	//255
    "operator>=##",	//256
    "operator>=#$",	//257
    "operator>=$#",	//258
    "operator>=$$",	//259
    "operator>>",	//260
    "operator>>##",	//261
    "operator>>#$",	//262
    "operator>>#?",	//263
    "operator|",	//264
    "operator|$$",	//265
    "paintEngine",	//266
    "paintEvent",	//267
    "paletteChange",	//268
    "parseMode",	//269
    "pluginInfos",	//270
    "pluginSelectionChanged",	//271
    "pluginSelector",	//272
    "qt_metacall",	//273
    "qt_metacall$$?",	//274
    "qt_metacast",	//275
    "qt_metacast$",	//276
    "quickHelp",	//277
    "quickHelpChanged",	//278
    "realModule",	//279
    "reject",	//280
    "removeAllIdleTimeouts",	//281
    "removeEmoticon",	//282
    "removeEmoticon$",	//283
    "removeEmoticonIndex",	//284
    "removeEmoticonIndex$?",	//285
    "removeEmoticonsMap",	//286
    "removeEmoticonsMap$",	//287
    "removeIdleTimeout",	//288
    "removeIdleTimeout$",	//289
    "resizeEvent",	//290
    "resumingFromIdle",	//291
    "rootOnlyMessage",	//292
    "save",	//293
    "setAllModules",	//294
    "setAllModules?",	//295
    "setAllowComponentSelection",	//296
    "setAllowComponentSelection$",	//297
    "setButtons",	//298
    "setButtons$",	//299
    "setCaption",	//300
    "setChangedModules",	//301
    "setChangedModules?",	//302
    "setComponentBlacklist",	//303
    "setComponentBlacklist?",	//304
    "setKCMArguments",	//305
    "setKCMArguments?",	//306
    "setParseMode",	//307
    "setParseMode$",	//308
    "setPlainCaption",	//309
    "setTheme",	//310
    "setTheme#",	//311
    "setTheme$",	//312
    "setThemeName",	//313
    "setThemeName$",	//314
    "setVisible",	//315
    "showEvent",	//316
    "showEvent#",	//317
    "simulateUserActivity",	//318
    "sizeHint",	//319
    "slotApplyClicked",	//320
    "slotButtonClicked",	//321
    "slotDefaultClicked",	//322
    "slotHelpClicked",	//323
    "slotOkClicked",	//324
    "slotUser1Clicked",	//325
    "staticMetaObject",	//326
    "stopCatchingResumeEvent",	//327
    "styleChange",	//328
    "tabletEvent",	//329
    "theme",	//330
    "theme$",	//331
    "themeList",	//332
    "themeName",	//333
    "themePath",	//334
    "timeoutReached",	//335
    "timeoutReached$",	//336
    "timeoutReached$$",	//337
    "timerEvent",	//338
    "tr",	//339
    "tr$",	//340
    "tr$$",	//341
    "tr$$$",	//342
    "tr2i18n",	//343
    "tr2i18n$",	//344
    "tr2i18n$$",	//345
    "trUtf8",	//346
    "trUtf8$",	//347
    "trUtf8$$",	//348
    "trUtf8$$$",	//349
    "updatePluginsState",	//350
    "useRootOnlyMessage",	//351
    "wheelEvent",	//352
    "windowActivationChange",	//353
    "x11Event",	//354
    "~Dialog",	//355
    "~KCModuleContainer",	//356
    "~KCModuleProxy",	//357
    "~KCMultiDialog",	//358
    "~KEmoticons",	//359
    "~KEmoticonsProvider",	//360
    "~KIdleTime",	//361
    "~KPluginSelector",	//362
    "~KPrintPreview",	//363
    "~PluginPage",	//364
};

// (classId, name (index in methodNames), argumentList index, number of args, method flags, return type (index in types), xcall() index)
static Smoke::Method methods[] = {
    { 0, 0, 0, 0, 0, 0, 0 },	// (no method)
    {3, 277, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 160, 0},	//1 KCModule::quickHelp() const
    {3, 89, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 256, 0},	//2 KCModule::aboutData() const
    {3, 316, 1, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3 KCModule::showEvent(QShowEvent*)
    {3, 72, 0, 0, Smoke::mf_static|Smoke::mf_enum, 3, 4},	//4 KCModule::NoAdditionalButton (enum)
    {3, 19, 0, 0, Smoke::mf_static|Smoke::mf_enum, 3, 5},	//5 KCModule::Help (enum)
    {3, 7, 0, 0, Smoke::mf_static|Smoke::mf_enum, 3, 6},	//6 KCModule::Default (enum)
    {3, 3, 0, 0, Smoke::mf_static|Smoke::mf_enum, 3, 7},	//7 KCModule::Apply (enum)
    {3, 17, 0, 0, Smoke::mf_static|Smoke::mf_enum, 3, 8},	//8 KCModule::Export (enum)
    {4, 197, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 285, 1},	//9 KCModuleContainer::metaObject() const
    {4, 275, 3, 1, Smoke::mf_virtual, 320, 2},	//10 KCModuleContainer::qt_metacast(const char*)
    {4, 339, 5, 2, Smoke::mf_static, 160, 3},	//11 KCModuleContainer::tr(const char*, const char*)
    {4, 346, 5, 2, Smoke::mf_static, 160, 4},	//12 KCModuleContainer::trUtf8(const char*, const char*)
    {4, 339, 8, 3, Smoke::mf_static, 160, 5},	//13 KCModuleContainer::tr(const char*, const char*, int)
    {4, 346, 8, 3, Smoke::mf_static, 160, 6},	//14 KCModuleContainer::trUtf8(const char*, const char*, int)
    {4, 273, 12, 3, Smoke::mf_virtual, 319, 7},	//15 KCModuleContainer::qt_metacall(QMetaObject::Call, int, void**)
    {4, 23, 16, 2, Smoke::mf_ctor, 4, 8},	//16 KCModuleContainer::KCModuleContainer(QWidget*, const QStringList&)
    {4, 23, 19, 2, Smoke::mf_ctor, 4, 9},	//17 KCModuleContainer::KCModuleContainer(QWidget*, const QString&)
    {4, 101, 22, 1, 0, 0, 10},	//18 KCModuleContainer::addModule(const QString&)
    {4, 293, 0, 0, Smoke::mf_virtual, 0, 11},	//19 KCModuleContainer::save()
    {4, 194, 0, 0, Smoke::mf_virtual, 0, 12},	//20 KCModuleContainer::load()
    {4, 147, 0, 0, Smoke::mf_virtual, 0, 13},	//21 KCModuleContainer::defaults()
    {4, 339, 3, 1, Smoke::mf_static, 160, 14},	//22 KCModuleContainer::tr(const char*)
    {4, 346, 3, 1, Smoke::mf_static, 160, 15},	//23 KCModuleContainer::trUtf8(const char*)
    {4, 23, 24, 1, Smoke::mf_ctor, 4, 16},	//24 KCModuleContainer::KCModuleContainer(QWidget*)
    {4, 326, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 284, 17},	//25 KCModuleContainer::staticMetaObject() const
    {4, 131, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 124, 18},	//26 KCModuleContainer::changedModules() const
    {4, 301, 26, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 19},	//27 KCModuleContainer::setChangedModules(const QList<KCModuleProxy*>&)
    {4, 123, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 124, 20},	//28 KCModuleContainer::allModules() const
    {4, 294, 26, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 21},	//29 KCModuleContainer::setAllModules(const QList<KCModuleProxy*>&)
    {4, 356, 0, 0, Smoke::mf_dtor, 0, 22 },	//30 KCModuleContainer::~KCModuleContainer()
    {6, 197, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 285, 1},	//31 KCModuleProxy::metaObject() const
    {6, 275, 3, 1, Smoke::mf_virtual, 320, 2},	//32 KCModuleProxy::qt_metacast(const char*)
    {6, 339, 5, 2, Smoke::mf_static, 160, 3},	//33 KCModuleProxy::tr(const char*, const char*)
    {6, 346, 5, 2, Smoke::mf_static, 160, 4},	//34 KCModuleProxy::trUtf8(const char*, const char*)
    {6, 339, 8, 3, Smoke::mf_static, 160, 5},	//35 KCModuleProxy::tr(const char*, const char*, int)
    {6, 346, 8, 3, Smoke::mf_static, 160, 6},	//36 KCModuleProxy::trUtf8(const char*, const char*, int)
    {6, 273, 12, 3, Smoke::mf_virtual, 319, 7},	//37 KCModuleProxy::qt_metacall(QMetaObject::Call, int, void**)
    {6, 27, 28, 3, Smoke::mf_ctor, 7, 8},	//38 KCModuleProxy::KCModuleProxy(const KCModuleInfo&, QWidget*, const QStringList&)
    {6, 27, 32, 3, Smoke::mf_ctor, 7, 9},	//39 KCModuleProxy::KCModuleProxy(const QString&, QWidget*, const QStringList&)
    {6, 27, 36, 3, Smoke::mf_ctor, 7, 10},	//40 KCModuleProxy::KCModuleProxy(const KSharedPtr<KService>&, QWidget*, const QStringList&)
    {6, 194, 0, 0, 0, 0, 11},	//41 KCModuleProxy::load()
    {6, 293, 0, 0, 0, 0, 12},	//42 KCModuleProxy::save()
    {6, 277, 0, 0, Smoke::mf_const, 160, 13},	//43 KCModuleProxy::quickHelp() const
    {6, 89, 0, 0, Smoke::mf_const, 256, 14},	//44 KCModuleProxy::aboutData() const
    {6, 125, 0, 0, Smoke::mf_const, 68, 15},	//45 KCModuleProxy::buttons() const
    {6, 292, 0, 0, Smoke::mf_const, 160, 16},	//46 KCModuleProxy::rootOnlyMessage() const
    {6, 351, 0, 0, Smoke::mf_const, 254, 17},	//47 KCModuleProxy::useRootOnlyMessage() const
    {6, 137, 0, 0, Smoke::mf_const, 10, 18},	//48 KCModuleProxy::componentData() const
    {6, 128, 0, 0, Smoke::mf_const, 254, 19},	//49 KCModuleProxy::changed() const
    {6, 279, 0, 0, Smoke::mf_const, 2, 20},	//50 KCModuleProxy::realModule() const
    {6, 200, 0, 0, Smoke::mf_const, 5, 21},	//51 KCModuleProxy::moduleInfo() const
    {6, 146, 0, 0, Smoke::mf_const, 160, 22},	//52 KCModuleProxy::dbusService() const
    {6, 145, 0, 0, Smoke::mf_const, 160, 23},	//53 KCModuleProxy::dbusPath() const
    {6, 199, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 155, 24},	//54 KCModuleProxy::minimumSizeHint() const
    {6, 147, 0, 0, Smoke::mf_slot, 0, 25},	//55 KCModuleProxy::defaults()
    {6, 148, 0, 0, Smoke::mf_slot, 0, 26},	//56 KCModuleProxy::deleteClient()
    {6, 128, 40, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 27},	//57 KCModuleProxy::changed(bool)
    {6, 128, 42, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 28},	//58 KCModuleProxy::changed(KCModuleProxy*)
    {6, 132, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 29},	//59 KCModuleProxy::childClosed()
    {6, 278, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 30},	//60 KCModuleProxy::quickHelpChanged()
    {6, 316, 1, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 31},	//61 KCModuleProxy::showEvent(QShowEvent*)
    {6, 339, 3, 1, Smoke::mf_static, 160, 32},	//62 KCModuleProxy::tr(const char*)
    {6, 346, 3, 1, Smoke::mf_static, 160, 33},	//63 KCModuleProxy::trUtf8(const char*)
    {6, 27, 44, 1, Smoke::mf_ctor, 7, 34},	//64 KCModuleProxy::KCModuleProxy(const KCModuleInfo&)
    {6, 27, 46, 2, Smoke::mf_ctor, 7, 35},	//65 KCModuleProxy::KCModuleProxy(const KCModuleInfo&, QWidget*)
    {6, 27, 22, 1, Smoke::mf_ctor, 7, 36},	//66 KCModuleProxy::KCModuleProxy(const QString&)
    {6, 27, 49, 2, Smoke::mf_ctor, 7, 37},	//67 KCModuleProxy::KCModuleProxy(const QString&, QWidget*)
    {6, 27, 52, 1, Smoke::mf_ctor, 7, 38},	//68 KCModuleProxy::KCModuleProxy(const KSharedPtr<KService>&)
    {6, 27, 54, 2, Smoke::mf_ctor, 7, 39},	//69 KCModuleProxy::KCModuleProxy(const KSharedPtr<KService>&, QWidget*)
    {6, 326, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 284, 40},	//70 KCModuleProxy::staticMetaObject() const
    {6, 357, 0, 0, Smoke::mf_dtor, 0, 41 },	//71 KCModuleProxy::~KCModuleProxy()
    {7, 197, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 285, 1},	//72 KCMultiDialog::metaObject() const
    {7, 275, 3, 1, Smoke::mf_virtual, 320, 2},	//73 KCMultiDialog::qt_metacast(const char*)
    {7, 339, 5, 2, Smoke::mf_static, 160, 3},	//74 KCMultiDialog::tr(const char*, const char*)
    {7, 346, 5, 2, Smoke::mf_static, 160, 4},	//75 KCMultiDialog::trUtf8(const char*, const char*)
    {7, 339, 8, 3, Smoke::mf_static, 160, 5},	//76 KCMultiDialog::tr(const char*, const char*, int)
    {7, 346, 8, 3, Smoke::mf_static, 160, 6},	//77 KCMultiDialog::trUtf8(const char*, const char*, int)
    {7, 273, 12, 3, Smoke::mf_virtual, 319, 7},	//78 KCMultiDialog::qt_metacall(QMetaObject::Call, int, void**)
    {7, 37, 24, 1, Smoke::mf_ctor, 8, 8},	//79 KCMultiDialog::KCMultiDialog(QWidget*)
    {7, 101, 57, 2, 0, 30, 9},	//80 KCMultiDialog::addModule(const QString&, const QStringList&)
    {7, 101, 60, 3, 0, 30, 10},	//81 KCMultiDialog::addModule(const KCModuleInfo&, KPageWidgetItem*, const QStringList&)
    {7, 134, 0, 0, 0, 0, 11},	//82 KCMultiDialog::clear()
    {7, 298, 64, 1, 0, 0, 12},	//83 KCMultiDialog::setButtons(QFlags<KDialog::ButtonCode>)
    {7, 138, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 13},	//84 KCMultiDialog::configCommitted()
    {7, 138, 66, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 14},	//85 KCMultiDialog::configCommitted(const QByteArray&)
    {7, 37, 68, 3, Smoke::mf_ctor|Smoke::mf_protected, 8, 15},	//86 KCMultiDialog::KCMultiDialog(KPageWidget*, QWidget*, QFlags<Qt::WindowType>)
    {7, 37, 72, 4, Smoke::mf_ctor|Smoke::mf_protected, 8, 16},	//87 KCMultiDialog::KCMultiDialog(KCMultiDialogPrivate&, KPageWidget*, QWidget*, QFlags<Qt::WindowType>)
    {7, 322, 0, 0, Smoke::mf_protected|Smoke::mf_slot, 0, 17},	//88 KCMultiDialog::slotDefaultClicked()
    {7, 325, 0, 0, Smoke::mf_protected|Smoke::mf_slot, 0, 18},	//89 KCMultiDialog::slotUser1Clicked()
    {7, 320, 0, 0, Smoke::mf_protected|Smoke::mf_slot, 0, 19},	//90 KCMultiDialog::slotApplyClicked()
    {7, 324, 0, 0, Smoke::mf_protected|Smoke::mf_slot, 0, 20},	//91 KCMultiDialog::slotOkClicked()
    {7, 323, 0, 0, Smoke::mf_protected|Smoke::mf_slot, 0, 21},	//92 KCMultiDialog::slotHelpClicked()
    {7, 339, 3, 1, Smoke::mf_static, 160, 22},	//93 KCMultiDialog::tr(const char*)
    {7, 346, 3, 1, Smoke::mf_static, 160, 23},	//94 KCMultiDialog::trUtf8(const char*)
    {7, 37, 0, 0, Smoke::mf_ctor, 8, 24},	//95 KCMultiDialog::KCMultiDialog()
    {7, 101, 22, 1, 0, 30, 25},	//96 KCMultiDialog::addModule(const QString&)
    {7, 101, 44, 1, 0, 30, 26},	//97 KCMultiDialog::addModule(const KCModuleInfo&)
    {7, 101, 77, 2, 0, 30, 27},	//98 KCMultiDialog::addModule(const KCModuleInfo&, KPageWidgetItem*)
    {7, 37, 80, 2, Smoke::mf_ctor|Smoke::mf_protected, 8, 28},	//99 KCMultiDialog::KCMultiDialog(KPageWidget*, QWidget*)
    {7, 37, 83, 3, Smoke::mf_ctor|Smoke::mf_protected, 8, 29},	//100 KCMultiDialog::KCMultiDialog(KCMultiDialogPrivate&, KPageWidget*, QWidget*)
    {7, 326, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 284, 30},	//101 KCMultiDialog::staticMetaObject() const
    {7, 358, 0, 0, Smoke::mf_dtor, 0, 31 },	//102 KCMultiDialog::~KCMultiDialog()
    {10, 319, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 155, 0},	//103 KDialog::sizeHint() const
    {10, 199, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 155, 0},	//104 KDialog::minimumSizeHint() const
    {10, 300, 22, 1, Smoke::mf_virtual|Smoke::mf_slot, 0, 0},	//105 KDialog::setCaption(const QString&)
    {10, 300, 87, 2, Smoke::mf_virtual|Smoke::mf_slot, 0, 0},	//106 KDialog::setCaption(const QString&, bool)
    {10, 309, 22, 1, Smoke::mf_virtual|Smoke::mf_slot, 0, 0},	//107 KDialog::setPlainCaption(const QString&)
    {10, 168, 90, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//108 KDialog::hideEvent(QHideEvent*)
    {10, 136, 92, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//109 KDialog::closeEvent(QCloseEvent*)
    {10, 182, 94, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//110 KDialog::keyPressEvent(QKeyEvent*)
    {10, 321, 96, 1, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_slot, 0, 0},	//111 KDialog::slotButtonClicked(int)
    {10, 75, 0, 0, Smoke::mf_static|Smoke::mf_enum, 13, 10},	//112 KDialog::None (enum)
    {10, 19, 0, 0, Smoke::mf_static|Smoke::mf_enum, 13, 11},	//113 KDialog::Help (enum)
    {10, 7, 0, 0, Smoke::mf_static|Smoke::mf_enum, 13, 12},	//114 KDialog::Default (enum)
    {10, 76, 0, 0, Smoke::mf_static|Smoke::mf_enum, 13, 13},	//115 KDialog::Ok (enum)
    {10, 3, 0, 0, Smoke::mf_static|Smoke::mf_enum, 13, 14},	//116 KDialog::Apply (enum)
    {10, 84, 0, 0, Smoke::mf_static|Smoke::mf_enum, 13, 15},	//117 KDialog::Try (enum)
    {10, 4, 0, 0, Smoke::mf_static|Smoke::mf_enum, 13, 16},	//118 KDialog::Cancel (enum)
    {10, 5, 0, 0, Smoke::mf_static|Smoke::mf_enum, 13, 17},	//119 KDialog::Close (enum)
    {10, 71, 0, 0, Smoke::mf_static|Smoke::mf_enum, 13, 18},	//120 KDialog::No (enum)
    {10, 88, 0, 0, Smoke::mf_static|Smoke::mf_enum, 13, 19},	//121 KDialog::Yes (enum)
    {10, 83, 0, 0, Smoke::mf_static|Smoke::mf_enum, 13, 20},	//122 KDialog::Reset (enum)
    {10, 9, 0, 0, Smoke::mf_static|Smoke::mf_enum, 13, 21},	//123 KDialog::Details (enum)
    {10, 85, 0, 0, Smoke::mf_static|Smoke::mf_enum, 13, 22},	//124 KDialog::User1 (enum)
    {10, 86, 0, 0, Smoke::mf_static|Smoke::mf_enum, 13, 23},	//125 KDialog::User2 (enum)
    {10, 87, 0, 0, Smoke::mf_static|Smoke::mf_enum, 13, 24},	//126 KDialog::User3 (enum)
    {10, 74, 0, 0, Smoke::mf_static|Smoke::mf_enum, 13, 25},	//127 KDialog::NoDefault (enum)
    {10, 73, 0, 0, Smoke::mf_static|Smoke::mf_enum, 14, 26},	//128 KDialog::NoCaptionFlags (enum)
    {10, 2, 0, 0, Smoke::mf_static|Smoke::mf_enum, 14, 27},	//129 KDialog::AppNameCaption (enum)
    {10, 70, 0, 0, Smoke::mf_static|Smoke::mf_enum, 14, 28},	//130 KDialog::ModifiedCaption (enum)
    {10, 18, 0, 0, Smoke::mf_static|Smoke::mf_enum, 14, 29},	//131 KDialog::HIGCompliantCaption (enum)
    {11, 197, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 285, 1},	//132 KEmoticons::metaObject() const
    {11, 275, 3, 1, Smoke::mf_virtual, 320, 2},	//133 KEmoticons::qt_metacast(const char*)
    {11, 339, 5, 2, Smoke::mf_static, 160, 3},	//134 KEmoticons::tr(const char*, const char*)
    {11, 346, 5, 2, Smoke::mf_static, 160, 4},	//135 KEmoticons::trUtf8(const char*, const char*)
    {11, 339, 8, 3, Smoke::mf_static, 160, 5},	//136 KEmoticons::tr(const char*, const char*, int)
    {11, 346, 8, 3, Smoke::mf_static, 160, 6},	//137 KEmoticons::trUtf8(const char*, const char*, int)
    {11, 273, 12, 3, Smoke::mf_virtual, 319, 7},	//138 KEmoticons::qt_metacall(QMetaObject::Call, int, void**)
    {11, 43, 0, 0, Smoke::mf_ctor, 15, 8},	//139 KEmoticons::KEmoticons()
    {11, 330, 0, 0, 0, 18, 9},	//140 KEmoticons::theme()
    {11, 330, 22, 1, 0, 18, 10},	//141 KEmoticons::theme(const QString&)
    {11, 143, 0, 0, Smoke::mf_static, 160, 11},	//142 KEmoticons::currentThemeName()
    {11, 332, 0, 0, Smoke::mf_static, 164, 12},	//143 KEmoticons::themeList()
    {11, 310, 98, 1, Smoke::mf_static, 0, 13},	//144 KEmoticons::setTheme(const KEmoticonsTheme&)
    {11, 310, 22, 1, Smoke::mf_static, 0, 14},	//145 KEmoticons::setTheme(const QString&)
    {11, 206, 100, 2, 0, 18, 15},	//146 KEmoticons::newTheme(const QString&, const KSharedPtr<KService>&)
    {11, 177, 22, 1, 0, 164, 16},	//147 KEmoticons::installTheme(const QString&)
    {11, 307, 103, 1, Smoke::mf_static, 0, 17},	//148 KEmoticons::setParseMode(QFlags<KEmoticonsTheme::ParseModeEnum>)
    {11, 269, 0, 0, Smoke::mf_static, 73, 18},	//149 KEmoticons::parseMode()
    {11, 339, 3, 1, Smoke::mf_static, 160, 19},	//150 KEmoticons::tr(const char*)
    {11, 346, 3, 1, Smoke::mf_static, 160, 20},	//151 KEmoticons::trUtf8(const char*)
    {11, 326, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 284, 21},	//152 KEmoticons::staticMetaObject() const
    {11, 359, 0, 0, Smoke::mf_dtor, 0, 22 },	//153 KEmoticons::~KEmoticons()
    {12, 197, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 285, 1},	//154 KEmoticonsProvider::metaObject() const
    {12, 275, 3, 1, Smoke::mf_virtual, 320, 2},	//155 KEmoticonsProvider::qt_metacast(const char*)
    {12, 339, 5, 2, Smoke::mf_static, 160, 3},	//156 KEmoticonsProvider::tr(const char*, const char*)
    {12, 346, 5, 2, Smoke::mf_static, 160, 4},	//157 KEmoticonsProvider::trUtf8(const char*, const char*)
    {12, 339, 8, 3, Smoke::mf_static, 160, 5},	//158 KEmoticonsProvider::tr(const char*, const char*, int)
    {12, 346, 8, 3, Smoke::mf_static, 160, 6},	//159 KEmoticonsProvider::trUtf8(const char*, const char*, int)
    {12, 273, 12, 3, Smoke::mf_virtual, 319, 7},	//160 KEmoticonsProvider::qt_metacall(QMetaObject::Call, int, void**)
    {12, 44, 105, 1, Smoke::mf_ctor, 16, 8},	//161 KEmoticonsProvider::KEmoticonsProvider(QObject*)
    {12, 195, 22, 1, Smoke::mf_virtual, 254, 9},	//162 KEmoticonsProvider::loadTheme(const QString&)
    {12, 282, 22, 1, Smoke::mf_virtual, 254, 10},	//163 KEmoticonsProvider::removeEmoticon(const QString&)
    {12, 92, 107, 3, Smoke::mf_virtual, 254, 11},	//164 KEmoticonsProvider::addEmoticon(const QString&, const QString&, KEmoticonsProvider::AddEmoticonOption)
    {12, 293, 0, 0, Smoke::mf_virtual, 0, 12},	//165 KEmoticonsProvider::save()
    {12, 333, 0, 0, Smoke::mf_const, 160, 13},	//166 KEmoticonsProvider::themeName() const
    {12, 313, 22, 1, 0, 0, 14},	//167 KEmoticonsProvider::setThemeName(const QString&)
    {12, 334, 0, 0, Smoke::mf_const, 160, 15},	//168 KEmoticonsProvider::themePath() const
    {12, 162, 0, 0, Smoke::mf_const, 160, 16},	//169 KEmoticonsProvider::fileName() const
    {12, 157, 0, 0, Smoke::mf_const, 108, 17},	//170 KEmoticonsProvider::emoticonsMap() const
    {12, 156, 0, 0, Smoke::mf_const, 107, 18},	//171 KEmoticonsProvider::emoticonsIndex() const
    {12, 142, 0, 0, Smoke::mf_virtual, 0, 19},	//172 KEmoticonsProvider::createNew()
    {12, 135, 0, 0, Smoke::mf_protected, 0, 20},	//173 KEmoticonsProvider::clearEmoticonsMap()
    {12, 97, 111, 2, Smoke::mf_protected, 0, 21},	//174 KEmoticonsProvider::addEmoticonsMap(QString, QStringList)
    {12, 286, 114, 1, Smoke::mf_protected, 0, 22},	//175 KEmoticonsProvider::removeEmoticonsMap(QString)
    {12, 95, 57, 2, Smoke::mf_protected, 0, 23},	//176 KEmoticonsProvider::addEmoticonIndex(const QString&, const QStringList&)
    {12, 284, 57, 2, Smoke::mf_protected, 0, 24},	//177 KEmoticonsProvider::removeEmoticonIndex(const QString&, const QStringList&)
    {12, 339, 3, 1, Smoke::mf_static, 160, 25},	//178 KEmoticonsProvider::tr(const char*)
    {12, 346, 3, 1, Smoke::mf_static, 160, 26},	//179 KEmoticonsProvider::trUtf8(const char*)
    {12, 44, 0, 0, Smoke::mf_ctor, 16, 27},	//180 KEmoticonsProvider::KEmoticonsProvider()
    {12, 92, 116, 2, 0, 254, 28},	//181 KEmoticonsProvider::addEmoticon(const QString&, const QString&)
    {12, 326, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 284, 29},	//182 KEmoticonsProvider::staticMetaObject() const
    {12, 14, 0, 0, Smoke::mf_static|Smoke::mf_enum, 17, 30},	//183 KEmoticonsProvider::DoNotCopy (enum)
    {12, 6, 0, 0, Smoke::mf_static|Smoke::mf_enum, 17, 31},	//184 KEmoticonsProvider::Copy (enum)
    {12, 360, 0, 0, Smoke::mf_dtor, 0, 32 },	//185 KEmoticonsProvider::~KEmoticonsProvider()
    {14, 197, 0, 0, Smoke::mf_const, 285, 1},	//186 KIdleTime::metaObject() const
    {14, 275, 3, 1, 0, 320, 2},	//187 KIdleTime::qt_metacast(const char*)
    {14, 339, 5, 2, Smoke::mf_static, 160, 3},	//188 KIdleTime::tr(const char*, const char*)
    {14, 346, 5, 2, Smoke::mf_static, 160, 4},	//189 KIdleTime::trUtf8(const char*, const char*)
    {14, 339, 8, 3, Smoke::mf_static, 160, 5},	//190 KIdleTime::tr(const char*, const char*, int)
    {14, 346, 8, 3, Smoke::mf_static, 160, 6},	//191 KIdleTime::trUtf8(const char*, const char*, int)
    {14, 273, 12, 3, 0, 319, 7},	//192 KIdleTime::qt_metacall(QMetaObject::Call, int, void**)
    {14, 179, 0, 0, Smoke::mf_static, 23, 8},	//193 KIdleTime::instance()
    {14, 173, 0, 0, Smoke::mf_const, 319, 9},	//194 KIdleTime::idleTime() const
    {14, 174, 0, 0, Smoke::mf_const, 109, 10},	//195 KIdleTime::idleTimeouts() const
    {14, 318, 0, 0, 0, 0, 11},	//196 KIdleTime::simulateUserActivity()
    {14, 99, 96, 1, Smoke::mf_slot, 319, 12},	//197 KIdleTime::addIdleTimeout(int)
    {14, 288, 96, 1, Smoke::mf_slot, 0, 13},	//198 KIdleTime::removeIdleTimeout(int)
    {14, 281, 0, 0, Smoke::mf_slot, 0, 14},	//199 KIdleTime::removeAllIdleTimeouts()
    {14, 126, 0, 0, Smoke::mf_slot, 0, 15},	//200 KIdleTime::catchNextResumeEvent()
    {14, 327, 0, 0, Smoke::mf_slot, 0, 16},	//201 KIdleTime::stopCatchingResumeEvent()
    {14, 291, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 17},	//202 KIdleTime::resumingFromIdle()
    {14, 335, 96, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 18},	//203 KIdleTime::timeoutReached(int)
    {14, 335, 119, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 19},	//204 KIdleTime::timeoutReached(int, int)
    {14, 339, 3, 1, Smoke::mf_static, 160, 20},	//205 KIdleTime::tr(const char*)
    {14, 346, 3, 1, Smoke::mf_static, 160, 21},	//206 KIdleTime::trUtf8(const char*)
    {14, 326, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 284, 22},	//207 KIdleTime::staticMetaObject() const
    {14, 361, 0, 0, Smoke::mf_dtor, 0, 23 },	//208 KIdleTime::~KIdleTime()
    {20, 197, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 285, 1},	//209 KPluginSelector::metaObject() const
    {20, 275, 3, 1, Smoke::mf_virtual, 320, 2},	//210 KPluginSelector::qt_metacast(const char*)
    {20, 339, 5, 2, Smoke::mf_static, 160, 3},	//211 KPluginSelector::tr(const char*, const char*)
    {20, 346, 5, 2, Smoke::mf_static, 160, 4},	//212 KPluginSelector::trUtf8(const char*, const char*)
    {20, 339, 8, 3, Smoke::mf_static, 160, 5},	//213 KPluginSelector::tr(const char*, const char*, int)
    {20, 346, 8, 3, Smoke::mf_static, 160, 6},	//214 KPluginSelector::trUtf8(const char*, const char*, int)
    {20, 273, 12, 3, Smoke::mf_virtual, 319, 7},	//215 KPluginSelector::qt_metacall(QMetaObject::Call, int, void**)
    {20, 46, 24, 1, Smoke::mf_ctor, 32, 8},	//216 KPluginSelector::KPluginSelector(QWidget*)
    {20, 109, 122, 4, 0, 0, 9},	//217 KPluginSelector::addPlugins(const QString&, const QString&, const QString&, KSharedPtr<KSharedConfig>)
    {20, 109, 127, 4, 0, 0, 10},	//218 KPluginSelector::addPlugins(const KComponentData&, const QString&, const QString&, const KSharedPtr<KSharedConfig>&)
    {20, 109, 132, 5, 0, 0, 11},	//219 KPluginSelector::addPlugins(const QList<KPluginInfo>&, KPluginSelector::PluginLoadMethod, const QString&, const QString&, const KSharedPtr<KSharedConfig>&)
    {20, 194, 0, 0, 0, 0, 12},	//220 KPluginSelector::load()
    {20, 293, 0, 0, 0, 0, 13},	//221 KPluginSelector::save()
    {20, 147, 0, 0, 0, 0, 14},	//222 KPluginSelector::defaults()
    {20, 181, 0, 0, Smoke::mf_const, 254, 15},	//223 KPluginSelector::isDefault() const
    {20, 350, 0, 0, 0, 0, 16},	//224 KPluginSelector::updatePluginsState()
    {20, 128, 40, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 17},	//225 KPluginSelector::changed(bool)
    {20, 138, 66, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 18},	//226 KPluginSelector::configCommitted(const QByteArray&)
    {20, 339, 3, 1, Smoke::mf_static, 160, 19},	//227 KPluginSelector::tr(const char*)
    {20, 346, 3, 1, Smoke::mf_static, 160, 20},	//228 KPluginSelector::trUtf8(const char*)
    {20, 46, 0, 0, Smoke::mf_ctor, 32, 21},	//229 KPluginSelector::KPluginSelector()
    {20, 109, 22, 1, 0, 0, 22},	//230 KPluginSelector::addPlugins(const QString&)
    {20, 109, 116, 2, 0, 0, 23},	//231 KPluginSelector::addPlugins(const QString&, const QString&)
    {20, 109, 138, 3, 0, 0, 24},	//232 KPluginSelector::addPlugins(const QString&, const QString&, const QString&)
    {20, 109, 142, 1, 0, 0, 25},	//233 KPluginSelector::addPlugins(const KComponentData&)
    {20, 109, 144, 2, 0, 0, 26},	//234 KPluginSelector::addPlugins(const KComponentData&, const QString&)
    {20, 109, 147, 3, 0, 0, 27},	//235 KPluginSelector::addPlugins(const KComponentData&, const QString&, const QString&)
    {20, 109, 151, 1, 0, 0, 28},	//236 KPluginSelector::addPlugins(const QList<KPluginInfo>&)
    {20, 109, 153, 2, 0, 0, 29},	//237 KPluginSelector::addPlugins(const QList<KPluginInfo>&, KPluginSelector::PluginLoadMethod)
    {20, 109, 156, 3, 0, 0, 30},	//238 KPluginSelector::addPlugins(const QList<KPluginInfo>&, KPluginSelector::PluginLoadMethod, const QString&)
    {20, 109, 160, 4, 0, 0, 31},	//239 KPluginSelector::addPlugins(const QList<KPluginInfo>&, KPluginSelector::PluginLoadMethod, const QString&, const QString&)
    {20, 326, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 284, 32},	//240 KPluginSelector::staticMetaObject() const
    {20, 81, 0, 0, Smoke::mf_static|Smoke::mf_enum, 33, 33},	//241 KPluginSelector::ReadConfigFile (enum)
    {20, 20, 0, 0, Smoke::mf_static|Smoke::mf_enum, 33, 34},	//242 KPluginSelector::IgnoreConfigFile (enum)
    {20, 362, 0, 0, Smoke::mf_dtor, 0, 35 },	//243 KPluginSelector::~KPluginSelector()
    {21, 197, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 285, 1},	//244 KPrintPreview::metaObject() const
    {21, 275, 3, 1, Smoke::mf_virtual, 320, 2},	//245 KPrintPreview::qt_metacast(const char*)
    {21, 339, 5, 2, Smoke::mf_static, 160, 3},	//246 KPrintPreview::tr(const char*, const char*)
    {21, 346, 5, 2, Smoke::mf_static, 160, 4},	//247 KPrintPreview::trUtf8(const char*, const char*)
    {21, 339, 8, 3, Smoke::mf_static, 160, 5},	//248 KPrintPreview::tr(const char*, const char*, int)
    {21, 346, 8, 3, Smoke::mf_static, 160, 6},	//249 KPrintPreview::trUtf8(const char*, const char*, int)
    {21, 273, 12, 3, Smoke::mf_virtual, 319, 7},	//250 KPrintPreview::qt_metacall(QMetaObject::Call, int, void**)
    {21, 48, 165, 2, Smoke::mf_ctor, 34, 8},	//251 KPrintPreview::KPrintPreview(QPrinter*, QWidget*)
    {21, 180, 0, 0, Smoke::mf_static, 254, 9},	//252 KPrintPreview::isAvailable()
    {21, 316, 1, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 10},	//253 KPrintPreview::showEvent(QShowEvent*)
    {21, 339, 3, 1, Smoke::mf_static, 160, 11},	//254 KPrintPreview::tr(const char*)
    {21, 346, 3, 1, Smoke::mf_static, 160, 12},	//255 KPrintPreview::trUtf8(const char*)
    {21, 48, 168, 1, Smoke::mf_ctor, 34, 13},	//256 KPrintPreview::KPrintPreview(QPrinter*)
    {21, 326, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 284, 14},	//257 KPrintPreview::staticMetaObject() const
    {21, 363, 0, 0, Smoke::mf_dtor, 0, 15 },	//258 KPrintPreview::~KPrintPreview()
    {24, 197, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 285, 1},	//259 KSettings::Dialog::metaObject() const
    {24, 275, 3, 1, Smoke::mf_virtual, 320, 2},	//260 KSettings::Dialog::qt_metacast(const char*)
    {24, 339, 5, 2, Smoke::mf_static, 160, 3},	//261 KSettings::Dialog::tr(const char*, const char*)
    {24, 346, 5, 2, Smoke::mf_static, 160, 4},	//262 KSettings::Dialog::trUtf8(const char*, const char*)
    {24, 339, 8, 3, Smoke::mf_static, 160, 5},	//263 KSettings::Dialog::tr(const char*, const char*, int)
    {24, 346, 8, 3, Smoke::mf_static, 160, 6},	//264 KSettings::Dialog::trUtf8(const char*, const char*, int)
    {24, 273, 12, 3, Smoke::mf_virtual, 319, 7},	//265 KSettings::Dialog::qt_metacall(QMetaObject::Call, int, void**)
    {24, 10, 24, 1, Smoke::mf_ctor, 37, 8},	//266 KSettings::Dialog::Dialog(QWidget*)
    {24, 10, 170, 2, Smoke::mf_ctor, 37, 9},	//267 KSettings::Dialog::Dialog(const QStringList&, QWidget*)
    {24, 107, 151, 1, 0, 0, 10},	//268 KSettings::Dialog::addPluginInfos(const QList<KPluginInfo>&)
    {24, 305, 173, 1, 0, 0, 11},	//269 KSettings::Dialog::setKCMArguments(const QStringList&)
    {24, 303, 173, 1, 0, 0, 12},	//270 KSettings::Dialog::setComponentBlacklist(const QStringList&)
    {24, 296, 40, 1, 0, 0, 13},	//271 KSettings::Dialog::setAllowComponentSelection(bool)
    {24, 124, 0, 0, Smoke::mf_const, 254, 14},	//272 KSettings::Dialog::allowComponentSelection() const
    {24, 270, 0, 0, Smoke::mf_const, 125, 15},	//273 KSettings::Dialog::pluginInfos() const
    {24, 316, 1, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 16},	//274 KSettings::Dialog::showEvent(QShowEvent*)
    {24, 271, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 17},	//275 KSettings::Dialog::pluginSelectionChanged()
    {24, 339, 3, 1, Smoke::mf_static, 160, 18},	//276 KSettings::Dialog::tr(const char*)
    {24, 346, 3, 1, Smoke::mf_static, 160, 19},	//277 KSettings::Dialog::trUtf8(const char*)
    {24, 10, 0, 0, Smoke::mf_ctor, 37, 20},	//278 KSettings::Dialog::Dialog()
    {24, 10, 173, 1, Smoke::mf_ctor, 37, 21},	//279 KSettings::Dialog::Dialog(const QStringList&)
    {24, 326, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 284, 22},	//280 KSettings::Dialog::staticMetaObject() const
    {24, 355, 0, 0, Smoke::mf_dtor, 0, 23 },	//281 KSettings::Dialog::~Dialog()
    {25, 197, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 285, 1},	//282 KSettings::PluginPage::metaObject() const
    {25, 275, 3, 1, Smoke::mf_virtual, 320, 2},	//283 KSettings::PluginPage::qt_metacast(const char*)
    {25, 339, 5, 2, Smoke::mf_static, 160, 3},	//284 KSettings::PluginPage::tr(const char*, const char*)
    {25, 346, 5, 2, Smoke::mf_static, 160, 4},	//285 KSettings::PluginPage::trUtf8(const char*, const char*)
    {25, 339, 8, 3, Smoke::mf_static, 160, 5},	//286 KSettings::PluginPage::tr(const char*, const char*, int)
    {25, 346, 8, 3, Smoke::mf_static, 160, 6},	//287 KSettings::PluginPage::trUtf8(const char*, const char*, int)
    {25, 273, 12, 3, Smoke::mf_virtual, 319, 7},	//288 KSettings::PluginPage::qt_metacall(QMetaObject::Call, int, void**)
    {25, 77, 175, 3, Smoke::mf_ctor, 38, 8},	//289 KSettings::PluginPage::PluginPage(const KComponentData&, QWidget*, const QList<QVariant>&)
    {25, 272, 0, 0, 0, 32, 9},	//290 KSettings::PluginPage::pluginSelector()
    {25, 194, 0, 0, Smoke::mf_virtual, 0, 10},	//291 KSettings::PluginPage::load()
    {25, 293, 0, 0, Smoke::mf_virtual, 0, 11},	//292 KSettings::PluginPage::save()
    {25, 147, 0, 0, Smoke::mf_virtual, 0, 12},	//293 KSettings::PluginPage::defaults()
    {25, 339, 3, 1, Smoke::mf_static, 160, 13},	//294 KSettings::PluginPage::tr(const char*)
    {25, 346, 3, 1, Smoke::mf_static, 160, 14},	//295 KSettings::PluginPage::trUtf8(const char*)
    {25, 77, 142, 1, Smoke::mf_ctor, 38, 15},	//296 KSettings::PluginPage::PluginPage(const KComponentData&)
    {25, 77, 179, 2, Smoke::mf_ctor, 38, 16},	//297 KSettings::PluginPage::PluginPage(const KComponentData&, QWidget*)
    {25, 326, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 284, 17},	//298 KSettings::PluginPage::staticMetaObject() const
    {25, 364, 0, 0, Smoke::mf_dtor, 0, 18 },	//299 KSettings::PluginPage::~PluginPage()
    {40, 315, 40, 1, Smoke::mf_virtual, 0, 0},	//300 QDialog::setVisible(bool)
    {40, 151, 96, 1, Smoke::mf_virtual|Smoke::mf_slot, 0, 0},	//301 QDialog::done(int)
    {40, 90, 0, 0, Smoke::mf_virtual|Smoke::mf_slot, 0, 0},	//302 QDialog::accept()
    {40, 280, 0, 0, Smoke::mf_virtual|Smoke::mf_slot, 0, 0},	//303 QDialog::reject()
    {40, 316, 1, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//304 QDialog::showEvent(QShowEvent*)
    {40, 290, 182, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//305 QDialog::resizeEvent(QResizeEvent*)
    {40, 141, 184, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//306 QDialog::contextMenuEvent(QContextMenuEvent*)
    {40, 161, 186, 2, Smoke::mf_protected|Smoke::mf_virtual, 254, 0},	//307 QDialog::eventFilter(QObject*, QEvent*)
    {48, 264, 189, 2, Smoke::mf_static, 114, 1},	//308 QGlobalSpace::operator|(Qt::DockWidgetArea, int)
    {48, 213, 192, 2, Smoke::mf_static, 289, 2},	//309 QGlobalSpace::operator*(const QPoint&, double)
    {48, 213, 195, 2, Smoke::mf_static, 291, 3},	//310 QGlobalSpace::operator*(double, const QPointF&)
    {48, 264, 198, 2, Smoke::mf_static, 98, 4},	//311 QGlobalSpace::operator|(Qt::MouseButton, QFlags<Qt::MouseButton>)
    {48, 208, 201, 2, Smoke::mf_static, 254, 5},	//312 QGlobalSpace::operator!=(const QMargins&, const QMargins&)
    {48, 213, 204, 2, Smoke::mf_static, 301, 6},	//313 QGlobalSpace::operator*(double, const QSizeF&)
    {48, 260, 207, 2, Smoke::mf_static, 60, 7},	//314 QGlobalSpace::operator>>(QDataStream&, QImage&)
    {48, 236, 210, 2, Smoke::mf_static, 60, 8},	//315 QGlobalSpace::operator<<(QDataStream&, const QSizePolicy&)
    {48, 264, 213, 2, Smoke::mf_static, 114, 9},	//316 QGlobalSpace::operator|(Qt::InputMethodHint, int)
    {48, 264, 216, 2, Smoke::mf_static, 75, 10},	//317 QGlobalSpace::operator|(KLocale::DateTimeFormatOption, KLocale::DateTimeFormatOption)
    {48, 208, 219, 2, Smoke::mf_static, 254, 11},	//318 QGlobalSpace::operator!=(const QRect&, const QRect&)
    {48, 217, 222, 2, Smoke::mf_static, 299, 12},	//319 QGlobalSpace::operator+(const QSize&, const QSize&)
    {48, 236, 225, 2, Smoke::mf_static, 60, 13},	//320 QGlobalSpace::operator<<(QDataStream&, const QTransform&)
    {48, 213, 228, 2, Smoke::mf_static, 141, 14},	//321 QGlobalSpace::operator*(const QPointF&, const QMatrix&)
    {48, 236, 231, 2, Smoke::mf_static, 60, 15},	//322 QGlobalSpace::operator<<(QDataStream&, const KServiceAction&)
    {48, 213, 234, 2, Smoke::mf_static, 119, 16},	//323 QGlobalSpace::operator*(const QLine&, const QTransform&)
    {48, 245, 201, 2, Smoke::mf_static, 254, 17},	//324 QGlobalSpace::operator==(const QMargins&, const QMargins&)
    {48, 264, 237, 2, Smoke::mf_static, 114, 18},	//325 QGlobalSpace::operator|(KEmoticonsTheme::ParseModeEnum, int)
    {48, 264, 240, 2, Smoke::mf_static, 103, 19},	//326 QGlobalSpace::operator|(Qt::WindowState, QFlags<Qt::WindowState>)
    {48, 213, 243, 2, Smoke::mf_static, 301, 20},	//327 QGlobalSpace::operator*(const QSizeF&, double)
    {48, 236, 246, 2, Smoke::mf_static, 60, 21},	//328 QGlobalSpace::operator<<(QDataStream&, const QLine&)
    {48, 250, 249, 2, Smoke::mf_static, 254, 22},	//329 QGlobalSpace::operator>(const char*, const QLatin1String&)
    {48, 225, 252, 2, Smoke::mf_static, 301, 23},	//330 QGlobalSpace::operator-(const QSizeF&, const QSizeF&)
    {48, 264, 255, 2, Smoke::mf_static, 76, 24},	//331 QGlobalSpace::operator|(KLocale::TimeFormatOption, QFlags<KLocale::TimeFormatOption>)
    {48, 255, 258, 2, Smoke::mf_static, 254, 25},	//332 QGlobalSpace::operator>=(const QByteArray&, const QByteArray&)
    {48, 245, 261, 2, Smoke::mf_static, 254, 26},	//333 QGlobalSpace::operator==(const QLatin1String&, const QStringRef&)
    {48, 264, 264, 2, Smoke::mf_static, 98, 27},	//334 QGlobalSpace::operator|(Qt::MouseButton, Qt::MouseButton)
    {48, 264, 267, 2, Smoke::mf_static, 78, 28},	//335 QGlobalSpace::operator|(KUrl::CleanPathOption, QFlags<KUrl::CleanPathOption>)
    {48, 264, 270, 2, Smoke::mf_static, 78, 29},	//336 QGlobalSpace::operator|(KUrl::CleanPathOption, KUrl::CleanPathOption)
    {48, 208, 273, 2, Smoke::mf_static, 254, 30},	//337 QGlobalSpace::operator!=(const QVariant&, const QVariantComparisonHelper&)
    {48, 264, 276, 2, Smoke::mf_static, 73, 31},	//338 QGlobalSpace::operator|(KEmoticonsTheme::ParseModeEnum, KEmoticonsTheme::ParseModeEnum)
    {48, 245, 279, 2, Smoke::mf_static, 254, 32},	//339 QGlobalSpace::operator==(QBool, QBool)
    {48, 264, 282, 2, Smoke::mf_static, 114, 33},	//340 QGlobalSpace::operator|(KConfigBase::WriteConfigFlag, int)
    {48, 264, 285, 2, Smoke::mf_static, 89, 34},	//341 QGlobalSpace::operator|(Qt::AlignmentFlag, QFlags<Qt::AlignmentFlag>)
    {48, 245, 288, 2, Smoke::mf_static, 254, 35},	//342 QGlobalSpace::operator==(QString::Null, QString::Null)
    {48, 260, 291, 2, Smoke::mf_static, 60, 36},	//343 QGlobalSpace::operator>>(QDataStream&, KServiceAction&)
    {48, 169, 3, 1, Smoke::mf_static, 160, 37},	//344 QGlobalSpace::i18n(const char*)
    {48, 236, 294, 2, Smoke::mf_static, 60, 38},	//345 QGlobalSpace::operator<<(QDataStream&, const QRectF&)
    {48, 217, 297, 2, Smoke::mf_static, 304, 39},	//346 QGlobalSpace::operator+(QChar, const QString&)
    {48, 264, 300, 2, Smoke::mf_static, 83, 40},	//347 QGlobalSpace::operator|(QIODevice::OpenModeFlag, QFlags<QIODevice::OpenModeFlag>)
    {48, 264, 303, 2, Smoke::mf_static, 71, 41},	//348 QGlobalSpace::operator|(KDialog::ButtonCode, KDialog::ButtonCode)
    {48, 236, 306, 2, Smoke::mf_static, 60, 42},	//349 QGlobalSpace::operator<<(QDataStream&, const QPalette&)
    {48, 222, 309, 1, Smoke::mf_static, 22, 43},	//350 QGlobalSpace::operator++(KIconLoader::Group&)
    {48, 236, 311, 2, Smoke::mf_static, 60, 44},	//351 QGlobalSpace::operator<<(QDataStream&, const QByteArray&)
    {48, 213, 314, 2, Smoke::mf_static, 145, 45},	//352 QGlobalSpace::operator*(const QPolygonF&, const QTransform&)
    {48, 264, 317, 2, Smoke::mf_static, 101, 46},	//353 QGlobalSpace::operator|(Qt::ToolBarArea, Qt::ToolBarArea)
    {48, 264, 320, 2, Smoke::mf_static, 114, 47},	//354 QGlobalSpace::operator|(KUrl::QueryItemsOption, int)
    {48, 217, 252, 2, Smoke::mf_static, 301, 48},	//355 QGlobalSpace::operator+(const QSizeF&, const QSizeF&)
    {48, 264, 323, 2, Smoke::mf_static, 114, 49},	//356 QGlobalSpace::operator|(QWidget::RenderFlag, int)
    {48, 264, 326, 2, Smoke::mf_static, 114, 50},	//357 QGlobalSpace::operator|(Qt::DropAction, int)
    {48, 236, 329, 2, Smoke::mf_static, 60, 51},	//358 QGlobalSpace::operator<<(QDataStream&, const QStringList&)
    {48, 264, 332, 2, Smoke::mf_static, 80, 52},	//359 QGlobalSpace::operator|(KUrl::EncodedPathAndQueryOption, KUrl::EncodedPathAndQueryOption)
    {48, 264, 335, 2, Smoke::mf_static, 69, 53},	//360 QGlobalSpace::operator|(KConfig::OpenFlag, QFlags<KConfig::OpenFlag>)
    {48, 264, 338, 2, Smoke::mf_static, 89, 54},	//361 QGlobalSpace::operator|(Qt::AlignmentFlag, Qt::AlignmentFlag)
    {48, 260, 341, 2, Smoke::mf_static, 60, 55},	//362 QGlobalSpace::operator>>(QDataStream&, QColor&)
    {48, 236, 344, 2, Smoke::mf_static, 60, 56},	//363 QGlobalSpace::operator<<(QDataStream&, const QRegExp&)
    {48, 264, 347, 2, Smoke::mf_static, 114, 57},	//364 QGlobalSpace::operator|(QUrl::FormattingOption, int)
    {48, 231, 350, 2, Smoke::mf_static, 254, 58},	//365 QGlobalSpace::operator<(const QByteArray&, const char*)
    {48, 343, 5, 2, Smoke::mf_static, 160, 59},	//366 QGlobalSpace::tr2i18n(const char*, const char*)
    {48, 343, 3, 1, Smoke::mf_static, 160, 60},	//367 QGlobalSpace::tr2i18n(const char*)
    {48, 264, 353, 2, Smoke::mf_static, 79, 61},	//368 QGlobalSpace::operator|(KUrl::DirectoryOption, KUrl::DirectoryOption)
    {48, 171, 5, 2, Smoke::mf_static, 160, 62},	//369 QGlobalSpace::i18nc(const char*, const char*)
    {48, 264, 356, 2, Smoke::mf_static, 90, 63},	//370 QGlobalSpace::operator|(Qt::DockWidgetArea, QFlags<Qt::DockWidgetArea>)
    {48, 264, 359, 2, Smoke::mf_static, 72, 64},	//371 QGlobalSpace::operator|(KDialog::CaptionFlag, KDialog::CaptionFlag)
    {48, 213, 362, 2, Smoke::mf_static, 119, 65},	//372 QGlobalSpace::operator*(const QLine&, const QMatrix&)
    {48, 264, 365, 2, Smoke::mf_static, 79, 66},	//373 QGlobalSpace::operator|(KUrl::DirectoryOption, QFlags<KUrl::DirectoryOption>)
    {48, 213, 368, 2, Smoke::mf_static, 121, 67},	//374 QGlobalSpace::operator*(const QLineF&, const QMatrix&)
    {48, 264, 371, 2, Smoke::mf_static, 99, 68},	//375 QGlobalSpace::operator|(Qt::Orientation, Qt::Orientation)
    {48, 213, 374, 2, Smoke::mf_static, 135, 69},	//376 QGlobalSpace::operator*(const QPainterPath&, const QMatrix&)
    {48, 264, 377, 2, Smoke::mf_static, 114, 70},	//377 QGlobalSpace::operator|(Qt::ToolBarArea, int)
    {48, 260, 380, 2, Smoke::mf_static, 60, 71},	//378 QGlobalSpace::operator>>(QDataStream&, QPointF&)
    {48, 264, 383, 2, Smoke::mf_static, 114, 72},	//379 QGlobalSpace::operator|(Qt::MatchFlag, int)
    {48, 236, 386, 2, Smoke::mf_static, 60, 73},	//380 QGlobalSpace::operator<<(QDataStream&, const QKeySequence&)
    {48, 217, 389, 2, Smoke::mf_static, 304, 74},	//381 QGlobalSpace::operator+(const QString&, const char*)
    {48, 236, 392, 2, Smoke::mf_static, 60, 75},	//382 QGlobalSpace::operator<<(QDataStream&, const QCursor&)
    {48, 264, 395, 2, Smoke::mf_static, 92, 76},	//383 QGlobalSpace::operator|(Qt::GestureFlag, Qt::GestureFlag)
    {48, 260, 398, 2, Smoke::mf_static, 60, 77},	//384 QGlobalSpace::operator>>(QDataStream&, QDate&)
    {48, 264, 401, 2, Smoke::mf_static, 83, 78},	//385 QGlobalSpace::operator|(QIODevice::OpenModeFlag, QIODevice::OpenModeFlag)
    {48, 217, 404, 2, Smoke::mf_static, 264, 79},	//386 QGlobalSpace::operator+(char, const QByteArray&)
    {48, 229, 192, 2, Smoke::mf_static, 289, 80},	//387 QGlobalSpace::operator/(const QPoint&, double)
    {48, 217, 407, 2, Smoke::mf_static, 304, 81},	//388 QGlobalSpace::operator+(const char*, const QString&)
    {48, 245, 410, 2, Smoke::mf_static, 254, 82},	//389 QGlobalSpace::operator==(const char*, const QByteArray&)
    {48, 260, 413, 2, Smoke::mf_static, 60, 83},	//390 QGlobalSpace::operator>>(QDataStream&, QByteArray&)
    {48, 260, 416, 2, Smoke::mf_static, 60, 84},	//391 QGlobalSpace::operator>>(QDataStream&, QVariant&)
    {48, 264, 419, 2, Smoke::mf_static, 114, 85},	//392 QGlobalSpace::operator|(KDialog::ButtonCode, int)
    {48, 260, 422, 2, Smoke::mf_static, 60, 86},	//393 QGlobalSpace::operator>>(QDataStream&, QRegExp&)
    {48, 245, 425, 2, Smoke::mf_static, 254, 87},	//394 QGlobalSpace::operator==(const QPointF&, const QPointF&)
    {48, 229, 428, 2, Smoke::mf_static, 171, 88},	//395 QGlobalSpace::operator/(const QTransform&, double)
    {48, 264, 431, 2, Smoke::mf_static, 74, 89},	//396 QGlobalSpace::operator|(KLocale::DateTimeComponent, QFlags<KLocale::DateTimeComponent>)
    {48, 240, 407, 2, Smoke::mf_static, 254, 90},	//397 QGlobalSpace::operator<=(const char*, const QString&)
    {48, 186, 5, 2, Smoke::mf_static, 28, 91},	//398 QGlobalSpace::ki18nc(const char*, const char*)
    {48, 208, 434, 2, Smoke::mf_static, 254, 92},	//399 QGlobalSpace::operator!=(const QStringRef&, const QStringRef&)
    {48, 231, 437, 2, Smoke::mf_static, 254, 93},	//400 QGlobalSpace::operator<(QChar, QChar)
    {48, 213, 440, 2, Smoke::mf_static, 135, 94},	//401 QGlobalSpace::operator*(const QPainterPath&, const QTransform&)
    {48, 236, 443, 2, Smoke::mf_static, 60, 95},	//402 QGlobalSpace::operator<<(QDataStream&, const QBrush&)
    {48, 255, 249, 2, Smoke::mf_static, 254, 96},	//403 QGlobalSpace::operator>=(const char*, const QLatin1String&)
    {48, 264, 446, 2, Smoke::mf_static, 71, 97},	//404 QGlobalSpace::operator|(KDialog::ButtonCode, QFlags<KDialog::ButtonCode>)
    {48, 264, 449, 2, Smoke::mf_static, 114, 98},	//405 QGlobalSpace::operator|(KLocale::DateTimeFormatOption, int)
    {48, 260, 452, 2, Smoke::mf_static, 60, 99},	//406 QGlobalSpace::operator>>(QDataStream&, QRegion&)
    {48, 213, 455, 2, Smoke::mf_static, 291, 100},	//407 QGlobalSpace::operator*(const QPointF&, double)
    {48, 264, 458, 2, Smoke::mf_static, 114, 101},	//408 QGlobalSpace::operator|(KUrl::EncodedPathAndQueryOption, int)
    {48, 245, 222, 2, Smoke::mf_static, 254, 102},	//409 QGlobalSpace::operator==(const QSize&, const QSize&)
    {48, 236, 461, 2, Smoke::mf_static, 60, 103},	//410 QGlobalSpace::operator<<(QDataStream&, const QDate&)
    {48, 245, 249, 2, Smoke::mf_static, 254, 104},	//411 QGlobalSpace::operator==(const char*, const QLatin1String&)
    {48, 264, 464, 2, Smoke::mf_static, 97, 105},	//412 QGlobalSpace::operator|(Qt::MatchFlag, QFlags<Qt::MatchFlag>)
    {48, 264, 467, 2, Smoke::mf_static, 114, 106},	//413 QGlobalSpace::operator|(Qt::GestureFlag, int)
    {48, 208, 258, 2, Smoke::mf_static, 254, 107},	//414 QGlobalSpace::operator!=(const QByteArray&, const QByteArray&)
    {48, 264, 470, 2, Smoke::mf_static, 85, 108},	//415 QGlobalSpace::operator|(QSizePolicy::ControlType, QSizePolicy::ControlType)
    {48, 260, 473, 2, Smoke::mf_static, 60, 109},	//416 QGlobalSpace::operator>>(QDataStream&, QCursor&)
    {48, 264, 476, 2, Smoke::mf_static, 96, 110},	//417 QGlobalSpace::operator|(Qt::KeyboardModifier, QFlags<Qt::KeyboardModifier>)
    {48, 229, 243, 2, Smoke::mf_static, 301, 111},	//418 QGlobalSpace::operator/(const QSizeF&, double)
    {48, 264, 479, 2, Smoke::mf_static, 97, 112},	//419 QGlobalSpace::operator|(Qt::MatchFlag, Qt::MatchFlag)
    {48, 260, 482, 2, Smoke::mf_static, 60, 113},	//420 QGlobalSpace::operator>>(QDataStream&, QTransform&)
    {48, 213, 485, 2, Smoke::mf_static, 143, 114},	//421 QGlobalSpace::operator*(const QPolygon&, const QMatrix&)
    {48, 250, 437, 2, Smoke::mf_static, 254, 115},	//422 QGlobalSpace::operator>(QChar, QChar)
    {48, 255, 410, 2, Smoke::mf_static, 254, 116},	//423 QGlobalSpace::operator>=(const char*, const QByteArray&)
    {48, 245, 488, 2, Smoke::mf_static, 254, 117},	//424 QGlobalSpace::operator==(const QString&, QString::Null)
    {48, 264, 491, 2, Smoke::mf_static, 68, 118},	//425 QGlobalSpace::operator|(KCModule::Button, QFlags<KCModule::Button>)
    {48, 231, 258, 2, Smoke::mf_static, 254, 119},	//426 QGlobalSpace::operator<(const QByteArray&, const QByteArray&)
    {48, 264, 494, 2, Smoke::mf_static, 114, 120},	//427 QGlobalSpace::operator|(QLibrary::LoadHint, int)
    {48, 260, 497, 2, Smoke::mf_static, 60, 121},	//428 QGlobalSpace::operator>>(QDataStream&, QSizeF&)
    {48, 225, 500, 1, Smoke::mf_static, 291, 122},	//429 QGlobalSpace::operator-(const QPointF&)
    {48, 264, 502, 2, Smoke::mf_static, 95, 123},	//430 QGlobalSpace::operator|(Qt::ItemFlag, Qt::ItemFlag)
    {48, 236, 505, 2, Smoke::mf_static, 60, 124},	//431 QGlobalSpace::operator<<(QDataStream&, const QPixmap&)
    {48, 217, 508, 2, Smoke::mf_static, 304, 125},	//432 QGlobalSpace::operator+(const QByteArray&, const QString&)
    {48, 264, 511, 2, Smoke::mf_static, 104, 126},	//433 QGlobalSpace::operator|(Qt::WindowType, QFlags<Qt::WindowType>)
    {48, 213, 514, 2, Smoke::mf_static, 141, 127},	//434 QGlobalSpace::operator*(const QPointF&, const QTransform&)
    {48, 264, 517, 2, Smoke::mf_static, 95, 128},	//435 QGlobalSpace::operator|(Qt::ItemFlag, QFlags<Qt::ItemFlag>)
    {48, 264, 520, 2, Smoke::mf_static, 102, 129},	//436 QGlobalSpace::operator|(Qt::TouchPointState, QFlags<Qt::TouchPointState>)
    {48, 217, 523, 2, Smoke::mf_static, 304, 130},	//437 QGlobalSpace::operator+(const QString&, char)
    {48, 255, 434, 2, Smoke::mf_static, 254, 131},	//438 QGlobalSpace::operator>=(const QStringRef&, const QStringRef&)
    {48, 245, 273, 2, Smoke::mf_static, 254, 132},	//439 QGlobalSpace::operator==(const QVariant&, const QVariantComparisonHelper&)
    {48, 236, 526, 2, Smoke::mf_static, 60, 133},	//440 QGlobalSpace::operator<<(QDataStream&, const QUrl&)
    {48, 264, 529, 2, Smoke::mf_static, 85, 134},	//441 QGlobalSpace::operator|(QSizePolicy::ControlType, QFlags<QSizePolicy::ControlType>)
    {48, 188, 532, 3, Smoke::mf_static, 28, 135},	//442 QGlobalSpace::ki18ncp(const char*, const char*, const char*)
    {48, 236, 536, 2, Smoke::mf_static, 60, 136},	//443 QGlobalSpace::operator<<(QDataStream&, const QVariant&)
    {48, 260, 539, 2, Smoke::mf_static, 60, 137},	//444 QGlobalSpace::operator>>(QDataStream&, QLine&)
    {48, 264, 542, 2, Smoke::mf_static, 96, 138},	//445 QGlobalSpace::operator|(Qt::KeyboardModifier, Qt::KeyboardModifier)
    {48, 231, 410, 2, Smoke::mf_static, 254, 139},	//446 QGlobalSpace::operator<(const char*, const QByteArray&)
    {48, 264, 545, 2, Smoke::mf_static, 114, 140},	//447 QGlobalSpace::operator|(Qt::AlignmentFlag, int)
    {48, 213, 548, 2, Smoke::mf_static, 139, 141},	//448 QGlobalSpace::operator*(const QPoint&, const QMatrix&)
    {48, 264, 551, 2, Smoke::mf_static, 114, 142},	//449 QGlobalSpace::operator|(Qt::KeyboardModifier, int)
    {48, 264, 554, 2, Smoke::mf_static, 114, 143},	//450 QGlobalSpace::operator|(Qt::ItemFlag, int)
    {48, 264, 557, 2, Smoke::mf_static, 77, 144},	//451 QGlobalSpace::operator|(KLocale::TimeProcessingOption, KLocale::TimeProcessingOption)
    {48, 208, 222, 2, Smoke::mf_static, 254, 145},	//452 QGlobalSpace::operator!=(const QSize&, const QSize&)
    {48, 264, 560, 2, Smoke::mf_static, 93, 146},	//453 QGlobalSpace::operator|(Qt::ImageConversionFlag, QFlags<Qt::ImageConversionFlag>)
    {48, 240, 350, 2, Smoke::mf_static, 254, 147},	//454 QGlobalSpace::operator<=(const QByteArray&, const char*)
    {48, 208, 563, 2, Smoke::mf_static, 254, 148},	//455 QGlobalSpace::operator!=(const QPoint&, const QPoint&)
    {48, 264, 566, 2, Smoke::mf_static, 114, 149},	//456 QGlobalSpace::operator|(QString::SectionFlag, int)
    {48, 264, 569, 2, Smoke::mf_static, 114, 150},	//457 QGlobalSpace::operator|(Qt::WindowType, int)
    {48, 264, 572, 2, Smoke::mf_static, 88, 151},	//458 QGlobalSpace::operator|(QWidget::RenderFlag, QWidget::RenderFlag)
    {48, 245, 575, 2, Smoke::mf_static, 254, 152},	//459 QGlobalSpace::operator==(const QStringRef&, const QString&)
    {48, 255, 578, 2, Smoke::mf_static, 254, 153},	//460 QGlobalSpace::operator>=(const QLatin1String&, const QLatin1String&)
    {48, 245, 581, 2, Smoke::mf_static, 254, 154},	//461 QGlobalSpace::operator==(const QHashDummyValue&, const QHashDummyValue&)
    {48, 264, 584, 2, Smoke::mf_static, 81, 155},	//462 QGlobalSpace::operator|(KUrl::EqualsOption, KUrl::EqualsOption)
    {48, 264, 587, 2, Smoke::mf_static, 87, 156},	//463 QGlobalSpace::operator|(QUrl::FormattingOption, QUrl::FormattingOption)
    {48, 260, 590, 2, Smoke::mf_static, 60, 157},	//464 QGlobalSpace::operator>>(QDataStream&, QIcon&)
    {48, 236, 593, 2, Smoke::mf_static, 60, 158},	//465 QGlobalSpace::operator<<(QDataStream&, const QPolygon&)
    {48, 213, 428, 2, Smoke::mf_static, 171, 159},	//466 QGlobalSpace::operator*(const QTransform&, double)
    {48, 264, 596, 2, Smoke::mf_static, 114, 160},	//467 QGlobalSpace::operator|(Qt::TouchPointState, int)
    {48, 264, 599, 2, Smoke::mf_static, 72, 161},	//468 QGlobalSpace::operator|(KDialog::CaptionFlag, QFlags<KDialog::CaptionFlag>)
    {48, 231, 434, 2, Smoke::mf_static, 254, 162},	//469 QGlobalSpace::operator<(const QStringRef&, const QStringRef&)
    {48, 264, 602, 2, Smoke::mf_static, 88, 163},	//470 QGlobalSpace::operator|(QWidget::RenderFlag, QFlags<QWidget::RenderFlag>)
    {48, 208, 605, 2, Smoke::mf_static, 254, 164},	//471 QGlobalSpace::operator!=(const QStringRef&, const char*)
    {48, 208, 410, 2, Smoke::mf_static, 254, 165},	//472 QGlobalSpace::operator!=(const char*, const QByteArray&)
    {48, 250, 434, 2, Smoke::mf_static, 254, 166},	//473 QGlobalSpace::operator>(const QStringRef&, const QStringRef&)
    {48, 264, 608, 2, Smoke::mf_static, 114, 167},	//474 QGlobalSpace::operator|(KUrl::CleanPathOption, int)
    {48, 264, 611, 2, Smoke::mf_static, 82, 168},	//475 QGlobalSpace::operator|(KUrl::QueryItemsOption, KUrl::QueryItemsOption)
    {48, 264, 614, 2, Smoke::mf_static, 70, 169},	//476 QGlobalSpace::operator|(KConfigBase::WriteConfigFlag, KConfigBase::WriteConfigFlag)
    {48, 264, 617, 2, Smoke::mf_static, 114, 170},	//477 QGlobalSpace::operator|(KConfig::OpenFlag, int)
    {48, 236, 620, 2, Smoke::mf_static, 60, 171},	//478 QGlobalSpace::operator<<(QDataStream&, const QLineF&)
    {48, 260, 623, 2, Smoke::mf_static, 60, 172},	//479 QGlobalSpace::operator>>(QDataStream&, QBrush&)
    {48, 236, 626, 2, Smoke::mf_static, 60, 173},	//480 QGlobalSpace::operator<<(QDataStream&, const QPointF&)
    {48, 213, 629, 2, Smoke::mf_static, 289, 174},	//481 QGlobalSpace::operator*(const QPoint&, float)
    {48, 264, 632, 2, Smoke::mf_static, 76, 175},	//482 QGlobalSpace::operator|(KLocale::TimeFormatOption, KLocale::TimeFormatOption)
    {48, 217, 116, 2, Smoke::mf_static, 304, 176},	//483 QGlobalSpace::operator+(const QString&, const QString&)
    {48, 231, 407, 2, Smoke::mf_static, 254, 177},	//484 QGlobalSpace::operator<(const char*, const QString&)
    {48, 208, 407, 2, Smoke::mf_static, 254, 178},	//485 QGlobalSpace::operator!=(const char*, const QString&)
    {48, 208, 350, 2, Smoke::mf_static, 254, 179},	//486 QGlobalSpace::operator!=(const QByteArray&, const char*)
    {48, 208, 635, 2, Smoke::mf_static, 254, 180},	//487 QGlobalSpace::operator!=(const QString&, const QStringRef&)
    {48, 264, 638, 2, Smoke::mf_static, 114, 181},	//488 QGlobalSpace::operator|(KUrl::EqualsOption, int)
    {48, 264, 641, 2, Smoke::mf_static, 114, 182},	//489 QGlobalSpace::operator|(KDialog::CaptionFlag, int)
    {48, 264, 644, 2, Smoke::mf_static, 114, 183},	//490 QGlobalSpace::operator|(QSizePolicy::ControlType, int)
    {48, 260, 647, 2, Smoke::mf_static, 60, 184},	//491 QGlobalSpace::operator>>(QDataStream&, QSizePolicy&)
    {48, 250, 258, 2, Smoke::mf_static, 254, 185},	//492 QGlobalSpace::operator>(const QByteArray&, const QByteArray&)
    {48, 240, 249, 2, Smoke::mf_static, 254, 186},	//493 QGlobalSpace::operator<=(const char*, const QLatin1String&)
    {48, 245, 563, 2, Smoke::mf_static, 254, 187},	//494 QGlobalSpace::operator==(const QPoint&, const QPoint&)
    {48, 245, 650, 2, Smoke::mf_static, 254, 188},	//495 QGlobalSpace::operator==(const char*, const QStringRef&)
    {48, 217, 410, 2, Smoke::mf_static, 264, 189},	//496 QGlobalSpace::operator+(const char*, const QByteArray&)
    {48, 260, 653, 2, Smoke::mf_static, 60, 190},	//497 QGlobalSpace::operator>>(QDataStream&, QMatrix&)
    {48, 264, 656, 2, Smoke::mf_static, 114, 191},	//498 QGlobalSpace::operator|(Qt::MouseButton, int)
    {48, 240, 434, 2, Smoke::mf_static, 254, 192},	//499 QGlobalSpace::operator<=(const QStringRef&, const QStringRef&)
    {48, 260, 659, 2, Smoke::mf_static, 60, 193},	//500 QGlobalSpace::operator>>(QDataStream&, QSize&)
    {48, 264, 662, 2, Smoke::mf_static, 94, 194},	//501 QGlobalSpace::operator|(Qt::InputMethodHint, Qt::InputMethodHint)
    {48, 264, 665, 2, Smoke::mf_static, 77, 195},	//502 QGlobalSpace::operator|(KLocale::TimeProcessingOption, QFlags<KLocale::TimeProcessingOption>)
    {48, 260, 668, 2, Smoke::mf_static, 60, 196},	//503 QGlobalSpace::operator>>(QDataStream&, QVariant::Type&)
    {48, 245, 437, 2, Smoke::mf_static, 254, 197},	//504 QGlobalSpace::operator==(QChar, QChar)
    {48, 264, 671, 2, Smoke::mf_static, 100, 198},	//505 QGlobalSpace::operator|(Qt::TextInteractionFlag, QFlags<Qt::TextInteractionFlag>)
    {48, 208, 575, 2, Smoke::mf_static, 254, 199},	//506 QGlobalSpace::operator!=(const QStringRef&, const QString&)
    {48, 213, 674, 2, Smoke::mf_static, 121, 200},	//507 QGlobalSpace::operator*(const QLineF&, const QTransform&)
    {48, 208, 677, 2, Smoke::mf_static, 254, 201},	//508 QGlobalSpace::operator!=(const QStringRef&, const QLatin1String&)
    {48, 236, 680, 2, Smoke::mf_static, 60, 202},	//509 QGlobalSpace::operator<<(QDataStream&, const QPolygonF&)
    {48, 236, 683, 2, Smoke::mf_static, 60, 203},	//510 QGlobalSpace::operator<<(QDataStream&, const QSizeF&)
    {48, 264, 686, 2, Smoke::mf_static, 101, 204},	//511 QGlobalSpace::operator|(Qt::ToolBarArea, QFlags<Qt::ToolBarArea>)
    {48, 236, 689, 2, Smoke::mf_static, 60, 205},	//512 QGlobalSpace::operator<<(QDataStream&, const QFont&)
    {48, 264, 692, 2, Smoke::mf_static, 81, 206},	//513 QGlobalSpace::operator|(KUrl::EqualsOption, QFlags<KUrl::EqualsOption>)
    {48, 264, 695, 2, Smoke::mf_static, 114, 207},	//514 QGlobalSpace::operator|(KLocale::TimeProcessingOption, int)
    {48, 236, 698, 2, Smoke::mf_static, 60, 208},	//515 QGlobalSpace::operator<<(QDataStream&, const QMatrix&)
    {48, 217, 701, 2, Smoke::mf_static, 304, 209},	//516 QGlobalSpace::operator+(char, const QString&)
    {48, 208, 261, 2, Smoke::mf_static, 254, 210},	//517 QGlobalSpace::operator!=(const QLatin1String&, const QStringRef&)
    {48, 208, 437, 2, Smoke::mf_static, 254, 211},	//518 QGlobalSpace::operator!=(QChar, QChar)
    {48, 264, 704, 2, Smoke::mf_static, 84, 212},	//519 QGlobalSpace::operator|(QLibrary::LoadHint, QLibrary::LoadHint)
    {48, 245, 578, 2, Smoke::mf_static, 254, 213},	//520 QGlobalSpace::operator==(const QLatin1String&, const QLatin1String&)
    {48, 264, 707, 2, Smoke::mf_static, 103, 214},	//521 QGlobalSpace::operator|(Qt::WindowState, Qt::WindowState)
    {48, 264, 710, 2, Smoke::mf_static, 87, 215},	//522 QGlobalSpace::operator|(QUrl::FormattingOption, QFlags<QUrl::FormattingOption>)
    {48, 245, 252, 2, Smoke::mf_static, 254, 216},	//523 QGlobalSpace::operator==(const QSizeF&, const QSizeF&)
    {48, 260, 713, 2, Smoke::mf_static, 60, 217},	//524 QGlobalSpace::operator>>(QDataStream&, QPolygonF&)
    {48, 260, 716, 2, Smoke::mf_static, 60, 218},	//525 QGlobalSpace::operator>>(QDataStream&, QPalette&)
    {48, 236, 719, 2, Smoke::mf_static, 60, 219},	//526 QGlobalSpace::operator<<(QDataStream&, const QPainterPath&)
    {48, 245, 434, 2, Smoke::mf_static, 254, 220},	//527 QGlobalSpace::operator==(const QStringRef&, const QStringRef&)
    {48, 208, 722, 2, Smoke::mf_static, 254, 221},	//528 QGlobalSpace::operator!=(const QRectF&, const QRectF&)
    {48, 213, 725, 2, Smoke::mf_static, 299, 222},	//529 QGlobalSpace::operator*(double, const QSize&)
    {48, 264, 728, 2, Smoke::mf_static, 68, 223},	//530 QGlobalSpace::operator|(KCModule::Button, KCModule::Button)
    {48, 255, 350, 2, Smoke::mf_static, 254, 224},	//531 QGlobalSpace::operator>=(const QByteArray&, const char*)
    {48, 213, 731, 2, Smoke::mf_static, 289, 225},	//532 QGlobalSpace::operator*(double, const QPoint&)
    {48, 236, 734, 2, Smoke::mf_static, 60, 226},	//533 QGlobalSpace::operator<<(QDataStream&, const QPoint&)
    {48, 236, 737, 2, Smoke::mf_static, 60, 227},	//534 QGlobalSpace::operator<<(QDataStream&, const QImage&)
    {48, 217, 740, 2, Smoke::mf_static, 264, 228},	//535 QGlobalSpace::operator+(const QByteArray&, char)
    {48, 229, 455, 2, Smoke::mf_static, 291, 229},	//536 QGlobalSpace::operator/(const QPointF&, double)
    {48, 255, 437, 2, Smoke::mf_static, 254, 230},	//537 QGlobalSpace::operator>=(QChar, QChar)
    {48, 240, 258, 2, Smoke::mf_static, 254, 231},	//538 QGlobalSpace::operator<=(const QByteArray&, const QByteArray&)
    {48, 260, 743, 2, Smoke::mf_static, 60, 232},	//539 QGlobalSpace::operator>>(QDataStream&, QFont&)
    {48, 240, 578, 2, Smoke::mf_static, 254, 233},	//540 QGlobalSpace::operator<=(const QLatin1String&, const QLatin1String&)
    {48, 264, 746, 2, Smoke::mf_static, 86, 234},	//541 QGlobalSpace::operator|(QString::SectionFlag, QFlags<QString::SectionFlag>)
    {48, 236, 749, 2, Smoke::mf_static, 60, 235},	//542 QGlobalSpace::operator<<(QDataStream&, const QSize&)
    {48, 250, 410, 2, Smoke::mf_static, 254, 236},	//543 QGlobalSpace::operator>(const char*, const QByteArray&)
    {48, 264, 752, 2, Smoke::mf_static, 75, 237},	//544 QGlobalSpace::operator|(KLocale::DateTimeFormatOption, QFlags<KLocale::DateTimeFormatOption>)
    {48, 260, 755, 2, Smoke::mf_static, 60, 238},	//545 QGlobalSpace::operator>>(QDataStream&, QRectF&)
    {48, 236, 758, 2, Smoke::mf_static, 60, 239},	//546 QGlobalSpace::operator<<(QDataStream&, const QChar&)
    {48, 245, 722, 2, Smoke::mf_static, 254, 240},	//547 QGlobalSpace::operator==(const QRectF&, const QRectF&)
    {48, 208, 761, 2, Smoke::mf_static, 254, 241},	//548 QGlobalSpace::operator!=(bool, QBool)
    {48, 264, 764, 2, Smoke::mf_static, 82, 242},	//549 QGlobalSpace::operator|(KUrl::QueryItemsOption, QFlags<KUrl::QueryItemsOption>)
    {48, 213, 767, 2, Smoke::mf_static, 143, 243},	//550 QGlobalSpace::operator*(const QPolygon&, const QTransform&)
    {48, 208, 770, 2, Smoke::mf_static, 254, 244},	//551 QGlobalSpace::operator!=(QBool, bool)
    {48, 264, 773, 2, Smoke::mf_static, 114, 245},	//552 QGlobalSpace::operator|(Qt::WindowState, int)
    {48, 225, 563, 2, Smoke::mf_static, 289, 246},	//553 QGlobalSpace::operator-(const QPoint&, const QPoint&)
    {48, 260, 776, 2, Smoke::mf_static, 60, 247},	//554 QGlobalSpace::operator>>(QDataStream&, QStringList&)
    {48, 217, 350, 2, Smoke::mf_static, 264, 248},	//555 QGlobalSpace::operator+(const QByteArray&, const char*)
    {48, 236, 779, 2, Smoke::mf_static, 60, 249},	//556 QGlobalSpace::operator<<(QDataStream&, const QRect&)
    {48, 208, 252, 2, Smoke::mf_static, 254, 250},	//557 QGlobalSpace::operator!=(const QSizeF&, const QSizeF&)
    {48, 240, 410, 2, Smoke::mf_static, 254, 251},	//558 QGlobalSpace::operator<=(const char*, const QByteArray&)
    {48, 264, 782, 2, Smoke::mf_static, 114, 252},	//559 QGlobalSpace::operator|(KUrl::DirectoryOption, int)
    {48, 184, 3, 1, Smoke::mf_static, 28, 253},	//560 QGlobalSpace::ki18n(const char*)
    {48, 236, 785, 2, Smoke::mf_static, 60, 254},	//561 QGlobalSpace::operator<<(QDataStream&, const QRegion&)
    {48, 264, 788, 2, Smoke::mf_static, 90, 255},	//562 QGlobalSpace::operator|(Qt::DockWidgetArea, Qt::DockWidgetArea)
    {48, 245, 635, 2, Smoke::mf_static, 254, 256},	//563 QGlobalSpace::operator==(const QString&, const QStringRef&)
    {48, 208, 578, 2, Smoke::mf_static, 254, 257},	//564 QGlobalSpace::operator!=(const QLatin1String&, const QLatin1String&)
    {48, 264, 791, 2, Smoke::mf_static, 74, 258},	//565 QGlobalSpace::operator|(KLocale::DateTimeComponent, KLocale::DateTimeComponent)
    {48, 236, 794, 2, Smoke::mf_static, 60, 259},	//566 QGlobalSpace::operator<<(QDataStream&, const QColor&)
    {48, 264, 797, 2, Smoke::mf_static, 104, 260},	//567 QGlobalSpace::operator|(Qt::WindowType, Qt::WindowType)
    {48, 213, 800, 2, Smoke::mf_static, 299, 261},	//568 QGlobalSpace::operator*(const QSize&, double)
    {48, 245, 803, 2, Smoke::mf_static, 254, 262},	//569 QGlobalSpace::operator==(QString::Null, const QString&)
    {48, 264, 806, 2, Smoke::mf_static, 94, 263},	//570 QGlobalSpace::operator|(Qt::InputMethodHint, QFlags<Qt::InputMethodHint>)
    {48, 264, 809, 2, Smoke::mf_static, 69, 264},	//571 QGlobalSpace::operator|(KConfig::OpenFlag, KConfig::OpenFlag)
    {48, 260, 812, 2, Smoke::mf_static, 60, 265},	//572 QGlobalSpace::operator>>(QDataStream&, QPoint&)
    {48, 245, 350, 2, Smoke::mf_static, 254, 266},	//573 QGlobalSpace::operator==(const QByteArray&, const char*)
    {48, 260, 815, 2, Smoke::mf_static, 60, 267},	//574 QGlobalSpace::operator>>(QDataStream&, QDateTime&)
    {48, 250, 407, 2, Smoke::mf_static, 254, 268},	//575 QGlobalSpace::operator>(const char*, const QString&)
    {48, 236, 818, 2, Smoke::mf_static, 60, 269},	//576 QGlobalSpace::operator<<(QDataStream&, const QTime&)
    {48, 260, 821, 2, Smoke::mf_static, 60, 270},	//577 QGlobalSpace::operator>>(QDataStream&, QKeySequence&)
    {48, 250, 350, 2, Smoke::mf_static, 254, 271},	//578 QGlobalSpace::operator>(const QByteArray&, const char*)
    {48, 231, 249, 2, Smoke::mf_static, 254, 272},	//579 QGlobalSpace::operator<(const char*, const QLatin1String&)
    {48, 217, 563, 2, Smoke::mf_static, 289, 273},	//580 QGlobalSpace::operator+(const QPoint&, const QPoint&)
    {48, 240, 437, 2, Smoke::mf_static, 254, 274},	//581 QGlobalSpace::operator<=(QChar, QChar)
    {48, 264, 824, 2, Smoke::mf_static, 114, 275},	//582 QGlobalSpace::operator|(KLocale::TimeFormatOption, int)
    {48, 213, 827, 2, Smoke::mf_static, 151, 276},	//583 QGlobalSpace::operator*(const QRegion&, const QTransform&)
    {48, 208, 803, 2, Smoke::mf_static, 254, 277},	//584 QGlobalSpace::operator!=(QString::Null, const QString&)
    {48, 264, 830, 2, Smoke::mf_static, 114, 278},	//585 QGlobalSpace::operator|(KCModule::Button, int)
    {48, 250, 578, 2, Smoke::mf_static, 254, 279},	//586 QGlobalSpace::operator>(const QLatin1String&, const QLatin1String&)
    {48, 264, 833, 2, Smoke::mf_static, 86, 280},	//587 QGlobalSpace::operator|(QString::SectionFlag, QString::SectionFlag)
    {48, 208, 488, 2, Smoke::mf_static, 254, 281},	//588 QGlobalSpace::operator!=(const QString&, QString::Null)
    {48, 264, 836, 2, Smoke::mf_static, 114, 282},	//589 QGlobalSpace::operator|(QIODevice::OpenModeFlag, int)
    {48, 213, 839, 2, Smoke::mf_static, 289, 283},	//590 QGlobalSpace::operator*(int, const QPoint&)
    {48, 264, 842, 2, Smoke::mf_static, 92, 284},	//591 QGlobalSpace::operator|(Qt::GestureFlag, QFlags<Qt::GestureFlag>)
    {48, 213, 845, 2, Smoke::mf_static, 145, 285},	//592 QGlobalSpace::operator*(const QPolygonF&, const QMatrix&)
    {48, 225, 848, 1, Smoke::mf_static, 289, 286},	//593 QGlobalSpace::operator-(const QPoint&)
    {48, 260, 850, 2, Smoke::mf_static, 60, 287},	//594 QGlobalSpace::operator>>(QDataStream&, QPolygon&)
    {48, 264, 853, 2, Smoke::mf_static, 80, 288},	//595 QGlobalSpace::operator|(KUrl::EncodedPathAndQueryOption, QFlags<KUrl::EncodedPathAndQueryOption>)
    {48, 260, 856, 2, Smoke::mf_static, 60, 289},	//596 QGlobalSpace::operator>>(QDataStream&, QString&)
    {48, 245, 258, 2, Smoke::mf_static, 254, 290},	//597 QGlobalSpace::operator==(const QByteArray&, const QByteArray&)
    {48, 236, 859, 2, Smoke::mf_static, 60, 291},	//598 QGlobalSpace::operator<<(QDataStream&, const QString&)
    {48, 225, 425, 2, Smoke::mf_static, 291, 292},	//599 QGlobalSpace::operator-(const QPointF&, const QPointF&)
    {48, 231, 578, 2, Smoke::mf_static, 254, 293},	//600 QGlobalSpace::operator<(const QLatin1String&, const QLatin1String&)
    {48, 260, 862, 2, Smoke::mf_static, 60, 294},	//601 QGlobalSpace::operator>>(QDataStream&, QChar&)
    {48, 217, 428, 2, Smoke::mf_static, 171, 295},	//602 QGlobalSpace::operator+(const QTransform&, double)
    {48, 264, 865, 2, Smoke::mf_static, 100, 296},	//603 QGlobalSpace::operator|(Qt::TextInteractionFlag, Qt::TextInteractionFlag)
    {48, 245, 605, 2, Smoke::mf_static, 254, 297},	//604 QGlobalSpace::operator==(const QStringRef&, const char*)
    {48, 208, 650, 2, Smoke::mf_static, 254, 298},	//605 QGlobalSpace::operator!=(const char*, const QStringRef&)
    {48, 260, 868, 2, Smoke::mf_static, 60, 299},	//606 QGlobalSpace::operator>>(QDataStream&, QPixmap&)
    {48, 217, 258, 2, Smoke::mf_static, 264, 300},	//607 QGlobalSpace::operator+(const QByteArray&, const QByteArray&)
    {48, 264, 871, 2, Smoke::mf_static, 73, 301},	//608 QGlobalSpace::operator|(KEmoticonsTheme::ParseModeEnum, QFlags<KEmoticonsTheme::ParseModeEnum>)
    {48, 264, 874, 2, Smoke::mf_static, 70, 302},	//609 QGlobalSpace::operator|(KConfigBase::WriteConfigFlag, QFlags<KConfigBase::WriteConfigFlag>)
    {48, 217, 877, 2, Smoke::mf_static, 304, 303},	//610 QGlobalSpace::operator+(const QString&, const QByteArray&)
    {48, 260, 880, 2, Smoke::mf_static, 60, 304},	//611 QGlobalSpace::operator>>(QDataStream&, QRect&)
    {48, 264, 883, 2, Smoke::mf_static, 114, 305},	//612 QGlobalSpace::operator|(KLocale::DateTimeComponent, int)
    {48, 264, 886, 2, Smoke::mf_static, 114, 306},	//613 QGlobalSpace::operator|(Qt::ImageConversionFlag, int)
    {48, 245, 407, 2, Smoke::mf_static, 254, 307},	//614 QGlobalSpace::operator==(const char*, const QString&)
    {48, 236, 889, 2, Smoke::mf_static, 60, 308},	//615 QGlobalSpace::operator<<(QDataStream&, const QIcon&)
    {48, 236, 892, 2, Smoke::mf_static, 60, 309},	//616 QGlobalSpace::operator<<(QDataStream&, const QVariant::Type)
    {48, 229, 800, 2, Smoke::mf_static, 299, 310},	//617 QGlobalSpace::operator/(const QSize&, double)
    {48, 260, 895, 2, Smoke::mf_static, 60, 311},	//618 QGlobalSpace::operator>>(QDataStream&, QLineF&)
    {48, 260, 898, 2, Smoke::mf_static, 60, 312},	//619 QGlobalSpace::operator>>(QDataStream&, QPainterPath&)
    {48, 245, 761, 2, Smoke::mf_static, 254, 313},	//620 QGlobalSpace::operator==(bool, QBool)
    {48, 264, 901, 2, Smoke::mf_static, 102, 314},	//621 QGlobalSpace::operator|(Qt::TouchPointState, Qt::TouchPointState)
    {48, 264, 904, 2, Smoke::mf_static, 114, 315},	//622 QGlobalSpace::operator|(Qt::TextInteractionFlag, int)
    {48, 213, 907, 2, Smoke::mf_static, 139, 316},	//623 QGlobalSpace::operator*(const QPoint&, const QTransform&)
    {48, 255, 407, 2, Smoke::mf_static, 254, 317},	//624 QGlobalSpace::operator>=(const char*, const QString&)
    {48, 236, 910, 2, Smoke::mf_static, 60, 318},	//625 QGlobalSpace::operator<<(QDataStream&, const QDateTime&)
    {48, 190, 5, 2, Smoke::mf_static, 28, 319},	//626 QGlobalSpace::ki18np(const char*, const char*)
    {48, 260, 913, 2, Smoke::mf_static, 60, 320},	//627 QGlobalSpace::operator>>(QDataStream&, QTime&)
    {48, 208, 425, 2, Smoke::mf_static, 254, 321},	//628 QGlobalSpace::operator!=(const QPointF&, const QPointF&)
    {48, 213, 916, 2, Smoke::mf_static, 289, 322},	//629 QGlobalSpace::operator*(const QPoint&, int)
    {48, 264, 919, 2, Smoke::mf_static, 93, 323},	//630 QGlobalSpace::operator|(Qt::ImageConversionFlag, Qt::ImageConversionFlag)
    {48, 225, 222, 2, Smoke::mf_static, 299, 324},	//631 QGlobalSpace::operator-(const QSize&, const QSize&)
    {48, 264, 922, 2, Smoke::mf_static, 91, 325},	//632 QGlobalSpace::operator|(Qt::DropAction, QFlags<Qt::DropAction>)
    {48, 264, 925, 2, Smoke::mf_static, 91, 326},	//633 QGlobalSpace::operator|(Qt::DropAction, Qt::DropAction)
    {48, 264, 928, 2, Smoke::mf_static, 114, 327},	//634 QGlobalSpace::operator|(Qt::Orientation, int)
    {48, 208, 249, 2, Smoke::mf_static, 254, 328},	//635 QGlobalSpace::operator!=(const char*, const QLatin1String&)
    {48, 217, 425, 2, Smoke::mf_static, 291, 329},	//636 QGlobalSpace::operator+(const QPointF&, const QPointF&)
    {48, 213, 931, 2, Smoke::mf_static, 151, 330},	//637 QGlobalSpace::operator*(const QRegion&, const QMatrix&)
    {48, 245, 770, 2, Smoke::mf_static, 254, 331},	//638 QGlobalSpace::operator==(QBool, bool)
    {48, 245, 219, 2, Smoke::mf_static, 254, 332},	//639 QGlobalSpace::operator==(const QRect&, const QRect&)
    {48, 213, 934, 2, Smoke::mf_static, 289, 333},	//640 QGlobalSpace::operator*(float, const QPoint&)
    {48, 260, 937, 2, Smoke::mf_static, 60, 334},	//641 QGlobalSpace::operator>>(QDataStream&, QUrl&)
    {48, 264, 940, 2, Smoke::mf_static, 84, 335},	//642 QGlobalSpace::operator|(QLibrary::LoadHint, QFlags<QLibrary::LoadHint>)
    {48, 217, 943, 2, Smoke::mf_static, 304, 336},	//643 QGlobalSpace::operator+(const QString&, QChar)
    {48, 208, 288, 2, Smoke::mf_static, 254, 337},	//644 QGlobalSpace::operator!=(QString::Null, QString::Null)
    {48, 264, 946, 2, Smoke::mf_static, 99, 338},	//645 QGlobalSpace::operator|(Qt::Orientation, QFlags<Qt::Orientation>)
    {48, 208, 279, 2, Smoke::mf_static, 254, 339},	//646 QGlobalSpace::operator!=(QBool, QBool)
    {48, 245, 677, 2, Smoke::mf_static, 254, 340},	//647 QGlobalSpace::operator==(const QStringRef&, const QLatin1String&)
    {48, 225, 428, 2, Smoke::mf_static, 171, 341},	//648 QGlobalSpace::operator-(const QTransform&, double)
    {48, 222, 949, 2, Smoke::mf_static, 21, 342},	//649 QGlobalSpace::operator++(KIconLoader::Group&, int)
    {48, 69, 0, 0, Smoke::mf_static|Smoke::mf_enum, 42, 343},	//650 QGlobalSpace::KST_KSycocaEntry (enum)
    {48, 62, 0, 0, Smoke::mf_static|Smoke::mf_enum, 42, 344},	//651 QGlobalSpace::KST_KService (enum)
    {48, 67, 0, 0, Smoke::mf_static|Smoke::mf_enum, 42, 345},	//652 QGlobalSpace::KST_KServiceType (enum)
    {48, 57, 0, 0, Smoke::mf_static|Smoke::mf_enum, 42, 346},	//653 QGlobalSpace::KST_KMimeType (enum)
    {48, 54, 0, 0, Smoke::mf_static|Smoke::mf_enum, 42, 347},	//654 QGlobalSpace::KST_KFolderMimeType (enum)
    {48, 53, 0, 0, Smoke::mf_static|Smoke::mf_enum, 42, 348},	//655 QGlobalSpace::KST_KDEDesktopMimeType (enum)
    {48, 58, 0, 0, Smoke::mf_static|Smoke::mf_enum, 42, 349},	//656 QGlobalSpace::KST_KMimeTypeEntry (enum)
    {48, 64, 0, 0, Smoke::mf_static|Smoke::mf_enum, 42, 350},	//657 QGlobalSpace::KST_KServiceGroup (enum)
    {48, 56, 0, 0, Smoke::mf_static|Smoke::mf_enum, 42, 351},	//658 QGlobalSpace::KST_KImageIOFormat (enum)
    {48, 60, 0, 0, Smoke::mf_static|Smoke::mf_enum, 42, 352},	//659 QGlobalSpace::KST_KProtocolInfo (enum)
    {48, 66, 0, 0, Smoke::mf_static|Smoke::mf_enum, 42, 353},	//660 QGlobalSpace::KST_KServiceSeparator (enum)
    {48, 52, 0, 0, Smoke::mf_static|Smoke::mf_enum, 42, 354},	//661 QGlobalSpace::KST_KCustom (enum)
    {48, 63, 0, 0, Smoke::mf_static|Smoke::mf_enum, 41, 355},	//662 QGlobalSpace::KST_KServiceFactory (enum)
    {48, 68, 0, 0, Smoke::mf_static|Smoke::mf_enum, 41, 356},	//663 QGlobalSpace::KST_KServiceTypeFactory (enum)
    {48, 65, 0, 0, Smoke::mf_static|Smoke::mf_enum, 41, 357},	//664 QGlobalSpace::KST_KServiceGroupFactory (enum)
    {48, 55, 0, 0, Smoke::mf_static|Smoke::mf_enum, 41, 358},	//665 QGlobalSpace::KST_KImageIO (enum)
    {48, 61, 0, 0, Smoke::mf_static|Smoke::mf_enum, 41, 359},	//666 QGlobalSpace::KST_KProtocolInfoFactory (enum)
    {48, 59, 0, 0, Smoke::mf_static|Smoke::mf_enum, 41, 360},	//667 QGlobalSpace::KST_KMimeTypeFactory (enum)
    {48, 51, 0, 0, Smoke::mf_static|Smoke::mf_enum, 41, 361},	//668 QGlobalSpace::KST_CTimeInfo (enum)
    {65, 160, 952, 1, Smoke::mf_virtual, 254, 0},	//669 QObject::event(QEvent*)
    {65, 161, 186, 2, Smoke::mf_virtual, 254, 0},	//670 QObject::eventFilter(QObject*, QEvent*)
    {65, 338, 954, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//671 QObject::timerEvent(QTimerEvent*)
    {65, 133, 956, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//672 QObject::childEvent(QChildEvent*)
    {65, 144, 952, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//673 QObject::customEvent(QEvent*)
    {65, 140, 3, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//674 QObject::connectNotify(const char*)
    {65, 150, 3, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//675 QObject::disconnectNotify(const char*)
    {96, 149, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 319, 0},	//676 QWidget::devType() const
    {96, 315, 40, 1, Smoke::mf_property|Smoke::mf_virtual|Smoke::mf_slot, 0, 0},	//677 QWidget::setVisible(bool)
    {96, 319, 0, 0, Smoke::mf_const|Smoke::mf_property|Smoke::mf_virtual, 155, 0},	//678 QWidget::sizeHint() const
    {96, 199, 0, 0, Smoke::mf_const|Smoke::mf_property|Smoke::mf_virtual, 155, 0},	//679 QWidget::minimumSizeHint() const
    {96, 167, 96, 1, Smoke::mf_const|Smoke::mf_virtual, 319, 0},	//680 QWidget::heightForWidth(int) const
    {96, 266, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 133, 0},	//681 QWidget::paintEngine() const
    {96, 160, 952, 1, Smoke::mf_protected|Smoke::mf_virtual, 254, 0},	//682 QWidget::event(QEvent*)
    {96, 203, 958, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//683 QWidget::mousePressEvent(QMouseEvent*)
    {96, 204, 958, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//684 QWidget::mouseReleaseEvent(QMouseEvent*)
    {96, 201, 958, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//685 QWidget::mouseDoubleClickEvent(QMouseEvent*)
    {96, 202, 958, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//686 QWidget::mouseMoveEvent(QMouseEvent*)
    {96, 352, 960, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//687 QWidget::wheelEvent(QWheelEvent*)
    {96, 182, 94, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//688 QWidget::keyPressEvent(QKeyEvent*)
    {96, 183, 94, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//689 QWidget::keyReleaseEvent(QKeyEvent*)
    {96, 163, 962, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//690 QWidget::focusInEvent(QFocusEvent*)
    {96, 165, 962, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//691 QWidget::focusOutEvent(QFocusEvent*)
    {96, 159, 952, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//692 QWidget::enterEvent(QEvent*)
    {96, 193, 952, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//693 QWidget::leaveEvent(QEvent*)
    {96, 267, 964, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//694 QWidget::paintEvent(QPaintEvent*)
    {96, 205, 966, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//695 QWidget::moveEvent(QMoveEvent*)
    {96, 290, 182, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//696 QWidget::resizeEvent(QResizeEvent*)
    {96, 136, 92, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//697 QWidget::closeEvent(QCloseEvent*)
    {96, 141, 184, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//698 QWidget::contextMenuEvent(QContextMenuEvent*)
    {96, 329, 968, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//699 QWidget::tabletEvent(QTabletEvent*)
    {96, 91, 970, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//700 QWidget::actionEvent(QActionEvent*)
    {96, 152, 972, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//701 QWidget::dragEnterEvent(QDragEnterEvent*)
    {96, 154, 974, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//702 QWidget::dragMoveEvent(QDragMoveEvent*)
    {96, 153, 976, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//703 QWidget::dragLeaveEvent(QDragLeaveEvent*)
    {96, 155, 978, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//704 QWidget::dropEvent(QDropEvent*)
    {96, 316, 1, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//705 QWidget::showEvent(QShowEvent*)
    {96, 168, 90, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//706 QWidget::hideEvent(QHideEvent*)
    {96, 354, 980, 1, Smoke::mf_protected|Smoke::mf_virtual, 254, 0},	//707 QWidget::x11Event(_XEvent*)
    {96, 127, 952, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//708 QWidget::changeEvent(QEvent*)
    {96, 198, 982, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 319, 0},	//709 QWidget::metric(QPaintDevice::PaintDeviceMetric) const
    {96, 175, 984, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//710 QWidget::inputMethodEvent(QInputMethodEvent*)
    {96, 176, 986, 1, Smoke::mf_const|Smoke::mf_virtual, 175, 0},	//711 QWidget::inputMethodQuery(Qt::InputMethodQuery) const
    {96, 164, 40, 1, Smoke::mf_protected|Smoke::mf_virtual, 254, 0},	//712 QWidget::focusNextPrevChild(bool)
    {96, 328, 988, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//713 QWidget::styleChange(QStyle&)
    {96, 158, 40, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//714 QWidget::enabledChange(bool)
    {96, 268, 990, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//715 QWidget::paletteChange(const QPalette&)
    {96, 166, 992, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//716 QWidget::fontChange(const QFont&)
    {96, 353, 40, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//717 QWidget::windowActivationChange(bool)
    {96, 192, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//718 QWidget::languageChange()
    {96, 16, 0, 0, Smoke::mf_static|Smoke::mf_enum, 180, 44},	//719 QWidget::DrawWindowBackground (enum)
    {96, 15, 0, 0, Smoke::mf_static|Smoke::mf_enum, 180, 45},	//720 QWidget::DrawChildren (enum)
    {96, 21, 0, 0, Smoke::mf_static|Smoke::mf_enum, 180, 46},	//721 QWidget::IgnoreMask (enum)
};

static Smoke::Index ambiguousMethodList[] = {
    0,
    312,  // QGlobalSpace::operator!=(const QMargins&, const QMargins&)
    318,  // QGlobalSpace::operator!=(const QRect&, const QRect&)
    337,  // QGlobalSpace::operator!=(const QVariant&, const QVariantComparisonHelper&)
    399,  // QGlobalSpace::operator!=(const QStringRef&, const QStringRef&)
    414,  // QGlobalSpace::operator!=(const QByteArray&, const QByteArray&)
    452,  // QGlobalSpace::operator!=(const QSize&, const QSize&)
    455,  // QGlobalSpace::operator!=(const QPoint&, const QPoint&)
    508,  // QGlobalSpace::operator!=(const QStringRef&, const QLatin1String&)
    517,  // QGlobalSpace::operator!=(const QLatin1String&, const QStringRef&)
    518,  // QGlobalSpace::operator!=(QChar, QChar)
    528,  // QGlobalSpace::operator!=(const QRectF&, const QRectF&)
    557,  // QGlobalSpace::operator!=(const QSizeF&, const QSizeF&)
    564,  // QGlobalSpace::operator!=(const QLatin1String&, const QLatin1String&)
    628,  // QGlobalSpace::operator!=(const QPointF&, const QPointF&)
    644,  // QGlobalSpace::operator!=(QString::Null, QString::Null)
    646,  // QGlobalSpace::operator!=(QBool, QBool)
    0,
    471,  // QGlobalSpace::operator!=(const QStringRef&, const char*)
    486,  // QGlobalSpace::operator!=(const QByteArray&, const char*)
    506,  // QGlobalSpace::operator!=(const QStringRef&, const QString&)
    551,  // QGlobalSpace::operator!=(QBool, bool)
    584,  // QGlobalSpace::operator!=(QString::Null, const QString&)
    0,
    472,  // QGlobalSpace::operator!=(const char*, const QByteArray&)
    487,  // QGlobalSpace::operator!=(const QString&, const QStringRef&)
    548,  // QGlobalSpace::operator!=(bool, QBool)
    588,  // QGlobalSpace::operator!=(const QString&, QString::Null)
    605,  // QGlobalSpace::operator!=(const char*, const QStringRef&)
    635,  // QGlobalSpace::operator!=(const char*, const QLatin1String&)
    0,
    321,  // QGlobalSpace::operator*(const QPointF&, const QMatrix&)
    323,  // QGlobalSpace::operator*(const QLine&, const QTransform&)
    352,  // QGlobalSpace::operator*(const QPolygonF&, const QTransform&)
    372,  // QGlobalSpace::operator*(const QLine&, const QMatrix&)
    374,  // QGlobalSpace::operator*(const QLineF&, const QMatrix&)
    376,  // QGlobalSpace::operator*(const QPainterPath&, const QMatrix&)
    401,  // QGlobalSpace::operator*(const QPainterPath&, const QTransform&)
    421,  // QGlobalSpace::operator*(const QPolygon&, const QMatrix&)
    434,  // QGlobalSpace::operator*(const QPointF&, const QTransform&)
    448,  // QGlobalSpace::operator*(const QPoint&, const QMatrix&)
    507,  // QGlobalSpace::operator*(const QLineF&, const QTransform&)
    550,  // QGlobalSpace::operator*(const QPolygon&, const QTransform&)
    583,  // QGlobalSpace::operator*(const QRegion&, const QTransform&)
    592,  // QGlobalSpace::operator*(const QPolygonF&, const QMatrix&)
    623,  // QGlobalSpace::operator*(const QPoint&, const QTransform&)
    637,  // QGlobalSpace::operator*(const QRegion&, const QMatrix&)
    0,
    309,  // QGlobalSpace::operator*(const QPoint&, double)
    327,  // QGlobalSpace::operator*(const QSizeF&, double)
    407,  // QGlobalSpace::operator*(const QPointF&, double)
    466,  // QGlobalSpace::operator*(const QTransform&, double)
    481,  // QGlobalSpace::operator*(const QPoint&, float)
    568,  // QGlobalSpace::operator*(const QSize&, double)
    629,  // QGlobalSpace::operator*(const QPoint&, int)
    0,
    310,  // QGlobalSpace::operator*(double, const QPointF&)
    313,  // QGlobalSpace::operator*(double, const QSizeF&)
    529,  // QGlobalSpace::operator*(double, const QSize&)
    532,  // QGlobalSpace::operator*(double, const QPoint&)
    590,  // QGlobalSpace::operator*(int, const QPoint&)
    640,  // QGlobalSpace::operator*(float, const QPoint&)
    0,
    319,  // QGlobalSpace::operator+(const QSize&, const QSize&)
    355,  // QGlobalSpace::operator+(const QSizeF&, const QSizeF&)
    580,  // QGlobalSpace::operator+(const QPoint&, const QPoint&)
    607,  // QGlobalSpace::operator+(const QByteArray&, const QByteArray&)
    636,  // QGlobalSpace::operator+(const QPointF&, const QPointF&)
    0,
    346,  // QGlobalSpace::operator+(QChar, const QString&)
    432,  // QGlobalSpace::operator+(const QByteArray&, const QString&)
    535,  // QGlobalSpace::operator+(const QByteArray&, char)
    555,  // QGlobalSpace::operator+(const QByteArray&, const char*)
    602,  // QGlobalSpace::operator+(const QTransform&, double)
    0,
    386,  // QGlobalSpace::operator+(char, const QByteArray&)
    496,  // QGlobalSpace::operator+(const char*, const QByteArray&)
    610,  // QGlobalSpace::operator+(const QString&, const QByteArray&)
    643,  // QGlobalSpace::operator+(const QString&, QChar)
    0,
    381,  // QGlobalSpace::operator+(const QString&, const char*)
    388,  // QGlobalSpace::operator+(const char*, const QString&)
    437,  // QGlobalSpace::operator+(const QString&, char)
    483,  // QGlobalSpace::operator+(const QString&, const QString&)
    516,  // QGlobalSpace::operator+(char, const QString&)
    0,
    429,  // QGlobalSpace::operator-(const QPointF&)
    593,  // QGlobalSpace::operator-(const QPoint&)
    0,
    330,  // QGlobalSpace::operator-(const QSizeF&, const QSizeF&)
    553,  // QGlobalSpace::operator-(const QPoint&, const QPoint&)
    599,  // QGlobalSpace::operator-(const QPointF&, const QPointF&)
    631,  // QGlobalSpace::operator-(const QSize&, const QSize&)
    0,
    387,  // QGlobalSpace::operator/(const QPoint&, double)
    395,  // QGlobalSpace::operator/(const QTransform&, double)
    418,  // QGlobalSpace::operator/(const QSizeF&, double)
    536,  // QGlobalSpace::operator/(const QPointF&, double)
    617,  // QGlobalSpace::operator/(const QSize&, double)
    0,
    400,  // QGlobalSpace::operator<(QChar, QChar)
    426,  // QGlobalSpace::operator<(const QByteArray&, const QByteArray&)
    469,  // QGlobalSpace::operator<(const QStringRef&, const QStringRef&)
    600,  // QGlobalSpace::operator<(const QLatin1String&, const QLatin1String&)
    0,
    446,  // QGlobalSpace::operator<(const char*, const QByteArray&)
    579,  // QGlobalSpace::operator<(const char*, const QLatin1String&)
    0,
    315,  // QGlobalSpace::operator<<(QDataStream&, const QSizePolicy&)
    320,  // QGlobalSpace::operator<<(QDataStream&, const QTransform&)
    322,  // QGlobalSpace::operator<<(QDataStream&, const KServiceAction&)
    328,  // QGlobalSpace::operator<<(QDataStream&, const QLine&)
    345,  // QGlobalSpace::operator<<(QDataStream&, const QRectF&)
    349,  // QGlobalSpace::operator<<(QDataStream&, const QPalette&)
    351,  // QGlobalSpace::operator<<(QDataStream&, const QByteArray&)
    363,  // QGlobalSpace::operator<<(QDataStream&, const QRegExp&)
    380,  // QGlobalSpace::operator<<(QDataStream&, const QKeySequence&)
    382,  // QGlobalSpace::operator<<(QDataStream&, const QCursor&)
    402,  // QGlobalSpace::operator<<(QDataStream&, const QBrush&)
    410,  // QGlobalSpace::operator<<(QDataStream&, const QDate&)
    431,  // QGlobalSpace::operator<<(QDataStream&, const QPixmap&)
    440,  // QGlobalSpace::operator<<(QDataStream&, const QUrl&)
    443,  // QGlobalSpace::operator<<(QDataStream&, const QVariant&)
    465,  // QGlobalSpace::operator<<(QDataStream&, const QPolygon&)
    478,  // QGlobalSpace::operator<<(QDataStream&, const QLineF&)
    480,  // QGlobalSpace::operator<<(QDataStream&, const QPointF&)
    509,  // QGlobalSpace::operator<<(QDataStream&, const QPolygonF&)
    510,  // QGlobalSpace::operator<<(QDataStream&, const QSizeF&)
    512,  // QGlobalSpace::operator<<(QDataStream&, const QFont&)
    515,  // QGlobalSpace::operator<<(QDataStream&, const QMatrix&)
    526,  // QGlobalSpace::operator<<(QDataStream&, const QPainterPath&)
    533,  // QGlobalSpace::operator<<(QDataStream&, const QPoint&)
    534,  // QGlobalSpace::operator<<(QDataStream&, const QImage&)
    542,  // QGlobalSpace::operator<<(QDataStream&, const QSize&)
    546,  // QGlobalSpace::operator<<(QDataStream&, const QChar&)
    556,  // QGlobalSpace::operator<<(QDataStream&, const QRect&)
    561,  // QGlobalSpace::operator<<(QDataStream&, const QRegion&)
    566,  // QGlobalSpace::operator<<(QDataStream&, const QColor&)
    576,  // QGlobalSpace::operator<<(QDataStream&, const QTime&)
    615,  // QGlobalSpace::operator<<(QDataStream&, const QIcon&)
    625,  // QGlobalSpace::operator<<(QDataStream&, const QDateTime&)
    0,
    598,  // QGlobalSpace::operator<<(QDataStream&, const QString&)
    616,  // QGlobalSpace::operator<<(QDataStream&, const QVariant::Type)
    0,
    499,  // QGlobalSpace::operator<=(const QStringRef&, const QStringRef&)
    538,  // QGlobalSpace::operator<=(const QByteArray&, const QByteArray&)
    540,  // QGlobalSpace::operator<=(const QLatin1String&, const QLatin1String&)
    581,  // QGlobalSpace::operator<=(QChar, QChar)
    0,
    493,  // QGlobalSpace::operator<=(const char*, const QLatin1String&)
    558,  // QGlobalSpace::operator<=(const char*, const QByteArray&)
    0,
    324,  // QGlobalSpace::operator==(const QMargins&, const QMargins&)
    333,  // QGlobalSpace::operator==(const QLatin1String&, const QStringRef&)
    339,  // QGlobalSpace::operator==(QBool, QBool)
    342,  // QGlobalSpace::operator==(QString::Null, QString::Null)
    394,  // QGlobalSpace::operator==(const QPointF&, const QPointF&)
    409,  // QGlobalSpace::operator==(const QSize&, const QSize&)
    439,  // QGlobalSpace::operator==(const QVariant&, const QVariantComparisonHelper&)
    461,  // QGlobalSpace::operator==(const QHashDummyValue&, const QHashDummyValue&)
    494,  // QGlobalSpace::operator==(const QPoint&, const QPoint&)
    504,  // QGlobalSpace::operator==(QChar, QChar)
    520,  // QGlobalSpace::operator==(const QLatin1String&, const QLatin1String&)
    523,  // QGlobalSpace::operator==(const QSizeF&, const QSizeF&)
    527,  // QGlobalSpace::operator==(const QStringRef&, const QStringRef&)
    547,  // QGlobalSpace::operator==(const QRectF&, const QRectF&)
    597,  // QGlobalSpace::operator==(const QByteArray&, const QByteArray&)
    639,  // QGlobalSpace::operator==(const QRect&, const QRect&)
    647,  // QGlobalSpace::operator==(const QStringRef&, const QLatin1String&)
    0,
    459,  // QGlobalSpace::operator==(const QStringRef&, const QString&)
    569,  // QGlobalSpace::operator==(QString::Null, const QString&)
    573,  // QGlobalSpace::operator==(const QByteArray&, const char*)
    604,  // QGlobalSpace::operator==(const QStringRef&, const char*)
    638,  // QGlobalSpace::operator==(QBool, bool)
    0,
    389,  // QGlobalSpace::operator==(const char*, const QByteArray&)
    411,  // QGlobalSpace::operator==(const char*, const QLatin1String&)
    424,  // QGlobalSpace::operator==(const QString&, QString::Null)
    495,  // QGlobalSpace::operator==(const char*, const QStringRef&)
    563,  // QGlobalSpace::operator==(const QString&, const QStringRef&)
    620,  // QGlobalSpace::operator==(bool, QBool)
    0,
    422,  // QGlobalSpace::operator>(QChar, QChar)
    473,  // QGlobalSpace::operator>(const QStringRef&, const QStringRef&)
    492,  // QGlobalSpace::operator>(const QByteArray&, const QByteArray&)
    586,  // QGlobalSpace::operator>(const QLatin1String&, const QLatin1String&)
    0,
    329,  // QGlobalSpace::operator>(const char*, const QLatin1String&)
    543,  // QGlobalSpace::operator>(const char*, const QByteArray&)
    0,
    332,  // QGlobalSpace::operator>=(const QByteArray&, const QByteArray&)
    438,  // QGlobalSpace::operator>=(const QStringRef&, const QStringRef&)
    460,  // QGlobalSpace::operator>=(const QLatin1String&, const QLatin1String&)
    537,  // QGlobalSpace::operator>=(QChar, QChar)
    0,
    403,  // QGlobalSpace::operator>=(const char*, const QLatin1String&)
    423,  // QGlobalSpace::operator>=(const char*, const QByteArray&)
    0,
    314,  // QGlobalSpace::operator>>(QDataStream&, QImage&)
    343,  // QGlobalSpace::operator>>(QDataStream&, KServiceAction&)
    362,  // QGlobalSpace::operator>>(QDataStream&, QColor&)
    378,  // QGlobalSpace::operator>>(QDataStream&, QPointF&)
    384,  // QGlobalSpace::operator>>(QDataStream&, QDate&)
    390,  // QGlobalSpace::operator>>(QDataStream&, QByteArray&)
    391,  // QGlobalSpace::operator>>(QDataStream&, QVariant&)
    393,  // QGlobalSpace::operator>>(QDataStream&, QRegExp&)
    406,  // QGlobalSpace::operator>>(QDataStream&, QRegion&)
    416,  // QGlobalSpace::operator>>(QDataStream&, QCursor&)
    420,  // QGlobalSpace::operator>>(QDataStream&, QTransform&)
    428,  // QGlobalSpace::operator>>(QDataStream&, QSizeF&)
    444,  // QGlobalSpace::operator>>(QDataStream&, QLine&)
    464,  // QGlobalSpace::operator>>(QDataStream&, QIcon&)
    479,  // QGlobalSpace::operator>>(QDataStream&, QBrush&)
    491,  // QGlobalSpace::operator>>(QDataStream&, QSizePolicy&)
    497,  // QGlobalSpace::operator>>(QDataStream&, QMatrix&)
    500,  // QGlobalSpace::operator>>(QDataStream&, QSize&)
    524,  // QGlobalSpace::operator>>(QDataStream&, QPolygonF&)
    525,  // QGlobalSpace::operator>>(QDataStream&, QPalette&)
    539,  // QGlobalSpace::operator>>(QDataStream&, QFont&)
    545,  // QGlobalSpace::operator>>(QDataStream&, QRectF&)
    572,  // QGlobalSpace::operator>>(QDataStream&, QPoint&)
    574,  // QGlobalSpace::operator>>(QDataStream&, QDateTime&)
    577,  // QGlobalSpace::operator>>(QDataStream&, QKeySequence&)
    594,  // QGlobalSpace::operator>>(QDataStream&, QPolygon&)
    601,  // QGlobalSpace::operator>>(QDataStream&, QChar&)
    606,  // QGlobalSpace::operator>>(QDataStream&, QPixmap&)
    611,  // QGlobalSpace::operator>>(QDataStream&, QRect&)
    618,  // QGlobalSpace::operator>>(QDataStream&, QLineF&)
    619,  // QGlobalSpace::operator>>(QDataStream&, QPainterPath&)
    627,  // QGlobalSpace::operator>>(QDataStream&, QTime&)
    641,  // QGlobalSpace::operator>>(QDataStream&, QUrl&)
    0,
    503,  // QGlobalSpace::operator>>(QDataStream&, QVariant::Type&)
    596,  // QGlobalSpace::operator>>(QDataStream&, QString&)
    0,
    308,  // QGlobalSpace::operator|(Qt::DockWidgetArea, int)
    311,  // QGlobalSpace::operator|(Qt::MouseButton, QFlags<Qt::MouseButton>)
    316,  // QGlobalSpace::operator|(Qt::InputMethodHint, int)
    317,  // QGlobalSpace::operator|(KLocale::DateTimeFormatOption, KLocale::DateTimeFormatOption)
    325,  // QGlobalSpace::operator|(KEmoticonsTheme::ParseModeEnum, int)
    326,  // QGlobalSpace::operator|(Qt::WindowState, QFlags<Qt::WindowState>)
    331,  // QGlobalSpace::operator|(KLocale::TimeFormatOption, QFlags<KLocale::TimeFormatOption>)
    334,  // QGlobalSpace::operator|(Qt::MouseButton, Qt::MouseButton)
    335,  // QGlobalSpace::operator|(KUrl::CleanPathOption, QFlags<KUrl::CleanPathOption>)
    336,  // QGlobalSpace::operator|(KUrl::CleanPathOption, KUrl::CleanPathOption)
    338,  // QGlobalSpace::operator|(KEmoticonsTheme::ParseModeEnum, KEmoticonsTheme::ParseModeEnum)
    340,  // QGlobalSpace::operator|(KConfigBase::WriteConfigFlag, int)
    341,  // QGlobalSpace::operator|(Qt::AlignmentFlag, QFlags<Qt::AlignmentFlag>)
    347,  // QGlobalSpace::operator|(QIODevice::OpenModeFlag, QFlags<QIODevice::OpenModeFlag>)
    348,  // QGlobalSpace::operator|(KDialog::ButtonCode, KDialog::ButtonCode)
    353,  // QGlobalSpace::operator|(Qt::ToolBarArea, Qt::ToolBarArea)
    354,  // QGlobalSpace::operator|(KUrl::QueryItemsOption, int)
    356,  // QGlobalSpace::operator|(QWidget::RenderFlag, int)
    357,  // QGlobalSpace::operator|(Qt::DropAction, int)
    359,  // QGlobalSpace::operator|(KUrl::EncodedPathAndQueryOption, KUrl::EncodedPathAndQueryOption)
    360,  // QGlobalSpace::operator|(KConfig::OpenFlag, QFlags<KConfig::OpenFlag>)
    361,  // QGlobalSpace::operator|(Qt::AlignmentFlag, Qt::AlignmentFlag)
    364,  // QGlobalSpace::operator|(QUrl::FormattingOption, int)
    368,  // QGlobalSpace::operator|(KUrl::DirectoryOption, KUrl::DirectoryOption)
    370,  // QGlobalSpace::operator|(Qt::DockWidgetArea, QFlags<Qt::DockWidgetArea>)
    371,  // QGlobalSpace::operator|(KDialog::CaptionFlag, KDialog::CaptionFlag)
    373,  // QGlobalSpace::operator|(KUrl::DirectoryOption, QFlags<KUrl::DirectoryOption>)
    375,  // QGlobalSpace::operator|(Qt::Orientation, Qt::Orientation)
    377,  // QGlobalSpace::operator|(Qt::ToolBarArea, int)
    379,  // QGlobalSpace::operator|(Qt::MatchFlag, int)
    383,  // QGlobalSpace::operator|(Qt::GestureFlag, Qt::GestureFlag)
    385,  // QGlobalSpace::operator|(QIODevice::OpenModeFlag, QIODevice::OpenModeFlag)
    392,  // QGlobalSpace::operator|(KDialog::ButtonCode, int)
    396,  // QGlobalSpace::operator|(KLocale::DateTimeComponent, QFlags<KLocale::DateTimeComponent>)
    404,  // QGlobalSpace::operator|(KDialog::ButtonCode, QFlags<KDialog::ButtonCode>)
    405,  // QGlobalSpace::operator|(KLocale::DateTimeFormatOption, int)
    408,  // QGlobalSpace::operator|(KUrl::EncodedPathAndQueryOption, int)
    412,  // QGlobalSpace::operator|(Qt::MatchFlag, QFlags<Qt::MatchFlag>)
    413,  // QGlobalSpace::operator|(Qt::GestureFlag, int)
    415,  // QGlobalSpace::operator|(QSizePolicy::ControlType, QSizePolicy::ControlType)
    417,  // QGlobalSpace::operator|(Qt::KeyboardModifier, QFlags<Qt::KeyboardModifier>)
    419,  // QGlobalSpace::operator|(Qt::MatchFlag, Qt::MatchFlag)
    425,  // QGlobalSpace::operator|(KCModule::Button, QFlags<KCModule::Button>)
    427,  // QGlobalSpace::operator|(QLibrary::LoadHint, int)
    430,  // QGlobalSpace::operator|(Qt::ItemFlag, Qt::ItemFlag)
    433,  // QGlobalSpace::operator|(Qt::WindowType, QFlags<Qt::WindowType>)
    435,  // QGlobalSpace::operator|(Qt::ItemFlag, QFlags<Qt::ItemFlag>)
    436,  // QGlobalSpace::operator|(Qt::TouchPointState, QFlags<Qt::TouchPointState>)
    441,  // QGlobalSpace::operator|(QSizePolicy::ControlType, QFlags<QSizePolicy::ControlType>)
    445,  // QGlobalSpace::operator|(Qt::KeyboardModifier, Qt::KeyboardModifier)
    447,  // QGlobalSpace::operator|(Qt::AlignmentFlag, int)
    449,  // QGlobalSpace::operator|(Qt::KeyboardModifier, int)
    450,  // QGlobalSpace::operator|(Qt::ItemFlag, int)
    451,  // QGlobalSpace::operator|(KLocale::TimeProcessingOption, KLocale::TimeProcessingOption)
    453,  // QGlobalSpace::operator|(Qt::ImageConversionFlag, QFlags<Qt::ImageConversionFlag>)
    456,  // QGlobalSpace::operator|(QString::SectionFlag, int)
    457,  // QGlobalSpace::operator|(Qt::WindowType, int)
    458,  // QGlobalSpace::operator|(QWidget::RenderFlag, QWidget::RenderFlag)
    462,  // QGlobalSpace::operator|(KUrl::EqualsOption, KUrl::EqualsOption)
    463,  // QGlobalSpace::operator|(QUrl::FormattingOption, QUrl::FormattingOption)
    467,  // QGlobalSpace::operator|(Qt::TouchPointState, int)
    468,  // QGlobalSpace::operator|(KDialog::CaptionFlag, QFlags<KDialog::CaptionFlag>)
    470,  // QGlobalSpace::operator|(QWidget::RenderFlag, QFlags<QWidget::RenderFlag>)
    474,  // QGlobalSpace::operator|(KUrl::CleanPathOption, int)
    475,  // QGlobalSpace::operator|(KUrl::QueryItemsOption, KUrl::QueryItemsOption)
    476,  // QGlobalSpace::operator|(KConfigBase::WriteConfigFlag, KConfigBase::WriteConfigFlag)
    477,  // QGlobalSpace::operator|(KConfig::OpenFlag, int)
    482,  // QGlobalSpace::operator|(KLocale::TimeFormatOption, KLocale::TimeFormatOption)
    488,  // QGlobalSpace::operator|(KUrl::EqualsOption, int)
    489,  // QGlobalSpace::operator|(KDialog::CaptionFlag, int)
    490,  // QGlobalSpace::operator|(QSizePolicy::ControlType, int)
    498,  // QGlobalSpace::operator|(Qt::MouseButton, int)
    501,  // QGlobalSpace::operator|(Qt::InputMethodHint, Qt::InputMethodHint)
    502,  // QGlobalSpace::operator|(KLocale::TimeProcessingOption, QFlags<KLocale::TimeProcessingOption>)
    505,  // QGlobalSpace::operator|(Qt::TextInteractionFlag, QFlags<Qt::TextInteractionFlag>)
    511,  // QGlobalSpace::operator|(Qt::ToolBarArea, QFlags<Qt::ToolBarArea>)
    513,  // QGlobalSpace::operator|(KUrl::EqualsOption, QFlags<KUrl::EqualsOption>)
    514,  // QGlobalSpace::operator|(KLocale::TimeProcessingOption, int)
    519,  // QGlobalSpace::operator|(QLibrary::LoadHint, QLibrary::LoadHint)
    521,  // QGlobalSpace::operator|(Qt::WindowState, Qt::WindowState)
    522,  // QGlobalSpace::operator|(QUrl::FormattingOption, QFlags<QUrl::FormattingOption>)
    530,  // QGlobalSpace::operator|(KCModule::Button, KCModule::Button)
    541,  // QGlobalSpace::operator|(QString::SectionFlag, QFlags<QString::SectionFlag>)
    544,  // QGlobalSpace::operator|(KLocale::DateTimeFormatOption, QFlags<KLocale::DateTimeFormatOption>)
    549,  // QGlobalSpace::operator|(KUrl::QueryItemsOption, QFlags<KUrl::QueryItemsOption>)
    552,  // QGlobalSpace::operator|(Qt::WindowState, int)
    559,  // QGlobalSpace::operator|(KUrl::DirectoryOption, int)
    562,  // QGlobalSpace::operator|(Qt::DockWidgetArea, Qt::DockWidgetArea)
    565,  // QGlobalSpace::operator|(KLocale::DateTimeComponent, KLocale::DateTimeComponent)
    567,  // QGlobalSpace::operator|(Qt::WindowType, Qt::WindowType)
    570,  // QGlobalSpace::operator|(Qt::InputMethodHint, QFlags<Qt::InputMethodHint>)
    571,  // QGlobalSpace::operator|(KConfig::OpenFlag, KConfig::OpenFlag)
    582,  // QGlobalSpace::operator|(KLocale::TimeFormatOption, int)
    585,  // QGlobalSpace::operator|(KCModule::Button, int)
    587,  // QGlobalSpace::operator|(QString::SectionFlag, QString::SectionFlag)
    589,  // QGlobalSpace::operator|(QIODevice::OpenModeFlag, int)
    591,  // QGlobalSpace::operator|(Qt::GestureFlag, QFlags<Qt::GestureFlag>)
    595,  // QGlobalSpace::operator|(KUrl::EncodedPathAndQueryOption, QFlags<KUrl::EncodedPathAndQueryOption>)
    603,  // QGlobalSpace::operator|(Qt::TextInteractionFlag, Qt::TextInteractionFlag)
    608,  // QGlobalSpace::operator|(KEmoticonsTheme::ParseModeEnum, QFlags<KEmoticonsTheme::ParseModeEnum>)
    609,  // QGlobalSpace::operator|(KConfigBase::WriteConfigFlag, QFlags<KConfigBase::WriteConfigFlag>)
    612,  // QGlobalSpace::operator|(KLocale::DateTimeComponent, int)
    613,  // QGlobalSpace::operator|(Qt::ImageConversionFlag, int)
    621,  // QGlobalSpace::operator|(Qt::TouchPointState, Qt::TouchPointState)
    622,  // QGlobalSpace::operator|(Qt::TextInteractionFlag, int)
    630,  // QGlobalSpace::operator|(Qt::ImageConversionFlag, Qt::ImageConversionFlag)
    632,  // QGlobalSpace::operator|(Qt::DropAction, QFlags<Qt::DropAction>)
    633,  // QGlobalSpace::operator|(Qt::DropAction, Qt::DropAction)
    634,  // QGlobalSpace::operator|(Qt::Orientation, int)
    642,  // QGlobalSpace::operator|(QLibrary::LoadHint, QFlags<QLibrary::LoadHint>)
    645,  // QGlobalSpace::operator|(Qt::Orientation, QFlags<Qt::Orientation>)
    0,
};

// Class ID, munged name ID (index into methodNames), method def (see methods) if >0 or number of overloads if <0
static Smoke::MethodMap methodMaps[] = {
    {0, 0, 0},	//0 (no method)
    {4, 24, 24},	// KCModuleContainer::KCModuleContainer#
    {4, 25, 17},	// KCModuleContainer::KCModuleContainer#$
    {4, 26, 16},	// KCModuleContainer::KCModuleContainer#?
    {4, 105, 18},	// KCModuleContainer::addModule$
    {4, 123, 28},	// KCModuleContainer::allModules
    {4, 131, 26},	// KCModuleContainer::changedModules
    {4, 147, 21},	// KCModuleContainer::defaults
    {4, 194, 20},	// KCModuleContainer::load
    {4, 197, 9},	// KCModuleContainer::metaObject
    {4, 274, 15},	// KCModuleContainer::qt_metacall$$?
    {4, 276, 10},	// KCModuleContainer::qt_metacast$
    {4, 293, 19},	// KCModuleContainer::save
    {4, 295, 29},	// KCModuleContainer::setAllModules?
    {4, 302, 27},	// KCModuleContainer::setChangedModules?
    {4, 326, 25},	// KCModuleContainer::staticMetaObject
    {4, 340, 22},	// KCModuleContainer::tr$
    {4, 341, 11},	// KCModuleContainer::tr$$
    {4, 342, 13},	// KCModuleContainer::tr$$$
    {4, 347, 23},	// KCModuleContainer::trUtf8$
    {4, 348, 12},	// KCModuleContainer::trUtf8$$
    {4, 349, 14},	// KCModuleContainer::trUtf8$$$
    {4, 356, 30},	// KCModuleContainer::~KCModuleContainer
    {6, 28, 64},	// KCModuleProxy::KCModuleProxy#
    {6, 29, 65},	// KCModuleProxy::KCModuleProxy##
    {6, 30, 38},	// KCModuleProxy::KCModuleProxy##?
    {6, 31, 66},	// KCModuleProxy::KCModuleProxy$
    {6, 32, 67},	// KCModuleProxy::KCModuleProxy$#
    {6, 33, 39},	// KCModuleProxy::KCModuleProxy$#?
    {6, 34, 68},	// KCModuleProxy::KCModuleProxy?
    {6, 35, 69},	// KCModuleProxy::KCModuleProxy?#
    {6, 36, 40},	// KCModuleProxy::KCModuleProxy?#?
    {6, 89, 44},	// KCModuleProxy::aboutData
    {6, 125, 45},	// KCModuleProxy::buttons
    {6, 128, 49},	// KCModuleProxy::changed
    {6, 129, 58},	// KCModuleProxy::changed#
    {6, 130, 57},	// KCModuleProxy::changed$
    {6, 132, 59},	// KCModuleProxy::childClosed
    {6, 137, 48},	// KCModuleProxy::componentData
    {6, 145, 53},	// KCModuleProxy::dbusPath
    {6, 146, 52},	// KCModuleProxy::dbusService
    {6, 147, 55},	// KCModuleProxy::defaults
    {6, 148, 56},	// KCModuleProxy::deleteClient
    {6, 194, 41},	// KCModuleProxy::load
    {6, 197, 31},	// KCModuleProxy::metaObject
    {6, 199, 54},	// KCModuleProxy::minimumSizeHint
    {6, 200, 51},	// KCModuleProxy::moduleInfo
    {6, 274, 37},	// KCModuleProxy::qt_metacall$$?
    {6, 276, 32},	// KCModuleProxy::qt_metacast$
    {6, 277, 43},	// KCModuleProxy::quickHelp
    {6, 278, 60},	// KCModuleProxy::quickHelpChanged
    {6, 279, 50},	// KCModuleProxy::realModule
    {6, 292, 46},	// KCModuleProxy::rootOnlyMessage
    {6, 293, 42},	// KCModuleProxy::save
    {6, 317, 61},	// KCModuleProxy::showEvent#
    {6, 326, 70},	// KCModuleProxy::staticMetaObject
    {6, 340, 62},	// KCModuleProxy::tr$
    {6, 341, 33},	// KCModuleProxy::tr$$
    {6, 342, 35},	// KCModuleProxy::tr$$$
    {6, 347, 63},	// KCModuleProxy::trUtf8$
    {6, 348, 34},	// KCModuleProxy::trUtf8$$
    {6, 349, 36},	// KCModuleProxy::trUtf8$$$
    {6, 351, 47},	// KCModuleProxy::useRootOnlyMessage
    {6, 357, 71},	// KCModuleProxy::~KCModuleProxy
    {7, 37, 95},	// KCMultiDialog::KCMultiDialog
    {7, 38, 79},	// KCMultiDialog::KCMultiDialog#
    {7, 39, 99},	// KCMultiDialog::KCMultiDialog##
    {7, 40, 100},	// KCMultiDialog::KCMultiDialog###
    {7, 41, 87},	// KCMultiDialog::KCMultiDialog###$
    {7, 42, 86},	// KCMultiDialog::KCMultiDialog##$
    {7, 102, 97},	// KCMultiDialog::addModule#
    {7, 103, 98},	// KCMultiDialog::addModule##
    {7, 104, 81},	// KCMultiDialog::addModule##?
    {7, 105, 96},	// KCMultiDialog::addModule$
    {7, 106, 80},	// KCMultiDialog::addModule$?
    {7, 134, 82},	// KCMultiDialog::clear
    {7, 138, 84},	// KCMultiDialog::configCommitted
    {7, 139, 85},	// KCMultiDialog::configCommitted#
    {7, 197, 72},	// KCMultiDialog::metaObject
    {7, 274, 78},	// KCMultiDialog::qt_metacall$$?
    {7, 276, 73},	// KCMultiDialog::qt_metacast$
    {7, 299, 83},	// KCMultiDialog::setButtons$
    {7, 320, 90},	// KCMultiDialog::slotApplyClicked
    {7, 322, 88},	// KCMultiDialog::slotDefaultClicked
    {7, 323, 92},	// KCMultiDialog::slotHelpClicked
    {7, 324, 91},	// KCMultiDialog::slotOkClicked
    {7, 325, 89},	// KCMultiDialog::slotUser1Clicked
    {7, 326, 101},	// KCMultiDialog::staticMetaObject
    {7, 340, 93},	// KCMultiDialog::tr$
    {7, 341, 74},	// KCMultiDialog::tr$$
    {7, 342, 76},	// KCMultiDialog::tr$$$
    {7, 347, 94},	// KCMultiDialog::trUtf8$
    {7, 348, 75},	// KCMultiDialog::trUtf8$$
    {7, 349, 77},	// KCMultiDialog::trUtf8$$$
    {7, 358, 102},	// KCMultiDialog::~KCMultiDialog
    {11, 43, 139},	// KEmoticons::KEmoticons
    {11, 143, 142},	// KEmoticons::currentThemeName
    {11, 178, 147},	// KEmoticons::installTheme$
    {11, 197, 132},	// KEmoticons::metaObject
    {11, 207, 146},	// KEmoticons::newTheme$?
    {11, 269, 149},	// KEmoticons::parseMode
    {11, 274, 138},	// KEmoticons::qt_metacall$$?
    {11, 276, 133},	// KEmoticons::qt_metacast$
    {11, 308, 148},	// KEmoticons::setParseMode$
    {11, 311, 144},	// KEmoticons::setTheme#
    {11, 312, 145},	// KEmoticons::setTheme$
    {11, 326, 152},	// KEmoticons::staticMetaObject
    {11, 330, 140},	// KEmoticons::theme
    {11, 331, 141},	// KEmoticons::theme$
    {11, 332, 143},	// KEmoticons::themeList
    {11, 340, 150},	// KEmoticons::tr$
    {11, 341, 134},	// KEmoticons::tr$$
    {11, 342, 136},	// KEmoticons::tr$$$
    {11, 347, 151},	// KEmoticons::trUtf8$
    {11, 348, 135},	// KEmoticons::trUtf8$$
    {11, 349, 137},	// KEmoticons::trUtf8$$$
    {11, 359, 153},	// KEmoticons::~KEmoticons
    {12, 6, 184},	// KEmoticonsProvider::Copy
    {12, 14, 183},	// KEmoticonsProvider::DoNotCopy
    {12, 44, 180},	// KEmoticonsProvider::KEmoticonsProvider
    {12, 45, 161},	// KEmoticonsProvider::KEmoticonsProvider#
    {12, 93, 181},	// KEmoticonsProvider::addEmoticon$$
    {12, 94, 164},	// KEmoticonsProvider::addEmoticon$$$
    {12, 96, 176},	// KEmoticonsProvider::addEmoticonIndex$?
    {12, 98, 174},	// KEmoticonsProvider::addEmoticonsMap$?
    {12, 135, 173},	// KEmoticonsProvider::clearEmoticonsMap
    {12, 142, 172},	// KEmoticonsProvider::createNew
    {12, 156, 171},	// KEmoticonsProvider::emoticonsIndex
    {12, 157, 170},	// KEmoticonsProvider::emoticonsMap
    {12, 162, 169},	// KEmoticonsProvider::fileName
    {12, 196, 162},	// KEmoticonsProvider::loadTheme$
    {12, 197, 154},	// KEmoticonsProvider::metaObject
    {12, 274, 160},	// KEmoticonsProvider::qt_metacall$$?
    {12, 276, 155},	// KEmoticonsProvider::qt_metacast$
    {12, 283, 163},	// KEmoticonsProvider::removeEmoticon$
    {12, 285, 177},	// KEmoticonsProvider::removeEmoticonIndex$?
    {12, 287, 175},	// KEmoticonsProvider::removeEmoticonsMap$
    {12, 293, 165},	// KEmoticonsProvider::save
    {12, 314, 167},	// KEmoticonsProvider::setThemeName$
    {12, 326, 182},	// KEmoticonsProvider::staticMetaObject
    {12, 333, 166},	// KEmoticonsProvider::themeName
    {12, 334, 168},	// KEmoticonsProvider::themePath
    {12, 340, 178},	// KEmoticonsProvider::tr$
    {12, 341, 156},	// KEmoticonsProvider::tr$$
    {12, 342, 158},	// KEmoticonsProvider::tr$$$
    {12, 347, 179},	// KEmoticonsProvider::trUtf8$
    {12, 348, 157},	// KEmoticonsProvider::trUtf8$$
    {12, 349, 159},	// KEmoticonsProvider::trUtf8$$$
    {12, 360, 185},	// KEmoticonsProvider::~KEmoticonsProvider
    {14, 100, 197},	// KIdleTime::addIdleTimeout$
    {14, 126, 200},	// KIdleTime::catchNextResumeEvent
    {14, 173, 194},	// KIdleTime::idleTime
    {14, 174, 195},	// KIdleTime::idleTimeouts
    {14, 179, 193},	// KIdleTime::instance
    {14, 197, 186},	// KIdleTime::metaObject
    {14, 274, 192},	// KIdleTime::qt_metacall$$?
    {14, 276, 187},	// KIdleTime::qt_metacast$
    {14, 281, 199},	// KIdleTime::removeAllIdleTimeouts
    {14, 289, 198},	// KIdleTime::removeIdleTimeout$
    {14, 291, 202},	// KIdleTime::resumingFromIdle
    {14, 318, 196},	// KIdleTime::simulateUserActivity
    {14, 326, 207},	// KIdleTime::staticMetaObject
    {14, 327, 201},	// KIdleTime::stopCatchingResumeEvent
    {14, 336, 203},	// KIdleTime::timeoutReached$
    {14, 337, 204},	// KIdleTime::timeoutReached$$
    {14, 340, 205},	// KIdleTime::tr$
    {14, 341, 188},	// KIdleTime::tr$$
    {14, 342, 190},	// KIdleTime::tr$$$
    {14, 347, 206},	// KIdleTime::trUtf8$
    {14, 348, 189},	// KIdleTime::trUtf8$$
    {14, 349, 191},	// KIdleTime::trUtf8$$$
    {14, 361, 208},	// KIdleTime::~KIdleTime
    {20, 20, 242},	// KPluginSelector::IgnoreConfigFile
    {20, 46, 229},	// KPluginSelector::KPluginSelector
    {20, 47, 216},	// KPluginSelector::KPluginSelector#
    {20, 81, 241},	// KPluginSelector::ReadConfigFile
    {20, 110, 233},	// KPluginSelector::addPlugins#
    {20, 111, 234},	// KPluginSelector::addPlugins#$
    {20, 112, 235},	// KPluginSelector::addPlugins#$$
    {20, 113, 218},	// KPluginSelector::addPlugins#$$?
    {20, 114, 230},	// KPluginSelector::addPlugins$
    {20, 115, 231},	// KPluginSelector::addPlugins$$
    {20, 116, 232},	// KPluginSelector::addPlugins$$$
    {20, 117, 217},	// KPluginSelector::addPlugins$$$?
    {20, 118, 236},	// KPluginSelector::addPlugins?
    {20, 119, 237},	// KPluginSelector::addPlugins?$
    {20, 120, 238},	// KPluginSelector::addPlugins?$$
    {20, 121, 239},	// KPluginSelector::addPlugins?$$$
    {20, 122, 219},	// KPluginSelector::addPlugins?$$$?
    {20, 130, 225},	// KPluginSelector::changed$
    {20, 139, 226},	// KPluginSelector::configCommitted#
    {20, 147, 222},	// KPluginSelector::defaults
    {20, 181, 223},	// KPluginSelector::isDefault
    {20, 194, 220},	// KPluginSelector::load
    {20, 197, 209},	// KPluginSelector::metaObject
    {20, 274, 215},	// KPluginSelector::qt_metacall$$?
    {20, 276, 210},	// KPluginSelector::qt_metacast$
    {20, 293, 221},	// KPluginSelector::save
    {20, 326, 240},	// KPluginSelector::staticMetaObject
    {20, 340, 227},	// KPluginSelector::tr$
    {20, 341, 211},	// KPluginSelector::tr$$
    {20, 342, 213},	// KPluginSelector::tr$$$
    {20, 347, 228},	// KPluginSelector::trUtf8$
    {20, 348, 212},	// KPluginSelector::trUtf8$$
    {20, 349, 214},	// KPluginSelector::trUtf8$$$
    {20, 350, 224},	// KPluginSelector::updatePluginsState
    {20, 362, 243},	// KPluginSelector::~KPluginSelector
    {21, 49, 256},	// KPrintPreview::KPrintPreview#
    {21, 50, 251},	// KPrintPreview::KPrintPreview##
    {21, 180, 252},	// KPrintPreview::isAvailable
    {21, 197, 244},	// KPrintPreview::metaObject
    {21, 274, 250},	// KPrintPreview::qt_metacall$$?
    {21, 276, 245},	// KPrintPreview::qt_metacast$
    {21, 317, 253},	// KPrintPreview::showEvent#
    {21, 326, 257},	// KPrintPreview::staticMetaObject
    {21, 340, 254},	// KPrintPreview::tr$
    {21, 341, 246},	// KPrintPreview::tr$$
    {21, 342, 248},	// KPrintPreview::tr$$$
    {21, 347, 255},	// KPrintPreview::trUtf8$
    {21, 348, 247},	// KPrintPreview::trUtf8$$
    {21, 349, 249},	// KPrintPreview::trUtf8$$$
    {21, 363, 258},	// KPrintPreview::~KPrintPreview
    {24, 10, 278},	// KSettings::Dialog::Dialog
    {24, 11, 266},	// KSettings::Dialog::Dialog#
    {24, 12, 279},	// KSettings::Dialog::Dialog?
    {24, 13, 267},	// KSettings::Dialog::Dialog?#
    {24, 108, 268},	// KSettings::Dialog::addPluginInfos?
    {24, 124, 272},	// KSettings::Dialog::allowComponentSelection
    {24, 197, 259},	// KSettings::Dialog::metaObject
    {24, 270, 273},	// KSettings::Dialog::pluginInfos
    {24, 271, 275},	// KSettings::Dialog::pluginSelectionChanged
    {24, 274, 265},	// KSettings::Dialog::qt_metacall$$?
    {24, 276, 260},	// KSettings::Dialog::qt_metacast$
    {24, 297, 271},	// KSettings::Dialog::setAllowComponentSelection$
    {24, 304, 270},	// KSettings::Dialog::setComponentBlacklist?
    {24, 306, 269},	// KSettings::Dialog::setKCMArguments?
    {24, 317, 274},	// KSettings::Dialog::showEvent#
    {24, 326, 280},	// KSettings::Dialog::staticMetaObject
    {24, 340, 276},	// KSettings::Dialog::tr$
    {24, 341, 261},	// KSettings::Dialog::tr$$
    {24, 342, 263},	// KSettings::Dialog::tr$$$
    {24, 347, 277},	// KSettings::Dialog::trUtf8$
    {24, 348, 262},	// KSettings::Dialog::trUtf8$$
    {24, 349, 264},	// KSettings::Dialog::trUtf8$$$
    {24, 355, 281},	// KSettings::Dialog::~Dialog
    {25, 78, 296},	// KSettings::PluginPage::PluginPage#
    {25, 79, 297},	// KSettings::PluginPage::PluginPage##
    {25, 80, 289},	// KSettings::PluginPage::PluginPage##?
    {25, 147, 293},	// KSettings::PluginPage::defaults
    {25, 194, 291},	// KSettings::PluginPage::load
    {25, 197, 282},	// KSettings::PluginPage::metaObject
    {25, 272, 290},	// KSettings::PluginPage::pluginSelector
    {25, 274, 288},	// KSettings::PluginPage::qt_metacall$$?
    {25, 276, 283},	// KSettings::PluginPage::qt_metacast$
    {25, 293, 292},	// KSettings::PluginPage::save
    {25, 326, 298},	// KSettings::PluginPage::staticMetaObject
    {25, 340, 294},	// KSettings::PluginPage::tr$
    {25, 341, 284},	// KSettings::PluginPage::tr$$
    {25, 342, 286},	// KSettings::PluginPage::tr$$$
    {25, 347, 295},	// KSettings::PluginPage::trUtf8$
    {25, 348, 285},	// KSettings::PluginPage::trUtf8$$
    {25, 349, 287},	// KSettings::PluginPage::trUtf8$$$
    {25, 364, 299},	// KSettings::PluginPage::~PluginPage
    {48, 51, 668},	// QGlobalSpace::KST_CTimeInfo
    {48, 52, 661},	// QGlobalSpace::KST_KCustom
    {48, 53, 655},	// QGlobalSpace::KST_KDEDesktopMimeType
    {48, 54, 654},	// QGlobalSpace::KST_KFolderMimeType
    {48, 55, 665},	// QGlobalSpace::KST_KImageIO
    {48, 56, 658},	// QGlobalSpace::KST_KImageIOFormat
    {48, 57, 653},	// QGlobalSpace::KST_KMimeType
    {48, 58, 656},	// QGlobalSpace::KST_KMimeTypeEntry
    {48, 59, 667},	// QGlobalSpace::KST_KMimeTypeFactory
    {48, 60, 659},	// QGlobalSpace::KST_KProtocolInfo
    {48, 61, 666},	// QGlobalSpace::KST_KProtocolInfoFactory
    {48, 62, 651},	// QGlobalSpace::KST_KService
    {48, 63, 662},	// QGlobalSpace::KST_KServiceFactory
    {48, 64, 657},	// QGlobalSpace::KST_KServiceGroup
    {48, 65, 664},	// QGlobalSpace::KST_KServiceGroupFactory
    {48, 66, 660},	// QGlobalSpace::KST_KServiceSeparator
    {48, 67, 652},	// QGlobalSpace::KST_KServiceType
    {48, 68, 663},	// QGlobalSpace::KST_KServiceTypeFactory
    {48, 69, 650},	// QGlobalSpace::KST_KSycocaEntry
    {48, 170, 344},	// QGlobalSpace::i18n$
    {48, 172, 369},	// QGlobalSpace::i18nc$$
    {48, 185, 560},	// QGlobalSpace::ki18n$
    {48, 187, 398},	// QGlobalSpace::ki18nc$$
    {48, 189, 442},	// QGlobalSpace::ki18ncp$$$
    {48, 191, 626},	// QGlobalSpace::ki18np$$
    {48, 209, -1},	// QGlobalSpace::operator!=##
    {48, 210, -18},	// QGlobalSpace::operator!=#$
    {48, 211, -24},	// QGlobalSpace::operator!=$#
    {48, 212, 485},	// QGlobalSpace::operator!=$$
    {48, 214, -31},	// QGlobalSpace::operator*##
    {48, 215, -48},	// QGlobalSpace::operator*#$
    {48, 216, -56},	// QGlobalSpace::operator*$#
    {48, 218, -63},	// QGlobalSpace::operator+##
    {48, 219, -69},	// QGlobalSpace::operator+#$
    {48, 220, -75},	// QGlobalSpace::operator+$#
    {48, 221, -80},	// QGlobalSpace::operator+$$
    {48, 223, 350},	// QGlobalSpace::operator++$
    {48, 224, 649},	// QGlobalSpace::operator++$$
    {48, 226, -86},	// QGlobalSpace::operator-#
    {48, 227, -89},	// QGlobalSpace::operator-##
    {48, 228, 648},	// QGlobalSpace::operator-#$
    {48, 230, -94},	// QGlobalSpace::operator/#$
    {48, 232, -100},	// QGlobalSpace::operator<##
    {48, 233, 365},	// QGlobalSpace::operator<#$
    {48, 234, -105},	// QGlobalSpace::operator<$#
    {48, 235, 484},	// QGlobalSpace::operator<$$
    {48, 237, -108},	// QGlobalSpace::operator<<##
    {48, 238, -142},	// QGlobalSpace::operator<<#$
    {48, 239, 358},	// QGlobalSpace::operator<<#?
    {48, 241, -145},	// QGlobalSpace::operator<=##
    {48, 242, 454},	// QGlobalSpace::operator<=#$
    {48, 243, -150},	// QGlobalSpace::operator<=$#
    {48, 244, 397},	// QGlobalSpace::operator<=$$
    {48, 246, -153},	// QGlobalSpace::operator==##
    {48, 247, -171},	// QGlobalSpace::operator==#$
    {48, 248, -177},	// QGlobalSpace::operator==$#
    {48, 249, 614},	// QGlobalSpace::operator==$$
    {48, 251, -184},	// QGlobalSpace::operator>##
    {48, 252, 578},	// QGlobalSpace::operator>#$
    {48, 253, -189},	// QGlobalSpace::operator>$#
    {48, 254, 575},	// QGlobalSpace::operator>$$
    {48, 256, -192},	// QGlobalSpace::operator>=##
    {48, 257, 531},	// QGlobalSpace::operator>=#$
    {48, 258, -197},	// QGlobalSpace::operator>=$#
    {48, 259, 624},	// QGlobalSpace::operator>=$$
    {48, 261, -200},	// QGlobalSpace::operator>>##
    {48, 262, -234},	// QGlobalSpace::operator>>#$
    {48, 263, 554},	// QGlobalSpace::operator>>#?
    {48, 265, -237},	// QGlobalSpace::operator|$$
    {48, 344, 367},	// QGlobalSpace::tr2i18n$
    {48, 345, 366},	// QGlobalSpace::tr2i18n$$
};

}

extern "C" {

SMOKE_IMPORT void init_kdeui_Smoke();

static bool initialized = false;
Smoke *kutils_Smoke = 0;

// Create the Smoke instance encapsulating all the above.
void init_kutils_Smoke() {
    init_kdeui_Smoke();
    if (initialized) return;
    kutils_Smoke = new Smoke(
        "kutils",
        __smokekutils::classes, 96,
        __smokekutils::methods, 722,
        __smokekutils::methodMaps, 334,
        __smokekutils::methodNames, 364,
        __smokekutils::types, 322,
        __smokekutils::inheritanceList,
        __smokekutils::argumentList,
        __smokekutils::ambiguousMethodList,
        __smokekutils::cast );
    initialized = true;
}

void delete_kutils_Smoke() { delete kutils_Smoke; }

}
