#include <knewstuff3_includes.h>

#include <smoke.h>
#include <knewstuff3_smoke.h>

namespace __smokeknewstuff3 {

static void *cast(void *xptr, Smoke::Index from, Smoke::Index to) {
  switch(from) {
    case 1:   //KAction
      switch(to) {
        case 1: return (void*)(KAction*)xptr;
        default: return xptr;
      }
    case 2:   //KActionCollection
      switch(to) {
        case 2: return (void*)(KActionCollection*)xptr;
        default: return xptr;
      }
    case 3:   //KDialog
      switch(to) {
        case 24: return (void*)(QDialog*)(KDialog*)xptr;
        case 81: return (void*)(QWidget*)(KDialog*)xptr;
        case 50: return (void*)(QObject*)(KDialog*)xptr;
        case 3: return (void*)(KDialog*)xptr;
        case 7: return (void*)(KNS3::UploadDialog*)(KDialog*)xptr;
        case 5: return (void*)(KNS3::DownloadDialog*)(KDialog*)xptr;
        default: return xptr;
      }
    case 4:   //KNS3::Button
      switch(to) {
        case 8: return (void*)(KPushButton*)(KNS3::Button*)xptr;
        case 60: return (void*)(QPushButton*)(KNS3::Button*)xptr;
        case 10: return (void*)(QAbstractButton*)(KNS3::Button*)xptr;
        case 81: return (void*)(QWidget*)(KNS3::Button*)xptr;
        case 50: return (void*)(QObject*)(KNS3::Button*)xptr;
        case 4: return (void*)(KNS3::Button*)xptr;
        default: return xptr;
      }
    case 5:   //KNS3::DownloadDialog
      switch(to) {
        case 3: return (void*)(KDialog*)(KNS3::DownloadDialog*)xptr;
        case 24: return (void*)(QDialog*)(KNS3::DownloadDialog*)xptr;
        case 81: return (void*)(QWidget*)(KNS3::DownloadDialog*)xptr;
        case 50: return (void*)(QObject*)(KNS3::DownloadDialog*)xptr;
        case 5: return (void*)(KNS3::DownloadDialog*)xptr;
        default: return xptr;
      }
    case 6:   //KNS3::Entry
      switch(to) {
        case 6: return (void*)(KNS3::Entry*)xptr;
        default: return xptr;
      }
    case 7:   //KNS3::UploadDialog
      switch(to) {
        case 3: return (void*)(KDialog*)(KNS3::UploadDialog*)xptr;
        case 24: return (void*)(QDialog*)(KNS3::UploadDialog*)xptr;
        case 81: return (void*)(QWidget*)(KNS3::UploadDialog*)xptr;
        case 50: return (void*)(QObject*)(KNS3::UploadDialog*)xptr;
        case 7: return (void*)(KNS3::UploadDialog*)xptr;
        default: return xptr;
      }
    case 8:   //KPushButton
      switch(to) {
        case 60: return (void*)(QPushButton*)(KPushButton*)xptr;
        case 10: return (void*)(QAbstractButton*)(KPushButton*)xptr;
        case 81: return (void*)(QWidget*)(KPushButton*)xptr;
        case 50: return (void*)(QObject*)(KPushButton*)xptr;
        case 8: return (void*)(KPushButton*)xptr;
        case 4: return (void*)(KNS3::Button*)(KPushButton*)xptr;
        default: return xptr;
      }
    case 9:   //KUrl
      switch(to) {
        case 77: return (void*)(QUrl*)(KUrl*)xptr;
        case 9: return (void*)(KUrl*)xptr;
        default: return xptr;
      }
    case 10:   //QAbstractButton
      switch(to) {
        case 81: return (void*)(QWidget*)(QAbstractButton*)xptr;
        case 50: return (void*)(QObject*)(QAbstractButton*)xptr;
        case 10: return (void*)(QAbstractButton*)xptr;
        case 4: return (void*)(KNS3::Button*)(QAbstractButton*)xptr;
        default: return xptr;
      }
    case 11:   //QActionEvent
      switch(to) {
        case 11: return (void*)(QActionEvent*)xptr;
        default: return xptr;
      }
    case 12:   //QBool
      switch(to) {
        case 12: return (void*)(QBool*)xptr;
        default: return xptr;
      }
    case 13:   //QBrush
      switch(to) {
        case 13: return (void*)(QBrush*)xptr;
        default: return xptr;
      }
    case 14:   //QByteArray
      switch(to) {
        case 14: return (void*)(QByteArray*)xptr;
        default: return xptr;
      }
    case 15:   //QChar
      switch(to) {
        case 15: return (void*)(QChar*)xptr;
        default: return xptr;
      }
    case 16:   //QChildEvent
      switch(to) {
        case 16: return (void*)(QChildEvent*)xptr;
        default: return xptr;
      }
    case 17:   //QCloseEvent
      switch(to) {
        case 17: return (void*)(QCloseEvent*)xptr;
        default: return xptr;
      }
    case 18:   //QColor
      switch(to) {
        case 18: return (void*)(QColor*)xptr;
        default: return xptr;
      }
    case 19:   //QContextMenuEvent
      switch(to) {
        case 19: return (void*)(QContextMenuEvent*)xptr;
        default: return xptr;
      }
    case 20:   //QCursor
      switch(to) {
        case 20: return (void*)(QCursor*)xptr;
        default: return xptr;
      }
    case 21:   //QDataStream
      switch(to) {
        case 21: return (void*)(QDataStream*)xptr;
        default: return xptr;
      }
    case 22:   //QDate
      switch(to) {
        case 22: return (void*)(QDate*)xptr;
        default: return xptr;
      }
    case 23:   //QDateTime
      switch(to) {
        case 23: return (void*)(QDateTime*)xptr;
        default: return xptr;
      }
    case 24:   //QDialog
      switch(to) {
        case 81: return (void*)(QWidget*)(QDialog*)xptr;
        case 50: return (void*)(QObject*)(QDialog*)xptr;
        case 24: return (void*)(QDialog*)xptr;
        case 7: return (void*)(KNS3::UploadDialog*)(QDialog*)xptr;
        case 5: return (void*)(KNS3::DownloadDialog*)(QDialog*)xptr;
        default: return xptr;
      }
    case 25:   //QDrag
      switch(to) {
        case 25: return (void*)(QDrag*)xptr;
        default: return xptr;
      }
    case 26:   //QDragEnterEvent
      switch(to) {
        case 26: return (void*)(QDragEnterEvent*)xptr;
        default: return xptr;
      }
    case 27:   //QDragLeaveEvent
      switch(to) {
        case 27: return (void*)(QDragLeaveEvent*)xptr;
        default: return xptr;
      }
    case 28:   //QDragMoveEvent
      switch(to) {
        case 28: return (void*)(QDragMoveEvent*)xptr;
        default: return xptr;
      }
    case 29:   //QDropEvent
      switch(to) {
        case 29: return (void*)(QDropEvent*)xptr;
        default: return xptr;
      }
    case 30:   //QEvent
      switch(to) {
        case 30: return (void*)(QEvent*)xptr;
        default: return xptr;
      }
    case 31:   //QFocusEvent
      switch(to) {
        case 31: return (void*)(QFocusEvent*)xptr;
        default: return xptr;
      }
    case 32:   //QFont
      switch(to) {
        case 32: return (void*)(QFont*)xptr;
        default: return xptr;
      }
    case 34:   //QHashDummyValue
      switch(to) {
        case 34: return (void*)(QHashDummyValue*)xptr;
        default: return xptr;
      }
    case 35:   //QHideEvent
      switch(to) {
        case 35: return (void*)(QHideEvent*)xptr;
        default: return xptr;
      }
    case 36:   //QIcon
      switch(to) {
        case 36: return (void*)(QIcon*)xptr;
        default: return xptr;
      }
    case 37:   //QImage
      switch(to) {
        case 37: return (void*)(QImage*)xptr;
        default: return xptr;
      }
    case 38:   //QIncompatibleFlag
      switch(to) {
        case 38: return (void*)(QIncompatibleFlag*)xptr;
        default: return xptr;
      }
    case 39:   //QInputMethodEvent
      switch(to) {
        case 39: return (void*)(QInputMethodEvent*)xptr;
        default: return xptr;
      }
    case 40:   //QKeyEvent
      switch(to) {
        case 40: return (void*)(QKeyEvent*)xptr;
        default: return xptr;
      }
    case 41:   //QKeySequence
      switch(to) {
        case 41: return (void*)(QKeySequence*)xptr;
        default: return xptr;
      }
    case 42:   //QLatin1String
      switch(to) {
        case 42: return (void*)(QLatin1String*)xptr;
        default: return xptr;
      }
    case 43:   //QLine
      switch(to) {
        case 43: return (void*)(QLine*)xptr;
        default: return xptr;
      }
    case 44:   //QLineF
      switch(to) {
        case 44: return (void*)(QLineF*)xptr;
        default: return xptr;
      }
    case 45:   //QMargins
      switch(to) {
        case 45: return (void*)(QMargins*)xptr;
        default: return xptr;
      }
    case 46:   //QMatrix
      switch(to) {
        case 46: return (void*)(QMatrix*)xptr;
        default: return xptr;
      }
    case 47:   //QMetaObject
      switch(to) {
        case 47: return (void*)(QMetaObject*)xptr;
        default: return xptr;
      }
    case 48:   //QMouseEvent
      switch(to) {
        case 48: return (void*)(QMouseEvent*)xptr;
        default: return xptr;
      }
    case 49:   //QMoveEvent
      switch(to) {
        case 49: return (void*)(QMoveEvent*)xptr;
        default: return xptr;
      }
    case 50:   //QObject
      switch(to) {
        case 50: return (void*)(QObject*)xptr;
        case 7: return (void*)(KNS3::UploadDialog*)(QObject*)xptr;
        case 5: return (void*)(KNS3::DownloadDialog*)(QObject*)xptr;
        case 4: return (void*)(KNS3::Button*)(QObject*)xptr;
        default: return xptr;
      }
    case 51:   //QPaintEngine
      switch(to) {
        case 51: return (void*)(QPaintEngine*)xptr;
        default: return xptr;
      }
    case 52:   //QPaintEvent
      switch(to) {
        case 52: return (void*)(QPaintEvent*)xptr;
        default: return xptr;
      }
    case 53:   //QPainterPath
      switch(to) {
        case 53: return (void*)(QPainterPath*)xptr;
        default: return xptr;
      }
    case 54:   //QPalette
      switch(to) {
        case 54: return (void*)(QPalette*)xptr;
        default: return xptr;
      }
    case 55:   //QPixmap
      switch(to) {
        case 55: return (void*)(QPixmap*)xptr;
        default: return xptr;
      }
    case 56:   //QPoint
      switch(to) {
        case 56: return (void*)(QPoint*)xptr;
        default: return xptr;
      }
    case 57:   //QPointF
      switch(to) {
        case 57: return (void*)(QPointF*)xptr;
        default: return xptr;
      }
    case 58:   //QPolygon
      switch(to) {
        case 58: return (void*)(QPolygon*)xptr;
        default: return xptr;
      }
    case 59:   //QPolygonF
      switch(to) {
        case 59: return (void*)(QPolygonF*)xptr;
        default: return xptr;
      }
    case 60:   //QPushButton
      switch(to) {
        case 10: return (void*)(QAbstractButton*)(QPushButton*)xptr;
        case 81: return (void*)(QWidget*)(QPushButton*)xptr;
        case 50: return (void*)(QObject*)(QPushButton*)xptr;
        case 60: return (void*)(QPushButton*)xptr;
        case 4: return (void*)(KNS3::Button*)(QPushButton*)xptr;
        default: return xptr;
      }
    case 61:   //QRect
      switch(to) {
        case 61: return (void*)(QRect*)xptr;
        default: return xptr;
      }
    case 62:   //QRectF
      switch(to) {
        case 62: return (void*)(QRectF*)xptr;
        default: return xptr;
      }
    case 63:   //QRegExp
      switch(to) {
        case 63: return (void*)(QRegExp*)xptr;
        default: return xptr;
      }
    case 64:   //QRegion
      switch(to) {
        case 64: return (void*)(QRegion*)xptr;
        default: return xptr;
      }
    case 65:   //QResizeEvent
      switch(to) {
        case 65: return (void*)(QResizeEvent*)xptr;
        default: return xptr;
      }
    case 66:   //QShowEvent
      switch(to) {
        case 66: return (void*)(QShowEvent*)xptr;
        default: return xptr;
      }
    case 67:   //QSize
      switch(to) {
        case 67: return (void*)(QSize*)xptr;
        default: return xptr;
      }
    case 68:   //QSizeF
      switch(to) {
        case 68: return (void*)(QSizeF*)xptr;
        default: return xptr;
      }
    case 69:   //QSizePolicy
      switch(to) {
        case 69: return (void*)(QSizePolicy*)xptr;
        default: return xptr;
      }
    case 70:   //QString::Null
      switch(to) {
        case 70: return (void*)(QString::Null*)xptr;
        default: return xptr;
      }
    case 71:   //QStringRef
      switch(to) {
        case 71: return (void*)(QStringRef*)xptr;
        default: return xptr;
      }
    case 72:   //QStyle
      switch(to) {
        case 72: return (void*)(QStyle*)xptr;
        default: return xptr;
      }
    case 73:   //QTabletEvent
      switch(to) {
        case 73: return (void*)(QTabletEvent*)xptr;
        default: return xptr;
      }
    case 74:   //QTime
      switch(to) {
        case 74: return (void*)(QTime*)xptr;
        default: return xptr;
      }
    case 75:   //QTimerEvent
      switch(to) {
        case 75: return (void*)(QTimerEvent*)xptr;
        default: return xptr;
      }
    case 76:   //QTransform
      switch(to) {
        case 76: return (void*)(QTransform*)xptr;
        default: return xptr;
      }
    case 77:   //QUrl
      switch(to) {
        case 77: return (void*)(QUrl*)xptr;
        default: return xptr;
      }
    case 78:   //QVariant
      switch(to) {
        case 78: return (void*)(QVariant*)xptr;
        default: return xptr;
      }
    case 79:   //QVariantComparisonHelper
      switch(to) {
        case 79: return (void*)(QVariantComparisonHelper*)xptr;
        default: return xptr;
      }
    case 80:   //QWheelEvent
      switch(to) {
        case 80: return (void*)(QWheelEvent*)xptr;
        default: return xptr;
      }
    case 81:   //QWidget
      switch(to) {
        case 50: return (void*)(QObject*)(QWidget*)xptr;
        case 81: return (void*)(QWidget*)xptr;
        case 7: return (void*)(KNS3::UploadDialog*)(QWidget*)xptr;
        case 5: return (void*)(KNS3::DownloadDialog*)(QWidget*)xptr;
        case 4: return (void*)(KNS3::Button*)(QWidget*)xptr;
        default: return xptr;
      }
    default: return xptr;
  }
}

// Group of Indexes (0 separated) used as super class lists.
// Classes with super classes have an index into this array.
static Smoke::Index inheritanceList[] = {
    0,	// 0: (no super class)
    8, 0,	// 1: KPushButton
    3, 0,	// 3: KDialog
};

// These are the xenum functions for manipulating enum pointers
void xenum_KNS3__Entry(Smoke::EnumOperation, Smoke::Index, void*&, long&);

// Those are the xcall functions defined in each x_*.cpp file, for dispatching method calls
void xcall_KNS3__Button(Smoke::Index, void*, Smoke::Stack);
void xcall_KNS3__DownloadDialog(Smoke::Index, void*, Smoke::Stack);
void xcall_KNS3__Entry(Smoke::Index, void*, Smoke::Stack);
void xcall_KNS3__UploadDialog(Smoke::Index, void*, Smoke::Stack);
void xcall_QGlobalSpace(Smoke::Index, void*, Smoke::Stack);

// List of all classes
// Name, external, index into inheritanceList, method dispatcher, enum dispatcher, class flags, size
static Smoke::Class classes[] = {
    { 0L, false, 0, 0, 0, 0, 0 },	// 0 (no class)
    { "KAction", true, 0, 0, 0, 0, 0 },	//1
    { "KActionCollection", true, 0, 0, 0, 0, 0 },	//2
    { "KDialog", true, 0, 0, 0, 0, 0 },	//3
    { "KNS3::Button", false, 1, xcall_KNS3__Button, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KNS3::Button) },	//4
    { "KNS3::DownloadDialog", false, 3, xcall_KNS3__DownloadDialog, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KNS3::DownloadDialog) },	//5
    { "KNS3::Entry", false, 0, xcall_KNS3__Entry, xenum_KNS3__Entry, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KNS3::Entry) },	//6
    { "KNS3::UploadDialog", false, 3, xcall_KNS3__UploadDialog, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KNS3::UploadDialog) },	//7
    { "KPushButton", true, 0, 0, 0, 0, 0 },	//8
    { "KUrl", true, 0, 0, 0, 0, 0 },	//9
    { "QAbstractButton", true, 0, 0, 0, 0, 0 },	//10
    { "QActionEvent", true, 0, 0, 0, 0, 0 },	//11
    { "QBool", true, 0, 0, 0, 0, 0 },	//12
    { "QBrush", true, 0, 0, 0, 0, 0 },	//13
    { "QByteArray", true, 0, 0, 0, 0, 0 },	//14
    { "QChar", true, 0, 0, 0, 0, 0 },	//15
    { "QChildEvent", true, 0, 0, 0, 0, 0 },	//16
    { "QCloseEvent", true, 0, 0, 0, 0, 0 },	//17
    { "QColor", true, 0, 0, 0, 0, 0 },	//18
    { "QContextMenuEvent", true, 0, 0, 0, 0, 0 },	//19
    { "QCursor", true, 0, 0, 0, 0, 0 },	//20
    { "QDataStream", true, 0, 0, 0, 0, 0 },	//21
    { "QDate", true, 0, 0, 0, 0, 0 },	//22
    { "QDateTime", true, 0, 0, 0, 0, 0 },	//23
    { "QDialog", true, 0, 0, 0, 0, 0 },	//24
    { "QDrag", true, 0, 0, 0, 0, 0 },	//25
    { "QDragEnterEvent", true, 0, 0, 0, 0, 0 },	//26
    { "QDragLeaveEvent", true, 0, 0, 0, 0, 0 },	//27
    { "QDragMoveEvent", true, 0, 0, 0, 0, 0 },	//28
    { "QDropEvent", true, 0, 0, 0, 0, 0 },	//29
    { "QEvent", true, 0, 0, 0, 0, 0 },	//30
    { "QFocusEvent", true, 0, 0, 0, 0, 0 },	//31
    { "QFont", true, 0, 0, 0, 0, 0 },	//32
    { "QGlobalSpace", false, 0, xcall_QGlobalSpace, 0, Smoke::cf_namespace, 0 },	//33
    { "QHashDummyValue", true, 0, 0, 0, 0, 0 },	//34
    { "QHideEvent", true, 0, 0, 0, 0, 0 },	//35
    { "QIcon", true, 0, 0, 0, 0, 0 },	//36
    { "QImage", true, 0, 0, 0, 0, 0 },	//37
    { "QIncompatibleFlag", true, 0, 0, 0, 0, 0 },	//38
    { "QInputMethodEvent", true, 0, 0, 0, 0, 0 },	//39
    { "QKeyEvent", true, 0, 0, 0, 0, 0 },	//40
    { "QKeySequence", true, 0, 0, 0, 0, 0 },	//41
    { "QLatin1String", true, 0, 0, 0, 0, 0 },	//42
    { "QLine", true, 0, 0, 0, 0, 0 },	//43
    { "QLineF", true, 0, 0, 0, 0, 0 },	//44
    { "QMargins", true, 0, 0, 0, 0, 0 },	//45
    { "QMatrix", true, 0, 0, 0, 0, 0 },	//46
    { "QMetaObject", true, 0, 0, 0, 0, 0 },	//47
    { "QMouseEvent", true, 0, 0, 0, 0, 0 },	//48
    { "QMoveEvent", true, 0, 0, 0, 0, 0 },	//49
    { "QObject", true, 0, 0, 0, 0, 0 },	//50
    { "QPaintEngine", true, 0, 0, 0, 0, 0 },	//51
    { "QPaintEvent", true, 0, 0, 0, 0, 0 },	//52
    { "QPainterPath", true, 0, 0, 0, 0, 0 },	//53
    { "QPalette", true, 0, 0, 0, 0, 0 },	//54
    { "QPixmap", true, 0, 0, 0, 0, 0 },	//55
    { "QPoint", true, 0, 0, 0, 0, 0 },	//56
    { "QPointF", true, 0, 0, 0, 0, 0 },	//57
    { "QPolygon", true, 0, 0, 0, 0, 0 },	//58
    { "QPolygonF", true, 0, 0, 0, 0, 0 },	//59
    { "QPushButton", true, 0, 0, 0, 0, 0 },	//60
    { "QRect", true, 0, 0, 0, 0, 0 },	//61
    { "QRectF", true, 0, 0, 0, 0, 0 },	//62
    { "QRegExp", true, 0, 0, 0, 0, 0 },	//63
    { "QRegion", true, 0, 0, 0, 0, 0 },	//64
    { "QResizeEvent", true, 0, 0, 0, 0, 0 },	//65
    { "QShowEvent", true, 0, 0, 0, 0, 0 },	//66
    { "QSize", true, 0, 0, 0, 0, 0 },	//67
    { "QSizeF", true, 0, 0, 0, 0, 0 },	//68
    { "QSizePolicy", true, 0, 0, 0, 0, 0 },	//69
    { "QString::Null", true, 0, 0, 0, 0, 0 },	//70
    { "QStringRef", true, 0, 0, 0, 0, 0 },	//71
    { "QStyle", true, 0, 0, 0, 0, 0 },	//72
    { "QTabletEvent", true, 0, 0, 0, 0, 0 },	//73
    { "QTime", true, 0, 0, 0, 0, 0 },	//74
    { "QTimerEvent", true, 0, 0, 0, 0, 0 },	//75
    { "QTransform", true, 0, 0, 0, 0, 0 },	//76
    { "QUrl", true, 0, 0, 0, 0, 0 },	//77
    { "QVariant", true, 0, 0, 0, 0, 0 },	//78
    { "QVariantComparisonHelper", true, 0, 0, 0, 0, 0 },	//79
    { "QWheelEvent", true, 0, 0, 0, 0, 0 },	//80
    { "QWidget", true, 0, 0, 0, 0, 0 },	//81
};

// List of all types needed by the methods (arguments and return values)
// Name, class ID if arg is a class, and TypeId
static Smoke::Type types[] = {
    { 0, 0, 0 },	//0 (no type)
    { "KAction*", 1, Smoke::t_class|Smoke::tf_ptr },	//1
    { "KActionCollection*", 2, Smoke::t_class|Smoke::tf_ptr },	//2
    { "KConfigBase::WriteConfigFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//3
    { "KDialog::ButtonCode", 3, Smoke::t_enum|Smoke::tf_stack },	//4
    { "KDialog::CaptionFlag", 3, Smoke::t_enum|Smoke::tf_stack },	//5
    { "KGlobal::CopyCatalogs", 0, Smoke::t_enum|Smoke::tf_stack },	//6
    { "KIconLoader::Group", 0, Smoke::t_enum|Smoke::tf_stack },	//7
    { "KIconLoader::Group&", 0, Smoke::t_enum|Smoke::tf_ref },	//8
    { "KNS3::Button*", 4, Smoke::t_class|Smoke::tf_ptr },	//9
    { "KNS3::DownloadDialog*", 5, Smoke::t_class|Smoke::tf_ptr },	//10
    { "KNS3::Entry", 6, Smoke::t_class|Smoke::tf_stack },	//11
    { "KNS3::Entry&", 6, Smoke::t_class|Smoke::tf_ref },	//12
    { "KNS3::Entry*", 6, Smoke::t_class|Smoke::tf_ptr },	//13
    { "KNS3::Entry::List", 0, Smoke::t_voidp|Smoke::tf_stack },	//14
    { "KNS3::Entry::Status", 6, Smoke::t_enum|Smoke::tf_stack },	//15
    { "KNS3::UploadDialog*", 7, Smoke::t_class|Smoke::tf_ptr },	//16
    { "KStandardGuiItem::BidiMode", 0, Smoke::t_enum|Smoke::tf_stack },	//17
    { "KStandardGuiItem::StandardItem", 0, Smoke::t_enum|Smoke::tf_stack },	//18
    { "KUrl::CleanPathOption", 9, Smoke::t_enum|Smoke::tf_stack },	//19
    { "KUrl::DirectoryOption", 9, Smoke::t_enum|Smoke::tf_stack },	//20
    { "KUrl::EncodedPathAndQueryOption", 9, Smoke::t_enum|Smoke::tf_stack },	//21
    { "KUrl::EqualsOption", 9, Smoke::t_enum|Smoke::tf_stack },	//22
    { "KUrl::QueryItemsOption", 9, Smoke::t_enum|Smoke::tf_stack },	//23
    { "QActionEvent*", 11, Smoke::t_class|Smoke::tf_ptr },	//24
    { "QBool", 12, Smoke::t_class|Smoke::tf_stack },	//25
    { "QBrush&", 13, Smoke::t_class|Smoke::tf_ref },	//26
    { "QByteArray&", 14, Smoke::t_class|Smoke::tf_ref },	//27
    { "QChar", 15, Smoke::t_class|Smoke::tf_stack },	//28
    { "QChar&", 15, Smoke::t_class|Smoke::tf_ref },	//29
    { "QChildEvent*", 16, Smoke::t_class|Smoke::tf_ptr },	//30
    { "QCloseEvent*", 17, Smoke::t_class|Smoke::tf_ptr },	//31
    { "QColor&", 18, Smoke::t_class|Smoke::tf_ref },	//32
    { "QContextMenuEvent*", 19, Smoke::t_class|Smoke::tf_ptr },	//33
    { "QCursor&", 20, Smoke::t_class|Smoke::tf_ref },	//34
    { "QDataStream&", 21, Smoke::t_class|Smoke::tf_ref },	//35
    { "QDate&", 22, Smoke::t_class|Smoke::tf_ref },	//36
    { "QDateTime&", 23, Smoke::t_class|Smoke::tf_ref },	//37
    { "QDrag*", 25, Smoke::t_class|Smoke::tf_ptr },	//38
    { "QDragEnterEvent*", 26, Smoke::t_class|Smoke::tf_ptr },	//39
    { "QDragLeaveEvent*", 27, Smoke::t_class|Smoke::tf_ptr },	//40
    { "QDragMoveEvent*", 28, Smoke::t_class|Smoke::tf_ptr },	//41
    { "QDropEvent*", 29, Smoke::t_class|Smoke::tf_ptr },	//42
    { "QEvent*", 30, Smoke::t_class|Smoke::tf_ptr },	//43
    { "QFlags<KConfigBase::WriteConfigFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//44
    { "QFlags<KDialog::ButtonCode>", 0, Smoke::t_uint|Smoke::tf_stack },	//45
    { "QFlags<KDialog::CaptionFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//46
    { "QFlags<KUrl::CleanPathOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//47
    { "QFlags<KUrl::DirectoryOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//48
    { "QFlags<KUrl::EncodedPathAndQueryOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//49
    { "QFlags<KUrl::EqualsOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//50
    { "QFlags<KUrl::QueryItemsOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//51
    { "QFlags<QIODevice::OpenModeFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//52
    { "QFlags<QSizePolicy::ControlType>", 0, Smoke::t_uint|Smoke::tf_stack },	//53
    { "QFlags<QString::SectionFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//54
    { "QFlags<QUrl::FormattingOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//55
    { "QFlags<QWidget::RenderFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//56
    { "QFlags<Qt::AlignmentFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//57
    { "QFlags<Qt::DockWidgetArea>", 0, Smoke::t_uint|Smoke::tf_stack },	//58
    { "QFlags<Qt::DropAction>", 0, Smoke::t_uint|Smoke::tf_stack },	//59
    { "QFlags<Qt::GestureFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//60
    { "QFlags<Qt::ImageConversionFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//61
    { "QFlags<Qt::InputMethodHint>", 0, Smoke::t_uint|Smoke::tf_stack },	//62
    { "QFlags<Qt::ItemFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//63
    { "QFlags<Qt::KeyboardModifier>", 0, Smoke::t_uint|Smoke::tf_stack },	//64
    { "QFlags<Qt::MatchFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//65
    { "QFlags<Qt::MouseButton>", 0, Smoke::t_uint|Smoke::tf_stack },	//66
    { "QFlags<Qt::Orientation>", 0, Smoke::t_uint|Smoke::tf_stack },	//67
    { "QFlags<Qt::TextInteractionFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//68
    { "QFlags<Qt::ToolBarArea>", 0, Smoke::t_uint|Smoke::tf_stack },	//69
    { "QFlags<Qt::TouchPointState>", 0, Smoke::t_uint|Smoke::tf_stack },	//70
    { "QFlags<Qt::WindowState>", 0, Smoke::t_uint|Smoke::tf_stack },	//71
    { "QFlags<Qt::WindowType>", 0, Smoke::t_uint|Smoke::tf_stack },	//72
    { "QFocusEvent*", 31, Smoke::t_class|Smoke::tf_ptr },	//73
    { "QFont&", 32, Smoke::t_class|Smoke::tf_ref },	//74
    { "QHideEvent*", 35, Smoke::t_class|Smoke::tf_ptr },	//75
    { "QIODevice::OpenModeFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//76
    { "QIcon&", 36, Smoke::t_class|Smoke::tf_ref },	//77
    { "QImage&", 37, Smoke::t_class|Smoke::tf_ref },	//78
    { "QIncompatibleFlag", 38, Smoke::t_class|Smoke::tf_stack },	//79
    { "QInputMethodEvent*", 39, Smoke::t_class|Smoke::tf_ptr },	//80
    { "QKeyEvent*", 40, Smoke::t_class|Smoke::tf_ptr },	//81
    { "QKeySequence&", 41, Smoke::t_class|Smoke::tf_ref },	//82
    { "QLine", 43, Smoke::t_class|Smoke::tf_stack },	//83
    { "QLine&", 43, Smoke::t_class|Smoke::tf_ref },	//84
    { "QLineF", 44, Smoke::t_class|Smoke::tf_stack },	//85
    { "QLineF&", 44, Smoke::t_class|Smoke::tf_ref },	//86
    { "QList<KNS3::Entry>", 0, Smoke::t_voidp|Smoke::tf_stack },	//87
    { "QMatrix&", 46, Smoke::t_class|Smoke::tf_ref },	//88
    { "QMetaObject::Call", 47, Smoke::t_enum|Smoke::tf_stack },	//89
    { "QMouseEvent*", 48, Smoke::t_class|Smoke::tf_ptr },	//90
    { "QMoveEvent*", 49, Smoke::t_class|Smoke::tf_ptr },	//91
    { "QObject*", 50, Smoke::t_class|Smoke::tf_ptr },	//92
    { "QPaintDevice::PaintDeviceMetric", 0, Smoke::t_enum|Smoke::tf_stack },	//93
    { "QPaintEngine*", 51, Smoke::t_class|Smoke::tf_ptr },	//94
    { "QPaintEvent*", 52, Smoke::t_class|Smoke::tf_ptr },	//95
    { "QPainterPath", 53, Smoke::t_class|Smoke::tf_stack },	//96
    { "QPainterPath&", 53, Smoke::t_class|Smoke::tf_ref },	//97
    { "QPalette&", 54, Smoke::t_class|Smoke::tf_ref },	//98
    { "QPixmap&", 55, Smoke::t_class|Smoke::tf_ref },	//99
    { "QPoint", 56, Smoke::t_class|Smoke::tf_stack },	//100
    { "QPoint&", 56, Smoke::t_class|Smoke::tf_ref },	//101
    { "QPointF", 57, Smoke::t_class|Smoke::tf_stack },	//102
    { "QPointF&", 57, Smoke::t_class|Smoke::tf_ref },	//103
    { "QPolygon", 58, Smoke::t_class|Smoke::tf_stack },	//104
    { "QPolygon&", 58, Smoke::t_class|Smoke::tf_ref },	//105
    { "QPolygonF", 59, Smoke::t_class|Smoke::tf_stack },	//106
    { "QPolygonF&", 59, Smoke::t_class|Smoke::tf_ref },	//107
    { "QRect&", 61, Smoke::t_class|Smoke::tf_ref },	//108
    { "QRectF&", 62, Smoke::t_class|Smoke::tf_ref },	//109
    { "QRegExp&", 63, Smoke::t_class|Smoke::tf_ref },	//110
    { "QRegion", 64, Smoke::t_class|Smoke::tf_stack },	//111
    { "QRegion&", 64, Smoke::t_class|Smoke::tf_ref },	//112
    { "QResizeEvent*", 65, Smoke::t_class|Smoke::tf_ptr },	//113
    { "QShowEvent*", 66, Smoke::t_class|Smoke::tf_ptr },	//114
    { "QSize", 67, Smoke::t_class|Smoke::tf_stack },	//115
    { "QSize&", 67, Smoke::t_class|Smoke::tf_ref },	//116
    { "QSizeF&", 68, Smoke::t_class|Smoke::tf_ref },	//117
    { "QSizePolicy&", 69, Smoke::t_class|Smoke::tf_ref },	//118
    { "QSizePolicy::ControlType", 69, Smoke::t_enum|Smoke::tf_stack },	//119
    { "QString", 0, Smoke::t_voidp|Smoke::tf_stack },	//120
    { "QString&", 0, Smoke::t_voidp|Smoke::tf_ref },	//121
    { "QString::Null", 70, Smoke::t_class|Smoke::tf_stack },	//122
    { "QString::SectionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//123
    { "QStringList", 0, Smoke::t_voidp|Smoke::tf_stack },	//124
    { "QStringList&", 0, Smoke::t_voidp|Smoke::tf_ref },	//125
    { "QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//126
    { "QStyle&", 72, Smoke::t_class|Smoke::tf_ref },	//127
    { "QTabletEvent*", 73, Smoke::t_class|Smoke::tf_ptr },	//128
    { "QTime&", 74, Smoke::t_class|Smoke::tf_ref },	//129
    { "QTimerEvent*", 75, Smoke::t_class|Smoke::tf_ptr },	//130
    { "QTransform", 76, Smoke::t_class|Smoke::tf_stack },	//131
    { "QTransform&", 76, Smoke::t_class|Smoke::tf_ref },	//132
    { "QUrl&", 77, Smoke::t_class|Smoke::tf_ref },	//133
    { "QUrl::FormattingOption", 77, Smoke::t_enum|Smoke::tf_stack },	//134
    { "QVariant", 78, Smoke::t_class|Smoke::tf_stack },	//135
    { "QVariant&", 78, Smoke::t_class|Smoke::tf_ref },	//136
    { "QVariant::Type&", 78, Smoke::t_enum|Smoke::tf_ref },	//137
    { "QWheelEvent*", 80, Smoke::t_class|Smoke::tf_ptr },	//138
    { "QWidget*", 81, Smoke::t_class|Smoke::tf_ptr },	//139
    { "QWidget::RenderFlag", 81, Smoke::t_enum|Smoke::tf_stack },	//140
    { "Qt::AlignmentFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//141
    { "Qt::AnchorAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//142
    { "Qt::AnchorPoint", 0, Smoke::t_enum|Smoke::tf_stack },	//143
    { "Qt::ApplicationAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//144
    { "Qt::ArrowType", 0, Smoke::t_enum|Smoke::tf_stack },	//145
    { "Qt::AspectRatioMode", 0, Smoke::t_enum|Smoke::tf_stack },	//146
    { "Qt::Axis", 0, Smoke::t_enum|Smoke::tf_stack },	//147
    { "Qt::BGMode", 0, Smoke::t_enum|Smoke::tf_stack },	//148
    { "Qt::BrushStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//149
    { "Qt::CaseSensitivity", 0, Smoke::t_enum|Smoke::tf_stack },	//150
    { "Qt::CheckState", 0, Smoke::t_enum|Smoke::tf_stack },	//151
    { "Qt::ClipOperation", 0, Smoke::t_enum|Smoke::tf_stack },	//152
    { "Qt::ConnectionType", 0, Smoke::t_enum|Smoke::tf_stack },	//153
    { "Qt::ContextMenuPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//154
    { "Qt::CoordinateSystem", 0, Smoke::t_enum|Smoke::tf_stack },	//155
    { "Qt::Corner", 0, Smoke::t_enum|Smoke::tf_stack },	//156
    { "Qt::CursorMoveStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//157
    { "Qt::CursorShape", 0, Smoke::t_enum|Smoke::tf_stack },	//158
    { "Qt::DateFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//159
    { "Qt::DayOfWeek", 0, Smoke::t_enum|Smoke::tf_stack },	//160
    { "Qt::DockWidgetArea", 0, Smoke::t_enum|Smoke::tf_stack },	//161
    { "Qt::DockWidgetAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//162
    { "Qt::DropAction", 0, Smoke::t_enum|Smoke::tf_stack },	//163
    { "Qt::EventPriority", 0, Smoke::t_enum|Smoke::tf_stack },	//164
    { "Qt::FillRule", 0, Smoke::t_enum|Smoke::tf_stack },	//165
    { "Qt::FocusPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//166
    { "Qt::FocusReason", 0, Smoke::t_enum|Smoke::tf_stack },	//167
    { "Qt::GestureFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//168
    { "Qt::GestureState", 0, Smoke::t_enum|Smoke::tf_stack },	//169
    { "Qt::GestureType", 0, Smoke::t_enum|Smoke::tf_stack },	//170
    { "Qt::GlobalColor", 0, Smoke::t_enum|Smoke::tf_stack },	//171
    { "Qt::ImageConversionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//172
    { "Qt::Initialization", 0, Smoke::t_enum|Smoke::tf_stack },	//173
    { "Qt::InputMethodHint", 0, Smoke::t_enum|Smoke::tf_stack },	//174
    { "Qt::InputMethodQuery", 0, Smoke::t_enum|Smoke::tf_stack },	//175
    { "Qt::ItemDataRole", 0, Smoke::t_enum|Smoke::tf_stack },	//176
    { "Qt::ItemFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//177
    { "Qt::ItemSelectionMode", 0, Smoke::t_enum|Smoke::tf_stack },	//178
    { "Qt::Key", 0, Smoke::t_enum|Smoke::tf_stack },	//179
    { "Qt::KeyboardModifier", 0, Smoke::t_enum|Smoke::tf_stack },	//180
    { "Qt::LayoutDirection", 0, Smoke::t_enum|Smoke::tf_stack },	//181
    { "Qt::MaskMode", 0, Smoke::t_enum|Smoke::tf_stack },	//182
    { "Qt::MatchFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//183
    { "Qt::Modifier", 0, Smoke::t_enum|Smoke::tf_stack },	//184
    { "Qt::MouseButton", 0, Smoke::t_enum|Smoke::tf_stack },	//185
    { "Qt::NavigationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//186
    { "Qt::Orientation", 0, Smoke::t_enum|Smoke::tf_stack },	//187
    { "Qt::PenCapStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//188
    { "Qt::PenJoinStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//189
    { "Qt::PenStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//190
    { "Qt::ScrollBarPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//191
    { "Qt::ShortcutContext", 0, Smoke::t_enum|Smoke::tf_stack },	//192
    { "Qt::SizeHint", 0, Smoke::t_enum|Smoke::tf_stack },	//193
    { "Qt::SizeMode", 0, Smoke::t_enum|Smoke::tf_stack },	//194
    { "Qt::SortOrder", 0, Smoke::t_enum|Smoke::tf_stack },	//195
    { "Qt::TextElideMode", 0, Smoke::t_enum|Smoke::tf_stack },	//196
    { "Qt::TextFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//197
    { "Qt::TextFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//198
    { "Qt::TextInteractionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//199
    { "Qt::TileRule", 0, Smoke::t_enum|Smoke::tf_stack },	//200
    { "Qt::TimeSpec", 0, Smoke::t_enum|Smoke::tf_stack },	//201
    { "Qt::ToolBarArea", 0, Smoke::t_enum|Smoke::tf_stack },	//202
    { "Qt::ToolBarAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//203
    { "Qt::ToolButtonStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//204
    { "Qt::TouchPointState", 0, Smoke::t_enum|Smoke::tf_stack },	//205
    { "Qt::TransformationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//206
    { "Qt::UIEffect", 0, Smoke::t_enum|Smoke::tf_stack },	//207
    { "Qt::WidgetAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//208
    { "Qt::WindowFrameSection", 0, Smoke::t_enum|Smoke::tf_stack },	//209
    { "Qt::WindowModality", 0, Smoke::t_enum|Smoke::tf_stack },	//210
    { "Qt::WindowState", 0, Smoke::t_enum|Smoke::tf_stack },	//211
    { "Qt::WindowType", 0, Smoke::t_enum|Smoke::tf_stack },	//212
    { "_XEvent*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//213
    { "bool", 0, Smoke::t_bool|Smoke::tf_stack },	//214
    { "char", 0, Smoke::t_char|Smoke::tf_stack },	//215
    { "const KNS3::Entry&", 6, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//216
    { "const KNS3::Entry::List&", 0, Smoke::t_voidp|Smoke::tf_stack },	//217
    { "const KUrl&", 9, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//218
    { "const QBrush&", 13, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//219
    { "const QByteArray", 14, Smoke::t_class|Smoke::tf_stack|Smoke::tf_const },	//220
    { "const QByteArray&", 14, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//221
    { "const QChar&", 15, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//222
    { "const QColor&", 18, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//223
    { "const QCursor&", 20, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//224
    { "const QDate&", 22, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//225
    { "const QDateTime&", 23, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//226
    { "const QFont&", 32, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//227
    { "const QHashDummyValue&", 34, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//228
    { "const QIcon&", 36, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//229
    { "const QImage&", 37, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//230
    { "const QKeySequence&", 41, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//231
    { "const QLatin1String&", 42, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//232
    { "const QLine&", 43, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//233
    { "const QLineF&", 44, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//234
    { "const QMargins&", 45, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//235
    { "const QMatrix&", 46, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//236
    { "const QMetaObject&", 47, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//237
    { "const QMetaObject*", 47, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//238
    { "const QObject*", 50, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//239
    { "const QPainterPath&", 53, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//240
    { "const QPalette&", 54, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//241
    { "const QPixmap&", 55, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//242
    { "const QPoint", 56, Smoke::t_class|Smoke::tf_stack|Smoke::tf_const },	//243
    { "const QPoint&", 56, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//244
    { "const QPointF", 57, Smoke::t_class|Smoke::tf_stack|Smoke::tf_const },	//245
    { "const QPointF&", 57, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//246
    { "const QPolygon&", 58, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//247
    { "const QPolygonF&", 59, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//248
    { "const QRect&", 61, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//249
    { "const QRectF&", 62, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//250
    { "const QRegExp&", 63, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//251
    { "const QRegion&", 64, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//252
    { "const QSize", 67, Smoke::t_class|Smoke::tf_stack|Smoke::tf_const },	//253
    { "const QSize&", 67, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//254
    { "const QSizeF", 68, Smoke::t_class|Smoke::tf_stack|Smoke::tf_const },	//255
    { "const QSizeF&", 68, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//256
    { "const QSizePolicy&", 69, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//257
    { "const QString", 0, Smoke::t_voidp|Smoke::tf_stack|Smoke::tf_const },	//258
    { "const QString&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//259
    { "const QStringList&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//260
    { "const QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//261
    { "const QStringRef&", 71, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//262
    { "const QTime&", 74, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//263
    { "const QTransform&", 76, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//264
    { "const QUrl&", 77, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//265
    { "const QVariant&", 78, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//266
    { "const QVariant::Type", 78, Smoke::t_enum|Smoke::tf_stack|Smoke::tf_const },	//267
    { "const QVariantComparisonHelper&", 79, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//268
    { "const char*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//269
    { "const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//270
    { "double", 0, Smoke::t_double|Smoke::tf_stack },	//271
    { "float", 0, Smoke::t_float|Smoke::tf_stack },	//272
    { "int", 0, Smoke::t_int|Smoke::tf_stack },	//273
    { "unsigned int", 0, Smoke::t_uint|Smoke::tf_stack },	//274
    { "void*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//275
    { "void**", 0, Smoke::t_voidp|Smoke::tf_ptr },	//276
    { "volatile const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//277
};

static Smoke::Index argumentList[] = {
    0,	//0  (void)
    259, 0,	//1  const QString&
    259, 214, 0,	//3  const QString&, bool
    75, 0,	//6  QHideEvent*
    31, 0,	//8  QCloseEvent*
    81, 0,	//10  QKeyEvent*
    273, 0,	//12  int
    269, 0,	//14  const char*
    269, 269, 0,	//16  const char*, const char*
    269, 269, 273, 0,	//19  const char*, const char*, int
    89, 273, 276, 0,	//23  QMetaObject::Call, int, void**
    259, 259, 139, 0,	//27  const QString&, const QString&, QWidget*
    139, 0,	//31  QWidget*
    217, 0,	//33  const KNS3::Entry::List&
    259, 139, 0,	//35  const QString&, QWidget*
    216, 0,	//38  const KNS3::Entry&
    218, 0,	//40  const KUrl&
    274, 218, 0,	//42  unsigned int, const KUrl&
    214, 0,	//45  bool
    271, 0,	//47  double
    90, 0,	//49  QMouseEvent*
    95, 0,	//51  QPaintEvent*
    244, 0,	//53  const QPoint&
    43, 0,	//55  QEvent*
    130, 0,	//57  QTimerEvent*
    114, 0,	//59  QShowEvent*
    113, 0,	//61  QResizeEvent*
    33, 0,	//63  QContextMenuEvent*
    92, 43, 0,	//65  QObject*, QEvent*
    161, 273, 0,	//68  Qt::DockWidgetArea, int
    244, 271, 0,	//71  const QPoint&, double
    271, 246, 0,	//74  double, const QPointF&
    185, 66, 0,	//77  Qt::MouseButton, QFlags<Qt::MouseButton>
    235, 235, 0,	//80  const QMargins&, const QMargins&
    271, 256, 0,	//83  double, const QSizeF&
    35, 78, 0,	//86  QDataStream&, QImage&
    35, 257, 0,	//89  QDataStream&, const QSizePolicy&
    174, 273, 0,	//92  Qt::InputMethodHint, int
    249, 249, 0,	//95  const QRect&, const QRect&
    254, 254, 0,	//98  const QSize&, const QSize&
    35, 264, 0,	//101  QDataStream&, const QTransform&
    246, 236, 0,	//104  const QPointF&, const QMatrix&
    233, 264, 0,	//107  const QLine&, const QTransform&
    211, 71, 0,	//110  Qt::WindowState, QFlags<Qt::WindowState>
    256, 271, 0,	//113  const QSizeF&, double
    35, 233, 0,	//116  QDataStream&, const QLine&
    269, 232, 0,	//119  const char*, const QLatin1String&
    256, 256, 0,	//122  const QSizeF&, const QSizeF&
    221, 221, 0,	//125  const QByteArray&, const QByteArray&
    232, 262, 0,	//128  const QLatin1String&, const QStringRef&
    185, 185, 0,	//131  Qt::MouseButton, Qt::MouseButton
    19, 47, 0,	//134  KUrl::CleanPathOption, QFlags<KUrl::CleanPathOption>
    19, 19, 0,	//137  KUrl::CleanPathOption, KUrl::CleanPathOption
    266, 268, 0,	//140  const QVariant&, const QVariantComparisonHelper&
    25, 25, 0,	//143  QBool, QBool
    3, 273, 0,	//146  KConfigBase::WriteConfigFlag, int
    141, 57, 0,	//149  Qt::AlignmentFlag, QFlags<Qt::AlignmentFlag>
    122, 122, 0,	//152  QString::Null, QString::Null
    35, 250, 0,	//155  QDataStream&, const QRectF&
    28, 259, 0,	//158  QChar, const QString&
    4, 4, 0,	//161  KDialog::ButtonCode, KDialog::ButtonCode
    76, 52, 0,	//164  QIODevice::OpenModeFlag, QFlags<QIODevice::OpenModeFlag>
    35, 241, 0,	//167  QDataStream&, const QPalette&
    8, 0,	//170  KIconLoader::Group&
    35, 221, 0,	//172  QDataStream&, const QByteArray&
    248, 264, 0,	//175  const QPolygonF&, const QTransform&
    202, 202, 0,	//178  Qt::ToolBarArea, Qt::ToolBarArea
    23, 273, 0,	//181  KUrl::QueryItemsOption, int
    140, 273, 0,	//184  QWidget::RenderFlag, int
    163, 273, 0,	//187  Qt::DropAction, int
    35, 260, 0,	//190  QDataStream&, const QStringList&
    21, 21, 0,	//193  KUrl::EncodedPathAndQueryOption, KUrl::EncodedPathAndQueryOption
    141, 141, 0,	//196  Qt::AlignmentFlag, Qt::AlignmentFlag
    35, 32, 0,	//199  QDataStream&, QColor&
    35, 251, 0,	//202  QDataStream&, const QRegExp&
    134, 273, 0,	//205  QUrl::FormattingOption, int
    221, 269, 0,	//208  const QByteArray&, const char*
    20, 20, 0,	//211  KUrl::DirectoryOption, KUrl::DirectoryOption
    161, 58, 0,	//214  Qt::DockWidgetArea, QFlags<Qt::DockWidgetArea>
    5, 5, 0,	//217  KDialog::CaptionFlag, KDialog::CaptionFlag
    233, 236, 0,	//220  const QLine&, const QMatrix&
    20, 48, 0,	//223  KUrl::DirectoryOption, QFlags<KUrl::DirectoryOption>
    234, 236, 0,	//226  const QLineF&, const QMatrix&
    187, 187, 0,	//229  Qt::Orientation, Qt::Orientation
    240, 236, 0,	//232  const QPainterPath&, const QMatrix&
    202, 273, 0,	//235  Qt::ToolBarArea, int
    35, 103, 0,	//238  QDataStream&, QPointF&
    35, 231, 0,	//241  QDataStream&, const QKeySequence&
    183, 273, 0,	//244  Qt::MatchFlag, int
    259, 269, 0,	//247  const QString&, const char*
    35, 224, 0,	//250  QDataStream&, const QCursor&
    168, 168, 0,	//253  Qt::GestureFlag, Qt::GestureFlag
    35, 36, 0,	//256  QDataStream&, QDate&
    76, 76, 0,	//259  QIODevice::OpenModeFlag, QIODevice::OpenModeFlag
    215, 221, 0,	//262  char, const QByteArray&
    269, 259, 0,	//265  const char*, const QString&
    269, 221, 0,	//268  const char*, const QByteArray&
    35, 27, 0,	//271  QDataStream&, QByteArray&
    35, 136, 0,	//274  QDataStream&, QVariant&
    4, 273, 0,	//277  KDialog::ButtonCode, int
    35, 110, 0,	//280  QDataStream&, QRegExp&
    246, 246, 0,	//283  const QPointF&, const QPointF&
    264, 271, 0,	//286  const QTransform&, double
    262, 262, 0,	//289  const QStringRef&, const QStringRef&
    28, 28, 0,	//292  QChar, QChar
    240, 264, 0,	//295  const QPainterPath&, const QTransform&
    35, 219, 0,	//298  QDataStream&, const QBrush&
    4, 45, 0,	//301  KDialog::ButtonCode, QFlags<KDialog::ButtonCode>
    35, 112, 0,	//304  QDataStream&, QRegion&
    246, 271, 0,	//307  const QPointF&, double
    21, 273, 0,	//310  KUrl::EncodedPathAndQueryOption, int
    35, 225, 0,	//313  QDataStream&, const QDate&
    183, 65, 0,	//316  Qt::MatchFlag, QFlags<Qt::MatchFlag>
    168, 273, 0,	//319  Qt::GestureFlag, int
    119, 119, 0,	//322  QSizePolicy::ControlType, QSizePolicy::ControlType
    35, 34, 0,	//325  QDataStream&, QCursor&
    180, 64, 0,	//328  Qt::KeyboardModifier, QFlags<Qt::KeyboardModifier>
    183, 183, 0,	//331  Qt::MatchFlag, Qt::MatchFlag
    35, 132, 0,	//334  QDataStream&, QTransform&
    247, 236, 0,	//337  const QPolygon&, const QMatrix&
    259, 122, 0,	//340  const QString&, QString::Null
    35, 117, 0,	//343  QDataStream&, QSizeF&
    246, 0,	//346  const QPointF&
    177, 177, 0,	//348  Qt::ItemFlag, Qt::ItemFlag
    35, 242, 0,	//351  QDataStream&, const QPixmap&
    221, 259, 0,	//354  const QByteArray&, const QString&
    212, 72, 0,	//357  Qt::WindowType, QFlags<Qt::WindowType>
    246, 264, 0,	//360  const QPointF&, const QTransform&
    177, 63, 0,	//363  Qt::ItemFlag, QFlags<Qt::ItemFlag>
    205, 70, 0,	//366  Qt::TouchPointState, QFlags<Qt::TouchPointState>
    259, 215, 0,	//369  const QString&, char
    35, 265, 0,	//372  QDataStream&, const QUrl&
    119, 53, 0,	//375  QSizePolicy::ControlType, QFlags<QSizePolicy::ControlType>
    35, 266, 0,	//378  QDataStream&, const QVariant&
    35, 84, 0,	//381  QDataStream&, QLine&
    180, 180, 0,	//384  Qt::KeyboardModifier, Qt::KeyboardModifier
    141, 273, 0,	//387  Qt::AlignmentFlag, int
    244, 236, 0,	//390  const QPoint&, const QMatrix&
    180, 273, 0,	//393  Qt::KeyboardModifier, int
    177, 273, 0,	//396  Qt::ItemFlag, int
    172, 61, 0,	//399  Qt::ImageConversionFlag, QFlags<Qt::ImageConversionFlag>
    244, 244, 0,	//402  const QPoint&, const QPoint&
    123, 273, 0,	//405  QString::SectionFlag, int
    212, 273, 0,	//408  Qt::WindowType, int
    140, 140, 0,	//411  QWidget::RenderFlag, QWidget::RenderFlag
    262, 259, 0,	//414  const QStringRef&, const QString&
    232, 232, 0,	//417  const QLatin1String&, const QLatin1String&
    228, 228, 0,	//420  const QHashDummyValue&, const QHashDummyValue&
    22, 22, 0,	//423  KUrl::EqualsOption, KUrl::EqualsOption
    134, 134, 0,	//426  QUrl::FormattingOption, QUrl::FormattingOption
    35, 77, 0,	//429  QDataStream&, QIcon&
    35, 247, 0,	//432  QDataStream&, const QPolygon&
    205, 273, 0,	//435  Qt::TouchPointState, int
    5, 46, 0,	//438  KDialog::CaptionFlag, QFlags<KDialog::CaptionFlag>
    140, 56, 0,	//441  QWidget::RenderFlag, QFlags<QWidget::RenderFlag>
    262, 269, 0,	//444  const QStringRef&, const char*
    19, 273, 0,	//447  KUrl::CleanPathOption, int
    23, 23, 0,	//450  KUrl::QueryItemsOption, KUrl::QueryItemsOption
    3, 3, 0,	//453  KConfigBase::WriteConfigFlag, KConfigBase::WriteConfigFlag
    35, 234, 0,	//456  QDataStream&, const QLineF&
    35, 26, 0,	//459  QDataStream&, QBrush&
    35, 246, 0,	//462  QDataStream&, const QPointF&
    244, 272, 0,	//465  const QPoint&, float
    259, 259, 0,	//468  const QString&, const QString&
    259, 262, 0,	//471  const QString&, const QStringRef&
    22, 273, 0,	//474  KUrl::EqualsOption, int
    5, 273, 0,	//477  KDialog::CaptionFlag, int
    119, 273, 0,	//480  QSizePolicy::ControlType, int
    35, 118, 0,	//483  QDataStream&, QSizePolicy&
    269, 262, 0,	//486  const char*, const QStringRef&
    35, 88, 0,	//489  QDataStream&, QMatrix&
    185, 273, 0,	//492  Qt::MouseButton, int
    35, 116, 0,	//495  QDataStream&, QSize&
    174, 174, 0,	//498  Qt::InputMethodHint, Qt::InputMethodHint
    35, 137, 0,	//501  QDataStream&, QVariant::Type&
    199, 68, 0,	//504  Qt::TextInteractionFlag, QFlags<Qt::TextInteractionFlag>
    234, 264, 0,	//507  const QLineF&, const QTransform&
    262, 232, 0,	//510  const QStringRef&, const QLatin1String&
    35, 248, 0,	//513  QDataStream&, const QPolygonF&
    35, 256, 0,	//516  QDataStream&, const QSizeF&
    202, 69, 0,	//519  Qt::ToolBarArea, QFlags<Qt::ToolBarArea>
    35, 227, 0,	//522  QDataStream&, const QFont&
    22, 50, 0,	//525  KUrl::EqualsOption, QFlags<KUrl::EqualsOption>
    35, 236, 0,	//528  QDataStream&, const QMatrix&
    215, 259, 0,	//531  char, const QString&
    211, 211, 0,	//534  Qt::WindowState, Qt::WindowState
    134, 55, 0,	//537  QUrl::FormattingOption, QFlags<QUrl::FormattingOption>
    35, 107, 0,	//540  QDataStream&, QPolygonF&
    35, 98, 0,	//543  QDataStream&, QPalette&
    35, 240, 0,	//546  QDataStream&, const QPainterPath&
    250, 250, 0,	//549  const QRectF&, const QRectF&
    271, 254, 0,	//552  double, const QSize&
    271, 244, 0,	//555  double, const QPoint&
    35, 244, 0,	//558  QDataStream&, const QPoint&
    35, 230, 0,	//561  QDataStream&, const QImage&
    221, 215, 0,	//564  const QByteArray&, char
    35, 74, 0,	//567  QDataStream&, QFont&
    123, 54, 0,	//570  QString::SectionFlag, QFlags<QString::SectionFlag>
    35, 254, 0,	//573  QDataStream&, const QSize&
    35, 109, 0,	//576  QDataStream&, QRectF&
    35, 222, 0,	//579  QDataStream&, const QChar&
    214, 25, 0,	//582  bool, QBool
    23, 51, 0,	//585  KUrl::QueryItemsOption, QFlags<KUrl::QueryItemsOption>
    247, 264, 0,	//588  const QPolygon&, const QTransform&
    25, 214, 0,	//591  QBool, bool
    211, 273, 0,	//594  Qt::WindowState, int
    35, 125, 0,	//597  QDataStream&, QStringList&
    35, 249, 0,	//600  QDataStream&, const QRect&
    20, 273, 0,	//603  KUrl::DirectoryOption, int
    35, 252, 0,	//606  QDataStream&, const QRegion&
    161, 161, 0,	//609  Qt::DockWidgetArea, Qt::DockWidgetArea
    35, 223, 0,	//612  QDataStream&, const QColor&
    212, 212, 0,	//615  Qt::WindowType, Qt::WindowType
    254, 271, 0,	//618  const QSize&, double
    122, 259, 0,	//621  QString::Null, const QString&
    174, 62, 0,	//624  Qt::InputMethodHint, QFlags<Qt::InputMethodHint>
    35, 101, 0,	//627  QDataStream&, QPoint&
    35, 37, 0,	//630  QDataStream&, QDateTime&
    35, 263, 0,	//633  QDataStream&, const QTime&
    35, 82, 0,	//636  QDataStream&, QKeySequence&
    252, 264, 0,	//639  const QRegion&, const QTransform&
    123, 123, 0,	//642  QString::SectionFlag, QString::SectionFlag
    76, 273, 0,	//645  QIODevice::OpenModeFlag, int
    273, 244, 0,	//648  int, const QPoint&
    168, 60, 0,	//651  Qt::GestureFlag, QFlags<Qt::GestureFlag>
    248, 236, 0,	//654  const QPolygonF&, const QMatrix&
    35, 105, 0,	//657  QDataStream&, QPolygon&
    21, 49, 0,	//660  KUrl::EncodedPathAndQueryOption, QFlags<KUrl::EncodedPathAndQueryOption>
    35, 121, 0,	//663  QDataStream&, QString&
    35, 259, 0,	//666  QDataStream&, const QString&
    35, 29, 0,	//669  QDataStream&, QChar&
    199, 199, 0,	//672  Qt::TextInteractionFlag, Qt::TextInteractionFlag
    35, 99, 0,	//675  QDataStream&, QPixmap&
    3, 44, 0,	//678  KConfigBase::WriteConfigFlag, QFlags<KConfigBase::WriteConfigFlag>
    259, 221, 0,	//681  const QString&, const QByteArray&
    35, 108, 0,	//684  QDataStream&, QRect&
    172, 273, 0,	//687  Qt::ImageConversionFlag, int
    35, 229, 0,	//690  QDataStream&, const QIcon&
    35, 267, 0,	//693  QDataStream&, const QVariant::Type
    35, 86, 0,	//696  QDataStream&, QLineF&
    35, 97, 0,	//699  QDataStream&, QPainterPath&
    205, 205, 0,	//702  Qt::TouchPointState, Qt::TouchPointState
    199, 273, 0,	//705  Qt::TextInteractionFlag, int
    244, 264, 0,	//708  const QPoint&, const QTransform&
    35, 226, 0,	//711  QDataStream&, const QDateTime&
    35, 129, 0,	//714  QDataStream&, QTime&
    244, 273, 0,	//717  const QPoint&, int
    172, 172, 0,	//720  Qt::ImageConversionFlag, Qt::ImageConversionFlag
    163, 59, 0,	//723  Qt::DropAction, QFlags<Qt::DropAction>
    163, 163, 0,	//726  Qt::DropAction, Qt::DropAction
    187, 273, 0,	//729  Qt::Orientation, int
    252, 236, 0,	//732  const QRegion&, const QMatrix&
    272, 244, 0,	//735  float, const QPoint&
    35, 133, 0,	//738  QDataStream&, QUrl&
    259, 28, 0,	//741  const QString&, QChar
    187, 67, 0,	//744  Qt::Orientation, QFlags<Qt::Orientation>
    8, 273, 0,	//747  KIconLoader::Group&, int
    30, 0,	//750  QChildEvent*
    73, 0,	//752  QFocusEvent*
    138, 0,	//754  QWheelEvent*
    91, 0,	//756  QMoveEvent*
    128, 0,	//758  QTabletEvent*
    24, 0,	//760  QActionEvent*
    39, 0,	//762  QDragEnterEvent*
    41, 0,	//764  QDragMoveEvent*
    40, 0,	//766  QDragLeaveEvent*
    42, 0,	//768  QDropEvent*
    213, 0,	//770  _XEvent*
    93, 0,	//772  QPaintDevice::PaintDeviceMetric
    80, 0,	//774  QInputMethodEvent*
    175, 0,	//776  Qt::InputMethodQuery
    127, 0,	//778  QStyle&
    241, 0,	//780  const QPalette&
    227, 0,	//782  const QFont&
};

// Raw list of all methods, using munged names
static const char *methodNames[] = {
    "",	//0
    "Accepted",	//1
    "AppNameCaption",	//2
    "Apply",	//3
    "Button",	//4
    "Button#",	//5
    "Button$$#",	//6
    "Cancel",	//7
    "Close",	//8
    "Default",	//9
    "DelayedPopup",	//10
    "Deleted",	//11
    "Details",	//12
    "DownloadDialog",	//13
    "DownloadDialog#",	//14
    "DownloadDialog$",	//15
    "DownloadDialog$#",	//16
    "Downloadable",	//17
    "DrawChildren",	//18
    "DrawWindowBackground",	//19
    "Entry",	//20
    "Entry#",	//21
    "HIGCompliantCaption",	//22
    "Help",	//23
    "IgnoreMask",	//24
    "Installed",	//25
    "Installing",	//26
    "InstantPopup",	//27
    "Invalid",	//28
    "ModifiedCaption",	//29
    "No",	//30
    "NoCaptionFlags",	//31
    "NoDefault",	//32
    "None",	//33
    "Ok",	//34
    "Rejected",	//35
    "Reset",	//36
    "Try",	//37
    "Updateable",	//38
    "Updating",	//39
    "UploadDialog",	//40
    "UploadDialog#",	//41
    "UploadDialog$",	//42
    "UploadDialog$#",	//43
    "User1",	//44
    "User2",	//45
    "User3",	//46
    "Yes",	//47
    "aboutToShowDialog",	//48
    "accept",	//49
    "actionEvent",	//50
    "category",	//51
    "changeEvent",	//52
    "changedEntries",	//53
    "checkStateSet",	//54
    "childEvent",	//55
    "closeEvent",	//56
    "connectNotify",	//57
    "contextMenuEvent",	//58
    "customEvent",	//59
    "devType",	//60
    "dialogFinished",	//61
    "dialogFinished?",	//62
    "disconnectNotify",	//63
    "done",	//64
    "dragEnterEvent",	//65
    "dragLeaveEvent",	//66
    "dragMoveEvent",	//67
    "dragObject",	//68
    "dropEvent",	//69
    "enabledChange",	//70
    "enterEvent",	//71
    "event",	//72
    "eventFilter",	//73
    "focusInEvent",	//74
    "focusNextPrevChild",	//75
    "focusOutEvent",	//76
    "fontChange",	//77
    "heightForWidth",	//78
    "hideEvent",	//79
    "hitButton",	//80
    "id",	//81
    "inputMethodEvent",	//82
    "inputMethodQuery",	//83
    "installedEntries",	//84
    "installedFiles",	//85
    "keyPressEvent",	//86
    "keyReleaseEvent",	//87
    "languageChange",	//88
    "leaveEvent",	//89
    "license",	//90
    "metaObject",	//91
    "metric",	//92
    "minimumSizeHint",	//93
    "mouseDoubleClickEvent",	//94
    "mouseMoveEvent",	//95
    "mousePressEvent",	//96
    "mouseReleaseEvent",	//97
    "moveEvent",	//98
    "name",	//99
    "nextCheckState",	//100
    "operator!=",	//101
    "operator!=##",	//102
    "operator!=#$",	//103
    "operator!=$#",	//104
    "operator!=$$",	//105
    "operator*",	//106
    "operator*##",	//107
    "operator*#$",	//108
    "operator*$#",	//109
    "operator+",	//110
    "operator+##",	//111
    "operator+#$",	//112
    "operator+$#",	//113
    "operator+$$",	//114
    "operator++",	//115
    "operator++$",	//116
    "operator++$$",	//117
    "operator-",	//118
    "operator-#",	//119
    "operator-##",	//120
    "operator-#$",	//121
    "operator/",	//122
    "operator/#$",	//123
    "operator<",	//124
    "operator<##",	//125
    "operator<#$",	//126
    "operator<$#",	//127
    "operator<$$",	//128
    "operator<<",	//129
    "operator<<##",	//130
    "operator<<#$",	//131
    "operator<<#?",	//132
    "operator<=",	//133
    "operator<=##",	//134
    "operator<=#$",	//135
    "operator<=$#",	//136
    "operator<=$$",	//137
    "operator=",	//138
    "operator=#",	//139
    "operator==",	//140
    "operator==##",	//141
    "operator==#$",	//142
    "operator==$#",	//143
    "operator==$$",	//144
    "operator>",	//145
    "operator>##",	//146
    "operator>#$",	//147
    "operator>$#",	//148
    "operator>$$",	//149
    "operator>=",	//150
    "operator>=##",	//151
    "operator>=#$",	//152
    "operator>=$#",	//153
    "operator>=$$",	//154
    "operator>>",	//155
    "operator>>##",	//156
    "operator>>#$",	//157
    "operator>>#?",	//158
    "operator|",	//159
    "operator|$$",	//160
    "paintEngine",	//161
    "paintEvent",	//162
    "paletteChange",	//163
    "providerId",	//164
    "qt_metacall",	//165
    "qt_metacall$$?",	//166
    "qt_metacast",	//167
    "qt_metacast$",	//168
    "reject",	//169
    "resizeEvent",	//170
    "selectCategory",	//171
    "selectCategory$",	//172
    "setButtonText",	//173
    "setButtonText$",	//174
    "setCaption",	//175
    "setChangelog",	//176
    "setChangelog$",	//177
    "setConfigFile",	//178
    "setConfigFile$",	//179
    "setDescription",	//180
    "setDescription$",	//181
    "setPlainCaption",	//182
    "setPreviewImageFile",	//183
    "setPreviewImageFile$#",	//184
    "setPrice",	//185
    "setPrice$",	//186
    "setPriceEnabled",	//187
    "setPriceEnabled$",	//188
    "setPriceReason",	//189
    "setPriceReason$",	//190
    "setUploadFile",	//191
    "setUploadFile#",	//192
    "setUploadName",	//193
    "setUploadName$",	//194
    "setVersion",	//195
    "setVersion$",	//196
    "setVisible",	//197
    "showDialog",	//198
    "showEvent",	//199
    "sizeHint",	//200
    "slotButtonClicked",	//201
    "startDrag",	//202
    "staticMetaObject",	//203
    "status",	//204
    "styleChange",	//205
    "summary",	//206
    "tabletEvent",	//207
    "timerEvent",	//208
    "tr",	//209
    "tr$",	//210
    "tr$$",	//211
    "tr$$$",	//212
    "trUtf8",	//213
    "trUtf8$",	//214
    "trUtf8$$",	//215
    "trUtf8$$$",	//216
    "uninstalledFiles",	//217
    "version",	//218
    "wheelEvent",	//219
    "windowActivationChange",	//220
    "x11Event",	//221
    "~Button",	//222
    "~DownloadDialog",	//223
    "~Entry",	//224
    "~UploadDialog",	//225
};

// (classId, name (index in methodNames), argumentList index, number of args, method flags, return type (index in types), xcall() index)
static Smoke::Method methods[] = {
    { 0, 0, 0, 0, 0, 0, 0 },	// (no method)
    {3, 200, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 115, 0},	//1 KDialog::sizeHint() const
    {3, 93, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 115, 0},	//2 KDialog::minimumSizeHint() const
    {3, 175, 1, 1, Smoke::mf_virtual|Smoke::mf_slot, 0, 0},	//3 KDialog::setCaption(const QString&)
    {3, 175, 3, 2, Smoke::mf_virtual|Smoke::mf_slot, 0, 0},	//4 KDialog::setCaption(const QString&, bool)
    {3, 182, 1, 1, Smoke::mf_virtual|Smoke::mf_slot, 0, 0},	//5 KDialog::setPlainCaption(const QString&)
    {3, 79, 6, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//6 KDialog::hideEvent(QHideEvent*)
    {3, 56, 8, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//7 KDialog::closeEvent(QCloseEvent*)
    {3, 86, 10, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//8 KDialog::keyPressEvent(QKeyEvent*)
    {3, 201, 12, 1, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_slot, 0, 0},	//9 KDialog::slotButtonClicked(int)
    {3, 33, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 10},	//10 KDialog::None (enum)
    {3, 23, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 11},	//11 KDialog::Help (enum)
    {3, 9, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 12},	//12 KDialog::Default (enum)
    {3, 34, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 13},	//13 KDialog::Ok (enum)
    {3, 3, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 14},	//14 KDialog::Apply (enum)
    {3, 37, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 15},	//15 KDialog::Try (enum)
    {3, 7, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 16},	//16 KDialog::Cancel (enum)
    {3, 8, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 17},	//17 KDialog::Close (enum)
    {3, 30, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 18},	//18 KDialog::No (enum)
    {3, 47, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 19},	//19 KDialog::Yes (enum)
    {3, 36, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 20},	//20 KDialog::Reset (enum)
    {3, 12, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 21},	//21 KDialog::Details (enum)
    {3, 44, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 22},	//22 KDialog::User1 (enum)
    {3, 45, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 23},	//23 KDialog::User2 (enum)
    {3, 46, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 24},	//24 KDialog::User3 (enum)
    {3, 32, 0, 0, Smoke::mf_static|Smoke::mf_enum, 4, 25},	//25 KDialog::NoDefault (enum)
    {3, 31, 0, 0, Smoke::mf_static|Smoke::mf_enum, 5, 26},	//26 KDialog::NoCaptionFlags (enum)
    {3, 2, 0, 0, Smoke::mf_static|Smoke::mf_enum, 5, 27},	//27 KDialog::AppNameCaption (enum)
    {3, 29, 0, 0, Smoke::mf_static|Smoke::mf_enum, 5, 28},	//28 KDialog::ModifiedCaption (enum)
    {3, 22, 0, 0, Smoke::mf_static|Smoke::mf_enum, 5, 29},	//29 KDialog::HIGCompliantCaption (enum)
    {4, 91, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 238, 1},	//30 KNS3::Button::metaObject() const
    {4, 167, 14, 1, Smoke::mf_virtual, 275, 2},	//31 KNS3::Button::qt_metacast(const char*)
    {4, 209, 16, 2, Smoke::mf_static, 120, 3},	//32 KNS3::Button::tr(const char*, const char*)
    {4, 213, 16, 2, Smoke::mf_static, 120, 4},	//33 KNS3::Button::trUtf8(const char*, const char*)
    {4, 209, 19, 3, Smoke::mf_static, 120, 5},	//34 KNS3::Button::tr(const char*, const char*, int)
    {4, 213, 19, 3, Smoke::mf_static, 120, 6},	//35 KNS3::Button::trUtf8(const char*, const char*, int)
    {4, 165, 23, 3, Smoke::mf_virtual, 273, 7},	//36 KNS3::Button::qt_metacall(QMetaObject::Call, int, void**)
    {4, 4, 27, 3, Smoke::mf_ctor, 9, 8},	//37 KNS3::Button::Button(const QString&, const QString&, QWidget*)
    {4, 4, 31, 1, Smoke::mf_ctor, 9, 9},	//38 KNS3::Button::Button(QWidget*)
    {4, 178, 1, 1, 0, 0, 10},	//39 KNS3::Button::setConfigFile(const QString&)
    {4, 173, 1, 1, 0, 0, 11},	//40 KNS3::Button::setButtonText(const QString&)
    {4, 48, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 12},	//41 KNS3::Button::aboutToShowDialog()
    {4, 61, 33, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 13},	//42 KNS3::Button::dialogFinished(const KNS3::Entry::List&)
    {4, 198, 0, 0, Smoke::mf_protected|Smoke::mf_slot, 0, 14},	//43 KNS3::Button::showDialog()
    {4, 209, 14, 1, Smoke::mf_static, 120, 15},	//44 KNS3::Button::tr(const char*)
    {4, 213, 14, 1, Smoke::mf_static, 120, 16},	//45 KNS3::Button::trUtf8(const char*)
    {4, 203, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 237, 17},	//46 KNS3::Button::staticMetaObject() const
    {4, 222, 0, 0, Smoke::mf_dtor, 0, 18 },	//47 KNS3::Button::~Button()
    {5, 91, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 238, 1},	//48 KNS3::DownloadDialog::metaObject() const
    {5, 167, 14, 1, Smoke::mf_virtual, 275, 2},	//49 KNS3::DownloadDialog::qt_metacast(const char*)
    {5, 209, 16, 2, Smoke::mf_static, 120, 3},	//50 KNS3::DownloadDialog::tr(const char*, const char*)
    {5, 213, 16, 2, Smoke::mf_static, 120, 4},	//51 KNS3::DownloadDialog::trUtf8(const char*, const char*)
    {5, 209, 19, 3, Smoke::mf_static, 120, 5},	//52 KNS3::DownloadDialog::tr(const char*, const char*, int)
    {5, 213, 19, 3, Smoke::mf_static, 120, 6},	//53 KNS3::DownloadDialog::trUtf8(const char*, const char*, int)
    {5, 165, 23, 3, Smoke::mf_virtual, 273, 7},	//54 KNS3::DownloadDialog::qt_metacall(QMetaObject::Call, int, void**)
    {5, 13, 31, 1, Smoke::mf_ctor, 10, 8},	//55 KNS3::DownloadDialog::DownloadDialog(QWidget*)
    {5, 13, 35, 2, Smoke::mf_ctor, 10, 9},	//56 KNS3::DownloadDialog::DownloadDialog(const QString&, QWidget*)
    {5, 53, 0, 0, 0, 87, 10},	//57 KNS3::DownloadDialog::changedEntries()
    {5, 84, 0, 0, 0, 87, 11},	//58 KNS3::DownloadDialog::installedEntries()
    {5, 209, 14, 1, Smoke::mf_static, 120, 12},	//59 KNS3::DownloadDialog::tr(const char*)
    {5, 213, 14, 1, Smoke::mf_static, 120, 13},	//60 KNS3::DownloadDialog::trUtf8(const char*)
    {5, 13, 0, 0, Smoke::mf_ctor, 10, 14},	//61 KNS3::DownloadDialog::DownloadDialog()
    {5, 13, 1, 1, Smoke::mf_ctor, 10, 15},	//62 KNS3::DownloadDialog::DownloadDialog(const QString&)
    {5, 203, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 237, 16},	//63 KNS3::DownloadDialog::staticMetaObject() const
    {5, 223, 0, 0, Smoke::mf_dtor, 0, 17 },	//64 KNS3::DownloadDialog::~DownloadDialog()
    {6, 20, 38, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 13, 1},	//65 KNS3::Entry::Entry(const KNS3::Entry&)
    {6, 138, 38, 1, 0, 12, 2},	//66 KNS3::Entry::operator=(const KNS3::Entry&)
    {6, 99, 0, 0, Smoke::mf_const, 120, 3},	//67 KNS3::Entry::name() const
    {6, 51, 0, 0, Smoke::mf_const, 120, 4},	//68 KNS3::Entry::category() const
    {6, 85, 0, 0, Smoke::mf_const, 124, 5},	//69 KNS3::Entry::installedFiles() const
    {6, 217, 0, 0, Smoke::mf_const, 124, 6},	//70 KNS3::Entry::uninstalledFiles() const
    {6, 204, 0, 0, Smoke::mf_const, 15, 7},	//71 KNS3::Entry::status() const
    {6, 90, 0, 0, Smoke::mf_const, 120, 8},	//72 KNS3::Entry::license() const
    {6, 206, 0, 0, Smoke::mf_const, 120, 9},	//73 KNS3::Entry::summary() const
    {6, 218, 0, 0, Smoke::mf_const, 120, 10},	//74 KNS3::Entry::version() const
    {6, 81, 0, 0, Smoke::mf_const, 120, 11},	//75 KNS3::Entry::id() const
    {6, 164, 0, 0, Smoke::mf_const, 120, 12},	//76 KNS3::Entry::providerId() const
    {6, 28, 0, 0, Smoke::mf_static|Smoke::mf_enum, 15, 13},	//77 KNS3::Entry::Invalid (enum)
    {6, 17, 0, 0, Smoke::mf_static|Smoke::mf_enum, 15, 14},	//78 KNS3::Entry::Downloadable (enum)
    {6, 25, 0, 0, Smoke::mf_static|Smoke::mf_enum, 15, 15},	//79 KNS3::Entry::Installed (enum)
    {6, 38, 0, 0, Smoke::mf_static|Smoke::mf_enum, 15, 16},	//80 KNS3::Entry::Updateable (enum)
    {6, 11, 0, 0, Smoke::mf_static|Smoke::mf_enum, 15, 17},	//81 KNS3::Entry::Deleted (enum)
    {6, 26, 0, 0, Smoke::mf_static|Smoke::mf_enum, 15, 18},	//82 KNS3::Entry::Installing (enum)
    {6, 39, 0, 0, Smoke::mf_static|Smoke::mf_enum, 15, 19},	//83 KNS3::Entry::Updating (enum)
    {6, 224, 0, 0, Smoke::mf_dtor, 0, 20 },	//84 KNS3::Entry::~Entry()
    {7, 91, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 238, 1},	//85 KNS3::UploadDialog::metaObject() const
    {7, 167, 14, 1, Smoke::mf_virtual, 275, 2},	//86 KNS3::UploadDialog::qt_metacast(const char*)
    {7, 209, 16, 2, Smoke::mf_static, 120, 3},	//87 KNS3::UploadDialog::tr(const char*, const char*)
    {7, 213, 16, 2, Smoke::mf_static, 120, 4},	//88 KNS3::UploadDialog::trUtf8(const char*, const char*)
    {7, 209, 19, 3, Smoke::mf_static, 120, 5},	//89 KNS3::UploadDialog::tr(const char*, const char*, int)
    {7, 213, 19, 3, Smoke::mf_static, 120, 6},	//90 KNS3::UploadDialog::trUtf8(const char*, const char*, int)
    {7, 165, 23, 3, Smoke::mf_virtual, 273, 7},	//91 KNS3::UploadDialog::qt_metacall(QMetaObject::Call, int, void**)
    {7, 40, 31, 1, Smoke::mf_ctor, 16, 8},	//92 KNS3::UploadDialog::UploadDialog(QWidget*)
    {7, 40, 35, 2, Smoke::mf_ctor, 16, 9},	//93 KNS3::UploadDialog::UploadDialog(const QString&, QWidget*)
    {7, 191, 40, 1, 0, 0, 10},	//94 KNS3::UploadDialog::setUploadFile(const KUrl&)
    {7, 193, 1, 1, 0, 0, 11},	//95 KNS3::UploadDialog::setUploadName(const QString&)
    {7, 195, 1, 1, 0, 0, 12},	//96 KNS3::UploadDialog::setVersion(const QString&)
    {7, 180, 1, 1, 0, 0, 13},	//97 KNS3::UploadDialog::setDescription(const QString&)
    {7, 176, 1, 1, 0, 0, 14},	//98 KNS3::UploadDialog::setChangelog(const QString&)
    {7, 183, 42, 2, 0, 0, 15},	//99 KNS3::UploadDialog::setPreviewImageFile(unsigned int, const KUrl&)
    {7, 187, 45, 1, 0, 0, 16},	//100 KNS3::UploadDialog::setPriceEnabled(bool)
    {7, 185, 47, 1, 0, 0, 17},	//101 KNS3::UploadDialog::setPrice(double)
    {7, 189, 1, 1, 0, 0, 18},	//102 KNS3::UploadDialog::setPriceReason(const QString&)
    {7, 171, 1, 1, 0, 0, 19},	//103 KNS3::UploadDialog::selectCategory(const QString&)
    {7, 49, 0, 0, Smoke::mf_virtual|Smoke::mf_slot, 0, 20},	//104 KNS3::UploadDialog::accept()
    {7, 209, 14, 1, Smoke::mf_static, 120, 21},	//105 KNS3::UploadDialog::tr(const char*)
    {7, 213, 14, 1, Smoke::mf_static, 120, 22},	//106 KNS3::UploadDialog::trUtf8(const char*)
    {7, 40, 0, 0, Smoke::mf_ctor, 16, 23},	//107 KNS3::UploadDialog::UploadDialog()
    {7, 40, 1, 1, Smoke::mf_ctor, 16, 24},	//108 KNS3::UploadDialog::UploadDialog(const QString&)
    {7, 203, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 237, 25},	//109 KNS3::UploadDialog::staticMetaObject() const
    {7, 225, 0, 0, Smoke::mf_dtor, 0, 26 },	//110 KNS3::UploadDialog::~UploadDialog()
    {8, 200, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 115, 0},	//111 KPushButton::sizeHint() const
    {8, 68, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 38, 0},	//112 KPushButton::dragObject()
    {8, 96, 49, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//113 KPushButton::mousePressEvent(QMouseEvent*)
    {8, 95, 49, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//114 KPushButton::mouseMoveEvent(QMouseEvent*)
    {8, 162, 51, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//115 KPushButton::paintEvent(QPaintEvent*)
    {8, 202, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//116 KPushButton::startDrag()
    {10, 80, 53, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 214, 0},	//117 QAbstractButton::hitButton(const QPoint&) const
    {10, 54, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//118 QAbstractButton::checkStateSet()
    {10, 100, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//119 QAbstractButton::nextCheckState()
    {10, 87, 10, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//120 QAbstractButton::keyReleaseEvent(QKeyEvent*)
    {10, 97, 49, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//121 QAbstractButton::mouseReleaseEvent(QMouseEvent*)
    {10, 52, 55, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//122 QAbstractButton::changeEvent(QEvent*)
    {10, 208, 57, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//123 QAbstractButton::timerEvent(QTimerEvent*)
    {24, 197, 45, 1, Smoke::mf_virtual, 0, 0},	//124 QDialog::setVisible(bool)
    {24, 64, 12, 1, Smoke::mf_virtual|Smoke::mf_slot, 0, 0},	//125 QDialog::done(int)
    {24, 49, 0, 0, Smoke::mf_virtual|Smoke::mf_slot, 0, 0},	//126 QDialog::accept()
    {24, 169, 0, 0, Smoke::mf_virtual|Smoke::mf_slot, 0, 0},	//127 QDialog::reject()
    {24, 199, 59, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//128 QDialog::showEvent(QShowEvent*)
    {24, 170, 61, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//129 QDialog::resizeEvent(QResizeEvent*)
    {24, 58, 63, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//130 QDialog::contextMenuEvent(QContextMenuEvent*)
    {24, 73, 65, 2, Smoke::mf_protected|Smoke::mf_virtual, 214, 0},	//131 QDialog::eventFilter(QObject*, QEvent*)
    {33, 159, 68, 2, Smoke::mf_static, 79, 1},	//132 QGlobalSpace::operator|(Qt::DockWidgetArea, int)
    {33, 106, 71, 2, Smoke::mf_static, 243, 2},	//133 QGlobalSpace::operator*(const QPoint&, double)
    {33, 106, 74, 2, Smoke::mf_static, 245, 3},	//134 QGlobalSpace::operator*(double, const QPointF&)
    {33, 159, 77, 2, Smoke::mf_static, 66, 4},	//135 QGlobalSpace::operator|(Qt::MouseButton, QFlags<Qt::MouseButton>)
    {33, 101, 80, 2, Smoke::mf_static, 214, 5},	//136 QGlobalSpace::operator!=(const QMargins&, const QMargins&)
    {33, 106, 83, 2, Smoke::mf_static, 255, 6},	//137 QGlobalSpace::operator*(double, const QSizeF&)
    {33, 155, 86, 2, Smoke::mf_static, 35, 7},	//138 QGlobalSpace::operator>>(QDataStream&, QImage&)
    {33, 129, 89, 2, Smoke::mf_static, 35, 8},	//139 QGlobalSpace::operator<<(QDataStream&, const QSizePolicy&)
    {33, 159, 92, 2, Smoke::mf_static, 79, 9},	//140 QGlobalSpace::operator|(Qt::InputMethodHint, int)
    {33, 101, 95, 2, Smoke::mf_static, 214, 10},	//141 QGlobalSpace::operator!=(const QRect&, const QRect&)
    {33, 110, 98, 2, Smoke::mf_static, 253, 11},	//142 QGlobalSpace::operator+(const QSize&, const QSize&)
    {33, 129, 101, 2, Smoke::mf_static, 35, 12},	//143 QGlobalSpace::operator<<(QDataStream&, const QTransform&)
    {33, 106, 104, 2, Smoke::mf_static, 102, 13},	//144 QGlobalSpace::operator*(const QPointF&, const QMatrix&)
    {33, 106, 107, 2, Smoke::mf_static, 83, 14},	//145 QGlobalSpace::operator*(const QLine&, const QTransform&)
    {33, 140, 80, 2, Smoke::mf_static, 214, 15},	//146 QGlobalSpace::operator==(const QMargins&, const QMargins&)
    {33, 159, 110, 2, Smoke::mf_static, 71, 16},	//147 QGlobalSpace::operator|(Qt::WindowState, QFlags<Qt::WindowState>)
    {33, 106, 113, 2, Smoke::mf_static, 255, 17},	//148 QGlobalSpace::operator*(const QSizeF&, double)
    {33, 129, 116, 2, Smoke::mf_static, 35, 18},	//149 QGlobalSpace::operator<<(QDataStream&, const QLine&)
    {33, 145, 119, 2, Smoke::mf_static, 214, 19},	//150 QGlobalSpace::operator>(const char*, const QLatin1String&)
    {33, 118, 122, 2, Smoke::mf_static, 255, 20},	//151 QGlobalSpace::operator-(const QSizeF&, const QSizeF&)
    {33, 150, 125, 2, Smoke::mf_static, 214, 21},	//152 QGlobalSpace::operator>=(const QByteArray&, const QByteArray&)
    {33, 140, 128, 2, Smoke::mf_static, 214, 22},	//153 QGlobalSpace::operator==(const QLatin1String&, const QStringRef&)
    {33, 159, 131, 2, Smoke::mf_static, 66, 23},	//154 QGlobalSpace::operator|(Qt::MouseButton, Qt::MouseButton)
    {33, 159, 134, 2, Smoke::mf_static, 47, 24},	//155 QGlobalSpace::operator|(KUrl::CleanPathOption, QFlags<KUrl::CleanPathOption>)
    {33, 159, 137, 2, Smoke::mf_static, 47, 25},	//156 QGlobalSpace::operator|(KUrl::CleanPathOption, KUrl::CleanPathOption)
    {33, 101, 140, 2, Smoke::mf_static, 214, 26},	//157 QGlobalSpace::operator!=(const QVariant&, const QVariantComparisonHelper&)
    {33, 140, 143, 2, Smoke::mf_static, 214, 27},	//158 QGlobalSpace::operator==(QBool, QBool)
    {33, 159, 146, 2, Smoke::mf_static, 79, 28},	//159 QGlobalSpace::operator|(KConfigBase::WriteConfigFlag, int)
    {33, 159, 149, 2, Smoke::mf_static, 57, 29},	//160 QGlobalSpace::operator|(Qt::AlignmentFlag, QFlags<Qt::AlignmentFlag>)
    {33, 140, 152, 2, Smoke::mf_static, 214, 30},	//161 QGlobalSpace::operator==(QString::Null, QString::Null)
    {33, 129, 155, 2, Smoke::mf_static, 35, 31},	//162 QGlobalSpace::operator<<(QDataStream&, const QRectF&)
    {33, 110, 158, 2, Smoke::mf_static, 258, 32},	//163 QGlobalSpace::operator+(QChar, const QString&)
    {33, 159, 161, 2, Smoke::mf_static, 45, 33},	//164 QGlobalSpace::operator|(KDialog::ButtonCode, KDialog::ButtonCode)
    {33, 159, 164, 2, Smoke::mf_static, 52, 34},	//165 QGlobalSpace::operator|(QIODevice::OpenModeFlag, QFlags<QIODevice::OpenModeFlag>)
    {33, 129, 167, 2, Smoke::mf_static, 35, 35},	//166 QGlobalSpace::operator<<(QDataStream&, const QPalette&)
    {33, 115, 170, 1, Smoke::mf_static, 8, 36},	//167 QGlobalSpace::operator++(KIconLoader::Group&)
    {33, 129, 172, 2, Smoke::mf_static, 35, 37},	//168 QGlobalSpace::operator<<(QDataStream&, const QByteArray&)
    {33, 106, 175, 2, Smoke::mf_static, 106, 38},	//169 QGlobalSpace::operator*(const QPolygonF&, const QTransform&)
    {33, 159, 178, 2, Smoke::mf_static, 69, 39},	//170 QGlobalSpace::operator|(Qt::ToolBarArea, Qt::ToolBarArea)
    {33, 159, 181, 2, Smoke::mf_static, 79, 40},	//171 QGlobalSpace::operator|(KUrl::QueryItemsOption, int)
    {33, 110, 122, 2, Smoke::mf_static, 255, 41},	//172 QGlobalSpace::operator+(const QSizeF&, const QSizeF&)
    {33, 159, 184, 2, Smoke::mf_static, 79, 42},	//173 QGlobalSpace::operator|(QWidget::RenderFlag, int)
    {33, 159, 187, 2, Smoke::mf_static, 79, 43},	//174 QGlobalSpace::operator|(Qt::DropAction, int)
    {33, 129, 190, 2, Smoke::mf_static, 35, 44},	//175 QGlobalSpace::operator<<(QDataStream&, const QStringList&)
    {33, 159, 193, 2, Smoke::mf_static, 49, 45},	//176 QGlobalSpace::operator|(KUrl::EncodedPathAndQueryOption, KUrl::EncodedPathAndQueryOption)
    {33, 159, 196, 2, Smoke::mf_static, 57, 46},	//177 QGlobalSpace::operator|(Qt::AlignmentFlag, Qt::AlignmentFlag)
    {33, 155, 199, 2, Smoke::mf_static, 35, 47},	//178 QGlobalSpace::operator>>(QDataStream&, QColor&)
    {33, 129, 202, 2, Smoke::mf_static, 35, 48},	//179 QGlobalSpace::operator<<(QDataStream&, const QRegExp&)
    {33, 159, 205, 2, Smoke::mf_static, 79, 49},	//180 QGlobalSpace::operator|(QUrl::FormattingOption, int)
    {33, 124, 208, 2, Smoke::mf_static, 214, 50},	//181 QGlobalSpace::operator<(const QByteArray&, const char*)
    {33, 159, 211, 2, Smoke::mf_static, 48, 51},	//182 QGlobalSpace::operator|(KUrl::DirectoryOption, KUrl::DirectoryOption)
    {33, 159, 214, 2, Smoke::mf_static, 58, 52},	//183 QGlobalSpace::operator|(Qt::DockWidgetArea, QFlags<Qt::DockWidgetArea>)
    {33, 159, 217, 2, Smoke::mf_static, 46, 53},	//184 QGlobalSpace::operator|(KDialog::CaptionFlag, KDialog::CaptionFlag)
    {33, 106, 220, 2, Smoke::mf_static, 83, 54},	//185 QGlobalSpace::operator*(const QLine&, const QMatrix&)
    {33, 159, 223, 2, Smoke::mf_static, 48, 55},	//186 QGlobalSpace::operator|(KUrl::DirectoryOption, QFlags<KUrl::DirectoryOption>)
    {33, 106, 226, 2, Smoke::mf_static, 85, 56},	//187 QGlobalSpace::operator*(const QLineF&, const QMatrix&)
    {33, 159, 229, 2, Smoke::mf_static, 67, 57},	//188 QGlobalSpace::operator|(Qt::Orientation, Qt::Orientation)
    {33, 106, 232, 2, Smoke::mf_static, 96, 58},	//189 QGlobalSpace::operator*(const QPainterPath&, const QMatrix&)
    {33, 159, 235, 2, Smoke::mf_static, 79, 59},	//190 QGlobalSpace::operator|(Qt::ToolBarArea, int)
    {33, 155, 238, 2, Smoke::mf_static, 35, 60},	//191 QGlobalSpace::operator>>(QDataStream&, QPointF&)
    {33, 129, 241, 2, Smoke::mf_static, 35, 61},	//192 QGlobalSpace::operator<<(QDataStream&, const QKeySequence&)
    {33, 159, 244, 2, Smoke::mf_static, 79, 62},	//193 QGlobalSpace::operator|(Qt::MatchFlag, int)
    {33, 110, 247, 2, Smoke::mf_static, 258, 63},	//194 QGlobalSpace::operator+(const QString&, const char*)
    {33, 129, 250, 2, Smoke::mf_static, 35, 64},	//195 QGlobalSpace::operator<<(QDataStream&, const QCursor&)
    {33, 159, 253, 2, Smoke::mf_static, 60, 65},	//196 QGlobalSpace::operator|(Qt::GestureFlag, Qt::GestureFlag)
    {33, 155, 256, 2, Smoke::mf_static, 35, 66},	//197 QGlobalSpace::operator>>(QDataStream&, QDate&)
    {33, 159, 259, 2, Smoke::mf_static, 52, 67},	//198 QGlobalSpace::operator|(QIODevice::OpenModeFlag, QIODevice::OpenModeFlag)
    {33, 110, 262, 2, Smoke::mf_static, 220, 68},	//199 QGlobalSpace::operator+(char, const QByteArray&)
    {33, 122, 71, 2, Smoke::mf_static, 243, 69},	//200 QGlobalSpace::operator/(const QPoint&, double)
    {33, 110, 265, 2, Smoke::mf_static, 258, 70},	//201 QGlobalSpace::operator+(const char*, const QString&)
    {33, 140, 268, 2, Smoke::mf_static, 214, 71},	//202 QGlobalSpace::operator==(const char*, const QByteArray&)
    {33, 155, 271, 2, Smoke::mf_static, 35, 72},	//203 QGlobalSpace::operator>>(QDataStream&, QByteArray&)
    {33, 155, 274, 2, Smoke::mf_static, 35, 73},	//204 QGlobalSpace::operator>>(QDataStream&, QVariant&)
    {33, 159, 277, 2, Smoke::mf_static, 79, 74},	//205 QGlobalSpace::operator|(KDialog::ButtonCode, int)
    {33, 155, 280, 2, Smoke::mf_static, 35, 75},	//206 QGlobalSpace::operator>>(QDataStream&, QRegExp&)
    {33, 140, 283, 2, Smoke::mf_static, 214, 76},	//207 QGlobalSpace::operator==(const QPointF&, const QPointF&)
    {33, 122, 286, 2, Smoke::mf_static, 131, 77},	//208 QGlobalSpace::operator/(const QTransform&, double)
    {33, 133, 265, 2, Smoke::mf_static, 214, 78},	//209 QGlobalSpace::operator<=(const char*, const QString&)
    {33, 101, 289, 2, Smoke::mf_static, 214, 79},	//210 QGlobalSpace::operator!=(const QStringRef&, const QStringRef&)
    {33, 124, 292, 2, Smoke::mf_static, 214, 80},	//211 QGlobalSpace::operator<(QChar, QChar)
    {33, 106, 295, 2, Smoke::mf_static, 96, 81},	//212 QGlobalSpace::operator*(const QPainterPath&, const QTransform&)
    {33, 129, 298, 2, Smoke::mf_static, 35, 82},	//213 QGlobalSpace::operator<<(QDataStream&, const QBrush&)
    {33, 150, 119, 2, Smoke::mf_static, 214, 83},	//214 QGlobalSpace::operator>=(const char*, const QLatin1String&)
    {33, 159, 301, 2, Smoke::mf_static, 45, 84},	//215 QGlobalSpace::operator|(KDialog::ButtonCode, QFlags<KDialog::ButtonCode>)
    {33, 155, 304, 2, Smoke::mf_static, 35, 85},	//216 QGlobalSpace::operator>>(QDataStream&, QRegion&)
    {33, 106, 307, 2, Smoke::mf_static, 245, 86},	//217 QGlobalSpace::operator*(const QPointF&, double)
    {33, 159, 310, 2, Smoke::mf_static, 79, 87},	//218 QGlobalSpace::operator|(KUrl::EncodedPathAndQueryOption, int)
    {33, 140, 98, 2, Smoke::mf_static, 214, 88},	//219 QGlobalSpace::operator==(const QSize&, const QSize&)
    {33, 129, 313, 2, Smoke::mf_static, 35, 89},	//220 QGlobalSpace::operator<<(QDataStream&, const QDate&)
    {33, 140, 119, 2, Smoke::mf_static, 214, 90},	//221 QGlobalSpace::operator==(const char*, const QLatin1String&)
    {33, 159, 316, 2, Smoke::mf_static, 65, 91},	//222 QGlobalSpace::operator|(Qt::MatchFlag, QFlags<Qt::MatchFlag>)
    {33, 159, 319, 2, Smoke::mf_static, 79, 92},	//223 QGlobalSpace::operator|(Qt::GestureFlag, int)
    {33, 101, 125, 2, Smoke::mf_static, 214, 93},	//224 QGlobalSpace::operator!=(const QByteArray&, const QByteArray&)
    {33, 159, 322, 2, Smoke::mf_static, 53, 94},	//225 QGlobalSpace::operator|(QSizePolicy::ControlType, QSizePolicy::ControlType)
    {33, 155, 325, 2, Smoke::mf_static, 35, 95},	//226 QGlobalSpace::operator>>(QDataStream&, QCursor&)
    {33, 159, 328, 2, Smoke::mf_static, 64, 96},	//227 QGlobalSpace::operator|(Qt::KeyboardModifier, QFlags<Qt::KeyboardModifier>)
    {33, 122, 113, 2, Smoke::mf_static, 255, 97},	//228 QGlobalSpace::operator/(const QSizeF&, double)
    {33, 159, 331, 2, Smoke::mf_static, 65, 98},	//229 QGlobalSpace::operator|(Qt::MatchFlag, Qt::MatchFlag)
    {33, 155, 334, 2, Smoke::mf_static, 35, 99},	//230 QGlobalSpace::operator>>(QDataStream&, QTransform&)
    {33, 106, 337, 2, Smoke::mf_static, 104, 100},	//231 QGlobalSpace::operator*(const QPolygon&, const QMatrix&)
    {33, 145, 292, 2, Smoke::mf_static, 214, 101},	//232 QGlobalSpace::operator>(QChar, QChar)
    {33, 150, 268, 2, Smoke::mf_static, 214, 102},	//233 QGlobalSpace::operator>=(const char*, const QByteArray&)
    {33, 140, 340, 2, Smoke::mf_static, 214, 103},	//234 QGlobalSpace::operator==(const QString&, QString::Null)
    {33, 124, 125, 2, Smoke::mf_static, 214, 104},	//235 QGlobalSpace::operator<(const QByteArray&, const QByteArray&)
    {33, 155, 343, 2, Smoke::mf_static, 35, 105},	//236 QGlobalSpace::operator>>(QDataStream&, QSizeF&)
    {33, 118, 346, 1, Smoke::mf_static, 245, 106},	//237 QGlobalSpace::operator-(const QPointF&)
    {33, 159, 348, 2, Smoke::mf_static, 63, 107},	//238 QGlobalSpace::operator|(Qt::ItemFlag, Qt::ItemFlag)
    {33, 129, 351, 2, Smoke::mf_static, 35, 108},	//239 QGlobalSpace::operator<<(QDataStream&, const QPixmap&)
    {33, 110, 354, 2, Smoke::mf_static, 258, 109},	//240 QGlobalSpace::operator+(const QByteArray&, const QString&)
    {33, 159, 357, 2, Smoke::mf_static, 72, 110},	//241 QGlobalSpace::operator|(Qt::WindowType, QFlags<Qt::WindowType>)
    {33, 106, 360, 2, Smoke::mf_static, 102, 111},	//242 QGlobalSpace::operator*(const QPointF&, const QTransform&)
    {33, 159, 363, 2, Smoke::mf_static, 63, 112},	//243 QGlobalSpace::operator|(Qt::ItemFlag, QFlags<Qt::ItemFlag>)
    {33, 159, 366, 2, Smoke::mf_static, 70, 113},	//244 QGlobalSpace::operator|(Qt::TouchPointState, QFlags<Qt::TouchPointState>)
    {33, 110, 369, 2, Smoke::mf_static, 258, 114},	//245 QGlobalSpace::operator+(const QString&, char)
    {33, 150, 289, 2, Smoke::mf_static, 214, 115},	//246 QGlobalSpace::operator>=(const QStringRef&, const QStringRef&)
    {33, 140, 140, 2, Smoke::mf_static, 214, 116},	//247 QGlobalSpace::operator==(const QVariant&, const QVariantComparisonHelper&)
    {33, 129, 372, 2, Smoke::mf_static, 35, 117},	//248 QGlobalSpace::operator<<(QDataStream&, const QUrl&)
    {33, 159, 375, 2, Smoke::mf_static, 53, 118},	//249 QGlobalSpace::operator|(QSizePolicy::ControlType, QFlags<QSizePolicy::ControlType>)
    {33, 129, 378, 2, Smoke::mf_static, 35, 119},	//250 QGlobalSpace::operator<<(QDataStream&, const QVariant&)
    {33, 155, 381, 2, Smoke::mf_static, 35, 120},	//251 QGlobalSpace::operator>>(QDataStream&, QLine&)
    {33, 159, 384, 2, Smoke::mf_static, 64, 121},	//252 QGlobalSpace::operator|(Qt::KeyboardModifier, Qt::KeyboardModifier)
    {33, 124, 268, 2, Smoke::mf_static, 214, 122},	//253 QGlobalSpace::operator<(const char*, const QByteArray&)
    {33, 159, 387, 2, Smoke::mf_static, 79, 123},	//254 QGlobalSpace::operator|(Qt::AlignmentFlag, int)
    {33, 106, 390, 2, Smoke::mf_static, 100, 124},	//255 QGlobalSpace::operator*(const QPoint&, const QMatrix&)
    {33, 159, 393, 2, Smoke::mf_static, 79, 125},	//256 QGlobalSpace::operator|(Qt::KeyboardModifier, int)
    {33, 159, 396, 2, Smoke::mf_static, 79, 126},	//257 QGlobalSpace::operator|(Qt::ItemFlag, int)
    {33, 101, 98, 2, Smoke::mf_static, 214, 127},	//258 QGlobalSpace::operator!=(const QSize&, const QSize&)
    {33, 159, 399, 2, Smoke::mf_static, 61, 128},	//259 QGlobalSpace::operator|(Qt::ImageConversionFlag, QFlags<Qt::ImageConversionFlag>)
    {33, 133, 208, 2, Smoke::mf_static, 214, 129},	//260 QGlobalSpace::operator<=(const QByteArray&, const char*)
    {33, 101, 402, 2, Smoke::mf_static, 214, 130},	//261 QGlobalSpace::operator!=(const QPoint&, const QPoint&)
    {33, 159, 405, 2, Smoke::mf_static, 79, 131},	//262 QGlobalSpace::operator|(QString::SectionFlag, int)
    {33, 159, 408, 2, Smoke::mf_static, 79, 132},	//263 QGlobalSpace::operator|(Qt::WindowType, int)
    {33, 159, 411, 2, Smoke::mf_static, 56, 133},	//264 QGlobalSpace::operator|(QWidget::RenderFlag, QWidget::RenderFlag)
    {33, 140, 414, 2, Smoke::mf_static, 214, 134},	//265 QGlobalSpace::operator==(const QStringRef&, const QString&)
    {33, 150, 417, 2, Smoke::mf_static, 214, 135},	//266 QGlobalSpace::operator>=(const QLatin1String&, const QLatin1String&)
    {33, 140, 420, 2, Smoke::mf_static, 214, 136},	//267 QGlobalSpace::operator==(const QHashDummyValue&, const QHashDummyValue&)
    {33, 159, 423, 2, Smoke::mf_static, 50, 137},	//268 QGlobalSpace::operator|(KUrl::EqualsOption, KUrl::EqualsOption)
    {33, 159, 426, 2, Smoke::mf_static, 55, 138},	//269 QGlobalSpace::operator|(QUrl::FormattingOption, QUrl::FormattingOption)
    {33, 155, 429, 2, Smoke::mf_static, 35, 139},	//270 QGlobalSpace::operator>>(QDataStream&, QIcon&)
    {33, 129, 432, 2, Smoke::mf_static, 35, 140},	//271 QGlobalSpace::operator<<(QDataStream&, const QPolygon&)
    {33, 106, 286, 2, Smoke::mf_static, 131, 141},	//272 QGlobalSpace::operator*(const QTransform&, double)
    {33, 159, 435, 2, Smoke::mf_static, 79, 142},	//273 QGlobalSpace::operator|(Qt::TouchPointState, int)
    {33, 159, 438, 2, Smoke::mf_static, 46, 143},	//274 QGlobalSpace::operator|(KDialog::CaptionFlag, QFlags<KDialog::CaptionFlag>)
    {33, 159, 441, 2, Smoke::mf_static, 56, 144},	//275 QGlobalSpace::operator|(QWidget::RenderFlag, QFlags<QWidget::RenderFlag>)
    {33, 124, 289, 2, Smoke::mf_static, 214, 145},	//276 QGlobalSpace::operator<(const QStringRef&, const QStringRef&)
    {33, 101, 444, 2, Smoke::mf_static, 214, 146},	//277 QGlobalSpace::operator!=(const QStringRef&, const char*)
    {33, 101, 268, 2, Smoke::mf_static, 214, 147},	//278 QGlobalSpace::operator!=(const char*, const QByteArray&)
    {33, 145, 289, 2, Smoke::mf_static, 214, 148},	//279 QGlobalSpace::operator>(const QStringRef&, const QStringRef&)
    {33, 159, 447, 2, Smoke::mf_static, 79, 149},	//280 QGlobalSpace::operator|(KUrl::CleanPathOption, int)
    {33, 159, 450, 2, Smoke::mf_static, 51, 150},	//281 QGlobalSpace::operator|(KUrl::QueryItemsOption, KUrl::QueryItemsOption)
    {33, 159, 453, 2, Smoke::mf_static, 44, 151},	//282 QGlobalSpace::operator|(KConfigBase::WriteConfigFlag, KConfigBase::WriteConfigFlag)
    {33, 129, 456, 2, Smoke::mf_static, 35, 152},	//283 QGlobalSpace::operator<<(QDataStream&, const QLineF&)
    {33, 155, 459, 2, Smoke::mf_static, 35, 153},	//284 QGlobalSpace::operator>>(QDataStream&, QBrush&)
    {33, 129, 462, 2, Smoke::mf_static, 35, 154},	//285 QGlobalSpace::operator<<(QDataStream&, const QPointF&)
    {33, 106, 465, 2, Smoke::mf_static, 243, 155},	//286 QGlobalSpace::operator*(const QPoint&, float)
    {33, 110, 468, 2, Smoke::mf_static, 258, 156},	//287 QGlobalSpace::operator+(const QString&, const QString&)
    {33, 124, 265, 2, Smoke::mf_static, 214, 157},	//288 QGlobalSpace::operator<(const char*, const QString&)
    {33, 101, 265, 2, Smoke::mf_static, 214, 158},	//289 QGlobalSpace::operator!=(const char*, const QString&)
    {33, 101, 208, 2, Smoke::mf_static, 214, 159},	//290 QGlobalSpace::operator!=(const QByteArray&, const char*)
    {33, 101, 471, 2, Smoke::mf_static, 214, 160},	//291 QGlobalSpace::operator!=(const QString&, const QStringRef&)
    {33, 159, 474, 2, Smoke::mf_static, 79, 161},	//292 QGlobalSpace::operator|(KUrl::EqualsOption, int)
    {33, 159, 477, 2, Smoke::mf_static, 79, 162},	//293 QGlobalSpace::operator|(KDialog::CaptionFlag, int)
    {33, 159, 480, 2, Smoke::mf_static, 79, 163},	//294 QGlobalSpace::operator|(QSizePolicy::ControlType, int)
    {33, 155, 483, 2, Smoke::mf_static, 35, 164},	//295 QGlobalSpace::operator>>(QDataStream&, QSizePolicy&)
    {33, 145, 125, 2, Smoke::mf_static, 214, 165},	//296 QGlobalSpace::operator>(const QByteArray&, const QByteArray&)
    {33, 133, 119, 2, Smoke::mf_static, 214, 166},	//297 QGlobalSpace::operator<=(const char*, const QLatin1String&)
    {33, 140, 402, 2, Smoke::mf_static, 214, 167},	//298 QGlobalSpace::operator==(const QPoint&, const QPoint&)
    {33, 140, 486, 2, Smoke::mf_static, 214, 168},	//299 QGlobalSpace::operator==(const char*, const QStringRef&)
    {33, 110, 268, 2, Smoke::mf_static, 220, 169},	//300 QGlobalSpace::operator+(const char*, const QByteArray&)
    {33, 155, 489, 2, Smoke::mf_static, 35, 170},	//301 QGlobalSpace::operator>>(QDataStream&, QMatrix&)
    {33, 159, 492, 2, Smoke::mf_static, 79, 171},	//302 QGlobalSpace::operator|(Qt::MouseButton, int)
    {33, 133, 289, 2, Smoke::mf_static, 214, 172},	//303 QGlobalSpace::operator<=(const QStringRef&, const QStringRef&)
    {33, 155, 495, 2, Smoke::mf_static, 35, 173},	//304 QGlobalSpace::operator>>(QDataStream&, QSize&)
    {33, 159, 498, 2, Smoke::mf_static, 62, 174},	//305 QGlobalSpace::operator|(Qt::InputMethodHint, Qt::InputMethodHint)
    {33, 155, 501, 2, Smoke::mf_static, 35, 175},	//306 QGlobalSpace::operator>>(QDataStream&, QVariant::Type&)
    {33, 140, 292, 2, Smoke::mf_static, 214, 176},	//307 QGlobalSpace::operator==(QChar, QChar)
    {33, 159, 504, 2, Smoke::mf_static, 68, 177},	//308 QGlobalSpace::operator|(Qt::TextInteractionFlag, QFlags<Qt::TextInteractionFlag>)
    {33, 101, 414, 2, Smoke::mf_static, 214, 178},	//309 QGlobalSpace::operator!=(const QStringRef&, const QString&)
    {33, 106, 507, 2, Smoke::mf_static, 85, 179},	//310 QGlobalSpace::operator*(const QLineF&, const QTransform&)
    {33, 101, 510, 2, Smoke::mf_static, 214, 180},	//311 QGlobalSpace::operator!=(const QStringRef&, const QLatin1String&)
    {33, 129, 513, 2, Smoke::mf_static, 35, 181},	//312 QGlobalSpace::operator<<(QDataStream&, const QPolygonF&)
    {33, 129, 516, 2, Smoke::mf_static, 35, 182},	//313 QGlobalSpace::operator<<(QDataStream&, const QSizeF&)
    {33, 159, 519, 2, Smoke::mf_static, 69, 183},	//314 QGlobalSpace::operator|(Qt::ToolBarArea, QFlags<Qt::ToolBarArea>)
    {33, 129, 522, 2, Smoke::mf_static, 35, 184},	//315 QGlobalSpace::operator<<(QDataStream&, const QFont&)
    {33, 159, 525, 2, Smoke::mf_static, 50, 185},	//316 QGlobalSpace::operator|(KUrl::EqualsOption, QFlags<KUrl::EqualsOption>)
    {33, 129, 528, 2, Smoke::mf_static, 35, 186},	//317 QGlobalSpace::operator<<(QDataStream&, const QMatrix&)
    {33, 110, 531, 2, Smoke::mf_static, 258, 187},	//318 QGlobalSpace::operator+(char, const QString&)
    {33, 101, 128, 2, Smoke::mf_static, 214, 188},	//319 QGlobalSpace::operator!=(const QLatin1String&, const QStringRef&)
    {33, 101, 292, 2, Smoke::mf_static, 214, 189},	//320 QGlobalSpace::operator!=(QChar, QChar)
    {33, 140, 417, 2, Smoke::mf_static, 214, 190},	//321 QGlobalSpace::operator==(const QLatin1String&, const QLatin1String&)
    {33, 159, 534, 2, Smoke::mf_static, 71, 191},	//322 QGlobalSpace::operator|(Qt::WindowState, Qt::WindowState)
    {33, 159, 537, 2, Smoke::mf_static, 55, 192},	//323 QGlobalSpace::operator|(QUrl::FormattingOption, QFlags<QUrl::FormattingOption>)
    {33, 140, 122, 2, Smoke::mf_static, 214, 193},	//324 QGlobalSpace::operator==(const QSizeF&, const QSizeF&)
    {33, 155, 540, 2, Smoke::mf_static, 35, 194},	//325 QGlobalSpace::operator>>(QDataStream&, QPolygonF&)
    {33, 155, 543, 2, Smoke::mf_static, 35, 195},	//326 QGlobalSpace::operator>>(QDataStream&, QPalette&)
    {33, 129, 546, 2, Smoke::mf_static, 35, 196},	//327 QGlobalSpace::operator<<(QDataStream&, const QPainterPath&)
    {33, 140, 289, 2, Smoke::mf_static, 214, 197},	//328 QGlobalSpace::operator==(const QStringRef&, const QStringRef&)
    {33, 101, 549, 2, Smoke::mf_static, 214, 198},	//329 QGlobalSpace::operator!=(const QRectF&, const QRectF&)
    {33, 106, 552, 2, Smoke::mf_static, 253, 199},	//330 QGlobalSpace::operator*(double, const QSize&)
    {33, 150, 208, 2, Smoke::mf_static, 214, 200},	//331 QGlobalSpace::operator>=(const QByteArray&, const char*)
    {33, 106, 555, 2, Smoke::mf_static, 243, 201},	//332 QGlobalSpace::operator*(double, const QPoint&)
    {33, 129, 558, 2, Smoke::mf_static, 35, 202},	//333 QGlobalSpace::operator<<(QDataStream&, const QPoint&)
    {33, 129, 561, 2, Smoke::mf_static, 35, 203},	//334 QGlobalSpace::operator<<(QDataStream&, const QImage&)
    {33, 110, 564, 2, Smoke::mf_static, 220, 204},	//335 QGlobalSpace::operator+(const QByteArray&, char)
    {33, 122, 307, 2, Smoke::mf_static, 245, 205},	//336 QGlobalSpace::operator/(const QPointF&, double)
    {33, 150, 292, 2, Smoke::mf_static, 214, 206},	//337 QGlobalSpace::operator>=(QChar, QChar)
    {33, 133, 125, 2, Smoke::mf_static, 214, 207},	//338 QGlobalSpace::operator<=(const QByteArray&, const QByteArray&)
    {33, 155, 567, 2, Smoke::mf_static, 35, 208},	//339 QGlobalSpace::operator>>(QDataStream&, QFont&)
    {33, 133, 417, 2, Smoke::mf_static, 214, 209},	//340 QGlobalSpace::operator<=(const QLatin1String&, const QLatin1String&)
    {33, 159, 570, 2, Smoke::mf_static, 54, 210},	//341 QGlobalSpace::operator|(QString::SectionFlag, QFlags<QString::SectionFlag>)
    {33, 129, 573, 2, Smoke::mf_static, 35, 211},	//342 QGlobalSpace::operator<<(QDataStream&, const QSize&)
    {33, 145, 268, 2, Smoke::mf_static, 214, 212},	//343 QGlobalSpace::operator>(const char*, const QByteArray&)
    {33, 155, 576, 2, Smoke::mf_static, 35, 213},	//344 QGlobalSpace::operator>>(QDataStream&, QRectF&)
    {33, 129, 579, 2, Smoke::mf_static, 35, 214},	//345 QGlobalSpace::operator<<(QDataStream&, const QChar&)
    {33, 140, 549, 2, Smoke::mf_static, 214, 215},	//346 QGlobalSpace::operator==(const QRectF&, const QRectF&)
    {33, 101, 582, 2, Smoke::mf_static, 214, 216},	//347 QGlobalSpace::operator!=(bool, QBool)
    {33, 159, 585, 2, Smoke::mf_static, 51, 217},	//348 QGlobalSpace::operator|(KUrl::QueryItemsOption, QFlags<KUrl::QueryItemsOption>)
    {33, 106, 588, 2, Smoke::mf_static, 104, 218},	//349 QGlobalSpace::operator*(const QPolygon&, const QTransform&)
    {33, 101, 591, 2, Smoke::mf_static, 214, 219},	//350 QGlobalSpace::operator!=(QBool, bool)
    {33, 159, 594, 2, Smoke::mf_static, 79, 220},	//351 QGlobalSpace::operator|(Qt::WindowState, int)
    {33, 118, 402, 2, Smoke::mf_static, 243, 221},	//352 QGlobalSpace::operator-(const QPoint&, const QPoint&)
    {33, 155, 597, 2, Smoke::mf_static, 35, 222},	//353 QGlobalSpace::operator>>(QDataStream&, QStringList&)
    {33, 110, 208, 2, Smoke::mf_static, 220, 223},	//354 QGlobalSpace::operator+(const QByteArray&, const char*)
    {33, 129, 600, 2, Smoke::mf_static, 35, 224},	//355 QGlobalSpace::operator<<(QDataStream&, const QRect&)
    {33, 101, 122, 2, Smoke::mf_static, 214, 225},	//356 QGlobalSpace::operator!=(const QSizeF&, const QSizeF&)
    {33, 133, 268, 2, Smoke::mf_static, 214, 226},	//357 QGlobalSpace::operator<=(const char*, const QByteArray&)
    {33, 159, 603, 2, Smoke::mf_static, 79, 227},	//358 QGlobalSpace::operator|(KUrl::DirectoryOption, int)
    {33, 129, 606, 2, Smoke::mf_static, 35, 228},	//359 QGlobalSpace::operator<<(QDataStream&, const QRegion&)
    {33, 159, 609, 2, Smoke::mf_static, 58, 229},	//360 QGlobalSpace::operator|(Qt::DockWidgetArea, Qt::DockWidgetArea)
    {33, 140, 471, 2, Smoke::mf_static, 214, 230},	//361 QGlobalSpace::operator==(const QString&, const QStringRef&)
    {33, 101, 417, 2, Smoke::mf_static, 214, 231},	//362 QGlobalSpace::operator!=(const QLatin1String&, const QLatin1String&)
    {33, 129, 612, 2, Smoke::mf_static, 35, 232},	//363 QGlobalSpace::operator<<(QDataStream&, const QColor&)
    {33, 159, 615, 2, Smoke::mf_static, 72, 233},	//364 QGlobalSpace::operator|(Qt::WindowType, Qt::WindowType)
    {33, 106, 618, 2, Smoke::mf_static, 253, 234},	//365 QGlobalSpace::operator*(const QSize&, double)
    {33, 140, 621, 2, Smoke::mf_static, 214, 235},	//366 QGlobalSpace::operator==(QString::Null, const QString&)
    {33, 159, 624, 2, Smoke::mf_static, 62, 236},	//367 QGlobalSpace::operator|(Qt::InputMethodHint, QFlags<Qt::InputMethodHint>)
    {33, 155, 627, 2, Smoke::mf_static, 35, 237},	//368 QGlobalSpace::operator>>(QDataStream&, QPoint&)
    {33, 140, 208, 2, Smoke::mf_static, 214, 238},	//369 QGlobalSpace::operator==(const QByteArray&, const char*)
    {33, 155, 630, 2, Smoke::mf_static, 35, 239},	//370 QGlobalSpace::operator>>(QDataStream&, QDateTime&)
    {33, 145, 265, 2, Smoke::mf_static, 214, 240},	//371 QGlobalSpace::operator>(const char*, const QString&)
    {33, 129, 633, 2, Smoke::mf_static, 35, 241},	//372 QGlobalSpace::operator<<(QDataStream&, const QTime&)
    {33, 155, 636, 2, Smoke::mf_static, 35, 242},	//373 QGlobalSpace::operator>>(QDataStream&, QKeySequence&)
    {33, 145, 208, 2, Smoke::mf_static, 214, 243},	//374 QGlobalSpace::operator>(const QByteArray&, const char*)
    {33, 124, 119, 2, Smoke::mf_static, 214, 244},	//375 QGlobalSpace::operator<(const char*, const QLatin1String&)
    {33, 110, 402, 2, Smoke::mf_static, 243, 245},	//376 QGlobalSpace::operator+(const QPoint&, const QPoint&)
    {33, 133, 292, 2, Smoke::mf_static, 214, 246},	//377 QGlobalSpace::operator<=(QChar, QChar)
    {33, 106, 639, 2, Smoke::mf_static, 111, 247},	//378 QGlobalSpace::operator*(const QRegion&, const QTransform&)
    {33, 101, 621, 2, Smoke::mf_static, 214, 248},	//379 QGlobalSpace::operator!=(QString::Null, const QString&)
    {33, 145, 417, 2, Smoke::mf_static, 214, 249},	//380 QGlobalSpace::operator>(const QLatin1String&, const QLatin1String&)
    {33, 159, 642, 2, Smoke::mf_static, 54, 250},	//381 QGlobalSpace::operator|(QString::SectionFlag, QString::SectionFlag)
    {33, 101, 340, 2, Smoke::mf_static, 214, 251},	//382 QGlobalSpace::operator!=(const QString&, QString::Null)
    {33, 159, 645, 2, Smoke::mf_static, 79, 252},	//383 QGlobalSpace::operator|(QIODevice::OpenModeFlag, int)
    {33, 106, 648, 2, Smoke::mf_static, 243, 253},	//384 QGlobalSpace::operator*(int, const QPoint&)
    {33, 159, 651, 2, Smoke::mf_static, 60, 254},	//385 QGlobalSpace::operator|(Qt::GestureFlag, QFlags<Qt::GestureFlag>)
    {33, 106, 654, 2, Smoke::mf_static, 106, 255},	//386 QGlobalSpace::operator*(const QPolygonF&, const QMatrix&)
    {33, 118, 53, 1, Smoke::mf_static, 243, 256},	//387 QGlobalSpace::operator-(const QPoint&)
    {33, 155, 657, 2, Smoke::mf_static, 35, 257},	//388 QGlobalSpace::operator>>(QDataStream&, QPolygon&)
    {33, 159, 660, 2, Smoke::mf_static, 49, 258},	//389 QGlobalSpace::operator|(KUrl::EncodedPathAndQueryOption, QFlags<KUrl::EncodedPathAndQueryOption>)
    {33, 155, 663, 2, Smoke::mf_static, 35, 259},	//390 QGlobalSpace::operator>>(QDataStream&, QString&)
    {33, 140, 125, 2, Smoke::mf_static, 214, 260},	//391 QGlobalSpace::operator==(const QByteArray&, const QByteArray&)
    {33, 129, 666, 2, Smoke::mf_static, 35, 261},	//392 QGlobalSpace::operator<<(QDataStream&, const QString&)
    {33, 118, 283, 2, Smoke::mf_static, 245, 262},	//393 QGlobalSpace::operator-(const QPointF&, const QPointF&)
    {33, 124, 417, 2, Smoke::mf_static, 214, 263},	//394 QGlobalSpace::operator<(const QLatin1String&, const QLatin1String&)
    {33, 155, 669, 2, Smoke::mf_static, 35, 264},	//395 QGlobalSpace::operator>>(QDataStream&, QChar&)
    {33, 110, 286, 2, Smoke::mf_static, 131, 265},	//396 QGlobalSpace::operator+(const QTransform&, double)
    {33, 159, 672, 2, Smoke::mf_static, 68, 266},	//397 QGlobalSpace::operator|(Qt::TextInteractionFlag, Qt::TextInteractionFlag)
    {33, 140, 444, 2, Smoke::mf_static, 214, 267},	//398 QGlobalSpace::operator==(const QStringRef&, const char*)
    {33, 101, 486, 2, Smoke::mf_static, 214, 268},	//399 QGlobalSpace::operator!=(const char*, const QStringRef&)
    {33, 155, 675, 2, Smoke::mf_static, 35, 269},	//400 QGlobalSpace::operator>>(QDataStream&, QPixmap&)
    {33, 110, 125, 2, Smoke::mf_static, 220, 270},	//401 QGlobalSpace::operator+(const QByteArray&, const QByteArray&)
    {33, 159, 678, 2, Smoke::mf_static, 44, 271},	//402 QGlobalSpace::operator|(KConfigBase::WriteConfigFlag, QFlags<KConfigBase::WriteConfigFlag>)
    {33, 110, 681, 2, Smoke::mf_static, 258, 272},	//403 QGlobalSpace::operator+(const QString&, const QByteArray&)
    {33, 155, 684, 2, Smoke::mf_static, 35, 273},	//404 QGlobalSpace::operator>>(QDataStream&, QRect&)
    {33, 159, 687, 2, Smoke::mf_static, 79, 274},	//405 QGlobalSpace::operator|(Qt::ImageConversionFlag, int)
    {33, 140, 265, 2, Smoke::mf_static, 214, 275},	//406 QGlobalSpace::operator==(const char*, const QString&)
    {33, 129, 690, 2, Smoke::mf_static, 35, 276},	//407 QGlobalSpace::operator<<(QDataStream&, const QIcon&)
    {33, 129, 693, 2, Smoke::mf_static, 35, 277},	//408 QGlobalSpace::operator<<(QDataStream&, const QVariant::Type)
    {33, 122, 618, 2, Smoke::mf_static, 253, 278},	//409 QGlobalSpace::operator/(const QSize&, double)
    {33, 155, 696, 2, Smoke::mf_static, 35, 279},	//410 QGlobalSpace::operator>>(QDataStream&, QLineF&)
    {33, 155, 699, 2, Smoke::mf_static, 35, 280},	//411 QGlobalSpace::operator>>(QDataStream&, QPainterPath&)
    {33, 140, 582, 2, Smoke::mf_static, 214, 281},	//412 QGlobalSpace::operator==(bool, QBool)
    {33, 159, 702, 2, Smoke::mf_static, 70, 282},	//413 QGlobalSpace::operator|(Qt::TouchPointState, Qt::TouchPointState)
    {33, 159, 705, 2, Smoke::mf_static, 79, 283},	//414 QGlobalSpace::operator|(Qt::TextInteractionFlag, int)
    {33, 106, 708, 2, Smoke::mf_static, 100, 284},	//415 QGlobalSpace::operator*(const QPoint&, const QTransform&)
    {33, 150, 265, 2, Smoke::mf_static, 214, 285},	//416 QGlobalSpace::operator>=(const char*, const QString&)
    {33, 129, 711, 2, Smoke::mf_static, 35, 286},	//417 QGlobalSpace::operator<<(QDataStream&, const QDateTime&)
    {33, 155, 714, 2, Smoke::mf_static, 35, 287},	//418 QGlobalSpace::operator>>(QDataStream&, QTime&)
    {33, 101, 283, 2, Smoke::mf_static, 214, 288},	//419 QGlobalSpace::operator!=(const QPointF&, const QPointF&)
    {33, 106, 717, 2, Smoke::mf_static, 243, 289},	//420 QGlobalSpace::operator*(const QPoint&, int)
    {33, 159, 720, 2, Smoke::mf_static, 61, 290},	//421 QGlobalSpace::operator|(Qt::ImageConversionFlag, Qt::ImageConversionFlag)
    {33, 118, 98, 2, Smoke::mf_static, 253, 291},	//422 QGlobalSpace::operator-(const QSize&, const QSize&)
    {33, 159, 723, 2, Smoke::mf_static, 59, 292},	//423 QGlobalSpace::operator|(Qt::DropAction, QFlags<Qt::DropAction>)
    {33, 159, 726, 2, Smoke::mf_static, 59, 293},	//424 QGlobalSpace::operator|(Qt::DropAction, Qt::DropAction)
    {33, 159, 729, 2, Smoke::mf_static, 79, 294},	//425 QGlobalSpace::operator|(Qt::Orientation, int)
    {33, 101, 119, 2, Smoke::mf_static, 214, 295},	//426 QGlobalSpace::operator!=(const char*, const QLatin1String&)
    {33, 110, 283, 2, Smoke::mf_static, 245, 296},	//427 QGlobalSpace::operator+(const QPointF&, const QPointF&)
    {33, 106, 732, 2, Smoke::mf_static, 111, 297},	//428 QGlobalSpace::operator*(const QRegion&, const QMatrix&)
    {33, 140, 591, 2, Smoke::mf_static, 214, 298},	//429 QGlobalSpace::operator==(QBool, bool)
    {33, 140, 95, 2, Smoke::mf_static, 214, 299},	//430 QGlobalSpace::operator==(const QRect&, const QRect&)
    {33, 106, 735, 2, Smoke::mf_static, 243, 300},	//431 QGlobalSpace::operator*(float, const QPoint&)
    {33, 155, 738, 2, Smoke::mf_static, 35, 301},	//432 QGlobalSpace::operator>>(QDataStream&, QUrl&)
    {33, 110, 741, 2, Smoke::mf_static, 258, 302},	//433 QGlobalSpace::operator+(const QString&, QChar)
    {33, 101, 152, 2, Smoke::mf_static, 214, 303},	//434 QGlobalSpace::operator!=(QString::Null, QString::Null)
    {33, 159, 744, 2, Smoke::mf_static, 67, 304},	//435 QGlobalSpace::operator|(Qt::Orientation, QFlags<Qt::Orientation>)
    {33, 101, 143, 2, Smoke::mf_static, 214, 305},	//436 QGlobalSpace::operator!=(QBool, QBool)
    {33, 140, 510, 2, Smoke::mf_static, 214, 306},	//437 QGlobalSpace::operator==(const QStringRef&, const QLatin1String&)
    {33, 118, 286, 2, Smoke::mf_static, 131, 307},	//438 QGlobalSpace::operator-(const QTransform&, double)
    {33, 115, 747, 2, Smoke::mf_static, 7, 308},	//439 QGlobalSpace::operator++(KIconLoader::Group&, int)
    {50, 73, 65, 2, Smoke::mf_virtual, 214, 0},	//440 QObject::eventFilter(QObject*, QEvent*)
    {50, 208, 57, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//441 QObject::timerEvent(QTimerEvent*)
    {50, 55, 750, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//442 QObject::childEvent(QChildEvent*)
    {50, 59, 55, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//443 QObject::customEvent(QEvent*)
    {50, 57, 14, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//444 QObject::connectNotify(const char*)
    {50, 63, 14, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//445 QObject::disconnectNotify(const char*)
    {60, 93, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 115, 0},	//446 QPushButton::minimumSizeHint() const
    {60, 72, 55, 1, Smoke::mf_protected|Smoke::mf_virtual, 214, 0},	//447 QPushButton::event(QEvent*)
    {60, 86, 10, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//448 QPushButton::keyPressEvent(QKeyEvent*)
    {60, 74, 752, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//449 QPushButton::focusInEvent(QFocusEvent*)
    {60, 76, 752, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//450 QPushButton::focusOutEvent(QFocusEvent*)
    {81, 60, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 273, 0},	//451 QWidget::devType() const
    {81, 197, 45, 1, Smoke::mf_property|Smoke::mf_virtual|Smoke::mf_slot, 0, 0},	//452 QWidget::setVisible(bool)
    {81, 78, 12, 1, Smoke::mf_const|Smoke::mf_virtual, 273, 0},	//453 QWidget::heightForWidth(int) const
    {81, 161, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 94, 0},	//454 QWidget::paintEngine() const
    {81, 72, 55, 1, Smoke::mf_protected|Smoke::mf_virtual, 214, 0},	//455 QWidget::event(QEvent*)
    {81, 96, 49, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//456 QWidget::mousePressEvent(QMouseEvent*)
    {81, 97, 49, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//457 QWidget::mouseReleaseEvent(QMouseEvent*)
    {81, 94, 49, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//458 QWidget::mouseDoubleClickEvent(QMouseEvent*)
    {81, 95, 49, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//459 QWidget::mouseMoveEvent(QMouseEvent*)
    {81, 219, 754, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//460 QWidget::wheelEvent(QWheelEvent*)
    {81, 87, 10, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//461 QWidget::keyReleaseEvent(QKeyEvent*)
    {81, 74, 752, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//462 QWidget::focusInEvent(QFocusEvent*)
    {81, 76, 752, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//463 QWidget::focusOutEvent(QFocusEvent*)
    {81, 71, 55, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//464 QWidget::enterEvent(QEvent*)
    {81, 89, 55, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//465 QWidget::leaveEvent(QEvent*)
    {81, 162, 51, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//466 QWidget::paintEvent(QPaintEvent*)
    {81, 98, 756, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//467 QWidget::moveEvent(QMoveEvent*)
    {81, 170, 61, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//468 QWidget::resizeEvent(QResizeEvent*)
    {81, 56, 8, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//469 QWidget::closeEvent(QCloseEvent*)
    {81, 58, 63, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//470 QWidget::contextMenuEvent(QContextMenuEvent*)
    {81, 207, 758, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//471 QWidget::tabletEvent(QTabletEvent*)
    {81, 50, 760, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//472 QWidget::actionEvent(QActionEvent*)
    {81, 65, 762, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//473 QWidget::dragEnterEvent(QDragEnterEvent*)
    {81, 67, 764, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//474 QWidget::dragMoveEvent(QDragMoveEvent*)
    {81, 66, 766, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//475 QWidget::dragLeaveEvent(QDragLeaveEvent*)
    {81, 69, 768, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//476 QWidget::dropEvent(QDropEvent*)
    {81, 199, 59, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//477 QWidget::showEvent(QShowEvent*)
    {81, 79, 6, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//478 QWidget::hideEvent(QHideEvent*)
    {81, 221, 770, 1, Smoke::mf_protected|Smoke::mf_virtual, 214, 0},	//479 QWidget::x11Event(_XEvent*)
    {81, 52, 55, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//480 QWidget::changeEvent(QEvent*)
    {81, 92, 772, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 273, 0},	//481 QWidget::metric(QPaintDevice::PaintDeviceMetric) const
    {81, 82, 774, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//482 QWidget::inputMethodEvent(QInputMethodEvent*)
    {81, 83, 776, 1, Smoke::mf_const|Smoke::mf_virtual, 135, 0},	//483 QWidget::inputMethodQuery(Qt::InputMethodQuery) const
    {81, 75, 45, 1, Smoke::mf_protected|Smoke::mf_virtual, 214, 0},	//484 QWidget::focusNextPrevChild(bool)
    {81, 205, 778, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//485 QWidget::styleChange(QStyle&)
    {81, 70, 45, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//486 QWidget::enabledChange(bool)
    {81, 163, 780, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//487 QWidget::paletteChange(const QPalette&)
    {81, 77, 782, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//488 QWidget::fontChange(const QFont&)
    {81, 220, 45, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//489 QWidget::windowActivationChange(bool)
    {81, 88, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//490 QWidget::languageChange()
    {81, 19, 0, 0, Smoke::mf_static|Smoke::mf_enum, 140, 41},	//491 QWidget::DrawWindowBackground (enum)
    {81, 18, 0, 0, Smoke::mf_static|Smoke::mf_enum, 140, 42},	//492 QWidget::DrawChildren (enum)
    {81, 24, 0, 0, Smoke::mf_static|Smoke::mf_enum, 140, 43},	//493 QWidget::IgnoreMask (enum)
};

static Smoke::Index ambiguousMethodList[] = {
    0,
    136,  // QGlobalSpace::operator!=(const QMargins&, const QMargins&)
    141,  // QGlobalSpace::operator!=(const QRect&, const QRect&)
    157,  // QGlobalSpace::operator!=(const QVariant&, const QVariantComparisonHelper&)
    210,  // QGlobalSpace::operator!=(const QStringRef&, const QStringRef&)
    224,  // QGlobalSpace::operator!=(const QByteArray&, const QByteArray&)
    258,  // QGlobalSpace::operator!=(const QSize&, const QSize&)
    261,  // QGlobalSpace::operator!=(const QPoint&, const QPoint&)
    311,  // QGlobalSpace::operator!=(const QStringRef&, const QLatin1String&)
    319,  // QGlobalSpace::operator!=(const QLatin1String&, const QStringRef&)
    320,  // QGlobalSpace::operator!=(QChar, QChar)
    329,  // QGlobalSpace::operator!=(const QRectF&, const QRectF&)
    356,  // QGlobalSpace::operator!=(const QSizeF&, const QSizeF&)
    362,  // QGlobalSpace::operator!=(const QLatin1String&, const QLatin1String&)
    419,  // QGlobalSpace::operator!=(const QPointF&, const QPointF&)
    434,  // QGlobalSpace::operator!=(QString::Null, QString::Null)
    436,  // QGlobalSpace::operator!=(QBool, QBool)
    0,
    277,  // QGlobalSpace::operator!=(const QStringRef&, const char*)
    290,  // QGlobalSpace::operator!=(const QByteArray&, const char*)
    309,  // QGlobalSpace::operator!=(const QStringRef&, const QString&)
    350,  // QGlobalSpace::operator!=(QBool, bool)
    379,  // QGlobalSpace::operator!=(QString::Null, const QString&)
    0,
    278,  // QGlobalSpace::operator!=(const char*, const QByteArray&)
    291,  // QGlobalSpace::operator!=(const QString&, const QStringRef&)
    347,  // QGlobalSpace::operator!=(bool, QBool)
    382,  // QGlobalSpace::operator!=(const QString&, QString::Null)
    399,  // QGlobalSpace::operator!=(const char*, const QStringRef&)
    426,  // QGlobalSpace::operator!=(const char*, const QLatin1String&)
    0,
    144,  // QGlobalSpace::operator*(const QPointF&, const QMatrix&)
    145,  // QGlobalSpace::operator*(const QLine&, const QTransform&)
    169,  // QGlobalSpace::operator*(const QPolygonF&, const QTransform&)
    185,  // QGlobalSpace::operator*(const QLine&, const QMatrix&)
    187,  // QGlobalSpace::operator*(const QLineF&, const QMatrix&)
    189,  // QGlobalSpace::operator*(const QPainterPath&, const QMatrix&)
    212,  // QGlobalSpace::operator*(const QPainterPath&, const QTransform&)
    231,  // QGlobalSpace::operator*(const QPolygon&, const QMatrix&)
    242,  // QGlobalSpace::operator*(const QPointF&, const QTransform&)
    255,  // QGlobalSpace::operator*(const QPoint&, const QMatrix&)
    310,  // QGlobalSpace::operator*(const QLineF&, const QTransform&)
    349,  // QGlobalSpace::operator*(const QPolygon&, const QTransform&)
    378,  // QGlobalSpace::operator*(const QRegion&, const QTransform&)
    386,  // QGlobalSpace::operator*(const QPolygonF&, const QMatrix&)
    415,  // QGlobalSpace::operator*(const QPoint&, const QTransform&)
    428,  // QGlobalSpace::operator*(const QRegion&, const QMatrix&)
    0,
    133,  // QGlobalSpace::operator*(const QPoint&, double)
    148,  // QGlobalSpace::operator*(const QSizeF&, double)
    217,  // QGlobalSpace::operator*(const QPointF&, double)
    272,  // QGlobalSpace::operator*(const QTransform&, double)
    286,  // QGlobalSpace::operator*(const QPoint&, float)
    365,  // QGlobalSpace::operator*(const QSize&, double)
    420,  // QGlobalSpace::operator*(const QPoint&, int)
    0,
    134,  // QGlobalSpace::operator*(double, const QPointF&)
    137,  // QGlobalSpace::operator*(double, const QSizeF&)
    330,  // QGlobalSpace::operator*(double, const QSize&)
    332,  // QGlobalSpace::operator*(double, const QPoint&)
    384,  // QGlobalSpace::operator*(int, const QPoint&)
    431,  // QGlobalSpace::operator*(float, const QPoint&)
    0,
    142,  // QGlobalSpace::operator+(const QSize&, const QSize&)
    172,  // QGlobalSpace::operator+(const QSizeF&, const QSizeF&)
    376,  // QGlobalSpace::operator+(const QPoint&, const QPoint&)
    401,  // QGlobalSpace::operator+(const QByteArray&, const QByteArray&)
    427,  // QGlobalSpace::operator+(const QPointF&, const QPointF&)
    0,
    163,  // QGlobalSpace::operator+(QChar, const QString&)
    240,  // QGlobalSpace::operator+(const QByteArray&, const QString&)
    335,  // QGlobalSpace::operator+(const QByteArray&, char)
    354,  // QGlobalSpace::operator+(const QByteArray&, const char*)
    396,  // QGlobalSpace::operator+(const QTransform&, double)
    0,
    199,  // QGlobalSpace::operator+(char, const QByteArray&)
    300,  // QGlobalSpace::operator+(const char*, const QByteArray&)
    403,  // QGlobalSpace::operator+(const QString&, const QByteArray&)
    433,  // QGlobalSpace::operator+(const QString&, QChar)
    0,
    194,  // QGlobalSpace::operator+(const QString&, const char*)
    201,  // QGlobalSpace::operator+(const char*, const QString&)
    245,  // QGlobalSpace::operator+(const QString&, char)
    287,  // QGlobalSpace::operator+(const QString&, const QString&)
    318,  // QGlobalSpace::operator+(char, const QString&)
    0,
    237,  // QGlobalSpace::operator-(const QPointF&)
    387,  // QGlobalSpace::operator-(const QPoint&)
    0,
    151,  // QGlobalSpace::operator-(const QSizeF&, const QSizeF&)
    352,  // QGlobalSpace::operator-(const QPoint&, const QPoint&)
    393,  // QGlobalSpace::operator-(const QPointF&, const QPointF&)
    422,  // QGlobalSpace::operator-(const QSize&, const QSize&)
    0,
    200,  // QGlobalSpace::operator/(const QPoint&, double)
    208,  // QGlobalSpace::operator/(const QTransform&, double)
    228,  // QGlobalSpace::operator/(const QSizeF&, double)
    336,  // QGlobalSpace::operator/(const QPointF&, double)
    409,  // QGlobalSpace::operator/(const QSize&, double)
    0,
    211,  // QGlobalSpace::operator<(QChar, QChar)
    235,  // QGlobalSpace::operator<(const QByteArray&, const QByteArray&)
    276,  // QGlobalSpace::operator<(const QStringRef&, const QStringRef&)
    394,  // QGlobalSpace::operator<(const QLatin1String&, const QLatin1String&)
    0,
    253,  // QGlobalSpace::operator<(const char*, const QByteArray&)
    375,  // QGlobalSpace::operator<(const char*, const QLatin1String&)
    0,
    139,  // QGlobalSpace::operator<<(QDataStream&, const QSizePolicy&)
    143,  // QGlobalSpace::operator<<(QDataStream&, const QTransform&)
    149,  // QGlobalSpace::operator<<(QDataStream&, const QLine&)
    162,  // QGlobalSpace::operator<<(QDataStream&, const QRectF&)
    166,  // QGlobalSpace::operator<<(QDataStream&, const QPalette&)
    168,  // QGlobalSpace::operator<<(QDataStream&, const QByteArray&)
    179,  // QGlobalSpace::operator<<(QDataStream&, const QRegExp&)
    192,  // QGlobalSpace::operator<<(QDataStream&, const QKeySequence&)
    195,  // QGlobalSpace::operator<<(QDataStream&, const QCursor&)
    213,  // QGlobalSpace::operator<<(QDataStream&, const QBrush&)
    220,  // QGlobalSpace::operator<<(QDataStream&, const QDate&)
    239,  // QGlobalSpace::operator<<(QDataStream&, const QPixmap&)
    248,  // QGlobalSpace::operator<<(QDataStream&, const QUrl&)
    250,  // QGlobalSpace::operator<<(QDataStream&, const QVariant&)
    271,  // QGlobalSpace::operator<<(QDataStream&, const QPolygon&)
    283,  // QGlobalSpace::operator<<(QDataStream&, const QLineF&)
    285,  // QGlobalSpace::operator<<(QDataStream&, const QPointF&)
    312,  // QGlobalSpace::operator<<(QDataStream&, const QPolygonF&)
    313,  // QGlobalSpace::operator<<(QDataStream&, const QSizeF&)
    315,  // QGlobalSpace::operator<<(QDataStream&, const QFont&)
    317,  // QGlobalSpace::operator<<(QDataStream&, const QMatrix&)
    327,  // QGlobalSpace::operator<<(QDataStream&, const QPainterPath&)
    333,  // QGlobalSpace::operator<<(QDataStream&, const QPoint&)
    334,  // QGlobalSpace::operator<<(QDataStream&, const QImage&)
    342,  // QGlobalSpace::operator<<(QDataStream&, const QSize&)
    345,  // QGlobalSpace::operator<<(QDataStream&, const QChar&)
    355,  // QGlobalSpace::operator<<(QDataStream&, const QRect&)
    359,  // QGlobalSpace::operator<<(QDataStream&, const QRegion&)
    363,  // QGlobalSpace::operator<<(QDataStream&, const QColor&)
    372,  // QGlobalSpace::operator<<(QDataStream&, const QTime&)
    407,  // QGlobalSpace::operator<<(QDataStream&, const QIcon&)
    417,  // QGlobalSpace::operator<<(QDataStream&, const QDateTime&)
    0,
    392,  // QGlobalSpace::operator<<(QDataStream&, const QString&)
    408,  // QGlobalSpace::operator<<(QDataStream&, const QVariant::Type)
    0,
    303,  // QGlobalSpace::operator<=(const QStringRef&, const QStringRef&)
    338,  // QGlobalSpace::operator<=(const QByteArray&, const QByteArray&)
    340,  // QGlobalSpace::operator<=(const QLatin1String&, const QLatin1String&)
    377,  // QGlobalSpace::operator<=(QChar, QChar)
    0,
    297,  // QGlobalSpace::operator<=(const char*, const QLatin1String&)
    357,  // QGlobalSpace::operator<=(const char*, const QByteArray&)
    0,
    146,  // QGlobalSpace::operator==(const QMargins&, const QMargins&)
    153,  // QGlobalSpace::operator==(const QLatin1String&, const QStringRef&)
    158,  // QGlobalSpace::operator==(QBool, QBool)
    161,  // QGlobalSpace::operator==(QString::Null, QString::Null)
    207,  // QGlobalSpace::operator==(const QPointF&, const QPointF&)
    219,  // QGlobalSpace::operator==(const QSize&, const QSize&)
    247,  // QGlobalSpace::operator==(const QVariant&, const QVariantComparisonHelper&)
    267,  // QGlobalSpace::operator==(const QHashDummyValue&, const QHashDummyValue&)
    298,  // QGlobalSpace::operator==(const QPoint&, const QPoint&)
    307,  // QGlobalSpace::operator==(QChar, QChar)
    321,  // QGlobalSpace::operator==(const QLatin1String&, const QLatin1String&)
    324,  // QGlobalSpace::operator==(const QSizeF&, const QSizeF&)
    328,  // QGlobalSpace::operator==(const QStringRef&, const QStringRef&)
    346,  // QGlobalSpace::operator==(const QRectF&, const QRectF&)
    391,  // QGlobalSpace::operator==(const QByteArray&, const QByteArray&)
    430,  // QGlobalSpace::operator==(const QRect&, const QRect&)
    437,  // QGlobalSpace::operator==(const QStringRef&, const QLatin1String&)
    0,
    265,  // QGlobalSpace::operator==(const QStringRef&, const QString&)
    366,  // QGlobalSpace::operator==(QString::Null, const QString&)
    369,  // QGlobalSpace::operator==(const QByteArray&, const char*)
    398,  // QGlobalSpace::operator==(const QStringRef&, const char*)
    429,  // QGlobalSpace::operator==(QBool, bool)
    0,
    202,  // QGlobalSpace::operator==(const char*, const QByteArray&)
    221,  // QGlobalSpace::operator==(const char*, const QLatin1String&)
    234,  // QGlobalSpace::operator==(const QString&, QString::Null)
    299,  // QGlobalSpace::operator==(const char*, const QStringRef&)
    361,  // QGlobalSpace::operator==(const QString&, const QStringRef&)
    412,  // QGlobalSpace::operator==(bool, QBool)
    0,
    232,  // QGlobalSpace::operator>(QChar, QChar)
    279,  // QGlobalSpace::operator>(const QStringRef&, const QStringRef&)
    296,  // QGlobalSpace::operator>(const QByteArray&, const QByteArray&)
    380,  // QGlobalSpace::operator>(const QLatin1String&, const QLatin1String&)
    0,
    150,  // QGlobalSpace::operator>(const char*, const QLatin1String&)
    343,  // QGlobalSpace::operator>(const char*, const QByteArray&)
    0,
    152,  // QGlobalSpace::operator>=(const QByteArray&, const QByteArray&)
    246,  // QGlobalSpace::operator>=(const QStringRef&, const QStringRef&)
    266,  // QGlobalSpace::operator>=(const QLatin1String&, const QLatin1String&)
    337,  // QGlobalSpace::operator>=(QChar, QChar)
    0,
    214,  // QGlobalSpace::operator>=(const char*, const QLatin1String&)
    233,  // QGlobalSpace::operator>=(const char*, const QByteArray&)
    0,
    138,  // QGlobalSpace::operator>>(QDataStream&, QImage&)
    178,  // QGlobalSpace::operator>>(QDataStream&, QColor&)
    191,  // QGlobalSpace::operator>>(QDataStream&, QPointF&)
    197,  // QGlobalSpace::operator>>(QDataStream&, QDate&)
    203,  // QGlobalSpace::operator>>(QDataStream&, QByteArray&)
    204,  // QGlobalSpace::operator>>(QDataStream&, QVariant&)
    206,  // QGlobalSpace::operator>>(QDataStream&, QRegExp&)
    216,  // QGlobalSpace::operator>>(QDataStream&, QRegion&)
    226,  // QGlobalSpace::operator>>(QDataStream&, QCursor&)
    230,  // QGlobalSpace::operator>>(QDataStream&, QTransform&)
    236,  // QGlobalSpace::operator>>(QDataStream&, QSizeF&)
    251,  // QGlobalSpace::operator>>(QDataStream&, QLine&)
    270,  // QGlobalSpace::operator>>(QDataStream&, QIcon&)
    284,  // QGlobalSpace::operator>>(QDataStream&, QBrush&)
    295,  // QGlobalSpace::operator>>(QDataStream&, QSizePolicy&)
    301,  // QGlobalSpace::operator>>(QDataStream&, QMatrix&)
    304,  // QGlobalSpace::operator>>(QDataStream&, QSize&)
    325,  // QGlobalSpace::operator>>(QDataStream&, QPolygonF&)
    326,  // QGlobalSpace::operator>>(QDataStream&, QPalette&)
    339,  // QGlobalSpace::operator>>(QDataStream&, QFont&)
    344,  // QGlobalSpace::operator>>(QDataStream&, QRectF&)
    368,  // QGlobalSpace::operator>>(QDataStream&, QPoint&)
    370,  // QGlobalSpace::operator>>(QDataStream&, QDateTime&)
    373,  // QGlobalSpace::operator>>(QDataStream&, QKeySequence&)
    388,  // QGlobalSpace::operator>>(QDataStream&, QPolygon&)
    395,  // QGlobalSpace::operator>>(QDataStream&, QChar&)
    400,  // QGlobalSpace::operator>>(QDataStream&, QPixmap&)
    404,  // QGlobalSpace::operator>>(QDataStream&, QRect&)
    410,  // QGlobalSpace::operator>>(QDataStream&, QLineF&)
    411,  // QGlobalSpace::operator>>(QDataStream&, QPainterPath&)
    418,  // QGlobalSpace::operator>>(QDataStream&, QTime&)
    432,  // QGlobalSpace::operator>>(QDataStream&, QUrl&)
    0,
    306,  // QGlobalSpace::operator>>(QDataStream&, QVariant::Type&)
    390,  // QGlobalSpace::operator>>(QDataStream&, QString&)
    0,
    132,  // QGlobalSpace::operator|(Qt::DockWidgetArea, int)
    135,  // QGlobalSpace::operator|(Qt::MouseButton, QFlags<Qt::MouseButton>)
    140,  // QGlobalSpace::operator|(Qt::InputMethodHint, int)
    147,  // QGlobalSpace::operator|(Qt::WindowState, QFlags<Qt::WindowState>)
    154,  // QGlobalSpace::operator|(Qt::MouseButton, Qt::MouseButton)
    155,  // QGlobalSpace::operator|(KUrl::CleanPathOption, QFlags<KUrl::CleanPathOption>)
    156,  // QGlobalSpace::operator|(KUrl::CleanPathOption, KUrl::CleanPathOption)
    159,  // QGlobalSpace::operator|(KConfigBase::WriteConfigFlag, int)
    160,  // QGlobalSpace::operator|(Qt::AlignmentFlag, QFlags<Qt::AlignmentFlag>)
    164,  // QGlobalSpace::operator|(KDialog::ButtonCode, KDialog::ButtonCode)
    165,  // QGlobalSpace::operator|(QIODevice::OpenModeFlag, QFlags<QIODevice::OpenModeFlag>)
    170,  // QGlobalSpace::operator|(Qt::ToolBarArea, Qt::ToolBarArea)
    171,  // QGlobalSpace::operator|(KUrl::QueryItemsOption, int)
    173,  // QGlobalSpace::operator|(QWidget::RenderFlag, int)
    174,  // QGlobalSpace::operator|(Qt::DropAction, int)
    176,  // QGlobalSpace::operator|(KUrl::EncodedPathAndQueryOption, KUrl::EncodedPathAndQueryOption)
    177,  // QGlobalSpace::operator|(Qt::AlignmentFlag, Qt::AlignmentFlag)
    180,  // QGlobalSpace::operator|(QUrl::FormattingOption, int)
    182,  // QGlobalSpace::operator|(KUrl::DirectoryOption, KUrl::DirectoryOption)
    183,  // QGlobalSpace::operator|(Qt::DockWidgetArea, QFlags<Qt::DockWidgetArea>)
    184,  // QGlobalSpace::operator|(KDialog::CaptionFlag, KDialog::CaptionFlag)
    186,  // QGlobalSpace::operator|(KUrl::DirectoryOption, QFlags<KUrl::DirectoryOption>)
    188,  // QGlobalSpace::operator|(Qt::Orientation, Qt::Orientation)
    190,  // QGlobalSpace::operator|(Qt::ToolBarArea, int)
    193,  // QGlobalSpace::operator|(Qt::MatchFlag, int)
    196,  // QGlobalSpace::operator|(Qt::GestureFlag, Qt::GestureFlag)
    198,  // QGlobalSpace::operator|(QIODevice::OpenModeFlag, QIODevice::OpenModeFlag)
    205,  // QGlobalSpace::operator|(KDialog::ButtonCode, int)
    215,  // QGlobalSpace::operator|(KDialog::ButtonCode, QFlags<KDialog::ButtonCode>)
    218,  // QGlobalSpace::operator|(KUrl::EncodedPathAndQueryOption, int)
    222,  // QGlobalSpace::operator|(Qt::MatchFlag, QFlags<Qt::MatchFlag>)
    223,  // QGlobalSpace::operator|(Qt::GestureFlag, int)
    225,  // QGlobalSpace::operator|(QSizePolicy::ControlType, QSizePolicy::ControlType)
    227,  // QGlobalSpace::operator|(Qt::KeyboardModifier, QFlags<Qt::KeyboardModifier>)
    229,  // QGlobalSpace::operator|(Qt::MatchFlag, Qt::MatchFlag)
    238,  // QGlobalSpace::operator|(Qt::ItemFlag, Qt::ItemFlag)
    241,  // QGlobalSpace::operator|(Qt::WindowType, QFlags<Qt::WindowType>)
    243,  // QGlobalSpace::operator|(Qt::ItemFlag, QFlags<Qt::ItemFlag>)
    244,  // QGlobalSpace::operator|(Qt::TouchPointState, QFlags<Qt::TouchPointState>)
    249,  // QGlobalSpace::operator|(QSizePolicy::ControlType, QFlags<QSizePolicy::ControlType>)
    252,  // QGlobalSpace::operator|(Qt::KeyboardModifier, Qt::KeyboardModifier)
    254,  // QGlobalSpace::operator|(Qt::AlignmentFlag, int)
    256,  // QGlobalSpace::operator|(Qt::KeyboardModifier, int)
    257,  // QGlobalSpace::operator|(Qt::ItemFlag, int)
    259,  // QGlobalSpace::operator|(Qt::ImageConversionFlag, QFlags<Qt::ImageConversionFlag>)
    262,  // QGlobalSpace::operator|(QString::SectionFlag, int)
    263,  // QGlobalSpace::operator|(Qt::WindowType, int)
    264,  // QGlobalSpace::operator|(QWidget::RenderFlag, QWidget::RenderFlag)
    268,  // QGlobalSpace::operator|(KUrl::EqualsOption, KUrl::EqualsOption)
    269,  // QGlobalSpace::operator|(QUrl::FormattingOption, QUrl::FormattingOption)
    273,  // QGlobalSpace::operator|(Qt::TouchPointState, int)
    274,  // QGlobalSpace::operator|(KDialog::CaptionFlag, QFlags<KDialog::CaptionFlag>)
    275,  // QGlobalSpace::operator|(QWidget::RenderFlag, QFlags<QWidget::RenderFlag>)
    280,  // QGlobalSpace::operator|(KUrl::CleanPathOption, int)
    281,  // QGlobalSpace::operator|(KUrl::QueryItemsOption, KUrl::QueryItemsOption)
    282,  // QGlobalSpace::operator|(KConfigBase::WriteConfigFlag, KConfigBase::WriteConfigFlag)
    292,  // QGlobalSpace::operator|(KUrl::EqualsOption, int)
    293,  // QGlobalSpace::operator|(KDialog::CaptionFlag, int)
    294,  // QGlobalSpace::operator|(QSizePolicy::ControlType, int)
    302,  // QGlobalSpace::operator|(Qt::MouseButton, int)
    305,  // QGlobalSpace::operator|(Qt::InputMethodHint, Qt::InputMethodHint)
    308,  // QGlobalSpace::operator|(Qt::TextInteractionFlag, QFlags<Qt::TextInteractionFlag>)
    314,  // QGlobalSpace::operator|(Qt::ToolBarArea, QFlags<Qt::ToolBarArea>)
    316,  // QGlobalSpace::operator|(KUrl::EqualsOption, QFlags<KUrl::EqualsOption>)
    322,  // QGlobalSpace::operator|(Qt::WindowState, Qt::WindowState)
    323,  // QGlobalSpace::operator|(QUrl::FormattingOption, QFlags<QUrl::FormattingOption>)
    341,  // QGlobalSpace::operator|(QString::SectionFlag, QFlags<QString::SectionFlag>)
    348,  // QGlobalSpace::operator|(KUrl::QueryItemsOption, QFlags<KUrl::QueryItemsOption>)
    351,  // QGlobalSpace::operator|(Qt::WindowState, int)
    358,  // QGlobalSpace::operator|(KUrl::DirectoryOption, int)
    360,  // QGlobalSpace::operator|(Qt::DockWidgetArea, Qt::DockWidgetArea)
    364,  // QGlobalSpace::operator|(Qt::WindowType, Qt::WindowType)
    367,  // QGlobalSpace::operator|(Qt::InputMethodHint, QFlags<Qt::InputMethodHint>)
    381,  // QGlobalSpace::operator|(QString::SectionFlag, QString::SectionFlag)
    383,  // QGlobalSpace::operator|(QIODevice::OpenModeFlag, int)
    385,  // QGlobalSpace::operator|(Qt::GestureFlag, QFlags<Qt::GestureFlag>)
    389,  // QGlobalSpace::operator|(KUrl::EncodedPathAndQueryOption, QFlags<KUrl::EncodedPathAndQueryOption>)
    397,  // QGlobalSpace::operator|(Qt::TextInteractionFlag, Qt::TextInteractionFlag)
    402,  // QGlobalSpace::operator|(KConfigBase::WriteConfigFlag, QFlags<KConfigBase::WriteConfigFlag>)
    405,  // QGlobalSpace::operator|(Qt::ImageConversionFlag, int)
    413,  // QGlobalSpace::operator|(Qt::TouchPointState, Qt::TouchPointState)
    414,  // QGlobalSpace::operator|(Qt::TextInteractionFlag, int)
    421,  // QGlobalSpace::operator|(Qt::ImageConversionFlag, Qt::ImageConversionFlag)
    423,  // QGlobalSpace::operator|(Qt::DropAction, QFlags<Qt::DropAction>)
    424,  // QGlobalSpace::operator|(Qt::DropAction, Qt::DropAction)
    425,  // QGlobalSpace::operator|(Qt::Orientation, int)
    435,  // QGlobalSpace::operator|(Qt::Orientation, QFlags<Qt::Orientation>)
    0,
};

// Class ID, munged name ID (index into methodNames), method def (see methods) if >0 or number of overloads if <0
static Smoke::MethodMap methodMaps[] = {
    {0, 0, 0},	//0 (no method)
    {4, 5, 38},	// KNS3::Button::Button#
    {4, 6, 37},	// KNS3::Button::Button$$#
    {4, 48, 41},	// KNS3::Button::aboutToShowDialog
    {4, 62, 42},	// KNS3::Button::dialogFinished?
    {4, 91, 30},	// KNS3::Button::metaObject
    {4, 166, 36},	// KNS3::Button::qt_metacall$$?
    {4, 168, 31},	// KNS3::Button::qt_metacast$
    {4, 174, 40},	// KNS3::Button::setButtonText$
    {4, 179, 39},	// KNS3::Button::setConfigFile$
    {4, 198, 43},	// KNS3::Button::showDialog
    {4, 203, 46},	// KNS3::Button::staticMetaObject
    {4, 210, 44},	// KNS3::Button::tr$
    {4, 211, 32},	// KNS3::Button::tr$$
    {4, 212, 34},	// KNS3::Button::tr$$$
    {4, 214, 45},	// KNS3::Button::trUtf8$
    {4, 215, 33},	// KNS3::Button::trUtf8$$
    {4, 216, 35},	// KNS3::Button::trUtf8$$$
    {4, 222, 47},	// KNS3::Button::~Button
    {5, 13, 61},	// KNS3::DownloadDialog::DownloadDialog
    {5, 14, 55},	// KNS3::DownloadDialog::DownloadDialog#
    {5, 15, 62},	// KNS3::DownloadDialog::DownloadDialog$
    {5, 16, 56},	// KNS3::DownloadDialog::DownloadDialog$#
    {5, 53, 57},	// KNS3::DownloadDialog::changedEntries
    {5, 84, 58},	// KNS3::DownloadDialog::installedEntries
    {5, 91, 48},	// KNS3::DownloadDialog::metaObject
    {5, 166, 54},	// KNS3::DownloadDialog::qt_metacall$$?
    {5, 168, 49},	// KNS3::DownloadDialog::qt_metacast$
    {5, 203, 63},	// KNS3::DownloadDialog::staticMetaObject
    {5, 210, 59},	// KNS3::DownloadDialog::tr$
    {5, 211, 50},	// KNS3::DownloadDialog::tr$$
    {5, 212, 52},	// KNS3::DownloadDialog::tr$$$
    {5, 214, 60},	// KNS3::DownloadDialog::trUtf8$
    {5, 215, 51},	// KNS3::DownloadDialog::trUtf8$$
    {5, 216, 53},	// KNS3::DownloadDialog::trUtf8$$$
    {5, 223, 64},	// KNS3::DownloadDialog::~DownloadDialog
    {6, 11, 81},	// KNS3::Entry::Deleted
    {6, 17, 78},	// KNS3::Entry::Downloadable
    {6, 21, 65},	// KNS3::Entry::Entry#
    {6, 25, 79},	// KNS3::Entry::Installed
    {6, 26, 82},	// KNS3::Entry::Installing
    {6, 28, 77},	// KNS3::Entry::Invalid
    {6, 38, 80},	// KNS3::Entry::Updateable
    {6, 39, 83},	// KNS3::Entry::Updating
    {6, 51, 68},	// KNS3::Entry::category
    {6, 81, 75},	// KNS3::Entry::id
    {6, 85, 69},	// KNS3::Entry::installedFiles
    {6, 90, 72},	// KNS3::Entry::license
    {6, 99, 67},	// KNS3::Entry::name
    {6, 139, 66},	// KNS3::Entry::operator=#
    {6, 164, 76},	// KNS3::Entry::providerId
    {6, 204, 71},	// KNS3::Entry::status
    {6, 206, 73},	// KNS3::Entry::summary
    {6, 217, 70},	// KNS3::Entry::uninstalledFiles
    {6, 218, 74},	// KNS3::Entry::version
    {6, 224, 84},	// KNS3::Entry::~Entry
    {7, 40, 107},	// KNS3::UploadDialog::UploadDialog
    {7, 41, 92},	// KNS3::UploadDialog::UploadDialog#
    {7, 42, 108},	// KNS3::UploadDialog::UploadDialog$
    {7, 43, 93},	// KNS3::UploadDialog::UploadDialog$#
    {7, 49, 104},	// KNS3::UploadDialog::accept
    {7, 91, 85},	// KNS3::UploadDialog::metaObject
    {7, 166, 91},	// KNS3::UploadDialog::qt_metacall$$?
    {7, 168, 86},	// KNS3::UploadDialog::qt_metacast$
    {7, 172, 103},	// KNS3::UploadDialog::selectCategory$
    {7, 177, 98},	// KNS3::UploadDialog::setChangelog$
    {7, 181, 97},	// KNS3::UploadDialog::setDescription$
    {7, 184, 99},	// KNS3::UploadDialog::setPreviewImageFile$#
    {7, 186, 101},	// KNS3::UploadDialog::setPrice$
    {7, 188, 100},	// KNS3::UploadDialog::setPriceEnabled$
    {7, 190, 102},	// KNS3::UploadDialog::setPriceReason$
    {7, 192, 94},	// KNS3::UploadDialog::setUploadFile#
    {7, 194, 95},	// KNS3::UploadDialog::setUploadName$
    {7, 196, 96},	// KNS3::UploadDialog::setVersion$
    {7, 203, 109},	// KNS3::UploadDialog::staticMetaObject
    {7, 210, 105},	// KNS3::UploadDialog::tr$
    {7, 211, 87},	// KNS3::UploadDialog::tr$$
    {7, 212, 89},	// KNS3::UploadDialog::tr$$$
    {7, 214, 106},	// KNS3::UploadDialog::trUtf8$
    {7, 215, 88},	// KNS3::UploadDialog::trUtf8$$
    {7, 216, 90},	// KNS3::UploadDialog::trUtf8$$$
    {7, 225, 110},	// KNS3::UploadDialog::~UploadDialog
    {33, 102, -1},	// QGlobalSpace::operator!=##
    {33, 103, -18},	// QGlobalSpace::operator!=#$
    {33, 104, -24},	// QGlobalSpace::operator!=$#
    {33, 105, 289},	// QGlobalSpace::operator!=$$
    {33, 107, -31},	// QGlobalSpace::operator*##
    {33, 108, -48},	// QGlobalSpace::operator*#$
    {33, 109, -56},	// QGlobalSpace::operator*$#
    {33, 111, -63},	// QGlobalSpace::operator+##
    {33, 112, -69},	// QGlobalSpace::operator+#$
    {33, 113, -75},	// QGlobalSpace::operator+$#
    {33, 114, -80},	// QGlobalSpace::operator+$$
    {33, 116, 167},	// QGlobalSpace::operator++$
    {33, 117, 439},	// QGlobalSpace::operator++$$
    {33, 119, -86},	// QGlobalSpace::operator-#
    {33, 120, -89},	// QGlobalSpace::operator-##
    {33, 121, 438},	// QGlobalSpace::operator-#$
    {33, 123, -94},	// QGlobalSpace::operator/#$
    {33, 125, -100},	// QGlobalSpace::operator<##
    {33, 126, 181},	// QGlobalSpace::operator<#$
    {33, 127, -105},	// QGlobalSpace::operator<$#
    {33, 128, 288},	// QGlobalSpace::operator<$$
    {33, 130, -108},	// QGlobalSpace::operator<<##
    {33, 131, -141},	// QGlobalSpace::operator<<#$
    {33, 132, 175},	// QGlobalSpace::operator<<#?
    {33, 134, -144},	// QGlobalSpace::operator<=##
    {33, 135, 260},	// QGlobalSpace::operator<=#$
    {33, 136, -149},	// QGlobalSpace::operator<=$#
    {33, 137, 209},	// QGlobalSpace::operator<=$$
    {33, 141, -152},	// QGlobalSpace::operator==##
    {33, 142, -170},	// QGlobalSpace::operator==#$
    {33, 143, -176},	// QGlobalSpace::operator==$#
    {33, 144, 406},	// QGlobalSpace::operator==$$
    {33, 146, -183},	// QGlobalSpace::operator>##
    {33, 147, 374},	// QGlobalSpace::operator>#$
    {33, 148, -188},	// QGlobalSpace::operator>$#
    {33, 149, 371},	// QGlobalSpace::operator>$$
    {33, 151, -191},	// QGlobalSpace::operator>=##
    {33, 152, 331},	// QGlobalSpace::operator>=#$
    {33, 153, -196},	// QGlobalSpace::operator>=$#
    {33, 154, 416},	// QGlobalSpace::operator>=$$
    {33, 156, -199},	// QGlobalSpace::operator>>##
    {33, 157, -232},	// QGlobalSpace::operator>>#$
    {33, 158, 353},	// QGlobalSpace::operator>>#?
    {33, 160, -235},	// QGlobalSpace::operator|$$
};

}

extern "C" {

SMOKE_IMPORT void init_kdeui_Smoke();

static bool initialized = false;
Smoke *knewstuff3_Smoke = 0;

// Create the Smoke instance encapsulating all the above.
void init_knewstuff3_Smoke() {
    init_kdeui_Smoke();
    if (initialized) return;
    knewstuff3_Smoke = new Smoke(
        "knewstuff3",
        __smokeknewstuff3::classes, 81,
        __smokeknewstuff3::methods, 494,
        __smokeknewstuff3::methodMaps, 126,
        __smokeknewstuff3::methodNames, 225,
        __smokeknewstuff3::types, 277,
        __smokeknewstuff3::inheritanceList,
        __smokeknewstuff3::argumentList,
        __smokeknewstuff3::ambiguousMethodList,
        __smokeknewstuff3::cast );
    initialized = true;
}

void delete_knewstuff3_Smoke() { delete knewstuff3_Smoke; }

}
