#include <kdecore_includes.h>

#include <smoke.h>
#include <kdecore_smoke.h>

namespace __smokekdecore {

static void *cast(void *xptr, Smoke::Index from, Smoke::Index to) {
  switch(from) {
    case 1:   //KAboutData
      switch(to) {
        case 1: return (void*)(KAboutData*)xptr;
        default: return xptr;
      }
    case 2:   //KAboutLicense
      switch(to) {
        case 2: return (void*)(KAboutLicense*)xptr;
        default: return xptr;
      }
    case 3:   //KAboutPerson
      switch(to) {
        case 3: return (void*)(KAboutPerson*)xptr;
        default: return xptr;
      }
    case 4:   //KAuth::Action
      switch(to) {
        case 4: return (void*)(KAuth::Action*)xptr;
        default: return xptr;
      }
    case 5:   //KAuth::ActionReply
      switch(to) {
        case 5: return (void*)(KAuth::ActionReply*)xptr;
        default: return xptr;
      }
    case 6:   //KAuth::ActionWatcher
      switch(to) {
        case 158: return (void*)(QObject*)(KAuth::ActionWatcher*)xptr;
        case 6: return (void*)(KAuth::ActionWatcher*)xptr;
        default: return xptr;
      }
    case 8:   //KAutoSaveFile
      switch(to) {
        case 147: return (void*)(QFile*)(KAutoSaveFile*)xptr;
        case 151: return (void*)(QIODevice*)(KAutoSaveFile*)xptr;
        case 158: return (void*)(QObject*)(KAutoSaveFile*)xptr;
        case 8: return (void*)(KAutoSaveFile*)xptr;
        default: return xptr;
      }
    case 9:   //KAutostart
      switch(to) {
        case 158: return (void*)(QObject*)(KAutostart*)xptr;
        case 9: return (void*)(KAutostart*)xptr;
        default: return xptr;
      }
    case 10:   //KCalendarSystem
      switch(to) {
        case 10: return (void*)(KCalendarSystem*)xptr;
        default: return xptr;
      }
    case 11:   //KCalendarSystemPrivate
      switch(to) {
        case 11: return (void*)(KCalendarSystemPrivate*)xptr;
        default: return xptr;
      }
    case 12:   //KCatalogName
      switch(to) {
        case 12: return (void*)(KCatalogName*)xptr;
        default: return xptr;
      }
    case 13:   //KCharMacroExpander
      switch(to) {
        case 76: return (void*)(KMacroExpanderBase*)(KCharMacroExpander*)xptr;
        case 13: return (void*)(KCharMacroExpander*)xptr;
        default: return xptr;
      }
    case 14:   //KCharsets
      switch(to) {
        case 14: return (void*)(KCharsets*)xptr;
        default: return xptr;
      }
    case 15:   //KCmdLineArgs
      switch(to) {
        case 15: return (void*)(KCmdLineArgs*)xptr;
        default: return xptr;
      }
    case 16:   //KCmdLineOptions
      switch(to) {
        case 16: return (void*)(KCmdLineOptions*)xptr;
        default: return xptr;
      }
    case 18:   //KComponentData
      switch(to) {
        case 18: return (void*)(KComponentData*)xptr;
        default: return xptr;
      }
    case 19:   //KCompositeJob
      switch(to) {
        case 63: return (void*)(KJob*)(KCompositeJob*)xptr;
        case 158: return (void*)(QObject*)(KCompositeJob*)xptr;
        case 19: return (void*)(KCompositeJob*)xptr;
        default: return xptr;
      }
    case 20:   //KCompositeJobPrivate
      switch(to) {
        case 20: return (void*)(KCompositeJobPrivate*)xptr;
        default: return xptr;
      }
    case 21:   //KConfig
      switch(to) {
        case 22: return (void*)(KConfigBase*)(KConfig*)xptr;
        case 21: return (void*)(KConfig*)xptr;
        case 57: return (void*)(KDesktopFile*)(KConfig*)xptr;
        case 100: return (void*)(KSharedConfig*)(KConfig*)xptr;
        default: return xptr;
      }
    case 22:   //KConfigBase
      switch(to) {
        case 22: return (void*)(KConfigBase*)xptr;
        case 23: return (void*)(KConfigGroup*)(KConfigBase*)xptr;
        case 21: return (void*)(KConfig*)(KConfigBase*)xptr;
        case 57: return (void*)(KDesktopFile*)(KConfigBase*)xptr;
        case 100: return (void*)(KSharedConfig*)(KConfigBase*)xptr;
        default: return xptr;
      }
    case 23:   //KConfigGroup
      switch(to) {
        case 22: return (void*)(KConfigBase*)(KConfigGroup*)xptr;
        case 23: return (void*)(KConfigGroup*)xptr;
        default: return xptr;
      }
    case 24:   //KConfigPrivate
      switch(to) {
        case 24: return (void*)(KConfigPrivate*)xptr;
        default: return xptr;
      }
    case 25:   //KConfigSkeletonItem
      switch(to) {
        case 25: return (void*)(KConfigSkeletonItem*)xptr;
        default: return xptr;
      }
    case 26:   //KCoreConfigSkeleton
      switch(to) {
        case 158: return (void*)(QObject*)(KCoreConfigSkeleton*)xptr;
        case 26: return (void*)(KCoreConfigSkeleton*)xptr;
        default: return xptr;
      }
    case 27:   //KCoreConfigSkeleton::ItemBool
      switch(to) {
        case 27: return (void*)(KCoreConfigSkeleton::ItemBool*)xptr;
        default: return xptr;
      }
    case 28:   //KCoreConfigSkeleton::ItemDateTime
      switch(to) {
        case 28: return (void*)(KCoreConfigSkeleton::ItemDateTime*)xptr;
        default: return xptr;
      }
    case 29:   //KCoreConfigSkeleton::ItemDouble
      switch(to) {
        case 29: return (void*)(KCoreConfigSkeleton::ItemDouble*)xptr;
        default: return xptr;
      }
    case 30:   //KCoreConfigSkeleton::ItemEnum
      switch(to) {
        case 33: return (void*)(KCoreConfigSkeleton::ItemInt*)(KCoreConfigSkeleton::ItemEnum*)xptr;
        case 30: return (void*)(KCoreConfigSkeleton::ItemEnum*)xptr;
        default: return xptr;
      }
    case 31:   //KCoreConfigSkeleton::ItemEnum::Choice
      switch(to) {
        case 31: return (void*)(KCoreConfigSkeleton::ItemEnum::Choice*)xptr;
        default: return xptr;
      }
    case 32:   //KCoreConfigSkeleton::ItemEnum::Choice2
      switch(to) {
        case 32: return (void*)(KCoreConfigSkeleton::ItemEnum::Choice2*)xptr;
        default: return xptr;
      }
    case 33:   //KCoreConfigSkeleton::ItemInt
      switch(to) {
        case 33: return (void*)(KCoreConfigSkeleton::ItemInt*)xptr;
        case 30: return (void*)(KCoreConfigSkeleton::ItemEnum*)(KCoreConfigSkeleton::ItemInt*)xptr;
        default: return xptr;
      }
    case 34:   //KCoreConfigSkeleton::ItemIntList
      switch(to) {
        case 34: return (void*)(KCoreConfigSkeleton::ItemIntList*)xptr;
        default: return xptr;
      }
    case 35:   //KCoreConfigSkeleton::ItemLongLong
      switch(to) {
        case 35: return (void*)(KCoreConfigSkeleton::ItemLongLong*)xptr;
        default: return xptr;
      }
    case 36:   //KCoreConfigSkeleton::ItemPassword
      switch(to) {
        case 43: return (void*)(KCoreConfigSkeleton::ItemString*)(KCoreConfigSkeleton::ItemPassword*)xptr;
        case 36: return (void*)(KCoreConfigSkeleton::ItemPassword*)xptr;
        default: return xptr;
      }
    case 37:   //KCoreConfigSkeleton::ItemPath
      switch(to) {
        case 43: return (void*)(KCoreConfigSkeleton::ItemString*)(KCoreConfigSkeleton::ItemPath*)xptr;
        case 37: return (void*)(KCoreConfigSkeleton::ItemPath*)xptr;
        default: return xptr;
      }
    case 38:   //KCoreConfigSkeleton::ItemPathList
      switch(to) {
        case 44: return (void*)(KCoreConfigSkeleton::ItemStringList*)(KCoreConfigSkeleton::ItemPathList*)xptr;
        case 38: return (void*)(KCoreConfigSkeleton::ItemPathList*)xptr;
        default: return xptr;
      }
    case 39:   //KCoreConfigSkeleton::ItemPoint
      switch(to) {
        case 39: return (void*)(KCoreConfigSkeleton::ItemPoint*)xptr;
        default: return xptr;
      }
    case 40:   //KCoreConfigSkeleton::ItemProperty
      switch(to) {
        case 40: return (void*)(KCoreConfigSkeleton::ItemProperty*)xptr;
        default: return xptr;
      }
    case 41:   //KCoreConfigSkeleton::ItemRect
      switch(to) {
        case 41: return (void*)(KCoreConfigSkeleton::ItemRect*)xptr;
        default: return xptr;
      }
    case 42:   //KCoreConfigSkeleton::ItemSize
      switch(to) {
        case 42: return (void*)(KCoreConfigSkeleton::ItemSize*)xptr;
        default: return xptr;
      }
    case 43:   //KCoreConfigSkeleton::ItemString
      switch(to) {
        case 43: return (void*)(KCoreConfigSkeleton::ItemString*)xptr;
        case 37: return (void*)(KCoreConfigSkeleton::ItemPath*)(KCoreConfigSkeleton::ItemString*)xptr;
        case 36: return (void*)(KCoreConfigSkeleton::ItemPassword*)(KCoreConfigSkeleton::ItemString*)xptr;
        default: return xptr;
      }
    case 44:   //KCoreConfigSkeleton::ItemStringList
      switch(to) {
        case 44: return (void*)(KCoreConfigSkeleton::ItemStringList*)xptr;
        case 38: return (void*)(KCoreConfigSkeleton::ItemPathList*)(KCoreConfigSkeleton::ItemStringList*)xptr;
        default: return xptr;
      }
    case 45:   //KCoreConfigSkeleton::ItemUInt
      switch(to) {
        case 45: return (void*)(KCoreConfigSkeleton::ItemUInt*)xptr;
        default: return xptr;
      }
    case 46:   //KCoreConfigSkeleton::ItemULongLong
      switch(to) {
        case 46: return (void*)(KCoreConfigSkeleton::ItemULongLong*)xptr;
        default: return xptr;
      }
    case 47:   //KCoreConfigSkeleton::ItemUrl
      switch(to) {
        case 47: return (void*)(KCoreConfigSkeleton::ItemUrl*)xptr;
        default: return xptr;
      }
    case 48:   //KCoreConfigSkeleton::ItemUrlList
      switch(to) {
        case 48: return (void*)(KCoreConfigSkeleton::ItemUrlList*)xptr;
        default: return xptr;
      }
    case 49:   //KCurrencyCode
      switch(to) {
        case 49: return (void*)(KCurrencyCode*)xptr;
        default: return xptr;
      }
    case 51:   //KDEDModule
      switch(to) {
        case 158: return (void*)(QObject*)(KDEDModule*)xptr;
        case 51: return (void*)(KDEDModule*)xptr;
        default: return xptr;
      }
    case 52:   //KDEPluginVerificationData
      switch(to) {
        case 52: return (void*)(KDEPluginVerificationData*)xptr;
        default: return xptr;
      }
    case 53:   //KDateTime
      switch(to) {
        case 53: return (void*)(KDateTime*)xptr;
        default: return xptr;
      }
    case 54:   //KDateTime::Spec
      switch(to) {
        case 54: return (void*)(KDateTime::Spec*)xptr;
        default: return xptr;
      }
    case 55:   //KDebug
      switch(to) {
        case 55: return (void*)(KDebug*)xptr;
        default: return xptr;
      }
    case 56:   //KDebugTag
      switch(to) {
        case 56: return (void*)(KDebugTag*)xptr;
        default: return xptr;
      }
    case 57:   //KDesktopFile
      switch(to) {
        case 21: return (void*)(KConfig*)(KDesktopFile*)xptr;
        case 22: return (void*)(KConfigBase*)(KDesktopFile*)xptr;
        case 57: return (void*)(KDesktopFile*)xptr;
        default: return xptr;
      }
    case 58:   //KEncodingDetector
      switch(to) {
        case 58: return (void*)(KEncodingDetector*)xptr;
        default: return xptr;
      }
    case 59:   //KEncodingProber
      switch(to) {
        case 59: return (void*)(KEncodingProber*)xptr;
        default: return xptr;
      }
    case 60:   //KFilterBase
      switch(to) {
        case 60: return (void*)(KFilterBase*)xptr;
        default: return xptr;
      }
    case 61:   //KFilterDev
      switch(to) {
        case 151: return (void*)(QIODevice*)(KFilterDev*)xptr;
        case 158: return (void*)(QObject*)(KFilterDev*)xptr;
        case 61: return (void*)(KFilterDev*)xptr;
        default: return xptr;
      }
    case 63:   //KJob
      switch(to) {
        case 158: return (void*)(QObject*)(KJob*)xptr;
        case 63: return (void*)(KJob*)xptr;
        case 19: return (void*)(KCompositeJob*)(KJob*)xptr;
        default: return xptr;
      }
    case 64:   //KJobPrivate
      switch(to) {
        case 64: return (void*)(KJobPrivate*)xptr;
        default: return xptr;
      }
    case 65:   //KJobTrackerInterface
      switch(to) {
        case 158: return (void*)(QObject*)(KJobTrackerInterface*)xptr;
        case 65: return (void*)(KJobTrackerInterface*)xptr;
        default: return xptr;
      }
    case 66:   //KJobUiDelegate
      switch(to) {
        case 158: return (void*)(QObject*)(KJobUiDelegate*)xptr;
        case 66: return (void*)(KJobUiDelegate*)xptr;
        default: return xptr;
      }
    case 67:   //KLibLoader
      switch(to) {
        case 158: return (void*)(QObject*)(KLibLoader*)xptr;
        case 67: return (void*)(KLibLoader*)xptr;
        default: return xptr;
      }
    case 68:   //KLibrary
      switch(to) {
        case 154: return (void*)(QLibrary*)(KLibrary*)xptr;
        case 158: return (void*)(QObject*)(KLibrary*)xptr;
        case 68: return (void*)(KLibrary*)xptr;
        default: return xptr;
      }
    case 69:   //KLocalSocket
      switch(to) {
        case 167: return (void*)(QTcpSocket*)(KLocalSocket*)xptr;
        case 134: return (void*)(QAbstractSocket*)(KLocalSocket*)xptr;
        case 151: return (void*)(QIODevice*)(KLocalSocket*)xptr;
        case 158: return (void*)(QObject*)(KLocalSocket*)xptr;
        case 69: return (void*)(KLocalSocket*)xptr;
        default: return xptr;
      }
    case 70:   //KLocalSocketServer
      switch(to) {
        case 158: return (void*)(QObject*)(KLocalSocketServer*)xptr;
        case 70: return (void*)(KLocalSocketServer*)xptr;
        default: return xptr;
      }
    case 71:   //KLocale
      switch(to) {
        case 71: return (void*)(KLocale*)xptr;
        default: return xptr;
      }
    case 72:   //KLocalizedString
      switch(to) {
        case 72: return (void*)(KLocalizedString*)xptr;
        default: return xptr;
      }
    case 73:   //KLockFile
      switch(to) {
        case 164: return (void*)(QSharedData*)(KLockFile*)xptr;
        case 73: return (void*)(KLockFile*)xptr;
        default: return xptr;
      }
    case 74:   //KMD5
      switch(to) {
        case 74: return (void*)(KMD5*)xptr;
        default: return xptr;
      }
    case 76:   //KMacroExpanderBase
      switch(to) {
        case 76: return (void*)(KMacroExpanderBase*)xptr;
        case 13: return (void*)(KCharMacroExpander*)(KMacroExpanderBase*)xptr;
        case 131: return (void*)(KWordMacroExpander*)(KMacroExpanderBase*)xptr;
        default: return xptr;
      }
    case 78:   //KMessageHandler
      switch(to) {
        case 78: return (void*)(KMessageHandler*)xptr;
        default: return xptr;
      }
    case 79:   //KMimeType
      switch(to) {
        case 97: return (void*)(KServiceType*)(KMimeType*)xptr;
        case 106: return (void*)(KSycocaEntry*)(KMimeType*)xptr;
        case 164: return (void*)(QSharedData*)(KMimeType*)xptr;
        case 79: return (void*)(KMimeType*)xptr;
        default: return xptr;
      }
    case 80:   //KMimeTypePrivate
      switch(to) {
        case 80: return (void*)(KMimeTypePrivate*)xptr;
        default: return xptr;
      }
    case 81:   //KMimeTypeTrader
      switch(to) {
        case 81: return (void*)(KMimeTypeTrader*)xptr;
        default: return xptr;
      }
    case 82:   //KParts::Part
      switch(to) {
        case 82: return (void*)(KParts::Part*)xptr;
        default: return xptr;
      }
    case 83:   //KPluginFactory
      switch(to) {
        case 158: return (void*)(QObject*)(KPluginFactory*)xptr;
        case 83: return (void*)(KPluginFactory*)xptr;
        default: return xptr;
      }
    case 84:   //KPluginFactoryPrivate
      switch(to) {
        case 84: return (void*)(KPluginFactoryPrivate*)xptr;
        default: return xptr;
      }
    case 85:   //KPluginInfo
      switch(to) {
        case 85: return (void*)(KPluginInfo*)xptr;
        default: return xptr;
      }
    case 86:   //KPluginLoader
      switch(to) {
        case 159: return (void*)(QPluginLoader*)(KPluginLoader*)xptr;
        case 158: return (void*)(QObject*)(KPluginLoader*)xptr;
        case 86: return (void*)(KPluginLoader*)xptr;
        default: return xptr;
      }
    case 87:   //KProcess
      switch(to) {
        case 161: return (void*)(QProcess*)(KProcess*)xptr;
        case 151: return (void*)(QIODevice*)(KProcess*)xptr;
        case 158: return (void*)(QObject*)(KProcess*)xptr;
        case 87: return (void*)(KProcess*)xptr;
        default: return xptr;
      }
    case 88:   //KProcessPrivate
      switch(to) {
        case 88: return (void*)(KProcessPrivate*)xptr;
        default: return xptr;
      }
    case 89:   //KProtocolInfo
      switch(to) {
        case 106: return (void*)(KSycocaEntry*)(KProtocolInfo*)xptr;
        case 164: return (void*)(QSharedData*)(KProtocolInfo*)xptr;
        case 89: return (void*)(KProtocolInfo*)xptr;
        default: return xptr;
      }
    case 90:   //KProtocolInfo::ExtraField
      switch(to) {
        case 90: return (void*)(KProtocolInfo::ExtraField*)xptr;
        default: return xptr;
      }
    case 92:   //KRandomSequence
      switch(to) {
        case 92: return (void*)(KRandomSequence*)xptr;
        default: return xptr;
      }
    case 93:   //KSaveFile
      switch(to) {
        case 147: return (void*)(QFile*)(KSaveFile*)xptr;
        case 151: return (void*)(QIODevice*)(KSaveFile*)xptr;
        case 158: return (void*)(QObject*)(KSaveFile*)xptr;
        case 93: return (void*)(KSaveFile*)xptr;
        default: return xptr;
      }
    case 94:   //KService
      switch(to) {
        case 106: return (void*)(KSycocaEntry*)(KService*)xptr;
        case 164: return (void*)(QSharedData*)(KService*)xptr;
        case 94: return (void*)(KService*)xptr;
        default: return xptr;
      }
    case 95:   //KServiceAction
      switch(to) {
        case 95: return (void*)(KServiceAction*)xptr;
        default: return xptr;
      }
    case 96:   //KServiceGroup
      switch(to) {
        case 106: return (void*)(KSycocaEntry*)(KServiceGroup*)xptr;
        case 164: return (void*)(QSharedData*)(KServiceGroup*)xptr;
        case 96: return (void*)(KServiceGroup*)xptr;
        default: return xptr;
      }
    case 97:   //KServiceType
      switch(to) {
        case 106: return (void*)(KSycocaEntry*)(KServiceType*)xptr;
        case 164: return (void*)(QSharedData*)(KServiceType*)xptr;
        case 97: return (void*)(KServiceType*)xptr;
        case 79: return (void*)(KMimeType*)(KServiceType*)xptr;
        default: return xptr;
      }
    case 98:   //KServiceTypePrivate
      switch(to) {
        case 98: return (void*)(KServiceTypePrivate*)xptr;
        default: return xptr;
      }
    case 99:   //KServiceTypeTrader
      switch(to) {
        case 99: return (void*)(KServiceTypeTrader*)xptr;
        default: return xptr;
      }
    case 100:   //KSharedConfig
      switch(to) {
        case 21: return (void*)(KConfig*)(KSharedConfig*)xptr;
        case 22: return (void*)(KConfigBase*)(KSharedConfig*)xptr;
        case 164: return (void*)(QSharedData*)(KSharedConfig*)xptr;
        case 100: return (void*)(KSharedConfig*)xptr;
        default: return xptr;
      }
    case 103:   //KStandardDirs
      switch(to) {
        case 103: return (void*)(KStandardDirs*)xptr;
        default: return xptr;
      }
    case 105:   //KSycoca
      switch(to) {
        case 158: return (void*)(QObject*)(KSycoca*)xptr;
        case 105: return (void*)(KSycoca*)xptr;
        default: return xptr;
      }
    case 106:   //KSycocaEntry
      switch(to) {
        case 164: return (void*)(QSharedData*)(KSycocaEntry*)xptr;
        case 106: return (void*)(KSycocaEntry*)xptr;
        case 89: return (void*)(KProtocolInfo*)(KSycocaEntry*)xptr;
        case 97: return (void*)(KServiceType*)(KSycocaEntry*)xptr;
        case 94: return (void*)(KService*)(KSycocaEntry*)xptr;
        case 96: return (void*)(KServiceGroup*)(KSycocaEntry*)xptr;
        case 79: return (void*)(KMimeType*)(KSycocaEntry*)xptr;
        default: return xptr;
      }
    case 107:   //KSycocaEntryPrivate
      switch(to) {
        case 107: return (void*)(KSycocaEntryPrivate*)xptr;
        default: return xptr;
      }
    case 108:   //KSycocaFactory
      switch(to) {
        case 108: return (void*)(KSycocaFactory*)xptr;
        default: return xptr;
      }
    case 109:   //KSycocaFactoryList
      switch(to) {
        case 109: return (void*)(KSycocaFactoryList*)xptr;
        default: return xptr;
      }
    case 110:   //KSystemTimeZone
      switch(to) {
        case 116: return (void*)(KTimeZone*)(KSystemTimeZone*)xptr;
        case 110: return (void*)(KSystemTimeZone*)xptr;
        default: return xptr;
      }
    case 111:   //KSystemTimeZoneBackend
      switch(to) {
        case 120: return (void*)(KTimeZoneBackend*)(KSystemTimeZoneBackend*)xptr;
        case 111: return (void*)(KSystemTimeZoneBackend*)xptr;
        default: return xptr;
      }
    case 112:   //KSystemTimeZoneSource
      switch(to) {
        case 122: return (void*)(KTimeZoneSource*)(KSystemTimeZoneSource*)xptr;
        case 112: return (void*)(KSystemTimeZoneSource*)xptr;
        default: return xptr;
      }
    case 113:   //KSystemTimeZones
      switch(to) {
        case 158: return (void*)(QObject*)(KSystemTimeZones*)xptr;
        case 113: return (void*)(KSystemTimeZones*)xptr;
        default: return xptr;
      }
    case 114:   //KTempDir
      switch(to) {
        case 114: return (void*)(KTempDir*)xptr;
        default: return xptr;
      }
    case 115:   //KTemporaryFile
      switch(to) {
        case 168: return (void*)(QTemporaryFile*)(KTemporaryFile*)xptr;
        case 147: return (void*)(QFile*)(KTemporaryFile*)xptr;
        case 151: return (void*)(QIODevice*)(KTemporaryFile*)xptr;
        case 158: return (void*)(QObject*)(KTemporaryFile*)xptr;
        case 115: return (void*)(KTemporaryFile*)xptr;
        default: return xptr;
      }
    case 116:   //KTimeZone
      switch(to) {
        case 116: return (void*)(KTimeZone*)xptr;
        case 110: return (void*)(KSystemTimeZone*)(KTimeZone*)xptr;
        case 125: return (void*)(KTzfileTimeZone*)(KTimeZone*)xptr;
        default: return xptr;
      }
    case 117:   //KTimeZone::LeapSeconds
      switch(to) {
        case 117: return (void*)(KTimeZone::LeapSeconds*)xptr;
        default: return xptr;
      }
    case 118:   //KTimeZone::Phase
      switch(to) {
        case 118: return (void*)(KTimeZone::Phase*)xptr;
        default: return xptr;
      }
    case 119:   //KTimeZone::Transition
      switch(to) {
        case 119: return (void*)(KTimeZone::Transition*)xptr;
        default: return xptr;
      }
    case 120:   //KTimeZoneBackend
      switch(to) {
        case 120: return (void*)(KTimeZoneBackend*)xptr;
        case 126: return (void*)(KTzfileTimeZoneBackend*)(KTimeZoneBackend*)xptr;
        case 111: return (void*)(KSystemTimeZoneBackend*)(KTimeZoneBackend*)xptr;
        default: return xptr;
      }
    case 121:   //KTimeZoneData
      switch(to) {
        case 121: return (void*)(KTimeZoneData*)xptr;
        default: return xptr;
      }
    case 122:   //KTimeZoneSource
      switch(to) {
        case 122: return (void*)(KTimeZoneSource*)xptr;
        case 127: return (void*)(KTzfileTimeZoneSource*)(KTimeZoneSource*)xptr;
        case 112: return (void*)(KSystemTimeZoneSource*)(KTimeZoneSource*)xptr;
        default: return xptr;
      }
    case 123:   //KTimeZones
      switch(to) {
        case 123: return (void*)(KTimeZones*)xptr;
        default: return xptr;
      }
    case 124:   //KToolInvocation
      switch(to) {
        case 158: return (void*)(QObject*)(KToolInvocation*)xptr;
        case 124: return (void*)(KToolInvocation*)xptr;
        default: return xptr;
      }
    case 125:   //KTzfileTimeZone
      switch(to) {
        case 116: return (void*)(KTimeZone*)(KTzfileTimeZone*)xptr;
        case 125: return (void*)(KTzfileTimeZone*)xptr;
        default: return xptr;
      }
    case 126:   //KTzfileTimeZoneBackend
      switch(to) {
        case 120: return (void*)(KTimeZoneBackend*)(KTzfileTimeZoneBackend*)xptr;
        case 126: return (void*)(KTzfileTimeZoneBackend*)xptr;
        default: return xptr;
      }
    case 127:   //KTzfileTimeZoneSource
      switch(to) {
        case 122: return (void*)(KTimeZoneSource*)(KTzfileTimeZoneSource*)xptr;
        case 127: return (void*)(KTzfileTimeZoneSource*)xptr;
        default: return xptr;
      }
    case 128:   //KUrl
      switch(to) {
        case 174: return (void*)(QUrl*)(KUrl*)xptr;
        case 128: return (void*)(KUrl*)xptr;
        default: return xptr;
      }
    case 129:   //KUser
      switch(to) {
        case 129: return (void*)(KUser*)xptr;
        default: return xptr;
      }
    case 130:   //KUserGroup
      switch(to) {
        case 130: return (void*)(KUserGroup*)xptr;
        default: return xptr;
      }
    case 131:   //KWordMacroExpander
      switch(to) {
        case 76: return (void*)(KMacroExpanderBase*)(KWordMacroExpander*)xptr;
        case 131: return (void*)(KWordMacroExpander*)xptr;
        default: return xptr;
      }
    case 132:   //OrgKdeKLauncherInterface
      switch(to) {
        case 139: return (void*)(QDBusAbstractInterface*)(OrgKdeKLauncherInterface*)xptr;
        case 158: return (void*)(QObject*)(OrgKdeKLauncherInterface*)xptr;
        case 132: return (void*)(OrgKdeKLauncherInterface*)xptr;
        default: return xptr;
      }
    case 133:   //QAbstractFileEngine
      switch(to) {
        case 133: return (void*)(QAbstractFileEngine*)xptr;
        default: return xptr;
      }
    case 134:   //QAbstractSocket
      switch(to) {
        case 151: return (void*)(QIODevice*)(QAbstractSocket*)xptr;
        case 158: return (void*)(QObject*)(QAbstractSocket*)xptr;
        case 134: return (void*)(QAbstractSocket*)xptr;
        case 69: return (void*)(KLocalSocket*)(QAbstractSocket*)xptr;
        default: return xptr;
      }
    case 135:   //QBool
      switch(to) {
        case 135: return (void*)(QBool*)xptr;
        default: return xptr;
      }
    case 136:   //QByteArray
      switch(to) {
        case 136: return (void*)(QByteArray*)xptr;
        default: return xptr;
      }
    case 137:   //QChar
      switch(to) {
        case 137: return (void*)(QChar*)xptr;
        default: return xptr;
      }
    case 138:   //QChildEvent
      switch(to) {
        case 146: return (void*)(QEvent*)(QChildEvent*)xptr;
        case 138: return (void*)(QChildEvent*)xptr;
        default: return xptr;
      }
    case 139:   //QDBusAbstractInterface
      switch(to) {
        case 158: return (void*)(QObject*)(QDBusAbstractInterface*)xptr;
        case 139: return (void*)(QDBusAbstractInterface*)xptr;
        case 132: return (void*)(OrgKdeKLauncherInterface*)(QDBusAbstractInterface*)xptr;
        default: return xptr;
      }
    case 140:   //QDBusConnection
      switch(to) {
        case 140: return (void*)(QDBusConnection*)xptr;
        default: return xptr;
      }
    case 141:   //QDBusObjectPath
      switch(to) {
        case 141: return (void*)(QDBusObjectPath*)xptr;
        default: return xptr;
      }
    case 142:   //QDBusSignature
      switch(to) {
        case 142: return (void*)(QDBusSignature*)xptr;
        default: return xptr;
      }
    case 143:   //QDataStream
      switch(to) {
        case 143: return (void*)(QDataStream*)xptr;
        default: return xptr;
      }
    case 144:   //QDate
      switch(to) {
        case 144: return (void*)(QDate*)xptr;
        default: return xptr;
      }
    case 145:   //QDateTime
      switch(to) {
        case 145: return (void*)(QDateTime*)xptr;
        default: return xptr;
      }
    case 146:   //QEvent
      switch(to) {
        case 146: return (void*)(QEvent*)xptr;
        default: return xptr;
      }
    case 147:   //QFile
      switch(to) {
        case 151: return (void*)(QIODevice*)(QFile*)xptr;
        case 158: return (void*)(QObject*)(QFile*)xptr;
        case 147: return (void*)(QFile*)xptr;
        case 8: return (void*)(KAutoSaveFile*)(QFile*)xptr;
        case 93: return (void*)(KSaveFile*)(QFile*)xptr;
        case 115: return (void*)(KTemporaryFile*)(QFile*)xptr;
        default: return xptr;
      }
    case 148:   //QFileInfo
      switch(to) {
        case 148: return (void*)(QFileInfo*)xptr;
        default: return xptr;
      }
    case 150:   //QHostAddress
      switch(to) {
        case 150: return (void*)(QHostAddress*)xptr;
        default: return xptr;
      }
    case 151:   //QIODevice
      switch(to) {
        case 158: return (void*)(QObject*)(QIODevice*)xptr;
        case 151: return (void*)(QIODevice*)xptr;
        case 69: return (void*)(KLocalSocket*)(QIODevice*)xptr;
        case 61: return (void*)(KFilterDev*)(QIODevice*)xptr;
        case 8: return (void*)(KAutoSaveFile*)(QIODevice*)xptr;
        case 93: return (void*)(KSaveFile*)(QIODevice*)xptr;
        case 115: return (void*)(KTemporaryFile*)(QIODevice*)xptr;
        case 87: return (void*)(KProcess*)(QIODevice*)xptr;
        default: return xptr;
      }
    case 152:   //QIncompatibleFlag
      switch(to) {
        case 152: return (void*)(QIncompatibleFlag*)xptr;
        default: return xptr;
      }
    case 153:   //QLatin1String
      switch(to) {
        case 153: return (void*)(QLatin1String*)xptr;
        default: return xptr;
      }
    case 154:   //QLibrary
      switch(to) {
        case 158: return (void*)(QObject*)(QLibrary*)xptr;
        case 154: return (void*)(QLibrary*)xptr;
        case 68: return (void*)(KLibrary*)(QLibrary*)xptr;
        default: return xptr;
      }
    case 155:   //QMetaObject
      switch(to) {
        case 155: return (void*)(QMetaObject*)xptr;
        default: return xptr;
      }
    case 156:   //QMimeData
      switch(to) {
        case 158: return (void*)(QObject*)(QMimeData*)xptr;
        case 156: return (void*)(QMimeData*)xptr;
        default: return xptr;
      }
    case 157:   //QNetworkProxy
      switch(to) {
        case 157: return (void*)(QNetworkProxy*)xptr;
        default: return xptr;
      }
    case 158:   //QObject
      switch(to) {
        case 158: return (void*)(QObject*)xptr;
        case 65: return (void*)(KJobTrackerInterface*)(QObject*)xptr;
        case 19: return (void*)(KCompositeJob*)(QObject*)xptr;
        case 86: return (void*)(KPluginLoader*)(QObject*)xptr;
        case 69: return (void*)(KLocalSocket*)(QObject*)xptr;
        case 63: return (void*)(KJob*)(QObject*)xptr;
        case 70: return (void*)(KLocalSocketServer*)(QObject*)xptr;
        case 178: return (void*)(Sonnet::BackgroundChecker*)(QObject*)xptr;
        case 9: return (void*)(KAutostart*)(QObject*)xptr;
        case 67: return (void*)(KLibLoader*)(QObject*)xptr;
        case 61: return (void*)(KFilterDev*)(QObject*)xptr;
        case 83: return (void*)(KPluginFactory*)(QObject*)xptr;
        case 113: return (void*)(KSystemTimeZones*)(QObject*)xptr;
        case 6: return (void*)(KAuth::ActionWatcher*)(QObject*)xptr;
        case 8: return (void*)(KAutoSaveFile*)(QObject*)xptr;
        case 124: return (void*)(KToolInvocation*)(QObject*)xptr;
        case 132: return (void*)(OrgKdeKLauncherInterface*)(QObject*)xptr;
        case 68: return (void*)(KLibrary*)(QObject*)xptr;
        case 93: return (void*)(KSaveFile*)(QObject*)xptr;
        case 26: return (void*)(KCoreConfigSkeleton*)(QObject*)xptr;
        case 66: return (void*)(KJobUiDelegate*)(QObject*)xptr;
        case 115: return (void*)(KTemporaryFile*)(QObject*)xptr;
        case 51: return (void*)(KDEDModule*)(QObject*)xptr;
        case 105: return (void*)(KSycoca*)(QObject*)xptr;
        case 87: return (void*)(KProcess*)(QObject*)xptr;
        default: return xptr;
      }
    case 159:   //QPluginLoader
      switch(to) {
        case 158: return (void*)(QObject*)(QPluginLoader*)xptr;
        case 159: return (void*)(QPluginLoader*)xptr;
        case 86: return (void*)(KPluginLoader*)(QPluginLoader*)xptr;
        default: return xptr;
      }
    case 160:   //QPoint
      switch(to) {
        case 160: return (void*)(QPoint*)xptr;
        default: return xptr;
      }
    case 161:   //QProcess
      switch(to) {
        case 151: return (void*)(QIODevice*)(QProcess*)xptr;
        case 158: return (void*)(QObject*)(QProcess*)xptr;
        case 161: return (void*)(QProcess*)xptr;
        case 87: return (void*)(KProcess*)(QProcess*)xptr;
        default: return xptr;
      }
    case 162:   //QRect
      switch(to) {
        case 162: return (void*)(QRect*)xptr;
        default: return xptr;
      }
    case 163:   //QRegExp
      switch(to) {
        case 163: return (void*)(QRegExp*)xptr;
        default: return xptr;
      }
    case 164:   //QSharedData
      switch(to) {
        case 164: return (void*)(QSharedData*)xptr;
        case 89: return (void*)(KProtocolInfo*)(QSharedData*)xptr;
        case 97: return (void*)(KServiceType*)(QSharedData*)xptr;
        case 94: return (void*)(KService*)(QSharedData*)xptr;
        case 73: return (void*)(KLockFile*)(QSharedData*)xptr;
        case 106: return (void*)(KSycocaEntry*)(QSharedData*)xptr;
        case 100: return (void*)(KSharedConfig*)(QSharedData*)xptr;
        case 96: return (void*)(KServiceGroup*)(QSharedData*)xptr;
        case 79: return (void*)(KMimeType*)(QSharedData*)xptr;
        default: return xptr;
      }
    case 165:   //QSize
      switch(to) {
        case 165: return (void*)(QSize*)xptr;
        default: return xptr;
      }
    case 166:   //QTcpServer
      switch(to) {
        case 158: return (void*)(QObject*)(QTcpServer*)xptr;
        case 166: return (void*)(QTcpServer*)xptr;
        default: return xptr;
      }
    case 167:   //QTcpSocket
      switch(to) {
        case 134: return (void*)(QAbstractSocket*)(QTcpSocket*)xptr;
        case 151: return (void*)(QIODevice*)(QTcpSocket*)xptr;
        case 158: return (void*)(QObject*)(QTcpSocket*)xptr;
        case 167: return (void*)(QTcpSocket*)xptr;
        case 69: return (void*)(KLocalSocket*)(QTcpSocket*)xptr;
        default: return xptr;
      }
    case 168:   //QTemporaryFile
      switch(to) {
        case 147: return (void*)(QFile*)(QTemporaryFile*)xptr;
        case 151: return (void*)(QIODevice*)(QTemporaryFile*)xptr;
        case 158: return (void*)(QObject*)(QTemporaryFile*)xptr;
        case 168: return (void*)(QTemporaryFile*)xptr;
        case 115: return (void*)(KTemporaryFile*)(QTemporaryFile*)xptr;
        default: return xptr;
      }
    case 169:   //QTextCodec
      switch(to) {
        case 169: return (void*)(QTextCodec*)xptr;
        default: return xptr;
      }
    case 170:   //QTextDecoder
      switch(to) {
        case 170: return (void*)(QTextDecoder*)xptr;
        default: return xptr;
      }
    case 171:   //QTime
      switch(to) {
        case 171: return (void*)(QTime*)xptr;
        default: return xptr;
      }
    case 172:   //QTimerEvent
      switch(to) {
        case 146: return (void*)(QEvent*)(QTimerEvent*)xptr;
        case 172: return (void*)(QTimerEvent*)xptr;
        default: return xptr;
      }
    case 173:   //QUdpSocket
      switch(to) {
        case 173: return (void*)(QUdpSocket*)xptr;
        default: return xptr;
      }
    case 174:   //QUrl
      switch(to) {
        case 174: return (void*)(QUrl*)xptr;
        case 128: return (void*)(KUrl*)(QUrl*)xptr;
        default: return xptr;
      }
    case 175:   //QVariant
      switch(to) {
        case 175: return (void*)(QVariant*)xptr;
        default: return xptr;
      }
    case 176:   //QWidget
      switch(to) {
        case 176: return (void*)(QWidget*)xptr;
        default: return xptr;
      }
    case 178:   //Sonnet::BackgroundChecker
      switch(to) {
        case 158: return (void*)(QObject*)(Sonnet::BackgroundChecker*)xptr;
        case 178: return (void*)(Sonnet::BackgroundChecker*)xptr;
        default: return xptr;
      }
    case 179:   //Sonnet::Speller
      switch(to) {
        case 179: return (void*)(Sonnet::Speller*)xptr;
        default: return xptr;
      }
    case 180:   //group
      switch(to) {
        case 180: return (void*)(group*)xptr;
        default: return xptr;
      }
    case 181:   //kndbgstream
      switch(to) {
        case 181: return (void*)(kndbgstream*)xptr;
        default: return xptr;
      }
    case 182:   //passwd
      switch(to) {
        case 182: return (void*)(passwd*)xptr;
        default: return xptr;
      }
    default: return xptr;
  }
}

// Group of Indexes (0 separated) used as super class lists.
// Classes with super classes have an index into this array.
static Smoke::Index inheritanceList[] = {
    0,	// 0: (no super class)
    158, 0,	// 1: QObject
    147, 0,	// 3: QFile
    76, 0,	// 5: KMacroExpanderBase
    63, 0,	// 7: KJob
    22, 0,	// 9: KConfigBase
    0, 0,	// 11: KConfigSkeletonGenericItem
    33, 0,	// 13: KCoreConfigSkeleton::ItemInt
    43, 0,	// 15: KCoreConfigSkeleton::ItemString
    44, 0,	// 17: KCoreConfigSkeleton::ItemStringList
    21, 0,	// 19: KConfig
    151, 0,	// 21: QIODevice
    154, 0,	// 23: QLibrary
    167, 0,	// 25: QTcpSocket
    164, 0,	// 27: QSharedData
    97, 0,	// 29: KServiceType
    159, 0,	// 31: QPluginLoader
    161, 0,	// 33: QProcess
    106, 0,	// 35: KSycocaEntry
    21, 164, 0,	// 37: KConfig, QSharedData
    116, 0,	// 40: KTimeZone
    120, 0,	// 42: KTimeZoneBackend
    122, 0,	// 44: KTimeZoneSource
    168, 0,	// 46: QTemporaryFile
    174, 0,	// 48: QUrl
    139, 0,	// 50: QDBusAbstractInterface
};

// These are the xenum functions for manipulating enum pointers
void xenum_KAutostart(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KShell(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KLocale(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KLocalSocket(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KConfig(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KUser(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KJob(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KServiceGroup(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KConfigBase(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KFilterBase(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KLockFile(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KMessage(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KStandardDirs(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_QGlobalSpace(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KAboutData(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KUrl(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KCalendarSystem(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KAuth__ActionReply(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KProtocolInfo(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KProcess(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KDateTime(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KService(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KCurrencyCode(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KLibLoader(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KCmdLineArgs(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KEncodingProber(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KSycoca(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KMimeType(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KCoreConfigSkeleton__ItemString(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KAuth__Action(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KProtocolInfo__ExtraField(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KEncodingDetector(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KGlobal(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_KComponentData(Smoke::EnumOperation, Smoke::Index, void*&, long&);
void xenum_Sonnet__Speller(Smoke::EnumOperation, Smoke::Index, void*&, long&);

// Those are the xcall functions defined in each x_*.cpp file, for dispatching method calls
void xcall_KAboutData(Smoke::Index, void*, Smoke::Stack);
void xcall_KAboutLicense(Smoke::Index, void*, Smoke::Stack);
void xcall_KAboutPerson(Smoke::Index, void*, Smoke::Stack);
void xcall_KAuth__Action(Smoke::Index, void*, Smoke::Stack);
void xcall_KAuth__ActionReply(Smoke::Index, void*, Smoke::Stack);
void xcall_KAuth__ActionWatcher(Smoke::Index, void*, Smoke::Stack);
void xcall_KAuthorized(Smoke::Index, void*, Smoke::Stack);
void xcall_KAutoSaveFile(Smoke::Index, void*, Smoke::Stack);
void xcall_KAutostart(Smoke::Index, void*, Smoke::Stack);
void xcall_KCalendarSystem(Smoke::Index, void*, Smoke::Stack);
void xcall_KCharMacroExpander(Smoke::Index, void*, Smoke::Stack);
void xcall_KCharsets(Smoke::Index, void*, Smoke::Stack);
void xcall_KCmdLineArgs(Smoke::Index, void*, Smoke::Stack);
void xcall_KCmdLineOptions(Smoke::Index, void*, Smoke::Stack);
void xcall_KCodecs(Smoke::Index, void*, Smoke::Stack);
void xcall_KComponentData(Smoke::Index, void*, Smoke::Stack);
void xcall_KCompositeJob(Smoke::Index, void*, Smoke::Stack);
void xcall_KConfig(Smoke::Index, void*, Smoke::Stack);
void xcall_KConfigBase(Smoke::Index, void*, Smoke::Stack);
void xcall_KConfigGroup(Smoke::Index, void*, Smoke::Stack);
void xcall_KConfigSkeletonItem(Smoke::Index, void*, Smoke::Stack);
void xcall_KCoreConfigSkeleton(Smoke::Index, void*, Smoke::Stack);
void xcall_KCoreConfigSkeleton__ItemBool(Smoke::Index, void*, Smoke::Stack);
void xcall_KCoreConfigSkeleton__ItemDateTime(Smoke::Index, void*, Smoke::Stack);
void xcall_KCoreConfigSkeleton__ItemDouble(Smoke::Index, void*, Smoke::Stack);
void xcall_KCoreConfigSkeleton__ItemEnum(Smoke::Index, void*, Smoke::Stack);
void xcall_KCoreConfigSkeleton__ItemEnum__Choice(Smoke::Index, void*, Smoke::Stack);
void xcall_KCoreConfigSkeleton__ItemEnum__Choice2(Smoke::Index, void*, Smoke::Stack);
void xcall_KCoreConfigSkeleton__ItemInt(Smoke::Index, void*, Smoke::Stack);
void xcall_KCoreConfigSkeleton__ItemIntList(Smoke::Index, void*, Smoke::Stack);
void xcall_KCoreConfigSkeleton__ItemLongLong(Smoke::Index, void*, Smoke::Stack);
void xcall_KCoreConfigSkeleton__ItemPassword(Smoke::Index, void*, Smoke::Stack);
void xcall_KCoreConfigSkeleton__ItemPath(Smoke::Index, void*, Smoke::Stack);
void xcall_KCoreConfigSkeleton__ItemPathList(Smoke::Index, void*, Smoke::Stack);
void xcall_KCoreConfigSkeleton__ItemPoint(Smoke::Index, void*, Smoke::Stack);
void xcall_KCoreConfigSkeleton__ItemProperty(Smoke::Index, void*, Smoke::Stack);
void xcall_KCoreConfigSkeleton__ItemRect(Smoke::Index, void*, Smoke::Stack);
void xcall_KCoreConfigSkeleton__ItemSize(Smoke::Index, void*, Smoke::Stack);
void xcall_KCoreConfigSkeleton__ItemString(Smoke::Index, void*, Smoke::Stack);
void xcall_KCoreConfigSkeleton__ItemStringList(Smoke::Index, void*, Smoke::Stack);
void xcall_KCoreConfigSkeleton__ItemUInt(Smoke::Index, void*, Smoke::Stack);
void xcall_KCoreConfigSkeleton__ItemULongLong(Smoke::Index, void*, Smoke::Stack);
void xcall_KCoreConfigSkeleton__ItemUrl(Smoke::Index, void*, Smoke::Stack);
void xcall_KCoreConfigSkeleton__ItemUrlList(Smoke::Index, void*, Smoke::Stack);
void xcall_KCurrencyCode(Smoke::Index, void*, Smoke::Stack);
void xcall_KDE(Smoke::Index, void*, Smoke::Stack);
void xcall_KDEDModule(Smoke::Index, void*, Smoke::Stack);
void xcall_KDEPluginVerificationData(Smoke::Index, void*, Smoke::Stack);
void xcall_KDateTime(Smoke::Index, void*, Smoke::Stack);
void xcall_KDateTime__Spec(Smoke::Index, void*, Smoke::Stack);
void xcall_KDebug(Smoke::Index, void*, Smoke::Stack);
void xcall_KDebugTag(Smoke::Index, void*, Smoke::Stack);
void xcall_KDesktopFile(Smoke::Index, void*, Smoke::Stack);
void xcall_KEncodingDetector(Smoke::Index, void*, Smoke::Stack);
void xcall_KEncodingProber(Smoke::Index, void*, Smoke::Stack);
void xcall_KFilterBase(Smoke::Index, void*, Smoke::Stack);
void xcall_KFilterDev(Smoke::Index, void*, Smoke::Stack);
void xcall_KGlobal(Smoke::Index, void*, Smoke::Stack);
void xcall_KJob(Smoke::Index, void*, Smoke::Stack);
void xcall_KJobTrackerInterface(Smoke::Index, void*, Smoke::Stack);
void xcall_KJobUiDelegate(Smoke::Index, void*, Smoke::Stack);
void xcall_KLibLoader(Smoke::Index, void*, Smoke::Stack);
void xcall_KLibrary(Smoke::Index, void*, Smoke::Stack);
void xcall_KLocalSocket(Smoke::Index, void*, Smoke::Stack);
void xcall_KLocalSocketServer(Smoke::Index, void*, Smoke::Stack);
void xcall_KLocale(Smoke::Index, void*, Smoke::Stack);
void xcall_KLocalizedString(Smoke::Index, void*, Smoke::Stack);
void xcall_KLockFile(Smoke::Index, void*, Smoke::Stack);
void xcall_KMD5(Smoke::Index, void*, Smoke::Stack);
void xcall_KMacroExpander(Smoke::Index, void*, Smoke::Stack);
void xcall_KMacroExpanderBase(Smoke::Index, void*, Smoke::Stack);
void xcall_KMessage(Smoke::Index, void*, Smoke::Stack);
void xcall_KMessageHandler(Smoke::Index, void*, Smoke::Stack);
void xcall_KMimeType(Smoke::Index, void*, Smoke::Stack);
void xcall_KMimeTypeTrader(Smoke::Index, void*, Smoke::Stack);
void xcall_KPluginFactory(Smoke::Index, void*, Smoke::Stack);
void xcall_KPluginInfo(Smoke::Index, void*, Smoke::Stack);
void xcall_KPluginLoader(Smoke::Index, void*, Smoke::Stack);
void xcall_KProcess(Smoke::Index, void*, Smoke::Stack);
void xcall_KProtocolInfo(Smoke::Index, void*, Smoke::Stack);
void xcall_KProtocolInfo__ExtraField(Smoke::Index, void*, Smoke::Stack);
void xcall_KRandom(Smoke::Index, void*, Smoke::Stack);
void xcall_KRandomSequence(Smoke::Index, void*, Smoke::Stack);
void xcall_KSaveFile(Smoke::Index, void*, Smoke::Stack);
void xcall_KService(Smoke::Index, void*, Smoke::Stack);
void xcall_KServiceAction(Smoke::Index, void*, Smoke::Stack);
void xcall_KServiceGroup(Smoke::Index, void*, Smoke::Stack);
void xcall_KServiceType(Smoke::Index, void*, Smoke::Stack);
void xcall_KServiceTypeTrader(Smoke::Index, void*, Smoke::Stack);
void xcall_KSharedConfig(Smoke::Index, void*, Smoke::Stack);
void xcall_KShell(Smoke::Index, void*, Smoke::Stack);
void xcall_KSocketFactory(Smoke::Index, void*, Smoke::Stack);
void xcall_KStandardDirs(Smoke::Index, void*, Smoke::Stack);
void xcall_KStringHandler(Smoke::Index, void*, Smoke::Stack);
void xcall_KSycoca(Smoke::Index, void*, Smoke::Stack);
void xcall_KSycocaEntry(Smoke::Index, void*, Smoke::Stack);
void xcall_KSystemTimeZone(Smoke::Index, void*, Smoke::Stack);
void xcall_KSystemTimeZoneBackend(Smoke::Index, void*, Smoke::Stack);
void xcall_KSystemTimeZoneSource(Smoke::Index, void*, Smoke::Stack);
void xcall_KSystemTimeZones(Smoke::Index, void*, Smoke::Stack);
void xcall_KTempDir(Smoke::Index, void*, Smoke::Stack);
void xcall_KTemporaryFile(Smoke::Index, void*, Smoke::Stack);
void xcall_KTimeZone(Smoke::Index, void*, Smoke::Stack);
void xcall_KTimeZone__LeapSeconds(Smoke::Index, void*, Smoke::Stack);
void xcall_KTimeZone__Phase(Smoke::Index, void*, Smoke::Stack);
void xcall_KTimeZone__Transition(Smoke::Index, void*, Smoke::Stack);
void xcall_KTimeZoneBackend(Smoke::Index, void*, Smoke::Stack);
void xcall_KTimeZoneData(Smoke::Index, void*, Smoke::Stack);
void xcall_KTimeZoneSource(Smoke::Index, void*, Smoke::Stack);
void xcall_KTimeZones(Smoke::Index, void*, Smoke::Stack);
void xcall_KToolInvocation(Smoke::Index, void*, Smoke::Stack);
void xcall_KTzfileTimeZone(Smoke::Index, void*, Smoke::Stack);
void xcall_KTzfileTimeZoneBackend(Smoke::Index, void*, Smoke::Stack);
void xcall_KTzfileTimeZoneSource(Smoke::Index, void*, Smoke::Stack);
void xcall_KUrl(Smoke::Index, void*, Smoke::Stack);
void xcall_KUser(Smoke::Index, void*, Smoke::Stack);
void xcall_KUserGroup(Smoke::Index, void*, Smoke::Stack);
void xcall_KWordMacroExpander(Smoke::Index, void*, Smoke::Stack);
void xcall_OrgKdeKLauncherInterface(Smoke::Index, void*, Smoke::Stack);
void xcall_QGlobalSpace(Smoke::Index, void*, Smoke::Stack);
void xcall_Sonnet(Smoke::Index, void*, Smoke::Stack);
void xcall_Sonnet__BackgroundChecker(Smoke::Index, void*, Smoke::Stack);
void xcall_Sonnet__Speller(Smoke::Index, void*, Smoke::Stack);
void xcall_kndbgstream(Smoke::Index, void*, Smoke::Stack);

// List of all classes
// Name, external, index into inheritanceList, method dispatcher, enum dispatcher, class flags, size
static Smoke::Class classes[] = {
    { 0L, false, 0, 0, 0, 0, 0 },	// 0 (no class)
    { "KAboutData", false, 0, xcall_KAboutData, xenum_KAboutData, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KAboutData) },	//1
    { "KAboutLicense", false, 0, xcall_KAboutLicense, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KAboutLicense) },	//2
    { "KAboutPerson", false, 0, xcall_KAboutPerson, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KAboutPerson) },	//3
    { "KAuth::Action", false, 0, xcall_KAuth__Action, xenum_KAuth__Action, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KAuth::Action) },	//4
    { "KAuth::ActionReply", false, 0, xcall_KAuth__ActionReply, xenum_KAuth__ActionReply, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KAuth::ActionReply) },	//5
    { "KAuth::ActionWatcher", false, 1, xcall_KAuth__ActionWatcher, 0, Smoke::cf_virtual, sizeof(KAuth::ActionWatcher) },	//6
    { "KAuthorized", false, 0, xcall_KAuthorized, 0, Smoke::cf_namespace, 0 },	//7
    { "KAutoSaveFile", false, 3, xcall_KAutoSaveFile, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KAutoSaveFile) },	//8
    { "KAutostart", false, 1, xcall_KAutostart, xenum_KAutostart, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KAutostart) },	//9
    { "KCalendarSystem", false, 0, xcall_KCalendarSystem, xenum_KCalendarSystem, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KCalendarSystem) },	//10
    { "KCalendarSystemPrivate", true, 0, 0, 0, 0, 0 },	//11
    { "KCatalogName", true, 0, 0, 0, 0, 0 },	//12
    { "KCharMacroExpander", false, 5, xcall_KCharMacroExpander, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KCharMacroExpander) },	//13
    { "KCharsets", false, 0, xcall_KCharsets, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KCharsets) },	//14
    { "KCmdLineArgs", false, 0, xcall_KCmdLineArgs, xenum_KCmdLineArgs, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KCmdLineArgs) },	//15
    { "KCmdLineOptions", false, 0, xcall_KCmdLineOptions, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KCmdLineOptions) },	//16
    { "KCodecs", false, 0, xcall_KCodecs, 0, Smoke::cf_namespace, 0 },	//17
    { "KComponentData", false, 0, xcall_KComponentData, xenum_KComponentData, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KComponentData) },	//18
    { "KCompositeJob", false, 7, xcall_KCompositeJob, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KCompositeJob) },	//19
    { "KCompositeJobPrivate", true, 0, 0, 0, 0, 0 },	//20
    { "KConfig", false, 9, xcall_KConfig, xenum_KConfig, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KConfig) },	//21
    { "KConfigBase", false, 0, xcall_KConfigBase, xenum_KConfigBase, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KConfigBase) },	//22
    { "KConfigGroup", false, 9, xcall_KConfigGroup, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KConfigGroup) },	//23
    { "KConfigPrivate", true, 0, 0, 0, 0, 0 },	//24
    { "KConfigSkeletonItem", false, 0, xcall_KConfigSkeletonItem, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KConfigSkeletonItem) },	//25
    { "KCoreConfigSkeleton", false, 1, xcall_KCoreConfigSkeleton, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KCoreConfigSkeleton) },	//26
    { "KCoreConfigSkeleton::ItemBool", false, 11, xcall_KCoreConfigSkeleton__ItemBool, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KCoreConfigSkeleton::ItemBool) },	//27
    { "KCoreConfigSkeleton::ItemDateTime", false, 11, xcall_KCoreConfigSkeleton__ItemDateTime, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KCoreConfigSkeleton::ItemDateTime) },	//28
    { "KCoreConfigSkeleton::ItemDouble", false, 11, xcall_KCoreConfigSkeleton__ItemDouble, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KCoreConfigSkeleton::ItemDouble) },	//29
    { "KCoreConfigSkeleton::ItemEnum", false, 13, xcall_KCoreConfigSkeleton__ItemEnum, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KCoreConfigSkeleton::ItemEnum) },	//30
    { "KCoreConfigSkeleton::ItemEnum::Choice", false, 0, xcall_KCoreConfigSkeleton__ItemEnum__Choice, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KCoreConfigSkeleton::ItemEnum::Choice) },	//31
    { "KCoreConfigSkeleton::ItemEnum::Choice2", false, 0, xcall_KCoreConfigSkeleton__ItemEnum__Choice2, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KCoreConfigSkeleton::ItemEnum::Choice2) },	//32
    { "KCoreConfigSkeleton::ItemInt", false, 11, xcall_KCoreConfigSkeleton__ItemInt, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KCoreConfigSkeleton::ItemInt) },	//33
    { "KCoreConfigSkeleton::ItemIntList", false, 11, xcall_KCoreConfigSkeleton__ItemIntList, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KCoreConfigSkeleton::ItemIntList) },	//34
    { "KCoreConfigSkeleton::ItemLongLong", false, 11, xcall_KCoreConfigSkeleton__ItemLongLong, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KCoreConfigSkeleton::ItemLongLong) },	//35
    { "KCoreConfigSkeleton::ItemPassword", false, 15, xcall_KCoreConfigSkeleton__ItemPassword, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KCoreConfigSkeleton::ItemPassword) },	//36
    { "KCoreConfigSkeleton::ItemPath", false, 15, xcall_KCoreConfigSkeleton__ItemPath, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KCoreConfigSkeleton::ItemPath) },	//37
    { "KCoreConfigSkeleton::ItemPathList", false, 17, xcall_KCoreConfigSkeleton__ItemPathList, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KCoreConfigSkeleton::ItemPathList) },	//38
    { "KCoreConfigSkeleton::ItemPoint", false, 11, xcall_KCoreConfigSkeleton__ItemPoint, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KCoreConfigSkeleton::ItemPoint) },	//39
    { "KCoreConfigSkeleton::ItemProperty", false, 11, xcall_KCoreConfigSkeleton__ItemProperty, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KCoreConfigSkeleton::ItemProperty) },	//40
    { "KCoreConfigSkeleton::ItemRect", false, 11, xcall_KCoreConfigSkeleton__ItemRect, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KCoreConfigSkeleton::ItemRect) },	//41
    { "KCoreConfigSkeleton::ItemSize", false, 11, xcall_KCoreConfigSkeleton__ItemSize, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KCoreConfigSkeleton::ItemSize) },	//42
    { "KCoreConfigSkeleton::ItemString", false, 11, xcall_KCoreConfigSkeleton__ItemString, xenum_KCoreConfigSkeleton__ItemString, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KCoreConfigSkeleton::ItemString) },	//43
    { "KCoreConfigSkeleton::ItemStringList", false, 11, xcall_KCoreConfigSkeleton__ItemStringList, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KCoreConfigSkeleton::ItemStringList) },	//44
    { "KCoreConfigSkeleton::ItemUInt", false, 11, xcall_KCoreConfigSkeleton__ItemUInt, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KCoreConfigSkeleton::ItemUInt) },	//45
    { "KCoreConfigSkeleton::ItemULongLong", false, 11, xcall_KCoreConfigSkeleton__ItemULongLong, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KCoreConfigSkeleton::ItemULongLong) },	//46
    { "KCoreConfigSkeleton::ItemUrl", false, 11, xcall_KCoreConfigSkeleton__ItemUrl, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KCoreConfigSkeleton::ItemUrl) },	//47
    { "KCoreConfigSkeleton::ItemUrlList", false, 11, xcall_KCoreConfigSkeleton__ItemUrlList, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KCoreConfigSkeleton::ItemUrlList) },	//48
    { "KCurrencyCode", false, 0, xcall_KCurrencyCode, xenum_KCurrencyCode, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KCurrencyCode) },	//49
    { "KDE", false, 0, xcall_KDE, 0, Smoke::cf_namespace, 0 },	//50
    { "KDEDModule", false, 1, xcall_KDEDModule, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KDEDModule) },	//51
    { "KDEPluginVerificationData", false, 0, xcall_KDEPluginVerificationData, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KDEPluginVerificationData) },	//52
    { "KDateTime", false, 0, xcall_KDateTime, xenum_KDateTime, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KDateTime) },	//53
    { "KDateTime::Spec", false, 0, xcall_KDateTime__Spec, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KDateTime::Spec) },	//54
    { "KDebug", false, 0, xcall_KDebug, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KDebug) },	//55
    { "KDebugTag", false, 0, xcall_KDebugTag, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KDebugTag) },	//56
    { "KDesktopFile", false, 19, xcall_KDesktopFile, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KDesktopFile) },	//57
    { "KEncodingDetector", false, 0, xcall_KEncodingDetector, xenum_KEncodingDetector, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KEncodingDetector) },	//58
    { "KEncodingProber", false, 0, xcall_KEncodingProber, xenum_KEncodingProber, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KEncodingProber) },	//59
    { "KFilterBase", false, 0, xcall_KFilterBase, xenum_KFilterBase, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KFilterBase) },	//60
    { "KFilterDev", false, 21, xcall_KFilterDev, 0, Smoke::cf_virtual, sizeof(KFilterDev) },	//61
    { "KGlobal", false, 0, xcall_KGlobal, xenum_KGlobal, Smoke::cf_namespace, 0 },	//62
    { "KJob", false, 1, xcall_KJob, xenum_KJob, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KJob) },	//63
    { "KJobPrivate", true, 0, 0, 0, 0, 0 },	//64
    { "KJobTrackerInterface", false, 1, xcall_KJobTrackerInterface, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KJobTrackerInterface) },	//65
    { "KJobUiDelegate", false, 1, xcall_KJobUiDelegate, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KJobUiDelegate) },	//66
    { "KLibLoader", false, 1, xcall_KLibLoader, xenum_KLibLoader, Smoke::cf_virtual, sizeof(KLibLoader) },	//67
    { "KLibrary", false, 23, xcall_KLibrary, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KLibrary) },	//68
    { "KLocalSocket", false, 25, xcall_KLocalSocket, xenum_KLocalSocket, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KLocalSocket) },	//69
    { "KLocalSocketServer", false, 1, xcall_KLocalSocketServer, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KLocalSocketServer) },	//70
    { "KLocale", false, 0, xcall_KLocale, xenum_KLocale, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KLocale) },	//71
    { "KLocalizedString", false, 0, xcall_KLocalizedString, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KLocalizedString) },	//72
    { "KLockFile", false, 27, xcall_KLockFile, xenum_KLockFile, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KLockFile) },	//73
    { "KMD5", false, 0, xcall_KMD5, 0, Smoke::cf_constructor, sizeof(KMD5) },	//74
    { "KMacroExpander", false, 0, xcall_KMacroExpander, 0, Smoke::cf_namespace, 0 },	//75
    { "KMacroExpanderBase", false, 0, xcall_KMacroExpanderBase, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KMacroExpanderBase) },	//76
    { "KMessage", false, 0, xcall_KMessage, xenum_KMessage, Smoke::cf_namespace, 0 },	//77
    { "KMessageHandler", false, 0, xcall_KMessageHandler, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KMessageHandler) },	//78
    { "KMimeType", false, 29, xcall_KMimeType, xenum_KMimeType, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KMimeType) },	//79
    { "KMimeTypePrivate", true, 0, 0, 0, 0, 0 },	//80
    { "KMimeTypeTrader", false, 0, xcall_KMimeTypeTrader, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KMimeTypeTrader) },	//81
    { "KParts::Part", true, 0, 0, 0, 0, 0 },	//82
    { "KPluginFactory", false, 1, xcall_KPluginFactory, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KPluginFactory) },	//83
    { "KPluginFactoryPrivate", true, 0, 0, 0, 0, 0 },	//84
    { "KPluginInfo", false, 0, xcall_KPluginInfo, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KPluginInfo) },	//85
    { "KPluginLoader", false, 31, xcall_KPluginLoader, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KPluginLoader) },	//86
    { "KProcess", false, 33, xcall_KProcess, xenum_KProcess, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KProcess) },	//87
    { "KProcessPrivate", true, 0, 0, 0, 0, 0 },	//88
    { "KProtocolInfo", false, 35, xcall_KProtocolInfo, xenum_KProtocolInfo, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KProtocolInfo) },	//89
    { "KProtocolInfo::ExtraField", false, 0, xcall_KProtocolInfo__ExtraField, xenum_KProtocolInfo__ExtraField, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KProtocolInfo::ExtraField) },	//90
    { "KRandom", false, 0, xcall_KRandom, 0, Smoke::cf_namespace, 0 },	//91
    { "KRandomSequence", false, 0, xcall_KRandomSequence, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KRandomSequence) },	//92
    { "KSaveFile", false, 3, xcall_KSaveFile, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KSaveFile) },	//93
    { "KService", false, 35, xcall_KService, xenum_KService, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KService) },	//94
    { "KServiceAction", false, 0, xcall_KServiceAction, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KServiceAction) },	//95
    { "KServiceGroup", false, 35, xcall_KServiceGroup, xenum_KServiceGroup, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KServiceGroup) },	//96
    { "KServiceType", false, 35, xcall_KServiceType, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KServiceType) },	//97
    { "KServiceTypePrivate", true, 0, 0, 0, 0, 0 },	//98
    { "KServiceTypeTrader", false, 0, xcall_KServiceTypeTrader, 0, 0, sizeof(KServiceTypeTrader) },	//99
    { "KSharedConfig", false, 37, xcall_KSharedConfig, 0, Smoke::cf_virtual, sizeof(KSharedConfig) },	//100
    { "KShell", false, 0, xcall_KShell, xenum_KShell, Smoke::cf_namespace, 0 },	//101
    { "KSocketFactory", false, 0, xcall_KSocketFactory, 0, Smoke::cf_namespace, 0 },	//102
    { "KStandardDirs", false, 0, xcall_KStandardDirs, xenum_KStandardDirs, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KStandardDirs) },	//103
    { "KStringHandler", false, 0, xcall_KStringHandler, 0, Smoke::cf_namespace, 0 },	//104
    { "KSycoca", false, 1, xcall_KSycoca, xenum_KSycoca, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KSycoca) },	//105
    { "KSycocaEntry", false, 27, xcall_KSycocaEntry, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KSycocaEntry) },	//106
    { "KSycocaEntryPrivate", true, 0, 0, 0, 0, 0 },	//107
    { "KSycocaFactory", true, 0, 0, 0, 0, 0 },	//108
    { "KSycocaFactoryList", true, 0, 0, 0, 0, 0 },	//109
    { "KSystemTimeZone", false, 40, xcall_KSystemTimeZone, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KSystemTimeZone) },	//110
    { "KSystemTimeZoneBackend", false, 42, xcall_KSystemTimeZoneBackend, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KSystemTimeZoneBackend) },	//111
    { "KSystemTimeZoneSource", false, 44, xcall_KSystemTimeZoneSource, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KSystemTimeZoneSource) },	//112
    { "KSystemTimeZones", false, 1, xcall_KSystemTimeZones, 0, Smoke::cf_virtual, sizeof(KSystemTimeZones) },	//113
    { "KTempDir", false, 0, xcall_KTempDir, 0, Smoke::cf_constructor, sizeof(KTempDir) },	//114
    { "KTemporaryFile", false, 46, xcall_KTemporaryFile, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(KTemporaryFile) },	//115
    { "KTimeZone", false, 0, xcall_KTimeZone, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTimeZone) },	//116
    { "KTimeZone::LeapSeconds", false, 0, xcall_KTimeZone__LeapSeconds, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KTimeZone::LeapSeconds) },	//117
    { "KTimeZone::Phase", false, 0, xcall_KTimeZone__Phase, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KTimeZone::Phase) },	//118
    { "KTimeZone::Transition", false, 0, xcall_KTimeZone__Transition, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KTimeZone::Transition) },	//119
    { "KTimeZoneBackend", false, 0, xcall_KTimeZoneBackend, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTimeZoneBackend) },	//120
    { "KTimeZoneData", false, 0, xcall_KTimeZoneData, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTimeZoneData) },	//121
    { "KTimeZoneSource", false, 0, xcall_KTimeZoneSource, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTimeZoneSource) },	//122
    { "KTimeZones", false, 0, xcall_KTimeZones, 0, Smoke::cf_constructor, sizeof(KTimeZones) },	//123
    { "KToolInvocation", false, 1, xcall_KToolInvocation, 0, Smoke::cf_virtual, sizeof(KToolInvocation) },	//124
    { "KTzfileTimeZone", false, 40, xcall_KTzfileTimeZone, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTzfileTimeZone) },	//125
    { "KTzfileTimeZoneBackend", false, 42, xcall_KTzfileTimeZoneBackend, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTzfileTimeZoneBackend) },	//126
    { "KTzfileTimeZoneSource", false, 44, xcall_KTzfileTimeZoneSource, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KTzfileTimeZoneSource) },	//127
    { "KUrl", false, 48, xcall_KUrl, xenum_KUrl, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KUrl) },	//128
    { "KUser", false, 0, xcall_KUser, xenum_KUser, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KUser) },	//129
    { "KUserGroup", false, 0, xcall_KUserGroup, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(KUserGroup) },	//130
    { "KWordMacroExpander", false, 5, xcall_KWordMacroExpander, 0, Smoke::cf_constructor|Smoke::cf_deepcopy|Smoke::cf_virtual, sizeof(KWordMacroExpander) },	//131
    { "OrgKdeKLauncherInterface", false, 50, xcall_OrgKdeKLauncherInterface, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(OrgKdeKLauncherInterface) },	//132
    { "QAbstractFileEngine", true, 0, 0, 0, 0, 0 },	//133
    { "QAbstractSocket", true, 0, 0, 0, 0, 0 },	//134
    { "QBool", true, 0, 0, 0, 0, 0 },	//135
    { "QByteArray", true, 0, 0, 0, 0, 0 },	//136
    { "QChar", true, 0, 0, 0, 0, 0 },	//137
    { "QChildEvent", true, 0, 0, 0, 0, 0 },	//138
    { "QDBusAbstractInterface", true, 0, 0, 0, 0, 0 },	//139
    { "QDBusConnection", true, 0, 0, 0, 0, 0 },	//140
    { "QDBusObjectPath", true, 0, 0, 0, 0, 0 },	//141
    { "QDBusSignature", true, 0, 0, 0, 0, 0 },	//142
    { "QDataStream", true, 0, 0, 0, 0, 0 },	//143
    { "QDate", true, 0, 0, 0, 0, 0 },	//144
    { "QDateTime", true, 0, 0, 0, 0, 0 },	//145
    { "QEvent", true, 0, 0, 0, 0, 0 },	//146
    { "QFile", true, 0, 0, 0, 0, 0 },	//147
    { "QFileInfo", true, 0, 0, 0, 0, 0 },	//148
    { "QGlobalSpace", false, 0, xcall_QGlobalSpace, xenum_QGlobalSpace, Smoke::cf_namespace, 0 },	//149
    { "QHostAddress", true, 0, 0, 0, 0, 0 },	//150
    { "QIODevice", true, 0, 0, 0, 0, 0 },	//151
    { "QIncompatibleFlag", true, 0, 0, 0, 0, 0 },	//152
    { "QLatin1String", true, 0, 0, 0, 0, 0 },	//153
    { "QLibrary", true, 0, 0, 0, 0, 0 },	//154
    { "QMetaObject", true, 0, 0, 0, 0, 0 },	//155
    { "QMimeData", true, 0, 0, 0, 0, 0 },	//156
    { "QNetworkProxy", true, 0, 0, 0, 0, 0 },	//157
    { "QObject", true, 0, 0, 0, 0, 0 },	//158
    { "QPluginLoader", true, 0, 0, 0, 0, 0 },	//159
    { "QPoint", true, 0, 0, 0, 0, 0 },	//160
    { "QProcess", true, 0, 0, 0, 0, 0 },	//161
    { "QRect", true, 0, 0, 0, 0, 0 },	//162
    { "QRegExp", true, 0, 0, 0, 0, 0 },	//163
    { "QSharedData", true, 0, 0, 0, 0, 0 },	//164
    { "QSize", true, 0, 0, 0, 0, 0 },	//165
    { "QTcpServer", true, 0, 0, 0, 0, 0 },	//166
    { "QTcpSocket", true, 0, 0, 0, 0, 0 },	//167
    { "QTemporaryFile", true, 0, 0, 0, 0, 0 },	//168
    { "QTextCodec", true, 0, 0, 0, 0, 0 },	//169
    { "QTextDecoder", true, 0, 0, 0, 0, 0 },	//170
    { "QTime", true, 0, 0, 0, 0, 0 },	//171
    { "QTimerEvent", true, 0, 0, 0, 0, 0 },	//172
    { "QUdpSocket", true, 0, 0, 0, 0, 0 },	//173
    { "QUrl", true, 0, 0, 0, 0, 0 },	//174
    { "QVariant", true, 0, 0, 0, 0, 0 },	//175
    { "QWidget", true, 0, 0, 0, 0, 0 },	//176
    { "Sonnet", false, 0, xcall_Sonnet, 0, Smoke::cf_namespace, 0 },	//177
    { "Sonnet::BackgroundChecker", false, 1, xcall_Sonnet__BackgroundChecker, 0, Smoke::cf_constructor|Smoke::cf_virtual, sizeof(Sonnet::BackgroundChecker) },	//178
    { "Sonnet::Speller", false, 0, xcall_Sonnet__Speller, xenum_Sonnet__Speller, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(Sonnet::Speller) },	//179
    { "group", true, 0, 0, 0, 0, 0 },	//180
    { "kndbgstream", false, 0, xcall_kndbgstream, 0, Smoke::cf_constructor|Smoke::cf_deepcopy, sizeof(kndbgstream) },	//181
    { "passwd", true, 0, 0, 0, 0, 0 },	//182
};

// List of all types needed by the methods (arguments and return values)
// Name, class ID if arg is a class, and TypeId
static Smoke::Type types[] = {
    { 0, 0, 0 },	//0 (no type)
    { "DatabaseType", 0, Smoke::t_voidp|Smoke::tf_stack },	//1
    { "FILE*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//2
    { "FileNameUsedForCopying", 0, Smoke::t_voidp|Smoke::tf_stack },	//3
    { "KAboutData&", 1, Smoke::t_class|Smoke::tf_ref },	//4
    { "KAboutData*", 1, Smoke::t_class|Smoke::tf_ptr },	//5
    { "KAboutData::LicenseKey", 1, Smoke::t_enum|Smoke::tf_stack },	//6
    { "KAboutData::NameFormat", 1, Smoke::t_enum|Smoke::tf_stack },	//7
    { "KAboutLicense", 2, Smoke::t_class|Smoke::tf_stack },	//8
    { "KAboutLicense&", 2, Smoke::t_class|Smoke::tf_ref },	//9
    { "KAboutLicense*", 2, Smoke::t_class|Smoke::tf_ptr },	//10
    { "KAboutPerson", 3, Smoke::t_class|Smoke::tf_stack },	//11
    { "KAboutPerson&", 3, Smoke::t_class|Smoke::tf_ref },	//12
    { "KAboutPerson*", 3, Smoke::t_class|Smoke::tf_ptr },	//13
    { "KAuth::Action", 4, Smoke::t_class|Smoke::tf_stack },	//14
    { "KAuth::Action&", 4, Smoke::t_class|Smoke::tf_ref },	//15
    { "KAuth::Action*", 4, Smoke::t_class|Smoke::tf_ptr },	//16
    { "KAuth::Action::AuthStatus", 4, Smoke::t_enum|Smoke::tf_stack },	//17
    { "KAuth::ActionReply", 5, Smoke::t_class|Smoke::tf_stack },	//18
    { "KAuth::ActionReply&", 5, Smoke::t_class|Smoke::tf_ref },	//19
    { "KAuth::ActionReply*", 5, Smoke::t_class|Smoke::tf_ptr },	//20
    { "KAuth::ActionReply::Error", 5, Smoke::t_enum|Smoke::tf_stack },	//21
    { "KAuth::ActionReply::Type", 5, Smoke::t_enum|Smoke::tf_stack },	//22
    { "KAuth::ActionWatcher*", 6, Smoke::t_class|Smoke::tf_ptr },	//23
    { "KAutoSaveFile*", 8, Smoke::t_class|Smoke::tf_ptr },	//24
    { "KAutostart*", 9, Smoke::t_class|Smoke::tf_ptr },	//25
    { "KAutostart::Condition", 9, Smoke::t_enum|Smoke::tf_stack },	//26
    { "KAutostart::StartPhase", 9, Smoke::t_enum|Smoke::tf_stack },	//27
    { "KCalendarSystem*", 10, Smoke::t_class|Smoke::tf_ptr },	//28
    { "KCalendarSystem::MonthNameFormat", 10, Smoke::t_enum|Smoke::tf_stack },	//29
    { "KCalendarSystem::StringFormat", 10, Smoke::t_enum|Smoke::tf_stack },	//30
    { "KCalendarSystem::WeekDayNameFormat", 10, Smoke::t_enum|Smoke::tf_stack },	//31
    { "KCalendarSystemPrivate&", 11, Smoke::t_class|Smoke::tf_ref },	//32
    { "KCatalogName", 12, Smoke::t_class|Smoke::tf_stack },	//33
    { "KCharMacroExpander*", 13, Smoke::t_class|Smoke::tf_ptr },	//34
    { "KCharsets*", 14, Smoke::t_class|Smoke::tf_ptr },	//35
    { "KCmdLineArgs*", 15, Smoke::t_class|Smoke::tf_ptr },	//36
    { "KCmdLineArgs::StdCmdLineArg", 15, Smoke::t_enum|Smoke::tf_stack },	//37
    { "KCmdLineOptions&", 16, Smoke::t_class|Smoke::tf_ref },	//38
    { "KCmdLineOptions*", 16, Smoke::t_class|Smoke::tf_ptr },	//39
    { "KComponentData", 18, Smoke::t_class|Smoke::tf_stack },	//40
    { "KComponentData&", 18, Smoke::t_class|Smoke::tf_ref },	//41
    { "KComponentData*", 18, Smoke::t_class|Smoke::tf_ptr },	//42
    { "KComponentData::MainComponentRegistration", 18, Smoke::t_enum|Smoke::tf_stack },	//43
    { "KCompositeJob*", 19, Smoke::t_class|Smoke::tf_ptr },	//44
    { "KCompositeJobPrivate&", 20, Smoke::t_class|Smoke::tf_ref },	//45
    { "KConfig*", 21, Smoke::t_class|Smoke::tf_ptr },	//46
    { "KConfig::OpenFlag", 21, Smoke::t_enum|Smoke::tf_stack },	//47
    { "KConfigBase*", 22, Smoke::t_class|Smoke::tf_ptr },	//48
    { "KConfigBase::AccessMode", 22, Smoke::t_enum|Smoke::tf_stack },	//49
    { "KConfigBase::WriteConfigFlag", 22, Smoke::t_enum|Smoke::tf_stack },	//50
    { "KConfigGroup", 23, Smoke::t_class|Smoke::tf_stack },	//51
    { "KConfigGroup&", 23, Smoke::t_class|Smoke::tf_ref },	//52
    { "KConfigGroup*", 23, Smoke::t_class|Smoke::tf_ptr },	//53
    { "KConfigPrivate&", 24, Smoke::t_class|Smoke::tf_ref },	//54
    { "KConfigSkeletonItem*", 25, Smoke::t_class|Smoke::tf_ptr },	//55
    { "KCoreConfigSkeleton*", 26, Smoke::t_class|Smoke::tf_ptr },	//56
    { "KCoreConfigSkeleton::ItemBool*", 27, Smoke::t_class|Smoke::tf_ptr },	//57
    { "KCoreConfigSkeleton::ItemDateTime*", 28, Smoke::t_class|Smoke::tf_ptr },	//58
    { "KCoreConfigSkeleton::ItemDouble*", 29, Smoke::t_class|Smoke::tf_ptr },	//59
    { "KCoreConfigSkeleton::ItemEnum*", 30, Smoke::t_class|Smoke::tf_ptr },	//60
    { "KCoreConfigSkeleton::ItemEnum::Choice", 31, Smoke::t_class|Smoke::tf_stack },	//61
    { "KCoreConfigSkeleton::ItemEnum::Choice*", 31, Smoke::t_class|Smoke::tf_ptr },	//62
    { "KCoreConfigSkeleton::ItemEnum::Choice2", 32, Smoke::t_class|Smoke::tf_stack },	//63
    { "KCoreConfigSkeleton::ItemEnum::Choice2*", 32, Smoke::t_class|Smoke::tf_ptr },	//64
    { "KCoreConfigSkeleton::ItemInt*", 33, Smoke::t_class|Smoke::tf_ptr },	//65
    { "KCoreConfigSkeleton::ItemIntList*", 34, Smoke::t_class|Smoke::tf_ptr },	//66
    { "KCoreConfigSkeleton::ItemLongLong*", 35, Smoke::t_class|Smoke::tf_ptr },	//67
    { "KCoreConfigSkeleton::ItemPassword*", 36, Smoke::t_class|Smoke::tf_ptr },	//68
    { "KCoreConfigSkeleton::ItemPath*", 37, Smoke::t_class|Smoke::tf_ptr },	//69
    { "KCoreConfigSkeleton::ItemPathList*", 38, Smoke::t_class|Smoke::tf_ptr },	//70
    { "KCoreConfigSkeleton::ItemPoint*", 39, Smoke::t_class|Smoke::tf_ptr },	//71
    { "KCoreConfigSkeleton::ItemProperty*", 40, Smoke::t_class|Smoke::tf_ptr },	//72
    { "KCoreConfigSkeleton::ItemRect*", 41, Smoke::t_class|Smoke::tf_ptr },	//73
    { "KCoreConfigSkeleton::ItemSize*", 42, Smoke::t_class|Smoke::tf_ptr },	//74
    { "KCoreConfigSkeleton::ItemString*", 43, Smoke::t_class|Smoke::tf_ptr },	//75
    { "KCoreConfigSkeleton::ItemString::Type", 43, Smoke::t_enum|Smoke::tf_stack },	//76
    { "KCoreConfigSkeleton::ItemStringList*", 44, Smoke::t_class|Smoke::tf_ptr },	//77
    { "KCoreConfigSkeleton::ItemUInt*", 45, Smoke::t_class|Smoke::tf_ptr },	//78
    { "KCoreConfigSkeleton::ItemULongLong*", 46, Smoke::t_class|Smoke::tf_ptr },	//79
    { "KCoreConfigSkeleton::ItemUrl*", 47, Smoke::t_class|Smoke::tf_ptr },	//80
    { "KCoreConfigSkeleton::ItemUrlList*", 48, Smoke::t_class|Smoke::tf_ptr },	//81
    { "KCurrencyCode&", 49, Smoke::t_class|Smoke::tf_ref },	//82
    { "KCurrencyCode*", 49, Smoke::t_class|Smoke::tf_ptr },	//83
    { "KCurrencyCode::CurrencyStatus", 49, Smoke::t_enum|Smoke::tf_stack },	//84
    { "KDEDModule*", 51, Smoke::t_class|Smoke::tf_ptr },	//85
    { "KDEPluginVerificationData*", 52, Smoke::t_class|Smoke::tf_ptr },	//86
    { "KDateTime", 53, Smoke::t_class|Smoke::tf_stack },	//87
    { "KDateTime&", 53, Smoke::t_class|Smoke::tf_ref },	//88
    { "KDateTime*", 53, Smoke::t_class|Smoke::tf_ptr },	//89
    { "KDateTime::Comparison", 53, Smoke::t_enum|Smoke::tf_stack },	//90
    { "KDateTime::Spec", 54, Smoke::t_class|Smoke::tf_stack },	//91
    { "KDateTime::Spec&", 54, Smoke::t_class|Smoke::tf_ref },	//92
    { "KDateTime::Spec*", 54, Smoke::t_class|Smoke::tf_ptr },	//93
    { "KDateTime::SpecType", 53, Smoke::t_enum|Smoke::tf_stack },	//94
    { "KDateTime::TimeFormat", 53, Smoke::t_enum|Smoke::tf_stack },	//95
    { "KDebug*", 55, Smoke::t_class|Smoke::tf_ptr },	//96
    { "KDebugTag*", 56, Smoke::t_class|Smoke::tf_ptr },	//97
    { "KDesktopFile*", 57, Smoke::t_class|Smoke::tf_ptr },	//98
    { "KEncodingDetector*", 58, Smoke::t_class|Smoke::tf_ptr },	//99
    { "KEncodingDetector::AutoDetectScript", 58, Smoke::t_enum|Smoke::tf_stack },	//100
    { "KEncodingDetector::EncodingChoiceSource", 58, Smoke::t_enum|Smoke::tf_stack },	//101
    { "KEncodingProber*", 59, Smoke::t_class|Smoke::tf_ptr },	//102
    { "KEncodingProber::ProberState", 59, Smoke::t_enum|Smoke::tf_stack },	//103
    { "KEncodingProber::ProberType", 59, Smoke::t_enum|Smoke::tf_stack },	//104
    { "KFilterBase*", 60, Smoke::t_class|Smoke::tf_ptr },	//105
    { "KFilterBase::FilterFlags", 60, Smoke::t_enum|Smoke::tf_stack },	//106
    { "KFilterBase::Result", 60, Smoke::t_enum|Smoke::tf_stack },	//107
    { "KGlobal::CopyCatalogs", 62, Smoke::t_enum|Smoke::tf_stack },	//108
    { "KJob*", 63, Smoke::t_class|Smoke::tf_ptr },	//109
    { "KJob::Capability", 63, Smoke::t_enum|Smoke::tf_stack },	//110
    { "KJob::KillVerbosity", 63, Smoke::t_enum|Smoke::tf_stack },	//111
    { "KJob::Unit", 63, Smoke::t_enum|Smoke::tf_stack },	//112
    { "KJobPrivate&", 64, Smoke::t_class|Smoke::tf_ref },	//113
    { "KJobTrackerInterface*", 65, Smoke::t_class|Smoke::tf_ptr },	//114
    { "KJobUiDelegate*", 66, Smoke::t_class|Smoke::tf_ptr },	//115
    { "KLibLoader*", 67, Smoke::t_class|Smoke::tf_ptr },	//116
    { "KLibLoader::ComponentLoadingError", 67, Smoke::t_enum|Smoke::tf_stack },	//117
    { "KLibrary*", 68, Smoke::t_class|Smoke::tf_ptr },	//118
    { "KLocalSocket*", 69, Smoke::t_class|Smoke::tf_ptr },	//119
    { "KLocalSocket::LocalSocketType", 69, Smoke::t_enum|Smoke::tf_stack },	//120
    { "KLocalSocketServer*", 70, Smoke::t_class|Smoke::tf_ptr },	//121
    { "KLocale&", 71, Smoke::t_class|Smoke::tf_ref },	//122
    { "KLocale*", 71, Smoke::t_class|Smoke::tf_ptr },	//123
    { "KLocale::BinarySizeUnits", 71, Smoke::t_enum|Smoke::tf_stack },	//124
    { "KLocale::BinaryUnitDialect", 71, Smoke::t_enum|Smoke::tf_stack },	//125
    { "KLocale::CalendarSystem", 71, Smoke::t_enum|Smoke::tf_stack },	//126
    { "KLocale::DateFormat", 71, Smoke::t_enum|Smoke::tf_stack },	//127
    { "KLocale::DateTimeComponent", 71, Smoke::t_enum|Smoke::tf_stack },	//128
    { "KLocale::DateTimeComponentFormat", 71, Smoke::t_enum|Smoke::tf_stack },	//129
    { "KLocale::DateTimeFormatOption", 71, Smoke::t_enum|Smoke::tf_stack },	//130
    { "KLocale::DateTimeFormatStandard", 71, Smoke::t_enum|Smoke::tf_stack },	//131
    { "KLocale::DateTimeParseMode", 71, Smoke::t_enum|Smoke::tf_stack },	//132
    { "KLocale::DigitSet", 71, Smoke::t_enum|Smoke::tf_stack },	//133
    { "KLocale::MeasureSystem", 71, Smoke::t_enum|Smoke::tf_stack },	//134
    { "KLocale::ReadDateFlags", 71, Smoke::t_enum|Smoke::tf_stack },	//135
    { "KLocale::ReadTimeFlags", 71, Smoke::t_enum|Smoke::tf_stack },	//136
    { "KLocale::SignPosition", 71, Smoke::t_enum|Smoke::tf_stack },	//137
    { "KLocale::TimeFormatOption", 71, Smoke::t_enum|Smoke::tf_stack },	//138
    { "KLocale::TimeProcessingOption", 71, Smoke::t_enum|Smoke::tf_stack },	//139
    { "KLocale::WeekNumberSystem", 71, Smoke::t_enum|Smoke::tf_stack },	//140
    { "KLocalizedString", 72, Smoke::t_class|Smoke::tf_stack },	//141
    { "KLocalizedString&", 72, Smoke::t_class|Smoke::tf_ref },	//142
    { "KLocalizedString*", 72, Smoke::t_class|Smoke::tf_ptr },	//143
    { "KLockFile*", 73, Smoke::t_class|Smoke::tf_ptr },	//144
    { "KLockFile::LockFlag", 73, Smoke::t_enum|Smoke::tf_stack },	//145
    { "KLockFile::LockResult", 73, Smoke::t_enum|Smoke::tf_stack },	//146
    { "KMD5*", 74, Smoke::t_class|Smoke::tf_ptr },	//147
    { "KMacroExpanderBase*", 76, Smoke::t_class|Smoke::tf_ptr },	//148
    { "KMessage::MessageType", 77, Smoke::t_enum|Smoke::tf_stack },	//149
    { "KMessageHandler*", 78, Smoke::t_class|Smoke::tf_ptr },	//150
    { "KMimeType", 79, Smoke::t_class|Smoke::tf_stack },	//151
    { "KMimeType*", 79, Smoke::t_class|Smoke::tf_ptr },	//152
    { "KMimeType::FindByNameOption", 79, Smoke::t_enum|Smoke::tf_stack },	//153
    { "KMimeTypePrivate&", 80, Smoke::t_class|Smoke::tf_ref },	//154
    { "KMimeTypeTrader*", 81, Smoke::t_class|Smoke::tf_ptr },	//155
    { "KParts::Part*", 82, Smoke::t_class|Smoke::tf_ptr },	//156
    { "KPluginFactory*", 83, Smoke::t_class|Smoke::tf_ptr },	//157
    { "KPluginFactoryPrivate&", 84, Smoke::t_class|Smoke::tf_ref },	//158
    { "KPluginInfo", 85, Smoke::t_class|Smoke::tf_stack },	//159
    { "KPluginInfo&", 85, Smoke::t_class|Smoke::tf_ref },	//160
    { "KPluginInfo*", 85, Smoke::t_class|Smoke::tf_ptr },	//161
    { "KPluginLoader*", 86, Smoke::t_class|Smoke::tf_ptr },	//162
    { "KProcess&", 87, Smoke::t_class|Smoke::tf_ref },	//163
    { "KProcess*", 87, Smoke::t_class|Smoke::tf_ptr },	//164
    { "KProcess::OutputChannelMode", 87, Smoke::t_enum|Smoke::tf_stack },	//165
    { "KProcessPrivate*", 88, Smoke::t_class|Smoke::tf_ptr },	//166
    { "KProtocolInfo*", 89, Smoke::t_class|Smoke::tf_ptr },	//167
    { "KProtocolInfo::ExtraField", 90, Smoke::t_class|Smoke::tf_stack },	//168
    { "KProtocolInfo::ExtraField&", 90, Smoke::t_class|Smoke::tf_ref },	//169
    { "KProtocolInfo::ExtraField*", 90, Smoke::t_class|Smoke::tf_ptr },	//170
    { "KProtocolInfo::ExtraField::Type", 90, Smoke::t_enum|Smoke::tf_stack },	//171
    { "KProtocolInfo::FileNameUsedForCopying", 89, Smoke::t_enum|Smoke::tf_stack },	//172
    { "KProtocolInfo::Type", 89, Smoke::t_enum|Smoke::tf_stack },	//173
    { "KRandomSequence&", 92, Smoke::t_class|Smoke::tf_ref },	//174
    { "KRandomSequence*", 92, Smoke::t_class|Smoke::tf_ptr },	//175
    { "KSaveFile*", 93, Smoke::t_class|Smoke::tf_ptr },	//176
    { "KService", 94, Smoke::t_class|Smoke::tf_stack },	//177
    { "KService*", 94, Smoke::t_class|Smoke::tf_ptr },	//178
    { "KService::DBusStartupType", 94, Smoke::t_enum|Smoke::tf_stack },	//179
    { "KServiceAction", 95, Smoke::t_class|Smoke::tf_stack },	//180
    { "KServiceAction&", 95, Smoke::t_class|Smoke::tf_ref },	//181
    { "KServiceAction*", 95, Smoke::t_class|Smoke::tf_ptr },	//182
    { "KServiceGroup", 96, Smoke::t_class|Smoke::tf_stack },	//183
    { "KServiceGroup*", 96, Smoke::t_class|Smoke::tf_ptr },	//184
    { "KServiceGroup::EntriesOption", 96, Smoke::t_enum|Smoke::tf_stack },	//185
    { "KServiceType", 97, Smoke::t_class|Smoke::tf_stack },	//186
    { "KServiceType*", 97, Smoke::t_class|Smoke::tf_ptr },	//187
    { "KServiceTypePrivate&", 98, Smoke::t_class|Smoke::tf_ref },	//188
    { "KServiceTypeTrader*", 99, Smoke::t_class|Smoke::tf_ptr },	//189
    { "KSharedConfig", 100, Smoke::t_class|Smoke::tf_stack },	//190
    { "KSharedPtr<KMimeType>", 0, Smoke::t_voidp|Smoke::tf_stack },	//191
    { "KSharedPtr<KService>", 0, Smoke::t_voidp|Smoke::tf_stack },	//192
    { "KSharedPtr<KServiceGroup>", 0, Smoke::t_voidp|Smoke::tf_stack },	//193
    { "KSharedPtr<KServiceType>", 0, Smoke::t_voidp|Smoke::tf_stack },	//194
    { "KSharedPtr<KSharedConfig>", 0, Smoke::t_voidp|Smoke::tf_stack },	//195
    { "KSharedPtr<KSycocaEntry>", 0, Smoke::t_voidp|Smoke::tf_stack },	//196
    { "KShell::Errors", 101, Smoke::t_enum|Smoke::tf_stack },	//197
    { "KShell::Errors*", 101, Smoke::t_enum|Smoke::tf_ptr },	//198
    { "KShell::Option", 101, Smoke::t_enum|Smoke::tf_stack },	//199
    { "KStandardDirs*", 103, Smoke::t_class|Smoke::tf_ptr },	//200
    { "KStandardDirs::SearchOption", 103, Smoke::t_enum|Smoke::tf_stack },	//201
    { "KSycoca*", 105, Smoke::t_class|Smoke::tf_ptr },	//202
    { "KSycoca::DatabaseType", 105, Smoke::t_enum|Smoke::tf_stack },	//203
    { "KSycocaEntry", 106, Smoke::t_class|Smoke::tf_stack },	//204
    { "KSycocaEntry*", 106, Smoke::t_class|Smoke::tf_ptr },	//205
    { "KSycocaEntryPrivate&", 107, Smoke::t_class|Smoke::tf_ref },	//206
    { "KSycocaFactory*", 108, Smoke::t_class|Smoke::tf_ptr },	//207
    { "KSycocaFactoryId", 149, Smoke::t_enum|Smoke::tf_stack },	//208
    { "KSycocaFactoryList*", 109, Smoke::t_class|Smoke::tf_ptr },	//209
    { "KSycocaType", 149, Smoke::t_enum|Smoke::tf_stack },	//210
    { "KSycocaType&", 149, Smoke::t_enum|Smoke::tf_ref },	//211
    { "KSystemTimeZone*", 110, Smoke::t_class|Smoke::tf_ptr },	//212
    { "KSystemTimeZoneBackend*", 111, Smoke::t_class|Smoke::tf_ptr },	//213
    { "KSystemTimeZoneSource*", 112, Smoke::t_class|Smoke::tf_ptr },	//214
    { "KTempDir*", 114, Smoke::t_class|Smoke::tf_ptr },	//215
    { "KTemporaryFile*", 115, Smoke::t_class|Smoke::tf_ptr },	//216
    { "KTimeZone", 116, Smoke::t_class|Smoke::tf_stack },	//217
    { "KTimeZone&", 116, Smoke::t_class|Smoke::tf_ref },	//218
    { "KTimeZone*", 116, Smoke::t_class|Smoke::tf_ptr },	//219
    { "KTimeZone::LeapSeconds", 117, Smoke::t_class|Smoke::tf_stack },	//220
    { "KTimeZone::LeapSeconds&", 117, Smoke::t_class|Smoke::tf_ref },	//221
    { "KTimeZone::LeapSeconds*", 117, Smoke::t_class|Smoke::tf_ptr },	//222
    { "KTimeZone::Phase", 118, Smoke::t_class|Smoke::tf_stack },	//223
    { "KTimeZone::Phase&", 118, Smoke::t_class|Smoke::tf_ref },	//224
    { "KTimeZone::Phase*", 118, Smoke::t_class|Smoke::tf_ptr },	//225
    { "KTimeZone::Transition", 119, Smoke::t_class|Smoke::tf_stack },	//226
    { "KTimeZone::Transition&", 119, Smoke::t_class|Smoke::tf_ref },	//227
    { "KTimeZone::Transition*", 119, Smoke::t_class|Smoke::tf_ptr },	//228
    { "KTimeZoneBackend&", 120, Smoke::t_class|Smoke::tf_ref },	//229
    { "KTimeZoneBackend*", 120, Smoke::t_class|Smoke::tf_ptr },	//230
    { "KTimeZoneData&", 121, Smoke::t_class|Smoke::tf_ref },	//231
    { "KTimeZoneData*", 121, Smoke::t_class|Smoke::tf_ptr },	//232
    { "KTimeZoneSource*", 122, Smoke::t_class|Smoke::tf_ptr },	//233
    { "KTimeZones*", 123, Smoke::t_class|Smoke::tf_ptr },	//234
    { "KToolInvocation*", 124, Smoke::t_class|Smoke::tf_ptr },	//235
    { "KTzfileTimeZone*", 125, Smoke::t_class|Smoke::tf_ptr },	//236
    { "KTzfileTimeZoneBackend*", 126, Smoke::t_class|Smoke::tf_ptr },	//237
    { "KTzfileTimeZoneSource*", 127, Smoke::t_class|Smoke::tf_ptr },	//238
    { "KUrl", 128, Smoke::t_class|Smoke::tf_stack },	//239
    { "KUrl&", 128, Smoke::t_class|Smoke::tf_ref },	//240
    { "KUrl*", 128, Smoke::t_class|Smoke::tf_ptr },	//241
    { "KUrl::AdjustPathOption", 128, Smoke::t_enum|Smoke::tf_stack },	//242
    { "KUrl::CleanPathOption", 128, Smoke::t_enum|Smoke::tf_stack },	//243
    { "KUrl::DirectoryOption", 128, Smoke::t_enum|Smoke::tf_stack },	//244
    { "KUrl::EncodedPathAndQueryOption", 128, Smoke::t_enum|Smoke::tf_stack },	//245
    { "KUrl::EqualsOption", 128, Smoke::t_enum|Smoke::tf_stack },	//246
    { "KUrl::List", 0, Smoke::t_voidp|Smoke::tf_stack },	//247
    { "KUrl::List&", 0, Smoke::t_voidp|Smoke::tf_ref },	//248
    { "KUrl::MimeDataFlags", 128, Smoke::t_enum|Smoke::tf_stack },	//249
    { "KUrl::QueryItemsOption", 128, Smoke::t_enum|Smoke::tf_stack },	//250
    { "KUser", 129, Smoke::t_class|Smoke::tf_stack },	//251
    { "KUser&", 129, Smoke::t_class|Smoke::tf_ref },	//252
    { "KUser*", 129, Smoke::t_class|Smoke::tf_ptr },	//253
    { "KUser::UIDMode", 129, Smoke::t_enum|Smoke::tf_stack },	//254
    { "KUser::UserProperty", 129, Smoke::t_enum|Smoke::tf_stack },	//255
    { "KUserGroup", 130, Smoke::t_class|Smoke::tf_stack },	//256
    { "KUserGroup&", 130, Smoke::t_class|Smoke::tf_ref },	//257
    { "KUserGroup*", 130, Smoke::t_class|Smoke::tf_ptr },	//258
    { "KWordMacroExpander*", 131, Smoke::t_class|Smoke::tf_ptr },	//259
    { "OrgKdeKLauncherInterface*", 132, Smoke::t_class|Smoke::tf_ptr },	//260
    { "QAbstractFileEngine*", 133, Smoke::t_class|Smoke::tf_ptr },	//261
    { "QAbstractSocket::SocketError", 134, Smoke::t_enum|Smoke::tf_stack },	//262
    { "QBool", 135, Smoke::t_class|Smoke::tf_stack },	//263
    { "QByteArray", 136, Smoke::t_class|Smoke::tf_stack },	//264
    { "QByteArray&", 136, Smoke::t_class|Smoke::tf_ref },	//265
    { "QChar", 137, Smoke::t_class|Smoke::tf_stack },	//266
    { "QChildEvent*", 138, Smoke::t_class|Smoke::tf_ptr },	//267
    { "QDBus::CallMode", 0, Smoke::t_enum|Smoke::tf_stack },	//268
    { "QDBusObjectPath", 141, Smoke::t_class|Smoke::tf_stack },	//269
    { "QDBusReply<bool>", 0, Smoke::t_voidp|Smoke::tf_stack },	//270
    { "QDBusReply<int>", 0, Smoke::t_voidp|Smoke::tf_stack },	//271
    { "QDBusReply<void>", 0, Smoke::t_voidp|Smoke::tf_stack },	//272
    { "QDataStream&", 143, Smoke::t_class|Smoke::tf_ref },	//273
    { "QDataStream*", 143, Smoke::t_class|Smoke::tf_ptr },	//274
    { "QDataStream*&", 143, Smoke::t_class|Smoke::tf_ref|Smoke::tf_ptr },	//275
    { "QDate", 144, Smoke::t_class|Smoke::tf_stack },	//276
    { "QDate&", 144, Smoke::t_class|Smoke::tf_ref },	//277
    { "QDateTime", 145, Smoke::t_class|Smoke::tf_stack },	//278
    { "QDateTime&", 145, Smoke::t_class|Smoke::tf_ref },	//279
    { "QEvent*", 146, Smoke::t_class|Smoke::tf_ptr },	//280
    { "QFile::FileError", 147, Smoke::t_enum|Smoke::tf_stack },	//281
    { "QFlags<KAutostart::Condition>", 0, Smoke::t_uint|Smoke::tf_stack },	//282
    { "QFlags<KCmdLineArgs::StdCmdLineArg>", 0, Smoke::t_uint|Smoke::tf_stack },	//283
    { "QFlags<KConfig::OpenFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//284
    { "QFlags<KConfigBase::WriteConfigFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//285
    { "QFlags<KCurrencyCode::CurrencyStatus>", 0, Smoke::t_uint|Smoke::tf_stack },	//286
    { "QFlags<KJob::Capability>", 0, Smoke::t_uint|Smoke::tf_stack },	//287
    { "QFlags<KLocale::DateTimeComponent>", 0, Smoke::t_uint|Smoke::tf_stack },	//288
    { "QFlags<KLocale::DateTimeFormatOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//289
    { "QFlags<KLocale::TimeFormatOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//290
    { "QFlags<KLocale::TimeProcessingOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//291
    { "QFlags<KLockFile::LockFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//292
    { "QFlags<KServiceGroup::EntriesOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//293
    { "QFlags<KShell::Option>", 0, Smoke::t_uint|Smoke::tf_stack },	//294
    { "QFlags<KStandardDirs::SearchOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//295
    { "QFlags<KUrl::CleanPathOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//296
    { "QFlags<KUrl::DirectoryOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//297
    { "QFlags<KUrl::EncodedPathAndQueryOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//298
    { "QFlags<KUrl::EqualsOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//299
    { "QFlags<KUrl::QueryItemsOption>", 0, Smoke::t_uint|Smoke::tf_stack },	//300
    { "QFlags<QIODevice::OpenModeFlag>", 0, Smoke::t_uint|Smoke::tf_stack },	//301
    { "QFlags<QLibrary::LoadHint>", 0, Smoke::t_uint|Smoke::tf_stack },	//302
    { "QFlags<QtConcurrent::ReduceOptions::enum_type>", 0, Smoke::t_uint|Smoke::tf_stack },	//303
    { "QIODevice&", 151, Smoke::t_class|Smoke::tf_ref },	//304
    { "QIODevice*", 151, Smoke::t_class|Smoke::tf_ptr },	//305
    { "QIODevice::OpenMode", 0, Smoke::t_uint|Smoke::tf_stack },	//306
    { "QIODevice::OpenModeFlag", 151, Smoke::t_enum|Smoke::tf_stack },	//307
    { "QIncompatibleFlag", 152, Smoke::t_class|Smoke::tf_stack },	//308
    { "QLibrary::LoadHint", 154, Smoke::t_enum|Smoke::tf_stack },	//309
    { "QList<KAboutLicense>", 0, Smoke::t_voidp|Smoke::tf_stack },	//310
    { "QList<KAboutPerson>", 0, Smoke::t_voidp|Smoke::tf_stack },	//311
    { "QList<KAuth::Action>*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//312
    { "QList<KAutoSaveFile*>", 0, Smoke::t_voidp|Smoke::tf_stack },	//313
    { "QList<KConfigSkeletonItem*>", 0, Smoke::t_voidp|Smoke::tf_stack },	//314
    { "QList<KCoreConfigSkeleton::ItemEnum::Choice2>", 0, Smoke::t_voidp|Smoke::tf_stack },	//315
    { "QList<KCoreConfigSkeleton::ItemEnum::Choice>", 0, Smoke::t_voidp|Smoke::tf_stack },	//316
    { "QList<KLocale::CalendarSystem>", 0, Smoke::t_voidp|Smoke::tf_stack },	//317
    { "QList<KLocale::DigitSet>", 0, Smoke::t_voidp|Smoke::tf_stack },	//318
    { "QList<KPluginInfo>", 0, Smoke::t_voidp|Smoke::tf_stack },	//319
    { "QList<KProtocolInfo::ExtraField>", 0, Smoke::t_voidp|Smoke::tf_stack },	//320
    { "QList<KServiceAction>", 0, Smoke::t_voidp|Smoke::tf_stack },	//321
    { "QList<KSharedPtr<KMimeType> >", 0, Smoke::t_voidp|Smoke::tf_stack },	//322
    { "QList<KSharedPtr<KService> >", 0, Smoke::t_voidp|Smoke::tf_stack },	//323
    { "QList<KSharedPtr<KService> >&", 0, Smoke::t_voidp|Smoke::tf_ref },	//324
    { "QList<KSharedPtr<KServiceGroup> >", 0, Smoke::t_voidp|Smoke::tf_stack },	//325
    { "QList<KSharedPtr<KServiceType> >", 0, Smoke::t_voidp|Smoke::tf_stack },	//326
    { "QList<KSharedPtr<KSycocaEntry> >", 0, Smoke::t_voidp|Smoke::tf_stack },	//327
    { "QList<KTimeZone::LeapSeconds>", 0, Smoke::t_voidp|Smoke::tf_stack },	//328
    { "QList<KTimeZone::Phase>", 0, Smoke::t_voidp|Smoke::tf_stack },	//329
    { "QList<KTimeZone::Transition>", 0, Smoke::t_voidp|Smoke::tf_stack },	//330
    { "QList<KUser>", 0, Smoke::t_voidp|Smoke::tf_stack },	//331
    { "QList<KUserGroup>", 0, Smoke::t_voidp|Smoke::tf_stack },	//332
    { "QList<QByteArray>", 0, Smoke::t_voidp|Smoke::tf_stack },	//333
    { "QList<QDateTime>", 0, Smoke::t_voidp|Smoke::tf_stack },	//334
    { "QList<QStringList>", 0, Smoke::t_voidp|Smoke::tf_stack },	//335
    { "QList<QVariant>", 0, Smoke::t_voidp|Smoke::tf_stack },	//336
    { "QList<int>", 0, Smoke::t_voidp|Smoke::tf_stack },	//337
    { "QList<int>&", 0, Smoke::t_voidp|Smoke::tf_ref },	//338
    { "QMap<QString,QString>", 0, Smoke::t_voidp|Smoke::tf_stack },	//339
    { "QMap<QString,QVariant::Type>", 0, Smoke::t_voidp|Smoke::tf_stack },	//340
    { "QMap<QString,QVariant>", 0, Smoke::t_voidp|Smoke::tf_stack },	//341
    { "QMetaObject::Call", 155, Smoke::t_enum|Smoke::tf_stack },	//342
    { "QMimeData*", 156, Smoke::t_class|Smoke::tf_ptr },	//343
    { "QNetworkProxy", 157, Smoke::t_class|Smoke::tf_stack },	//344
    { "QObject*", 158, Smoke::t_class|Smoke::tf_ptr },	//345
    { "QPair<QString,QString>", 0, Smoke::t_voidp|Smoke::tf_stack },	//346
    { "QPoint&", 160, Smoke::t_class|Smoke::tf_ref },	//347
    { "QRect&", 162, Smoke::t_class|Smoke::tf_ref },	//348
    { "QRegExp&", 163, Smoke::t_class|Smoke::tf_ref },	//349
    { "QSize&", 165, Smoke::t_class|Smoke::tf_ref },	//350
    { "QString", 0, Smoke::t_voidp|Smoke::tf_stack },	//351
    { "QString&", 0, Smoke::t_voidp|Smoke::tf_ref },	//352
    { "QString*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//353
    { "QStringList", 0, Smoke::t_voidp|Smoke::tf_stack },	//354
    { "QStringList&", 0, Smoke::t_voidp|Smoke::tf_ref },	//355
    { "QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//356
    { "QTcpServer*", 166, Smoke::t_class|Smoke::tf_ptr },	//357
    { "QTcpSocket*", 167, Smoke::t_class|Smoke::tf_ptr },	//358
    { "QTextCodec*", 169, Smoke::t_class|Smoke::tf_ptr },	//359
    { "QTextDecoder*", 170, Smoke::t_class|Smoke::tf_ptr },	//360
    { "QTime", 171, Smoke::t_class|Smoke::tf_stack },	//361
    { "QTimerEvent*", 172, Smoke::t_class|Smoke::tf_ptr },	//362
    { "QUdpSocket*", 173, Smoke::t_class|Smoke::tf_ptr },	//363
    { "QVariant", 175, Smoke::t_class|Smoke::tf_stack },	//364
    { "QVariant&", 175, Smoke::t_class|Smoke::tf_ref },	//365
    { "QVariant::Type", 175, Smoke::t_enum|Smoke::tf_stack },	//366
    { "QVariantMap", 0, Smoke::t_voidp|Smoke::tf_stack },	//367
    { "QWidget*", 176, Smoke::t_class|Smoke::tf_ptr },	//368
    { "Qt::AlignmentFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//369
    { "Qt::AnchorAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//370
    { "Qt::AnchorPoint", 0, Smoke::t_enum|Smoke::tf_stack },	//371
    { "Qt::ApplicationAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//372
    { "Qt::ArrowType", 0, Smoke::t_enum|Smoke::tf_stack },	//373
    { "Qt::AspectRatioMode", 0, Smoke::t_enum|Smoke::tf_stack },	//374
    { "Qt::Axis", 0, Smoke::t_enum|Smoke::tf_stack },	//375
    { "Qt::BGMode", 0, Smoke::t_enum|Smoke::tf_stack },	//376
    { "Qt::BrushStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//377
    { "Qt::CaseSensitivity", 0, Smoke::t_enum|Smoke::tf_stack },	//378
    { "Qt::CheckState", 0, Smoke::t_enum|Smoke::tf_stack },	//379
    { "Qt::ClipOperation", 0, Smoke::t_enum|Smoke::tf_stack },	//380
    { "Qt::ConnectionType", 0, Smoke::t_enum|Smoke::tf_stack },	//381
    { "Qt::ContextMenuPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//382
    { "Qt::CoordinateSystem", 0, Smoke::t_enum|Smoke::tf_stack },	//383
    { "Qt::Corner", 0, Smoke::t_enum|Smoke::tf_stack },	//384
    { "Qt::CursorMoveStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//385
    { "Qt::CursorShape", 0, Smoke::t_enum|Smoke::tf_stack },	//386
    { "Qt::DateFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//387
    { "Qt::DayOfWeek", 0, Smoke::t_enum|Smoke::tf_stack },	//388
    { "Qt::DockWidgetArea", 0, Smoke::t_enum|Smoke::tf_stack },	//389
    { "Qt::DockWidgetAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//390
    { "Qt::DropAction", 0, Smoke::t_enum|Smoke::tf_stack },	//391
    { "Qt::EventPriority", 0, Smoke::t_enum|Smoke::tf_stack },	//392
    { "Qt::FillRule", 0, Smoke::t_enum|Smoke::tf_stack },	//393
    { "Qt::FocusPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//394
    { "Qt::FocusReason", 0, Smoke::t_enum|Smoke::tf_stack },	//395
    { "Qt::GestureFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//396
    { "Qt::GestureState", 0, Smoke::t_enum|Smoke::tf_stack },	//397
    { "Qt::GestureType", 0, Smoke::t_enum|Smoke::tf_stack },	//398
    { "Qt::GlobalColor", 0, Smoke::t_enum|Smoke::tf_stack },	//399
    { "Qt::ImageConversionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//400
    { "Qt::Initialization", 0, Smoke::t_enum|Smoke::tf_stack },	//401
    { "Qt::InputMethodHint", 0, Smoke::t_enum|Smoke::tf_stack },	//402
    { "Qt::InputMethodQuery", 0, Smoke::t_enum|Smoke::tf_stack },	//403
    { "Qt::ItemDataRole", 0, Smoke::t_enum|Smoke::tf_stack },	//404
    { "Qt::ItemFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//405
    { "Qt::ItemSelectionMode", 0, Smoke::t_enum|Smoke::tf_stack },	//406
    { "Qt::Key", 0, Smoke::t_enum|Smoke::tf_stack },	//407
    { "Qt::KeyboardModifier", 0, Smoke::t_enum|Smoke::tf_stack },	//408
    { "Qt::LayoutDirection", 0, Smoke::t_enum|Smoke::tf_stack },	//409
    { "Qt::MaskMode", 0, Smoke::t_enum|Smoke::tf_stack },	//410
    { "Qt::MatchFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//411
    { "Qt::Modifier", 0, Smoke::t_enum|Smoke::tf_stack },	//412
    { "Qt::MouseButton", 0, Smoke::t_enum|Smoke::tf_stack },	//413
    { "Qt::NavigationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//414
    { "Qt::Orientation", 0, Smoke::t_enum|Smoke::tf_stack },	//415
    { "Qt::PenCapStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//416
    { "Qt::PenJoinStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//417
    { "Qt::PenStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//418
    { "Qt::ScrollBarPolicy", 0, Smoke::t_enum|Smoke::tf_stack },	//419
    { "Qt::ShortcutContext", 0, Smoke::t_enum|Smoke::tf_stack },	//420
    { "Qt::SizeHint", 0, Smoke::t_enum|Smoke::tf_stack },	//421
    { "Qt::SizeMode", 0, Smoke::t_enum|Smoke::tf_stack },	//422
    { "Qt::SortOrder", 0, Smoke::t_enum|Smoke::tf_stack },	//423
    { "Qt::TextElideMode", 0, Smoke::t_enum|Smoke::tf_stack },	//424
    { "Qt::TextFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//425
    { "Qt::TextFormat", 0, Smoke::t_enum|Smoke::tf_stack },	//426
    { "Qt::TextInteractionFlag", 0, Smoke::t_enum|Smoke::tf_stack },	//427
    { "Qt::TileRule", 0, Smoke::t_enum|Smoke::tf_stack },	//428
    { "Qt::TimeSpec", 0, Smoke::t_enum|Smoke::tf_stack },	//429
    { "Qt::ToolBarArea", 0, Smoke::t_enum|Smoke::tf_stack },	//430
    { "Qt::ToolBarAreaSizes", 0, Smoke::t_enum|Smoke::tf_stack },	//431
    { "Qt::ToolButtonStyle", 0, Smoke::t_enum|Smoke::tf_stack },	//432
    { "Qt::TouchPointState", 0, Smoke::t_enum|Smoke::tf_stack },	//433
    { "Qt::TransformationMode", 0, Smoke::t_enum|Smoke::tf_stack },	//434
    { "Qt::UIEffect", 0, Smoke::t_enum|Smoke::tf_stack },	//435
    { "Qt::WidgetAttribute", 0, Smoke::t_enum|Smoke::tf_stack },	//436
    { "Qt::WindowFrameSection", 0, Smoke::t_enum|Smoke::tf_stack },	//437
    { "Qt::WindowModality", 0, Smoke::t_enum|Smoke::tf_stack },	//438
    { "Qt::WindowState", 0, Smoke::t_enum|Smoke::tf_stack },	//439
    { "Qt::WindowType", 0, Smoke::t_enum|Smoke::tf_stack },	//440
    { "QtConcurrent::ReduceOption", 0, Smoke::t_enum|Smoke::tf_stack },	//441
    { "QtConcurrent::ReduceOptions::enum_type", 0, Smoke::t_voidp|Smoke::tf_stack },	//442
    { "QtConcurrent::ThreadFunctionResult", 0, Smoke::t_enum|Smoke::tf_stack },	//443
    { "QtMsgType", 149, Smoke::t_enum|Smoke::tf_stack },	//444
    { "Sonnet::BackgroundChecker*", 178, Smoke::t_class|Smoke::tf_ptr },	//445
    { "Sonnet::Speller", 179, Smoke::t_class|Smoke::tf_stack },	//446
    { "Sonnet::Speller&", 179, Smoke::t_class|Smoke::tf_ref },	//447
    { "Sonnet::Speller*", 179, Smoke::t_class|Smoke::tf_ptr },	//448
    { "Sonnet::Speller::Attribute", 179, Smoke::t_enum|Smoke::tf_stack },	//449
    { "bool", 0, Smoke::t_bool|Smoke::tf_stack },	//450
    { "bool&", 0, Smoke::t_voidp|Smoke::tf_ref },	//451
    { "bool*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//452
    { "char", 0, Smoke::t_char|Smoke::tf_stack },	//453
    { "char*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//454
    { "char**", 0, Smoke::t_voidp|Smoke::tf_ptr },	//455
    { "const KAboutData&", 1, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//456
    { "const KAboutData*", 1, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//457
    { "const KAboutLicense&", 2, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//458
    { "const KAboutPerson&", 3, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//459
    { "const KAuth::Action&", 4, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//460
    { "const KAuth::ActionReply&", 5, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//461
    { "const KCalendarSystem*", 10, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//462
    { "const KCharMacroExpander&", 13, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//463
    { "const KCharsets&", 14, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//464
    { "const KCmdLineArgs&", 15, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//465
    { "const KCmdLineOptions&", 16, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//466
    { "const KComponentData&", 18, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//467
    { "const KConfig*", 21, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//468
    { "const KConfigBase&", 22, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//469
    { "const KConfigBase*", 22, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//470
    { "const KConfigGroup", 23, Smoke::t_class|Smoke::tf_stack|Smoke::tf_const },	//471
    { "const KConfigGroup&", 23, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//472
    { "const KConfigSkeletonItem&", 25, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//473
    { "const KCoreConfigSkeleton::ItemBool&", 27, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//474
    { "const KCoreConfigSkeleton::ItemDateTime&", 28, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//475
    { "const KCoreConfigSkeleton::ItemDouble&", 29, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//476
    { "const KCoreConfigSkeleton::ItemEnum&", 30, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//477
    { "const KCoreConfigSkeleton::ItemEnum::Choice&", 31, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//478
    { "const KCoreConfigSkeleton::ItemEnum::Choice2&", 32, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//479
    { "const KCoreConfigSkeleton::ItemInt&", 33, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//480
    { "const KCoreConfigSkeleton::ItemIntList&", 34, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//481
    { "const KCoreConfigSkeleton::ItemLongLong&", 35, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//482
    { "const KCoreConfigSkeleton::ItemPassword&", 36, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//483
    { "const KCoreConfigSkeleton::ItemPath&", 37, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//484
    { "const KCoreConfigSkeleton::ItemPathList&", 38, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//485
    { "const KCoreConfigSkeleton::ItemPoint&", 39, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//486
    { "const KCoreConfigSkeleton::ItemProperty&", 40, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//487
    { "const KCoreConfigSkeleton::ItemRect&", 41, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//488
    { "const KCoreConfigSkeleton::ItemSize&", 42, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//489
    { "const KCoreConfigSkeleton::ItemString&", 43, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//490
    { "const KCoreConfigSkeleton::ItemStringList&", 44, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//491
    { "const KCoreConfigSkeleton::ItemUInt&", 45, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//492
    { "const KCoreConfigSkeleton::ItemULongLong&", 46, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//493
    { "const KCoreConfigSkeleton::ItemUrl&", 47, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//494
    { "const KCoreConfigSkeleton::ItemUrlList&", 48, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//495
    { "const KCurrencyCode&", 49, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//496
    { "const KDEPluginVerificationData&", 52, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//497
    { "const KDateTime&", 53, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//498
    { "const KDateTime::Spec&", 54, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//499
    { "const KDebug&", 55, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//500
    { "const KDebugTag&", 56, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//501
    { "const KDesktopFile*", 57, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//502
    { "const KEncodingDetector&", 58, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//503
    { "const KEncodingProber&", 59, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//504
    { "const KLocale&", 71, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//505
    { "const KLocale*", 71, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//506
    { "const KLocalizedString&", 72, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//507
    { "const KLockFile&", 73, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//508
    { "const KMacroExpanderBase&", 76, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//509
    { "const KMessageHandler&", 78, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//510
    { "const KMimeTypeTrader&", 81, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//511
    { "const KPluginInfo&", 85, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//512
    { "const KProtocolInfo::ExtraField&", 90, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//513
    { "const KRandomSequence&", 92, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//514
    { "const KService&", 94, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//515
    { "const KServiceAction&", 95, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//516
    { "const KServiceType*", 97, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//517
    { "const KSharedPtr<KService>", 0, Smoke::t_voidp|Smoke::tf_stack|Smoke::tf_const },	//518
    { "const KSharedPtr<KSharedConfig>", 0, Smoke::t_voidp|Smoke::tf_stack|Smoke::tf_const },	//519
    { "const KSharedPtr<KSharedConfig>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//520
    { "const KSharedPtr<KSycocaEntry>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//521
    { "const KSystemTimeZone&", 110, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//522
    { "const KSystemTimeZoneBackend&", 111, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//523
    { "const KSystemTimeZoneSource&", 112, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//524
    { "const KTimeZone&", 116, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//525
    { "const KTimeZone*", 116, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//526
    { "const KTimeZone::LeapSeconds&", 117, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//527
    { "const KTimeZone::Phase&", 118, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//528
    { "const KTimeZone::Transition&", 119, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//529
    { "const KTimeZone::Transition*", 119, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//530
    { "const KTimeZone::Transition**", 119, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//531
    { "const KTimeZoneBackend&", 120, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//532
    { "const KTimeZoneData&", 121, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//533
    { "const KTimeZoneData*", 121, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//534
    { "const KTimeZoneSource&", 122, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//535
    { "const KTimeZones*", 123, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//536
    { "const KTzfileTimeZone&", 125, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//537
    { "const KTzfileTimeZoneBackend&", 126, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//538
    { "const KTzfileTimeZoneSource&", 127, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//539
    { "const KUrl&", 128, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//540
    { "const KUrl::CleanPathOption&", 128, Smoke::t_enum|Smoke::tf_ref|Smoke::tf_const },	//541
    { "const KUrl::List&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//542
    { "const KUser&", 129, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//543
    { "const KUserGroup&", 130, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//544
    { "const KWordMacroExpander&", 131, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//545
    { "const QByteArray", 136, Smoke::t_class|Smoke::tf_stack|Smoke::tf_const },	//546
    { "const QByteArray&", 136, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//547
    { "const QChar&", 137, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//548
    { "const QDBusConnection&", 140, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//549
    { "const QDBusObjectPath&", 141, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//550
    { "const QDBusSignature&", 142, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//551
    { "const QDate", 144, Smoke::t_class|Smoke::tf_stack|Smoke::tf_const },	//552
    { "const QDate&", 144, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//553
    { "const QDateTime&", 145, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//554
    { "const QFileInfo&", 148, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//555
    { "const QFlags<KUrl::DirectoryOption>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//556
    { "const QFlags<KUrl::EncodedPathAndQueryOption>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//557
    { "const QFlags<KUrl::EqualsOption>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//558
    { "const QFlags<KUrl::QueryItemsOption>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//559
    { "const QHash<QChar,QString>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//560
    { "const QHash<QChar,QStringList>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//561
    { "const QHash<QString,QString>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//562
    { "const QHash<QString,QStringList>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//563
    { "const QHostAddress&", 150, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//564
    { "const QLatin1String&", 153, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//565
    { "const QList<KAuth::Action>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//566
    { "const QList<KCatalogName>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//567
    { "const QList<KCoreConfigSkeleton::ItemEnum::Choice2>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//568
    { "const QList<KCoreConfigSkeleton::ItemEnum::Choice>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//569
    { "const QList<KJob*>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//570
    { "const QList<KSharedPtr<KService> >&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//571
    { "const QList<KTimeZone::LeapSeconds>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//572
    { "const QList<KTimeZone::Phase>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//573
    { "const QList<KTimeZone::Transition>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//574
    { "const QList<QByteArray>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//575
    { "const QList<QVariant>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//576
    { "const QList<int>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//577
    { "const QMap<QString,KTimeZone>", 0, Smoke::t_voidp|Smoke::tf_stack|Smoke::tf_const },	//578
    { "const QMap<QString,QString>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//579
    { "const QMap<QString,QVariant>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//580
    { "const QMetaObject&", 155, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//581
    { "const QMetaObject*", 155, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//582
    { "const QObject*", 158, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//583
    { "const QPair<QString,QString>&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//584
    { "const QPoint&", 160, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//585
    { "const QRect&", 162, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//586
    { "const QRegExp&", 163, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//587
    { "const QSize&", 165, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//588
    { "const QString", 0, Smoke::t_voidp|Smoke::tf_stack|Smoke::tf_const },	//589
    { "const QString&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//590
    { "const QStringList&", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//591
    { "const QStringList*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//592
    { "const QTime&", 171, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//593
    { "const QUrl&", 174, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//594
    { "const QVariant&", 175, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//595
    { "const QVariantMap&", 0, Smoke::t_voidp|Smoke::tf_stack },	//596
    { "const Sonnet::Speller&", 179, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//597
    { "const char*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//598
    { "const float", 0, Smoke::t_float|Smoke::tf_stack|Smoke::tf_const },	//599
    { "const group*", 180, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//600
    { "const int", 0, Smoke::t_int|Smoke::tf_stack|Smoke::tf_const },	//601
    { "const kndbgstream&", 181, Smoke::t_class|Smoke::tf_ref|Smoke::tf_const },	//602
    { "const passwd*", 182, Smoke::t_class|Smoke::tf_ptr|Smoke::tf_const },	//603
    { "const time_t", 0, Smoke::t_voidp|Smoke::tf_stack|Smoke::tf_const },	//604
    { "const unsigned char(&)[16]", 0, Smoke::t_voidp|Smoke::tf_ref|Smoke::tf_const },	//605
    { "const unsigned char*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//606
    { "const unsigned char[64]", 0, Smoke::t_uchar|Smoke::tf_stack|Smoke::tf_const },	//607
    { "const unsigned int", 0, Smoke::t_uint|Smoke::tf_stack|Smoke::tf_const },	//608
    { "const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//609
    { "double", 0, Smoke::t_double|Smoke::tf_stack },	//610
    { "double&", 0, Smoke::t_voidp|Smoke::tf_ref },	//611
    { "float", 0, Smoke::t_float|Smoke::tf_stack },	//612
    { "gid_t", 0, Smoke::t_voidp|Smoke::tf_stack },	//613
    { "int", 0, Smoke::t_int|Smoke::tf_stack },	//614
    { "int&", 0, Smoke::t_voidp|Smoke::tf_ref },	//615
    { "int*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//616
    { "kndbgstream*", 181, Smoke::t_class|Smoke::tf_ptr },	//617
    { "long", 0, Smoke::t_long|Smoke::tf_stack },	//618
    { "long long", 0, Smoke::t_voidp|Smoke::tf_stack },	//619
    { "long long&", 0, Smoke::t_voidp|Smoke::tf_ref },	//620
    { "mode_t", 0, Smoke::t_voidp|Smoke::tf_stack },	//621
    { "qlonglong", 0, Smoke::t_voidp|Smoke::tf_stack },	//622
    { "quint16", 0, Smoke::t_ushort|Smoke::tf_stack },	//623
    { "qulonglong", 0, Smoke::t_voidp|Smoke::tf_stack },	//624
    { "std::bidirectional_iterator_tag", 0, Smoke::t_voidp|Smoke::tf_stack },	//625
    { "std::forward_iterator_tag", 0, Smoke::t_voidp|Smoke::tf_stack },	//626
    { "std::random_access_iterator_tag", 0, Smoke::t_voidp|Smoke::tf_stack },	//627
    { "time_t", 0, Smoke::t_voidp|Smoke::tf_stack },	//628
    { "uid_t", 0, Smoke::t_voidp|Smoke::tf_stack },	//629
    { "unsigned char", 0, Smoke::t_uchar|Smoke::tf_stack },	//630
    { "unsigned char(&)[16]", 0, Smoke::t_voidp|Smoke::tf_ref },	//631
    { "unsigned int", 0, Smoke::t_uint|Smoke::tf_stack },	//632
    { "unsigned int&", 0, Smoke::t_voidp|Smoke::tf_ref },	//633
    { "unsigned long", 0, Smoke::t_ulong|Smoke::tf_stack },	//634
    { "unsigned long long", 0, Smoke::t_voidp|Smoke::tf_stack },	//635
    { "unsigned long long&", 0, Smoke::t_voidp|Smoke::tf_ref },	//636
    { "unsigned short", 0, Smoke::t_ushort|Smoke::tf_stack },	//637
    { "void(*)()", 0, Smoke::t_voidp|Smoke::tf_stack },	//638
    { "void*", 0, Smoke::t_voidp|Smoke::tf_ptr },	//639
    { "void**", 0, Smoke::t_voidp|Smoke::tf_ptr },	//640
    { "volatile const void*", 0, Smoke::t_voidp|Smoke::tf_ptr|Smoke::tf_const },	//641
};

static Smoke::Index argumentList[] = {
    0,	//0  (void)
    547, 547, 507, 547, 507, 6, 507, 507, 547, 547, 0,	//1  const QByteArray&, const QByteArray&, const KLocalizedString&, const QByteArray&, const KLocalizedString&, KAboutData::LicenseKey, const KLocalizedString&, const KLocalizedString&, const QByteArray&, const QByteArray&
    456, 0,	//12  const KAboutData&
    507, 507, 547, 547, 0,	//14  const KLocalizedString&, const KLocalizedString&, const QByteArray&, const QByteArray&
    507, 507, 547, 547, 547, 0,	//19  const KLocalizedString&, const KLocalizedString&, const QByteArray&, const QByteArray&, const QByteArray&
    507, 507, 0,	//25  const KLocalizedString&, const KLocalizedString&
    507, 0,	//28  const KLocalizedString&
    590, 0,	//30  const QString&
    547, 0,	//32  const QByteArray&
    595, 0,	//34  const QVariant&
    6, 0,	//36  KAboutData::LicenseKey
    7, 0,	//38  KAboutData::NameFormat
    547, 547, 507, 547, 0,	//40  const QByteArray&, const QByteArray&, const KLocalizedString&, const QByteArray&
    547, 547, 507, 547, 507, 0,	//45  const QByteArray&, const QByteArray&, const KLocalizedString&, const QByteArray&, const KLocalizedString&
    547, 547, 507, 547, 507, 6, 0,	//51  const QByteArray&, const QByteArray&, const KLocalizedString&, const QByteArray&, const KLocalizedString&, KAboutData::LicenseKey
    547, 547, 507, 547, 507, 6, 507, 0,	//58  const QByteArray&, const QByteArray&, const KLocalizedString&, const QByteArray&, const KLocalizedString&, KAboutData::LicenseKey, const KLocalizedString&
    547, 547, 507, 547, 507, 6, 507, 507, 0,	//66  const QByteArray&, const QByteArray&, const KLocalizedString&, const QByteArray&, const KLocalizedString&, KAboutData::LicenseKey, const KLocalizedString&, const KLocalizedString&
    547, 547, 507, 547, 507, 6, 507, 507, 547, 0,	//75  const QByteArray&, const QByteArray&, const KLocalizedString&, const QByteArray&, const KLocalizedString&, KAboutData::LicenseKey, const KLocalizedString&, const KLocalizedString&, const QByteArray&
    507, 507, 547, 0,	//85  const KLocalizedString&, const KLocalizedString&, const QByteArray&
    458, 0,	//89  const KAboutLicense&
    459, 0,	//91  const KAboutPerson&
    460, 0,	//93  const KAuth::Action&
    590, 590, 0,	//95  const QString&, const QString&
    580, 0,	//98  const QMap<QString,QVariant>&
    590, 595, 0,	//100  const QString&, const QVariant&
    450, 0,	//103  bool
    566, 312, 590, 0,	//105  const QList<KAuth::Action>&, QList<KAuth::Action>*, const QString&
    566, 312, 590, 368, 0,	//109  const QList<KAuth::Action>&, QList<KAuth::Action>*, const QString&, QWidget*
    368, 0,	//114  QWidget*
    22, 0,	//116  KAuth::ActionReply::Type
    614, 0,	//118  int
    461, 0,	//120  const KAuth::ActionReply&
    598, 0,	//122  const char*
    598, 598, 0,	//124  const char*, const char*
    598, 598, 614, 0,	//127  const char*, const char*, int
    342, 614, 640, 0,	//131  QMetaObject::Call, int, void**
    596, 0,	//135  const QVariantMap&
    590, 540, 540, 0,	//137  const QString&, const KUrl&, const KUrl&
    591, 0,	//141  const QStringList&
    540, 345, 0,	//143  const KUrl&, QObject*
    345, 0,	//146  QObject*
    540, 0,	//148  const KUrl&
    301, 0,	//150  QFlags<QIODevice::OpenModeFlag>
    540, 590, 0,	//152  const KUrl&, const QString&
    590, 345, 0,	//155  const QString&, QObject*
    590, 282, 0,	//158  const QString&, QFlags<KAutostart::Condition>
    27, 0,	//161  KAutostart::StartPhase
    590, 506, 0,	//163  const QString&, const KLocale*
    590, 195, 506, 0,	//166  const QString&, KSharedPtr<KSharedConfig>, const KLocale*
    126, 506, 0,	//170  KLocale::CalendarSystem, const KLocale*
    126, 195, 506, 0,	//173  KLocale::CalendarSystem, KSharedPtr<KSharedConfig>, const KLocale*
    126, 0,	//177  KLocale::CalendarSystem
    506, 0,	//179  const KLocale*
    519, 506, 0,	//181  const KSharedPtr<KSharedConfig>, const KLocale*
    614, 614, 614, 0,	//184  int, int, int
    614, 614, 0,	//188  int, int
    590, 614, 614, 614, 0,	//191  const QString&, int, int, int
    553, 0,	//196  const QDate&
    277, 614, 614, 614, 0,	//198  QDate&, int, int, int
    277, 614, 614, 0,	//203  QDate&, int, int
    277, 351, 614, 614, 614, 0,	//207  QDate&, QString, int, int, int
    552, 616, 616, 616, 0,	//213  const QDate, int*, int*, int*
    553, 30, 0,	//218  const QDate&, KCalendarSystem::StringFormat
    553, 614, 0,	//221  const QDate&, int
    553, 553, 616, 616, 616, 616, 0,	//224  const QDate&, const QDate&, int*, int*, int*, int*
    553, 553, 0,	//231  const QDate&, const QDate&
    553, 140, 0,	//234  const QDate&, KLocale::WeekNumberSystem
    614, 140, 0,	//237  int, KLocale::WeekNumberSystem
    553, 616, 0,	//240  const QDate&, int*
    553, 140, 616, 0,	//243  const QDate&, KLocale::WeekNumberSystem, int*
    614, 614, 29, 0,	//247  int, int, KCalendarSystem::MonthNameFormat
    553, 29, 0,	//251  const QDate&, KCalendarSystem::MonthNameFormat
    614, 31, 0,	//254  int, KCalendarSystem::WeekDayNameFormat
    553, 31, 0,	//257  const QDate&, KCalendarSystem::WeekDayNameFormat
    590, 615, 0,	//260  const QString&, int&
    553, 127, 0,	//263  const QDate&, KLocale::DateFormat
    553, 590, 131, 0,	//266  const QDate&, const QString&, KLocale::DateTimeFormatStandard
    553, 590, 133, 131, 0,	//270  const QDate&, const QString&, KLocale::DigitSet, KLocale::DateTimeFormatStandard
    553, 128, 129, 140, 0,	//275  const QDate&, KLocale::DateTimeComponent, KLocale::DateTimeComponentFormat, KLocale::WeekNumberSystem
    590, 452, 0,	//280  const QString&, bool*
    590, 135, 452, 0,	//283  const QString&, KLocale::ReadDateFlags, bool*
    590, 590, 452, 0,	//287  const QString&, const QString&, bool*
    590, 590, 452, 131, 0,	//291  const QString&, const QString&, bool*, KLocale::DateTimeFormatStandard
    614, 615, 615, 615, 0,	//296  int, int&, int&, int&
    614, 614, 614, 615, 0,	//301  int, int, int, int&
    32, 519, 506, 0,	//306  KCalendarSystemPrivate&, const KSharedPtr<KSharedConfig>, const KLocale*
    590, 195, 0,	//310  const QString&, KSharedPtr<KSharedConfig>
    126, 195, 0,	//313  KLocale::CalendarSystem, KSharedPtr<KSharedConfig>
    519, 0,	//316  const KSharedPtr<KSharedConfig>
    553, 590, 0,	//318  const QDate&, const QString&
    553, 590, 133, 0,	//321  const QDate&, const QString&, KLocale::DigitSet
    553, 128, 0,	//325  const QDate&, KLocale::DateTimeComponent
    553, 128, 129, 0,	//328  const QDate&, KLocale::DateTimeComponent, KLocale::DateTimeComponentFormat
    590, 135, 0,	//332  const QString&, KLocale::ReadDateFlags
    32, 0,	//335  KCalendarSystemPrivate&
    32, 519, 0,	//337  KCalendarSystemPrivate&, const KSharedPtr<KSharedConfig>
    266, 0,	//340  QChar
    590, 614, 355, 0,	//342  const QString&, int, QStringList&
    266, 355, 0,	//346  QChar, QStringList&
    463, 0,	//349  const KCharMacroExpander&
    590, 451, 0,	//351  const QString&, bool&
    548, 0,	//354  const QChar&
    464, 0,	//356  const KCharsets&
    614, 455, 547, 547, 507, 547, 507, 283, 0,	//358  int, char**, const QByteArray&, const QByteArray&, const KLocalizedString&, const QByteArray&, const KLocalizedString&, QFlags<KCmdLineArgs::StdCmdLineArg>
    614, 455, 457, 283, 0,	//367  int, char**, const KAboutData*, QFlags<KCmdLineArgs::StdCmdLineArg>
    457, 0,	//372  const KAboutData*
    283, 0,	//374  QFlags<KCmdLineArgs::StdCmdLineArg>
    466, 507, 547, 547, 0,	//376  const KCmdLineOptions&, const KLocalizedString&, const QByteArray&, const QByteArray&
    273, 0,	//381  QDataStream&
    466, 507, 547, 0,	//383  const KCmdLineOptions&, const KLocalizedString&, const QByteArray&
    465, 0,	//387  const KCmdLineArgs&
    614, 455, 547, 547, 507, 547, 0,	//389  int, char**, const QByteArray&, const QByteArray&, const KLocalizedString&, const QByteArray&
    614, 455, 547, 547, 507, 547, 507, 0,	//396  int, char**, const QByteArray&, const QByteArray&, const KLocalizedString&, const QByteArray&, const KLocalizedString&
    614, 455, 457, 0,	//404  int, char**, const KAboutData*
    466, 0,	//408  const KCmdLineOptions&
    466, 507, 0,	//410  const KCmdLineOptions&, const KLocalizedString&
    547, 507, 547, 0,	//413  const QByteArray&, const KLocalizedString&, const QByteArray&
    547, 507, 0,	//417  const QByteArray&, const KLocalizedString&
    547, 265, 0,	//420  const QByteArray&, QByteArray&
    547, 450, 0,	//423  const QByteArray&, bool
    547, 265, 450, 0,	//426  const QByteArray&, QByteArray&, bool
    467, 0,	//430  const KComponentData&
    547, 547, 43, 0,	//432  const QByteArray&, const QByteArray&, KComponentData::MainComponentRegistration
    456, 43, 0,	//436  const KAboutData&, KComponentData::MainComponentRegistration
    457, 43, 0,	//439  const KAboutData*, KComponentData::MainComponentRegistration
    547, 547, 0,	//442  const QByteArray&, const QByteArray&
    109, 0,	//445  KJob*
    109, 590, 590, 0,	//447  KJob*, const QString&, const QString&
    45, 345, 0,	//451  KCompositeJobPrivate&, QObject*
    590, 284, 598, 0,	//454  const QString&, QFlags<KConfig::OpenFlag>, const char*
    467, 590, 284, 598, 0,	//458  const KComponentData&, const QString&, QFlags<KConfig::OpenFlag>, const char*
    590, 590, 598, 0,	//463  const QString&, const QString&, const char*
    590, 46, 0,	//467  const QString&, KConfig*
    547, 285, 0,	//470  const QByteArray&, QFlags<KConfigBase::WriteConfigFlag>
    54, 0,	//473  KConfigPrivate&
    590, 284, 0,	//475  const QString&, QFlags<KConfig::OpenFlag>
    467, 590, 0,	//478  const KComponentData&, const QString&
    467, 590, 284, 0,	//481  const KComponentData&, const QString&, QFlags<KConfig::OpenFlag>
    590, 285, 0,	//485  const QString&, QFlags<KConfigBase::WriteConfigFlag>
    598, 285, 0,	//488  const char*, QFlags<KConfigBase::WriteConfigFlag>
    469, 0,	//491  const KConfigBase&
    48, 590, 0,	//493  KConfigBase*, const QString&
    48, 598, 0,	//496  KConfigBase*, const char*
    470, 590, 0,	//499  const KConfigBase*, const QString&
    470, 598, 0,	//502  const KConfigBase*, const char*
    520, 590, 0,	//505  const KSharedPtr<KSharedConfig>&, const QString&
    520, 598, 0,	//508  const KSharedPtr<KSharedConfig>&, const char*
    472, 0,	//511  const KConfigGroup&
    48, 285, 0,	//513  KConfigBase*, QFlags<KConfigBase::WriteConfigFlag>
    285, 0,	//516  QFlags<KConfigBase::WriteConfigFlag>
    598, 595, 0,	//518  const char*, const QVariant&
    598, 590, 0,	//521  const char*, const QString&
    590, 598, 0,	//524  const QString&, const char*
    590, 576, 0,	//527  const QString&, const QList<QVariant>&
    598, 576, 0,	//530  const char*, const QList<QVariant>&
    590, 591, 0,	//533  const QString&, const QStringList&
    598, 591, 0,	//536  const char*, const QStringList&
    590, 595, 285, 0,	//539  const QString&, const QVariant&, QFlags<KConfigBase::WriteConfigFlag>
    598, 595, 285, 0,	//543  const char*, const QVariant&, QFlags<KConfigBase::WriteConfigFlag>
    590, 590, 285, 0,	//547  const QString&, const QString&, QFlags<KConfigBase::WriteConfigFlag>
    598, 590, 285, 0,	//551  const char*, const QString&, QFlags<KConfigBase::WriteConfigFlag>
    590, 547, 285, 0,	//555  const QString&, const QByteArray&, QFlags<KConfigBase::WriteConfigFlag>
    598, 547, 285, 0,	//559  const char*, const QByteArray&, QFlags<KConfigBase::WriteConfigFlag>
    590, 598, 285, 0,	//563  const QString&, const char*, QFlags<KConfigBase::WriteConfigFlag>
    598, 598, 285, 0,	//567  const char*, const char*, QFlags<KConfigBase::WriteConfigFlag>
    590, 591, 285, 0,	//571  const QString&, const QStringList&, QFlags<KConfigBase::WriteConfigFlag>
    598, 591, 285, 0,	//575  const char*, const QStringList&, QFlags<KConfigBase::WriteConfigFlag>
    590, 576, 285, 0,	//579  const QString&, const QList<QVariant>&, QFlags<KConfigBase::WriteConfigFlag>
    598, 576, 285, 0,	//583  const char*, const QList<QVariant>&, QFlags<KConfigBase::WriteConfigFlag>
    48, 0,	//587  KConfigBase*
    590, 547, 0,	//589  const QString&, const QByteArray&
    598, 547, 0,	//592  const char*, const QByteArray&
    46, 0,	//595  KConfig*
    473, 0,	//597  const KConfigSkeletonItem&
    195, 345, 0,	//599  KSharedPtr<KSharedConfig>, QObject*
    55, 590, 0,	//602  KConfigSkeletonItem*, const QString&
    590, 352, 590, 590, 0,	//605  const QString&, QString&, const QString&, const QString&
    590, 365, 595, 590, 0,	//610  const QString&, QVariant&, const QVariant&, const QString&
    590, 451, 450, 590, 0,	//615  const QString&, bool&, bool, const QString&
    590, 615, 614, 590, 0,	//620  const QString&, int&, int, const QString&
    590, 633, 632, 590, 0,	//625  const QString&, unsigned int&, unsigned int, const QString&
    590, 620, 619, 590, 0,	//630  const QString&, long long&, long long, const QString&
    590, 636, 635, 590, 0,	//635  const QString&, unsigned long long&, unsigned long long, const QString&
    590, 611, 610, 590, 0,	//640  const QString&, double&, double, const QString&
    590, 348, 586, 590, 0,	//645  const QString&, QRect&, const QRect&, const QString&
    590, 347, 585, 590, 0,	//650  const QString&, QPoint&, const QPoint&, const QString&
    590, 350, 588, 590, 0,	//655  const QString&, QSize&, const QSize&, const QString&
    590, 279, 554, 590, 0,	//660  const QString&, QDateTime&, const QDateTime&, const QString&
    590, 355, 591, 590, 0,	//665  const QString&, QStringList&, const QStringList&, const QString&
    590, 338, 577, 590, 0,	//670  const QString&, QList<int>&, const QList<int>&, const QString&
    195, 0,	//675  KSharedPtr<KSharedConfig>
    55, 0,	//677  KConfigSkeletonItem*
    590, 352, 0,	//679  const QString&, QString&
    590, 352, 590, 0,	//682  const QString&, QString&, const QString&
    590, 365, 0,	//686  const QString&, QVariant&
    590, 365, 595, 0,	//689  const QString&, QVariant&, const QVariant&
    590, 451, 450, 0,	//693  const QString&, bool&, bool
    590, 615, 614, 0,	//697  const QString&, int&, int
    590, 633, 0,	//701  const QString&, unsigned int&
    590, 633, 632, 0,	//704  const QString&, unsigned int&, unsigned int
    590, 620, 0,	//708  const QString&, long long&
    590, 620, 619, 0,	//711  const QString&, long long&, long long
    590, 636, 0,	//715  const QString&, unsigned long long&
    590, 636, 635, 0,	//718  const QString&, unsigned long long&, unsigned long long
    590, 611, 0,	//722  const QString&, double&
    590, 611, 610, 0,	//725  const QString&, double&, double
    590, 348, 0,	//729  const QString&, QRect&
    590, 348, 586, 0,	//732  const QString&, QRect&, const QRect&
    590, 347, 0,	//736  const QString&, QPoint&
    590, 347, 585, 0,	//739  const QString&, QPoint&, const QPoint&
    590, 350, 0,	//743  const QString&, QSize&
    590, 350, 588, 0,	//746  const QString&, QSize&, const QSize&
    590, 279, 0,	//750  const QString&, QDateTime&
    590, 279, 554, 0,	//753  const QString&, QDateTime&, const QDateTime&
    590, 355, 0,	//757  const QString&, QStringList&
    590, 355, 591, 0,	//760  const QString&, QStringList&, const QStringList&
    590, 338, 0,	//764  const QString&, QList<int>&
    590, 338, 577, 0,	//767  const QString&, QList<int>&, const QList<int>&
    590, 590, 451, 450, 0,	//771  const QString&, const QString&, bool&, bool
    474, 0,	//776  const KCoreConfigSkeleton::ItemBool&
    590, 590, 451, 0,	//778  const QString&, const QString&, bool&
    590, 590, 279, 554, 0,	//782  const QString&, const QString&, QDateTime&, const QDateTime&
    475, 0,	//787  const KCoreConfigSkeleton::ItemDateTime&
    590, 590, 279, 0,	//789  const QString&, const QString&, QDateTime&
    590, 590, 611, 610, 0,	//793  const QString&, const QString&, double&, double
    610, 0,	//798  double
    476, 0,	//800  const KCoreConfigSkeleton::ItemDouble&
    590, 590, 611, 0,	//802  const QString&, const QString&, double&
    590, 590, 615, 569, 614, 0,	//806  const QString&, const QString&, int&, const QList<KCoreConfigSkeleton::ItemEnum::Choice>&, int
    590, 590, 615, 568, 614, 0,	//812  const QString&, const QString&, int&, const QList<KCoreConfigSkeleton::ItemEnum::Choice2>&, int
    477, 0,	//818  const KCoreConfigSkeleton::ItemEnum&
    590, 590, 615, 569, 0,	//820  const QString&, const QString&, int&, const QList<KCoreConfigSkeleton::ItemEnum::Choice>&
    590, 590, 615, 568, 0,	//825  const QString&, const QString&, int&, const QList<KCoreConfigSkeleton::ItemEnum::Choice2>&
    478, 0,	//830  const KCoreConfigSkeleton::ItemEnum::Choice&
    479, 0,	//832  const KCoreConfigSkeleton::ItemEnum::Choice2&
    590, 590, 615, 614, 0,	//834  const QString&, const QString&, int&, int
    480, 0,	//839  const KCoreConfigSkeleton::ItemInt&
    590, 590, 615, 0,	//841  const QString&, const QString&, int&
    590, 590, 338, 577, 0,	//845  const QString&, const QString&, QList<int>&, const QList<int>&
    481, 0,	//850  const KCoreConfigSkeleton::ItemIntList&
    590, 590, 338, 0,	//852  const QString&, const QString&, QList<int>&
    590, 590, 620, 619, 0,	//856  const QString&, const QString&, long long&, long long
    619, 0,	//861  long long
    482, 0,	//863  const KCoreConfigSkeleton::ItemLongLong&
    590, 590, 620, 0,	//865  const QString&, const QString&, long long&
    590, 590, 352, 590, 0,	//869  const QString&, const QString&, QString&, const QString&
    483, 0,	//874  const KCoreConfigSkeleton::ItemPassword&
    590, 590, 352, 0,	//876  const QString&, const QString&, QString&
    484, 0,	//880  const KCoreConfigSkeleton::ItemPath&
    590, 590, 355, 591, 0,	//882  const QString&, const QString&, QStringList&, const QStringList&
    485, 0,	//887  const KCoreConfigSkeleton::ItemPathList&
    590, 590, 355, 0,	//889  const QString&, const QString&, QStringList&
    590, 590, 347, 585, 0,	//893  const QString&, const QString&, QPoint&, const QPoint&
    486, 0,	//898  const KCoreConfigSkeleton::ItemPoint&
    590, 590, 347, 0,	//900  const QString&, const QString&, QPoint&
    590, 590, 365, 595, 0,	//904  const QString&, const QString&, QVariant&, const QVariant&
    487, 0,	//909  const KCoreConfigSkeleton::ItemProperty&
    590, 590, 365, 0,	//911  const QString&, const QString&, QVariant&
    590, 590, 348, 586, 0,	//915  const QString&, const QString&, QRect&, const QRect&
    488, 0,	//920  const KCoreConfigSkeleton::ItemRect&
    590, 590, 348, 0,	//922  const QString&, const QString&, QRect&
    590, 590, 350, 588, 0,	//926  const QString&, const QString&, QSize&, const QSize&
    489, 0,	//931  const KCoreConfigSkeleton::ItemSize&
    590, 590, 350, 0,	//933  const QString&, const QString&, QSize&
    590, 590, 352, 590, 76, 0,	//937  const QString&, const QString&, QString&, const QString&, KCoreConfigSkeleton::ItemString::Type
    490, 0,	//943  const KCoreConfigSkeleton::ItemString&
    491, 0,	//945  const KCoreConfigSkeleton::ItemStringList&
    590, 590, 633, 632, 0,	//947  const QString&, const QString&, unsigned int&, unsigned int
    632, 0,	//952  unsigned int
    492, 0,	//954  const KCoreConfigSkeleton::ItemUInt&
    590, 590, 633, 0,	//956  const QString&, const QString&, unsigned int&
    590, 590, 636, 635, 0,	//960  const QString&, const QString&, unsigned long long&, unsigned long long
    635, 0,	//965  unsigned long long
    493, 0,	//967  const KCoreConfigSkeleton::ItemULongLong&
    590, 590, 636, 0,	//969  const QString&, const QString&, unsigned long long&
    590, 590, 240, 540, 0,	//973  const QString&, const QString&, KUrl&, const KUrl&
    494, 0,	//978  const KCoreConfigSkeleton::ItemUrl&
    590, 590, 240, 0,	//980  const QString&, const QString&, KUrl&
    590, 590, 248, 542, 0,	//984  const QString&, const QString&, KUrl::List&, const KUrl::List&
    495, 0,	//989  const KCoreConfigSkeleton::ItemUrlList&
    590, 590, 248, 0,	//991  const QString&, const QString&, KUrl::List&
    555, 590, 0,	//995  const QFileInfo&, const QString&
    496, 0,	//998  const KCurrencyCode&
    590, 286, 0,	//1000  const QString&, QFlags<KCurrencyCode::CurrencyStatus>
    286, 0,	//1003  QFlags<KCurrencyCode::CurrencyStatus>
    555, 0,	//1005  const QFileInfo&
    590, 621, 0,	//1007  const QString&, mode_t
    590, 614, 621, 0,	//1010  const QString&, int, mode_t
    590, 614, 0,	//1014  const QString&, int
    85, 0,	//1017  KDEDModule*
    622, 0,	//1019  qlonglong
    550, 0,	//1021  const QDBusObjectPath&
    497, 0,	//1023  const KDEPluginVerificationData&
    630, 0,	//1025  unsigned char
    553, 499, 0,	//1027  const QDate&, const KDateTime::Spec&
    553, 593, 499, 0,	//1030  const QDate&, const QTime&, const KDateTime::Spec&
    554, 499, 0,	//1034  const QDateTime&, const KDateTime::Spec&
    554, 0,	//1037  const QDateTime&
    498, 0,	//1039  const KDateTime&
    525, 0,	//1041  const KTimeZone&
    499, 0,	//1043  const KDateTime::Spec&
    593, 0,	//1045  const QTime&
    95, 0,	//1047  KDateTime::TimeFormat
    590, 95, 452, 0,	//1049  const QString&, KDateTime::TimeFormat, bool*
    590, 590, 536, 450, 0,	//1053  const QString&, const QString&, const KTimeZones*, bool
    553, 593, 0,	//1058  const QDate&, const QTime&
    590, 95, 0,	//1061  const QString&, KDateTime::TimeFormat
    590, 590, 536, 0,	//1064  const QString&, const QString&, const KTimeZones*
    94, 614, 0,	//1068  KDateTime::SpecType, int
    94, 0,	//1071  KDateTime::SpecType
    444, 598, 614, 598, 0,	//1073  QtMsgType, const char*, int, const char*
    444, 450, 614, 450, 0,	//1078  QtMsgType, bool, int, bool
    450, 614, 0,	//1083  bool, int
    500, 0,	//1086  const KDebug&
    444, 0,	//1088  QtMsgType
    444, 598, 0,	//1090  QtMsgType, const char*
    444, 598, 614, 0,	//1093  QtMsgType, const char*, int
    501, 0,	//1097  const KDebugTag&
    359, 101, 100, 0,	//1099  QTextCodec*, KEncodingDetector::EncodingChoiceSource, KEncodingDetector::AutoDetectScript
    598, 101, 0,	//1103  const char*, KEncodingDetector::EncodingChoiceSource
    100, 0,	//1106  KEncodingDetector::AutoDetectScript
    598, 614, 0,	//1108  const char*, int
    454, 614, 0,	//1111  char*, int
    503, 0,	//1114  const KEncodingDetector&
    359, 101, 0,	//1116  QTextCodec*, KEncodingDetector::EncodingChoiceSource
    104, 0,	//1119  KEncodingProber::ProberType
    504, 0,	//1121  const KEncodingProber&
    305, 450, 0,	//1123  QIODevice*, bool
    454, 632, 0,	//1126  char*, unsigned int
    598, 632, 0,	//1129  const char*, unsigned int
    106, 0,	//1132  KFilterBase::FilterFlags
    305, 0,	//1134  QIODevice*
    590, 590, 450, 0,	//1136  const QString&, const QString&, bool
    305, 590, 450, 0,	//1140  QIODevice*, const QString&, bool
    454, 619, 0,	//1144  char*, long long
    598, 619, 0,	//1147  const char*, long long
    305, 590, 0,	//1150  QIODevice*, const QString&
    123, 108, 0,	//1153  KLocale*, KGlobal::CopyCatalogs
    123, 0,	//1156  KLocale*
    583, 581, 0,	//1158  const QObject*, const QMetaObject&
    115, 0,	//1161  KJobUiDelegate*
    111, 0,	//1163  KJob::KillVerbosity
    287, 0,	//1165  QFlags<KJob::Capability>
    112, 0,	//1167  KJob::Unit
    109, 590, 584, 584, 0,	//1169  KJob*, const QString&, const QPair<QString,QString>&, const QPair<QString,QString>&
    112, 635, 0,	//1174  KJob::Unit, unsigned long long
    634, 0,	//1177  unsigned long
    635, 635, 0,	//1179  unsigned long long, unsigned long long
    113, 345, 0,	//1182  KJobPrivate&, QObject*
    109, 590, 0,	//1185  KJob*, const QString&
    109, 590, 584, 0,	//1188  KJob*, const QString&, const QPair<QString,QString>&
    109, 112, 624, 0,	//1192  KJob*, KJob::Unit, qulonglong
    109, 634, 0,	//1196  KJob*, unsigned long
    590, 302, 0,	//1199  const QString&, QFlags<QLibrary::LoadHint>
    590, 467, 0,	//1202  const QString&, const KComponentData&
    590, 467, 345, 0,	//1205  const QString&, const KComponentData&, QObject*
    590, 614, 467, 345, 0,	//1209  const QString&, int, const KComponentData&, QObject*
    590, 614, 467, 0,	//1214  const QString&, int, const KComponentData&
    590, 301, 0,	//1218  const QString&, QFlags<QIODevice::OpenModeFlag>
    590, 120, 301, 0,	//1221  const QString&, KLocalSocket::LocalSocketType, QFlags<QIODevice::OpenModeFlag>
    590, 623, 306, 0,	//1225  const QString&, quint16, QIODevice::OpenMode
    590, 120, 0,	//1229  const QString&, KLocalSocket::LocalSocketType
    614, 452, 0,	//1232  int, bool*
    590, 590, 590, 46, 0,	//1235  const QString&, const QString&, const QString&, KConfig*
    505, 0,	//1240  const KLocale&
    598, 598, 353, 353, 0,	//1242  const char*, const char*, QString*, QString*
    598, 353, 353, 0,	//1247  const char*, QString*, QString*
    598, 598, 598, 353, 353, 0,	//1251  const char*, const char*, const char*, QString*, QString*
    598, 598, 598, 634, 353, 353, 0,	//1257  const char*, const char*, const char*, unsigned long, QString*, QString*
    598, 598, 634, 353, 353, 0,	//1264  const char*, const char*, unsigned long, QString*, QString*
    598, 598, 598, 598, 634, 353, 353, 0,	//1270  const char*, const char*, const char*, const char*, unsigned long, QString*, QString*
    133, 450, 0,	//1278  KLocale::DigitSet, bool
    610, 590, 614, 0,	//1281  double, const QString&, int
    610, 614, 0,	//1285  double, int
    590, 450, 614, 0,	//1288  const QString&, bool, int
    618, 0,	//1292  long
    610, 614, 125, 124, 0,	//1294  double, int, KLocale::BinaryUnitDialect, KLocale::BinarySizeUnits
    125, 0,	//1299  KLocale::BinaryUnitDialect
    554, 127, 450, 0,	//1301  const QDateTime&, KLocale::DateFormat, bool
    498, 127, 289, 0,	//1305  const KDateTime&, KLocale::DateFormat, QFlags<KLocale::DateTimeFormatOption>
    593, 450, 450, 0,	//1309  const QTime&, bool, bool
    593, 290, 0,	//1313  const QTime&, QFlags<KLocale::TimeFormatOption>
    593, 129, 0,	//1316  const QTime&, KLocale::DateTimeComponentFormat
    140, 0,	//1319  KLocale::WeekNumberSystem
    590, 136, 452, 0,	//1321  const QString&, KLocale::ReadTimeFlags, bool*
    590, 452, 290, 291, 0,	//1325  const QString&, bool*, QFlags<KLocale::TimeFormatOption>, QFlags<KLocale::TimeProcessingOption>
    133, 0,	//1330  KLocale::DigitSet
    137, 0,	//1332  KLocale::SignPosition
    134, 0,	//1334  KLocale::MeasureSystem
    598, 598, 598, 0,	//1336  const char*, const char*, const char*
    590, 352, 352, 352, 352, 0,	//1340  const QString&, QString&, QString&, QString&, QString&
    590, 133, 450, 0,	//1346  const QString&, KLocale::DigitSet, bool
    590, 590, 590, 0,	//1350  const QString&, const QString&, const QString&
    610, 590, 0,	//1354  double, const QString&
    590, 450, 0,	//1357  const QString&, bool
    610, 614, 125, 0,	//1360  double, int, KLocale::BinaryUnitDialect
    554, 127, 0,	//1364  const QDateTime&, KLocale::DateFormat
    498, 127, 0,	//1367  const KDateTime&, KLocale::DateFormat
    593, 450, 0,	//1370  const QTime&, bool
    590, 136, 0,	//1373  const QString&, KLocale::ReadTimeFlags
    590, 452, 290, 0,	//1376  const QString&, bool*, QFlags<KLocale::TimeFormatOption>
    590, 133, 0,	//1380  const QString&, KLocale::DigitSet
    506, 590, 0,	//1383  const KLocale*, const QString&
    614, 614, 614, 548, 0,	//1386  int, int, int, const QChar&
    632, 614, 614, 548, 0,	//1391  unsigned int, int, int, const QChar&
    618, 614, 614, 548, 0,	//1396  long, int, int, const QChar&
    634, 614, 614, 548, 0,	//1401  unsigned long, int, int, const QChar&
    619, 614, 614, 548, 0,	//1406  long long, int, int, const QChar&
    635, 614, 614, 548, 0,	//1411  unsigned long long, int, int, const QChar&
    610, 614, 453, 614, 548, 0,	//1416  double, int, char, int, const QChar&
    266, 614, 548, 0,	//1422  QChar, int, const QChar&
    590, 614, 548, 0,	//1426  const QString&, int, const QChar&
    591, 567, 0,	//1430  const QStringList&, const QList<KCatalogName>&
    632, 614, 0,	//1433  unsigned int, int
    632, 614, 614, 0,	//1436  unsigned int, int, int
    618, 614, 0,	//1440  long, int
    618, 614, 614, 0,	//1443  long, int, int
    634, 614, 0,	//1447  unsigned long, int
    634, 614, 614, 0,	//1450  unsigned long, int, int
    619, 614, 0,	//1454  long long, int
    619, 614, 614, 0,	//1457  long long, int, int
    635, 614, 0,	//1461  unsigned long long, int
    635, 614, 614, 0,	//1464  unsigned long long, int, int
    610, 614, 453, 0,	//1468  double, int, char
    610, 614, 453, 614, 0,	//1472  double, int, char, int
    266, 614, 0,	//1477  QChar, int
    292, 0,	//1480  QFlags<KLockFile::LockFlag>
    615, 352, 352, 0,	//1482  int&, QString&, QString&
    508, 0,	//1486  const KLockFile&
    606, 614, 0,	//1488  const unsigned char*, int
    304, 0,	//1491  QIODevice&
    631, 0,	//1493  unsigned char(&)[16]
    265, 0,	//1495  QByteArray&
    605, 0,	//1497  const unsigned char(&)[16]
    607, 0,	//1499  const unsigned char[64]
    606, 0,	//1501  const unsigned char*
    590, 560, 266, 0,	//1503  const QString&, const QHash<QChar,QString>&, QChar
    590, 560, 0,	//1507  const QString&, const QHash<QChar,QString>&
    590, 563, 266, 0,	//1510  const QString&, const QHash<QString,QStringList>&, QChar
    590, 563, 0,	//1514  const QString&, const QHash<QString,QStringList>&
    590, 561, 266, 0,	//1517  const QString&, const QHash<QChar,QStringList>&, QChar
    590, 561, 0,	//1521  const QString&, const QHash<QChar,QStringList>&
    590, 562, 266, 0,	//1524  const QString&, const QHash<QString,QString>&, QChar
    590, 562, 0,	//1528  const QString&, const QHash<QString,QString>&
    352, 0,	//1531  QString&
    352, 615, 0,	//1533  QString&, int&
    509, 0,	//1536  const KMacroExpanderBase&
    150, 0,	//1538  KMessageHandler*
    149, 590, 590, 0,	//1540  KMessage::MessageType, const QString&, const QString&
    149, 590, 0,	//1544  KMessage::MessageType, const QString&
    510, 0,	//1547  const KMessageHandler&
    540, 621, 0,	//1549  const KUrl&, mode_t
    590, 153, 0,	//1552  const QString&, KMimeType::FindByNameOption
    540, 621, 450, 450, 616, 0,	//1555  const KUrl&, mode_t, bool, bool, int*
    590, 621, 450, 616, 0,	//1561  const QString&, mode_t, bool, int*
    547, 616, 0,	//1566  const QByteArray&, int*
    590, 547, 621, 616, 0,	//1569  const QString&, const QByteArray&, mode_t, int*
    305, 616, 0,	//1574  QIODevice*, int*
    590, 305, 621, 616, 0,	//1577  const QString&, QIODevice*, mode_t, int*
    590, 616, 0,	//1582  const QString&, int*
    273, 614, 0,	//1585  QDataStream&, int
    154, 0,	//1588  KMimeTypePrivate&
    154, 590, 590, 0,	//1590  KMimeTypePrivate&, const QString&, const QString&
    540, 621, 450, 0,	//1594  const KUrl&, mode_t, bool
    540, 621, 450, 450, 0,	//1598  const KUrl&, mode_t, bool, bool
    590, 621, 450, 0,	//1603  const QString&, mode_t, bool
    590, 547, 621, 0,	//1607  const QString&, const QByteArray&, mode_t
    590, 305, 0,	//1611  const QString&, QIODevice*
    590, 305, 621, 0,	//1614  const QString&, QIODevice*, mode_t
    511, 0,	//1618  const KMimeTypeTrader&
    598, 598, 345, 0,	//1620  const char*, const char*, QObject*
    456, 345, 0,	//1624  const KAboutData&, QObject*
    457, 345, 0,	//1627  const KAboutData*, QObject*
    345, 598, 591, 0,	//1630  QObject*, const char*, const QStringList&
    158, 345, 0,	//1634  KPluginFactoryPrivate&, QObject*
    576, 0,	//1637  const QList<QVariant>&
    368, 345, 598, 591, 0,	//1639  QWidget*, QObject*, const char*, const QStringList&
    598, 368, 345, 576, 590, 0,	//1644  const char*, QWidget*, QObject*, const QList<QVariant>&, const QString&
    345, 598, 0,	//1650  QObject*, const char*
    158, 0,	//1653  KPluginFactoryPrivate&
    518, 0,	//1655  const KSharedPtr<KService>
    571, 472, 0,	//1657  const QList<KSharedPtr<KService> >&, const KConfigGroup&
    591, 472, 0,	//1660  const QStringList&, const KConfigGroup&
    590, 472, 0,	//1663  const QString&, const KConfigGroup&
    51, 0,	//1666  KConfigGroup
    512, 0,	//1668  const KPluginInfo&
    571, 0,	//1670  const QList<KSharedPtr<KService> >&
    515, 467, 345, 0,	//1672  const KService&, const KComponentData&, QObject*
    515, 0,	//1676  const KService&
    515, 467, 0,	//1678  const KService&, const KComponentData&
    165, 0,	//1681  KProcess::OutputChannelMode
    590, 591, 614, 0,	//1683  const QString&, const QStringList&, int
    591, 614, 0,	//1687  const QStringList&, int
    166, 345, 0,	//1690  KProcessPrivate*, QObject*
    173, 0,	//1693  KProtocolInfo::Type
    590, 171, 0,	//1695  const QString&, KProtocolInfo::ExtraField::Type
    513, 0,	//1698  const KProtocolInfo::ExtraField&
    171, 0,	//1700  KProtocolInfo::ExtraField::Type
    514, 0,	//1702  const KRandomSequence&
    590, 590, 590, 608, 0,	//1704  const QString&, const QString&, const QString&, const unsigned int
    502, 0,	//1709  const KDesktopFile*
    517, 0,	//1711  const KServiceType*
    590, 366, 0,	//1713  const QString&, QVariant::Type
    450, 590, 353, 592, 0,	//1716  bool, const QString&, QString*, const QStringList*
    450, 590, 0,	//1721  bool, const QString&
    450, 590, 353, 0,	//1724  bool, const QString&, QString*
    590, 590, 590, 590, 450, 0,	//1728  const QString&, const QString&, const QString&, const QString&, bool
    516, 0,	//1734  const KServiceAction&
    590, 590, 590, 590, 0,	//1736  const QString&, const QString&, const QString&, const QString&
    273, 614, 450, 0,	//1741  QDataStream&, int, bool
    450, 450, 450, 450, 0,	//1745  bool, bool, bool, bool
    450, 450, 0,	//1750  bool, bool
    293, 0,	//1753  QFlags<KServiceGroup::EntriesOption>
    521, 0,	//1755  const KSharedPtr<KSycocaEntry>&
    450, 450, 450, 0,	//1757  bool, bool, bool
    98, 0,	//1761  KDesktopFile*
    188, 0,	//1763  KServiceTypePrivate&
    188, 590, 590, 0,	//1765  KServiceTypePrivate&, const QString&, const QString&
    324, 590, 0,	//1769  QList<KSharedPtr<KService> >&, const QString&
    590, 294, 198, 0,	//1772  const QString&, QFlags<KShell::Option>, KShell::Errors*
    590, 294, 0,	//1776  const QString&, QFlags<KShell::Option>
    590, 590, 637, 345, 0,	//1779  const QString&, const QString&, unsigned short, QObject*
    590, 590, 637, 0,	//1784  const QString&, const QString&, unsigned short
    594, 614, 345, 0,	//1788  const QUrl&, int, QObject*
    594, 0,	//1792  const QUrl&
    594, 614, 0,	//1794  const QUrl&, int
    590, 564, 637, 345, 0,	//1797  const QString&, const QHostAddress&, unsigned short, QObject*
    590, 564, 0,	//1802  const QString&, const QHostAddress&
    590, 564, 637, 0,	//1805  const QString&, const QHostAddress&, unsigned short
    358, 590, 590, 637, 0,	//1809  QTcpSocket*, const QString&, const QString&, unsigned short
    594, 345, 0,	//1814  const QUrl&, QObject*
    590, 590, 637, 614, 345, 0,	//1817  const QString&, const QString&, unsigned short, int, QObject*
    590, 590, 637, 614, 0,	//1823  const QString&, const QString&, unsigned short, int
    358, 594, 0,	//1828  QTcpSocket*, const QUrl&
    590, 590, 345, 0,	//1831  const QString&, const QString&, QObject*
    358, 594, 614, 0,	//1835  QTcpSocket*, const QUrl&, int
    358, 590, 590, 637, 614, 0,	//1839  QTcpSocket*, const QString&, const QString&, unsigned short, int
    598, 590, 450, 0,	//1845  const char*, const QString&, bool
    598, 598, 590, 450, 0,	//1849  const char*, const char*, const QString&, bool
    598, 598, 598, 450, 0,	//1854  const char*, const char*, const char*, bool
    598, 590, 295, 0,	//1859  const char*, const QString&, QFlags<KStandardDirs::SearchOption>
    598, 590, 295, 355, 0,	//1863  const char*, const QString&, QFlags<KStandardDirs::SearchOption>, QStringList&
    590, 590, 295, 0,	//1868  const QString&, const QString&, QFlags<KStandardDirs::SearchOption>
    355, 590, 590, 295, 0,	//1872  QStringList&, const QString&, const QString&, QFlags<KStandardDirs::SearchOption>
    598, 590, 467, 0,	//1877  const char*, const QString&, const KComponentData&
    598, 590, 450, 467, 0,	//1881  const char*, const QString&, bool, const KComponentData&
    598, 598, 590, 0,	//1886  const char*, const char*, const QString&
    355, 590, 0,	//1890  QStringList&, const QString&
    355, 590, 590, 0,	//1893  QStringList&, const QString&, const QString&
    590, 590, 614, 0,	//1897  const QString&, const QString&, int
    590, 590, 378, 0,	//1901  const QString&, const QString&, Qt::CaseSensitivity
    548, 590, 614, 0,	//1905  const QChar&, const QString&, int
    548, 590, 0,	//1909  const QChar&, const QString&
    587, 590, 614, 0,	//1912  const QRegExp&, const QString&, int
    587, 590, 0,	//1916  const QRegExp&, const QString&
    614, 211, 0,	//1919  int, KSycocaType&
    208, 0,	//1922  KSycocaFactoryId
    1, 0,	//1924  DatabaseType
    207, 0,	//1926  KSycocaFactory*
    274, 0,	//1928  QDataStream*
    210, 0,	//1930  KSycocaType
    273, 352, 0,	//1932  QDataStream&, QString&
    273, 355, 0,	//1935  QDataStream&, QStringList&
    206, 0,	//1938  KSycocaEntryPrivate&
    214, 590, 590, 612, 612, 590, 0,	//1940  KSystemTimeZoneSource*, const QString&, const QString&, float, float, const QString&
    522, 0,	//1947  const KSystemTimeZone&
    214, 590, 0,	//1949  KSystemTimeZoneSource*, const QString&
    214, 590, 590, 0,	//1952  KSystemTimeZoneSource*, const QString&, const QString&
    214, 590, 590, 612, 0,	//1956  KSystemTimeZoneSource*, const QString&, const QString&, float
    214, 590, 590, 612, 612, 0,	//1961  KSystemTimeZoneSource*, const QString&, const QString&, float, float
    526, 554, 616, 0,	//1967  const KTimeZone*, const QDateTime&, int*
    526, 554, 0,	//1971  const KTimeZone*, const QDateTime&
    526, 628, 0,	//1974  const KTimeZone*, time_t
    523, 0,	//1977  const KSystemTimeZoneBackend&
    524, 0,	//1979  const KSystemTimeZoneSource&
    525, 554, 0,	//1981  const KTimeZone&, const QDateTime&
    554, 452, 0,	//1984  const QDateTime&, bool*
    429, 0,	//1987  Qt::TimeSpec
    554, 616, 0,	//1989  const QDateTime&, int*
    628, 0,	//1992  time_t
    554, 554, 0,	//1994  const QDateTime&, const QDateTime&
    554, 531, 452, 0,	//1997  const QDateTime&, const KTimeZone::Transition**, bool*
    554, 616, 452, 0,	//2001  const QDateTime&, int*, bool*
    528, 554, 554, 0,	//2005  const KTimeZone::Phase&, const QDateTime&, const QDateTime&
    230, 0,	//2009  KTimeZoneBackend*
    232, 233, 0,	//2011  KTimeZoneData*, KTimeZoneSource*
    554, 531, 0,	//2014  const QDateTime&, const KTimeZone::Transition**
    528, 0,	//2017  const KTimeZone::Phase&
    528, 554, 0,	//2019  const KTimeZone::Phase&, const QDateTime&
    232, 0,	//2022  KTimeZoneData*
    554, 614, 590, 0,	//2024  const QDateTime&, int, const QString&
    527, 0,	//2028  const KTimeZone::LeapSeconds&
    554, 614, 0,	//2030  const QDateTime&, int
    614, 547, 450, 590, 0,	//2033  int, const QByteArray&, bool, const QString&
    614, 575, 450, 590, 0,	//2038  int, const QList<QByteArray>&, bool, const QString&
    614, 547, 450, 0,	//2043  int, const QByteArray&, bool
    614, 575, 450, 0,	//2047  int, const QList<QByteArray>&, bool
    554, 528, 0,	//2051  const QDateTime&, const KTimeZone::Phase&
    529, 0,	//2054  const KTimeZone::Transition&
    532, 0,	//2056  const KTimeZoneBackend&
    526, 0,	//2058  const KTimeZone*
    233, 590, 590, 612, 612, 590, 0,	//2060  KTimeZoneSource*, const QString&, const QString&, float, float, const QString&
    233, 590, 0,	//2067  KTimeZoneSource*, const QString&
    233, 590, 590, 0,	//2070  KTimeZoneSource*, const QString&, const QString&
    233, 590, 590, 612, 0,	//2074  KTimeZoneSource*, const QString&, const QString&, float
    233, 590, 590, 612, 612, 0,	//2079  KTimeZoneSource*, const QString&, const QString&, float, float
    533, 0,	//2085  const KTimeZoneData&
    573, 528, 0,	//2087  const QList<KTimeZone::Phase>&, const KTimeZone::Phase&
    573, 614, 0,	//2090  const QList<KTimeZone::Phase>&, int
    574, 0,	//2093  const QList<KTimeZone::Transition>&
    572, 0,	//2095  const QList<KTimeZone::LeapSeconds>&
    535, 0,	//2097  const KTimeZoneSource&
    590, 590, 547, 0,	//2099  const QString&, const QString&, const QByteArray&
    540, 547, 450, 0,	//2103  const KUrl&, const QByteArray&, bool
    590, 590, 590, 590, 590, 590, 591, 547, 0,	//2107  const QString&, const QString&, const QString&, const QString&, const QString&, const QString&, const QStringList&, const QByteArray&
    590, 590, 353, 353, 616, 547, 450, 0,	//2116  const QString&, const QString&, QString*, QString*, int*, const QByteArray&, bool
    590, 591, 353, 353, 616, 547, 450, 0,	//2124  const QString&, const QStringList&, QString*, QString*, int*, const QByteArray&, bool
    590, 591, 353, 616, 547, 0,	//2132  const QString&, const QStringList&, QString*, int*, const QByteArray&
    355, 265, 0,	//2138  QStringList&, QByteArray&
    540, 547, 0,	//2141  const KUrl&, const QByteArray&
    590, 590, 590, 590, 590, 0,	//2144  const QString&, const QString&, const QString&, const QString&, const QString&
    590, 590, 590, 590, 590, 590, 0,	//2150  const QString&, const QString&, const QString&, const QString&, const QString&, const QString&
    590, 590, 590, 590, 590, 590, 591, 0,	//2157  const QString&, const QString&, const QString&, const QString&, const QString&, const QString&, const QStringList&
    590, 590, 353, 0,	//2165  const QString&, const QString&, QString*
    590, 590, 353, 353, 0,	//2169  const QString&, const QString&, QString*, QString*
    590, 590, 353, 353, 616, 0,	//2174  const QString&, const QString&, QString*, QString*, int*
    590, 590, 353, 353, 616, 547, 0,	//2180  const QString&, const QString&, QString*, QString*, int*, const QByteArray&
    590, 591, 353, 0,	//2187  const QString&, const QStringList&, QString*
    590, 591, 353, 353, 0,	//2191  const QString&, const QStringList&, QString*, QString*
    590, 591, 353, 353, 616, 0,	//2196  const QString&, const QStringList&, QString*, QString*, int*
    590, 591, 353, 353, 616, 547, 0,	//2202  const QString&, const QStringList&, QString*, QString*, int*, const QByteArray&
    590, 591, 353, 616, 0,	//2209  const QString&, const QStringList&, QString*, int*
    238, 590, 590, 612, 612, 590, 0,	//2214  KTzfileTimeZoneSource*, const QString&, const QString&, float, float, const QString&
    537, 0,	//2221  const KTzfileTimeZone&
    238, 590, 0,	//2223  KTzfileTimeZoneSource*, const QString&
    238, 590, 590, 0,	//2226  KTzfileTimeZoneSource*, const QString&, const QString&
    238, 590, 590, 612, 0,	//2230  KTzfileTimeZoneSource*, const QString&, const QString&, float
    238, 590, 590, 612, 612, 0,	//2235  KTzfileTimeZoneSource*, const QString&, const QString&, float, float
    538, 0,	//2241  const KTzfileTimeZoneBackend&
    539, 0,	//2243  const KTzfileTimeZoneSource&
    242, 0,	//2245  KUrl::AdjustPathOption
    541, 0,	//2247  const KUrl::CleanPathOption&
    242, 557, 0,	//2249  KUrl::AdjustPathOption, const QFlags<KUrl::EncodedPathAndQueryOption>&
    559, 0,	//2252  const QFlags<KUrl::QueryItemsOption>&
    556, 0,	//2254  const QFlags<KUrl::DirectoryOption>&
    540, 450, 0,	//2256  const KUrl&, bool
    540, 558, 0,	//2259  const KUrl&, const QFlags<KUrl::EqualsOption>&
    542, 0,	//2262  const KUrl::List&
    343, 579, 249, 0,	//2264  QMimeData*, const QMap<QString,QString>&, KUrl::MimeDataFlags
    540, 540, 0,	//2268  const KUrl&, const KUrl&
    343, 0,	//2271  QMimeData*
    343, 579, 0,	//2273  QMimeData*, const QMap<QString,QString>&
    254, 0,	//2276  KUser::UIDMode
    629, 0,	//2278  uid_t
    603, 0,	//2280  const passwd*
    543, 0,	//2282  const KUser&
    255, 0,	//2284  KUser::UserProperty
    613, 0,	//2286  gid_t
    600, 0,	//2288  const group*
    544, 0,	//2290  const KUserGroup&
    545, 0,	//2292  const KWordMacroExpander&
    590, 590, 549, 345, 0,	//2294  const QString&, const QString&, const QDBusConnection&, QObject*
    590, 591, 591, 590, 0,	//2299  const QString&, const QStringList&, const QStringList&, const QString&
    590, 591, 591, 590, 352, 352, 615, 0,	//2304  const QString&, const QStringList&, const QStringList&, const QString&, QString&, QString&, int&
    590, 590, 590, 352, 0,	//2312  const QString&, const QString&, const QString&, QString&
    590, 591, 591, 590, 450, 352, 352, 615, 0,	//2317  const QString&, const QStringList&, const QStringList&, const QString&, bool, QString&, QString&, int&
    590, 590, 549, 0,	//2326  const QString&, const QString&, const QDBusConnection&
    26, 282, 0,	//2330  KAutostart::Condition, QFlags<KAutostart::Condition>
    26, 26, 0,	//2333  KAutostart::Condition, KAutostart::Condition
    130, 130, 0,	//2336  KLocale::DateTimeFormatOption, KLocale::DateTimeFormatOption
    84, 286, 0,	//2339  KCurrencyCode::CurrencyStatus, QFlags<KCurrencyCode::CurrencyStatus>
    273, 516, 0,	//2342  QDataStream&, const KServiceAction&
    598, 565, 0,	//2345  const char*, const QLatin1String&
    138, 290, 0,	//2348  KLocale::TimeFormatOption, QFlags<KLocale::TimeFormatOption>
    243, 296, 0,	//2351  KUrl::CleanPathOption, QFlags<KUrl::CleanPathOption>
    243, 243, 0,	//2354  KUrl::CleanPathOption, KUrl::CleanPathOption
    50, 614, 0,	//2357  KConfigBase::WriteConfigFlag, int
    110, 110, 0,	//2360  KJob::Capability, KJob::Capability
    273, 181, 0,	//2363  QDataStream&, KServiceAction&
    551, 551, 0,	//2366  const QDBusSignature&, const QDBusSignature&
    250, 614, 0,	//2369  KUrl::QueryItemsOption, int
    245, 245, 0,	//2372  KUrl::EncodedPathAndQueryOption, KUrl::EncodedPathAndQueryOption
    47, 284, 0,	//2375  KConfig::OpenFlag, QFlags<KConfig::OpenFlag>
    244, 244, 0,	//2378  KUrl::DirectoryOption, KUrl::DirectoryOption
    244, 297, 0,	//2381  KUrl::DirectoryOption, QFlags<KUrl::DirectoryOption>
    37, 283, 0,	//2384  KCmdLineArgs::StdCmdLineArg, QFlags<KCmdLineArgs::StdCmdLineArg>
    199, 199, 0,	//2387  KShell::Option, KShell::Option
    145, 614, 0,	//2390  KLockFile::LockFlag, int
    128, 288, 0,	//2393  KLocale::DateTimeComponent, QFlags<KLocale::DateTimeComponent>
    550, 550, 0,	//2396  const QDBusObjectPath&, const QDBusObjectPath&
    37, 614, 0,	//2399  KCmdLineArgs::StdCmdLineArg, int
    130, 614, 0,	//2402  KLocale::DateTimeFormatOption, int
    245, 614, 0,	//2405  KUrl::EncodedPathAndQueryOption, int
    199, 614, 0,	//2408  KShell::Option, int
    454, 0,	//2411  char*
    199, 294, 0,	//2413  KShell::Option, QFlags<KShell::Option>
    201, 295, 0,	//2416  KStandardDirs::SearchOption, QFlags<KStandardDirs::SearchOption>
    26, 614, 0,	//2419  KAutostart::Condition, int
    84, 84, 0,	//2422  KCurrencyCode::CurrencyStatus, KCurrencyCode::CurrencyStatus
    547, 590, 0,	//2425  const QByteArray&, const QString&
    590, 453, 0,	//2428  const QString&, char
    201, 201, 0,	//2431  KStandardDirs::SearchOption, KStandardDirs::SearchOption
    110, 614, 0,	//2434  KJob::Capability, int
    139, 139, 0,	//2437  KLocale::TimeProcessingOption, KLocale::TimeProcessingOption
    565, 565, 0,	//2440  const QLatin1String&, const QLatin1String&
    246, 246, 0,	//2443  KUrl::EqualsOption, KUrl::EqualsOption
    243, 614, 0,	//2446  KUrl::CleanPathOption, int
    201, 614, 0,	//2449  KStandardDirs::SearchOption, int
    250, 250, 0,	//2452  KUrl::QueryItemsOption, KUrl::QueryItemsOption
    50, 50, 0,	//2455  KConfigBase::WriteConfigFlag, KConfigBase::WriteConfigFlag
    47, 614, 0,	//2458  KConfig::OpenFlag, int
    138, 138, 0,	//2461  KLocale::TimeFormatOption, KLocale::TimeFormatOption
    84, 614, 0,	//2464  KCurrencyCode::CurrencyStatus, int
    246, 614, 0,	//2467  KUrl::EqualsOption, int
    139, 291, 0,	//2470  KLocale::TimeProcessingOption, QFlags<KLocale::TimeProcessingOption>
    246, 299, 0,	//2473  KUrl::EqualsOption, QFlags<KUrl::EqualsOption>
    139, 614, 0,	//2476  KLocale::TimeProcessingOption, int
    453, 590, 0,	//2479  char, const QString&
    273, 513, 0,	//2482  QDataStream&, const KProtocolInfo::ExtraField&
    145, 292, 0,	//2485  KLockFile::LockFlag, QFlags<KLockFile::LockFlag>
    130, 289, 0,	//2488  KLocale::DateTimeFormatOption, QFlags<KLocale::DateTimeFormatOption>
    250, 300, 0,	//2491  KUrl::QueryItemsOption, QFlags<KUrl::QueryItemsOption>
    244, 614, 0,	//2494  KUrl::DirectoryOption, int
    128, 128, 0,	//2497  KLocale::DateTimeComponent, KLocale::DateTimeComponent
    47, 47, 0,	//2500  KConfig::OpenFlag, KConfig::OpenFlag
    37, 37, 0,	//2503  KCmdLineArgs::StdCmdLineArg, KCmdLineArgs::StdCmdLineArg
    138, 614, 0,	//2506  KLocale::TimeFormatOption, int
    273, 169, 0,	//2509  QDataStream&, KProtocolInfo::ExtraField&
    245, 298, 0,	//2512  KUrl::EncodedPathAndQueryOption, QFlags<KUrl::EncodedPathAndQueryOption>
    50, 285, 0,	//2515  KConfigBase::WriteConfigFlag, QFlags<KConfigBase::WriteConfigFlag>
    128, 614, 0,	//2518  KLocale::DateTimeComponent, int
    110, 287, 0,	//2521  KJob::Capability, QFlags<KJob::Capability>
    145, 145, 0,	//2524  KLockFile::LockFlag, KLockFile::LockFlag
    280, 0,	//2527  QEvent*
    345, 280, 0,	//2529  QObject*, QEvent*
    362, 0,	//2532  QTimerEvent*
    267, 0,	//2534  QChildEvent*
    597, 345, 0,	//2536  const Sonnet::Speller&, QObject*
    597, 0,	//2539  const Sonnet::Speller&
    614, 590, 590, 0,	//2541  int, const QString&, const QString&
    449, 450, 0,	//2545  Sonnet::Speller::Attribute, bool
    449, 0,	//2548  Sonnet::Speller::Attribute
    602, 0,	//2550  const kndbgstream&
};

// Raw list of all methods, using munged names
static const char *methodNames[] = {
    "",	//0
    "AbortError",	//1
    "AbortOnMeta",	//2
    "AbstractUnixSocket",	//3
    "Action",	//4
    "Action#",	//5
    "Action$",	//6
    "Action$$",	//7
    "ActionReply",	//8
    "ActionReply#",	//9
    "ActionReply$",	//10
    "ActiveCurrency",	//11
    "AddTrailingSlash",	//12
    "AddressInUseError",	//13
    "After",	//14
    "AfterMoney",	//15
    "AfterQuantityMoney",	//16
    "AllowEmptyPath",	//17
    "AllowSeparators",	//18
    "Append",	//19
    "AppendTrailingSlash",	//20
    "Applications",	//21
    "Arabic",	//22
    "ArabicDigits",	//23
    "ArabicIndicDigits",	//24
    "AtEnd",	//25
    "AtStart",	//26
    "AuthRequired",	//27
    "AuthorizationDenied",	//28
    "AuthorizationDeniedReply",	//29
    "Authorized",	//30
    "AutoCloseHandle",	//31
    "AutoDetectedEncoding",	//32
    "AvoidEmptyPath",	//33
    "BOM",	//34
    "BackgroundChecker",	//35
    "BackgroundChecker#",	//36
    "BackgroundChecker##",	//37
    "BadQuoting",	//38
    "Baltic",	//39
    "BaseDesktop",	//40
    "Before",	//41
    "BeforeMoney",	//42
    "BeforeQuantityMoney",	//43
    "BengaliDigits",	//44
    "BoundState",	//45
    "Bytes",	//46
    "CascadeConfig",	//47
    "CaseInsensitiveKeys",	//48
    "CentralEuropean",	//49
    "CheckAll",	//50
    "CheckCommand",	//51
    "CheckCondition",	//52
    "CheckUppercase",	//53
    "ChineseSimplified",	//54
    "ChineseTraditional",	//55
    "Choice",	//56
    "Choice#",	//57
    "Choice2",	//58
    "Choice2#",	//59
    "ClockTime",	//60
    "ClosingState",	//61
    "CmdLineArgKDE",	//62
    "CmdLineArgNone",	//63
    "CmdLineArgQt",	//64
    "CmdLineArgsMask",	//65
    "CompareWithoutFragment",	//66
    "CompareWithoutTrailingSlash",	//67
    "ConnectedState",	//68
    "ConnectingState",	//69
    "ConnectionRefusedError",	//70
    "CopticCalendar",	//71
    "CopyError",	//72
    "CrashExit",	//73
    "Crashed",	//74
    "Cyrillic",	//75
    "DBusError",	//76
    "DBusErrorReply",	//77
    "DBusMulti",	//78
    "DBusNone",	//79
    "DBusUnique",	//80
    "DBusWait",	//81
    "DatagramTooLargeError",	//82
    "DateTime",	//83
    "Day",	//84
    "DayName",	//85
    "DayOfWeek",	//86
    "DayOfWeekName",	//87
    "DayOfYear",	//88
    "DayOfYearName",	//89
    "DayPeriod",	//90
    "DayPeriodHour",	//91
    "DaysInMonth",	//92
    "DaysInWeek",	//93
    "DaysInYear",	//94
    "DefaultBinaryDialect",	//95
    "DefaultBinaryUnits",	//96
    "DefaultComponentFormat",	//97
    "DefaultEncoding",	//98
    "DefaultMimeDataFlags",	//99
    "DefaultWeekNumber",	//100
    "Denied",	//101
    "DesktopServices",	//102
    "DevenagariDigits",	//103
    "Directories",	//104
    "DisplayName",	//105
    "DoCopyCatalogs",	//106
    "DontCloseHandle",	//107
    "DontCopyCatalogs",	//108
    "DontResolveAlias",	//109
    "EasternArabicIndicDigits",	//110
    "EmitResult",	//111
    "EncodingFromHTTPHeader",	//112
    "EncodingFromMetaTag",	//113
    "EncodingFromXMLHeader",	//114
    "End",	//115
    "EndsAt",	//116
    "Equal",	//117
    "EraName",	//118
    "EraYear",	//119
    "ErrNoComponent",	//120
    "ErrNoFactory",	//121
    "ErrNoLibrary",	//122
    "ErrNoServiceFound",	//123
    "ErrServiceProvidesNoLibrary",	//124
    "Error",	//125
    "EthiopianCalendar",	//126
    "ExcludeNoDisplay",	//127
    "ExeGroup",	//128
    "ExeOther",	//129
    "ExeOwner",	//130
    "ExeUser",	//131
    "ExtraField",	//132
    "ExtraField#",	//133
    "ExtraField$$",	//134
    "FailedToStart",	//135
    "FancyLongDate",	//136
    "FancyShortDate",	//137
    "Fatal",	//138
    "FatalError",	//139
    "Files",	//140
    "FirstFullWeek",	//141
    "FirstPartialWeek",	//142
    "ForceFlag",	//143
    "ForwardedChannels",	//144
    "FoundIt",	//145
    "FoundMeta",	//146
    "FromUrl",	//147
    "FullConfig",	//148
    "FullName",	//149
    "Global",	//150
    "GlobalDatabase",	//151
    "Greek",	//152
    "GregorianCalendar",	//153
    "GujaratiDigits",	//154
    "GurmukhiDigits",	//155
    "Hebrew",	//156
    "HebrewCalendar",	//157
    "HelperBusy",	//158
    "HelperBusyReply",	//159
    "HelperError",	//160
    "HelperErrorReply",	//161
    "HomePhone",	//162
    "HostLookupState",	//163
    "HostNotFoundError",	//164
    "Hour",	//165
    "IECBinaryDialect",	//166
    "IPv4Protocol",	//167
    "IPv6Protocol",	//168
    "ISODate",	//169
    "IgnoreExecBit",	//170
    "IgnoreTrailingSlash",	//171
    "Imperial",	//172
    "IncludeGlobals",	//173
    "IndianNationalCalendar",	//174
    "Information",	//175
    "Inside",	//176
    "Invalid",	//177
    "InvalidAction",	//178
    "InvalidActionReply",	//179
    "InvalidOffset",	//180
    "InvalidTime_t",	//181
    "IslamicCivilCalendar",	//182
    "IsoDate",	//183
    "IsoFormat",	//184
    "IsoOrdinalDate",	//185
    "IsoOrdinalFormat",	//186
    "IsoWeekDate",	//187
    "IsoWeekFormat",	//188
    "IsoWeekNumber",	//189
    "ItemBool",	//190
    "ItemBool#",	//191
    "ItemBool$$$",	//192
    "ItemBool$$$$",	//193
    "ItemDateTime",	//194
    "ItemDateTime#",	//195
    "ItemDateTime$$#",	//196
    "ItemDateTime$$##",	//197
    "ItemDouble",	//198
    "ItemDouble#",	//199
    "ItemDouble$$$",	//200
    "ItemDouble$$$$",	//201
    "ItemEnum",	//202
    "ItemEnum#",	//203
    "ItemEnum$$$?",	//204
    "ItemEnum$$$?$",	//205
    "ItemInt",	//206
    "ItemInt#",	//207
    "ItemInt$$$",	//208
    "ItemInt$$$$",	//209
    "ItemIntList",	//210
    "ItemIntList#",	//211
    "ItemIntList$$?",	//212
    "ItemIntList$$??",	//213
    "ItemLongLong",	//214
    "ItemLongLong#",	//215
    "ItemLongLong$$$",	//216
    "ItemLongLong$$$$",	//217
    "ItemPassword",	//218
    "ItemPassword#",	//219
    "ItemPassword$$$",	//220
    "ItemPassword$$$$",	//221
    "ItemPath",	//222
    "ItemPath#",	//223
    "ItemPath$$$",	//224
    "ItemPath$$$$",	//225
    "ItemPathList",	//226
    "ItemPathList#",	//227
    "ItemPathList$$?",	//228
    "ItemPathList$$??",	//229
    "ItemPoint",	//230
    "ItemPoint#",	//231
    "ItemPoint$$#",	//232
    "ItemPoint$$##",	//233
    "ItemProperty",	//234
    "ItemProperty#",	//235
    "ItemProperty$$#",	//236
    "ItemProperty$$##",	//237
    "ItemRect",	//238
    "ItemRect#",	//239
    "ItemRect$$#",	//240
    "ItemRect$$##",	//241
    "ItemSize",	//242
    "ItemSize#",	//243
    "ItemSize$$#",	//244
    "ItemSize$$##",	//245
    "ItemString",	//246
    "ItemString#",	//247
    "ItemString$$$",	//248
    "ItemString$$$$",	//249
    "ItemString$$$$$",	//250
    "ItemStringList",	//251
    "ItemStringList#",	//252
    "ItemStringList$$?",	//253
    "ItemStringList$$??",	//254
    "ItemUInt",	//255
    "ItemUInt#",	//256
    "ItemUInt$$$",	//257
    "ItemUInt$$$$",	//258
    "ItemULongLong",	//259
    "ItemULongLong#",	//260
    "ItemULongLong$$$",	//261
    "ItemULongLong$$$$",	//262
    "ItemUrl",	//263
    "ItemUrl#",	//264
    "ItemUrl$$#",	//265
    "ItemUrl$$##",	//266
    "ItemUrlList",	//267
    "ItemUrlList#",	//268
    "ItemUrlList$$?",	//269
    "ItemUrlList$$??",	//270
    "JEDECBinaryDialect",	//271
    "JalaliCalendar",	//272
    "Japanese",	//273
    "JapaneseCalendar",	//274
    "JulianCalendar",	//275
    "JulianDay",	//276
    "KAboutData",	//277
    "KAboutData#",	//278
    "KAboutData####",	//279
    "KAboutData#####",	//280
    "KAboutData#####$",	//281
    "KAboutData#####$#",	//282
    "KAboutData#####$##",	//283
    "KAboutData#####$###",	//284
    "KAboutData#####$####",	//285
    "KAboutLicense",	//286
    "KAboutLicense#",	//287
    "KAboutPerson",	//288
    "KAboutPerson#",	//289
    "KAboutPerson##",	//290
    "KAboutPerson###",	//291
    "KAboutPerson####",	//292
    "KAboutPerson#####",	//293
    "KAuthError",	//294
    "KAutoSaveFile",	//295
    "KAutoSaveFile#",	//296
    "KAutoSaveFile##",	//297
    "KAutostart",	//298
    "KAutostart$",	//299
    "KAutostart$#",	//300
    "KCalendarSystem",	//301
    "KCalendarSystem#",	//302
    "KCalendarSystem#?",	//303
    "KCalendarSystem#?#",	//304
    "KCalendarSystem?",	//305
    "KCalendarSystem?#",	//306
    "KCharMacroExpander",	//307
    "KCharMacroExpander#",	//308
    "KCharsets",	//309
    "KCharsets#",	//310
    "KCmdLineArgs",	//311
    "KCmdLineArgs#",	//312
    "KCmdLineArgs###",	//313
    "KCmdLineOptions",	//314
    "KCmdLineOptions#",	//315
    "KComponentData",	//316
    "KComponentData#",	//317
    "KComponentData##",	//318
    "KComponentData##$",	//319
    "KComponentData#$",	//320
    "KCompositeJob",	//321
    "KCompositeJob#",	//322
    "KCompositeJob##",	//323
    "KConfig",	//324
    "KConfig#",	//325
    "KConfig#$",	//326
    "KConfig#$$",	//327
    "KConfig#$$$",	//328
    "KConfig$",	//329
    "KConfig$$",	//330
    "KConfig$$$",	//331
    "KConfigBase",	//332
    "KConfigBase#",	//333
    "KConfigGroup",	//334
    "KConfigGroup#",	//335
    "KConfigGroup#$",	//336
    "KConfigGroup?$",	//337
    "KConfigSkeletonItem",	//338
    "KConfigSkeletonItem#",	//339
    "KConfigSkeletonItem$$",	//340
    "KCoreConfigSkeleton",	//341
    "KCoreConfigSkeleton$",	//342
    "KCoreConfigSkeleton$#",	//343
    "KCoreConfigSkeleton?",	//344
    "KCoreConfigSkeleton?#",	//345
    "KCurrencyCode",	//346
    "KCurrencyCode#",	//347
    "KCurrencyCode#$",	//348
    "KCurrencyCode$",	//349
    "KCurrencyCode$$",	//350
    "KDEDModule",	//351
    "KDEDModule#",	//352
    "KDEPluginVerificationData",	//353
    "KDEPluginVerificationData#",	//354
    "KDEVersion",	//355
    "KDEVersionString",	//356
    "KDateTime",	//357
    "KDateTime#",	//358
    "KDateTime##",	//359
    "KDateTime###",	//360
    "KDebug",	//361
    "KDebug#",	//362
    "KDebug$",	//363
    "KDebug$$",	//364
    "KDebug$$$",	//365
    "KDebug$$$$",	//366
    "KDebugTag",	//367
    "KDebugTag#",	//368
    "KDesktopFile",	//369
    "KDesktopFile$",	//370
    "KDesktopFile$$",	//371
    "KEncodingDetector",	//372
    "KEncodingDetector#",	//373
    "KEncodingDetector#$",	//374
    "KEncodingDetector#$$",	//375
    "KEncodingProber",	//376
    "KEncodingProber#",	//377
    "KEncodingProber$",	//378
    "KFilterBase",	//379
    "KJob",	//380
    "KJob#",	//381
    "KJob##",	//382
    "KJobTrackerInterface",	//383
    "KJobTrackerInterface#",	//384
    "KJobUiDelegate",	//385
    "KLibrary",	//386
    "KLibrary#",	//387
    "KLibrary$",	//388
    "KLibrary$#",	//389
    "KLibrary$##",	//390
    "KLibrary$$",	//391
    "KLibrary$$#",	//392
    "KLibrary$$##",	//393
    "KLocalSocket",	//394
    "KLocalSocket#",	//395
    "KLocalSocketServer",	//396
    "KLocalSocketServer#",	//397
    "KLocale",	//398
    "KLocale#",	//399
    "KLocale$",	//400
    "KLocale$$",	//401
    "KLocale$$$",	//402
    "KLocale$$$#",	//403
    "KLocale$?",	//404
    "KLocalizedString",	//405
    "KLocalizedString#",	//406
    "KLockFile",	//407
    "KLockFile#",	//408
    "KLockFile$",	//409
    "KLockFile$#",	//410
    "KMD5",	//411
    "KMD5#",	//412
    "KMD5$",	//413
    "KMD5$$",	//414
    "KMacroExpanderBase",	//415
    "KMacroExpanderBase#",	//416
    "KMessageHandler",	//417
    "KMessageHandler#",	//418
    "KMimeType",	//419
    "KMimeType#",	//420
    "KMimeType#$",	//421
    "KMimeType#$$",	//422
    "KMimeType$$$",	//423
    "KMimeTypeTrader",	//424
    "KMimeTypeTrader#",	//425
    "KPluginFactory",	//426
    "KPluginFactory#",	//427
    "KPluginFactory##",	//428
    "KPluginFactory$",	//429
    "KPluginFactory$$",	//430
    "KPluginFactory$$#",	//431
    "KPluginInfo",	//432
    "KPluginInfo#",	//433
    "KPluginInfo$",	//434
    "KPluginInfo$$",	//435
    "KPluginInfo?",	//436
    "KPluginLoader",	//437
    "KPluginLoader#",	//438
    "KPluginLoader##",	//439
    "KPluginLoader###",	//440
    "KPluginLoader$",	//441
    "KPluginLoader$#",	//442
    "KPluginLoader$##",	//443
    "KProcess",	//444
    "KProcess#",	//445
    "KProcess##",	//446
    "KProtocolInfo",	//447
    "KProtocolInfo#$",	//448
    "KRandomSequence",	//449
    "KRandomSequence#",	//450
    "KRandomSequence$",	//451
    "KST_CTimeInfo",	//452
    "KST_KCustom",	//453
    "KST_KDEDesktopMimeType",	//454
    "KST_KFolderMimeType",	//455
    "KST_KImageIO",	//456
    "KST_KImageIOFormat",	//457
    "KST_KMimeType",	//458
    "KST_KMimeTypeEntry",	//459
    "KST_KMimeTypeFactory",	//460
    "KST_KProtocolInfo",	//461
    "KST_KProtocolInfoFactory",	//462
    "KST_KService",	//463
    "KST_KServiceFactory",	//464
    "KST_KServiceGroup",	//465
    "KST_KServiceGroupFactory",	//466
    "KST_KServiceSeparator",	//467
    "KST_KServiceType",	//468
    "KST_KServiceTypeFactory",	//469
    "KST_KSycocaEntry",	//470
    "KSaveFile",	//471
    "KSaveFile$",	//472
    "KSaveFile$#",	//473
    "KService",	//474
    "KService#",	//475
    "KService#$",	//476
    "KService$",	//477
    "KService$$$",	//478
    "KServiceAction",	//479
    "KServiceAction#",	//480
    "KServiceAction$$$$",	//481
    "KServiceAction$$$$$",	//482
    "KServiceGroup",	//483
    "KServiceGroup#$$",	//484
    "KServiceGroup$",	//485
    "KServiceGroup$$",	//486
    "KServiceType",	//487
    "KServiceType#",	//488
    "KServiceType#$",	//489
    "KServiceType#$$",	//490
    "KStandardDirs",	//491
    "KSycoca",	//492
    "KSycoca$",	//493
    "KSycocaEntry",	//494
    "KSycocaEntry#",	//495
    "KSystemTimeZone",	//496
    "KSystemTimeZone#",	//497
    "KSystemTimeZone#$",	//498
    "KSystemTimeZone#$$",	//499
    "KSystemTimeZone#$$$",	//500
    "KSystemTimeZone#$$$$",	//501
    "KSystemTimeZone#$$$$$",	//502
    "KSystemTimeZoneBackend",	//503
    "KSystemTimeZoneBackend#",	//504
    "KSystemTimeZoneBackend#$$$$$",	//505
    "KSystemTimeZoneSource",	//506
    "KSystemTimeZoneSource#",	//507
    "KTempDir",	//508
    "KTempDir$",	//509
    "KTempDir$$",	//510
    "KTemporaryFile",	//511
    "KTemporaryFile#",	//512
    "KTimeZone",	//513
    "KTimeZone#",	//514
    "KTimeZone$",	//515
    "KTimeZoneBackend",	//516
    "KTimeZoneBackend#",	//517
    "KTimeZoneBackend#$",	//518
    "KTimeZoneBackend#$$",	//519
    "KTimeZoneBackend#$$$",	//520
    "KTimeZoneBackend#$$$$",	//521
    "KTimeZoneBackend#$$$$$",	//522
    "KTimeZoneBackend$",	//523
    "KTimeZoneData",	//524
    "KTimeZoneData#",	//525
    "KTimeZoneSource",	//526
    "KTimeZoneSource#",	//527
    "KTimeZoneSource$",	//528
    "KTimeZones",	//529
    "KTzfileTimeZone",	//530
    "KTzfileTimeZone#",	//531
    "KTzfileTimeZone#$",	//532
    "KTzfileTimeZone#$$",	//533
    "KTzfileTimeZone#$$$",	//534
    "KTzfileTimeZone#$$$$",	//535
    "KTzfileTimeZone#$$$$$",	//536
    "KTzfileTimeZoneBackend",	//537
    "KTzfileTimeZoneBackend#",	//538
    "KTzfileTimeZoneBackend#$$$$$",	//539
    "KTzfileTimeZoneSource",	//540
    "KTzfileTimeZoneSource#",	//541
    "KTzfileTimeZoneSource$",	//542
    "KUrl",	//543
    "KUrl#",	//544
    "KUrl#$",	//545
    "KUrl$",	//546
    "KUser",	//547
    "KUser#",	//548
    "KUser$",	//549
    "KUser?",	//550
    "KUserGroup",	//551
    "KUserGroup#",	//552
    "KUserGroup$",	//553
    "KUserGroup?",	//554
    "KWordMacroExpander",	//555
    "KWordMacroExpander#",	//556
    "KannadaDigits",	//557
    "KdeFormat",	//558
    "KeepAliveOption",	//559
    "KeepDirSeparators",	//560
    "KhmerDigits",	//561
    "Killable",	//562
    "KilledJobError",	//563
    "Korean",	//564
    "LastBinaryDialect",	//565
    "LeapSeconds",	//566
    "LeapSeconds#",	//567
    "LeapSeconds#$",	//568
    "LeapSeconds#$$",	//569
    "LeaveTrailingSlash",	//570
    "LiberalParsing",	//571
    "License_Artistic",	//572
    "License_BSD",	//573
    "License_Custom",	//574
    "License_File",	//575
    "License_GPL",	//576
    "License_GPL_V2",	//577
    "License_GPL_V3",	//578
    "License_LGPL",	//579
    "License_LGPL_V2",	//580
    "License_LGPL_V3",	//581
    "License_QPL",	//582
    "License_QPL_V1_0",	//583
    "License_Unknown",	//584
    "ListeningState",	//585
    "LocalDatabase",	//586
    "LocalDate",	//587
    "LocalZone",	//588
    "Localized",	//589
    "LockError",	//590
    "LockFail",	//591
    "LockOK",	//592
    "LockStale",	//593
    "LongDate",	//594
    "LongDayName",	//595
    "LongFormat",	//596
    "LongName",	//597
    "LongNamePossessive",	//598
    "LongNumber",	//599
    "LowDelayOption",	//600
    "MalayalamDigits",	//601
    "MergedChannels",	//602
    "Metric",	//603
    "MetricBinaryDialect",	//604
    "Millisecond",	//605
    "MinguoCalendar",	//606
    "Minute",	//607
    "Month",	//608
    "MonthName",	//609
    "MonthsInYear",	//610
    "MulticastLoopbackOption",	//611
    "MulticastTtlOption",	//612
    "Name",	//613
    "NarrowDayName",	//614
    "NarrowName",	//615
    "NetworkError",	//616
    "NoAccess",	//617
    "NoBlockFlag",	//618
    "NoCapabilities",	//619
    "NoCascade",	//620
    "NoConditions",	//621
    "NoDuplicates",	//622
    "NoError",	//623
    "NoGlobals",	//624
    "NoHeaders",	//625
    "NoOptions",	//626
    "NoResponder",	//627
    "NoResponderReply",	//628
    "NoSearchOptions",	//629
    "NoSuchAction",	//630
    "NoSuchActionReply",	//631
    "NoTextExport",	//632
    "None",	//633
    "Normal",	//634
    "NormalExit",	//635
    "NormalFormat",	//636
    "NorthernSaami",	//637
    "NotMe",	//638
    "NotOpen",	//639
    "NotRunning",	//640
    "ObeyTrailingSlash",	//641
    "ObsoleteCurrency",	//642
    "OffsetFromUTC",	//643
    "OffsetFromUTC$",	//644
    "Ok",	//645
    "OnlyStderrChannel",	//646
    "OnlyStdoutChannel",	//647
    "OpenError",	//648
    "OrgKdeKLauncherInterface",	//649
    "OrgKdeKLauncherInterface$$#",	//650
    "OrgKdeKLauncherInterface$$##",	//651
    "OriyaDigits",	//652
    "Other",	//653
    "Outside",	//654
    "ParensAround",	//655
    "Password",	//656
    "Path",	//657
    "PermissionsError",	//658
    "PermitEmptyPath",	//659
    "Persistent",	//660
    "Phase",	//661
    "Phase#",	//662
    "Phase$#$",	//663
    "Phase$#$$",	//664
    "Phase$?$",	//665
    "Phase$?$$",	//666
    "PluginVerificationDataVersion",	//667
    "PositionError",	//668
    "PosixFormat",	//669
    "Probing",	//670
    "ProcessNonStrict",	//671
    "ProcessStrict",	//672
    "ProxyAuthenticationRequiredError",	//673
    "ProxyConnectionClosedError",	//674
    "ProxyConnectionRefusedError",	//675
    "ProxyConnectionTimeoutError",	//676
    "ProxyNotFoundError",	//677
    "ProxyProtocolError",	//678
    "QDateCalendar",	//679
    "QtTextDate",	//680
    "Quietly",	//681
    "RFC3339Date",	//682
    "RFCDate",	//683
    "RFCDateDay",	//684
    "ReadError",	//685
    "ReadGroup",	//686
    "ReadOnly",	//687
    "ReadOther",	//688
    "ReadOwner",	//689
    "ReadUser",	//690
    "ReadWrite",	//691
    "Recursive",	//692
    "RegisterAsMainComponent",	//693
    "RemoteHostClosedError",	//694
    "RemoveError",	//695
    "RemoveTrailingSlash",	//696
    "RenameError",	//697
    "Reserved",	//698
    "ResizeError",	//699
    "ResolveAliases",	//700
    "ResourceError",	//701
    "RoomNumber",	//702
    "Running",	//703
    "Second",	//704
    "Seconds",	//705
    "SemiautomaticDetection",	//706
    "SeparateChannels",	//707
    "ShortDate",	//708
    "ShortDayName",	//709
    "ShortFormat",	//710
    "ShortName",	//711
    "ShortNamePossessive",	//712
    "ShortNumber",	//713
    "SimpleConfig",	//714
    "SimpleWeek",	//715
    "SimplifyDirSeparators",	//716
    "SkipMainComponentRegistration",	//717
    "SkipRunTogether",	//718
    "SocketAccessError",	//719
    "SocketAddressNotAvailableError",	//720
    "SocketResourceError",	//721
    "SocketTimeoutError",	//722
    "Sorry",	//723
    "SortByGenericName",	//724
    "SortEntries",	//725
    "SouthEasternEurope",	//726
    "Spec",	//727
    "Spec#",	//728
    "Spec$",	//729
    "Spec$$",	//730
    "Speller",	//731
    "Speller#",	//732
    "Speller$",	//733
    "SslHandshakeFailedError",	//734
    "StandardError",	//735
    "StandardOutput",	//736
    "Starting",	//737
    "StartsAt",	//738
    "String",	//739
    "Success",	//740
    "SuccessReply",	//741
    "Suspendable",	//742
    "SuspendedCurrency",	//743
    "T_ERROR",	//744
    "T_FILESYSTEM",	//745
    "T_NONE",	//746
    "T_STREAM",	//747
    "TamilDigits",	//748
    "TcpSocket",	//749
    "TeluguDigits",	//750
    "Text",	//751
    "Thai",	//752
    "ThaiCalendar",	//753
    "ThaiDigits",	//754
    "TildeExpand",	//755
    "TimeDefault",	//756
    "TimeDuration",	//757
    "TimeFoldHours",	//758
    "TimeOutError",	//759
    "TimeWithoutAmPm",	//760
    "TimeWithoutSeconds",	//761
    "TimeZone",	//762
    "Timedout",	//763
    "Timezone",	//764
    "TimezoneName",	//765
    "Transition",	//766
    "Transition#",	//767
    "Transition##",	//768
    "Truncate",	//769
    "Turkish",	//770
    "UNKNOWN",	//771
    "UTC",	//772
    "UdpSocket",	//773
    "Unbuffered",	//774
    "UnconnectedState",	//775
    "UnfinishedSocketOperationError",	//776
    "Unicode",	//777
    "UnicodeFormat",	//778
    "UnitByte",	//779
    "UnitExaByte",	//780
    "UnitGigaByte",	//781
    "UnitKiloByte",	//782
    "UnitLastUnit",	//783
    "UnitMegaByte",	//784
    "UnitPetaByte",	//785
    "UnitTeraByte",	//786
    "UnitYottaByte",	//787
    "UnitZettaByte",	//788
    "Universal",	//789
    "UnixSocket",	//790
    "UnixTime",	//791
    "UnknownError",	//792
    "UnknownLocalSocketType",	//793
    "UnknownNetworkLayerProtocol",	//794
    "UnknownSocketError",	//795
    "UnknownSocketType",	//796
    "UnspecifiedError",	//797
    "UnsupportedSocketOperationError",	//798
    "UseEffectiveUID",	//799
    "UseRealUserID",	//800
    "UserCancelled",	//801
    "UserCancelledReply",	//802
    "UserChosenEncoding",	//803
    "UserDefinedError",	//804
    "Warning",	//805
    "Week",	//806
    "WeekYear",	//807
    "WeeksInYear",	//808
    "WesternEuropean",	//809
    "WithHeaders",	//810
    "WithSeconds",	//811
    "WithoutSeconds",	//812
    "WorkPhone",	//813
    "WriteError",	//814
    "WriteGroup",	//815
    "WriteOnly",	//816
    "WriteOther",	//817
    "WriteOwner",	//818
    "WriteUser",	//819
    "Year",	//820
    "YearInEra",	//821
    "YearName",	//822
    "abbreviation",	//823
    "abbreviation#",	//824
    "abbreviations",	//825
    "abort",	//826
    "aboutData",	//827
    "aboutTranslationTeam",	//828
    "absoluteFilePath",	//829
    "absoluteFilePath?",	//830
    "access",	//831
    "access$$",	//832
    "accessMode",	//833
    "action",	//834
    "actionGroup",	//835
    "actionGroup$",	//836
    "actionPerformed",	//837
    "actionPerformed#",	//838
    "actionStarted",	//839
    "actions",	//840
    "activeComponent",	//841
    "add",	//842
    "add#",	//843
    "add##",	//844
    "add###",	//845
    "addArgument",	//846
    "addArgument$#",	//847
    "addAuthor",	//848
    "addAuthor#",	//849
    "addAuthor##",	//850
    "addAuthor###",	//851
    "addAuthor####",	//852
    "addAuthor#####",	//853
    "addCmdLineOptions",	//854
    "addCmdLineOptions#",	//855
    "addCmdLineOptions##",	//856
    "addCmdLineOptions###",	//857
    "addCmdLineOptions####",	//858
    "addConfigSources",	//859
    "addConfigSources?",	//860
    "addCredit",	//861
    "addCredit#",	//862
    "addCredit##",	//863
    "addCredit###",	//864
    "addCredit####",	//865
    "addCredit#####",	//866
    "addCustomized",	//867
    "addCustomized#",	//868
    "addData",	//869
    "addData$#",	//870
    "addDays",	//871
    "addDays#$",	//872
    "addDays$",	//873
    "addEntry",	//874
    "addEntry?",	//875
    "addFactory",	//876
    "addFactory#",	//877
    "addItem",	//878
    "addItem#",	//879
    "addItem#$",	//880
    "addItemBool",	//881
    "addItemBool$$",	//882
    "addItemBool$$$",	//883
    "addItemBool$$$$",	//884
    "addItemDateTime",	//885
    "addItemDateTime$#",	//886
    "addItemDateTime$##",	//887
    "addItemDateTime$##$",	//888
    "addItemDouble",	//889
    "addItemDouble$$",	//890
    "addItemDouble$$$",	//891
    "addItemDouble$$$$",	//892
    "addItemInt",	//893
    "addItemInt$$",	//894
    "addItemInt$$$",	//895
    "addItemInt$$$$",	//896
    "addItemInt64",	//897
    "addItemInt64$$",	//898
    "addItemInt64$$$",	//899
    "addItemInt64$$$$",	//900
    "addItemIntList",	//901
    "addItemIntList$?",	//902
    "addItemIntList$??",	//903
    "addItemIntList$??$",	//904
    "addItemLongLong",	//905
    "addItemLongLong$$",	//906
    "addItemLongLong$$$",	//907
    "addItemLongLong$$$$",	//908
    "addItemPassword",	//909
    "addItemPassword$$",	//910
    "addItemPassword$$$",	//911
    "addItemPassword$$$$",	//912
    "addItemPath",	//913
    "addItemPath$$",	//914
    "addItemPath$$$",	//915
    "addItemPath$$$$",	//916
    "addItemPoint",	//917
    "addItemPoint$#",	//918
    "addItemPoint$##",	//919
    "addItemPoint$##$",	//920
    "addItemProperty",	//921
    "addItemProperty$#",	//922
    "addItemProperty$##",	//923
    "addItemProperty$##$",	//924
    "addItemRect",	//925
    "addItemRect$#",	//926
    "addItemRect$##",	//927
    "addItemRect$##$",	//928
    "addItemSize",	//929
    "addItemSize$#",	//930
    "addItemSize$##",	//931
    "addItemSize$##$",	//932
    "addItemString",	//933
    "addItemString$$",	//934
    "addItemString$$$",	//935
    "addItemString$$$$",	//936
    "addItemStringList",	//937
    "addItemStringList$?",	//938
    "addItemStringList$??",	//939
    "addItemStringList$??$",	//940
    "addItemUInt",	//941
    "addItemUInt$$",	//942
    "addItemUInt$$$",	//943
    "addItemUInt$$$$",	//944
    "addItemUInt64",	//945
    "addItemUInt64$$",	//946
    "addItemUInt64$$$",	//947
    "addItemUInt64$$$$",	//948
    "addItemULongLong",	//949
    "addItemULongLong$$",	//950
    "addItemULongLong$$$",	//951
    "addItemULongLong$$$$",	//952
    "addLicense",	//953
    "addLicense$",	//954
    "addLicenseText",	//955
    "addLicenseText#",	//956
    "addLicenseTextFile",	//957
    "addLicenseTextFile$",	//958
    "addMSecs",	//959
    "addMSecs$",	//960
    "addMonths",	//961
    "addMonths#$",	//962
    "addMonths$",	//963
    "addPath",	//964
    "addPath$",	//965
    "addPrefix",	//966
    "addPrefix$",	//967
    "addQueryItem",	//968
    "addQueryItem$$",	//969
    "addResourceDir",	//970
    "addResourceDir$$",	//971
    "addResourceDir$$$",	//972
    "addResourceType",	//973
    "addResourceType$$",	//974
    "addResourceType$$$",	//975
    "addResourceType$$$$",	//976
    "addSecs",	//977
    "addSecs$",	//978
    "addStdCmdLineOptions",	//979
    "addStdCmdLineOptions$",	//980
    "addSubjob",	//981
    "addSubjob#",	//982
    "addTempFileOption",	//983
    "addToAllowedEnvironments",	//984
    "addToAllowedEnvironments$",	//985
    "addToExcludedEnvironments",	//986
    "addToExcludedEnvironments$",	//987
    "addToPersonal",	//988
    "addToPersonal$",	//989
    "addToSession",	//990
    "addToSession$",	//991
    "addWordToPersonal",	//992
    "addWordToPersonal$",	//993
    "addXdgConfigPrefix",	//994
    "addXdgConfigPrefix$",	//995
    "addXdgDataPrefix",	//996
    "addXdgDataPrefix$",	//997
    "addYears",	//998
    "addYears#$",	//999
    "addYears$",	//1000
    "adjustPath",	//1001
    "adjustPath$",	//1002
    "allArguments",	//1003
    "allCountriesList",	//1004
    "allCurrencyCodesList",	//1005
    "allCurrencyCodesList$",	//1006
    "allDigitSetsList",	//1007
    "allGroupNames",	//1008
    "allGroups",	//1009
    "allLanguagesList",	//1010
    "allMimeTypes",	//1011
    "allParentMimeTypes",	//1012
    "allResourceDirs",	//1013
    "allServiceTypes",	//1014
    "allServices",	//1015
    "allStaleFiles",	//1016
    "allStaleFiles$",	//1017
    "allTypes",	//1018
    "allUserNames",	//1019
    "allUsers",	//1020
    "allowAsDefault",	//1021
    "allowInline",	//1022
    "allowMultipleFiles",	//1023
    "allowUrlAction",	//1024
    "allowUrlAction$##",	//1025
    "allowedEnvironments",	//1026
    "analyze",	//1027
    "analyze$$",	//1028
    "appName",	//1029
    "applyConstraints",	//1030
    "applyConstraints?$",	//1031
    "applyShortYearWindow",	//1032
    "applyShortYearWindow$",	//1033
    "archiveMimeTypes",	//1034
    "arg",	//1035
    "arg$",	//1036
    "arguments",	//1037
    "atEnd",	//1038
    "author",	//1039
    "authorize",	//1040
    "authorize$",	//1041
    "authorizeControlModule",	//1042
    "authorizeControlModule$",	//1043
    "authorizeControlModules",	//1044
    "authorizeControlModules?",	//1045
    "authorizeKAction",	//1046
    "authorizeKAction$",	//1047
    "authorizeUrlAction",	//1048
    "authorizeUrlAction$##",	//1049
    "authors",	//1050
    "autoDetectLanguage",	//1051
    "autoRemove",	//1052
    "autoStart",	//1053
    "autoStart$",	//1054
    "autoStart0Done",	//1055
    "autoStart1Done",	//1056
    "autoStart2Done",	//1057
    "autostarts",	//1058
    "autostarts$",	//1059
    "autostarts$$",	//1060
    "availableBackends",	//1061
    "availableDictionaries",	//1062
    "availableEncodingNames",	//1063
    "availableLanguageNames",	//1064
    "availableLanguages",	//1065
    "backupFile",	//1066
    "backupFile$",	//1067
    "backupFile$$",	//1068
    "base64Decode",	//1069
    "base64Decode#",	//1070
    "base64Decode##",	//1071
    "base64Digest",	//1072
    "base64Encode",	//1073
    "base64Encode#",	//1074
    "base64Encode##",	//1075
    "base64Encode##$",	//1076
    "base64Encode#$",	//1077
    "baseGroup",	//1078
    "baseGroup$",	//1079
    "baseGroupName",	//1080
    "binaryUnitDialect",	//1081
    "bugAddress",	//1082
    "byKeyword",	//1083
    "byKeyword$",	//1084
    "bytesAvailable",	//1085
    "bytesToWrite",	//1086
    "calcResourceHash",	//1087
    "calcResourceHash$$",	//1088
    "calcResourceHash$$$",	//1089
    "calendar",	//1090
    "calendarLabel",	//1091
    "calendarLabel$",	//1092
    "calendarLabel$#",	//1093
    "calendarSystem",	//1094
    "calendarSystem$",	//1095
    "calendarSystemForCalendarType",	//1096
    "calendarSystemForCalendarType$",	//1097
    "calendarSystems",	//1098
    "calendarSystemsList",	//1099
    "calendarType",	//1100
    "calendarType$",	//1101
    "canDeleteRecursive",	//1102
    "canReadLine",	//1103
    "canRenameFromFile",	//1104
    "canRenameToFile",	//1105
    "capabilities",	//1106
    "capabilities$",	//1107
    "caption",	//1108
    "capwords",	//1109
    "capwords$",	//1110
    "capwords?",	//1111
    "catalogName",	//1112
    "categories",	//1113
    "category",	//1114
    "cd",	//1115
    "cd$",	//1116
    "changeGroup",	//1117
    "changeGroup$",	//1118
    "changeLanguage",	//1119
    "changeLanguage$",	//1120
    "charsets",	//1121
    "checkAccess",	//1122
    "checkAccess$$",	//1123
    "checkAllowedEnvironment",	//1124
    "checkAllowedEnvironment$",	//1125
    "checkAndSuggest",	//1126
    "checkAndSuggest$?",	//1127
    "checkForHeldSlave",	//1128
    "checkForHeldSlave$",	//1129
    "checkUpdate",	//1130
    "checkUpdate$$",	//1131
    "checkWord",	//1132
    "checkWord$",	//1133
    "childCount",	//1134
    "childEvent",	//1135
    "childGroup",	//1136
    "childGroup$",	//1137
    "chmod",	//1138
    "chmod$?",	//1139
    "choices",	//1140
    "choices2",	//1141
    "cleanPath",	//1142
    "cleanPath$",	//1143
    "clear",	//1144
    "clearEnvironment",	//1145
    "clearProgram",	//1146
    "clearSubjobs",	//1147
    "clone",	//1148
    "close",	//1149
    "cmp",	//1150
    "cmp#",	//1151
    "cmp#$",	//1152
    "codecForEncoding",	//1153
    "codecForName",	//1154
    "codecForName$",	//1155
    "codecForName$$",	//1156
    "command",	//1157
    "commandToCheck",	//1158
    "comment",	//1159
    "comment#",	//1160
    "compare",	//1161
    "compare#",	//1162
    "componentData",	//1163
    "componentName",	//1164
    "compress",	//1165
    "compress$",	//1166
    "confidence",	//1167
    "config",	//1168
    "config$",	//1169
    "configChanged",	//1170
    "connectNotify",	//1171
    "connectToHost",	//1172
    "connectToHost#",	//1173
    "connectToHost##",	//1174
    "connectToHost#$$$",	//1175
    "connectToHost$$$",	//1176
    "connectToHost$$$#",	//1177
    "connectToHostImplementation",	//1178
    "connectToHostImplementation$$$",	//1179
    "connectToPath",	//1180
    "connectToPath$",	//1181
    "connectToPath$$",	//1182
    "connectToPath$$$",	//1183
    "continueChecking",	//1184
    "convert",	//1185
    "convert##",	//1186
    "convertDigits",	//1187
    "convertDigits$$",	//1188
    "convertDigits$$$",	//1189
    "copyCatalogsTo",	//1190
    "copyCatalogsTo#",	//1191
    "copyTo",	//1192
    "copyTo#",	//1193
    "copyTo#$",	//1194
    "copyTo$",	//1195
    "copyTo$#",	//1196
    "copyrightStatement",	//1197
    "count",	//1198
    "countriesUsingCurrency",	//1199
    "country",	//1200
    "countryCode",	//1201
    "countryCodeToName",	//1202
    "countryCodeToName$",	//1203
    "countryDivisionCode",	//1204
    "create",	//1205
    "create#",	//1206
    "create#$",	//1207
    "create#$?",	//1208
    "create$",	//1209
    "create$#",	//1210
    "create$##?$",	//1211
    "create$$",	//1212
    "create$?",	//1213
    "create$?#",	//1214
    "createObject",	//1215
    "createObject#$?",	//1216
    "createPartObject",	//1217
    "createPartObject##$?",	//1218
    "credits",	//1219
    "csqueeze",	//1220
    "csqueeze$",	//1221
    "csqueeze$$",	//1222
    "currency",	//1223
    "currencyCode",	//1224
    "currencyCodeList",	//1225
    "currencyCodeToName",	//1226
    "currencyCodeToName$",	//1227
    "currencyCodeToName$$",	//1228
    "currencySymbol",	//1229
    "currentContext",	//1230
    "currentDateTime",	//1231
    "currentDateTime#",	//1232
    "currentGroup",	//1233
    "currentLocalDate",	//1234
    "currentLocalDateTime",	//1235
    "currentLocalTime",	//1236
    "currentOffset",	//1237
    "currentOffset$",	//1238
    "currentUtcDateTime",	//1239
    "customAuthorPlainText",	//1240
    "customAuthorRichText",	//1241
    "customAuthorTextEnabled",	//1242
    "customEvent",	//1243
    "cwd",	//1244
    "data",	//1245
    "data$",	//1246
    "dataVersion",	//1247
    "databaseChanged",	//1248
    "databaseChanged?",	//1249
    "datagramSocket",	//1250
    "datagramSocket$$",	//1251
    "datagramSocket$$#",	//1252
    "date",	//1253
    "dateDifference",	//1254
    "dateDifference##$$$$",	//1255
    "dateFormat",	//1256
    "dateFormatShort",	//1257
    "dateIntroduced",	//1258
    "dateMonthNamePossessive",	//1259
    "dateSuspended",	//1260
    "dateTime",	//1261
    "dateTimeDigitSet",	//1262
    "dateToJulianDay",	//1263
    "dateToJulianDay$$$$",	//1264
    "dateWithdrawn",	//1265
    "day",	//1266
    "day#",	//1267
    "dayOfWeek",	//1268
    "dayOfWeek#",	//1269
    "dayOfWeekString",	//1270
    "dayOfWeekString#",	//1271
    "dayOfYear",	//1272
    "dayOfYear#",	//1273
    "dayOfYearString",	//1274
    "dayOfYearString#",	//1275
    "dayOfYearString#$",	//1276
    "dayPeriodText",	//1277
    "dayPeriodText#",	//1278
    "dayPeriodText#$",	//1279
    "dayString",	//1280
    "dayString#",	//1281
    "dayString#$",	//1282
    "dayStringToInteger",	//1283
    "dayStringToInteger$$",	//1284
    "daysDifference",	//1285
    "daysDifference##",	//1286
    "daysInMonth",	//1287
    "daysInMonth#",	//1288
    "daysInMonth$$",	//1289
    "daysInMonthString",	//1290
    "daysInMonthString#",	//1291
    "daysInMonthString#$",	//1292
    "daysInWeek",	//1293
    "daysInWeek#",	//1294
    "daysInWeekString",	//1295
    "daysInWeekString#",	//1296
    "daysInYear",	//1297
    "daysInYear#",	//1298
    "daysInYear$",	//1299
    "daysInYearString",	//1300
    "daysInYearString#",	//1301
    "daysInYearString#$",	//1302
    "daysTo",	//1303
    "daysTo#",	//1304
    "dbusStartupType",	//1305
    "decimalPlaces",	//1306
    "decimalSymbol",	//1307
    "decode",	//1308
    "decode#",	//1309
    "decode$$",	//1310
    "decodeRFC2047String",	//1311
    "decodeRFC2047String$",	//1312
    "decodeWithBuffering",	//1313
    "decodeWithBuffering$$",	//1314
    "decode_string",	//1315
    "decode_string$",	//1316
    "decodedInvalidCharacters",	//1317
    "decoder",	//1318
    "defaultClient",	//1319
    "defaultCountry",	//1320
    "defaultCurrencyCode",	//1321
    "defaultLanguage",	//1322
    "defaultLanguageName",	//1323
    "defaultMimeType",	//1324
    "defaultMimeTypePtr",	//1325
    "defaultOffers",	//1326
    "defaultOffers$",	//1327
    "defaultOffers$$",	//1328
    "defaultSymbol",	//1329
    "defaults",	//1330
    "deleteEntry",	//1331
    "deleteEntry$",	//1332
    "deleteEntry$$",	//1333
    "deleteGroup",	//1334
    "deleteGroup#",	//1335
    "deleteGroup#$",	//1336
    "deleteGroup$",	//1337
    "deleteGroup$$",	//1338
    "deleteGroupImpl",	//1339
    "deleteGroupImpl#",	//1340
    "deleteGroupImpl#$",	//1341
    "dependencies",	//1342
    "deref",	//1343
    "description",	//1344
    "description#$",	//1345
    "description#$?",	//1346
    "description#$??",	//1347
    "descriptionForEncoding",	//1348
    "descriptionForEncoding$",	//1349
    "descriptiveEncodingNames",	//1350
    "deserialize",	//1351
    "deserialize#",	//1352
    "desktopEntryName",	//1353
    "desktopEntryPath",	//1354
    "desktopGroup",	//1355
    "detach",	//1356
    "details",	//1357
    "detectLanguage",	//1358
    "detectLanguage$",	//1359
    "determineMimetypeFromExtension",	//1360
    "determineMimetypeFromExtension$",	//1361
    "device",	//1362
    "device#$",	//1363
    "device#$$",	//1364
    "deviceForFile",	//1365
    "deviceForFile$",	//1366
    "deviceForFile$$",	//1367
    "deviceForFile$$$",	//1368
    "digitSet",	//1369
    "digitSetToName",	//1370
    "digitSetToName$",	//1371
    "digitSetToName$$",	//1372
    "directWriteFallback",	//1373
    "directory",	//1374
    "directory#",	//1375
    "directoryEntryPath",	//1376
    "dirs",	//1377
    "disableAutoRebuild",	//1378
    "disconnectFromHostImplementation",	//1379
    "disconnectFromPath",	//1380
    "disconnectNotify",	//1381
    "doKill",	//1382
    "doResume",	//1383
    "doSuspend",	//1384
    "docPath",	//1385
    "docPath$",	//1386
    "done",	//1387
    "earliestValidDate",	//1388
    "earlyAuthorize",	//1389
    "email",	//1390
    "emailAddress",	//1391
    "emitPercent",	//1392
    "emitPercent$$",	//1393
    "emitResult",	//1394
    "emitSpeed",	//1395
    "emitSpeed$",	//1396
    "enable_i18n",	//1397
    "encode_string",	//1398
    "encode_string$",	//1399
    "encode_string_no_slash",	//1400
    "encode_string_no_slash$",	//1401
    "encodedHtmlRef",	//1402
    "encodedPathAndQuery",	//1403
    "encodedPathAndQuery$",	//1404
    "encodedPathAndQuery$#",	//1405
    "encoding",	//1406
    "encodingChoiceSource",	//1407
    "encodingForName",	//1408
    "encodingForName$",	//1409
    "encodingMib",	//1410
    "encodingName",	//1411
    "encodingsByScript",	//1412
    "endParseBlock",	//1413
    "entries",	//1414
    "entries$",	//1415
    "entries$$",	//1416
    "entries$$$",	//1417
    "entries$$$$",	//1418
    "entryMap",	//1419
    "entryMap$",	//1420
    "entryPath",	//1421
    "epoch",	//1422
    "equals",	//1423
    "equals#",	//1424
    "equals##",	//1425
    "equivalentTo",	//1426
    "equivalentTo#",	//1427
    "eraName",	//1428
    "eraName#",	//1429
    "eraName#$",	//1430
    "eraYear",	//1431
    "eraYear#",	//1432
    "eraYear#$",	//1433
    "error",	//1434
    "errorCode",	//1435
    "errorDescription",	//1436
    "errorString",	//1437
    "errorString$",	//1438
    "errorText",	//1439
    "errorsIfUtf8",	//1440
    "errorsIfUtf8$$",	//1441
    "escapeChar",	//1442
    "event",	//1443
    "eventFilter",	//1444
    "excludedEnvironments",	//1445
    "exec",	//1446
    "exec$",	//1447
    "exec_blind",	//1448
    "exec_blind$?",	//1449
    "exec_blind$??$",	//1450
    "execute",	//1451
    "execute$",	//1452
    "execute$?",	//1453
    "execute$?$",	//1454
    "execute?",	//1455
    "execute?$",	//1456
    "executeActions",	//1457
    "executeActions??$",	//1458
    "executeActions??$#",	//1459
    "executesAsync",	//1460
    "exists",	//1461
    "exists$",	//1462
    "expandEscapedMacro",	//1463
    "expandEscapedMacro$$?",	//1464
    "expandMacro",	//1465
    "expandMacro#?",	//1466
    "expandMacro$?",	//1467
    "expandMacros",	//1468
    "expandMacros$",	//1469
    "expandMacros$?",	//1470
    "expandMacros$?#",	//1471
    "expandMacrosShellQuote",	//1472
    "expandMacrosShellQuote$",	//1473
    "expandMacrosShellQuote$$",	//1474
    "expandMacrosShellQuote$?",	//1475
    "expandMacrosShellQuote$?#",	//1476
    "expandPlainMacro",	//1477
    "expandPlainMacro$$?",	//1478
    "extraFields",	//1479
    "extraFields#",	//1480
    "extractKnownExtension",	//1481
    "extractKnownExtension$",	//1482
    "faceIconPath",	//1483
    "factories",	//1484
    "factory",	//1485
    "factory$",	//1486
    "factory$$",	//1487
    "failed",	//1488
    "favIconForUrl",	//1489
    "favIconForUrl#",	//1490
    "feed",	//1491
    "feed#",	//1492
    "feed$$",	//1493
    "fetchMoreText",	//1494
    "fileEncoding",	//1495
    "fileEncodingMib",	//1496
    "fileEngine",	//1497
    "fileName",	//1498
    "fileName#",	//1499
    "fileNameUsedForCopying",	//1500
    "filterFlags",	//1501
    "finalize",	//1502
    "findAllExe",	//1503
    "findAllExe?$",	//1504
    "findAllExe?$$",	//1505
    "findAllExe?$$$",	//1506
    "findAllResources",	//1507
    "findAllResources$",	//1508
    "findAllResources$$",	//1509
    "findAllResources$$$",	//1510
    "findAllResources$$$?",	//1511
    "findByContent",	//1512
    "findByContent#",	//1513
    "findByContent#$",	//1514
    "findByFileContent",	//1515
    "findByFileContent$",	//1516
    "findByFileContent$$",	//1517
    "findByNameAndContent",	//1518
    "findByNameAndContent$#",	//1519
    "findByNameAndContent$#?",	//1520
    "findByNameAndContent$#?$",	//1521
    "findByPath",	//1522
    "findByPath$",	//1523
    "findByPath$?",	//1524
    "findByPath$?$",	//1525
    "findByPath$?$$",	//1526
    "findByUrl",	//1527
    "findByUrl#",	//1528
    "findByUrl#?",	//1529
    "findByUrl#?$",	//1530
    "findByUrl#?$$",	//1531
    "findByUrl#?$$$",	//1532
    "findDirectChild_helper",	//1533
    "findDirectChild_helper##",	//1534
    "findDirs",	//1535
    "findDirs$$",	//1536
    "findEntry",	//1537
    "findEntry$$",	//1538
    "findExe",	//1539
    "findExe$",	//1540
    "findExe$$",	//1541
    "findExe$$$",	//1542
    "findFactory",	//1543
    "findFactory$",	//1544
    "findFilterByFileName",	//1545
    "findFilterByFileName$",	//1546
    "findFilterByMimeType",	//1547
    "findFilterByMimeType$",	//1548
    "findItem",	//1549
    "findItem$",	//1550
    "findLibrary",	//1551
    "findLibrary$",	//1552
    "findLibrary$#",	//1553
    "findResource",	//1554
    "findResource$$",	//1555
    "findResourceDir",	//1556
    "findResourceDir$$",	//1557
    "finished",	//1558
    "finished#",	//1559
    "finishedCurrentFeed",	//1560
    "firstDayOfMonth",	//1561
    "firstDayOfMonth#",	//1562
    "firstDayOfMonth$$",	//1563
    "firstDayOfYear",	//1564
    "firstDayOfYear#",	//1565
    "firstDayOfYear$",	//1566
    "flagError",	//1567
    "flush",	//1568
    "fopen",	//1569
    "fopen$$",	//1570
    "forceGlobal",	//1571
    "formatByteSize",	//1572
    "formatByteSize$",	//1573
    "formatByteSize$$",	//1574
    "formatByteSize$$$",	//1575
    "formatByteSize$$$$",	//1576
    "formatDate",	//1577
    "formatDate#",	//1578
    "formatDate#$",	//1579
    "formatDate#$$",	//1580
    "formatDate#$$$",	//1581
    "formatDateTime",	//1582
    "formatDateTime#",	//1583
    "formatDateTime#$",	//1584
    "formatDateTime#$$",	//1585
    "formatDuration",	//1586
    "formatDuration$",	//1587
    "formatLocaleTime",	//1588
    "formatLocaleTime#",	//1589
    "formatLocaleTime#$",	//1590
    "formatLong",	//1591
    "formatLong$",	//1592
    "formatMoney",	//1593
    "formatMoney$",	//1594
    "formatMoney$$",	//1595
    "formatMoney$$$",	//1596
    "formatNumber",	//1597
    "formatNumber$",	//1598
    "formatNumber$$",	//1599
    "formatNumber$$$",	//1600
    "formatTime",	//1601
    "formatTime#",	//1602
    "formatTime#$",	//1603
    "formatTime#$$",	//1604
    "fracDigits",	//1605
    "from8Bit",	//1606
    "from8Bit$",	//1607
    "fromEntity",	//1608
    "fromEntity$",	//1609
    "fromEntity$$",	//1610
    "fromFiles",	//1611
    "fromFiles?",	//1612
    "fromFiles?#",	//1613
    "fromKPartsInstanceName",	//1614
    "fromKPartsInstanceName$",	//1615
    "fromKPartsInstanceName$#",	//1616
    "fromMimeDataByteArray",	//1617
    "fromMimeDataByteArray#",	//1618
    "fromPath",	//1619
    "fromPath$",	//1620
    "fromPathOrUrl",	//1621
    "fromPathOrUrl$",	//1622
    "fromServices",	//1623
    "fromServices?",	//1624
    "fromServices?#",	//1625
    "fromString",	//1626
    "fromString$",	//1627
    "fromString$$",	//1628
    "fromString$$#",	//1629
    "fromString$$#$",	//1630
    "fromString$$$",	//1631
    "fromTime_t",	//1632
    "fromTime_t?",	//1633
    "fullLicense",	//1634
    "fullName",	//1635
    "genericName",	//1636
    "getBool",	//1637
    "getDate",	//1638
    "getDate#$$$",	//1639
    "getDouble",	//1640
    "getLockInfo",	//1641
    "getLockInfo$$$",	//1642
    "getLong",	//1643
    "getLong$",	//1644
    "getOption",	//1645
    "getOption#",	//1646
    "getOptionList",	//1647
    "getOptionList#",	//1648
    "gid",	//1649
    "group",	//1650
    "group#",	//1651
    "group$",	//1652
    "groupEntries",	//1653
    "groupEntries$",	//1654
    "groupImpl",	//1655
    "groupImpl#",	//1656
    "groupList",	//1657
    "groupNames",	//1658
    "groups",	//1659
    "hasActionGroup",	//1660
    "hasActionGroup$",	//1661
    "hasApplicationType",	//1662
    "hasAutoDetectionForScript",	//1663
    "hasAutoDetectionForScript$",	//1664
    "hasDefault",	//1665
    "hasDefault$",	//1666
    "hasDeviceType",	//1667
    "hasGroup",	//1668
    "hasGroup#",	//1669
    "hasGroup$",	//1670
    "hasGroupImpl",	//1671
    "hasGroupImpl#",	//1672
    "hasHTMLRef",	//1673
    "hasHelper",	//1674
    "hasHost",	//1675
    "hasKey",	//1676
    "hasKey$",	//1677
    "hasLinkType",	//1678
    "hasLocale",	//1679
    "hasMainComponent",	//1680
    "hasMimeType",	//1681
    "hasMimeType#",	//1682
    "hasMimeType$",	//1683
    "hasMimeTypeType",	//1684
    "hasNullOutput",	//1685
    "hasNullOutput$$$$",	//1686
    "hasNullOutputQtDebugMsg",	//1687
    "hasNullOutputQtDebugMsg$",	//1688
    "hasNullOutputQtDebugMsg$$",	//1689
    "hasPass",	//1690
    "hasPath",	//1691
    "hasPendingConnections",	//1692
    "hasRef",	//1693
    "hasServiceType",	//1694
    "hasServiceType$",	//1695
    "hasSubUrl",	//1696
    "hasSubjobs",	//1697
    "hasSubunits",	//1698
    "hasSubunitsInCirculation",	//1699
    "hasTransitions",	//1700
    "hasTransitions#",	//1701
    "hasUser",	//1702
    "helperID",	//1703
    "hexDigest",	//1704
    "hexDigest#",	//1705
    "homeDir",	//1706
    "homepage",	//1707
    "htmlRef",	//1708
    "i18n",	//1709
    "i18n$",	//1710
    "i18nc",	//1711
    "i18nc$$",	//1712
    "icon",	//1713
    "icon$",	//1714
    "iconName",	//1715
    "iconName#",	//1716
    "iconNameForUrl",	//1717
    "iconNameForUrl#",	//1718
    "iconNameForUrl#?",	//1719
    "inBufferAvailable",	//1720
    "inBufferEmpty",	//1721
    "inContext",	//1722
    "inContext$$",	//1723
    "incomingConnection",	//1724
    "incomingConnection$",	//1725
    "infoMessage",	//1726
    "infoMessage#$",	//1727
    "infoMessage#$$",	//1728
    "inherits",	//1729
    "inherits$",	//1730
    "init",	//1731
    "init#",	//1732
    "init$",	//1733
    "init$?#",	//1734
    "init$?####",	//1735
    "init$?#####",	//1736
    "init$?#####$",	//1737
    "init$?#$",	//1738
    "initialPreference",	//1739
    "inlineAlias",	//1740
    "inlineValue",	//1741
    "insertCatalog",	//1742
    "insertCatalog$",	//1743
    "installPath",	//1744
    "installPath$",	//1745
    "installedLanguages",	//1746
    "internalBugAddress",	//1747
    "internalProgramName",	//1748
    "internalVersion",	//1749
    "invokeBrowser",	//1750
    "invokeBrowser$",	//1751
    "invokeBrowser$#",	//1752
    "invokeHelp",	//1753
    "invokeHelp$",	//1754
    "invokeHelp$$",	//1755
    "invokeHelp$$#",	//1756
    "invokeMailer",	//1757
    "invokeMailer#",	//1758
    "invokeMailer##",	//1759
    "invokeMailer##$",	//1760
    "invokeMailer$$",	//1761
    "invokeMailer$$#",	//1762
    "invokeMailer$$$$$",	//1763
    "invokeMailer$$$$$$",	//1764
    "invokeMailer$$$$$$?",	//1765
    "invokeMailer$$$$$$?#",	//1766
    "invokeTerminal",	//1767
    "invokeTerminal$",	//1768
    "invokeTerminal$$",	//1769
    "invokeTerminal$$#",	//1770
    "is",	//1771
    "is$",	//1772
    "isApplication",	//1773
    "isApplicationTranslatedInto",	//1774
    "isApplicationTranslatedInto$",	//1775
    "isAuthorizedDesktopFile",	//1776
    "isAuthorizedDesktopFile$",	//1777
    "isAutoDelete",	//1778
    "isAutoErrorHandlingEnabled",	//1779
    "isAutoWarningHandlingEnabled",	//1780
    "isAvailable",	//1781
    "isBinaryData",	//1782
    "isBinaryData$",	//1783
    "isBufferBinaryData",	//1784
    "isBufferBinaryData#",	//1785
    "isBuilding",	//1786
    "isChanged",	//1787
    "isChanged$",	//1788
    "isClockTime",	//1789
    "isConfigWritable",	//1790
    "isConfigWritable$",	//1791
    "isCorrect",	//1792
    "isCorrect$",	//1793
    "isDateOnly",	//1794
    "isDefault",	//1795
    "isDeleted",	//1796
    "isDerived",	//1797
    "isDesktopFile",	//1798
    "isDesktopFile$",	//1799
    "isDirty",	//1800
    "isDst",	//1801
    "isDst#?",	//1802
    "isDst?",	//1803
    "isDstAtUtc",	//1804
    "isDstAtUtc#",	//1805
    "isDstAtUtc##",	//1806
    "isEmpty",	//1807
    "isEntryImmutable",	//1808
    "isEntryImmutable$",	//1809
    "isEqual",	//1810
    "isEqual#",	//1811
    "isFilterProtocol",	//1812
    "isFilterProtocol#",	//1813
    "isFilterProtocol$",	//1814
    "isGroupImmutable",	//1815
    "isGroupImmutable#",	//1816
    "isGroupImmutable$",	//1817
    "isGroupImmutableImpl",	//1818
    "isGroupImmutableImpl#",	//1819
    "isHelperProtocol",	//1820
    "isHelperProtocol#",	//1821
    "isHelperProtocol$",	//1822
    "isHidden",	//1823
    "isImmutable",	//1824
    "isImmutable$",	//1825
    "isKnownProtocol",	//1826
    "isKnownProtocol#",	//1827
    "isKnownProtocol$",	//1828
    "isLeapYear",	//1829
    "isLeapYear#",	//1830
    "isLeapYear$",	//1831
    "isListening",	//1832
    "isLoaded",	//1833
    "isLocalFile",	//1834
    "isLocalZone",	//1835
    "isLocked",	//1836
    "isLunar",	//1837
    "isLunisolar",	//1838
    "isMisspelled",	//1839
    "isMisspelled$",	//1840
    "isNull",	//1841
    "isOffsetFromUtc",	//1842
    "isParentOf",	//1843
    "isParentOf#",	//1844
    "isPluginEnabled",	//1845
    "isPluginEnabledByDefault",	//1846
    "isProleptic",	//1847
    "isRelativeUrl",	//1848
    "isRelativeUrl$",	//1849
    "isRestrictedResource",	//1850
    "isRestrictedResource$",	//1851
    "isRestrictedResource$$",	//1852
    "isSecondOccurrence",	//1853
    "isSeparator",	//1854
    "isSequential",	//1855
    "isServiceRegistered",	//1856
    "isServiceRegistered$",	//1857
    "isSet",	//1858
    "isSet#",	//1859
    "isSimulated",	//1860
    "isSolar",	//1861
    "isSuperUser",	//1862
    "isSuspended",	//1863
    "isTempFileSet",	//1864
    "isTimeZoneDaemonAvailable",	//1865
    "isType",	//1866
    "isType$",	//1867
    "isUtc",	//1868
    "isUtf8",	//1869
    "isUtf8$",	//1870
    "isValid",	//1871
    "isValid#",	//1872
    "isValid$",	//1873
    "isValid$$",	//1874
    "isValid$$$",	//1875
    "isValid$$$$",	//1876
    "isValidIsoWeekDate",	//1877
    "isValidIsoWeekDate$$$",	//1878
    "isoCurrencyCode",	//1879
    "isoCurrencyCodeNumeric",	//1880
    "isoName",	//1881
    "items",	//1882
    "job",	//1883
    "join",	//1884
    "join?",	//1885
    "joinArgs",	//1886
    "joinArgs?",	//1887
    "julianDayToDate",	//1888
    "julianDayToDate$$$$",	//1889
    "kAsciiToLower",	//1890
    "kAsciiToLower$",	//1891
    "kAsciiToUpper",	//1892
    "kAsciiToUpper$",	//1893
    "kBacktrace",	//1894
    "kBacktrace$",	//1895
    "kClearDebugConfig",	//1896
    "kRealBacktrace",	//1897
    "kRealBacktrace$",	//1898
    "kapplication_hook",	//1899
    "kapplication_hook?#",	//1900
    "kasciistricmp",	//1901
    "kasciistricmp$$",	//1902
    "kcmServices",	//1903
    "kdBacktrace",	//1904
    "kdBacktrace$",	//1905
    "kde_default",	//1906
    "kde_default$",	//1907
    "kdeinitExec",	//1908
    "kdeinitExec$",	//1909
    "kdeinitExec$?",	//1910
    "kdeinitExec$?$",	//1911
    "kdeinitExec$?$$",	//1912
    "kdeinitExec$?$$#",	//1913
    "kdeinitExecWait",	//1914
    "kdeinitExecWait$",	//1915
    "kdeinitExecWait$?",	//1916
    "kdeinitExecWait$?$",	//1917
    "kdeinitExecWait$?$$",	//1918
    "kdeinitExecWait$?$$#",	//1919
    "kdeinit_exec",	//1920
    "kdeinit_exec$??$$$$",	//1921
    "kdeinit_exec_wait",	//1922
    "kdeinit_exec_wait$??$$$$",	//1923
    "key",	//1924
    "keyList",	//1925
    "keywords",	//1926
    "kfsstnd_prefixes",	//1927
    "kfsstnd_xdg_conf_prefixes",	//1928
    "kfsstnd_xdg_data_prefixes",	//1929
    "ki18n",	//1930
    "ki18n$",	//1931
    "ki18nc",	//1932
    "ki18nc$$",	//1933
    "ki18ncp",	//1934
    "ki18ncp$$$",	//1935
    "ki18np",	//1936
    "ki18np$$",	//1937
    "kill",	//1938
    "kill$",	//1939
    "klauncher",	//1940
    "kndbgstream",	//1941
    "kndbgstream#",	//1942
    "label",	//1943
    "langLookup",	//1944
    "langLookup$",	//1945
    "langLookup$$",	//1946
    "language",	//1947
    "languageCodeToName",	//1948
    "languageCodeToName$",	//1949
    "languageForEncoding",	//1950
    "languageForEncoding$",	//1951
    "languageList",	//1952
    "lastDayOfMonth",	//1953
    "lastDayOfMonth#",	//1954
    "lastDayOfMonth$$",	//1955
    "lastDayOfYear",	//1956
    "lastDayOfYear#",	//1957
    "lastDayOfYear$",	//1958
    "lastErrorMessage",	//1959
    "latestValidDate",	//1960
    "latitude",	//1961
    "layoutInfo",	//1962
    "leapSecondChange",	//1963
    "leapSecondChange#",	//1964
    "leapSecondChanges",	//1965
    "leapSeconds",	//1966
    "library",	//1967
    "library$",	//1968
    "library$$",	//1969
    "license",	//1970
    "licenseName",	//1971
    "licenseName$",	//1972
    "licenses",	//1973
    "listen",	//1974
    "listen$",	//1975
    "listen$#",	//1976
    "listen$#$",	//1977
    "listen$#$#",	//1978
    "listen$$",	//1979
    "load",	//1980
    "load#",	//1981
    "loadAppArgs",	//1982
    "loadAppArgs#",	//1983
    "local",	//1984
    "localPath",	//1985
    "localSocketType",	//1986
    "locale",	//1987
    "localizedFilePath",	//1988
    "localizedFilePath$",	//1989
    "localkdedir",	//1990
    "localxdgconfdir",	//1991
    "localxdgdatadir",	//1992
    "locate",	//1993
    "locate$$",	//1994
    "locate$$#",	//1995
    "locateLocal",	//1996
    "locateLocal$",	//1997
    "locateLocal$$",	//1998
    "locateLocal$$#",	//1999
    "locateLocal$$$",	//2000
    "locateLocal$$$#",	//2001
    "location",	//2002
    "lock",	//2003
    "lock$",	//2004
    "loginName",	//2005
    "longitude",	//2006
    "lsqueeze",	//2007
    "lsqueeze$",	//2008
    "lsqueeze$$",	//2009
    "mGroup",	//2010
    "mKey",	//2011
    "mName",	//2012
    "m_bAutoDel",	//2013
    "m_canCopyFromFile",	//2014
    "m_canCopyToFile",	//2015
    "m_config",	//2016
    "m_defaultMimetype",	//2017
    "m_determineMimetypeFromExtension",	//2018
    "m_dev",	//2019
    "m_exec",	//2020
    "m_icon",	//2021
    "m_inputType",	//2022
    "m_isHelperProtocol",	//2023
    "m_isSourceProtocol",	//2024
    "m_listing",	//2025
    "m_maxSlaves",	//2026
    "m_name",	//2027
    "m_outputType",	//2028
    "m_str_deprecated",	//2029
    "m_supportsDeleting",	//2030
    "m_supportsLinking",	//2031
    "m_supportsListing",	//2032
    "m_supportsMakeDir",	//2033
    "m_supportsMoving",	//2034
    "m_supportsOpening",	//2035
    "m_supportsReading",	//2036
    "m_supportsWriting",	//2037
    "mainComponent",	//2038
    "mainExtension",	//2039
    "makeDir",	//2040
    "makeDir$",	//2041
    "makeDir$$",	//2042
    "makeURL",	//2043
    "makeURL#",	//2044
    "managedFile",	//2045
    "markAsClean",	//2046
    "matchFileName",	//2047
    "matchFileName$$",	//2048
    "maxPendingConnections",	//2049
    "maxSlaves",	//2050
    "maxSlaves$",	//2051
    "maxSlavesPerHost",	//2052
    "maxSlavesPerHost$",	//2053
    "maxValue",	//2054
    "measureSystem",	//2055
    "menuId",	//2056
    "message",	//2057
    "message$$",	//2058
    "message$$$",	//2059
    "metaObject",	//2060
    "mimeType",	//2061
    "mimeType$",	//2062
    "mimeType$$",	//2063
    "mimeTypes",	//2064
    "minValue",	//2065
    "misspelling",	//2066
    "misspelling$$",	//2067
    "mkdir",	//2068
    "mkdir$?",	//2069
    "mode",	//2070
    "modulate",	//2071
    "modulate$",	//2072
    "moduleDeleted",	//2073
    "moduleDeleted#",	//2074
    "moduleName",	//2075
    "moduleRegistered",	//2076
    "moduleRegistered#",	//2077
    "monetaryDecimalPlaces",	//2078
    "monetaryDecimalSymbol",	//2079
    "monetaryDigitSet",	//2080
    "monetaryThousandsSeparator",	//2081
    "month",	//2082
    "month#",	//2083
    "monthName",	//2084
    "monthName#",	//2085
    "monthName#$",	//2086
    "monthName$$",	//2087
    "monthName$$$",	//2088
    "monthString",	//2089
    "monthString#",	//2090
    "monthString#$",	//2091
    "monthStringToInteger",	//2092
    "monthStringToInteger$$",	//2093
    "monthsDifference",	//2094
    "monthsDifference##",	//2095
    "monthsInYear",	//2096
    "monthsInYear#",	//2097
    "monthsInYear$",	//2098
    "monthsInYearString",	//2099
    "monthsInYearString#",	//2100
    "monthsInYearString#$",	//2101
    "name",	//2102
    "name$",	//2103
    "nameForProberType",	//2104
    "nameForProberType$",	//2105
    "nameForScript",	//2106
    "nameForScript$",	//2107
    "naturalCompare",	//2108
    "naturalCompare$$",	//2109
    "naturalCompare$$$",	//2110
    "negativeMonetarySignPosition",	//2111
    "negativePrefixCurrencySymbol",	//2112
    "negativeSign",	//2113
    "newConnection",	//2114
    "newServicePath",	//2115
    "newServicePath$$",	//2116
    "newServicePath$$$",	//2117
    "newServicePath$$$?",	//2118
    "nextPendingConnection",	//2119
    "noDisplay",	//2120
    "notifyCatalogsUpdated",	//2121
    "notifyCatalogsUpdated??",	//2122
    "nounDeclension",	//2123
    "numberedBackupFile",	//2124
    "numberedBackupFile$",	//2125
    "numberedBackupFile$$",	//2126
    "numberedBackupFile$$$",	//2127
    "numberedBackupFile$$$$",	//2128
    "objectCreated",	//2129
    "objectCreated#",	//2130
    "obscure",	//2131
    "obscure$",	//2132
    "ocsProviderUrl",	//2133
    "ocsUsername",	//2134
    "offset",	//2135
    "offset#?",	//2136
    "offset?",	//2137
    "offsetAtUtc",	//2138
    "offsetAtUtc#",	//2139
    "offsetAtUtc##",	//2140
    "offsetAtZoneTime",	//2141
    "offsetAtZoneTime#",	//2142
    "offsetAtZoneTime##$",	//2143
    "offsetAtZoneTime#$",	//2144
    "open",	//2145
    "open$",	//2146
    "open$$",	//2147
    "open$$?",	//2148
    "openConfig",	//2149
    "openConfig#",	//2150
    "openConfig#$",	//2151
    "openConfig#$$",	//2152
    "openConfig#$$$",	//2153
    "openConfig$",	//2154
    "openConfig$$",	//2155
    "openConfig$$$",	//2156
    "operator QVariant",	//2157
    "operator!=",	//2158
    "operator!=#",	//2159
    "operator!=##",	//2160
    "operator!=$",	//2161
    "operator!=$#",	//2162
    "operator!=$$",	//2163
    "operator+",	//2164
    "operator+#$",	//2165
    "operator+$#",	//2166
    "operator+$$",	//2167
    "operator<",	//2168
    "operator<#",	//2169
    "operator<##",	//2170
    "operator<$#",	//2171
    "operator<$$",	//2172
    "operator<<",	//2173
    "operator<<##",	//2174
    "operator<<$",	//2175
    "operator<<?",	//2176
    "operator<=",	//2177
    "operator<=#",	//2178
    "operator<=##",	//2179
    "operator<=$#",	//2180
    "operator<=$$",	//2181
    "operator=",	//2182
    "operator=#",	//2183
    "operator=$",	//2184
    "operator==",	//2185
    "operator==#",	//2186
    "operator==##",	//2187
    "operator==$",	//2188
    "operator==$#",	//2189
    "operator==$$",	//2190
    "operator>",	//2191
    "operator>#",	//2192
    "operator>##",	//2193
    "operator>$#",	//2194
    "operator>$$",	//2195
    "operator>=",	//2196
    "operator>=#",	//2197
    "operator>=##",	//2198
    "operator>=$#",	//2199
    "operator>=$$",	//2200
    "operator>>",	//2201
    "operator>>##",	//2202
    "operator|",	//2203
    "operator|$$",	//2204
    "organizationDomain",	//2205
    "otherText",	//2206
    "outBufferAvailable",	//2207
    "outBufferFull",	//2208
    "outOfRange",	//2209
    "outputChannelMode",	//2210
    "pageSize",	//2211
    "parent",	//2212
    "parentApp",	//2213
    "parentMimeType",	//2214
    "parentMimeTypes",	//2215
    "parentServiceType",	//2216
    "parentType",	//2217
    "parentWidget",	//2218
    "parse",	//2219
    "parse#",	//2220
    "parsedArgs",	//2221
    "parsedArgs#",	//2222
    "pass",	//2223
    "path",	//2224
    "path$",	//2225
    "pathOrUrl",	//2226
    "pathOrUrl$",	//2227
    "patterns",	//2228
    "peerPath",	//2229
    "percent",	//2230
    "percent#$",	//2231
    "perlSplit",	//2232
    "perlSplit#$",	//2233
    "perlSplit#$$",	//2234
    "perlSplit$$",	//2235
    "perlSplit$$$",	//2236
    "phase",	//2237
    "phases",	//2238
    "pid",	//2239
    "pluginKeyword",	//2240
    "pluginName",	//2241
    "pluginVersion",	//2242
    "populateMimeData",	//2243
    "populateMimeData#",	//2244
    "populateMimeData#?",	//2245
    "populateMimeData#?$",	//2246
    "pos",	//2247
    "positiveMonetarySignPosition",	//2248
    "positivePrefixCurrencySymbol",	//2249
    "positiveSign",	//2250
    "preProcessWrap",	//2251
    "preProcessWrap$",	//2252
    "preferredService",	//2253
    "preferredService$",	//2254
    "preferredService$$",	//2255
    "prettyFormatDuration",	//2256
    "prettyFormatDuration$",	//2257
    "prettyUrl",	//2258
    "prettyUrl$",	//2259
    "previousUtcOffset",	//2260
    "proberType",	//2261
    "proberTypeForName",	//2262
    "proberTypeForName$",	//2263
    "processNull",	//2264
    "processNull$$",	//2265
    "processedAmount",	//2266
    "processedAmount#$$",	//2267
    "processedAmount$",	//2268
    "productName",	//2269
    "program",	//2270
    "programIconName",	//2271
    "programLogo",	//2272
    "programName",	//2273
    "progressStep",	//2274
    "progressStep$",	//2275
    "progressStep?",	//2276
    "property",	//2277
    "property$",	//2278
    "property$$",	//2279
    "propertyDef",	//2280
    "propertyDef$",	//2281
    "propertyDefNames",	//2282
    "propertyDefs",	//2283
    "propertyNames",	//2284
    "protocol",	//2285
    "protocolClass",	//2286
    "protocolClass$",	//2287
    "protocols",	//2288
    "proxiedBy",	//2289
    "proxiedBy$",	//2290
    "proxyForConnection",	//2291
    "proxyForConnection$$",	//2292
    "proxyForDatagram",	//2293
    "proxyForDatagram$$",	//2294
    "proxyForListening",	//2295
    "proxyForListening$",	//2296
    "qtArgc",	//2297
    "qtArgv",	//2298
    "qt_metacall",	//2299
    "qt_metacall$$?",	//2300
    "qt_metacast",	//2301
    "qt_metacast$",	//2302
    "query",	//2303
    "query$",	//2304
    "query$$",	//2305
    "query$$$",	//2306
    "queryItem",	//2307
    "queryItem$",	//2308
    "queryItems",	//2309
    "queryItems#",	//2310
    "quoteArg",	//2311
    "quoteArg$",	//2312
    "quotedPrintableDecode",	//2313
    "quotedPrintableDecode#",	//2314
    "quotedPrintableDecode##",	//2315
    "quotedPrintableEncode",	//2316
    "quotedPrintableEncode#",	//2317
    "quotedPrintableEncode##$",	//2318
    "quotedPrintableEncode#$",	//2319
    "random",	//2320
    "randomString",	//2321
    "randomString$",	//2322
    "rawDigest",	//2323
    "rawDigest$",	//2324
    "rcsBackupFile",	//2325
    "rcsBackupFile$",	//2326
    "rcsBackupFile$$",	//2327
    "rcsBackupFile$$$",	//2328
    "read",	//2329
    "read#$",	//2330
    "read#?",	//2331
    "readActions",	//2332
    "readComment",	//2333
    "readConfig",	//2334
    "readConfig#",	//2335
    "readData",	//2336
    "readData$$",	//2337
    "readDate",	//2338
    "readDate$",	//2339
    "readDate$$",	//2340
    "readDate$$$",	//2341
    "readDate$$$$",	//2342
    "readDefault",	//2343
    "readDefault#",	//2344
    "readDefaults",	//2345
    "readDevice",	//2346
    "readDocPath",	//2347
    "readEntry",	//2348
    "readEntry$",	//2349
    "readEntry$#",	//2350
    "readEntry$$",	//2351
    "readEntry$?",	//2352
    "readEntryUntranslated",	//2353
    "readEntryUntranslated$",	//2354
    "readEntryUntranslated$$",	//2355
    "readError",	//2356
    "readGenericName",	//2357
    "readHeader",	//2358
    "readIcon",	//2359
    "readImmutability",	//2360
    "readImmutability#",	//2361
    "readLineData",	//2362
    "readLocaleTime",	//2363
    "readLocaleTime$",	//2364
    "readLocaleTime$$",	//2365
    "readLocaleTime$$$",	//2366
    "readLocaleTime$$$$",	//2367
    "readMoney",	//2368
    "readMoney$",	//2369
    "readMoney$$",	//2370
    "readName",	//2371
    "readNumber",	//2372
    "readNumber$",	//2373
    "readNumber$$",	//2374
    "readPath",	//2375
    "readPathEntry",	//2376
    "readPathEntry$$",	//2377
    "readPathEntry$?",	//2378
    "readTime",	//2379
    "readTime$",	//2380
    "readTime$$",	//2381
    "readTime$$$",	//2382
    "readType",	//2383
    "readUrl",	//2384
    "readXdgListEntry",	//2385
    "readXdgListEntry$",	//2386
    "readXdgListEntry$?",	//2387
    "readZone",	//2388
    "readZone$",	//2389
    "realCurrentLocalDateTime",	//2390
    "realFilePath",	//2391
    "realFilePath$",	//2392
    "realLocalZone",	//2393
    "realPath",	//2394
    "realPath$",	//2395
    "ref",	//2396
    "registerArea",	//2397
    "registerArea#",	//2398
    "registerArea#$",	//2399
    "registerJob",	//2400
    "registerJob#",	//2401
    "relPath",	//2402
    "relativeLocation",	//2403
    "relativeLocation$$",	//2404
    "relativePath",	//2405
    "relativePath$$",	//2406
    "relativePath$$$",	//2407
    "relativeUrl",	//2408
    "relativeUrl##",	//2409
    "releaseLock",	//2410
    "remove",	//2411
    "remove#",	//2412
    "remove$",	//2413
    "removeAcceleratorMarker",	//2414
    "removeAcceleratorMarker$",	//2415
    "removeCatalog",	//2416
    "removeCatalog$",	//2417
    "removeDir",	//2418
    "removeDir$",	//2419
    "removeFromAllowedEnvironments",	//2420
    "removeFromAllowedEnvironments$",	//2421
    "removeFromExcludedEnvironments",	//2422
    "removeFromExcludedEnvironments$",	//2423
    "removeSubjob",	//2424
    "removeSubjob#",	//2425
    "rename",	//2426
    "rename$$",	//2427
    "reparent",	//2428
    "reparent#",	//2429
    "reparent#$",	//2430
    "reparseConfiguration",	//2431
    "replace",	//2432
    "replace$$$",	//2433
    "requestHoldSlave",	//2434
    "requestHoldSlave$$",	//2435
    "requestSlave",	//2436
    "requestSlave$$$$",	//2437
    "reset",	//2438
    "resetDecoder",	//2439
    "resolveEntities",	//2440
    "resolveEntities$",	//2441
    "resolveFunction",	//2442
    "resolveFunction$",	//2443
    "resolveSymbol",	//2444
    "resolveSymbol$",	//2445
    "resource",	//2446
    "resourceDirs",	//2447
    "resourceDirs$",	//2448
    "restore",	//2449
    "restore#",	//2450
    "resume",	//2451
    "resumed",	//2452
    "resumed#",	//2453
    "revertToDefault",	//2454
    "revertToDefault$",	//2455
    "root",	//2456
    "rsqueeze",	//2457
    "rsqueeze$",	//2458
    "rsqueeze$$",	//2459
    "save",	//2460
    "save#",	//2461
    "saveAppArgs",	//2462
    "saveAppArgs#",	//2463
    "saveLocation",	//2464
    "saveLocation$",	//2465
    "saveLocation$$",	//2466
    "saveLocation$$$",	//2467
    "scriptForName",	//2468
    "scriptForName$",	//2469
    "secsTo",	//2470
    "secsTo#",	//2471
    "secsTo_long",	//2472
    "secsTo_long#",	//2473
    "seek",	//2474
    "seek$",	//2475
    "self",	//2476
    "serialized",	//2477
    "serverError",	//2478
    "service",	//2479
    "serviceByDesktopName",	//2480
    "serviceByDesktopName$",	//2481
    "serviceByDesktopPath",	//2482
    "serviceByDesktopPath$",	//2483
    "serviceByMenuId",	//2484
    "serviceByMenuId$",	//2485
    "serviceByName",	//2486
    "serviceByName$",	//2487
    "serviceByStorageId",	//2488
    "serviceByStorageId$",	//2489
    "serviceEntries",	//2490
    "serviceEntries$",	//2491
    "serviceOffersOffset",	//2492
    "serviceType",	//2493
    "serviceType$",	//2494
    "serviceTypes",	//2495
    "setAboutData",	//2496
    "setAboutData#",	//2497
    "setActiveCatalog",	//2498
    "setActiveCatalog$",	//2499
    "setActiveComponent",	//2500
    "setActiveComponent#",	//2501
    "setAllowInline",	//2502
    "setAllowInline$",	//2503
    "setAllowQuit",	//2504
    "setAllowQuit$",	//2505
    "setAllowedEnvironments",	//2506
    "setAllowedEnvironments?",	//2507
    "setAppName",	//2508
    "setAppName#",	//2509
    "setArguments",	//2510
    "setArguments?",	//2511
    "setAttribute",	//2512
    "setAttribute$",	//2513
    "setAttribute$$",	//2514
    "setAutoDelete",	//2515
    "setAutoDelete$",	//2516
    "setAutoDetectLanguage",	//2517
    "setAutoDetectLanguage$",	//2518
    "setAutoErrorHandlingEnabled",	//2519
    "setAutoErrorHandlingEnabled$",	//2520
    "setAutoRemove",	//2521
    "setAutoRemove$",	//2522
    "setAutoWarningHandlingEnabled",	//2523
    "setAutoWarningHandlingEnabled$",	//2524
    "setAutostarts",	//2525
    "setAutostarts$",	//2526
    "setBinaryUnitDialect",	//2527
    "setBinaryUnitDialect$",	//2528
    "setBugAddress",	//2529
    "setBugAddress#",	//2530
    "setCalendar",	//2531
    "setCalendar$",	//2532
    "setCalendarSystem",	//2533
    "setCalendarSystem$",	//2534
    "setCapabilities",	//2535
    "setCapabilities$",	//2536
    "setCatalogName",	//2537
    "setCatalogName#",	//2538
    "setCommand",	//2539
    "setCommand$",	//2540
    "setCommandToCheck",	//2541
    "setCommandToCheck$",	//2542
    "setComponentData",	//2543
    "setComponentData#",	//2544
    "setConfig",	//2545
    "setConfig#",	//2546
    "setConfigName",	//2547
    "setConfigName$",	//2548
    "setCopyrightStatement",	//2549
    "setCopyrightStatement#",	//2550
    "setCountry",	//2551
    "setCountry$#",	//2552
    "setCountryDivisionCode",	//2553
    "setCountryDivisionCode$",	//2554
    "setCurrencyCode",	//2555
    "setCurrencyCode$",	//2556
    "setCurrencySymbol",	//2557
    "setCurrencySymbol$",	//2558
    "setCurrentGroup",	//2559
    "setCurrentGroup$",	//2560
    "setCustomAuthorText",	//2561
    "setCustomAuthorText##",	//2562
    "setCwd",	//2563
    "setCwd#",	//2564
    "setData",	//2565
    "setData#",	//2566
    "setData##",	//2567
    "setData?",	//2568
    "setDataVersion",	//2569
    "setDataVersion$",	//2570
    "setDate",	//2571
    "setDate#",	//2572
    "setDate#$$",	//2573
    "setDate#$$$",	//2574
    "setDate#$$$$",	//2575
    "setDateFormat",	//2576
    "setDateFormat$",	//2577
    "setDateFormatShort",	//2578
    "setDateFormatShort$",	//2579
    "setDateIsoWeek",	//2580
    "setDateIsoWeek#$$$",	//2581
    "setDateMonthNamePossessive",	//2582
    "setDateMonthNamePossessive$",	//2583
    "setDateOnly",	//2584
    "setDateOnly$",	//2585
    "setDateTime",	//2586
    "setDateTime#",	//2587
    "setDateTimeDigitSet",	//2588
    "setDateTimeDigitSet$",	//2589
    "setDecimalPlaces",	//2590
    "setDecimalPlaces$",	//2591
    "setDecimalSymbol",	//2592
    "setDecimalSymbol$",	//2593
    "setDefault",	//2594
    "setDefaultClient",	//2595
    "setDefaultClient$",	//2596
    "setDefaultLanguage",	//2597
    "setDefaultLanguage$",	//2598
    "setDefaults",	//2599
    "setDeleted",	//2600
    "setDeleted$",	//2601
    "setDetails",	//2602
    "setDetails$",	//2603
    "setDevice",	//2604
    "setDevice#",	//2605
    "setDevice#$",	//2606
    "setDigitSet",	//2607
    "setDigitSet$",	//2608
    "setDirectWriteFallback",	//2609
    "setDirectWriteFallback$",	//2610
    "setDirectory",	//2611
    "setDirectory$",	//2612
    "setEncodedPathAndQuery",	//2613
    "setEncodedPathAndQuery$",	//2614
    "setEncoding",	//2615
    "setEncoding$",	//2616
    "setEncoding$$",	//2617
    "setEnv",	//2618
    "setEnv$$",	//2619
    "setEnv$$$",	//2620
    "setError",	//2621
    "setError$",	//2622
    "setErrorCode",	//2623
    "setErrorCode$",	//2624
    "setErrorDescription",	//2625
    "setErrorDescription$",	//2626
    "setErrorText",	//2627
    "setErrorText$",	//2628
    "setEscapeChar",	//2629
    "setEscapeChar#",	//2630
    "setExcludedEnvironments",	//2631
    "setExcludedEnvironments?",	//2632
    "setExec",	//2633
    "setExec$",	//2634
    "setExecutesAsync",	//2635
    "setExecutesAsync$",	//2636
    "setFileEncoding",	//2637
    "setFileEncoding$",	//2638
    "setFileName",	//2639
    "setFileName$",	//2640
    "setFileName$#",	//2641
    "setFilterFlags",	//2642
    "setFilterFlags$",	//2643
    "setForceGlobal",	//2644
    "setForceGlobal$",	//2645
    "setFracDigits",	//2646
    "setFracDigits$",	//2647
    "setFromStringDefault",	//2648
    "setFromStringDefault#",	//2649
    "setGroup",	//2650
    "setGroup$",	//2651
    "setHTMLRef",	//2652
    "setHTMLRef$",	//2653
    "setHasYear0",	//2654
    "setHasYear0$",	//2655
    "setHelperID",	//2656
    "setHelperID$",	//2657
    "setHomepage",	//2658
    "setHomepage#",	//2659
    "setInBuffer",	//2660
    "setInBuffer$$",	//2661
    "setInlineAlias",	//2662
    "setInlineAlias$",	//2663
    "setInlineValue",	//2664
    "setInlineValue$",	//2665
    "setKDEVersion",	//2666
    "setKDEVersion$",	//2667
    "setKDEVersionString",	//2668
    "setKDEVersionString$",	//2669
    "setKey",	//2670
    "setKey$",	//2671
    "setLabel",	//2672
    "setLabel$",	//2673
    "setLanguage",	//2674
    "setLanguage$",	//2675
    "setLanguage$#",	//2676
    "setLanguage?",	//2677
    "setLaunchEnv",	//2678
    "setLaunchEnv$$",	//2679
    "setLayoutInfo",	//2680
    "setLayoutInfo?",	//2681
    "setLeapSecondChanges",	//2682
    "setLeapSecondChanges?",	//2683
    "setLicense",	//2684
    "setLicense$",	//2685
    "setLicenseText",	//2686
    "setLicenseText#",	//2687
    "setLicenseTextFile",	//2688
    "setLicenseTextFile$",	//2689
    "setLocalZone",	//2690
    "setLocalZone#",	//2691
    "setLocale",	//2692
    "setLocale#",	//2693
    "setLocale#$",	//2694
    "setLocale$",	//2695
    "setMGroup",	//2696
    "setMGroup$",	//2697
    "setMKey",	//2698
    "setMKey$",	//2699
    "setMName",	//2700
    "setMName$",	//2701
    "setM_bAutoDel",	//2702
    "setM_bAutoDel$",	//2703
    "setM_canCopyFromFile",	//2704
    "setM_canCopyFromFile$",	//2705
    "setM_canCopyToFile",	//2706
    "setM_canCopyToFile$",	//2707
    "setM_config",	//2708
    "setM_config$",	//2709
    "setM_defaultMimetype",	//2710
    "setM_defaultMimetype$",	//2711
    "setM_determineMimetypeFromExtension",	//2712
    "setM_determineMimetypeFromExtension$",	//2713
    "setM_dev",	//2714
    "setM_dev#",	//2715
    "setM_exec",	//2716
    "setM_exec$",	//2717
    "setM_icon",	//2718
    "setM_icon$",	//2719
    "setM_inputType",	//2720
    "setM_inputType$",	//2721
    "setM_isHelperProtocol",	//2722
    "setM_isHelperProtocol$",	//2723
    "setM_isSourceProtocol",	//2724
    "setM_isSourceProtocol$",	//2725
    "setM_listing",	//2726
    "setM_listing?",	//2727
    "setM_maxSlaves",	//2728
    "setM_maxSlaves$",	//2729
    "setM_name",	//2730
    "setM_name$",	//2731
    "setM_outputType",	//2732
    "setM_outputType$",	//2733
    "setM_str_deprecated",	//2734
    "setM_str_deprecated#",	//2735
    "setM_supportsDeleting",	//2736
    "setM_supportsDeleting$",	//2737
    "setM_supportsLinking",	//2738
    "setM_supportsLinking$",	//2739
    "setM_supportsListing",	//2740
    "setM_supportsListing$",	//2741
    "setM_supportsMakeDir",	//2742
    "setM_supportsMakeDir$",	//2743
    "setM_supportsMoving",	//2744
    "setM_supportsMoving$",	//2745
    "setM_supportsOpening",	//2746
    "setM_supportsOpening$",	//2747
    "setM_supportsReading",	//2748
    "setM_supportsReading$",	//2749
    "setM_supportsWriting",	//2750
    "setM_supportsWriting$",	//2751
    "setMainCatalog",	//2752
    "setMainCatalog$",	//2753
    "setManagedFile",	//2754
    "setManagedFile#",	//2755
    "setMaxDaysInWeek",	//2756
    "setMaxDaysInWeek$",	//2757
    "setMaxMonthsInYear",	//2758
    "setMaxMonthsInYear$",	//2759
    "setMaxPendingConnections",	//2760
    "setMaxPendingConnections$",	//2761
    "setMaxValue",	//2762
    "setMaxValue$",	//2763
    "setMeasureSystem",	//2764
    "setMeasureSystem$",	//2765
    "setMenuId",	//2766
    "setMenuId$",	//2767
    "setMessageHandler",	//2768
    "setMessageHandler#",	//2769
    "setMinValue",	//2770
    "setMinValue$",	//2771
    "setModuleName",	//2772
    "setModuleName$",	//2773
    "setMonetaryDecimalPlaces",	//2774
    "setMonetaryDecimalPlaces$",	//2775
    "setMonetaryDecimalSymbol",	//2776
    "setMonetaryDecimalSymbol$",	//2777
    "setMonetaryDigitSet",	//2778
    "setMonetaryDigitSet$",	//2779
    "setMonetaryThousandsSeparator",	//2780
    "setMonetaryThousandsSeparator$",	//2781
    "setName",	//2782
    "setName$",	//2783
    "setNegativeMonetarySignPosition",	//2784
    "setNegativeMonetarySignPosition$",	//2785
    "setNegativePrefixCurrencySymbol",	//2786
    "setNegativePrefixCurrencySymbol$",	//2787
    "setNegativeSign",	//2788
    "setNegativeSign$",	//2789
    "setNextOpenMode",	//2790
    "setNextOpenMode$",	//2791
    "setOcsProvider",	//2792
    "setOcsProvider#",	//2793
    "setOrganizationDomain",	//2794
    "setOrganizationDomain#",	//2795
    "setOrigFileName",	//2796
    "setOrigFileName#",	//2797
    "setOtherText",	//2798
    "setOtherText#",	//2799
    "setOutBuffer",	//2800
    "setOutBuffer$$",	//2801
    "setOutputChannelMode",	//2802
    "setOutputChannelMode$",	//2803
    "setPageSize",	//2804
    "setPageSize$",	//2805
    "setParentWidget",	//2806
    "setParentWidget#",	//2807
    "setPass",	//2808
    "setPass$",	//2809
    "setPath",	//2810
    "setPath$",	//2811
    "setPercent",	//2812
    "setPercent$",	//2813
    "setPhases",	//2814
    "setPhases?#",	//2815
    "setPhases?$",	//2816
    "setPluginEnabled",	//2817
    "setPluginEnabled$",	//2818
    "setPositiveMonetarySignPosition",	//2819
    "setPositiveMonetarySignPosition$",	//2820
    "setPositivePrefixCurrencySymbol",	//2821
    "setPositivePrefixCurrencySymbol$",	//2822
    "setPositiveSign",	//2823
    "setPositiveSign$",	//2824
    "setPrefix",	//2825
    "setPrefix$",	//2826
    "setProberType",	//2827
    "setProberType$",	//2828
    "setProcessedAmount",	//2829
    "setProcessedAmount$$",	//2830
    "setProductName",	//2831
    "setProductName#",	//2832
    "setProgram",	//2833
    "setProgram$",	//2834
    "setProgram$?",	//2835
    "setProgram?",	//2836
    "setProgramIconName",	//2837
    "setProgramIconName$",	//2838
    "setProgramLogo",	//2839
    "setProgramLogo#",	//2840
    "setProgramName",	//2841
    "setProgramName#",	//2842
    "setProperty",	//2843
    "setProperty#",	//2844
    "setProtocol",	//2845
    "setProtocol$",	//2846
    "setQuery",	//2847
    "setQuery$",	//2848
    "setReadDefaults",	//2849
    "setReadDefaults$",	//2850
    "setRef",	//2851
    "setRef$",	//2852
    "setSecondOccurrence",	//2853
    "setSecondOccurrence$",	//2854
    "setSeed",	//2855
    "setSeed$",	//2856
    "setServiceOffersOffset",	//2857
    "setServiceOffersOffset$",	//2858
    "setSharedConfig",	//2859
    "setSharedConfig?",	//2860
    "setShellCommand",	//2861
    "setShellCommand$",	//2862
    "setShortDescription",	//2863
    "setShortDescription#",	//2864
    "setShowEmptyMenu",	//2865
    "setShowEmptyMenu$",	//2866
    "setShowInlineHeader",	//2867
    "setShowInlineHeader$",	//2868
    "setSimulatedSystemTime",	//2869
    "setSimulatedSystemTime#",	//2870
    "setSkipHeaders",	//2871
    "setSpeller",	//2872
    "setSpeller#",	//2873
    "setStaleTime",	//2874
    "setStaleTime$",	//2875
    "setStartPhase",	//2876
    "setStartPhase$",	//2877
    "setSuffix",	//2878
    "setSuffix$",	//2879
    "setTerminal",	//2880
    "setTerminal$",	//2881
    "setTerminalOptions",	//2882
    "setTerminalOptions$",	//2883
    "setText",	//2884
    "setText$",	//2885
    "setThousandsSeparator",	//2886
    "setThousandsSeparator$",	//2887
    "setTime",	//2888
    "setTime#",	//2889
    "setTimeFormat",	//2890
    "setTimeFormat$",	//2891
    "setTimeSpec",	//2892
    "setTimeSpec#",	//2893
    "setTime_t",	//2894
    "setTime_t$",	//2895
    "setToolTip",	//2896
    "setToolTip$",	//2897
    "setTotalAmount",	//2898
    "setTotalAmount$$",	//2899
    "setTransitions",	//2900
    "setTransitions?",	//2901
    "setTranslator",	//2902
    "setTranslator##",	//2903
    "setType",	//2904
    "setType#",	//2905
    "setType$",	//2906
    "setType$$",	//2907
    "setUiDelegate",	//2908
    "setUiDelegate#",	//2909
    "setUser",	//2910
    "setUser$",	//2911
    "setVersion",	//2912
    "setVersion#",	//2913
    "setVisibleName",	//2914
    "setVisibleName$",	//2915
    "setWeekDayOfPray",	//2916
    "setWeekDayOfPray$",	//2917
    "setWeekNumberSystem",	//2918
    "setWeekNumberSystem$",	//2919
    "setWeekStartDay",	//2920
    "setWeekStartDay$",	//2921
    "setWhatsThis",	//2922
    "setWhatsThis$",	//2923
    "setWorkingWeekEndDay",	//2924
    "setWorkingWeekEndDay$",	//2925
    "setWorkingWeekStartDay",	//2926
    "setWorkingWeekStartDay$",	//2927
    "setYMD",	//2928
    "setYMD#$$$",	//2929
    "setupChildProcess",	//2930
    "setupTranslations",	//2931
    "sharedMimeInfoVersion",	//2932
    "shell",	//2933
    "shortDescription",	//2934
    "shortYearWindowStartYear",	//2935
    "showEmptyMenu",	//2936
    "showErrorMessage",	//2937
    "showFilePreview",	//2938
    "showFilePreview$",	//2939
    "showInKDE",	//2940
    "showInlineHeader",	//2941
    "simpleBackupFile",	//2942
    "simpleBackupFile$",	//2943
    "simpleBackupFile$$",	//2944
    "simpleBackupFile$$$",	//2945
    "size",	//2946
    "slotEngineDone",	//2947
    "slotInfoMessage",	//2948
    "slotInfoMessage#$$",	//2949
    "slotResult",	//2950
    "slotResult#",	//2951
    "slotWarning",	//2952
    "slotWarning#$$",	//2953
    "sortOrder",	//2954
    "source",	//2955
    "speed",	//2956
    "speed#$",	//2957
    "speller",	//2958
    "split",	//2959
    "split#",	//2960
    "split$",	//2961
    "splitArgs",	//2962
    "splitArgs$",	//2963
    "splitArgs$$",	//2964
    "splitArgs$$$",	//2965
    "splitLocale",	//2966
    "splitLocale$$$$$",	//2967
    "staleFiles",	//2968
    "staleFiles#",	//2969
    "staleFiles#$",	//2970
    "staleTime",	//2971
    "start",	//2972
    "startAfter",	//2973
    "startDetached",	//2974
    "startDetached$",	//2975
    "startDetached$?",	//2976
    "startDetached?",	//2977
    "startParseBlock",	//2978
    "startPhase",	//2979
    "startServiceByDesktopName",	//2980
    "startServiceByDesktopName$",	//2981
    "startServiceByDesktopName$$",	//2982
    "startServiceByDesktopName$$$",	//2983
    "startServiceByDesktopName$$$$",	//2984
    "startServiceByDesktopName$$$$$",	//2985
    "startServiceByDesktopName$$$$$#",	//2986
    "startServiceByDesktopName$$$$$#$",	//2987
    "startServiceByDesktopName$?",	//2988
    "startServiceByDesktopName$?$",	//2989
    "startServiceByDesktopName$?$$",	//2990
    "startServiceByDesktopName$?$$$",	//2991
    "startServiceByDesktopName$?$$$#",	//2992
    "startServiceByDesktopName$?$$$#$",	//2993
    "startServiceByDesktopPath",	//2994
    "startServiceByDesktopPath$",	//2995
    "startServiceByDesktopPath$$",	//2996
    "startServiceByDesktopPath$$$",	//2997
    "startServiceByDesktopPath$$$$",	//2998
    "startServiceByDesktopPath$$$$$",	//2999
    "startServiceByDesktopPath$$$$$#",	//3000
    "startServiceByDesktopPath$$$$$#$",	//3001
    "startServiceByDesktopPath$?",	//3002
    "startServiceByDesktopPath$?$",	//3003
    "startServiceByDesktopPath$?$$",	//3004
    "startServiceByDesktopPath$?$$$",	//3005
    "startServiceByDesktopPath$?$$$#",	//3006
    "startServiceByDesktopPath$?$$$#$",	//3007
    "startServiceByName",	//3008
    "startServiceByName$",	//3009
    "startServiceByName$$",	//3010
    "startServiceByName$$$",	//3011
    "startServiceByName$$$$",	//3012
    "startServiceByName$$$$$",	//3013
    "startServiceByName$$$$$#",	//3014
    "startServiceByName$$$$$#$",	//3015
    "startServiceByName$?",	//3016
    "startServiceByName$?$",	//3017
    "startServiceByName$?$$",	//3018
    "startServiceByName$?$$$",	//3019
    "startServiceByName$?$$$#",	//3020
    "startServiceByName$?$$$#$",	//3021
    "start_service_by_desktop_name",	//3022
    "start_service_by_desktop_name$??$$$$$",	//3023
    "start_service_by_desktop_path",	//3024
    "start_service_by_desktop_path$??$$$$$",	//3025
    "start_service_by_name",	//3026
    "start_service_by_name$??$$$$$",	//3027
    "state",	//3028
    "staticInterfaceName",	//3029
    "staticMetaObject",	//3030
    "staticQString",	//3031
    "staticQString$",	//3032
    "status",	//3033
    "statusChanged",	//3034
    "statusChanged$",	//3035
    "stop",	//3036
    "stop$",	//3037
    "storageId",	//3038
    "storeReplacement",	//3039
    "storeReplacement$$",	//3040
    "stream",	//3041
    "stringListToVariantList",	//3042
    "stringListToVariantList?",	//3043
    "subjobs",	//3044
    "subs",	//3045
    "subs#",	//3046
    "subs#$",	//3047
    "subs#$#",	//3048
    "subs$",	//3049
    "subs$$",	//3050
    "subs$$#",	//3051
    "subs$$$",	//3052
    "subs$$$#",	//3053
    "subs$$$$",	//3054
    "subs$$$$#",	//3055
    "substituteUid",	//3056
    "subunitSymbol",	//3057
    "subunitsPerUnit",	//3058
    "succeeded",	//3059
    "suggest",	//3060
    "suggest$",	//3061
    "suppressGenericNames",	//3062
    "suspend",	//3063
    "suspended",	//3064
    "suspended#",	//3065
    "swapDefault",	//3066
    "sycocaType",	//3067
    "symbolList",	//3068
    "sync",	//3069
    "synchronousConnectToHost",	//3070
    "synchronousConnectToHost#",	//3071
    "synchronousConnectToHost##",	//3072
    "synchronousConnectToHost##$",	//3073
    "synchronousConnectToHost#$",	//3074
    "synchronousConnectToHost#$#",	//3075
    "synchronousConnectToHost#$$$",	//3076
    "synchronousConnectToHost#$$$$",	//3077
    "synchronousConnectToHost$$$",	//3078
    "synchronousConnectToHost$$$$",	//3079
    "synchronousConnectToHost$$$$#",	//3080
    "systemPaths",	//3081
    "systemPaths$",	//3082
    "tagUrls",	//3083
    "tagUrls$",	//3084
    "task",	//3085
    "terminal",	//3086
    "terminalOptions",	//3087
    "terminate",	//3088
    "testAttribute",	//3089
    "testAttribute$",	//3090
    "text",	//3091
    "thousandsSeparator",	//3092
    "tildeExpand",	//3093
    "tildeExpand$",	//3094
    "time",	//3095
    "timeFormat",	//3096
    "timeSpec",	//3097
    "timeStamp",	//3098
    "timeType",	//3099
    "timeZone",	//3100
    "timeZones",	//3101
    "timerEvent",	//3102
    "toClockTime",	//3103
    "toEntity",	//3104
    "toEntity#",	//3105
    "toLocalFile",	//3106
    "toLocalFile$",	//3107
    "toLocalZone",	//3108
    "toMimeDataString",	//3109
    "toOffsetFromUtc",	//3110
    "toOffsetFromUtc$",	//3111
    "toString",	//3112
    "toString#",	//3113
    "toString#$",	//3114
    "toString$",	//3115
    "toTimeSpec",	//3116
    "toTimeSpec#",	//3117
    "toTime_t",	//3118
    "toTime_t#",	//3119
    "toUtc",	//3120
    "toUtc#",	//3121
    "toZone",	//3122
    "toZone#",	//3123
    "toZoneTime",	//3124
    "toZoneTime#",	//3125
    "toZoneTime#$",	//3126
    "toolTip",	//3127
    "totalAmount",	//3128
    "totalAmount#$$",	//3129
    "totalAmount$",	//3130
    "tr",	//3131
    "tr$",	//3132
    "tr$$",	//3133
    "tr$$$",	//3134
    "tr2i18n",	//3135
    "tr2i18n$",	//3136
    "tr2i18n$$",	//3137
    "trUtf8",	//3138
    "trUtf8$",	//3139
    "trUtf8$$",	//3140
    "trUtf8$$$",	//3141
    "transform",	//3142
    "transform$",	//3143
    "transition",	//3144
    "transition#",	//3145
    "transition#?",	//3146
    "transition#?$",	//3147
    "transitionIndex",	//3148
    "transitionIndex#",	//3149
    "transitionIndex#$",	//3150
    "transitionIndex#$$",	//3151
    "transitionTimes",	//3152
    "transitionTimes#",	//3153
    "transitionTimes##",	//3154
    "transitionTimes###",	//3155
    "transitions",	//3156
    "transitions#",	//3157
    "transitions##",	//3158
    "translateInternalProgramName",	//3159
    "translateQt",	//3160
    "translateQt$$$",	//3161
    "translateRaw",	//3162
    "translateRaw$$$",	//3163
    "translateRaw$$$$",	//3164
    "translateRaw$$$$$",	//3165
    "translateRaw$$$$$$",	//3166
    "translateRawFrom",	//3167
    "translateRawFrom$$$$",	//3168
    "translateRawFrom$$$$$",	//3169
    "translateRawFrom$$$$$$",	//3170
    "translateRawFrom$$$$$$$",	//3171
    "translators",	//3172
    "tryExec",	//3173
    "type",	//3174
    "uiDelegate",	//3175
    "uid",	//3176
    "umask",	//3177
    "unambiguousSymbol",	//3178
    "uncompress",	//3179
    "unlink",	//3180
    "unload",	//3181
    "unloadLibrary",	//3182
    "unloadLibrary$",	//3183
    "unlock",	//3184
    "unregisterJob",	//3185
    "unregisterJob#",	//3186
    "unsetCustomAuthorText",	//3187
    "unsetEnv",	//3188
    "unsetEnv$",	//3189
    "untranslatedGenericName",	//3190
    "upUrl",	//3191
    "update",	//3192
    "update#",	//3193
    "update$",	//3194
    "update$$",	//3195
    "updateBase",	//3196
    "updateBase#",	//3197
    "updateSignature",	//3198
    "url",	//3199
    "url$",	//3200
    "usage",	//3201
    "usage#",	//3202
    "usageError",	//3203
    "usageError$",	//3204
    "use12Clock",	//3205
    "useDefaults",	//3206
    "useDefaults$",	//3207
    "useTranscript",	//3208
    "useZoneParse",	//3209
    "user",	//3210
    "userNames",	//3211
    "userSpecifiedIconName",	//3212
    "username",	//3213
    "users",	//3214
    "usrReadConfig",	//3215
    "usrSetDefaults",	//3216
    "usrUseDefaults",	//3217
    "usrUseDefaults$",	//3218
    "usrWriteConfig",	//3219
    "utc",	//3220
    "utcOffset",	//3221
    "utcOffsets",	//3222
    "uudecode",	//3223
    "uudecode#",	//3224
    "uudecode##",	//3225
    "uuencode",	//3226
    "uuencode#",	//3227
    "uuencode##",	//3228
    "variantListToStringList",	//3229
    "variantListToStringList?",	//3230
    "verify",	//3231
    "verify#",	//3232
    "verify$",	//3233
    "version",	//3234
    "versionMajor",	//3235
    "versionMinor",	//3236
    "versionRelease",	//3237
    "versionString",	//3238
    "visibleName",	//3239
    "visuallyOrdered",	//3240
    "waitForBytesWritten",	//3241
    "waitForNewConnection",	//3242
    "waitForNewConnection$",	//3243
    "waitForNewConnection$$",	//3244
    "waitForReadyRead",	//3245
    "waitForSlave",	//3246
    "waitForSlave$",	//3247
    "warning",	//3248
    "warning#$",	//3249
    "warning#$$",	//3250
    "watcher",	//3251
    "watcher$",	//3252
    "webAddress",	//3253
    "website",	//3254
    "week",	//3255
    "week#",	//3256
    "week#$",	//3257
    "week#$$",	//3258
    "weekDayName",	//3259
    "weekDayName#",	//3260
    "weekDayName#$",	//3261
    "weekDayName$",	//3262
    "weekDayName$$",	//3263
    "weekDayOfPray",	//3264
    "weekNumber",	//3265
    "weekNumber#",	//3266
    "weekNumber#$",	//3267
    "weekNumberString",	//3268
    "weekNumberString#",	//3269
    "weekNumberString#$",	//3270
    "weekNumberSystem",	//3271
    "weekStartDay",	//3272
    "weeksInYear",	//3273
    "weeksInYear#",	//3274
    "weeksInYear#$",	//3275
    "weeksInYear$",	//3276
    "weeksInYear$$",	//3277
    "weeksInYearString",	//3278
    "weeksInYearString#",	//3279
    "weeksInYearString#$",	//3280
    "whatsThis",	//3281
    "windowRegistered",	//3282
    "windowRegistered$",	//3283
    "windowUnregistered",	//3284
    "windowUnregistered$",	//3285
    "workingWeekEndDay",	//3286
    "workingWeekStartDay",	//3287
    "writeConfig",	//3288
    "writeConfig#",	//3289
    "writeData",	//3290
    "writeData$$",	//3291
    "writeEntry",	//3292
    "writeEntry$#",	//3293
    "writeEntry$#$",	//3294
    "writeEntry$$",	//3295
    "writeEntry$$$",	//3296
    "writeEntry$?",	//3297
    "writeEntry$?$",	//3298
    "writeHeader",	//3299
    "writeHeader#",	//3300
    "writePathEntry",	//3301
    "writePathEntry$$",	//3302
    "writePathEntry$$$",	//3303
    "writePathEntry$?",	//3304
    "writePathEntry$?$",	//3305
    "writeXdgListEntry",	//3306
    "writeXdgListEntry$?",	//3307
    "writeXdgListEntry$?$",	//3308
    "year",	//3309
    "year#",	//3310
    "yearInEra",	//3311
    "yearInEra#",	//3312
    "yearInEraString",	//3313
    "yearInEraString#",	//3314
    "yearInEraString#$",	//3315
    "yearString",	//3316
    "yearString#",	//3317
    "yearString#$",	//3318
    "yearStringToInteger",	//3319
    "yearStringToInteger$$",	//3320
    "yearsDifference",	//3321
    "yearsDifference##",	//3322
    "zone",	//3323
    "zone$",	//3324
    "zoneinfoDir",	//3325
    "zones",	//3326
    "~Action",	//3327
    "~ActionReply",	//3328
    "~ActionWatcher",	//3329
    "~BackgroundChecker",	//3330
    "~Choice",	//3331
    "~Choice2",	//3332
    "~ExtraField",	//3333
    "~ItemBool",	//3334
    "~ItemDateTime",	//3335
    "~ItemDouble",	//3336
    "~ItemEnum",	//3337
    "~ItemInt",	//3338
    "~ItemIntList",	//3339
    "~ItemLongLong",	//3340
    "~ItemPassword",	//3341
    "~ItemPath",	//3342
    "~ItemPathList",	//3343
    "~ItemPoint",	//3344
    "~ItemProperty",	//3345
    "~ItemRect",	//3346
    "~ItemSize",	//3347
    "~ItemString",	//3348
    "~ItemStringList",	//3349
    "~ItemUInt",	//3350
    "~ItemULongLong",	//3351
    "~ItemUrl",	//3352
    "~ItemUrlList",	//3353
    "~KAboutData",	//3354
    "~KAboutLicense",	//3355
    "~KAboutPerson",	//3356
    "~KAutoSaveFile",	//3357
    "~KAutostart",	//3358
    "~KCalendarSystem",	//3359
    "~KCharMacroExpander",	//3360
    "~KCharsets",	//3361
    "~KCmdLineArgs",	//3362
    "~KCmdLineOptions",	//3363
    "~KComponentData",	//3364
    "~KCompositeJob",	//3365
    "~KConfig",	//3366
    "~KConfigBase",	//3367
    "~KConfigGroup",	//3368
    "~KConfigSkeletonItem",	//3369
    "~KCoreConfigSkeleton",	//3370
    "~KCurrencyCode",	//3371
    "~KDEDModule",	//3372
    "~KDEPluginVerificationData",	//3373
    "~KDateTime",	//3374
    "~KDebug",	//3375
    "~KDebugTag",	//3376
    "~KDesktopFile",	//3377
    "~KEncodingDetector",	//3378
    "~KEncodingProber",	//3379
    "~KFilterBase",	//3380
    "~KFilterDev",	//3381
    "~KJob",	//3382
    "~KJobTrackerInterface",	//3383
    "~KJobUiDelegate",	//3384
    "~KLibrary",	//3385
    "~KLocalSocket",	//3386
    "~KLocalSocketServer",	//3387
    "~KLocale",	//3388
    "~KLocalizedString",	//3389
    "~KLockFile",	//3390
    "~KMD5",	//3391
    "~KMacroExpanderBase",	//3392
    "~KMessageHandler",	//3393
    "~KMimeType",	//3394
    "~KMimeTypeTrader",	//3395
    "~KPluginFactory",	//3396
    "~KPluginInfo",	//3397
    "~KPluginLoader",	//3398
    "~KProcess",	//3399
    "~KProtocolInfo",	//3400
    "~KRandomSequence",	//3401
    "~KSaveFile",	//3402
    "~KService",	//3403
    "~KServiceAction",	//3404
    "~KServiceGroup",	//3405
    "~KServiceType",	//3406
    "~KServiceTypeTrader",	//3407
    "~KSharedConfig",	//3408
    "~KStandardDirs",	//3409
    "~KSycoca",	//3410
    "~KSycocaEntry",	//3411
    "~KSystemTimeZone",	//3412
    "~KSystemTimeZoneBackend",	//3413
    "~KSystemTimeZoneSource",	//3414
    "~KSystemTimeZones",	//3415
    "~KTempDir",	//3416
    "~KTemporaryFile",	//3417
    "~KTimeZone",	//3418
    "~KTimeZoneBackend",	//3419
    "~KTimeZoneData",	//3420
    "~KTimeZoneSource",	//3421
    "~KTimeZones",	//3422
    "~KToolInvocation",	//3423
    "~KTzfileTimeZone",	//3424
    "~KTzfileTimeZoneBackend",	//3425
    "~KTzfileTimeZoneSource",	//3426
    "~KUrl",	//3427
    "~KUser",	//3428
    "~KUserGroup",	//3429
    "~KWordMacroExpander",	//3430
    "~LeapSeconds",	//3431
    "~OrgKdeKLauncherInterface",	//3432
    "~Phase",	//3433
    "~Spec",	//3434
    "~Speller",	//3435
    "~Transition",	//3436
    "~kndbgstream",	//3437
};

// (classId, name (index in methodNames), argumentList index, number of args, method flags, return type (index in types), xcall() index)
static Smoke::Method methods[] = {
    { 0, 0, 0, 0, 0, 0, 0 },	// (no method)
    {1, 277, 1, 10, Smoke::mf_ctor, 5, 1},	//1 KAboutData::KAboutData(const QByteArray&, const QByteArray&, const KLocalizedString&, const QByteArray&, const KLocalizedString&, KAboutData::LicenseKey, const KLocalizedString&, const KLocalizedString&, const QByteArray&, const QByteArray&)
    {1, 277, 12, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 5, 2},	//2 KAboutData::KAboutData(const KAboutData&)
    {1, 2182, 12, 1, 0, 4, 3},	//3 KAboutData::operator=(const KAboutData&)
    {1, 848, 14, 4, 0, 4, 4},	//4 KAboutData::addAuthor(const KLocalizedString&, const KLocalizedString&, const QByteArray&, const QByteArray&)
    {1, 848, 19, 5, 0, 4, 5},	//5 KAboutData::addAuthor(const KLocalizedString&, const KLocalizedString&, const QByteArray&, const QByteArray&, const QByteArray&)
    {1, 861, 14, 4, 0, 4, 6},	//6 KAboutData::addCredit(const KLocalizedString&, const KLocalizedString&, const QByteArray&, const QByteArray&)
    {1, 861, 19, 5, 0, 4, 7},	//7 KAboutData::addCredit(const KLocalizedString&, const KLocalizedString&, const QByteArray&, const QByteArray&, const QByteArray&)
    {1, 2902, 25, 2, 0, 4, 8},	//8 KAboutData::setTranslator(const KLocalizedString&, const KLocalizedString&)
    {1, 2686, 28, 1, 0, 4, 9},	//9 KAboutData::setLicenseText(const KLocalizedString&)
    {1, 955, 28, 1, 0, 4, 10},	//10 KAboutData::addLicenseText(const KLocalizedString&)
    {1, 2688, 30, 1, 0, 4, 11},	//11 KAboutData::setLicenseTextFile(const QString&)
    {1, 957, 30, 1, 0, 4, 12},	//12 KAboutData::addLicenseTextFile(const QString&)
    {1, 2508, 32, 1, 0, 4, 13},	//13 KAboutData::setAppName(const QByteArray&)
    {1, 2841, 28, 1, 0, 4, 14},	//14 KAboutData::setProgramName(const KLocalizedString&)
    {1, 2837, 30, 1, 0, 4, 15},	//15 KAboutData::setProgramIconName(const QString&)
    {1, 2839, 34, 1, 0, 4, 16},	//16 KAboutData::setProgramLogo(const QVariant&)
    {1, 2792, 32, 1, 0, 4, 17},	//17 KAboutData::setOcsProvider(const QByteArray&)
    {1, 2912, 32, 1, 0, 4, 18},	//18 KAboutData::setVersion(const QByteArray&)
    {1, 2863, 28, 1, 0, 4, 19},	//19 KAboutData::setShortDescription(const KLocalizedString&)
    {1, 2537, 32, 1, 0, 4, 20},	//20 KAboutData::setCatalogName(const QByteArray&)
    {1, 2684, 36, 1, 0, 4, 21},	//21 KAboutData::setLicense(KAboutData::LicenseKey)
    {1, 953, 36, 1, 0, 4, 22},	//22 KAboutData::addLicense(KAboutData::LicenseKey)
    {1, 2549, 28, 1, 0, 4, 23},	//23 KAboutData::setCopyrightStatement(const KLocalizedString&)
    {1, 2798, 28, 1, 0, 4, 24},	//24 KAboutData::setOtherText(const KLocalizedString&)
    {1, 2658, 32, 1, 0, 4, 25},	//25 KAboutData::setHomepage(const QByteArray&)
    {1, 2529, 32, 1, 0, 4, 26},	//26 KAboutData::setBugAddress(const QByteArray&)
    {1, 2794, 32, 1, 0, 4, 27},	//27 KAboutData::setOrganizationDomain(const QByteArray&)
    {1, 2831, 32, 1, 0, 4, 28},	//28 KAboutData::setProductName(const QByteArray&)
    {1, 1029, 0, 0, Smoke::mf_const, 351, 29},	//29 KAboutData::appName() const
    {1, 2269, 0, 0, Smoke::mf_const, 351, 30},	//30 KAboutData::productName() const
    {1, 2273, 0, 0, Smoke::mf_const, 351, 31},	//31 KAboutData::programName() const
    {1, 2205, 0, 0, Smoke::mf_const, 351, 32},	//32 KAboutData::organizationDomain() const
    {1, 1748, 0, 0, Smoke::mf_const, 598, 33},	//33 KAboutData::internalProgramName() const
    {1, 3159, 0, 0, Smoke::mf_const, 0, 34},	//34 KAboutData::translateInternalProgramName() const
    {1, 2271, 0, 0, Smoke::mf_const, 351, 35},	//35 KAboutData::programIconName() const
    {1, 2272, 0, 0, Smoke::mf_const, 364, 36},	//36 KAboutData::programLogo() const
    {1, 2133, 0, 0, Smoke::mf_const, 351, 37},	//37 KAboutData::ocsProviderUrl() const
    {1, 3234, 0, 0, Smoke::mf_const, 351, 38},	//38 KAboutData::version() const
    {1, 1749, 0, 0, Smoke::mf_const, 598, 39},	//39 KAboutData::internalVersion() const
    {1, 2934, 0, 0, Smoke::mf_const, 351, 40},	//40 KAboutData::shortDescription() const
    {1, 1112, 0, 0, Smoke::mf_const, 351, 41},	//41 KAboutData::catalogName() const
    {1, 1707, 0, 0, Smoke::mf_const, 351, 42},	//42 KAboutData::homepage() const
    {1, 1082, 0, 0, Smoke::mf_const, 351, 43},	//43 KAboutData::bugAddress() const
    {1, 1747, 0, 0, Smoke::mf_const, 598, 44},	//44 KAboutData::internalBugAddress() const
    {1, 1050, 0, 0, Smoke::mf_const, 311, 45},	//45 KAboutData::authors() const
    {1, 1219, 0, 0, Smoke::mf_const, 311, 46},	//46 KAboutData::credits() const
    {1, 3172, 0, 0, Smoke::mf_const, 311, 47},	//47 KAboutData::translators() const
    {1, 828, 0, 0, Smoke::mf_static, 351, 48},	//48 KAboutData::aboutTranslationTeam()
    {1, 2206, 0, 0, Smoke::mf_const, 351, 49},	//49 KAboutData::otherText() const
    {1, 1970, 0, 0, Smoke::mf_const, 351, 50},	//50 KAboutData::license() const
    {1, 1971, 38, 1, Smoke::mf_const, 351, 51},	//51 KAboutData::licenseName(KAboutData::NameFormat) const
    {1, 1973, 0, 0, Smoke::mf_const, 310, 52},	//52 KAboutData::licenses() const
    {1, 1197, 0, 0, Smoke::mf_const, 351, 53},	//53 KAboutData::copyrightStatement() const
    {1, 1240, 0, 0, Smoke::mf_const, 351, 54},	//54 KAboutData::customAuthorPlainText() const
    {1, 1241, 0, 0, Smoke::mf_const, 351, 55},	//55 KAboutData::customAuthorRichText() const
    {1, 1242, 0, 0, Smoke::mf_const, 450, 56},	//56 KAboutData::customAuthorTextEnabled() const
    {1, 2561, 25, 2, 0, 4, 57},	//57 KAboutData::setCustomAuthorText(const KLocalizedString&, const KLocalizedString&)
    {1, 3187, 0, 0, 0, 4, 58},	//58 KAboutData::unsetCustomAuthorText()
    {1, 277, 40, 4, Smoke::mf_ctor, 5, 59},	//59 KAboutData::KAboutData(const QByteArray&, const QByteArray&, const KLocalizedString&, const QByteArray&)
    {1, 277, 45, 5, Smoke::mf_ctor, 5, 60},	//60 KAboutData::KAboutData(const QByteArray&, const QByteArray&, const KLocalizedString&, const QByteArray&, const KLocalizedString&)
    {1, 277, 51, 6, Smoke::mf_ctor, 5, 61},	//61 KAboutData::KAboutData(const QByteArray&, const QByteArray&, const KLocalizedString&, const QByteArray&, const KLocalizedString&, KAboutData::LicenseKey)
    {1, 277, 58, 7, Smoke::mf_ctor, 5, 62},	//62 KAboutData::KAboutData(const QByteArray&, const QByteArray&, const KLocalizedString&, const QByteArray&, const KLocalizedString&, KAboutData::LicenseKey, const KLocalizedString&)
    {1, 277, 66, 8, Smoke::mf_ctor, 5, 63},	//63 KAboutData::KAboutData(const QByteArray&, const QByteArray&, const KLocalizedString&, const QByteArray&, const KLocalizedString&, KAboutData::LicenseKey, const KLocalizedString&, const KLocalizedString&)
    {1, 277, 75, 9, Smoke::mf_ctor, 5, 64},	//64 KAboutData::KAboutData(const QByteArray&, const QByteArray&, const KLocalizedString&, const QByteArray&, const KLocalizedString&, KAboutData::LicenseKey, const KLocalizedString&, const KLocalizedString&, const QByteArray&)
    {1, 848, 28, 1, 0, 4, 65},	//65 KAboutData::addAuthor(const KLocalizedString&)
    {1, 848, 25, 2, 0, 4, 66},	//66 KAboutData::addAuthor(const KLocalizedString&, const KLocalizedString&)
    {1, 848, 85, 3, 0, 4, 67},	//67 KAboutData::addAuthor(const KLocalizedString&, const KLocalizedString&, const QByteArray&)
    {1, 861, 28, 1, 0, 4, 68},	//68 KAboutData::addCredit(const KLocalizedString&)
    {1, 861, 25, 2, 0, 4, 69},	//69 KAboutData::addCredit(const KLocalizedString&, const KLocalizedString&)
    {1, 861, 85, 3, 0, 4, 70},	//70 KAboutData::addCredit(const KLocalizedString&, const KLocalizedString&, const QByteArray&)
    {1, 574, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 71},	//71 KAboutData::License_Custom (enum)
    {1, 575, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 72},	//72 KAboutData::License_File (enum)
    {1, 584, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 73},	//73 KAboutData::License_Unknown (enum)
    {1, 576, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 74},	//74 KAboutData::License_GPL (enum)
    {1, 577, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 75},	//75 KAboutData::License_GPL_V2 (enum)
    {1, 579, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 76},	//76 KAboutData::License_LGPL (enum)
    {1, 580, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 77},	//77 KAboutData::License_LGPL_V2 (enum)
    {1, 573, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 78},	//78 KAboutData::License_BSD (enum)
    {1, 572, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 79},	//79 KAboutData::License_Artistic (enum)
    {1, 582, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 80},	//80 KAboutData::License_QPL (enum)
    {1, 583, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 81},	//81 KAboutData::License_QPL_V1_0 (enum)
    {1, 578, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 82},	//82 KAboutData::License_GPL_V3 (enum)
    {1, 581, 0, 0, Smoke::mf_static|Smoke::mf_enum, 6, 83},	//83 KAboutData::License_LGPL_V3 (enum)
    {1, 711, 0, 0, Smoke::mf_static|Smoke::mf_enum, 7, 84},	//84 KAboutData::ShortName (enum)
    {1, 149, 0, 0, Smoke::mf_static|Smoke::mf_enum, 7, 85},	//85 KAboutData::FullName (enum)
    {1, 3354, 0, 0, Smoke::mf_dtor, 0, 86 },	//86 KAboutData::~KAboutData()
    {2, 286, 89, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 10, 1},	//87 KAboutLicense::KAboutLicense(const KAboutLicense&)
    {2, 2182, 89, 1, 0, 9, 2},	//88 KAboutLicense::operator=(const KAboutLicense&)
    {2, 3091, 0, 0, Smoke::mf_const, 351, 3},	//89 KAboutLicense::text() const
    {2, 2102, 38, 1, Smoke::mf_const, 351, 4},	//90 KAboutLicense::name(KAboutData::NameFormat) const
    {2, 1924, 0, 0, Smoke::mf_const, 6, 5},	//91 KAboutLicense::key() const
    {2, 1083, 30, 1, Smoke::mf_static, 8, 6},	//92 KAboutLicense::byKeyword(const QString&)
    {2, 3355, 0, 0, Smoke::mf_dtor, 0, 7 },	//93 KAboutLicense::~KAboutLicense()
    {3, 288, 14, 4, Smoke::mf_ctor, 13, 1},	//94 KAboutPerson::KAboutPerson(const KLocalizedString&, const KLocalizedString&, const QByteArray&, const QByteArray&)
    {3, 288, 19, 5, Smoke::mf_ctor, 13, 2},	//95 KAboutPerson::KAboutPerson(const KLocalizedString&, const KLocalizedString&, const QByteArray&, const QByteArray&, const QByteArray&)
    {3, 288, 91, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 13, 3},	//96 KAboutPerson::KAboutPerson(const KAboutPerson&)
    {3, 2182, 91, 1, 0, 12, 4},	//97 KAboutPerson::operator=(const KAboutPerson&)
    {3, 2102, 0, 0, Smoke::mf_const, 351, 5},	//98 KAboutPerson::name() const
    {3, 3085, 0, 0, Smoke::mf_const, 351, 6},	//99 KAboutPerson::task() const
    {3, 1391, 0, 0, Smoke::mf_const, 351, 7},	//100 KAboutPerson::emailAddress() const
    {3, 3253, 0, 0, Smoke::mf_const, 351, 8},	//101 KAboutPerson::webAddress() const
    {3, 2134, 0, 0, Smoke::mf_const, 351, 9},	//102 KAboutPerson::ocsUsername() const
    {3, 288, 28, 1, Smoke::mf_ctor, 13, 10},	//103 KAboutPerson::KAboutPerson(const KLocalizedString&)
    {3, 288, 25, 2, Smoke::mf_ctor, 13, 11},	//104 KAboutPerson::KAboutPerson(const KLocalizedString&, const KLocalizedString&)
    {3, 288, 85, 3, Smoke::mf_ctor, 13, 12},	//105 KAboutPerson::KAboutPerson(const KLocalizedString&, const KLocalizedString&, const QByteArray&)
    {3, 3356, 0, 0, Smoke::mf_dtor, 0, 13 },	//106 KAboutPerson::~KAboutPerson()
    {4, 4, 0, 0, Smoke::mf_ctor, 16, 1},	//107 KAuth::Action::Action()
    {4, 4, 93, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 16, 2},	//108 KAuth::Action::Action(const KAuth::Action&)
    {4, 4, 30, 1, Smoke::mf_ctor, 16, 3},	//109 KAuth::Action::Action(const QString&)
    {4, 4, 95, 2, Smoke::mf_ctor, 16, 4},	//110 KAuth::Action::Action(const QString&, const QString&)
    {4, 2182, 93, 1, 0, 15, 5},	//111 KAuth::Action::operator=(const KAuth::Action&)
    {4, 2185, 93, 1, Smoke::mf_const, 450, 6},	//112 KAuth::Action::operator==(const KAuth::Action&) const
    {4, 2158, 93, 1, Smoke::mf_const, 450, 7},	//113 KAuth::Action::operator!=(const KAuth::Action&) const
    {4, 2102, 0, 0, Smoke::mf_const, 351, 8},	//114 KAuth::Action::name() const
    {4, 2782, 30, 1, 0, 0, 9},	//115 KAuth::Action::setName(const QString&)
    {4, 2602, 30, 1, 0, 0, 10},	//116 KAuth::Action::setDetails(const QString&)
    {4, 1357, 0, 0, Smoke::mf_const, 351, 11},	//117 KAuth::Action::details() const
    {4, 1871, 0, 0, Smoke::mf_const, 450, 12},	//118 KAuth::Action::isValid() const
    {4, 1703, 0, 0, Smoke::mf_const, 351, 13},	//119 KAuth::Action::helperID() const
    {4, 2656, 30, 1, 0, 0, 14},	//120 KAuth::Action::setHelperID(const QString&)
    {4, 1674, 0, 0, Smoke::mf_const, 450, 15},	//121 KAuth::Action::hasHelper() const
    {4, 3251, 0, 0, 0, 23, 16},	//122 KAuth::Action::watcher()
    {4, 2510, 98, 1, 0, 0, 17},	//123 KAuth::Action::setArguments(const QMap<QString,QVariant>&)
    {4, 1037, 0, 0, Smoke::mf_const, 341, 18},	//124 KAuth::Action::arguments() const
    {4, 846, 100, 2, 0, 0, 19},	//125 KAuth::Action::addArgument(const QString&, const QVariant&)
    {4, 1040, 0, 0, Smoke::mf_const, 17, 20},	//126 KAuth::Action::authorize() const
    {4, 1389, 0, 0, Smoke::mf_const, 17, 21},	//127 KAuth::Action::earlyAuthorize() const
    {4, 3033, 0, 0, Smoke::mf_const, 17, 22},	//128 KAuth::Action::status() const
    {4, 1451, 0, 0, Smoke::mf_const, 18, 23},	//129 KAuth::Action::execute() const
    {4, 1451, 30, 1, Smoke::mf_const, 18, 24},	//130 KAuth::Action::execute(const QString&) const
    {4, 2635, 103, 1, 0, 0, 25},	//131 KAuth::Action::setExecutesAsync(bool)
    {4, 1460, 0, 0, Smoke::mf_const, 450, 26},	//132 KAuth::Action::executesAsync() const
    {4, 1457, 105, 3, Smoke::mf_static, 450, 27},	//133 KAuth::Action::executeActions(const QList<KAuth::Action>&, QList<KAuth::Action>*, const QString&)
    {4, 1457, 109, 4, Smoke::mf_static, 450, 28},	//134 KAuth::Action::executeActions(const QList<KAuth::Action>&, QList<KAuth::Action>*, const QString&, QWidget*)
    {4, 3036, 0, 0, 0, 0, 29},	//135 KAuth::Action::stop()
    {4, 3036, 30, 1, 0, 0, 30},	//136 KAuth::Action::stop(const QString&)
    {4, 2806, 114, 1, 0, 0, 31},	//137 KAuth::Action::setParentWidget(QWidget*)
    {4, 2218, 0, 0, Smoke::mf_const, 368, 32},	//138 KAuth::Action::parentWidget() const
    {4, 101, 0, 0, Smoke::mf_static|Smoke::mf_enum, 17, 33},	//139 KAuth::Action::Denied (enum)
    {4, 125, 0, 0, Smoke::mf_static|Smoke::mf_enum, 17, 34},	//140 KAuth::Action::Error (enum)
    {4, 177, 0, 0, Smoke::mf_static|Smoke::mf_enum, 17, 35},	//141 KAuth::Action::Invalid (enum)
    {4, 30, 0, 0, Smoke::mf_static|Smoke::mf_enum, 17, 36},	//142 KAuth::Action::Authorized (enum)
    {4, 27, 0, 0, Smoke::mf_static|Smoke::mf_enum, 17, 37},	//143 KAuth::Action::AuthRequired (enum)
    {4, 801, 0, 0, Smoke::mf_static|Smoke::mf_enum, 17, 38},	//144 KAuth::Action::UserCancelled (enum)
    {4, 3327, 0, 0, Smoke::mf_dtor, 0, 39 },	//145 KAuth::Action::~Action()
    {5, 8, 0, 0, Smoke::mf_ctor, 20, 1},	//146 KAuth::ActionReply::ActionReply()
    {5, 8, 116, 1, Smoke::mf_ctor, 20, 2},	//147 KAuth::ActionReply::ActionReply(KAuth::ActionReply::Type)
    {5, 8, 118, 1, Smoke::mf_ctor, 20, 3},	//148 KAuth::ActionReply::ActionReply(int)
    {5, 8, 120, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 20, 4},	//149 KAuth::ActionReply::ActionReply(const KAuth::ActionReply&)
    {5, 2565, 98, 1, 0, 0, 5},	//150 KAuth::ActionReply::setData(const QMap<QString,QVariant>&)
    {5, 1245, 0, 0, Smoke::mf_const, 341, 6},	//151 KAuth::ActionReply::data() const
    {5, 869, 100, 2, 0, 0, 7},	//152 KAuth::ActionReply::addData(const QString&, const QVariant&)
    {5, 3174, 0, 0, Smoke::mf_const, 22, 8},	//153 KAuth::ActionReply::type() const
    {5, 3059, 0, 0, Smoke::mf_const, 450, 9},	//154 KAuth::ActionReply::succeeded() const
    {5, 1488, 0, 0, Smoke::mf_const, 450, 10},	//155 KAuth::ActionReply::failed() const
    {5, 1435, 0, 0, Smoke::mf_const, 614, 11},	//156 KAuth::ActionReply::errorCode() const
    {5, 2623, 118, 1, 0, 0, 12},	//157 KAuth::ActionReply::setErrorCode(int)
    {5, 1436, 0, 0, Smoke::mf_const, 351, 13},	//158 KAuth::ActionReply::errorDescription() const
    {5, 2625, 30, 1, 0, 0, 14},	//159 KAuth::ActionReply::setErrorDescription(const QString&)
    {5, 2477, 0, 0, Smoke::mf_const, 264, 15},	//160 KAuth::ActionReply::serialized() const
    {5, 1351, 32, 1, Smoke::mf_static, 18, 16},	//161 KAuth::ActionReply::deserialize(const QByteArray&)
    {5, 2182, 120, 1, 0, 19, 17},	//162 KAuth::ActionReply::operator=(const KAuth::ActionReply&)
    {5, 2185, 120, 1, Smoke::mf_const, 450, 18},	//163 KAuth::ActionReply::operator==(const KAuth::ActionReply&) const
    {5, 2158, 120, 1, Smoke::mf_const, 450, 19},	//164 KAuth::ActionReply::operator!=(const KAuth::ActionReply&) const
    {5, 741, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 461, 20},	//165 KAuth::ActionReply::SuccessReply() const
    {5, 161, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 461, 21},	//166 KAuth::ActionReply::HelperErrorReply() const
    {5, 628, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 461, 22},	//167 KAuth::ActionReply::NoResponderReply() const
    {5, 631, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 461, 23},	//168 KAuth::ActionReply::NoSuchActionReply() const
    {5, 179, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 461, 24},	//169 KAuth::ActionReply::InvalidActionReply() const
    {5, 29, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 461, 25},	//170 KAuth::ActionReply::AuthorizationDeniedReply() const
    {5, 802, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 461, 26},	//171 KAuth::ActionReply::UserCancelledReply() const
    {5, 159, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 461, 27},	//172 KAuth::ActionReply::HelperBusyReply() const
    {5, 77, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 461, 28},	//173 KAuth::ActionReply::DBusErrorReply() const
    {5, 294, 0, 0, Smoke::mf_static|Smoke::mf_enum, 22, 29},	//174 KAuth::ActionReply::KAuthError (enum)
    {5, 160, 0, 0, Smoke::mf_static|Smoke::mf_enum, 22, 30},	//175 KAuth::ActionReply::HelperError (enum)
    {5, 740, 0, 0, Smoke::mf_static|Smoke::mf_enum, 22, 31},	//176 KAuth::ActionReply::Success (enum)
    {5, 623, 0, 0, Smoke::mf_static|Smoke::mf_enum, 21, 32},	//177 KAuth::ActionReply::NoError (enum)
    {5, 627, 0, 0, Smoke::mf_static|Smoke::mf_enum, 21, 33},	//178 KAuth::ActionReply::NoResponder (enum)
    {5, 630, 0, 0, Smoke::mf_static|Smoke::mf_enum, 21, 34},	//179 KAuth::ActionReply::NoSuchAction (enum)
    {5, 178, 0, 0, Smoke::mf_static|Smoke::mf_enum, 21, 35},	//180 KAuth::ActionReply::InvalidAction (enum)
    {5, 28, 0, 0, Smoke::mf_static|Smoke::mf_enum, 21, 36},	//181 KAuth::ActionReply::AuthorizationDenied (enum)
    {5, 801, 0, 0, Smoke::mf_static|Smoke::mf_enum, 21, 37},	//182 KAuth::ActionReply::UserCancelled (enum)
    {5, 158, 0, 0, Smoke::mf_static|Smoke::mf_enum, 21, 38},	//183 KAuth::ActionReply::HelperBusy (enum)
    {5, 76, 0, 0, Smoke::mf_static|Smoke::mf_enum, 21, 39},	//184 KAuth::ActionReply::DBusError (enum)
    {5, 3328, 0, 0, Smoke::mf_dtor, 0, 40 },	//185 KAuth::ActionReply::~ActionReply()
    {6, 2060, 0, 0, Smoke::mf_const, 582, 1},	//186 KAuth::ActionWatcher::metaObject() const
    {6, 2301, 122, 1, 0, 639, 2},	//187 KAuth::ActionWatcher::qt_metacast(const char*)
    {6, 3131, 124, 2, Smoke::mf_static, 351, 3},	//188 KAuth::ActionWatcher::tr(const char*, const char*)
    {6, 3138, 124, 2, Smoke::mf_static, 351, 4},	//189 KAuth::ActionWatcher::trUtf8(const char*, const char*)
    {6, 3131, 127, 3, Smoke::mf_static, 351, 5},	//190 KAuth::ActionWatcher::tr(const char*, const char*, int)
    {6, 3138, 127, 3, Smoke::mf_static, 351, 6},	//191 KAuth::ActionWatcher::trUtf8(const char*, const char*, int)
    {6, 2299, 131, 3, 0, 614, 7},	//192 KAuth::ActionWatcher::qt_metacall(QMetaObject::Call, int, void**)
    {6, 3251, 30, 1, Smoke::mf_static, 23, 8},	//193 KAuth::ActionWatcher::watcher(const QString&)
    {6, 834, 0, 0, Smoke::mf_const, 351, 9},	//194 KAuth::ActionWatcher::action() const
    {6, 839, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 10},	//195 KAuth::ActionWatcher::actionStarted()
    {6, 837, 120, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 11},	//196 KAuth::ActionWatcher::actionPerformed(const KAuth::ActionReply&)
    {6, 2274, 118, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 12},	//197 KAuth::ActionWatcher::progressStep(int)
    {6, 2274, 135, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 13},	//198 KAuth::ActionWatcher::progressStep(const QVariantMap&)
    {6, 3034, 118, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 14},	//199 KAuth::ActionWatcher::statusChanged(int)
    {6, 3131, 122, 1, Smoke::mf_static, 351, 15},	//200 KAuth::ActionWatcher::tr(const char*)
    {6, 3138, 122, 1, Smoke::mf_static, 351, 16},	//201 KAuth::ActionWatcher::trUtf8(const char*)
    {6, 3030, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 581, 17},	//202 KAuth::ActionWatcher::staticMetaObject() const
    {6, 3329, 0, 0, Smoke::mf_dtor, 0, 18 },	//203 KAuth::ActionWatcher::~ActionWatcher()
    {7, 1024, 137, 3, Smoke::mf_static, 0, 1},	//204 KAuthorized::allowUrlAction(const QString&, const KUrl&, const KUrl&)
    {7, 1042, 30, 1, Smoke::mf_static, 450, 2},	//205 KAuthorized::authorizeControlModule(const QString&)
    {7, 1044, 141, 1, Smoke::mf_static, 354, 3},	//206 KAuthorized::authorizeControlModules(const QStringList&)
    {7, 1040, 30, 1, Smoke::mf_static, 450, 4},	//207 KAuthorized::authorize(const QString&)
    {7, 1046, 30, 1, Smoke::mf_static, 450, 5},	//208 KAuthorized::authorizeKAction(const QString&)
    {7, 1048, 137, 3, Smoke::mf_static, 450, 6},	//209 KAuthorized::authorizeUrlAction(const QString&, const KUrl&, const KUrl&)
    {8, 2060, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 582, 1},	//210 KAutoSaveFile::metaObject() const
    {8, 2301, 122, 1, Smoke::mf_virtual, 639, 2},	//211 KAutoSaveFile::qt_metacast(const char*)
    {8, 3131, 124, 2, Smoke::mf_static, 351, 3},	//212 KAutoSaveFile::tr(const char*, const char*)
    {8, 3138, 124, 2, Smoke::mf_static, 351, 4},	//213 KAutoSaveFile::trUtf8(const char*, const char*)
    {8, 3131, 127, 3, Smoke::mf_static, 351, 5},	//214 KAutoSaveFile::tr(const char*, const char*, int)
    {8, 3138, 127, 3, Smoke::mf_static, 351, 6},	//215 KAutoSaveFile::trUtf8(const char*, const char*, int)
    {8, 2299, 131, 3, Smoke::mf_virtual, 614, 7},	//216 KAutoSaveFile::qt_metacall(QMetaObject::Call, int, void**)
    {8, 295, 143, 2, Smoke::mf_ctor, 24, 8},	//217 KAutoSaveFile::KAutoSaveFile(const KUrl&, QObject*)
    {8, 295, 146, 1, Smoke::mf_ctor, 24, 9},	//218 KAutoSaveFile::KAutoSaveFile(QObject*)
    {8, 2045, 0, 0, Smoke::mf_const, 239, 10},	//219 KAutoSaveFile::managedFile() const
    {8, 2754, 148, 1, 0, 0, 11},	//220 KAutoSaveFile::setManagedFile(const KUrl&)
    {8, 2410, 0, 0, Smoke::mf_virtual, 0, 12},	//221 KAutoSaveFile::releaseLock()
    {8, 2145, 150, 1, Smoke::mf_virtual, 450, 13},	//222 KAutoSaveFile::open(QFlags<QIODevice::OpenModeFlag>)
    {8, 2968, 152, 2, Smoke::mf_static, 313, 14},	//223 KAutoSaveFile::staleFiles(const KUrl&, const QString&)
    {8, 1016, 30, 1, Smoke::mf_static, 313, 15},	//224 KAutoSaveFile::allStaleFiles(const QString&)
    {8, 3131, 122, 1, Smoke::mf_static, 351, 16},	//225 KAutoSaveFile::tr(const char*)
    {8, 3138, 122, 1, Smoke::mf_static, 351, 17},	//226 KAutoSaveFile::trUtf8(const char*)
    {8, 295, 148, 1, Smoke::mf_ctor, 24, 18},	//227 KAutoSaveFile::KAutoSaveFile(const KUrl&)
    {8, 295, 0, 0, Smoke::mf_ctor, 24, 19},	//228 KAutoSaveFile::KAutoSaveFile()
    {8, 2968, 148, 1, Smoke::mf_static, 313, 20},	//229 KAutoSaveFile::staleFiles(const KUrl&)
    {8, 1016, 0, 0, Smoke::mf_static, 313, 21},	//230 KAutoSaveFile::allStaleFiles()
    {8, 3030, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 581, 22},	//231 KAutoSaveFile::staticMetaObject() const
    {8, 3357, 0, 0, Smoke::mf_dtor, 0, 23 },	//232 KAutoSaveFile::~KAutoSaveFile()
    {9, 2060, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 582, 1},	//233 KAutostart::metaObject() const
    {9, 2301, 122, 1, Smoke::mf_virtual, 639, 2},	//234 KAutostart::qt_metacast(const char*)
    {9, 3131, 124, 2, Smoke::mf_static, 351, 3},	//235 KAutostart::tr(const char*, const char*)
    {9, 3138, 124, 2, Smoke::mf_static, 351, 4},	//236 KAutostart::trUtf8(const char*, const char*)
    {9, 3131, 127, 3, Smoke::mf_static, 351, 5},	//237 KAutostart::tr(const char*, const char*, int)
    {9, 3138, 127, 3, Smoke::mf_static, 351, 6},	//238 KAutostart::trUtf8(const char*, const char*, int)
    {9, 2299, 131, 3, Smoke::mf_virtual, 614, 7},	//239 KAutostart::qt_metacall(QMetaObject::Call, int, void**)
    {9, 298, 155, 2, Smoke::mf_ctor, 25, 8},	//240 KAutostart::KAutostart(const QString&, QObject*)
    {9, 2525, 103, 1, 0, 0, 9},	//241 KAutostart::setAutostarts(bool)
    {9, 1058, 158, 2, Smoke::mf_const, 450, 10},	//242 KAutostart::autostarts(const QString&, QFlags<KAutostart::Condition>) const
    {9, 1157, 0, 0, Smoke::mf_const, 351, 11},	//243 KAutostart::command() const
    {9, 2539, 30, 1, 0, 0, 12},	//244 KAutostart::setCommand(const QString&)
    {9, 3239, 0, 0, Smoke::mf_const, 351, 13},	//245 KAutostart::visibleName() const
    {9, 2914, 30, 1, 0, 0, 14},	//246 KAutostart::setVisibleName(const QString&)
    {9, 1856, 30, 1, Smoke::mf_static, 450, 15},	//247 KAutostart::isServiceRegistered(const QString&)
    {9, 1158, 0, 0, Smoke::mf_const, 351, 16},	//248 KAutostart::commandToCheck() const
    {9, 2541, 30, 1, 0, 0, 17},	//249 KAutostart::setCommandToCheck(const QString&)
    {9, 2979, 0, 0, Smoke::mf_const, 27, 18},	//250 KAutostart::startPhase() const
    {9, 2876, 161, 1, 0, 0, 19},	//251 KAutostart::setStartPhase(KAutostart::StartPhase)
    {9, 1026, 0, 0, Smoke::mf_const, 354, 20},	//252 KAutostart::allowedEnvironments() const
    {9, 2506, 141, 1, 0, 0, 21},	//253 KAutostart::setAllowedEnvironments(const QStringList&)
    {9, 984, 30, 1, 0, 0, 22},	//254 KAutostart::addToAllowedEnvironments(const QString&)
    {9, 2420, 30, 1, 0, 0, 23},	//255 KAutostart::removeFromAllowedEnvironments(const QString&)
    {9, 1445, 0, 0, Smoke::mf_const, 354, 24},	//256 KAutostart::excludedEnvironments() const
    {9, 2631, 141, 1, 0, 0, 25},	//257 KAutostart::setExcludedEnvironments(const QStringList&)
    {9, 986, 30, 1, 0, 0, 26},	//258 KAutostart::addToExcludedEnvironments(const QString&)
    {9, 2422, 30, 1, 0, 0, 27},	//259 KAutostart::removeFromExcludedEnvironments(const QString&)
    {9, 2973, 0, 0, Smoke::mf_const, 351, 28},	//260 KAutostart::startAfter() const
    {9, 1124, 30, 1, Smoke::mf_const, 450, 29},	//261 KAutostart::checkAllowedEnvironment(const QString&) const
    {9, 3131, 122, 1, Smoke::mf_static, 351, 30},	//262 KAutostart::tr(const char*)
    {9, 3138, 122, 1, Smoke::mf_static, 351, 31},	//263 KAutostart::trUtf8(const char*)
    {9, 298, 0, 0, Smoke::mf_ctor, 25, 32},	//264 KAutostart::KAutostart()
    {9, 298, 30, 1, Smoke::mf_ctor, 25, 33},	//265 KAutostart::KAutostart(const QString&)
    {9, 1058, 0, 0, Smoke::mf_const, 450, 34},	//266 KAutostart::autostarts() const
    {9, 1058, 30, 1, Smoke::mf_const, 450, 35},	//267 KAutostart::autostarts(const QString&) const
    {9, 3030, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 581, 36},	//268 KAutostart::staticMetaObject() const
    {9, 621, 0, 0, Smoke::mf_static|Smoke::mf_enum, 26, 37},	//269 KAutostart::NoConditions (enum)
    {9, 51, 0, 0, Smoke::mf_static|Smoke::mf_enum, 26, 38},	//270 KAutostart::CheckCommand (enum)
    {9, 52, 0, 0, Smoke::mf_static|Smoke::mf_enum, 26, 39},	//271 KAutostart::CheckCondition (enum)
    {9, 50, 0, 0, Smoke::mf_static|Smoke::mf_enum, 26, 40},	//272 KAutostart::CheckAll (enum)
    {9, 40, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 41},	//273 KAutostart::BaseDesktop (enum)
    {9, 102, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 42},	//274 KAutostart::DesktopServices (enum)
    {9, 21, 0, 0, Smoke::mf_static|Smoke::mf_enum, 27, 43},	//275 KAutostart::Applications (enum)
    {9, 3358, 0, 0, Smoke::mf_dtor, 0, 44 },	//276 KAutostart::~KAutostart()
    {10, 1205, 163, 2, Smoke::mf_static, 28, 1},	//277 KCalendarSystem::create(const QString&, const KLocale*)
    {10, 1205, 166, 3, Smoke::mf_static, 28, 2},	//278 KCalendarSystem::create(const QString&, KSharedPtr<KSharedConfig>, const KLocale*)
    {10, 1205, 170, 2, Smoke::mf_static, 28, 3},	//279 KCalendarSystem::create(KLocale::CalendarSystem, const KLocale*)
    {10, 1205, 173, 3, Smoke::mf_static, 28, 4},	//280 KCalendarSystem::create(KLocale::CalendarSystem, KSharedPtr<KSharedConfig>, const KLocale*)
    {10, 1098, 0, 0, Smoke::mf_static, 354, 5},	//281 KCalendarSystem::calendarSystems()
    {10, 1099, 0, 0, Smoke::mf_static, 317, 6},	//282 KCalendarSystem::calendarSystemsList()
    {10, 1091, 30, 1, Smoke::mf_static, 351, 7},	//283 KCalendarSystem::calendarLabel(const QString&)
    {10, 1091, 170, 2, Smoke::mf_static, 351, 8},	//284 KCalendarSystem::calendarLabel(KLocale::CalendarSystem, const KLocale*)
    {10, 1096, 30, 1, Smoke::mf_static, 126, 9},	//285 KCalendarSystem::calendarSystemForCalendarType(const QString&)
    {10, 1094, 30, 1, Smoke::mf_static, 126, 10},	//286 KCalendarSystem::calendarSystem(const QString&)
    {10, 1100, 177, 1, Smoke::mf_static, 351, 11},	//287 KCalendarSystem::calendarType(KLocale::CalendarSystem)
    {10, 301, 179, 1, Smoke::mf_ctor, 28, 12},	//288 KCalendarSystem::KCalendarSystem(const KLocale*)
    {10, 301, 181, 2, Smoke::mf_ctor, 28, 13},	//289 KCalendarSystem::KCalendarSystem(const KSharedPtr<KSharedConfig>, const KLocale*)
    {10, 1100, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 351, 14},	//290 KCalendarSystem::calendarType() const [pure virtual]
    {10, 1094, 0, 0, Smoke::mf_const, 126, 15},	//291 KCalendarSystem::calendarSystem() const
    {10, 1091, 0, 0, Smoke::mf_const, 351, 16},	//292 KCalendarSystem::calendarLabel() const
    {10, 1422, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 276, 17},	//293 KCalendarSystem::epoch() const
    {10, 1388, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 276, 18},	//294 KCalendarSystem::earliestValidDate() const
    {10, 1960, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 276, 19},	//295 KCalendarSystem::latestValidDate() const
    {10, 1871, 184, 3, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 450, 20},	//296 KCalendarSystem::isValid(int, int, int) const [pure virtual]
    {10, 1871, 188, 2, Smoke::mf_const, 450, 21},	//297 KCalendarSystem::isValid(int, int) const
    {10, 1871, 191, 4, Smoke::mf_const, 450, 22},	//298 KCalendarSystem::isValid(const QString&, int, int, int) const
    {10, 1877, 184, 3, Smoke::mf_const, 450, 23},	//299 KCalendarSystem::isValidIsoWeekDate(int, int, int) const
    {10, 1871, 196, 1, Smoke::mf_const|Smoke::mf_virtual, 450, 24},	//300 KCalendarSystem::isValid(const QDate&) const
    {10, 2571, 198, 4, Smoke::mf_const|Smoke::mf_virtual, 450, 25},	//301 KCalendarSystem::setDate(QDate&, int, int, int) const
    {10, 2571, 203, 3, Smoke::mf_const, 450, 26},	//302 KCalendarSystem::setDate(QDate&, int, int) const
    {10, 2571, 207, 5, Smoke::mf_const, 450, 27},	//303 KCalendarSystem::setDate(QDate&, QString, int, int, int) const
    {10, 2580, 198, 4, Smoke::mf_const, 450, 28},	//304 KCalendarSystem::setDateIsoWeek(QDate&, int, int, int) const
    {10, 2928, 198, 4, Smoke::mf_const|Smoke::mf_virtual, 450, 29},	//305 KCalendarSystem::setYMD(QDate&, int, int, int) const
    {10, 1638, 213, 4, Smoke::mf_const, 0, 30},	//306 KCalendarSystem::getDate(const QDate, int*, int*, int*) const
    {10, 3309, 196, 1, Smoke::mf_const|Smoke::mf_virtual, 614, 31},	//307 KCalendarSystem::year(const QDate&) const
    {10, 2082, 196, 1, Smoke::mf_const|Smoke::mf_virtual, 614, 32},	//308 KCalendarSystem::month(const QDate&) const
    {10, 1266, 196, 1, Smoke::mf_const|Smoke::mf_virtual, 614, 33},	//309 KCalendarSystem::day(const QDate&) const
    {10, 1428, 218, 2, Smoke::mf_const, 351, 34},	//310 KCalendarSystem::eraName(const QDate&, KCalendarSystem::StringFormat) const
    {10, 1431, 218, 2, Smoke::mf_const, 351, 35},	//311 KCalendarSystem::eraYear(const QDate&, KCalendarSystem::StringFormat) const
    {10, 3311, 196, 1, Smoke::mf_const, 614, 36},	//312 KCalendarSystem::yearInEra(const QDate&) const
    {10, 998, 221, 2, Smoke::mf_const|Smoke::mf_virtual, 276, 37},	//313 KCalendarSystem::addYears(const QDate&, int) const
    {10, 961, 221, 2, Smoke::mf_const|Smoke::mf_virtual, 276, 38},	//314 KCalendarSystem::addMonths(const QDate&, int) const
    {10, 871, 221, 2, Smoke::mf_const|Smoke::mf_virtual, 276, 39},	//315 KCalendarSystem::addDays(const QDate&, int) const
    {10, 1254, 224, 6, Smoke::mf_const, 0, 40},	//316 KCalendarSystem::dateDifference(const QDate&, const QDate&, int*, int*, int*, int*) const
    {10, 3321, 231, 2, Smoke::mf_const, 614, 41},	//317 KCalendarSystem::yearsDifference(const QDate&, const QDate&) const
    {10, 2094, 231, 2, Smoke::mf_const, 614, 42},	//318 KCalendarSystem::monthsDifference(const QDate&, const QDate&) const
    {10, 1285, 231, 2, Smoke::mf_const, 614, 43},	//319 KCalendarSystem::daysDifference(const QDate&, const QDate&) const
    {10, 2096, 196, 1, Smoke::mf_const|Smoke::mf_virtual, 614, 44},	//320 KCalendarSystem::monthsInYear(const QDate&) const
    {10, 2096, 118, 1, Smoke::mf_const, 614, 45},	//321 KCalendarSystem::monthsInYear(int) const
    {10, 3273, 196, 1, Smoke::mf_const|Smoke::mf_virtual, 614, 46},	//322 KCalendarSystem::weeksInYear(const QDate&) const
    {10, 3273, 234, 2, Smoke::mf_const, 614, 47},	//323 KCalendarSystem::weeksInYear(const QDate&, KLocale::WeekNumberSystem) const
    {10, 3273, 118, 1, Smoke::mf_const|Smoke::mf_virtual, 614, 48},	//324 KCalendarSystem::weeksInYear(int) const
    {10, 3273, 237, 2, Smoke::mf_const, 614, 49},	//325 KCalendarSystem::weeksInYear(int, KLocale::WeekNumberSystem) const
    {10, 1297, 196, 1, Smoke::mf_const|Smoke::mf_virtual, 614, 50},	//326 KCalendarSystem::daysInYear(const QDate&) const
    {10, 1297, 118, 1, Smoke::mf_const, 614, 51},	//327 KCalendarSystem::daysInYear(int) const
    {10, 1287, 196, 1, Smoke::mf_const|Smoke::mf_virtual, 614, 52},	//328 KCalendarSystem::daysInMonth(const QDate&) const
    {10, 1287, 188, 2, Smoke::mf_const, 614, 53},	//329 KCalendarSystem::daysInMonth(int, int) const
    {10, 1293, 196, 1, Smoke::mf_const|Smoke::mf_virtual, 614, 54},	//330 KCalendarSystem::daysInWeek(const QDate&) const
    {10, 1272, 196, 1, Smoke::mf_const|Smoke::mf_virtual, 614, 55},	//331 KCalendarSystem::dayOfYear(const QDate&) const
    {10, 1268, 196, 1, Smoke::mf_const|Smoke::mf_virtual, 614, 56},	//332 KCalendarSystem::dayOfWeek(const QDate&) const
    {10, 3265, 240, 2, Smoke::mf_const|Smoke::mf_virtual, 614, 57},	//333 KCalendarSystem::weekNumber(const QDate&, int*) const
    {10, 3255, 240, 2, Smoke::mf_const, 614, 58},	//334 KCalendarSystem::week(const QDate&, int*) const
    {10, 3255, 243, 3, Smoke::mf_const, 614, 59},	//335 KCalendarSystem::week(const QDate&, KLocale::WeekNumberSystem, int*) const
    {10, 1829, 118, 1, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 450, 60},	//336 KCalendarSystem::isLeapYear(int) const [pure virtual]
    {10, 1829, 196, 1, Smoke::mf_const|Smoke::mf_virtual, 450, 61},	//337 KCalendarSystem::isLeapYear(const QDate&) const
    {10, 1564, 118, 1, Smoke::mf_const, 276, 62},	//338 KCalendarSystem::firstDayOfYear(int) const
    {10, 1956, 118, 1, Smoke::mf_const, 276, 63},	//339 KCalendarSystem::lastDayOfYear(int) const
    {10, 1564, 196, 1, Smoke::mf_const, 276, 64},	//340 KCalendarSystem::firstDayOfYear(const QDate&) const
    {10, 1956, 196, 1, Smoke::mf_const, 276, 65},	//341 KCalendarSystem::lastDayOfYear(const QDate&) const
    {10, 1561, 188, 2, Smoke::mf_const, 276, 66},	//342 KCalendarSystem::firstDayOfMonth(int, int) const
    {10, 1953, 188, 2, Smoke::mf_const, 276, 67},	//343 KCalendarSystem::lastDayOfMonth(int, int) const
    {10, 1561, 196, 1, Smoke::mf_const, 276, 68},	//344 KCalendarSystem::firstDayOfMonth(const QDate&) const
    {10, 1953, 196, 1, Smoke::mf_const, 276, 69},	//345 KCalendarSystem::lastDayOfMonth(const QDate&) const
    {10, 2084, 247, 3, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 351, 70},	//346 KCalendarSystem::monthName(int, int, KCalendarSystem::MonthNameFormat) const [pure virtual]
    {10, 2084, 251, 2, Smoke::mf_const|Smoke::mf_virtual, 351, 71},	//347 KCalendarSystem::monthName(const QDate&, KCalendarSystem::MonthNameFormat) const
    {10, 3259, 254, 2, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 351, 72},	//348 KCalendarSystem::weekDayName(int, KCalendarSystem::WeekDayNameFormat) const [pure virtual]
    {10, 3259, 257, 2, Smoke::mf_const|Smoke::mf_virtual, 351, 73},	//349 KCalendarSystem::weekDayName(const QDate&, KCalendarSystem::WeekDayNameFormat) const
    {10, 3316, 218, 2, Smoke::mf_const|Smoke::mf_virtual, 351, 74},	//350 KCalendarSystem::yearString(const QDate&, KCalendarSystem::StringFormat) const
    {10, 2089, 218, 2, Smoke::mf_const|Smoke::mf_virtual, 351, 75},	//351 KCalendarSystem::monthString(const QDate&, KCalendarSystem::StringFormat) const
    {10, 1280, 218, 2, Smoke::mf_const|Smoke::mf_virtual, 351, 76},	//352 KCalendarSystem::dayString(const QDate&, KCalendarSystem::StringFormat) const
    {10, 3313, 218, 2, Smoke::mf_const, 351, 77},	//353 KCalendarSystem::yearInEraString(const QDate&, KCalendarSystem::StringFormat) const
    {10, 1274, 218, 2, Smoke::mf_const, 351, 78},	//354 KCalendarSystem::dayOfYearString(const QDate&, KCalendarSystem::StringFormat) const
    {10, 1270, 196, 1, Smoke::mf_const, 351, 79},	//355 KCalendarSystem::dayOfWeekString(const QDate&) const
    {10, 3268, 218, 2, Smoke::mf_const, 351, 80},	//356 KCalendarSystem::weekNumberString(const QDate&, KCalendarSystem::StringFormat) const
    {10, 2099, 218, 2, Smoke::mf_const, 351, 81},	//357 KCalendarSystem::monthsInYearString(const QDate&, KCalendarSystem::StringFormat) const
    {10, 3278, 218, 2, Smoke::mf_const, 351, 82},	//358 KCalendarSystem::weeksInYearString(const QDate&, KCalendarSystem::StringFormat) const
    {10, 1300, 218, 2, Smoke::mf_const, 351, 83},	//359 KCalendarSystem::daysInYearString(const QDate&, KCalendarSystem::StringFormat) const
    {10, 1290, 218, 2, Smoke::mf_const, 351, 84},	//360 KCalendarSystem::daysInMonthString(const QDate&, KCalendarSystem::StringFormat) const
    {10, 1295, 196, 1, Smoke::mf_const, 351, 85},	//361 KCalendarSystem::daysInWeekString(const QDate&) const
    {10, 3319, 260, 2, Smoke::mf_const|Smoke::mf_virtual, 614, 86},	//362 KCalendarSystem::yearStringToInteger(const QString&, int&) const
    {10, 2092, 260, 2, Smoke::mf_const|Smoke::mf_virtual, 614, 87},	//363 KCalendarSystem::monthStringToInteger(const QString&, int&) const
    {10, 1283, 260, 2, Smoke::mf_const|Smoke::mf_virtual, 614, 88},	//364 KCalendarSystem::dayStringToInteger(const QString&, int&) const
    {10, 1577, 263, 2, Smoke::mf_const|Smoke::mf_virtual, 351, 89},	//365 KCalendarSystem::formatDate(const QDate&, KLocale::DateFormat) const
    {10, 1577, 266, 3, Smoke::mf_const, 351, 90},	//366 KCalendarSystem::formatDate(const QDate&, const QString&, KLocale::DateTimeFormatStandard) const
    {10, 1577, 270, 4, Smoke::mf_const, 351, 91},	//367 KCalendarSystem::formatDate(const QDate&, const QString&, KLocale::DigitSet, KLocale::DateTimeFormatStandard) const
    {10, 1577, 275, 4, Smoke::mf_const, 351, 92},	//368 KCalendarSystem::formatDate(const QDate&, KLocale::DateTimeComponent, KLocale::DateTimeComponentFormat, KLocale::WeekNumberSystem) const
    {10, 2338, 280, 2, Smoke::mf_const|Smoke::mf_virtual, 276, 93},	//369 KCalendarSystem::readDate(const QString&, bool*) const
    {10, 2338, 283, 3, Smoke::mf_const|Smoke::mf_virtual, 276, 94},	//370 KCalendarSystem::readDate(const QString&, KLocale::ReadDateFlags, bool*) const
    {10, 2338, 287, 3, Smoke::mf_const|Smoke::mf_virtual, 276, 95},	//371 KCalendarSystem::readDate(const QString&, const QString&, bool*) const
    {10, 2338, 291, 4, Smoke::mf_const, 276, 96},	//372 KCalendarSystem::readDate(const QString&, const QString&, bool*, KLocale::DateTimeFormatStandard) const
    {10, 2935, 0, 0, Smoke::mf_const, 614, 97},	//373 KCalendarSystem::shortYearWindowStartYear() const
    {10, 1032, 118, 1, Smoke::mf_const, 614, 98},	//374 KCalendarSystem::applyShortYearWindow(int) const
    {10, 3272, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 614, 99},	//375 KCalendarSystem::weekStartDay() const
    {10, 3264, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 614, 100},	//376 KCalendarSystem::weekDayOfPray() const [pure virtual]
    {10, 1837, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 450, 101},	//377 KCalendarSystem::isLunar() const [pure virtual]
    {10, 1838, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 450, 102},	//378 KCalendarSystem::isLunisolar() const [pure virtual]
    {10, 1861, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 450, 103},	//379 KCalendarSystem::isSolar() const [pure virtual]
    {10, 1847, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 450, 104},	//380 KCalendarSystem::isProleptic() const [pure virtual]
    {10, 1888, 296, 4, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_purevirtual, 450, 105},	//381 KCalendarSystem::julianDayToDate(int, int&, int&, int&) const [pure virtual]
    {10, 1263, 301, 4, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_purevirtual, 450, 106},	//382 KCalendarSystem::dateToJulianDay(int, int, int, int&) const [pure virtual]
    {10, 1987, 0, 0, Smoke::mf_const|Smoke::mf_protected, 506, 107},	//383 KCalendarSystem::locale() const
    {10, 2758, 118, 1, Smoke::mf_protected, 0, 108},	//384 KCalendarSystem::setMaxMonthsInYear(int)
    {10, 2756, 118, 1, Smoke::mf_protected, 0, 109},	//385 KCalendarSystem::setMaxDaysInWeek(int)
    {10, 2654, 103, 1, Smoke::mf_protected, 0, 110},	//386 KCalendarSystem::setHasYear0(bool)
    {10, 301, 306, 3, Smoke::mf_ctor|Smoke::mf_protected, 28, 111},	//387 KCalendarSystem::KCalendarSystem(KCalendarSystemPrivate&, const KSharedPtr<KSharedConfig>, const KLocale*)
    {10, 1205, 0, 0, Smoke::mf_static, 28, 112},	//388 KCalendarSystem::create()
    {10, 1205, 30, 1, Smoke::mf_static, 28, 113},	//389 KCalendarSystem::create(const QString&)
    {10, 1205, 310, 2, Smoke::mf_static, 28, 114},	//390 KCalendarSystem::create(const QString&, KSharedPtr<KSharedConfig>)
    {10, 1205, 177, 1, Smoke::mf_static, 28, 115},	//391 KCalendarSystem::create(KLocale::CalendarSystem)
    {10, 1205, 313, 2, Smoke::mf_static, 28, 116},	//392 KCalendarSystem::create(KLocale::CalendarSystem, KSharedPtr<KSharedConfig>)
    {10, 1091, 177, 1, Smoke::mf_static, 351, 117},	//393 KCalendarSystem::calendarLabel(KLocale::CalendarSystem)
    {10, 301, 0, 0, Smoke::mf_ctor, 28, 118},	//394 KCalendarSystem::KCalendarSystem()
    {10, 301, 316, 1, Smoke::mf_ctor, 28, 119},	//395 KCalendarSystem::KCalendarSystem(const KSharedPtr<KSharedConfig>)
    {10, 1428, 196, 1, Smoke::mf_const, 351, 120},	//396 KCalendarSystem::eraName(const QDate&) const
    {10, 1431, 196, 1, Smoke::mf_const, 351, 121},	//397 KCalendarSystem::eraYear(const QDate&) const
    {10, 3265, 196, 1, Smoke::mf_const, 614, 122},	//398 KCalendarSystem::weekNumber(const QDate&) const
    {10, 3255, 196, 1, Smoke::mf_const, 614, 123},	//399 KCalendarSystem::week(const QDate&) const
    {10, 3255, 234, 2, Smoke::mf_const, 614, 124},	//400 KCalendarSystem::week(const QDate&, KLocale::WeekNumberSystem) const
    {10, 1564, 0, 0, Smoke::mf_const, 276, 125},	//401 KCalendarSystem::firstDayOfYear() const
    {10, 1956, 0, 0, Smoke::mf_const, 276, 126},	//402 KCalendarSystem::lastDayOfYear() const
    {10, 1561, 0, 0, Smoke::mf_const, 276, 127},	//403 KCalendarSystem::firstDayOfMonth() const
    {10, 1953, 0, 0, Smoke::mf_const, 276, 128},	//404 KCalendarSystem::lastDayOfMonth() const
    {10, 2084, 188, 2, Smoke::mf_const, 351, 129},	//405 KCalendarSystem::monthName(int, int) const
    {10, 2084, 196, 1, Smoke::mf_const, 351, 130},	//406 KCalendarSystem::monthName(const QDate&) const
    {10, 3259, 118, 1, Smoke::mf_const, 351, 131},	//407 KCalendarSystem::weekDayName(int) const
    {10, 3259, 196, 1, Smoke::mf_const, 351, 132},	//408 KCalendarSystem::weekDayName(const QDate&) const
    {10, 3316, 196, 1, Smoke::mf_const, 351, 133},	//409 KCalendarSystem::yearString(const QDate&) const
    {10, 2089, 196, 1, Smoke::mf_const, 351, 134},	//410 KCalendarSystem::monthString(const QDate&) const
    {10, 1280, 196, 1, Smoke::mf_const, 351, 135},	//411 KCalendarSystem::dayString(const QDate&) const
    {10, 3313, 196, 1, Smoke::mf_const, 351, 136},	//412 KCalendarSystem::yearInEraString(const QDate&) const
    {10, 1274, 196, 1, Smoke::mf_const, 351, 137},	//413 KCalendarSystem::dayOfYearString(const QDate&) const
    {10, 3268, 196, 1, Smoke::mf_const, 351, 138},	//414 KCalendarSystem::weekNumberString(const QDate&) const
    {10, 2099, 196, 1, Smoke::mf_const, 351, 139},	//415 KCalendarSystem::monthsInYearString(const QDate&) const
    {10, 3278, 196, 1, Smoke::mf_const, 351, 140},	//416 KCalendarSystem::weeksInYearString(const QDate&) const
    {10, 1300, 196, 1, Smoke::mf_const, 351, 141},	//417 KCalendarSystem::daysInYearString(const QDate&) const
    {10, 1290, 196, 1, Smoke::mf_const, 351, 142},	//418 KCalendarSystem::daysInMonthString(const QDate&) const
    {10, 1577, 196, 1, Smoke::mf_const, 351, 143},	//419 KCalendarSystem::formatDate(const QDate&) const
    {10, 1577, 318, 2, Smoke::mf_const, 351, 144},	//420 KCalendarSystem::formatDate(const QDate&, const QString&) const
    {10, 1577, 321, 3, Smoke::mf_const, 351, 145},	//421 KCalendarSystem::formatDate(const QDate&, const QString&, KLocale::DigitSet) const
    {10, 1577, 325, 2, Smoke::mf_const, 351, 146},	//422 KCalendarSystem::formatDate(const QDate&, KLocale::DateTimeComponent) const
    {10, 1577, 328, 3, Smoke::mf_const, 351, 147},	//423 KCalendarSystem::formatDate(const QDate&, KLocale::DateTimeComponent, KLocale::DateTimeComponentFormat) const
    {10, 2338, 30, 1, Smoke::mf_const, 276, 148},	//424 KCalendarSystem::readDate(const QString&) const
    {10, 2338, 332, 2, Smoke::mf_const, 276, 149},	//425 KCalendarSystem::readDate(const QString&, KLocale::ReadDateFlags) const
    {10, 2338, 95, 2, Smoke::mf_const, 276, 150},	//426 KCalendarSystem::readDate(const QString&, const QString&) const
    {10, 301, 335, 1, Smoke::mf_ctor|Smoke::mf_protected, 28, 151},	//427 KCalendarSystem::KCalendarSystem(KCalendarSystemPrivate&)
    {10, 301, 337, 2, Smoke::mf_ctor|Smoke::mf_protected, 28, 152},	//428 KCalendarSystem::KCalendarSystem(KCalendarSystemPrivate&, const KSharedPtr<KSharedConfig>)
    {10, 710, 0, 0, Smoke::mf_static|Smoke::mf_enum, 30, 153},	//429 KCalendarSystem::ShortFormat (enum)
    {10, 596, 0, 0, Smoke::mf_static|Smoke::mf_enum, 30, 154},	//430 KCalendarSystem::LongFormat (enum)
    {10, 711, 0, 0, Smoke::mf_static|Smoke::mf_enum, 29, 155},	//431 KCalendarSystem::ShortName (enum)
    {10, 597, 0, 0, Smoke::mf_static|Smoke::mf_enum, 29, 156},	//432 KCalendarSystem::LongName (enum)
    {10, 712, 0, 0, Smoke::mf_static|Smoke::mf_enum, 29, 157},	//433 KCalendarSystem::ShortNamePossessive (enum)
    {10, 598, 0, 0, Smoke::mf_static|Smoke::mf_enum, 29, 158},	//434 KCalendarSystem::LongNamePossessive (enum)
    {10, 615, 0, 0, Smoke::mf_static|Smoke::mf_enum, 29, 159},	//435 KCalendarSystem::NarrowName (enum)
    {10, 709, 0, 0, Smoke::mf_static|Smoke::mf_enum, 31, 160},	//436 KCalendarSystem::ShortDayName (enum)
    {10, 595, 0, 0, Smoke::mf_static|Smoke::mf_enum, 31, 161},	//437 KCalendarSystem::LongDayName (enum)
    {10, 614, 0, 0, Smoke::mf_static|Smoke::mf_enum, 31, 162},	//438 KCalendarSystem::NarrowDayName (enum)
    {10, 3359, 0, 0, Smoke::mf_dtor, 0, 163 },	//439 KCalendarSystem::~KCalendarSystem()
    {13, 307, 340, 1, Smoke::mf_ctor|Smoke::mf_explicit, 34, 1},	//440 KCharMacroExpander::KCharMacroExpander(QChar)
    {13, 1477, 342, 3, Smoke::mf_protected|Smoke::mf_virtual, 614, 2},	//441 KCharMacroExpander::expandPlainMacro(const QString&, int, QStringList&)
    {13, 1463, 342, 3, Smoke::mf_protected|Smoke::mf_virtual, 614, 3},	//442 KCharMacroExpander::expandEscapedMacro(const QString&, int, QStringList&)
    {13, 1465, 346, 2, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_purevirtual, 450, 4},	//443 KCharMacroExpander::expandMacro(QChar, QStringList&) [pure virtual]
    {13, 307, 349, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 34, 5},	//444 KCharMacroExpander::KCharMacroExpander(const KCharMacroExpander&)
    {13, 307, 0, 0, Smoke::mf_ctor|Smoke::mf_explicit, 34, 6},	//445 KCharMacroExpander::KCharMacroExpander()
    {13, 3360, 0, 0, Smoke::mf_dtor, 0, 7 },	//446 KCharMacroExpander::~KCharMacroExpander()
    {14, 309, 0, 0, Smoke::mf_ctor|Smoke::mf_protected, 35, 1},	//447 KCharsets::KCharsets()
    {14, 1154, 30, 1, Smoke::mf_const, 359, 2},	//448 KCharsets::codecForName(const QString&) const
    {14, 1154, 351, 2, Smoke::mf_const, 359, 3},	//449 KCharsets::codecForName(const QString&, bool&) const
    {14, 1608, 30, 1, Smoke::mf_static, 266, 4},	//450 KCharsets::fromEntity(const QString&)
    {14, 1608, 260, 2, Smoke::mf_static, 266, 5},	//451 KCharsets::fromEntity(const QString&, int&)
    {14, 3104, 354, 1, Smoke::mf_static, 351, 6},	//452 KCharsets::toEntity(const QChar&)
    {14, 2440, 30, 1, Smoke::mf_static, 351, 7},	//453 KCharsets::resolveEntities(const QString&)
    {14, 1063, 0, 0, Smoke::mf_const, 354, 8},	//454 KCharsets::availableEncodingNames() const
    {14, 1350, 0, 0, Smoke::mf_const, 354, 9},	//455 KCharsets::descriptiveEncodingNames() const
    {14, 1412, 0, 0, Smoke::mf_const, 335, 10},	//456 KCharsets::encodingsByScript() const
    {14, 1950, 30, 1, Smoke::mf_const, 351, 11},	//457 KCharsets::languageForEncoding(const QString&) const
    {14, 1348, 30, 1, Smoke::mf_const, 351, 12},	//458 KCharsets::descriptionForEncoding(const QString&) const
    {14, 1408, 30, 1, Smoke::mf_const, 351, 13},	//459 KCharsets::encodingForName(const QString&) const
    {14, 309, 356, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 35, 14},	//460 KCharsets::KCharsets(const KCharsets&)
    {14, 3361, 0, 0, Smoke::mf_dtor, 0, 15 },	//461 KCharsets::~KCharsets()
    {15, 1731, 358, 8, Smoke::mf_static, 0, 1},	//462 KCmdLineArgs::init(int, char**, const QByteArray&, const QByteArray&, const KLocalizedString&, const QByteArray&, const KLocalizedString&, QFlags<KCmdLineArgs::StdCmdLineArg>)
    {15, 1731, 367, 4, Smoke::mf_static, 0, 2},	//463 KCmdLineArgs::init(int, char**, const KAboutData*, QFlags<KCmdLineArgs::StdCmdLineArg>)
    {15, 1731, 372, 1, Smoke::mf_static, 0, 3},	//464 KCmdLineArgs::init(const KAboutData*)
    {15, 979, 374, 1, Smoke::mf_static, 0, 4},	//465 KCmdLineArgs::addStdCmdLineOptions(QFlags<KCmdLineArgs::StdCmdLineArg>)
    {15, 854, 376, 4, Smoke::mf_static, 0, 5},	//466 KCmdLineArgs::addCmdLineOptions(const KCmdLineOptions&, const KLocalizedString&, const QByteArray&, const QByteArray&)
    {15, 2221, 32, 1, Smoke::mf_static, 36, 6},	//467 KCmdLineArgs::parsedArgs(const QByteArray&)
    {15, 1244, 0, 0, Smoke::mf_static, 351, 7},	//468 KCmdLineArgs::cwd()
    {15, 1029, 0, 0, Smoke::mf_static, 351, 8},	//469 KCmdLineArgs::appName()
    {15, 3201, 32, 1, Smoke::mf_static, 0, 9},	//470 KCmdLineArgs::usage(const QByteArray&)
    {15, 3203, 30, 1, Smoke::mf_static, 0, 10},	//471 KCmdLineArgs::usageError(const QString&)
    {15, 1397, 0, 0, Smoke::mf_static, 0, 11},	//472 KCmdLineArgs::enable_i18n()
    {15, 1645, 32, 1, Smoke::mf_const, 351, 12},	//473 KCmdLineArgs::getOption(const QByteArray&) const
    {15, 1647, 32, 1, Smoke::mf_const, 354, 13},	//474 KCmdLineArgs::getOptionList(const QByteArray&) const
    {15, 1858, 32, 1, Smoke::mf_const, 450, 14},	//475 KCmdLineArgs::isSet(const QByteArray&) const
    {15, 1198, 0, 0, Smoke::mf_const, 614, 15},	//476 KCmdLineArgs::count() const
    {15, 1035, 118, 1, Smoke::mf_const, 351, 16},	//477 KCmdLineArgs::arg(int) const
    {15, 3199, 118, 1, Smoke::mf_const, 239, 17},	//478 KCmdLineArgs::url(int) const
    {15, 2043, 32, 1, Smoke::mf_static, 239, 18},	//479 KCmdLineArgs::makeURL(const QByteArray&)
    {15, 2563, 32, 1, Smoke::mf_static, 0, 19},	//480 KCmdLineArgs::setCwd(const QByteArray&)
    {15, 1144, 0, 0, 0, 0, 20},	//481 KCmdLineArgs::clear()
    {15, 2438, 0, 0, Smoke::mf_static, 0, 21},	//482 KCmdLineArgs::reset()
    {15, 1982, 381, 1, Smoke::mf_static, 0, 22},	//483 KCmdLineArgs::loadAppArgs(QDataStream&)
    {15, 2462, 381, 1, Smoke::mf_static, 0, 23},	//484 KCmdLineArgs::saveAppArgs(QDataStream&)
    {15, 983, 0, 0, Smoke::mf_static, 0, 24},	//485 KCmdLineArgs::addTempFileOption()
    {15, 1864, 0, 0, Smoke::mf_static, 450, 25},	//486 KCmdLineArgs::isTempFileSet()
    {15, 2297, 0, 0, Smoke::mf_static, 615, 26},	//487 KCmdLineArgs::qtArgc()
    {15, 2298, 0, 0, Smoke::mf_static, 455, 27},	//488 KCmdLineArgs::qtArgv()
    {15, 1003, 0, 0, Smoke::mf_static, 354, 28},	//489 KCmdLineArgs::allArguments()
    {15, 827, 0, 0, Smoke::mf_static, 457, 29},	//490 KCmdLineArgs::aboutData()
    {15, 311, 383, 3, Smoke::mf_ctor|Smoke::mf_protected, 36, 30},	//491 KCmdLineArgs::KCmdLineArgs(const KCmdLineOptions&, const KLocalizedString&, const QByteArray&)
    {15, 311, 387, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 36, 31},	//492 KCmdLineArgs::KCmdLineArgs(const KCmdLineArgs&)
    {15, 1731, 389, 6, Smoke::mf_static, 0, 32},	//493 KCmdLineArgs::init(int, char**, const QByteArray&, const QByteArray&, const KLocalizedString&, const QByteArray&)
    {15, 1731, 396, 7, Smoke::mf_static, 0, 33},	//494 KCmdLineArgs::init(int, char**, const QByteArray&, const QByteArray&, const KLocalizedString&, const QByteArray&, const KLocalizedString&)
    {15, 1731, 404, 3, Smoke::mf_static, 0, 34},	//495 KCmdLineArgs::init(int, char**, const KAboutData*)
    {15, 979, 0, 0, Smoke::mf_static, 0, 35},	//496 KCmdLineArgs::addStdCmdLineOptions()
    {15, 854, 408, 1, Smoke::mf_static, 0, 36},	//497 KCmdLineArgs::addCmdLineOptions(const KCmdLineOptions&)
    {15, 854, 410, 2, Smoke::mf_static, 0, 37},	//498 KCmdLineArgs::addCmdLineOptions(const KCmdLineOptions&, const KLocalizedString&)
    {15, 854, 383, 3, Smoke::mf_static, 0, 38},	//499 KCmdLineArgs::addCmdLineOptions(const KCmdLineOptions&, const KLocalizedString&, const QByteArray&)
    {15, 2221, 0, 0, Smoke::mf_static, 36, 39},	//500 KCmdLineArgs::parsedArgs()
    {15, 3201, 0, 0, Smoke::mf_static, 0, 40},	//501 KCmdLineArgs::usage()
    {15, 64, 0, 0, Smoke::mf_static|Smoke::mf_enum, 37, 41},	//502 KCmdLineArgs::CmdLineArgQt (enum)
    {15, 62, 0, 0, Smoke::mf_static|Smoke::mf_enum, 37, 42},	//503 KCmdLineArgs::CmdLineArgKDE (enum)
    {15, 65, 0, 0, Smoke::mf_static|Smoke::mf_enum, 37, 43},	//504 KCmdLineArgs::CmdLineArgsMask (enum)
    {15, 63, 0, 0, Smoke::mf_static|Smoke::mf_enum, 37, 44},	//505 KCmdLineArgs::CmdLineArgNone (enum)
    {15, 698, 0, 0, Smoke::mf_static|Smoke::mf_enum, 37, 45},	//506 KCmdLineArgs::Reserved (enum)
    {15, 3362, 0, 0, Smoke::mf_dtor, 0, 46 },	//507 KCmdLineArgs::~KCmdLineArgs()
    {16, 314, 0, 0, Smoke::mf_ctor, 39, 1},	//508 KCmdLineOptions::KCmdLineOptions()
    {16, 314, 408, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 39, 2},	//509 KCmdLineOptions::KCmdLineOptions(const KCmdLineOptions&)
    {16, 2182, 408, 1, 0, 38, 3},	//510 KCmdLineOptions::operator=(const KCmdLineOptions&)
    {16, 842, 413, 3, 0, 38, 4},	//511 KCmdLineOptions::add(const QByteArray&, const KLocalizedString&, const QByteArray&)
    {16, 842, 408, 1, 0, 38, 5},	//512 KCmdLineOptions::add(const KCmdLineOptions&)
    {16, 842, 32, 1, 0, 38, 6},	//513 KCmdLineOptions::add(const QByteArray&)
    {16, 842, 417, 2, 0, 38, 7},	//514 KCmdLineOptions::add(const QByteArray&, const KLocalizedString&)
    {16, 3363, 0, 0, Smoke::mf_dtor, 0, 8 },	//515 KCmdLineOptions::~KCmdLineOptions()
    {17, 3226, 420, 2, Smoke::mf_static, 0, 1},	//516 KCodecs::uuencode(const QByteArray&, QByteArray&)
    {17, 1069, 420, 2, Smoke::mf_static, 0, 2},	//517 KCodecs::base64Decode(const QByteArray&, QByteArray&)
    {17, 2313, 420, 2, Smoke::mf_static, 0, 3},	//518 KCodecs::quotedPrintableDecode(const QByteArray&, QByteArray&)
    {17, 2313, 32, 1, Smoke::mf_static, 264, 4},	//519 KCodecs::quotedPrintableDecode(const QByteArray&)
    {17, 2316, 423, 2, Smoke::mf_static, 264, 5},	//520 KCodecs::quotedPrintableEncode(const QByteArray&, bool)
    {17, 2316, 32, 1, Smoke::mf_static, 264, 6},	//521 KCodecs::quotedPrintableEncode(const QByteArray&)
    {17, 3223, 420, 2, Smoke::mf_static, 0, 7},	//522 KCodecs::uudecode(const QByteArray&, QByteArray&)
    {17, 2316, 426, 3, Smoke::mf_static, 0, 8},	//523 KCodecs::quotedPrintableEncode(const QByteArray&, QByteArray&, bool)
    {17, 1073, 426, 3, Smoke::mf_static, 0, 9},	//524 KCodecs::base64Encode(const QByteArray&, QByteArray&, bool)
    {17, 1073, 420, 2, Smoke::mf_static, 0, 10},	//525 KCodecs::base64Encode(const QByteArray&, QByteArray&)
    {17, 1069, 32, 1, Smoke::mf_static, 264, 11},	//526 KCodecs::base64Decode(const QByteArray&)
    {17, 3226, 32, 1, Smoke::mf_static, 264, 12},	//527 KCodecs::uuencode(const QByteArray&)
    {17, 1073, 423, 2, Smoke::mf_static, 264, 13},	//528 KCodecs::base64Encode(const QByteArray&, bool)
    {17, 1073, 32, 1, Smoke::mf_static, 264, 14},	//529 KCodecs::base64Encode(const QByteArray&)
    {17, 3223, 32, 1, Smoke::mf_static, 264, 15},	//530 KCodecs::uudecode(const QByteArray&)
    {17, 1311, 30, 1, Smoke::mf_static, 351, 16},	//531 KCodecs::decodeRFC2047String(const QString&)
    {18, 316, 0, 0, Smoke::mf_ctor, 42, 1},	//532 KComponentData::KComponentData()
    {18, 316, 430, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 42, 2},	//533 KComponentData::KComponentData(const KComponentData&)
    {18, 2182, 430, 1, 0, 41, 3},	//534 KComponentData::operator=(const KComponentData&)
    {18, 2185, 430, 1, Smoke::mf_const, 450, 4},	//535 KComponentData::operator==(const KComponentData&) const
    {18, 2158, 430, 1, Smoke::mf_const, 450, 5},	//536 KComponentData::operator!=(const KComponentData&) const
    {18, 316, 432, 3, Smoke::mf_ctor, 42, 6},	//537 KComponentData::KComponentData(const QByteArray&, const QByteArray&, KComponentData::MainComponentRegistration)
    {18, 316, 436, 2, Smoke::mf_ctor, 42, 7},	//538 KComponentData::KComponentData(const KAboutData&, KComponentData::MainComponentRegistration)
    {18, 316, 439, 2, Smoke::mf_ctor, 42, 8},	//539 KComponentData::KComponentData(const KAboutData*, KComponentData::MainComponentRegistration)
    {18, 1871, 0, 0, Smoke::mf_const, 450, 9},	//540 KComponentData::isValid() const
    {18, 1377, 0, 0, Smoke::mf_const, 200, 10},	//541 KComponentData::dirs() const
    {18, 1168, 0, 0, Smoke::mf_const, 520, 11},	//542 KComponentData::config() const
    {18, 827, 0, 0, Smoke::mf_const, 457, 12},	//543 KComponentData::aboutData() const
    {18, 2496, 12, 1, 0, 0, 13},	//544 KComponentData::setAboutData(const KAboutData&)
    {18, 1164, 0, 0, Smoke::mf_const, 351, 14},	//545 KComponentData::componentName() const
    {18, 1112, 0, 0, Smoke::mf_const, 351, 15},	//546 KComponentData::catalogName() const
    {18, 2547, 30, 1, Smoke::mf_protected, 0, 16},	//547 KComponentData::setConfigName(const QString&)
    {18, 316, 32, 1, Smoke::mf_ctor, 42, 17},	//548 KComponentData::KComponentData(const QByteArray&)
    {18, 316, 442, 2, Smoke::mf_ctor, 42, 18},	//549 KComponentData::KComponentData(const QByteArray&, const QByteArray&)
    {18, 316, 12, 1, Smoke::mf_ctor, 42, 19},	//550 KComponentData::KComponentData(const KAboutData&)
    {18, 316, 372, 1, Smoke::mf_ctor, 42, 20},	//551 KComponentData::KComponentData(const KAboutData*)
    {18, 693, 0, 0, Smoke::mf_static|Smoke::mf_enum, 43, 21},	//552 KComponentData::RegisterAsMainComponent (enum)
    {18, 717, 0, 0, Smoke::mf_static|Smoke::mf_enum, 43, 22},	//553 KComponentData::SkipMainComponentRegistration (enum)
    {18, 3364, 0, 0, Smoke::mf_dtor, 0, 23 },	//554 KComponentData::~KComponentData()
    {19, 2060, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 582, 1},	//555 KCompositeJob::metaObject() const
    {19, 2301, 122, 1, Smoke::mf_virtual, 639, 2},	//556 KCompositeJob::qt_metacast(const char*)
    {19, 3131, 124, 2, Smoke::mf_static, 351, 3},	//557 KCompositeJob::tr(const char*, const char*)
    {19, 3138, 124, 2, Smoke::mf_static, 351, 4},	//558 KCompositeJob::trUtf8(const char*, const char*)
    {19, 3131, 127, 3, Smoke::mf_static, 351, 5},	//559 KCompositeJob::tr(const char*, const char*, int)
    {19, 3138, 127, 3, Smoke::mf_static, 351, 6},	//560 KCompositeJob::trUtf8(const char*, const char*, int)
    {19, 2299, 131, 3, Smoke::mf_virtual, 614, 7},	//561 KCompositeJob::qt_metacall(QMetaObject::Call, int, void**)
    {19, 321, 146, 1, Smoke::mf_ctor, 44, 8},	//562 KCompositeJob::KCompositeJob(QObject*)
    {19, 981, 445, 1, Smoke::mf_protected|Smoke::mf_virtual, 450, 9},	//563 KCompositeJob::addSubjob(KJob*)
    {19, 2424, 445, 1, Smoke::mf_protected|Smoke::mf_virtual, 450, 10},	//564 KCompositeJob::removeSubjob(KJob*)
    {19, 1697, 0, 0, Smoke::mf_protected, 450, 11},	//565 KCompositeJob::hasSubjobs()
    {19, 3044, 0, 0, Smoke::mf_const|Smoke::mf_protected, 570, 12},	//566 KCompositeJob::subjobs() const
    {19, 1147, 0, 0, Smoke::mf_protected, 0, 13},	//567 KCompositeJob::clearSubjobs()
    {19, 2950, 445, 1, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_slot, 0, 14},	//568 KCompositeJob::slotResult(KJob*)
    {19, 2948, 447, 3, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_slot, 0, 15},	//569 KCompositeJob::slotInfoMessage(KJob*, const QString&, const QString&)
    {19, 321, 451, 2, Smoke::mf_ctor|Smoke::mf_protected, 44, 16},	//570 KCompositeJob::KCompositeJob(KCompositeJobPrivate&, QObject*)
    {19, 3131, 122, 1, Smoke::mf_static, 351, 17},	//571 KCompositeJob::tr(const char*)
    {19, 3138, 122, 1, Smoke::mf_static, 351, 18},	//572 KCompositeJob::trUtf8(const char*)
    {19, 321, 0, 0, Smoke::mf_ctor, 44, 19},	//573 KCompositeJob::KCompositeJob()
    {19, 3030, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 581, 20},	//574 KCompositeJob::staticMetaObject() const
    {19, 3365, 0, 0, Smoke::mf_dtor, 0, 21 },	//575 KCompositeJob::~KCompositeJob()
    {21, 324, 454, 3, Smoke::mf_ctor, 46, 1},	//576 KConfig::KConfig(const QString&, QFlags<KConfig::OpenFlag>, const char*)
    {21, 324, 458, 4, Smoke::mf_ctor, 46, 2},	//577 KConfig::KConfig(const KComponentData&, const QString&, QFlags<KConfig::OpenFlag>, const char*)
    {21, 324, 463, 3, Smoke::mf_ctor, 46, 3},	//578 KConfig::KConfig(const QString&, const QString&, const char*)
    {21, 1163, 0, 0, Smoke::mf_const, 467, 4},	//579 KConfig::componentData() const
    {21, 2102, 0, 0, Smoke::mf_const, 351, 5},	//580 KConfig::name() const
    {21, 3069, 0, 0, Smoke::mf_virtual, 0, 6},	//581 KConfig::sync()
    {21, 1800, 0, 0, Smoke::mf_const, 450, 7},	//582 KConfig::isDirty() const
    {21, 2046, 0, 0, Smoke::mf_virtual, 0, 8},	//583 KConfig::markAsClean()
    {21, 833, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 49, 9},	//584 KConfig::accessMode() const
    {21, 1790, 103, 1, 0, 450, 10},	//585 KConfig::isConfigWritable(bool)
    {21, 1192, 467, 2, Smoke::mf_const, 46, 11},	//586 KConfig::copyTo(const QString&, KConfig*) const
    {21, 1130, 95, 2, 0, 0, 12},	//587 KConfig::checkUpdate(const QString&, const QString&)
    {21, 2431, 0, 0, 0, 0, 13},	//588 KConfig::reparseConfiguration()
    {21, 859, 141, 1, 0, 0, 14},	//589 KConfig::addConfigSources(const QStringList&)
    {21, 1987, 0, 0, Smoke::mf_const, 351, 15},	//590 KConfig::locale() const
    {21, 2692, 30, 1, 0, 450, 16},	//591 KConfig::setLocale(const QString&)
    {21, 2849, 103, 1, 0, 0, 17},	//592 KConfig::setReadDefaults(bool)
    {21, 2345, 0, 0, Smoke::mf_const, 450, 18},	//593 KConfig::readDefaults() const
    {21, 1824, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 450, 19},	//594 KConfig::isImmutable() const
    {21, 2644, 103, 1, 0, 0, 20},	//595 KConfig::setForceGlobal(bool)
    {21, 1571, 0, 0, Smoke::mf_const, 450, 21},	//596 KConfig::forceGlobal() const
    {21, 1657, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 354, 22},	//597 KConfig::groupList() const
    {21, 1419, 30, 1, Smoke::mf_const, 339, 23},	//598 KConfig::entryMap(const QString&) const
    {21, 1671, 32, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 450, 24},	//599 KConfig::hasGroupImpl(const QByteArray&) const
    {21, 1655, 32, 1, Smoke::mf_protected|Smoke::mf_virtual, 51, 25},	//600 KConfig::groupImpl(const QByteArray&)
    {21, 1655, 32, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 471, 26},	//601 KConfig::groupImpl(const QByteArray&) const
    {21, 1339, 470, 2, Smoke::mf_protected|Smoke::mf_virtual, 0, 27},	//602 KConfig::deleteGroupImpl(const QByteArray&, QFlags<KConfigBase::WriteConfigFlag>)
    {21, 1818, 32, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 450, 28},	//603 KConfig::isGroupImmutableImpl(const QByteArray&) const
    {21, 324, 473, 1, Smoke::mf_ctor|Smoke::mf_protected, 46, 29},	//604 KConfig::KConfig(KConfigPrivate&)
    {21, 324, 0, 0, Smoke::mf_ctor, 46, 30},	//605 KConfig::KConfig()
    {21, 324, 30, 1, Smoke::mf_ctor, 46, 31},	//606 KConfig::KConfig(const QString&)
    {21, 324, 475, 2, Smoke::mf_ctor, 46, 32},	//607 KConfig::KConfig(const QString&, QFlags<KConfig::OpenFlag>)
    {21, 324, 430, 1, Smoke::mf_ctor, 46, 33},	//608 KConfig::KConfig(const KComponentData&)
    {21, 324, 478, 2, Smoke::mf_ctor, 46, 34},	//609 KConfig::KConfig(const KComponentData&, const QString&)
    {21, 324, 481, 3, Smoke::mf_ctor, 46, 35},	//610 KConfig::KConfig(const KComponentData&, const QString&, QFlags<KConfig::OpenFlag>)
    {21, 324, 95, 2, Smoke::mf_ctor, 46, 36},	//611 KConfig::KConfig(const QString&, const QString&)
    {21, 1192, 30, 1, Smoke::mf_const, 46, 37},	//612 KConfig::copyTo(const QString&) const
    {21, 1419, 0, 0, Smoke::mf_const, 339, 38},	//613 KConfig::entryMap() const
    {21, 1339, 32, 1, Smoke::mf_protected, 0, 39},	//614 KConfig::deleteGroupImpl(const QByteArray&)
    {21, 173, 0, 0, Smoke::mf_static|Smoke::mf_enum, 47, 40},	//615 KConfig::IncludeGlobals (enum)
    {21, 47, 0, 0, Smoke::mf_static|Smoke::mf_enum, 47, 41},	//616 KConfig::CascadeConfig (enum)
    {21, 714, 0, 0, Smoke::mf_static|Smoke::mf_enum, 47, 42},	//617 KConfig::SimpleConfig (enum)
    {21, 620, 0, 0, Smoke::mf_static|Smoke::mf_enum, 47, 43},	//618 KConfig::NoCascade (enum)
    {21, 624, 0, 0, Smoke::mf_static|Smoke::mf_enum, 47, 44},	//619 KConfig::NoGlobals (enum)
    {21, 148, 0, 0, Smoke::mf_static|Smoke::mf_enum, 47, 45},	//620 KConfig::FullConfig (enum)
    {21, 3366, 0, 0, Smoke::mf_dtor, 0, 46 },	//621 KConfig::~KConfig()
    {22, 1657, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 354, 1},	//622 KConfigBase::groupList() const [pure virtual]
    {22, 1668, 30, 1, Smoke::mf_const, 450, 2},	//623 KConfigBase::hasGroup(const QString&) const
    {22, 1668, 122, 1, Smoke::mf_const, 450, 3},	//624 KConfigBase::hasGroup(const char*) const
    {22, 1668, 32, 1, Smoke::mf_const, 450, 4},	//625 KConfigBase::hasGroup(const QByteArray&) const
    {22, 1650, 32, 1, 0, 51, 5},	//626 KConfigBase::group(const QByteArray&)
    {22, 1650, 30, 1, 0, 51, 6},	//627 KConfigBase::group(const QString&)
    {22, 1650, 122, 1, 0, 51, 7},	//628 KConfigBase::group(const char*)
    {22, 1650, 32, 1, Smoke::mf_const, 471, 8},	//629 KConfigBase::group(const QByteArray&) const
    {22, 1650, 30, 1, Smoke::mf_const, 471, 9},	//630 KConfigBase::group(const QString&) const
    {22, 1650, 122, 1, Smoke::mf_const, 471, 10},	//631 KConfigBase::group(const char*) const
    {22, 1334, 470, 2, 0, 0, 11},	//632 KConfigBase::deleteGroup(const QByteArray&, QFlags<KConfigBase::WriteConfigFlag>)
    {22, 1334, 485, 2, 0, 0, 12},	//633 KConfigBase::deleteGroup(const QString&, QFlags<KConfigBase::WriteConfigFlag>)
    {22, 1334, 488, 2, 0, 0, 13},	//634 KConfigBase::deleteGroup(const char*, QFlags<KConfigBase::WriteConfigFlag>)
    {22, 3069, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 14},	//635 KConfigBase::sync() [pure virtual]
    {22, 2046, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 15},	//636 KConfigBase::markAsClean() [pure virtual]
    {22, 833, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 49, 16},	//637 KConfigBase::accessMode() const [pure virtual]
    {22, 1824, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 450, 17},	//638 KConfigBase::isImmutable() const [pure virtual]
    {22, 1815, 32, 1, Smoke::mf_const, 450, 18},	//639 KConfigBase::isGroupImmutable(const QByteArray&) const
    {22, 1815, 30, 1, Smoke::mf_const, 450, 19},	//640 KConfigBase::isGroupImmutable(const QString&) const
    {22, 1815, 122, 1, Smoke::mf_const, 450, 20},	//641 KConfigBase::isGroupImmutable(const char*) const
    {22, 332, 0, 0, Smoke::mf_ctor|Smoke::mf_protected, 48, 21},	//642 KConfigBase::KConfigBase()
    {22, 1671, 32, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_purevirtual, 450, 22},	//643 KConfigBase::hasGroupImpl(const QByteArray&) const [pure virtual]
    {22, 1655, 32, 1, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_purevirtual, 51, 23},	//644 KConfigBase::groupImpl(const QByteArray&) [pure virtual]
    {22, 1655, 32, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_purevirtual, 471, 24},	//645 KConfigBase::groupImpl(const QByteArray&) const [pure virtual]
    {22, 1339, 470, 2, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 25},	//646 KConfigBase::deleteGroupImpl(const QByteArray&, QFlags<KConfigBase::WriteConfigFlag>) [pure virtual]
    {22, 1818, 32, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_purevirtual, 450, 26},	//647 KConfigBase::isGroupImmutableImpl(const QByteArray&) const [pure virtual]
    {22, 332, 491, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 48, 27},	//648 KConfigBase::KConfigBase(const KConfigBase&)
    {22, 1334, 32, 1, 0, 0, 28},	//649 KConfigBase::deleteGroup(const QByteArray&)
    {22, 1334, 30, 1, 0, 0, 29},	//650 KConfigBase::deleteGroup(const QString&)
    {22, 1334, 122, 1, 0, 0, 30},	//651 KConfigBase::deleteGroup(const char*)
    {22, 1339, 32, 1, Smoke::mf_protected, 0, 31},	//652 KConfigBase::deleteGroupImpl(const QByteArray&)
    {22, 660, 0, 0, Smoke::mf_static|Smoke::mf_enum, 50, 32},	//653 KConfigBase::Persistent (enum)
    {22, 150, 0, 0, Smoke::mf_static|Smoke::mf_enum, 50, 33},	//654 KConfigBase::Global (enum)
    {22, 589, 0, 0, Smoke::mf_static|Smoke::mf_enum, 50, 34},	//655 KConfigBase::Localized (enum)
    {22, 634, 0, 0, Smoke::mf_static|Smoke::mf_enum, 50, 35},	//656 KConfigBase::Normal (enum)
    {22, 617, 0, 0, Smoke::mf_static|Smoke::mf_enum, 49, 36},	//657 KConfigBase::NoAccess (enum)
    {22, 687, 0, 0, Smoke::mf_static|Smoke::mf_enum, 49, 37},	//658 KConfigBase::ReadOnly (enum)
    {22, 691, 0, 0, Smoke::mf_static|Smoke::mf_enum, 49, 38},	//659 KConfigBase::ReadWrite (enum)
    {22, 3367, 0, 0, Smoke::mf_dtor, 0, 39 },	//660 KConfigBase::~KConfigBase()
    {23, 334, 0, 0, Smoke::mf_ctor, 53, 1},	//661 KConfigGroup::KConfigGroup()
    {23, 334, 493, 2, Smoke::mf_ctor, 53, 2},	//662 KConfigGroup::KConfigGroup(KConfigBase*, const QString&)
    {23, 334, 496, 2, Smoke::mf_ctor, 53, 3},	//663 KConfigGroup::KConfigGroup(KConfigBase*, const char*)
    {23, 334, 499, 2, Smoke::mf_ctor, 53, 4},	//664 KConfigGroup::KConfigGroup(const KConfigBase*, const QString&)
    {23, 334, 502, 2, Smoke::mf_ctor, 53, 5},	//665 KConfigGroup::KConfigGroup(const KConfigBase*, const char*)
    {23, 334, 505, 2, Smoke::mf_ctor, 53, 6},	//666 KConfigGroup::KConfigGroup(const KSharedPtr<KSharedConfig>&, const QString&)
    {23, 334, 508, 2, Smoke::mf_ctor, 53, 7},	//667 KConfigGroup::KConfigGroup(const KSharedPtr<KSharedConfig>&, const char*)
    {23, 334, 511, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 53, 8},	//668 KConfigGroup::KConfigGroup(const KConfigGroup&)
    {23, 2182, 511, 1, 0, 52, 9},	//669 KConfigGroup::operator=(const KConfigGroup&)
    {23, 1871, 0, 0, Smoke::mf_const, 450, 10},	//670 KConfigGroup::isValid() const
    {23, 2102, 0, 0, Smoke::mf_const, 351, 11},	//671 KConfigGroup::name() const
    {23, 1461, 0, 0, Smoke::mf_const, 450, 12},	//672 KConfigGroup::exists() const
    {23, 3069, 0, 0, Smoke::mf_virtual, 0, 13},	//673 KConfigGroup::sync()
    {23, 2046, 0, 0, Smoke::mf_virtual, 0, 14},	//674 KConfigGroup::markAsClean()
    {23, 833, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 49, 15},	//675 KConfigGroup::accessMode() const
    {23, 1168, 0, 0, 0, 46, 16},	//676 KConfigGroup::config()
    {23, 1168, 0, 0, Smoke::mf_const, 468, 17},	//677 KConfigGroup::config() const
    {23, 1117, 30, 1, 0, 0, 18},	//678 KConfigGroup::changeGroup(const QString&)
    {23, 1117, 122, 1, 0, 0, 19},	//679 KConfigGroup::changeGroup(const char*)
    {23, 1192, 513, 2, Smoke::mf_const, 0, 20},	//680 KConfigGroup::copyTo(KConfigBase*, QFlags<KConfigBase::WriteConfigFlag>) const
    {23, 2428, 513, 2, 0, 0, 21},	//681 KConfigGroup::reparent(KConfigBase*, QFlags<KConfigBase::WriteConfigFlag>)
    {23, 2212, 0, 0, Smoke::mf_const, 51, 22},	//682 KConfigGroup::parent() const
    {23, 1657, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 354, 23},	//683 KConfigGroup::groupList() const
    {23, 1925, 0, 0, Smoke::mf_const, 354, 24},	//684 KConfigGroup::keyList() const
    {23, 1334, 516, 1, 0, 0, 25},	//685 KConfigGroup::deleteGroup(QFlags<KConfigBase::WriteConfigFlag>)
    {23, 1334, 470, 2, 0, 0, 26},	//686 KConfigGroup::deleteGroup(const QByteArray&, QFlags<KConfigBase::WriteConfigFlag>)
    {23, 1334, 485, 2, 0, 0, 27},	//687 KConfigGroup::deleteGroup(const QString&, QFlags<KConfigBase::WriteConfigFlag>)
    {23, 1334, 488, 2, 0, 0, 28},	//688 KConfigGroup::deleteGroup(const char*, QFlags<KConfigBase::WriteConfigFlag>)
    {23, 2348, 100, 2, Smoke::mf_const, 364, 29},	//689 KConfigGroup::readEntry(const QString&, const QVariant&) const
    {23, 2348, 518, 2, Smoke::mf_const, 364, 30},	//690 KConfigGroup::readEntry(const char*, const QVariant&) const
    {23, 2348, 95, 2, Smoke::mf_const, 351, 31},	//691 KConfigGroup::readEntry(const QString&, const QString&) const
    {23, 2348, 521, 2, Smoke::mf_const, 351, 32},	//692 KConfigGroup::readEntry(const char*, const QString&) const
    {23, 2348, 524, 2, Smoke::mf_const, 351, 33},	//693 KConfigGroup::readEntry(const QString&, const char*) const
    {23, 2348, 124, 2, Smoke::mf_const, 351, 34},	//694 KConfigGroup::readEntry(const char*, const char*) const
    {23, 2348, 527, 2, Smoke::mf_const, 336, 35},	//695 KConfigGroup::readEntry(const QString&, const QList<QVariant>&) const
    {23, 2348, 530, 2, Smoke::mf_const, 336, 36},	//696 KConfigGroup::readEntry(const char*, const QList<QVariant>&) const
    {23, 2348, 533, 2, Smoke::mf_const, 354, 37},	//697 KConfigGroup::readEntry(const QString&, const QStringList&) const
    {23, 2348, 536, 2, Smoke::mf_const, 354, 38},	//698 KConfigGroup::readEntry(const char*, const QStringList&) const
    {23, 2385, 533, 2, Smoke::mf_const, 354, 39},	//699 KConfigGroup::readXdgListEntry(const QString&, const QStringList&) const
    {23, 2385, 536, 2, Smoke::mf_const, 354, 40},	//700 KConfigGroup::readXdgListEntry(const char*, const QStringList&) const
    {23, 2376, 95, 2, Smoke::mf_const, 351, 41},	//701 KConfigGroup::readPathEntry(const QString&, const QString&) const
    {23, 2376, 521, 2, Smoke::mf_const, 351, 42},	//702 KConfigGroup::readPathEntry(const char*, const QString&) const
    {23, 2376, 533, 2, Smoke::mf_const, 354, 43},	//703 KConfigGroup::readPathEntry(const QString&, const QStringList&) const
    {23, 2376, 536, 2, Smoke::mf_const, 354, 44},	//704 KConfigGroup::readPathEntry(const char*, const QStringList&) const
    {23, 2353, 95, 2, Smoke::mf_const, 351, 45},	//705 KConfigGroup::readEntryUntranslated(const QString&, const QString&) const
    {23, 2353, 521, 2, Smoke::mf_const, 351, 46},	//706 KConfigGroup::readEntryUntranslated(const char*, const QString&) const
    {23, 3292, 539, 3, 0, 0, 47},	//707 KConfigGroup::writeEntry(const QString&, const QVariant&, QFlags<KConfigBase::WriteConfigFlag>)
    {23, 3292, 543, 3, 0, 0, 48},	//708 KConfigGroup::writeEntry(const char*, const QVariant&, QFlags<KConfigBase::WriteConfigFlag>)
    {23, 3292, 547, 3, 0, 0, 49},	//709 KConfigGroup::writeEntry(const QString&, const QString&, QFlags<KConfigBase::WriteConfigFlag>)
    {23, 3292, 551, 3, 0, 0, 50},	//710 KConfigGroup::writeEntry(const char*, const QString&, QFlags<KConfigBase::WriteConfigFlag>)
    {23, 3292, 555, 3, 0, 0, 51},	//711 KConfigGroup::writeEntry(const QString&, const QByteArray&, QFlags<KConfigBase::WriteConfigFlag>)
    {23, 3292, 559, 3, 0, 0, 52},	//712 KConfigGroup::writeEntry(const char*, const QByteArray&, QFlags<KConfigBase::WriteConfigFlag>)
    {23, 3292, 563, 3, 0, 0, 53},	//713 KConfigGroup::writeEntry(const QString&, const char*, QFlags<KConfigBase::WriteConfigFlag>)
    {23, 3292, 567, 3, 0, 0, 54},	//714 KConfigGroup::writeEntry(const char*, const char*, QFlags<KConfigBase::WriteConfigFlag>)
    {23, 3292, 571, 3, 0, 0, 55},	//715 KConfigGroup::writeEntry(const QString&, const QStringList&, QFlags<KConfigBase::WriteConfigFlag>)
    {23, 3292, 575, 3, 0, 0, 56},	//716 KConfigGroup::writeEntry(const char*, const QStringList&, QFlags<KConfigBase::WriteConfigFlag>)
    {23, 3292, 579, 3, 0, 0, 57},	//717 KConfigGroup::writeEntry(const QString&, const QList<QVariant>&, QFlags<KConfigBase::WriteConfigFlag>)
    {23, 3292, 583, 3, 0, 0, 58},	//718 KConfigGroup::writeEntry(const char*, const QList<QVariant>&, QFlags<KConfigBase::WriteConfigFlag>)
    {23, 3306, 571, 3, 0, 0, 59},	//719 KConfigGroup::writeXdgListEntry(const QString&, const QStringList&, QFlags<KConfigBase::WriteConfigFlag>)
    {23, 3306, 575, 3, 0, 0, 60},	//720 KConfigGroup::writeXdgListEntry(const char*, const QStringList&, QFlags<KConfigBase::WriteConfigFlag>)
    {23, 3301, 547, 3, 0, 0, 61},	//721 KConfigGroup::writePathEntry(const QString&, const QString&, QFlags<KConfigBase::WriteConfigFlag>)
    {23, 3301, 551, 3, 0, 0, 62},	//722 KConfigGroup::writePathEntry(const char*, const QString&, QFlags<KConfigBase::WriteConfigFlag>)
    {23, 3301, 571, 3, 0, 0, 63},	//723 KConfigGroup::writePathEntry(const QString&, const QStringList&, QFlags<KConfigBase::WriteConfigFlag>)
    {23, 3301, 575, 3, 0, 0, 64},	//724 KConfigGroup::writePathEntry(const char*, const QStringList&, QFlags<KConfigBase::WriteConfigFlag>)
    {23, 1331, 485, 2, 0, 0, 65},	//725 KConfigGroup::deleteEntry(const QString&, QFlags<KConfigBase::WriteConfigFlag>)
    {23, 1331, 488, 2, 0, 0, 66},	//726 KConfigGroup::deleteEntry(const char*, QFlags<KConfigBase::WriteConfigFlag>)
    {23, 1676, 30, 1, Smoke::mf_const, 450, 67},	//727 KConfigGroup::hasKey(const QString&) const
    {23, 1676, 122, 1, Smoke::mf_const, 450, 68},	//728 KConfigGroup::hasKey(const char*) const
    {23, 1824, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 450, 69},	//729 KConfigGroup::isImmutable() const
    {23, 1808, 30, 1, Smoke::mf_const, 450, 70},	//730 KConfigGroup::isEntryImmutable(const QString&) const
    {23, 1808, 122, 1, Smoke::mf_const, 450, 71},	//731 KConfigGroup::isEntryImmutable(const char*) const
    {23, 2454, 30, 1, 0, 0, 72},	//732 KConfigGroup::revertToDefault(const QString&)
    {23, 2454, 122, 1, 0, 0, 73},	//733 KConfigGroup::revertToDefault(const char*)
    {23, 1665, 30, 1, Smoke::mf_const, 450, 74},	//734 KConfigGroup::hasDefault(const QString&) const
    {23, 1665, 122, 1, Smoke::mf_const, 450, 75},	//735 KConfigGroup::hasDefault(const char*) const
    {23, 1419, 0, 0, Smoke::mf_const, 339, 76},	//736 KConfigGroup::entryMap() const
    {23, 1671, 32, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 450, 77},	//737 KConfigGroup::hasGroupImpl(const QByteArray&) const
    {23, 1655, 32, 1, Smoke::mf_protected|Smoke::mf_virtual, 51, 78},	//738 KConfigGroup::groupImpl(const QByteArray&)
    {23, 1655, 32, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 471, 79},	//739 KConfigGroup::groupImpl(const QByteArray&) const
    {23, 1339, 470, 2, Smoke::mf_protected|Smoke::mf_virtual, 0, 80},	//740 KConfigGroup::deleteGroupImpl(const QByteArray&, QFlags<KConfigBase::WriteConfigFlag>)
    {23, 1818, 32, 1, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_virtual, 450, 81},	//741 KConfigGroup::isGroupImmutableImpl(const QByteArray&) const
    {23, 1192, 587, 1, Smoke::mf_const, 0, 82},	//742 KConfigGroup::copyTo(KConfigBase*) const
    {23, 2428, 587, 1, 0, 0, 83},	//743 KConfigGroup::reparent(KConfigBase*)
    {23, 1334, 0, 0, 0, 0, 84},	//744 KConfigGroup::deleteGroup()
    {23, 1334, 32, 1, 0, 0, 85},	//745 KConfigGroup::deleteGroup(const QByteArray&)
    {23, 1334, 30, 1, 0, 0, 86},	//746 KConfigGroup::deleteGroup(const QString&)
    {23, 1334, 122, 1, 0, 0, 87},	//747 KConfigGroup::deleteGroup(const char*)
    {23, 2348, 30, 1, Smoke::mf_const, 351, 88},	//748 KConfigGroup::readEntry(const QString&) const
    {23, 2348, 122, 1, Smoke::mf_const, 351, 89},	//749 KConfigGroup::readEntry(const char*) const
    {23, 2385, 30, 1, Smoke::mf_const, 354, 90},	//750 KConfigGroup::readXdgListEntry(const QString&) const
    {23, 2385, 122, 1, Smoke::mf_const, 354, 91},	//751 KConfigGroup::readXdgListEntry(const char*) const
    {23, 2353, 30, 1, Smoke::mf_const, 351, 92},	//752 KConfigGroup::readEntryUntranslated(const QString&) const
    {23, 2353, 122, 1, Smoke::mf_const, 351, 93},	//753 KConfigGroup::readEntryUntranslated(const char*) const
    {23, 3292, 100, 2, 0, 0, 94},	//754 KConfigGroup::writeEntry(const QString&, const QVariant&)
    {23, 3292, 518, 2, 0, 0, 95},	//755 KConfigGroup::writeEntry(const char*, const QVariant&)
    {23, 3292, 95, 2, 0, 0, 96},	//756 KConfigGroup::writeEntry(const QString&, const QString&)
    {23, 3292, 521, 2, 0, 0, 97},	//757 KConfigGroup::writeEntry(const char*, const QString&)
    {23, 3292, 589, 2, 0, 0, 98},	//758 KConfigGroup::writeEntry(const QString&, const QByteArray&)
    {23, 3292, 592, 2, 0, 0, 99},	//759 KConfigGroup::writeEntry(const char*, const QByteArray&)
    {23, 3292, 524, 2, 0, 0, 100},	//760 KConfigGroup::writeEntry(const QString&, const char*)
    {23, 3292, 124, 2, 0, 0, 101},	//761 KConfigGroup::writeEntry(const char*, const char*)
    {23, 3292, 533, 2, 0, 0, 102},	//762 KConfigGroup::writeEntry(const QString&, const QStringList&)
    {23, 3292, 536, 2, 0, 0, 103},	//763 KConfigGroup::writeEntry(const char*, const QStringList&)
    {23, 3292, 527, 2, 0, 0, 104},	//764 KConfigGroup::writeEntry(const QString&, const QList<QVariant>&)
    {23, 3292, 530, 2, 0, 0, 105},	//765 KConfigGroup::writeEntry(const char*, const QList<QVariant>&)
    {23, 3306, 533, 2, 0, 0, 106},	//766 KConfigGroup::writeXdgListEntry(const QString&, const QStringList&)
    {23, 3306, 536, 2, 0, 0, 107},	//767 KConfigGroup::writeXdgListEntry(const char*, const QStringList&)
    {23, 3301, 95, 2, 0, 0, 108},	//768 KConfigGroup::writePathEntry(const QString&, const QString&)
    {23, 3301, 521, 2, 0, 0, 109},	//769 KConfigGroup::writePathEntry(const char*, const QString&)
    {23, 3301, 533, 2, 0, 0, 110},	//770 KConfigGroup::writePathEntry(const QString&, const QStringList&)
    {23, 3301, 536, 2, 0, 0, 111},	//771 KConfigGroup::writePathEntry(const char*, const QStringList&)
    {23, 1331, 30, 1, 0, 0, 112},	//772 KConfigGroup::deleteEntry(const QString&)
    {23, 1331, 122, 1, 0, 0, 113},	//773 KConfigGroup::deleteEntry(const char*)
    {23, 3368, 0, 0, Smoke::mf_dtor, 0, 114 },	//774 KConfigGroup::~KConfigGroup()
    {25, 338, 95, 2, Smoke::mf_ctor, 55, 1},	//775 KConfigSkeletonItem::KConfigSkeletonItem(const QString&, const QString&)
    {25, 2650, 30, 1, 0, 0, 2},	//776 KConfigSkeletonItem::setGroup(const QString&)
    {25, 1650, 0, 0, Smoke::mf_const, 351, 3},	//777 KConfigSkeletonItem::group() const
    {25, 2670, 30, 1, 0, 0, 4},	//778 KConfigSkeletonItem::setKey(const QString&)
    {25, 1924, 0, 0, Smoke::mf_const, 351, 5},	//779 KConfigSkeletonItem::key() const
    {25, 2782, 30, 1, 0, 0, 6},	//780 KConfigSkeletonItem::setName(const QString&)
    {25, 2102, 0, 0, Smoke::mf_const, 351, 7},	//781 KConfigSkeletonItem::name() const
    {25, 2672, 30, 1, 0, 0, 8},	//782 KConfigSkeletonItem::setLabel(const QString&)
    {25, 1943, 0, 0, Smoke::mf_const, 351, 9},	//783 KConfigSkeletonItem::label() const
    {25, 2896, 30, 1, 0, 0, 10},	//784 KConfigSkeletonItem::setToolTip(const QString&)
    {25, 3127, 0, 0, Smoke::mf_const, 351, 11},	//785 KConfigSkeletonItem::toolTip() const
    {25, 2922, 30, 1, 0, 0, 12},	//786 KConfigSkeletonItem::setWhatsThis(const QString&)
    {25, 3281, 0, 0, Smoke::mf_const, 351, 13},	//787 KConfigSkeletonItem::whatsThis() const
    {25, 2334, 595, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 14},	//788 KConfigSkeletonItem::readConfig(KConfig*) [pure virtual]
    {25, 3288, 595, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 15},	//789 KConfigSkeletonItem::writeConfig(KConfig*) [pure virtual]
    {25, 2343, 595, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 16},	//790 KConfigSkeletonItem::readDefault(KConfig*) [pure virtual]
    {25, 2843, 34, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 17},	//791 KConfigSkeletonItem::setProperty(const QVariant&) [pure virtual]
    {25, 1810, 34, 1, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 450, 18},	//792 KConfigSkeletonItem::isEqual(const QVariant&) const [pure virtual]
    {25, 2277, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 364, 19},	//793 KConfigSkeletonItem::property() const [pure virtual]
    {25, 2065, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 364, 20},	//794 KConfigSkeletonItem::minValue() const
    {25, 2054, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 364, 21},	//795 KConfigSkeletonItem::maxValue() const
    {25, 2594, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 22},	//796 KConfigSkeletonItem::setDefault() [pure virtual]
    {25, 3066, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 23},	//797 KConfigSkeletonItem::swapDefault() [pure virtual]
    {25, 1824, 0, 0, Smoke::mf_const, 450, 24},	//798 KConfigSkeletonItem::isImmutable() const
    {25, 2360, 511, 1, Smoke::mf_protected, 0, 25},	//799 KConfigSkeletonItem::readImmutability(const KConfigGroup&)
    {25, 338, 597, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 55, 26},	//800 KConfigSkeletonItem::KConfigSkeletonItem(const KConfigSkeletonItem&)
    {25, 2010, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 352, 27},	//801 KConfigSkeletonItem::mGroup() const
    {25, 2696, 30, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 28},	//802 KConfigSkeletonItem::setMGroup(const QString&)
    {25, 2011, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 352, 29},	//803 KConfigSkeletonItem::mKey() const
    {25, 2698, 30, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 30},	//804 KConfigSkeletonItem::setMKey(const QString&)
    {25, 2012, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 352, 31},	//805 KConfigSkeletonItem::mName() const
    {25, 2700, 30, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 32},	//806 KConfigSkeletonItem::setMName(const QString&)
    {25, 3369, 0, 0, Smoke::mf_dtor, 0, 33 },	//807 KConfigSkeletonItem::~KConfigSkeletonItem()
    {26, 2060, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 582, 1},	//808 KCoreConfigSkeleton::metaObject() const
    {26, 2301, 122, 1, Smoke::mf_virtual, 639, 2},	//809 KCoreConfigSkeleton::qt_metacast(const char*)
    {26, 3131, 124, 2, Smoke::mf_static, 351, 3},	//810 KCoreConfigSkeleton::tr(const char*, const char*)
    {26, 3138, 124, 2, Smoke::mf_static, 351, 4},	//811 KCoreConfigSkeleton::trUtf8(const char*, const char*)
    {26, 3131, 127, 3, Smoke::mf_static, 351, 5},	//812 KCoreConfigSkeleton::tr(const char*, const char*, int)
    {26, 3138, 127, 3, Smoke::mf_static, 351, 6},	//813 KCoreConfigSkeleton::trUtf8(const char*, const char*, int)
    {26, 2299, 131, 3, Smoke::mf_virtual, 614, 7},	//814 KCoreConfigSkeleton::qt_metacall(QMetaObject::Call, int, void**)
    {26, 341, 155, 2, Smoke::mf_ctor, 56, 8},	//815 KCoreConfigSkeleton::KCoreConfigSkeleton(const QString&, QObject*)
    {26, 341, 599, 2, Smoke::mf_ctor, 56, 9},	//816 KCoreConfigSkeleton::KCoreConfigSkeleton(KSharedPtr<KSharedConfig>, QObject*)
    {26, 2599, 0, 0, Smoke::mf_virtual, 0, 10},	//817 KCoreConfigSkeleton::setDefaults()
    {26, 2334, 0, 0, Smoke::mf_virtual, 0, 11},	//818 KCoreConfigSkeleton::readConfig()
    {26, 3288, 0, 0, Smoke::mf_virtual, 0, 12},	//819 KCoreConfigSkeleton::writeConfig()
    {26, 2559, 30, 1, 0, 0, 13},	//820 KCoreConfigSkeleton::setCurrentGroup(const QString&)
    {26, 1233, 0, 0, Smoke::mf_const, 351, 14},	//821 KCoreConfigSkeleton::currentGroup() const
    {26, 878, 602, 2, 0, 0, 15},	//822 KCoreConfigSkeleton::addItem(KConfigSkeletonItem*, const QString&)
    {26, 933, 605, 4, 0, 75, 16},	//823 KCoreConfigSkeleton::addItemString(const QString&, QString&, const QString&, const QString&)
    {26, 909, 605, 4, 0, 68, 17},	//824 KCoreConfigSkeleton::addItemPassword(const QString&, QString&, const QString&, const QString&)
    {26, 913, 605, 4, 0, 69, 18},	//825 KCoreConfigSkeleton::addItemPath(const QString&, QString&, const QString&, const QString&)
    {26, 921, 610, 4, 0, 72, 19},	//826 KCoreConfigSkeleton::addItemProperty(const QString&, QVariant&, const QVariant&, const QString&)
    {26, 881, 615, 4, 0, 57, 20},	//827 KCoreConfigSkeleton::addItemBool(const QString&, bool&, bool, const QString&)
    {26, 893, 620, 4, 0, 65, 21},	//828 KCoreConfigSkeleton::addItemInt(const QString&, int&, int, const QString&)
    {26, 941, 625, 4, 0, 78, 22},	//829 KCoreConfigSkeleton::addItemUInt(const QString&, unsigned int&, unsigned int, const QString&)
    {26, 905, 630, 4, 0, 67, 23},	//830 KCoreConfigSkeleton::addItemLongLong(const QString&, long long&, long long, const QString&)
    {26, 897, 630, 4, 0, 67, 24},	//831 KCoreConfigSkeleton::addItemInt64(const QString&, long long&, long long, const QString&)
    {26, 949, 635, 4, 0, 79, 25},	//832 KCoreConfigSkeleton::addItemULongLong(const QString&, unsigned long long&, unsigned long long, const QString&)
    {26, 945, 635, 4, 0, 79, 26},	//833 KCoreConfigSkeleton::addItemUInt64(const QString&, unsigned long long&, unsigned long long, const QString&)
    {26, 889, 640, 4, 0, 59, 27},	//834 KCoreConfigSkeleton::addItemDouble(const QString&, double&, double, const QString&)
    {26, 925, 645, 4, 0, 73, 28},	//835 KCoreConfigSkeleton::addItemRect(const QString&, QRect&, const QRect&, const QString&)
    {26, 917, 650, 4, 0, 71, 29},	//836 KCoreConfigSkeleton::addItemPoint(const QString&, QPoint&, const QPoint&, const QString&)
    {26, 929, 655, 4, 0, 74, 30},	//837 KCoreConfigSkeleton::addItemSize(const QString&, QSize&, const QSize&, const QString&)
    {26, 885, 660, 4, 0, 58, 31},	//838 KCoreConfigSkeleton::addItemDateTime(const QString&, QDateTime&, const QDateTime&, const QString&)
    {26, 937, 665, 4, 0, 77, 32},	//839 KCoreConfigSkeleton::addItemStringList(const QString&, QStringList&, const QStringList&, const QString&)
    {26, 901, 670, 4, 0, 66, 33},	//840 KCoreConfigSkeleton::addItemIntList(const QString&, QList<int>&, const QList<int>&, const QString&)
    {26, 1168, 0, 0, 0, 46, 34},	//841 KCoreConfigSkeleton::config()
    {26, 1168, 0, 0, Smoke::mf_const, 468, 35},	//842 KCoreConfigSkeleton::config() const
    {26, 2859, 675, 1, 0, 0, 36},	//843 KCoreConfigSkeleton::setSharedConfig(KSharedPtr<KSharedConfig>)
    {26, 1882, 0, 0, Smoke::mf_const, 314, 37},	//844 KCoreConfigSkeleton::items() const
    {26, 1824, 30, 1, 0, 450, 38},	//845 KCoreConfigSkeleton::isImmutable(const QString&)
    {26, 1824, 30, 1, Smoke::mf_const, 450, 39},	//846 KCoreConfigSkeleton::isImmutable(const QString&) const
    {26, 1549, 30, 1, 0, 55, 40},	//847 KCoreConfigSkeleton::findItem(const QString&)
    {26, 1549, 30, 1, Smoke::mf_const, 55, 41},	//848 KCoreConfigSkeleton::findItem(const QString&) const
    {26, 3206, 103, 1, Smoke::mf_virtual, 450, 42},	//849 KCoreConfigSkeleton::useDefaults(bool)
    {26, 1170, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 43},	//850 KCoreConfigSkeleton::configChanged()
    {26, 3217, 103, 1, Smoke::mf_protected|Smoke::mf_virtual, 450, 44},	//851 KCoreConfigSkeleton::usrUseDefaults(bool)
    {26, 3216, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 45},	//852 KCoreConfigSkeleton::usrSetDefaults()
    {26, 3215, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 46},	//853 KCoreConfigSkeleton::usrReadConfig()
    {26, 3219, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 47},	//854 KCoreConfigSkeleton::usrWriteConfig()
    {26, 3131, 122, 1, Smoke::mf_static, 351, 48},	//855 KCoreConfigSkeleton::tr(const char*)
    {26, 3138, 122, 1, Smoke::mf_static, 351, 49},	//856 KCoreConfigSkeleton::trUtf8(const char*)
    {26, 341, 0, 0, Smoke::mf_ctor, 56, 50},	//857 KCoreConfigSkeleton::KCoreConfigSkeleton()
    {26, 341, 30, 1, Smoke::mf_ctor, 56, 51},	//858 KCoreConfigSkeleton::KCoreConfigSkeleton(const QString&)
    {26, 341, 675, 1, Smoke::mf_ctor, 56, 52},	//859 KCoreConfigSkeleton::KCoreConfigSkeleton(KSharedPtr<KSharedConfig>)
    {26, 878, 677, 1, 0, 0, 53},	//860 KCoreConfigSkeleton::addItem(KConfigSkeletonItem*)
    {26, 933, 679, 2, 0, 75, 54},	//861 KCoreConfigSkeleton::addItemString(const QString&, QString&)
    {26, 933, 682, 3, 0, 75, 55},	//862 KCoreConfigSkeleton::addItemString(const QString&, QString&, const QString&)
    {26, 909, 679, 2, 0, 68, 56},	//863 KCoreConfigSkeleton::addItemPassword(const QString&, QString&)
    {26, 909, 682, 3, 0, 68, 57},	//864 KCoreConfigSkeleton::addItemPassword(const QString&, QString&, const QString&)
    {26, 913, 679, 2, 0, 69, 58},	//865 KCoreConfigSkeleton::addItemPath(const QString&, QString&)
    {26, 913, 682, 3, 0, 69, 59},	//866 KCoreConfigSkeleton::addItemPath(const QString&, QString&, const QString&)
    {26, 921, 686, 2, 0, 72, 60},	//867 KCoreConfigSkeleton::addItemProperty(const QString&, QVariant&)
    {26, 921, 689, 3, 0, 72, 61},	//868 KCoreConfigSkeleton::addItemProperty(const QString&, QVariant&, const QVariant&)
    {26, 881, 351, 2, 0, 57, 62},	//869 KCoreConfigSkeleton::addItemBool(const QString&, bool&)
    {26, 881, 693, 3, 0, 57, 63},	//870 KCoreConfigSkeleton::addItemBool(const QString&, bool&, bool)
    {26, 893, 260, 2, 0, 65, 64},	//871 KCoreConfigSkeleton::addItemInt(const QString&, int&)
    {26, 893, 697, 3, 0, 65, 65},	//872 KCoreConfigSkeleton::addItemInt(const QString&, int&, int)
    {26, 941, 701, 2, 0, 78, 66},	//873 KCoreConfigSkeleton::addItemUInt(const QString&, unsigned int&)
    {26, 941, 704, 3, 0, 78, 67},	//874 KCoreConfigSkeleton::addItemUInt(const QString&, unsigned int&, unsigned int)
    {26, 905, 708, 2, 0, 67, 68},	//875 KCoreConfigSkeleton::addItemLongLong(const QString&, long long&)
    {26, 905, 711, 3, 0, 67, 69},	//876 KCoreConfigSkeleton::addItemLongLong(const QString&, long long&, long long)
    {26, 897, 708, 2, 0, 67, 70},	//877 KCoreConfigSkeleton::addItemInt64(const QString&, long long&)
    {26, 897, 711, 3, 0, 67, 71},	//878 KCoreConfigSkeleton::addItemInt64(const QString&, long long&, long long)
    {26, 949, 715, 2, 0, 79, 72},	//879 KCoreConfigSkeleton::addItemULongLong(const QString&, unsigned long long&)
    {26, 949, 718, 3, 0, 79, 73},	//880 KCoreConfigSkeleton::addItemULongLong(const QString&, unsigned long long&, unsigned long long)
    {26, 945, 715, 2, 0, 79, 74},	//881 KCoreConfigSkeleton::addItemUInt64(const QString&, unsigned long long&)
    {26, 945, 718, 3, 0, 79, 75},	//882 KCoreConfigSkeleton::addItemUInt64(const QString&, unsigned long long&, unsigned long long)
    {26, 889, 722, 2, 0, 59, 76},	//883 KCoreConfigSkeleton::addItemDouble(const QString&, double&)
    {26, 889, 725, 3, 0, 59, 77},	//884 KCoreConfigSkeleton::addItemDouble(const QString&, double&, double)
    {26, 925, 729, 2, 0, 73, 78},	//885 KCoreConfigSkeleton::addItemRect(const QString&, QRect&)
    {26, 925, 732, 3, 0, 73, 79},	//886 KCoreConfigSkeleton::addItemRect(const QString&, QRect&, const QRect&)
    {26, 917, 736, 2, 0, 71, 80},	//887 KCoreConfigSkeleton::addItemPoint(const QString&, QPoint&)
    {26, 917, 739, 3, 0, 71, 81},	//888 KCoreConfigSkeleton::addItemPoint(const QString&, QPoint&, const QPoint&)
    {26, 929, 743, 2, 0, 74, 82},	//889 KCoreConfigSkeleton::addItemSize(const QString&, QSize&)
    {26, 929, 746, 3, 0, 74, 83},	//890 KCoreConfigSkeleton::addItemSize(const QString&, QSize&, const QSize&)
    {26, 885, 750, 2, 0, 58, 84},	//891 KCoreConfigSkeleton::addItemDateTime(const QString&, QDateTime&)
    {26, 885, 753, 3, 0, 58, 85},	//892 KCoreConfigSkeleton::addItemDateTime(const QString&, QDateTime&, const QDateTime&)
    {26, 937, 757, 2, 0, 77, 86},	//893 KCoreConfigSkeleton::addItemStringList(const QString&, QStringList&)
    {26, 937, 760, 3, 0, 77, 87},	//894 KCoreConfigSkeleton::addItemStringList(const QString&, QStringList&, const QStringList&)
    {26, 901, 764, 2, 0, 66, 88},	//895 KCoreConfigSkeleton::addItemIntList(const QString&, QList<int>&)
    {26, 901, 767, 3, 0, 66, 89},	//896 KCoreConfigSkeleton::addItemIntList(const QString&, QList<int>&, const QList<int>&)
    {26, 3030, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 581, 90},	//897 KCoreConfigSkeleton::staticMetaObject() const
    {26, 3370, 0, 0, Smoke::mf_dtor, 0, 91 },	//898 KCoreConfigSkeleton::~KCoreConfigSkeleton()
    {27, 190, 771, 4, Smoke::mf_ctor, 57, 1},	//899 KCoreConfigSkeleton::ItemBool::ItemBool(const QString&, const QString&, bool&, bool)
    {27, 2334, 595, 1, 0, 0, 2},	//900 KCoreConfigSkeleton::ItemBool::readConfig(KConfig*)
    {27, 2843, 34, 1, 0, 0, 3},	//901 KCoreConfigSkeleton::ItemBool::setProperty(const QVariant&)
    {27, 1810, 34, 1, Smoke::mf_const, 450, 4},	//902 KCoreConfigSkeleton::ItemBool::isEqual(const QVariant&) const
    {27, 2277, 0, 0, Smoke::mf_const, 364, 5},	//903 KCoreConfigSkeleton::ItemBool::property() const
    {27, 190, 776, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 57, 6},	//904 KCoreConfigSkeleton::ItemBool::ItemBool(const KCoreConfigSkeleton::ItemBool&)
    {27, 190, 778, 3, Smoke::mf_ctor, 57, 7},	//905 KCoreConfigSkeleton::ItemBool::ItemBool(const QString&, const QString&, bool&)
    {27, 3334, 0, 0, Smoke::mf_dtor, 0, 8 },	//906 KCoreConfigSkeleton::ItemBool::~ItemBool()
    {28, 194, 782, 4, Smoke::mf_ctor, 58, 1},	//907 KCoreConfigSkeleton::ItemDateTime::ItemDateTime(const QString&, const QString&, QDateTime&, const QDateTime&)
    {28, 2334, 595, 1, 0, 0, 2},	//908 KCoreConfigSkeleton::ItemDateTime::readConfig(KConfig*)
    {28, 2843, 34, 1, 0, 0, 3},	//909 KCoreConfigSkeleton::ItemDateTime::setProperty(const QVariant&)
    {28, 1810, 34, 1, Smoke::mf_const, 450, 4},	//910 KCoreConfigSkeleton::ItemDateTime::isEqual(const QVariant&) const
    {28, 2277, 0, 0, Smoke::mf_const, 364, 5},	//911 KCoreConfigSkeleton::ItemDateTime::property() const
    {28, 194, 787, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 58, 6},	//912 KCoreConfigSkeleton::ItemDateTime::ItemDateTime(const KCoreConfigSkeleton::ItemDateTime&)
    {28, 194, 789, 3, Smoke::mf_ctor, 58, 7},	//913 KCoreConfigSkeleton::ItemDateTime::ItemDateTime(const QString&, const QString&, QDateTime&)
    {28, 3335, 0, 0, Smoke::mf_dtor, 0, 8 },	//914 KCoreConfigSkeleton::ItemDateTime::~ItemDateTime()
    {29, 198, 793, 4, Smoke::mf_ctor, 59, 1},	//915 KCoreConfigSkeleton::ItemDouble::ItemDouble(const QString&, const QString&, double&, double)
    {29, 2334, 595, 1, 0, 0, 2},	//916 KCoreConfigSkeleton::ItemDouble::readConfig(KConfig*)
    {29, 2843, 34, 1, 0, 0, 3},	//917 KCoreConfigSkeleton::ItemDouble::setProperty(const QVariant&)
    {29, 1810, 34, 1, Smoke::mf_const, 450, 4},	//918 KCoreConfigSkeleton::ItemDouble::isEqual(const QVariant&) const
    {29, 2277, 0, 0, Smoke::mf_const, 364, 5},	//919 KCoreConfigSkeleton::ItemDouble::property() const
    {29, 2065, 0, 0, Smoke::mf_const, 364, 6},	//920 KCoreConfigSkeleton::ItemDouble::minValue() const
    {29, 2054, 0, 0, Smoke::mf_const, 364, 7},	//921 KCoreConfigSkeleton::ItemDouble::maxValue() const
    {29, 2770, 798, 1, 0, 0, 8},	//922 KCoreConfigSkeleton::ItemDouble::setMinValue(double)
    {29, 2762, 798, 1, 0, 0, 9},	//923 KCoreConfigSkeleton::ItemDouble::setMaxValue(double)
    {29, 198, 800, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 59, 10},	//924 KCoreConfigSkeleton::ItemDouble::ItemDouble(const KCoreConfigSkeleton::ItemDouble&)
    {29, 198, 802, 3, Smoke::mf_ctor, 59, 11},	//925 KCoreConfigSkeleton::ItemDouble::ItemDouble(const QString&, const QString&, double&)
    {29, 3336, 0, 0, Smoke::mf_dtor, 0, 12 },	//926 KCoreConfigSkeleton::ItemDouble::~ItemDouble()
    {30, 202, 806, 5, Smoke::mf_ctor, 60, 1},	//927 KCoreConfigSkeleton::ItemEnum::ItemEnum(const QString&, const QString&, int&, const QList<KCoreConfigSkeleton::ItemEnum::Choice>&, int)
    {30, 202, 812, 5, Smoke::mf_ctor, 60, 2},	//928 KCoreConfigSkeleton::ItemEnum::ItemEnum(const QString&, const QString&, int&, const QList<KCoreConfigSkeleton::ItemEnum::Choice2>&, int)
    {30, 1140, 0, 0, Smoke::mf_const, 316, 3},	//929 KCoreConfigSkeleton::ItemEnum::choices() const
    {30, 1141, 0, 0, Smoke::mf_const, 315, 4},	//930 KCoreConfigSkeleton::ItemEnum::choices2() const
    {30, 2334, 595, 1, 0, 0, 5},	//931 KCoreConfigSkeleton::ItemEnum::readConfig(KConfig*)
    {30, 3288, 595, 1, 0, 0, 6},	//932 KCoreConfigSkeleton::ItemEnum::writeConfig(KConfig*)
    {30, 202, 818, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 60, 7},	//933 KCoreConfigSkeleton::ItemEnum::ItemEnum(const KCoreConfigSkeleton::ItemEnum&)
    {30, 202, 820, 4, Smoke::mf_ctor, 60, 8},	//934 KCoreConfigSkeleton::ItemEnum::ItemEnum(const QString&, const QString&, int&, const QList<KCoreConfigSkeleton::ItemEnum::Choice>&)
    {30, 202, 825, 4, Smoke::mf_ctor, 60, 9},	//935 KCoreConfigSkeleton::ItemEnum::ItemEnum(const QString&, const QString&, int&, const QList<KCoreConfigSkeleton::ItemEnum::Choice2>&)
    {30, 3337, 0, 0, Smoke::mf_dtor, 0, 10 },	//936 KCoreConfigSkeleton::ItemEnum::~ItemEnum()
    {31, 56, 0, 0, Smoke::mf_ctor, 62, 1},	//937 KCoreConfigSkeleton::ItemEnum::Choice::Choice()
    {31, 56, 830, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 62, 2},	//938 KCoreConfigSkeleton::ItemEnum::Choice::Choice(const KCoreConfigSkeleton::ItemEnum::Choice&)
    {31, 2102, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 352, 3},	//939 KCoreConfigSkeleton::ItemEnum::Choice::name() const
    {31, 2782, 30, 1, Smoke::mf_attribute, 0, 4},	//940 KCoreConfigSkeleton::ItemEnum::Choice::setName(const QString&)
    {31, 1943, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 352, 5},	//941 KCoreConfigSkeleton::ItemEnum::Choice::label() const
    {31, 2672, 30, 1, Smoke::mf_attribute, 0, 6},	//942 KCoreConfigSkeleton::ItemEnum::Choice::setLabel(const QString&)
    {31, 3281, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 352, 7},	//943 KCoreConfigSkeleton::ItemEnum::Choice::whatsThis() const
    {31, 2922, 30, 1, Smoke::mf_attribute, 0, 8},	//944 KCoreConfigSkeleton::ItemEnum::Choice::setWhatsThis(const QString&)
    {31, 3331, 0, 0, Smoke::mf_dtor, 0, 9 },	//945 KCoreConfigSkeleton::ItemEnum::Choice::~Choice()
    {32, 58, 0, 0, Smoke::mf_ctor, 64, 1},	//946 KCoreConfigSkeleton::ItemEnum::Choice2::Choice2()
    {32, 58, 832, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 64, 2},	//947 KCoreConfigSkeleton::ItemEnum::Choice2::Choice2(const KCoreConfigSkeleton::ItemEnum::Choice2&)
    {32, 2102, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 352, 3},	//948 KCoreConfigSkeleton::ItemEnum::Choice2::name() const
    {32, 2782, 30, 1, Smoke::mf_attribute, 0, 4},	//949 KCoreConfigSkeleton::ItemEnum::Choice2::setName(const QString&)
    {32, 1943, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 352, 5},	//950 KCoreConfigSkeleton::ItemEnum::Choice2::label() const
    {32, 2672, 30, 1, Smoke::mf_attribute, 0, 6},	//951 KCoreConfigSkeleton::ItemEnum::Choice2::setLabel(const QString&)
    {32, 3127, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 352, 7},	//952 KCoreConfigSkeleton::ItemEnum::Choice2::toolTip() const
    {32, 2896, 30, 1, Smoke::mf_attribute, 0, 8},	//953 KCoreConfigSkeleton::ItemEnum::Choice2::setToolTip(const QString&)
    {32, 3281, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 352, 9},	//954 KCoreConfigSkeleton::ItemEnum::Choice2::whatsThis() const
    {32, 2922, 30, 1, Smoke::mf_attribute, 0, 10},	//955 KCoreConfigSkeleton::ItemEnum::Choice2::setWhatsThis(const QString&)
    {32, 3332, 0, 0, Smoke::mf_dtor, 0, 11 },	//956 KCoreConfigSkeleton::ItemEnum::Choice2::~Choice2()
    {33, 206, 834, 4, Smoke::mf_ctor, 65, 1},	//957 KCoreConfigSkeleton::ItemInt::ItemInt(const QString&, const QString&, int&, int)
    {33, 2334, 595, 1, 0, 0, 2},	//958 KCoreConfigSkeleton::ItemInt::readConfig(KConfig*)
    {33, 2843, 34, 1, 0, 0, 3},	//959 KCoreConfigSkeleton::ItemInt::setProperty(const QVariant&)
    {33, 1810, 34, 1, Smoke::mf_const, 450, 4},	//960 KCoreConfigSkeleton::ItemInt::isEqual(const QVariant&) const
    {33, 2277, 0, 0, Smoke::mf_const, 364, 5},	//961 KCoreConfigSkeleton::ItemInt::property() const
    {33, 2065, 0, 0, Smoke::mf_const, 364, 6},	//962 KCoreConfigSkeleton::ItemInt::minValue() const
    {33, 2054, 0, 0, Smoke::mf_const, 364, 7},	//963 KCoreConfigSkeleton::ItemInt::maxValue() const
    {33, 2770, 118, 1, 0, 0, 8},	//964 KCoreConfigSkeleton::ItemInt::setMinValue(int)
    {33, 2762, 118, 1, 0, 0, 9},	//965 KCoreConfigSkeleton::ItemInt::setMaxValue(int)
    {33, 206, 839, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 65, 10},	//966 KCoreConfigSkeleton::ItemInt::ItemInt(const KCoreConfigSkeleton::ItemInt&)
    {33, 206, 841, 3, Smoke::mf_ctor, 65, 11},	//967 KCoreConfigSkeleton::ItemInt::ItemInt(const QString&, const QString&, int&)
    {33, 3338, 0, 0, Smoke::mf_dtor, 0, 12 },	//968 KCoreConfigSkeleton::ItemInt::~ItemInt()
    {34, 210, 845, 4, Smoke::mf_ctor, 66, 1},	//969 KCoreConfigSkeleton::ItemIntList::ItemIntList(const QString&, const QString&, QList<int>&, const QList<int>&)
    {34, 2334, 595, 1, 0, 0, 2},	//970 KCoreConfigSkeleton::ItemIntList::readConfig(KConfig*)
    {34, 2843, 34, 1, 0, 0, 3},	//971 KCoreConfigSkeleton::ItemIntList::setProperty(const QVariant&)
    {34, 1810, 34, 1, Smoke::mf_const, 450, 4},	//972 KCoreConfigSkeleton::ItemIntList::isEqual(const QVariant&) const
    {34, 2277, 0, 0, Smoke::mf_const, 364, 5},	//973 KCoreConfigSkeleton::ItemIntList::property() const
    {34, 210, 850, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 66, 6},	//974 KCoreConfigSkeleton::ItemIntList::ItemIntList(const KCoreConfigSkeleton::ItemIntList&)
    {34, 210, 852, 3, Smoke::mf_ctor, 66, 7},	//975 KCoreConfigSkeleton::ItemIntList::ItemIntList(const QString&, const QString&, QList<int>&)
    {34, 3339, 0, 0, Smoke::mf_dtor, 0, 8 },	//976 KCoreConfigSkeleton::ItemIntList::~ItemIntList()
    {35, 214, 856, 4, Smoke::mf_ctor, 67, 1},	//977 KCoreConfigSkeleton::ItemLongLong::ItemLongLong(const QString&, const QString&, long long&, long long)
    {35, 2334, 595, 1, 0, 0, 2},	//978 KCoreConfigSkeleton::ItemLongLong::readConfig(KConfig*)
    {35, 2843, 34, 1, 0, 0, 3},	//979 KCoreConfigSkeleton::ItemLongLong::setProperty(const QVariant&)
    {35, 1810, 34, 1, Smoke::mf_const, 450, 4},	//980 KCoreConfigSkeleton::ItemLongLong::isEqual(const QVariant&) const
    {35, 2277, 0, 0, Smoke::mf_const, 364, 5},	//981 KCoreConfigSkeleton::ItemLongLong::property() const
    {35, 2065, 0, 0, Smoke::mf_const, 364, 6},	//982 KCoreConfigSkeleton::ItemLongLong::minValue() const
    {35, 2054, 0, 0, Smoke::mf_const, 364, 7},	//983 KCoreConfigSkeleton::ItemLongLong::maxValue() const
    {35, 2770, 861, 1, 0, 0, 8},	//984 KCoreConfigSkeleton::ItemLongLong::setMinValue(long long)
    {35, 2762, 861, 1, 0, 0, 9},	//985 KCoreConfigSkeleton::ItemLongLong::setMaxValue(long long)
    {35, 214, 863, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 67, 10},	//986 KCoreConfigSkeleton::ItemLongLong::ItemLongLong(const KCoreConfigSkeleton::ItemLongLong&)
    {35, 214, 865, 3, Smoke::mf_ctor, 67, 11},	//987 KCoreConfigSkeleton::ItemLongLong::ItemLongLong(const QString&, const QString&, long long&)
    {35, 3340, 0, 0, Smoke::mf_dtor, 0, 12 },	//988 KCoreConfigSkeleton::ItemLongLong::~ItemLongLong()
    {36, 218, 869, 4, Smoke::mf_ctor, 68, 1},	//989 KCoreConfigSkeleton::ItemPassword::ItemPassword(const QString&, const QString&, QString&, const QString&)
    {36, 218, 874, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 68, 2},	//990 KCoreConfigSkeleton::ItemPassword::ItemPassword(const KCoreConfigSkeleton::ItemPassword&)
    {36, 218, 876, 3, Smoke::mf_ctor, 68, 3},	//991 KCoreConfigSkeleton::ItemPassword::ItemPassword(const QString&, const QString&, QString&)
    {36, 3341, 0, 0, Smoke::mf_dtor, 0, 4 },	//992 KCoreConfigSkeleton::ItemPassword::~ItemPassword()
    {37, 222, 869, 4, Smoke::mf_ctor, 69, 1},	//993 KCoreConfigSkeleton::ItemPath::ItemPath(const QString&, const QString&, QString&, const QString&)
    {37, 222, 880, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 69, 2},	//994 KCoreConfigSkeleton::ItemPath::ItemPath(const KCoreConfigSkeleton::ItemPath&)
    {37, 222, 876, 3, Smoke::mf_ctor, 69, 3},	//995 KCoreConfigSkeleton::ItemPath::ItemPath(const QString&, const QString&, QString&)
    {37, 3342, 0, 0, Smoke::mf_dtor, 0, 4 },	//996 KCoreConfigSkeleton::ItemPath::~ItemPath()
    {38, 226, 882, 4, Smoke::mf_ctor, 70, 1},	//997 KCoreConfigSkeleton::ItemPathList::ItemPathList(const QString&, const QString&, QStringList&, const QStringList&)
    {38, 2334, 595, 1, 0, 0, 2},	//998 KCoreConfigSkeleton::ItemPathList::readConfig(KConfig*)
    {38, 3288, 595, 1, 0, 0, 3},	//999 KCoreConfigSkeleton::ItemPathList::writeConfig(KConfig*)
    {38, 226, 887, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 70, 4},	//1000 KCoreConfigSkeleton::ItemPathList::ItemPathList(const KCoreConfigSkeleton::ItemPathList&)
    {38, 226, 889, 3, Smoke::mf_ctor, 70, 5},	//1001 KCoreConfigSkeleton::ItemPathList::ItemPathList(const QString&, const QString&, QStringList&)
    {38, 3343, 0, 0, Smoke::mf_dtor, 0, 6 },	//1002 KCoreConfigSkeleton::ItemPathList::~ItemPathList()
    {39, 230, 893, 4, Smoke::mf_ctor, 71, 1},	//1003 KCoreConfigSkeleton::ItemPoint::ItemPoint(const QString&, const QString&, QPoint&, const QPoint&)
    {39, 2334, 595, 1, 0, 0, 2},	//1004 KCoreConfigSkeleton::ItemPoint::readConfig(KConfig*)
    {39, 2843, 34, 1, 0, 0, 3},	//1005 KCoreConfigSkeleton::ItemPoint::setProperty(const QVariant&)
    {39, 1810, 34, 1, Smoke::mf_const, 450, 4},	//1006 KCoreConfigSkeleton::ItemPoint::isEqual(const QVariant&) const
    {39, 2277, 0, 0, Smoke::mf_const, 364, 5},	//1007 KCoreConfigSkeleton::ItemPoint::property() const
    {39, 230, 898, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 71, 6},	//1008 KCoreConfigSkeleton::ItemPoint::ItemPoint(const KCoreConfigSkeleton::ItemPoint&)
    {39, 230, 900, 3, Smoke::mf_ctor, 71, 7},	//1009 KCoreConfigSkeleton::ItemPoint::ItemPoint(const QString&, const QString&, QPoint&)
    {39, 3344, 0, 0, Smoke::mf_dtor, 0, 8 },	//1010 KCoreConfigSkeleton::ItemPoint::~ItemPoint()
    {40, 234, 904, 4, Smoke::mf_ctor, 72, 1},	//1011 KCoreConfigSkeleton::ItemProperty::ItemProperty(const QString&, const QString&, QVariant&, const QVariant&)
    {40, 2334, 595, 1, 0, 0, 2},	//1012 KCoreConfigSkeleton::ItemProperty::readConfig(KConfig*)
    {40, 2843, 34, 1, 0, 0, 3},	//1013 KCoreConfigSkeleton::ItemProperty::setProperty(const QVariant&)
    {40, 1810, 34, 1, Smoke::mf_const, 450, 4},	//1014 KCoreConfigSkeleton::ItemProperty::isEqual(const QVariant&) const
    {40, 2277, 0, 0, Smoke::mf_const, 364, 5},	//1015 KCoreConfigSkeleton::ItemProperty::property() const
    {40, 234, 909, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 72, 6},	//1016 KCoreConfigSkeleton::ItemProperty::ItemProperty(const KCoreConfigSkeleton::ItemProperty&)
    {40, 234, 911, 3, Smoke::mf_ctor, 72, 7},	//1017 KCoreConfigSkeleton::ItemProperty::ItemProperty(const QString&, const QString&, QVariant&)
    {40, 3345, 0, 0, Smoke::mf_dtor, 0, 8 },	//1018 KCoreConfigSkeleton::ItemProperty::~ItemProperty()
    {41, 238, 915, 4, Smoke::mf_ctor, 73, 1},	//1019 KCoreConfigSkeleton::ItemRect::ItemRect(const QString&, const QString&, QRect&, const QRect&)
    {41, 2334, 595, 1, 0, 0, 2},	//1020 KCoreConfigSkeleton::ItemRect::readConfig(KConfig*)
    {41, 2843, 34, 1, 0, 0, 3},	//1021 KCoreConfigSkeleton::ItemRect::setProperty(const QVariant&)
    {41, 1810, 34, 1, Smoke::mf_const, 450, 4},	//1022 KCoreConfigSkeleton::ItemRect::isEqual(const QVariant&) const
    {41, 2277, 0, 0, Smoke::mf_const, 364, 5},	//1023 KCoreConfigSkeleton::ItemRect::property() const
    {41, 238, 920, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 73, 6},	//1024 KCoreConfigSkeleton::ItemRect::ItemRect(const KCoreConfigSkeleton::ItemRect&)
    {41, 238, 922, 3, Smoke::mf_ctor, 73, 7},	//1025 KCoreConfigSkeleton::ItemRect::ItemRect(const QString&, const QString&, QRect&)
    {41, 3346, 0, 0, Smoke::mf_dtor, 0, 8 },	//1026 KCoreConfigSkeleton::ItemRect::~ItemRect()
    {42, 242, 926, 4, Smoke::mf_ctor, 74, 1},	//1027 KCoreConfigSkeleton::ItemSize::ItemSize(const QString&, const QString&, QSize&, const QSize&)
    {42, 2334, 595, 1, 0, 0, 2},	//1028 KCoreConfigSkeleton::ItemSize::readConfig(KConfig*)
    {42, 2843, 34, 1, 0, 0, 3},	//1029 KCoreConfigSkeleton::ItemSize::setProperty(const QVariant&)
    {42, 1810, 34, 1, Smoke::mf_const, 450, 4},	//1030 KCoreConfigSkeleton::ItemSize::isEqual(const QVariant&) const
    {42, 2277, 0, 0, Smoke::mf_const, 364, 5},	//1031 KCoreConfigSkeleton::ItemSize::property() const
    {42, 242, 931, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 74, 6},	//1032 KCoreConfigSkeleton::ItemSize::ItemSize(const KCoreConfigSkeleton::ItemSize&)
    {42, 242, 933, 3, Smoke::mf_ctor, 74, 7},	//1033 KCoreConfigSkeleton::ItemSize::ItemSize(const QString&, const QString&, QSize&)
    {42, 3347, 0, 0, Smoke::mf_dtor, 0, 8 },	//1034 KCoreConfigSkeleton::ItemSize::~ItemSize()
    {43, 246, 937, 5, Smoke::mf_ctor, 75, 1},	//1035 KCoreConfigSkeleton::ItemString::ItemString(const QString&, const QString&, QString&, const QString&, KCoreConfigSkeleton::ItemString::Type)
    {43, 3288, 595, 1, 0, 0, 2},	//1036 KCoreConfigSkeleton::ItemString::writeConfig(KConfig*)
    {43, 2334, 595, 1, 0, 0, 3},	//1037 KCoreConfigSkeleton::ItemString::readConfig(KConfig*)
    {43, 2843, 34, 1, 0, 0, 4},	//1038 KCoreConfigSkeleton::ItemString::setProperty(const QVariant&)
    {43, 1810, 34, 1, Smoke::mf_const, 450, 5},	//1039 KCoreConfigSkeleton::ItemString::isEqual(const QVariant&) const
    {43, 2277, 0, 0, Smoke::mf_const, 364, 6},	//1040 KCoreConfigSkeleton::ItemString::property() const
    {43, 246, 943, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 75, 7},	//1041 KCoreConfigSkeleton::ItemString::ItemString(const KCoreConfigSkeleton::ItemString&)
    {43, 246, 876, 3, Smoke::mf_ctor, 75, 8},	//1042 KCoreConfigSkeleton::ItemString::ItemString(const QString&, const QString&, QString&)
    {43, 246, 869, 4, Smoke::mf_ctor, 75, 9},	//1043 KCoreConfigSkeleton::ItemString::ItemString(const QString&, const QString&, QString&, const QString&)
    {43, 634, 0, 0, Smoke::mf_static|Smoke::mf_enum, 76, 10},	//1044 KCoreConfigSkeleton::ItemString::Normal (enum)
    {43, 656, 0, 0, Smoke::mf_static|Smoke::mf_enum, 76, 11},	//1045 KCoreConfigSkeleton::ItemString::Password (enum)
    {43, 657, 0, 0, Smoke::mf_static|Smoke::mf_enum, 76, 12},	//1046 KCoreConfigSkeleton::ItemString::Path (enum)
    {43, 3348, 0, 0, Smoke::mf_dtor, 0, 13 },	//1047 KCoreConfigSkeleton::ItemString::~ItemString()
    {44, 251, 882, 4, Smoke::mf_ctor, 77, 1},	//1048 KCoreConfigSkeleton::ItemStringList::ItemStringList(const QString&, const QString&, QStringList&, const QStringList&)
    {44, 2334, 595, 1, 0, 0, 2},	//1049 KCoreConfigSkeleton::ItemStringList::readConfig(KConfig*)
    {44, 2843, 34, 1, 0, 0, 3},	//1050 KCoreConfigSkeleton::ItemStringList::setProperty(const QVariant&)
    {44, 1810, 34, 1, Smoke::mf_const, 450, 4},	//1051 KCoreConfigSkeleton::ItemStringList::isEqual(const QVariant&) const
    {44, 2277, 0, 0, Smoke::mf_const, 364, 5},	//1052 KCoreConfigSkeleton::ItemStringList::property() const
    {44, 251, 945, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 77, 6},	//1053 KCoreConfigSkeleton::ItemStringList::ItemStringList(const KCoreConfigSkeleton::ItemStringList&)
    {44, 251, 889, 3, Smoke::mf_ctor, 77, 7},	//1054 KCoreConfigSkeleton::ItemStringList::ItemStringList(const QString&, const QString&, QStringList&)
    {44, 3349, 0, 0, Smoke::mf_dtor, 0, 8 },	//1055 KCoreConfigSkeleton::ItemStringList::~ItemStringList()
    {45, 255, 947, 4, Smoke::mf_ctor, 78, 1},	//1056 KCoreConfigSkeleton::ItemUInt::ItemUInt(const QString&, const QString&, unsigned int&, unsigned int)
    {45, 2334, 595, 1, 0, 0, 2},	//1057 KCoreConfigSkeleton::ItemUInt::readConfig(KConfig*)
    {45, 2843, 34, 1, 0, 0, 3},	//1058 KCoreConfigSkeleton::ItemUInt::setProperty(const QVariant&)
    {45, 1810, 34, 1, Smoke::mf_const, 450, 4},	//1059 KCoreConfigSkeleton::ItemUInt::isEqual(const QVariant&) const
    {45, 2277, 0, 0, Smoke::mf_const, 364, 5},	//1060 KCoreConfigSkeleton::ItemUInt::property() const
    {45, 2065, 0, 0, Smoke::mf_const, 364, 6},	//1061 KCoreConfigSkeleton::ItemUInt::minValue() const
    {45, 2054, 0, 0, Smoke::mf_const, 364, 7},	//1062 KCoreConfigSkeleton::ItemUInt::maxValue() const
    {45, 2770, 952, 1, 0, 0, 8},	//1063 KCoreConfigSkeleton::ItemUInt::setMinValue(unsigned int)
    {45, 2762, 952, 1, 0, 0, 9},	//1064 KCoreConfigSkeleton::ItemUInt::setMaxValue(unsigned int)
    {45, 255, 954, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 78, 10},	//1065 KCoreConfigSkeleton::ItemUInt::ItemUInt(const KCoreConfigSkeleton::ItemUInt&)
    {45, 255, 956, 3, Smoke::mf_ctor, 78, 11},	//1066 KCoreConfigSkeleton::ItemUInt::ItemUInt(const QString&, const QString&, unsigned int&)
    {45, 3350, 0, 0, Smoke::mf_dtor, 0, 12 },	//1067 KCoreConfigSkeleton::ItemUInt::~ItemUInt()
    {46, 259, 960, 4, Smoke::mf_ctor, 79, 1},	//1068 KCoreConfigSkeleton::ItemULongLong::ItemULongLong(const QString&, const QString&, unsigned long long&, unsigned long long)
    {46, 2334, 595, 1, 0, 0, 2},	//1069 KCoreConfigSkeleton::ItemULongLong::readConfig(KConfig*)
    {46, 2843, 34, 1, 0, 0, 3},	//1070 KCoreConfigSkeleton::ItemULongLong::setProperty(const QVariant&)
    {46, 1810, 34, 1, Smoke::mf_const, 450, 4},	//1071 KCoreConfigSkeleton::ItemULongLong::isEqual(const QVariant&) const
    {46, 2277, 0, 0, Smoke::mf_const, 364, 5},	//1072 KCoreConfigSkeleton::ItemULongLong::property() const
    {46, 2065, 0, 0, Smoke::mf_const, 364, 6},	//1073 KCoreConfigSkeleton::ItemULongLong::minValue() const
    {46, 2054, 0, 0, Smoke::mf_const, 364, 7},	//1074 KCoreConfigSkeleton::ItemULongLong::maxValue() const
    {46, 2770, 965, 1, 0, 0, 8},	//1075 KCoreConfigSkeleton::ItemULongLong::setMinValue(unsigned long long)
    {46, 2762, 965, 1, 0, 0, 9},	//1076 KCoreConfigSkeleton::ItemULongLong::setMaxValue(unsigned long long)
    {46, 259, 967, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 79, 10},	//1077 KCoreConfigSkeleton::ItemULongLong::ItemULongLong(const KCoreConfigSkeleton::ItemULongLong&)
    {46, 259, 969, 3, Smoke::mf_ctor, 79, 11},	//1078 KCoreConfigSkeleton::ItemULongLong::ItemULongLong(const QString&, const QString&, unsigned long long&)
    {46, 3351, 0, 0, Smoke::mf_dtor, 0, 12 },	//1079 KCoreConfigSkeleton::ItemULongLong::~ItemULongLong()
    {47, 263, 973, 4, Smoke::mf_ctor, 80, 1},	//1080 KCoreConfigSkeleton::ItemUrl::ItemUrl(const QString&, const QString&, KUrl&, const KUrl&)
    {47, 3288, 595, 1, 0, 0, 2},	//1081 KCoreConfigSkeleton::ItemUrl::writeConfig(KConfig*)
    {47, 2334, 595, 1, 0, 0, 3},	//1082 KCoreConfigSkeleton::ItemUrl::readConfig(KConfig*)
    {47, 2843, 34, 1, 0, 0, 4},	//1083 KCoreConfigSkeleton::ItemUrl::setProperty(const QVariant&)
    {47, 1810, 34, 1, Smoke::mf_const, 450, 5},	//1084 KCoreConfigSkeleton::ItemUrl::isEqual(const QVariant&) const
    {47, 2277, 0, 0, Smoke::mf_const, 364, 6},	//1085 KCoreConfigSkeleton::ItemUrl::property() const
    {47, 263, 978, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 80, 7},	//1086 KCoreConfigSkeleton::ItemUrl::ItemUrl(const KCoreConfigSkeleton::ItemUrl&)
    {47, 263, 980, 3, Smoke::mf_ctor, 80, 8},	//1087 KCoreConfigSkeleton::ItemUrl::ItemUrl(const QString&, const QString&, KUrl&)
    {47, 3352, 0, 0, Smoke::mf_dtor, 0, 9 },	//1088 KCoreConfigSkeleton::ItemUrl::~ItemUrl()
    {48, 267, 984, 4, Smoke::mf_ctor, 81, 1},	//1089 KCoreConfigSkeleton::ItemUrlList::ItemUrlList(const QString&, const QString&, KUrl::List&, const KUrl::List&)
    {48, 2334, 595, 1, 0, 0, 2},	//1090 KCoreConfigSkeleton::ItemUrlList::readConfig(KConfig*)
    {48, 3288, 595, 1, 0, 0, 3},	//1091 KCoreConfigSkeleton::ItemUrlList::writeConfig(KConfig*)
    {48, 2843, 34, 1, 0, 0, 4},	//1092 KCoreConfigSkeleton::ItemUrlList::setProperty(const QVariant&)
    {48, 1810, 34, 1, Smoke::mf_const, 450, 5},	//1093 KCoreConfigSkeleton::ItemUrlList::isEqual(const QVariant&) const
    {48, 2277, 0, 0, Smoke::mf_const, 364, 6},	//1094 KCoreConfigSkeleton::ItemUrlList::property() const
    {48, 267, 989, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 81, 7},	//1095 KCoreConfigSkeleton::ItemUrlList::ItemUrlList(const KCoreConfigSkeleton::ItemUrlList&)
    {48, 267, 991, 3, Smoke::mf_ctor, 81, 8},	//1096 KCoreConfigSkeleton::ItemUrlList::ItemUrlList(const QString&, const QString&, KUrl::List&)
    {48, 3353, 0, 0, Smoke::mf_dtor, 0, 9 },	//1097 KCoreConfigSkeleton::ItemUrlList::~ItemUrlList()
    {49, 346, 95, 2, Smoke::mf_ctor, 83, 1},	//1098 KCurrencyCode::KCurrencyCode(const QString&, const QString&)
    {49, 346, 995, 2, Smoke::mf_ctor, 83, 2},	//1099 KCurrencyCode::KCurrencyCode(const QFileInfo&, const QString&)
    {49, 346, 998, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 83, 3},	//1100 KCurrencyCode::KCurrencyCode(const KCurrencyCode&)
    {49, 2182, 998, 1, 0, 82, 4},	//1101 KCurrencyCode::operator=(const KCurrencyCode&)
    {49, 1879, 0, 0, Smoke::mf_const, 351, 5},	//1102 KCurrencyCode::isoCurrencyCode() const
    {49, 1880, 0, 0, Smoke::mf_const, 351, 6},	//1103 KCurrencyCode::isoCurrencyCodeNumeric() const
    {49, 2102, 0, 0, Smoke::mf_const, 351, 7},	//1104 KCurrencyCode::name() const
    {49, 1881, 0, 0, Smoke::mf_const, 351, 8},	//1105 KCurrencyCode::isoName() const
    {49, 3033, 0, 0, Smoke::mf_const, 84, 9},	//1106 KCurrencyCode::status() const
    {49, 1258, 0, 0, Smoke::mf_const, 276, 10},	//1107 KCurrencyCode::dateIntroduced() const
    {49, 1260, 0, 0, Smoke::mf_const, 276, 11},	//1108 KCurrencyCode::dateSuspended() const
    {49, 1265, 0, 0, Smoke::mf_const, 276, 12},	//1109 KCurrencyCode::dateWithdrawn() const
    {49, 3068, 0, 0, Smoke::mf_const, 354, 13},	//1110 KCurrencyCode::symbolList() const
    {49, 1329, 0, 0, Smoke::mf_const, 351, 14},	//1111 KCurrencyCode::defaultSymbol() const
    {49, 3178, 0, 0, Smoke::mf_const, 351, 15},	//1112 KCurrencyCode::unambiguousSymbol() const
    {49, 1698, 0, 0, Smoke::mf_const, 450, 16},	//1113 KCurrencyCode::hasSubunits() const
    {49, 1699, 0, 0, Smoke::mf_const, 450, 17},	//1114 KCurrencyCode::hasSubunitsInCirculation() const
    {49, 3057, 0, 0, Smoke::mf_const, 351, 18},	//1115 KCurrencyCode::subunitSymbol() const
    {49, 3058, 0, 0, Smoke::mf_const, 614, 19},	//1116 KCurrencyCode::subunitsPerUnit() const
    {49, 1306, 0, 0, Smoke::mf_const, 614, 20},	//1117 KCurrencyCode::decimalPlaces() const
    {49, 1199, 0, 0, Smoke::mf_const, 354, 21},	//1118 KCurrencyCode::countriesUsingCurrency() const
    {49, 1871, 0, 0, Smoke::mf_const, 450, 22},	//1119 KCurrencyCode::isValid() const
    {49, 1871, 1000, 2, Smoke::mf_static, 450, 23},	//1120 KCurrencyCode::isValid(const QString&, QFlags<KCurrencyCode::CurrencyStatus>)
    {49, 1005, 1003, 1, Smoke::mf_static, 354, 24},	//1121 KCurrencyCode::allCurrencyCodesList(QFlags<KCurrencyCode::CurrencyStatus>)
    {49, 1226, 95, 2, Smoke::mf_static, 351, 25},	//1122 KCurrencyCode::currencyCodeToName(const QString&, const QString&)
    {49, 346, 30, 1, Smoke::mf_ctor, 83, 26},	//1123 KCurrencyCode::KCurrencyCode(const QString&)
    {49, 346, 1005, 1, Smoke::mf_ctor, 83, 27},	//1124 KCurrencyCode::KCurrencyCode(const QFileInfo&)
    {49, 1871, 30, 1, Smoke::mf_static, 450, 28},	//1125 KCurrencyCode::isValid(const QString&)
    {49, 1005, 0, 0, Smoke::mf_static, 354, 29},	//1126 KCurrencyCode::allCurrencyCodesList()
    {49, 1226, 30, 1, Smoke::mf_static, 351, 30},	//1127 KCurrencyCode::currencyCodeToName(const QString&)
    {49, 11, 0, 0, Smoke::mf_static|Smoke::mf_enum, 84, 31},	//1128 KCurrencyCode::ActiveCurrency (enum)
    {49, 743, 0, 0, Smoke::mf_static|Smoke::mf_enum, 84, 32},	//1129 KCurrencyCode::SuspendedCurrency (enum)
    {49, 642, 0, 0, Smoke::mf_static|Smoke::mf_enum, 84, 33},	//1130 KCurrencyCode::ObsoleteCurrency (enum)
    {49, 3371, 0, 0, Smoke::mf_dtor, 0, 34 },	//1131 KCurrencyCode::~KCurrencyCode()
    {50, 1569, 524, 2, Smoke::mf_static, 2, 1},	//1132 KDE::fopen(const QString&, const char*)
    {50, 3236, 0, 0, Smoke::mf_static, 632, 2},	//1133 KDE::versionMinor()
    {50, 3238, 0, 0, Smoke::mf_static, 598, 3},	//1134 KDE::versionString()
    {50, 1138, 1007, 2, Smoke::mf_static, 614, 4},	//1135 KDE::chmod(const QString&, mode_t)
    {50, 2426, 95, 2, Smoke::mf_static, 614, 5},	//1136 KDE::rename(const QString&, const QString&)
    {50, 3237, 0, 0, Smoke::mf_static, 632, 6},	//1137 KDE::versionRelease()
    {50, 3234, 0, 0, Smoke::mf_static, 632, 7},	//1138 KDE::version()
    {50, 2145, 1010, 3, Smoke::mf_static, 614, 8},	//1139 KDE::open(const QString&, int, mode_t)
    {50, 2145, 1014, 2, Smoke::mf_static, 614, 9},	//1140 KDE::open(const QString&, int)
    {50, 831, 1014, 2, Smoke::mf_static, 614, 10},	//1141 KDE::access(const QString&, int)
    {50, 2068, 1007, 2, Smoke::mf_static, 614, 11},	//1142 KDE::mkdir(const QString&, mode_t)
    {50, 3235, 0, 0, Smoke::mf_static, 632, 12},	//1143 KDE::versionMajor()
    {51, 2060, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 582, 1},	//1144 KDEDModule::metaObject() const
    {51, 2301, 122, 1, Smoke::mf_virtual, 639, 2},	//1145 KDEDModule::qt_metacast(const char*)
    {51, 3131, 124, 2, Smoke::mf_static, 351, 3},	//1146 KDEDModule::tr(const char*, const char*)
    {51, 3138, 124, 2, Smoke::mf_static, 351, 4},	//1147 KDEDModule::trUtf8(const char*, const char*)
    {51, 3131, 127, 3, Smoke::mf_static, 351, 5},	//1148 KDEDModule::tr(const char*, const char*, int)
    {51, 3138, 127, 3, Smoke::mf_static, 351, 6},	//1149 KDEDModule::trUtf8(const char*, const char*, int)
    {51, 2299, 131, 3, Smoke::mf_virtual, 614, 7},	//1150 KDEDModule::qt_metacall(QMetaObject::Call, int, void**)
    {51, 351, 146, 1, Smoke::mf_ctor, 85, 8},	//1151 KDEDModule::KDEDModule(QObject*)
    {51, 2772, 30, 1, 0, 0, 9},	//1152 KDEDModule::setModuleName(const QString&)
    {51, 2075, 0, 0, Smoke::mf_const, 351, 10},	//1153 KDEDModule::moduleName() const
    {51, 2073, 1017, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 11},	//1154 KDEDModule::moduleDeleted(KDEDModule*)
    {51, 3282, 1019, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 12},	//1155 KDEDModule::windowRegistered(qlonglong)
    {51, 3284, 1019, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 13},	//1156 KDEDModule::windowUnregistered(qlonglong)
    {51, 2076, 1021, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 14},	//1157 KDEDModule::moduleRegistered(const QDBusObjectPath&)
    {51, 3131, 122, 1, Smoke::mf_static, 351, 15},	//1158 KDEDModule::tr(const char*)
    {51, 3138, 122, 1, Smoke::mf_static, 351, 16},	//1159 KDEDModule::trUtf8(const char*)
    {51, 351, 0, 0, Smoke::mf_ctor, 85, 17},	//1160 KDEDModule::KDEDModule()
    {51, 3030, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 581, 18},	//1161 KDEDModule::staticMetaObject() const
    {51, 3372, 0, 0, Smoke::mf_dtor, 0, 19 },	//1162 KDEDModule::~KDEDModule()
    {52, 353, 0, 0, Smoke::mf_ctor, 86, 1},	//1163 KDEPluginVerificationData::KDEPluginVerificationData()
    {52, 353, 1023, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 86, 2},	//1164 KDEPluginVerificationData::KDEPluginVerificationData(const KDEPluginVerificationData&)
    {52, 1247, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 630, 3},	//1165 KDEPluginVerificationData::dataVersion() const
    {52, 2569, 1025, 1, Smoke::mf_attribute, 0, 4},	//1166 KDEPluginVerificationData::setDataVersion(unsigned char)
    {52, 355, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 632, 5},	//1167 KDEPluginVerificationData::KDEVersion() const
    {52, 2666, 952, 1, Smoke::mf_attribute, 0, 6},	//1168 KDEPluginVerificationData::setKDEVersion(unsigned int)
    {52, 356, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 598, 7},	//1169 KDEPluginVerificationData::KDEVersionString() const
    {52, 2668, 122, 1, Smoke::mf_attribute, 0, 8},	//1170 KDEPluginVerificationData::setKDEVersionString(const char*)
    {52, 667, 0, 0, Smoke::mf_static|Smoke::mf_enum, 618, 9},	//1171 KDEPluginVerificationData::PluginVerificationDataVersion (enum)
    {52, 3373, 0, 0, Smoke::mf_dtor, 0, 10 },	//1172 KDEPluginVerificationData::~KDEPluginVerificationData()
    {53, 357, 0, 0, Smoke::mf_ctor, 89, 1},	//1173 KDateTime::KDateTime()
    {53, 357, 1027, 2, Smoke::mf_ctor, 89, 2},	//1174 KDateTime::KDateTime(const QDate&, const KDateTime::Spec&)
    {53, 357, 1030, 3, Smoke::mf_ctor, 89, 3},	//1175 KDateTime::KDateTime(const QDate&, const QTime&, const KDateTime::Spec&)
    {53, 357, 1034, 2, Smoke::mf_ctor, 89, 4},	//1176 KDateTime::KDateTime(const QDateTime&, const KDateTime::Spec&)
    {53, 357, 1037, 1, Smoke::mf_ctor, 89, 5},	//1177 KDateTime::KDateTime(const QDateTime&)
    {53, 357, 1039, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 89, 6},	//1178 KDateTime::KDateTime(const KDateTime&)
    {53, 2182, 1039, 1, 0, 88, 7},	//1179 KDateTime::operator=(const KDateTime&)
    {53, 1841, 0, 0, Smoke::mf_const, 450, 8},	//1180 KDateTime::isNull() const
    {53, 1871, 0, 0, Smoke::mf_const, 450, 9},	//1181 KDateTime::isValid() const
    {53, 1794, 0, 0, Smoke::mf_const, 450, 10},	//1182 KDateTime::isDateOnly() const
    {53, 1253, 0, 0, Smoke::mf_const, 276, 11},	//1183 KDateTime::date() const
    {53, 3095, 0, 0, Smoke::mf_const, 361, 12},	//1184 KDateTime::time() const
    {53, 1261, 0, 0, Smoke::mf_const, 278, 13},	//1185 KDateTime::dateTime() const
    {53, 3100, 0, 0, Smoke::mf_const, 217, 14},	//1186 KDateTime::timeZone() const
    {53, 3097, 0, 0, Smoke::mf_const, 91, 15},	//1187 KDateTime::timeSpec() const
    {53, 3099, 0, 0, Smoke::mf_const, 94, 16},	//1188 KDateTime::timeType() const
    {53, 1835, 0, 0, Smoke::mf_const, 450, 17},	//1189 KDateTime::isLocalZone() const
    {53, 1789, 0, 0, Smoke::mf_const, 450, 18},	//1190 KDateTime::isClockTime() const
    {53, 1868, 0, 0, Smoke::mf_const, 450, 19},	//1191 KDateTime::isUtc() const
    {53, 1842, 0, 0, Smoke::mf_const, 450, 20},	//1192 KDateTime::isOffsetFromUtc() const
    {53, 3221, 0, 0, Smoke::mf_const, 614, 21},	//1193 KDateTime::utcOffset() const
    {53, 1853, 0, 0, Smoke::mf_const, 450, 22},	//1194 KDateTime::isSecondOccurrence() const
    {53, 3120, 0, 0, Smoke::mf_const, 87, 23},	//1195 KDateTime::toUtc() const
    {53, 3110, 0, 0, Smoke::mf_const, 87, 24},	//1196 KDateTime::toOffsetFromUtc() const
    {53, 3110, 118, 1, Smoke::mf_const, 87, 25},	//1197 KDateTime::toOffsetFromUtc(int) const
    {53, 3108, 0, 0, Smoke::mf_const, 87, 26},	//1198 KDateTime::toLocalZone() const
    {53, 3103, 0, 0, Smoke::mf_const, 87, 27},	//1199 KDateTime::toClockTime() const
    {53, 3122, 1041, 1, Smoke::mf_const, 87, 28},	//1200 KDateTime::toZone(const KTimeZone&) const
    {53, 3116, 1043, 1, Smoke::mf_const, 87, 29},	//1201 KDateTime::toTimeSpec(const KDateTime::Spec&) const
    {53, 3116, 1039, 1, Smoke::mf_const, 87, 30},	//1202 KDateTime::toTimeSpec(const KDateTime&) const
    {53, 3118, 0, 0, Smoke::mf_const, 632, 31},	//1203 KDateTime::toTime_t() const
    {53, 2894, 861, 1, 0, 0, 32},	//1204 KDateTime::setTime_t(long long)
    {53, 2584, 103, 1, 0, 0, 33},	//1205 KDateTime::setDateOnly(bool)
    {53, 2571, 196, 1, 0, 0, 34},	//1206 KDateTime::setDate(const QDate&)
    {53, 2888, 1045, 1, 0, 0, 35},	//1207 KDateTime::setTime(const QTime&)
    {53, 2586, 1037, 1, 0, 0, 36},	//1208 KDateTime::setDateTime(const QDateTime&)
    {53, 2892, 1043, 1, 0, 0, 37},	//1209 KDateTime::setTimeSpec(const KDateTime::Spec&)
    {53, 2853, 103, 1, 0, 0, 38},	//1210 KDateTime::setSecondOccurrence(bool)
    {53, 959, 861, 1, Smoke::mf_const, 87, 39},	//1211 KDateTime::addMSecs(long long) const
    {53, 977, 861, 1, Smoke::mf_const, 87, 40},	//1212 KDateTime::addSecs(long long) const
    {53, 871, 118, 1, Smoke::mf_const, 87, 41},	//1213 KDateTime::addDays(int) const
    {53, 961, 118, 1, Smoke::mf_const, 87, 42},	//1214 KDateTime::addMonths(int) const
    {53, 998, 118, 1, Smoke::mf_const, 87, 43},	//1215 KDateTime::addYears(int) const
    {53, 2470, 1039, 1, Smoke::mf_const, 614, 44},	//1216 KDateTime::secsTo(const KDateTime&) const
    {53, 2472, 1039, 1, Smoke::mf_const, 619, 45},	//1217 KDateTime::secsTo_long(const KDateTime&) const
    {53, 1303, 1039, 1, Smoke::mf_const, 614, 46},	//1218 KDateTime::daysTo(const KDateTime&) const
    {53, 1235, 0, 0, Smoke::mf_static, 87, 47},	//1219 KDateTime::currentLocalDateTime()
    {53, 1239, 0, 0, Smoke::mf_static, 87, 48},	//1220 KDateTime::currentUtcDateTime()
    {53, 1231, 1043, 1, Smoke::mf_static, 87, 49},	//1221 KDateTime::currentDateTime(const KDateTime::Spec&)
    {53, 1234, 0, 0, Smoke::mf_static, 276, 50},	//1222 KDateTime::currentLocalDate()
    {53, 1236, 0, 0, Smoke::mf_static, 361, 51},	//1223 KDateTime::currentLocalTime()
    {53, 3112, 30, 1, Smoke::mf_const, 351, 52},	//1224 KDateTime::toString(const QString&) const
    {53, 3112, 1047, 1, Smoke::mf_const, 351, 53},	//1225 KDateTime::toString(KDateTime::TimeFormat) const
    {53, 1626, 1049, 3, Smoke::mf_static, 87, 54},	//1226 KDateTime::fromString(const QString&, KDateTime::TimeFormat, bool*)
    {53, 1626, 1053, 4, Smoke::mf_static, 87, 55},	//1227 KDateTime::fromString(const QString&, const QString&, const KTimeZones*, bool)
    {53, 2648, 1043, 1, Smoke::mf_static, 0, 56},	//1228 KDateTime::setFromStringDefault(const KDateTime::Spec&)
    {53, 2209, 0, 0, Smoke::mf_const, 450, 57},	//1229 KDateTime::outOfRange() const
    {53, 1161, 1039, 1, Smoke::mf_const, 90, 58},	//1230 KDateTime::compare(const KDateTime&) const
    {53, 2185, 1039, 1, Smoke::mf_const, 450, 59},	//1231 KDateTime::operator==(const KDateTime&) const
    {53, 2158, 1039, 1, Smoke::mf_const, 450, 60},	//1232 KDateTime::operator!=(const KDateTime&) const
    {53, 2168, 1039, 1, Smoke::mf_const, 450, 61},	//1233 KDateTime::operator<(const KDateTime&) const
    {53, 2177, 1039, 1, Smoke::mf_const, 450, 62},	//1234 KDateTime::operator<=(const KDateTime&) const
    {53, 2191, 1039, 1, Smoke::mf_const, 450, 63},	//1235 KDateTime::operator>(const KDateTime&) const
    {53, 2196, 1039, 1, Smoke::mf_const, 450, 64},	//1236 KDateTime::operator>=(const KDateTime&) const
    {53, 1356, 0, 0, 0, 0, 65},	//1237 KDateTime::detach()
    {53, 2869, 1039, 1, Smoke::mf_static, 0, 66},	//1238 KDateTime::setSimulatedSystemTime(const KDateTime&)
    {53, 2390, 0, 0, Smoke::mf_static, 87, 67},	//1239 KDateTime::realCurrentLocalDateTime()
    {53, 357, 196, 1, Smoke::mf_ctor, 89, 68},	//1240 KDateTime::KDateTime(const QDate&)
    {53, 357, 1058, 2, Smoke::mf_ctor, 89, 69},	//1241 KDateTime::KDateTime(const QDate&, const QTime&)
    {53, 3112, 0, 0, Smoke::mf_const, 351, 70},	//1242 KDateTime::toString() const
    {53, 1626, 30, 1, Smoke::mf_static, 87, 71},	//1243 KDateTime::fromString(const QString&)
    {53, 1626, 1061, 2, Smoke::mf_static, 87, 72},	//1244 KDateTime::fromString(const QString&, KDateTime::TimeFormat)
    {53, 1626, 95, 2, Smoke::mf_static, 87, 73},	//1245 KDateTime::fromString(const QString&, const QString&)
    {53, 1626, 1064, 3, Smoke::mf_static, 87, 74},	//1246 KDateTime::fromString(const QString&, const QString&, const KTimeZones*)
    {53, 177, 0, 0, Smoke::mf_static|Smoke::mf_enum, 94, 75},	//1247 KDateTime::Invalid (enum)
    {53, 772, 0, 0, Smoke::mf_static|Smoke::mf_enum, 94, 76},	//1248 KDateTime::UTC (enum)
    {53, 643, 0, 0, Smoke::mf_static|Smoke::mf_enum, 94, 77},	//1249 KDateTime::OffsetFromUTC (enum)
    {53, 762, 0, 0, Smoke::mf_static|Smoke::mf_enum, 94, 78},	//1250 KDateTime::TimeZone (enum)
    {53, 588, 0, 0, Smoke::mf_static|Smoke::mf_enum, 94, 79},	//1251 KDateTime::LocalZone (enum)
    {53, 60, 0, 0, Smoke::mf_static|Smoke::mf_enum, 94, 80},	//1252 KDateTime::ClockTime (enum)
    {53, 169, 0, 0, Smoke::mf_static|Smoke::mf_enum, 95, 81},	//1253 KDateTime::ISODate (enum)
    {53, 683, 0, 0, Smoke::mf_static|Smoke::mf_enum, 95, 82},	//1254 KDateTime::RFCDate (enum)
    {53, 684, 0, 0, Smoke::mf_static|Smoke::mf_enum, 95, 83},	//1255 KDateTime::RFCDateDay (enum)
    {53, 680, 0, 0, Smoke::mf_static|Smoke::mf_enum, 95, 84},	//1256 KDateTime::QtTextDate (enum)
    {53, 587, 0, 0, Smoke::mf_static|Smoke::mf_enum, 95, 85},	//1257 KDateTime::LocalDate (enum)
    {53, 682, 0, 0, Smoke::mf_static|Smoke::mf_enum, 95, 86},	//1258 KDateTime::RFC3339Date (enum)
    {53, 41, 0, 0, Smoke::mf_static|Smoke::mf_enum, 90, 87},	//1259 KDateTime::Before (enum)
    {53, 26, 0, 0, Smoke::mf_static|Smoke::mf_enum, 90, 88},	//1260 KDateTime::AtStart (enum)
    {53, 176, 0, 0, Smoke::mf_static|Smoke::mf_enum, 90, 89},	//1261 KDateTime::Inside (enum)
    {53, 25, 0, 0, Smoke::mf_static|Smoke::mf_enum, 90, 90},	//1262 KDateTime::AtEnd (enum)
    {53, 14, 0, 0, Smoke::mf_static|Smoke::mf_enum, 90, 91},	//1263 KDateTime::After (enum)
    {53, 117, 0, 0, Smoke::mf_static|Smoke::mf_enum, 90, 92},	//1264 KDateTime::Equal (enum)
    {53, 654, 0, 0, Smoke::mf_static|Smoke::mf_enum, 90, 93},	//1265 KDateTime::Outside (enum)
    {53, 738, 0, 0, Smoke::mf_static|Smoke::mf_enum, 90, 94},	//1266 KDateTime::StartsAt (enum)
    {53, 116, 0, 0, Smoke::mf_static|Smoke::mf_enum, 90, 95},	//1267 KDateTime::EndsAt (enum)
    {53, 3374, 0, 0, Smoke::mf_dtor, 0, 96 },	//1268 KDateTime::~KDateTime()
    {54, 727, 0, 0, Smoke::mf_ctor, 93, 1},	//1269 KDateTime::Spec::Spec()
    {54, 727, 1041, 1, Smoke::mf_ctor, 93, 2},	//1270 KDateTime::Spec::Spec(const KTimeZone&)
    {54, 727, 1068, 2, Smoke::mf_ctor, 93, 3},	//1271 KDateTime::Spec::Spec(KDateTime::SpecType, int)
    {54, 727, 1043, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 93, 4},	//1272 KDateTime::Spec::Spec(const KDateTime::Spec&)
    {54, 2182, 1043, 1, 0, 92, 5},	//1273 KDateTime::Spec::operator=(const KDateTime::Spec&)
    {54, 1871, 0, 0, Smoke::mf_const, 450, 6},	//1274 KDateTime::Spec::isValid() const
    {54, 3100, 0, 0, Smoke::mf_const, 217, 7},	//1275 KDateTime::Spec::timeZone() const
    {54, 3174, 0, 0, Smoke::mf_const, 94, 8},	//1276 KDateTime::Spec::type() const
    {54, 1835, 0, 0, Smoke::mf_const, 450, 9},	//1277 KDateTime::Spec::isLocalZone() const
    {54, 1789, 0, 0, Smoke::mf_const, 450, 10},	//1278 KDateTime::Spec::isClockTime() const
    {54, 1868, 0, 0, Smoke::mf_const, 450, 11},	//1279 KDateTime::Spec::isUtc() const
    {54, 1842, 0, 0, Smoke::mf_const, 450, 12},	//1280 KDateTime::Spec::isOffsetFromUtc() const
    {54, 3221, 0, 0, Smoke::mf_const, 614, 13},	//1281 KDateTime::Spec::utcOffset() const
    {54, 2904, 1068, 2, 0, 0, 14},	//1282 KDateTime::Spec::setType(KDateTime::SpecType, int)
    {54, 2904, 1041, 1, 0, 0, 15},	//1283 KDateTime::Spec::setType(const KTimeZone&)
    {54, 2185, 1043, 1, Smoke::mf_const, 450, 16},	//1284 KDateTime::Spec::operator==(const KDateTime::Spec&) const
    {54, 2158, 1043, 1, Smoke::mf_const, 450, 17},	//1285 KDateTime::Spec::operator!=(const KDateTime::Spec&) const
    {54, 1426, 1043, 1, Smoke::mf_const, 450, 18},	//1286 KDateTime::Spec::equivalentTo(const KDateTime::Spec&) const
    {54, 772, 0, 0, Smoke::mf_static, 91, 19},	//1287 KDateTime::Spec::UTC()
    {54, 60, 0, 0, Smoke::mf_static, 91, 20},	//1288 KDateTime::Spec::ClockTime()
    {54, 643, 118, 1, Smoke::mf_static, 91, 21},	//1289 KDateTime::Spec::OffsetFromUTC(int)
    {54, 588, 0, 0, Smoke::mf_static, 91, 22},	//1290 KDateTime::Spec::LocalZone()
    {54, 727, 1071, 1, Smoke::mf_ctor, 93, 23},	//1291 KDateTime::Spec::Spec(KDateTime::SpecType)
    {54, 2904, 1071, 1, 0, 0, 24},	//1292 KDateTime::Spec::setType(KDateTime::SpecType)
    {54, 3434, 0, 0, Smoke::mf_dtor, 0, 25 },	//1293 KDateTime::Spec::~Spec()
    {55, 361, 1073, 4, Smoke::mf_ctor|Smoke::mf_explicit, 96, 1},	//1294 KDebug::KDebug(QtMsgType, const char*, int, const char*)
    {55, 1685, 1078, 4, Smoke::mf_static, 450, 2},	//1295 KDebug::hasNullOutput(QtMsgType, bool, int, bool)
    {55, 1687, 118, 1, Smoke::mf_static, 450, 3},	//1296 KDebug::hasNullOutputQtDebugMsg(int)
    {55, 1687, 1083, 2, Smoke::mf_static, 450, 4},	//1297 KDebug::hasNullOutputQtDebugMsg(bool, int)
    {55, 2397, 423, 2, Smoke::mf_static, 614, 5},	//1298 KDebug::registerArea(const QByteArray&, bool)
    {55, 361, 1086, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 96, 6},	//1299 KDebug::KDebug(const KDebug&)
    {55, 361, 1088, 1, Smoke::mf_ctor|Smoke::mf_explicit, 96, 7},	//1300 KDebug::KDebug(QtMsgType)
    {55, 361, 1090, 2, Smoke::mf_ctor|Smoke::mf_explicit, 96, 8},	//1301 KDebug::KDebug(QtMsgType, const char*)
    {55, 361, 1093, 3, Smoke::mf_ctor|Smoke::mf_explicit, 96, 9},	//1302 KDebug::KDebug(QtMsgType, const char*, int)
    {55, 1687, 0, 0, Smoke::mf_static, 450, 10},	//1303 KDebug::hasNullOutputQtDebugMsg()
    {55, 1687, 103, 1, Smoke::mf_static, 450, 11},	//1304 KDebug::hasNullOutputQtDebugMsg(bool)
    {55, 2397, 32, 1, Smoke::mf_static, 614, 12},	//1305 KDebug::registerArea(const QByteArray&)
    {55, 3375, 0, 0, Smoke::mf_dtor, 0, 13 },	//1306 KDebug::~KDebug()
    {56, 367, 0, 0, Smoke::mf_ctor, 97, 1},	//1307 KDebugTag::KDebugTag()
    {56, 367, 1097, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 97, 2},	//1308 KDebugTag::KDebugTag(const KDebugTag&)
    {56, 3376, 0, 0, Smoke::mf_dtor, 0, 3 },	//1309 KDebugTag::~KDebugTag()
    {57, 369, 521, 2, Smoke::mf_ctor, 98, 1},	//1310 KDesktopFile::KDesktopFile(const char*, const QString&)
    {57, 369, 30, 1, Smoke::mf_ctor, 98, 2},	//1311 KDesktopFile::KDesktopFile(const QString&)
    {57, 1798, 30, 1, Smoke::mf_static, 450, 3},	//1312 KDesktopFile::isDesktopFile(const QString&)
    {57, 1776, 30, 1, Smoke::mf_static, 450, 4},	//1313 KDesktopFile::isAuthorizedDesktopFile(const QString&)
    {57, 1996, 30, 1, Smoke::mf_static, 351, 5},	//1314 KDesktopFile::locateLocal(const QString&)
    {57, 1355, 0, 0, Smoke::mf_const, 51, 6},	//1315 KDesktopFile::desktopGroup() const
    {57, 2383, 0, 0, Smoke::mf_const, 351, 7},	//1316 KDesktopFile::readType() const
    {57, 2359, 0, 0, Smoke::mf_const, 351, 8},	//1317 KDesktopFile::readIcon() const
    {57, 2371, 0, 0, Smoke::mf_const, 351, 9},	//1318 KDesktopFile::readName() const
    {57, 2333, 0, 0, Smoke::mf_const, 351, 10},	//1319 KDesktopFile::readComment() const
    {57, 2357, 0, 0, Smoke::mf_const, 351, 11},	//1320 KDesktopFile::readGenericName() const
    {57, 2375, 0, 0, Smoke::mf_const, 351, 12},	//1321 KDesktopFile::readPath() const
    {57, 2346, 0, 0, Smoke::mf_const, 351, 13},	//1322 KDesktopFile::readDevice() const
    {57, 2384, 0, 0, Smoke::mf_const, 351, 14},	//1323 KDesktopFile::readUrl() const
    {57, 2332, 0, 0, Smoke::mf_const, 354, 15},	//1324 KDesktopFile::readActions() const
    {57, 835, 30, 1, 0, 51, 16},	//1325 KDesktopFile::actionGroup(const QString&)
    {57, 835, 30, 1, Smoke::mf_const, 471, 17},	//1326 KDesktopFile::actionGroup(const QString&) const
    {57, 1660, 30, 1, Smoke::mf_const, 450, 18},	//1327 KDesktopFile::hasActionGroup(const QString&) const
    {57, 1678, 0, 0, Smoke::mf_const, 450, 19},	//1328 KDesktopFile::hasLinkType() const
    {57, 1662, 0, 0, Smoke::mf_const, 450, 20},	//1329 KDesktopFile::hasApplicationType() const
    {57, 1684, 0, 0, Smoke::mf_const, 450, 21},	//1330 KDesktopFile::hasMimeTypeType() const
    {57, 1667, 0, 0, Smoke::mf_const, 450, 22},	//1331 KDesktopFile::hasDeviceType() const
    {57, 3173, 0, 0, Smoke::mf_const, 450, 23},	//1332 KDesktopFile::tryExec() const
    {57, 2347, 0, 0, Smoke::mf_const, 351, 24},	//1333 KDesktopFile::readDocPath() const
    {57, 2954, 0, 0, Smoke::mf_const, 354, 25},	//1334 KDesktopFile::sortOrder() const
    {57, 2120, 0, 0, Smoke::mf_const, 450, 26},	//1335 KDesktopFile::noDisplay() const
    {57, 1192, 30, 1, Smoke::mf_const, 98, 27},	//1336 KDesktopFile::copyTo(const QString&) const
    {57, 1498, 0, 0, Smoke::mf_const, 351, 28},	//1337 KDesktopFile::fileName() const
    {57, 2446, 0, 0, Smoke::mf_const, 598, 29},	//1338 KDesktopFile::resource() const
    {57, 3377, 0, 0, Smoke::mf_dtor, 0, 30 },	//1339 KDesktopFile::~KDesktopFile()
    {58, 372, 0, 0, Smoke::mf_ctor, 99, 1},	//1340 KEncodingDetector::KEncodingDetector()
    {58, 372, 1099, 3, Smoke::mf_ctor, 99, 2},	//1341 KEncodingDetector::KEncodingDetector(QTextCodec*, KEncodingDetector::EncodingChoiceSource, KEncodingDetector::AutoDetectScript)
    {58, 2615, 1103, 2, 0, 450, 3},	//1342 KEncodingDetector::setEncoding(const char*, KEncodingDetector::EncodingChoiceSource)
    {58, 1406, 0, 0, Smoke::mf_const, 598, 4},	//1343 KEncodingDetector::encoding() const
    {58, 3240, 0, 0, Smoke::mf_const, 450, 5},	//1344 KEncodingDetector::visuallyOrdered() const
    {58, 2517, 1106, 1, 0, 0, 6},	//1345 KEncodingDetector::setAutoDetectLanguage(KEncodingDetector::AutoDetectScript)
    {58, 1051, 0, 0, Smoke::mf_const, 100, 7},	//1346 KEncodingDetector::autoDetectLanguage() const
    {58, 1407, 0, 0, Smoke::mf_const, 101, 8},	//1347 KEncodingDetector::encodingChoiceSource() const
    {58, 1308, 1108, 2, 0, 351, 9},	//1348 KEncodingDetector::decode(const char*, int)
    {58, 1308, 32, 1, 0, 351, 10},	//1349 KEncodingDetector::decode(const QByteArray&)
    {58, 1313, 1108, 2, 0, 351, 11},	//1350 KEncodingDetector::decodeWithBuffering(const char*, int)
    {58, 1317, 0, 0, Smoke::mf_const, 450, 12},	//1351 KEncodingDetector::decodedInvalidCharacters() const
    {58, 2439, 0, 0, 0, 0, 13},	//1352 KEncodingDetector::resetDecoder()
    {58, 1568, 0, 0, 0, 351, 14},	//1353 KEncodingDetector::flush()
    {58, 2468, 30, 1, Smoke::mf_static, 100, 15},	//1354 KEncodingDetector::scriptForName(const QString&)
    {58, 2106, 1106, 1, Smoke::mf_static, 351, 16},	//1355 KEncodingDetector::nameForScript(KEncodingDetector::AutoDetectScript)
    {58, 1663, 1106, 1, Smoke::mf_static, 450, 17},	//1356 KEncodingDetector::hasAutoDetectionForScript(KEncodingDetector::AutoDetectScript)
    {58, 2264, 1111, 2, Smoke::mf_protected, 450, 18},	//1357 KEncodingDetector::processNull(char*, int)
    {58, 1440, 1108, 2, Smoke::mf_protected, 450, 19},	//1358 KEncodingDetector::errorsIfUtf8(const char*, int)
    {58, 1027, 1108, 2, Smoke::mf_protected, 450, 20},	//1359 KEncodingDetector::analyze(const char*, int)
    {58, 1318, 0, 0, Smoke::mf_protected, 360, 21},	//1360 KEncodingDetector::decoder()
    {58, 372, 1114, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 99, 22},	//1361 KEncodingDetector::KEncodingDetector(const KEncodingDetector&)
    {58, 372, 1116, 2, Smoke::mf_ctor, 99, 23},	//1362 KEncodingDetector::KEncodingDetector(QTextCodec*, KEncodingDetector::EncodingChoiceSource)
    {58, 98, 0, 0, Smoke::mf_static|Smoke::mf_enum, 101, 24},	//1363 KEncodingDetector::DefaultEncoding (enum)
    {58, 32, 0, 0, Smoke::mf_static|Smoke::mf_enum, 101, 25},	//1364 KEncodingDetector::AutoDetectedEncoding (enum)
    {58, 34, 0, 0, Smoke::mf_static|Smoke::mf_enum, 101, 26},	//1365 KEncodingDetector::BOM (enum)
    {58, 114, 0, 0, Smoke::mf_static|Smoke::mf_enum, 101, 27},	//1366 KEncodingDetector::EncodingFromXMLHeader (enum)
    {58, 113, 0, 0, Smoke::mf_static|Smoke::mf_enum, 101, 28},	//1367 KEncodingDetector::EncodingFromMetaTag (enum)
    {58, 112, 0, 0, Smoke::mf_static|Smoke::mf_enum, 101, 29},	//1368 KEncodingDetector::EncodingFromHTTPHeader (enum)
    {58, 803, 0, 0, Smoke::mf_static|Smoke::mf_enum, 101, 30},	//1369 KEncodingDetector::UserChosenEncoding (enum)
    {58, 633, 0, 0, Smoke::mf_static|Smoke::mf_enum, 100, 31},	//1370 KEncodingDetector::None (enum)
    {58, 706, 0, 0, Smoke::mf_static|Smoke::mf_enum, 100, 32},	//1371 KEncodingDetector::SemiautomaticDetection (enum)
    {58, 22, 0, 0, Smoke::mf_static|Smoke::mf_enum, 100, 33},	//1372 KEncodingDetector::Arabic (enum)
    {58, 39, 0, 0, Smoke::mf_static|Smoke::mf_enum, 100, 34},	//1373 KEncodingDetector::Baltic (enum)
    {58, 49, 0, 0, Smoke::mf_static|Smoke::mf_enum, 100, 35},	//1374 KEncodingDetector::CentralEuropean (enum)
    {58, 54, 0, 0, Smoke::mf_static|Smoke::mf_enum, 100, 36},	//1375 KEncodingDetector::ChineseSimplified (enum)
    {58, 55, 0, 0, Smoke::mf_static|Smoke::mf_enum, 100, 37},	//1376 KEncodingDetector::ChineseTraditional (enum)
    {58, 75, 0, 0, Smoke::mf_static|Smoke::mf_enum, 100, 38},	//1377 KEncodingDetector::Cyrillic (enum)
    {58, 152, 0, 0, Smoke::mf_static|Smoke::mf_enum, 100, 39},	//1378 KEncodingDetector::Greek (enum)
    {58, 156, 0, 0, Smoke::mf_static|Smoke::mf_enum, 100, 40},	//1379 KEncodingDetector::Hebrew (enum)
    {58, 273, 0, 0, Smoke::mf_static|Smoke::mf_enum, 100, 41},	//1380 KEncodingDetector::Japanese (enum)
    {58, 564, 0, 0, Smoke::mf_static|Smoke::mf_enum, 100, 42},	//1381 KEncodingDetector::Korean (enum)
    {58, 637, 0, 0, Smoke::mf_static|Smoke::mf_enum, 100, 43},	//1382 KEncodingDetector::NorthernSaami (enum)
    {58, 726, 0, 0, Smoke::mf_static|Smoke::mf_enum, 100, 44},	//1383 KEncodingDetector::SouthEasternEurope (enum)
    {58, 752, 0, 0, Smoke::mf_static|Smoke::mf_enum, 100, 45},	//1384 KEncodingDetector::Thai (enum)
    {58, 770, 0, 0, Smoke::mf_static|Smoke::mf_enum, 100, 46},	//1385 KEncodingDetector::Turkish (enum)
    {58, 777, 0, 0, Smoke::mf_static|Smoke::mf_enum, 100, 47},	//1386 KEncodingDetector::Unicode (enum)
    {58, 809, 0, 0, Smoke::mf_static|Smoke::mf_enum, 100, 48},	//1387 KEncodingDetector::WesternEuropean (enum)
    {58, 3378, 0, 0, Smoke::mf_dtor, 0, 49 },	//1388 KEncodingDetector::~KEncodingDetector()
    {59, 376, 1119, 1, Smoke::mf_ctor, 102, 1},	//1389 KEncodingProber::KEncodingProber(KEncodingProber::ProberType)
    {59, 2438, 0, 0, 0, 0, 2},	//1390 KEncodingProber::reset()
    {59, 1491, 32, 1, 0, 103, 3},	//1391 KEncodingProber::feed(const QByteArray&)
    {59, 1491, 1108, 2, 0, 103, 4},	//1392 KEncodingProber::feed(const char*, int)
    {59, 3028, 0, 0, Smoke::mf_const, 103, 5},	//1393 KEncodingProber::state() const
    {59, 1411, 0, 0, Smoke::mf_const, 598, 6},	//1394 KEncodingProber::encodingName() const
    {59, 1406, 0, 0, Smoke::mf_const, 264, 7},	//1395 KEncodingProber::encoding() const
    {59, 1167, 0, 0, Smoke::mf_const, 612, 8},	//1396 KEncodingProber::confidence() const
    {59, 2261, 0, 0, Smoke::mf_const, 104, 9},	//1397 KEncodingProber::proberType() const
    {59, 2827, 1119, 1, 0, 0, 10},	//1398 KEncodingProber::setProberType(KEncodingProber::ProberType)
    {59, 2262, 30, 1, Smoke::mf_static, 104, 11},	//1399 KEncodingProber::proberTypeForName(const QString&)
    {59, 2104, 1119, 1, Smoke::mf_static, 351, 12},	//1400 KEncodingProber::nameForProberType(KEncodingProber::ProberType)
    {59, 376, 1121, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 102, 13},	//1401 KEncodingProber::KEncodingProber(const KEncodingProber&)
    {59, 376, 0, 0, Smoke::mf_ctor, 102, 14},	//1402 KEncodingProber::KEncodingProber()
    {59, 145, 0, 0, Smoke::mf_static|Smoke::mf_enum, 103, 15},	//1403 KEncodingProber::FoundIt (enum)
    {59, 638, 0, 0, Smoke::mf_static|Smoke::mf_enum, 103, 16},	//1404 KEncodingProber::NotMe (enum)
    {59, 670, 0, 0, Smoke::mf_static|Smoke::mf_enum, 103, 17},	//1405 KEncodingProber::Probing (enum)
    {59, 633, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 18},	//1406 KEncodingProber::None (enum)
    {59, 789, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 19},	//1407 KEncodingProber::Universal (enum)
    {59, 22, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 20},	//1408 KEncodingProber::Arabic (enum)
    {59, 39, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 21},	//1409 KEncodingProber::Baltic (enum)
    {59, 49, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 22},	//1410 KEncodingProber::CentralEuropean (enum)
    {59, 54, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 23},	//1411 KEncodingProber::ChineseSimplified (enum)
    {59, 55, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 24},	//1412 KEncodingProber::ChineseTraditional (enum)
    {59, 75, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 25},	//1413 KEncodingProber::Cyrillic (enum)
    {59, 152, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 26},	//1414 KEncodingProber::Greek (enum)
    {59, 156, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 27},	//1415 KEncodingProber::Hebrew (enum)
    {59, 273, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 28},	//1416 KEncodingProber::Japanese (enum)
    {59, 564, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 29},	//1417 KEncodingProber::Korean (enum)
    {59, 637, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 30},	//1418 KEncodingProber::NorthernSaami (enum)
    {59, 653, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 31},	//1419 KEncodingProber::Other (enum)
    {59, 726, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 32},	//1420 KEncodingProber::SouthEasternEurope (enum)
    {59, 752, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 33},	//1421 KEncodingProber::Thai (enum)
    {59, 770, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 34},	//1422 KEncodingProber::Turkish (enum)
    {59, 777, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 35},	//1423 KEncodingProber::Unicode (enum)
    {59, 809, 0, 0, Smoke::mf_static|Smoke::mf_enum, 104, 36},	//1424 KEncodingProber::WesternEuropean (enum)
    {59, 3379, 0, 0, Smoke::mf_dtor, 0, 37 },	//1425 KEncodingProber::~KEncodingProber()
    {60, 379, 0, 0, Smoke::mf_ctor, 105, 1},	//1426 KFilterBase::KFilterBase()
    {60, 2604, 1123, 2, 0, 0, 2},	//1427 KFilterBase::setDevice(QIODevice*, bool)
    {60, 1362, 0, 0, 0, 305, 3},	//1428 KFilterBase::device()
    {60, 1731, 118, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 4},	//1429 KFilterBase::init(int) [pure virtual]
    {60, 2070, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 614, 5},	//1430 KFilterBase::mode() const [pure virtual]
    {60, 3088, 0, 0, Smoke::mf_virtual, 0, 6},	//1431 KFilterBase::terminate()
    {60, 2438, 0, 0, Smoke::mf_virtual, 0, 7},	//1432 KFilterBase::reset()
    {60, 2358, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 450, 8},	//1433 KFilterBase::readHeader() [pure virtual]
    {60, 3299, 32, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 450, 9},	//1434 KFilterBase::writeHeader(const QByteArray&) [pure virtual]
    {60, 2800, 1126, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 10},	//1435 KFilterBase::setOutBuffer(char*, unsigned int) [pure virtual]
    {60, 2660, 1129, 2, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 11},	//1436 KFilterBase::setInBuffer(const char*, unsigned int) [pure virtual]
    {60, 1721, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 450, 12},	//1437 KFilterBase::inBufferEmpty() const
    {60, 1720, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 614, 13},	//1438 KFilterBase::inBufferAvailable() const [pure virtual]
    {60, 2208, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 450, 14},	//1439 KFilterBase::outBufferFull() const
    {60, 2207, 0, 0, Smoke::mf_const|Smoke::mf_virtual|Smoke::mf_purevirtual, 614, 15},	//1440 KFilterBase::outBufferAvailable() const [pure virtual]
    {60, 3179, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 107, 16},	//1441 KFilterBase::uncompress() [pure virtual]
    {60, 1165, 103, 1, Smoke::mf_virtual|Smoke::mf_purevirtual, 107, 17},	//1442 KFilterBase::compress(bool) [pure virtual]
    {60, 2642, 1132, 1, 0, 0, 18},	//1443 KFilterBase::setFilterFlags(KFilterBase::FilterFlags)
    {60, 1501, 0, 0, Smoke::mf_const, 106, 19},	//1444 KFilterBase::filterFlags() const
    {60, 1545, 30, 1, Smoke::mf_static, 105, 20},	//1445 KFilterBase::findFilterByFileName(const QString&)
    {60, 1547, 30, 1, Smoke::mf_static, 105, 21},	//1446 KFilterBase::findFilterByMimeType(const QString&)
    {60, 2604, 1134, 1, 0, 0, 22},	//1447 KFilterBase::setDevice(QIODevice*)
    {60, 2019, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 305, 23},	//1448 KFilterBase::m_dev() const
    {60, 2714, 1134, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 24},	//1449 KFilterBase::setM_dev(QIODevice*)
    {60, 2013, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 450, 25},	//1450 KFilterBase::m_bAutoDel() const
    {60, 2702, 103, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 26},	//1451 KFilterBase::setM_bAutoDel(bool)
    {60, 645, 0, 0, Smoke::mf_static|Smoke::mf_enum, 107, 27},	//1452 KFilterBase::Ok (enum)
    {60, 115, 0, 0, Smoke::mf_static|Smoke::mf_enum, 107, 28},	//1453 KFilterBase::End (enum)
    {60, 125, 0, 0, Smoke::mf_static|Smoke::mf_enum, 107, 29},	//1454 KFilterBase::Error (enum)
    {60, 625, 0, 0, Smoke::mf_static|Smoke::mf_enum, 106, 30},	//1455 KFilterBase::NoHeaders (enum)
    {60, 810, 0, 0, Smoke::mf_static|Smoke::mf_enum, 106, 31},	//1456 KFilterBase::WithHeaders (enum)
    {60, 3380, 0, 0, Smoke::mf_dtor, 0, 32 },	//1457 KFilterBase::~KFilterBase()
    {61, 2145, 150, 1, 0, 450, 1},	//1458 KFilterDev::open(QFlags<QIODevice::OpenModeFlag>)
    {61, 1149, 0, 0, 0, 0, 2},	//1459 KFilterDev::close()
    {61, 2796, 32, 1, 0, 0, 3},	//1460 KFilterDev::setOrigFileName(const QByteArray&)
    {61, 2871, 0, 0, 0, 0, 4},	//1461 KFilterDev::setSkipHeaders()
    {61, 2474, 861, 1, 0, 450, 5},	//1462 KFilterDev::seek(long long)
    {61, 1038, 0, 0, Smoke::mf_const, 450, 6},	//1463 KFilterDev::atEnd() const
    {61, 1365, 1136, 3, Smoke::mf_static, 305, 7},	//1464 KFilterDev::deviceForFile(const QString&, const QString&, bool)
    {61, 1362, 1140, 3, Smoke::mf_static, 305, 8},	//1465 KFilterDev::device(QIODevice*, const QString&, bool)
    {61, 2336, 1144, 2, Smoke::mf_protected, 619, 9},	//1466 KFilterDev::readData(char*, long long)
    {61, 3290, 1147, 2, Smoke::mf_protected, 619, 10},	//1467 KFilterDev::writeData(const char*, long long)
    {61, 1365, 30, 1, Smoke::mf_static, 305, 11},	//1468 KFilterDev::deviceForFile(const QString&)
    {61, 1365, 95, 2, Smoke::mf_static, 305, 12},	//1469 KFilterDev::deviceForFile(const QString&, const QString&)
    {61, 1362, 1150, 2, Smoke::mf_static, 305, 13},	//1470 KFilterDev::device(QIODevice*, const QString&)
    {61, 3381, 0, 0, Smoke::mf_dtor, 0, 14 },	//1471 KFilterDev::~KFilterDev()
    {62, 2038, 0, 0, Smoke::mf_static, 467, 1},	//1472 KGlobal::mainComponent()
    {62, 3031, 30, 1, Smoke::mf_static, 590, 2},	//1473 KGlobal::staticQString(const QString&)
    {62, 1121, 0, 0, Smoke::mf_static, 35, 3},	//1474 KGlobal::charsets()
    {62, 2504, 103, 1, Smoke::mf_static, 0, 4},	//1475 KGlobal::setAllowQuit(bool)
    {62, 2396, 0, 0, Smoke::mf_static, 0, 5},	//1476 KGlobal::ref()
    {62, 2692, 1153, 2, Smoke::mf_static, 0, 6},	//1477 KGlobal::setLocale(KLocale*, KGlobal::CopyCatalogs)
    {62, 2692, 1156, 1, Smoke::mf_static, 0, 7},	//1478 KGlobal::setLocale(KLocale*)
    {62, 1377, 0, 0, Smoke::mf_static, 200, 8},	//1479 KGlobal::dirs()
    {62, 3177, 0, 0, Smoke::mf_static, 621, 9},	//1480 KGlobal::umask()
    {62, 1108, 0, 0, Smoke::mf_static, 351, 10},	//1481 KGlobal::caption()
    {62, 1987, 0, 0, Smoke::mf_static, 123, 11},	//1482 KGlobal::locale()
    {62, 1742, 30, 1, Smoke::mf_static, 0, 12},	//1483 KGlobal::insertCatalog(const QString&)
    {62, 1168, 0, 0, Smoke::mf_static, 195, 13},	//1484 KGlobal::config()
    {62, 3031, 122, 1, Smoke::mf_static, 590, 14},	//1485 KGlobal::staticQString(const char*)
    {62, 1679, 0, 0, Smoke::mf_static, 450, 15},	//1486 KGlobal::hasLocale()
    {62, 1533, 1158, 2, Smoke::mf_static, 345, 16},	//1487 KGlobal::findDirectChild_helper(const QObject*, const QMetaObject&)
    {62, 841, 0, 0, Smoke::mf_static, 40, 17},	//1488 KGlobal::activeComponent()
    {62, 2500, 430, 1, Smoke::mf_static, 0, 18},	//1489 KGlobal::setActiveComponent(const KComponentData&)
    {62, 1680, 0, 0, Smoke::mf_static, 450, 19},	//1490 KGlobal::hasMainComponent()
    {62, 1343, 0, 0, Smoke::mf_static, 0, 20},	//1491 KGlobal::deref()
    {62, 106, 0, 0, Smoke::mf_static|Smoke::mf_enum, 108, 21},	//1492 KGlobal::DoCopyCatalogs (enum)
    {62, 108, 0, 0, Smoke::mf_static|Smoke::mf_enum, 108, 22},	//1493 KGlobal::DontCopyCatalogs (enum)
    {63, 2060, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 582, 1},	//1494 KJob::metaObject() const
    {63, 2301, 122, 1, Smoke::mf_virtual, 639, 2},	//1495 KJob::qt_metacast(const char*)
    {63, 3131, 124, 2, Smoke::mf_static, 351, 3},	//1496 KJob::tr(const char*, const char*)
    {63, 3138, 124, 2, Smoke::mf_static, 351, 4},	//1497 KJob::trUtf8(const char*, const char*)
    {63, 3131, 127, 3, Smoke::mf_static, 351, 5},	//1498 KJob::tr(const char*, const char*, int)
    {63, 3138, 127, 3, Smoke::mf_static, 351, 6},	//1499 KJob::trUtf8(const char*, const char*, int)
    {63, 2299, 131, 3, Smoke::mf_virtual, 614, 7},	//1500 KJob::qt_metacall(QMetaObject::Call, int, void**)
    {63, 380, 146, 1, Smoke::mf_ctor, 109, 8},	//1501 KJob::KJob(QObject*)
    {63, 2908, 1161, 1, 0, 0, 9},	//1502 KJob::setUiDelegate(KJobUiDelegate*)
    {63, 3175, 0, 0, Smoke::mf_const, 115, 10},	//1503 KJob::uiDelegate() const
    {63, 1106, 0, 0, Smoke::mf_const, 287, 11},	//1504 KJob::capabilities() const
    {63, 1863, 0, 0, Smoke::mf_const, 450, 12},	//1505 KJob::isSuspended() const
    {63, 2972, 0, 0, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 13},	//1506 KJob::start() [pure virtual]
    {63, 1938, 1163, 1, Smoke::mf_slot, 450, 14},	//1507 KJob::kill(KJob::KillVerbosity)
    {63, 3063, 0, 0, Smoke::mf_slot, 450, 15},	//1508 KJob::suspend()
    {63, 2451, 0, 0, Smoke::mf_slot, 450, 16},	//1509 KJob::resume()
    {63, 1382, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 450, 17},	//1510 KJob::doKill()
    {63, 1384, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 450, 18},	//1511 KJob::doSuspend()
    {63, 1383, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 450, 19},	//1512 KJob::doResume()
    {63, 2535, 1165, 1, Smoke::mf_protected, 0, 20},	//1513 KJob::setCapabilities(QFlags<KJob::Capability>)
    {63, 1446, 0, 0, 0, 450, 21},	//1514 KJob::exec()
    {63, 1434, 0, 0, Smoke::mf_const, 614, 22},	//1515 KJob::error() const
    {63, 1439, 0, 0, Smoke::mf_const, 351, 23},	//1516 KJob::errorText() const
    {63, 1437, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 351, 24},	//1517 KJob::errorString() const
    {63, 2266, 1167, 1, Smoke::mf_const, 635, 25},	//1518 KJob::processedAmount(KJob::Unit) const
    {63, 3128, 1167, 1, Smoke::mf_const, 635, 26},	//1519 KJob::totalAmount(KJob::Unit) const
    {63, 2230, 0, 0, Smoke::mf_const, 634, 27},	//1520 KJob::percent() const
    {63, 2515, 103, 1, 0, 0, 28},	//1521 KJob::setAutoDelete(bool)
    {63, 1778, 0, 0, Smoke::mf_const, 450, 29},	//1522 KJob::isAutoDelete() const
    {63, 1344, 1169, 4, Smoke::mf_protected|Smoke::mf_signal, 0, 30},	//1523 KJob::description(KJob*, const QString&, const QPair<QString,QString>&, const QPair<QString,QString>&)
    {63, 1726, 447, 3, Smoke::mf_protected|Smoke::mf_signal, 0, 31},	//1524 KJob::infoMessage(KJob*, const QString&, const QString&)
    {63, 3248, 447, 3, Smoke::mf_protected|Smoke::mf_signal, 0, 32},	//1525 KJob::warning(KJob*, const QString&, const QString&)
    {63, 2621, 118, 1, Smoke::mf_protected, 0, 33},	//1526 KJob::setError(int)
    {63, 2627, 30, 1, Smoke::mf_protected, 0, 34},	//1527 KJob::setErrorText(const QString&)
    {63, 2829, 1174, 2, Smoke::mf_protected, 0, 35},	//1528 KJob::setProcessedAmount(KJob::Unit, unsigned long long)
    {63, 2898, 1174, 2, Smoke::mf_protected, 0, 36},	//1529 KJob::setTotalAmount(KJob::Unit, unsigned long long)
    {63, 2812, 1177, 1, Smoke::mf_protected, 0, 37},	//1530 KJob::setPercent(unsigned long)
    {63, 1394, 0, 0, Smoke::mf_protected, 0, 38},	//1531 KJob::emitResult()
    {63, 1392, 1179, 2, Smoke::mf_protected, 0, 39},	//1532 KJob::emitPercent(unsigned long long, unsigned long long)
    {63, 1395, 1177, 1, Smoke::mf_protected, 0, 40},	//1533 KJob::emitSpeed(unsigned long)
    {63, 380, 1182, 2, Smoke::mf_ctor|Smoke::mf_protected, 109, 41},	//1534 KJob::KJob(KJobPrivate&, QObject*)
    {63, 3131, 122, 1, Smoke::mf_static, 351, 42},	//1535 KJob::tr(const char*)
    {63, 3138, 122, 1, Smoke::mf_static, 351, 43},	//1536 KJob::trUtf8(const char*)
    {63, 380, 0, 0, Smoke::mf_ctor, 109, 44},	//1537 KJob::KJob()
    {63, 1938, 0, 0, Smoke::mf_slot, 450, 45},	//1538 KJob::kill()
    {63, 1344, 1185, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 46},	//1539 KJob::description(KJob*, const QString&)
    {63, 1344, 1188, 3, Smoke::mf_protected|Smoke::mf_signal, 0, 47},	//1540 KJob::description(KJob*, const QString&, const QPair<QString,QString>&)
    {63, 1726, 1185, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 48},	//1541 KJob::infoMessage(KJob*, const QString&)
    {63, 3248, 1185, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 49},	//1542 KJob::warning(KJob*, const QString&)
    {63, 3030, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 581, 50},	//1543 KJob::staticMetaObject() const
    {63, 46, 0, 0, Smoke::mf_static|Smoke::mf_enum, 112, 51},	//1544 KJob::Bytes (enum)
    {63, 140, 0, 0, Smoke::mf_static|Smoke::mf_enum, 112, 52},	//1545 KJob::Files (enum)
    {63, 104, 0, 0, Smoke::mf_static|Smoke::mf_enum, 112, 53},	//1546 KJob::Directories (enum)
    {63, 619, 0, 0, Smoke::mf_static|Smoke::mf_enum, 110, 54},	//1547 KJob::NoCapabilities (enum)
    {63, 562, 0, 0, Smoke::mf_static|Smoke::mf_enum, 110, 55},	//1548 KJob::Killable (enum)
    {63, 742, 0, 0, Smoke::mf_static|Smoke::mf_enum, 110, 56},	//1549 KJob::Suspendable (enum)
    {63, 681, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 57},	//1550 KJob::Quietly (enum)
    {63, 111, 0, 0, Smoke::mf_static|Smoke::mf_enum, 111, 58},	//1551 KJob::EmitResult (enum)
    {63, 623, 0, 0, Smoke::mf_static|Smoke::mf_enum, 618, 59},	//1552 KJob::NoError (enum)
    {63, 563, 0, 0, Smoke::mf_static|Smoke::mf_enum, 618, 60},	//1553 KJob::KilledJobError (enum)
    {63, 804, 0, 0, Smoke::mf_static|Smoke::mf_enum, 618, 61},	//1554 KJob::UserDefinedError (enum)
    {63, 3382, 0, 0, Smoke::mf_dtor, 0, 62 },	//1555 KJob::~KJob()
    {65, 2060, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 582, 1},	//1556 KJobTrackerInterface::metaObject() const
    {65, 2301, 122, 1, Smoke::mf_virtual, 639, 2},	//1557 KJobTrackerInterface::qt_metacast(const char*)
    {65, 3131, 124, 2, Smoke::mf_static, 351, 3},	//1558 KJobTrackerInterface::tr(const char*, const char*)
    {65, 3138, 124, 2, Smoke::mf_static, 351, 4},	//1559 KJobTrackerInterface::trUtf8(const char*, const char*)
    {65, 3131, 127, 3, Smoke::mf_static, 351, 5},	//1560 KJobTrackerInterface::tr(const char*, const char*, int)
    {65, 3138, 127, 3, Smoke::mf_static, 351, 6},	//1561 KJobTrackerInterface::trUtf8(const char*, const char*, int)
    {65, 2299, 131, 3, Smoke::mf_virtual, 614, 7},	//1562 KJobTrackerInterface::qt_metacall(QMetaObject::Call, int, void**)
    {65, 383, 146, 1, Smoke::mf_ctor, 114, 8},	//1563 KJobTrackerInterface::KJobTrackerInterface(QObject*)
    {65, 2400, 445, 1, Smoke::mf_virtual|Smoke::mf_slot, 0, 9},	//1564 KJobTrackerInterface::registerJob(KJob*)
    {65, 3185, 445, 1, Smoke::mf_virtual|Smoke::mf_slot, 0, 10},	//1565 KJobTrackerInterface::unregisterJob(KJob*)
    {65, 1558, 445, 1, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_slot, 0, 11},	//1566 KJobTrackerInterface::finished(KJob*)
    {65, 3064, 445, 1, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_slot, 0, 12},	//1567 KJobTrackerInterface::suspended(KJob*)
    {65, 2452, 445, 1, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_slot, 0, 13},	//1568 KJobTrackerInterface::resumed(KJob*)
    {65, 1344, 1169, 4, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_slot, 0, 14},	//1569 KJobTrackerInterface::description(KJob*, const QString&, const QPair<QString,QString>&, const QPair<QString,QString>&)
    {65, 1726, 447, 3, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_slot, 0, 15},	//1570 KJobTrackerInterface::infoMessage(KJob*, const QString&, const QString&)
    {65, 3248, 447, 3, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_slot, 0, 16},	//1571 KJobTrackerInterface::warning(KJob*, const QString&, const QString&)
    {65, 3128, 1192, 3, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_slot, 0, 17},	//1572 KJobTrackerInterface::totalAmount(KJob*, KJob::Unit, qulonglong)
    {65, 2266, 1192, 3, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_slot, 0, 18},	//1573 KJobTrackerInterface::processedAmount(KJob*, KJob::Unit, qulonglong)
    {65, 2230, 1196, 2, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_slot, 0, 19},	//1574 KJobTrackerInterface::percent(KJob*, unsigned long)
    {65, 2956, 1196, 2, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_slot, 0, 20},	//1575 KJobTrackerInterface::speed(KJob*, unsigned long)
    {65, 3131, 122, 1, Smoke::mf_static, 351, 21},	//1576 KJobTrackerInterface::tr(const char*)
    {65, 3138, 122, 1, Smoke::mf_static, 351, 22},	//1577 KJobTrackerInterface::trUtf8(const char*)
    {65, 383, 0, 0, Smoke::mf_ctor, 114, 23},	//1578 KJobTrackerInterface::KJobTrackerInterface()
    {65, 3030, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 581, 24},	//1579 KJobTrackerInterface::staticMetaObject() const
    {65, 3383, 0, 0, Smoke::mf_dtor, 0, 25 },	//1580 KJobTrackerInterface::~KJobTrackerInterface()
    {66, 2060, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 582, 1},	//1581 KJobUiDelegate::metaObject() const
    {66, 2301, 122, 1, Smoke::mf_virtual, 639, 2},	//1582 KJobUiDelegate::qt_metacast(const char*)
    {66, 3131, 124, 2, Smoke::mf_static, 351, 3},	//1583 KJobUiDelegate::tr(const char*, const char*)
    {66, 3138, 124, 2, Smoke::mf_static, 351, 4},	//1584 KJobUiDelegate::trUtf8(const char*, const char*)
    {66, 3131, 127, 3, Smoke::mf_static, 351, 5},	//1585 KJobUiDelegate::tr(const char*, const char*, int)
    {66, 3138, 127, 3, Smoke::mf_static, 351, 6},	//1586 KJobUiDelegate::trUtf8(const char*, const char*, int)
    {66, 2299, 131, 3, Smoke::mf_virtual, 614, 7},	//1587 KJobUiDelegate::qt_metacall(QMetaObject::Call, int, void**)
    {66, 385, 0, 0, Smoke::mf_ctor, 115, 8},	//1588 KJobUiDelegate::KJobUiDelegate()
    {66, 1883, 0, 0, Smoke::mf_protected, 109, 9},	//1589 KJobUiDelegate::job()
    {66, 2937, 0, 0, Smoke::mf_virtual, 0, 10},	//1590 KJobUiDelegate::showErrorMessage()
    {66, 2519, 103, 1, 0, 0, 11},	//1591 KJobUiDelegate::setAutoErrorHandlingEnabled(bool)
    {66, 1779, 0, 0, Smoke::mf_const, 450, 12},	//1592 KJobUiDelegate::isAutoErrorHandlingEnabled() const
    {66, 2523, 103, 1, 0, 0, 13},	//1593 KJobUiDelegate::setAutoWarningHandlingEnabled(bool)
    {66, 1780, 0, 0, Smoke::mf_const, 450, 14},	//1594 KJobUiDelegate::isAutoWarningHandlingEnabled() const
    {66, 2952, 447, 3, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_slot, 0, 15},	//1595 KJobUiDelegate::slotWarning(KJob*, const QString&, const QString&)
    {66, 3131, 122, 1, Smoke::mf_static, 351, 16},	//1596 KJobUiDelegate::tr(const char*)
    {66, 3138, 122, 1, Smoke::mf_static, 351, 17},	//1597 KJobUiDelegate::trUtf8(const char*)
    {66, 3030, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 581, 18},	//1598 KJobUiDelegate::staticMetaObject() const
    {66, 3384, 0, 0, Smoke::mf_dtor, 0, 19 },	//1599 KJobUiDelegate::~KJobUiDelegate()
    {67, 2060, 0, 0, Smoke::mf_const, 582, 1},	//1600 KLibLoader::metaObject() const
    {67, 2301, 122, 1, 0, 639, 2},	//1601 KLibLoader::qt_metacast(const char*)
    {67, 3131, 124, 2, Smoke::mf_static, 351, 3},	//1602 KLibLoader::tr(const char*, const char*)
    {67, 3138, 124, 2, Smoke::mf_static, 351, 4},	//1603 KLibLoader::trUtf8(const char*, const char*)
    {67, 3131, 127, 3, Smoke::mf_static, 351, 5},	//1604 KLibLoader::tr(const char*, const char*, int)
    {67, 3138, 127, 3, Smoke::mf_static, 351, 6},	//1605 KLibLoader::trUtf8(const char*, const char*, int)
    {67, 2299, 131, 3, 0, 614, 7},	//1606 KLibLoader::qt_metacall(QMetaObject::Call, int, void**)
    {67, 1485, 1199, 2, 0, 157, 8},	//1607 KLibLoader::factory(const QString&, QFlags<QLibrary::LoadHint>)
    {67, 1967, 1199, 2, 0, 118, 9},	//1608 KLibLoader::library(const QString&, QFlags<QLibrary::LoadHint>)
    {67, 1959, 0, 0, Smoke::mf_const, 351, 10},	//1609 KLibLoader::lastErrorMessage() const
    {67, 3182, 30, 1, 0, 0, 11},	//1610 KLibLoader::unloadLibrary(const QString&)
    {67, 2476, 0, 0, Smoke::mf_static, 116, 12},	//1611 KLibLoader::self()
    {67, 1551, 1202, 2, Smoke::mf_static, 351, 13},	//1612 KLibLoader::findLibrary(const QString&, const KComponentData&)
    {67, 1437, 118, 1, Smoke::mf_static, 351, 14},	//1613 KLibLoader::errorString(int)
    {67, 3131, 122, 1, Smoke::mf_static, 351, 15},	//1614 KLibLoader::tr(const char*)
    {67, 3138, 122, 1, Smoke::mf_static, 351, 16},	//1615 KLibLoader::trUtf8(const char*)
    {67, 1485, 30, 1, 0, 157, 17},	//1616 KLibLoader::factory(const QString&)
    {67, 1967, 30, 1, 0, 118, 18},	//1617 KLibLoader::library(const QString&)
    {67, 1551, 30, 1, Smoke::mf_static, 351, 19},	//1618 KLibLoader::findLibrary(const QString&)
    {67, 3030, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 581, 20},	//1619 KLibLoader::staticMetaObject() const
    {67, 122, 0, 0, Smoke::mf_static|Smoke::mf_enum, 117, 21},	//1620 KLibLoader::ErrNoLibrary (enum)
    {67, 121, 0, 0, Smoke::mf_static|Smoke::mf_enum, 117, 22},	//1621 KLibLoader::ErrNoFactory (enum)
    {67, 120, 0, 0, Smoke::mf_static|Smoke::mf_enum, 117, 23},	//1622 KLibLoader::ErrNoComponent (enum)
    {67, 124, 0, 0, Smoke::mf_static|Smoke::mf_enum, 117, 24},	//1623 KLibLoader::ErrServiceProvidesNoLibrary (enum)
    {67, 123, 0, 0, Smoke::mf_static|Smoke::mf_enum, 117, 25},	//1624 KLibLoader::ErrNoServiceFound (enum)
    {68, 2060, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 582, 1},	//1625 KLibrary::metaObject() const
    {68, 2301, 122, 1, Smoke::mf_virtual, 639, 2},	//1626 KLibrary::qt_metacast(const char*)
    {68, 3131, 124, 2, Smoke::mf_static, 351, 3},	//1627 KLibrary::tr(const char*, const char*)
    {68, 3138, 124, 2, Smoke::mf_static, 351, 4},	//1628 KLibrary::trUtf8(const char*, const char*)
    {68, 3131, 127, 3, Smoke::mf_static, 351, 5},	//1629 KLibrary::tr(const char*, const char*, int)
    {68, 3138, 127, 3, Smoke::mf_static, 351, 6},	//1630 KLibrary::trUtf8(const char*, const char*, int)
    {68, 2299, 131, 3, Smoke::mf_virtual, 614, 7},	//1631 KLibrary::qt_metacall(QMetaObject::Call, int, void**)
    {68, 386, 146, 1, Smoke::mf_ctor, 118, 8},	//1632 KLibrary::KLibrary(QObject*)
    {68, 386, 1205, 3, Smoke::mf_ctor, 118, 9},	//1633 KLibrary::KLibrary(const QString&, const KComponentData&, QObject*)
    {68, 386, 1209, 4, Smoke::mf_ctor, 118, 10},	//1634 KLibrary::KLibrary(const QString&, int, const KComponentData&, QObject*)
    {68, 1485, 122, 1, 0, 157, 11},	//1635 KLibrary::factory(const char*)
    {68, 2444, 122, 1, 0, 639, 12},	//1636 KLibrary::resolveSymbol(const char*)
    {68, 2442, 122, 1, 0, 638, 13},	//1637 KLibrary::resolveFunction(const char*)
    {68, 2639, 1202, 2, 0, 0, 14},	//1638 KLibrary::setFileName(const QString&, const KComponentData&)
    {68, 3181, 0, 0, 0, 450, 15},	//1639 KLibrary::unload()
    {68, 3131, 122, 1, Smoke::mf_static, 351, 16},	//1640 KLibrary::tr(const char*)
    {68, 3138, 122, 1, Smoke::mf_static, 351, 17},	//1641 KLibrary::trUtf8(const char*)
    {68, 386, 0, 0, Smoke::mf_ctor, 118, 18},	//1642 KLibrary::KLibrary()
    {68, 386, 30, 1, Smoke::mf_ctor, 118, 19},	//1643 KLibrary::KLibrary(const QString&)
    {68, 386, 1202, 2, Smoke::mf_ctor, 118, 20},	//1644 KLibrary::KLibrary(const QString&, const KComponentData&)
    {68, 386, 1014, 2, Smoke::mf_ctor, 118, 21},	//1645 KLibrary::KLibrary(const QString&, int)
    {68, 386, 1214, 3, Smoke::mf_ctor, 118, 22},	//1646 KLibrary::KLibrary(const QString&, int, const KComponentData&)
    {68, 1485, 0, 0, 0, 157, 23},	//1647 KLibrary::factory()
    {68, 2639, 30, 1, 0, 0, 24},	//1648 KLibrary::setFileName(const QString&)
    {68, 3030, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 581, 25},	//1649 KLibrary::staticMetaObject() const
    {68, 3385, 0, 0, Smoke::mf_dtor, 0, 26 },	//1650 KLibrary::~KLibrary()
    {69, 2060, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 582, 1},	//1651 KLocalSocket::metaObject() const
    {69, 2301, 122, 1, Smoke::mf_virtual, 639, 2},	//1652 KLocalSocket::qt_metacast(const char*)
    {69, 3131, 124, 2, Smoke::mf_static, 351, 3},	//1653 KLocalSocket::tr(const char*, const char*)
    {69, 3138, 124, 2, Smoke::mf_static, 351, 4},	//1654 KLocalSocket::trUtf8(const char*, const char*)
    {69, 3131, 127, 3, Smoke::mf_static, 351, 5},	//1655 KLocalSocket::tr(const char*, const char*, int)
    {69, 3138, 127, 3, Smoke::mf_static, 351, 6},	//1656 KLocalSocket::trUtf8(const char*, const char*, int)
    {69, 2299, 131, 3, Smoke::mf_virtual, 614, 7},	//1657 KLocalSocket::qt_metacall(QMetaObject::Call, int, void**)
    {69, 394, 146, 1, Smoke::mf_ctor, 119, 8},	//1658 KLocalSocket::KLocalSocket(QObject*)
    {69, 1180, 1218, 2, 0, 0, 9},	//1659 KLocalSocket::connectToPath(const QString&, QFlags<QIODevice::OpenModeFlag>)
    {69, 1180, 1221, 3, 0, 0, 10},	//1660 KLocalSocket::connectToPath(const QString&, KLocalSocket::LocalSocketType, QFlags<QIODevice::OpenModeFlag>)
    {69, 1380, 0, 0, 0, 0, 11},	//1661 KLocalSocket::disconnectFromPath()
    {69, 1986, 0, 0, Smoke::mf_const, 120, 12},	//1662 KLocalSocket::localSocketType() const
    {69, 1985, 0, 0, Smoke::mf_const, 351, 13},	//1663 KLocalSocket::localPath() const
    {69, 2229, 0, 0, Smoke::mf_const, 351, 14},	//1664 KLocalSocket::peerPath() const
    {69, 1178, 1225, 3, Smoke::mf_protected|Smoke::mf_slot, 0, 15},	//1665 KLocalSocket::connectToHostImplementation(const QString&, quint16, QIODevice::OpenMode)
    {69, 1379, 0, 0, Smoke::mf_protected|Smoke::mf_slot, 0, 16},	//1666 KLocalSocket::disconnectFromHostImplementation()
    {69, 3131, 122, 1, Smoke::mf_static, 351, 17},	//1667 KLocalSocket::tr(const char*)
    {69, 3138, 122, 1, Smoke::mf_static, 351, 18},	//1668 KLocalSocket::trUtf8(const char*)
    {69, 394, 0, 0, Smoke::mf_ctor, 119, 19},	//1669 KLocalSocket::KLocalSocket()
    {69, 1180, 30, 1, 0, 0, 20},	//1670 KLocalSocket::connectToPath(const QString&)
    {69, 1180, 1229, 2, 0, 0, 21},	//1671 KLocalSocket::connectToPath(const QString&, KLocalSocket::LocalSocketType)
    {69, 3030, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 581, 22},	//1672 KLocalSocket::staticMetaObject() const
    {69, 790, 0, 0, Smoke::mf_static|Smoke::mf_enum, 120, 23},	//1673 KLocalSocket::UnixSocket (enum)
    {69, 3, 0, 0, Smoke::mf_static|Smoke::mf_enum, 120, 24},	//1674 KLocalSocket::AbstractUnixSocket (enum)
    {69, 793, 0, 0, Smoke::mf_static|Smoke::mf_enum, 120, 25},	//1675 KLocalSocket::UnknownLocalSocketType (enum)
    {69, 3386, 0, 0, Smoke::mf_dtor, 0, 26 },	//1676 KLocalSocket::~KLocalSocket()
    {70, 2060, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 582, 1},	//1677 KLocalSocketServer::metaObject() const
    {70, 2301, 122, 1, Smoke::mf_virtual, 639, 2},	//1678 KLocalSocketServer::qt_metacast(const char*)
    {70, 3131, 124, 2, Smoke::mf_static, 351, 3},	//1679 KLocalSocketServer::tr(const char*, const char*)
    {70, 3138, 124, 2, Smoke::mf_static, 351, 4},	//1680 KLocalSocketServer::trUtf8(const char*, const char*)
    {70, 3131, 127, 3, Smoke::mf_static, 351, 5},	//1681 KLocalSocketServer::tr(const char*, const char*, int)
    {70, 3138, 127, 3, Smoke::mf_static, 351, 6},	//1682 KLocalSocketServer::trUtf8(const char*, const char*, int)
    {70, 2299, 131, 3, Smoke::mf_virtual, 614, 7},	//1683 KLocalSocketServer::qt_metacall(QMetaObject::Call, int, void**)
    {70, 396, 146, 1, Smoke::mf_ctor, 121, 8},	//1684 KLocalSocketServer::KLocalSocketServer(QObject*)
    {70, 1974, 1229, 2, 0, 450, 9},	//1685 KLocalSocketServer::listen(const QString&, KLocalSocket::LocalSocketType)
    {70, 1149, 0, 0, 0, 0, 10},	//1686 KLocalSocketServer::close()
    {70, 1832, 0, 0, Smoke::mf_const, 450, 11},	//1687 KLocalSocketServer::isListening() const
    {70, 2760, 118, 1, 0, 0, 12},	//1688 KLocalSocketServer::setMaxPendingConnections(int)
    {70, 2049, 0, 0, Smoke::mf_const, 614, 13},	//1689 KLocalSocketServer::maxPendingConnections() const
    {70, 1986, 0, 0, Smoke::mf_const, 120, 14},	//1690 KLocalSocketServer::localSocketType() const
    {70, 1985, 0, 0, Smoke::mf_const, 351, 15},	//1691 KLocalSocketServer::localPath() const
    {70, 3242, 1232, 2, 0, 450, 16},	//1692 KLocalSocketServer::waitForNewConnection(int, bool*)
    {70, 1692, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 450, 17},	//1693 KLocalSocketServer::hasPendingConnections() const
    {70, 2119, 0, 0, Smoke::mf_virtual, 119, 18},	//1694 KLocalSocketServer::nextPendingConnection()
    {70, 2478, 0, 0, Smoke::mf_const, 262, 19},	//1695 KLocalSocketServer::serverError() const
    {70, 1437, 0, 0, Smoke::mf_const, 351, 20},	//1696 KLocalSocketServer::errorString() const
    {70, 1724, 118, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 21},	//1697 KLocalSocketServer::incomingConnection(int)
    {70, 2114, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 22},	//1698 KLocalSocketServer::newConnection()
    {70, 3131, 122, 1, Smoke::mf_static, 351, 23},	//1699 KLocalSocketServer::tr(const char*)
    {70, 3138, 122, 1, Smoke::mf_static, 351, 24},	//1700 KLocalSocketServer::trUtf8(const char*)
    {70, 396, 0, 0, Smoke::mf_ctor, 121, 25},	//1701 KLocalSocketServer::KLocalSocketServer()
    {70, 1974, 30, 1, 0, 450, 26},	//1702 KLocalSocketServer::listen(const QString&)
    {70, 3242, 0, 0, 0, 450, 27},	//1703 KLocalSocketServer::waitForNewConnection()
    {70, 3242, 118, 1, 0, 450, 28},	//1704 KLocalSocketServer::waitForNewConnection(int)
    {70, 3030, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 581, 29},	//1705 KLocalSocketServer::staticMetaObject() const
    {70, 3387, 0, 0, Smoke::mf_dtor, 0, 30 },	//1706 KLocalSocketServer::~KLocalSocketServer()
    {71, 398, 310, 2, Smoke::mf_ctor, 123, 1},	//1707 KLocale::KLocale(const QString&, KSharedPtr<KSharedConfig>)
    {71, 398, 1235, 4, Smoke::mf_ctor, 123, 2},	//1708 KLocale::KLocale(const QString&, const QString&, const QString&, KConfig*)
    {71, 398, 1240, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 123, 3},	//1709 KLocale::KLocale(const KLocale&)
    {71, 2182, 1240, 1, 0, 122, 4},	//1710 KLocale::operator=(const KLocale&)
    {71, 3167, 1242, 4, Smoke::mf_const, 0, 5},	//1711 KLocale::translateRawFrom(const char*, const char*, QString*, QString*) const
    {71, 3162, 1247, 3, Smoke::mf_const, 0, 6},	//1712 KLocale::translateRaw(const char*, QString*, QString*) const
    {71, 3167, 1251, 5, Smoke::mf_const, 0, 7},	//1713 KLocale::translateRawFrom(const char*, const char*, const char*, QString*, QString*) const
    {71, 3162, 1242, 4, Smoke::mf_const, 0, 8},	//1714 KLocale::translateRaw(const char*, const char*, QString*, QString*) const
    {71, 3167, 1257, 6, Smoke::mf_const, 0, 9},	//1715 KLocale::translateRawFrom(const char*, const char*, const char*, unsigned long, QString*, QString*) const
    {71, 3162, 1264, 5, Smoke::mf_const, 0, 10},	//1716 KLocale::translateRaw(const char*, const char*, unsigned long, QString*, QString*) const
    {71, 3167, 1270, 7, Smoke::mf_const, 0, 11},	//1717 KLocale::translateRawFrom(const char*, const char*, const char*, const char*, unsigned long, QString*, QString*) const
    {71, 3162, 1257, 6, Smoke::mf_const, 0, 12},	//1718 KLocale::translateRaw(const char*, const char*, const char*, unsigned long, QString*, QString*) const
    {71, 2615, 118, 1, 0, 450, 13},	//1719 KLocale::setEncoding(int)
    {71, 1370, 1278, 2, Smoke::mf_const, 351, 14},	//1720 KLocale::digitSetToName(KLocale::DigitSet, bool) const
    {71, 1007, 0, 0, Smoke::mf_const, 318, 15},	//1721 KLocale::allDigitSetsList() const
    {71, 1307, 0, 0, Smoke::mf_const, 351, 16},	//1722 KLocale::decimalSymbol() const
    {71, 3092, 0, 0, Smoke::mf_const, 351, 17},	//1723 KLocale::thousandsSeparator() const
    {71, 1369, 0, 0, Smoke::mf_const, 133, 18},	//1724 KLocale::digitSet() const
    {71, 1224, 0, 0, Smoke::mf_const, 351, 19},	//1725 KLocale::currencyCode() const
    {71, 1223, 0, 0, Smoke::mf_const, 83, 20},	//1726 KLocale::currency() const
    {71, 1229, 0, 0, Smoke::mf_const, 351, 21},	//1727 KLocale::currencySymbol() const
    {71, 2079, 0, 0, Smoke::mf_const, 351, 22},	//1728 KLocale::monetaryDecimalSymbol() const
    {71, 2081, 0, 0, Smoke::mf_const, 351, 23},	//1729 KLocale::monetaryThousandsSeparator() const
    {71, 2250, 0, 0, Smoke::mf_const, 351, 24},	//1730 KLocale::positiveSign() const
    {71, 2113, 0, 0, Smoke::mf_const, 351, 25},	//1731 KLocale::negativeSign() const
    {71, 1605, 0, 0, Smoke::mf_const, 614, 26},	//1732 KLocale::fracDigits() const
    {71, 1306, 0, 0, Smoke::mf_const, 614, 27},	//1733 KLocale::decimalPlaces() const
    {71, 2078, 0, 0, Smoke::mf_const, 614, 28},	//1734 KLocale::monetaryDecimalPlaces() const
    {71, 2249, 0, 0, Smoke::mf_const, 450, 29},	//1735 KLocale::positivePrefixCurrencySymbol() const
    {71, 2112, 0, 0, Smoke::mf_const, 450, 30},	//1736 KLocale::negativePrefixCurrencySymbol() const
    {71, 2248, 0, 0, Smoke::mf_const, 137, 31},	//1737 KLocale::positiveMonetarySignPosition() const
    {71, 2111, 0, 0, Smoke::mf_const, 137, 32},	//1738 KLocale::negativeMonetarySignPosition() const
    {71, 2080, 0, 0, Smoke::mf_const, 133, 33},	//1739 KLocale::monetaryDigitSet() const
    {71, 1593, 1281, 3, Smoke::mf_const, 351, 34},	//1740 KLocale::formatMoney(double, const QString&, int) const
    {71, 1597, 1285, 2, Smoke::mf_const, 351, 35},	//1741 KLocale::formatNumber(double, int) const
    {71, 1597, 1288, 3, Smoke::mf_const, 351, 36},	//1742 KLocale::formatNumber(const QString&, bool, int) const
    {71, 1591, 1292, 1, Smoke::mf_const, 351, 37},	//1743 KLocale::formatLong(long) const
    {71, 1572, 798, 1, Smoke::mf_const, 351, 38},	//1744 KLocale::formatByteSize(double) const
    {71, 1572, 1294, 4, Smoke::mf_const, 351, 39},	//1745 KLocale::formatByteSize(double, int, KLocale::BinaryUnitDialect, KLocale::BinarySizeUnits) const
    {71, 1081, 0, 0, Smoke::mf_const, 125, 40},	//1746 KLocale::binaryUnitDialect() const
    {71, 2527, 1299, 1, 0, 0, 41},	//1747 KLocale::setBinaryUnitDialect(KLocale::BinaryUnitDialect)
    {71, 1586, 1177, 1, Smoke::mf_const, 351, 42},	//1748 KLocale::formatDuration(unsigned long) const
    {71, 2256, 1177, 1, Smoke::mf_const, 351, 43},	//1749 KLocale::prettyFormatDuration(unsigned long) const
    {71, 2123, 0, 0, Smoke::mf_const, 450, 44},	//1750 KLocale::nounDeclension() const
    {71, 1577, 263, 2, Smoke::mf_const, 351, 45},	//1751 KLocale::formatDate(const QDate&, KLocale::DateFormat) const
    {71, 1582, 1301, 3, Smoke::mf_const, 351, 46},	//1752 KLocale::formatDateTime(const QDateTime&, KLocale::DateFormat, bool) const
    {71, 1582, 1305, 3, Smoke::mf_const, 351, 47},	//1753 KLocale::formatDateTime(const KDateTime&, KLocale::DateFormat, QFlags<KLocale::DateTimeFormatOption>) const
    {71, 1259, 0, 0, Smoke::mf_const, 450, 48},	//1754 KLocale::dateMonthNamePossessive() const
    {71, 1601, 1309, 3, Smoke::mf_const, 351, 49},	//1755 KLocale::formatTime(const QTime&, bool, bool) const
    {71, 1588, 1313, 2, Smoke::mf_const, 351, 50},	//1756 KLocale::formatLocaleTime(const QTime&, QFlags<KLocale::TimeFormatOption>) const
    {71, 1262, 0, 0, Smoke::mf_const, 133, 51},	//1757 KLocale::dateTimeDigitSet() const
    {71, 3205, 0, 0, Smoke::mf_const, 450, 52},	//1758 KLocale::use12Clock() const
    {71, 1277, 1316, 2, Smoke::mf_const, 351, 53},	//1759 KLocale::dayPeriodText(const QTime&, KLocale::DateTimeComponentFormat) const
    {71, 3272, 0, 0, Smoke::mf_const, 614, 54},	//1760 KLocale::weekStartDay() const
    {71, 3287, 0, 0, Smoke::mf_const, 614, 55},	//1761 KLocale::workingWeekStartDay() const
    {71, 3286, 0, 0, Smoke::mf_const, 614, 56},	//1762 KLocale::workingWeekEndDay() const
    {71, 3264, 0, 0, Smoke::mf_const, 614, 57},	//1763 KLocale::weekDayOfPray() const
    {71, 1090, 0, 0, Smoke::mf_const, 462, 58},	//1764 KLocale::calendar() const
    {71, 1100, 0, 0, Smoke::mf_const, 351, 59},	//1765 KLocale::calendarType() const
    {71, 1094, 0, 0, Smoke::mf_const, 126, 60},	//1766 KLocale::calendarSystem() const
    {71, 2531, 30, 1, 0, 0, 61},	//1767 KLocale::setCalendar(const QString&)
    {71, 2533, 177, 1, 0, 0, 62},	//1768 KLocale::setCalendarSystem(KLocale::CalendarSystem)
    {71, 2918, 1319, 1, 0, 0, 63},	//1769 KLocale::setWeekNumberSystem(KLocale::WeekNumberSystem)
    {71, 3271, 0, 0, 0, 140, 64},	//1770 KLocale::weekNumberSystem()
    {71, 3271, 0, 0, Smoke::mf_const, 140, 65},	//1771 KLocale::weekNumberSystem() const
    {71, 2368, 280, 2, Smoke::mf_const, 610, 66},	//1772 KLocale::readMoney(const QString&, bool*) const
    {71, 2372, 280, 2, Smoke::mf_const, 610, 67},	//1773 KLocale::readNumber(const QString&, bool*) const
    {71, 2338, 280, 2, Smoke::mf_const, 276, 68},	//1774 KLocale::readDate(const QString&, bool*) const
    {71, 2338, 287, 3, Smoke::mf_const, 276, 69},	//1775 KLocale::readDate(const QString&, const QString&, bool*) const
    {71, 2338, 283, 3, Smoke::mf_const, 276, 70},	//1776 KLocale::readDate(const QString&, KLocale::ReadDateFlags, bool*) const
    {71, 2379, 280, 2, Smoke::mf_const, 361, 71},	//1777 KLocale::readTime(const QString&, bool*) const
    {71, 2379, 1321, 3, Smoke::mf_const, 361, 72},	//1778 KLocale::readTime(const QString&, KLocale::ReadTimeFlags, bool*) const
    {71, 2363, 1325, 4, Smoke::mf_const, 361, 73},	//1779 KLocale::readLocaleTime(const QString&, bool*, QFlags<KLocale::TimeFormatOption>, QFlags<KLocale::TimeProcessingOption>) const
    {71, 1947, 0, 0, Smoke::mf_const, 351, 74},	//1780 KLocale::language() const
    {71, 1200, 0, 0, Smoke::mf_const, 351, 75},	//1781 KLocale::country() const
    {71, 1204, 0, 0, Smoke::mf_const, 351, 76},	//1782 KLocale::countryDivisionCode() const
    {71, 1952, 0, 0, Smoke::mf_const, 354, 77},	//1783 KLocale::languageList() const
    {71, 1225, 0, 0, Smoke::mf_const, 354, 78},	//1784 KLocale::currencyCodeList() const
    {71, 1406, 0, 0, Smoke::mf_const, 546, 79},	//1785 KLocale::encoding() const
    {71, 1410, 0, 0, Smoke::mf_const, 614, 80},	//1786 KLocale::encodingMib() const
    {71, 1153, 0, 0, Smoke::mf_const, 359, 81},	//1787 KLocale::codecForEncoding() const
    {71, 1496, 0, 0, Smoke::mf_const, 614, 82},	//1788 KLocale::fileEncodingMib() const
    {71, 2576, 30, 1, 0, 0, 83},	//1789 KLocale::setDateFormat(const QString&)
    {71, 2578, 30, 1, 0, 0, 84},	//1790 KLocale::setDateFormatShort(const QString&)
    {71, 2582, 103, 1, 0, 0, 85},	//1791 KLocale::setDateMonthNamePossessive(bool)
    {71, 2890, 30, 1, 0, 0, 86},	//1792 KLocale::setTimeFormat(const QString&)
    {71, 2588, 1330, 1, 0, 0, 87},	//1793 KLocale::setDateTimeDigitSet(KLocale::DigitSet)
    {71, 2920, 118, 1, 0, 0, 88},	//1794 KLocale::setWeekStartDay(int)
    {71, 2926, 118, 1, 0, 0, 89},	//1795 KLocale::setWorkingWeekStartDay(int)
    {71, 2924, 118, 1, 0, 0, 90},	//1796 KLocale::setWorkingWeekEndDay(int)
    {71, 2916, 118, 1, 0, 0, 91},	//1797 KLocale::setWeekDayOfPray(int)
    {71, 1256, 0, 0, Smoke::mf_const, 351, 92},	//1798 KLocale::dateFormat() const
    {71, 1257, 0, 0, Smoke::mf_const, 351, 93},	//1799 KLocale::dateFormatShort() const
    {71, 3096, 0, 0, Smoke::mf_const, 351, 94},	//1800 KLocale::timeFormat() const
    {71, 2592, 30, 1, 0, 0, 95},	//1801 KLocale::setDecimalSymbol(const QString&)
    {71, 2886, 30, 1, 0, 0, 96},	//1802 KLocale::setThousandsSeparator(const QString&)
    {71, 2823, 30, 1, 0, 0, 97},	//1803 KLocale::setPositiveSign(const QString&)
    {71, 2788, 30, 1, 0, 0, 98},	//1804 KLocale::setNegativeSign(const QString&)
    {71, 2607, 1330, 1, 0, 0, 99},	//1805 KLocale::setDigitSet(KLocale::DigitSet)
    {71, 2819, 1332, 1, 0, 0, 100},	//1806 KLocale::setPositiveMonetarySignPosition(KLocale::SignPosition)
    {71, 2784, 1332, 1, 0, 0, 101},	//1807 KLocale::setNegativeMonetarySignPosition(KLocale::SignPosition)
    {71, 2821, 103, 1, 0, 0, 102},	//1808 KLocale::setPositivePrefixCurrencySymbol(bool)
    {71, 2786, 103, 1, 0, 0, 103},	//1809 KLocale::setNegativePrefixCurrencySymbol(bool)
    {71, 2646, 118, 1, 0, 0, 104},	//1810 KLocale::setFracDigits(int)
    {71, 2590, 118, 1, 0, 0, 105},	//1811 KLocale::setDecimalPlaces(int)
    {71, 2774, 118, 1, 0, 0, 106},	//1812 KLocale::setMonetaryDecimalPlaces(int)
    {71, 2780, 30, 1, 0, 0, 107},	//1813 KLocale::setMonetaryThousandsSeparator(const QString&)
    {71, 2776, 30, 1, 0, 0, 108},	//1814 KLocale::setMonetaryDecimalSymbol(const QString&)
    {71, 2555, 30, 1, 0, 0, 109},	//1815 KLocale::setCurrencyCode(const QString&)
    {71, 2557, 30, 1, 0, 0, 110},	//1816 KLocale::setCurrencySymbol(const QString&)
    {71, 2778, 1330, 1, 0, 0, 111},	//1817 KLocale::setMonetaryDigitSet(KLocale::DigitSet)
    {71, 2211, 0, 0, Smoke::mf_const, 614, 112},	//1818 KLocale::pageSize() const
    {71, 2804, 118, 1, 0, 0, 113},	//1819 KLocale::setPageSize(int)
    {71, 2055, 0, 0, Smoke::mf_const, 134, 114},	//1820 KLocale::measureSystem() const
    {71, 2764, 1334, 1, 0, 0, 115},	//1821 KLocale::setMeasureSystem(KLocale::MeasureSystem)
    {71, 1742, 30, 1, 0, 0, 116},	//1822 KLocale::insertCatalog(const QString&)
    {71, 2416, 30, 1, 0, 0, 117},	//1823 KLocale::removeCatalog(const QString&)
    {71, 2498, 30, 1, 0, 0, 118},	//1824 KLocale::setActiveCatalog(const QString&)
    {71, 3160, 1336, 3, Smoke::mf_const, 351, 119},	//1825 KLocale::translateQt(const char*, const char*, const char*) const
    {71, 1010, 0, 0, Smoke::mf_const, 354, 120},	//1826 KLocale::allLanguagesList() const
    {71, 1746, 0, 0, Smoke::mf_const, 354, 121},	//1827 KLocale::installedLanguages() const
    {71, 1948, 30, 1, Smoke::mf_const, 351, 122},	//1828 KLocale::languageCodeToName(const QString&) const
    {71, 1004, 0, 0, Smoke::mf_const, 354, 123},	//1829 KLocale::allCountriesList() const
    {71, 1202, 30, 1, Smoke::mf_const, 351, 124},	//1830 KLocale::countryCodeToName(const QString&) const
    {71, 2966, 1340, 5, Smoke::mf_static, 0, 125},	//1831 KLocale::splitLocale(const QString&, QString&, QString&, QString&, QString&)
    {71, 2752, 122, 1, Smoke::mf_static, 0, 126},	//1832 KLocale::setMainCatalog(const char*)
    {71, 1944, 524, 2, Smoke::mf_static, 351, 127},	//1833 KLocale::langLookup(const QString&, const char*)
    {71, 1322, 0, 0, Smoke::mf_static, 351, 128},	//1834 KLocale::defaultLanguage()
    {71, 1320, 0, 0, Smoke::mf_static, 351, 129},	//1835 KLocale::defaultCountry()
    {71, 1321, 0, 0, Smoke::mf_static, 351, 130},	//1836 KLocale::defaultCurrencyCode()
    {71, 3208, 0, 0, Smoke::mf_const, 450, 131},	//1837 KLocale::useTranscript() const
    {71, 1774, 30, 1, 0, 450, 132},	//1838 KLocale::isApplicationTranslatedInto(const QString&)
    {71, 1190, 1156, 1, 0, 0, 133},	//1839 KLocale::copyCatalogsTo(KLocale*)
    {71, 2551, 467, 2, 0, 450, 134},	//1840 KLocale::setCountry(const QString&, KConfig*)
    {71, 2553, 30, 1, 0, 450, 135},	//1841 KLocale::setCountryDivisionCode(const QString&)
    {71, 2674, 467, 2, 0, 450, 136},	//1842 KLocale::setLanguage(const QString&, KConfig*)
    {71, 2674, 141, 1, 0, 450, 137},	//1843 KLocale::setLanguage(const QStringList&)
    {71, 1988, 30, 1, Smoke::mf_const, 351, 138},	//1844 KLocale::localizedFilePath(const QString&) const
    {71, 2414, 30, 1, Smoke::mf_const, 351, 139},	//1845 KLocale::removeAcceleratorMarker(const QString&) const
    {71, 1187, 1346, 3, Smoke::mf_const, 351, 140},	//1846 KLocale::convertDigits(const QString&, KLocale::DigitSet, bool) const
    {71, 2431, 0, 0, 0, 0, 141},	//1847 KLocale::reparseConfiguration()
    {71, 398, 30, 1, Smoke::mf_ctor, 123, 142},	//1848 KLocale::KLocale(const QString&)
    {71, 398, 95, 2, Smoke::mf_ctor, 123, 143},	//1849 KLocale::KLocale(const QString&, const QString&)
    {71, 398, 1350, 3, Smoke::mf_ctor, 123, 144},	//1850 KLocale::KLocale(const QString&, const QString&, const QString&)
    {71, 1370, 1330, 1, Smoke::mf_const, 351, 145},	//1851 KLocale::digitSetToName(KLocale::DigitSet) const
    {71, 1593, 798, 1, Smoke::mf_const, 351, 146},	//1852 KLocale::formatMoney(double) const
    {71, 1593, 1354, 2, Smoke::mf_const, 351, 147},	//1853 KLocale::formatMoney(double, const QString&) const
    {71, 1597, 798, 1, Smoke::mf_const, 351, 148},	//1854 KLocale::formatNumber(double) const
    {71, 1597, 30, 1, Smoke::mf_const, 351, 149},	//1855 KLocale::formatNumber(const QString&) const
    {71, 1597, 1357, 2, Smoke::mf_const, 351, 150},	//1856 KLocale::formatNumber(const QString&, bool) const
    {71, 1572, 1285, 2, Smoke::mf_const, 351, 151},	//1857 KLocale::formatByteSize(double, int) const
    {71, 1572, 1360, 3, Smoke::mf_const, 351, 152},	//1858 KLocale::formatByteSize(double, int, KLocale::BinaryUnitDialect) const
    {71, 1577, 196, 1, Smoke::mf_const, 351, 153},	//1859 KLocale::formatDate(const QDate&) const
    {71, 1582, 1037, 1, Smoke::mf_const, 351, 154},	//1860 KLocale::formatDateTime(const QDateTime&) const
    {71, 1582, 1364, 2, Smoke::mf_const, 351, 155},	//1861 KLocale::formatDateTime(const QDateTime&, KLocale::DateFormat) const
    {71, 1582, 1039, 1, Smoke::mf_const, 351, 156},	//1862 KLocale::formatDateTime(const KDateTime&) const
    {71, 1582, 1367, 2, Smoke::mf_const, 351, 157},	//1863 KLocale::formatDateTime(const KDateTime&, KLocale::DateFormat) const
    {71, 1601, 1045, 1, Smoke::mf_const, 351, 158},	//1864 KLocale::formatTime(const QTime&) const
    {71, 1601, 1370, 2, Smoke::mf_const, 351, 159},	//1865 KLocale::formatTime(const QTime&, bool) const
    {71, 1588, 1045, 1, Smoke::mf_const, 351, 160},	//1866 KLocale::formatLocaleTime(const QTime&) const
    {71, 1277, 1045, 1, Smoke::mf_const, 351, 161},	//1867 KLocale::dayPeriodText(const QTime&) const
    {71, 2368, 30, 1, Smoke::mf_const, 610, 162},	//1868 KLocale::readMoney(const QString&) const
    {71, 2372, 30, 1, Smoke::mf_const, 610, 163},	//1869 KLocale::readNumber(const QString&) const
    {71, 2338, 30, 1, Smoke::mf_const, 276, 164},	//1870 KLocale::readDate(const QString&) const
    {71, 2338, 95, 2, Smoke::mf_const, 276, 165},	//1871 KLocale::readDate(const QString&, const QString&) const
    {71, 2338, 332, 2, Smoke::mf_const, 276, 166},	//1872 KLocale::readDate(const QString&, KLocale::ReadDateFlags) const
    {71, 2379, 30, 1, Smoke::mf_const, 361, 167},	//1873 KLocale::readTime(const QString&) const
    {71, 2379, 1373, 2, Smoke::mf_const, 361, 168},	//1874 KLocale::readTime(const QString&, KLocale::ReadTimeFlags) const
    {71, 2363, 30, 1, Smoke::mf_const, 361, 169},	//1875 KLocale::readLocaleTime(const QString&) const
    {71, 2363, 280, 2, Smoke::mf_const, 361, 170},	//1876 KLocale::readLocaleTime(const QString&, bool*) const
    {71, 2363, 1376, 3, Smoke::mf_const, 361, 171},	//1877 KLocale::readLocaleTime(const QString&, bool*, QFlags<KLocale::TimeFormatOption>) const
    {71, 1944, 30, 1, Smoke::mf_static, 351, 172},	//1878 KLocale::langLookup(const QString&)
    {71, 1187, 1380, 2, Smoke::mf_const, 351, 173},	//1879 KLocale::convertDigits(const QString&, KLocale::DigitSet) const
    {71, 655, 0, 0, Smoke::mf_static|Smoke::mf_enum, 137, 174},	//1880 KLocale::ParensAround (enum)
    {71, 43, 0, 0, Smoke::mf_static|Smoke::mf_enum, 137, 175},	//1881 KLocale::BeforeQuantityMoney (enum)
    {71, 16, 0, 0, Smoke::mf_static|Smoke::mf_enum, 137, 176},	//1882 KLocale::AfterQuantityMoney (enum)
    {71, 42, 0, 0, Smoke::mf_static|Smoke::mf_enum, 137, 177},	//1883 KLocale::BeforeMoney (enum)
    {71, 15, 0, 0, Smoke::mf_static|Smoke::mf_enum, 137, 178},	//1884 KLocale::AfterMoney (enum)
    {71, 23, 0, 0, Smoke::mf_static|Smoke::mf_enum, 133, 179},	//1885 KLocale::ArabicDigits (enum)
    {71, 24, 0, 0, Smoke::mf_static|Smoke::mf_enum, 133, 180},	//1886 KLocale::ArabicIndicDigits (enum)
    {71, 110, 0, 0, Smoke::mf_static|Smoke::mf_enum, 133, 181},	//1887 KLocale::EasternArabicIndicDigits (enum)
    {71, 103, 0, 0, Smoke::mf_static|Smoke::mf_enum, 133, 182},	//1888 KLocale::DevenagariDigits (enum)
    {71, 44, 0, 0, Smoke::mf_static|Smoke::mf_enum, 133, 183},	//1889 KLocale::BengaliDigits (enum)
    {71, 154, 0, 0, Smoke::mf_static|Smoke::mf_enum, 133, 184},	//1890 KLocale::GujaratiDigits (enum)
    {71, 155, 0, 0, Smoke::mf_static|Smoke::mf_enum, 133, 185},	//1891 KLocale::GurmukhiDigits (enum)
    {71, 557, 0, 0, Smoke::mf_static|Smoke::mf_enum, 133, 186},	//1892 KLocale::KannadaDigits (enum)
    {71, 561, 0, 0, Smoke::mf_static|Smoke::mf_enum, 133, 187},	//1893 KLocale::KhmerDigits (enum)
    {71, 601, 0, 0, Smoke::mf_static|Smoke::mf_enum, 133, 188},	//1894 KLocale::MalayalamDigits (enum)
    {71, 652, 0, 0, Smoke::mf_static|Smoke::mf_enum, 133, 189},	//1895 KLocale::OriyaDigits (enum)
    {71, 748, 0, 0, Smoke::mf_static|Smoke::mf_enum, 133, 190},	//1896 KLocale::TamilDigits (enum)
    {71, 750, 0, 0, Smoke::mf_static|Smoke::mf_enum, 133, 191},	//1897 KLocale::TeluguDigits (enum)
    {71, 754, 0, 0, Smoke::mf_static|Smoke::mf_enum, 133, 192},	//1898 KLocale::ThaiDigits (enum)
    {71, 96, 0, 0, Smoke::mf_static|Smoke::mf_enum, 124, 193},	//1899 KLocale::DefaultBinaryUnits (enum)
    {71, 779, 0, 0, Smoke::mf_static|Smoke::mf_enum, 124, 194},	//1900 KLocale::UnitByte (enum)
    {71, 782, 0, 0, Smoke::mf_static|Smoke::mf_enum, 124, 195},	//1901 KLocale::UnitKiloByte (enum)
    {71, 784, 0, 0, Smoke::mf_static|Smoke::mf_enum, 124, 196},	//1902 KLocale::UnitMegaByte (enum)
    {71, 781, 0, 0, Smoke::mf_static|Smoke::mf_enum, 124, 197},	//1903 KLocale::UnitGigaByte (enum)
    {71, 786, 0, 0, Smoke::mf_static|Smoke::mf_enum, 124, 198},	//1904 KLocale::UnitTeraByte (enum)
    {71, 785, 0, 0, Smoke::mf_static|Smoke::mf_enum, 124, 199},	//1905 KLocale::UnitPetaByte (enum)
    {71, 780, 0, 0, Smoke::mf_static|Smoke::mf_enum, 124, 200},	//1906 KLocale::UnitExaByte (enum)
    {71, 788, 0, 0, Smoke::mf_static|Smoke::mf_enum, 124, 201},	//1907 KLocale::UnitZettaByte (enum)
    {71, 787, 0, 0, Smoke::mf_static|Smoke::mf_enum, 124, 202},	//1908 KLocale::UnitYottaByte (enum)
    {71, 783, 0, 0, Smoke::mf_static|Smoke::mf_enum, 124, 203},	//1909 KLocale::UnitLastUnit (enum)
    {71, 95, 0, 0, Smoke::mf_static|Smoke::mf_enum, 125, 204},	//1910 KLocale::DefaultBinaryDialect (enum)
    {71, 166, 0, 0, Smoke::mf_static|Smoke::mf_enum, 125, 205},	//1911 KLocale::IECBinaryDialect (enum)
    {71, 271, 0, 0, Smoke::mf_static|Smoke::mf_enum, 125, 206},	//1912 KLocale::JEDECBinaryDialect (enum)
    {71, 604, 0, 0, Smoke::mf_static|Smoke::mf_enum, 125, 207},	//1913 KLocale::MetricBinaryDialect (enum)
    {71, 565, 0, 0, Smoke::mf_static|Smoke::mf_enum, 125, 208},	//1914 KLocale::LastBinaryDialect (enum)
    {71, 679, 0, 0, Smoke::mf_static|Smoke::mf_enum, 126, 209},	//1915 KLocale::QDateCalendar (enum)
    {71, 71, 0, 0, Smoke::mf_static|Smoke::mf_enum, 126, 210},	//1916 KLocale::CopticCalendar (enum)
    {71, 126, 0, 0, Smoke::mf_static|Smoke::mf_enum, 126, 211},	//1917 KLocale::EthiopianCalendar (enum)
    {71, 153, 0, 0, Smoke::mf_static|Smoke::mf_enum, 126, 212},	//1918 KLocale::GregorianCalendar (enum)
    {71, 157, 0, 0, Smoke::mf_static|Smoke::mf_enum, 126, 213},	//1919 KLocale::HebrewCalendar (enum)
    {71, 182, 0, 0, Smoke::mf_static|Smoke::mf_enum, 126, 214},	//1920 KLocale::IslamicCivilCalendar (enum)
    {71, 174, 0, 0, Smoke::mf_static|Smoke::mf_enum, 126, 215},	//1921 KLocale::IndianNationalCalendar (enum)
    {71, 272, 0, 0, Smoke::mf_static|Smoke::mf_enum, 126, 216},	//1922 KLocale::JalaliCalendar (enum)
    {71, 274, 0, 0, Smoke::mf_static|Smoke::mf_enum, 126, 217},	//1923 KLocale::JapaneseCalendar (enum)
    {71, 275, 0, 0, Smoke::mf_static|Smoke::mf_enum, 126, 218},	//1924 KLocale::JulianCalendar (enum)
    {71, 606, 0, 0, Smoke::mf_static|Smoke::mf_enum, 126, 219},	//1925 KLocale::MinguoCalendar (enum)
    {71, 753, 0, 0, Smoke::mf_static|Smoke::mf_enum, 126, 220},	//1926 KLocale::ThaiCalendar (enum)
    {71, 100, 0, 0, Smoke::mf_static|Smoke::mf_enum, 140, 221},	//1927 KLocale::DefaultWeekNumber (enum)
    {71, 189, 0, 0, Smoke::mf_static|Smoke::mf_enum, 140, 222},	//1928 KLocale::IsoWeekNumber (enum)
    {71, 141, 0, 0, Smoke::mf_static|Smoke::mf_enum, 140, 223},	//1929 KLocale::FirstFullWeek (enum)
    {71, 142, 0, 0, Smoke::mf_static|Smoke::mf_enum, 140, 224},	//1930 KLocale::FirstPartialWeek (enum)
    {71, 715, 0, 0, Smoke::mf_static|Smoke::mf_enum, 140, 225},	//1931 KLocale::SimpleWeek (enum)
    {71, 558, 0, 0, Smoke::mf_static|Smoke::mf_enum, 131, 226},	//1932 KLocale::KdeFormat (enum)
    {71, 669, 0, 0, Smoke::mf_static|Smoke::mf_enum, 131, 227},	//1933 KLocale::PosixFormat (enum)
    {71, 778, 0, 0, Smoke::mf_static|Smoke::mf_enum, 131, 228},	//1934 KLocale::UnicodeFormat (enum)
    {71, 571, 0, 0, Smoke::mf_static|Smoke::mf_enum, 132, 229},	//1935 KLocale::LiberalParsing (enum)
    {71, 820, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 230},	//1936 KLocale::Year (enum)
    {71, 822, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 231},	//1937 KLocale::YearName (enum)
    {71, 608, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 232},	//1938 KLocale::Month (enum)
    {71, 609, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 233},	//1939 KLocale::MonthName (enum)
    {71, 84, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 234},	//1940 KLocale::Day (enum)
    {71, 85, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 235},	//1941 KLocale::DayName (enum)
    {71, 276, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 236},	//1942 KLocale::JulianDay (enum)
    {71, 118, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 237},	//1943 KLocale::EraName (enum)
    {71, 119, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 238},	//1944 KLocale::EraYear (enum)
    {71, 821, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 239},	//1945 KLocale::YearInEra (enum)
    {71, 88, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 240},	//1946 KLocale::DayOfYear (enum)
    {71, 89, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 241},	//1947 KLocale::DayOfYearName (enum)
    {71, 86, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 242},	//1948 KLocale::DayOfWeek (enum)
    {71, 87, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 243},	//1949 KLocale::DayOfWeekName (enum)
    {71, 806, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 244},	//1950 KLocale::Week (enum)
    {71, 807, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 245},	//1951 KLocale::WeekYear (enum)
    {71, 610, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 246},	//1952 KLocale::MonthsInYear (enum)
    {71, 808, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 247},	//1953 KLocale::WeeksInYear (enum)
    {71, 94, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 248},	//1954 KLocale::DaysInYear (enum)
    {71, 92, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 249},	//1955 KLocale::DaysInMonth (enum)
    {71, 93, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 250},	//1956 KLocale::DaysInWeek (enum)
    {71, 165, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 251},	//1957 KLocale::Hour (enum)
    {71, 607, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 252},	//1958 KLocale::Minute (enum)
    {71, 704, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 253},	//1959 KLocale::Second (enum)
    {71, 605, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 254},	//1960 KLocale::Millisecond (enum)
    {71, 90, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 255},	//1961 KLocale::DayPeriod (enum)
    {71, 91, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 256},	//1962 KLocale::DayPeriodHour (enum)
    {71, 764, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 257},	//1963 KLocale::Timezone (enum)
    {71, 765, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 258},	//1964 KLocale::TimezoneName (enum)
    {71, 791, 0, 0, Smoke::mf_static|Smoke::mf_enum, 128, 259},	//1965 KLocale::UnixTime (enum)
    {71, 97, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 260},	//1966 KLocale::DefaultComponentFormat (enum)
    {71, 713, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 261},	//1967 KLocale::ShortNumber (enum)
    {71, 599, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 262},	//1968 KLocale::LongNumber (enum)
    {71, 615, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 263},	//1969 KLocale::NarrowName (enum)
    {71, 711, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 264},	//1970 KLocale::ShortName (enum)
    {71, 597, 0, 0, Smoke::mf_static|Smoke::mf_enum, 129, 265},	//1971 KLocale::LongName (enum)
    {71, 708, 0, 0, Smoke::mf_static|Smoke::mf_enum, 127, 266},	//1972 KLocale::ShortDate (enum)
    {71, 594, 0, 0, Smoke::mf_static|Smoke::mf_enum, 127, 267},	//1973 KLocale::LongDate (enum)
    {71, 137, 0, 0, Smoke::mf_static|Smoke::mf_enum, 127, 268},	//1974 KLocale::FancyShortDate (enum)
    {71, 136, 0, 0, Smoke::mf_static|Smoke::mf_enum, 127, 269},	//1975 KLocale::FancyLongDate (enum)
    {71, 183, 0, 0, Smoke::mf_static|Smoke::mf_enum, 127, 270},	//1976 KLocale::IsoDate (enum)
    {71, 187, 0, 0, Smoke::mf_static|Smoke::mf_enum, 127, 271},	//1977 KLocale::IsoWeekDate (enum)
    {71, 185, 0, 0, Smoke::mf_static|Smoke::mf_enum, 127, 272},	//1978 KLocale::IsoOrdinalDate (enum)
    {71, 762, 0, 0, Smoke::mf_static|Smoke::mf_enum, 130, 273},	//1979 KLocale::TimeZone (enum)
    {71, 705, 0, 0, Smoke::mf_static|Smoke::mf_enum, 130, 274},	//1980 KLocale::Seconds (enum)
    {71, 756, 0, 0, Smoke::mf_static|Smoke::mf_enum, 138, 275},	//1981 KLocale::TimeDefault (enum)
    {71, 761, 0, 0, Smoke::mf_static|Smoke::mf_enum, 138, 276},	//1982 KLocale::TimeWithoutSeconds (enum)
    {71, 760, 0, 0, Smoke::mf_static|Smoke::mf_enum, 138, 277},	//1983 KLocale::TimeWithoutAmPm (enum)
    {71, 757, 0, 0, Smoke::mf_static|Smoke::mf_enum, 138, 278},	//1984 KLocale::TimeDuration (enum)
    {71, 758, 0, 0, Smoke::mf_static|Smoke::mf_enum, 138, 279},	//1985 KLocale::TimeFoldHours (enum)
    {71, 636, 0, 0, Smoke::mf_static|Smoke::mf_enum, 135, 280},	//1986 KLocale::NormalFormat (enum)
    {71, 710, 0, 0, Smoke::mf_static|Smoke::mf_enum, 135, 281},	//1987 KLocale::ShortFormat (enum)
    {71, 184, 0, 0, Smoke::mf_static|Smoke::mf_enum, 135, 282},	//1988 KLocale::IsoFormat (enum)
    {71, 188, 0, 0, Smoke::mf_static|Smoke::mf_enum, 135, 283},	//1989 KLocale::IsoWeekFormat (enum)
    {71, 186, 0, 0, Smoke::mf_static|Smoke::mf_enum, 135, 284},	//1990 KLocale::IsoOrdinalFormat (enum)
    {71, 811, 0, 0, Smoke::mf_static|Smoke::mf_enum, 136, 285},	//1991 KLocale::WithSeconds (enum)
    {71, 812, 0, 0, Smoke::mf_static|Smoke::mf_enum, 136, 286},	//1992 KLocale::WithoutSeconds (enum)
    {71, 672, 0, 0, Smoke::mf_static|Smoke::mf_enum, 139, 287},	//1993 KLocale::ProcessStrict (enum)
    {71, 671, 0, 0, Smoke::mf_static|Smoke::mf_enum, 139, 288},	//1994 KLocale::ProcessNonStrict (enum)
    {71, 603, 0, 0, Smoke::mf_static|Smoke::mf_enum, 134, 289},	//1995 KLocale::Metric (enum)
    {71, 172, 0, 0, Smoke::mf_static|Smoke::mf_enum, 134, 290},	//1996 KLocale::Imperial (enum)
    {71, 3388, 0, 0, Smoke::mf_dtor, 0, 291 },	//1997 KLocale::~KLocale()
    {72, 405, 0, 0, Smoke::mf_ctor, 143, 1},	//1998 KLocalizedString::KLocalizedString()
    {72, 405, 28, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 143, 2},	//1999 KLocalizedString::KLocalizedString(const KLocalizedString&)
    {72, 2182, 28, 1, 0, 142, 3},	//2000 KLocalizedString::operator=(const KLocalizedString&)
    {72, 3112, 0, 0, Smoke::mf_const, 351, 4},	//2001 KLocalizedString::toString() const
    {72, 3112, 30, 1, Smoke::mf_const, 351, 5},	//2002 KLocalizedString::toString(const QString&) const
    {72, 3112, 179, 1, Smoke::mf_const, 351, 6},	//2003 KLocalizedString::toString(const KLocale*) const
    {72, 3112, 1383, 2, Smoke::mf_const, 351, 7},	//2004 KLocalizedString::toString(const KLocale*, const QString&) const
    {72, 1807, 0, 0, Smoke::mf_const, 450, 8},	//2005 KLocalizedString::isEmpty() const
    {72, 3045, 1386, 4, Smoke::mf_const, 141, 9},	//2006 KLocalizedString::subs(int, int, int, const QChar&) const
    {72, 3045, 1391, 4, Smoke::mf_const, 141, 10},	//2007 KLocalizedString::subs(unsigned int, int, int, const QChar&) const
    {72, 3045, 1396, 4, Smoke::mf_const, 141, 11},	//2008 KLocalizedString::subs(long, int, int, const QChar&) const
    {72, 3045, 1401, 4, Smoke::mf_const, 141, 12},	//2009 KLocalizedString::subs(unsigned long, int, int, const QChar&) const
    {72, 3045, 1406, 4, Smoke::mf_const, 141, 13},	//2010 KLocalizedString::subs(long long, int, int, const QChar&) const
    {72, 3045, 1411, 4, Smoke::mf_const, 141, 14},	//2011 KLocalizedString::subs(unsigned long long, int, int, const QChar&) const
    {72, 3045, 1416, 5, Smoke::mf_const, 141, 15},	//2012 KLocalizedString::subs(double, int, char, int, const QChar&) const
    {72, 3045, 1422, 3, Smoke::mf_const, 141, 16},	//2013 KLocalizedString::subs(QChar, int, const QChar&) const
    {72, 3045, 1426, 3, Smoke::mf_const, 141, 17},	//2014 KLocalizedString::subs(const QString&, int, const QChar&) const
    {72, 1722, 95, 2, Smoke::mf_const, 141, 18},	//2015 KLocalizedString::inContext(const QString&, const QString&) const
    {72, 2121, 1430, 2, Smoke::mf_static, 0, 19},	//2016 KLocalizedString::notifyCatalogsUpdated(const QStringList&, const QList<KCatalogName>&)
    {72, 3045, 118, 1, Smoke::mf_const, 141, 20},	//2017 KLocalizedString::subs(int) const
    {72, 3045, 188, 2, Smoke::mf_const, 141, 21},	//2018 KLocalizedString::subs(int, int) const
    {72, 3045, 184, 3, Smoke::mf_const, 141, 22},	//2019 KLocalizedString::subs(int, int, int) const
    {72, 3045, 952, 1, Smoke::mf_const, 141, 23},	//2020 KLocalizedString::subs(unsigned int) const
    {72, 3045, 1433, 2, Smoke::mf_const, 141, 24},	//2021 KLocalizedString::subs(unsigned int, int) const
    {72, 3045, 1436, 3, Smoke::mf_const, 141, 25},	//2022 KLocalizedString::subs(unsigned int, int, int) const
    {72, 3045, 1292, 1, Smoke::mf_const, 141, 26},	//2023 KLocalizedString::subs(long) const
    {72, 3045, 1440, 2, Smoke::mf_const, 141, 27},	//2024 KLocalizedString::subs(long, int) const
    {72, 3045, 1443, 3, Smoke::mf_const, 141, 28},	//2025 KLocalizedString::subs(long, int, int) const
    {72, 3045, 1177, 1, Smoke::mf_const, 141, 29},	//2026 KLocalizedString::subs(unsigned long) const
    {72, 3045, 1447, 2, Smoke::mf_const, 141, 30},	//2027 KLocalizedString::subs(unsigned long, int) const
    {72, 3045, 1450, 3, Smoke::mf_const, 141, 31},	//2028 KLocalizedString::subs(unsigned long, int, int) const
    {72, 3045, 861, 1, Smoke::mf_const, 141, 32},	//2029 KLocalizedString::subs(long long) const
    {72, 3045, 1454, 2, Smoke::mf_const, 141, 33},	//2030 KLocalizedString::subs(long long, int) const
    {72, 3045, 1457, 3, Smoke::mf_const, 141, 34},	//2031 KLocalizedString::subs(long long, int, int) const
    {72, 3045, 965, 1, Smoke::mf_const, 141, 35},	//2032 KLocalizedString::subs(unsigned long long) const
    {72, 3045, 1461, 2, Smoke::mf_const, 141, 36},	//2033 KLocalizedString::subs(unsigned long long, int) const
    {72, 3045, 1464, 3, Smoke::mf_const, 141, 37},	//2034 KLocalizedString::subs(unsigned long long, int, int) const
    {72, 3045, 798, 1, Smoke::mf_const, 141, 38},	//2035 KLocalizedString::subs(double) const
    {72, 3045, 1285, 2, Smoke::mf_const, 141, 39},	//2036 KLocalizedString::subs(double, int) const
    {72, 3045, 1468, 3, Smoke::mf_const, 141, 40},	//2037 KLocalizedString::subs(double, int, char) const
    {72, 3045, 1472, 4, Smoke::mf_const, 141, 41},	//2038 KLocalizedString::subs(double, int, char, int) const
    {72, 3045, 340, 1, Smoke::mf_const, 141, 42},	//2039 KLocalizedString::subs(QChar) const
    {72, 3045, 1477, 2, Smoke::mf_const, 141, 43},	//2040 KLocalizedString::subs(QChar, int) const
    {72, 3045, 30, 1, Smoke::mf_const, 141, 44},	//2041 KLocalizedString::subs(const QString&) const
    {72, 3045, 1014, 2, Smoke::mf_const, 141, 45},	//2042 KLocalizedString::subs(const QString&, int) const
    {72, 3389, 0, 0, Smoke::mf_dtor, 0, 46 },	//2043 KLocalizedString::~KLocalizedString()
    {73, 407, 1202, 2, Smoke::mf_ctor, 144, 1},	//2044 KLockFile::KLockFile(const QString&, const KComponentData&)
    {73, 2003, 1480, 1, 0, 146, 2},	//2045 KLockFile::lock(QFlags<KLockFile::LockFlag>)
    {73, 1836, 0, 0, Smoke::mf_const, 450, 3},	//2046 KLockFile::isLocked() const
    {73, 3184, 0, 0, 0, 0, 4},	//2047 KLockFile::unlock()
    {73, 2971, 0, 0, Smoke::mf_const, 614, 5},	//2048 KLockFile::staleTime() const
    {73, 2874, 118, 1, 0, 0, 6},	//2049 KLockFile::setStaleTime(int)
    {73, 1641, 1482, 3, 0, 450, 7},	//2050 KLockFile::getLockInfo(int&, QString&, QString&)
    {73, 407, 1486, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 144, 8},	//2051 KLockFile::KLockFile(const KLockFile&)
    {73, 407, 30, 1, Smoke::mf_ctor, 144, 9},	//2052 KLockFile::KLockFile(const QString&)
    {73, 2003, 0, 0, 0, 146, 10},	//2053 KLockFile::lock()
    {73, 592, 0, 0, Smoke::mf_static|Smoke::mf_enum, 146, 11},	//2054 KLockFile::LockOK (enum)
    {73, 591, 0, 0, Smoke::mf_static|Smoke::mf_enum, 146, 12},	//2055 KLockFile::LockFail (enum)
    {73, 590, 0, 0, Smoke::mf_static|Smoke::mf_enum, 146, 13},	//2056 KLockFile::LockError (enum)
    {73, 593, 0, 0, Smoke::mf_static|Smoke::mf_enum, 146, 14},	//2057 KLockFile::LockStale (enum)
    {73, 618, 0, 0, Smoke::mf_static|Smoke::mf_enum, 145, 15},	//2058 KLockFile::NoBlockFlag (enum)
    {73, 143, 0, 0, Smoke::mf_static|Smoke::mf_enum, 145, 16},	//2059 KLockFile::ForceFlag (enum)
    {73, 3390, 0, 0, Smoke::mf_dtor, 0, 17 },	//2060 KLockFile::~KLockFile()
    {74, 411, 0, 0, Smoke::mf_ctor, 147, 1},	//2061 KMD5::KMD5()
    {74, 411, 1108, 2, Smoke::mf_ctor, 147, 2},	//2062 KMD5::KMD5(const char*, int)
    {74, 411, 32, 1, Smoke::mf_ctor, 147, 3},	//2063 KMD5::KMD5(const QByteArray&)
    {74, 3192, 1108, 2, 0, 0, 4},	//2064 KMD5::update(const char*, int)
    {74, 3192, 1488, 2, 0, 0, 5},	//2065 KMD5::update(const unsigned char*, int)
    {74, 3192, 32, 1, 0, 0, 6},	//2066 KMD5::update(const QByteArray&)
    {74, 3192, 1491, 1, 0, 450, 7},	//2067 KMD5::update(QIODevice&)
    {74, 2438, 0, 0, 0, 0, 8},	//2068 KMD5::reset()
    {74, 2323, 0, 0, 0, 605, 9},	//2069 KMD5::rawDigest()
    {74, 2323, 1493, 1, 0, 0, 10},	//2070 KMD5::rawDigest(unsigned char(&)[16])
    {74, 1704, 0, 0, 0, 264, 11},	//2071 KMD5::hexDigest()
    {74, 1704, 1495, 1, 0, 0, 12},	//2072 KMD5::hexDigest(QByteArray&)
    {74, 1072, 0, 0, 0, 264, 13},	//2073 KMD5::base64Digest()
    {74, 3231, 1497, 1, 0, 450, 14},	//2074 KMD5::verify(const unsigned char(&)[16])
    {74, 3231, 32, 1, 0, 450, 15},	//2075 KMD5::verify(const QByteArray&)
    {74, 3142, 1499, 1, Smoke::mf_protected, 0, 16},	//2076 KMD5::transform(const unsigned char[64])
    {74, 1502, 0, 0, Smoke::mf_protected, 0, 17},	//2077 KMD5::finalize()
    {74, 411, 122, 1, Smoke::mf_ctor, 147, 18},	//2078 KMD5::KMD5(const char*)
    {74, 3192, 122, 1, 0, 0, 19},	//2079 KMD5::update(const char*)
    {74, 3192, 1501, 1, 0, 0, 20},	//2080 KMD5::update(const unsigned char*)
    {74, 3391, 0, 0, Smoke::mf_dtor, 0, 21 },	//2081 KMD5::~KMD5()
    {75, 1468, 1503, 3, Smoke::mf_static, 351, 1},	//2082 KMacroExpander::expandMacros(const QString&, const QHash<QChar,QString>&, QChar)
    {75, 1468, 1507, 2, Smoke::mf_static, 351, 2},	//2083 KMacroExpander::expandMacros(const QString&, const QHash<QChar,QString>&)
    {75, 1472, 1503, 3, Smoke::mf_static, 351, 3},	//2084 KMacroExpander::expandMacrosShellQuote(const QString&, const QHash<QChar,QString>&, QChar)
    {75, 1472, 1507, 2, Smoke::mf_static, 351, 4},	//2085 KMacroExpander::expandMacrosShellQuote(const QString&, const QHash<QChar,QString>&)
    {75, 1472, 1510, 3, Smoke::mf_static, 351, 5},	//2086 KMacroExpander::expandMacrosShellQuote(const QString&, const QHash<QString,QStringList>&, QChar)
    {75, 1472, 1514, 2, Smoke::mf_static, 351, 6},	//2087 KMacroExpander::expandMacrosShellQuote(const QString&, const QHash<QString,QStringList>&)
    {75, 1468, 1517, 3, Smoke::mf_static, 351, 7},	//2088 KMacroExpander::expandMacros(const QString&, const QHash<QChar,QStringList>&, QChar)
    {75, 1468, 1521, 2, Smoke::mf_static, 351, 8},	//2089 KMacroExpander::expandMacros(const QString&, const QHash<QChar,QStringList>&)
    {75, 1472, 1524, 3, Smoke::mf_static, 351, 9},	//2090 KMacroExpander::expandMacrosShellQuote(const QString&, const QHash<QString,QString>&, QChar)
    {75, 1472, 1528, 2, Smoke::mf_static, 351, 10},	//2091 KMacroExpander::expandMacrosShellQuote(const QString&, const QHash<QString,QString>&)
    {75, 1468, 1510, 3, Smoke::mf_static, 351, 11},	//2092 KMacroExpander::expandMacros(const QString&, const QHash<QString,QStringList>&, QChar)
    {75, 1468, 1514, 2, Smoke::mf_static, 351, 12},	//2093 KMacroExpander::expandMacros(const QString&, const QHash<QString,QStringList>&)
    {75, 1468, 1524, 3, Smoke::mf_static, 351, 13},	//2094 KMacroExpander::expandMacros(const QString&, const QHash<QString,QString>&, QChar)
    {75, 1468, 1528, 2, Smoke::mf_static, 351, 14},	//2095 KMacroExpander::expandMacros(const QString&, const QHash<QString,QString>&)
    {75, 1472, 1517, 3, Smoke::mf_static, 351, 15},	//2096 KMacroExpander::expandMacrosShellQuote(const QString&, const QHash<QChar,QStringList>&, QChar)
    {75, 1472, 1521, 2, Smoke::mf_static, 351, 16},	//2097 KMacroExpander::expandMacrosShellQuote(const QString&, const QHash<QChar,QStringList>&)
    {76, 415, 340, 1, Smoke::mf_ctor, 148, 1},	//2098 KMacroExpanderBase::KMacroExpanderBase(QChar)
    {76, 1468, 1531, 1, 0, 0, 2},	//2099 KMacroExpanderBase::expandMacros(QString&)
    {76, 1472, 1533, 2, 0, 450, 3},	//2100 KMacroExpanderBase::expandMacrosShellQuote(QString&, int&)
    {76, 1472, 1531, 1, 0, 450, 4},	//2101 KMacroExpanderBase::expandMacrosShellQuote(QString&)
    {76, 2629, 340, 1, 0, 0, 5},	//2102 KMacroExpanderBase::setEscapeChar(QChar)
    {76, 1442, 0, 0, Smoke::mf_const, 266, 6},	//2103 KMacroExpanderBase::escapeChar() const
    {76, 1477, 342, 3, Smoke::mf_protected|Smoke::mf_virtual, 614, 7},	//2104 KMacroExpanderBase::expandPlainMacro(const QString&, int, QStringList&)
    {76, 1463, 342, 3, Smoke::mf_protected|Smoke::mf_virtual, 614, 8},	//2105 KMacroExpanderBase::expandEscapedMacro(const QString&, int, QStringList&)
    {76, 415, 1536, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 148, 9},	//2106 KMacroExpanderBase::KMacroExpanderBase(const KMacroExpanderBase&)
    {76, 415, 0, 0, Smoke::mf_ctor, 148, 10},	//2107 KMacroExpanderBase::KMacroExpanderBase()
    {76, 3392, 0, 0, Smoke::mf_dtor, 0, 11 },	//2108 KMacroExpanderBase::~KMacroExpanderBase()
    {77, 2768, 1538, 1, Smoke::mf_static, 0, 1},	//2109 KMessage::setMessageHandler(KMessageHandler*)
    {77, 2057, 1540, 3, Smoke::mf_static, 0, 2},	//2110 KMessage::message(KMessage::MessageType, const QString&, const QString&)
    {77, 2057, 1544, 2, Smoke::mf_static, 0, 3},	//2111 KMessage::message(KMessage::MessageType, const QString&)
    {77, 125, 0, 0, Smoke::mf_static|Smoke::mf_enum, 149, 4},	//2112 KMessage::Error (enum)
    {77, 175, 0, 0, Smoke::mf_static|Smoke::mf_enum, 149, 5},	//2113 KMessage::Information (enum)
    {77, 805, 0, 0, Smoke::mf_static|Smoke::mf_enum, 149, 6},	//2114 KMessage::Warning (enum)
    {77, 723, 0, 0, Smoke::mf_static|Smoke::mf_enum, 149, 7},	//2115 KMessage::Sorry (enum)
    {77, 138, 0, 0, Smoke::mf_static|Smoke::mf_enum, 149, 8},	//2116 KMessage::Fatal (enum)
    {78, 2057, 1540, 3, Smoke::mf_virtual|Smoke::mf_purevirtual, 0, 1},	//2117 KMessageHandler::message(KMessage::MessageType, const QString&, const QString&) [pure virtual]
    {78, 417, 0, 0, Smoke::mf_ctor, 150, 2},	//2118 KMessageHandler::KMessageHandler()
    {78, 417, 1547, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 150, 3},	//2119 KMessageHandler::KMessageHandler(const KMessageHandler&)
    {78, 3393, 0, 0, Smoke::mf_dtor, 0, 4 },	//2120 KMessageHandler::~KMessageHandler()
    {79, 1715, 148, 1, Smoke::mf_const, 351, 1},	//2121 KMimeType::iconName(const KUrl&) const
    {79, 1717, 1549, 2, Smoke::mf_static, 351, 2},	//2122 KMimeType::iconNameForUrl(const KUrl&, mode_t)
    {79, 1489, 148, 1, Smoke::mf_static, 351, 3},	//2123 KMimeType::favIconForUrl(const KUrl&)
    {79, 1159, 148, 1, Smoke::mf_const, 351, 4},	//2124 KMimeType::comment(const KUrl&) const
    {79, 2228, 0, 0, Smoke::mf_const, 354, 5},	//2125 KMimeType::patterns() const
    {79, 2061, 1552, 2, Smoke::mf_static, 191, 6},	//2126 KMimeType::mimeType(const QString&, KMimeType::FindByNameOption)
    {79, 1527, 1555, 5, Smoke::mf_static, 191, 7},	//2127 KMimeType::findByUrl(const KUrl&, mode_t, bool, bool, int*)
    {79, 1522, 1561, 4, Smoke::mf_static, 191, 8},	//2128 KMimeType::findByPath(const QString&, mode_t, bool, int*)
    {79, 1512, 1566, 2, Smoke::mf_static, 191, 9},	//2129 KMimeType::findByContent(const QByteArray&, int*)
    {79, 1518, 1569, 4, Smoke::mf_static, 191, 10},	//2130 KMimeType::findByNameAndContent(const QString&, const QByteArray&, mode_t, int*)
    {79, 1512, 1574, 2, Smoke::mf_static, 191, 11},	//2131 KMimeType::findByContent(QIODevice*, int*)
    {79, 1518, 1577, 4, Smoke::mf_static, 191, 12},	//2132 KMimeType::findByNameAndContent(const QString&, QIODevice*, mode_t, int*)
    {79, 1515, 1582, 2, Smoke::mf_static, 191, 13},	//2133 KMimeType::findByFileContent(const QString&, int*)
    {79, 1782, 30, 1, Smoke::mf_static, 450, 14},	//2134 KMimeType::isBinaryData(const QString&)
    {79, 1784, 32, 1, Smoke::mf_static, 450, 15},	//2135 KMimeType::isBufferBinaryData(const QByteArray&)
    {79, 1011, 0, 0, Smoke::mf_static, 322, 16},	//2136 KMimeType::allMimeTypes()
    {79, 1324, 0, 0, Smoke::mf_static, 351, 17},	//2137 KMimeType::defaultMimeType()
    {79, 1325, 0, 0, Smoke::mf_static, 191, 18},	//2138 KMimeType::defaultMimeTypePtr()
    {79, 1795, 0, 0, Smoke::mf_const, 450, 19},	//2139 KMimeType::isDefault() const
    {79, 2214, 0, 0, Smoke::mf_const, 351, 20},	//2140 KMimeType::parentMimeType() const
    {79, 2215, 0, 0, Smoke::mf_const, 354, 21},	//2141 KMimeType::parentMimeTypes() const
    {79, 1012, 0, 0, Smoke::mf_const, 354, 22},	//2142 KMimeType::allParentMimeTypes() const
    {79, 1771, 30, 1, Smoke::mf_const, 450, 23},	//2143 KMimeType::is(const QString&) const
    {79, 3212, 0, 0, Smoke::mf_const, 351, 24},	//2144 KMimeType::userSpecifiedIconName() const
    {79, 2039, 0, 0, Smoke::mf_const, 351, 25},	//2145 KMimeType::mainExtension() const
    {79, 1481, 30, 1, Smoke::mf_static, 351, 26},	//2146 KMimeType::extractKnownExtension(const QString&)
    {79, 2047, 95, 2, Smoke::mf_static, 450, 27},	//2147 KMimeType::matchFileName(const QString&, const QString&)
    {79, 2932, 0, 0, Smoke::mf_static, 614, 28},	//2148 KMimeType::sharedMimeInfoVersion()
    {79, 419, 1585, 2, Smoke::mf_ctor|Smoke::mf_protected, 152, 29},	//2149 KMimeType::KMimeType(QDataStream&, int)
    {79, 419, 1350, 3, Smoke::mf_ctor|Smoke::mf_protected, 152, 30},	//2150 KMimeType::KMimeType(const QString&, const QString&, const QString&)
    {79, 419, 1588, 1, Smoke::mf_ctor|Smoke::mf_protected, 152, 31},	//2151 KMimeType::KMimeType(KMimeTypePrivate&)
    {79, 419, 1590, 3, Smoke::mf_ctor|Smoke::mf_protected, 152, 32},	//2152 KMimeType::KMimeType(KMimeTypePrivate&, const QString&, const QString&)
    {79, 1715, 0, 0, Smoke::mf_const, 351, 33},	//2153 KMimeType::iconName() const
    {79, 1717, 148, 1, Smoke::mf_static, 351, 34},	//2154 KMimeType::iconNameForUrl(const KUrl&)
    {79, 1159, 0, 0, Smoke::mf_const, 351, 35},	//2155 KMimeType::comment() const
    {79, 2061, 30, 1, Smoke::mf_static, 191, 36},	//2156 KMimeType::mimeType(const QString&)
    {79, 1527, 148, 1, Smoke::mf_static, 191, 37},	//2157 KMimeType::findByUrl(const KUrl&)
    {79, 1527, 1549, 2, Smoke::mf_static, 191, 38},	//2158 KMimeType::findByUrl(const KUrl&, mode_t)
    {79, 1527, 1594, 3, Smoke::mf_static, 191, 39},	//2159 KMimeType::findByUrl(const KUrl&, mode_t, bool)
    {79, 1527, 1598, 4, Smoke::mf_static, 191, 40},	//2160 KMimeType::findByUrl(const KUrl&, mode_t, bool, bool)
    {79, 1522, 30, 1, Smoke::mf_static, 191, 41},	//2161 KMimeType::findByPath(const QString&)
    {79, 1522, 1007, 2, Smoke::mf_static, 191, 42},	//2162 KMimeType::findByPath(const QString&, mode_t)
    {79, 1522, 1603, 3, Smoke::mf_static, 191, 43},	//2163 KMimeType::findByPath(const QString&, mode_t, bool)
    {79, 1512, 32, 1, Smoke::mf_static, 191, 44},	//2164 KMimeType::findByContent(const QByteArray&)
    {79, 1518, 589, 2, Smoke::mf_static, 191, 45},	//2165 KMimeType::findByNameAndContent(const QString&, const QByteArray&)
    {79, 1518, 1607, 3, Smoke::mf_static, 191, 46},	//2166 KMimeType::findByNameAndContent(const QString&, const QByteArray&, mode_t)
    {79, 1512, 1134, 1, Smoke::mf_static, 191, 47},	//2167 KMimeType::findByContent(QIODevice*)
    {79, 1518, 1611, 2, Smoke::mf_static, 191, 48},	//2168 KMimeType::findByNameAndContent(const QString&, QIODevice*)
    {79, 1518, 1614, 3, Smoke::mf_static, 191, 49},	//2169 KMimeType::findByNameAndContent(const QString&, QIODevice*, mode_t)
    {79, 1515, 30, 1, Smoke::mf_static, 191, 50},	//2170 KMimeType::findByFileContent(const QString&)
    {79, 109, 0, 0, Smoke::mf_static|Smoke::mf_enum, 153, 51},	//2171 KMimeType::DontResolveAlias (enum)
    {79, 700, 0, 0, Smoke::mf_static|Smoke::mf_enum, 153, 52},	//2172 KMimeType::ResolveAliases (enum)
    {79, 3394, 0, 0, Smoke::mf_dtor, 0, 53 },	//2173 KMimeType::~KMimeType()
    {81, 2303, 1350, 3, Smoke::mf_const, 323, 1},	//2174 KMimeTypeTrader::query(const QString&, const QString&, const QString&) const
    {81, 2253, 95, 2, 0, 192, 2},	//2175 KMimeTypeTrader::preferredService(const QString&, const QString&)
    {81, 2476, 0, 0, Smoke::mf_static, 155, 3},	//2176 KMimeTypeTrader::self()
    {81, 424, 1618, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 155, 4},	//2177 KMimeTypeTrader::KMimeTypeTrader(const KMimeTypeTrader&)
    {81, 2303, 30, 1, Smoke::mf_const, 323, 5},	//2178 KMimeTypeTrader::query(const QString&) const
    {81, 2303, 95, 2, Smoke::mf_const, 323, 6},	//2179 KMimeTypeTrader::query(const QString&, const QString&) const
    {81, 2253, 30, 1, 0, 192, 7},	//2180 KMimeTypeTrader::preferredService(const QString&)
    {81, 3395, 0, 0, Smoke::mf_dtor, 0, 8 },	//2181 KMimeTypeTrader::~KMimeTypeTrader()
    {83, 2060, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 582, 1},	//2182 KPluginFactory::metaObject() const
    {83, 2301, 122, 1, Smoke::mf_virtual, 639, 2},	//2183 KPluginFactory::qt_metacast(const char*)
    {83, 3131, 124, 2, Smoke::mf_static, 351, 3},	//2184 KPluginFactory::tr(const char*, const char*)
    {83, 3138, 124, 2, Smoke::mf_static, 351, 4},	//2185 KPluginFactory::trUtf8(const char*, const char*)
    {83, 3131, 127, 3, Smoke::mf_static, 351, 5},	//2186 KPluginFactory::tr(const char*, const char*, int)
    {83, 3138, 127, 3, Smoke::mf_static, 351, 6},	//2187 KPluginFactory::trUtf8(const char*, const char*, int)
    {83, 2299, 131, 3, Smoke::mf_virtual, 614, 7},	//2188 KPluginFactory::qt_metacall(QMetaObject::Call, int, void**)
    {83, 426, 1620, 3, Smoke::mf_ctor, 157, 8},	//2189 KPluginFactory::KPluginFactory(const char*, const char*, QObject*)
    {83, 426, 1624, 2, Smoke::mf_ctor, 157, 9},	//2190 KPluginFactory::KPluginFactory(const KAboutData&, QObject*)
    {83, 426, 1627, 2, Smoke::mf_ctor, 157, 10},	//2191 KPluginFactory::KPluginFactory(const KAboutData*, QObject*)
    {83, 426, 146, 1, Smoke::mf_ctor, 157, 11},	//2192 KPluginFactory::KPluginFactory(QObject*)
    {83, 1163, 0, 0, Smoke::mf_const, 40, 12},	//2193 KPluginFactory::componentData() const
    {83, 1205, 1630, 3, 0, 345, 13},	//2194 KPluginFactory::create(QObject*, const char*, const QStringList&)
    {83, 2129, 146, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 14},	//2195 KPluginFactory::objectCreated(QObject*)
    {83, 426, 1634, 2, Smoke::mf_ctor|Smoke::mf_protected, 157, 15},	//2196 KPluginFactory::KPluginFactory(KPluginFactoryPrivate&, QObject*)
    {83, 3042, 141, 1, Smoke::mf_protected, 336, 16},	//2197 KPluginFactory::stringListToVariantList(const QStringList&)
    {83, 3229, 1637, 1, Smoke::mf_protected, 354, 17},	//2198 KPluginFactory::variantListToStringList(const QList<QVariant>&)
    {83, 2931, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 18},	//2199 KPluginFactory::setupTranslations()
    {83, 1215, 1630, 3, Smoke::mf_protected|Smoke::mf_virtual, 345, 19},	//2200 KPluginFactory::createObject(QObject*, const char*, const QStringList&)
    {83, 1217, 1639, 4, Smoke::mf_protected|Smoke::mf_virtual, 156, 20},	//2201 KPluginFactory::createPartObject(QWidget*, QObject*, const char*, const QStringList&)
    {83, 2543, 430, 1, Smoke::mf_protected, 0, 21},	//2202 KPluginFactory::setComponentData(const KComponentData&)
    {83, 1205, 1644, 5, Smoke::mf_protected|Smoke::mf_virtual, 345, 22},	//2203 KPluginFactory::create(const char*, QWidget*, QObject*, const QList<QVariant>&, const QString&)
    {83, 3131, 122, 1, Smoke::mf_static, 351, 23},	//2204 KPluginFactory::tr(const char*)
    {83, 3138, 122, 1, Smoke::mf_static, 351, 24},	//2205 KPluginFactory::trUtf8(const char*)
    {83, 426, 0, 0, Smoke::mf_ctor, 157, 25},	//2206 KPluginFactory::KPluginFactory()
    {83, 426, 122, 1, Smoke::mf_ctor, 157, 26},	//2207 KPluginFactory::KPluginFactory(const char*)
    {83, 426, 124, 2, Smoke::mf_ctor, 157, 27},	//2208 KPluginFactory::KPluginFactory(const char*, const char*)
    {83, 426, 12, 1, Smoke::mf_ctor, 157, 28},	//2209 KPluginFactory::KPluginFactory(const KAboutData&)
    {83, 426, 372, 1, Smoke::mf_ctor, 157, 29},	//2210 KPluginFactory::KPluginFactory(const KAboutData*)
    {83, 1205, 0, 0, 0, 345, 30},	//2211 KPluginFactory::create()
    {83, 1205, 146, 1, 0, 345, 31},	//2212 KPluginFactory::create(QObject*)
    {83, 1205, 1650, 2, 0, 345, 32},	//2213 KPluginFactory::create(QObject*, const char*)
    {83, 426, 1653, 1, Smoke::mf_ctor|Smoke::mf_protected, 157, 33},	//2214 KPluginFactory::KPluginFactory(KPluginFactoryPrivate&)
    {83, 3030, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 581, 34},	//2215 KPluginFactory::staticMetaObject() const
    {83, 3396, 0, 0, Smoke::mf_dtor, 0, 35 },	//2216 KPluginFactory::~KPluginFactory()
    {85, 432, 524, 2, Smoke::mf_ctor, 161, 1},	//2217 KPluginInfo::KPluginInfo(const QString&, const char*)
    {85, 432, 1655, 1, Smoke::mf_ctor, 161, 2},	//2218 KPluginInfo::KPluginInfo(const KSharedPtr<KService>)
    {85, 432, 0, 0, Smoke::mf_ctor, 161, 3},	//2219 KPluginInfo::KPluginInfo()
    {85, 1623, 1657, 2, Smoke::mf_static, 319, 4},	//2220 KPluginInfo::fromServices(const QList<KSharedPtr<KService> >&, const KConfigGroup&)
    {85, 1611, 1660, 2, Smoke::mf_static, 319, 5},	//2221 KPluginInfo::fromFiles(const QStringList&, const KConfigGroup&)
    {85, 1614, 1663, 2, Smoke::mf_static, 319, 6},	//2222 KPluginInfo::fromKPartsInstanceName(const QString&, const KConfigGroup&)
    {85, 1823, 0, 0, Smoke::mf_const, 450, 7},	//2223 KPluginInfo::isHidden() const
    {85, 2817, 103, 1, 0, 0, 8},	//2224 KPluginInfo::setPluginEnabled(bool)
    {85, 1845, 0, 0, Smoke::mf_const, 450, 9},	//2225 KPluginInfo::isPluginEnabled() const
    {85, 1846, 0, 0, Smoke::mf_const, 450, 10},	//2226 KPluginInfo::isPluginEnabledByDefault() const
    {85, 2277, 30, 1, Smoke::mf_const, 364, 11},	//2227 KPluginInfo::property(const QString&) const
    {85, 2102, 0, 0, Smoke::mf_const, 351, 12},	//2228 KPluginInfo::name() const
    {85, 1159, 0, 0, Smoke::mf_const, 351, 13},	//2229 KPluginInfo::comment() const
    {85, 1713, 0, 0, Smoke::mf_const, 351, 14},	//2230 KPluginInfo::icon() const
    {85, 1421, 0, 0, Smoke::mf_const, 351, 15},	//2231 KPluginInfo::entryPath() const
    {85, 1039, 0, 0, Smoke::mf_const, 351, 16},	//2232 KPluginInfo::author() const
    {85, 1390, 0, 0, Smoke::mf_const, 351, 17},	//2233 KPluginInfo::email() const
    {85, 1114, 0, 0, Smoke::mf_const, 351, 18},	//2234 KPluginInfo::category() const
    {85, 2241, 0, 0, Smoke::mf_const, 351, 19},	//2235 KPluginInfo::pluginName() const
    {85, 3234, 0, 0, Smoke::mf_const, 351, 20},	//2236 KPluginInfo::version() const
    {85, 3254, 0, 0, Smoke::mf_const, 351, 21},	//2237 KPluginInfo::website() const
    {85, 1970, 0, 0, Smoke::mf_const, 351, 22},	//2238 KPluginInfo::license() const
    {85, 1634, 0, 0, Smoke::mf_const, 8, 23},	//2239 KPluginInfo::fullLicense() const
    {85, 1342, 0, 0, Smoke::mf_const, 354, 24},	//2240 KPluginInfo::dependencies() const
    {85, 2479, 0, 0, Smoke::mf_const, 192, 25},	//2241 KPluginInfo::service() const
    {85, 1903, 0, 0, Smoke::mf_const, 323, 26},	//2242 KPluginInfo::kcmServices() const
    {85, 2545, 511, 1, 0, 0, 27},	//2243 KPluginInfo::setConfig(const KConfigGroup&)
    {85, 1168, 0, 0, Smoke::mf_const, 51, 28},	//2244 KPluginInfo::config() const
    {85, 2460, 1666, 1, 0, 0, 29},	//2245 KPluginInfo::save(KConfigGroup)
    {85, 1980, 511, 1, 0, 0, 30},	//2246 KPluginInfo::load(const KConfigGroup&)
    {85, 1330, 0, 0, 0, 0, 31},	//2247 KPluginInfo::defaults()
    {85, 1871, 0, 0, Smoke::mf_const, 450, 32},	//2248 KPluginInfo::isValid() const
    {85, 432, 1668, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 161, 33},	//2249 KPluginInfo::KPluginInfo(const KPluginInfo&)
    {85, 2182, 1668, 1, 0, 160, 34},	//2250 KPluginInfo::operator=(const KPluginInfo&)
    {85, 2185, 1668, 1, Smoke::mf_const, 450, 35},	//2251 KPluginInfo::operator==(const KPluginInfo&) const
    {85, 2158, 1668, 1, Smoke::mf_const, 450, 36},	//2252 KPluginInfo::operator!=(const KPluginInfo&) const
    {85, 2168, 1668, 1, Smoke::mf_const, 450, 37},	//2253 KPluginInfo::operator<(const KPluginInfo&) const
    {85, 2191, 1668, 1, Smoke::mf_const, 450, 38},	//2254 KPluginInfo::operator>(const KPluginInfo&) const
    {85, 432, 30, 1, Smoke::mf_ctor, 161, 39},	//2255 KPluginInfo::KPluginInfo(const QString&)
    {85, 1623, 1670, 1, Smoke::mf_static, 319, 40},	//2256 KPluginInfo::fromServices(const QList<KSharedPtr<KService> >&)
    {85, 1611, 141, 1, Smoke::mf_static, 319, 41},	//2257 KPluginInfo::fromFiles(const QStringList&)
    {85, 1614, 30, 1, Smoke::mf_static, 319, 42},	//2258 KPluginInfo::fromKPartsInstanceName(const QString&)
    {85, 2460, 0, 0, 0, 0, 43},	//2259 KPluginInfo::save()
    {85, 1980, 0, 0, 0, 0, 44},	//2260 KPluginInfo::load()
    {85, 3397, 0, 0, Smoke::mf_dtor, 0, 45 },	//2261 KPluginInfo::~KPluginInfo()
    {86, 2060, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 582, 1},	//2262 KPluginLoader::metaObject() const
    {86, 2301, 122, 1, Smoke::mf_virtual, 639, 2},	//2263 KPluginLoader::qt_metacast(const char*)
    {86, 3131, 124, 2, Smoke::mf_static, 351, 3},	//2264 KPluginLoader::tr(const char*, const char*)
    {86, 3138, 124, 2, Smoke::mf_static, 351, 4},	//2265 KPluginLoader::trUtf8(const char*, const char*)
    {86, 3131, 127, 3, Smoke::mf_static, 351, 5},	//2266 KPluginLoader::tr(const char*, const char*, int)
    {86, 3138, 127, 3, Smoke::mf_static, 351, 6},	//2267 KPluginLoader::trUtf8(const char*, const char*, int)
    {86, 2299, 131, 3, Smoke::mf_virtual, 614, 7},	//2268 KPluginLoader::qt_metacall(QMetaObject::Call, int, void**)
    {86, 437, 1205, 3, Smoke::mf_ctor, 162, 8},	//2269 KPluginLoader::KPluginLoader(const QString&, const KComponentData&, QObject*)
    {86, 437, 1672, 3, Smoke::mf_ctor, 162, 9},	//2270 KPluginLoader::KPluginLoader(const KService&, const KComponentData&, QObject*)
    {86, 1485, 0, 0, 0, 157, 10},	//2271 KPluginLoader::factory()
    {86, 2241, 0, 0, Smoke::mf_const|Smoke::mf_property, 351, 11},	//2272 KPluginLoader::pluginName() const
    {86, 2242, 0, 0, Smoke::mf_const, 632, 12},	//2273 KPluginLoader::pluginVersion() const
    {86, 1437, 0, 0, Smoke::mf_const, 351, 13},	//2274 KPluginLoader::errorString() const
    {86, 1833, 0, 0, Smoke::mf_const, 450, 14},	//2275 KPluginLoader::isLoaded() const
    {86, 1980, 0, 0, Smoke::mf_protected, 450, 15},	//2276 KPluginLoader::load()
    {86, 3131, 122, 1, Smoke::mf_static, 351, 16},	//2277 KPluginLoader::tr(const char*)
    {86, 3138, 122, 1, Smoke::mf_static, 351, 17},	//2278 KPluginLoader::trUtf8(const char*)
    {86, 437, 30, 1, Smoke::mf_ctor, 162, 18},	//2279 KPluginLoader::KPluginLoader(const QString&)
    {86, 437, 1202, 2, Smoke::mf_ctor, 162, 19},	//2280 KPluginLoader::KPluginLoader(const QString&, const KComponentData&)
    {86, 437, 1676, 1, Smoke::mf_ctor, 162, 20},	//2281 KPluginLoader::KPluginLoader(const KService&)
    {86, 437, 1678, 2, Smoke::mf_ctor, 162, 21},	//2282 KPluginLoader::KPluginLoader(const KService&, const KComponentData&)
    {86, 3030, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 581, 22},	//2283 KPluginLoader::staticMetaObject() const
    {86, 3398, 0, 0, Smoke::mf_dtor, 0, 23 },	//2284 KPluginLoader::~KPluginLoader()
    {87, 2060, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 582, 1},	//2285 KProcess::metaObject() const
    {87, 2301, 122, 1, Smoke::mf_virtual, 639, 2},	//2286 KProcess::qt_metacast(const char*)
    {87, 3131, 124, 2, Smoke::mf_static, 351, 3},	//2287 KProcess::tr(const char*, const char*)
    {87, 3138, 124, 2, Smoke::mf_static, 351, 4},	//2288 KProcess::trUtf8(const char*, const char*)
    {87, 3131, 127, 3, Smoke::mf_static, 351, 5},	//2289 KProcess::tr(const char*, const char*, int)
    {87, 3138, 127, 3, Smoke::mf_static, 351, 6},	//2290 KProcess::trUtf8(const char*, const char*, int)
    {87, 2299, 131, 3, Smoke::mf_virtual, 614, 7},	//2291 KProcess::qt_metacall(QMetaObject::Call, int, void**)
    {87, 444, 146, 1, Smoke::mf_ctor, 164, 8},	//2292 KProcess::KProcess(QObject*)
    {87, 2802, 1681, 1, 0, 0, 9},	//2293 KProcess::setOutputChannelMode(KProcess::OutputChannelMode)
    {87, 2210, 0, 0, Smoke::mf_const, 165, 10},	//2294 KProcess::outputChannelMode() const
    {87, 2790, 150, 1, 0, 0, 11},	//2295 KProcess::setNextOpenMode(QFlags<QIODevice::OpenModeFlag>)
    {87, 2618, 1136, 3, 0, 0, 12},	//2296 KProcess::setEnv(const QString&, const QString&, bool)
    {87, 3188, 30, 1, 0, 0, 13},	//2297 KProcess::unsetEnv(const QString&)
    {87, 1145, 0, 0, 0, 0, 14},	//2298 KProcess::clearEnvironment()
    {87, 2833, 533, 2, 0, 0, 15},	//2299 KProcess::setProgram(const QString&, const QStringList&)
    {87, 2833, 141, 1, 0, 0, 16},	//2300 KProcess::setProgram(const QStringList&)
    {87, 2173, 30, 1, 0, 163, 17},	//2301 KProcess::operator<<(const QString&)
    {87, 2173, 141, 1, 0, 163, 18},	//2302 KProcess::operator<<(const QStringList&)
    {87, 1146, 0, 0, 0, 0, 19},	//2303 KProcess::clearProgram()
    {87, 2861, 30, 1, 0, 0, 20},	//2304 KProcess::setShellCommand(const QString&)
    {87, 2270, 0, 0, Smoke::mf_const, 354, 21},	//2305 KProcess::program() const
    {87, 2972, 0, 0, 0, 0, 22},	//2306 KProcess::start()
    {87, 1451, 118, 1, 0, 614, 23},	//2307 KProcess::execute(int)
    {87, 1451, 1683, 3, Smoke::mf_static, 614, 24},	//2308 KProcess::execute(const QString&, const QStringList&, int)
    {87, 1451, 1687, 2, Smoke::mf_static, 614, 25},	//2309 KProcess::execute(const QStringList&, int)
    {87, 2974, 0, 0, 0, 614, 26},	//2310 KProcess::startDetached()
    {87, 2974, 533, 2, Smoke::mf_static, 614, 27},	//2311 KProcess::startDetached(const QString&, const QStringList&)
    {87, 2974, 141, 1, Smoke::mf_static, 614, 28},	//2312 KProcess::startDetached(const QStringList&)
    {87, 2239, 0, 0, Smoke::mf_const, 614, 29},	//2313 KProcess::pid() const
    {87, 444, 1690, 2, Smoke::mf_ctor|Smoke::mf_protected, 164, 30},	//2314 KProcess::KProcess(KProcessPrivate*, QObject*)
    {87, 3131, 122, 1, Smoke::mf_static, 351, 31},	//2315 KProcess::tr(const char*)
    {87, 3138, 122, 1, Smoke::mf_static, 351, 32},	//2316 KProcess::trUtf8(const char*)
    {87, 444, 0, 0, Smoke::mf_ctor, 164, 33},	//2317 KProcess::KProcess()
    {87, 2618, 95, 2, 0, 0, 34},	//2318 KProcess::setEnv(const QString&, const QString&)
    {87, 2833, 30, 1, 0, 0, 35},	//2319 KProcess::setProgram(const QString&)
    {87, 1451, 0, 0, 0, 614, 36},	//2320 KProcess::execute()
    {87, 1451, 30, 1, Smoke::mf_static, 614, 37},	//2321 KProcess::execute(const QString&)
    {87, 1451, 533, 2, Smoke::mf_static, 614, 38},	//2322 KProcess::execute(const QString&, const QStringList&)
    {87, 1451, 141, 1, Smoke::mf_static, 614, 39},	//2323 KProcess::execute(const QStringList&)
    {87, 2974, 30, 1, Smoke::mf_static, 614, 40},	//2324 KProcess::startDetached(const QString&)
    {87, 3030, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 581, 41},	//2325 KProcess::staticMetaObject() const
    {87, 707, 0, 0, Smoke::mf_static|Smoke::mf_enum, 165, 42},	//2326 KProcess::SeparateChannels (enum)
    {87, 602, 0, 0, Smoke::mf_static|Smoke::mf_enum, 165, 43},	//2327 KProcess::MergedChannels (enum)
    {87, 144, 0, 0, Smoke::mf_static|Smoke::mf_enum, 165, 44},	//2328 KProcess::ForwardedChannels (enum)
    {87, 647, 0, 0, Smoke::mf_static|Smoke::mf_enum, 165, 45},	//2329 KProcess::OnlyStdoutChannel (enum)
    {87, 646, 0, 0, Smoke::mf_static|Smoke::mf_enum, 165, 46},	//2330 KProcess::OnlyStderrChannel (enum)
    {87, 3399, 0, 0, Smoke::mf_dtor, 0, 47 },	//2331 KProcess::~KProcess()
    {89, 2288, 0, 0, Smoke::mf_static, 354, 1},	//2332 KProtocolInfo::protocols()
    {89, 1826, 148, 1, Smoke::mf_static, 450, 2},	//2333 KProtocolInfo::isKnownProtocol(const KUrl&)
    {89, 1826, 30, 1, Smoke::mf_static, 450, 3},	//2334 KProtocolInfo::isKnownProtocol(const QString&)
    {89, 1446, 30, 1, Smoke::mf_static, 351, 4},	//2335 KProtocolInfo::exec(const QString&)
    {89, 1479, 148, 1, Smoke::mf_static, 320, 5},	//2336 KProtocolInfo::extraFields(const KUrl&)
    {89, 1820, 148, 1, Smoke::mf_static, 450, 6},	//2337 KProtocolInfo::isHelperProtocol(const KUrl&)
    {89, 1820, 30, 1, Smoke::mf_static, 450, 7},	//2338 KProtocolInfo::isHelperProtocol(const QString&)
    {89, 1812, 148, 1, Smoke::mf_static, 450, 8},	//2339 KProtocolInfo::isFilterProtocol(const KUrl&)
    {89, 1812, 30, 1, Smoke::mf_static, 450, 9},	//2340 KProtocolInfo::isFilterProtocol(const QString&)
    {89, 1713, 30, 1, Smoke::mf_static, 351, 10},	//2341 KProtocolInfo::icon(const QString&)
    {89, 1168, 30, 1, Smoke::mf_static, 351, 11},	//2342 KProtocolInfo::config(const QString&)
    {89, 2050, 30, 1, Smoke::mf_static, 614, 12},	//2343 KProtocolInfo::maxSlaves(const QString&)
    {89, 2052, 30, 1, Smoke::mf_static, 614, 13},	//2344 KProtocolInfo::maxSlavesPerHost(const QString&)
    {89, 1360, 30, 1, Smoke::mf_static, 450, 14},	//2345 KProtocolInfo::determineMimetypeFromExtension(const QString&)
    {89, 1385, 30, 1, Smoke::mf_static, 351, 15},	//2346 KProtocolInfo::docPath(const QString&)
    {89, 2286, 30, 1, Smoke::mf_static, 351, 16},	//2347 KProtocolInfo::protocolClass(const QString&)
    {89, 2938, 30, 1, Smoke::mf_static, 450, 17},	//2348 KProtocolInfo::showFilePreview(const QString&)
    {89, 1106, 30, 1, Smoke::mf_static, 354, 18},	//2349 KProtocolInfo::capabilities(const QString&)
    {89, 2289, 30, 1, Smoke::mf_static, 351, 19},	//2350 KProtocolInfo::proxiedBy(const QString&)
    {89, 447, 1585, 2, Smoke::mf_ctor, 167, 20},	//2351 KProtocolInfo::KProtocolInfo(QDataStream&, int)
    {89, 1324, 0, 0, Smoke::mf_const, 351, 21},	//2352 KProtocolInfo::defaultMimeType() const
    {89, 1034, 0, 0, Smoke::mf_const, 354, 22},	//2353 KProtocolInfo::archiveMimeTypes() const
    {89, 1104, 0, 0, Smoke::mf_const|Smoke::mf_protected, 450, 23},	//2354 KProtocolInfo::canRenameFromFile() const
    {89, 1105, 0, 0, Smoke::mf_const|Smoke::mf_protected, 450, 24},	//2355 KProtocolInfo::canRenameToFile() const
    {89, 1102, 0, 0, Smoke::mf_const|Smoke::mf_protected, 450, 25},	//2356 KProtocolInfo::canDeleteRecursive() const
    {89, 1500, 0, 0, Smoke::mf_const|Smoke::mf_protected, 3, 26},	//2357 KProtocolInfo::fileNameUsedForCopying() const
    {89, 2027, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 352, 27},	//2358 KProtocolInfo::m_name() const
    {89, 2730, 30, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 28},	//2359 KProtocolInfo::setM_name(const QString&)
    {89, 2020, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 352, 29},	//2360 KProtocolInfo::m_exec() const
    {89, 2716, 30, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 30},	//2361 KProtocolInfo::setM_exec(const QString&)
    {89, 2022, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 173, 31},	//2362 KProtocolInfo::m_inputType() const
    {89, 2720, 1693, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 32},	//2363 KProtocolInfo::setM_inputType(KProtocolInfo::Type)
    {89, 2028, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 173, 33},	//2364 KProtocolInfo::m_outputType() const
    {89, 2732, 1693, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 34},	//2365 KProtocolInfo::setM_outputType(KProtocolInfo::Type)
    {89, 2025, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 355, 35},	//2366 KProtocolInfo::m_listing() const
    {89, 2726, 141, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 36},	//2367 KProtocolInfo::setM_listing(const QStringList&)
    {89, 2024, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 450, 37},	//2368 KProtocolInfo::m_isSourceProtocol() const
    {89, 2724, 103, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 38},	//2369 KProtocolInfo::setM_isSourceProtocol(bool)
    {89, 2023, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 450, 39},	//2370 KProtocolInfo::m_isHelperProtocol() const
    {89, 2722, 103, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 40},	//2371 KProtocolInfo::setM_isHelperProtocol(bool)
    {89, 2032, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 450, 41},	//2372 KProtocolInfo::m_supportsListing() const
    {89, 2740, 103, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 42},	//2373 KProtocolInfo::setM_supportsListing(bool)
    {89, 2036, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 450, 43},	//2374 KProtocolInfo::m_supportsReading() const
    {89, 2748, 103, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 44},	//2375 KProtocolInfo::setM_supportsReading(bool)
    {89, 2037, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 450, 45},	//2376 KProtocolInfo::m_supportsWriting() const
    {89, 2750, 103, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 46},	//2377 KProtocolInfo::setM_supportsWriting(bool)
    {89, 2033, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 450, 47},	//2378 KProtocolInfo::m_supportsMakeDir() const
    {89, 2742, 103, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 48},	//2379 KProtocolInfo::setM_supportsMakeDir(bool)
    {89, 2030, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 450, 49},	//2380 KProtocolInfo::m_supportsDeleting() const
    {89, 2736, 103, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 50},	//2381 KProtocolInfo::setM_supportsDeleting(bool)
    {89, 2031, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 450, 51},	//2382 KProtocolInfo::m_supportsLinking() const
    {89, 2738, 103, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 52},	//2383 KProtocolInfo::setM_supportsLinking(bool)
    {89, 2034, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 450, 53},	//2384 KProtocolInfo::m_supportsMoving() const
    {89, 2744, 103, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 54},	//2385 KProtocolInfo::setM_supportsMoving(bool)
    {89, 2035, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 450, 55},	//2386 KProtocolInfo::m_supportsOpening() const
    {89, 2746, 103, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 56},	//2387 KProtocolInfo::setM_supportsOpening(bool)
    {89, 2017, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 352, 57},	//2388 KProtocolInfo::m_defaultMimetype() const
    {89, 2710, 30, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 58},	//2389 KProtocolInfo::setM_defaultMimetype(const QString&)
    {89, 2018, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 450, 59},	//2390 KProtocolInfo::m_determineMimetypeFromExtension() const
    {89, 2712, 103, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 60},	//2391 KProtocolInfo::setM_determineMimetypeFromExtension(bool)
    {89, 2021, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 352, 61},	//2392 KProtocolInfo::m_icon() const
    {89, 2718, 30, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 62},	//2393 KProtocolInfo::setM_icon(const QString&)
    {89, 2014, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 450, 63},	//2394 KProtocolInfo::m_canCopyFromFile() const
    {89, 2704, 103, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 64},	//2395 KProtocolInfo::setM_canCopyFromFile(bool)
    {89, 2015, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 450, 65},	//2396 KProtocolInfo::m_canCopyToFile() const
    {89, 2706, 103, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 66},	//2397 KProtocolInfo::setM_canCopyToFile(bool)
    {89, 2016, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 352, 67},	//2398 KProtocolInfo::m_config() const
    {89, 2708, 30, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 68},	//2399 KProtocolInfo::setM_config(const QString&)
    {89, 2026, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 614, 69},	//2400 KProtocolInfo::m_maxSlaves() const
    {89, 2728, 118, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 70},	//2401 KProtocolInfo::setM_maxSlaves(int)
    {89, 747, 0, 0, Smoke::mf_static|Smoke::mf_enum, 173, 71},	//2402 KProtocolInfo::T_STREAM (enum)
    {89, 745, 0, 0, Smoke::mf_static|Smoke::mf_enum, 173, 72},	//2403 KProtocolInfo::T_FILESYSTEM (enum)
    {89, 746, 0, 0, Smoke::mf_static|Smoke::mf_enum, 173, 73},	//2404 KProtocolInfo::T_NONE (enum)
    {89, 744, 0, 0, Smoke::mf_static|Smoke::mf_enum, 173, 74},	//2405 KProtocolInfo::T_ERROR (enum)
    {89, 613, 0, 0, Smoke::mf_static|Smoke::mf_enum, 172, 75},	//2406 KProtocolInfo::Name (enum)
    {89, 147, 0, 0, Smoke::mf_static|Smoke::mf_enum, 172, 76},	//2407 KProtocolInfo::FromUrl (enum)
    {89, 105, 0, 0, Smoke::mf_static|Smoke::mf_enum, 172, 77},	//2408 KProtocolInfo::DisplayName (enum)
    {89, 3400, 0, 0, Smoke::mf_dtor, 0, 78 },	//2409 KProtocolInfo::~KProtocolInfo()
    {90, 132, 0, 0, Smoke::mf_ctor, 170, 1},	//2410 KProtocolInfo::ExtraField::ExtraField()
    {90, 132, 1695, 2, Smoke::mf_ctor, 170, 2},	//2411 KProtocolInfo::ExtraField::ExtraField(const QString&, KProtocolInfo::ExtraField::Type)
    {90, 132, 1698, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 170, 3},	//2412 KProtocolInfo::ExtraField::ExtraField(const KProtocolInfo::ExtraField&)
    {90, 2102, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 352, 4},	//2413 KProtocolInfo::ExtraField::name() const
    {90, 2782, 30, 1, Smoke::mf_attribute, 0, 5},	//2414 KProtocolInfo::ExtraField::setName(const QString&)
    {90, 3174, 0, 0, Smoke::mf_const|Smoke::mf_attribute, 171, 6},	//2415 KProtocolInfo::ExtraField::type() const
    {90, 2904, 1700, 1, Smoke::mf_attribute, 0, 7},	//2416 KProtocolInfo::ExtraField::setType(KProtocolInfo::ExtraField::Type)
    {90, 739, 0, 0, Smoke::mf_static|Smoke::mf_enum, 171, 8},	//2417 KProtocolInfo::ExtraField::String (enum)
    {90, 83, 0, 0, Smoke::mf_static|Smoke::mf_enum, 171, 9},	//2418 KProtocolInfo::ExtraField::DateTime (enum)
    {90, 177, 0, 0, Smoke::mf_static|Smoke::mf_enum, 171, 10},	//2419 KProtocolInfo::ExtraField::Invalid (enum)
    {90, 3333, 0, 0, Smoke::mf_dtor, 0, 11 },	//2420 KProtocolInfo::ExtraField::~ExtraField()
    {91, 2320, 0, 0, Smoke::mf_static, 614, 1},	//2421 KRandom::random()
    {91, 2321, 118, 1, Smoke::mf_static, 351, 2},	//2422 KRandom::randomString(int)
    {92, 449, 1292, 1, Smoke::mf_ctor, 175, 1},	//2423 KRandomSequence::KRandomSequence(long)
    {92, 449, 1702, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 175, 2},	//2424 KRandomSequence::KRandomSequence(const KRandomSequence&)
    {92, 2182, 1702, 1, 0, 174, 3},	//2425 KRandomSequence::operator=(const KRandomSequence&)
    {92, 2855, 1292, 1, 0, 0, 4},	//2426 KRandomSequence::setSeed(long)
    {92, 1640, 0, 0, 0, 610, 5},	//2427 KRandomSequence::getDouble()
    {92, 1643, 1177, 1, 0, 634, 6},	//2428 KRandomSequence::getLong(unsigned long)
    {92, 1637, 0, 0, 0, 450, 7},	//2429 KRandomSequence::getBool()
    {92, 2071, 118, 1, 0, 0, 8},	//2430 KRandomSequence::modulate(int)
    {92, 449, 0, 0, Smoke::mf_ctor, 175, 9},	//2431 KRandomSequence::KRandomSequence()
    {92, 2855, 0, 0, 0, 0, 10},	//2432 KRandomSequence::setSeed()
    {92, 3401, 0, 0, Smoke::mf_dtor, 0, 11 },	//2433 KRandomSequence::~KRandomSequence()
    {93, 471, 0, 0, Smoke::mf_ctor, 176, 1},	//2434 KSaveFile::KSaveFile()
    {93, 471, 1202, 2, Smoke::mf_ctor, 176, 2},	//2435 KSaveFile::KSaveFile(const QString&, const KComponentData&)
    {93, 2639, 30, 1, 0, 0, 3},	//2436 KSaveFile::setFileName(const QString&)
    {93, 1498, 0, 0, Smoke::mf_const, 351, 4},	//2437 KSaveFile::fileName() const
    {93, 1434, 0, 0, Smoke::mf_const, 281, 5},	//2438 KSaveFile::error() const
    {93, 1437, 0, 0, Smoke::mf_const, 351, 6},	//2439 KSaveFile::errorString() const
    {93, 2145, 150, 1, Smoke::mf_virtual, 450, 7},	//2440 KSaveFile::open(QFlags<QIODevice::OpenModeFlag>)
    {93, 826, 0, 0, 0, 0, 8},	//2441 KSaveFile::abort()
    {93, 1502, 0, 0, 0, 450, 9},	//2442 KSaveFile::finalize()
    {93, 2609, 103, 1, 0, 0, 10},	//2443 KSaveFile::setDirectWriteFallback(bool)
    {93, 1373, 0, 0, Smoke::mf_const, 450, 11},	//2444 KSaveFile::directWriteFallback() const
    {93, 1066, 95, 2, Smoke::mf_static, 450, 12},	//2445 KSaveFile::backupFile(const QString&, const QString&)
    {93, 2942, 1350, 3, Smoke::mf_static, 450, 13},	//2446 KSaveFile::simpleBackupFile(const QString&, const QString&, const QString&)
    {93, 2124, 1704, 4, Smoke::mf_static, 450, 14},	//2447 KSaveFile::numberedBackupFile(const QString&, const QString&, const QString&, const unsigned int)
    {93, 2325, 1350, 3, Smoke::mf_static, 450, 15},	//2448 KSaveFile::rcsBackupFile(const QString&, const QString&, const QString&)
    {93, 471, 30, 1, Smoke::mf_ctor, 176, 16},	//2449 KSaveFile::KSaveFile(const QString&)
    {93, 2145, 0, 0, 0, 450, 17},	//2450 KSaveFile::open()
    {93, 1066, 30, 1, Smoke::mf_static, 450, 18},	//2451 KSaveFile::backupFile(const QString&)
    {93, 2942, 30, 1, Smoke::mf_static, 450, 19},	//2452 KSaveFile::simpleBackupFile(const QString&)
    {93, 2942, 95, 2, Smoke::mf_static, 450, 20},	//2453 KSaveFile::simpleBackupFile(const QString&, const QString&)
    {93, 2124, 30, 1, Smoke::mf_static, 450, 21},	//2454 KSaveFile::numberedBackupFile(const QString&)
    {93, 2124, 95, 2, Smoke::mf_static, 450, 22},	//2455 KSaveFile::numberedBackupFile(const QString&, const QString&)
    {93, 2124, 1350, 3, Smoke::mf_static, 450, 23},	//2456 KSaveFile::numberedBackupFile(const QString&, const QString&, const QString&)
    {93, 2325, 30, 1, Smoke::mf_static, 450, 24},	//2457 KSaveFile::rcsBackupFile(const QString&)
    {93, 2325, 95, 2, Smoke::mf_static, 450, 25},	//2458 KSaveFile::rcsBackupFile(const QString&, const QString&)
    {93, 3402, 0, 0, Smoke::mf_dtor, 0, 26 },	//2459 KSaveFile::~KSaveFile()
    {94, 474, 1350, 3, Smoke::mf_ctor, 178, 1},	//2460 KService::KService(const QString&, const QString&, const QString&)
    {94, 474, 30, 1, Smoke::mf_ctor, 178, 2},	//2461 KService::KService(const QString&)
    {94, 474, 1709, 1, Smoke::mf_ctor, 178, 3},	//2462 KService::KService(const KDesktopFile*)
    {94, 474, 1585, 2, Smoke::mf_ctor, 178, 4},	//2463 KService::KService(QDataStream&, int)
    {94, 1773, 0, 0, Smoke::mf_const, 450, 5},	//2464 KService::isApplication() const
    {94, 3174, 0, 0, Smoke::mf_const, 351, 6},	//2465 KService::type() const
    {94, 1446, 0, 0, Smoke::mf_const, 351, 7},	//2466 KService::exec() const
    {94, 1967, 0, 0, Smoke::mf_const, 351, 8},	//2467 KService::library() const
    {94, 1713, 0, 0, Smoke::mf_const, 351, 9},	//2468 KService::icon() const
    {94, 3086, 0, 0, Smoke::mf_const, 450, 10},	//2469 KService::terminal() const
    {94, 3087, 0, 0, Smoke::mf_const, 351, 11},	//2470 KService::terminalOptions() const
    {94, 3056, 0, 0, Smoke::mf_const, 450, 12},	//2471 KService::substituteUid() const
    {94, 3213, 0, 0, Smoke::mf_const, 351, 13},	//2472 KService::username() const
    {94, 1354, 0, 0, Smoke::mf_const, 351, 14},	//2473 KService::desktopEntryPath() const
    {94, 1353, 0, 0, Smoke::mf_const, 351, 15},	//2474 KService::desktopEntryName() const
    {94, 2056, 0, 0, Smoke::mf_const, 351, 16},	//2475 KService::menuId() const
    {94, 3038, 0, 0, Smoke::mf_const, 351, 17},	//2476 KService::storageId() const
    {94, 1305, 0, 0, Smoke::mf_const, 179, 18},	//2477 KService::dbusStartupType() const
    {94, 2224, 0, 0, Smoke::mf_const, 351, 19},	//2478 KService::path() const
    {94, 1159, 0, 0, Smoke::mf_const, 351, 20},	//2479 KService::comment() const
    {94, 1636, 0, 0, Smoke::mf_const, 351, 21},	//2480 KService::genericName() const
    {94, 3190, 0, 0, Smoke::mf_const, 351, 22},	//2481 KService::untranslatedGenericName() const
    {94, 1926, 0, 0, Smoke::mf_const, 354, 23},	//2482 KService::keywords() const
    {94, 1113, 0, 0, Smoke::mf_const, 354, 24},	//2483 KService::categories() const
    {94, 2064, 0, 0, Smoke::mf_const, 354, 25},	//2484 KService::mimeTypes() const
    {94, 2495, 0, 0, Smoke::mf_const, 354, 26},	//2485 KService::serviceTypes() const
    {94, 1694, 30, 1, Smoke::mf_const, 450, 27},	//2486 KService::hasServiceType(const QString&) const
    {94, 1681, 1711, 1, Smoke::mf_const, 450, 28},	//2487 KService::hasMimeType(const KServiceType*) const
    {94, 1681, 30, 1, Smoke::mf_const, 450, 29},	//2488 KService::hasMimeType(const QString&) const
    {94, 1021, 0, 0, Smoke::mf_const, 450, 30},	//2489 KService::allowAsDefault() const
    {94, 840, 0, 0, Smoke::mf_const, 321, 31},	//2490 KService::actions() const
    {94, 1023, 0, 0, Smoke::mf_const, 450, 32},	//2491 KService::allowMultipleFiles() const
    {94, 1739, 0, 0, Smoke::mf_const, 614, 33},	//2492 KService::initialPreference() const
    {94, 2120, 0, 0, Smoke::mf_const, 450, 34},	//2493 KService::noDisplay() const
    {94, 2940, 0, 0, Smoke::mf_const, 450, 35},	//2494 KService::showInKDE() const
    {94, 2213, 0, 0, Smoke::mf_const, 351, 36},	//2495 KService::parentApp() const
    {94, 2240, 0, 0, Smoke::mf_const, 351, 37},	//2496 KService::pluginKeyword() const
    {94, 1385, 0, 0, Smoke::mf_const, 351, 38},	//2497 KService::docPath() const
    {94, 2277, 1713, 2, Smoke::mf_const, 364, 39},	//2498 KService::property(const QString&, QVariant::Type) const
    {94, 2277, 30, 1, Smoke::mf_const, 364, 40},	//2499 KService::property(const QString&) const
    {94, 1996, 0, 0, Smoke::mf_const, 351, 41},	//2500 KService::locateLocal() const
    {94, 2766, 30, 1, 0, 0, 42},	//2501 KService::setMenuId(const QString&)
    {94, 2880, 103, 1, 0, 0, 43},	//2502 KService::setTerminal(bool)
    {94, 2882, 30, 1, 0, 0, 44},	//2503 KService::setTerminalOptions(const QString&)
    {94, 2633, 30, 1, 0, 0, 45},	//2504 KService::setExec(const QString&)
    {94, 2486, 30, 1, Smoke::mf_static, 192, 46},	//2505 KService::serviceByName(const QString&)
    {94, 2482, 30, 1, Smoke::mf_static, 192, 47},	//2506 KService::serviceByDesktopPath(const QString&)
    {94, 2480, 30, 1, Smoke::mf_static, 192, 48},	//2507 KService::serviceByDesktopName(const QString&)
    {94, 2484, 30, 1, Smoke::mf_static, 192, 49},	//2508 KService::serviceByMenuId(const QString&)
    {94, 2488, 30, 1, Smoke::mf_static, 192, 50},	//2509 KService::serviceByStorageId(const QString&)
    {94, 1015, 0, 0, Smoke::mf_static, 323, 51},	//2510 KService::allServices()
    {94, 2115, 1716, 4, Smoke::mf_static, 351, 52},	//2511 KService::newServicePath(bool, const QString&, QString*, const QStringList*)
    {94, 2115, 1721, 2, Smoke::mf_static, 351, 53},	//2512 KService::newServicePath(bool, const QString&)
    {94, 2115, 1724, 3, Smoke::mf_static, 351, 54},	//2513 KService::newServicePath(bool, const QString&, QString*)
    {94, 79, 0, 0, Smoke::mf_static|Smoke::mf_enum, 179, 55},	//2514 KService::DBusNone (enum)
    {94, 80, 0, 0, Smoke::mf_static|Smoke::mf_enum, 179, 56},	//2515 KService::DBusUnique (enum)
    {94, 78, 0, 0, Smoke::mf_static|Smoke::mf_enum, 179, 57},	//2516 KService::DBusMulti (enum)
    {94, 81, 0, 0, Smoke::mf_static|Smoke::mf_enum, 179, 58},	//2517 KService::DBusWait (enum)
    {94, 3403, 0, 0, Smoke::mf_dtor, 0, 59 },	//2518 KService::~KService()
    {95, 479, 1728, 5, Smoke::mf_ctor, 182, 1},	//2519 KServiceAction::KServiceAction(const QString&, const QString&, const QString&, const QString&, bool)
    {95, 479, 0, 0, Smoke::mf_ctor, 182, 2},	//2520 KServiceAction::KServiceAction()
    {95, 479, 1734, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 182, 3},	//2521 KServiceAction::KServiceAction(const KServiceAction&)
    {95, 2182, 1734, 1, 0, 181, 4},	//2522 KServiceAction::operator=(const KServiceAction&)
    {95, 2565, 34, 1, 0, 0, 5},	//2523 KServiceAction::setData(const QVariant&)
    {95, 1245, 0, 0, Smoke::mf_const, 364, 6},	//2524 KServiceAction::data() const
    {95, 2102, 0, 0, Smoke::mf_const, 351, 7},	//2525 KServiceAction::name() const
    {95, 3091, 0, 0, Smoke::mf_const, 351, 8},	//2526 KServiceAction::text() const
    {95, 1713, 0, 0, Smoke::mf_const, 351, 9},	//2527 KServiceAction::icon() const
    {95, 1446, 0, 0, Smoke::mf_const, 351, 10},	//2528 KServiceAction::exec() const
    {95, 2120, 0, 0, Smoke::mf_const, 450, 11},	//2529 KServiceAction::noDisplay() const
    {95, 1854, 0, 0, Smoke::mf_const, 450, 12},	//2530 KServiceAction::isSeparator() const
    {95, 479, 1736, 4, Smoke::mf_ctor, 182, 13},	//2531 KServiceAction::KServiceAction(const QString&, const QString&, const QString&, const QString&)
    {95, 3404, 0, 0, Smoke::mf_dtor, 0, 14 },	//2532 KServiceAction::~KServiceAction()
    {96, 483, 30, 1, Smoke::mf_ctor, 184, 1},	//2533 KServiceGroup::KServiceGroup(const QString&)
    {96, 483, 95, 2, Smoke::mf_ctor, 184, 2},	//2534 KServiceGroup::KServiceGroup(const QString&, const QString&)
    {96, 483, 1741, 3, Smoke::mf_ctor, 184, 3},	//2535 KServiceGroup::KServiceGroup(QDataStream&, int, bool)
    {96, 2402, 0, 0, Smoke::mf_const, 351, 4},	//2536 KServiceGroup::relPath() const
    {96, 1108, 0, 0, Smoke::mf_const, 351, 5},	//2537 KServiceGroup::caption() const
    {96, 1713, 0, 0, Smoke::mf_const, 351, 6},	//2538 KServiceGroup::icon() const
    {96, 1159, 0, 0, Smoke::mf_const, 351, 7},	//2539 KServiceGroup::comment() const
    {96, 1134, 0, 0, Smoke::mf_const, 614, 8},	//2540 KServiceGroup::childCount() const
    {96, 2120, 0, 0, Smoke::mf_const, 450, 9},	//2541 KServiceGroup::noDisplay() const
    {96, 2936, 0, 0, Smoke::mf_const, 450, 10},	//2542 KServiceGroup::showEmptyMenu() const
    {96, 2865, 103, 1, 0, 0, 11},	//2543 KServiceGroup::setShowEmptyMenu(bool)
    {96, 2941, 0, 0, Smoke::mf_const, 450, 12},	//2544 KServiceGroup::showInlineHeader() const
    {96, 2867, 103, 1, 0, 0, 13},	//2545 KServiceGroup::setShowInlineHeader(bool)
    {96, 1740, 0, 0, Smoke::mf_const, 450, 14},	//2546 KServiceGroup::inlineAlias() const
    {96, 2662, 103, 1, 0, 0, 15},	//2547 KServiceGroup::setInlineAlias(bool)
    {96, 1022, 0, 0, Smoke::mf_const, 450, 16},	//2548 KServiceGroup::allowInline() const
    {96, 2502, 103, 1, 0, 0, 17},	//2549 KServiceGroup::setAllowInline(bool)
    {96, 1741, 0, 0, Smoke::mf_const, 614, 18},	//2550 KServiceGroup::inlineValue() const
    {96, 2664, 118, 1, 0, 0, 19},	//2551 KServiceGroup::setInlineValue(int)
    {96, 3062, 0, 0, Smoke::mf_const, 354, 20},	//2552 KServiceGroup::suppressGenericNames() const
    {96, 2680, 141, 1, 0, 0, 21},	//2553 KServiceGroup::setLayoutInfo(const QStringList&)
    {96, 1962, 0, 0, Smoke::mf_const, 354, 22},	//2554 KServiceGroup::layoutInfo() const
    {96, 1414, 1745, 4, 0, 327, 23},	//2555 KServiceGroup::entries(bool, bool, bool, bool)
    {96, 1414, 1750, 2, 0, 327, 24},	//2556 KServiceGroup::entries(bool, bool)
    {96, 1414, 103, 1, 0, 327, 25},	//2557 KServiceGroup::entries(bool)
    {96, 1653, 1753, 1, 0, 325, 26},	//2558 KServiceGroup::groupEntries(QFlags<KServiceGroup::EntriesOption>)
    {96, 2490, 1753, 1, 0, 323, 27},	//2559 KServiceGroup::serviceEntries(QFlags<KServiceGroup::EntriesOption>)
    {96, 1080, 0, 0, Smoke::mf_const, 351, 28},	//2560 KServiceGroup::baseGroupName() const
    {96, 1376, 0, 0, Smoke::mf_const, 351, 29},	//2561 KServiceGroup::directoryEntryPath() const
    {96, 1078, 30, 1, Smoke::mf_static, 193, 30},	//2562 KServiceGroup::baseGroup(const QString&)
    {96, 2456, 0, 0, Smoke::mf_static, 193, 31},	//2563 KServiceGroup::root()
    {96, 1650, 30, 1, Smoke::mf_static, 193, 32},	//2564 KServiceGroup::group(const QString&)
    {96, 1136, 30, 1, Smoke::mf_static, 193, 33},	//2565 KServiceGroup::childGroup(const QString&)
    {96, 874, 1755, 1, Smoke::mf_protected, 0, 34},	//2566 KServiceGroup::addEntry(const KSharedPtr<KSycocaEntry>&)
    {96, 1414, 1757, 3, 0, 327, 35},	//2567 KServiceGroup::entries(bool, bool, bool)
    {96, 1414, 0, 0, 0, 327, 36},	//2568 KServiceGroup::entries()
    {96, 1653, 0, 0, 0, 325, 37},	//2569 KServiceGroup::groupEntries()
    {96, 2490, 0, 0, 0, 323, 38},	//2570 KServiceGroup::serviceEntries()
    {96, 626, 0, 0, Smoke::mf_static|Smoke::mf_enum, 185, 39},	//2571 KServiceGroup::NoOptions (enum)
    {96, 725, 0, 0, Smoke::mf_static|Smoke::mf_enum, 185, 40},	//2572 KServiceGroup::SortEntries (enum)
    {96, 127, 0, 0, Smoke::mf_static|Smoke::mf_enum, 185, 41},	//2573 KServiceGroup::ExcludeNoDisplay (enum)
    {96, 18, 0, 0, Smoke::mf_static|Smoke::mf_enum, 185, 42},	//2574 KServiceGroup::AllowSeparators (enum)
    {96, 724, 0, 0, Smoke::mf_static|Smoke::mf_enum, 185, 43},	//2575 KServiceGroup::SortByGenericName (enum)
    {96, 3405, 0, 0, Smoke::mf_dtor, 0, 44 },	//2576 KServiceGroup::~KServiceGroup()
    {97, 487, 1761, 1, Smoke::mf_ctor, 187, 1},	//2577 KServiceType::KServiceType(KDesktopFile*)
    {97, 487, 1585, 2, Smoke::mf_ctor, 187, 2},	//2578 KServiceType::KServiceType(QDataStream&, int)
    {97, 1159, 0, 0, Smoke::mf_const, 351, 3},	//2579 KServiceType::comment() const
    {97, 1354, 0, 0, Smoke::mf_const, 351, 4},	//2580 KServiceType::desktopEntryPath() const
    {97, 1797, 0, 0, Smoke::mf_const, 450, 5},	//2581 KServiceType::isDerived() const
    {97, 2216, 0, 0, Smoke::mf_const, 351, 6},	//2582 KServiceType::parentServiceType() const
    {97, 1729, 30, 1, Smoke::mf_const, 450, 7},	//2583 KServiceType::inherits(const QString&) const
    {97, 2280, 30, 1, Smoke::mf_const, 366, 8},	//2584 KServiceType::propertyDef(const QString&) const
    {97, 2282, 0, 0, Smoke::mf_const, 354, 9},	//2585 KServiceType::propertyDefNames() const
    {97, 2283, 0, 0, Smoke::mf_const, 340, 10},	//2586 KServiceType::propertyDefs() const
    {97, 2217, 0, 0, 0, 194, 11},	//2587 KServiceType::parentType()
    {97, 2857, 118, 1, 0, 0, 12},	//2588 KServiceType::setServiceOffersOffset(int)
    {97, 2492, 0, 0, Smoke::mf_const, 614, 13},	//2589 KServiceType::serviceOffersOffset() const
    {97, 2493, 30, 1, Smoke::mf_static, 194, 14},	//2590 KServiceType::serviceType(const QString&)
    {97, 1014, 0, 0, Smoke::mf_static, 326, 15},	//2591 KServiceType::allServiceTypes()
    {97, 487, 1763, 1, Smoke::mf_ctor|Smoke::mf_protected, 187, 16},	//2592 KServiceType::KServiceType(KServiceTypePrivate&)
    {97, 487, 1765, 3, Smoke::mf_ctor|Smoke::mf_protected, 187, 17},	//2593 KServiceType::KServiceType(KServiceTypePrivate&, const QString&, const QString&)
    {97, 3406, 0, 0, Smoke::mf_dtor, 0, 18 },	//2594 KServiceType::~KServiceType()
    {99, 2303, 95, 2, Smoke::mf_const, 323, 1},	//2595 KServiceTypeTrader::query(const QString&, const QString&) const
    {99, 1326, 95, 2, Smoke::mf_const, 323, 2},	//2596 KServiceTypeTrader::defaultOffers(const QString&, const QString&) const
    {99, 2253, 30, 1, Smoke::mf_const, 192, 3},	//2597 KServiceTypeTrader::preferredService(const QString&) const
    {99, 2476, 0, 0, Smoke::mf_static, 189, 4},	//2598 KServiceTypeTrader::self()
    {99, 1030, 1769, 2, Smoke::mf_static, 0, 5},	//2599 KServiceTypeTrader::applyConstraints(QList<KSharedPtr<KService> >&, const QString&)
    {99, 2303, 30, 1, Smoke::mf_const, 323, 6},	//2600 KServiceTypeTrader::query(const QString&) const
    {99, 1326, 30, 1, Smoke::mf_const, 323, 7},	//2601 KServiceTypeTrader::defaultOffers(const QString&) const
    {99, 3407, 0, 0, Smoke::mf_dtor, 0, 8 },	//2602 KServiceTypeTrader::~KServiceTypeTrader()
    {100, 2149, 454, 3, Smoke::mf_static, 195, 1},	//2603 KSharedConfig::openConfig(const QString&, QFlags<KConfig::OpenFlag>, const char*)
    {100, 2149, 458, 4, Smoke::mf_static, 195, 2},	//2604 KSharedConfig::openConfig(const KComponentData&, const QString&, QFlags<KConfig::OpenFlag>, const char*)
    {100, 2149, 0, 0, Smoke::mf_static, 195, 3},	//2605 KSharedConfig::openConfig()
    {100, 2149, 30, 1, Smoke::mf_static, 195, 4},	//2606 KSharedConfig::openConfig(const QString&)
    {100, 2149, 475, 2, Smoke::mf_static, 195, 5},	//2607 KSharedConfig::openConfig(const QString&, QFlags<KConfig::OpenFlag>)
    {100, 2149, 430, 1, Smoke::mf_static, 195, 6},	//2608 KSharedConfig::openConfig(const KComponentData&)
    {100, 2149, 478, 2, Smoke::mf_static, 195, 7},	//2609 KSharedConfig::openConfig(const KComponentData&, const QString&)
    {100, 2149, 481, 3, Smoke::mf_static, 195, 8},	//2610 KSharedConfig::openConfig(const KComponentData&, const QString&, QFlags<KConfig::OpenFlag>)
    {100, 3408, 0, 0, Smoke::mf_dtor, 0, 9 },	//2611 KSharedConfig::~KSharedConfig()
    {101, 1886, 141, 1, Smoke::mf_static, 351, 1},	//2612 KShell::joinArgs(const QStringList&)
    {101, 3093, 30, 1, Smoke::mf_static, 351, 2},	//2613 KShell::tildeExpand(const QString&)
    {101, 2311, 30, 1, Smoke::mf_static, 351, 3},	//2614 KShell::quoteArg(const QString&)
    {101, 2962, 1772, 3, Smoke::mf_static, 354, 4},	//2615 KShell::splitArgs(const QString&, QFlags<KShell::Option>, KShell::Errors*)
    {101, 2962, 30, 1, Smoke::mf_static, 354, 5},	//2616 KShell::splitArgs(const QString&)
    {101, 2962, 1776, 2, Smoke::mf_static, 354, 6},	//2617 KShell::splitArgs(const QString&, QFlags<KShell::Option>)
    {101, 626, 0, 0, Smoke::mf_static|Smoke::mf_enum, 199, 7},	//2618 KShell::NoOptions (enum)
    {101, 755, 0, 0, Smoke::mf_static|Smoke::mf_enum, 199, 8},	//2619 KShell::TildeExpand (enum)
    {101, 2, 0, 0, Smoke::mf_static|Smoke::mf_enum, 199, 9},	//2620 KShell::AbortOnMeta (enum)
    {101, 623, 0, 0, Smoke::mf_static|Smoke::mf_enum, 197, 10},	//2621 KShell::NoError (enum)
    {101, 38, 0, 0, Smoke::mf_static|Smoke::mf_enum, 197, 11},	//2622 KShell::BadQuoting (enum)
    {101, 146, 0, 0, Smoke::mf_static|Smoke::mf_enum, 197, 12},	//2623 KShell::FoundMeta (enum)
    {102, 1172, 1779, 4, Smoke::mf_static, 358, 1},	//2624 KSocketFactory::connectToHost(const QString&, const QString&, unsigned short, QObject*)
    {102, 1172, 1784, 3, Smoke::mf_static, 358, 2},	//2625 KSocketFactory::connectToHost(const QString&, const QString&, unsigned short)
    {102, 3070, 1788, 3, Smoke::mf_static, 358, 3},	//2626 KSocketFactory::synchronousConnectToHost(const QUrl&, int, QObject*)
    {102, 3070, 1792, 1, Smoke::mf_static, 358, 4},	//2627 KSocketFactory::synchronousConnectToHost(const QUrl&)
    {102, 3070, 1794, 2, Smoke::mf_static, 358, 5},	//2628 KSocketFactory::synchronousConnectToHost(const QUrl&, int)
    {102, 1974, 1797, 4, Smoke::mf_static, 357, 6},	//2629 KSocketFactory::listen(const QString&, const QHostAddress&, unsigned short, QObject*)
    {102, 1974, 30, 1, Smoke::mf_static, 357, 7},	//2630 KSocketFactory::listen(const QString&)
    {102, 1974, 1802, 2, Smoke::mf_static, 357, 8},	//2631 KSocketFactory::listen(const QString&, const QHostAddress&)
    {102, 1974, 1805, 3, Smoke::mf_static, 357, 9},	//2632 KSocketFactory::listen(const QString&, const QHostAddress&, unsigned short)
    {102, 1172, 1809, 4, Smoke::mf_static, 0, 10},	//2633 KSocketFactory::connectToHost(QTcpSocket*, const QString&, const QString&, unsigned short)
    {102, 2295, 30, 1, Smoke::mf_static, 344, 11},	//2634 KSocketFactory::proxyForListening(const QString&)
    {102, 1172, 1814, 2, Smoke::mf_static, 358, 12},	//2635 KSocketFactory::connectToHost(const QUrl&, QObject*)
    {102, 1172, 1792, 1, Smoke::mf_static, 358, 13},	//2636 KSocketFactory::connectToHost(const QUrl&)
    {102, 3070, 1817, 5, Smoke::mf_static, 358, 14},	//2637 KSocketFactory::synchronousConnectToHost(const QString&, const QString&, unsigned short, int, QObject*)
    {102, 3070, 1784, 3, Smoke::mf_static, 358, 15},	//2638 KSocketFactory::synchronousConnectToHost(const QString&, const QString&, unsigned short)
    {102, 3070, 1823, 4, Smoke::mf_static, 358, 16},	//2639 KSocketFactory::synchronousConnectToHost(const QString&, const QString&, unsigned short, int)
    {102, 1172, 1828, 2, Smoke::mf_static, 0, 17},	//2640 KSocketFactory::connectToHost(QTcpSocket*, const QUrl&)
    {102, 1250, 1831, 3, Smoke::mf_static, 363, 18},	//2641 KSocketFactory::datagramSocket(const QString&, const QString&, QObject*)
    {102, 1250, 95, 2, Smoke::mf_static, 363, 19},	//2642 KSocketFactory::datagramSocket(const QString&, const QString&)
    {102, 2291, 95, 2, Smoke::mf_static, 344, 20},	//2643 KSocketFactory::proxyForConnection(const QString&, const QString&)
    {102, 3070, 1835, 3, Smoke::mf_static, 0, 21},	//2644 KSocketFactory::synchronousConnectToHost(QTcpSocket*, const QUrl&, int)
    {102, 3070, 1828, 2, Smoke::mf_static, 0, 22},	//2645 KSocketFactory::synchronousConnectToHost(QTcpSocket*, const QUrl&)
    {102, 2293, 95, 2, Smoke::mf_static, 344, 23},	//2646 KSocketFactory::proxyForDatagram(const QString&, const QString&)
    {102, 3070, 1839, 5, Smoke::mf_static, 0, 24},	//2647 KSocketFactory::synchronousConnectToHost(QTcpSocket*, const QString&, const QString&, unsigned short, int)
    {102, 3070, 1809, 4, Smoke::mf_static, 0, 25},	//2648 KSocketFactory::synchronousConnectToHost(QTcpSocket*, const QString&, const QString&, unsigned short)
    {103, 491, 0, 0, Smoke::mf_ctor, 200, 1},	//2649 KStandardDirs::KStandardDirs()
    {103, 966, 30, 1, 0, 0, 2},	//2650 KStandardDirs::addPrefix(const QString&)
    {103, 994, 30, 1, 0, 0, 3},	//2651 KStandardDirs::addXdgConfigPrefix(const QString&)
    {103, 996, 30, 1, 0, 0, 4},	//2652 KStandardDirs::addXdgDataPrefix(const QString&)
    {103, 973, 1845, 3, 0, 450, 5},	//2653 KStandardDirs::addResourceType(const char*, const QString&, bool)
    {103, 973, 1849, 4, 0, 450, 6},	//2654 KStandardDirs::addResourceType(const char*, const char*, const QString&, bool)
    {103, 973, 1854, 4, 0, 450, 7},	//2655 KStandardDirs::addResourceType(const char*, const char*, const char*, bool)
    {103, 970, 1845, 3, 0, 450, 8},	//2656 KStandardDirs::addResourceDir(const char*, const QString&, bool)
    {103, 1554, 521, 2, Smoke::mf_const, 351, 9},	//2657 KStandardDirs::findResource(const char*, const QString&) const
    {103, 1850, 521, 2, Smoke::mf_const, 450, 10},	//2658 KStandardDirs::isRestrictedResource(const char*, const QString&) const
    {103, 1087, 1859, 3, Smoke::mf_const, 632, 11},	//2659 KStandardDirs::calcResourceHash(const char*, const QString&, QFlags<KStandardDirs::SearchOption>) const
    {103, 1535, 521, 2, Smoke::mf_const, 354, 12},	//2660 KStandardDirs::findDirs(const char*, const QString&) const
    {103, 1556, 521, 2, Smoke::mf_const, 351, 13},	//2661 KStandardDirs::findResourceDir(const char*, const QString&) const
    {103, 1507, 1859, 3, Smoke::mf_const, 354, 14},	//2662 KStandardDirs::findAllResources(const char*, const QString&, QFlags<KStandardDirs::SearchOption>) const
    {103, 1507, 1863, 4, Smoke::mf_const, 354, 15},	//2663 KStandardDirs::findAllResources(const char*, const QString&, QFlags<KStandardDirs::SearchOption>, QStringList&) const
    {103, 3081, 30, 1, Smoke::mf_static, 354, 16},	//2664 KStandardDirs::systemPaths(const QString&)
    {103, 1539, 1868, 3, Smoke::mf_static, 351, 17},	//2665 KStandardDirs::findExe(const QString&, const QString&, QFlags<KStandardDirs::SearchOption>)
    {103, 1503, 1872, 4, Smoke::mf_static, 614, 18},	//2666 KStandardDirs::findAllExe(QStringList&, const QString&, const QString&, QFlags<KStandardDirs::SearchOption>)
    {103, 867, 595, 1, 0, 450, 19},	//2667 KStandardDirs::addCustomized(KConfig*)
    {103, 2447, 122, 1, Smoke::mf_const, 354, 20},	//2668 KStandardDirs::resourceDirs(const char*) const
    {103, 1018, 0, 0, Smoke::mf_const, 354, 21},	//2669 KStandardDirs::allTypes() const
    {103, 2464, 1845, 3, Smoke::mf_const, 351, 22},	//2670 KStandardDirs::saveLocation(const char*, const QString&, bool) const
    {103, 2403, 521, 2, 0, 351, 23},	//2671 KStandardDirs::relativeLocation(const char*, const QString&)
    {103, 2040, 1014, 2, Smoke::mf_static, 450, 24},	//2672 KStandardDirs::makeDir(const QString&, int)
    {103, 1906, 122, 1, Smoke::mf_static, 351, 25},	//2673 KStandardDirs::kde_default(const char*)
    {103, 1927, 0, 0, 0, 351, 26},	//2674 KStandardDirs::kfsstnd_prefixes()
    {103, 1928, 0, 0, 0, 351, 27},	//2675 KStandardDirs::kfsstnd_xdg_conf_prefixes()
    {103, 1929, 0, 0, 0, 351, 28},	//2676 KStandardDirs::kfsstnd_xdg_data_prefixes()
    {103, 1990, 0, 0, Smoke::mf_const, 351, 29},	//2677 KStandardDirs::localkdedir() const
    {103, 1992, 0, 0, Smoke::mf_const, 351, 30},	//2678 KStandardDirs::localxdgdatadir() const
    {103, 1991, 0, 0, Smoke::mf_const, 351, 31},	//2679 KStandardDirs::localxdgconfdir() const
    {103, 1744, 122, 1, Smoke::mf_static, 351, 32},	//2680 KStandardDirs::installPath(const char*)
    {103, 1461, 30, 1, Smoke::mf_static, 450, 33},	//2681 KStandardDirs::exists(const QString&)
    {103, 2394, 30, 1, Smoke::mf_static, 351, 34},	//2682 KStandardDirs::realPath(const QString&)
    {103, 2391, 30, 1, Smoke::mf_static, 351, 35},	//2683 KStandardDirs::realFilePath(const QString&)
    {103, 1993, 1877, 3, Smoke::mf_static, 351, 36},	//2684 KStandardDirs::locate(const char*, const QString&, const KComponentData&)
    {103, 1996, 1877, 3, Smoke::mf_static, 351, 37},	//2685 KStandardDirs::locateLocal(const char*, const QString&, const KComponentData&)
    {103, 1996, 1881, 4, Smoke::mf_static, 351, 38},	//2686 KStandardDirs::locateLocal(const char*, const QString&, bool, const KComponentData&)
    {103, 1122, 1014, 2, Smoke::mf_static, 450, 39},	//2687 KStandardDirs::checkAccess(const QString&, int)
    {103, 973, 521, 2, 0, 450, 40},	//2688 KStandardDirs::addResourceType(const char*, const QString&)
    {103, 973, 1886, 3, 0, 450, 41},	//2689 KStandardDirs::addResourceType(const char*, const char*, const QString&)
    {103, 973, 1336, 3, 0, 450, 42},	//2690 KStandardDirs::addResourceType(const char*, const char*, const char*)
    {103, 970, 521, 2, 0, 450, 43},	//2691 KStandardDirs::addResourceDir(const char*, const QString&)
    {103, 1850, 122, 1, Smoke::mf_const, 450, 44},	//2692 KStandardDirs::isRestrictedResource(const char*) const
    {103, 1087, 521, 2, Smoke::mf_const, 632, 45},	//2693 KStandardDirs::calcResourceHash(const char*, const QString&) const
    {103, 1507, 122, 1, Smoke::mf_const, 354, 46},	//2694 KStandardDirs::findAllResources(const char*) const
    {103, 1507, 521, 2, Smoke::mf_const, 354, 47},	//2695 KStandardDirs::findAllResources(const char*, const QString&) const
    {103, 3081, 0, 0, Smoke::mf_static, 354, 48},	//2696 KStandardDirs::systemPaths()
    {103, 1539, 30, 1, Smoke::mf_static, 351, 49},	//2697 KStandardDirs::findExe(const QString&)
    {103, 1539, 95, 2, Smoke::mf_static, 351, 50},	//2698 KStandardDirs::findExe(const QString&, const QString&)
    {103, 1503, 1890, 2, Smoke::mf_static, 614, 51},	//2699 KStandardDirs::findAllExe(QStringList&, const QString&)
    {103, 1503, 1893, 3, Smoke::mf_static, 614, 52},	//2700 KStandardDirs::findAllExe(QStringList&, const QString&, const QString&)
    {103, 2464, 122, 1, Smoke::mf_const, 351, 53},	//2701 KStandardDirs::saveLocation(const char*) const
    {103, 2464, 521, 2, Smoke::mf_const, 351, 54},	//2702 KStandardDirs::saveLocation(const char*, const QString&) const
    {103, 2040, 30, 1, Smoke::mf_static, 450, 55},	//2703 KStandardDirs::makeDir(const QString&)
    {103, 1993, 521, 2, Smoke::mf_static, 351, 56},	//2704 KStandardDirs::locate(const char*, const QString&)
    {103, 1996, 521, 2, Smoke::mf_static, 351, 57},	//2705 KStandardDirs::locateLocal(const char*, const QString&)
    {103, 1996, 1845, 3, Smoke::mf_static, 351, 58},	//2706 KStandardDirs::locateLocal(const char*, const QString&, bool)
    {103, 629, 0, 0, Smoke::mf_static|Smoke::mf_enum, 201, 59},	//2707 KStandardDirs::NoSearchOptions (enum)
    {103, 692, 0, 0, Smoke::mf_static|Smoke::mf_enum, 201, 60},	//2708 KStandardDirs::Recursive (enum)
    {103, 622, 0, 0, Smoke::mf_static|Smoke::mf_enum, 201, 61},	//2709 KStandardDirs::NoDuplicates (enum)
    {103, 170, 0, 0, Smoke::mf_static|Smoke::mf_enum, 201, 62},	//2710 KStandardDirs::IgnoreExecBit (enum)
    {103, 3409, 0, 0, Smoke::mf_dtor, 0, 63 },	//2711 KStandardDirs::~KStandardDirs()
    {104, 2232, 1897, 3, Smoke::mf_static, 354, 1},	//2712 KStringHandler::perlSplit(const QString&, const QString&, int)
    {104, 2232, 95, 2, Smoke::mf_static, 354, 2},	//2713 KStringHandler::perlSplit(const QString&, const QString&)
    {104, 2108, 1901, 3, Smoke::mf_static, 614, 3},	//2714 KStringHandler::naturalCompare(const QString&, const QString&, Qt::CaseSensitivity)
    {104, 2108, 95, 2, Smoke::mf_static, 614, 4},	//2715 KStringHandler::naturalCompare(const QString&, const QString&)
    {104, 1606, 122, 1, Smoke::mf_static, 351, 5},	//2716 KStringHandler::from8Bit(const char*)
    {104, 1869, 122, 1, Smoke::mf_static, 450, 6},	//2717 KStringHandler::isUtf8(const char*)
    {104, 2007, 1014, 2, Smoke::mf_static, 351, 7},	//2718 KStringHandler::lsqueeze(const QString&, int)
    {104, 2007, 30, 1, Smoke::mf_static, 351, 8},	//2719 KStringHandler::lsqueeze(const QString&)
    {104, 1109, 30, 1, Smoke::mf_static, 351, 9},	//2720 KStringHandler::capwords(const QString&)
    {104, 1220, 1014, 2, Smoke::mf_static, 351, 10},	//2721 KStringHandler::csqueeze(const QString&, int)
    {104, 1220, 30, 1, Smoke::mf_static, 351, 11},	//2722 KStringHandler::csqueeze(const QString&)
    {104, 2232, 1905, 3, Smoke::mf_static, 354, 12},	//2723 KStringHandler::perlSplit(const QChar&, const QString&, int)
    {104, 2232, 1909, 2, Smoke::mf_static, 354, 13},	//2724 KStringHandler::perlSplit(const QChar&, const QString&)
    {104, 2251, 30, 1, Smoke::mf_static, 351, 14},	//2725 KStringHandler::preProcessWrap(const QString&)
    {104, 2232, 1912, 3, Smoke::mf_static, 354, 15},	//2726 KStringHandler::perlSplit(const QRegExp&, const QString&, int)
    {104, 2232, 1916, 2, Smoke::mf_static, 354, 16},	//2727 KStringHandler::perlSplit(const QRegExp&, const QString&)
    {104, 2131, 30, 1, Smoke::mf_static, 351, 17},	//2728 KStringHandler::obscure(const QString&)
    {104, 1109, 141, 1, Smoke::mf_static, 354, 18},	//2729 KStringHandler::capwords(const QStringList&)
    {104, 2457, 1014, 2, Smoke::mf_static, 351, 19},	//2730 KStringHandler::rsqueeze(const QString&, int)
    {104, 2457, 30, 1, Smoke::mf_static, 351, 20},	//2731 KStringHandler::rsqueeze(const QString&)
    {104, 3083, 30, 1, Smoke::mf_static, 351, 21},	//2732 KStringHandler::tagUrls(const QString&)
    {105, 2060, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 582, 1},	//2733 KSycoca::metaObject() const
    {105, 2301, 122, 1, Smoke::mf_virtual, 639, 2},	//2734 KSycoca::qt_metacast(const char*)
    {105, 3131, 124, 2, Smoke::mf_static, 351, 3},	//2735 KSycoca::tr(const char*, const char*)
    {105, 3138, 124, 2, Smoke::mf_static, 351, 4},	//2736 KSycoca::trUtf8(const char*, const char*)
    {105, 3131, 127, 3, Smoke::mf_static, 351, 5},	//2737 KSycoca::tr(const char*, const char*, int)
    {105, 3138, 127, 3, Smoke::mf_static, 351, 6},	//2738 KSycoca::trUtf8(const char*, const char*, int)
    {105, 2299, 131, 3, Smoke::mf_virtual, 614, 7},	//2739 KSycoca::qt_metacall(QMetaObject::Call, int, void**)
    {105, 492, 103, 1, Smoke::mf_ctor|Smoke::mf_protected, 202, 8},	//2740 KSycoca::KSycoca(bool)
    {105, 3234, 0, 0, Smoke::mf_static, 614, 9},	//2741 KSycoca::version()
    {105, 1781, 0, 0, Smoke::mf_static, 450, 10},	//2742 KSycoca::isAvailable()
    {105, 1537, 1919, 2, 0, 274, 11},	//2743 KSycoca::findEntry(int, KSycocaType&)
    {105, 1543, 1922, 1, 0, 274, 12},	//2744 KSycoca::findFactory(KSycocaFactoryId)
    {105, 1927, 0, 0, 0, 351, 13},	//2745 KSycoca::kfsstnd_prefixes()
    {105, 829, 1924, 1, Smoke::mf_static, 351, 14},	//2746 KSycoca::absoluteFilePath(DatabaseType)
    {105, 1947, 0, 0, 0, 351, 15},	//2747 KSycoca::language()
    {105, 3098, 0, 0, 0, 632, 16},	//2748 KSycoca::timeStamp()
    {105, 3198, 0, 0, 0, 632, 17},	//2749 KSycoca::updateSignature()
    {105, 1013, 0, 0, 0, 354, 18},	//2750 KSycoca::allResourceDirs()
    {105, 876, 1926, 1, 0, 0, 19},	//2751 KSycoca::addFactory(KSycocaFactory*)
    {105, 1786, 0, 0, Smoke::mf_virtual, 450, 20},	//2752 KSycoca::isBuilding()
    {105, 1378, 0, 0, Smoke::mf_static, 0, 21},	//2753 KSycoca::disableAutoRebuild()
    {105, 1787, 122, 1, Smoke::mf_static, 450, 22},	//2754 KSycoca::isChanged(const char*)
    {105, 1567, 0, 0, Smoke::mf_static, 0, 23},	//2755 KSycoca::flagError()
    {105, 2356, 0, 0, Smoke::mf_static, 450, 24},	//2756 KSycoca::readError()
    {105, 1248, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 25},	//2757 KSycoca::databaseChanged()
    {105, 1248, 141, 1, Smoke::mf_protected|Smoke::mf_signal, 0, 26},	//2758 KSycoca::databaseChanged(const QStringList&)
    {105, 1484, 0, 0, Smoke::mf_protected, 209, 27},	//2759 KSycoca::factories()
    {105, 3041, 0, 0, Smoke::mf_protected, 275, 28},	//2760 KSycoca::stream()
    {105, 3131, 122, 1, Smoke::mf_static, 351, 29},	//2761 KSycoca::tr(const char*)
    {105, 3138, 122, 1, Smoke::mf_static, 351, 30},	//2762 KSycoca::trUtf8(const char*)
    {105, 829, 0, 0, Smoke::mf_static, 351, 31},	//2763 KSycoca::absoluteFilePath()
    {105, 3030, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 581, 32},	//2764 KSycoca::staticMetaObject() const
    {105, 2029, 0, 0, Smoke::mf_const|Smoke::mf_protected|Smoke::mf_attribute, 274, 33},	//2765 KSycoca::m_str_deprecated() const
    {105, 2734, 1928, 1, Smoke::mf_protected|Smoke::mf_attribute, 0, 34},	//2766 KSycoca::setM_str_deprecated(QDataStream*)
    {105, 586, 0, 0, Smoke::mf_static|Smoke::mf_enum, 203, 35},	//2767 KSycoca::LocalDatabase (enum)
    {105, 151, 0, 0, Smoke::mf_static|Smoke::mf_enum, 203, 36},	//2768 KSycoca::GlobalDatabase (enum)
    {105, 3410, 0, 0, Smoke::mf_dtor, 0, 37 },	//2769 KSycoca::~KSycoca()
    {106, 494, 0, 0, Smoke::mf_ctor, 205, 1},	//2770 KSycocaEntry::KSycocaEntry()
    {106, 1866, 1930, 1, Smoke::mf_const, 450, 2},	//2771 KSycocaEntry::isType(KSycocaType) const
    {106, 3067, 0, 0, Smoke::mf_const, 210, 3},	//2772 KSycocaEntry::sycocaType() const
    {106, 2329, 1932, 2, Smoke::mf_static, 0, 4},	//2773 KSycocaEntry::read(QDataStream&, QString&)
    {106, 2329, 1935, 2, Smoke::mf_static, 0, 5},	//2774 KSycocaEntry::read(QDataStream&, QStringList&)
    {106, 2102, 0, 0, Smoke::mf_const, 351, 6},	//2775 KSycocaEntry::name() const
    {106, 1421, 0, 0, Smoke::mf_const, 351, 7},	//2776 KSycocaEntry::entryPath() const
    {106, 3038, 0, 0, Smoke::mf_const, 351, 8},	//2777 KSycocaEntry::storageId() const
    {106, 1871, 0, 0, Smoke::mf_const, 450, 9},	//2778 KSycocaEntry::isValid() const
    {106, 1796, 0, 0, Smoke::mf_const, 450, 10},	//2779 KSycocaEntry::isDeleted() const
    {106, 2277, 30, 1, Smoke::mf_const, 364, 11},	//2780 KSycocaEntry::property(const QString&) const
    {106, 2284, 0, 0, Smoke::mf_const, 354, 12},	//2781 KSycocaEntry::propertyNames() const
    {106, 2600, 103, 1, 0, 0, 13},	//2782 KSycocaEntry::setDeleted(bool)
    {106, 1854, 0, 0, Smoke::mf_const, 450, 14},	//2783 KSycocaEntry::isSeparator() const
    {106, 2135, 0, 0, Smoke::mf_const, 614, 15},	//2784 KSycocaEntry::offset() const
    {106, 2460, 381, 1, 0, 0, 16},	//2785 KSycocaEntry::save(QDataStream&)
    {106, 494, 1938, 1, Smoke::mf_ctor|Smoke::mf_protected, 205, 17},	//2786 KSycocaEntry::KSycocaEntry(KSycocaEntryPrivate&)
    {106, 3411, 0, 0, Smoke::mf_dtor, 0, 18 },	//2787 KSycocaEntry::~KSycocaEntry()
    {110, 496, 1940, 6, Smoke::mf_ctor, 212, 1},	//2788 KSystemTimeZone::KSystemTimeZone(KSystemTimeZoneSource*, const QString&, const QString&, float, float, const QString&)
    {110, 496, 1947, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 212, 2},	//2789 KSystemTimeZone::KSystemTimeZone(const KSystemTimeZone&)
    {110, 496, 1949, 2, Smoke::mf_ctor, 212, 3},	//2790 KSystemTimeZone::KSystemTimeZone(KSystemTimeZoneSource*, const QString&)
    {110, 496, 1952, 3, Smoke::mf_ctor, 212, 4},	//2791 KSystemTimeZone::KSystemTimeZone(KSystemTimeZoneSource*, const QString&, const QString&)
    {110, 496, 1956, 4, Smoke::mf_ctor, 212, 5},	//2792 KSystemTimeZone::KSystemTimeZone(KSystemTimeZoneSource*, const QString&, const QString&, float)
    {110, 496, 1961, 5, Smoke::mf_ctor, 212, 6},	//2793 KSystemTimeZone::KSystemTimeZone(KSystemTimeZoneSource*, const QString&, const QString&, float, float)
    {110, 3412, 0, 0, Smoke::mf_dtor, 0, 7 },	//2794 KSystemTimeZone::~KSystemTimeZone()
    {111, 503, 1940, 6, Smoke::mf_ctor, 213, 1},	//2795 KSystemTimeZoneBackend::KSystemTimeZoneBackend(KSystemTimeZoneSource*, const QString&, const QString&, float, float, const QString&)
    {111, 1148, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 230, 2},	//2796 KSystemTimeZoneBackend::clone() const
    {111, 3174, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 264, 3},	//2797 KSystemTimeZoneBackend::type() const
    {111, 2141, 1967, 3, Smoke::mf_const|Smoke::mf_virtual, 614, 4},	//2798 KSystemTimeZoneBackend::offsetAtZoneTime(const KTimeZone*, const QDateTime&, int*) const
    {111, 2138, 1971, 2, Smoke::mf_const|Smoke::mf_virtual, 614, 5},	//2799 KSystemTimeZoneBackend::offsetAtUtc(const KTimeZone*, const QDateTime&) const
    {111, 2135, 1974, 2, Smoke::mf_const|Smoke::mf_virtual, 614, 6},	//2800 KSystemTimeZoneBackend::offset(const KTimeZone*, time_t) const
    {111, 1804, 1971, 2, Smoke::mf_const|Smoke::mf_virtual, 450, 7},	//2801 KSystemTimeZoneBackend::isDstAtUtc(const KTimeZone*, const QDateTime&) const
    {111, 1801, 1974, 2, Smoke::mf_const|Smoke::mf_virtual, 450, 8},	//2802 KSystemTimeZoneBackend::isDst(const KTimeZone*, time_t) const
    {111, 503, 1977, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 213, 9},	//2803 KSystemTimeZoneBackend::KSystemTimeZoneBackend(const KSystemTimeZoneBackend&)
    {111, 3413, 0, 0, Smoke::mf_dtor, 0, 10 },	//2804 KSystemTimeZoneBackend::~KSystemTimeZoneBackend()
    {112, 506, 0, 0, Smoke::mf_ctor, 214, 1},	//2805 KSystemTimeZoneSource::KSystemTimeZoneSource()
    {112, 2219, 1041, 1, Smoke::mf_const|Smoke::mf_virtual, 232, 2},	//2806 KSystemTimeZoneSource::parse(const KTimeZone&) const
    {112, 2978, 0, 0, Smoke::mf_static, 0, 3},	//2807 KSystemTimeZoneSource::startParseBlock()
    {112, 1413, 0, 0, Smoke::mf_static, 0, 4},	//2808 KSystemTimeZoneSource::endParseBlock()
    {112, 506, 1979, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 214, 5},	//2809 KSystemTimeZoneSource::KSystemTimeZoneSource(const KSystemTimeZoneSource&)
    {112, 3414, 0, 0, Smoke::mf_dtor, 0, 6 },	//2810 KSystemTimeZoneSource::~KSystemTimeZoneSource()
    {113, 2060, 0, 0, Smoke::mf_const, 582, 1},	//2811 KSystemTimeZones::metaObject() const
    {113, 2301, 122, 1, 0, 639, 2},	//2812 KSystemTimeZones::qt_metacast(const char*)
    {113, 3131, 124, 2, Smoke::mf_static, 351, 3},	//2813 KSystemTimeZones::tr(const char*, const char*)
    {113, 3138, 124, 2, Smoke::mf_static, 351, 4},	//2814 KSystemTimeZones::trUtf8(const char*, const char*)
    {113, 3131, 127, 3, Smoke::mf_static, 351, 5},	//2815 KSystemTimeZones::tr(const char*, const char*, int)
    {113, 3138, 127, 3, Smoke::mf_static, 351, 6},	//2816 KSystemTimeZones::trUtf8(const char*, const char*, int)
    {113, 2299, 131, 3, 0, 614, 7},	//2817 KSystemTimeZones::qt_metacall(QMetaObject::Call, int, void**)
    {113, 3101, 0, 0, Smoke::mf_static, 234, 8},	//2818 KSystemTimeZones::timeZones()
    {113, 3326, 0, 0, Smoke::mf_static, 578, 9},	//2819 KSystemTimeZones::zones()
    {113, 3323, 30, 1, Smoke::mf_static, 217, 10},	//2820 KSystemTimeZones::zone(const QString&)
    {113, 2388, 30, 1, Smoke::mf_static, 217, 11},	//2821 KSystemTimeZones::readZone(const QString&)
    {113, 1984, 0, 0, Smoke::mf_static, 217, 12},	//2822 KSystemTimeZones::local()
    {113, 2393, 0, 0, Smoke::mf_static, 217, 13},	//2823 KSystemTimeZones::realLocalZone()
    {113, 2690, 1041, 1, Smoke::mf_static, 0, 14},	//2824 KSystemTimeZones::setLocalZone(const KTimeZone&)
    {113, 1860, 0, 0, Smoke::mf_static, 450, 15},	//2825 KSystemTimeZones::isSimulated()
    {113, 3325, 0, 0, Smoke::mf_static, 351, 16},	//2826 KSystemTimeZones::zoneinfoDir()
    {113, 1865, 0, 0, Smoke::mf_static, 450, 17},	//2827 KSystemTimeZones::isTimeZoneDaemonAvailable()
    {113, 3131, 122, 1, Smoke::mf_static, 351, 18},	//2828 KSystemTimeZones::tr(const char*)
    {113, 3138, 122, 1, Smoke::mf_static, 351, 19},	//2829 KSystemTimeZones::trUtf8(const char*)
    {113, 3030, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 581, 20},	//2830 KSystemTimeZones::staticMetaObject() const
    {113, 3415, 0, 0, Smoke::mf_dtor, 0, 21 },	//2831 KSystemTimeZones::~KSystemTimeZones()
    {114, 508, 1014, 2, Smoke::mf_ctor, 215, 1},	//2832 KTempDir::KTempDir(const QString&, int)
    {114, 2521, 103, 1, 0, 0, 2},	//2833 KTempDir::setAutoRemove(bool)
    {114, 1052, 0, 0, Smoke::mf_const, 450, 3},	//2834 KTempDir::autoRemove() const
    {114, 3033, 0, 0, Smoke::mf_const, 614, 4},	//2835 KTempDir::status() const
    {114, 2102, 0, 0, Smoke::mf_const, 351, 5},	//2836 KTempDir::name() const
    {114, 3180, 0, 0, 0, 0, 6},	//2837 KTempDir::unlink()
    {114, 1461, 0, 0, Smoke::mf_const, 450, 7},	//2838 KTempDir::exists() const
    {114, 2418, 30, 1, Smoke::mf_static, 450, 8},	//2839 KTempDir::removeDir(const QString&)
    {114, 1205, 1014, 2, Smoke::mf_protected, 450, 9},	//2840 KTempDir::create(const QString&, int)
    {114, 508, 0, 0, Smoke::mf_ctor, 215, 10},	//2841 KTempDir::KTempDir()
    {114, 508, 30, 1, Smoke::mf_ctor, 215, 11},	//2842 KTempDir::KTempDir(const QString&)
    {114, 3416, 0, 0, Smoke::mf_dtor, 0, 12 },	//2843 KTempDir::~KTempDir()
    {115, 511, 430, 1, Smoke::mf_ctor, 216, 1},	//2844 KTemporaryFile::KTemporaryFile(const KComponentData&)
    {115, 2825, 30, 1, 0, 0, 2},	//2845 KTemporaryFile::setPrefix(const QString&)
    {115, 2878, 30, 1, 0, 0, 3},	//2846 KTemporaryFile::setSuffix(const QString&)
    {115, 511, 0, 0, Smoke::mf_ctor, 216, 4},	//2847 KTemporaryFile::KTemporaryFile()
    {115, 3417, 0, 0, Smoke::mf_dtor, 0, 5 },	//2848 KTemporaryFile::~KTemporaryFile()
    {116, 513, 0, 0, Smoke::mf_ctor, 219, 1},	//2849 KTimeZone::KTimeZone()
    {116, 513, 30, 1, Smoke::mf_ctor, 219, 2},	//2850 KTimeZone::KTimeZone(const QString&)
    {116, 513, 1041, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 219, 3},	//2851 KTimeZone::KTimeZone(const KTimeZone&)
    {116, 2182, 1041, 1, 0, 218, 4},	//2852 KTimeZone::operator=(const KTimeZone&)
    {116, 2185, 1041, 1, Smoke::mf_const, 450, 5},	//2853 KTimeZone::operator==(const KTimeZone&) const
    {116, 2158, 1041, 1, Smoke::mf_const, 450, 6},	//2854 KTimeZone::operator!=(const KTimeZone&) const
    {116, 3174, 0, 0, Smoke::mf_const, 264, 7},	//2855 KTimeZone::type() const
    {116, 1871, 0, 0, Smoke::mf_const, 450, 8},	//2856 KTimeZone::isValid() const
    {116, 2102, 0, 0, Smoke::mf_const, 351, 9},	//2857 KTimeZone::name() const
    {116, 1201, 0, 0, Smoke::mf_const, 351, 10},	//2858 KTimeZone::countryCode() const
    {116, 1961, 0, 0, Smoke::mf_const, 612, 11},	//2859 KTimeZone::latitude() const
    {116, 2006, 0, 0, Smoke::mf_const, 612, 12},	//2860 KTimeZone::longitude() const
    {116, 1159, 0, 0, Smoke::mf_const, 351, 13},	//2861 KTimeZone::comment() const
    {116, 825, 0, 0, Smoke::mf_const, 333, 14},	//2862 KTimeZone::abbreviations() const
    {116, 823, 1037, 1, Smoke::mf_const, 264, 15},	//2863 KTimeZone::abbreviation(const QDateTime&) const
    {116, 3222, 0, 0, Smoke::mf_const, 337, 16},	//2864 KTimeZone::utcOffsets() const
    {116, 1185, 1981, 2, Smoke::mf_const, 278, 17},	//2865 KTimeZone::convert(const KTimeZone&, const QDateTime&) const
    {116, 3120, 1037, 1, Smoke::mf_const, 278, 18},	//2866 KTimeZone::toUtc(const QDateTime&) const
    {116, 3124, 1984, 2, Smoke::mf_const, 278, 19},	//2867 KTimeZone::toZoneTime(const QDateTime&, bool*) const
    {116, 1237, 1987, 1, Smoke::mf_const, 614, 20},	//2868 KTimeZone::currentOffset(Qt::TimeSpec) const
    {116, 2141, 1989, 2, Smoke::mf_const|Smoke::mf_virtual, 614, 21},	//2869 KTimeZone::offsetAtZoneTime(const QDateTime&, int*) const
    {116, 2138, 1037, 1, Smoke::mf_const|Smoke::mf_virtual, 614, 22},	//2870 KTimeZone::offsetAtUtc(const QDateTime&) const
    {116, 2135, 1992, 1, Smoke::mf_const|Smoke::mf_virtual, 614, 23},	//2871 KTimeZone::offset(time_t) const
    {116, 1804, 1037, 1, Smoke::mf_const|Smoke::mf_virtual, 450, 24},	//2872 KTimeZone::isDstAtUtc(const QDateTime&) const
    {116, 1801, 1992, 1, Smoke::mf_const|Smoke::mf_virtual, 450, 25},	//2873 KTimeZone::isDst(time_t) const
    {116, 2238, 0, 0, Smoke::mf_const, 329, 26},	//2874 KTimeZone::phases() const
    {116, 1700, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 450, 27},	//2875 KTimeZone::hasTransitions() const
    {116, 3156, 1994, 2, Smoke::mf_const, 330, 28},	//2876 KTimeZone::transitions(const QDateTime&, const QDateTime&) const
    {116, 3144, 1997, 3, Smoke::mf_const, 530, 29},	//2877 KTimeZone::transition(const QDateTime&, const KTimeZone::Transition**, bool*) const
    {116, 3148, 2001, 3, Smoke::mf_const, 614, 30},	//2878 KTimeZone::transitionIndex(const QDateTime&, int*, bool*) const
    {116, 3152, 2005, 3, Smoke::mf_const, 334, 31},	//2879 KTimeZone::transitionTimes(const KTimeZone::Phase&, const QDateTime&, const QDateTime&) const
    {116, 1965, 0, 0, Smoke::mf_const, 328, 32},	//2880 KTimeZone::leapSecondChanges() const
    {116, 2955, 0, 0, Smoke::mf_const, 233, 33},	//2881 KTimeZone::source() const
    {116, 2219, 0, 0, Smoke::mf_const, 450, 34},	//2882 KTimeZone::parse() const
    {116, 1245, 103, 1, Smoke::mf_const, 534, 35},	//2883 KTimeZone::data(bool) const
    {116, 3196, 1041, 1, 0, 450, 36},	//2884 KTimeZone::updateBase(const KTimeZone&)
    {116, 1632, 1992, 1, Smoke::mf_static, 278, 37},	//2885 KTimeZone::fromTime_t(time_t)
    {116, 3118, 1037, 1, Smoke::mf_static, 628, 38},	//2886 KTimeZone::toTime_t(const QDateTime&)
    {116, 3220, 0, 0, Smoke::mf_static, 217, 39},	//2887 KTimeZone::utc()
    {116, 513, 2009, 1, Smoke::mf_ctor|Smoke::mf_protected, 219, 40},	//2888 KTimeZone::KTimeZone(KTimeZoneBackend*)
    {116, 2565, 2011, 2, Smoke::mf_protected, 0, 41},	//2889 KTimeZone::setData(KTimeZoneData*, KTimeZoneSource*)
    {116, 3124, 1037, 1, Smoke::mf_const, 278, 42},	//2890 KTimeZone::toZoneTime(const QDateTime&) const
    {116, 1237, 0, 0, Smoke::mf_const, 614, 43},	//2891 KTimeZone::currentOffset() const
    {116, 2141, 1037, 1, Smoke::mf_const, 614, 44},	//2892 KTimeZone::offsetAtZoneTime(const QDateTime&) const
    {116, 3156, 0, 0, Smoke::mf_const, 330, 45},	//2893 KTimeZone::transitions() const
    {116, 3156, 1037, 1, Smoke::mf_const, 330, 46},	//2894 KTimeZone::transitions(const QDateTime&) const
    {116, 3144, 1037, 1, Smoke::mf_const, 530, 47},	//2895 KTimeZone::transition(const QDateTime&) const
    {116, 3144, 2014, 2, Smoke::mf_const, 530, 48},	//2896 KTimeZone::transition(const QDateTime&, const KTimeZone::Transition**) const
    {116, 3148, 1037, 1, Smoke::mf_const, 614, 49},	//2897 KTimeZone::transitionIndex(const QDateTime&) const
    {116, 3148, 1989, 2, Smoke::mf_const, 614, 50},	//2898 KTimeZone::transitionIndex(const QDateTime&, int*) const
    {116, 3152, 2017, 1, Smoke::mf_const, 334, 51},	//2899 KTimeZone::transitionTimes(const KTimeZone::Phase&) const
    {116, 3152, 2019, 2, Smoke::mf_const, 334, 52},	//2900 KTimeZone::transitionTimes(const KTimeZone::Phase&, const QDateTime&) const
    {116, 1245, 0, 0, Smoke::mf_const, 534, 53},	//2901 KTimeZone::data() const
    {116, 2565, 2022, 1, Smoke::mf_protected, 0, 54},	//2902 KTimeZone::setData(KTimeZoneData*)
    {116, 180, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 601, 55},	//2903 KTimeZone::InvalidOffset() const
    {116, 181, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 604, 56},	//2904 KTimeZone::InvalidTime_t() const
    {116, 771, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 599, 57},	//2905 KTimeZone::UNKNOWN() const
    {116, 3418, 0, 0, Smoke::mf_dtor, 0, 58 },	//2906 KTimeZone::~KTimeZone()
    {117, 566, 0, 0, Smoke::mf_ctor, 222, 1},	//2907 KTimeZone::LeapSeconds::LeapSeconds()
    {117, 566, 2024, 3, Smoke::mf_ctor, 222, 2},	//2908 KTimeZone::LeapSeconds::LeapSeconds(const QDateTime&, int, const QString&)
    {117, 566, 2028, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 222, 3},	//2909 KTimeZone::LeapSeconds::LeapSeconds(const KTimeZone::LeapSeconds&)
    {117, 2182, 2028, 1, 0, 221, 4},	//2910 KTimeZone::LeapSeconds::operator=(const KTimeZone::LeapSeconds&)
    {117, 2168, 2028, 1, Smoke::mf_const, 450, 5},	//2911 KTimeZone::LeapSeconds::operator<(const KTimeZone::LeapSeconds&) const
    {117, 1871, 0, 0, Smoke::mf_const, 450, 6},	//2912 KTimeZone::LeapSeconds::isValid() const
    {117, 1261, 0, 0, Smoke::mf_const, 278, 7},	//2913 KTimeZone::LeapSeconds::dateTime() const
    {117, 1966, 0, 0, Smoke::mf_const, 614, 8},	//2914 KTimeZone::LeapSeconds::leapSeconds() const
    {117, 1159, 0, 0, Smoke::mf_const, 351, 9},	//2915 KTimeZone::LeapSeconds::comment() const
    {117, 566, 2030, 2, Smoke::mf_ctor, 222, 10},	//2916 KTimeZone::LeapSeconds::LeapSeconds(const QDateTime&, int)
    {117, 3431, 0, 0, Smoke::mf_dtor, 0, 11 },	//2917 KTimeZone::LeapSeconds::~LeapSeconds()
    {118, 661, 0, 0, Smoke::mf_ctor, 225, 1},	//2918 KTimeZone::Phase::Phase()
    {118, 661, 2033, 4, Smoke::mf_ctor, 225, 2},	//2919 KTimeZone::Phase::Phase(int, const QByteArray&, bool, const QString&)
    {118, 661, 2038, 4, Smoke::mf_ctor, 225, 3},	//2920 KTimeZone::Phase::Phase(int, const QList<QByteArray>&, bool, const QString&)
    {118, 661, 2017, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 225, 4},	//2921 KTimeZone::Phase::Phase(const KTimeZone::Phase&)
    {118, 2182, 2017, 1, 0, 224, 5},	//2922 KTimeZone::Phase::operator=(const KTimeZone::Phase&)
    {118, 2185, 2017, 1, Smoke::mf_const, 450, 6},	//2923 KTimeZone::Phase::operator==(const KTimeZone::Phase&) const
    {118, 2158, 2017, 1, Smoke::mf_const, 450, 7},	//2924 KTimeZone::Phase::operator!=(const KTimeZone::Phase&) const
    {118, 3221, 0, 0, Smoke::mf_const, 614, 8},	//2925 KTimeZone::Phase::utcOffset() const
    {118, 825, 0, 0, Smoke::mf_const, 333, 9},	//2926 KTimeZone::Phase::abbreviations() const
    {118, 1801, 0, 0, Smoke::mf_const, 450, 10},	//2927 KTimeZone::Phase::isDst() const
    {118, 1159, 0, 0, Smoke::mf_const, 351, 11},	//2928 KTimeZone::Phase::comment() const
    {118, 661, 2043, 3, Smoke::mf_ctor, 225, 12},	//2929 KTimeZone::Phase::Phase(int, const QByteArray&, bool)
    {118, 661, 2047, 3, Smoke::mf_ctor, 225, 13},	//2930 KTimeZone::Phase::Phase(int, const QList<QByteArray>&, bool)
    {118, 3433, 0, 0, Smoke::mf_dtor, 0, 14 },	//2931 KTimeZone::Phase::~Phase()
    {119, 766, 0, 0, Smoke::mf_ctor, 228, 1},	//2932 KTimeZone::Transition::Transition()
    {119, 766, 2051, 2, Smoke::mf_ctor, 228, 2},	//2933 KTimeZone::Transition::Transition(const QDateTime&, const KTimeZone::Phase&)
    {119, 766, 2054, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 228, 3},	//2934 KTimeZone::Transition::Transition(const KTimeZone::Transition&)
    {119, 2182, 2054, 1, 0, 227, 4},	//2935 KTimeZone::Transition::operator=(const KTimeZone::Transition&)
    {119, 3095, 0, 0, Smoke::mf_const, 278, 5},	//2936 KTimeZone::Transition::time() const
    {119, 2237, 0, 0, Smoke::mf_const, 223, 6},	//2937 KTimeZone::Transition::phase() const
    {119, 2168, 2054, 1, Smoke::mf_const, 450, 7},	//2938 KTimeZone::Transition::operator<(const KTimeZone::Transition&) const
    {119, 3436, 0, 0, Smoke::mf_dtor, 0, 8 },	//2939 KTimeZone::Transition::~Transition()
    {120, 516, 0, 0, Smoke::mf_ctor, 230, 1},	//2940 KTimeZoneBackend::KTimeZoneBackend()
    {120, 516, 30, 1, Smoke::mf_ctor, 230, 2},	//2941 KTimeZoneBackend::KTimeZoneBackend(const QString&)
    {120, 516, 2056, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 230, 3},	//2942 KTimeZoneBackend::KTimeZoneBackend(const KTimeZoneBackend&)
    {120, 2182, 2056, 1, 0, 229, 4},	//2943 KTimeZoneBackend::operator=(const KTimeZoneBackend&)
    {120, 1148, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 230, 5},	//2944 KTimeZoneBackend::clone() const
    {120, 3174, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 264, 6},	//2945 KTimeZoneBackend::type() const
    {120, 2141, 1967, 3, Smoke::mf_const|Smoke::mf_virtual, 614, 7},	//2946 KTimeZoneBackend::offsetAtZoneTime(const KTimeZone*, const QDateTime&, int*) const
    {120, 2138, 1971, 2, Smoke::mf_const|Smoke::mf_virtual, 614, 8},	//2947 KTimeZoneBackend::offsetAtUtc(const KTimeZone*, const QDateTime&) const
    {120, 2135, 1974, 2, Smoke::mf_const|Smoke::mf_virtual, 614, 9},	//2948 KTimeZoneBackend::offset(const KTimeZone*, time_t) const
    {120, 1804, 1971, 2, Smoke::mf_const|Smoke::mf_virtual, 450, 10},	//2949 KTimeZoneBackend::isDstAtUtc(const KTimeZone*, const QDateTime&) const
    {120, 1801, 1974, 2, Smoke::mf_const|Smoke::mf_virtual, 450, 11},	//2950 KTimeZoneBackend::isDst(const KTimeZone*, time_t) const
    {120, 1700, 2058, 1, Smoke::mf_const|Smoke::mf_virtual, 450, 12},	//2951 KTimeZoneBackend::hasTransitions(const KTimeZone*) const
    {120, 516, 2060, 6, Smoke::mf_ctor|Smoke::mf_protected, 230, 13},	//2952 KTimeZoneBackend::KTimeZoneBackend(KTimeZoneSource*, const QString&, const QString&, float, float, const QString&)
    {120, 516, 2067, 2, Smoke::mf_ctor|Smoke::mf_protected, 230, 14},	//2953 KTimeZoneBackend::KTimeZoneBackend(KTimeZoneSource*, const QString&)
    {120, 516, 2070, 3, Smoke::mf_ctor|Smoke::mf_protected, 230, 15},	//2954 KTimeZoneBackend::KTimeZoneBackend(KTimeZoneSource*, const QString&, const QString&)
    {120, 516, 2074, 4, Smoke::mf_ctor|Smoke::mf_protected, 230, 16},	//2955 KTimeZoneBackend::KTimeZoneBackend(KTimeZoneSource*, const QString&, const QString&, float)
    {120, 516, 2079, 5, Smoke::mf_ctor|Smoke::mf_protected, 230, 17},	//2956 KTimeZoneBackend::KTimeZoneBackend(KTimeZoneSource*, const QString&, const QString&, float, float)
    {120, 3419, 0, 0, Smoke::mf_dtor, 0, 18 },	//2957 KTimeZoneBackend::~KTimeZoneBackend()
    {121, 524, 0, 0, Smoke::mf_ctor, 232, 1},	//2958 KTimeZoneData::KTimeZoneData()
    {121, 524, 2085, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 232, 2},	//2959 KTimeZoneData::KTimeZoneData(const KTimeZoneData&)
    {121, 2182, 2085, 1, 0, 231, 3},	//2960 KTimeZoneData::operator=(const KTimeZoneData&)
    {121, 1148, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 232, 4},	//2961 KTimeZoneData::clone() const
    {121, 825, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 333, 5},	//2962 KTimeZoneData::abbreviations() const
    {121, 823, 1037, 1, Smoke::mf_const|Smoke::mf_virtual, 264, 6},	//2963 KTimeZoneData::abbreviation(const QDateTime&) const
    {121, 3222, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 337, 7},	//2964 KTimeZoneData::utcOffsets() const
    {121, 2260, 0, 0, Smoke::mf_const, 614, 8},	//2965 KTimeZoneData::previousUtcOffset() const
    {121, 2238, 0, 0, Smoke::mf_const, 329, 9},	//2966 KTimeZoneData::phases() const
    {121, 1700, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 450, 10},	//2967 KTimeZoneData::hasTransitions() const
    {121, 3156, 1994, 2, Smoke::mf_const, 330, 11},	//2968 KTimeZoneData::transitions(const QDateTime&, const QDateTime&) const
    {121, 3144, 1997, 3, Smoke::mf_const, 530, 12},	//2969 KTimeZoneData::transition(const QDateTime&, const KTimeZone::Transition**, bool*) const
    {121, 3148, 2001, 3, Smoke::mf_const, 614, 13},	//2970 KTimeZoneData::transitionIndex(const QDateTime&, int*, bool*) const
    {121, 3152, 2005, 3, Smoke::mf_const, 334, 14},	//2971 KTimeZoneData::transitionTimes(const KTimeZone::Phase&, const QDateTime&, const QDateTime&) const
    {121, 1965, 0, 0, Smoke::mf_const, 328, 15},	//2972 KTimeZoneData::leapSecondChanges() const
    {121, 1963, 1037, 1, Smoke::mf_const, 220, 16},	//2973 KTimeZoneData::leapSecondChange(const QDateTime&) const
    {121, 2814, 2087, 2, Smoke::mf_protected, 0, 17},	//2974 KTimeZoneData::setPhases(const QList<KTimeZone::Phase>&, const KTimeZone::Phase&)
    {121, 2814, 2090, 2, Smoke::mf_protected, 0, 18},	//2975 KTimeZoneData::setPhases(const QList<KTimeZone::Phase>&, int)
    {121, 2900, 2093, 1, Smoke::mf_protected, 0, 19},	//2976 KTimeZoneData::setTransitions(const QList<KTimeZone::Transition>&)
    {121, 2682, 2095, 1, Smoke::mf_protected, 0, 20},	//2977 KTimeZoneData::setLeapSecondChanges(const QList<KTimeZone::LeapSeconds>&)
    {121, 3156, 0, 0, Smoke::mf_const, 330, 21},	//2978 KTimeZoneData::transitions() const
    {121, 3156, 1037, 1, Smoke::mf_const, 330, 22},	//2979 KTimeZoneData::transitions(const QDateTime&) const
    {121, 3144, 1037, 1, Smoke::mf_const, 530, 23},	//2980 KTimeZoneData::transition(const QDateTime&) const
    {121, 3144, 2014, 2, Smoke::mf_const, 530, 24},	//2981 KTimeZoneData::transition(const QDateTime&, const KTimeZone::Transition**) const
    {121, 3148, 1037, 1, Smoke::mf_const, 614, 25},	//2982 KTimeZoneData::transitionIndex(const QDateTime&) const
    {121, 3148, 1989, 2, Smoke::mf_const, 614, 26},	//2983 KTimeZoneData::transitionIndex(const QDateTime&, int*) const
    {121, 3152, 2017, 1, Smoke::mf_const, 334, 27},	//2984 KTimeZoneData::transitionTimes(const KTimeZone::Phase&) const
    {121, 3152, 2019, 2, Smoke::mf_const, 334, 28},	//2985 KTimeZoneData::transitionTimes(const KTimeZone::Phase&, const QDateTime&) const
    {121, 3420, 0, 0, Smoke::mf_dtor, 0, 29 },	//2986 KTimeZoneData::~KTimeZoneData()
    {122, 526, 0, 0, Smoke::mf_ctor, 233, 1},	//2987 KTimeZoneSource::KTimeZoneSource()
    {122, 2219, 1041, 1, Smoke::mf_const|Smoke::mf_virtual, 232, 2},	//2988 KTimeZoneSource::parse(const KTimeZone&) const
    {122, 3209, 0, 0, Smoke::mf_const, 450, 3},	//2989 KTimeZoneSource::useZoneParse() const
    {122, 526, 103, 1, Smoke::mf_ctor|Smoke::mf_protected, 233, 4},	//2990 KTimeZoneSource::KTimeZoneSource(bool)
    {122, 526, 2097, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 233, 5},	//2991 KTimeZoneSource::KTimeZoneSource(const KTimeZoneSource&)
    {122, 3421, 0, 0, Smoke::mf_dtor, 0, 6 },	//2992 KTimeZoneSource::~KTimeZoneSource()
    {123, 529, 0, 0, Smoke::mf_ctor, 234, 1},	//2993 KTimeZones::KTimeZones()
    {123, 3323, 30, 1, Smoke::mf_const, 217, 2},	//2994 KTimeZones::zone(const QString&) const
    {123, 3326, 0, 0, Smoke::mf_const, 578, 3},	//2995 KTimeZones::zones() const
    {123, 842, 1041, 1, 0, 450, 4},	//2996 KTimeZones::add(const KTimeZone&)
    {123, 2411, 1041, 1, 0, 217, 5},	//2997 KTimeZones::remove(const KTimeZone&)
    {123, 2411, 30, 1, 0, 217, 6},	//2998 KTimeZones::remove(const QString&)
    {123, 1144, 0, 0, 0, 0, 7},	//2999 KTimeZones::clear()
    {123, 3422, 0, 0, Smoke::mf_dtor, 0, 8 },	//3000 KTimeZones::~KTimeZones()
    {124, 2060, 0, 0, Smoke::mf_const, 582, 1},	//3001 KToolInvocation::metaObject() const
    {124, 2301, 122, 1, 0, 639, 2},	//3002 KToolInvocation::qt_metacast(const char*)
    {124, 3131, 124, 2, Smoke::mf_static, 351, 3},	//3003 KToolInvocation::tr(const char*, const char*)
    {124, 3138, 124, 2, Smoke::mf_static, 351, 4},	//3004 KToolInvocation::trUtf8(const char*, const char*)
    {124, 3131, 127, 3, Smoke::mf_static, 351, 5},	//3005 KToolInvocation::tr(const char*, const char*, int)
    {124, 3138, 127, 3, Smoke::mf_static, 351, 6},	//3006 KToolInvocation::trUtf8(const char*, const char*, int)
    {124, 2299, 131, 3, 0, 614, 7},	//3007 KToolInvocation::qt_metacall(QMetaObject::Call, int, void**)
    {124, 2476, 0, 0, Smoke::mf_static, 235, 8},	//3008 KToolInvocation::self()
    {124, 1753, 2099, 3, Smoke::mf_static|Smoke::mf_slot, 0, 9},	//3009 KToolInvocation::invokeHelp(const QString&, const QString&, const QByteArray&)
    {124, 1757, 2099, 3, Smoke::mf_static|Smoke::mf_slot, 0, 10},	//3010 KToolInvocation::invokeMailer(const QString&, const QString&, const QByteArray&)
    {124, 1757, 2103, 3, Smoke::mf_static|Smoke::mf_slot, 0, 11},	//3011 KToolInvocation::invokeMailer(const KUrl&, const QByteArray&, bool)
    {124, 1757, 2107, 8, Smoke::mf_static|Smoke::mf_slot, 0, 12},	//3012 KToolInvocation::invokeMailer(const QString&, const QString&, const QString&, const QString&, const QString&, const QString&, const QStringList&, const QByteArray&)
    {124, 1750, 589, 2, Smoke::mf_static|Smoke::mf_slot, 0, 13},	//3013 KToolInvocation::invokeBrowser(const QString&, const QByteArray&)
    {124, 1767, 2099, 3, Smoke::mf_static|Smoke::mf_slot, 0, 14},	//3014 KToolInvocation::invokeTerminal(const QString&, const QString&, const QByteArray&)
    {124, 1940, 0, 0, Smoke::mf_static, 260, 15},	//3015 KToolInvocation::klauncher()
    {124, 3008, 2116, 7, Smoke::mf_static, 614, 16},	//3016 KToolInvocation::startServiceByName(const QString&, const QString&, QString*, QString*, int*, const QByteArray&, bool)
    {124, 3008, 2124, 7, Smoke::mf_static, 614, 17},	//3017 KToolInvocation::startServiceByName(const QString&, const QStringList&, QString*, QString*, int*, const QByteArray&, bool)
    {124, 2994, 2116, 7, Smoke::mf_static, 614, 18},	//3018 KToolInvocation::startServiceByDesktopPath(const QString&, const QString&, QString*, QString*, int*, const QByteArray&, bool)
    {124, 2994, 2124, 7, Smoke::mf_static, 614, 19},	//3019 KToolInvocation::startServiceByDesktopPath(const QString&, const QStringList&, QString*, QString*, int*, const QByteArray&, bool)
    {124, 2980, 2116, 7, Smoke::mf_static, 614, 20},	//3020 KToolInvocation::startServiceByDesktopName(const QString&, const QString&, QString*, QString*, int*, const QByteArray&, bool)
    {124, 2980, 2124, 7, Smoke::mf_static, 614, 21},	//3021 KToolInvocation::startServiceByDesktopName(const QString&, const QStringList&, QString*, QString*, int*, const QByteArray&, bool)
    {124, 1908, 2132, 5, Smoke::mf_static, 614, 22},	//3022 KToolInvocation::kdeinitExec(const QString&, const QStringList&, QString*, int*, const QByteArray&)
    {124, 1914, 2132, 5, Smoke::mf_static, 614, 23},	//3023 KToolInvocation::kdeinitExecWait(const QString&, const QStringList&, QString*, int*, const QByteArray&)
    {124, 1899, 2138, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 24},	//3024 KToolInvocation::kapplication_hook(QStringList&, QByteArray&)
    {124, 3131, 122, 1, Smoke::mf_static, 351, 25},	//3025 KToolInvocation::tr(const char*)
    {124, 3138, 122, 1, Smoke::mf_static, 351, 26},	//3026 KToolInvocation::trUtf8(const char*)
    {124, 1753, 0, 0, Smoke::mf_static|Smoke::mf_slot, 0, 27},	//3027 KToolInvocation::invokeHelp()
    {124, 1753, 30, 1, Smoke::mf_static|Smoke::mf_slot, 0, 28},	//3028 KToolInvocation::invokeHelp(const QString&)
    {124, 1753, 95, 2, Smoke::mf_static|Smoke::mf_slot, 0, 29},	//3029 KToolInvocation::invokeHelp(const QString&, const QString&)
    {124, 1757, 95, 2, Smoke::mf_static|Smoke::mf_slot, 0, 30},	//3030 KToolInvocation::invokeMailer(const QString&, const QString&)
    {124, 1757, 148, 1, Smoke::mf_static|Smoke::mf_slot, 0, 31},	//3031 KToolInvocation::invokeMailer(const KUrl&)
    {124, 1757, 2141, 2, Smoke::mf_static|Smoke::mf_slot, 0, 32},	//3032 KToolInvocation::invokeMailer(const KUrl&, const QByteArray&)
    {124, 1757, 2144, 5, Smoke::mf_static|Smoke::mf_slot, 0, 33},	//3033 KToolInvocation::invokeMailer(const QString&, const QString&, const QString&, const QString&, const QString&)
    {124, 1757, 2150, 6, Smoke::mf_static|Smoke::mf_slot, 0, 34},	//3034 KToolInvocation::invokeMailer(const QString&, const QString&, const QString&, const QString&, const QString&, const QString&)
    {124, 1757, 2157, 7, Smoke::mf_static|Smoke::mf_slot, 0, 35},	//3035 KToolInvocation::invokeMailer(const QString&, const QString&, const QString&, const QString&, const QString&, const QString&, const QStringList&)
    {124, 1750, 30, 1, Smoke::mf_static|Smoke::mf_slot, 0, 36},	//3036 KToolInvocation::invokeBrowser(const QString&)
    {124, 1767, 30, 1, Smoke::mf_static|Smoke::mf_slot, 0, 37},	//3037 KToolInvocation::invokeTerminal(const QString&)
    {124, 1767, 95, 2, Smoke::mf_static|Smoke::mf_slot, 0, 38},	//3038 KToolInvocation::invokeTerminal(const QString&, const QString&)
    {124, 3008, 95, 2, Smoke::mf_static, 614, 39},	//3039 KToolInvocation::startServiceByName(const QString&, const QString&)
    {124, 3008, 2165, 3, Smoke::mf_static, 614, 40},	//3040 KToolInvocation::startServiceByName(const QString&, const QString&, QString*)
    {124, 3008, 2169, 4, Smoke::mf_static, 614, 41},	//3041 KToolInvocation::startServiceByName(const QString&, const QString&, QString*, QString*)
    {124, 3008, 2174, 5, Smoke::mf_static, 614, 42},	//3042 KToolInvocation::startServiceByName(const QString&, const QString&, QString*, QString*, int*)
    {124, 3008, 2180, 6, Smoke::mf_static, 614, 43},	//3043 KToolInvocation::startServiceByName(const QString&, const QString&, QString*, QString*, int*, const QByteArray&)
    {124, 3008, 30, 1, Smoke::mf_static, 614, 44},	//3044 KToolInvocation::startServiceByName(const QString&)
    {124, 3008, 533, 2, Smoke::mf_static, 614, 45},	//3045 KToolInvocation::startServiceByName(const QString&, const QStringList&)
    {124, 3008, 2187, 3, Smoke::mf_static, 614, 46},	//3046 KToolInvocation::startServiceByName(const QString&, const QStringList&, QString*)
    {124, 3008, 2191, 4, Smoke::mf_static, 614, 47},	//3047 KToolInvocation::startServiceByName(const QString&, const QStringList&, QString*, QString*)
    {124, 3008, 2196, 5, Smoke::mf_static, 614, 48},	//3048 KToolInvocation::startServiceByName(const QString&, const QStringList&, QString*, QString*, int*)
    {124, 3008, 2202, 6, Smoke::mf_static, 614, 49},	//3049 KToolInvocation::startServiceByName(const QString&, const QStringList&, QString*, QString*, int*, const QByteArray&)
    {124, 2994, 95, 2, Smoke::mf_static, 614, 50},	//3050 KToolInvocation::startServiceByDesktopPath(const QString&, const QString&)
    {124, 2994, 2165, 3, Smoke::mf_static, 614, 51},	//3051 KToolInvocation::startServiceByDesktopPath(const QString&, const QString&, QString*)
    {124, 2994, 2169, 4, Smoke::mf_static, 614, 52},	//3052 KToolInvocation::startServiceByDesktopPath(const QString&, const QString&, QString*, QString*)
    {124, 2994, 2174, 5, Smoke::mf_static, 614, 53},	//3053 KToolInvocation::startServiceByDesktopPath(const QString&, const QString&, QString*, QString*, int*)
    {124, 2994, 2180, 6, Smoke::mf_static, 614, 54},	//3054 KToolInvocation::startServiceByDesktopPath(const QString&, const QString&, QString*, QString*, int*, const QByteArray&)
    {124, 2994, 30, 1, Smoke::mf_static, 614, 55},	//3055 KToolInvocation::startServiceByDesktopPath(const QString&)
    {124, 2994, 533, 2, Smoke::mf_static, 614, 56},	//3056 KToolInvocation::startServiceByDesktopPath(const QString&, const QStringList&)
    {124, 2994, 2187, 3, Smoke::mf_static, 614, 57},	//3057 KToolInvocation::startServiceByDesktopPath(const QString&, const QStringList&, QString*)
    {124, 2994, 2191, 4, Smoke::mf_static, 614, 58},	//3058 KToolInvocation::startServiceByDesktopPath(const QString&, const QStringList&, QString*, QString*)
    {124, 2994, 2196, 5, Smoke::mf_static, 614, 59},	//3059 KToolInvocation::startServiceByDesktopPath(const QString&, const QStringList&, QString*, QString*, int*)
    {124, 2994, 2202, 6, Smoke::mf_static, 614, 60},	//3060 KToolInvocation::startServiceByDesktopPath(const QString&, const QStringList&, QString*, QString*, int*, const QByteArray&)
    {124, 2980, 95, 2, Smoke::mf_static, 614, 61},	//3061 KToolInvocation::startServiceByDesktopName(const QString&, const QString&)
    {124, 2980, 2165, 3, Smoke::mf_static, 614, 62},	//3062 KToolInvocation::startServiceByDesktopName(const QString&, const QString&, QString*)
    {124, 2980, 2169, 4, Smoke::mf_static, 614, 63},	//3063 KToolInvocation::startServiceByDesktopName(const QString&, const QString&, QString*, QString*)
    {124, 2980, 2174, 5, Smoke::mf_static, 614, 64},	//3064 KToolInvocation::startServiceByDesktopName(const QString&, const QString&, QString*, QString*, int*)
    {124, 2980, 2180, 6, Smoke::mf_static, 614, 65},	//3065 KToolInvocation::startServiceByDesktopName(const QString&, const QString&, QString*, QString*, int*, const QByteArray&)
    {124, 2980, 30, 1, Smoke::mf_static, 614, 66},	//3066 KToolInvocation::startServiceByDesktopName(const QString&)
    {124, 2980, 533, 2, Smoke::mf_static, 614, 67},	//3067 KToolInvocation::startServiceByDesktopName(const QString&, const QStringList&)
    {124, 2980, 2187, 3, Smoke::mf_static, 614, 68},	//3068 KToolInvocation::startServiceByDesktopName(const QString&, const QStringList&, QString*)
    {124, 2980, 2191, 4, Smoke::mf_static, 614, 69},	//3069 KToolInvocation::startServiceByDesktopName(const QString&, const QStringList&, QString*, QString*)
    {124, 2980, 2196, 5, Smoke::mf_static, 614, 70},	//3070 KToolInvocation::startServiceByDesktopName(const QString&, const QStringList&, QString*, QString*, int*)
    {124, 2980, 2202, 6, Smoke::mf_static, 614, 71},	//3071 KToolInvocation::startServiceByDesktopName(const QString&, const QStringList&, QString*, QString*, int*, const QByteArray&)
    {124, 1908, 30, 1, Smoke::mf_static, 614, 72},	//3072 KToolInvocation::kdeinitExec(const QString&)
    {124, 1908, 533, 2, Smoke::mf_static, 614, 73},	//3073 KToolInvocation::kdeinitExec(const QString&, const QStringList&)
    {124, 1908, 2187, 3, Smoke::mf_static, 614, 74},	//3074 KToolInvocation::kdeinitExec(const QString&, const QStringList&, QString*)
    {124, 1908, 2209, 4, Smoke::mf_static, 614, 75},	//3075 KToolInvocation::kdeinitExec(const QString&, const QStringList&, QString*, int*)
    {124, 1914, 30, 1, Smoke::mf_static, 614, 76},	//3076 KToolInvocation::kdeinitExecWait(const QString&)
    {124, 1914, 533, 2, Smoke::mf_static, 614, 77},	//3077 KToolInvocation::kdeinitExecWait(const QString&, const QStringList&)
    {124, 1914, 2187, 3, Smoke::mf_static, 614, 78},	//3078 KToolInvocation::kdeinitExecWait(const QString&, const QStringList&, QString*)
    {124, 1914, 2209, 4, Smoke::mf_static, 614, 79},	//3079 KToolInvocation::kdeinitExecWait(const QString&, const QStringList&, QString*, int*)
    {124, 3030, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 581, 80},	//3080 KToolInvocation::staticMetaObject() const
    {124, 3423, 0, 0, Smoke::mf_dtor, 0, 81 },	//3081 KToolInvocation::~KToolInvocation()
    {125, 530, 2214, 6, Smoke::mf_ctor, 236, 1},	//3082 KTzfileTimeZone::KTzfileTimeZone(KTzfileTimeZoneSource*, const QString&, const QString&, float, float, const QString&)
    {125, 530, 2221, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 236, 2},	//3083 KTzfileTimeZone::KTzfileTimeZone(const KTzfileTimeZone&)
    {125, 530, 2223, 2, Smoke::mf_ctor, 236, 3},	//3084 KTzfileTimeZone::KTzfileTimeZone(KTzfileTimeZoneSource*, const QString&)
    {125, 530, 2226, 3, Smoke::mf_ctor, 236, 4},	//3085 KTzfileTimeZone::KTzfileTimeZone(KTzfileTimeZoneSource*, const QString&, const QString&)
    {125, 530, 2230, 4, Smoke::mf_ctor, 236, 5},	//3086 KTzfileTimeZone::KTzfileTimeZone(KTzfileTimeZoneSource*, const QString&, const QString&, float)
    {125, 530, 2235, 5, Smoke::mf_ctor, 236, 6},	//3087 KTzfileTimeZone::KTzfileTimeZone(KTzfileTimeZoneSource*, const QString&, const QString&, float, float)
    {125, 3424, 0, 0, Smoke::mf_dtor, 0, 7 },	//3088 KTzfileTimeZone::~KTzfileTimeZone()
    {126, 537, 2214, 6, Smoke::mf_ctor, 237, 1},	//3089 KTzfileTimeZoneBackend::KTzfileTimeZoneBackend(KTzfileTimeZoneSource*, const QString&, const QString&, float, float, const QString&)
    {126, 1148, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 230, 2},	//3090 KTzfileTimeZoneBackend::clone() const
    {126, 3174, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 264, 3},	//3091 KTzfileTimeZoneBackend::type() const
    {126, 1700, 2058, 1, Smoke::mf_const|Smoke::mf_virtual, 450, 4},	//3092 KTzfileTimeZoneBackend::hasTransitions(const KTimeZone*) const
    {126, 537, 2241, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 237, 5},	//3093 KTzfileTimeZoneBackend::KTzfileTimeZoneBackend(const KTzfileTimeZoneBackend&)
    {126, 3425, 0, 0, Smoke::mf_dtor, 0, 6 },	//3094 KTzfileTimeZoneBackend::~KTzfileTimeZoneBackend()
    {127, 540, 30, 1, Smoke::mf_ctor, 238, 1},	//3095 KTzfileTimeZoneSource::KTzfileTimeZoneSource(const QString&)
    {127, 2002, 0, 0, Smoke::mf_const, 351, 2},	//3096 KTzfileTimeZoneSource::location() const
    {127, 2219, 1041, 1, Smoke::mf_const|Smoke::mf_virtual, 232, 3},	//3097 KTzfileTimeZoneSource::parse(const KTimeZone&) const
    {127, 540, 2243, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 238, 4},	//3098 KTzfileTimeZoneSource::KTzfileTimeZoneSource(const KTzfileTimeZoneSource&)
    {127, 3426, 0, 0, Smoke::mf_dtor, 0, 5 },	//3099 KTzfileTimeZoneSource::~KTzfileTimeZoneSource()
    {128, 543, 0, 0, Smoke::mf_ctor, 241, 1},	//3100 KUrl::KUrl()
    {128, 543, 30, 1, Smoke::mf_ctor, 241, 2},	//3101 KUrl::KUrl(const QString&)
    {128, 543, 122, 1, Smoke::mf_ctor, 241, 3},	//3102 KUrl::KUrl(const char*)
    {128, 543, 32, 1, Smoke::mf_ctor, 241, 4},	//3103 KUrl::KUrl(const QByteArray&)
    {128, 543, 148, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 241, 5},	//3104 KUrl::KUrl(const KUrl&)
    {128, 543, 1792, 1, Smoke::mf_ctor, 241, 6},	//3105 KUrl::KUrl(const QUrl&)
    {128, 543, 152, 2, Smoke::mf_ctor, 241, 7},	//3106 KUrl::KUrl(const KUrl&, const QString&)
    {128, 2285, 0, 0, Smoke::mf_const, 351, 8},	//3107 KUrl::protocol() const
    {128, 2845, 30, 1, 0, 0, 9},	//3108 KUrl::setProtocol(const QString&)
    {128, 3210, 0, 0, Smoke::mf_const, 351, 10},	//3109 KUrl::user() const
    {128, 2910, 30, 1, 0, 0, 11},	//3110 KUrl::setUser(const QString&)
    {128, 1702, 0, 0, Smoke::mf_const, 450, 12},	//3111 KUrl::hasUser() const
    {128, 2223, 0, 0, Smoke::mf_const, 351, 13},	//3112 KUrl::pass() const
    {128, 2808, 30, 1, 0, 0, 14},	//3113 KUrl::setPass(const QString&)
    {128, 1690, 0, 0, Smoke::mf_const, 450, 15},	//3114 KUrl::hasPass() const
    {128, 1675, 0, 0, Smoke::mf_const, 450, 16},	//3115 KUrl::hasHost() const
    {128, 2224, 2245, 1, Smoke::mf_const, 351, 17},	//3116 KUrl::path(KUrl::AdjustPathOption) const
    {128, 3106, 2245, 1, Smoke::mf_const, 351, 18},	//3117 KUrl::toLocalFile(KUrl::AdjustPathOption) const
    {128, 2810, 30, 1, 0, 0, 19},	//3118 KUrl::setPath(const QString&)
    {128, 1691, 0, 0, Smoke::mf_const, 450, 20},	//3119 KUrl::hasPath() const
    {128, 1142, 2247, 1, 0, 0, 21},	//3120 KUrl::cleanPath(const KUrl::CleanPathOption&)
    {128, 1001, 2245, 1, 0, 0, 22},	//3121 KUrl::adjustPath(KUrl::AdjustPathOption)
    {128, 2613, 30, 1, 0, 0, 23},	//3122 KUrl::setEncodedPathAndQuery(const QString&)
    {128, 1403, 2249, 2, Smoke::mf_const, 351, 24},	//3123 KUrl::encodedPathAndQuery(KUrl::AdjustPathOption, const QFlags<KUrl::EncodedPathAndQueryOption>&) const
    {128, 2847, 30, 1, 0, 0, 25},	//3124 KUrl::setQuery(const QString&)
    {128, 2303, 0, 0, Smoke::mf_const, 351, 26},	//3125 KUrl::query() const
    {128, 2396, 0, 0, Smoke::mf_const, 351, 27},	//3126 KUrl::ref() const
    {128, 2851, 30, 1, 0, 0, 28},	//3127 KUrl::setRef(const QString&)
    {128, 1693, 0, 0, Smoke::mf_const, 450, 29},	//3128 KUrl::hasRef() const
    {128, 1708, 0, 0, Smoke::mf_const, 351, 30},	//3129 KUrl::htmlRef() const
    {128, 1402, 0, 0, Smoke::mf_const, 351, 31},	//3130 KUrl::encodedHtmlRef() const
    {128, 2652, 30, 1, 0, 0, 32},	//3131 KUrl::setHTMLRef(const QString&)
    {128, 1673, 0, 0, Smoke::mf_const, 450, 33},	//3132 KUrl::hasHTMLRef() const
    {128, 1834, 0, 0, Smoke::mf_const, 450, 34},	//3133 KUrl::isLocalFile() const
    {128, 2637, 30, 1, 0, 0, 35},	//3134 KUrl::setFileEncoding(const QString&)
    {128, 1495, 0, 0, Smoke::mf_const, 351, 36},	//3135 KUrl::fileEncoding() const
    {128, 1696, 0, 0, Smoke::mf_const, 450, 37},	//3136 KUrl::hasSubUrl() const
    {128, 964, 30, 1, 0, 0, 38},	//3137 KUrl::addPath(const QString&)
    {128, 2309, 2252, 1, Smoke::mf_const, 339, 39},	//3138 KUrl::queryItems(const QFlags<KUrl::QueryItemsOption>&) const
    {128, 2307, 30, 1, Smoke::mf_const, 351, 40},	//3139 KUrl::queryItem(const QString&) const
    {128, 968, 95, 2, 0, 0, 41},	//3140 KUrl::addQueryItem(const QString&, const QString&)
    {128, 2639, 30, 1, 0, 0, 42},	//3141 KUrl::setFileName(const QString&)
    {128, 1498, 2254, 1, Smoke::mf_const, 351, 43},	//3142 KUrl::fileName(const QFlags<KUrl::DirectoryOption>&) const
    {128, 1374, 2254, 1, Smoke::mf_const, 351, 44},	//3143 KUrl::directory(const QFlags<KUrl::DirectoryOption>&) const
    {128, 2611, 30, 1, 0, 0, 45},	//3144 KUrl::setDirectory(const QString&)
    {128, 1115, 30, 1, 0, 450, 46},	//3145 KUrl::cd(const QString&)
    {128, 3199, 2245, 1, Smoke::mf_const, 351, 47},	//3146 KUrl::url(KUrl::AdjustPathOption) const
    {128, 2258, 2245, 1, Smoke::mf_const, 351, 48},	//3147 KUrl::prettyUrl(KUrl::AdjustPathOption) const
    {128, 2226, 0, 0, Smoke::mf_const, 351, 49},	//3148 KUrl::pathOrUrl() const
    {128, 2226, 2245, 1, Smoke::mf_const, 351, 50},	//3149 KUrl::pathOrUrl(KUrl::AdjustPathOption) const
    {128, 3109, 0, 0, Smoke::mf_const, 351, 51},	//3150 KUrl::toMimeDataString() const
    {128, 3191, 0, 0, Smoke::mf_const, 239, 52},	//3151 KUrl::upUrl() const
    {128, 2182, 148, 1, 0, 240, 53},	//3152 KUrl::operator=(const KUrl&)
    {128, 2182, 122, 1, 0, 240, 54},	//3153 KUrl::operator=(const char*)
    {128, 2182, 32, 1, 0, 240, 55},	//3154 KUrl::operator=(const QByteArray&)
    {128, 2182, 30, 1, 0, 240, 56},	//3155 KUrl::operator=(const QString&)
    {128, 2185, 148, 1, Smoke::mf_const, 450, 57},	//3156 KUrl::operator==(const KUrl&) const
    {128, 2185, 30, 1, Smoke::mf_const, 450, 58},	//3157 KUrl::operator==(const QString&) const
    {128, 2158, 148, 1, Smoke::mf_const, 450, 59},	//3158 KUrl::operator!=(const KUrl&) const
    {128, 2158, 30, 1, Smoke::mf_const, 450, 60},	//3159 KUrl::operator!=(const QString&) const
    {128, 2157, 0, 0, Smoke::mf_const, 364, 61},	//3160 KUrl::operator QVariant() const
    {128, 1150, 2256, 2, Smoke::mf_const, 450, 62},	//3161 KUrl::cmp(const KUrl&, bool) const
    {128, 1423, 2259, 2, Smoke::mf_const, 450, 63},	//3162 KUrl::equals(const KUrl&, const QFlags<KUrl::EqualsOption>&) const
    {128, 1843, 148, 1, Smoke::mf_const, 450, 64},	//3163 KUrl::isParentOf(const KUrl&) const
    {128, 2959, 30, 1, Smoke::mf_static, 247, 65},	//3164 KUrl::split(const QString&)
    {128, 2959, 148, 1, Smoke::mf_static, 247, 66},	//3165 KUrl::split(const KUrl&)
    {128, 1884, 2262, 1, Smoke::mf_static, 239, 67},	//3166 KUrl::join(const KUrl::List&)
    {128, 1619, 30, 1, Smoke::mf_static, 239, 68},	//3167 KUrl::fromPath(const QString&)
    {128, 1621, 30, 1, Smoke::mf_static, 239, 69},	//3168 KUrl::fromPathOrUrl(const QString&)
    {128, 1617, 32, 1, Smoke::mf_static, 239, 70},	//3169 KUrl::fromMimeDataByteArray(const QByteArray&)
    {128, 2243, 2264, 3, Smoke::mf_const, 0, 71},	//3170 KUrl::populateMimeData(QMimeData*, const QMap<QString,QString>&, KUrl::MimeDataFlags) const
    {128, 1398, 30, 1, Smoke::mf_static, 351, 72},	//3171 KUrl::encode_string(const QString&)
    {128, 1400, 30, 1, Smoke::mf_static, 351, 73},	//3172 KUrl::encode_string_no_slash(const QString&)
    {128, 1315, 30, 1, Smoke::mf_static, 351, 74},	//3173 KUrl::decode_string(const QString&)
    {128, 1848, 30, 1, Smoke::mf_static, 450, 75},	//3174 KUrl::isRelativeUrl(const QString&)
    {128, 2408, 2268, 2, Smoke::mf_static, 351, 76},	//3175 KUrl::relativeUrl(const KUrl&, const KUrl&)
    {128, 2405, 287, 3, Smoke::mf_static, 351, 77},	//3176 KUrl::relativePath(const QString&, const QString&, bool*)
    {128, 2224, 0, 0, Smoke::mf_const, 351, 78},	//3177 KUrl::path() const
    {128, 3106, 0, 0, Smoke::mf_const, 351, 79},	//3178 KUrl::toLocalFile() const
    {128, 1142, 0, 0, 0, 0, 80},	//3179 KUrl::cleanPath()
    {128, 1403, 0, 0, Smoke::mf_const, 351, 81},	//3180 KUrl::encodedPathAndQuery() const
    {128, 1403, 2245, 1, Smoke::mf_const, 351, 82},	//3181 KUrl::encodedPathAndQuery(KUrl::AdjustPathOption) const
    {128, 2309, 0, 0, Smoke::mf_const, 339, 83},	//3182 KUrl::queryItems() const
    {128, 1498, 0, 0, Smoke::mf_const, 351, 84},	//3183 KUrl::fileName() const
    {128, 1374, 0, 0, Smoke::mf_const, 351, 85},	//3184 KUrl::directory() const
    {128, 3199, 0, 0, Smoke::mf_const, 351, 86},	//3185 KUrl::url() const
    {128, 2258, 0, 0, Smoke::mf_const, 351, 87},	//3186 KUrl::prettyUrl() const
    {128, 1150, 148, 1, Smoke::mf_const, 450, 88},	//3187 KUrl::cmp(const KUrl&) const
    {128, 1423, 148, 1, Smoke::mf_const, 450, 89},	//3188 KUrl::equals(const KUrl&) const
    {128, 2243, 2271, 1, Smoke::mf_const, 0, 90},	//3189 KUrl::populateMimeData(QMimeData*) const
    {128, 2243, 2273, 2, Smoke::mf_const, 0, 91},	//3190 KUrl::populateMimeData(QMimeData*, const QMap<QString,QString>&) const
    {128, 2405, 95, 2, Smoke::mf_static, 351, 92},	//3191 KUrl::relativePath(const QString&, const QString&)
    {128, 99, 0, 0, Smoke::mf_static|Smoke::mf_enum, 249, 93},	//3192 KUrl::DefaultMimeDataFlags (enum)
    {128, 632, 0, 0, Smoke::mf_static|Smoke::mf_enum, 249, 94},	//3193 KUrl::NoTextExport (enum)
    {128, 696, 0, 0, Smoke::mf_static|Smoke::mf_enum, 242, 95},	//3194 KUrl::RemoveTrailingSlash (enum)
    {128, 570, 0, 0, Smoke::mf_static|Smoke::mf_enum, 242, 96},	//3195 KUrl::LeaveTrailingSlash (enum)
    {128, 12, 0, 0, Smoke::mf_static|Smoke::mf_enum, 242, 97},	//3196 KUrl::AddTrailingSlash (enum)
    {128, 716, 0, 0, Smoke::mf_static|Smoke::mf_enum, 243, 98},	//3197 KUrl::SimplifyDirSeparators (enum)
    {128, 560, 0, 0, Smoke::mf_static|Smoke::mf_enum, 243, 99},	//3198 KUrl::KeepDirSeparators (enum)
    {128, 659, 0, 0, Smoke::mf_static|Smoke::mf_enum, 245, 100},	//3199 KUrl::PermitEmptyPath (enum)
    {128, 33, 0, 0, Smoke::mf_static|Smoke::mf_enum, 245, 101},	//3200 KUrl::AvoidEmptyPath (enum)
    {128, 48, 0, 0, Smoke::mf_static|Smoke::mf_enum, 250, 102},	//3201 KUrl::CaseInsensitiveKeys (enum)
    {128, 641, 0, 0, Smoke::mf_static|Smoke::mf_enum, 244, 103},	//3202 KUrl::ObeyTrailingSlash (enum)
    {128, 20, 0, 0, Smoke::mf_static|Smoke::mf_enum, 244, 104},	//3203 KUrl::AppendTrailingSlash (enum)
    {128, 171, 0, 0, Smoke::mf_static|Smoke::mf_enum, 244, 105},	//3204 KUrl::IgnoreTrailingSlash (enum)
    {128, 67, 0, 0, Smoke::mf_static|Smoke::mf_enum, 246, 106},	//3205 KUrl::CompareWithoutTrailingSlash (enum)
    {128, 66, 0, 0, Smoke::mf_static|Smoke::mf_enum, 246, 107},	//3206 KUrl::CompareWithoutFragment (enum)
    {128, 17, 0, 0, Smoke::mf_static|Smoke::mf_enum, 246, 108},	//3207 KUrl::AllowEmptyPath (enum)
    {128, 3427, 0, 0, Smoke::mf_dtor, 0, 109 },	//3208 KUrl::~KUrl()
    {129, 547, 2276, 1, Smoke::mf_ctor, 253, 1},	//3209 KUser::KUser(KUser::UIDMode)
    {129, 547, 2278, 1, Smoke::mf_ctor, 253, 2},	//3210 KUser::KUser(uid_t)
    {129, 547, 30, 1, Smoke::mf_ctor, 253, 3},	//3211 KUser::KUser(const QString&)
    {129, 547, 122, 1, Smoke::mf_ctor, 253, 4},	//3212 KUser::KUser(const char*)
    {129, 547, 2280, 1, Smoke::mf_ctor, 253, 5},	//3213 KUser::KUser(const passwd*)
    {129, 547, 2282, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 253, 6},	//3214 KUser::KUser(const KUser&)
    {129, 2182, 2282, 1, 0, 252, 7},	//3215 KUser::operator=(const KUser&)
    {129, 2185, 2282, 1, Smoke::mf_const, 450, 8},	//3216 KUser::operator==(const KUser&) const
    {129, 2158, 2282, 1, Smoke::mf_const, 450, 9},	//3217 KUser::operator!=(const KUser&) const
    {129, 1871, 0, 0, Smoke::mf_const, 450, 10},	//3218 KUser::isValid() const
    {129, 3176, 0, 0, Smoke::mf_const, 629, 11},	//3219 KUser::uid() const
    {129, 1649, 0, 0, Smoke::mf_const, 613, 12},	//3220 KUser::gid() const
    {129, 1862, 0, 0, Smoke::mf_const, 450, 13},	//3221 KUser::isSuperUser() const
    {129, 2005, 0, 0, Smoke::mf_const, 351, 14},	//3222 KUser::loginName() const
    {129, 1635, 0, 0, Smoke::mf_const, 351, 15},	//3223 KUser::fullName() const
    {129, 1706, 0, 0, Smoke::mf_const, 351, 16},	//3224 KUser::homeDir() const
    {129, 1483, 0, 0, Smoke::mf_const, 351, 17},	//3225 KUser::faceIconPath() const
    {129, 2933, 0, 0, Smoke::mf_const, 351, 18},	//3226 KUser::shell() const
    {129, 1659, 0, 0, Smoke::mf_const, 332, 19},	//3227 KUser::groups() const
    {129, 1658, 0, 0, Smoke::mf_const, 354, 20},	//3228 KUser::groupNames() const
    {129, 2277, 2284, 1, Smoke::mf_const, 364, 21},	//3229 KUser::property(KUser::UserProperty) const
    {129, 1020, 0, 0, Smoke::mf_static, 331, 22},	//3230 KUser::allUsers()
    {129, 1019, 0, 0, Smoke::mf_static, 354, 23},	//3231 KUser::allUserNames()
    {129, 547, 0, 0, Smoke::mf_ctor, 253, 24},	//3232 KUser::KUser()
    {129, 799, 0, 0, Smoke::mf_static|Smoke::mf_enum, 254, 25},	//3233 KUser::UseEffectiveUID (enum)
    {129, 800, 0, 0, Smoke::mf_static|Smoke::mf_enum, 254, 26},	//3234 KUser::UseRealUserID (enum)
    {129, 149, 0, 0, Smoke::mf_static|Smoke::mf_enum, 255, 27},	//3235 KUser::FullName (enum)
    {129, 702, 0, 0, Smoke::mf_static|Smoke::mf_enum, 255, 28},	//3236 KUser::RoomNumber (enum)
    {129, 813, 0, 0, Smoke::mf_static|Smoke::mf_enum, 255, 29},	//3237 KUser::WorkPhone (enum)
    {129, 162, 0, 0, Smoke::mf_static|Smoke::mf_enum, 255, 30},	//3238 KUser::HomePhone (enum)
    {129, 3428, 0, 0, Smoke::mf_dtor, 0, 31 },	//3239 KUser::~KUser()
    {130, 551, 30, 1, Smoke::mf_ctor, 258, 1},	//3240 KUserGroup::KUserGroup(const QString&)
    {130, 551, 122, 1, Smoke::mf_ctor, 258, 2},	//3241 KUserGroup::KUserGroup(const char*)
    {130, 551, 2276, 1, Smoke::mf_ctor, 258, 3},	//3242 KUserGroup::KUserGroup(KUser::UIDMode)
    {130, 551, 2286, 1, Smoke::mf_ctor, 258, 4},	//3243 KUserGroup::KUserGroup(gid_t)
    {130, 551, 2288, 1, Smoke::mf_ctor, 258, 5},	//3244 KUserGroup::KUserGroup(const group*)
    {130, 551, 2290, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 258, 6},	//3245 KUserGroup::KUserGroup(const KUserGroup&)
    {130, 2182, 2290, 1, 0, 257, 7},	//3246 KUserGroup::operator=(const KUserGroup&)
    {130, 2185, 2290, 1, Smoke::mf_const, 450, 8},	//3247 KUserGroup::operator==(const KUserGroup&) const
    {130, 2158, 2290, 1, Smoke::mf_const, 450, 9},	//3248 KUserGroup::operator!=(const KUserGroup&) const
    {130, 1871, 0, 0, Smoke::mf_const, 450, 10},	//3249 KUserGroup::isValid() const
    {130, 1649, 0, 0, Smoke::mf_const, 613, 11},	//3250 KUserGroup::gid() const
    {130, 2102, 0, 0, Smoke::mf_const, 351, 12},	//3251 KUserGroup::name() const
    {130, 3214, 0, 0, Smoke::mf_const, 331, 13},	//3252 KUserGroup::users() const
    {130, 3211, 0, 0, Smoke::mf_const, 354, 14},	//3253 KUserGroup::userNames() const
    {130, 1009, 0, 0, Smoke::mf_static, 332, 15},	//3254 KUserGroup::allGroups()
    {130, 1008, 0, 0, Smoke::mf_static, 354, 16},	//3255 KUserGroup::allGroupNames()
    {130, 551, 0, 0, Smoke::mf_ctor, 258, 17},	//3256 KUserGroup::KUserGroup()
    {130, 3429, 0, 0, Smoke::mf_dtor, 0, 18 },	//3257 KUserGroup::~KUserGroup()
    {131, 555, 340, 1, Smoke::mf_ctor|Smoke::mf_explicit, 259, 1},	//3258 KWordMacroExpander::KWordMacroExpander(QChar)
    {131, 1477, 342, 3, Smoke::mf_protected|Smoke::mf_virtual, 614, 2},	//3259 KWordMacroExpander::expandPlainMacro(const QString&, int, QStringList&)
    {131, 1463, 342, 3, Smoke::mf_protected|Smoke::mf_virtual, 614, 3},	//3260 KWordMacroExpander::expandEscapedMacro(const QString&, int, QStringList&)
    {131, 1465, 757, 2, Smoke::mf_protected|Smoke::mf_virtual|Smoke::mf_purevirtual, 450, 4},	//3261 KWordMacroExpander::expandMacro(const QString&, QStringList&) [pure virtual]
    {131, 555, 2292, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 259, 5},	//3262 KWordMacroExpander::KWordMacroExpander(const KWordMacroExpander&)
    {131, 555, 0, 0, Smoke::mf_ctor|Smoke::mf_explicit, 259, 6},	//3263 KWordMacroExpander::KWordMacroExpander()
    {131, 3430, 0, 0, Smoke::mf_dtor, 0, 7 },	//3264 KWordMacroExpander::~KWordMacroExpander()
    {132, 2060, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 582, 1},	//3265 OrgKdeKLauncherInterface::metaObject() const
    {132, 2301, 122, 1, Smoke::mf_virtual, 639, 2},	//3266 OrgKdeKLauncherInterface::qt_metacast(const char*)
    {132, 3131, 124, 2, Smoke::mf_static, 351, 3},	//3267 OrgKdeKLauncherInterface::tr(const char*, const char*)
    {132, 3138, 124, 2, Smoke::mf_static, 351, 4},	//3268 OrgKdeKLauncherInterface::trUtf8(const char*, const char*)
    {132, 3131, 127, 3, Smoke::mf_static, 351, 5},	//3269 OrgKdeKLauncherInterface::tr(const char*, const char*, int)
    {132, 3138, 127, 3, Smoke::mf_static, 351, 6},	//3270 OrgKdeKLauncherInterface::trUtf8(const char*, const char*, int)
    {132, 2299, 131, 3, Smoke::mf_virtual, 614, 7},	//3271 OrgKdeKLauncherInterface::qt_metacall(QMetaObject::Call, int, void**)
    {132, 3029, 0, 0, Smoke::mf_static, 598, 8},	//3272 OrgKdeKLauncherInterface::staticInterfaceName()
    {132, 649, 2294, 4, Smoke::mf_ctor, 260, 9},	//3273 OrgKdeKLauncherInterface::OrgKdeKLauncherInterface(const QString&, const QString&, const QDBusConnection&, QObject*)
    {132, 1053, 0, 0, Smoke::mf_slot, 272, 10},	//3274 OrgKdeKLauncherInterface::autoStart()
    {132, 1053, 118, 1, Smoke::mf_slot, 272, 11},	//3275 OrgKdeKLauncherInterface::autoStart(int)
    {132, 1448, 2299, 4, Smoke::mf_slot, 272, 12},	//3276 OrgKdeKLauncherInterface::exec_blind(const QString&, const QStringList&, const QStringList&, const QString&)
    {132, 1448, 533, 2, Smoke::mf_slot, 272, 13},	//3277 OrgKdeKLauncherInterface::exec_blind(const QString&, const QStringList&)
    {132, 1920, 2304, 7, Smoke::mf_slot, 271, 14},	//3278 OrgKdeKLauncherInterface::kdeinit_exec(const QString&, const QStringList&, const QStringList&, const QString&, QString&, QString&, int&)
    {132, 1922, 2304, 7, Smoke::mf_slot, 271, 15},	//3279 OrgKdeKLauncherInterface::kdeinit_exec_wait(const QString&, const QStringList&, const QStringList&, const QString&, QString&, QString&, int&)
    {132, 2431, 0, 0, Smoke::mf_slot, 272, 16},	//3280 OrgKdeKLauncherInterface::reparseConfiguration()
    {132, 2434, 95, 2, Smoke::mf_slot, 271, 17},	//3281 OrgKdeKLauncherInterface::requestHoldSlave(const QString&, const QString&)
    {132, 2436, 2312, 4, Smoke::mf_slot, 271, 18},	//3282 OrgKdeKLauncherInterface::requestSlave(const QString&, const QString&, const QString&, QString&)
    {132, 2678, 95, 2, Smoke::mf_slot, 272, 19},	//3283 OrgKdeKLauncherInterface::setLaunchEnv(const QString&, const QString&)
    {132, 3022, 2317, 8, Smoke::mf_slot, 271, 20},	//3284 OrgKdeKLauncherInterface::start_service_by_desktop_name(const QString&, const QStringList&, const QStringList&, const QString&, bool, QString&, QString&, int&)
    {132, 3024, 2317, 8, Smoke::mf_slot, 271, 21},	//3285 OrgKdeKLauncherInterface::start_service_by_desktop_path(const QString&, const QStringList&, const QStringList&, const QString&, bool, QString&, QString&, int&)
    {132, 3026, 2317, 8, Smoke::mf_slot, 271, 22},	//3286 OrgKdeKLauncherInterface::start_service_by_name(const QString&, const QStringList&, const QStringList&, const QString&, bool, QString&, QString&, int&)
    {132, 3246, 118, 1, Smoke::mf_slot, 272, 23},	//3287 OrgKdeKLauncherInterface::waitForSlave(int)
    {132, 1128, 30, 1, Smoke::mf_slot, 270, 24},	//3288 OrgKdeKLauncherInterface::checkForHeldSlave(const QString&)
    {132, 1055, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 25},	//3289 OrgKdeKLauncherInterface::autoStart0Done()
    {132, 1056, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 26},	//3290 OrgKdeKLauncherInterface::autoStart1Done()
    {132, 1057, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 27},	//3291 OrgKdeKLauncherInterface::autoStart2Done()
    {132, 3131, 122, 1, Smoke::mf_static, 351, 28},	//3292 OrgKdeKLauncherInterface::tr(const char*)
    {132, 3138, 122, 1, Smoke::mf_static, 351, 29},	//3293 OrgKdeKLauncherInterface::trUtf8(const char*)
    {132, 649, 2326, 3, Smoke::mf_ctor, 260, 30},	//3294 OrgKdeKLauncherInterface::OrgKdeKLauncherInterface(const QString&, const QString&, const QDBusConnection&)
    {132, 3030, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 581, 31},	//3295 OrgKdeKLauncherInterface::staticMetaObject() const
    {132, 3432, 0, 0, Smoke::mf_dtor, 0, 32 },	//3296 OrgKdeKLauncherInterface::~OrgKdeKLauncherInterface()
    {134, 1085, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 619, 0},	//3297 QAbstractSocket::bytesAvailable() const
    {134, 1086, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 619, 0},	//3298 QAbstractSocket::bytesToWrite() const
    {134, 1103, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 450, 0},	//3299 QAbstractSocket::canReadLine() const
    {134, 1149, 0, 0, Smoke::mf_virtual, 0, 0},	//3300 QAbstractSocket::close()
    {134, 1855, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 450, 0},	//3301 QAbstractSocket::isSequential() const
    {134, 1038, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 450, 0},	//3302 QAbstractSocket::atEnd() const
    {134, 3245, 118, 1, Smoke::mf_virtual, 450, 0},	//3303 QAbstractSocket::waitForReadyRead(int)
    {134, 3241, 118, 1, Smoke::mf_virtual, 450, 0},	//3304 QAbstractSocket::waitForBytesWritten(int)
    {134, 2336, 1144, 2, Smoke::mf_protected|Smoke::mf_virtual, 619, 0},	//3305 QAbstractSocket::readData(char*, long long)
    {134, 2362, 1144, 2, Smoke::mf_protected|Smoke::mf_virtual, 619, 0},	//3306 QAbstractSocket::readLineData(char*, long long)
    {134, 3290, 1147, 2, Smoke::mf_protected|Smoke::mf_virtual, 619, 0},	//3307 QAbstractSocket::writeData(const char*, long long)
    {134, 70, 0, 0, Smoke::mf_static|Smoke::mf_enum, 262, 12},	//3308 QAbstractSocket::ConnectionRefusedError (enum)
    {134, 694, 0, 0, Smoke::mf_static|Smoke::mf_enum, 262, 13},	//3309 QAbstractSocket::RemoteHostClosedError (enum)
    {134, 164, 0, 0, Smoke::mf_static|Smoke::mf_enum, 262, 14},	//3310 QAbstractSocket::HostNotFoundError (enum)
    {134, 719, 0, 0, Smoke::mf_static|Smoke::mf_enum, 262, 15},	//3311 QAbstractSocket::SocketAccessError (enum)
    {134, 721, 0, 0, Smoke::mf_static|Smoke::mf_enum, 262, 16},	//3312 QAbstractSocket::SocketResourceError (enum)
    {134, 722, 0, 0, Smoke::mf_static|Smoke::mf_enum, 262, 17},	//3313 QAbstractSocket::SocketTimeoutError (enum)
    {134, 82, 0, 0, Smoke::mf_static|Smoke::mf_enum, 262, 18},	//3314 QAbstractSocket::DatagramTooLargeError (enum)
    {134, 616, 0, 0, Smoke::mf_static|Smoke::mf_enum, 262, 19},	//3315 QAbstractSocket::NetworkError (enum)
    {134, 13, 0, 0, Smoke::mf_static|Smoke::mf_enum, 262, 20},	//3316 QAbstractSocket::AddressInUseError (enum)
    {134, 720, 0, 0, Smoke::mf_static|Smoke::mf_enum, 262, 21},	//3317 QAbstractSocket::SocketAddressNotAvailableError (enum)
    {134, 798, 0, 0, Smoke::mf_static|Smoke::mf_enum, 262, 22},	//3318 QAbstractSocket::UnsupportedSocketOperationError (enum)
    {134, 776, 0, 0, Smoke::mf_static|Smoke::mf_enum, 262, 23},	//3319 QAbstractSocket::UnfinishedSocketOperationError (enum)
    {134, 673, 0, 0, Smoke::mf_static|Smoke::mf_enum, 262, 24},	//3320 QAbstractSocket::ProxyAuthenticationRequiredError (enum)
    {134, 734, 0, 0, Smoke::mf_static|Smoke::mf_enum, 262, 25},	//3321 QAbstractSocket::SslHandshakeFailedError (enum)
    {134, 675, 0, 0, Smoke::mf_static|Smoke::mf_enum, 262, 26},	//3322 QAbstractSocket::ProxyConnectionRefusedError (enum)
    {134, 674, 0, 0, Smoke::mf_static|Smoke::mf_enum, 262, 27},	//3323 QAbstractSocket::ProxyConnectionClosedError (enum)
    {134, 676, 0, 0, Smoke::mf_static|Smoke::mf_enum, 262, 28},	//3324 QAbstractSocket::ProxyConnectionTimeoutError (enum)
    {134, 677, 0, 0, Smoke::mf_static|Smoke::mf_enum, 262, 29},	//3325 QAbstractSocket::ProxyNotFoundError (enum)
    {134, 678, 0, 0, Smoke::mf_static|Smoke::mf_enum, 262, 30},	//3326 QAbstractSocket::ProxyProtocolError (enum)
    {134, 795, 0, 0, Smoke::mf_static|Smoke::mf_enum, 262, 31},	//3327 QAbstractSocket::UnknownSocketError (enum)
    {139, 1171, 122, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3328 QDBusAbstractInterface::connectNotify(const char*)
    {139, 1381, 122, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3329 QDBusAbstractInterface::disconnectNotify(const char*)
    {147, 2060, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 582, 0},	//3330 QFile::metaObject() const
    {147, 2301, 122, 1, Smoke::mf_virtual, 639, 0},	//3331 QFile::qt_metacast(const char*)
    {147, 2299, 131, 3, Smoke::mf_virtual, 614, 0},	//3332 QFile::qt_metacall(QMetaObject::Call, int, void**)
    {147, 1855, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 450, 0},	//3333 QFile::isSequential() const
    {147, 1149, 0, 0, Smoke::mf_virtual, 0, 0},	//3334 QFile::close()
    {147, 2946, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 619, 0},	//3335 QFile::size() const
    {147, 2247, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 619, 0},	//3336 QFile::pos() const
    {147, 2474, 861, 1, Smoke::mf_virtual, 450, 0},	//3337 QFile::seek(long long)
    {147, 1038, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 450, 0},	//3338 QFile::atEnd() const
    {147, 1497, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 261, 0},	//3339 QFile::fileEngine() const
    {147, 2336, 1144, 2, Smoke::mf_protected|Smoke::mf_virtual, 619, 0},	//3340 QFile::readData(char*, long long)
    {147, 3290, 1147, 2, Smoke::mf_protected|Smoke::mf_virtual, 619, 0},	//3341 QFile::writeData(const char*, long long)
    {147, 2362, 1144, 2, Smoke::mf_protected|Smoke::mf_virtual, 619, 0},	//3342 QFile::readLineData(char*, long long)
    {147, 623, 0, 0, Smoke::mf_static|Smoke::mf_enum, 281, 14},	//3343 QFile::NoError (enum)
    {147, 685, 0, 0, Smoke::mf_static|Smoke::mf_enum, 281, 15},	//3344 QFile::ReadError (enum)
    {147, 814, 0, 0, Smoke::mf_static|Smoke::mf_enum, 281, 16},	//3345 QFile::WriteError (enum)
    {147, 139, 0, 0, Smoke::mf_static|Smoke::mf_enum, 281, 17},	//3346 QFile::FatalError (enum)
    {147, 701, 0, 0, Smoke::mf_static|Smoke::mf_enum, 281, 18},	//3347 QFile::ResourceError (enum)
    {147, 648, 0, 0, Smoke::mf_static|Smoke::mf_enum, 281, 19},	//3348 QFile::OpenError (enum)
    {147, 1, 0, 0, Smoke::mf_static|Smoke::mf_enum, 281, 20},	//3349 QFile::AbortError (enum)
    {147, 759, 0, 0, Smoke::mf_static|Smoke::mf_enum, 281, 21},	//3350 QFile::TimeOutError (enum)
    {147, 797, 0, 0, Smoke::mf_static|Smoke::mf_enum, 281, 22},	//3351 QFile::UnspecifiedError (enum)
    {147, 695, 0, 0, Smoke::mf_static|Smoke::mf_enum, 281, 23},	//3352 QFile::RemoveError (enum)
    {147, 697, 0, 0, Smoke::mf_static|Smoke::mf_enum, 281, 24},	//3353 QFile::RenameError (enum)
    {147, 668, 0, 0, Smoke::mf_static|Smoke::mf_enum, 281, 25},	//3354 QFile::PositionError (enum)
    {147, 699, 0, 0, Smoke::mf_static|Smoke::mf_enum, 281, 26},	//3355 QFile::ResizeError (enum)
    {147, 658, 0, 0, Smoke::mf_static|Smoke::mf_enum, 281, 27},	//3356 QFile::PermissionsError (enum)
    {147, 72, 0, 0, Smoke::mf_static|Smoke::mf_enum, 281, 28},	//3357 QFile::CopyError (enum)
    {149, 1894, 118, 1, Smoke::mf_static, 351, 1},	//3358 QGlobalSpace::kBacktrace(int)
    {149, 1894, 0, 0, Smoke::mf_static, 351, 2},	//3359 QGlobalSpace::kBacktrace()
    {149, 2203, 2330, 2, Smoke::mf_static, 282, 3},	//3360 QGlobalSpace::operator|(KAutostart::Condition, QFlags<KAutostart::Condition>)
    {149, 2203, 2333, 2, Smoke::mf_static, 282, 4},	//3361 QGlobalSpace::operator|(KAutostart::Condition, KAutostart::Condition)
    {149, 2203, 2336, 2, Smoke::mf_static, 289, 5},	//3362 QGlobalSpace::operator|(KLocale::DateTimeFormatOption, KLocale::DateTimeFormatOption)
    {149, 2203, 2339, 2, Smoke::mf_static, 286, 6},	//3363 QGlobalSpace::operator|(KCurrencyCode::CurrencyStatus, QFlags<KCurrencyCode::CurrencyStatus>)
    {149, 2173, 2342, 2, Smoke::mf_static, 273, 7},	//3364 QGlobalSpace::operator<<(QDataStream&, const KServiceAction&)
    {149, 2191, 2345, 2, Smoke::mf_static, 450, 8},	//3365 QGlobalSpace::operator>(const char*, const QLatin1String&)
    {149, 2203, 2348, 2, Smoke::mf_static, 290, 9},	//3366 QGlobalSpace::operator|(KLocale::TimeFormatOption, QFlags<KLocale::TimeFormatOption>)
    {149, 2203, 2351, 2, Smoke::mf_static, 296, 10},	//3367 QGlobalSpace::operator|(KUrl::CleanPathOption, QFlags<KUrl::CleanPathOption>)
    {149, 2203, 2354, 2, Smoke::mf_static, 296, 11},	//3368 QGlobalSpace::operator|(KUrl::CleanPathOption, KUrl::CleanPathOption)
    {149, 2203, 2357, 2, Smoke::mf_static, 308, 12},	//3369 QGlobalSpace::operator|(KConfigBase::WriteConfigFlag, int)
    {149, 2203, 2360, 2, Smoke::mf_static, 287, 13},	//3370 QGlobalSpace::operator|(KJob::Capability, KJob::Capability)
    {149, 2201, 2363, 2, Smoke::mf_static, 273, 14},	//3371 QGlobalSpace::operator>>(QDataStream&, KServiceAction&)
    {149, 1709, 122, 1, Smoke::mf_static, 351, 15},	//3372 QGlobalSpace::i18n(const char*)
    {149, 2168, 2366, 2, Smoke::mf_static, 450, 16},	//3373 QGlobalSpace::operator<(const QDBusSignature&, const QDBusSignature&)
    {149, 2203, 2369, 2, Smoke::mf_static, 308, 17},	//3374 QGlobalSpace::operator|(KUrl::QueryItemsOption, int)
    {149, 2185, 2366, 2, Smoke::mf_static, 450, 18},	//3375 QGlobalSpace::operator==(const QDBusSignature&, const QDBusSignature&)
    {149, 2203, 2372, 2, Smoke::mf_static, 298, 19},	//3376 QGlobalSpace::operator|(KUrl::EncodedPathAndQueryOption, KUrl::EncodedPathAndQueryOption)
    {149, 2203, 2375, 2, Smoke::mf_static, 284, 20},	//3377 QGlobalSpace::operator|(KConfig::OpenFlag, QFlags<KConfig::OpenFlag>)
    {149, 3135, 124, 2, Smoke::mf_static, 351, 21},	//3378 QGlobalSpace::tr2i18n(const char*, const char*)
    {149, 3135, 122, 1, Smoke::mf_static, 351, 22},	//3379 QGlobalSpace::tr2i18n(const char*)
    {149, 2203, 2378, 2, Smoke::mf_static, 297, 23},	//3380 QGlobalSpace::operator|(KUrl::DirectoryOption, KUrl::DirectoryOption)
    {149, 1711, 124, 2, Smoke::mf_static, 351, 24},	//3381 QGlobalSpace::i18nc(const char*, const char*)
    {149, 2203, 2381, 2, Smoke::mf_static, 297, 25},	//3382 QGlobalSpace::operator|(KUrl::DirectoryOption, QFlags<KUrl::DirectoryOption>)
    {149, 2164, 524, 2, Smoke::mf_static, 589, 26},	//3383 QGlobalSpace::operator+(const QString&, const char*)
    {149, 2203, 2384, 2, Smoke::mf_static, 283, 27},	//3384 QGlobalSpace::operator|(KCmdLineArgs::StdCmdLineArg, QFlags<KCmdLineArgs::StdCmdLineArg>)
    {149, 2164, 521, 2, Smoke::mf_static, 589, 28},	//3385 QGlobalSpace::operator+(const char*, const QString&)
    {149, 2203, 2387, 2, Smoke::mf_static, 294, 29},	//3386 QGlobalSpace::operator|(KShell::Option, KShell::Option)
    {149, 2203, 2390, 2, Smoke::mf_static, 308, 30},	//3387 QGlobalSpace::operator|(KLockFile::LockFlag, int)
    {149, 2203, 2393, 2, Smoke::mf_static, 288, 31},	//3388 QGlobalSpace::operator|(KLocale::DateTimeComponent, QFlags<KLocale::DateTimeComponent>)
    {149, 2177, 521, 2, Smoke::mf_static, 450, 32},	//3389 QGlobalSpace::operator<=(const char*, const QString&)
    {149, 1932, 124, 2, Smoke::mf_static, 141, 33},	//3390 QGlobalSpace::ki18nc(const char*, const char*)
    {149, 2185, 2396, 2, Smoke::mf_static, 450, 34},	//3391 QGlobalSpace::operator==(const QDBusObjectPath&, const QDBusObjectPath&)
    {149, 2196, 2345, 2, Smoke::mf_static, 450, 35},	//3392 QGlobalSpace::operator>=(const char*, const QLatin1String&)
    {149, 2203, 2399, 2, Smoke::mf_static, 308, 36},	//3393 QGlobalSpace::operator|(KCmdLineArgs::StdCmdLineArg, int)
    {149, 2203, 2402, 2, Smoke::mf_static, 308, 37},	//3394 QGlobalSpace::operator|(KLocale::DateTimeFormatOption, int)
    {149, 2203, 2405, 2, Smoke::mf_static, 308, 38},	//3395 QGlobalSpace::operator|(KUrl::EncodedPathAndQueryOption, int)
    {149, 2203, 2408, 2, Smoke::mf_static, 308, 39},	//3396 QGlobalSpace::operator|(KShell::Option, int)
    {149, 1892, 2411, 1, Smoke::mf_static, 454, 40},	//3397 QGlobalSpace::kAsciiToUpper(char*)
    {149, 2185, 2345, 2, Smoke::mf_static, 450, 41},	//3398 QGlobalSpace::operator==(const char*, const QLatin1String&)
    {149, 2203, 2413, 2, Smoke::mf_static, 294, 42},	//3399 QGlobalSpace::operator|(KShell::Option, QFlags<KShell::Option>)
    {149, 2203, 2416, 2, Smoke::mf_static, 295, 43},	//3400 QGlobalSpace::operator|(KStandardDirs::SearchOption, QFlags<KStandardDirs::SearchOption>)
    {149, 2203, 2419, 2, Smoke::mf_static, 308, 44},	//3401 QGlobalSpace::operator|(KAutostart::Condition, int)
    {149, 2203, 2422, 2, Smoke::mf_static, 286, 45},	//3402 QGlobalSpace::operator|(KCurrencyCode::CurrencyStatus, KCurrencyCode::CurrencyStatus)
    {149, 2164, 2425, 2, Smoke::mf_static, 589, 46},	//3403 QGlobalSpace::operator+(const QByteArray&, const QString&)
    {149, 2164, 2428, 2, Smoke::mf_static, 589, 47},	//3404 QGlobalSpace::operator+(const QString&, char)
    {149, 2203, 2431, 2, Smoke::mf_static, 295, 48},	//3405 QGlobalSpace::operator|(KStandardDirs::SearchOption, KStandardDirs::SearchOption)
    {149, 1934, 1336, 3, Smoke::mf_static, 141, 49},	//3406 QGlobalSpace::ki18ncp(const char*, const char*, const char*)
    {149, 2203, 2434, 2, Smoke::mf_static, 308, 50},	//3407 QGlobalSpace::operator|(KJob::Capability, int)
    {149, 2203, 2437, 2, Smoke::mf_static, 291, 51},	//3408 QGlobalSpace::operator|(KLocale::TimeProcessingOption, KLocale::TimeProcessingOption)
    {149, 2196, 2440, 2, Smoke::mf_static, 450, 52},	//3409 QGlobalSpace::operator>=(const QLatin1String&, const QLatin1String&)
    {149, 2203, 2443, 2, Smoke::mf_static, 299, 53},	//3410 QGlobalSpace::operator|(KUrl::EqualsOption, KUrl::EqualsOption)
    {149, 1901, 124, 2, Smoke::mf_static, 614, 54},	//3411 QGlobalSpace::kasciistricmp(const char*, const char*)
    {149, 2203, 2446, 2, Smoke::mf_static, 308, 55},	//3412 QGlobalSpace::operator|(KUrl::CleanPathOption, int)
    {149, 2203, 2449, 2, Smoke::mf_static, 308, 56},	//3413 QGlobalSpace::operator|(KStandardDirs::SearchOption, int)
    {149, 2203, 2452, 2, Smoke::mf_static, 300, 57},	//3414 QGlobalSpace::operator|(KUrl::QueryItemsOption, KUrl::QueryItemsOption)
    {149, 2203, 2455, 2, Smoke::mf_static, 285, 58},	//3415 QGlobalSpace::operator|(KConfigBase::WriteConfigFlag, KConfigBase::WriteConfigFlag)
    {149, 2203, 2458, 2, Smoke::mf_static, 308, 59},	//3416 QGlobalSpace::operator|(KConfig::OpenFlag, int)
    {149, 1904, 118, 1, Smoke::mf_static, 351, 60},	//3417 QGlobalSpace::kdBacktrace(int)
    {149, 1904, 0, 0, Smoke::mf_static, 351, 61},	//3418 QGlobalSpace::kdBacktrace()
    {149, 2203, 2461, 2, Smoke::mf_static, 290, 62},	//3419 QGlobalSpace::operator|(KLocale::TimeFormatOption, KLocale::TimeFormatOption)
    {149, 2168, 521, 2, Smoke::mf_static, 450, 63},	//3420 QGlobalSpace::operator<(const char*, const QString&)
    {149, 2158, 521, 2, Smoke::mf_static, 450, 64},	//3421 QGlobalSpace::operator!=(const char*, const QString&)
    {149, 2203, 2464, 2, Smoke::mf_static, 308, 65},	//3422 QGlobalSpace::operator|(KCurrencyCode::CurrencyStatus, int)
    {149, 2203, 2467, 2, Smoke::mf_static, 308, 66},	//3423 QGlobalSpace::operator|(KUrl::EqualsOption, int)
    {149, 2177, 2345, 2, Smoke::mf_static, 450, 67},	//3424 QGlobalSpace::operator<=(const char*, const QLatin1String&)
    {149, 2203, 2470, 2, Smoke::mf_static, 291, 68},	//3425 QGlobalSpace::operator|(KLocale::TimeProcessingOption, QFlags<KLocale::TimeProcessingOption>)
    {149, 2203, 2473, 2, Smoke::mf_static, 299, 69},	//3426 QGlobalSpace::operator|(KUrl::EqualsOption, QFlags<KUrl::EqualsOption>)
    {149, 2203, 2476, 2, Smoke::mf_static, 308, 70},	//3427 QGlobalSpace::operator|(KLocale::TimeProcessingOption, int)
    {149, 2164, 2479, 2, Smoke::mf_static, 589, 71},	//3428 QGlobalSpace::operator+(char, const QString&)
    {149, 2185, 2440, 2, Smoke::mf_static, 450, 72},	//3429 QGlobalSpace::operator==(const QLatin1String&, const QLatin1String&)
    {149, 1890, 2411, 1, Smoke::mf_static, 454, 73},	//3430 QGlobalSpace::kAsciiToLower(char*)
    {149, 2173, 2482, 2, Smoke::mf_static, 273, 74},	//3431 QGlobalSpace::operator<<(QDataStream&, const KProtocolInfo::ExtraField&)
    {149, 2203, 2485, 2, Smoke::mf_static, 292, 75},	//3432 QGlobalSpace::operator|(KLockFile::LockFlag, QFlags<KLockFile::LockFlag>)
    {149, 2158, 2366, 2, Smoke::mf_static, 450, 76},	//3433 QGlobalSpace::operator!=(const QDBusSignature&, const QDBusSignature&)
    {149, 2177, 2440, 2, Smoke::mf_static, 450, 77},	//3434 QGlobalSpace::operator<=(const QLatin1String&, const QLatin1String&)
    {149, 2203, 2488, 2, Smoke::mf_static, 289, 78},	//3435 QGlobalSpace::operator|(KLocale::DateTimeFormatOption, QFlags<KLocale::DateTimeFormatOption>)
    {149, 2203, 2491, 2, Smoke::mf_static, 300, 79},	//3436 QGlobalSpace::operator|(KUrl::QueryItemsOption, QFlags<KUrl::QueryItemsOption>)
    {149, 2158, 2396, 2, Smoke::mf_static, 450, 80},	//3437 QGlobalSpace::operator!=(const QDBusObjectPath&, const QDBusObjectPath&)
    {149, 2203, 2494, 2, Smoke::mf_static, 308, 81},	//3438 QGlobalSpace::operator|(KUrl::DirectoryOption, int)
    {149, 1930, 122, 1, Smoke::mf_static, 141, 82},	//3439 QGlobalSpace::ki18n(const char*)
    {149, 2158, 2440, 2, Smoke::mf_static, 450, 83},	//3440 QGlobalSpace::operator!=(const QLatin1String&, const QLatin1String&)
    {149, 2203, 2497, 2, Smoke::mf_static, 288, 84},	//3441 QGlobalSpace::operator|(KLocale::DateTimeComponent, KLocale::DateTimeComponent)
    {149, 2168, 2396, 2, Smoke::mf_static, 450, 85},	//3442 QGlobalSpace::operator<(const QDBusObjectPath&, const QDBusObjectPath&)
    {149, 2203, 2500, 2, Smoke::mf_static, 284, 86},	//3443 QGlobalSpace::operator|(KConfig::OpenFlag, KConfig::OpenFlag)
    {149, 2191, 521, 2, Smoke::mf_static, 450, 87},	//3444 QGlobalSpace::operator>(const char*, const QString&)
    {149, 2203, 2503, 2, Smoke::mf_static, 283, 88},	//3445 QGlobalSpace::operator|(KCmdLineArgs::StdCmdLineArg, KCmdLineArgs::StdCmdLineArg)
    {149, 2168, 2345, 2, Smoke::mf_static, 450, 89},	//3446 QGlobalSpace::operator<(const char*, const QLatin1String&)
    {149, 2203, 2506, 2, Smoke::mf_static, 308, 90},	//3447 QGlobalSpace::operator|(KLocale::TimeFormatOption, int)
    {149, 2191, 2440, 2, Smoke::mf_static, 450, 91},	//3448 QGlobalSpace::operator>(const QLatin1String&, const QLatin1String&)
    {149, 1897, 118, 1, Smoke::mf_static, 351, 92},	//3449 QGlobalSpace::kRealBacktrace(int)
    {149, 2201, 2509, 2, Smoke::mf_static, 273, 93},	//3450 QGlobalSpace::operator>>(QDataStream&, KProtocolInfo::ExtraField&)
    {149, 2203, 2512, 2, Smoke::mf_static, 298, 94},	//3451 QGlobalSpace::operator|(KUrl::EncodedPathAndQueryOption, QFlags<KUrl::EncodedPathAndQueryOption>)
    {149, 2168, 2440, 2, Smoke::mf_static, 450, 95},	//3452 QGlobalSpace::operator<(const QLatin1String&, const QLatin1String&)
    {149, 2203, 2515, 2, Smoke::mf_static, 285, 96},	//3453 QGlobalSpace::operator|(KConfigBase::WriteConfigFlag, QFlags<KConfigBase::WriteConfigFlag>)
    {149, 2164, 589, 2, Smoke::mf_static, 589, 97},	//3454 QGlobalSpace::operator+(const QString&, const QByteArray&)
    {149, 2203, 2518, 2, Smoke::mf_static, 308, 98},	//3455 QGlobalSpace::operator|(KLocale::DateTimeComponent, int)
    {149, 2185, 521, 2, Smoke::mf_static, 450, 99},	//3456 QGlobalSpace::operator==(const char*, const QString&)
    {149, 2203, 2521, 2, Smoke::mf_static, 287, 100},	//3457 QGlobalSpace::operator|(KJob::Capability, QFlags<KJob::Capability>)
    {149, 1896, 0, 0, Smoke::mf_static, 0, 101},	//3458 QGlobalSpace::kClearDebugConfig()
    {149, 2196, 521, 2, Smoke::mf_static, 450, 102},	//3459 QGlobalSpace::operator>=(const char*, const QString&)
    {149, 1936, 124, 2, Smoke::mf_static, 141, 103},	//3460 QGlobalSpace::ki18np(const char*, const char*)
    {149, 2203, 2524, 2, Smoke::mf_static, 292, 104},	//3461 QGlobalSpace::operator|(KLockFile::LockFlag, KLockFile::LockFlag)
    {149, 2158, 2345, 2, Smoke::mf_static, 450, 105},	//3462 QGlobalSpace::operator!=(const char*, const QLatin1String&)
    {149, 470, 0, 0, Smoke::mf_static|Smoke::mf_enum, 210, 106},	//3463 QGlobalSpace::KST_KSycocaEntry (enum)
    {149, 463, 0, 0, Smoke::mf_static|Smoke::mf_enum, 210, 107},	//3464 QGlobalSpace::KST_KService (enum)
    {149, 468, 0, 0, Smoke::mf_static|Smoke::mf_enum, 210, 108},	//3465 QGlobalSpace::KST_KServiceType (enum)
    {149, 458, 0, 0, Smoke::mf_static|Smoke::mf_enum, 210, 109},	//3466 QGlobalSpace::KST_KMimeType (enum)
    {149, 455, 0, 0, Smoke::mf_static|Smoke::mf_enum, 210, 110},	//3467 QGlobalSpace::KST_KFolderMimeType (enum)
    {149, 454, 0, 0, Smoke::mf_static|Smoke::mf_enum, 210, 111},	//3468 QGlobalSpace::KST_KDEDesktopMimeType (enum)
    {149, 459, 0, 0, Smoke::mf_static|Smoke::mf_enum, 210, 112},	//3469 QGlobalSpace::KST_KMimeTypeEntry (enum)
    {149, 465, 0, 0, Smoke::mf_static|Smoke::mf_enum, 210, 113},	//3470 QGlobalSpace::KST_KServiceGroup (enum)
    {149, 457, 0, 0, Smoke::mf_static|Smoke::mf_enum, 210, 114},	//3471 QGlobalSpace::KST_KImageIOFormat (enum)
    {149, 461, 0, 0, Smoke::mf_static|Smoke::mf_enum, 210, 115},	//3472 QGlobalSpace::KST_KProtocolInfo (enum)
    {149, 467, 0, 0, Smoke::mf_static|Smoke::mf_enum, 210, 116},	//3473 QGlobalSpace::KST_KServiceSeparator (enum)
    {149, 453, 0, 0, Smoke::mf_static|Smoke::mf_enum, 210, 117},	//3474 QGlobalSpace::KST_KCustom (enum)
    {149, 464, 0, 0, Smoke::mf_static|Smoke::mf_enum, 208, 118},	//3475 QGlobalSpace::KST_KServiceFactory (enum)
    {149, 469, 0, 0, Smoke::mf_static|Smoke::mf_enum, 208, 119},	//3476 QGlobalSpace::KST_KServiceTypeFactory (enum)
    {149, 466, 0, 0, Smoke::mf_static|Smoke::mf_enum, 208, 120},	//3477 QGlobalSpace::KST_KServiceGroupFactory (enum)
    {149, 456, 0, 0, Smoke::mf_static|Smoke::mf_enum, 208, 121},	//3478 QGlobalSpace::KST_KImageIO (enum)
    {149, 462, 0, 0, Smoke::mf_static|Smoke::mf_enum, 208, 122},	//3479 QGlobalSpace::KST_KProtocolInfoFactory (enum)
    {149, 460, 0, 0, Smoke::mf_static|Smoke::mf_enum, 208, 123},	//3480 QGlobalSpace::KST_KMimeTypeFactory (enum)
    {149, 452, 0, 0, Smoke::mf_static|Smoke::mf_enum, 208, 124},	//3481 QGlobalSpace::KST_CTimeInfo (enum)
    {151, 2145, 150, 1, Smoke::mf_virtual, 450, 0},	//3482 QIODevice::open(QFlags<QIODevice::OpenModeFlag>)
    {151, 2247, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 619, 0},	//3483 QIODevice::pos() const
    {151, 2946, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 619, 0},	//3484 QIODevice::size() const
    {151, 2474, 861, 1, Smoke::mf_virtual, 450, 0},	//3485 QIODevice::seek(long long)
    {151, 2438, 0, 0, Smoke::mf_virtual, 450, 0},	//3486 QIODevice::reset()
    {151, 1085, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 619, 0},	//3487 QIODevice::bytesAvailable() const
    {151, 1086, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 619, 0},	//3488 QIODevice::bytesToWrite() const
    {151, 1103, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 450, 0},	//3489 QIODevice::canReadLine() const
    {151, 3245, 118, 1, Smoke::mf_virtual, 450, 0},	//3490 QIODevice::waitForReadyRead(int)
    {151, 3241, 118, 1, Smoke::mf_virtual, 450, 0},	//3491 QIODevice::waitForBytesWritten(int)
    {151, 2362, 1144, 2, Smoke::mf_protected|Smoke::mf_virtual, 619, 0},	//3492 QIODevice::readLineData(char*, long long)
    {151, 639, 0, 0, Smoke::mf_static|Smoke::mf_enum, 307, 12},	//3493 QIODevice::NotOpen (enum)
    {151, 687, 0, 0, Smoke::mf_static|Smoke::mf_enum, 307, 13},	//3494 QIODevice::ReadOnly (enum)
    {151, 816, 0, 0, Smoke::mf_static|Smoke::mf_enum, 307, 14},	//3495 QIODevice::WriteOnly (enum)
    {151, 691, 0, 0, Smoke::mf_static|Smoke::mf_enum, 307, 15},	//3496 QIODevice::ReadWrite (enum)
    {151, 19, 0, 0, Smoke::mf_static|Smoke::mf_enum, 307, 16},	//3497 QIODevice::Append (enum)
    {151, 769, 0, 0, Smoke::mf_static|Smoke::mf_enum, 307, 17},	//3498 QIODevice::Truncate (enum)
    {151, 751, 0, 0, Smoke::mf_static|Smoke::mf_enum, 307, 18},	//3499 QIODevice::Text (enum)
    {151, 774, 0, 0, Smoke::mf_static|Smoke::mf_enum, 307, 19},	//3500 QIODevice::Unbuffered (enum)
    {158, 1443, 2527, 1, Smoke::mf_virtual, 450, 0},	//3501 QObject::event(QEvent*)
    {158, 1444, 2529, 2, Smoke::mf_virtual, 450, 0},	//3502 QObject::eventFilter(QObject*, QEvent*)
    {158, 3102, 2532, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3503 QObject::timerEvent(QTimerEvent*)
    {158, 1135, 2534, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3504 QObject::childEvent(QChildEvent*)
    {158, 1243, 2527, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3505 QObject::customEvent(QEvent*)
    {158, 1171, 122, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3506 QObject::connectNotify(const char*)
    {158, 1381, 122, 1, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3507 QObject::disconnectNotify(const char*)
    {161, 3245, 118, 1, Smoke::mf_virtual, 450, 0},	//3508 QProcess::waitForReadyRead(int)
    {161, 3241, 118, 1, Smoke::mf_virtual, 450, 0},	//3509 QProcess::waitForBytesWritten(int)
    {161, 1085, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 619, 0},	//3510 QProcess::bytesAvailable() const
    {161, 1086, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 619, 0},	//3511 QProcess::bytesToWrite() const
    {161, 1855, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 450, 0},	//3512 QProcess::isSequential() const
    {161, 1103, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 450, 0},	//3513 QProcess::canReadLine() const
    {161, 1149, 0, 0, Smoke::mf_virtual, 0, 0},	//3514 QProcess::close()
    {161, 1038, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 450, 0},	//3515 QProcess::atEnd() const
    {161, 2930, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 0},	//3516 QProcess::setupChildProcess()
    {161, 2336, 1144, 2, Smoke::mf_protected|Smoke::mf_virtual, 619, 0},	//3517 QProcess::readData(char*, long long)
    {161, 3290, 1147, 2, Smoke::mf_protected|Smoke::mf_virtual, 619, 0},	//3518 QProcess::writeData(const char*, long long)
    {168, 2060, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 582, 0},	//3519 QTemporaryFile::metaObject() const
    {168, 2301, 122, 1, Smoke::mf_virtual, 639, 0},	//3520 QTemporaryFile::qt_metacast(const char*)
    {168, 2299, 131, 3, Smoke::mf_virtual, 614, 0},	//3521 QTemporaryFile::qt_metacall(QMetaObject::Call, int, void**)
    {168, 1497, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 261, 0},	//3522 QTemporaryFile::fileEngine() const
    {168, 2145, 150, 1, Smoke::mf_protected|Smoke::mf_virtual, 450, 0},	//3523 QTemporaryFile::open(QFlags<QIODevice::OpenModeFlag>)
    {177, 1358, 30, 1, Smoke::mf_static, 351, 1},	//3524 Sonnet::detectLanguage(const QString&)
    {177, 1323, 0, 0, Smoke::mf_static, 351, 2},	//3525 Sonnet::defaultLanguageName()
    {178, 2060, 0, 0, Smoke::mf_const|Smoke::mf_virtual, 582, 1},	//3526 Sonnet::BackgroundChecker::metaObject() const
    {178, 2301, 122, 1, Smoke::mf_virtual, 639, 2},	//3527 Sonnet::BackgroundChecker::qt_metacast(const char*)
    {178, 3131, 124, 2, Smoke::mf_static, 351, 3},	//3528 Sonnet::BackgroundChecker::tr(const char*, const char*)
    {178, 3138, 124, 2, Smoke::mf_static, 351, 4},	//3529 Sonnet::BackgroundChecker::trUtf8(const char*, const char*)
    {178, 3131, 127, 3, Smoke::mf_static, 351, 5},	//3530 Sonnet::BackgroundChecker::tr(const char*, const char*, int)
    {178, 3138, 127, 3, Smoke::mf_static, 351, 6},	//3531 Sonnet::BackgroundChecker::trUtf8(const char*, const char*, int)
    {178, 2299, 131, 3, Smoke::mf_virtual, 614, 7},	//3532 Sonnet::BackgroundChecker::qt_metacall(QMetaObject::Call, int, void**)
    {178, 35, 146, 1, Smoke::mf_ctor, 445, 8},	//3533 Sonnet::BackgroundChecker::BackgroundChecker(QObject*)
    {178, 35, 2536, 2, Smoke::mf_ctor, 445, 9},	//3534 Sonnet::BackgroundChecker::BackgroundChecker(const Sonnet::Speller&, QObject*)
    {178, 2884, 30, 1, 0, 0, 10},	//3535 Sonnet::BackgroundChecker::setText(const QString&)
    {178, 3091, 0, 0, Smoke::mf_const, 351, 11},	//3536 Sonnet::BackgroundChecker::text() const
    {178, 1230, 0, 0, Smoke::mf_const, 351, 12},	//3537 Sonnet::BackgroundChecker::currentContext() const
    {178, 2958, 0, 0, Smoke::mf_const, 446, 13},	//3538 Sonnet::BackgroundChecker::speller() const
    {178, 2872, 2539, 1, 0, 0, 14},	//3539 Sonnet::BackgroundChecker::setSpeller(const Sonnet::Speller&)
    {178, 1132, 30, 1, 0, 450, 15},	//3540 Sonnet::BackgroundChecker::checkWord(const QString&)
    {178, 3060, 30, 1, Smoke::mf_const, 354, 16},	//3541 Sonnet::BackgroundChecker::suggest(const QString&) const
    {178, 992, 30, 1, 0, 450, 17},	//3542 Sonnet::BackgroundChecker::addWordToPersonal(const QString&)
    {178, 2449, 595, 1, 0, 0, 18},	//3543 Sonnet::BackgroundChecker::restore(KConfig*)
    {178, 2972, 0, 0, Smoke::mf_virtual|Smoke::mf_slot, 0, 19},	//3544 Sonnet::BackgroundChecker::start()
    {178, 3036, 0, 0, Smoke::mf_virtual|Smoke::mf_slot, 0, 20},	//3545 Sonnet::BackgroundChecker::stop()
    {178, 2432, 2541, 3, Smoke::mf_slot, 0, 21},	//3546 Sonnet::BackgroundChecker::replace(int, const QString&, const QString&)
    {178, 1119, 30, 1, Smoke::mf_slot, 0, 22},	//3547 Sonnet::BackgroundChecker::changeLanguage(const QString&)
    {178, 1184, 0, 0, Smoke::mf_virtual|Smoke::mf_slot, 0, 23},	//3548 Sonnet::BackgroundChecker::continueChecking()
    {178, 2066, 1014, 2, Smoke::mf_protected|Smoke::mf_signal, 0, 24},	//3549 Sonnet::BackgroundChecker::misspelling(const QString&, int)
    {178, 1387, 0, 0, Smoke::mf_protected|Smoke::mf_signal, 0, 25},	//3550 Sonnet::BackgroundChecker::done()
    {178, 1494, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 351, 26},	//3551 Sonnet::BackgroundChecker::fetchMoreText()
    {178, 1560, 0, 0, Smoke::mf_protected|Smoke::mf_virtual, 0, 27},	//3552 Sonnet::BackgroundChecker::finishedCurrentFeed()
    {178, 2947, 0, 0, Smoke::mf_protected|Smoke::mf_slot, 0, 28},	//3553 Sonnet::BackgroundChecker::slotEngineDone()
    {178, 3131, 122, 1, Smoke::mf_static, 351, 29},	//3554 Sonnet::BackgroundChecker::tr(const char*)
    {178, 3138, 122, 1, Smoke::mf_static, 351, 30},	//3555 Sonnet::BackgroundChecker::trUtf8(const char*)
    {178, 35, 0, 0, Smoke::mf_ctor, 445, 31},	//3556 Sonnet::BackgroundChecker::BackgroundChecker()
    {178, 35, 2539, 1, Smoke::mf_ctor, 445, 32},	//3557 Sonnet::BackgroundChecker::BackgroundChecker(const Sonnet::Speller&)
    {178, 3030, 0, 0, Smoke::mf_const|Smoke::mf_static|Smoke::mf_attribute, 581, 33},	//3558 Sonnet::BackgroundChecker::staticMetaObject() const
    {178, 3330, 0, 0, Smoke::mf_dtor, 0, 34 },	//3559 Sonnet::BackgroundChecker::~BackgroundChecker()
    {179, 731, 30, 1, Smoke::mf_ctor, 448, 1},	//3560 Sonnet::Speller::Speller(const QString&)
    {179, 731, 2539, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 448, 2},	//3561 Sonnet::Speller::Speller(const Sonnet::Speller&)
    {179, 2182, 2539, 1, 0, 447, 3},	//3562 Sonnet::Speller::operator=(const Sonnet::Speller&)
    {179, 1871, 0, 0, Smoke::mf_const, 450, 4},	//3563 Sonnet::Speller::isValid() const
    {179, 2674, 30, 1, 0, 0, 5},	//3564 Sonnet::Speller::setLanguage(const QString&)
    {179, 1947, 0, 0, Smoke::mf_const, 351, 6},	//3565 Sonnet::Speller::language() const
    {179, 1792, 30, 1, Smoke::mf_const, 450, 7},	//3566 Sonnet::Speller::isCorrect(const QString&) const
    {179, 1839, 30, 1, Smoke::mf_const, 450, 8},	//3567 Sonnet::Speller::isMisspelled(const QString&) const
    {179, 3060, 30, 1, Smoke::mf_const, 354, 9},	//3568 Sonnet::Speller::suggest(const QString&) const
    {179, 1126, 757, 2, Smoke::mf_const, 450, 10},	//3569 Sonnet::Speller::checkAndSuggest(const QString&, QStringList&) const
    {179, 3039, 95, 2, 0, 450, 11},	//3570 Sonnet::Speller::storeReplacement(const QString&, const QString&)
    {179, 988, 30, 1, 0, 450, 12},	//3571 Sonnet::Speller::addToPersonal(const QString&)
    {179, 990, 30, 1, 0, 450, 13},	//3572 Sonnet::Speller::addToSession(const QString&)
    {179, 2460, 595, 1, 0, 0, 14},	//3573 Sonnet::Speller::save(KConfig*)
    {179, 2449, 595, 1, 0, 0, 15},	//3574 Sonnet::Speller::restore(KConfig*)
    {179, 1061, 0, 0, Smoke::mf_const, 354, 16},	//3575 Sonnet::Speller::availableBackends() const
    {179, 1065, 0, 0, Smoke::mf_const, 354, 17},	//3576 Sonnet::Speller::availableLanguages() const
    {179, 1064, 0, 0, Smoke::mf_const, 354, 18},	//3577 Sonnet::Speller::availableLanguageNames() const
    {179, 1062, 0, 0, Smoke::mf_const, 339, 19},	//3578 Sonnet::Speller::availableDictionaries() const
    {179, 2597, 30, 1, 0, 0, 20},	//3579 Sonnet::Speller::setDefaultLanguage(const QString&)
    {179, 1322, 0, 0, Smoke::mf_const, 351, 21},	//3580 Sonnet::Speller::defaultLanguage() const
    {179, 2595, 30, 1, 0, 0, 22},	//3581 Sonnet::Speller::setDefaultClient(const QString&)
    {179, 1319, 0, 0, Smoke::mf_const, 351, 23},	//3582 Sonnet::Speller::defaultClient() const
    {179, 2512, 2545, 2, 0, 0, 24},	//3583 Sonnet::Speller::setAttribute(Sonnet::Speller::Attribute, bool)
    {179, 3089, 2548, 1, Smoke::mf_const, 450, 25},	//3584 Sonnet::Speller::testAttribute(Sonnet::Speller::Attribute) const
    {179, 731, 0, 0, Smoke::mf_ctor, 448, 26},	//3585 Sonnet::Speller::Speller()
    {179, 2512, 2548, 1, 0, 0, 27},	//3586 Sonnet::Speller::setAttribute(Sonnet::Speller::Attribute)
    {179, 53, 0, 0, Smoke::mf_static|Smoke::mf_enum, 449, 28},	//3587 Sonnet::Speller::CheckUppercase (enum)
    {179, 718, 0, 0, Smoke::mf_static|Smoke::mf_enum, 449, 29},	//3588 Sonnet::Speller::SkipRunTogether (enum)
    {179, 3435, 0, 0, Smoke::mf_dtor, 0, 30 },	//3589 Sonnet::Speller::~Speller()
    {181, 1941, 0, 0, Smoke::mf_ctor, 617, 1},	//3590 kndbgstream::kndbgstream()
    {181, 1941, 2550, 1, Smoke::mf_ctor|Smoke::mf_copyctor, 617, 2},	//3591 kndbgstream::kndbgstream(const kndbgstream&)
    {181, 3437, 0, 0, Smoke::mf_dtor, 0, 3 },	//3592 kndbgstream::~kndbgstream()
};

static Smoke::Index ambiguousMethodList[] = {
    0,
    3103,  // KUrl::KUrl(const QByteArray&)
    3104,  // KUrl::KUrl(const KUrl&)
    3105,  // KUrl::KUrl(const QUrl&)
    0,
    3101,  // KUrl::KUrl(const QString&)
    3102,  // KUrl::KUrl(const char*)
    0,
    3152,  // KUrl::operator=(const KUrl&)
    3154,  // KUrl::operator=(const QByteArray&)
    0,
    3153,  // KUrl::operator=(const char*)
    3155,  // KUrl::operator=(const QString&)
    0,
    3244,  // KUserGroup::KUserGroup(const group*)
    3245,  // KUserGroup::KUserGroup(const KUserGroup&)
    0,
    3240,  // KUserGroup::KUserGroup(const QString&)
    3241,  // KUserGroup::KUserGroup(const char*)
    3242,  // KUserGroup::KUserGroup(KUser::UIDMode)
    0,
    2851,  // KTimeZone::KTimeZone(const KTimeZone&)
    2888,  // KTimeZone::KTimeZone(KTimeZoneBackend*)
    0,
    2724,  // KStringHandler::perlSplit(const QChar&, const QString&)
    2727,  // KStringHandler::perlSplit(const QRegExp&, const QString&)
    0,
    2723,  // KStringHandler::perlSplit(const QChar&, const QString&, int)
    2726,  // KStringHandler::perlSplit(const QRegExp&, const QString&, int)
    0,
    2307,  // KProcess::execute(int)
    2321,  // KProcess::execute(const QString&)
    0,
    96,  // KAboutPerson::KAboutPerson(const KAboutPerson&)
    103,  // KAboutPerson::KAboutPerson(const KLocalizedString&)
    0,
    2066,  // KMD5::update(const QByteArray&)
    2067,  // KMD5::update(QIODevice&)
    0,
    2079,  // KMD5::update(const char*)
    2080,  // KMD5::update(const unsigned char*)
    0,
    2064,  // KMD5::update(const char*, int)
    2065,  // KMD5::update(const unsigned char*, int)
    0,
    1659,  // KLocalSocket::connectToPath(const QString&, QFlags<QIODevice::OpenModeFlag>)
    1671,  // KLocalSocket::connectToPath(const QString&, KLocalSocket::LocalSocketType)
    0,
    2635,  // KSocketFactory::connectToHost(const QUrl&, QObject*)
    2640,  // KSocketFactory::connectToHost(QTcpSocket*, const QUrl&)
    0,
    934,  // KCoreConfigSkeleton::ItemEnum::ItemEnum(const QString&, const QString&, int&, const QList<KCoreConfigSkeleton::ItemEnum::Choice>&)
    935,  // KCoreConfigSkeleton::ItemEnum::ItemEnum(const QString&, const QString&, int&, const QList<KCoreConfigSkeleton::ItemEnum::Choice2>&)
    0,
    927,  // KCoreConfigSkeleton::ItemEnum::ItemEnum(const QString&, const QString&, int&, const QList<KCoreConfigSkeleton::ItemEnum::Choice>&, int)
    928,  // KCoreConfigSkeleton::ItemEnum::ItemEnum(const QString&, const QString&, int&, const QList<KCoreConfigSkeleton::ItemEnum::Choice2>&, int)
    0,
    3213,  // KUser::KUser(const passwd*)
    3214,  // KUser::KUser(const KUser&)
    0,
    3209,  // KUser::KUser(KUser::UIDMode)
    3211,  // KUser::KUser(const QString&)
    3212,  // KUser::KUser(const char*)
    0,
    662,  // KConfigGroup::KConfigGroup(KConfigBase*, const QString&)
    663,  // KConfigGroup::KConfigGroup(KConfigBase*, const char*)
    664,  // KConfigGroup::KConfigGroup(const KConfigBase*, const QString&)
    665,  // KConfigGroup::KConfigGroup(const KConfigBase*, const char*)
    0,
    666,  // KConfigGroup::KConfigGroup(const KSharedPtr<KSharedConfig>&, const QString&)
    667,  // KConfigGroup::KConfigGroup(const KSharedPtr<KSharedConfig>&, const char*)
    0,
    678,  // KConfigGroup::changeGroup(const QString&)
    679,  // KConfigGroup::changeGroup(const char*)
    0,
    676,  // KConfigGroup::config()
    677,  // KConfigGroup::config() const
    0,
    772,  // KConfigGroup::deleteEntry(const QString&)
    773,  // KConfigGroup::deleteEntry(const char*)
    0,
    725,  // KConfigGroup::deleteEntry(const QString&, QFlags<KConfigBase::WriteConfigFlag>)
    726,  // KConfigGroup::deleteEntry(const char*, QFlags<KConfigBase::WriteConfigFlag>)
    0,
    685,  // KConfigGroup::deleteGroup(QFlags<KConfigBase::WriteConfigFlag>)
    746,  // KConfigGroup::deleteGroup(const QString&)
    747,  // KConfigGroup::deleteGroup(const char*)
    0,
    687,  // KConfigGroup::deleteGroup(const QString&, QFlags<KConfigBase::WriteConfigFlag>)
    688,  // KConfigGroup::deleteGroup(const char*, QFlags<KConfigBase::WriteConfigFlag>)
    0,
    738,  // KConfigGroup::groupImpl(const QByteArray&)
    739,  // KConfigGroup::groupImpl(const QByteArray&) const
    0,
    734,  // KConfigGroup::hasDefault(const QString&) const
    735,  // KConfigGroup::hasDefault(const char*) const
    0,
    727,  // KConfigGroup::hasKey(const QString&) const
    728,  // KConfigGroup::hasKey(const char*) const
    0,
    730,  // KConfigGroup::isEntryImmutable(const QString&) const
    731,  // KConfigGroup::isEntryImmutable(const char*) const
    0,
    748,  // KConfigGroup::readEntry(const QString&) const
    749,  // KConfigGroup::readEntry(const char*) const
    0,
    689,  // KConfigGroup::readEntry(const QString&, const QVariant&) const
    690,  // KConfigGroup::readEntry(const char*, const QVariant&) const
    0,
    691,  // KConfigGroup::readEntry(const QString&, const QString&) const
    692,  // KConfigGroup::readEntry(const char*, const QString&) const
    693,  // KConfigGroup::readEntry(const QString&, const char*) const
    694,  // KConfigGroup::readEntry(const char*, const char*) const
    0,
    695,  // KConfigGroup::readEntry(const QString&, const QList<QVariant>&) const
    696,  // KConfigGroup::readEntry(const char*, const QList<QVariant>&) const
    697,  // KConfigGroup::readEntry(const QString&, const QStringList&) const
    698,  // KConfigGroup::readEntry(const char*, const QStringList&) const
    0,
    752,  // KConfigGroup::readEntryUntranslated(const QString&) const
    753,  // KConfigGroup::readEntryUntranslated(const char*) const
    0,
    705,  // KConfigGroup::readEntryUntranslated(const QString&, const QString&) const
    706,  // KConfigGroup::readEntryUntranslated(const char*, const QString&) const
    0,
    701,  // KConfigGroup::readPathEntry(const QString&, const QString&) const
    702,  // KConfigGroup::readPathEntry(const char*, const QString&) const
    0,
    703,  // KConfigGroup::readPathEntry(const QString&, const QStringList&) const
    704,  // KConfigGroup::readPathEntry(const char*, const QStringList&) const
    0,
    750,  // KConfigGroup::readXdgListEntry(const QString&) const
    751,  // KConfigGroup::readXdgListEntry(const char*) const
    0,
    699,  // KConfigGroup::readXdgListEntry(const QString&, const QStringList&) const
    700,  // KConfigGroup::readXdgListEntry(const char*, const QStringList&) const
    0,
    732,  // KConfigGroup::revertToDefault(const QString&)
    733,  // KConfigGroup::revertToDefault(const char*)
    0,
    754,  // KConfigGroup::writeEntry(const QString&, const QVariant&)
    755,  // KConfigGroup::writeEntry(const char*, const QVariant&)
    758,  // KConfigGroup::writeEntry(const QString&, const QByteArray&)
    759,  // KConfigGroup::writeEntry(const char*, const QByteArray&)
    0,
    707,  // KConfigGroup::writeEntry(const QString&, const QVariant&, QFlags<KConfigBase::WriteConfigFlag>)
    708,  // KConfigGroup::writeEntry(const char*, const QVariant&, QFlags<KConfigBase::WriteConfigFlag>)
    711,  // KConfigGroup::writeEntry(const QString&, const QByteArray&, QFlags<KConfigBase::WriteConfigFlag>)
    712,  // KConfigGroup::writeEntry(const char*, const QByteArray&, QFlags<KConfigBase::WriteConfigFlag>)
    0,
    756,  // KConfigGroup::writeEntry(const QString&, const QString&)
    757,  // KConfigGroup::writeEntry(const char*, const QString&)
    760,  // KConfigGroup::writeEntry(const QString&, const char*)
    761,  // KConfigGroup::writeEntry(const char*, const char*)
    0,
    709,  // KConfigGroup::writeEntry(const QString&, const QString&, QFlags<KConfigBase::WriteConfigFlag>)
    710,  // KConfigGroup::writeEntry(const char*, const QString&, QFlags<KConfigBase::WriteConfigFlag>)
    713,  // KConfigGroup::writeEntry(const QString&, const char*, QFlags<KConfigBase::WriteConfigFlag>)
    714,  // KConfigGroup::writeEntry(const char*, const char*, QFlags<KConfigBase::WriteConfigFlag>)
    0,
    762,  // KConfigGroup::writeEntry(const QString&, const QStringList&)
    763,  // KConfigGroup::writeEntry(const char*, const QStringList&)
    764,  // KConfigGroup::writeEntry(const QString&, const QList<QVariant>&)
    765,  // KConfigGroup::writeEntry(const char*, const QList<QVariant>&)
    0,
    715,  // KConfigGroup::writeEntry(const QString&, const QStringList&, QFlags<KConfigBase::WriteConfigFlag>)
    716,  // KConfigGroup::writeEntry(const char*, const QStringList&, QFlags<KConfigBase::WriteConfigFlag>)
    717,  // KConfigGroup::writeEntry(const QString&, const QList<QVariant>&, QFlags<KConfigBase::WriteConfigFlag>)
    718,  // KConfigGroup::writeEntry(const char*, const QList<QVariant>&, QFlags<KConfigBase::WriteConfigFlag>)
    0,
    768,  // KConfigGroup::writePathEntry(const QString&, const QString&)
    769,  // KConfigGroup::writePathEntry(const char*, const QString&)
    0,
    721,  // KConfigGroup::writePathEntry(const QString&, const QString&, QFlags<KConfigBase::WriteConfigFlag>)
    722,  // KConfigGroup::writePathEntry(const char*, const QString&, QFlags<KConfigBase::WriteConfigFlag>)
    0,
    770,  // KConfigGroup::writePathEntry(const QString&, const QStringList&)
    771,  // KConfigGroup::writePathEntry(const char*, const QStringList&)
    0,
    723,  // KConfigGroup::writePathEntry(const QString&, const QStringList&, QFlags<KConfigBase::WriteConfigFlag>)
    724,  // KConfigGroup::writePathEntry(const char*, const QStringList&, QFlags<KConfigBase::WriteConfigFlag>)
    0,
    766,  // KConfigGroup::writeXdgListEntry(const QString&, const QStringList&)
    767,  // KConfigGroup::writeXdgListEntry(const char*, const QStringList&)
    0,
    719,  // KConfigGroup::writeXdgListEntry(const QString&, const QStringList&, QFlags<KConfigBase::WriteConfigFlag>)
    720,  // KConfigGroup::writeXdgListEntry(const char*, const QStringList&, QFlags<KConfigBase::WriteConfigFlag>)
    0,
    1473,  // KGlobal::staticQString(const QString&)
    1485,  // KGlobal::staticQString(const char*)
    0,
    2083,  // KMacroExpander::expandMacros(const QString&, const QHash<QChar,QString>&)
    2089,  // KMacroExpander::expandMacros(const QString&, const QHash<QChar,QStringList>&)
    2093,  // KMacroExpander::expandMacros(const QString&, const QHash<QString,QStringList>&)
    2095,  // KMacroExpander::expandMacros(const QString&, const QHash<QString,QString>&)
    0,
    2082,  // KMacroExpander::expandMacros(const QString&, const QHash<QChar,QString>&, QChar)
    2088,  // KMacroExpander::expandMacros(const QString&, const QHash<QChar,QStringList>&, QChar)
    2092,  // KMacroExpander::expandMacros(const QString&, const QHash<QString,QStringList>&, QChar)
    2094,  // KMacroExpander::expandMacros(const QString&, const QHash<QString,QString>&, QChar)
    0,
    2085,  // KMacroExpander::expandMacrosShellQuote(const QString&, const QHash<QChar,QString>&)
    2087,  // KMacroExpander::expandMacrosShellQuote(const QString&, const QHash<QString,QStringList>&)
    2091,  // KMacroExpander::expandMacrosShellQuote(const QString&, const QHash<QString,QString>&)
    2097,  // KMacroExpander::expandMacrosShellQuote(const QString&, const QHash<QChar,QStringList>&)
    0,
    2084,  // KMacroExpander::expandMacrosShellQuote(const QString&, const QHash<QChar,QString>&, QChar)
    2086,  // KMacroExpander::expandMacrosShellQuote(const QString&, const QHash<QString,QStringList>&, QChar)
    2090,  // KMacroExpander::expandMacrosShellQuote(const QString&, const QHash<QString,QString>&, QChar)
    2096,  // KMacroExpander::expandMacrosShellQuote(const QString&, const QHash<QChar,QStringList>&, QChar)
    0,
    512,  // KCmdLineOptions::add(const KCmdLineOptions&)
    513,  // KCmdLineOptions::add(const QByteArray&)
    0,
    1177,  // KDateTime::KDateTime(const QDateTime&)
    1178,  // KDateTime::KDateTime(const KDateTime&)
    1240,  // KDateTime::KDateTime(const QDate&)
    0,
    1174,  // KDateTime::KDateTime(const QDate&, const KDateTime::Spec&)
    1176,  // KDateTime::KDateTime(const QDateTime&, const KDateTime::Spec&)
    1241,  // KDateTime::KDateTime(const QDate&, const QTime&)
    0,
    1244,  // KDateTime::fromString(const QString&, KDateTime::TimeFormat)
    1245,  // KDateTime::fromString(const QString&, const QString&)
    0,
    1224,  // KDateTime::toString(const QString&) const
    1225,  // KDateTime::toString(KDateTime::TimeFormat) const
    0,
    1201,  // KDateTime::toTimeSpec(const KDateTime::Spec&) const
    1202,  // KDateTime::toTimeSpec(const KDateTime&) const
    0,
    841,  // KCoreConfigSkeleton::config()
    842,  // KCoreConfigSkeleton::config() const
    0,
    847,  // KCoreConfigSkeleton::findItem(const QString&)
    848,  // KCoreConfigSkeleton::findItem(const QString&) const
    0,
    845,  // KCoreConfigSkeleton::isImmutable(const QString&)
    846,  // KCoreConfigSkeleton::isImmutable(const QString&) const
    0,
    604,  // KConfig::KConfig(KConfigPrivate&)
    608,  // KConfig::KConfig(const KComponentData&)
    0,
    607,  // KConfig::KConfig(const QString&, QFlags<KConfig::OpenFlag>)
    611,  // KConfig::KConfig(const QString&, const QString&)
    0,
    576,  // KConfig::KConfig(const QString&, QFlags<KConfig::OpenFlag>, const char*)
    578,  // KConfig::KConfig(const QString&, const QString&, const char*)
    0,
    600,  // KConfig::groupImpl(const QByteArray&)
    601,  // KConfig::groupImpl(const QByteArray&) const
    0,
    1860,  // KLocale::formatDateTime(const QDateTime&) const
    1862,  // KLocale::formatDateTime(const KDateTime&) const
    0,
    1861,  // KLocale::formatDateTime(const QDateTime&, KLocale::DateFormat) const
    1863,  // KLocale::formatDateTime(const KDateTime&, KLocale::DateFormat) const
    0,
    1752,  // KLocale::formatDateTime(const QDateTime&, KLocale::DateFormat, bool) const
    1753,  // KLocale::formatDateTime(const KDateTime&, KLocale::DateFormat, QFlags<KLocale::DateTimeFormatOption>) const
    0,
    1854,  // KLocale::formatNumber(double) const
    1855,  // KLocale::formatNumber(const QString&) const
    0,
    1741,  // KLocale::formatNumber(double, int) const
    1856,  // KLocale::formatNumber(const QString&, bool) const
    0,
    1774,  // KLocale::readDate(const QString&, bool*) const
    1871,  // KLocale::readDate(const QString&, const QString&) const
    1872,  // KLocale::readDate(const QString&, KLocale::ReadDateFlags) const
    0,
    1775,  // KLocale::readDate(const QString&, const QString&, bool*) const
    1776,  // KLocale::readDate(const QString&, KLocale::ReadDateFlags, bool*) const
    0,
    1777,  // KLocale::readTime(const QString&, bool*) const
    1874,  // KLocale::readTime(const QString&, KLocale::ReadTimeFlags) const
    0,
    1770,  // KLocale::weekNumberSystem()
    1771,  // KLocale::weekNumberSystem() const
    0,
    3533,  // Sonnet::BackgroundChecker::BackgroundChecker(QObject*)
    3557,  // Sonnet::BackgroundChecker::BackgroundChecker(const Sonnet::Speller&)
    0,
    2192,  // KPluginFactory::KPluginFactory(QObject*)
    2209,  // KPluginFactory::KPluginFactory(const KAboutData&)
    2210,  // KPluginFactory::KPluginFactory(const KAboutData*)
    2214,  // KPluginFactory::KPluginFactory(KPluginFactoryPrivate&)
    0,
    2190,  // KPluginFactory::KPluginFactory(const KAboutData&, QObject*)
    2191,  // KPluginFactory::KPluginFactory(const KAboutData*, QObject*)
    2196,  // KPluginFactory::KPluginFactory(KPluginFactoryPrivate&, QObject*)
    0,
    2577,  // KServiceType::KServiceType(KDesktopFile*)
    2592,  // KServiceType::KServiceType(KServiceTypePrivate&)
    0,
    650,  // KConfigBase::deleteGroup(const QString&)
    651,  // KConfigBase::deleteGroup(const char*)
    0,
    633,  // KConfigBase::deleteGroup(const QString&, QFlags<KConfigBase::WriteConfigFlag>)
    634,  // KConfigBase::deleteGroup(const char*, QFlags<KConfigBase::WriteConfigFlag>)
    0,
    626,  // KConfigBase::group(const QByteArray&)
    629,  // KConfigBase::group(const QByteArray&) const
    0,
    627,  // KConfigBase::group(const QString&)
    628,  // KConfigBase::group(const char*)
    630,  // KConfigBase::group(const QString&) const
    631,  // KConfigBase::group(const char*) const
    0,
    644,  // KConfigBase::groupImpl(const QByteArray&)
    645,  // KConfigBase::groupImpl(const QByteArray&) const
    0,
    623,  // KConfigBase::hasGroup(const QString&) const
    624,  // KConfigBase::hasGroup(const char*) const
    0,
    640,  // KConfigBase::isGroupImmutable(const QString&) const
    641,  // KConfigBase::isGroupImmutable(const char*) const
    0,
    2098,  // KMacroExpanderBase::KMacroExpanderBase(QChar)
    2106,  // KMacroExpanderBase::KMacroExpanderBase(const KMacroExpanderBase&)
    0,
    1325,  // KDesktopFile::actionGroup(const QString&)
    1326,  // KDesktopFile::actionGroup(const QString&) const
    0,
    440,  // KCharMacroExpander::KCharMacroExpander(QChar)
    444,  // KCharMacroExpander::KCharMacroExpander(const KCharMacroExpander&)
    0,
    2164,  // KMimeType::findByContent(const QByteArray&)
    2167,  // KMimeType::findByContent(QIODevice*)
    0,
    2129,  // KMimeType::findByContent(const QByteArray&, int*)
    2131,  // KMimeType::findByContent(QIODevice*, int*)
    0,
    2165,  // KMimeType::findByNameAndContent(const QString&, const QByteArray&)
    2168,  // KMimeType::findByNameAndContent(const QString&, QIODevice*)
    0,
    2166,  // KMimeType::findByNameAndContent(const QString&, const QByteArray&, mode_t)
    2169,  // KMimeType::findByNameAndContent(const QString&, QIODevice*, mode_t)
    0,
    2130,  // KMimeType::findByNameAndContent(const QString&, const QByteArray&, mode_t, int*)
    2132,  // KMimeType::findByNameAndContent(const QString&, QIODevice*, mode_t, int*)
    0,
    288,  // KCalendarSystem::KCalendarSystem(const KLocale*)
    427,  // KCalendarSystem::KCalendarSystem(KCalendarSystemPrivate&)
    0,
    283,  // KCalendarSystem::calendarLabel(const QString&)
    393,  // KCalendarSystem::calendarLabel(KLocale::CalendarSystem)
    0,
    389,  // KCalendarSystem::create(const QString&)
    391,  // KCalendarSystem::create(KLocale::CalendarSystem)
    0,
    277,  // KCalendarSystem::create(const QString&, const KLocale*)
    279,  // KCalendarSystem::create(KLocale::CalendarSystem, const KLocale*)
    0,
    390,  // KCalendarSystem::create(const QString&, KSharedPtr<KSharedConfig>)
    392,  // KCalendarSystem::create(KLocale::CalendarSystem, KSharedPtr<KSharedConfig>)
    0,
    278,  // KCalendarSystem::create(const QString&, KSharedPtr<KSharedConfig>, const KLocale*)
    280,  // KCalendarSystem::create(KLocale::CalendarSystem, KSharedPtr<KSharedConfig>, const KLocale*)
    0,
    365,  // KCalendarSystem::formatDate(const QDate&, KLocale::DateFormat) const
    420,  // KCalendarSystem::formatDate(const QDate&, const QString&) const
    422,  // KCalendarSystem::formatDate(const QDate&, KLocale::DateTimeComponent) const
    0,
    366,  // KCalendarSystem::formatDate(const QDate&, const QString&, KLocale::DateTimeFormatStandard) const
    421,  // KCalendarSystem::formatDate(const QDate&, const QString&, KLocale::DigitSet) const
    423,  // KCalendarSystem::formatDate(const QDate&, KLocale::DateTimeComponent, KLocale::DateTimeComponentFormat) const
    0,
    367,  // KCalendarSystem::formatDate(const QDate&, const QString&, KLocale::DigitSet, KLocale::DateTimeFormatStandard) const
    368,  // KCalendarSystem::formatDate(const QDate&, KLocale::DateTimeComponent, KLocale::DateTimeComponentFormat, KLocale::WeekNumberSystem) const
    0,
    369,  // KCalendarSystem::readDate(const QString&, bool*) const
    425,  // KCalendarSystem::readDate(const QString&, KLocale::ReadDateFlags) const
    426,  // KCalendarSystem::readDate(const QString&, const QString&) const
    0,
    370,  // KCalendarSystem::readDate(const QString&, KLocale::ReadDateFlags, bool*) const
    371,  // KCalendarSystem::readDate(const QString&, const QString&, bool*) const
    0,
    334,  // KCalendarSystem::week(const QDate&, int*) const
    400,  // KCalendarSystem::week(const QDate&, KLocale::WeekNumberSystem) const
    0,
    533,  // KComponentData::KComponentData(const KComponentData&)
    548,  // KComponentData::KComponentData(const QByteArray&)
    550,  // KComponentData::KComponentData(const KAboutData&)
    551,  // KComponentData::KComponentData(const KAboutData*)
    0,
    538,  // KComponentData::KComponentData(const KAboutData&, KComponentData::MainComponentRegistration)
    539,  // KComponentData::KComponentData(const KAboutData*, KComponentData::MainComponentRegistration)
    0,
    2017,  // KLocalizedString::subs(int) const
    2020,  // KLocalizedString::subs(unsigned int) const
    2023,  // KLocalizedString::subs(long) const
    2026,  // KLocalizedString::subs(unsigned long) const
    2029,  // KLocalizedString::subs(long long) const
    2032,  // KLocalizedString::subs(unsigned long long) const
    2035,  // KLocalizedString::subs(double) const
    2041,  // KLocalizedString::subs(const QString&) const
    0,
    2018,  // KLocalizedString::subs(int, int) const
    2021,  // KLocalizedString::subs(unsigned int, int) const
    2024,  // KLocalizedString::subs(long, int) const
    2027,  // KLocalizedString::subs(unsigned long, int) const
    2030,  // KLocalizedString::subs(long long, int) const
    2033,  // KLocalizedString::subs(unsigned long long, int) const
    2036,  // KLocalizedString::subs(double, int) const
    2042,  // KLocalizedString::subs(const QString&, int) const
    0,
    2019,  // KLocalizedString::subs(int, int, int) const
    2022,  // KLocalizedString::subs(unsigned int, int, int) const
    2025,  // KLocalizedString::subs(long, int, int) const
    2028,  // KLocalizedString::subs(unsigned long, int, int) const
    2031,  // KLocalizedString::subs(long long, int, int) const
    2034,  // KLocalizedString::subs(unsigned long long, int, int) const
    2037,  // KLocalizedString::subs(double, int, char) const
    0,
    2006,  // KLocalizedString::subs(int, int, int, const QChar&) const
    2007,  // KLocalizedString::subs(unsigned int, int, int, const QChar&) const
    2008,  // KLocalizedString::subs(long, int, int, const QChar&) const
    2009,  // KLocalizedString::subs(unsigned long, int, int, const QChar&) const
    2010,  // KLocalizedString::subs(long long, int, int, const QChar&) const
    2011,  // KLocalizedString::subs(unsigned long long, int, int, const QChar&) const
    0,
    218,  // KAutoSaveFile::KAutoSaveFile(QObject*)
    227,  // KAutoSaveFile::KAutoSaveFile(const KUrl&)
    0,
    3433,  // QGlobalSpace::operator!=(const QDBusSignature&, const QDBusSignature&)
    3437,  // QGlobalSpace::operator!=(const QDBusObjectPath&, const QDBusObjectPath&)
    3440,  // QGlobalSpace::operator!=(const QLatin1String&, const QLatin1String&)
    0,
    3383,  // QGlobalSpace::operator+(const QString&, const char*)
    3385,  // QGlobalSpace::operator+(const char*, const QString&)
    3404,  // QGlobalSpace::operator+(const QString&, char)
    3428,  // QGlobalSpace::operator+(char, const QString&)
    0,
    3373,  // QGlobalSpace::operator<(const QDBusSignature&, const QDBusSignature&)
    3442,  // QGlobalSpace::operator<(const QDBusObjectPath&, const QDBusObjectPath&)
    3452,  // QGlobalSpace::operator<(const QLatin1String&, const QLatin1String&)
    0,
    3364,  // QGlobalSpace::operator<<(QDataStream&, const KServiceAction&)
    3431,  // QGlobalSpace::operator<<(QDataStream&, const KProtocolInfo::ExtraField&)
    0,
    3375,  // QGlobalSpace::operator==(const QDBusSignature&, const QDBusSignature&)
    3391,  // QGlobalSpace::operator==(const QDBusObjectPath&, const QDBusObjectPath&)
    3429,  // QGlobalSpace::operator==(const QLatin1String&, const QLatin1String&)
    0,
    3371,  // QGlobalSpace::operator>>(QDataStream&, KServiceAction&)
    3450,  // QGlobalSpace::operator>>(QDataStream&, KProtocolInfo::ExtraField&)
    0,
    3360,  // QGlobalSpace::operator|(KAutostart::Condition, QFlags<KAutostart::Condition>)
    3361,  // QGlobalSpace::operator|(KAutostart::Condition, KAutostart::Condition)
    3362,  // QGlobalSpace::operator|(KLocale::DateTimeFormatOption, KLocale::DateTimeFormatOption)
    3363,  // QGlobalSpace::operator|(KCurrencyCode::CurrencyStatus, QFlags<KCurrencyCode::CurrencyStatus>)
    3366,  // QGlobalSpace::operator|(KLocale::TimeFormatOption, QFlags<KLocale::TimeFormatOption>)
    3367,  // QGlobalSpace::operator|(KUrl::CleanPathOption, QFlags<KUrl::CleanPathOption>)
    3368,  // QGlobalSpace::operator|(KUrl::CleanPathOption, KUrl::CleanPathOption)
    3369,  // QGlobalSpace::operator|(KConfigBase::WriteConfigFlag, int)
    3370,  // QGlobalSpace::operator|(KJob::Capability, KJob::Capability)
    3374,  // QGlobalSpace::operator|(KUrl::QueryItemsOption, int)
    3376,  // QGlobalSpace::operator|(KUrl::EncodedPathAndQueryOption, KUrl::EncodedPathAndQueryOption)
    3377,  // QGlobalSpace::operator|(KConfig::OpenFlag, QFlags<KConfig::OpenFlag>)
    3380,  // QGlobalSpace::operator|(KUrl::DirectoryOption, KUrl::DirectoryOption)
    3382,  // QGlobalSpace::operator|(KUrl::DirectoryOption, QFlags<KUrl::DirectoryOption>)
    3384,  // QGlobalSpace::operator|(KCmdLineArgs::StdCmdLineArg, QFlags<KCmdLineArgs::StdCmdLineArg>)
    3386,  // QGlobalSpace::operator|(KShell::Option, KShell::Option)
    3387,  // QGlobalSpace::operator|(KLockFile::LockFlag, int)
    3388,  // QGlobalSpace::operator|(KLocale::DateTimeComponent, QFlags<KLocale::DateTimeComponent>)
    3393,  // QGlobalSpace::operator|(KCmdLineArgs::StdCmdLineArg, int)
    3394,  // QGlobalSpace::operator|(KLocale::DateTimeFormatOption, int)
    3395,  // QGlobalSpace::operator|(KUrl::EncodedPathAndQueryOption, int)
    3396,  // QGlobalSpace::operator|(KShell::Option, int)
    3399,  // QGlobalSpace::operator|(KShell::Option, QFlags<KShell::Option>)
    3400,  // QGlobalSpace::operator|(KStandardDirs::SearchOption, QFlags<KStandardDirs::SearchOption>)
    3401,  // QGlobalSpace::operator|(KAutostart::Condition, int)
    3402,  // QGlobalSpace::operator|(KCurrencyCode::CurrencyStatus, KCurrencyCode::CurrencyStatus)
    3405,  // QGlobalSpace::operator|(KStandardDirs::SearchOption, KStandardDirs::SearchOption)
    3407,  // QGlobalSpace::operator|(KJob::Capability, int)
    3408,  // QGlobalSpace::operator|(KLocale::TimeProcessingOption, KLocale::TimeProcessingOption)
    3410,  // QGlobalSpace::operator|(KUrl::EqualsOption, KUrl::EqualsOption)
    3412,  // QGlobalSpace::operator|(KUrl::CleanPathOption, int)
    3413,  // QGlobalSpace::operator|(KStandardDirs::SearchOption, int)
    3414,  // QGlobalSpace::operator|(KUrl::QueryItemsOption, KUrl::QueryItemsOption)
    3415,  // QGlobalSpace::operator|(KConfigBase::WriteConfigFlag, KConfigBase::WriteConfigFlag)
    3416,  // QGlobalSpace::operator|(KConfig::OpenFlag, int)
    3419,  // QGlobalSpace::operator|(KLocale::TimeFormatOption, KLocale::TimeFormatOption)
    3422,  // QGlobalSpace::operator|(KCurrencyCode::CurrencyStatus, int)
    3423,  // QGlobalSpace::operator|(KUrl::EqualsOption, int)
    3425,  // QGlobalSpace::operator|(KLocale::TimeProcessingOption, QFlags<KLocale::TimeProcessingOption>)
    3426,  // QGlobalSpace::operator|(KUrl::EqualsOption, QFlags<KUrl::EqualsOption>)
    3427,  // QGlobalSpace::operator|(KLocale::TimeProcessingOption, int)
    3432,  // QGlobalSpace::operator|(KLockFile::LockFlag, QFlags<KLockFile::LockFlag>)
    3435,  // QGlobalSpace::operator|(KLocale::DateTimeFormatOption, QFlags<KLocale::DateTimeFormatOption>)
    3436,  // QGlobalSpace::operator|(KUrl::QueryItemsOption, QFlags<KUrl::QueryItemsOption>)
    3438,  // QGlobalSpace::operator|(KUrl::DirectoryOption, int)
    3441,  // QGlobalSpace::operator|(KLocale::DateTimeComponent, KLocale::DateTimeComponent)
    3443,  // QGlobalSpace::operator|(KConfig::OpenFlag, KConfig::OpenFlag)
    3445,  // QGlobalSpace::operator|(KCmdLineArgs::StdCmdLineArg, KCmdLineArgs::StdCmdLineArg)
    3447,  // QGlobalSpace::operator|(KLocale::TimeFormatOption, int)
    3451,  // QGlobalSpace::operator|(KUrl::EncodedPathAndQueryOption, QFlags<KUrl::EncodedPathAndQueryOption>)
    3453,  // QGlobalSpace::operator|(KConfigBase::WriteConfigFlag, QFlags<KConfigBase::WriteConfigFlag>)
    3455,  // QGlobalSpace::operator|(KLocale::DateTimeComponent, int)
    3457,  // QGlobalSpace::operator|(KJob::Capability, QFlags<KJob::Capability>)
    3461,  // QGlobalSpace::operator|(KLockFile::LockFlag, KLockFile::LockFlag)
    0,
    3258,  // KWordMacroExpander::KWordMacroExpander(QChar)
    3262,  // KWordMacroExpander::KWordMacroExpander(const KWordMacroExpander&)
    0,
    147,  // KAuth::ActionReply::ActionReply(KAuth::ActionReply::Type)
    148,  // KAuth::ActionReply::ActionReply(int)
    0,
    2653,  // KStandardDirs::addResourceType(const char*, const QString&, bool)
    2689,  // KStandardDirs::addResourceType(const char*, const char*, const QString&)
    2690,  // KStandardDirs::addResourceType(const char*, const char*, const char*)
    0,
    2654,  // KStandardDirs::addResourceType(const char*, const char*, const QString&, bool)
    2655,  // KStandardDirs::addResourceType(const char*, const char*, const char*, bool)
    0,
    1296,  // KDebug::hasNullOutputQtDebugMsg(int)
    1304,  // KDebug::hasNullOutputQtDebugMsg(bool)
    0,
    1100,  // KCurrencyCode::KCurrencyCode(const KCurrencyCode&)
    1124,  // KCurrencyCode::KCurrencyCode(const QFileInfo&)
    0,
    1270,  // KDateTime::Spec::Spec(const KTimeZone&)
    1272,  // KDateTime::Spec::Spec(const KDateTime::Spec&)
    0,
};

// Class ID, munged name ID (index into methodNames), method def (see methods) if >0 or number of overloads if <0
static Smoke::MethodMap methodMaps[] = {
    {0, 0, 0},	//0 (no method)
    {1, 149, 85},	// KAboutData::FullName
    {1, 278, 2},	// KAboutData::KAboutData#
    {1, 279, 59},	// KAboutData::KAboutData####
    {1, 280, 60},	// KAboutData::KAboutData#####
    {1, 281, 61},	// KAboutData::KAboutData#####$
    {1, 282, 62},	// KAboutData::KAboutData#####$#
    {1, 283, 63},	// KAboutData::KAboutData#####$##
    {1, 284, 64},	// KAboutData::KAboutData#####$###
    {1, 285, 1},	// KAboutData::KAboutData#####$####
    {1, 572, 79},	// KAboutData::License_Artistic
    {1, 573, 78},	// KAboutData::License_BSD
    {1, 574, 71},	// KAboutData::License_Custom
    {1, 575, 72},	// KAboutData::License_File
    {1, 576, 74},	// KAboutData::License_GPL
    {1, 577, 75},	// KAboutData::License_GPL_V2
    {1, 578, 82},	// KAboutData::License_GPL_V3
    {1, 579, 76},	// KAboutData::License_LGPL
    {1, 580, 77},	// KAboutData::License_LGPL_V2
    {1, 581, 83},	// KAboutData::License_LGPL_V3
    {1, 582, 80},	// KAboutData::License_QPL
    {1, 583, 81},	// KAboutData::License_QPL_V1_0
    {1, 584, 73},	// KAboutData::License_Unknown
    {1, 711, 84},	// KAboutData::ShortName
    {1, 828, 48},	// KAboutData::aboutTranslationTeam
    {1, 849, 65},	// KAboutData::addAuthor#
    {1, 850, 66},	// KAboutData::addAuthor##
    {1, 851, 67},	// KAboutData::addAuthor###
    {1, 852, 4},	// KAboutData::addAuthor####
    {1, 853, 5},	// KAboutData::addAuthor#####
    {1, 862, 68},	// KAboutData::addCredit#
    {1, 863, 69},	// KAboutData::addCredit##
    {1, 864, 70},	// KAboutData::addCredit###
    {1, 865, 6},	// KAboutData::addCredit####
    {1, 866, 7},	// KAboutData::addCredit#####
    {1, 954, 22},	// KAboutData::addLicense$
    {1, 956, 10},	// KAboutData::addLicenseText#
    {1, 958, 12},	// KAboutData::addLicenseTextFile$
    {1, 1029, 29},	// KAboutData::appName
    {1, 1050, 45},	// KAboutData::authors
    {1, 1082, 43},	// KAboutData::bugAddress
    {1, 1112, 41},	// KAboutData::catalogName
    {1, 1197, 53},	// KAboutData::copyrightStatement
    {1, 1219, 46},	// KAboutData::credits
    {1, 1240, 54},	// KAboutData::customAuthorPlainText
    {1, 1241, 55},	// KAboutData::customAuthorRichText
    {1, 1242, 56},	// KAboutData::customAuthorTextEnabled
    {1, 1707, 42},	// KAboutData::homepage
    {1, 1747, 44},	// KAboutData::internalBugAddress
    {1, 1748, 33},	// KAboutData::internalProgramName
    {1, 1749, 39},	// KAboutData::internalVersion
    {1, 1970, 50},	// KAboutData::license
    {1, 1972, 51},	// KAboutData::licenseName$
    {1, 1973, 52},	// KAboutData::licenses
    {1, 2133, 37},	// KAboutData::ocsProviderUrl
    {1, 2183, 3},	// KAboutData::operator=#
    {1, 2205, 32},	// KAboutData::organizationDomain
    {1, 2206, 49},	// KAboutData::otherText
    {1, 2269, 30},	// KAboutData::productName
    {1, 2271, 35},	// KAboutData::programIconName
    {1, 2272, 36},	// KAboutData::programLogo
    {1, 2273, 31},	// KAboutData::programName
    {1, 2509, 13},	// KAboutData::setAppName#
    {1, 2530, 26},	// KAboutData::setBugAddress#
    {1, 2538, 20},	// KAboutData::setCatalogName#
    {1, 2550, 23},	// KAboutData::setCopyrightStatement#
    {1, 2562, 57},	// KAboutData::setCustomAuthorText##
    {1, 2659, 25},	// KAboutData::setHomepage#
    {1, 2685, 21},	// KAboutData::setLicense$
    {1, 2687, 9},	// KAboutData::setLicenseText#
    {1, 2689, 11},	// KAboutData::setLicenseTextFile$
    {1, 2793, 17},	// KAboutData::setOcsProvider#
    {1, 2795, 27},	// KAboutData::setOrganizationDomain#
    {1, 2799, 24},	// KAboutData::setOtherText#
    {1, 2832, 28},	// KAboutData::setProductName#
    {1, 2838, 15},	// KAboutData::setProgramIconName$
    {1, 2840, 16},	// KAboutData::setProgramLogo#
    {1, 2842, 14},	// KAboutData::setProgramName#
    {1, 2864, 19},	// KAboutData::setShortDescription#
    {1, 2903, 8},	// KAboutData::setTranslator##
    {1, 2913, 18},	// KAboutData::setVersion#
    {1, 2934, 40},	// KAboutData::shortDescription
    {1, 3159, 34},	// KAboutData::translateInternalProgramName
    {1, 3172, 47},	// KAboutData::translators
    {1, 3187, 58},	// KAboutData::unsetCustomAuthorText
    {1, 3234, 38},	// KAboutData::version
    {1, 3354, 86},	// KAboutData::~KAboutData
    {2, 287, 87},	// KAboutLicense::KAboutLicense#
    {2, 1084, 92},	// KAboutLicense::byKeyword$
    {2, 1924, 91},	// KAboutLicense::key
    {2, 2103, 90},	// KAboutLicense::name$
    {2, 2183, 88},	// KAboutLicense::operator=#
    {2, 3091, 89},	// KAboutLicense::text
    {2, 3355, 93},	// KAboutLicense::~KAboutLicense
    {3, 289, -33},	// KAboutPerson::KAboutPerson#
    {3, 290, 104},	// KAboutPerson::KAboutPerson##
    {3, 291, 105},	// KAboutPerson::KAboutPerson###
    {3, 292, 94},	// KAboutPerson::KAboutPerson####
    {3, 293, 95},	// KAboutPerson::KAboutPerson#####
    {3, 1391, 100},	// KAboutPerson::emailAddress
    {3, 2102, 98},	// KAboutPerson::name
    {3, 2134, 102},	// KAboutPerson::ocsUsername
    {3, 2183, 97},	// KAboutPerson::operator=#
    {3, 3085, 99},	// KAboutPerson::task
    {3, 3253, 101},	// KAboutPerson::webAddress
    {3, 3356, 106},	// KAboutPerson::~KAboutPerson
    {4, 4, 107},	// KAuth::Action::Action
    {4, 5, 108},	// KAuth::Action::Action#
    {4, 6, 109},	// KAuth::Action::Action$
    {4, 7, 110},	// KAuth::Action::Action$$
    {4, 27, 143},	// KAuth::Action::AuthRequired
    {4, 30, 142},	// KAuth::Action::Authorized
    {4, 101, 139},	// KAuth::Action::Denied
    {4, 125, 140},	// KAuth::Action::Error
    {4, 177, 141},	// KAuth::Action::Invalid
    {4, 801, 144},	// KAuth::Action::UserCancelled
    {4, 847, 125},	// KAuth::Action::addArgument$#
    {4, 1037, 124},	// KAuth::Action::arguments
    {4, 1040, 126},	// KAuth::Action::authorize
    {4, 1357, 117},	// KAuth::Action::details
    {4, 1389, 127},	// KAuth::Action::earlyAuthorize
    {4, 1451, 129},	// KAuth::Action::execute
    {4, 1452, 130},	// KAuth::Action::execute$
    {4, 1458, 133},	// KAuth::Action::executeActions??$
    {4, 1459, 134},	// KAuth::Action::executeActions??$#
    {4, 1460, 132},	// KAuth::Action::executesAsync
    {4, 1674, 121},	// KAuth::Action::hasHelper
    {4, 1703, 119},	// KAuth::Action::helperID
    {4, 1871, 118},	// KAuth::Action::isValid
    {4, 2102, 114},	// KAuth::Action::name
    {4, 2159, 113},	// KAuth::Action::operator!=#
    {4, 2183, 111},	// KAuth::Action::operator=#
    {4, 2186, 112},	// KAuth::Action::operator==#
    {4, 2218, 138},	// KAuth::Action::parentWidget
    {4, 2511, 123},	// KAuth::Action::setArguments?
    {4, 2603, 116},	// KAuth::Action::setDetails$
    {4, 2636, 131},	// KAuth::Action::setExecutesAsync$
    {4, 2657, 120},	// KAuth::Action::setHelperID$
    {4, 2783, 115},	// KAuth::Action::setName$
    {4, 2807, 137},	// KAuth::Action::setParentWidget#
    {4, 3033, 128},	// KAuth::Action::status
    {4, 3036, 135},	// KAuth::Action::stop
    {4, 3037, 136},	// KAuth::Action::stop$
    {4, 3251, 122},	// KAuth::Action::watcher
    {4, 3327, 145},	// KAuth::Action::~Action
    {5, 8, 146},	// KAuth::ActionReply::ActionReply
    {5, 9, 149},	// KAuth::ActionReply::ActionReply#
    {5, 10, -506},	// KAuth::ActionReply::ActionReply$
    {5, 28, 181},	// KAuth::ActionReply::AuthorizationDenied
    {5, 29, 170},	// KAuth::ActionReply::AuthorizationDeniedReply
    {5, 76, 184},	// KAuth::ActionReply::DBusError
    {5, 77, 173},	// KAuth::ActionReply::DBusErrorReply
    {5, 158, 183},	// KAuth::ActionReply::HelperBusy
    {5, 159, 172},	// KAuth::ActionReply::HelperBusyReply
    {5, 160, 175},	// KAuth::ActionReply::HelperError
    {5, 161, 166},	// KAuth::ActionReply::HelperErrorReply
    {5, 178, 180},	// KAuth::ActionReply::InvalidAction
    {5, 179, 169},	// KAuth::ActionReply::InvalidActionReply
    {5, 294, 174},	// KAuth::ActionReply::KAuthError
    {5, 623, 177},	// KAuth::ActionReply::NoError
    {5, 627, 178},	// KAuth::ActionReply::NoResponder
    {5, 628, 167},	// KAuth::ActionReply::NoResponderReply
    {5, 630, 179},	// KAuth::ActionReply::NoSuchAction
    {5, 631, 168},	// KAuth::ActionReply::NoSuchActionReply
    {5, 740, 176},	// KAuth::ActionReply::Success
    {5, 741, 165},	// KAuth::ActionReply::SuccessReply
    {5, 801, 182},	// KAuth::ActionReply::UserCancelled
    {5, 802, 171},	// KAuth::ActionReply::UserCancelledReply
    {5, 870, 152},	// KAuth::ActionReply::addData$#
    {5, 1245, 151},	// KAuth::ActionReply::data
    {5, 1352, 161},	// KAuth::ActionReply::deserialize#
    {5, 1435, 156},	// KAuth::ActionReply::errorCode
    {5, 1436, 158},	// KAuth::ActionReply::errorDescription
    {5, 1488, 155},	// KAuth::ActionReply::failed
    {5, 2159, 164},	// KAuth::ActionReply::operator!=#
    {5, 2183, 162},	// KAuth::ActionReply::operator=#
    {5, 2186, 163},	// KAuth::ActionReply::operator==#
    {5, 2477, 160},	// KAuth::ActionReply::serialized
    {5, 2568, 150},	// KAuth::ActionReply::setData?
    {5, 2624, 157},	// KAuth::ActionReply::setErrorCode$
    {5, 2626, 159},	// KAuth::ActionReply::setErrorDescription$
    {5, 3059, 154},	// KAuth::ActionReply::succeeded
    {5, 3174, 153},	// KAuth::ActionReply::type
    {5, 3328, 185},	// KAuth::ActionReply::~ActionReply
    {6, 834, 194},	// KAuth::ActionWatcher::action
    {6, 838, 196},	// KAuth::ActionWatcher::actionPerformed#
    {6, 839, 195},	// KAuth::ActionWatcher::actionStarted
    {6, 2060, 186},	// KAuth::ActionWatcher::metaObject
    {6, 2275, 197},	// KAuth::ActionWatcher::progressStep$
    {6, 2276, 198},	// KAuth::ActionWatcher::progressStep?
    {6, 2300, 192},	// KAuth::ActionWatcher::qt_metacall$$?
    {6, 2302, 187},	// KAuth::ActionWatcher::qt_metacast$
    {6, 3030, 202},	// KAuth::ActionWatcher::staticMetaObject
    {6, 3035, 199},	// KAuth::ActionWatcher::statusChanged$
    {6, 3132, 200},	// KAuth::ActionWatcher::tr$
    {6, 3133, 188},	// KAuth::ActionWatcher::tr$$
    {6, 3134, 190},	// KAuth::ActionWatcher::tr$$$
    {6, 3139, 201},	// KAuth::ActionWatcher::trUtf8$
    {6, 3140, 189},	// KAuth::ActionWatcher::trUtf8$$
    {6, 3141, 191},	// KAuth::ActionWatcher::trUtf8$$$
    {6, 3252, 193},	// KAuth::ActionWatcher::watcher$
    {6, 3329, 203},	// KAuth::ActionWatcher::~ActionWatcher
    {7, 1025, 204},	// KAuthorized::allowUrlAction$##
    {7, 1041, 207},	// KAuthorized::authorize$
    {7, 1043, 205},	// KAuthorized::authorizeControlModule$
    {7, 1045, 206},	// KAuthorized::authorizeControlModules?
    {7, 1047, 208},	// KAuthorized::authorizeKAction$
    {7, 1049, 209},	// KAuthorized::authorizeUrlAction$##
    {8, 295, 228},	// KAutoSaveFile::KAutoSaveFile
    {8, 296, -422},	// KAutoSaveFile::KAutoSaveFile#
    {8, 297, 217},	// KAutoSaveFile::KAutoSaveFile##
    {8, 1016, 230},	// KAutoSaveFile::allStaleFiles
    {8, 1017, 224},	// KAutoSaveFile::allStaleFiles$
    {8, 2045, 219},	// KAutoSaveFile::managedFile
    {8, 2060, 210},	// KAutoSaveFile::metaObject
    {8, 2146, 222},	// KAutoSaveFile::open$
    {8, 2300, 216},	// KAutoSaveFile::qt_metacall$$?
    {8, 2302, 211},	// KAutoSaveFile::qt_metacast$
    {8, 2410, 221},	// KAutoSaveFile::releaseLock
    {8, 2755, 220},	// KAutoSaveFile::setManagedFile#
    {8, 2969, 229},	// KAutoSaveFile::staleFiles#
    {8, 2970, 223},	// KAutoSaveFile::staleFiles#$
    {8, 3030, 231},	// KAutoSaveFile::staticMetaObject
    {8, 3132, 225},	// KAutoSaveFile::tr$
    {8, 3133, 212},	// KAutoSaveFile::tr$$
    {8, 3134, 214},	// KAutoSaveFile::tr$$$
    {8, 3139, 226},	// KAutoSaveFile::trUtf8$
    {8, 3140, 213},	// KAutoSaveFile::trUtf8$$
    {8, 3141, 215},	// KAutoSaveFile::trUtf8$$$
    {8, 3357, 232},	// KAutoSaveFile::~KAutoSaveFile
    {9, 21, 275},	// KAutostart::Applications
    {9, 40, 273},	// KAutostart::BaseDesktop
    {9, 50, 272},	// KAutostart::CheckAll
    {9, 51, 270},	// KAutostart::CheckCommand
    {9, 52, 271},	// KAutostart::CheckCondition
    {9, 102, 274},	// KAutostart::DesktopServices
    {9, 298, 264},	// KAutostart::KAutostart
    {9, 299, 265},	// KAutostart::KAutostart$
    {9, 300, 240},	// KAutostart::KAutostart$#
    {9, 621, 269},	// KAutostart::NoConditions
    {9, 985, 254},	// KAutostart::addToAllowedEnvironments$
    {9, 987, 258},	// KAutostart::addToExcludedEnvironments$
    {9, 1026, 252},	// KAutostart::allowedEnvironments
    {9, 1058, 266},	// KAutostart::autostarts
    {9, 1059, 267},	// KAutostart::autostarts$
    {9, 1060, 242},	// KAutostart::autostarts$$
    {9, 1125, 261},	// KAutostart::checkAllowedEnvironment$
    {9, 1157, 243},	// KAutostart::command
    {9, 1158, 248},	// KAutostart::commandToCheck
    {9, 1445, 256},	// KAutostart::excludedEnvironments
    {9, 1857, 247},	// KAutostart::isServiceRegistered$
    {9, 2060, 233},	// KAutostart::metaObject
    {9, 2300, 239},	// KAutostart::qt_metacall$$?
    {9, 2302, 234},	// KAutostart::qt_metacast$
    {9, 2421, 255},	// KAutostart::removeFromAllowedEnvironments$
    {9, 2423, 259},	// KAutostart::removeFromExcludedEnvironments$
    {9, 2507, 253},	// KAutostart::setAllowedEnvironments?
    {9, 2526, 241},	// KAutostart::setAutostarts$
    {9, 2540, 244},	// KAutostart::setCommand$
    {9, 2542, 249},	// KAutostart::setCommandToCheck$
    {9, 2632, 257},	// KAutostart::setExcludedEnvironments?
    {9, 2877, 251},	// KAutostart::setStartPhase$
    {9, 2915, 246},	// KAutostart::setVisibleName$
    {9, 2973, 260},	// KAutostart::startAfter
    {9, 2979, 250},	// KAutostart::startPhase
    {9, 3030, 268},	// KAutostart::staticMetaObject
    {9, 3132, 262},	// KAutostart::tr$
    {9, 3133, 235},	// KAutostart::tr$$
    {9, 3134, 237},	// KAutostart::tr$$$
    {9, 3139, 263},	// KAutostart::trUtf8$
    {9, 3140, 236},	// KAutostart::trUtf8$$
    {9, 3141, 238},	// KAutostart::trUtf8$$$
    {9, 3239, 245},	// KAutostart::visibleName
    {9, 3358, 276},	// KAutostart::~KAutostart
    {10, 301, 394},	// KCalendarSystem::KCalendarSystem
    {10, 302, -342},	// KCalendarSystem::KCalendarSystem#
    {10, 303, 428},	// KCalendarSystem::KCalendarSystem#?
    {10, 304, 387},	// KCalendarSystem::KCalendarSystem#?#
    {10, 305, 395},	// KCalendarSystem::KCalendarSystem?
    {10, 306, 289},	// KCalendarSystem::KCalendarSystem?#
    {10, 595, 437},	// KCalendarSystem::LongDayName
    {10, 596, 430},	// KCalendarSystem::LongFormat
    {10, 597, 432},	// KCalendarSystem::LongName
    {10, 598, 434},	// KCalendarSystem::LongNamePossessive
    {10, 614, 438},	// KCalendarSystem::NarrowDayName
    {10, 615, 435},	// KCalendarSystem::NarrowName
    {10, 709, 436},	// KCalendarSystem::ShortDayName
    {10, 710, 429},	// KCalendarSystem::ShortFormat
    {10, 711, 431},	// KCalendarSystem::ShortName
    {10, 712, 433},	// KCalendarSystem::ShortNamePossessive
    {10, 872, 315},	// KCalendarSystem::addDays#$
    {10, 962, 314},	// KCalendarSystem::addMonths#$
    {10, 999, 313},	// KCalendarSystem::addYears#$
    {10, 1033, 374},	// KCalendarSystem::applyShortYearWindow$
    {10, 1091, 292},	// KCalendarSystem::calendarLabel
    {10, 1092, -345},	// KCalendarSystem::calendarLabel$
    {10, 1093, 284},	// KCalendarSystem::calendarLabel$#
    {10, 1094, 291},	// KCalendarSystem::calendarSystem
    {10, 1095, 286},	// KCalendarSystem::calendarSystem$
    {10, 1097, 285},	// KCalendarSystem::calendarSystemForCalendarType$
    {10, 1098, 281},	// KCalendarSystem::calendarSystems
    {10, 1099, 282},	// KCalendarSystem::calendarSystemsList
    {10, 1100, 290},	// KCalendarSystem::calendarType
    {10, 1101, 287},	// KCalendarSystem::calendarType$
    {10, 1205, 388},	// KCalendarSystem::create
    {10, 1209, -348},	// KCalendarSystem::create$
    {10, 1210, -351},	// KCalendarSystem::create$#
    {10, 1213, -354},	// KCalendarSystem::create$?
    {10, 1214, -357},	// KCalendarSystem::create$?#
    {10, 1255, 316},	// KCalendarSystem::dateDifference##$$$$
    {10, 1264, 382},	// KCalendarSystem::dateToJulianDay$$$$
    {10, 1267, 309},	// KCalendarSystem::day#
    {10, 1269, 332},	// KCalendarSystem::dayOfWeek#
    {10, 1271, 355},	// KCalendarSystem::dayOfWeekString#
    {10, 1273, 331},	// KCalendarSystem::dayOfYear#
    {10, 1275, 413},	// KCalendarSystem::dayOfYearString#
    {10, 1276, 354},	// KCalendarSystem::dayOfYearString#$
    {10, 1281, 411},	// KCalendarSystem::dayString#
    {10, 1282, 352},	// KCalendarSystem::dayString#$
    {10, 1284, 364},	// KCalendarSystem::dayStringToInteger$$
    {10, 1286, 319},	// KCalendarSystem::daysDifference##
    {10, 1288, 328},	// KCalendarSystem::daysInMonth#
    {10, 1289, 329},	// KCalendarSystem::daysInMonth$$
    {10, 1291, 418},	// KCalendarSystem::daysInMonthString#
    {10, 1292, 360},	// KCalendarSystem::daysInMonthString#$
    {10, 1294, 330},	// KCalendarSystem::daysInWeek#
    {10, 1296, 361},	// KCalendarSystem::daysInWeekString#
    {10, 1298, 326},	// KCalendarSystem::daysInYear#
    {10, 1299, 327},	// KCalendarSystem::daysInYear$
    {10, 1301, 417},	// KCalendarSystem::daysInYearString#
    {10, 1302, 359},	// KCalendarSystem::daysInYearString#$
    {10, 1388, 294},	// KCalendarSystem::earliestValidDate
    {10, 1422, 293},	// KCalendarSystem::epoch
    {10, 1429, 396},	// KCalendarSystem::eraName#
    {10, 1430, 310},	// KCalendarSystem::eraName#$
    {10, 1432, 397},	// KCalendarSystem::eraYear#
    {10, 1433, 311},	// KCalendarSystem::eraYear#$
    {10, 1561, 403},	// KCalendarSystem::firstDayOfMonth
    {10, 1562, 344},	// KCalendarSystem::firstDayOfMonth#
    {10, 1563, 342},	// KCalendarSystem::firstDayOfMonth$$
    {10, 1564, 401},	// KCalendarSystem::firstDayOfYear
    {10, 1565, 340},	// KCalendarSystem::firstDayOfYear#
    {10, 1566, 338},	// KCalendarSystem::firstDayOfYear$
    {10, 1578, 419},	// KCalendarSystem::formatDate#
    {10, 1579, -360},	// KCalendarSystem::formatDate#$
    {10, 1580, -364},	// KCalendarSystem::formatDate#$$
    {10, 1581, -368},	// KCalendarSystem::formatDate#$$$
    {10, 1639, 306},	// KCalendarSystem::getDate#$$$
    {10, 1830, 337},	// KCalendarSystem::isLeapYear#
    {10, 1831, 336},	// KCalendarSystem::isLeapYear$
    {10, 1837, 377},	// KCalendarSystem::isLunar
    {10, 1838, 378},	// KCalendarSystem::isLunisolar
    {10, 1847, 380},	// KCalendarSystem::isProleptic
    {10, 1861, 379},	// KCalendarSystem::isSolar
    {10, 1872, 300},	// KCalendarSystem::isValid#
    {10, 1874, 297},	// KCalendarSystem::isValid$$
    {10, 1875, 296},	// KCalendarSystem::isValid$$$
    {10, 1876, 298},	// KCalendarSystem::isValid$$$$
    {10, 1878, 299},	// KCalendarSystem::isValidIsoWeekDate$$$
    {10, 1889, 381},	// KCalendarSystem::julianDayToDate$$$$
    {10, 1953, 404},	// KCalendarSystem::lastDayOfMonth
    {10, 1954, 345},	// KCalendarSystem::lastDayOfMonth#
    {10, 1955, 343},	// KCalendarSystem::lastDayOfMonth$$
    {10, 1956, 402},	// KCalendarSystem::lastDayOfYear
    {10, 1957, 341},	// KCalendarSystem::lastDayOfYear#
    {10, 1958, 339},	// KCalendarSystem::lastDayOfYear$
    {10, 1960, 295},	// KCalendarSystem::latestValidDate
    {10, 1987, 383},	// KCalendarSystem::locale
    {10, 2083, 308},	// KCalendarSystem::month#
    {10, 2085, 406},	// KCalendarSystem::monthName#
    {10, 2086, 347},	// KCalendarSystem::monthName#$
    {10, 2087, 405},	// KCalendarSystem::monthName$$
    {10, 2088, 346},	// KCalendarSystem::monthName$$$
    {10, 2090, 410},	// KCalendarSystem::monthString#
    {10, 2091, 351},	// KCalendarSystem::monthString#$
    {10, 2093, 363},	// KCalendarSystem::monthStringToInteger$$
    {10, 2095, 318},	// KCalendarSystem::monthsDifference##
    {10, 2097, 320},	// KCalendarSystem::monthsInYear#
    {10, 2098, 321},	// KCalendarSystem::monthsInYear$
    {10, 2100, 415},	// KCalendarSystem::monthsInYearString#
    {10, 2101, 357},	// KCalendarSystem::monthsInYearString#$
    {10, 2339, 424},	// KCalendarSystem::readDate$
    {10, 2340, -371},	// KCalendarSystem::readDate$$
    {10, 2341, -375},	// KCalendarSystem::readDate$$$
    {10, 2342, 372},	// KCalendarSystem::readDate$$$$
    {10, 2573, 302},	// KCalendarSystem::setDate#$$
    {10, 2574, 301},	// KCalendarSystem::setDate#$$$
    {10, 2575, 303},	// KCalendarSystem::setDate#$$$$
    {10, 2581, 304},	// KCalendarSystem::setDateIsoWeek#$$$
    {10, 2655, 386},	// KCalendarSystem::setHasYear0$
    {10, 2757, 385},	// KCalendarSystem::setMaxDaysInWeek$
    {10, 2759, 384},	// KCalendarSystem::setMaxMonthsInYear$
    {10, 2929, 305},	// KCalendarSystem::setYMD#$$$
    {10, 2935, 373},	// KCalendarSystem::shortYearWindowStartYear
    {10, 3256, 399},	// KCalendarSystem::week#
    {10, 3257, -378},	// KCalendarSystem::week#$
    {10, 3258, 335},	// KCalendarSystem::week#$$
    {10, 3260, 408},	// KCalendarSystem::weekDayName#
    {10, 3261, 349},	// KCalendarSystem::weekDayName#$
    {10, 3262, 407},	// KCalendarSystem::weekDayName$
    {10, 3263, 348},	// KCalendarSystem::weekDayName$$
    {10, 3264, 376},	// KCalendarSystem::weekDayOfPray
    {10, 3266, 398},	// KCalendarSystem::weekNumber#
    {10, 3267, 333},	// KCalendarSystem::weekNumber#$
    {10, 3269, 414},	// KCalendarSystem::weekNumberString#
    {10, 3270, 356},	// KCalendarSystem::weekNumberString#$
    {10, 3272, 375},	// KCalendarSystem::weekStartDay
    {10, 3274, 322},	// KCalendarSystem::weeksInYear#
    {10, 3275, 323},	// KCalendarSystem::weeksInYear#$
    {10, 3276, 324},	// KCalendarSystem::weeksInYear$
    {10, 3277, 325},	// KCalendarSystem::weeksInYear$$
    {10, 3279, 416},	// KCalendarSystem::weeksInYearString#
    {10, 3280, 358},	// KCalendarSystem::weeksInYearString#$
    {10, 3310, 307},	// KCalendarSystem::year#
    {10, 3312, 312},	// KCalendarSystem::yearInEra#
    {10, 3314, 412},	// KCalendarSystem::yearInEraString#
    {10, 3315, 353},	// KCalendarSystem::yearInEraString#$
    {10, 3317, 409},	// KCalendarSystem::yearString#
    {10, 3318, 350},	// KCalendarSystem::yearString#$
    {10, 3320, 362},	// KCalendarSystem::yearStringToInteger$$
    {10, 3322, 317},	// KCalendarSystem::yearsDifference##
    {10, 3359, 439},	// KCalendarSystem::~KCalendarSystem
    {13, 307, 445},	// KCharMacroExpander::KCharMacroExpander
    {13, 308, -324},	// KCharMacroExpander::KCharMacroExpander#
    {13, 1464, 442},	// KCharMacroExpander::expandEscapedMacro$$?
    {13, 1466, 443},	// KCharMacroExpander::expandMacro#?
    {13, 1478, 441},	// KCharMacroExpander::expandPlainMacro$$?
    {13, 3360, 446},	// KCharMacroExpander::~KCharMacroExpander
    {14, 309, 447},	// KCharsets::KCharsets
    {14, 310, 460},	// KCharsets::KCharsets#
    {14, 1063, 454},	// KCharsets::availableEncodingNames
    {14, 1155, 448},	// KCharsets::codecForName$
    {14, 1156, 449},	// KCharsets::codecForName$$
    {14, 1349, 458},	// KCharsets::descriptionForEncoding$
    {14, 1350, 455},	// KCharsets::descriptiveEncodingNames
    {14, 1409, 459},	// KCharsets::encodingForName$
    {14, 1412, 456},	// KCharsets::encodingsByScript
    {14, 1609, 450},	// KCharsets::fromEntity$
    {14, 1610, 451},	// KCharsets::fromEntity$$
    {14, 1951, 457},	// KCharsets::languageForEncoding$
    {14, 2441, 453},	// KCharsets::resolveEntities$
    {14, 3105, 452},	// KCharsets::toEntity#
    {14, 3361, 461},	// KCharsets::~KCharsets
    {15, 62, 503},	// KCmdLineArgs::CmdLineArgKDE
    {15, 63, 505},	// KCmdLineArgs::CmdLineArgNone
    {15, 64, 502},	// KCmdLineArgs::CmdLineArgQt
    {15, 65, 504},	// KCmdLineArgs::CmdLineArgsMask
    {15, 312, 492},	// KCmdLineArgs::KCmdLineArgs#
    {15, 313, 491},	// KCmdLineArgs::KCmdLineArgs###
    {15, 698, 506},	// KCmdLineArgs::Reserved
    {15, 827, 490},	// KCmdLineArgs::aboutData
    {15, 855, 497},	// KCmdLineArgs::addCmdLineOptions#
    {15, 856, 498},	// KCmdLineArgs::addCmdLineOptions##
    {15, 857, 499},	// KCmdLineArgs::addCmdLineOptions###
    {15, 858, 466},	// KCmdLineArgs::addCmdLineOptions####
    {15, 979, 496},	// KCmdLineArgs::addStdCmdLineOptions
    {15, 980, 465},	// KCmdLineArgs::addStdCmdLineOptions$
    {15, 983, 485},	// KCmdLineArgs::addTempFileOption
    {15, 1003, 489},	// KCmdLineArgs::allArguments
    {15, 1029, 469},	// KCmdLineArgs::appName
    {15, 1036, 477},	// KCmdLineArgs::arg$
    {15, 1144, 481},	// KCmdLineArgs::clear
    {15, 1198, 476},	// KCmdLineArgs::count
    {15, 1244, 468},	// KCmdLineArgs::cwd
    {15, 1397, 472},	// KCmdLineArgs::enable_i18n
    {15, 1646, 473},	// KCmdLineArgs::getOption#
    {15, 1648, 474},	// KCmdLineArgs::getOptionList#
    {15, 1732, 464},	// KCmdLineArgs::init#
    {15, 1734, 495},	// KCmdLineArgs::init$?#
    {15, 1735, 493},	// KCmdLineArgs::init$?####
    {15, 1736, 494},	// KCmdLineArgs::init$?#####
    {15, 1737, 462},	// KCmdLineArgs::init$?#####$
    {15, 1738, 463},	// KCmdLineArgs::init$?#$
    {15, 1859, 475},	// KCmdLineArgs::isSet#
    {15, 1864, 486},	// KCmdLineArgs::isTempFileSet
    {15, 1983, 483},	// KCmdLineArgs::loadAppArgs#
    {15, 2044, 479},	// KCmdLineArgs::makeURL#
    {15, 2221, 500},	// KCmdLineArgs::parsedArgs
    {15, 2222, 467},	// KCmdLineArgs::parsedArgs#
    {15, 2297, 487},	// KCmdLineArgs::qtArgc
    {15, 2298, 488},	// KCmdLineArgs::qtArgv
    {15, 2438, 482},	// KCmdLineArgs::reset
    {15, 2463, 484},	// KCmdLineArgs::saveAppArgs#
    {15, 2564, 480},	// KCmdLineArgs::setCwd#
    {15, 3200, 478},	// KCmdLineArgs::url$
    {15, 3201, 501},	// KCmdLineArgs::usage
    {15, 3202, 470},	// KCmdLineArgs::usage#
    {15, 3204, 471},	// KCmdLineArgs::usageError$
    {15, 3362, 507},	// KCmdLineArgs::~KCmdLineArgs
    {16, 314, 508},	// KCmdLineOptions::KCmdLineOptions
    {16, 315, 509},	// KCmdLineOptions::KCmdLineOptions#
    {16, 843, -211},	// KCmdLineOptions::add#
    {16, 844, 514},	// KCmdLineOptions::add##
    {16, 845, 511},	// KCmdLineOptions::add###
    {16, 2183, 510},	// KCmdLineOptions::operator=#
    {16, 3363, 515},	// KCmdLineOptions::~KCmdLineOptions
    {17, 1070, 526},	// KCodecs::base64Decode#
    {17, 1071, 517},	// KCodecs::base64Decode##
    {17, 1074, 529},	// KCodecs::base64Encode#
    {17, 1075, 525},	// KCodecs::base64Encode##
    {17, 1076, 524},	// KCodecs::base64Encode##$
    {17, 1077, 528},	// KCodecs::base64Encode#$
    {17, 1312, 531},	// KCodecs::decodeRFC2047String$
    {17, 2314, 519},	// KCodecs::quotedPrintableDecode#
    {17, 2315, 518},	// KCodecs::quotedPrintableDecode##
    {17, 2317, 521},	// KCodecs::quotedPrintableEncode#
    {17, 2318, 523},	// KCodecs::quotedPrintableEncode##$
    {17, 2319, 520},	// KCodecs::quotedPrintableEncode#$
    {17, 3224, 530},	// KCodecs::uudecode#
    {17, 3225, 522},	// KCodecs::uudecode##
    {17, 3227, 527},	// KCodecs::uuencode#
    {17, 3228, 516},	// KCodecs::uuencode##
    {18, 316, 532},	// KComponentData::KComponentData
    {18, 317, -381},	// KComponentData::KComponentData#
    {18, 318, 549},	// KComponentData::KComponentData##
    {18, 319, 537},	// KComponentData::KComponentData##$
    {18, 320, -386},	// KComponentData::KComponentData#$
    {18, 693, 552},	// KComponentData::RegisterAsMainComponent
    {18, 717, 553},	// KComponentData::SkipMainComponentRegistration
    {18, 827, 543},	// KComponentData::aboutData
    {18, 1112, 546},	// KComponentData::catalogName
    {18, 1164, 545},	// KComponentData::componentName
    {18, 1168, 542},	// KComponentData::config
    {18, 1377, 541},	// KComponentData::dirs
    {18, 1871, 540},	// KComponentData::isValid
    {18, 2159, 536},	// KComponentData::operator!=#
    {18, 2183, 534},	// KComponentData::operator=#
    {18, 2186, 535},	// KComponentData::operator==#
    {18, 2497, 544},	// KComponentData::setAboutData#
    {18, 2548, 547},	// KComponentData::setConfigName$
    {18, 3364, 554},	// KComponentData::~KComponentData
    {19, 321, 573},	// KCompositeJob::KCompositeJob
    {19, 322, 562},	// KCompositeJob::KCompositeJob#
    {19, 323, 570},	// KCompositeJob::KCompositeJob##
    {19, 982, 563},	// KCompositeJob::addSubjob#
    {19, 1147, 567},	// KCompositeJob::clearSubjobs
    {19, 1697, 565},	// KCompositeJob::hasSubjobs
    {19, 2060, 555},	// KCompositeJob::metaObject
    {19, 2300, 561},	// KCompositeJob::qt_metacall$$?
    {19, 2302, 556},	// KCompositeJob::qt_metacast$
    {19, 2425, 564},	// KCompositeJob::removeSubjob#
    {19, 2949, 569},	// KCompositeJob::slotInfoMessage#$$
    {19, 2951, 568},	// KCompositeJob::slotResult#
    {19, 3030, 574},	// KCompositeJob::staticMetaObject
    {19, 3044, 566},	// KCompositeJob::subjobs
    {19, 3132, 571},	// KCompositeJob::tr$
    {19, 3133, 557},	// KCompositeJob::tr$$
    {19, 3134, 559},	// KCompositeJob::tr$$$
    {19, 3139, 572},	// KCompositeJob::trUtf8$
    {19, 3140, 558},	// KCompositeJob::trUtf8$$
    {19, 3141, 560},	// KCompositeJob::trUtf8$$$
    {19, 3365, 575},	// KCompositeJob::~KCompositeJob
    {21, 47, 616},	// KConfig::CascadeConfig
    {21, 148, 620},	// KConfig::FullConfig
    {21, 173, 615},	// KConfig::IncludeGlobals
    {21, 324, 605},	// KConfig::KConfig
    {21, 325, -240},	// KConfig::KConfig#
    {21, 326, 609},	// KConfig::KConfig#$
    {21, 327, 610},	// KConfig::KConfig#$$
    {21, 328, 577},	// KConfig::KConfig#$$$
    {21, 329, 606},	// KConfig::KConfig$
    {21, 330, -243},	// KConfig::KConfig$$
    {21, 331, -246},	// KConfig::KConfig$$$
    {21, 620, 618},	// KConfig::NoCascade
    {21, 624, 619},	// KConfig::NoGlobals
    {21, 714, 617},	// KConfig::SimpleConfig
    {21, 833, 584},	// KConfig::accessMode
    {21, 860, 589},	// KConfig::addConfigSources?
    {21, 1131, 587},	// KConfig::checkUpdate$$
    {21, 1163, 579},	// KConfig::componentData
    {21, 1195, 612},	// KConfig::copyTo$
    {21, 1196, 586},	// KConfig::copyTo$#
    {21, 1340, 614},	// KConfig::deleteGroupImpl#
    {21, 1341, 602},	// KConfig::deleteGroupImpl#$
    {21, 1419, 613},	// KConfig::entryMap
    {21, 1420, 598},	// KConfig::entryMap$
    {21, 1571, 596},	// KConfig::forceGlobal
    {21, 1656, -249},	// KConfig::groupImpl#
    {21, 1657, 597},	// KConfig::groupList
    {21, 1672, 599},	// KConfig::hasGroupImpl#
    {21, 1791, 585},	// KConfig::isConfigWritable$
    {21, 1800, 582},	// KConfig::isDirty
    {21, 1819, 603},	// KConfig::isGroupImmutableImpl#
    {21, 1824, 594},	// KConfig::isImmutable
    {21, 1987, 590},	// KConfig::locale
    {21, 2046, 583},	// KConfig::markAsClean
    {21, 2102, 580},	// KConfig::name
    {21, 2345, 593},	// KConfig::readDefaults
    {21, 2431, 588},	// KConfig::reparseConfiguration
    {21, 2645, 595},	// KConfig::setForceGlobal$
    {21, 2695, 591},	// KConfig::setLocale$
    {21, 2850, 592},	// KConfig::setReadDefaults$
    {21, 3069, 581},	// KConfig::sync
    {21, 3366, 621},	// KConfig::~KConfig
    {22, 150, 654},	// KConfigBase::Global
    {22, 332, 642},	// KConfigBase::KConfigBase
    {22, 333, 648},	// KConfigBase::KConfigBase#
    {22, 589, 655},	// KConfigBase::Localized
    {22, 617, 657},	// KConfigBase::NoAccess
    {22, 634, 656},	// KConfigBase::Normal
    {22, 660, 653},	// KConfigBase::Persistent
    {22, 687, 658},	// KConfigBase::ReadOnly
    {22, 691, 659},	// KConfigBase::ReadWrite
    {22, 833, 637},	// KConfigBase::accessMode
    {22, 1335, 649},	// KConfigBase::deleteGroup#
    {22, 1336, 632},	// KConfigBase::deleteGroup#$
    {22, 1337, -295},	// KConfigBase::deleteGroup$
    {22, 1338, -298},	// KConfigBase::deleteGroup$$
    {22, 1340, 652},	// KConfigBase::deleteGroupImpl#
    {22, 1341, 646},	// KConfigBase::deleteGroupImpl#$
    {22, 1651, -301},	// KConfigBase::group#
    {22, 1652, -304},	// KConfigBase::group$
    {22, 1656, -309},	// KConfigBase::groupImpl#
    {22, 1657, 622},	// KConfigBase::groupList
    {22, 1669, 625},	// KConfigBase::hasGroup#
    {22, 1670, -312},	// KConfigBase::hasGroup$
    {22, 1672, 643},	// KConfigBase::hasGroupImpl#
    {22, 1816, 639},	// KConfigBase::isGroupImmutable#
    {22, 1817, -315},	// KConfigBase::isGroupImmutable$
    {22, 1819, 647},	// KConfigBase::isGroupImmutableImpl#
    {22, 1824, 638},	// KConfigBase::isImmutable
    {22, 2046, 636},	// KConfigBase::markAsClean
    {22, 3069, 635},	// KConfigBase::sync
    {22, 3367, 660},	// KConfigBase::~KConfigBase
    {23, 334, 661},	// KConfigGroup::KConfigGroup
    {23, 335, 668},	// KConfigGroup::KConfigGroup#
    {23, 336, -64},	// KConfigGroup::KConfigGroup#$
    {23, 337, -69},	// KConfigGroup::KConfigGroup?$
    {23, 833, 675},	// KConfigGroup::accessMode
    {23, 1118, -72},	// KConfigGroup::changeGroup$
    {23, 1168, -75},	// KConfigGroup::config
    {23, 1193, 742},	// KConfigGroup::copyTo#
    {23, 1194, 680},	// KConfigGroup::copyTo#$
    {23, 1332, -78},	// KConfigGroup::deleteEntry$
    {23, 1333, -81},	// KConfigGroup::deleteEntry$$
    {23, 1334, 744},	// KConfigGroup::deleteGroup
    {23, 1335, 745},	// KConfigGroup::deleteGroup#
    {23, 1336, 686},	// KConfigGroup::deleteGroup#$
    {23, 1337, -84},	// KConfigGroup::deleteGroup$
    {23, 1338, -88},	// KConfigGroup::deleteGroup$$
    {23, 1341, 740},	// KConfigGroup::deleteGroupImpl#$
    {23, 1419, 736},	// KConfigGroup::entryMap
    {23, 1461, 672},	// KConfigGroup::exists
    {23, 1656, -91},	// KConfigGroup::groupImpl#
    {23, 1657, 683},	// KConfigGroup::groupList
    {23, 1666, -94},	// KConfigGroup::hasDefault$
    {23, 1672, 737},	// KConfigGroup::hasGroupImpl#
    {23, 1677, -97},	// KConfigGroup::hasKey$
    {23, 1809, -100},	// KConfigGroup::isEntryImmutable$
    {23, 1819, 741},	// KConfigGroup::isGroupImmutableImpl#
    {23, 1824, 729},	// KConfigGroup::isImmutable
    {23, 1871, 670},	// KConfigGroup::isValid
    {23, 1925, 684},	// KConfigGroup::keyList
    {23, 2046, 674},	// KConfigGroup::markAsClean
    {23, 2102, 671},	// KConfigGroup::name
    {23, 2183, 669},	// KConfigGroup::operator=#
    {23, 2212, 682},	// KConfigGroup::parent
    {23, 2349, -103},	// KConfigGroup::readEntry$
    {23, 2350, -106},	// KConfigGroup::readEntry$#
    {23, 2351, -109},	// KConfigGroup::readEntry$$
    {23, 2352, -114},	// KConfigGroup::readEntry$?
    {23, 2354, -119},	// KConfigGroup::readEntryUntranslated$
    {23, 2355, -122},	// KConfigGroup::readEntryUntranslated$$
    {23, 2377, -125},	// KConfigGroup::readPathEntry$$
    {23, 2378, -128},	// KConfigGroup::readPathEntry$?
    {23, 2386, -131},	// KConfigGroup::readXdgListEntry$
    {23, 2387, -134},	// KConfigGroup::readXdgListEntry$?
    {23, 2429, 743},	// KConfigGroup::reparent#
    {23, 2430, 681},	// KConfigGroup::reparent#$
    {23, 2455, -137},	// KConfigGroup::revertToDefault$
    {23, 3069, 673},	// KConfigGroup::sync
    {23, 3293, -140},	// KConfigGroup::writeEntry$#
    {23, 3294, -145},	// KConfigGroup::writeEntry$#$
    {23, 3295, -150},	// KConfigGroup::writeEntry$$
    {23, 3296, -155},	// KConfigGroup::writeEntry$$$
    {23, 3297, -160},	// KConfigGroup::writeEntry$?
    {23, 3298, -165},	// KConfigGroup::writeEntry$?$
    {23, 3302, -170},	// KConfigGroup::writePathEntry$$
    {23, 3303, -173},	// KConfigGroup::writePathEntry$$$
    {23, 3304, -176},	// KConfigGroup::writePathEntry$?
    {23, 3305, -179},	// KConfigGroup::writePathEntry$?$
    {23, 3307, -182},	// KConfigGroup::writeXdgListEntry$?
    {23, 3308, -185},	// KConfigGroup::writeXdgListEntry$?$
    {23, 3368, 774},	// KConfigGroup::~KConfigGroup
    {25, 339, 800},	// KConfigSkeletonItem::KConfigSkeletonItem#
    {25, 340, 775},	// KConfigSkeletonItem::KConfigSkeletonItem$$
    {25, 1650, 777},	// KConfigSkeletonItem::group
    {25, 1811, 792},	// KConfigSkeletonItem::isEqual#
    {25, 1824, 798},	// KConfigSkeletonItem::isImmutable
    {25, 1924, 779},	// KConfigSkeletonItem::key
    {25, 1943, 783},	// KConfigSkeletonItem::label
    {25, 2010, 801},	// KConfigSkeletonItem::mGroup
    {25, 2011, 803},	// KConfigSkeletonItem::mKey
    {25, 2012, 805},	// KConfigSkeletonItem::mName
    {25, 2054, 795},	// KConfigSkeletonItem::maxValue
    {25, 2065, 794},	// KConfigSkeletonItem::minValue
    {25, 2102, 781},	// KConfigSkeletonItem::name
    {25, 2277, 793},	// KConfigSkeletonItem::property
    {25, 2335, 788},	// KConfigSkeletonItem::readConfig#
    {25, 2344, 790},	// KConfigSkeletonItem::readDefault#
    {25, 2361, 799},	// KConfigSkeletonItem::readImmutability#
    {25, 2594, 796},	// KConfigSkeletonItem::setDefault
    {25, 2651, 776},	// KConfigSkeletonItem::setGroup$
    {25, 2671, 778},	// KConfigSkeletonItem::setKey$
    {25, 2673, 782},	// KConfigSkeletonItem::setLabel$
    {25, 2697, 802},	// KConfigSkeletonItem::setMGroup$
    {25, 2699, 804},	// KConfigSkeletonItem::setMKey$
    {25, 2701, 806},	// KConfigSkeletonItem::setMName$
    {25, 2783, 780},	// KConfigSkeletonItem::setName$
    {25, 2844, 791},	// KConfigSkeletonItem::setProperty#
    {25, 2897, 784},	// KConfigSkeletonItem::setToolTip$
    {25, 2923, 786},	// KConfigSkeletonItem::setWhatsThis$
    {25, 3066, 797},	// KConfigSkeletonItem::swapDefault
    {25, 3127, 785},	// KConfigSkeletonItem::toolTip
    {25, 3281, 787},	// KConfigSkeletonItem::whatsThis
    {25, 3289, 789},	// KConfigSkeletonItem::writeConfig#
    {25, 3369, 807},	// KConfigSkeletonItem::~KConfigSkeletonItem
    {26, 341, 857},	// KCoreConfigSkeleton::KCoreConfigSkeleton
    {26, 342, 858},	// KCoreConfigSkeleton::KCoreConfigSkeleton$
    {26, 343, 815},	// KCoreConfigSkeleton::KCoreConfigSkeleton$#
    {26, 344, 859},	// KCoreConfigSkeleton::KCoreConfigSkeleton?
    {26, 345, 816},	// KCoreConfigSkeleton::KCoreConfigSkeleton?#
    {26, 879, 860},	// KCoreConfigSkeleton::addItem#
    {26, 880, 822},	// KCoreConfigSkeleton::addItem#$
    {26, 882, 869},	// KCoreConfigSkeleton::addItemBool$$
    {26, 883, 870},	// KCoreConfigSkeleton::addItemBool$$$
    {26, 884, 827},	// KCoreConfigSkeleton::addItemBool$$$$
    {26, 886, 891},	// KCoreConfigSkeleton::addItemDateTime$#
    {26, 887, 892},	// KCoreConfigSkeleton::addItemDateTime$##
    {26, 888, 838},	// KCoreConfigSkeleton::addItemDateTime$##$
    {26, 890, 883},	// KCoreConfigSkeleton::addItemDouble$$
    {26, 891, 884},	// KCoreConfigSkeleton::addItemDouble$$$
    {26, 892, 834},	// KCoreConfigSkeleton::addItemDouble$$$$
    {26, 894, 871},	// KCoreConfigSkeleton::addItemInt$$
    {26, 895, 872},	// KCoreConfigSkeleton::addItemInt$$$
    {26, 896, 828},	// KCoreConfigSkeleton::addItemInt$$$$
    {26, 898, 877},	// KCoreConfigSkeleton::addItemInt64$$
    {26, 899, 878},	// KCoreConfigSkeleton::addItemInt64$$$
    {26, 900, 831},	// KCoreConfigSkeleton::addItemInt64$$$$
    {26, 902, 895},	// KCoreConfigSkeleton::addItemIntList$?
    {26, 903, 896},	// KCoreConfigSkeleton::addItemIntList$??
    {26, 904, 840},	// KCoreConfigSkeleton::addItemIntList$??$
    {26, 906, 875},	// KCoreConfigSkeleton::addItemLongLong$$
    {26, 907, 876},	// KCoreConfigSkeleton::addItemLongLong$$$
    {26, 908, 830},	// KCoreConfigSkeleton::addItemLongLong$$$$
    {26, 910, 863},	// KCoreConfigSkeleton::addItemPassword$$
    {26, 911, 864},	// KCoreConfigSkeleton::addItemPassword$$$
    {26, 912, 824},	// KCoreConfigSkeleton::addItemPassword$$$$
    {26, 914, 865},	// KCoreConfigSkeleton::addItemPath$$
    {26, 915, 866},	// KCoreConfigSkeleton::addItemPath$$$
    {26, 916, 825},	// KCoreConfigSkeleton::addItemPath$$$$
    {26, 918, 887},	// KCoreConfigSkeleton::addItemPoint$#
    {26, 919, 888},	// KCoreConfigSkeleton::addItemPoint$##
    {26, 920, 836},	// KCoreConfigSkeleton::addItemPoint$##$
    {26, 922, 867},	// KCoreConfigSkeleton::addItemProperty$#
    {26, 923, 868},	// KCoreConfigSkeleton::addItemProperty$##
    {26, 924, 826},	// KCoreConfigSkeleton::addItemProperty$##$
    {26, 926, 885},	// KCoreConfigSkeleton::addItemRect$#
    {26, 927, 886},	// KCoreConfigSkeleton::addItemRect$##
    {26, 928, 835},	// KCoreConfigSkeleton::addItemRect$##$
    {26, 930, 889},	// KCoreConfigSkeleton::addItemSize$#
    {26, 931, 890},	// KCoreConfigSkeleton::addItemSize$##
    {26, 932, 837},	// KCoreConfigSkeleton::addItemSize$##$
    {26, 934, 861},	// KCoreConfigSkeleton::addItemString$$
    {26, 935, 862},	// KCoreConfigSkeleton::addItemString$$$
    {26, 936, 823},	// KCoreConfigSkeleton::addItemString$$$$
    {26, 938, 893},	// KCoreConfigSkeleton::addItemStringList$?
    {26, 939, 894},	// KCoreConfigSkeleton::addItemStringList$??
    {26, 940, 839},	// KCoreConfigSkeleton::addItemStringList$??$
    {26, 942, 873},	// KCoreConfigSkeleton::addItemUInt$$
    {26, 943, 874},	// KCoreConfigSkeleton::addItemUInt$$$
    {26, 944, 829},	// KCoreConfigSkeleton::addItemUInt$$$$
    {26, 946, 881},	// KCoreConfigSkeleton::addItemUInt64$$
    {26, 947, 882},	// KCoreConfigSkeleton::addItemUInt64$$$
    {26, 948, 833},	// KCoreConfigSkeleton::addItemUInt64$$$$
    {26, 950, 879},	// KCoreConfigSkeleton::addItemULongLong$$
    {26, 951, 880},	// KCoreConfigSkeleton::addItemULongLong$$$
    {26, 952, 832},	// KCoreConfigSkeleton::addItemULongLong$$$$
    {26, 1168, -231},	// KCoreConfigSkeleton::config
    {26, 1170, 850},	// KCoreConfigSkeleton::configChanged
    {26, 1233, 821},	// KCoreConfigSkeleton::currentGroup
    {26, 1550, -234},	// KCoreConfigSkeleton::findItem$
    {26, 1825, -237},	// KCoreConfigSkeleton::isImmutable$
    {26, 1882, 844},	// KCoreConfigSkeleton::items
    {26, 2060, 808},	// KCoreConfigSkeleton::metaObject
    {26, 2300, 814},	// KCoreConfigSkeleton::qt_metacall$$?
    {26, 2302, 809},	// KCoreConfigSkeleton::qt_metacast$
    {26, 2334, 818},	// KCoreConfigSkeleton::readConfig
    {26, 2560, 820},	// KCoreConfigSkeleton::setCurrentGroup$
    {26, 2599, 817},	// KCoreConfigSkeleton::setDefaults
    {26, 2860, 843},	// KCoreConfigSkeleton::setSharedConfig?
    {26, 3030, 897},	// KCoreConfigSkeleton::staticMetaObject
    {26, 3132, 855},	// KCoreConfigSkeleton::tr$
    {26, 3133, 810},	// KCoreConfigSkeleton::tr$$
    {26, 3134, 812},	// KCoreConfigSkeleton::tr$$$
    {26, 3139, 856},	// KCoreConfigSkeleton::trUtf8$
    {26, 3140, 811},	// KCoreConfigSkeleton::trUtf8$$
    {26, 3141, 813},	// KCoreConfigSkeleton::trUtf8$$$
    {26, 3207, 849},	// KCoreConfigSkeleton::useDefaults$
    {26, 3215, 853},	// KCoreConfigSkeleton::usrReadConfig
    {26, 3216, 852},	// KCoreConfigSkeleton::usrSetDefaults
    {26, 3218, 851},	// KCoreConfigSkeleton::usrUseDefaults$
    {26, 3219, 854},	// KCoreConfigSkeleton::usrWriteConfig
    {26, 3288, 819},	// KCoreConfigSkeleton::writeConfig
    {26, 3370, 898},	// KCoreConfigSkeleton::~KCoreConfigSkeleton
    {27, 191, 904},	// KCoreConfigSkeleton::ItemBool::ItemBool#
    {27, 192, 905},	// KCoreConfigSkeleton::ItemBool::ItemBool$$$
    {27, 193, 899},	// KCoreConfigSkeleton::ItemBool::ItemBool$$$$
    {27, 1811, 902},	// KCoreConfigSkeleton::ItemBool::isEqual#
    {27, 2277, 903},	// KCoreConfigSkeleton::ItemBool::property
    {27, 2335, 900},	// KCoreConfigSkeleton::ItemBool::readConfig#
    {27, 2844, 901},	// KCoreConfigSkeleton::ItemBool::setProperty#
    {27, 3334, 906},	// KCoreConfigSkeleton::ItemBool::~ItemBool
    {28, 195, 912},	// KCoreConfigSkeleton::ItemDateTime::ItemDateTime#
    {28, 196, 913},	// KCoreConfigSkeleton::ItemDateTime::ItemDateTime$$#
    {28, 197, 907},	// KCoreConfigSkeleton::ItemDateTime::ItemDateTime$$##
    {28, 1811, 910},	// KCoreConfigSkeleton::ItemDateTime::isEqual#
    {28, 2277, 911},	// KCoreConfigSkeleton::ItemDateTime::property
    {28, 2335, 908},	// KCoreConfigSkeleton::ItemDateTime::readConfig#
    {28, 2844, 909},	// KCoreConfigSkeleton::ItemDateTime::setProperty#
    {28, 3335, 914},	// KCoreConfigSkeleton::ItemDateTime::~ItemDateTime
    {29, 199, 924},	// KCoreConfigSkeleton::ItemDouble::ItemDouble#
    {29, 200, 925},	// KCoreConfigSkeleton::ItemDouble::ItemDouble$$$
    {29, 201, 915},	// KCoreConfigSkeleton::ItemDouble::ItemDouble$$$$
    {29, 1811, 918},	// KCoreConfigSkeleton::ItemDouble::isEqual#
    {29, 2054, 921},	// KCoreConfigSkeleton::ItemDouble::maxValue
    {29, 2065, 920},	// KCoreConfigSkeleton::ItemDouble::minValue
    {29, 2277, 919},	// KCoreConfigSkeleton::ItemDouble::property
    {29, 2335, 916},	// KCoreConfigSkeleton::ItemDouble::readConfig#
    {29, 2763, 923},	// KCoreConfigSkeleton::ItemDouble::setMaxValue$
    {29, 2771, 922},	// KCoreConfigSkeleton::ItemDouble::setMinValue$
    {29, 2844, 917},	// KCoreConfigSkeleton::ItemDouble::setProperty#
    {29, 3336, 926},	// KCoreConfigSkeleton::ItemDouble::~ItemDouble
    {30, 203, 933},	// KCoreConfigSkeleton::ItemEnum::ItemEnum#
    {30, 204, -51},	// KCoreConfigSkeleton::ItemEnum::ItemEnum$$$?
    {30, 205, -54},	// KCoreConfigSkeleton::ItemEnum::ItemEnum$$$?$
    {30, 1140, 929},	// KCoreConfigSkeleton::ItemEnum::choices
    {30, 1141, 930},	// KCoreConfigSkeleton::ItemEnum::choices2
    {30, 2335, 931},	// KCoreConfigSkeleton::ItemEnum::readConfig#
    {30, 3289, 932},	// KCoreConfigSkeleton::ItemEnum::writeConfig#
    {30, 3337, 936},	// KCoreConfigSkeleton::ItemEnum::~ItemEnum
    {31, 56, 937},	// KCoreConfigSkeleton::ItemEnum::Choice::Choice
    {31, 57, 938},	// KCoreConfigSkeleton::ItemEnum::Choice::Choice#
    {31, 1943, 941},	// KCoreConfigSkeleton::ItemEnum::Choice::label
    {31, 2102, 939},	// KCoreConfigSkeleton::ItemEnum::Choice::name
    {31, 2673, 942},	// KCoreConfigSkeleton::ItemEnum::Choice::setLabel$
    {31, 2783, 940},	// KCoreConfigSkeleton::ItemEnum::Choice::setName$
    {31, 2923, 944},	// KCoreConfigSkeleton::ItemEnum::Choice::setWhatsThis$
    {31, 3281, 943},	// KCoreConfigSkeleton::ItemEnum::Choice::whatsThis
    {31, 3331, 945},	// KCoreConfigSkeleton::ItemEnum::Choice::~Choice
    {32, 58, 946},	// KCoreConfigSkeleton::ItemEnum::Choice2::Choice2
    {32, 59, 947},	// KCoreConfigSkeleton::ItemEnum::Choice2::Choice2#
    {32, 1943, 950},	// KCoreConfigSkeleton::ItemEnum::Choice2::label
    {32, 2102, 948},	// KCoreConfigSkeleton::ItemEnum::Choice2::name
    {32, 2673, 951},	// KCoreConfigSkeleton::ItemEnum::Choice2::setLabel$
    {32, 2783, 949},	// KCoreConfigSkeleton::ItemEnum::Choice2::setName$
    {32, 2897, 953},	// KCoreConfigSkeleton::ItemEnum::Choice2::setToolTip$
    {32, 2923, 955},	// KCoreConfigSkeleton::ItemEnum::Choice2::setWhatsThis$
    {32, 3127, 952},	// KCoreConfigSkeleton::ItemEnum::Choice2::toolTip
    {32, 3281, 954},	// KCoreConfigSkeleton::ItemEnum::Choice2::whatsThis
    {32, 3332, 956},	// KCoreConfigSkeleton::ItemEnum::Choice2::~Choice2
    {33, 207, 966},	// KCoreConfigSkeleton::ItemInt::ItemInt#
    {33, 208, 967},	// KCoreConfigSkeleton::ItemInt::ItemInt$$$
    {33, 209, 957},	// KCoreConfigSkeleton::ItemInt::ItemInt$$$$
    {33, 1811, 960},	// KCoreConfigSkeleton::ItemInt::isEqual#
    {33, 2054, 963},	// KCoreConfigSkeleton::ItemInt::maxValue
    {33, 2065, 962},	// KCoreConfigSkeleton::ItemInt::minValue
    {33, 2277, 961},	// KCoreConfigSkeleton::ItemInt::property
    {33, 2335, 958},	// KCoreConfigSkeleton::ItemInt::readConfig#
    {33, 2763, 965},	// KCoreConfigSkeleton::ItemInt::setMaxValue$
    {33, 2771, 964},	// KCoreConfigSkeleton::ItemInt::setMinValue$
    {33, 2844, 959},	// KCoreConfigSkeleton::ItemInt::setProperty#
    {33, 3338, 968},	// KCoreConfigSkeleton::ItemInt::~ItemInt
    {34, 211, 974},	// KCoreConfigSkeleton::ItemIntList::ItemIntList#
    {34, 212, 975},	// KCoreConfigSkeleton::ItemIntList::ItemIntList$$?
    {34, 213, 969},	// KCoreConfigSkeleton::ItemIntList::ItemIntList$$??
    {34, 1811, 972},	// KCoreConfigSkeleton::ItemIntList::isEqual#
    {34, 2277, 973},	// KCoreConfigSkeleton::ItemIntList::property
    {34, 2335, 970},	// KCoreConfigSkeleton::ItemIntList::readConfig#
    {34, 2844, 971},	// KCoreConfigSkeleton::ItemIntList::setProperty#
    {34, 3339, 976},	// KCoreConfigSkeleton::ItemIntList::~ItemIntList
    {35, 215, 986},	// KCoreConfigSkeleton::ItemLongLong::ItemLongLong#
    {35, 216, 987},	// KCoreConfigSkeleton::ItemLongLong::ItemLongLong$$$
    {35, 217, 977},	// KCoreConfigSkeleton::ItemLongLong::ItemLongLong$$$$
    {35, 1811, 980},	// KCoreConfigSkeleton::ItemLongLong::isEqual#
    {35, 2054, 983},	// KCoreConfigSkeleton::ItemLongLong::maxValue
    {35, 2065, 982},	// KCoreConfigSkeleton::ItemLongLong::minValue
    {35, 2277, 981},	// KCoreConfigSkeleton::ItemLongLong::property
    {35, 2335, 978},	// KCoreConfigSkeleton::ItemLongLong::readConfig#
    {35, 2763, 985},	// KCoreConfigSkeleton::ItemLongLong::setMaxValue$
    {35, 2771, 984},	// KCoreConfigSkeleton::ItemLongLong::setMinValue$
    {35, 2844, 979},	// KCoreConfigSkeleton::ItemLongLong::setProperty#
    {35, 3340, 988},	// KCoreConfigSkeleton::ItemLongLong::~ItemLongLong
    {36, 219, 990},	// KCoreConfigSkeleton::ItemPassword::ItemPassword#
    {36, 220, 991},	// KCoreConfigSkeleton::ItemPassword::ItemPassword$$$
    {36, 221, 989},	// KCoreConfigSkeleton::ItemPassword::ItemPassword$$$$
    {36, 3341, 992},	// KCoreConfigSkeleton::ItemPassword::~ItemPassword
    {37, 223, 994},	// KCoreConfigSkeleton::ItemPath::ItemPath#
    {37, 224, 995},	// KCoreConfigSkeleton::ItemPath::ItemPath$$$
    {37, 225, 993},	// KCoreConfigSkeleton::ItemPath::ItemPath$$$$
    {37, 3342, 996},	// KCoreConfigSkeleton::ItemPath::~ItemPath
    {38, 227, 1000},	// KCoreConfigSkeleton::ItemPathList::ItemPathList#
    {38, 228, 1001},	// KCoreConfigSkeleton::ItemPathList::ItemPathList$$?
    {38, 229, 997},	// KCoreConfigSkeleton::ItemPathList::ItemPathList$$??
    {38, 2335, 998},	// KCoreConfigSkeleton::ItemPathList::readConfig#
    {38, 3289, 999},	// KCoreConfigSkeleton::ItemPathList::writeConfig#
    {38, 3343, 1002},	// KCoreConfigSkeleton::ItemPathList::~ItemPathList
    {39, 231, 1008},	// KCoreConfigSkeleton::ItemPoint::ItemPoint#
    {39, 232, 1009},	// KCoreConfigSkeleton::ItemPoint::ItemPoint$$#
    {39, 233, 1003},	// KCoreConfigSkeleton::ItemPoint::ItemPoint$$##
    {39, 1811, 1006},	// KCoreConfigSkeleton::ItemPoint::isEqual#
    {39, 2277, 1007},	// KCoreConfigSkeleton::ItemPoint::property
    {39, 2335, 1004},	// KCoreConfigSkeleton::ItemPoint::readConfig#
    {39, 2844, 1005},	// KCoreConfigSkeleton::ItemPoint::setProperty#
    {39, 3344, 1010},	// KCoreConfigSkeleton::ItemPoint::~ItemPoint
    {40, 235, 1016},	// KCoreConfigSkeleton::ItemProperty::ItemProperty#
    {40, 236, 1017},	// KCoreConfigSkeleton::ItemProperty::ItemProperty$$#
    {40, 237, 1011},	// KCoreConfigSkeleton::ItemProperty::ItemProperty$$##
    {40, 1811, 1014},	// KCoreConfigSkeleton::ItemProperty::isEqual#
    {40, 2277, 1015},	// KCoreConfigSkeleton::ItemProperty::property
    {40, 2335, 1012},	// KCoreConfigSkeleton::ItemProperty::readConfig#
    {40, 2844, 1013},	// KCoreConfigSkeleton::ItemProperty::setProperty#
    {40, 3345, 1018},	// KCoreConfigSkeleton::ItemProperty::~ItemProperty
    {41, 239, 1024},	// KCoreConfigSkeleton::ItemRect::ItemRect#
    {41, 240, 1025},	// KCoreConfigSkeleton::ItemRect::ItemRect$$#
    {41, 241, 1019},	// KCoreConfigSkeleton::ItemRect::ItemRect$$##
    {41, 1811, 1022},	// KCoreConfigSkeleton::ItemRect::isEqual#
    {41, 2277, 1023},	// KCoreConfigSkeleton::ItemRect::property
    {41, 2335, 1020},	// KCoreConfigSkeleton::ItemRect::readConfig#
    {41, 2844, 1021},	// KCoreConfigSkeleton::ItemRect::setProperty#
    {41, 3346, 1026},	// KCoreConfigSkeleton::ItemRect::~ItemRect
    {42, 243, 1032},	// KCoreConfigSkeleton::ItemSize::ItemSize#
    {42, 244, 1033},	// KCoreConfigSkeleton::ItemSize::ItemSize$$#
    {42, 245, 1027},	// KCoreConfigSkeleton::ItemSize::ItemSize$$##
    {42, 1811, 1030},	// KCoreConfigSkeleton::ItemSize::isEqual#
    {42, 2277, 1031},	// KCoreConfigSkeleton::ItemSize::property
    {42, 2335, 1028},	// KCoreConfigSkeleton::ItemSize::readConfig#
    {42, 2844, 1029},	// KCoreConfigSkeleton::ItemSize::setProperty#
    {42, 3347, 1034},	// KCoreConfigSkeleton::ItemSize::~ItemSize
    {43, 247, 1041},	// KCoreConfigSkeleton::ItemString::ItemString#
    {43, 248, 1042},	// KCoreConfigSkeleton::ItemString::ItemString$$$
    {43, 249, 1043},	// KCoreConfigSkeleton::ItemString::ItemString$$$$
    {43, 250, 1035},	// KCoreConfigSkeleton::ItemString::ItemString$$$$$
    {43, 634, 1044},	// KCoreConfigSkeleton::ItemString::Normal
    {43, 656, 1045},	// KCoreConfigSkeleton::ItemString::Password
    {43, 657, 1046},	// KCoreConfigSkeleton::ItemString::Path
    {43, 1811, 1039},	// KCoreConfigSkeleton::ItemString::isEqual#
    {43, 2277, 1040},	// KCoreConfigSkeleton::ItemString::property
    {43, 2335, 1037},	// KCoreConfigSkeleton::ItemString::readConfig#
    {43, 2844, 1038},	// KCoreConfigSkeleton::ItemString::setProperty#
    {43, 3289, 1036},	// KCoreConfigSkeleton::ItemString::writeConfig#
    {43, 3348, 1047},	// KCoreConfigSkeleton::ItemString::~ItemString
    {44, 252, 1053},	// KCoreConfigSkeleton::ItemStringList::ItemStringList#
    {44, 253, 1054},	// KCoreConfigSkeleton::ItemStringList::ItemStringList$$?
    {44, 254, 1048},	// KCoreConfigSkeleton::ItemStringList::ItemStringList$$??
    {44, 1811, 1051},	// KCoreConfigSkeleton::ItemStringList::isEqual#
    {44, 2277, 1052},	// KCoreConfigSkeleton::ItemStringList::property
    {44, 2335, 1049},	// KCoreConfigSkeleton::ItemStringList::readConfig#
    {44, 2844, 1050},	// KCoreConfigSkeleton::ItemStringList::setProperty#
    {44, 3349, 1055},	// KCoreConfigSkeleton::ItemStringList::~ItemStringList
    {45, 256, 1065},	// KCoreConfigSkeleton::ItemUInt::ItemUInt#
    {45, 257, 1066},	// KCoreConfigSkeleton::ItemUInt::ItemUInt$$$
    {45, 258, 1056},	// KCoreConfigSkeleton::ItemUInt::ItemUInt$$$$
    {45, 1811, 1059},	// KCoreConfigSkeleton::ItemUInt::isEqual#
    {45, 2054, 1062},	// KCoreConfigSkeleton::ItemUInt::maxValue
    {45, 2065, 1061},	// KCoreConfigSkeleton::ItemUInt::minValue
    {45, 2277, 1060},	// KCoreConfigSkeleton::ItemUInt::property
    {45, 2335, 1057},	// KCoreConfigSkeleton::ItemUInt::readConfig#
    {45, 2763, 1064},	// KCoreConfigSkeleton::ItemUInt::setMaxValue$
    {45, 2771, 1063},	// KCoreConfigSkeleton::ItemUInt::setMinValue$
    {45, 2844, 1058},	// KCoreConfigSkeleton::ItemUInt::setProperty#
    {45, 3350, 1067},	// KCoreConfigSkeleton::ItemUInt::~ItemUInt
    {46, 260, 1077},	// KCoreConfigSkeleton::ItemULongLong::ItemULongLong#
    {46, 261, 1078},	// KCoreConfigSkeleton::ItemULongLong::ItemULongLong$$$
    {46, 262, 1068},	// KCoreConfigSkeleton::ItemULongLong::ItemULongLong$$$$
    {46, 1811, 1071},	// KCoreConfigSkeleton::ItemULongLong::isEqual#
    {46, 2054, 1074},	// KCoreConfigSkeleton::ItemULongLong::maxValue
    {46, 2065, 1073},	// KCoreConfigSkeleton::ItemULongLong::minValue
    {46, 2277, 1072},	// KCoreConfigSkeleton::ItemULongLong::property
    {46, 2335, 1069},	// KCoreConfigSkeleton::ItemULongLong::readConfig#
    {46, 2763, 1076},	// KCoreConfigSkeleton::ItemULongLong::setMaxValue$
    {46, 2771, 1075},	// KCoreConfigSkeleton::ItemULongLong::setMinValue$
    {46, 2844, 1070},	// KCoreConfigSkeleton::ItemULongLong::setProperty#
    {46, 3351, 1079},	// KCoreConfigSkeleton::ItemULongLong::~ItemULongLong
    {47, 264, 1086},	// KCoreConfigSkeleton::ItemUrl::ItemUrl#
    {47, 265, 1087},	// KCoreConfigSkeleton::ItemUrl::ItemUrl$$#
    {47, 266, 1080},	// KCoreConfigSkeleton::ItemUrl::ItemUrl$$##
    {47, 1811, 1084},	// KCoreConfigSkeleton::ItemUrl::isEqual#
    {47, 2277, 1085},	// KCoreConfigSkeleton::ItemUrl::property
    {47, 2335, 1082},	// KCoreConfigSkeleton::ItemUrl::readConfig#
    {47, 2844, 1083},	// KCoreConfigSkeleton::ItemUrl::setProperty#
    {47, 3289, 1081},	// KCoreConfigSkeleton::ItemUrl::writeConfig#
    {47, 3352, 1088},	// KCoreConfigSkeleton::ItemUrl::~ItemUrl
    {48, 268, 1095},	// KCoreConfigSkeleton::ItemUrlList::ItemUrlList#
    {48, 269, 1096},	// KCoreConfigSkeleton::ItemUrlList::ItemUrlList$$?
    {48, 270, 1089},	// KCoreConfigSkeleton::ItemUrlList::ItemUrlList$$??
    {48, 1811, 1093},	// KCoreConfigSkeleton::ItemUrlList::isEqual#
    {48, 2277, 1094},	// KCoreConfigSkeleton::ItemUrlList::property
    {48, 2335, 1090},	// KCoreConfigSkeleton::ItemUrlList::readConfig#
    {48, 2844, 1092},	// KCoreConfigSkeleton::ItemUrlList::setProperty#
    {48, 3289, 1091},	// KCoreConfigSkeleton::ItemUrlList::writeConfig#
    {48, 3353, 1097},	// KCoreConfigSkeleton::ItemUrlList::~ItemUrlList
    {49, 11, 1128},	// KCurrencyCode::ActiveCurrency
    {49, 347, -519},	// KCurrencyCode::KCurrencyCode#
    {49, 348, 1099},	// KCurrencyCode::KCurrencyCode#$
    {49, 349, 1123},	// KCurrencyCode::KCurrencyCode$
    {49, 350, 1098},	// KCurrencyCode::KCurrencyCode$$
    {49, 642, 1130},	// KCurrencyCode::ObsoleteCurrency
    {49, 743, 1129},	// KCurrencyCode::SuspendedCurrency
    {49, 1005, 1126},	// KCurrencyCode::allCurrencyCodesList
    {49, 1006, 1121},	// KCurrencyCode::allCurrencyCodesList$
    {49, 1199, 1118},	// KCurrencyCode::countriesUsingCurrency
    {49, 1227, 1127},	// KCurrencyCode::currencyCodeToName$
    {49, 1228, 1122},	// KCurrencyCode::currencyCodeToName$$
    {49, 1258, 1107},	// KCurrencyCode::dateIntroduced
    {49, 1260, 1108},	// KCurrencyCode::dateSuspended
    {49, 1265, 1109},	// KCurrencyCode::dateWithdrawn
    {49, 1306, 1117},	// KCurrencyCode::decimalPlaces
    {49, 1329, 1111},	// KCurrencyCode::defaultSymbol
    {49, 1698, 1113},	// KCurrencyCode::hasSubunits
    {49, 1699, 1114},	// KCurrencyCode::hasSubunitsInCirculation
    {49, 1871, 1119},	// KCurrencyCode::isValid
    {49, 1873, 1125},	// KCurrencyCode::isValid$
    {49, 1874, 1120},	// KCurrencyCode::isValid$$
    {49, 1879, 1102},	// KCurrencyCode::isoCurrencyCode
    {49, 1880, 1103},	// KCurrencyCode::isoCurrencyCodeNumeric
    {49, 1881, 1105},	// KCurrencyCode::isoName
    {49, 2102, 1104},	// KCurrencyCode::name
    {49, 2183, 1101},	// KCurrencyCode::operator=#
    {49, 3033, 1106},	// KCurrencyCode::status
    {49, 3057, 1115},	// KCurrencyCode::subunitSymbol
    {49, 3058, 1116},	// KCurrencyCode::subunitsPerUnit
    {49, 3068, 1110},	// KCurrencyCode::symbolList
    {49, 3178, 1112},	// KCurrencyCode::unambiguousSymbol
    {49, 3371, 1131},	// KCurrencyCode::~KCurrencyCode
    {50, 832, 1141},	// KDE::access$$
    {50, 1139, 1135},	// KDE::chmod$?
    {50, 1570, 1132},	// KDE::fopen$$
    {50, 2069, 1142},	// KDE::mkdir$?
    {50, 2147, 1140},	// KDE::open$$
    {50, 2148, 1139},	// KDE::open$$?
    {50, 2427, 1136},	// KDE::rename$$
    {50, 3234, 1138},	// KDE::version
    {50, 3235, 1143},	// KDE::versionMajor
    {50, 3236, 1133},	// KDE::versionMinor
    {50, 3237, 1137},	// KDE::versionRelease
    {50, 3238, 1134},	// KDE::versionString
    {51, 351, 1160},	// KDEDModule::KDEDModule
    {51, 352, 1151},	// KDEDModule::KDEDModule#
    {51, 2060, 1144},	// KDEDModule::metaObject
    {51, 2074, 1154},	// KDEDModule::moduleDeleted#
    {51, 2075, 1153},	// KDEDModule::moduleName
    {51, 2077, 1157},	// KDEDModule::moduleRegistered#
    {51, 2300, 1150},	// KDEDModule::qt_metacall$$?
    {51, 2302, 1145},	// KDEDModule::qt_metacast$
    {51, 2773, 1152},	// KDEDModule::setModuleName$
    {51, 3030, 1161},	// KDEDModule::staticMetaObject
    {51, 3132, 1158},	// KDEDModule::tr$
    {51, 3133, 1146},	// KDEDModule::tr$$
    {51, 3134, 1148},	// KDEDModule::tr$$$
    {51, 3139, 1159},	// KDEDModule::trUtf8$
    {51, 3140, 1147},	// KDEDModule::trUtf8$$
    {51, 3141, 1149},	// KDEDModule::trUtf8$$$
    {51, 3283, 1155},	// KDEDModule::windowRegistered$
    {51, 3285, 1156},	// KDEDModule::windowUnregistered$
    {51, 3372, 1162},	// KDEDModule::~KDEDModule
    {52, 353, 1163},	// KDEPluginVerificationData::KDEPluginVerificationData
    {52, 354, 1164},	// KDEPluginVerificationData::KDEPluginVerificationData#
    {52, 355, 1167},	// KDEPluginVerificationData::KDEVersion
    {52, 356, 1169},	// KDEPluginVerificationData::KDEVersionString
    {52, 667, 1171},	// KDEPluginVerificationData::PluginVerificationDataVersion
    {52, 1247, 1165},	// KDEPluginVerificationData::dataVersion
    {52, 2570, 1166},	// KDEPluginVerificationData::setDataVersion$
    {52, 2667, 1168},	// KDEPluginVerificationData::setKDEVersion$
    {52, 2669, 1170},	// KDEPluginVerificationData::setKDEVersionString$
    {52, 3373, 1172},	// KDEPluginVerificationData::~KDEPluginVerificationData
    {53, 14, 1263},	// KDateTime::After
    {53, 25, 1262},	// KDateTime::AtEnd
    {53, 26, 1260},	// KDateTime::AtStart
    {53, 41, 1259},	// KDateTime::Before
    {53, 60, 1252},	// KDateTime::ClockTime
    {53, 116, 1267},	// KDateTime::EndsAt
    {53, 117, 1264},	// KDateTime::Equal
    {53, 169, 1253},	// KDateTime::ISODate
    {53, 176, 1261},	// KDateTime::Inside
    {53, 177, 1247},	// KDateTime::Invalid
    {53, 357, 1173},	// KDateTime::KDateTime
    {53, 358, -214},	// KDateTime::KDateTime#
    {53, 359, -218},	// KDateTime::KDateTime##
    {53, 360, 1175},	// KDateTime::KDateTime###
    {53, 587, 1257},	// KDateTime::LocalDate
    {53, 588, 1251},	// KDateTime::LocalZone
    {53, 643, 1249},	// KDateTime::OffsetFromUTC
    {53, 654, 1265},	// KDateTime::Outside
    {53, 680, 1256},	// KDateTime::QtTextDate
    {53, 682, 1258},	// KDateTime::RFC3339Date
    {53, 683, 1254},	// KDateTime::RFCDate
    {53, 684, 1255},	// KDateTime::RFCDateDay
    {53, 738, 1266},	// KDateTime::StartsAt
    {53, 762, 1250},	// KDateTime::TimeZone
    {53, 772, 1248},	// KDateTime::UTC
    {53, 873, 1213},	// KDateTime::addDays$
    {53, 960, 1211},	// KDateTime::addMSecs$
    {53, 963, 1214},	// KDateTime::addMonths$
    {53, 978, 1212},	// KDateTime::addSecs$
    {53, 1000, 1215},	// KDateTime::addYears$
    {53, 1162, 1230},	// KDateTime::compare#
    {53, 1232, 1221},	// KDateTime::currentDateTime#
    {53, 1234, 1222},	// KDateTime::currentLocalDate
    {53, 1235, 1219},	// KDateTime::currentLocalDateTime
    {53, 1236, 1223},	// KDateTime::currentLocalTime
    {53, 1239, 1220},	// KDateTime::currentUtcDateTime
    {53, 1253, 1183},	// KDateTime::date
    {53, 1261, 1185},	// KDateTime::dateTime
    {53, 1304, 1218},	// KDateTime::daysTo#
    {53, 1356, 1237},	// KDateTime::detach
    {53, 1627, 1243},	// KDateTime::fromString$
    {53, 1628, -222},	// KDateTime::fromString$$
    {53, 1629, 1246},	// KDateTime::fromString$$#
    {53, 1630, 1227},	// KDateTime::fromString$$#$
    {53, 1631, 1226},	// KDateTime::fromString$$$
    {53, 1789, 1190},	// KDateTime::isClockTime
    {53, 1794, 1182},	// KDateTime::isDateOnly
    {53, 1835, 1189},	// KDateTime::isLocalZone
    {53, 1841, 1180},	// KDateTime::isNull
    {53, 1842, 1192},	// KDateTime::isOffsetFromUtc
    {53, 1853, 1194},	// KDateTime::isSecondOccurrence
    {53, 1868, 1191},	// KDateTime::isUtc
    {53, 1871, 1181},	// KDateTime::isValid
    {53, 2159, 1232},	// KDateTime::operator!=#
    {53, 2169, 1233},	// KDateTime::operator<#
    {53, 2178, 1234},	// KDateTime::operator<=#
    {53, 2183, 1179},	// KDateTime::operator=#
    {53, 2186, 1231},	// KDateTime::operator==#
    {53, 2192, 1235},	// KDateTime::operator>#
    {53, 2197, 1236},	// KDateTime::operator>=#
    {53, 2209, 1229},	// KDateTime::outOfRange
    {53, 2390, 1239},	// KDateTime::realCurrentLocalDateTime
    {53, 2471, 1216},	// KDateTime::secsTo#
    {53, 2473, 1217},	// KDateTime::secsTo_long#
    {53, 2572, 1206},	// KDateTime::setDate#
    {53, 2585, 1205},	// KDateTime::setDateOnly$
    {53, 2587, 1208},	// KDateTime::setDateTime#
    {53, 2649, 1228},	// KDateTime::setFromStringDefault#
    {53, 2854, 1210},	// KDateTime::setSecondOccurrence$
    {53, 2870, 1238},	// KDateTime::setSimulatedSystemTime#
    {53, 2889, 1207},	// KDateTime::setTime#
    {53, 2893, 1209},	// KDateTime::setTimeSpec#
    {53, 2895, 1204},	// KDateTime::setTime_t$
    {53, 3095, 1184},	// KDateTime::time
    {53, 3097, 1187},	// KDateTime::timeSpec
    {53, 3099, 1188},	// KDateTime::timeType
    {53, 3100, 1186},	// KDateTime::timeZone
    {53, 3103, 1199},	// KDateTime::toClockTime
    {53, 3108, 1198},	// KDateTime::toLocalZone
    {53, 3110, 1196},	// KDateTime::toOffsetFromUtc
    {53, 3111, 1197},	// KDateTime::toOffsetFromUtc$
    {53, 3112, 1242},	// KDateTime::toString
    {53, 3115, -225},	// KDateTime::toString$
    {53, 3117, -228},	// KDateTime::toTimeSpec#
    {53, 3118, 1203},	// KDateTime::toTime_t
    {53, 3120, 1195},	// KDateTime::toUtc
    {53, 3123, 1200},	// KDateTime::toZone#
    {53, 3221, 1193},	// KDateTime::utcOffset
    {53, 3374, 1268},	// KDateTime::~KDateTime
    {54, 60, 1288},	// KDateTime::Spec::ClockTime
    {54, 588, 1290},	// KDateTime::Spec::LocalZone
    {54, 644, 1289},	// KDateTime::Spec::OffsetFromUTC$
    {54, 727, 1269},	// KDateTime::Spec::Spec
    {54, 728, -522},	// KDateTime::Spec::Spec#
    {54, 729, 1291},	// KDateTime::Spec::Spec$
    {54, 730, 1271},	// KDateTime::Spec::Spec$$
    {54, 772, 1287},	// KDateTime::Spec::UTC
    {54, 1427, 1286},	// KDateTime::Spec::equivalentTo#
    {54, 1789, 1278},	// KDateTime::Spec::isClockTime
    {54, 1835, 1277},	// KDateTime::Spec::isLocalZone
    {54, 1842, 1280},	// KDateTime::Spec::isOffsetFromUtc
    {54, 1868, 1279},	// KDateTime::Spec::isUtc
    {54, 1871, 1274},	// KDateTime::Spec::isValid
    {54, 2159, 1285},	// KDateTime::Spec::operator!=#
    {54, 2183, 1273},	// KDateTime::Spec::operator=#
    {54, 2186, 1284},	// KDateTime::Spec::operator==#
    {54, 2905, 1283},	// KDateTime::Spec::setType#
    {54, 2906, 1292},	// KDateTime::Spec::setType$
    {54, 2907, 1282},	// KDateTime::Spec::setType$$
    {54, 3100, 1275},	// KDateTime::Spec::timeZone
    {54, 3174, 1276},	// KDateTime::Spec::type
    {54, 3221, 1281},	// KDateTime::Spec::utcOffset
    {54, 3434, 1293},	// KDateTime::Spec::~Spec
    {55, 362, 1299},	// KDebug::KDebug#
    {55, 363, 1300},	// KDebug::KDebug$
    {55, 364, 1301},	// KDebug::KDebug$$
    {55, 365, 1302},	// KDebug::KDebug$$$
    {55, 366, 1294},	// KDebug::KDebug$$$$
    {55, 1686, 1295},	// KDebug::hasNullOutput$$$$
    {55, 1687, 1303},	// KDebug::hasNullOutputQtDebugMsg
    {55, 1688, -516},	// KDebug::hasNullOutputQtDebugMsg$
    {55, 1689, 1297},	// KDebug::hasNullOutputQtDebugMsg$$
    {55, 2398, 1305},	// KDebug::registerArea#
    {55, 2399, 1298},	// KDebug::registerArea#$
    {55, 3375, 1306},	// KDebug::~KDebug
    {56, 367, 1307},	// KDebugTag::KDebugTag
    {56, 368, 1308},	// KDebugTag::KDebugTag#
    {56, 3376, 1309},	// KDebugTag::~KDebugTag
    {57, 370, 1311},	// KDesktopFile::KDesktopFile$
    {57, 371, 1310},	// KDesktopFile::KDesktopFile$$
    {57, 836, -321},	// KDesktopFile::actionGroup$
    {57, 1195, 1336},	// KDesktopFile::copyTo$
    {57, 1355, 1315},	// KDesktopFile::desktopGroup
    {57, 1498, 1337},	// KDesktopFile::fileName
    {57, 1661, 1327},	// KDesktopFile::hasActionGroup$
    {57, 1662, 1329},	// KDesktopFile::hasApplicationType
    {57, 1667, 1331},	// KDesktopFile::hasDeviceType
    {57, 1678, 1328},	// KDesktopFile::hasLinkType
    {57, 1684, 1330},	// KDesktopFile::hasMimeTypeType
    {57, 1777, 1313},	// KDesktopFile::isAuthorizedDesktopFile$
    {57, 1799, 1312},	// KDesktopFile::isDesktopFile$
    {57, 1997, 1314},	// KDesktopFile::locateLocal$
    {57, 2120, 1335},	// KDesktopFile::noDisplay
    {57, 2332, 1324},	// KDesktopFile::readActions
    {57, 2333, 1319},	// KDesktopFile::readComment
    {57, 2346, 1322},	// KDesktopFile::readDevice
    {57, 2347, 1333},	// KDesktopFile::readDocPath
    {57, 2357, 1320},	// KDesktopFile::readGenericName
    {57, 2359, 1317},	// KDesktopFile::readIcon
    {57, 2371, 1318},	// KDesktopFile::readName
    {57, 2375, 1321},	// KDesktopFile::readPath
    {57, 2383, 1316},	// KDesktopFile::readType
    {57, 2384, 1323},	// KDesktopFile::readUrl
    {57, 2446, 1338},	// KDesktopFile::resource
    {57, 2954, 1334},	// KDesktopFile::sortOrder
    {57, 3173, 1332},	// KDesktopFile::tryExec
    {57, 3377, 1339},	// KDesktopFile::~KDesktopFile
    {58, 22, 1372},	// KEncodingDetector::Arabic
    {58, 32, 1364},	// KEncodingDetector::AutoDetectedEncoding
    {58, 34, 1365},	// KEncodingDetector::BOM
    {58, 39, 1373},	// KEncodingDetector::Baltic
    {58, 49, 1374},	// KEncodingDetector::CentralEuropean
    {58, 54, 1375},	// KEncodingDetector::ChineseSimplified
    {58, 55, 1376},	// KEncodingDetector::ChineseTraditional
    {58, 75, 1377},	// KEncodingDetector::Cyrillic
    {58, 98, 1363},	// KEncodingDetector::DefaultEncoding
    {58, 112, 1368},	// KEncodingDetector::EncodingFromHTTPHeader
    {58, 113, 1367},	// KEncodingDetector::EncodingFromMetaTag
    {58, 114, 1366},	// KEncodingDetector::EncodingFromXMLHeader
    {58, 152, 1378},	// KEncodingDetector::Greek
    {58, 156, 1379},	// KEncodingDetector::Hebrew
    {58, 273, 1380},	// KEncodingDetector::Japanese
    {58, 372, 1340},	// KEncodingDetector::KEncodingDetector
    {58, 373, 1361},	// KEncodingDetector::KEncodingDetector#
    {58, 374, 1362},	// KEncodingDetector::KEncodingDetector#$
    {58, 375, 1341},	// KEncodingDetector::KEncodingDetector#$$
    {58, 564, 1381},	// KEncodingDetector::Korean
    {58, 633, 1370},	// KEncodingDetector::None
    {58, 637, 1382},	// KEncodingDetector::NorthernSaami
    {58, 706, 1371},	// KEncodingDetector::SemiautomaticDetection
    {58, 726, 1383},	// KEncodingDetector::SouthEasternEurope
    {58, 752, 1384},	// KEncodingDetector::Thai
    {58, 770, 1385},	// KEncodingDetector::Turkish
    {58, 777, 1386},	// KEncodingDetector::Unicode
    {58, 803, 1369},	// KEncodingDetector::UserChosenEncoding
    {58, 809, 1387},	// KEncodingDetector::WesternEuropean
    {58, 1028, 1359},	// KEncodingDetector::analyze$$
    {58, 1051, 1346},	// KEncodingDetector::autoDetectLanguage
    {58, 1309, 1349},	// KEncodingDetector::decode#
    {58, 1310, 1348},	// KEncodingDetector::decode$$
    {58, 1314, 1350},	// KEncodingDetector::decodeWithBuffering$$
    {58, 1317, 1351},	// KEncodingDetector::decodedInvalidCharacters
    {58, 1318, 1360},	// KEncodingDetector::decoder
    {58, 1406, 1343},	// KEncodingDetector::encoding
    {58, 1407, 1347},	// KEncodingDetector::encodingChoiceSource
    {58, 1441, 1358},	// KEncodingDetector::errorsIfUtf8$$
    {58, 1568, 1353},	// KEncodingDetector::flush
    {58, 1664, 1356},	// KEncodingDetector::hasAutoDetectionForScript$
    {58, 2107, 1355},	// KEncodingDetector::nameForScript$
    {58, 2265, 1357},	// KEncodingDetector::processNull$$
    {58, 2439, 1352},	// KEncodingDetector::resetDecoder
    {58, 2469, 1354},	// KEncodingDetector::scriptForName$
    {58, 2518, 1345},	// KEncodingDetector::setAutoDetectLanguage$
    {58, 2617, 1342},	// KEncodingDetector::setEncoding$$
    {58, 3240, 1344},	// KEncodingDetector::visuallyOrdered
    {58, 3378, 1388},	// KEncodingDetector::~KEncodingDetector
    {59, 22, 1408},	// KEncodingProber::Arabic
    {59, 39, 1409},	// KEncodingProber::Baltic
    {59, 49, 1410},	// KEncodingProber::CentralEuropean
    {59, 54, 1411},	// KEncodingProber::ChineseSimplified
    {59, 55, 1412},	// KEncodingProber::ChineseTraditional
    {59, 75, 1413},	// KEncodingProber::Cyrillic
    {59, 145, 1403},	// KEncodingProber::FoundIt
    {59, 152, 1414},	// KEncodingProber::Greek
    {59, 156, 1415},	// KEncodingProber::Hebrew
    {59, 273, 1416},	// KEncodingProber::Japanese
    {59, 376, 1402},	// KEncodingProber::KEncodingProber
    {59, 377, 1401},	// KEncodingProber::KEncodingProber#
    {59, 378, 1389},	// KEncodingProber::KEncodingProber$
    {59, 564, 1417},	// KEncodingProber::Korean
    {59, 633, 1406},	// KEncodingProber::None
    {59, 637, 1418},	// KEncodingProber::NorthernSaami
    {59, 638, 1404},	// KEncodingProber::NotMe
    {59, 653, 1419},	// KEncodingProber::Other
    {59, 670, 1405},	// KEncodingProber::Probing
    {59, 726, 1420},	// KEncodingProber::SouthEasternEurope
    {59, 752, 1421},	// KEncodingProber::Thai
    {59, 770, 1422},	// KEncodingProber::Turkish
    {59, 777, 1423},	// KEncodingProber::Unicode
    {59, 789, 1407},	// KEncodingProber::Universal
    {59, 809, 1424},	// KEncodingProber::WesternEuropean
    {59, 1167, 1396},	// KEncodingProber::confidence
    {59, 1406, 1395},	// KEncodingProber::encoding
    {59, 1411, 1394},	// KEncodingProber::encodingName
    {59, 1492, 1391},	// KEncodingProber::feed#
    {59, 1493, 1392},	// KEncodingProber::feed$$
    {59, 2105, 1400},	// KEncodingProber::nameForProberType$
    {59, 2261, 1397},	// KEncodingProber::proberType
    {59, 2263, 1399},	// KEncodingProber::proberTypeForName$
    {59, 2438, 1390},	// KEncodingProber::reset
    {59, 2828, 1398},	// KEncodingProber::setProberType$
    {59, 3028, 1393},	// KEncodingProber::state
    {59, 3379, 1425},	// KEncodingProber::~KEncodingProber
    {60, 115, 1453},	// KFilterBase::End
    {60, 125, 1454},	// KFilterBase::Error
    {60, 379, 1426},	// KFilterBase::KFilterBase
    {60, 625, 1455},	// KFilterBase::NoHeaders
    {60, 645, 1452},	// KFilterBase::Ok
    {60, 810, 1456},	// KFilterBase::WithHeaders
    {60, 1166, 1442},	// KFilterBase::compress$
    {60, 1362, 1428},	// KFilterBase::device
    {60, 1501, 1444},	// KFilterBase::filterFlags
    {60, 1546, 1445},	// KFilterBase::findFilterByFileName$
    {60, 1548, 1446},	// KFilterBase::findFilterByMimeType$
    {60, 1720, 1438},	// KFilterBase::inBufferAvailable
    {60, 1721, 1437},	// KFilterBase::inBufferEmpty
    {60, 1733, 1429},	// KFilterBase::init$
    {60, 2013, 1450},	// KFilterBase::m_bAutoDel
    {60, 2019, 1448},	// KFilterBase::m_dev
    {60, 2070, 1430},	// KFilterBase::mode
    {60, 2207, 1440},	// KFilterBase::outBufferAvailable
    {60, 2208, 1439},	// KFilterBase::outBufferFull
    {60, 2358, 1433},	// KFilterBase::readHeader
    {60, 2438, 1432},	// KFilterBase::reset
    {60, 2605, 1447},	// KFilterBase::setDevice#
    {60, 2606, 1427},	// KFilterBase::setDevice#$
    {60, 2643, 1443},	// KFilterBase::setFilterFlags$
    {60, 2661, 1436},	// KFilterBase::setInBuffer$$
    {60, 2703, 1451},	// KFilterBase::setM_bAutoDel$
    {60, 2715, 1449},	// KFilterBase::setM_dev#
    {60, 2801, 1435},	// KFilterBase::setOutBuffer$$
    {60, 3088, 1431},	// KFilterBase::terminate
    {60, 3179, 1441},	// KFilterBase::uncompress
    {60, 3300, 1434},	// KFilterBase::writeHeader#
    {60, 3380, 1457},	// KFilterBase::~KFilterBase
    {61, 1038, 1463},	// KFilterDev::atEnd
    {61, 1149, 1459},	// KFilterDev::close
    {61, 1363, 1470},	// KFilterDev::device#$
    {61, 1364, 1465},	// KFilterDev::device#$$
    {61, 1366, 1468},	// KFilterDev::deviceForFile$
    {61, 1367, 1469},	// KFilterDev::deviceForFile$$
    {61, 1368, 1464},	// KFilterDev::deviceForFile$$$
    {61, 2146, 1458},	// KFilterDev::open$
    {61, 2337, 1466},	// KFilterDev::readData$$
    {61, 2475, 1462},	// KFilterDev::seek$
    {61, 2797, 1460},	// KFilterDev::setOrigFileName#
    {61, 2871, 1461},	// KFilterDev::setSkipHeaders
    {61, 3291, 1467},	// KFilterDev::writeData$$
    {61, 3381, 1471},	// KFilterDev::~KFilterDev
    {62, 106, 1492},	// KGlobal::DoCopyCatalogs
    {62, 108, 1493},	// KGlobal::DontCopyCatalogs
    {62, 841, 1488},	// KGlobal::activeComponent
    {62, 1108, 1481},	// KGlobal::caption
    {62, 1121, 1474},	// KGlobal::charsets
    {62, 1168, 1484},	// KGlobal::config
    {62, 1343, 1491},	// KGlobal::deref
    {62, 1377, 1479},	// KGlobal::dirs
    {62, 1534, 1487},	// KGlobal::findDirectChild_helper##
    {62, 1679, 1486},	// KGlobal::hasLocale
    {62, 1680, 1490},	// KGlobal::hasMainComponent
    {62, 1743, 1483},	// KGlobal::insertCatalog$
    {62, 1987, 1482},	// KGlobal::locale
    {62, 2038, 1472},	// KGlobal::mainComponent
    {62, 2396, 1476},	// KGlobal::ref
    {62, 2501, 1489},	// KGlobal::setActiveComponent#
    {62, 2505, 1475},	// KGlobal::setAllowQuit$
    {62, 2693, 1478},	// KGlobal::setLocale#
    {62, 2694, 1477},	// KGlobal::setLocale#$
    {62, 3032, -188},	// KGlobal::staticQString$
    {62, 3177, 1480},	// KGlobal::umask
    {63, 46, 1544},	// KJob::Bytes
    {63, 104, 1546},	// KJob::Directories
    {63, 111, 1551},	// KJob::EmitResult
    {63, 140, 1545},	// KJob::Files
    {63, 380, 1537},	// KJob::KJob
    {63, 381, 1501},	// KJob::KJob#
    {63, 382, 1534},	// KJob::KJob##
    {63, 562, 1548},	// KJob::Killable
    {63, 563, 1553},	// KJob::KilledJobError
    {63, 619, 1547},	// KJob::NoCapabilities
    {63, 623, 1552},	// KJob::NoError
    {63, 681, 1550},	// KJob::Quietly
    {63, 742, 1549},	// KJob::Suspendable
    {63, 804, 1554},	// KJob::UserDefinedError
    {63, 1106, 1504},	// KJob::capabilities
    {63, 1345, 1539},	// KJob::description#$
    {63, 1346, 1540},	// KJob::description#$?
    {63, 1347, 1523},	// KJob::description#$??
    {63, 1382, 1510},	// KJob::doKill
    {63, 1383, 1512},	// KJob::doResume
    {63, 1384, 1511},	// KJob::doSuspend
    {63, 1393, 1532},	// KJob::emitPercent$$
    {63, 1394, 1531},	// KJob::emitResult
    {63, 1396, 1533},	// KJob::emitSpeed$
    {63, 1434, 1515},	// KJob::error
    {63, 1437, 1517},	// KJob::errorString
    {63, 1439, 1516},	// KJob::errorText
    {63, 1446, 1514},	// KJob::exec
    {63, 1727, 1541},	// KJob::infoMessage#$
    {63, 1728, 1524},	// KJob::infoMessage#$$
    {63, 1778, 1522},	// KJob::isAutoDelete
    {63, 1863, 1505},	// KJob::isSuspended
    {63, 1938, 1538},	// KJob::kill
    {63, 1939, 1507},	// KJob::kill$
    {63, 2060, 1494},	// KJob::metaObject
    {63, 2230, 1520},	// KJob::percent
    {63, 2268, 1518},	// KJob::processedAmount$
    {63, 2300, 1500},	// KJob::qt_metacall$$?
    {63, 2302, 1495},	// KJob::qt_metacast$
    {63, 2451, 1509},	// KJob::resume
    {63, 2516, 1521},	// KJob::setAutoDelete$
    {63, 2536, 1513},	// KJob::setCapabilities$
    {63, 2622, 1526},	// KJob::setError$
    {63, 2628, 1527},	// KJob::setErrorText$
    {63, 2813, 1530},	// KJob::setPercent$
    {63, 2830, 1528},	// KJob::setProcessedAmount$$
    {63, 2899, 1529},	// KJob::setTotalAmount$$
    {63, 2909, 1502},	// KJob::setUiDelegate#
    {63, 2972, 1506},	// KJob::start
    {63, 3030, 1543},	// KJob::staticMetaObject
    {63, 3063, 1508},	// KJob::suspend
    {63, 3130, 1519},	// KJob::totalAmount$
    {63, 3132, 1535},	// KJob::tr$
    {63, 3133, 1496},	// KJob::tr$$
    {63, 3134, 1498},	// KJob::tr$$$
    {63, 3139, 1536},	// KJob::trUtf8$
    {63, 3140, 1497},	// KJob::trUtf8$$
    {63, 3141, 1499},	// KJob::trUtf8$$$
    {63, 3175, 1503},	// KJob::uiDelegate
    {63, 3249, 1542},	// KJob::warning#$
    {63, 3250, 1525},	// KJob::warning#$$
    {63, 3382, 1555},	// KJob::~KJob
    {65, 383, 1578},	// KJobTrackerInterface::KJobTrackerInterface
    {65, 384, 1563},	// KJobTrackerInterface::KJobTrackerInterface#
    {65, 1347, 1569},	// KJobTrackerInterface::description#$??
    {65, 1559, 1566},	// KJobTrackerInterface::finished#
    {65, 1728, 1570},	// KJobTrackerInterface::infoMessage#$$
    {65, 2060, 1556},	// KJobTrackerInterface::metaObject
    {65, 2231, 1574},	// KJobTrackerInterface::percent#$
    {65, 2267, 1573},	// KJobTrackerInterface::processedAmount#$$
    {65, 2300, 1562},	// KJobTrackerInterface::qt_metacall$$?
    {65, 2302, 1557},	// KJobTrackerInterface::qt_metacast$
    {65, 2401, 1564},	// KJobTrackerInterface::registerJob#
    {65, 2453, 1568},	// KJobTrackerInterface::resumed#
    {65, 2957, 1575},	// KJobTrackerInterface::speed#$
    {65, 3030, 1579},	// KJobTrackerInterface::staticMetaObject
    {65, 3065, 1567},	// KJobTrackerInterface::suspended#
    {65, 3129, 1572},	// KJobTrackerInterface::totalAmount#$$
    {65, 3132, 1576},	// KJobTrackerInterface::tr$
    {65, 3133, 1558},	// KJobTrackerInterface::tr$$
    {65, 3134, 1560},	// KJobTrackerInterface::tr$$$
    {65, 3139, 1577},	// KJobTrackerInterface::trUtf8$
    {65, 3140, 1559},	// KJobTrackerInterface::trUtf8$$
    {65, 3141, 1561},	// KJobTrackerInterface::trUtf8$$$
    {65, 3186, 1565},	// KJobTrackerInterface::unregisterJob#
    {65, 3250, 1571},	// KJobTrackerInterface::warning#$$
    {65, 3383, 1580},	// KJobTrackerInterface::~KJobTrackerInterface
    {66, 385, 1588},	// KJobUiDelegate::KJobUiDelegate
    {66, 1779, 1592},	// KJobUiDelegate::isAutoErrorHandlingEnabled
    {66, 1780, 1594},	// KJobUiDelegate::isAutoWarningHandlingEnabled
    {66, 1883, 1589},	// KJobUiDelegate::job
    {66, 2060, 1581},	// KJobUiDelegate::metaObject
    {66, 2300, 1587},	// KJobUiDelegate::qt_metacall$$?
    {66, 2302, 1582},	// KJobUiDelegate::qt_metacast$
    {66, 2520, 1591},	// KJobUiDelegate::setAutoErrorHandlingEnabled$
    {66, 2524, 1593},	// KJobUiDelegate::setAutoWarningHandlingEnabled$
    {66, 2937, 1590},	// KJobUiDelegate::showErrorMessage
    {66, 2953, 1595},	// KJobUiDelegate::slotWarning#$$
    {66, 3030, 1598},	// KJobUiDelegate::staticMetaObject
    {66, 3132, 1596},	// KJobUiDelegate::tr$
    {66, 3133, 1583},	// KJobUiDelegate::tr$$
    {66, 3134, 1585},	// KJobUiDelegate::tr$$$
    {66, 3139, 1597},	// KJobUiDelegate::trUtf8$
    {66, 3140, 1584},	// KJobUiDelegate::trUtf8$$
    {66, 3141, 1586},	// KJobUiDelegate::trUtf8$$$
    {66, 3384, 1599},	// KJobUiDelegate::~KJobUiDelegate
    {67, 120, 1622},	// KLibLoader::ErrNoComponent
    {67, 121, 1621},	// KLibLoader::ErrNoFactory
    {67, 122, 1620},	// KLibLoader::ErrNoLibrary
    {67, 123, 1624},	// KLibLoader::ErrNoServiceFound
    {67, 124, 1623},	// KLibLoader::ErrServiceProvidesNoLibrary
    {67, 1438, 1613},	// KLibLoader::errorString$
    {67, 1486, 1616},	// KLibLoader::factory$
    {67, 1487, 1607},	// KLibLoader::factory$$
    {67, 1552, 1618},	// KLibLoader::findLibrary$
    {67, 1553, 1612},	// KLibLoader::findLibrary$#
    {67, 1959, 1609},	// KLibLoader::lastErrorMessage
    {67, 1968, 1617},	// KLibLoader::library$
    {67, 1969, 1608},	// KLibLoader::library$$
    {67, 2060, 1600},	// KLibLoader::metaObject
    {67, 2300, 1606},	// KLibLoader::qt_metacall$$?
    {67, 2302, 1601},	// KLibLoader::qt_metacast$
    {67, 2476, 1611},	// KLibLoader::self
    {67, 3030, 1619},	// KLibLoader::staticMetaObject
    {67, 3132, 1614},	// KLibLoader::tr$
    {67, 3133, 1602},	// KLibLoader::tr$$
    {67, 3134, 1604},	// KLibLoader::tr$$$
    {67, 3139, 1615},	// KLibLoader::trUtf8$
    {67, 3140, 1603},	// KLibLoader::trUtf8$$
    {67, 3141, 1605},	// KLibLoader::trUtf8$$$
    {67, 3183, 1610},	// KLibLoader::unloadLibrary$
    {68, 386, 1642},	// KLibrary::KLibrary
    {68, 387, 1632},	// KLibrary::KLibrary#
    {68, 388, 1643},	// KLibrary::KLibrary$
    {68, 389, 1644},	// KLibrary::KLibrary$#
    {68, 390, 1633},	// KLibrary::KLibrary$##
    {68, 391, 1645},	// KLibrary::KLibrary$$
    {68, 392, 1646},	// KLibrary::KLibrary$$#
    {68, 393, 1634},	// KLibrary::KLibrary$$##
    {68, 1485, 1647},	// KLibrary::factory
    {68, 1486, 1635},	// KLibrary::factory$
    {68, 2060, 1625},	// KLibrary::metaObject
    {68, 2300, 1631},	// KLibrary::qt_metacall$$?
    {68, 2302, 1626},	// KLibrary::qt_metacast$
    {68, 2443, 1637},	// KLibrary::resolveFunction$
    {68, 2445, 1636},	// KLibrary::resolveSymbol$
    {68, 2640, 1648},	// KLibrary::setFileName$
    {68, 2641, 1638},	// KLibrary::setFileName$#
    {68, 3030, 1649},	// KLibrary::staticMetaObject
    {68, 3132, 1640},	// KLibrary::tr$
    {68, 3133, 1627},	// KLibrary::tr$$
    {68, 3134, 1629},	// KLibrary::tr$$$
    {68, 3139, 1641},	// KLibrary::trUtf8$
    {68, 3140, 1628},	// KLibrary::trUtf8$$
    {68, 3141, 1630},	// KLibrary::trUtf8$$$
    {68, 3181, 1639},	// KLibrary::unload
    {68, 3385, 1650},	// KLibrary::~KLibrary
    {69, 3, 1674},	// KLocalSocket::AbstractUnixSocket
    {69, 394, 1669},	// KLocalSocket::KLocalSocket
    {69, 395, 1658},	// KLocalSocket::KLocalSocket#
    {69, 790, 1673},	// KLocalSocket::UnixSocket
    {69, 793, 1675},	// KLocalSocket::UnknownLocalSocketType
    {69, 1179, 1665},	// KLocalSocket::connectToHostImplementation$$$
    {69, 1181, 1670},	// KLocalSocket::connectToPath$
    {69, 1182, -45},	// KLocalSocket::connectToPath$$
    {69, 1183, 1660},	// KLocalSocket::connectToPath$$$
    {69, 1379, 1666},	// KLocalSocket::disconnectFromHostImplementation
    {69, 1380, 1661},	// KLocalSocket::disconnectFromPath
    {69, 1985, 1663},	// KLocalSocket::localPath
    {69, 1986, 1662},	// KLocalSocket::localSocketType
    {69, 2060, 1651},	// KLocalSocket::metaObject
    {69, 2229, 1664},	// KLocalSocket::peerPath
    {69, 2300, 1657},	// KLocalSocket::qt_metacall$$?
    {69, 2302, 1652},	// KLocalSocket::qt_metacast$
    {69, 3030, 1672},	// KLocalSocket::staticMetaObject
    {69, 3132, 1667},	// KLocalSocket::tr$
    {69, 3133, 1653},	// KLocalSocket::tr$$
    {69, 3134, 1655},	// KLocalSocket::tr$$$
    {69, 3139, 1668},	// KLocalSocket::trUtf8$
    {69, 3140, 1654},	// KLocalSocket::trUtf8$$
    {69, 3141, 1656},	// KLocalSocket::trUtf8$$$
    {69, 3386, 1676},	// KLocalSocket::~KLocalSocket
    {70, 396, 1701},	// KLocalSocketServer::KLocalSocketServer
    {70, 397, 1684},	// KLocalSocketServer::KLocalSocketServer#
    {70, 1149, 1686},	// KLocalSocketServer::close
    {70, 1437, 1696},	// KLocalSocketServer::errorString
    {70, 1692, 1693},	// KLocalSocketServer::hasPendingConnections
    {70, 1725, 1697},	// KLocalSocketServer::incomingConnection$
    {70, 1832, 1687},	// KLocalSocketServer::isListening
    {70, 1975, 1702},	// KLocalSocketServer::listen$
    {70, 1979, 1685},	// KLocalSocketServer::listen$$
    {70, 1985, 1691},	// KLocalSocketServer::localPath
    {70, 1986, 1690},	// KLocalSocketServer::localSocketType
    {70, 2049, 1689},	// KLocalSocketServer::maxPendingConnections
    {70, 2060, 1677},	// KLocalSocketServer::metaObject
    {70, 2114, 1698},	// KLocalSocketServer::newConnection
    {70, 2119, 1694},	// KLocalSocketServer::nextPendingConnection
    {70, 2300, 1683},	// KLocalSocketServer::qt_metacall$$?
    {70, 2302, 1678},	// KLocalSocketServer::qt_metacast$
    {70, 2478, 1695},	// KLocalSocketServer::serverError
    {70, 2761, 1688},	// KLocalSocketServer::setMaxPendingConnections$
    {70, 3030, 1705},	// KLocalSocketServer::staticMetaObject
    {70, 3132, 1699},	// KLocalSocketServer::tr$
    {70, 3133, 1679},	// KLocalSocketServer::tr$$
    {70, 3134, 1681},	// KLocalSocketServer::tr$$$
    {70, 3139, 1700},	// KLocalSocketServer::trUtf8$
    {70, 3140, 1680},	// KLocalSocketServer::trUtf8$$
    {70, 3141, 1682},	// KLocalSocketServer::trUtf8$$$
    {70, 3242, 1703},	// KLocalSocketServer::waitForNewConnection
    {70, 3243, 1704},	// KLocalSocketServer::waitForNewConnection$
    {70, 3244, 1692},	// KLocalSocketServer::waitForNewConnection$$
    {70, 3387, 1706},	// KLocalSocketServer::~KLocalSocketServer
    {71, 15, 1884},	// KLocale::AfterMoney
    {71, 16, 1882},	// KLocale::AfterQuantityMoney
    {71, 23, 1885},	// KLocale::ArabicDigits
    {71, 24, 1886},	// KLocale::ArabicIndicDigits
    {71, 42, 1883},	// KLocale::BeforeMoney
    {71, 43, 1881},	// KLocale::BeforeQuantityMoney
    {71, 44, 1889},	// KLocale::BengaliDigits
    {71, 71, 1916},	// KLocale::CopticCalendar
    {71, 84, 1940},	// KLocale::Day
    {71, 85, 1941},	// KLocale::DayName
    {71, 86, 1948},	// KLocale::DayOfWeek
    {71, 87, 1949},	// KLocale::DayOfWeekName
    {71, 88, 1946},	// KLocale::DayOfYear
    {71, 89, 1947},	// KLocale::DayOfYearName
    {71, 90, 1961},	// KLocale::DayPeriod
    {71, 91, 1962},	// KLocale::DayPeriodHour
    {71, 92, 1955},	// KLocale::DaysInMonth
    {71, 93, 1956},	// KLocale::DaysInWeek
    {71, 94, 1954},	// KLocale::DaysInYear
    {71, 95, 1910},	// KLocale::DefaultBinaryDialect
    {71, 96, 1899},	// KLocale::DefaultBinaryUnits
    {71, 97, 1966},	// KLocale::DefaultComponentFormat
    {71, 100, 1927},	// KLocale::DefaultWeekNumber
    {71, 103, 1888},	// KLocale::DevenagariDigits
    {71, 110, 1887},	// KLocale::EasternArabicIndicDigits
    {71, 118, 1943},	// KLocale::EraName
    {71, 119, 1944},	// KLocale::EraYear
    {71, 126, 1917},	// KLocale::EthiopianCalendar
    {71, 136, 1975},	// KLocale::FancyLongDate
    {71, 137, 1974},	// KLocale::FancyShortDate
    {71, 141, 1929},	// KLocale::FirstFullWeek
    {71, 142, 1930},	// KLocale::FirstPartialWeek
    {71, 153, 1918},	// KLocale::GregorianCalendar
    {71, 154, 1890},	// KLocale::GujaratiDigits
    {71, 155, 1891},	// KLocale::GurmukhiDigits
    {71, 157, 1919},	// KLocale::HebrewCalendar
    {71, 165, 1957},	// KLocale::Hour
    {71, 166, 1911},	// KLocale::IECBinaryDialect
    {71, 172, 1996},	// KLocale::Imperial
    {71, 174, 1921},	// KLocale::IndianNationalCalendar
    {71, 182, 1920},	// KLocale::IslamicCivilCalendar
    {71, 183, 1976},	// KLocale::IsoDate
    {71, 184, 1988},	// KLocale::IsoFormat
    {71, 185, 1978},	// KLocale::IsoOrdinalDate
    {71, 186, 1990},	// KLocale::IsoOrdinalFormat
    {71, 187, 1977},	// KLocale::IsoWeekDate
    {71, 188, 1989},	// KLocale::IsoWeekFormat
    {71, 189, 1928},	// KLocale::IsoWeekNumber
    {71, 271, 1912},	// KLocale::JEDECBinaryDialect
    {71, 272, 1922},	// KLocale::JalaliCalendar
    {71, 274, 1923},	// KLocale::JapaneseCalendar
    {71, 275, 1924},	// KLocale::JulianCalendar
    {71, 276, 1942},	// KLocale::JulianDay
    {71, 399, 1709},	// KLocale::KLocale#
    {71, 400, 1848},	// KLocale::KLocale$
    {71, 401, 1849},	// KLocale::KLocale$$
    {71, 402, 1850},	// KLocale::KLocale$$$
    {71, 403, 1708},	// KLocale::KLocale$$$#
    {71, 404, 1707},	// KLocale::KLocale$?
    {71, 557, 1892},	// KLocale::KannadaDigits
    {71, 558, 1932},	// KLocale::KdeFormat
    {71, 561, 1893},	// KLocale::KhmerDigits
    {71, 565, 1914},	// KLocale::LastBinaryDialect
    {71, 571, 1935},	// KLocale::LiberalParsing
    {71, 594, 1973},	// KLocale::LongDate
    {71, 597, 1971},	// KLocale::LongName
    {71, 599, 1968},	// KLocale::LongNumber
    {71, 601, 1894},	// KLocale::MalayalamDigits
    {71, 603, 1995},	// KLocale::Metric
    {71, 604, 1913},	// KLocale::MetricBinaryDialect
    {71, 605, 1960},	// KLocale::Millisecond
    {71, 606, 1925},	// KLocale::MinguoCalendar
    {71, 607, 1958},	// KLocale::Minute
    {71, 608, 1938},	// KLocale::Month
    {71, 609, 1939},	// KLocale::MonthName
    {71, 610, 1952},	// KLocale::MonthsInYear
    {71, 615, 1969},	// KLocale::NarrowName
    {71, 636, 1986},	// KLocale::NormalFormat
    {71, 652, 1895},	// KLocale::OriyaDigits
    {71, 655, 1880},	// KLocale::ParensAround
    {71, 669, 1933},	// KLocale::PosixFormat
    {71, 671, 1994},	// KLocale::ProcessNonStrict
    {71, 672, 1993},	// KLocale::ProcessStrict
    {71, 679, 1915},	// KLocale::QDateCalendar
    {71, 704, 1959},	// KLocale::Second
    {71, 705, 1980},	// KLocale::Seconds
    {71, 708, 1972},	// KLocale::ShortDate
    {71, 710, 1987},	// KLocale::ShortFormat
    {71, 711, 1970},	// KLocale::ShortName
    {71, 713, 1967},	// KLocale::ShortNumber
    {71, 715, 1931},	// KLocale::SimpleWeek
    {71, 748, 1896},	// KLocale::TamilDigits
    {71, 750, 1897},	// KLocale::TeluguDigits
    {71, 753, 1926},	// KLocale::ThaiCalendar
    {71, 754, 1898},	// KLocale::ThaiDigits
    {71, 756, 1981},	// KLocale::TimeDefault
    {71, 757, 1984},	// KLocale::TimeDuration
    {71, 758, 1985},	// KLocale::TimeFoldHours
    {71, 760, 1983},	// KLocale::TimeWithoutAmPm
    {71, 761, 1982},	// KLocale::TimeWithoutSeconds
    {71, 762, 1979},	// KLocale::TimeZone
    {71, 764, 1963},	// KLocale::Timezone
    {71, 765, 1964},	// KLocale::TimezoneName
    {71, 778, 1934},	// KLocale::UnicodeFormat
    {71, 779, 1900},	// KLocale::UnitByte
    {71, 780, 1906},	// KLocale::UnitExaByte
    {71, 781, 1903},	// KLocale::UnitGigaByte
    {71, 782, 1901},	// KLocale::UnitKiloByte
    {71, 783, 1909},	// KLocale::UnitLastUnit
    {71, 784, 1902},	// KLocale::UnitMegaByte
    {71, 785, 1905},	// KLocale::UnitPetaByte
    {71, 786, 1904},	// KLocale::UnitTeraByte
    {71, 787, 1908},	// KLocale::UnitYottaByte
    {71, 788, 1907},	// KLocale::UnitZettaByte
    {71, 791, 1965},	// KLocale::UnixTime
    {71, 806, 1950},	// KLocale::Week
    {71, 807, 1951},	// KLocale::WeekYear
    {71, 808, 1953},	// KLocale::WeeksInYear
    {71, 811, 1991},	// KLocale::WithSeconds
    {71, 812, 1992},	// KLocale::WithoutSeconds
    {71, 820, 1936},	// KLocale::Year
    {71, 821, 1945},	// KLocale::YearInEra
    {71, 822, 1937},	// KLocale::YearName
    {71, 1004, 1829},	// KLocale::allCountriesList
    {71, 1007, 1721},	// KLocale::allDigitSetsList
    {71, 1010, 1826},	// KLocale::allLanguagesList
    {71, 1081, 1746},	// KLocale::binaryUnitDialect
    {71, 1090, 1764},	// KLocale::calendar
    {71, 1094, 1766},	// KLocale::calendarSystem
    {71, 1100, 1765},	// KLocale::calendarType
    {71, 1153, 1787},	// KLocale::codecForEncoding
    {71, 1188, 1879},	// KLocale::convertDigits$$
    {71, 1189, 1846},	// KLocale::convertDigits$$$
    {71, 1191, 1839},	// KLocale::copyCatalogsTo#
    {71, 1200, 1781},	// KLocale::country
    {71, 1203, 1830},	// KLocale::countryCodeToName$
    {71, 1204, 1782},	// KLocale::countryDivisionCode
    {71, 1223, 1726},	// KLocale::currency
    {71, 1224, 1725},	// KLocale::currencyCode
    {71, 1225, 1784},	// KLocale::currencyCodeList
    {71, 1229, 1727},	// KLocale::currencySymbol
    {71, 1256, 1798},	// KLocale::dateFormat
    {71, 1257, 1799},	// KLocale::dateFormatShort
    {71, 1259, 1754},	// KLocale::dateMonthNamePossessive
    {71, 1262, 1757},	// KLocale::dateTimeDigitSet
    {71, 1278, 1867},	// KLocale::dayPeriodText#
    {71, 1279, 1759},	// KLocale::dayPeriodText#$
    {71, 1306, 1733},	// KLocale::decimalPlaces
    {71, 1307, 1722},	// KLocale::decimalSymbol
    {71, 1320, 1835},	// KLocale::defaultCountry
    {71, 1321, 1836},	// KLocale::defaultCurrencyCode
    {71, 1322, 1834},	// KLocale::defaultLanguage
    {71, 1369, 1724},	// KLocale::digitSet
    {71, 1371, 1851},	// KLocale::digitSetToName$
    {71, 1372, 1720},	// KLocale::digitSetToName$$
    {71, 1406, 1785},	// KLocale::encoding
    {71, 1410, 1786},	// KLocale::encodingMib
    {71, 1496, 1788},	// KLocale::fileEncodingMib
    {71, 1573, 1744},	// KLocale::formatByteSize$
    {71, 1574, 1857},	// KLocale::formatByteSize$$
    {71, 1575, 1858},	// KLocale::formatByteSize$$$
    {71, 1576, 1745},	// KLocale::formatByteSize$$$$
    {71, 1578, 1859},	// KLocale::formatDate#
    {71, 1579, 1751},	// KLocale::formatDate#$
    {71, 1583, -252},	// KLocale::formatDateTime#
    {71, 1584, -255},	// KLocale::formatDateTime#$
    {71, 1585, -258},	// KLocale::formatDateTime#$$
    {71, 1587, 1748},	// KLocale::formatDuration$
    {71, 1589, 1866},	// KLocale::formatLocaleTime#
    {71, 1590, 1756},	// KLocale::formatLocaleTime#$
    {71, 1592, 1743},	// KLocale::formatLong$
    {71, 1594, 1852},	// KLocale::formatMoney$
    {71, 1595, 1853},	// KLocale::formatMoney$$
    {71, 1596, 1740},	// KLocale::formatMoney$$$
    {71, 1598, -261},	// KLocale::formatNumber$
    {71, 1599, -264},	// KLocale::formatNumber$$
    {71, 1600, 1742},	// KLocale::formatNumber$$$
    {71, 1602, 1864},	// KLocale::formatTime#
    {71, 1603, 1865},	// KLocale::formatTime#$
    {71, 1604, 1755},	// KLocale::formatTime#$$
    {71, 1605, 1732},	// KLocale::fracDigits
    {71, 1743, 1822},	// KLocale::insertCatalog$
    {71, 1746, 1827},	// KLocale::installedLanguages
    {71, 1775, 1838},	// KLocale::isApplicationTranslatedInto$
    {71, 1945, 1878},	// KLocale::langLookup$
    {71, 1946, 1833},	// KLocale::langLookup$$
    {71, 1947, 1780},	// KLocale::language
    {71, 1949, 1828},	// KLocale::languageCodeToName$
    {71, 1952, 1783},	// KLocale::languageList
    {71, 1989, 1844},	// KLocale::localizedFilePath$
    {71, 2055, 1820},	// KLocale::measureSystem
    {71, 2078, 1734},	// KLocale::monetaryDecimalPlaces
    {71, 2079, 1728},	// KLocale::monetaryDecimalSymbol
    {71, 2080, 1739},	// KLocale::monetaryDigitSet
    {71, 2081, 1729},	// KLocale::monetaryThousandsSeparator
    {71, 2111, 1738},	// KLocale::negativeMonetarySignPosition
    {71, 2112, 1736},	// KLocale::negativePrefixCurrencySymbol
    {71, 2113, 1731},	// KLocale::negativeSign
    {71, 2123, 1750},	// KLocale::nounDeclension
    {71, 2183, 1710},	// KLocale::operator=#
    {71, 2211, 1818},	// KLocale::pageSize
    {71, 2248, 1737},	// KLocale::positiveMonetarySignPosition
    {71, 2249, 1735},	// KLocale::positivePrefixCurrencySymbol
    {71, 2250, 1730},	// KLocale::positiveSign
    {71, 2257, 1749},	// KLocale::prettyFormatDuration$
    {71, 2339, 1870},	// KLocale::readDate$
    {71, 2340, -267},	// KLocale::readDate$$
    {71, 2341, -271},	// KLocale::readDate$$$
    {71, 2364, 1875},	// KLocale::readLocaleTime$
    {71, 2365, 1876},	// KLocale::readLocaleTime$$
    {71, 2366, 1877},	// KLocale::readLocaleTime$$$
    {71, 2367, 1779},	// KLocale::readLocaleTime$$$$
    {71, 2369, 1868},	// KLocale::readMoney$
    {71, 2370, 1772},	// KLocale::readMoney$$
    {71, 2373, 1869},	// KLocale::readNumber$
    {71, 2374, 1773},	// KLocale::readNumber$$
    {71, 2380, 1873},	// KLocale::readTime$
    {71, 2381, -274},	// KLocale::readTime$$
    {71, 2382, 1778},	// KLocale::readTime$$$
    {71, 2415, 1845},	// KLocale::removeAcceleratorMarker$
    {71, 2417, 1823},	// KLocale::removeCatalog$
    {71, 2431, 1847},	// KLocale::reparseConfiguration
    {71, 2499, 1824},	// KLocale::setActiveCatalog$
    {71, 2528, 1747},	// KLocale::setBinaryUnitDialect$
    {71, 2532, 1767},	// KLocale::setCalendar$
    {71, 2534, 1768},	// KLocale::setCalendarSystem$
    {71, 2552, 1840},	// KLocale::setCountry$#
    {71, 2554, 1841},	// KLocale::setCountryDivisionCode$
    {71, 2556, 1815},	// KLocale::setCurrencyCode$
    {71, 2558, 1816},	// KLocale::setCurrencySymbol$
    {71, 2577, 1789},	// KLocale::setDateFormat$
    {71, 2579, 1790},	// KLocale::setDateFormatShort$
    {71, 2583, 1791},	// KLocale::setDateMonthNamePossessive$
    {71, 2589, 1793},	// KLocale::setDateTimeDigitSet$
    {71, 2591, 1811},	// KLocale::setDecimalPlaces$
    {71, 2593, 1801},	// KLocale::setDecimalSymbol$
    {71, 2608, 1805},	// KLocale::setDigitSet$
    {71, 2616, 1719},	// KLocale::setEncoding$
    {71, 2647, 1810},	// KLocale::setFracDigits$
    {71, 2676, 1842},	// KLocale::setLanguage$#
    {71, 2677, 1843},	// KLocale::setLanguage?
    {71, 2753, 1832},	// KLocale::setMainCatalog$
    {71, 2765, 1821},	// KLocale::setMeasureSystem$
    {71, 2775, 1812},	// KLocale::setMonetaryDecimalPlaces$
    {71, 2777, 1814},	// KLocale::setMonetaryDecimalSymbol$
    {71, 2779, 1817},	// KLocale::setMonetaryDigitSet$
    {71, 2781, 1813},	// KLocale::setMonetaryThousandsSeparator$
    {71, 2785, 1807},	// KLocale::setNegativeMonetarySignPosition$
    {71, 2787, 1809},	// KLocale::setNegativePrefixCurrencySymbol$
    {71, 2789, 1804},	// KLocale::setNegativeSign$
    {71, 2805, 1819},	// KLocale::setPageSize$
    {71, 2820, 1806},	// KLocale::setPositiveMonetarySignPosition$
    {71, 2822, 1808},	// KLocale::setPositivePrefixCurrencySymbol$
    {71, 2824, 1803},	// KLocale::setPositiveSign$
    {71, 2887, 1802},	// KLocale::setThousandsSeparator$
    {71, 2891, 1792},	// KLocale::setTimeFormat$
    {71, 2917, 1797},	// KLocale::setWeekDayOfPray$
    {71, 2919, 1769},	// KLocale::setWeekNumberSystem$
    {71, 2921, 1794},	// KLocale::setWeekStartDay$
    {71, 2925, 1796},	// KLocale::setWorkingWeekEndDay$
    {71, 2927, 1795},	// KLocale::setWorkingWeekStartDay$
    {71, 2967, 1831},	// KLocale::splitLocale$$$$$
    {71, 3092, 1723},	// KLocale::thousandsSeparator
    {71, 3096, 1800},	// KLocale::timeFormat
    {71, 3161, 1825},	// KLocale::translateQt$$$
    {71, 3163, 1712},	// KLocale::translateRaw$$$
    {71, 3164, 1714},	// KLocale::translateRaw$$$$
    {71, 3165, 1716},	// KLocale::translateRaw$$$$$
    {71, 3166, 1718},	// KLocale::translateRaw$$$$$$
    {71, 3168, 1711},	// KLocale::translateRawFrom$$$$
    {71, 3169, 1713},	// KLocale::translateRawFrom$$$$$
    {71, 3170, 1715},	// KLocale::translateRawFrom$$$$$$
    {71, 3171, 1717},	// KLocale::translateRawFrom$$$$$$$
    {71, 3205, 1758},	// KLocale::use12Clock
    {71, 3208, 1837},	// KLocale::useTranscript
    {71, 3264, 1763},	// KLocale::weekDayOfPray
    {71, 3271, -277},	// KLocale::weekNumberSystem
    {71, 3272, 1760},	// KLocale::weekStartDay
    {71, 3286, 1762},	// KLocale::workingWeekEndDay
    {71, 3287, 1761},	// KLocale::workingWeekStartDay
    {71, 3388, 1997},	// KLocale::~KLocale
    {72, 405, 1998},	// KLocalizedString::KLocalizedString
    {72, 406, 1999},	// KLocalizedString::KLocalizedString#
    {72, 1723, 2015},	// KLocalizedString::inContext$$
    {72, 1807, 2005},	// KLocalizedString::isEmpty
    {72, 2122, 2016},	// KLocalizedString::notifyCatalogsUpdated??
    {72, 2183, 2000},	// KLocalizedString::operator=#
    {72, 3046, 2039},	// KLocalizedString::subs#
    {72, 3047, 2040},	// KLocalizedString::subs#$
    {72, 3048, 2013},	// KLocalizedString::subs#$#
    {72, 3049, -389},	// KLocalizedString::subs$
    {72, 3050, -398},	// KLocalizedString::subs$$
    {72, 3051, 2014},	// KLocalizedString::subs$$#
    {72, 3052, -407},	// KLocalizedString::subs$$$
    {72, 3053, -415},	// KLocalizedString::subs$$$#
    {72, 3054, 2038},	// KLocalizedString::subs$$$$
    {72, 3055, 2012},	// KLocalizedString::subs$$$$#
    {72, 3112, 2001},	// KLocalizedString::toString
    {72, 3113, 2003},	// KLocalizedString::toString#
    {72, 3114, 2004},	// KLocalizedString::toString#$
    {72, 3115, 2002},	// KLocalizedString::toString$
    {72, 3389, 2043},	// KLocalizedString::~KLocalizedString
    {73, 143, 2059},	// KLockFile::ForceFlag
    {73, 408, 2051},	// KLockFile::KLockFile#
    {73, 409, 2052},	// KLockFile::KLockFile$
    {73, 410, 2044},	// KLockFile::KLockFile$#
    {73, 590, 2056},	// KLockFile::LockError
    {73, 591, 2055},	// KLockFile::LockFail
    {73, 592, 2054},	// KLockFile::LockOK
    {73, 593, 2057},	// KLockFile::LockStale
    {73, 618, 2058},	// KLockFile::NoBlockFlag
    {73, 1642, 2050},	// KLockFile::getLockInfo$$$
    {73, 1836, 2046},	// KLockFile::isLocked
    {73, 2003, 2053},	// KLockFile::lock
    {73, 2004, 2045},	// KLockFile::lock$
    {73, 2875, 2049},	// KLockFile::setStaleTime$
    {73, 2971, 2048},	// KLockFile::staleTime
    {73, 3184, 2047},	// KLockFile::unlock
    {73, 3390, 2060},	// KLockFile::~KLockFile
    {74, 411, 2061},	// KMD5::KMD5
    {74, 412, 2063},	// KMD5::KMD5#
    {74, 413, 2078},	// KMD5::KMD5$
    {74, 414, 2062},	// KMD5::KMD5$$
    {74, 1072, 2073},	// KMD5::base64Digest
    {74, 1502, 2077},	// KMD5::finalize
    {74, 1704, 2071},	// KMD5::hexDigest
    {74, 1705, 2072},	// KMD5::hexDigest#
    {74, 2323, 2069},	// KMD5::rawDigest
    {74, 2324, 2070},	// KMD5::rawDigest$
    {74, 2438, 2068},	// KMD5::reset
    {74, 3143, 2076},	// KMD5::transform$
    {74, 3193, -36},	// KMD5::update#
    {74, 3194, -39},	// KMD5::update$
    {74, 3195, -42},	// KMD5::update$$
    {74, 3232, 2075},	// KMD5::verify#
    {74, 3233, 2074},	// KMD5::verify$
    {74, 3391, 2081},	// KMD5::~KMD5
    {75, 1470, -191},	// KMacroExpander::expandMacros$?
    {75, 1471, -196},	// KMacroExpander::expandMacros$?#
    {75, 1475, -201},	// KMacroExpander::expandMacrosShellQuote$?
    {75, 1476, -206},	// KMacroExpander::expandMacrosShellQuote$?#
    {76, 415, 2107},	// KMacroExpanderBase::KMacroExpanderBase
    {76, 416, -318},	// KMacroExpanderBase::KMacroExpanderBase#
    {76, 1442, 2103},	// KMacroExpanderBase::escapeChar
    {76, 1464, 2105},	// KMacroExpanderBase::expandEscapedMacro$$?
    {76, 1469, 2099},	// KMacroExpanderBase::expandMacros$
    {76, 1473, 2101},	// KMacroExpanderBase::expandMacrosShellQuote$
    {76, 1474, 2100},	// KMacroExpanderBase::expandMacrosShellQuote$$
    {76, 1478, 2104},	// KMacroExpanderBase::expandPlainMacro$$?
    {76, 2630, 2102},	// KMacroExpanderBase::setEscapeChar#
    {76, 3392, 2108},	// KMacroExpanderBase::~KMacroExpanderBase
    {77, 125, 2112},	// KMessage::Error
    {77, 138, 2116},	// KMessage::Fatal
    {77, 175, 2113},	// KMessage::Information
    {77, 723, 2115},	// KMessage::Sorry
    {77, 805, 2114},	// KMessage::Warning
    {77, 2058, 2111},	// KMessage::message$$
    {77, 2059, 2110},	// KMessage::message$$$
    {77, 2769, 2109},	// KMessage::setMessageHandler#
    {78, 417, 2118},	// KMessageHandler::KMessageHandler
    {78, 418, 2119},	// KMessageHandler::KMessageHandler#
    {78, 2059, 2117},	// KMessageHandler::message$$$
    {78, 3393, 2120},	// KMessageHandler::~KMessageHandler
    {79, 109, 2171},	// KMimeType::DontResolveAlias
    {79, 420, 2151},	// KMimeType::KMimeType#
    {79, 421, 2149},	// KMimeType::KMimeType#$
    {79, 422, 2152},	// KMimeType::KMimeType#$$
    {79, 423, 2150},	// KMimeType::KMimeType$$$
    {79, 700, 2172},	// KMimeType::ResolveAliases
    {79, 1011, 2136},	// KMimeType::allMimeTypes
    {79, 1012, 2142},	// KMimeType::allParentMimeTypes
    {79, 1159, 2155},	// KMimeType::comment
    {79, 1160, 2124},	// KMimeType::comment#
    {79, 1324, 2137},	// KMimeType::defaultMimeType
    {79, 1325, 2138},	// KMimeType::defaultMimeTypePtr
    {79, 1482, 2146},	// KMimeType::extractKnownExtension$
    {79, 1490, 2123},	// KMimeType::favIconForUrl#
    {79, 1513, -327},	// KMimeType::findByContent#
    {79, 1514, -330},	// KMimeType::findByContent#$
    {79, 1516, 2170},	// KMimeType::findByFileContent$
    {79, 1517, 2133},	// KMimeType::findByFileContent$$
    {79, 1519, -333},	// KMimeType::findByNameAndContent$#
    {79, 1520, -336},	// KMimeType::findByNameAndContent$#?
    {79, 1521, -339},	// KMimeType::findByNameAndContent$#?$
    {79, 1523, 2161},	// KMimeType::findByPath$
    {79, 1524, 2162},	// KMimeType::findByPath$?
    {79, 1525, 2163},	// KMimeType::findByPath$?$
    {79, 1526, 2128},	// KMimeType::findByPath$?$$
    {79, 1528, 2157},	// KMimeType::findByUrl#
    {79, 1529, 2158},	// KMimeType::findByUrl#?
    {79, 1530, 2159},	// KMimeType::findByUrl#?$
    {79, 1531, 2160},	// KMimeType::findByUrl#?$$
    {79, 1532, 2127},	// KMimeType::findByUrl#?$$$
    {79, 1715, 2153},	// KMimeType::iconName
    {79, 1716, 2121},	// KMimeType::iconName#
    {79, 1718, 2154},	// KMimeType::iconNameForUrl#
    {79, 1719, 2122},	// KMimeType::iconNameForUrl#?
    {79, 1772, 2143},	// KMimeType::is$
    {79, 1783, 2134},	// KMimeType::isBinaryData$
    {79, 1785, 2135},	// KMimeType::isBufferBinaryData#
    {79, 1795, 2139},	// KMimeType::isDefault
    {79, 2039, 2145},	// KMimeType::mainExtension
    {79, 2048, 2147},	// KMimeType::matchFileName$$
    {79, 2062, 2156},	// KMimeType::mimeType$
    {79, 2063, 2126},	// KMimeType::mimeType$$
    {79, 2214, 2140},	// KMimeType::parentMimeType
    {79, 2215, 2141},	// KMimeType::parentMimeTypes
    {79, 2228, 2125},	// KMimeType::patterns
    {79, 2932, 2148},	// KMimeType::sharedMimeInfoVersion
    {79, 3212, 2144},	// KMimeType::userSpecifiedIconName
    {79, 3394, 2173},	// KMimeType::~KMimeType
    {81, 425, 2177},	// KMimeTypeTrader::KMimeTypeTrader#
    {81, 2254, 2180},	// KMimeTypeTrader::preferredService$
    {81, 2255, 2175},	// KMimeTypeTrader::preferredService$$
    {81, 2304, 2178},	// KMimeTypeTrader::query$
    {81, 2305, 2179},	// KMimeTypeTrader::query$$
    {81, 2306, 2174},	// KMimeTypeTrader::query$$$
    {81, 2476, 2176},	// KMimeTypeTrader::self
    {81, 3395, 2181},	// KMimeTypeTrader::~KMimeTypeTrader
    {83, 426, 2206},	// KPluginFactory::KPluginFactory
    {83, 427, -283},	// KPluginFactory::KPluginFactory#
    {83, 428, -288},	// KPluginFactory::KPluginFactory##
    {83, 429, 2207},	// KPluginFactory::KPluginFactory$
    {83, 430, 2208},	// KPluginFactory::KPluginFactory$$
    {83, 431, 2189},	// KPluginFactory::KPluginFactory$$#
    {83, 1163, 2193},	// KPluginFactory::componentData
    {83, 1205, 2211},	// KPluginFactory::create
    {83, 1206, 2212},	// KPluginFactory::create#
    {83, 1207, 2213},	// KPluginFactory::create#$
    {83, 1208, 2194},	// KPluginFactory::create#$?
    {83, 1211, 2203},	// KPluginFactory::create$##?$
    {83, 1216, 2200},	// KPluginFactory::createObject#$?
    {83, 1218, 2201},	// KPluginFactory::createPartObject##$?
    {83, 2060, 2182},	// KPluginFactory::metaObject
    {83, 2130, 2195},	// KPluginFactory::objectCreated#
    {83, 2300, 2188},	// KPluginFactory::qt_metacall$$?
    {83, 2302, 2183},	// KPluginFactory::qt_metacast$
    {83, 2544, 2202},	// KPluginFactory::setComponentData#
    {83, 2931, 2199},	// KPluginFactory::setupTranslations
    {83, 3030, 2215},	// KPluginFactory::staticMetaObject
    {83, 3043, 2197},	// KPluginFactory::stringListToVariantList?
    {83, 3132, 2204},	// KPluginFactory::tr$
    {83, 3133, 2184},	// KPluginFactory::tr$$
    {83, 3134, 2186},	// KPluginFactory::tr$$$
    {83, 3139, 2205},	// KPluginFactory::trUtf8$
    {83, 3140, 2185},	// KPluginFactory::trUtf8$$
    {83, 3141, 2187},	// KPluginFactory::trUtf8$$$
    {83, 3230, 2198},	// KPluginFactory::variantListToStringList?
    {83, 3396, 2216},	// KPluginFactory::~KPluginFactory
    {85, 432, 2219},	// KPluginInfo::KPluginInfo
    {85, 433, 2249},	// KPluginInfo::KPluginInfo#
    {85, 434, 2255},	// KPluginInfo::KPluginInfo$
    {85, 435, 2217},	// KPluginInfo::KPluginInfo$$
    {85, 436, 2218},	// KPluginInfo::KPluginInfo?
    {85, 1039, 2232},	// KPluginInfo::author
    {85, 1114, 2234},	// KPluginInfo::category
    {85, 1159, 2229},	// KPluginInfo::comment
    {85, 1168, 2244},	// KPluginInfo::config
    {85, 1330, 2247},	// KPluginInfo::defaults
    {85, 1342, 2240},	// KPluginInfo::dependencies
    {85, 1390, 2233},	// KPluginInfo::email
    {85, 1421, 2231},	// KPluginInfo::entryPath
    {85, 1612, 2257},	// KPluginInfo::fromFiles?
    {85, 1613, 2221},	// KPluginInfo::fromFiles?#
    {85, 1615, 2258},	// KPluginInfo::fromKPartsInstanceName$
    {85, 1616, 2222},	// KPluginInfo::fromKPartsInstanceName$#
    {85, 1624, 2256},	// KPluginInfo::fromServices?
    {85, 1625, 2220},	// KPluginInfo::fromServices?#
    {85, 1634, 2239},	// KPluginInfo::fullLicense
    {85, 1713, 2230},	// KPluginInfo::icon
    {85, 1823, 2223},	// KPluginInfo::isHidden
    {85, 1845, 2225},	// KPluginInfo::isPluginEnabled
    {85, 1846, 2226},	// KPluginInfo::isPluginEnabledByDefault
    {85, 1871, 2248},	// KPluginInfo::isValid
    {85, 1903, 2242},	// KPluginInfo::kcmServices
    {85, 1970, 2238},	// KPluginInfo::license
    {85, 1980, 2260},	// KPluginInfo::load
    {85, 1981, 2246},	// KPluginInfo::load#
    {85, 2102, 2228},	// KPluginInfo::name
    {85, 2159, 2252},	// KPluginInfo::operator!=#
    {85, 2169, 2253},	// KPluginInfo::operator<#
    {85, 2183, 2250},	// KPluginInfo::operator=#
    {85, 2186, 2251},	// KPluginInfo::operator==#
    {85, 2192, 2254},	// KPluginInfo::operator>#
    {85, 2241, 2235},	// KPluginInfo::pluginName
    {85, 2278, 2227},	// KPluginInfo::property$
    {85, 2460, 2259},	// KPluginInfo::save
    {85, 2461, 2245},	// KPluginInfo::save#
    {85, 2479, 2241},	// KPluginInfo::service
    {85, 2546, 2243},	// KPluginInfo::setConfig#
    {85, 2818, 2224},	// KPluginInfo::setPluginEnabled$
    {85, 3234, 2236},	// KPluginInfo::version
    {85, 3254, 2237},	// KPluginInfo::website
    {85, 3397, 2261},	// KPluginInfo::~KPluginInfo
    {86, 438, 2281},	// KPluginLoader::KPluginLoader#
    {86, 439, 2282},	// KPluginLoader::KPluginLoader##
    {86, 440, 2270},	// KPluginLoader::KPluginLoader###
    {86, 441, 2279},	// KPluginLoader::KPluginLoader$
    {86, 442, 2280},	// KPluginLoader::KPluginLoader$#
    {86, 443, 2269},	// KPluginLoader::KPluginLoader$##
    {86, 1437, 2274},	// KPluginLoader::errorString
    {86, 1485, 2271},	// KPluginLoader::factory
    {86, 1833, 2275},	// KPluginLoader::isLoaded
    {86, 1980, 2276},	// KPluginLoader::load
    {86, 2060, 2262},	// KPluginLoader::metaObject
    {86, 2241, 2272},	// KPluginLoader::pluginName
    {86, 2242, 2273},	// KPluginLoader::pluginVersion
    {86, 2300, 2268},	// KPluginLoader::qt_metacall$$?
    {86, 2302, 2263},	// KPluginLoader::qt_metacast$
    {86, 3030, 2283},	// KPluginLoader::staticMetaObject
    {86, 3132, 2277},	// KPluginLoader::tr$
    {86, 3133, 2264},	// KPluginLoader::tr$$
    {86, 3134, 2266},	// KPluginLoader::tr$$$
    {86, 3139, 2278},	// KPluginLoader::trUtf8$
    {86, 3140, 2265},	// KPluginLoader::trUtf8$$
    {86, 3141, 2267},	// KPluginLoader::trUtf8$$$
    {86, 3398, 2284},	// KPluginLoader::~KPluginLoader
    {87, 144, 2328},	// KProcess::ForwardedChannels
    {87, 444, 2317},	// KProcess::KProcess
    {87, 445, 2292},	// KProcess::KProcess#
    {87, 446, 2314},	// KProcess::KProcess##
    {87, 602, 2327},	// KProcess::MergedChannels
    {87, 646, 2330},	// KProcess::OnlyStderrChannel
    {87, 647, 2329},	// KProcess::OnlyStdoutChannel
    {87, 707, 2326},	// KProcess::SeparateChannels
    {87, 1145, 2298},	// KProcess::clearEnvironment
    {87, 1146, 2303},	// KProcess::clearProgram
    {87, 1451, 2320},	// KProcess::execute
    {87, 1452, -30},	// KProcess::execute$
    {87, 1453, 2322},	// KProcess::execute$?
    {87, 1454, 2308},	// KProcess::execute$?$
    {87, 1455, 2323},	// KProcess::execute?
    {87, 1456, 2309},	// KProcess::execute?$
    {87, 2060, 2285},	// KProcess::metaObject
    {87, 2175, 2301},	// KProcess::operator<<$
    {87, 2176, 2302},	// KProcess::operator<<?
    {87, 2210, 2294},	// KProcess::outputChannelMode
    {87, 2239, 2313},	// KProcess::pid
    {87, 2270, 2305},	// KProcess::program
    {87, 2300, 2291},	// KProcess::qt_metacall$$?
    {87, 2302, 2286},	// KProcess::qt_metacast$
    {87, 2619, 2318},	// KProcess::setEnv$$
    {87, 2620, 2296},	// KProcess::setEnv$$$
    {87, 2791, 2295},	// KProcess::setNextOpenMode$
    {87, 2803, 2293},	// KProcess::setOutputChannelMode$
    {87, 2834, 2319},	// KProcess::setProgram$
    {87, 2835, 2299},	// KProcess::setProgram$?
    {87, 2836, 2300},	// KProcess::setProgram?
    {87, 2862, 2304},	// KProcess::setShellCommand$
    {87, 2972, 2306},	// KProcess::start
    {87, 2974, 2310},	// KProcess::startDetached
    {87, 2975, 2324},	// KProcess::startDetached$
    {87, 2976, 2311},	// KProcess::startDetached$?
    {87, 2977, 2312},	// KProcess::startDetached?
    {87, 3030, 2325},	// KProcess::staticMetaObject
    {87, 3132, 2315},	// KProcess::tr$
    {87, 3133, 2287},	// KProcess::tr$$
    {87, 3134, 2289},	// KProcess::tr$$$
    {87, 3139, 2316},	// KProcess::trUtf8$
    {87, 3140, 2288},	// KProcess::trUtf8$$
    {87, 3141, 2290},	// KProcess::trUtf8$$$
    {87, 3189, 2297},	// KProcess::unsetEnv$
    {87, 3399, 2331},	// KProcess::~KProcess
    {89, 105, 2408},	// KProtocolInfo::DisplayName
    {89, 147, 2407},	// KProtocolInfo::FromUrl
    {89, 448, 2351},	// KProtocolInfo::KProtocolInfo#$
    {89, 613, 2406},	// KProtocolInfo::Name
    {89, 744, 2405},	// KProtocolInfo::T_ERROR
    {89, 745, 2403},	// KProtocolInfo::T_FILESYSTEM
    {89, 746, 2404},	// KProtocolInfo::T_NONE
    {89, 747, 2402},	// KProtocolInfo::T_STREAM
    {89, 1034, 2353},	// KProtocolInfo::archiveMimeTypes
    {89, 1102, 2356},	// KProtocolInfo::canDeleteRecursive
    {89, 1104, 2354},	// KProtocolInfo::canRenameFromFile
    {89, 1105, 2355},	// KProtocolInfo::canRenameToFile
    {89, 1107, 2349},	// KProtocolInfo::capabilities$
    {89, 1169, 2342},	// KProtocolInfo::config$
    {89, 1324, 2352},	// KProtocolInfo::defaultMimeType
    {89, 1361, 2345},	// KProtocolInfo::determineMimetypeFromExtension$
    {89, 1386, 2346},	// KProtocolInfo::docPath$
    {89, 1447, 2335},	// KProtocolInfo::exec$
    {89, 1480, 2336},	// KProtocolInfo::extraFields#
    {89, 1500, 2357},	// KProtocolInfo::fileNameUsedForCopying
    {89, 1714, 2341},	// KProtocolInfo::icon$
    {89, 1813, 2339},	// KProtocolInfo::isFilterProtocol#
    {89, 1814, 2340},	// KProtocolInfo::isFilterProtocol$
    {89, 1821, 2337},	// KProtocolInfo::isHelperProtocol#
    {89, 1822, 2338},	// KProtocolInfo::isHelperProtocol$
    {89, 1827, 2333},	// KProtocolInfo::isKnownProtocol#
    {89, 1828, 2334},	// KProtocolInfo::isKnownProtocol$
    {89, 2014, 2394},	// KProtocolInfo::m_canCopyFromFile
    {89, 2015, 2396},	// KProtocolInfo::m_canCopyToFile
    {89, 2016, 2398},	// KProtocolInfo::m_config
    {89, 2017, 2388},	// KProtocolInfo::m_defaultMimetype
    {89, 2018, 2390},	// KProtocolInfo::m_determineMimetypeFromExtension
    {89, 2020, 2360},	// KProtocolInfo::m_exec
    {89, 2021, 2392},	// KProtocolInfo::m_icon
    {89, 2022, 2362},	// KProtocolInfo::m_inputType
    {89, 2023, 2370},	// KProtocolInfo::m_isHelperProtocol
    {89, 2024, 2368},	// KProtocolInfo::m_isSourceProtocol
    {89, 2025, 2366},	// KProtocolInfo::m_listing
    {89, 2026, 2400},	// KProtocolInfo::m_maxSlaves
    {89, 2027, 2358},	// KProtocolInfo::m_name
    {89, 2028, 2364},	// KProtocolInfo::m_outputType
    {89, 2030, 2380},	// KProtocolInfo::m_supportsDeleting
    {89, 2031, 2382},	// KProtocolInfo::m_supportsLinking
    {89, 2032, 2372},	// KProtocolInfo::m_supportsListing
    {89, 2033, 2378},	// KProtocolInfo::m_supportsMakeDir
    {89, 2034, 2384},	// KProtocolInfo::m_supportsMoving
    {89, 2035, 2386},	// KProtocolInfo::m_supportsOpening
    {89, 2036, 2374},	// KProtocolInfo::m_supportsReading
    {89, 2037, 2376},	// KProtocolInfo::m_supportsWriting
    {89, 2051, 2343},	// KProtocolInfo::maxSlaves$
    {89, 2053, 2344},	// KProtocolInfo::maxSlavesPerHost$
    {89, 2287, 2347},	// KProtocolInfo::protocolClass$
    {89, 2288, 2332},	// KProtocolInfo::protocols
    {89, 2290, 2350},	// KProtocolInfo::proxiedBy$
    {89, 2705, 2395},	// KProtocolInfo::setM_canCopyFromFile$
    {89, 2707, 2397},	// KProtocolInfo::setM_canCopyToFile$
    {89, 2709, 2399},	// KProtocolInfo::setM_config$
    {89, 2711, 2389},	// KProtocolInfo::setM_defaultMimetype$
    {89, 2713, 2391},	// KProtocolInfo::setM_determineMimetypeFromExtension$
    {89, 2717, 2361},	// KProtocolInfo::setM_exec$
    {89, 2719, 2393},	// KProtocolInfo::setM_icon$
    {89, 2721, 2363},	// KProtocolInfo::setM_inputType$
    {89, 2723, 2371},	// KProtocolInfo::setM_isHelperProtocol$
    {89, 2725, 2369},	// KProtocolInfo::setM_isSourceProtocol$
    {89, 2727, 2367},	// KProtocolInfo::setM_listing?
    {89, 2729, 2401},	// KProtocolInfo::setM_maxSlaves$
    {89, 2731, 2359},	// KProtocolInfo::setM_name$
    {89, 2733, 2365},	// KProtocolInfo::setM_outputType$
    {89, 2737, 2381},	// KProtocolInfo::setM_supportsDeleting$
    {89, 2739, 2383},	// KProtocolInfo::setM_supportsLinking$
    {89, 2741, 2373},	// KProtocolInfo::setM_supportsListing$
    {89, 2743, 2379},	// KProtocolInfo::setM_supportsMakeDir$
    {89, 2745, 2385},	// KProtocolInfo::setM_supportsMoving$
    {89, 2747, 2387},	// KProtocolInfo::setM_supportsOpening$
    {89, 2749, 2375},	// KProtocolInfo::setM_supportsReading$
    {89, 2751, 2377},	// KProtocolInfo::setM_supportsWriting$
    {89, 2939, 2348},	// KProtocolInfo::showFilePreview$
    {89, 3400, 2409},	// KProtocolInfo::~KProtocolInfo
    {90, 83, 2418},	// KProtocolInfo::ExtraField::DateTime
    {90, 132, 2410},	// KProtocolInfo::ExtraField::ExtraField
    {90, 133, 2412},	// KProtocolInfo::ExtraField::ExtraField#
    {90, 134, 2411},	// KProtocolInfo::ExtraField::ExtraField$$
    {90, 177, 2419},	// KProtocolInfo::ExtraField::Invalid
    {90, 739, 2417},	// KProtocolInfo::ExtraField::String
    {90, 2102, 2413},	// KProtocolInfo::ExtraField::name
    {90, 2783, 2414},	// KProtocolInfo::ExtraField::setName$
    {90, 2906, 2416},	// KProtocolInfo::ExtraField::setType$
    {90, 3174, 2415},	// KProtocolInfo::ExtraField::type
    {90, 3333, 2420},	// KProtocolInfo::ExtraField::~ExtraField
    {91, 2320, 2421},	// KRandom::random
    {91, 2322, 2422},	// KRandom::randomString$
    {92, 449, 2431},	// KRandomSequence::KRandomSequence
    {92, 450, 2424},	// KRandomSequence::KRandomSequence#
    {92, 451, 2423},	// KRandomSequence::KRandomSequence$
    {92, 1637, 2429},	// KRandomSequence::getBool
    {92, 1640, 2427},	// KRandomSequence::getDouble
    {92, 1644, 2428},	// KRandomSequence::getLong$
    {92, 2072, 2430},	// KRandomSequence::modulate$
    {92, 2183, 2425},	// KRandomSequence::operator=#
    {92, 2855, 2432},	// KRandomSequence::setSeed
    {92, 2856, 2426},	// KRandomSequence::setSeed$
    {92, 3401, 2433},	// KRandomSequence::~KRandomSequence
    {93, 471, 2434},	// KSaveFile::KSaveFile
    {93, 472, 2449},	// KSaveFile::KSaveFile$
    {93, 473, 2435},	// KSaveFile::KSaveFile$#
    {93, 826, 2441},	// KSaveFile::abort
    {93, 1067, 2451},	// KSaveFile::backupFile$
    {93, 1068, 2445},	// KSaveFile::backupFile$$
    {93, 1373, 2444},	// KSaveFile::directWriteFallback
    {93, 1434, 2438},	// KSaveFile::error
    {93, 1437, 2439},	// KSaveFile::errorString
    {93, 1498, 2437},	// KSaveFile::fileName
    {93, 1502, 2442},	// KSaveFile::finalize
    {93, 2125, 2454},	// KSaveFile::numberedBackupFile$
    {93, 2126, 2455},	// KSaveFile::numberedBackupFile$$
    {93, 2127, 2456},	// KSaveFile::numberedBackupFile$$$
    {93, 2128, 2447},	// KSaveFile::numberedBackupFile$$$$
    {93, 2145, 2450},	// KSaveFile::open
    {93, 2146, 2440},	// KSaveFile::open$
    {93, 2326, 2457},	// KSaveFile::rcsBackupFile$
    {93, 2327, 2458},	// KSaveFile::rcsBackupFile$$
    {93, 2328, 2448},	// KSaveFile::rcsBackupFile$$$
    {93, 2610, 2443},	// KSaveFile::setDirectWriteFallback$
    {93, 2640, 2436},	// KSaveFile::setFileName$
    {93, 2943, 2452},	// KSaveFile::simpleBackupFile$
    {93, 2944, 2453},	// KSaveFile::simpleBackupFile$$
    {93, 2945, 2446},	// KSaveFile::simpleBackupFile$$$
    {93, 3402, 2459},	// KSaveFile::~KSaveFile
    {94, 78, 2516},	// KService::DBusMulti
    {94, 79, 2514},	// KService::DBusNone
    {94, 80, 2515},	// KService::DBusUnique
    {94, 81, 2517},	// KService::DBusWait
    {94, 475, 2462},	// KService::KService#
    {94, 476, 2463},	// KService::KService#$
    {94, 477, 2461},	// KService::KService$
    {94, 478, 2460},	// KService::KService$$$
    {94, 840, 2490},	// KService::actions
    {94, 1015, 2510},	// KService::allServices
    {94, 1021, 2489},	// KService::allowAsDefault
    {94, 1023, 2491},	// KService::allowMultipleFiles
    {94, 1113, 2483},	// KService::categories
    {94, 1159, 2479},	// KService::comment
    {94, 1305, 2477},	// KService::dbusStartupType
    {94, 1353, 2474},	// KService::desktopEntryName
    {94, 1354, 2473},	// KService::desktopEntryPath
    {94, 1385, 2497},	// KService::docPath
    {94, 1446, 2466},	// KService::exec
    {94, 1636, 2480},	// KService::genericName
    {94, 1682, 2487},	// KService::hasMimeType#
    {94, 1683, 2488},	// KService::hasMimeType$
    {94, 1695, 2486},	// KService::hasServiceType$
    {94, 1713, 2468},	// KService::icon
    {94, 1739, 2492},	// KService::initialPreference
    {94, 1773, 2464},	// KService::isApplication
    {94, 1926, 2482},	// KService::keywords
    {94, 1967, 2467},	// KService::library
    {94, 1996, 2500},	// KService::locateLocal
    {94, 2056, 2475},	// KService::menuId
    {94, 2064, 2484},	// KService::mimeTypes
    {94, 2116, 2512},	// KService::newServicePath$$
    {94, 2117, 2513},	// KService::newServicePath$$$
    {94, 2118, 2511},	// KService::newServicePath$$$?
    {94, 2120, 2493},	// KService::noDisplay
    {94, 2213, 2495},	// KService::parentApp
    {94, 2224, 2478},	// KService::path
    {94, 2240, 2496},	// KService::pluginKeyword
    {94, 2278, 2499},	// KService::property$
    {94, 2279, 2498},	// KService::property$$
    {94, 2481, 2507},	// KService::serviceByDesktopName$
    {94, 2483, 2506},	// KService::serviceByDesktopPath$
    {94, 2485, 2508},	// KService::serviceByMenuId$
    {94, 2487, 2505},	// KService::serviceByName$
    {94, 2489, 2509},	// KService::serviceByStorageId$
    {94, 2495, 2485},	// KService::serviceTypes
    {94, 2634, 2504},	// KService::setExec$
    {94, 2767, 2501},	// KService::setMenuId$
    {94, 2881, 2502},	// KService::setTerminal$
    {94, 2883, 2503},	// KService::setTerminalOptions$
    {94, 2940, 2494},	// KService::showInKDE
    {94, 3038, 2476},	// KService::storageId
    {94, 3056, 2471},	// KService::substituteUid
    {94, 3086, 2469},	// KService::terminal
    {94, 3087, 2470},	// KService::terminalOptions
    {94, 3174, 2465},	// KService::type
    {94, 3190, 2481},	// KService::untranslatedGenericName
    {94, 3213, 2472},	// KService::username
    {94, 3403, 2518},	// KService::~KService
    {95, 479, 2520},	// KServiceAction::KServiceAction
    {95, 480, 2521},	// KServiceAction::KServiceAction#
    {95, 481, 2531},	// KServiceAction::KServiceAction$$$$
    {95, 482, 2519},	// KServiceAction::KServiceAction$$$$$
    {95, 1245, 2524},	// KServiceAction::data
    {95, 1446, 2528},	// KServiceAction::exec
    {95, 1713, 2527},	// KServiceAction::icon
    {95, 1854, 2530},	// KServiceAction::isSeparator
    {95, 2102, 2525},	// KServiceAction::name
    {95, 2120, 2529},	// KServiceAction::noDisplay
    {95, 2183, 2522},	// KServiceAction::operator=#
    {95, 2566, 2523},	// KServiceAction::setData#
    {95, 3091, 2526},	// KServiceAction::text
    {95, 3404, 2532},	// KServiceAction::~KServiceAction
    {96, 18, 2574},	// KServiceGroup::AllowSeparators
    {96, 127, 2573},	// KServiceGroup::ExcludeNoDisplay
    {96, 484, 2535},	// KServiceGroup::KServiceGroup#$$
    {96, 485, 2533},	// KServiceGroup::KServiceGroup$
    {96, 486, 2534},	// KServiceGroup::KServiceGroup$$
    {96, 626, 2571},	// KServiceGroup::NoOptions
    {96, 724, 2575},	// KServiceGroup::SortByGenericName
    {96, 725, 2572},	// KServiceGroup::SortEntries
    {96, 875, 2566},	// KServiceGroup::addEntry?
    {96, 1022, 2548},	// KServiceGroup::allowInline
    {96, 1079, 2562},	// KServiceGroup::baseGroup$
    {96, 1080, 2560},	// KServiceGroup::baseGroupName
    {96, 1108, 2537},	// KServiceGroup::caption
    {96, 1134, 2540},	// KServiceGroup::childCount
    {96, 1137, 2565},	// KServiceGroup::childGroup$
    {96, 1159, 2539},	// KServiceGroup::comment
    {96, 1376, 2561},	// KServiceGroup::directoryEntryPath
    {96, 1414, 2568},	// KServiceGroup::entries
    {96, 1415, 2557},	// KServiceGroup::entries$
    {96, 1416, 2556},	// KServiceGroup::entries$$
    {96, 1417, 2567},	// KServiceGroup::entries$$$
    {96, 1418, 2555},	// KServiceGroup::entries$$$$
    {96, 1652, 2564},	// KServiceGroup::group$
    {96, 1653, 2569},	// KServiceGroup::groupEntries
    {96, 1654, 2558},	// KServiceGroup::groupEntries$
    {96, 1713, 2538},	// KServiceGroup::icon
    {96, 1740, 2546},	// KServiceGroup::inlineAlias
    {96, 1741, 2550},	// KServiceGroup::inlineValue
    {96, 1962, 2554},	// KServiceGroup::layoutInfo
    {96, 2120, 2541},	// KServiceGroup::noDisplay
    {96, 2402, 2536},	// KServiceGroup::relPath
    {96, 2456, 2563},	// KServiceGroup::root
    {96, 2490, 2570},	// KServiceGroup::serviceEntries
    {96, 2491, 2559},	// KServiceGroup::serviceEntries$
    {96, 2503, 2549},	// KServiceGroup::setAllowInline$
    {96, 2663, 2547},	// KServiceGroup::setInlineAlias$
    {96, 2665, 2551},	// KServiceGroup::setInlineValue$
    {96, 2681, 2553},	// KServiceGroup::setLayoutInfo?
    {96, 2866, 2543},	// KServiceGroup::setShowEmptyMenu$
    {96, 2868, 2545},	// KServiceGroup::setShowInlineHeader$
    {96, 2936, 2542},	// KServiceGroup::showEmptyMenu
    {96, 2941, 2544},	// KServiceGroup::showInlineHeader
    {96, 3062, 2552},	// KServiceGroup::suppressGenericNames
    {96, 3405, 2576},	// KServiceGroup::~KServiceGroup
    {97, 488, -292},	// KServiceType::KServiceType#
    {97, 489, 2578},	// KServiceType::KServiceType#$
    {97, 490, 2593},	// KServiceType::KServiceType#$$
    {97, 1014, 2591},	// KServiceType::allServiceTypes
    {97, 1159, 2579},	// KServiceType::comment
    {97, 1354, 2580},	// KServiceType::desktopEntryPath
    {97, 1730, 2583},	// KServiceType::inherits$
    {97, 1797, 2581},	// KServiceType::isDerived
    {97, 2216, 2582},	// KServiceType::parentServiceType
    {97, 2217, 2587},	// KServiceType::parentType
    {97, 2281, 2584},	// KServiceType::propertyDef$
    {97, 2282, 2585},	// KServiceType::propertyDefNames
    {97, 2283, 2586},	// KServiceType::propertyDefs
    {97, 2492, 2589},	// KServiceType::serviceOffersOffset
    {97, 2494, 2590},	// KServiceType::serviceType$
    {97, 2858, 2588},	// KServiceType::setServiceOffersOffset$
    {97, 3406, 2594},	// KServiceType::~KServiceType
    {99, 1031, 2599},	// KServiceTypeTrader::applyConstraints?$
    {99, 1327, 2601},	// KServiceTypeTrader::defaultOffers$
    {99, 1328, 2596},	// KServiceTypeTrader::defaultOffers$$
    {99, 2254, 2597},	// KServiceTypeTrader::preferredService$
    {99, 2304, 2600},	// KServiceTypeTrader::query$
    {99, 2305, 2595},	// KServiceTypeTrader::query$$
    {99, 2476, 2598},	// KServiceTypeTrader::self
    {99, 3407, 2602},	// KServiceTypeTrader::~KServiceTypeTrader
    {100, 2149, 2605},	// KSharedConfig::openConfig
    {100, 2150, 2608},	// KSharedConfig::openConfig#
    {100, 2151, 2609},	// KSharedConfig::openConfig#$
    {100, 2152, 2610},	// KSharedConfig::openConfig#$$
    {100, 2153, 2604},	// KSharedConfig::openConfig#$$$
    {100, 2154, 2606},	// KSharedConfig::openConfig$
    {100, 2155, 2607},	// KSharedConfig::openConfig$$
    {100, 2156, 2603},	// KSharedConfig::openConfig$$$
    {100, 3408, 2611},	// KSharedConfig::~KSharedConfig
    {101, 2, 2620},	// KShell::AbortOnMeta
    {101, 38, 2622},	// KShell::BadQuoting
    {101, 146, 2623},	// KShell::FoundMeta
    {101, 623, 2621},	// KShell::NoError
    {101, 626, 2618},	// KShell::NoOptions
    {101, 755, 2619},	// KShell::TildeExpand
    {101, 1887, 2612},	// KShell::joinArgs?
    {101, 2312, 2614},	// KShell::quoteArg$
    {101, 2963, 2616},	// KShell::splitArgs$
    {101, 2964, 2617},	// KShell::splitArgs$$
    {101, 2965, 2615},	// KShell::splitArgs$$$
    {101, 3094, 2613},	// KShell::tildeExpand$
    {102, 1173, 2636},	// KSocketFactory::connectToHost#
    {102, 1174, -48},	// KSocketFactory::connectToHost##
    {102, 1175, 2633},	// KSocketFactory::connectToHost#$$$
    {102, 1176, 2625},	// KSocketFactory::connectToHost$$$
    {102, 1177, 2624},	// KSocketFactory::connectToHost$$$#
    {102, 1251, 2642},	// KSocketFactory::datagramSocket$$
    {102, 1252, 2641},	// KSocketFactory::datagramSocket$$#
    {102, 1975, 2630},	// KSocketFactory::listen$
    {102, 1976, 2631},	// KSocketFactory::listen$#
    {102, 1977, 2632},	// KSocketFactory::listen$#$
    {102, 1978, 2629},	// KSocketFactory::listen$#$#
    {102, 2292, 2643},	// KSocketFactory::proxyForConnection$$
    {102, 2294, 2646},	// KSocketFactory::proxyForDatagram$$
    {102, 2296, 2634},	// KSocketFactory::proxyForListening$
    {102, 3071, 2627},	// KSocketFactory::synchronousConnectToHost#
    {102, 3072, 2645},	// KSocketFactory::synchronousConnectToHost##
    {102, 3073, 2644},	// KSocketFactory::synchronousConnectToHost##$
    {102, 3074, 2628},	// KSocketFactory::synchronousConnectToHost#$
    {102, 3075, 2626},	// KSocketFactory::synchronousConnectToHost#$#
    {102, 3076, 2648},	// KSocketFactory::synchronousConnectToHost#$$$
    {102, 3077, 2647},	// KSocketFactory::synchronousConnectToHost#$$$$
    {102, 3078, 2638},	// KSocketFactory::synchronousConnectToHost$$$
    {102, 3079, 2639},	// KSocketFactory::synchronousConnectToHost$$$$
    {102, 3080, 2637},	// KSocketFactory::synchronousConnectToHost$$$$#
    {103, 170, 2710},	// KStandardDirs::IgnoreExecBit
    {103, 491, 2649},	// KStandardDirs::KStandardDirs
    {103, 622, 2709},	// KStandardDirs::NoDuplicates
    {103, 629, 2707},	// KStandardDirs::NoSearchOptions
    {103, 692, 2708},	// KStandardDirs::Recursive
    {103, 868, 2667},	// KStandardDirs::addCustomized#
    {103, 967, 2650},	// KStandardDirs::addPrefix$
    {103, 971, 2691},	// KStandardDirs::addResourceDir$$
    {103, 972, 2656},	// KStandardDirs::addResourceDir$$$
    {103, 974, 2688},	// KStandardDirs::addResourceType$$
    {103, 975, -509},	// KStandardDirs::addResourceType$$$
    {103, 976, -513},	// KStandardDirs::addResourceType$$$$
    {103, 995, 2651},	// KStandardDirs::addXdgConfigPrefix$
    {103, 997, 2652},	// KStandardDirs::addXdgDataPrefix$
    {103, 1018, 2669},	// KStandardDirs::allTypes
    {103, 1088, 2693},	// KStandardDirs::calcResourceHash$$
    {103, 1089, 2659},	// KStandardDirs::calcResourceHash$$$
    {103, 1123, 2687},	// KStandardDirs::checkAccess$$
    {103, 1462, 2681},	// KStandardDirs::exists$
    {103, 1504, 2699},	// KStandardDirs::findAllExe?$
    {103, 1505, 2700},	// KStandardDirs::findAllExe?$$
    {103, 1506, 2666},	// KStandardDirs::findAllExe?$$$
    {103, 1508, 2694},	// KStandardDirs::findAllResources$
    {103, 1509, 2695},	// KStandardDirs::findAllResources$$
    {103, 1510, 2662},	// KStandardDirs::findAllResources$$$
    {103, 1511, 2663},	// KStandardDirs::findAllResources$$$?
    {103, 1536, 2660},	// KStandardDirs::findDirs$$
    {103, 1540, 2697},	// KStandardDirs::findExe$
    {103, 1541, 2698},	// KStandardDirs::findExe$$
    {103, 1542, 2665},	// KStandardDirs::findExe$$$
    {103, 1555, 2657},	// KStandardDirs::findResource$$
    {103, 1557, 2661},	// KStandardDirs::findResourceDir$$
    {103, 1745, 2680},	// KStandardDirs::installPath$
    {103, 1851, 2692},	// KStandardDirs::isRestrictedResource$
    {103, 1852, 2658},	// KStandardDirs::isRestrictedResource$$
    {103, 1907, 2673},	// KStandardDirs::kde_default$
    {103, 1927, 2674},	// KStandardDirs::kfsstnd_prefixes
    {103, 1928, 2675},	// KStandardDirs::kfsstnd_xdg_conf_prefixes
    {103, 1929, 2676},	// KStandardDirs::kfsstnd_xdg_data_prefixes
    {103, 1990, 2677},	// KStandardDirs::localkdedir
    {103, 1991, 2679},	// KStandardDirs::localxdgconfdir
    {103, 1992, 2678},	// KStandardDirs::localxdgdatadir
    {103, 1994, 2704},	// KStandardDirs::locate$$
    {103, 1995, 2684},	// KStandardDirs::locate$$#
    {103, 1998, 2705},	// KStandardDirs::locateLocal$$
    {103, 1999, 2685},	// KStandardDirs::locateLocal$$#
    {103, 2000, 2706},	// KStandardDirs::locateLocal$$$
    {103, 2001, 2686},	// KStandardDirs::locateLocal$$$#
    {103, 2041, 2703},	// KStandardDirs::makeDir$
    {103, 2042, 2672},	// KStandardDirs::makeDir$$
    {103, 2392, 2683},	// KStandardDirs::realFilePath$
    {103, 2395, 2682},	// KStandardDirs::realPath$
    {103, 2404, 2671},	// KStandardDirs::relativeLocation$$
    {103, 2448, 2668},	// KStandardDirs::resourceDirs$
    {103, 2465, 2701},	// KStandardDirs::saveLocation$
    {103, 2466, 2702},	// KStandardDirs::saveLocation$$
    {103, 2467, 2670},	// KStandardDirs::saveLocation$$$
    {103, 3081, 2696},	// KStandardDirs::systemPaths
    {103, 3082, 2664},	// KStandardDirs::systemPaths$
    {103, 3409, 2711},	// KStandardDirs::~KStandardDirs
    {104, 1110, 2720},	// KStringHandler::capwords$
    {104, 1111, 2729},	// KStringHandler::capwords?
    {104, 1221, 2722},	// KStringHandler::csqueeze$
    {104, 1222, 2721},	// KStringHandler::csqueeze$$
    {104, 1607, 2716},	// KStringHandler::from8Bit$
    {104, 1870, 2717},	// KStringHandler::isUtf8$
    {104, 2008, 2719},	// KStringHandler::lsqueeze$
    {104, 2009, 2718},	// KStringHandler::lsqueeze$$
    {104, 2109, 2715},	// KStringHandler::naturalCompare$$
    {104, 2110, 2714},	// KStringHandler::naturalCompare$$$
    {104, 2132, 2728},	// KStringHandler::obscure$
    {104, 2233, -24},	// KStringHandler::perlSplit#$
    {104, 2234, -27},	// KStringHandler::perlSplit#$$
    {104, 2235, 2713},	// KStringHandler::perlSplit$$
    {104, 2236, 2712},	// KStringHandler::perlSplit$$$
    {104, 2252, 2725},	// KStringHandler::preProcessWrap$
    {104, 2458, 2731},	// KStringHandler::rsqueeze$
    {104, 2459, 2730},	// KStringHandler::rsqueeze$$
    {104, 3084, 2732},	// KStringHandler::tagUrls$
    {105, 151, 2768},	// KSycoca::GlobalDatabase
    {105, 493, 2740},	// KSycoca::KSycoca$
    {105, 586, 2767},	// KSycoca::LocalDatabase
    {105, 829, 2763},	// KSycoca::absoluteFilePath
    {105, 830, 2746},	// KSycoca::absoluteFilePath?
    {105, 877, 2751},	// KSycoca::addFactory#
    {105, 1013, 2750},	// KSycoca::allResourceDirs
    {105, 1248, 2757},	// KSycoca::databaseChanged
    {105, 1249, 2758},	// KSycoca::databaseChanged?
    {105, 1378, 2753},	// KSycoca::disableAutoRebuild
    {105, 1484, 2759},	// KSycoca::factories
    {105, 1538, 2743},	// KSycoca::findEntry$$
    {105, 1544, 2744},	// KSycoca::findFactory$
    {105, 1567, 2755},	// KSycoca::flagError
    {105, 1781, 2742},	// KSycoca::isAvailable
    {105, 1786, 2752},	// KSycoca::isBuilding
    {105, 1788, 2754},	// KSycoca::isChanged$
    {105, 1927, 2745},	// KSycoca::kfsstnd_prefixes
    {105, 1947, 2747},	// KSycoca::language
    {105, 2029, 2765},	// KSycoca::m_str_deprecated
    {105, 2060, 2733},	// KSycoca::metaObject
    {105, 2300, 2739},	// KSycoca::qt_metacall$$?
    {105, 2302, 2734},	// KSycoca::qt_metacast$
    {105, 2356, 2756},	// KSycoca::readError
    {105, 2735, 2766},	// KSycoca::setM_str_deprecated#
    {105, 3030, 2764},	// KSycoca::staticMetaObject
    {105, 3041, 2760},	// KSycoca::stream
    {105, 3098, 2748},	// KSycoca::timeStamp
    {105, 3132, 2761},	// KSycoca::tr$
    {105, 3133, 2735},	// KSycoca::tr$$
    {105, 3134, 2737},	// KSycoca::tr$$$
    {105, 3139, 2762},	// KSycoca::trUtf8$
    {105, 3140, 2736},	// KSycoca::trUtf8$$
    {105, 3141, 2738},	// KSycoca::trUtf8$$$
    {105, 3198, 2749},	// KSycoca::updateSignature
    {105, 3234, 2741},	// KSycoca::version
    {105, 3410, 2769},	// KSycoca::~KSycoca
    {106, 494, 2770},	// KSycocaEntry::KSycocaEntry
    {106, 495, 2786},	// KSycocaEntry::KSycocaEntry#
    {106, 1421, 2776},	// KSycocaEntry::entryPath
    {106, 1796, 2779},	// KSycocaEntry::isDeleted
    {106, 1854, 2783},	// KSycocaEntry::isSeparator
    {106, 1867, 2771},	// KSycocaEntry::isType$
    {106, 1871, 2778},	// KSycocaEntry::isValid
    {106, 2102, 2775},	// KSycocaEntry::name
    {106, 2135, 2784},	// KSycocaEntry::offset
    {106, 2278, 2780},	// KSycocaEntry::property$
    {106, 2284, 2781},	// KSycocaEntry::propertyNames
    {106, 2330, 2773},	// KSycocaEntry::read#$
    {106, 2331, 2774},	// KSycocaEntry::read#?
    {106, 2461, 2785},	// KSycocaEntry::save#
    {106, 2601, 2782},	// KSycocaEntry::setDeleted$
    {106, 3038, 2777},	// KSycocaEntry::storageId
    {106, 3067, 2772},	// KSycocaEntry::sycocaType
    {106, 3411, 2787},	// KSycocaEntry::~KSycocaEntry
    {110, 497, 2789},	// KSystemTimeZone::KSystemTimeZone#
    {110, 498, 2790},	// KSystemTimeZone::KSystemTimeZone#$
    {110, 499, 2791},	// KSystemTimeZone::KSystemTimeZone#$$
    {110, 500, 2792},	// KSystemTimeZone::KSystemTimeZone#$$$
    {110, 501, 2793},	// KSystemTimeZone::KSystemTimeZone#$$$$
    {110, 502, 2788},	// KSystemTimeZone::KSystemTimeZone#$$$$$
    {110, 3412, 2794},	// KSystemTimeZone::~KSystemTimeZone
    {111, 504, 2803},	// KSystemTimeZoneBackend::KSystemTimeZoneBackend#
    {111, 505, 2795},	// KSystemTimeZoneBackend::KSystemTimeZoneBackend#$$$$$
    {111, 1148, 2796},	// KSystemTimeZoneBackend::clone
    {111, 1802, 2802},	// KSystemTimeZoneBackend::isDst#?
    {111, 1806, 2801},	// KSystemTimeZoneBackend::isDstAtUtc##
    {111, 2136, 2800},	// KSystemTimeZoneBackend::offset#?
    {111, 2140, 2799},	// KSystemTimeZoneBackend::offsetAtUtc##
    {111, 2143, 2798},	// KSystemTimeZoneBackend::offsetAtZoneTime##$
    {111, 3174, 2797},	// KSystemTimeZoneBackend::type
    {111, 3413, 2804},	// KSystemTimeZoneBackend::~KSystemTimeZoneBackend
    {112, 506, 2805},	// KSystemTimeZoneSource::KSystemTimeZoneSource
    {112, 507, 2809},	// KSystemTimeZoneSource::KSystemTimeZoneSource#
    {112, 1413, 2808},	// KSystemTimeZoneSource::endParseBlock
    {112, 2220, 2806},	// KSystemTimeZoneSource::parse#
    {112, 2978, 2807},	// KSystemTimeZoneSource::startParseBlock
    {112, 3414, 2810},	// KSystemTimeZoneSource::~KSystemTimeZoneSource
    {113, 1860, 2825},	// KSystemTimeZones::isSimulated
    {113, 1865, 2827},	// KSystemTimeZones::isTimeZoneDaemonAvailable
    {113, 1984, 2822},	// KSystemTimeZones::local
    {113, 2060, 2811},	// KSystemTimeZones::metaObject
    {113, 2300, 2817},	// KSystemTimeZones::qt_metacall$$?
    {113, 2302, 2812},	// KSystemTimeZones::qt_metacast$
    {113, 2389, 2821},	// KSystemTimeZones::readZone$
    {113, 2393, 2823},	// KSystemTimeZones::realLocalZone
    {113, 2691, 2824},	// KSystemTimeZones::setLocalZone#
    {113, 3030, 2830},	// KSystemTimeZones::staticMetaObject
    {113, 3101, 2818},	// KSystemTimeZones::timeZones
    {113, 3132, 2828},	// KSystemTimeZones::tr$
    {113, 3133, 2813},	// KSystemTimeZones::tr$$
    {113, 3134, 2815},	// KSystemTimeZones::tr$$$
    {113, 3139, 2829},	// KSystemTimeZones::trUtf8$
    {113, 3140, 2814},	// KSystemTimeZones::trUtf8$$
    {113, 3141, 2816},	// KSystemTimeZones::trUtf8$$$
    {113, 3324, 2820},	// KSystemTimeZones::zone$
    {113, 3325, 2826},	// KSystemTimeZones::zoneinfoDir
    {113, 3326, 2819},	// KSystemTimeZones::zones
    {113, 3415, 2831},	// KSystemTimeZones::~KSystemTimeZones
    {114, 508, 2841},	// KTempDir::KTempDir
    {114, 509, 2842},	// KTempDir::KTempDir$
    {114, 510, 2832},	// KTempDir::KTempDir$$
    {114, 1052, 2834},	// KTempDir::autoRemove
    {114, 1212, 2840},	// KTempDir::create$$
    {114, 1461, 2838},	// KTempDir::exists
    {114, 2102, 2836},	// KTempDir::name
    {114, 2419, 2839},	// KTempDir::removeDir$
    {114, 2522, 2833},	// KTempDir::setAutoRemove$
    {114, 3033, 2835},	// KTempDir::status
    {114, 3180, 2837},	// KTempDir::unlink
    {114, 3416, 2843},	// KTempDir::~KTempDir
    {115, 511, 2847},	// KTemporaryFile::KTemporaryFile
    {115, 512, 2844},	// KTemporaryFile::KTemporaryFile#
    {115, 2826, 2845},	// KTemporaryFile::setPrefix$
    {115, 2879, 2846},	// KTemporaryFile::setSuffix$
    {115, 3417, 2848},	// KTemporaryFile::~KTemporaryFile
    {116, 180, 2903},	// KTimeZone::InvalidOffset
    {116, 181, 2904},	// KTimeZone::InvalidTime_t
    {116, 513, 2849},	// KTimeZone::KTimeZone
    {116, 514, -21},	// KTimeZone::KTimeZone#
    {116, 515, 2850},	// KTimeZone::KTimeZone$
    {116, 771, 2905},	// KTimeZone::UNKNOWN
    {116, 824, 2863},	// KTimeZone::abbreviation#
    {116, 825, 2862},	// KTimeZone::abbreviations
    {116, 1159, 2861},	// KTimeZone::comment
    {116, 1186, 2865},	// KTimeZone::convert##
    {116, 1201, 2858},	// KTimeZone::countryCode
    {116, 1237, 2891},	// KTimeZone::currentOffset
    {116, 1238, 2868},	// KTimeZone::currentOffset$
    {116, 1245, 2901},	// KTimeZone::data
    {116, 1246, 2883},	// KTimeZone::data$
    {116, 1633, 2885},	// KTimeZone::fromTime_t?
    {116, 1700, 2875},	// KTimeZone::hasTransitions
    {116, 1803, 2873},	// KTimeZone::isDst?
    {116, 1805, 2872},	// KTimeZone::isDstAtUtc#
    {116, 1871, 2856},	// KTimeZone::isValid
    {116, 1961, 2859},	// KTimeZone::latitude
    {116, 1965, 2880},	// KTimeZone::leapSecondChanges
    {116, 2006, 2860},	// KTimeZone::longitude
    {116, 2102, 2857},	// KTimeZone::name
    {116, 2137, 2871},	// KTimeZone::offset?
    {116, 2139, 2870},	// KTimeZone::offsetAtUtc#
    {116, 2142, 2892},	// KTimeZone::offsetAtZoneTime#
    {116, 2144, 2869},	// KTimeZone::offsetAtZoneTime#$
    {116, 2159, 2854},	// KTimeZone::operator!=#
    {116, 2183, 2852},	// KTimeZone::operator=#
    {116, 2186, 2853},	// KTimeZone::operator==#
    {116, 2219, 2882},	// KTimeZone::parse
    {116, 2238, 2874},	// KTimeZone::phases
    {116, 2566, 2902},	// KTimeZone::setData#
    {116, 2567, 2889},	// KTimeZone::setData##
    {116, 2955, 2881},	// KTimeZone::source
    {116, 3119, 2886},	// KTimeZone::toTime_t#
    {116, 3121, 2866},	// KTimeZone::toUtc#
    {116, 3125, 2890},	// KTimeZone::toZoneTime#
    {116, 3126, 2867},	// KTimeZone::toZoneTime#$
    {116, 3145, 2895},	// KTimeZone::transition#
    {116, 3146, 2896},	// KTimeZone::transition#?
    {116, 3147, 2877},	// KTimeZone::transition#?$
    {116, 3149, 2897},	// KTimeZone::transitionIndex#
    {116, 3150, 2898},	// KTimeZone::transitionIndex#$
    {116, 3151, 2878},	// KTimeZone::transitionIndex#$$
    {116, 3153, 2899},	// KTimeZone::transitionTimes#
    {116, 3154, 2900},	// KTimeZone::transitionTimes##
    {116, 3155, 2879},	// KTimeZone::transitionTimes###
    {116, 3156, 2893},	// KTimeZone::transitions
    {116, 3157, 2894},	// KTimeZone::transitions#
    {116, 3158, 2876},	// KTimeZone::transitions##
    {116, 3174, 2855},	// KTimeZone::type
    {116, 3197, 2884},	// KTimeZone::updateBase#
    {116, 3220, 2887},	// KTimeZone::utc
    {116, 3222, 2864},	// KTimeZone::utcOffsets
    {116, 3418, 2906},	// KTimeZone::~KTimeZone
    {117, 566, 2907},	// KTimeZone::LeapSeconds::LeapSeconds
    {117, 567, 2909},	// KTimeZone::LeapSeconds::LeapSeconds#
    {117, 568, 2916},	// KTimeZone::LeapSeconds::LeapSeconds#$
    {117, 569, 2908},	// KTimeZone::LeapSeconds::LeapSeconds#$$
    {117, 1159, 2915},	// KTimeZone::LeapSeconds::comment
    {117, 1261, 2913},	// KTimeZone::LeapSeconds::dateTime
    {117, 1871, 2912},	// KTimeZone::LeapSeconds::isValid
    {117, 1966, 2914},	// KTimeZone::LeapSeconds::leapSeconds
    {117, 2169, 2911},	// KTimeZone::LeapSeconds::operator<#
    {117, 2183, 2910},	// KTimeZone::LeapSeconds::operator=#
    {117, 3431, 2917},	// KTimeZone::LeapSeconds::~LeapSeconds
    {118, 661, 2918},	// KTimeZone::Phase::Phase
    {118, 662, 2921},	// KTimeZone::Phase::Phase#
    {118, 663, 2929},	// KTimeZone::Phase::Phase$#$
    {118, 664, 2919},	// KTimeZone::Phase::Phase$#$$
    {118, 665, 2930},	// KTimeZone::Phase::Phase$?$
    {118, 666, 2920},	// KTimeZone::Phase::Phase$?$$
    {118, 825, 2926},	// KTimeZone::Phase::abbreviations
    {118, 1159, 2928},	// KTimeZone::Phase::comment
    {118, 1801, 2927},	// KTimeZone::Phase::isDst
    {118, 2159, 2924},	// KTimeZone::Phase::operator!=#
    {118, 2183, 2922},	// KTimeZone::Phase::operator=#
    {118, 2186, 2923},	// KTimeZone::Phase::operator==#
    {118, 3221, 2925},	// KTimeZone::Phase::utcOffset
    {118, 3433, 2931},	// KTimeZone::Phase::~Phase
    {119, 766, 2932},	// KTimeZone::Transition::Transition
    {119, 767, 2934},	// KTimeZone::Transition::Transition#
    {119, 768, 2933},	// KTimeZone::Transition::Transition##
    {119, 2169, 2938},	// KTimeZone::Transition::operator<#
    {119, 2183, 2935},	// KTimeZone::Transition::operator=#
    {119, 2237, 2937},	// KTimeZone::Transition::phase
    {119, 3095, 2936},	// KTimeZone::Transition::time
    {119, 3436, 2939},	// KTimeZone::Transition::~Transition
    {120, 516, 2940},	// KTimeZoneBackend::KTimeZoneBackend
    {120, 517, 2942},	// KTimeZoneBackend::KTimeZoneBackend#
    {120, 518, 2953},	// KTimeZoneBackend::KTimeZoneBackend#$
    {120, 519, 2954},	// KTimeZoneBackend::KTimeZoneBackend#$$
    {120, 520, 2955},	// KTimeZoneBackend::KTimeZoneBackend#$$$
    {120, 521, 2956},	// KTimeZoneBackend::KTimeZoneBackend#$$$$
    {120, 522, 2952},	// KTimeZoneBackend::KTimeZoneBackend#$$$$$
    {120, 523, 2941},	// KTimeZoneBackend::KTimeZoneBackend$
    {120, 1148, 2944},	// KTimeZoneBackend::clone
    {120, 1701, 2951},	// KTimeZoneBackend::hasTransitions#
    {120, 1802, 2950},	// KTimeZoneBackend::isDst#?
    {120, 1806, 2949},	// KTimeZoneBackend::isDstAtUtc##
    {120, 2136, 2948},	// KTimeZoneBackend::offset#?
    {120, 2140, 2947},	// KTimeZoneBackend::offsetAtUtc##
    {120, 2143, 2946},	// KTimeZoneBackend::offsetAtZoneTime##$
    {120, 2183, 2943},	// KTimeZoneBackend::operator=#
    {120, 3174, 2945},	// KTimeZoneBackend::type
    {120, 3419, 2957},	// KTimeZoneBackend::~KTimeZoneBackend
    {121, 524, 2958},	// KTimeZoneData::KTimeZoneData
    {121, 525, 2959},	// KTimeZoneData::KTimeZoneData#
    {121, 824, 2963},	// KTimeZoneData::abbreviation#
    {121, 825, 2962},	// KTimeZoneData::abbreviations
    {121, 1148, 2961},	// KTimeZoneData::clone
    {121, 1700, 2967},	// KTimeZoneData::hasTransitions
    {121, 1964, 2973},	// KTimeZoneData::leapSecondChange#
    {121, 1965, 2972},	// KTimeZoneData::leapSecondChanges
    {121, 2183, 2960},	// KTimeZoneData::operator=#
    {121, 2238, 2966},	// KTimeZoneData::phases
    {121, 2260, 2965},	// KTimeZoneData::previousUtcOffset
    {121, 2683, 2977},	// KTimeZoneData::setLeapSecondChanges?
    {121, 2815, 2974},	// KTimeZoneData::setPhases?#
    {121, 2816, 2975},	// KTimeZoneData::setPhases?$
    {121, 2901, 2976},	// KTimeZoneData::setTransitions?
    {121, 3145, 2980},	// KTimeZoneData::transition#
    {121, 3146, 2981},	// KTimeZoneData::transition#?
    {121, 3147, 2969},	// KTimeZoneData::transition#?$
    {121, 3149, 2982},	// KTimeZoneData::transitionIndex#
    {121, 3150, 2983},	// KTimeZoneData::transitionIndex#$
    {121, 3151, 2970},	// KTimeZoneData::transitionIndex#$$
    {121, 3153, 2984},	// KTimeZoneData::transitionTimes#
    {121, 3154, 2985},	// KTimeZoneData::transitionTimes##
    {121, 3155, 2971},	// KTimeZoneData::transitionTimes###
    {121, 3156, 2978},	// KTimeZoneData::transitions
    {121, 3157, 2979},	// KTimeZoneData::transitions#
    {121, 3158, 2968},	// KTimeZoneData::transitions##
    {121, 3222, 2964},	// KTimeZoneData::utcOffsets
    {121, 3420, 2986},	// KTimeZoneData::~KTimeZoneData
    {122, 526, 2987},	// KTimeZoneSource::KTimeZoneSource
    {122, 527, 2991},	// KTimeZoneSource::KTimeZoneSource#
    {122, 528, 2990},	// KTimeZoneSource::KTimeZoneSource$
    {122, 2220, 2988},	// KTimeZoneSource::parse#
    {122, 3209, 2989},	// KTimeZoneSource::useZoneParse
    {122, 3421, 2992},	// KTimeZoneSource::~KTimeZoneSource
    {123, 529, 2993},	// KTimeZones::KTimeZones
    {123, 843, 2996},	// KTimeZones::add#
    {123, 1144, 2999},	// KTimeZones::clear
    {123, 2412, 2997},	// KTimeZones::remove#
    {123, 2413, 2998},	// KTimeZones::remove$
    {123, 3324, 2994},	// KTimeZones::zone$
    {123, 3326, 2995},	// KTimeZones::zones
    {123, 3422, 3000},	// KTimeZones::~KTimeZones
    {124, 1751, 3036},	// KToolInvocation::invokeBrowser$
    {124, 1752, 3013},	// KToolInvocation::invokeBrowser$#
    {124, 1753, 3027},	// KToolInvocation::invokeHelp
    {124, 1754, 3028},	// KToolInvocation::invokeHelp$
    {124, 1755, 3029},	// KToolInvocation::invokeHelp$$
    {124, 1756, 3009},	// KToolInvocation::invokeHelp$$#
    {124, 1758, 3031},	// KToolInvocation::invokeMailer#
    {124, 1759, 3032},	// KToolInvocation::invokeMailer##
    {124, 1760, 3011},	// KToolInvocation::invokeMailer##$
    {124, 1761, 3030},	// KToolInvocation::invokeMailer$$
    {124, 1762, 3010},	// KToolInvocation::invokeMailer$$#
    {124, 1763, 3033},	// KToolInvocation::invokeMailer$$$$$
    {124, 1764, 3034},	// KToolInvocation::invokeMailer$$$$$$
    {124, 1765, 3035},	// KToolInvocation::invokeMailer$$$$$$?
    {124, 1766, 3012},	// KToolInvocation::invokeMailer$$$$$$?#
    {124, 1768, 3037},	// KToolInvocation::invokeTerminal$
    {124, 1769, 3038},	// KToolInvocation::invokeTerminal$$
    {124, 1770, 3014},	// KToolInvocation::invokeTerminal$$#
    {124, 1900, 3024},	// KToolInvocation::kapplication_hook?#
    {124, 1909, 3072},	// KToolInvocation::kdeinitExec$
    {124, 1910, 3073},	// KToolInvocation::kdeinitExec$?
    {124, 1911, 3074},	// KToolInvocation::kdeinitExec$?$
    {124, 1912, 3075},	// KToolInvocation::kdeinitExec$?$$
    {124, 1913, 3022},	// KToolInvocation::kdeinitExec$?$$#
    {124, 1915, 3076},	// KToolInvocation::kdeinitExecWait$
    {124, 1916, 3077},	// KToolInvocation::kdeinitExecWait$?
    {124, 1917, 3078},	// KToolInvocation::kdeinitExecWait$?$
    {124, 1918, 3079},	// KToolInvocation::kdeinitExecWait$?$$
    {124, 1919, 3023},	// KToolInvocation::kdeinitExecWait$?$$#
    {124, 1940, 3015},	// KToolInvocation::klauncher
    {124, 2060, 3001},	// KToolInvocation::metaObject
    {124, 2300, 3007},	// KToolInvocation::qt_metacall$$?
    {124, 2302, 3002},	// KToolInvocation::qt_metacast$
    {124, 2476, 3008},	// KToolInvocation::self
    {124, 2981, 3066},	// KToolInvocation::startServiceByDesktopName$
    {124, 2982, 3061},	// KToolInvocation::startServiceByDesktopName$$
    {124, 2983, 3062},	// KToolInvocation::startServiceByDesktopName$$$
    {124, 2984, 3063},	// KToolInvocation::startServiceByDesktopName$$$$
    {124, 2985, 3064},	// KToolInvocation::startServiceByDesktopName$$$$$
    {124, 2986, 3065},	// KToolInvocation::startServiceByDesktopName$$$$$#
    {124, 2987, 3020},	// KToolInvocation::startServiceByDesktopName$$$$$#$
    {124, 2988, 3067},	// KToolInvocation::startServiceByDesktopName$?
    {124, 2989, 3068},	// KToolInvocation::startServiceByDesktopName$?$
    {124, 2990, 3069},	// KToolInvocation::startServiceByDesktopName$?$$
    {124, 2991, 3070},	// KToolInvocation::startServiceByDesktopName$?$$$
    {124, 2992, 3071},	// KToolInvocation::startServiceByDesktopName$?$$$#
    {124, 2993, 3021},	// KToolInvocation::startServiceByDesktopName$?$$$#$
    {124, 2995, 3055},	// KToolInvocation::startServiceByDesktopPath$
    {124, 2996, 3050},	// KToolInvocation::startServiceByDesktopPath$$
    {124, 2997, 3051},	// KToolInvocation::startServiceByDesktopPath$$$
    {124, 2998, 3052},	// KToolInvocation::startServiceByDesktopPath$$$$
    {124, 2999, 3053},	// KToolInvocation::startServiceByDesktopPath$$$$$
    {124, 3000, 3054},	// KToolInvocation::startServiceByDesktopPath$$$$$#
    {124, 3001, 3018},	// KToolInvocation::startServiceByDesktopPath$$$$$#$
    {124, 3002, 3056},	// KToolInvocation::startServiceByDesktopPath$?
    {124, 3003, 3057},	// KToolInvocation::startServiceByDesktopPath$?$
    {124, 3004, 3058},	// KToolInvocation::startServiceByDesktopPath$?$$
    {124, 3005, 3059},	// KToolInvocation::startServiceByDesktopPath$?$$$
    {124, 3006, 3060},	// KToolInvocation::startServiceByDesktopPath$?$$$#
    {124, 3007, 3019},	// KToolInvocation::startServiceByDesktopPath$?$$$#$
    {124, 3009, 3044},	// KToolInvocation::startServiceByName$
    {124, 3010, 3039},	// KToolInvocation::startServiceByName$$
    {124, 3011, 3040},	// KToolInvocation::startServiceByName$$$
    {124, 3012, 3041},	// KToolInvocation::startServiceByName$$$$
    {124, 3013, 3042},	// KToolInvocation::startServiceByName$$$$$
    {124, 3014, 3043},	// KToolInvocation::startServiceByName$$$$$#
    {124, 3015, 3016},	// KToolInvocation::startServiceByName$$$$$#$
    {124, 3016, 3045},	// KToolInvocation::startServiceByName$?
    {124, 3017, 3046},	// KToolInvocation::startServiceByName$?$
    {124, 3018, 3047},	// KToolInvocation::startServiceByName$?$$
    {124, 3019, 3048},	// KToolInvocation::startServiceByName$?$$$
    {124, 3020, 3049},	// KToolInvocation::startServiceByName$?$$$#
    {124, 3021, 3017},	// KToolInvocation::startServiceByName$?$$$#$
    {124, 3030, 3080},	// KToolInvocation::staticMetaObject
    {124, 3132, 3025},	// KToolInvocation::tr$
    {124, 3133, 3003},	// KToolInvocation::tr$$
    {124, 3134, 3005},	// KToolInvocation::tr$$$
    {124, 3139, 3026},	// KToolInvocation::trUtf8$
    {124, 3140, 3004},	// KToolInvocation::trUtf8$$
    {124, 3141, 3006},	// KToolInvocation::trUtf8$$$
    {124, 3423, 3081},	// KToolInvocation::~KToolInvocation
    {125, 531, 3083},	// KTzfileTimeZone::KTzfileTimeZone#
    {125, 532, 3084},	// KTzfileTimeZone::KTzfileTimeZone#$
    {125, 533, 3085},	// KTzfileTimeZone::KTzfileTimeZone#$$
    {125, 534, 3086},	// KTzfileTimeZone::KTzfileTimeZone#$$$
    {125, 535, 3087},	// KTzfileTimeZone::KTzfileTimeZone#$$$$
    {125, 536, 3082},	// KTzfileTimeZone::KTzfileTimeZone#$$$$$
    {125, 3424, 3088},	// KTzfileTimeZone::~KTzfileTimeZone
    {126, 538, 3093},	// KTzfileTimeZoneBackend::KTzfileTimeZoneBackend#
    {126, 539, 3089},	// KTzfileTimeZoneBackend::KTzfileTimeZoneBackend#$$$$$
    {126, 1148, 3090},	// KTzfileTimeZoneBackend::clone
    {126, 1701, 3092},	// KTzfileTimeZoneBackend::hasTransitions#
    {126, 3174, 3091},	// KTzfileTimeZoneBackend::type
    {126, 3425, 3094},	// KTzfileTimeZoneBackend::~KTzfileTimeZoneBackend
    {127, 541, 3098},	// KTzfileTimeZoneSource::KTzfileTimeZoneSource#
    {127, 542, 3095},	// KTzfileTimeZoneSource::KTzfileTimeZoneSource$
    {127, 2002, 3096},	// KTzfileTimeZoneSource::location
    {127, 2220, 3097},	// KTzfileTimeZoneSource::parse#
    {127, 3426, 3099},	// KTzfileTimeZoneSource::~KTzfileTimeZoneSource
    {128, 12, 3196},	// KUrl::AddTrailingSlash
    {128, 17, 3207},	// KUrl::AllowEmptyPath
    {128, 20, 3203},	// KUrl::AppendTrailingSlash
    {128, 33, 3200},	// KUrl::AvoidEmptyPath
    {128, 48, 3201},	// KUrl::CaseInsensitiveKeys
    {128, 66, 3206},	// KUrl::CompareWithoutFragment
    {128, 67, 3205},	// KUrl::CompareWithoutTrailingSlash
    {128, 99, 3192},	// KUrl::DefaultMimeDataFlags
    {128, 171, 3204},	// KUrl::IgnoreTrailingSlash
    {128, 543, 3100},	// KUrl::KUrl
    {128, 544, -1},	// KUrl::KUrl#
    {128, 545, 3106},	// KUrl::KUrl#$
    {128, 546, -5},	// KUrl::KUrl$
    {128, 560, 3198},	// KUrl::KeepDirSeparators
    {128, 570, 3195},	// KUrl::LeaveTrailingSlash
    {128, 632, 3193},	// KUrl::NoTextExport
    {128, 641, 3202},	// KUrl::ObeyTrailingSlash
    {128, 659, 3199},	// KUrl::PermitEmptyPath
    {128, 696, 3194},	// KUrl::RemoveTrailingSlash
    {128, 716, 3197},	// KUrl::SimplifyDirSeparators
    {128, 965, 3137},	// KUrl::addPath$
    {128, 969, 3140},	// KUrl::addQueryItem$$
    {128, 1002, 3121},	// KUrl::adjustPath$
    {128, 1116, 3145},	// KUrl::cd$
    {128, 1142, 3179},	// KUrl::cleanPath
    {128, 1143, 3120},	// KUrl::cleanPath$
    {128, 1151, 3187},	// KUrl::cmp#
    {128, 1152, 3161},	// KUrl::cmp#$
    {128, 1316, 3173},	// KUrl::decode_string$
    {128, 1374, 3184},	// KUrl::directory
    {128, 1375, 3143},	// KUrl::directory#
    {128, 1399, 3171},	// KUrl::encode_string$
    {128, 1401, 3172},	// KUrl::encode_string_no_slash$
    {128, 1402, 3130},	// KUrl::encodedHtmlRef
    {128, 1403, 3180},	// KUrl::encodedPathAndQuery
    {128, 1404, 3181},	// KUrl::encodedPathAndQuery$
    {128, 1405, 3123},	// KUrl::encodedPathAndQuery$#
    {128, 1424, 3188},	// KUrl::equals#
    {128, 1425, 3162},	// KUrl::equals##
    {128, 1495, 3135},	// KUrl::fileEncoding
    {128, 1498, 3183},	// KUrl::fileName
    {128, 1499, 3142},	// KUrl::fileName#
    {128, 1618, 3169},	// KUrl::fromMimeDataByteArray#
    {128, 1620, 3167},	// KUrl::fromPath$
    {128, 1622, 3168},	// KUrl::fromPathOrUrl$
    {128, 1673, 3132},	// KUrl::hasHTMLRef
    {128, 1675, 3115},	// KUrl::hasHost
    {128, 1690, 3114},	// KUrl::hasPass
    {128, 1691, 3119},	// KUrl::hasPath
    {128, 1693, 3128},	// KUrl::hasRef
    {128, 1696, 3136},	// KUrl::hasSubUrl
    {128, 1702, 3111},	// KUrl::hasUser
    {128, 1708, 3129},	// KUrl::htmlRef
    {128, 1834, 3133},	// KUrl::isLocalFile
    {128, 1844, 3163},	// KUrl::isParentOf#
    {128, 1849, 3174},	// KUrl::isRelativeUrl$
    {128, 1885, 3166},	// KUrl::join?
    {128, 2157, 3160},	// KUrl::operator QVariant
    {128, 2159, 3158},	// KUrl::operator!=#
    {128, 2161, 3159},	// KUrl::operator!=$
    {128, 2183, -8},	// KUrl::operator=#
    {128, 2184, -11},	// KUrl::operator=$
    {128, 2186, 3156},	// KUrl::operator==#
    {128, 2188, 3157},	// KUrl::operator==$
    {128, 2223, 3112},	// KUrl::pass
    {128, 2224, 3177},	// KUrl::path
    {128, 2225, 3116},	// KUrl::path$
    {128, 2226, 3148},	// KUrl::pathOrUrl
    {128, 2227, 3149},	// KUrl::pathOrUrl$
    {128, 2244, 3189},	// KUrl::populateMimeData#
    {128, 2245, 3190},	// KUrl::populateMimeData#?
    {128, 2246, 3170},	// KUrl::populateMimeData#?$
    {128, 2258, 3186},	// KUrl::prettyUrl
    {128, 2259, 3147},	// KUrl::prettyUrl$
    {128, 2285, 3107},	// KUrl::protocol
    {128, 2303, 3125},	// KUrl::query
    {128, 2308, 3139},	// KUrl::queryItem$
    {128, 2309, 3182},	// KUrl::queryItems
    {128, 2310, 3138},	// KUrl::queryItems#
    {128, 2396, 3126},	// KUrl::ref
    {128, 2406, 3191},	// KUrl::relativePath$$
    {128, 2407, 3176},	// KUrl::relativePath$$$
    {128, 2409, 3175},	// KUrl::relativeUrl##
    {128, 2612, 3144},	// KUrl::setDirectory$
    {128, 2614, 3122},	// KUrl::setEncodedPathAndQuery$
    {128, 2638, 3134},	// KUrl::setFileEncoding$
    {128, 2640, 3141},	// KUrl::setFileName$
    {128, 2653, 3131},	// KUrl::setHTMLRef$
    {128, 2809, 3113},	// KUrl::setPass$
    {128, 2811, 3118},	// KUrl::setPath$
    {128, 2846, 3108},	// KUrl::setProtocol$
    {128, 2848, 3124},	// KUrl::setQuery$
    {128, 2852, 3127},	// KUrl::setRef$
    {128, 2911, 3110},	// KUrl::setUser$
    {128, 2960, 3165},	// KUrl::split#
    {128, 2961, 3164},	// KUrl::split$
    {128, 3106, 3178},	// KUrl::toLocalFile
    {128, 3107, 3117},	// KUrl::toLocalFile$
    {128, 3109, 3150},	// KUrl::toMimeDataString
    {128, 3191, 3151},	// KUrl::upUrl
    {128, 3199, 3185},	// KUrl::url
    {128, 3200, 3146},	// KUrl::url$
    {128, 3210, 3109},	// KUrl::user
    {128, 3427, 3208},	// KUrl::~KUrl
    {129, 149, 3235},	// KUser::FullName
    {129, 162, 3238},	// KUser::HomePhone
    {129, 547, 3232},	// KUser::KUser
    {129, 548, -57},	// KUser::KUser#
    {129, 549, -60},	// KUser::KUser$
    {129, 550, 3210},	// KUser::KUser?
    {129, 702, 3236},	// KUser::RoomNumber
    {129, 799, 3233},	// KUser::UseEffectiveUID
    {129, 800, 3234},	// KUser::UseRealUserID
    {129, 813, 3237},	// KUser::WorkPhone
    {129, 1019, 3231},	// KUser::allUserNames
    {129, 1020, 3230},	// KUser::allUsers
    {129, 1483, 3225},	// KUser::faceIconPath
    {129, 1635, 3223},	// KUser::fullName
    {129, 1649, 3220},	// KUser::gid
    {129, 1658, 3228},	// KUser::groupNames
    {129, 1659, 3227},	// KUser::groups
    {129, 1706, 3224},	// KUser::homeDir
    {129, 1862, 3221},	// KUser::isSuperUser
    {129, 1871, 3218},	// KUser::isValid
    {129, 2005, 3222},	// KUser::loginName
    {129, 2159, 3217},	// KUser::operator!=#
    {129, 2183, 3215},	// KUser::operator=#
    {129, 2186, 3216},	// KUser::operator==#
    {129, 2278, 3229},	// KUser::property$
    {129, 2933, 3226},	// KUser::shell
    {129, 3176, 3219},	// KUser::uid
    {129, 3428, 3239},	// KUser::~KUser
    {130, 551, 3256},	// KUserGroup::KUserGroup
    {130, 552, -14},	// KUserGroup::KUserGroup#
    {130, 553, -17},	// KUserGroup::KUserGroup$
    {130, 554, 3243},	// KUserGroup::KUserGroup?
    {130, 1008, 3255},	// KUserGroup::allGroupNames
    {130, 1009, 3254},	// KUserGroup::allGroups
    {130, 1649, 3250},	// KUserGroup::gid
    {130, 1871, 3249},	// KUserGroup::isValid
    {130, 2102, 3251},	// KUserGroup::name
    {130, 2159, 3248},	// KUserGroup::operator!=#
    {130, 2183, 3246},	// KUserGroup::operator=#
    {130, 2186, 3247},	// KUserGroup::operator==#
    {130, 3211, 3253},	// KUserGroup::userNames
    {130, 3214, 3252},	// KUserGroup::users
    {130, 3429, 3257},	// KUserGroup::~KUserGroup
    {131, 555, 3263},	// KWordMacroExpander::KWordMacroExpander
    {131, 556, -503},	// KWordMacroExpander::KWordMacroExpander#
    {131, 1464, 3260},	// KWordMacroExpander::expandEscapedMacro$$?
    {131, 1467, 3261},	// KWordMacroExpander::expandMacro$?
    {131, 1478, 3259},	// KWordMacroExpander::expandPlainMacro$$?
    {131, 3430, 3264},	// KWordMacroExpander::~KWordMacroExpander
    {132, 650, 3294},	// OrgKdeKLauncherInterface::OrgKdeKLauncherInterface$$#
    {132, 651, 3273},	// OrgKdeKLauncherInterface::OrgKdeKLauncherInterface$$##
    {132, 1053, 3274},	// OrgKdeKLauncherInterface::autoStart
    {132, 1054, 3275},	// OrgKdeKLauncherInterface::autoStart$
    {132, 1055, 3289},	// OrgKdeKLauncherInterface::autoStart0Done
    {132, 1056, 3290},	// OrgKdeKLauncherInterface::autoStart1Done
    {132, 1057, 3291},	// OrgKdeKLauncherInterface::autoStart2Done
    {132, 1129, 3288},	// OrgKdeKLauncherInterface::checkForHeldSlave$
    {132, 1449, 3277},	// OrgKdeKLauncherInterface::exec_blind$?
    {132, 1450, 3276},	// OrgKdeKLauncherInterface::exec_blind$??$
    {132, 1921, 3278},	// OrgKdeKLauncherInterface::kdeinit_exec$??$$$$
    {132, 1923, 3279},	// OrgKdeKLauncherInterface::kdeinit_exec_wait$??$$$$
    {132, 2060, 3265},	// OrgKdeKLauncherInterface::metaObject
    {132, 2300, 3271},	// OrgKdeKLauncherInterface::qt_metacall$$?
    {132, 2302, 3266},	// OrgKdeKLauncherInterface::qt_metacast$
    {132, 2431, 3280},	// OrgKdeKLauncherInterface::reparseConfiguration
    {132, 2435, 3281},	// OrgKdeKLauncherInterface::requestHoldSlave$$
    {132, 2437, 3282},	// OrgKdeKLauncherInterface::requestSlave$$$$
    {132, 2679, 3283},	// OrgKdeKLauncherInterface::setLaunchEnv$$
    {132, 3023, 3284},	// OrgKdeKLauncherInterface::start_service_by_desktop_name$??$$$$$
    {132, 3025, 3285},	// OrgKdeKLauncherInterface::start_service_by_desktop_path$??$$$$$
    {132, 3027, 3286},	// OrgKdeKLauncherInterface::start_service_by_name$??$$$$$
    {132, 3029, 3272},	// OrgKdeKLauncherInterface::staticInterfaceName
    {132, 3030, 3295},	// OrgKdeKLauncherInterface::staticMetaObject
    {132, 3132, 3292},	// OrgKdeKLauncherInterface::tr$
    {132, 3133, 3267},	// OrgKdeKLauncherInterface::tr$$
    {132, 3134, 3269},	// OrgKdeKLauncherInterface::tr$$$
    {132, 3139, 3293},	// OrgKdeKLauncherInterface::trUtf8$
    {132, 3140, 3268},	// OrgKdeKLauncherInterface::trUtf8$$
    {132, 3141, 3270},	// OrgKdeKLauncherInterface::trUtf8$$$
    {132, 3247, 3287},	// OrgKdeKLauncherInterface::waitForSlave$
    {132, 3432, 3296},	// OrgKdeKLauncherInterface::~OrgKdeKLauncherInterface
    {149, 452, 3481},	// QGlobalSpace::KST_CTimeInfo
    {149, 453, 3474},	// QGlobalSpace::KST_KCustom
    {149, 454, 3468},	// QGlobalSpace::KST_KDEDesktopMimeType
    {149, 455, 3467},	// QGlobalSpace::KST_KFolderMimeType
    {149, 456, 3478},	// QGlobalSpace::KST_KImageIO
    {149, 457, 3471},	// QGlobalSpace::KST_KImageIOFormat
    {149, 458, 3466},	// QGlobalSpace::KST_KMimeType
    {149, 459, 3469},	// QGlobalSpace::KST_KMimeTypeEntry
    {149, 460, 3480},	// QGlobalSpace::KST_KMimeTypeFactory
    {149, 461, 3472},	// QGlobalSpace::KST_KProtocolInfo
    {149, 462, 3479},	// QGlobalSpace::KST_KProtocolInfoFactory
    {149, 463, 3464},	// QGlobalSpace::KST_KService
    {149, 464, 3475},	// QGlobalSpace::KST_KServiceFactory
    {149, 465, 3470},	// QGlobalSpace::KST_KServiceGroup
    {149, 466, 3477},	// QGlobalSpace::KST_KServiceGroupFactory
    {149, 467, 3473},	// QGlobalSpace::KST_KServiceSeparator
    {149, 468, 3465},	// QGlobalSpace::KST_KServiceType
    {149, 469, 3476},	// QGlobalSpace::KST_KServiceTypeFactory
    {149, 470, 3463},	// QGlobalSpace::KST_KSycocaEntry
    {149, 1710, 3372},	// QGlobalSpace::i18n$
    {149, 1712, 3381},	// QGlobalSpace::i18nc$$
    {149, 1891, 3430},	// QGlobalSpace::kAsciiToLower$
    {149, 1893, 3397},	// QGlobalSpace::kAsciiToUpper$
    {149, 1894, 3359},	// QGlobalSpace::kBacktrace
    {149, 1895, 3358},	// QGlobalSpace::kBacktrace$
    {149, 1896, 3458},	// QGlobalSpace::kClearDebugConfig
    {149, 1898, 3449},	// QGlobalSpace::kRealBacktrace$
    {149, 1902, 3411},	// QGlobalSpace::kasciistricmp$$
    {149, 1904, 3418},	// QGlobalSpace::kdBacktrace
    {149, 1905, 3417},	// QGlobalSpace::kdBacktrace$
    {149, 1931, 3439},	// QGlobalSpace::ki18n$
    {149, 1933, 3390},	// QGlobalSpace::ki18nc$$
    {149, 1935, 3406},	// QGlobalSpace::ki18ncp$$$
    {149, 1937, 3460},	// QGlobalSpace::ki18np$$
    {149, 2160, -425},	// QGlobalSpace::operator!=##
    {149, 2162, 3462},	// QGlobalSpace::operator!=$#
    {149, 2163, 3421},	// QGlobalSpace::operator!=$$
    {149, 2165, 3403},	// QGlobalSpace::operator+#$
    {149, 2166, 3454},	// QGlobalSpace::operator+$#
    {149, 2167, -429},	// QGlobalSpace::operator+$$
    {149, 2170, -434},	// QGlobalSpace::operator<##
    {149, 2171, 3446},	// QGlobalSpace::operator<$#
    {149, 2172, 3420},	// QGlobalSpace::operator<$$
    {149, 2174, -438},	// QGlobalSpace::operator<<##
    {149, 2179, 3434},	// QGlobalSpace::operator<=##
    {149, 2180, 3424},	// QGlobalSpace::operator<=$#
    {149, 2181, 3389},	// QGlobalSpace::operator<=$$
    {149, 2187, -441},	// QGlobalSpace::operator==##
    {149, 2189, 3398},	// QGlobalSpace::operator==$#
    {149, 2190, 3456},	// QGlobalSpace::operator==$$
    {149, 2193, 3448},	// QGlobalSpace::operator>##
    {149, 2194, 3365},	// QGlobalSpace::operator>$#
    {149, 2195, 3444},	// QGlobalSpace::operator>$$
    {149, 2198, 3409},	// QGlobalSpace::operator>=##
    {149, 2199, 3392},	// QGlobalSpace::operator>=$#
    {149, 2200, 3459},	// QGlobalSpace::operator>=$$
    {149, 2202, -445},	// QGlobalSpace::operator>>##
    {149, 2204, -448},	// QGlobalSpace::operator|$$
    {149, 3136, 3379},	// QGlobalSpace::tr2i18n$
    {149, 3137, 3378},	// QGlobalSpace::tr2i18n$$
    {177, 1323, 3525},	// Sonnet::defaultLanguageName
    {177, 1359, 3524},	// Sonnet::detectLanguage$
    {178, 35, 3556},	// Sonnet::BackgroundChecker::BackgroundChecker
    {178, 36, -280},	// Sonnet::BackgroundChecker::BackgroundChecker#
    {178, 37, 3534},	// Sonnet::BackgroundChecker::BackgroundChecker##
    {178, 993, 3542},	// Sonnet::BackgroundChecker::addWordToPersonal$
    {178, 1120, 3547},	// Sonnet::BackgroundChecker::changeLanguage$
    {178, 1133, 3540},	// Sonnet::BackgroundChecker::checkWord$
    {178, 1184, 3548},	// Sonnet::BackgroundChecker::continueChecking
    {178, 1230, 3537},	// Sonnet::BackgroundChecker::currentContext
    {178, 1387, 3550},	// Sonnet::BackgroundChecker::done
    {178, 1494, 3551},	// Sonnet::BackgroundChecker::fetchMoreText
    {178, 1560, 3552},	// Sonnet::BackgroundChecker::finishedCurrentFeed
    {178, 2060, 3526},	// Sonnet::BackgroundChecker::metaObject
    {178, 2067, 3549},	// Sonnet::BackgroundChecker::misspelling$$
    {178, 2300, 3532},	// Sonnet::BackgroundChecker::qt_metacall$$?
    {178, 2302, 3527},	// Sonnet::BackgroundChecker::qt_metacast$
    {178, 2433, 3546},	// Sonnet::BackgroundChecker::replace$$$
    {178, 2450, 3543},	// Sonnet::BackgroundChecker::restore#
    {178, 2873, 3539},	// Sonnet::BackgroundChecker::setSpeller#
    {178, 2885, 3535},	// Sonnet::BackgroundChecker::setText$
    {178, 2947, 3553},	// Sonnet::BackgroundChecker::slotEngineDone
    {178, 2958, 3538},	// Sonnet::BackgroundChecker::speller
    {178, 2972, 3544},	// Sonnet::BackgroundChecker::start
    {178, 3030, 3558},	// Sonnet::BackgroundChecker::staticMetaObject
    {178, 3036, 3545},	// Sonnet::BackgroundChecker::stop
    {178, 3061, 3541},	// Sonnet::BackgroundChecker::suggest$
    {178, 3091, 3536},	// Sonnet::BackgroundChecker::text
    {178, 3132, 3554},	// Sonnet::BackgroundChecker::tr$
    {178, 3133, 3528},	// Sonnet::BackgroundChecker::tr$$
    {178, 3134, 3530},	// Sonnet::BackgroundChecker::tr$$$
    {178, 3139, 3555},	// Sonnet::BackgroundChecker::trUtf8$
    {178, 3140, 3529},	// Sonnet::BackgroundChecker::trUtf8$$
    {178, 3141, 3531},	// Sonnet::BackgroundChecker::trUtf8$$$
    {178, 3330, 3559},	// Sonnet::BackgroundChecker::~BackgroundChecker
    {179, 53, 3587},	// Sonnet::Speller::CheckUppercase
    {179, 718, 3588},	// Sonnet::Speller::SkipRunTogether
    {179, 731, 3585},	// Sonnet::Speller::Speller
    {179, 732, 3561},	// Sonnet::Speller::Speller#
    {179, 733, 3560},	// Sonnet::Speller::Speller$
    {179, 989, 3571},	// Sonnet::Speller::addToPersonal$
    {179, 991, 3572},	// Sonnet::Speller::addToSession$
    {179, 1061, 3575},	// Sonnet::Speller::availableBackends
    {179, 1062, 3578},	// Sonnet::Speller::availableDictionaries
    {179, 1064, 3577},	// Sonnet::Speller::availableLanguageNames
    {179, 1065, 3576},	// Sonnet::Speller::availableLanguages
    {179, 1127, 3569},	// Sonnet::Speller::checkAndSuggest$?
    {179, 1319, 3582},	// Sonnet::Speller::defaultClient
    {179, 1322, 3580},	// Sonnet::Speller::defaultLanguage
    {179, 1793, 3566},	// Sonnet::Speller::isCorrect$
    {179, 1840, 3567},	// Sonnet::Speller::isMisspelled$
    {179, 1871, 3563},	// Sonnet::Speller::isValid
    {179, 1947, 3565},	// Sonnet::Speller::language
    {179, 2183, 3562},	// Sonnet::Speller::operator=#
    {179, 2450, 3574},	// Sonnet::Speller::restore#
    {179, 2461, 3573},	// Sonnet::Speller::save#
    {179, 2513, 3586},	// Sonnet::Speller::setAttribute$
    {179, 2514, 3583},	// Sonnet::Speller::setAttribute$$
    {179, 2596, 3581},	// Sonnet::Speller::setDefaultClient$
    {179, 2598, 3579},	// Sonnet::Speller::setDefaultLanguage$
    {179, 2675, 3564},	// Sonnet::Speller::setLanguage$
    {179, 3040, 3570},	// Sonnet::Speller::storeReplacement$$
    {179, 3061, 3568},	// Sonnet::Speller::suggest$
    {179, 3090, 3584},	// Sonnet::Speller::testAttribute$
    {179, 3435, 3589},	// Sonnet::Speller::~Speller
    {181, 1941, 3590},	// kndbgstream::kndbgstream
    {181, 1942, 3591},	// kndbgstream::kndbgstream#
    {181, 3437, 3592},	// kndbgstream::~kndbgstream
};

}

extern "C" {

SMOKE_IMPORT void init_qtcore_Smoke();
SMOKE_IMPORT void init_qtnetwork_Smoke();
SMOKE_IMPORT void init_qtdbus_Smoke();

static bool initialized = false;
Smoke *kdecore_Smoke = 0;

// Create the Smoke instance encapsulating all the above.
void init_kdecore_Smoke() {
    init_qtcore_Smoke();
    init_qtnetwork_Smoke();
    init_qtdbus_Smoke();
    if (initialized) return;
    kdecore_Smoke = new Smoke(
        "kdecore",
        __smokekdecore::classes, 182,
        __smokekdecore::methods, 3593,
        __smokekdecore::methodMaps, 3234,
        __smokekdecore::methodNames, 3437,
        __smokekdecore::types, 641,
        __smokekdecore::inheritanceList,
        __smokekdecore::argumentList,
        __smokekdecore::ambiguousMethodList,
        __smokekdecore::cast );
    initialized = true;
}

void delete_kdecore_Smoke() { delete kdecore_Smoke; }

}
