/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SHARED_WORKERS)

#include "JSSharedWorker.h"

#include "JSMessagePort.h"
#include "MessagePort.h"
#include "SharedWorker.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSharedWorkerTableValues[] =
{
    { "port", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSharedWorkerPort), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSharedWorkerConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSharedWorkerTable = { 4, 3, JSSharedWorkerTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSharedWorkerConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSharedWorkerConstructorTable = { 1, 0, JSSharedWorkerConstructorTableValues, 0 };
const ClassInfo JSSharedWorkerConstructor::s_info = { "SharedWorkerConstructor", &Base::s_info, &JSSharedWorkerConstructorTable, 0, CREATE_METHOD_TABLE(JSSharedWorkerConstructor) };

JSSharedWorkerConstructor::JSSharedWorkerConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSharedWorkerConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSharedWorkerPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->globalData(), exec->propertyNames().length, jsNumber(2), ReadOnly | DontDelete | DontEnum);
}

bool JSSharedWorkerConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSharedWorkerConstructor, JSDOMWrapper>(exec, &JSSharedWorkerConstructorTable, jsCast<JSSharedWorkerConstructor*>(cell), propertyName, slot);
}

bool JSSharedWorkerConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSharedWorkerConstructor, JSDOMWrapper>(exec, &JSSharedWorkerConstructorTable, jsCast<JSSharedWorkerConstructor*>(object), propertyName, descriptor);
}

ConstructType JSSharedWorkerConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSSharedWorker;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSSharedWorkerPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSharedWorkerPrototypeTable = { 1, 0, JSSharedWorkerPrototypeTableValues, 0 };
const ClassInfo JSSharedWorkerPrototype::s_info = { "SharedWorkerPrototype", &Base::s_info, &JSSharedWorkerPrototypeTable, 0, CREATE_METHOD_TABLE(JSSharedWorkerPrototype) };

JSObject* JSSharedWorkerPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSharedWorker>(exec, globalObject);
}

const ClassInfo JSSharedWorker::s_info = { "SharedWorker", &Base::s_info, &JSSharedWorkerTable, 0 , CREATE_METHOD_TABLE(JSSharedWorker) };

JSSharedWorker::JSSharedWorker(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SharedWorker> impl)
    : JSAbstractWorker(structure, globalObject, impl)
{
}

void JSSharedWorker::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSharedWorker::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSharedWorkerPrototype::create(exec->globalData(), globalObject, JSSharedWorkerPrototype::createStructure(exec->globalData(), globalObject, JSAbstractWorkerPrototype::self(exec, globalObject)));
}

bool JSSharedWorker::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSharedWorker* thisObject = jsCast<JSSharedWorker*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSharedWorker, Base>(exec, &JSSharedWorkerTable, thisObject, propertyName, slot);
}

bool JSSharedWorker::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSharedWorker* thisObject = jsCast<JSSharedWorker*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSharedWorker, Base>(exec, &JSSharedWorkerTable, thisObject, propertyName, descriptor);
}

JSValue jsSharedWorkerPort(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSharedWorker* castedThis = jsCast<JSSharedWorker*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SharedWorker* impl = static_cast<SharedWorker*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->port()));
    return result;
}


JSValue jsSharedWorkerConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSharedWorker* domObject = jsCast<JSSharedWorker*>(asObject(slotBase));
    return JSSharedWorker::getConstructor(exec, domObject->globalObject());
}

JSValue JSSharedWorker::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSharedWorkerConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

static inline bool isObservable(JSSharedWorker* jsSharedWorker)
{
    if (jsSharedWorker->hasCustomProperties())
        return true;
    return false;
}

bool JSSharedWorkerOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSharedWorker* jsSharedWorker = jsCast<JSSharedWorker*>(handle.get().asCell());
    if (jsSharedWorker->impl()->hasPendingActivity())
        return true;
    if (!isObservable(jsSharedWorker))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSharedWorkerOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSharedWorker* jsSharedWorker = jsCast<JSSharedWorker*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSharedWorker->impl(), jsSharedWorker);
    jsSharedWorker->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SharedWorker* impl)
{
    return wrap<JSSharedWorker>(exec, globalObject, impl);
}

SharedWorker* toSharedWorker(JSC::JSValue value)
{
    return value.inherits(&JSSharedWorker::s_info) ? jsCast<JSSharedWorker*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SHARED_WORKERS)
