/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGAnimatedRect.h"

#include "FloatRect.h"
#include "JSSVGRect.h"
#include "SVGRect.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGAnimatedRectTableValues[] =
{
    { "baseVal", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedRectBaseVal), (intptr_t)0, NoIntrinsic },
    { "animVal", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedRectAnimVal), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedRectConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAnimatedRectTable = { 8, 7, JSSVGAnimatedRectTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGAnimatedRectConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAnimatedRectConstructorTable = { 1, 0, JSSVGAnimatedRectConstructorTableValues, 0 };
const ClassInfo JSSVGAnimatedRectConstructor::s_info = { "SVGAnimatedRectConstructor", &Base::s_info, &JSSVGAnimatedRectConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGAnimatedRectConstructor) };

JSSVGAnimatedRectConstructor::JSSVGAnimatedRectConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGAnimatedRectConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGAnimatedRectPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGAnimatedRectConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAnimatedRectConstructor, JSDOMWrapper>(exec, &JSSVGAnimatedRectConstructorTable, jsCast<JSSVGAnimatedRectConstructor*>(cell), propertyName, slot);
}

bool JSSVGAnimatedRectConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGAnimatedRectConstructor, JSDOMWrapper>(exec, &JSSVGAnimatedRectConstructorTable, jsCast<JSSVGAnimatedRectConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGAnimatedRectPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAnimatedRectPrototypeTable = { 1, 0, JSSVGAnimatedRectPrototypeTableValues, 0 };
const ClassInfo JSSVGAnimatedRectPrototype::s_info = { "SVGAnimatedRectPrototype", &Base::s_info, &JSSVGAnimatedRectPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGAnimatedRectPrototype) };

JSObject* JSSVGAnimatedRectPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGAnimatedRect>(exec, globalObject);
}

const ClassInfo JSSVGAnimatedRect::s_info = { "SVGAnimatedRect", &Base::s_info, &JSSVGAnimatedRectTable, 0 , CREATE_METHOD_TABLE(JSSVGAnimatedRect) };

JSSVGAnimatedRect::JSSVGAnimatedRect(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGAnimatedRect> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSVGAnimatedRect::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGAnimatedRect::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGAnimatedRectPrototype::create(exec->globalData(), globalObject, JSSVGAnimatedRectPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSSVGAnimatedRect::destroy(JSC::JSCell* cell)
{
    JSSVGAnimatedRect* thisObject = static_cast<JSSVGAnimatedRect*>(cell);
    thisObject->JSSVGAnimatedRect::~JSSVGAnimatedRect();
}

JSSVGAnimatedRect::~JSSVGAnimatedRect()
{
    releaseImplIfNotNull();
}

bool JSSVGAnimatedRect::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGAnimatedRect* thisObject = jsCast<JSSVGAnimatedRect*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGAnimatedRect, Base>(exec, &JSSVGAnimatedRectTable, thisObject, propertyName, slot);
}

bool JSSVGAnimatedRect::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGAnimatedRect* thisObject = jsCast<JSSVGAnimatedRect*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGAnimatedRect, Base>(exec, &JSSVGAnimatedRectTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGAnimatedRectBaseVal(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAnimatedRect* castedThis = jsCast<JSSVGAnimatedRect*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAnimatedRect* impl = static_cast<SVGAnimatedRect*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(static_cast<SVGPropertyTearOff<FloatRect>*>(impl->baseVal())));
    return result;
}


JSValue jsSVGAnimatedRectAnimVal(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAnimatedRect* castedThis = jsCast<JSSVGAnimatedRect*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAnimatedRect* impl = static_cast<SVGAnimatedRect*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(static_cast<SVGPropertyTearOff<FloatRect>*>(impl->animVal())));
    return result;
}


JSValue jsSVGAnimatedRectConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAnimatedRect* domObject = jsCast<JSSVGAnimatedRect*>(asObject(slotBase));
    return JSSVGAnimatedRect::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGAnimatedRect::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGAnimatedRectConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

static inline bool isObservable(JSSVGAnimatedRect* jsSVGAnimatedRect)
{
    if (jsSVGAnimatedRect->hasCustomProperties())
        return true;
    return false;
}

bool JSSVGAnimatedRectOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSVGAnimatedRect* jsSVGAnimatedRect = jsCast<JSSVGAnimatedRect*>(handle.get().asCell());
    if (!isObservable(jsSVGAnimatedRect))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGAnimatedRectOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSVGAnimatedRect* jsSVGAnimatedRect = jsCast<JSSVGAnimatedRect*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGAnimatedRect->impl(), jsSVGAnimatedRect);
    jsSVGAnimatedRect->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGAnimatedRect* impl)
{
    return wrap<JSSVGAnimatedRect>(exec, globalObject, impl);
}

SVGAnimatedRect* toSVGAnimatedRect(JSC::JSValue value)
{
    return value.inherits(&JSSVGAnimatedRect::s_info) ? jsCast<JSSVGAnimatedRect*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
