/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLTableRowElement.h"

#include "ExceptionCode.h"
#include "HTMLCollection.h"
#include "HTMLElement.h"
#include "HTMLNames.h"
#include "HTMLTableRowElement.h"
#include "JSDOMBinding.h"
#include "JSHTMLCollection.h"
#include "JSHTMLElement.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLTableRowElementTableValues[] =
{
    { "rowIndex", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableRowElementRowIndex), (intptr_t)0, NoIntrinsic },
    { "sectionRowIndex", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableRowElementSectionRowIndex), (intptr_t)0, NoIntrinsic },
    { "cells", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableRowElementCells), (intptr_t)0, NoIntrinsic },
    { "align", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableRowElementAlign), (intptr_t)setJSHTMLTableRowElementAlign, NoIntrinsic },
    { "bgColor", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableRowElementBgColor), (intptr_t)setJSHTMLTableRowElementBgColor, NoIntrinsic },
    { "ch", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableRowElementCh), (intptr_t)setJSHTMLTableRowElementCh, NoIntrinsic },
    { "chOff", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableRowElementChOff), (intptr_t)setJSHTMLTableRowElementChOff, NoIntrinsic },
    { "vAlign", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableRowElementVAlign), (intptr_t)setJSHTMLTableRowElementVAlign, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTableRowElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLTableRowElementTable = { 33, 31, JSHTMLTableRowElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLTableRowElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLTableRowElementConstructorTable = { 1, 0, JSHTMLTableRowElementConstructorTableValues, 0 };
const ClassInfo JSHTMLTableRowElementConstructor::s_info = { "HTMLTableRowElementConstructor", &Base::s_info, &JSHTMLTableRowElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLTableRowElementConstructor) };

JSHTMLTableRowElementConstructor::JSHTMLTableRowElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLTableRowElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLTableRowElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLTableRowElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLTableRowElementConstructor, JSDOMWrapper>(exec, &JSHTMLTableRowElementConstructorTable, jsCast<JSHTMLTableRowElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLTableRowElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLTableRowElementConstructor, JSDOMWrapper>(exec, &JSHTMLTableRowElementConstructorTable, jsCast<JSHTMLTableRowElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLTableRowElementPrototypeTableValues[] =
{
    { "insertCell", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLTableRowElementPrototypeFunctionInsertCell), (intptr_t)1, NoIntrinsic },
    { "deleteCell", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLTableRowElementPrototypeFunctionDeleteCell), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLTableRowElementPrototypeTable = { 4, 3, JSHTMLTableRowElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLTableRowElementPrototype::s_info = { "HTMLTableRowElementPrototype", &Base::s_info, &JSHTMLTableRowElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLTableRowElementPrototype) };

JSObject* JSHTMLTableRowElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLTableRowElement>(exec, globalObject);
}

bool JSHTMLTableRowElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLTableRowElementPrototype* thisObject = jsCast<JSHTMLTableRowElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLTableRowElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSHTMLTableRowElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLTableRowElementPrototype* thisObject = jsCast<JSHTMLTableRowElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSHTMLTableRowElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSHTMLTableRowElement::s_info = { "HTMLTableRowElement", &Base::s_info, &JSHTMLTableRowElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLTableRowElement) };

JSHTMLTableRowElement::JSHTMLTableRowElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLTableRowElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLTableRowElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLTableRowElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLTableRowElementPrototype::create(exec->globalData(), globalObject, JSHTMLTableRowElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLTableRowElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLTableRowElement* thisObject = jsCast<JSHTMLTableRowElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLTableRowElement, Base>(exec, &JSHTMLTableRowElementTable, thisObject, propertyName, slot);
}

bool JSHTMLTableRowElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLTableRowElement* thisObject = jsCast<JSHTMLTableRowElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLTableRowElement, Base>(exec, &JSHTMLTableRowElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLTableRowElementRowIndex(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableRowElement* castedThis = jsCast<JSHTMLTableRowElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableRowElement* impl = static_cast<HTMLTableRowElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->rowIndex());
    return result;
}


JSValue jsHTMLTableRowElementSectionRowIndex(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableRowElement* castedThis = jsCast<JSHTMLTableRowElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableRowElement* impl = static_cast<HTMLTableRowElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->sectionRowIndex());
    return result;
}


JSValue jsHTMLTableRowElementCells(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableRowElement* castedThis = jsCast<JSHTMLTableRowElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableRowElement* impl = static_cast<HTMLTableRowElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->cells()));
    return result;
}


JSValue jsHTMLTableRowElementAlign(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableRowElement* castedThis = jsCast<JSHTMLTableRowElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableRowElement* impl = static_cast<HTMLTableRowElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::alignAttr));
    return result;
}


JSValue jsHTMLTableRowElementBgColor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableRowElement* castedThis = jsCast<JSHTMLTableRowElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableRowElement* impl = static_cast<HTMLTableRowElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::bgcolorAttr));
    return result;
}


JSValue jsHTMLTableRowElementCh(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableRowElement* castedThis = jsCast<JSHTMLTableRowElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableRowElement* impl = static_cast<HTMLTableRowElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::charAttr));
    return result;
}


JSValue jsHTMLTableRowElementChOff(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableRowElement* castedThis = jsCast<JSHTMLTableRowElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableRowElement* impl = static_cast<HTMLTableRowElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::charoffAttr));
    return result;
}


JSValue jsHTMLTableRowElementVAlign(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableRowElement* castedThis = jsCast<JSHTMLTableRowElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTableRowElement* impl = static_cast<HTMLTableRowElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::valignAttr));
    return result;
}


JSValue jsHTMLTableRowElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTableRowElement* domObject = jsCast<JSHTMLTableRowElement*>(asObject(slotBase));
    return JSHTMLTableRowElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLTableRowElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLTableRowElement* thisObject = jsCast<JSHTMLTableRowElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLTableRowElement, Base>(exec, propertyName, value, &JSHTMLTableRowElementTable, thisObject, slot);
}

void setJSHTMLTableRowElementAlign(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableRowElement* castedThis = jsCast<JSHTMLTableRowElement*>(thisObject);
    HTMLTableRowElement* impl = static_cast<HTMLTableRowElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::alignAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLTableRowElementBgColor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableRowElement* castedThis = jsCast<JSHTMLTableRowElement*>(thisObject);
    HTMLTableRowElement* impl = static_cast<HTMLTableRowElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::bgcolorAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLTableRowElementCh(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableRowElement* castedThis = jsCast<JSHTMLTableRowElement*>(thisObject);
    HTMLTableRowElement* impl = static_cast<HTMLTableRowElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::charAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLTableRowElementChOff(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableRowElement* castedThis = jsCast<JSHTMLTableRowElement*>(thisObject);
    HTMLTableRowElement* impl = static_cast<HTMLTableRowElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::charoffAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLTableRowElementVAlign(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTableRowElement* castedThis = jsCast<JSHTMLTableRowElement*>(thisObject);
    HTMLTableRowElement* impl = static_cast<HTMLTableRowElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::valignAttr, valueToStringWithNullCheck(exec, value));
}


JSValue JSHTMLTableRowElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLTableRowElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHTMLTableRowElementPrototypeFunctionInsertCell(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLTableRowElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLTableRowElement* castedThis = jsCast<JSHTMLTableRowElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLTableRowElement::s_info);
    HTMLTableRowElement* impl = static_cast<HTMLTableRowElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    int index(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->insertCell(index, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsHTMLTableRowElementPrototypeFunctionDeleteCell(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLTableRowElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLTableRowElement* castedThis = jsCast<JSHTMLTableRowElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLTableRowElement::s_info);
    HTMLTableRowElement* impl = static_cast<HTMLTableRowElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    int index(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->deleteCell(index, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}


}
