/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSTextEvent.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMWindow.h"
#include "KURL.h"
#include "TextEvent.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSTextEventTableValues[] =
{
    { "data", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextEventData), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTextEventConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSTextEventTable = { 4, 3, JSTextEventTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSTextEventConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSTextEventConstructorTable = { 1, 0, JSTextEventConstructorTableValues, 0 };
const ClassInfo JSTextEventConstructor::s_info = { "TextEventConstructor", &Base::s_info, &JSTextEventConstructorTable, 0, CREATE_METHOD_TABLE(JSTextEventConstructor) };

JSTextEventConstructor::JSTextEventConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSTextEventConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSTextEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSTextEventConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSTextEventConstructor, JSDOMWrapper>(exec, &JSTextEventConstructorTable, jsCast<JSTextEventConstructor*>(cell), propertyName, slot);
}

bool JSTextEventConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSTextEventConstructor, JSDOMWrapper>(exec, &JSTextEventConstructorTable, jsCast<JSTextEventConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSTextEventPrototypeTableValues[] =
{
    { "initTextEvent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsTextEventPrototypeFunctionInitTextEvent), (intptr_t)5, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSTextEventPrototypeTable = { 2, 1, JSTextEventPrototypeTableValues, 0 };
const ClassInfo JSTextEventPrototype::s_info = { "TextEventPrototype", &Base::s_info, &JSTextEventPrototypeTable, 0, CREATE_METHOD_TABLE(JSTextEventPrototype) };

JSObject* JSTextEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSTextEvent>(exec, globalObject);
}

bool JSTextEventPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSTextEventPrototype* thisObject = jsCast<JSTextEventPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSTextEventPrototypeTable, thisObject, propertyName, slot);
}

bool JSTextEventPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSTextEventPrototype* thisObject = jsCast<JSTextEventPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSTextEventPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSTextEvent::s_info = { "TextEvent", &Base::s_info, &JSTextEventTable, 0 , CREATE_METHOD_TABLE(JSTextEvent) };

JSTextEvent::JSTextEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<TextEvent> impl)
    : JSUIEvent(structure, globalObject, impl)
{
}

void JSTextEvent::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSTextEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSTextEventPrototype::create(exec->globalData(), globalObject, JSTextEventPrototype::createStructure(exec->globalData(), globalObject, JSUIEventPrototype::self(exec, globalObject)));
}

bool JSTextEvent::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSTextEvent* thisObject = jsCast<JSTextEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSTextEvent, Base>(exec, &JSTextEventTable, thisObject, propertyName, slot);
}

bool JSTextEvent::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSTextEvent* thisObject = jsCast<JSTextEvent*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSTextEvent, Base>(exec, &JSTextEventTable, thisObject, propertyName, descriptor);
}

JSValue jsTextEventData(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTextEvent* castedThis = jsCast<JSTextEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    TextEvent* impl = static_cast<TextEvent*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->data());
    return result;
}


JSValue jsTextEventConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSTextEvent* domObject = jsCast<JSTextEvent*>(asObject(slotBase));
    return JSTextEvent::getConstructor(exec, domObject->globalObject());
}

JSValue JSTextEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTextEventConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsTextEventPrototypeFunctionInitTextEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSTextEvent::s_info))
        return throwVMTypeError(exec);
    JSTextEvent* castedThis = jsCast<JSTextEvent*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSTextEvent::s_info);
    TextEvent* impl = static_cast<TextEvent*>(castedThis->impl());
    const String& typeArg(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool canBubbleArg(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool cancelableArg(MAYBE_MISSING_PARAMETER(exec, 2, DefaultIsUndefined).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    DOMWindow* viewArg(toDOMWindow(MAYBE_MISSING_PARAMETER(exec, 3, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& dataArg(MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 4, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->initTextEvent(typeArg, canBubbleArg, cancelableArg, viewArg, dataArg);
    return JSValue::encode(jsUndefined());
}


}
