/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FILTERS) && ENABLE(SVG)

#include "JSSVGFECompositeElement.h"

#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "ExceptionCode.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedEnumeration.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedNumber.h"
#include "JSSVGAnimatedString.h"
#include "SVGFECompositeElement.h"
#include "StylePropertySet.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGFECompositeElementTableValues[] =
{
    { "in1", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementIn1), (intptr_t)0, NoIntrinsic },
    { "in2", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementIn2), (intptr_t)0, NoIntrinsic },
    { "operator", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementOperator), (intptr_t)0, NoIntrinsic },
    { "k1", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementK1), (intptr_t)0, NoIntrinsic },
    { "k2", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementK2), (intptr_t)0, NoIntrinsic },
    { "k3", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementK3), (intptr_t)0, NoIntrinsic },
    { "k4", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementK4), (intptr_t)0, NoIntrinsic },
    { "x", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementX), (intptr_t)0, NoIntrinsic },
    { "y", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementY), (intptr_t)0, NoIntrinsic },
    { "width", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementWidth), (intptr_t)0, NoIntrinsic },
    { "height", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementHeight), (intptr_t)0, NoIntrinsic },
    { "result", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementResult), (intptr_t)0, NoIntrinsic },
    { "className", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementClassName), (intptr_t)0, NoIntrinsic },
    { "style", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementStyle), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFECompositeElementTable = { 34, 31, JSSVGFECompositeElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGFECompositeElementConstructorTableValues[] =
{
    { "SVG_FECOMPOSITE_OPERATOR_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "SVG_FECOMPOSITE_OPERATOR_OVER", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_OVER), (intptr_t)0, NoIntrinsic },
    { "SVG_FECOMPOSITE_OPERATOR_IN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_IN), (intptr_t)0, NoIntrinsic },
    { "SVG_FECOMPOSITE_OPERATOR_OUT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_OUT), (intptr_t)0, NoIntrinsic },
    { "SVG_FECOMPOSITE_OPERATOR_ATOP", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_ATOP), (intptr_t)0, NoIntrinsic },
    { "SVG_FECOMPOSITE_OPERATOR_XOR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_XOR), (intptr_t)0, NoIntrinsic },
    { "SVG_FECOMPOSITE_OPERATOR_ARITHMETIC", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_ARITHMETIC), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFECompositeElementConstructorTable = { 16, 15, JSSVGFECompositeElementConstructorTableValues, 0 };
const ClassInfo JSSVGFECompositeElementConstructor::s_info = { "SVGFECompositeElementConstructor", &Base::s_info, &JSSVGFECompositeElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGFECompositeElementConstructor) };

JSSVGFECompositeElementConstructor::JSSVGFECompositeElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGFECompositeElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGFECompositeElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGFECompositeElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFECompositeElementConstructor, JSDOMWrapper>(exec, &JSSVGFECompositeElementConstructorTable, jsCast<JSSVGFECompositeElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGFECompositeElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGFECompositeElementConstructor, JSDOMWrapper>(exec, &JSSVGFECompositeElementConstructorTable, jsCast<JSSVGFECompositeElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGFECompositeElementPrototypeTableValues[] =
{
    { "SVG_FECOMPOSITE_OPERATOR_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "SVG_FECOMPOSITE_OPERATOR_OVER", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_OVER), (intptr_t)0, NoIntrinsic },
    { "SVG_FECOMPOSITE_OPERATOR_IN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_IN), (intptr_t)0, NoIntrinsic },
    { "SVG_FECOMPOSITE_OPERATOR_OUT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_OUT), (intptr_t)0, NoIntrinsic },
    { "SVG_FECOMPOSITE_OPERATOR_ATOP", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_ATOP), (intptr_t)0, NoIntrinsic },
    { "SVG_FECOMPOSITE_OPERATOR_XOR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_XOR), (intptr_t)0, NoIntrinsic },
    { "SVG_FECOMPOSITE_OPERATOR_ARITHMETIC", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_ARITHMETIC), (intptr_t)0, NoIntrinsic },
    { "getPresentationAttribute", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGFECompositeElementPrototypeFunctionGetPresentationAttribute), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFECompositeElementPrototypeTable = { 17, 15, JSSVGFECompositeElementPrototypeTableValues, 0 };
const ClassInfo JSSVGFECompositeElementPrototype::s_info = { "SVGFECompositeElementPrototype", &Base::s_info, &JSSVGFECompositeElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGFECompositeElementPrototype) };

JSObject* JSSVGFECompositeElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGFECompositeElement>(exec, globalObject);
}

bool JSSVGFECompositeElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGFECompositeElementPrototype* thisObject = jsCast<JSSVGFECompositeElementPrototype*>(cell);
    return getStaticPropertySlot<JSSVGFECompositeElementPrototype, JSObject>(exec, &JSSVGFECompositeElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGFECompositeElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGFECompositeElementPrototype* thisObject = jsCast<JSSVGFECompositeElementPrototype*>(object);
    return getStaticPropertyDescriptor<JSSVGFECompositeElementPrototype, JSObject>(exec, &JSSVGFECompositeElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGFECompositeElement::s_info = { "SVGFECompositeElement", &Base::s_info, &JSSVGFECompositeElementTable, 0 , CREATE_METHOD_TABLE(JSSVGFECompositeElement) };

JSSVGFECompositeElement::JSSVGFECompositeElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGFECompositeElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

void JSSVGFECompositeElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGFECompositeElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGFECompositeElementPrototype::create(exec->globalData(), globalObject, JSSVGFECompositeElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGFECompositeElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGFECompositeElement* thisObject = jsCast<JSSVGFECompositeElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGFECompositeElement, Base>(exec, &JSSVGFECompositeElementTable, thisObject, propertyName, slot);
}

bool JSSVGFECompositeElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGFECompositeElement* thisObject = jsCast<JSSVGFECompositeElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGFECompositeElement, Base>(exec, &JSSVGFECompositeElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGFECompositeElementIn1(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFECompositeElement* castedThis = jsCast<JSSVGFECompositeElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFECompositeElement* impl = static_cast<SVGFECompositeElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->in1Animated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFECompositeElementIn2(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFECompositeElement* castedThis = jsCast<JSSVGFECompositeElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFECompositeElement* impl = static_cast<SVGFECompositeElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->in2Animated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFECompositeElementOperator(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFECompositeElement* castedThis = jsCast<JSSVGFECompositeElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFECompositeElement* impl = static_cast<SVGFECompositeElement*>(castedThis->impl());
    RefPtr<SVGAnimatedEnumeration> obj = impl->_operatorAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFECompositeElementK1(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFECompositeElement* castedThis = jsCast<JSSVGFECompositeElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFECompositeElement* impl = static_cast<SVGFECompositeElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = impl->k1Animated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFECompositeElementK2(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFECompositeElement* castedThis = jsCast<JSSVGFECompositeElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFECompositeElement* impl = static_cast<SVGFECompositeElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = impl->k2Animated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFECompositeElementK3(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFECompositeElement* castedThis = jsCast<JSSVGFECompositeElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFECompositeElement* impl = static_cast<SVGFECompositeElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = impl->k3Animated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFECompositeElementK4(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFECompositeElement* castedThis = jsCast<JSSVGFECompositeElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFECompositeElement* impl = static_cast<SVGFECompositeElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = impl->k4Animated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFECompositeElementX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFECompositeElement* castedThis = jsCast<JSSVGFECompositeElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFECompositeElement* impl = static_cast<SVGFECompositeElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->xAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFECompositeElementY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFECompositeElement* castedThis = jsCast<JSSVGFECompositeElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFECompositeElement* impl = static_cast<SVGFECompositeElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->yAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFECompositeElementWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFECompositeElement* castedThis = jsCast<JSSVGFECompositeElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFECompositeElement* impl = static_cast<SVGFECompositeElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->widthAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFECompositeElementHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFECompositeElement* castedThis = jsCast<JSSVGFECompositeElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFECompositeElement* impl = static_cast<SVGFECompositeElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->heightAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFECompositeElementResult(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFECompositeElement* castedThis = jsCast<JSSVGFECompositeElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFECompositeElement* impl = static_cast<SVGFECompositeElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->resultAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFECompositeElementClassName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFECompositeElement* castedThis = jsCast<JSSVGFECompositeElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFECompositeElement* impl = static_cast<SVGFECompositeElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->classNameAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFECompositeElementStyle(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFECompositeElement* castedThis = jsCast<JSSVGFECompositeElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFECompositeElement* impl = static_cast<SVGFECompositeElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->style()));
    return result;
}


JSValue jsSVGFECompositeElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFECompositeElement* domObject = jsCast<JSSVGFECompositeElement*>(asObject(slotBase));
    return JSSVGFECompositeElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGFECompositeElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGFECompositeElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGFECompositeElementPrototypeFunctionGetPresentationAttribute(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGFECompositeElement::s_info))
        return throwVMTypeError(exec);
    JSSVGFECompositeElement* castedThis = jsCast<JSSVGFECompositeElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGFECompositeElement::s_info);
    SVGFECompositeElement* impl = static_cast<SVGFECompositeElement*>(castedThis->impl());
    const String& name(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getPresentationAttribute(name)));
    return JSValue::encode(result);
}

// Constant getters

JSValue jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_UNKNOWN(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_OVER(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_IN(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_OUT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}

JSValue jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_ATOP(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(4));
}

JSValue jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_XOR(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(5));
}

JSValue jsSVGFECompositeElementSVG_FECOMPOSITE_OPERATOR_ARITHMETIC(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(6));
}


}

#endif // ENABLE(FILTERS) && ENABLE(SVG)
