/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGAnimatedTransformList.h"

#include "JSSVGTransformList.h"
#include "SVGTransformList.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGAnimatedTransformListTableValues[] =
{
    { "baseVal", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedTransformListBaseVal), (intptr_t)0, NoIntrinsic },
    { "animVal", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedTransformListAnimVal), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGAnimatedTransformListConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAnimatedTransformListTable = { 8, 7, JSSVGAnimatedTransformListTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGAnimatedTransformListConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAnimatedTransformListConstructorTable = { 1, 0, JSSVGAnimatedTransformListConstructorTableValues, 0 };
const ClassInfo JSSVGAnimatedTransformListConstructor::s_info = { "SVGAnimatedTransformListConstructor", &Base::s_info, &JSSVGAnimatedTransformListConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGAnimatedTransformListConstructor) };

JSSVGAnimatedTransformListConstructor::JSSVGAnimatedTransformListConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGAnimatedTransformListConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGAnimatedTransformListPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGAnimatedTransformListConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGAnimatedTransformListConstructor, JSDOMWrapper>(exec, &JSSVGAnimatedTransformListConstructorTable, jsCast<JSSVGAnimatedTransformListConstructor*>(cell), propertyName, slot);
}

bool JSSVGAnimatedTransformListConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGAnimatedTransformListConstructor, JSDOMWrapper>(exec, &JSSVGAnimatedTransformListConstructorTable, jsCast<JSSVGAnimatedTransformListConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGAnimatedTransformListPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGAnimatedTransformListPrototypeTable = { 1, 0, JSSVGAnimatedTransformListPrototypeTableValues, 0 };
const ClassInfo JSSVGAnimatedTransformListPrototype::s_info = { "SVGAnimatedTransformListPrototype", &Base::s_info, &JSSVGAnimatedTransformListPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGAnimatedTransformListPrototype) };

JSObject* JSSVGAnimatedTransformListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGAnimatedTransformList>(exec, globalObject);
}

const ClassInfo JSSVGAnimatedTransformList::s_info = { "SVGAnimatedTransformList", &Base::s_info, &JSSVGAnimatedTransformListTable, 0 , CREATE_METHOD_TABLE(JSSVGAnimatedTransformList) };

JSSVGAnimatedTransformList::JSSVGAnimatedTransformList(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGAnimatedTransformList> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSVGAnimatedTransformList::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGAnimatedTransformList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGAnimatedTransformListPrototype::create(exec->globalData(), globalObject, JSSVGAnimatedTransformListPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSSVGAnimatedTransformList::destroy(JSC::JSCell* cell)
{
    JSSVGAnimatedTransformList* thisObject = static_cast<JSSVGAnimatedTransformList*>(cell);
    thisObject->JSSVGAnimatedTransformList::~JSSVGAnimatedTransformList();
}

JSSVGAnimatedTransformList::~JSSVGAnimatedTransformList()
{
    releaseImplIfNotNull();
}

bool JSSVGAnimatedTransformList::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGAnimatedTransformList* thisObject = jsCast<JSSVGAnimatedTransformList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGAnimatedTransformList, Base>(exec, &JSSVGAnimatedTransformListTable, thisObject, propertyName, slot);
}

bool JSSVGAnimatedTransformList::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGAnimatedTransformList* thisObject = jsCast<JSSVGAnimatedTransformList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGAnimatedTransformList, Base>(exec, &JSSVGAnimatedTransformListTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGAnimatedTransformListBaseVal(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAnimatedTransformList* castedThis = jsCast<JSSVGAnimatedTransformList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAnimatedTransformList* impl = static_cast<SVGAnimatedTransformList*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(static_cast<SVGTransformListPropertyTearOff*>(impl->baseVal())));
    return result;
}


JSValue jsSVGAnimatedTransformListAnimVal(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAnimatedTransformList* castedThis = jsCast<JSSVGAnimatedTransformList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGAnimatedTransformList* impl = static_cast<SVGAnimatedTransformList*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(static_cast<SVGTransformListPropertyTearOff*>(impl->animVal())));
    return result;
}


JSValue jsSVGAnimatedTransformListConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGAnimatedTransformList* domObject = jsCast<JSSVGAnimatedTransformList*>(asObject(slotBase));
    return JSSVGAnimatedTransformList::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGAnimatedTransformList::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGAnimatedTransformListConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

static inline bool isObservable(JSSVGAnimatedTransformList* jsSVGAnimatedTransformList)
{
    if (jsSVGAnimatedTransformList->hasCustomProperties())
        return true;
    return false;
}

bool JSSVGAnimatedTransformListOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSVGAnimatedTransformList* jsSVGAnimatedTransformList = jsCast<JSSVGAnimatedTransformList*>(handle.get().asCell());
    if (!isObservable(jsSVGAnimatedTransformList))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGAnimatedTransformListOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSVGAnimatedTransformList* jsSVGAnimatedTransformList = jsCast<JSSVGAnimatedTransformList*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGAnimatedTransformList->impl(), jsSVGAnimatedTransformList);
    jsSVGAnimatedTransformList->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGAnimatedTransformList* impl)
{
    return wrap<JSSVGAnimatedTransformList>(exec, globalObject, impl);
}

SVGAnimatedTransformList* toSVGAnimatedTransformList(JSC::JSValue value)
{
    return value.inherits(&JSSVGAnimatedTransformList::s_info) ? jsCast<JSSVGAnimatedTransformList*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
