/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSMediaError.h"

#include "MediaError.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSMediaErrorTableValues[] =
{
    { "code", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaErrorCode), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaErrorConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMediaErrorTable = { 5, 3, JSMediaErrorTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSMediaErrorConstructorTableValues[] =
{
    { "MEDIA_ERR_ABORTED", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaErrorMEDIA_ERR_ABORTED), (intptr_t)0, NoIntrinsic },
    { "MEDIA_ERR_NETWORK", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaErrorMEDIA_ERR_NETWORK), (intptr_t)0, NoIntrinsic },
    { "MEDIA_ERR_DECODE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaErrorMEDIA_ERR_DECODE), (intptr_t)0, NoIntrinsic },
    { "MEDIA_ERR_SRC_NOT_SUPPORTED", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaErrorMEDIA_ERR_SRC_NOT_SUPPORTED), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMediaErrorConstructorTable = { 9, 7, JSMediaErrorConstructorTableValues, 0 };

COMPILE_ASSERT(1 == MediaError::MEDIA_ERR_ABORTED, MediaErrorEnumMEDIA_ERR_ABORTEDIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == MediaError::MEDIA_ERR_NETWORK, MediaErrorEnumMEDIA_ERR_NETWORKIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == MediaError::MEDIA_ERR_DECODE, MediaErrorEnumMEDIA_ERR_DECODEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(4 == MediaError::MEDIA_ERR_SRC_NOT_SUPPORTED, MediaErrorEnumMEDIA_ERR_SRC_NOT_SUPPORTEDIsWrongUseDoNotCheckConstants);

const ClassInfo JSMediaErrorConstructor::s_info = { "MediaErrorConstructor", &Base::s_info, &JSMediaErrorConstructorTable, 0, CREATE_METHOD_TABLE(JSMediaErrorConstructor) };

JSMediaErrorConstructor::JSMediaErrorConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSMediaErrorConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSMediaErrorPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSMediaErrorConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMediaErrorConstructor, JSDOMWrapper>(exec, &JSMediaErrorConstructorTable, jsCast<JSMediaErrorConstructor*>(cell), propertyName, slot);
}

bool JSMediaErrorConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSMediaErrorConstructor, JSDOMWrapper>(exec, &JSMediaErrorConstructorTable, jsCast<JSMediaErrorConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSMediaErrorPrototypeTableValues[] =
{
    { "MEDIA_ERR_ABORTED", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaErrorMEDIA_ERR_ABORTED), (intptr_t)0, NoIntrinsic },
    { "MEDIA_ERR_NETWORK", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaErrorMEDIA_ERR_NETWORK), (intptr_t)0, NoIntrinsic },
    { "MEDIA_ERR_DECODE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaErrorMEDIA_ERR_DECODE), (intptr_t)0, NoIntrinsic },
    { "MEDIA_ERR_SRC_NOT_SUPPORTED", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaErrorMEDIA_ERR_SRC_NOT_SUPPORTED), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSMediaErrorPrototypeTable = { 9, 7, JSMediaErrorPrototypeTableValues, 0 };
const ClassInfo JSMediaErrorPrototype::s_info = { "MediaErrorPrototype", &Base::s_info, &JSMediaErrorPrototypeTable, 0, CREATE_METHOD_TABLE(JSMediaErrorPrototype) };

JSObject* JSMediaErrorPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMediaError>(exec, globalObject);
}

bool JSMediaErrorPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSMediaErrorPrototype* thisObject = jsCast<JSMediaErrorPrototype*>(cell);
    return getStaticValueSlot<JSMediaErrorPrototype, JSObject>(exec, &JSMediaErrorPrototypeTable, thisObject, propertyName, slot);
}

bool JSMediaErrorPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSMediaErrorPrototype* thisObject = jsCast<JSMediaErrorPrototype*>(object);
    return getStaticValueDescriptor<JSMediaErrorPrototype, JSObject>(exec, &JSMediaErrorPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSMediaError::s_info = { "MediaError", &Base::s_info, &JSMediaErrorTable, 0 , CREATE_METHOD_TABLE(JSMediaError) };

JSMediaError::JSMediaError(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<MediaError> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSMediaError::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSMediaError::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSMediaErrorPrototype::create(exec->globalData(), globalObject, JSMediaErrorPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSMediaError::destroy(JSC::JSCell* cell)
{
    JSMediaError* thisObject = static_cast<JSMediaError*>(cell);
    thisObject->JSMediaError::~JSMediaError();
}

JSMediaError::~JSMediaError()
{
    releaseImplIfNotNull();
}

bool JSMediaError::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSMediaError* thisObject = jsCast<JSMediaError*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSMediaError, Base>(exec, &JSMediaErrorTable, thisObject, propertyName, slot);
}

bool JSMediaError::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSMediaError* thisObject = jsCast<JSMediaError*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSMediaError, Base>(exec, &JSMediaErrorTable, thisObject, propertyName, descriptor);
}

JSValue jsMediaErrorCode(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMediaError* castedThis = jsCast<JSMediaError*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MediaError* impl = static_cast<MediaError*>(castedThis->impl());
    JSValue result = jsNumber(impl->code());
    return result;
}


JSValue jsMediaErrorConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSMediaError* domObject = jsCast<JSMediaError*>(asObject(slotBase));
    return JSMediaError::getConstructor(exec, domObject->globalObject());
}

JSValue JSMediaError::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaErrorConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

// Constant getters

JSValue jsMediaErrorMEDIA_ERR_ABORTED(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsMediaErrorMEDIA_ERR_NETWORK(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsMediaErrorMEDIA_ERR_DECODE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}

JSValue jsMediaErrorMEDIA_ERR_SRC_NOT_SUPPORTED(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(4));
}

static inline bool isObservable(JSMediaError* jsMediaError)
{
    if (jsMediaError->hasCustomProperties())
        return true;
    return false;
}

bool JSMediaErrorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSMediaError* jsMediaError = jsCast<JSMediaError*>(handle.get().asCell());
    if (!isObservable(jsMediaError))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSMediaErrorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSMediaError* jsMediaError = jsCast<JSMediaError*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsMediaError->impl(), jsMediaError);
    jsMediaError->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, MediaError* impl)
{
    return wrap<JSMediaError>(exec, globalObject, impl);
}

MediaError* toMediaError(JSC::JSValue value)
{
    return value.inherits(&JSMediaError::s_info) ? jsCast<JSMediaError*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(VIDEO)
