/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(BLOB)

#include "JSDOMURL.h"

#include "DOMURL.h"
#include "ExceptionCode.h"
#include "JSBlob.h"
#include "JSDOMBinding.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSDOMURLTableValues[] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsDOMURLConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDOMURLTable = { 2, 1, JSDOMURLTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSDOMURLConstructorTableValues[] =
{
    { "createObjectURL", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDOMURLConstructorFunctionCreateObjectURL), (intptr_t)1, NoIntrinsic },
    { "revokeObjectURL", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsDOMURLConstructorFunctionRevokeObjectURL), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDOMURLConstructorTable = { 2, 0, JSDOMURLConstructorTableValues, 0 };
static const HashTable* getJSDOMURLConstructorTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSDOMURLConstructorTable);
}

const ClassInfo JSDOMURLConstructor::s_info = { "URLConstructor", &Base::s_info, 0, getJSDOMURLConstructorTable, CREATE_METHOD_TABLE(JSDOMURLConstructor) };

JSDOMURLConstructor::JSDOMURLConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSDOMURLConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSDOMURLPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->globalData(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSDOMURLConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSDOMURLConstructor, JSDOMWrapper>(exec, getJSDOMURLConstructorTable(exec), jsCast<JSDOMURLConstructor*>(cell), propertyName, slot);
}

bool JSDOMURLConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticPropertyDescriptor<JSDOMURLConstructor, JSDOMWrapper>(exec, getJSDOMURLConstructorTable(exec), jsCast<JSDOMURLConstructor*>(object), propertyName, descriptor);
}

EncodedJSValue JSC_HOST_CALL JSDOMURLConstructor::constructJSDOMURL(ExecState* exec)
{
    JSDOMURLConstructor* castedThis = jsCast<JSDOMURLConstructor*>(exec->callee());
    RefPtr<DOMURL> object = DOMURL::create();
    return JSValue::encode(asObject(toJS(exec, castedThis->globalObject(), object.get())));
}

ConstructType JSDOMURLConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSDOMURL;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSDOMURLPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSDOMURLPrototypeTable = { 4, 3, JSDOMURLPrototypeTableValues, 0 };
static const HashTable* getJSDOMURLPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSDOMURLPrototypeTable);
}

const ClassInfo JSDOMURLPrototype::s_info = { "URLPrototype", &Base::s_info, 0, getJSDOMURLPrototypeTable, CREATE_METHOD_TABLE(JSDOMURLPrototype) };

JSObject* JSDOMURLPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSDOMURL>(exec, globalObject);
}

bool JSDOMURLPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDOMURLPrototype* thisObject = jsCast<JSDOMURLPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, getJSDOMURLPrototypeTable(exec), thisObject, propertyName, slot);
}

bool JSDOMURLPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDOMURLPrototype* thisObject = jsCast<JSDOMURLPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, getJSDOMURLPrototypeTable(exec), thisObject, propertyName, descriptor);
}

static const HashTable* getJSDOMURLTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSDOMURLTable);
}

const ClassInfo JSDOMURL::s_info = { "URL", &Base::s_info, 0, getJSDOMURLTable , CREATE_METHOD_TABLE(JSDOMURL) };

JSDOMURL::JSDOMURL(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<DOMURL> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSDOMURL::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSDOMURL::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSDOMURLPrototype::create(exec->globalData(), globalObject, JSDOMURLPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSDOMURL::destroy(JSC::JSCell* cell)
{
    JSDOMURL* thisObject = static_cast<JSDOMURL*>(cell);
    thisObject->JSDOMURL::~JSDOMURL();
}

JSDOMURL::~JSDOMURL()
{
    releaseImplIfNotNull();
}

bool JSDOMURL::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSDOMURL* thisObject = jsCast<JSDOMURL*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSDOMURL, Base>(exec, getJSDOMURLTable(exec), thisObject, propertyName, slot);
}

bool JSDOMURL::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSDOMURL* thisObject = jsCast<JSDOMURL*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSDOMURL, Base>(exec, getJSDOMURLTable(exec), thisObject, propertyName, descriptor);
}

JSValue jsDOMURLConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSDOMURL* domObject = jsCast<JSDOMURL*>(asObject(slotBase));
    return JSDOMURL::getConstructor(exec, domObject->globalObject());
}

JSValue JSDOMURL::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDOMURLConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsDOMURLConstructorFunctionCreateObjectURL(ExecState* exec)
{
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ScriptExecutionContext* scriptContext = jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    Blob* blob(toBlob(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringOrNull(exec, DOMURL::createObjectURL(scriptContext, blob));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsDOMURLConstructorFunctionRevokeObjectURL(ExecState* exec)
{
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ScriptExecutionContext* scriptContext = jsCast<JSDOMGlobalObject*>(exec->lexicalGlobalObject())->scriptExecutionContext();
    if (!scriptContext)
        return JSValue::encode(jsUndefined());
    const String& url(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    DOMURL::revokeObjectURL(scriptContext, url);
    return JSValue::encode(jsUndefined());
}

static inline bool isObservable(JSDOMURL* jsDOMURL)
{
    if (jsDOMURL->hasCustomProperties())
        return true;
    return false;
}

bool JSDOMURLOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSDOMURL* jsDOMURL = jsCast<JSDOMURL*>(handle.get().asCell());
    if (!isObservable(jsDOMURL))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSDOMURLOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSDOMURL* jsDOMURL = jsCast<JSDOMURL*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsDOMURL->impl(), jsDOMURL);
    jsDOMURL->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, DOMURL* impl)
{
    return wrap<JSDOMURL>(exec, globalObject, impl);
}

DOMURL* toDOMURL(JSC::JSValue value)
{
    return value.inherits(&JSDOMURL::s_info) ? jsCast<JSDOMURL*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(BLOB)
