/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSValue.h"

#include "CSSValue.h"
#include "KURL.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSCSSValueTableValues[] =
{
    { "cssText", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSValueCssText), (intptr_t)setJSCSSValueCssText, NoIntrinsic },
    { "cssValueType", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSValueCssValueType), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSValueConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCSSValueTable = { 8, 7, JSCSSValueTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSCSSValueConstructorTableValues[] =
{
    { "CSS_INHERIT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSValueCSS_INHERIT), (intptr_t)0, NoIntrinsic },
    { "CSS_PRIMITIVE_VALUE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSValueCSS_PRIMITIVE_VALUE), (intptr_t)0, NoIntrinsic },
    { "CSS_VALUE_LIST", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSValueCSS_VALUE_LIST), (intptr_t)0, NoIntrinsic },
    { "CSS_CUSTOM", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSValueCSS_CUSTOM), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCSSValueConstructorTable = { 8, 7, JSCSSValueConstructorTableValues, 0 };

COMPILE_ASSERT(0 == CSSValue::CSS_INHERIT, CSSValueEnumCSS_INHERITIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == CSSValue::CSS_PRIMITIVE_VALUE, CSSValueEnumCSS_PRIMITIVE_VALUEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == CSSValue::CSS_VALUE_LIST, CSSValueEnumCSS_VALUE_LISTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == CSSValue::CSS_CUSTOM, CSSValueEnumCSS_CUSTOMIsWrongUseDoNotCheckConstants);

const ClassInfo JSCSSValueConstructor::s_info = { "CSSValueConstructor", &Base::s_info, &JSCSSValueConstructorTable, 0, CREATE_METHOD_TABLE(JSCSSValueConstructor) };

JSCSSValueConstructor::JSCSSValueConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSCSSValueConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSCSSValuePrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSCSSValueConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSValueConstructor, JSDOMWrapper>(exec, &JSCSSValueConstructorTable, jsCast<JSCSSValueConstructor*>(cell), propertyName, slot);
}

bool JSCSSValueConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCSSValueConstructor, JSDOMWrapper>(exec, &JSCSSValueConstructorTable, jsCast<JSCSSValueConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSCSSValuePrototypeTableValues[] =
{
    { "CSS_INHERIT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSValueCSS_INHERIT), (intptr_t)0, NoIntrinsic },
    { "CSS_PRIMITIVE_VALUE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSValueCSS_PRIMITIVE_VALUE), (intptr_t)0, NoIntrinsic },
    { "CSS_VALUE_LIST", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSValueCSS_VALUE_LIST), (intptr_t)0, NoIntrinsic },
    { "CSS_CUSTOM", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSValueCSS_CUSTOM), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCSSValuePrototypeTable = { 8, 7, JSCSSValuePrototypeTableValues, 0 };
const ClassInfo JSCSSValuePrototype::s_info = { "CSSValuePrototype", &Base::s_info, &JSCSSValuePrototypeTable, 0, CREATE_METHOD_TABLE(JSCSSValuePrototype) };

JSObject* JSCSSValuePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCSSValue>(exec, globalObject);
}

bool JSCSSValuePrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSCSSValuePrototype* thisObject = jsCast<JSCSSValuePrototype*>(cell);
    return getStaticValueSlot<JSCSSValuePrototype, JSObject>(exec, &JSCSSValuePrototypeTable, thisObject, propertyName, slot);
}

bool JSCSSValuePrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSCSSValuePrototype* thisObject = jsCast<JSCSSValuePrototype*>(object);
    return getStaticValueDescriptor<JSCSSValuePrototype, JSObject>(exec, &JSCSSValuePrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSCSSValue::s_info = { "CSSValue", &Base::s_info, &JSCSSValueTable, 0 , CREATE_METHOD_TABLE(JSCSSValue) };

JSCSSValue::JSCSSValue(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<CSSValue> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSCSSValue::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSCSSValue::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSCSSValuePrototype::create(exec->globalData(), globalObject, JSCSSValuePrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSCSSValue::destroy(JSC::JSCell* cell)
{
    JSCSSValue* thisObject = static_cast<JSCSSValue*>(cell);
    thisObject->JSCSSValue::~JSCSSValue();
}

JSCSSValue::~JSCSSValue()
{
    releaseImplIfNotNull();
}

bool JSCSSValue::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSCSSValue* thisObject = jsCast<JSCSSValue*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSCSSValue, Base>(exec, &JSCSSValueTable, thisObject, propertyName, slot);
}

bool JSCSSValue::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSCSSValue* thisObject = jsCast<JSCSSValue*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSCSSValue, Base>(exec, &JSCSSValueTable, thisObject, propertyName, descriptor);
}

JSValue jsCSSValueCssText(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCSSValue* castedThis = jsCast<JSCSSValue*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CSSValue* impl = static_cast<CSSValue*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, impl->cssText());
    return result;
}


JSValue jsCSSValueCssValueType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCSSValue* castedThis = jsCast<JSCSSValue*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CSSValue* impl = static_cast<CSSValue*>(castedThis->impl());
    JSValue result = jsNumber(impl->cssValueType());
    return result;
}


JSValue jsCSSValueConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCSSValue* domObject = jsCast<JSCSSValue*>(asObject(slotBase));
    return JSCSSValue::getConstructor(exec, domObject->globalObject());
}

void JSCSSValue::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSCSSValue* thisObject = jsCast<JSCSSValue*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSCSSValue, Base>(exec, propertyName, value, &JSCSSValueTable, thisObject, slot);
}

void setJSCSSValueCssText(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSCSSValue* castedThis = jsCast<JSCSSValue*>(thisObject);
    CSSValue* impl = static_cast<CSSValue*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->setCssText(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}


JSValue JSCSSValue::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSValueConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

// Constant getters

JSValue jsCSSValueCSS_INHERIT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsCSSValueCSS_PRIMITIVE_VALUE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsCSSValueCSS_VALUE_LIST(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsCSSValueCSS_CUSTOM(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}

CSSValue* toCSSValue(JSC::JSValue value)
{
    return value.inherits(&JSCSSValue::s_info) ? jsCast<JSCSSValue*>(asObject(value))->impl() : 0;
}

}
