#!/bin/sh

function install_conf {
	if [ ! -f "$1" ]; then
		mv "$1.default" "$1"
	else
		rm -f "$1.default"
	fi
}
function install_maildir {
	if ! [ -d "$1" ]; then
		mkdir -p "$1"
		chmod 775 "$1"
		chown SYSTEM:mail "$1"
	fi
}
function groupadd {
	if ! [ "`grep "^$1:" /etc/group`" ]; then
		net localgroup "$1" /add >/dev/null
		mkgroup -l -g "$1" >>/etc/group
	fi
}

groupadd mail

install_maildir /var/spool/mail
install_conf /etc/aliases

chmod 6755 /usr/bin/procmail.exe
chown SYSTEM:mail /usr/bin/procmail.exe

chmod 2755 /usr/bin/lockfile.exe
chgrp mail /usr/bin/lockfile.exe
