/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.24 from the
 * contents of Socket.xs. Do not edit this file, edit Socket.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

/////////////////////////////////////////////////////////////////////////////
// Name:        ext/socket/Socket.xs
// Purpose:     XS for Wx::Socket
// Author:      Graciliano M. P.
// Modified by:
// Created:     27/02/2003
// RCS-ID:      $Id: Socket.xs 2757 2010-01-17 10:26:27Z mbarbon $
// Copyright:   (c) 2003-2004, 2006, 2008-2010 Graciliano M. P.
// Licence:     This program is free software; you can redistribute it and/or
//              modify it under the same terms as Perl itself
/////////////////////////////////////////////////////////////////////////////

#define PERL_NO_GET_CONTEXT

#include "cpp/wxapi.h"
#include "wx/socket.h"

#undef THIS

#include "cpp/sk_constants.cpp"
#include "cpp/socket.h"

#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
            Perl_croak(aTHX_ "Usage: %s::%s(%s)", hvname, gvname, params);
        else
            Perl_croak(aTHX_ "Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
        Perl_croak(aTHX_ "Usage: CODE(0x%"UVxf")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#ifdef PERL_IMPLICIT_CONTEXT
#define croak_xs_usage(a,b)    S_croak_xs_usage(aTHX_ a,b)
#else
#define croak_xs_usage        S_croak_xs_usage
#endif

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */


/* INCLUDE:  Including 'XS/SocketBase.xs' from 'Socket.xs' */


/* INCLUDE:  Including 'XS/SocketClient.xs' from 'XS/SocketBase.xs' */


/* INCLUDE:  Including 'XS/SocketServer.xs' from 'XS/SocketClient.xs' */


/* INCLUDE:  Including 'XS/SocketEvent.xs' from 'XS/SocketServer.xs' */


XS_EUPXS(XS_Wx__SocketEvent_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketEvent_new)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "CLASS, id = 0");
    {
	int	id;
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
	wxSocketEvent *	RETVAL;

	if (items < 2)
	    id = 0;
	else {
	    id = (int)SvIV(ST(1))
;
	}
    RETVAL = new wxSocketEvent( id ) ;
	ST(0) = sv_newmortal();
    wxPli_object_2_sv( aTHX_ ST(0), RETVAL );
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketEvent_GetSocket); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketEvent_GetSocket)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSocketEvent *    THIS = (wxSocketEvent *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketEvent" )
;
	wxSocketBase *	RETVAL;

	RETVAL = THIS->GetSocket();
	ST(0) = sv_newmortal();
    wxPli_object_2_sv( aTHX_ ST(0), RETVAL );
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketEvent_GetSocketEvent); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketEvent_GetSocketEvent)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSocketEvent *    THIS = (wxSocketEvent *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketEvent" )
;
	long	RETVAL;
	dXSTARG;

	RETVAL = THIS->GetSocketEvent();
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'XS/SocketServer.xs' from 'XS/SocketEvent.xs' */


XS_EUPXS(XS_Wx__SocketServer_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketServer_new)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "CLASS, host, port, style = 0");
    {
	wxString	host;
	wxString	port;
	long	style;
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
	wxSocketServer *	RETVAL;

    WXSTRING_INPUT( host, wxString, ST(1) )
;

    WXSTRING_INPUT( port, wxString, ST(2) )
;

	if (items < 4)
	    style = 0;
	else {
	    style = (long)SvIV(ST(3))
;
	}
    wxIPV4address addr ;
    addr.Hostname(host) ;
    addr.Service(port) ;
    RETVAL = new wxPlSocketServer( CLASS , addr , style ) ;
	ST(0) = sv_newmortal();
    wxPli_object_2_sv( aTHX_ ST(0), RETVAL );
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketServer_Accept); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketServer_Accept)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "THIS, wait = true");
    {
	bool	wait;
	wxSocketServer *    THIS = (wxSocketServer *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketServer" )
;
	wxSocketBase *	RETVAL;

	if (items < 2)
	    wait = true;
	else {
	    wait = (bool)SvTRUE(ST(1))
;
	}
    // works, more or less; not a good example of C++
    RETVAL = ((wxPlSocketServer*)THIS)->Accept(wait);
	ST(0) = sv_newmortal();
    wxPli_object_2_sv( aTHX_ ST(0), RETVAL );
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketServer_AcceptWith); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketServer_AcceptWith)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "THIS, socket, wait = true");
    {
	wxSocketBase*    socket = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(1), "Wx::SocketBase" )
;
	bool	wait;
	wxSocketServer *    THIS = (wxSocketServer *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketServer" )
;
	bool	RETVAL;

	if (items < 3)
	    wait = true;
	else {
	    wait = (bool)SvTRUE(ST(2))
;
	}
    RETVAL = THIS->AcceptWith( *socket , wait );
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketServer_WaitForAccept); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketServer_WaitForAccept)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "THIS, seconds = -1, millisecond = 0");
    {
	long	seconds;
	long	millisecond;
	wxSocketServer *    THIS = (wxSocketServer *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketServer" )
;
	bool	RETVAL;

	if (items < 2)
	    seconds = -1;
	else {
	    seconds = (long)SvIV(ST(1))
;
	}

	if (items < 3)
	    millisecond = 0;
	else {
	    millisecond = (long)SvIV(ST(2))
;
	}

	RETVAL = THIS->WaitForAccept(seconds, millisecond);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'XS/SocketClient.xs' from 'XS/SocketServer.xs' */


XS_EUPXS(XS_Wx__SocketClient_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketClient_new)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "CLASS, style = 0");
    {
	long	style;
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
	wxSocketClient *	RETVAL;

	if (items < 2)
	    style = 0;
	else {
	    style = (long)SvIV(ST(1))
;
	}
    RETVAL = new wxPliSocketClient( CLASS , style ) ;
	ST(0) = sv_newmortal();
    wxPli_object_2_sv( aTHX_ ST(0), RETVAL );
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketClient_Connect); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketClient_Connect)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "THIS, host, port, wait = 1");
    {
	wxString	host;
	wxString	port;
	bool	wait;
	wxSocketClient *    THIS = (wxSocketClient *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketClient" )
;
	bool	RETVAL;

    WXSTRING_INPUT( host, wxString, ST(1) )
;

    WXSTRING_INPUT( port, wxString, ST(2) )
;

	if (items < 4)
	    wait = 1;
	else {
	    wait = (bool)SvTRUE(ST(3))
;
	}
    wxIPV4address addr ;
    addr.Hostname(host) ;
    addr.Service(port) ;
    RETVAL = THIS->Connect( addr , wait ) ;
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'XS/SocketBase.xs' from 'XS/SocketClient.xs' */

#if 0
#define XSubPPtmpAAAA 1


XS_EUPXS(XS_Wx__SocketBase_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "CLASS");
    {
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
	wxSocketBase *	RETVAL;
    RETVAL = new wxPlSocketBase( CLASS ) ;
	ST(0) = sv_newmortal();
    wxPli_object_2_sv( aTHX_ ST(0), RETVAL );
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Wx__SocketBase_Destroy); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_Destroy)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;

	THIS->Destroy();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Wx__SocketBase_Ok); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_Ok)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	bool	RETVAL;

	RETVAL = THIS->Ok();
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_IsConnected); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_IsConnected)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	bool	RETVAL;

	RETVAL = THIS->IsConnected();
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_IsDisconnected); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_IsDisconnected)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	bool	RETVAL;

	RETVAL = THIS->IsDisconnected();
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_IsData); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_IsData)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	bool	RETVAL;

	RETVAL = THIS->IsData();
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_LastCount); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_LastCount)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	long	RETVAL;
	dXSTARG;

	RETVAL = THIS->LastCount();
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_Notify); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_Notify)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, notify");
    {
	bool	notify = (bool)SvTRUE(ST(1))
;
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;

	THIS->Notify(notify);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Wx__SocketBase_SetTimeout); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_SetTimeout)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, seconds");
    {
	int	seconds = (int)SvIV(ST(1))
;
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;

	THIS->SetTimeout(seconds);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Wx__SocketBase_Wait); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_Wait)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "THIS, seconds = -1, millisecond = 0");
    {
	long	seconds;
	long	millisecond;
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	bool	RETVAL;

	if (items < 2)
	    seconds = -1;
	else {
	    seconds = (long)SvIV(ST(1))
;
	}

	if (items < 3)
	    millisecond = 0;
	else {
	    millisecond = (long)SvIV(ST(2))
;
	}

	RETVAL = THIS->Wait(seconds, millisecond);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_WaitForRead); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_WaitForRead)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "THIS, seconds = -1, millisecond = 0");
    {
	long	seconds;
	long	millisecond;
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	bool	RETVAL;

	if (items < 2)
	    seconds = -1;
	else {
	    seconds = (long)SvIV(ST(1))
;
	}

	if (items < 3)
	    millisecond = 0;
	else {
	    millisecond = (long)SvIV(ST(2))
;
	}

	RETVAL = THIS->WaitForRead(seconds, millisecond);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_WaitForWrite); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_WaitForWrite)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "THIS, seconds = -1, millisecond = 0");
    {
	long	seconds;
	long	millisecond;
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	bool	RETVAL;

	if (items < 2)
	    seconds = -1;
	else {
	    seconds = (long)SvIV(ST(1))
;
	}

	if (items < 3)
	    millisecond = 0;
	else {
	    millisecond = (long)SvIV(ST(2))
;
	}

	RETVAL = THIS->WaitForWrite(seconds, millisecond);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_Read); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_Read)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "THIS, buf, size, leng = 0");
    {
	SV*	buf = ST(1)
;
	size_t    size = (size_t)SvUV( ST(2) )
;
	size_t	leng;
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	long	RETVAL;
	dXSTARG;

	if (items < 4)
	    leng = 0;
	else {
    leng = (size_t)SvUV( ST(3) )
;
	}
    // Upgrade the SV to scalar if needed. If the scalar is undef
    // can't use SvGROW.
    SvUPGRADE(buf , SVt_PV) ;
    // Tell that the scalar is string only (not integer, double, utf8...):
    SvPOK_only(buf) ;

    // Grow the scalar to receive the data and return a char* point:
    char* buffer = SvGROW( buf , leng + size + 2 ) ;

    // To read at the offset the user specified (works even if offset = 0):
    if ( leng > 0 ) buffer += leng ;

    THIS->Read( buffer , size ) ;
    int nread = THIS->LastCount() ;

    // Null-terminate the buffer, not necessary, but does not hurt:
    buffer[nread] = 0 ;
    // Tell Perl how long the string is:
    SvCUR_set( buf , leng + nread ) ;
    // Undef on read error:
    if( THIS->Error() ) XSRETURN_UNDEF ;
    // Return the amount of data read, like Perl read().
    RETVAL = nread ;
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_Close); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_Close)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;

	THIS->Close();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Wx__SocketBase_Discard); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_Discard)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;

	THIS->Discard();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Wx__SocketBase_Error); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_Error)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	bool	RETVAL;

	RETVAL = THIS->Error();
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_GetFlags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_GetFlags)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	long	RETVAL;
	dXSTARG;

	RETVAL = THIS->GetFlags();
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_GetLocal); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_GetLocal)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
    wxIPV4address addr ;
    THIS->GetLocal( addr ) ;
    XPUSHs( sv_2mortal( newSVpv( addr.Hostname().mb_str(), 0 ) ) );
    XPUSHs( sv_2mortal( newSViv( addr.Service() ) ) );
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Wx__SocketBase_GetPeer); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_GetPeer)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
    wxIPV4address addr ;
    THIS->GetPeer( addr ) ;
    XPUSHs( sv_2mortal( newSVpv( addr.Hostname().mb_str(), 0 ) ) );
    XPUSHs( sv_2mortal( newSViv( addr.Service() ) ) );
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Wx__SocketBase_InterruptWait); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_InterruptWait)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;

	THIS->InterruptWait();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Wx__SocketBase_LastError); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_LastError)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	long	RETVAL;
	dXSTARG;

	RETVAL = THIS->LastError();
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_Peek); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_Peek)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "THIS, buf, size, leng = 0");
    {
	SV*	buf = ST(1)
;
	size_t    size = (size_t)SvUV( ST(2) )
;
	size_t	leng;
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	long	RETVAL;
	dXSTARG;

	if (items < 4)
	    leng = 0;
	else {
    leng = (size_t)SvUV( ST(3) )
;
	}
    SvUPGRADE(buf , SVt_PV) ;
    SvPOK_only(buf) ;
    char* buffer = SvGROW( buf , leng + size + 2 ) ;
    if ( leng > 0 ) { buffer += leng ;}

    THIS->Peek( buffer , size ) ;
    int nread = THIS->LastCount() ;

    buffer[nread] = 0 ;
    SvCUR_set( buf , leng + nread ) ;
    if( THIS->Error() ) XSRETURN_UNDEF ;
    RETVAL = nread ;
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_ReadMsg); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_ReadMsg)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "THIS, buf, size, leng = 0");
    {
	SV*	buf = ST(1)
;
	size_t    size = (size_t)SvUV( ST(2) )
;
	size_t	leng;
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	long	RETVAL;
	dXSTARG;

	if (items < 4)
	    leng = 0;
	else {
    leng = (size_t)SvUV( ST(3) )
;
	}
    SvUPGRADE(buf , SVt_PV) ;
    SvPOK_only(buf) ;
    char* buffer = SvGROW( buf , leng + size + 2 ) ;
    if ( leng > 0 ) { buffer += leng ;}

    THIS->ReadMsg( buffer , size ) ;
    int nread = THIS->LastCount() ;

    buffer[nread] = 0 ;
    SvCUR_set( buf , leng + nread ) ;
    if( THIS->Error() ) XSRETURN_UNDEF ;
    RETVAL = nread ;
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_RestoreState); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_RestoreState)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;

	THIS->RestoreState();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Wx__SocketBase_SaveState); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_SaveState)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;

	THIS->SaveState();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Wx__SocketBase_SetFlags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_SetFlags)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, flags");
    {
	long	flags = (long)SvIV(ST(1))
;
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;

	THIS->SetFlags(flags);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Wx__SocketBase_SetNotify); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_SetNotify)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, flags");
    {
	long	flags = (long)SvIV(ST(1))
;
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;

	THIS->SetNotify(flags);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Wx__SocketBase_Unread); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_Unread)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "THIS, buf, size = 0");
    {
	SV*	buf = ST(1)
;
	long	size;
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	long	RETVAL;
	dXSTARG;

	if (items < 3)
	    size = 0;
	else {
	    size = (long)SvIV(ST(2))
;
	}
    // Upgrade the SV to scalar if needed. If the scalar is undef 
    // can't use SvGROW.
    SvUPGRADE(buf , SVt_PV) ;

    if ( size == 0 ) { size = SvCUR(buf) ;}
    THIS->Unread( SvPV_nolen(buf) , size ) ;
    RETVAL = THIS->LastCount() ;
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_WaitForLost); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_WaitForLost)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "THIS, seconds = -1, millisecond = 0");
    {
	long	seconds;
	long	millisecond;
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	bool	RETVAL;

	if (items < 2)
	    seconds = -1;
	else {
	    seconds = (long)SvIV(ST(1))
;
	}

	if (items < 3)
	    millisecond = 0;
	else {
	    millisecond = (long)SvIV(ST(2))
;
	}

	RETVAL = THIS->WaitForLost(seconds, millisecond);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_Write); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_Write)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "THIS, buf, size = 0");
    {
	SV*	buf = ST(1)
;
	long	size;
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	long	RETVAL;
	dXSTARG;

	if (items < 3)
	    size = 0;
	else {
	    size = (long)SvIV(ST(2))
;
	}
    if ( size == 0 ) { size = SvCUR(buf) ;}
    THIS->Write( SvPV_nolen(buf) , size ) ;
    RETVAL = THIS->LastCount() ;
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_WriteMsg); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_WriteMsg)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "THIS, buf, size = 0");
    {
	SV*	buf = ST(1)
;
	long	size;
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	long	RETVAL;
	dXSTARG;

	if (items < 3)
	    size = 0;
	else {
	    size = (long)SvIV(ST(2))
;
	}
    if ( size == 0 ) { size = SvCUR(buf) ;}
    THIS->WriteMsg( SvPV_nolen(buf) , size ) ;
    RETVAL = THIS->LastCount() ;
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_SetEventHandler); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_SetEventHandler)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "THIS, evthnd, id = wxID_ANY");
    {
	wxEvtHandler*    evthnd = (wxEvtHandler *) wxPli_sv_2_object( aTHX_ ST(1), "Wx::EvtHandler" )
;
	int	id;
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;

	if (items < 3)
	    id = wxID_ANY;
	else {
	    id = (int)SvIV(ST(2))
;
	}
    THIS->SetEventHandler( *evthnd , id );
    }
    XSRETURN_EMPTY;
}


/* INCLUDE: Returning to 'Socket.xs' from 'XS/SocketBase.xs' */


/* INCLUDE_COMMAND:  Including output of '/usr/bin/perl -MExtUtils::XSpp::Cmd -e xspp -- -t ../../typemap.xsp XS/SockAddress.xsp' from 'Socket.xs' */

#include <exception>

#undef  xsp_constructor_class
#define xsp_constructor_class(c) (c)

XS_EUPXS(XS_Wx__SockAddress_CLONE); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SockAddress_CLONE)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "CLASS");
    {
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
    wxPli_thread_sv_clone( aTHX_ CLASS, (wxPliCloneSV)wxPli_detach_object );
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Wx__SockAddress_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SockAddress_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSockAddress *    THIS = (wxSockAddress *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SockAddress" )
;
     wxPli_thread_sv_unregister( aTHX_ wxPli_get_class( aTHX_ ST(0) ), THIS, ST(0) );
                delete THIS;
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Wx__SockAddress_Clear); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SockAddress_Clear)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSockAddress *    THIS = (wxSockAddress *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SockAddress" )
;
    try {
      THIS->Clear();
    }
    catch (std::exception& e) {
      croak("Caught C++ exception of type or derived from 'std::exception': %s", e.what());
    }
    catch (...) {
      croak("Caught C++ exception of unknown type");
    }
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Wx__SockAddress_Type); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SockAddress_Type)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSockAddress *    THIS = (wxSockAddress *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SockAddress" )
;
	int	RETVAL;
	dXSTARG;
    try {
      RETVAL = THIS->Type();
    }
    catch (std::exception& e) {
      croak("Caught C++ exception of type or derived from 'std::exception': %s", e.what());
    }
    catch (...) {
      croak("Caught C++ exception of unknown type");
    }
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#if WXPERL_W_VERSION_GE( 2, 5, 1 )
#define XSpp_2c048bf0_074076
#define XSubPPtmpAAAB 1


XS_EUPXS(XS_Wx__IPaddress_SetHostname); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__IPaddress_SetHostname)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, name");
    {
	wxIPaddress *    THIS = (wxIPaddress *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::IPaddress" )
;
	bool	RETVAL;
	wxString	name;

    WXSTRING_INPUT( name, wxString, ST(1) )
;
    try {
      RETVAL = THIS->Hostname( name );
    }
    catch (std::exception& e) {
      croak("Caught C++ exception of type or derived from 'std::exception': %s", e.what());
    }
    catch (...) {
      croak("Caught C++ exception of unknown type");
    }
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__IPaddress_SetService); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__IPaddress_SetService)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, port");
    {
	wxIPaddress *    THIS = (wxIPaddress *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::IPaddress" )
;
	bool	RETVAL;
	wxString	port;

    WXSTRING_INPUT( port, wxString, ST(1) )
;
    try {
      RETVAL = THIS->Service( port );
    }
    catch (std::exception& e) {
      croak("Caught C++ exception of type or derived from 'std::exception': %s", e.what());
    }
    catch (...) {
      croak("Caught C++ exception of unknown type");
    }
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__IPaddress_IsLocalHost); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__IPaddress_IsLocalHost)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxIPaddress *    THIS = (wxIPaddress *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::IPaddress" )
;
	bool	RETVAL;
    try {
      RETVAL = THIS->IsLocalHost();
    }
    catch (std::exception& e) {
      croak("Caught C++ exception of type or derived from 'std::exception': %s", e.what());
    }
    catch (...) {
      croak("Caught C++ exception of unknown type");
    }
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__IPaddress_SetAnyAddress); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__IPaddress_SetAnyAddress)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxIPaddress *    THIS = (wxIPaddress *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::IPaddress" )
;
	bool	RETVAL;
    try {
      RETVAL = THIS->AnyAddress();
    }
    catch (std::exception& e) {
      croak("Caught C++ exception of type or derived from 'std::exception': %s", e.what());
    }
    catch (...) {
      croak("Caught C++ exception of unknown type");
    }
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__IPaddress_GetIPAddress); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__IPaddress_GetIPAddress)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxIPaddress *    THIS = (wxIPaddress *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::IPaddress" )
;
	wxString	RETVAL;
    try {
      RETVAL = THIS->IPAddress();
    }
    catch (std::exception& e) {
      croak("Caught C++ exception of type or derived from 'std::exception': %s", e.what());
    }
    catch (...) {
      croak("Caught C++ exception of unknown type");
    }
	ST(0) = sv_newmortal();
    WXSTRING_OUTPUT( RETVAL, ST(0) );
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__IPaddress_GetHostname); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__IPaddress_GetHostname)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxIPaddress *    THIS = (wxIPaddress *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::IPaddress" )
;
	wxString	RETVAL;
    try {
      RETVAL = THIS->Hostname();
    }
    catch (std::exception& e) {
      croak("Caught C++ exception of type or derived from 'std::exception': %s", e.what());
    }
    catch (...) {
      croak("Caught C++ exception of unknown type");
    }
	ST(0) = sv_newmortal();
    WXSTRING_OUTPUT( RETVAL, ST(0) );
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__IPaddress_GetService); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__IPaddress_GetService)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxIPaddress *    THIS = (wxIPaddress *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::IPaddress" )
;
	unsigned short	RETVAL;
	dXSTARG;
    try {
      RETVAL = THIS->Service();
    }
    catch (std::exception& e) {
      croak("Caught C++ exception of type or derived from 'std::exception': %s", e.what());
    }
    catch (...) {
      croak("Caught C++ exception of unknown type");
    }
	XSprePUSH; PUSHu((UV)RETVAL );
    }
    XSRETURN(1);
}

#endif
#undef  xsp_constructor_class
#define xsp_constructor_class(c) (CLASS)

XS_EUPXS(XS_Wx__IPV4address_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__IPV4address_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "CLASS");
    {
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
	wxIPV4address *	RETVAL;
    try {
      RETVAL = new wxIPV4address();
    }
    catch (std::exception& e) {
      croak("Caught C++ exception of type or derived from 'std::exception': %s", e.what());
    }
    catch (...) {
      croak("Caught C++ exception of unknown type");
    }
	ST(0) = sv_newmortal();
    wxPli_object_2_sv( aTHX_ ST(0), RETVAL );
    wxPli_thread_sv_register( aTHX_ "Wx::IPV4address", RETVAL, ST(0) );
    }
    XSRETURN(1);
}

#undef  xsp_constructor_class
#define xsp_constructor_class(c) (c)

XS_EUPXS(XS_Wx__IPV4address_GetOrigHostname); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__IPV4address_GetOrigHostname)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxIPV4address *    THIS = (wxIPV4address *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::IPV4address" )
;
	wxString	RETVAL;
    try {
      RETVAL = THIS->OrigHostname();
    }
    catch (std::exception& e) {
      croak("Caught C++ exception of type or derived from 'std::exception': %s", e.what());
    }
    catch (...) {
      croak("Caught C++ exception of unknown type");
    }
	ST(0) = sv_newmortal();
    WXSTRING_OUTPUT( RETVAL, ST(0) );
    }
    XSRETURN(1);
}

#if WXPERL_W_VERSION_GE( 2, 9, 0 )
#define XSpp_2c048bf0_054474
#define XSubPPtmpAAAC 1


XS_EUPXS(XS_Wx__IPV4address_SetBroadcastAddress); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__IPV4address_SetBroadcastAddress)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxIPV4address *    THIS = (wxIPV4address *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::IPV4address" )
;
	bool	RETVAL;
    try {
      RETVAL = THIS->BroadcastAddress();
    }
    catch (std::exception& e) {
      croak("Caught C++ exception of type or derived from 'std::exception': %s", e.what());
    }
    catch (...) {
      croak("Caught C++ exception of unknown type");
    }
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}

#endif
#if wxUSE_IPV6
#define XSpp_2c048bf0_031200
#undef  xsp_constructor_class
#define xsp_constructor_class(c) (CLASS)
#define XSubPPtmpAAAD 1


XS_EUPXS(XS_Wx__IPV6address_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__IPV6address_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "CLASS");
    {
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
	wxIPV6address *	RETVAL;
    try {
      RETVAL = new wxIPV6address();
    }
    catch (std::exception& e) {
      croak("Caught C++ exception of type or derived from 'std::exception': %s", e.what());
    }
    catch (...) {
      croak("Caught C++ exception of unknown type");
    }
	ST(0) = sv_newmortal();
    wxPli_object_2_sv( aTHX_ ST(0), RETVAL );
    wxPli_thread_sv_register( aTHX_ "Wx::IPV6address", RETVAL, ST(0) );
    }
    XSRETURN(1);
}

#undef  xsp_constructor_class
#define xsp_constructor_class(c) (c)
#endif
#ifdef __UNIX__
#define XSpp_2c048bf0_060365
#undef  xsp_constructor_class
#define xsp_constructor_class(c) (CLASS)
#define XSubPPtmpAAAE 1


XS_EUPXS(XS_Wx__UNIXaddress_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__UNIXaddress_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "CLASS");
    {
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
	wxUNIXaddress *	RETVAL;
    try {
      RETVAL = new wxUNIXaddress();
    }
    catch (std::exception& e) {
      croak("Caught C++ exception of type or derived from 'std::exception': %s", e.what());
    }
    catch (...) {
      croak("Caught C++ exception of unknown type");
    }
	ST(0) = sv_newmortal();
    wxPli_object_2_sv( aTHX_ ST(0), RETVAL );
    wxPli_thread_sv_register( aTHX_ "Wx::UNIXaddress", RETVAL, ST(0) );
    }
    XSRETURN(1);
}

#undef  xsp_constructor_class
#define xsp_constructor_class(c) (c)

XS_EUPXS(XS_Wx__UNIXaddress_GetFilename); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__UNIXaddress_GetFilename)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxUNIXaddress *    THIS = (wxUNIXaddress *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::UNIXaddress" )
;
	wxString	RETVAL;
    try {
      RETVAL = THIS->Filename();
    }
    catch (std::exception& e) {
      croak("Caught C++ exception of type or derived from 'std::exception': %s", e.what());
    }
    catch (...) {
      croak("Caught C++ exception of unknown type");
    }
	ST(0) = sv_newmortal();
    WXSTRING_OUTPUT( RETVAL, ST(0) );
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__UNIXaddress_SetFilename); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__UNIXaddress_SetFilename)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, filename");
    {
	wxUNIXaddress *    THIS = (wxUNIXaddress *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::UNIXaddress" )
;
	wxString	filename;

    WXSTRING_INPUT( filename, wxString, ST(1) )
;
    try {
      THIS->Filename( filename );
    }
    catch (std::exception& e) {
      croak("Caught C++ exception of type or derived from 'std::exception': %s", e.what());
    }
    catch (...) {
      croak("Caught C++ exception of unknown type");
    }
    }
    XSRETURN_EMPTY;
}

#endif

/* INCLUDE: Returning to 'Socket.xs' from '/usr/bin/perl -MExtUtils::XSpp::Cmd -e xspp -- -t ../../typemap.xsp XS/SockAddress.xsp' */


/* INCLUDE_COMMAND:  Including output of '/usr/bin/perl -MExtUtils::XSpp::Cmd -e xspp -- -t ../../typemap.xsp XS/DatagramSocket.xsp' from 'Socket.xs' */

#include <exception>

#undef  xsp_constructor_class
#define xsp_constructor_class(c) (c)
#undef  xsp_constructor_class
#define xsp_constructor_class(c) (CLASS)

XS_EUPXS(XS_Wx__DatagramSocket_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__DatagramSocket_new)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "CLASS, addr, flags= wxSOCKET_NONE");
    {
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
	wxDatagramSocket *	RETVAL;
	wxSockAddress*    addr = (wxSockAddress *) wxPli_sv_2_object( aTHX_ ST(1), "Wx::SockAddress" )
;
	wxSocketFlags	flags;

	if (items < 3)
	    flags = wxSOCKET_NONE;
	else {
	    flags = (wxSocketFlags)SvIV(ST(2))
;
	}
     RETVAL = new wxPliDatagramSocket( CLASS , *addr, flags ); 
	ST(0) = sv_newmortal();
    wxPli_object_2_sv( aTHX_ ST(0), RETVAL );
    }
    XSRETURN(1);
}

#undef  xsp_constructor_class
#define xsp_constructor_class(c) (c)

XS_EUPXS(XS_Wx__DatagramSocket_RecvFrom); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__DatagramSocket_RecvFrom)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "THIS, addr, buf, nBytes");
    {
	wxSockAddress*    addr = (wxSockAddress *) wxPli_sv_2_object( aTHX_ ST(1), "Wx::SockAddress" )
;
	SV*	buf = ST(2)
;
	wxUint32	nBytes = (wxUint32)SvIV(ST(3))
;
	wxDatagramSocket *    THIS = (wxDatagramSocket *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::DatagramSocket" )
;
	size_t	RETVAL;
	dXSTARG;
    DO_READ( THIS->RecvFrom( *addr, buffer, nBytes ), buf, nBytes, 0 );
	XSprePUSH; PUSHu((UV)RETVAL );
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__DatagramSocket_SendTo); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__DatagramSocket_SendTo)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "THIS, addr, buf, nBytes");
    {
	wxSockAddress*    addr = (wxSockAddress *) wxPli_sv_2_object( aTHX_ ST(1), "Wx::SockAddress" )
;
	SV*	buf = ST(2)
;
	wxUint32	nBytes = (wxUint32)SvIV(ST(3))
;
	wxDatagramSocket *    THIS = (wxDatagramSocket *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::DatagramSocket" )
;
	size_t	RETVAL;
	dXSTARG;
    DO_WRITE( THIS->SendTo( *addr, buffer, nBytes ), buf, nBytes );
	XSprePUSH; PUSHu((UV)RETVAL );
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'Socket.xs' from '/usr/bin/perl -MExtUtils::XSpp::Cmd -e xspp -- -t ../../typemap.xsp XS/DatagramSocket.xsp' */

#if defined(__WXMSW__)
#undef XS
#define XS( name ) WXXS( name )
#endif
#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_Wx__Socket); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Wx__Socket)
{
    dVAR; dXSARGS;
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#endif
    XS_VERSION_BOOTCHECK;

        newXS("Wx::SocketEvent::new", XS_Wx__SocketEvent_new, file);
        newXS("Wx::SocketEvent::GetSocket", XS_Wx__SocketEvent_GetSocket, file);
        newXS("Wx::SocketEvent::GetSocketEvent", XS_Wx__SocketEvent_GetSocketEvent, file);
        newXS("Wx::SocketServer::new", XS_Wx__SocketServer_new, file);
        newXS("Wx::SocketServer::Accept", XS_Wx__SocketServer_Accept, file);
        newXS("Wx::SocketServer::AcceptWith", XS_Wx__SocketServer_AcceptWith, file);
        newXS("Wx::SocketServer::WaitForAccept", XS_Wx__SocketServer_WaitForAccept, file);
        newXS("Wx::SocketClient::new", XS_Wx__SocketClient_new, file);
        newXS("Wx::SocketClient::Connect", XS_Wx__SocketClient_Connect, file);
#if XSubPPtmpAAAA
        newXS("Wx::SocketBase::new", XS_Wx__SocketBase_new, file);
#endif
        newXS("Wx::SocketBase::Destroy", XS_Wx__SocketBase_Destroy, file);
        newXS("Wx::SocketBase::Ok", XS_Wx__SocketBase_Ok, file);
        newXS("Wx::SocketBase::IsConnected", XS_Wx__SocketBase_IsConnected, file);
        newXS("Wx::SocketBase::IsDisconnected", XS_Wx__SocketBase_IsDisconnected, file);
        newXS("Wx::SocketBase::IsData", XS_Wx__SocketBase_IsData, file);
        newXS("Wx::SocketBase::LastCount", XS_Wx__SocketBase_LastCount, file);
        newXS("Wx::SocketBase::Notify", XS_Wx__SocketBase_Notify, file);
        newXS("Wx::SocketBase::SetTimeout", XS_Wx__SocketBase_SetTimeout, file);
        newXS("Wx::SocketBase::Wait", XS_Wx__SocketBase_Wait, file);
        newXS("Wx::SocketBase::WaitForRead", XS_Wx__SocketBase_WaitForRead, file);
        newXS("Wx::SocketBase::WaitForWrite", XS_Wx__SocketBase_WaitForWrite, file);
        newXS("Wx::SocketBase::Read", XS_Wx__SocketBase_Read, file);
        newXS("Wx::SocketBase::Close", XS_Wx__SocketBase_Close, file);
        newXS("Wx::SocketBase::Discard", XS_Wx__SocketBase_Discard, file);
        newXS("Wx::SocketBase::Error", XS_Wx__SocketBase_Error, file);
        newXS("Wx::SocketBase::GetFlags", XS_Wx__SocketBase_GetFlags, file);
        newXS("Wx::SocketBase::GetLocal", XS_Wx__SocketBase_GetLocal, file);
        newXS("Wx::SocketBase::GetPeer", XS_Wx__SocketBase_GetPeer, file);
        newXS("Wx::SocketBase::InterruptWait", XS_Wx__SocketBase_InterruptWait, file);
        newXS("Wx::SocketBase::LastError", XS_Wx__SocketBase_LastError, file);
        newXS("Wx::SocketBase::Peek", XS_Wx__SocketBase_Peek, file);
        newXS("Wx::SocketBase::ReadMsg", XS_Wx__SocketBase_ReadMsg, file);
        newXS("Wx::SocketBase::RestoreState", XS_Wx__SocketBase_RestoreState, file);
        newXS("Wx::SocketBase::SaveState", XS_Wx__SocketBase_SaveState, file);
        newXS("Wx::SocketBase::SetFlags", XS_Wx__SocketBase_SetFlags, file);
        newXS("Wx::SocketBase::SetNotify", XS_Wx__SocketBase_SetNotify, file);
        newXS("Wx::SocketBase::Unread", XS_Wx__SocketBase_Unread, file);
        newXS("Wx::SocketBase::WaitForLost", XS_Wx__SocketBase_WaitForLost, file);
        newXS("Wx::SocketBase::Write", XS_Wx__SocketBase_Write, file);
        newXS("Wx::SocketBase::WriteMsg", XS_Wx__SocketBase_WriteMsg, file);
        newXS("Wx::SocketBase::SetEventHandler", XS_Wx__SocketBase_SetEventHandler, file);
        newXS("Wx::SockAddress::CLONE", XS_Wx__SockAddress_CLONE, file);
        newXS("Wx::SockAddress::DESTROY", XS_Wx__SockAddress_DESTROY, file);
        newXS("Wx::SockAddress::Clear", XS_Wx__SockAddress_Clear, file);
        newXS("Wx::SockAddress::Type", XS_Wx__SockAddress_Type, file);
#if XSubPPtmpAAAB
        newXS("Wx::IPaddress::SetHostname", XS_Wx__IPaddress_SetHostname, file);
        newXS("Wx::IPaddress::SetService", XS_Wx__IPaddress_SetService, file);
        newXS("Wx::IPaddress::IsLocalHost", XS_Wx__IPaddress_IsLocalHost, file);
        newXS("Wx::IPaddress::SetAnyAddress", XS_Wx__IPaddress_SetAnyAddress, file);
        newXS("Wx::IPaddress::GetIPAddress", XS_Wx__IPaddress_GetIPAddress, file);
        newXS("Wx::IPaddress::GetHostname", XS_Wx__IPaddress_GetHostname, file);
        newXS("Wx::IPaddress::GetService", XS_Wx__IPaddress_GetService, file);
#endif
        newXS("Wx::IPV4address::new", XS_Wx__IPV4address_new, file);
        newXS("Wx::IPV4address::GetOrigHostname", XS_Wx__IPV4address_GetOrigHostname, file);
#if XSubPPtmpAAAC
        newXS("Wx::IPV4address::SetBroadcastAddress", XS_Wx__IPV4address_SetBroadcastAddress, file);
#endif
#if XSubPPtmpAAAD
        newXS("Wx::IPV6address::new", XS_Wx__IPV6address_new, file);
#endif
#if XSubPPtmpAAAE
        newXS("Wx::UNIXaddress::new", XS_Wx__UNIXaddress_new, file);
        newXS("Wx::UNIXaddress::GetFilename", XS_Wx__UNIXaddress_GetFilename, file);
        newXS("Wx::UNIXaddress::SetFilename", XS_Wx__UNIXaddress_SetFilename, file);
#endif
        newXS("Wx::DatagramSocket::new", XS_Wx__DatagramSocket_new, file);
        newXS("Wx::DatagramSocket::RecvFrom", XS_Wx__DatagramSocket_RecvFrom, file);
        newXS("Wx::DatagramSocket::SendTo", XS_Wx__DatagramSocket_SendTo, file);

    /* Initialisation Section */

  INIT_PLI_HELPERS( wx_pli_helpers );

#if XSubPPtmpAAAA
#endif
#if XSubPPtmpAAAB
#endif
#if XSubPPtmpAAAC
#endif
#if XSubPPtmpAAAD
#endif
#if XSubPPtmpAAAE
#endif

    /* End of Initialisation Section */

#if (PERL_REVISION == 5 && PERL_VERSION >= 9)
  if (PL_unitcheckav)
       call_list(PL_scopestack_ix, PL_unitcheckav);
#endif
    XSRETURN_YES;
}

