/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.28 from the
 * contents of VteTerminal.xs. Do not edit this file, edit VteTerminal.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "xs/VteTerminal.xs"
/*
 * Copyright (C) 2003 by the gtk2-perl team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include "vte2perl.h"

/* ------------------------------------------------------------------------- */

char **SvVteCharArray (SV *ref)
{
	char **result = NULL;

	if (SvOK (ref)) {
		if (SvRV (ref) && SvTYPE (SvRV (ref)) == SVt_PVAV) {
			AV *array = (AV *) SvRV (ref);
			SV **string;

			int i, length = av_len (array);
			result = g_new0 (char *, length + 2);

			for (i = 0; i <= length; i++)
				if ((string = av_fetch (array, i, 0)) && SvOK (*string))
					result[i] = SvPV_nolen (*string);

			result[length + 1] = NULL;
		}
		else
			croak ("the argument and environment parameters must be array references");
	}

	return result;
}

GdkColor *SvVteGdkColorArray (SV *ref, glong *size)
{
	GdkColor *result = NULL;

	if (SvOK (ref)) {
		if (SvRV (ref) && SvTYPE (SvRV (ref)) == SVt_PVAV) {
			AV *array = (AV *) SvRV (ref);
			SV **color;

			int i, length = av_len (array);
			result = g_new0 (GdkColor, length + 1);

			*size = length + 1;

			for (i = 0; i <= length; i++)
				if ((color = av_fetch (array, i, 0)) && SvOK (*color))
					result[i] = *((GdkColor *) SvGdkColor (*color));
		}
		else
			croak ("the pallete parameter must be a reference to an array of GdkColor's");
	}

	return result;
}

#if !VTE_CHECK_VERSION (0, 11, 11)
  typedef struct vte_char_attributes VteCharAttributes;
#endif

SV *
newSVVteCharAttributes (GArray *text_array)
{
	AV *array = newAV ();
	int i;

	for (i = 0; i < text_array->len; i++) {
		VteCharAttributes *text_attributes = &g_array_index(text_array, VteCharAttributes, i);
		HV *hash = newHV ();

		hv_store (hash, "row", 3, newSViv (text_attributes->row), 0);
		hv_store (hash, "column", 6, newSViv (text_attributes->column), 0);
		hv_store (hash, "fore", 4, newSVGdkColor_copy (&text_attributes->fore), 0);
		hv_store (hash, "back", 4, newSVGdkColor_copy (&text_attributes->back), 0);
		hv_store (hash, "underline", 9, newSVuv (text_attributes->underline), 0);
		hv_store (hash, "strikethrough", 13, newSVuv (text_attributes->strikethrough), 0);

		av_push (array, newRV_noinc ((SV *) hash));
	}

	return newRV_noinc ((SV *) array);
}

/* ------------------------------------------------------------------------- */

static GPerlCallback *
vte2perl_is_selected_create (SV * func, SV * data)
{
	GType param_types [] = {
		VTE_TYPE_TERMINAL,
		G_TYPE_LONG,
		G_TYPE_LONG
	};
	return gperl_callback_new (func, data, G_N_ELEMENTS (param_types),
				   param_types, G_TYPE_BOOLEAN);
}

static gboolean
vte2perl_is_selected (VteTerminal *terminal,
                      glong column,
                      glong row,
                      gpointer data)
{
	GPerlCallback *callback = (GPerlCallback *) data;
	GValue value = {0,};
	gboolean retval;

	g_value_init (&value, callback->return_type);
	gperl_callback_invoke (callback, &value, terminal, column, row);
	retval = g_value_get_boolean (&value);
	g_value_unset (&value);

	return retval;
}

/* ------------------------------------------------------------------------- */

#line 146 "xs/VteTerminal.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%"UVxf")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 290 "xs/VteTerminal.c"

XS_EUPXS(XS_Gnome2__Vte__Terminal_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "class");
    {
	GtkWidget *	RETVAL;

	RETVAL = vte_terminal_new(/* void */);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGtkWidget (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_im_append_menuitems); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_im_append_menuitems)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, menushell");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	GtkMenuShell *	menushell = SvGtkMenuShell (ST(1))
;

	vte_terminal_im_append_menuitems(terminal, menushell);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_fork_command); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_fork_command)
{
    dVAR; dXSARGS;
    if (items != 8)
       croak_xs_usage(cv,  "terminal, command, arg_ref, env_ref, directory, lastlog, utmp, wtmp");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	const char *	command = (const char *)SvPV_nolen(ST(1))
;
	SV *	arg_ref = ST(2)
;
	SV *	env_ref = ST(3)
;
	const char_ornull *	directory;
	gboolean	lastlog = (bool)SvTRUE(ST(5))
;
	gboolean	utmp = (bool)SvTRUE(ST(6))
;
	gboolean	wtmp = (bool)SvTRUE(ST(7))
;
#line 162 "xs/VteTerminal.xs"
	char **argv, **envv;
#line 355 "xs/VteTerminal.c"
	int	RETVAL;
	dXSTARG;

	if (gperl_sv_is_defined (ST(4))) {
		directory = (const char_ornull *)SvPV_nolen (ST(4));
	} else {
		directory = NULL;
	}
;
#line 164 "xs/VteTerminal.xs"
	argv = SvVteCharArray (arg_ref);
	envv = SvVteCharArray (env_ref);

	RETVAL = vte_terminal_fork_command (terminal,
	                                    command,
	                                    argv,
	                                    envv,
	                                    directory,
	                                    lastlog,
	                                    utmp,
	                                    wtmp);

	g_free (argv);
	g_free (envv);
#line 380 "xs/VteTerminal.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_feed); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_feed)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, data");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	SV *	data = ST(1)
;
#line 187 "xs/VteTerminal.xs"
	STRLEN len;
	char *real_data;
#line 401 "xs/VteTerminal.c"
#line 190 "xs/VteTerminal.xs"
	real_data = SvPV (data, len);
	vte_terminal_feed (terminal, real_data, len);
#line 405 "xs/VteTerminal.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_feed_child); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_feed_child)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, data");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	SV *	data = ST(1)
;
#line 199 "xs/VteTerminal.xs"
	STRLEN len;
	char *real_data;
#line 425 "xs/VteTerminal.c"
#line 202 "xs/VteTerminal.xs"
	real_data = SvPV (data, len);
	vte_terminal_feed_child (terminal, real_data, len);
#line 429 "xs/VteTerminal.c"
    }
    XSRETURN_EMPTY;
}

#if VTE_CHECK_VERSION (0, 12, 1)
#define XSubPPtmpAAAA 1


XS_EUPXS(XS_Gnome2__Vte__Terminal_feed_child_binary); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_feed_child_binary)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, data");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	SV *	data = ST(1)
;
#line 213 "xs/VteTerminal.xs"
	STRLEN len;
	char *real_data;
#line 452 "xs/VteTerminal.c"
#line 216 "xs/VteTerminal.xs"
	real_data = SvPV (data, len);
	vte_terminal_feed_child_binary (terminal, real_data, len);
#line 456 "xs/VteTerminal.c"
    }
    XSRETURN_EMPTY;
}

#endif

XS_EUPXS(XS_Gnome2__Vte__Terminal_copy_clipboard); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_copy_clipboard)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "terminal");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;

	vte_terminal_copy_clipboard(terminal);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_paste_clipboard); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_paste_clipboard)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "terminal");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;

	vte_terminal_paste_clipboard(terminal);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_copy_primary); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_copy_primary)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "terminal");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;

	vte_terminal_copy_primary(terminal);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_paste_primary); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_paste_primary)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "terminal");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;

	vte_terminal_paste_primary(terminal);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_set_size); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_set_size)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "terminal, columns, rows");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	glong	columns = (glong)SvIV(ST(1))
;
	glong	rows = (glong)SvIV(ST(2))
;

	vte_terminal_set_size(terminal, columns, rows);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_set_audible_bell); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_set_audible_bell)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, is_audible");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	gboolean	is_audible = (bool)SvTRUE(ST(1))
;

	vte_terminal_set_audible_bell(terminal, is_audible);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_get_audible_bell); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_get_audible_bell)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "terminal");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	gboolean	RETVAL;

	RETVAL = vte_terminal_get_audible_bell(terminal);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_set_visible_bell); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_set_visible_bell)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, is_visible");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	gboolean	is_visible = (bool)SvTRUE(ST(1))
;

	vte_terminal_set_visible_bell(terminal, is_visible);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_get_visible_bell); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_get_visible_bell)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "terminal");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	gboolean	RETVAL;

	RETVAL = vte_terminal_get_visible_bell(terminal);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_set_allow_bold); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_set_allow_bold)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, allow_bold");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	gboolean	allow_bold = (bool)SvTRUE(ST(1))
;

	vte_terminal_set_allow_bold(terminal, allow_bold);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_get_allow_bold); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_get_allow_bold)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "terminal");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	gboolean	RETVAL;

	RETVAL = vte_terminal_get_allow_bold(terminal);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_set_scroll_on_output); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_set_scroll_on_output)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, scroll");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	gboolean	scroll = (bool)SvTRUE(ST(1))
;

	vte_terminal_set_scroll_on_output(terminal, scroll);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_set_scroll_on_keystroke); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_set_scroll_on_keystroke)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, scroll");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	gboolean	scroll = (bool)SvTRUE(ST(1))
;

	vte_terminal_set_scroll_on_keystroke(terminal, scroll);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_set_color_bold); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_set_color_bold)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, bold");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	const GdkColor *	bold = SvGdkColor (ST(1))
;

	vte_terminal_set_color_bold(terminal, bold);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_set_color_foreground); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_set_color_foreground)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, foreground");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	const GdkColor *	foreground = SvGdkColor (ST(1))
;

	vte_terminal_set_color_foreground(terminal, foreground);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_set_color_background); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_set_color_background)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, background");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	const GdkColor *	background = SvGdkColor (ST(1))
;

	vte_terminal_set_color_background(terminal, background);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_set_color_dim); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_set_color_dim)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, dim");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	const GdkColor *	dim = SvGdkColor (ST(1))
;

	vte_terminal_set_color_dim(terminal, dim);
    }
    XSRETURN_EMPTY;
}

#if VTE_CHECK_VERSION (0, 12, 0)
#define XSubPPtmpAAAB 1


XS_EUPXS(XS_Gnome2__Vte__Terminal_set_color_cursor); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_set_color_cursor)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, cursor_background");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	const GdkColor_ornull *	cursor_background = SvGdkColor_ornull (ST(1))
;

	vte_terminal_set_color_cursor(terminal, cursor_background);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_set_color_highlight); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_set_color_highlight)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, highlight_background");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	const GdkColor_ornull *	highlight_background = SvGdkColor_ornull (ST(1))
;

	vte_terminal_set_color_highlight(terminal, highlight_background);
    }
    XSRETURN_EMPTY;
}

#endif

XS_EUPXS(XS_Gnome2__Vte__Terminal_set_colors); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_set_colors)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "terminal, foreground, background, palette_ref");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	const GdkColor_ornull *	foreground = SvGdkColor_ornull (ST(1))
;
	const GdkColor_ornull *	background = SvGdkColor_ornull (ST(2))
;
	SV *	palette_ref = ST(3)
;
#line 341 "xs/VteTerminal.xs"
	GdkColor *palette = NULL;
	glong palette_size;
#line 821 "xs/VteTerminal.c"
#line 344 "xs/VteTerminal.xs"
	palette = SvVteGdkColorArray (palette_ref, &palette_size);

	vte_terminal_set_colors (terminal,
	                         foreground,
	                         background,
	                         palette,
	                         palette_size);

	g_free (palette);
#line 832 "xs/VteTerminal.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_set_default_colors); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_set_default_colors)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "terminal");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;

	vte_terminal_set_default_colors(terminal);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_set_background_image); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_set_background_image)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, image");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	GdkPixbuf_ornull *	image = SvGdkPixbuf_ornull (ST(1))
;

	vte_terminal_set_background_image(terminal, image);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_set_background_image_file); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_set_background_image_file)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, path");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	const char *	path = (const char *)SvPV_nolen(ST(1))
;

	vte_terminal_set_background_image_file(terminal, path);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_set_background_saturation); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_set_background_saturation)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, saturation");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	double	saturation = (double)SvNV(ST(1))
;

	vte_terminal_set_background_saturation(terminal, saturation);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_set_background_transparent); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_set_background_transparent)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, transparent");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	gboolean	transparent = (bool)SvTRUE(ST(1))
;

	vte_terminal_set_background_transparent(terminal, transparent);
    }
    XSRETURN_EMPTY;
}

#if VTE_CHECK_VERSION (0, 14, 0)
#define XSubPPtmpAAAC 1


XS_EUPXS(XS_Gnome2__Vte__Terminal_set_opacity); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_set_opacity)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, opacity");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	guint16	opacity = (guint16)SvUV(ST(1))
;

	vte_terminal_set_opacity(terminal, opacity);
    }
    XSRETURN_EMPTY;
}

#endif
#if VTE_CHECK_VERSION (0, 12, 0)
#define XSubPPtmpAAAD 1


XS_EUPXS(XS_Gnome2__Vte__Terminal_set_background_tint_color); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_set_background_tint_color)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, color");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	const GdkColor *	color = SvGdkColor (ST(1))
;

	vte_terminal_set_background_tint_color(terminal, color);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_set_scroll_background); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_set_scroll_background)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, scroll");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	gboolean	scroll = (bool)SvTRUE(ST(1))
;

	vte_terminal_set_scroll_background(terminal, scroll);
    }
    XSRETURN_EMPTY;
}

#endif

XS_EUPXS(XS_Gnome2__Vte__Terminal_set_cursor_blinks); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_set_cursor_blinks)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, blink");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	gboolean	blink = (bool)SvTRUE(ST(1))
;

	vte_terminal_set_cursor_blinks(terminal, blink);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_set_scrollback_lines); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_set_scrollback_lines)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, lines");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	glong	lines = (glong)SvIV(ST(1))
;

	vte_terminal_set_scrollback_lines(terminal, lines);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_set_font); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_set_font)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, font_desc");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	const PangoFontDescription *	font_desc = SvPangoFontDescription (ST(1))
;

	vte_terminal_set_font(terminal, font_desc);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_set_font_from_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_set_font_from_string)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, name");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	const char *	name = (const char *)SvPV_nolen(ST(1))
;

	vte_terminal_set_font_from_string(terminal, name);
    }
    XSRETURN_EMPTY;
}

#if VTE_CHECK_VERSION (0, 12, 0)
#define XSubPPtmpAAAE 1


XS_EUPXS(XS_Gnome2__Vte__Terminal_set_font_full); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_set_font_full)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "terminal, font_desc, anti_alias");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	const PangoFontDescription_ornull *	font_desc = SvPangoFontDescription_ornull (ST(1))
;
	VteTerminalAntiAlias	anti_alias = SvVteTerminalAntiAlias (ST(2))
;

	vte_terminal_set_font_full(terminal, font_desc, anti_alias);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_set_font_from_string_full); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_set_font_from_string_full)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "terminal, name, anti_alias");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	const char *	name = (const char *)SvPV_nolen(ST(1))
;
	VteTerminalAntiAlias	anti_alias = SvVteTerminalAntiAlias (ST(2))
;

	vte_terminal_set_font_from_string_full(terminal, name, anti_alias);
    }
    XSRETURN_EMPTY;
}

#endif

XS_EUPXS(XS_Gnome2__Vte__Terminal_get_font); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_get_font)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "terminal");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	PangoFontDescription *	RETVAL;
#line 452 "xs/VteTerminal.xs"
	RETVAL = (PangoFontDescription *) vte_terminal_get_font (terminal);
#line 1116 "xs/VteTerminal.c"
	{
	    SV * RETVALSV;
	    RETVALSV = newSVPangoFontDescription (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_get_using_xft); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_get_using_xft)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "terminal");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	gboolean	RETVAL;

	RETVAL = vte_terminal_get_using_xft(terminal);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_get_has_selection); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_get_has_selection)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "terminal");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	gboolean	RETVAL;

	RETVAL = vte_terminal_get_has_selection(terminal);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_set_word_chars); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_set_word_chars)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, spec");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	const char_ornull *	spec;

	if (gperl_sv_is_defined (ST(1))) {
		spec = (const char_ornull *)SvPV_nolen (ST(1));
	} else {
		spec = NULL;
	}
;

	vte_terminal_set_word_chars(terminal, spec);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_is_word_char); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_is_word_char)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, c");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	gunichar	c = g_utf8_get_char (SvGChar (ST(1)))
;
	gboolean	RETVAL;

	RETVAL = vte_terminal_is_word_char(terminal, c);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_set_backspace_binding); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_set_backspace_binding)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, binding");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	VteTerminalEraseBinding	binding = SvVteTerminalEraseBinding (ST(1))
;

	vte_terminal_set_backspace_binding(terminal, binding);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_set_delete_binding); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_set_delete_binding)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, binding");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	VteTerminalEraseBinding	binding = SvVteTerminalEraseBinding (ST(1))
;

	vte_terminal_set_delete_binding(terminal, binding);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_set_mouse_autohide); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_set_mouse_autohide)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, setting");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	gboolean	setting = (bool)SvTRUE(ST(1))
;

	vte_terminal_set_mouse_autohide(terminal, setting);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_get_mouse_autohide); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_get_mouse_autohide)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "terminal");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	gboolean	RETVAL;

	RETVAL = vte_terminal_get_mouse_autohide(terminal);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_reset); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_reset)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "terminal, full, clear_history");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	gboolean	full = (bool)SvTRUE(ST(1))
;
	gboolean	clear_history = (bool)SvTRUE(ST(2))
;

	vte_terminal_reset(terminal, full, clear_history);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_get_text); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_get_text)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "terminal, func=NULL, data=NULL");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	SV *	func;
	SV *	data;
#line 521 "xs/VteTerminal.xs"
	GPerlCallback *callback;
	GArray *attributes;
	char *text = "";
#line 1317 "xs/VteTerminal.c"

	if (items < 2)
	    func = NULL;
	else {
	    func = ST(1)
;
	}

	if (items < 3)
	    data = NULL;
	else {
	    data = ST(2)
;
	}
#line 525 "xs/VteTerminal.xs"
	callback = func && SvOK (func)
		? vte2perl_is_selected_create (func, data)
		: NULL;
	attributes = g_array_new (FALSE, TRUE, sizeof (VteCharAttributes));

	g_object_set_data_full (G_OBJECT (terminal),
	                        "_is_selected_callback",
	                        callback,
	                        (GDestroyNotify) gperl_callback_destroy);

	text = callback
		? vte_terminal_get_text (terminal, vte2perl_is_selected, callback, attributes)
		: vte_terminal_get_text (terminal, NULL, NULL, attributes);

	EXTEND (sp, 2);
	PUSHs (sv_2mortal (newSVGChar (text)));
	PUSHs (sv_2mortal (newSVVteCharAttributes (attributes)));

	g_array_free(attributes, TRUE);
	g_free (text);
#line 1353 "xs/VteTerminal.c"
	PUTBACK;
	return;
    }
}

#if VTE_CHECK_VERSION (0, 12, 0)
#define XSubPPtmpAAAF 1


XS_EUPXS(XS_Gnome2__Vte__Terminal_get_text_include_trailing_spaces); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_get_text_include_trailing_spaces)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "terminal, func, data=NULL");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	SV *	func = ST(1)
;
	SV *	data;
#line 561 "xs/VteTerminal.xs"
	GPerlCallback *callback;
	GArray *attributes;
	char *text = "";
#line 1381 "xs/VteTerminal.c"

	if (items < 3)
	    data = NULL;
	else {
	    data = ST(2)
;
	}
#line 565 "xs/VteTerminal.xs"
	callback = vte2perl_is_selected_create (func, data);
	attributes = g_array_new (FALSE, TRUE, sizeof (VteCharAttributes));

	g_object_set_data_full (G_OBJECT (terminal),
	                        "_is_selected_callback",
	                        callback,
	                        (GDestroyNotify) gperl_callback_destroy);

	text = vte_terminal_get_text_include_trailing_spaces (terminal, vte2perl_is_selected, callback, attributes);

	EXTEND (sp, 2);
	PUSHs (sv_2mortal (newSVGChar (text)));
	PUSHs (sv_2mortal (newSVVteCharAttributes (attributes)));

	g_array_free(attributes, TRUE);
	g_free (text);
#line 1406 "xs/VteTerminal.c"
	PUTBACK;
	return;
    }
}

#endif

XS_EUPXS(XS_Gnome2__Vte__Terminal_get_text_range); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_get_text_range)
{
    dVAR; dXSARGS;
    if (items < 6 || items > 7)
       croak_xs_usage(cv,  "terminal, start_row, start_col, end_row, end_col, func, data=NULL");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	glong	start_row = (glong)SvIV(ST(1))
;
	glong	start_col = (glong)SvIV(ST(2))
;
	glong	end_row = (glong)SvIV(ST(3))
;
	glong	end_col = (glong)SvIV(ST(4))
;
	SV *	func = ST(5)
;
	SV *	data;
#line 601 "xs/VteTerminal.xs"
	GPerlCallback *callback;
	GArray *attributes;
	char *text;
#line 1440 "xs/VteTerminal.c"

	if (items < 7)
	    data = NULL;
	else {
	    data = ST(6)
;
	}
#line 605 "xs/VteTerminal.xs"
	callback = vte2perl_is_selected_create (func, data);
	attributes = g_array_new (FALSE, TRUE, sizeof (VteCharAttributes));

	g_object_set_data_full (G_OBJECT (terminal),
	                        "_is_selected_callback",
	                        callback,
	                        (GDestroyNotify) gperl_callback_destroy);

	text = vte_terminal_get_text_range (terminal, start_row, start_col, end_row, end_col, vte2perl_is_selected, callback, attributes);

	EXTEND (sp, 2);
	PUSHs (sv_2mortal (newSVGChar (text)));
	PUSHs (sv_2mortal (newSVVteCharAttributes (attributes)));

	g_array_free(attributes, TRUE);
	g_free (text);
#line 1465 "xs/VteTerminal.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_get_cursor_position); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_get_cursor_position)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "terminal");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	glong	column;
	glong	row;

	vte_terminal_get_cursor_position(terminal, &column, &row);
	XSprePUSH;	EXTEND(SP,2);
	PUSHs(sv_newmortal());
	sv_setiv(ST(0), (IV)column);
	PUSHs(sv_newmortal());
	sv_setiv(ST(1), (IV)row);
    }
    XSRETURN(2);
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_match_clear_all); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_match_clear_all)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "terminal");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;

	vte_terminal_match_clear_all(terminal);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_match_add); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_match_add)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, match");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	const char *	match = (const char *)SvPV_nolen(ST(1))
;
	int	RETVAL;
	dXSTARG;

	RETVAL = vte_terminal_match_add(terminal, match);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_match_remove); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_match_remove)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, tag");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	int	tag = (int)SvIV(ST(1))
;

	vte_terminal_match_remove(terminal, tag);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_match_check); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_match_check)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "terminal, column, row");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 647 "xs/VteTerminal.xs"
	gchar *match;
	int tag;
#line 1562 "xs/VteTerminal.c"
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	glong	column = (glong)SvIV(ST(1))
;
	glong	row = (glong)SvIV(ST(2))
;
#line 650 "xs/VteTerminal.xs"
	match = vte_terminal_match_check (terminal, column, row, &tag);
	EXTEND (SP, 2);
	PUSHs (sv_2mortal (newSVGChar (match)));
	PUSHs (sv_2mortal (newSViv (tag)));
	g_free (match);
#line 1575 "xs/VteTerminal.c"
	PUTBACK;
	return;
    }
}

#if VTE_CHECK_VERSION (0, 12, 0)
#define XSubPPtmpAAAG 1


XS_EUPXS(XS_Gnome2__Vte__Terminal_match_set_cursor); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_match_set_cursor)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "terminal, tag, cursor");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	int	tag = (int)SvIV(ST(1))
;
	GdkCursor *	cursor = SvGdkCursor (ST(2))
;

	vte_terminal_match_set_cursor(terminal, tag, cursor);
    }
    XSRETURN_EMPTY;
}

#endif
#if VTE_CHECK_VERSION (0, 12, 0)
#define XSubPPtmpAAAH 1


XS_EUPXS(XS_Gnome2__Vte__Terminal_match_set_cursor_type); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_match_set_cursor_type)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "terminal, tag, cursor_type");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	int	tag = (int)SvIV(ST(1))
;
	GdkCursorType	cursor_type = SvGdkCursorType (ST(2))
;

	vte_terminal_match_set_cursor_type(terminal, tag, cursor_type);
    }
    XSRETURN_EMPTY;
}

#endif

XS_EUPXS(XS_Gnome2__Vte__Terminal_set_emulation); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_set_emulation)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, emulation");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	const char *	emulation = (const char *)SvPV_nolen(ST(1))
;

	vte_terminal_set_emulation(terminal, emulation);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_get_emulation); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_get_emulation)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "terminal");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	const char *	RETVAL;
	dXSTARG;

	RETVAL = vte_terminal_get_emulation(terminal);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}

#if VTE_CHECK_VERSION (0, 12, 0)
#define XSubPPtmpAAAI 1


XS_EUPXS(XS_Gnome2__Vte__Terminal_get_default_emulation); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_get_default_emulation)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "terminal");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	const char *	RETVAL;
	dXSTARG;

	RETVAL = vte_terminal_get_default_emulation(terminal);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Gnome2__Vte__Terminal_set_encoding); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_set_encoding)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, codeset");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	const char *	codeset = (const char *)SvPV_nolen(ST(1))
;

	vte_terminal_set_encoding(terminal, codeset);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_get_encoding); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_get_encoding)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "terminal");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	const char *	RETVAL;
	dXSTARG;

	RETVAL = vte_terminal_get_encoding(terminal);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_get_status_line); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_get_status_line)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "terminal");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	const gchar *	RETVAL;

	RETVAL = vte_terminal_get_status_line(terminal);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    /* same as newSVGChar(), but not in a function */
	    sv_setpv ((SV*)RETVALSV, RETVAL);
	    SvUTF8_on (RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_get_padding); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_get_padding)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "terminal");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	int	xpad;
	int	ypad;

	vte_terminal_get_padding(terminal, &xpad, &ypad);
	XSprePUSH;	EXTEND(SP,2);
	PUSHs(sv_newmortal());
	sv_setiv(ST(0), (IV)xpad);
	PUSHs(sv_newmortal());
	sv_setiv(ST(1), (IV)ypad);
    }
    XSRETURN(2);
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_get_adjustment); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_get_adjustment)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "terminal");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	GtkAdjustment *	RETVAL;

	RETVAL = vte_terminal_get_adjustment(terminal);
	{
	    SV * RETVALSV;
	    RETVALSV = newSVGtkAdjustment (RETVAL);
	    RETVALSV = sv_2mortal(RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_get_char_ascent); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_get_char_ascent)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "terminal");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	glong	RETVAL;
	dXSTARG;

	RETVAL = vte_terminal_get_char_ascent(terminal);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_get_char_descent); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_get_char_descent)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "terminal");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	glong	RETVAL;
	dXSTARG;

	RETVAL = vte_terminal_get_char_descent(terminal);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_get_char_height); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_get_char_height)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "terminal");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	glong	RETVAL;
	dXSTARG;

	RETVAL = vte_terminal_get_char_height(terminal);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_get_char_width); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_get_char_width)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "terminal");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	glong	RETVAL;
	dXSTARG;

	RETVAL = vte_terminal_get_char_width(terminal);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_get_column_count); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_get_column_count)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "terminal");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	glong	RETVAL;
	dXSTARG;

	RETVAL = vte_terminal_get_column_count(terminal);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_get_icon_title); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_get_icon_title)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "terminal");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	const gchar *	RETVAL;

	RETVAL = vte_terminal_get_icon_title(terminal);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    /* same as newSVGChar(), but not in a function */
	    sv_setpv ((SV*)RETVALSV, RETVAL);
	    SvUTF8_on (RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#if VTE_CHECK_VERSION (0, 12, 1)
#define XSubPPtmpAAAJ 1


XS_EUPXS(XS_Gnome2__Vte__Terminal_set_pty); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_set_pty)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "terminal, pty_master");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	int	pty_master = (int)SvIV(ST(1))
;

	vte_terminal_set_pty(terminal, pty_master);
    }
    XSRETURN_EMPTY;
}

#endif

XS_EUPXS(XS_Gnome2__Vte__Terminal_get_row_count); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_get_row_count)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "terminal");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	glong	RETVAL;
	dXSTARG;

	RETVAL = vte_terminal_get_row_count(terminal);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Gnome2__Vte__Terminal_get_window_title); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Gnome2__Vte__Terminal_get_window_title)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "terminal");
    {
	VteTerminal *	terminal = SvVteTerminal (ST(0))
;
	const gchar *	RETVAL;

	RETVAL = vte_terminal_get_window_title(terminal);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    /* same as newSVGChar(), but not in a function */
	    sv_setpv ((SV*)RETVALSV, RETVAL);
	    SvUTF8_on (RETVALSV);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_Gnome2__Vte__Terminal); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Gnome2__Vte__Terminal)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        newXS_deffile("Gnome2::Vte::Terminal::new", XS_Gnome2__Vte__Terminal_new);
        newXS_deffile("Gnome2::Vte::Terminal::im_append_menuitems", XS_Gnome2__Vte__Terminal_im_append_menuitems);
        newXS_deffile("Gnome2::Vte::Terminal::fork_command", XS_Gnome2__Vte__Terminal_fork_command);
        newXS_deffile("Gnome2::Vte::Terminal::feed", XS_Gnome2__Vte__Terminal_feed);
        newXS_deffile("Gnome2::Vte::Terminal::feed_child", XS_Gnome2__Vte__Terminal_feed_child);
#if XSubPPtmpAAAA
        newXS_deffile("Gnome2::Vte::Terminal::feed_child_binary", XS_Gnome2__Vte__Terminal_feed_child_binary);
#endif
        newXS_deffile("Gnome2::Vte::Terminal::copy_clipboard", XS_Gnome2__Vte__Terminal_copy_clipboard);
        newXS_deffile("Gnome2::Vte::Terminal::paste_clipboard", XS_Gnome2__Vte__Terminal_paste_clipboard);
        newXS_deffile("Gnome2::Vte::Terminal::copy_primary", XS_Gnome2__Vte__Terminal_copy_primary);
        newXS_deffile("Gnome2::Vte::Terminal::paste_primary", XS_Gnome2__Vte__Terminal_paste_primary);
        newXS_deffile("Gnome2::Vte::Terminal::set_size", XS_Gnome2__Vte__Terminal_set_size);
        newXS_deffile("Gnome2::Vte::Terminal::set_audible_bell", XS_Gnome2__Vte__Terminal_set_audible_bell);
        newXS_deffile("Gnome2::Vte::Terminal::get_audible_bell", XS_Gnome2__Vte__Terminal_get_audible_bell);
        newXS_deffile("Gnome2::Vte::Terminal::set_visible_bell", XS_Gnome2__Vte__Terminal_set_visible_bell);
        newXS_deffile("Gnome2::Vte::Terminal::get_visible_bell", XS_Gnome2__Vte__Terminal_get_visible_bell);
        newXS_deffile("Gnome2::Vte::Terminal::set_allow_bold", XS_Gnome2__Vte__Terminal_set_allow_bold);
        newXS_deffile("Gnome2::Vte::Terminal::get_allow_bold", XS_Gnome2__Vte__Terminal_get_allow_bold);
        newXS_deffile("Gnome2::Vte::Terminal::set_scroll_on_output", XS_Gnome2__Vte__Terminal_set_scroll_on_output);
        newXS_deffile("Gnome2::Vte::Terminal::set_scroll_on_keystroke", XS_Gnome2__Vte__Terminal_set_scroll_on_keystroke);
        newXS_deffile("Gnome2::Vte::Terminal::set_color_bold", XS_Gnome2__Vte__Terminal_set_color_bold);
        newXS_deffile("Gnome2::Vte::Terminal::set_color_foreground", XS_Gnome2__Vte__Terminal_set_color_foreground);
        newXS_deffile("Gnome2::Vte::Terminal::set_color_background", XS_Gnome2__Vte__Terminal_set_color_background);
        newXS_deffile("Gnome2::Vte::Terminal::set_color_dim", XS_Gnome2__Vte__Terminal_set_color_dim);
#if XSubPPtmpAAAB
        newXS_deffile("Gnome2::Vte::Terminal::set_color_cursor", XS_Gnome2__Vte__Terminal_set_color_cursor);
        newXS_deffile("Gnome2::Vte::Terminal::set_color_highlight", XS_Gnome2__Vte__Terminal_set_color_highlight);
#endif
        newXS_deffile("Gnome2::Vte::Terminal::set_colors", XS_Gnome2__Vte__Terminal_set_colors);
        newXS_deffile("Gnome2::Vte::Terminal::set_default_colors", XS_Gnome2__Vte__Terminal_set_default_colors);
        newXS_deffile("Gnome2::Vte::Terminal::set_background_image", XS_Gnome2__Vte__Terminal_set_background_image);
        newXS_deffile("Gnome2::Vte::Terminal::set_background_image_file", XS_Gnome2__Vte__Terminal_set_background_image_file);
        newXS_deffile("Gnome2::Vte::Terminal::set_background_saturation", XS_Gnome2__Vte__Terminal_set_background_saturation);
        newXS_deffile("Gnome2::Vte::Terminal::set_background_transparent", XS_Gnome2__Vte__Terminal_set_background_transparent);
#if XSubPPtmpAAAC
        newXS_deffile("Gnome2::Vte::Terminal::set_opacity", XS_Gnome2__Vte__Terminal_set_opacity);
#endif
#if XSubPPtmpAAAD
        newXS_deffile("Gnome2::Vte::Terminal::set_background_tint_color", XS_Gnome2__Vte__Terminal_set_background_tint_color);
        newXS_deffile("Gnome2::Vte::Terminal::set_scroll_background", XS_Gnome2__Vte__Terminal_set_scroll_background);
#endif
        newXS_deffile("Gnome2::Vte::Terminal::set_cursor_blinks", XS_Gnome2__Vte__Terminal_set_cursor_blinks);
        newXS_deffile("Gnome2::Vte::Terminal::set_scrollback_lines", XS_Gnome2__Vte__Terminal_set_scrollback_lines);
        newXS_deffile("Gnome2::Vte::Terminal::set_font", XS_Gnome2__Vte__Terminal_set_font);
        newXS_deffile("Gnome2::Vte::Terminal::set_font_from_string", XS_Gnome2__Vte__Terminal_set_font_from_string);
#if XSubPPtmpAAAE
        newXS_deffile("Gnome2::Vte::Terminal::set_font_full", XS_Gnome2__Vte__Terminal_set_font_full);
        newXS_deffile("Gnome2::Vte::Terminal::set_font_from_string_full", XS_Gnome2__Vte__Terminal_set_font_from_string_full);
#endif
        newXS_deffile("Gnome2::Vte::Terminal::get_font", XS_Gnome2__Vte__Terminal_get_font);
        newXS_deffile("Gnome2::Vte::Terminal::get_using_xft", XS_Gnome2__Vte__Terminal_get_using_xft);
        newXS_deffile("Gnome2::Vte::Terminal::get_has_selection", XS_Gnome2__Vte__Terminal_get_has_selection);
        newXS_deffile("Gnome2::Vte::Terminal::set_word_chars", XS_Gnome2__Vte__Terminal_set_word_chars);
        newXS_deffile("Gnome2::Vte::Terminal::is_word_char", XS_Gnome2__Vte__Terminal_is_word_char);
        newXS_deffile("Gnome2::Vte::Terminal::set_backspace_binding", XS_Gnome2__Vte__Terminal_set_backspace_binding);
        newXS_deffile("Gnome2::Vte::Terminal::set_delete_binding", XS_Gnome2__Vte__Terminal_set_delete_binding);
        newXS_deffile("Gnome2::Vte::Terminal::set_mouse_autohide", XS_Gnome2__Vte__Terminal_set_mouse_autohide);
        newXS_deffile("Gnome2::Vte::Terminal::get_mouse_autohide", XS_Gnome2__Vte__Terminal_get_mouse_autohide);
        newXS_deffile("Gnome2::Vte::Terminal::reset", XS_Gnome2__Vte__Terminal_reset);
        newXS_deffile("Gnome2::Vte::Terminal::get_text", XS_Gnome2__Vte__Terminal_get_text);
#if XSubPPtmpAAAF
        newXS_deffile("Gnome2::Vte::Terminal::get_text_include_trailing_spaces", XS_Gnome2__Vte__Terminal_get_text_include_trailing_spaces);
#endif
        newXS_deffile("Gnome2::Vte::Terminal::get_text_range", XS_Gnome2__Vte__Terminal_get_text_range);
        newXS_deffile("Gnome2::Vte::Terminal::get_cursor_position", XS_Gnome2__Vte__Terminal_get_cursor_position);
        newXS_deffile("Gnome2::Vte::Terminal::match_clear_all", XS_Gnome2__Vte__Terminal_match_clear_all);
        newXS_deffile("Gnome2::Vte::Terminal::match_add", XS_Gnome2__Vte__Terminal_match_add);
        newXS_deffile("Gnome2::Vte::Terminal::match_remove", XS_Gnome2__Vte__Terminal_match_remove);
        newXS_deffile("Gnome2::Vte::Terminal::match_check", XS_Gnome2__Vte__Terminal_match_check);
#if XSubPPtmpAAAG
        newXS_deffile("Gnome2::Vte::Terminal::match_set_cursor", XS_Gnome2__Vte__Terminal_match_set_cursor);
#endif
#if XSubPPtmpAAAH
        newXS_deffile("Gnome2::Vte::Terminal::match_set_cursor_type", XS_Gnome2__Vte__Terminal_match_set_cursor_type);
#endif
        newXS_deffile("Gnome2::Vte::Terminal::set_emulation", XS_Gnome2__Vte__Terminal_set_emulation);
        newXS_deffile("Gnome2::Vte::Terminal::get_emulation", XS_Gnome2__Vte__Terminal_get_emulation);
#if XSubPPtmpAAAI
        newXS_deffile("Gnome2::Vte::Terminal::get_default_emulation", XS_Gnome2__Vte__Terminal_get_default_emulation);
#endif
        newXS_deffile("Gnome2::Vte::Terminal::set_encoding", XS_Gnome2__Vte__Terminal_set_encoding);
        newXS_deffile("Gnome2::Vte::Terminal::get_encoding", XS_Gnome2__Vte__Terminal_get_encoding);
        newXS_deffile("Gnome2::Vte::Terminal::get_status_line", XS_Gnome2__Vte__Terminal_get_status_line);
        newXS_deffile("Gnome2::Vte::Terminal::get_padding", XS_Gnome2__Vte__Terminal_get_padding);
        newXS_deffile("Gnome2::Vte::Terminal::get_adjustment", XS_Gnome2__Vte__Terminal_get_adjustment);
        newXS_deffile("Gnome2::Vte::Terminal::get_char_ascent", XS_Gnome2__Vte__Terminal_get_char_ascent);
        newXS_deffile("Gnome2::Vte::Terminal::get_char_descent", XS_Gnome2__Vte__Terminal_get_char_descent);
        newXS_deffile("Gnome2::Vte::Terminal::get_char_height", XS_Gnome2__Vte__Terminal_get_char_height);
        newXS_deffile("Gnome2::Vte::Terminal::get_char_width", XS_Gnome2__Vte__Terminal_get_char_width);
        newXS_deffile("Gnome2::Vte::Terminal::get_column_count", XS_Gnome2__Vte__Terminal_get_column_count);
        newXS_deffile("Gnome2::Vte::Terminal::get_icon_title", XS_Gnome2__Vte__Terminal_get_icon_title);
#if XSubPPtmpAAAJ
        newXS_deffile("Gnome2::Vte::Terminal::set_pty", XS_Gnome2__Vte__Terminal_set_pty);
#endif
        newXS_deffile("Gnome2::Vte::Terminal::get_row_count", XS_Gnome2__Vte__Terminal_get_row_count);
        newXS_deffile("Gnome2::Vte::Terminal::get_window_title", XS_Gnome2__Vte__Terminal_get_window_title);

    /* Initialisation Section */

#if XSubPPtmpAAAA
#endif
#if XSubPPtmpAAAB
#endif
#if XSubPPtmpAAAC
#endif
#if XSubPPtmpAAAD
#endif
#if XSubPPtmpAAAE
#endif
#if XSubPPtmpAAAF
#endif
#if XSubPPtmpAAAG
#endif
#if XSubPPtmpAAAH
#endif
#if XSubPPtmpAAAI
#endif
#if XSubPPtmpAAAJ
#endif
#line 2131 "xs/VteTerminal.c"

    /* End of Initialisation Section */

#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

