/* midori-database.c generated by valac 0.30.0, the Vala compiler
 * generated from midori-database.vala, do not modify */

/*
 Copyright (C) 2013 Christian Dywan <christian@twotoats.de>

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 See the file COPYING for the full license text.
*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <stdio.h>
#include <float.h>
#include <math.h>
#include <unistd.h>
#include <glib/gstdio.h>


#define MIDORI_TYPE_DATABASE_STATEMENT (midori_database_statement_get_type ())
#define MIDORI_DATABASE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MIDORI_TYPE_DATABASE_STATEMENT, MidoriDatabaseStatement))
#define MIDORI_DATABASE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MIDORI_TYPE_DATABASE_STATEMENT, MidoriDatabaseStatementClass))
#define MIDORI_IS_DATABASE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MIDORI_TYPE_DATABASE_STATEMENT))
#define MIDORI_IS_DATABASE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MIDORI_TYPE_DATABASE_STATEMENT))
#define MIDORI_DATABASE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MIDORI_TYPE_DATABASE_STATEMENT, MidoriDatabaseStatementClass))

typedef struct _MidoriDatabaseStatement MidoriDatabaseStatement;
typedef struct _MidoriDatabaseStatementClass MidoriDatabaseStatementClass;
typedef struct _MidoriDatabaseStatementPrivate MidoriDatabaseStatementPrivate;

#define MIDORI_TYPE_DATABASE (midori_database_get_type ())
#define MIDORI_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MIDORI_TYPE_DATABASE, MidoriDatabase))
#define MIDORI_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MIDORI_TYPE_DATABASE, MidoriDatabaseClass))
#define MIDORI_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MIDORI_TYPE_DATABASE))
#define MIDORI_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MIDORI_TYPE_DATABASE))
#define MIDORI_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MIDORI_TYPE_DATABASE, MidoriDatabaseClass))

typedef struct _MidoriDatabase MidoriDatabase;
typedef struct _MidoriDatabaseClass MidoriDatabaseClass;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _MidoriDatabasePrivate MidoriDatabasePrivate;
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block3Data Block3Data;

typedef enum  {
	MIDORI_DATABASE_ERROR_OPEN,
	MIDORI_DATABASE_ERROR_NAMING,
	MIDORI_DATABASE_ERROR_FILENAME,
	MIDORI_DATABASE_ERROR_EXECUTE,
	MIDORI_DATABASE_ERROR_COMPILE,
	MIDORI_DATABASE_ERROR_TYPE
} MidoriDatabaseError;
#define MIDORI_DATABASE_ERROR midori_database_error_quark ()
typedef gboolean (*MidoriDatabaseCallback) (void* user_data, GError** error);
struct _MidoriDatabaseStatement {
	GObject parent_instance;
	MidoriDatabaseStatementPrivate * priv;
	sqlite3_stmt* _stmt;
};

struct _MidoriDatabaseStatementClass {
	GObjectClass parent_class;
	gboolean (*init) (MidoriDatabaseStatement* self, GCancellable* cancellable, GError** error);
};

struct _MidoriDatabaseStatementPrivate {
	MidoriDatabase* _database;
	gchar* _query;
	gint64 last_row_id;
};

struct _MidoriDatabase {
	GObject parent_instance;
	MidoriDatabasePrivate * priv;
	gboolean trace;
	sqlite3* _db;
};

struct _MidoriDatabaseClass {
	GObjectClass parent_class;
	gboolean (*init) (MidoriDatabase* self, GCancellable* cancellable, GError** error);
};

struct _MidoriDatabasePrivate {
	gchar* _path;
	gboolean _first_use;
};

struct _Block3Data {
	int _ref_count_;
	MidoriDatabase* self;
	gchar* schema;
};


static gpointer midori_database_statement_parent_class = NULL;
static GInitableIface* midori_database_statement_g_initable_parent_iface = NULL;
static gpointer midori_database_parent_class = NULL;
static GInitableIface* midori_database_g_initable_parent_iface = NULL;

GQuark midori_database_error_quark (void);
GType midori_database_statement_get_type (void) G_GNUC_CONST;
GType midori_database_get_type (void) G_GNUC_CONST;
#define MIDORI_DATABASE_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MIDORI_TYPE_DATABASE_STATEMENT, MidoriDatabaseStatementPrivate))
enum  {
	MIDORI_DATABASE_STATEMENT_DUMMY_PROPERTY,
	MIDORI_DATABASE_STATEMENT_STMT,
	MIDORI_DATABASE_STATEMENT_DATABASE,
	MIDORI_DATABASE_STATEMENT_QUERY
};
MidoriDatabaseStatement* midori_database_statement_new (MidoriDatabase* database, const gchar* query, GError** error);
MidoriDatabaseStatement* midori_database_statement_construct (GType object_type, MidoriDatabase* database, const gchar* query, GError** error);
gboolean midori_database_statement_init (MidoriDatabaseStatement* self, GCancellable* cancellable, GError** error);
static gboolean midori_database_statement_real_init (MidoriDatabaseStatement* self, GCancellable* cancellable, GError** error);
MidoriDatabase* midori_database_statement_get_database (MidoriDatabaseStatement* self);
sqlite3* midori_database_get_db (MidoriDatabase* self);
const gchar* midori_database_statement_get_query (MidoriDatabaseStatement* self);
void midori_database_statement_bind (MidoriDatabaseStatement* self, const gchar* pname, GError** error, ...);
sqlite3_stmt* midori_database_statement_get_stmt (MidoriDatabaseStatement* self);
gboolean midori_database_statement_exec (MidoriDatabaseStatement* self, GError** error);
gboolean midori_database_statement_step (MidoriDatabaseStatement* self, GError** error);
gint64 midori_database_statement_row_id (MidoriDatabaseStatement* self, GError** error);
static gint midori_database_statement_column_index (MidoriDatabaseStatement* self, const gchar* name, GError** error);
gchar* midori_database_statement_get_string (MidoriDatabaseStatement* self, const gchar* name, GError** error);
gint64 midori_database_statement_get_int64 (MidoriDatabaseStatement* self, const gchar* name, GError** error);
gdouble midori_database_statement_get_double (MidoriDatabaseStatement* self, const gchar* name, GError** error);
void midori_database_statement_set_database (MidoriDatabaseStatement* self, MidoriDatabase* value);
void midori_database_statement_set_query (MidoriDatabaseStatement* self, const gchar* value);
static void midori_database_statement_finalize (GObject* obj);
static void _vala_midori_database_statement_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_midori_database_statement_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define MIDORI_DATABASE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MIDORI_TYPE_DATABASE, MidoriDatabasePrivate))
enum  {
	MIDORI_DATABASE_DUMMY_PROPERTY,
	MIDORI_DATABASE_DB,
	MIDORI_DATABASE_PATH,
	MIDORI_DATABASE_FIRST_USE
};
MidoriDatabase* midori_database_new (const gchar* path, GError** error);
MidoriDatabase* midori_database_construct (GType object_type, const gchar* path, GError** error);
gboolean midori_database_init (MidoriDatabase* self, GCancellable* cancellable, GError** error);
static gchar* midori_database_resolve_path (MidoriDatabase* self, const gchar* path);
gchar* midori_paths_get_config_filename_for_writing (const gchar* filename);
static gboolean midori_database_real_init (MidoriDatabase* self, GCancellable* cancellable, GError** error);
const gchar* midori_database_get_path (MidoriDatabase* self);
gboolean midori_database_exists (MidoriDatabase* self, const gchar* path);
static void ___lambda5_ (MidoriDatabase* self, const gchar* sql, guint64 nanoseconds);
static void ____lambda5__sqlite_profile_callback (gpointer self, const gchar* sql, guint64 time);
gboolean midori_database_exec_script (MidoriDatabase* self, const gchar* filename, GError** error);
gboolean midori_database_exec (MidoriDatabase* self, const gchar* query, GError** error);
void midori_database_set_first_use (MidoriDatabase* self, gboolean value);
gboolean midori_database_attach (MidoriDatabase* self, const gchar* path, const gchar* alias, GError** error);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
gchar* midori_paths_get_res_filename (const gchar* filename);
gboolean midori_database_transaction (MidoriDatabase* self, MidoriDatabaseCallback callback, void* callback_target, GError** error);
static gboolean __lambda6_ (Block3Data* _data3_, GError** error);
static gboolean ___lambda6__midori_database_callback (gpointer self, GError** error);
MidoriDatabaseStatement* midori_database_prepare (MidoriDatabase* self, const gchar* query, GError** error, ...);
void midori_database_set_path (MidoriDatabase* self, const gchar* value);
gboolean midori_database_get_first_use (MidoriDatabase* self);
static void midori_database_finalize (GObject* obj);
static void _vala_midori_database_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_midori_database_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark midori_database_error_quark (void) {
	return g_quark_from_static_string ("midori_database_error-quark");
}


MidoriDatabaseStatement* midori_database_statement_construct (GType object_type, MidoriDatabase* database, const gchar* query, GError** error) {
	MidoriDatabaseStatement * self = NULL;
	MidoriDatabase* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 40 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (database != NULL, NULL);
#line 40 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 41 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp0_ = database;
#line 41 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp1_ = query;
#line 41 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	self = (MidoriDatabaseStatement*) g_object_new (object_type, "database", _tmp0_, "query", _tmp1_, NULL);
#line 42 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	midori_database_statement_init (self, NULL, &_inner_error_);
#line 42 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 42 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 42 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_propagate_error (error, _inner_error_);
#line 42 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_g_object_unref0 (self);
#line 42 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return NULL;
#line 215 "midori-database.c"
		} else {
#line 42 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 42 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_clear_error (&_inner_error_);
#line 42 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return NULL;
#line 223 "midori-database.c"
		}
	}
#line 40 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	return self;
#line 228 "midori-database.c"
}


MidoriDatabaseStatement* midori_database_statement_new (MidoriDatabase* database, const gchar* query, GError** error) {
#line 40 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	return midori_database_statement_construct (MIDORI_TYPE_DATABASE_STATEMENT, database, query, error);
#line 235 "midori-database.c"
}


static gboolean midori_database_statement_real_init (MidoriDatabaseStatement* self, GCancellable* cancellable, GError** error) {
	gboolean result = FALSE;
	gint _result_ = 0;
	MidoriDatabase* _tmp0_ = NULL;
	sqlite3* _tmp1_ = NULL;
	sqlite3* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	sqlite3_stmt* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	GError * _inner_error_ = NULL;
#line 46 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp0_ = self->priv->_database;
#line 46 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp1_ = midori_database_get_db (_tmp0_);
#line 46 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp2_ = _tmp1_;
#line 46 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp3_ = self->priv->_query;
#line 46 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp5_ = sqlite3_prepare_v2 (_tmp2_, _tmp3_, -1, &_tmp4_, NULL);
#line 46 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_sqlite3_finalize0 (self->_stmt);
#line 46 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	self->_stmt = _tmp4_;
#line 46 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_result_ = _tmp5_;
#line 47 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp6_ = _result_;
#line 47 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (_tmp6_ != SQLITE_OK) {
#line 270 "midori-database.c"
		MidoriDatabase* _tmp7_ = NULL;
		sqlite3* _tmp8_ = NULL;
		sqlite3* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		GError* _tmp13_ = NULL;
		GError* _tmp14_ = NULL;
#line 48 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp7_ = self->priv->_database;
#line 48 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp8_ = midori_database_get_db (_tmp7_);
#line 48 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp9_ = _tmp8_;
#line 48 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp10_ = sqlite3_errmsg (_tmp9_);
#line 48 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp11_ = g_strdup_printf ("Failed to compile statement: %s", _tmp10_);
#line 48 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp12_ = _tmp11_;
#line 48 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp13_ = g_error_new_literal (MIDORI_DATABASE_ERROR, MIDORI_DATABASE_ERROR_COMPILE, _tmp12_);
#line 48 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp14_ = _tmp13_;
#line 48 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_g_free0 (_tmp12_);
#line 48 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_inner_error_ = _tmp14_;
#line 48 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 48 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_propagate_error (error, _inner_error_);
#line 48 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return FALSE;
#line 305 "midori-database.c"
		} else {
#line 48 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 48 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_clear_error (&_inner_error_);
#line 48 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return FALSE;
#line 313 "midori-database.c"
		}
	}
#line 49 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	result = TRUE;
#line 49 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	return result;
#line 320 "midori-database.c"
}


gboolean midori_database_statement_init (MidoriDatabaseStatement* self, GCancellable* cancellable, GError** error) {
#line 45 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 45 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	return MIDORI_DATABASE_STATEMENT_GET_CLASS (self)->init (self, cancellable, error);
#line 329 "midori-database.c"
}


static gchar* double_to_string (gdouble self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 783 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
#line 783 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 783 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
#line 783 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp2_ = g_ascii_dtostr (_tmp1_, G_ASCII_DTOSTR_BUF_SIZE, self);
#line 783 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp3_ = g_strdup (_tmp2_);
#line 783 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 783 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = (g_free (_tmp1_), NULL);
#line 783 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 783 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	return result;
#line 359 "midori-database.c"
}


void midori_database_statement_bind (MidoriDatabaseStatement* self, const gchar* pname, GError** error, ...) {
	gint pindex = 0;
	sqlite3_stmt* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	va_list args = {0};
	GType ptype = 0UL;
	GType _tmp10_ = 0UL;
	GType _tmp11_ = 0UL;
	GError * _inner_error_ = NULL;
#line 58 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_if_fail (self != NULL);
#line 58 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_if_fail (pname != NULL);
#line 59 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp0_ = midori_database_statement_get_stmt (self);
#line 59 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp1_ = _tmp0_;
#line 59 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp2_ = pname;
#line 59 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp3_ = sqlite3_bind_parameter_index (_tmp1_, _tmp2_);
#line 59 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	pindex = _tmp3_;
#line 60 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (pindex <= 0) {
#line 390 "midori-database.c"
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
#line 61 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp4_ = pname;
#line 61 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp5_ = self->priv->_query;
#line 61 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp6_ = g_strdup_printf ("No such parameter '%s' in statement: %s", _tmp4_, _tmp5_);
#line 61 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp7_ = _tmp6_;
#line 61 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp8_ = g_error_new_literal (MIDORI_DATABASE_ERROR, MIDORI_DATABASE_ERROR_TYPE, _tmp7_);
#line 61 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp9_ = _tmp8_;
#line 61 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_g_free0 (_tmp7_);
#line 61 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_inner_error_ = _tmp9_;
#line 61 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 61 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_propagate_error (error, _inner_error_);
#line 61 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return;
#line 419 "midori-database.c"
		} else {
#line 61 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 61 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_clear_error (&_inner_error_);
#line 61 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return;
#line 427 "midori-database.c"
		}
	}
#line 62 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	va_start (args, error);
#line 63 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp10_ = va_arg (args, GType);
#line 63 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	ptype = _tmp10_;
#line 64 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp11_ = ptype;
#line 64 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (_tmp11_ == G_TYPE_STRING) {
#line 440 "midori-database.c"
		gchar* text = NULL;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		sqlite3_stmt* _tmp14_ = NULL;
		sqlite3_stmt* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		GDestroyNotify _tmp18_ = NULL;
		MidoriDatabase* _tmp19_ = NULL;
		gboolean _tmp20_ = FALSE;
#line 65 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp12_ = va_arg (args, gchar*);
#line 65 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp13_ = g_strdup (_tmp12_);
#line 65 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		text = _tmp13_;
#line 66 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp14_ = midori_database_statement_get_stmt (self);
#line 66 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp15_ = _tmp14_;
#line 66 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp16_ = text;
#line 66 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp17_ = g_strdup (_tmp16_);
#line 66 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp18_ = g_free;
#line 66 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		sqlite3_bind_text (_tmp15_, pindex, _tmp17_, -1, _tmp18_);
#line 67 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp19_ = self->priv->_database;
#line 67 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp20_ = _tmp19_->trace;
#line 67 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (_tmp20_) {
#line 475 "midori-database.c"
			FILE* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
#line 68 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_tmp21_ = stdout;
#line 68 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_tmp22_ = pname;
#line 68 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_tmp23_ = text;
#line 68 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			fprintf (_tmp21_, "%s=%s ", _tmp22_, _tmp23_);
#line 487 "midori-database.c"
		}
#line 64 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_g_free0 (text);
#line 491 "midori-database.c"
	} else {
		GType _tmp24_ = 0UL;
#line 69 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp24_ = ptype;
#line 69 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (_tmp24_ == G_TYPE_INT64) {
#line 498 "midori-database.c"
			gint64 integer = 0LL;
			gint64 _tmp25_ = 0LL;
			sqlite3_stmt* _tmp26_ = NULL;
			sqlite3_stmt* _tmp27_ = NULL;
			gint64 _tmp28_ = 0LL;
			MidoriDatabase* _tmp29_ = NULL;
			gboolean _tmp30_ = FALSE;
#line 70 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_tmp25_ = va_arg (args, gint64);
#line 70 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			integer = _tmp25_;
#line 71 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_tmp26_ = midori_database_statement_get_stmt (self);
#line 71 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_tmp27_ = _tmp26_;
#line 71 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_tmp28_ = integer;
#line 71 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			sqlite3_bind_int64 (_tmp27_, pindex, _tmp28_);
#line 72 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_tmp29_ = self->priv->_database;
#line 72 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_tmp30_ = _tmp29_->trace;
#line 72 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			if (_tmp30_) {
#line 524 "midori-database.c"
				FILE* _tmp31_ = NULL;
				const gchar* _tmp32_ = NULL;
				gint64 _tmp33_ = 0LL;
				gchar* _tmp34_ = NULL;
				gchar* _tmp35_ = NULL;
#line 73 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_tmp31_ = stdout;
#line 73 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_tmp32_ = pname;
#line 73 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_tmp33_ = integer;
#line 73 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_tmp34_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp33_);
#line 73 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_tmp35_ = _tmp34_;
#line 73 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				fprintf (_tmp31_, "%s=%s ", _tmp32_, _tmp35_);
#line 73 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_g_free0 (_tmp35_);
#line 544 "midori-database.c"
			}
		} else {
			GType _tmp36_ = 0UL;
#line 74 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_tmp36_ = ptype;
#line 74 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			if (_tmp36_ == G_TYPE_DOUBLE) {
#line 552 "midori-database.c"
				gdouble stuntman = 0.0;
				gdouble _tmp37_ = 0.0;
				sqlite3_stmt* _tmp38_ = NULL;
				sqlite3_stmt* _tmp39_ = NULL;
				gdouble _tmp40_ = 0.0;
				MidoriDatabase* _tmp41_ = NULL;
				gboolean _tmp42_ = FALSE;
#line 75 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_tmp37_ = va_arg (args, gdouble);
#line 75 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				stuntman = _tmp37_;
#line 76 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_tmp38_ = midori_database_statement_get_stmt (self);
#line 76 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_tmp39_ = _tmp38_;
#line 76 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_tmp40_ = stuntman;
#line 76 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				sqlite3_bind_double (_tmp39_, pindex, _tmp40_);
#line 77 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_tmp41_ = self->priv->_database;
#line 77 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_tmp42_ = _tmp41_->trace;
#line 77 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				if (_tmp42_) {
#line 578 "midori-database.c"
					FILE* _tmp43_ = NULL;
					const gchar* _tmp44_ = NULL;
					gdouble _tmp45_ = 0.0;
					gchar* _tmp46_ = NULL;
					gchar* _tmp47_ = NULL;
#line 78 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					_tmp43_ = stdout;
#line 78 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					_tmp44_ = pname;
#line 78 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					_tmp45_ = stuntman;
#line 78 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					_tmp46_ = double_to_string (_tmp45_);
#line 78 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					_tmp47_ = _tmp46_;
#line 78 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					fprintf (_tmp43_, "%s=%s ", _tmp44_, _tmp47_);
#line 78 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					_g_free0 (_tmp47_);
#line 598 "midori-database.c"
				}
			} else {
				GType _tmp48_ = 0UL;
				const gchar* _tmp49_ = NULL;
				const gchar* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				gchar* _tmp52_ = NULL;
				gchar* _tmp53_ = NULL;
				GError* _tmp54_ = NULL;
				GError* _tmp55_ = NULL;
#line 80 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_tmp48_ = ptype;
#line 80 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_tmp49_ = g_type_name (_tmp48_);
#line 80 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_tmp50_ = pname;
#line 80 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_tmp51_ = self->priv->_query;
#line 80 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_tmp52_ = g_strdup_printf ("Invalid type '%s' for '%s' in statement: %s", _tmp49_, _tmp50_, _tmp51_);
#line 80 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_tmp53_ = _tmp52_;
#line 80 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_tmp54_ = g_error_new_literal (MIDORI_DATABASE_ERROR, MIDORI_DATABASE_ERROR_TYPE, _tmp53_);
#line 80 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_tmp55_ = _tmp54_;
#line 80 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_g_free0 (_tmp53_);
#line 80 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_inner_error_ = _tmp55_;
#line 80 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 80 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					g_propagate_error (error, _inner_error_);
#line 80 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					va_end (args);
#line 80 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					return;
#line 637 "midori-database.c"
				} else {
#line 80 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					va_end (args);
#line 80 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 80 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					g_clear_error (&_inner_error_);
#line 80 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					return;
#line 647 "midori-database.c"
				}
			}
		}
	}
#line 58 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	va_end (args);
#line 654 "midori-database.c"
}


gboolean midori_database_statement_exec (MidoriDatabaseStatement* self, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
#line 86 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 87 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp1_ = midori_database_statement_step (self, &_inner_error_);
#line 87 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp0_ = _tmp1_;
#line 87 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 87 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 87 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_propagate_error (error, _inner_error_);
#line 87 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return FALSE;
#line 677 "midori-database.c"
		} else {
#line 87 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 87 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_clear_error (&_inner_error_);
#line 87 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return FALSE;
#line 685 "midori-database.c"
		}
	}
#line 87 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (_tmp0_) {
#line 690 "midori-database.c"
		GError* _tmp2_ = NULL;
#line 88 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp2_ = g_error_new_literal (MIDORI_DATABASE_ERROR, MIDORI_DATABASE_ERROR_EXECUTE, "More rows available - use step instead of exec");
#line 88 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_inner_error_ = _tmp2_;
#line 88 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 88 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_propagate_error (error, _inner_error_);
#line 88 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return FALSE;
#line 702 "midori-database.c"
		} else {
#line 88 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 88 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_clear_error (&_inner_error_);
#line 88 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return FALSE;
#line 710 "midori-database.c"
		}
	}
#line 89 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	result = TRUE;
#line 89 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	return result;
#line 717 "midori-database.c"
}


gboolean midori_database_statement_step (MidoriDatabaseStatement* self, GError** error) {
	gboolean result = FALSE;
	gint _result_ = 0;
	sqlite3_stmt* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_ = 0;
	MidoriDatabase* _tmp11_ = NULL;
	sqlite3* _tmp12_ = NULL;
	sqlite3* _tmp13_ = NULL;
	gint64 _tmp14_ = 0LL;
	gint _tmp15_ = 0;
	GError * _inner_error_ = NULL;
#line 95 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 96 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp0_ = midori_database_statement_get_stmt (self);
#line 96 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp1_ = _tmp0_;
#line 96 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp2_ = sqlite3_step (_tmp1_);
#line 96 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_result_ = _tmp2_;
#line 97 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp4_ = _result_;
#line 97 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (_tmp4_ != SQLITE_DONE) {
#line 749 "midori-database.c"
		gint _tmp5_ = 0;
#line 97 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp5_ = _result_;
#line 97 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp3_ = _tmp5_ != SQLITE_ROW;
#line 755 "midori-database.c"
	} else {
#line 97 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp3_ = FALSE;
#line 759 "midori-database.c"
	}
#line 97 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (_tmp3_) {
#line 763 "midori-database.c"
		MidoriDatabase* _tmp6_ = NULL;
		sqlite3* _tmp7_ = NULL;
		sqlite3* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		GError* _tmp10_ = NULL;
#line 98 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp6_ = self->priv->_database;
#line 98 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp7_ = midori_database_get_db (_tmp6_);
#line 98 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp8_ = _tmp7_;
#line 98 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp9_ = sqlite3_errmsg (_tmp8_);
#line 98 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp10_ = g_error_new_literal (MIDORI_DATABASE_ERROR, MIDORI_DATABASE_ERROR_EXECUTE, _tmp9_);
#line 98 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_inner_error_ = _tmp10_;
#line 98 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 98 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_propagate_error (error, _inner_error_);
#line 98 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return FALSE;
#line 787 "midori-database.c"
		} else {
#line 98 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 98 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_clear_error (&_inner_error_);
#line 98 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return FALSE;
#line 795 "midori-database.c"
		}
	}
#line 99 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp11_ = self->priv->_database;
#line 99 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp12_ = midori_database_get_db (_tmp11_);
#line 99 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp13_ = _tmp12_;
#line 99 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp14_ = sqlite3_last_insert_rowid (_tmp13_);
#line 99 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	self->priv->last_row_id = _tmp14_;
#line 100 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp15_ = _result_;
#line 100 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	result = _tmp15_ == SQLITE_ROW;
#line 100 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	return result;
#line 814 "midori-database.c"
}


gint64 midori_database_statement_row_id (MidoriDatabaseStatement* self, GError** error) {
	gint64 result = 0LL;
	gint64 _tmp0_ = 0LL;
	gint64 _tmp2_ = 0LL;
	GError * _inner_error_ = NULL;
#line 108 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 109 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp0_ = self->priv->last_row_id;
#line 109 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (_tmp0_ == ((gint64) -1)) {
#line 829 "midori-database.c"
		GError* _tmp1_ = NULL;
#line 110 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp1_ = g_error_new_literal (MIDORI_DATABASE_ERROR, MIDORI_DATABASE_ERROR_EXECUTE, "No row id");
#line 110 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_inner_error_ = _tmp1_;
#line 110 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 110 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_propagate_error (error, _inner_error_);
#line 110 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return 0LL;
#line 841 "midori-database.c"
		} else {
#line 110 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 110 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_clear_error (&_inner_error_);
#line 110 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return 0LL;
#line 849 "midori-database.c"
		}
	}
#line 111 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp2_ = self->priv->last_row_id;
#line 111 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	result = _tmp2_;
#line 111 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	return result;
#line 858 "midori-database.c"
}


static gint midori_database_statement_column_index (MidoriDatabaseStatement* self, const gchar* name, GError** error) {
	gint result = 0;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	GError* _tmp15_ = NULL;
	GError* _tmp16_ = NULL;
	GError * _inner_error_ = NULL;
#line 114 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 114 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (name != NULL, 0);
#line 875 "midori-database.c"
	{
		gint i = 0;
#line 115 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		i = 0;
#line 880 "midori-database.c"
		{
			gboolean _tmp0_ = FALSE;
#line 115 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_tmp0_ = TRUE;
#line 115 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			while (TRUE) {
#line 887 "midori-database.c"
				gint _tmp2_ = 0;
				sqlite3_stmt* _tmp3_ = NULL;
				sqlite3_stmt* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				const gchar* _tmp6_ = NULL;
				sqlite3_stmt* _tmp7_ = NULL;
				sqlite3_stmt* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				const gchar* _tmp10_ = NULL;
#line 115 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				if (!_tmp0_) {
#line 899 "midori-database.c"
					gint _tmp1_ = 0;
#line 115 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					_tmp1_ = i;
#line 115 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					i = _tmp1_ + 1;
#line 905 "midori-database.c"
				}
#line 115 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_tmp0_ = FALSE;
#line 115 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_tmp2_ = i;
#line 115 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_tmp3_ = midori_database_statement_get_stmt (self);
#line 115 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_tmp4_ = _tmp3_;
#line 115 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_tmp5_ = sqlite3_column_count (_tmp4_);
#line 115 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				if (!(_tmp2_ < _tmp5_)) {
#line 115 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					break;
#line 921 "midori-database.c"
				}
#line 116 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_tmp6_ = name;
#line 116 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_tmp7_ = midori_database_statement_get_stmt (self);
#line 116 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_tmp8_ = _tmp7_;
#line 116 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_tmp9_ = i;
#line 116 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_tmp10_ = sqlite3_column_name (_tmp8_, _tmp9_);
#line 116 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				if (g_strcmp0 (_tmp6_, _tmp10_) == 0) {
#line 117 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					result = i;
#line 117 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					return result;
#line 939 "midori-database.c"
				}
			}
		}
	}
#line 119 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp11_ = name;
#line 119 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp12_ = self->priv->_query;
#line 119 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp13_ = g_strdup_printf ("No such column '%s' in row: %s", _tmp11_, _tmp12_);
#line 119 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp14_ = _tmp13_;
#line 119 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp15_ = g_error_new_literal (MIDORI_DATABASE_ERROR, MIDORI_DATABASE_ERROR_TYPE, _tmp14_);
#line 119 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp16_ = _tmp15_;
#line 119 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_g_free0 (_tmp14_);
#line 119 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_inner_error_ = _tmp16_;
#line 119 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 119 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		g_propagate_error (error, _inner_error_);
#line 119 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		return 0;
#line 966 "midori-database.c"
	} else {
#line 119 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 119 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		g_clear_error (&_inner_error_);
#line 119 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		return 0;
#line 974 "midori-database.c"
	}
}


gchar* midori_database_statement_get_string (MidoriDatabaseStatement* self, const gchar* name, GError** error) {
	gchar* result = NULL;
	gint index = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint type = 0;
	sqlite3_stmt* _tmp2_ = NULL;
	sqlite3_stmt* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	sqlite3_stmt* _tmp7_ = NULL;
	sqlite3_stmt* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	sqlite3_stmt* _tmp18_ = NULL;
	sqlite3_stmt* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	const gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	GError * _inner_error_ = NULL;
#line 126 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 126 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 127 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp0_ = name;
#line 127 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp1_ = midori_database_statement_column_index (self, _tmp0_, &_inner_error_);
#line 127 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	index = _tmp1_;
#line 127 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 127 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 127 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_propagate_error (error, _inner_error_);
#line 127 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return NULL;
#line 1018 "midori-database.c"
		} else {
#line 127 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 127 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_clear_error (&_inner_error_);
#line 127 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return NULL;
#line 1026 "midori-database.c"
		}
	}
#line 128 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp2_ = midori_database_statement_get_stmt (self);
#line 128 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp3_ = _tmp2_;
#line 128 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp4_ = index;
#line 128 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp5_ = sqlite3_column_type (_tmp3_, _tmp4_);
#line 128 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	type = _tmp5_;
#line 129 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp7_ = midori_database_statement_get_stmt (self);
#line 129 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp8_ = _tmp7_;
#line 129 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp9_ = index;
#line 129 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp10_ = sqlite3_column_type (_tmp8_, _tmp9_);
#line 129 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (_tmp10_ != SQLITE3_TEXT) {
#line 1049 "midori-database.c"
		gint _tmp11_ = 0;
#line 129 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp11_ = type;
#line 129 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp6_ = _tmp11_ != SQLITE_NULL;
#line 1055 "midori-database.c"
	} else {
#line 129 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp6_ = FALSE;
#line 1059 "midori-database.c"
	}
#line 129 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (_tmp6_) {
#line 1063 "midori-database.c"
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		GError* _tmp16_ = NULL;
		GError* _tmp17_ = NULL;
#line 130 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp12_ = name;
#line 130 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp13_ = self->priv->_query;
#line 130 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp14_ = g_strdup_printf ("Getting '%s' with wrong type in row: %s", _tmp12_, _tmp13_);
#line 130 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp15_ = _tmp14_;
#line 130 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp16_ = g_error_new_literal (MIDORI_DATABASE_ERROR, MIDORI_DATABASE_ERROR_TYPE, _tmp15_);
#line 130 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp17_ = _tmp16_;
#line 130 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_g_free0 (_tmp15_);
#line 130 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_inner_error_ = _tmp17_;
#line 130 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 130 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_propagate_error (error, _inner_error_);
#line 130 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return NULL;
#line 1092 "midori-database.c"
		} else {
#line 130 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 130 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_clear_error (&_inner_error_);
#line 130 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return NULL;
#line 1100 "midori-database.c"
		}
	}
#line 131 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp18_ = midori_database_statement_get_stmt (self);
#line 131 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp19_ = _tmp18_;
#line 131 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp20_ = index;
#line 131 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp21_ = sqlite3_column_text (_tmp19_, _tmp20_);
#line 131 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp22_ = g_strdup (_tmp21_);
#line 131 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	result = _tmp22_;
#line 131 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	return result;
#line 1117 "midori-database.c"
}


gint64 midori_database_statement_get_int64 (MidoriDatabaseStatement* self, const gchar* name, GError** error) {
	gint64 result = 0LL;
	gint index = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint type = 0;
	sqlite3_stmt* _tmp2_ = NULL;
	sqlite3_stmt* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	gint _tmp7_ = 0;
	sqlite3_stmt* _tmp20_ = NULL;
	sqlite3_stmt* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint64 _tmp23_ = 0LL;
	GError * _inner_error_ = NULL;
#line 138 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (self != NULL, 0LL);
#line 138 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (name != NULL, 0LL);
#line 139 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp0_ = name;
#line 139 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp1_ = midori_database_statement_column_index (self, _tmp0_, &_inner_error_);
#line 139 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	index = _tmp1_;
#line 139 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 139 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 139 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_propagate_error (error, _inner_error_);
#line 139 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return 0LL;
#line 1156 "midori-database.c"
		} else {
#line 139 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 139 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_clear_error (&_inner_error_);
#line 139 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return 0LL;
#line 1164 "midori-database.c"
		}
	}
#line 140 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp2_ = midori_database_statement_get_stmt (self);
#line 140 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp3_ = _tmp2_;
#line 140 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp4_ = index;
#line 140 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp5_ = sqlite3_column_type (_tmp3_, _tmp4_);
#line 140 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	type = _tmp5_;
#line 141 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp7_ = type;
#line 141 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (_tmp7_ != SQLITE_INTEGER) {
#line 1181 "midori-database.c"
		gint _tmp8_ = 0;
#line 141 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp8_ = type;
#line 141 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp6_ = _tmp8_ != SQLITE_NULL;
#line 1187 "midori-database.c"
	} else {
#line 141 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp6_ = FALSE;
#line 1191 "midori-database.c"
	}
#line 141 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (_tmp6_) {
#line 1195 "midori-database.c"
		const gchar* _tmp9_ = NULL;
		sqlite3_stmt* _tmp10_ = NULL;
		sqlite3_stmt* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		const gchar* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		GError* _tmp18_ = NULL;
		GError* _tmp19_ = NULL;
#line 142 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp9_ = name;
#line 142 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp10_ = midori_database_statement_get_stmt (self);
#line 142 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp11_ = _tmp10_;
#line 142 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp12_ = index;
#line 142 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp13_ = sqlite3_column_text (_tmp11_, _tmp12_);
#line 142 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp14_ = type;
#line 142 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp15_ = self->priv->_query;
#line 142 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp16_ = g_strdup_printf ("Getting '%s' with value '%s' of wrong type %d in row: %s", _tmp9_, _tmp13_, _tmp14_, _tmp15_);
#line 142 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp17_ = _tmp16_;
#line 142 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp18_ = g_error_new_literal (MIDORI_DATABASE_ERROR, MIDORI_DATABASE_ERROR_TYPE, _tmp17_);
#line 142 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp19_ = _tmp18_;
#line 142 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_g_free0 (_tmp17_);
#line 142 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_inner_error_ = _tmp19_;
#line 142 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 142 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_propagate_error (error, _inner_error_);
#line 142 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return 0LL;
#line 1239 "midori-database.c"
		} else {
#line 142 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 142 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_clear_error (&_inner_error_);
#line 142 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return 0LL;
#line 1247 "midori-database.c"
		}
	}
#line 144 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp20_ = midori_database_statement_get_stmt (self);
#line 144 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp21_ = _tmp20_;
#line 144 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp22_ = index;
#line 144 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp23_ = sqlite3_column_int64 (_tmp21_, _tmp22_);
#line 144 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	result = _tmp23_;
#line 144 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	return result;
#line 1262 "midori-database.c"
}


gdouble midori_database_statement_get_double (MidoriDatabaseStatement* self, const gchar* name, GError** error) {
	gdouble result = 0.0;
	gint index = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint type = 0;
	sqlite3_stmt* _tmp2_ = NULL;
	sqlite3_stmt* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	gint _tmp7_ = 0;
	gdouble _tmp15_ = 0.0;
	gint _tmp16_ = 0;
	GError * _inner_error_ = NULL;
#line 151 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 151 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (name != NULL, 0.0);
#line 152 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp0_ = name;
#line 152 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp1_ = midori_database_statement_column_index (self, _tmp0_, &_inner_error_);
#line 152 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	index = _tmp1_;
#line 152 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 152 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 152 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_propagate_error (error, _inner_error_);
#line 152 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return 0.0;
#line 1299 "midori-database.c"
		} else {
#line 152 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 152 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_clear_error (&_inner_error_);
#line 152 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return 0.0;
#line 1307 "midori-database.c"
		}
	}
#line 153 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp2_ = midori_database_statement_get_stmt (self);
#line 153 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp3_ = _tmp2_;
#line 153 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp4_ = index;
#line 153 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp5_ = sqlite3_column_type (_tmp3_, _tmp4_);
#line 153 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	type = _tmp5_;
#line 154 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp7_ = type;
#line 154 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (_tmp7_ != SQLITE_FLOAT) {
#line 1324 "midori-database.c"
		gint _tmp8_ = 0;
#line 154 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp8_ = type;
#line 154 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp6_ = _tmp8_ != SQLITE_NULL;
#line 1330 "midori-database.c"
	} else {
#line 154 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp6_ = FALSE;
#line 1334 "midori-database.c"
	}
#line 154 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (_tmp6_) {
#line 1338 "midori-database.c"
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		GError* _tmp13_ = NULL;
		GError* _tmp14_ = NULL;
#line 155 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp9_ = name;
#line 155 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp10_ = self->priv->_query;
#line 155 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp11_ = g_strdup_printf ("Getting '%s' with wrong type in row: %s", _tmp9_, _tmp10_);
#line 155 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp12_ = _tmp11_;
#line 155 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp13_ = g_error_new_literal (MIDORI_DATABASE_ERROR, MIDORI_DATABASE_ERROR_TYPE, _tmp12_);
#line 155 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp14_ = _tmp13_;
#line 155 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_g_free0 (_tmp12_);
#line 155 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_inner_error_ = _tmp14_;
#line 155 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 155 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_propagate_error (error, _inner_error_);
#line 155 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return 0.0;
#line 1367 "midori-database.c"
		} else {
#line 155 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 155 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_clear_error (&_inner_error_);
#line 155 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return 0.0;
#line 1375 "midori-database.c"
		}
	}
#line 156 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp16_ = type;
#line 156 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (_tmp16_ == SQLITE_NULL) {
#line 156 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp15_ = ((double) NAN);
#line 1384 "midori-database.c"
	} else {
		sqlite3_stmt* _tmp17_ = NULL;
		sqlite3_stmt* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		gdouble _tmp20_ = 0.0;
#line 156 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp17_ = midori_database_statement_get_stmt (self);
#line 156 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp18_ = _tmp17_;
#line 156 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp19_ = index;
#line 156 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp20_ = sqlite3_column_double (_tmp18_, _tmp19_);
#line 156 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp15_ = _tmp20_;
#line 1400 "midori-database.c"
	}
#line 156 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	result = _tmp15_;
#line 156 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	return result;
#line 1406 "midori-database.c"
}


sqlite3_stmt* midori_database_statement_get_stmt (MidoriDatabaseStatement* self) {
	sqlite3_stmt* result;
	sqlite3_stmt* _tmp0_ = NULL;
#line 34 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 34 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp0_ = self->_stmt;
#line 34 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	result = _tmp0_;
#line 34 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	return result;
#line 1421 "midori-database.c"
}


MidoriDatabase* midori_database_statement_get_database (MidoriDatabaseStatement* self) {
	MidoriDatabase* result;
	MidoriDatabase* _tmp0_ = NULL;
#line 36 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 36 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp0_ = self->priv->_database;
#line 36 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	result = _tmp0_;
#line 36 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	return result;
#line 1436 "midori-database.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 36 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	return self ? g_object_ref (self) : NULL;
#line 1443 "midori-database.c"
}


void midori_database_statement_set_database (MidoriDatabaseStatement* self, MidoriDatabase* value) {
	MidoriDatabase* _tmp0_ = NULL;
	MidoriDatabase* _tmp1_ = NULL;
#line 36 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_if_fail (self != NULL);
#line 36 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp0_ = value;
#line 36 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 36 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_g_object_unref0 (self->priv->_database);
#line 36 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	self->priv->_database = _tmp1_;
#line 36 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_object_notify ((GObject *) self, "database");
#line 1462 "midori-database.c"
}


const gchar* midori_database_statement_get_query (MidoriDatabaseStatement* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 37 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 37 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp0_ = self->priv->_query;
#line 37 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	result = _tmp0_;
#line 37 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	return result;
#line 1477 "midori-database.c"
}


void midori_database_statement_set_query (MidoriDatabaseStatement* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 37 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_if_fail (self != NULL);
#line 37 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp0_ = value;
#line 37 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 37 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_g_free0 (self->priv->_query);
#line 37 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	self->priv->_query = _tmp1_;
#line 37 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_object_notify ((GObject *) self, "query");
#line 1496 "midori-database.c"
}


static void midori_database_statement_class_init (MidoriDatabaseStatementClass * klass) {
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	midori_database_statement_parent_class = g_type_class_peek_parent (klass);
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_type_class_add_private (klass, sizeof (MidoriDatabaseStatementPrivate));
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	((MidoriDatabaseStatementClass *) klass)->init = midori_database_statement_real_init;
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_midori_database_statement_get_property;
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_midori_database_statement_set_property;
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	G_OBJECT_CLASS (klass)->finalize = midori_database_statement_finalize;
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_DATABASE_STATEMENT_STMT, g_param_spec_pointer ("stmt", "stmt", "stmt", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_DATABASE_STATEMENT_DATABASE, g_param_spec_object ("database", "database", "database", MIDORI_TYPE_DATABASE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_DATABASE_STATEMENT_QUERY, g_param_spec_string ("query", "query", "query", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
#line 1519 "midori-database.c"
}


static void midori_database_statement_g_initable_interface_init (GInitableIface * iface) {
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	midori_database_statement_g_initable_parent_iface = g_type_interface_peek_parent (iface);
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	iface->init = (gboolean (*)(GInitable*, GCancellable*, GError**)) midori_database_statement_init;
#line 1528 "midori-database.c"
}


static void midori_database_statement_instance_init (MidoriDatabaseStatement * self) {
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	self->priv = MIDORI_DATABASE_STATEMENT_GET_PRIVATE (self);
#line 35 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	self->_stmt = NULL;
#line 38 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	self->priv->last_row_id = (gint64) -1;
#line 1539 "midori-database.c"
}


static void midori_database_statement_finalize (GObject* obj) {
	MidoriDatabaseStatement * self;
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MIDORI_TYPE_DATABASE_STATEMENT, MidoriDatabaseStatement);
#line 35 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_sqlite3_finalize0 (self->_stmt);
#line 36 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_g_object_unref0 (self->priv->_database);
#line 37 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_g_free0 (self->priv->_query);
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	G_OBJECT_CLASS (midori_database_statement_parent_class)->finalize (obj);
#line 1555 "midori-database.c"
}


GType midori_database_statement_get_type (void) {
	static volatile gsize midori_database_statement_type_id__volatile = 0;
	if (g_once_init_enter (&midori_database_statement_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MidoriDatabaseStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) midori_database_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MidoriDatabaseStatement), 0, (GInstanceInitFunc) midori_database_statement_instance_init, NULL };
		static const GInterfaceInfo g_initable_info = { (GInterfaceInitFunc) midori_database_statement_g_initable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType midori_database_statement_type_id;
		midori_database_statement_type_id = g_type_register_static (G_TYPE_OBJECT, "MidoriDatabaseStatement", &g_define_type_info, 0);
		g_type_add_interface_static (midori_database_statement_type_id, G_TYPE_INITABLE, &g_initable_info);
		g_once_init_leave (&midori_database_statement_type_id__volatile, midori_database_statement_type_id);
	}
	return midori_database_statement_type_id__volatile;
}


static void _vala_midori_database_statement_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MidoriDatabaseStatement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MIDORI_TYPE_DATABASE_STATEMENT, MidoriDatabaseStatement);
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	switch (property_id) {
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		case MIDORI_DATABASE_STATEMENT_STMT:
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		g_value_set_pointer (value, midori_database_statement_get_stmt (self));
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		break;
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		case MIDORI_DATABASE_STATEMENT_DATABASE:
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		g_value_set_object (value, midori_database_statement_get_database (self));
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		break;
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		case MIDORI_DATABASE_STATEMENT_QUERY:
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		g_value_set_string (value, midori_database_statement_get_query (self));
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		break;
#line 1596 "midori-database.c"
		default:
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		break;
#line 1602 "midori-database.c"
	}
}


static void _vala_midori_database_statement_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MidoriDatabaseStatement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MIDORI_TYPE_DATABASE_STATEMENT, MidoriDatabaseStatement);
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	switch (property_id) {
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		case MIDORI_DATABASE_STATEMENT_DATABASE:
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		midori_database_statement_set_database (self, g_value_get_object (value));
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		break;
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		case MIDORI_DATABASE_STATEMENT_QUERY:
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		midori_database_statement_set_query (self, g_value_get_string (value));
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		break;
#line 1624 "midori-database.c"
		default:
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		break;
#line 1630 "midori-database.c"
	}
}


MidoriDatabase* midori_database_construct (GType object_type, const gchar* path, GError** error) {
	MidoriDatabase * self = NULL;
	const gchar* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
#line 179 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 180 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp0_ = path;
#line 180 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	self = (MidoriDatabase*) g_object_new (object_type, "path", _tmp0_, NULL);
#line 181 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	midori_database_init (self, NULL, &_inner_error_);
#line 181 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 181 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 181 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_propagate_error (error, _inner_error_);
#line 181 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_g_object_unref0 (self);
#line 181 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return NULL;
#line 1657 "midori-database.c"
		} else {
#line 181 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 181 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_clear_error (&_inner_error_);
#line 181 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return NULL;
#line 1665 "midori-database.c"
		}
	}
#line 179 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	return self;
#line 1670 "midori-database.c"
}


MidoriDatabase* midori_database_new (const gchar* path, GError** error) {
#line 179 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	return midori_database_construct (MIDORI_TYPE_DATABASE, path, error);
#line 1677 "midori-database.c"
}


static gchar* midori_database_resolve_path (MidoriDatabase* self, const gchar* path) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
#line 184 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 184 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 185 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp0_ = path;
#line 185 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp1_ = g_str_has_prefix (_tmp0_, ":memory:");
#line 185 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (_tmp1_) {
#line 1697 "midori-database.c"
		gchar* _tmp2_ = NULL;
#line 186 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp2_ = g_strdup (":memory:");
#line 186 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		result = _tmp2_;
#line 186 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		return result;
#line 1705 "midori-database.c"
	} else {
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
#line 187 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp3_ = path;
#line 187 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp4_ = g_path_is_absolute (_tmp3_);
#line 187 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (!_tmp4_) {
#line 1715 "midori-database.c"
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
#line 188 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_tmp5_ = path;
#line 188 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_tmp6_ = midori_paths_get_config_filename_for_writing (_tmp5_);
#line 188 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			result = _tmp6_;
#line 188 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return result;
#line 1726 "midori-database.c"
		}
	}
#line 189 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp7_ = path;
#line 189 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp8_ = g_strdup (_tmp7_);
#line 189 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	result = _tmp8_;
#line 189 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	return result;
#line 1737 "midori-database.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1278 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1278 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1279 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1279 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1279 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1279 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	return result;
#line 1757 "midori-database.c"
}


static void ___lambda5_ (MidoriDatabase* self, const gchar* sql, guint64 nanoseconds) {
	gchar* milliseconds = NULL;
	guint64 _tmp0_ = 0ULL;
	gchar* _tmp1_ = NULL;
	FILE* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
#line 205 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_if_fail (sql != NULL);
#line 207 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp0_ = nanoseconds;
#line 207 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp1_ = g_strdup_printf ("%" G_GUINT64_FORMAT, _tmp0_ / 1000000);
#line 207 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	milliseconds = _tmp1_;
#line 208 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp2_ = stdout;
#line 208 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp3_ = self->priv->_path;
#line 208 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp4_ = sql;
#line 208 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	fprintf (_tmp2_, "§§ %s: %s (%sms)\n", _tmp3_, _tmp4_, milliseconds);
#line 205 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_g_free0 (milliseconds);
#line 1786 "midori-database.c"
}


static void ____lambda5__sqlite_profile_callback (gpointer self, const gchar* sql, guint64 time) {
#line 205 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	___lambda5_ ((MidoriDatabase*) self, sql, time);
#line 1793 "midori-database.c"
}


static gint _sqlite3_exec (sqlite3* self, const gchar* sql, sqlite3_callback callback, void* callback_target, gchar** errmsg) {
	gchar* _vala_errmsg = NULL;
	gint result = 0;
	const gchar* sqlite_errmsg = NULL;
	gint ec = 0;
	const gchar* _tmp0_ = NULL;
	sqlite3_callback _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	const gchar* _tmp6_ = NULL;
#line 34 "/usr/share/vala-0.30/vapi/sqlite3.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 34 "/usr/share/vala-0.30/vapi/sqlite3.vapi"
	g_return_val_if_fail (sql != NULL, 0);
#line 36 "/usr/share/vala-0.30/vapi/sqlite3.vapi"
	_tmp0_ = sql;
#line 36 "/usr/share/vala-0.30/vapi/sqlite3.vapi"
	_tmp1_ = callback;
#line 36 "/usr/share/vala-0.30/vapi/sqlite3.vapi"
	_tmp1__target = callback_target;
#line 36 "/usr/share/vala-0.30/vapi/sqlite3.vapi"
	_tmp3_ = sqlite3_exec (self, _tmp0_, _tmp1_, _tmp1__target, (char**) (&_tmp2_));
#line 36 "/usr/share/vala-0.30/vapi/sqlite3.vapi"
	sqlite_errmsg = _tmp2_;
#line 36 "/usr/share/vala-0.30/vapi/sqlite3.vapi"
	ec = _tmp3_;
#line 37 "/usr/share/vala-0.30/vapi/sqlite3.vapi"
	if ((&_vala_errmsg) != NULL) {
#line 1826 "midori-database.c"
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 38 "/usr/share/vala-0.30/vapi/sqlite3.vapi"
		_tmp4_ = sqlite_errmsg;
#line 38 "/usr/share/vala-0.30/vapi/sqlite3.vapi"
		_tmp5_ = g_strdup (_tmp4_);
#line 38 "/usr/share/vala-0.30/vapi/sqlite3.vapi"
		_g_free0 (_vala_errmsg);
#line 38 "/usr/share/vala-0.30/vapi/sqlite3.vapi"
		_vala_errmsg = _tmp5_;
#line 1837 "midori-database.c"
	}
#line 40 "/usr/share/vala-0.30/vapi/sqlite3.vapi"
	_tmp6_ = sqlite_errmsg;
#line 40 "/usr/share/vala-0.30/vapi/sqlite3.vapi"
	sqlite3_free ((void*) _tmp6_);
#line 41 "/usr/share/vala-0.30/vapi/sqlite3.vapi"
	result = ec;
#line 41 "/usr/share/vala-0.30/vapi/sqlite3.vapi"
	if (errmsg) {
#line 41 "/usr/share/vala-0.30/vapi/sqlite3.vapi"
		*errmsg = _vala_errmsg;
#line 1849 "midori-database.c"
	} else {
#line 41 "/usr/share/vala-0.30/vapi/sqlite3.vapi"
		_g_free0 (_vala_errmsg);
#line 1853 "midori-database.c"
	}
#line 41 "/usr/share/vala-0.30/vapi/sqlite3.vapi"
	return result;
#line 1857 "midori-database.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 239 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	return self ? g_error_copy (self) : NULL;
#line 1864 "midori-database.c"
}


static gboolean midori_database_real_init (MidoriDatabase* self, GCancellable* cancellable, GError** error) {
	gboolean result = FALSE;
	gchar* real_path = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean exists = FALSE;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_ = NULL;
	sqlite3* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* token = NULL;
	gchar* _tmp14_ = NULL;
	gchar* basename = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar** parts = NULL;
	const gchar* _tmp17_ = NULL;
	gchar** _tmp18_ = NULL;
	gchar** _tmp19_ = NULL;
	gint parts_length1 = 0;
	gint _parts_size_ = 0;
	const gchar* _tmp20_ = NULL;
	gchar** _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	const gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	sqlite3* _tmp31_ = NULL;
	sqlite3* _tmp32_ = NULL;
	gint _tmp33_ = 0;
	sqlite3* _tmp36_ = NULL;
	sqlite3* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	gint64 user_version = 0LL;
	sqlite3_stmt* stmt = NULL;
	sqlite3* _tmp39_ = NULL;
	sqlite3* _tmp40_ = NULL;
	sqlite3_stmt* _tmp41_ = NULL;
	gint _tmp42_ = 0;
	sqlite3_stmt* _tmp50_ = NULL;
	gint _tmp51_ = 0;
	sqlite3_stmt* _tmp59_ = NULL;
	gint64 _tmp60_ = 0LL;
	gint64 _tmp61_ = 0LL;
	gboolean _tmp81_ = FALSE;
	GError * _inner_error_ = NULL;
#line 193 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp0_ = self->priv->_path;
#line 193 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp1_ = midori_database_resolve_path (self, _tmp0_);
#line 193 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	real_path = _tmp1_;
#line 194 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp2_ = real_path;
#line 194 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp3_ = midori_database_exists (self, _tmp2_);
#line 194 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	exists = _tmp3_;
#line 196 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp4_ = real_path;
#line 196 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp6_ = sqlite3_open_v2 (_tmp4_, &_tmp5_, SQLITE_OPEN_READWRITE | SQLITE_OPEN_CREATE, NULL);
#line 196 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_sqlite3_close0 (self->_db);
#line 196 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	self->_db = _tmp5_;
#line 196 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (_tmp6_ != SQLITE_OK) {
#line 1941 "midori-database.c"
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		GError* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
#line 197 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp7_ = real_path;
#line 197 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp8_ = g_strdup_printf ("Failed to open database %s", _tmp7_);
#line 197 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp9_ = _tmp8_;
#line 197 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp10_ = g_error_new_literal (MIDORI_DATABASE_ERROR, MIDORI_DATABASE_ERROR_OPEN, _tmp9_);
#line 197 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp11_ = _tmp10_;
#line 197 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_g_free0 (_tmp9_);
#line 197 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_inner_error_ = _tmp11_;
#line 197 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 197 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_propagate_error (error, _inner_error_);
#line 197 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_g_free0 (real_path);
#line 197 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return FALSE;
#line 1969 "midori-database.c"
		} else {
#line 197 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_g_free0 (real_path);
#line 197 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 197 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_clear_error (&_inner_error_);
#line 197 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return FALSE;
#line 1979 "midori-database.c"
		}
	}
#line 199 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp13_ = g_getenv ("MIDORI_DEBUG");
#line 199 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp12_ = _tmp13_;
#line 199 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (_tmp12_ == NULL) {
#line 199 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp12_ = "";
#line 1990 "midori-database.c"
	}
#line 199 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp14_ = g_strdup (_tmp12_);
#line 199 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	token = _tmp14_;
#line 200 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp15_ = self->priv->_path;
#line 200 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp16_ = g_path_get_basename (_tmp15_);
#line 200 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	basename = _tmp16_;
#line 201 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp17_ = basename;
#line 201 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp19_ = _tmp18_ = g_strsplit (_tmp17_, ".", 0);
#line 201 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	parts = _tmp19_;
#line 201 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	parts_length1 = _vala_array_length (_tmp18_);
#line 201 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_parts_size_ = parts_length1;
#line 202 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp20_ = token;
#line 202 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp21_ = parts;
#line 202 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp21__length1 = parts_length1;
#line 202 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp22_ = _tmp21_[0];
#line 202 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp23_ = g_strconcat ("db:", _tmp22_, NULL);
#line 202 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp24_ = _tmp23_;
#line 202 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp25_ = string_contains (_tmp20_, _tmp24_);
#line 202 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	self->trace = _tmp25_;
#line 202 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_g_free0 (_tmp24_);
#line 203 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp26_ = self->trace;
#line 203 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (_tmp26_) {
#line 2034 "midori-database.c"
		FILE* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		sqlite3* _tmp29_ = NULL;
		sqlite3* _tmp30_ = NULL;
#line 204 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp27_ = stdout;
#line 204 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp28_ = self->priv->_path;
#line 204 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		fprintf (_tmp27_, "§§ Tracing %s\n", _tmp28_);
#line 205 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp29_ = midori_database_get_db (self);
#line 205 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp30_ = _tmp29_;
#line 205 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		sqlite3_profile (_tmp30_, ____lambda5__sqlite_profile_callback, self);
#line 2051 "midori-database.c"
	}
#line 212 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp31_ = midori_database_get_db (self);
#line 212 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp32_ = _tmp31_;
#line 212 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp33_ = _sqlite3_exec (_tmp32_, "PRAGMA journal_mode = WAL; PRAGMA cache_size = 32100;", NULL, NULL, NULL);
#line 212 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (_tmp33_ != SQLITE_OK) {
#line 2061 "midori-database.c"
		sqlite3* _tmp34_ = NULL;
		sqlite3* _tmp35_ = NULL;
#line 213 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp34_ = midori_database_get_db (self);
#line 213 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp35_ = _tmp34_;
#line 213 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_sqlite3_exec (_tmp35_, "PRAGMA synchronous = NORMAL; PRAGMA temp_store = MEMORY;", NULL, NULL, NULL);
#line 2070 "midori-database.c"
	}
#line 214 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp36_ = midori_database_get_db (self);
#line 214 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp37_ = _tmp36_;
#line 214 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_sqlite3_exec (_tmp37_, "PRAGMA count_changes = OFF;", NULL, NULL, NULL);
#line 216 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp38_ = real_path;
#line 216 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (g_strcmp0 (_tmp38_, ":memory:") == 0) {
#line 217 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		result = TRUE;
#line 217 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 217 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_g_free0 (basename);
#line 217 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_g_free0 (token);
#line 217 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_g_free0 (real_path);
#line 217 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		return result;
#line 2094 "midori-database.c"
	}
#line 221 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp39_ = midori_database_get_db (self);
#line 221 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp40_ = _tmp39_;
#line 221 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp42_ = sqlite3_prepare_v2 (_tmp40_, "PRAGMA user_version;", -1, &_tmp41_, NULL);
#line 221 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_sqlite3_finalize0 (stmt);
#line 221 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	stmt = _tmp41_;
#line 221 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (_tmp42_ != SQLITE_OK) {
#line 2108 "midori-database.c"
		sqlite3* _tmp43_ = NULL;
		sqlite3* _tmp44_ = NULL;
		const gchar* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		gchar* _tmp47_ = NULL;
		GError* _tmp48_ = NULL;
		GError* _tmp49_ = NULL;
#line 222 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp43_ = midori_database_get_db (self);
#line 222 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp44_ = _tmp43_;
#line 222 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp45_ = sqlite3_errmsg (_tmp44_);
#line 222 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp46_ = g_strdup_printf ("Failed to compile statement %s", _tmp45_);
#line 222 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp47_ = _tmp46_;
#line 222 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp48_ = g_error_new_literal (MIDORI_DATABASE_ERROR, MIDORI_DATABASE_ERROR_EXECUTE, _tmp47_);
#line 222 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp49_ = _tmp48_;
#line 222 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_g_free0 (_tmp47_);
#line 222 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_inner_error_ = _tmp49_;
#line 222 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 222 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_propagate_error (error, _inner_error_);
#line 222 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_sqlite3_finalize0 (stmt);
#line 222 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 222 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_g_free0 (basename);
#line 222 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_g_free0 (token);
#line 222 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_g_free0 (real_path);
#line 222 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return FALSE;
#line 2150 "midori-database.c"
		} else {
#line 222 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_sqlite3_finalize0 (stmt);
#line 222 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 222 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_g_free0 (basename);
#line 222 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_g_free0 (token);
#line 222 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_g_free0 (real_path);
#line 222 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 222 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_clear_error (&_inner_error_);
#line 222 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return FALSE;
#line 2168 "midori-database.c"
		}
	}
#line 223 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp50_ = stmt;
#line 223 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp51_ = sqlite3_step (_tmp50_);
#line 223 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (_tmp51_ != SQLITE_ROW) {
#line 2177 "midori-database.c"
		sqlite3* _tmp52_ = NULL;
		sqlite3* _tmp53_ = NULL;
		const gchar* _tmp54_ = NULL;
		gchar* _tmp55_ = NULL;
		gchar* _tmp56_ = NULL;
		GError* _tmp57_ = NULL;
		GError* _tmp58_ = NULL;
#line 224 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp52_ = midori_database_get_db (self);
#line 224 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp53_ = _tmp52_;
#line 224 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp54_ = sqlite3_errmsg (_tmp53_);
#line 224 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp55_ = g_strdup_printf ("Failed to get row %s", _tmp54_);
#line 224 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp56_ = _tmp55_;
#line 224 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp57_ = g_error_new_literal (MIDORI_DATABASE_ERROR, MIDORI_DATABASE_ERROR_EXECUTE, _tmp56_);
#line 224 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp58_ = _tmp57_;
#line 224 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_g_free0 (_tmp56_);
#line 224 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_inner_error_ = _tmp58_;
#line 224 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 224 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_propagate_error (error, _inner_error_);
#line 224 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_sqlite3_finalize0 (stmt);
#line 224 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 224 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_g_free0 (basename);
#line 224 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_g_free0 (token);
#line 224 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_g_free0 (real_path);
#line 224 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return FALSE;
#line 2219 "midori-database.c"
		} else {
#line 224 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_sqlite3_finalize0 (stmt);
#line 224 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 224 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_g_free0 (basename);
#line 224 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_g_free0 (token);
#line 224 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_g_free0 (real_path);
#line 224 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 224 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_clear_error (&_inner_error_);
#line 224 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return FALSE;
#line 2237 "midori-database.c"
		}
	}
#line 225 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp59_ = stmt;
#line 225 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp60_ = sqlite3_column_int64 (_tmp59_, 0);
#line 225 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	user_version = _tmp60_;
#line 227 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp61_ = user_version;
#line 227 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (_tmp61_ == ((gint64) 0)) {
#line 2250 "midori-database.c"
		gint64 _tmp62_ = 0LL;
		gchar* _tmp63_ = NULL;
		gchar* _tmp64_ = NULL;
		gchar* _tmp65_ = NULL;
		gchar* _tmp66_ = NULL;
#line 228 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		midori_database_exec_script (self, "Create", &_inner_error_);
#line 228 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 228 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 228 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				g_propagate_error (error, _inner_error_);
#line 228 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_sqlite3_finalize0 (stmt);
#line 228 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 228 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_g_free0 (basename);
#line 228 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_g_free0 (token);
#line 228 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_g_free0 (real_path);
#line 228 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				return FALSE;
#line 2276 "midori-database.c"
			} else {
#line 228 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_sqlite3_finalize0 (stmt);
#line 228 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 228 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_g_free0 (basename);
#line 228 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_g_free0 (token);
#line 228 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_g_free0 (real_path);
#line 228 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 228 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				g_clear_error (&_inner_error_);
#line 228 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				return FALSE;
#line 2294 "midori-database.c"
			}
		}
#line 229 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		user_version = (gint64) 1;
#line 230 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp62_ = user_version;
#line 230 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp63_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp62_);
#line 230 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp64_ = _tmp63_;
#line 230 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp65_ = g_strconcat ("PRAGMA user_version = ", _tmp64_, NULL);
#line 230 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp66_ = _tmp65_;
#line 230 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		midori_database_exec (self, _tmp66_, &_inner_error_);
#line 230 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_g_free0 (_tmp66_);
#line 230 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_g_free0 (_tmp64_);
#line 230 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 230 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 230 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				g_propagate_error (error, _inner_error_);
#line 230 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_sqlite3_finalize0 (stmt);
#line 230 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 230 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_g_free0 (basename);
#line 230 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_g_free0 (token);
#line 230 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_g_free0 (real_path);
#line 230 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				return FALSE;
#line 2333 "midori-database.c"
			} else {
#line 230 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_sqlite3_finalize0 (stmt);
#line 230 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 230 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_g_free0 (basename);
#line 230 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_g_free0 (token);
#line 230 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_g_free0 (real_path);
#line 230 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 230 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				g_clear_error (&_inner_error_);
#line 230 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				return FALSE;
#line 2351 "midori-database.c"
			}
		}
	}
#line 233 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	while (TRUE) {
#line 2357 "midori-database.c"
		gint64 _tmp75_ = 0LL;
		gint64 _tmp76_ = 0LL;
		gchar* _tmp77_ = NULL;
		gchar* _tmp78_ = NULL;
		gchar* _tmp79_ = NULL;
		gchar* _tmp80_ = NULL;
		{
			gint64 _tmp67_ = 0LL;
			gchar* _tmp68_ = NULL;
			gchar* _tmp69_ = NULL;
			gchar* _tmp70_ = NULL;
			gchar* _tmp71_ = NULL;
#line 235 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_tmp67_ = user_version;
#line 235 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_tmp68_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp67_);
#line 235 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_tmp69_ = _tmp68_;
#line 235 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_tmp70_ = g_strconcat ("Update", _tmp69_, NULL);
#line 235 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_tmp71_ = _tmp70_;
#line 235 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			midori_database_exec_script (self, _tmp71_, &_inner_error_);
#line 235 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_g_free0 (_tmp71_);
#line 235 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_g_free0 (_tmp69_);
#line 235 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 235 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 2390 "midori-database.c"
					goto __catch13_midori_database_error;
				}
#line 235 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_sqlite3_finalize0 (stmt);
#line 235 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 235 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_g_free0 (basename);
#line 235 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_g_free0 (token);
#line 235 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_g_free0 (real_path);
#line 235 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 235 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				g_clear_error (&_inner_error_);
#line 235 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				return FALSE;
#line 2409 "midori-database.c"
			}
		}
		goto __finally13;
		__catch13_midori_database_error:
		{
			GError* _error_ = NULL;
			GError* _tmp72_ = NULL;
			GError* _tmp73_ = NULL;
			GError* _tmp74_ = NULL;
#line 234 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_error_ = _inner_error_;
#line 234 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_inner_error_ = NULL;
#line 237 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_tmp72_ = _error_;
#line 237 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			if (g_error_matches (_tmp72_, MIDORI_DATABASE_ERROR, MIDORI_DATABASE_ERROR_FILENAME)) {
#line 238 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_g_error_free0 (_error_);
#line 238 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				break;
#line 2431 "midori-database.c"
			}
#line 239 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_tmp73_ = _error_;
#line 239 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_tmp74_ = _g_error_copy0 (_tmp73_);
#line 239 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_inner_error_ = _tmp74_;
#line 239 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_g_error_free0 (_error_);
#line 2441 "midori-database.c"
			goto __finally13;
		}
		__finally13:
#line 234 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 234 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 234 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				g_propagate_error (error, _inner_error_);
#line 234 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_sqlite3_finalize0 (stmt);
#line 234 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 234 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_g_free0 (basename);
#line 234 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_g_free0 (token);
#line 234 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_g_free0 (real_path);
#line 234 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				return FALSE;
#line 2463 "midori-database.c"
			} else {
#line 234 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_sqlite3_finalize0 (stmt);
#line 234 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 234 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_g_free0 (basename);
#line 234 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_g_free0 (token);
#line 234 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_g_free0 (real_path);
#line 234 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 234 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				g_clear_error (&_inner_error_);
#line 234 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				return FALSE;
#line 2481 "midori-database.c"
			}
		}
#line 241 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp75_ = user_version;
#line 241 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		user_version = _tmp75_ + 1;
#line 242 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp76_ = user_version;
#line 242 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp77_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp76_);
#line 242 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp78_ = _tmp77_;
#line 242 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp79_ = g_strconcat ("PRAGMA user_version = ", _tmp78_, NULL);
#line 242 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp80_ = _tmp79_;
#line 242 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		midori_database_exec (self, _tmp80_, &_inner_error_);
#line 242 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_g_free0 (_tmp80_);
#line 242 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_g_free0 (_tmp78_);
#line 242 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 242 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 242 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				g_propagate_error (error, _inner_error_);
#line 242 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_sqlite3_finalize0 (stmt);
#line 242 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 242 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_g_free0 (basename);
#line 242 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_g_free0 (token);
#line 242 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_g_free0 (real_path);
#line 242 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				return FALSE;
#line 2522 "midori-database.c"
			} else {
#line 242 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_sqlite3_finalize0 (stmt);
#line 242 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 242 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_g_free0 (basename);
#line 242 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_g_free0 (token);
#line 242 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_g_free0 (real_path);
#line 242 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 242 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				g_clear_error (&_inner_error_);
#line 242 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				return FALSE;
#line 2540 "midori-database.c"
			}
		}
	}
#line 245 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp81_ = exists;
#line 245 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	midori_database_set_first_use (self, !_tmp81_);
#line 246 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	result = TRUE;
#line 246 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_sqlite3_finalize0 (stmt);
#line 246 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 246 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_g_free0 (basename);
#line 246 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_g_free0 (token);
#line 246 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_g_free0 (real_path);
#line 246 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	return result;
#line 2562 "midori-database.c"
}


gboolean midori_database_init (MidoriDatabase* self, GCancellable* cancellable, GError** error) {
#line 192 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 192 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	return MIDORI_DATABASE_GET_CLASS (self)->init (self, cancellable, error);
#line 2571 "midori-database.c"
}


gboolean midori_database_exists (MidoriDatabase* self, const gchar* path) {
	gboolean result = FALSE;
	gboolean exists = FALSE;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 249 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 249 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (path != NULL, FALSE);
#line 252 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp0_ = path;
#line 252 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp1_ = access (_tmp0_, F_OK);
#line 252 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	exists = _tmp1_ == 0;
#line 257 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	result = exists;
#line 257 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	return result;
#line 2594 "midori-database.c"
}


gboolean midori_database_attach (MidoriDatabase* self, const gchar* path, const gchar* alias, GError** error) {
	gboolean result = FALSE;
	gchar* real_path = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	GError * _inner_error_ = NULL;
#line 265 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 265 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (path != NULL, FALSE);
#line 265 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (alias != NULL, FALSE);
#line 266 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp0_ = path;
#line 266 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp1_ = midori_database_resolve_path (self, _tmp0_);
#line 266 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	real_path = _tmp1_;
#line 267 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp2_ = real_path;
#line 267 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp3_ = midori_database_exists (self, _tmp2_);
#line 267 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (!_tmp3_) {
#line 2631 "midori-database.c"
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
#line 268 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp4_ = path;
#line 268 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp5_ = g_strdup_printf ("Failed to attach database %s", _tmp4_);
#line 268 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp6_ = _tmp5_;
#line 268 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp7_ = g_error_new_literal (MIDORI_DATABASE_ERROR, MIDORI_DATABASE_ERROR_OPEN, _tmp6_);
#line 268 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp8_ = _tmp7_;
#line 268 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_g_free0 (_tmp6_);
#line 268 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_inner_error_ = _tmp8_;
#line 268 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 268 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_propagate_error (error, _inner_error_);
#line 268 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_g_free0 (real_path);
#line 268 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return FALSE;
#line 2659 "midori-database.c"
		} else {
#line 268 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_g_free0 (real_path);
#line 268 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 268 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_clear_error (&_inner_error_);
#line 268 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return FALSE;
#line 2669 "midori-database.c"
		}
	}
#line 269 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp10_ = real_path;
#line 269 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp11_ = alias;
#line 269 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp12_ = g_strdup_printf ("ATTACH DATABASE '%s' AS '%s';", _tmp10_, _tmp11_);
#line 269 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp13_ = _tmp12_;
#line 269 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp14_ = midori_database_exec (self, _tmp13_, &_inner_error_);
#line 269 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp15_ = _tmp14_;
#line 269 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_g_free0 (_tmp13_);
#line 269 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp9_ = _tmp15_;
#line 269 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 269 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 269 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_propagate_error (error, _inner_error_);
#line 269 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_g_free0 (real_path);
#line 269 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return FALSE;
#line 2698 "midori-database.c"
		} else {
#line 269 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_g_free0 (real_path);
#line 269 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 269 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_clear_error (&_inner_error_);
#line 269 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return FALSE;
#line 2708 "midori-database.c"
		}
	}
#line 269 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	result = _tmp9_;
#line 269 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_g_free0 (real_path);
#line 269 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	return result;
#line 2717 "midori-database.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 272 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 272 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	return _data3_;
#line 2726 "midori-database.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 272 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 2735 "midori-database.c"
		MidoriDatabase* self;
#line 272 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		self = _data3_->self;
#line 272 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_g_free0 (_data3_->schema);
#line 272 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_g_object_unref0 (self);
#line 272 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		g_slice_free (Block3Data, _data3_);
#line 2745 "midori-database.c"
	}
}


static gboolean __lambda6_ (Block3Data* _data3_, GError** error) {
	MidoriDatabase* self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	self = _data3_->self;
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp1_ = _data3_->schema;
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp2_ = midori_database_exec (self, _tmp1_, &_inner_error_);
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp0_ = _tmp2_;
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_propagate_error (error, _inner_error_);
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return FALSE;
#line 2773 "midori-database.c"
		} else {
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_clear_error (&_inner_error_);
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return FALSE;
#line 2781 "midori-database.c"
		}
	}
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	result = _tmp0_;
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	return result;
#line 2788 "midori-database.c"
}


static gboolean ___lambda6__midori_database_callback (gpointer self, GError** error) {
	gboolean result;
	result = __lambda6_ (self, error);
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	return result;
#line 2797 "midori-database.c"
}


gboolean midori_database_exec_script (MidoriDatabase* self, const gchar* filename, GError** error) {
	gboolean result = FALSE;
	Block3Data* _data3_;
	gchar* basename = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** parts = NULL;
	const gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint parts_length1 = 0;
	gint _parts_size_ = 0;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gchar* schema_filename = NULL;
	gchar** _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	GError * _inner_error_ = NULL;
#line 272 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 272 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (filename != NULL, FALSE);
#line 272 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 272 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_data3_->_ref_count_ = 1;
#line 272 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_data3_->self = g_object_ref (self);
#line 273 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp0_ = self->priv->_path;
#line 273 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp1_ = g_path_get_basename (_tmp0_);
#line 273 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	basename = _tmp1_;
#line 274 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp2_ = basename;
#line 274 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, ".", 0);
#line 274 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	parts = _tmp4_;
#line 274 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	parts_length1 = _vala_array_length (_tmp3_);
#line 274 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_parts_size_ = parts_length1;
#line 275 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp7_ = parts;
#line 275 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp7__length1 = parts_length1;
#line 275 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (_tmp7_ != NULL) {
#line 2863 "midori-database.c"
		gchar** _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
		const gchar* _tmp9_ = NULL;
#line 275 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp8_ = parts;
#line 275 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp8__length1 = parts_length1;
#line 275 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp9_ = _tmp8_[0];
#line 275 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp6_ = _tmp9_ != NULL;
#line 2875 "midori-database.c"
	} else {
#line 275 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp6_ = FALSE;
#line 2879 "midori-database.c"
	}
#line 275 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (_tmp6_) {
#line 2883 "midori-database.c"
		gchar** _tmp10_ = NULL;
		gint _tmp10__length1 = 0;
		const gchar* _tmp11_ = NULL;
#line 275 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp10_ = parts;
#line 275 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp10__length1 = parts_length1;
#line 275 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp11_ = _tmp10_[1];
#line 275 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp5_ = _tmp11_ != NULL;
#line 2895 "midori-database.c"
	} else {
#line 275 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp5_ = FALSE;
#line 2899 "midori-database.c"
	}
#line 275 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (!_tmp5_) {
#line 2903 "midori-database.c"
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		GError* _tmp15_ = NULL;
		GError* _tmp16_ = NULL;
#line 276 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp12_ = self->priv->_path;
#line 276 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp13_ = g_strdup_printf ("Failed to deduce schema filename from %s", _tmp12_);
#line 276 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp14_ = _tmp13_;
#line 276 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp15_ = g_error_new_literal (MIDORI_DATABASE_ERROR, MIDORI_DATABASE_ERROR_NAMING, _tmp14_);
#line 276 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp16_ = _tmp15_;
#line 276 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_g_free0 (_tmp14_);
#line 276 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_inner_error_ = _tmp16_;
#line 276 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 276 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_propagate_error (error, _inner_error_);
#line 276 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 276 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_g_free0 (basename);
#line 276 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			block3_data_unref (_data3_);
#line 276 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_data3_ = NULL;
#line 276 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return FALSE;
#line 2937 "midori-database.c"
		} else {
#line 276 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 276 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_g_free0 (basename);
#line 276 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			block3_data_unref (_data3_);
#line 276 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_data3_ = NULL;
#line 276 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 276 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_clear_error (&_inner_error_);
#line 276 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return FALSE;
#line 2953 "midori-database.c"
		}
	}
#line 277 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp17_ = parts;
#line 277 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp17__length1 = parts_length1;
#line 277 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp18_ = _tmp17_[0];
#line 277 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp19_ = g_strconcat (_tmp18_, "/", NULL);
#line 277 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp20_ = _tmp19_;
#line 277 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp21_ = filename;
#line 277 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp22_ = g_strconcat (_tmp20_, _tmp21_, NULL);
#line 277 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp23_ = _tmp22_;
#line 277 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp24_ = g_strconcat (_tmp23_, ".sql", NULL);
#line 277 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp25_ = _tmp24_;
#line 277 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp26_ = midori_paths_get_res_filename (_tmp25_);
#line 277 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp27_ = _tmp26_;
#line 277 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_g_free0 (_tmp25_);
#line 277 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_g_free0 (_tmp23_);
#line 277 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_g_free0 (_tmp20_);
#line 277 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	schema_filename = _tmp27_;
#line 2988 "midori-database.c"
	{
		const gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
#line 280 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp28_ = schema_filename;
#line 280 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		g_file_get_contents (_tmp28_, &_tmp29_, NULL, &_inner_error_);
#line 280 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_g_free0 (_data3_->schema);
#line 280 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_data3_->schema = _tmp29_;
#line 280 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3002 "midori-database.c"
			goto __catch14_g_error;
		}
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		GError* _tmp33_ = NULL;
		GError* _tmp34_ = NULL;
#line 279 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_error_ = _inner_error_;
#line 279 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_inner_error_ = NULL;
#line 282 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp30_ = schema_filename;
#line 282 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp31_ = g_strdup_printf ("Failed to open schema: %s", _tmp30_);
#line 282 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp32_ = _tmp31_;
#line 282 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp33_ = g_error_new_literal (MIDORI_DATABASE_ERROR, MIDORI_DATABASE_ERROR_FILENAME, _tmp32_);
#line 282 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp34_ = _tmp33_;
#line 282 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_g_free0 (_tmp32_);
#line 282 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_inner_error_ = _tmp34_;
#line 282 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_g_error_free0 (_error_);
#line 3035 "midori-database.c"
		goto __finally14;
	}
	__finally14:
#line 279 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 279 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 279 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_propagate_error (error, _inner_error_);
#line 279 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_g_free0 (schema_filename);
#line 279 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 279 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_g_free0 (basename);
#line 279 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			block3_data_unref (_data3_);
#line 279 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_data3_ = NULL;
#line 279 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return FALSE;
#line 3057 "midori-database.c"
		} else {
#line 279 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_g_free0 (schema_filename);
#line 279 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 279 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_g_free0 (basename);
#line 279 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			block3_data_unref (_data3_);
#line 279 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_data3_ = NULL;
#line 279 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 279 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_clear_error (&_inner_error_);
#line 279 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return FALSE;
#line 3075 "midori-database.c"
		}
	}
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	midori_database_transaction (self, ___lambda6__midori_database_callback, _data3_, &_inner_error_);
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_propagate_error (error, _inner_error_);
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_g_free0 (schema_filename);
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_g_free0 (basename);
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			block3_data_unref (_data3_);
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_data3_ = NULL;
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return FALSE;
#line 3098 "midori-database.c"
		} else {
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_g_free0 (schema_filename);
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_g_free0 (basename);
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			block3_data_unref (_data3_);
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_data3_ = NULL;
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_clear_error (&_inner_error_);
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return FALSE;
#line 3116 "midori-database.c"
		}
	}
#line 285 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	result = TRUE;
#line 285 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_g_free0 (schema_filename);
#line 285 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 285 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_g_free0 (basename);
#line 285 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	block3_data_unref (_data3_);
#line 285 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_data3_ = NULL;
#line 285 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	return result;
#line 3133 "midori-database.c"
}


gboolean midori_database_transaction (MidoriDatabase* self, MidoriDatabaseCallback callback, void* callback_target, GError** error) {
	gboolean result = FALSE;
	MidoriDatabaseCallback _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	GError * _inner_error_ = NULL;
#line 288 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 289 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	midori_database_exec (self, "BEGIN TRANSACTION;", &_inner_error_);
#line 289 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 289 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 289 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_propagate_error (error, _inner_error_);
#line 289 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return FALSE;
#line 3154 "midori-database.c"
		} else {
#line 289 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 289 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_clear_error (&_inner_error_);
#line 289 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return FALSE;
#line 3162 "midori-database.c"
		}
	}
#line 290 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp0_ = callback;
#line 290 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp0__target = callback_target;
#line 290 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp0_ (_tmp0__target, &_inner_error_);
#line 290 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 290 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 290 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_propagate_error (error, _inner_error_);
#line 290 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return FALSE;
#line 3179 "midori-database.c"
		} else {
#line 290 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 290 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_clear_error (&_inner_error_);
#line 290 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return FALSE;
#line 3187 "midori-database.c"
		}
	}
#line 291 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	midori_database_exec (self, "COMMIT;", &_inner_error_);
#line 291 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 291 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 291 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_propagate_error (error, _inner_error_);
#line 291 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return FALSE;
#line 3200 "midori-database.c"
		} else {
#line 291 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 291 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_clear_error (&_inner_error_);
#line 291 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return FALSE;
#line 3208 "midori-database.c"
		}
	}
#line 292 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	result = TRUE;
#line 292 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	return result;
#line 3215 "midori-database.c"
}


gboolean midori_database_exec (MidoriDatabase* self, const gchar* query, GError** error) {
	gboolean result = FALSE;
	sqlite3* _tmp0_ = NULL;
	sqlite3* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GError * _inner_error_ = NULL;
#line 295 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 295 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (query != NULL, FALSE);
#line 296 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp0_ = midori_database_get_db (self);
#line 296 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp1_ = _tmp0_;
#line 296 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp2_ = query;
#line 296 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp3_ = _sqlite3_exec (_tmp1_, _tmp2_, NULL, NULL, NULL);
#line 296 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (_tmp3_ != SQLITE_OK) {
#line 3240 "midori-database.c"
		sqlite3* _tmp4_ = NULL;
		sqlite3* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
#line 297 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp4_ = midori_database_get_db (self);
#line 297 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp5_ = _tmp4_;
#line 297 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp6_ = sqlite3_errmsg (_tmp5_);
#line 297 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp7_ = g_error_new_literal (MIDORI_DATABASE_ERROR, MIDORI_DATABASE_ERROR_EXECUTE, _tmp6_);
#line 297 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_inner_error_ = _tmp7_;
#line 297 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 297 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_propagate_error (error, _inner_error_);
#line 297 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return FALSE;
#line 3261 "midori-database.c"
		} else {
#line 297 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 297 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_clear_error (&_inner_error_);
#line 297 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return FALSE;
#line 3269 "midori-database.c"
		}
	}
#line 298 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	result = TRUE;
#line 298 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	return result;
#line 3276 "midori-database.c"
}


MidoriDatabaseStatement* midori_database_prepare (MidoriDatabase* self, const gchar* query, GError** error, ...) {
	MidoriDatabaseStatement* result = NULL;
	MidoriDatabaseStatement* statement = NULL;
	const gchar* _tmp0_ = NULL;
	MidoriDatabaseStatement* _tmp1_ = NULL;
	va_list args = {0};
	const gchar* pname = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp32_ = FALSE;
	GError * _inner_error_ = NULL;
#line 306 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 306 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (query != NULL, NULL);
#line 307 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp0_ = query;
#line 307 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp1_ = midori_database_statement_new (self, _tmp0_, &_inner_error_);
#line 307 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	statement = _tmp1_;
#line 307 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 307 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 307 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_propagate_error (error, _inner_error_);
#line 307 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return NULL;
#line 3308 "midori-database.c"
		} else {
#line 307 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 307 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			g_clear_error (&_inner_error_);
#line 307 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			return NULL;
#line 3316 "midori-database.c"
		}
	}
#line 308 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	va_start (args, error);
#line 309 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp2_ = va_arg (args, gchar*);
#line 309 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	pname = _tmp2_;
#line 310 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	while (TRUE) {
#line 3327 "midori-database.c"
		const gchar* _tmp3_ = NULL;
		GType ptype = 0UL;
		GType _tmp4_ = 0UL;
		GType _tmp5_ = 0UL;
		const gchar* _tmp31_ = NULL;
#line 310 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp3_ = pname;
#line 310 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (!(_tmp3_ != NULL)) {
#line 310 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			break;
#line 3339 "midori-database.c"
		}
#line 311 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp4_ = va_arg (args, GType);
#line 311 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		ptype = _tmp4_;
#line 312 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp5_ = ptype;
#line 312 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		if (_tmp5_ == G_TYPE_STRING) {
#line 3349 "midori-database.c"
			gchar* pvalue = NULL;
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			MidoriDatabaseStatement* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			GType _tmp10_ = 0UL;
			const gchar* _tmp11_ = NULL;
#line 313 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_tmp6_ = va_arg (args, gchar*);
#line 313 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_tmp7_ = g_strdup (_tmp6_);
#line 313 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			pvalue = _tmp7_;
#line 314 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_tmp8_ = statement;
#line 314 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_tmp9_ = pname;
#line 314 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_tmp10_ = ptype;
#line 314 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_tmp11_ = pvalue;
#line 314 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			midori_database_statement_bind (_tmp8_, _tmp9_, &_inner_error_, _tmp10_, _tmp11_, NULL);
#line 314 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 314 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 314 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					g_propagate_error (error, _inner_error_);
#line 314 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					_g_free0 (pvalue);
#line 314 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					va_end (args);
#line 314 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					_g_object_unref0 (statement);
#line 314 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					return NULL;
#line 3387 "midori-database.c"
				} else {
#line 314 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					_g_free0 (pvalue);
#line 314 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					va_end (args);
#line 314 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					_g_object_unref0 (statement);
#line 314 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 314 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					g_clear_error (&_inner_error_);
#line 314 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					return NULL;
#line 3401 "midori-database.c"
				}
			}
#line 312 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_g_free0 (pvalue);
#line 3406 "midori-database.c"
		} else {
			GType _tmp12_ = 0UL;
#line 315 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			_tmp12_ = ptype;
#line 315 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
			if (_tmp12_ == G_TYPE_INT64) {
#line 3413 "midori-database.c"
				gint64 pvalue = 0LL;
				gint64 _tmp13_ = 0LL;
				MidoriDatabaseStatement* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				GType _tmp16_ = 0UL;
				gint64 _tmp17_ = 0LL;
#line 316 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_tmp13_ = va_arg (args, gint64);
#line 316 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				pvalue = _tmp13_;
#line 317 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_tmp14_ = statement;
#line 317 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_tmp15_ = pname;
#line 317 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_tmp16_ = ptype;
#line 317 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_tmp17_ = pvalue;
#line 317 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				midori_database_statement_bind (_tmp14_, _tmp15_, &_inner_error_, _tmp16_, _tmp17_, NULL);
#line 317 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 317 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 317 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
						g_propagate_error (error, _inner_error_);
#line 317 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
						va_end (args);
#line 317 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
						_g_object_unref0 (statement);
#line 317 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
						return NULL;
#line 3446 "midori-database.c"
					} else {
#line 317 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
						va_end (args);
#line 317 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
						_g_object_unref0 (statement);
#line 317 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 317 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
						g_clear_error (&_inner_error_);
#line 317 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
						return NULL;
#line 3458 "midori-database.c"
					}
				}
			} else {
				GType _tmp18_ = 0UL;
#line 318 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				_tmp18_ = ptype;
#line 318 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
				if (_tmp18_ == G_TYPE_DOUBLE) {
#line 3467 "midori-database.c"
					gdouble pvalue = 0.0;
					gdouble _tmp19_ = 0.0;
					MidoriDatabaseStatement* _tmp20_ = NULL;
					const gchar* _tmp21_ = NULL;
					GType _tmp22_ = 0UL;
					gdouble _tmp23_ = 0.0;
#line 319 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					_tmp19_ = va_arg (args, gdouble);
#line 319 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					pvalue = _tmp19_;
#line 320 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					_tmp20_ = statement;
#line 320 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					_tmp21_ = pname;
#line 320 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					_tmp22_ = ptype;
#line 320 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					_tmp23_ = pvalue;
#line 320 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					midori_database_statement_bind (_tmp20_, _tmp21_, &_inner_error_, _tmp22_, _tmp23_, NULL);
#line 320 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 320 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
						if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 320 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
							g_propagate_error (error, _inner_error_);
#line 320 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
							va_end (args);
#line 320 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
							_g_object_unref0 (statement);
#line 320 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
							return NULL;
#line 3500 "midori-database.c"
						} else {
#line 320 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
							va_end (args);
#line 320 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
							_g_object_unref0 (statement);
#line 320 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 320 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
							g_clear_error (&_inner_error_);
#line 320 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
							return NULL;
#line 3512 "midori-database.c"
						}
					}
				} else {
					GType _tmp24_ = 0UL;
					const gchar* _tmp25_ = NULL;
					const gchar* _tmp26_ = NULL;
					gchar* _tmp27_ = NULL;
					gchar* _tmp28_ = NULL;
					GError* _tmp29_ = NULL;
					GError* _tmp30_ = NULL;
#line 322 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					_tmp24_ = ptype;
#line 322 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					_tmp25_ = g_type_name (_tmp24_);
#line 322 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					_tmp26_ = query;
#line 322 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					_tmp27_ = g_strdup_printf ("Invalid type '%s' in statement: %s", _tmp25_, _tmp26_);
#line 322 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					_tmp28_ = _tmp27_;
#line 322 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					_tmp29_ = g_error_new_literal (MIDORI_DATABASE_ERROR, MIDORI_DATABASE_ERROR_TYPE, _tmp28_);
#line 322 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					_tmp30_ = _tmp29_;
#line 322 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					_g_free0 (_tmp28_);
#line 322 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					_inner_error_ = _tmp30_;
#line 322 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
					if (_inner_error_->domain == MIDORI_DATABASE_ERROR) {
#line 322 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
						g_propagate_error (error, _inner_error_);
#line 322 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
						va_end (args);
#line 322 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
						_g_object_unref0 (statement);
#line 322 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
						return NULL;
#line 3551 "midori-database.c"
					} else {
#line 322 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
						va_end (args);
#line 322 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
						_g_object_unref0 (statement);
#line 322 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 322 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
						g_clear_error (&_inner_error_);
#line 322 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
						return NULL;
#line 3563 "midori-database.c"
					}
				}
			}
		}
#line 323 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp31_ = va_arg (args, gchar*);
#line 323 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		pname = _tmp31_;
#line 3572 "midori-database.c"
	}
#line 325 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp32_ = self->trace;
#line 325 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	if (_tmp32_) {
#line 3578 "midori-database.c"
		FILE* _tmp33_ = NULL;
#line 326 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		_tmp33_ = stdout;
#line 326 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		fprintf (_tmp33_, "\n");
#line 3584 "midori-database.c"
	}
#line 327 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	result = statement;
#line 327 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	va_end (args);
#line 327 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	return result;
#line 3592 "midori-database.c"
}


sqlite3* midori_database_get_db (MidoriDatabase* self) {
	sqlite3* result;
	sqlite3* _tmp0_ = NULL;
#line 165 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 165 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp0_ = self->_db;
#line 165 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	result = _tmp0_;
#line 165 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	return result;
#line 3607 "midori-database.c"
}


const gchar* midori_database_get_path (MidoriDatabase* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 167 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 167 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp0_ = self->priv->_path;
#line 167 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	result = _tmp0_;
#line 167 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	return result;
#line 3622 "midori-database.c"
}


void midori_database_set_path (MidoriDatabase* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 167 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_if_fail (self != NULL);
#line 167 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp0_ = value;
#line 167 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 167 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_g_free0 (self->priv->_path);
#line 167 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	self->priv->_path = _tmp1_;
#line 167 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_object_notify ((GObject *) self, "path");
#line 3641 "midori-database.c"
}


gboolean midori_database_get_first_use (MidoriDatabase* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 173 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 173 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp0_ = self->priv->_first_use;
#line 173 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	result = _tmp0_;
#line 173 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	return result;
#line 3656 "midori-database.c"
}


void midori_database_set_first_use (MidoriDatabase* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 173 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_return_if_fail (self != NULL);
#line 173 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp0_ = value;
#line 173 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	self->priv->_first_use = _tmp0_;
#line 173 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_object_notify ((GObject *) self, "first-use");
#line 3670 "midori-database.c"
}


static void midori_database_class_init (MidoriDatabaseClass * klass) {
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	midori_database_parent_class = g_type_class_peek_parent (klass);
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_type_class_add_private (klass, sizeof (MidoriDatabasePrivate));
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	((MidoriDatabaseClass *) klass)->init = midori_database_real_init;
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_midori_database_get_property;
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_midori_database_set_property;
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	G_OBJECT_CLASS (klass)->finalize = midori_database_finalize;
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_DATABASE_DB, g_param_spec_pointer ("db", "db", "db", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_DATABASE_PATH, g_param_spec_string ("path", "path", "path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MIDORI_DATABASE_FIRST_USE, g_param_spec_boolean ("first-use", "first-use", "first-use", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 3693 "midori-database.c"
}


static void midori_database_g_initable_interface_init (GInitableIface * iface) {
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	midori_database_g_initable_parent_iface = g_type_interface_peek_parent (iface);
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	iface->init = (gboolean (*)(GInitable*, GCancellable*, GError**)) midori_database_init;
#line 3702 "midori-database.c"
}


static void midori_database_instance_init (MidoriDatabase * self) {
	gchar* _tmp0_ = NULL;
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	self->priv = MIDORI_DATABASE_GET_PRIVATE (self);
#line 164 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	self->trace = FALSE;
#line 166 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	self->_db = NULL;
#line 167 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_tmp0_ = g_strdup (":memory:");
#line 167 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	self->priv->_path = _tmp0_;
#line 173 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	self->priv->_first_use = FALSE;
#line 3720 "midori-database.c"
}


static void midori_database_finalize (GObject* obj) {
	MidoriDatabase * self;
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MIDORI_TYPE_DATABASE, MidoriDatabase);
#line 166 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_sqlite3_close0 (self->_db);
#line 167 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	_g_free0 (self->priv->_path);
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	G_OBJECT_CLASS (midori_database_parent_class)->finalize (obj);
#line 3734 "midori-database.c"
}


GType midori_database_get_type (void) {
	static volatile gsize midori_database_type_id__volatile = 0;
	if (g_once_init_enter (&midori_database_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MidoriDatabaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) midori_database_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MidoriDatabase), 0, (GInstanceInitFunc) midori_database_instance_init, NULL };
		static const GInterfaceInfo g_initable_info = { (GInterfaceInitFunc) midori_database_g_initable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType midori_database_type_id;
		midori_database_type_id = g_type_register_static (G_TYPE_OBJECT, "MidoriDatabase", &g_define_type_info, 0);
		g_type_add_interface_static (midori_database_type_id, G_TYPE_INITABLE, &g_initable_info);
		g_once_init_leave (&midori_database_type_id__volatile, midori_database_type_id);
	}
	return midori_database_type_id__volatile;
}


static void _vala_midori_database_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MidoriDatabase * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MIDORI_TYPE_DATABASE, MidoriDatabase);
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	switch (property_id) {
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		case MIDORI_DATABASE_DB:
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		g_value_set_pointer (value, midori_database_get_db (self));
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		break;
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		case MIDORI_DATABASE_PATH:
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		g_value_set_string (value, midori_database_get_path (self));
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		break;
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		case MIDORI_DATABASE_FIRST_USE:
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		g_value_set_boolean (value, midori_database_get_first_use (self));
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		break;
#line 3775 "midori-database.c"
		default:
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		break;
#line 3781 "midori-database.c"
	}
}


static void _vala_midori_database_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MidoriDatabase * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MIDORI_TYPE_DATABASE, MidoriDatabase);
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
	switch (property_id) {
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		case MIDORI_DATABASE_PATH:
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		midori_database_set_path (self, g_value_get_string (value));
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		break;
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		case MIDORI_DATABASE_FIRST_USE:
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		midori_database_set_first_use (self, g_value_get_boolean (value));
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		break;
#line 3803 "midori-database.c"
		default:
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/midori/midori-database.vala"
		break;
#line 3809 "midori-database.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



