/* extension.c generated by valac 0.30.0, the Vala compiler
 * generated from extension.vala, do not modify */

/*
 Copyright (C) 2009-2014 Christian Dywan <christian@twotoasts.de>
 Copyright (C) 2009-2012 Alexander Butenko <a.butenka@gmail.com>

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 See the file COPYING for the full license text.
*/

#include <glib.h>
#include <glib-object.h>
#include "toolbar-editor.h"
#include <stdlib.h>
#include <string.h>
#include <libsoup/soup.h>
#include <glib/gi18n-lib.h>
#include "midori/midori-extension.h"
#include "midori/midori-app.h"
#include "midori/midori-browser.h"
#include "midori/midori-view.h"
#include "midori-core.h"
#include <gtk/gtk.h>
#include "webkit/webkit.h"
#include <gio/gio.h>
#include <stdio.h>
#include <stdarg.h>
#include <glib/gstdio.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _adblock_subscription_manager_unref0(var) ((var == NULL) ? NULL : (var = (adblock_subscription_manager_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _Block1Data Block1Data;

#define ADBLOCK_TYPE_CUSTOM_RULES_EDITOR (adblock_custom_rules_editor_get_type ())
#define ADBLOCK_CUSTOM_RULES_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ADBLOCK_TYPE_CUSTOM_RULES_EDITOR, AdblockCustomRulesEditor))
#define ADBLOCK_CUSTOM_RULES_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ADBLOCK_TYPE_CUSTOM_RULES_EDITOR, AdblockCustomRulesEditorClass))
#define ADBLOCK_IS_CUSTOM_RULES_EDITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ADBLOCK_TYPE_CUSTOM_RULES_EDITOR))
#define ADBLOCK_IS_CUSTOM_RULES_EDITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ADBLOCK_TYPE_CUSTOM_RULES_EDITOR))
#define ADBLOCK_CUSTOM_RULES_EDITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ADBLOCK_TYPE_CUSTOM_RULES_EDITOR, AdblockCustomRulesEditorClass))

typedef struct _AdblockCustomRulesEditor AdblockCustomRulesEditor;
typedef struct _AdblockCustomRulesEditorClass AdblockCustomRulesEditorClass;
#define _adblock_custom_rules_editor_unref0(var) ((var == NULL) ? NULL : (var = (adblock_custom_rules_editor_unref (var), NULL)))

#define TYPE_TEST_CASE_CONFIG (test_case_config_get_type ())
typedef struct _TestCaseConfig TestCaseConfig;

#define TYPE_TEST_CASE_SUB (test_case_sub_get_type ())
typedef struct _TestCaseSub TestCaseSub;

#define TYPE_TEST_CASE_LINE (test_case_line_get_type ())
typedef struct _TestCaseLine TestCaseLine;

#define TYPE_TEST_CASE_PATTERN (test_case_pattern_get_type ())
typedef struct _TestCasePattern TestCasePattern;

#define TYPE_TEST_UPDATE_EXAMPLE (test_update_example_get_type ())
typedef struct _TestUpdateExample TestUpdateExample;

#define TYPE_TEST_SUB_URI (test_sub_uri_get_type ())
typedef struct _TestSubUri TestSubUri;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Block1Data {
	int _ref_count_;
	AdblockExtension* self;
	gchar* uri;
};

struct _TestCaseConfig {
	gchar* content;
	guint size;
	gboolean enabled;
};

struct _TestCaseSub {
	gchar* uri;
	gboolean active;
};

struct _TestCaseLine {
	gchar* line;
	gchar* fixed;
};

struct _TestCasePattern {
	gchar* uri;
	AdblockDirective directive;
};

struct _TestUpdateExample {
	gchar* content;
	gboolean result;
	gboolean valid;
};

struct _TestSubUri {
	gchar* src_uri;
	gchar* dst_uri;
};


static gpointer adblock_extension_parent_class = NULL;
extern gchar* tmp_folder;
gchar* tmp_folder = NULL;

enum  {
	ADBLOCK_EXTENSION_DUMMY_PROPERTY
};
static void adblock_extension_extension_activated (AdblockExtension* self, MidoriApp* app);
static void _adblock_extension_extension_activated_midori_extension_activate (MidoriExtension* _sender, MidoriApp* app, gpointer self);
static void adblock_extension_extension_deactivated (AdblockExtension* self);
static void _adblock_extension_extension_deactivated_midori_extension_deactivate (MidoriExtension* _sender, gpointer self);
static void adblock_extension_extension_preferences (AdblockExtension* self);
static void _adblock_extension_extension_preferences_midori_extension_open_preferences (MidoriExtension* _sender, gpointer self);
void adblock_extension_init (AdblockExtension* self);
static void adblock_extension_browser_added (AdblockExtension* self, MidoriBrowser* browser);
static void _adblock_extension_browser_added_midori_app_add_browser (MidoriApp* _sender, MidoriBrowser* browser, gpointer self);
static void adblock_extension_browser_removed (AdblockExtension* self, MidoriBrowser* browser);
static void _adblock_extension_browser_removed_midori_app_remove_browser (MidoriApp* _sender, MidoriBrowser* browser, gpointer self);
static void adblock_extension_tab_added (AdblockExtension* self, MidoriView* view);
static void _adblock_extension_tab_added_midori_browser_add_tab (MidoriBrowser* _sender, MidoriView* tab, gpointer self);
static void adblock_extension_tab_removed (AdblockExtension* self, MidoriView* view);
static void _adblock_extension_tab_removed_midori_browser_remove_tab (MidoriBrowser* _sender, MidoriView* tab, gpointer self);
static gboolean adblock_extension_navigation_requested (AdblockExtension* self, MidoriTab* tab, const gchar* uri);
static gboolean _adblock_extension_navigation_requested_midori_tab_navigation_requested (MidoriTab* _sender, const gchar* uri, gpointer self);
static void adblock_extension_resource_requested (AdblockExtension* self, WebKitWebView* web_view, WebKitWebFrame* frame, WebKitWebResource* resource, WebKitNetworkRequest* request, WebKitNetworkResponse* response);
static void _adblock_extension_resource_requested_webkit_web_view_resource_request_starting (WebKitWebView* _sender, WebKitWebFrame* p0, WebKitWebResource* p1, WebKitNetworkRequest* p2, WebKitNetworkResponse* p3, gpointer self);
static void adblock_extension_load_status_changed (AdblockExtension* self, GObject* object, GParamSpec* pspec);
static void _adblock_extension_load_status_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void adblock_extension_context_menu (AdblockExtension* self, WebKitHitTestResult* hit_test_result, MidoriContextAction* menu);
static void _adblock_extension_context_menu_midori_tab_context_menu (MidoriTab* _sender, WebKitHitTestResult* hit_test_result, MidoriContextAction* menu, gpointer self);
static void adblock_extension_inject_css (AdblockExtension* self, MidoriView* view, const gchar* page_uri);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda12_ (Block1Data* _data1_, GtkAction* action);
gpointer adblock_custom_rules_editor_ref (gpointer instance);
void adblock_custom_rules_editor_unref (gpointer instance);
GParamSpec* adblock_param_spec_custom_rules_editor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void adblock_value_set_custom_rules_editor (GValue* value, gpointer v_object);
void adblock_value_take_custom_rules_editor (GValue* value, gpointer v_object);
gpointer adblock_value_get_custom_rules_editor (const GValue* value);
GType adblock_custom_rules_editor_get_type (void) G_GNUC_CONST;
AdblockCustomRulesEditor* adblock_custom_rules_editor_new (AdblockSubscription* custom);
AdblockCustomRulesEditor* adblock_custom_rules_editor_construct (GType object_type, AdblockSubscription* custom);
void adblock_custom_rules_editor_set_uri (AdblockCustomRulesEditor* self, const gchar* uri);
void adblock_custom_rules_editor_show (AdblockCustomRulesEditor* self);
static void ___lambda12__gtk_action_activate (GtkAction* _sender, gpointer self);
gboolean adblock_extension_request_handled (AdblockExtension* self, const gchar* request_uri, const gchar* page_uri);
static gchar* adblock_extension_fetch_js_hider_function_body (AdblockExtension* self);
static gchar* adblock_extension_get_hider_js_for_blocked_resorces (AdblockExtension* self);
static gchar** adblock_extension_get_domains_for_uri (AdblockExtension* self, const gchar* uri, int* result_length1);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static gchar* adblock_extension_get_hider_css_rules_for_uri (AdblockExtension* self, const gchar* page_uri);
static void adblock_extension_load_config (AdblockExtension* self);
static void adblock_extension_subscriptions_added_removed (AdblockExtension* self, GParamSpec* pspec);
static void _adblock_extension_subscriptions_added_removed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean adblock_extension_open_link (AdblockExtension* self, const gchar* uri);
static gboolean _adblock_extension_open_link_gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self);
static AdblockDirective* _adblock_directive_dup (AdblockDirective* self);
static gboolean _adblock_directive_equal (const AdblockDirective* s1, const AdblockDirective* s2);
static void adblock_extension_finalize (GObject* obj);
void adblock_debug (const gchar* format, ...);
gchar* adblock_fixup_regex (const gchar* prefix, const gchar* src);
gchar* get_test_file (const gchar* contents);
GType test_case_config_get_type (void) G_GNUC_CONST;
TestCaseConfig* test_case_config_dup (const TestCaseConfig* self);
void test_case_config_free (TestCaseConfig* self);
void test_case_config_copy (const TestCaseConfig* self, TestCaseConfig* dest);
void test_case_config_destroy (TestCaseConfig* self);
void test_adblock_config (void);
GType test_case_sub_get_type (void) G_GNUC_CONST;
TestCaseSub* test_case_sub_dup (const TestCaseSub* self);
void test_case_sub_free (TestCaseSub* self);
void test_case_sub_copy (const TestCaseSub* self, TestCaseSub* dest);
void test_case_sub_destroy (TestCaseSub* self);
void test_adblock_subs (void);
void test_adblock_init (void);
GType test_case_line_get_type (void) G_GNUC_CONST;
TestCaseLine* test_case_line_dup (const TestCaseLine* self);
void test_case_line_free (TestCaseLine* self);
void test_case_line_copy (const TestCaseLine* self, TestCaseLine* dest);
void test_case_line_destroy (TestCaseLine* self);
void test_adblock_fixup_regexp (void);
GType test_case_pattern_get_type (void) G_GNUC_CONST;
TestCasePattern* test_case_pattern_dup (const TestCasePattern* self);
void test_case_pattern_free (TestCasePattern* self);
void test_case_pattern_copy (const TestCasePattern* self, TestCasePattern* dest);
void test_case_pattern_destroy (TestCasePattern* self);
gchar* pretty_directive (AdblockDirective* directive);
void test_adblock_pattern (void);
gchar* pretty_date (GDateTime* date);
GType test_update_example_get_type (void) G_GNUC_CONST;
TestUpdateExample* test_update_example_dup (const TestUpdateExample* self);
void test_update_example_free (TestUpdateExample* self);
void test_update_example_copy (const TestUpdateExample* self, TestUpdateExample* dest);
void test_update_example_destroy (TestUpdateExample* self);
void test_subscription_update (void);
GType test_sub_uri_get_type (void) G_GNUC_CONST;
TestSubUri* test_sub_uri_dup (const TestSubUri* self);
void test_sub_uri_free (TestSubUri* self);
void test_sub_uri_copy (const TestSubUri* self, TestSubUri* dest);
void test_sub_uri_destroy (TestSubUri* self);
void test_subscription_uri_parsing (void);
static void _test_adblock_config_gcallback (void);
static void _test_adblock_subs_gcallback (void);
static void _test_adblock_init_gcallback (void);
static void _test_adblock_fixup_regexp_gcallback (void);
static void _test_adblock_pattern_gcallback (void);
static void _test_subscription_update_gcallback (void);
static void _test_subscription_uri_parsing_gcallback (void);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const TestCaseConfig configs[4] = {{"", (guint) 0, TRUE}, {"[settings]", (guint) 0, TRUE}, {"[settings]\nfilters=foo;", (guint) 1, TRUE}, {"[settings]\nfilters=foo;\ndisabled=true", (guint) 1, FALSE}};
const TestCaseSub subs[6] = {{"http://foo.com", TRUE}, {"http://bar.com", FALSE}, {"https://spam.com", TRUE}, {"https://eggs.com", FALSE}, {"file:///bla", TRUE}, {"file:///blub", FALSE}};
const TestCaseLine lines[15] = {{NULL, NULL}, {"!", "!"}, {"@@", "@@"}, {"##", "##"}, {"[", "\\["}, {"+advert/", "advert/"}, {"*foo", "foo"}, {"f*oo", "f.*oo"}, {"?foo", "\\?foo"}, {"foo?", "foo\\?"}, {".*foo/bar", "..*foo/bar"}, {".*.*.*.info/popup", "\\..*\\..*\\..*\\.info/popup"}, {"http://bla.blub/*", "http://bla.blub/.*"}, {"bag?r[]=*cpa", "bag\\?r\\[\\]=.*cpa"}, {"(facebookLike,", "\\(facebookLike,"}};
const TestCasePattern patterns[19] = {{"http://www.engadget.com/_uac/adpage.html", ADBLOCK_DIRECTIVE_BLOCK}, {"http://test.dom/test?var=1", ADBLOCK_DIRECTIVE_BLOCK}, {"http://ads.foo.bar/teddy", ADBLOCK_DIRECTIVE_BLOCK}, {"http://ads.fuu.bar/teddy", ADBLOCK_DIRECTIVE_ALLOW}, {"https://ads.bogus.name/blub", ADBLOCK_DIRECTIVE_BLOCK}, {"http://ads.foo.boing/beer", ADBLOCK_DIRECTIVE_ALLOW}, {"https://testsub.engine.adct.ru/test?id=1", ADBLOCK_DIRECTIVE_BLOCK}, {"http://test.ltd/addyn/test/test?var=adtech;&var2=1", ADBLOCK_DIRECTIVE_BLOCK}, {"http://add.doubleclick.net/pfadx/aaaa.mtvi", ADBLOCK_DIRECTIVE_BLOCK}, {"http://add.doubleclick.net/pfadx/aaaa.mtv", ADBLOCK_DIRECTIVE_ALLOW}, {"http://objects.tremormedia.com/embed/xml/list.xml?r=", ADBLOCK_DIRECTIVE_BLOCK}, {"http://qq.videostrip.c/sub/admatcherclient.php", ADBLOCK_DIRECTIVE_ALLOW}, {"http://qq.videostrip.com/sub/admatcherclient.php", ADBLOCK_DIRECTIVE_BLOCK}, {"http://qq.videostrip.com/sub/admatcherclient.php", ADBLOCK_DIRECTIVE_BLOCK}, {"http://br.gcl.ru/cgi-bin/br/test", ADBLOCK_DIRECTIVE_BLOCK}, {"https://bugs.webkit.org/buglist.cgi?query_format=advanced&short_desc_t" \
"ype=allwordssubstr&short_desc=&long_desc_type=substring&long_desc=&bug" \
"_file_loc_type=allwordssubstr&bug_file_loc=&keywords_type=allwords&key" \
"words=&bug_status=UNCONFIRMED&bug_status=NEW&bug_status=ASSIGNED&bug_s" \
"tatus=REOPENED&emailassigned_to1=1&emailtype1=substring&email1=&emaila" \
"ssigned_to2=1&emailreporter2=1&emailcc2=1&emailtype2=substring&email2=" \
"&bugidtype=include&bug_id=&votes=&chfieldfrom=&chfieldto=Now&chfieldva" \
"lue=&query_based_on=gtkport&field0-0-0=keywords&type0-0-0=anywordssubs" \
"tr&value0-0-0=Gtk%20Cairo%20soup&field0-0-1=short_desc&type0-0-1=anywo" \
"rdssubstr&value0-0-1=Gtk%20Cairo%20soup%20autoconf%20automake%20autoto" \
"ol&field0-0-2=component&type0-0-2=equals&value0-0-2=WebKit%20Gtk", ADBLOCK_DIRECTIVE_ALLOW}, {"http://www.engadget.com/2009/09/24/google-hits-android-rom-modder-with" \
"-a-cease-and-desist-letter/", ADBLOCK_DIRECTIVE_ALLOW}, {"http://karibik-invest.com/es/bienes_raices/search.php?sqT=19&sqN=&sqMp" \
"=&sqL=0&qR=1&sqMb=&searchMode=1&action=B%FAsqueda", ADBLOCK_DIRECTIVE_ALLOW}, {"http://google.com", ADBLOCK_DIRECTIVE_ALLOW}};
const TestUpdateExample examples[9] = {{"[Adblock Plus 1.1]\n" \
"! Last modified: 05 Sep 2010 11:00 UTC\n" \
"! This list expires after 48 hours\n", TRUE, TRUE}, {"[Adblock Plus 1.1]\n" \
"! Last modified: 05.09.2010 11:00 UTC\n" \
"! Expires: 2 days (update frequency)\n", TRUE, TRUE}, {"[Adblock Plus 1.1]\n" \
"! Updated: 05 Nov 2024 11:00 UTC\n" \
"! Expires: 5 days (update frequency)\n", FALSE, TRUE}, {"[Adblock]\n" \
"! dutchblock v3\n" \
"! This list expires after 14 days\n" \
"|http://b*.mookie1.com/\n", FALSE, TRUE}, {"[Adblock Plus 2.0]\n" \
"! Last modification time (GMT): 2012.11.05 13:33\n" \
"! Expires: 5 days (update frequency)\n", TRUE, TRUE}, {"[Adblock Plus 2.0]\n" \
"! Last modification time (GMT): 2012.11.05 13:33\n", TRUE, TRUE}, {"[Adblock]\n ! dummy,  i dont have any dates\n", FALSE, TRUE}, {"[Adblock Plus 2.0]\n" \
" ! Last modified: Oct 26, 2013 18:00 UTC\n" \
" ! This list expires after 5 days\n" \
"! Last modified by maty: 12Oct2013\n" \
"! \n", FALSE, TRUE}, {"\n", FALSE, FALSE}};
const TestSubUri suburis[4] = {{NULL, NULL}, {"not-a-link", NULL}, {"http://some.uri", "http://some.uri"}, {"abp:subscribe?location=https%3A%2F%2Feasylist-downloads.adblockplus.or" \
"g%2Fabpindo%2Beasylist.txt&title=ABPindo%2BEasyList", "https://easylist-downloads.adblockplus.org/abpindo+easylist.txt"}};

GType adblock_directive_get_type (void) {
	static volatile gsize adblock_directive_type_id__volatile = 0;
	if (g_once_init_enter (&adblock_directive_type_id__volatile)) {
		static const GEnumValue values[] = {{ADBLOCK_DIRECTIVE_ALLOW, "ADBLOCK_DIRECTIVE_ALLOW", "allow"}, {ADBLOCK_DIRECTIVE_BLOCK, "ADBLOCK_DIRECTIVE_BLOCK", "block"}, {0, NULL, NULL}};
		GType adblock_directive_type_id;
		adblock_directive_type_id = g_enum_register_static ("AdblockDirective", values);
		g_once_init_leave (&adblock_directive_type_id__volatile, adblock_directive_type_id);
	}
	return adblock_directive_type_id__volatile;
}


GType adblock_state_get_type (void) {
	static volatile gsize adblock_state_type_id__volatile = 0;
	if (g_once_init_enter (&adblock_state_type_id__volatile)) {
		static const GEnumValue values[] = {{ADBLOCK_STATE_ENABLED, "ADBLOCK_STATE_ENABLED", "enabled"}, {ADBLOCK_STATE_DISABLED, "ADBLOCK_STATE_DISABLED", "disabled"}, {ADBLOCK_STATE_BLOCKED, "ADBLOCK_STATE_BLOCKED", "blocked"}, {0, NULL, NULL}};
		GType adblock_state_type_id;
		adblock_state_type_id = g_enum_register_static ("AdblockState", values);
		g_once_init_leave (&adblock_state_type_id__volatile, adblock_state_type_id);
	}
	return adblock_state_type_id__volatile;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1282 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1282 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1282 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 270 "extension.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1284 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1284 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1284 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1284 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1284 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1284 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1284 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1284 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1284 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 301 "extension.c"
				goto __catch2_g_regex_error;
			}
#line 1284 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1284 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1284 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
			return NULL;
#line 310 "extension.c"
		}
#line 1285 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1285 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1285 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
#line 1285 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1285 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1285 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 326 "extension.c"
				goto __catch2_g_regex_error;
			}
#line 1285 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1285 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1285 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1285 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
			return NULL;
#line 337 "extension.c"
		}
#line 1285 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1285 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1285 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1285 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1285 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1285 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 351 "extension.c"
	}
	goto __finally2;
	__catch2_g_regex_error:
	{
		GError* e = NULL;
#line 1283 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1283 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1287 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1283 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 365 "extension.c"
	}
	__finally2:
#line 1283 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1283 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1283 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1283 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		return NULL;
#line 376 "extension.c"
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1197 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1197 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1197 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1197 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1198 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1198 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 400 "extension.c"
		glong _tmp4_ = 0L;
#line 1199 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1199 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1199 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 408 "extension.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1201 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1201 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1201 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1201 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 420 "extension.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
#line 1208 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1210 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1210 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 444 "extension.c"
		glong _tmp2_ = 0L;
#line 1210 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1210 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 450 "extension.c"
	} else {
#line 1210 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 454 "extension.c"
	}
#line 1210 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 458 "extension.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
#line 1212 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1212 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1212 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1212 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 470 "extension.c"
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1214 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1214 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1214 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 480 "extension.c"
	}
#line 1217 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1217 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 486 "extension.c"
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1218 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1218 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1218 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1219 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1219 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 500 "extension.c"
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
#line 1221 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1221 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1221 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 510 "extension.c"
	}
#line 1223 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1223 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 516 "extension.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1224 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1224 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1224 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 525 "extension.c"
	}
#line 1226 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1226 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1226 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1226 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1227 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1227 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1227 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1227 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1227 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	return result;
#line 545 "extension.c"
}


gchar* adblock_parse_subscription_uri (const gchar* uri) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 26 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = uri;
#line 26 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (_tmp0_ == NULL) {
#line 27 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		result = NULL;
#line 27 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		return result;
#line 564 "extension.c"
	}
#line 29 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp3_ = uri;
#line 29 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp4_ = g_str_has_prefix (_tmp3_, "http");
#line 29 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (_tmp4_) {
#line 29 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp2_ = TRUE;
#line 574 "extension.c"
	} else {
		const gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 29 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp5_ = uri;
#line 29 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp6_ = g_str_has_prefix (_tmp5_, "abp");
#line 29 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp2_ = _tmp6_;
#line 584 "extension.c"
	}
#line 29 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (_tmp2_) {
#line 29 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp1_ = TRUE;
#line 590 "extension.c"
	} else {
		const gchar* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
#line 29 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp7_ = uri;
#line 29 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp8_ = g_str_has_prefix (_tmp7_, "file");
#line 29 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp1_ = _tmp8_;
#line 600 "extension.c"
	}
#line 29 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (_tmp1_) {
#line 604 "extension.c"
		gchar* sub_uri = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		gchar* decoded_uri = NULL;
		const gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
#line 31 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp9_ = uri;
#line 31 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp10_ = g_strdup (_tmp9_);
#line 31 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		sub_uri = _tmp10_;
#line 32 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp11_ = uri;
#line 32 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp12_ = g_str_has_prefix (_tmp11_, "abp:");
#line 32 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		if (_tmp12_) {
#line 625 "extension.c"
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp13_ = uri;
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp14_ = string_replace (_tmp13_, "abp://", "abp:");
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp15_ = _tmp14_;
#line 33 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_g_free0 (_tmp15_);
#line 34 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp16_ = uri;
#line 34 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp17_ = g_str_has_prefix (_tmp16_, "abp:subscribe?location=");
#line 34 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			if (_tmp17_) {
#line 645 "extension.c"
				gchar** parts = NULL;
				const gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
				gchar** _tmp21_ = NULL;
				gchar** _tmp22_ = NULL;
				gchar** _tmp23_ = NULL;
				gint _tmp23__length1 = 0;
				gint parts_length1 = 0;
				gint _parts_size_ = 0;
				gchar** _tmp24_ = NULL;
				gint _tmp24__length1 = 0;
				const gchar* _tmp25_ = NULL;
				gchar* _tmp26_ = NULL;
#line 36 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp18_ = uri;
#line 36 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp19_ = string_substring (_tmp18_, (glong) 23, (glong) -1);
#line 36 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp20_ = _tmp19_;
#line 36 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp22_ = _tmp21_ = g_strsplit (_tmp20_, "&", 2);
#line 36 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp23_ = _tmp22_;
#line 36 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp23__length1 = _vala_array_length (_tmp21_);
#line 36 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_g_free0 (_tmp20_);
#line 36 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				parts = _tmp23_;
#line 36 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				parts_length1 = _tmp23__length1;
#line 36 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_parts_size_ = parts_length1;
#line 37 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp24_ = parts;
#line 37 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp24__length1 = parts_length1;
#line 37 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp25_ = _tmp24_[0];
#line 37 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp26_ = g_strdup (_tmp25_);
#line 37 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_g_free0 (sub_uri);
#line 37 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				sub_uri = _tmp26_;
#line 34 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 694 "extension.c"
			}
		}
#line 41 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp27_ = sub_uri;
#line 41 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp28_ = soup_uri_decode (_tmp27_);
#line 41 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		decoded_uri = _tmp28_;
#line 42 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		result = decoded_uri;
#line 42 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (sub_uri);
#line 42 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		return result;
#line 709 "extension.c"
	}
#line 44 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	result = NULL;
#line 44 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	return result;
#line 715 "extension.c"
}


static void _adblock_extension_extension_activated_midori_extension_activate (MidoriExtension* _sender, MidoriApp* app, gpointer self) {
#line 80 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	adblock_extension_extension_activated ((AdblockExtension*) self, app);
#line 722 "extension.c"
}


static void _adblock_extension_extension_deactivated_midori_extension_deactivate (MidoriExtension* _sender, gpointer self) {
#line 81 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	adblock_extension_extension_deactivated ((AdblockExtension*) self);
#line 729 "extension.c"
}


static void _adblock_extension_extension_preferences_midori_extension_open_preferences (MidoriExtension* _sender, gpointer self) {
#line 82 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	adblock_extension_extension_preferences ((AdblockExtension*) self);
#line 736 "extension.c"
}


AdblockExtension* adblock_extension_construct (GType object_type) {
	AdblockExtension * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 76 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = _ ("Advertisement blocker");
#line 76 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp1_ = _ ("Block advertisements according to a filter list");
#line 76 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	self = (AdblockExtension*) g_object_new (object_type, "name", _tmp0_, "description", _tmp1_, "version", "2.0", "authors", "Christian Dywan <christian@twotoasts.de>", NULL);
#line 80 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_signal_connect_object ((MidoriExtension*) self, "activate", (GCallback) _adblock_extension_extension_activated_midori_extension_activate, self, 0);
#line 81 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_signal_connect_object ((MidoriExtension*) self, "deactivate", (GCallback) _adblock_extension_extension_deactivated_midori_extension_deactivate, self, 0);
#line 82 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_signal_connect_object ((MidoriExtension*) self, "open-preferences", (GCallback) _adblock_extension_extension_preferences_midori_extension_open_preferences, self, 0);
#line 75 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	return self;
#line 758 "extension.c"
}


AdblockExtension* adblock_extension_new (void) {
#line 75 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	return adblock_extension_construct (ADBLOCK_TYPE_EXTENSION);
#line 765 "extension.c"
}


static void adblock_extension_extension_preferences (AdblockExtension* self) {
	AdblockSubscriptionManager* _tmp0_ = NULL;
#line 85 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_if_fail (self != NULL);
#line 86 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = self->manager;
#line 86 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	adblock_subscription_manager_add_subscription (_tmp0_, NULL);
#line 777 "extension.c"
}


static void _adblock_extension_browser_added_midori_app_add_browser (MidoriApp* _sender, MidoriBrowser* browser, gpointer self) {
#line 108 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	adblock_extension_browser_added ((AdblockExtension*) self, browser);
#line 784 "extension.c"
}


static void _adblock_extension_browser_removed_midori_app_remove_browser (MidoriApp* _sender, MidoriBrowser* browser, gpointer self) {
#line 109 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	adblock_extension_browser_removed ((AdblockExtension*) self, browser);
#line 791 "extension.c"
}


static void adblock_extension_extension_activated (AdblockExtension* self, MidoriApp* app) {
	MidoriApp* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	MidoriApp* _tmp3_ = NULL;
	MidoriApp* _tmp4_ = NULL;
#line 89 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_if_fail (self != NULL);
#line 89 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_if_fail (app != NULL);
#line 105 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	adblock_extension_init (self);
#line 106 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = app;
#line 106 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp1_ = midori_app_get_browsers (_tmp0_);
#line 810 "extension.c"
	{
		GList* browser_collection = NULL;
		GList* browser_it = NULL;
#line 106 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		browser_collection = _tmp1_;
#line 106 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		for (browser_it = browser_collection; browser_it != NULL; browser_it = browser_it->next) {
#line 818 "extension.c"
			MidoriBrowser* browser = NULL;
#line 106 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			browser = (MidoriBrowser*) browser_it->data;
#line 822 "extension.c"
			{
				MidoriBrowser* _tmp2_ = NULL;
#line 107 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp2_ = browser;
#line 107 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				adblock_extension_browser_added (self, _tmp2_);
#line 829 "extension.c"
			}
		}
#line 106 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_list_free0 (browser_collection);
#line 834 "extension.c"
	}
#line 108 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp3_ = app;
#line 108 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_signal_connect_object (_tmp3_, "add-browser", (GCallback) _adblock_extension_browser_added_midori_app_add_browser, self, 0);
#line 109 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp4_ = app;
#line 109 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_signal_connect_object (_tmp4_, "remove-browser", (GCallback) _adblock_extension_browser_removed_midori_app_remove_browser, self, 0);
#line 844 "extension.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 113 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	return self ? g_object_ref (self) : NULL;
#line 851 "extension.c"
}


static void adblock_extension_extension_deactivated (AdblockExtension* self) {
	MidoriApp* app = NULL;
	MidoriApp* _tmp0_ = NULL;
	MidoriApp* _tmp1_ = NULL;
	MidoriApp* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	MidoriApp* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	MidoriApp* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
#line 112 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_if_fail (self != NULL);
#line 113 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = midori_extension_get_app ((MidoriExtension*) self);
#line 113 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 113 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	app = _tmp1_;
#line 114 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp2_ = app;
#line 114 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp3_ = midori_app_get_browsers (_tmp2_);
#line 877 "extension.c"
	{
		GList* browser_collection = NULL;
		GList* browser_it = NULL;
#line 114 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		browser_collection = _tmp3_;
#line 114 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		for (browser_it = browser_collection; browser_it != NULL; browser_it = browser_it->next) {
#line 885 "extension.c"
			MidoriBrowser* browser = NULL;
#line 114 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			browser = (MidoriBrowser*) browser_it->data;
#line 889 "extension.c"
			{
				MidoriBrowser* _tmp4_ = NULL;
#line 115 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp4_ = browser;
#line 115 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				adblock_extension_browser_removed (self, _tmp4_);
#line 896 "extension.c"
			}
		}
#line 114 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_list_free0 (browser_collection);
#line 901 "extension.c"
	}
#line 116 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp5_ = app;
#line 116 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_signal_parse_name ("add-browser", MIDORI_TYPE_APP, &_tmp6_, NULL, FALSE);
#line 116 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _adblock_extension_browser_added_midori_app_add_browser, self);
#line 117 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp7_ = app;
#line 117 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_signal_parse_name ("remove-browser", MIDORI_TYPE_APP, &_tmp8_, NULL, FALSE);
#line 117 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _adblock_extension_browser_removed_midori_app_remove_browser, self);
#line 112 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_object_unref0 (app);
#line 917 "extension.c"
}


static void _adblock_extension_tab_added_midori_browser_add_tab (MidoriBrowser* _sender, MidoriView* tab, gpointer self) {
#line 123 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	adblock_extension_tab_added ((AdblockExtension*) self, tab);
#line 924 "extension.c"
}


static void _adblock_extension_tab_removed_midori_browser_remove_tab (MidoriBrowser* _sender, MidoriView* tab, gpointer self) {
#line 124 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	adblock_extension_tab_removed ((AdblockExtension*) self, tab);
#line 931 "extension.c"
}


static void adblock_extension_browser_added (AdblockExtension* self, MidoriBrowser* browser) {
	MidoriBrowser* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	MidoriBrowser* _tmp3_ = NULL;
	MidoriBrowser* _tmp4_ = NULL;
	MidoriBrowser* _tmp5_ = NULL;
	AdblockStatusIcon* _tmp6_ = NULL;
#line 120 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_if_fail (self != NULL);
#line 120 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_if_fail (browser != NULL);
#line 121 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = browser;
#line 121 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp1_ = midori_browser_get_tabs (_tmp0_);
#line 950 "extension.c"
	{
		GList* tab_collection = NULL;
		GList* tab_it = NULL;
#line 121 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		tab_collection = _tmp1_;
#line 121 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		for (tab_it = tab_collection; tab_it != NULL; tab_it = tab_it->next) {
#line 958 "extension.c"
			MidoriView* tab = NULL;
#line 121 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			tab = (MidoriView*) tab_it->data;
#line 962 "extension.c"
			{
				MidoriView* _tmp2_ = NULL;
#line 122 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp2_ = tab;
#line 122 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				adblock_extension_tab_added (self, _tmp2_);
#line 969 "extension.c"
			}
		}
#line 121 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_list_free0 (tab_collection);
#line 974 "extension.c"
	}
#line 123 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp3_ = browser;
#line 123 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_signal_connect_object (_tmp3_, "add-tab", (GCallback) _adblock_extension_tab_added_midori_browser_add_tab, self, 0);
#line 124 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp4_ = browser;
#line 124 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_signal_connect_object (_tmp4_, "remove-tab", (GCallback) _adblock_extension_tab_removed_midori_browser_remove_tab, self, 0);
#line 126 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp5_ = browser;
#line 126 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp6_ = self->status_icon;
#line 126 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	midori_window_add_action ((MidoriWindow*) _tmp5_, (GtkAction*) _tmp6_);
#line 990 "extension.c"
}


static void adblock_extension_browser_removed (AdblockExtension* self, MidoriBrowser* browser) {
	MidoriBrowser* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	MidoriBrowser* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	MidoriBrowser* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	MidoriBrowser* _tmp7_ = NULL;
	AdblockStatusIcon* _tmp8_ = NULL;
#line 129 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_if_fail (self != NULL);
#line 129 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_if_fail (browser != NULL);
#line 130 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = browser;
#line 130 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp1_ = midori_browser_get_tabs (_tmp0_);
#line 1011 "extension.c"
	{
		GList* tab_collection = NULL;
		GList* tab_it = NULL;
#line 130 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		tab_collection = _tmp1_;
#line 130 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		for (tab_it = tab_collection; tab_it != NULL; tab_it = tab_it->next) {
#line 1019 "extension.c"
			MidoriView* tab = NULL;
#line 130 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			tab = (MidoriView*) tab_it->data;
#line 1023 "extension.c"
			{
				MidoriView* _tmp2_ = NULL;
#line 131 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp2_ = tab;
#line 131 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				adblock_extension_tab_removed (self, _tmp2_);
#line 1030 "extension.c"
			}
		}
#line 130 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_list_free0 (tab_collection);
#line 1035 "extension.c"
	}
#line 132 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp3_ = browser;
#line 132 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_signal_parse_name ("add-tab", MIDORI_TYPE_BROWSER, &_tmp4_, NULL, FALSE);
#line 132 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _adblock_extension_tab_added_midori_browser_add_tab, self);
#line 133 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp5_ = browser;
#line 133 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_signal_parse_name ("remove-tab", MIDORI_TYPE_BROWSER, &_tmp6_, NULL, FALSE);
#line 133 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _adblock_extension_tab_removed_midori_browser_remove_tab, self);
#line 134 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp7_ = browser;
#line 134 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp8_ = self->status_icon;
#line 134 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	midori_window_remove_action ((MidoriWindow*) _tmp7_, (GtkAction*) _tmp8_);
#line 1055 "extension.c"
}


static gboolean _adblock_extension_navigation_requested_midori_tab_navigation_requested (MidoriTab* _sender, const gchar* uri, gpointer self) {
	gboolean result;
	result = adblock_extension_navigation_requested ((AdblockExtension*) self, _sender, uri);
#line 138 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	return result;
#line 1064 "extension.c"
}


static void _adblock_extension_resource_requested_webkit_web_view_resource_request_starting (WebKitWebView* _sender, WebKitWebFrame* p0, WebKitWebResource* p1, WebKitNetworkRequest* p2, WebKitNetworkResponse* p3, gpointer self) {
#line 140 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	adblock_extension_resource_requested ((AdblockExtension*) self, _sender, p0, p1, p2, p3);
#line 1071 "extension.c"
}


static void _adblock_extension_load_status_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 142 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	adblock_extension_load_status_changed ((AdblockExtension*) self, _sender, pspec);
#line 1078 "extension.c"
}


static void _adblock_extension_context_menu_midori_tab_context_menu (MidoriTab* _sender, WebKitHitTestResult* hit_test_result, MidoriContextAction* menu, gpointer self) {
#line 143 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	adblock_extension_context_menu ((AdblockExtension*) self, hit_test_result, menu);
#line 1085 "extension.c"
}


static void adblock_extension_tab_added (AdblockExtension* self, MidoriView* view) {
	MidoriView* _tmp0_ = NULL;
	MidoriView* _tmp1_ = NULL;
	WebKitWebView* _tmp2_ = NULL;
	WebKitWebView* _tmp3_ = NULL;
	MidoriView* _tmp4_ = NULL;
	MidoriView* _tmp5_ = NULL;
#line 137 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_if_fail (self != NULL);
#line 137 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_if_fail (view != NULL);
#line 138 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = view;
#line 138 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_signal_connect_object ((MidoriTab*) _tmp0_, "navigation-requested", (GCallback) _adblock_extension_navigation_requested_midori_tab_navigation_requested, self, 0);
#line 140 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp1_ = view;
#line 140 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp2_ = midori_tab_get_web_view ((MidoriTab*) _tmp1_);
#line 140 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp3_ = _tmp2_;
#line 140 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_signal_connect_object (_tmp3_, "resource-request-starting", (GCallback) _adblock_extension_resource_requested_webkit_web_view_resource_request_starting, self, 0);
#line 142 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp4_ = view;
#line 142 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_signal_connect_object ((GObject*) _tmp4_, "notify::load-status", (GCallback) _adblock_extension_load_status_changed_g_object_notify, self, 0);
#line 143 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp5_ = view;
#line 143 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_signal_connect_object ((MidoriTab*) _tmp5_, "context-menu", (GCallback) _adblock_extension_context_menu_midori_tab_context_menu, self, 0);
#line 1120 "extension.c"
}


static void adblock_extension_tab_removed (AdblockExtension* self, MidoriView* view) {
	MidoriView* _tmp0_ = NULL;
	WebKitWebView* _tmp1_ = NULL;
	WebKitWebView* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	MidoriView* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	MidoriView* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	GQuark _tmp8_ = 0U;
	MidoriView* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
#line 146 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_if_fail (self != NULL);
#line 146 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_if_fail (view != NULL);
#line 148 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = view;
#line 148 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp1_ = midori_tab_get_web_view ((MidoriTab*) _tmp0_);
#line 148 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp2_ = _tmp1_;
#line 148 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_signal_parse_name ("resource-request-starting", WEBKIT_TYPE_WEB_VIEW, &_tmp3_, NULL, FALSE);
#line 148 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _adblock_extension_resource_requested_webkit_web_view_resource_request_starting, self);
#line 150 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp4_ = view;
#line 150 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_signal_parse_name ("navigation-requested", MIDORI_TYPE_TAB, &_tmp5_, NULL, FALSE);
#line 150 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_signal_handlers_disconnect_matched ((MidoriTab*) _tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _adblock_extension_navigation_requested_midori_tab_navigation_requested, self);
#line 151 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp6_ = view;
#line 151 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_signal_parse_name ("notify::load-status", G_TYPE_OBJECT, &_tmp7_, &_tmp8_, TRUE);
#line 151 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_signal_handlers_disconnect_matched ((GObject*) _tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, _tmp8_, NULL, (GCallback) _adblock_extension_load_status_changed_g_object_notify, self);
#line 152 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp9_ = view;
#line 152 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_signal_parse_name ("context-menu", MIDORI_TYPE_TAB, &_tmp10_, NULL, FALSE);
#line 152 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_signal_handlers_disconnect_matched ((MidoriTab*) _tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _adblock_extension_context_menu_midori_tab_context_menu, self);
#line 1168 "extension.c"
}


static void adblock_extension_load_status_changed (AdblockExtension* self, GObject* object, GParamSpec* pspec) {
	MidoriView* view = NULL;
	GObject* _tmp0_ = NULL;
	MidoriView* _tmp1_ = NULL;
	AdblockConfig* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
#line 155 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_if_fail (self != NULL);
#line 155 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_if_fail (object != NULL);
#line 155 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_if_fail (pspec != NULL);
#line 156 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = object;
#line 156 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, MIDORI_TYPE_VIEW) ? ((MidoriView*) _tmp0_) : NULL);
#line 156 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	view = _tmp1_;
#line 157 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp2_ = self->config;
#line 157 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp3_ = adblock_config_get_enabled (_tmp2_);
#line 157 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp4_ = _tmp3_;
#line 157 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (_tmp4_) {
#line 1199 "extension.c"
		MidoriView* _tmp5_ = NULL;
		MidoriLoadStatus _tmp6_ = 0;
		MidoriLoadStatus _tmp7_ = 0;
#line 158 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp5_ = view;
#line 158 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp6_ = midori_tab_get_load_status ((MidoriTab*) _tmp5_);
#line 158 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp7_ = _tmp6_;
#line 158 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		if (_tmp7_ == MIDORI_LOAD_FINISHED) {
#line 1211 "extension.c"
			MidoriView* _tmp8_ = NULL;
			MidoriView* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
#line 159 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp8_ = view;
#line 159 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp9_ = view;
#line 159 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp10_ = midori_tab_get_uri ((MidoriTab*) _tmp9_);
#line 159 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp11_ = _tmp10_;
#line 159 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			adblock_extension_inject_css (self, _tmp8_, _tmp11_);
#line 1226 "extension.c"
		}
	}
#line 155 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_object_unref0 (view);
#line 1231 "extension.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	return _data1_;
#line 1240 "extension.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 1249 "extension.c"
		AdblockExtension* self;
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		self = _data1_->self;
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (_data1_->uri);
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_object_unref0 (self);
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		g_slice_free (Block1Data, _data1_);
#line 1259 "extension.c"
	}
}


static void __lambda12_ (Block1Data* _data1_, GtkAction* action) {
	AdblockExtension* self;
	AdblockCustomRulesEditor* custom_rules_editor = NULL;
	AdblockSubscription* _tmp0_ = NULL;
	AdblockCustomRulesEditor* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 174 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	self = _data1_->self;
#line 174 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_if_fail (action != NULL);
#line 175 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = self->custom;
#line 175 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp1_ = adblock_custom_rules_editor_new (_tmp0_);
#line 175 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	custom_rules_editor = _tmp1_;
#line 176 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp2_ = _data1_->uri;
#line 176 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	adblock_custom_rules_editor_set_uri (custom_rules_editor, _tmp2_);
#line 177 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	adblock_custom_rules_editor_show (custom_rules_editor);
#line 174 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_adblock_custom_rules_editor_unref0 (custom_rules_editor);
#line 1288 "extension.c"
}


static void ___lambda12__gtk_action_activate (GtkAction* _sender, gpointer self) {
#line 174 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	__lambda12_ (self, _sender);
#line 1295 "extension.c"
}


static void adblock_extension_context_menu (AdblockExtension* self, WebKitHitTestResult* hit_test_result, MidoriContextAction* menu) {
	Block1Data* _data1_;
	gchar* label = NULL;
	WebKitHitTestResult* _tmp0_ = NULL;
	WebKitHitTestResultContext _tmp1_ = 0;
	WebKitHitTestResultContext _tmp2_ = 0;
	GtkAction* action = NULL;
	const gchar* _tmp16_ = NULL;
	GtkAction* _tmp17_ = NULL;
	GtkAction* _tmp18_ = NULL;
	MidoriContextAction* _tmp19_ = NULL;
	GtkAction* _tmp20_ = NULL;
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_if_fail (self != NULL);
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_if_fail (hit_test_result != NULL);
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_if_fail (menu != NULL);
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_data1_->_ref_count_ = 1;
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_data1_->self = g_object_ref (self);
#line 165 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = hit_test_result;
#line 165 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_object_get (_tmp0_, "context", &_tmp1_, NULL);
#line 165 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp2_ = _tmp1_;
#line 165 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if ((_tmp2_ & WEBKIT_HIT_TEST_RESULT_CONTEXT_IMAGE) != 0) {
#line 1331 "extension.c"
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		WebKitHitTestResult* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 166 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp3_ = _ ("Bl_ock image");
#line 166 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp4_ = g_strdup (_tmp3_);
#line 166 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (label);
#line 166 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		label = _tmp4_;
#line 167 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp5_ = hit_test_result;
#line 167 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		g_object_get (_tmp5_, "image-uri", &_tmp6_, NULL);
#line 167 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp7_ = _tmp6_;
#line 167 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (_data1_->uri);
#line 167 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_data1_->uri = _tmp7_;
#line 1355 "extension.c"
	} else {
		WebKitHitTestResult* _tmp8_ = NULL;
		WebKitHitTestResultContext _tmp9_ = 0;
		WebKitHitTestResultContext _tmp10_ = 0;
#line 168 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp8_ = hit_test_result;
#line 168 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		g_object_get (_tmp8_, "context", &_tmp9_, NULL);
#line 168 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp10_ = _tmp9_;
#line 168 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		if ((_tmp10_ & WEBKIT_HIT_TEST_RESULT_CONTEXT_LINK) != 0) {
#line 1368 "extension.c"
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			WebKitHitTestResult* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
#line 169 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp11_ = _ ("Bl_ock link");
#line 169 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp12_ = g_strdup (_tmp11_);
#line 169 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_g_free0 (label);
#line 169 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			label = _tmp12_;
#line 170 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp13_ = hit_test_result;
#line 170 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			g_object_get (_tmp13_, "link-uri", &_tmp14_, NULL);
#line 170 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp15_ = _tmp14_;
#line 170 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_g_free0 (_data1_->uri);
#line 170 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_data1_->uri = _tmp15_;
#line 1392 "extension.c"
		} else {
#line 172 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_g_free0 (label);
#line 172 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			block1_data_unref (_data1_);
#line 172 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_data1_ = NULL;
#line 172 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			return;
#line 1402 "extension.c"
		}
	}
#line 173 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp16_ = label;
#line 173 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp17_ = gtk_action_new ("BlockElement", _tmp16_, NULL, NULL);
#line 173 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	action = _tmp17_;
#line 174 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp18_ = action;
#line 174 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_signal_connect_data (_tmp18_, "activate", (GCallback) ___lambda12__gtk_action_activate, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 179 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp19_ = menu;
#line 179 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp20_ = action;
#line 179 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	midori_context_action_add (_tmp19_, _tmp20_);
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_object_unref0 (action);
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 (label);
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	block1_data_unref (_data1_);
#line 163 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_data1_ = NULL;
#line 1429 "extension.c"
}


static void adblock_extension_resource_requested (AdblockExtension* self, WebKitWebView* web_view, WebKitWebFrame* frame, WebKitWebResource* resource, WebKitNetworkRequest* request, WebKitNetworkResponse* response) {
	WebKitNetworkRequest* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	WebKitWebView* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
#line 183 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_if_fail (self != NULL);
#line 183 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_if_fail (web_view != NULL);
#line 183 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_if_fail (frame != NULL);
#line 183 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_if_fail (resource != NULL);
#line 183 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_if_fail (request != NULL);
#line 186 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = request;
#line 186 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp1_ = webkit_network_request_get_uri (_tmp0_);
#line 186 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp2_ = _tmp1_;
#line 186 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp3_ = web_view;
#line 186 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp4_ = webkit_web_view_get_uri (_tmp3_);
#line 186 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp5_ = _tmp4_;
#line 186 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp6_ = adblock_extension_request_handled (self, _tmp2_, _tmp5_);
#line 186 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (_tmp6_) {
#line 1467 "extension.c"
		WebKitNetworkRequest* _tmp7_ = NULL;
#line 187 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp7_ = request;
#line 187 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		webkit_network_request_set_uri (_tmp7_, "about:blank");
#line 1473 "extension.c"
	}
}


static gboolean adblock_extension_navigation_requested (AdblockExtension* self, MidoriTab* tab, const gchar* uri) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	AdblockState _tmp6_ = 0;
	AdblockConfig* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	AdblockStatusIcon* _tmp10_ = NULL;
#line 192 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 192 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_val_if_fail (tab != NULL, FALSE);
#line 192 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_val_if_fail (uri != NULL, FALSE);
#line 193 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = uri;
#line 193 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp1_ = g_str_has_prefix (_tmp0_, "abp:");
#line 193 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (_tmp1_) {
#line 1499 "extension.c"
		gchar* parsed_uri = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		AdblockSubscriptionManager* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 194 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp2_ = uri;
#line 194 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp3_ = adblock_parse_subscription_uri (_tmp2_);
#line 194 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		parsed_uri = _tmp3_;
#line 195 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp4_ = self->manager;
#line 195 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp5_ = parsed_uri;
#line 195 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		adblock_subscription_manager_add_subscription (_tmp4_, _tmp5_);
#line 196 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		result = TRUE;
#line 196 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (parsed_uri);
#line 196 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		return result;
#line 1523 "extension.c"
	}
#line 198 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp7_ = self->config;
#line 198 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp8_ = adblock_config_get_enabled (_tmp7_);
#line 198 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp9_ = _tmp8_;
#line 198 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (_tmp9_) {
#line 198 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp6_ = ADBLOCK_STATE_ENABLED;
#line 1535 "extension.c"
	} else {
#line 198 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp6_ = ADBLOCK_STATE_DISABLED;
#line 1539 "extension.c"
	}
#line 198 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp10_ = self->status_icon;
#line 198 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	adblock_status_icon_set_state (_tmp10_, _tmp6_);
#line 199 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	result = FALSE;
#line 199 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	return result;
#line 1549 "extension.c"
}


static gchar* adblock_extension_fetch_js_hider_function_body (AdblockExtension* self) {
	gchar* result = NULL;
	gchar* filename = NULL;
	gchar* _tmp0_ = NULL;
	GFile* js_file = NULL;
	GFile* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 222 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 223 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = midori_paths_get_res_filename ("adblock/element_hider.js");
#line 223 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	filename = _tmp0_;
#line 224 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp1_ = g_file_new_for_path (filename);
#line 224 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	js_file = _tmp1_;
#line 1570 "extension.c"
	{
		guint8* function_body = NULL;
		gint function_body_length1 = 0;
		gint _function_body_size_ = 0;
		guint8* _tmp2_ = NULL;
		gsize _tmp3_;
		gchar* _tmp4_ = NULL;
#line 227 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		g_file_load_contents (js_file, NULL, &_tmp2_, &_tmp3_, NULL, &_inner_error_);
#line 227 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		function_body = (g_free (function_body), NULL);
#line 227 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		function_body = _tmp2_;
#line 227 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		function_body_length1 = _tmp3_;
#line 227 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_function_body_size_ = function_body_length1;
#line 227 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 227 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			function_body = (g_free (function_body), NULL);
#line 1592 "extension.c"
			goto __catch3_g_error;
		}
#line 228 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp4_ = g_strdup ((const gchar*) function_body);
#line 228 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		result = _tmp4_;
#line 228 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		function_body = (g_free (function_body), NULL);
#line 228 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_object_unref0 (js_file);
#line 228 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (filename);
#line 228 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		return result;
#line 1607 "extension.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 225 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_error_ = _inner_error_;
#line 225 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_inner_error_ = NULL;
#line 231 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp5_ = _error_;
#line 231 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp6_ = _tmp5_->message;
#line 231 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		g_warning ("extension.vala:231: Error while loading adblock hider js: %s\n", _tmp6_);
#line 225 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_error_free0 (_error_);
#line 1627 "extension.c"
	}
	__finally3:
#line 225 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 225 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_object_unref0 (js_file);
#line 225 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (filename);
#line 225 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 225 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		g_clear_error (&_inner_error_);
#line 225 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		return NULL;
#line 1642 "extension.c"
	}
#line 233 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	result = NULL;
#line 233 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_object_unref0 (js_file);
#line 233 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 (filename);
#line 233 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	return result;
#line 1652 "extension.c"
}


static gchar* adblock_extension_get_hider_js_for_blocked_resorces (AdblockExtension* self) {
	gchar* result = NULL;
	GString* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	GString* js = NULL;
	GString* _tmp5_ = NULL;
	GString* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GString* _tmp8_ = NULL;
	GString* _tmp9_ = NULL;
	GString* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GString* _tmp12_ = NULL;
	GString* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
#line 236 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 237 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = self->hider_selectors;
#line 237 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp1_ = _tmp0_->str;
#line 237 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (g_strcmp0 (_tmp1_, "") == 0) {
#line 238 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		result = NULL;
#line 238 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		return result;
#line 1686 "extension.c"
	}
#line 240 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp3_ = self->js_hider_function_body;
#line 240 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (_tmp3_ == NULL) {
#line 240 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp2_ = TRUE;
#line 1694 "extension.c"
	} else {
		const gchar* _tmp4_ = NULL;
#line 240 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp4_ = self->js_hider_function_body;
#line 240 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
#line 1701 "extension.c"
	}
#line 240 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (_tmp2_) {
#line 241 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		result = NULL;
#line 241 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		return result;
#line 1709 "extension.c"
	}
#line 243 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp5_ = g_string_new ("(function() {");
#line 243 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	js = _tmp5_;
#line 244 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp6_ = js;
#line 244 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp7_ = self->js_hider_function_body;
#line 244 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_string_append (_tmp6_, _tmp7_);
#line 245 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp8_ = js;
#line 245 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_string_append (_tmp8_, "var uris=new Array ();");
#line 246 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp9_ = js;
#line 246 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp10_ = self->hider_selectors;
#line 246 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp11_ = _tmp10_->str;
#line 246 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_string_append (_tmp9_, _tmp11_);
#line 247 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp12_ = js;
#line 247 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_string_append (_tmp12_, " hideElementBySrc (uris);})();");
#line 249 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp13_ = js;
#line 249 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp14_ = _tmp13_->str;
#line 249 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp15_ = g_strdup (_tmp14_);
#line 249 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	result = _tmp15_;
#line 249 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_string_free0 (js);
#line 249 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	return result;
#line 1749 "extension.c"
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
#line 267 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if ((*length) == (*size)) {
#line 267 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 267 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1760 "extension.c"
	}
#line 267 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	(*array)[(*length)++] = value;
#line 267 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	(*array)[*length] = NULL;
#line 1766 "extension.c"
}


static gchar** adblock_extension_get_domains_for_uri (AdblockExtension* self, const gchar* uri, int* result_length1) {
	gchar** result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar** domains = NULL;
	gint domains_length1 = 0;
	gint _domains_size_ = 0;
	gchar* domain = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar** subdomains = NULL;
	const gchar* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gint subdomains_length1 = 0;
	gint _subdomains_size_ = 0;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gint cnt = 0;
	gchar** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	GString* subdomain = NULL;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gint _tmp11_ = 0;
	const gchar* _tmp12_ = NULL;
	GString* _tmp13_ = NULL;
	GString* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gchar** _tmp27_ = NULL;
	gint _tmp27__length1 = 0;
#line 253 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 253 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 254 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = uri;
#line 254 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (_tmp0_ == NULL) {
#line 1808 "extension.c"
		gchar** _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
#line 255 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp1_ = NULL;
#line 255 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp1__length1 = 0;
#line 255 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		if (result_length1) {
#line 255 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			*result_length1 = _tmp1__length1;
#line 1819 "extension.c"
		}
#line 255 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		result = _tmp1_;
#line 255 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		return result;
#line 1825 "extension.c"
	}
#line 256 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	domains = NULL;
#line 256 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	domains_length1 = 0;
#line 256 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_domains_size_ = domains_length1;
#line 257 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp2_ = uri;
#line 257 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp3_ = midori_uri_parse_hostname (_tmp2_, NULL);
#line 257 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	domain = _tmp3_;
#line 258 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp4_ = domain;
#line 258 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, ".", 0);
#line 258 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	subdomains = _tmp6_;
#line 258 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	subdomains_length1 = _vala_array_length (_tmp5_);
#line 258 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_subdomains_size_ = subdomains_length1;
#line 259 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp7_ = subdomains;
#line 259 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp7__length1 = subdomains_length1;
#line 259 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (_tmp7_ == NULL) {
#line 1855 "extension.c"
		gchar** _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
#line 260 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp8_ = NULL;
#line 260 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp8__length1 = 0;
#line 260 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		if (result_length1) {
#line 260 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			*result_length1 = _tmp8__length1;
#line 1866 "extension.c"
		}
#line 260 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		result = _tmp8_;
#line 260 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		subdomains = (_vala_array_free (subdomains, subdomains_length1, (GDestroyNotify) g_free), NULL);
#line 260 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (domain);
#line 260 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		domains = (_vala_array_free (domains, domains_length1, (GDestroyNotify) g_free), NULL);
#line 260 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		return result;
#line 1878 "extension.c"
	}
#line 261 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp9_ = subdomains;
#line 261 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp9__length1 = subdomains_length1;
#line 261 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	cnt = _tmp9__length1 - 1;
#line 262 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp10_ = subdomains;
#line 262 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp10__length1 = subdomains_length1;
#line 262 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp11_ = cnt;
#line 262 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp12_ = _tmp10_[_tmp11_];
#line 262 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp13_ = g_string_new (_tmp12_);
#line 262 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	subdomain = _tmp13_;
#line 263 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp14_ = subdomain;
#line 263 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_string_prepend_c (_tmp14_, '.');
#line 264 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp15_ = cnt;
#line 264 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	cnt = _tmp15_ - 1;
#line 265 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	while (TRUE) {
#line 1908 "extension.c"
		gint _tmp16_ = 0;
		GString* _tmp17_ = NULL;
		gchar** _tmp18_ = NULL;
		gint _tmp18__length1 = 0;
		gint _tmp19_ = 0;
		const gchar* _tmp20_ = NULL;
		gchar** _tmp21_ = NULL;
		gint _tmp21__length1 = 0;
		GString* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		GString* _tmp25_ = NULL;
		gint _tmp26_ = 0;
#line 265 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp16_ = cnt;
#line 265 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		if (!(_tmp16_ >= 0)) {
#line 265 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			break;
#line 1928 "extension.c"
		}
#line 266 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp17_ = subdomain;
#line 266 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp18_ = subdomains;
#line 266 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp18__length1 = subdomains_length1;
#line 266 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp19_ = cnt;
#line 266 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp20_ = _tmp18_[_tmp19_];
#line 266 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		g_string_prepend (_tmp17_, _tmp20_);
#line 267 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp21_ = domains;
#line 267 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp21__length1 = domains_length1;
#line 267 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp22_ = subdomain;
#line 267 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp23_ = _tmp22_->str;
#line 267 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp24_ = g_strdup (_tmp23_);
#line 267 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_vala_array_add1 (&domains, &domains_length1, &_domains_size_, _tmp24_);
#line 268 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp25_ = subdomain;
#line 268 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		g_string_prepend_c (_tmp25_, '.');
#line 269 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp26_ = cnt;
#line 269 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		cnt = _tmp26_ - 1;
#line 1962 "extension.c"
	}
#line 271 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp27_ = domains;
#line 271 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp27__length1 = domains_length1;
#line 271 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (result_length1) {
#line 271 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		*result_length1 = _tmp27__length1;
#line 1972 "extension.c"
	}
#line 271 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	result = _tmp27_;
#line 271 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_string_free0 (subdomain);
#line 271 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	subdomains = (_vala_array_free (subdomains, subdomains_length1, (GDestroyNotify) g_free), NULL);
#line 271 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 (domain);
#line 271 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	return result;
#line 1984 "extension.c"
}


static gchar* adblock_extension_get_hider_css_rules_for_uri (AdblockExtension* self, const gchar* page_uri) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar** domains = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar** _tmp3_ = NULL;
	gint domains_length1 = 0;
	gint _domains_size_ = 0;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	GString* code = NULL;
	GString* _tmp5_ = NULL;
	gint blockscnt = 0;
	gchar* style = NULL;
	gint _tmp40_ = 0;
	GString* _tmp41_ = NULL;
	GString* _tmp42_ = NULL;
	gssize _tmp43_ = 0L;
	gchar* hider_css = NULL;
	gboolean _tmp44_ = FALSE;
	GString* _tmp47_ = NULL;
	const gchar* _tmp48_ = NULL;
	gboolean _tmp49_ = FALSE;
	GString* _tmp53_ = NULL;
	const gchar* _tmp54_ = NULL;
	gchar* _tmp55_ = NULL;
#line 274 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 274 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_val_if_fail (page_uri != NULL, NULL);
#line 275 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = page_uri;
#line 275 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (_tmp0_ == NULL) {
#line 276 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		result = NULL;
#line 276 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		return result;
#line 2027 "extension.c"
	}
#line 277 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp1_ = page_uri;
#line 277 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp3_ = adblock_extension_get_domains_for_uri (self, _tmp1_, &_tmp2_);
#line 277 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	domains = _tmp3_;
#line 277 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	domains_length1 = _tmp2_;
#line 277 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_domains_size_ = domains_length1;
#line 278 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp4_ = domains;
#line 278 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp4__length1 = domains_length1;
#line 278 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (_tmp4_ == NULL) {
#line 279 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		result = NULL;
#line 279 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		domains = (_vala_array_free (domains, domains_length1, (GDestroyNotify) g_free), NULL);
#line 279 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		return result;
#line 2051 "extension.c"
	}
#line 280 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp5_ = g_string_new ("");
#line 280 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	code = _tmp5_;
#line 281 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	blockscnt = 0;
#line 282 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	style = NULL;
#line 2061 "extension.c"
	{
		AdblockConfig* _sub_list = NULL;
		AdblockConfig* _tmp6_ = NULL;
		AdblockConfig* _tmp7_ = NULL;
		guint _sub_size = 0U;
		AdblockConfig* _tmp8_ = NULL;
		guint _tmp9_ = 0U;
		guint _tmp10_ = 0U;
		gint _sub_index = 0;
#line 283 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp6_ = self->config;
#line 283 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp7_ = _g_object_ref0 (_tmp6_);
#line 283 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_sub_list = _tmp7_;
#line 283 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp8_ = _sub_list;
#line 283 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp9_ = adblock_config_get_size (_tmp8_);
#line 283 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp10_ = _tmp9_;
#line 283 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_sub_size = _tmp10_;
#line 283 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_sub_index = -1;
#line 283 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		while (TRUE) {
#line 2089 "extension.c"
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			guint _tmp13_ = 0U;
			AdblockSubscription* sub = NULL;
			AdblockConfig* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			AdblockSubscription* _tmp16_ = NULL;
#line 283 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp11_ = _sub_index;
#line 283 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_sub_index = _tmp11_ + 1;
#line 283 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp12_ = _sub_index;
#line 283 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp13_ = _sub_size;
#line 283 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			if (!(((guint) _tmp12_) < _tmp13_)) {
#line 283 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				break;
#line 2109 "extension.c"
			}
#line 283 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp14_ = _sub_list;
#line 283 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp15_ = _sub_index;
#line 283 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp16_ = adblock_config_get (_tmp14_, (guint) _tmp15_);
#line 283 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			sub = _tmp16_;
#line 2119 "extension.c"
			{
				AdblockSubscription* _feature_list = NULL;
				AdblockSubscription* _tmp17_ = NULL;
				AdblockSubscription* _tmp18_ = NULL;
				guint _feature_size = 0U;
				AdblockSubscription* _tmp19_ = NULL;
				guint _tmp20_ = 0U;
				guint _tmp21_ = 0U;
				gint _feature_index = 0;
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp17_ = sub;
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp18_ = _g_object_ref0 (_tmp17_);
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_feature_list = _tmp18_;
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp19_ = _feature_list;
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp20_ = adblock_subscription_get_size (_tmp19_);
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp21_ = _tmp20_;
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_feature_size = _tmp21_;
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_feature_index = -1;
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				while (TRUE) {
#line 2147 "extension.c"
					gint _tmp22_ = 0;
					gint _tmp23_ = 0;
					guint _tmp24_ = 0U;
					AdblockFeature* feature = NULL;
					AdblockSubscription* _tmp25_ = NULL;
					gint _tmp26_ = 0;
					AdblockFeature* _tmp27_ = NULL;
					AdblockElement* element = NULL;
					AdblockFeature* _tmp28_ = NULL;
					AdblockElement* _tmp29_ = NULL;
					AdblockElement* _tmp30_ = NULL;
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp22_ = _feature_index;
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_feature_index = _tmp22_ + 1;
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp23_ = _feature_index;
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp24_ = _feature_size;
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					if (!(((guint) _tmp23_) < _tmp24_)) {
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						break;
#line 2171 "extension.c"
					}
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp25_ = _feature_list;
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp26_ = _feature_index;
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp27_ = adblock_subscription_get (_tmp25_, (guint) _tmp26_);
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					feature = _tmp27_;
#line 285 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp28_ = feature;
#line 285 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, ADBLOCK_TYPE_ELEMENT) ? ((AdblockElement*) _tmp28_) : NULL);
#line 285 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					element = _tmp29_;
#line 286 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp30_ = element;
#line 286 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					if (_tmp30_ != NULL) {
#line 2191 "extension.c"
						gchar** _tmp31_ = NULL;
						gint _tmp31__length1 = 0;
#line 287 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						_tmp31_ = domains;
#line 287 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						_tmp31__length1 = domains_length1;
#line 2198 "extension.c"
						{
							gchar** subdomain_collection = NULL;
							gint subdomain_collection_length1 = 0;
							gint _subdomain_collection_size_ = 0;
							gint subdomain_it = 0;
#line 287 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
							subdomain_collection = _tmp31_;
#line 287 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
							subdomain_collection_length1 = _tmp31__length1;
#line 287 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
							for (subdomain_it = 0; subdomain_it < _tmp31__length1; subdomain_it = subdomain_it + 1) {
#line 2210 "extension.c"
								const gchar* subdomain = NULL;
#line 287 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
								subdomain = subdomain_collection[subdomain_it];
#line 2214 "extension.c"
								{
									AdblockElement* _tmp32_ = NULL;
									const gchar* _tmp33_ = NULL;
									gchar* _tmp34_ = NULL;
									const gchar* _tmp35_ = NULL;
#line 288 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
									_tmp32_ = element;
#line 288 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
									_tmp33_ = subdomain;
#line 288 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
									_tmp34_ = adblock_element_lookup (_tmp32_, _tmp33_);
#line 288 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
									_g_free0 (style);
#line 288 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
									style = _tmp34_;
#line 289 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
									_tmp35_ = style;
#line 289 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
									if (_tmp35_ != NULL) {
#line 2234 "extension.c"
										GString* _tmp36_ = NULL;
										const gchar* _tmp37_ = NULL;
										GString* _tmp38_ = NULL;
										gint _tmp39_ = 0;
#line 290 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
										_tmp36_ = code;
#line 290 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
										_tmp37_ = style;
#line 290 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
										g_string_append (_tmp36_, _tmp37_);
#line 291 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
										_tmp38_ = code;
#line 291 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
										g_string_append_c (_tmp38_, ',');
#line 292 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
										_tmp39_ = blockscnt;
#line 292 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
										blockscnt = _tmp39_ + 1;
#line 2253 "extension.c"
									}
								}
							}
						}
					}
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_g_object_unref0 (element);
#line 2261 "extension.c"
				}
#line 284 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_g_object_unref0 (_feature_list);
#line 2265 "extension.c"
			}
		}
#line 283 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_object_unref0 (_sub_list);
#line 2270 "extension.c"
	}
#line 299 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp40_ = blockscnt;
#line 299 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (_tmp40_ == 0) {
#line 300 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		result = NULL;
#line 300 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (style);
#line 300 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_string_free0 (code);
#line 300 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		domains = (_vala_array_free (domains, domains_length1, (GDestroyNotify) g_free), NULL);
#line 300 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		return result;
#line 2286 "extension.c"
	}
#line 301 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp41_ = code;
#line 301 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp42_ = code;
#line 301 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp43_ = _tmp42_->len;
#line 301 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_string_truncate (_tmp41_, (gsize) (_tmp43_ - 1));
#line 304 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp44_ = self->debug_element;
#line 304 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (_tmp44_) {
#line 2300 "extension.c"
		gchar* _tmp45_ = NULL;
#line 305 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp45_ = g_strdup (" { background-color: red !important; border: 4px solid green !importan" \
"t; }");
#line 305 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (hider_css);
#line 305 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		hider_css = _tmp45_;
#line 2308 "extension.c"
	} else {
		gchar* _tmp46_ = NULL;
#line 307 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp46_ = g_strdup (" { display: none !important }");
#line 307 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (hider_css);
#line 307 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		hider_css = _tmp46_;
#line 2317 "extension.c"
	}
#line 309 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp47_ = code;
#line 309 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp48_ = hider_css;
#line 309 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_string_append (_tmp47_, _tmp48_);
#line 310 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp49_ = self->debug_element;
#line 310 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (_tmp49_) {
#line 2329 "extension.c"
		FILE* _tmp50_ = NULL;
		GString* _tmp51_ = NULL;
		const gchar* _tmp52_ = NULL;
#line 311 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp50_ = stdout;
#line 311 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp51_ = code;
#line 311 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp52_ = _tmp51_->str;
#line 311 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		fprintf (_tmp50_, "css: %s\n", _tmp52_);
#line 2341 "extension.c"
	}
#line 313 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp53_ = code;
#line 313 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp54_ = _tmp53_->str;
#line 313 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp55_ = g_strdup (_tmp54_);
#line 313 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	result = _tmp55_;
#line 313 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 (hider_css);
#line 313 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 (style);
#line 313 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_string_free0 (code);
#line 313 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	domains = (_vala_array_free (domains, domains_length1, (GDestroyNotify) g_free), NULL);
#line 313 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	return result;
#line 2361 "extension.c"
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1278 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1278 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1279 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1279 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1279 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1279 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	return result;
#line 2381 "extension.c"
}


static void adblock_extension_inject_css (AdblockExtension* self, MidoriView* view, const gchar* page_uri) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gchar* blocked_js = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* style = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
#line 316 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_if_fail (self != NULL);
#line 316 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_if_fail (view != NULL);
#line 316 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_if_fail (page_uri != NULL);
#line 318 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = page_uri;
#line 318 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp1_ = midori_uri_is_http (_tmp0_);
#line 318 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (!_tmp1_) {
#line 319 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		return;
#line 2412 "extension.c"
	}
#line 321 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp3_ = g_getenv ("MIDORI_DEBUG");
#line 321 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp2_ = _tmp3_;
#line 321 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (_tmp2_ == NULL) {
#line 321 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp2_ = "";
#line 2422 "extension.c"
	}
#line 321 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp4_ = string_contains (_tmp2_, "adblock:element");
#line 321 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (_tmp4_) {
#line 322 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		self->debug_element = TRUE;
#line 2430 "extension.c"
	} else {
		AdblockStatusIcon* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 324 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp5_ = self->status_icon;
#line 324 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp6_ = _tmp5_->debug_element_toggled;
#line 324 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		self->debug_element = _tmp6_;
#line 2440 "extension.c"
	}
#line 331 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp7_ = adblock_extension_get_hider_js_for_blocked_resorces (self);
#line 331 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	blocked_js = _tmp7_;
#line 332 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp8_ = blocked_js;
#line 332 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (_tmp8_ != NULL) {
#line 2450 "extension.c"
		MidoriView* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
#line 333 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp9_ = view;
#line 333 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp10_ = blocked_js;
#line 333 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		midori_view_execute_script (_tmp9_, _tmp10_, NULL);
#line 2459 "extension.c"
	}
#line 335 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp11_ = page_uri;
#line 335 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp12_ = adblock_extension_get_hider_css_rules_for_uri (self, _tmp11_);
#line 335 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	style = _tmp12_;
#line 336 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp13_ = style;
#line 336 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (_tmp13_ != NULL) {
#line 2471 "extension.c"
		MidoriView* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
#line 337 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp14_ = view;
#line 337 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp15_ = style;
#line 337 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		midori_tab_inject_stylesheet ((MidoriTab*) _tmp14_, _tmp15_);
#line 2480 "extension.c"
	}
#line 316 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 (style);
#line 316 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 (blocked_js);
#line 2486 "extension.c"
}


static void _adblock_extension_subscriptions_added_removed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 352 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	adblock_extension_subscriptions_added_removed ((AdblockExtension*) self, pspec);
#line 2493 "extension.c"
}


static gboolean _adblock_extension_open_link_gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self) {
	gboolean result;
	result = adblock_extension_open_link ((AdblockExtension*) self, uri);
#line 353 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	return result;
#line 2502 "extension.c"
}


void adblock_extension_init (AdblockExtension* self) {
	GString* _tmp0_ = NULL;
	AdblockConfig* _tmp1_ = NULL;
	AdblockSubscriptionManager* _tmp2_ = NULL;
	AdblockConfig* _tmp3_ = NULL;
	AdblockSubscriptionManager* _tmp4_ = NULL;
	AdblockStatusIcon* _tmp5_ = NULL;
	AdblockConfig* _tmp23_ = NULL;
	AdblockSubscriptionManager* _tmp24_ = NULL;
	GtkLabel* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	GError * _inner_error_ = NULL;
#line 340 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_if_fail (self != NULL);
#line 341 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = g_string_new ("");
#line 341 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_string_free0 (self->hider_selectors);
#line 341 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	self->hider_selectors = _tmp0_;
#line 342 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	adblock_extension_load_config (self);
#line 343 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp1_ = self->config;
#line 343 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp2_ = adblock_subscription_manager_new (_tmp1_);
#line 343 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_adblock_subscription_manager_unref0 (self->manager);
#line 343 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	self->manager = _tmp2_;
#line 344 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp3_ = self->config;
#line 344 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp4_ = self->manager;
#line 344 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp5_ = adblock_status_icon_new (_tmp3_, _tmp4_);
#line 344 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_object_unref0 (self->status_icon);
#line 344 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	self->status_icon = _tmp5_;
#line 2546 "extension.c"
	{
		AdblockConfig* _sub_list = NULL;
		AdblockConfig* _tmp6_ = NULL;
		AdblockConfig* _tmp7_ = NULL;
		guint _sub_size = 0U;
		AdblockConfig* _tmp8_ = NULL;
		guint _tmp9_ = 0U;
		guint _tmp10_ = 0U;
		gint _sub_index = 0;
#line 345 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp6_ = self->config;
#line 345 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp7_ = _g_object_ref0 (_tmp6_);
#line 345 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_sub_list = _tmp7_;
#line 345 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp8_ = _sub_list;
#line 345 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp9_ = adblock_config_get_size (_tmp8_);
#line 345 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp10_ = _tmp9_;
#line 345 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_sub_size = _tmp10_;
#line 345 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_sub_index = -1;
#line 345 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		while (TRUE) {
#line 2574 "extension.c"
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			guint _tmp13_ = 0U;
			AdblockSubscription* sub = NULL;
			AdblockConfig* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			AdblockSubscription* _tmp16_ = NULL;
#line 345 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp11_ = _sub_index;
#line 345 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_sub_index = _tmp11_ + 1;
#line 345 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp12_ = _sub_index;
#line 345 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp13_ = _sub_size;
#line 345 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			if (!(((guint) _tmp12_) < _tmp13_)) {
#line 345 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				break;
#line 2594 "extension.c"
			}
#line 345 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp14_ = _sub_list;
#line 345 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp15_ = _sub_index;
#line 345 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp16_ = adblock_config_get (_tmp14_, (guint) _tmp15_);
#line 345 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			sub = _tmp16_;
#line 2604 "extension.c"
			{
				AdblockSubscription* _tmp17_ = NULL;
#line 347 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp17_ = sub;
#line 347 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				adblock_subscription_parse (_tmp17_, &_inner_error_);
#line 347 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2613 "extension.c"
					goto __catch4_g_error;
				}
			}
			goto __finally4;
			__catch4_g_error:
			{
				GError* _error_ = NULL;
				AdblockSubscription* _tmp18_ = NULL;
				const gchar* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				GError* _tmp21_ = NULL;
				const gchar* _tmp22_ = NULL;
#line 346 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_error_ = _inner_error_;
#line 346 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_inner_error_ = NULL;
#line 349 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp18_ = sub;
#line 349 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp19_ = adblock_subscription_get_uri (_tmp18_);
#line 349 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp20_ = _tmp19_;
#line 349 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp21_ = _error_;
#line 349 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp22_ = _tmp21_->message;
#line 349 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				g_warning ("extension.vala:349: Error parsing %s: %s", _tmp20_, _tmp22_);
#line 346 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_g_error_free0 (_error_);
#line 2644 "extension.c"
			}
			__finally4:
#line 346 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 346 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_g_object_unref0 (_sub_list);
#line 346 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 346 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				g_clear_error (&_inner_error_);
#line 346 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				return;
#line 2657 "extension.c"
			}
		}
#line 345 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_object_unref0 (_sub_list);
#line 2662 "extension.c"
	}
#line 352 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp23_ = self->config;
#line 352 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_signal_connect_object ((GObject*) _tmp23_, "notify::size", (GCallback) _adblock_extension_subscriptions_added_removed_g_object_notify, self, 0);
#line 353 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp24_ = self->manager;
#line 353 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp25_ = _tmp24_->description_label;
#line 353 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_signal_connect_object (_tmp25_, "activate-link", (GCallback) _adblock_extension_open_link_gtk_label_activate_link, self, 0);
#line 355 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp26_ = adblock_extension_fetch_js_hider_function_body (self);
#line 355 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 (self->js_hider_function_body);
#line 355 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	self->js_hider_function_body = _tmp26_;
#line 2680 "extension.c"
}


static gboolean adblock_extension_open_link (AdblockExtension* self, const gchar* uri) {
	gboolean result = FALSE;
	MidoriBrowser* browser = NULL;
	MidoriApp* _tmp0_ = NULL;
	MidoriBrowser* _tmp1_ = NULL;
	MidoriBrowser* _tmp2_ = NULL;
	MidoriBrowser* _tmp3_ = NULL;
	GtkWidget* view = NULL;
	const gchar* _tmp4_ = NULL;
	GtkWidget* _tmp5_ = NULL;
	GtkWidget* _tmp6_ = NULL;
#line 359 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 359 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_val_if_fail (uri != NULL, FALSE);
#line 360 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = midori_extension_get_app ((MidoriExtension*) self);
#line 360 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp1_ = midori_app_get_browser (_tmp0_);
#line 360 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp2_ = _tmp1_;
#line 360 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 360 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	browser = _tmp3_;
#line 361 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp4_ = uri;
#line 361 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp5_ = midori_browser_add_uri (browser, _tmp4_);
#line 361 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 361 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	view = _tmp6_;
#line 362 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	midori_browser_set_tab (browser, view);
#line 363 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	result = TRUE;
#line 363 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_object_unref0 (view);
#line 363 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_object_unref0 (browser);
#line 363 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	return result;
#line 2727 "extension.c"
}


static void adblock_extension_subscriptions_added_removed (AdblockExtension* self, GParamSpec* pspec) {
	GString* _tmp0_ = NULL;
#line 366 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_if_fail (self != NULL);
#line 366 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_if_fail (pspec != NULL);
#line 367 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = g_string_new ("");
#line 367 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_string_free0 (self->hider_selectors);
#line 367 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	self->hider_selectors = _tmp0_;
#line 2743 "extension.c"
}


static void adblock_extension_load_config (AdblockExtension* self) {
	gchar* config_dir = NULL;
	gchar* _tmp0_ = NULL;
	gchar* presets = NULL;
	gchar* _tmp1_ = NULL;
	gchar* filename = NULL;
	gchar* _tmp2_ = NULL;
	AdblockConfig* _tmp3_ = NULL;
	gchar* custom_list = NULL;
	gchar* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 370 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_if_fail (self != NULL);
#line 375 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = midori_paths_get_extension_config_dir ("adblock");
#line 375 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	config_dir = _tmp0_;
#line 377 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp1_ = midori_paths_get_extension_preset_filename ("adblock", "config");
#line 377 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	presets = _tmp1_;
#line 378 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp2_ = g_build_filename (config_dir, "config", NULL);
#line 378 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	filename = _tmp2_;
#line 379 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp3_ = adblock_config_new (filename, presets);
#line 379 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_object_unref0 (self->config);
#line 379 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	self->config = _tmp3_;
#line 380 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp4_ = g_build_filename (config_dir, "custom.list", NULL);
#line 380 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	custom_list = _tmp4_;
#line 2782 "extension.c"
	{
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		AdblockSubscription* _tmp7_ = NULL;
		AdblockSubscription* _tmp8_ = NULL;
		AdblockSubscription* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		AdblockConfig* _tmp11_ = NULL;
		AdblockSubscription* _tmp12_ = NULL;
#line 382 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp6_ = g_filename_to_uri (custom_list, NULL, &_inner_error_);
#line 382 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp5_ = _tmp6_;
#line 382 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2798 "extension.c"
			goto __catch5_g_error;
		}
#line 382 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp7_ = adblock_subscription_new (_tmp5_);
#line 382 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_object_unref0 (self->custom);
#line 382 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		self->custom = _tmp7_;
#line 383 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp8_ = self->custom;
#line 383 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		adblock_subscription_set_mutable (_tmp8_, FALSE);
#line 384 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp9_ = self->custom;
#line 384 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp10_ = _ ("Custom");
#line 384 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		adblock_subscription_set_title (_tmp9_, _tmp10_);
#line 385 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp11_ = self->config;
#line 385 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp12_ = self->custom;
#line 385 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		adblock_config_add (_tmp11_, _tmp12_);
#line 381 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (_tmp5_);
#line 2825 "extension.c"
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
#line 381 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_error_ = _inner_error_;
#line 381 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_inner_error_ = NULL;
#line 387 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_object_unref0 (self->custom);
#line 387 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		self->custom = NULL;
#line 388 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp13_ = _error_;
#line 388 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp14_ = _tmp13_->message;
#line 388 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		g_warning ("extension.vala:388: Failed to add custom list %s: %s", custom_list, _tmp14_);
#line 381 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_error_free0 (_error_);
#line 2849 "extension.c"
	}
	__finally5:
#line 381 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 381 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (custom_list);
#line 381 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (filename);
#line 381 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (presets);
#line 381 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (config_dir);
#line 381 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 381 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		g_clear_error (&_inner_error_);
#line 381 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		return;
#line 2868 "extension.c"
	}
#line 370 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 (custom_list);
#line 370 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 (filename);
#line 370 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 (presets);
#line 370 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 (config_dir);
#line 2878 "extension.c"
}


static AdblockDirective* _adblock_directive_dup (AdblockDirective* self) {
	AdblockDirective* dup;
#line 416 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	dup = g_new0 (AdblockDirective, 1);
#line 416 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	memcpy (dup, self, sizeof (AdblockDirective));
#line 416 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	return dup;
#line 2890 "extension.c"
}


static gpointer __adblock_directive_dup0 (gpointer self) {
#line 416 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	return self ? _adblock_directive_dup (self) : NULL;
#line 2897 "extension.c"
}


static gboolean _adblock_directive_equal (const AdblockDirective* s1, const AdblockDirective* s2) {
#line 417 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (s1 == s2) {
#line 417 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		return TRUE;
#line 2906 "extension.c"
	}
#line 417 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (s1 == NULL) {
#line 417 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		return FALSE;
#line 2912 "extension.c"
	}
#line 417 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (s2 == NULL) {
#line 417 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		return FALSE;
#line 2918 "extension.c"
	}
#line 417 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	return (*s1) == (*s2);
#line 2922 "extension.c"
}


AdblockDirective adblock_extension_get_directive_for_uri (AdblockExtension* self, const gchar* request_uri, const gchar* page_uri) {
	AdblockDirective result = 0;
	AdblockConfig* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	AdblockDirective* directive = NULL;
	AdblockDirective* _tmp28_ = NULL;
	AdblockDirective* _tmp38_ = NULL;
	AdblockDirective _tmp39_ = 0;
#line 392 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 392 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_val_if_fail (request_uri != NULL, 0);
#line 392 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_val_if_fail (page_uri != NULL, 0);
#line 393 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = self->config;
#line 393 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp1_ = adblock_config_get_enabled (_tmp0_);
#line 393 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp2_ = _tmp1_;
#line 393 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (!_tmp2_) {
#line 394 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		result = ADBLOCK_DIRECTIVE_ALLOW;
#line 394 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		return result;
#line 2960 "extension.c"
	}
#line 397 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp3_ = request_uri;
#line 397 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp4_ = page_uri;
#line 397 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
#line 398 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		result = ADBLOCK_DIRECTIVE_ALLOW;
#line 398 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		return result;
#line 2972 "extension.c"
	}
#line 401 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp5_ = page_uri;
#line 401 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp6_ = midori_uri_is_blank (_tmp5_);
#line 401 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (_tmp6_) {
#line 402 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		result = ADBLOCK_DIRECTIVE_ALLOW;
#line 402 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		return result;
#line 2984 "extension.c"
	}
#line 405 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp8_ = request_uri;
#line 405 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp9_ = midori_uri_is_http (_tmp8_);
#line 405 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (!_tmp9_) {
#line 405 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp7_ = TRUE;
#line 2994 "extension.c"
	} else {
		const gchar* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
#line 405 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp10_ = request_uri;
#line 405 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp11_ = g_str_has_suffix (_tmp10_, "favicon.ico");
#line 405 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp7_ = _tmp11_;
#line 3004 "extension.c"
	}
#line 405 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (_tmp7_) {
#line 406 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		result = ADBLOCK_DIRECTIVE_ALLOW;
#line 406 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		return result;
#line 3012 "extension.c"
	}
#line 408 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	directive = NULL;
#line 3016 "extension.c"
	{
		AdblockConfig* _sub_list = NULL;
		AdblockConfig* _tmp12_ = NULL;
		AdblockConfig* _tmp13_ = NULL;
		guint _sub_size = 0U;
		AdblockConfig* _tmp14_ = NULL;
		guint _tmp15_ = 0U;
		guint _tmp16_ = 0U;
		gint _sub_index = 0;
#line 409 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp12_ = self->config;
#line 409 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp13_ = _g_object_ref0 (_tmp12_);
#line 409 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_sub_list = _tmp13_;
#line 409 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp14_ = _sub_list;
#line 409 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp15_ = adblock_config_get_size (_tmp14_);
#line 409 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp16_ = _tmp15_;
#line 409 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_sub_size = _tmp16_;
#line 409 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_sub_index = -1;
#line 409 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		while (TRUE) {
#line 3044 "extension.c"
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
			guint _tmp19_ = 0U;
			AdblockSubscription* sub = NULL;
			AdblockConfig* _tmp20_ = NULL;
			gint _tmp21_ = 0;
			AdblockSubscription* _tmp22_ = NULL;
			AdblockSubscription* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			const gchar* _tmp25_ = NULL;
			AdblockDirective* _tmp26_ = NULL;
			AdblockDirective* _tmp27_ = NULL;
#line 409 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp17_ = _sub_index;
#line 409 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_sub_index = _tmp17_ + 1;
#line 409 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp18_ = _sub_index;
#line 409 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp19_ = _sub_size;
#line 409 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			if (!(((guint) _tmp18_) < _tmp19_)) {
#line 409 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				break;
#line 3069 "extension.c"
			}
#line 409 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp20_ = _sub_list;
#line 409 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp21_ = _sub_index;
#line 409 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp22_ = adblock_config_get (_tmp20_, (guint) _tmp21_);
#line 409 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			sub = _tmp22_;
#line 410 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp23_ = sub;
#line 410 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp24_ = request_uri;
#line 410 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp25_ = page_uri;
#line 410 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp26_ = adblock_subscription_get_directive (_tmp23_, _tmp24_, _tmp25_);
#line 410 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_g_free0 (directive);
#line 410 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			directive = _tmp26_;
#line 411 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp27_ = directive;
#line 411 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			if (_tmp27_ != NULL) {
#line 412 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				break;
#line 3097 "extension.c"
			}
		}
#line 409 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_object_unref0 (_sub_list);
#line 3102 "extension.c"
	}
#line 415 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp28_ = directive;
#line 415 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (_tmp28_ == NULL) {
#line 3108 "extension.c"
		AdblockDirective _tmp29_ = 0;
		AdblockDirective* _tmp30_ = NULL;
#line 416 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp29_ = ADBLOCK_DIRECTIVE_ALLOW;
#line 416 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp30_ = __adblock_directive_dup0 (&_tmp29_);
#line 416 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (directive);
#line 416 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		directive = _tmp30_;
#line 3119 "extension.c"
	} else {
		AdblockDirective* _tmp31_ = NULL;
		AdblockDirective _tmp32_ = 0;
#line 417 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp31_ = directive;
#line 417 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp32_ = ADBLOCK_DIRECTIVE_BLOCK;
#line 417 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		if (_adblock_directive_equal (_tmp31_, &_tmp32_) == TRUE) {
#line 3129 "extension.c"
			AdblockStatusIcon* _tmp33_ = NULL;
			GString* _tmp34_ = NULL;
			const gchar* _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			gchar* _tmp37_ = NULL;
#line 418 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp33_ = self->status_icon;
#line 418 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			adblock_status_icon_set_state (_tmp33_, ADBLOCK_STATE_BLOCKED);
#line 422 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp34_ = self->hider_selectors;
#line 422 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp35_ = request_uri;
#line 422 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp36_ = g_strdup_printf (" uris.push ('%s');\n", _tmp35_);
#line 422 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp37_ = _tmp36_;
#line 422 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			g_string_append (_tmp34_, _tmp37_);
#line 422 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_g_free0 (_tmp37_);
#line 3151 "extension.c"
		}
	}
#line 425 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp38_ = directive;
#line 425 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp39_ = *_tmp38_;
#line 425 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 (_tmp38_);
#line 425 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	result = _tmp39_;
#line 425 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	return result;
#line 3164 "extension.c"
}


gboolean adblock_extension_request_handled (AdblockExtension* self, const gchar* request_uri, const gchar* page_uri) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	AdblockDirective _tmp2_ = 0;
#line 428 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 428 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_val_if_fail (request_uri != NULL, FALSE);
#line 428 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_val_if_fail (page_uri != NULL, FALSE);
#line 429 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = request_uri;
#line 429 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp1_ = page_uri;
#line 429 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp2_ = adblock_extension_get_directive_for_uri (self, _tmp0_, _tmp1_);
#line 429 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	result = _tmp2_ == ADBLOCK_DIRECTIVE_BLOCK;
#line 429 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	return result;
#line 3189 "extension.c"
}


static void adblock_extension_class_init (AdblockExtensionClass * klass) {
#line 47 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	adblock_extension_parent_class = g_type_class_peek_parent (klass);
#line 47 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	G_OBJECT_CLASS (klass)->finalize = adblock_extension_finalize;
#line 3198 "extension.c"
}


static void adblock_extension_instance_init (AdblockExtension * self) {
}


static void adblock_extension_finalize (GObject* obj) {
	AdblockExtension * self;
#line 47 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ADBLOCK_TYPE_EXTENSION, AdblockExtension);
#line 48 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_object_unref0 (self->config);
#line 49 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_object_unref0 (self->custom);
#line 50 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_string_free0 (self->hider_selectors);
#line 51 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_object_unref0 (self->status_icon);
#line 52 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_adblock_subscription_manager_unref0 (self->manager);
#line 55 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 (self->js_hider_function_body);
#line 47 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	G_OBJECT_CLASS (adblock_extension_parent_class)->finalize (obj);
#line 3224 "extension.c"
}


GType adblock_extension_get_type (void) {
	static volatile gsize adblock_extension_type_id__volatile = 0;
	if (g_once_init_enter (&adblock_extension_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AdblockExtensionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) adblock_extension_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AdblockExtension), 0, (GInstanceInitFunc) adblock_extension_instance_init, NULL };
		GType adblock_extension_type_id;
		adblock_extension_type_id = g_type_register_static (MIDORI_TYPE_EXTENSION, "AdblockExtension", &g_define_type_info, 0);
		g_once_init_leave (&adblock_extension_type_id__volatile, adblock_extension_type_id);
	}
	return adblock_extension_type_id__volatile;
}


void adblock_debug (const gchar* format, ...) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean debug_match = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	va_list args = {0};
	FILE* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
#line 433 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_if_fail (format != NULL);
#line 434 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp1_ = g_getenv ("MIDORI_DEBUG");
#line 434 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = _tmp1_;
#line 434 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (_tmp0_ == NULL) {
#line 434 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp0_ = "";
#line 3261 "extension.c"
	}
#line 434 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp2_ = string_contains (_tmp0_, "adblock:match");
#line 434 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	debug_match = _tmp2_;
#line 435 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp3_ = debug_match;
#line 435 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (!_tmp3_) {
#line 436 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		return;
#line 3273 "extension.c"
	}
#line 438 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	va_start (args, format);
#line 439 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp4_ = stdout;
#line 439 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp5_ = format;
#line 439 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp6_ = g_strconcat (_tmp5_, "\n", NULL);
#line 439 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp7_ = _tmp6_;
#line 439 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	vfprintf (_tmp4_, _tmp7_, args);
#line 439 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 (_tmp7_);
#line 433 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	va_end (args);
#line 3291 "extension.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 996 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 997 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 997 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 997 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 997 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	return result;
#line 3309 "extension.c"
}


gchar* adblock_fixup_regex (const gchar* prefix, const gchar* src) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	GString* fixed = NULL;
	GString* _tmp1_ = NULL;
	GString* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	guint i = 0U;
	const gchar* _tmp4_ = NULL;
	gchar _tmp5_ = '\0';
	guint l = 0U;
	const gchar* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	GString* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
#line 442 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_val_if_fail (prefix != NULL, NULL);
#line 443 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = src;
#line 443 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (_tmp0_ == NULL) {
#line 444 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		result = NULL;
#line 444 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		return result;
#line 3340 "extension.c"
	}
#line 446 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp1_ = g_string_new ("");
#line 446 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	fixed = _tmp1_;
#line 447 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp2_ = fixed;
#line 447 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp3_ = prefix;
#line 447 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_string_append (_tmp2_, _tmp3_);
#line 449 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	i = (guint) 0;
#line 450 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp4_ = src;
#line 450 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp5_ = string_get (_tmp4_, (glong) 0);
#line 450 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (_tmp5_ == '*') {
#line 3360 "extension.c"
		guint _tmp6_ = 0U;
#line 451 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp6_ = i;
#line 451 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		i = _tmp6_ + 1;
#line 3366 "extension.c"
	}
#line 452 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp7_ = src;
#line 452 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp8_ = strlen (_tmp7_);
#line 452 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp9_ = _tmp8_;
#line 452 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	l = (guint) _tmp9_;
#line 453 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	while (TRUE) {
#line 3378 "extension.c"
		guint _tmp10_ = 0U;
		guint _tmp11_ = 0U;
		gchar c = '\0';
		const gchar* _tmp12_ = NULL;
		guint _tmp13_ = 0U;
		gchar _tmp14_ = '\0';
		gchar _tmp15_ = '\0';
		guint _tmp21_ = 0U;
#line 453 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp10_ = i;
#line 453 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp11_ = l;
#line 453 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		if (!(_tmp10_ < _tmp11_)) {
#line 453 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			break;
#line 3395 "extension.c"
		}
#line 454 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp12_ = src;
#line 454 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp13_ = i;
#line 454 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp14_ = string_get (_tmp12_, (glong) _tmp13_);
#line 454 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		c = _tmp14_;
#line 455 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp15_ = c;
#line 455 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		switch (_tmp15_) {
#line 455 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			case '*':
#line 3411 "extension.c"
			{
				GString* _tmp16_ = NULL;
#line 457 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp16_ = fixed;
#line 457 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				g_string_append (_tmp16_, ".*");
#line 457 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				break;
#line 3420 "extension.c"
			}
#line 455 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			case '|':
#line 455 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			case '^':
#line 455 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			case '+':
#line 3428 "extension.c"
			{
#line 461 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				break;
#line 3432 "extension.c"
			}
#line 455 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			case '?':
#line 455 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			case '[':
#line 455 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			case ']':
#line 455 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			case '.':
#line 455 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			case '(':
#line 455 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			case ')':
#line 3446 "extension.c"
			{
				GString* _tmp17_ = NULL;
				gchar _tmp18_ = '\0';
#line 468 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp17_ = fixed;
#line 468 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp18_ = c;
#line 468 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				g_string_append_printf (_tmp17_, "\\%c", (gint) _tmp18_);
#line 468 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				break;
#line 3458 "extension.c"
			}
			default:
			{
				GString* _tmp19_ = NULL;
				gchar _tmp20_ = '\0';
#line 470 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp19_ = fixed;
#line 470 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp20_ = c;
#line 470 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				g_string_append_c (_tmp19_, _tmp20_);
#line 470 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				break;
#line 3472 "extension.c"
			}
		}
#line 472 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp21_ = i;
#line 472 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		i = _tmp21_ + 1;
#line 3479 "extension.c"
	}
#line 474 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp22_ = fixed;
#line 474 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp23_ = _tmp22_->str;
#line 474 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp24_ = g_strdup (_tmp23_);
#line 474 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	result = _tmp24_;
#line 474 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_string_free0 (fixed);
#line 474 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	return result;
#line 3493 "extension.c"
}


MidoriExtension* extension_init (void) {
	MidoriExtension* result = NULL;
	AdblockExtension* _tmp0_ = NULL;
#line 488 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = adblock_extension_new ();
#line 488 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	result = (MidoriExtension*) _tmp0_;
#line 488 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	return result;
#line 3506 "extension.c"
}


gchar* get_test_file (const gchar* contents) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* checksum = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* file = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 492 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_return_val_if_fail (contents != NULL, NULL);
#line 493 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = tmp_folder;
#line 493 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (_tmp0_ == NULL) {
#line 3526 "extension.c"
		gchar* _tmp1_ = NULL;
#line 494 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp1_ = midori_paths_make_tmp_dir ("adblockXXXXXX");
#line 494 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (tmp_folder);
#line 494 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		tmp_folder = _tmp1_;
#line 3534 "extension.c"
	}
#line 495 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp2_ = contents;
#line 495 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp3_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp2_, (gsize) -1);
#line 495 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	checksum = _tmp3_;
#line 496 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp4_ = tmp_folder;
#line 496 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp5_ = g_build_path (G_DIR_SEPARATOR_S, _tmp4_, checksum, NULL);
#line 496 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	file = _tmp5_;
#line 3548 "extension.c"
	{
		const gchar* _tmp6_ = NULL;
#line 498 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp6_ = contents;
#line 498 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		g_file_set_contents (file, _tmp6_, (gssize) -1, &_inner_error_);
#line 498 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3557 "extension.c"
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* file_error = NULL;
		const gchar* _tmp7_ = NULL;
#line 497 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		file_error = _inner_error_;
#line 497 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_inner_error_ = NULL;
#line 500 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp7_ = file_error->message;
#line 500 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		g_error ("extension.vala:500: %s", _tmp7_);
#line 497 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_error_free0 (file_error);
#line 3576 "extension.c"
	}
	__finally6:
#line 497 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 497 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (file);
#line 497 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (checksum);
#line 497 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 497 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		g_clear_error (&_inner_error_);
#line 497 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		return NULL;
#line 3591 "extension.c"
	}
#line 502 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	result = file;
#line 502 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 (checksum);
#line 502 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	return result;
#line 3599 "extension.c"
}


void test_case_config_copy (const TestCaseConfig* self, TestCaseConfig* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	gboolean _tmp3_ = FALSE;
#line 505 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = (*self).content;
#line 505 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 505 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 ((*dest).content);
#line 505 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	(*dest).content = _tmp1_;
#line 505 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp2_ = (*self).size;
#line 505 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	(*dest).size = _tmp2_;
#line 505 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp3_ = (*self).enabled;
#line 505 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	(*dest).enabled = _tmp3_;
#line 3624 "extension.c"
}


void test_case_config_destroy (TestCaseConfig* self) {
#line 506 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 ((*self).content);
#line 3631 "extension.c"
}


TestCaseConfig* test_case_config_dup (const TestCaseConfig* self) {
	TestCaseConfig* dup;
#line 505 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	dup = g_new0 (TestCaseConfig, 1);
#line 505 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	test_case_config_copy (self, dup);
#line 505 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	return dup;
#line 3643 "extension.c"
}


void test_case_config_free (TestCaseConfig* self) {
#line 505 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	test_case_config_destroy (self);
#line 505 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_free (self);
#line 3652 "extension.c"
}


GType test_case_config_get_type (void) {
	static volatile gsize test_case_config_type_id__volatile = 0;
	if (g_once_init_enter (&test_case_config_type_id__volatile)) {
		GType test_case_config_type_id;
		test_case_config_type_id = g_boxed_type_register_static ("TestCaseConfig", (GBoxedCopyFunc) test_case_config_dup, (GBoxedFreeFunc) test_case_config_free);
		g_once_init_leave (&test_case_config_type_id__volatile, test_case_config_type_id);
	}
	return test_case_config_type_id__volatile;
}


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
#line 37 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	if (self) {
#line 3671 "extension.c"
		gchar* _tmp0_ = NULL;
#line 38 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp0_ = g_strdup ("true");
#line 38 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		result = _tmp0_;
#line 38 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 3679 "extension.c"
	} else {
		gchar* _tmp1_ = NULL;
#line 40 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		_tmp1_ = g_strdup ("false");
#line 40 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		result = _tmp1_;
#line 40 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		return result;
#line 3688 "extension.c"
	}
}


void test_adblock_config (void) {
	AdblockConfig* _tmp0_ = NULL;
	AdblockConfig* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
#line 519 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = adblock_config_new (NULL, NULL);
#line 519 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp1_ = _tmp0_;
#line 519 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp2_ = adblock_config_get_size (_tmp1_);
#line 519 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp3_ = _tmp2_;
#line 519 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (_tmp3_ == ((guint) 0), "new Adblock.Config (null, null).size == 0");
#line 519 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_object_unref0 (_tmp1_);
#line 3710 "extension.c"
	{
		TestCaseConfig* conf_collection = NULL;
		gint conf_collection_length1 = 0;
		gint _conf_collection_size_ = 0;
		gint conf_it = 0;
#line 521 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		conf_collection = configs;
#line 521 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		conf_collection_length1 = G_N_ELEMENTS (configs);
#line 521 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		for (conf_it = 0; conf_it < G_N_ELEMENTS (configs); conf_it = conf_it + 1) {
#line 3722 "extension.c"
			TestCaseConfig conf = {0};
#line 521 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			conf = conf_collection[conf_it];
#line 3726 "extension.c"
			{
				AdblockConfig* config = NULL;
				TestCaseConfig _tmp4_ = {0};
				const gchar* _tmp5_ = NULL;
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_ = NULL;
				AdblockConfig* _tmp8_ = NULL;
				AdblockConfig* _tmp9_ = NULL;
				AdblockConfig* _tmp10_ = NULL;
				guint _tmp11_ = 0U;
				guint _tmp12_ = 0U;
				TestCaseConfig _tmp13_ = {0};
				guint _tmp14_ = 0U;
				AdblockConfig* _tmp26_ = NULL;
				gboolean _tmp27_ = FALSE;
				gboolean _tmp28_ = FALSE;
				TestCaseConfig _tmp29_ = {0};
				gboolean _tmp30_ = FALSE;
#line 522 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp4_ = conf;
#line 522 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp5_ = _tmp4_.content;
#line 522 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp6_ = get_test_file (_tmp5_);
#line 522 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp7_ = _tmp6_;
#line 522 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp8_ = adblock_config_new (_tmp7_, NULL);
#line 522 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp9_ = _tmp8_;
#line 522 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_g_free0 (_tmp7_);
#line 522 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				config = _tmp9_;
#line 523 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp10_ = config;
#line 523 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp11_ = adblock_config_get_size (_tmp10_);
#line 523 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp12_ = _tmp11_;
#line 523 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp13_ = conf;
#line 523 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp14_ = _tmp13_.size;
#line 523 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				if (_tmp12_ != _tmp14_) {
#line 3773 "extension.c"
					AdblockConfig* _tmp15_ = NULL;
					guint _tmp16_ = 0U;
					guint _tmp17_ = 0U;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					TestCaseConfig _tmp20_ = {0};
					guint _tmp21_ = 0U;
					gchar* _tmp22_ = NULL;
					gchar* _tmp23_ = NULL;
					TestCaseConfig _tmp24_ = {0};
					const gchar* _tmp25_ = NULL;
#line 524 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp15_ = config;
#line 524 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp16_ = adblock_config_get_size (_tmp15_);
#line 524 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp17_ = _tmp16_;
#line 524 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp18_ = g_strdup_printf ("%u", _tmp17_);
#line 524 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp19_ = _tmp18_;
#line 524 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp20_ = conf;
#line 524 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp21_ = _tmp20_.size;
#line 524 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp22_ = g_strdup_printf ("%u", _tmp21_);
#line 524 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp23_ = _tmp22_;
#line 524 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp24_ = conf;
#line 524 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp25_ = _tmp24_.content;
#line 524 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					g_error ("extension.vala:524: Wrong size %s rather than %s:\n%s", _tmp19_, _tmp23_, _tmp25_);
#line 524 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_g_free0 (_tmp23_);
#line 524 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_g_free0 (_tmp19_);
#line 3813 "extension.c"
				}
#line 526 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp26_ = config;
#line 526 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp27_ = adblock_config_get_enabled (_tmp26_);
#line 526 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp28_ = _tmp27_;
#line 526 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp29_ = conf;
#line 526 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp30_ = _tmp29_.enabled;
#line 526 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				if (_tmp28_ != _tmp30_) {
#line 3827 "extension.c"
					AdblockConfig* _tmp31_ = NULL;
					gboolean _tmp32_ = FALSE;
					gboolean _tmp33_ = FALSE;
					gchar* _tmp34_ = NULL;
					gchar* _tmp35_ = NULL;
					TestCaseConfig _tmp36_ = {0};
					gboolean _tmp37_ = FALSE;
					gchar* _tmp38_ = NULL;
					gchar* _tmp39_ = NULL;
					TestCaseConfig _tmp40_ = {0};
					const gchar* _tmp41_ = NULL;
#line 527 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp31_ = config;
#line 527 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp32_ = adblock_config_get_enabled (_tmp31_);
#line 527 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp33_ = _tmp32_;
#line 527 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp34_ = bool_to_string (_tmp33_);
#line 527 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp35_ = _tmp34_;
#line 527 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp36_ = conf;
#line 527 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp37_ = _tmp36_.enabled;
#line 527 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp38_ = bool_to_string (_tmp37_);
#line 527 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp39_ = _tmp38_;
#line 527 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp40_ = conf;
#line 527 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp41_ = _tmp40_.content;
#line 527 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					g_error ("extension.vala:527: Wrongly got enabled=%s rather than %s:\n%s", _tmp35_, _tmp39_, _tmp41_);
#line 527 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_g_free0 (_tmp39_);
#line 527 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_g_free0 (_tmp35_);
#line 3867 "extension.c"
				}
#line 521 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_g_object_unref0 (config);
#line 3871 "extension.c"
			}
		}
	}
}


void test_case_sub_copy (const TestCaseSub* self, TestCaseSub* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 532 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = (*self).uri;
#line 532 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 532 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 ((*dest).uri);
#line 532 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	(*dest).uri = _tmp1_;
#line 532 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp2_ = (*self).active;
#line 532 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	(*dest).active = _tmp2_;
#line 3894 "extension.c"
}


void test_case_sub_destroy (TestCaseSub* self) {
#line 533 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 ((*self).uri);
#line 3901 "extension.c"
}


TestCaseSub* test_case_sub_dup (const TestCaseSub* self) {
	TestCaseSub* dup;
#line 532 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	dup = g_new0 (TestCaseSub, 1);
#line 532 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	test_case_sub_copy (self, dup);
#line 532 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	return dup;
#line 3913 "extension.c"
}


void test_case_sub_free (TestCaseSub* self) {
#line 532 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	test_case_sub_destroy (self);
#line 532 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_free (self);
#line 3922 "extension.c"
}


GType test_case_sub_get_type (void) {
	static volatile gsize test_case_sub_type_id__volatile = 0;
	if (g_once_init_enter (&test_case_sub_type_id__volatile)) {
		GType test_case_sub_type_id;
		test_case_sub_type_id = g_boxed_type_register_static ("TestCaseSub", (GBoxedCopyFunc) test_case_sub_dup, (GBoxedFreeFunc) test_case_sub_free);
		g_once_init_leave (&test_case_sub_type_id__volatile, test_case_sub_type_id);
	}
	return test_case_sub_type_id__volatile;
}


void test_adblock_subs (void) {
	AdblockConfig* config = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	AdblockConfig* _tmp2_ = NULL;
	AdblockConfig* _tmp3_ = NULL;
	AdblockConfig* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	AdblockConfig* _tmp31_ = NULL;
	guint _tmp32_ = 0U;
	guint _tmp33_ = 0U;
	AdblockConfig* _tmp34_ = NULL;
	AdblockSubscription* _tmp35_ = NULL;
	AdblockSubscription* _tmp36_ = NULL;
	gboolean _tmp37_ = FALSE;
	AdblockConfig* _tmp38_ = NULL;
	AdblockConfig* copy = NULL;
	AdblockConfig* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	const gchar* _tmp41_ = NULL;
	AdblockConfig* _tmp42_ = NULL;
	AdblockConfig* _tmp43_ = NULL;
	guint _tmp44_ = 0U;
	guint _tmp45_ = 0U;
	AdblockConfig* _tmp46_ = NULL;
	guint _tmp47_ = 0U;
	guint _tmp48_ = 0U;
	AdblockConfig* _tmp49_ = NULL;
	gboolean _tmp50_ = FALSE;
	gboolean _tmp51_ = FALSE;
	AdblockConfig* _tmp52_ = NULL;
	gboolean _tmp53_ = FALSE;
	gboolean _tmp54_ = FALSE;
	AdblockConfig* _tmp81_ = NULL;
	AdblockConfig* _tmp82_ = NULL;
	const gchar* _tmp83_ = NULL;
	const gchar* _tmp84_ = NULL;
	AdblockConfig* _tmp85_ = NULL;
	AdblockConfig* _tmp86_ = NULL;
	gboolean _tmp87_ = FALSE;
	gboolean _tmp88_ = FALSE;
	AdblockConfig* _tmp89_ = NULL;
	gboolean _tmp90_ = FALSE;
	gboolean _tmp91_ = FALSE;
	AdblockConfig* _tmp107_ = NULL;
	const gchar* _tmp108_ = NULL;
	const gchar* _tmp109_ = NULL;
	AdblockConfig* _tmp110_ = NULL;
	AdblockSubscription* s = NULL;
	AdblockSubscription* _tmp149_ = NULL;
	AdblockConfig* _tmp150_ = NULL;
	gboolean _tmp151_ = FALSE;
	AdblockConfig* _tmp152_ = NULL;
	guint _tmp153_ = 0U;
	guint _tmp154_ = 0U;
	AdblockConfig* _tmp155_ = NULL;
	AdblockConfig* _tmp156_ = NULL;
	guint _tmp157_ = 0U;
	guint _tmp158_ = 0U;
	AdblockConfig* _tmp159_ = NULL;
	gboolean _tmp160_ = FALSE;
	AdblockConfig* _tmp161_ = NULL;
	guint _tmp162_ = 0U;
	guint _tmp163_ = 0U;
	GError * _inner_error_ = NULL;
#line 547 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = get_test_file ("\n" \
"[settings]\n" \
"filters=http://foo.com;http-//bar.com;https://spam.com;http-://eggs.co" \
"m;file:///bla;file-///blub;http://foo.com;\n");
#line 547 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp1_ = _tmp0_;
#line 547 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp2_ = adblock_config_new (_tmp1_, NULL);
#line 547 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp3_ = _tmp2_;
#line 547 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 (_tmp1_);
#line 547 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	config = _tmp3_;
#line 552 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp4_ = config;
#line 552 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp5_ = adblock_config_get_enabled (_tmp4_);
#line 552 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp6_ = _tmp5_;
#line 552 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (_tmp6_, "config.enabled");
#line 4023 "extension.c"
	{
		TestCaseSub* sub_collection = NULL;
		gint sub_collection_length1 = 0;
		gint _sub_collection_size_ = 0;
		gint sub_it = 0;
#line 553 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		sub_collection = subs;
#line 553 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		sub_collection_length1 = G_N_ELEMENTS (subs);
#line 553 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		for (sub_it = 0; sub_it < G_N_ELEMENTS (subs); sub_it = sub_it + 1) {
#line 4035 "extension.c"
			TestCaseSub sub = {0};
#line 553 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			sub = sub_collection[sub_it];
#line 4039 "extension.c"
			{
				gboolean found = FALSE;
				gboolean _tmp28_ = FALSE;
#line 554 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				found = FALSE;
#line 4045 "extension.c"
				{
					AdblockConfig* _subscription_list = NULL;
					AdblockConfig* _tmp7_ = NULL;
					AdblockConfig* _tmp8_ = NULL;
					guint _subscription_size = 0U;
					AdblockConfig* _tmp9_ = NULL;
					guint _tmp10_ = 0U;
					guint _tmp11_ = 0U;
					gint _subscription_index = 0;
#line 555 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp7_ = config;
#line 555 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp8_ = _g_object_ref0 (_tmp7_);
#line 555 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_subscription_list = _tmp8_;
#line 555 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp9_ = _subscription_list;
#line 555 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp10_ = adblock_config_get_size (_tmp9_);
#line 555 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp11_ = _tmp10_;
#line 555 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_subscription_size = _tmp11_;
#line 555 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_subscription_index = -1;
#line 555 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					while (TRUE) {
#line 4073 "extension.c"
						gint _tmp12_ = 0;
						gint _tmp13_ = 0;
						guint _tmp14_ = 0U;
						AdblockSubscription* subscription = NULL;
						AdblockConfig* _tmp15_ = NULL;
						gint _tmp16_ = 0;
						AdblockSubscription* _tmp17_ = NULL;
						AdblockSubscription* _tmp18_ = NULL;
						const gchar* _tmp19_ = NULL;
						const gchar* _tmp20_ = NULL;
						TestCaseSub _tmp21_ = {0};
						const gchar* _tmp22_ = NULL;
#line 555 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						_tmp12_ = _subscription_index;
#line 555 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						_subscription_index = _tmp12_ + 1;
#line 555 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						_tmp13_ = _subscription_index;
#line 555 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						_tmp14_ = _subscription_size;
#line 555 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						if (!(((guint) _tmp13_) < _tmp14_)) {
#line 555 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
							break;
#line 4098 "extension.c"
						}
#line 555 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						_tmp15_ = _subscription_list;
#line 555 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						_tmp16_ = _subscription_index;
#line 555 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						_tmp17_ = adblock_config_get (_tmp15_, (guint) _tmp16_);
#line 555 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						subscription = _tmp17_;
#line 556 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						_tmp18_ = subscription;
#line 556 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						_tmp19_ = adblock_subscription_get_uri (_tmp18_);
#line 556 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						_tmp20_ = _tmp19_;
#line 556 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						_tmp21_ = sub;
#line 556 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						_tmp22_ = _tmp21_.uri;
#line 556 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						if (g_strcmp0 (_tmp20_, _tmp22_) == 0) {
#line 4120 "extension.c"
							AdblockSubscription* _tmp23_ = NULL;
							gboolean _tmp24_ = FALSE;
							gboolean _tmp25_ = FALSE;
							TestCaseSub _tmp26_ = {0};
							gboolean _tmp27_ = FALSE;
#line 557 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
							_tmp23_ = subscription;
#line 557 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
							_tmp24_ = adblock_subscription_get_active (_tmp23_);
#line 557 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
							_tmp25_ = _tmp24_;
#line 557 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
							_tmp26_ = sub;
#line 557 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
							_tmp27_ = _tmp26_.active;
#line 557 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
							_vala_assert (_tmp25_ == _tmp27_, "subscription.active == sub.active");
#line 558 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
							found = TRUE;
#line 4140 "extension.c"
						}
					}
#line 555 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_g_object_unref0 (_subscription_list);
#line 4145 "extension.c"
				}
#line 561 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp28_ = found;
#line 561 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				if (!_tmp28_) {
#line 4151 "extension.c"
					TestCaseSub _tmp29_ = {0};
					const gchar* _tmp30_ = NULL;
#line 562 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp29_ = sub;
#line 562 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp30_ = _tmp29_.uri;
#line 562 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					g_error ("extension.vala:562: %s not found", _tmp30_);
#line 4160 "extension.c"
				}
			}
		}
	}
#line 566 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp31_ = config;
#line 566 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp32_ = adblock_config_get_size (_tmp31_);
#line 566 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp33_ = _tmp32_;
#line 566 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (_tmp33_ == ((guint) 6), "config.size == 6");
#line 568 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp34_ = config;
#line 568 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp35_ = adblock_subscription_new ("https://spam.com");
#line 568 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp36_ = _tmp35_;
#line 568 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp37_ = adblock_config_add (_tmp34_, _tmp36_);
#line 568 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (!_tmp37_, "!config.add (new Adblock.Subscription (\"https://spam.com\"))");
#line 568 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_object_unref0 (_tmp36_);
#line 571 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp38_ = config;
#line 571 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	adblock_config_save (_tmp38_);
#line 572 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp39_ = config;
#line 572 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp40_ = adblock_config_get_path (_tmp39_);
#line 572 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp41_ = _tmp40_;
#line 572 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp42_ = adblock_config_new (_tmp41_, NULL);
#line 572 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	copy = _tmp42_;
#line 573 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp43_ = copy;
#line 573 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp44_ = adblock_config_get_size (_tmp43_);
#line 573 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp45_ = _tmp44_;
#line 573 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp46_ = config;
#line 573 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp47_ = adblock_config_get_size (_tmp46_);
#line 573 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp48_ = _tmp47_;
#line 573 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (_tmp45_ == _tmp48_, "copy.size == config.size");
#line 574 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp49_ = copy;
#line 574 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp50_ = adblock_config_get_enabled (_tmp49_);
#line 574 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp51_ = _tmp50_;
#line 574 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp52_ = config;
#line 574 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp53_ = adblock_config_get_enabled (_tmp52_);
#line 574 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp54_ = _tmp53_;
#line 574 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (_tmp51_ == _tmp54_, "copy.enabled == config.enabled");
#line 4227 "extension.c"
	{
		gint i = 0;
#line 575 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		i = 0;
#line 4232 "extension.c"
		{
			gboolean _tmp55_ = FALSE;
#line 575 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp55_ = TRUE;
#line 575 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			while (TRUE) {
#line 4239 "extension.c"
				gint _tmp57_ = 0;
				AdblockConfig* _tmp58_ = NULL;
				guint _tmp59_ = 0U;
				guint _tmp60_ = 0U;
				AdblockConfig* _tmp61_ = NULL;
				gint _tmp62_ = 0;
				AdblockSubscription* _tmp63_ = NULL;
				const gchar* _tmp64_ = NULL;
				const gchar* _tmp65_ = NULL;
				AdblockConfig* _tmp66_ = NULL;
				gint _tmp67_ = 0;
				AdblockSubscription* _tmp68_ = NULL;
				const gchar* _tmp69_ = NULL;
				const gchar* _tmp70_ = NULL;
				AdblockConfig* _tmp71_ = NULL;
				gint _tmp72_ = 0;
				AdblockSubscription* _tmp73_ = NULL;
				gboolean _tmp74_ = FALSE;
				gboolean _tmp75_ = FALSE;
				AdblockConfig* _tmp76_ = NULL;
				gint _tmp77_ = 0;
				AdblockSubscription* _tmp78_ = NULL;
				gboolean _tmp79_ = FALSE;
				gboolean _tmp80_ = FALSE;
#line 575 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				if (!_tmp55_) {
#line 4266 "extension.c"
					gint _tmp56_ = 0;
#line 575 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp56_ = i;
#line 575 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					i = _tmp56_ + 1;
#line 4272 "extension.c"
				}
#line 575 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp55_ = FALSE;
#line 575 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp57_ = i;
#line 575 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp58_ = config;
#line 575 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp59_ = adblock_config_get_size (_tmp58_);
#line 575 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp60_ = _tmp59_;
#line 575 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				if (!(((guint) _tmp57_) < _tmp60_)) {
#line 575 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					break;
#line 4288 "extension.c"
				}
#line 576 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp61_ = copy;
#line 576 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp62_ = i;
#line 576 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp63_ = adblock_config_get (_tmp61_, (guint) _tmp62_);
#line 576 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp64_ = adblock_subscription_get_uri (_tmp63_);
#line 576 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp65_ = _tmp64_;
#line 576 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp66_ = config;
#line 576 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp67_ = i;
#line 576 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp68_ = adblock_config_get (_tmp66_, (guint) _tmp67_);
#line 576 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp69_ = adblock_subscription_get_uri (_tmp68_);
#line 576 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp70_ = _tmp69_;
#line 576 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_vala_assert (g_strcmp0 (_tmp65_, _tmp70_) == 0, "copy[i].uri == config[i].uri");
#line 577 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp71_ = copy;
#line 577 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp72_ = i;
#line 577 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp73_ = adblock_config_get (_tmp71_, (guint) _tmp72_);
#line 577 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp74_ = adblock_subscription_get_active (_tmp73_);
#line 577 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp75_ = _tmp74_;
#line 577 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp76_ = config;
#line 577 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp77_ = i;
#line 577 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp78_ = adblock_config_get (_tmp76_, (guint) _tmp77_);
#line 577 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp79_ = adblock_subscription_get_active (_tmp78_);
#line 577 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp80_ = _tmp79_;
#line 577 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_vala_assert (_tmp75_ == _tmp80_, "copy[i].active == config[i].active");
#line 4334 "extension.c"
			}
		}
	}
#line 580 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp81_ = config;
#line 580 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	adblock_config_set_enabled (_tmp81_, FALSE);
#line 581 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp82_ = config;
#line 581 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp83_ = adblock_config_get_path (_tmp82_);
#line 581 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp84_ = _tmp83_;
#line 581 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp85_ = adblock_config_new (_tmp84_, NULL);
#line 581 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_object_unref0 (copy);
#line 581 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	copy = _tmp85_;
#line 582 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp86_ = copy;
#line 582 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp87_ = adblock_config_get_enabled (_tmp86_);
#line 582 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp88_ = _tmp87_;
#line 582 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp89_ = config;
#line 582 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp90_ = adblock_config_get_enabled (_tmp89_);
#line 582 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp91_ = _tmp90_;
#line 582 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (_tmp88_ == _tmp91_, "copy.enabled == config.enabled");
#line 4368 "extension.c"
	{
		AdblockConfig* _sub_list = NULL;
		AdblockConfig* _tmp92_ = NULL;
		AdblockConfig* _tmp93_ = NULL;
		guint _sub_size = 0U;
		AdblockConfig* _tmp94_ = NULL;
		guint _tmp95_ = 0U;
		guint _tmp96_ = 0U;
		gint _sub_index = 0;
#line 584 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp92_ = config;
#line 584 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp93_ = _g_object_ref0 (_tmp92_);
#line 584 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_sub_list = _tmp93_;
#line 584 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp94_ = _sub_list;
#line 584 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp95_ = adblock_config_get_size (_tmp94_);
#line 584 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp96_ = _tmp95_;
#line 584 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_sub_size = _tmp96_;
#line 584 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_sub_index = -1;
#line 584 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		while (TRUE) {
#line 4396 "extension.c"
			gint _tmp97_ = 0;
			gint _tmp98_ = 0;
			guint _tmp99_ = 0U;
			AdblockSubscription* sub = NULL;
			AdblockConfig* _tmp100_ = NULL;
			gint _tmp101_ = 0;
			AdblockSubscription* _tmp102_ = NULL;
			AdblockSubscription* _tmp103_ = NULL;
			AdblockSubscription* _tmp104_ = NULL;
			gboolean _tmp105_ = FALSE;
			gboolean _tmp106_ = FALSE;
#line 584 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp97_ = _sub_index;
#line 584 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_sub_index = _tmp97_ + 1;
#line 584 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp98_ = _sub_index;
#line 584 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp99_ = _sub_size;
#line 584 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			if (!(((guint) _tmp98_) < _tmp99_)) {
#line 584 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				break;
#line 4420 "extension.c"
			}
#line 584 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp100_ = _sub_list;
#line 584 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp101_ = _sub_index;
#line 584 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp102_ = adblock_config_get (_tmp100_, (guint) _tmp101_);
#line 584 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			sub = _tmp102_;
#line 585 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp103_ = sub;
#line 585 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp104_ = sub;
#line 585 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp105_ = adblock_subscription_get_active (_tmp104_);
#line 585 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp106_ = _tmp105_;
#line 585 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			adblock_subscription_set_active (_tmp103_, !_tmp106_);
#line 4440 "extension.c"
		}
#line 584 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_object_unref0 (_sub_list);
#line 4444 "extension.c"
	}
#line 586 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp107_ = config;
#line 586 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp108_ = adblock_config_get_path (_tmp107_);
#line 586 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp109_ = _tmp108_;
#line 586 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp110_ = adblock_config_new (_tmp109_, NULL);
#line 586 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_object_unref0 (copy);
#line 586 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	copy = _tmp110_;
#line 4458 "extension.c"
	{
		guint i = 0U;
#line 587 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		i = (guint) 0;
#line 4463 "extension.c"
		{
			gboolean _tmp111_ = FALSE;
#line 587 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			_tmp111_ = TRUE;
#line 587 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			while (TRUE) {
#line 4470 "extension.c"
				guint _tmp113_ = 0U;
				AdblockConfig* _tmp114_ = NULL;
				guint _tmp115_ = 0U;
				guint _tmp116_ = 0U;
				AdblockConfig* _tmp117_ = NULL;
				guint _tmp118_ = 0U;
				AdblockSubscription* _tmp119_ = NULL;
				gboolean _tmp120_ = FALSE;
				gboolean _tmp121_ = FALSE;
				AdblockConfig* _tmp122_ = NULL;
				guint _tmp123_ = 0U;
				AdblockSubscription* _tmp124_ = NULL;
				gboolean _tmp125_ = FALSE;
				gboolean _tmp126_ = FALSE;
#line 587 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				if (!_tmp111_) {
#line 4487 "extension.c"
					guint _tmp112_ = 0U;
#line 587 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp112_ = i;
#line 587 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					i = _tmp112_ + 1;
#line 4493 "extension.c"
				}
#line 587 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp111_ = FALSE;
#line 587 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp113_ = i;
#line 587 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp114_ = config;
#line 587 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp115_ = adblock_config_get_size (_tmp114_);
#line 587 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp116_ = _tmp115_;
#line 587 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				if (!(_tmp113_ < _tmp116_)) {
#line 587 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					break;
#line 4509 "extension.c"
				}
#line 588 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp117_ = config;
#line 588 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp118_ = i;
#line 588 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp119_ = adblock_config_get (_tmp117_, _tmp118_);
#line 588 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp120_ = adblock_subscription_get_active (_tmp119_);
#line 588 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp121_ = _tmp120_;
#line 588 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp122_ = copy;
#line 588 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp123_ = i;
#line 588 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp124_ = adblock_config_get (_tmp122_, _tmp123_);
#line 588 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp125_ = adblock_subscription_get_active (_tmp124_);
#line 588 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp126_ = _tmp125_;
#line 588 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				if (_tmp121_ != _tmp126_) {
#line 4533 "extension.c"
					gchar* contents = NULL;
					const gchar* _tmp132_ = NULL;
					AdblockConfig* _tmp133_ = NULL;
					guint _tmp134_ = 0U;
					AdblockSubscription* _tmp135_ = NULL;
					gboolean _tmp136_ = FALSE;
					gboolean _tmp137_ = FALSE;
					const gchar* _tmp138_ = NULL;
					AdblockConfig* _tmp139_ = NULL;
					guint _tmp140_ = 0U;
					AdblockSubscription* _tmp141_ = NULL;
					gboolean _tmp142_ = FALSE;
					gboolean _tmp143_ = FALSE;
					AdblockConfig* _tmp144_ = NULL;
					guint _tmp145_ = 0U;
					AdblockSubscription* _tmp146_ = NULL;
					const gchar* _tmp147_ = NULL;
					const gchar* _tmp148_ = NULL;
					{
						AdblockConfig* _tmp127_ = NULL;
						const gchar* _tmp128_ = NULL;
						const gchar* _tmp129_ = NULL;
						gchar* _tmp130_ = NULL;
#line 591 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						_tmp127_ = config;
#line 591 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						_tmp128_ = adblock_config_get_path (_tmp127_);
#line 591 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						_tmp129_ = _tmp128_;
#line 591 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						g_file_get_contents (_tmp129_, &_tmp130_, NULL, &_inner_error_);
#line 591 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						_g_free0 (contents);
#line 591 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						contents = _tmp130_;
#line 591 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4571 "extension.c"
							goto __catch7_g_error;
						}
					}
					goto __finally7;
					__catch7_g_error:
					{
						GError* file_error = NULL;
						const gchar* _tmp131_ = NULL;
#line 590 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						file_error = _inner_error_;
#line 590 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						_inner_error_ = NULL;
#line 593 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						_tmp131_ = file_error->message;
#line 593 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						g_error ("extension.vala:593: %s", _tmp131_);
#line 590 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						_g_error_free0 (file_error);
#line 4590 "extension.c"
					}
					__finally7:
#line 590 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 590 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						_g_free0 (contents);
#line 590 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						_g_object_unref0 (copy);
#line 590 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						_g_object_unref0 (config);
#line 590 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 590 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						g_clear_error (&_inner_error_);
#line 590 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						return;
#line 4607 "extension.c"
					}
#line 596 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp133_ = copy;
#line 596 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp134_ = i;
#line 596 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp135_ = adblock_config_get (_tmp133_, _tmp134_);
#line 596 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp136_ = adblock_subscription_get_active (_tmp135_);
#line 596 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp137_ = _tmp136_;
#line 596 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					if (_tmp137_) {
#line 596 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						_tmp132_ = "active";
#line 4623 "extension.c"
					} else {
#line 596 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						_tmp132_ = "disabled";
#line 4627 "extension.c"
					}
#line 596 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp139_ = config;
#line 596 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp140_ = i;
#line 596 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp141_ = adblock_config_get (_tmp139_, _tmp140_);
#line 596 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp142_ = adblock_subscription_get_active (_tmp141_);
#line 596 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp143_ = _tmp142_;
#line 596 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					if (_tmp143_) {
#line 596 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						_tmp138_ = "active";
#line 4643 "extension.c"
					} else {
#line 596 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						_tmp138_ = "disabled";
#line 4647 "extension.c"
					}
#line 595 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp144_ = copy;
#line 595 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp145_ = i;
#line 595 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp146_ = adblock_config_get (_tmp144_, _tmp145_);
#line 595 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp147_ = adblock_subscription_get_uri (_tmp146_);
#line 595 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp148_ = _tmp147_;
#line 595 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					g_error ("extension.vala:595: %s is %s but should be %s:\n%s", _tmp148_, _tmp132_, _tmp138_, contents);
#line 588 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_g_free0 (contents);
#line 4663 "extension.c"
				}
			}
		}
	}
#line 601 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp149_ = adblock_subscription_new ("http://en.de");
#line 601 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	s = _tmp149_;
#line 602 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp150_ = config;
#line 602 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp151_ = adblock_config_add (_tmp150_, s);
#line 602 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (_tmp151_, "config.add (s)");
#line 603 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp152_ = config;
#line 603 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp153_ = adblock_config_get_size (_tmp152_);
#line 603 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp154_ = _tmp153_;
#line 603 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (_tmp154_ == ((guint) 7), "config.size == 7");
#line 604 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp155_ = config;
#line 604 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	adblock_config_remove (_tmp155_, s);
#line 605 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp156_ = config;
#line 605 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp157_ = adblock_config_get_size (_tmp156_);
#line 605 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp158_ = _tmp157_;
#line 605 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (_tmp158_ == ((guint) 6), "config.size == 6");
#line 607 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp159_ = config;
#line 607 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp160_ = adblock_config_add (_tmp159_, s);
#line 607 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (_tmp160_, "config.add (s)");
#line 608 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp161_ = config;
#line 608 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp162_ = adblock_config_get_size (_tmp161_);
#line 608 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp163_ = _tmp162_;
#line 608 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (_tmp163_ == ((guint) 7), "config.size == 7");
#line 546 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_object_unref0 (s);
#line 546 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_object_unref0 (copy);
#line 546 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_object_unref0 (config);
#line 4718 "extension.c"
}


void test_adblock_init (void) {
	AdblockExtension* extension = NULL;
	AdblockExtension* _tmp0_ = NULL;
	AdblockConfig* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	AdblockConfig* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	AdblockStatusIcon* _tmp14_ = NULL;
	AdblockState _tmp15_ = 0;
	gchar* path = NULL;
	gchar* _tmp16_ = NULL;
	gchar* uri = NULL;
	AdblockSubscription* sub = NULL;
	AdblockSubscription* _tmp21_ = NULL;
	AdblockConfig* _tmp22_ = NULL;
	AdblockStatusIcon* _tmp23_ = NULL;
	AdblockState _tmp24_ = 0;
	AdblockConfig* _tmp25_ = NULL;
	guint _tmp26_ = 0U;
	guint _tmp27_ = 0U;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
	AdblockStatusIcon* _tmp31_ = NULL;
	AdblockState _tmp32_ = 0;
	const gchar* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	AdblockDirective* _tmp35_ = NULL;
	AdblockDirective* _tmp36_ = NULL;
	AdblockDirective _tmp37_ = 0;
	gboolean _tmp38_ = FALSE;
	AdblockStatusIcon* _tmp39_ = NULL;
	AdblockState _tmp40_ = 0;
	GString* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	AdblockConfig* _tmp43_ = NULL;
	gboolean _tmp44_ = FALSE;
	AdblockConfig* _tmp45_ = NULL;
	GString* _tmp46_ = NULL;
	const gchar* _tmp47_ = NULL;
	AdblockConfig* _tmp48_ = NULL;
	guint _tmp49_ = 0U;
	guint _tmp50_ = 0U;
	AdblockConfig* _tmp51_ = NULL;
	AdblockSubscription* _tmp52_ = NULL;
	AdblockSubscription* _tmp53_ = NULL;
	AdblockDirective* _tmp54_ = NULL;
	AdblockDirective* _tmp55_ = NULL;
	AdblockDirective _tmp56_ = 0;
	gboolean _tmp57_ = FALSE;
	AdblockStatusIcon* _tmp58_ = NULL;
	AdblockState _tmp59_ = 0;
	AdblockSubscription* _tmp60_ = NULL;
	AdblockDirective* _tmp61_ = NULL;
	AdblockDirective* _tmp62_ = NULL;
	AdblockDirective _tmp63_ = 0;
	gboolean _tmp64_ = FALSE;
	AdblockSubscription* _tmp65_ = NULL;
	AdblockSubscription* _tmp66_ = NULL;
	AdblockDirective* _tmp67_ = NULL;
	AdblockDirective* _tmp68_ = NULL;
	AdblockDirective _tmp69_ = 0;
	gboolean _tmp70_ = FALSE;
	gboolean _tmp71_ = FALSE;
	gboolean _tmp72_ = FALSE;
	AdblockSubscription* _tmp73_ = NULL;
	AdblockDirective* _tmp74_ = NULL;
	AdblockDirective* _tmp75_ = NULL;
	AdblockDirective _tmp76_ = 0;
	AdblockSubscription* _tmp77_ = NULL;
	gboolean _tmp78_ = FALSE;
	gboolean _tmp79_ = FALSE;
	AdblockSubscription* _tmp80_ = NULL;
	AdblockDirective* _tmp81_ = NULL;
	AdblockDirective* _tmp82_ = NULL;
	AdblockDirective _tmp83_ = 0;
	gboolean _tmp84_ = FALSE;
	AdblockSubscription* _tmp85_ = NULL;
	AdblockDirective* _tmp86_ = NULL;
	AdblockDirective* _tmp87_ = NULL;
	AdblockDirective _tmp88_ = 0;
	GError * _inner_error_ = NULL;
#line 613 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = adblock_extension_new ();
#line 613 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	extension = _tmp0_;
#line 614 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	adblock_extension_init (extension);
#line 615 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp1_ = extension->config;
#line 615 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp2_ = adblock_config_get_enabled (_tmp1_);
#line 615 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp3_ = _tmp2_;
#line 615 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (_tmp3_, "extension.config.enabled");
#line 617 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp4_ = extension->config;
#line 617 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp5_ = adblock_config_get_size (_tmp4_);
#line 617 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp6_ = _tmp5_;
#line 617 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (_tmp6_ != ((guint) 3)) {
#line 4827 "extension.c"
		AdblockConfig* _tmp7_ = NULL;
		guint _tmp8_ = 0U;
		guint _tmp9_ = 0U;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
#line 618 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp7_ = extension->config;
#line 618 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp8_ = adblock_config_get_size (_tmp7_);
#line 618 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp9_ = _tmp8_;
#line 618 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp10_ = g_strdup_printf ("%u", _tmp9_);
#line 618 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp11_ = _tmp10_;
#line 618 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp12_ = g_strdup_printf ("Expected 3 initial subs, got %s", _tmp11_);
#line 618 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp13_ = _tmp12_;
#line 618 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		g_error ("extension.vala:618: %s", _tmp13_);
#line 618 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (_tmp13_);
#line 618 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (_tmp11_);
#line 4855 "extension.c"
	}
#line 620 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp14_ = extension->status_icon;
#line 620 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp15_ = _tmp14_->state;
#line 620 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (_tmp15_ == ADBLOCK_STATE_ENABLED, "extension.status_icon.state == Adblock.State.ENABLED");
#line 623 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp16_ = midori_paths_get_res_filename ("adblock.list");
#line 623 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	path = _tmp16_;
#line 4867 "extension.c"
	{
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
#line 626 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp18_ = g_filename_to_uri (path, NULL, &_inner_error_);
#line 626 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp17_ = _tmp18_;
#line 626 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4878 "extension.c"
			goto __catch8_g_error;
		}
#line 626 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp19_ = _tmp17_;
#line 626 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp17_ = NULL;
#line 626 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (uri);
#line 626 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		uri = _tmp19_;
#line 625 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (_tmp17_);
#line 4891 "extension.c"
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp20_ = NULL;
#line 625 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_error_ = _inner_error_;
#line 625 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_inner_error_ = NULL;
#line 628 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp20_ = _error_->message;
#line 628 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		g_error ("extension.vala:628: %s", _tmp20_);
#line 625 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_error_free0 (_error_);
#line 4908 "extension.c"
	}
	__finally8:
#line 625 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 625 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (uri);
#line 625 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (path);
#line 625 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_object_unref0 (extension);
#line 625 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 625 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		g_clear_error (&_inner_error_);
#line 625 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		return;
#line 4925 "extension.c"
	}
#line 630 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp21_ = adblock_subscription_new (uri);
#line 630 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	sub = _tmp21_;
#line 631 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp22_ = extension->config;
#line 631 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	adblock_config_add (_tmp22_, sub);
#line 632 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp23_ = extension->status_icon;
#line 632 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp24_ = _tmp23_->state;
#line 632 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (_tmp24_ == ADBLOCK_STATE_ENABLED, "extension.status_icon.state == Adblock.State.ENABLED");
#line 633 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp25_ = extension->config;
#line 633 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp26_ = adblock_config_get_size (_tmp25_);
#line 633 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp27_ = _tmp26_;
#line 633 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (_tmp27_ == ((guint) 4), "extension.config.size == 4");
#line 4949 "extension.c"
	{
#line 635 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		adblock_subscription_parse (sub, &_inner_error_);
#line 635 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4955 "extension.c"
			goto __catch9_g_error;
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp28_ = NULL;
#line 634 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_error_ = _inner_error_;
#line 634 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_inner_error_ = NULL;
#line 637 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp28_ = _error_->message;
#line 637 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		g_error ("extension.vala:637: %s", _tmp28_);
#line 634 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_error_free0 (_error_);
#line 4974 "extension.c"
	}
	__finally9:
#line 634 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 634 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_object_unref0 (sub);
#line 634 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (uri);
#line 634 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (path);
#line 634 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_object_unref0 (extension);
#line 634 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 634 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		g_clear_error (&_inner_error_);
#line 634 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		return;
#line 4993 "extension.c"
	}
#line 640 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp29_ = adblock_extension_request_handled (extension, "https://ads.bogus.name/blub", "https://ads.bogus.name/blub");
#line 640 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (!_tmp29_, "!extension.request_handled (\"https://ads.bogus.name/blub\", \"https://ads.bogus.name/blub\")");
#line 642 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp30_ = adblock_extension_request_handled (extension, "https://foo.com", "https://ads.bogus.name/blub/favicon.ico");
#line 642 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (!_tmp30_, "!extension.request_handled (\"https://foo.com\", \"https://ads.bogus.name/blub/favicon.ico\")");
#line 643 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp31_ = extension->status_icon;
#line 643 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp32_ = _tmp31_->state;
#line 643 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (_tmp32_ == ADBLOCK_STATE_ENABLED, "extension.status_icon.state == Adblock.State.ENABLED");
#line 645 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp33_ = adblock_subscription_get_title (sub);
#line 645 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp34_ = _tmp33_;
#line 645 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (g_strcmp0 (_tmp34_, "Exercise") == 0, "sub.title == \"Exercise\"");
#line 646 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp35_ = adblock_subscription_get_directive (sub, "https://ads.bogus.name/blub", "");
#line 646 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp36_ = _tmp35_;
#line 646 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp37_ = ADBLOCK_DIRECTIVE_BLOCK;
#line 646 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (_adblock_directive_equal (_tmp36_, &_tmp37_) == TRUE, "sub.get_directive (\"https://ads.bogus.name/blub\", \"\") == Adblock.Directive.BLOCK");
#line 646 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 (_tmp36_);
#line 648 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp38_ = adblock_extension_request_handled (extension, "https://ads.bogus.name/blub", "https://foo.com");
#line 648 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (_tmp38_, "extension.request_handled (\"https://ads.bogus.name/blub\", \"https://foo.com\")");
#line 649 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp39_ = extension->status_icon;
#line 649 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp40_ = _tmp39_->state;
#line 649 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (_tmp40_ == ADBLOCK_STATE_BLOCKED, "extension.status_icon.state == Adblock.State.BLOCKED");
#line 650 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp41_ = extension->hider_selectors;
#line 650 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp42_ = _tmp41_->str;
#line 650 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (g_strcmp0 (_tmp42_, "") != 0, "extension.hider_selectors.str != \"\"");
#line 652 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp43_ = extension->config;
#line 652 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	adblock_config_set_enabled (_tmp43_, FALSE);
#line 653 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp44_ = adblock_extension_request_handled (extension, "https://ads.bogus.name/blub", "https://foo.com");
#line 653 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (!_tmp44_, "!extension.request_handled (\"https://ads.bogus.name/blub\", \"https://foo.com\")");
#line 656 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp45_ = extension->config;
#line 656 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	adblock_config_remove (_tmp45_, sub);
#line 657 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp46_ = extension->hider_selectors;
#line 657 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp47_ = _tmp46_->str;
#line 657 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (g_strcmp0 (_tmp47_, "") == 0, "extension.hider_selectors.str == \"\"");
#line 658 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp48_ = extension->config;
#line 658 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp49_ = adblock_config_get_size (_tmp48_);
#line 658 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp50_ = _tmp49_;
#line 658 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (_tmp50_ == ((guint) 3), "extension.config.size == 3");
#line 660 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp51_ = extension->config;
#line 660 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	adblock_config_set_enabled (_tmp51_, TRUE);
#line 661 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp52_ = extension->custom;
#line 661 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	adblock_subscription_add_rule (_tmp52_, "/adpage.");
#line 662 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp53_ = extension->custom;
#line 662 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp54_ = adblock_subscription_get_directive (_tmp53_, "http://www.engadget.com/_uac/adpage.html", "http://foo.com");
#line 662 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp55_ = _tmp54_;
#line 662 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp56_ = ADBLOCK_DIRECTIVE_BLOCK;
#line 662 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (_adblock_directive_equal (_tmp55_, &_tmp56_) == TRUE, "extension.custom.get_directive (\"http://www.engadget.com/_uac/adpage.html\", \"http://foo.com\") == Adblock.Directive.BLOCK");
#line 662 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 (_tmp55_);
#line 663 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp57_ = adblock_extension_request_handled (extension, "http://www.engadget.com/_uac/adpage.html", "http://foo.com");
#line 663 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (_tmp57_, "extension.request_handled (\"http://www.engadget.com/_uac/adpage.html\", \"http://foo.com\")");
#line 664 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp58_ = extension->status_icon;
#line 664 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp59_ = _tmp58_->state;
#line 664 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (_tmp59_ == ADBLOCK_STATE_BLOCKED, "extension.status_icon.state == Adblock.State.BLOCKED");
#line 666 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp60_ = extension->custom;
#line 666 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp61_ = adblock_subscription_get_directive (_tmp60_, "http://www.engadget.com/_uac/adpage.html", "http://foo.com");
#line 666 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp62_ = _tmp61_;
#line 666 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp63_ = ADBLOCK_DIRECTIVE_BLOCK;
#line 666 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (_adblock_directive_equal (_tmp62_, &_tmp63_) == TRUE, "extension.custom.get_directive (\"http://www.engadget.com/_uac/adpage.html\", \"http://foo.com\") == Adblock.Directive.BLOCK");
#line 666 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 (_tmp62_);
#line 667 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp64_ = adblock_extension_request_handled (extension, "http://www.engadget.com/_uac/adpage.html", "http://foo.com");
#line 667 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (_tmp64_, "extension.request_handled (\"http://www.engadget.com/_uac/adpage.html\", \"http://foo.com\")");
#line 669 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp65_ = extension->custom;
#line 669 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	adblock_subscription_add_rule (_tmp65_, "/images/*.png");
#line 670 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp66_ = extension->custom;
#line 670 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp67_ = adblock_subscription_get_directive (_tmp66_, "http://alpha.beta.com/images/yota.png", "https://foo.com");
#line 670 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp68_ = _tmp67_;
#line 670 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp69_ = ADBLOCK_DIRECTIVE_BLOCK;
#line 670 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (_adblock_directive_equal (_tmp68_, &_tmp69_) == TRUE, "extension.custom.get_directive (\"http://alpha.beta.com/images/yota.png\", \"https://foo.com\") == Adblock.Directive.BLOCK");
#line 670 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 (_tmp68_);
#line 671 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp70_ = adblock_extension_request_handled (extension, "http://alpha.beta.com/images/yota.png", "https://foo.com");
#line 671 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (_tmp70_, "extension.request_handled (\"http://alpha.beta.com/images/yota.png\", \"https://foo.com\")");
#line 673 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp71_ = adblock_extension_request_handled (extension, "http://alpha.beta.com/images/yota.png", "https://foo.com");
#line 673 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (_tmp71_, "extension.request_handled (\"http://alpha.beta.com/images/yota.png\", \"https://foo.com\")");
#line 675 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp72_ = adblock_extension_request_handled (extension, "http://alpha.beta.com/images/yota.jpg", "https://foo.com");
#line 675 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (!_tmp72_, "!extension.request_handled (\"http://alpha.beta.com/images/yota.jpg\", \"https://foo.com\")");
#line 676 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp73_ = extension->custom;
#line 676 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp74_ = adblock_subscription_get_directive (_tmp73_, "http://alpha.beta.com/images/yota.jpg", "https://foo.com");
#line 676 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp75_ = _tmp74_;
#line 676 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp76_ = ADBLOCK_DIRECTIVE_BLOCK;
#line 676 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (_adblock_directive_equal (_tmp75_, &_tmp76_) != TRUE, "extension.custom.get_directive (\"http://alpha.beta.com/images/yota.jpg\", \"https://foo.com\") != Adblock.Directive.BLOCK");
#line 676 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 (_tmp75_);
#line 678 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp77_ = extension->custom;
#line 678 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	adblock_subscription_add_rule (_tmp77_, "@@http://alpha.beta.com/images/drop*bear.png");
#line 679 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp78_ = adblock_extension_request_handled (extension, "http://alpha.beta.com/images/drop-bear.png", "https://foo.com");
#line 679 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (!_tmp78_, "!extension.request_handled (\"http://alpha.beta.com/images/drop-bear.png\", \"https://foo.com\")");
#line 680 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp79_ = adblock_extension_request_handled (extension, "http://alpha.beta.com/images/dropzone_bear.png", "https://foo.com");
#line 680 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (!_tmp79_, "!extension.request_handled (\"http://alpha.beta.com/images/dropzone_bear.png\", \"https://foo.com\")");
#line 681 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp80_ = extension->custom;
#line 681 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp81_ = adblock_subscription_get_directive (_tmp80_, "http://alpha.beta.com/images/drop-bear.png", "https://foo.com");
#line 681 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp82_ = _tmp81_;
#line 681 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp83_ = ADBLOCK_DIRECTIVE_BLOCK;
#line 681 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (_adblock_directive_equal (_tmp82_, &_tmp83_) != TRUE, "extension.custom.get_directive (\"http://alpha.beta.com/images/drop-bear.png\", \"https://foo.com\") != Adblock.Directive.BLOCK");
#line 681 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 (_tmp82_);
#line 683 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp84_ = adblock_extension_request_handled (extension, "http://alpha.beta.com/images/bear.png", "https://foo.com");
#line 683 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (_tmp84_, "extension.request_handled (\"http://alpha.beta.com/images/bear.png\", \"https://foo.com\")");
#line 684 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp85_ = extension->custom;
#line 684 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp86_ = adblock_subscription_get_directive (_tmp85_, "http://alpha.beta.com/images/bear.png", "https://foo.com");
#line 684 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp87_ = _tmp86_;
#line 684 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp88_ = ADBLOCK_DIRECTIVE_BLOCK;
#line 684 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_vala_assert (_adblock_directive_equal (_tmp87_, &_tmp88_) == TRUE, "extension.custom.get_directive (\"http://alpha.beta.com/images/bear.png\", \"https://foo.com\") == Adblock.Directive.BLOCK");
#line 684 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 (_tmp87_);
#line 611 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_object_unref0 (sub);
#line 611 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 (uri);
#line 611 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 (path);
#line 611 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_object_unref0 (extension);
#line 5201 "extension.c"
}


void test_case_line_copy (const TestCaseLine* self, TestCaseLine* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 687 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = (*self).line;
#line 687 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 687 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 ((*dest).line);
#line 687 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	(*dest).line = _tmp1_;
#line 687 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp2_ = (*self).fixed;
#line 687 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 687 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 ((*dest).fixed);
#line 687 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	(*dest).fixed = _tmp3_;
#line 5226 "extension.c"
}


void test_case_line_destroy (TestCaseLine* self) {
#line 688 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 ((*self).line);
#line 689 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 ((*self).fixed);
#line 5235 "extension.c"
}


TestCaseLine* test_case_line_dup (const TestCaseLine* self) {
	TestCaseLine* dup;
#line 687 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	dup = g_new0 (TestCaseLine, 1);
#line 687 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	test_case_line_copy (self, dup);
#line 687 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	return dup;
#line 5247 "extension.c"
}


void test_case_line_free (TestCaseLine* self) {
#line 687 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	test_case_line_destroy (self);
#line 687 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_free (self);
#line 5256 "extension.c"
}


GType test_case_line_get_type (void) {
	static volatile gsize test_case_line_type_id__volatile = 0;
	if (g_once_init_enter (&test_case_line_type_id__volatile)) {
		GType test_case_line_type_id;
		test_case_line_type_id = g_boxed_type_register_static ("TestCaseLine", (GBoxedCopyFunc) test_case_line_dup, (GBoxedFreeFunc) test_case_line_free);
		g_once_init_leave (&test_case_line_type_id__volatile, test_case_line_type_id);
	}
	return test_case_line_type_id__volatile;
}


void test_adblock_fixup_regexp (void) {
	{
		TestCaseLine* line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
#line 711 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		line_collection = lines;
#line 711 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		line_collection_length1 = G_N_ELEMENTS (lines);
#line 711 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		for (line_it = 0; line_it < G_N_ELEMENTS (lines); line_it = line_it + 1) {
#line 5283 "extension.c"
			TestCaseLine line = {0};
#line 711 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			line = line_collection[line_it];
#line 5287 "extension.c"
			{
				TestCaseLine _tmp0_ = {0};
				const gchar* _tmp1_ = NULL;
				TestCaseLine _tmp2_ = {0};
				const gchar* _tmp3_ = NULL;
				gchar* _tmp4_ = NULL;
				gchar* _tmp5_ = NULL;
				TestCaseLine _tmp6_ = {0};
				const gchar* _tmp7_ = NULL;
#line 712 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp0_ = line;
#line 712 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp1_ = _tmp0_.line;
#line 712 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp2_ = line;
#line 712 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp3_ = _tmp2_.line;
#line 712 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp4_ = adblock_fixup_regex ("", _tmp3_);
#line 712 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp5_ = _tmp4_;
#line 712 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp6_ = line;
#line 712 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp7_ = _tmp6_.fixed;
#line 712 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				katze_assert_str_equal (_tmp1_, _tmp5_, _tmp7_);
#line 712 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_g_free0 (_tmp5_);
#line 5317 "extension.c"
			}
		}
	}
}


void test_case_pattern_copy (const TestCasePattern* self, TestCasePattern* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	AdblockDirective _tmp2_ = 0;
#line 716 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = (*self).uri;
#line 716 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 716 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 ((*dest).uri);
#line 716 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	(*dest).uri = _tmp1_;
#line 716 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp2_ = (*self).directive;
#line 716 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	(*dest).directive = _tmp2_;
#line 5340 "extension.c"
}


void test_case_pattern_destroy (TestCasePattern* self) {
#line 717 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 ((*self).uri);
#line 5347 "extension.c"
}


TestCasePattern* test_case_pattern_dup (const TestCasePattern* self) {
	TestCasePattern* dup;
#line 716 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	dup = g_new0 (TestCasePattern, 1);
#line 716 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	test_case_pattern_copy (self, dup);
#line 716 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	return dup;
#line 5359 "extension.c"
}


void test_case_pattern_free (TestCasePattern* self) {
#line 716 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	test_case_pattern_destroy (self);
#line 716 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_free (self);
#line 5368 "extension.c"
}


GType test_case_pattern_get_type (void) {
	static volatile gsize test_case_pattern_type_id__volatile = 0;
	if (g_once_init_enter (&test_case_pattern_type_id__volatile)) {
		GType test_case_pattern_type_id;
		test_case_pattern_type_id = g_boxed_type_register_static ("TestCasePattern", (GBoxedCopyFunc) test_case_pattern_dup, (GBoxedFreeFunc) test_case_pattern_free);
		g_once_init_leave (&test_case_pattern_type_id__volatile, test_case_pattern_type_id);
	}
	return test_case_pattern_type_id__volatile;
}


gchar* pretty_directive (AdblockDirective* directive) {
	gchar* result = NULL;
	AdblockDirective* _tmp0_ = NULL;
	AdblockDirective* _tmp2_ = NULL;
	GEnumValue* _tmp3_;
	gchar* _tmp4_ = NULL;
#line 746 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = directive;
#line 746 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (_tmp0_ == NULL) {
#line 5393 "extension.c"
		gchar* _tmp1_ = NULL;
#line 747 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp1_ = g_strdup ("none");
#line 747 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		result = _tmp1_;
#line 747 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		return result;
#line 5401 "extension.c"
	}
#line 748 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp2_ = directive;
#line 748 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp3_ = g_enum_get_value (g_type_class_ref (ADBLOCK_TYPE_DIRECTIVE), *_tmp2_);
#line 748 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp4_ = g_strdup ((_tmp3_ != NULL) ? _tmp3_->value_name : NULL);
#line 748 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	result = _tmp4_;
#line 748 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	return result;
#line 5413 "extension.c"
}


void test_adblock_pattern (void) {
	gchar* path = NULL;
	gchar* _tmp0_ = NULL;
	gchar* uri = NULL;
	AdblockSubscription* sub = NULL;
	AdblockSubscription* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 752 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = midori_paths_get_res_filename ("adblock.list");
#line 752 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	path = _tmp0_;
#line 5428 "extension.c"
	{
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 755 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp2_ = g_filename_to_uri (path, NULL, &_inner_error_);
#line 755 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp1_ = _tmp2_;
#line 755 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5439 "extension.c"
			goto __catch10_g_error;
		}
#line 755 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp3_ = _tmp1_;
#line 755 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp1_ = NULL;
#line 755 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (uri);
#line 755 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		uri = _tmp3_;
#line 754 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (_tmp1_);
#line 5452 "extension.c"
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 754 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_error_ = _inner_error_;
#line 754 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_inner_error_ = NULL;
#line 757 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp4_ = _error_->message;
#line 757 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		g_error ("extension.vala:757: %s", _tmp4_);
#line 754 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_error_free0 (_error_);
#line 5469 "extension.c"
	}
	__finally10:
#line 754 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 754 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (uri);
#line 754 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (path);
#line 754 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 754 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		g_clear_error (&_inner_error_);
#line 754 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		return;
#line 5484 "extension.c"
	}
#line 759 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp5_ = adblock_subscription_new (uri);
#line 759 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	sub = _tmp5_;
#line 5490 "extension.c"
	{
#line 761 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		adblock_subscription_parse (sub, &_inner_error_);
#line 761 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5496 "extension.c"
			goto __catch11_g_error;
		}
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 760 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_error_ = _inner_error_;
#line 760 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_inner_error_ = NULL;
#line 763 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp6_ = _error_->message;
#line 763 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		g_error ("extension.vala:763: %s", _tmp6_);
#line 760 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_error_free0 (_error_);
#line 5515 "extension.c"
	}
	__finally11:
#line 760 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 760 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_object_unref0 (sub);
#line 760 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (uri);
#line 760 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (path);
#line 760 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 760 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		g_clear_error (&_inner_error_);
#line 760 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		return;
#line 5532 "extension.c"
	}
	{
		TestCasePattern* pattern_collection = NULL;
		gint pattern_collection_length1 = 0;
		gint _pattern_collection_size_ = 0;
		gint pattern_it = 0;
#line 765 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		pattern_collection = patterns;
#line 765 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		pattern_collection_length1 = G_N_ELEMENTS (patterns);
#line 765 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		for (pattern_it = 0; pattern_it < G_N_ELEMENTS (patterns); pattern_it = pattern_it + 1) {
#line 5545 "extension.c"
			TestCasePattern pattern = {0};
#line 765 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			pattern = pattern_collection[pattern_it];
#line 5549 "extension.c"
			{
				AdblockDirective* directive = NULL;
				TestCasePattern _tmp7_ = {0};
				const gchar* _tmp8_ = NULL;
				AdblockDirective* _tmp9_ = NULL;
				AdblockDirective* _tmp10_ = NULL;
				AdblockDirective* _tmp13_ = NULL;
				TestCasePattern _tmp14_ = {0};
				AdblockDirective _tmp15_ = 0;
#line 766 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp7_ = pattern;
#line 766 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp8_ = _tmp7_.uri;
#line 766 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp9_ = adblock_subscription_get_directive (sub, _tmp8_, "");
#line 766 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				directive = _tmp9_;
#line 767 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp10_ = directive;
#line 767 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				if (_tmp10_ == NULL) {
#line 5571 "extension.c"
					AdblockDirective _tmp11_ = 0;
					AdblockDirective* _tmp12_ = NULL;
#line 768 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp11_ = ADBLOCK_DIRECTIVE_ALLOW;
#line 768 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp12_ = __adblock_directive_dup0 (&_tmp11_);
#line 768 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_g_free0 (directive);
#line 768 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					directive = _tmp12_;
#line 5582 "extension.c"
				}
#line 769 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp13_ = directive;
#line 769 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp14_ = pattern;
#line 769 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp15_ = _tmp14_.directive;
#line 769 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				if (_adblock_directive_equal (_tmp13_, &_tmp15_) != TRUE) {
#line 5592 "extension.c"
					TestCasePattern _tmp16_ = {0};
					AdblockDirective _tmp17_ = 0;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					TestCasePattern _tmp20_ = {0};
					const gchar* _tmp21_ = NULL;
					AdblockDirective* _tmp22_ = NULL;
					gchar* _tmp23_ = NULL;
					gchar* _tmp24_ = NULL;
#line 770 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp16_ = pattern;
#line 770 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp17_ = _tmp16_.directive;
#line 770 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp18_ = pretty_directive (&_tmp17_);
#line 770 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp19_ = _tmp18_;
#line 770 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp20_ = pattern;
#line 770 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp21_ = _tmp20_.uri;
#line 770 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp22_ = directive;
#line 770 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp23_ = pretty_directive (_tmp22_);
#line 770 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp24_ = _tmp23_;
#line 770 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					g_error ("extension.vala:770: %s expected for %s but got %s", _tmp19_, _tmp21_, _tmp24_);
#line 770 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_g_free0 (_tmp24_);
#line 770 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_g_free0 (_tmp19_);
#line 5626 "extension.c"
				}
#line 765 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_g_free0 (directive);
#line 5630 "extension.c"
			}
		}
	}
#line 751 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_object_unref0 (sub);
#line 751 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 (uri);
#line 751 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 (path);
#line 5640 "extension.c"
}


static gchar* g_date_time_to_string (GDateTime* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
#line 2609 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 2610 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
#line 2610 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	result = _tmp0_;
#line 2610 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	return result;
#line 5655 "extension.c"
}


gchar* pretty_date (GDateTime* date) {
	gchar* result = NULL;
	GDateTime* _tmp0_ = NULL;
	GDateTime* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 777 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = date;
#line 777 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (_tmp0_ == NULL) {
#line 5668 "extension.c"
		gchar* _tmp1_ = NULL;
#line 778 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp1_ = g_strdup ("N/A");
#line 778 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		result = _tmp1_;
#line 778 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		return result;
#line 5676 "extension.c"
	}
#line 779 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp2_ = date;
#line 779 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp3_ = g_date_time_to_string (_tmp2_);
#line 779 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	result = _tmp3_;
#line 779 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	return result;
#line 5686 "extension.c"
}


void test_update_example_copy (const TestUpdateExample* self, TestUpdateExample* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
#line 782 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = (*self).content;
#line 782 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 782 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 ((*dest).content);
#line 782 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	(*dest).content = _tmp1_;
#line 782 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp2_ = (*self).result;
#line 782 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	(*dest).result = _tmp2_;
#line 782 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp3_ = (*self).valid;
#line 782 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	(*dest).valid = _tmp3_;
#line 5711 "extension.c"
}


void test_update_example_destroy (TestUpdateExample* self) {
#line 783 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 ((*self).content);
#line 5718 "extension.c"
}


TestUpdateExample* test_update_example_dup (const TestUpdateExample* self) {
	TestUpdateExample* dup;
#line 782 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	dup = g_new0 (TestUpdateExample, 1);
#line 782 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	test_update_example_copy (self, dup);
#line 782 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	return dup;
#line 5730 "extension.c"
}


void test_update_example_free (TestUpdateExample* self) {
#line 782 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	test_update_example_destroy (self);
#line 782 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_free (self);
#line 5739 "extension.c"
}


GType test_update_example_get_type (void) {
	static volatile gsize test_update_example_type_id__volatile = 0;
	if (g_once_init_enter (&test_update_example_type_id__volatile)) {
		GType test_update_example_type_id;
		test_update_example_type_id = g_boxed_type_register_static ("TestUpdateExample", (GBoxedCopyFunc) test_update_example_dup, (GBoxedFreeFunc) test_update_example_free);
		g_once_init_leave (&test_update_example_type_id__volatile, test_update_example_type_id);
	}
	return test_update_example_type_id__volatile;
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1 = 0;
	gint _res_size_ = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
#line 1300 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1301 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	res = (guint8*) self;
#line 1301 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	res_length1 = -1;
#line 1301 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1302 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1302 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1302 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1302 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp2_ = res_length1;
#line 1303 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp3_ = res;
#line 1303 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp3__length1 = res_length1;
#line 1303 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 1303 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	_tmp4__length1 = _tmp3__length1;
#line 1303 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1303 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
		*result_length1 = _tmp4__length1;
#line 5794 "extension.c"
	}
#line 1303 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 1303 "/usr/share/vala-0.30/vapi/glib-2.0.vapi"
	return result;
#line 5800 "extension.c"
}


void test_subscription_update (void) {
	gchar* uri = NULL;
	GFileIOStream* iostream = NULL;
	GFile* file = NULL;
	AdblockSubscription* sub = NULL;
	AdblockSubscription* _tmp6_ = NULL;
	AdblockUpdater* updater = NULL;
	AdblockUpdater* _tmp7_ = NULL;
	AdblockSubscription* _tmp8_ = NULL;
	AdblockUpdater* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
	{
		GFile* _tmp0_ = NULL;
		GFileIOStream* _tmp1_ = NULL;
		GFile* _tmp2_ = NULL;
		GFile* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
#line 806 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp2_ = g_file_new_tmp ("midori_adblock_update_test_XXXXXX", &_tmp1_, &_inner_error_);
#line 806 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_object_unref0 (iostream);
#line 806 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		iostream = _tmp1_;
#line 806 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp0_ = _tmp2_;
#line 806 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5831 "extension.c"
			goto __catch12_g_error;
		}
#line 806 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp3_ = _tmp0_;
#line 806 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp0_ = NULL;
#line 806 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_object_unref0 (file);
#line 806 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		file = _tmp3_;
#line 807 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp4_ = g_file_get_uri (file);
#line 807 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (uri);
#line 807 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		uri = _tmp4_;
#line 805 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_object_unref0 (_tmp0_);
#line 5850 "extension.c"
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 805 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_error_ = _inner_error_;
#line 805 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_inner_error_ = NULL;
#line 809 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_tmp5_ = _error_->message;
#line 809 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		g_error ("extension.vala:809: %s", _tmp5_);
#line 805 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_error_free0 (_error_);
#line 5867 "extension.c"
	}
	__finally12:
#line 805 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 805 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_object_unref0 (file);
#line 805 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_object_unref0 (iostream);
#line 805 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		_g_free0 (uri);
#line 805 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 805 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		g_clear_error (&_inner_error_);
#line 805 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		return;
#line 5884 "extension.c"
	}
#line 811 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp6_ = adblock_subscription_new (uri);
#line 811 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	sub = _tmp6_;
#line 812 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp7_ = adblock_updater_new ();
#line 812 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	updater = _tmp7_;
#line 813 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp8_ = sub;
#line 813 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp9_ = updater;
#line 813 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	adblock_subscription_add_feature (_tmp8_, (AdblockFeature*) _tmp9_);
#line 5900 "extension.c"
	{
		TestUpdateExample* example_collection = NULL;
		gint example_collection_length1 = 0;
		gint _example_collection_size_ = 0;
		gint example_it = 0;
#line 815 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		example_collection = examples;
#line 815 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		example_collection_length1 = G_N_ELEMENTS (examples);
#line 815 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		for (example_it = 0; example_it < G_N_ELEMENTS (examples); example_it = example_it + 1) {
#line 5912 "extension.c"
			TestUpdateExample example = {0};
#line 815 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			example = example_collection[example_it];
#line 5916 "extension.c"
			{
				TestUpdateExample _tmp17_ = {0};
				gboolean _tmp18_ = FALSE;
				AdblockSubscription* _tmp19_ = NULL;
				gboolean _tmp20_ = FALSE;
				gboolean _tmp21_ = FALSE;
				TestUpdateExample _tmp31_ = {0};
				gboolean _tmp32_ = FALSE;
				AdblockUpdater* _tmp33_ = NULL;
				gboolean _tmp34_ = FALSE;
				gboolean _tmp35_ = FALSE;
				{
					TestUpdateExample _tmp10_ = {0};
					const gchar* _tmp11_ = NULL;
					guint8* _tmp12_ = NULL;
					gint _tmp12__length1 = 0;
					guint8* _tmp13_ = NULL;
					gint _tmp13__length1 = 0;
					AdblockSubscription* _tmp14_ = NULL;
					AdblockSubscription* _tmp15_ = NULL;
#line 817 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp10_ = example;
#line 817 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp11_ = _tmp10_.content;
#line 817 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp12_ = string_get_data (_tmp11_, &_tmp12__length1);
#line 817 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp13_ = _tmp12_;
#line 817 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp13__length1 = _tmp12__length1;
#line 817 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					g_file_replace_contents (file, _tmp13_, (gsize) _tmp13__length1, NULL, FALSE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error_);
#line 817 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5951 "extension.c"
						goto __catch13_g_error;
					}
#line 818 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp14_ = sub;
#line 818 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					adblock_subscription_clear (_tmp14_);
#line 819 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp15_ = sub;
#line 819 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					adblock_subscription_parse (_tmp15_, &_inner_error_);
#line 819 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 5964 "extension.c"
						goto __catch13_g_error;
					}
				}
				goto __finally13;
				__catch13_g_error:
				{
					GError* _error_ = NULL;
					const gchar* _tmp16_ = NULL;
#line 816 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_error_ = _inner_error_;
#line 816 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_inner_error_ = NULL;
#line 821 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp16_ = _error_->message;
#line 821 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					g_error ("extension.vala:821: %s", _tmp16_);
#line 816 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_g_error_free0 (_error_);
#line 5983 "extension.c"
				}
				__finally13:
#line 816 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 816 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_g_object_unref0 (updater);
#line 816 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_g_object_unref0 (sub);
#line 816 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_g_object_unref0 (file);
#line 816 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_g_object_unref0 (iostream);
#line 816 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_g_free0 (uri);
#line 816 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 816 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					g_clear_error (&_inner_error_);
#line 816 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					return;
#line 6004 "extension.c"
				}
#line 823 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp17_ = example;
#line 823 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp18_ = _tmp17_.valid;
#line 823 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp19_ = sub;
#line 823 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp20_ = adblock_subscription_get_valid (_tmp19_);
#line 823 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp21_ = _tmp20_;
#line 823 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				if (_tmp18_ != _tmp21_) {
#line 6018 "extension.c"
					const gchar* _tmp22_ = NULL;
					TestUpdateExample _tmp23_ = {0};
					gboolean _tmp24_ = FALSE;
					const gchar* _tmp25_ = NULL;
					AdblockSubscription* _tmp26_ = NULL;
					gboolean _tmp27_ = FALSE;
					gboolean _tmp28_ = FALSE;
					TestUpdateExample _tmp29_ = {0};
					const gchar* _tmp30_ = NULL;
#line 825 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp23_ = example;
#line 825 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp24_ = _tmp23_.valid;
#line 825 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					if (_tmp24_) {
#line 825 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						_tmp22_ = "";
#line 6036 "extension.c"
					} else {
#line 825 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						_tmp22_ = "in";
#line 6040 "extension.c"
					}
#line 825 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp26_ = sub;
#line 825 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp27_ = adblock_subscription_get_valid (_tmp26_);
#line 825 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp28_ = _tmp27_;
#line 825 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					if (_tmp28_) {
#line 825 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						_tmp25_ = "";
#line 6052 "extension.c"
					} else {
#line 825 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						_tmp25_ = "in";
#line 6056 "extension.c"
					}
#line 824 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp29_ = example;
#line 824 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp30_ = _tmp29_.content;
#line 824 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					g_error ("extension.vala:824: Subscription expected to be %svalid but %svalid:\n" \
"%s", _tmp22_, _tmp25_, _tmp30_);
#line 6064 "extension.c"
				}
#line 826 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp31_ = example;
#line 826 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp32_ = _tmp31_.result;
#line 826 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp33_ = updater;
#line 826 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp34_ = adblock_updater_get_needs_update (_tmp33_);
#line 826 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp35_ = _tmp34_;
#line 826 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				if (_tmp32_ != _tmp35_) {
#line 6078 "extension.c"
					const gchar* _tmp36_ = NULL;
					TestUpdateExample _tmp37_ = {0};
					gboolean _tmp38_ = FALSE;
					TestUpdateExample _tmp39_ = {0};
					const gchar* _tmp40_ = NULL;
					AdblockUpdater* _tmp41_ = NULL;
					GDateTime* _tmp42_ = NULL;
					GDateTime* _tmp43_ = NULL;
					gchar* _tmp44_ = NULL;
					gchar* _tmp45_ = NULL;
					AdblockUpdater* _tmp46_ = NULL;
					GDateTime* _tmp47_ = NULL;
					GDateTime* _tmp48_ = NULL;
					gchar* _tmp49_ = NULL;
					gchar* _tmp50_ = NULL;
#line 828 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp37_ = example;
#line 828 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp38_ = _tmp37_.result;
#line 828 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					if (_tmp38_) {
#line 828 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						_tmp36_ = "";
#line 6102 "extension.c"
					} else {
#line 828 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
						_tmp36_ = " not";
#line 6106 "extension.c"
					}
#line 827 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp39_ = example;
#line 827 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp40_ = _tmp39_.content;
#line 827 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp41_ = updater;
#line 827 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp42_ = adblock_updater_get_last_updated (_tmp41_);
#line 827 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp43_ = _tmp42_;
#line 827 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp44_ = pretty_date (_tmp43_);
#line 827 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp45_ = _tmp44_;
#line 827 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp46_ = updater;
#line 827 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp47_ = adblock_updater_get_expires (_tmp46_);
#line 827 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp48_ = _tmp47_;
#line 827 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp49_ = pretty_date (_tmp48_);
#line 827 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp50_ = _tmp49_;
#line 827 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					g_error ("extension.vala:827: Update%s expected for:\n" \
"%s\n" \
"Last Updated: %s\n" \
"Expires: %s", _tmp36_, _tmp40_, _tmp45_, _tmp50_);
#line 827 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_g_free0 (_tmp50_);
#line 827 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_g_free0 (_tmp45_);
#line 6138 "extension.c"
				}
			}
		}
	}
#line 801 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_object_unref0 (updater);
#line 801 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_object_unref0 (sub);
#line 801 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_object_unref0 (file);
#line 801 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_object_unref0 (iostream);
#line 801 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 (uri);
#line 6153 "extension.c"
}


void test_sub_uri_copy (const TestSubUri* self, TestSubUri* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 833 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp0_ = (*self).src_uri;
#line 833 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 833 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 ((*dest).src_uri);
#line 833 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	(*dest).src_uri = _tmp1_;
#line 833 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp2_ = (*self).dst_uri;
#line 833 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 833 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 ((*dest).dst_uri);
#line 833 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	(*dest).dst_uri = _tmp3_;
#line 6178 "extension.c"
}


void test_sub_uri_destroy (TestSubUri* self) {
#line 834 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 ((*self).src_uri);
#line 835 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 ((*self).dst_uri);
#line 6187 "extension.c"
}


TestSubUri* test_sub_uri_dup (const TestSubUri* self) {
	TestSubUri* dup;
#line 833 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	dup = g_new0 (TestSubUri, 1);
#line 833 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	test_sub_uri_copy (self, dup);
#line 833 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	return dup;
#line 6199 "extension.c"
}


void test_sub_uri_free (TestSubUri* self) {
#line 833 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	test_sub_uri_destroy (self);
#line 833 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_free (self);
#line 6208 "extension.c"
}


GType test_sub_uri_get_type (void) {
	static volatile gsize test_sub_uri_type_id__volatile = 0;
	if (g_once_init_enter (&test_sub_uri_type_id__volatile)) {
		GType test_sub_uri_type_id;
		test_sub_uri_type_id = g_boxed_type_register_static ("TestSubUri", (GBoxedCopyFunc) test_sub_uri_dup, (GBoxedFreeFunc) test_sub_uri_free);
		g_once_init_leave (&test_sub_uri_type_id__volatile, test_sub_uri_type_id);
	}
	return test_sub_uri_type_id__volatile;
}


void test_subscription_uri_parsing (void) {
	gchar* parsed_uri = NULL;
	{
		TestSubUri* example_collection = NULL;
		gint example_collection_length1 = 0;
		gint _example_collection_size_ = 0;
		gint example_it = 0;
#line 848 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		example_collection = suburis;
#line 848 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		example_collection_length1 = G_N_ELEMENTS (suburis);
#line 848 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
		for (example_it = 0; example_it < G_N_ELEMENTS (suburis); example_it = example_it + 1) {
#line 6236 "extension.c"
			TestSubUri example = {0};
#line 848 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
			example = example_collection[example_it];
#line 6240 "extension.c"
			{
				TestSubUri _tmp0_ = {0};
				const gchar* _tmp1_ = NULL;
				gchar* _tmp2_ = NULL;
				const gchar* _tmp3_ = NULL;
				TestSubUri _tmp4_ = {0};
				const gchar* _tmp5_ = NULL;
#line 849 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp0_ = example;
#line 849 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp1_ = _tmp0_.src_uri;
#line 849 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp2_ = adblock_parse_subscription_uri (_tmp1_);
#line 849 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_g_free0 (parsed_uri);
#line 849 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				parsed_uri = _tmp2_;
#line 850 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp3_ = parsed_uri;
#line 850 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp4_ = example;
#line 850 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				_tmp5_ = _tmp4_.dst_uri;
#line 850 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
				if (g_strcmp0 (_tmp3_, _tmp5_) != 0) {
#line 6266 "extension.c"
					TestSubUri _tmp6_ = {0};
					const gchar* _tmp7_ = NULL;
					const gchar* _tmp8_ = NULL;
					TestSubUri _tmp9_ = {0};
					const gchar* _tmp10_ = NULL;
#line 851 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp6_ = example;
#line 851 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp7_ = _tmp6_.dst_uri;
#line 851 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp8_ = parsed_uri;
#line 851 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp9_ = example;
#line 851 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					_tmp10_ = _tmp9_.src_uri;
#line 851 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
					g_error ("extension.vala:851: Subscription expected to be %svalid but %svalid:\n" \
"%s", _tmp7_, _tmp8_, _tmp10_);
#line 6284 "extension.c"
				}
			}
		}
	}
#line 846 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	_g_free0 (parsed_uri);
#line 6291 "extension.c"
}


static void _test_adblock_config_gcallback (void) {
#line 857 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	test_adblock_config ();
#line 6298 "extension.c"
}


static void _test_adblock_subs_gcallback (void) {
#line 858 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	test_adblock_subs ();
#line 6305 "extension.c"
}


static void _test_adblock_init_gcallback (void) {
#line 859 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	test_adblock_init ();
#line 6312 "extension.c"
}


static void _test_adblock_fixup_regexp_gcallback (void) {
#line 860 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	test_adblock_fixup_regexp ();
#line 6319 "extension.c"
}


static void _test_adblock_pattern_gcallback (void) {
#line 861 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	test_adblock_pattern ();
#line 6326 "extension.c"
}


static void _test_subscription_update_gcallback (void) {
#line 862 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	test_subscription_update ();
#line 6333 "extension.c"
}


static void _test_subscription_uri_parsing_gcallback (void) {
#line 863 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	test_subscription_uri_parsing ();
#line 6340 "extension.c"
}


void extension_test (void) {
#line 857 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_test_add_func ("/extensions/adblock2/config", _test_adblock_config_gcallback);
#line 858 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_test_add_func ("/extensions/adblock2/subs", _test_adblock_subs_gcallback);
#line 859 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_test_add_func ("/extensions/adblock2/init", _test_adblock_init_gcallback);
#line 860 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_test_add_func ("/extensions/adblock2/parse", _test_adblock_fixup_regexp_gcallback);
#line 861 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_test_add_func ("/extensions/adblock2/pattern", _test_adblock_pattern_gcallback);
#line 862 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_test_add_func ("/extensions/adblock2/update", _test_subscription_update_gcallback);
#line 863 "/usr/src/ports/midori/midori-0.5.11-1.i686/src/midori-0.5.11/extensions/adblock/extension.vala"
	g_test_add_func ("/extensions/adblock2/subsparse", _test_subscription_uri_parsing_gcallback);
#line 6359 "extension.c"
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



