/* main.c generated by valac 0.20.1, the Vala compiler
 * generated from main.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2011 Peng Huang <shawn.p.huang@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include <glib.h>
#include <glib-object.h>
#include <ibus.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>


#define TYPE_DUMMY_ENGINE (dummy_engine_get_type ())
#define DUMMY_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DUMMY_ENGINE, DummyEngine))
#define DUMMY_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DUMMY_ENGINE, DummyEngineClass))
#define IS_DUMMY_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DUMMY_ENGINE))
#define IS_DUMMY_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DUMMY_ENGINE))
#define DUMMY_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DUMMY_ENGINE, DummyEngineClass))

typedef struct _DummyEngine DummyEngine;
typedef struct _DummyEngineClass DummyEngineClass;
typedef struct _DummyEnginePrivate DummyEnginePrivate;
typedef struct _Block1Data Block1Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _DummyEngine {
	IBusEngineSimple parent_instance;
	DummyEnginePrivate * priv;
};

struct _DummyEngineClass {
	IBusEngineSimpleClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	IBusBus* bus;
	gint id;
};


static gpointer dummy_engine_parent_class = NULL;

GType dummy_engine_get_type (void) G_GNUC_CONST;
enum  {
	DUMMY_ENGINE_DUMMY_PROPERTY
};
DummyEngine* dummy_engine_new (void);
DummyEngine* dummy_engine_construct (GType object_type);
gint _vala_main (gchar** args, int args_length1);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda2_ (IBusBus* bus);
static void ___lambda2__ibus_bus_disconnected (IBusBus* _sender, gpointer self);
static IBusEngine* __lambda3_ (Block1Data* _data1_, IBusFactory* factory, const gchar* name);
static IBusEngine* ___lambda3__ibus_factory_create_engine (IBusFactory* _sender, const gchar* engine_name, gpointer self);

const guint16 cedilla_compose_seqs[36] = {(guint16) IBUS_KEY_dead_acute, (guint16) IBUS_KEY_C, (guint16) 0, (guint16) 0, (guint16) 0, (guint16) 0x00C7, (guint16) IBUS_KEY_dead_acute, (guint16) IBUS_KEY_c, (guint16) 0, (guint16) 0, (guint16) 0, (guint16) 0x00E7, (guint16) IBUS_KEY_Multi_key, (guint16) IBUS_KEY_apostrophe, (guint16) IBUS_KEY_C, (guint16) 0, (guint16) 0, (guint16) 0x00C7, (guint16) IBUS_KEY_Multi_key, (guint16) IBUS_KEY_apostrophe, (guint16) IBUS_KEY_c, (guint16) 0, (guint16) 0, (guint16) 0x00E7, (guint16) IBUS_KEY_Multi_key, (guint16) IBUS_KEY_C, (guint16) IBUS_KEY_apostrophe, (guint16) 0, (guint16) 0, (guint16) 0x00C7, (guint16) IBUS_KEY_Multi_key, (guint16) IBUS_KEY_c, (guint16) IBUS_KEY_apostrophe, (guint16) 0, (guint16) 0, (guint16) 0x00E7};

DummyEngine* dummy_engine_construct (GType object_type) {
	DummyEngine * self = NULL;
	self = (DummyEngine*) g_object_new (object_type, NULL);
	return self;
}


DummyEngine* dummy_engine_new (void) {
	return dummy_engine_construct (TYPE_DUMMY_ENGINE);
}


static void dummy_engine_class_init (DummyEngineClass * klass) {
	dummy_engine_parent_class = g_type_class_peek_parent (klass);
}


static void dummy_engine_instance_init (DummyEngine * self) {
}


GType dummy_engine_get_type (void) {
	static volatile gsize dummy_engine_type_id__volatile = 0;
	if (g_once_init_enter (&dummy_engine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DummyEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dummy_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DummyEngine), 0, (GInstanceInitFunc) dummy_engine_instance_init, NULL };
		GType dummy_engine_type_id;
		dummy_engine_type_id = g_type_register_static (ibus_engine_simple_get_type (), "DummyEngine", &g_define_type_info, 0);
		g_once_init_leave (&dummy_engine_type_id__volatile, dummy_engine_type_id);
	}
	return dummy_engine_type_id__volatile;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->bus);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda2_ (IBusBus* bus) {
	g_return_if_fail (bus != NULL);
	g_debug ("main.vala:54: bus disconnected");
	ibus_quit ();
}


static void ___lambda2__ibus_bus_disconnected (IBusBus* _sender, gpointer self) {
	__lambda2_ (_sender);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static IBusEngine* __lambda3_ (Block1Data* _data1_, IBusFactory* factory, const gchar* name) {
	IBusEngine* result = NULL;
	static const char path[] = "/org/freedesktop/IBus/engine/simple/%d";
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* lang;
	const gchar* _tmp2_;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	IBusBus* _tmp10_;
	GDBusConnection* _tmp11_ = NULL;
	IBusEngine* _tmp12_;
	IBusEngine* _tmp13_;
	IBusEngine* engine;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp15_;
	gboolean _tmp20_;
	g_return_val_if_fail (factory != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = setlocale (LC_CTYPE, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	lang = _tmp1_;
	_tmp2_ = lang;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp3_ = g_getenv ("LANG");
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (lang);
		lang = _tmp4_;
	}
	_tmp5_ = name;
	_tmp6_ = _data1_->id;
	_data1_->id = _tmp6_ + 1;
	_tmp7_ = _data1_->id;
	_tmp8_ = g_strdup_printf (path, _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _data1_->bus;
	_tmp11_ = ibus_bus_get_connection (_tmp10_);
	_tmp12_ = ibus_engine_new_with_type (ibus_engine_simple_get_type (), _tmp5_, _tmp9_, _tmp11_);
	g_object_ref_sink (_tmp12_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp9_);
	engine = _tmp13_;
	_tmp15_ = lang;
	if (_tmp15_ != NULL) {
		const gchar* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _tmp19_ = 0;
		_tmp16_ = lang;
		_tmp17_ = strlen ("pt_br");
		_tmp18_ = _tmp17_;
		_tmp19_ = g_ascii_strncasecmp (_tmp16_, "pt_br", (gsize) _tmp18_);
		_tmp14_ = _tmp19_ == 0;
	} else {
		_tmp14_ = FALSE;
	}
	_tmp20_ = _tmp14_;
	if (_tmp20_) {
		IBusEngine* _tmp21_;
		IBusEngineSimple* _tmp22_;
		IBusEngineSimple* simple;
		IBusEngineSimple* _tmp23_;
		_tmp21_ = engine;
		_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, ibus_engine_simple_get_type (), IBusEngineSimple));
		simple = _tmp22_;
		_tmp23_ = simple;
		ibus_engine_simple_add_table (_tmp23_, cedilla_compose_seqs, 4, G_N_ELEMENTS (cedilla_compose_seqs) / (4 + 2));
		_g_object_unref0 (simple);
	}
	result = engine;
	_g_free0 (lang);
	return result;
}


static IBusEngine* ___lambda3__ibus_factory_create_engine (IBusFactory* _sender, const gchar* engine_name, gpointer self) {
	IBusEngine* result;
	result = __lambda3_ (self, _sender, engine_name);
	return result;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	Block1Data* _data1_;
	IBusBus* _tmp0_;
	IBusBus* _tmp1_;
	gboolean _tmp2_ = FALSE;
	IBusBus* _tmp3_;
	IBusBus* _tmp4_;
	GDBusConnection* _tmp5_ = NULL;
	IBusFactory* _tmp6_;
	IBusFactory* factory;
	IBusFactory* _tmp7_;
	guint flags;
	IBusBus* _tmp8_;
	guint _tmp9_;
	guint32 _tmp10_ = 0U;
	guint retval;
	guint _tmp11_;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	setlocale (LC_ALL, "");
	ibus_init ();
	_tmp0_ = ibus_bus_new ();
	g_object_ref_sink (_tmp0_);
	_data1_->bus = _tmp0_;
	_tmp1_ = _data1_->bus;
	_tmp2_ = ibus_bus_is_connected (_tmp1_);
	if (!_tmp2_) {
		g_warning ("main.vala:49: ibus-daemon does not exist.");
		result = 1;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	_tmp3_ = _data1_->bus;
	g_signal_connect (_tmp3_, "disconnected", (GCallback) ___lambda2__ibus_bus_disconnected, NULL);
	_tmp4_ = _data1_->bus;
	_tmp5_ = ibus_bus_get_connection (_tmp4_);
	_tmp6_ = ibus_factory_new (_tmp5_);
	g_object_ref_sink (_tmp6_);
	factory = _tmp6_;
	_data1_->id = 0;
	_tmp7_ = factory;
	g_signal_connect_data (_tmp7_, "create-engine", (GCallback) ___lambda3__ibus_factory_create_engine, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	flags = (guint) (IBUS_BUS_NAME_FLAG_REPLACE_EXISTING | IBUS_BUS_NAME_FLAG_ALLOW_REPLACEMENT);
	_tmp8_ = _data1_->bus;
	_tmp9_ = flags;
	_tmp10_ = ibus_bus_request_name (_tmp8_, "org.freedesktop.IBus.Simple", (guint32) _tmp9_);
	retval = (guint) _tmp10_;
	_tmp11_ = retval;
	if (_tmp11_ == ((guint) 0)) {
		g_warning ("main.vala:104: Registry bus name org.freedesktop.IBus.Simple failed!");
		result = 1;
		_g_object_unref0 (factory);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	ibus_main ();
	result = 0;
	_g_object_unref0 (factory);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}



