/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.taglets;

import com.sun.javadoc.Tag;
import com.sun.tools.doclets.Taglet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AuthorTaglet
implements Taglet {
    private static EmailReplacement emailReplacementType = EmailReplacement.NO_REPLACEMENT;
    private static String atReplacement = " <b>at</b> ";
    private static String dotReplacement = " <b>dot</b> ";
    private static final String NAME = "author";
    private static final String SINGLE_HEADER = "Author:";
    private static final String MULTI_HEADER = "Authors:";
    private static boolean enabled = true;
    private static final Pattern dotPattern = Pattern.compile("[.]");
    private static final Pattern atPattern = Pattern.compile("[@]");
    private static final Pattern authorEmailPattern = Pattern.compile("^\\s*((?:[^\t\r\n ]|\\()+(?:\\s+(?:[^\t\r\n ]|\\()+)*)\\s*[(<]\\s*(([A-z0-9_\\-\\.]+)[@][A-z0-9_\\-]+(?:[.][A-z0-9_\\-]+)+[A-z])\\s*(?:\\)|>)$");

    public String getName() {
        return NAME;
    }

    public boolean inField() {
        return true;
    }

    public boolean inConstructor() {
        return true;
    }

    public boolean inMethod() {
        return true;
    }

    public boolean inOverview() {
        return true;
    }

    public boolean inPackage() {
        return true;
    }

    public boolean inType() {
        return true;
    }

    public boolean isInlineTag() {
        return false;
    }

    public static void register(Map tagletMap) {
        AuthorTaglet authorTaglet = new AuthorTaglet();
        tagletMap.put(authorTaglet.getName(), authorTaglet);
    }

    public String toString(Tag tag) {
        if (enabled) {
            return this.toString(new Tag[]{tag});
        }
        return null;
    }

    public String toString(Tag[] tags) {
        if (!enabled || tags.length == 0) {
            return null;
        }
        boolean haveValidTag = false;
        int i = 0;
        while (i < tags.length && !haveValidTag) {
            if (tags[i].text().length() > 0) {
                haveValidTag = true;
            }
            ++i;
        }
        if (haveValidTag) {
            StringBuffer result = new StringBuffer();
            result.append("<dl class=\"tag list\">");
            result.append("<dt class=\"tag section header\"><b>");
            if (tags.length == 1) {
                result.append(SINGLE_HEADER);
            } else {
                result.append(MULTI_HEADER);
            }
            result.append("</b></dt>");
            int i2 = 0;
            while (i2 < tags.length) {
                result.append("<dd class=\"tag item\">");
                result.append(this.replaceEmail(tags[i2].text()));
                result.append("</dd>");
                ++i2;
            }
            result.append("</dl>");
            return result.toString();
        }
        return null;
    }

    private String replaceEmail(String text) {
        if (EmailReplacement.NO_REPLACEMENT == emailReplacementType) {
            return text;
        }
        Matcher matcher = authorEmailPattern.matcher(text);
        if (matcher.matches()) {
            String realName = matcher.group(1);
            String emailAddress = matcher.group(2);
            if (EmailReplacement.MAILTO_NAME == emailReplacementType) {
                return "<a href=\"mailto:" + emailAddress + "\">" + realName + "</a>";
            }
            if (EmailReplacement.NAME_MAILTO_ADDRESS == emailReplacementType) {
                return String.valueOf(realName) + " (<a href=\"mailto:" + emailAddress + "\">" + emailAddress + "</a>)";
            }
            if (EmailReplacement.NAME_MANGLED_ADDRESS == emailReplacementType) {
                Matcher dotMatcher = dotPattern.matcher(emailAddress);
                Matcher atMatcher = atPattern.matcher(dotMatcher.replaceAll(dotReplacement));
                String mangledAddress = atMatcher.replaceAll(atReplacement);
                return String.valueOf(realName) + " (" + mangledAddress + ")";
            }
            return text;
        }
        return text;
    }

    public static void setEmailReplacementType(EmailReplacement emailReplacementType) {
        if (emailReplacementType == null) {
            throw new NullPointerException();
        }
        AuthorTaglet.emailReplacementType = emailReplacementType;
    }

    public static void setAtReplacement(String atReplacement) {
        AuthorTaglet.atReplacement = atReplacement;
    }

    public static void setDotReplacement(String dotReplacement) {
        AuthorTaglet.dotReplacement = dotReplacement;
    }

    public static void setTagletEnabled(boolean enabled) {
        AuthorTaglet.enabled = enabled;
    }

    public static class EmailReplacement {
        public static final EmailReplacement NO_REPLACEMENT = new EmailReplacement();
        public static final EmailReplacement MAILTO_NAME = new EmailReplacement();
        public static final EmailReplacement NAME_MAILTO_ADDRESS = new EmailReplacement();
        public static final EmailReplacement NAME_MANGLED_ADDRESS = new EmailReplacement();

        private EmailReplacement() {
        }
    }
}

