/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.jar;

import gnu.classpath.tools.jar.Main;
import gnu.classpath.tools.jar.Messages;
import gnu.classpath.tools.jar.Updater;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class Indexer
extends Updater {
    private void indexJarFile(StringBuilder result, File fileName, boolean verbose) throws IOException {
        Manifest manifest;
        if (verbose) {
            String msg = MessageFormat.format(Messages.getString("Indexer.Indexing"), fileName);
            System.err.println(msg);
        }
        JarFile jf = new JarFile(fileName);
        LinkedHashSet<Object> entries = new LinkedHashSet<Object>();
        Enumeration<JarEntry> e = jf.entries();
        while (e.hasMoreElements()) {
            JarEntry jarEntry = e.nextElement();
            Object name = jarEntry.getName();
            if (((String)name).startsWith("META-INF/")) continue;
            int index = ((String)name).lastIndexOf(47);
            if (index != -1) {
                name = ((String)name).substring(0, index);
            }
            entries.add(name);
        }
        if (!entries.isEmpty()) {
            result.append(fileName);
            result.append('\n');
            for (String string : entries) {
                result.append(string);
                result.append('\n');
            }
            result.append('\n');
        }
        if ((manifest = jf.getManifest()) != null) {
            File parent = fileName.getParentFile();
            Attributes attrs = manifest.getMainAttributes();
            String jars = attrs.getValue(Attributes.Name.CLASS_PATH);
            if (jars != null) {
                StringTokenizer st = new StringTokenizer(jars, " ");
                while (st.hasMoreTokens()) {
                    String name = st.nextToken();
                    this.indexJarFile(result, new File(parent, name), verbose);
                }
            }
        }
        jf.close();
    }

    protected void writeCommandLineEntries(Main parameters, OutputStream os) throws IOException {
        super.writeCommandLineEntries(parameters, os);
        StringBuilder contents = new StringBuilder();
        this.indexJarFile(contents, parameters.archiveFile, parameters.verbose);
        if (contents.length() != 0) {
            contents.insert(0, "1.0\n\n");
            contents.insert(0, "JarIndex-Version: ");
            ByteArrayInputStream in = new ByteArrayInputStream(contents.toString().getBytes());
            this.writeFile(false, in, "META-INF/INDEX.LIST", parameters.verbose);
        }
    }
}

