/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.gjdoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Type;
import gnu.classpath.tools.gjdoc.ClassDocImpl;
import gnu.classpath.tools.gjdoc.ClassDocProxy;
import gnu.classpath.tools.gjdoc.Debug;
import gnu.classpath.tools.gjdoc.Main;
import gnu.classpath.tools.gjdoc.ParseException;
import gnu.classpath.tools.gjdoc.ProgramElementDocImpl;
import gnu.classpath.tools.gjdoc.TagContainer;

public abstract class MemberDocImpl
extends ProgramElementDocImpl
implements MemberDoc {
    protected String typeName;
    protected Type type;
    private String name;

    public MemberDocImpl(ClassDoc containingClass, PackageDoc containingPackage, SourcePosition position) {
        super(containingClass, containingPackage, position);
    }

    public String qualifiedName() {
        return String.valueOf(this.containingClass().qualifiedName()) + "." + this.name();
    }

    public boolean isSynthetic() {
        return false;
    }

    int parseModifiers(char[] source, int startIndex, int endIndex) {
        Debug.log(9, "parseModifiers '" + new String(source, startIndex, endIndex - startIndex) + "'");
        int state = 1;
        StringBuffer word = new StringBuffer();
        StringBuffer typeNameBuf = new StringBuffer();
        int lastWordStart = startIndex;
        int firstChar = 0;
        int lastChar = 0;
        while (startIndex < endIndex) {
            if (state == 2) {
                if (startIndex < endIndex - 1 && source[startIndex] == '*' && source[startIndex + 1] == '/') {
                    ++startIndex;
                    state = 1;
                }
            } else if (state == 3) {
                if (source[startIndex] == '\n') {
                    state = 1;
                }
            } else if (startIndex < endIndex - 1 && source[startIndex] == '/' && source[startIndex + 1] == '*') {
                ++startIndex;
                state = 2;
            } else {
                if (source[startIndex] == '=' || source[startIndex] == '(' || source[startIndex] == ';') {
                    this.typeName = typeNameBuf.toString();
                    return lastWordStart;
                }
                if (" \t\r\n\f".indexOf(source[startIndex]) >= 0 || startIndex > 0 && source[startIndex - 1] == ']' && source[startIndex] != '[') {
                    if (word.length() > 0 && lastChar != 46) {
                        if (!this.processModifier(word.toString())) {
                            if (typeNameBuf.length() == 0 && !this.isConstructor()) {
                                typeNameBuf.setLength(0);
                                typeNameBuf.append(word);
                            } else if (!(firstChar != 91 && firstChar != 93 || this.isConstructor())) {
                                typeNameBuf.append(word);
                            } else {
                                this.typeName = typeNameBuf.toString();
                                return lastWordStart;
                            }
                        }
                        word.setLength(0);
                        lastWordStart = startIndex;
                    }
                } else {
                    if (lastWordStart < 0) {
                        lastWordStart = startIndex;
                    }
                    lastChar = source[startIndex];
                    if (word.length() == 0) {
                        firstChar = lastChar;
                    }
                    word.append((char)lastChar);
                }
            }
            ++startIndex;
        }
        this.typeName = typeNameBuf.toString();
        return startIndex;
    }

    public Type type() {
        Debug.log(9, "type() called on " + this.containingClass() + "." + this);
        if (this.type == null) {
            try {
                this.type = ((ClassDocImpl)this.containingClass()).typeForString(this.typeName);
            }
            catch (ParseException e) {
                System.err.println("FIXME: add try-catch to force compilation");
                e.printStackTrace();
            }
        }
        return this.type;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
        this.type = null;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isIncluded() {
        return Main.getInstance().includeAccessLevel(this.accessLevel);
    }

    public int compareTo(Doc d) {
        if (d instanceof MemberDocImpl) {
            int rc = this.name().compareTo(((MemberDocImpl)d).name());
            if (rc == 0) {
                rc = this.containingClass().qualifiedName().compareTo(((MemberDocImpl)d).containingClass().qualifiedName());
            }
            return rc;
        }
        return super.compareTo(d);
    }

    void resolve() {
        if (this.type == null && this.typeName != null) {
            Debug.log(1, "MemberDocImpl.resolve(), looking up type named " + this.typeName);
            try {
                this.type = ((ClassDocImpl)this.containingClass()).typeForString(this.typeName);
            }
            catch (ParseException parseException) {
                Debug.log(1, "INTERNAL WARNING: Couldn't find type for name '" + this.typeName + "'");
            }
        }
        if (this.type instanceof ClassDocProxy) {
            String className = this.type.qualifiedTypeName();
            ClassDoc realClassDoc = ((ClassDocImpl)this.containingClass()).findClass(className, this.type.dimension());
            if (realClassDoc != null) {
                this.type = realClassDoc;
            }
        }
    }

    public void resolveComments() {
        TagContainer inheritedTagMap;
        super.resolveComments();
        if (this.tagMap.isEmpty() && (inheritedTagMap = ClassDocImpl.findInheritedDoc(this.containingClass(), this, null)) != null) {
            this.tagMap = inheritedTagMap.getTagMap();
        }
    }
}

