/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.doclets;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import com.sun.tools.doclets.Taglet;
import gnu.classpath.tools.IOToolkit;
import gnu.classpath.tools.doclets.DocletConfigurationException;
import gnu.classpath.tools.doclets.DocletOption;
import gnu.classpath.tools.doclets.DocletOptionColonSeparated;
import gnu.classpath.tools.doclets.DocletOptionFile;
import gnu.classpath.tools.doclets.DocletOptionFlag;
import gnu.classpath.tools.doclets.DocletOptionPackageWildcard;
import gnu.classpath.tools.doclets.InlineTagRenderer;
import gnu.classpath.tools.doclets.InvalidPackageWildcardException;
import gnu.classpath.tools.doclets.PackageGroup;
import gnu.classpath.tools.doclets.PackageMatcher;
import gnu.classpath.tools.doclets.StandardTaglet;
import gnu.classpath.tools.doclets.TagletPrinter;
import gnu.classpath.tools.taglets.AuthorTaglet;
import gnu.classpath.tools.taglets.CodeTaglet;
import gnu.classpath.tools.taglets.DeprecatedTaglet;
import gnu.classpath.tools.taglets.GenericTaglet;
import gnu.classpath.tools.taglets.GnuExtendedTaglet;
import gnu.classpath.tools.taglets.SinceTaglet;
import gnu.classpath.tools.taglets.TagletContext;
import gnu.classpath.tools.taglets.ValueTaglet;
import gnu.classpath.tools.taglets.VersionTaglet;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDoclet {
    protected Map<String, Taglet> tagletMap = new LinkedHashMap<String, Taglet>();
    private List<PackageGroup> packageGroups = new LinkedList<PackageGroup>();
    private List<Taglet> mentionedTags = new LinkedList<Taglet>();
    private static AbstractDoclet instance;
    private RootDoc rootDoc;
    private DocletOptionFile optionTargetDirectory = new DocletOptionFile("-d", new File(System.getProperty("user.dir")));
    private DocletOptionFlag optionAuthor = new DocletOptionFlag("-author");
    private DocletOptionFlag optionVersion = new DocletOptionFlag("-version");
    private DocletOptionFlag optionNoSince = new DocletOptionFlag("-nosince");
    private DocletOptionFlag optionNoDeprecated = new DocletOptionFlag("-nodeprecated");
    private DocletOptionGroup optionGroup = new DocletOptionGroup("-group");
    private DocletOptionPackageWildcard optionNoQualifier = new DocletOptionPackageWildcard("-noqualifier", true);
    private DocletOptionFlag optionDocFilesSubDirs = new DocletOptionFlag("-docfilessubdirs");
    private DocletOptionColonSeparated optionExcludeDocFilesSubDir = new DocletOptionColonSeparated("-excludedocfilessubdir");
    private DocletOptionTag optionTaglet = new DocletOptionTag("-taglet");
    private DocletOptionTag optionTag = new DocletOptionTag("-tag");
    private DocletOption[] commonOptions = new DocletOption[]{this.optionTargetDirectory, this.optionAuthor, this.optionVersion, this.optionNoSince, this.optionNoDeprecated, this.optionGroup, this.optionDocFilesSubDirs, this.optionExcludeDocFilesSubDir, this.optionTaglet, this.optionTag};
    private boolean optionsRegistered = false;
    private Map<String, DocletOption> nameToOptionMap = new HashMap<String, DocletOption>();
    private Map<Character, List<Doc>> categorizedIndex;
    private Map<IndexKey, Doc> indexByName;
    private Map<ClassDoc, Map<PackageDoc, Map<UsageType, Set<Doc>>>> usedClassToPackagesMap = null;
    private ResourceBundle resources;
    private Set sourcePaths;
    private SortedSet allPackages;
    private Map allSubClasses;
    private Map interfaceRelations;
    private Map sortedMethodMap = new HashMap();
    private Map sortedConstructorMap = new HashMap();
    private Map sortedFieldMap = new HashMap();
    private Map sortedInnerClassMap = new HashMap();
    private Map implementedInterfacesCache = new HashMap();

    public static int optionLength(String option) {
        return instance.getOptionLength(option);
    }

    public static boolean validOptions(String[][] options) {
        return true;
    }

    protected static void setInstance(AbstractDoclet instance) {
        AbstractDoclet.instance = instance;
    }

    protected abstract void run() throws DocletConfigurationException, IOException;

    public static boolean start(RootDoc rootDoc) {
        try {
            instance.startInstance(rootDoc);
            return true;
        }
        catch (DocletConfigurationException e) {
            instance.printError(e.getMessage());
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected RootDoc getRootDoc() {
        return this.rootDoc;
    }

    protected abstract InlineTagRenderer getInlineTagRenderer();

    private void startInstance(RootDoc rootDoc) throws DocletConfigurationException, IOException {
        this.rootDoc = rootDoc;
        this.registerTaglet(new VersionTaglet());
        this.registerTaglet(new AuthorTaglet());
        this.registerTaglet(new SinceTaglet(this.getInlineTagRenderer()));
        this.registerTaglet(new StandardTaglet("serial"));
        this.registerTaglet(new StandardTaglet("deprecated"));
        this.registerTaglet(new StandardTaglet("see"));
        this.registerTaglet(new StandardTaglet("param"));
        this.registerTaglet(new StandardTaglet("return"));
        this.registerTaglet(new ValueTaglet());
        this.registerTaglet(new CodeTaglet());
        int i = 0;
        int ilim = rootDoc.options().length;
        while (i < ilim) {
            String[] optionArr = rootDoc.options()[i];
            String _optionTag = optionArr[0];
            DocletOption option = this.nameToOptionMap.get(_optionTag.toLowerCase());
            if (option != null) {
                option.set(optionArr);
            }
            ++i;
        }
        AuthorTaglet.setTagletEnabled(this.optionAuthor.getValue());
        VersionTaglet.setTagletEnabled(this.optionVersion.getValue());
        SinceTaglet.setTagletEnabled(!this.optionNoSince.getValue());
        DeprecatedTaglet.setTagletEnabled(!this.optionNoDeprecated.getValue());
        if (!this.getTargetDirectory().exists() && !this.getTargetDirectory().mkdirs()) {
            throw new DocletConfigurationException("Cannot create target directory " + this.getTargetDirectory());
        }
        this.run();
    }

    public File getTargetDirectory() {
        return this.optionTargetDirectory.getValue();
    }

    private void registerOptions() {
        if (!this.optionsRegistered) {
            int i = 0;
            while (i < this.commonOptions.length) {
                DocletOption option = this.commonOptions[i];
                this.registerOption(option);
                ++i;
            }
            DocletOption[] docletOptions = this.getOptions();
            int i2 = 0;
            while (i2 < docletOptions.length) {
                DocletOption option = docletOptions[i2];
                this.registerOption(option);
                ++i2;
            }
            this.optionsRegistered = true;
        }
    }

    protected abstract DocletOption[] getOptions();

    private void registerOption(DocletOption option) {
        this.nameToOptionMap.put(option.getName(), option);
    }

    private int getOptionLength(String optionName) {
        this.registerOptions();
        DocletOption option = this.nameToOptionMap.get(optionName.toLowerCase());
        if (option != null) {
            return option.getLength();
        }
        return -1;
    }

    protected List<ClassDoc> getKnownDirectSubclasses(ClassDoc classDoc) {
        LinkedList<ClassDoc> result = new LinkedList<ClassDoc>();
        if (!"java.lang.Object".equals(classDoc.qualifiedName())) {
            ClassDoc[] classes = this.rootDoc.classes();
            int i = 0;
            while (i < classes.length) {
                if (classDoc == classes[i].superclass()) {
                    result.add(classes[i]);
                }
                ++i;
            }
        }
        return result;
    }

    protected Map<Character, List<Doc>> getCategorizedIndex() {
        if (this.categorizedIndex == null) {
            this.categorizedIndex = new LinkedHashMap<Character, List<Doc>>();
            Map<IndexKey, Doc> indexMap = this.getIndexByName();
            LinkedList<IndexKey> keys = new LinkedList<IndexKey>();
            keys.addAll(indexMap.keySet());
            Collections.sort(keys);
            Iterator it = keys.iterator();
            char previousCategoryLetter = '\u0000';
            Character keyLetter = null;
            while (it.hasNext()) {
                IndexKey key = (IndexKey)it.next();
                char firstChar = Character.toUpperCase(key.getName().charAt(0));
                if (firstChar != previousCategoryLetter) {
                    keyLetter = new Character(firstChar);
                    previousCategoryLetter = firstChar;
                    this.categorizedIndex.put(keyLetter, new LinkedList());
                }
                List<Doc> letterList = this.categorizedIndex.get(keyLetter);
                letterList.add(indexMap.get(key));
            }
        }
        return this.categorizedIndex;
    }

    protected Map<IndexKey, Doc> getIndexByName() {
        if (this.indexByName == null) {
            this.indexByName = new HashMap<IndexKey, Doc>();
            PackageDoc[] packages = this.rootDoc.specifiedPackages();
            int i = 0;
            int ilim = packages.length;
            while (i < ilim) {
                PackageDoc c = packages[i];
                if (c.name().length() > 0) {
                    this.indexByName.put(new IndexKey(c.name()), c);
                }
                ++i;
            }
            ClassDoc[] sumclasses = this.rootDoc.classes();
            int i2 = 0;
            int ilim2 = sumclasses.length;
            while (i2 < ilim2) {
                ClassDoc c = sumclasses[i2];
                if (c.containingClass() == null) {
                    this.indexByName.put(new IndexKey(String.valueOf(c.name()) + " " + c.containingPackage().name()), c);
                } else {
                    this.indexByName.put(new IndexKey(String.valueOf(c.name().substring(c.containingClass().name().length() + 1)) + " " + c.containingClass().name() + " " + c.containingPackage().name()), c);
                }
                FieldDoc[] fields = c.fields();
                int j = 0;
                int jlim = fields.length;
                while (j < jlim) {
                    this.indexByName.put(new IndexKey(String.valueOf(fields[j].name()) + " " + fields[j].containingClass().name() + " " + fields[j].containingPackage().name()), fields[j]);
                    ++j;
                }
                MethodDoc[] methods = c.methods();
                int j2 = 0;
                int jlim2 = methods.length;
                while (j2 < jlim2) {
                    MethodDoc method = methods[j2];
                    this.indexByName.put(new IndexKey(String.valueOf(method.name()) + method.signature() + " " + method.containingClass().name() + " " + method.containingPackage().name()), method);
                    ++j2;
                }
                ConstructorDoc[] constructors = c.constructors();
                int j3 = 0;
                int jlim3 = constructors.length;
                while (j3 < jlim3) {
                    ConstructorDoc constructor = constructors[j3];
                    this.indexByName.put(new IndexKey(String.valueOf(constructor.name()) + constructor.signature() + " " + constructor.containingClass().name() + " " + constructor.containingPackage().name()), constructor);
                    ++j3;
                }
                ++i2;
            }
        }
        return this.indexByName;
    }

    private void registerTaglet(Taglet taglet) {
        this.tagletMap.put(taglet.getName(), taglet);
    }

    protected void printTaglets(Tag[] tags, TagletContext context, TagletPrinter output, boolean inline) {
        for (String tagName : this.tagletMap.keySet()) {
            Taglet taglet = this.tagletMap.get(tagName);
            Doc doc = context.getDoc();
            if (inline != taglet.isInlineTag() || !(doc == null && taglet.inOverview()) && (doc == null || !(doc.isConstructor() && taglet.inConstructor() || doc.isField() && taglet.inField() || doc.isMethod() && taglet.inMethod() || doc instanceof PackageDoc && taglet.inPackage()) && (!doc.isClass() && !doc.isInterface() || !taglet.inType()))) continue;
            LinkedList<Tag> tagsOfThisType = new LinkedList<Tag>();
            int i = 0;
            while (i < tags.length) {
                if (tags[i].name().substring(1).equals(tagName)) {
                    tagsOfThisType.add(tags[i]);
                }
                ++i;
            }
            Tag[] tagletTags = tagsOfThisType.toArray(new Tag[tagsOfThisType.size()]);
            String tagletString = taglet instanceof StandardTaglet ? this.renderTag(tagName, tagletTags, context) : (taglet instanceof GnuExtendedTaglet ? ((GnuExtendedTaglet)taglet).toString(tagletTags, context) : taglet.toString(tagletTags));
            if (tagletString == null) continue;
            output.printTagletString(tagletString);
        }
    }

    protected void printInlineTaglet(Tag tag, TagletContext context, TagletPrinter output) {
        Taglet taglet = this.tagletMap.get(tag.name().substring(1));
        if (taglet != null) {
            String tagletString = taglet instanceof GnuExtendedTaglet ? ((GnuExtendedTaglet)taglet).toString(tag, context) : taglet.toString(tag);
            if (tagletString != null) {
                output.printTagletString(tagletString);
            }
        } else {
            this.printWarning("Unknown tag: " + tag.name());
        }
    }

    protected void printMainTaglets(Tag[] tags, TagletContext context, TagletPrinter output) {
        this.printTaglets(tags, context, output, false);
    }

    private void addUsedBy(Map<ClassDoc, Map<PackageDoc, Map<UsageType, Set<Doc>>>> usedClassToPackagesMap, ClassDoc usedClass, UsageType usageType, Doc user, PackageDoc userPackage) {
        Set<Doc> userSet;
        Map<UsageType, Set<Doc>> usageTypeToUsersMap;
        Map<PackageDoc, Map<UsageType, Set<Doc>>> packageToUsageTypeMap = usedClassToPackagesMap.get(usedClass);
        if (packageToUsageTypeMap == null) {
            packageToUsageTypeMap = new HashMap<PackageDoc, Map<UsageType, Set<Doc>>>();
            usedClassToPackagesMap.put(usedClass, packageToUsageTypeMap);
        }
        if ((usageTypeToUsersMap = packageToUsageTypeMap.get(userPackage)) == null) {
            usageTypeToUsersMap = new TreeMap<UsageType, Set<Doc>>();
            packageToUsageTypeMap.put(userPackage, usageTypeToUsersMap);
        }
        if ((userSet = usageTypeToUsersMap.get(usageType)) == null) {
            userSet = new TreeSet<Doc>();
            usageTypeToUsersMap.put(usageType, userSet);
        }
        userSet.add(user);
    }

    private Map collectUsage() {
        HashMap<ClassDoc, Map<PackageDoc, Map<UsageType, Set<Doc>>>> _usedClassToPackagesMap = new HashMap<ClassDoc, Map<PackageDoc, Map<UsageType, Set<Doc>>>>();
        ClassDoc[] classes = this.rootDoc.classes();
        int i = 0;
        int ilim = classes.length;
        while (i < ilim) {
            ClassDoc thrownException;
            int klim;
            int k;
            ClassDoc[] thrownExceptions;
            Parameter[] parameters;
            ClassDoc clazz = classes[i];
            if (clazz.isInterface()) {
                InterfaceRelation relation = (InterfaceRelation)this.getInterfaceRelations().get(clazz);
                for (ClassDoc implementor : relation.implementingClasses) {
                    this.addUsedBy(_usedClassToPackagesMap, clazz, UsageType.CLASS_IMPLEMENTING, implementor, implementor.containingPackage());
                }
            } else {
                ClassDoc superclass = clazz.superclass();
                while (superclass != null) {
                    this.addUsedBy(_usedClassToPackagesMap, superclass, UsageType.CLASS_DERIVED_FROM, clazz, clazz.containingPackage());
                    superclass = superclass.superclass();
                }
            }
            FieldDoc[] fields = clazz.fields();
            int j = 0;
            int jlim = fields.length;
            while (j < jlim) {
                FieldDoc field = fields[j];
                ClassDoc fieldType = field.type().asClassDoc();
                if (fieldType != null) {
                    this.addUsedBy(_usedClassToPackagesMap, fieldType, UsageType.FIELD_OF_TYPE, field, clazz.containingPackage());
                }
                ++j;
            }
            MethodDoc[] methods = clazz.methods();
            int j2 = 0;
            int jlim2 = methods.length;
            while (j2 < jlim2) {
                MethodDoc method = methods[j2];
                ClassDoc returnType = method.returnType().asClassDoc();
                if (returnType != null) {
                    this.addUsedBy(_usedClassToPackagesMap, returnType, UsageType.METHOD_WITH_RETURN_TYPE, method, clazz.containingPackage());
                }
                parameters = method.parameters();
                int k2 = 0;
                while (k2 < parameters.length) {
                    Parameter parameter = parameters[k2];
                    ClassDoc parameterType = parameter.type().asClassDoc();
                    if (parameterType != null) {
                        this.addUsedBy(_usedClassToPackagesMap, parameterType, UsageType.METHOD_WITH_PARAMETER_TYPE, method, clazz.containingPackage());
                    }
                    ++k2;
                }
                thrownExceptions = method.thrownExceptions();
                k = 0;
                klim = thrownExceptions.length;
                while (k < klim) {
                    thrownException = thrownExceptions[k];
                    this.addUsedBy(_usedClassToPackagesMap, thrownException, UsageType.METHOD_WITH_THROWN_TYPE, method, clazz.containingPackage());
                    ++k;
                }
                ++j2;
            }
            ConstructorDoc[] constructors = clazz.constructors();
            int j3 = 0;
            int jlim3 = constructors.length;
            while (j3 < jlim3) {
                ConstructorDoc constructor = constructors[j3];
                parameters = constructor.parameters();
                int k3 = 0;
                int klim2 = parameters.length;
                while (k3 < klim2) {
                    Parameter parameter = parameters[k3];
                    ClassDoc parameterType = parameter.type().asClassDoc();
                    if (parameterType != null) {
                        this.addUsedBy(_usedClassToPackagesMap, parameterType, UsageType.CONSTRUCTOR_WITH_PARAMETER_TYPE, constructor, clazz.containingPackage());
                    }
                    ++k3;
                }
                thrownExceptions = constructor.thrownExceptions();
                k = 0;
                klim = thrownExceptions.length;
                while (k < klim) {
                    thrownException = thrownExceptions[k];
                    this.addUsedBy(_usedClassToPackagesMap, thrownException, UsageType.CONSTRUCTOR_WITH_THROWN_TYPE, constructor, clazz.containingPackage());
                    ++k;
                }
                ++j3;
            }
            ++i;
        }
        return _usedClassToPackagesMap;
    }

    protected Map<PackageDoc, Map<UsageType, Set<Doc>>> getUsageOfClass(ClassDoc classDoc) {
        if (this.usedClassToPackagesMap == null) {
            this.usedClassToPackagesMap = this.collectUsage();
        }
        return this.usedClassToPackagesMap.get(classDoc);
    }

    protected String getString(String key) {
        if (this.resources == null) {
            Locale currentLocale = Locale.getDefault();
            this.resources = ResourceBundle.getBundle("htmldoclet.HtmlDoclet", currentLocale);
        }
        return this.resources.getString(key);
    }

    protected String format(String key, String value1) {
        return MessageFormat.format(this.getString(key), value1);
    }

    protected List<PackageGroup> getPackageGroups() {
        return this.packageGroups;
    }

    protected void copyDocFiles(File sourceDir, File targetDir) throws IOException {
        File sourceDocFiles = new File(sourceDir, "doc-files");
        File targetDocFiles = new File(targetDir, "doc-files");
        if (sourceDocFiles.exists()) {
            IOToolkit.copyDirectory(sourceDocFiles, targetDocFiles, this.optionDocFilesSubDirs.getValue(), this.optionExcludeDocFilesSubDir.getComponents());
        }
    }

    protected List getPackageSourceDirs(PackageDoc packageDoc) throws IOException {
        if (this.sourcePaths == null) {
            int i = 0;
            while (i < this.rootDoc.options().length) {
                if ("-sourcepath".equals(this.rootDoc.options()[i][0]) || "-s".equals(this.rootDoc.options()[i][0])) {
                    this.sourcePaths = new LinkedHashSet();
                    String sourcepathString = this.rootDoc.options()[i][1];
                    StringTokenizer st = new StringTokenizer(sourcepathString, File.pathSeparator);
                    while (st.hasMoreTokens()) {
                        this.sourcePaths.add(new File(st.nextToken()));
                    }
                }
                ++i;
            }
            if (this.sourcePaths == null) {
                this.sourcePaths = new LinkedHashSet();
                this.sourcePaths.add(new File(System.getProperty("user.dir")));
            }
        }
        String packageSubDir = packageDoc.name().replace('.', File.separatorChar);
        Iterator it = this.sourcePaths.iterator();
        LinkedList<File> result = new LinkedList<File>();
        while (it.hasNext()) {
            File pathComponent = (File)it.next();
            File packageDir = new File(pathComponent, packageSubDir);
            if (!packageDir.exists()) continue;
            result.add(packageDir);
        }
        if (result.isEmpty()) {
            throw new IOException("Couldn't locate source directory for package " + packageDoc.name());
        }
        return result;
    }

    protected File getSourceFile(ClassDoc classDoc) throws IOException {
        List packageDirs = this.getPackageSourceDirs(classDoc.containingPackage());
        for (File packageDir : packageDirs) {
            File sourceFile = new File(packageDir, String.valueOf(AbstractDoclet.getOuterClassDoc(classDoc).name()) + ".java");
            if (!sourceFile.exists()) continue;
            return sourceFile;
        }
        throw new IOException("Couldn't locate source file for class " + classDoc.qualifiedTypeName());
    }

    protected void printError(String error) {
        if (this.rootDoc != null) {
            this.rootDoc.printError(error);
        } else {
            System.err.println("ERROR: " + error);
        }
    }

    protected void printWarning(String warning) {
        if (this.rootDoc != null) {
            this.rootDoc.printWarning(warning);
        } else {
            System.err.println("WARNING: " + warning);
        }
    }

    protected void printNotice(String notice) {
        if (this.rootDoc != null) {
            this.rootDoc.printNotice(notice);
        } else {
            System.err.println(notice);
        }
    }

    protected static ClassDoc getOuterClassDoc(ClassDoc classDoc) {
        while (classDoc.containingClass() != null) {
            classDoc = classDoc.containingClass();
        }
        return classDoc;
    }

    protected Set getAllPackages() {
        if (this.allPackages == null) {
            this.allPackages = new TreeSet();
            PackageDoc[] specifiedPackages = this.rootDoc.specifiedPackages();
            int i = 0;
            while (i < specifiedPackages.length) {
                this.allPackages.add(specifiedPackages[i]);
                ++i;
            }
            ClassDoc[] specifiedClasses = this.rootDoc.specifiedClasses();
            int i2 = 0;
            while (i2 < specifiedClasses.length) {
                this.allPackages.add(specifiedClasses[i2].containingPackage());
                ++i2;
            }
        }
        return this.allPackages;
    }

    protected boolean omitPackageQualifier(PackageDoc packageDoc) {
        if (!this.optionNoQualifier.isSpecified()) {
            return false;
        }
        return this.optionNoQualifier.match(packageDoc);
    }

    protected String possiblyQualifiedName(Type type) {
        if (type.asClassDoc() == null || !this.omitPackageQualifier(type.asClassDoc().containingPackage())) {
            return type.qualifiedTypeName();
        }
        return type.typeName();
    }

    private void addAllInterfaces(ClassDoc classDoc, Set allInterfaces) {
        ClassDoc[] interfaces = classDoc.interfaces();
        int i = 0;
        while (i < interfaces.length) {
            allInterfaces.add(interfaces[i]);
            this.addAllInterfaces(interfaces[i], allInterfaces);
            ++i;
        }
    }

    protected Map getAllSubClasses() {
        if (this.allSubClasses == null) {
            this.allSubClasses = new HashMap();
            ClassDoc[] classDocs = this.getRootDoc().classes();
            int i = 0;
            while (i < classDocs.length) {
                if (!classDocs[i].isInterface()) {
                    ClassDoc cd = classDocs[i].superclass();
                    while (cd != null) {
                        if (!cd.qualifiedTypeName().equals("java.lang.Object")) {
                            LinkedList<ClassDoc> subClasses = (LinkedList<ClassDoc>)this.allSubClasses.get(cd);
                            if (subClasses == null) {
                                subClasses = new LinkedList<ClassDoc>();
                                this.allSubClasses.put(cd, subClasses);
                            }
                            subClasses.add(classDocs[i]);
                        }
                        cd = cd.superclass();
                    }
                }
                ++i;
            }
        }
        return this.allSubClasses;
    }

    private void addToInterfaces(ClassDoc classDoc, ClassDoc[] interfaces) {
        int i = 0;
        while (i < interfaces.length) {
            InterfaceRelation interfaceRelation = (InterfaceRelation)this.interfaceRelations.get(interfaces[i]);
            if (interfaceRelation == null) {
                interfaceRelation = new InterfaceRelation();
                this.interfaceRelations.put(interfaces[i], interfaceRelation);
            }
            interfaceRelation.implementingClasses.add(classDoc);
            this.addToInterfaces(classDoc, interfaces[i].interfaces());
            ++i;
        }
    }

    protected Map getInterfaceRelations() {
        if (this.interfaceRelations == null) {
            this.interfaceRelations = new HashMap();
            ClassDoc[] classDocs = this.getRootDoc().classes();
            int i = 0;
            while (i < classDocs.length) {
                if (classDocs[i].isInterface()) {
                    InterfaceRelation relation = new InterfaceRelation();
                    this.addAllInterfaces(classDocs[i], relation.superInterfaces);
                    this.interfaceRelations.put(classDocs[i], relation);
                }
                ++i;
            }
            for (ClassDoc interfaceDoc : this.interfaceRelations.keySet()) {
                InterfaceRelation relation = (InterfaceRelation)this.interfaceRelations.get(interfaceDoc);
                for (ClassDoc superInterfaceDoc : relation.superInterfaces) {
                    InterfaceRelation superRelation = (InterfaceRelation)this.interfaceRelations.get(superInterfaceDoc);
                    if (superRelation == null) continue;
                    superRelation.subInterfaces.add(interfaceDoc);
                }
            }
            int i2 = 0;
            while (i2 < classDocs.length) {
                if (!classDocs[i2].isInterface()) {
                    ClassDoc cd = classDocs[i2];
                    while (cd != null) {
                        this.addToInterfaces(classDocs[i2], cd.interfaces());
                        cd = cd.superclass();
                    }
                }
                ++i2;
            }
        }
        return this.interfaceRelations;
    }

    protected MethodDoc[] getSortedMethods(ClassDoc classDoc) {
        Object[] result = (MethodDoc[])this.sortedMethodMap.get(classDoc);
        if (result == null) {
            MethodDoc[] methods = classDoc.methods();
            result = (MethodDoc[])methods.clone();
            Arrays.sort(result);
            return result;
        }
        return result;
    }

    protected ConstructorDoc[] getSortedConstructors(ClassDoc classDoc) {
        Object[] result = (ConstructorDoc[])this.sortedConstructorMap.get(classDoc);
        if (result == null) {
            ConstructorDoc[] constructors = classDoc.constructors();
            result = (ConstructorDoc[])constructors.clone();
            Arrays.sort(result);
            return result;
        }
        return result;
    }

    protected FieldDoc[] getSortedFields(ClassDoc classDoc) {
        Object[] result = (FieldDoc[])this.sortedFieldMap.get(classDoc);
        if (result == null) {
            FieldDoc[] fields = classDoc.fields();
            result = (FieldDoc[])fields.clone();
            Arrays.sort(result);
            return result;
        }
        return result;
    }

    protected ClassDoc[] getSortedInnerClasses(ClassDoc classDoc) {
        Object[] result = (ClassDoc[])this.sortedInnerClassMap.get(classDoc);
        if (result == null) {
            ClassDoc[] innerClasses = classDoc.innerClasses();
            result = (ClassDoc[])innerClasses.clone();
            Arrays.sort(result);
            return result;
        }
        return result;
    }

    protected abstract String renderTag(String var1, Tag[] var2, TagletContext var3);

    protected abstract String getDocletVersion();

    protected SortedSet getThrownExceptions(ExecutableMemberDoc execMemberDoc) {
        TreeSet<ClassDoc> result = new TreeSet<ClassDoc>();
        ClassDoc[] thrownExceptions = execMemberDoc.thrownExceptions();
        int j = 0;
        while (j < thrownExceptions.length) {
            result.add(thrownExceptions[j]);
            ++j;
        }
        return result;
    }

    protected boolean isUncheckedException(ClassDoc classDoc) {
        if (classDoc.isException()) {
            while (classDoc != null) {
                if (classDoc.qualifiedTypeName().equals("java.lang.RuntimeException")) {
                    return true;
                }
                classDoc = classDoc.superclass();
            }
            return false;
        }
        return false;
    }

    protected FieldDoc findField(ClassDoc classDoc, String fieldName) {
        ClassDoc cd = classDoc;
        while (cd != null) {
            FieldDoc[] fields = cd.fields(false);
            int i = 0;
            while (i < fields.length) {
                if (fields[i].name().equals(fieldName)) {
                    return fields[i];
                }
                ++i;
            }
            cd = cd.superclass();
        }
        return null;
    }

    protected Set getImplementedInterfaces(ClassDoc classDoc) {
        TreeSet<ClassDoc> result = (TreeSet<ClassDoc>)this.implementedInterfacesCache.get(classDoc);
        if (result == null) {
            result = new TreeSet<ClassDoc>();
            ClassDoc cd = classDoc;
            while (cd != null) {
                ClassDoc[] interfaces = cd.interfaces();
                int i = 0;
                while (i < interfaces.length) {
                    result.add(interfaces[i]);
                    InterfaceRelation relation = (InterfaceRelation)this.getInterfaceRelations().get(interfaces[i]);
                    if (relation != null) {
                        result.addAll(relation.superInterfaces);
                    }
                    ++i;
                }
                cd = cd.superclass();
            }
            this.implementedInterfacesCache.put(classDoc, result);
        }
        return result;
    }

    protected boolean isSinglePackage() {
        return this.getAllPackages().size() <= 1;
    }

    protected PackageDoc getSinglePackage() {
        return (PackageDoc)this.getAllPackages().iterator().next();
    }

    private class DocletOptionGroup
    extends DocletOption {
        DocletOptionGroup(String optionName) {
            super(optionName);
        }

        public int getLength() {
            return 3;
        }

        public boolean set(String[] optionArr) {
            try {
                PackageMatcher packageMatcher = new PackageMatcher();
                StringTokenizer tokenizer = new StringTokenizer(optionArr[2], ":");
                while (tokenizer.hasMoreTokens()) {
                    String packageWildcard = tokenizer.nextToken();
                    packageMatcher.addWildcard(packageWildcard);
                }
                SortedSet<PackageDoc> groupPackages = packageMatcher.filter(AbstractDoclet.this.rootDoc.specifiedPackages());
                AbstractDoclet.this.packageGroups.add(new PackageGroup(optionArr[1], groupPackages));
                return true;
            }
            catch (InvalidPackageWildcardException invalidPackageWildcardException) {
                return false;
            }
        }
    }

    private class DocletOptionTag
    extends DocletOption {
        DocletOptionTag(String optionName) {
            super(optionName);
        }

        public int getLength() {
            return 2;
        }

        public boolean set(String[] optionArr) {
            String tagSpec = optionArr[1];
            boolean validTagSpec = false;
            int ndx1 = tagSpec.indexOf(58);
            if (ndx1 < 0) {
                Taglet taglet = AbstractDoclet.this.tagletMap.get(tagSpec);
                if (taglet == null) {
                    AbstractDoclet.this.printError("There is no standard tag '" + tagSpec + "'.");
                } else if (AbstractDoclet.this.mentionedTags.contains(taglet)) {
                    AbstractDoclet.this.printError("Tag '" + tagSpec + "' has been added or moved before.");
                } else {
                    AbstractDoclet.this.mentionedTags.add(taglet);
                    AbstractDoclet.this.tagletMap.remove(tagSpec);
                    AbstractDoclet.this.tagletMap.put(tagSpec, taglet);
                }
            } else {
                int ndx2 = tagSpec.indexOf(58, ndx1 + 1);
                if (ndx2 > ndx1 && ndx2 < tagSpec.length() - 1) {
                    String tagName = tagSpec.substring(0, ndx1);
                    String tagHead = null;
                    if (tagSpec.charAt(ndx2 + 1) == '\"') {
                        if (tagSpec.charAt(tagSpec.length() - 1) == '\"') {
                            tagHead = tagSpec.substring(ndx2 + 2, tagSpec.length() - 1);
                            validTagSpec = true;
                        }
                    } else {
                        tagHead = tagSpec.substring(ndx2 + 1);
                        validTagSpec = true;
                    }
                    boolean tagScopeOverview = false;
                    boolean tagScopePackages = false;
                    boolean tagScopeTypes = false;
                    boolean tagScopeConstructors = false;
                    boolean tagScopeMethods = false;
                    boolean tagScopeFields = false;
                    boolean tagDisabled = false;
                    int n = ndx1 + 1;
                    block10: while (n < ndx2) {
                        switch (tagSpec.charAt(n)) {
                            case 'X': {
                                tagDisabled = true;
                                break;
                            }
                            case 'a': {
                                tagScopeOverview = true;
                                tagScopePackages = true;
                                tagScopeTypes = true;
                                tagScopeConstructors = true;
                                tagScopeMethods = true;
                                tagScopeFields = true;
                                break;
                            }
                            case 'o': {
                                tagScopeOverview = true;
                                break;
                            }
                            case 'p': {
                                tagScopePackages = true;
                                break;
                            }
                            case 't': {
                                tagScopeTypes = true;
                                break;
                            }
                            case 'c': {
                                tagScopeConstructors = true;
                                break;
                            }
                            case 'm': {
                                tagScopeMethods = true;
                                break;
                            }
                            case 'f': {
                                tagScopeFields = true;
                                break;
                            }
                            default: {
                                validTagSpec = false;
                                break block10;
                            }
                        }
                        ++n;
                    }
                    if (validTagSpec) {
                        GenericTaglet taglet = new GenericTaglet(tagName, tagHead, tagScopeOverview, tagScopePackages, tagScopeTypes, tagScopeConstructors, tagScopeMethods, tagScopeFields);
                        taglet.setTagletEnabled(!tagDisabled);
                        taglet.register(AbstractDoclet.this.tagletMap);
                        AbstractDoclet.this.mentionedTags.add(taglet);
                    }
                }
            }
            if (!validTagSpec) {
                AbstractDoclet.this.printError("Value for option -tag must be in format \"<tagname>:Xaoptcmf:<taghead>\".");
            }
            return validTagSpec;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class IndexKey
    implements Comparable<IndexKey> {
        private String name;
        private String lowerName;

        public IndexKey(String name) {
            this.name = name;
            this.lowerName = name.toLowerCase();
        }

        public boolean equals(Object other) {
            return this.lowerName.equals(((IndexKey)other).lowerName);
        }

        public int hashCode() {
            return this.lowerName.hashCode();
        }

        @Override
        public int compareTo(IndexKey ik) {
            return this.lowerName.compareTo(ik.lowerName);
        }

        public String getName() {
            return this.name;
        }
    }

    protected static class InterfaceRelation {
        public Set superInterfaces = new TreeSet();
        public Set subInterfaces = new TreeSet();
        public Set implementingClasses = new TreeSet();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class UsageType
    implements Comparable<UsageType> {
        public static final UsageType CLASS_DERIVED_FROM = new UsageType("class-derived-from");
        public static final UsageType CLASS_IMPLEMENTING = new UsageType("class-implementing");
        public static final UsageType FIELD_OF_TYPE = new UsageType("field-of-type");
        public static final UsageType METHOD_WITH_RETURN_TYPE = new UsageType("method-with-return-type");
        public static final UsageType METHOD_WITH_PARAMETER_TYPE = new UsageType("method-with-parameter-type");
        public static final UsageType METHOD_WITH_THROWN_TYPE = new UsageType("method-with-thrown-type");
        public static final UsageType CONSTRUCTOR_WITH_PARAMETER_TYPE = new UsageType("constructor-with-parameter-type");
        public static final UsageType CONSTRUCTOR_WITH_THROWN_TYPE = new UsageType("constructor-with-thrown-type");
        private String id;

        private UsageType(String id) {
            this.id = id;
        }

        @Override
        public int compareTo(UsageType ut) {
            return this.id.compareTo(ut.id);
        }

        public String toString() {
            return "UsageType{id=" + this.id + "}";
        }

        public String getId() {
            return this.id;
        }
    }
}

