/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html.parser;

import java.io.IOException;
import java.io.Reader;
import javax.swing.text.BadLocationException;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.DTD;
import javax.swing.text.html.parser.DTDConstants;
import javax.swing.text.html.parser.Parser;
import javax.swing.text.html.parser.TagElement;

public class DocumentParser
extends Parser
implements DTDConstants {
    DocumentParser parser = this;
    HTMLEditorKit.ParserCallback callBack;
    gnuParser gnu;

    public DocumentParser(DTD a_dtd) {
        super(a_dtd);
        this.gnu = new gnuParser(a_dtd);
    }

    public void parse(Reader reader, HTMLEditorKit.ParserCallback aCallback, boolean ignoreCharSet) throws IOException {
        this.callBack = aCallback;
        this.gnu.parse(reader);
        this.callBack.handleEndOfLineString(this.gnu.getEndOfLineSequence());
        try {
            this.callBack.flush();
        }
        catch (BadLocationException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    protected void handleComment(char[] comment) {
    }

    protected void handleEmptyTag(TagElement tag) throws ChangedCharSetException {
    }

    protected void handleEndTag(TagElement tag) {
    }

    protected void handleError(int line, String message) {
    }

    protected void handleStartTag(TagElement tag) {
    }

    protected void handleText(char[] text) {
    }

    private class gnuParser
    extends gnu.javax.swing.text.html.parser.support.Parser {
        private gnuParser(DTD d) {
            super(d);
        }

        protected final void handleComment(char[] comment) {
            DocumentParser.this.parser.handleComment(comment);
            DocumentParser.this.callBack.handleComment(comment, this.hTag.where.startPosition);
        }

        protected final void handleEmptyTag(TagElement tag) throws ChangedCharSetException {
            DocumentParser.this.parser.handleEmptyTag(tag);
            DocumentParser.this.callBack.handleSimpleTag(tag.getHTMLTag(), this.getAttributes(), this.hTag.where.startPosition);
        }

        protected final void handleEndTag(TagElement tag) {
            DocumentParser.this.parser.handleEndTag(tag);
            DocumentParser.this.callBack.handleEndTag(tag.getHTMLTag(), this.hTag.where.startPosition);
        }

        protected final void handleError(int line, String message) {
            DocumentParser.this.parser.handleError(line, message);
            DocumentParser.this.callBack.handleError(message, this.hTag.where.startPosition);
        }

        protected final void handleStartTag(TagElement tag) {
            DocumentParser.this.parser.handleStartTag(tag);
            SimpleAttributeSet attributes = DocumentParser.this.gnu.getAttributes();
            if (tag.fictional()) {
                attributes.addAttribute(HTMLEditorKit.ParserCallback.IMPLIED, Boolean.TRUE);
            }
            DocumentParser.this.callBack.handleStartTag(tag.getHTMLTag(), attributes, this.hTag.where.startPosition);
        }

        protected final void handleText(char[] text) {
            DocumentParser.this.parser.handleText(text);
            DocumentParser.this.callBack.handleText(text, this.hTag.where.startPosition);
        }

        DTD getDTD() {
            return this.dtd;
        }
    }
}

