/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ButtonGroup
implements Serializable {
    private static final long serialVersionUID = 4259076101881721375L;
    protected Vector<AbstractButton> buttons = new Vector();
    ButtonModel sel;

    public void add(AbstractButton b) {
        if (b == null) {
            return;
        }
        b.getModel().setGroup(this);
        if (b.isSelected()) {
            if (this.sel == null) {
                this.sel = b.getModel();
            } else {
                b.setSelected(false);
            }
        }
        this.buttons.addElement(b);
    }

    public void remove(AbstractButton b) {
        if (b == null) {
            return;
        }
        b.getModel().setGroup(null);
        if (b.getModel() == this.sel) {
            this.sel = null;
        }
        this.buttons.removeElement(b);
    }

    public Enumeration<AbstractButton> getElements() {
        return this.buttons.elements();
    }

    public ButtonModel getSelection() {
        return this.sel;
    }

    AbstractButton findButton(ButtonModel m) {
        int i = 0;
        while (i < this.buttons.size()) {
            AbstractButton a = this.buttons.get(i);
            if (a.getModel() == m) {
                return a;
            }
            ++i;
        }
        return null;
    }

    public void setSelected(ButtonModel m, boolean b) {
        if (!(this.sel == m && !b || b && this.sel != m)) {
            return;
        }
        if (b && this.sel != m) {
            AbstractButton button;
            ButtonModel old = this.sel;
            this.sel = m;
            if (old != null) {
                old.setSelected(false);
            }
            if (m != null) {
                this.sel.setSelected(true);
            }
            if ((button = this.findButton(old)) != null) {
                button.repaint();
            }
        } else if (!b && this.sel == m) {
            m.setSelected(true);
        }
    }

    public boolean isSelected(ButtonModel m) {
        return m == this.sel;
    }

    public int getButtonCount() {
        return this.buttons.size();
    }
}

