/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class SSLContext {
    private static final String SSL_CONTEXT = "SSLContext";
    private final SSLContextSpi ctxSpi;
    private final Provider provider;
    private final String protocol;

    protected SSLContext(SSLContextSpi ctxSpi, Provider provider, String protocol) {
        this.ctxSpi = ctxSpi;
        this.provider = provider;
        this.protocol = protocol;
    }

    public static final SSLContext getInstance(String protocol) throws NoSuchAlgorithmException {
        Provider[] p = Security.getProviders();
        NoSuchAlgorithmException lastException = null;
        int i = 0;
        while (i < p.length) {
            try {
                return SSLContext.getInstance(protocol, p[i]);
            }
            catch (NoSuchAlgorithmException x) {
                lastException = x;
                ++i;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        throw new NoSuchAlgorithmException(protocol);
    }

    public static final SSLContext getInstance(String protocol, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider == null) {
            throw new IllegalArgumentException("provider MUST NOT be null");
        }
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return SSLContext.getInstance(protocol, p);
    }

    public static final SSLContext getInstance(String protocol, Provider provider) throws NoSuchAlgorithmException {
        Throwable cause;
        StringBuilder sb = new StringBuilder("SSLContext for protocol [").append(protocol).append("] from provider[").append(provider).append("] could not be created");
        try {
            Object spi = Engine.getInstance(SSL_CONTEXT, protocol, provider);
            return new SSLContext((SSLContextSpi)spi, provider, protocol);
        }
        catch (InvocationTargetException x) {
            cause = x.getCause();
            if (cause instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)cause;
            }
            if (cause == null) {
                cause = x;
            }
        }
        catch (ClassCastException x) {
            cause = x;
        }
        NoSuchAlgorithmException x = new NoSuchAlgorithmException(sb.toString());
        x.initCause(cause);
        throw x;
    }

    public final SSLEngine createSSLEngine() {
        return this.ctxSpi.engineCreateSSLEngine();
    }

    public final SSLEngine createSSLEngine(String host, int port) {
        return this.ctxSpi.engineCreateSSLEngine(host, port);
    }

    public final SSLSessionContext getClientSessionContext() {
        return this.ctxSpi.engineGetClientSessionContext();
    }

    public final String getProtocol() {
        return this.protocol;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final SSLSessionContext getServerSessionContext() {
        return this.ctxSpi.engineGetServerSessionContext();
    }

    public final SSLServerSocketFactory getServerSocketFactory() {
        return this.ctxSpi.engineGetServerSocketFactory();
    }

    public final SSLSocketFactory getSocketFactory() {
        return this.ctxSpi.engineGetSocketFactory();
    }

    public final void init(KeyManager[] keyManagers, TrustManager[] trustManagers, SecureRandom random) throws KeyManagementException {
        this.ctxSpi.engineInit(keyManagers, trustManagers, random);
    }
}

