/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.imageio.IIOImage;
import javax.imageio.ImageTranscoder;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.event.IIOWriteProgressListener;
import javax.imageio.event.IIOWriteWarningListener;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ImageWriter
implements ImageTranscoder {
    private boolean aborted;
    protected Locale[] availableLocales = null;
    protected Locale locale = null;
    protected ImageWriterSpi originatingProvider = null;
    protected Object output = null;
    protected List<IIOWriteProgressListener> progressListeners = null;
    protected List<IIOWriteWarningListener> warningListeners = null;
    protected List<Locale> warningLocales = null;

    protected ImageWriter(ImageWriterSpi originatingProvider) {
        this.originatingProvider = originatingProvider;
    }

    private void checkOutputSet() {
        if (this.output == null) {
            throw new IllegalStateException("no output set");
        }
    }

    public void abort() {
        this.aborted = true;
    }

    protected boolean abortRequested() {
        return this.aborted;
    }

    public void addIIOWriteProgressListener(IIOWriteProgressListener listener) {
        if (listener == null) {
            return;
        }
        if (this.progressListeners == null) {
            this.progressListeners = new ArrayList<IIOWriteProgressListener>();
        }
        this.progressListeners.add(listener);
    }

    public void addIIOWriteWarningListener(IIOWriteWarningListener listener) {
        if (listener == null) {
            return;
        }
        if (this.warningListeners == null) {
            this.warningListeners = new ArrayList<IIOWriteWarningListener>();
        }
        this.warningListeners.add(listener);
    }

    public boolean canInsertEmpty(int imageIndex) throws IOException {
        this.checkOutputSet();
        return false;
    }

    public boolean canInsertImage(int imageIndex) throws IOException {
        this.checkOutputSet();
        return false;
    }

    public boolean canRemoveImage(int imageIndex) throws IOException {
        this.checkOutputSet();
        return false;
    }

    public boolean canReplaceImageMetadata(int imageIndex) throws IOException {
        this.checkOutputSet();
        return false;
    }

    public boolean canReplacePixels(int imageIndex) throws IOException {
        this.checkOutputSet();
        return false;
    }

    public boolean canReplaceStreamMetadata() throws IOException {
        this.checkOutputSet();
        return false;
    }

    public boolean canWriteEmpty() throws IOException {
        this.checkOutputSet();
        return false;
    }

    public boolean canWriteRasters() {
        return false;
    }

    public boolean canWriteSequence() {
        return false;
    }

    protected void clearAbortRequest() {
        this.aborted = false;
    }

    @Override
    public abstract IIOMetadata convertImageMetadata(IIOMetadata var1, ImageTypeSpecifier var2, ImageWriteParam var3);

    @Override
    public abstract IIOMetadata convertStreamMetadata(IIOMetadata var1, ImageWriteParam var2);

    public void dispose() {
    }

    public Locale[] getAvailableLocales() {
        return this.availableLocales;
    }

    public abstract IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier var1, ImageWriteParam var2);

    public abstract IIOMetadata getDefaultStreamMetadata(ImageWriteParam var1);

    public ImageWriteParam getDefaultWriteParam() {
        return new ImageWriteParam(this.getLocale());
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int getNumThumbnailsSupported(ImageTypeSpecifier imageType, ImageWriteParam param, IIOMetadata streamMetadata, IIOMetadata imageMetadata) {
        return 0;
    }

    public ImageWriterSpi getOriginatingProvider() {
        return this.originatingProvider;
    }

    public Object getOutput() {
        return this.output;
    }

    public Dimension[] getPreferredThumbnailSizes(ImageTypeSpecifier imageType, ImageWriteParam param, IIOMetadata streamMetadata, IIOMetadata imageMetadata) {
        return null;
    }

    protected void processImageComplete() {
        if (this.progressListeners != null) {
            for (IIOWriteProgressListener listener : this.progressListeners) {
                listener.imageComplete(this);
            }
        }
    }

    protected void processImageProgress(float percentageDone) {
        if (this.progressListeners != null) {
            for (IIOWriteProgressListener listener : this.progressListeners) {
                listener.imageProgress(this, percentageDone);
            }
        }
    }

    protected void processImageStarted(int imageIndex) {
        if (this.progressListeners != null) {
            for (IIOWriteProgressListener listener : this.progressListeners) {
                listener.imageStarted(this, imageIndex);
            }
        }
    }

    protected void processThumbnailComplete() {
        if (this.progressListeners != null) {
            for (IIOWriteProgressListener listener : this.progressListeners) {
                listener.thumbnailComplete(this);
            }
        }
    }

    protected void processThumbnailProgress(float percentageDone) {
        if (this.progressListeners != null) {
            for (IIOWriteProgressListener listener : this.progressListeners) {
                listener.thumbnailProgress(this, percentageDone);
            }
        }
    }

    protected void processThumbnailStarted(int imageIndex, int thumbnailIndex) {
        if (this.progressListeners != null) {
            for (IIOWriteProgressListener listener : this.progressListeners) {
                listener.thumbnailStarted(this, imageIndex, thumbnailIndex);
            }
        }
    }

    protected void processWarningOccurred(int imageIndex, String warning) {
        if (this.warningListeners != null) {
            for (IIOWriteWarningListener listener : this.warningListeners) {
                listener.warningOccurred(this, imageIndex, warning);
            }
        }
    }

    protected void processWarningOccurred(int imageIndex, String baseName, String keyword) {
        if (baseName == null || keyword == null) {
            throw new IllegalArgumentException("null argument");
        }
        ResourceBundle b = null;
        try {
            b = ResourceBundle.getBundle(baseName, this.getLocale());
        }
        catch (MissingResourceException missingResourceException) {
            throw new IllegalArgumentException("no resource bundle found");
        }
        Object str = null;
        try {
            str = b.getObject(keyword);
        }
        catch (MissingResourceException missingResourceException) {
            throw new IllegalArgumentException("no results found for keyword");
        }
        if (!(str instanceof String)) {
            throw new IllegalArgumentException("retrieved object not a String");
        }
        String warning = (String)str;
        if (this.warningListeners != null) {
            for (IIOWriteWarningListener listener : this.warningListeners) {
                listener.warningOccurred(this, imageIndex, warning);
            }
        }
    }

    protected void processWriteAborted() {
        if (this.progressListeners != null) {
            for (IIOWriteProgressListener listener : this.progressListeners) {
                listener.writeAborted(this);
            }
        }
    }

    public void removeAllIIOWriteProgressListeners() {
        if (this.progressListeners != null) {
            this.progressListeners.clear();
        }
    }

    public void removeAllIIOWriteWarningListeners() {
        if (this.progressListeners != null) {
            this.progressListeners.clear();
        }
    }

    public void removeIIOWriteProgressListener(IIOWriteProgressListener listener) {
        if (listener == null) {
            return;
        }
        if (this.progressListeners != null) {
            this.progressListeners.remove(listener);
        }
    }

    public void removeIIOWriteWarningListener(IIOWriteWarningListener listener) {
        if (listener == null) {
            return;
        }
        if (this.warningListeners != null) {
            this.warningListeners.remove(listener);
        }
    }

    public void reset() {
        this.setOutput(null);
        this.setLocale(null);
        this.removeAllIIOWriteWarningListeners();
        this.removeAllIIOWriteProgressListeners();
        this.clearAbortRequest();
    }

    public void setLocale(Locale locale) {
        if (locale != null) {
            boolean found = false;
            if (this.availableLocales != null) {
                int i = this.availableLocales.length - 1;
                while (i >= 0) {
                    if (this.availableLocales[i].equals(locale)) {
                        found = true;
                    }
                    --i;
                }
            }
            if (!found) {
                throw new IllegalArgumentException("looale not available");
            }
        }
        this.locale = locale;
    }

    public void setOutput(Object output) {
        if (output != null) {
            boolean found = false;
            Class[] types = null;
            if (this.originatingProvider != null) {
                types = this.originatingProvider.getOutputTypes();
            }
            if (types != null) {
                int i = types.length - 1;
                while (i >= 0) {
                    if (types[i].isInstance(output)) {
                        found = true;
                    }
                    --i;
                }
            }
            if (!found) {
                throw new IllegalArgumentException("output type not available");
            }
        }
        this.output = output;
    }

    public abstract void write(IIOMetadata var1, IIOImage var2, ImageWriteParam var3) throws IOException;

    public void endInsertEmpty() throws IOException {
        if (!this.canInsertEmpty(0)) {
            throw new UnsupportedOperationException();
        }
    }

    public void endReplacePixels() throws IOException {
        if (!this.canReplacePixels(0)) {
            throw new UnsupportedOperationException();
        }
    }

    public void endWriteEmpty() throws IOException {
        if (!this.canWriteEmpty()) {
            throw new UnsupportedOperationException();
        }
    }

    public void endWriteSequence() throws IOException {
        this.checkOutputSet();
        if (!this.canWriteSequence()) {
            throw new UnsupportedOperationException();
        }
    }

    public void prepareInsertEmpty(int imageIndex, ImageTypeSpecifier imageType, int width, int height, IIOMetadata imageMetadata, List<? extends BufferedImage> thumbnails, ImageWriteParam param) throws IOException {
        if (!this.canInsertEmpty(imageIndex)) {
            throw new UnsupportedOperationException();
        }
    }

    public void prepareReplacePixels(int imageIndex, Rectangle region) throws IOException {
        if (this.canReplacePixels(imageIndex)) {
            throw new UnsupportedOperationException();
        }
    }

    public void prepareWriteEmpty(IIOMetadata streamMetadata, ImageTypeSpecifier imageType, int width, int height, IIOMetadata imageMetadata, List<? extends BufferedImage> thumbnails, ImageWriteParam param) throws IOException {
        if (!this.canWriteEmpty()) {
            throw new UnsupportedOperationException();
        }
    }

    public void prepareWriteSequence(IIOMetadata streamMetadata) throws IOException {
        this.checkOutputSet();
        if (!this.canWriteSequence()) {
            throw new UnsupportedOperationException();
        }
    }

    public void removeImage(int imageIndex) throws IOException {
        if (!this.canRemoveImage(imageIndex)) {
            throw new UnsupportedOperationException();
        }
    }

    public void replaceImageMetadata(int imageIndex, IIOMetadata imageMetadata) throws IOException {
        if (!this.canReplaceImageMetadata(imageIndex)) {
            throw new UnsupportedOperationException();
        }
    }

    public void replacePixels(RenderedImage image, ImageWriteParam param) throws IOException {
        if (!this.canReplacePixels(0)) {
            throw new UnsupportedOperationException();
        }
    }

    public void replacePixels(Raster raster, ImageWriteParam param) throws IOException {
        if (!this.canReplacePixels(0)) {
            throw new UnsupportedOperationException();
        }
    }

    public void replaceStreamMetadata(IIOMetadata streamMetadata) throws IOException {
        if (!this.canReplaceStreamMetadata()) {
            throw new UnsupportedOperationException();
        }
    }

    public void write(RenderedImage image) throws IOException {
        this.checkOutputSet();
        this.write(null, new IIOImage(image, null, null), null);
    }

    public void write(IIOImage image) throws IOException {
        this.checkOutputSet();
        this.write(null, image, null);
    }

    public void writeInsert(int imageIndex, IIOImage image, ImageWriteParam param) throws IOException {
        if (!this.canInsertImage(imageIndex)) {
            throw new UnsupportedOperationException();
        }
    }

    public void writeToSequence(IIOImage image, ImageWriteParam param) throws IOException {
        if (!this.canWriteSequence()) {
            throw new UnsupportedOperationException();
        }
    }
}

