/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import gnu.java.lang.CPStringBuilder;
import java.awt.datatransfer.DataFlavor;
import java.io.InputStream;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;

public class ActivationDataFlavor
extends DataFlavor {
    private final String mimeType;
    private final Class<?> representationClass;
    private String humanPresentableName;

    public ActivationDataFlavor(Class representationClass, String mimeType, String humanPresentableName) {
        super(mimeType, humanPresentableName);
        this.mimeType = mimeType;
        this.humanPresentableName = humanPresentableName;
        this.representationClass = representationClass;
    }

    public ActivationDataFlavor(Class representationClass, String humanPresentableName) {
        super(representationClass, humanPresentableName);
        this.mimeType = super.getMimeType();
        this.representationClass = representationClass;
        this.humanPresentableName = humanPresentableName;
    }

    public ActivationDataFlavor(String mimeType, String humanPresentableName) {
        super(mimeType, humanPresentableName);
        this.mimeType = mimeType;
        this.humanPresentableName = humanPresentableName;
        this.representationClass = InputStream.class;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Class getRepresentationClass() {
        return this.representationClass;
    }

    public String getHumanPresentableName() {
        return this.humanPresentableName;
    }

    public void setHumanPresentableName(String humanPresentableName) {
        this.humanPresentableName = humanPresentableName;
    }

    public boolean equals(DataFlavor dataFlavor) {
        return this.isMimeTypeEqual(dataFlavor) && dataFlavor.getRepresentationClass() == this.representationClass;
    }

    public boolean isMimeTypeEqual(String mimeType) {
        try {
            return new MimeType(this.mimeType).match(new MimeType(mimeType));
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            return false;
        }
    }

    protected String normalizeMimeTypeParameter(String parameterName, String parameterValue) {
        return new CPStringBuilder(parameterName).append('=').append(parameterValue).toString();
    }

    protected String normalizeMimeType(String mimeType) {
        return mimeType;
    }
}

