/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class MemoryHandler
extends Handler {
    private final LogRecord[] buffer;
    private int position;
    private int numPublished;
    private Level pushLevel;
    private final Handler target;

    public MemoryHandler() {
        this((Handler)LogManager.getInstanceProperty("java.util.logging.MemoryHandler.target", Handler.class, null), LogManager.getIntPropertyClamped("java.util.logging.MemoryHandler.size", 1000, 1, Integer.MAX_VALUE), LogManager.getLevelProperty("java.util.logging.MemoryHandler.push", Level.SEVERE));
    }

    public MemoryHandler(Handler target, int size, Level pushLevel) {
        if (target == null || size <= 0 || pushLevel == null) {
            throw new IllegalArgumentException();
        }
        this.buffer = new LogRecord[size];
        this.pushLevel = pushLevel;
        this.target = target;
        this.setLevel(LogManager.getLevelProperty("java.util.logging.MemoryHandler.level", Level.ALL));
        this.setFilter((Filter)LogManager.getInstanceProperty("java.util.logging.MemoryHandler.filter", Filter.class, null));
    }

    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        this.buffer[this.position] = record;
        this.position = (this.position + 1) % this.buffer.length;
        ++this.numPublished;
        if (record.getLevel().intValue() >= this.pushLevel.intValue()) {
            this.push();
        }
    }

    public void push() {
        if (this.numPublished < this.buffer.length) {
            int i = 0;
            while (i < this.position) {
                this.target.publish(this.buffer[i]);
                ++i;
            }
        } else {
            int i = this.position;
            while (i < this.buffer.length) {
                this.target.publish(this.buffer[i]);
                ++i;
            }
            i = 0;
            while (i < this.position) {
                this.target.publish(this.buffer[i]);
                ++i;
            }
        }
        this.numPublished = 0;
        this.position = 0;
    }

    public void flush() {
        this.target.flush();
    }

    public void close() throws SecurityException {
        this.push();
        this.target.close();
    }

    public Level getPushLevel() {
        return this.pushLevel;
    }

    public void setPushLevel(Level pushLevel) {
        LogManager.getLogManager().checkAccess();
        pushLevel.getClass();
        this.pushLevel = pushLevel;
    }
}

