/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentLinkedQueue<E>
extends AbstractQueue<E>
implements Queue<E>,
Serializable {
    private static final long serialVersionUID = 196745693267521676L;
    private static final AtomicReferenceFieldUpdater<ConcurrentLinkedQueue, Node> tailUpdater = AtomicReferenceFieldUpdater.newUpdater(ConcurrentLinkedQueue.class, Node.class, "tail");
    private static final AtomicReferenceFieldUpdater<ConcurrentLinkedQueue, Node> headUpdater = AtomicReferenceFieldUpdater.newUpdater(ConcurrentLinkedQueue.class, Node.class, "head");
    private volatile transient Node<E> head = new Node<Object>(null, null);
    private volatile transient Node<E> tail = this.head;

    private boolean casTail(Node<E> cmp, Node<E> val) {
        return tailUpdater.compareAndSet(this, cmp, val);
    }

    private boolean casHead(Node<E> cmp, Node<E> val) {
        return headUpdater.compareAndSet(this, cmp, val);
    }

    public ConcurrentLinkedQueue() {
    }

    public ConcurrentLinkedQueue(Collection<? extends E> c) {
        Iterator<E> it = c.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        Node<E> n = new Node<E>(e, null);
        while (true) {
            Node<E> t = this.tail;
            Node<E> s = t.getNext();
            if (t != this.tail) continue;
            if (s == null) {
                if (!t.casNext(s, n)) continue;
                this.casTail(t, n);
                return true;
            }
            this.casTail(t, s);
        }
    }

    @Override
    public E poll() {
        E item;
        Node<E> first;
        while (true) {
            Node<E> h = this.head;
            Node<E> t = this.tail;
            first = h.getNext();
            if (h != this.head) continue;
            if (h == t) {
                if (first == null) {
                    return null;
                }
                this.casTail(t, first);
                continue;
            }
            if (this.casHead(h, first) && (item = first.getItem()) != null) break;
        }
        first.setItem(null);
        return item;
    }

    @Override
    public E peek() {
        while (true) {
            Node<E> h = this.head;
            Node<E> t = this.tail;
            Node<E> first = h.getNext();
            if (h != this.head) continue;
            if (h == t) {
                if (first == null) {
                    return null;
                }
                this.casTail(t, first);
                continue;
            }
            E item = first.getItem();
            if (item != null) {
                return item;
            }
            this.casHead(h, first);
        }
    }

    Node<E> first() {
        while (true) {
            Node<E> h = this.head;
            Node<E> t = this.tail;
            Node<E> first = h.getNext();
            if (h != this.head) continue;
            if (h == t) {
                if (first == null) {
                    return null;
                }
                this.casTail(t, first);
                continue;
            }
            if (first.getItem() != null) {
                return first;
            }
            this.casHead(h, first);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.first() == null;
    }

    @Override
    public int size() {
        int count = 0;
        Node<E> p = this.first();
        while (p != null) {
            if (p.getItem() != null && ++count == Integer.MAX_VALUE) break;
            p = p.getNext();
        }
        return count;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        Node<E> p = this.first();
        while (p != null) {
            E item = p.getItem();
            if (item != null && o.equals(item)) {
                return true;
            }
            p = p.getNext();
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        Node<E> p = this.first();
        while (p != null) {
            E item = p.getItem();
            if (item != null && o.equals(item) && p.casItem(item, null)) {
                return true;
            }
            p = p.getNext();
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Node<E> p = this.first();
        while (p != null) {
            E item = p.getItem();
            if (item != null) {
                s.writeObject(item);
            }
            p = p.getNext();
        }
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Object item;
        s.defaultReadObject();
        this.head = new Node<Object>(null, null);
        this.tail = this.head;
        while ((item = s.readObject()) != null) {
            this.offer(item);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Itr
    implements Iterator<E> {
        private Node<E> nextNode;
        private E nextItem;
        private Node<E> lastRet;

        Itr() {
            this.advance();
        }

        private E advance() {
            Node p;
            this.lastRet = this.nextNode;
            Object x = this.nextItem;
            Node node2 = p = this.nextNode == null ? ConcurrentLinkedQueue.this.first() : this.nextNode.getNext();
            while (true) {
                if (p == null) {
                    this.nextNode = null;
                    this.nextItem = null;
                    return x;
                }
                Object item = p.getItem();
                if (item != null) {
                    this.nextNode = p;
                    this.nextItem = item;
                    return x;
                }
                p = p.getNext();
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextNode != null;
        }

        @Override
        public E next() {
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            return this.advance();
        }

        @Override
        public void remove() {
            Node<Object> l = this.lastRet;
            if (l == null) {
                throw new IllegalStateException();
            }
            l.setItem(null);
            this.lastRet = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node<E> {
        private volatile E item;
        private volatile Node<E> next;
        private static final AtomicReferenceFieldUpdater<Node, Node> nextUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, Node.class, "next");
        private static final AtomicReferenceFieldUpdater<Node, Object> itemUpdater = AtomicReferenceFieldUpdater.newUpdater(Node.class, Object.class, "item");

        Node(E x) {
            this.item = x;
        }

        Node(E x, Node<E> n) {
            this.item = x;
            this.next = n;
        }

        E getItem() {
            return this.item;
        }

        boolean casItem(E cmp, E val) {
            return itemUpdater.compareAndSet(this, cmp, val);
        }

        void setItem(E val) {
            itemUpdater.set(this, val);
        }

        Node<E> getNext() {
            return this.next;
        }

        boolean casNext(Node<E> cmp, Node<E> val) {
            return nextUpdater.compareAndSet(this, cmp, val);
        }

        void setNext(Node<E> val) {
            nextUpdater.set(this, val);
        }
    }
}

