/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class GregorianCalendar
extends Calendar {
    public static final int BC = 0;
    public static final int AD = 1;
    private long gregorianCutover = new Date(-12219292800000L).getTime();
    static final long serialVersionUID = -8125100834729963327L;
    private static final int EPOCH_DAYS = 719162;
    private static final int[] minimums;
    private static final int[] maximums;

    static {
        int[] nArray = new int[17];
        nArray[1] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[8] = 1;
        nArray[10] = 1;
        nArray[15] = -43200000;
        minimums = nArray;
        maximums = new int[]{1, 5000000, 11, 53, 6, 31, 366, 7, 5, 1, 12, 23, 59, 59, 999, 43200000, 43200000};
    }

    public GregorianCalendar() {
        this(TimeZone.getDefault(), Locale.getDefault());
    }

    public GregorianCalendar(TimeZone zone) {
        this(zone, Locale.getDefault());
    }

    public GregorianCalendar(Locale locale) {
        this(TimeZone.getDefault(), locale);
    }

    public GregorianCalendar(TimeZone zone, Locale locale) {
        this(zone, locale, false);
        this.setTimeInMillis(System.currentTimeMillis());
    }

    private GregorianCalendar(TimeZone zone, Locale locale, boolean unused) {
        super(zone, locale);
    }

    public GregorianCalendar(int year, int month, int day) {
        this(TimeZone.getDefault(), Locale.getDefault(), false);
        this.set(year, month, day);
    }

    public GregorianCalendar(int year, int month, int day, int hour, int minute) {
        this(TimeZone.getDefault(), Locale.getDefault(), false);
        this.set(year, month, day, hour, minute);
    }

    public GregorianCalendar(int year, int month, int day, int hour, int minute, int second) {
        this(TimeZone.getDefault(), Locale.getDefault(), false);
        this.set(year, month, day, hour, minute, second);
    }

    public void setGregorianChange(Date date) {
        this.gregorianCutover = date.getTime();
    }

    public final Date getGregorianChange() {
        return new Date(this.gregorianCutover);
    }

    public boolean isLeapYear(int year) {
        if ((year & 3) != 0) {
            return false;
        }
        if (!this.isGregorian(year, 59)) {
            return true;
        }
        return year % 100 != 0 || year % 400 == 0;
    }

    private int getWeekDay(int year, int dayOfYear) {
        boolean greg = this.isGregorian(year, dayOfYear);
        int day = (int)this.getLinearDay(year, dayOfYear, greg);
        int weekday = (day + 5) % 7;
        if (weekday <= 0) {
            weekday += 7;
        }
        return weekday;
    }

    private int getFirstDayOfMonth(int year, int month) {
        boolean greg;
        int day;
        int weekday;
        int[] nArray = new int[12];
        nArray[1] = 31;
        nArray[2] = 59;
        nArray[3] = 90;
        nArray[4] = 120;
        nArray[5] = 151;
        nArray[6] = 181;
        nArray[7] = 212;
        nArray[8] = 243;
        nArray[9] = 273;
        nArray[10] = 304;
        nArray[11] = 334;
        int[] dayCount = nArray;
        if (month > 11) {
            year += month / 12;
            month %= 12;
        }
        if (month < 0) {
            year += month / 12;
            if ((month %= 12) < 0) {
                month += 12;
                --year;
            }
        }
        int dayOfYear = dayCount[month] + 1;
        if (month > 1 && this.isLeapYear(year)) {
            ++dayOfYear;
        }
        if ((weekday = ((day = (int)this.getLinearDay(year, dayOfYear, greg = this.isGregorian(year, dayOfYear))) + 5) % 7) <= 0) {
            weekday += 7;
        }
        return weekday;
    }

    private boolean isGregorian(int year, int dayOfYear) {
        int relativeDay = (year - 1) * 365 + (year - 1 >> 2) + dayOfYear - 719162;
        int gregFactor = (int)Math.floor((double)(year - 1) / 400.0) - (int)Math.floor((double)(year - 1) / 100.0);
        return (long)(relativeDay + gregFactor) * 60L * 60L * 24L * 1000L >= this.gregorianCutover;
    }

    private void nonLeniencyCheck() throws IllegalArgumentException {
        int weeks;
        int leap;
        int[] month_days = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        int year = this.fields[1];
        int month = this.fields[2];
        int n = leap = this.isLeapYear(year) ? 1 : 0;
        if (this.isSet[0] && this.fields[0] != 1 && this.fields[0] != 0) {
            throw new IllegalArgumentException("Illegal ERA.");
        }
        if (this.isSet[1] && this.fields[1] < 1) {
            throw new IllegalArgumentException("Illegal YEAR.");
        }
        if (this.isSet[2] && (month < 0 || month > 11)) {
            throw new IllegalArgumentException("Illegal MONTH.");
        }
        if (this.isSet[3]) {
            int daysInYear = 365 + leap;
            daysInYear += this.getFirstDayOfMonth(year, 0) - 1;
            int last = this.getFirstDayOfMonth(year, 11) + 4;
            if (last > 7) {
                last -= 7;
            }
            int weeks2 = (daysInYear += 7 - last) / 7;
            if (this.fields[3] < 1 || this.fields[3] > weeks2) {
                throw new IllegalArgumentException("Illegal WEEK_OF_YEAR.");
            }
        }
        if (this.isSet[4]) {
            int n2 = weeks = month == 1 && leap == 0 ? 5 : 6;
            if (this.fields[4] < 1 || this.fields[4] > weeks) {
                throw new IllegalArgumentException("Illegal WEEK_OF_MONTH.");
            }
        }
        if (this.isSet[5] && (this.fields[5] < 1 || this.fields[5] > month_days[month] + (month == 1 ? leap : 0))) {
            throw new IllegalArgumentException("Illegal DAY_OF_MONTH.");
        }
        if (this.isSet[6] && (this.fields[6] < 1 || this.fields[6] > 365 + leap)) {
            throw new IllegalArgumentException("Illegal DAY_OF_YEAR.");
        }
        if (this.isSet[7] && (this.fields[7] < 1 || this.fields[7] > 7)) {
            throw new IllegalArgumentException("Illegal DAY_OF_WEEK.");
        }
        if (this.isSet[8]) {
            int n3 = weeks = month == 1 && leap == 0 ? 4 : 5;
            if (this.fields[8] < -weeks || this.fields[8] > weeks) {
                throw new IllegalArgumentException("Illegal DAY_OF_WEEK_IN_MONTH.");
            }
        }
        if (this.isSet[9] && this.fields[9] != 0 && this.fields[9] != 1) {
            throw new IllegalArgumentException("Illegal AM_PM.");
        }
        if (this.isSet[10] && (this.fields[10] < 0 || this.fields[10] > 11)) {
            throw new IllegalArgumentException("Illegal HOUR.");
        }
        if (this.isSet[11] && (this.fields[11] < 0 || this.fields[11] > 23)) {
            throw new IllegalArgumentException("Illegal HOUR_OF_DAY.");
        }
        if (this.isSet[12] && (this.fields[12] < 0 || this.fields[12] > 59)) {
            throw new IllegalArgumentException("Illegal MINUTE.");
        }
        if (this.isSet[13] && (this.fields[13] < 0 || this.fields[13] > 59)) {
            throw new IllegalArgumentException("Illegal SECOND.");
        }
        if (this.isSet[14] && (this.fields[14] < 0 || this.fields[14] > 999)) {
            throw new IllegalArgumentException("Illegal MILLISECOND.");
        }
        if (this.isSet[15] && ((long)this.fields[15] < -43200000L || (long)this.fields[15] > 43200000L)) {
            throw new IllegalArgumentException("Illegal ZONE_OFFSET.");
        }
        if (this.isSet[16] && ((long)this.fields[16] < -43200000L || (long)this.fields[16] > 43200000L)) {
            throw new IllegalArgumentException("Illegal DST_OFFSET.");
        }
    }

    protected synchronized void computeTime() {
        int rawOffset;
        int gregFactor;
        int relativeDay;
        int daysInFirstWeek;
        int offs;
        int first;
        int millisInDay = 0;
        int era = this.fields[0];
        int year = this.fields[1];
        int month = this.fields[2];
        int day = this.fields[5];
        int minute = this.fields[12];
        int second = this.fields[13];
        int millis = this.fields[14];
        int[] month_days = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        int[] nArray = new int[12];
        nArray[1] = 31;
        nArray[2] = 59;
        nArray[3] = 90;
        nArray[4] = 120;
        nArray[5] = 151;
        nArray[6] = 181;
        nArray[7] = 212;
        nArray[8] = 243;
        nArray[9] = 273;
        nArray[10] = 304;
        nArray[11] = 334;
        int[] dayCount = nArray;
        int hour = 0;
        if (!this.isLenient()) {
            this.nonLeniencyCheck();
        }
        if (!(this.isSet[2] || this.isSet[7] && !this.isSet[3])) {
            if (this.isSet[3]) {
                first = this.getFirstDayOfMonth(year, 0);
                offs = 1;
                daysInFirstWeek = this.getFirstDayOfWeek() - first;
                if (daysInFirstWeek <= 0) {
                    daysInFirstWeek += 7;
                }
                offs = daysInFirstWeek < this.getMinimalDaysInFirstWeek() ? (offs += daysInFirstWeek) : (offs -= 7 - daysInFirstWeek);
                month = 0;
                day = offs + 7 * (this.fields[3] - 1);
                offs = this.fields[7] - this.getFirstDayOfWeek();
                if (offs < 0) {
                    offs += 7;
                }
                day += offs;
            } else {
                month = 0;
                day = this.fields[6];
            }
        } else if (this.isSet[7]) {
            first = this.getFirstDayOfMonth(year, month);
            if (this.isSet[8]) {
                if (this.fields[8] < 0) {
                    first = this.getFirstDayOfMonth(year, ++month);
                    day = 1 + 7 * this.fields[8];
                } else {
                    day = 1 + 7 * (this.fields[8] - 1);
                }
                offs = this.fields[7] - first;
                if (offs < 0) {
                    offs += 7;
                }
                day += offs;
            } else {
                offs = 1;
                daysInFirstWeek = this.getFirstDayOfWeek() - first;
                if (daysInFirstWeek <= 0) {
                    daysInFirstWeek += 7;
                }
                offs = daysInFirstWeek < this.getMinimalDaysInFirstWeek() ? (offs += daysInFirstWeek) : (offs -= 7 - daysInFirstWeek);
                day = offs + 7 * (this.fields[4] - 1);
                offs = this.fields[7] - this.getFirstDayOfWeek();
                if (offs < 0) {
                    offs += 7;
                }
                day += offs;
            }
        }
        if (era == 0 && year > 0) {
            year = 1 - year;
        }
        if (this.isSet[10]) {
            hour = this.fields[10];
            if (this.fields[9] == 1) {
                hour += 12;
            }
        } else {
            hour = this.fields[11];
        }
        long allMillis = (((long)hour * 60L + (long)minute) * 60L + (long)second) * 1000L + (long)millis;
        day = (int)((long)day + allMillis / 86400000L);
        millisInDay = (int)(allMillis % 86400000L);
        if (month < 0) {
            year += month / 12;
            if ((month %= 12) < 0) {
                month += 12;
                --year;
            }
        }
        if (month > 11) {
            year += month / 12;
            month %= 12;
        }
        month_days[1] = this.isLeapYear(year) ? 29 : 28;
        while (day <= 0) {
            if (month == 0) {
                month_days[1] = this.isLeapYear(--year) ? 29 : 28;
            }
            month = (month + 11) % 12;
            day += month_days[month];
        }
        while (day > month_days[month]) {
            day -= month_days[month];
            if ((month = (month + 1) % 12) != 0) continue;
            int n = month_days[1] = this.isLeapYear(++year) ? 29 : 28;
        }
        int dayOfYear = dayCount[month] + day - 1;
        if (this.isLeapYear(year) && month > 1) {
            ++dayOfYear;
        }
        relativeDay = (long)((relativeDay = (year - 1) * 365 + (year - 1 >> 2) + dayOfYear - 719162) + (gregFactor = (int)Math.floor((double)(year - 1) / 400.0) - (int)Math.floor((double)(year - 1) / 100.0))) * 60L * 60L * 24L * 1000L >= this.gregorianCutover ? (relativeDay += gregFactor) : (relativeDay -= 2);
        this.time = (long)relativeDay * 86400000L + (long)millisInDay;
        int weekday = (relativeDay + 5) % 7;
        if (weekday <= 0) {
            weekday += 7;
        }
        this.fields[7] = weekday;
        TimeZone zone = this.getTimeZone();
        int n = rawOffset = this.isSet[15] ? this.fields[15] : zone.getRawOffset();
        int dstOffset = this.isSet[16] ? this.fields[16] : zone.getOffset(year < 0 ? 0 : 1, year < 0 ? 1 - year : year, month, day, weekday, millisInDay) - zone.getRawOffset();
        this.time -= (long)(rawOffset + dstOffset);
        this.isTimeSet = true;
    }

    private long getLinearDay(int year, int dayOfYear, boolean gregorian) {
        long julianDay = (long)(year - 1) * 365L + (long)(year - 1 >> 2) + (long)(dayOfYear - 1) - 719162L;
        if (gregorian) {
            int gregOffset = (int)Math.floor((double)(year - 1) / 400.0) - (int)Math.floor((double)(year - 1) / 100.0);
            return julianDay + (long)gregOffset;
        }
        return julianDay -= 2L;
    }

    private void calculateDay(int[] fields, long day, boolean gregorian) {
        int leapday;
        long firstDayOfYear;
        int weekday = (int)(day + 5L) % 7;
        if (weekday <= 0) {
            weekday += 7;
        }
        fields[7] = weekday;
        int year = 1970 + (int)(gregorian ? (day - 100L) * 400L / 146097L : (day - 100L) * 4L / 1461L);
        if (day >= 0L) {
            ++year;
        }
        if (day < (firstDayOfYear = this.getLinearDay(year, 1, gregorian))) {
            firstDayOfYear = this.getLinearDay(--year, 1, gregorian);
        }
        fields[6] = (int)(day -= firstDayOfYear - 1L);
        if (year <= 0) {
            fields[0] = 0;
            fields[1] = 1 - year;
        } else {
            fields[0] = 1;
            fields[1] = year;
        }
        int n = leapday = this.isLeapYear(year) ? 1 : 0;
        if (day <= (long)(59 + leapday)) {
            fields[2] = (int)day / 32;
            fields[5] = (int)day - 31 * fields[2];
        } else {
            int scaledDay = ((int)day - leapday) * 5 + 8;
            fields[2] = scaledDay / 153;
            fields[5] = scaledDay % 153 / 5 + 1;
        }
    }

    protected synchronized void computeFields() {
        int hour;
        int minDays;
        boolean gregorian = this.time >= this.gregorianCutover;
        TimeZone zone = this.getTimeZone();
        this.fields[15] = zone.getRawOffset();
        long localTime = this.time + (long)this.fields[15];
        long day = localTime / 86400000L;
        int millisInDay = (int)(localTime % 86400000L);
        if (millisInDay < 0) {
            millisInDay += 86400000;
            --day;
        }
        this.calculateDay(this.fields, day, gregorian);
        this.fields[16] = zone.getOffset(this.fields[0], this.fields[1], this.fields[2], this.fields[5], this.fields[7], millisInDay) - this.fields[15];
        if ((millisInDay += this.fields[16]) >= 86400000) {
            millisInDay -= 86400000;
            this.calculateDay(this.fields, ++day, gregorian);
        }
        this.fields[8] = (this.fields[5] + 6) / 7;
        int relativeWeekday = (7 + this.fields[7] - this.getFirstDayOfWeek()) % 7;
        int relativeWeekdayOfFirst = (relativeWeekday - this.fields[5] + 1 + 35) % 7;
        int weekOfFirst = 7 - relativeWeekdayOfFirst >= (minDays = this.getMinimalDaysInFirstWeek()) ? 1 : 0;
        this.fields[4] = (this.fields[5] + relativeWeekdayOfFirst - 1) / 7 + weekOfFirst;
        int weekOfYear = (this.fields[6] - relativeWeekday + 6) / 7;
        int firstWeekday = (7 + this.getWeekDay(this.fields[1], minDays) - this.getFirstDayOfWeek()) % 7;
        if (minDays - firstWeekday < 1) {
            // empty if block
        }
        this.fields[3] = ++weekOfYear;
        int hourOfDay = millisInDay / 3600000;
        this.fields[9] = hourOfDay < 12 ? 0 : 1;
        this.fields[10] = hour = hourOfDay % 12;
        this.fields[11] = hourOfDay;
        this.fields[12] = (millisInDay %= 3600000) / 60000;
        this.fields[13] = (millisInDay %= 60000) / 1000;
        this.fields[14] = millisInDay % 1000;
        this.isSet[16] = true;
        this.isSet[15] = true;
        this.isSet[14] = true;
        this.isSet[13] = true;
        this.isSet[12] = true;
        this.isSet[11] = true;
        this.isSet[10] = true;
        this.isSet[9] = true;
        this.isSet[8] = true;
        this.isSet[7] = true;
        this.isSet[6] = true;
        this.isSet[5] = true;
        this.isSet[4] = true;
        this.isSet[3] = true;
        this.isSet[2] = true;
        this.isSet[1] = true;
        this.isSet[0] = true;
        this.areFieldsSet = true;
    }

    public int hashCode() {
        int val = (int)(this.gregorianCutover >>> 32 ^ this.gregorianCutover & 0xFFFFFFFFFFFFFFFFL);
        return super.hashCode() ^ val;
    }

    public boolean equals(Object o) {
        if (!(o instanceof GregorianCalendar)) {
            return false;
        }
        GregorianCalendar cal = (GregorianCalendar)o;
        return cal.gregorianCutover == this.gregorianCutover && super.equals(o);
    }

    public void add(int field, int amount) {
        switch (field) {
            case 1: {
                this.complete();
                this.fields[1] = this.fields[1] + amount;
                this.isTimeSet = false;
                break;
            }
            case 2: {
                int maxDay;
                this.complete();
                int months = this.fields[2] + amount;
                this.fields[1] = this.fields[1] + months / 12;
                this.fields[2] = months % 12;
                if (this.fields[2] < 0) {
                    this.fields[2] = this.fields[2] + 12;
                    this.fields[1] = this.fields[1] - 1;
                }
                if (this.fields[5] > (maxDay = this.getActualMaximum(5))) {
                    this.fields[5] = maxDay;
                }
                this.set(1, this.fields[1]);
                this.set(2, this.fields[2]);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                if (!this.isTimeSet) {
                    this.computeTime();
                }
                this.time += (long)amount * 86400000L;
                this.areFieldsSet = false;
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                if (!this.isTimeSet) {
                    this.computeTime();
                }
                this.time += (long)amount * 604800000L;
                this.areFieldsSet = false;
                break;
            }
            case 9: {
                if (!this.isTimeSet) {
                    this.computeTime();
                }
                this.time += (long)amount * 43200000L;
                this.areFieldsSet = false;
                break;
            }
            case 10: 
            case 11: {
                if (!this.isTimeSet) {
                    this.computeTime();
                }
                this.time += (long)amount * 3600000L;
                this.areFieldsSet = false;
                break;
            }
            case 12: {
                if (!this.isTimeSet) {
                    this.computeTime();
                }
                this.time += (long)amount * 60000L;
                this.areFieldsSet = false;
                break;
            }
            case 13: {
                if (!this.isTimeSet) {
                    this.computeTime();
                }
                this.time += (long)amount * 1000L;
                this.areFieldsSet = false;
                break;
            }
            case 14: {
                if (!this.isTimeSet) {
                    this.computeTime();
                }
                this.time += (long)amount;
                this.areFieldsSet = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid or unknown field");
            }
        }
    }

    public void roll(int field, boolean up) {
        this.roll(field, up ? 1 : -1);
    }

    private void cleanUpAfterRoll(int field, int delta) {
        switch (field) {
            case 0: 
            case 1: 
            case 2: {
                if (this.fields[5] > this.getActualMaximum(5)) {
                    this.fields[5] = this.getActualMaximum(5);
                }
                this.isTimeSet = false;
                this.isSet[4] = false;
                this.isSet[7] = false;
                this.isSet[8] = false;
                this.isSet[6] = false;
                this.isSet[3] = false;
                break;
            }
            case 5: {
                this.isSet[4] = false;
                this.isSet[7] = false;
                this.isSet[8] = false;
                this.isSet[6] = false;
                this.isSet[3] = false;
                this.time += (long)delta * 86400000L;
                break;
            }
            case 4: {
                this.isSet[5] = false;
                this.isSet[8] = false;
                this.isSet[6] = false;
                this.isSet[3] = false;
                this.time += (long)delta * 604800000L;
                break;
            }
            case 8: {
                this.isSet[5] = false;
                this.isSet[4] = false;
                this.isSet[6] = false;
                this.isSet[3] = false;
                this.time += (long)delta * 604800000L;
                break;
            }
            case 6: {
                this.isSet[2] = false;
                this.isSet[5] = false;
                this.isSet[4] = false;
                this.isSet[8] = false;
                this.isSet[7] = false;
                this.isSet[3] = false;
                this.time += (long)delta * 86400000L;
                break;
            }
            case 3: {
                this.isSet[2] = false;
                this.isSet[5] = false;
                this.isSet[4] = false;
                this.isSet[8] = false;
                this.isSet[6] = false;
                this.time += (long)delta * 604800000L;
                break;
            }
            case 9: {
                this.isSet[11] = false;
                this.time += (long)delta * 43200000L;
                break;
            }
            case 10: {
                this.isSet[11] = false;
                this.time += (long)delta * 3600000L;
                break;
            }
            case 11: {
                this.isSet[10] = false;
                this.isSet[9] = false;
                this.time += (long)delta * 3600000L;
                break;
            }
            case 12: {
                this.time += (long)delta * 60000L;
                break;
            }
            case 13: {
                this.time += (long)delta * 1000L;
                break;
            }
            case 14: {
                this.time += (long)delta;
            }
        }
    }

    public void roll(int field, int amount) {
        switch (field) {
            case 7: {
                this.add(field, amount);
                return;
            }
            case 15: 
            case 16: {
                throw new IllegalArgumentException("Can't roll time zone");
            }
        }
        this.complete();
        int min = this.getActualMinimum(field);
        int range = this.getActualMaximum(field) - min + 1;
        int oldval = this.fields[field];
        int newval = (oldval - min + range + amount) % range + min;
        if (newval < min) {
            newval += range;
        }
        this.fields[field] = newval;
        this.cleanUpAfterRoll(field, newval - oldval);
    }

    public int getMinimum(int field) {
        return minimums[field];
    }

    public int getMaximum(int field) {
        return maximums[field];
    }

    public int getGreatestMinimum(int field) {
        if (field == 3) {
            return 1;
        }
        return minimums[field];
    }

    public int getLeastMaximum(int field) {
        switch (field) {
            case 3: {
                return 52;
            }
            case 5: {
                return 28;
            }
            case 6: {
                return 365;
            }
            case 4: 
            case 8: {
                return 4;
            }
        }
        return maximums[field];
    }

    public int getActualMinimum(int field) {
        if (field == 3) {
            int year;
            int weekday;
            int min = this.getMinimalDaysInFirstWeek();
            if (min == 0) {
                return 1;
            }
            if (!(this.areFieldsSet && this.isSet[0] && this.isSet[1])) {
                this.complete();
            }
            if ((7 + (weekday = this.getWeekDay(year = this.fields[0] == 1 ? this.fields[1] : 1 - this.fields[1], min)) - this.getFirstDayOfWeek()) % 7 >= min - 1) {
                return 1;
            }
            return 0;
        }
        return minimums[field];
    }

    public int getActualMaximum(int field) {
        switch (field) {
            case 3: {
                int firstWeekday;
                if (!(this.areFieldsSet && this.isSet[0] && this.isSet[1])) {
                    this.complete();
                }
                int year = this.fields[0] == 1 ? this.fields[1] : 1 - this.fields[1];
                int lastDay = this.isLeapYear(year) ? 366 : 365;
                int weekday = this.getWeekDay(year, lastDay);
                int week = (lastDay + 6 - (7 + weekday - this.getFirstDayOfWeek()) % 7) / 7;
                int minimalDays = this.getMinimalDaysInFirstWeek();
                if (minimalDays - (7 + (firstWeekday = this.getWeekDay(year, minimalDays)) - this.getFirstDayOfWeek()) % 7 < 1) {
                    return week + 1;
                }
            }
            case 5: {
                int month;
                if (!this.areFieldsSet || !this.isSet[2]) {
                    this.complete();
                }
                if ((month = this.fields[2]) == 1) {
                    if (!this.isSet[1] || !this.isSet[0]) {
                        this.complete();
                    }
                    int year = this.fields[0] == 1 ? this.fields[1] : 1 - this.fields[1];
                    return this.isLeapYear(year) ? 29 : 28;
                }
                if (month < 7) {
                    return 31 - (month & 1);
                }
                return 30 + (month & 1);
            }
            case 6: {
                if (!(this.areFieldsSet && this.isSet[0] && this.isSet[1])) {
                    this.complete();
                }
                int year = this.fields[0] == 1 ? this.fields[1] : 1 - this.fields[1];
                return this.isLeapYear(year) ? 366 : 365;
            }
            case 8: {
                int daysInMonth = this.getActualMaximum(5);
                return (daysInMonth - (this.fields[5] - 1) % 7 + 6) / 7;
            }
            case 4: {
                int daysInMonth = this.getActualMaximum(5);
                int weekday = (daysInMonth - this.fields[5] + this.fields[7] - 1) % 7 + 1;
                return (daysInMonth + 6 - (7 + weekday - this.getFirstDayOfWeek()) % 7) / 7;
            }
        }
        return maximums[field];
    }
}

