/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;
import java.util.HashSet;

public final class AccessControlContext {
    private final ProtectionDomain[] protectionDomains;
    private final DomainCombiner combiner;

    public AccessControlContext(ProtectionDomain[] context) {
        HashSet<ProtectionDomain> domains = new HashSet<ProtectionDomain>(context.length);
        int i = 0;
        while (i < context.length) {
            domains.add(context[i]);
            ++i;
        }
        this.protectionDomains = domains.toArray(new ProtectionDomain[domains.size()]);
        this.combiner = null;
    }

    public AccessControlContext(AccessControlContext acc, DomainCombiner combiner) {
        AccessControlContext acc2 = null;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            SecurityPermission perm = new SecurityPermission("createAccessControlContext");
            if (sm.getClass() == SecurityManager.class) {
                acc2 = AccessController.getContext();
                acc2.checkPermission(perm);
            } else {
                sm.checkPermission(perm);
            }
        }
        if (acc2 == null) {
            acc2 = AccessController.getContext();
        }
        this.protectionDomains = combiner.combine(acc2.protectionDomains, acc.protectionDomains);
        this.combiner = combiner;
    }

    AccessControlContext(ProtectionDomain[] domains, AccessControlContext acc, DomainCombiner combiner) {
        this.protectionDomains = combiner.combine(domains, acc.protectionDomains);
        this.combiner = combiner;
    }

    public DomainCombiner getDomainCombiner() {
        return this.combiner;
    }

    public void checkPermission(Permission perm) throws AccessControlException {
        if (this.protectionDomains.length == 0) {
            throw new AccessControlException("permission " + perm + " not granted: no protection domains");
        }
        int i = 0;
        while (i < this.protectionDomains.length) {
            ProtectionDomain domain = this.protectionDomains[i];
            if (!domain.implies(perm)) {
                throw new AccessControlException("permission " + perm + " not granted: " + domain + " does not imply it.");
            }
            ++i;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof AccessControlContext) {
            AccessControlContext acc = (AccessControlContext)obj;
            if (acc.protectionDomains.length != this.protectionDomains.length) {
                return false;
            }
            int i = 0;
            while (i < this.protectionDomains.length) {
                int j = 0;
                while (j < acc.protectionDomains.length) {
                    if (acc.protectionDomains[j].equals(this.protectionDomains[i])) break;
                    ++j;
                }
                if (j == acc.protectionDomains.length) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int h = 0;
        int i = 0;
        while (i < this.protectionDomains.length) {
            h ^= this.protectionDomains[i].hashCode();
            ++i;
        }
        return h;
    }

    ProtectionDomain[] getProtectionDomains() {
        return this.protectionDomains;
    }
}

